/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.util;

import io.sf.carte.doc.dom.CSSDOMImplementation;
import io.sf.carte.doc.style.css.nsac.Parser;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheet;
import io.sf.carte.doc.style.css.om.AbstractCSSStyleSheetFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.stream.Stream;

public class Minify {
    public static void main(String[] args) throws URISyntaxException, IOException {
        Minify.main(args, System.out, System.err);
    }

    static void main(String[] args, PrintStream out, PrintStream err) throws URISyntaxException, IOException {
        if (args == null || args.length != 1) {
            Minify.printUsage(err);
            return;
        }
        URI uri = new URI(args[0]);
        Path filePath = Paths.get(uri);
        out.print(Minify.minifyCSS(filePath));
    }

    private static void printUsage(PrintStream err) {
        err.println("Usage: " + Minify.class.getName() + " <style-sheet-uri>");
    }

    public static String minifyCSS(String css) {
        AbstractCSSStyleSheet sheet = Minify.createStyleSheet();
        try {
            if (sheet.parseStyleSheet(new StringReader(css), (short)0)) {
                return sheet.toMinifiedString();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return css;
    }

    public static String minifyCSS(Path cssPath) throws IOException {
        AbstractCSSStyleSheet sheet = Minify.createStyleSheet();
        try (BufferedReader cssReader = Files.newBufferedReader(cssPath, StandardCharsets.UTF_8);){
            if (sheet.parseStyleSheet(cssReader, (short)0)) {
                String string = sheet.toMinifiedString();
                return string;
            }
        }
        StringBuilder builder = new StringBuilder(256);
        try (Stream<String> stream = Files.lines(cssPath, StandardCharsets.UTF_8);){
            stream.forEach(s -> builder.append((String)s).append(' '));
        }
        return builder.toString();
    }

    private static AbstractCSSStyleSheet createStyleSheet() {
        CSSDOMImplementation cssFactory = new CSSDOMImplementation(EnumSet.allOf(Parser.Flag.class));
        return ((AbstractCSSStyleSheetFactory)cssFactory).createStyleSheet(null, null);
    }
}

