/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.dom;

import io.sf.carte.doc.dom.AbstractDOMNode;
import io.sf.carte.doc.dom.ClassnameElementList;
import io.sf.carte.doc.dom.DOMElement;
import io.sf.carte.doc.dom.DOMElementLinkedList;
import io.sf.carte.doc.dom.DOMNode;
import io.sf.carte.doc.dom.ElementList;
import io.sf.carte.doc.dom.EmptyElementList;
import io.sf.carte.doc.dom.LinkedNodeList;
import io.sf.carte.doc.dom.NonDocumentTypeChildNode;
import io.sf.carte.doc.dom.TagnameElementList;
import io.sf.carte.doc.dom.TagnameElementListNS;
import io.sf.carte.doc.style.css.CSSDocument;
import io.sf.carte.doc.style.css.nsac.CSSNamespaceParseException;
import io.sf.carte.doc.style.css.nsac.SelectorList;
import io.sf.carte.doc.style.css.parser.CSSParser;
import java.io.StringReader;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Locale;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.w3c.dom.DOMException;
import org.w3c.dom.Node;

abstract class NDTNode
extends AbstractDOMNode
implements NonDocumentTypeChildNode {
    private static final long serialVersionUID = 2L;

    NDTNode(short nodeType) {
        super(nodeType);
    }

    public DOMElement getFirstElementChild() {
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            return (DOMElement)node;
        }
        return null;
    }

    public DOMElement getLastElementChild() {
        for (Node node = this.getLastChild(); node != null; node = node.getPreviousSibling()) {
            if (node.getNodeType() != 1) continue;
            return (DOMElement)node;
        }
        return null;
    }

    public int getChildElementCount() {
        int count = 0;
        for (Node node = this.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean hasChildNodes() {
        return !this.getNodeList().isEmpty();
    }

    @Override
    public DOMElement getPreviousElementSibling() {
        Node next;
        for (next = this.getPreviousSibling(); next != null && next.getNodeType() != 1; next = next.getPreviousSibling()) {
        }
        return (DOMElement)next;
    }

    @Override
    public DOMElement getNextElementSibling() {
        Node next;
        for (next = this.getNextSibling(); next != null && next.getNodeType() != 1; next = next.getNextSibling()) {
        }
        return (DOMElement)next;
    }

    public DOMNode prependChild(Node newChild) throws DOMException {
        AbstractDOMNode.RawNodeList nl = this.getNodeList();
        if (nl.isEmpty()) {
            return this.appendChild(newChild);
        }
        AbstractDOMNode added = (AbstractDOMNode)newChild;
        if (added.getNodeType() != 11) {
            this.preAddChild(added);
            AbstractDOMNode refChild = nl.getFirst();
            nl.insertBefore(added, refChild);
            this.postAddChild(added);
        } else {
            this.prependDocumentFragment(added);
        }
        return added;
    }

    private void prependDocumentFragment(Node newChild) {
        Node added = newChild.getLastChild();
        while (added != null) {
            Node next = added.getPreviousSibling();
            this.prependChild(added);
            added = next;
        }
    }

    static DOMElement querySelector(String selectors, Node firstChild) {
        SelectorList selist = NDTNode.parseSelectors(selectors);
        return NDTNode.matchQuerySelector(selist, firstChild);
    }

    private static DOMElement matchQuerySelector(SelectorList selist, Node firstChild) {
        for (Node node = firstChild; node != null; node = node.getNextSibling()) {
            if (node.getNodeType() != 1) continue;
            DOMElement element = (DOMElement)node;
            if (element.matches(selist, null)) {
                return element;
            }
            DOMElement elt = NDTNode.matchQuerySelector(selist, element.getFirstChild());
            if (elt == null) continue;
            return elt;
        }
        return null;
    }

    static ElementList querySelectorAll(String selectors, Node firstChild) {
        SelectorList selist = NDTNode.parseSelectors(selectors);
        DOMElementLinkedList list = new DOMElementLinkedList();
        list.fillQuerySelectorList(selist, firstChild);
        return list;
    }

    private static SelectorList parseSelectors(String selectors) throws DOMException {
        SelectorList selist;
        CSSParser parser = new CSSParser();
        try {
            selist = parser.parseSelectors(new StringReader(selectors));
        }
        catch (CSSNamespaceParseException e) {
            throw NDTNode.createDOMException((short)14, "Namespaces inside the selectors are not supported: " + selectors, e);
        }
        catch (Exception e) {
            throw NDTNode.createDOMException((short)12, "Unable to parse selector in: " + selectors, e);
        }
        return selist;
    }

    private static DOMException createDOMException(short type, String message, Exception cause) {
        DOMException ex = new DOMException(type, message);
        ex.initCause(cause);
        return ex;
    }

    class DefaultChildNodeList
    extends LinkedNodeList
    implements AbstractDOMNode.ChildCollections {
        private static final long serialVersionUID = 1L;
        private WeakReference<ElementList> childElementRef = null;

        DefaultChildNodeList() {
        }

        @Override
        public ElementList getChildren() {
            ElementList list = null;
            if (this.childElementRef != null) {
                list = (ElementList)this.childElementRef.get();
            }
            if (list == null) {
                list = new ChildElementList();
                this.childElementRef = new WeakReference<ElementList>(list);
            }
            return list;
        }

        @Override
        public ElementList getElementsByTagNameNS(String namespaceURI, String localName) {
            boolean matchAll = "*".equals(localName);
            boolean matchAllNS = "*".equals(namespaceURI);
            if (namespaceURI != null && !matchAllNS) {
                namespaceURI = namespaceURI.intern();
            }
            TagnameElementListNS list = new TagnameElementListNS(NDTNode.this, localName, namespaceURI, matchAll, matchAllNS);
            return list;
        }

        @Override
        public ElementList getElementsByTagName(String name, boolean isHTML) {
            if (name == null) {
                return EmptyElementList.getInstance();
            }
            boolean matchAll = "*".equals(name);
            String prefix = null;
            int idx = name.indexOf(58);
            if (idx != -1) {
                prefix = name.substring(0, idx);
                if (++idx == name.length()) {
                    return EmptyElementList.getInstance();
                }
                name = name.substring(idx);
            }
            TagnameElementList list = new TagnameElementList(NDTNode.this, name, prefix, matchAll, isHTML);
            return list;
        }

        @Override
        public ElementList getElementsByClassName(String names, CSSDocument.ComplianceMode mode) {
            if (names == null) {
                return EmptyElementList.getInstance();
            }
            names = names.trim();
            if (mode == CSSDocument.ComplianceMode.QUIRKS) {
                names = names.toLowerCase(Locale.ROOT);
            }
            TreeSet<String> sorted = new TreeSet<String>();
            if (names.indexOf(32) != -1) {
                names = this.sortClassNames(names, sorted);
            } else {
                sorted.add(names);
            }
            ClassnameElementList list = new ClassnameElementList(NDTNode.this, sorted);
            return list;
        }

        private String sortClassNames(String names, SortedSet<String> sorted) {
            StringTokenizer st = new StringTokenizer(names);
            while (st.hasMoreTokens()) {
                sorted.add(st.nextToken());
            }
            StringBuilder buf = new StringBuilder(names.length());
            Iterator it = sorted.iterator();
            buf.append((String)it.next());
            while (it.hasNext()) {
                buf.append(' ').append((String)it.next());
            }
            return buf.toString();
        }

        @Override
        void postRemoveChild(AbstractDOMNode removed) {
            NDTNode.this.postRemoveChild(removed);
        }

        @Override
        void preAddChild(Node node) {
            NDTNode.this.preAddChild(node);
        }

        @Override
        void postAddChild(AbstractDOMNode node) {
            NDTNode.this.postAddChild(node);
        }

        @Override
        void replaceChild(Node newChild, Node oldChild) {
            NDTNode.this.replaceChild(newChild, oldChild);
        }
    }

    class ChildElementList
    implements ElementList {
        ChildElementList() {
        }

        @Override
        public boolean contains(Node node) {
            return NDTNode.this.getNodeList().contains(node);
        }

        @Override
        public DOMElement item(int index) {
            int idx = 0;
            for (Node node = NDTNode.this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                if (idx == index) {
                    return (DOMElement)node;
                }
                ++idx;
            }
            return null;
        }

        @Override
        public Iterator<DOMElement> iterator() {
            return NDTNode.this.getNodeList().elementIterator();
        }

        @Override
        public int getLength() {
            return NDTNode.this.getChildElementCount();
        }

        @Override
        public boolean isEmpty() {
            return NDTNode.this.getFirstElementChild() == null;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(this.getLength() * 32 + 40);
            for (Node node = NDTNode.this.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() != 1) continue;
                buf.append(node.toString());
            }
            return buf.toString();
        }
    }
}

