/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.doc.style.css.om;

import io.sf.carte.doc.style.css.StyleDeclarationErrorHandler;
import io.sf.carte.doc.style.css.StyleFormattingContext;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.om.BaseCSSDeclarationRule;
import io.sf.carte.doc.style.css.om.BaseCSSStyleDeclaration;
import io.sf.carte.doc.style.css.om.CompatDeclarationSet;
import io.sf.carte.doc.style.css.om.ShorthandValue;
import io.sf.carte.doc.style.css.property.CSSPropertyValueException;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.util.SimpleWriter;
import java.io.IOException;
import java.util.LinkedList;
import org.w3c.dom.DOMException;

class CompatStyleDeclaration
extends BaseCSSStyleDeclaration {
    private static final long serialVersionUID = 1L;
    private final CompatDeclarationSet compatSet;

    protected CompatStyleDeclaration(BaseCSSDeclarationRule baseCSSDeclarationRule) {
        super(baseCSSDeclarationRule);
        this.compatSet = new CompatDeclarationSet();
    }

    protected CompatStyleDeclaration(CompatStyleDeclaration compatStyleDeclaration) {
        super(compatStyleDeclaration);
        this.compatSet = compatStyleDeclaration.compatSet.clone();
    }

    @Override
    protected void setLonghandProperty(String string, LexicalUnit lexicalUnit, boolean bl) throws DOMException {
        if (lexicalUnit.getLexicalUnitType() != LexicalUnit.LexicalType.COMPAT_PRIO) {
            super.setLonghandProperty(string, lexicalUnit, bl);
        } else {
            StyleValue styleValue;
            ValueFactory valueFactory = this.getValueFactory();
            try {
                styleValue = valueFactory.createCSSValue(lexicalUnit, this);
            }
            catch (DOMException dOMException) {
                StyleDeclarationErrorHandler styleDeclarationErrorHandler = this.getStyleDeclarationErrorHandler();
                if (styleDeclarationErrorHandler != null) {
                    CSSPropertyValueException cSSPropertyValueException = new CSSPropertyValueException("Wrong value for " + string, dOMException);
                    cSSPropertyValueException.setValueText(CompatStyleDeclaration.lexicalUnitToString(lexicalUnit));
                    styleDeclarationErrorHandler.wrongValue(string, cSSPropertyValueException);
                }
                throw dOMException;
            }
            this.compatLonghand(string, styleValue, true, this.isPropertySet(string));
        }
    }

    @Override
    protected boolean addOverrideProperty(String string, StyleValue styleValue, String string2) {
        return this.addCompatProperty(string, styleValue, string2);
    }

    @Override
    protected void compatLonghand(String string, StyleValue styleValue, boolean bl, boolean bl2) {
        this.compatSet.setCompatLonghand(string, styleValue, bl, bl2);
    }

    @Override
    protected void shorthandError(String string, LexicalUnit lexicalUnit, boolean bl, LinkedList<String> linkedList, DOMException dOMException) {
        if (this.compatSet.setCompatShorthand(string, lexicalUnit, bl, linkedList)) {
            this.compatWarning(string, lexicalUnit, bl);
            return;
        }
        super.shorthandError(string, lexicalUnit, bl, linkedList, dOMException);
    }

    @Override
    protected void appendShorthandMinifiedCssText(StringBuilder stringBuilder, String string, ShorthandValue shorthandValue) {
        ShorthandValue shorthandValue2;
        boolean bl = this.compatSet.isCompatShorthand(string);
        if (!bl && !shorthandValue.isImportant() && (shorthandValue2 = this.compatSet.getNonOvCompatShorthand(string)) != null) {
            CompatDeclarationSet.appendIEPrioCharShorthandMinifiedCssText(stringBuilder, string, shorthandValue2);
        }
        super.appendShorthandMinifiedCssText(stringBuilder, string, shorthandValue);
        if (bl) {
            shorthandValue2 = this.compatSet.getCompatShorthand(string);
            if (!shorthandValue2.isPriorityCompat()) {
                super.appendShorthandMinifiedCssText(stringBuilder, string, shorthandValue2);
            } else {
                CompatDeclarationSet.appendIEPrioCharShorthandMinifiedCssText(stringBuilder, string, shorthandValue2);
            }
        }
    }

    @Override
    protected void appendLonghandMinifiedCssText(StringBuilder stringBuilder, String string, StyleValue styleValue, boolean bl) {
        StyleValue styleValue2;
        boolean bl2 = this.compatSet.isCompatLonghand(string);
        if (!bl2 && !bl && (styleValue2 = this.compatSet.getNonOvCompatLonghand(string)) != null) {
            super.appendLonghandMinifiedCssText(stringBuilder, string, styleValue2, true);
            stringBuilder.append('!').append(';');
        }
        super.appendLonghandMinifiedCssText(stringBuilder, string, styleValue, bl);
        if (bl2) {
            stringBuilder.append(';');
            styleValue2 = this.compatSet.getCompatLonghand(string);
            super.appendLonghandMinifiedCssText(stringBuilder, string, styleValue2, this.compatSet.isImportantCompatLonghand(string));
            if (CompatDeclarationSet.isPriorityCompat(styleValue2)) {
                stringBuilder.append('!');
            }
        }
    }

    @Override
    protected void writeShorthandCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, String string, ShorthandValue shorthandValue) throws IOException {
        ShorthandValue shorthandValue2;
        boolean bl = this.compatSet.isCompatShorthand(string);
        if (!bl && !shorthandValue.isImportant() && (shorthandValue2 = this.compatSet.getNonOvCompatShorthand(string)) != null) {
            styleFormattingContext.startPropertyDeclaration(simpleWriter);
            CompatDeclarationSet.writeIEPrioCharShorthandCssText(simpleWriter, styleFormattingContext, string, shorthandValue2);
            styleFormattingContext.endPropertyDeclaration(simpleWriter);
        }
        super.writeShorthandCssText(simpleWriter, styleFormattingContext, string, shorthandValue);
        if (bl) {
            shorthandValue2 = this.compatSet.getCompatShorthand(string);
            if (!shorthandValue2.isPriorityCompat()) {
                super.writeShorthandCssText(simpleWriter, styleFormattingContext, string, shorthandValue2);
            } else {
                styleFormattingContext.startPropertyDeclaration(simpleWriter);
                CompatDeclarationSet.writeIEPrioCharShorthandCssText(simpleWriter, styleFormattingContext, string, shorthandValue2);
                styleFormattingContext.endPropertyDeclaration(simpleWriter);
            }
        }
    }

    @Override
    protected void writeLonghandCssText(SimpleWriter simpleWriter, StyleFormattingContext styleFormattingContext, String string, StyleValue styleValue, boolean bl) throws IOException {
        StyleValue styleValue2;
        boolean bl2 = this.compatSet.isCompatLonghand(string);
        if (!bl2 && !bl && (styleValue2 = this.compatSet.getNonOvCompatLonghand(string)) != null) {
            styleFormattingContext.startPropertyDeclaration(simpleWriter);
            CompatDeclarationSet.writeIEPrioCharLonghandCssText(simpleWriter, styleFormattingContext, string, styleValue2);
            styleFormattingContext.endPropertyDeclaration(simpleWriter);
        }
        super.writeLonghandCssText(simpleWriter, styleFormattingContext, string, styleValue, bl);
        if (bl2) {
            styleValue2 = this.compatSet.getCompatLonghand(string);
            if (!CompatDeclarationSet.isPriorityCompat(styleValue2)) {
                super.writeLonghandCssText(simpleWriter, styleFormattingContext, string, styleValue2, this.compatSet.isImportantCompatLonghand(string));
            } else {
                styleFormattingContext.startPropertyDeclaration(simpleWriter);
                CompatDeclarationSet.writeIEPrioCharLonghandCssText(simpleWriter, styleFormattingContext, string, styleValue2);
                styleFormattingContext.endPropertyDeclaration(simpleWriter);
            }
        }
    }

    @Override
    void clear() {
        super.clear();
        this.compatSet.clear();
    }

    @Override
    public CompatStyleDeclaration clone() {
        return new CompatStyleDeclaration(this);
    }
}

