/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.css.engine.value;

import io.sf.carte.doc.style.css.CSSExpressionValue;
import io.sf.carte.doc.style.css.CSSMathFunctionValue;
import io.sf.carte.doc.style.css.CSSValue;
import io.sf.carte.doc.style.css.CSSValueSyntax;
import io.sf.carte.doc.style.css.nsac.LexicalUnit;
import io.sf.carte.doc.style.css.parser.SyntaxParser;
import io.sf.carte.doc.style.css.property.StyleValue;
import io.sf.carte.doc.style.css.property.ValueFactory;
import io.sf.carte.echosvg.css.engine.CSSEngine;
import io.sf.carte.echosvg.css.engine.CSSEngineUserAgent;
import io.sf.carte.echosvg.css.engine.CSSStylableElement;
import io.sf.carte.echosvg.css.engine.StyleMap;
import io.sf.carte.echosvg.css.engine.value.AbstractValueFactory;
import io.sf.carte.echosvg.css.engine.value.CSSProxyValueException;
import io.sf.carte.echosvg.css.engine.value.CalcValue;
import io.sf.carte.echosvg.css.engine.value.FloatValue;
import io.sf.carte.echosvg.css.engine.value.LexicalValue;
import io.sf.carte.echosvg.css.engine.value.MathFunctionValue;
import io.sf.carte.echosvg.css.engine.value.Messages;
import io.sf.carte.echosvg.css.engine.value.NumericDelegateValue;
import io.sf.carte.echosvg.css.engine.value.URIValue;
import io.sf.carte.echosvg.css.engine.value.Value;
import io.sf.carte.echosvg.css.engine.value.ValueManager;
import org.w3c.css.om.unit.CSSUnit;
import org.w3c.dom.DOMException;

public abstract class AbstractValueManager
extends AbstractValueFactory
implements ValueManager {
    @Override
    public Value createFloatValue(short s, float f) throws DOMException {
        throw this.createDOMException();
    }

    @Override
    public Value createStringValue(CSSValue.Type type, String string, CSSEngine cSSEngine) throws DOMException {
        throw this.createDOMException();
    }

    protected Value createLexicalValue(LexicalUnit lexicalUnit) throws CSSProxyValueException {
        if (lexicalUnit.getPreviousLexicalUnit() != null || lexicalUnit.isParameter()) {
            throw new CSSProxyValueException();
        }
        return new LexicalValue(lexicalUnit);
    }

    protected Value createCalc(LexicalUnit lexicalUnit) throws DOMException {
        ValueFactory valueFactory = new ValueFactory();
        LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit() != null ? lexicalUnit.shallowClone() : lexicalUnit;
        StyleValue styleValue = valueFactory.createCSSValue(lexicalUnit2);
        CSSValue.Type type = styleValue.getPrimitiveType();
        if (type != CSSValue.Type.EXPRESSION) {
            if (type == CSSValue.Type.LEXICAL) {
                if (lexicalUnit2.getPreviousLexicalUnit() != null || lexicalUnit2.isParameter()) {
                    throw new CSSProxyValueException();
                }
                return this.createLexicalValue(lexicalUnit2);
            }
            this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
        CalcValue calcValue = new CalcValue((CSSExpressionValue)styleValue){
            private static final long serialVersionUID = 1L;

            @Override
            protected FloatValue absoluteValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, FloatValue floatValue) {
                return (FloatValue)AbstractValueManager.this.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, floatValue);
            }
        };
        return calcValue;
    }

    protected Value createMathFunction(LexicalUnit lexicalUnit, String string) throws DOMException {
        CSSValueSyntax cSSValueSyntax;
        MathFunctionValue mathFunctionValue;
        ValueFactory valueFactory = new ValueFactory();
        LexicalUnit lexicalUnit2 = lexicalUnit.getNextLexicalUnit() != null ? lexicalUnit.shallowClone() : lexicalUnit;
        StyleValue styleValue = valueFactory.createCSSValue(lexicalUnit2);
        CSSValue.Type type = styleValue.getPrimitiveType();
        if (type != CSSValue.Type.MATH_FUNCTION) {
            if (type == CSSValue.Type.LEXICAL) {
                if (lexicalUnit2.getPreviousLexicalUnit() != null || lexicalUnit2.isParameter()) {
                    throw new CSSProxyValueException();
                }
                return this.createLexicalValue(lexicalUnit2);
            }
            this.createInvalidLexicalUnitDOMException(lexicalUnit.getLexicalUnitType());
        }
        if ((mathFunctionValue = new MathFunctionValue((CSSMathFunctionValue)styleValue){
            private static final long serialVersionUID = 1L;

            @Override
            protected FloatValue absoluteValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, FloatValue floatValue) {
                return (FloatValue)AbstractValueManager.this.computeValue(cSSStylableElement, string, cSSEngine, n, styleMap, floatValue);
            }
        }).matches(cSSValueSyntax = new SyntaxParser().parseSyntax(string)) == CSSValueSyntax.Match.FALSE) {
            throw this.createDOMException(mathFunctionValue);
        }
        return mathFunctionValue;
    }

    @Override
    public Value computeValue(CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, Value value) {
        if (value.getPrimitiveType() == CSSValue.Type.URI) {
            if (styleMap.isAttrTainted(n)) {
                CSSEngineUserAgent cSSEngineUserAgent = cSSEngine.getCSSEngineUserAgent();
                if (cSSEngineUserAgent != null) {
                    cSSEngineUserAgent.displayMessage("attr()-tainted value: " + value.getCssText());
                }
                return null;
            }
            String string2 = value.getURIValue();
            return new URIValue(string2, string2);
        }
        return value;
    }

    protected Value evaluateMath(NumericDelegateValue<?> numericDelegateValue, CSSStylableElement cSSStylableElement, String string, CSSEngine cSSEngine, int n, StyleMap styleMap, short s) throws DOMException {
        return numericDelegateValue.evaluate(cSSStylableElement, string, cSSEngine, n, styleMap, s);
    }

    protected float lengthValue(Value value) {
        short s = value.getUnitType();
        if (!CSSUnit.isLengthUnitType((short)s) && s != 0) {
            throw this.createDOMException(value);
        }
        return value.getFloatValue();
    }

    protected DOMException createDOMException(Value value) {
        Object[] objectArray = new Object[]{value.getCssText(), value.getUnitType()};
        String string = Messages.formatMessage("invalid.value.access", objectArray);
        return new DOMException(15, string);
    }
}

