/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.util;

import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;

public class SoftDoublyIndexedTable<K, L> {
    protected static final int INITIAL_CAPACITY = 11;
    protected Entry[] table;
    protected int count;
    protected ReferenceQueue<Object> referenceQueue = new ReferenceQueue();

    public SoftDoublyIndexedTable() {
        this.table = new Entry[11];
    }

    public SoftDoublyIndexedTable(int n) {
        this.table = new Entry[n];
    }

    public int size() {
        return this.count;
    }

    public Object get(K k, L l) {
        int n = this.hashCode(k, l) & Integer.MAX_VALUE;
        int n2 = n % this.table.length;
        Entry entry = this.table[n2];
        while (entry != null) {
            if (entry.hash == n && entry.match(k, l)) {
                return entry.get();
            }
            entry = entry.next;
        }
        return null;
    }

    public Object put(K k, L l, Object object) {
        int n;
        this.removeClearedEntries();
        int n2 = this.hashCode(k, l) & Integer.MAX_VALUE;
        int n3 = n2 % this.table.length;
        Entry entry = this.table[n3];
        if (entry != null) {
            if (entry.hash == n2 && entry.match(k, l)) {
                Object t = entry.get();
                this.table[n3] = new Entry(n2, k, l, object, this.referenceQueue, entry.next);
                return t;
            }
            Entry entry2 = entry;
            entry = entry.next;
            while (entry != null) {
                if (entry.hash == n2 && entry.match(k, l)) {
                    Object t = entry.get();
                    entry2.next = entry = new Entry(n2, k, l, object, this.referenceQueue, entry.next);
                    return t;
                }
                entry2 = entry;
                entry = entry.next;
            }
        }
        if (this.count++ >= (n = this.table.length) - (n >> 2)) {
            this.rehash();
            n3 = n2 % this.table.length;
        }
        this.table[n3] = new Entry(n2, k, l, object, this.referenceQueue, this.table[n3]);
        return null;
    }

    public void clear() {
        this.table = new Entry[11];
        this.count = 0;
        this.referenceQueue = new ReferenceQueue();
    }

    protected void rehash() {
        Entry[] entryArray = this.table;
        this.table = new Entry[entryArray.length * 2 + 1];
        for (int i = entryArray.length - 1; i >= 0; --i) {
            Entry entry = entryArray[i];
            while (entry != null) {
                Entry entry2 = entry;
                entry = entry.next;
                int n = entry2.hash % this.table.length;
                entry2.next = this.table[n];
                this.table[n] = entry2;
            }
        }
    }

    protected int hashCode(Object object, Object object2) {
        int n = object == null ? 0 : object.hashCode();
        return n ^ (object2 == null ? 0 : object2.hashCode());
    }

    protected void removeClearedEntries() {
        Entry entry;
        while ((entry = (Entry)this.referenceQueue.poll()) != null) {
            int n = entry.hash % this.table.length;
            Entry entry2 = this.table[n];
            if (entry2 == entry) {
                this.table[n] = entry.next;
            } else {
                while (entry2 != null) {
                    Entry entry3 = entry2.next;
                    if (entry3 == entry) {
                        entry2.next = entry.next;
                        break;
                    }
                    entry2 = entry3;
                }
            }
            --this.count;
        }
    }

    private static class Entry
    extends SoftReference<Object> {
        public int hash;
        public Object key1;
        public Object key2;
        public Entry next;

        public Entry(int n, Object object, Object object2, Object object3, ReferenceQueue<Object> referenceQueue, Entry entry) {
            super(object3, referenceQueue);
            this.hash = n;
            this.key1 = object;
            this.key2 = object2;
            this.next = entry;
        }

        public boolean match(Object object, Object object2) {
            if (this.key1 != null ? !this.key1.equals(object) : object != null) {
                return false;
            }
            if (this.key2 != null) {
                return this.key2.equals(object2);
            }
            return object2 == null;
        }
    }
}

