/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.map;

import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.Window;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.freeplane.api.ChildNodesAlignment;
import org.freeplane.api.ChildNodesLayout;
import org.freeplane.api.ChildrenSides;
import org.freeplane.api.Dash;
import org.freeplane.api.HorizontalTextAlignment;
import org.freeplane.api.LayoutOrientation;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.IUserInputListenerFactory;
import org.freeplane.core.ui.components.IconListComponent;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.ObjectRule;
import org.freeplane.features.attribute.AttributeController;
import org.freeplane.features.attribute.NodeAttributeTableModel;
import org.freeplane.features.cloud.CloudController;
import org.freeplane.features.cloud.CloudModel;
import org.freeplane.features.edge.EdgeController;
import org.freeplane.features.edge.EdgeStyle;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.filter.FilterController;
import org.freeplane.features.filter.hidden.NodeVisibility;
import org.freeplane.features.filter.hidden.NodeVisibilityConfiguration;
import org.freeplane.features.highlight.HighlightController;
import org.freeplane.features.highlight.NodeHighlighter;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.mindmapmode.MIconController;
import org.freeplane.features.layout.LayoutController;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.FreeNode;
import org.freeplane.features.map.HistoryInformationModel;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodelocation.LocationController;
import org.freeplane.features.nodelocation.LocationModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.NodeStyleShape;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.MapViewLayout;
import org.freeplane.features.text.TextController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewIconListComponent;
import org.freeplane.view.swing.map.NodeViewFactory;
import org.freeplane.view.swing.map.NodeViewLayoutHelper;
import org.freeplane.view.swing.map.PaintingMode;
import org.freeplane.view.swing.map.SiblingSelection;
import org.freeplane.view.swing.map.SummaryEdgePainter;
import org.freeplane.view.swing.map.TagLocation;
import org.freeplane.view.swing.map.UpdateCause;
import org.freeplane.view.swing.map.ZoomedEmptyBorder;
import org.freeplane.view.swing.map.attribute.AttributeView;
import org.freeplane.view.swing.map.cloud.CloudView;
import org.freeplane.view.swing.map.cloud.CloudViewFactory;
import org.freeplane.view.swing.map.edge.AutomaticEdgeStyle;
import org.freeplane.view.swing.map.edge.EdgeView;
import org.freeplane.view.swing.map.edge.EdgeViewFactory;
import org.freeplane.view.swing.ui.mindmapmode.MNodeDragListener;
import org.freeplane.view.swing.ui.mindmapmode.MNodeDropListener;

public class NodeView
extends JComponent
implements INodeView {
    private static final Quantity<LengthUnit> TAG_INDENT = new Quantity(12.0, (Enum)LengthUnit.pt);
    static final String DEBUG_INFO_PROPERTY = "debugInfo";
    private static final int HIGHLIGHTED_NODE_ARC_MARGIN = 4;
    static final int ALIGN_BOTTOM = -1;
    static final int ALIGN_CENTER = 0;
    static final int ALIGN_TOP = 1;
    protected static final Color dragColor = Color.lightGray;
    private static final long serialVersionUID = 1L;
    static final int SPACE_AROUND = 50;
    public static final int MAIN_VIEWER_POSITION = 1;
    public static final int TAG_VIEWER_POSITION = 3;
    static final boolean PAINT_DEBUG_INFO;
    public static int ADDITIONAL_MOUSE_SENSITIVE_AREA;
    public static final int DETAIL_VIEWER_POSITION = 4;
    public static final int NOTE_VIEWER_POSITION = 12;
    private static int maxToolTipWidth;
    private AttributeView attributeView;
    private JComponent contentPane;
    private MainView mainView;
    private final MapView map;
    private NodeModel viewedNode;
    private NodeView lastSelectedChild;
    private EdgeStyle edgeStyle = EdgeStyle.EDGESTYLE_HIDDEN;
    private Integer edgeWidth = 1;
    private ObjectRule<Color, EdgeController.Rules> edgeColor = null;
    private Color modelBackgroundColor;
    private boolean isFolded;
    private Dash edgeDash = Dash.DEFAULT;
    private final NodeViewLayoutHelper layoutHelper;
    private NodeModel.Side side;
    private ChildNodesAlignment childNodesAlignment;
    private ChildNodesLayout childNodesLayout;
    private LayoutOrientation layoutOrientation;
    private ChildrenSides childrenSides;
    private boolean isNodeNumberingEnabled;

    protected NodeView(NodeModel viewedNode, MapView map) {
        this.setFocusCycleRoot(true);
        this.viewedNode = viewedNode;
        this.map = map;
        this.isFolded = map.getModeController().getMapController().isFolded(viewedNode);
        this.layoutHelper = new NodeViewLayoutHelper(this);
        TextController textController = TextController.getController(this.getModeController());
        this.isNodeNumberingEnabled = textController.getNodeNumbering(viewedNode);
    }

    public boolean isFolded() {
        return this.isFolded && !this.isRoot();
    }

    private int calcShiftY(LocationModel locationModel) {
        try {
            NodeModel parent = this.viewedNode.getParentNode();
            Filter filter = this.map.getFilter();
            int singleChildShift = !this.getParentView().isSummary() && this.getModeController().hasOneVisibleChild(parent, filter) ? this.getMainView().getSingleChildShift() : 0;
            return locationModel.getShiftY().toBaseUnitsRounded() + singleChildShift;
        }
        catch (NullPointerException e) {
            return 0;
        }
    }

    @Override
    public boolean contains(int x, int y) {
        int space = this.map.getZoomed(50);
        int reducedSpace = space - ADDITIONAL_MOUSE_SENSITIVE_AREA;
        if (x >= reducedSpace && x < this.getWidth() - reducedSpace && y >= reducedSpace && y < this.getHeight() - reducedSpace) {
            for (int i = this.getComponentCount() - 1; i >= 0; --i) {
                Component comp = this.getComponent(i);
                if (!comp.isVisible() || !comp.contains(x - comp.getX(), y - comp.getY())) continue;
                return true;
            }
        }
        return false;
    }

    protected void convertPointToMap(Point p) {
        UITools.convertPointToAncestor((Component)this, p, this.map);
    }

    public void createAttributeView() {
        if (this.attributeView == null && NodeAttributeTableModel.getModel(this.viewedNode) != NodeAttributeTableModel.EMTPY_ATTRIBUTES) {
            this.attributeView = new AttributeView(this, true);
        }
        this.syncronizeAttributeView();
    }

    public boolean focused() {
        return this.mainView.hasFocus();
    }

    public AttributeView getAttributeView() {
        if (this.attributeView == null) {
            AttributeController.getController(this.getModeController()).createAttributeTableModel(this.viewedNode);
            this.attributeView = new AttributeView(this, true);
        }
        return this.attributeView;
    }

    public Color getBackgroundColor() {
        Color cloudColor = this.getCloudColor();
        if (cloudColor != null) {
            return cloudColor;
        }
        NodeView parentView = this.getParentView();
        if (parentView == null) {
            return this.map.getBackground();
        }
        return parentView.getBackgroundColor();
    }

    public Color getCloudColor() {
        CloudModel cloudModel = this.getCloudModel();
        if (cloudModel != null) {
            Color cloudColor = cloudModel.getColor();
            return cloudColor;
        }
        return null;
    }

    public LinkedList<NodeView> getChildrenViews() {
        LinkedList<NodeView> childrenViews = new LinkedList<NodeView>();
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!(components[i] instanceof NodeView)) continue;
            NodeView view = (NodeView)components[i];
            childrenViews.add(view);
        }
        return childrenViews;
    }

    public JComponent getContent() {
        JComponent c;
        JComponent jComponent = c = this.contentPane == null ? this.mainView : this.contentPane;
        assert (c == null || c.getParent() == this);
        return c;
    }

    private JComponent getContentPane() {
        if (this.contentPane == null) {
            Window windowAncestor = SwingUtilities.getWindowAncestor(this.mainView);
            boolean hasFocus = windowAncestor != null && windowAncestor.getMostRecentFocusOwner() == this.mainView;
            this.contentPane = NodeViewFactory.getInstance().newContentPane(this);
            int index = this.getComponentCount() - 1;
            this.remove(index);
            this.contentPane.add(this.mainView);
            this.mainView.putClientProperty("NODE_VIEW_CONTENT_POSITION", 1);
            if (!this.mainView.isVisible()) {
                this.mainView.setVisible(true);
            }
            this.add((Component)this.contentPane, index);
            if (hasFocus) {
                this.restoreFocusToMainView();
            }
        }
        return this.contentPane;
    }

    private void restoreFocusToMainView() {
        final Window windowAncestor = SwingUtilities.getWindowAncestor(this.mainView);
        if (windowAncestor.isFocused()) {
            this.mainView.requestFocusInWindow();
        } else {
            windowAncestor.addWindowFocusListener(new WindowFocusListener(){

                @Override
                public void windowLostFocus(WindowEvent e) {
                }

                @Override
                public void windowGainedFocus(WindowEvent e) {
                    NodeView.this.mainView.requestFocusInWindow();
                    windowAncestor.removeWindowFocusListener(this);
                }
            });
        }
    }

    public void getCoordinates(LinkedList<Point> inList) {
        this.getCoordinates(inList, 0, false, 0, 0);
    }

    private void getCoordinates(LinkedList<Point> inList, int additionalDistanceForConvexHull, boolean byChildren, int transX, int transY) {
        if (!this.isVisible()) {
            return;
        }
        if (this.isContentVisible()) {
            ModeController modeController;
            CloudController cloudController;
            CloudModel cloud;
            if (byChildren && (cloud = (cloudController = CloudController.getController(modeController = this.getModeController())).getCloud(this.getNode(), this.getStyleOption())) != null) {
                additionalDistanceForConvexHull += CloudView.getAdditionalHeigth(cloud, this) / 5;
            }
            Rectangle foldingRectangleBounds = this.getMainView().getFoldingRectangleBounds(this, false);
            JComponent content = this.getContent();
            int extraFoldingRectangleLeftWidth = -Math.min(0, foldingRectangleBounds.x);
            int x = transX + content.getX() - extraFoldingRectangleLeftWidth;
            int extraFoldingRectangleTopHeight = -Math.min(0, foldingRectangleBounds.y);
            int y = transY + content.getY() - extraFoldingRectangleTopHeight;
            int width = extraFoldingRectangleLeftWidth + Math.max(content.getWidth(), foldingRectangleBounds.x + foldingRectangleBounds.width);
            int height = extraFoldingRectangleTopHeight + Math.max(content.getHeight(), foldingRectangleBounds.y + foldingRectangleBounds.height);
            inList.addLast(new Point(-additionalDistanceForConvexHull + x, -additionalDistanceForConvexHull + y));
            inList.addLast(new Point(-additionalDistanceForConvexHull + x, additionalDistanceForConvexHull + y + height));
            inList.addLast(new Point(additionalDistanceForConvexHull + x + width, additionalDistanceForConvexHull + y + height));
            inList.addLast(new Point(additionalDistanceForConvexHull + x + width, -additionalDistanceForConvexHull + y));
        }
        for (NodeView child : this.getChildrenViews()) {
            child.getCoordinates(inList, additionalDistanceForConvexHull, true, transX + child.getX(), transY + child.getY());
        }
    }

    private NodeView getFirstVisible(Component startAfter, boolean leftOnly, boolean rightOnly) {
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            NodeView child;
            if (startAfter != null) {
                if (components[i] != startAfter) continue;
                startAfter = null;
                continue;
            }
            if (!(components[i] instanceof NodeView)) continue;
            NodeView view = (NodeView)components[i];
            if (leftOnly && !view.isTopOrLeft() || rightOnly && view.isTopOrLeft()) continue;
            if (view.isContentVisible()) {
                return view;
            }
            if (view.isSummary() || (child = view.getFirstVisible(null, leftOnly, rightOnly)) == null) continue;
            return child;
        }
        return null;
    }

    int getHGap() {
        double unscaledHGap;
        double modelGap = LocationModel.getModel(this.viewedNode).getHGap().toBaseUnits();
        NodeView parentView = this.getParentView();
        if (parentView == null) {
            unscaledHGap = modelGap;
        } else {
            boolean reduce;
            ChildNodesAlignment childNodesAlignment = parentView.getChildNodesAlignment();
            ChildrenSides childrenSides = parentView.childrenSides();
            boolean bl = reduce = childNodesAlignment.isStacked() && (childrenSides == ChildrenSides.BOTH_SIDES || parentView.usesHorizontalLayout());
            unscaledHGap = reduce ? (parentView.usesHorizontalLayout() ? (childrenSides != ChildrenSides.BOTH_SIDES ? modelGap - (double)LocationModel.DEFAULT_HGAP_PX + (double)LocationModel.DEFAULT_VGAP_PX : modelGap - (double)LocationModel.DEFAULT_HGAP_PX + (double)(2 * LocationModel.DEFAULT_VGAP_PX)) : modelGap - (double)LocationModel.DEFAULT_HGAP_PX * 0.5) : modelGap;
        }
        return this.map.getZoomed(unscaledHGap);
    }

    private NodeView getLastVisible(Component startBefore, boolean leftOnly, boolean rightOnly) {
        Component[] components = this.getComponents();
        for (int i = components.length - 1; i >= 0; --i) {
            NodeView child;
            if (startBefore != null) {
                if (components[i] != startBefore) continue;
                startBefore = null;
                continue;
            }
            if (!(components[i] instanceof NodeView)) continue;
            NodeView view = (NodeView)components[i];
            if (leftOnly && !view.isTopOrLeft() || rightOnly && view.isTopOrLeft()) continue;
            if (view.isContentVisible()) {
                return view;
            }
            if (view.isSummary() || (child = view.getLastVisible(null, leftOnly, rightOnly)) == null) continue;
            return child;
        }
        return null;
    }

    LinkedList<NodeView> getLeft() {
        LinkedList<NodeView> left = new LinkedList<NodeView>();
        for (NodeView node : this.getChildrenViews()) {
            if (node == null || !node.isTopOrLeft()) continue;
            left.add(node);
        }
        return left;
    }

    public Point getLinkPoint(Point declination) {
        Point linkPoint;
        int y;
        int x;
        if (declination != null) {
            x = this.map.getZoomed(declination.x);
            y = this.map.getZoomed(declination.y);
        } else {
            x = 1;
            y = 0;
        }
        if (this.isTopOrLeft()) {
            x = -x;
        }
        if (y != 0 && this.getContent().getHeight() > 0) {
            int absLinkY;
            int absLinkX;
            double ctgLine;
            double ctgRect = Math.abs((double)this.getContent().getWidth() / (double)this.getContent().getHeight());
            if (ctgRect >= (ctgLine = Math.abs((double)x / (double)y)) || x == 0) {
                absLinkX = Math.abs(x * this.getContent().getHeight() / (2 * y));
                absLinkY = this.getContent().getHeight() / 2;
            } else {
                absLinkX = this.getContent().getWidth() / 2;
                absLinkY = Math.abs(y * this.getContent().getWidth() / (2 * x));
            }
            linkPoint = new Point(this.getContent().getWidth() / 2 + (x > 0 ? absLinkX : -absLinkX), this.getContent().getHeight() / 2 + (y > 0 ? absLinkY : -absLinkY));
        } else {
            linkPoint = new Point(x > 0 ? this.getContent().getWidth() : 0, this.getContent().getHeight() / 2);
        }
        linkPoint.translate(this.getContent().getX(), this.getContent().getY());
        this.convertPointToMap(linkPoint);
        return linkPoint;
    }

    public MainView getMainView() {
        return this.mainView;
    }

    public Point getRelativeLocation(NodeView target) {
        int targetX = 0;
        int targetY = 0;
        Container component = target.getMainView();
        while (!this.equals(component) && !component.getClass().equals(MapView.class)) {
            targetX += ((Component)component).getX();
            targetY += ((Component)component).getY();
            component = component.getParent();
        }
        Point relativeLocation = new Point();
        UITools.convertPointToAncestor((Component)this.mainView, relativeLocation, component);
        relativeLocation.x = targetX - relativeLocation.x;
        relativeLocation.y = targetY - relativeLocation.y;
        return relativeLocation;
    }

    public Point getRelativeLocation(NodeView target, double x, double y) {
        Point relativeLocation = this.getRelativeLocation(target);
        if (x != 0.0) {
            relativeLocation.x = (int)((long)relativeLocation.x + Math.round((double)target.getMainView().getWidth() * x));
        }
        if (y != 0.0) {
            relativeLocation.y = (int)((long)relativeLocation.y + Math.round((double)target.getMainView().getHeight() * y));
        }
        return relativeLocation;
    }

    public MapView getMap() {
        return this.map;
    }

    public int getMaxToolTipWidth() {
        if (maxToolTipWidth == 0) {
            try {
                maxToolTipWidth = ResourceController.getResourceController().getIntProperty("toolTipManager.max_tooltip_width", 600);
            }
            catch (NumberFormatException e) {
                maxToolTipWidth = 600;
            }
        }
        return maxToolTipWidth;
    }

    public NodeModel getNode() {
        return this.viewedNode;
    }

    private NodeView getNextVisibleSiblingSameParent(SiblingSelection siblingSelection) {
        NodeView first;
        LinkedList<NodeView> v = this.getSiblingViews();
        int index = v.indexOf(this);
        boolean isOutlineLayoutSet = this.map.isOutlineLayoutSet();
        boolean skipUntilSummaryEnd = !isOutlineLayoutSet && this.isSummary();
        for (int i = index + 1; i < v.size(); ++i) {
            NodeView first2;
            NodeView nextView = v.get(i);
            if (this.isTopOrLeft() != nextView.isTopOrLeft()) continue;
            if (skipUntilSummaryEnd && nextView.isSummary()) break;
            skipUntilSummaryEnd = false;
            NodeModel node = nextView.getNode();
            if (node.hasVisibleContent(this.map.getFilter())) {
                return nextView;
            }
            if (!isOutlineLayoutSet && node.isHiddenSummary() || (first2 = nextView.getFirstVisible(null, this.isTopOrLeft(), !this.isTopOrLeft())) == null) continue;
            return first2;
        }
        if (siblingSelection != SiblingSelection.CHANGE_PARENT && (first = this.getParentView().getPreferredVisibleChild(PreferredChild.FIRST, this.isTopOrLeft())) != this) {
            if (siblingSelection == SiblingSelection.LOOP) {
                return first;
            }
            return this;
        }
        return null;
    }

    NodeView getNextVisibleSibling(LayoutOrientation requiredLayoutOrientation, SiblingSelection siblingSelection) {
        NodeView first;
        NodeView sibling = this;
        NodeView lastSibling = this;
        NodeView parentView = this.getParentView();
        while (sibling != this.map.getRoot()) {
            lastSibling = sibling;
            LayoutOrientation parentLayoutOrientation = parentView.layoutOrientation();
            if (requiredLayoutOrientation == parentLayoutOrientation && (sibling = sibling.getNextVisibleSiblingSameParent(siblingSelection)) != null) break;
            sibling = parentView;
            parentView = parentView.getParentView();
        }
        if (sibling.getChildNodesAlignment().isStacked() && !sibling.usesHorizontalLayout()) {
            return sibling.isRoot() ? null : sibling;
        }
        Filter filter = this.map.getFilter();
        int siblingMaxLevel = this.map.getSiblingMaxLevel();
        while (sibling.getNode().getNodeLevel(filter) < siblingMaxLevel && sibling.layoutOrientation() == requiredLayoutOrientation && (first = sibling.getFirstVisible(sibling.isRoot() ? lastSibling : null, this.isTopOrLeft(), !this.isTopOrLeft())) != null) {
            if (siblingSelection != SiblingSelection.CHANGE_PARENT && first != sibling.getLastVisible(null, this.isTopOrLeft(), !this.isTopOrLeft())) {
                return null;
            }
            sibling = first;
        }
        return sibling.isRoot() ? null : sibling;
    }

    public NodeView getParentView() {
        Container parent = this.getParent();
        if (parent instanceof NodeView) {
            return (NodeView)parent;
        }
        return null;
    }

    public NodeView getParentNodeView() {
        NodeView parent = this.getParentView();
        if (parent != null) {
            return parent;
        }
        NodeModel parentNode = this.viewedNode.getParentNode();
        if (parentNode == null) {
            return null;
        }
        NodeView parentNodeView = this.getMap().getNodeView(parentNode);
        if (parentNodeView != null) {
            return parentNodeView;
        }
        NodeView newParentNodeView = new NodeView(parentNode, this.map);
        newParentNodeView.update();
        return newParentNodeView;
    }

    NodeView getPreferredVisibleChild(PreferredChild preferredChild, ChildrenSides sides) {
        return this.getPreferredVisibleChild(preferredChild, sides, this);
    }

    private NodeView getPreferredVisibleChild(PreferredChild preferredChild, ChildrenSides sides, NodeView nearest) {
        if (this.getNode().isLeaf()) {
            return null;
        }
        if (preferredChild == PreferredChild.LAST_SELECTED && this.lastSelectedChild != null && this.lastSelectedChild.getParent() == this && sides.matches(this.lastSelectedChild.isTopOrLeft())) {
            if (this.lastSelectedChild.isContentVisible()) {
                return this.lastSelectedChild;
            }
            NodeView newSelected = this.lastSelectedChild.getPreferredVisibleChild(preferredChild, ChildrenSides.BOTH_SIDES, nearest);
            if (newSelected != null) {
                return newSelected;
            }
        }
        return this.selectNearest(preferredChild, sides, nearest);
    }

    NodeView selectNearest(PreferredChild preferredChild, ChildrenSides sides, NodeView ancor) {
        int distance = Integer.MAX_VALUE;
        NodeView baseComponent = (this.isContentVisible() || this.isSummary()) && preferredChild != PreferredChild.NEAREST_SIBLING || this.getParentView() == null ? this : this.getAncestorWithVisibleContent();
        NodeView newSelected = null;
        JComponent ancorContent = ancor.getContent();
        Point ownPoint = baseComponent.calculateCentralPoint(ancorContent);
        for (int i = 0; i < this.getComponentCount(); ++i) {
            int gapToChild;
            int distanceToBorder;
            NodeView childView;
            boolean isChildTopOrLeft;
            Component c = this.getComponent(i);
            if (!(c instanceof NodeView) || c == ancor || !sides.matches(isChildTopOrLeft = (childView = (NodeView)c).isTopOrLeft()) || sides == ChildrenSides.BOTH_SIDES && this.lastSelectedChild != null && this.lastSelectedChild.getParent() == this && this.lastSelectedChild.isTopOrLeft() != isChildTopOrLeft || !childView.isContentVisible() && (childView.isSummary() && newSelected != null && !this.map.isOutlineLayoutSet() || (childView = childView.getPreferredVisibleChild(preferredChild, ChildrenSides.BOTH_SIDES, ancor)) == null)) continue;
            if (preferredChild == PreferredChild.FIRST) {
                return childView;
            }
            if (preferredChild == PreferredChild.LAST) {
                newSelected = childView;
                continue;
            }
            JComponent childContent = childView.getContent();
            if (childContent == null) continue;
            Point childPoint = baseComponent.calculateCentralPoint(childContent);
            if (baseComponent.usesHorizontalLayout()) {
                distanceToBorder = (ancorContent.getHeight() + childContent.getHeight()) / 2;
                childPoint.y = childView.isTopOrLeft() ? (childPoint.y += distanceToBorder) : (childPoint.y -= distanceToBorder);
            } else {
                distanceToBorder = (ancorContent.getWidth() + childContent.getWidth()) / 2;
                childPoint.x = childView.isTopOrLeft() ? (childPoint.x += distanceToBorder) : (childPoint.x -= distanceToBorder);
            }
            int dx = childPoint.x - ownPoint.x;
            int dy = childPoint.y - ownPoint.y;
            int n = gapToChild = baseComponent.usesHorizontalLayout() ? dy * dy + 2 * dx * dx : 2 * dy * dy + dx * dx;
            if (gapToChild >= distance) break;
            newSelected = childView;
            distance = gapToChild;
        }
        return newSelected;
    }

    private Point calculateCentralPoint(JComponent c) {
        Point childPoint = new Point(c.getWidth() / 2, c.getHeight() / 2);
        UITools.convertPointToAncestor((Component)c, childPoint, this);
        return childPoint;
    }

    private NodeView getPreviousVisibleSiblingSameParent(SiblingSelection siblingSelection) {
        NodeView last;
        LinkedList<NodeView> v = this.getSiblingViews();
        int index = v.indexOf(this);
        boolean skipUntilFirstGroupNode = !this.map.isOutlineLayoutSet() && this.isSummary();
        for (int i = index - 1; i >= 0; --i) {
            NodeView last2;
            NodeView nextView = v.get(i);
            if (skipUntilFirstGroupNode) {
                skipUntilFirstGroupNode = !nextView.isFirstGroupNode();
                continue;
            }
            if (this.isTopOrLeft() != nextView.isTopOrLeft()) continue;
            NodeModel node = nextView.getNode();
            if (node.hasVisibleContent(this.map.getFilter())) {
                return nextView;
            }
            if (node.isHiddenSummary() || (last2 = nextView.getLastVisible(null, this.isTopOrLeft(), !this.isTopOrLeft())) == null) continue;
            return last2;
        }
        if (siblingSelection != SiblingSelection.CHANGE_PARENT && (last = this.getParentView().getPreferredVisibleChild(PreferredChild.LAST, this.isTopOrLeft())) != this) {
            if (siblingSelection == SiblingSelection.LOOP) {
                return last;
            }
            return this;
        }
        return null;
    }

    protected LinkedList<NodeView> getSiblingViews() {
        LinkedList<NodeView> v = null;
        NodeView parentView = this.getParentView();
        if (parentView == null) {
            UITools.errorMessage("unexpected error: node " + this.getMainView().getText() + " has lost its parent ");
            return null;
        }
        v = parentView.isRoot() ? (this.isTopOrLeft() ? parentView.getLeft() : parentView.getRight()) : parentView.getChildrenViews();
        return v;
    }

    NodeView getPreviousVisibleSibling(LayoutOrientation requiredLayoutOrientation, SiblingSelection siblingSelection) {
        NodeView last;
        NodeView sibling = this;
        NodeView previousSibling = this;
        NodeView parentView = this.getParentView();
        if (parentView == null) {
            return null;
        }
        boolean parentUsesHorizontalLayout = parentView.usesHorizontalLayout();
        while (parentView != null) {
            previousSibling = sibling;
            if (requiredLayoutOrientation == parentView.layoutOrientation() && (sibling = sibling.getPreviousVisibleSiblingSameParent(siblingSelection)) != null) break;
            sibling = parentView;
            parentView = parentView.getParentView();
        }
        if ((parentView != null ? parentView : sibling).layoutOrientation() != requiredLayoutOrientation) {
            return null;
        }
        if (sibling.getChildNodesAlignment().isStacked() && !sibling.usesHorizontalLayout()) {
            return sibling;
        }
        int siblingMaxLevel = this.map.getSiblingMaxLevel();
        Filter filter = this.map.getFilter();
        while (sibling.getNode().getNodeLevel(filter) < siblingMaxLevel && sibling.usesHorizontalLayout() == parentUsesHorizontalLayout && (last = sibling.getLastVisible(sibling.isRoot() ? previousSibling : null, this.isTopOrLeft(), !this.isTopOrLeft())) != null) {
            if (siblingSelection != SiblingSelection.CHANGE_PARENT && last != sibling.getFirstVisible(null, this.isTopOrLeft(), !this.isTopOrLeft())) {
                return null;
            }
            sibling = last;
        }
        if (sibling.isRoot()) {
            return null;
        }
        return sibling;
    }

    LinkedList<NodeView> getRight() {
        LinkedList<NodeView> right = new LinkedList<NodeView>();
        for (NodeView node : this.getChildrenViews()) {
            if (node == null || node.isTopOrLeft()) continue;
            right.add(node);
        }
        return right;
    }

    public int getShift() {
        LocationModel locationModel = LocationModel.getModel(this.viewedNode);
        return this.map.getZoomed(this.calcShiftY(locationModel));
    }

    public Color getTextBackground() {
        if (this.modelBackgroundColor != null) {
            return this.modelBackgroundColor;
        }
        return this.getBackgroundColor();
    }

    public void setTextBackground(Color textBackground) {
        this.modelBackgroundColor = textBackground;
    }

    public Color getTextBackground(LogicalStyleController.StyleOption styleOption) {
        Color modelBackgroundColor = this.styleController().getBackgroundColor(this.viewedNode, styleOption);
        if (modelBackgroundColor != null) {
            return modelBackgroundColor;
        }
        return this.getBackgroundColor();
    }

    private NodeStyleController styleController() {
        return NodeStyleController.getController(this.getModeController());
    }

    public Color getTextColor(LogicalStyleController.StyleOption styleOption) {
        Color color = this.styleController().getColor(this.viewedNode, styleOption);
        return color;
    }

    public int getMinimalDistanceBetweenChildren() {
        double minimalDistanceBetweenChildren = this.getModeController().getExtension(LocationController.class).getCommonVGapBetweenChildren(this.viewedNode).toBaseUnits();
        return this.map.getZoomed(minimalDistanceBetweenChildren);
    }

    public int getBaseDistanceToChildren() {
        double distance = this.getModeController().getExtension(LocationController.class).getBaseHGapToChildren(this.viewedNode).toBaseUnits();
        return this.map.getZoomed(distance - (double)LocationModel.DEFAULT_HGAP_PX);
    }

    public ChildNodesAlignment getChildNodesAlignment() {
        this.updateLayoutProperties();
        return this.childNodesAlignment;
    }

    private void updateChildNodesAlignment() {
        if (this.map.isOutlineLayoutSet()) {
            this.childNodesAlignment = ChildNodesAlignment.AFTER_PARENT;
        } else {
            ChildNodesAlignment childNodesAlignment = this.childNodesLayout.childNodesAlignment();
            switch (childNodesAlignment) {
                case STACKED_AUTO: 
                case NOT_SET: 
                case AUTO: {
                    this.childNodesAlignment = this.getDefaultChildNodesAlignment();
                    break;
                }
                default: {
                    this.childNodesAlignment = childNodesAlignment;
                }
            }
        }
    }

    private boolean isEffectivelyTopOrLeft() {
        NodeView parentView = this.getParentNodeView();
        if (parentView == null || parentView.layoutOrientation() != this.layoutOrientation()) {
            return this.isTopOrLeft();
        }
        return parentView.isEffectivelyTopOrLeft();
    }

    private ChildNodesAlignment getDefaultChildNodesAlignment() {
        NodeView parentView = this.getParentNodeView();
        if (parentView == null) {
            return ChildNodesAlignment.FLOW;
        }
        if (parentView.isSummary()) {
            return parentView.getDefaultChildNodesAlignment();
        }
        if (this.childNodesLayout.childNodesAlignment() == ChildNodesAlignment.STACKED_AUTO) {
            if (parentView.getChildNodesAlignment().isStacked()) {
                return parentView.getChildNodesAlignment();
            }
            if (this.isEffectivelyTopOrLeft()) {
                return ChildNodesAlignment.BEFORE_PARENT;
            }
            return ChildNodesAlignment.AFTER_PARENT;
        }
        if (parentView.usesHorizontalLayout() == this.usesHorizontalLayout()) {
            return parentView.getChildNodesAlignment();
        }
        if (this.isTopOrLeft()) {
            return ChildNodesAlignment.BEFORE_PARENT;
        }
        return ChildNodesAlignment.AFTER_PARENT;
    }

    public NodeView getAncestorWithVisibleContent() {
        NodeView parentView = this.getParentView();
        if (parentView == null || parentView.isContentVisible()) {
            return parentView;
        }
        return parentView.getAncestorWithVisibleContent();
    }

    NodeView getDescendant(PreferredChild preferredChild) {
        NodeView preferredVisibleChild;
        NodeView newSelected = this;
        while (this.layoutOrientation() == LayoutOrientation.TOP_TO_BOTTOM && this.getChildNodesAlignment() == this.getParentView().getChildNodesAlignment() && this.isSubtreeVisible() && (preferredVisibleChild = newSelected.getPreferredVisibleChild(preferredChild, ChildrenSides.BOTH_SIDES)) != null) {
            newSelected = preferredVisibleChild;
        }
        return newSelected;
    }

    NodeView getVisibleSummarizedOrParentView(LayoutOrientation requiredLayoutOrientation, boolean isChildTopOrLeft) {
        Container parent = this.getParent();
        if (!(parent instanceof NodeView)) {
            return null;
        }
        NodeView parentView = (NodeView)parent;
        if (parentView.layoutOrientation() == requiredLayoutOrientation && isChildTopOrLeft == this.isTopOrLeft()) {
            if (this.isSummary()) {
                boolean startFromSummary = true;
                LinkedList<NodeView> v = this.getSiblingViews();
                int index = v.indexOf(this);
                for (int i = index - 1; i >= 0; --i) {
                    NodeView nextView = v.get(i);
                    if (nextView.isContentVisible() || nextView.isSubtreeVisible()) {
                        return nextView.getDescendant(PreferredChild.FIRST);
                    }
                    if (!nextView.isSummary()) {
                        startFromSummary = false;
                        continue;
                    }
                    if (!startFromSummary) break;
                }
            }
            if (parentView.isContentVisible()) {
                return parentView;
            }
        }
        return parentView.getVisibleSummarizedOrParentView(requiredLayoutOrientation, isChildTopOrLeft);
    }

    public int getZoomedFoldingMarkHalfWidth() {
        int preferredFoldingSymbolHalfWidth = (int)(ResourceController.getResourceController().getLengthQuantityProperty("foldingsymbolwidth").toBaseUnits() * (double)this.map.getZoom() / 2.0);
        return preferredFoldingSymbolHalfWidth;
    }

    public int getZoomedFoldingSwitchMinWidth() {
        int preferredFoldingSwitchMinWidth = (int)(ResourceController.getResourceController().getLengthQuantityProperty("foldingSwitchMinWidth").toBaseUnits() * (double)this.map.getZoom());
        return preferredFoldingSwitchMinWidth;
    }

    int getMinimumDistanceConsideringHandles() {
        int draggingAreaWidth = this.mainView.getDraggingAreaWidth();
        if (!this.usesHorizontalLayout()) {
            int preferredFoldingSymbolWidth = Math.max(this.getZoomedFoldingMarkHalfWidth(), this.getZoomedFoldingSwitchMinWidth());
            return draggingAreaWidth + preferredFoldingSymbolWidth;
        }
        return draggingAreaWidth;
    }

    public int getZoomedStateSymbolHalfWidth() {
        int preferredFoldingSymbolHalfWidth = (int)(ResourceController.getResourceController().getLengthQuantityProperty("statesymbolwidth").toBaseUnits() * (double)this.map.getZoom() / 2.0);
        return preferredFoldingSymbolHalfWidth;
    }

    void addChildViews() {
        if (this.isFolded()) {
            return;
        }
        int index = 0;
        for (NodeModel child : this.getNode().getChildren()) {
            if (this.isChildHidden(child)) {
                return;
            }
            if (this.getComponentCount() <= index || !(this.getComponent(index) instanceof NodeView)) {
                this.addChildView(child, index);
            }
            ++index;
        }
    }

    NodeView addChildView(NodeModel newNode, int index) {
        this.updateFilterResults(newNode);
        return NodeViewFactory.getInstance().newNodeView(newNode, this.map, this, index);
    }

    void onFilterResultUpdate(NodeModel node) {
        NodeView nodeView = this.map.getNodeView(node);
        if (nodeView != null) {
            nodeView.revalidate();
            nodeView.repaint();
            if (nodeView.isSelected() && !nodeView.isContentVisible()) {
                this.map.deselect(nodeView);
                NodeView ancestorWithVisibleContent = nodeView.getAncestorWithVisibleContent();
                this.map.addSelected(ancestorWithVisibleContent, true);
            }
        }
    }

    public boolean isChildOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView;
    }

    public boolean isContentVisible() {
        if (this.isValid()) {
            return this.getContent().isVisible();
        }
        return this.getNode().hasVisibleContent(this.map.getFilter()) || this.isRoot();
    }

    public NodeModel.Side side() {
        this.updateLayoutProperties();
        return this.side;
    }

    @Override
    public boolean isTopOrLeft() {
        return this.side() == NodeModel.Side.TOP_OR_LEFT;
    }

    public boolean isRight() {
        return !this.isTopOrLeft() && this.getNode() != this.map.getRoot().getNode();
    }

    public boolean isParentHidden() {
        Container parent = this.getParent();
        if (!(parent instanceof NodeView)) {
            return false;
        }
        NodeView parentView = (NodeView)parent;
        return !parentView.isContentVisible() && !parentView.getNode().isHiddenSummary();
    }

    public boolean isParentOf(NodeView myNodeView) {
        return this == myNodeView.getParentView();
    }

    public boolean isRoot() {
        return this.map.isRoot(this);
    }

    public boolean isSearchRoot() {
        return this.map.isSearchRoot(this);
    }

    public boolean isSelected() {
        return this.map.isSelected(this);
    }

    public boolean isSiblingOf(NodeView myNodeView) {
        return this.getParentView() == myNodeView.getParentView();
    }

    @Override
    public void nodeChanged(NodeChangeEvent event) {
        NodeModel node = event.getNode();
        if (!node.isRoot() && node.getParentNode() == null) {
            return;
        }
        this.updateChangedNode(event);
        this.updateFilterResults(node);
    }

    void updateFilterResults(NodeModel node) {
        if (!this.map.isSelected()) {
            Filter filter = this.map.getFilter();
            filter.updateFilterResults(node, this::onFilterResultUpdate);
            if (this.map.synchronizesSelectionAcrossVisibleViews()) {
                this.map.synchronizeSelection();
            }
        }
    }

    private void updateChangedNode(NodeChangeEvent event) {
        Object property = event.getProperty();
        if (property == NodeModel.NodeChangeType.FOLDING || property == Properties.HIDDEN_CHILDREN || property == EncryptionModel.class) {
            if (this.map.isSelected() || property == EncryptionModel.class && !this.isFolded()) {
                boolean folded = this.getModeController().getMapController().isFolded(this.viewedNode);
                boolean force = property == Properties.HIDDEN_CHILDREN || property == EncryptionModel.class;
                this.setFolded(folded, force);
            }
            if (property != EncryptionModel.class) {
                return;
            }
        }
        if (property == ChildNodesAlignment.class || property == LayoutOrientation.class || property == ChildNodesLayout.class) {
            this.resetLayoutPropertiesRecursively();
            this.revalidate();
            this.repaint();
            return;
        }
        if (property == NodeVisibilityConfiguration.class) {
            this.updateAll();
            if (event.getNewValue() != NodeVisibilityConfiguration.SHOW_HIDDEN_NODES) {
                FilterController.getCurrentFilterController().selectVisibleNodes(this.map.getMapSelection());
            }
            return;
        }
        if (property == NodeVisibility.class && this.map.getMap().getRootNode().getExtension(NodeVisibilityConfiguration.class) != NodeVisibilityConfiguration.SHOW_HIDDEN_NODES) {
            if (!this.isRoot()) {
                NodeView parentView = this.getParentView();
                parentView.setFolded(parentView.isFolded(), true);
                if (event.getNewValue() == NodeVisibility.HIDDEN && this.isSelected()) {
                    FilterController.getCurrentFilterController().selectVisibleNodes(this.map.getMapSelection());
                }
            } else {
                this.updateIcons();
            }
            return;
        }
        if (property == NodeModel.Side.class) {
            this.resetLayoutPropertiesRecursively();
            this.revalidate();
        }
        if (this.mainView == null) {
            return;
        }
        if (property.equals("icon") || property.equals("hierarchical_icons")) {
            this.updateIcons();
            this.revalidate();
            return;
        }
        if (property.equals("icon_size")) {
            this.updateIcons();
            this.revalidate();
            return;
        }
        if (property.equals(HistoryInformationModel.class)) {
            return;
        }
        this.update();
        this.updateNumbering();
    }

    private void updateNumbering() {
        if (this.getParentView() == null) {
            return;
        }
        NodeModel parentNode = this.viewedNode.getParentNode();
        if (parentNode == null) {
            return;
        }
        TextController textController = TextController.getController(this.getModeController());
        boolean isNodeNumberingEnabled = textController.getNodeNumbering(this.getNode());
        if (this.isNodeNumberingEnabled != isNodeNumberingEnabled) {
            this.isNodeNumberingEnabled = isNodeNumberingEnabled;
            this.getParentView().numberChanged(parentNode.getIndex(this.viewedNode) + 1);
        }
    }

    public void setFolded(boolean folded) {
        this.setFolded(folded, false);
        this.revalidate();
    }

    void keepUnfolded() {
        this.isFolded = false;
    }

    private void setFolded(boolean fold, boolean force) {
        boolean wasFolded = this.isFolded;
        this.isFolded = fold;
        if (wasFolded != fold || force) {
            this.map.preserveRootNodeLocationOnScreen();
            this.fireFoldingChanged();
        }
        this.map.foldingWasSet(this);
        if (this.lastSelectedChild != null && this.isFolded()) {
            this.lastSelectedChild = null;
        }
    }

    void fireFoldingChanged() {
        this.treeStructureChanged();
        this.map.selectIfSelectionIsEmpty(this.isContentVisible() ? this : this.getAncestorWithVisibleContent());
        NodeStyleShape shape = this.styleController().getShape(this.viewedNode, this.getStyleOption());
        if (shape.equals((Object)NodeStyleShape.combined)) {
            this.update();
        }
    }

    @Override
    public void onPreNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        this.adjustLastSelectedChild(nodeDeletionEvent);
    }

    private void adjustLastSelectedChild(NodeDeletionEvent nodeDeletionEvent) {
        NodeView node;
        int childModeViewIndex;
        if (this.lastSelectedChild == null || this.isFolded()) {
            return;
        }
        NodeView mapRootNodeView = this.map.getRoot();
        NodeModel mapRootNode = mapRootNodeView.getNode();
        if (mapRootNode == nodeDeletionEvent.node) {
            childModeViewIndex = nodeDeletionEvent.index;
            node = mapRootNodeView;
        } else {
            childModeViewIndex = this.map.calculateComponentIndex(this, nodeDeletionEvent.index);
            node = (NodeView)this.getComponent(childModeViewIndex);
        }
        if (node == this.lastSelectedChild) {
            NodeView candidate;
            Component c;
            int j;
            this.lastSelectedChild = null;
            int n = j = mapRootNode == nodeDeletionEvent.node ? childModeViewIndex : childModeViewIndex + 1;
            while (j < this.getComponentCount() && (c = this.getComponent(j)) instanceof NodeView) {
                candidate = (NodeView)c;
                if (candidate.isVisible() && node.isTopOrLeft() == candidate.isTopOrLeft()) {
                    this.lastSelectedChild = candidate;
                    break;
                }
                ++j;
            }
            if (this.lastSelectedChild == null) {
                for (j = childModeViewIndex - 1; j >= 0 && (c = this.getComponent(j)) instanceof NodeView; --j) {
                    candidate = (NodeView)c;
                    if (!candidate.isVisible() || node.isTopOrLeft() != candidate.isTopOrLeft()) continue;
                    this.lastSelectedChild = candidate;
                    break;
                }
            }
        }
    }

    @Override
    public void onNodeDeleted(NodeDeletionEvent nodeDeletionEvent) {
        NodeView node;
        NodeModel mapRootNode = this.map.getRoot().getNode();
        if (mapRootNode == nodeDeletionEvent.node) {
            this.map.restoreRootNode(nodeDeletionEvent.index);
        } else if (mapRootNode.isDescendantOf(nodeDeletionEvent.node)) {
            this.map.restoreRootNode();
        }
        if (this.getComponentCount() <= 1) {
            return;
        }
        int childNodeViewIndex = this.viewedNode == this.map.getRoot().getNode().getParentNode() ? (nodeDeletionEvent.index == this.getComponentCount() - 1 ? nodeDeletionEvent.index - 1 : (nodeDeletionEvent.index == 0 ? nodeDeletionEvent.index : ((node = (NodeView)this.getComponent(nodeDeletionEvent.index)).getNode() == nodeDeletionEvent.node ? nodeDeletionEvent.index : nodeDeletionEvent.index - 1))) : nodeDeletionEvent.index;
        node = (NodeView)this.getComponent(childNodeViewIndex);
        if (node.viewedNode != nodeDeletionEvent.node) {
            throw new IllegalStateException("Inconsistent child node view after deletion");
        }
        this.numberChanged(childNodeViewIndex + 1);
        this.map.preserveRootNodeLocationOnScreen();
        node.remove();
        this.updateFilterResults(this.viewedNode);
        this.map.updateSelectedNode();
        NodeView preferred = this.getPreferredVisibleChild(PreferredChild.LAST_SELECTED, this.childrenSides());
        if (preferred == null) {
            preferred = this;
        }
        this.revalidate();
        if (this.map.getSelected() == null) {
            this.map.selectVisibleAncestorOrSelf(preferred);
        }
    }

    public NodeView getPreferredVisibleChild(PreferredChild preferredChild, boolean isTopOrLeft) {
        return this.getPreferredVisibleChild(preferredChild, ChildrenSides.ofTopOrLeft((boolean)isTopOrLeft));
    }

    @Override
    public void onNodeInserted(NodeModel parent, NodeModel child, int index) {
        assert (parent == this.viewedNode);
        if (this.isFolded()) {
            return;
        }
        if (child == this.map.getRoot().getNode()) {
            return;
        }
        if (!this.map.isSelected() && parent.getChildCount() == 1 && this.map.getFilter().getCondition() == null && !this.getNode().isRoot()) {
            this.isFolded = true;
            if (!this.isRoot()) {
                this.revalidate();
                return;
            }
        }
        NodeView newChild = this.addChildView(child, index);
        if (this.map.getRoot().getNode().getParentNode() != parent) {
            this.numberChanged(index + 1);
        }
        if (!SummaryNode.isSummaryNode(child)) {
            this.lastSelectedChild = newChild;
        }
        this.revalidate();
    }

    private void numberChanged(int firstChangedIndex) {
        TextController textController = TextController.getController(this.getModeController());
        if (firstChangedIndex > 0 || textController.getNodeNumbering(this.getNode())) {
            Component[] components = this.getComponents();
            for (int i = firstChangedIndex; i < components.length; ++i) {
                NodeView view;
                MainView childMainView;
                if (!(components[i] instanceof NodeView) || (childMainView = (view = (NodeView)components[i]).getMainView()) == null) continue;
                childMainView.updateText(view.getNode());
                view.numberChanged(0);
            }
        }
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getMainView() == null) {
            return;
        }
        PaintingMode paintingMode = this.map.getPaintingMode();
        if (paintingMode == null) {
            LogUtils.severe("paintingMode = null");
            LogUtils.severe("own map =" + this.map);
            MapView ancestorMap = (MapView)SwingUtilities.getAncestorOfClass(MapView.class, this);
            LogUtils.severe("parent component map =" + ancestorMap);
            if (ancestorMap != null) {
                LogUtils.severe("ancestor map paintingMode = " + (Object)((Object)ancestorMap.getPaintingMode()));
            }
            throw new NullPointerException();
        }
        Graphics2D g2 = (Graphics2D)g;
        ModeController modeController = this.getModeController();
        switch (paintingMode) {
            case CLOUDS: {
                if (!this.isSubtreeVisible()) break;
                boolean isRoot = this.isRoot();
                if (isRoot) {
                    this.paintCloud(g);
                }
                this.paintClouds(g2);
                break;
            }
            case NODES: {
                if (!this.isContentVisible()) break;
                g2.setStroke(MainView.DEF_STROKE);
                this.paintEdges(g2, this);
                break;
            }
        }
        if (PAINT_DEBUG_INFO && this.isSelected() && paintingMode.equals((Object)PaintingMode.SELECTED_NODES)) {
            int spaceAround = this.getZoomed(50);
            g.setColor(UITools.getTextColorForBackground(this.getBackgroundColor()));
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.drawRect(spaceAround - 1, spaceAround - 1, this.getWidth() - 2 * spaceAround, this.getHeight() - 2 * spaceAround);
            Object debugInfo = this.getClientProperty(DEBUG_INFO_PROPERTY);
            if (debugInfo != null) {
                g.drawString(debugInfo.toString(), 0, spaceAround);
            }
        }
    }

    @Override
    public void paint(Graphics g) {
        if (this.isSubtreeVisible()) {
            super.paint(g);
            this.paintDecoration((Graphics2D)g);
        }
    }

    private void paintCloud(Graphics g) {
        if (!this.isSubtreeVisible()) {
            return;
        }
        CloudModel cloudModel = this.getCloudModel();
        if (cloudModel == null) {
            return;
        }
        CloudView cloud = new CloudViewFactory().createCloudView(cloudModel, this);
        cloud.paint(g);
    }

    private void paintClouds(Graphics2D g) {
        for (int i = this.getComponentCount() - 1; i >= 0; --i) {
            Component component = this.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView nodeView = (NodeView)component;
            Point p = new Point();
            UITools.convertPointToAncestor((Component)nodeView, p, this);
            g.translate(p.x, p.y);
            if (nodeView.isSubtreeVisible()) {
                nodeView.paintCloud(g);
            } else {
                nodeView.paintClouds(g);
            }
            g.translate(-p.x, -p.y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void paintEdges(Graphics2D g, NodeView source) {
        int step;
        int end;
        int start;
        SummaryEdgePainter rightSummaryEdgePainter;
        boolean paintsChildrenOnBothSides;
        ChildrenSides childrenSides = this.childrenSides();
        boolean bl = paintsChildrenOnBothSides = childrenSides == ChildrenSides.BOTH_SIDES || this.isRoot();
        boolean paintsOnTheLeftSide = paintsChildrenOnBothSides ? true : (childrenSides == ChildrenSides.BOTTOM_OR_RIGHT ? false : (childrenSides == ChildrenSides.TOP_OR_LEFT ? true : this.isTopOrLeft()));
        SummaryEdgePainter summaryEdgePainter = new SummaryEdgePainter(this, paintsOnTheLeftSide);
        SummaryEdgePainter summaryEdgePainter2 = rightSummaryEdgePainter = paintsChildrenOnBothSides ? new SummaryEdgePainter(this, false) : null;
        if (this.map.getLayoutType() == MapViewLayout.OUTLINE) {
            start = this.getComponentCount() - 1;
            end = -1;
            step = -1;
        } else {
            start = 0;
            end = this.getComponentCount();
            step = 1;
        }
        for (int i = start; i != end; i += step) {
            Component component = this.getComponent(i);
            if (!(component instanceof NodeView)) continue;
            NodeView nodeView = (NodeView)component;
            if (this.map.getLayoutType() != MapViewLayout.OUTLINE) {
                SummaryEdgePainter activePainter = nodeView.isTopOrLeft() || !paintsChildrenOnBothSides ? summaryEdgePainter : rightSummaryEdgePainter;
                activePainter.addChild(nodeView);
                if (nodeView.isSubtreeVisible() && activePainter.paintSummaryEdge(g, source, nodeView)) {
                    if (nodeView.isContentVisible()) continue;
                    Rectangle bounds = SwingUtilities.convertRectangle(this, nodeView.getBounds(), source);
                    Graphics cg = g.create(bounds.x, bounds.y, bounds.width, bounds.height);
                    try {
                        nodeView.paintEdges((Graphics2D)cg, nodeView);
                        continue;
                    }
                    finally {
                        cg.dispose();
                    }
                }
            }
            if (nodeView.isContentVisible()) {
                EdgeView edge = EdgeViewFactory.getInstance().getEdge(source, nodeView, source);
                edge.paint(g);
                continue;
            }
            nodeView.paintEdges(g, source);
        }
    }

    public ChildNodesLayout recalculateChildNodesLayout() {
        this.childNodesLayout = null;
        return this.getChildNodesLayout();
    }

    public ChildNodesLayout getChildNodesLayout() {
        this.updateLayoutProperties();
        return this.childNodesLayout;
    }

    public ChildrenSides childrenSides() {
        this.updateLayoutProperties();
        return this.childrenSides;
    }

    int getSpaceAround() {
        return this.getZoomed(50);
    }

    public int getZoomed(int x) {
        return this.map.getZoomed(x);
    }

    private void paintDecoration(Graphics2D g) {
        PaintingMode paintingMode = this.map.getPaintingMode();
        if (!(this.getMainView() != null && (paintingMode.equals((Object)PaintingMode.NODES) && !this.isSelected() || paintingMode.equals((Object)PaintingMode.SELECTED_NODES) && this.isSelected()) && this.isContentVisible())) {
            return;
        }
        Graphics2D g2 = g;
        g2.setStroke(MainView.DEF_STROKE);
        Point origin = new Point();
        UITools.convertPointToAncestor((Component)this.mainView, origin, this);
        g.translate(origin.x, origin.y);
        this.mainView.paintDecoration(this, g);
        g.translate(-origin.x, -origin.y);
        if (this.map.isSelected()) {
            HighlightController highlightController = this.getModeController().getController().getExtension(HighlightController.class);
            List<NodeHighlighter> highlighters = highlightController.getHighlighters(this.viewedNode, this.map.getMapSelection(), this.map.isPrinting());
            int margin = 4;
            for (NodeHighlighter highlighter : highlighters) {
                this.highlightNode(g, highlighter, margin += 4);
            }
        }
    }

    public void highlightNode(Graphics2D g, NodeHighlighter highlighter, int arcMargin) {
        Color oldColor = g.getColor();
        Stroke oldStroke = g.getStroke();
        g.setStroke(NodeHighlighter.DEFAULT_STROKE);
        highlighter.configure(this.getNode(), g, this.map.isPrinting());
        JComponent content = this.getContent();
        Point contentLocation = content.getLocation();
        int arcWidth = 15;
        g.drawRoundRect(contentLocation.x - arcMargin, contentLocation.y - arcMargin, content.getWidth() + 2 * arcMargin, content.getHeight() + 2 * arcMargin, 15, 15);
        g.setColor(oldColor);
        g.setStroke(oldStroke);
    }

    void remove() {
        ListIterator e = this.getChildrenViews().listIterator();
        while (e.hasNext()) {
            NodeView child = (NodeView)e.next();
            child.remove();
        }
        this.getModeController().onViewRemoved(this);
        this.removeFromMap();
        if (this.attributeView != null) {
            this.attributeView.viewRemoved();
        }
        this.getNode().removeViewer(this);
        this.map.deselect(this);
    }

    protected void removeFromMap() {
        this.setFocusCycleRoot(false);
        Container parent = this.getParent();
        parent.remove(this);
    }

    private void repaintEdge(NodeView target) {
        MainView targetMainView = target.getMainView();
        int targetEdgeWidth = target.getEdgeWidth();
        Point mainViewLocation = new Point(0, 0);
        UITools.convertPointToAncestor((Component)this.mainView, mainViewLocation, this);
        Point targetMainViewLocation = new Point(0, 0);
        UITools.convertPointToAncestor((Component)targetMainView, targetMainViewLocation, this);
        int x = Math.min(mainViewLocation.x, targetMainViewLocation.x);
        int y = Math.min(mainViewLocation.y, targetMainViewLocation.y);
        int w = Math.max(mainViewLocation.x + this.mainView.getWidth(), targetMainViewLocation.x + targetMainView.getWidth()) - x;
        int h = Math.max(mainViewLocation.y + this.mainView.getHeight(), targetMainViewLocation.y + targetMainView.getHeight()) - y;
        int EXTRA = 1 + targetEdgeWidth;
        this.repaint(x - EXTRA, y - EXTRA, w + EXTRA * 2, h + EXTRA * 2);
    }

    void repaintSelected() {
        if (this.mainView == null) {
            return;
        }
        if (this.viewedNode.getParentNode() == null && !this.viewedNode.isRoot()) {
            return;
        }
        if (this.getEdgeStyle().equals((Object)EdgeStyle.EDGESTYLE_HIDDEN)) {
            this.repaintEdge();
        }
        JComponent content = this.getContent();
        int EXTRA = 20;
        int x = content.getX() - 20;
        int y = content.getY() - 20;
        this.repaint(x, y, content.getWidth() + 40, content.getHeight() + 40);
    }

    void repaintEdge() {
        NodeView visibleParentView = this.getAncestorWithVisibleContent();
        if (visibleParentView != null) {
            visibleParentView.repaintEdge(this);
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        if (this.mainView == null) {
            return false;
        }
        if (this.mainView.requestFocusInWindow()) {
            this.map.scrollNodeToVisible(this);
            Controller.getCurrentController().getViewController().addObjectTypeInfo(this.getNode().getUserObject());
            return true;
        }
        return false;
    }

    @Override
    public void requestFocus() {
        if (this.mainView == null) {
            return;
        }
        this.map.scrollNodeToVisible(this);
        Controller.getCurrentController().getViewController().addObjectTypeInfo(this.getNode().getUserObject());
        this.mainView.requestFocus();
    }

    void setMainView(MainView newMainView) {
        if (this.contentPane != null) {
            assert (this.contentPane.getParent() == this);
            if (this.mainView != null) {
                this.removeContent(1);
            }
            this.addContent(newMainView, 1);
            assert (this.contentPane.getParent() == this);
        } else if (this.mainView != null) {
            int i;
            Container c = this.mainView.getParent();
            for (i = c.getComponentCount() - 1; i >= 0 && this.mainView != c.getComponent(i); --i) {
            }
            c.remove(i);
            c.add((Component)newMainView, i);
        } else {
            this.add(newMainView);
        }
        this.mainView = newMainView;
        ModeController modeController = this.getModeController();
        if (modeController.canEdit(this.getNode())) {
            DropTargetListener nodeDropTargetListener;
            IUserInputListenerFactory userInputListenerFactory = modeController.getUserInputListenerFactory();
            this.mainView.addMouseListener(userInputListenerFactory.getNodeMouseMotionListener());
            this.mainView.addMouseMotionListener(userInputListenerFactory.getNodeMouseMotionListener());
            this.mainView.addMouseWheelListener(userInputListenerFactory.getNodeMouseWheelListener());
            this.mainView.addKeyListener(userInputListenerFactory.getNodeKeyListener());
            DragGestureListener nodeDragListener = userInputListenerFactory.getNodeDragListener();
            if (nodeDragListener instanceof MNodeDragListener) {
                ((MNodeDragListener)nodeDragListener).addDragListener(this.mainView);
            }
            if ((nodeDropTargetListener = userInputListenerFactory.getNodeDropTargetListener()) instanceof MNodeDropListener) {
                ((MNodeDropListener)nodeDropTargetListener).addDropListener(this.mainView);
            }
        }
    }

    protected void setViewedNode(NodeModel model) {
        this.viewedNode = model;
    }

    public void setLastSelectedChild(NodeView view) {
        Container parent;
        if (view == null) {
            return;
        }
        if (!SummaryNode.isSummaryNode(view.getNode())) {
            this.lastSelectedChild = view;
        }
        if ((parent = this.getParent()) instanceof NodeView) {
            ((NodeView)parent).setLastSelectedChild(this);
        }
    }

    public void setText(String string) {
        this.mainView.setText(string);
    }

    void syncronizeAttributeView() {
        if (this.attributeView != null) {
            this.attributeView.syncronizeAttributeView();
        }
    }

    @Override
    public String toString() {
        return this.getNode().toString() + ", " + super.toString();
    }

    private void treeStructureChanged() {
        if (this.isFolded()) {
            for (NodeView child : this.getChildrenViews()) {
                child.remove();
            }
            this.map.updateSelectedNode();
            this.map.revalidateSelecteds();
        } else {
            this.addChildViews();
        }
        this.revalidate();
    }

    public void update() {
        this.update(UpdateCause.UNKNOWN);
    }

    void update(UpdateCause cause) {
        boolean textShortened;
        if (!this.map.isDisplayable()) {
            return;
        }
        this.invalidate();
        this.updateShape();
        this.updateEdge();
        this.updateCloud();
        this.mainView.updateTextColor(this);
        this.mainView.updateCss(this);
        this.mainView.updateFont(this);
        this.mainView.updateHorizontalTextAlignment(this);
        this.mainView.updateTextWritingDirection(this);
        this.mainView.updateBorder(this);
        ModeController modeController = this.getModeController();
        NodeStyleController nsc = NodeStyleController.getController(modeController);
        LogicalStyleController.StyleOption styleOption = this.getStyleOption();
        int minNodeWidth = this.map.getZoomed(nsc.getMinWidth(this.getNode(), styleOption).toBaseUnits());
        int maxNodeWidth = Math.max(this.map.getLayoutSpecificMaxNodeWidth(), this.map.getZoomed(nsc.getMaxWidth(this.getNode(), styleOption).toBaseUnits()));
        this.mainView.setMinimumWidth(minNodeWidth);
        this.mainView.setMaximumWidth(maxNodeWidth);
        this.createAttributeView();
        if (this.attributeView != null) {
            this.attributeView.update();
        }
        if (!(textShortened = this.isShortened())) {
            NodeViewFactory nodeViewFactory = NodeViewFactory.getInstance();
            nodeViewFactory.updateDetails(this, minNodeWidth, maxNodeWidth, cause);
            nodeViewFactory.updateNoteViewer(this, minNodeWidth, maxNodeWidth, cause);
        }
        if (cause != UpdateCause.SELECTION) {
            this.updateShortener(textShortened);
            this.updateIcons();
            this.mainView.updateText(this.getNode());
        }
        this.modelBackgroundColor = this.styleController().getBackgroundColor(this.viewedNode, this.getStyleOption());
        if (this.isContentVisible()) {
            this.revalidate();
            this.repaint();
        }
    }

    void updateIcons() {
        this.mainView.updateIcons(this);
        this.updateTagIcons();
    }

    private void updateTagIcons() {
        ModeController modeController = this.getMap().getModeController();
        if (TagLocation.UNDER_NODES == this.getMap().getTagLocation()) {
            final IconController iconController = IconController.getController(modeController);
            List<TagIcon> tagIcons = iconController.getTagIcons(this.viewedNode);
            MapViewIconListComponent component = (MapViewIconListComponent)this.getContent(3);
            if (component == null && tagIcons.isEmpty()) {
                return;
            }
            if (component == null) {
                DropTargetListener nodeDropTargetListener;
                component = new MapViewIconListComponent(tagIcons);
                IUserInputListenerFactory userInputListenerFactory = modeController.getUserInputListenerFactory();
                DragGestureListener nodeDragListener = userInputListenerFactory.getNodeDragListener();
                if (nodeDragListener instanceof MNodeDragListener) {
                    ((MNodeDragListener)nodeDragListener).addDragListener((IconListComponent)component);
                }
                if ((nodeDropTargetListener = userInputListenerFactory.getNodeDropTargetListener()) instanceof MNodeDropListener) {
                    ((MNodeDropListener)nodeDropTargetListener).addDropListener(component);
                }
                int margin = TAG_INDENT.toBaseUnitsRounded();
                component.setBorder(new ZoomedEmptyBorder(0, margin, 0, margin, this.map::getZoomed));
                if (iconController instanceof MIconController) {
                    component.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            if (e.getClickCount() == 2) {
                                ((MIconController)iconController).editTags(NodeView.this.viewedNode);
                            }
                        }
                    });
                }
                this.addContent(component, 3);
            } else {
                if (tagIcons.isEmpty()) {
                    this.removeContent(3);
                    return;
                }
                component.setIcons(tagIcons);
            }
            ComponentOrientation componentOrientation = this.mainView.getComponentOrientation();
            component.setComponentOrientation(componentOrientation);
            component.setHorizontalAlignment(this.mainView.getHorizontalAlignment());
            HorizontalTextAlignment tagComponentAlignment = iconController.getTagComponentAlignment(this.viewedNode);
            component.setAlignmentX(tagComponentAlignment == HorizontalTextAlignment.LEFT ? 0.0f : (tagComponentAlignment == HorizontalTextAlignment.CENTER ? 0.5f : (tagComponentAlignment == HorizontalTextAlignment.RIGHT ? 1.0f : (componentOrientation.isLeftToRight() ? 0.0f : (componentOrientation.isHorizontal() ? 1.0f : 0.5f)))));
            component.setSize(this.mainView.getMaximumWidth(), 0);
        } else {
            this.removeContent(3);
        }
    }

    private ModeController getModeController() {
        return this.map.getModeController();
    }

    public boolean isShortened() {
        ModeController modeController = this.getModeController();
        TextController textController = TextController.getController(modeController);
        boolean textShortened = textController.isMinimized(this.getNode());
        return textShortened;
    }

    private void updateEdge() {
        EdgeController edgeController = EdgeController.getController(this.getModeController());
        EdgeStyle newEdgeStyle = edgeController.getStyle(this.viewedNode, this.getStyleOption(), false);
        NodeModel realNode = SummaryNode.getRealNode(this.viewedNode);
        Integer newEdgeWidth = edgeController.getWidth(realNode, this.getStyleOption(), false);
        Dash newEdgeDash = edgeController.getDash(realNode, this.getStyleOption(), false);
        ObjectRule<Color, EdgeController.Rules> newColor = edgeController.getColorRule(realNode, this.getStyleOption());
        if (newEdgeStyle != this.edgeStyle || !Objects.equals(newEdgeWidth, this.edgeWidth) || newEdgeDash != this.edgeDash || !Objects.equals(newColor, this.edgeColor)) {
            NodeView ancestorWithVisibleContent;
            this.edgeStyle = newEdgeStyle;
            this.edgeWidth = newEdgeWidth;
            this.edgeDash = newEdgeDash;
            this.edgeColor = newColor;
            if (!this.isRoot() && (ancestorWithVisibleContent = this.getAncestorWithVisibleContent()) != null) {
                ancestorWithVisibleContent.repaint();
            }
        }
        NodeModel parentNode = this.viewedNode.getParentNode();
        if (!this.isRoot() && parentNode != null && SummaryNode.isSummaryNode(parentNode)) {
            this.getParentView().updateEdge();
        }
    }

    public EdgeStyle getEdgeStyle() {
        if (this.edgeStyle != null) {
            return this.edgeStyle;
        }
        NodeView parentView = this.getParentNodeView();
        if (parentView != null) {
            return parentView.getEdgeStyle();
        }
        return EdgeStyle.values()[0];
    }

    public Dash getEdgeDash() {
        if (this.edgeDash != null) {
            return this.edgeDash;
        }
        NodeView parentView = this.getParentNodeView();
        if (parentView != null) {
            return parentView.getEdgeDash();
        }
        return Dash.DEFAULT;
    }

    public int getEdgeWidth() {
        if (this.edgeWidth != null) {
            return this.edgeWidth;
        }
        NodeView parentView = this.getParentNodeView();
        if (parentView != null) {
            return parentView.getEdgeWidth();
        }
        return 1;
    }

    public Color getEdgeColor() {
        NodeView parentView;
        if (this.edgeColor.hasValue()) {
            return this.edgeColor.getValue();
        }
        EdgeController.Rules rule = this.edgeColor.getRule();
        if (rule == EdgeController.Rules.BY_COLUMN) {
            Color color = new AutomaticEdgeStyle(this).getColor();
            this.edgeColor.setCache(color);
            return color;
        }
        NodeModel parentNode = this.viewedNode.getParentNode();
        if (rule == EdgeController.Rules.BY_BRANCH && parentNode.isRoot() || rule == EdgeController.Rules.BY_LEVEL) {
            int index = rule == EdgeController.Rules.BY_BRANCH ? parentNode.getIndex(this.viewedNode) + 1 : this.viewedNode.getNodeLevel(this.map.getFilter()) + (this.viewedNode.isHiddenSummary() ? 1 : 0);
            MapModel mapModel = this.map.getMap();
            ModeController modeController = this.getModeController();
            EdgeController edgeController = modeController.getExtension(EdgeController.class);
            if (edgeController.areEdgeColorsAvailable(mapModel)) {
                Color color = edgeController.getEdgeColor(mapModel, index);
                this.edgeColor.setCache(color);
                return color;
            }
        } else if (rule == EdgeController.Rules.BY_PARENT && (parentView = this.getParentNodeView()) != null) {
            Color color = parentView.getEdgeColor();
            return color;
        }
        return Color.GRAY;
    }

    private void updateCloud() {
        CloudModel cloudModel = CloudController.getController(this.getModeController()).getCloud(this.viewedNode, this.getStyleOption());
        this.putClientProperty(CloudModel.class, cloudModel);
    }

    public CloudModel getCloudModel() {
        return (CloudModel)this.getClientProperty(CloudModel.class);
    }

    private void updateShortener(boolean textShortened) {
        boolean componentsVisible = !textShortened;
        this.setContentComponentsVisible(componentsVisible);
    }

    private void setContentComponentsVisible(boolean componentsVisible) {
        if (this.contentPane == null) {
            return;
        }
        Component[] components = this.getContentPane().getComponents();
        for (int index = 0; index < components.length; ++index) {
            Component component = components[index];
            if (!component.isValid()) {
                component.revalidate();
            }
            if (component == this.getMainView() || component instanceof MapViewIconListComponent && MapView.showsTagsOnMinimizedNodes() || component.isVisible() == componentsVisible) continue;
            component.setVisible(componentsVisible);
        }
    }

    public void updateAll() {
        this.update();
        this.invalidate();
        for (NodeView child : this.getChildrenViews()) {
            child.updateAll();
        }
    }

    void resetLayoutPropertiesRecursively() {
        this.childNodesAlignment = null;
        this.childNodesLayout = null;
        LinkedList<NodeView> childrenViews = this.getChildrenViews();
        if (childrenViews.isEmpty()) {
            this.invalidate();
        }
        for (NodeView child : childrenViews) {
            child.resetLayoutPropertiesRecursively();
        }
    }

    private void updateLayoutProperties() {
        if (this.childNodesLayout == null) {
            this.updateSide();
            LayoutController layoutController = this.getModeController().getExtension(LayoutController.class);
            this.childNodesLayout = layoutController.getEffectiveChildNodesLayout(this.viewedNode);
            this.updateLayoutOrientation();
            this.updateChildNodesAlignment();
            this.updateChildrenSides();
            this.childNodesLayout = ChildNodesLayout.using((LayoutOrientation)this.layoutOrientation, (ChildrenSides)this.childrenSides, (ChildNodesAlignment)this.childNodesAlignment).orElse(this.childNodesLayout);
        }
    }

    @Override
    public boolean hasStandardLayoutWithRootNode(NodeModel root) {
        return this.map.getLayoutType() == MapViewLayout.MAP && this.map.getRoot().getNode().equals(root);
    }

    private void updateChildrenSides() {
        ChildrenSides childrenSidesByLayout;
        ChildrenSides childrenSides = this.map.getLayoutType() == MapViewLayout.OUTLINE ? ChildrenSides.BOTTOM_OR_RIGHT : (this.viewedNode.isRoot() && this.childNodesLayout.childNodesAlignment() == ChildNodesAlignment.STACKED_AUTO ? ChildrenSides.BOTH_SIDES : ((childrenSidesByLayout = this.childNodesLayout.childrenSides()) == ChildrenSides.TOP_OR_LEFT || childrenSidesByLayout == ChildrenSides.BOTTOM_OR_RIGHT || childrenSidesByLayout == ChildrenSides.BOTH_SIDES ? childrenSidesByLayout : (this.isRoot() ? ChildrenSides.BOTH_SIDES : (this.childNodesAlignment.isStacked() && (childrenSidesByLayout == ChildrenSides.DIAGONAL_ASCENDING || childrenSidesByLayout == ChildrenSides.DIAGONAL_DESCENDING) ? (childrenSidesByLayout == ChildrenSides.DIAGONAL_ASCENDING == (this.childNodesAlignment == ChildNodesAlignment.AFTER_PARENT) ? ChildrenSides.TOP_OR_LEFT : ChildrenSides.BOTTOM_OR_RIGHT) : (this.side == NodeModel.Side.TOP_OR_LEFT ? ChildrenSides.TOP_OR_LEFT : ChildrenSides.BOTTOM_OR_RIGHT)))));
        this.childrenSides = childrenSides;
    }

    private void updateSide() {
        NodeModel.Side side;
        NodeView parent;
        ChildrenSides childrenSides;
        boolean isTopOrLeft = this.map.getLayoutType() == MapViewLayout.OUTLINE || this.viewedNode.isRoot() ? false : ((childrenSides = (parent = this.getParentNodeView()).childrenSides()) == ChildrenSides.TOP_OR_LEFT ? true : (childrenSides == ChildrenSides.BOTTOM_OR_RIGHT ? false : (parent.isRoot() || childrenSides == ChildrenSides.BOTH_SIDES ? ((side = this.viewedNode.getSide()) != NodeModel.Side.DEFAULT ? side == NodeModel.Side.TOP_OR_LEFT : parent.getNode().isTopOrLeft(this.viewedNode.getMap().getRootNode())) : parent.isTopOrLeft())));
        this.side = isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT;
    }

    private void updateShape() {
        if (this.mainView != null) {
            NodeViewFactory.getInstance().updateViewPainter(this);
        } else {
            MainView newMainView = NodeViewFactory.getInstance().newMainView(this);
            this.setMainView(newMainView);
            if (this.map.getSelected() == this) {
                this.requestFocusInWindow();
            }
        }
    }

    boolean useSelectionColors() {
        return this.isSelected() && !MapView.drawsRectangleForSelection() && !this.map.isPrinting();
    }

    @Override
    protected void validateTree() {
        super.validateTree();
    }

    public void addContent(JComponent component, int pos) {
        component.putClientProperty("NODE_VIEW_CONTENT_POSITION", pos);
        JComponent contentPane = this.getContentPane();
        for (int i = 0; i < contentPane.getComponentCount(); ++i) {
            JComponent content = (JComponent)contentPane.getComponent(i);
            if (content == null) {
                throw new RuntimeException("component " + i + "is null");
            }
            Object clientProperty = content.getClientProperty("NODE_VIEW_CONTENT_POSITION");
            if (clientProperty == null) {
                throw new RuntimeException("NODE_VIEW_CONTENT_POSITION not set on component " + content.toString() + i + "/" + contentPane.getComponentCount());
            }
            if (pos >= (Integer)clientProperty) continue;
            contentPane.add((Component)component, i);
            return;
        }
        contentPane.add(component);
    }

    public JComponent removeContent(int pos) {
        return this.removeContent(pos, true);
    }

    private JComponent removeContent(int pos, boolean remove) {
        if (this.contentPane == null) {
            return null;
        }
        for (int i = 0; i < this.contentPane.getComponentCount(); ++i) {
            JComponent component = (JComponent)this.contentPane.getComponent(i);
            Integer contentPos = (Integer)component.getClientProperty("NODE_VIEW_CONTENT_POSITION");
            if (contentPos == null) continue;
            if (contentPos == pos) {
                if (remove) {
                    component.putClientProperty("NODE_VIEW_CONTENT_POSITION", null);
                    this.contentPane.remove(i);
                }
                return component;
            }
            if (contentPos <= pos) continue;
            return null;
        }
        return null;
    }

    public JComponent getContent(int pos) {
        return this.removeContent(pos, false);
    }

    public boolean isSummary() {
        return SummaryNode.isSummaryNode(this.getNode());
    }

    public boolean isFirstGroupNode() {
        return SummaryNode.isFirstGroupNode(this.getNode());
    }

    public boolean isFree() {
        return FreeNode.isFreeNode(this.getNode());
    }

    @Override
    public void setBounds(int x, int y, int width, int height) {
        if (x != this.getX() || y != this.getY() || width != this.getWidth() || height != this.getHeight()) {
            EdgeController.Rules rule = this.edgeColor.getRule();
            if (EdgeController.Rules.BY_PARENT != rule) {
                this.edgeColor.resetCache();
            }
            this.repaintEdge();
        }
        super.setBounds(x, y, width, height);
    }

    boolean isSubtreeVisible() {
        if (this.isValid()) {
            return this.getHeight() > 2 * this.getSpaceAround();
        }
        if (this.isContentVisible()) {
            return true;
        }
        Component[] components = this.getComponents();
        for (int i = 0; i < components.length; ++i) {
            NodeView view;
            if (!(components[i] instanceof NodeView) || !(view = (NodeView)components[i]).isSubtreeVisible()) continue;
            return true;
        }
        return false;
    }

    boolean isChildHidden(NodeModel node) {
        Set hiddenChildren = (Set)this.getClientProperty((Object)Properties.HIDDEN_CHILDREN);
        return hiddenChildren != null && hiddenChildren.contains(node);
    }

    public int getHiddenChildCount() {
        Set hiddenChildren = (Set)this.getClientProperty((Object)Properties.HIDDEN_CHILDREN);
        return hiddenChildren != null ? hiddenChildren.size() : 0;
    }

    boolean hasHiddenChildren() {
        Set hiddenChildren = (Set)this.getClientProperty((Object)Properties.HIDDEN_CHILDREN);
        return hiddenChildren != null && !hiddenChildren.isEmpty();
    }

    boolean unfoldHiddenChildren() {
        boolean hasHiddenChildren = this.hasHiddenChildren();
        this.putClientProperty((Object)Properties.HIDDEN_CHILDREN, null);
        return hasHiddenChildren;
    }

    public void hideChildren(NodeModel node) {
        HashSet<NodeModel> set = new HashSet<NodeModel>();
        set.addAll(node.getChildren());
        this.putClientProperty((Object)Properties.HIDDEN_CHILDREN, set);
    }

    public boolean showHiddenNode(NodeModel node) {
        Set hiddenChildren = (Set)this.getClientProperty((Object)Properties.HIDDEN_CHILDREN);
        return hiddenChildren != null && hiddenChildren.remove(node);
    }

    public Rectangle getInnerBounds() {
        int spaceAround = this.getSpaceAround();
        if (this.isContentVisible()) {
            return new Rectangle(spaceAround, spaceAround, this.getWidth() - 2 * spaceAround, this.getHeight() - 2 * spaceAround);
        }
        Rectangle innerBounds = new Rectangle(spaceAround, spaceAround, -1, -1);
        this.getChildrenViews().stream().map(v -> {
            Rectangle r = v.getInnerBounds();
            r.x += v.getX();
            r.y += v.getY();
            return r;
        }).forEach(innerBounds::add);
        innerBounds.y = spaceAround;
        innerBounds.width = Math.max(0, innerBounds.width);
        innerBounds.height = this.getHeight() - 2 * spaceAround;
        return innerBounds;
    }

    public LogicalStyleController.StyleOption getStyleOption() {
        return this.useSelectionColors() ? LogicalStyleController.StyleOption.FOR_SELECTED_NODE : LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE;
    }

    NodeViewLayoutHelper getLayoutHelper() {
        return this.layoutHelper;
    }

    public boolean usesHorizontalLayout() {
        return this.layoutOrientation() == LayoutOrientation.LEFT_TO_RIGHT;
    }

    public LayoutOrientation layoutOrientation() {
        this.updateLayoutProperties();
        return this.layoutOrientation;
    }

    private void updateLayoutOrientation() {
        if (this.map.isOutlineLayoutSet()) {
            this.layoutOrientation = LayoutOrientation.TOP_TO_BOTTOM;
        } else {
            LayoutOrientation layoutOrientation = this.childNodesLayout.layoutOrientation();
            switch (layoutOrientation) {
                case TOP_TO_BOTTOM: 
                case LEFT_TO_RIGHT: {
                    this.layoutOrientation = layoutOrientation;
                    break;
                }
                default: {
                    NodeView parent = this.getParentNodeView();
                    this.layoutOrientation = parent != null ? parent.layoutOrientation() : LayoutOrientation.TOP_TO_BOTTOM;
                }
            }
        }
    }

    boolean paintsChildrenOnTheLeft() {
        if (this.usesHorizontalLayout()) {
            return false;
        }
        return this.paintsChildrenOnTopOrLeft();
    }

    boolean paintsChildrenOnTopOrLeft() {
        boolean paintsChildrenOnBothSides;
        ChildrenSides childrenSides = this.childrenSides();
        boolean bl = paintsChildrenOnBothSides = childrenSides == ChildrenSides.BOTH_SIDES || this.isRoot();
        return paintsChildrenOnBothSides ? false : (childrenSides == ChildrenSides.BOTTOM_OR_RIGHT ? false : (childrenSides == ChildrenSides.TOP_OR_LEFT ? true : this.isTopOrLeft()));
    }

    @Override
    public void revalidate() {
        super.revalidate();
        this.map.repaintVisible();
    }

    static {
        ADDITIONAL_MOUSE_SENSITIVE_AREA = 50;
        boolean paintDebugInfo = false;
        try {
            paintDebugInfo = Boolean.getBoolean("org.freeplane.view.swing.map.NodeView.PAINT_DEBUG_INFO");
        }
        catch (Exception exception) {
            // empty catch block
        }
        PAINT_DEBUG_INFO = paintDebugInfo;
    }

    static enum PreferredChild {
        LAST_SELECTED,
        FIRST,
        LAST,
        NEAREST_SIBLING;

    }

    public static enum Properties {
        HIDDEN_CHILDREN;

    }
}

