/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.map;

import java.security.AccessController;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.freeplane.api.ChildrenSides;
import org.freeplane.core.extension.ExtensionContainer;
import org.freeplane.core.extension.IExtension;
import org.freeplane.core.util.HtmlUtils;
import org.freeplane.features.filter.Filter;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.layout.LayoutController;
import org.freeplane.features.map.AlwaysUnfoldedNode;
import org.freeplane.features.map.CloneEncryptedNodeException;
import org.freeplane.features.map.Cloner;
import org.freeplane.features.map.Clones;
import org.freeplane.features.map.DetachedNodeList;
import org.freeplane.features.map.EncryptionModel;
import org.freeplane.features.map.HistoryInformationModel;
import org.freeplane.features.map.IMapChangeListener;
import org.freeplane.features.map.INodeChangeListener;
import org.freeplane.features.map.INodeView;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeChangeEvent;
import org.freeplane.features.map.NodeDeletionEvent;
import org.freeplane.features.map.NodeIconSetModel;
import org.freeplane.features.map.NodeMoveEvent;
import org.freeplane.features.map.SharedNodeData;
import org.freeplane.features.map.SummaryNode;
import org.freeplane.features.ui.INodeViewVisitor;

public class NodeModel {
    static final int TREE_CLONE_INDEX = CloneType.TREE.ordinal();
    static final int CONTENT_CLONE_INDEX = CloneType.CONTENT.ordinal();
    private static final boolean ALLOWSCHILDREN = true;
    public static final String NODE_TEXT = "node_text";
    public static final String NOTE_TEXT = "note_text";
    public static final Object UNKNOWN_PROPERTY = NodeProperty.UNKNOWN_PROPERTY;
    public static final String NODE_ICON = "icon";
    public static final String NODE_ICON_SIZE = "icon_size";
    public static final Object HYPERLINK_CHANGED = "hyperlink_changed";
    private List<NodeModel> children;
    private NodeModel parent;
    private String id;
    private boolean folded;
    private MapModel map = null;
    private Side side;
    private Collection<INodeView> views = null;
    private SharedNodeData sharedData;
    private Clones[] clones;

    void setClones(Clones clones) {
        this.clones[clones.getCloneType().ordinal()] = clones;
        for (NodeModel clone : clones) {
            clone.fireNodeChanged(new NodeChangeEvent(this, UNKNOWN_PROPERTY, null, null, false, false));
        }
    }

    public Object getUserObject() {
        return this.sharedData.getUserObject();
    }

    public NodeModel(MapModel map) {
        this("", map);
    }

    public NodeModel(Object userObject, MapModel map) {
        this.map = map;
        this.children = new ArrayList<NodeModel>();
        this.sharedData = new SharedNodeData();
        this.side = Side.DEFAULT;
        this.init(userObject);
        this.clones = new Clones[]{new DetachedNodeList(this, CloneType.TREE), new DetachedNodeList(this, CloneType.CONTENT)};
        this.folded = false;
    }

    private NodeModel(NodeModel toBeCloned, CloneType cloneType) {
        this.map = toBeCloned.map;
        this.sharedData = toBeCloned.sharedData;
        this.children = new ArrayList<NodeModel>();
        this.clones = new Clones[]{new DetachedNodeList(this, cloneType == CloneType.TREE ? toBeCloned : this, CloneType.TREE), new DetachedNodeList(this, toBeCloned, CloneType.CONTENT)};
        this.side = Side.DEFAULT;
        this.folded = toBeCloned.folded;
    }

    protected void init(Object userObject) {
        this.setUserObject(userObject);
        this.setHistoryInformation(new HistoryInformationModel());
    }

    public void acceptViewVisitor(INodeViewVisitor visitor) {
        if (this.views == null) {
            return;
        }
        for (INodeView view : this.views) {
            visitor.visit(view);
        }
    }

    public void addExtension(IExtension extension) {
        this.getExtensionContainer().addExtension(extension);
    }

    public IExtension putExtension(IExtension extension) {
        return this.getExtensionContainer().putExtension(extension);
    }

    public IExtension putExtension(Class<? extends IExtension> clazz, IExtension extension) {
        return this.getExtensionContainer().putExtension(clazz, extension);
    }

    public void addIcon(NamedIcon icon) {
        this.getIconModel().addIcon(icon);
        if (this.map != null) {
            this.map.getIconRegistry().addIcon(icon);
        }
    }

    public void addIcon(NamedIcon icon, int position) {
        this.getIconModel().addIcon(icon, position);
        this.getMap().getIconRegistry().addIcon(icon);
    }

    public void addViewer(INodeView viewer) {
        this.getViewers().add(viewer);
    }

    public boolean areViewsEmpty() {
        return this.views == null || this.views.isEmpty();
    }

    protected List<NodeModel> getChildrenInternal() {
        return this.children;
    }

    protected void setChildrenInternal(List<NodeModel> chidren) {
        this.children = chidren;
    }

    public Enumeration<NodeModel> children() {
        final Iterator<NodeModel> i = this.getChildrenInternal().iterator();
        return new Enumeration<NodeModel>(){

            @Override
            public boolean hasMoreElements() {
                return i.hasNext();
            }

            @Override
            public NodeModel nextElement() {
                return (NodeModel)i.next();
            }
        };
    }

    public boolean containsExtension(Class<? extends IExtension> clazz) {
        return this.getExtensionContainer().containsExtension(clazz);
    }

    public String createID() {
        if (this.id == null) {
            this.id = this.getMap().registryNode(this);
        }
        return this.id;
    }

    void fireNodeInserted(IMapChangeListener[] list, NodeModel child, int index) {
        AccessController.doPrivileged(() -> {
            for (IMapChangeListener next : list) {
                next.onNodeInserted(this, child, index);
            }
            this.fireNodeInserted(child, index);
            return null;
        });
    }

    private void fireNodeInserted(NodeModel child, int index) {
        if (this.views == null) {
            return;
        }
        Iterator<INodeView> iterator = this.views.iterator();
        while (iterator.hasNext()) {
            iterator.next().onNodeInserted(this, child, index);
        }
    }

    void fireNodeChanged(INodeChangeListener[] nodeChangeListeners, NodeChangeEvent nodeChangeEvent) {
        AccessController.doPrivileged(() -> {
            for (NodeModel node : this.clones[CloneType.CONTENT.ordinal()]) {
                NodeChangeEvent cloneEvent = nodeChangeEvent.forNode(node);
                node.fireSingleNodeChanged(nodeChangeListeners, cloneEvent);
            }
            return null;
        });
    }

    private void fireSingleNodeChanged(INodeChangeListener[] nodeChangeListeners, NodeChangeEvent nodeChangeEvent) {
        for (INodeChangeListener listener : nodeChangeListeners) {
            listener.nodeChanged(nodeChangeEvent);
        }
        this.fireNodeChanged(nodeChangeEvent);
    }

    public void fireNodeChanged(NodeChangeEvent nodeChangeEvent) {
        if (this.views == null) {
            return;
        }
        AccessController.doPrivileged(() -> {
            Iterator<INodeView> iterator = new ArrayList<INodeView>(this.views).iterator();
            while (iterator.hasNext()) {
                iterator.next().nodeChanged(nodeChangeEvent);
            }
            return null;
        });
    }

    static void fireNodeMoved(IMapChangeListener[] list, NodeMoveEvent nodeMoveEvent) {
        AccessController.doPrivileged(() -> {
            NodeDeletionEvent nodeDeletionEvent = new NodeDeletionEvent(nodeMoveEvent.oldParent, nodeMoveEvent.child, nodeMoveEvent.oldIndex);
            nodeMoveEvent.oldParent.fireNodeRemoved(nodeDeletionEvent);
            for (IMapChangeListener next : list) {
                next.onNodeMoved(nodeMoveEvent);
            }
            nodeMoveEvent.newParent.fireNodeInserted(nodeMoveEvent.child, nodeMoveEvent.newIndex);
            return null;
        });
    }

    void fireNodeRemoved(IMapChangeListener[] list, NodeDeletionEvent nodeDeletionEvent) {
        AccessController.doPrivileged(() -> {
            this.fireNodeRemoved(nodeDeletionEvent);
            for (IMapChangeListener next : list) {
                next.onNodeDeleted(nodeDeletionEvent);
            }
            return null;
        });
    }

    private void fireNodeRemoved(NodeDeletionEvent nodeDeletionEvent) {
        if (this.views == null) {
            return;
        }
        Iterator<INodeView> iterator = this.views.iterator();
        while (iterator.hasNext()) {
            iterator.next().onNodeDeleted(nodeDeletionEvent);
        }
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public NodeModel getChildAt(int childIndex) {
        return childIndex >= 0 ? this.getChildrenInternal().get(childIndex) : null;
    }

    public int getChildCount() {
        if (this.getChildrenInternal() == null) {
            return 0;
        }
        return this.getChildrenInternal().size();
    }

    public List<NodeModel> getChildren() {
        List<Object> childrenList = this.getChildrenInternal() != null ? this.getChildrenInternal() : Collections.emptyList();
        return Collections.unmodifiableList(childrenList);
    }

    public <T extends IExtension> T getExtension(Class<T> clazz) {
        return this.getExtensionContainer().getExtension(clazz);
    }

    public Map<Class<? extends IExtension>, IExtension> getSharedExtensions() {
        return this.getExtensionContainer().getExtensions();
    }

    public HistoryInformationModel getHistoryInformation() {
        return this.sharedData.getHistoryInformation();
    }

    public NamedIcon getIcon(int position) {
        return this.getIconModel().getIcon(position);
    }

    public List<NamedIcon> getIcons() {
        return this.getIconModel().getIcons();
    }

    public String getID() {
        return this.id;
    }

    public int getIndex(NodeModel node) {
        return this.children.indexOf(node);
    }

    public MapModel getMap() {
        return this.map;
    }

    public int getNodeLevel() {
        return this.getNodeLevel(true, null);
    }

    public int getNodeLevel(Filter filter) {
        return this.getNodeLevel(false, filter);
    }

    private int getNodeLevel(boolean countHidden, Filter filter) {
        int level = 0;
        for (NodeModel parent = this.getParentNode(); parent != null; parent = parent.getParentNode()) {
            if (!countHidden && !parent.isVisible(filter)) continue;
            ++level;
        }
        return level;
    }

    public NodeModel getParentNode() {
        return this.parent;
    }

    public NodeModel[] getPathToRoot() {
        int i = this.getNodeLevel();
        NodeModel[] path = new NodeModel[i + 1];
        NodeModel node = this;
        while (i >= 0) {
            path[i--] = node;
            node = node.getParentNode();
        }
        return path;
    }

    public String getText() {
        String string = "";
        if (this.getUserObject() != null) {
            string = this.getUserObject().toString();
        }
        return string;
    }

    public Collection<INodeView> getViewers() {
        if (this.views == null) {
            this.views = new LinkedList<INodeView>();
        }
        return this.views;
    }

    public boolean hasViewers() {
        return this.views != null && !this.views.isEmpty();
    }

    public final String getXmlText() {
        return this.sharedData.getXmlText();
    }

    public boolean hasChildren() {
        return this.getChildCount() != 0;
    }

    public boolean hasID() {
        return this.id != null;
    }

    public void insert(NodeModel child, int index) {
        if (index < 0) {
            index = this.getChildCount();
            this.children.add(index, child);
        } else {
            this.children.add(index, child);
        }
        child.setParent(this);
    }

    private boolean isAccessible() {
        EncryptionModel encryptionModel = EncryptionModel.getModel(this);
        return encryptionModel == null || encryptionModel.isAccessible();
    }

    public boolean isDescendantOf(NodeModel node) {
        if (this.parent == null) {
            return false;
        }
        if (node == this.parent) {
            return true;
        }
        return this.parent.isDescendantOf(node);
    }

    public boolean isFolded() {
        return this.folded || !this.isAccessible();
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isTopOrLeft(NodeModel root) {
        NodeModel parentNode = this.getParentNode();
        return this.wouldBeTopOrLeft(root, parentNode);
    }

    public boolean wouldBeTopOrLeft(NodeModel root, NodeModel parent) {
        ChildrenSides childrenSides;
        if (parent == null) {
            return false;
        }
        if (this.views != null) {
            for (INodeView view : this.views) {
                if (!view.hasStandardLayoutWithRootNode(root)) continue;
                return view.isTopOrLeft();
            }
        }
        if ((childrenSides = LayoutController.getController().getEffectiveChildNodesLayout(parent).childrenSides()) == ChildrenSides.TOP_OR_LEFT) {
            return true;
        }
        if (childrenSides == ChildrenSides.BOTTOM_OR_RIGHT) {
            return false;
        }
        if (parent == root || childrenSides == ChildrenSides.BOTH_SIDES) {
            if (this.side != Side.DEFAULT) {
                return this.side == Side.TOP_OR_LEFT;
            }
            return parent.isTopOrLeft(parent.getMap().getRootNode());
        }
        return parent.isTopOrLeft(root);
    }

    public Side suggestNewChildSide(NodeModel root) {
        return LayoutController.getController().suggestNewChildSide(this, root);
    }

    public boolean isRoot() {
        return this.getMap().getRootNode() == this;
    }

    public boolean hasVisibleContent(Filter filter) {
        return !this.isHiddenSummary() && this.satisfies(filter);
    }

    private boolean satisfies(Filter filter) {
        return filter == null || filter.isVisible(this);
    }

    public boolean isHiddenSummary() {
        return SummaryNode.isHidden(this);
    }

    public boolean isVisible(Filter filter) {
        return this.isHiddenSummary() || this.satisfies(filter);
    }

    public void remove(int index) {
        NodeModel child = this.children.get(index);
        this.firePreNodeDeleted(child, index);
        child.setParent(null);
        this.children.remove(index);
    }

    private void firePreNodeDeleted(NodeModel child, int index) {
        if (this.views != null && this.views.size() > 0) {
            NodeDeletionEvent nodeDeletionEvent = new NodeDeletionEvent(this, child, index);
            for (INodeView view : this.views) {
                view.onPreNodeDeleted(nodeDeletionEvent);
            }
        }
    }

    public <T extends IExtension> T removeExtension(Class<T> clazz) {
        return this.getExtensionContainer().removeExtension(clazz);
    }

    public boolean removeExtension(IExtension extension) {
        return this.getExtensionContainer().removeExtension(extension);
    }

    public int removeIcon() {
        return this.getIconModel().removeIcon();
    }

    public int removeIcon(int position) {
        return this.getIconModel().removeIcon(position);
    }

    public void removeViewer(INodeView viewer) {
        this.getViewers().remove(viewer);
    }

    public void setFolded(boolean folded) {
        boolean wasFoldingFlagSet = this.folded;
        boolean wasFolded = this.isFolded();
        if (wasFoldingFlagSet != folded && this.isAccessible()) {
            this.folded = folded && !AlwaysUnfoldedNode.isAlwaysUnfolded(this);
        }
        boolean isFoldedNow = this.isFolded();
        this.fireNodeChanged(new NodeChangeEvent(this, (Object)NodeChangeType.FOLDING, wasFolded, isFoldedNow, false, false));
    }

    public void setHistoryInformation(HistoryInformationModel historyInformation) {
        this.sharedData.setHistoryInformation(historyInformation);
    }

    public void setID(String value) {
        this.id = value;
        this.getMap().registryID(value, this);
    }

    public void setSide(Side side) {
        if (this.isCloneTreeNode()) {
            for (NodeModel node : this.clones[CloneType.TREE.ordinal()]) {
                node.side = side;
            }
        } else {
            this.side = side;
        }
    }

    public void setChildNodeSidesAsNow() {
        this.children.forEach(child -> {
            if (child.getSide() == Side.DEFAULT) {
                child.setSide(child.isTopOrLeft(this) ? Side.TOP_OR_LEFT : Side.BOTTOM_OR_RIGHT);
            }
        });
    }

    public void setMap(MapModel map) {
        this.map = map;
        for (NodeModel child : this.children) {
            child.setMap(map);
        }
    }

    public void setParent(NodeModel newParent) {
        if (this.parent == null && newParent != null && newParent.isAttached()) {
            this.attach();
        } else if (this.parent != null && this.parent.isAttached() && (newParent == null || !newParent.isAttached()) || newParent == null && this.isAttached()) {
            this.detach();
        }
        this.parent = newParent;
    }

    void attach() {
        this.attachClones();
        for (NodeModel child : this.children) {
            child.attach();
        }
    }

    private void attachClones() {
        for (Clones clonesGroup : this.clones) {
            clonesGroup.attach();
        }
    }

    private void detach() {
        this.detachClones();
        for (NodeModel child : this.children) {
            child.detach();
        }
    }

    private void detachClones() {
        for (Clones clonesGroup : this.clones) {
            clonesGroup.detach(this);
        }
    }

    boolean isAttached() {
        return this.clones[0].size() != 0;
    }

    public final void setText(String text) {
        this.sharedData.setText(text);
    }

    public final void setUserObject(Object data) {
        this.sharedData.setUserObject(data);
    }

    public final void setXmlText(String pXmlText) {
        this.sharedData.setXmlText(pXmlText);
    }

    public String toString() {
        return HtmlUtils.htmlToPlain(this.getText());
    }

    public int depth() {
        NodeModel parentNode = this.getParentNode();
        if (parentNode == null) {
            return 0;
        }
        return parentNode.depth() + 1;
    }

    public void insert(NodeModel newNodeModel) {
        this.insert(newNodeModel, this.getChildCount());
    }

    public NodeModel getVisibleAncestorOrSelf(Filter filter) {
        NodeModel node = this;
        while (!node.hasVisibleContent(filter)) {
            node = node.getParentNode();
        }
        return node;
    }

    private ExtensionContainer getExtensionContainer() {
        return this.sharedData.getExtensionContainer();
    }

    private NodeIconSetModel getIconModel() {
        return this.sharedData.getIcons();
    }

    public NodeModel cloneTree() {
        NodeModel clone = new Cloner(this).cloneTree();
        return clone;
    }

    public NodeModel cloneContent() {
        if (this.containsExtension(EncryptionModel.class)) {
            throw new CloneEncryptedNodeException();
        }
        return this.cloneNode(CloneType.CONTENT);
    }

    protected NodeModel cloneNode(CloneType cloneType) {
        NodeModel clone = new NodeModel(this, cloneType);
        return clone;
    }

    public SharedNodeData getSharedData() {
        return this.sharedData;
    }

    public Collection<IExtension> getIndividualExtensionValues() {
        return Collections.emptyList();
    }

    public void convertToClone(NodeModel node, CloneType cloneType) {
        this.sharedData = node.sharedData;
        if (cloneType == CloneType.TREE) {
            this.clones[CloneType.TREE.ordinal()] = new DetachedNodeList(this, node, CloneType.TREE);
        }
        this.clones[CloneType.CONTENT.ordinal()] = new DetachedNodeList(this, node, CloneType.CONTENT);
    }

    public Clones subtreeClones() {
        return this.clones(CloneType.TREE);
    }

    public Clones allClones() {
        return this.clones(CloneType.CONTENT);
    }

    Clones clones(CloneType cloneType) {
        return this.clones[cloneType.ordinal()];
    }

    public boolean subtreeContainsCloneOf(NodeModel node) {
        for (NodeModel clone : node.subtreeClones()) {
            if (!this.equals(clone)) continue;
            return true;
        }
        for (NodeModel child : this.children) {
            if (!child.subtreeContainsCloneOf(node)) continue;
            return true;
        }
        return false;
    }

    public boolean isSubtreeCloneOf(NodeModel ancestorClone) {
        return this.subtreeClones().contains(ancestorClone);
    }

    public NodeModel getSubtreeRootOrContentClone() {
        if (this.isSubtreeRootOrContentClone()) {
            return this;
        }
        return this.getParentNode().getSubtreeRootOrContentClone();
    }

    public boolean isCloneTreeRoot() {
        return this.parent != null && this.parent.clones[TREE_CLONE_INDEX].size() < this.clones[TREE_CLONE_INDEX].size();
    }

    public boolean isCloneContentNodeOutsideCloneTree() {
        return this.clones[TREE_CLONE_INDEX].size() == 1 && this.clones[CONTENT_CLONE_INDEX].size() > 1;
    }

    private boolean isSubtreeRootOrContentClone() {
        return this.parent == null || this.isCloneTreeRootOrContentClone();
    }

    public boolean isCloneTreeRootOrContentClone() {
        return this.parent != null && this.parent.clones[TREE_CLONE_INDEX].size() < this.clones[TREE_CLONE_INDEX].size() || this.clones[CONTENT_CLONE_INDEX].size() > this.clones[TREE_CLONE_INDEX].size();
    }

    public boolean isCloneTreeNode() {
        return this.parent != null && this.clones[TREE_CLONE_INDEX].size() > 1 && this.parent.clones[TREE_CLONE_INDEX].size() == this.clones[TREE_CLONE_INDEX].size();
    }

    public boolean isCloneNode() {
        return this.clones[TREE_CLONE_INDEX].size() > 1 || this.clones[CONTENT_CLONE_INDEX].size() > 1;
    }

    public int nextNodeIndex(NodeModel root, int index, boolean leftSide) {
        return this.nextNodeIndex(root, index, leftSide, 1);
    }

    public int previousNodeIndex(NodeModel root, int index, boolean leftSide) {
        return this.nextNodeIndex(root, index, leftSide, -1);
    }

    private int nextNodeIndex(NodeModel root, int index, boolean leftSide, int step) {
        for (int i = index + step; i >= 0 && i < this.getChildCount(); i += step) {
            NodeModel followingNode = this.getChildAt(i);
            if (followingNode.isTopOrLeft(root) != leftSide) continue;
            return i;
        }
        return -1;
    }

    public NodeModel previousNode(NodeModel root, int start, boolean isTopOrLeft) {
        int previousNodeIndex = this.previousNodeIndex(root, start, isTopOrLeft);
        return this.parent.getChildAt(previousNodeIndex);
    }

    public int getIndex() {
        NodeModel parentNode = this.getParentNode();
        return parentNode != null ? parentNode.getIndex(this) : -1;
    }

    public void swapData(NodeModel duplicate) {
        this.detachClones();
        SharedNodeData sharedDataSwap = this.sharedData;
        this.sharedData = duplicate.sharedData;
        duplicate.sharedData = sharedDataSwap;
        Clones[] clonesSwap = this.clones;
        this.clones = duplicate.clones;
        duplicate.clones = clonesSwap;
        for (CloneType cloneType : CloneType.values()) {
            DetachedNodeList detachedClone = (DetachedNodeList)this.clones[cloneType.ordinal()];
            this.clones[cloneType.ordinal()] = detachedClone.forClone(this);
        }
        this.attachClones();
    }

    public boolean subtreeHasVisibleContent(Filter filter) {
        return this.hasVisibleContent(filter) || this.childSubtreesHaveVisibleContent(filter);
    }

    public boolean childSubtreesHaveVisibleContent(Filter filter) {
        return this.children.stream().anyMatch(child -> child.subtreeHasVisibleContent(filter));
    }

    public NodeModel duplicate(boolean withChildren) {
        return this.map.duplicate(this, withChildren);
    }

    public Side getSide() {
        return this.side;
    }

    public boolean isFoldable() {
        return !this.isLeaf() && !this.isRoot() && !AlwaysUnfoldedNode.isAlwaysUnfolded(this);
    }

    public static enum CloneType {
        TREE,
        CONTENT;

    }

    public static enum Side {
        DEFAULT,
        TOP_OR_LEFT,
        BOTTOM_OR_RIGHT,
        AS_SIBLING;

    }

    public static enum NodeChangeType {
        FOLDING,
        REFRESH;

    }

    public static enum NodeProperty {
        UNKNOWN_PROPERTY;

    }
}

