/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.core.ui.components;

import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.Icon;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.ui.components.IconRow;
import org.freeplane.core.ui.components.TagIcon;
import org.freeplane.features.icon.IconController;
import org.freeplane.features.icon.NamedIcon;
import org.freeplane.features.icon.factory.IconFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.styles.LogicalStyleController;

public class MultipleImageIcon
implements Icon {
    private static final int UNKNOWN = -1;
    private final int TAG_GAP = new Quantity(2.0, (Enum)LengthUnit.pt).toBaseUnitsRounded();
    private final IconRow iconRow = new IconRow();
    private final List<NamedIcon> mUIIcons = new ArrayList<NamedIcon>();
    private final List<TagIcon> mTags = new ArrayList<TagIcon>();
    private int horizontalAlignment = 2;

    public int getHorizontalAlignment() {
        return this.horizontalAlignment;
    }

    public void setHorizontalAlignment(int alignment) {
        this.horizontalAlignment = alignment;
    }

    public void addIcon(NamedIcon uiIcon) {
        Icon icon = uiIcon.getIcon();
        Objects.requireNonNull(icon);
        this.iconRow.addIcon(icon);
        this.mUIIcons.add(uiIcon);
    }

    public void addIcon(NamedIcon uiIcon, Quantity<LengthUnit> iconHeight) {
        Icon icon = uiIcon.getIcon(iconHeight);
        Objects.requireNonNull(icon);
        this.iconRow.addIcon(icon);
        this.mUIIcons.add(uiIcon);
    }

    public void addLinkIcon(Icon icon, NodeModel node, LogicalStyleController.StyleOption option) {
        Objects.requireNonNull(icon);
        Quantity<LengthUnit> iconHeight = IconController.getController().getIconSize(node, option);
        IconFactory iconFactory = IconFactory.getInstance();
        Icon scaledIcon = iconFactory.canScaleIcon(icon) ? iconFactory.getScaledIcon(icon, iconHeight) : icon;
        this.iconRow.addIcon(scaledIcon);
        this.mUIIcons.add(null);
    }

    public void addIcon(Icon icon) {
        Objects.requireNonNull(icon);
        this.iconRow.addIcon(icon);
        this.mUIIcons.add(null);
    }

    public void addTag(TagIcon tag) {
        Objects.requireNonNull(tag);
        this.mTags.add(tag);
    }

    @Override
    public int getIconHeight() {
        int height = this.getGraphicalIconHeight();
        for (Icon icon : this.mTags) {
            height += this.TAG_GAP + icon.getIconHeight();
        }
        return height;
    }

    private int getGraphicalIconHeight() {
        return this.iconRow.getIconHeight();
    }

    @Override
    public int getIconWidth() {
        int width = this.getGraphicalIconWidth();
        for (Icon icon : this.mTags) {
            width = Math.max(width, icon.getIconWidth());
        }
        return width;
    }

    private int getGraphicalIconWidth() {
        return this.iconRow.getIconWidth();
    }

    public int getImageCount() {
        return this.iconRow.getImageCount();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        boolean isLeftToRight = this.horizontalAlignment == 2;
        int graphicalIconWidth = isLeftToRight ? 0 : this.getGraphicalIconWidth();
        int iconWidth = isLeftToRight ? 0 : this.getIconWidth();
        int myX = x;
        if (this.horizontalAlignment == 0) {
            myX += (iconWidth - graphicalIconWidth) / 2;
        } else if (this.horizontalAlignment == 4) {
            myX += iconWidth - graphicalIconWidth;
        }
        this.iconRow.paintIcon(c, g, myX, y);
        int graphicalIconHeight = this.getGraphicalIconHeight();
        int myY = graphicalIconHeight == 0 ? y : y + this.TAG_GAP + graphicalIconHeight;
        for (Icon icon : this.mTags) {
            int myX2 = x;
            if (this.horizontalAlignment == 0) {
                myX2 += (iconWidth - icon.getIconWidth()) / 2;
            } else if (this.horizontalAlignment == 4) {
                myX2 += iconWidth - icon.getIconWidth();
            }
            icon.paintIcon(c, g, myX2, myY);
            myY += this.TAG_GAP + icon.getIconHeight();
        }
    }

    public NamedIcon getUIIconAt(Point coordinate) {
        if (!this.iconRow.containsIcons() || coordinate.x < 0 || coordinate.y < 0 || coordinate.y >= this.getGraphicalIconHeight()) {
            return null;
        }
        boolean isLeftToRight = this.horizontalAlignment == 2;
        int graphicalIconWidth = isLeftToRight ? 0 : this.getGraphicalIconWidth();
        int iconWidth = isLeftToRight ? 0 : this.getIconWidth();
        int iconX = 0;
        if (this.horizontalAlignment == 0) {
            iconX += (iconWidth - graphicalIconWidth) / 2;
        } else if (this.horizontalAlignment == 4) {
            iconX += iconWidth - graphicalIconWidth;
        }
        for (int iconIndex = 0; iconIndex < this.iconRow.getImageCount(); ++iconIndex) {
            if (coordinate.x > (iconX += this.iconRow.getIcon(iconIndex).getIconWidth())) continue;
            return this.mUIIcons.get(iconIndex);
        }
        return null;
    }

    public TagIcon getTagIconAt(Point coordinate) {
        if (this.mTags.isEmpty() || coordinate.x < 0 || coordinate.y <= this.getGraphicalIconHeight() || coordinate.x >= this.getIconWidth()) {
            return null;
        }
        int graphicalIconHeight = this.getGraphicalIconHeight();
        int myY = graphicalIconHeight == 0 ? 0 : this.TAG_GAP + graphicalIconHeight;
        for (TagIcon icon : this.mTags) {
            int iconHeight = icon.getIconHeight();
            if (myY <= coordinate.y && coordinate.y < myY + iconHeight) {
                return icon;
            }
            myY += this.TAG_GAP + iconHeight;
        }
        return null;
    }

    public Rectangle getIconR(Icon icon) {
        return this.iconRow.getIconR(icon);
    }

    public boolean containsIcons() {
        return this.iconRow.containsIcons() || !this.mTags.isEmpty();
    }
}

