/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.icon.mindmapmode;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.UUID;
import java.util.stream.Stream;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;

public class TagSelection
implements Transferable {
    public static final DataFlavor tagFlavor = new DataFlavor("application/x-freeplane-tag; class=java.lang.String", "Freeplane Tags");
    public static final DataFlavor uuidFlavor = new DataFlavor("application/x-freeplane-uuid; class=java.lang.String", "Freeplane UUID");
    public static final DataFlavor dropActionFlavor = MindMapNodesSelection.dropActionFlavor;
    private static final DataFlavor[] flavors = new DataFlavor[]{tagFlavor, uuidFlavor, DataFlavor.stringFlavor, dropActionFlavor};
    private final String id;
    private final String tagSelection;
    private Integer dropAction;

    public TagSelection(UUID uuid, String tagData) {
        this.id = uuid.toString();
        this.tagSelection = tagData;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return (DataFlavor[])flavors.clone();
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        if (flavor.equals(dropActionFlavor)) {
            return this.dropAction != null;
        }
        return Stream.of(flavors).anyMatch(flavor::equals);
    }

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        if (flavor.equals(uuidFlavor)) {
            return this.id;
        }
        if (flavor.equals(dropActionFlavor)) {
            return this.dropAction;
        }
        return this.tagSelection;
    }

    public void setDropAction(int dropAction) {
        this.dropAction = dropAction;
    }
}

