/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.List;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.WindowTab;
import net.infonode.docking.drag.DockingWindowDragSource;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.drag.DockingWindowDraggerProvider;
import net.infonode.docking.drop.InteriorDropInfo;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.ViewTitleBar;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.ViewItem;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.properties.ViewProperties;
import net.infonode.docking.properties.ViewTitleBarProperties;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.properties.base.Property;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.util.ChangeNotifyList;
import net.infonode.util.Direction;
import net.infonode.util.StreamUtil;

public class View
extends DockingWindow {
    private Component lastFocusedComponent;
    private HierarchyListener focusComponentListener = new HierarchyListener(){

        @Override
        public void hierarchyChanged(HierarchyEvent e) {
            View.this.checkLastFocusedComponent();
        }
    };
    private SimplePanel contentPanel = new SimplePanel();
    private ViewProperties rootProperties = new ViewProperties();
    private WeakReference lastRootWindow;
    private PropertyChangeListener listener = new PropertyChangeListener(){

        @Override
        public void propertyChanged(Property property, Object valueContainer, Object oldValue, Object newValue) {
            View.this.fireTitleChanged();
        }
    };
    private PropertyChangeListener titleBarPropertiesListener = new PropertyChangeListener(){

        @Override
        public void propertyChanged(Property property, Object valueContainer, Object oldValue, Object newValue) {
            View.this.updateTitleBar(property, valueContainer);
        }
    };
    private ViewTitleBar titleBar;
    private boolean isfocused = false;
    private List customTitleBarComponents;
    private WindowTab ghostTab;
    private DropAction titleBarDropAction = new DropAction(){

        @Override
        public boolean showTitle() {
            return false;
        }

        @Override
        public void execute(DockingWindow window, MouseEvent mouseEvent) {
            this.removeGhostTab();
            ((AbstractTabWindow)View.this.getWindowParent()).addTab(window);
        }

        @Override
        public void clear(DockingWindow window, DropAction newDropAction) {
            if (newDropAction != this) {
                this.removeGhostTab();
            }
        }

        private void removeGhostTab() {
            if (View.this.ghostTab != null) {
                TabbedPanel tp = ((AbstractTabWindow)View.this.getWindowParent()).getTabbedPanel();
                tp.removeTab(View.this.ghostTab);
                View.this.ghostTab = null;
                if (tp.getProperties().getEnsureSelectedTabVisible() && tp.getSelectedTab() != null) {
                    tp.scrollTabToVisibleArea(tp.getSelectedTab());
                }
            }
        }
    };

    public View(String title, Icon icon, Component component) {
        super(new ViewItem());
        this.rootProperties.setTitle(title);
        this.rootProperties.setIcon(icon);
        this.getViewProperties().addSuperObject(this.rootProperties);
        super.setComponent(this.contentPanel);
        this.contentPanel.setComponent(component);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getMap(), ViewProperties.TITLE, this.listener);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getMap(), ViewProperties.ICON, this.listener);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getViewTitleBarProperties().getMap(), ViewTitleBarProperties.VISIBLE, this.titleBarPropertiesListener);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getViewTitleBarProperties().getMap(), ViewTitleBarProperties.CONTENT_TITLE_BAR_GAP, this.titleBarPropertiesListener);
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getViewProperties().getViewTitleBarProperties().getMap(), ViewTitleBarProperties.ORIENTATION, this.titleBarPropertiesListener);
        this.updateTitleBar(null, null);
        this.init();
    }

    public List getCustomTabComponents() {
        return this.getTab().getCustomTabComponentsList();
    }

    public List getCustomTitleBarComponents() {
        if (this.customTitleBarComponents == null) {
            this.customTitleBarComponents = new ChangeNotifyList(){

                @Override
                protected void changed() {
                    if (View.this.titleBar != null) {
                        View.this.titleBar.updateCustomBarComponents(this);
                    }
                }
            };
        }
        return this.customTitleBarComponents;
    }

    public Component getComponent() {
        return this.contentPanel.getComponent(0);
    }

    @Override
    public void setComponent(Component component) {
        this.contentPanel.setComponent(component);
    }

    public ViewProperties getViewProperties() {
        return ((ViewItem)this.getWindowItem()).getViewProperties();
    }

    @Override
    protected void update() {
    }

    @Override
    public DockingWindow getChildWindow(int index) {
        return null;
    }

    @Override
    public int getChildWindowCount() {
        return 0;
    }

    void setLastFocusedComponent(Component component) {
        if (component != this.lastFocusedComponent) {
            if (this.lastFocusedComponent != null) {
                this.lastFocusedComponent.removeHierarchyListener(this.focusComponentListener);
            }
            this.lastFocusedComponent = component;
            if (this.lastFocusedComponent != null) {
                this.lastFocusedComponent.addHierarchyListener(this.focusComponentListener);
            }
        }
    }

    Component getFocusComponent() {
        this.checkLastFocusedComponent();
        return this.lastFocusedComponent;
    }

    @Override
    public boolean isFocusCycleRoot() {
        return true;
    }

    @Override
    public void restoreFocus() {
        this.makeVisible();
        this.checkLastFocusedComponent();
        if (this.lastFocusedComponent == null) {
            ComponentUtil.smartRequestFocus(this.contentPanel);
        } else {
            this.lastFocusedComponent.requestFocusInWindow();
        }
    }

    @Override
    public Icon getIcon() {
        return this.getViewProperties().getIcon();
    }

    @Override
    protected void doReplace(DockingWindow oldWindow, DockingWindow newWindow) {
        throw new RuntimeException(View.class + ".replaceChildWindow called!");
    }

    @Override
    protected void doRemoveWindow(DockingWindow window) {
        throw new RuntimeException(View.class + ".removeChildWindow called!");
    }

    protected void write(ObjectOutputStream out, WriteContext context) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            context.getViewSerializer().writeView(this, oos);
            this.getWindowItem().writeSettings(oos, context);
        }
        finally {
            oos.close();
        }
        out.writeInt(baos.size());
        baos.writeTo(out);
    }

    static View read(ObjectInputStream in, ReadContext context) throws IOException {
        int size = in.readInt();
        byte[] viewData = new byte[size];
        StreamUtil.readAll(in, viewData);
        ObjectInputStream viewIn = new ObjectInputStream(new ByteArrayInputStream(viewData));
        View view = context.getViewSerializer().readView(viewIn);
        if (view != null) {
            view.getWindowItem().readSettings(viewIn, context);
        }
        return view;
    }

    @Override
    protected DropAction doAcceptDrop(Point p, DockingWindow window) {
        if (this.getWindowParent() instanceof TabWindow && this.titleBar != null && this.titleBar.contains(SwingUtilities.convertPoint(this, p, this.titleBar))) {
            return this.acceptInteriorDrop(p, window);
        }
        return this.getWindowParent() instanceof TabWindow && this.getWindowParent().getChildWindowCount() == 1 ? null : super.doAcceptDrop(p, window);
    }

    @Override
    protected DropAction acceptInteriorDrop(Point p, DockingWindow window) {
        Point p2;
        if (this.getWindowParent() instanceof TabWindow && this.titleBar != null && window.getWindowParent() != this.getWindowParent() && this.titleBar.contains(p2 = SwingUtilities.convertPoint(this, p, this.titleBar))) {
            if (!this.getInteriorDropFilter().acceptDrop(new InteriorDropInfo(window, this, p))) {
                return null;
            }
            this.addGhostTab(window);
            DockingWindow c = this.getWindowParent() instanceof TabWindow ? this.getWindowParent() : this;
            this.getRootWindow().setDragRectangle(SwingUtilities.convertRectangle(c, new Rectangle(0, 0, ((Component)c).getWidth(), ((Component)c).getHeight()), this.getRootWindow()));
            return this.titleBarDropAction;
        }
        return null;
    }

    private void addGhostTab(DockingWindow window) {
        if (this.ghostTab == null) {
            this.ghostTab = ((AbstractTabWindow)this.getWindowParent()).createGhostTab(window);
            ((AbstractTabWindow)this.getWindowParent()).getTabbedPanel().addTab(this.ghostTab);
            ((AbstractTabWindow)this.getWindowParent()).getTabbedPanel().scrollTabToVisibleArea(this.ghostTab);
        }
    }

    @Override
    public String toString() {
        return this.getTitle();
    }

    void setRootWindow(RootWindow newRoot) {
        RootWindow last;
        if (newRoot == null) {
            return;
        }
        RootWindow rootWindow = last = this.lastRootWindow == null ? null : (RootWindow)this.lastRootWindow.get();
        if (last == newRoot) {
            return;
        }
        if (last != null) {
            last.removeView(this);
        }
        this.lastRootWindow = new WeakReference<RootWindow>(newRoot);
        newRoot.addView(this);
    }

    @Override
    protected void setFocused(boolean focused) {
        super.setFocused(focused);
        if (this.isfocused != focused) {
            this.isfocused = focused;
            if (focused) {
                this.getViewProperties().getViewTitleBarProperties().getNormalProperties().addSuperObject(this.getViewProperties().getViewTitleBarProperties().getFocusedProperties());
            } else {
                this.getViewProperties().getViewTitleBarProperties().getNormalProperties().removeSuperObject(this.getViewProperties().getViewTitleBarProperties().getFocusedProperties());
            }
        }
    }

    @Override
    protected void rootChanged(RootWindow oldRoot, RootWindow newRoot) {
        super.rootChanged(oldRoot, newRoot);
        this.setRootWindow(newRoot);
        if (oldRoot != this.getRootWindow()) {
            if (oldRoot != null) {
                this.rootProperties.removeSuperObject(oldRoot.getRootWindowProperties().getViewProperties());
            }
            if (this.getRootWindow() != null) {
                this.rootProperties.addSuperObject(this.getRootWindow().getRootWindowProperties().getViewProperties());
            }
        }
    }

    @Override
    protected PropertyMap getPropertyObject() {
        return this.getViewProperties().getMap();
    }

    @Override
    protected PropertyMap createPropertyObject() {
        return new ViewProperties().getMap();
    }

    @Override
    protected boolean needsTitleWindow() {
        return this.getViewProperties().getAlwaysShowTitle();
    }

    private void checkLastFocusedComponent() {
        if (this.lastFocusedComponent != null && !SwingUtilities.isDescendingFrom(this.lastFocusedComponent, this)) {
            this.lastFocusedComponent.removeHierarchyListener(this.focusComponentListener);
            this.lastFocusedComponent = null;
        }
    }

    @Override
    void removeWindowComponent(DockingWindow window) {
    }

    @Override
    void restoreWindowComponent(DockingWindow window) {
    }

    private void updateTitleBar(Property property, Object valueContainer) {
        boolean changed = valueContainer == null;
        ViewTitleBarProperties titleBarProperties = this.getViewProperties().getViewTitleBarProperties();
        if (changed || property == ViewTitleBarProperties.VISIBLE) {
            if (titleBarProperties.getVisible()) {
                if (this.titleBar == null) {
                    this.titleBar = new ViewTitleBar(this);
                    new DockingWindowDragSource(this.titleBar, new DockingWindowDraggerProvider(){

                        @Override
                        public DockingWindowDragger getDragger(MouseEvent mouseEvent) {
                            return View.this.getWindowProperties().getDragEnabled() ? View.this.startDrag(View.this.getRootWindow()) : null;
                        }
                    });
                    this.titleBar.addMouseListener(new MouseAdapter(){

                        @Override
                        public void mousePressed(MouseEvent e) {
                            View.this.fireTabWindowMouseButtonEvent(e);
                            this.checkPopupMenu(e);
                        }

                        @Override
                        public void mouseClicked(MouseEvent e) {
                            View.this.fireTabWindowMouseButtonEvent(e);
                        }

                        @Override
                        public void mouseReleased(MouseEvent e) {
                            View.this.fireTabWindowMouseButtonEvent(e);
                            this.checkPopupMenu(e);
                        }

                        private void checkPopupMenu(MouseEvent e) {
                            if (e.isPopupTrigger()) {
                                View.this.showPopupMenu(e);
                            }
                        }
                    });
                    if (this.customTitleBarComponents != null) {
                        this.titleBar.updateCustomBarComponents(this.customTitleBarComponents);
                    }
                    changed = true;
                }
            } else if (this.titleBar != null) {
                this.remove(this.titleBar);
                this.titleBar.dispose();
                this.titleBar = null;
                changed = true;
            }
        }
        if ((changed || property == ViewTitleBarProperties.ORIENTATION) && this.titleBar != null) {
            this.remove(this.titleBar);
            this.add((Component)this.titleBar, ComponentUtil.getBorderLayoutOrientation(titleBarProperties.getOrientation()));
            changed = true;
        }
        if (changed || property == ViewTitleBarProperties.CONTENT_TITLE_BAR_GAP) {
            if (this.titleBar != null) {
                Direction orientation = titleBarProperties.getOrientation();
                int contentBarGap = titleBarProperties.getContentTitleBarGap();
                this.contentPanel.setBorder(new EmptyBorder(orientation == Direction.UP ? contentBarGap : 0, orientation == Direction.LEFT ? contentBarGap : 0, orientation == Direction.DOWN ? contentBarGap : 0, orientation == Direction.RIGHT ? contentBarGap : 0));
            } else {
                this.contentPanel.setBorder(null);
            }
        }
    }

    @Override
    protected void updateButtonVisibility() {
        super.updateButtonVisibility();
        if (this.titleBar != null) {
            this.titleBar.updateViewButtons(null);
        }
    }

    @Override
    protected void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
        out.writeInt(1);
        viewWriter.writeView(this, out, context);
    }
}

