/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FloatingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.SplitWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.View;
import net.infonode.docking.ViewSerializer;
import net.infonode.docking.WindowBar;
import net.infonode.docking.WindowDecoder;
import net.infonode.docking.action.MaximizeWithAbortWindowAction;
import net.infonode.docking.action.NullWindowAction;
import net.infonode.docking.action.RestoreFocusWindowAction;
import net.infonode.docking.action.RestoreParentWithAbortWindowAction;
import net.infonode.docking.action.RestoreWithAbortWindowAction;
import net.infonode.docking.action.StateDependentWindowAction;
import net.infonode.docking.drop.ChildDropInfo;
import net.infonode.docking.drop.InteriorDropInfo;
import net.infonode.docking.internal.HeavyWeightContainer;
import net.infonode.docking.internal.HeavyWeightDragRectangle;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.RootWindowItem;
import net.infonode.docking.model.SplitWindowItem;
import net.infonode.docking.model.TabWindowItem;
import net.infonode.docking.model.ViewItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.CursorManager;
import net.infonode.gui.DragLabelWindow;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.RectangleComponentPainter;
import net.infonode.gui.layout.BorderLayout2;
import net.infonode.gui.layout.LayoutUtil;
import net.infonode.gui.layout.StretchLayout;
import net.infonode.gui.mouse.MouseButtonListener;
import net.infonode.gui.panel.SimplePanel;
import net.infonode.gui.shaped.panel.ShapedPanel;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Direction;
import net.infonode.util.ReadWritable;

public class RootWindow
extends DockingWindow
implements ReadWritable {
    private static final int SERIALIZE_VERSION = 4;
    private static final int FLOATING_WINDOW_MIN_WIDTH = 400;
    private static final int FLOATING_WINDOW_MIN_HEIGHT = 300;
    private boolean heavyweightSupport = false;
    private final ShapedPanel layeredPane = new ShapedPanel(){

        @Override
        public boolean isOptimizedDrawingEnabled() {
            return false;
        }
    };
    private final ShapedPanel windowPanel = new ShapedPanel(new StretchLayout(true, true));
    private final SimplePanel mainPanel = new SimplePanel();
    private JFrame dummyFrame;
    private final ViewSerializer viewSerializer;
    private DockingWindow window;
    private final WindowBar[] windowBars = new WindowBar[Direction.getDirections().length];
    private final ArrayList floatingWindows = new ArrayList();
    private DockingWindow maximizedWindow;
    private View focusedView;
    private ArrayList lastFocusedWindows = new ArrayList(4);
    private ArrayList focusedWindows = new ArrayList(4);
    private final ArrayList views = new ArrayList();
    private boolean cleanUpModel;
    private final Runnable modelCleanUpEvent = new Runnable(){

        @Override
        public void run() {
            if (RootWindow.this.cleanUpModel) {
                RootWindow.this.cleanUpModel = false;
                RootWindow.this.getWindowItem().cleanUp();
            }
        }
    };
    private final JLabel dragTextLabel = new JLabel();
    private Container dragTextContainer;
    private DragLabelWindow dragTextWindow;
    private final Component dragRectangle;
    private JRootPane currentDragRootPane;

    public RootWindow(ViewSerializer viewSerializer) {
        this(false, viewSerializer);
    }

    public RootWindow(boolean heavyweightSupport, ViewSerializer viewSerializer) {
        super(new RootWindowItem());
        this.heavyweightSupport = heavyweightSupport;
        this.dragRectangle = heavyweightSupport ? new HeavyWeightDragRectangle() : new ShapedPanel();
        this.getWindowProperties().addSuperObject(this.getRootWindowProperties().getDockingWindowProperties());
        this.mainPanel.setLayout(new BorderLayout2());
        this.mainPanel.add((Component)this.windowPanel, new Point(1, 1));
        this.createWindowBars();
        this.layeredPane.add(this.mainPanel);
        this.layeredPane.setLayout(new SingleComponentLayout());
        this.setComponent(this.layeredPane);
        this.viewSerializer = viewSerializer;
        this.dragTextLabel.setOpaque(true);
        if (heavyweightSupport) {
            this.dragTextContainer = new HeavyWeightContainer(this.dragTextLabel, true);
            this.dragTextContainer.validate();
        } else {
            this.dragTextContainer = this.dragTextLabel;
        }
        this.init();
        FocusManager.getInstance();
        this.addTabMouseButtonListener(new MouseButtonListener(){

            @Override
            public void mouseButtonEvent(MouseEvent event) {
                if (event.isConsumed()) {
                    return;
                }
                DockingWindow window = (DockingWindow)event.getSource();
                if (event.getID() == 501 && event.getButton() == 1 && !event.isShiftDown() && window.isShowing()) {
                    RestoreFocusWindowAction.INSTANCE.perform(window);
                } else if (event.getID() == 500 && event.getButton() == 1 && event.getClickCount() == 2) {
                    if (window.getWindowParent() instanceof WindowBar && RootWindow.this.getRootWindowProperties().getDoubleClickRestoresWindow()) {
                        RestoreWithAbortWindowAction.INSTANCE.perform(window);
                    } else {
                        new StateDependentWindowAction(MaximizeWithAbortWindowAction.INSTANCE, NullWindowAction.INSTANCE, RestoreParentWithAbortWindowAction.INSTANCE).perform(window);
                    }
                }
            }
        });
    }

    public RootWindow(ViewSerializer viewSerializer, DockingWindow window) {
        this(false, viewSerializer, window);
    }

    public RootWindow(boolean heavyweightSupport, ViewSerializer viewSerializer, DockingWindow window) {
        this(heavyweightSupport, viewSerializer);
        this.setWindow(window);
    }

    public View getFocusedView() {
        return this.focusedView;
    }

    void addFocusedWindow(DockingWindow window) {
        int i = 0;
        while (i < this.lastFocusedWindows.size()) {
            if (((WeakReference)this.lastFocusedWindows.get(i)).get() == window) {
                return;
            }
            ++i;
        }
        this.lastFocusedWindows.add(new WeakReference<DockingWindow>(window));
    }

    void setFocusedView(View view) {
        DockingWindow w;
        if (view == this.focusedView) {
            return;
        }
        View previouslyFocusedView = this.focusedView;
        this.focusedView = view;
        DockingWindow w2 = view;
        while (w2 != null) {
            this.focusedWindows.add(new WeakReference<View>((View)w2));
            int i = 0;
            while (i < this.lastFocusedWindows.size()) {
                if (((WeakReference)this.lastFocusedWindows.get(i)).get() == w2) {
                    this.lastFocusedWindows.remove(i);
                    break;
                }
                ++i;
            }
            w2 = w2.getWindowParent();
        }
        int i = 0;
        while (i < this.lastFocusedWindows.size()) {
            DockingWindow w3 = (DockingWindow)((WeakReference)this.lastFocusedWindows.get(i)).get();
            if (w3 != null) {
                w3.setFocused(false);
            }
            ++i;
        }
        ArrayList temp = this.lastFocusedWindows;
        this.lastFocusedWindows = this.focusedWindows;
        this.focusedWindows = temp;
        int i2 = 0;
        while (i2 < this.lastFocusedWindows.size()) {
            w = (DockingWindow)((WeakReference)this.lastFocusedWindows.get(i2)).get();
            if (w != null) {
                w.setFocused(true);
            }
            ++i2;
        }
        if (view != null) {
            view.childGainedFocus(null, view);
        } else {
            this.clearFocus(null);
        }
        i2 = 0;
        while (i2 < this.focusedWindows.size()) {
            w = (DockingWindow)((WeakReference)this.focusedWindows.get(i2)).get();
            if (w != null) {
                w.fireViewFocusChanged(previouslyFocusedView, this.focusedView);
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.lastFocusedWindows.size()) {
            w = (DockingWindow)((WeakReference)this.lastFocusedWindows.get(i2)).get();
            if (w != null) {
                w.fireViewFocusChanged(previouslyFocusedView, this.focusedView);
            }
            ++i2;
        }
        this.focusedWindows.clear();
    }

    public RootWindowProperties getRootWindowProperties() {
        return ((RootWindowItem)this.getWindowItem()).getRootWindowProperties();
    }

    public Direction getClosestWindowBar(DockingWindow window) {
        Point pos = SwingUtilities.convertPoint(window.getParent(), window.getLocation(), this);
        int[] distances = new int[]{this.getWindowBar(Direction.UP).isEnabled() ? pos.y + window.getHeight() : Integer.MAX_VALUE, this.getWindowBar(Direction.DOWN).isEnabled() ? this.getHeight() - pos.y : Integer.MAX_VALUE, this.getWindowBar(Direction.LEFT).isEnabled() ? pos.x + window.getWidth() : Integer.MAX_VALUE, this.getWindowBar(Direction.RIGHT).isEnabled() ? this.getWidth() - pos.x : Integer.MAX_VALUE};
        Direction dir = (new Direction[]{Direction.UP, Direction.DOWN, Direction.LEFT, Direction.RIGHT})[ArrayUtil.findSmallest(distances)];
        return this.getWindowBar(dir).isEnabled() ? dir : null;
    }

    public WindowBar getWindowBar(Direction direction) {
        return this.windowBars[direction.getValue()];
    }

    public void setWindow(DockingWindow newWindow) {
        if (this.window == newWindow) {
            return;
        }
        if (this.window == null) {
            DockingWindow actualWindow = this.addWindow(newWindow);
            this.doReplace(null, actualWindow);
            if (this.getUpdateModel() && actualWindow.getWindowItem().getRootItem() != this.getWindowItem()) {
                this.getWindowItem().removeAll();
                this.addWindowItem(actualWindow, -1);
            }
        } else if (newWindow == null) {
            this.removeChildWindow(this.window);
            this.window = null;
        } else {
            this.replaceChildWindow(this.window, newWindow);
        }
    }

    public DockingWindow getWindow() {
        return this.window;
    }

    public FloatingWindow createFloatingWindow(Point location, Dimension innerSize, DockingWindow window) {
        FloatingWindow fw = new FloatingWindow(this, window, location, innerSize);
        this.floatingWindows.add(fw);
        this.addWindow(fw);
        return fw;
    }

    FloatingWindow createFloatingWindow() {
        FloatingWindow fw = new FloatingWindow(this);
        this.floatingWindows.add(fw);
        this.addWindow(fw);
        return fw;
    }

    FloatingWindow createFloatingWindow(DockingWindow window, Point p) {
        Dimension size = window.getSize();
        if (size.width <= 0 || size.height <= 0) {
            Dimension preferred = window.getPreferredSize();
            size = new Dimension(Math.max(400, preferred.width), Math.max(300, preferred.height));
        }
        FloatingWindow fw = this.createFloatingWindow(p, size, window);
        fw.getTopLevelAncestor().setVisible(true);
        return fw;
    }

    void removeFloatingWindow(FloatingWindow fw) {
        this.floatingWindows.remove(fw);
        this.removeWindow(fw);
    }

    public ViewSerializer getViewSerializer() {
        return this.viewSerializer;
    }

    @Override
    public DockingWindow getChildWindow(int index) {
        return index < 4 ? this.windowBars[index] : (this.window != null ? (index == 4 ? this.window : (DockingWindow)this.floatingWindows.get(index - 5)) : (DockingWindow)this.floatingWindows.get(index - 4));
    }

    @Override
    public int getChildWindowCount() {
        return 4 + (this.window == null ? 0 : 1) + this.floatingWindows.size();
    }

    @Override
    public Icon getIcon() {
        return null;
    }

    @Override
    public void write(ObjectOutputStream out) throws IOException {
        this.write(out, true);
    }

    public void write(ObjectOutputStream out, boolean writeProperties) throws IOException {
        this.cleanUpModel();
        out.writeInt(4);
        out.writeBoolean(writeProperties);
        WriteContext context = new WriteContext(writeProperties, this.getViewSerializer());
        final ArrayList<View> v = new ArrayList<View>();
        int i = 0;
        while (i < this.views.size()) {
            View view = (View)((WeakReference)this.views.get(i)).get();
            if (view != null) {
                v.add(view);
            }
            ++i;
        }
        RootWindow.writeViews(v, out, context);
        ViewWriter viewWriter = new ViewWriter(){

            @Override
            public void writeWindowItem(WindowItem windowItem, ObjectOutputStream out, WriteContext context) throws IOException {
                if (windowItem.getRootItem() == RootWindow.this.getWindowItem()) {
                    out.writeBoolean(true);
                    RootWindow.this.writeWindowItemIndex(windowItem, out);
                    out.writeInt(-1);
                } else {
                    out.writeBoolean(false);
                    windowItem.writeSettings(out, context);
                }
            }

            @Override
            public void writeView(View view, ObjectOutputStream out, WriteContext context) throws IOException {
                int i = 0;
                while (i < v.size()) {
                    if (v.get(i) == view) {
                        out.writeInt(i);
                        return;
                    }
                    ++i;
                }
                out.writeInt(-1);
            }
        };
        this.getWindowItem().write(out, context, viewWriter);
        int i2 = 0;
        while (i2 < 4) {
            this.windowBars[i2].write(out, context, viewWriter);
            ++i2;
        }
        out.writeInt(this.floatingWindows.size());
        i2 = 0;
        while (i2 < this.floatingWindows.size()) {
            ((FloatingWindow)this.floatingWindows.get(i2)).write(out, context, viewWriter);
            ++i2;
        }
        this.writeLocations(out);
        if (this.maximizedWindow != null) {
            this.writeMaximized(this.maximizedWindow, out);
        }
        out.writeInt(-1);
    }

    private void writeWindowItemIndex(WindowItem item, ObjectOutputStream out) throws IOException {
        if (item.getParent() == null) {
            return;
        }
        this.writeWindowItemIndex(item.getParent(), out);
        int index = item.getParent().getWindowIndex(item);
        out.writeInt(index);
    }

    private void writeMaximized(DockingWindow window, ObjectOutputStream out) throws IOException {
        DockingWindow parent = window.getWindowParent();
        if (parent != null) {
            this.writeMaximized(parent, out);
            out.writeInt(parent.getChildWindowIndex(window));
        }
    }

    private static void writeViews(ArrayList views, ObjectOutputStream out, WriteContext context) throws IOException {
        out.writeInt(views.size());
        int i = 0;
        while (i < views.size()) {
            ((View)views.get(i)).write(out, context);
            ++i;
        }
    }

    @Override
    public void read(ObjectInputStream in) throws IOException {
        this.read(in, true);
    }

    private void oldInternalRead(ObjectInputStream in, ReadContext context) throws IOException {
        this.setWindow(in.readBoolean() ? WindowDecoder.decodeWindow(in, context) : null);
        int i = 0;
        while (i < 4) {
            in.readInt();
            this.windowBars[i].oldRead(in, context);
            ++i;
        }
        super.oldRead(in, context);
        this.readLocations(in, this, context.getVersion());
        if (context.getVersion() > 1) {
            int viewCount = in.readInt();
            int i2 = 0;
            while (i2 < viewCount) {
                View view = (View)WindowDecoder.decodeWindow(in, context);
                view.setRootWindow(this);
                view.readLocations(in, this, context.getVersion());
                ++i2;
            }
        }
    }

    private void newInternalRead(ObjectInputStream in, ReadContext context) throws IOException {
        RootWindow.beginUpdateModel();
        try {
            int viewCount = in.readInt();
            final View[] views = new View[viewCount];
            int i = 0;
            while (i < viewCount) {
                views[i] = View.read(in, context);
                if (views[i] != null) {
                    views[i].setRootWindow(this);
                }
                ++i;
            }
            ViewReader viewReader = new ViewReader(){

                @Override
                public ViewItem readViewItem(ObjectInputStream in, ReadContext context) throws IOException {
                    View view = this.readView(in, context);
                    return view == null ? new ViewItem() : (ViewItem)view.getWindowItem();
                }

                @Override
                public WindowItem readWindowItem(ObjectInputStream in, ReadContext context) throws IOException {
                    if (in.readBoolean()) {
                        int index;
                        WindowItem item = RootWindow.this.getWindowItem();
                        while ((index = in.readInt()) != -1) {
                            item = item.getWindow(index);
                        }
                        return item;
                    }
                    return null;
                }

                @Override
                public TabWindow createTabWindow(DockingWindow[] childWindows, TabWindowItem windowItem) {
                    TabWindow tabWindow = new TabWindow(childWindows, windowItem);
                    tabWindow.updateSelectedTab();
                    return tabWindow;
                }

                @Override
                public SplitWindow createSplitWindow(DockingWindow leftWindow, DockingWindow rightWindow, SplitWindowItem windowItem) {
                    return new SplitWindow(windowItem.isHorizontal(), windowItem.getDividerLocation(), leftWindow, rightWindow, windowItem);
                }

                @Override
                public View readView(ObjectInputStream in, ReadContext context) throws IOException {
                    int id = in.readInt();
                    return id == -1 ? null : views[id];
                }
            };
            this.setWindow(this.getWindowItem().read(in, context, viewReader));
            int i2 = 0;
            while (i2 < 4) {
                this.windowBars[i2].newRead(in, context, viewReader);
                ++i2;
            }
            if (context.getVersion() >= 4) {
                int count = in.readInt();
                int i3 = 0;
                while (i3 < count) {
                    FloatingWindow w = this.createFloatingWindow();
                    w.read(in, context, viewReader);
                    ++i3;
                }
            }
            this.readLocations(in, this, context.getVersion());
        }
        finally {
            RootWindow.endUpdateModel();
        }
    }

    public void read(ObjectInputStream in, boolean readProperties) throws IOException {
        FocusManager.getInstance().startIgnoreFocusChanges();
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.setWindow(null);
            while (this.floatingWindows.size() > 0) {
                ((FloatingWindow)this.floatingWindows.get(0)).close();
            }
            int serializeVersion = in.readInt();
            if (serializeVersion > 4) {
                throw new IOException("Can't read serialized data because it was written by a later version of InfoNode Docking Windows!");
            }
            ReadContext context = new ReadContext(this, serializeVersion, in.readBoolean(), readProperties);
            if (context.getVersion() < 3) {
                this.oldInternalRead(in, context);
            } else {
                this.newInternalRead(in, context);
            }
            if (serializeVersion > 1) {
                this.readMaximized(in);
            }
            FocusManager.focusWindow(this);
        }
        catch (Throwable throwable) {
            PropertyMapManager.getInstance().endBatch();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    FocusManager.getInstance().stopIgnoreFocusChanges();
                }
            });
            throw throwable;
        }
        PropertyMapManager.getInstance().endBatch();
        SwingUtilities.invokeLater(new /* invalid duplicate definition of identical inner class */);
    }

    private void readMaximized(ObjectInputStream in) throws IOException {
        int index;
        DockingWindow w = this;
        while ((index = in.readInt()) != -1) {
            if (index >= ((DockingWindow)w).getChildWindowCount()) {
                while (in.readInt() != -1) {
                }
                return;
            }
            w = ((DockingWindow)w).getChildWindow(index);
        }
        if (w != this) {
            this.setMaximizedWindow(w);
        }
    }

    public DockingWindow getMaximizedWindow() {
        return this.maximizedWindow;
    }

    public void setMaximizedWindow(DockingWindow window) {
        if (window != null && (window.isMinimized() || window.isUndocked())) {
            return;
        }
        this.internalSetMaximizedWindow(window);
    }

    void addView(View view) {
        int freeIndex = this.views.size();
        int i = 0;
        while (i < this.views.size()) {
            View v = (View)((WeakReference)this.views.get(i)).get();
            if (v == view) {
                return;
            }
            if (v == null) {
                freeIndex = i;
            }
            ++i;
        }
        this.views.add(freeIndex, new WeakReference<View>(view));
    }

    public void removeView(View view) {
        if (view.getRootWindow() == this) {
            return;
        }
        if (this.focusedView == view) {
            this.focusedView = null;
        }
        this.removeWeak(view, this.views);
        this.removeWeak(view, this.lastFocusedWindows);
        this.removeWeak(view, this.focusedWindows);
        this.getWindowItem().removeWindowRefs(view);
    }

    private void removeWeak(Object item, List l) {
        int i = 0;
        while (i < l.size()) {
            Object o = ((WeakReference)l.get(i)).get();
            if (o == item) {
                l.remove(i);
                return;
            }
            ++i;
        }
    }

    private void internalSetMaximizedWindow(DockingWindow window) {
        if (window == this.maximizedWindow) {
            return;
        }
        DockingWindow focusWindow = null;
        if (this.maximizedWindow != null) {
            DockingWindow oldMaximized = this.maximizedWindow;
            this.maximizedWindow = null;
            if (oldMaximized.getWindowParent() != null) {
                oldMaximized.getWindowParent().restoreWindowComponent(oldMaximized);
            }
            if (oldMaximized != this.window) {
                this.windowPanel.remove(oldMaximized);
            }
            focusWindow = oldMaximized;
            this.fireWindowRestored(oldMaximized);
        }
        this.maximizedWindow = window;
        if (this.maximizedWindow != null) {
            if (this.maximizedWindow.getWindowParent() != null) {
                this.maximizedWindow.getWindowParent().removeWindowComponent(this.maximizedWindow);
            }
            if (this.maximizedWindow != this.window) {
                this.windowPanel.add(this.maximizedWindow);
                if (this.window != null) {
                    this.window.setVisible(false);
                }
            }
            this.maximizedWindow.setVisible(true);
            focusWindow = this.maximizedWindow;
            this.fireWindowMaximized(this.maximizedWindow);
        } else if (this.window != null) {
            this.window.setVisible(true);
        }
        if (focusWindow != null) {
            FocusManager.focusWindow(focusWindow);
        }
    }

    private void createWindowBars() {
        Direction[] directions = Direction.getDirections();
        int i = 0;
        while (i < directions.length) {
            this.windowBars[i] = new WindowBar(this, directions[i]);
            this.windowBars[i].setEnabled(false);
            this.addWindow(this.windowBars[i]);
            this.layeredPane.add(this.windowBars[i].getEdgePanel());
            this.mainPanel.add((Component)this.windowBars[i], new Point(directions[i] == Direction.LEFT ? 0 : (directions[i] == Direction.RIGHT ? 2 : 1), directions[i] == Direction.UP ? 0 : (directions[i] == Direction.DOWN ? 2 : 1)));
            this.windowBars[i].addPropertyChangeListener("enabled", new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    RootWindow.this.updateButtonVisibility();
                }
            });
            ++i;
        }
    }

    JComponent getLayeredPane() {
        return this.layeredPane;
    }

    JComponent getWindowPanel() {
        return this.windowPanel;
    }

    @Override
    protected void showChildWindow(DockingWindow window) {
        if (this.maximizedWindow != null && window == this.window) {
            this.setMaximizedWindow(null);
        }
        super.showChildWindow(window);
    }

    @Override
    protected void update() {
        RootWindowProperties properties = this.getRootWindowProperties();
        properties.getComponentProperties().applyTo(this.layeredPane);
        InternalPropertiesUtil.applyTo(properties.getShapedPanelProperties(), this.layeredPane);
        properties.getWindowAreaProperties().applyTo(this.windowPanel);
        InternalPropertiesUtil.applyTo(properties.getWindowAreaShapedPanelProperties(), this.windowPanel);
        properties.getDragLabelProperties().applyTo(this.dragTextLabel);
        if (!this.heavyweightSupport) {
            ShapedPanel dragRectangle = (ShapedPanel)this.dragRectangle;
            InternalPropertiesUtil.applyTo(properties.getDragRectangleShapedPanelProperties(), dragRectangle);
            if (dragRectangle.getComponentPainter() == null) {
                dragRectangle.setComponentPainter(new RectangleComponentPainter(Color.BLACK, properties.getDragRectangleBorderWidth()));
            }
        } else {
            HeavyWeightDragRectangle rectangle = (HeavyWeightDragRectangle)this.dragRectangle;
            ComponentPainter painter = properties.getDragRectangleShapedPanelProperties().getComponentPainter();
            Color color = painter != null ? painter.getColor(this) : null;
            rectangle.setColor(color != null ? color : Color.BLACK);
            rectangle.setBorderWidth(properties.getDragRectangleBorderWidth());
        }
    }

    void internalStartDrag(JComponent component) {
        this.currentDragRootPane = this.getRootPane();
        FloatingWindow fwStartedDrag = DockingUtil.getFloatingWindowFor((DockingWindow)component);
        int i = 0;
        while (i < this.floatingWindows.size()) {
            FloatingWindow fw = (FloatingWindow)this.floatingWindows.get(i);
            fw.startDrag();
            if (this.dummyFrame != null && fw != fwStartedDrag) {
                ((JDialog)fw.getTopLevelAncestor()).toFront();
            }
            ++i;
        }
        if (this.dummyFrame != null && fwStartedDrag != null) {
            ((JDialog)fwStartedDrag.getTopLevelAncestor()).toFront();
        }
    }

    void stopDrag() {
        if (this.dragTextContainer.getParent() != null) {
            if (!this.heavyweightSupport) {
                this.dragTextContainer.getParent().repaint(this.dragTextContainer.getX(), this.dragTextContainer.getY(), this.dragTextContainer.getWidth(), this.dragTextContainer.getHeight());
            }
            this.dragTextContainer.getParent().remove(this.dragTextContainer);
        }
        if (this.dragTextWindow != null) {
            this.dragTextWindow.setVisible(false);
            this.dragTextWindow.dispose();
            this.dragTextWindow = null;
        }
        if (this.dragRectangle.getParent() != null) {
            if (!this.heavyweightSupport) {
                this.dragRectangle.getParent().repaint(this.dragRectangle.getX(), this.dragRectangle.getY(), this.dragRectangle.getWidth(), this.dragRectangle.getHeight());
            }
            this.dragRectangle.getParent().remove(this.dragRectangle);
        }
        CursorManager.resetGlobalCursor(this.getCurrentDragRootPane());
        this.currentDragRootPane = null;
        int i = 0;
        while (i < this.floatingWindows.size()) {
            ((FloatingWindow)this.floatingWindows.get(i)).stopDrag();
            ++i;
        }
    }

    boolean floatingWindowsContainPoint(Point p) {
        int i = 0;
        while (i < this.floatingWindows.size()) {
            FloatingWindow c = (FloatingWindow)this.floatingWindows.get(i);
            if (c.isShowing() && c.windowContainsPoint(SwingUtilities.convertPoint(this.getRootPane(), p, c))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    void setCurrentDragRootPane(JRootPane rootPane) {
        CursorManager.resetGlobalCursor(this.getCurrentDragRootPane());
        this.currentDragRootPane = rootPane;
    }

    JRootPane getCurrentDragRootPane() {
        return this.currentDragRootPane == null ? this.getRootPane() : this.currentDragRootPane;
    }

    Component getTopLevelComponent() {
        Container c = this.getTopLevelAncestor();
        if (c instanceof JFrame || c instanceof JDialog) {
            return c;
        }
        if (this.dummyFrame == null) {
            this.dummyFrame = new JFrame("");
            this.dummyFrame.setDefaultCloseOperation(2);
        }
        return this.dummyFrame;
    }

    boolean isHeavyweightSupported() {
        return this.heavyweightSupport;
    }

    private static boolean reparent(Container parent, Component c) {
        if (c.getParent() != parent) {
            if (c.getParent() != null) {
                c.getParent().remove(c);
            }
            parent.add(c);
            return true;
        }
        return false;
    }

    void setDragCursor(Cursor cursor) {
        CursorManager.setGlobalCursor(this.getCurrentDragRootPane(), cursor);
        if (this.dragTextWindow != null) {
            this.dragTextWindow.setCursor(cursor);
        }
    }

    void setDragText(Point textPoint, String text) {
        if (textPoint != null) {
            JRootPane currentDragRootPane = this.getCurrentDragRootPane();
            if (RootWindow.reparent(currentDragRootPane.getLayeredPane(), this.dragTextContainer)) {
                currentDragRootPane.getLayeredPane().setLayer(this.dragTextContainer, JLayeredPane.DRAG_LAYER + (this.heavyweightSupport ? -1 : 1));
            }
            this.dragTextLabel.setText(text);
            this.dragTextContainer.setSize(this.dragTextContainer.getPreferredSize());
            Point p2 = SwingUtilities.convertPoint(currentDragRootPane, textPoint, this.dragTextContainer.getParent());
            int yLocationOffs = this.dragTextLabel.getInsets().bottom;
            this.dragTextContainer.setLocation((int)(p2.getX() - (double)(this.dragTextContainer.getWidth() / 2)), (int)(p2.getY() - (double)this.dragTextContainer.getHeight() + (double)yLocationOffs));
            Point rp = SwingUtilities.convertPoint(currentDragRootPane, textPoint, this.getRootPane());
            if (!this.getRootPane().contains(rp) && !this.floatingWindowsContainPoint(rp)) {
                this.dragTextContainer.setVisible(false);
                if (this.dragTextWindow == null) {
                    Component c = this.getTopLevelComponent();
                    if (c instanceof Frame) {
                        this.dragTextWindow = new DragLabelWindow((Frame)c);
                    } else if (c instanceof Dialog) {
                        this.dragTextWindow = new DragLabelWindow((Dialog)c);
                    }
                    if (this.dragTextWindow != null) {
                        this.dragTextWindow.setFocusableWindowState(false);
                        this.dragTextWindow.setFocusable(false);
                        this.getRootWindowProperties().getDragLabelProperties().applyTo(this.dragTextWindow.getLabel());
                    }
                }
                if (this.dragTextWindow != null) {
                    this.dragTextWindow.getLabel().setText(text);
                    SwingUtilities.convertPointToScreen(textPoint, currentDragRootPane);
                    this.dragTextWindow.setLocation(textPoint.x - this.dragTextContainer.getWidth() / 2, textPoint.y - this.dragTextContainer.getHeight() + yLocationOffs);
                    this.dragTextWindow.setVisible(true);
                }
            } else {
                this.dragTextContainer.setVisible(true);
                if (this.heavyweightSupport) {
                    this.dragTextContainer.repaint();
                }
                if (this.dragTextWindow != null) {
                    this.dragTextWindow.setVisible(false);
                }
            }
        } else if (this.dragTextContainer.getParent() != null) {
            this.dragTextContainer.setVisible(false);
            if (this.dragTextWindow != null) {
                this.dragTextWindow.setVisible(false);
            }
        }
    }

    void setDragRectangle(Rectangle rect) {
        if (rect != null) {
            if (RootWindow.reparent(this.getCurrentDragRootPane().getLayeredPane(), this.dragRectangle)) {
                this.getCurrentDragRootPane().getLayeredPane().setLayer(this.dragRectangle, JLayeredPane.DRAG_LAYER + (this.heavyweightSupport ? -1 : 0));
            }
            this.dragRectangle.setBounds(SwingUtilities.convertRectangle(this, rect, this.dragRectangle.getParent()));
            this.dragRectangle.setVisible(true);
        } else if (this.dragRectangle.getParent() != null) {
            this.dragRectangle.setVisible(false);
        }
    }

    @Override
    protected void doReplace(DockingWindow oldWindow, DockingWindow newWindow) {
        if (oldWindow == this.window) {
            if (this.window != null) {
                this.windowPanel.remove(this.window);
                this.window.setVisible(true);
            }
            this.window = newWindow;
            if (this.window != null) {
                if (this.maximizedWindow != null) {
                    this.window.setVisible(false);
                }
                this.windowPanel.add(this.window);
                this.windowPanel.revalidate();
            }
        }
    }

    @Override
    protected void doRemoveWindow(DockingWindow window) {
        if (window == this.window) {
            this.windowPanel.remove(window);
            this.window.setVisible(true);
            this.window = null;
        }
        this.repaint();
    }

    @Override
    public RootWindow getRootWindow() {
        return this;
    }

    @Override
    protected boolean acceptsSplitWith(DockingWindow window) {
        return false;
    }

    @Override
    protected DropAction doAcceptDrop(Point p, DockingWindow window) {
        DropAction da;
        Point p2;
        if (this.maximizedWindow != null && this.maximizedWindow.contains(p2 = SwingUtilities.convertPoint(this, p, this.maximizedWindow)) && this.getChildDropFilter().acceptDrop(new ChildDropInfo(window, this, p, this.maximizedWindow)) && (da = this.maximizedWindow.acceptDrop(p2, window)) != null) {
            return da;
        }
        return super.doAcceptDrop(p, window);
    }

    @Override
    protected DropAction acceptInteriorDrop(Point p, DockingWindow window) {
        if (this.window != null) {
            return null;
        }
        if (this.getInteriorDropFilter().acceptDrop(new InteriorDropInfo(window, this, p))) {
            return new DropAction(){

                @Override
                public void execute(DockingWindow window, MouseEvent mouseEvent) {
                    RootWindow.this.setWindow(window);
                }
            };
        }
        return null;
    }

    @Override
    protected PropertyMap getPropertyObject() {
        return this.getRootWindowProperties().getMap();
    }

    @Override
    protected PropertyMap createPropertyObject() {
        return new RootWindowProperties().getMap();
    }

    boolean windowBarEnabled() {
        int i = 0;
        while (i < this.windowBars.length) {
            if (this.windowBars[i].isEnabled()) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    void removeWindowComponent(DockingWindow window) {
    }

    @Override
    void restoreWindowComponent(DockingWindow window) {
    }

    @Override
    protected void cleanUpModel() {
        if (!this.cleanUpModel) {
            this.cleanUpModel = true;
            SwingUtilities.invokeLater(this.modelCleanUpEvent);
        }
    }

    @Override
    protected boolean isShowingInRootWindow() {
        return true;
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.floatingWindows != null) {
            int i = 0;
            while (i < this.floatingWindows.size()) {
                SwingUtilities.updateComponentTreeUI(((JComponent)this.floatingWindows.get(i)).getTopLevelAncestor());
                ++i;
            }
            i = 0;
            while (i < this.views.size()) {
                View v = (View)((WeakReference)this.views.get(i)).get();
                if (v != null && v.getWindowParent() == null) {
                    SwingUtilities.updateComponentTreeUI(v);
                }
                ++i;
            }
        }
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
    }

    private class SingleComponentLayout
    implements LayoutManager {
        private SingleComponentLayout() {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void layoutContainer(Container parent) {
            Dimension size = LayoutUtil.getInteriorSize(parent);
            Insets insets = parent.getInsets();
            RootWindow.this.mainPanel.setBounds(insets.left, insets.top, size.width, size.height);
            int w1 = ((RootWindow)RootWindow.this).windowBars[Direction.LEFT.getValue()].getPreferredSize().width;
            int w2 = ((RootWindow)RootWindow.this).windowBars[Direction.RIGHT.getValue()].getPreferredSize().width;
            int h1 = ((RootWindow)RootWindow.this).windowBars[Direction.UP.getValue()].getPreferredSize().height;
            int h2 = ((RootWindow)RootWindow.this).windowBars[Direction.DOWN.getValue()].getPreferredSize().height;
            Direction[] directions = Direction.getDirections();
            int i = 0;
            while (i < RootWindow.this.windowBars.length) {
                Component panel = RootWindow.this.windowBars[i].getEdgePanel();
                if (panel.isVisible()) {
                    int height;
                    int width;
                    Direction dir = directions[i];
                    int maxWidth = size.width - w1 - w2;
                    int maxHeight = size.height - h1 - h2;
                    if (dir == Direction.RIGHT) {
                        int rightX = parent.getWidth() - insets.right - w2 + ((RootWindow)RootWindow.this).windowBars[dir.getValue()].getInsets().left;
                        width = Math.min(panel.getPreferredSize().width, maxWidth + ((RootWindow)RootWindow.this).windowBars[dir.getValue()].getInsets().left);
                        panel.setBounds(rightX - width, insets.top + h1, width, maxHeight);
                    } else if (dir == Direction.LEFT) {
                        int x = insets.left + w1 - ((RootWindow)RootWindow.this).windowBars[dir.getValue()].getInsets().right;
                        width = Math.min(panel.getPreferredSize().width, maxWidth + ((RootWindow)RootWindow.this).windowBars[dir.getValue()].getInsets().right);
                        panel.setBounds(x, insets.top + h1, width, maxHeight);
                    } else if (dir == Direction.DOWN) {
                        int bottomY = parent.getHeight() - insets.bottom - h2 + ((RootWindow)RootWindow.this).windowBars[dir.getValue()].getInsets().top;
                        height = Math.min(panel.getPreferredSize().height, maxHeight + ((RootWindow)RootWindow.this).windowBars[dir.getValue()].getInsets().top);
                        panel.setBounds(insets.left + w1, bottomY - height, maxWidth, height);
                    } else {
                        int y = insets.top + h1 - ((RootWindow)RootWindow.this).windowBars[dir.getValue()].getInsets().bottom;
                        height = Math.min(panel.getPreferredSize().height, maxHeight + ((RootWindow)RootWindow.this).windowBars[dir.getValue()].getInsets().bottom);
                        panel.setBounds(insets.left + w1, y, maxWidth, height);
                    }
                }
                ++i;
            }
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return LayoutUtil.add(RootWindow.this.mainPanel.getMinimumSize(), parent.getInsets());
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return LayoutUtil.add(RootWindow.this.mainPanel.getPreferredSize(), parent.getInsets());
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }
}

