/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.ui.mindmapmode;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetContext;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Set;
import javax.swing.SwingUtilities;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.map.clipboard.MapClipboardController;
import org.freeplane.features.map.clipboard.MindMapNodesSelection;
import org.freeplane.features.map.mindmapmode.InsertionRelation;
import org.freeplane.features.map.mindmapmode.MMapController;
import org.freeplane.features.map.mindmapmode.clipboard.MMapClipboardController;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.view.swing.map.MainView;
import org.freeplane.view.swing.map.MapView;
import org.freeplane.view.swing.map.MapViewIconListComponent;
import org.freeplane.view.swing.map.NodeView;
import org.freeplane.view.swing.map.NodeViewFolder;
import org.freeplane.view.swing.ui.MouseEventActor;
import org.freeplane.view.swing.ui.NodeDropUtils;

public class MNodeDropListener
implements DropTargetListener {
    private static final String PROPERTY_UNFOLD_ON_PASTE = "unfold_on_paste";
    private static final EnumMap<MainView.DragOverRelation, NodeModel.Side> sides = new EnumMap(MainView.DragOverRelation.class);
    private static final EnumMap<MainView.DragOverRelation, InsertionRelation> insertionRelations;
    private final NodeViewFolder nodeFolder;

    MNodeDropListener(NodeViewFolder nodeFolder) {
        this.nodeFolder = nodeFolder;
    }

    public void addDropListener(MainView component) {
        this.addDropListener((Component)component);
    }

    public void addDropListener(MapViewIconListComponent component) {
        this.addDropListener((Component)component);
    }

    private void addDropListener(Component component) {
        DropTarget dropTarget = new DropTarget(component, this);
        dropTarget.setActive(true);
    }

    @Override
    public void dragEnter(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            dtde.acceptDrag(2);
        } else {
            dtde.rejectDrag();
        }
    }

    @Override
    public void dragExit(DropTargetEvent e) {
        MainView mainView = this.getMainView(e);
        mainView.stopDragOver();
        mainView.repaint();
        if (this.isInFoldingRegion(mainView)) {
            NodeView nodeView = mainView.getNodeView();
            this.nodeFolder.adjustFolding(Collections.singleton(nodeView));
        }
    }

    private boolean isInFoldingRegion(MainView node) {
        MainView.DragOverDirection dragOverDirection;
        AWTEvent currentEvent = EventQueue.getCurrentEvent();
        if (!(currentEvent instanceof MouseEvent)) {
            return false;
        }
        MouseEvent mouseEvent = (MouseEvent)currentEvent;
        if (mouseEvent.getComponent() != node) {
            return false;
        }
        Point p = mouseEvent.getPoint();
        if (p.x < 0 && p.y >= 0 && p.y < node.getHeight()) {
            dragOverDirection = MainView.DragOverDirection.DROP_LEFT;
        } else if (p.x >= node.getWidth() && p.y >= 0 && p.y < node.getHeight()) {
            dragOverDirection = MainView.DragOverDirection.DROP_RIGHT;
        } else if (p.y < 0 && p.x >= 0 && p.x < node.getWidth()) {
            dragOverDirection = MainView.DragOverDirection.DROP_UP;
        } else if (p.y >= node.getHeight() && p.x >= 0 && p.x < node.getWidth()) {
            dragOverDirection = MainView.DragOverDirection.DROP_DOWN;
        } else {
            return false;
        }
        NodeView nodeView = node.getNodeView();
        MainView.DragOverRelation relation = dragOverDirection.relation(nodeView.layoutOrientation(), nodeView.side());
        return relation.isChild() && nodeView.childrenSides().matches(relation == MainView.DragOverRelation.CHILD_BEFORE);
    }

    private MainView getMainView(DropTargetEvent e) {
        DropTargetContext dropTargetContext = e.getDropTargetContext();
        return this.getMainView(dropTargetContext);
    }

    private MainView getMainView(DropTargetContext dropTargetContext) {
        Component component = dropTargetContext.getComponent();
        if (component instanceof MainView) {
            return (MainView)component;
        }
        NodeView nodeView = (NodeView)SwingUtilities.getAncestorOfClass(NodeView.class, component);
        return nodeView.getMainView();
    }

    @Override
    public void dragOver(DropTargetDragEvent dtde) {
        if (this.isDragAcceptable(dtde)) {
            MainView dropTarget = this.getMainView(dtde.getDropTargetContext());
            dropTarget.setDragOverDirection(dtde);
        }
    }

    private boolean isDragAcceptable(DropTargetDragEvent event) {
        NodeView nodeView = this.getMainView(event.getDropTargetContext()).getNodeView();
        NodeDropUtils.AcceptedContent acceptedContent = this.determineAcceptedContent(event.getDropTargetContext());
        return NodeDropUtils.isDragAcceptable((DropTargetDragEvent)event, (NodeModel)nodeView.getNode(), (NodeDropUtils.AcceptedContent)acceptedContent);
    }

    private NodeDropUtils.AcceptedContent determineAcceptedContent(DropTargetContext context) {
        Component component = context.getComponent();
        if (component instanceof MainView) {
            return NodeDropUtils.AcceptedContent.ANY;
        }
        if (component instanceof MapViewIconListComponent) {
            return NodeDropUtils.AcceptedContent.ONLY_TAGS;
        }
        return NodeDropUtils.AcceptedContent.ANY;
    }

    private boolean isDropAcceptable(DropTargetDropEvent event, int dropAction) {
        NodeModel node = this.getMainView(event.getDropTargetContext()).getNodeView().getNode();
        NodeDropUtils.AcceptedContent acceptedContent = this.determineAcceptedContent(event.getDropTargetContext());
        return NodeDropUtils.isDropAcceptable((DropTargetDropEvent)event, (NodeModel)node, (int)dropAction, (NodeDropUtils.AcceptedContent)acceptedContent);
    }

    @Override
    public void drop(DropTargetDropEvent dtde) {
        try {
            DropContext context = this.prepareDropContext(dtde);
            if (!this.validateDrop(dtde, context)) {
                dtde.rejectDrop();
                return;
            }
            if (this.isExternalDrop(dtde)) {
                this.handleExternalDrop(dtde, context);
            } else if (this.isLinkAction(context.dropAction)) {
                this.handleLinkAction(dtde, context);
            } else if (this.isLocalNodeMove(dtde, context)) {
                this.handleLocalNodeMove(dtde, context);
            } else {
                this.handleClipboardContentDrop(dtde, context);
            }
            this.adjustFoldingOnDrop(context.targetNodeView, context.dragOverRelation);
        }
        catch (Exception e) {
            LogUtils.severe((String)"Drop exception:", (Throwable)e);
            dtde.dropComplete(false);
            return;
        }
        dtde.dropComplete(true);
    }

    private DropContext prepareDropContext(DropTargetDropEvent dtde) {
        DropContext context = new DropContext(dtde, this);
        context.mapView.select();
        context.mainView.stopDragOver();
        context.mainView.repaint();
        return context;
    }

    private boolean validateDrop(DropTargetDropEvent dtde, DropContext context) {
        if (!this.isDropAcceptable(dtde, context.dropAction)) {
            return false;
        }
        if (context.dragOverRelation == MainView.DragOverRelation.NOT_AVAILABLE) {
            return false;
        }
        if (this.requiresWriteableParent(context.dropAction)) {
            NodeModel parent;
            NodeModel nodeModel = parent = context.dropAsSibling ? context.targetNode.getParentNode() : context.targetNode;
            if (!context.mapController.isWriteable(parent)) {
                String message = TextUtils.getText((String)"node_is_write_protected");
                UITools.errorMessage((Object)message);
                return false;
            }
        }
        return true;
    }

    private boolean requiresWriteableParent(int dropAction) {
        return dropAction == 2 || dropAction == 1;
    }

    private boolean isExternalDrop(DropTargetDropEvent dtde) {
        return !dtde.isLocalTransfer();
    }

    private boolean isLinkAction(int dropAction) {
        return dropAction == 0x40000000;
    }

    private boolean isLocalNodeMove(DropTargetDropEvent dtde, DropContext context) {
        if (context.dropAction != 2 || !dtde.isLocalTransfer()) {
            return false;
        }
        if (!context.transferable.isDataFlavorSupported(MindMapNodesSelection.mindMapNodeObjectsFlavor)) {
            return false;
        }
        try {
            return NodeDropUtils.areFromSameMap((Transferable)context.transferable, (NodeModel)context.targetNode);
        }
        catch (UnsupportedFlavorException | IOException e) {
            return false;
        }
    }

    private void handleExternalDrop(DropTargetDropEvent dtde, DropContext context) throws Exception {
        this.adjustFoldingOnDrop(context.targetNodeView, context.dragOverRelation);
        dtde.acceptDrop(1);
        NodeDropUtils.handleMoveOrCopyAction((Transferable)context.transferable, (NodeModel)context.targetNode, (int)context.dropAction, (boolean)false, (InsertionRelation)context.insertionRelation, (NodeModel.Side)context.side);
    }

    private void handleLinkAction(DropTargetDropEvent dtde, DropContext context) throws Exception {
        dtde.acceptDrop(context.dropAction);
        NodeDropUtils.handleLinkAction((Transferable)context.transferable, (NodeModel)context.targetNode, (Controller)context.controller, (ModeController)context.modeController);
    }

    private void handleLocalNodeMove(DropTargetDropEvent dtde, DropContext context) throws Exception {
        dtde.acceptDrop(context.dropAction);
        List selectedNodes = context.mapController.getSelectedNodes();
        NodeModel[] selectedArray = selectedNodes.toArray(new NodeModel[selectedNodes.size()]);
        NodeDropUtils.handleMoveOrCopyAction((Transferable)context.transferable, (NodeModel)context.targetNode, (int)context.dropAction, (boolean)true, (InsertionRelation)context.insertionRelation, (NodeModel.Side)context.side);
        this.updateSelectionAfterNodeMove(context, selectedArray);
    }

    private void updateSelectionAfterNodeMove(DropContext context, NodeModel[] selectedArray) {
        if (context.dropAsSibling || !context.targetNodeView.isFolded()) {
            MouseEventActor.INSTANCE.withMouseEvent(() -> context.controller.getSelection().replaceSelection(selectedArray));
        } else {
            MouseEventActor.INSTANCE.withMouseEvent(() -> context.mapView.selectAsTheOnlyOneSelected(context.targetNodeView));
        }
    }

    private void handleClipboardContentDrop(DropTargetDropEvent dtde, DropContext context) throws Exception {
        dtde.acceptDrop(context.dropAction);
        ((MMapClipboardController)MapClipboardController.getController()).paste(context.transferable, context.targetNode, context.side, context.dropAction);
        MouseEventActor.INSTANCE.withMouseEvent(() -> context.controller.getSelection().selectAsTheOnlyOneSelected(context.targetNode));
    }

    private void adjustFoldingOnDrop(NodeView targetNodeView, MainView.DragOverRelation dragOverRelation) {
        Set<Object> nodesKeptUnfold;
        boolean unfoldsTarget = ResourceController.getResourceController().getBooleanProperty(PROPERTY_UNFOLD_ON_PASTE);
        if (unfoldsTarget) {
            if (dragOverRelation.isChild()) {
                nodesKeptUnfold = Collections.singleton(targetNodeView);
            } else {
                NodeView parentNodeView = targetNodeView.getAncestorWithVisibleContent();
                nodesKeptUnfold = Collections.singleton(parentNodeView);
            }
        } else {
            nodesKeptUnfold = Collections.emptySet();
        }
        this.nodeFolder.adjustFolding(nodesKeptUnfold);
        this.nodeFolder.reset();
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent e) {
    }

    static {
        sides.put(MainView.DragOverRelation.SIBLING_AFTER, NodeModel.Side.AS_SIBLING_AFTER);
        sides.put(MainView.DragOverRelation.SIBLING_BEFORE, NodeModel.Side.AS_SIBLING_BEFORE);
        insertionRelations = new EnumMap(MainView.DragOverRelation.class);
        insertionRelations.put(MainView.DragOverRelation.SIBLING_AFTER, InsertionRelation.AS_SIBLING_AFTER);
        insertionRelations.put(MainView.DragOverRelation.SIBLING_BEFORE, InsertionRelation.AS_SIBLING_BEFORE);
    }

    private static class DropContext {
        final MainView mainView;
        final NodeView targetNodeView;
        final MapView mapView;
        final NodeModel targetNode;
        final Controller controller;
        final ModeController modeController;
        final MMapController mapController;
        final int dropAction;
        final Transferable transferable;
        final MainView.DragOverRelation dragOverRelation;
        final boolean dropAsSibling;
        final boolean isTopOrLeft;
        final NodeModel.Side side;
        final InsertionRelation insertionRelation;

        DropContext(DropTargetDropEvent dtde, MNodeDropListener listener) {
            this.mainView = listener.getMainView(dtde.getDropTargetContext());
            this.targetNodeView = this.mainView.getNodeView();
            this.mapView = this.targetNodeView.getMap();
            this.targetNode = this.targetNodeView.getNode();
            this.controller = Controller.getCurrentController();
            this.modeController = this.controller.getModeController();
            this.mapController = (MMapController)this.modeController.getMapController();
            this.dropAction = NodeDropUtils.getDropAction((DropTargetDropEvent)dtde);
            this.transferable = dtde.getTransferable();
            this.dragOverRelation = this.mainView.dragOverRelation(dtde);
            this.dropAsSibling = this.dragOverRelation.isSibling();
            boolean bl = this.isTopOrLeft = this.dragOverRelation == MainView.DragOverRelation.CHILD_BEFORE;
            this.side = this.dropAsSibling ? (NodeModel.Side)sides.get(this.dragOverRelation) : (this.isTopOrLeft ? NodeModel.Side.TOP_OR_LEFT : NodeModel.Side.BOTTOM_OR_RIGHT);
            this.insertionRelation = insertionRelations.getOrDefault(this.dragOverRelation, InsertionRelation.AS_CHILD);
        }
    }
}

