/*
 * Decompiled with CFR 0.152.
 */
package jogamp.graph.font.typecast.ot.table;

import java.io.DataInputStream;
import java.io.IOException;
import jogamp.graph.font.typecast.ot.table.Script;
import jogamp.graph.font.typecast.ot.table.ScriptRecord;

public class ScriptList {
    private int _scriptCount;
    private ScriptRecord[] _scriptRecords;
    private Script[] _scripts;

    ScriptList(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        dataInputStream.reset();
        dataInputStream.skipBytes(n);
        this._scriptCount = dataInputStream.readUnsignedShort();
        this._scriptRecords = new ScriptRecord[this._scriptCount];
        this._scripts = new Script[this._scriptCount];
        for (n2 = 0; n2 < this._scriptCount; ++n2) {
            this._scriptRecords[n2] = new ScriptRecord(dataInputStream);
        }
        for (n2 = 0; n2 < this._scriptCount; ++n2) {
            this._scripts[n2] = new Script(dataInputStream, n + this._scriptRecords[n2].getOffset());
        }
    }

    public int getScriptCount() {
        return this._scriptCount;
    }

    public ScriptRecord getScriptRecord(int n) {
        return this._scriptRecords[n];
    }

    public Script getScript(int n) {
        return this._scripts[n];
    }

    public Script findScript(String string) {
        if (string.length() != 4) {
            return null;
        }
        int n = string.charAt(0) << 24 | string.charAt(1) << 16 | string.charAt(2) << 8 | string.charAt(3);
        for (int i = 0; i < this._scriptCount; ++i) {
            if (this._scriptRecords[i].getTag() != n) continue;
            return this._scripts[i];
        }
        return null;
    }
}

