/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.content.application.x_jmx;

import com.sun.media.BasicPlayer;
import com.sun.media.Log;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.io.File;
import java.io.IOException;
import java.util.Vector;
import javax.media.ControllerErrorEvent;
import javax.media.ControllerEvent;
import javax.media.ControllerListener;
import javax.media.IncompatibleSourceException;
import javax.media.IncompatibleTimeBaseException;
import javax.media.Manager;
import javax.media.MediaLocator;
import javax.media.Player;
import javax.media.RealizeCompleteEvent;
import javax.media.TimeBase;
import javax.media.protocol.DataSource;
import javax.media.protocol.PullDataSource;
import javax.media.renderer.VisualContainer;

public class Handler
extends BasicPlayer {
    Player[] players = null;
    Player master = null;
    boolean[] realized = null;
    Vector locators = new Vector();
    ControllerListener listener = new PlayerListener(this);
    boolean playersRealized = false;
    Object realizedSync = new Object();
    private boolean closed = false;
    private boolean audioEnabled = false;
    private boolean videoEnabled = false;
    String sessionError = "Cannot create a Player for: ";
    private Container container = null;

    public Handler() {
        this.framePositioning = true;
    }

    protected boolean doRealize() {
        super.doRealize();
        MediaLocator ml = null;
        try {
            this.players = new Player[this.locators.size()];
            this.realized = new boolean[this.locators.size()];
            int i = 0;
            while (i < this.locators.size()) {
                ml = (MediaLocator)this.locators.elementAt(i);
                this.players[i] = Manager.createPlayer(ml);
                this.players[i].addControllerListener(this.listener);
                this.realized[i] = false;
                this.players[i].realize();
                ++i;
            }
        }
        catch (Exception e) {
            Log.error(this.sessionError + ml);
            this.processError = this.sessionError + ml;
            return false;
        }
        try {
            Object e = this.realizedSync;
            synchronized (e) {
                while (!(this.playersRealized || this.isInterrupted() || this.closed)) {
                    this.realizedSync.wait();
                }
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        if (this.closed || this.isInterrupted()) {
            this.resetInterrupt();
            this.processError = "Realize interrupted";
            return false;
        }
        try {
            this.master = this.players[0];
            int i = 1;
            while (i < this.players.length) {
                this.master.addController(this.players[i]);
                ++i;
            }
        }
        catch (IncompatibleTimeBaseException e) {
            this.processError = "AddController failed";
            return false;
        }
        this.manageController(this.master);
        return true;
    }

    protected void completeRealize() {
        this.state = 300;
        super.completeRealize();
    }

    protected void doStart() {
        super.doStart();
    }

    protected void doStop() {
        super.doStop();
    }

    protected void doDeallocate() {
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
    }

    protected void doClose() {
        this.closed = true;
        Object object = this.realizedSync;
        synchronized (object) {
            this.realizedSync.notify();
        }
        this.stop();
        super.doClose();
    }

    protected TimeBase getMasterTimeBase() {
        return this.master.getTimeBase();
    }

    protected boolean audioEnabled() {
        return this.audioEnabled;
    }

    protected boolean videoEnabled() {
        return this.videoEnabled;
    }

    private void sendMyEvent(ControllerEvent e) {
        super.sendEvent(e);
    }

    /*
     * Unable to fully structure code
     */
    public void setSource(DataSource source) throws IOException, IncompatibleSourceException {
        block14: {
            block13: {
                super.setSource(source);
                if (!(source instanceof PullDataSource)) {
                    throw new IncompatibleSourceException();
                }
                pss = ((PullDataSource)source).getStreams();
                if (pss.length != 1) {
                    throw new IncompatibleSourceException();
                }
                source.start();
                len = (int)pss[0].getContentLength();
                if ((long)len == -1L) {
                    throw new IncompatibleSourceException();
                }
                barray = new byte[len];
                try {
                    len = pss[0].read(barray, 0, len);
                    content = new String(barray);
                }
                catch (Exception e) {
                    throw new IncompatibleSourceException();
                }
                start = 0;
                size = content.length();
                relPath = null;
                ch = content.charAt(start);
                break block13;
                while (++start < size) {
                    ch = content.charAt(start);
lbl25:
                    // 2 sources

                    ** while (ch != ' ' && ch != '\n')
lbl26:
                    // 1 sources

                }
lbl27:
                // 2 sources

                if (start >= size) break block14;
                idx = start;
                while (++idx < size && (ch = content.charAt(idx)) != '\n') {
                }
                str = content.substring(start, idx);
                if (str.indexOf(58) == -1) {
                    if (relPath == null) {
                        loc = source.getLocator();
                        if (loc == null) {
                            throw new IncompatibleSourceException();
                        }
                        relPath = loc.toString();
                        i = relPath.lastIndexOf(47);
                        if (i < 0) {
                            i = relPath.lastIndexOf(File.separator);
                        }
                        relPath = relPath.substring(0, i + 1);
                    }
                    str = relPath + str;
                }
                this.locators.addElement(new MediaLocator(str));
                start = idx;
            }
            if (start < size) ** GOTO lbl25
        }
        if (this.locators.size() < 1) {
            throw new IncompatibleSourceException();
        }
    }

    private void invalidateComp() {
        this.controlComp = null;
        this.controls = null;
    }

    public Component getVisualComponent() {
        Vector<Component> visuals = new Vector<Component>(1);
        int i = 0;
        while (i < this.players.length) {
            Component comp = this.players[i].getVisualComponent();
            if (comp != null) {
                visuals.addElement(comp);
            }
            ++i;
        }
        if (visuals.size() == 0) {
            return null;
        }
        if (visuals.size() == 1) {
            return (Component)visuals.elementAt(0);
        }
        return this.createVisualContainer(visuals);
    }

    protected Component createVisualContainer(Vector visuals) {
        Boolean hint = (Boolean)Manager.getHint(3);
        if (this.container == null) {
            this.container = hint == null || hint == false ? new HeavyPanel(visuals) : new LightPanel(visuals);
            this.container.setLayout(new FlowLayout());
            this.container.setBackground(Color.black);
            int i = 0;
            while (i < visuals.size()) {
                Component c = (Component)visuals.elementAt(i);
                this.container.add(c);
                c.setSize(c.getPreferredSize());
                ++i;
            }
        }
        return this.container;
    }

    public void updateStats() {
        int i = 0;
        while (i < this.players.length) {
            if (this.players[i] != null) {
                ((BasicPlayer)this.players[i]).updateStats();
            }
            ++i;
        }
    }

    class PlayerListener
    implements ControllerListener {
        Handler handler;

        public PlayerListener(Handler handler) {
            this.handler = handler;
        }

        public synchronized void controllerUpdate(ControllerEvent ce) {
            Player p = (Player)ce.getSourceController();
            if (p == null) {
                return;
            }
            int idx = 0;
            while (idx < Handler.this.players.length) {
                if (Handler.this.players[idx] == p) break;
                ++idx;
            }
            if (idx >= Handler.this.players.length) {
                System.err.println("Unknown player: " + p);
                return;
            }
            if (ce instanceof RealizeCompleteEvent) {
                Handler.this.realized[idx] = true;
                int i = 0;
                while (i < Handler.this.realized.length) {
                    if (!Handler.this.realized[i]) {
                        return;
                    }
                    ++i;
                }
                Object object = Handler.this.realizedSync;
                synchronized (object) {
                    Handler.this.playersRealized = true;
                    Handler.this.realizedSync.notifyAll();
                }
            }
            if (ce instanceof ControllerErrorEvent) {
                Handler.this.players[idx].removeControllerListener(this);
                Log.error("Meta Handler internal error: " + ce);
                Handler.this.players[idx] = null;
            }
        }
    }

    class LightPanel
    extends Container
    implements VisualContainer {
        public LightPanel(Vector visuals) {
        }
    }

    class HeavyPanel
    extends Panel
    implements VisualContainer {
        public HeavyPanel(Vector visuals) {
        }
    }
}

