/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.vertx.web;

import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.ext.web.RoutingContext;
import java.util.Optional;

public interface RoutingExchange {
    public RoutingContext context();

    default public HttpServerRequest request() {
        return this.context().request();
    }

    default public Optional<String> getParam(String paramName) {
        return Optional.ofNullable(this.request().getParam(paramName));
    }

    default public Optional<String> getHeader(CharSequence headerName) {
        return Optional.ofNullable(this.request().getHeader(headerName));
    }

    default public HttpServerResponse response() {
        return this.context().response();
    }

    default public HttpServerResponse ok() {
        return this.response().setStatusCode(200);
    }

    default public void ok(String chunk) {
        this.ok().end(chunk);
    }

    default public HttpServerResponse serverError() {
        return this.response().setStatusCode(500);
    }

    default public HttpServerResponse notFound() {
        return this.response().setStatusCode(404);
    }
}

