/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authentication.authenticators.client;

import jakarta.ws.rs.core.Response;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.keycloak.authentication.AuthenticationFlowError;
import org.keycloak.authentication.ClientAuthenticationFlowContext;
import org.keycloak.authentication.authenticators.client.AbstractClientAuthenticator;
import org.keycloak.authentication.authenticators.client.AbstractJWTClientValidator;
import org.keycloak.authentication.authenticators.client.ClientAssertionState;
import org.keycloak.authentication.authenticators.client.ClientAuthUtil;
import org.keycloak.authentication.authenticators.client.JWTClientValidator;
import org.keycloak.crypto.ClientSignatureVerifierProvider;
import org.keycloak.models.AuthenticationExecutionModel;
import org.keycloak.models.ClientModel;
import org.keycloak.models.TokenManager;
import org.keycloak.protocol.oidc.OIDCClientSecretConfigWrapper;
import org.keycloak.provider.ProviderConfigProperty;
import org.keycloak.representations.JsonWebToken;
import org.keycloak.services.ServicesLogger;

public class JWTClientSecretAuthenticator
extends AbstractClientAuthenticator {
    public static final String PROVIDER_ID = "client-secret-jwt";

    public void authenticateClient(ClientAuthenticationFlowContext context) {
        try {
            JWTClientValidator validator;
            ClientAssertionState clientAssertionState = (ClientAssertionState)context.getState(ClientAssertionState.class, ClientAssertionState.supplier());
            JsonWebToken jwt = clientAssertionState.getToken();
            if (jwt != null) {
                if (!Objects.equals(jwt.getIssuer(), jwt.getSubject())) {
                    return;
                }
                if (clientAssertionState.getClient() == null) {
                    clientAssertionState.setClient(context.getRealm().getClientByClientId(jwt.getSubject()));
                }
            }
            if (!(validator = new JWTClientValidator(context, this::verifySignature, this.getId())).validate()) {
                return;
            }
            context.success();
        }
        catch (Exception e) {
            ServicesLogger.LOGGER.errorValidatingAssertion(e);
            Response challengeResponse = ClientAuthUtil.errorResponse(Response.Status.BAD_REQUEST.getStatusCode(), "unauthorized_client", "Client authentication with client secret signed JWT failed: " + e.getMessage());
            context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, challengeResponse);
        }
    }

    public boolean verifySignature(AbstractJWTClientValidator validator) {
        boolean signatureValid;
        ClientAuthenticationFlowContext context = validator.getContext();
        ClientModel client = validator.getClient();
        String clientSecretString = client.getSecret();
        if (clientSecretString == null) {
            context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, null);
            return false;
        }
        OIDCClientSecretConfigWrapper wrapper = OIDCClientSecretConfigWrapper.fromClientModel(client);
        if (wrapper.isClientSecretExpired()) {
            context.failure(AuthenticationFlowError.INVALID_CLIENT_CREDENTIALS, null);
            return false;
        }
        try {
            JsonWebToken jwt = (JsonWebToken)context.getSession().tokens().decodeClientJWT(validator.getClientAssertion(), client, (jose, validatedClient) -> {
                TokenManager.DEFAULT_VALIDATOR.accept(jose, validatedClient);
                String signatureAlgorithm = jose.getHeader().getRawAlgorithm();
                ClientSignatureVerifierProvider signatureProvider = (ClientSignatureVerifierProvider)context.getSession().getProvider(ClientSignatureVerifierProvider.class, signatureAlgorithm);
                if (signatureProvider == null) {
                    throw new RuntimeException("Algorithm not supported");
                }
                if (signatureProvider.isAsymmetricAlgorithm()) {
                    throw new RuntimeException("Algorithm is not symmetric");
                }
            }, JsonWebToken.class);
            boolean bl = signatureValid = jwt != null;
            if (!signatureValid && wrapper.hasRotatedSecret() && !wrapper.isClientRotatedSecretExpired()) {
                jwt = (JsonWebToken)context.getSession().tokens().decodeClientJWT(validator.getClientAssertion(), (ClientModel)wrapper.toRotatedClientModel(), JsonWebToken.class);
                signatureValid = jwt != null;
            }
        }
        catch (Exception e) {
            Throwable cause = e.getCause() != null ? e.getCause() : e;
            throw new RuntimeException("Signature on JWT token by client secret failed validation", cause);
        }
        if (!signatureValid) {
            throw new RuntimeException("Signature on JWT token by client secret  failed validation");
        }
        return true;
    }

    public boolean isConfigurable() {
        return false;
    }

    public List<ProviderConfigProperty> getConfigPropertiesPerClient() {
        return Collections.emptyList();
    }

    public Map<String, Object> getAdapterConfiguration(ClientModel client) {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("secret", client.getSecret());
        String algorithm = client.getAttribute("token.endpoint.auth.signing.alg");
        if (algorithm != null) {
            props.put("algorithm", algorithm);
        }
        HashMap<String, Object> config = new HashMap<String, Object>();
        config.put("secret-jwt", props);
        return config;
    }

    public Set<String> getProtocolAuthenticatorMethods(String loginProtocol) {
        if (loginProtocol.equals("openid-connect")) {
            HashSet<String> results = new HashSet<String>();
            results.add("client_secret_jwt");
            return results;
        }
        return Collections.emptySet();
    }

    public boolean supportsSecret() {
        return true;
    }

    public String getId() {
        return PROVIDER_ID;
    }

    public String getDisplayType() {
        return "Signed JWT with Client Secret";
    }

    public AuthenticationExecutionModel.Requirement[] getRequirementChoices() {
        return REQUIREMENT_CHOICES;
    }

    public String getHelpText() {
        return "Validates client based on signed JWT issued by client and signed with the Client Secret";
    }

    public List<ProviderConfigProperty> getConfigProperties() {
        return new LinkedList<ProviderConfigProperty>();
    }
}

