/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker;

import java.io.File;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.gradle.api.Action;
import org.gradle.api.logging.LogLevel;
import org.gradle.internal.id.IdGenerator;
import org.gradle.internal.jvm.JpmsConfiguration;
import org.gradle.internal.jvm.Jvm;
import org.gradle.internal.jvm.inspection.JvmVersionDetector;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.remote.Address;
import org.gradle.internal.remote.ConnectionAcceptor;
import org.gradle.internal.remote.MessagingServer;
import org.gradle.internal.remote.ObjectConnection;
import org.gradle.process.ExecResult;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.gradle.process.internal.JavaExecHandleFactory;
import org.gradle.process.internal.health.memory.JvmMemoryStatus;
import org.gradle.process.internal.health.memory.MemoryAmount;
import org.gradle.process.internal.health.memory.MemoryManager;
import org.gradle.process.internal.worker.DefaultWorkerLoggingProtocol;
import org.gradle.process.internal.worker.DefaultWorkerProcess;
import org.gradle.process.internal.worker.WorkerJvmMemoryInfoSerializer;
import org.gradle.process.internal.worker.WorkerLoggingSerializer;
import org.gradle.process.internal.worker.WorkerProcess;
import org.gradle.process.internal.worker.WorkerProcessBuilder;
import org.gradle.process.internal.worker.WorkerProcessContext;
import org.gradle.process.internal.worker.child.ApplicationClassesInSystemClassLoaderWorkerImplementationFactory;
import org.gradle.process.internal.worker.child.WorkerJvmMemoryInfoProtocol;
import org.gradle.process.internal.worker.child.WorkerLoggingProtocol;
import org.gradle.util.internal.GUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultWorkerProcessBuilder
implements WorkerProcessBuilder {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultWorkerProcessBuilder.class);
    private final MessagingServer server;
    private final IdGenerator<Long> idGenerator;
    private final ApplicationClassesInSystemClassLoaderWorkerImplementationFactory workerImplementationFactory;
    private final OutputEventListener outputEventListener;
    private final JavaExecHandleBuilder javaCommand;
    private final Set<String> packages = new HashSet<String>();
    private final Set<File> applicationClasspath = new LinkedHashSet<File>();
    private final Set<File> applicationModulePath = new LinkedHashSet<File>();
    private final MemoryManager memoryManager;
    private final JvmVersionDetector jvmVersionDetector;
    private Action<? super WorkerProcessContext> action;
    private LogLevel logLevel = LogLevel.LIFECYCLE;
    private String baseName = "Gradle Worker";
    private int connectTimeoutSeconds;
    private List<URL> implementationClassPath;
    private List<URL> implementationModulePath;
    private boolean shouldPublishJvmMemoryInfo;
    private NativeServices.NativeServicesMode nativeServicesMode = NativeServices.NativeServicesMode.NOT_SET;
    private boolean addJpmsCompatibilityFlags = true;

    DefaultWorkerProcessBuilder(JavaExecHandleFactory execHandleFactory, MessagingServer server, IdGenerator<Long> idGenerator, ApplicationClassesInSystemClassLoaderWorkerImplementationFactory workerImplementationFactory, OutputEventListener outputEventListener, MemoryManager memoryManager, JvmVersionDetector jvmVersionDetector) {
        this.javaCommand = execHandleFactory.newJavaExec();
        this.javaCommand.setExecutable(Jvm.current().getJavaExecutable());
        this.server = server;
        this.idGenerator = idGenerator;
        this.workerImplementationFactory = workerImplementationFactory;
        this.outputEventListener = outputEventListener;
        this.memoryManager = memoryManager;
        this.jvmVersionDetector = jvmVersionDetector;
    }

    public int getConnectTimeoutSeconds() {
        return this.connectTimeoutSeconds;
    }

    public void setConnectTimeoutSeconds(int connectTimeoutSeconds) {
        this.connectTimeoutSeconds = connectTimeoutSeconds;
    }

    @Override
    public WorkerProcessBuilder setBaseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    @Override
    public String getBaseName() {
        return this.baseName;
    }

    @Override
    public WorkerProcessBuilder applicationClasspath(Iterable<File> files) {
        for (File file : files) {
            if (file == null) {
                throw new IllegalArgumentException("Illegal null value provided in this collection: " + files);
            }
            if (!this.isEntryValid(file)) continue;
            this.applicationClasspath.add(file);
        }
        return this;
    }

    private boolean isEntryValid(File file) {
        return file.exists() || "*".equals(file.getName()) && file.getParentFile() != null && file.getParentFile().exists();
    }

    @Override
    public Set<File> getApplicationClasspath() {
        return this.applicationClasspath;
    }

    @Override
    public WorkerProcessBuilder applicationModulePath(Iterable<File> files) {
        GUtil.addToCollection(this.applicationModulePath, files);
        return this;
    }

    @Override
    public Set<File> getApplicationModulePath() {
        return this.applicationModulePath;
    }

    @Override
    public WorkerProcessBuilder sharedPackages(String ... packages) {
        this.sharedPackages(Arrays.asList(packages));
        return this;
    }

    @Override
    public WorkerProcessBuilder sharedPackages(Iterable<String> packages) {
        GUtil.addToCollection(this.packages, packages);
        return this;
    }

    @Override
    public Set<String> getSharedPackages() {
        return this.packages;
    }

    public WorkerProcessBuilder worker(Action<? super WorkerProcessContext> action) {
        this.action = action;
        return this;
    }

    @Override
    public Action<? super WorkerProcessContext> getWorker() {
        return this.action;
    }

    @Override
    public JavaExecHandleBuilder getJavaCommand() {
        return this.javaCommand;
    }

    @Override
    public LogLevel getLogLevel() {
        return this.logLevel;
    }

    @Override
    public WorkerProcessBuilder setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
        return this;
    }

    @Override
    public void setImplementationClasspath(List<URL> implementationClassPath) {
        this.implementationClassPath = implementationClassPath;
    }

    @Override
    public void setImplementationModulePath(List<URL> implementationModulePath) {
        this.implementationModulePath = implementationModulePath;
    }

    @Override
    public void enableJvmMemoryInfoPublishing(boolean shouldPublish) {
        this.shouldPublishJvmMemoryInfo = shouldPublish;
    }

    @Override
    public void setNativeServicesMode(NativeServices.NativeServicesMode nativeServicesMode) {
        this.nativeServicesMode = nativeServicesMode;
    }

    @Override
    public NativeServices.NativeServicesMode getNativeServicesMode() {
        return this.nativeServicesMode;
    }

    @Override
    public WorkerProcessBuilder setAddJpmsCompatibilityFlags(boolean addJpmsCompatibilityFlags) {
        this.addJpmsCompatibilityFlags = addJpmsCompatibilityFlags;
        return this;
    }

    @Override
    public WorkerProcess build() {
        WorkerJvmMemoryStatus memoryStatus = this.shouldPublishJvmMemoryInfo ? new WorkerJvmMemoryStatus() : null;
        DefaultWorkerProcess workerProcess = new DefaultWorkerProcess(this.connectTimeoutSeconds, TimeUnit.SECONDS, memoryStatus);
        ConnectionAcceptor acceptor = this.server.accept(connection -> workerProcess.onConnect((ObjectConnection)connection, () -> {
            DefaultWorkerLoggingProtocol defaultWorkerLoggingProtocol = new DefaultWorkerLoggingProtocol(this.outputEventListener);
            connection.useParameterSerializers(WorkerLoggingSerializer.create());
            connection.addIncoming(WorkerLoggingProtocol.class, (Object)defaultWorkerLoggingProtocol);
            if (this.shouldPublishJvmMemoryInfo) {
                connection.useParameterSerializers(WorkerJvmMemoryInfoSerializer.create());
                connection.addIncoming(WorkerJvmMemoryInfoProtocol.class, (Object)memoryStatus);
            }
        }));
        workerProcess.startAccepting(acceptor);
        Address localAddress = acceptor.getAddress();
        long id = (Long)this.idGenerator.generateId();
        String displayName = this.getBaseName() + " " + id;
        LOGGER.debug("Creating {}", (Object)displayName);
        LOGGER.debug("Using application classpath {}", this.applicationClasspath);
        LOGGER.debug("Using application module path {}", this.applicationModulePath);
        LOGGER.debug("Using implementation classpath {}", this.implementationClassPath);
        LOGGER.debug("Using implementation module path {}", this.implementationModulePath);
        JavaExecHandleBuilder javaCommand = this.getJavaCommand();
        javaCommand.setDisplayName(displayName);
        int javaVersionMajor = this.jvmVersionDetector.getJavaVersionMajor(javaCommand.getExecutable());
        boolean java9Compatible = javaVersionMajor >= 9;
        this.workerImplementationFactory.prepareJavaCommand(id, displayName, this, this.implementationClassPath, this.implementationModulePath, localAddress, javaCommand, this.shouldPublishJvmMemoryInfo, java9Compatible);
        if (this.addJpmsCompatibilityFlags) {
            javaCommand.jvmArgs(JpmsConfiguration.forWorkerProcesses((int)javaVersionMajor, (boolean)this.nativeServicesMode.isPotentiallyEnabled()));
        }
        javaCommand.args("'" + displayName + "'");
        if (javaCommand.getMaxHeapSize() == null) {
            javaCommand.setMaxHeapSize("512m");
        }
        ExecHandle execHandle = javaCommand.build();
        workerProcess.setExecHandle(execHandle);
        return new MemoryRequestingWorkerProcess(workerProcess, this.memoryManager, MemoryAmount.parseNotation((String)javaCommand.getMaxHeapSize()));
    }

    private static class WorkerJvmMemoryStatus
    implements JvmMemoryStatus,
    WorkerJvmMemoryInfoProtocol {
        private JvmMemoryStatus snapshot = new JvmMemoryStatus(){

            public long getMaxMemory() {
                throw new IllegalStateException("JVM memory status has not been reported yet.");
            }

            public long getCommittedMemory() {
                throw new IllegalStateException("JVM memory status has not been reported yet.");
            }
        };

        public void sendJvmMemoryStatus(JvmMemoryStatus jvmMemoryStatus) {
            this.snapshot = jvmMemoryStatus;
        }

        public long getMaxMemory() {
            return this.snapshot.getMaxMemory();
        }

        public long getCommittedMemory() {
            return this.snapshot.getCommittedMemory();
        }
    }

    private static class MemoryRequestingWorkerProcess
    implements WorkerProcess {
        private final WorkerProcess delegate;
        private final MemoryManager memoryResourceManager;
        private final long memoryAmount;

        private MemoryRequestingWorkerProcess(WorkerProcess delegate, MemoryManager memoryResourceManager, long memoryAmount) {
            this.delegate = delegate;
            this.memoryResourceManager = memoryResourceManager;
            this.memoryAmount = memoryAmount;
        }

        @Override
        public WorkerProcess start() {
            this.memoryResourceManager.requestFreeMemory(this.memoryAmount);
            return this.delegate.start();
        }

        @Override
        public ObjectConnection getConnection() {
            return this.delegate.getConnection();
        }

        @Override
        public ExecResult waitForStop() {
            return this.delegate.waitForStop();
        }

        @Override
        public Optional<ExecResult> getExecResult() {
            return this.delegate.getExecResult();
        }

        @Override
        public JvmMemoryStatus getJvmMemoryStatus() {
            return this.delegate.getJvmMemoryStatus();
        }

        @Override
        public void stopNow() {
            this.delegate.stopNow();
        }

        public String getDisplayName() {
            return this.delegate.getDisplayName();
        }
    }
}

