// BankUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef BankUI_h
#define BankUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2010, Alan Calvert
// Copyright 2014-2025, Will Godfrey & others

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of original ZynAddSubFX code.


#include <unistd.h>
#include <iostream>
#include <string>
    using std::string;
#include <FL/Fl_Button.H>
#include <FL/Fl_Spinner.H>
#include "UI/MiscGui.h"
#include "UI/WidgetCheckButton.h"
#include "UI/WidgetSpinner.h"
#include "UI/ScaleTrackedWindow.h"
#include "Misc/Bank.h"
#include "Misc/Config.h"
#include "Misc/SynthEngine.h"
#include "Interface/TextLists.h"

class BankProcess_ {
public:
  virtual void process();
  Bank *bank;
};

class BankSlot : public Fl_Button, BankProcess_ {
public:
  BankSlot(int x,int y, int w, int h, const char *label=0);
  int handle(int event);
  void init(int nslot_, int *what_, int *whatslot_, void (BankProcess_:: *fnc_)(void), BankProcess_ *bp_, Bank *bank_, int *nselected_);
  void refresh(int bk, int rt, int last);
private:
  int *what, *whatslot, nslot, highlight, *nselected;
  void (BankProcess_:: *fnc)(void);
  BankProcess_ *bp;
protected:
  void draw();
private:
  int rootID;
  int bankID;
public:
  int lastSeen;
};

class RootProcess_ {
public:
  virtual void rootprocess();
  Bank *root;
};

class RootSlot : public Fl_Button, RootProcess_ {
public:
  RootSlot(int x,int y, int w, int h, const char *label=0);
  int handle(int event);
  void init(int nslot_, int *what_, int *whatslot_, void (RootProcess_:: *fnr_)(void), RootProcess_ *rp_, Bank *root_, int *rselected_);
  void rootrefresh(unsigned int currentBank, unsigned int rootID);
private:
  int *what, *whatslot, nslot, highlight, *nselected, *rselected;
  void (RootProcess_:: *fnr)(void);
  RootProcess_ *rp;
};
#include <FL/Fl_Choice.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Text_Display.H>
#include <FL/Fl_Group.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Browser.H>

class BankUI : public BankProcess_, RootProcess_ {
public:
  ScaleTrackedWindow* make_window();
  ScaleTrackedWindow *instrumentuiwindow;
private:
  inline void cb_instrumentuiwindow_i(ScaleTrackedWindow*, void*);
  static void cb_instrumentuiwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Choice *banklist;
private:
  inline void cb_banklist_i(Fl_Choice*, void*);
  static void cb_banklist(Fl_Choice*, void*);
public:
  Fl_Button *B_search;
private:
  inline void cb_B_search_i(Fl_Button*, void*);
  static void cb_B_search(Fl_Button*, void*);
public:
  Fl_Button *insRoots;
private:
  inline void cb_insRoots_i(Fl_Button*, void*);
  static void cb_insRoots(Fl_Button*, void*);
public:
  Fl_Button *insBanks;
private:
  inline void cb_insBanks_i(Fl_Button*, void*);
  static void cb_insBanks(Fl_Button*, void*);
public:
  Fl_Text_Display *insT1;
  Fl_Text_Display *insT2;
  Fl_Group *insgroup;
  Fl_Group *insframe1;
  Fl_Group *insframe2;
  Fl_Group *insframe3;
  Fl_Group *insframe4;
  Fl_Group *insframe5;
  Fl_Group *modeselect;
  Fl_Box *selectPatch;
  Fl_Button *readbutton;
private:
  inline void cb_readbutton_i(Fl_Button*, void*);
  static void cb_readbutton(Fl_Button*, void*);
public:
  Fl_Box *renamePatch;
  Fl_Button *renamebutton;
private:
  inline void cb_renamebutton_i(Fl_Button*, void*);
  static void cb_renamebutton(Fl_Button*, void*);
public:
  Fl_Box *savePatch;
  Fl_Button *writebutton;
private:
  inline void cb_writebutton_i(Fl_Button*, void*);
  static void cb_writebutton(Fl_Button*, void*);
public:
  Fl_Box *deletPatch;
  Fl_Button *clearbutton;
private:
  inline void cb_clearbutton_i(Fl_Button*, void*);
  static void cb_clearbutton(Fl_Button*, void*);
public:
  Fl_Box *swapPatch;
  Fl_Button *swapbutton;
private:
  inline void cb_swapbutton_i(Fl_Button*, void*);
  static void cb_swapbutton(Fl_Button*, void*);
public:
  Fl_Text_Display *insT3;
  Fl_Button *insClose;
private:
  inline void cb_insClose_i(Fl_Button*, void*);
  static void cb_insClose(Fl_Button*, void*);
public:
  Fl_Box *addpatch;
  Fl_Box *subpatch;
  Fl_Box *padpatch;
  ScaleTrackedWindow *searchwin;
private:
  inline void cb_searchwin_i(ScaleTrackedWindow*, void*);
  static void cb_searchwin(ScaleTrackedWindow*, void*);
public:
  Fl_Browser *searchbrowse;
private:
  inline void cb_searchbrowse_i(Fl_Browser*, void*);
  static void cb_searchbrowse(Fl_Browser*, void*);
public:
  Fl_Button *searchClose;
private:
  inline void cb_searchClose_i(Fl_Button*, void*);
  static void cb_searchClose(Fl_Button*, void*);
public:
  Fl_Button *searchT;
  Fl_Text_Display *noEntries;
  Fl_Choice *searchType;
private:
  inline void cb_searchType_i(Fl_Choice*, void*);
  static void cb_searchType(Fl_Choice*, void*);
public:
  ScaleTrackedWindow *bankuiwindow;
private:
  inline void cb_bankuiwindow_i(ScaleTrackedWindow*, void*);
  static void cb_bankuiwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Button *bankroot;
private:
  inline void cb_bankroot_i(Fl_Button*, void*);
  static void cb_bankroot(Fl_Button*, void*);
public:
  Fl_Button *bankcurrent;
  Fl_Button *bankinst;
private:
  inline void cb_bankinst_i(Fl_Button*, void*);
  static void cb_bankinst(Fl_Button*, void*);
public:
  Fl_Group *bankgroup;
  Fl_Group *rootmodeselect;
  Fl_Box *rootSelectPatch;
  Fl_Button *rootreadbutton;
private:
  inline void cb_rootreadbutton_i(Fl_Button*, void*);
  static void cb_rootreadbutton(Fl_Button*, void*);
public:
  Fl_Box *rootRenamePatch;
  Fl_Button *rootrenamebutton;
private:
  inline void cb_rootrenamebutton_i(Fl_Button*, void*);
  static void cb_rootrenamebutton(Fl_Button*, void*);
public:
  Fl_Box *rootSavePatch;
  Fl_Button *rootwritebutton;
private:
  inline void cb_rootwritebutton_i(Fl_Button*, void*);
  static void cb_rootwritebutton(Fl_Button*, void*);
public:
  Fl_Box *rootDeletPatch;
  Fl_Button *rootclearbutton;
private:
  inline void cb_rootclearbutton_i(Fl_Button*, void*);
  static void cb_rootclearbutton(Fl_Button*, void*);
public:
  Fl_Box *rootSwapPatch;
  Fl_Button *rootswapbutton;
private:
  inline void cb_rootswapbutton_i(Fl_Button*, void*);
  static void cb_rootswapbutton(Fl_Button*, void*);
public:
  Fl_Box *rootImportPatch;
  Fl_Button *rootimportbutton;
private:
  inline void cb_rootimportbutton_i(Fl_Button*, void*);
  static void cb_rootimportbutton(Fl_Button*, void*);
public:
  Fl_Box *rootExportPatch;
  Fl_Button *rootexportbutton;
private:
  inline void cb_rootexportbutton_i(Fl_Button*, void*);
  static void cb_rootexportbutton(Fl_Button*, void*);
public:
  Fl_Button *bankClose;
private:
  inline void cb_bankClose_i(Fl_Button*, void*);
  static void cb_bankClose(Fl_Button*, void*);
public:
  ScaleTrackedWindow *rootuiwindow;
private:
  inline void cb_rootuiwindow_i(ScaleTrackedWindow*, void*);
  static void cb_rootuiwindow(ScaleTrackedWindow*, void*);
public:
  Fl_Browser *rootsbrowse;
private:
  inline void cb_rootsbrowse_i(Fl_Browser*, void*);
  static void cb_rootsbrowse(Fl_Browser*, void*);
public:
  Fl_Button *addrootdirbutton;
private:
  inline void cb_addrootdirbutton_i(Fl_Button*, void*);
  static void cb_addrootdirbutton(Fl_Button*, void*);
public:
  Fl_Button *removerootdirbutton;
private:
  inline void cb_removerootdirbutton_i(Fl_Button*, void*);
  static void cb_removerootdirbutton(Fl_Button*, void*);
public:
  Fl_Button *makedefaultrootdirbutton;
private:
  inline void cb_makedefaultrootdirbutton_i(Fl_Button*, void*);
  static void cb_makedefaultrootdirbutton(Fl_Button*, void*);
public:
  Fl_Button *showdefaultrootdirbutton;
private:
  inline void cb_showdefaultrootdirbutton_i(Fl_Button*, void*);
  static void cb_showdefaultrootdirbutton(Fl_Button*, void*);
public:
  WidgetSpinner *changeIDbutton;
private:
  inline void cb_changeIDbutton_i(WidgetSpinner*, void*);
  static void cb_changeIDbutton(WidgetSpinner*, void*);
public:
  Fl_Button *Pend;
private:
  inline void cb_Pend_i(Fl_Button*, void*);
  static void cb_Pend(Fl_Button*, void*);
public:
  Fl_Button *rootClose;
private:
  inline void cb_rootClose_i(Fl_Button*, void*);
  static void cb_rootClose(Fl_Button*, void*);
public:
  void setHighlight(int button);
  void setRootHighlight(int button);
  void fillSearchChoice();
  void fillBrowser(int group);
  void send_data(int action, int control, float value, int type, int part = UNUSED, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int miscmsg = UNUSED);
  float fetchData(float value, int control, int part, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int offset = UNUSED, int miscmsg = UNUSED, int request = UNUSED);
  void returns_update(CommandBlock *getData);
  BankUI(SynthEngine *_synth);
  virtual ~BankUI();
  void Show();
  void ShowInst();
  void Showbank();
  void ShowRoot();
  void ShowSearch();
  void Hide(int type = 0);
  void init(Fl_Spinner *cbwig_);
  void process();
  void rootprocess();
  void refreshmainwindow();
  void refreshinstrumentwindow();
  void theme();
  void wincheck();
  void instrumentRtext();
  void searchRtext();
  void bankRtext();
  void rootRtext();
  void refreshbankslot(int ins, int bk, int rt, int last);
  void removeselection();
  void removeRootselection();
  void rescan_for_banks();
  void set_bank_slot();
  void activatebutton_rootdir(bool active);
  void readbankcfg();
  int recoverID();
private:
  BankSlot *bs[MAX_INSTRUMENTS_IN_BANK];
  RootSlot *rs[MAX_BANKS_IN_ROOT];
  int slot, what; // "what" = what button is pressed
  int mode, r_mode, nselected, rselected;
  void (BankProcess_::* fnc)(void);
  void (RootProcess_::* fnr)(void);
public:
  Fl_Spinner *cbwig;
private:
  SynthEngine *synth;
  int bankS;
  long selectedRootID;
  int oldrootID;
  string rootuiwindowlabel;
  int rootFrom;
  bool rootSeen;
  int rootDW;
  int lastrootW;
  int rootDH;
  int bankFrom;
  int lastbankW;
  int bankDW;
  int bankDH;
  bool bankSeen;
  int instFrom;
  int instDW;
  int instDH;
  int lastinstrumentW;
  bool instrumentSeen;
public:
  bool unsearched;
private:
  int searchDW;
  int searchDH;
  int lastsearchW;
  bool searchSeen;
};
#endif
