/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the X86 target                             *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 150;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(X86InstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(X86InstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static X86InstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static X86InstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_s1,
  GILLT_s8,
  GILLT_s16,
  GILLT_s32,
  GILLT_s64,
  GILLT_s80,
  GILLT_s128,
  GILLT_v2s1,
  GILLT_v2s64,
  GILLT_v4s1,
  GILLT_v4s32,
  GILLT_v4s64,
  GILLT_v8s1,
  GILLT_v8s16,
  GILLT_v8s32,
  GILLT_v8s64,
  GILLT_v16s1,
  GILLT_v16s8,
  GILLT_v16s16,
  GILLT_v16s32,
  GILLT_v32s1,
  GILLT_v32s8,
  GILLT_v32s16,
  GILLT_v64s1,
  GILLT_v64s8,
};
const static size_t NumTypeObjects = 25;
const static LLT TypeObjects[] = {
  LLT::scalar(1),
  LLT::scalar(8),
  LLT::scalar(16),
  LLT::scalar(32),
  LLT::scalar(64),
  LLT::scalar(80),
  LLT::scalar(128),
  LLT::vector(ElementCount::getFixed(2), 1),
  LLT::vector(ElementCount::getFixed(2), 64),
  LLT::vector(ElementCount::getFixed(4), 1),
  LLT::vector(ElementCount::getFixed(4), 32),
  LLT::vector(ElementCount::getFixed(4), 64),
  LLT::vector(ElementCount::getFixed(8), 1),
  LLT::vector(ElementCount::getFixed(8), 16),
  LLT::vector(ElementCount::getFixed(8), 32),
  LLT::vector(ElementCount::getFixed(8), 64),
  LLT::vector(ElementCount::getFixed(16), 1),
  LLT::vector(ElementCount::getFixed(16), 8),
  LLT::vector(ElementCount::getFixed(16), 16),
  LLT::vector(ElementCount::getFixed(16), 32),
  LLT::vector(ElementCount::getFixed(32), 1),
  LLT::vector(ElementCount::getFixed(32), 8),
  LLT::vector(ElementCount::getFixed(32), 16),
  LLT::vector(ElementCount::getFixed(64), 1),
  LLT::vector(ElementCount::getFixed(64), 8),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
  Feature_TruePredicateBit = 61,
  Feature_HasEGPRBit = 5,
  Feature_NoEGPRBit = 4,
  Feature_HasNDDBit = 6,
  Feature_NoNDDBit = 27,
  Feature_HasZUBit = 149,
  Feature_HasCFBit = 30,
  Feature_HasCMOVBit = 29,
  Feature_NoCMOVBit = 135,
  Feature_HasMMXBit = 107,
  Feature_HasSSE1Bit = 47,
  Feature_UseSSE1Bit = 54,
  Feature_HasSSE2Bit = 46,
  Feature_UseSSE2Bit = 55,
  Feature_HasSSE3Bit = 38,
  Feature_UseSSE3Bit = 64,
  Feature_HasSSSE3Bit = 108,
  Feature_UseSSSE3Bit = 65,
  Feature_UseSSE41Bit = 62,
  Feature_UseSSE42Bit = 69,
  Feature_HasSSE4ABit = 79,
  Feature_NoAVXBit = 75,
  Feature_HasAVXBit = 56,
  Feature_HasAVX2Bit = 50,
  Feature_HasAVX1OnlyBit = 48,
  Feature_HasEVEX512Bit = 142,
  Feature_HasAVX10_2Bit = 106,
  Feature_HasAVX10_2_512Bit = 105,
  Feature_NoAVX10_2Bit = 68,
  Feature_HasAVX512Bit = 92,
  Feature_UseAVXBit = 52,
  Feature_NoAVX512Bit = 43,
  Feature_HasCDIBit = 96,
  Feature_HasVPOPCNTDQBit = 100,
  Feature_HasDQIBit = 94,
  Feature_NoDQIBit = 66,
  Feature_HasBWIBit = 95,
  Feature_NoBWIBit = 63,
  Feature_HasVLXBit = 93,
  Feature_NoVLXBit = 42,
  Feature_NoVLX_Or_NoBWIBit = 60,
  Feature_HasVNNIBit = 102,
  Feature_HasVP2INTERSECTBit = 104,
  Feature_HasFP16Bit = 98,
  Feature_HasAVXVNNIINT16Bit = 91,
  Feature_HasAVXVNNIINT8Bit = 86,
  Feature_HasAVXVNNIBit = 80,
  Feature_NoVLX_Or_NoVNNIBit = 81,
  Feature_HasBITALGBit = 103,
  Feature_HasPOPCNTBit = 67,
  Feature_HasAESBit = 72,
  Feature_HasVAESBit = 74,
  Feature_NoVLX_Or_NoVAESBit = 73,
  Feature_HasFXSRBit = 39,
  Feature_HasX87Bit = 37,
  Feature_HasXSAVEBit = 124,
  Feature_HasXSAVEOPTBit = 125,
  Feature_HasXSAVECBit = 126,
  Feature_HasXSAVESBit = 127,
  Feature_HasPCLMULBit = 76,
  Feature_NoVLX_Or_NoVPCLMULQDQBit = 77,
  Feature_HasVPCLMULQDQBit = 78,
  Feature_HasGFNIBit = 83,
  Feature_HasFMABit = 40,
  Feature_HasFMA4Bit = 44,
  Feature_NoFMA4Bit = 41,
  Feature_HasXOPBit = 45,
  Feature_HasTBMBit = 26,
  Feature_NoTBMBit = 140,
  Feature_HasLWPBit = 12,
  Feature_HasMOVBEBit = 3,
  Feature_NoNDD_Or_NoMOVBEBit = 2,
  Feature_HasRDRANDBit = 7,
  Feature_HasF16CBit = 82,
  Feature_HasFSGSBaseBit = 128,
  Feature_HasLZCNTBit = 9,
  Feature_HasBMIBit = 10,
  Feature_HasBMI2Bit = 11,
  Feature_NoBMI2Bit = 139,
  Feature_HasVBMIBit = 97,
  Feature_HasVBMI2Bit = 101,
  Feature_HasIFMABit = 99,
  Feature_HasAVXIFMABit = 84,
  Feature_NoVLX_Or_NoIFMABit = 85,
  Feature_HasRTMBit = 110,
  Feature_HasSHABit = 71,
  Feature_HasSHA512Bit = 88,
  Feature_HasSM3Bit = 89,
  Feature_HasRDSEEDBit = 8,
  Feature_HasSSEPrefetchBit = 57,
  Feature_HasPREFETCHIBit = 20,
  Feature_HasPrefetchWBit = 109,
  Feature_HasMWAITXBit = 138,
  Feature_HasCLDEMOTEBit = 24,
  Feature_HasMOVDIRIBit = 14,
  Feature_HasMOVDIR64BBit = 15,
  Feature_HasMOVRSBit = 25,
  Feature_HasPTWRITEBit = 131,
  Feature_FPStackf32Bit = 35,
  Feature_FPStackf64Bit = 36,
  Feature_HasSM4Bit = 90,
  Feature_HasCLFLUSHBit = 58,
  Feature_HasCLFLUSHOPTBit = 22,
  Feature_HasCLWBBit = 23,
  Feature_HasWBNOINVDBit = 123,
  Feature_HasRDPIDBit = 130,
  Feature_HasWAITPKGBit = 13,
  Feature_HasINVPCIDBit = 129,
  Feature_HasCX8Bit = 136,
  Feature_HasCX16Bit = 137,
  Feature_HasENQCMDBit = 16,
  Feature_HasAMXFP16Bit = 115,
  Feature_HasCMPCCXADDBit = 21,
  Feature_HasAVXNECONVERTBit = 87,
  Feature_HasKLBit = 111,
  Feature_HasRAOINTBit = 121,
  Feature_HasSERIALIZEBit = 17,
  Feature_HasTSXLDTRKBit = 18,
  Feature_HasAMXTILEBit = 112,
  Feature_HasAMXBF16Bit = 114,
  Feature_HasAMXINT8Bit = 113,
  Feature_HasAMXCOMPLEXBit = 116,
  Feature_HasAMXFP8Bit = 117,
  Feature_HasAMXTRANSPOSEBit = 118,
  Feature_HasAMXAVX512Bit = 119,
  Feature_HasAMXTF32Bit = 120,
  Feature_HasUINTRBit = 19,
  Feature_HasUSERMSRBit = 122,
  Feature_HasCRC32Bit = 70,
  Feature_Not64BitModeBit = 0,
  Feature_In64BitModeBit = 1,
  Feature_IsLP64Bit = 133,
  Feature_NotLP64Bit = 132,
  Feature_NotWin64WithoutFPBit = 134,
  Feature_IsPSBit = 144,
  Feature_NotPSBit = 143,
  Feature_KernelCodeBit = 145,
  Feature_NearDataBit = 147,
  Feature_IsNotPICBit = 146,
  Feature_OptForSizeBit = 51,
  Feature_OptForMinSizeBit = 49,
  Feature_OptForSpeedBit = 141,
  Feature_UseIncDecBit = 28,
  Feature_NoSSE41_Or_OptForSizeBit = 53,
  Feature_CallImmAddrBit = 148,
  Feature_FavorMemIndirectCallBit = 31,
  Feature_HasFastSHLDRotateBit = 34,
  Feature_HasMFenceBit = 59,
  Feature_UseIndirectThunkCallsBit = 33,
  Feature_NotUseIndirectThunkCallsBit = 32,
};

PredicateBitset X86InstructionSelector::
computeAvailableModuleFeatures(const X86Subtarget *Subtarget) const {
  PredicateBitset Features{};
  if (true)
    Features.set(Feature_TruePredicateBit);
  if (Subtarget->hasEGPR())
    Features.set(Feature_HasEGPRBit);
  if (!Subtarget->hasEGPR())
    Features.set(Feature_NoEGPRBit);
  if (Subtarget->hasNDD())
    Features.set(Feature_HasNDDBit);
  if (!Subtarget->hasNDD())
    Features.set(Feature_NoNDDBit);
  if (Subtarget->hasZU())
    Features.set(Feature_HasZUBit);
  if (Subtarget->hasCF())
    Features.set(Feature_HasCFBit);
  if (Subtarget->canUseCMOV())
    Features.set(Feature_HasCMOVBit);
  if (!Subtarget->canUseCMOV())
    Features.set(Feature_NoCMOVBit);
  if (Subtarget->hasMMX())
    Features.set(Feature_HasMMXBit);
  if (Subtarget->hasSSE1())
    Features.set(Feature_HasSSE1Bit);
  if (Subtarget->hasSSE1() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE1Bit);
  if (Subtarget->hasSSE2())
    Features.set(Feature_HasSSE2Bit);
  if (Subtarget->hasSSE2() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE2Bit);
  if (Subtarget->hasSSE3())
    Features.set(Feature_HasSSE3Bit);
  if (Subtarget->hasSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE3Bit);
  if (Subtarget->hasSSSE3())
    Features.set(Feature_HasSSSE3Bit);
  if (Subtarget->hasSSSE3() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSSE3Bit);
  if (Subtarget->hasSSE41() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE41Bit);
  if (Subtarget->hasSSE42() && !Subtarget->hasAVX())
    Features.set(Feature_UseSSE42Bit);
  if (Subtarget->hasSSE4A())
    Features.set(Feature_HasSSE4ABit);
  if (!Subtarget->hasAVX())
    Features.set(Feature_NoAVXBit);
  if (Subtarget->hasAVX())
    Features.set(Feature_HasAVXBit);
  if (Subtarget->hasAVX2())
    Features.set(Feature_HasAVX2Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX2())
    Features.set(Feature_HasAVX1OnlyBit);
  if (Subtarget->hasEVEX512())
    Features.set(Feature_HasEVEX512Bit);
  if (Subtarget->hasAVX10_2())
    Features.set(Feature_HasAVX10_2Bit);
  if (Subtarget->hasAVX10_2_512())
    Features.set(Feature_HasAVX10_2_512Bit);
  if (!Subtarget->hasAVX10_2())
    Features.set(Feature_NoAVX10_2Bit);
  if (Subtarget->hasAVX512())
    Features.set(Feature_HasAVX512Bit);
  if (Subtarget->hasAVX() && !Subtarget->hasAVX512())
    Features.set(Feature_UseAVXBit);
  if (!Subtarget->hasAVX512())
    Features.set(Feature_NoAVX512Bit);
  if (Subtarget->hasCDI())
    Features.set(Feature_HasCDIBit);
  if (Subtarget->hasVPOPCNTDQ())
    Features.set(Feature_HasVPOPCNTDQBit);
  if (Subtarget->hasDQI())
    Features.set(Feature_HasDQIBit);
  if (!Subtarget->hasDQI())
    Features.set(Feature_NoDQIBit);
  if (Subtarget->hasBWI())
    Features.set(Feature_HasBWIBit);
  if (!Subtarget->hasBWI())
    Features.set(Feature_NoBWIBit);
  if (Subtarget->hasVLX())
    Features.set(Feature_HasVLXBit);
  if (!Subtarget->hasVLX())
    Features.set(Feature_NoVLXBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasBWI())
    Features.set(Feature_NoVLX_Or_NoBWIBit);
  if (Subtarget->hasVNNI())
    Features.set(Feature_HasVNNIBit);
  if (Subtarget->hasVP2INTERSECT())
    Features.set(Feature_HasVP2INTERSECTBit);
  if (Subtarget->hasFP16())
    Features.set(Feature_HasFP16Bit);
  if (Subtarget->hasAVXVNNIINT16())
    Features.set(Feature_HasAVXVNNIINT16Bit);
  if (Subtarget->hasAVXVNNIINT8())
    Features.set(Feature_HasAVXVNNIINT8Bit);
  if (Subtarget->hasAVXVNNI())
    Features.set(Feature_HasAVXVNNIBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVNNI())
    Features.set(Feature_NoVLX_Or_NoVNNIBit);
  if (Subtarget->hasBITALG())
    Features.set(Feature_HasBITALGBit);
  if (Subtarget->hasPOPCNT())
    Features.set(Feature_HasPOPCNTBit);
  if (Subtarget->hasAES())
    Features.set(Feature_HasAESBit);
  if (Subtarget->hasVAES())
    Features.set(Feature_HasVAESBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVAES())
    Features.set(Feature_NoVLX_Or_NoVAESBit);
  if (Subtarget->hasFXSR())
    Features.set(Feature_HasFXSRBit);
  if (Subtarget->hasX87())
    Features.set(Feature_HasX87Bit);
  if (Subtarget->hasXSAVE())
    Features.set(Feature_HasXSAVEBit);
  if (Subtarget->hasXSAVEOPT())
    Features.set(Feature_HasXSAVEOPTBit);
  if (Subtarget->hasXSAVEC())
    Features.set(Feature_HasXSAVECBit);
  if (Subtarget->hasXSAVES())
    Features.set(Feature_HasXSAVESBit);
  if (Subtarget->hasPCLMUL())
    Features.set(Feature_HasPCLMULBit);
  if (!Subtarget->hasVLX() || !Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_NoVLX_Or_NoVPCLMULQDQBit);
  if (Subtarget->hasVPCLMULQDQ())
    Features.set(Feature_HasVPCLMULQDQBit);
  if (Subtarget->hasGFNI())
    Features.set(Feature_HasGFNIBit);
  if (Subtarget->hasFMA())
    Features.set(Feature_HasFMABit);
  if (Subtarget->hasFMA4())
    Features.set(Feature_HasFMA4Bit);
  if (!Subtarget->hasFMA4())
    Features.set(Feature_NoFMA4Bit);
  if (Subtarget->hasXOP())
    Features.set(Feature_HasXOPBit);
  if (Subtarget->hasTBM())
    Features.set(Feature_HasTBMBit);
  if (!Subtarget->hasTBM())
    Features.set(Feature_NoTBMBit);
  if (Subtarget->hasLWP())
    Features.set(Feature_HasLWPBit);
  if (Subtarget->hasMOVBE())
    Features.set(Feature_HasMOVBEBit);
  if (!Subtarget->hasNDD() || !Subtarget->hasMOVBE())
    Features.set(Feature_NoNDD_Or_NoMOVBEBit);
  if (Subtarget->hasRDRAND())
    Features.set(Feature_HasRDRANDBit);
  if (Subtarget->hasF16C())
    Features.set(Feature_HasF16CBit);
  if (Subtarget->hasFSGSBase())
    Features.set(Feature_HasFSGSBaseBit);
  if (Subtarget->hasLZCNT())
    Features.set(Feature_HasLZCNTBit);
  if (Subtarget->hasBMI())
    Features.set(Feature_HasBMIBit);
  if (Subtarget->hasBMI2())
    Features.set(Feature_HasBMI2Bit);
  if (!Subtarget->hasBMI2())
    Features.set(Feature_NoBMI2Bit);
  if (Subtarget->hasVBMI())
    Features.set(Feature_HasVBMIBit);
  if (Subtarget->hasVBMI2())
    Features.set(Feature_HasVBMI2Bit);
  if (Subtarget->hasIFMA())
    Features.set(Feature_HasIFMABit);
  if (Subtarget->hasAVXIFMA())
    Features.set(Feature_HasAVXIFMABit);
  if (!Subtarget->hasVLX() || !Subtarget->hasIFMA())
    Features.set(Feature_NoVLX_Or_NoIFMABit);
  if (Subtarget->hasRTM())
    Features.set(Feature_HasRTMBit);
  if (Subtarget->hasSHA())
    Features.set(Feature_HasSHABit);
  if (Subtarget->hasSHA512())
    Features.set(Feature_HasSHA512Bit);
  if (Subtarget->hasSM3())
    Features.set(Feature_HasSM3Bit);
  if (Subtarget->hasRDSEED())
    Features.set(Feature_HasRDSEEDBit);
  if (Subtarget->hasSSEPrefetch())
    Features.set(Feature_HasSSEPrefetchBit);
  if (Subtarget->hasPREFETCHI())
    Features.set(Feature_HasPREFETCHIBit);
  if (Subtarget->hasPrefetchW())
    Features.set(Feature_HasPrefetchWBit);
  if (Subtarget->hasMWAITX())
    Features.set(Feature_HasMWAITXBit);
  if (Subtarget->hasCLDEMOTE())
    Features.set(Feature_HasCLDEMOTEBit);
  if (Subtarget->hasMOVDIRI())
    Features.set(Feature_HasMOVDIRIBit);
  if (Subtarget->hasMOVDIR64B())
    Features.set(Feature_HasMOVDIR64BBit);
  if (Subtarget->hasMOVRS())
    Features.set(Feature_HasMOVRSBit);
  if (Subtarget->hasPTWRITE())
    Features.set(Feature_HasPTWRITEBit);
  if (!Subtarget->hasSSE1())
    Features.set(Feature_FPStackf32Bit);
  if (!Subtarget->hasSSE2())
    Features.set(Feature_FPStackf64Bit);
  if (Subtarget->hasSM4())
    Features.set(Feature_HasSM4Bit);
  if (Subtarget->hasCLFLUSH())
    Features.set(Feature_HasCLFLUSHBit);
  if (Subtarget->hasCLFLUSHOPT())
    Features.set(Feature_HasCLFLUSHOPTBit);
  if (Subtarget->hasCLWB())
    Features.set(Feature_HasCLWBBit);
  if (Subtarget->hasWBNOINVD())
    Features.set(Feature_HasWBNOINVDBit);
  if (Subtarget->hasRDPID())
    Features.set(Feature_HasRDPIDBit);
  if (Subtarget->hasWAITPKG())
    Features.set(Feature_HasWAITPKGBit);
  if (Subtarget->hasINVPCID())
    Features.set(Feature_HasINVPCIDBit);
  if (Subtarget->hasCX8())
    Features.set(Feature_HasCX8Bit);
  if (Subtarget->hasCX16())
    Features.set(Feature_HasCX16Bit);
  if (Subtarget->hasENQCMD())
    Features.set(Feature_HasENQCMDBit);
  if (Subtarget->hasAMXFP16())
    Features.set(Feature_HasAMXFP16Bit);
  if (Subtarget->hasCMPCCXADD())
    Features.set(Feature_HasCMPCCXADDBit);
  if (Subtarget->hasAVXNECONVERT())
    Features.set(Feature_HasAVXNECONVERTBit);
  if (Subtarget->hasKL())
    Features.set(Feature_HasKLBit);
  if (Subtarget->hasRAOINT())
    Features.set(Feature_HasRAOINTBit);
  if (Subtarget->hasSERIALIZE())
    Features.set(Feature_HasSERIALIZEBit);
  if (Subtarget->hasTSXLDTRK())
    Features.set(Feature_HasTSXLDTRKBit);
  if (Subtarget->hasAMXTILE())
    Features.set(Feature_HasAMXTILEBit);
  if (Subtarget->hasAMXBF16())
    Features.set(Feature_HasAMXBF16Bit);
  if (Subtarget->hasAMXINT8())
    Features.set(Feature_HasAMXINT8Bit);
  if (Subtarget->hasAMXCOMPLEX())
    Features.set(Feature_HasAMXCOMPLEXBit);
  if (Subtarget->hasAMXFP8())
    Features.set(Feature_HasAMXFP8Bit);
  if (Subtarget->hasAMXTRANSPOSE())
    Features.set(Feature_HasAMXTRANSPOSEBit);
  if (Subtarget->hasAMXAVX512())
    Features.set(Feature_HasAMXAVX512Bit);
  if (Subtarget->hasAMXTF32())
    Features.set(Feature_HasAMXTF32Bit);
  if (Subtarget->hasUINTR())
    Features.set(Feature_HasUINTRBit);
  if (Subtarget->hasUSERMSR())
    Features.set(Feature_HasUSERMSRBit);
  if (Subtarget->hasCRC32())
    Features.set(Feature_HasCRC32Bit);
  if (!Subtarget->is64Bit())
    Features.set(Feature_Not64BitModeBit);
  if (Subtarget->is64Bit())
    Features.set(Feature_In64BitModeBit);
  if (Subtarget->isTarget64BitLP64())
    Features.set(Feature_IsLP64Bit);
  if (!Subtarget->isTarget64BitLP64())
    Features.set(Feature_NotLP64Bit);
  if (Subtarget->isTargetPS())
    Features.set(Feature_IsPSBit);
  if (!Subtarget->isTargetPS())
    Features.set(Feature_NotPSBit);
  if (TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_KernelCodeBit);
  if (TM.getCodeModel() == CodeModel::Small ||TM.getCodeModel() == CodeModel::Kernel)
    Features.set(Feature_NearDataBit);
  if (!TM.isPositionIndependent())
    Features.set(Feature_IsNotPICBit);
  if (Subtarget->isLegalToCallImmediateAddr())
    Features.set(Feature_CallImmAddrBit);
  if (!Subtarget->slowTwoMemOps())
    Features.set(Feature_FavorMemIndirectCallBit);
  if (Subtarget->hasFastSHLDRotate())
    Features.set(Feature_HasFastSHLDRotateBit);
  if (Subtarget->hasMFence())
    Features.set(Feature_HasMFenceBit);
  if (Subtarget->useIndirectThunkCalls())
    Features.set(Feature_UseIndirectThunkCallsBit);
  if (!Subtarget->useIndirectThunkCalls())
    Features.set(Feature_NotUseIndirectThunkCallsBit);
  return Features;
}

void X86InstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const X86Subtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset X86InstructionSelector::
computeAvailableFunctionFeatures(const X86Subtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  if (!Subtarget->isTargetWin64() ||Subtarget->getFrameLowering()->hasFP(*MF))
    Features.set(Feature_NotWin64WithoutFPBit);
  if (shouldOptForSize(MF))
    Features.set(Feature_OptForSizeBit);
  if (MF->getFunction().hasMinSize())
    Features.set(Feature_OptForMinSizeBit);
  if (!shouldOptForSize(MF))
    Features.set(Feature_OptForSpeedBit);
  if (!Subtarget->slowIncDec() || shouldOptForSize(MF))
    Features.set(Feature_UseIncDecBit);
  if (shouldOptForSize(MF) || !Subtarget->hasSSE41())
    Features.set(Feature_NoSSE41_Or_OptForSizeBit);
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
  GIFBS_FPStackf32,
  GIFBS_FPStackf64,
  GIFBS_HasAVX,
  GIFBS_HasAVX1Only,
  GIFBS_HasAVX2,
  GIFBS_HasAVX512,
  GIFBS_HasBITALG,
  GIFBS_HasBMI,
  GIFBS_HasBWI,
  GIFBS_HasCDI,
  GIFBS_HasDQI,
  GIFBS_HasFP16,
  GIFBS_HasFastSHLDRotate,
  GIFBS_HasKL,
  GIFBS_HasLWP,
  GIFBS_HasLZCNT,
  GIFBS_HasMFence,
  GIFBS_HasMMX,
  GIFBS_HasMOVBE,
  GIFBS_HasMWAITX,
  GIFBS_HasNDD,
  GIFBS_HasPOPCNT,
  GIFBS_HasPTWRITE,
  GIFBS_HasRTM,
  GIFBS_HasSERIALIZE,
  GIFBS_HasSHA,
  GIFBS_HasSHA512,
  GIFBS_HasSM3,
  GIFBS_HasSM4,
  GIFBS_HasSSE1,
  GIFBS_HasSSE2,
  GIFBS_HasSSE3,
  GIFBS_HasSSE4A,
  GIFBS_HasTBM,
  GIFBS_HasTSXLDTRK,
  GIFBS_HasVBMI2,
  GIFBS_HasVLX,
  GIFBS_HasVPOPCNTDQ,
  GIFBS_HasWAITPKG,
  GIFBS_HasWBNOINVD,
  GIFBS_HasX87,
  GIFBS_HasXOP,
  GIFBS_HasZU,
  GIFBS_In64BitMode,
  GIFBS_IsPS,
  GIFBS_NoDQI,
  GIFBS_NoNDD,
  GIFBS_NoNDD_Or_NoMOVBE,
  GIFBS_Not64BitMode,
  GIFBS_NotPS,
  GIFBS_UseAVX,
  GIFBS_UseSSE1,
  GIFBS_UseSSE2,
  GIFBS_UseSSE41,
  GIFBS_UseSSSE3,
  GIFBS_HasAES_HasAVX,
  GIFBS_HasAES_NoAVX,
  GIFBS_HasAMXBF16_In64BitMode,
  GIFBS_HasAMXCOMPLEX_In64BitMode,
  GIFBS_HasAMXFP16_In64BitMode,
  GIFBS_HasAMXFP8_In64BitMode,
  GIFBS_HasAMXINT8_In64BitMode,
  GIFBS_HasAMXTF32_In64BitMode,
  GIFBS_HasAMXTILE_In64BitMode,
  GIFBS_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAVX_In64BitMode,
  GIFBS_HasAVX_NoAVX10_2,
  GIFBS_HasAVX_NoBWI,
  GIFBS_HasAVX_NoVLX,
  GIFBS_HasAVX_NoVLX_Or_NoBWI,
  GIFBS_HasAVX10_2_HasSM4,
  GIFBS_HasAVX10_2_512_HasSM4,
  GIFBS_HasAVX2_NoVLX,
  GIFBS_HasAVX2_NoVLX_Or_NoBWI,
  GIFBS_HasAVX512_HasVAES,
  GIFBS_HasAVX512_HasVLX,
  GIFBS_HasAVX512_HasVPCLMULQDQ,
  GIFBS_HasAVX512_NoBWI,
  GIFBS_HasAVX512_NoDQI,
  GIFBS_HasBITALG_HasVLX,
  GIFBS_HasBMI_HasEGPR,
  GIFBS_HasBMI_NoEGPR,
  GIFBS_HasBMI2_HasEGPR,
  GIFBS_HasBMI2_NoEGPR,
  GIFBS_HasBWI_HasVLX,
  GIFBS_HasCDI_HasVLX,
  GIFBS_HasCRC32_NoEGPR,
  GIFBS_HasDQI_HasVLX,
  GIFBS_HasDQI_NoBWI,
  GIFBS_HasEVEX512_NoVLX,
  GIFBS_HasFMA4_NoAVX512,
  GIFBS_HasFMA4_NoVLX,
  GIFBS_HasFP16_HasVLX,
  GIFBS_HasFSGSBase_In64BitMode,
  GIFBS_HasNDD_In64BitMode,
  GIFBS_HasNDD_UseIncDec,
  GIFBS_HasPCLMUL_NoAVX,
  GIFBS_HasPTWRITE_In64BitMode,
  GIFBS_HasRDPID_In64BitMode,
  GIFBS_HasRDPID_Not64BitMode,
  GIFBS_HasUINTR_In64BitMode,
  GIFBS_HasUSERMSR_NoEGPR,
  GIFBS_HasVAES_HasVLX,
  GIFBS_HasVAES_NoVLX,
  GIFBS_HasVBMI2_HasVLX,
  GIFBS_HasVLX_HasVPCLMULQDQ,
  GIFBS_HasVLX_HasVPOPCNTDQ,
  GIFBS_HasVPCLMULQDQ_NoVLX,
  GIFBS_HasWAITPKG_In64BitMode,
  GIFBS_HasWAITPKG_Not64BitMode,
  GIFBS_In64BitMode_UseSSE2,
  GIFBS_NoNDD_UseIncDec,
  GIFBS_Not64BitMode_OptForSize,
  GIFBS_NotWin64WithoutFP_OptForMinSize,
  GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES,
  GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode,
  GIFBS_HasAMXBF16_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXCOMPLEX_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXFP16_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAMXTF32_HasAMXTRANSPOSE_In64BitMode,
  GIFBS_HasAVX_HasPCLMUL_NoVLX_Or_NoVPCLMULQDQ,
  GIFBS_HasAVX512_HasEVEX512_NoVLX,
  GIFBS_HasBITALG_HasEVEX512_NoVLX,
  GIFBS_HasBWI_HasEVEX512_NoVLX,
  GIFBS_HasCDI_HasEVEX512_NoVLX,
  GIFBS_HasCRC32_HasEGPR_In64BitMode,
  GIFBS_HasDQI_HasEVEX512_NoVLX,
  GIFBS_HasDQI_HasVLX_NoBWI,
  GIFBS_HasEGPR_HasUSERMSR_In64BitMode,
  GIFBS_HasEVEX512_HasVPOPCNTDQ_NoVLX,
  GIFBS_HasFMA_NoAVX512_NoFMA4,
  GIFBS_HasFMA_NoFMA4_NoVLX,
  GIFBS_HasMOVBE_HasNDD_In64BitMode,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
  {Feature_FPStackf32Bit, },
  {Feature_FPStackf64Bit, },
  {Feature_HasAVXBit, },
  {Feature_HasAVX1OnlyBit, },
  {Feature_HasAVX2Bit, },
  {Feature_HasAVX512Bit, },
  {Feature_HasBITALGBit, },
  {Feature_HasBMIBit, },
  {Feature_HasBWIBit, },
  {Feature_HasCDIBit, },
  {Feature_HasDQIBit, },
  {Feature_HasFP16Bit, },
  {Feature_HasFastSHLDRotateBit, },
  {Feature_HasKLBit, },
  {Feature_HasLWPBit, },
  {Feature_HasLZCNTBit, },
  {Feature_HasMFenceBit, },
  {Feature_HasMMXBit, },
  {Feature_HasMOVBEBit, },
  {Feature_HasMWAITXBit, },
  {Feature_HasNDDBit, },
  {Feature_HasPOPCNTBit, },
  {Feature_HasPTWRITEBit, },
  {Feature_HasRTMBit, },
  {Feature_HasSERIALIZEBit, },
  {Feature_HasSHABit, },
  {Feature_HasSHA512Bit, },
  {Feature_HasSM3Bit, },
  {Feature_HasSM4Bit, },
  {Feature_HasSSE1Bit, },
  {Feature_HasSSE2Bit, },
  {Feature_HasSSE3Bit, },
  {Feature_HasSSE4ABit, },
  {Feature_HasTBMBit, },
  {Feature_HasTSXLDTRKBit, },
  {Feature_HasVBMI2Bit, },
  {Feature_HasVLXBit, },
  {Feature_HasVPOPCNTDQBit, },
  {Feature_HasWAITPKGBit, },
  {Feature_HasWBNOINVDBit, },
  {Feature_HasX87Bit, },
  {Feature_HasXOPBit, },
  {Feature_HasZUBit, },
  {Feature_In64BitModeBit, },
  {Feature_IsPSBit, },
  {Feature_NoDQIBit, },
  {Feature_NoNDDBit, },
  {Feature_NoNDD_Or_NoMOVBEBit, },
  {Feature_Not64BitModeBit, },
  {Feature_NotPSBit, },
  {Feature_UseAVXBit, },
  {Feature_UseSSE1Bit, },
  {Feature_UseSSE2Bit, },
  {Feature_UseSSE41Bit, },
  {Feature_UseSSSE3Bit, },
  {Feature_HasAESBit, Feature_HasAVXBit, },
  {Feature_HasAESBit, Feature_NoAVXBit, },
  {Feature_HasAMXBF16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXCOMPLEXBit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP16Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP8Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXINT8Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXTF32Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXTILEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_NoAVX10_2Bit, },
  {Feature_HasAVXBit, Feature_NoBWIBit, },
  {Feature_HasAVXBit, Feature_NoVLXBit, },
  {Feature_HasAVXBit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX10_2Bit, Feature_HasSM4Bit, },
  {Feature_HasAVX10_2_512Bit, Feature_HasSM4Bit, },
  {Feature_HasAVX2Bit, Feature_NoVLXBit, },
  {Feature_HasAVX2Bit, Feature_NoVLX_Or_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_HasVAESBit, },
  {Feature_HasAVX512Bit, Feature_HasVLXBit, },
  {Feature_HasAVX512Bit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasAVX512Bit, Feature_NoBWIBit, },
  {Feature_HasAVX512Bit, Feature_NoDQIBit, },
  {Feature_HasBITALGBit, Feature_HasVLXBit, },
  {Feature_HasBMIBit, Feature_HasEGPRBit, },
  {Feature_HasBMIBit, Feature_NoEGPRBit, },
  {Feature_HasBMI2Bit, Feature_HasEGPRBit, },
  {Feature_HasBMI2Bit, Feature_NoEGPRBit, },
  {Feature_HasBWIBit, Feature_HasVLXBit, },
  {Feature_HasCDIBit, Feature_HasVLXBit, },
  {Feature_HasCRC32Bit, Feature_NoEGPRBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, },
  {Feature_HasDQIBit, Feature_NoBWIBit, },
  {Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasFMA4Bit, Feature_NoAVX512Bit, },
  {Feature_HasFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasFP16Bit, Feature_HasVLXBit, },
  {Feature_HasFSGSBaseBit, Feature_In64BitModeBit, },
  {Feature_HasNDDBit, Feature_In64BitModeBit, },
  {Feature_HasNDDBit, Feature_UseIncDecBit, },
  {Feature_HasPCLMULBit, Feature_NoAVXBit, },
  {Feature_HasPTWRITEBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_In64BitModeBit, },
  {Feature_HasRDPIDBit, Feature_Not64BitModeBit, },
  {Feature_HasUINTRBit, Feature_In64BitModeBit, },
  {Feature_HasUSERMSRBit, Feature_NoEGPRBit, },
  {Feature_HasVAESBit, Feature_HasVLXBit, },
  {Feature_HasVAESBit, Feature_NoVLXBit, },
  {Feature_HasVBMI2Bit, Feature_HasVLXBit, },
  {Feature_HasVLXBit, Feature_HasVPCLMULQDQBit, },
  {Feature_HasVLXBit, Feature_HasVPOPCNTDQBit, },
  {Feature_HasVPCLMULQDQBit, Feature_NoVLXBit, },
  {Feature_HasWAITPKGBit, Feature_In64BitModeBit, },
  {Feature_HasWAITPKGBit, Feature_Not64BitModeBit, },
  {Feature_In64BitModeBit, Feature_UseSSE2Bit, },
  {Feature_NoNDDBit, Feature_UseIncDecBit, },
  {Feature_Not64BitModeBit, Feature_OptForSizeBit, },
  {Feature_NotWin64WithoutFPBit, Feature_OptForMinSizeBit, },
  {Feature_HasAESBit, Feature_HasAVXBit, Feature_NoVLX_Or_NoVAESBit, },
  {Feature_HasAMXAVX512Bit, Feature_HasAVX10_2_512Bit, Feature_In64BitModeBit, },
  {Feature_HasAMXBF16Bit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXCOMPLEXBit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXFP16Bit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAMXTF32Bit, Feature_HasAMXTRANSPOSEBit, Feature_In64BitModeBit, },
  {Feature_HasAVXBit, Feature_HasPCLMULBit, Feature_NoVLX_Or_NoVPCLMULQDQBit, },
  {Feature_HasAVX512Bit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasBITALGBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasBWIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasCDIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasCRC32Bit, Feature_HasEGPRBit, Feature_In64BitModeBit, },
  {Feature_HasDQIBit, Feature_HasEVEX512Bit, Feature_NoVLXBit, },
  {Feature_HasDQIBit, Feature_HasVLXBit, Feature_NoBWIBit, },
  {Feature_HasEGPRBit, Feature_HasUSERMSRBit, Feature_In64BitModeBit, },
  {Feature_HasEVEX512Bit, Feature_HasVPOPCNTDQBit, Feature_NoVLXBit, },
  {Feature_HasFMABit, Feature_NoAVX512Bit, Feature_NoFMA4Bit, },
  {Feature_HasFMABit, Feature_NoFMA4Bit, Feature_NoVLXBit, },
  {Feature_HasMOVBEBit, Feature_HasNDDBit, Feature_In64BitModeBit, },
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

X86InstructionSelector::ComplexMatcherMemFn
X86InstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
bool X86InstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_I64_Predicate_AndMask64 = GICXXPred_Invalid + 1,
  GICXXPred_I64_Predicate_BTCBTSMask64,
  GICXXPred_I64_Predicate_BTRMask64,
  GICXXPred_I64_Predicate_i16immSExt8,
  GICXXPred_I64_Predicate_i32immSExt8,
  GICXXPred_I64_Predicate_i64immSExt8,
  GICXXPred_I64_Predicate_i64immSExt32,
  GICXXPred_I64_Predicate_i64immZExt32,
  GICXXPred_I64_Predicate_i64immZExt32SExt8,
  GICXXPred_I64_Predicate_i64timmSExt32,
  GICXXPred_I64_Predicate_immff00_ffff,
};
bool X86InstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  switch (PredicateID) {
  case GICXXPred_I64_Predicate_AndMask64: {
    
      return isMask_64(Imm) && !isUInt<32>(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTCBTSMask64: {
    
      return !isInt<32>(Imm) && isPowerOf2_64(Imm);
    
  }
  case GICXXPred_I64_Predicate_BTRMask64: {
    
      return !isUInt<32>(Imm) && !isInt<32>(Imm) && isPowerOf2_64(~Imm);
    
  }
  case GICXXPred_I64_Predicate_i16immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i32immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt8: {
     return isInt<8>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32: {
     return isUInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_i64immZExt32SExt8: {
    
      return isUInt<32>(Imm) && isInt<8>(static_cast<int32_t>(Imm));
    
  }
  case GICXXPred_I64_Predicate_i64timmSExt32: {
     return isInt<32>(Imm); 
  }
  case GICXXPred_I64_Predicate_immff00_ffff: {
    
      return Imm >= 0xff00 && Imm <= 0xffff;
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APFloat_Predicate_fpimm0 = GICXXPred_Invalid + 1,
  GICXXPred_APFloat_Predicate_fpimm1,
  GICXXPred_APFloat_Predicate_fpimmneg0,
  GICXXPred_APFloat_Predicate_fpimmneg1,
};
bool X86InstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APFloat_Predicate_fpimm0: {
    
      return Imm.isExactlyValue(+0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimm1: {
    
      return Imm.isExactlyValue(+1.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg0: {
    
      return Imm.isExactlyValue(-0.0);
    
  }
  case GICXXPred_APFloat_Predicate_fpimmneg1: {
    
      return Imm.isExactlyValue(-1.0);
    
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool X86InstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
bool X86InstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("X86InstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
X86InstructionSelector::CustomRendererFn
X86InstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool X86InstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool X86InstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("X86InstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *X86InstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
    GIM_SwitchOpcode, /*MI*/0, /*[*/GIMT_Encode2(55), GIMT_Encode2(289), /*)*//*default:*//*Label 70*/ GIMT_Encode4(90083),
    /*TargetOpcode::G_ADD*//*Label 0*/ GIMT_Encode4(946),
    /*TargetOpcode::G_SUB*//*Label 1*/ GIMT_Encode4(3304),
    /*TargetOpcode::G_MUL*//*Label 2*/ GIMT_Encode4(5120), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_AND*//*Label 3*/ GIMT_Encode4(6345),
    /*TargetOpcode::G_OR*//*Label 4*/ GIMT_Encode4(12189),
    /*TargetOpcode::G_XOR*//*Label 5*/ GIMT_Encode4(16581), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_CONCAT_VECTORS*//*Label 6*/ GIMT_Encode4(25028), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BITCAST*//*Label 7*/ GIMT_Encode4(25195), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC_LRINT*//*Label 8*/ GIMT_Encode4(26952),
    /*TargetOpcode::G_INTRINSIC_LLRINT*//*Label 9*/ GIMT_Encode4(27814), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_INTRINSIC*//*Label 10*/ GIMT_Encode4(28208),
    /*TargetOpcode::G_INTRINSIC_W_SIDE_EFFECTS*//*Label 11*/ GIMT_Encode4(33806), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_ANYEXT*//*Label 12*/ GIMT_Encode4(37450),
    /*TargetOpcode::G_TRUNC*//*Label 13*/ GIMT_Encode4(37885),
    /*TargetOpcode::G_CONSTANT*//*Label 14*/ GIMT_Encode4(38898),
    /*TargetOpcode::G_FCONSTANT*//*Label 15*/ GIMT_Encode4(39504), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SEXT*//*Label 16*/ GIMT_Encode4(39957),
    /*TargetOpcode::G_SEXT_INREG*//*Label 17*/ GIMT_Encode4(40980),
    /*TargetOpcode::G_ZEXT*//*Label 18*/ GIMT_Encode4(41222),
    /*TargetOpcode::G_SHL*//*Label 19*/ GIMT_Encode4(42330),
    /*TargetOpcode::G_LSHR*//*Label 20*/ GIMT_Encode4(43518),
    /*TargetOpcode::G_ASHR*//*Label 21*/ GIMT_Encode4(44498),
    /*TargetOpcode::G_FSHL*//*Label 22*/ GIMT_Encode4(45478),
    /*TargetOpcode::G_FSHR*//*Label 23*/ GIMT_Encode4(45854),
    /*TargetOpcode::G_ROTR*//*Label 24*/ GIMT_Encode4(46230),
    /*TargetOpcode::G_ROTL*//*Label 25*/ GIMT_Encode4(48212),
    /*TargetOpcode::G_ICMP*//*Label 26*/ GIMT_Encode4(50196), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SELECT*//*Label 27*/ GIMT_Encode4(51853), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_UMULH*//*Label 28*/ GIMT_Encode4(58661),
    /*TargetOpcode::G_SMULH*//*Label 29*/ GIMT_Encode4(58908),
    /*TargetOpcode::G_UADDSAT*//*Label 30*/ GIMT_Encode4(59155),
    /*TargetOpcode::G_SADDSAT*//*Label 31*/ GIMT_Encode4(59605),
    /*TargetOpcode::G_USUBSAT*//*Label 32*/ GIMT_Encode4(60055),
    /*TargetOpcode::G_SSUBSAT*//*Label 33*/ GIMT_Encode4(60505), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FADD*//*Label 34*/ GIMT_Encode4(60955),
    /*TargetOpcode::G_FSUB*//*Label 35*/ GIMT_Encode4(61971),
    /*TargetOpcode::G_FMUL*//*Label 36*/ GIMT_Encode4(62987),
    /*TargetOpcode::G_FMA*//*Label 37*/ GIMT_Encode4(64003), GIMT_Encode4(0),
    /*TargetOpcode::G_FDIV*//*Label 38*/ GIMT_Encode4(65131), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FNEG*//*Label 39*/ GIMT_Encode4(66147),
    /*TargetOpcode::G_FPEXT*//*Label 40*/ GIMT_Encode4(66270),
    /*TargetOpcode::G_FPTRUNC*//*Label 41*/ GIMT_Encode4(66840),
    /*TargetOpcode::G_FPTOSI*//*Label 42*/ GIMT_Encode4(67167),
    /*TargetOpcode::G_FPTOUI*//*Label 43*/ GIMT_Encode4(67664),
    /*TargetOpcode::G_SITOFP*//*Label 44*/ GIMT_Encode4(67866),
    /*TargetOpcode::G_UITOFP*//*Label 45*/ GIMT_Encode4(69128), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FABS*//*Label 46*/ GIMT_Encode4(69978), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_SMIN*//*Label 47*/ GIMT_Encode4(70101),
    /*TargetOpcode::G_SMAX*//*Label 48*/ GIMT_Encode4(71198),
    /*TargetOpcode::G_UMIN*//*Label 49*/ GIMT_Encode4(72295),
    /*TargetOpcode::G_UMAX*//*Label 50*/ GIMT_Encode4(73392),
    /*TargetOpcode::G_ABS*//*Label 51*/ GIMT_Encode4(74489), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_BR*//*Label 52*/ GIMT_Encode4(75354), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_EXTRACT_SUBVECTOR*//*Label 53*/ GIMT_Encode4(75370), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_VECTOR_COMPRESS*//*Label 54*/ GIMT_Encode4(78299),
    /*TargetOpcode::G_CTTZ*//*Label 55*/ GIMT_Encode4(80281),
    /*TargetOpcode::G_CTTZ_ZERO_UNDEF*//*Label 56*/ GIMT_Encode4(80404),
    /*TargetOpcode::G_CTLZ*//*Label 57*/ GIMT_Encode4(80566), GIMT_Encode4(0),
    /*TargetOpcode::G_CTPOP*//*Label 58*/ GIMT_Encode4(81347),
    /*TargetOpcode::G_BSWAP*//*Label 59*/ GIMT_Encode4(82746), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_FSQRT*//*Label 60*/ GIMT_Encode4(82922), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FADD*//*Label 61*/ GIMT_Encode4(83874),
    /*TargetOpcode::G_STRICT_FSUB*//*Label 62*/ GIMT_Encode4(84890),
    /*TargetOpcode::G_STRICT_FMUL*//*Label 63*/ GIMT_Encode4(85906),
    /*TargetOpcode::G_STRICT_FDIV*//*Label 64*/ GIMT_Encode4(86922), GIMT_Encode4(0),
    /*TargetOpcode::G_STRICT_FMA*//*Label 65*/ GIMT_Encode4(87938),
    /*TargetOpcode::G_STRICT_FSQRT*//*Label 66*/ GIMT_Encode4(89066), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*TargetOpcode::G_TRAP*//*Label 67*/ GIMT_Encode4(90018),
    /*TargetOpcode::G_DEBUGTRAP*//*Label 68*/ GIMT_Encode4(90031),
    /*TargetOpcode::G_UBSANTRAP*//*Label 69*/ GIMT_Encode4(90067),
    // Label 0: @946
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 87*/ GIMT_Encode4(3303),
    /*GILLT_s8*//*Label 71*/ GIMT_Encode4(1053),
    /*GILLT_s16*//*Label 72*/ GIMT_Encode4(1286),
    /*GILLT_s32*//*Label 73*/ GIMT_Encode4(1587),
    /*GILLT_s64*//*Label 74*/ GIMT_Encode4(1888), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 75*/ GIMT_Encode4(2279), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 76*/ GIMT_Encode4(2373),
    /*GILLT_v4s64*//*Label 77*/ GIMT_Encode4(2589), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 78*/ GIMT_Encode4(2656),
    /*GILLT_v8s32*//*Label 79*/ GIMT_Encode4(2872),
    /*GILLT_v8s64*//*Label 80*/ GIMT_Encode4(2939), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 81*/ GIMT_Encode4(2973),
    /*GILLT_v16s16*//*Label 82*/ GIMT_Encode4(3067),
    /*GILLT_v16s32*//*Label 83*/ GIMT_Encode4(3134), GIMT_Encode4(0),
    /*GILLT_v32s8*//*Label 84*/ GIMT_Encode4(3168),
    /*GILLT_v32s16*//*Label 85*/ GIMT_Encode4(3235), GIMT_Encode4(0),
    /*GILLT_v64s8*//*Label 86*/ GIMT_Encode4(3269),
    // Label 71: @1053
    GIM_Try, /*On fail goto*//*Label 88*/ GIMT_Encode4(1285),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 89*/ GIMT_Encode4(1096), // Rule ID 23286 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23286,
        GIR_EraseRootFromParent_Done,
      // Label 89: @1096
      GIM_Try, /*On fail goto*//*Label 90*/ GIMT_Encode4(1120), // Rule ID 23290 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23290,
        GIR_EraseRootFromParent_Done,
      // Label 90: @1120
      GIM_Try, /*On fail goto*//*Label 91*/ GIMT_Encode4(1144), // Rule ID 23376 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, 1:{ *:[i8] })  =>  (INC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23376,
        GIR_EraseRootFromParent_Done,
      // Label 91: @1144
      GIM_Try, /*On fail goto*//*Label 92*/ GIMT_Encode4(1168), // Rule ID 23380 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src, -1:{ *:[i8] })  =>  (DEC8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23380,
        GIR_EraseRootFromParent_Done,
      // Label 92: @1168
      GIM_Try, /*On fail goto*//*Label 93*/ GIMT_Encode4(1201), // Rule ID 23224 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23224,
        GIR_EraseRootFromParent_Done,
      // Label 93: @1201
      GIM_Try, /*On fail goto*//*Label 94*/ GIMT_Encode4(1234), // Rule ID 23314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (ADD8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23314,
        GIR_EraseRootFromParent_Done,
      // Label 94: @1234
      GIM_Try, /*On fail goto*//*Label 95*/ GIMT_Encode4(1259), // Rule ID 23216 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23216,
        GIR_Done,
      // Label 95: @1259
      GIM_Try, /*On fail goto*//*Label 96*/ GIMT_Encode4(1284), // Rule ID 23306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (add:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (ADD8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23306,
        GIR_Done,
      // Label 96: @1284
      GIM_Reject,
    // Label 88: @1285
    GIM_Reject,
    // Label 72: @1286
    GIM_Try, /*On fail goto*//*Label 97*/ GIMT_Encode4(1586),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 98*/ GIMT_Encode4(1339), // Rule ID 23026 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23026,
        GIR_EraseRootFromParent_Done,
      // Label 98: @1339
      GIM_Try, /*On fail goto*//*Label 99*/ GIMT_Encode4(1373), // Rule ID 23032 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, 128:{ *:[i16] })  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -128:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23032,
        GIR_EraseRootFromParent_Done,
      // Label 99: @1373
      GIM_Try, /*On fail goto*//*Label 100*/ GIMT_Encode4(1397), // Rule ID 23287 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23287,
        GIR_EraseRootFromParent_Done,
      // Label 100: @1397
      GIM_Try, /*On fail goto*//*Label 101*/ GIMT_Encode4(1421), // Rule ID 23291 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23291,
        GIR_EraseRootFromParent_Done,
      // Label 101: @1421
      GIM_Try, /*On fail goto*//*Label 102*/ GIMT_Encode4(1445), // Rule ID 23377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, 1:{ *:[i16] })  =>  (INC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23377,
        GIR_EraseRootFromParent_Done,
      // Label 102: @1445
      GIM_Try, /*On fail goto*//*Label 103*/ GIMT_Encode4(1469), // Rule ID 23381 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src, -1:{ *:[i16] })  =>  (DEC16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23381,
        GIR_EraseRootFromParent_Done,
      // Label 103: @1469
      GIM_Try, /*On fail goto*//*Label 104*/ GIMT_Encode4(1502), // Rule ID 23225 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23225,
        GIR_EraseRootFromParent_Done,
      // Label 104: @1502
      GIM_Try, /*On fail goto*//*Label 105*/ GIMT_Encode4(1535), // Rule ID 23315 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (ADD16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23315,
        GIR_EraseRootFromParent_Done,
      // Label 105: @1535
      GIM_Try, /*On fail goto*//*Label 106*/ GIMT_Encode4(1560), // Rule ID 23217 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23217,
        GIR_Done,
      // Label 106: @1560
      GIM_Try, /*On fail goto*//*Label 107*/ GIMT_Encode4(1585), // Rule ID 23307 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (add:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (ADD16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23307,
        GIR_Done,
      // Label 107: @1585
      GIM_Reject,
    // Label 97: @1586
    GIM_Reject,
    // Label 73: @1587
    GIM_Try, /*On fail goto*//*Label 108*/ GIMT_Encode4(1887),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 109*/ GIMT_Encode4(1640), // Rule ID 23027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23027,
        GIR_EraseRootFromParent_Done,
      // Label 109: @1640
      GIM_Try, /*On fail goto*//*Label 110*/ GIMT_Encode4(1674), // Rule ID 23033 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, 128:{ *:[i32] })  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -128:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23033,
        GIR_EraseRootFromParent_Done,
      // Label 110: @1674
      GIM_Try, /*On fail goto*//*Label 111*/ GIMT_Encode4(1698), // Rule ID 23288 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23288,
        GIR_EraseRootFromParent_Done,
      // Label 111: @1698
      GIM_Try, /*On fail goto*//*Label 112*/ GIMT_Encode4(1722), // Rule ID 23292 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23292,
        GIR_EraseRootFromParent_Done,
      // Label 112: @1722
      GIM_Try, /*On fail goto*//*Label 113*/ GIMT_Encode4(1746), // Rule ID 23378 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] })  =>  (INC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23378,
        GIR_EraseRootFromParent_Done,
      // Label 113: @1746
      GIM_Try, /*On fail goto*//*Label 114*/ GIMT_Encode4(1770), // Rule ID 23382 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] })  =>  (DEC32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23382,
        GIR_EraseRootFromParent_Done,
      // Label 114: @1770
      GIM_Try, /*On fail goto*//*Label 115*/ GIMT_Encode4(1803), // Rule ID 23226 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23226,
        GIR_EraseRootFromParent_Done,
      // Label 115: @1803
      GIM_Try, /*On fail goto*//*Label 116*/ GIMT_Encode4(1836), // Rule ID 23316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (ADD32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23316,
        GIR_EraseRootFromParent_Done,
      // Label 116: @1836
      GIM_Try, /*On fail goto*//*Label 117*/ GIMT_Encode4(1861), // Rule ID 23218 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23218,
        GIR_Done,
      // Label 117: @1861
      GIM_Try, /*On fail goto*//*Label 118*/ GIMT_Encode4(1886), // Rule ID 23308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (add:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (ADD32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23308,
        GIR_Done,
      // Label 118: @1886
      GIM_Reject,
    // Label 108: @1887
    GIM_Reject,
    // Label 74: @1888
    GIM_Try, /*On fail goto*//*Label 119*/ GIMT_Encode4(2278),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 120*/ GIMT_Encode4(1941), // Rule ID 23028 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23028,
        GIR_EraseRootFromParent_Done,
      // Label 120: @1941
      GIM_Try, /*On fail goto*//*Label 121*/ GIMT_Encode4(1975), // Rule ID 23034 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(128),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 128:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -128:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23034,
        GIR_EraseRootFromParent_Done,
      // Label 121: @1975
      GIM_Try, /*On fail goto*//*Label 122*/ GIMT_Encode4(2016), // Rule ID 23044 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23044,
        GIR_EraseRootFromParent_Done,
      // Label 122: @2016
      GIM_Try, /*On fail goto*//*Label 123*/ GIMT_Encode4(2057), // Rule ID 23046 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(2147483648),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, 2147483648:{ *:[i64] })  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, -2147483648:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23046,
        GIR_EraseRootFromParent_Done,
      // Label 123: @2057
      GIM_Try, /*On fail goto*//*Label 124*/ GIMT_Encode4(2081), // Rule ID 23289 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23289,
        GIR_EraseRootFromParent_Done,
      // Label 124: @2081
      GIM_Try, /*On fail goto*//*Label 125*/ GIMT_Encode4(2105), // Rule ID 23293 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23293,
        GIR_EraseRootFromParent_Done,
      // Label 125: @2105
      GIM_Try, /*On fail goto*//*Label 126*/ GIMT_Encode4(2129), // Rule ID 23379 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, 1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] })  =>  (INC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INC64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23379,
        GIR_EraseRootFromParent_Done,
      // Label 126: @2129
      GIM_Try, /*On fail goto*//*Label 127*/ GIMT_Encode4(2153), // Rule ID 23383 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_UseIncDec),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] })  =>  (DEC64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DEC64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23383,
        GIR_EraseRootFromParent_Done,
      // Label 127: @2153
      GIM_Try, /*On fail goto*//*Label 128*/ GIMT_Encode4(2190), // Rule ID 23227 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23227,
        GIR_EraseRootFromParent_Done,
      // Label 128: @2190
      GIM_Try, /*On fail goto*//*Label 129*/ GIMT_Encode4(2227), // Rule ID 23317 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (ADD64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23317,
        GIR_EraseRootFromParent_Done,
      // Label 129: @2227
      GIM_Try, /*On fail goto*//*Label 130*/ GIMT_Encode4(2252), // Rule ID 23219 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23219,
        GIR_Done,
      // Label 130: @2252
      GIM_Try, /*On fail goto*//*Label 131*/ GIMT_Encode4(2277), // Rule ID 23309 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (add:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (ADD64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::ADD64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23309,
        GIR_Done,
      // Label 131: @2277
      GIM_Reject,
    // Label 119: @2278
    GIM_Reject,
    // Label 75: @2279
    GIM_Try, /*On fail goto*//*Label 132*/ GIMT_Encode4(2372),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 133*/ GIMT_Encode4(2317), // Rule ID 2537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2537,
        GIR_Done,
      // Label 133: @2317
      GIM_Try, /*On fail goto*//*Label 134*/ GIMT_Encode4(2344), // Rule ID 2539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PADDQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2539,
        GIR_Done,
      // Label 134: @2344
      GIM_Try, /*On fail goto*//*Label 135*/ GIMT_Encode4(2371), // Rule ID 4648 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPADDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4648,
        GIR_Done,
      // Label 135: @2371
      GIM_Reject,
    // Label 132: @2372
    GIM_Reject,
    // Label 76: @2373
    GIM_Try, /*On fail goto*//*Label 136*/ GIMT_Encode4(2588),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 137*/ GIMT_Encode4(2445), // Rule ID 18314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2), VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/2, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18314,
        GIR_EraseRootFromParent_Done,
      // Label 137: @2445
      GIM_Try, /*On fail goto*//*Label 138*/ GIMT_Encode4(2506), // Rule ID 25614 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src3, (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2))  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25614,
        GIR_EraseRootFromParent_Done,
      // Label 138: @2506
      GIM_Try, /*On fail goto*//*Label 139*/ GIMT_Encode4(2533), // Rule ID 2531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2531,
        GIR_Done,
      // Label 139: @2533
      GIM_Try, /*On fail goto*//*Label 140*/ GIMT_Encode4(2560), // Rule ID 2533 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PADDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2533,
        GIR_Done,
      // Label 140: @2560
      GIM_Try, /*On fail goto*//*Label 141*/ GIMT_Encode4(2587), // Rule ID 4675 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPADDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4675,
        GIR_Done,
      // Label 141: @2587
      GIM_Reject,
    // Label 136: @2588
    GIM_Reject,
    // Label 77: @2589
    GIM_Try, /*On fail goto*//*Label 142*/ GIMT_Encode4(2655),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 143*/ GIMT_Encode4(2627), // Rule ID 2541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPADDQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2541,
        GIR_Done,
      // Label 143: @2627
      GIM_Try, /*On fail goto*//*Label 144*/ GIMT_Encode4(2654), // Rule ID 4639 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPADDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4639,
        GIR_Done,
      // Label 144: @2654
      GIM_Reject,
    // Label 142: @2655
    GIM_Reject,
    // Label 78: @2656
    GIM_Try, /*On fail goto*//*Label 145*/ GIMT_Encode4(2871),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 146*/ GIMT_Encode4(2728), // Rule ID 18313 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2), VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/2, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18313,
        GIR_EraseRootFromParent_Done,
      // Label 146: @2728
      GIM_Try, /*On fail goto*//*Label 147*/ GIMT_Encode4(2789), // Rule ID 25613 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src3, (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2))  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25613,
        GIR_EraseRootFromParent_Done,
      // Label 147: @2789
      GIM_Try, /*On fail goto*//*Label 148*/ GIMT_Encode4(2816), // Rule ID 2525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2525,
        GIR_Done,
      // Label 148: @2816
      GIM_Try, /*On fail goto*//*Label 149*/ GIMT_Encode4(2843), // Rule ID 2527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PADDWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2527,
        GIR_Done,
      // Label 149: @2843
      GIM_Try, /*On fail goto*//*Label 150*/ GIMT_Encode4(2870), // Rule ID 4696 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPADDWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4696,
        GIR_Done,
      // Label 150: @2870
      GIM_Reject,
    // Label 145: @2871
    GIM_Reject,
    // Label 79: @2872
    GIM_Try, /*On fail goto*//*Label 151*/ GIMT_Encode4(2938),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 152*/ GIMT_Encode4(2910), // Rule ID 2535 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPADDDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2535,
        GIR_Done,
      // Label 152: @2910
      GIM_Try, /*On fail goto*//*Label 153*/ GIMT_Encode4(2937), // Rule ID 4666 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPADDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4666,
        GIR_Done,
      // Label 153: @2937
      GIM_Reject,
    // Label 151: @2938
    GIM_Reject,
    // Label 80: @2939
    GIM_Try, /*On fail goto*//*Label 154*/ GIMT_Encode4(2972), // Rule ID 4630 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPADDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4630,
      GIR_Done,
    // Label 154: @2972
    GIM_Reject,
    // Label 81: @2973
    GIM_Try, /*On fail goto*//*Label 155*/ GIMT_Encode4(3066),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 156*/ GIMT_Encode4(3011), // Rule ID 2519 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2519,
        GIR_Done,
      // Label 156: @3011
      GIM_Try, /*On fail goto*//*Label 157*/ GIMT_Encode4(3038), // Rule ID 2521 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (add:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PADDBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PADDBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2521,
        GIR_Done,
      // Label 157: @3038
      GIM_Try, /*On fail goto*//*Label 158*/ GIMT_Encode4(3065), // Rule ID 4714 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (add:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPADDBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4714,
        GIR_Done,
      // Label 158: @3065
      GIM_Reject,
    // Label 155: @3066
    GIM_Reject,
    // Label 82: @3067
    GIM_Try, /*On fail goto*//*Label 159*/ GIMT_Encode4(3133),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 160*/ GIMT_Encode4(3105), // Rule ID 2529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPADDWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2529,
        GIR_Done,
      // Label 160: @3105
      GIM_Try, /*On fail goto*//*Label 161*/ GIMT_Encode4(3132), // Rule ID 4690 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPADDWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4690,
        GIR_Done,
      // Label 161: @3132
      GIM_Reject,
    // Label 159: @3133
    GIM_Reject,
    // Label 83: @3134
    GIM_Try, /*On fail goto*//*Label 162*/ GIMT_Encode4(3167), // Rule ID 4657 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPADDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4657,
      GIR_Done,
    // Label 162: @3167
    GIM_Reject,
    // Label 84: @3168
    GIM_Try, /*On fail goto*//*Label 163*/ GIMT_Encode4(3234),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 164*/ GIMT_Encode4(3206), // Rule ID 2523 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (add:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPADDBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2523,
        GIR_Done,
      // Label 164: @3206
      GIM_Try, /*On fail goto*//*Label 165*/ GIMT_Encode4(3233), // Rule ID 4708 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (add:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPADDBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4708,
        GIR_Done,
      // Label 165: @3233
      GIM_Reject,
    // Label 163: @3234
    GIM_Reject,
    // Label 85: @3235
    GIM_Try, /*On fail goto*//*Label 166*/ GIMT_Encode4(3268), // Rule ID 4684 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPADDWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4684,
      GIR_Done,
    // Label 166: @3268
    GIM_Reject,
    // Label 86: @3269
    GIM_Try, /*On fail goto*//*Label 167*/ GIMT_Encode4(3302), // Rule ID 4702 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (add:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPADDBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPADDBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4702,
      GIR_Done,
    // Label 167: @3302
    GIM_Reject,
    // Label 87: @3303
    GIM_Reject,
    // Label 1: @3304
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(25), /*)*//*default:*//*Label 184*/ GIMT_Encode4(5119),
    /*GILLT_s8*//*Label 168*/ GIMT_Encode4(3411),
    /*GILLT_s16*//*Label 169*/ GIMT_Encode4(3641),
    /*GILLT_s32*//*Label 170*/ GIMT_Encode4(3871),
    /*GILLT_s64*//*Label 171*/ GIMT_Encode4(4101), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 172*/ GIMT_Encode4(4339), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 173*/ GIMT_Encode4(4433),
    /*GILLT_v4s64*//*Label 174*/ GIMT_Encode4(4527), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 175*/ GIMT_Encode4(4594),
    /*GILLT_v8s32*//*Label 176*/ GIMT_Encode4(4688),
    /*GILLT_v8s64*//*Label 177*/ GIMT_Encode4(4755), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 178*/ GIMT_Encode4(4789),
    /*GILLT_v16s16*//*Label 179*/ GIMT_Encode4(4883),
    /*GILLT_v16s32*//*Label 180*/ GIMT_Encode4(4950), GIMT_Encode4(0),
    /*GILLT_v32s8*//*Label 181*/ GIMT_Encode4(4984),
    /*GILLT_v32s16*//*Label 182*/ GIMT_Encode4(5051), GIMT_Encode4(0),
    /*GILLT_v64s8*//*Label 183*/ GIMT_Encode4(5085),
    // Label 168: @3411
    GIM_Try, /*On fail goto*//*Label 185*/ GIMT_Encode4(3640),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 186*/ GIMT_Encode4(3454), // Rule ID 239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 239,
        GIR_EraseRootFromParent_Done,
      // Label 186: @3454
      GIM_Try, /*On fail goto*//*Label 187*/ GIMT_Encode4(3482), // Rule ID 247 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 247,
        GIR_EraseRootFromParent_Done,
      // Label 187: @3482
      GIM_Try, /*On fail goto*//*Label 188*/ GIMT_Encode4(3507), // Rule ID 255 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } 0:{ *:[i8] }, GR8:{ *:[i8] }:$src1)  =>  (NEG8r_NF_ND:{ *:[i8] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG8r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 255,
        GIR_EraseRootFromParent_Done,
      // Label 188: @3507
      GIM_Try, /*On fail goto*//*Label 189*/ GIMT_Encode4(3544), // Rule ID 23236 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23236,
        GIR_EraseRootFromParent_Done,
      // Label 189: @3544
      GIM_Try, /*On fail goto*//*Label 190*/ GIMT_Encode4(3581), // Rule ID 23326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (SUB8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23326,
        GIR_EraseRootFromParent_Done,
      // Label 190: @3581
      GIM_Try, /*On fail goto*//*Label 191*/ GIMT_Encode4(3610), // Rule ID 23228 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23228,
        GIR_Done,
      // Label 191: @3610
      GIM_Try, /*On fail goto*//*Label 192*/ GIMT_Encode4(3639), // Rule ID 23318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (sub:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (SUB8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23318,
        GIR_Done,
      // Label 192: @3639
      GIM_Reject,
    // Label 185: @3640
    GIM_Reject,
    // Label 169: @3641
    GIM_Try, /*On fail goto*//*Label 193*/ GIMT_Encode4(3870),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 194*/ GIMT_Encode4(3684), // Rule ID 240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 240,
        GIR_EraseRootFromParent_Done,
      // Label 194: @3684
      GIM_Try, /*On fail goto*//*Label 195*/ GIMT_Encode4(3712), // Rule ID 248 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 248,
        GIR_EraseRootFromParent_Done,
      // Label 195: @3712
      GIM_Try, /*On fail goto*//*Label 196*/ GIMT_Encode4(3737), // Rule ID 256 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } 0:{ *:[i16] }, GR16:{ *:[i16] }:$src1)  =>  (NEG16r_NF_ND:{ *:[i16] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG16r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 256,
        GIR_EraseRootFromParent_Done,
      // Label 196: @3737
      GIM_Try, /*On fail goto*//*Label 197*/ GIMT_Encode4(3774), // Rule ID 23237 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23237,
        GIR_EraseRootFromParent_Done,
      // Label 197: @3774
      GIM_Try, /*On fail goto*//*Label 198*/ GIMT_Encode4(3811), // Rule ID 23327 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (SUB16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23327,
        GIR_EraseRootFromParent_Done,
      // Label 198: @3811
      GIM_Try, /*On fail goto*//*Label 199*/ GIMT_Encode4(3840), // Rule ID 23229 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23229,
        GIR_Done,
      // Label 199: @3840
      GIM_Try, /*On fail goto*//*Label 200*/ GIMT_Encode4(3869), // Rule ID 23319 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (sub:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (SUB16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23319,
        GIR_Done,
      // Label 200: @3869
      GIM_Reject,
    // Label 193: @3870
    GIM_Reject,
    // Label 170: @3871
    GIM_Try, /*On fail goto*//*Label 201*/ GIMT_Encode4(4100),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 202*/ GIMT_Encode4(3914), // Rule ID 241 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 241,
        GIR_EraseRootFromParent_Done,
      // Label 202: @3914
      GIM_Try, /*On fail goto*//*Label 203*/ GIMT_Encode4(3942), // Rule ID 249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 249,
        GIR_EraseRootFromParent_Done,
      // Label 203: @3942
      GIM_Try, /*On fail goto*//*Label 204*/ GIMT_Encode4(3967), // Rule ID 257 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } 0:{ *:[i32] }, GR32:{ *:[i32] }:$src1)  =>  (NEG32r_NF_ND:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG32r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 257,
        GIR_EraseRootFromParent_Done,
      // Label 204: @3967
      GIM_Try, /*On fail goto*//*Label 205*/ GIMT_Encode4(4004), // Rule ID 23238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23238,
        GIR_EraseRootFromParent_Done,
      // Label 205: @4004
      GIM_Try, /*On fail goto*//*Label 206*/ GIMT_Encode4(4041), // Rule ID 23328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (SUB32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23328,
        GIR_EraseRootFromParent_Done,
      // Label 206: @4041
      GIM_Try, /*On fail goto*//*Label 207*/ GIMT_Encode4(4070), // Rule ID 23230 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23230,
        GIR_Done,
      // Label 207: @4070
      GIM_Try, /*On fail goto*//*Label 208*/ GIMT_Encode4(4099), // Rule ID 23320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (sub:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (SUB32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23320,
        GIR_Done,
      // Label 208: @4099
      GIM_Reject,
    // Label 201: @4100
    GIM_Reject,
    // Label 171: @4101
    GIM_Try, /*On fail goto*//*Label 209*/ GIMT_Encode4(4338),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 210*/ GIMT_Encode4(4144), // Rule ID 242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 242,
        GIR_EraseRootFromParent_Done,
      // Label 210: @4144
      GIM_Try, /*On fail goto*//*Label 211*/ GIMT_Encode4(4172), // Rule ID 250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 250,
        GIR_EraseRootFromParent_Done,
      // Label 211: @4172
      GIM_Try, /*On fail goto*//*Label 212*/ GIMT_Encode4(4197), // Rule ID 258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/1, 0,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } 0:{ *:[i64] }, GR64:{ *:[i64] }:$src1)  =>  (NEG64r_NF_ND:{ *:[i64] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NEG64r_NF_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 258,
        GIR_EraseRootFromParent_Done,
      // Label 212: @4197
      GIM_Try, /*On fail goto*//*Label 213*/ GIMT_Encode4(4238), // Rule ID 23239 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23239,
        GIR_EraseRootFromParent_Done,
      // Label 213: @4238
      GIM_Try, /*On fail goto*//*Label 214*/ GIMT_Encode4(4279), // Rule ID 23329 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (SUB64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SUB64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23329,
        GIR_EraseRootFromParent_Done,
      // Label 214: @4279
      GIM_Try, /*On fail goto*//*Label 215*/ GIMT_Encode4(4308), // Rule ID 23231 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23231,
        GIR_Done,
      // Label 215: @4308
      GIM_Try, /*On fail goto*//*Label 216*/ GIMT_Encode4(4337), // Rule ID 23321 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (sub:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (SUB64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::SUB64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23321,
        GIR_Done,
      // Label 216: @4337
      GIM_Reject,
    // Label 209: @4338
    GIM_Reject,
    // Label 172: @4339
    GIM_Try, /*On fail goto*//*Label 217*/ GIMT_Encode4(4432),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 218*/ GIMT_Encode4(4377), // Rule ID 2603 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2603,
        GIR_Done,
      // Label 218: @4377
      GIM_Try, /*On fail goto*//*Label 219*/ GIMT_Encode4(4404), // Rule ID 2605 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PSUBQrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBQrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2605,
        GIR_Done,
      // Label 219: @4404
      GIM_Try, /*On fail goto*//*Label 220*/ GIMT_Encode4(4431), // Rule ID 4738 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPSUBQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4738,
        GIR_Done,
      // Label 220: @4431
      GIM_Reject,
    // Label 217: @4432
    GIM_Reject,
    // Label 173: @4433
    GIM_Try, /*On fail goto*//*Label 221*/ GIMT_Encode4(4526),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 222*/ GIMT_Encode4(4471), // Rule ID 2597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2597,
        GIR_Done,
      // Label 222: @4471
      GIM_Try, /*On fail goto*//*Label 223*/ GIMT_Encode4(4498), // Rule ID 2599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PSUBDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2599,
        GIR_Done,
      // Label 223: @4498
      GIM_Try, /*On fail goto*//*Label 224*/ GIMT_Encode4(4525), // Rule ID 4765 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPSUBDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4765,
        GIR_Done,
      // Label 224: @4525
      GIM_Reject,
    // Label 221: @4526
    GIM_Reject,
    // Label 174: @4527
    GIM_Try, /*On fail goto*//*Label 225*/ GIMT_Encode4(4593),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 226*/ GIMT_Encode4(4565), // Rule ID 2607 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPSUBQYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2607,
        GIR_Done,
      // Label 226: @4565
      GIM_Try, /*On fail goto*//*Label 227*/ GIMT_Encode4(4592), // Rule ID 4729 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPSUBQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4729,
        GIR_Done,
      // Label 227: @4592
      GIM_Reject,
    // Label 225: @4593
    GIM_Reject,
    // Label 175: @4594
    GIM_Try, /*On fail goto*//*Label 228*/ GIMT_Encode4(4687),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 229*/ GIMT_Encode4(4632), // Rule ID 2591 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2591,
        GIR_Done,
      // Label 229: @4632
      GIM_Try, /*On fail goto*//*Label 230*/ GIMT_Encode4(4659), // Rule ID 2593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PSUBWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2593,
        GIR_Done,
      // Label 230: @4659
      GIM_Try, /*On fail goto*//*Label 231*/ GIMT_Encode4(4686), // Rule ID 4786 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPSUBWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4786,
        GIR_Done,
      // Label 231: @4686
      GIM_Reject,
    // Label 228: @4687
    GIM_Reject,
    // Label 176: @4688
    GIM_Try, /*On fail goto*//*Label 232*/ GIMT_Encode4(4754),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 233*/ GIMT_Encode4(4726), // Rule ID 2601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPSUBDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2601,
        GIR_Done,
      // Label 233: @4726
      GIM_Try, /*On fail goto*//*Label 234*/ GIMT_Encode4(4753), // Rule ID 4756 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPSUBDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4756,
        GIR_Done,
      // Label 234: @4753
      GIM_Reject,
    // Label 232: @4754
    GIM_Reject,
    // Label 177: @4755
    GIM_Try, /*On fail goto*//*Label 235*/ GIMT_Encode4(4788), // Rule ID 4720 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPSUBQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4720,
      GIR_Done,
    // Label 235: @4788
    GIM_Reject,
    // Label 178: @4789
    GIM_Try, /*On fail goto*//*Label 236*/ GIMT_Encode4(4882),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 237*/ GIMT_Encode4(4827), // Rule ID 2585 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2585,
        GIR_Done,
      // Label 237: @4827
      GIM_Try, /*On fail goto*//*Label 238*/ GIMT_Encode4(4854), // Rule ID 2587 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (sub:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PSUBBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PSUBBrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2587,
        GIR_Done,
      // Label 238: @4854
      GIM_Try, /*On fail goto*//*Label 239*/ GIMT_Encode4(4881), // Rule ID 4804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (sub:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPSUBBZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4804,
        GIR_Done,
      // Label 239: @4881
      GIM_Reject,
    // Label 236: @4882
    GIM_Reject,
    // Label 179: @4883
    GIM_Try, /*On fail goto*//*Label 240*/ GIMT_Encode4(4949),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 241*/ GIMT_Encode4(4921), // Rule ID 2595 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPSUBWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2595,
        GIR_Done,
      // Label 241: @4921
      GIM_Try, /*On fail goto*//*Label 242*/ GIMT_Encode4(4948), // Rule ID 4780 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPSUBWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4780,
        GIR_Done,
      // Label 242: @4948
      GIM_Reject,
    // Label 240: @4949
    GIM_Reject,
    // Label 180: @4950
    GIM_Try, /*On fail goto*//*Label 243*/ GIMT_Encode4(4983), // Rule ID 4747 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPSUBDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4747,
      GIR_Done,
    // Label 243: @4983
    GIM_Reject,
    // Label 181: @4984
    GIM_Try, /*On fail goto*//*Label 244*/ GIMT_Encode4(5050),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 245*/ GIMT_Encode4(5022), // Rule ID 2589 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (sub:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPSUBBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2589,
        GIR_Done,
      // Label 245: @5022
      GIM_Try, /*On fail goto*//*Label 246*/ GIMT_Encode4(5049), // Rule ID 4798 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (sub:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPSUBBZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4798,
        GIR_Done,
      // Label 246: @5049
      GIM_Reject,
    // Label 244: @5050
    GIM_Reject,
    // Label 182: @5051
    GIM_Try, /*On fail goto*//*Label 247*/ GIMT_Encode4(5084), // Rule ID 4774 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPSUBWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4774,
      GIR_Done,
    // Label 247: @5084
    GIM_Reject,
    // Label 183: @5085
    GIM_Try, /*On fail goto*//*Label 248*/ GIMT_Encode4(5118), // Rule ID 4792 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (sub:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPSUBBZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPSUBBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4792,
      GIR_Done,
    // Label 248: @5118
    GIM_Reject,
    // Label 184: @5119
    GIM_Reject,
    // Label 2: @5120
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(23), /*)*//*default:*//*Label 261*/ GIMT_Encode4(6344),
    /*GILLT_s16*//*Label 249*/ GIMT_Encode4(5215),
    /*GILLT_s32*//*Label 250*/ GIMT_Encode4(5316),
    /*GILLT_s64*//*Label 251*/ GIMT_Encode4(5417), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 252*/ GIMT_Encode4(5522), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 253*/ GIMT_Encode4(5727),
    /*GILLT_v4s64*//*Label 254*/ GIMT_Encode4(5821), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 255*/ GIMT_Encode4(6014),
    /*GILLT_v8s32*//*Label 256*/ GIMT_Encode4(6108),
    /*GILLT_v8s64*//*Label 257*/ GIMT_Encode4(6175), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s16*//*Label 258*/ GIMT_Encode4(6209),
    /*GILLT_v16s32*//*Label 259*/ GIMT_Encode4(6276), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v32s16*//*Label 260*/ GIMT_Encode4(6310),
    // Label 249: @5215
    GIM_Try, /*On fail goto*//*Label 262*/ GIMT_Encode4(5315),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 263*/ GIMT_Encode4(5264), // Rule ID 23400 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (IMUL16rri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL16rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23400,
        GIR_EraseRootFromParent_Done,
      // Label 263: @5264
      GIM_Try, /*On fail goto*//*Label 264*/ GIMT_Encode4(5289), // Rule ID 23244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23244,
        GIR_Done,
      // Label 264: @5289
      GIM_Try, /*On fail goto*//*Label 265*/ GIMT_Encode4(5314), // Rule ID 23334 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (mul:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (IMUL16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23334,
        GIR_Done,
      // Label 265: @5314
      GIM_Reject,
    // Label 262: @5315
    GIM_Reject,
    // Label 250: @5316
    GIM_Try, /*On fail goto*//*Label 266*/ GIMT_Encode4(5416),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_Try, /*On fail goto*//*Label 267*/ GIMT_Encode4(5365), // Rule ID 23401 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (IMUL32rri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL32rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23401,
        GIR_EraseRootFromParent_Done,
      // Label 267: @5365
      GIM_Try, /*On fail goto*//*Label 268*/ GIMT_Encode4(5390), // Rule ID 23245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23245,
        GIR_Done,
      // Label 268: @5390
      GIM_Try, /*On fail goto*//*Label 269*/ GIMT_Encode4(5415), // Rule ID 23335 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (mul:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (IMUL32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23335,
        GIR_Done,
      // Label 269: @5415
      GIM_Reject,
    // Label 266: @5416
    GIM_Reject,
    // Label 251: @5417
    GIM_Try, /*On fail goto*//*Label 270*/ GIMT_Encode4(5521),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_Try, /*On fail goto*//*Label 271*/ GIMT_Encode4(5470), // Rule ID 23402 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (IMUL64rri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::IMUL64rri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23402,
        GIR_EraseRootFromParent_Done,
      // Label 271: @5470
      GIM_Try, /*On fail goto*//*Label 272*/ GIMT_Encode4(5495), // Rule ID 23246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23246,
        GIR_Done,
      // Label 272: @5495
      GIM_Try, /*On fail goto*//*Label 273*/ GIMT_Encode4(5520), // Rule ID 23336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (mul:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (IMUL64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::IMUL64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23336,
        GIR_Done,
      // Label 273: @5520
      GIM_Reject,
    // Label 270: @5521
    GIM_Reject,
    // Label 252: @5522
    GIM_Try, /*On fail goto*//*Label 274*/ GIMT_Encode4(5726),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 275*/ GIMT_Encode4(5560), // Rule ID 5017 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPMULLQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5017,
        GIR_Done,
      // Label 275: @5560
      GIM_Try, /*On fail goto*//*Label 276*/ GIMT_Encode4(5725), // Rule ID 20445 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v2i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src1, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src2, sub_xmm:{ *:[i32] })), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/4, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/2, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20445,
        GIR_EraseRootFromParent_Done,
      // Label 276: @5725
      GIM_Reject,
    // Label 274: @5726
    GIM_Reject,
    // Label 253: @5727
    GIM_Try, /*On fail goto*//*Label 277*/ GIMT_Encode4(5820),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 278*/ GIMT_Encode4(5765), // Rule ID 3236 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3236,
        GIR_Done,
      // Label 278: @5765
      GIM_Try, /*On fail goto*//*Label 279*/ GIMT_Encode4(5792), // Rule ID 3244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PMULLDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3244,
        GIR_Done,
      // Label 279: @5792
      GIM_Try, /*On fail goto*//*Label 280*/ GIMT_Encode4(5819), // Rule ID 4972 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPMULLDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4972,
        GIR_Done,
      // Label 280: @5819
      GIM_Reject,
    // Label 277: @5820
    GIM_Reject,
    // Label 254: @5821
    GIM_Try, /*On fail goto*//*Label 281*/ GIMT_Encode4(6013),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_Try, /*On fail goto*//*Label 282*/ GIMT_Encode4(5859), // Rule ID 5008 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
        // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPMULLQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5008,
        GIR_Done,
      // Label 282: @5859
      GIM_Try, /*On fail goto*//*Label 283*/ GIMT_Encode4(6012), // Rule ID 20443 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasEVEX512_NoVLX),
        // (mul:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (EXTRACT_SUBREG:{ *:[v4i64] } (VPMULLQZrr:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src1, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src2, sub_ymm:{ *:[i32] })), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/4, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 20443,
        GIR_EraseRootFromParent_Done,
      // Label 283: @6012
      GIM_Reject,
    // Label 281: @6013
    GIM_Reject,
    // Label 255: @6014
    GIM_Try, /*On fail goto*//*Label 284*/ GIMT_Encode4(6107),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 285*/ GIMT_Encode4(6052), // Rule ID 2567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2567,
        GIR_Done,
      // Label 285: @6052
      GIM_Try, /*On fail goto*//*Label 286*/ GIMT_Encode4(6079), // Rule ID 2569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (mul:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PMULLWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PMULLWrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2569,
        GIR_Done,
      // Label 286: @6079
      GIM_Try, /*On fail goto*//*Label 287*/ GIMT_Encode4(6106), // Rule ID 4993 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (mul:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPMULLWZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4993,
        GIR_Done,
      // Label 287: @6106
      GIM_Reject,
    // Label 284: @6107
    GIM_Reject,
    // Label 256: @6108
    GIM_Try, /*On fail goto*//*Label 288*/ GIMT_Encode4(6174),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 289*/ GIMT_Encode4(6146), // Rule ID 3240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (mul:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPMULLDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3240,
        GIR_Done,
      // Label 289: @6146
      GIM_Try, /*On fail goto*//*Label 290*/ GIMT_Encode4(6173), // Rule ID 4963 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPMULLDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4963,
        GIR_Done,
      // Label 290: @6173
      GIM_Reject,
    // Label 288: @6174
    GIM_Reject,
    // Label 257: @6175
    GIM_Try, /*On fail goto*//*Label 291*/ GIMT_Encode4(6208), // Rule ID 4999 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (mul:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPMULLQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4999,
      GIR_Done,
    // Label 291: @6208
    GIM_Reject,
    // Label 258: @6209
    GIM_Try, /*On fail goto*//*Label 292*/ GIMT_Encode4(6275),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 293*/ GIMT_Encode4(6247), // Rule ID 2571 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX_Or_NoBWI),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (mul:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPMULLWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2571,
        GIR_Done,
      // Label 293: @6247
      GIM_Try, /*On fail goto*//*Label 294*/ GIMT_Encode4(6274), // Rule ID 4987 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (mul:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPMULLWZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4987,
        GIR_Done,
      // Label 294: @6274
      GIM_Reject,
    // Label 292: @6275
    GIM_Reject,
    // Label 259: @6276
    GIM_Try, /*On fail goto*//*Label 295*/ GIMT_Encode4(6309), // Rule ID 4954 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (mul:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPMULLDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4954,
      GIR_Done,
    // Label 295: @6309
    GIM_Reject,
    // Label 260: @6310
    GIM_Try, /*On fail goto*//*Label 296*/ GIMT_Encode4(6343), // Rule ID 4981 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (mul:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPMULLWZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMULLWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4981,
      GIR_Done,
    // Label 296: @6343
    GIM_Reject,
    // Label 261: @6344
    GIM_Reject,
    // Label 3: @6345
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 320*/ GIMT_Encode4(12188),
    /*GILLT_s1*//*Label 297*/ GIMT_Encode4(6456),
    /*GILLT_s8*//*Label 298*/ GIMT_Encode4(6802),
    /*GILLT_s16*//*Label 299*/ GIMT_Encode4(6939),
    /*GILLT_s32*//*Label 300*/ GIMT_Encode4(7380),
    /*GILLT_s64*//*Label 301*/ GIMT_Encode4(8566), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s1*//*Label 302*/ GIMT_Encode4(9630),
    /*GILLT_v2s64*//*Label 303*/ GIMT_Encode4(9976),
    /*GILLT_v4s1*//*Label 304*/ GIMT_Encode4(10070),
    /*GILLT_v4s32*//*Label 305*/ GIMT_Encode4(10416),
    /*GILLT_v4s64*//*Label 306*/ GIMT_Encode4(10510),
    /*GILLT_v8s1*//*Label 307*/ GIMT_Encode4(10604),
    /*GILLT_v8s16*//*Label 308*/ GIMT_Encode4(11102),
    /*GILLT_v8s32*//*Label 309*/ GIMT_Encode4(11196),
    /*GILLT_v8s64*//*Label 310*/ GIMT_Encode4(11290),
    /*GILLT_v16s1*//*Label 311*/ GIMT_Encode4(11324),
    /*GILLT_v16s8*//*Label 312*/ GIMT_Encode4(11484),
    /*GILLT_v16s16*//*Label 313*/ GIMT_Encode4(11578),
    /*GILLT_v16s32*//*Label 314*/ GIMT_Encode4(11672),
    /*GILLT_v32s1*//*Label 315*/ GIMT_Encode4(11706),
    /*GILLT_v32s8*//*Label 316*/ GIMT_Encode4(11866),
    /*GILLT_v32s16*//*Label 317*/ GIMT_Encode4(11960),
    /*GILLT_v64s1*//*Label 318*/ GIMT_Encode4(11994),
    /*GILLT_v64s8*//*Label 319*/ GIMT_Encode4(12154),
    // Label 297: @6456
    GIM_Try, /*On fail goto*//*Label 321*/ GIMT_Encode4(6801),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      GIM_Try, /*On fail goto*//*Label 322*/ GIMT_Encode4(6591), // Rule ID 19935 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }), VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 19935,
        GIR_EraseRootFromParent_Done,
      // Label 322: @6591
      GIM_Try, /*On fail goto*//*Label 323*/ GIMT_Encode4(6711), // Rule ID 25791 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src2, (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 25791,
        GIR_EraseRootFromParent_Done,
      // Label 323: @6711
      GIM_Try, /*On fail goto*//*Label 324*/ GIMT_Encode4(6800), // Rule ID 19931 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        // (and:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 19931,
        GIR_EraseRootFromParent_Done,
      // Label 324: @6800
      GIM_Reject,
    // Label 321: @6801
    GIM_Reject,
    // Label 298: @6802
    GIM_Try, /*On fail goto*//*Label 325*/ GIMT_Encode4(6938),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 326*/ GIMT_Encode4(6854), // Rule ID 23282 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23282,
        GIR_EraseRootFromParent_Done,
      // Label 326: @6854
      GIM_Try, /*On fail goto*//*Label 327*/ GIMT_Encode4(6887), // Rule ID 23372 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (AND8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23372,
        GIR_EraseRootFromParent_Done,
      // Label 327: @6887
      GIM_Try, /*On fail goto*//*Label 328*/ GIMT_Encode4(6912), // Rule ID 23274 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23274,
        GIR_Done,
      // Label 328: @6912
      GIM_Try, /*On fail goto*//*Label 329*/ GIMT_Encode4(6937), // Rule ID 23364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (and:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (AND8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23364,
        GIR_Done,
      // Label 329: @6937
      GIM_Reject,
    // Label 325: @6938
    GIM_Reject,
    // Label 299: @6939
    GIM_Try, /*On fail goto*//*Label 330*/ GIMT_Encode4(7379),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 331*/ GIMT_Encode4(7056), // Rule ID 26460 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26460,
        GIR_EraseRootFromParent_Done,
      // Label 331: @7056
      GIM_Try, /*On fail goto*//*Label 332*/ GIMT_Encode4(7158), // Rule ID 23198 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (rotl:{ *:[i16] } -2:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23198,
        GIR_EraseRootFromParent_Done,
      // Label 332: @7158
      GIM_Try, /*On fail goto*//*Label 333*/ GIMT_Encode4(7246), // Rule ID 23058 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, 255:{ *:[i16] })  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR16:{ *:[i16] }:$src1, sub_8bit:{ *:[i32] })), sub_16bit:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s8,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
        // GIR_Coverage, 23058,
        GIR_EraseRootFromParent_Done,
      // Label 333: @7246
      GIM_Try, /*On fail goto*//*Label 334*/ GIMT_Encode4(7283), // Rule ID 23283 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23283,
        GIR_EraseRootFromParent_Done,
      // Label 334: @7283
      GIM_Try, /*On fail goto*//*Label 335*/ GIMT_Encode4(7320), // Rule ID 23373 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (AND16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23373,
        GIR_EraseRootFromParent_Done,
      // Label 335: @7320
      GIM_Try, /*On fail goto*//*Label 336*/ GIMT_Encode4(7349), // Rule ID 23275 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23275,
        GIR_Done,
      // Label 336: @7349
      GIM_Try, /*On fail goto*//*Label 337*/ GIMT_Encode4(7378), // Rule ID 23365 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (and:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (AND16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23365,
        GIR_Done,
      // Label 337: @7378
      GIM_Reject,
    // Label 330: @7379
    GIM_Reject,
    // Label 300: @7380
    GIM_Try, /*On fail goto*//*Label 338*/ GIMT_Encode4(8565),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 339*/ GIMT_Encode4(7465), // Rule ID 25419 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25419,
        GIR_EraseRootFromParent_Done,
      // Label 339: @7465
      GIM_Try, /*On fail goto*//*Label 340*/ GIMT_Encode4(7542), // Rule ID 25431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25431,
        GIR_EraseRootFromParent_Done,
      // Label 340: @7542
      GIM_Try, /*On fail goto*//*Label 341*/ GIMT_Encode4(7619), // Rule ID 17803 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17803,
        GIR_EraseRootFromParent_Done,
      // Label 341: @7619
      GIM_Try, /*On fail goto*//*Label 342*/ GIMT_Encode4(7696), // Rule ID 17815 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (TZMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17815,
        GIR_EraseRootFromParent_Done,
      // Label 342: @7696
      GIM_Try, /*On fail goto*//*Label 343*/ GIMT_Encode4(7754), // Rule ID 25413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25413,
        GIR_EraseRootFromParent_Done,
      // Label 343: @7754
      GIM_Try, /*On fail goto*//*Label 344*/ GIMT_Encode4(7863), // Rule ID 26466 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26466,
        GIR_EraseRootFromParent_Done,
      // Label 344: @7863
      GIM_Try, /*On fail goto*//*Label 345*/ GIMT_Encode4(7917), // Rule ID 17797 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17797,
        GIR_EraseRootFromParent_Done,
      // Label 345: @7917
      GIM_Try, /*On fail goto*//*Label 346*/ GIMT_Encode4(8026), // Rule ID 23204 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (rotl:{ *:[i32] } -2:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23204,
        GIR_EraseRootFromParent_Done,
      // Label 346: @8026
      GIM_Try, /*On fail goto*//*Label 347*/ GIMT_Encode4(8091), // Rule ID 23056 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(65535),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 65535:{ *:[i32] })  =>  (MOVZX32rr16:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i16] } GR32:{ *:[i32] }:$src1, sub_16bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(4), // src1
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23056,
        GIR_EraseRootFromParent_Done,
      // Label 347: @8091
      GIM_Try, /*On fail goto*//*Label 348*/ GIMT_Encode4(8156), // Rule ID 23057 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(255),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, 255:{ *:[i32] })  =>  (MOVZX32rr8:{ *:[i32] } (EXTRACT_SUBREG:{ *:[i8] } GR32:{ *:[i32] }:$src1, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_CopySubReg, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src1
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23057,
        GIR_EraseRootFromParent_Done,
      // Label 348: @8156
      GIM_Try, /*On fail goto*//*Label 349*/ GIMT_Encode4(8200), // Rule ID 23284 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23284,
        GIR_EraseRootFromParent_Done,
      // Label 349: @8200
      GIM_Try, /*On fail goto*//*Label 350*/ GIMT_Encode4(8244), // Rule ID 23374 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (AND32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23374,
        GIR_EraseRootFromParent_Done,
      // Label 350: @8244
      GIM_Try, /*On fail goto*//*Label 351*/ GIMT_Encode4(8306), // Rule ID 17991 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17991,
        GIR_EraseRootFromParent_Done,
      // Label 351: @8306
      GIM_Try, /*On fail goto*//*Label 352*/ GIMT_Encode4(8368), // Rule ID 17995 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src2)  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17995,
        GIR_EraseRootFromParent_Done,
      // Label 352: @8368
      GIM_Try, /*On fail goto*//*Label 353*/ GIMT_Encode4(8430), // Rule ID 25525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25525,
        GIR_EraseRootFromParent_Done,
      // Label 353: @8430
      GIM_Try, /*On fail goto*//*Label 354*/ GIMT_Encode4(8492), // Rule ID 25529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src2, (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] }))  =>  (ANDN32rr_EVEX:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN32rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25529,
        GIR_EraseRootFromParent_Done,
      // Label 354: @8492
      GIM_Try, /*On fail goto*//*Label 355*/ GIMT_Encode4(8528), // Rule ID 23276 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23276,
        GIR_Done,
      // Label 355: @8528
      GIM_Try, /*On fail goto*//*Label 356*/ GIMT_Encode4(8564), // Rule ID 23366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (and:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (AND32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23366,
        GIR_Done,
      // Label 356: @8564
      GIM_Reject,
    // Label 338: @8565
    GIM_Reject,
    // Label 301: @8566
    GIM_Try, /*On fail goto*//*Label 357*/ GIMT_Encode4(9629),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 358*/ GIMT_Encode4(8651), // Rule ID 25420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25420,
        GIR_EraseRootFromParent_Done,
      // Label 358: @8651
      GIM_Try, /*On fail goto*//*Label 359*/ GIMT_Encode4(8728), // Rule ID 25432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25432,
        GIR_EraseRootFromParent_Done,
      // Label 359: @8728
      GIM_Try, /*On fail goto*//*Label 360*/ GIMT_Encode4(8805), // Rule ID 17804 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17804,
        GIR_EraseRootFromParent_Done,
      // Label 360: @8805
      GIM_Try, /*On fail goto*//*Label 361*/ GIMT_Encode4(8882), // Rule ID 17816 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (TZMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TZMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17816,
        GIR_EraseRootFromParent_Done,
      // Label 361: @8882
      GIM_Try, /*On fail goto*//*Label 362*/ GIMT_Encode4(8940), // Rule ID 25414 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25414,
        GIR_EraseRootFromParent_Done,
      // Label 362: @8940
      GIM_Try, /*On fail goto*//*Label 363*/ GIMT_Encode4(9049), // Rule ID 26472 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26472,
        GIR_EraseRootFromParent_Done,
      // Label 363: @9049
      GIM_Try, /*On fail goto*//*Label 364*/ GIMT_Encode4(9103), // Rule ID 17798 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17798,
        GIR_EraseRootFromParent_Done,
      // Label 364: @9103
      GIM_Try, /*On fail goto*//*Label 365*/ GIMT_Encode4(9212), // Rule ID 23210 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ROTL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (rotl:{ *:[i64] } -2:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTR64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23210,
        GIR_EraseRootFromParent_Done,
      // Label 365: @9212
      GIM_Try, /*On fail goto*//*Label 366*/ GIMT_Encode4(9260), // Rule ID 23285 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23285,
        GIR_EraseRootFromParent_Done,
      // Label 366: @9260
      GIM_Try, /*On fail goto*//*Label 367*/ GIMT_Encode4(9308), // Rule ID 23375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (AND64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AND64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23375,
        GIR_EraseRootFromParent_Done,
      // Label 367: @9308
      GIM_Try, /*On fail goto*//*Label 368*/ GIMT_Encode4(9370), // Rule ID 17992 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17992,
        GIR_EraseRootFromParent_Done,
      // Label 368: @9370
      GIM_Try, /*On fail goto*//*Label 369*/ GIMT_Encode4(9432), // Rule ID 17996 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src2)  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17996,
        GIR_EraseRootFromParent_Done,
      // Label 369: @9432
      GIM_Try, /*On fail goto*//*Label 370*/ GIMT_Encode4(9494), // Rule ID 25526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_NoEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25526,
        GIR_EraseRootFromParent_Done,
      // Label 370: @9494
      GIM_Try, /*On fail goto*//*Label 371*/ GIMT_Encode4(9556), // Rule ID 25530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBMI_HasEGPR),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src2, (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] }))  =>  (ANDN64rr_EVEX:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ANDN64rr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25530,
        GIR_EraseRootFromParent_Done,
      // Label 371: @9556
      GIM_Try, /*On fail goto*//*Label 372*/ GIMT_Encode4(9592), // Rule ID 23277 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23277,
        GIR_Done,
      // Label 372: @9592
      GIM_Try, /*On fail goto*//*Label 373*/ GIMT_Encode4(9628), // Rule ID 23367 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (and:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (AND64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::AND64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23367,
        GIR_Done,
      // Label 373: @9628
      GIM_Reject,
    // Label 357: @9629
    GIM_Reject,
    // Label 302: @9630
    GIM_Try, /*On fail goto*//*Label 374*/ GIMT_Encode4(9975),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_Try, /*On fail goto*//*Label 375*/ GIMT_Encode4(9765), // Rule ID 19936 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }), VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 19936,
        GIR_EraseRootFromParent_Done,
      // Label 375: @9765
      GIM_Try, /*On fail goto*//*Label 376*/ GIMT_Encode4(9885), // Rule ID 25792 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src2, (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 25792,
        GIR_EraseRootFromParent_Done,
      // Label 376: @9885
      GIM_Try, /*On fail goto*//*Label 377*/ GIMT_Encode4(9974), // Rule ID 19932 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        // (and:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 19932,
        GIR_EraseRootFromParent_Done,
      // Label 377: @9974
      GIM_Reject,
    // Label 374: @9975
    GIM_Reject,
    // Label 303: @9976
    GIM_Try, /*On fail goto*//*Label 378*/ GIMT_Encode4(10069),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 379*/ GIMT_Encode4(10014), // Rule ID 2107 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2107,
        GIR_Done,
      // Label 379: @10014
      GIM_Try, /*On fail goto*//*Label 380*/ GIMT_Encode4(10041), // Rule ID 2109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PANDrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2109,
        GIR_Done,
      // Label 380: @10041
      GIM_Try, /*On fail goto*//*Label 381*/ GIMT_Encode4(10068), // Rule ID 5701 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPANDQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5701,
        GIR_Done,
      // Label 381: @10068
      GIM_Reject,
    // Label 378: @10069
    GIM_Reject,
    // Label 304: @10070
    GIM_Try, /*On fail goto*//*Label 382*/ GIMT_Encode4(10415),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_Try, /*On fail goto*//*Label 383*/ GIMT_Encode4(10205), // Rule ID 19937 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }), VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 19937,
        GIR_EraseRootFromParent_Done,
      // Label 383: @10205
      GIM_Try, /*On fail goto*//*Label 384*/ GIMT_Encode4(10325), // Rule ID 25793 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src2, (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 25793,
        GIR_EraseRootFromParent_Done,
      // Label 384: @10325
      GIM_Try, /*On fail goto*//*Label 385*/ GIMT_Encode4(10414), // Rule ID 19933 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        // (and:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 19933,
        GIR_EraseRootFromParent_Done,
      // Label 385: @10414
      GIM_Reject,
    // Label 382: @10415
    GIM_Reject,
    // Label 305: @10416
    GIM_Try, /*On fail goto*//*Label 386*/ GIMT_Encode4(10509),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 387*/ GIMT_Encode4(10454), // Rule ID 5728 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPANDDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5728,
        GIR_Done,
      // Label 387: @10454
      GIM_Try, /*On fail goto*//*Label 388*/ GIMT_Encode4(10481), // Rule ID 18595 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18595,
        GIR_Done,
      // Label 388: @10481
      GIM_Try, /*On fail goto*//*Label 389*/ GIMT_Encode4(10508), // Rule ID 18619 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PANDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18619,
        GIR_Done,
      // Label 389: @10508
      GIM_Reject,
    // Label 386: @10509
    GIM_Reject,
    // Label 306: @10510
    GIM_Try, /*On fail goto*//*Label 390*/ GIMT_Encode4(10603),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 391*/ GIMT_Encode4(10548), // Rule ID 2111 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPANDYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2111,
        GIR_Done,
      // Label 391: @10548
      GIM_Try, /*On fail goto*//*Label 392*/ GIMT_Encode4(10575), // Rule ID 5692 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPANDQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5692,
        GIR_Done,
      // Label 392: @10575
      GIM_Try, /*On fail goto*//*Label 393*/ GIMT_Encode4(10602), // Rule ID 18564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VANDPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18564,
        GIR_Done,
      // Label 393: @10602
      GIM_Reject,
    // Label 390: @10603
    GIM_Reject,
    // Label 307: @10604
    GIM_Try, /*On fail goto*//*Label 394*/ GIMT_Encode4(11101),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_Try, /*On fail goto*//*Label 395*/ GIMT_Encode4(10679), // Rule ID 4428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (KANDNBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4428,
        GIR_EraseRootFromParent_Done,
      // Label 395: @10679
      GIM_Try, /*On fail goto*//*Label 396*/ GIMT_Encode4(10802), // Rule ID 19934 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 19934,
        GIR_EraseRootFromParent_Done,
      // Label 396: @10802
      GIM_Try, /*On fail goto*//*Label 397*/ GIMT_Encode4(10862), // Rule ID 24116 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (KANDNBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNBkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24116,
        GIR_EraseRootFromParent_Done,
      // Label 397: @10862
      GIM_Try, /*On fail goto*//*Label 398*/ GIMT_Encode4(10985), // Rule ID 25790 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDNWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 25790,
        GIR_EraseRootFromParent_Done,
      // Label 398: @10985
      GIM_Try, /*On fail goto*//*Label 399*/ GIMT_Encode4(11008), // Rule ID 4412 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KANDBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDBkk),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4412,
        GIR_Done,
      // Label 399: @11008
      GIM_Try, /*On fail goto*//*Label 400*/ GIMT_Encode4(11100), // Rule ID 19930 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (and:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KANDWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 19930,
        GIR_EraseRootFromParent_Done,
      // Label 400: @11100
      GIM_Reject,
    // Label 394: @11101
    GIM_Reject,
    // Label 308: @11102
    GIM_Try, /*On fail goto*//*Label 401*/ GIMT_Encode4(11195),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 402*/ GIMT_Encode4(11140), // Rule ID 18594 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18594,
        GIR_Done,
      // Label 402: @11140
      GIM_Try, /*On fail goto*//*Label 403*/ GIMT_Encode4(11167), // Rule ID 18618 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PANDrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18618,
        GIR_Done,
      // Label 403: @11167
      GIM_Try, /*On fail goto*//*Label 404*/ GIMT_Encode4(11194), // Rule ID 20464 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPANDQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20464,
        GIR_Done,
      // Label 404: @11194
      GIM_Reject,
    // Label 401: @11195
    GIM_Reject,
    // Label 309: @11196
    GIM_Try, /*On fail goto*//*Label 405*/ GIMT_Encode4(11289),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 406*/ GIMT_Encode4(11234), // Rule ID 5719 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPANDDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5719,
        GIR_Done,
      // Label 406: @11234
      GIM_Try, /*On fail goto*//*Label 407*/ GIMT_Encode4(11261), // Rule ID 18539 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPANDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18539,
        GIR_Done,
      // Label 407: @11261
      GIM_Try, /*On fail goto*//*Label 408*/ GIMT_Encode4(11288), // Rule ID 18563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VANDPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18563,
        GIR_Done,
      // Label 408: @11288
      GIM_Reject,
    // Label 405: @11289
    GIM_Reject,
    // Label 310: @11290
    GIM_Try, /*On fail goto*//*Label 409*/ GIMT_Encode4(11323), // Rule ID 5683 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPANDQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5683,
      GIR_Done,
    // Label 409: @11323
    GIM_Reject,
    // Label 311: @11324
    GIM_Try, /*On fail goto*//*Label 410*/ GIMT_Encode4(11483),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_Try, /*On fail goto*//*Label 411*/ GIMT_Encode4(11399), // Rule ID 4429 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }), VK16:{ *:[v16i1] }:$src2)  =>  (KANDNWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4429,
        GIR_EraseRootFromParent_Done,
      // Label 411: @11399
      GIM_Try, /*On fail goto*//*Label 412*/ GIMT_Encode4(11459), // Rule ID 24117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src2, (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }))  =>  (KANDNWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNWkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24117,
        GIR_EraseRootFromParent_Done,
      // Label 412: @11459
      GIM_Try, /*On fail goto*//*Label 413*/ GIMT_Encode4(11482), // Rule ID 4413 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        // (and:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KANDWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDWkk),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4413,
        GIR_Done,
      // Label 413: @11482
      GIM_Reject,
    // Label 410: @11483
    GIM_Reject,
    // Label 312: @11484
    GIM_Try, /*On fail goto*//*Label 414*/ GIMT_Encode4(11577),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 415*/ GIMT_Encode4(11522), // Rule ID 18593 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18593,
        GIR_Done,
      // Label 415: @11522
      GIM_Try, /*On fail goto*//*Label 416*/ GIMT_Encode4(11549), // Rule ID 18617 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (and:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PANDrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PANDrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18617,
        GIR_Done,
      // Label 416: @11549
      GIM_Try, /*On fail goto*//*Label 417*/ GIMT_Encode4(11576), // Rule ID 20463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (and:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPANDQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20463,
        GIR_Done,
      // Label 417: @11576
      GIM_Reject,
    // Label 414: @11577
    GIM_Reject,
    // Label 313: @11578
    GIM_Try, /*On fail goto*//*Label 418*/ GIMT_Encode4(11671),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 419*/ GIMT_Encode4(11616), // Rule ID 18538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPANDYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18538,
        GIR_Done,
      // Label 419: @11616
      GIM_Try, /*On fail goto*//*Label 420*/ GIMT_Encode4(11643), // Rule ID 18562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VANDPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18562,
        GIR_Done,
      // Label 420: @11643
      GIM_Try, /*On fail goto*//*Label 421*/ GIMT_Encode4(11670), // Rule ID 20480 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPANDQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20480,
        GIR_Done,
      // Label 421: @11670
      GIM_Reject,
    // Label 418: @11671
    GIM_Reject,
    // Label 314: @11672
    GIM_Try, /*On fail goto*//*Label 422*/ GIMT_Encode4(11705), // Rule ID 5710 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPANDDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5710,
      GIR_Done,
    // Label 422: @11705
    GIM_Reject,
    // Label 315: @11706
    GIM_Try, /*On fail goto*//*Label 423*/ GIMT_Encode4(11865),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_Try, /*On fail goto*//*Label 424*/ GIMT_Encode4(11781), // Rule ID 4430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }), VK32:{ *:[v32i1] }:$src2)  =>  (KANDNDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4430,
        GIR_EraseRootFromParent_Done,
      // Label 424: @11781
      GIM_Try, /*On fail goto*//*Label 425*/ GIMT_Encode4(11841), // Rule ID 24118 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src2, (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }))  =>  (KANDNDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNDkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24118,
        GIR_EraseRootFromParent_Done,
      // Label 425: @11841
      GIM_Try, /*On fail goto*//*Label 426*/ GIMT_Encode4(11864), // Rule ID 4414 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        // (and:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KANDDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDDkk),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4414,
        GIR_Done,
      // Label 426: @11864
      GIM_Reject,
    // Label 423: @11865
    GIM_Reject,
    // Label 316: @11866
    GIM_Try, /*On fail goto*//*Label 427*/ GIMT_Encode4(11959),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 428*/ GIMT_Encode4(11904), // Rule ID 18537 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPANDYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18537,
        GIR_Done,
      // Label 428: @11904
      GIM_Try, /*On fail goto*//*Label 429*/ GIMT_Encode4(11931), // Rule ID 18561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (and:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VANDPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VANDPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18561,
        GIR_Done,
      // Label 429: @11931
      GIM_Try, /*On fail goto*//*Label 430*/ GIMT_Encode4(11958), // Rule ID 20479 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (and:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPANDQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20479,
        GIR_Done,
      // Label 430: @11958
      GIM_Reject,
    // Label 427: @11959
    GIM_Reject,
    // Label 317: @11960
    GIM_Try, /*On fail goto*//*Label 431*/ GIMT_Encode4(11993), // Rule ID 20496 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPANDQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20496,
      GIR_Done,
    // Label 431: @11993
    GIM_Reject,
    // Label 318: @11994
    GIM_Try, /*On fail goto*//*Label 432*/ GIMT_Encode4(12153),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_Try, /*On fail goto*//*Label 433*/ GIMT_Encode4(12069), // Rule ID 4431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }), VK64:{ *:[v64i1] }:$src2)  =>  (KANDNQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4431,
        GIR_EraseRootFromParent_Done,
      // Label 433: @12069
      GIM_Try, /*On fail goto*//*Label 434*/ GIMT_Encode4(12129), // Rule ID 24119 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src2, (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }))  =>  (KANDNQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KANDNQkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24119,
        GIR_EraseRootFromParent_Done,
      // Label 434: @12129
      GIM_Try, /*On fail goto*//*Label 435*/ GIMT_Encode4(12152), // Rule ID 4415 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        // (and:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KANDQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KANDQkk),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4415,
        GIR_Done,
      // Label 435: @12152
      GIM_Reject,
    // Label 432: @12153
    GIM_Reject,
    // Label 319: @12154
    GIM_Try, /*On fail goto*//*Label 436*/ GIMT_Encode4(12187), // Rule ID 20495 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (and:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPANDQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPANDQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20495,
      GIR_Done,
    // Label 436: @12187
    GIM_Reject,
    // Label 320: @12188
    GIM_Reject,
    // Label 4: @12189
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 460*/ GIMT_Encode4(16580),
    /*GILLT_s1*//*Label 437*/ GIMT_Encode4(12300),
    /*GILLT_s8*//*Label 438*/ GIMT_Encode4(12400),
    /*GILLT_s16*//*Label 439*/ GIMT_Encode4(12537),
    /*GILLT_s32*//*Label 440*/ GIMT_Encode4(12890),
    /*GILLT_s64*//*Label 441*/ GIMT_Encode4(14074), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s1*//*Label 442*/ GIMT_Encode4(15266),
    /*GILLT_v2s64*//*Label 443*/ GIMT_Encode4(15366),
    /*GILLT_v4s1*//*Label 444*/ GIMT_Encode4(15460),
    /*GILLT_v4s32*//*Label 445*/ GIMT_Encode4(15560),
    /*GILLT_v4s64*//*Label 446*/ GIMT_Encode4(15654),
    /*GILLT_v8s1*//*Label 447*/ GIMT_Encode4(15748),
    /*GILLT_v8s16*//*Label 448*/ GIMT_Encode4(15872),
    /*GILLT_v8s32*//*Label 449*/ GIMT_Encode4(15966),
    /*GILLT_v8s64*//*Label 450*/ GIMT_Encode4(16060),
    /*GILLT_v16s1*//*Label 451*/ GIMT_Encode4(16094),
    /*GILLT_v16s8*//*Label 452*/ GIMT_Encode4(16128),
    /*GILLT_v16s16*//*Label 453*/ GIMT_Encode4(16222),
    /*GILLT_v16s32*//*Label 454*/ GIMT_Encode4(16316),
    /*GILLT_v32s1*//*Label 455*/ GIMT_Encode4(16350),
    /*GILLT_v32s8*//*Label 456*/ GIMT_Encode4(16384),
    /*GILLT_v32s16*//*Label 457*/ GIMT_Encode4(16478),
    /*GILLT_v64s1*//*Label 458*/ GIMT_Encode4(16512),
    /*GILLT_v64s8*//*Label 459*/ GIMT_Encode4(16546),
    // Label 437: @12300
    GIM_Try, /*On fail goto*//*Label 461*/ GIMT_Encode4(12399), // Rule ID 19939 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
      // (or:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
      // GIR_Coverage, 19939,
      GIR_EraseRootFromParent_Done,
    // Label 461: @12399
    GIM_Reject,
    // Label 438: @12400
    GIM_Try, /*On fail goto*//*Label 462*/ GIMT_Encode4(12536),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 463*/ GIMT_Encode4(12452), // Rule ID 23258 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23258,
        GIR_EraseRootFromParent_Done,
      // Label 463: @12452
      GIM_Try, /*On fail goto*//*Label 464*/ GIMT_Encode4(12485), // Rule ID 23348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (OR8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23348,
        GIR_EraseRootFromParent_Done,
      // Label 464: @12485
      GIM_Try, /*On fail goto*//*Label 465*/ GIMT_Encode4(12510), // Rule ID 23250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23250,
        GIR_Done,
      // Label 465: @12510
      GIM_Try, /*On fail goto*//*Label 466*/ GIMT_Encode4(12535), // Rule ID 23340 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (or:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (OR8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23340,
        GIR_Done,
      // Label 466: @12535
      GIM_Reject,
    // Label 462: @12536
    GIM_Reject,
    // Label 439: @12537
    GIM_Try, /*On fail goto*//*Label 467*/ GIMT_Encode4(12889),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 468*/ GIMT_Encode4(12654), // Rule ID 26461 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26461,
        GIR_EraseRootFromParent_Done,
      // Label 468: @12654
      GIM_Try, /*On fail goto*//*Label 469*/ GIMT_Encode4(12756), // Rule ID 23199 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTS16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23199,
        GIR_EraseRootFromParent_Done,
      // Label 469: @12756
      GIM_Try, /*On fail goto*//*Label 470*/ GIMT_Encode4(12793), // Rule ID 23259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23259,
        GIR_EraseRootFromParent_Done,
      // Label 470: @12793
      GIM_Try, /*On fail goto*//*Label 471*/ GIMT_Encode4(12830), // Rule ID 23349 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (OR16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23349,
        GIR_EraseRootFromParent_Done,
      // Label 471: @12830
      GIM_Try, /*On fail goto*//*Label 472*/ GIMT_Encode4(12859), // Rule ID 23251 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23251,
        GIR_Done,
      // Label 472: @12859
      GIM_Try, /*On fail goto*//*Label 473*/ GIMT_Encode4(12888), // Rule ID 23341 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (or:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (OR16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23341,
        GIR_Done,
      // Label 473: @12888
      GIM_Reject,
    // Label 467: @12889
    GIM_Reject,
    // Label 440: @12890
    GIM_Try, /*On fail goto*//*Label 474*/ GIMT_Encode4(14073),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 475*/ GIMT_Encode4(12975), // Rule ID 25427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25427,
        GIR_EraseRootFromParent_Done,
      // Label 475: @12975
      GIM_Try, /*On fail goto*//*Label 476*/ GIMT_Encode4(13052), // Rule ID 25429 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25429,
        GIR_EraseRootFromParent_Done,
      // Label 476: @13052
      GIM_Try, /*On fail goto*//*Label 477*/ GIMT_Encode4(13130), // Rule ID 25415 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25415,
        GIR_EraseRootFromParent_Done,
      // Label 477: @13130
      GIM_Try, /*On fail goto*//*Label 478*/ GIMT_Encode4(13207), // Rule ID 17811 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSIC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17811,
        GIR_EraseRootFromParent_Done,
      // Label 478: @13207
      GIM_Try, /*On fail goto*//*Label 479*/ GIMT_Encode4(13284), // Rule ID 17813 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (T1MSKC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17813,
        GIR_EraseRootFromParent_Done,
      // Label 479: @13284
      GIM_Try, /*On fail goto*//*Label 480*/ GIMT_Encode4(13358), // Rule ID 17799 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), -1:{ *:[i32] }))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17799,
        GIR_EraseRootFromParent_Done,
      // Label 480: @13358
      GIM_Try, /*On fail goto*//*Label 481*/ GIMT_Encode4(13416), // Rule ID 25423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25423,
        GIR_EraseRootFromParent_Done,
      // Label 481: @13416
      GIM_Try, /*On fail goto*//*Label 482*/ GIMT_Encode4(13474), // Rule ID 25425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25425,
        GIR_EraseRootFromParent_Done,
      // Label 482: @13474
      GIM_Try, /*On fail goto*//*Label 483*/ GIMT_Encode4(13583), // Rule ID 26467 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26467,
        GIR_EraseRootFromParent_Done,
      // Label 483: @13583
      GIM_Try, /*On fail goto*//*Label 484*/ GIMT_Encode4(13641), // Rule ID 25417 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src), GR32:{ *:[i32] }:$src)  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25417,
        GIR_EraseRootFromParent_Done,
      // Label 484: @13641
      GIM_Try, /*On fail goto*//*Label 485*/ GIMT_Encode4(13695), // Rule ID 17807 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17807,
        GIR_EraseRootFromParent_Done,
      // Label 485: @13695
      GIM_Try, /*On fail goto*//*Label 486*/ GIMT_Encode4(13749), // Rule ID 17809 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, -1:{ *:[i32] }))  =>  (BLSFILL32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17809,
        GIR_EraseRootFromParent_Done,
      // Label 486: @13749
      GIM_Try, /*On fail goto*//*Label 487*/ GIMT_Encode4(13858), // Rule ID 23205 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTS32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23205,
        GIR_EraseRootFromParent_Done,
      // Label 487: @13858
      GIM_Try, /*On fail goto*//*Label 488*/ GIMT_Encode4(13912), // Rule ID 17801 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src, (sub:{ *:[i32] } -2:{ *:[i32] }, GR32:{ *:[i32] }:$src))  =>  (BLCI32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17801,
        GIR_EraseRootFromParent_Done,
      // Label 488: @13912
      GIM_Try, /*On fail goto*//*Label 489*/ GIMT_Encode4(13956), // Rule ID 23260 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23260,
        GIR_EraseRootFromParent_Done,
      // Label 489: @13956
      GIM_Try, /*On fail goto*//*Label 490*/ GIMT_Encode4(14000), // Rule ID 23350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (OR32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23350,
        GIR_EraseRootFromParent_Done,
      // Label 490: @14000
      GIM_Try, /*On fail goto*//*Label 491*/ GIMT_Encode4(14036), // Rule ID 23252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23252,
        GIR_Done,
      // Label 491: @14036
      GIM_Try, /*On fail goto*//*Label 492*/ GIMT_Encode4(14072), // Rule ID 23342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (or:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (OR32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23342,
        GIR_Done,
      // Label 492: @14072
      GIM_Reject,
    // Label 474: @14073
    GIM_Reject,
    // Label 441: @14074
    GIM_Try, /*On fail goto*//*Label 493*/ GIMT_Encode4(15265),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 494*/ GIMT_Encode4(14159), // Rule ID 25428 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25428,
        GIR_EraseRootFromParent_Done,
      // Label 494: @14159
      GIM_Try, /*On fail goto*//*Label 495*/ GIMT_Encode4(14236), // Rule ID 25430 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25430,
        GIR_EraseRootFromParent_Done,
      // Label 495: @14236
      GIM_Try, /*On fail goto*//*Label 496*/ GIMT_Encode4(14314), // Rule ID 25416 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/2, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/2, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/2, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25416,
        GIR_EraseRootFromParent_Done,
      // Label 496: @14314
      GIM_Try, /*On fail goto*//*Label 497*/ GIMT_Encode4(14391), // Rule ID 17812 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSIC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSIC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17812,
        GIR_EraseRootFromParent_Done,
      // Label 497: @14391
      GIM_Try, /*On fail goto*//*Label 498*/ GIMT_Encode4(14468), // Rule ID 17814 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (T1MSKC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::T1MSKC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17814,
        GIR_EraseRootFromParent_Done,
      // Label 498: @14468
      GIM_Try, /*On fail goto*//*Label 499*/ GIMT_Encode4(14542), // Rule ID 17800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/1, // MIs[2]
        GIM_CheckOpcode, /*MI*/2, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/2, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[2] src
        GIM_CheckIsSameOperand, /*MI*/2, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/2, /*Op*/2, 1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), -1:{ *:[i64] }))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17800,
        GIR_EraseRootFromParent_Done,
      // Label 499: @14542
      GIM_Try, /*On fail goto*//*Label 500*/ GIMT_Encode4(14600), // Rule ID 25424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25424,
        GIR_EraseRootFromParent_Done,
      // Label 500: @14600
      GIM_Try, /*On fail goto*//*Label 501*/ GIMT_Encode4(14658), // Rule ID 25426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25426,
        GIR_EraseRootFromParent_Done,
      // Label 501: @14658
      GIM_Try, /*On fail goto*//*Label 502*/ GIMT_Encode4(14767), // Rule ID 26473 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26473,
        GIR_EraseRootFromParent_Done,
      // Label 502: @14767
      GIM_Try, /*On fail goto*//*Label 503*/ GIMT_Encode4(14825), // Rule ID 25418 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src), GR64:{ *:[i64] }:$src)  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25418,
        GIR_EraseRootFromParent_Done,
      // Label 503: @14825
      GIM_Try, /*On fail goto*//*Label 504*/ GIMT_Encode4(14879), // Rule ID 17808 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17808,
        GIR_EraseRootFromParent_Done,
      // Label 504: @14879
      GIM_Try, /*On fail goto*//*Label 505*/ GIMT_Encode4(14933), // Rule ID 17810 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, uint8_t(-1),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, -1:{ *:[i64] }))  =>  (BLSFILL64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLSFILL64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17810,
        GIR_EraseRootFromParent_Done,
      // Label 505: @14933
      GIM_Try, /*On fail goto*//*Label 506*/ GIMT_Encode4(15042), // Rule ID 23211 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTS64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTS64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23211,
        GIR_EraseRootFromParent_Done,
      // Label 506: @15042
      GIM_Try, /*On fail goto*//*Label 507*/ GIMT_Encode4(15096), // Rule ID 17802 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, uint8_t(-2),
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/2, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src, (sub:{ *:[i64] } -2:{ *:[i64] }, GR64:{ *:[i64] }:$src))  =>  (BLCI64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCI64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17802,
        GIR_EraseRootFromParent_Done,
      // Label 507: @15096
      GIM_Try, /*On fail goto*//*Label 508*/ GIMT_Encode4(15144), // Rule ID 23261 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23261,
        GIR_EraseRootFromParent_Done,
      // Label 508: @15144
      GIM_Try, /*On fail goto*//*Label 509*/ GIMT_Encode4(15192), // Rule ID 23351 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (OR64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::OR64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23351,
        GIR_EraseRootFromParent_Done,
      // Label 509: @15192
      GIM_Try, /*On fail goto*//*Label 510*/ GIMT_Encode4(15228), // Rule ID 23253 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23253,
        GIR_Done,
      // Label 510: @15228
      GIM_Try, /*On fail goto*//*Label 511*/ GIMT_Encode4(15264), // Rule ID 23343 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (or:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (OR64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::OR64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23343,
        GIR_Done,
      // Label 511: @15264
      GIM_Reject,
    // Label 493: @15265
    GIM_Reject,
    // Label 442: @15266
    GIM_Try, /*On fail goto*//*Label 512*/ GIMT_Encode4(15365), // Rule ID 19940 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      // (or:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
      // GIR_Coverage, 19940,
      GIR_EraseRootFromParent_Done,
    // Label 512: @15365
    GIM_Reject,
    // Label 443: @15366
    GIM_Try, /*On fail goto*//*Label 513*/ GIMT_Encode4(15459),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 514*/ GIMT_Encode4(15404), // Rule ID 2113 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2113,
        GIR_Done,
      // Label 514: @15404
      GIM_Try, /*On fail goto*//*Label 515*/ GIMT_Encode4(15431), // Rule ID 2115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2115,
        GIR_Done,
      // Label 515: @15431
      GIM_Try, /*On fail goto*//*Label 516*/ GIMT_Encode4(15458), // Rule ID 5755 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPORQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5755,
        GIR_Done,
      // Label 516: @15458
      GIM_Reject,
    // Label 513: @15459
    GIM_Reject,
    // Label 444: @15460
    GIM_Try, /*On fail goto*//*Label 517*/ GIMT_Encode4(15559), // Rule ID 19941 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      // (or:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
      // GIR_Coverage, 19941,
      GIR_EraseRootFromParent_Done,
    // Label 517: @15559
    GIM_Reject,
    // Label 445: @15560
    GIM_Try, /*On fail goto*//*Label 518*/ GIMT_Encode4(15653),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 519*/ GIMT_Encode4(15598), // Rule ID 5782 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPORDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5782,
        GIR_Done,
      // Label 519: @15598
      GIM_Try, /*On fail goto*//*Label 520*/ GIMT_Encode4(15625), // Rule ID 18598 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18598,
        GIR_Done,
      // Label 520: @15625
      GIM_Try, /*On fail goto*//*Label 521*/ GIMT_Encode4(15652), // Rule ID 18622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18622,
        GIR_Done,
      // Label 521: @15652
      GIM_Reject,
    // Label 518: @15653
    GIM_Reject,
    // Label 446: @15654
    GIM_Try, /*On fail goto*//*Label 522*/ GIMT_Encode4(15747),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 523*/ GIMT_Encode4(15692), // Rule ID 2117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPORYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2117,
        GIR_Done,
      // Label 523: @15692
      GIM_Try, /*On fail goto*//*Label 524*/ GIMT_Encode4(15719), // Rule ID 5746 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPORQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5746,
        GIR_Done,
      // Label 524: @15719
      GIM_Try, /*On fail goto*//*Label 525*/ GIMT_Encode4(15746), // Rule ID 18568 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VORPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18568,
        GIR_Done,
      // Label 525: @15746
      GIM_Reject,
    // Label 522: @15747
    GIM_Reject,
    // Label 447: @15748
    GIM_Try, /*On fail goto*//*Label 526*/ GIMT_Encode4(15871),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_Try, /*On fail goto*//*Label 527*/ GIMT_Encode4(15786), // Rule ID 4416 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KORBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORBkk),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4416,
        GIR_Done,
      // Label 527: @15786
      GIM_Try, /*On fail goto*//*Label 528*/ GIMT_Encode4(15870), // Rule ID 19938 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        // (or:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 19938,
        GIR_EraseRootFromParent_Done,
      // Label 528: @15870
      GIM_Reject,
    // Label 526: @15871
    GIM_Reject,
    // Label 448: @15872
    GIM_Try, /*On fail goto*//*Label 529*/ GIMT_Encode4(15965),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 530*/ GIMT_Encode4(15910), // Rule ID 18597 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18597,
        GIR_Done,
      // Label 530: @15910
      GIM_Try, /*On fail goto*//*Label 531*/ GIMT_Encode4(15937), // Rule ID 18621 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18621,
        GIR_Done,
      // Label 531: @15937
      GIM_Try, /*On fail goto*//*Label 532*/ GIMT_Encode4(15964), // Rule ID 20466 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPORQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20466,
        GIR_Done,
      // Label 532: @15964
      GIM_Reject,
    // Label 529: @15965
    GIM_Reject,
    // Label 449: @15966
    GIM_Try, /*On fail goto*//*Label 533*/ GIMT_Encode4(16059),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 534*/ GIMT_Encode4(16004), // Rule ID 5773 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPORDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5773,
        GIR_Done,
      // Label 534: @16004
      GIM_Try, /*On fail goto*//*Label 535*/ GIMT_Encode4(16031), // Rule ID 18542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPORYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18542,
        GIR_Done,
      // Label 535: @16031
      GIM_Try, /*On fail goto*//*Label 536*/ GIMT_Encode4(16058), // Rule ID 18567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VORPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18567,
        GIR_Done,
      // Label 536: @16058
      GIM_Reject,
    // Label 533: @16059
    GIM_Reject,
    // Label 450: @16060
    GIM_Try, /*On fail goto*//*Label 537*/ GIMT_Encode4(16093), // Rule ID 5737 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPORQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5737,
      GIR_Done,
    // Label 537: @16093
    GIM_Reject,
    // Label 451: @16094
    GIM_Try, /*On fail goto*//*Label 538*/ GIMT_Encode4(16127), // Rule ID 4417 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      // (or:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KORWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORWkk),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4417,
      GIR_Done,
    // Label 538: @16127
    GIM_Reject,
    // Label 452: @16128
    GIM_Try, /*On fail goto*//*Label 539*/ GIMT_Encode4(16221),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 540*/ GIMT_Encode4(16166), // Rule ID 18596 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18596,
        GIR_Done,
      // Label 540: @16166
      GIM_Try, /*On fail goto*//*Label 541*/ GIMT_Encode4(16193), // Rule ID 18620 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (or:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18620,
        GIR_Done,
      // Label 541: @16193
      GIM_Try, /*On fail goto*//*Label 542*/ GIMT_Encode4(16220), // Rule ID 20465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (or:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPORQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20465,
        GIR_Done,
      // Label 542: @16220
      GIM_Reject,
    // Label 539: @16221
    GIM_Reject,
    // Label 453: @16222
    GIM_Try, /*On fail goto*//*Label 543*/ GIMT_Encode4(16315),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 544*/ GIMT_Encode4(16260), // Rule ID 18541 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPORYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18541,
        GIR_Done,
      // Label 544: @16260
      GIM_Try, /*On fail goto*//*Label 545*/ GIMT_Encode4(16287), // Rule ID 18566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VORPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18566,
        GIR_Done,
      // Label 545: @16287
      GIM_Try, /*On fail goto*//*Label 546*/ GIMT_Encode4(16314), // Rule ID 20482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPORQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20482,
        GIR_Done,
      // Label 546: @16314
      GIM_Reject,
    // Label 543: @16315
    GIM_Reject,
    // Label 454: @16316
    GIM_Try, /*On fail goto*//*Label 547*/ GIMT_Encode4(16349), // Rule ID 5764 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPORDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 5764,
      GIR_Done,
    // Label 547: @16349
    GIM_Reject,
    // Label 455: @16350
    GIM_Try, /*On fail goto*//*Label 548*/ GIMT_Encode4(16383), // Rule ID 4418 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      // (or:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KORDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORDkk),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4418,
      GIR_Done,
    // Label 548: @16383
    GIM_Reject,
    // Label 456: @16384
    GIM_Try, /*On fail goto*//*Label 549*/ GIMT_Encode4(16477),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 550*/ GIMT_Encode4(16422), // Rule ID 18540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPORYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18540,
        GIR_Done,
      // Label 550: @16422
      GIM_Try, /*On fail goto*//*Label 551*/ GIMT_Encode4(16449), // Rule ID 18565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (or:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VORPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18565,
        GIR_Done,
      // Label 551: @16449
      GIM_Try, /*On fail goto*//*Label 552*/ GIMT_Encode4(16476), // Rule ID 20481 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (or:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPORQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20481,
        GIR_Done,
      // Label 552: @16476
      GIM_Reject,
    // Label 549: @16477
    GIM_Reject,
    // Label 457: @16478
    GIM_Try, /*On fail goto*//*Label 553*/ GIMT_Encode4(16511), // Rule ID 20498 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPORQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20498,
      GIR_Done,
    // Label 553: @16511
    GIM_Reject,
    // Label 458: @16512
    GIM_Try, /*On fail goto*//*Label 554*/ GIMT_Encode4(16545), // Rule ID 4419 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      // (or:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KORQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KORQkk),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4419,
      GIR_Done,
    // Label 554: @16545
    GIM_Reject,
    // Label 459: @16546
    GIM_Try, /*On fail goto*//*Label 555*/ GIMT_Encode4(16579), // Rule ID 20497 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (or:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPORQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPORQZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20497,
      GIR_Done,
    // Label 555: @16579
    GIM_Reject,
    // Label 460: @16580
    GIM_Reject,
    // Label 5: @16581
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(25), /*)*//*default:*//*Label 579*/ GIMT_Encode4(25027),
    /*GILLT_s1*//*Label 556*/ GIMT_Encode4(16692),
    /*GILLT_s8*//*Label 557*/ GIMT_Encode4(17250),
    /*GILLT_s16*//*Label 558*/ GIMT_Encode4(17453),
    /*GILLT_s32*//*Label 559*/ GIMT_Encode4(17898),
    /*GILLT_s64*//*Label 560*/ GIMT_Encode4(18511), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s1*//*Label 561*/ GIMT_Encode4(19083),
    /*GILLT_v2s64*//*Label 562*/ GIMT_Encode4(19625),
    /*GILLT_v4s1*//*Label 563*/ GIMT_Encode4(19997),
    /*GILLT_v4s32*//*Label 564*/ GIMT_Encode4(20539),
    /*GILLT_v4s64*//*Label 565*/ GIMT_Encode4(20911),
    /*GILLT_v8s1*//*Label 566*/ GIMT_Encode4(21283),
    /*GILLT_v8s16*//*Label 567*/ GIMT_Encode4(22081),
    /*GILLT_v8s32*//*Label 568*/ GIMT_Encode4(22453),
    /*GILLT_v8s64*//*Label 569*/ GIMT_Encode4(22825),
    /*GILLT_v16s1*//*Label 570*/ GIMT_Encode4(22903),
    /*GILLT_v16s8*//*Label 571*/ GIMT_Encode4(23161),
    /*GILLT_v16s16*//*Label 572*/ GIMT_Encode4(23533),
    /*GILLT_v16s32*//*Label 573*/ GIMT_Encode4(23905),
    /*GILLT_v32s1*//*Label 574*/ GIMT_Encode4(23983),
    /*GILLT_v32s8*//*Label 575*/ GIMT_Encode4(24241),
    /*GILLT_v32s16*//*Label 576*/ GIMT_Encode4(24613),
    /*GILLT_v64s1*//*Label 577*/ GIMT_Encode4(24691),
    /*GILLT_v64s8*//*Label 578*/ GIMT_Encode4(24949),
    // Label 556: @16692
    GIM_Try, /*On fail goto*//*Label 580*/ GIMT_Encode4(17249),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s1,
      GIM_Try, /*On fail goto*//*Label 581*/ GIMT_Encode4(16827), // Rule ID 25796 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }), VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 25796,
        GIR_EraseRootFromParent_Done,
      // Label 581: @16827
      GIM_Try, /*On fail goto*//*Label 582*/ GIMT_Encode4(16952), // Rule ID 19943 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v1i1] } (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2), immAllOnesV:{ *:[v1i1] })  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 19943,
        GIR_EraseRootFromParent_Done,
      // Label 582: @16952
      GIM_Try, /*On fail goto*//*Label 583*/ GIMT_Encode4(17076), // Rule ID 25797 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src2, (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, immAllOnesV:{ *:[v1i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 25797,
        GIR_EraseRootFromParent_Done,
      // Label 583: @17076
      GIM_Try, /*On fail goto*//*Label 584*/ GIMT_Encode4(17155), // Rule ID 19929 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src, immAllOnesV:{ *:[v1i1] })  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KNOTWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 19929,
        GIR_EraseRootFromParent_Done,
      // Label 584: @17155
      GIM_Try, /*On fail goto*//*Label 585*/ GIMT_Encode4(17248), // Rule ID 19947 //
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK1RegClassID),
        // (xor:{ *:[v1i1] } VK1:{ *:[v1i1] }:$src1, VK1:{ *:[v1i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v1i1] } (KXORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK1:{ *:[v1i1] }:$src2, VK16:{ *:[i32] })), VK1:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK1RegClassID),
        // GIR_Coverage, 19947,
        GIR_EraseRootFromParent_Done,
      // Label 585: @17248
      GIM_Reject,
    // Label 580: @17249
    GIM_Reject,
    // Label 557: @17250
    GIM_Try, /*On fail goto*//*Label 586*/ GIMT_Encode4(17452),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_Try, /*On fail goto*//*Label 587*/ GIMT_Encode4(17293), // Rule ID 23023 //
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-128),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, -128:{ *:[i8] })  =>  (ADD8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, -128:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm8, /*InsnID*/0, /*Imm*/uint8_t(-128),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23023,
        GIR_EraseRootFromParent_Done,
      // Label 587: @17293
      GIM_Try, /*On fail goto*//*Label 588*/ GIMT_Encode4(17314), // Rule ID 243 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, -1:{ *:[i8] })  =>  (NOT8r:{ *:[i8] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT8r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 243,
        GIR_EraseRootFromParent_Done,
      // Label 588: @17314
      GIM_Try, /*On fail goto*//*Label 589*/ GIMT_Encode4(17335), // Rule ID 251 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, -1:{ *:[i8] })  =>  (NOT8r_ND:{ *:[i8] } GR8:{ *:[i8] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT8r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 251,
        GIR_EraseRootFromParent_Done,
      // Label 589: @17335
      GIM_Try, /*On fail goto*//*Label 590*/ GIMT_Encode4(17368), // Rule ID 23270 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (XOR8ri:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR8ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23270,
        GIR_EraseRootFromParent_Done,
      // Label 590: @17368
      GIM_Try, /*On fail goto*//*Label 591*/ GIMT_Encode4(17401), // Rule ID 23360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)  =>  (XOR8ri_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, (imm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR8ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23360,
        GIR_EraseRootFromParent_Done,
      // Label 591: @17401
      GIM_Try, /*On fail goto*//*Label 592*/ GIMT_Encode4(17426), // Rule ID 23262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (XOR8rr:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR8rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23262,
        GIR_Done,
      // Label 592: @17426
      GIM_Try, /*On fail goto*//*Label 593*/ GIMT_Encode4(17451), // Rule ID 23352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (xor:{ *:[i8] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (XOR8rr_ND:{ *:[i8] }:{ *:[i32] } GR8:{ *:[i8] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR8rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23352,
        GIR_Done,
      // Label 593: @17451
      GIM_Reject,
    // Label 586: @17452
    GIM_Reject,
    // Label 558: @17453
    GIM_Try, /*On fail goto*//*Label 594*/ GIMT_Encode4(17897),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_Try, /*On fail goto*//*Label 595*/ GIMT_Encode4(17510), // Rule ID 23024 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(-32768),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, -32768:{ *:[i16] })  =>  (ADD16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, -32768:{ *:[i16] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-32768),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23024,
        GIR_EraseRootFromParent_Done,
      // Label 595: @17510
      GIM_Try, /*On fail goto*//*Label 596*/ GIMT_Encode4(17612), // Rule ID 26462 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2), GR16:{ *:[i16] }:$src1)  =>  (BTC16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26462,
        GIR_EraseRootFromParent_Done,
      // Label 596: @17612
      GIM_Try, /*On fail goto*//*Label 597*/ GIMT_Encode4(17714), // Rule ID 23200 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s16,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, (shl:{ *:[i16] } 1:{ *:[i16] }, GR8:{ *:[i8] }:$src2))  =>  (BTC16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (INSERT_SUBREG:{ *:[i16] } (IMPLICIT_DEF:{ *:[i16] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC16rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23200,
        GIR_EraseRootFromParent_Done,
      // Label 597: @17714
      GIM_Try, /*On fail goto*//*Label 598*/ GIMT_Encode4(17739), // Rule ID 244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, -1:{ *:[i16] })  =>  (NOT16r:{ *:[i16] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT16r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 244,
        GIR_EraseRootFromParent_Done,
      // Label 598: @17739
      GIM_Try, /*On fail goto*//*Label 599*/ GIMT_Encode4(17764), // Rule ID 252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, -1:{ *:[i16] })  =>  (NOT16r_ND:{ *:[i16] } GR16:{ *:[i16] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT16r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 252,
        GIR_EraseRootFromParent_Done,
      // Label 599: @17764
      GIM_Try, /*On fail goto*//*Label 600*/ GIMT_Encode4(17801), // Rule ID 23271 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (XOR16ri:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR16ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23271,
        GIR_EraseRootFromParent_Done,
      // Label 600: @17801
      GIM_Try, /*On fail goto*//*Label 601*/ GIMT_Encode4(17838), // Rule ID 23361 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)  =>  (XOR16ri_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, (imm:{ *:[i16] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR16ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23361,
        GIR_EraseRootFromParent_Done,
      // Label 601: @17838
      GIM_Try, /*On fail goto*//*Label 602*/ GIMT_Encode4(17867), // Rule ID 23263 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (XOR16rr:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR16rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23263,
        GIR_Done,
      // Label 602: @17867
      GIM_Try, /*On fail goto*//*Label 603*/ GIMT_Encode4(17896), // Rule ID 23353 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (xor:{ *:[i16] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (XOR16rr_ND:{ *:[i16] }:{ *:[i32] } GR16:{ *:[i16] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR16rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23353,
        GIR_Done,
      // Label 603: @17896
      GIM_Reject,
    // Label 594: @17897
    GIM_Reject,
    // Label 559: @17898
    GIM_Try, /*On fail goto*//*Label 604*/ GIMT_Encode4(18510),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_Try, /*On fail goto*//*Label 605*/ GIMT_Encode4(17955), // Rule ID 23025 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt, /*MI*/0, /*Op*/2, GIMT_Encode8(-2147483648),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -2147483648:{ *:[i32] })  =>  (ADD32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, -2147483648:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ADD32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddImm, /*InsnID*/0, /*Imm*/GIMT_Encode8(-2147483648),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23025,
        GIR_EraseRootFromParent_Done,
      // Label 605: @17955
      GIM_Try, /*On fail goto*//*Label 606*/ GIMT_Encode4(18013), // Rule ID 25421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }), GR32:{ *:[i32] }:$src)  =>  (BLCMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25421,
        GIR_EraseRootFromParent_Done,
      // Label 606: @18013
      GIM_Try, /*On fail goto*//*Label 607*/ GIMT_Encode4(18122), // Rule ID 26468 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2), GR32:{ *:[i32] }:$src1)  =>  (BTC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26468,
        GIR_EraseRootFromParent_Done,
      // Label 607: @18122
      GIM_Try, /*On fail goto*//*Label 608*/ GIMT_Encode4(18176), // Rule ID 17805 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s32,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src, (add:{ *:[i32] } GR32:{ *:[i32] }:$src, 1:{ *:[i32] }))  =>  (BLCMSK32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17805,
        GIR_EraseRootFromParent_Done,
      // Label 608: @18176
      GIM_Try, /*On fail goto*//*Label 609*/ GIMT_Encode4(18285), // Rule ID 23206 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s32,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, (shl:{ *:[i32] } 1:{ *:[i32] }, GR8:{ *:[i8] }:$src2))  =>  (BTC32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC32rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23206,
        GIR_EraseRootFromParent_Done,
      // Label 609: @18285
      GIM_Try, /*On fail goto*//*Label 610*/ GIMT_Encode4(18317), // Rule ID 245 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] })  =>  (NOT32r:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT32r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 245,
        GIR_EraseRootFromParent_Done,
      // Label 610: @18317
      GIM_Try, /*On fail goto*//*Label 611*/ GIMT_Encode4(18349), // Rule ID 253 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, -1:{ *:[i32] })  =>  (NOT32r_ND:{ *:[i32] } GR32:{ *:[i32] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT32r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 253,
        GIR_EraseRootFromParent_Done,
      // Label 611: @18349
      GIM_Try, /*On fail goto*//*Label 612*/ GIMT_Encode4(18393), // Rule ID 23272 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (XOR32ri:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR32ri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23272,
        GIR_EraseRootFromParent_Done,
      // Label 612: @18393
      GIM_Try, /*On fail goto*//*Label 613*/ GIMT_Encode4(18437), // Rule ID 23362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)  =>  (XOR32ri_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR32ri_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23362,
        GIR_EraseRootFromParent_Done,
      // Label 613: @18437
      GIM_Try, /*On fail goto*//*Label 614*/ GIMT_Encode4(18473), // Rule ID 23264 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (XOR32rr:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR32rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23264,
        GIR_Done,
      // Label 614: @18473
      GIM_Try, /*On fail goto*//*Label 615*/ GIMT_Encode4(18509), // Rule ID 23354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (xor:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (XOR32rr_ND:{ *:[i32] }:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR32rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23354,
        GIR_Done,
      // Label 615: @18509
      GIM_Reject,
    // Label 604: @18510
    GIM_Reject,
    // Label 560: @18511
    GIM_Try, /*On fail goto*//*Label 616*/ GIMT_Encode4(19082),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_Try, /*On fail goto*//*Label 617*/ GIMT_Encode4(18577), // Rule ID 25422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        // MIs[0] src
        GIM_CheckIsSameOperand, /*MI*/0, /*OpIdx*/2, /*OtherMI*/1, /*OtherOpIdx*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }), GR64:{ *:[i64] }:$src)  =>  (BLCMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 25422,
        GIR_EraseRootFromParent_Done,
      // Label 617: @18577
      GIM_Try, /*On fail goto*//*Label 618*/ GIMT_Encode4(18686), // Rule ID 26474 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2), GR64:{ *:[i64] }:$src1)  =>  (BTC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 26474,
        GIR_EraseRootFromParent_Done,
      // Label 618: @18686
      GIM_Try, /*On fail goto*//*Label 619*/ GIMT_Encode4(18740), // Rule ID 17806 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTBM),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
        // MIs[1] src
        GIM_CheckIsSameOperand, /*MI*/1, /*OpIdx*/1, /*OtherMI*/0, /*OtherOpIdx*/1,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/2, 1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src, (add:{ *:[i64] } GR64:{ *:[i64] }:$src, 1:{ *:[i64] }))  =>  (BLCMSK64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BLCMSK64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17806,
        GIR_EraseRootFromParent_Done,
      // Label 619: @18740
      GIM_Try, /*On fail goto*//*Label 620*/ GIMT_Encode4(18849), // Rule ID 23212 //
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s8,
        GIM_CheckConstantInt8, /*MI*/1, /*Op*/1, 1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, (shl:{ *:[i64] } 1:{ *:[i64] }, GR8:{ *:[i8] }:$src2))  =>  (BTC64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR8:{ *:[i8] }:$src2, sub_8bit:{ *:[i32] }))
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::BTC64rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23212,
        GIR_EraseRootFromParent_Done,
      // Label 620: @18849
      GIM_Try, /*On fail goto*//*Label 621*/ GIMT_Encode4(18881), // Rule ID 246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] })  =>  (NOT64r:{ *:[i64] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT64r),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 246,
        GIR_EraseRootFromParent_Done,
      // Label 621: @18881
      GIM_Try, /*On fail goto*//*Label 622*/ GIMT_Encode4(18913), // Rule ID 254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD_In64BitMode),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_CheckConstantInt8, /*MI*/0, /*Op*/2, uint8_t(-1),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, -1:{ *:[i64] })  =>  (NOT64r_ND:{ *:[i64] } GR64:{ *:[i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::NOT64r_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 254,
        GIR_EraseRootFromParent_Done,
      // Label 622: @18913
      GIM_Try, /*On fail goto*//*Label 623*/ GIMT_Encode4(18961), // Rule ID 23273 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (XOR64ri32:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR64ri32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23273,
        GIR_EraseRootFromParent_Done,
      // Label 623: @18961
      GIM_Try, /*On fail goto*//*Label 624*/ GIMT_Encode4(19009), // Rule ID 23363 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        GIM_CheckI64ImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_I64_Predicate_i64immSExt32),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)  =>  (XOR64ri32_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, (imm:{ *:[i64] })<<P:Predicate_i64immSExt32>>:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XOR64ri32_ND),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23363,
        GIR_EraseRootFromParent_Done,
      // Label 624: @19009
      GIM_Try, /*On fail goto*//*Label 625*/ GIMT_Encode4(19045), // Rule ID 23265 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (XOR64rr:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR64rr),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23265,
        GIR_Done,
      // Label 625: @19045
      GIM_Try, /*On fail goto*//*Label 626*/ GIMT_Encode4(19081), // Rule ID 23355 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasNDD),
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (xor:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (XOR64rr_ND:{ *:[i64] }:{ *:[i32] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::XOR64rr_ND),
        GIR_AddImplicitDef, /*InsnID*/0, GIMT_Encode2(X86::EFLAGS), GIMT_Encode2(RegState::Dead),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 23355,
        GIR_Done,
      // Label 626: @19081
      GIM_Reject,
    // Label 616: @19082
    GIM_Reject,
    // Label 561: @19083
    GIM_Try, /*On fail goto*//*Label 627*/ GIMT_Encode4(19624),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
      GIM_Try, /*On fail goto*//*Label 628*/ GIMT_Encode4(19218), // Rule ID 25798 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }), VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 25798,
        GIR_EraseRootFromParent_Done,
      // Label 628: @19218
      GIM_Try, /*On fail goto*//*Label 629*/ GIMT_Encode4(19339), // Rule ID 19944 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v2i1] } (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2), immAllOnesV:{ *:[v2i1] })  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 19944,
        GIR_EraseRootFromParent_Done,
      // Label 629: @19339
      GIM_Try, /*On fail goto*//*Label 630*/ GIMT_Encode4(19459), // Rule ID 25799 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src2, (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, immAllOnesV:{ *:[v2i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 25799,
        GIR_EraseRootFromParent_Done,
      // Label 630: @19459
      GIM_Try, /*On fail goto*//*Label 631*/ GIMT_Encode4(19534), // Rule ID 19928 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src, immAllOnesV:{ *:[v2i1] })  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KNOTWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 19928,
        GIR_EraseRootFromParent_Done,
      // Label 631: @19534
      GIM_Try, /*On fail goto*//*Label 632*/ GIMT_Encode4(19623), // Rule ID 19948 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK2RegClassID),
        // (xor:{ *:[v2i1] } VK2:{ *:[v2i1] }:$src1, VK2:{ *:[v2i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v2i1] } (KXORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK2:{ *:[v2i1] }:$src2, VK16:{ *:[i32] })), VK2:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK2RegClassID),
        // GIR_Coverage, 19948,
        GIR_EraseRootFromParent_Done,
      // Label 632: @19623
      GIM_Reject,
    // Label 627: @19624
    GIM_Reject,
    // Label 562: @19625
    GIM_Try, /*On fail goto*//*Label 633*/ GIMT_Encode4(19996),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_Try, /*On fail goto*//*Label 634*/ GIMT_Encode4(19868), // Rule ID 22393 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src, immAllOnesV:{ *:[v2i64] })  =>  (EXTRACT_SUBREG:{ *:[v2i64] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v2i64] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 22393,
        GIR_EraseRootFromParent_Done,
      // Label 634: @19868
      GIM_Try, /*On fail goto*//*Label 635*/ GIMT_Encode4(19914), // Rule ID 22401 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src, immAllOnesV:{ *:[v2i64] })  =>  (VPTERNLOGQZ128rri:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src, VR128X:{ *:[v2i64] }:$src, VR128X:{ *:[v2i64] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22401,
        GIR_EraseRootFromParent_Done,
      // Label 635: @19914
      GIM_Try, /*On fail goto*//*Label 636*/ GIMT_Encode4(19941), // Rule ID 2119 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VPXORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2119,
        GIR_Done,
      // Label 636: @19941
      GIM_Try, /*On fail goto*//*Label 637*/ GIMT_Encode4(19968), // Rule ID 2121 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (PXORrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2121,
        GIR_Done,
      // Label 637: @19968
      GIM_Try, /*On fail goto*//*Label 638*/ GIMT_Encode4(19995), // Rule ID 5809 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VPXORQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5809,
        GIR_Done,
      // Label 638: @19995
      GIM_Reject,
    // Label 633: @19996
    GIM_Reject,
    // Label 563: @19997
    GIM_Try, /*On fail goto*//*Label 639*/ GIMT_Encode4(20538),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
      GIM_Try, /*On fail goto*//*Label 640*/ GIMT_Encode4(20132), // Rule ID 25800 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }), VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 25800,
        GIR_EraseRootFromParent_Done,
      // Label 640: @20132
      GIM_Try, /*On fail goto*//*Label 641*/ GIMT_Encode4(20253), // Rule ID 19945 //
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i1] } (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2), immAllOnesV:{ *:[v4i1] })  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 19945,
        GIR_EraseRootFromParent_Done,
      // Label 641: @20253
      GIM_Try, /*On fail goto*//*Label 642*/ GIMT_Encode4(20373), // Rule ID 25801 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v4s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v4s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src2, (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, immAllOnesV:{ *:[v4i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 25801,
        GIR_EraseRootFromParent_Done,
      // Label 642: @20373
      GIM_Try, /*On fail goto*//*Label 643*/ GIMT_Encode4(20448), // Rule ID 19927 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src, immAllOnesV:{ *:[v4i1] })  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KNOTWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 19927,
        GIR_EraseRootFromParent_Done,
      // Label 643: @20448
      GIM_Try, /*On fail goto*//*Label 644*/ GIMT_Encode4(20537), // Rule ID 19949 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK4RegClassID),
        // (xor:{ *:[v4i1] } VK4:{ *:[v4i1] }:$src1, VK4:{ *:[v4i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v4i1] } (KXORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK4:{ *:[v4i1] }:$src2, VK16:{ *:[i32] })), VK4:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK4RegClassID),
        // GIR_Coverage, 19949,
        GIR_EraseRootFromParent_Done,
      // Label 644: @20537
      GIM_Reject,
    // Label 639: @20538
    GIM_Reject,
    // Label 564: @20539
    GIM_Try, /*On fail goto*//*Label 645*/ GIMT_Encode4(20910),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_Try, /*On fail goto*//*Label 646*/ GIMT_Encode4(20782), // Rule ID 22392 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src, immAllOnesV:{ *:[v4i32] })  =>  (EXTRACT_SUBREG:{ *:[v4i32] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v4i32] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v4i32] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v4i32] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 22392,
        GIR_EraseRootFromParent_Done,
      // Label 646: @20782
      GIM_Try, /*On fail goto*//*Label 647*/ GIMT_Encode4(20828), // Rule ID 22400 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src, immAllOnesV:{ *:[v4i32] })  =>  (VPTERNLOGQZ128rri:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src, VR128X:{ *:[v4i32] }:$src, VR128X:{ *:[v4i32] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22400,
        GIR_EraseRootFromParent_Done,
      // Label 647: @20828
      GIM_Try, /*On fail goto*//*Label 648*/ GIMT_Encode4(20855), // Rule ID 5836 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VPXORDZ128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORDZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5836,
        GIR_Done,
      // Label 648: @20855
      GIM_Try, /*On fail goto*//*Label 649*/ GIMT_Encode4(20882), // Rule ID 18601 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPXORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18601,
        GIR_Done,
      // Label 649: @20882
      GIM_Try, /*On fail goto*//*Label 650*/ GIMT_Encode4(20909), // Rule ID 18625 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PXORrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18625,
        GIR_Done,
      // Label 650: @20909
      GIM_Reject,
    // Label 645: @20910
    GIM_Reject,
    // Label 565: @20911
    GIM_Try, /*On fail goto*//*Label 651*/ GIMT_Encode4(21282),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 652*/ GIMT_Encode4(21154), // Rule ID 22397 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src, immAllOnesV:{ *:[v4i64] })  =>  (EXTRACT_SUBREG:{ *:[v4i64] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 22397,
        GIR_EraseRootFromParent_Done,
      // Label 652: @21154
      GIM_Try, /*On fail goto*//*Label 653*/ GIMT_Encode4(21200), // Rule ID 22405 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src, immAllOnesV:{ *:[v4i64] })  =>  (VPTERNLOGQZ256rri:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src, VR256X:{ *:[v4i64] }:$src, VR256X:{ *:[v4i64] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22405,
        GIR_EraseRootFromParent_Done,
      // Label 653: @21200
      GIM_Try, /*On fail goto*//*Label 654*/ GIMT_Encode4(21227), // Rule ID 2123 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VPXORYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2123,
        GIR_Done,
      // Label 654: @21227
      GIM_Try, /*On fail goto*//*Label 655*/ GIMT_Encode4(21254), // Rule ID 5800 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VPXORQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5800,
        GIR_Done,
      // Label 655: @21254
      GIM_Try, /*On fail goto*//*Label 656*/ GIMT_Encode4(21281), // Rule ID 18572 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VXORPSYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18572,
        GIR_Done,
      // Label 656: @21281
      GIM_Reject,
    // Label 651: @21282
    GIM_Reject,
    // Label 566: @21283
    GIM_Try, /*On fail goto*//*Label 657*/ GIMT_Encode4(22080),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_Try, /*On fail goto*//*Label 658*/ GIMT_Encode4(21358), // Rule ID 24108 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (KXNORBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORBkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24108,
        GIR_EraseRootFromParent_Done,
      // Label 658: @21358
      GIM_Try, /*On fail goto*//*Label 659*/ GIMT_Encode4(21481), // Rule ID 25794 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }), VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 25794,
        GIR_EraseRootFromParent_Done,
      // Label 659: @21481
      GIM_Try, /*On fail goto*//*Label 660*/ GIMT_Encode4(21544), // Rule ID 4420 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2), immAllOnesV:{ *:[v8i1] })  =>  (KXNORBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORBkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4420,
        GIR_EraseRootFromParent_Done,
      // Label 660: @21544
      GIM_Try, /*On fail goto*//*Label 661*/ GIMT_Encode4(21668), // Rule ID 19942 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2), immAllOnesV:{ *:[v8i1] })  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 19942,
        GIR_EraseRootFromParent_Done,
      // Label 661: @21668
      GIM_Try, /*On fail goto*//*Label 662*/ GIMT_Encode4(21728), // Rule ID 24109 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (KXNORBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORBkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24109,
        GIR_EraseRootFromParent_Done,
      // Label 662: @21728
      GIM_Try, /*On fail goto*//*Label 663*/ GIMT_Encode4(21851), // Rule ID 25795 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src2, (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, immAllOnesV:{ *:[v8i1] }))  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXNORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 25795,
        GIR_EraseRootFromParent_Done,
      // Label 663: @21851
      GIM_Try, /*On fail goto*//*Label 664*/ GIMT_Encode4(21886), // Rule ID 4408 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src, immAllOnesV:{ *:[v8i1] })  =>  (KNOTBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTBkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4408,
        GIR_EraseRootFromParent_Done,
      // Label 664: @21886
      GIM_Try, /*On fail goto*//*Label 665*/ GIMT_Encode4(21964), // Rule ID 19926 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src, immAllOnesV:{ *:[v8i1] })  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KNOTWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KNOTWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 19926,
        GIR_EraseRootFromParent_Done,
      // Label 665: @21964
      GIM_Try, /*On fail goto*//*Label 666*/ GIMT_Encode4(21987), // Rule ID 4424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KXORBkk:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORBkk),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4424,
        GIR_Done,
      // Label 666: @21987
      GIM_Try, /*On fail goto*//*Label 667*/ GIMT_Encode4(22079), // Rule ID 19946 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_NoDQI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (xor:{ *:[v8i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (KXORWkk:{ *:[v16i1] } (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK16:{ *:[i32] }), (COPY_TO_REGCLASS:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK16:{ *:[i32] })), VK8:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/2, // src2
        GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src1
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s1,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KXORWkk),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
        // GIR_Coverage, 19946,
        GIR_EraseRootFromParent_Done,
      // Label 667: @22079
      GIM_Reject,
    // Label 657: @22080
    GIM_Reject,
    // Label 567: @22081
    GIM_Try, /*On fail goto*//*Label 668*/ GIMT_Encode4(22452),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
      GIM_Try, /*On fail goto*//*Label 669*/ GIMT_Encode4(22324), // Rule ID 22391 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src, immAllOnesV:{ *:[v8i16] })  =>  (EXTRACT_SUBREG:{ *:[v8i16] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v8i16] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v8i16] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v8i16] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 22391,
        GIR_EraseRootFromParent_Done,
      // Label 669: @22324
      GIM_Try, /*On fail goto*//*Label 670*/ GIMT_Encode4(22370), // Rule ID 22399 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src, immAllOnesV:{ *:[v8i16] })  =>  (VPTERNLOGQZ128rri:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src, VR128X:{ *:[v8i16] }:$src, VR128X:{ *:[v8i16] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22399,
        GIR_EraseRootFromParent_Done,
      // Label 670: @22370
      GIM_Try, /*On fail goto*//*Label 671*/ GIMT_Encode4(22397), // Rule ID 18600 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPXORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18600,
        GIR_Done,
      // Label 671: @22397
      GIM_Try, /*On fail goto*//*Label 672*/ GIMT_Encode4(22424), // Rule ID 18624 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PXORrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18624,
        GIR_Done,
      // Label 672: @22424
      GIM_Try, /*On fail goto*//*Label 673*/ GIMT_Encode4(22451), // Rule ID 20468 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)  =>  (VPXORQZ128rr:{ *:[v8i16] } VR128X:{ *:[v8i16] }:$src1, VR128X:{ *:[v8i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20468,
        GIR_Done,
      // Label 673: @22451
      GIM_Reject,
    // Label 668: @22452
    GIM_Reject,
    // Label 568: @22453
    GIM_Try, /*On fail goto*//*Label 674*/ GIMT_Encode4(22824),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
      GIM_Try, /*On fail goto*//*Label 675*/ GIMT_Encode4(22696), // Rule ID 22396 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src, immAllOnesV:{ *:[v8i32] })  =>  (EXTRACT_SUBREG:{ *:[v8i32] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 22396,
        GIR_EraseRootFromParent_Done,
      // Label 675: @22696
      GIM_Try, /*On fail goto*//*Label 676*/ GIMT_Encode4(22742), // Rule ID 22404 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src, immAllOnesV:{ *:[v8i32] })  =>  (VPTERNLOGQZ256rri:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src, VR256X:{ *:[v8i32] }:$src, VR256X:{ *:[v8i32] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22404,
        GIR_EraseRootFromParent_Done,
      // Label 676: @22742
      GIM_Try, /*On fail goto*//*Label 677*/ GIMT_Encode4(22769), // Rule ID 5827 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VPXORDZ256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5827,
        GIR_Done,
      // Label 677: @22769
      GIM_Try, /*On fail goto*//*Label 678*/ GIMT_Encode4(22796), // Rule ID 18545 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPXORYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18545,
        GIR_Done,
      // Label 678: @22796
      GIM_Try, /*On fail goto*//*Label 679*/ GIMT_Encode4(22823), // Rule ID 18571 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VXORPSYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18571,
        GIR_Done,
      // Label 679: @22823
      GIM_Reject,
    // Label 674: @22824
    GIM_Reject,
    // Label 569: @22825
    GIM_Try, /*On fail goto*//*Label 680*/ GIMT_Encode4(22902),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 681*/ GIMT_Encode4(22882), // Rule ID 22389 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src, immAllOnesV:{ *:[v8i64] })  =>  (VPTERNLOGQZrri:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src, VR512:{ *:[v8i64] }:$src, VR512:{ *:[v8i64] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22389,
        GIR_EraseRootFromParent_Done,
      // Label 681: @22882
      GIM_Try, /*On fail goto*//*Label 682*/ GIMT_Encode4(22901), // Rule ID 5791 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VPXORQZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5791,
        GIR_Done,
      // Label 682: @22901
      GIM_Reject,
    // Label 680: @22902
    GIM_Reject,
    // Label 570: @22903
    GIM_Try, /*On fail goto*//*Label 683*/ GIMT_Encode4(23160),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_Try, /*On fail goto*//*Label 684*/ GIMT_Encode4(22978), // Rule ID 24110 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }), VK16:{ *:[v16i1] }:$src2)  =>  (KXNORWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24110,
        GIR_EraseRootFromParent_Done,
      // Label 684: @22978
      GIM_Try, /*On fail goto*//*Label 685*/ GIMT_Encode4(23041), // Rule ID 4421 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v16i1] } (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2), immAllOnesV:{ *:[v16i1] })  =>  (KXNORWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4421,
        GIR_EraseRootFromParent_Done,
      // Label 685: @23041
      GIM_Try, /*On fail goto*//*Label 686*/ GIMT_Encode4(23101), // Rule ID 24111 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src2, (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, immAllOnesV:{ *:[v16i1] }))  =>  (KXNORWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORWkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24111,
        GIR_EraseRootFromParent_Done,
      // Label 686: @23101
      GIM_Try, /*On fail goto*//*Label 687*/ GIMT_Encode4(23136), // Rule ID 4409 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src, immAllOnesV:{ *:[v16i1] })  =>  (KNOTWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTWkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4409,
        GIR_EraseRootFromParent_Done,
      // Label 687: @23136
      GIM_Try, /*On fail goto*//*Label 688*/ GIMT_Encode4(23159), // Rule ID 4425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        // (xor:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KXORWkk:{ *:[v16i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORWkk),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4425,
        GIR_Done,
      // Label 688: @23159
      GIM_Reject,
    // Label 683: @23160
    GIM_Reject,
    // Label 571: @23161
    GIM_Try, /*On fail goto*//*Label 689*/ GIMT_Encode4(23532),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
      GIM_Try, /*On fail goto*//*Label 690*/ GIMT_Encode4(23404), // Rule ID 22390 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src, immAllOnesV:{ *:[v16i8] })  =>  (EXTRACT_SUBREG:{ *:[v16i8] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v16i8] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v16i8] }:$src, sub_xmm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR128X:{ *:[v16i8] }:$src, sub_xmm:{ *:[i32] }), 15:{ *:[i8] }), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/11,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR128XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 22390,
        GIR_EraseRootFromParent_Done,
      // Label 690: @23404
      GIM_Try, /*On fail goto*//*Label 691*/ GIMT_Encode4(23450), // Rule ID 22398 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src, immAllOnesV:{ *:[v16i8] })  =>  (VPTERNLOGQZ128rri:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src, VR128X:{ *:[v16i8] }:$src, VR128X:{ *:[v16i8] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22398,
        GIR_EraseRootFromParent_Done,
      // Label 691: @23450
      GIM_Try, /*On fail goto*//*Label 692*/ GIMT_Encode4(23477), // Rule ID 18599 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPXORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18599,
        GIR_Done,
      // Label 692: @23477
      GIM_Try, /*On fail goto*//*Label 693*/ GIMT_Encode4(23504), // Rule ID 18623 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (xor:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PXORrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::PXORrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18623,
        GIR_Done,
      // Label 693: @23504
      GIM_Try, /*On fail goto*//*Label 694*/ GIMT_Encode4(23531), // Rule ID 20467 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (xor:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)  =>  (VPXORQZ128rr:{ *:[v16i8] } VR128X:{ *:[v16i8] }:$src1, VR128X:{ *:[v16i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ128rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20467,
        GIR_Done,
      // Label 694: @23531
      GIM_Reject,
    // Label 689: @23532
    GIM_Reject,
    // Label 572: @23533
    GIM_Try, /*On fail goto*//*Label 695*/ GIMT_Encode4(23904),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
      GIM_Try, /*On fail goto*//*Label 696*/ GIMT_Encode4(23776), // Rule ID 22395 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src, immAllOnesV:{ *:[v16i16] })  =>  (EXTRACT_SUBREG:{ *:[v16i16] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 22395,
        GIR_EraseRootFromParent_Done,
      // Label 696: @23776
      GIM_Try, /*On fail goto*//*Label 697*/ GIMT_Encode4(23822), // Rule ID 22403 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src, immAllOnesV:{ *:[v16i16] })  =>  (VPTERNLOGQZ256rri:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src, VR256X:{ *:[v16i16] }:$src, VR256X:{ *:[v16i16] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22403,
        GIR_EraseRootFromParent_Done,
      // Label 697: @23822
      GIM_Try, /*On fail goto*//*Label 698*/ GIMT_Encode4(23849), // Rule ID 18544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPXORYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18544,
        GIR_Done,
      // Label 698: @23849
      GIM_Try, /*On fail goto*//*Label 699*/ GIMT_Encode4(23876), // Rule ID 18570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VXORPSYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18570,
        GIR_Done,
      // Label 699: @23876
      GIM_Try, /*On fail goto*//*Label 700*/ GIMT_Encode4(23903), // Rule ID 20484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)  =>  (VPXORQZ256rr:{ *:[v16i16] } VR256X:{ *:[v16i16] }:$src1, VR256X:{ *:[v16i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20484,
        GIR_Done,
      // Label 700: @23903
      GIM_Reject,
    // Label 695: @23904
    GIM_Reject,
    // Label 573: @23905
    GIM_Try, /*On fail goto*//*Label 701*/ GIMT_Encode4(23982),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 702*/ GIMT_Encode4(23962), // Rule ID 22388 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src, immAllOnesV:{ *:[v16i32] })  =>  (VPTERNLOGQZrri:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src, VR512:{ *:[v16i32] }:$src, VR512:{ *:[v16i32] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22388,
        GIR_EraseRootFromParent_Done,
      // Label 702: @23962
      GIM_Try, /*On fail goto*//*Label 703*/ GIMT_Encode4(23981), // Rule ID 5818 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VPXORDZrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORDZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 5818,
        GIR_Done,
      // Label 703: @23981
      GIM_Reject,
    // Label 701: @23982
    GIM_Reject,
    // Label 574: @23983
    GIM_Try, /*On fail goto*//*Label 704*/ GIMT_Encode4(24240),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_Try, /*On fail goto*//*Label 705*/ GIMT_Encode4(24058), // Rule ID 24112 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }), VK32:{ *:[v32i1] }:$src2)  =>  (KXNORDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORDkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24112,
        GIR_EraseRootFromParent_Done,
      // Label 705: @24058
      GIM_Try, /*On fail goto*//*Label 706*/ GIMT_Encode4(24121), // Rule ID 4422 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v32i1] } (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2), immAllOnesV:{ *:[v32i1] })  =>  (KXNORDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORDkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4422,
        GIR_EraseRootFromParent_Done,
      // Label 706: @24121
      GIM_Try, /*On fail goto*//*Label 707*/ GIMT_Encode4(24181), // Rule ID 24113 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src2, (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, immAllOnesV:{ *:[v32i1] }))  =>  (KXNORDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORDkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24113,
        GIR_EraseRootFromParent_Done,
      // Label 707: @24181
      GIM_Try, /*On fail goto*//*Label 708*/ GIMT_Encode4(24216), // Rule ID 4410 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src, immAllOnesV:{ *:[v32i1] })  =>  (KNOTDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTDkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4410,
        GIR_EraseRootFromParent_Done,
      // Label 708: @24216
      GIM_Try, /*On fail goto*//*Label 709*/ GIMT_Encode4(24239), // Rule ID 4426 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        // (xor:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KXORDkk:{ *:[v32i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORDkk),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4426,
        GIR_Done,
      // Label 709: @24239
      GIM_Reject,
    // Label 704: @24240
    GIM_Reject,
    // Label 575: @24241
    GIM_Try, /*On fail goto*//*Label 710*/ GIMT_Encode4(24612),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
      GIM_Try, /*On fail goto*//*Label 711*/ GIMT_Encode4(24484), // Rule ID 22394 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src, immAllOnesV:{ *:[v32i8] })  =>  (EXTRACT_SUBREG:{ *:[v32i8] } (VPTERNLOGQZrri:{ *:[v64i8] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v32i8] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v32i8] }:$src, sub_ymm:{ *:[i32] }), (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v32i8] }:$src, sub_ymm:{ *:[i32] }), 15:{ *:[i8] }), sub_ymm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/6, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/7, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/7, /*TempRegID*/6, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/7,
        GIR_MakeTempReg, /*TempRegID*/5, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/6, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/6, /*TempRegID*/5, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/6, /*TempRegID*/6,
        GIR_Copy, /*NewInsnID*/6, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/6, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/6, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/4, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/5, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/5, /*TempRegID*/4, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/5,
        GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/4, /*TempRegID*/4,
        GIR_Copy, /*NewInsnID*/4, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/4, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/4, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v64s8,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/3,
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/5,
        GIR_AddImm8, /*InsnID*/1, /*Imm*/15,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_ymm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        // GIR_Coverage, 22394,
        GIR_EraseRootFromParent_Done,
      // Label 711: @24484
      GIM_Try, /*On fail goto*//*Label 712*/ GIMT_Encode4(24530), // Rule ID 22402 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src, immAllOnesV:{ *:[v32i8] })  =>  (VPTERNLOGQZ256rri:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src, VR256X:{ *:[v32i8] }:$src, VR256X:{ *:[v32i8] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22402,
        GIR_EraseRootFromParent_Done,
      // Label 712: @24530
      GIM_Try, /*On fail goto*//*Label 713*/ GIMT_Encode4(24557), // Rule ID 18543 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPXORYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18543,
        GIR_Done,
      // Label 713: @24557
      GIM_Try, /*On fail goto*//*Label 714*/ GIMT_Encode4(24584), // Rule ID 18569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX1Only),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (xor:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VXORPSYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VXORPSYrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18569,
        GIR_Done,
      // Label 714: @24584
      GIM_Try, /*On fail goto*//*Label 715*/ GIMT_Encode4(24611), // Rule ID 20483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (xor:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)  =>  (VPXORQZ256rr:{ *:[v32i8] } VR256X:{ *:[v32i8] }:$src1, VR256X:{ *:[v32i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20483,
        GIR_Done,
      // Label 715: @24611
      GIM_Reject,
    // Label 710: @24612
    GIM_Reject,
    // Label 576: @24613
    GIM_Try, /*On fail goto*//*Label 716*/ GIMT_Encode4(24690),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s16,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 717*/ GIMT_Encode4(24670), // Rule ID 22387 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src, immAllOnesV:{ *:[v32i16] })  =>  (VPTERNLOGQZrri:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src, VR512:{ *:[v32i16] }:$src, VR512:{ *:[v32i16] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22387,
        GIR_EraseRootFromParent_Done,
      // Label 717: @24670
      GIM_Try, /*On fail goto*//*Label 718*/ GIMT_Encode4(24689), // Rule ID 20500 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)  =>  (VPXORQZrr:{ *:[v32i16] } VR512:{ *:[v32i16] }:$src1, VR512:{ *:[v32i16] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20500,
        GIR_Done,
      // Label 718: @24689
      GIM_Reject,
    // Label 716: @24690
    GIM_Reject,
    // Label 577: @24691
    GIM_Try, /*On fail goto*//*Label 719*/ GIMT_Encode4(24948),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_Try, /*On fail goto*//*Label 720*/ GIMT_Encode4(24766), // Rule ID 24114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }), VK64:{ *:[v64i1] }:$src2)  =>  (KXNORQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORQkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24114,
        GIR_EraseRootFromParent_Done,
      // Label 720: @24766
      GIM_Try, /*On fail goto*//*Label 721*/ GIMT_Encode4(24829), // Rule ID 4423 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/0, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v64i1] } (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2), immAllOnesV:{ *:[v64i1] })  =>  (KXNORQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORQkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4423,
        GIR_EraseRootFromParent_Done,
      // Label 721: @24829
      GIM_Try, /*On fail goto*//*Label 722*/ GIMT_Encode4(24889), // Rule ID 24115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
        GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v64s1,
        GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v64s1,
        GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/2, /*MI*/1, /*OpIdx*/2, // MIs[2]
        GIM_CheckOpcodeIsEither, /*MI*/2, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/2,
        GIM_CheckIsSafeToFold, /*NumInsns*/2,
        // (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src2, (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, immAllOnesV:{ *:[v64i1] }))  =>  (KXNORQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KXNORQkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/1, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 24115,
        GIR_EraseRootFromParent_Done,
      // Label 722: @24889
      GIM_Try, /*On fail goto*//*Label 723*/ GIMT_Encode4(24924), // Rule ID 4411 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src, immAllOnesV:{ *:[v64i1] })  =>  (KNOTQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KNOTQkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4411,
        GIR_EraseRootFromParent_Done,
      // Label 723: @24924
      GIM_Try, /*On fail goto*//*Label 724*/ GIMT_Encode4(24947), // Rule ID 4427 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        // (xor:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)  =>  (KXORQkk:{ *:[v64i1] } VK64:{ *:[v64i1] }:$src1, VK64:{ *:[v64i1] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::KXORQkk),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4427,
        GIR_Done,
      // Label 724: @24947
      GIM_Reject,
    // Label 719: @24948
    GIM_Reject,
    // Label 578: @24949
    GIM_Try, /*On fail goto*//*Label 725*/ GIMT_Encode4(25026),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s8,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v64s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_Try, /*On fail goto*//*Label 726*/ GIMT_Encode4(25006), // Rule ID 22386 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/2, // MIs[1]
        GIM_CheckOpcodeIsEither, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR), GIMT_Encode2(TargetOpcode::G_BUILD_VECTOR_TRUNC),
        GIM_CheckIsBuildVectorAllOnes, /*MI*/1,
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (xor:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src, immAllOnesV:{ *:[v64i8] })  =>  (VPTERNLOGQZrri:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src, VR512:{ *:[v64i8] }:$src, VR512:{ *:[v64i8] }:$src, 15:{ *:[i8] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPTERNLOGQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/0, /*Imm*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 22386,
        GIR_EraseRootFromParent_Done,
      // Label 726: @25006
      GIM_Try, /*On fail goto*//*Label 727*/ GIMT_Encode4(25025), // Rule ID 20499 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (xor:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)  =>  (VPXORQZrr:{ *:[v64i8] } VR512:{ *:[v64i8] }:$src1, VR512:{ *:[v64i8] }:$src2)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPXORQZrr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20499,
        GIR_Done,
      // Label 727: @25025
      GIM_Reject,
    // Label 725: @25026
    GIM_Reject,
    // Label 579: @25027
    GIM_Reject,
    // Label 6: @25028
    GIM_Try, /*On fail goto*//*Label 728*/ GIMT_Encode4(25194),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(16), GIMT_Encode2(24), /*)*//*default:*//*Label 732*/ GIMT_Encode4(25193),
      /*GILLT_v16s1*//*Label 729*/ GIMT_Encode4(25079), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v32s1*//*Label 730*/ GIMT_Encode4(25117), GIMT_Encode4(0), GIMT_Encode4(0),
      /*GILLT_v64s1*//*Label 731*/ GIMT_Encode4(25155),
      // Label 729: @25079
      GIM_Try, /*On fail goto*//*Label 733*/ GIMT_Encode4(25116), // Rule ID 19950 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
        // (concat_vectors:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src1, VK8:{ *:[v8i1] }:$src2)  =>  (KUNPCKBWkk:{ *:[v16i1] } VK8:{ *:[v8i1] }:$src2, VK8:{ *:[v8i1] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KUNPCKBWkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 19950,
        GIR_EraseRootFromParent_Done,
      // Label 733: @25116
      GIM_Reject,
      // Label 730: @25117
      GIM_Try, /*On fail goto*//*Label 734*/ GIMT_Encode4(25154), // Rule ID 19951 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
        // (concat_vectors:{ *:[v32i1] } VK16:{ *:[v16i1] }:$src1, VK16:{ *:[v16i1] }:$src2)  =>  (KUNPCKWDkk:{ *:[v32i1] } VK16:{ *:[v16i1] }:$src2, VK16:{ *:[v16i1] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KUNPCKWDkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 19951,
        GIR_EraseRootFromParent_Done,
      // Label 734: @25154
      GIM_Reject,
      // Label 731: @25155
      GIM_Try, /*On fail goto*//*Label 735*/ GIMT_Encode4(25192), // Rule ID 19952 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s1,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
        // (concat_vectors:{ *:[v64i1] } VK32:{ *:[v32i1] }:$src1, VK32:{ *:[v32i1] }:$src2)  =>  (KUNPCKDQkk:{ *:[v64i1] } VK32:{ *:[v32i1] }:$src2, VK32:{ *:[v32i1] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KUNPCKDQkk),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 19952,
        GIR_EraseRootFromParent_Done,
      // Label 735: @25192
      GIM_Reject,
      // Label 732: @25193
      GIM_Reject,
    // Label 728: @25194
    GIM_Reject,
    // Label 7: @25195
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(24), /*)*//*default:*//*Label 744*/ GIMT_Encode4(26951),
    /*GILLT_s8*//*Label 736*/ GIMT_Encode4(25298),
    /*GILLT_s16*//*Label 737*/ GIMT_Encode4(25359),
    /*GILLT_s32*//*Label 738*/ GIMT_Encode4(26189),
    /*GILLT_s64*//*Label 739*/ GIMT_Encode4(26417), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s1*//*Label 740*/ GIMT_Encode4(26645), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s1*//*Label 741*/ GIMT_Encode4(26727), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v32s1*//*Label 742*/ GIMT_Encode4(26809), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v64s1*//*Label 743*/ GIMT_Encode4(26880),
    // Label 736: @25298
    GIM_Try, /*On fail goto*//*Label 745*/ GIMT_Encode4(25358), // Rule ID 19881 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      // (bitconvert:{ *:[i8] } VK8:{ *:[v8i1] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i32] } VK8:{ *:[v8i1] }:$src, GR32:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 19881,
      GIR_EraseRootFromParent_Done,
    // Label 745: @25358
    GIM_Reject,
    // Label 737: @25359
    GIM_Try, /*On fail goto*//*Label 746*/ GIMT_Encode4(25419), // Rule ID 19878 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      // (bitconvert:{ *:[i16] } VK16:{ *:[v16i1] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (COPY_TO_REGCLASS:{ *:[i32] } VK16:{ *:[v16i1] }:$src, GR32:{ *:[i32] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 19878,
      GIR_EraseRootFromParent_Done,
    // Label 746: @25419
    GIM_Try, /*On fail goto*//*Label 747*/ GIMT_Encode4(25520), // Rule ID 22587 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (bitconvert:{ *:[f16] } GR16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (VMOVW2SHrr:{ *:[f128] } (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] })), FR16X:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/2, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVW2SHrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      // GIR_Coverage, 22587,
      GIR_EraseRootFromParent_Done,
    // Label 747: @25520
    GIM_Try, /*On fail goto*//*Label 748*/ GIMT_Encode4(25600), // Rule ID 22600 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFP16),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      // (bitconvert:{ *:[i16] } FR16X:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (VMOVSH2Wrr:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[f128] } FR16X:{ *:[f16] }:$src, VR128X:{ *:[i32] })), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR128XRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVSH2Wrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 22600,
      GIR_EraseRootFromParent_Done,
    // Label 748: @25600
    GIM_Try, /*On fail goto*//*Label 749*/ GIMT_Encode4(25679), // Rule ID 18787 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (bitconvert:{ *:[i16] } f16:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (VPEXTRWrri:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v8i16] } FR16:{ *:[f16] }:$src, VR128:{ *:[i32] }), 0:{ *:[i8] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR128RegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPEXTRWrri),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 18787,
      GIR_EraseRootFromParent_Done,
    // Label 749: @25679
    GIM_Try, /*On fail goto*//*Label 750*/ GIMT_Encode4(25796), // Rule ID 18788 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16RegClassID),
      // (bitconvert:{ *:[f16] } i16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (VPINSRWrri:{ *:[f128] } (IMPLICIT_DEF:{ *:[v8i16] }), (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), 0:{ *:[i8] }), FR16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/3, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPINSRWrri),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16RegClassID),
      // GIR_Coverage, 18788,
      GIR_EraseRootFromParent_Done,
    // Label 750: @25796
    GIM_Try, /*On fail goto*//*Label 751*/ GIMT_Encode4(25875), // Rule ID 18784 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (bitconvert:{ *:[i16] } f16:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (PEXTRWrri:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v8i16] } FR16:{ *:[f16] }:$src, VR128:{ *:[i32] }), 0:{ *:[i8] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR128RegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::PEXTRWrri),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 18784,
      GIR_EraseRootFromParent_Done,
    // Label 751: @25875
    GIM_Try, /*On fail goto*//*Label 752*/ GIMT_Encode4(25992), // Rule ID 18785 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16RegClassID),
      // (bitconvert:{ *:[f16] } i16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (PINSRWrri:{ *:[f128] } (IMPLICIT_DEF:{ *:[v8i16] }), (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), 0:{ *:[i8] }), FR16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/3, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::PINSRWrri),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16RegClassID),
      // GIR_Coverage, 18785,
      GIR_EraseRootFromParent_Done,
    // Label 752: @25992
    GIM_Try, /*On fail goto*//*Label 753*/ GIMT_Encode4(26071), // Rule ID 22288 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (bitconvert:{ *:[i16] } f16:{ *:[f16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (VPEXTRWZrri:{ *:[i32] } (COPY_TO_REGCLASS:{ *:[v8i16] } FR16X:{ *:[f16] }:$src, VR128X:{ *:[i32] }), 0:{ *:[i8] }), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR128XRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPEXTRWZrri),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 22288,
      GIR_EraseRootFromParent_Done,
    // Label 753: @26071
    GIM_Try, /*On fail goto*//*Label 754*/ GIMT_Encode4(26188), // Rule ID 22289 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      // (bitconvert:{ *:[f16] } i16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[f16] } (VPINSRWZrri:{ *:[f128] } (IMPLICIT_DEF:{ *:[v8i16] }), (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), 0:{ *:[i8] }), FR16X:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/3, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/4, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/4, /*TempRegID*/3, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/4,
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/3, /*TempRegID*/3,
      GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/3, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/3, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s128,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPINSRWZrri),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/2,
      GIR_AddImm8, /*InsnID*/1, /*Imm*/0,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      // GIR_Coverage, 22289,
      GIR_EraseRootFromParent_Done,
    // Label 754: @26188
    GIM_Reject,
    // Label 738: @26189
    GIM_Try, /*On fail goto*//*Label 755*/ GIMT_Encode4(26215), // Rule ID 2912 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[f32] } GR32:{ *:[i32] }:$src)  =>  (VMOVDI2SSrr:{ *:[f32] } GR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVDI2SSrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2912,
      GIR_Done,
    // Label 755: @26215
    GIM_Try, /*On fail goto*//*Label 756*/ GIMT_Encode4(26241), // Rule ID 2913 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[f32] } GR32:{ *:[i32] }:$src)  =>  (MOVDI2SSrr:{ *:[f32] } GR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVDI2SSrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2913,
      GIR_Done,
    // Label 756: @26241
    GIM_Try, /*On fail goto*//*Label 757*/ GIMT_Encode4(26267), // Rule ID 2922 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (bitconvert:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (VMOVSS2DIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSS2DIrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2922,
      GIR_Done,
    // Label 757: @26267
    GIM_Try, /*On fail goto*//*Label 758*/ GIMT_Encode4(26293), // Rule ID 2923 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (bitconvert:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (MOVSS2DIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVSS2DIrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2923,
      GIR_Done,
    // Label 758: @26293
    GIM_Try, /*On fail goto*//*Label 759*/ GIMT_Encode4(26319), // Rule ID 4595 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (bitconvert:{ *:[f32] } GR32:{ *:[i32] }:$src)  =>  (VMOVDI2SSZrr:{ *:[f32] } GR32:{ *:[i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVDI2SSZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4595,
      GIR_Done,
    // Label 759: @26319
    GIM_Try, /*On fail goto*//*Label 760*/ GIMT_Encode4(26345), // Rule ID 4600 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      // (bitconvert:{ *:[i32] } FR32X:{ *:[f32] }:$src)  =>  (VMOVSS2DIZrr:{ *:[i32] } FR32X:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSS2DIZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4600,
      GIR_Done,
    // Label 760: @26345
    GIM_Try, /*On fail goto*//*Label 761*/ GIMT_Encode4(26372), // Rule ID 19889 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      // (bitconvert:{ *:[i32] } VK32:{ *:[v32i1] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i32] } VK32:{ *:[v32i1] }:$src, GR32:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 19889,
      GIR_Done,
    // Label 761: @26372
    GIM_Try, /*On fail goto*//*Label 762*/ GIMT_Encode4(26416), // Rule ID 20323 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v32s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      // (bitconvert:{ *:[f32] } VK32:{ *:[v32i1] }:$src)  =>  (VMOVDI2SSZrr:{ *:[f32] } (KMOVDrk:{ *:[i32] } VK32:{ *:[v32i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KMOVDrk),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMOVDI2SSZrr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20323,
      GIR_EraseRootFromParent_Done,
    // Label 762: @26416
    GIM_Reject,
    // Label 739: @26417
    GIM_Try, /*On fail goto*//*Label 763*/ GIMT_Encode4(26443), // Rule ID 2907 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // (bitconvert:{ *:[f64] } GR64:{ *:[i64] }:$src)  =>  (VMOV64toSDrr:{ *:[f64] } GR64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOV64toSDrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2907,
      GIR_Done,
    // Label 763: @26443
    GIM_Try, /*On fail goto*//*Label 764*/ GIMT_Encode4(26469), // Rule ID 2911 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // (bitconvert:{ *:[f64] } GR64:{ *:[i64] }:$src)  =>  (MOV64toSDrr:{ *:[f64] } GR64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOV64toSDrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2911,
      GIR_Done,
    // Label 764: @26469
    GIM_Try, /*On fail goto*//*Label 765*/ GIMT_Encode4(26495), // Rule ID 2920 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (bitconvert:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VMOVSDto64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSDto64rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2920,
      GIR_Done,
    // Label 765: @26495
    GIM_Try, /*On fail goto*//*Label 766*/ GIMT_Encode4(26521), // Rule ID 2921 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (bitconvert:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (MOVSDto64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVSDto64rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 2921,
      GIR_Done,
    // Label 766: @26521
    GIM_Try, /*On fail goto*//*Label 767*/ GIMT_Encode4(26547), // Rule ID 4593 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      // (bitconvert:{ *:[f64] } GR64:{ *:[i64] }:$src)  =>  (VMOV64toSDZrr:{ *:[f64] } GR64:{ *:[i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOV64toSDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4593,
      GIR_Done,
    // Label 767: @26547
    GIM_Try, /*On fail goto*//*Label 768*/ GIMT_Encode4(26573), // Rule ID 4594 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      // (bitconvert:{ *:[i64] } FR64X:{ *:[f64] }:$src)  =>  (VMOVSDto64Zrr:{ *:[i64] } FR64X:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VMOVSDto64Zrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 4594,
      GIR_Done,
    // Label 768: @26573
    GIM_Try, /*On fail goto*//*Label 769*/ GIMT_Encode4(26600), // Rule ID 19891 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      // (bitconvert:{ *:[i64] } VK64:{ *:[v64i1] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[i64] } VK64:{ *:[v64i1] }:$src, GR64:{ *:[i32] })
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      // GIR_Coverage, 19891,
      GIR_Done,
    // Label 769: @26600
    GIM_Try, /*On fail goto*//*Label 770*/ GIMT_Encode4(26644), // Rule ID 20325 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v64s1,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      // (bitconvert:{ *:[f64] } VK64:{ *:[v64i1] }:$src)  =>  (VMOV64toSDZrr:{ *:[f64] } (KMOVQrk:{ *:[i64] } VK64:{ *:[v64i1] }:$src))
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::KMOVQrk),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMOV64toSDZrr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 20325,
      GIR_EraseRootFromParent_Done,
    // Label 770: @26644
    GIM_Reject,
    // Label 740: @26645
    GIM_Try, /*On fail goto*//*Label 771*/ GIMT_Encode4(26726), // Rule ID 19880 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (bitconvert:{ *:[v8i1] } GR8:{ *:[i8] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v8i1] } (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR8:{ *:[i8] }:$src, sub_8bit:{ *:[i32] }), VK8:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/1, /*Imm*/1,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBP_with_sub_8bitRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR8RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK8RegClassID),
      // GIR_Coverage, 19880,
      GIR_EraseRootFromParent_Done,
    // Label 771: @26726
    GIM_Reject,
    // Label 741: @26727
    GIM_Try, /*On fail goto*//*Label 772*/ GIMT_Encode4(26808), // Rule ID 19877 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (bitconvert:{ *:[v16i1] } GR16:{ *:[i16] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v16i1] } (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] }), VK16:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/2,
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/1, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK16RegClassID),
      // GIR_Coverage, 19877,
      GIR_EraseRootFromParent_Done,
    // Label 772: @26808
    GIM_Reject,
    // Label 742: @26809
    GIM_Try, /*On fail goto*//*Label 773*/ GIMT_Encode4(26879),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK32RegClassID),
      GIM_Try, /*On fail goto*//*Label 774*/ GIMT_Encode4(26841), // Rule ID 19888 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (bitconvert:{ *:[v32i1] } GR32:{ *:[i32] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v32i1] } GR32:{ *:[i32] }:$src, VK32:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK32RegClassID),
        // GIR_Coverage, 19888,
        GIR_Done,
      // Label 774: @26841
      GIM_Try, /*On fail goto*//*Label 775*/ GIMT_Encode4(26878), // Rule ID 20322 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
        // (bitconvert:{ *:[v32i1] } FR32X:{ *:[f32] }:$src)  =>  (KMOVDkr:{ *:[v32i1] } (VMOVSS2DIZrr:{ *:[i32] } FR32X:{ *:[f32] }:$src))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVSS2DIZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KMOVDkr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20322,
        GIR_EraseRootFromParent_Done,
      // Label 775: @26878
      GIM_Reject,
    // Label 773: @26879
    GIM_Reject,
    // Label 743: @26880
    GIM_Try, /*On fail goto*//*Label 776*/ GIMT_Encode4(26950),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VK64RegClassID),
      GIM_Try, /*On fail goto*//*Label 777*/ GIMT_Encode4(26912), // Rule ID 19890 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (bitconvert:{ *:[v64i1] } GR64:{ *:[i64] }:$src)  =>  (COPY_TO_REGCLASS:{ *:[v64i1] } GR64:{ *:[i64] }:$src, VK64:{ *:[i32] })
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::VK64RegClassID),
        // GIR_Coverage, 19890,
        GIR_Done,
      // Label 777: @26912
      GIM_Try, /*On fail goto*//*Label 778*/ GIMT_Encode4(26949), // Rule ID 20324 //
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
        // (bitconvert:{ *:[v64i1] } FR64X:{ *:[f64] }:$src)  =>  (KMOVQkr:{ *:[v64i1] } (VMOVSDto64Zrr:{ *:[i64] } FR64X:{ *:[f64] }:$src))
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VMOVSDto64Zrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::KMOVQkr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 20324,
        GIR_EraseRootFromParent_Done,
      // Label 778: @26949
      GIM_Reject,
    // Label 776: @26950
    GIM_Reject,
    // Label 744: @26951
    GIM_Reject,
    // Label 8: @26952
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(3), GIMT_Encode2(20), /*)*//*default:*//*Label 787*/ GIMT_Encode4(27813),
    /*GILLT_s32*//*Label 779*/ GIMT_Encode4(27031),
    /*GILLT_s64*//*Label 780*/ GIMT_Encode4(27212), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 781*/ GIMT_Encode4(27393), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 782*/ GIMT_Encode4(27424),
    /*GILLT_v4s64*//*Label 783*/ GIMT_Encode4(27575), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s32*//*Label 784*/ GIMT_Encode4(27636),
    /*GILLT_v8s64*//*Label 785*/ GIMT_Encode4(27724), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s32*//*Label 786*/ GIMT_Encode4(27785),
    // Label 779: @27031
    GIM_Try, /*On fail goto*//*Label 788*/ GIMT_Encode4(27061), // Rule ID 1752 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1752,
      GIR_Done,
    // Label 788: @27061
    GIM_Try, /*On fail goto*//*Label 789*/ GIMT_Encode4(27091), // Rule ID 1756 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i32] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SIrr:{ *:[i32] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1756,
      GIR_Done,
    // Label 789: @27091
    GIM_Try, /*On fail goto*//*Label 790*/ GIMT_Encode4(27121), // Rule ID 1776 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i32] } FR32:{ *:[f32] }:$src)  =>  (CVTSS2SIrr:{ *:[i32] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSS2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1776,
      GIR_Done,
    // Label 790: @27121
    GIM_Try, /*On fail goto*//*Label 791*/ GIMT_Encode4(27151), // Rule ID 1780 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i32] } FR64:{ *:[f64] }:$src)  =>  (CVTSD2SIrr:{ *:[i32] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSD2SIrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1780,
      GIR_Done,
    // Label 791: @27151
    GIM_Try, /*On fail goto*//*Label 792*/ GIMT_Encode4(27181), // Rule ID 10349 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      // (lrint:{ *:[i32] } FR32X:{ *:[f32] }:$src)  =>  (VCVTSS2SIZrr:{ *:[i32] } FR32X:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SIZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10349,
      GIR_Done,
    // Label 792: @27181
    GIM_Try, /*On fail goto*//*Label 793*/ GIMT_Encode4(27211), // Rule ID 10353 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      // (lrint:{ *:[i32] } FR64X:{ *:[f64] }:$src)  =>  (VCVTSD2SIZrr:{ *:[i32] } FR64X:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SIZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10353,
      GIR_Done,
    // Label 793: @27211
    GIM_Reject,
    // Label 780: @27212
    GIM_Try, /*On fail goto*//*Label 794*/ GIMT_Encode4(27242), // Rule ID 18436 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18436,
      GIR_Done,
    // Label 794: @27242
    GIM_Try, /*On fail goto*//*Label 795*/ GIMT_Encode4(27272), // Rule ID 18438 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18438,
      GIR_Done,
    // Label 795: @27272
    GIM_Try, /*On fail goto*//*Label 796*/ GIMT_Encode4(27302), // Rule ID 18440 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (CVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18440,
      GIR_Done,
    // Label 796: @27302
    GIM_Try, /*On fail goto*//*Label 797*/ GIMT_Encode4(27332), // Rule ID 18442 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (CVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18442,
      GIR_Done,
    // Label 797: @27332
    GIM_Try, /*On fail goto*//*Label 798*/ GIMT_Encode4(27362), // Rule ID 21606 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (lrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SI64Zrr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21606,
      GIR_Done,
    // Label 798: @27362
    GIM_Try, /*On fail goto*//*Label 799*/ GIMT_Encode4(27392), // Rule ID 21608 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (lrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SI64Zrr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21608,
      GIR_Done,
    // Label 799: @27392
    GIM_Reject,
    // Label 781: @27393
    GIM_Try, /*On fail goto*//*Label 800*/ GIMT_Encode4(27423), // Rule ID 21831 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (lrint:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)  =>  (VCVTPD2QQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ128rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21831,
      GIR_Done,
    // Label 800: @27423
    GIM_Reject,
    // Label 782: @27424
    GIM_Try, /*On fail goto*//*Label 801*/ GIMT_Encode4(27454), // Rule ID 18490 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      // (lrint:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)  =>  (VCVTPS2DQrr:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18490,
      GIR_Done,
    // Label 801: @27454
    GIM_Try, /*On fail goto*//*Label 802*/ GIMT_Encode4(27484), // Rule ID 18494 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
      // (lrint:{ *:[v4i32] } VR256:{ *:[v4f64] }:$src)  =>  (VCVTPD2DQYrr:{ *:[v4i32] } VR256:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2DQYrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18494,
      GIR_Done,
    // Label 802: @27484
    GIM_Try, /*On fail goto*//*Label 803*/ GIMT_Encode4(27514), // Rule ID 18496 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      // (lrint:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)  =>  (CVTPS2DQrr:{ *:[v4i32] } VR128:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTPS2DQrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18496,
      GIR_Done,
    // Label 803: @27514
    GIM_Try, /*On fail goto*//*Label 804*/ GIMT_Encode4(27544), // Rule ID 21803 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (lrint:{ *:[v4i32] } VR128X:{ *:[v4f32] }:$src)  =>  (VCVTPS2DQZ128rr:{ *:[v4i32] } VR128X:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQZ128rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21803,
      GIR_Done,
    // Label 804: @27544
    GIM_Try, /*On fail goto*//*Label 805*/ GIMT_Encode4(27574), // Rule ID 21807 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v4i32] } VR256X:{ *:[v4f64] }:$src)  =>  (VCVTPD2DQZ256rr:{ *:[v4i32] } VR256X:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2DQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21807,
      GIR_Done,
    // Label 805: @27574
    GIM_Reject,
    // Label 783: @27575
    GIM_Try, /*On fail goto*//*Label 806*/ GIMT_Encode4(27605), // Rule ID 21827 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (lrint:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)  =>  (VCVTPS2QQZ256rr:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21827,
      GIR_Done,
    // Label 806: @27605
    GIM_Try, /*On fail goto*//*Label 807*/ GIMT_Encode4(27635), // Rule ID 21833 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)  =>  (VCVTPD2QQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21833,
      GIR_Done,
    // Label 807: @27635
    GIM_Reject,
    // Label 784: @27636
    GIM_Try, /*On fail goto*//*Label 808*/ GIMT_Encode4(27666), // Rule ID 18492 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
      // (lrint:{ *:[v8i32] } VR256:{ *:[v8f32] }:$src)  =>  (VCVTPS2DQYrr:{ *:[v8i32] } VR256:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQYrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 18492,
      GIR_Done,
    // Label 808: @27666
    GIM_Try, /*On fail goto*//*Label 809*/ GIMT_Encode4(27696), // Rule ID 21805 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v8i32] } VR256X:{ *:[v8f32] }:$src)  =>  (VCVTPS2DQZ256rr:{ *:[v8i32] } VR256X:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21805,
      GIR_Done,
    // Label 809: @27696
    GIM_Try, /*On fail goto*//*Label 810*/ GIMT_Encode4(27723), // Rule ID 21811 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (lrint:{ *:[v8i32] } VR512:{ *:[v8f64] }:$src)  =>  (VCVTPD2DQZrr:{ *:[v8i32] } VR512:{ *:[v8f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2DQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21811,
      GIR_Done,
    // Label 810: @27723
    GIM_Reject,
    // Label 785: @27724
    GIM_Try, /*On fail goto*//*Label 811*/ GIMT_Encode4(27754), // Rule ID 21839 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (lrint:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)  =>  (VCVTPS2QQZrr:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21839,
      GIR_Done,
    // Label 811: @27754
    GIM_Try, /*On fail goto*//*Label 812*/ GIMT_Encode4(27784), // Rule ID 21843 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (lrint:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)  =>  (VCVTPD2QQZrr:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21843,
      GIR_Done,
    // Label 812: @27784
    GIM_Reject,
    // Label 786: @27785
    GIM_Try, /*On fail goto*//*Label 813*/ GIMT_Encode4(27812), // Rule ID 21809 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (lrint:{ *:[v16i32] } VR512:{ *:[v16f32] }:$src)  =>  (VCVTPS2DQZrr:{ *:[v16i32] } VR512:{ *:[v16f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2DQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21809,
      GIR_Done,
    // Label 813: @27812
    GIM_Reject,
    // Label 787: @27813
    GIM_Reject,
    // Label 9: @27814
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(4), GIMT_Encode2(16), /*)*//*default:*//*Label 818*/ GIMT_Encode4(28207),
    /*GILLT_s64*//*Label 814*/ GIMT_Encode4(27873), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v2s64*//*Label 815*/ GIMT_Encode4(28054), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s64*//*Label 816*/ GIMT_Encode4(28085), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s64*//*Label 817*/ GIMT_Encode4(28146),
    // Label 814: @27873
    GIM_Try, /*On fail goto*//*Label 819*/ GIMT_Encode4(27903), // Rule ID 1754 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (llrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (VCVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1754,
      GIR_Done,
    // Label 819: @27903
    GIM_Try, /*On fail goto*//*Label 820*/ GIMT_Encode4(27933), // Rule ID 1758 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseAVX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (llrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (VCVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1758,
      GIR_Done,
    // Label 820: @27933
    GIM_Try, /*On fail goto*//*Label 821*/ GIMT_Encode4(27963), // Rule ID 1778 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32RegClassID),
      // (llrint:{ *:[i64] } FR32:{ *:[f32] }:$src)  =>  (CVTSS2SI64rr:{ *:[i64] } FR32:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSS2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1778,
      GIR_Done,
    // Label 821: @27963
    GIM_Try, /*On fail goto*//*Label 822*/ GIMT_Encode4(27993), // Rule ID 1782 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64RegClassID),
      // (llrint:{ *:[i64] } FR64:{ *:[f64] }:$src)  =>  (CVTSD2SI64rr:{ *:[i64] } FR64:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::CVTSD2SI64rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 1782,
      GIR_Done,
    // Label 822: @27993
    GIM_Try, /*On fail goto*//*Label 823*/ GIMT_Encode4(28023), // Rule ID 10351 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR32XRegClassID),
      // (llrint:{ *:[i64] } FR32X:{ *:[f32] }:$src)  =>  (VCVTSS2SI64Zrr:{ *:[i64] } FR32X:{ *:[f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSS2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10351,
      GIR_Done,
    // Label 823: @28023
    GIM_Try, /*On fail goto*//*Label 824*/ GIMT_Encode4(28053), // Rule ID 10355 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::FR64XRegClassID),
      // (llrint:{ *:[i64] } FR64X:{ *:[f64] }:$src)  =>  (VCVTSD2SI64Zrr:{ *:[i64] } FR64X:{ *:[f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTSD2SI64Zrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 10355,
      GIR_Done,
    // Label 824: @28053
    GIM_Reject,
    // Label 815: @28054
    GIM_Try, /*On fail goto*//*Label 825*/ GIMT_Encode4(28084), // Rule ID 21835 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (llrint:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)  =>  (VCVTPD2QQZ128rr:{ *:[v2i64] } VR128X:{ *:[v2f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ128rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21835,
      GIR_Done,
    // Label 825: @28084
    GIM_Reject,
    // Label 816: @28085
    GIM_Try, /*On fail goto*//*Label 826*/ GIMT_Encode4(28115), // Rule ID 21829 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      // (llrint:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)  =>  (VCVTPS2QQZ256rr:{ *:[v4i64] } VR128X:{ *:[v4f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21829,
      GIR_Done,
    // Label 826: @28115
    GIM_Try, /*On fail goto*//*Label 827*/ GIMT_Encode4(28145), // Rule ID 21837 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (llrint:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)  =>  (VCVTPD2QQZ256rr:{ *:[v4i64] } VR256X:{ *:[v4f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZ256rr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21837,
      GIR_Done,
    // Label 827: @28145
    GIM_Reject,
    // Label 817: @28146
    GIM_Try, /*On fail goto*//*Label 828*/ GIMT_Encode4(28176), // Rule ID 21841 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (llrint:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)  =>  (VCVTPS2QQZrr:{ *:[v8i64] } VR256X:{ *:[v8f32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPS2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21841,
      GIR_Done,
    // Label 828: @28176
    GIM_Try, /*On fail goto*//*Label 829*/ GIMT_Encode4(28206), // Rule ID 21845 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasDQI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (llrint:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)  =>  (VCVTPD2QQZrr:{ *:[v8i64] } VR512:{ *:[v8f64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VCVTPD2QQZrr),
      GIR_AddImplicitUse, /*InsnID*/0, GIMT_Encode2(X86::MXCSR),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 21845,
      GIR_Done,
    // Label 829: @28206
    GIM_Reject,
    // Label 818: @28207
    GIM_Reject,
    // Label 10: @28208
    GIM_Try, /*On fail goto*//*Label 830*/ GIMT_Encode4(29197),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 831*/ GIMT_Encode4(28252), // Rule ID 1526 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphsubwd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14730:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHSUBWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1526,
        GIR_EraseRootFromParent_Done,
      // Label 831: @28252
      GIM_Try, /*On fail goto*//*Label 832*/ GIMT_Encode4(28288), // Rule ID 1528 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphsubdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14729:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src)  =>  (VPHSUBDQrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1528,
        GIR_EraseRootFromParent_Done,
      // Label 832: @28288
      GIM_Try, /*On fail goto*//*Label 833*/ GIMT_Encode4(28324), // Rule ID 1530 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphsubbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14728:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHSUBBWrr:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1530,
        GIR_EraseRootFromParent_Done,
      // Label 833: @28324
      GIM_Try, /*On fail goto*//*Label 834*/ GIMT_Encode4(28360), // Rule ID 1532 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddwq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14727:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDWQrr:{ *:[v2i64] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDWQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1532,
        GIR_EraseRootFromParent_Done,
      // Label 834: @28360
      GIM_Try, /*On fail goto*//*Label 835*/ GIMT_Encode4(28396), // Rule ID 1534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddwd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14726:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1534,
        GIR_EraseRootFromParent_Done,
      // Label 835: @28396
      GIM_Try, /*On fail goto*//*Label 836*/ GIMT_Encode4(28432), // Rule ID 1536 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphadduwq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14725:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDUWQrr:{ *:[v2i64] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUWQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1536,
        GIR_EraseRootFromParent_Done,
      // Label 836: @28432
      GIM_Try, /*On fail goto*//*Label 837*/ GIMT_Encode4(28468), // Rule ID 1538 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphadduwd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14724:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src)  =>  (VPHADDUWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1538,
        GIR_EraseRootFromParent_Done,
      // Label 837: @28468
      GIM_Try, /*On fail goto*//*Label 838*/ GIMT_Encode4(28504), // Rule ID 1540 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddudq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14723:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src)  =>  (VPHADDUDQrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1540,
        GIR_EraseRootFromParent_Done,
      // Label 838: @28504
      GIM_Try, /*On fail goto*//*Label 839*/ GIMT_Encode4(28540), // Rule ID 1542 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddubw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14722:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDUBWrr:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1542,
        GIR_EraseRootFromParent_Done,
      // Label 839: @28540
      GIM_Try, /*On fail goto*//*Label 840*/ GIMT_Encode4(28576), // Rule ID 1544 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddubq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14721:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDUBQrr:{ *:[v2i64] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUBQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1544,
        GIR_EraseRootFromParent_Done,
      // Label 840: @28576
      GIM_Try, /*On fail goto*//*Label 841*/ GIMT_Encode4(28612), // Rule ID 1546 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddubd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14720:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDUBDrr:{ *:[v4i32] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDUBDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1546,
        GIR_EraseRootFromParent_Done,
      // Label 841: @28612
      GIM_Try, /*On fail goto*//*Label 842*/ GIMT_Encode4(28648), // Rule ID 1548 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphadddq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14719:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src)  =>  (VPHADDDQrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDDQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1548,
        GIR_EraseRootFromParent_Done,
      // Label 842: @28648
      GIM_Try, /*On fail goto*//*Label 843*/ GIMT_Encode4(28684), // Rule ID 1550 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddbw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14718:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDBWrr:{ *:[v8i16] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDBWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1550,
        GIR_EraseRootFromParent_Done,
      // Label 843: @28684
      GIM_Try, /*On fail goto*//*Label 844*/ GIMT_Encode4(28720), // Rule ID 1552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddbq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14717:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDBQrr:{ *:[v2i64] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDBQrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1552,
        GIR_EraseRootFromParent_Done,
      // Label 844: @28720
      GIM_Try, /*On fail goto*//*Label 845*/ GIMT_Encode4(28756), // Rule ID 1554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vphaddbd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14716:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src)  =>  (VPHADDBDrr:{ *:[v4i32] } VR128:{ *:[v16i8] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDBDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1554,
        GIR_EraseRootFromParent_Done,
      // Label 845: @28756
      GIM_Try, /*On fail goto*//*Label 846*/ GIMT_Encode4(28792), // Rule ID 1556 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 14711:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VFRCZSSrr:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZSSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1556,
        GIR_EraseRootFromParent_Done,
      // Label 846: @28792
      GIM_Try, /*On fail goto*//*Label 847*/ GIMT_Encode4(28828), // Rule ID 1560 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_ps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 14708:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VFRCZPSrr:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPSrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1560,
        GIR_EraseRootFromParent_Done,
      // Label 847: @28828
      GIM_Try, /*On fail goto*//*Label 848*/ GIMT_Encode4(28864), // Rule ID 1562 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_ps_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8f32] } 14709:{ *:[iPTR] }, VR256:{ *:[v8f32] }:$src)  =>  (VFRCZPSYrr:{ *:[v8f32] } VR256:{ *:[v8f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPSYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1562,
        GIR_EraseRootFromParent_Done,
      // Label 848: @28864
      GIM_Try, /*On fail goto*//*Label 849*/ GIMT_Encode4(28900), // Rule ID 1564 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_sd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 14710:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src)  =>  (VFRCZSDrr:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZSDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1564,
        GIR_EraseRootFromParent_Done,
      // Label 849: @28900
      GIM_Try, /*On fail goto*//*Label 850*/ GIMT_Encode4(28936), // Rule ID 1568 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_pd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2f64] } 14706:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src)  =>  (VFRCZPDrr:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1568,
        GIR_EraseRootFromParent_Done,
      // Label 850: @28936
      GIM_Try, /*On fail goto*//*Label 851*/ GIMT_Encode4(28972), // Rule ID 1570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vfrcz_pd_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f64] } 14707:{ *:[iPTR] }, VR256:{ *:[v4f64] }:$src)  =>  (VFRCZPDYrr:{ *:[v4f64] } VR256:{ *:[v4f64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VFRCZPDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1570,
        GIR_EraseRootFromParent_Done,
      // Label 851: @28972
      GIM_Try, /*On fail goto*//*Label 852*/ GIMT_Encode4(29008), // Rule ID 3360 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesimc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12992:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1)  =>  (VAESIMCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESIMCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3360,
        GIR_EraseRootFromParent_Done,
      // Label 852: @29008
      GIM_Try, /*On fail goto*//*Label 853*/ GIMT_Encode4(29044), // Rule ID 3362 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesimc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12992:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1)  =>  (AESIMCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESIMCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3362,
        GIR_EraseRootFromParent_Done,
      // Label 853: @29044
      GIM_Try, /*On fail goto*//*Label 854*/ GIMT_Encode4(29082), // Rule ID 18713 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rsqrt_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 14416:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (RSQRTSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RSQRTSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18713,
        GIR_EraseRootFromParent_Done,
      // Label 854: @29082
      GIM_Try, /*On fail goto*//*Label 855*/ GIMT_Encode4(29120), // Rule ID 18717 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rsqrt_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 14416:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VRSQRTSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VRSQRTSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18717,
        GIR_EraseRootFromParent_Done,
      // Label 855: @29120
      GIM_Try, /*On fail goto*//*Label 856*/ GIMT_Encode4(29158), // Rule ID 18733 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rcp_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 14414:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (RCPSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RCPSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18733,
        GIR_EraseRootFromParent_Done,
      // Label 856: @29158
      GIM_Try, /*On fail goto*//*Label 857*/ GIMT_Encode4(29196), // Rule ID 18737 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse_rcp_ss),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4f32] } 14414:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src)  =>  (VRCPSSr_Int:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src, VR128:{ *:[v4f32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VRCPSSr_Int),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 18737,
        GIR_EraseRootFromParent_Done,
      // Label 857: @29196
      GIM_Reject,
    // Label 830: @29197
    GIM_Try, /*On fail goto*//*Label 858*/ GIMT_Encode4(32258),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 859*/ GIMT_Encode4(29246), // Rule ID 3364 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aeskeygenassist),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 12993:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)  =>  (VAESKEYGENASSIST128rr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESKEYGENASSIST128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3364,
        GIR_EraseRootFromParent_Done,
      // Label 859: @29246
      GIM_Try, /*On fail goto*//*Label 860*/ GIMT_Encode4(29287), // Rule ID 3366 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aeskeygenassist),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_wo_chain:{ *:[v2i64] } 12993:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)  =>  (AESKEYGENASSIST128rr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, (timm:{ *:[i8] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESKEYGENASSIST128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3366,
        GIR_EraseRootFromParent_Done,
      // Label 860: @29287
      GIM_Try, /*On fail goto*//*Label 861*/ GIMT_Encode4(29332), // Rule ID 17236 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX10_2_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4key4128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14685:{ *:[iPTR] }, VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VSM4KEY4Z128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4KEY4Z128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17236,
        GIR_EraseRootFromParent_Done,
      // Label 861: @29332
      GIM_Try, /*On fail goto*//*Label 862*/ GIMT_Encode4(29377), // Rule ID 17238 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX10_2_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4key4256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 14686:{ *:[iPTR] }, VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VSM4KEY4Z256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4KEY4Z256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17238,
        GIR_EraseRootFromParent_Done,
      // Label 862: @29377
      GIM_Try, /*On fail goto*//*Label 863*/ GIMT_Encode4(29422), // Rule ID 17242 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX10_2_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4rnds4128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14688:{ *:[iPTR] }, VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)  =>  (VSM4RNDS4Z128rr:{ *:[v4i32] } VR128X:{ *:[v4i32] }:$src1, VR128X:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4RNDS4Z128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17242,
        GIR_EraseRootFromParent_Done,
      // Label 863: @29422
      GIM_Try, /*On fail goto*//*Label 864*/ GIMT_Encode4(29467), // Rule ID 17244 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX10_2_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4rnds4256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 14689:{ *:[iPTR] }, VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)  =>  (VSM4RNDS4Z256rr:{ *:[v8i32] } VR256X:{ *:[v8i32] }:$src1, VR256X:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4RNDS4Z256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17244,
        GIR_EraseRootFromParent_Done,
      // Label 864: @29467
      GIM_Try, /*On fail goto*//*Label 865*/ GIMT_Encode4(29512), // Rule ID 3019 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_b_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 14554:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (VPSIGNBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3019,
        GIR_EraseRootFromParent_Done,
      // Label 865: @29512
      GIM_Try, /*On fail goto*//*Label 866*/ GIMT_Encode4(29557), // Rule ID 3021 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_w_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14558:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPSIGNWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3021,
        GIR_EraseRootFromParent_Done,
      // Label 866: @29557
      GIM_Try, /*On fail goto*//*Label 867*/ GIMT_Encode4(29602), // Rule ID 3023 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_d_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14556:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VPSIGNDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3023,
        GIR_EraseRootFromParent_Done,
      // Label 867: @29602
      GIM_Try, /*On fail goto*//*Label 868*/ GIMT_Encode4(29647), // Rule ID 3025 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phadd_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14538:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPHADDSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3025,
        GIR_EraseRootFromParent_Done,
      // Label 868: @29647
      GIM_Try, /*On fail goto*//*Label 869*/ GIMT_Encode4(29692), // Rule ID 3027 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phsub_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14544:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (VPHSUBSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3027,
        GIR_EraseRootFromParent_Done,
      // Label 869: @29692
      GIM_Try, /*On fail goto*//*Label 870*/ GIMT_Encode4(29737), // Rule ID 3043 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_psign_b),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v32s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v32s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v32s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v32i8] } 13445:{ *:[iPTR] }, VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)  =>  (VPSIGNBYrr:{ *:[v32i8] } VR256:{ *:[v32i8] }:$src1, VR256:{ *:[v32i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNBYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3043,
        GIR_EraseRootFromParent_Done,
      // Label 870: @29737
      GIM_Try, /*On fail goto*//*Label 871*/ GIMT_Encode4(29782), // Rule ID 3045 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_psign_w),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i16] } 13447:{ *:[iPTR] }, VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPSIGNWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNWYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3045,
        GIR_EraseRootFromParent_Done,
      // Label 871: @29782
      GIM_Try, /*On fail goto*//*Label 872*/ GIMT_Encode4(29827), // Rule ID 3047 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_psign_d),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 13446:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VPSIGNDYrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPSIGNDYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3047,
        GIR_EraseRootFromParent_Done,
      // Label 872: @29827
      GIM_Try, /*On fail goto*//*Label 873*/ GIMT_Encode4(29872), // Rule ID 3049 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_phadd_sw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i16] } 13432:{ *:[iPTR] }, VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPHADDSWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHADDSWYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3049,
        GIR_EraseRootFromParent_Done,
      // Label 873: @29872
      GIM_Try, /*On fail goto*//*Label 874*/ GIMT_Encode4(29917), // Rule ID 3051 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx2_phsub_sw),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i16] } 13435:{ *:[iPTR] }, VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)  =>  (VPHSUBSWYrr:{ *:[v16i16] } VR256:{ *:[v16i16] }:$src1, VR256:{ *:[v16i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPHSUBSWYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3051,
        GIR_EraseRootFromParent_Done,
      // Label 874: @29917
      GIM_Try, /*On fail goto*//*Label 875*/ GIMT_Encode4(29962), // Rule ID 3061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_b_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i8] } 14554:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)  =>  (PSIGNBrr:{ *:[v16i8] } VR128:{ *:[v16i8] }:$src1, VR128:{ *:[v16i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PSIGNBrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3061,
        GIR_EraseRootFromParent_Done,
      // Label 875: @29962
      GIM_Try, /*On fail goto*//*Label 876*/ GIMT_Encode4(30007), // Rule ID 3063 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_w_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14558:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PSIGNWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PSIGNWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3063,
        GIR_EraseRootFromParent_Done,
      // Label 876: @30007
      GIM_Try, /*On fail goto*//*Label 877*/ GIMT_Encode4(30052), // Rule ID 3065 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_psign_d_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14556:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (PSIGNDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PSIGNDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3065,
        GIR_EraseRootFromParent_Done,
      // Label 877: @30052
      GIM_Try, /*On fail goto*//*Label 878*/ GIMT_Encode4(30097), // Rule ID 3069 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phadd_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14538:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PHADDSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PHADDSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3069,
        GIR_EraseRootFromParent_Done,
      // Label 878: @30097
      GIM_Try, /*On fail goto*//*Label 879*/ GIMT_Encode4(30142), // Rule ID 3071 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_ssse3_phsub_sw_128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14544:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)  =>  (PHSUBSWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PHSUBSWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3071,
        GIR_EraseRootFromParent_Done,
      // Label 879: @30142
      GIM_Try, /*On fail goto*//*Label 880*/ GIMT_Encode4(30187), // Rule ID 3306 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 14512:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (CRC32r32r8:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r8),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3306,
        GIR_EraseRootFromParent_Done,
      // Label 880: @30187
      GIM_Try, /*On fail goto*//*Label 881*/ GIMT_Encode4(30232), // Rule ID 3308 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 14510:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (CRC32r32r16:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r16),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3308,
        GIR_EraseRootFromParent_Done,
      // Label 881: @30232
      GIM_Try, /*On fail goto*//*Label 882*/ GIMT_Encode4(30277), // Rule ID 3310 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 14511:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (CRC32r32r32:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3310,
        GIR_EraseRootFromParent_Done,
      // Label 882: @30277
      GIM_Try, /*On fail goto*//*Label 883*/ GIMT_Encode4(30322), // Rule ID 3312 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_64_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 14513:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (CRC32r64r64:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r64r64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3312,
        GIR_EraseRootFromParent_Done,
      // Label 883: @30322
      GIM_Try, /*On fail goto*//*Label 884*/ GIMT_Encode4(30367), // Rule ID 3314 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_8),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 14512:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)  =>  (CRC32r32r8_EVEX:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR8:{ *:[i8] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r8_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3314,
        GIR_EraseRootFromParent_Done,
      // Label 884: @30367
      GIM_Try, /*On fail goto*//*Label 885*/ GIMT_Encode4(30412), // Rule ID 3316 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_16),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 14510:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)  =>  (CRC32r32r16_EVEX:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR16:{ *:[i16] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r16_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3316,
        GIR_EraseRootFromParent_Done,
      // Label 885: @30412
      GIM_Try, /*On fail goto*//*Label 886*/ GIMT_Encode4(30457), // Rule ID 3318 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_32_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_wo_chain:{ *:[i32] } 14511:{ *:[iPTR] }, GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)  =>  (CRC32r32r32_EVEX:{ *:[i32] } GR32:{ *:[i32] }:$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r32r32_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3318,
        GIR_EraseRootFromParent_Done,
      // Label 886: @30457
      GIM_Try, /*On fail goto*//*Label 887*/ GIMT_Encode4(30502), // Rule ID 3320 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasCRC32_HasEGPR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse42_crc32_64_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_wo_chain:{ *:[i64] } 14513:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (CRC32r64r64_EVEX:{ *:[i64] } GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CRC32r64r64_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3320,
        GIR_EraseRootFromParent_Done,
      // Label 887: @30502
      GIM_Try, /*On fail goto*//*Label 888*/ GIMT_Encode4(30547), // Rule ID 3324 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1nexte),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14382:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA1NEXTErr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1NEXTErr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3324,
        GIR_EraseRootFromParent_Done,
      // Label 888: @30547
      GIM_Try, /*On fail goto*//*Label 889*/ GIMT_Encode4(30592), // Rule ID 3326 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14380:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA1MSG1rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3326,
        GIR_EraseRootFromParent_Done,
      // Label 889: @30592
      GIM_Try, /*On fail goto*//*Label 890*/ GIMT_Encode4(30637), // Rule ID 3328 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14381:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA1MSG2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3328,
        GIR_EraseRootFromParent_Done,
      // Label 890: @30637
      GIM_Try, /*On fail goto*//*Label 891*/ GIMT_Encode4(30682), // Rule ID 3332 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha256msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14384:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA256MSG1rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA256MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3332,
        GIR_EraseRootFromParent_Done,
      // Label 891: @30682
      GIM_Try, /*On fail goto*//*Label 892*/ GIMT_Encode4(30727), // Rule ID 3334 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha256msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14385:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (SHA256MSG2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA256MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3334,
        GIR_EraseRootFromParent_Done,
      // Label 892: @30727
      GIM_Try, /*On fail goto*//*Label 893*/ GIMT_Encode4(30772), // Rule ID 3336 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12986:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESENCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3336,
        GIR_EraseRootFromParent_Done,
      // Label 893: @30772
      GIM_Try, /*On fail goto*//*Label 894*/ GIMT_Encode4(30817), // Rule ID 3338 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12989:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESENCLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3338,
        GIR_EraseRootFromParent_Done,
      // Label 894: @30817
      GIM_Try, /*On fail goto*//*Label 895*/ GIMT_Encode4(30862), // Rule ID 3340 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12980:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESDECrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3340,
        GIR_EraseRootFromParent_Done,
      // Label 895: @30862
      GIM_Try, /*On fail goto*//*Label 896*/ GIMT_Encode4(30907), // Rule ID 3342 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_HasAVX_NoVLX_Or_NoVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12983:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VAESDECLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3342,
        GIR_EraseRootFromParent_Done,
      // Label 896: @30907
      GIM_Try, /*On fail goto*//*Label 897*/ GIMT_Encode4(30952), // Rule ID 3344 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12987:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESENCYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3344,
        GIR_EraseRootFromParent_Done,
      // Label 897: @30952
      GIM_Try, /*On fail goto*//*Label 898*/ GIMT_Encode4(30997), // Rule ID 3346 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12990:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESENCLASTYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3346,
        GIR_EraseRootFromParent_Done,
      // Label 898: @30997
      GIM_Try, /*On fail goto*//*Label 899*/ GIMT_Encode4(31042), // Rule ID 3348 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12981:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESDECYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3348,
        GIR_EraseRootFromParent_Done,
      // Label 899: @31042
      GIM_Try, /*On fail goto*//*Label 900*/ GIMT_Encode4(31087), // Rule ID 3350 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12984:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VAESDECLASTYrr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTYrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3350,
        GIR_EraseRootFromParent_Done,
      // Label 900: @31087
      GIM_Try, /*On fail goto*//*Label 901*/ GIMT_Encode4(31132), // Rule ID 3352 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12986:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESENCrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESENCrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3352,
        GIR_EraseRootFromParent_Done,
      // Label 901: @31132
      GIM_Try, /*On fail goto*//*Label 902*/ GIMT_Encode4(31177), // Rule ID 3354 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12989:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESENCLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESENCLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3354,
        GIR_EraseRootFromParent_Done,
      // Label 902: @31177
      GIM_Try, /*On fail goto*//*Label 903*/ GIMT_Encode4(31222), // Rule ID 3356 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12980:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESDECrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESDECrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3356,
        GIR_EraseRootFromParent_Done,
      // Label 903: @31222
      GIM_Try, /*On fail goto*//*Label 904*/ GIMT_Encode4(31267), // Rule ID 3358 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAES_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12983:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (AESDECLASTrr:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::AESDECLASTrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3358,
        GIR_EraseRootFromParent_Done,
      // Label 904: @31267
      GIM_Try, /*On fail goto*//*Label 905*/ GIMT_Encode4(31312), // Rule ID 3375 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE4A),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse4a_extrq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14528:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src, VR128:{ *:[v16i8] }:$mask)  =>  (EXTRQ:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::EXTRQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3375,
        GIR_EraseRootFromParent_Done,
      // Label 905: @31312
      GIM_Try, /*On fail goto*//*Label 906*/ GIMT_Encode4(31357), // Rule ID 3377 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE4A),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse4a_insertq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14530:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src, VR128:{ *:[v2i64] }:$mask)  =>  (INSERTQ:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src, VR128:{ *:[v2i64] }:$mask)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INSERTQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_RootToRootCopy, /*OpIdx*/3, // mask
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3377,
        GIR_EraseRootFromParent_Done,
      // Label 906: @31357
      GIM_Try, /*On fail goto*//*Label 907*/ GIMT_Encode4(31402), // Rule ID 3552 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA512),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsha512msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 14679:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR128:{ *:[v2i64] }:$src2)  =>  (VSHA512MSG1rr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSHA512MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3552,
        GIR_EraseRootFromParent_Done,
      // Label 907: @31402
      GIM_Try, /*On fail goto*//*Label 908*/ GIMT_Encode4(31447), // Rule ID 3553 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA512),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsha512msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 14680:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)  =>  (VSHA512MSG2rr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSHA512MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3553,
        GIR_EraseRootFromParent_Done,
      // Label 908: @31447
      GIM_Try, /*On fail goto*//*Label 909*/ GIMT_Encode4(31492), // Rule ID 3561 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4key4128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14685:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VSM4KEY4rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4KEY4rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3561,
        GIR_EraseRootFromParent_Done,
      // Label 909: @31492
      GIM_Try, /*On fail goto*//*Label 910*/ GIMT_Encode4(31537), // Rule ID 3563 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4key4256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 14686:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VSM4KEY4Yrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4KEY4Yrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3563,
        GIR_EraseRootFromParent_Done,
      // Label 910: @31537
      GIM_Try, /*On fail goto*//*Label 911*/ GIMT_Encode4(31582), // Rule ID 3565 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4rnds4128),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14688:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)  =>  (VSM4RNDS4rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4RNDS4rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3565,
        GIR_EraseRootFromParent_Done,
      // Label 911: @31582
      GIM_Try, /*On fail goto*//*Label 912*/ GIMT_Encode4(31627), // Rule ID 3567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4rnds4256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i32] } 14689:{ *:[iPTR] }, VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)  =>  (VSM4RNDS4Yrr:{ *:[v8i32] } VR256:{ *:[v8i32] }:$src1, VR256:{ *:[v8i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4RNDS4Yrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3567,
        GIR_EraseRootFromParent_Done,
      // Label 912: @31627
      GIM_Try, /*On fail goto*//*Label 913*/ GIMT_Encode4(31672), // Rule ID 14057 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12986:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESENCZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14057,
        GIR_EraseRootFromParent_Done,
      // Label 913: @31672
      GIM_Try, /*On fail goto*//*Label 914*/ GIMT_Encode4(31717), // Rule ID 14059 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12987:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESENCZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14059,
        GIR_EraseRootFromParent_Done,
      // Label 914: @31717
      GIM_Try, /*On fail goto*//*Label 915*/ GIMT_Encode4(31762), // Rule ID 14061 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenc_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12988:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESENCZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14061,
        GIR_EraseRootFromParent_Done,
      // Label 915: @31762
      GIM_Try, /*On fail goto*//*Label 916*/ GIMT_Encode4(31807), // Rule ID 14063 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12989:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESENCLASTZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14063,
        GIR_EraseRootFromParent_Done,
      // Label 916: @31807
      GIM_Try, /*On fail goto*//*Label 917*/ GIMT_Encode4(31852), // Rule ID 14065 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12990:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESENCLASTZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14065,
        GIR_EraseRootFromParent_Done,
      // Label 917: @31852
      GIM_Try, /*On fail goto*//*Label 918*/ GIMT_Encode4(31897), // Rule ID 14067 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesenclast_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12991:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESENCLASTZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESENCLASTZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14067,
        GIR_EraseRootFromParent_Done,
      // Label 918: @31897
      GIM_Try, /*On fail goto*//*Label 919*/ GIMT_Encode4(31942), // Rule ID 14069 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12980:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESDECZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14069,
        GIR_EraseRootFromParent_Done,
      // Label 919: @31942
      GIM_Try, /*On fail goto*//*Label 920*/ GIMT_Encode4(31987), // Rule ID 14071 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12981:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESDECZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14071,
        GIR_EraseRootFromParent_Done,
      // Label 920: @31987
      GIM_Try, /*On fail goto*//*Label 921*/ GIMT_Encode4(32032), // Rule ID 14073 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdec_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12982:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESDECZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14073,
        GIR_EraseRootFromParent_Done,
      // Label 921: @32032
      GIM_Try, /*On fail goto*//*Label 922*/ GIMT_Encode4(32077), // Rule ID 14075 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 12983:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)  =>  (VAESDECLASTZ128rr:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTZ128rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14075,
        GIR_EraseRootFromParent_Done,
      // Label 922: @32077
      GIM_Try, /*On fail goto*//*Label 923*/ GIMT_Encode4(32122), // Rule ID 14077 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVAES_HasVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 12984:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)  =>  (VAESDECLASTZ256rr:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTZ256rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14077,
        GIR_EraseRootFromParent_Done,
      // Label 923: @32122
      GIM_Try, /*On fail goto*//*Label 924*/ GIMT_Encode4(32167), // Rule ID 14079 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVAES),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_aesni_aesdeclast_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i64] } 12985:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)  =>  (VAESDECLASTZrr:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VAESDECLASTZrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14079,
        GIR_EraseRootFromParent_Done,
      // Label 924: @32167
      GIM_Try, /*On fail goto*//*Label 925*/ GIMT_Encode4(32212), // Rule ID 17240 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX10_2_512_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4key4512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i32] } 14687:{ *:[iPTR] }, VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VSM4KEY4Zrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4KEY4Zrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17240,
        GIR_EraseRootFromParent_Done,
      // Label 925: @32212
      GIM_Try, /*On fail goto*//*Label 926*/ GIMT_Encode4(32257), // Rule ID 17246 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX10_2_512_HasSM4),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm4rnds4512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v16s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // (intrinsic_wo_chain:{ *:[v16i32] } 14690:{ *:[iPTR] }, VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)  =>  (VSM4RNDS4Zrr:{ *:[v16i32] } VR512:{ *:[v16i32] }:$src1, VR512:{ *:[v16i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM4RNDS4Zrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17246,
        GIR_EraseRootFromParent_Done,
      // Label 926: @32257
      GIM_Reject,
    // Label 858: @32258
    GIM_Try, /*On fail goto*//*Label 927*/ GIMT_Encode4(33743),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_Try, /*On fail goto*//*Label 928*/ GIMT_Encode4(32316), // Rule ID 3250 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoAVX10_2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dpps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4f32] } 14497:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VDPPSrri:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VDPPSrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3250,
        GIR_EraseRootFromParent_Done,
      // Label 928: @32316
      GIM_Try, /*On fail goto*//*Label 929*/ GIMT_Encode4(32366), // Rule ID 3252 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoAVX10_2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dppd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2f64] } 14496:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VDPPDrri:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VDPPDrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3252,
        GIR_EraseRootFromParent_Done,
      // Label 929: @32366
      GIM_Try, /*On fail goto*//*Label 930*/ GIMT_Encode4(32416), // Rule ID 3254 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_NoAVX10_2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_avx_dp_ps_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8f32] } 13018:{ *:[iPTR] }, VR256:{ *:[v8f32] }:$src1, VR256:{ *:[v8f32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VDPPSYrri:{ *:[v8f32] } VR256:{ *:[v8f32] }:$src1, VR256:{ *:[v8f32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VDPPSYrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3254,
        GIR_EraseRootFromParent_Done,
      // Label 930: @32416
      GIM_Try, /*On fail goto*//*Label 931*/ GIMT_Encode4(32466), // Rule ID 3260 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dpps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4f32] } 14497:{ *:[iPTR] }, VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (DPPSrri:{ *:[v4f32] } VR128:{ *:[v4f32] }:$src1, VR128:{ *:[v4f32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DPPSrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3260,
        GIR_EraseRootFromParent_Done,
      // Label 931: @32466
      GIM_Try, /*On fail goto*//*Label 932*/ GIMT_Encode4(32516), // Rule ID 3262 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE41),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sse41_dppd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2f64] } 14496:{ *:[iPTR] }, VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (DPPDrri:{ *:[v2f64] } VR128:{ *:[v2f64] }:$src1, VR128:{ *:[v2f64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::DPPDrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3262,
        GIR_EraseRootFromParent_Done,
      // Label 932: @32516
      GIM_Try, /*On fail goto*//*Label 933*/ GIMT_Encode4(32566), // Rule ID 3322 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha1rnds4),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i32] } 14383:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (SHA1RNDS4rri:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA1RNDS4rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3322,
        GIR_EraseRootFromParent_Done,
      // Label 933: @32566
      GIM_Try, /*On fail goto*//*Label 934*/ GIMT_Encode4(32616), // Rule ID 3368 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasPCLMUL_NoAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 14348:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (PCLMULQDQrri:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PCLMULQDQrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3368,
        GIR_EraseRootFromParent_Done,
      // Label 934: @32616
      GIM_Try, /*On fail goto*//*Label 935*/ GIMT_Encode4(32666), // Rule ID 3370 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_HasPCLMUL_NoVLX_Or_NoVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 14348:{ *:[iPTR] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQrri:{ *:[v2i64] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3370,
        GIR_EraseRootFromParent_Done,
      // Label 935: @32666
      GIM_Try, /*On fail goto*//*Label 936*/ GIMT_Encode4(32716), // Rule ID 3372 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVPCLMULQDQ_NoVLX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i64] } 14349:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQYrri:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQYrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3372,
        GIR_EraseRootFromParent_Done,
      // Label 936: @32716
      GIM_Try, /*On fail goto*//*Label 937*/ GIMT_Encode4(32766), // Rule ID 14081 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq_512),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v8i64] } 14350:{ *:[iPTR] }, VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQZrri:{ *:[v8i64] } VR512:{ *:[v8i64] }:$src1, VR512:{ *:[v8i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQZrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14081,
        GIR_EraseRootFromParent_Done,
      // Label 937: @32766
      GIM_Try, /*On fail goto*//*Label 938*/ GIMT_Encode4(32816), // Rule ID 14083 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX_HasVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v2i64] } 14348:{ *:[iPTR] }, VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQZ128rri:{ *:[v2i64] } VR128X:{ *:[v2i64] }:$src1, VR128X:{ *:[v2i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQZ128rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14083,
        GIR_EraseRootFromParent_Done,
      // Label 938: @32816
      GIM_Try, /*On fail goto*//*Label 939*/ GIMT_Encode4(32866), // Rule ID 14085 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasVLX_HasVPCLMULQDQ),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_pclmulqdq_256),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/4,
        // (intrinsic_wo_chain:{ *:[v4i64] } 14349:{ *:[iPTR] }, VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)  =>  (VPCLMULQDQZ256rri:{ *:[v4i64] } VR256X:{ *:[v4i64] }:$src1, VR256X:{ *:[v4i64] }:$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPCLMULQDQZ256rri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 14085,
        GIR_EraseRootFromParent_Done,
      // Label 939: @32866
      GIM_Try, /*On fail goto*//*Label 940*/ GIMT_Encode4(32920), // Rule ID 1616 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmadcswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14742:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMADCSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMADCSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1616,
        GIR_EraseRootFromParent_Done,
      // Label 940: @32920
      GIM_Try, /*On fail goto*//*Label 941*/ GIMT_Encode4(32974), // Rule ID 1618 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmadcsswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14741:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMADCSSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMADCSSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1618,
        GIR_EraseRootFromParent_Done,
      // Label 941: @32974
      GIM_Try, /*On fail goto*//*Label 942*/ GIMT_Encode4(33028), // Rule ID 1620 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsww),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14740:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1620,
        GIR_EraseRootFromParent_Done,
      // Label 942: @33028
      GIM_Try, /*On fail goto*//*Label 943*/ GIMT_Encode4(33082), // Rule ID 1622 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14739:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1622,
        GIR_EraseRootFromParent_Done,
      // Label 943: @33082
      GIM_Try, /*On fail goto*//*Label 944*/ GIMT_Encode4(33136), // Rule ID 1624 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssww),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v8s16,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v8i16] } 14738:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)  =>  (VPMACSSWWrr:{ *:[v8i16] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v8i16] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSWWrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1624,
        GIR_EraseRootFromParent_Done,
      // Label 944: @33136
      GIM_Try, /*On fail goto*//*Label 945*/ GIMT_Encode4(33190), // Rule ID 1626 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsswd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v8s16,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14737:{ *:[iPTR] }, VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSSWDrr:{ *:[v4i32] } VR128:{ *:[v8i16] }:$src1, VR128:{ *:[v8i16] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSWDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1626,
        GIR_EraseRootFromParent_Done,
      // Label 945: @33190
      GIM_Try, /*On fail goto*//*Label 946*/ GIMT_Encode4(33244), // Rule ID 1628 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssdql),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14736:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSSDQLrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSDQLrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1628,
        GIR_EraseRootFromParent_Done,
      // Label 946: @33244
      GIM_Try, /*On fail goto*//*Label 947*/ GIMT_Encode4(33298), // Rule ID 1630 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssdqh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14735:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSSDQHrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSDQHrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1630,
        GIR_EraseRootFromParent_Done,
      // Label 947: @33298
      GIM_Try, /*On fail goto*//*Label 948*/ GIMT_Encode4(33352), // Rule ID 1632 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacssdd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14734:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1632,
        GIR_EraseRootFromParent_Done,
      // Label 948: @33352
      GIM_Try, /*On fail goto*//*Label 949*/ GIMT_Encode4(33406), // Rule ID 1634 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsdql),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14733:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSDQLrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDQLrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1634,
        GIR_EraseRootFromParent_Done,
      // Label 949: @33406
      GIM_Try, /*On fail goto*//*Label 950*/ GIMT_Encode4(33460), // Rule ID 1636 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsdqh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v2s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v2i64] } 14732:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VPMACSDQHrr:{ *:[v2i64] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDQHrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1636,
        GIR_EraseRootFromParent_Done,
      // Label 950: @33460
      GIM_Try, /*On fail goto*//*Label 951*/ GIMT_Encode4(33514), // Rule ID 1638 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasXOP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xop_vpmacsdd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14731:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VPMACSDDrr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VPMACSDDrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1638,
        GIR_EraseRootFromParent_Done,
      // Label 951: @33514
      GIM_Try, /*On fail goto*//*Label 952*/ GIMT_Encode4(33580), // Rule ID 3330 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_sha256rnds2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14386:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, XMM0:{ *:[v4i32] })  =>  (SHA256RNDS2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::XMM0), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/4, // XMM0
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SHA256RNDS2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3330,
        GIR_EraseRootFromParent_Done,
      // Label 952: @33580
      GIM_Try, /*On fail goto*//*Label 953*/ GIMT_Encode4(33634), // Rule ID 3554 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSHA512),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsha512rnds2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s64,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v2s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR256RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i64] } 14681:{ *:[iPTR] }, VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, VR128:{ *:[v2i64] }:$src3)  =>  (VSHA512RNDS2rr:{ *:[v4i64] } VR256:{ *:[v4i64] }:$src1, VR256:{ *:[v4i64] }:$src2, VR128:{ *:[v2i64] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSHA512RNDS2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3554,
        GIR_EraseRootFromParent_Done,
      // Label 953: @33634
      GIM_Try, /*On fail goto*//*Label 954*/ GIMT_Encode4(33688), // Rule ID 3555 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm3msg1),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14682:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VSM3MSG1rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM3MSG1rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3555,
        GIR_EraseRootFromParent_Done,
      // Label 954: @33688
      GIM_Try, /*On fail goto*//*Label 955*/ GIMT_Encode4(33742), // Rule ID 3557 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm3msg2),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
        GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // (intrinsic_wo_chain:{ *:[v4i32] } 14683:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)  =>  (VSM3MSG2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM3MSG2rr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_RootToRootCopy, /*OpIdx*/4, // src3
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3557,
        GIR_EraseRootFromParent_Done,
      // Label 955: @33742
      GIM_Reject,
    // Label 927: @33743
    GIM_Try, /*On fail goto*//*Label 956*/ GIMT_Encode4(33805), // Rule ID 3559 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSM3),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/6,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_vsm3rnds2),
      GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v4s32,
      GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_v4s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      // MIs[0] src4
      GIM_CheckIsImm, /*MI*/0, /*Op*/5,
      // (intrinsic_wo_chain:{ *:[v4i32] } 14684:{ *:[iPTR] }, VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3, (timm:{ *:[i32] }):$src4)  =>  (VSM3RNDS2rr:{ *:[v4i32] } VR128:{ *:[v4i32] }:$src1, VR128:{ *:[v4i32] }:$src2, VR128:{ *:[v4i32] }:$src3, (timm:{ *:[i32] }):$src4)
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VSM3RNDS2rr),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_RootToRootCopy, /*OpIdx*/2, // src1
      GIR_RootToRootCopy, /*OpIdx*/3, // src2
      GIR_RootToRootCopy, /*OpIdx*/4, // src3
      GIR_RootToRootCopy, /*OpIdx*/5, // src4
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 3559,
      GIR_EraseRootFromParent_Done,
    // Label 956: @33805
    GIM_Reject,
    // Label 11: @33806
    GIM_Try, /*On fail goto*//*Label 957*/ GIMT_Encode4(34365),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/1,
      GIM_Try, /*On fail goto*//*Label 958*/ GIMT_Encode4(33836), // Rule ID 149 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSERIALIZE),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_serialize),
        // (intrinsic_void 14378:{ *:[iPTR] })  =>  (SERIALIZE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SERIALIZE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 149,
        GIR_EraseRootFromParent_Done,
      // Label 958: @33836
      GIM_Try, /*On fail goto*//*Label 959*/ GIMT_Encode4(33858), // Rule ID 150 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTSXLDTRK),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xsusldtrk),
        // (intrinsic_void 14766:{ *:[iPTR] })  =>  (XSUSLDTRK)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XSUSLDTRK),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 150,
        GIR_EraseRootFromParent_Done,
      // Label 959: @33858
      GIM_Try, /*On fail goto*//*Label 960*/ GIMT_Encode4(33880), // Rule ID 151 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasTSXLDTRK),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xresldtrk),
        // (intrinsic_void 14752:{ *:[iPTR] })  =>  (XRESLDTRK)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XRESLDTRK),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 151,
        GIR_EraseRootFromParent_Done,
      // Label 960: @33880
      GIM_Try, /*On fail goto*//*Label 961*/ GIMT_Encode4(33902), // Rule ID 152 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUINTR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_clui),
        // (intrinsic_void 14236:{ *:[iPTR] })  =>  (CLUI)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::CLUI),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 152,
        GIR_EraseRootFromParent_Done,
      // Label 961: @33902
      GIM_Try, /*On fail goto*//*Label 962*/ GIMT_Encode4(33924), // Rule ID 153 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUINTR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_stui),
        // (intrinsic_void 14560:{ *:[iPTR] })  =>  (STUI)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::STUI),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 153,
        GIR_EraseRootFromParent_Done,
      // Label 962: @33924
      GIM_Try, /*On fail goto*//*Label 963*/ GIMT_Encode4(33943), // Rule ID 2507 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_pause),
        // (intrinsic_void 14455:{ *:[iPTR] })  =>  (PAUSE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PAUSE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2507,
        GIR_EraseRootFromParent_Done,
      // Label 963: @33943
      GIM_Try, /*On fail goto*//*Label 964*/ GIMT_Encode4(33965), // Rule ID 2508 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE1),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse_sfence),
        // (intrinsic_void 14417:{ *:[iPTR] })  =>  (SFENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SFENCE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2508,
        GIR_EraseRootFromParent_Done,
      // Label 964: @33965
      GIM_Try, /*On fail goto*//*Label 965*/ GIMT_Encode4(33987), // Rule ID 2509 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_lfence),
        // (intrinsic_void 14444:{ *:[iPTR] })  =>  (LFENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LFENCE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2509,
        GIR_EraseRootFromParent_Done,
      // Label 965: @33987
      GIM_Try, /*On fail goto*//*Label 966*/ GIMT_Encode4(34009), // Rule ID 2510 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMFence),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_mfence),
        // (intrinsic_void 14448:{ *:[iPTR] })  =>  (MFENCE)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MFENCE),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2510,
        GIR_EraseRootFromParent_Done,
      // Label 966: @34009
      GIM_Try, /*On fail goto*//*Label 967*/ GIMT_Encode4(34075), // Rule ID 3424 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_avx_vzeroall),
        // (intrinsic_void 13061:{ *:[iPTR] })  =>  (VZEROALL)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VZEROALL),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM7*/7,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM8*/8,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM9*/9,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM10*/10,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM11*/11,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM12*/12,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM13*/13,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM14*/14,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM15*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3424,
        GIR_EraseRootFromParent_Done,
      // Label 967: @34075
      GIM_Try, /*On fail goto*//*Label 968*/ GIMT_Encode4(34141), // Rule ID 3425 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_avx_vzeroupper),
        // (intrinsic_void 13062:{ *:[iPTR] })  =>  (VZEROUPPER)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VZEROUPPER),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM7*/7,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM8*/8,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM9*/9,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM10*/10,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM11*/11,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM12*/12,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM13*/13,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM14*/14,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::YMM15*/15,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3425,
        GIR_EraseRootFromParent_Done,
      // Label 968: @34141
      GIM_Try, /*On fail goto*//*Label 969*/ GIMT_Encode4(34211), // Rule ID 17249 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMMX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_mmx_emms),
        // (intrinsic_void 14271:{ *:[iPTR] })  =>  (MMX_EMMS:{ *:[x86mmx] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MMX_EMMS),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::MM7*/7,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST0*/8,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST1*/9,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST2*/10,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST3*/11,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST4*/12,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST5*/13,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST6*/14,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ST7*/15,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17249,
        GIR_EraseRootFromParent_Done,
      // Label 969: @34211
      GIM_Try, /*On fail goto*//*Label 970*/ GIMT_Encode4(34233), // Rule ID 17432 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xend),
        // (intrinsic_void 14704:{ *:[iPTR] })  =>  (XEND)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XEND),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17432,
        GIR_EraseRootFromParent_Done,
      // Label 970: @34233
      GIM_Try, /*On fail goto*//*Label 971*/ GIMT_Encode4(34279), // Rule ID 17444 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXTILE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tilerelease),
        // (intrinsic_void 14630:{ *:[iPTR] })  =>  (TILERELEASE:{ *:[x86amx] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::TILERELEASE),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM0*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM1*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM2*/2,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM3*/3,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM4*/4,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM5*/5,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM6*/6,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::TMM7*/7,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17444,
        GIR_EraseRootFromParent_Done,
      // Label 971: @34279
      GIM_Try, /*On fail goto*//*Label 972*/ GIMT_Encode4(34298), // Rule ID 17533 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wbinvd),
        // (intrinsic_void 14691:{ *:[iPTR] })  =>  (WBINVD)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WBINVD),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17533,
        GIR_EraseRootFromParent_Done,
      // Label 972: @34298
      GIM_Try, /*On fail goto*//*Label 973*/ GIMT_Encode4(34320), // Rule ID 17534 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWBNOINVD),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wbnoinvd),
        // (intrinsic_void 14692:{ *:[iPTR] })  =>  (WBNOINVD)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WBNOINVD),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17534,
        GIR_EraseRootFromParent_Done,
      // Label 973: @34320
      GIM_Try, /*On fail goto*//*Label 974*/ GIMT_Encode4(34342), // Rule ID 17539 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_saveprevssp),
        // (intrinsic_void 14373:{ *:[iPTR] })  =>  (SAVEPREVSSP)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SAVEPREVSSP),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::SSP*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17539,
        GIR_EraseRootFromParent_Done,
      // Label 974: @34342
      GIM_Try, /*On fail goto*//*Label 975*/ GIMT_Encode4(34364), // Rule ID 17549 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_setssbsy),
        // (intrinsic_void 14379:{ *:[iPTR] })  =>  (SETSSBSY)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SETSSBSY),
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::SSP*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17549,
        GIR_EraseRootFromParent_Done,
      // Label 975: @34364
      GIM_Reject,
    // Label 957: @34365
    GIM_Try, /*On fail goto*//*Label 976*/ GIMT_Encode4(35374),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/2,
      GIM_Try, /*On fail goto*//*Label 977*/ GIMT_Encode4(34403), // Rule ID 17522 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_int),
        // MIs[0] Operand 1
        GIM_CheckLiteralInt, /*MI*/0, /*Op*/1, GIMT_Encode8(3),
        // (intrinsic_void 14261:{ *:[iPTR] }, 3:{ *:[i8] })  =>  (INT3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INT3),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17522,
        GIR_EraseRootFromParent_Done,
      // Label 977: @34403
      GIM_Try, /*On fail goto*//*Label 978*/ GIMT_Encode4(34430), // Rule ID 17434 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xabort),
        // MIs[0] imm
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 14702:{ *:[iPTR] }, (timm:{ *:[i8] }):$imm)  =>  (XABORT (timm:{ *:[i8] }):$imm)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XABORT),
        GIR_RootToRootCopy, /*OpIdx*/1, // imm
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17434,
        GIR_EraseRootFromParent_Done,
      // Label 978: @34430
      GIM_Try, /*On fail goto*//*Label 979*/ GIMT_Encode4(34457), // Rule ID 17446 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXTILE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tilezero),
        // MIs[0] src
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 14633:{ *:[iPTR] }, (timm:{ *:[i8] }):$src)  =>  (PTILEZERO (timm:{ *:[i8] }):$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTILEZERO),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17446,
        GIR_EraseRootFromParent_Done,
      // Label 979: @34457
      GIM_Try, /*On fail goto*//*Label 980*/ GIMT_Encode4(34481), // Rule ID 17524 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_int),
        // MIs[0] trap
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // (intrinsic_void 14261:{ *:[iPTR] }, (timm:{ *:[i8] }):$trap)  =>  (INT (timm:{ *:[i8] }):$trap)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INT),
        GIR_RootToRootCopy, /*OpIdx*/1, // trap
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17524,
        GIR_EraseRootFromParent_Done,
      // Label 980: @34481
      GIM_Try, /*On fail goto*//*Label 981*/ GIMT_Encode4(34515), // Rule ID 1 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_flags_read_u32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 14247:{ *:[iPTR] })  =>  (RDFLAGS32:{ *:[i32] }:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFLAGS32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ESP*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 1,
        GIR_EraseRootFromParent_Done,
      // Label 981: @34515
      GIM_Try, /*On fail goto*//*Label 982*/ GIMT_Encode4(34549), // Rule ID 2 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_flags_read_u64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 14248:{ *:[iPTR] })  =>  (RDFLAGS64:{ *:[i64] }:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFLAGS64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ESP*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2,
        GIR_EraseRootFromParent_Done,
      // Label 982: @34549
      GIM_Try, /*On fail goto*//*Label 983*/ GIMT_Encode4(34580), // Rule ID 115 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_slwpcb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 14387:{ *:[iPTR] })  =>  (SLWPCB:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SLWPCB),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 115,
        GIR_EraseRootFromParent_Done,
      // Label 983: @34580
      GIM_Try, /*On fail goto*//*Label 984*/ GIMT_Encode4(34611), // Rule ID 117 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_slwpcb),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 14387:{ *:[iPTR] })  =>  (SLWPCB64:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SLWPCB64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 117,
        GIR_EraseRootFromParent_Done,
      // Label 984: @34611
      GIM_Try, /*On fail goto*//*Label 985*/ GIMT_Encode4(34642), // Rule ID 17431 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRTM),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_xbegin),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 14703:{ *:[iPTR] })  =>  (XBEGIN:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XBEGIN),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17431,
        GIR_EraseRootFromParent_Done,
      // Label 985: @34642
      GIM_Try, /*On fail goto*//*Label 986*/ GIMT_Encode4(34673), // Rule ID 17566 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdfsbase_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 14354:{ *:[iPTR] })  =>  (RDFSBASE:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFSBASE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17566,
        GIR_EraseRootFromParent_Done,
      // Label 986: @34673
      GIM_Try, /*On fail goto*//*Label 987*/ GIMT_Encode4(34704), // Rule ID 17567 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdfsbase_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 14355:{ *:[iPTR] })  =>  (RDFSBASE64:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDFSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17567,
        GIR_EraseRootFromParent_Done,
      // Label 987: @34704
      GIM_Try, /*On fail goto*//*Label 988*/ GIMT_Encode4(34735), // Rule ID 17568 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdgsbase_32),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 14356:{ *:[iPTR] })  =>  (RDGSBASE:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDGSBASE),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17568,
        GIR_EraseRootFromParent_Done,
      // Label 988: @34735
      GIM_Try, /*On fail goto*//*Label 989*/ GIMT_Encode4(34766), // Rule ID 17569 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdgsbase_64),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 14357:{ *:[iPTR] })  =>  (RDGSBASE64:{ *:[i64] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDGSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17569,
        GIR_EraseRootFromParent_Done,
      // Label 989: @34766
      GIM_Try, /*On fail goto*//*Label 990*/ GIMT_Encode4(34797), // Rule ID 17575 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRDPID_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdpid),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 14358:{ *:[iPTR] })  =>  (RDPID32:{ *:[i32] })
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDPID32),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17575,
        GIR_EraseRootFromParent_Done,
      // Label 990: @34797
      GIM_Try, /*On fail goto*//*Label 991*/ GIMT_Encode4(34854), // Rule ID 22807 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasRDPID_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdpid),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 14358:{ *:[iPTR] })  =>  (EXTRACT_SUBREG:{ *:[i32] } (RDPID64:{ *:[i64] }), sub_32bit:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::RDPID64),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_32bit),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR64_with_sub_8bitRegClassID),
        // GIR_Coverage, 22807,
        GIR_EraseRootFromParent_Done,
      // Label 991: @34854
      GIM_Try, /*On fail goto*//*Label 992*/ GIMT_Encode4(34894), // Rule ID 3 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_flags_write_u32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 14249:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (WRFLAGS32:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFLAGS32),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::ESP*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::DF*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3,
        GIR_EraseRootFromParent_Done,
      // Label 992: @34894
      GIM_Try, /*On fail goto*//*Label 993*/ GIMT_Encode4(34934), // Rule ID 4 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_flags_write_u64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14250:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (WRFLAGS64:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFLAGS64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::RSP*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::DF*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 4,
        GIR_EraseRootFromParent_Done,
      // Label 993: @34934
      GIM_Try, /*On fail goto*//*Label 994*/ GIMT_Encode4(34965), // Rule ID 154 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUINTR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_senduipi),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14377:{ *:[iPTR] }, GR64:{ *:[i64] }:$arg)  =>  (SENDUIPI GR64:{ *:[i64] }:$arg)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::SENDUIPI),
        GIR_RootToRootCopy, /*OpIdx*/1, // arg
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 154,
        GIR_EraseRootFromParent_Done,
      // Label 994: @34965
      GIM_Try, /*On fail goto*//*Label 995*/ GIMT_Encode4(34996), // Rule ID 17535 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_incsspd),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 14259:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (INCSSPD GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INCSSPD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::SSP*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17535,
        GIR_EraseRootFromParent_Done,
      // Label 995: @34996
      GIM_Try, /*On fail goto*//*Label 996*/ GIMT_Encode4(35027), // Rule ID 17536 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_incsspq),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14260:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (INCSSPQ GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::INCSSPQ),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::SSP*/0,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17536,
        GIR_EraseRootFromParent_Done,
      // Label 996: @35027
      GIM_Try, /*On fail goto*//*Label 997*/ GIMT_Encode4(35058), // Rule ID 17570 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrfsbase_32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 14693:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (WRFSBASE GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFSBASE),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17570,
        GIR_EraseRootFromParent_Done,
      // Label 997: @35058
      GIM_Try, /*On fail goto*//*Label 998*/ GIMT_Encode4(35089), // Rule ID 17571 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrfsbase_64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14694:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (WRFSBASE64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRFSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17571,
        GIR_EraseRootFromParent_Done,
      // Label 998: @35089
      GIM_Try, /*On fail goto*//*Label 999*/ GIMT_Encode4(35120), // Rule ID 17572 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrgsbase_32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 14695:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (WRGSBASE GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRGSBASE),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17572,
        GIR_EraseRootFromParent_Done,
      // Label 999: @35120
      GIM_Try, /*On fail goto*//*Label 1000*/ GIMT_Encode4(35151), // Rule ID 17573 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasFSGSBase_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_wrgsbase_64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14696:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (WRGSBASE64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::WRGSBASE64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17573,
        GIR_EraseRootFromParent_Done,
      // Label 1000: @35151
      GIM_Try, /*On fail goto*//*Label 1001*/ GIMT_Encode4(35182), // Rule ID 17578 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasPTWRITE),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ptwrite32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 14352:{ *:[iPTR] }, GR32:{ *:[i32] }:$dst)  =>  (PTWRITEr GR32:{ *:[i32] }:$dst)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTWRITEr),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17578,
        GIR_EraseRootFromParent_Done,
      // Label 1001: @35182
      GIM_Try, /*On fail goto*//*Label 1002*/ GIMT_Encode4(35213), // Rule ID 17579 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasPTWRITE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ptwrite64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14353:{ *:[iPTR] }, GR64:{ *:[i64] }:$dst)  =>  (PTWRITE64r GR64:{ *:[i64] }:$dst)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTWRITE64r),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17579,
        GIR_EraseRootFromParent_Done,
      // Label 1002: @35213
      GIM_Try, /*On fail goto*//*Label 1003*/ GIMT_Encode4(35245), // Rule ID 114 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_llwpcb),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 14265:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (LLWPCB GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LLWPCB),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 114,
        GIR_EraseRootFromParent_Done,
      // Label 1003: @35245
      GIM_Try, /*On fail goto*//*Label 1004*/ GIMT_Encode4(35277), // Rule ID 116 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_llwpcb),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14265:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (LLWPCB64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LLWPCB64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 116,
        GIR_EraseRootFromParent_Done,
      // Label 1004: @35277
      GIM_Try, /*On fail goto*//*Label 1005*/ GIMT_Encode4(35309), // Rule ID 126 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWAITPKG_Not64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_umonitor),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/16,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
        // (intrinsic_void 14650:{ *:[iPTR] }, GR16:{ *:[i16] }:$src)  =>  (UMONITOR16 GR16:{ *:[i16] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UMONITOR16),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 126,
        GIR_EraseRootFromParent_Done,
      // Label 1005: @35309
      GIM_Try, /*On fail goto*//*Label 1006*/ GIMT_Encode4(35341), // Rule ID 127 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWAITPKG),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_umonitor),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 14650:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (UMONITOR32 GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UMONITOR32),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 127,
        GIR_EraseRootFromParent_Done,
      // Label 1006: @35341
      GIM_Try, /*On fail goto*//*Label 1007*/ GIMT_Encode4(35373), // Rule ID 128 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasWAITPKG_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_umonitor),
        // MIs[0] src
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14650:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (UMONITOR64 GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UMONITOR64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 128,
        GIR_EraseRootFromParent_Done,
      // Label 1007: @35373
      GIM_Reject,
    // Label 976: @35374
    GIM_Try, /*On fail goto*//*Label 1008*/ GIMT_Encode4(35788),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/3,
      GIM_Try, /*On fail goto*//*Label 1009*/ GIMT_Encode4(35414), // Rule ID 17472 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXTRANSPOSE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ttransposed),
        // MIs[0] dst
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 14648:{ *:[iPTR] }, (timm:{ *:[i8] }):$dst, (timm:{ *:[i8] }):$src)  =>  (PTTRANSPOSED (timm:{ *:[i8] }):$dst, (timm:{ *:[i8] }):$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTTRANSPOSED),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17472,
        GIR_EraseRootFromParent_Done,
      // Label 1009: @35414
      GIM_Try, /*On fail goto*//*Label 1010*/ GIMT_Encode4(35446), // Rule ID 17484 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_HasAMXTRANSPOSE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tconjtfp16),
        // MIs[0] dst
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 14587:{ *:[iPTR] }, (timm:{ *:[i8] }):$dst, (timm:{ *:[i8] }):$src)  =>  (PTCONJTFP16 (timm:{ *:[i8] }):$dst, (timm:{ *:[i8] }):$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCONJTFP16),
        GIR_RootToRootCopy, /*OpIdx*/1, // dst
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17484,
        GIR_EraseRootFromParent_Done,
      // Label 1010: @35446
      GIM_Try, /*On fail goto*//*Label 1011*/ GIMT_Encode4(35489), // Rule ID 17599 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::asan_check_memaccess),
        // MIs[0] addr
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/1, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64PLTSafeRegClassID),
        // MIs[0] accessinfo
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // (intrinsic_void 9:{ *:[iPTR] }, GR64PLTSafe:{ *:[i64] }:$addr, (timm:{ *:[i32] }):$accessinfo)  =>  (ASAN_CHECK_MEMACCESS:{ *:[i64] } GR64PLTSafe:{ *:[i64] }:$addr, (timm:{ *:[i32] }):$accessinfo)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::ASAN_CHECK_MEMACCESS),
        GIR_RootToRootCopy, /*OpIdx*/1, // addr
        GIR_RootToRootCopy, /*OpIdx*/2, // accessinfo
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::R10*/0,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::R11*/1,
        GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/2,
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17599,
        GIR_EraseRootFromParent_Done,
      // Label 1011: @35489
      GIM_Try, /*On fail goto*//*Label 1012*/ GIMT_Encode4(35529), // Rule ID 17525 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUSERMSR_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_urdmsr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 14652:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (URDMSRrr:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::URDMSRrr),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17525,
        GIR_EraseRootFromParent_Done,
      // Label 1012: @35529
      GIM_Try, /*On fail goto*//*Label 1013*/ GIMT_Encode4(35569), // Rule ID 17529 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasEGPR_HasUSERMSR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_urdmsr),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 14652:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (URDMSRrr_EVEX:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::URDMSRrr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17529,
        GIR_EraseRootFromParent_Done,
      // Label 1013: @35569
      GIM_Try, /*On fail goto*//*Label 1014*/ GIMT_Encode4(35606), // Rule ID 17537 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdsspd),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[i32] } 14368:{ *:[iPTR] }, GR32:{ *:[i32] }:$src)  =>  (RDSSPD:{ *:[i32] } GR32:{ *:[i32] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDSSPD),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17537,
        GIR_EraseRootFromParent_Done,
      // Label 1014: @35606
      GIM_Try, /*On fail goto*//*Label 1015*/ GIMT_Encode4(35643), // Rule ID 17538 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_rdsspq),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_w_chain:{ *:[i64] } 14369:{ *:[iPTR] }, GR64:{ *:[i64] }:$src)  =>  (RDSSPQ:{ *:[i64] } GR64:{ *:[i64] }:$src)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::RDSSPQ),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17538,
        GIR_EraseRootFromParent_Done,
      // Label 1015: @35643
      GIM_Try, /*On fail goto*//*Label 1016*/ GIMT_Encode4(35707), // Rule ID 3083 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasSSE3),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse3_mwait),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32_ArgRef_and_GR32_CBRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32_ADRegClassID),
        // (intrinsic_void 14493:{ *:[iPTR] }, ECX:{ *:[i32] }, EAX:{ *:[i32] })  =>  (MWAITrr)
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/2, GIMT_Encode2(X86::EAX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // EAX
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::ECX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // ECX
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MWAITrr),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 3083,
        GIR_EraseRootFromParent_Done,
      // Label 1016: @35707
      GIM_Try, /*On fail goto*//*Label 1017*/ GIMT_Encode4(35747), // Rule ID 17527 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasUSERMSR_NoEGPR),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_uwrmsr),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14653:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (UWRMSRrr GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UWRMSRrr),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17527,
        GIR_EraseRootFromParent_Done,
      // Label 1017: @35747
      GIM_Try, /*On fail goto*//*Label 1018*/ GIMT_Encode4(35787), // Rule ID 17531 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasEGPR_HasUSERMSR_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_uwrmsr),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        // (intrinsic_void 14653:{ *:[iPTR] }, GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)  =>  (UWRMSRrr_EVEX GR64:{ *:[i64] }:$src1, GR64:{ *:[i64] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::UWRMSRrr_EVEX),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17531,
        GIR_EraseRootFromParent_Done,
      // Label 1018: @35787
      GIM_Reject,
    // Label 1008: @35788
    GIM_Try, /*On fail goto*//*Label 1019*/ GIMT_Encode4(37361),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/4,
      GIM_Try, /*On fail goto*//*Label 1020*/ GIMT_Encode4(35833), // Rule ID 17451 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbssd),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14605:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBSSD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBSSD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17451,
        GIR_EraseRootFromParent_Done,
      // Label 1020: @35833
      GIM_Try, /*On fail goto*//*Label 1021*/ GIMT_Encode4(35870), // Rule ID 17452 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbsud),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14607:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBSUD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBSUD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17452,
        GIR_EraseRootFromParent_Done,
      // Label 1021: @35870
      GIM_Try, /*On fail goto*//*Label 1022*/ GIMT_Encode4(35907), // Rule ID 17453 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbusd),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14609:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBUSD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBUSD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17453,
        GIR_EraseRootFromParent_Done,
      // Label 1022: @35907
      GIM_Try, /*On fail goto*//*Label 1023*/ GIMT_Encode4(35944), // Rule ID 17454 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXINT8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbuud),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14611:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBUUD (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBUUD),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17454,
        GIR_EraseRootFromParent_Done,
      // Label 1023: @35944
      GIM_Try, /*On fail goto*//*Label 1024*/ GIMT_Encode4(35981), // Rule ID 17456 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXBF16_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbf16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14599:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBF16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBF16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17456,
        GIR_EraseRootFromParent_Done,
      // Label 1024: @35981
      GIM_Try, /*On fail goto*//*Label 1025*/ GIMT_Encode4(36018), // Rule ID 17458 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXFP16_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14613:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17458,
        GIR_EraseRootFromParent_Done,
      // Label 1025: @36018
      GIM_Try, /*On fail goto*//*Label 1026*/ GIMT_Encode4(36055), // Rule ID 17461 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tcmmimfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14581:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTCMMIMFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCMMIMFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17461,
        GIR_EraseRootFromParent_Done,
      // Label 1026: @36055
      GIM_Try, /*On fail goto*//*Label 1027*/ GIMT_Encode4(36092), // Rule ID 17462 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tcmmrlfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14583:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTCMMRLFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCMMRLFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17462,
        GIR_EraseRootFromParent_Done,
      // Label 1027: @36092
      GIM_Try, /*On fail goto*//*Label 1028*/ GIMT_Encode4(36129), // Rule ID 17463 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXFP8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbf8ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14601:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBF8PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBF8PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17463,
        GIR_EraseRootFromParent_Done,
      // Label 1028: @36129
      GIM_Try, /*On fail goto*//*Label 1029*/ GIMT_Encode4(36166), // Rule ID 17464 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXFP8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdpbhf8ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14603:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPBHF8PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPBHF8PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17464,
        GIR_EraseRootFromParent_Done,
      // Label 1029: @36166
      GIM_Try, /*On fail goto*//*Label 1030*/ GIMT_Encode4(36203), // Rule ID 17465 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXFP8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdphbf8ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14615:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPHBF8PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPHBF8PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17465,
        GIR_EraseRootFromParent_Done,
      // Label 1030: @36203
      GIM_Try, /*On fail goto*//*Label 1031*/ GIMT_Encode4(36240), // Rule ID 17466 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXFP8_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tdphf8ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14617:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTDPHF8PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTDPHF8PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17466,
        GIR_EraseRootFromParent_Done,
      // Label 1031: @36240
      GIM_Try, /*On fail goto*//*Label 1032*/ GIMT_Encode4(36277), // Rule ID 17474 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXBF16_HasAMXTRANSPOSE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ttdpbf16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14642:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTTDPBF16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTTDPBF16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17474,
        GIR_EraseRootFromParent_Done,
      // Label 1032: @36277
      GIM_Try, /*On fail goto*//*Label 1033*/ GIMT_Encode4(36314), // Rule ID 17476 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXFP16_HasAMXTRANSPOSE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ttdpfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14644:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTTDPFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTTDPFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17476,
        GIR_EraseRootFromParent_Done,
      // Label 1033: @36314
      GIM_Try, /*On fail goto*//*Label 1034*/ GIMT_Encode4(36351), // Rule ID 17481 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_HasAMXTRANSPOSE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ttcmmimfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14638:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTTCMMIMFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTTCMMIMFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17481,
        GIR_EraseRootFromParent_Done,
      // Label 1034: @36351
      GIM_Try, /*On fail goto*//*Label 1035*/ GIMT_Encode4(36388), // Rule ID 17482 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_HasAMXTRANSPOSE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ttcmmrlfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14640:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTTCMMRLFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTTCMMRLFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17482,
        GIR_EraseRootFromParent_Done,
      // Label 1035: @36388
      GIM_Try, /*On fail goto*//*Label 1036*/ GIMT_Encode4(36425), // Rule ID 17483 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXCOMPLEX_HasAMXTRANSPOSE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tconjtcmmimfp16ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14585:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTCONJTCMMIMFP16PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCONJTCMMIMFP16PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17483,
        GIR_EraseRootFromParent_Done,
      // Label 1036: @36425
      GIM_Try, /*On fail goto*//*Label 1037*/ GIMT_Encode4(36462), // Rule ID 17502 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXTF32_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_tmmultf32ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14635:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTMMULTF32PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTMMULTF32PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17502,
        GIR_EraseRootFromParent_Done,
      // Label 1037: @36462
      GIM_Try, /*On fail goto*//*Label 1038*/ GIMT_Encode4(36499), // Rule ID 17504 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXTF32_HasAMXTRANSPOSE_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_ttmmultf32ps),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/1,
        // MIs[0] src2
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        // MIs[0] src3
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14646:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)  =>  (PTTMMULTF32PS (timm:{ *:[i8] }):$src1, (timm:{ *:[i8] }):$src2, (timm:{ *:[i8] }):$src3)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTTMMULTF32PS),
        GIR_RootToRootCopy, /*OpIdx*/1, // src1
        GIR_RootToRootCopy, /*OpIdx*/2, // src2
        GIR_RootToRootCopy, /*OpIdx*/3, // src3
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17504,
        GIR_EraseRootFromParent_Done,
      // Label 1038: @36499
      GIM_Try, /*On fail goto*//*Label 1039*/ GIMT_Encode4(36552), // Rule ID 17485 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_tcvtrowd2ps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v16f32] } 14589:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (imm:{ *:[i32] }):$src2)  =>  (PTCVTROWD2PSrri:{ *:[v16f32] } (timm:{ *:[i8] }):$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCVTROWD2PSrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17485,
        GIR_EraseRootFromParent_Done,
      // Label 1039: @36552
      GIM_Try, /*On fail goto*//*Label 1040*/ GIMT_Encode4(36605), // Rule ID 17494 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_tcvtrowps2phh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v32s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v32f16] } 14595:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (imm:{ *:[i32] }):$src2)  =>  (PTCVTROWPS2PHHrri:{ *:[v32f16] } (timm:{ *:[i8] }):$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCVTROWPS2PHHrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17494,
        GIR_EraseRootFromParent_Done,
      // Label 1040: @36605
      GIM_Try, /*On fail goto*//*Label 1041*/ GIMT_Encode4(36658), // Rule ID 17496 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_tcvtrowps2phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v32s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v32f16] } 14597:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (imm:{ *:[i32] }):$src2)  =>  (PTCVTROWPS2PHLrri:{ *:[v32f16] } (timm:{ *:[i8] }):$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCVTROWPS2PHLrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17496,
        GIR_EraseRootFromParent_Done,
      // Label 1041: @36658
      GIM_Try, /*On fail goto*//*Label 1042*/ GIMT_Encode4(36711), // Rule ID 17497 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_tilemovrow),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/3, // MIs[1]
        GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
        // MIs[1] Operand 1
        // No operand predicates
        GIM_CheckIsSafeToFold, /*NumInsns*/1,
        // (intrinsic_w_chain:{ *:[v16i32] } 14628:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, (imm:{ *:[i32] }):$src2)  =>  (PTILEMOVROWrri:{ *:[v16i32] } (timm:{ *:[i8] }):$src1, (imm:{ *:[i32] }):$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTILEMOVROWrri),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_CopyConstantAsSImm, /*NewInsnID*/0, /*OldInsnID*/1, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/2, /*MergeInsnID's*/0, 1,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17497,
        GIR_EraseRootFromParent_Done,
      // Label 1042: @36711
      GIM_Try, /*On fail goto*//*Label 1043*/ GIMT_Encode4(36756), // Rule ID 17486 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_tcvtrowd2ps),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[v16f32] } 14589:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, GR32:{ *:[i32] }:$src2)  =>  (PTCVTROWD2PSrre:{ *:[v16f32] } (timm:{ *:[i8] }):$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCVTROWD2PSrre),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17486,
        GIR_EraseRootFromParent_Done,
      // Label 1043: @36756
      GIM_Try, /*On fail goto*//*Label 1044*/ GIMT_Encode4(36801), // Rule ID 17493 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_tcvtrowps2phh),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v32s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[v32f16] } 14595:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, GR32:{ *:[i32] }:$src2)  =>  (PTCVTROWPS2PHHrre:{ *:[v32f16] } (timm:{ *:[i8] }):$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCVTROWPS2PHHrre),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17493,
        GIR_EraseRootFromParent_Done,
      // Label 1044: @36801
      GIM_Try, /*On fail goto*//*Label 1045*/ GIMT_Encode4(36846), // Rule ID 17495 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_tcvtrowps2phl),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v32s16,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[v32f16] } 14597:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, GR32:{ *:[i32] }:$src2)  =>  (PTCVTROWPS2PHLrre:{ *:[v32f16] } (timm:{ *:[i8] }):$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTCVTROWPS2PHLrre),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17495,
        GIR_EraseRootFromParent_Done,
      // Label 1045: @36846
      GIM_Try, /*On fail goto*//*Label 1046*/ GIMT_Encode4(36891), // Rule ID 17498 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAMXAVX512_HasAVX10_2_512_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/1, GIMT_Encode2(Intrinsic::x86_tilemovrow),
        GIM_RootCheckType, /*Op*/0, /*Type*/GILLT_v16s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
        // MIs[0] src1
        GIM_CheckIsImm, /*MI*/0, /*Op*/2,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_w_chain:{ *:[v16i32] } 14628:{ *:[iPTR] }, (timm:{ *:[i8] }):$src1, GR32:{ *:[i32] }:$src2)  =>  (PTILEMOVROWrre:{ *:[v16i32] } (timm:{ *:[i8] }):$src1, GR32:{ *:[i32] }:$src2)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::PTILEMOVROWrre),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // src2
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17498,
        GIR_EraseRootFromParent_Done,
      // Label 1046: @36891
      GIM_Try, /*On fail goto*//*Label 1047*/ GIMT_Encode4(36936), // Rule ID 122 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_lwpval32),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // MIs[0] cntl
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14269:{ *:[iPTR] }, GR32:{ *:[i32] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)  =>  (LWPVAL32rri GR32:{ *:[i32] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LWPVAL32rri),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // cntl
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 122,
        GIR_EraseRootFromParent_Done,
      // Label 1047: @36936
      GIM_Try, /*On fail goto*//*Label 1048*/ GIMT_Encode4(36981), // Rule ID 124 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasLWP),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_lwpval64),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // MIs[0] cntl
        GIM_CheckIsImm, /*MI*/0, /*Op*/3,
        // (intrinsic_void 14270:{ *:[iPTR] }, GR64:{ *:[i64] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)  =>  (LWPVAL64rri GR64:{ *:[i64] }:$src0, GR32:{ *:[i32] }:$src1, (timm:{ *:[i32] }):$cntl)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LWPVAL64rri),
        GIR_RootToRootCopy, /*OpIdx*/1, // src0
        GIR_RootToRootCopy, /*OpIdx*/2, // src1
        GIR_RootToRootCopy, /*OpIdx*/3, // cntl
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 124,
        GIR_EraseRootFromParent_Done,
      // Label 1048: @36981
      GIM_Try, /*On fail goto*//*Label 1049*/ GIMT_Encode4(37063), // Rule ID 17551 //
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_xsetbv),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32_ArgRef_and_GR32_CBRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32_AD_and_GR32_ArgRefRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32_ADRegClassID),
        // (intrinsic_void 14765:{ *:[iPTR] }, ECX:{ *:[i32] }, EDX:{ *:[i32] }, EAX:{ *:[i32] })  =>  (XSETBV)
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/3, GIMT_Encode2(X86::EAX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/3, /*OldInsnID*/0, /*OpIdx*/3, // EAX
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/2, GIMT_Encode2(X86::EDX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/2, // EDX
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::ECX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // ECX
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::XSETBV),
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17551,
        GIR_EraseRootFromParent_Done,
      // Label 1049: @37063
      GIM_Try, /*On fail goto*//*Label 1050*/ GIMT_Encode4(37112), // Rule ID 17740 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasMWAITX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_mwaitx),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s32,
        GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_s32,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
        // (intrinsic_void 14347:{ *:[iPTR] }, GR32:{ *:[i32] }:$ecx, GR32:{ *:[i32] }:$eax, GR32:{ *:[i32] }:$ebx)  =>  (MWAITX GR32:{ *:[i32] }:$ecx, GR32:{ *:[i32] }:$eax, GR32:{ *:[i32] }:$ebx)
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MWAITX),
        GIR_RootToRootCopy, /*OpIdx*/1, // ecx
        GIR_RootToRootCopy, /*OpIdx*/2, // eax
        GIR_RootToRootCopy, /*OpIdx*/3, // ebx
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 17740,
        GIR_EraseRootFromParent_Done,
      // Label 1050: @37112
      GIM_Try, /*On fail goto*//*Label 1051*/ GIMT_Encode4(37174), // Rule ID 2900 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX_In64BitMode),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64_with_sub_32bit_in_GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 14445:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, RDI:{ *:[i64] })  =>  (VMASKMOVDQU64 VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::RDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // RDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMASKMOVDQU64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2900,
        GIR_EraseRootFromParent_Done,
      // Label 1051: @37174
      GIM_Try, /*On fail goto*//*Label 1052*/ GIMT_Encode4(37236), // Rule ID 2901 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 14445:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, EDI:{ *:[i32] })  =>  (VMASKMOVDQU VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::EDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // EDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::VMASKMOVDQU),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2901,
        GIR_EraseRootFromParent_Done,
      // Label 1052: @37236
      GIM_Try, /*On fail goto*//*Label 1053*/ GIMT_Encode4(37298), // Rule ID 2902 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode_UseSSE2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/64,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR64_with_sub_32bit_in_GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 14445:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, RDI:{ *:[i64] })  =>  (MASKMOVDQU64 VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::RDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // RDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MASKMOVDQU64),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2902,
        GIR_EraseRootFromParent_Done,
      // Label 1053: @37298
      GIM_Try, /*On fail goto*//*Label 1054*/ GIMT_Encode4(37360), // Rule ID 2903 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_UseSSE2),
        GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_sse2_maskmov_dqu),
        GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s8,
        GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v16s8,
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
        // MIs[0] Operand 3
        GIM_CheckPointerToAny, /*MI*/0, /*Op*/3, /*SizeInBits*/32,
        GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::GR32_DIBP_and_GR32_SIDIRegClassID),
        // (intrinsic_void 14445:{ *:[iPTR] }, VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask, EDI:{ *:[i32] })  =>  (MASKMOVDQU VR128:{ *:[v16i8] }:$src, VR128:{ *:[v16i8] }:$mask)
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::EDI), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/3, // EDI
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::MASKMOVDQU),
        GIR_RootToRootCopy, /*OpIdx*/1, // src
        GIR_RootToRootCopy, /*OpIdx*/2, // mask
        GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 2903,
        GIR_EraseRootFromParent_Done,
      // Label 1054: @37360
      GIM_Reject,
    // Label 1019: @37361
    GIM_Try, /*On fail goto*//*Label 1055*/ GIMT_Encode4(37449), // Rule ID 17435 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasKL),
      GIM_CheckNumOperands, /*MI*/0, /*Expected*/5,
      GIM_CheckIntrinsicID, /*MI*/0, /*Op*/0, GIMT_Encode2(Intrinsic::x86_loadiwkey),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/3, /*Type*/GILLT_v2s64,
      GIM_RootCheckType, /*Op*/4, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/3, /*RC*/GIMT_Encode2(X86::VR128RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/4, /*RC*/GIMT_Encode2(X86::GR32_ADRegClassID),
      // (intrinsic_void 14266:{ *:[iPTR] }, XMM0:{ *:[v2i64] }, VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2, EAX:{ *:[i32] })  =>  (LOADIWKEY:{ *:[i32] } VR128:{ *:[v2i64] }:$src1, VR128:{ *:[v2i64] }:$src2)
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddRegister, /*InsnID*/2, GIMT_Encode2(X86::EAX), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/4, // EAX
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddRegister, /*InsnID*/1, GIMT_Encode2(X86::XMM0), /*AddRegisterRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // XMM0
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(X86::LOADIWKEY),
      GIR_RootToRootCopy, /*OpIdx*/2, // src1
      GIR_RootToRootCopy, /*OpIdx*/3, // src2
      GIR_SetImplicitDefDead, /*InsnID*/0, /*OpIdx for X86::EFLAGS*/0,
      GIR_MergeMemOperands, /*InsnID*/0, /*NumInsns*/1, /*MergeInsnID's*/0,
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 17435,
      GIR_EraseRootFromParent_Done,
    // Label 1055: @37449
    GIM_Reject,
    // Label 12: @37450
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(2), GIMT_Encode2(5), /*)*//*default:*//*Label 1059*/ GIMT_Encode4(37884),
    /*GILLT_s16*//*Label 1056*/ GIMT_Encode4(37473),
    /*GILLT_s32*//*Label 1057*/ GIMT_Encode4(37531),
    /*GILLT_s64*//*Label 1058*/ GIMT_Encode4(37706),
    // Label 1056: @37473
    GIM_Try, /*On fail goto*//*Label 1060*/ GIMT_Encode4(37530), // Rule ID 23014 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (anyext:{ *:[i16] } GR8:{ *:[i8] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } (MOVZX32rr8:{ *:[i32] } GR8:{ *:[i8] }:$src), sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_16bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 23014,
      GIR_EraseRootFromParent_Done,
    // Label 1060: @37530
    GIM_Reject,
    // Label 1057: @37531
    GIM_Try, /*On fail goto*//*Label 1061*/ GIMT_Encode4(37577), // Rule ID 19884 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (anyext:{ *:[i32] } (bitconvert:{ *:[i16] } VK16:{ *:[v16i1] }:$src))  =>  (COPY_TO_REGCLASS:{ *:[i32] } VK16:{ *:[v16i1] }:$src, GR32:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 19884,
      GIR_EraseRootFromParent_Done,
    // Label 1061: @37577
    GIM_Try, /*On fail goto*//*Label 1062*/ GIMT_Encode4(37623), // Rule ID 19887 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v8s1,
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK8RegClassID),
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (anyext:{ *:[i32] } (bitconvert:{ *:[i8] } VK8:{ *:[v8i1] }:$src))  =>  (COPY_TO_REGCLASS:{ *:[i32] } VK8:{ *:[v8i1] }:$src, GR32:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 19887,
      GIR_EraseRootFromParent_Done,
    // Label 1062: @37623
    GIM_Try, /*On fail goto*//*Label 1063*/ GIMT_Encode4(37646), // Rule ID 23015 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (anyext:{ *:[i32] } GR8:{ *:[i8] }:$src)  =>  (MOVZX32rr8:{ *:[i32] } GR8:{ *:[i8] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 23015,
      GIR_Done,
    // Label 1063: @37646
    GIM_Try, /*On fail goto*//*Label 1064*/ GIMT_Encode4(37705), // Rule ID 23016 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (anyext:{ *:[i32] } GR16:{ *:[i16] }:$src)  =>  (INSERT_SUBREG:{ *:[i32] } (IMPLICIT_DEF:{ *:[i32] }), GR16:{ *:[i16] }:$src, sub_16bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/4,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::LOW32_ADDR_ACCESS_RBPRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR16RegClassID),
      // GIR_Coverage, 23016,
      GIR_EraseRootFromParent_Done,
    // Label 1064: @37705
    GIM_Reject,
    // Label 1058: @37706
    GIM_Try, /*On fail goto*//*Label 1065*/ GIMT_Encode4(37765), // Rule ID 23017 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s8,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      // (anyext:{ *:[i64] } GR8:{ *:[i8] }:$src)  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (MOVZX32rr8:{ *:[i32] } GR8:{ *:[i8] }:$src), sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr8),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 23017,
      GIR_EraseRootFromParent_Done,
    // Label 1065: @37765
    GIM_Try, /*On fail goto*//*Label 1066*/ GIMT_Encode4(37824), // Rule ID 23018 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (anyext:{ *:[i64] } GR16:{ *:[i16] }:$src)  =>  (SUBREG_TO_REG:{ *:[i64] } 0:{ *:[i64] }, (MOVZX32rr16:{ *:[i32] } GR16:{ *:[i16] }:$src), sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::MOVZX32rr16),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::SUBREG_TO_REG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddImm8, /*InsnID*/0, /*Imm*/0,
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 23018,
      GIR_EraseRootFromParent_Done,
    // Label 1066: @37824
    GIM_Try, /*On fail goto*//*Label 1067*/ GIMT_Encode4(37883), // Rule ID 23019 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR64RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (anyext:{ *:[i64] } GR32:{ *:[i32] }:$src)  =>  (INSERT_SUBREG:{ *:[i64] } (IMPLICIT_DEF:{ *:[i64] }), GR32:{ *:[i32] }:$src, sub_32bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s64,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddSimpleTempRegister, /*InsnID*/0, /*TempRegID*/0,
      GIR_RootToRootCopy, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/0, /*Imm*/6,
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR64RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/2, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 23019,
      GIR_EraseRootFromParent_Done,
    // Label 1067: @37883
    GIM_Reject,
    // Label 1059: @37884
    GIM_Reject,
    // Label 13: @37885
    GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(1), GIMT_Encode2(22), /*)*//*default:*//*Label 1076*/ GIMT_Encode4(38897),
    /*GILLT_s8*//*Label 1068*/ GIMT_Encode4(37980),
    /*GILLT_s16*//*Label 1069*/ GIMT_Encode4(38264), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v4s32*//*Label 1070*/ GIMT_Encode4(38303), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v8s16*//*Label 1071*/ GIMT_Encode4(38443),
    /*GILLT_v8s32*//*Label 1072*/ GIMT_Encode4(38606), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v16s8*//*Label 1073*/ GIMT_Encode4(38633),
    /*GILLT_v16s16*//*Label 1074*/ GIMT_Encode4(38843), GIMT_Encode4(0), GIMT_Encode4(0),
    /*GILLT_v32s8*//*Label 1075*/ GIMT_Encode4(38870),
    // Label 1068: @37980
    GIM_Try, /*On fail goto*//*Label 1077*/ GIMT_Encode4(38055), // Rule ID 19879 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
      GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_BITCAST),
      GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v16s1,
      GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(X86::VK16RegClassID),
      GIM_CheckIsSafeToFold, /*NumInsns*/1,
      // (trunc:{ *:[i8] } (bitconvert:{ *:[i16] } VK16:{ *:[v16i1] }:$src))  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i32] } VK16:{ *:[v16i1] }:$src, GR32:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/1, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR32RegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 19879,
      GIR_EraseRootFromParent_Done,
    // Label 1077: @38055
    GIM_Try, /*On fail goto*//*Label 1078*/ GIMT_Encode4(38118), // Rule ID 23076 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8_ABCD_LRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (trunc:{ *:[i8] } GR32:{ *:[i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i32] } GR32:{ *:[i32] }:$src, GR32_ABCD:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s32,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR32_ABCDRegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8_ABCD_LRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32_ABCDRegClassID),
      // GIR_Coverage, 23076,
      GIR_EraseRootFromParent_Done,
    // Label 1078: @38118
    GIM_Try, /*On fail goto*//*Label 1079*/ GIMT_Encode4(38181), // Rule ID 23077 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_Not64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8_ABCD_LRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (trunc:{ *:[i8] } GR16:{ *:[i16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } (COPY_TO_REGCLASS:{ *:[i16] } GR16:{ *:[i16] }:$src, GR16_ABCD:{ *:[i32] }), sub_8bit:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_Copy, /*NewInsnID*/1, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_ConstrainOperandRC, /*InsnID*/1, /*Op*/0, GIMT_Encode2(X86::GR16_ABCDRegClassID),
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_8bit),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8_ABCD_LRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR16_ABCDRegClassID),
      // GIR_Coverage, 23077,
      GIR_EraseRootFromParent_Done,
    // Label 1079: @38181
    GIM_Try, /*On fail goto*//*Label 1080*/ GIMT_Encode4(38222), // Rule ID 23081 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (trunc:{ *:[i8] } GR32:{ *:[i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } GR32:{ *:[i32] }:$src, sub_8bit:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 23081,
      GIR_EraseRootFromParent_Done,
    // Label 1080: @38222
    GIM_Try, /*On fail goto*//*Label 1081*/ GIMT_Encode4(38263), // Rule ID 23082 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_In64BitMode),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR8RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      // (trunc:{ *:[i8] } GR16:{ *:[i16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i8] } GR16:{ *:[i16] }:$src, sub_8bit:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(1), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR8RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR16RegClassID),
      // GIR_Coverage, 23082,
      GIR_EraseRootFromParent_Done,
    // Label 1081: @38263
    GIM_Reject,
    // Label 1069: @38264
    GIM_Try, /*On fail goto*//*Label 1082*/ GIMT_Encode4(38302), // Rule ID 23075 //
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::GR16RegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::GR32RegClassID),
      // (trunc:{ *:[i16] } GR32:{ *:[i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[i16] } GR32:{ *:[i32] }:$src, sub_16bit:{ *:[i32] })
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_CopySubReg, /*NewInsnID*/0, /*OldInsnID*/0, /*OpIdx*/1, /*SubRegIdx*/GIMT_Encode2(4), // src
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::GR16RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::GR32RegClassID),
      // GIR_Coverage, 23075,
      GIR_EraseRootFromParent_Done,
    // Label 1082: @38302
    GIM_Reject,
    // Label 1070: @38303
    GIM_Try, /*On fail goto*//*Label 1083*/ GIMT_Encode4(38442),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v4s64,
      GIM_Try, /*On fail goto*//*Label 1084*/ GIMT_Encode4(38334), // Rule ID 12259 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (trunc:{ *:[v4i32] } VR256X:{ *:[v4i64] }:$src)  =>  (VPMOVQDZ256rr:{ *:[v4i32] } VR256X:{ *:[v4i64] }:$src)
        GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVQDZ256rr),
        GIR_RootConstrainSelectedInstOperands,
        // GIR_Coverage, 12259,
        GIR_Done,
      // Label 1084: @38334
      GIM_Try, /*On fail goto*//*Label 1085*/ GIMT_Encode4(38441), // Rule ID 22004 //
        GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
        GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
        GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
        // (trunc:{ *:[v4i32] } VR256X:{ *:[v4i64] }:$src)  =>  (EXTRACT_SUBREG:{ *:[v4i32] } (VPMOVQDZrr:{ *:[v8i32] } (INSERT_SUBREG:{ *:[v8i64] } (IMPLICIT_DEF:{ *:[v8i64] }), VR256X:{ *:[v4i64] }:$src, sub_ymm:{ *:[i32] })), sub_xmm:{ *:[i32] })
        GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
        GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
        GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v8s64,
        GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
        GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
        GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
        GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
        GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v8s32,
        GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVQDZrr),
        GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
        GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
        GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
        GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
        GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
        GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
        GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR256XRegClassID),
        // GIR_Coverage, 22004,
        GIR_EraseRootFromParent_Done,
      // Label 1085: @38441
      GIM_Reject,
    // Label 1083: @38442
    GIM_Reject,
    // Label 1071: @38443
    GIM_Try, /*On fail goto*//*Label 1086*/ GIMT_Encode4(38469), // Rule ID 12235 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v8i16] } VR512:{ *:[v8i64] }:$src)  =>  (VPMOVQWZrr:{ *:[v8i16] } VR512:{ *:[v8i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVQWZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12235,
      GIR_Done,
    // Label 1086: @38469
    GIM_Try, /*On fail goto*//*Label 1087*/ GIMT_Encode4(38495), // Rule ID 12313 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v8i16] } VR256X:{ *:[v8i32] }:$src)  =>  (VPMOVDWZ256rr:{ *:[v8i16] } VR256X:{ *:[v8i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVDWZ256rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12313,
      GIR_Done,
    // Label 1087: @38495
    GIM_Try, /*On fail goto*//*Label 1088*/ GIMT_Encode4(38605), // Rule ID 22003 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_HasEVEX512_NoVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v8i16] } VR256X:{ *:[v8i32] }:$src)  =>  (EXTRACT_SUBREG:{ *:[v8i16] } (VPMOVDWZrr:{ *:[v16i16] } (INSERT_SUBREG:{ *:[v16i32] } (IMPLICIT_DEF:{ *:[v16i32] }), VR256X:{ *:[v8i32] }:$src, sub_ymm:{ *:[i32] })), sub_xmm:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v16s32,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v16s32,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v16s16,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVDWZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR256XRegClassID),
      // GIR_Coverage, 22003,
      GIR_EraseRootFromParent_Done,
    // Label 1088: @38605
    GIM_Reject,
    // Label 1072: @38606
    GIM_Try, /*On fail goto*//*Label 1089*/ GIMT_Encode4(38632), // Rule ID 12262 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v8s64,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v8i32] } VR512:{ *:[v8i64] }:$src)  =>  (VPMOVQDZrr:{ *:[v8i32] } VR512:{ *:[v8i64] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVQDZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12262,
      GIR_Done,
    // Label 1089: @38632
    GIM_Reject,
    // Label 1073: @38633
    GIM_Try, /*On fail goto*//*Label 1090*/ GIMT_Encode4(38659), // Rule ID 12289 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s32,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR512RegClassID),
      // (trunc:{ *:[v16i8] } VR512:{ *:[v16i32] }:$src)  =>  (VPMOVDBZrr:{ *:[v16i8] } VR512:{ *:[v16i32] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVDBZrr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12289,
      GIR_Done,
    // Label 1090: @38659
    GIM_Try, /*On fail goto*//*Label 1091*/ GIMT_Encode4(38685), // Rule ID 12340 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)  =>  (VPMOVWBZ256rr:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)
      GIR_MutateOpcode, /*InsnID*/0, /*RecycleInsnID*/0, /*Opcode*/GIMT_Encode2(X86::VPMOVWBZ256rr),
      GIR_RootConstrainSelectedInstOperands,
      // GIR_Coverage, 12340,
      GIR_Done,
    // Label 1091: @38685
    GIM_Try, /*On fail goto*//*Label 1092*/ GIMT_Encode4(38795), // Rule ID 22005 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasBWI_HasEVEX512_NoVLX),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::FR16XRegClassID),
      GIM_RootCheckRegBankForClass, /*Op*/1, /*RC*/GIMT_Encode2(X86::VR256XRegClassID),
      // (trunc:{ *:[v16i8] } VR256X:{ *:[v16i16] }:$src)  =>  (EXTRACT_SUBREG:{ *:[v16i8] } (VPMOVWBZrr:{ *:[v32i8] } (INSERT_SUBREG:{ *:[v32i16] } (IMPLICIT_DEF:{ *:[v32i16] }), VR256X:{ *:[v16i16] }:$src, sub_ymm:{ *:[i32] })), sub_xmm:{ *:[i32] })
      GIR_MakeTempReg, /*TempRegID*/2, /*TypeID*/GILLT_v32s16,
      GIR_BuildMI, /*InsnID*/3, /*Opcode*/GIMT_Encode2(TargetOpcode::IMPLICIT_DEF),
      GIR_AddTempRegister, /*InsnID*/3, /*TempRegID*/2, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_ConstrainSelectedInstOperands, /*InsnID*/3,
      GIR_MakeTempReg, /*TempRegID*/1, /*TypeID*/GILLT_v32s16,
      GIR_BuildMI, /*InsnID*/2, /*Opcode*/GIMT_Encode2(TargetOpcode::INSERT_SUBREG),
      GIR_AddTempRegister, /*InsnID*/2, /*TempRegID*/1, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/2, /*TempRegID*/2,
      GIR_Copy, /*NewInsnID*/2, /*OldInsnID*/0, /*OpIdx*/1, // src
      GIR_AddImm8, /*InsnID*/2, /*Imm*/12,
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/0, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/1, GIMT_Encode2(X86::VR512RegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/2, /*Op*/2, GIMT_Encode2(X86::VR256XRegClassID),
      GIR_MakeTempReg, /*TempRegID*/0, /*TypeID*/GILLT_v32s8,
      GIR_BuildMI, /*InsnID*/1, /*Opcode*/GIMT_Encode2(X86::VPMOVWBZrr),
      GIR_AddTempRegister, /*InsnID*/1, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(RegState::Define),
      GIR_AddSimpleTempRegister, /*InsnID*/1, /*TempRegID*/1,
      GIR_ConstrainSelectedInstOperands, /*InsnID*/1,
      GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(TargetOpcode::COPY),
      GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
      GIR_AddTempSubRegister, /*InsnID*/0, /*TempRegID*/0, /*TempRegFlags*/GIMT_Encode2(0), GIMT_Encode2(X86::sub_xmm),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/0, GIMT_Encode2(X86::FR16XRegClassID),
      GIR_ConstrainOperandRC, /*InsnID*/0, /*Op*/1, GIMT_Encode2(X86::VR256XRegClassID),
      // GIR_Coverage, 22005,
      GIR_EraseRootFromParent_Done,
    // Label 1092: @38795
    GIM_Try, /*On fail goto*//*Label 1093*/ GIMT_Encode4(38842), // Rule ID 22096 //
      GIM_CheckFeatures, GIMT_Encode2(GIFBS_HasAVX512_NoBWI),
      GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v16s16,
      GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(X86::VR128XRegCla