/* This file is autogenerated by scripts/decodetree.py.  */

typedef struct {
    int df;
    int wd;
    int ws;
    int m;
} arg_msa_bit;

typedef struct {
    int df;
    int wt;
    int sa;
} arg_msa_bz;

typedef struct {
    int wd;
    int ws;
} arg_msa_elm;

typedef struct {
    int df;
    int wd;
    int ws;
    int n;
} arg_msa_elm_df;

typedef struct {
    int df;
    int wd;
    int ws;
    int sa;
} arg_msa_i;

typedef struct {
    int df;
    int wd;
    int sa;
} arg_msa_ldi;

typedef struct {
    int df;
    int wd;
    int ws;
    int wt;
} arg_msa_r;

typedef struct {
    int rs;
    int rt;
    int rd;
    int sa;
} arg_r;

typedef arg_r arg_LSA;
static bool trans_LSA(DisasContext *ctx, arg_LSA *a);
typedef arg_r arg_DLSA;
static bool trans_DLSA(DisasContext *ctx, arg_DLSA *a);
typedef arg_msa_bz arg_BZ_V;
static bool trans_BZ_V(DisasContext *ctx, arg_BZ_V *a);
typedef arg_msa_bz arg_BNZ_V;
static bool trans_BNZ_V(DisasContext *ctx, arg_BNZ_V *a);
typedef arg_msa_bz arg_BZ;
static bool trans_BZ(DisasContext *ctx, arg_BZ *a);
typedef arg_msa_bz arg_BNZ;
static bool trans_BNZ(DisasContext *ctx, arg_BNZ *a);
typedef arg_msa_i arg_ANDI;
static bool trans_ANDI(DisasContext *ctx, arg_ANDI *a);
typedef arg_msa_i arg_ORI;
static bool trans_ORI(DisasContext *ctx, arg_ORI *a);
typedef arg_msa_i arg_NORI;
static bool trans_NORI(DisasContext *ctx, arg_NORI *a);
typedef arg_msa_i arg_XORI;
static bool trans_XORI(DisasContext *ctx, arg_XORI *a);
typedef arg_msa_i arg_BMNZI;
static bool trans_BMNZI(DisasContext *ctx, arg_BMNZI *a);
typedef arg_msa_i arg_BMZI;
static bool trans_BMZI(DisasContext *ctx, arg_BMZI *a);
typedef arg_msa_i arg_BSELI;
static bool trans_BSELI(DisasContext *ctx, arg_BSELI *a);
typedef arg_msa_i arg_SHF;
static bool trans_SHF(DisasContext *ctx, arg_SHF *a);
typedef arg_msa_i arg_ADDVI;
static bool trans_ADDVI(DisasContext *ctx, arg_ADDVI *a);
typedef arg_msa_i arg_SUBVI;
static bool trans_SUBVI(DisasContext *ctx, arg_SUBVI *a);
typedef arg_msa_i arg_MAXI_S;
static bool trans_MAXI_S(DisasContext *ctx, arg_MAXI_S *a);
typedef arg_msa_i arg_MAXI_U;
static bool trans_MAXI_U(DisasContext *ctx, arg_MAXI_U *a);
typedef arg_msa_i arg_MINI_S;
static bool trans_MINI_S(DisasContext *ctx, arg_MINI_S *a);
typedef arg_msa_i arg_MINI_U;
static bool trans_MINI_U(DisasContext *ctx, arg_MINI_U *a);
typedef arg_msa_i arg_CEQI;
static bool trans_CEQI(DisasContext *ctx, arg_CEQI *a);
typedef arg_msa_i arg_CLTI_S;
static bool trans_CLTI_S(DisasContext *ctx, arg_CLTI_S *a);
typedef arg_msa_i arg_CLTI_U;
static bool trans_CLTI_U(DisasContext *ctx, arg_CLTI_U *a);
typedef arg_msa_i arg_CLEI_S;
static bool trans_CLEI_S(DisasContext *ctx, arg_CLEI_S *a);
typedef arg_msa_i arg_CLEI_U;
static bool trans_CLEI_U(DisasContext *ctx, arg_CLEI_U *a);
typedef arg_msa_ldi arg_LDI;
static bool trans_LDI(DisasContext *ctx, arg_LDI *a);
typedef arg_msa_bit arg_SLLI;
static bool trans_SLLI(DisasContext *ctx, arg_SLLI *a);
typedef arg_msa_bit arg_SRAI;
static bool trans_SRAI(DisasContext *ctx, arg_SRAI *a);
typedef arg_msa_bit arg_SRLI;
static bool trans_SRLI(DisasContext *ctx, arg_SRLI *a);
typedef arg_msa_bit arg_BCLRI;
static bool trans_BCLRI(DisasContext *ctx, arg_BCLRI *a);
typedef arg_msa_bit arg_BSETI;
static bool trans_BSETI(DisasContext *ctx, arg_BSETI *a);
typedef arg_msa_bit arg_BNEGI;
static bool trans_BNEGI(DisasContext *ctx, arg_BNEGI *a);
typedef arg_msa_bit arg_BINSLI;
static bool trans_BINSLI(DisasContext *ctx, arg_BINSLI *a);
typedef arg_msa_bit arg_BINSRI;
static bool trans_BINSRI(DisasContext *ctx, arg_BINSRI *a);
typedef arg_msa_bit arg_SAT_S;
static bool trans_SAT_S(DisasContext *ctx, arg_SAT_S *a);
typedef arg_msa_bit arg_SAT_U;
static bool trans_SAT_U(DisasContext *ctx, arg_SAT_U *a);
typedef arg_msa_bit arg_SRARI;
static bool trans_SRARI(DisasContext *ctx, arg_SRARI *a);
typedef arg_msa_bit arg_SRLRI;
static bool trans_SRLRI(DisasContext *ctx, arg_SRLRI *a);
typedef arg_msa_r arg_SLL;
static bool trans_SLL(DisasContext *ctx, arg_SLL *a);
typedef arg_msa_r arg_SRA;
static bool trans_SRA(DisasContext *ctx, arg_SRA *a);
typedef arg_msa_r arg_SRL;
static bool trans_SRL(DisasContext *ctx, arg_SRL *a);
typedef arg_msa_r arg_BCLR;
static bool trans_BCLR(DisasContext *ctx, arg_BCLR *a);
typedef arg_msa_r arg_BSET;
static bool trans_BSET(DisasContext *ctx, arg_BSET *a);
typedef arg_msa_r arg_BNEG;
static bool trans_BNEG(DisasContext *ctx, arg_BNEG *a);
typedef arg_msa_r arg_BINSL;
static bool trans_BINSL(DisasContext *ctx, arg_BINSL *a);
typedef arg_msa_r arg_BINSR;
static bool trans_BINSR(DisasContext *ctx, arg_BINSR *a);
typedef arg_msa_r arg_ADDV;
static bool trans_ADDV(DisasContext *ctx, arg_ADDV *a);
typedef arg_msa_r arg_SUBV;
static bool trans_SUBV(DisasContext *ctx, arg_SUBV *a);
typedef arg_msa_r arg_MAX_S;
static bool trans_MAX_S(DisasContext *ctx, arg_MAX_S *a);
typedef arg_msa_r arg_MAX_U;
static bool trans_MAX_U(DisasContext *ctx, arg_MAX_U *a);
typedef arg_msa_r arg_MIN_S;
static bool trans_MIN_S(DisasContext *ctx, arg_MIN_S *a);
typedef arg_msa_r arg_MIN_U;
static bool trans_MIN_U(DisasContext *ctx, arg_MIN_U *a);
typedef arg_msa_r arg_MAX_A;
static bool trans_MAX_A(DisasContext *ctx, arg_MAX_A *a);
typedef arg_msa_r arg_MIN_A;
static bool trans_MIN_A(DisasContext *ctx, arg_MIN_A *a);
typedef arg_msa_r arg_CEQ;
static bool trans_CEQ(DisasContext *ctx, arg_CEQ *a);
typedef arg_msa_r arg_CLT_S;
static bool trans_CLT_S(DisasContext *ctx, arg_CLT_S *a);
typedef arg_msa_r arg_CLT_U;
static bool trans_CLT_U(DisasContext *ctx, arg_CLT_U *a);
typedef arg_msa_r arg_CLE_S;
static bool trans_CLE_S(DisasContext *ctx, arg_CLE_S *a);
typedef arg_msa_r arg_CLE_U;
static bool trans_CLE_U(DisasContext *ctx, arg_CLE_U *a);
typedef arg_msa_r arg_ADD_A;
static bool trans_ADD_A(DisasContext *ctx, arg_ADD_A *a);
typedef arg_msa_r arg_ADDS_A;
static bool trans_ADDS_A(DisasContext *ctx, arg_ADDS_A *a);
typedef arg_msa_r arg_ADDS_S;
static bool trans_ADDS_S(DisasContext *ctx, arg_ADDS_S *a);
typedef arg_msa_r arg_ADDS_U;
static bool trans_ADDS_U(DisasContext *ctx, arg_ADDS_U *a);
typedef arg_msa_r arg_AVE_S;
static bool trans_AVE_S(DisasContext *ctx, arg_AVE_S *a);
typedef arg_msa_r arg_AVE_U;
static bool trans_AVE_U(DisasContext *ctx, arg_AVE_U *a);
typedef arg_msa_r arg_AVER_S;
static bool trans_AVER_S(DisasContext *ctx, arg_AVER_S *a);
typedef arg_msa_r arg_AVER_U;
static bool trans_AVER_U(DisasContext *ctx, arg_AVER_U *a);
typedef arg_msa_r arg_SUBS_S;
static bool trans_SUBS_S(DisasContext *ctx, arg_SUBS_S *a);
typedef arg_msa_r arg_SUBS_U;
static bool trans_SUBS_U(DisasContext *ctx, arg_SUBS_U *a);
typedef arg_msa_r arg_SUBSUS_U;
static bool trans_SUBSUS_U(DisasContext *ctx, arg_SUBSUS_U *a);
typedef arg_msa_r arg_SUBSUU_S;
static bool trans_SUBSUU_S(DisasContext *ctx, arg_SUBSUU_S *a);
typedef arg_msa_r arg_ASUB_S;
static bool trans_ASUB_S(DisasContext *ctx, arg_ASUB_S *a);
typedef arg_msa_r arg_ASUB_U;
static bool trans_ASUB_U(DisasContext *ctx, arg_ASUB_U *a);
typedef arg_msa_r arg_MULV;
static bool trans_MULV(DisasContext *ctx, arg_MULV *a);
typedef arg_msa_r arg_MADDV;
static bool trans_MADDV(DisasContext *ctx, arg_MADDV *a);
typedef arg_msa_r arg_MSUBV;
static bool trans_MSUBV(DisasContext *ctx, arg_MSUBV *a);
typedef arg_msa_r arg_DIV_S;
static bool trans_DIV_S(DisasContext *ctx, arg_DIV_S *a);
typedef arg_msa_r arg_DIV_U;
static bool trans_DIV_U(DisasContext *ctx, arg_DIV_U *a);
typedef arg_msa_r arg_MOD_S;
static bool trans_MOD_S(DisasContext *ctx, arg_MOD_S *a);
typedef arg_msa_r arg_MOD_U;
static bool trans_MOD_U(DisasContext *ctx, arg_MOD_U *a);
typedef arg_msa_r arg_DOTP_S;
static bool trans_DOTP_S(DisasContext *ctx, arg_DOTP_S *a);
typedef arg_msa_r arg_DOTP_U;
static bool trans_DOTP_U(DisasContext *ctx, arg_DOTP_U *a);
typedef arg_msa_r arg_DPADD_S;
static bool trans_DPADD_S(DisasContext *ctx, arg_DPADD_S *a);
typedef arg_msa_r arg_DPADD_U;
static bool trans_DPADD_U(DisasContext *ctx, arg_DPADD_U *a);
typedef arg_msa_r arg_DPSUB_S;
static bool trans_DPSUB_S(DisasContext *ctx, arg_DPSUB_S *a);
typedef arg_msa_r arg_DPSUB_U;
static bool trans_DPSUB_U(DisasContext *ctx, arg_DPSUB_U *a);
typedef arg_msa_r arg_SLD;
static bool trans_SLD(DisasContext *ctx, arg_SLD *a);
typedef arg_msa_r arg_SPLAT;
static bool trans_SPLAT(DisasContext *ctx, arg_SPLAT *a);
typedef arg_msa_r arg_PCKEV;
static bool trans_PCKEV(DisasContext *ctx, arg_PCKEV *a);
typedef arg_msa_r arg_PCKOD;
static bool trans_PCKOD(DisasContext *ctx, arg_PCKOD *a);
typedef arg_msa_r arg_ILVL;
static bool trans_ILVL(DisasContext *ctx, arg_ILVL *a);
typedef arg_msa_r arg_ILVR;
static bool trans_ILVR(DisasContext *ctx, arg_ILVR *a);
typedef arg_msa_r arg_ILVEV;
static bool trans_ILVEV(DisasContext *ctx, arg_ILVEV *a);
typedef arg_msa_r arg_ILVOD;
static bool trans_ILVOD(DisasContext *ctx, arg_ILVOD *a);
typedef arg_msa_r arg_VSHF;
static bool trans_VSHF(DisasContext *ctx, arg_VSHF *a);
typedef arg_msa_r arg_SRAR;
static bool trans_SRAR(DisasContext *ctx, arg_SRAR *a);
typedef arg_msa_r arg_SRLR;
static bool trans_SRLR(DisasContext *ctx, arg_SRLR *a);
typedef arg_msa_r arg_HADD_S;
static bool trans_HADD_S(DisasContext *ctx, arg_HADD_S *a);
typedef arg_msa_r arg_HADD_U;
static bool trans_HADD_U(DisasContext *ctx, arg_HADD_U *a);
typedef arg_msa_r arg_HSUB_S;
static bool trans_HSUB_S(DisasContext *ctx, arg_HSUB_S *a);
typedef arg_msa_r arg_HSUB_U;
static bool trans_HSUB_U(DisasContext *ctx, arg_HSUB_U *a);
typedef arg_msa_elm arg_CTCMSA;
static bool trans_CTCMSA(DisasContext *ctx, arg_CTCMSA *a);
typedef arg_msa_elm_df arg_SLDI;
static bool trans_SLDI(DisasContext *ctx, arg_SLDI *a);
typedef arg_msa_elm arg_CFCMSA;
static bool trans_CFCMSA(DisasContext *ctx, arg_CFCMSA *a);
typedef arg_msa_elm_df arg_SPLATI;
static bool trans_SPLATI(DisasContext *ctx, arg_SPLATI *a);
typedef arg_msa_elm arg_MOVE_V;
static bool trans_MOVE_V(DisasContext *ctx, arg_MOVE_V *a);
typedef arg_msa_elm_df arg_COPY_S;
static bool trans_COPY_S(DisasContext *ctx, arg_COPY_S *a);
typedef arg_msa_elm_df arg_COPY_U;
static bool trans_COPY_U(DisasContext *ctx, arg_COPY_U *a);
typedef arg_msa_elm_df arg_INSERT;
static bool trans_INSERT(DisasContext *ctx, arg_INSERT *a);
typedef arg_msa_elm_df arg_INSVE;
static bool trans_INSVE(DisasContext *ctx, arg_INSVE *a);
typedef arg_msa_r arg_FCAF;
static bool trans_FCAF(DisasContext *ctx, arg_FCAF *a);
typedef arg_msa_r arg_FCUN;
static bool trans_FCUN(DisasContext *ctx, arg_FCUN *a);
typedef arg_msa_r arg_FCEQ;
static bool trans_FCEQ(DisasContext *ctx, arg_FCEQ *a);
typedef arg_msa_r arg_FCUEQ;
static bool trans_FCUEQ(DisasContext *ctx, arg_FCUEQ *a);
typedef arg_msa_r arg_FCLT;
static bool trans_FCLT(DisasContext *ctx, arg_FCLT *a);
typedef arg_msa_r arg_FCULT;
static bool trans_FCULT(DisasContext *ctx, arg_FCULT *a);
typedef arg_msa_r arg_FCLE;
static bool trans_FCLE(DisasContext *ctx, arg_FCLE *a);
typedef arg_msa_r arg_FCULE;
static bool trans_FCULE(DisasContext *ctx, arg_FCULE *a);
typedef arg_msa_r arg_FSAF;
static bool trans_FSAF(DisasContext *ctx, arg_FSAF *a);
typedef arg_msa_r arg_FSUN;
static bool trans_FSUN(DisasContext *ctx, arg_FSUN *a);
typedef arg_msa_r arg_FSEQ;
static bool trans_FSEQ(DisasContext *ctx, arg_FSEQ *a);
typedef arg_msa_r arg_FSUEQ;
static bool trans_FSUEQ(DisasContext *ctx, arg_FSUEQ *a);
typedef arg_msa_r arg_FSLT;
static bool trans_FSLT(DisasContext *ctx, arg_FSLT *a);
typedef arg_msa_r arg_FSULT;
static bool trans_FSULT(DisasContext *ctx, arg_FSULT *a);
typedef arg_msa_r arg_FSLE;
static bool trans_FSLE(DisasContext *ctx, arg_FSLE *a);
typedef arg_msa_r arg_FSULE;
static bool trans_FSULE(DisasContext *ctx, arg_FSULE *a);
typedef arg_msa_r arg_FADD;
static bool trans_FADD(DisasContext *ctx, arg_FADD *a);
typedef arg_msa_r arg_FSUB;
static bool trans_FSUB(DisasContext *ctx, arg_FSUB *a);
typedef arg_msa_r arg_FMUL;
static bool trans_FMUL(DisasContext *ctx, arg_FMUL *a);
typedef arg_msa_r arg_FDIV;
static bool trans_FDIV(DisasContext *ctx, arg_FDIV *a);
typedef arg_msa_r arg_FMADD;
static bool trans_FMADD(DisasContext *ctx, arg_FMADD *a);
typedef arg_msa_r arg_FMSUB;
static bool trans_FMSUB(DisasContext *ctx, arg_FMSUB *a);
typedef arg_msa_r arg_FEXP2;
static bool trans_FEXP2(DisasContext *ctx, arg_FEXP2 *a);
typedef arg_msa_r arg_FEXDO;
static bool trans_FEXDO(DisasContext *ctx, arg_FEXDO *a);
typedef arg_msa_r arg_FTQ;
static bool trans_FTQ(DisasContext *ctx, arg_FTQ *a);
typedef arg_msa_r arg_FMIN;
static bool trans_FMIN(DisasContext *ctx, arg_FMIN *a);
typedef arg_msa_r arg_FMIN_A;
static bool trans_FMIN_A(DisasContext *ctx, arg_FMIN_A *a);
typedef arg_msa_r arg_FMAX;
static bool trans_FMAX(DisasContext *ctx, arg_FMAX *a);
typedef arg_msa_r arg_FMAX_A;
static bool trans_FMAX_A(DisasContext *ctx, arg_FMAX_A *a);
typedef arg_msa_r arg_FCOR;
static bool trans_FCOR(DisasContext *ctx, arg_FCOR *a);
typedef arg_msa_r arg_FCUNE;
static bool trans_FCUNE(DisasContext *ctx, arg_FCUNE *a);
typedef arg_msa_r arg_FCNE;
static bool trans_FCNE(DisasContext *ctx, arg_FCNE *a);
typedef arg_msa_r arg_MUL_Q;
static bool trans_MUL_Q(DisasContext *ctx, arg_MUL_Q *a);
typedef arg_msa_r arg_MADD_Q;
static bool trans_MADD_Q(DisasContext *ctx, arg_MADD_Q *a);
typedef arg_msa_r arg_MSUB_Q;
static bool trans_MSUB_Q(DisasContext *ctx, arg_MSUB_Q *a);
typedef arg_msa_r arg_FSOR;
static bool trans_FSOR(DisasContext *ctx, arg_FSOR *a);
typedef arg_msa_r arg_FSUNE;
static bool trans_FSUNE(DisasContext *ctx, arg_FSUNE *a);
typedef arg_msa_r arg_FSNE;
static bool trans_FSNE(DisasContext *ctx, arg_FSNE *a);
typedef arg_msa_r arg_MULR_Q;
static bool trans_MULR_Q(DisasContext *ctx, arg_MULR_Q *a);
typedef arg_msa_r arg_MADDR_Q;
static bool trans_MADDR_Q(DisasContext *ctx, arg_MADDR_Q *a);
typedef arg_msa_r arg_MSUBR_Q;
static bool trans_MSUBR_Q(DisasContext *ctx, arg_MSUBR_Q *a);
typedef arg_msa_r arg_AND_V;
static bool trans_AND_V(DisasContext *ctx, arg_AND_V *a);
typedef arg_msa_r arg_OR_V;
static bool trans_OR_V(DisasContext *ctx, arg_OR_V *a);
typedef arg_msa_r arg_NOR_V;
static bool trans_NOR_V(DisasContext *ctx, arg_NOR_V *a);
typedef arg_msa_r arg_XOR_V;
static bool trans_XOR_V(DisasContext *ctx, arg_XOR_V *a);
typedef arg_msa_r arg_BMNZ_V;
static bool trans_BMNZ_V(DisasContext *ctx, arg_BMNZ_V *a);
typedef arg_msa_r arg_BMZ_V;
static bool trans_BMZ_V(DisasContext *ctx, arg_BMZ_V *a);
typedef arg_msa_r arg_BSEL_V;
static bool trans_BSEL_V(DisasContext *ctx, arg_BSEL_V *a);
typedef arg_msa_r arg_FILL;
static bool trans_FILL(DisasContext *ctx, arg_FILL *a);
typedef arg_msa_r arg_PCNT;
static bool trans_PCNT(DisasContext *ctx, arg_PCNT *a);
typedef arg_msa_r arg_NLOC;
static bool trans_NLOC(DisasContext *ctx, arg_NLOC *a);
typedef arg_msa_r arg_NLZC;
static bool trans_NLZC(DisasContext *ctx, arg_NLZC *a);
typedef arg_msa_r arg_FCLASS;
static bool trans_FCLASS(DisasContext *ctx, arg_FCLASS *a);
typedef arg_msa_r arg_FTRUNC_S;
static bool trans_FTRUNC_S(DisasContext *ctx, arg_FTRUNC_S *a);
typedef arg_msa_r arg_FTRUNC_U;
static bool trans_FTRUNC_U(DisasContext *ctx, arg_FTRUNC_U *a);
typedef arg_msa_r arg_FSQRT;
static bool trans_FSQRT(DisasContext *ctx, arg_FSQRT *a);
typedef arg_msa_r arg_FRSQRT;
static bool trans_FRSQRT(DisasContext *ctx, arg_FRSQRT *a);
typedef arg_msa_r arg_FRCP;
static bool trans_FRCP(DisasContext *ctx, arg_FRCP *a);
typedef arg_msa_r arg_FRINT;
static bool trans_FRINT(DisasContext *ctx, arg_FRINT *a);
typedef arg_msa_r arg_FLOG2;
static bool trans_FLOG2(DisasContext *ctx, arg_FLOG2 *a);
typedef arg_msa_r arg_FEXUPL;
static bool trans_FEXUPL(DisasContext *ctx, arg_FEXUPL *a);
typedef arg_msa_r arg_FEXUPR;
static bool trans_FEXUPR(DisasContext *ctx, arg_FEXUPR *a);
typedef arg_msa_r arg_FFQL;
static bool trans_FFQL(DisasContext *ctx, arg_FFQL *a);
typedef arg_msa_r arg_FFQR;
static bool trans_FFQR(DisasContext *ctx, arg_FFQR *a);
typedef arg_msa_r arg_FTINT_S;
static bool trans_FTINT_S(DisasContext *ctx, arg_FTINT_S *a);
typedef arg_msa_r arg_FTINT_U;
static bool trans_FTINT_U(DisasContext *ctx, arg_FTINT_U *a);
typedef arg_msa_r arg_FFINT_S;
static bool trans_FFINT_S(DisasContext *ctx, arg_FFINT_S *a);
typedef arg_msa_r arg_FFINT_U;
static bool trans_FFINT_U(DisasContext *ctx, arg_FFINT_U *a);
typedef arg_msa_i arg_LD;
static bool trans_LD(DisasContext *ctx, arg_LD *a);
typedef arg_msa_i arg_ST;
static bool trans_ST(DisasContext *ctx, arg_ST *a);

static void decode_ase_msa_extract_2r(DisasContext *ctx, arg_msa_r *a, uint32_t insn)
{
    a->wt = 0;
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = extract32(insn, 16, 2);
}

static void decode_ase_msa_extract_2rf(DisasContext *ctx, arg_msa_r *a, uint32_t insn)
{
    a->wt = 0;
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = plus_2(ctx, extract32(insn, 16, 1));
}

static void decode_ase_msa_extract_3r(DisasContext *ctx, arg_msa_r *a, uint32_t insn)
{
    a->wt = extract32(insn, 16, 5);
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = extract32(insn, 21, 2);
}

static void decode_ase_msa_extract_3rf_h(DisasContext *ctx, arg_msa_r *a, uint32_t insn)
{
    a->wt = extract32(insn, 16, 5);
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = plus_1(ctx, extract32(insn, 21, 1));
}

static void decode_ase_msa_extract_3rf_w(DisasContext *ctx, arg_msa_r *a, uint32_t insn)
{
    a->wt = extract32(insn, 16, 5);
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = plus_2(ctx, extract32(insn, 21, 1));
}

static void decode_ase_msa_extract_bit(DisasContext *ctx, arg_msa_bit *a, uint32_t insn)
{
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = bit_df(ctx, extract32(insn, 16, 7));
    a->m = bit_m(ctx, extract32(insn, 16, 7));
}

static void decode_ase_msa_extract_bz(DisasContext *ctx, arg_msa_bz *a, uint32_t insn)
{
    a->wt = extract32(insn, 16, 5);
    a->df = extract32(insn, 21, 2);
    a->sa = sextract32(insn, 0, 16);
}

static void decode_ase_msa_extract_bz_v(DisasContext *ctx, arg_msa_bz *a, uint32_t insn)
{
    a->wt = extract32(insn, 16, 5);
    a->df = 3;
    a->sa = sextract32(insn, 0, 16);
}

static void decode_ase_msa_extract_elm(DisasContext *ctx, arg_msa_elm *a, uint32_t insn)
{
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
}

static void decode_ase_msa_extract_elm_df(DisasContext *ctx, arg_msa_elm_df *a, uint32_t insn)
{
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = elm_df(ctx, extract32(insn, 16, 6));
    a->n = elm_n(ctx, extract32(insn, 16, 6));
}

static void decode_ase_msa_extract_i8(DisasContext *ctx, arg_msa_i *a, uint32_t insn)
{
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = 0;
    a->sa = sextract32(insn, 16, 8);
}

static void decode_ase_msa_extract_i8_df(DisasContext *ctx, arg_msa_i *a, uint32_t insn)
{
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = extract32(insn, 24, 2);
    a->sa = sextract32(insn, 16, 8);
}

static void decode_ase_msa_extract_ldi(DisasContext *ctx, arg_msa_ldi *a, uint32_t insn)
{
    a->wd = extract32(insn, 6, 5);
    a->df = extract32(insn, 21, 2);
    a->sa = sextract32(insn, 11, 10);
}

static void decode_ase_msa_extract_ldst(DisasContext *ctx, arg_msa_i *a, uint32_t insn)
{
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = extract32(insn, 0, 2);
    a->sa = sextract32(insn, 16, 10);
}

static void decode_ase_msa_extract_lsa(DisasContext *ctx, arg_r *a, uint32_t insn)
{
    a->rd = extract32(insn, 11, 5);
    a->rs = extract32(insn, 21, 5);
    a->rt = extract32(insn, 16, 5);
    a->sa = extract32(insn, 6, 2);
}

static void decode_ase_msa_extract_s5(DisasContext *ctx, arg_msa_i *a, uint32_t insn)
{
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = extract32(insn, 21, 2);
    a->sa = sextract32(insn, 16, 5);
}

static void decode_ase_msa_extract_u5(DisasContext *ctx, arg_msa_i *a, uint32_t insn)
{
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = extract32(insn, 21, 2);
    a->sa = extract32(insn, 16, 5);
}

static void decode_ase_msa_extract_vec(DisasContext *ctx, arg_msa_r *a, uint32_t insn)
{
    a->wt = extract32(insn, 16, 5);
    a->ws = extract32(insn, 11, 5);
    a->wd = extract32(insn, 6, 5);
    a->df = 0;
}

bool decode_ase_msa(DisasContext *ctx, uint32_t insn)
{
    union {
        arg_msa_bit f_msa_bit;
        arg_msa_bz f_msa_bz;
        arg_msa_elm f_msa_elm;
        arg_msa_elm_df f_msa_elm_df;
        arg_msa_i f_msa_i;
        arg_msa_ldi f_msa_ldi;
        arg_msa_r f_msa_r;
        arg_r f_r;
    } u;

    switch ((insn >> 26) & 0x3f) {
    case 0x0:
        /* 000000.. ........ ........ ........ */
        decode_ase_msa_extract_lsa(ctx, &u.f_r, insn);
        switch (insn & 0x0000073f) {
        case 0x00000005:
            /* 000000.. ........ .....000 ..000101 */
            /* ../qemu-10.2.0/target/mips/tcg/msa.decode:51 */
            if (trans_LSA(ctx, &u.f_r)) return true;
            break;
        case 0x00000015:
            /* 000000.. ........ .....000 ..010101 */
            /* ../qemu-10.2.0/target/mips/tcg/msa.decode:52 */
            if (trans_DLSA(ctx, &u.f_r)) return true;
            break;
        }
        break;
    case 0x11:
        /* 010001.. ........ ........ ........ */
        switch ((insn >> 23) & 0x7) {
        case 0x2:
            /* 01000101 0....... ........ ........ */
            decode_ase_msa_extract_bz_v(ctx, &u.f_msa_bz, insn);
            switch ((insn >> 21) & 0x3) {
            case 0x3:
                /* 01000101 011..... ........ ........ */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:54 */
                if (trans_BZ_V(ctx, &u.f_msa_bz)) return true;
                break;
            }
            break;
        case 0x3:
            /* 01000101 1....... ........ ........ */
            decode_ase_msa_extract_bz_v(ctx, &u.f_msa_bz, insn);
            switch ((insn >> 21) & 0x3) {
            case 0x3:
                /* 01000101 111..... ........ ........ */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:55 */
                if (trans_BNZ_V(ctx, &u.f_msa_bz)) return true;
                break;
            }
            break;
        case 0x6:
            /* 01000111 0....... ........ ........ */
            /* ../qemu-10.2.0/target/mips/tcg/msa.decode:56 */
            decode_ase_msa_extract_bz(ctx, &u.f_msa_bz, insn);
            if (trans_BZ(ctx, &u.f_msa_bz)) return true;
            break;
        case 0x7:
            /* 01000111 1....... ........ ........ */
            /* ../qemu-10.2.0/target/mips/tcg/msa.decode:57 */
            decode_ase_msa_extract_bz(ctx, &u.f_msa_bz, insn);
            if (trans_BNZ(ctx, &u.f_msa_bz)) return true;
            break;
        }
        break;
    case 0x1e:
        /* 011110.. ........ ........ ........ */
        switch ((insn >> 2) & 0xf) {
        case 0x0:
            /* 011110.. ........ ........ ..0000.. */
            switch (insn & 0x00000003) {
            case 0x00000000:
                /* 011110.. ........ ........ ..000000 */
                decode_ase_msa_extract_i8(ctx, &u.f_msa_i, insn);
                switch ((insn >> 24) & 0x3) {
                case 0x0:
                    /* 01111000 ........ ........ ..000000 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:59 */
                    if (trans_ANDI(ctx, &u.f_msa_i)) return true;
                    break;
                case 0x1:
                    /* 01111001 ........ ........ ..000000 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:60 */
                    if (trans_ORI(ctx, &u.f_msa_i)) return true;
                    break;
                case 0x2:
                    /* 01111010 ........ ........ ..000000 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:61 */
                    if (trans_NORI(ctx, &u.f_msa_i)) return true;
                    break;
                case 0x3:
                    /* 01111011 ........ ........ ..000000 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:62 */
                    if (trans_XORI(ctx, &u.f_msa_i)) return true;
                    break;
                }
                break;
            case 0x00000001:
                /* 011110.. ........ ........ ..000001 */
                decode_ase_msa_extract_i8(ctx, &u.f_msa_i, insn);
                switch ((insn >> 24) & 0x3) {
                case 0x0:
                    /* 01111000 ........ ........ ..000001 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:63 */
                    if (trans_BMNZI(ctx, &u.f_msa_i)) return true;
                    break;
                case 0x1:
                    /* 01111001 ........ ........ ..000001 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:64 */
                    if (trans_BMZI(ctx, &u.f_msa_i)) return true;
                    break;
                case 0x2:
                    /* 01111010 ........ ........ ..000001 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:65 */
                    if (trans_BSELI(ctx, &u.f_msa_i)) return true;
                    break;
                }
                break;
            case 0x00000002:
                /* 011110.. ........ ........ ..000010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:66 */
                decode_ase_msa_extract_i8_df(ctx, &u.f_msa_i, insn);
                if (trans_SHF(ctx, &u.f_msa_i)) return true;
                break;
            }
            break;
        case 0x1:
            /* 011110.. ........ ........ ..0001.. */
            switch (insn & 0x03800003) {
            case 0x00000002:
                /* 01111000 0....... ........ ..000110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:68 */
                decode_ase_msa_extract_u5(ctx, &u.f_msa_i, insn);
                if (trans_ADDVI(ctx, &u.f_msa_i)) return true;
                break;
            case 0x00000003:
                /* 01111000 0....... ........ ..000111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:75 */
                decode_ase_msa_extract_s5(ctx, &u.f_msa_i, insn);
                if (trans_CEQI(ctx, &u.f_msa_i)) return true;
                break;
            case 0x00800002:
                /* 01111000 1....... ........ ..000110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:69 */
                decode_ase_msa_extract_u5(ctx, &u.f_msa_i, insn);
                if (trans_SUBVI(ctx, &u.f_msa_i)) return true;
                break;
            case 0x01000002:
                /* 01111001 0....... ........ ..000110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:70 */
                decode_ase_msa_extract_s5(ctx, &u.f_msa_i, insn);
                if (trans_MAXI_S(ctx, &u.f_msa_i)) return true;
                break;
            case 0x01000003:
                /* 01111001 0....... ........ ..000111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:76 */
                decode_ase_msa_extract_s5(ctx, &u.f_msa_i, insn);
                if (trans_CLTI_S(ctx, &u.f_msa_i)) return true;
                break;
            case 0x01800002:
                /* 01111001 1....... ........ ..000110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:71 */
                decode_ase_msa_extract_u5(ctx, &u.f_msa_i, insn);
                if (trans_MAXI_U(ctx, &u.f_msa_i)) return true;
                break;
            case 0x01800003:
                /* 01111001 1....... ........ ..000111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:77 */
                decode_ase_msa_extract_u5(ctx, &u.f_msa_i, insn);
                if (trans_CLTI_U(ctx, &u.f_msa_i)) return true;
                break;
            case 0x02000002:
                /* 01111010 0....... ........ ..000110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:72 */
                decode_ase_msa_extract_s5(ctx, &u.f_msa_i, insn);
                if (trans_MINI_S(ctx, &u.f_msa_i)) return true;
                break;
            case 0x02000003:
                /* 01111010 0....... ........ ..000111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:78 */
                decode_ase_msa_extract_s5(ctx, &u.f_msa_i, insn);
                if (trans_CLEI_S(ctx, &u.f_msa_i)) return true;
                break;
            case 0x02800002:
                /* 01111010 1....... ........ ..000110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:73 */
                decode_ase_msa_extract_u5(ctx, &u.f_msa_i, insn);
                if (trans_MINI_U(ctx, &u.f_msa_i)) return true;
                break;
            case 0x02800003:
                /* 01111010 1....... ........ ..000111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:79 */
                decode_ase_msa_extract_u5(ctx, &u.f_msa_i, insn);
                if (trans_CLEI_U(ctx, &u.f_msa_i)) return true;
                break;
            case 0x03000003:
                /* 01111011 0....... ........ ..000111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:81 */
                decode_ase_msa_extract_ldi(ctx, &u.f_msa_ldi, insn);
                if (trans_LDI(ctx, &u.f_msa_ldi)) return true;
                break;
            }
            break;
        case 0x2:
            /* 011110.. ........ ........ ..0010.. */
            decode_ase_msa_extract_bit(ctx, &u.f_msa_bit, insn);
            switch (insn & 0x03800003) {
            case 0x00000001:
                /* 01111000 0....... ........ ..001001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:83 */
                if (trans_SLLI(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x00000002:
                /* 01111000 0....... ........ ..001010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:92 */
                if (trans_SAT_S(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x00800001:
                /* 01111000 1....... ........ ..001001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:84 */
                if (trans_SRAI(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x00800002:
                /* 01111000 1....... ........ ..001010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:93 */
                if (trans_SAT_U(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x01000001:
                /* 01111001 0....... ........ ..001001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:85 */
                if (trans_SRLI(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x01000002:
                /* 01111001 0....... ........ ..001010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:94 */
                if (trans_SRARI(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x01800001:
                /* 01111001 1....... ........ ..001001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:86 */
                if (trans_BCLRI(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x01800002:
                /* 01111001 1....... ........ ..001010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:95 */
                if (trans_SRLRI(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x02000001:
                /* 01111010 0....... ........ ..001001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:87 */
                if (trans_BSETI(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x02800001:
                /* 01111010 1....... ........ ..001001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:88 */
                if (trans_BNEGI(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x03000001:
                /* 01111011 0....... ........ ..001001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:89 */
                if (trans_BINSLI(ctx, &u.f_msa_bit)) return true;
                break;
            case 0x03800001:
                /* 01111011 1....... ........ ..001001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:90 */
                if (trans_BINSRI(ctx, &u.f_msa_bit)) return true;
                break;
            }
            break;
        case 0x3:
            /* 011110.. ........ ........ ..0011.. */
            decode_ase_msa_extract_3r(ctx, &u.f_msa_r, insn);
            switch (insn & 0x03800003) {
            case 0x00000001:
                /* 01111000 0....... ........ ..001101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:97 */
                if (trans_SLL(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00000002:
                /* 01111000 0....... ........ ..001110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:106 */
                if (trans_ADDV(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00000003:
                /* 01111000 0....... ........ ..001111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:115 */
                if (trans_CEQ(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800001:
                /* 01111000 1....... ........ ..001101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:98 */
                if (trans_SRA(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800002:
                /* 01111000 1....... ........ ..001110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:107 */
                if (trans_SUBV(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000001:
                /* 01111001 0....... ........ ..001101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:99 */
                if (trans_SRL(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000002:
                /* 01111001 0....... ........ ..001110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:108 */
                if (trans_MAX_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000003:
                /* 01111001 0....... ........ ..001111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:116 */
                if (trans_CLT_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01800001:
                /* 01111001 1....... ........ ..001101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:100 */
                if (trans_BCLR(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01800002:
                /* 01111001 1....... ........ ..001110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:109 */
                if (trans_MAX_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01800003:
                /* 01111001 1....... ........ ..001111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:117 */
                if (trans_CLT_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000001:
                /* 01111010 0....... ........ ..001101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:101 */
                if (trans_BSET(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000002:
                /* 01111010 0....... ........ ..001110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:110 */
                if (trans_MIN_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000003:
                /* 01111010 0....... ........ ..001111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:118 */
                if (trans_CLE_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800001:
                /* 01111010 1....... ........ ..001101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:102 */
                if (trans_BNEG(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800002:
                /* 01111010 1....... ........ ..001110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:111 */
                if (trans_MIN_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800003:
                /* 01111010 1....... ........ ..001111 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:119 */
                if (trans_CLE_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000001:
                /* 01111011 0....... ........ ..001101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:103 */
                if (trans_BINSL(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000002:
                /* 01111011 0....... ........ ..001110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:112 */
                if (trans_MAX_A(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03800001:
                /* 01111011 1....... ........ ..001101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:104 */
                if (trans_BINSR(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03800002:
                /* 01111011 1....... ........ ..001110 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:113 */
                if (trans_MIN_A(ctx, &u.f_msa_r)) return true;
                break;
            }
            break;
        case 0x4:
            /* 011110.. ........ ........ ..0100.. */
            decode_ase_msa_extract_3r(ctx, &u.f_msa_r, insn);
            switch (insn & 0x03800003) {
            case 0x00000000:
                /* 01111000 0....... ........ ..010000 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:121 */
                if (trans_ADD_A(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00000001:
                /* 01111000 0....... ........ ..010001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:130 */
                if (trans_SUBS_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00000002:
                /* 01111000 0....... ........ ..010010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:137 */
                if (trans_MULV(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00000003:
                /* 01111000 0....... ........ ..010011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:145 */
                if (trans_DOTP_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800000:
                /* 01111000 1....... ........ ..010000 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:122 */
                if (trans_ADDS_A(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800001:
                /* 01111000 1....... ........ ..010001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:131 */
                if (trans_SUBS_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800002:
                /* 01111000 1....... ........ ..010010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:138 */
                if (trans_MADDV(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800003:
                /* 01111000 1....... ........ ..010011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:146 */
                if (trans_DOTP_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000000:
                /* 01111001 0....... ........ ..010000 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:123 */
                if (trans_ADDS_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000001:
                /* 01111001 0....... ........ ..010001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:132 */
                if (trans_SUBSUS_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000002:
                /* 01111001 0....... ........ ..010010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:139 */
                if (trans_MSUBV(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000003:
                /* 01111001 0....... ........ ..010011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:147 */
                if (trans_DPADD_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01800000:
                /* 01111001 1....... ........ ..010000 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:124 */
                if (trans_ADDS_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01800001:
                /* 01111001 1....... ........ ..010001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:133 */
                if (trans_SUBSUU_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01800003:
                /* 01111001 1....... ........ ..010011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:148 */
                if (trans_DPADD_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000000:
                /* 01111010 0....... ........ ..010000 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:125 */
                if (trans_AVE_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000001:
                /* 01111010 0....... ........ ..010001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:134 */
                if (trans_ASUB_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000002:
                /* 01111010 0....... ........ ..010010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:140 */
                if (trans_DIV_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000003:
                /* 01111010 0....... ........ ..010011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:149 */
                if (trans_DPSUB_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800000:
                /* 01111010 1....... ........ ..010000 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:126 */
                if (trans_AVE_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800001:
                /* 01111010 1....... ........ ..010001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:135 */
                if (trans_ASUB_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800002:
                /* 01111010 1....... ........ ..010010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:141 */
                if (trans_DIV_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800003:
                /* 01111010 1....... ........ ..010011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:150 */
                if (trans_DPSUB_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000000:
                /* 01111011 0....... ........ ..010000 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:127 */
                if (trans_AVER_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000002:
                /* 01111011 0....... ........ ..010010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:142 */
                if (trans_MOD_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03800000:
                /* 01111011 1....... ........ ..010000 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:128 */
                if (trans_AVER_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03800002:
                /* 01111011 1....... ........ ..010010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:143 */
                if (trans_MOD_U(ctx, &u.f_msa_r)) return true;
                break;
            }
            break;
        case 0x5:
            /* 011110.. ........ ........ ..0101.. */
            decode_ase_msa_extract_3r(ctx, &u.f_msa_r, insn);
            switch (insn & 0x03800003) {
            case 0x00000000:
                /* 01111000 0....... ........ ..010100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:152 */
                if (trans_SLD(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00000001:
                /* 01111000 0....... ........ ..010101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:161 */
                if (trans_VSHF(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800000:
                /* 01111000 1....... ........ ..010100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:153 */
                if (trans_SPLAT(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800001:
                /* 01111000 1....... ........ ..010101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:162 */
                if (trans_SRAR(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000000:
                /* 01111001 0....... ........ ..010100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:154 */
                if (trans_PCKEV(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000001:
                /* 01111001 0....... ........ ..010101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:163 */
                if (trans_SRLR(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01800000:
                /* 01111001 1....... ........ ..010100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:155 */
                if (trans_PCKOD(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000000:
                /* 01111010 0....... ........ ..010100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:156 */
                if (trans_ILVL(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000001:
                /* 01111010 0....... ........ ..010101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:164 */
                if (trans_HADD_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800000:
                /* 01111010 1....... ........ ..010100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:157 */
                if (trans_ILVR(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800001:
                /* 01111010 1....... ........ ..010101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:165 */
                if (trans_HADD_U(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000000:
                /* 01111011 0....... ........ ..010100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:158 */
                if (trans_ILVEV(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000001:
                /* 01111011 0....... ........ ..010101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:166 */
                if (trans_HSUB_S(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03800000:
                /* 01111011 1....... ........ ..010100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:159 */
                if (trans_ILVOD(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03800001:
                /* 01111011 1....... ........ ..010101 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:167 */
                if (trans_HSUB_U(ctx, &u.f_msa_r)) return true;
                break;
            }
            break;
        case 0x6:
            /* 011110.. ........ ........ ..0110.. */
            switch (insn & 0x03c00003) {
            case 0x00000001:
                /* 01111000 00...... ........ ..011001 */
                if ((insn & 0x003f0000) == 0x003e0000) {
                    /* 01111000 00111110 ........ ..011001 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:170 */
                    decode_ase_msa_extract_elm(ctx, &u.f_msa_elm, insn);
                    if (trans_CTCMSA(ctx, &u.f_msa_elm)) return true;
                }
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:171 */
                decode_ase_msa_extract_elm_df(ctx, &u.f_msa_elm_df, insn);
                if (trans_SLDI(ctx, &u.f_msa_elm_df)) return true;
                break;
            case 0x00000002:
                /* 01111000 00...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:185 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCAF(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00000003:
                /* 01111000 00...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:202 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FADD(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00400001:
                /* 01111000 01...... ........ ..011001 */
                if ((insn & 0x003f0000) == 0x003e0000) {
                    /* 01111000 01111110 ........ ..011001 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:174 */
                    decode_ase_msa_extract_elm(ctx, &u.f_msa_elm, insn);
                    if (trans_CFCMSA(ctx, &u.f_msa_elm)) return true;
                }
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:175 */
                decode_ase_msa_extract_elm_df(ctx, &u.f_msa_elm_df, insn);
                if (trans_SPLATI(ctx, &u.f_msa_elm_df)) return true;
                break;
            case 0x00400002:
                /* 01111000 01...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:186 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCUN(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00400003:
                /* 01111000 01...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:203 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSUB(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800001:
                /* 01111000 10...... ........ ..011001 */
                if ((insn & 0x003f0000) == 0x003e0000) {
                    /* 01111000 10111110 ........ ..011001 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:178 */
                    decode_ase_msa_extract_elm(ctx, &u.f_msa_elm, insn);
                    if (trans_MOVE_V(ctx, &u.f_msa_elm)) return true;
                }
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:179 */
                decode_ase_msa_extract_elm_df(ctx, &u.f_msa_elm_df, insn);
                if (trans_COPY_S(ctx, &u.f_msa_elm_df)) return true;
                break;
            case 0x00800002:
                /* 01111000 10...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:187 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCEQ(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800003:
                /* 01111000 10...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:204 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FMUL(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00c00001:
                /* 01111000 11...... ........ ..011001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:181 */
                decode_ase_msa_extract_elm_df(ctx, &u.f_msa_elm_df, insn);
                if (trans_COPY_U(ctx, &u.f_msa_elm_df)) return true;
                break;
            case 0x00c00002:
                /* 01111000 11...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:188 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCUEQ(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00c00003:
                /* 01111000 11...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:205 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FDIV(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000001:
                /* 01111001 00...... ........ ..011001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:182 */
                decode_ase_msa_extract_elm_df(ctx, &u.f_msa_elm_df, insn);
                if (trans_INSERT(ctx, &u.f_msa_elm_df)) return true;
                break;
            case 0x01000002:
                /* 01111001 00...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:189 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCLT(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01000003:
                /* 01111001 00...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:206 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FMADD(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01400001:
                /* 01111001 01...... ........ ..011001 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:183 */
                decode_ase_msa_extract_elm_df(ctx, &u.f_msa_elm_df, insn);
                if (trans_INSVE(ctx, &u.f_msa_elm_df)) return true;
                break;
            case 0x01400002:
                /* 01111001 01...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:190 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCULT(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01400003:
                /* 01111001 01...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:207 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FMSUB(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01800002:
                /* 01111001 10...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:191 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCLE(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01c00002:
                /* 01111001 11...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:192 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCULE(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01c00003:
                /* 01111001 11...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:208 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FEXP2(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000002:
                /* 01111010 00...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:193 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSAF(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02000003:
                /* 01111010 00...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:209 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FEXDO(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02400002:
                /* 01111010 01...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:194 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSUN(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800002:
                /* 01111010 10...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:195 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSEQ(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800003:
                /* 01111010 10...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:210 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FTQ(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02c00002:
                /* 01111010 11...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:196 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSUEQ(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000002:
                /* 01111011 00...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:197 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSLT(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000003:
                /* 01111011 00...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:211 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FMIN(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03400002:
                /* 01111011 01...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:198 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSULT(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03400003:
                /* 01111011 01...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:212 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FMIN_A(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03800002:
                /* 01111011 10...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:199 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSLE(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03800003:
                /* 01111011 10...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:213 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FMAX(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03c00002:
                /* 01111011 11...... ........ ..011010 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:200 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSULE(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03c00003:
                /* 01111011 11...... ........ ..011011 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:214 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FMAX_A(ctx, &u.f_msa_r)) return true;
                break;
            }
            break;
        case 0x7:
            /* 011110.. ........ ........ ..0111.. */
            switch (insn & 0x03c00003) {
            case 0x00000002:
                /* 01111000 00...... ........ ..011110 */
                decode_ase_msa_extract_vec(ctx, &u.f_msa_r, insn);
                switch ((insn >> 21) & 0x1) {
                case 0x0:
                    /* 01111000 000..... ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:229 */
                    if (trans_AND_V(ctx, &u.f_msa_r)) return true;
                    break;
                case 0x1:
                    /* 01111000 001..... ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:230 */
                    if (trans_OR_V(ctx, &u.f_msa_r)) return true;
                    break;
                }
                break;
            case 0x00400000:
                /* 01111000 01...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:216 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCOR(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00400002:
                /* 01111000 01...... ........ ..011110 */
                decode_ase_msa_extract_vec(ctx, &u.f_msa_r, insn);
                switch ((insn >> 21) & 0x1) {
                case 0x0:
                    /* 01111000 010..... ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:231 */
                    if (trans_NOR_V(ctx, &u.f_msa_r)) return true;
                    break;
                case 0x1:
                    /* 01111000 011..... ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:232 */
                    if (trans_XOR_V(ctx, &u.f_msa_r)) return true;
                    break;
                }
                break;
            case 0x00800000:
                /* 01111000 10...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:217 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCUNE(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00800002:
                /* 01111000 10...... ........ ..011110 */
                decode_ase_msa_extract_vec(ctx, &u.f_msa_r, insn);
                switch ((insn >> 21) & 0x1) {
                case 0x0:
                    /* 01111000 100..... ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:233 */
                    if (trans_BMNZ_V(ctx, &u.f_msa_r)) return true;
                    break;
                case 0x1:
                    /* 01111000 101..... ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:234 */
                    if (trans_BMZ_V(ctx, &u.f_msa_r)) return true;
                    break;
                }
                break;
            case 0x00c00000:
                /* 01111000 11...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:218 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FCNE(ctx, &u.f_msa_r)) return true;
                break;
            case 0x00c00002:
                /* 01111000 11...... ........ ..011110 */
                decode_ase_msa_extract_vec(ctx, &u.f_msa_r, insn);
                switch ((insn >> 21) & 0x1) {
                case 0x0:
                    /* 01111000 110..... ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:235 */
                    if (trans_BSEL_V(ctx, &u.f_msa_r)) return true;
                    break;
                }
                break;
            case 0x01000000:
                /* 01111001 00...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:219 */
                decode_ase_msa_extract_3rf_h(ctx, &u.f_msa_r, insn);
                if (trans_MUL_Q(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01400000:
                /* 01111001 01...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:220 */
                decode_ase_msa_extract_3rf_h(ctx, &u.f_msa_r, insn);
                if (trans_MADD_Q(ctx, &u.f_msa_r)) return true;
                break;
            case 0x01800000:
                /* 01111001 10...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:221 */
                decode_ase_msa_extract_3rf_h(ctx, &u.f_msa_r, insn);
                if (trans_MSUB_Q(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02400000:
                /* 01111010 01...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:222 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSOR(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02800000:
                /* 01111010 10...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:223 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSUNE(ctx, &u.f_msa_r)) return true;
                break;
            case 0x02c00000:
                /* 01111010 11...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:224 */
                decode_ase_msa_extract_3rf_w(ctx, &u.f_msa_r, insn);
                if (trans_FSNE(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000000:
                /* 01111011 00...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:225 */
                decode_ase_msa_extract_3rf_h(ctx, &u.f_msa_r, insn);
                if (trans_MULR_Q(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03000002:
                /* 01111011 00...... ........ ..011110 */
                switch ((insn >> 18) & 0xf) {
                case 0x0:
                    /* 01111011 000000.. ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:236 */
                    decode_ase_msa_extract_2r(ctx, &u.f_msa_r, insn);
                    if (trans_FILL(ctx, &u.f_msa_r)) return true;
                    break;
                case 0x1:
                    /* 01111011 000001.. ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:237 */
                    decode_ase_msa_extract_2r(ctx, &u.f_msa_r, insn);
                    if (trans_PCNT(ctx, &u.f_msa_r)) return true;
                    break;
                case 0x2:
                    /* 01111011 000010.. ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:238 */
                    decode_ase_msa_extract_2r(ctx, &u.f_msa_r, insn);
                    if (trans_NLOC(ctx, &u.f_msa_r)) return true;
                    break;
                case 0x3:
                    /* 01111011 000011.. ........ ..011110 */
                    /* ../qemu-10.2.0/target/mips/tcg/msa.decode:239 */
                    decode_ase_msa_extract_2r(ctx, &u.f_msa_r, insn);
                    if (trans_NLZC(ctx, &u.f_msa_r)) return true;
                    break;
                case 0x8:
                    /* 01111011 001000.. ........ ..011110 */
                    decode_ase_msa_extract_2rf(ctx, &u.f_msa_r, insn);
                    switch ((insn >> 17) & 0x1) {
                    case 0x0:
                        /* 01111011 0010000. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:240 */
                        if (trans_FCLASS(ctx, &u.f_msa_r)) return true;
                        break;
                    case 0x1:
                        /* 01111011 0010001. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:241 */
                        if (trans_FTRUNC_S(ctx, &u.f_msa_r)) return true;
                        break;
                    }
                    break;
                case 0x9:
                    /* 01111011 001001.. ........ ..011110 */
                    decode_ase_msa_extract_2rf(ctx, &u.f_msa_r, insn);
                    switch ((insn >> 17) & 0x1) {
                    case 0x0:
                        /* 01111011 0010010. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:242 */
                        if (trans_FTRUNC_U(ctx, &u.f_msa_r)) return true;
                        break;
                    case 0x1:
                        /* 01111011 0010011. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:243 */
                        if (trans_FSQRT(ctx, &u.f_msa_r)) return true;
                        break;
                    }
                    break;
                case 0xa:
                    /* 01111011 001010.. ........ ..011110 */
                    decode_ase_msa_extract_2rf(ctx, &u.f_msa_r, insn);
                    switch ((insn >> 17) & 0x1) {
                    case 0x0:
                        /* 01111011 0010100. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:244 */
                        if (trans_FRSQRT(ctx, &u.f_msa_r)) return true;
                        break;
                    case 0x1:
                        /* 01111011 0010101. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:245 */
                        if (trans_FRCP(ctx, &u.f_msa_r)) return true;
                        break;
                    }
                    break;
                case 0xb:
                    /* 01111011 001011.. ........ ..011110 */
                    decode_ase_msa_extract_2rf(ctx, &u.f_msa_r, insn);
                    switch ((insn >> 17) & 0x1) {
                    case 0x0:
                        /* 01111011 0010110. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:246 */
                        if (trans_FRINT(ctx, &u.f_msa_r)) return true;
                        break;
                    case 0x1:
                        /* 01111011 0010111. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:247 */
                        if (trans_FLOG2(ctx, &u.f_msa_r)) return true;
                        break;
                    }
                    break;
                case 0xc:
                    /* 01111011 001100.. ........ ..011110 */
                    decode_ase_msa_extract_2rf(ctx, &u.f_msa_r, insn);
                    switch ((insn >> 17) & 0x1) {
                    case 0x0:
                        /* 01111011 0011000. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:248 */
                        if (trans_FEXUPL(ctx, &u.f_msa_r)) return true;
                        break;
                    case 0x1:
                        /* 01111011 0011001. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:249 */
                        if (trans_FEXUPR(ctx, &u.f_msa_r)) return true;
                        break;
                    }
                    break;
                case 0xd:
                    /* 01111011 001101.. ........ ..011110 */
                    decode_ase_msa_extract_2rf(ctx, &u.f_msa_r, insn);
                    switch ((insn >> 17) & 0x1) {
                    case 0x0:
                        /* 01111011 0011010. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:250 */
                        if (trans_FFQL(ctx, &u.f_msa_r)) return true;
                        break;
                    case 0x1:
                        /* 01111011 0011011. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:251 */
                        if (trans_FFQR(ctx, &u.f_msa_r)) return true;
                        break;
                    }
                    break;
                case 0xe:
                    /* 01111011 001110.. ........ ..011110 */
                    decode_ase_msa_extract_2rf(ctx, &u.f_msa_r, insn);
                    switch ((insn >> 17) & 0x1) {
                    case 0x0:
                        /* 01111011 0011100. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:252 */
                        if (trans_FTINT_S(ctx, &u.f_msa_r)) return true;
                        break;
                    case 0x1:
                        /* 01111011 0011101. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:253 */
                        if (trans_FTINT_U(ctx, &u.f_msa_r)) return true;
                        break;
                    }
                    break;
                case 0xf:
                    /* 01111011 001111.. ........ ..011110 */
                    decode_ase_msa_extract_2rf(ctx, &u.f_msa_r, insn);
                    switch ((insn >> 17) & 0x1) {
                    case 0x0:
                        /* 01111011 0011110. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:254 */
                        if (trans_FFINT_S(ctx, &u.f_msa_r)) return true;
                        break;
                    case 0x1:
                        /* 01111011 0011111. ........ ..011110 */
                        /* ../qemu-10.2.0/target/mips/tcg/msa.decode:255 */
                        if (trans_FFINT_U(ctx, &u.f_msa_r)) return true;
                        break;
                    }
                    break;
                }
                break;
            case 0x03400000:
                /* 01111011 01...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:226 */
                decode_ase_msa_extract_3rf_h(ctx, &u.f_msa_r, insn);
                if (trans_MADDR_Q(ctx, &u.f_msa_r)) return true;
                break;
            case 0x03800000:
                /* 01111011 10...... ........ ..011100 */
                /* ../qemu-10.2.0/target/mips/tcg/msa.decode:227 */
                decode_ase_msa_extract_3rf_h(ctx, &u.f_msa_r, insn);
                if (trans_MSUBR_Q(ctx, &u.f_msa_r)) return true;
                break;
            }
            break;
        case 0x8:
            /* 011110.. ........ ........ ..1000.. */
            /* ../qemu-10.2.0/target/mips/tcg/msa.decode:257 */
            decode_ase_msa_extract_ldst(ctx, &u.f_msa_i, insn);
            if (trans_LD(ctx, &u.f_msa_i)) return true;
            break;
        case 0x9:
            /* 011110.. ........ ........ ..1001.. */
            /* ../qemu-10.2.0/target/mips/tcg/msa.decode:258 */
            decode_ase_msa_extract_ldst(ctx, &u.f_msa_i, insn);
            if (trans_ST(ctx, &u.f_msa_i)) return true;
            break;
        }
        break;
    }
    return false;
}
