#include "vtkABI.h"
#include "vtkClientServerInterpreter.h"

extern "C" { void vtkImageAnisotropicDiffusion2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageAnisotropicDiffusion3D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageCheckerboard_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageCityBlockDistance_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageConvolve_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageCorrelation_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageEuclideanDistance_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageEuclideanToPolar_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageGaussianSmooth_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageGradient_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageGradientMagnitude_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageHybridMedian2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageLaplacian_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageMedian3D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageNormalize_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageRange3D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageSeparableConvolution_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageSlab_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageSlabReslice_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageSobel2D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageSobel3D_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageSpatialAlgorithm_Init(vtkClientServerInterpreter*); }
extern "C" { void vtkImageVariance3D_Init(vtkClientServerInterpreter*); }

extern "C" VTK_ABI_EXPORT void vtkImagingGeneralCS_Initialize(vtkClientServerInterpreter* csi)
{
  (void)csi;
  vtkImageAnisotropicDiffusion2D_Init(csi);
  vtkImageAnisotropicDiffusion3D_Init(csi);
  vtkImageCheckerboard_Init(csi);
  vtkImageCityBlockDistance_Init(csi);
  vtkImageConvolve_Init(csi);
  vtkImageCorrelation_Init(csi);
  vtkImageEuclideanDistance_Init(csi);
  vtkImageEuclideanToPolar_Init(csi);
  vtkImageGaussianSmooth_Init(csi);
  vtkImageGradient_Init(csi);
  vtkImageGradientMagnitude_Init(csi);
  vtkImageHybridMedian2D_Init(csi);
  vtkImageLaplacian_Init(csi);
  vtkImageMedian3D_Init(csi);
  vtkImageNormalize_Init(csi);
  vtkImageRange3D_Init(csi);
  vtkImageSeparableConvolution_Init(csi);
  vtkImageSlab_Init(csi);
  vtkImageSlabReslice_Init(csi);
  vtkImageSobel2D_Init(csi);
  vtkImageSobel3D_Init(csi);
  vtkImageSpatialAlgorithm_Init(csi);
  vtkImageVariance3D_Init(csi);
}
