/*
 * SPDX-License-Identifier: GPL-3.0-only
 * MuseScore-CLA-applies
 *
 * MuseScore
 * Music Composition & Notation
 *
 * Copyright (C) 2021 MuseScore BVBA and others
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 3 as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef MUSE_AUDIO_IPLAYER_H
#define MUSE_AUDIO_IPLAYER_H

#include <memory>

#include "global/async/promise.h"
#include "global/async/channel.h"

#include "audiotypes.h"

namespace muse::audio {
class IPlayer
{
public:
    virtual ~IPlayer() = default;

    virtual TrackSequenceId sequenceId() const = 0;

    virtual void play() = 0;
    virtual void seek(const secs_t newPosition) = 0;
    virtual void stop() = 0;
    virtual void pause() = 0;
    virtual void resume() = 0;

    virtual PlaybackStatus playbackStatus() const = 0;
    virtual async::Channel<PlaybackStatus> playbackStatusChanged() const = 0;

    virtual void setDuration(const msecs_t durationMsec) = 0;
    virtual async::Promise<bool> setLoop(const msecs_t fromMsec, const msecs_t toMsec) = 0;
    virtual void resetLoop() = 0;

    virtual secs_t playbackPosition() const = 0;
    virtual async::Channel<secs_t> playbackPositionChanged() const = 0;
};

using IPlayerPtr = std::shared_ptr<IPlayer>;
}

#endif // MUSE_AUDIO_IPLAYER_H
