/*
 * This file is generated by gdbus-codegen, do not modify it.
 *
 * The license of this code is the same as for the D-Bus interface description
 * it was derived from. Note that it links to GLib, so must comply with the
 * LGPL linking clauses.
 */

#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include "mm-gdbus-manager.h"

#include <string.h>
#ifdef G_OS_UNIX
#  include <gio/gunixfdlist.h>
#endif

#ifdef G_ENABLE_DEBUG
#define g_marshal_value_peek_boolean(v)  g_value_get_boolean (v)
#define g_marshal_value_peek_char(v)     g_value_get_schar (v)
#define g_marshal_value_peek_uchar(v)    g_value_get_uchar (v)
#define g_marshal_value_peek_int(v)      g_value_get_int (v)
#define g_marshal_value_peek_uint(v)     g_value_get_uint (v)
#define g_marshal_value_peek_long(v)     g_value_get_long (v)
#define g_marshal_value_peek_ulong(v)    g_value_get_ulong (v)
#define g_marshal_value_peek_int64(v)    g_value_get_int64 (v)
#define g_marshal_value_peek_uint64(v)   g_value_get_uint64 (v)
#define g_marshal_value_peek_enum(v)     g_value_get_enum (v)
#define g_marshal_value_peek_flags(v)    g_value_get_flags (v)
#define g_marshal_value_peek_float(v)    g_value_get_float (v)
#define g_marshal_value_peek_double(v)   g_value_get_double (v)
#define g_marshal_value_peek_string(v)   (char*) g_value_get_string (v)
#define g_marshal_value_peek_param(v)    g_value_get_param (v)
#define g_marshal_value_peek_boxed(v)    g_value_get_boxed (v)
#define g_marshal_value_peek_pointer(v)  g_value_get_pointer (v)
#define g_marshal_value_peek_object(v)   g_value_get_object (v)
#define g_marshal_value_peek_variant(v)  g_value_get_variant (v)
#else /* !G_ENABLE_DEBUG */
/* WARNING: This code accesses GValues directly, which is UNSUPPORTED API.
 *          Do not access GValues directly in your code. Instead, use the
 *          g_value_get_*() functions
 */
#define g_marshal_value_peek_boolean(v)  (v)->data[0].v_int
#define g_marshal_value_peek_char(v)     (v)->data[0].v_int
#define g_marshal_value_peek_uchar(v)    (v)->data[0].v_uint
#define g_marshal_value_peek_int(v)      (v)->data[0].v_int
#define g_marshal_value_peek_uint(v)     (v)->data[0].v_uint
#define g_marshal_value_peek_long(v)     (v)->data[0].v_long
#define g_marshal_value_peek_ulong(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_int64(v)    (v)->data[0].v_int64
#define g_marshal_value_peek_uint64(v)   (v)->data[0].v_uint64
#define g_marshal_value_peek_enum(v)     (v)->data[0].v_long
#define g_marshal_value_peek_flags(v)    (v)->data[0].v_ulong
#define g_marshal_value_peek_float(v)    (v)->data[0].v_float
#define g_marshal_value_peek_double(v)   (v)->data[0].v_double
#define g_marshal_value_peek_string(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_param(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_boxed(v)    (v)->data[0].v_pointer
#define g_marshal_value_peek_pointer(v)  (v)->data[0].v_pointer
#define g_marshal_value_peek_object(v)   (v)->data[0].v_pointer
#define g_marshal_value_peek_variant(v)  (v)->data[0].v_pointer
#endif /* !G_ENABLE_DEBUG */

typedef struct
{
  GDBusArgInfo parent_struct;
  gboolean use_gvariant;
} _ExtendedGDBusArgInfo;

typedef struct
{
  GDBusMethodInfo parent_struct;
  const gchar *signal_name;
  gboolean pass_fdlist;
} _ExtendedGDBusMethodInfo;

typedef struct
{
  GDBusSignalInfo parent_struct;
  const gchar *signal_name;
} _ExtendedGDBusSignalInfo;

typedef struct
{
  GDBusPropertyInfo parent_struct;
  const gchar *hyphen_name;
  guint use_gvariant : 1;
  guint emits_changed_signal : 1;
} _ExtendedGDBusPropertyInfo;

typedef struct
{
  GDBusInterfaceInfo parent_struct;
  const gchar *hyphen_name;
} _ExtendedGDBusInterfaceInfo;

typedef struct
{
  const _ExtendedGDBusPropertyInfo *info;
  guint prop_id;
  GValue orig_value; /* the value before the change */
} ChangedProperty;

static void
_changed_property_free (ChangedProperty *data)
{
  g_value_unset (&data->orig_value);
  g_free (data);
}

static gboolean
_g_strv_equal0 (gchar **a, gchar **b)
{
  gboolean ret = FALSE;
  guint n;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  if (g_strv_length (a) != g_strv_length (b))
    goto out;
  for (n = 0; a[n] != NULL; n++)
    if (g_strcmp0 (a[n], b[n]) != 0)
      goto out;
  ret = TRUE;
out:
  return ret;
}

static gboolean
_g_variant_equal0 (GVariant *a, GVariant *b)
{
  gboolean ret = FALSE;
  if (a == NULL && b == NULL)
    {
      ret = TRUE;
      goto out;
    }
  if (a == NULL || b == NULL)
    goto out;
  ret = g_variant_equal (a, b);
out:
  return ret;
}

G_GNUC_UNUSED static gboolean
_g_value_equal (const GValue *a, const GValue *b)
{
  gboolean ret = FALSE;
  g_assert (G_VALUE_TYPE (a) == G_VALUE_TYPE (b));
  switch (G_VALUE_TYPE (a))
    {
      case G_TYPE_BOOLEAN:
        ret = (g_value_get_boolean (a) == g_value_get_boolean (b));
        break;
      case G_TYPE_UCHAR:
        ret = (g_value_get_uchar (a) == g_value_get_uchar (b));
        break;
      case G_TYPE_INT:
        ret = (g_value_get_int (a) == g_value_get_int (b));
        break;
      case G_TYPE_UINT:
        ret = (g_value_get_uint (a) == g_value_get_uint (b));
        break;
      case G_TYPE_INT64:
        ret = (g_value_get_int64 (a) == g_value_get_int64 (b));
        break;
      case G_TYPE_UINT64:
        ret = (g_value_get_uint64 (a) == g_value_get_uint64 (b));
        break;
      case G_TYPE_DOUBLE:
        {
          /* Avoid -Wfloat-equal warnings by doing a direct bit compare */
          gdouble da = g_value_get_double (a);
          gdouble db = g_value_get_double (b);
          ret = memcmp (&da, &db, sizeof (gdouble)) == 0;
        }
        break;
      case G_TYPE_STRING:
        ret = (g_strcmp0 (g_value_get_string (a), g_value_get_string (b)) == 0);
        break;
      case G_TYPE_VARIANT:
        ret = _g_variant_equal0 (g_value_get_variant (a), g_value_get_variant (b));
        break;
      default:
        if (G_VALUE_TYPE (a) == G_TYPE_STRV)
          ret = _g_strv_equal0 (g_value_get_boxed (a), g_value_get_boxed (b));
        else
          g_critical ("_g_value_equal() does not handle type %s", g_type_name (G_VALUE_TYPE (a)));
        break;
    }
  return ret;
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 2);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_level,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        GVariant *arg_properties,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectVariantFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 3);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectVariantFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_variant (param_values + 2),
              data2);

  g_value_set_boolean (return_value, v_return);
}

static void
_g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint G_GNUC_UNUSED,
    void         *marshal_data)
{
  typedef gboolean (*_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
       (void *data1,
        GDBusMethodInvocation *arg_method_invocation,
        const gchar *arg_uid,
        gboolean arg_inhibit,
        void *data2);
  _GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc callback;
  GCClosure *cc = (GCClosure*) closure;
  void *data1, *data2;
  gboolean v_return;

  g_return_if_fail (return_value != NULL);
  g_return_if_fail (n_param_values == 4);

  if (G_CCLOSURE_SWAP_DATA (closure))
    {
      data1 = closure->data;
      data2 = g_value_peek_pointer (param_values + 0);
    }
  else
    {
      data1 = g_value_peek_pointer (param_values + 0);
      data2 = closure->data;
    }

  callback = (_GDbusCodegenMarshalBoolean_ObjectStringBooleanFunc)
    (marshal_data ? marshal_data : cc->callback);

  v_return =
    callback (data1,
              g_marshal_value_peek_object (param_values + 1),
              g_marshal_value_peek_string (param_values + 2),
              g_marshal_value_peek_boolean (param_values + 3),
              data2);

  g_value_set_boolean (return_value, v_return);
}

/* ------------------------------------------------------------------------
 * Code for interface org.freedesktop.ModemManager1
 * ------------------------------------------------------------------------
 */

/**
 * SECTION:MmGdbusOrgFreedesktopModemManager1
 * @title: MmGdbusOrgFreedesktopModemManager1
 * @short_description: Generated C code for the org.freedesktop.ModemManager1 D-Bus interface
 *
 * This section contains code for working with the <link linkend="gdbus-interface-org-freedesktop-ModemManager1.top_of_page">org.freedesktop.ModemManager1</link> D-Bus interface in C.
 */

/* ---- Introspection data for org.freedesktop.ModemManager1 ---- */

static const _ExtendedGDBusMethodInfo _mm_gdbus_org_freedesktop_modem_manager1_method_info_scan_devices =
{
  {
    -1,
    (gchar *) "ScanDevices",
    NULL,
    NULL,
    NULL
  },
  "handle-scan-devices",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_org_freedesktop_modem_manager1_method_info_set_logging_IN_ARG_level =
{
  {
    -1,
    (gchar *) "level",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_org_freedesktop_modem_manager1_method_info_set_logging_IN_ARG_pointers[] =
{
  &_mm_gdbus_org_freedesktop_modem_manager1_method_info_set_logging_IN_ARG_level.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_org_freedesktop_modem_manager1_method_info_set_logging =
{
  {
    -1,
    (gchar *) "SetLogging",
    (GDBusArgInfo **) &_mm_gdbus_org_freedesktop_modem_manager1_method_info_set_logging_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-set-logging",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_org_freedesktop_modem_manager1_method_info_report_kernel_event_IN_ARG_properties =
{
  {
    -1,
    (gchar *) "properties",
    (gchar *) "a{sv}",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_org_freedesktop_modem_manager1_method_info_report_kernel_event_IN_ARG_pointers[] =
{
  &_mm_gdbus_org_freedesktop_modem_manager1_method_info_report_kernel_event_IN_ARG_properties.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_org_freedesktop_modem_manager1_method_info_report_kernel_event =
{
  {
    -1,
    (gchar *) "ReportKernelEvent",
    (GDBusArgInfo **) &_mm_gdbus_org_freedesktop_modem_manager1_method_info_report_kernel_event_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-report-kernel-event",
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_org_freedesktop_modem_manager1_method_info_inhibit_device_IN_ARG_uid =
{
  {
    -1,
    (gchar *) "uid",
    (gchar *) "s",
    NULL
  },
  FALSE
};

static const _ExtendedGDBusArgInfo _mm_gdbus_org_freedesktop_modem_manager1_method_info_inhibit_device_IN_ARG_inhibit =
{
  {
    -1,
    (gchar *) "inhibit",
    (gchar *) "b",
    NULL
  },
  FALSE
};

static const GDBusArgInfo * const _mm_gdbus_org_freedesktop_modem_manager1_method_info_inhibit_device_IN_ARG_pointers[] =
{
  &_mm_gdbus_org_freedesktop_modem_manager1_method_info_inhibit_device_IN_ARG_uid.parent_struct,
  &_mm_gdbus_org_freedesktop_modem_manager1_method_info_inhibit_device_IN_ARG_inhibit.parent_struct,
  NULL
};

static const _ExtendedGDBusMethodInfo _mm_gdbus_org_freedesktop_modem_manager1_method_info_inhibit_device =
{
  {
    -1,
    (gchar *) "InhibitDevice",
    (GDBusArgInfo **) &_mm_gdbus_org_freedesktop_modem_manager1_method_info_inhibit_device_IN_ARG_pointers,
    NULL,
    NULL
  },
  "handle-inhibit-device",
  FALSE
};

static const GDBusMethodInfo * const _mm_gdbus_org_freedesktop_modem_manager1_method_info_pointers[] =
{
  &_mm_gdbus_org_freedesktop_modem_manager1_method_info_scan_devices.parent_struct,
  &_mm_gdbus_org_freedesktop_modem_manager1_method_info_set_logging.parent_struct,
  &_mm_gdbus_org_freedesktop_modem_manager1_method_info_report_kernel_event.parent_struct,
  &_mm_gdbus_org_freedesktop_modem_manager1_method_info_inhibit_device.parent_struct,
  NULL
};

static const _ExtendedGDBusPropertyInfo _mm_gdbus_org_freedesktop_modem_manager1_property_info_version =
{
  {
    -1,
    (gchar *) "Version",
    (gchar *) "s",
    G_DBUS_PROPERTY_INFO_FLAGS_READABLE,
    NULL
  },
  "version",
  FALSE,
  TRUE
};

static const GDBusPropertyInfo * const _mm_gdbus_org_freedesktop_modem_manager1_property_info_pointers[] =
{
  &_mm_gdbus_org_freedesktop_modem_manager1_property_info_version.parent_struct,
  NULL
};

static const _ExtendedGDBusInterfaceInfo _mm_gdbus_org_freedesktop_modem_manager1_interface_info =
{
  {
    -1,
    (gchar *) "org.freedesktop.ModemManager1",
    (GDBusMethodInfo **) &_mm_gdbus_org_freedesktop_modem_manager1_method_info_pointers,
    NULL,
    (GDBusPropertyInfo **) &_mm_gdbus_org_freedesktop_modem_manager1_property_info_pointers,
    NULL
  },
  "org-freedesktop-modem-manager1",
};


/**
 * mm_gdbus_org_freedesktop_modem_manager1_interface_info:
 *
 * Gets a machine-readable description of the <link linkend="gdbus-interface-org-freedesktop-ModemManager1.top_of_page">org.freedesktop.ModemManager1</link> D-Bus interface.
 *
 * Returns: (transfer none): A #GDBusInterfaceInfo. Do not free.
 */
GDBusInterfaceInfo *
mm_gdbus_org_freedesktop_modem_manager1_interface_info (void)
{
  return (GDBusInterfaceInfo *) &_mm_gdbus_org_freedesktop_modem_manager1_interface_info.parent_struct;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_override_properties:
 * @klass: The class structure for a #GObject derived class.
 * @property_id_begin: The property id to assign to the first overridden property.
 *
 * Overrides all #GObject properties in the #MmGdbusOrgFreedesktopModemManager1 interface for a concrete class.
 * The properties are overridden in the order they are defined.
 *
 * Returns: The last property id.
 */
guint
mm_gdbus_org_freedesktop_modem_manager1_override_properties (GObjectClass *klass, guint property_id_begin)
{
  g_object_class_override_property (klass, property_id_begin++, "version");
  return property_id_begin - 1;
}


inline static void
mm_gdbus_org_freedesktop_modem_manager1_method_marshal_scan_devices (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_org_freedesktop_modem_manager1_method_marshal_set_logging (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_org_freedesktop_modem_manager1_method_marshal_report_kernel_event (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_VARIANT (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}

inline static void
mm_gdbus_org_freedesktop_modem_manager1_method_marshal_inhibit_device (
    GClosure     *closure,
    GValue       *return_value,
    unsigned int  n_param_values,
    const GValue *param_values,
    void         *invocation_hint,
    void         *marshal_data)
{
  _g_dbus_codegen_marshal_BOOLEAN__OBJECT_STRING_BOOLEAN (closure,
    return_value, n_param_values, param_values, invocation_hint, marshal_data);
}


/**
 * MmGdbusOrgFreedesktopModemManager1:
 *
 * Abstract interface type for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1.top_of_page">org.freedesktop.ModemManager1</link>.
 */

/**
 * MmGdbusOrgFreedesktopModemManager1Iface:
 * @parent_iface: The parent interface.
 * @handle_inhibit_device: Handler for the #MmGdbusOrgFreedesktopModemManager1::handle-inhibit-device signal.
 * @handle_report_kernel_event: Handler for the #MmGdbusOrgFreedesktopModemManager1::handle-report-kernel-event signal.
 * @handle_scan_devices: Handler for the #MmGdbusOrgFreedesktopModemManager1::handle-scan-devices signal.
 * @handle_set_logging: Handler for the #MmGdbusOrgFreedesktopModemManager1::handle-set-logging signal.
 * @get_version: Getter for the #MmGdbusOrgFreedesktopModemManager1:version property.
 *
 * Virtual table for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1.top_of_page">org.freedesktop.ModemManager1</link>.
 */

typedef MmGdbusOrgFreedesktopModemManager1Iface MmGdbusOrgFreedesktopModemManager1Interface;
G_DEFINE_INTERFACE (MmGdbusOrgFreedesktopModemManager1, mm_gdbus_org_freedesktop_modem_manager1, G_TYPE_OBJECT)

static void
mm_gdbus_org_freedesktop_modem_manager1_default_init (MmGdbusOrgFreedesktopModemManager1Iface *iface)
{
  /* GObject signals for incoming D-Bus method calls: */
  /**
   * MmGdbusOrgFreedesktopModemManager1::handle-scan-devices:
   * @object: A #MmGdbusOrgFreedesktopModemManager1.
   * @invocation: A #GDBusMethodInvocation.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1.ScanDevices">ScanDevices()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_org_freedesktop_modem_manager1_complete_scan_devices() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-scan-devices",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusOrgFreedesktopModemManager1Iface, handle_scan_devices),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_org_freedesktop_modem_manager1_method_marshal_scan_devices,
    G_TYPE_BOOLEAN,
    1,
    G_TYPE_DBUS_METHOD_INVOCATION);

  /**
   * MmGdbusOrgFreedesktopModemManager1::handle-set-logging:
   * @object: A #MmGdbusOrgFreedesktopModemManager1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_level: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1.SetLogging">SetLogging()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_org_freedesktop_modem_manager1_complete_set_logging() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-set-logging",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusOrgFreedesktopModemManager1Iface, handle_set_logging),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_org_freedesktop_modem_manager1_method_marshal_set_logging,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING);

  /**
   * MmGdbusOrgFreedesktopModemManager1::handle-report-kernel-event:
   * @object: A #MmGdbusOrgFreedesktopModemManager1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_properties: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1.ReportKernelEvent">ReportKernelEvent()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_org_freedesktop_modem_manager1_complete_report_kernel_event() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-report-kernel-event",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusOrgFreedesktopModemManager1Iface, handle_report_kernel_event),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_org_freedesktop_modem_manager1_method_marshal_report_kernel_event,
    G_TYPE_BOOLEAN,
    2,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_VARIANT);

  /**
   * MmGdbusOrgFreedesktopModemManager1::handle-inhibit-device:
   * @object: A #MmGdbusOrgFreedesktopModemManager1.
   * @invocation: A #GDBusMethodInvocation.
   * @arg_uid: Argument passed by remote caller.
   * @arg_inhibit: Argument passed by remote caller.
   *
   * Signal emitted when a remote caller is invoking the <link linkend="gdbus-method-org-freedesktop-ModemManager1.InhibitDevice">InhibitDevice()</link> D-Bus method.
   *
   * If a signal handler returns %TRUE, it means the signal handler will handle the invocation (e.g. take a reference to @invocation and eventually call mm_gdbus_org_freedesktop_modem_manager1_complete_inhibit_device() or e.g. g_dbus_method_invocation_return_error() on it) and no other signal handlers will run. If no signal handler handles the invocation, the %G_DBUS_ERROR_UNKNOWN_METHOD error is returned.
   *
   * Returns: %G_DBUS_METHOD_INVOCATION_HANDLED or %TRUE if the invocation was handled, %G_DBUS_METHOD_INVOCATION_UNHANDLED or %FALSE to let other signal handlers run.
   */
  g_signal_new ("handle-inhibit-device",
    G_TYPE_FROM_INTERFACE (iface),
    G_SIGNAL_RUN_LAST,
    G_STRUCT_OFFSET (MmGdbusOrgFreedesktopModemManager1Iface, handle_inhibit_device),
    g_signal_accumulator_true_handled,
    NULL,
      mm_gdbus_org_freedesktop_modem_manager1_method_marshal_inhibit_device,
    G_TYPE_BOOLEAN,
    3,
    G_TYPE_DBUS_METHOD_INVOCATION, G_TYPE_STRING, G_TYPE_BOOLEAN);

  /* GObject properties for D-Bus properties: */
  /**
   * MmGdbusOrgFreedesktopModemManager1:version:
   *
   * Represents the D-Bus property <link linkend="gdbus-property-org-freedesktop-ModemManager1.Version">"Version"</link>.
   *
   * Since the D-Bus property for this #GObject property is readable but not writable, it is meaningful to read from it on both the client- and service-side. It is only meaningful, however, to write to it on the service-side.
   */
  g_object_interface_install_property (iface,
    g_param_spec_string ("version", "Version", "Version", NULL, G_PARAM_READWRITE | G_PARAM_STATIC_STRINGS));
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_get_version: (skip)
 * @object: A #MmGdbusOrgFreedesktopModemManager1.
 *
 * Gets the value of the <link linkend="gdbus-property-org-freedesktop-ModemManager1.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * The returned value is only valid until the property changes so on the client-side it is only safe to use this function on the thread where @object was constructed. Use mm_gdbus_org_freedesktop_modem_manager1_dup_version() if on another thread.
 *
 * Returns: (transfer none) (nullable): The property value or %NULL if the property is not set. Do not free the returned value, it belongs to @object.
 */
const gchar *
mm_gdbus_org_freedesktop_modem_manager1_get_version (MmGdbusOrgFreedesktopModemManager1 *object)
{
  g_return_val_if_fail (MM_GDBUS_IS_ORG_FREEDESKTOP_MODEM_MANAGER1 (object), NULL);

  return MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_GET_IFACE (object)->get_version (object);
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_dup_version: (skip)
 * @object: A #MmGdbusOrgFreedesktopModemManager1.
 *
 * Gets a copy of the <link linkend="gdbus-property-org-freedesktop-ModemManager1.Version">"Version"</link> D-Bus property.
 *
 * Since this D-Bus property is readable, it is meaningful to use this function on both the client- and service-side.
 *
 * Returns: (transfer full) (nullable): The property value or %NULL if the property is not set. The returned value should be freed with g_free().
 */
gchar *
mm_gdbus_org_freedesktop_modem_manager1_dup_version (MmGdbusOrgFreedesktopModemManager1 *object)
{
  gchar *value;
  g_object_get (G_OBJECT (object), "version", &value, NULL);
  return value;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_set_version: (skip)
 * @object: A #MmGdbusOrgFreedesktopModemManager1.
 * @value: The value to set.
 *
 * Sets the <link linkend="gdbus-property-org-freedesktop-ModemManager1.Version">"Version"</link> D-Bus property to @value.
 *
 * Since this D-Bus property is not writable, it is only meaningful to use this function on the service-side.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_set_version (MmGdbusOrgFreedesktopModemManager1 *object, const gchar *value)
{
  g_object_set (G_OBJECT (object), "version", value, NULL);
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1.ScanDevices">ScanDevices()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices_finish() to get the result of the operation.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ScanDevices",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices_finish:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices_finish (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices_sync:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1.ScanDevices">ScanDevices()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_org_freedesktop_modem_manager1_call_scan_devices_sync (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ScanDevices",
    g_variant_new ("()"),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_set_logging:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @arg_level: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1.SetLogging">SetLogging()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_org_freedesktop_modem_manager1_call_set_logging_finish() to get the result of the operation.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_call_set_logging_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_call_set_logging (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    const gchar *arg_level,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "SetLogging",
    g_variant_new ("(s)",
                   arg_level),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_set_logging_finish:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_org_freedesktop_modem_manager1_call_set_logging().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_org_freedesktop_modem_manager1_call_set_logging().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_org_freedesktop_modem_manager1_call_set_logging_finish (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_set_logging_sync:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @arg_level: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1.SetLogging">SetLogging()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_call_set_logging() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_org_freedesktop_modem_manager1_call_set_logging_sync (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    const gchar *arg_level,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "SetLogging",
    g_variant_new ("(s)",
                   arg_level),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1.ReportKernelEvent">ReportKernelEvent()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event_finish() to get the result of the operation.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "ReportKernelEvent",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event_finish:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event_finish (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event_sync:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @arg_properties: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1.ReportKernelEvent">ReportKernelEvent()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_org_freedesktop_modem_manager1_call_report_kernel_event_sync (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    GVariant *arg_properties,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "ReportKernelEvent",
    g_variant_new ("(@a{sv})",
                   arg_properties),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_inhibit: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied or %NULL.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1.InhibitDevice">InhibitDevice()</link> D-Bus method on @proxy.
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device_finish() to get the result of the operation.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device_sync() for the synchronous, blocking version of this method.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    const gchar *arg_uid,
    gboolean arg_inhibit,
    GCancellable *cancellable,
    GAsyncReadyCallback callback,
    gpointer user_data)
{
  g_dbus_proxy_call (G_DBUS_PROXY (proxy),
    "InhibitDevice",
    g_variant_new ("(sb)",
                   arg_uid,
                   arg_inhibit),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    callback,
    user_data);
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device_finish:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device().
 * @error: Return location for error or %NULL.
 *
 * Finishes an operation started with mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device().
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device_finish (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    GAsyncResult *res,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_finish (G_DBUS_PROXY (proxy), res, error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device_sync:
 * @proxy: A #MmGdbusOrgFreedesktopModemManager1Proxy.
 * @arg_uid: Argument to pass with the method invocation.
 * @arg_inhibit: Argument to pass with the method invocation.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL.
 *
 * Synchronously invokes the <link linkend="gdbus-method-org-freedesktop-ModemManager1.InhibitDevice">InhibitDevice()</link> D-Bus method on @proxy. The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device() for the asynchronous version of this method.
 *
 * Returns: (skip): %TRUE if the call succeeded, %FALSE if @error is set.
 */
gboolean
mm_gdbus_org_freedesktop_modem_manager1_call_inhibit_device_sync (
    MmGdbusOrgFreedesktopModemManager1 *proxy,
    const gchar *arg_uid,
    gboolean arg_inhibit,
    GCancellable *cancellable,
    GError **error)
{
  GVariant *_ret;
  _ret = g_dbus_proxy_call_sync (G_DBUS_PROXY (proxy),
    "InhibitDevice",
    g_variant_new ("(sb)",
                   arg_uid,
                   arg_inhibit),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    cancellable,
    error);
  if (_ret == NULL)
    goto _out;
  g_variant_get (_ret,
                 "()");
  g_variant_unref (_ret);
_out:
  return _ret != NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_complete_scan_devices:
 * @object: A #MmGdbusOrgFreedesktopModemManager1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1.ScanDevices">ScanDevices()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_complete_scan_devices (
    MmGdbusOrgFreedesktopModemManager1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_complete_set_logging:
 * @object: A #MmGdbusOrgFreedesktopModemManager1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1.SetLogging">SetLogging()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_complete_set_logging (
    MmGdbusOrgFreedesktopModemManager1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_complete_report_kernel_event:
 * @object: A #MmGdbusOrgFreedesktopModemManager1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1.ReportKernelEvent">ReportKernelEvent()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_complete_report_kernel_event (
    MmGdbusOrgFreedesktopModemManager1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_complete_inhibit_device:
 * @object: A #MmGdbusOrgFreedesktopModemManager1.
 * @invocation: (transfer full): A #GDBusMethodInvocation.
 *
 * Helper function used in service implementations to finish handling invocations of the <link linkend="gdbus-method-org-freedesktop-ModemManager1.InhibitDevice">InhibitDevice()</link> D-Bus method. If you instead want to finish handling an invocation by returning an error, use g_dbus_method_invocation_return_error() or similar.
 *
 * This method will free @invocation, you cannot use it afterwards.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_complete_inhibit_device (
    MmGdbusOrgFreedesktopModemManager1 *object G_GNUC_UNUSED,
    GDBusMethodInvocation *invocation)
{
  g_dbus_method_invocation_return_value (invocation,
    g_variant_new ("()"));
}

/* ------------------------------------------------------------------------ */

/**
 * MmGdbusOrgFreedesktopModemManager1Proxy:
 *
 * The #MmGdbusOrgFreedesktopModemManager1Proxy structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusOrgFreedesktopModemManager1ProxyClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusOrgFreedesktopModemManager1Proxy.
 */

struct _MmGdbusOrgFreedesktopModemManager1ProxyPrivate
{
  GData *qdata;
};

static void mm_gdbus_org_freedesktop_modem_manager1_proxy_iface_init (MmGdbusOrgFreedesktopModemManager1Iface *iface);

#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusOrgFreedesktopModemManager1Proxy, mm_gdbus_org_freedesktop_modem_manager1_proxy, G_TYPE_DBUS_PROXY,
                         G_ADD_PRIVATE (MmGdbusOrgFreedesktopModemManager1Proxy)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1, mm_gdbus_org_freedesktop_modem_manager1_proxy_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusOrgFreedesktopModemManager1Proxy, mm_gdbus_org_freedesktop_modem_manager1_proxy, G_TYPE_DBUS_PROXY,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1, mm_gdbus_org_freedesktop_modem_manager1_proxy_iface_init))

#endif
static void
mm_gdbus_org_freedesktop_modem_manager1_proxy_finalize (GObject *object)
{
  MmGdbusOrgFreedesktopModemManager1Proxy *proxy = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_PROXY (object);
  g_datalist_clear (&proxy->priv->qdata);
  G_OBJECT_CLASS (mm_gdbus_org_freedesktop_modem_manager1_proxy_parent_class)->finalize (object);
}

static void
mm_gdbus_org_freedesktop_modem_manager1_proxy_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_org_freedesktop_modem_manager1_property_info_pointers[prop_id - 1];
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (object), info->parent_struct.name);
  if (info->use_gvariant)
    {
      g_value_set_variant (value, variant);
    }
  else
    {
      if (variant != NULL)
        g_dbus_gvariant_to_gvalue (variant, value);
    }
  if (variant != NULL)
    g_variant_unref (variant);
}

static void
mm_gdbus_org_freedesktop_modem_manager1_proxy_set_property_cb (GDBusProxy *proxy,
  GAsyncResult *res,
  gpointer      user_data)
{
  const _ExtendedGDBusPropertyInfo *info = user_data;
  GError *error;
  GVariant *_ret;
  error = NULL;
  _ret = g_dbus_proxy_call_finish (proxy, res, &error);
  if (!_ret)
    {
      g_warning ("Error setting property '%s' on interface org.freedesktop.ModemManager1: %s (%s, %d)",
                 info->parent_struct.name, 
                 error->message, g_quark_to_string (error->domain), error->code);
      g_error_free (error);
    }
  else
    {
      g_variant_unref (_ret);
    }
}

static void
mm_gdbus_org_freedesktop_modem_manager1_proxy_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  const _ExtendedGDBusPropertyInfo *info;
  GVariant *variant;
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_org_freedesktop_modem_manager1_property_info_pointers[prop_id - 1];
  variant = g_dbus_gvalue_to_gvariant (value, G_VARIANT_TYPE (info->parent_struct.signature));
  g_dbus_proxy_call (G_DBUS_PROXY (object),
    "org.freedesktop.DBus.Properties.Set",
    g_variant_new ("(ssv)", "org.freedesktop.ModemManager1", info->parent_struct.name, variant),
    G_DBUS_CALL_FLAGS_NONE,
    -1,
    NULL, (GAsyncReadyCallback) mm_gdbus_org_freedesktop_modem_manager1_proxy_set_property_cb, (GDBusPropertyInfo *) &info->parent_struct);
  g_variant_unref (variant);
}

static void
mm_gdbus_org_freedesktop_modem_manager1_proxy_g_signal (GDBusProxy *proxy,
  const gchar *sender_name G_GNUC_UNUSED,
  const gchar *signal_name,
  GVariant *parameters)
{
  _ExtendedGDBusSignalInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  gsize n;
  guint signal_id;
  info = (_ExtendedGDBusSignalInfo *) g_dbus_interface_info_lookup_signal ((GDBusInterfaceInfo *) &_mm_gdbus_org_freedesktop_modem_manager1_interface_info.parent_struct, signal_name);
  if (info == NULL)
    return;
  num_params = g_variant_n_children (parameters);
  paramv = g_new0 (GValue, num_params + 1);
  g_value_init (&paramv[0], MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1);
  g_value_set_object (&paramv[0], proxy);
  g_variant_iter_init (&iter, parameters);
  n = 1;
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.args[n - 1];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1);
  g_signal_emitv (paramv, signal_id, 0, NULL);
  for (n = 0; n < num_params + 1; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static void
mm_gdbus_org_freedesktop_modem_manager1_proxy_g_properties_changed (GDBusProxy *_proxy,
  GVariant *changed_properties,
  const gchar *const *invalidated_properties)
{
  MmGdbusOrgFreedesktopModemManager1Proxy *proxy = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_PROXY (_proxy);
  guint n;
  const gchar *key;
  GVariantIter *iter;
  _ExtendedGDBusPropertyInfo *info;
  g_variant_get (changed_properties, "a{sv}", &iter);
  while (g_variant_iter_next (iter, "{&sv}", &key, NULL))
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_org_freedesktop_modem_manager1_interface_info.parent_struct, key);
      g_datalist_remove_data (&proxy->priv->qdata, key);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
  g_variant_iter_free (iter);
  for (n = 0; invalidated_properties[n] != NULL; n++)
    {
      info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_org_freedesktop_modem_manager1_interface_info.parent_struct, invalidated_properties[n]);
      g_datalist_remove_data (&proxy->priv->qdata, invalidated_properties[n]);
      if (info != NULL)
        g_object_notify (G_OBJECT (proxy), info->hyphen_name);
    }
}

static const gchar *
mm_gdbus_org_freedesktop_modem_manager1_proxy_get_version (MmGdbusOrgFreedesktopModemManager1 *object)
{
  MmGdbusOrgFreedesktopModemManager1Proxy *proxy = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_PROXY (object);
  GVariant *variant;
  const gchar *value = NULL;
  variant = g_dbus_proxy_get_cached_property (G_DBUS_PROXY (proxy), "Version");
  if (variant != NULL)
    {
      value = g_variant_get_string (variant, NULL);
      g_variant_unref (variant);
    }
  return value;
}

static void
mm_gdbus_org_freedesktop_modem_manager1_proxy_init (MmGdbusOrgFreedesktopModemManager1Proxy *proxy)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  proxy->priv = mm_gdbus_org_freedesktop_modem_manager1_proxy_get_instance_private (proxy);
#else
  proxy->priv = G_TYPE_INSTANCE_GET_PRIVATE (proxy, MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1_PROXY, MmGdbusOrgFreedesktopModemManager1ProxyPrivate);
#endif

  g_dbus_proxy_set_interface_info (G_DBUS_PROXY (proxy), mm_gdbus_org_freedesktop_modem_manager1_interface_info ());
}

static void
mm_gdbus_org_freedesktop_modem_manager1_proxy_class_init (MmGdbusOrgFreedesktopModemManager1ProxyClass *klass)
{
  GObjectClass *gobject_class;
  GDBusProxyClass *proxy_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize     = mm_gdbus_org_freedesktop_modem_manager1_proxy_finalize;
  gobject_class->get_property = mm_gdbus_org_freedesktop_modem_manager1_proxy_get_property;
  gobject_class->set_property = mm_gdbus_org_freedesktop_modem_manager1_proxy_set_property;

  proxy_class = G_DBUS_PROXY_CLASS (klass);
  proxy_class->g_signal = mm_gdbus_org_freedesktop_modem_manager1_proxy_g_signal;
  proxy_class->g_properties_changed = mm_gdbus_org_freedesktop_modem_manager1_proxy_g_properties_changed;

  mm_gdbus_org_freedesktop_modem_manager1_override_properties (gobject_class, 1);

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusOrgFreedesktopModemManager1ProxyPrivate));
#endif
}

static void
mm_gdbus_org_freedesktop_modem_manager1_proxy_iface_init (MmGdbusOrgFreedesktopModemManager1Iface *iface)
{
  iface->get_version = mm_gdbus_org_freedesktop_modem_manager1_proxy_get_version;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_proxy_new:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Asynchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1.top_of_page">org.freedesktop.ModemManager1</link>. See g_dbus_proxy_new() for more details.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_org_freedesktop_modem_manager1_proxy_new_finish() to get the result of the operation.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_proxy_new_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_proxy_new (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1", NULL);
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_proxy_new_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_org_freedesktop_modem_manager1_proxy_new().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_org_freedesktop_modem_manager1_proxy_new().
 *
 * Returns: (transfer full) (type MmGdbusOrgFreedesktopModemManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusOrgFreedesktopModemManager1 *
mm_gdbus_org_freedesktop_modem_manager1_proxy_new_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1 (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_proxy_new_sync:
 * @connection: A #GDBusConnection.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: (nullable): A bus name (well-known or unique) or %NULL if @connection is not a message bus connection.
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Synchronously creates a proxy for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1.top_of_page">org.freedesktop.ModemManager1</link>. See g_dbus_proxy_new_sync() for more details.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_proxy_new() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusOrgFreedesktopModemManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusOrgFreedesktopModemManager1 *
mm_gdbus_org_freedesktop_modem_manager1_proxy_new_sync (
    GDBusConnection     *connection,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-connection", connection, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1", NULL);
  if (ret != NULL)
    return MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1 (ret);
  else
    return NULL;
}


/**
 * mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @callback: A #GAsyncReadyCallback to call when the request is satisfied.
 * @user_data: User data to pass to @callback.
 *
 * Like mm_gdbus_org_freedesktop_modem_manager1_proxy_new() but takes a #GBusType instead of a #GDBusConnection.
 *
 * When the operation is finished, @callback will be invoked in the thread-default main loop of the thread you are calling this method from (see g_main_context_push_thread_default()).
 * You can then call mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus_finish() to get the result of the operation.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus_sync() for the synchronous, blocking version of this constructor.
 */
void
mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GAsyncReadyCallback  callback,
    gpointer             user_data)
{
  g_async_initable_new_async (MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1_PROXY, G_PRIORITY_DEFAULT, cancellable, callback, user_data, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1", NULL);
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus_finish:
 * @res: The #GAsyncResult obtained from the #GAsyncReadyCallback passed to mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus().
 * @error: Return location for error or %NULL
 *
 * Finishes an operation started with mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus().
 *
 * Returns: (transfer full) (type MmGdbusOrgFreedesktopModemManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusOrgFreedesktopModemManager1 *
mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus_finish (
    GAsyncResult        *res,
    GError             **error)
{
  GObject *ret;
  GObject *source_object;
  source_object = g_async_result_get_source_object (res);
  ret = g_async_initable_new_finish (G_ASYNC_INITABLE (source_object), res, error);
  g_object_unref (source_object);
  if (ret != NULL)
    return MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1 (ret);
  else
    return NULL;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus_sync:
 * @bus_type: A #GBusType.
 * @flags: Flags from the #GDBusProxyFlags enumeration.
 * @name: A bus name (well-known or unique).
 * @object_path: An object path.
 * @cancellable: (nullable): A #GCancellable or %NULL.
 * @error: Return location for error or %NULL
 *
 * Like mm_gdbus_org_freedesktop_modem_manager1_proxy_new_sync() but takes a #GBusType instead of a #GDBusConnection.
 *
 * The calling thread is blocked until a reply is received.
 *
 * See mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus() for the asynchronous version of this constructor.
 *
 * Returns: (transfer full) (type MmGdbusOrgFreedesktopModemManager1Proxy): The constructed proxy object or %NULL if @error is set.
 */
MmGdbusOrgFreedesktopModemManager1 *
mm_gdbus_org_freedesktop_modem_manager1_proxy_new_for_bus_sync (
    GBusType             bus_type,
    GDBusProxyFlags      flags,
    const gchar         *name,
    const gchar         *object_path,
    GCancellable        *cancellable,
    GError             **error)
{
  GInitable *ret;
  ret = g_initable_new (MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1_PROXY, cancellable, error, "g-flags", flags, "g-name", name, "g-bus-type", bus_type, "g-object-path", object_path, "g-interface-name", "org.freedesktop.ModemManager1", NULL);
  if (ret != NULL)
    return MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1 (ret);
  else
    return NULL;
}


/* ------------------------------------------------------------------------ */

/**
 * MmGdbusOrgFreedesktopModemManager1Skeleton:
 *
 * The #MmGdbusOrgFreedesktopModemManager1Skeleton structure contains only private data and should only be accessed using the provided API.
 */

/**
 * MmGdbusOrgFreedesktopModemManager1SkeletonClass:
 * @parent_class: The parent class.
 *
 * Class structure for #MmGdbusOrgFreedesktopModemManager1Skeleton.
 */

struct _MmGdbusOrgFreedesktopModemManager1SkeletonPrivate
{
  GValue *properties;
  GList *changed_properties;
  GSource *changed_properties_idle_source;
  GMainContext *context;
  GMutex lock;
};

static void
_mm_gdbus_org_freedesktop_modem_manager1_skeleton_handle_method_call (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name,
  const gchar *method_name,
  GVariant *parameters,
  GDBusMethodInvocation *invocation,
  gpointer user_data)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (user_data);
  _ExtendedGDBusMethodInfo *info;
  GVariantIter iter;
  GVariant *child;
  GValue *paramv;
  gsize num_params;
  guint num_extra;
  gsize n;
  guint signal_id;
  GValue return_value = G_VALUE_INIT;
  info = (_ExtendedGDBusMethodInfo *) g_dbus_method_invocation_get_method_info (invocation);
  g_assert (info != NULL);
  num_params = g_variant_n_children (parameters);
  num_extra = info->pass_fdlist ? 3 : 2;  paramv = g_new0 (GValue, num_params + num_extra);
  n = 0;
  g_value_init (&paramv[n], MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1);
  g_value_set_object (&paramv[n++], skeleton);
  g_value_init (&paramv[n], G_TYPE_DBUS_METHOD_INVOCATION);
  g_value_set_object (&paramv[n++], invocation);
  if (info->pass_fdlist)
    {
#ifdef G_OS_UNIX
      g_value_init (&paramv[n], G_TYPE_UNIX_FD_LIST);
      g_value_set_object (&paramv[n++], g_dbus_message_get_unix_fd_list (g_dbus_method_invocation_get_message (invocation)));
#else
      g_assert_not_reached ();
#endif
    }
  g_variant_iter_init (&iter, parameters);
  while ((child = g_variant_iter_next_value (&iter)) != NULL)
    {
      _ExtendedGDBusArgInfo *arg_info = (_ExtendedGDBusArgInfo *) info->parent_struct.in_args[n - num_extra];
      if (arg_info->use_gvariant)
        {
          g_value_init (&paramv[n], G_TYPE_VARIANT);
          g_value_set_variant (&paramv[n], child);
          n++;
        }
      else
        g_dbus_gvariant_to_gvalue (child, &paramv[n++]);
      g_variant_unref (child);
    }
  signal_id = g_signal_lookup (info->signal_name, MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1);
  g_value_init (&return_value, G_TYPE_BOOLEAN);
  g_signal_emitv (paramv, signal_id, 0, &return_value);
  if (!g_value_get_boolean (&return_value))
    g_dbus_method_invocation_return_error (invocation, G_DBUS_ERROR, G_DBUS_ERROR_UNKNOWN_METHOD, "Method %s is not implemented on interface %s", method_name, interface_name);
  g_value_unset (&return_value);
  for (n = 0; n < num_params + num_extra; n++)
    g_value_unset (&paramv[n]);
  g_free (paramv);
}

static GVariant *
_mm_gdbus_org_freedesktop_modem_manager1_skeleton_handle_get_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GError **error,
  gpointer user_data)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  GVariant *ret;
  ret = NULL;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_org_freedesktop_modem_manager1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      g_value_init (&value, pspec->value_type);
      g_object_get_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      ret = g_dbus_gvalue_to_gvariant (&value, G_VARIANT_TYPE (info->parent_struct.signature));
      g_value_unset (&value);
    }
  return ret;
}

static gboolean
_mm_gdbus_org_freedesktop_modem_manager1_skeleton_handle_set_property (
  GDBusConnection *connection G_GNUC_UNUSED,
  const gchar *sender G_GNUC_UNUSED,
  const gchar *object_path G_GNUC_UNUSED,
  const gchar *interface_name G_GNUC_UNUSED,
  const gchar *property_name,
  GVariant *variant,
  GError **error,
  gpointer user_data)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (user_data);
  GValue value = G_VALUE_INIT;
  GParamSpec *pspec;
  _ExtendedGDBusPropertyInfo *info;
  gboolean ret;
  ret = FALSE;
  info = (_ExtendedGDBusPropertyInfo *) g_dbus_interface_info_lookup_property ((GDBusInterfaceInfo *) &_mm_gdbus_org_freedesktop_modem_manager1_interface_info.parent_struct, property_name);
  g_assert (info != NULL);
  pspec = g_object_class_find_property (G_OBJECT_GET_CLASS (skeleton), info->hyphen_name);
  if (pspec == NULL)
    {
      g_set_error (error, G_DBUS_ERROR, G_DBUS_ERROR_INVALID_ARGS, "No property with name %s", property_name);
    }
  else
    {
      if (info->use_gvariant)
        g_value_set_variant (&value, variant);
      else
        g_dbus_gvariant_to_gvalue (variant, &value);
      g_object_set_property (G_OBJECT (skeleton), info->hyphen_name, &value);
      g_value_unset (&value);
      ret = TRUE;
    }
  return ret;
}

static const GDBusInterfaceVTable _mm_gdbus_org_freedesktop_modem_manager1_skeleton_vtable =
{
  _mm_gdbus_org_freedesktop_modem_manager1_skeleton_handle_method_call,
  _mm_gdbus_org_freedesktop_modem_manager1_skeleton_handle_get_property,
  _mm_gdbus_org_freedesktop_modem_manager1_skeleton_handle_set_property,
  {NULL}
};

static GDBusInterfaceInfo *
mm_gdbus_org_freedesktop_modem_manager1_skeleton_dbus_interface_get_info (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return mm_gdbus_org_freedesktop_modem_manager1_interface_info ();
}

static GDBusInterfaceVTable *
mm_gdbus_org_freedesktop_modem_manager1_skeleton_dbus_interface_get_vtable (GDBusInterfaceSkeleton *skeleton G_GNUC_UNUSED)
{
  return (GDBusInterfaceVTable *) &_mm_gdbus_org_freedesktop_modem_manager1_skeleton_vtable;
}

static GVariant *
mm_gdbus_org_freedesktop_modem_manager1_skeleton_dbus_interface_get_properties (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (_skeleton);

  GVariantBuilder builder;
  guint n;
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
#else
  g_variant_builder_init(&builder, G_VARIANT_TYPE ("a{sv}"));
#endif
  if (_mm_gdbus_org_freedesktop_modem_manager1_interface_info.parent_struct.properties == NULL)
    goto out;
  for (n = 0; _mm_gdbus_org_freedesktop_modem_manager1_interface_info.parent_struct.properties[n] != NULL; n++)
    {
      GDBusPropertyInfo *info = _mm_gdbus_org_freedesktop_modem_manager1_interface_info.parent_struct.properties[n];
      if (info->flags & G_DBUS_PROPERTY_INFO_FLAGS_READABLE)
        {
          GVariant *value;
          value = _mm_gdbus_org_freedesktop_modem_manager1_skeleton_handle_get_property (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)), NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)), "org.freedesktop.ModemManager1", info->name, NULL, skeleton);
          if (value != NULL)
            {
              g_variant_take_ref (value);
              g_variant_builder_add (&builder, "{sv}", info->name, value);
              g_variant_unref (value);
            }
        }
    }
out:
  return g_variant_builder_end (&builder);
}

static gboolean _mm_gdbus_org_freedesktop_modem_manager1_emit_changed (gpointer user_data);

static void
mm_gdbus_org_freedesktop_modem_manager1_skeleton_dbus_interface_flush (GDBusInterfaceSkeleton *_skeleton)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (_skeleton);
  gboolean emit_changed = FALSE;

  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    {
      g_source_destroy (skeleton->priv->changed_properties_idle_source);
      skeleton->priv->changed_properties_idle_source = NULL;
      emit_changed = TRUE;
    }
  g_mutex_unlock (&skeleton->priv->lock);

  if (emit_changed)
    _mm_gdbus_org_freedesktop_modem_manager1_emit_changed (skeleton);
}

static void mm_gdbus_org_freedesktop_modem_manager1_skeleton_iface_init (MmGdbusOrgFreedesktopModemManager1Iface *iface);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
G_DEFINE_TYPE_WITH_CODE (MmGdbusOrgFreedesktopModemManager1Skeleton, mm_gdbus_org_freedesktop_modem_manager1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_ADD_PRIVATE (MmGdbusOrgFreedesktopModemManager1Skeleton)
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1, mm_gdbus_org_freedesktop_modem_manager1_skeleton_iface_init))

#else
G_DEFINE_TYPE_WITH_CODE (MmGdbusOrgFreedesktopModemManager1Skeleton, mm_gdbus_org_freedesktop_modem_manager1_skeleton, G_TYPE_DBUS_INTERFACE_SKELETON,
                         G_IMPLEMENT_INTERFACE (MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1, mm_gdbus_org_freedesktop_modem_manager1_skeleton_iface_init))

#endif
static void
mm_gdbus_org_freedesktop_modem_manager1_skeleton_finalize (GObject *object)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (object);
  guint n;
  for (n = 0; n < 1; n++)
    g_value_unset (&skeleton->priv->properties[n]);
  g_free (skeleton->priv->properties);
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  if (skeleton->priv->changed_properties_idle_source != NULL)
    g_source_destroy (skeleton->priv->changed_properties_idle_source);
  g_main_context_unref (skeleton->priv->context);
  g_mutex_clear (&skeleton->priv->lock);
  G_OBJECT_CLASS (mm_gdbus_org_freedesktop_modem_manager1_skeleton_parent_class)->finalize (object);
}

static void
mm_gdbus_org_freedesktop_modem_manager1_skeleton_get_property (GObject      *object,
  guint         prop_id,
  GValue       *value,
  GParamSpec   *pspec G_GNUC_UNUSED)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  g_mutex_lock (&skeleton->priv->lock);
  g_value_copy (&skeleton->priv->properties[prop_id - 1], value);
  g_mutex_unlock (&skeleton->priv->lock);
}

static gboolean
_mm_gdbus_org_freedesktop_modem_manager1_emit_changed (gpointer user_data)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (user_data);
  GList *l;
  GVariantBuilder builder;
  GVariantBuilder invalidated_builder;
  guint num_changes;

  g_mutex_lock (&skeleton->priv->lock);
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_84
  g_variant_builder_init_static (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init_static (&invalidated_builder, G_VARIANT_TYPE ("as"));
#else
  g_variant_builder_init (&builder, G_VARIANT_TYPE ("a{sv}"));
  g_variant_builder_init (&invalidated_builder, G_VARIANT_TYPE ("as"));
#endif
  for (l = skeleton->priv->changed_properties, num_changes = 0; l != NULL; l = l->next)
    {
      ChangedProperty *cp = l->data;
      GVariant *variant;
      const GValue *cur_value;

      cur_value = &skeleton->priv->properties[cp->prop_id - 1];
      if (!_g_value_equal (cur_value, &cp->orig_value))
        {
          variant = g_dbus_gvalue_to_gvariant (cur_value, G_VARIANT_TYPE (cp->info->parent_struct.signature));
          g_variant_builder_add (&builder, "{sv}", cp->info->parent_struct.name, variant);
          g_variant_unref (variant);
          num_changes++;
        }
    }
  if (num_changes > 0)
    {
      GList *connections, *ll;
      GVariant *signal_variant;
      signal_variant = g_variant_ref_sink (g_variant_new ("(sa{sv}as)", "org.freedesktop.ModemManager1",
                                           &builder, &invalidated_builder));
      connections = g_dbus_interface_skeleton_get_connections (G_DBUS_INTERFACE_SKELETON (skeleton));
      for (ll = connections; ll != NULL; ll = ll->next)
        {
          GDBusConnection *connection = ll->data;

          g_dbus_connection_emit_signal (connection,
                                         NULL, g_dbus_interface_skeleton_get_object_path (G_DBUS_INTERFACE_SKELETON (skeleton)),
                                         "org.freedesktop.DBus.Properties",
                                         "PropertiesChanged",
                                         signal_variant,
                                         NULL);
        }
      g_variant_unref (signal_variant);
      g_list_free_full (connections, g_object_unref);
    }
  else
    {
      g_variant_builder_clear (&builder);
      g_variant_builder_clear (&invalidated_builder);
    }
  g_list_free_full (skeleton->priv->changed_properties, (GDestroyNotify) _changed_property_free);
  skeleton->priv->changed_properties = NULL;
  skeleton->priv->changed_properties_idle_source = NULL;
  g_mutex_unlock (&skeleton->priv->lock);
  return FALSE;
}

static void
_mm_gdbus_org_freedesktop_modem_manager1_schedule_emit_changed (MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton, const _ExtendedGDBusPropertyInfo *info, guint prop_id, const GValue *orig_value)
{
  ChangedProperty *cp;
  GList *l;
  cp = NULL;
  for (l = skeleton->priv->changed_properties; l != NULL; l = l->next)
    {
      ChangedProperty *i_cp = l->data;
      if (i_cp->info == info)
        {
          cp = i_cp;
          break;
        }
    }
  if (cp == NULL)
    {
      cp = g_new0 (ChangedProperty, 1);
      cp->prop_id = prop_id;
      cp->info = info;
      skeleton->priv->changed_properties = g_list_prepend (skeleton->priv->changed_properties, cp);
      g_value_init (&cp->orig_value, G_VALUE_TYPE (orig_value));
      g_value_copy (orig_value, &cp->orig_value);
    }
}

static void
mm_gdbus_org_freedesktop_modem_manager1_skeleton_notify (GObject      *object,
  GParamSpec *pspec G_GNUC_UNUSED)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (object);
  g_mutex_lock (&skeleton->priv->lock);
  if (skeleton->priv->changed_properties != NULL &&
      skeleton->priv->changed_properties_idle_source == NULL)
    {
      skeleton->priv->changed_properties_idle_source = g_idle_source_new ();
      g_source_set_priority (skeleton->priv->changed_properties_idle_source, G_PRIORITY_DEFAULT);
      g_source_set_callback (skeleton->priv->changed_properties_idle_source, _mm_gdbus_org_freedesktop_modem_manager1_emit_changed, g_object_ref (skeleton), (GDestroyNotify) g_object_unref);
      g_source_set_name (skeleton->priv->changed_properties_idle_source, "[generated] _mm_gdbus_org_freedesktop_modem_manager1_emit_changed");
      g_source_attach (skeleton->priv->changed_properties_idle_source, skeleton->priv->context);
      g_source_unref (skeleton->priv->changed_properties_idle_source);
    }
  g_mutex_unlock (&skeleton->priv->lock);
}

static void
mm_gdbus_org_freedesktop_modem_manager1_skeleton_set_property (GObject      *object,
  guint         prop_id,
  const GValue *value,
  GParamSpec   *pspec)
{
  const _ExtendedGDBusPropertyInfo *info;
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (object);
  g_assert (prop_id != 0 && prop_id - 1 < 1);
  info = (const _ExtendedGDBusPropertyInfo *) _mm_gdbus_org_freedesktop_modem_manager1_property_info_pointers[prop_id - 1];
  g_mutex_lock (&skeleton->priv->lock);
  g_object_freeze_notify (object);
  if (!_g_value_equal (value, &skeleton->priv->properties[prop_id - 1]))
    {
      if (g_dbus_interface_skeleton_get_connection (G_DBUS_INTERFACE_SKELETON (skeleton)) != NULL &&
          info->emits_changed_signal)
        _mm_gdbus_org_freedesktop_modem_manager1_schedule_emit_changed (skeleton, info, prop_id, &skeleton->priv->properties[prop_id - 1]);
      g_value_copy (value, &skeleton->priv->properties[prop_id - 1]);
      g_object_notify_by_pspec (object, pspec);
    }
  g_mutex_unlock (&skeleton->priv->lock);
  g_object_thaw_notify (object);
}

static void
mm_gdbus_org_freedesktop_modem_manager1_skeleton_init (MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton)
{
#if GLIB_VERSION_MAX_ALLOWED >= GLIB_VERSION_2_38
  skeleton->priv = mm_gdbus_org_freedesktop_modem_manager1_skeleton_get_instance_private (skeleton);
#else
  skeleton->priv = G_TYPE_INSTANCE_GET_PRIVATE (skeleton, MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON, MmGdbusOrgFreedesktopModemManager1SkeletonPrivate);
#endif

  g_mutex_init (&skeleton->priv->lock);
  skeleton->priv->context = g_main_context_ref_thread_default ();
  skeleton->priv->properties = g_new0 (GValue, 1);
  g_value_init (&skeleton->priv->properties[0], G_TYPE_STRING);
}

static const gchar *
mm_gdbus_org_freedesktop_modem_manager1_skeleton_get_version (MmGdbusOrgFreedesktopModemManager1 *object)
{
  MmGdbusOrgFreedesktopModemManager1Skeleton *skeleton = MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON (object);
  const gchar *value;
  g_mutex_lock (&skeleton->priv->lock);
  value = g_marshal_value_peek_string (&(skeleton->priv->properties[0]));
  g_mutex_unlock (&skeleton->priv->lock);
  return value;
}

static void
mm_gdbus_org_freedesktop_modem_manager1_skeleton_class_init (MmGdbusOrgFreedesktopModemManager1SkeletonClass *klass)
{
  GObjectClass *gobject_class;
  GDBusInterfaceSkeletonClass *skeleton_class;

  gobject_class = G_OBJECT_CLASS (klass);
  gobject_class->finalize = mm_gdbus_org_freedesktop_modem_manager1_skeleton_finalize;
  gobject_class->get_property = mm_gdbus_org_freedesktop_modem_manager1_skeleton_get_property;
  gobject_class->set_property = mm_gdbus_org_freedesktop_modem_manager1_skeleton_set_property;
  gobject_class->notify       = mm_gdbus_org_freedesktop_modem_manager1_skeleton_notify;


  mm_gdbus_org_freedesktop_modem_manager1_override_properties (gobject_class, 1);

  skeleton_class = G_DBUS_INTERFACE_SKELETON_CLASS (klass);
  skeleton_class->get_info = mm_gdbus_org_freedesktop_modem_manager1_skeleton_dbus_interface_get_info;
  skeleton_class->get_properties = mm_gdbus_org_freedesktop_modem_manager1_skeleton_dbus_interface_get_properties;
  skeleton_class->flush = mm_gdbus_org_freedesktop_modem_manager1_skeleton_dbus_interface_flush;
  skeleton_class->get_vtable = mm_gdbus_org_freedesktop_modem_manager1_skeleton_dbus_interface_get_vtable;

#if GLIB_VERSION_MAX_ALLOWED < GLIB_VERSION_2_38
  g_type_class_add_private (klass, sizeof (MmGdbusOrgFreedesktopModemManager1SkeletonPrivate));
#endif
}

static void
mm_gdbus_org_freedesktop_modem_manager1_skeleton_iface_init (MmGdbusOrgFreedesktopModemManager1Iface *iface)
{
  iface->get_version = mm_gdbus_org_freedesktop_modem_manager1_skeleton_get_version;
}

/**
 * mm_gdbus_org_freedesktop_modem_manager1_skeleton_new:
 *
 * Creates a skeleton object for the D-Bus interface <link linkend="gdbus-interface-org-freedesktop-ModemManager1.top_of_page">org.freedesktop.ModemManager1</link>.
 *
 * Returns: (transfer full) (type MmGdbusOrgFreedesktopModemManager1Skeleton): The skeleton object.
 */
MmGdbusOrgFreedesktopModemManager1 *
mm_gdbus_org_freedesktop_modem_manager1_skeleton_new (void)
{
  return MM_GDBUS_ORG_FREEDESKTOP_MODEM_MANAGER1 (g_object_new (MM_GDBUS_TYPE_ORG_FREEDESKTOP_MODEM_MANAGER1_SKELETON, NULL));
}

