/* UndoTextReplace.c generated by valac 0.56.18, the Vala compiler
 * generated from UndoTextReplace.vala, do not modify */

/*
* Copyright (c) 2020 (https://github.com/phase1geo/Outliner)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;
typedef struct _UndoItemPrivate UndoItemPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_UNDO_TEXT_ITEM (undo_text_item_get_type ())
#define UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItem))
#define UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))
#define IS_UNDO_TEXT_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_ITEM))
#define IS_UNDO_TEXT_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_ITEM))
#define UNDO_TEXT_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_ITEM, UndoTextItemClass))

typedef struct _UndoTextItem UndoTextItem;
typedef struct _UndoTextItemClass UndoTextItemClass;
typedef struct _UndoTextItemPrivate UndoTextItemPrivate;

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_UNDO_TEXT_REPLACE (undo_text_replace_get_type ())
#define UNDO_TEXT_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_REPLACE, UndoTextReplace))
#define UNDO_TEXT_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_REPLACE, UndoTextReplaceClass))
#define IS_UNDO_TEXT_REPLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_REPLACE))
#define IS_UNDO_TEXT_REPLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_REPLACE))
#define UNDO_TEXT_REPLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_REPLACE, UndoTextReplaceClass))

typedef struct _UndoTextReplace UndoTextReplace;
typedef struct _UndoTextReplaceClass UndoTextReplaceClass;
typedef struct _UndoTextReplacePrivate UndoTextReplacePrivate;

#define TYPE_UNDO_TAG_INFO (undo_tag_info_get_type ())
#define UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfo))
#define UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))
#define IS_UNDO_TAG_INFO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TAG_INFO))
#define IS_UNDO_TAG_INFO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TAG_INFO))
#define UNDO_TAG_INFO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TAG_INFO, UndoTagInfoClass))

typedef struct _UndoTagInfo UndoTagInfo;
typedef struct _UndoTagInfoClass UndoTagInfoClass;
enum  {
	UNDO_TEXT_REPLACE_0_PROPERTY,
	UNDO_TEXT_REPLACE_ORIG_TEXT_PROPERTY,
	UNDO_TEXT_REPLACE_NEW_TEXT_PROPERTY,
	UNDO_TEXT_REPLACE_START_PROPERTY,
	UNDO_TEXT_REPLACE_TAGS_PROPERTY,
	UNDO_TEXT_REPLACE_NUM_PROPERTIES
};
static GParamSpec* undo_text_replace_properties[UNDO_TEXT_REPLACE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef enum  {
	UNDO_TEXT_OP_INSERT = 0,
	UNDO_TEXT_OP_DELETE,
	UNDO_TEXT_OP_REPLACE,
	UNDO_TEXT_OP_TAGADD,
	UNDO_TEXT_OP_TAGDEL,
	UNDO_TEXT_OP_TAGCLEAR
} UndoTextOp;

#define TYPE_UNDO_TEXT_OP (undo_text_op_get_type ())

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

#define TYPE_UNDO_TEXT_INSERT (undo_text_insert_get_type ())
#define UNDO_TEXT_INSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_TEXT_INSERT, UndoTextInsert))
#define UNDO_TEXT_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_TEXT_INSERT, UndoTextInsertClass))
#define IS_UNDO_TEXT_INSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_TEXT_INSERT))
#define IS_UNDO_TEXT_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_TEXT_INSERT))
#define UNDO_TEXT_INSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_TEXT_INSERT, UndoTextInsertClass))

typedef struct _UndoTextInsert UndoTextInsert;
typedef struct _UndoTextInsertClass UndoTextInsertClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _UndoItem {
	GObject parent_instance;
	UndoItemPrivate * priv;
};

struct _UndoItemClass {
	GObjectClass parent_class;
	void (*undo) (UndoItem* self, DrawArea* da);
	void (*redo) (UndoItem* self, DrawArea* da);
	gboolean (*matches) (UndoItem* self, UndoItem* item);
	void (*replace_with_item) (UndoItem* self, UndoItem* item);
	gchar* (*to_string) (UndoItem* self);
};

struct _UndoTextItem {
	UndoItem parent_instance;
	UndoTextItemPrivate * priv;
};

struct _UndoTextItemClass {
	UndoItemClass parent_class;
	gboolean (*merge) (UndoTextItem* self, CanvasText* ct, UndoTextItem* item);
	void (*undo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
	void (*redo_text) (UndoTextItem* self, DrawArea* da, CanvasText* ct);
};

struct _UndoTextReplace {
	UndoTextItem parent_instance;
	UndoTextReplacePrivate * priv;
};

struct _UndoTextReplaceClass {
	UndoTextItemClass parent_class;
};

struct _UndoTextReplacePrivate {
	gchar* _orig_text;
	gchar* _new_text;
	gint _start;
	GArray* _tags;
};

static gint UndoTextReplace_private_offset;
static gpointer undo_text_replace_parent_class = NULL;

VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType undo_text_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextItem, g_object_unref)
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN GType undo_text_replace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextReplace, g_object_unref)
VALA_EXTERN gpointer undo_tag_info_ref (gpointer instance);
VALA_EXTERN void undo_tag_info_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_undo_tag_info (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_undo_tag_info (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_undo_tag_info (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_undo_tag_info (const GValue* value);
VALA_EXTERN GType undo_tag_info_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTagInfo, undo_tag_info_unref)
VALA_EXTERN void undo_text_item_undo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN void undo_text_item_redo_text (UndoTextItem* self,
                               DrawArea* da,
                               CanvasText* ct);
VALA_EXTERN gboolean undo_text_item_merge (UndoTextItem* self,
                               CanvasText* ct,
                               UndoTextItem* item);
VALA_EXTERN UndoTextReplace* undo_text_replace_new (const gchar* orig_text,
                                        const gchar* new_text,
                                        gint start,
                                        GArray* tags,
                                        gint start_cursor,
                                        gint end_cursor);
VALA_EXTERN UndoTextReplace* undo_text_replace_construct (GType object_type,
                                              const gchar* orig_text,
                                              const gchar* new_text,
                                              gint start,
                                              GArray* tags,
                                              gint start_cursor,
                                              gint end_cursor);
VALA_EXTERN GType undo_text_op_get_type (void) G_GNUC_CONST ;
VALA_EXTERN UndoTextItem* undo_text_item_new (const gchar* name,
                                  UndoTextOp op,
                                  gint start_cursor,
                                  gint end_cursor);
VALA_EXTERN UndoTextItem* undo_text_item_construct (GType object_type,
                                        const gchar* name,
                                        UndoTextOp op,
                                        gint start_cursor,
                                        gint end_cursor);
static void undo_text_replace_set_orig_text (UndoTextReplace* self,
                                      const gchar* value);
static void undo_text_replace_set_new_text (UndoTextReplace* self,
                                     const gchar* value);
static void undo_text_replace_set_start (UndoTextReplace* self,
                                  gint value);
static void undo_text_replace_set_tags (UndoTextReplace* self,
                                 GArray* value);
static void undo_text_replace_real_undo_text (UndoTextItem* base,
                                       DrawArea* da,
                                       CanvasText* ct);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN void formatted_text_replace_text (FormattedText* self,
                                  gint index,
                                  gint chars,
                                  const gchar* str);
VALA_EXTERN gint undo_text_replace_get_start (UndoTextReplace* self);
VALA_EXTERN const gchar* undo_text_replace_get_new_text (UndoTextReplace* self);
VALA_EXTERN const gchar* undo_text_replace_get_orig_text (UndoTextReplace* self);
VALA_EXTERN void formatted_text_apply_tags (FormattedText* self,
                                GArray* tags,
                                gint start);
VALA_EXTERN GArray* undo_text_replace_get_tags (UndoTextReplace* self);
VALA_EXTERN void canvas_text_set_cursor_only (CanvasText* self,
                                  gint cursor);
VALA_EXTERN gint undo_text_item_get_start_cursor (UndoTextItem* self);
static void undo_text_replace_real_redo_text (UndoTextItem* base,
                                       DrawArea* da,
                                       CanvasText* ct);
VALA_EXTERN gint undo_text_item_get_end_cursor (UndoTextItem* self);
static gboolean undo_text_replace_real_merge (UndoTextItem* base,
                                       CanvasText* ct,
                                       UndoTextItem* item);
VALA_EXTERN UndoTextOp undo_text_item_get_op (UndoTextItem* self);
VALA_EXTERN GType undo_text_insert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoTextInsert, g_object_unref)
VALA_EXTERN const gchar* undo_text_insert_get_text (UndoTextInsert* self);
VALA_EXTERN void undo_text_item_set_end_cursor (UndoTextItem* self,
                                    gint value);
static void undo_text_replace_finalize (GObject * obj);
static GType undo_text_replace_get_type_once (void);
static void _vala_undo_text_replace_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec);
static void _vala_undo_text_replace_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
undo_text_replace_get_instance_private (UndoTextReplace* self)
{
	return G_STRUCT_MEMBER_P (self, UndoTextReplace_private_offset);
}

UndoTextReplace*
undo_text_replace_construct (GType object_type,
                             const gchar* orig_text,
                             const gchar* new_text,
                             gint start,
                             GArray* tags,
                             gint start_cursor,
                             gint end_cursor)
{
	UndoTextReplace * self = NULL;
	g_return_val_if_fail (orig_text != NULL, NULL);
	g_return_val_if_fail (new_text != NULL, NULL);
	g_return_val_if_fail (tags != NULL, NULL);
	self = (UndoTextReplace*) undo_text_item_construct (object_type, _ ("text replacement"), UNDO_TEXT_OP_REPLACE, start_cursor, end_cursor);
	undo_text_replace_set_orig_text (self, orig_text);
	undo_text_replace_set_new_text (self, new_text);
	undo_text_replace_set_start (self, start);
	undo_text_replace_set_tags (self, tags);
	return self;
}

UndoTextReplace*
undo_text_replace_new (const gchar* orig_text,
                       const gchar* new_text,
                       gint start,
                       GArray* tags,
                       gint start_cursor,
                       gint end_cursor)
{
	return undo_text_replace_construct (TYPE_UNDO_TEXT_REPLACE, orig_text, new_text, start, tags, start_cursor, end_cursor);
}

static void
undo_text_replace_real_undo_text (UndoTextItem* base,
                                  DrawArea* da,
                                  CanvasText* ct)
{
	UndoTextReplace * self;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	FormattedText* _tmp7_;
	FormattedText* _tmp8_;
	GArray* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	self = (UndoTextReplace*) base;
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_start;
	_tmp3_ = self->priv->_new_text;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_orig_text;
	formatted_text_replace_text (_tmp1_, _tmp2_, _tmp5_, _tmp6_);
	_tmp7_ = canvas_text_get_text (ct);
	_tmp8_ = _tmp7_;
	_tmp9_ = self->priv->_tags;
	_tmp10_ = self->priv->_start;
	formatted_text_apply_tags (_tmp8_, _tmp9_, _tmp10_);
	_tmp11_ = undo_text_item_get_start_cursor ((UndoTextItem*) self);
	_tmp12_ = _tmp11_;
	canvas_text_set_cursor_only (ct, _tmp12_);
	gtk_widget_queue_draw ((GtkWidget*) da);
}

static void
undo_text_replace_real_redo_text (UndoTextItem* base,
                                  DrawArea* da,
                                  CanvasText* ct)
{
	UndoTextReplace * self;
	FormattedText* _tmp0_;
	FormattedText* _tmp1_;
	gint _tmp2_;
	const gchar* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	const gchar* _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	self = (UndoTextReplace*) base;
	g_return_if_fail (da != NULL);
	g_return_if_fail (ct != NULL);
	_tmp0_ = canvas_text_get_text (ct);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->priv->_start;
	_tmp3_ = self->priv->_orig_text;
	_tmp4_ = strlen (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = self->priv->_new_text;
	formatted_text_replace_text (_tmp1_, _tmp2_, _tmp5_, _tmp6_);
	_tmp7_ = undo_text_item_get_end_cursor ((UndoTextItem*) self);
	_tmp8_ = _tmp7_;
	canvas_text_set_cursor_only (ct, _tmp8_);
	gtk_widget_queue_draw ((GtkWidget*) da);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
undo_text_replace_real_merge (UndoTextItem* base,
                              CanvasText* ct,
                              UndoTextItem* item)
{
	UndoTextReplace * self;
	gboolean _tmp0_ = FALSE;
	gint _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	self = (UndoTextReplace*) base;
	g_return_val_if_fail (ct != NULL, FALSE);
	g_return_val_if_fail (item != NULL, FALSE);
	_tmp1_ = undo_text_item_get_end_cursor ((UndoTextItem*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = undo_text_item_get_start_cursor (item);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == _tmp4_) {
		UndoTextOp _tmp5_;
		UndoTextOp _tmp6_;
		_tmp5_ = undo_text_item_get_op (item);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_ == UNDO_TEXT_OP_INSERT;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		UndoTextInsert* insert = NULL;
		UndoTextInsert* _tmp7_;
		const gchar* _tmp8_;
		UndoTextInsert* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		UndoTextInsert* _tmp14_;
		gint _tmp15_;
		gint _tmp16_;
		_tmp7_ = _g_object_ref0 (IS_UNDO_TEXT_INSERT (item) ? ((UndoTextInsert*) item) : NULL);
		insert = _tmp7_;
		_tmp8_ = self->priv->_new_text;
		_tmp9_ = insert;
		_tmp10_ = undo_text_insert_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strconcat (_tmp8_, _tmp11_, NULL);
		_tmp13_ = _tmp12_;
		undo_text_replace_set_new_text (self, _tmp13_);
		_g_free0 (_tmp13_);
		_tmp14_ = insert;
		_tmp15_ = undo_text_item_get_end_cursor ((UndoTextItem*) _tmp14_);
		_tmp16_ = _tmp15_;
		undo_text_item_set_end_cursor ((UndoTextItem*) self, _tmp16_);
		result = TRUE;
		_g_object_unref0 (insert);
		return result;
	}
	result = FALSE;
	return result;
}

const gchar*
undo_text_replace_get_orig_text (UndoTextReplace* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_orig_text;
	result = _tmp0_;
	return result;
}

static void
undo_text_replace_set_orig_text (UndoTextReplace* self,
                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_replace_get_orig_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_orig_text);
		self->priv->_orig_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, undo_text_replace_properties[UNDO_TEXT_REPLACE_ORIG_TEXT_PROPERTY]);
	}
}

const gchar*
undo_text_replace_get_new_text (UndoTextReplace* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_new_text;
	result = _tmp0_;
	return result;
}

static void
undo_text_replace_set_new_text (UndoTextReplace* self,
                                const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_replace_get_new_text (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_new_text);
		self->priv->_new_text = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, undo_text_replace_properties[UNDO_TEXT_REPLACE_NEW_TEXT_PROPERTY]);
	}
}

gint
undo_text_replace_get_start (UndoTextReplace* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_start;
	return result;
}

static void
undo_text_replace_set_start (UndoTextReplace* self,
                             gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_replace_get_start (self);
	if (old_value != value) {
		self->priv->_start = value;
		g_object_notify_by_pspec ((GObject *) self, undo_text_replace_properties[UNDO_TEXT_REPLACE_START_PROPERTY]);
	}
}

GArray*
undo_text_replace_get_tags (UndoTextReplace* self)
{
	GArray* result;
	GArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_tags;
	result = _tmp0_;
	return result;
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

static void
undo_text_replace_set_tags (UndoTextReplace* self,
                            GArray* value)
{
	GArray* old_value;
	g_return_if_fail (self != NULL);
	old_value = undo_text_replace_get_tags (self);
	if (old_value != value) {
		GArray* _tmp0_;
		_tmp0_ = _g_array_ref0 (value);
		_g_array_unref0 (self->priv->_tags);
		self->priv->_tags = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, undo_text_replace_properties[UNDO_TEXT_REPLACE_TAGS_PROPERTY]);
	}
}

static void
undo_text_replace_class_init (UndoTextReplaceClass * klass,
                              gpointer klass_data)
{
	undo_text_replace_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &UndoTextReplace_private_offset);
	((UndoTextItemClass *) klass)->undo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_replace_real_undo_text;
	((UndoTextItemClass *) klass)->redo_text = (void (*) (UndoTextItem*, DrawArea*, CanvasText*)) undo_text_replace_real_redo_text;
	((UndoTextItemClass *) klass)->merge = (gboolean (*) (UndoTextItem*, CanvasText*, UndoTextItem*)) undo_text_replace_real_merge;
	G_OBJECT_CLASS (klass)->get_property = _vala_undo_text_replace_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_undo_text_replace_set_property;
	G_OBJECT_CLASS (klass)->finalize = undo_text_replace_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_REPLACE_ORIG_TEXT_PROPERTY, undo_text_replace_properties[UNDO_TEXT_REPLACE_ORIG_TEXT_PROPERTY] = g_param_spec_string ("orig-text", "orig-text", "orig-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_REPLACE_NEW_TEXT_PROPERTY, undo_text_replace_properties[UNDO_TEXT_REPLACE_NEW_TEXT_PROPERTY] = g_param_spec_string ("new-text", "new-text", "new-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_REPLACE_START_PROPERTY, undo_text_replace_properties[UNDO_TEXT_REPLACE_START_PROPERTY] = g_param_spec_int ("start", "start", "start", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), UNDO_TEXT_REPLACE_TAGS_PROPERTY, undo_text_replace_properties[UNDO_TEXT_REPLACE_TAGS_PROPERTY] = g_param_spec_boxed ("tags", "tags", "tags", G_TYPE_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
undo_text_replace_instance_init (UndoTextReplace * self,
                                 gpointer klass)
{
	self->priv = undo_text_replace_get_instance_private (self);
}

static void
undo_text_replace_finalize (GObject * obj)
{
	UndoTextReplace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_UNDO_TEXT_REPLACE, UndoTextReplace);
	_g_free0 (self->priv->_orig_text);
	_g_free0 (self->priv->_new_text);
	_g_array_unref0 (self->priv->_tags);
	G_OBJECT_CLASS (undo_text_replace_parent_class)->finalize (obj);
}

static GType
undo_text_replace_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UndoTextReplaceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) undo_text_replace_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UndoTextReplace), 0, (GInstanceInitFunc) undo_text_replace_instance_init, NULL };
	GType undo_text_replace_type_id;
	undo_text_replace_type_id = g_type_register_static (TYPE_UNDO_TEXT_ITEM, "UndoTextReplace", &g_define_type_info, 0);
	UndoTextReplace_private_offset = g_type_add_instance_private (undo_text_replace_type_id, sizeof (UndoTextReplacePrivate));
	return undo_text_replace_type_id;
}

GType
undo_text_replace_get_type (void)
{
	static volatile gsize undo_text_replace_type_id__once = 0;
	if (g_once_init_enter (&undo_text_replace_type_id__once)) {
		GType undo_text_replace_type_id;
		undo_text_replace_type_id = undo_text_replace_get_type_once ();
		g_once_init_leave (&undo_text_replace_type_id__once, undo_text_replace_type_id);
	}
	return undo_text_replace_type_id__once;
}

static void
_vala_undo_text_replace_get_property (GObject * object,
                                      guint property_id,
                                      GValue * value,
                                      GParamSpec * pspec)
{
	UndoTextReplace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_REPLACE, UndoTextReplace);
	switch (property_id) {
		case UNDO_TEXT_REPLACE_ORIG_TEXT_PROPERTY:
		g_value_set_string (value, undo_text_replace_get_orig_text (self));
		break;
		case UNDO_TEXT_REPLACE_NEW_TEXT_PROPERTY:
		g_value_set_string (value, undo_text_replace_get_new_text (self));
		break;
		case UNDO_TEXT_REPLACE_START_PROPERTY:
		g_value_set_int (value, undo_text_replace_get_start (self));
		break;
		case UNDO_TEXT_REPLACE_TAGS_PROPERTY:
		g_value_set_boxed (value, undo_text_replace_get_tags (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_undo_text_replace_set_property (GObject * object,
                                      guint property_id,
                                      const GValue * value,
                                      GParamSpec * pspec)
{
	UndoTextReplace * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_UNDO_TEXT_REPLACE, UndoTextReplace);
	switch (property_id) {
		case UNDO_TEXT_REPLACE_ORIG_TEXT_PROPERTY:
		undo_text_replace_set_orig_text (self, g_value_get_string (value));
		break;
		case UNDO_TEXT_REPLACE_NEW_TEXT_PROPERTY:
		undo_text_replace_set_new_text (self, g_value_get_string (value));
		break;
		case UNDO_TEXT_REPLACE_START_PROPERTY:
		undo_text_replace_set_start (self, g_value_get_int (value));
		break;
		case UNDO_TEXT_REPLACE_TAGS_PROPERTY:
		undo_text_replace_set_tags (self, g_value_get_boxed (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

