/* NodeLink.c generated by valac 0.56.18, the Vala compiler
 * generated from NodeLink.vala, do not modify */

/*
* Copyright (c) 2018-2021 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <handy.h>
#include <glib/gi18n-lib.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NODE_LINK (node_link_get_type ())
#define NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LINK, NodeLink))
#define NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_LINK, NodeLinkClass))
#define IS_NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LINK))
#define IS_NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_LINK))
#define NODE_LINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_LINK, NodeLinkClass))

typedef struct _NodeLink NodeLink;
typedef struct _NodeLinkClass NodeLinkClass;
typedef struct _NodeLinkPrivate NodeLinkPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CANVAS_TEXT (canvas_text_get_type ())
#define CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CANVAS_TEXT, CanvasText))
#define CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CANVAS_TEXT, CanvasTextClass))
#define IS_CANVAS_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CANVAS_TEXT))
#define IS_CANVAS_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CANVAS_TEXT))
#define CANVAS_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CANVAS_TEXT, CanvasTextClass))

typedef struct _CanvasText CanvasText;
typedef struct _CanvasTextClass CanvasTextClass;

#define TYPE_FORMATTED_TEXT (formatted_text_get_type ())
#define FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FORMATTED_TEXT, FormattedText))
#define FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FORMATTED_TEXT, FormattedTextClass))
#define IS_FORMATTED_TEXT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FORMATTED_TEXT))
#define IS_FORMATTED_TEXT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FORMATTED_TEXT))
#define FORMATTED_TEXT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FORMATTED_TEXT, FormattedTextClass))

typedef struct _FormattedText FormattedText;
typedef struct _FormattedTextClass FormattedTextClass;

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;
typedef struct _Block29Data Block29Data;
#define _node_link_unref0(var) ((var == NULL) ? NULL : (var = (node_link_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
typedef struct _ParamSpecNodeLink ParamSpecNodeLink;

struct _NodeLink {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NodeLinkPrivate * priv;
};

struct _NodeLinkClass {
	GTypeClass parent_class;
	void (*finalize) (NodeLink *self);
};

struct _NodeLinkPrivate {
	gchar* _fname;
	gboolean _temp_file;
	gchar* _node_title;
	gint _node_id;
};

struct _Block29Data {
	int _ref_count_;
	NodeLink* self;
	DrawArea* other_da;
	Node* node;
};

struct _ParamSpecNodeLink {
	GParamSpec parent_instance;
};

static gint NodeLink_private_offset;
static gpointer node_link_parent_class = NULL;

VALA_EXTERN gpointer node_link_ref (gpointer instance);
VALA_EXTERN void node_link_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_link (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_node_link (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_node_link (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_node_link (const GValue* value);
VALA_EXTERN GType node_link_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeLink, node_link_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN NodeLink* node_link_new (Node* node);
VALA_EXTERN NodeLink* node_link_construct (GType object_type,
                               Node* node);
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN DrawArea* node_get_da (Node* self);
VALA_EXTERN GType document_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Document, g_object_unref)
VALA_EXTERN Document* draw_area_get_doc (DrawArea* self);
VALA_EXTERN const gchar* document_get_filename (Document* self);
VALA_EXTERN gboolean document_is_saved (Document* self);
VALA_EXTERN GType canvas_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (CanvasText, g_object_unref)
VALA_EXTERN CanvasText* node_get_name (Node* self);
VALA_EXTERN gpointer formatted_text_ref (gpointer instance);
VALA_EXTERN void formatted_text_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_formatted_text (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_formatted_text (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_formatted_text (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_formatted_text (const GValue* value);
VALA_EXTERN GType formatted_text_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FormattedText, formatted_text_unref)
VALA_EXTERN FormattedText* canvas_text_get_text (CanvasText* self);
VALA_EXTERN const gchar* formatted_text_get_text (FormattedText* self);
VALA_EXTERN gint node_id (Node* self);
VALA_EXTERN NodeLink* node_link_new_for_local (gint id);
VALA_EXTERN NodeLink* node_link_construct_for_local (GType object_type,
                                         gint id);
VALA_EXTERN NodeLink* node_link_new_from_xml (xmlNode* node);
VALA_EXTERN NodeLink* node_link_construct_from_xml (GType object_type,
                                        xmlNode* node);
VALA_EXTERN void node_link_load (NodeLink* self,
                     xmlNode* node);
VALA_EXTERN gboolean node_link_is_local (NodeLink* self);
VALA_EXTERN gboolean node_link_is_linkable (NodeLink* self,
                                const gchar* fname,
                                gint node_id);
VALA_EXTERN gboolean node_link_matches (NodeLink* self,
                            NodeLink* other);
VALA_EXTERN void node_link_normalize (NodeLink* self,
                          DrawArea* da);
VALA_EXTERN void node_link_select (NodeLink* self,
                       DrawArea* da);
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN MainWindow* draw_area_get_win (DrawArea* self);
VALA_EXTERN gboolean main_window_open_file (MainWindow* self,
                                const gchar* fname,
                                gboolean dir);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
VALA_EXTERN DrawArea* main_window_get_current_da (MainWindow* self,
                                      const gchar* caller);
VALA_EXTERN Node* draw_area_get_node (DrawArea* self,
                          GArray* nodes,
                          gint id);
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
static gboolean ___lambda110_ (Block29Data* _data29_);
VALA_EXTERN gboolean draw_area_select_node (DrawArea* self,
                                Node* n,
                                gboolean animate);
static gboolean ____lambda110__gsource_func (gpointer self);
VALA_EXTERN gchar* node_link_get_tooltip (NodeLink* self,
                              DrawArea* da);
VALA_EXTERN gboolean document_xml_find (const gchar* fname,
                            gint id,
                            gchar** name);
VALA_EXTERN gchar* node_link_get_markdown_text (NodeLink* self,
                                    DrawArea* da);
VALA_EXTERN xmlNode* node_link_save (NodeLink* self);
VALA_EXTERN gint node_link_get_node_id (NodeLink* self);
static void node_link_finalize (NodeLink * obj);
static GType node_link_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
node_link_get_instance_private (NodeLink* self)
{
	return G_STRUCT_MEMBER_P (self, NodeLink_private_offset);
}

NodeLink*
node_link_construct (GType object_type,
                     Node* node)
{
	NodeLink* self = NULL;
	DrawArea* _tmp0_;
	DrawArea* _tmp1_;
	Document* _tmp2_;
	Document* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	DrawArea* _tmp7_;
	DrawArea* _tmp8_;
	Document* _tmp9_;
	Document* _tmp10_;
	CanvasText* _tmp11_;
	CanvasText* _tmp12_;
	FormattedText* _tmp13_;
	FormattedText* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_val_if_fail (node != NULL, NULL);
	self = (NodeLink*) g_type_create_instance (object_type);
	_tmp0_ = node_get_da (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = draw_area_get_doc (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = document_get_filename (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup (_tmp5_);
	_g_free0 (self->priv->_fname);
	self->priv->_fname = _tmp6_;
	_g_object_unref0 (_tmp3_);
	_tmp7_ = node_get_da (node);
	_tmp8_ = _tmp7_;
	_tmp9_ = draw_area_get_doc (_tmp8_);
	_tmp10_ = _tmp9_;
	self->priv->_temp_file = !document_is_saved (_tmp10_);
	_g_object_unref0 (_tmp10_);
	_tmp11_ = node_get_name (node);
	_tmp12_ = _tmp11_;
	_tmp13_ = canvas_text_get_text (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = formatted_text_get_text (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = g_strdup (_tmp16_);
	_g_free0 (self->priv->_node_title);
	self->priv->_node_title = _tmp17_;
	self->priv->_node_id = node_id (node);
	return self;
}

NodeLink*
node_link_new (Node* node)
{
	return node_link_construct (TYPE_NODE_LINK, node);
}

NodeLink*
node_link_construct_for_local (GType object_type,
                               gint id)
{
	NodeLink* self = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (NodeLink*) g_type_create_instance (object_type);
	_tmp0_ = g_strdup ("");
	_g_free0 (self->priv->_fname);
	self->priv->_fname = _tmp0_;
	self->priv->_temp_file = FALSE;
	_tmp1_ = g_strdup ("");
	_g_free0 (self->priv->_node_title);
	self->priv->_node_title = _tmp1_;
	self->priv->_node_id = id;
	return self;
}

NodeLink*
node_link_new_for_local (gint id)
{
	return node_link_construct_for_local (TYPE_NODE_LINK, id);
}

NodeLink*
node_link_construct_from_xml (GType object_type,
                              xmlNode* node)
{
	NodeLink* self = NULL;
	self = (NodeLink*) g_type_create_instance (object_type);
	self->priv->_temp_file = FALSE;
	node_link_load (self, node);
	return self;
}

NodeLink*
node_link_new_from_xml (xmlNode* node)
{
	return node_link_construct_from_xml (TYPE_NODE_LINK, node);
}

gboolean
node_link_is_local (NodeLink* self)
{
	const gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_fname;
	result = g_strcmp0 (_tmp0_, "") == 0;
	return result;
}

gboolean
node_link_is_linkable (NodeLink* self,
                       const gchar* fname,
                       gint node_id)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (fname != NULL, FALSE);
	_tmp1_ = self->priv->_fname;
	if (g_strcmp0 (fname, _tmp1_) == 0) {
		_tmp0_ = self->priv->_node_id != node_id;
	} else {
		_tmp0_ = !self->priv->_temp_file;
	}
	result = _tmp0_;
	return result;
}

gboolean
node_link_matches (NodeLink* self,
                   NodeLink* other)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp1_ = self->priv->_fname;
	_tmp2_ = other->priv->_fname;
	if (g_strcmp0 (_tmp1_, _tmp2_) == 0) {
		_tmp0_ = self->priv->_node_id == other->priv->_node_id;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
node_link_normalize (NodeLink* self,
                     DrawArea* da)
{
	const gchar* _tmp0_;
	Document* _tmp1_;
	Document* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = self->priv->_fname;
	_tmp1_ = draw_area_get_doc (da);
	_tmp2_ = _tmp1_;
	_tmp3_ = document_get_filename (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_strcmp0 (_tmp0_, _tmp4_) == 0;
	_g_object_unref0 (_tmp2_);
	if (_tmp5_) {
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = g_strdup ("");
		_g_free0 (self->priv->_fname);
		self->priv->_fname = _tmp6_;
		self->priv->_temp_file = FALSE;
		_tmp7_ = g_strdup ("");
		_g_free0 (self->priv->_node_title);
		self->priv->_node_title = _tmp7_;
	}
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		NodeLink* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->node);
		_g_object_unref0 (_data29_->other_da);
		_node_link_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static gboolean
___lambda110_ (Block29Data* _data29_)
{
	NodeLink* self;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	gboolean result;
	self = _data29_->self;
	_tmp0_ = _data29_->other_da;
	_tmp1_ = _data29_->node;
	if (draw_area_select_node (_tmp0_, _tmp1_, FALSE)) {
		DrawArea* _tmp2_;
		_tmp2_ = _data29_->other_da;
		gtk_widget_queue_draw ((GtkWidget*) _tmp2_);
	} else {
	}
	result = FALSE;
	return result;
}

static gboolean
____lambda110__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda110_ (self);
	return result;
}

void
node_link_select (NodeLink* self,
                  DrawArea* da)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp1_ = self->priv->_fname;
	if (g_strcmp0 (_tmp1_, "") == 0) {
		_tmp0_ = TRUE;
	} else {
		MainWindow* _tmp2_;
		MainWindow* _tmp3_;
		const gchar* _tmp4_;
		_tmp2_ = draw_area_get_win (da);
		_tmp3_ = _tmp2_;
		_tmp4_ = self->priv->_fname;
		_tmp0_ = main_window_open_file (_tmp3_, _tmp4_, FALSE);
	}
	if (_tmp0_) {
		Block29Data* _data29_;
		MainWindow* _tmp5_;
		MainWindow* _tmp6_;
		DrawArea* _tmp7_;
		DrawArea* _tmp8_;
		DrawArea* _tmp9_;
		GArray* _tmp10_;
		GArray* _tmp11_;
		Node* _tmp12_;
		Node* _tmp13_;
		_data29_ = g_slice_new0 (Block29Data);
		_data29_->_ref_count_ = 1;
		_data29_->self = node_link_ref (self);
		_tmp5_ = draw_area_get_win (da);
		_tmp6_ = _tmp5_;
		_tmp7_ = main_window_get_current_da (_tmp6_, NULL);
		_data29_->other_da = _tmp7_;
		_tmp8_ = _data29_->other_da;
		_tmp9_ = _data29_->other_da;
		_tmp10_ = draw_area_get_nodes (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = draw_area_get_node (_tmp8_, _tmp11_, self->priv->_node_id);
		_tmp13_ = _tmp12_;
		_g_array_unref0 (_tmp11_);
		_data29_->node = _tmp13_;
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda110__gsource_func, block29_data_ref (_data29_), block29_data_unref);
		block29_data_unref (_data29_);
		_data29_ = NULL;
	}
}

gchar*
node_link_get_tooltip (NodeLink* self,
                       DrawArea* da)
{
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = self->priv->_fname;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		Node* linked_node = NULL;
		GArray* _tmp1_;
		GArray* _tmp2_;
		Node* _tmp3_;
		Node* _tmp4_;
		Node* _tmp5_;
		_tmp1_ = draw_area_get_nodes (da);
		_tmp2_ = _tmp1_;
		_tmp3_ = draw_area_get_node (da, _tmp2_, self->priv->_node_id);
		_tmp4_ = _tmp3_;
		_g_array_unref0 (_tmp2_);
		linked_node = _tmp4_;
		_tmp5_ = linked_node;
		if (_tmp5_ != NULL) {
			Node* _tmp6_;
			CanvasText* _tmp7_;
			CanvasText* _tmp8_;
			FormattedText* _tmp9_;
			FormattedText* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			_tmp6_ = linked_node;
			_tmp7_ = node_get_name (_tmp6_);
			_tmp8_ = _tmp7_;
			_tmp9_ = canvas_text_get_text (_tmp8_);
			_tmp10_ = _tmp9_;
			_tmp11_ = formatted_text_get_text (_tmp10_);
			_tmp12_ = _tmp11_;
			_tmp13_ = g_strdup (_tmp12_);
			result = _tmp13_;
			_g_object_unref0 (linked_node);
			return result;
		} else {
			gchar* _tmp14_;
			_tmp14_ = g_strdup (_ ("No node found"));
			result = _tmp14_;
			_g_object_unref0 (linked_node);
			return result;
		}
		_g_object_unref0 (linked_node);
	} else {
		gchar* title = NULL;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		_tmp15_ = g_strdup (_ ("No node found"));
		title = _tmp15_;
		_tmp16_ = self->priv->_fname;
		document_xml_find (_tmp16_, self->priv->_node_id, &title);
		_tmp17_ = title;
		_tmp18_ = self->priv->_fname;
		_tmp19_ = g_strdup_printf ("%s\n\nFilename: %s", _tmp17_, _tmp18_);
		result = _tmp19_;
		_g_free0 (title);
		return result;
	}
}

gchar*
node_link_get_markdown_text (NodeLink* self,
                             DrawArea* da)
{
	const gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (da != NULL, NULL);
	_tmp0_ = self->priv->_fname;
	if (g_strcmp0 (_tmp0_, "") == 0) {
		Node* linked_node = NULL;
		GArray* _tmp1_;
		GArray* _tmp2_;
		Node* _tmp3_;
		Node* _tmp4_;
		Node* _tmp5_;
		CanvasText* _tmp6_;
		CanvasText* _tmp7_;
		FormattedText* _tmp8_;
		FormattedText* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp1_ = draw_area_get_nodes (da);
		_tmp2_ = _tmp1_;
		_tmp3_ = draw_area_get_node (da, _tmp2_, self->priv->_node_id);
		_tmp4_ = _tmp3_;
		_g_array_unref0 (_tmp2_);
		linked_node = _tmp4_;
		_tmp5_ = linked_node;
		_tmp6_ = node_get_name (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = canvas_text_get_text (_tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = formatted_text_get_text (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_strdup (_tmp11_);
		result = _tmp12_;
		_g_object_unref0 (linked_node);
		return result;
	} else {
		gchar* title = NULL;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		const gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		_tmp13_ = g_strdup ("");
		title = _tmp13_;
		_tmp14_ = self->priv->_fname;
		document_xml_find (_tmp14_, self->priv->_node_id, &title);
		_tmp15_ = self->priv->_fname;
		_tmp16_ = g_path_get_basename (_tmp15_);
		_tmp17_ = _tmp16_;
		_tmp18_ = title;
		_tmp19_ = g_strdup_printf ("%s: %s", _tmp17_, _tmp18_);
		_tmp20_ = _tmp19_;
		_g_free0 (_tmp17_);
		result = _tmp20_;
		_g_free0 (title);
		return result;
	}
}

xmlNode*
node_link_save (NodeLink* self)
{
	xmlNode* node = NULL;
	xmlNode* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "nodelink");
	node = _tmp0_;
	_tmp1_ = g_strdup_printf ("%i", self->priv->_node_id);
	_tmp2_ = _tmp1_;
	xmlNewProp (node, (xmlChar*) "id", (xmlChar*) _tmp2_);
	_g_free0 (_tmp2_);
	_tmp3_ = self->priv->_fname;
	xmlNewProp (node, (xmlChar*) "fname", (xmlChar*) _tmp3_);
	_tmp4_ = self->priv->_node_title;
	xmlNewProp (node, (xmlChar*) "title", (xmlChar*) _tmp4_);
	result = node;
	return result;
}

void
node_link_load (NodeLink* self,
                xmlNode* node)
{
	gchar* id = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (gchar*) xmlGetProp (node, (xmlChar*) "id");
	id = _tmp0_;
	_tmp1_ = id;
	if (_tmp1_ != NULL) {
		const gchar* _tmp2_;
		_tmp2_ = id;
		self->priv->_node_id = atoi (_tmp2_);
	}
	_tmp3_ = (gchar*) xmlGetProp (node, (xmlChar*) "fname");
	_g_free0 (self->priv->_fname);
	self->priv->_fname = _tmp3_;
	_tmp4_ = (gchar*) xmlGetProp (node, (xmlChar*) "title");
	_g_free0 (self->priv->_node_title);
	self->priv->_node_title = _tmp4_;
	_g_free0 (id);
}

gint
node_link_get_node_id (NodeLink* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_node_id;
	return result;
}

static void
value_node_link_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_node_link_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		node_link_unref (value->data[0].v_pointer);
	}
}

static void
value_node_link_copy_value (const GValue* src_value,
                            GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = node_link_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_node_link_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_node_link_collect_value (GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NodeLink * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = node_link_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_node_link_lcopy_value (const GValue* value,
                             guint n_collect_values,
                             GTypeCValue* collect_values,
                             guint collect_flags)
{
	NodeLink ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = node_link_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_node_link (const gchar* name,
                      const gchar* nick,
                      const gchar* blurb,
                      GType object_type,
                      GParamFlags flags)
{
	ParamSpecNodeLink* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NODE_LINK), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_node_link (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_LINK), NULL);
	return value->data[0].v_pointer;
}

void
value_set_node_link (GValue* value,
                     gpointer v_object)
{
	NodeLink * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_LINK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE_LINK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		node_link_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_link_unref (old);
	}
}

void
value_take_node_link (GValue* value,
                      gpointer v_object)
{
	NodeLink * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_LINK));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE_LINK));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_link_unref (old);
	}
}

static void
node_link_class_init (NodeLinkClass * klass,
                      gpointer klass_data)
{
	node_link_parent_class = g_type_class_peek_parent (klass);
	((NodeLinkClass *) klass)->finalize = node_link_finalize;
	g_type_class_adjust_private_offset (klass, &NodeLink_private_offset);
}

static void
node_link_instance_init (NodeLink * self,
                         gpointer klass)
{
	self->priv = node_link_get_instance_private (self);
	self->ref_count = 1;
}

static void
node_link_finalize (NodeLink * obj)
{
	NodeLink * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NODE_LINK, NodeLink);
	g_signal_handlers_destroy (self);
	_g_free0 (self->priv->_fname);
	_g_free0 (self->priv->_node_title);
}

static GType
node_link_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_node_link_init, value_node_link_free_value, value_node_link_copy_value, value_node_link_peek_pointer, "p", value_node_link_collect_value, "p", value_node_link_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NodeLinkClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) node_link_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NodeLink), 0, (GInstanceInitFunc) node_link_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType node_link_type_id;
	node_link_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NodeLink", &g_define_type_info, &g_define_type_fundamental_info, 0);
	NodeLink_private_offset = g_type_add_instance_private (node_link_type_id, sizeof (NodeLinkPrivate));
	return node_link_type_id;
}

GType
node_link_get_type (void)
{
	static volatile gsize node_link_type_id__once = 0;
	if (g_once_init_enter (&node_link_type_id__once)) {
		GType node_link_type_id;
		node_link_type_id = node_link_get_type_once ();
		g_once_init_leave (&node_link_type_id__once, node_link_type_id);
	}
	return node_link_type_id__once;
}

gpointer
node_link_ref (gpointer instance)
{
	NodeLink * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
node_link_unref (gpointer instance)
{
	NodeLink * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NODE_LINK_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

