/* NodeInspector.c generated by valac 0.56.18, the Vala compiler
 * generated from NodeInspector.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <handy.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NODE_INSPECTOR (node_inspector_get_type ())
#define NODE_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_INSPECTOR, NodeInspector))
#define NODE_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_INSPECTOR, NodeInspectorClass))
#define IS_NODE_INSPECTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_INSPECTOR))
#define IS_NODE_INSPECTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_INSPECTOR))
#define NODE_INSPECTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_INSPECTOR, NodeInspectorClass))

typedef struct _NodeInspector NodeInspector;
typedef struct _NodeInspectorClass NodeInspectorClass;
typedef struct _NodeInspectorPrivate NodeInspectorPrivate;

#define TYPE_NOTE_VIEW (note_view_get_type ())
#define NOTE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NOTE_VIEW, NoteView))
#define NOTE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NOTE_VIEW, NoteViewClass))
#define IS_NOTE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NOTE_VIEW))
#define IS_NOTE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NOTE_VIEW))
#define NOTE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NOTE_VIEW, NoteViewClass))

typedef struct _NoteView NoteView;
typedef struct _NoteViewClass NoteViewClass;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
enum  {
	NODE_INSPECTOR_0_PROPERTY,
	NODE_INSPECTOR_NUM_PROPERTIES
};
static GParamSpec* node_inspector_properties[NODE_INSPECTOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MAIN_WINDOW (main_window_get_type ())
#define MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN_WINDOW, MainWindow))
#define MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN_WINDOW, MainWindowClass))
#define IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN_WINDOW))
#define IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN_WINDOW))
#define MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN_WINDOW, MainWindowClass))

typedef struct _MainWindow MainWindow;
typedef struct _MainWindowClass MainWindowClass;

#define TYPE_UNICODE_INSERT (unicode_insert_get_type ())
#define UNICODE_INSERT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNICODE_INSERT, UnicodeInsert))
#define UNICODE_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNICODE_INSERT, UnicodeInsertClass))
#define IS_UNICODE_INSERT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNICODE_INSERT))
#define IS_UNICODE_INSERT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNICODE_INSERT))
#define UNICODE_INSERT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNICODE_INSERT, UnicodeInsertClass))

typedef struct _UnicodeInsert UnicodeInsert;
typedef struct _UnicodeInsertClass UnicodeInsertClass;

#define TYPE_NODE_LINK (node_link_get_type ())
#define NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LINK, NodeLink))
#define NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_LINK, NodeLinkClass))
#define IS_NODE_LINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LINK))
#define IS_NODE_LINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_LINK))
#define NODE_LINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_LINK, NodeLinkClass))

typedef struct _NodeLink NodeLink;
typedef struct _NodeLinkClass NodeLinkClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))

#define TYPE_UNDO_BUFFER (undo_buffer_get_type ())
#define UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_BUFFER, UndoBuffer))
#define UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_BUFFER, UndoBufferClass))
#define IS_UNDO_BUFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_BUFFER))
#define IS_UNDO_BUFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_BUFFER))
#define UNDO_BUFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_BUFFER, UndoBufferClass))

typedef struct _UndoBuffer UndoBuffer;
typedef struct _UndoBufferClass UndoBufferClass;

#define TYPE_UNDO_ITEM (undo_item_get_type ())
#define UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_ITEM, UndoItem))
#define UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_ITEM, UndoItemClass))
#define IS_UNDO_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_ITEM))
#define IS_UNDO_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_ITEM))
#define UNDO_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_ITEM, UndoItemClass))

typedef struct _UndoItem UndoItem;
typedef struct _UndoItemClass UndoItemClass;

#define TYPE_UNDO_NODE_NOTE (undo_node_note_get_type ())
#define UNDO_NODE_NOTE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_UNDO_NODE_NOTE, UndoNodeNote))
#define UNDO_NODE_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_UNDO_NODE_NOTE, UndoNodeNoteClass))
#define IS_UNDO_NODE_NOTE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_UNDO_NODE_NOTE))
#define IS_UNDO_NODE_NOTE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_UNDO_NODE_NOTE))
#define UNDO_NODE_NOTE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_UNDO_NODE_NOTE, UndoNodeNoteClass))

typedef struct _UndoNodeNote UndoNodeNote;
typedef struct _UndoNodeNoteClass UndoNodeNoteClass;

#define TYPE_NODE_LINKS (node_links_get_type ())
#define NODE_LINKS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_LINKS, NodeLinks))
#define NODE_LINKS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_LINKS, NodeLinksClass))
#define IS_NODE_LINKS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_LINKS))
#define IS_NODE_LINKS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_LINKS))
#define NODE_LINKS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_LINKS, NodeLinksClass))

typedef struct _NodeLinks NodeLinks;
typedef struct _NodeLinksClass NodeLinksClass;
#define _node_link_unref0(var) ((var == NULL) ? NULL : (var = (node_link_unref (var), NULL)))

#define TYPE_NODE_IMAGE (node_image_get_type ())
#define NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_IMAGE, NodeImage))
#define NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_IMAGE, NodeImageClass))
#define IS_NODE_IMAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_IMAGE))
#define IS_NODE_IMAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_IMAGE))
#define NODE_IMAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_IMAGE, NodeImageClass))

typedef struct _NodeImage NodeImage;
typedef struct _NodeImageClass NodeImageClass;

#define TYPE_IMAGE_MANAGER (image_manager_get_type ())
#define IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_IMAGE_MANAGER, ImageManager))
#define IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_IMAGE_MANAGER, ImageManagerClass))
#define IS_IMAGE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_IMAGE_MANAGER))
#define IS_IMAGE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_IMAGE_MANAGER))
#define IMAGE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_IMAGE_MANAGER, ImageManagerClass))

typedef struct _ImageManager ImageManager;
typedef struct _ImageManagerClass ImageManagerClass;
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _NodeInspector {
	GtkBox parent_instance;
	NodeInspectorPrivate * priv;
};

struct _NodeInspectorClass {
	GtkBoxClass parent_class;
};

struct _NodeInspectorPrivate {
	GtkScrolledWindow* _sw;
	GtkSwitch* _task;
	GtkSwitch* _fold;
	GtkSwitch* _sequence;
	GtkRevealer* _link_reveal;
	GtkColorButton* _link_color;
	NoteView* _note;
	DrawArea* _da;
	GtkButton* _detach_btn;
	gchar* _orig_note;
	Node* _node;
	GtkStack* _image_stack;
	GtkImage* _image;
	GtkButton* _image_btn;
	GtkLabel* _image_loc;
	GtkSwitch* _override;
	GtkColorButton* _root_color;
	GtkRevealer* _root_color_reveal;
	GtkRevealer* _color_reveal;
	GtkToggleButton* _resize;
	gboolean _ignore_changes;
};

static gint NodeInspector_private_offset;
static gpointer node_inspector_parent_class = NULL;

VALA_EXTERN GType node_inspector_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeInspector, g_object_unref)
VALA_EXTERN GType note_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NoteView, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MainWindow, g_object_unref)
VALA_EXTERN NodeInspector* node_inspector_new (MainWindow* win);
VALA_EXTERN NodeInspector* node_inspector_construct (GType object_type,
                                         MainWindow* win);
static void node_inspector_create_title (NodeInspector* self);
static void node_inspector_create_task (NodeInspector* self);
static void node_inspector_create_fold (NodeInspector* self);
static void node_inspector_create_sequence (NodeInspector* self);
static void node_inspector_create_link (NodeInspector* self);
static void node_inspector_create_color (NodeInspector* self);
static void node_inspector_create_note (NodeInspector* self,
                                 MainWindow* win);
static void node_inspector_create_image (NodeInspector* self);
static void node_inspector_create_buttons (NodeInspector* self);
static void node_inspector_tab_changed (NodeInspector* self,
                                 DrawArea* da);
static void _node_inspector_tab_changed_main_window_canvas_changed (MainWindow* _sender,
                                                             DrawArea* da,
                                                             gpointer self);
static void node_inspector_node_changed (NodeInspector* self);
static void _node_inspector_node_changed_draw_area_current_changed (DrawArea* _sender,
                                                             DrawArea* da,
                                                             gpointer self);
static void node_inspector_theme_changed (NodeInspector* self,
                                   DrawArea* da);
static void _node_inspector_theme_changed_draw_area_theme_changed (DrawArea* _sender,
                                                            DrawArea* da,
                                                            gpointer self);
VALA_EXTERN void node_inspector_set_width (NodeInspector* self,
                               gint width);
VALA_EXTERN gchar* utils_make_title (const gchar* str);
static gboolean node_inspector_task_changed (NodeInspector* self,
                                      GdkEventButton* e);
static gboolean _node_inspector_task_changed_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                       GdkEventButton* event,
                                                                       gpointer self);
static gboolean node_inspector_fold_changed (NodeInspector* self,
                                      GdkEventButton* e);
static gboolean _node_inspector_fold_changed_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                       GdkEventButton* event,
                                                                       gpointer self);
static gboolean node_inspector_sequence_changed (NodeInspector* self,
                                          GdkEventButton* e);
static gboolean _node_inspector_sequence_changed_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                           GdkEventButton* event,
                                                                           gpointer self);
static void __lambda55_ (NodeInspector* self);
VALA_EXTERN void draw_area_change_current_link_color (DrawArea* self,
                                          GdkRGBA* color);
static void ___lambda55__gtk_color_button_color_set (GtkColorButton* _sender,
                                              gpointer self);
static gboolean node_inspector_root_color_changed (NodeInspector* self,
                                            GdkEventButton* e);
static gboolean _node_inspector_root_color_changed_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                             GdkEventButton* event,
                                                                             gpointer self);
static void __lambda56_ (NodeInspector* self);
static void ___lambda56__gtk_color_button_color_set (GtkColorButton* _sender,
                                              gpointer self);
VALA_EXTERN NoteView* note_view_new (void);
VALA_EXTERN NoteView* note_view_construct (GType object_type);
VALA_EXTERN gpointer unicode_insert_ref (gpointer instance);
VALA_EXTERN void unicode_insert_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_unicode_insert (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_unicode_insert (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_unicode_insert (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_unicode_insert (const GValue* value);
VALA_EXTERN GType unicode_insert_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UnicodeInsert, unicode_insert_unref)
VALA_EXTERN void note_view_add_unicode_completion (NoteView* self,
                                       MainWindow* win,
                                       UnicodeInsert* unicoder);
VALA_EXTERN UnicodeInsert* main_window_get_unicoder (MainWindow* self);
static void node_inspector_note_changed (NodeInspector* self);
static void _node_inspector_note_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                           gpointer self);
static gboolean node_inspector_note_focus_in (NodeInspector* self,
                                       GdkEventFocus* e);
static gboolean _node_inspector_note_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                                  GdkEventFocus* event,
                                                                  gpointer self);
static gboolean node_inspector_note_focus_out (NodeInspector* self,
                                        GdkEventFocus* e);
static gboolean _node_inspector_note_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                    GdkEventFocus* event,
                                                                    gpointer self);
VALA_EXTERN gpointer node_link_ref (gpointer instance);
VALA_EXTERN void node_link_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_link (const gchar* name,
                                  const gchar* nick,
                                  const gchar* blurb,
                                  GType object_type,
                                  GParamFlags flags);
VALA_EXTERN void value_set_node_link (GValue* value,
                          gpointer v_object);
VALA_EXTERN void value_take_node_link (GValue* value,
                           gpointer v_object);
VALA_EXTERN gpointer value_get_node_link (const GValue* value);
VALA_EXTERN GType node_link_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeLink, node_link_unref)
static gint node_inspector_note_node_link_added (NodeInspector* self,
                                          NodeLink* link,
                                          gchar** text);
static gint _node_inspector_note_node_link_added_note_view_node_link_added (NoteView* _sender,
                                                                     NodeLink* link,
                                                                     gchar** text,
                                                                     gpointer self);
static void node_inspector_note_node_link_clicked (NodeInspector* self,
                                            gint id);
static void _node_inspector_note_node_link_clicked_note_view_node_link_clicked (NoteView* _sender,
                                                                         gint id,
                                                                         gpointer self);
static void node_inspector_note_node_link_hover (NodeInspector* self,
                                          gint id);
static void _node_inspector_note_node_link_hover_note_view_node_link_hover (NoteView* _sender,
                                                                     gint id,
                                                                     gpointer self);
static GtkBox* node_inspector_create_image_add (NodeInspector* self);
static GtkBox* node_inspector_create_image_edit (NodeInspector* self);
static void node_inspector_image_button_clicked (NodeInspector* self);
static void _node_inspector_image_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                              gpointer self);
static void __lambda57_ (NodeInspector* self);
VALA_EXTERN void draw_area_edit_current_image (DrawArea* self);
static void ___lambda57__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda66_ (NodeInspector* self);
VALA_EXTERN void draw_area_delete_current_image (DrawArea* self);
static void ___lambda66__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda67_ (NodeInspector* self);
VALA_EXTERN Node* draw_area_get_current_node (DrawArea* self);
VALA_EXTERN void node_set_image_resizable (Node* self,
                               gboolean value);
VALA_EXTERN void draw_area_auto_save (DrawArea* self);
static void ___lambda67__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                             gpointer self);
static void __lambda68_ (NodeInspector* self,
                  GdkDragContext* ctx,
                  gint x,
                  gint y,
                  GtkSelectionData* data,
                  guint info,
                  guint t);
VALA_EXTERN gboolean draw_area_update_current_image (DrawArea* self,
                                         const gchar* uri);
static void ___lambda68__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                 GdkDragContext* context,
                                                 gint x,
                                                 gint y,
                                                 GtkSelectionData* selection_data,
                                                 guint info,
                                                 guint time_,
                                                 gpointer self);
VALA_EXTERN void draw_area_add_current_image (DrawArea* self);
static gboolean node_inspector_image_link_clicked (NodeInspector* self,
                                            const gchar* uri);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void node_inspector_node_copy (NodeInspector* self);
static void _node_inspector_node_copy_gtk_button_clicked (GtkButton* _sender,
                                                   gpointer self);
static void node_inspector_node_cut (NodeInspector* self);
static void _node_inspector_node_cut_gtk_button_clicked (GtkButton* _sender,
                                                  gpointer self);
static void node_inspector_node_detach (NodeInspector* self);
static void _node_inspector_node_detach_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
static void node_inspector_node_delete (NodeInspector* self);
static void _node_inspector_node_delete_gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self);
VALA_EXTERN void draw_area_change_current_task (DrawArea* self,
                                    gboolean enable,
                                    gboolean done);
VALA_EXTERN gboolean node_task_enabled (Node* self);
VALA_EXTERN void draw_area_change_current_fold (DrawArea* self,
                                    gboolean folded,
                                    gboolean deep);
VALA_EXTERN gboolean node_get_folded (Node* self);
VALA_EXTERN gboolean node_get_sequence (Node* self);
VALA_EXTERN void node_set_sequence (Node* self,
                        gboolean value);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN void draw_area_change_current_node_note (DrawArea* self,
                                         const gchar* note);
VALA_EXTERN const gchar* node_get_note (Node* self);
VALA_EXTERN GType undo_buffer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoBuffer, g_object_unref)
VALA_EXTERN UndoBuffer* draw_area_get_undo_buffer (DrawArea* self);
VALA_EXTERN GType undo_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoItem, g_object_unref)
VALA_EXTERN void undo_buffer_add_item (UndoBuffer* self,
                           UndoItem* item);
VALA_EXTERN UndoNodeNote* undo_node_note_new (Node* n,
                                  const gchar* old_note);
VALA_EXTERN UndoNodeNote* undo_node_note_construct (GType object_type,
                                        Node* n,
                                        const gchar* old_note);
VALA_EXTERN GType undo_node_note_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UndoNodeNote, g_object_unref)
VALA_EXTERN gint draw_area_add_note_node_link (DrawArea* self,
                                   NodeLink* link,
                                   gchar** text);
VALA_EXTERN void draw_area_note_node_link_clicked (DrawArea* self,
                                       gint id);
VALA_EXTERN gpointer node_links_ref (gpointer instance);
VALA_EXTERN void node_links_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_links (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_links (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_links (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_links (const GValue* value);
VALA_EXTERN GType node_links_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeLinks, node_links_unref)
VALA_EXTERN NodeLinks* draw_area_get_node_links (DrawArea* self);
VALA_EXTERN NodeLink* node_links_get_node_link (NodeLinks* self,
                                    gint id);
VALA_EXTERN void note_view_show_tooltip (NoteView* self,
                             const gchar* tooltip);
VALA_EXTERN gchar* node_link_get_tooltip (NodeLink* self,
                              DrawArea* da);
VALA_EXTERN void minder_clipboard_copy_nodes (DrawArea* d);
VALA_EXTERN void draw_area_cut_node_to_clipboard (DrawArea* self);
VALA_EXTERN void draw_area_detach (DrawArea* self);
VALA_EXTERN void draw_area_delete_node (DrawArea* self);
VALA_EXTERN void node_inspector_grab_note (NodeInspector* self);
static gboolean node_inspector_resize_changed (NodeInspector* self,
                                        GdkEventButton* e);
VALA_EXTERN gboolean node_get_image_resizable (Node* self);
VALA_EXTERN gint theme_num_link_colors (void);
VALA_EXTERN void theme_link_color (Theme* self,
                       gint index,
                       GdkRGBA* result);
VALA_EXTERN gboolean node_is_leaf (Node* self);
VALA_EXTERN gboolean node_is_root (Node* self);
VALA_EXTERN gboolean node_get_link_color_set (Node* self);
VALA_EXTERN GdkRGBA* node_get_link_color (Node* self);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
VALA_EXTERN Node* node_get_parent (Node* self);
VALA_EXTERN gpointer node_image_ref (gpointer instance);
VALA_EXTERN void node_image_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_image (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_node_image (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_node_image (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_node_image (const GValue* value);
VALA_EXTERN GType node_image_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeImage, node_image_unref)
VALA_EXTERN NodeImage* node_get_image (Node* self);
VALA_EXTERN gpointer image_manager_ref (gpointer instance);
VALA_EXTERN void image_manager_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_image_manager (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_image_manager (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_image_manager (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_image_manager (const GValue* value);
VALA_EXTERN GType image_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ImageManager, image_manager_unref)
VALA_EXTERN ImageManager* draw_area_get_image_manager (DrawArea* self);
VALA_EXTERN gchar* image_manager_get_uri (ImageManager* self,
                              gint id);
VALA_EXTERN gint node_image_get_id (NodeImage* self);
VALA_EXTERN void node_image_set_image (NodeImage* self,
                           GtkImage* img);
VALA_EXTERN void node_inspector_grab_first (NodeInspector* self);
static void node_inspector_finalize (GObject * obj);
static GType node_inspector_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GtkTargetEntry NODE_INSPECTOR_DRAG_TARGETS[1] = {{"text/uri-list", (guint) 0, (guint) 0}};

static inline gpointer
node_inspector_get_instance_private (NodeInspector* self)
{
	return G_STRUCT_MEMBER_P (self, NodeInspector_private_offset);
}

static void
_node_inspector_tab_changed_main_window_canvas_changed (MainWindow* _sender,
                                                        DrawArea* da,
                                                        gpointer self)
{
	node_inspector_tab_changed ((NodeInspector*) self, da);
}

NodeInspector*
node_inspector_construct (GType object_type,
                          MainWindow* win)
{
	NodeInspector * self = NULL;
	g_return_val_if_fail (win != NULL, NULL);
	self = (NodeInspector*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 0, NULL);
	node_inspector_create_title (self);
	node_inspector_create_task (self);
	node_inspector_create_fold (self);
	node_inspector_create_sequence (self);
	node_inspector_create_link (self);
	node_inspector_create_color (self);
	node_inspector_create_note (self, win);
	node_inspector_create_image (self);
	node_inspector_create_buttons (self);
	gtk_widget_show_all ((GtkWidget*) self);
	g_signal_connect_object (win, "canvas-changed", (GCallback) _node_inspector_tab_changed_main_window_canvas_changed, self, 0);
	return self;
}

NodeInspector*
node_inspector_new (MainWindow* win)
{
	return node_inspector_construct (TYPE_NODE_INSPECTOR, win);
}

static void
_node_inspector_node_changed_draw_area_current_changed (DrawArea* _sender,
                                                        DrawArea* da,
                                                        gpointer self)
{
	node_inspector_node_changed ((NodeInspector*) self);
}

static void
_node_inspector_theme_changed_draw_area_theme_changed (DrawArea* _sender,
                                                       DrawArea* da,
                                                       gpointer self)
{
	node_inspector_theme_changed ((NodeInspector*) self, da);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
node_inspector_tab_changed (NodeInspector* self,
                            DrawArea* da)
{
	DrawArea* _tmp0_;
	DrawArea* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	if (_tmp0_ != NULL) {
		DrawArea* _tmp1_;
		guint _tmp2_;
		DrawArea* _tmp3_;
		guint _tmp4_;
		_tmp1_ = self->priv->_da;
		g_signal_parse_name ("current-changed", TYPE_DRAW_AREA, &_tmp2_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _node_inspector_node_changed_draw_area_current_changed, self);
		_tmp3_ = self->priv->_da;
		g_signal_parse_name ("theme-changed", TYPE_DRAW_AREA, &_tmp4_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp3_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp4_, 0, NULL, (GCallback) _node_inspector_theme_changed_draw_area_theme_changed, self);
	}
	_tmp5_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp5_;
	if (da != NULL) {
		g_signal_connect_object (da, "current-changed", (GCallback) _node_inspector_node_changed_draw_area_current_changed, self, 0);
		g_signal_connect_object (da, "theme-changed", (GCallback) _node_inspector_theme_changed_draw_area_theme_changed, self, 0);
		node_inspector_node_changed (self);
	}
}

void
node_inspector_set_width (NodeInspector* self,
                          gint width)
{
	GtkScrolledWindow* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_sw;
	g_object_set ((GtkWidget*) _tmp0_, "width-request", width, NULL);
}

static void
node_inspector_create_title (NodeInspector* self)
{
	GtkLabel* title = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strconcat ("<big>", _ ("Node"), NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat (_tmp1_, "</big>", NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_tmp3_);
	g_object_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	title = _tmp5_;
	gtk_label_set_use_markup (title, TRUE);
	gtk_label_set_justify (title, GTK_JUSTIFY_CENTER);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) title, FALSE, TRUE, (guint) 0);
	_g_object_unref0 (title);
}

static gboolean
_node_inspector_task_changed_gtk_widget_button_release_event (GtkWidget* _sender,
                                                              GdkEventButton* event,
                                                              gpointer self)
{
	gboolean result;
	result = node_inspector_task_changed ((NodeInspector*) self, event);
	return result;
}

static void
node_inspector_create_task (NodeInspector* self)
{
	GtkLabel* lbl = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkSwitch* _tmp5_;
	GtkBox* box = NULL;
	GtkBox* _tmp6_;
	GtkSwitch* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = utils_make_title (_ ("Task"));
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	lbl = _tmp3_;
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_use_markup (lbl, TRUE);
	_tmp4_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_task);
	self->priv->_task = _tmp4_;
	_tmp5_ = self->priv->_task;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "button-release-event", (GCallback) _node_inspector_task_changed_gtk_widget_button_release_event, self, 0);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	box = _tmp6_;
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, TRUE, (guint) 0);
	_tmp7_ = self->priv->_task;
	gtk_box_pack_end (box, (GtkWidget*) _tmp7_, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) box, FALSE, TRUE, (guint) 5);
	_g_object_unref0 (box);
	_g_object_unref0 (lbl);
}

static gboolean
_node_inspector_fold_changed_gtk_widget_button_release_event (GtkWidget* _sender,
                                                              GdkEventButton* event,
                                                              gpointer self)
{
	gboolean result;
	result = node_inspector_fold_changed ((NodeInspector*) self, event);
	return result;
}

static void
node_inspector_create_fold (NodeInspector* self)
{
	GtkLabel* lbl = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkSwitch* _tmp5_;
	GtkBox* box = NULL;
	GtkBox* _tmp6_;
	GtkSwitch* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = utils_make_title (_ ("Fold"));
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	lbl = _tmp3_;
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_use_markup (lbl, TRUE);
	_tmp4_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_fold);
	self->priv->_fold = _tmp4_;
	_tmp5_ = self->priv->_fold;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "button-release-event", (GCallback) _node_inspector_fold_changed_gtk_widget_button_release_event, self, 0);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	box = _tmp6_;
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, TRUE, (guint) 0);
	_tmp7_ = self->priv->_fold;
	gtk_box_pack_end (box, (GtkWidget*) _tmp7_, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) box, FALSE, TRUE, (guint) 5);
	_g_object_unref0 (box);
	_g_object_unref0 (lbl);
}

static gboolean
_node_inspector_sequence_changed_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                  GdkEventButton* event,
                                                                  gpointer self)
{
	gboolean result;
	result = node_inspector_sequence_changed ((NodeInspector*) self, event);
	return result;
}

static void
node_inspector_create_sequence (NodeInspector* self)
{
	GtkLabel* lbl = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_ = NULL;
	GtkLabel* _tmp3_;
	GtkImage* info = NULL;
	gchar* _tmp4_;
	GtkImage* _tmp5_ = NULL;
	GtkSwitch* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkBox* box = NULL;
	GtkBox* _tmp8_;
	GtkSwitch* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = utils_make_title (_ ("Sequence"));
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	gtk_label_set_xalign (_tmp2_, (gfloat) 0);
	gtk_label_set_use_markup (_tmp2_, TRUE);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	lbl = _tmp3_;
	_tmp4_ = g_strdup (_ ("When set, automatically numbers child nodes and displays them as a seq" \
"uence."));
	_tmp5_ = (GtkImage*) gtk_image_new_from_icon_name ("dialog-information-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_widget_set_halign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp5_, _tmp4_);
	_g_free0 (_tmp4_);
	g_object_ref_sink (_tmp5_);
	info = _tmp5_;
	_tmp6_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->_sequence);
	self->priv->_sequence = _tmp6_;
	_tmp7_ = self->priv->_sequence;
	g_signal_connect_object ((GtkWidget*) _tmp7_, "button-release-event", (GCallback) _node_inspector_sequence_changed_gtk_widget_button_release_event, self, 0);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 5);
	g_object_ref_sink (_tmp8_);
	box = _tmp8_;
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) info, FALSE, TRUE, (guint) 0);
	_tmp9_ = self->priv->_sequence;
	gtk_box_pack_end (box, (GtkWidget*) _tmp9_, FALSE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) box, FALSE, TRUE, (guint) 5);
	_g_object_unref0 (box);
	_g_object_unref0 (info);
	_g_object_unref0 (lbl);
}

static void
__lambda55_ (NodeInspector* self)
{
	DrawArea* _tmp0_;
	GtkColorButton* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_link_color;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	draw_area_change_current_link_color (_tmp0_, &_tmp3_);
}

static void
___lambda55__gtk_color_button_color_set (GtkColorButton* _sender,
                                         gpointer self)
{
	__lambda55_ ((NodeInspector*) self);
}

static void
node_inspector_create_link (NodeInspector* self)
{
	GtkLabel* lbl = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkColorButton* _tmp4_;
	GtkColorButton* _tmp5_;
	GtkBox* box = NULL;
	GtkBox* _tmp6_;
	GtkColorButton* _tmp7_;
	GtkRevealer* _tmp8_;
	GtkRevealer* _tmp9_;
	GtkRevealer* _tmp10_;
	GtkRevealer* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = utils_make_title (_ ("Color"));
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	lbl = _tmp3_;
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_use_markup (lbl, TRUE);
	_tmp4_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_link_color);
	self->priv->_link_color = _tmp4_;
	_tmp5_ = self->priv->_link_color;
	g_signal_connect_object (_tmp5_, "color-set", (GCallback) ___lambda55__gtk_color_button_color_set, self, 0);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	box = _tmp6_;
	gtk_box_set_homogeneous (box, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) box, 5);
	gtk_widget_set_margin_bottom ((GtkWidget*) box, 5);
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, TRUE, (guint) 0);
	_tmp7_ = self->priv->_link_color;
	gtk_box_pack_end (box, (GtkWidget*) _tmp7_, TRUE, TRUE, (guint) 0);
	_tmp8_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->_link_reveal);
	self->priv->_link_reveal = _tmp8_;
	_tmp9_ = self->priv->_link_reveal;
	gtk_revealer_set_transition_type (_tmp9_, GTK_REVEALER_TRANSITION_TYPE_NONE);
	_tmp10_ = self->priv->_link_reveal;
	gtk_container_add ((GtkContainer*) _tmp10_, (GtkWidget*) box);
	_tmp11_ = self->priv->_link_reveal;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp11_, FALSE, TRUE, (guint) 0);
	_g_object_unref0 (box);
	_g_object_unref0 (lbl);
}

static gboolean
_node_inspector_root_color_changed_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                    GdkEventButton* event,
                                                                    gpointer self)
{
	gboolean result;
	result = node_inspector_root_color_changed ((NodeInspector*) self, event);
	return result;
}

static void
__lambda56_ (NodeInspector* self)
{
	DrawArea* _tmp0_;
	GtkColorButton* _tmp1_;
	GdkRGBA _tmp2_ = {0};
	GdkRGBA _tmp3_;
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_root_color;
	gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp1_, &_tmp2_);
	_tmp3_ = _tmp2_;
	draw_area_change_current_link_color (_tmp0_, &_tmp3_);
}

static void
___lambda56__gtk_color_button_color_set (GtkColorButton* _sender,
                                         gpointer self)
{
	__lambda56_ ((NodeInspector*) self);
}

static void
node_inspector_create_color (NodeInspector* self)
{
	GtkLabel* lbl = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkSwitch* _tmp4_;
	GtkSwitch* _tmp5_;
	GtkBox* box = NULL;
	GtkBox* _tmp6_;
	GtkSwitch* _tmp7_;
	GtkLabel* l = NULL;
	GtkLabel* _tmp8_;
	GtkColorButton* _tmp9_;
	GtkColorButton* _tmp10_;
	GtkBox* cbox = NULL;
	GtkBox* _tmp11_;
	GtkColorButton* _tmp12_;
	GtkRevealer* _tmp13_;
	GtkRevealer* _tmp14_;
	GtkBox* hbox = NULL;
	GtkBox* _tmp15_;
	GtkRevealer* _tmp16_;
	GtkRevealer* _tmp17_;
	GtkRevealer* _tmp18_;
	GtkRevealer* _tmp19_;
	GtkRevealer* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp0_ = utils_make_title (_ ("Override Color"));
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	lbl = _tmp3_;
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_use_markup (lbl, TRUE);
	_tmp4_ = (GtkSwitch*) gtk_switch_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_override);
	self->priv->_override = _tmp4_;
	_tmp5_ = self->priv->_override;
	g_signal_connect_object ((GtkWidget*) _tmp5_, "button-release-event", (GCallback) _node_inspector_root_color_changed_gtk_widget_button_release_event, self, 0);
	_tmp6_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp6_);
	box = _tmp6_;
	gtk_widget_set_margin_top ((GtkWidget*) box, 5);
	gtk_widget_set_margin_bottom ((GtkWidget*) box, 5);
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, TRUE, (guint) 0);
	_tmp7_ = self->priv->_override;
	gtk_box_pack_end (box, (GtkWidget*) _tmp7_, FALSE, TRUE, (guint) 0);
	_tmp8_ = (GtkLabel*) gtk_label_new ("");
	g_object_ref_sink (_tmp8_);
	l = _tmp8_;
	_tmp9_ = (GtkColorButton*) gtk_color_button_new ();
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->_root_color);
	self->priv->_root_color = _tmp9_;
	_tmp10_ = self->priv->_root_color;
	g_signal_connect_object (_tmp10_, "color-set", (GCallback) ___lambda56__gtk_color_button_color_set, self, 0);
	_tmp11_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp11_);
	cbox = _tmp11_;
	gtk_box_set_homogeneous (cbox, TRUE);
	gtk_widget_set_margin_bottom ((GtkWidget*) cbox, 5);
	gtk_box_pack_start (cbox, (GtkWidget*) l, FALSE, TRUE, (guint) 0);
	_tmp12_ = self->priv->_root_color;
	gtk_box_pack_end (cbox, (GtkWidget*) _tmp12_, FALSE, TRUE, (guint) 0);
	_tmp13_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->_color_reveal);
	self->priv->_color_reveal = _tmp13_;
	_tmp14_ = self->priv->_color_reveal;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) cbox);
	_tmp15_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	g_object_ref_sink (_tmp15_);
	hbox = _tmp15_;
	gtk_widget_set_margin_bottom ((GtkWidget*) hbox, 5);
	gtk_box_pack_start (hbox, (GtkWidget*) box, FALSE, TRUE, (guint) 0);
	_tmp16_ = self->priv->_color_reveal;
	gtk_box_pack_start (hbox, (GtkWidget*) _tmp16_, FALSE, TRUE, (guint) 0);
	_tmp17_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->_root_color_reveal);
	self->priv->_root_color_reveal = _tmp17_;
	_tmp18_ = self->priv->_root_color_reveal;
	gtk_revealer_set_transition_type (_tmp18_, GTK_REVEALER_TRANSITION_TYPE_NONE);
	_tmp19_ = self->priv->_root_color_reveal;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) hbox);
	_tmp20_ = self->priv->_root_color_reveal;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp20_, FALSE, TRUE, (guint) 0);
	_g_object_unref0 (hbox);
	_g_object_unref0 (cbox);
	_g_object_unref0 (l);
	_g_object_unref0 (box);
	_g_object_unref0 (lbl);
}

static void
_node_inspector_note_changed_gtk_text_buffer_changed (GtkTextBuffer* _sender,
                                                      gpointer self)
{
	node_inspector_note_changed ((NodeInspector*) self);
}

static gboolean
_node_inspector_note_focus_in_gtk_widget_focus_in_event (GtkWidget* _sender,
                                                         GdkEventFocus* event,
                                                         gpointer self)
{
	gboolean result;
	result = node_inspector_note_focus_in ((NodeInspector*) self, event);
	return result;
}

static gboolean
_node_inspector_note_focus_out_gtk_widget_focus_out_event (GtkWidget* _sender,
                                                           GdkEventFocus* event,
                                                           gpointer self)
{
	gboolean result;
	result = node_inspector_note_focus_out ((NodeInspector*) self, event);
	return result;
}

static gint
_node_inspector_note_node_link_added_note_view_node_link_added (NoteView* _sender,
                                                                NodeLink* link,
                                                                gchar** text,
                                                                gpointer self)
{
	gint result;
	result = node_inspector_note_node_link_added ((NodeInspector*) self, link, text);
	return result;
}

static void
_node_inspector_note_node_link_clicked_note_view_node_link_clicked (NoteView* _sender,
                                                                    gint id,
                                                                    gpointer self)
{
	node_inspector_note_node_link_clicked ((NodeInspector*) self, id);
}

static void
_node_inspector_note_node_link_hover_note_view_node_link_hover (NoteView* _sender,
                                                                gint id,
                                                                gpointer self)
{
	node_inspector_note_node_link_hover ((NodeInspector*) self, id);
}

static void
node_inspector_create_note (NodeInspector* self,
                            MainWindow* win)
{
	GtkLabel* lbl = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	NoteView* _tmp4_;
	NoteView* _tmp5_;
	NoteView* _tmp6_;
	UnicodeInsert* _tmp7_;
	UnicodeInsert* _tmp8_;
	NoteView* _tmp9_;
	GtkTextBuffer* _tmp10_;
	GtkTextBuffer* _tmp11_;
	NoteView* _tmp12_;
	GtkTextBuffer* _tmp13_;
	GtkTextBuffer* _tmp14_;
	NoteView* _tmp15_;
	NoteView* _tmp16_;
	NoteView* _tmp17_;
	NoteView* _tmp18_;
	NoteView* _tmp19_;
	GtkScrolledWindow* _tmp20_;
	GtkScrolledWindow* _tmp21_;
	GtkScrolledWindow* _tmp22_;
	GtkScrolledWindow* _tmp23_;
	NoteView* _tmp24_;
	GtkBox* box = NULL;
	GtkBox* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (win != NULL);
	_tmp0_ = utils_make_title (_ ("Note"));
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	lbl = _tmp3_;
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_use_markup (lbl, TRUE);
	_tmp4_ = note_view_new ();
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->_note);
	self->priv->_note = _tmp4_;
	_tmp5_ = self->priv->_note;
	gtk_text_view_set_wrap_mode ((GtkTextView*) _tmp5_, GTK_WRAP_WORD);
	_tmp6_ = self->priv->_note;
	_tmp7_ = main_window_get_unicoder (win);
	_tmp8_ = _tmp7_;
	note_view_add_unicode_completion (_tmp6_, win, _tmp8_);
	_tmp9_ = self->priv->_note;
	_tmp10_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp9_);
	_tmp11_ = _tmp10_;
	g_object_set (_tmp11_, "text", "", NULL);
	_tmp12_ = self->priv->_note;
	_tmp13_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp12_);
	_tmp14_ = _tmp13_;
	g_signal_connect_object (_tmp14_, "changed", (GCallback) _node_inspector_note_changed_gtk_text_buffer_changed, self, 0);
	_tmp15_ = self->priv->_note;
	g_signal_connect_object ((GtkWidget*) _tmp15_, "focus-in-event", (GCallback) _node_inspector_note_focus_in_gtk_widget_focus_in_event, self, 0);
	_tmp16_ = self->priv->_note;
	g_signal_connect_object ((GtkWidget*) _tmp16_, "focus-out-event", (GCallback) _node_inspector_note_focus_out_gtk_widget_focus_out_event, self, 0);
	_tmp17_ = self->priv->_note;
	g_signal_connect_object (_tmp17_, "node-link-added", (GCallback) _node_inspector_note_node_link_added_note_view_node_link_added, self, 0);
	_tmp18_ = self->priv->_note;
	g_signal_connect_object (_tmp18_, "node-link-clicked", (GCallback) _node_inspector_note_node_link_clicked_note_view_node_link_clicked, self, 0);
	_tmp19_ = self->priv->_note;
	g_signal_connect_object (_tmp19_, "node-link-hover", (GCallback) _node_inspector_note_node_link_hover_note_view_node_link_hover, self, 0);
	_tmp20_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp20_);
	_g_object_unref0 (self->priv->_sw);
	self->priv->_sw = _tmp20_;
	_tmp21_ = self->priv->_sw;
	gtk_scrolled_window_set_min_content_width (_tmp21_, 300);
	_tmp22_ = self->priv->_sw;
	gtk_scrolled_window_set_min_content_height (_tmp22_, 100);
	_tmp23_ = self->priv->_sw;
	_tmp24_ = self->priv->_note;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	g_object_ref_sink (_tmp25_);
	box = _tmp25_;
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, FALSE, (guint) 0);
	_tmp26_ = self->priv->_sw;
	gtk_box_pack_start (box, (GtkWidget*) _tmp26_, TRUE, TRUE, (guint) 0);
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) box, TRUE, TRUE, (guint) 5);
	_g_object_unref0 (box);
	_g_object_unref0 (lbl);
}

static void
node_inspector_create_image (NodeInspector* self)
{
	GtkStack* _tmp0_;
	GtkStack* _tmp1_;
	GtkStack* _tmp2_;
	GtkStack* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkStack* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	GtkStack* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkStack*) gtk_stack_new ();
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->_image_stack);
	self->priv->_image_stack = _tmp0_;
	_tmp1_ = self->priv->_image_stack;
	gtk_stack_set_transition_type (_tmp1_, GTK_STACK_TRANSITION_TYPE_NONE);
	_tmp2_ = self->priv->_image_stack;
	gtk_stack_set_homogeneous (_tmp2_, FALSE);
	_tmp3_ = self->priv->_image_stack;
	_tmp4_ = node_inspector_create_image_add (self);
	_tmp5_ = _tmp4_;
	gtk_stack_add_named (_tmp3_, (GtkWidget*) _tmp5_, "add");
	_g_object_unref0 (_tmp5_);
	_tmp6_ = self->priv->_image_stack;
	_tmp7_ = node_inspector_create_image_edit (self);
	_tmp8_ = _tmp7_;
	gtk_stack_add_named (_tmp6_, (GtkWidget*) _tmp8_, "edit");
	_g_object_unref0 (_tmp8_);
	_tmp9_ = self->priv->_image_stack;
	gtk_box_pack_start ((GtkBox*) self, (GtkWidget*) _tmp9_, FALSE, TRUE, (guint) 5);
}

static void
_node_inspector_image_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                         gpointer self)
{
	node_inspector_image_button_clicked ((NodeInspector*) self);
}

static GtkBox*
node_inspector_create_image_add (NodeInspector* self)
{
	GtkLabel* lbl = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkButton* btn = NULL;
	GtkButton* _tmp4_;
	GtkBox* box = NULL;
	GtkBox* _tmp5_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = utils_make_title (_ ("Image"));
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	lbl = _tmp3_;
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_use_markup (lbl, TRUE);
	_tmp4_ = (GtkButton*) gtk_button_new_with_label (_ ("Add Image…"));
	g_object_ref_sink (_tmp4_);
	btn = _tmp4_;
	g_signal_connect_object (btn, "clicked", (GCallback) _node_inspector_image_button_clicked_gtk_button_clicked, self, 0);
	_tmp5_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	g_object_ref_sink (_tmp5_);
	box = _tmp5_;
	gtk_box_pack_start (box, (GtkWidget*) lbl, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (box, (GtkWidget*) btn, FALSE, TRUE, (guint) 0);
	result = box;
	_g_object_unref0 (btn);
	_g_object_unref0 (lbl);
	return result;
}

static void
__lambda57_ (NodeInspector* self)
{
	DrawArea* _tmp0_;
	_tmp0_ = self->priv->_da;
	draw_area_edit_current_image (_tmp0_);
}

static void
___lambda57__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda57_ ((NodeInspector*) self);
}

static void
__lambda66_ (NodeInspector* self)
{
	DrawArea* _tmp0_;
	_tmp0_ = self->priv->_da;
	draw_area_delete_current_image (_tmp0_);
}

static void
___lambda66__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
	__lambda66_ ((NodeInspector*) self);
}

static void
__lambda67_ (NodeInspector* self)
{
	Node* current = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	current = _tmp1_;
	_tmp2_ = current;
	if (_tmp2_ != NULL) {
		Node* _tmp3_;
		GtkToggleButton* _tmp4_;
		DrawArea* _tmp5_;
		_tmp3_ = current;
		_tmp4_ = self->priv->_resize;
		node_set_image_resizable (_tmp3_, gtk_toggle_button_get_active (_tmp4_));
		_tmp5_ = self->priv->_da;
		draw_area_auto_save (_tmp5_);
	}
	_g_object_unref0 (current);
}

static void
___lambda67__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                        gpointer self)
{
	__lambda67_ ((NodeInspector*) self);
}

static void
__lambda68_ (NodeInspector* self,
             GdkDragContext* ctx,
             gint x,
             gint y,
             GtkSelectionData* data,
             guint info,
             guint t)
{
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gboolean _tmp3_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (data != NULL);
	_tmp1_ = _tmp0_ = gtk_selection_data_get_uris (data);
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	_tmp3_ = _vala_array_length (_tmp0_) == 1;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
	if (_tmp3_) {
		DrawArea* _tmp4_;
		gchar** _tmp5_;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		gboolean _tmp9_;
		_tmp4_ = self->priv->_da;
		_tmp6_ = _tmp5_ = gtk_selection_data_get_uris (data);
		_tmp7_ = _tmp6_;
		_tmp7__length1 = _vala_array_length (_tmp5_);
		_tmp8_ = _tmp7_[0];
		_tmp9_ = draw_area_update_current_image (_tmp4_, _tmp8_);
		_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
		if (_tmp9_) {
			gtk_drag_finish (ctx, TRUE, FALSE, (guint32) t);
		}
	}
}

static void
___lambda68__gtk_widget_drag_data_received (GtkWidget* _sender,
                                            GdkDragContext* context,
                                            gint x,
                                            gint y,
                                            GtkSelectionData* selection_data,
                                            guint info,
                                            guint time_,
                                            gpointer self)
{
	__lambda68_ ((NodeInspector*) self, context, x, y, selection_data, info, time_);
}

static GtkBox*
node_inspector_create_image_edit (NodeInspector* self)
{
	GtkLabel* lbl = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkButton* btn_edit = NULL;
	GtkButton* _tmp4_;
	GtkButton* btn_del = NULL;
	GtkButton* _tmp5_;
	GtkToggleButton* _tmp6_;
	GtkToggleButton* _tmp7_;
	GtkImage* _tmp8_;
	GtkImage* _tmp9_;
	GtkToggleButton* _tmp10_;
	GtkToggleButton* _tmp11_;
	GtkBox* image_btn_box = NULL;
	GtkBox* _tmp12_;
	GtkToggleButton* _tmp13_;
	GtkBox* tbox = NULL;
	GtkBox* _tmp14_;
	GtkImage* _tmp15_;
	GtkImage* _tmp16_;
	GtkBox* box = NULL;
	GtkBox* _tmp17_;
	GtkImage* _tmp18_;
	GtkImage* _tmp19_;
	GtkImage* _tmp20_;
	GtkBox* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = utils_make_title (_ ("Image"));
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	lbl = _tmp3_;
	gtk_label_set_xalign (lbl, (gfloat) 0);
	gtk_label_set_use_markup (lbl, TRUE);
	_tmp4_ = (GtkButton*) gtk_button_new_from_icon_name ("document-edit-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp4_);
	btn_edit = _tmp4_;
	gtk_widget_set_tooltip_text ((GtkWidget*) btn_edit, _ ("Edit Image"));
	g_signal_connect_object (btn_edit, "clicked", (GCallback) ___lambda57__gtk_button_clicked, self, 0);
	_tmp5_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_BUTTON);
	g_object_ref_sink (_tmp5_);
	btn_del = _tmp5_;
	gtk_widget_set_tooltip_text ((GtkWidget*) btn_del, _ ("Remove Image"));
	g_signal_connect_object (btn_del, "clicked", (GCallback) ___lambda66__gtk_button_clicked, self, 0);
	_tmp6_ = (GtkToggleButton*) gtk_toggle_button_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->_resize);
	self->priv->_resize = _tmp6_;
	_tmp7_ = self->priv->_resize;
	_tmp8_ = (GtkImage*) gtk_image_new_from_icon_name ("view-fullscreen-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	gtk_button_set_image ((GtkButton*) _tmp7_, (GtkWidget*) _tmp9_);
	_g_object_unref0 (_tmp9_);
	_tmp10_ = self->priv->_resize;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp10_, _ ("Resizable"));
	_tmp11_ = self->priv->_resize;
	g_signal_connect_object (_tmp11_, "toggled", (GCallback) ___lambda67__gtk_toggle_button_toggled, self, 0);
	_tmp12_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp12_);
	image_btn_box = _tmp12_;
	_tmp13_ = self->priv->_resize;
	gtk_box_pack_start (image_btn_box, (GtkWidget*) _tmp13_, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (image_btn_box, (GtkWidget*) btn_edit, FALSE, FALSE, (guint) 0);
	gtk_box_pack_start (image_btn_box, (GtkWidget*) btn_del, FALSE, FALSE, (guint) 0);
	_tmp14_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 10);
	g_object_ref_sink (_tmp14_);
	tbox = _tmp14_;
	gtk_box_pack_start (tbox, (GtkWidget*) lbl, FALSE, FALSE, (guint) 0);
	gtk_box_pack_end (tbox, (GtkWidget*) image_btn_box, FALSE, FALSE, (guint) 0);
	_tmp15_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->_image);
	self->priv->_image = _tmp15_;
	_tmp16_ = self->priv->_image;
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp16_, 20);
	_tmp17_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 10);
	g_object_ref_sink (_tmp17_);
	box = _tmp17_;
	gtk_box_pack_start (box, (GtkWidget*) tbox, FALSE, FALSE, (guint) 0);
	_tmp18_ = self->priv->_image;
	gtk_box_pack_start (box, (GtkWidget*) _tmp18_, TRUE, TRUE, (guint) 0);
	_tmp19_ = self->priv->_image;
	gtk_drag_dest_set ((GtkWidget*) _tmp19_, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_DROP, NODE_INSPECTOR_DRAG_TARGETS, (gint) G_N_ELEMENTS (NODE_INSPECTOR_DRAG_TARGETS), GDK_ACTION_COPY);
	_tmp20_ = self->priv->_image;
	g_signal_connect_object ((GtkWidget*) _tmp20_, "drag-data-received", (GCallback) ___lambda68__gtk_widget_drag_data_received, self, 0);
	result = box;
	_g_object_unref0 (tbox);
	_g_object_unref0 (image_btn_box);
	_g_object_unref0 (btn_del);
	_g_object_unref0 (btn_edit);
	_g_object_unref0 (lbl);
	return result;
}

static void
node_inspector_image_button_clicked (NodeInspector* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_add_current_image (_tmp0_);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gboolean
node_inspector_image_link_clicked (NodeInspector* self,
                                   const gchar* uri)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = g_file_new_for_uri (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = g_file_get_uri_scheme (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "file") == 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		GAppInfo* files = NULL;
		GAppInfo* _tmp5_;
		GList* list = NULL;
		GFile* _tmp6_;
		GFile* _tmp7_;
		_tmp5_ = g_app_info_get_default_for_type ("inode/directory", TRUE);
		files = _tmp5_;
		list = NULL;
		_tmp6_ = file;
		_tmp7_ = _g_object_ref0 (_tmp6_);
		list = g_list_append (list, _tmp7_);
		{
			GAppInfo* _tmp8_;
			GList* _tmp9_;
			_tmp8_ = files;
			_tmp9_ = list;
			g_app_info_launch (_tmp8_, _tmp9_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			g_clear_error (&_inner_error0_);
			result = FALSE;
			(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
			_g_object_unref0 (files);
			_g_object_unref0 (file);
			return result;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
			_g_object_unref0 (files);
			_g_object_unref0 (file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
		result = TRUE;
		(list == NULL) ? NULL : (list = (_g_list_free__g_object_unref0_ (list), NULL));
		_g_object_unref0 (files);
		_g_object_unref0 (file);
		return result;
	}
	result = FALSE;
	_g_object_unref0 (file);
	return result;
}

static void
_node_inspector_node_copy_gtk_button_clicked (GtkButton* _sender,
                                              gpointer self)
{
	node_inspector_node_copy ((NodeInspector*) self);
}

static void
_node_inspector_node_cut_gtk_button_clicked (GtkButton* _sender,
                                             gpointer self)
{
	node_inspector_node_cut ((NodeInspector*) self);
}

static void
_node_inspector_node_detach_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	node_inspector_node_detach ((NodeInspector*) self);
}

static void
_node_inspector_node_delete_gtk_button_clicked (GtkButton* _sender,
                                                gpointer self)
{
	node_inspector_node_delete ((NodeInspector*) self);
}

static void
node_inspector_create_buttons (NodeInspector* self)
{
	GtkGrid* grid = NULL;
	GtkGrid* _tmp0_;
	GtkButton* copy_btn = NULL;
	GtkButton* _tmp1_;
	GtkButton* cut_btn = NULL;
	GtkButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkButton* _tmp4_;
	GtkButton* _tmp5_;
	GtkButton* del_btn = NULL;
	GtkButton* _tmp6_;
	GtkButton* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp0_);
	grid = _tmp0_;
	gtk_grid_set_column_homogeneous (grid, TRUE);
	gtk_grid_set_column_spacing (grid, 5);
	_tmp1_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-copy-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp1_);
	copy_btn = _tmp1_;
	gtk_widget_set_tooltip_text ((GtkWidget*) copy_btn, _ ("Copy Node To Clipboard"));
	g_signal_connect_object (copy_btn, "clicked", (GCallback) _node_inspector_node_copy_gtk_button_clicked, self, 0);
	_tmp2_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-cut-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp2_);
	cut_btn = _tmp2_;
	gtk_widget_set_tooltip_text ((GtkWidget*) cut_btn, _ ("Cut Node To Clipboard"));
	g_signal_connect_object (cut_btn, "clicked", (GCallback) _node_inspector_node_cut_gtk_button_clicked, self, 0);
	_tmp3_ = (GtkButton*) gtk_button_new_from_icon_name ("minder-detach-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->_detach_btn);
	self->priv->_detach_btn = _tmp3_;
	_tmp4_ = self->priv->_detach_btn;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _ ("Detach Node"));
	_tmp5_ = self->priv->_detach_btn;
	g_signal_connect_object (_tmp5_, "clicked", (GCallback) _node_inspector_node_detach_gtk_button_clicked, self, 0);
	_tmp6_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-delete-symbolic", (GtkIconSize) GTK_ICON_SIZE_SMALL_TOOLBAR);
	g_object_ref_sink (_tmp6_);
	del_btn = _tmp6_;
	gtk_widget_set_tooltip_text ((GtkWidget*) del_btn, _ ("Delete Node"));
	g_signal_connect_object (del_btn, "clicked", (GCallback) _node_inspector_node_delete_gtk_button_clicked, self, 0);
	gtk_grid_attach (grid, (GtkWidget*) copy_btn, 0, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) cut_btn, 1, 0, 1, 1);
	_tmp7_ = self->priv->_detach_btn;
	gtk_grid_attach (grid, (GtkWidget*) _tmp7_, 2, 0, 1, 1);
	gtk_grid_attach (grid, (GtkWidget*) del_btn, 3, 0, 1, 1);
	_g_object_unref0 (del_btn);
	_g_object_unref0 (cut_btn);
	_g_object_unref0 (copy_btn);
	_g_object_unref0 (grid);
}

static gboolean
node_inspector_task_changed (NodeInspector* self,
                             GdkEventButton* e)
{
	Node* current = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	current = _tmp1_;
	_tmp2_ = current;
	if (_tmp2_ != NULL) {
		DrawArea* _tmp3_;
		Node* _tmp4_;
		_tmp3_ = self->priv->_da;
		_tmp4_ = current;
		draw_area_change_current_task (_tmp3_, !node_task_enabled (_tmp4_), FALSE);
	}
	result = FALSE;
	_g_object_unref0 (current);
	return result;
}

static gboolean
node_inspector_fold_changed (NodeInspector* self,
                             GdkEventButton* e)
{
	Node* current = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	current = _tmp1_;
	_tmp2_ = current;
	if (_tmp2_ != NULL) {
		DrawArea* _tmp3_;
		Node* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		_tmp3_ = self->priv->_da;
		_tmp4_ = current;
		_tmp5_ = node_get_folded (_tmp4_);
		_tmp6_ = _tmp5_;
		draw_area_change_current_fold (_tmp3_, !_tmp6_, FALSE);
	}
	result = FALSE;
	_g_object_unref0 (current);
	return result;
}

static gboolean
node_inspector_sequence_changed (NodeInspector* self,
                                 GdkEventButton* e)
{
	Node* current = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	current = _tmp1_;
	_tmp2_ = current;
	if (_tmp2_ != NULL) {
		Node* _tmp3_;
		Node* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		DrawArea* _tmp7_;
		DrawArea* _tmp8_;
		_tmp3_ = current;
		_tmp4_ = current;
		_tmp5_ = node_get_sequence (_tmp4_);
		_tmp6_ = _tmp5_;
		node_set_sequence (_tmp3_, !_tmp6_);
		_tmp7_ = self->priv->_da;
		draw_area_auto_save (_tmp7_);
		_tmp8_ = self->priv->_da;
		gtk_widget_queue_draw ((GtkWidget*) _tmp8_);
	}
	result = FALSE;
	_g_object_unref0 (current);
	return result;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static gboolean
node_inspector_root_color_changed (NodeInspector* self,
                                   GdkEventButton* e)
{
	Node* current = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	GtkRevealer* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	current = _tmp1_;
	_tmp2_ = self->priv->_color_reveal;
	_tmp3_ = gtk_revealer_get_reveal_child (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkRevealer* _tmp5_;
		Node* _tmp6_;
		_tmp5_ = self->priv->_color_reveal;
		gtk_revealer_set_reveal_child (_tmp5_, FALSE);
		_tmp6_ = current;
		if (_tmp6_ != NULL) {
			DrawArea* _tmp7_;
			_tmp7_ = self->priv->_da;
			draw_area_change_current_link_color (_tmp7_, NULL);
		}
	} else {
		GtkRevealer* _tmp8_;
		gboolean _tmp9_ = FALSE;
		Node* _tmp10_;
		_tmp8_ = self->priv->_color_reveal;
		gtk_revealer_set_reveal_child (_tmp8_, TRUE);
		_tmp10_ = current;
		if (_tmp10_ != NULL) {
			GtkColorButton* _tmp11_;
			GdkRGBA _tmp12_ = {0};
			GdkRGBA _tmp13_;
			DrawArea* _tmp14_;
			Theme* _tmp15_;
			Theme* _tmp16_;
			GdkRGBA* _tmp17_;
			GdkRGBA* _tmp18_;
			_tmp11_ = self->priv->_root_color;
			gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp11_, &_tmp12_);
			_tmp13_ = _tmp12_;
			_tmp14_ = self->priv->_da;
			_tmp15_ = draw_area_get_theme (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp17_ = theme_get_color (_tmp16_, "root_background");
			_tmp18_ = _tmp17_;
			_tmp9_ = _gdk_rgba_equal (&_tmp13_, _tmp18_) != TRUE;
			__vala_GdkRGBA_free0 (_tmp18_);
			_g_object_unref0 (_tmp16_);
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			DrawArea* _tmp19_;
			GtkColorButton* _tmp20_;
			GdkRGBA _tmp21_ = {0};
			_tmp19_ = self->priv->_da;
			_tmp20_ = self->priv->_root_color;
			gtk_color_chooser_get_rgba ((GtkColorChooser*) _tmp20_, &_tmp21_);
			draw_area_change_current_link_color (_tmp19_, &_tmp21_);
		}
	}
	result = FALSE;
	_g_object_unref0 (current);
	return result;
}

static void
node_inspector_note_changed (NodeInspector* self)
{
	DrawArea* _tmp0_;
	NoteView* _tmp1_;
	GtkTextBuffer* _tmp2_;
	GtkTextBuffer* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->priv->_ignore_changes) {
		return;
	}
	_tmp0_ = self->priv->_da;
	_tmp1_ = self->priv->_note;
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp1_);
	_tmp3_ = _tmp2_;
	g_object_get (_tmp3_, "text", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	draw_area_change_current_node_note (_tmp0_, _tmp6_);
	_g_free0 (_tmp6_);
}

static gboolean
node_inspector_note_focus_in (NodeInspector* self,
                              GdkEventFocus* e)
{
	DrawArea* _tmp0_;
	Node* _tmp1_;
	NoteView* _tmp2_;
	GtkTextBuffer* _tmp3_;
	GtkTextBuffer* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	_g_object_unref0 (self->priv->_node);
	self->priv->_node = _tmp1_;
	_tmp2_ = self->priv->_note;
	_tmp3_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp2_);
	_tmp4_ = _tmp3_;
	g_object_get (_tmp4_, "text", &_tmp5_, NULL);
	_tmp6_ = _tmp5_;
	_g_free0 (self->priv->_orig_note);
	self->priv->_orig_note = _tmp6_;
	result = FALSE;
	return result;
}

static gboolean
node_inspector_note_focus_out (NodeInspector* self,
                               GdkEventFocus* e)
{
	gboolean _tmp0_ = FALSE;
	Node* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp1_ = self->priv->_node;
	if (_tmp1_ != NULL) {
		Node* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp2_ = self->priv->_node;
		_tmp3_ = node_get_note (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = self->priv->_orig_note;
		_tmp0_ = g_strcmp0 (_tmp4_, _tmp5_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		DrawArea* _tmp6_;
		UndoBuffer* _tmp7_;
		UndoBuffer* _tmp8_;
		Node* _tmp9_;
		const gchar* _tmp10_;
		UndoNodeNote* _tmp11_;
		UndoNodeNote* _tmp12_;
		_tmp6_ = self->priv->_da;
		_tmp7_ = draw_area_get_undo_buffer (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->priv->_node;
		_tmp10_ = self->priv->_orig_note;
		_tmp11_ = undo_node_note_new (_tmp9_, _tmp10_);
		_tmp12_ = _tmp11_;
		undo_buffer_add_item (_tmp8_, (UndoItem*) _tmp12_);
		_g_object_unref0 (_tmp12_);
	}
	result = FALSE;
	return result;
}

static gint
node_inspector_note_node_link_added (NodeInspector* self,
                                     NodeLink* link,
                                     gchar** text)
{
	gchar* _vala_text = NULL;
	DrawArea* _tmp0_;
	gchar* _tmp1_ = NULL;
	gint _tmp2_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (link != NULL, 0);
	_tmp0_ = self->priv->_da;
	_tmp2_ = draw_area_add_note_node_link (_tmp0_, link, &_tmp1_);
	_g_free0 (_vala_text);
	_vala_text = _tmp1_;
	result = _tmp2_;
	if (text) {
		*text = _vala_text;
	} else {
		_g_free0 (_vala_text);
	}
	return result;
}

static void
node_inspector_note_node_link_clicked (NodeInspector* self,
                                       gint id)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_note_node_link_clicked (_tmp0_, id);
}

static void
node_inspector_note_node_link_hover (NodeInspector* self,
                                     gint id)
{
	NodeLink* link = NULL;
	DrawArea* _tmp0_;
	NodeLinks* _tmp1_;
	NodeLinks* _tmp2_;
	NodeLink* _tmp3_;
	NodeLink* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_node_links (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = node_links_get_node_link (_tmp2_, id);
	link = _tmp3_;
	_tmp4_ = link;
	if (_tmp4_ != NULL) {
		NoteView* _tmp5_;
		NodeLink* _tmp6_;
		DrawArea* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		_tmp5_ = self->priv->_note;
		_tmp6_ = link;
		_tmp7_ = self->priv->_da;
		_tmp8_ = node_link_get_tooltip (_tmp6_, _tmp7_);
		_tmp9_ = _tmp8_;
		note_view_show_tooltip (_tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
	}
	_node_link_unref0 (link);
}

static void
node_inspector_node_copy (NodeInspector* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	minder_clipboard_copy_nodes (_tmp0_);
}

static void
node_inspector_node_cut (NodeInspector* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_cut_node_to_clipboard (_tmp0_);
}

static void
node_inspector_node_detach (NodeInspector* self)
{
	DrawArea* _tmp0_;
	GtkButton* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_detach (_tmp0_);
	_tmp1_ = self->priv->_detach_btn;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
}

static void
node_inspector_node_delete (NodeInspector* self)
{
	DrawArea* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	draw_area_delete_node (_tmp0_);
}

void
node_inspector_grab_note (NodeInspector* self)
{
	NoteView* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_note;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	node_inspector_node_changed (self);
}

static gboolean
node_inspector_resize_changed (NodeInspector* self,
                               GdkEventButton* e)
{
	Node* current = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	current = _tmp1_;
	_tmp2_ = current;
	if (_tmp2_ != NULL) {
		Node* _tmp3_;
		Node* _tmp4_;
		gboolean _tmp5_;
		gboolean _tmp6_;
		DrawArea* _tmp7_;
		_tmp3_ = current;
		_tmp4_ = current;
		_tmp5_ = node_get_image_resizable (_tmp4_);
		_tmp6_ = _tmp5_;
		node_set_image_resizable (_tmp3_, !_tmp6_);
		_tmp7_ = self->priv->_da;
		draw_area_auto_save (_tmp7_);
	}
	result = FALSE;
	_g_object_unref0 (current);
	return result;
}

static void
node_inspector_theme_changed (NodeInspector* self,
                              DrawArea* da)
{
	gint num_colors = 0;
	GdkRGBA* colors = NULL;
	GdkRGBA* _tmp0_;
	gint colors_length1;
	gint _colors_size_;
	GtkColorButton* _tmp8_;
	GtkColorButton* _tmp9_;
	GdkRGBA* _tmp10_;
	gint _tmp10__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	num_colors = theme_num_link_colors ();
	_tmp0_ = g_new0 (GdkRGBA, num_colors);
	colors = _tmp0_;
	colors_length1 = num_colors;
	_colors_size_ = colors_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GdkRGBA* _tmp3_;
				gint _tmp3__length1;
				DrawArea* _tmp4_;
				Theme* _tmp5_;
				Theme* _tmp6_;
				GdkRGBA _tmp7_ = {0};
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < num_colors)) {
					break;
				}
				_tmp3_ = colors;
				_tmp3__length1 = colors_length1;
				_tmp4_ = self->priv->_da;
				_tmp5_ = draw_area_get_theme (_tmp4_);
				_tmp6_ = _tmp5_;
				theme_link_color (_tmp6_, i, &_tmp7_);
				_tmp3_[i] = _tmp7_;
				_g_object_unref0 (_tmp6_);
			}
		}
	}
	_tmp8_ = self->priv->_link_color;
	gtk_color_chooser_add_palette ((GtkColorChooser*) _tmp8_, GTK_ORIENTATION_HORIZONTAL, 10, (gint) 0, NULL);
	_tmp9_ = self->priv->_link_color;
	_tmp10_ = colors;
	_tmp10__length1 = colors_length1;
	gtk_color_chooser_add_palette ((GtkColorChooser*) _tmp9_, GTK_ORIENTATION_HORIZONTAL, 10, (gint) _tmp10__length1, _tmp10_);
	colors = (g_free (colors), NULL);
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static void
node_inspector_node_changed (NodeInspector* self)
{
	Node* current = NULL;
	DrawArea* _tmp0_;
	Node* _tmp1_;
	Node* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_da;
	_tmp1_ = draw_area_get_current_node (_tmp0_);
	current = _tmp1_;
	self->priv->_ignore_changes = TRUE;
	_tmp2_ = current;
	if (_tmp2_ != NULL) {
		GtkSwitch* _tmp3_;
		Node* _tmp4_;
		Node* _tmp5_;
		Node* _tmp13_;
		Node* _tmp21_;
		GtkButton* _tmp55_;
		Node* _tmp56_;
		Node* _tmp57_;
		Node* _tmp58_;
		gchar* note = NULL;
		Node* _tmp59_;
		const gchar* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		NoteView* _tmp63_;
		GtkTextBuffer* _tmp64_;
		GtkTextBuffer* _tmp65_;
		const gchar* _tmp66_;
		Node* _tmp67_;
		NodeImage* _tmp68_;
		NodeImage* _tmp69_;
		_tmp3_ = self->priv->_task;
		_tmp4_ = current;
		gtk_switch_set_active (_tmp3_, node_task_enabled (_tmp4_));
		_tmp5_ = current;
		if (node_is_leaf (_tmp5_)) {
			GtkSwitch* _tmp6_;
			GtkSwitch* _tmp7_;
			_tmp6_ = self->priv->_fold;
			gtk_switch_set_active (_tmp6_, FALSE);
			_tmp7_ = self->priv->_fold;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, FALSE);
		} else {
			GtkSwitch* _tmp8_;
			Node* _tmp9_;
			gboolean _tmp10_;
			gboolean _tmp11_;
			GtkSwitch* _tmp12_;
			_tmp8_ = self->priv->_fold;
			_tmp9_ = current;
			_tmp10_ = node_get_folded (_tmp9_);
			_tmp11_ = _tmp10_;
			gtk_switch_set_active (_tmp8_, _tmp11_);
			_tmp12_ = self->priv->_fold;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp12_, TRUE);
		}
		_tmp13_ = current;
		if (node_is_root (_tmp13_)) {
			GtkSwitch* _tmp14_;
			GtkSwitch* _tmp15_;
			_tmp14_ = self->priv->_sequence;
			gtk_switch_set_active (_tmp14_, FALSE);
			_tmp15_ = self->priv->_sequence;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp15_, FALSE);
		} else {
			GtkSwitch* _tmp16_;
			Node* _tmp17_;
			gboolean _tmp18_;
			gboolean _tmp19_;
			GtkSwitch* _tmp20_;
			_tmp16_ = self->priv->_sequence;
			_tmp17_ = current;
			_tmp18_ = node_get_sequence (_tmp17_);
			_tmp19_ = _tmp18_;
			gtk_switch_set_active (_tmp16_, _tmp19_);
			_tmp20_ = self->priv->_sequence;
			gtk_widget_set_sensitive ((GtkWidget*) _tmp20_, TRUE);
		}
		_tmp21_ = current;
		if (node_is_root (_tmp21_)) {
			GtkRevealer* _tmp22_;
			GtkRevealer* _tmp23_;
			GtkSwitch* _tmp24_;
			Node* _tmp25_;
			gboolean _tmp26_;
			gboolean _tmp27_;
			GtkRevealer* _tmp28_;
			Node* _tmp29_;
			gboolean _tmp30_;
			gboolean _tmp31_;
			GdkRGBA* _tmp32_ = NULL;
			Node* _tmp33_;
			gboolean _tmp34_;
			gboolean _tmp35_;
			GtkColorButton* _tmp44_;
			GdkRGBA _tmp45_;
			GtkColorButton* _tmp46_;
			_tmp22_ = self->priv->_link_reveal;
			gtk_revealer_set_reveal_child (_tmp22_, FALSE);
			_tmp23_ = self->priv->_root_color_reveal;
			gtk_revealer_set_reveal_child (_tmp23_, TRUE);
			_tmp24_ = self->priv->_override;
			_tmp25_ = current;
			_tmp26_ = node_get_link_color_set (_tmp25_);
			_tmp27_ = _tmp26_;
			gtk_switch_set_active (_tmp24_, _tmp27_);
			_tmp28_ = self->priv->_color_reveal;
			_tmp29_ = current;
			_tmp30_ = node_get_link_color_set (_tmp29_);
			_tmp31_ = _tmp30_;
			gtk_revealer_set_reveal_child (_tmp28_, _tmp31_);
			_tmp33_ = current;
			_tmp34_ = node_get_link_color_set (_tmp33_);
			_tmp35_ = _tmp34_;
			if (_tmp35_) {
				Node* _tmp36_;
				GdkRGBA* _tmp37_;
				GdkRGBA* _tmp38_;
				GdkRGBA* _tmp39_;
				_tmp36_ = current;
				_tmp37_ = node_get_link_color (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = __vala_GdkRGBA_copy0 (_tmp38_);
				__vala_GdkRGBA_free0 (_tmp32_);
				_tmp32_ = _tmp39_;
			} else {
				DrawArea* _tmp40_;
				Theme* _tmp41_;
				Theme* _tmp42_;
				GdkRGBA* _tmp43_;
				_tmp40_ = self->priv->_da;
				_tmp41_ = draw_area_get_theme (_tmp40_);
				_tmp42_ = _tmp41_;
				_tmp43_ = theme_get_color (_tmp42_, "root_background");
				__vala_GdkRGBA_free0 (_tmp32_);
				_tmp32_ = _tmp43_;
				_g_object_unref0 (_tmp42_);
			}
			_tmp44_ = self->priv->_root_color;
			_tmp45_ = *_tmp32_;
			gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp44_, &_tmp45_);
			_tmp46_ = self->priv->_root_color;
			gtk_color_button_set_alpha (_tmp46_, (guint) 65535);
			__vala_GdkRGBA_free0 (_tmp32_);
		} else {
			GtkRevealer* _tmp47_;
			GtkRevealer* _tmp48_;
			GtkColorButton* _tmp49_;
			Node* _tmp50_;
			GdkRGBA* _tmp51_;
			GdkRGBA* _tmp52_;
			GdkRGBA _tmp53_;
			GtkColorButton* _tmp54_;
			_tmp47_ = self->priv->_link_reveal;
			gtk_revealer_set_reveal_child (_tmp47_, TRUE);
			_tmp48_ = self->priv->_root_color_reveal;
			gtk_revealer_set_reveal_child (_tmp48_, FALSE);
			_tmp49_ = self->priv->_link_color;
			_tmp50_ = current;
			_tmp51_ = node_get_link_color (_tmp50_);
			_tmp52_ = _tmp51_;
			_tmp53_ = *_tmp52_;
			gtk_color_chooser_set_rgba ((GtkColorChooser*) _tmp49_, &_tmp53_);
			_tmp54_ = self->priv->_link_color;
			gtk_color_button_set_alpha (_tmp54_, (guint) 65535);
		}
		_tmp55_ = self->priv->_detach_btn;
		_tmp56_ = current;
		_tmp57_ = node_get_parent (_tmp56_);
		_tmp58_ = _tmp57_;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp55_, _tmp58_ != NULL);
		_tmp59_ = current;
		_tmp60_ = node_get_note (_tmp59_);
		_tmp61_ = _tmp60_;
		_tmp62_ = g_strdup (_tmp61_);
		note = _tmp62_;
		_tmp63_ = self->priv->_note;
		_tmp64_ = gtk_text_view_get_buffer ((GtkTextView*) _tmp63_);
		_tmp65_ = _tmp64_;
		_tmp66_ = note;
		g_object_set (_tmp65_, "text", _tmp66_, NULL);
		_tmp67_ = current;
		_tmp68_ = node_get_image (_tmp67_);
		_tmp69_ = _tmp68_;
		if (_tmp69_ != NULL) {
			gchar* url = NULL;
			DrawArea* _tmp70_;
			ImageManager* _tmp71_;
			ImageManager* _tmp72_;
			Node* _tmp73_;
			NodeImage* _tmp74_;
			NodeImage* _tmp75_;
			gint _tmp76_;
			gint _tmp77_;
			gchar* _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* str = NULL;
			const gchar* _tmp82_;
			gchar* _tmp83_;
			gchar* _tmp84_;
			gchar* _tmp85_;
			gchar* _tmp86_;
			const gchar* _tmp87_;
			gchar* _tmp88_;
			gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			Node* _tmp92_;
			NodeImage* _tmp93_;
			NodeImage* _tmp94_;
			GtkImage* _tmp95_;
			GtkToggleButton* _tmp96_;
			Node* _tmp97_;
			gboolean _tmp98_;
			gboolean _tmp99_;
			GtkStack* _tmp100_;
			_tmp70_ = self->priv->_da;
			_tmp71_ = draw_area_get_image_manager (_tmp70_);
			_tmp72_ = _tmp71_;
			_tmp73_ = current;
			_tmp74_ = node_get_image (_tmp73_);
			_tmp75_ = _tmp74_;
			_tmp76_ = node_image_get_id (_tmp75_);
			_tmp77_ = _tmp76_;
			_tmp78_ = image_manager_get_uri (_tmp72_, _tmp77_);
			_tmp79_ = _tmp78_;
			_tmp80_ = string_replace (_tmp79_, "&", "&amp;");
			_tmp81_ = _tmp80_;
			_g_free0 (_tmp79_);
			url = _tmp81_;
			_tmp82_ = url;
			_tmp83_ = g_strconcat ("<a href=\"", _tmp82_, NULL);
			_tmp84_ = _tmp83_;
			_tmp85_ = g_strconcat (_tmp84_, "\">", NULL);
			_tmp86_ = _tmp85_;
			_tmp87_ = url;
			_tmp88_ = g_strconcat (_tmp86_, _tmp87_, NULL);
			_tmp89_ = _tmp88_;
			_tmp90_ = g_strconcat (_tmp89_, "</a>", NULL);
			_tmp91_ = _tmp90_;
			_g_free0 (_tmp89_);
			_g_free0 (_tmp86_);
			_g_free0 (_tmp84_);
			str = _tmp91_;
			_tmp92_ = current;
			_tmp93_ = node_get_image (_tmp92_);
			_tmp94_ = _tmp93_;
			_tmp95_ = self->priv->_image;
			node_image_set_image (_tmp94_, _tmp95_);
			_tmp96_ = self->priv->_resize;
			_tmp97_ = current;
			_tmp98_ = node_get_image_resizable (_tmp97_);
			_tmp99_ = _tmp98_;
			gtk_toggle_button_set_active (_tmp96_, _tmp99_);
			_tmp100_ = self->priv->_image_stack;
			gtk_stack_set_visible_child_name (_tmp100_, "edit");
			_g_free0 (str);
			_g_free0 (url);
		} else {
			GtkStack* _tmp101_;
			_tmp101_ = self->priv->_image_stack;
			gtk_stack_set_visible_child_name (_tmp101_, "add");
		}
		_g_free0 (note);
	}
	self->priv->_ignore_changes = FALSE;
	_g_object_unref0 (current);
}

void
node_inspector_grab_first (NodeInspector* self)
{
	GtkSwitch* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_task;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
	node_inspector_node_changed (self);
}

static void
node_inspector_class_init (NodeInspectorClass * klass,
                           gpointer klass_data)
{
	node_inspector_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NodeInspector_private_offset);
	G_OBJECT_CLASS (klass)->finalize = node_inspector_finalize;
}

static void
node_inspector_instance_init (NodeInspector * self,
                              gpointer klass)
{
	gchar* _tmp0_;
	self->priv = node_inspector_get_instance_private (self);
	self->priv->_da = NULL;
	_tmp0_ = g_strdup ("");
	self->priv->_orig_note = _tmp0_;
	self->priv->_node = NULL;
	self->priv->_ignore_changes = FALSE;
}

static void
node_inspector_finalize (GObject * obj)
{
	NodeInspector * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NODE_INSPECTOR, NodeInspector);
	_g_object_unref0 (self->priv->_sw);
	_g_object_unref0 (self->priv->_task);
	_g_object_unref0 (self->priv->_fold);
	_g_object_unref0 (self->priv->_sequence);
	_g_object_unref0 (self->priv->_link_reveal);
	_g_object_unref0 (self->priv->_link_color);
	_g_object_unref0 (self->priv->_note);
	_g_object_unref0 (self->priv->_da);
	_g_object_unref0 (self->priv->_detach_btn);
	_g_free0 (self->priv->_orig_note);
	_g_object_unref0 (self->priv->_node);
	_g_object_unref0 (self->priv->_image_stack);
	_g_object_unref0 (self->priv->_image);
	_g_object_unref0 (self->priv->_image_btn);
	_g_object_unref0 (self->priv->_image_loc);
	_g_object_unref0 (self->priv->_override);
	_g_object_unref0 (self->priv->_root_color);
	_g_object_unref0 (self->priv->_root_color_reveal);
	_g_object_unref0 (self->priv->_color_reveal);
	_g_object_unref0 (self->priv->_resize);
	G_OBJECT_CLASS (node_inspector_parent_class)->finalize (obj);
}

static GType
node_inspector_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NodeInspectorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) node_inspector_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NodeInspector), 0, (GInstanceInitFunc) node_inspector_instance_init, NULL };
	GType node_inspector_type_id;
	node_inspector_type_id = g_type_register_static (gtk_box_get_type (), "NodeInspector", &g_define_type_info, 0);
	NodeInspector_private_offset = g_type_add_instance_private (node_inspector_type_id, sizeof (NodeInspectorPrivate));
	return node_inspector_type_id;
}

GType
node_inspector_get_type (void)
{
	static volatile gsize node_inspector_type_id__once = 0;
	if (g_once_init_enter (&node_inspector_type_id__once)) {
		GType node_inspector_type_id;
		node_inspector_type_id = node_inspector_get_type_once ();
		g_once_init_leave (&node_inspector_type_id__once, node_inspector_type_id);
	}
	return node_inspector_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

