/* NodeGroups.c generated by valac 0.56.18, the Vala compiler
 * generated from NodeGroups.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <libxml/tree.h>
#include <cairo-gobject.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_UNDO_NODE_GROUPS (undo_node_groups_get_type ())
typedef struct _UndoNodeGroups UndoNodeGroups;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;

#define TYPE_NODE_GROUP (node_group_get_type ())
#define NODE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_GROUP, NodeGroup))
#define NODE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_GROUP, NodeGroupClass))
#define IS_NODE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_GROUP))
#define IS_NODE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_GROUP))
#define NODE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_GROUP, NodeGroupClass))

typedef struct _NodeGroup NodeGroup;
typedef struct _NodeGroupClass NodeGroupClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_NODE_GROUPS (node_groups_get_type ())
#define NODE_GROUPS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_GROUPS, NodeGroups))
#define NODE_GROUPS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_GROUPS, NodeGroupsClass))
#define IS_NODE_GROUPS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_GROUPS))
#define IS_NODE_GROUPS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_GROUPS))
#define NODE_GROUPS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_GROUPS, NodeGroupsClass))

typedef struct _NodeGroups NodeGroups;
typedef struct _NodeGroupsClass NodeGroupsClass;
typedef struct _NodeGroupsPrivate NodeGroupsPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;
#define _undo_node_groups_free0(var) ((var == NULL) ? NULL : (var = (undo_node_groups_free (var), NULL)))

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
typedef struct _ParamSpecNodeGroups ParamSpecNodeGroups;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _UndoNodeGroups {
	Node* node;
	GArray* groups;
};

struct _NodeGroups {
	GTypeInstance parent_instance;
	volatile int ref_count;
	NodeGroupsPrivate * priv;
};

struct _NodeGroupsClass {
	GTypeClass parent_class;
	void (*finalize) (NodeGroups *self);
};

struct _NodeGroupsPrivate {
	DrawArea* _da;
	GArray* _groups;
};

struct _ParamSpecNodeGroups {
	GParamSpec parent_instance;
};

static gint NodeGroups_private_offset;
static gpointer node_groups_parent_class = NULL;

VALA_EXTERN GType undo_node_groups_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType node_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeGroup, g_object_unref)
VALA_EXTERN UndoNodeGroups* undo_node_groups_dup (const UndoNodeGroups* self);
VALA_EXTERN void undo_node_groups_free (UndoNodeGroups* self);
VALA_EXTERN void undo_node_groups_copy (const UndoNodeGroups* self,
                            UndoNodeGroups* dest);
VALA_EXTERN void undo_node_groups_destroy (UndoNodeGroups* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (UndoNodeGroups, undo_node_groups_destroy)
VALA_EXTERN void undo_node_groups_init (UndoNodeGroups *self,
                            Node* n,
                            GArray* g);
VALA_EXTERN gpointer node_groups_ref (gpointer instance);
VALA_EXTERN void node_groups_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_node_groups (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void value_set_node_groups (GValue* value,
                            gpointer v_object);
VALA_EXTERN void value_take_node_groups (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer value_get_node_groups (const GValue* value);
VALA_EXTERN GType node_groups_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeGroups, node_groups_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN NodeGroups* node_groups_new (DrawArea* da);
VALA_EXTERN NodeGroups* node_groups_construct (GType object_type,
                                   DrawArea* da);
static void _g_object_unref0_ (gpointer var);
static void _vala_NodeGroup_free_function_content_of (gpointer data);
VALA_EXTERN void node_groups_clear (NodeGroups* self);
VALA_EXTERN void node_groups_add_group (NodeGroups* self,
                            NodeGroup* group);
VALA_EXTERN void node_groups_remove_group (NodeGroups* self,
                               NodeGroup* group);
VALA_EXTERN void node_groups_remove_node (NodeGroups* self,
                              Node* node,
                              UndoNodeGroups** affected);
VALA_EXTERN gboolean node_group_remove_node (NodeGroup* self,
                                 Node* node);
VALA_EXTERN GArray* node_group_get_nodes (NodeGroup* self);
VALA_EXTERN void node_groups_remove_nodes (NodeGroups* self,
                               GArray* nodes,
                               GArray** affected);
static void _undo_node_groups_free0_ (gpointer var);
static void _vala_UndoNodeGroups_free_function_content_of (gpointer data);
VALA_EXTERN NodeGroup* node_groups_merge_groups (NodeGroups* self,
                                     GArray* groups);
VALA_EXTERN NodeGroup* node_group_new_copy (NodeGroup* group);
VALA_EXTERN NodeGroup* node_group_construct_copy (GType object_type,
                                      NodeGroup* group);
VALA_EXTERN void node_group_merge (NodeGroup* self,
                       NodeGroup* other);
static gboolean node_groups_group_exists (NodeGroups* self,
                                   NodeGroup* group);
VALA_EXTERN void node_groups_apply_undo (NodeGroups* self,
                             UndoNodeGroups* g);
VALA_EXTERN void node_group_add_node (NodeGroup* self,
                          Node* node);
VALA_EXTERN void node_groups_apply_undos (NodeGroups* self,
                              GArray* g);
VALA_EXTERN NodeGroup* node_groups_node_group_containing (NodeGroups* self,
                                              gdouble x,
                                              gdouble y);
VALA_EXTERN gboolean node_group_is_within (NodeGroup* self,
                               gdouble x,
                               gdouble y);
VALA_EXTERN void node_groups_get_match_items (NodeGroups* self,
                                  const gchar* tabname,
                                  const gchar* pattern,
                                  gboolean* search_opts,
                                  gint search_opts_length1,
                                  GtkListStore** matches);
VALA_EXTERN void node_group_get_match_items (NodeGroup* self,
                                 const gchar* tabname,
                                 const gchar* pattern,
                                 gboolean* search_opts,
                                 gint search_opts_length1,
                                 GtkListStore** matches);
VALA_EXTERN xmlNode* node_groups_save (NodeGroups* self);
VALA_EXTERN xmlNode* node_group_save (NodeGroup* self);
VALA_EXTERN void node_groups_load (NodeGroups* self,
                       DrawArea* da,
                       xmlNode* g);
VALA_EXTERN NodeGroup* node_group_new_from_xml (DrawArea* da,
                                    xmlNode* n);
VALA_EXTERN NodeGroup* node_group_construct_from_xml (GType object_type,
                                          DrawArea* da,
                                          xmlNode* n);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN void node_groups_draw_all (NodeGroups* self,
                           cairo_t* ctx,
                           Theme* theme,
                           gboolean exporting);
VALA_EXTERN void node_group_draw (NodeGroup* self,
                      cairo_t* ctx,
                      Theme* theme,
                      gboolean exporting);
static void node_groups_finalize (NodeGroups * obj);
static GType node_groups_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gpointer
_g_array_ref0 (gpointer self)
{
	return self ? g_array_ref (self) : NULL;
}

void
undo_node_groups_init (UndoNodeGroups *self,
                       Node* n,
                       GArray* g)
{
	Node* _tmp0_;
	GArray* _tmp1_;
	g_return_if_fail (n != NULL);
	g_return_if_fail (g != NULL);
	memset (self, 0, sizeof (UndoNodeGroups));
	_tmp0_ = _g_object_ref0 (n);
	_g_object_unref0 ((*self).node);
	(*self).node = _tmp0_;
	_tmp1_ = _g_array_ref0 (g);
	_g_array_unref0 ((*self).groups);
	(*self).groups = _tmp1_;
}

void
undo_node_groups_copy (const UndoNodeGroups* self,
                       UndoNodeGroups* dest)
{
	Node* _tmp0_;
	Node* _tmp1_;
	GArray* _tmp2_;
	GArray* _tmp3_;
	_tmp0_ = (*self).node;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 ((*dest).node);
	(*dest).node = _tmp1_;
	_tmp2_ = (*self).groups;
	_tmp3_ = _g_array_ref0 (_tmp2_);
	_g_array_unref0 ((*dest).groups);
	(*dest).groups = _tmp3_;
}

void
undo_node_groups_destroy (UndoNodeGroups* self)
{
	_g_object_unref0 ((*self).node);
	_g_array_unref0 ((*self).groups);
}

UndoNodeGroups*
undo_node_groups_dup (const UndoNodeGroups* self)
{
	UndoNodeGroups* dup;
	dup = g_new0 (UndoNodeGroups, 1);
	undo_node_groups_copy (self, dup);
	return dup;
}

void
undo_node_groups_free (UndoNodeGroups* self)
{
	undo_node_groups_destroy (self);
	g_free (self);
}

static GType
undo_node_groups_get_type_once (void)
{
	GType undo_node_groups_type_id;
	undo_node_groups_type_id = g_boxed_type_register_static ("UndoNodeGroups", (GBoxedCopyFunc) undo_node_groups_dup, (GBoxedFreeFunc) undo_node_groups_free);
	return undo_node_groups_type_id;
}

GType
undo_node_groups_get_type (void)
{
	static volatile gsize undo_node_groups_type_id__once = 0;
	if (g_once_init_enter (&undo_node_groups_type_id__once)) {
		GType undo_node_groups_type_id;
		undo_node_groups_type_id = undo_node_groups_get_type_once ();
		g_once_init_leave (&undo_node_groups_type_id__once, undo_node_groups_type_id);
	}
	return undo_node_groups_type_id__once;
}

static inline gpointer
node_groups_get_instance_private (NodeGroups* self)
{
	return G_STRUCT_MEMBER_P (self, NodeGroups_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_NodeGroup_free_function_content_of (gpointer data)
{
	NodeGroup* self;
	self = *((NodeGroup**) data);
	_g_object_unref0_ (self);
}

NodeGroups*
node_groups_construct (GType object_type,
                       DrawArea* da)
{
	NodeGroups* self = NULL;
	DrawArea* _tmp0_;
	GArray* _tmp1_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (NodeGroups*) g_type_create_instance (object_type);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (NodeGroup*));
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_NodeGroup_free_function_content_of);
	_g_array_unref0 (self->priv->_groups);
	self->priv->_groups = _tmp1_;
	return self;
}

NodeGroups*
node_groups_new (DrawArea* da)
{
	return node_groups_construct (TYPE_NODE_GROUPS, da);
}

static gpointer*
vala_g_array_remove_range (GArray* self,
                           guint index,
                           guint length,
                           gint* result_length1)
{
	gpointer* ga = NULL;
	gpointer* _tmp0_;
	gint ga_length1;
	gint _ga_size_;
	gpointer* _tmp6_;
	gint _tmp6__length1;
	gpointer* result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len >= (index + length), "this.length >= index + length");
	_tmp0_ = g_new0 (gpointer, length);
	ga = _tmp0_;
	ga_length1 = length;
	_ga_size_ = ga_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gpointer* _tmp3_;
				gint _tmp3__length1;
				gpointer* _tmp4_;
				gint _tmp4__length1;
				gpointer _tmp5_;
				if (!_tmp1_) {
					guint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < length)) {
					break;
				}
				_tmp3_ = ga;
				_tmp3__length1 = ga_length1;
				_tmp4_ = self->data;
				_tmp4__length1 = self->len;
				_tmp5_ = _tmp4_[i + index];
				_tmp4_[i + index] = NULL;
				_tmp3_[i] = _tmp5_;
			}
		}
	}
	g_array_remove_range (self, index, length);
	_tmp6_ = ga;
	_tmp6__length1 = ga_length1;
	if (result_length1) {
		*result_length1 = _tmp6__length1;
	}
	result = _tmp6_;
	return result;
}

void
node_groups_clear (NodeGroups* self)
{
	GArray* _tmp0_;
	GArray* _tmp1_;
	gint _tmp2_ = 0;
	gpointer* _tmp3_;
	NodeGroup** _tmp4_;
	gint _tmp4__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_groups;
	_tmp1_ = self->priv->_groups;
	_tmp3_ = vala_g_array_remove_range (_tmp0_, (guint) 0, _tmp1_->len, &_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp4__length1 = _tmp2_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
}

void
node_groups_add_group (NodeGroups* self,
                       NodeGroup* group)
{
	GArray* _tmp0_;
	NodeGroup* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	_tmp0_ = self->priv->_groups;
	_tmp1_ = _g_object_ref0 (group);
	g_array_append_val (_tmp0_, _tmp1_);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

void
node_groups_remove_group (NodeGroups* self,
                          NodeGroup* group)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (group != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				NodeGroup* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_groups;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_groups;
				_tmp4_ = g_array_index (_tmp3_, NodeGroup*, (guint) i);
				if (_tmp4_ == group) {
					GArray* _tmp5_;
					NodeGroup* _tmp6_;
					NodeGroup* _tmp7_;
					_tmp5_ = self->priv->_groups;
					_tmp6_ = vala_g_array_remove_index (_tmp5_, (guint) i);
					_tmp7_ = _tmp6_;
					_g_object_unref0 (_tmp7_);
					return;
				}
			}
		}
	}
}

static gpointer
_undo_node_groups_dup0 (gpointer self)
{
	return self ? undo_node_groups_dup (self) : NULL;
}

void
node_groups_remove_node (NodeGroups* self,
                         Node* node,
                         UndoNodeGroups** affected)
{
	GArray* groups = NULL;
	GArray* _tmp0_;
	GArray* _tmp17_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (NodeGroup*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_NodeGroup_free_function_content_of);
	groups = _tmp0_;
	{
		gint i = 0;
		GArray* _tmp1_;
		_tmp1_ = self->priv->_groups;
		i = (gint) (_tmp1_->len - 1);
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				NodeGroup* _tmp5_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ - 1;
				}
				_tmp2_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp4_ = self->priv->_groups;
				_tmp5_ = g_array_index (_tmp4_, NodeGroup*, (guint) i);
				if (node_group_remove_node (_tmp5_, node)) {
					GArray* _tmp6_;
					GArray* _tmp7_;
					NodeGroup* _tmp8_;
					NodeGroup* _tmp9_;
					GArray* _tmp10_;
					NodeGroup* _tmp11_;
					GArray* _tmp12_;
					GArray* _tmp13_;
					_tmp6_ = groups;
					_tmp7_ = self->priv->_groups;
					_tmp8_ = g_array_index (_tmp7_, NodeGroup*, (guint) i);
					_tmp9_ = _g_object_ref0 (_tmp8_);
					g_array_append_val (_tmp6_, _tmp9_);
					_tmp10_ = self->priv->_groups;
					_tmp11_ = g_array_index (_tmp10_, NodeGroup*, (guint) i);
					_tmp12_ = node_group_get_nodes (_tmp11_);
					_tmp13_ = _tmp12_;
					if (_tmp13_->len == ((guint) 0)) {
						GArray* _tmp14_;
						NodeGroup* _tmp15_;
						NodeGroup* _tmp16_;
						_tmp14_ = self->priv->_groups;
						_tmp15_ = vala_g_array_remove_index (_tmp14_, (guint) i);
						_tmp16_ = _tmp15_;
						_g_object_unref0 (_tmp16_);
					}
				}
			}
		}
	}
	_tmp17_ = groups;
	if (_tmp17_->len > ((guint) 0)) {
		GArray* _tmp18_;
		UndoNodeGroups _tmp19_ = {0};
		UndoNodeGroups _tmp20_;
		UndoNodeGroups* _tmp21_;
		_tmp18_ = groups;
		undo_node_groups_init (&_tmp19_, node, _tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = _undo_node_groups_dup0 (&_tmp20_);
		_undo_node_groups_free0 (*affected);
		*affected = _tmp21_;
		undo_node_groups_destroy (&_tmp20_);
	}
	_g_array_unref0 (groups);
}

static void
_undo_node_groups_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (undo_node_groups_free (var), NULL));
}

static void
_vala_UndoNodeGroups_free_function_content_of (gpointer data)
{
	UndoNodeGroups* self;
	self = *((UndoNodeGroups**) data);
	_undo_node_groups_free0_ (self);
}

void
node_groups_remove_nodes (NodeGroups* self,
                          GArray* nodes,
                          GArray** affected)
{
	GArray* _vala_affected = NULL;
	GArray* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (nodes != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (UndoNodeGroups*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_UndoNodeGroups_free_function_content_of);
	_g_array_unref0 (_vala_affected);
	_vala_affected = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				UndoNodeGroups* a = NULL;
				Node* _tmp3_;
				UndoNodeGroups* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((guint) i) < nodes->len)) {
					break;
				}
				a = NULL;
				_tmp3_ = g_array_index (nodes, Node*, (guint) i);
				node_groups_remove_node (self, _tmp3_, &a);
				_tmp4_ = a;
				if (_tmp4_ != NULL) {
					GArray* _tmp5_;
					UndoNodeGroups* _tmp6_;
					UndoNodeGroups* _tmp7_;
					_tmp5_ = _vala_affected;
					_tmp6_ = a;
					_tmp7_ = _undo_node_groups_dup0 (_tmp6_);
					g_array_append_val (_tmp5_, _tmp7_);
				}
				_undo_node_groups_free0 (a);
			}
		}
	}
	if (affected) {
		*affected = _vala_affected;
	} else {
		_g_array_unref0 (_vala_affected);
	}
}

NodeGroup*
node_groups_merge_groups (NodeGroups* self,
                          GArray* groups)
{
	NodeGroup* group = NULL;
	NodeGroup* _tmp0_;
	NodeGroup* _tmp1_;
	NodeGroup* _tmp2_;
	NodeGroup* _tmp8_;
	NodeGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (groups != NULL, NULL);
	if (groups->len == ((guint) 0)) {
		result = NULL;
		return result;
	}
	_tmp0_ = g_array_index (groups, NodeGroup*, (guint) 0);
	_tmp1_ = node_group_new_copy (_tmp0_);
	group = _tmp1_;
	_tmp2_ = g_array_index (groups, NodeGroup*, (guint) 0);
	node_groups_remove_group (self, _tmp2_);
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				NodeGroup* _tmp5_;
				NodeGroup* _tmp6_;
				NodeGroup* _tmp7_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(((guint) i) < groups->len)) {
					break;
				}
				_tmp5_ = group;
				_tmp6_ = g_array_index (groups, NodeGroup*, (guint) i);
				node_group_merge (_tmp5_, _tmp6_);
				_tmp7_ = g_array_index (groups, NodeGroup*, (guint) i);
				node_groups_remove_group (self, _tmp7_);
			}
		}
	}
	_tmp8_ = group;
	node_groups_add_group (self, _tmp8_);
	result = group;
	return result;
}

static gboolean
node_groups_group_exists (NodeGroups* self,
                          NodeGroup* group)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (group != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				NodeGroup* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_groups;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_groups;
				_tmp4_ = g_array_index (_tmp3_, NodeGroup*, (guint) i);
				if (_tmp4_ == group) {
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

void
node_groups_apply_undo (NodeGroups* self,
                        UndoNodeGroups* g)
{
	g_return_if_fail (self != NULL);
	if (g != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp0_ = FALSE;
				_tmp0_ = TRUE;
				while (TRUE) {
					GArray* _tmp2_;
					GArray* _tmp3_;
					NodeGroup* _tmp4_;
					Node* _tmp5_;
					GArray* _tmp6_;
					NodeGroup* _tmp7_;
					if (!_tmp0_) {
						gint _tmp1_;
						_tmp1_ = i;
						i = _tmp1_ + 1;
					}
					_tmp0_ = FALSE;
					_tmp2_ = (*g).groups;
					if (!(((guint) i) < _tmp2_->len)) {
						break;
					}
					_tmp3_ = (*g).groups;
					_tmp4_ = g_array_index (_tmp3_, NodeGroup*, (guint) i);
					_tmp5_ = (*g).node;
					node_group_add_node (_tmp4_, _tmp5_);
					_tmp6_ = (*g).groups;
					_tmp7_ = g_array_index (_tmp6_, NodeGroup*, (guint) i);
					if (!node_groups_group_exists (self, _tmp7_)) {
						GArray* _tmp8_;
						GArray* _tmp9_;
						NodeGroup* _tmp10_;
						NodeGroup* _tmp11_;
						_tmp8_ = self->priv->_groups;
						_tmp9_ = (*g).groups;
						_tmp10_ = g_array_index (_tmp9_, NodeGroup*, (guint) i);
						_tmp11_ = _g_object_ref0 (_tmp10_);
						g_array_append_val (_tmp8_, _tmp11_);
					}
				}
			}
		}
	}
}

void
node_groups_apply_undos (NodeGroups* self,
                         GArray* g)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (g != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((guint) i) < g->len)) {
					break;
				}
				node_groups_apply_undo (self, g_array_index (g, UndoNodeGroups*, (guint) i));
			}
		}
	}
}

NodeGroup*
node_groups_node_group_containing (NodeGroups* self,
                                   gdouble x,
                                   gdouble y)
{
	NodeGroup* result;
	g_return_val_if_fail (self != NULL, NULL);
	{
		gint i = 0;
		GArray* _tmp0_;
		_tmp0_ = self->priv->_groups;
		i = (gint) (_tmp0_->len - 1);
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				NodeGroup* _tmp4_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				if (!(i >= 0)) {
					break;
				}
				_tmp3_ = self->priv->_groups;
				_tmp4_ = g_array_index (_tmp3_, NodeGroup*, (guint) i);
				if (node_group_is_within (_tmp4_, x, y)) {
					GArray* _tmp5_;
					NodeGroup* _tmp6_;
					NodeGroup* _tmp7_;
					_tmp5_ = self->priv->_groups;
					_tmp6_ = g_array_index (_tmp5_, NodeGroup*, (guint) i);
					_tmp7_ = _g_object_ref0 (_tmp6_);
					result = _tmp7_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

void
node_groups_get_match_items (NodeGroups* self,
                             const gchar* tabname,
                             const gchar* pattern,
                             gboolean* search_opts,
                             gint search_opts_length1,
                             GtkListStore** matches)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (tabname != NULL);
	g_return_if_fail (pattern != NULL);
	g_return_if_fail (*matches != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				NodeGroup* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_groups;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_groups;
				_tmp4_ = g_array_index (_tmp3_, NodeGroup*, (guint) i);
				node_group_get_match_items (_tmp4_, tabname, pattern, search_opts, (gint) search_opts_length1, matches);
			}
		}
	}
}

xmlNode*
node_groups_save (NodeGroups* self)
{
	xmlNode* g = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp8_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "groups");
	g = _tmp0_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GArray* _tmp3_;
				xmlNode* _tmp4_;
				GArray* _tmp5_;
				NodeGroup* _tmp6_;
				xmlNode* _tmp7_;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = self->priv->_groups;
				if (!(((guint) i) < _tmp3_->len)) {
					break;
				}
				_tmp4_ = g;
				_tmp5_ = self->priv->_groups;
				_tmp6_ = g_array_index (_tmp5_, NodeGroup*, (guint) i);
				_tmp7_ = node_group_save (_tmp6_);
				xmlAddChild (_tmp4_, _tmp7_);
			}
		}
	}
	_tmp8_ = g;
	result = _tmp8_;
	return result;
}

void
node_groups_load (NodeGroups* self,
                  DrawArea* da,
                  xmlNode* g)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	{
		xmlNode* it = NULL;
		xmlNode* _tmp0_;
		_tmp0_ = g->children;
		it = _tmp0_;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp4_;
				gboolean _tmp5_ = FALSE;
				xmlNode* _tmp6_;
				if (!_tmp1_) {
					xmlNode* _tmp2_;
					xmlNode* _tmp3_;
					_tmp2_ = it;
					_tmp3_ = _tmp2_->next;
					it = _tmp3_;
				}
				_tmp1_ = FALSE;
				_tmp4_ = it;
				if (!(_tmp4_ != NULL)) {
					break;
				}
				_tmp6_ = it;
				if (_tmp6_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp7_;
					const gchar* _tmp8_;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->name;
					_tmp5_ = g_strcmp0 (_tmp8_, "group") == 0;
				} else {
					_tmp5_ = FALSE;
				}
				if (_tmp5_) {
					GArray* _tmp9_;
					xmlNode* _tmp10_;
					NodeGroup* _tmp11_;
					_tmp9_ = self->priv->_groups;
					_tmp10_ = it;
					_tmp11_ = node_group_new_from_xml (da, _tmp10_);
					g_array_append_val (_tmp9_, _tmp11_);
				}
			}
		}
	}
}

void
node_groups_draw_all (NodeGroups* self,
                      cairo_t* ctx,
                      Theme* theme,
                      gboolean exporting)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				NodeGroup* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_groups;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_groups;
				_tmp4_ = g_array_index (_tmp3_, NodeGroup*, (guint) i);
				node_group_draw (_tmp4_, ctx, theme, exporting);
			}
		}
	}
}

static void
value_node_groups_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_node_groups_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		node_groups_unref (value->data[0].v_pointer);
	}
}

static void
value_node_groups_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = node_groups_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_node_groups_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_node_groups_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		NodeGroups * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = node_groups_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_node_groups_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	NodeGroups ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = node_groups_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_node_groups (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	ParamSpecNodeGroups* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_NODE_GROUPS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_node_groups (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_GROUPS), NULL);
	return value->data[0].v_pointer;
}

void
value_set_node_groups (GValue* value,
                       gpointer v_object)
{
	NodeGroups * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_GROUPS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE_GROUPS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		node_groups_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_groups_unref (old);
	}
}

void
value_take_node_groups (GValue* value,
                        gpointer v_object)
{
	NodeGroups * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_NODE_GROUPS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_NODE_GROUPS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		node_groups_unref (old);
	}
}

static void
node_groups_class_init (NodeGroupsClass * klass,
                        gpointer klass_data)
{
	node_groups_parent_class = g_type_class_peek_parent (klass);
	((NodeGroupsClass *) klass)->finalize = node_groups_finalize;
	g_type_class_adjust_private_offset (klass, &NodeGroups_private_offset);
}

static void
node_groups_instance_init (NodeGroups * self,
                           gpointer klass)
{
	self->priv = node_groups_get_instance_private (self);
	self->ref_count = 1;
}

static void
node_groups_finalize (NodeGroups * obj)
{
	NodeGroups * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NODE_GROUPS, NodeGroups);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->priv->_da);
	_g_array_unref0 (self->priv->_groups);
}

static GType
node_groups_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_node_groups_init, value_node_groups_free_value, value_node_groups_copy_value, value_node_groups_peek_pointer, "p", value_node_groups_collect_value, "p", value_node_groups_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (NodeGroupsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) node_groups_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NodeGroups), 0, (GInstanceInitFunc) node_groups_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType node_groups_type_id;
	node_groups_type_id = g_type_register_fundamental (g_type_fundamental_next (), "NodeGroups", &g_define_type_info, &g_define_type_fundamental_info, 0);
	NodeGroups_private_offset = g_type_add_instance_private (node_groups_type_id, sizeof (NodeGroupsPrivate));
	return node_groups_type_id;
}

GType
node_groups_get_type (void)
{
	static volatile gsize node_groups_type_id__once = 0;
	if (g_once_init_enter (&node_groups_type_id__once)) {
		GType node_groups_type_id;
		node_groups_type_id = node_groups_get_type_once ();
		g_once_init_leave (&node_groups_type_id__once, node_groups_type_id);
	}
	return node_groups_type_id__once;
}

gpointer
node_groups_ref (gpointer instance)
{
	NodeGroups * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
node_groups_unref (gpointer instance)
{
	NodeGroups * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		NODE_GROUPS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

