/* Animator.c generated by valac 0.56.18, the Vala compiler
 * generated from Animator.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>

#define ANIMATOR__timeout 20
#define ANIMATOR__frames ((gdouble) 10)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_ANIMATOR (animator_get_type ())
#define ANIMATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR, Animator))
#define ANIMATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR, AnimatorClass))
#define IS_ANIMATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR))
#define IS_ANIMATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR))
#define ANIMATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR, AnimatorClass))

typedef struct _Animator Animator;
typedef struct _AnimatorClass AnimatorClass;
typedef struct _AnimatorPrivate AnimatorPrivate;

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_ANIMATOR_ACTION (animator_action_get_type ())
#define ANIMATOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_ACTION, AnimatorAction))
#define ANIMATOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_ACTION, AnimatorActionClass))
#define IS_ANIMATOR_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_ACTION))
#define IS_ANIMATOR_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_ACTION))
#define ANIMATOR_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_ACTION, AnimatorActionClass))

typedef struct _AnimatorAction AnimatorAction;
typedef struct _AnimatorActionClass AnimatorActionClass;
enum  {
	ANIMATOR_0_PROPERTY,
	ANIMATOR_ENABLE_PROPERTY,
	ANIMATOR_NUM_PROPERTIES
};
static GParamSpec* animator_properties[ANIMATOR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
typedef enum  {
	ANIMATION_TYPE_UNKNOWN = 0,
	ANIMATION_TYPE_NODES,
	ANIMATION_TYPE_NODE,
	ANIMATION_TYPE_FADE,
	ANIMATION_TYPE_PAN,
	ANIMATION_TYPE_SCALE,
	ANIMATION_TYPE_PANSCALE
} AnimationType;

#define TYPE_ANIMATION_TYPE (animation_type_get_type ())

#define TYPE_ANIMATOR_NODES (animator_nodes_get_type ())
#define ANIMATOR_NODES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_NODES, AnimatorNodes))
#define ANIMATOR_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_NODES, AnimatorNodesClass))
#define IS_ANIMATOR_NODES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_NODES))
#define IS_ANIMATOR_NODES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_NODES))
#define ANIMATOR_NODES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_NODES, AnimatorNodesClass))

typedef struct _AnimatorNodes AnimatorNodes;
typedef struct _AnimatorNodesClass AnimatorNodesClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))

#define TYPE_ANIMATOR_FADE (animator_fade_get_type ())
#define ANIMATOR_FADE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_FADE, AnimatorFade))
#define ANIMATOR_FADE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_FADE, AnimatorFadeClass))
#define IS_ANIMATOR_FADE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_FADE))
#define IS_ANIMATOR_FADE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_FADE))
#define ANIMATOR_FADE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_FADE, AnimatorFadeClass))

typedef struct _AnimatorFade AnimatorFade;
typedef struct _AnimatorFadeClass AnimatorFadeClass;

#define TYPE_ANIMATOR_SCALE (animator_scale_get_type ())
#define ANIMATOR_SCALE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_SCALE, AnimatorScale))
#define ANIMATOR_SCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_SCALE, AnimatorScaleClass))
#define IS_ANIMATOR_SCALE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_SCALE))
#define IS_ANIMATOR_SCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_SCALE))
#define ANIMATOR_SCALE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_SCALE, AnimatorScaleClass))

typedef struct _AnimatorScale AnimatorScale;
typedef struct _AnimatorScaleClass AnimatorScaleClass;

#define TYPE_ANIMATOR_PAN (animator_pan_get_type ())
#define ANIMATOR_PAN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_PAN, AnimatorPan))
#define ANIMATOR_PAN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_PAN, AnimatorPanClass))
#define IS_ANIMATOR_PAN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_PAN))
#define IS_ANIMATOR_PAN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_PAN))
#define ANIMATOR_PAN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_PAN, AnimatorPanClass))

typedef struct _AnimatorPan AnimatorPan;
typedef struct _AnimatorPanClass AnimatorPanClass;

#define TYPE_ANIMATOR_PAN_SCALE (animator_pan_scale_get_type ())
#define ANIMATOR_PAN_SCALE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_PAN_SCALE, AnimatorPanScale))
#define ANIMATOR_PAN_SCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_PAN_SCALE, AnimatorPanScaleClass))
#define IS_ANIMATOR_PAN_SCALE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_PAN_SCALE))
#define IS_ANIMATOR_PAN_SCALE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_PAN_SCALE))
#define ANIMATOR_PAN_SCALE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_PAN_SCALE, AnimatorPanScaleClass))

typedef struct _AnimatorPanScale AnimatorPanScale;
typedef struct _AnimatorPanScaleClass AnimatorPanScaleClass;

#define TYPE_ANIMATOR_SCALE_IN_PLACE (animator_scale_in_place_get_type ())
#define ANIMATOR_SCALE_IN_PLACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ANIMATOR_SCALE_IN_PLACE, AnimatorScaleInPlace))
#define ANIMATOR_SCALE_IN_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ANIMATOR_SCALE_IN_PLACE, AnimatorScaleInPlaceClass))
#define IS_ANIMATOR_SCALE_IN_PLACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ANIMATOR_SCALE_IN_PLACE))
#define IS_ANIMATOR_SCALE_IN_PLACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ANIMATOR_SCALE_IN_PLACE))
#define ANIMATOR_SCALE_IN_PLACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ANIMATOR_SCALE_IN_PLACE, AnimatorScaleInPlaceClass))

typedef struct _AnimatorScaleInPlace AnimatorScaleInPlace;
typedef struct _AnimatorScaleInPlaceClass AnimatorScaleInPlaceClass;

struct _Animator {
	GObject parent_instance;
	AnimatorPrivate * priv;
};

struct _AnimatorClass {
	GObjectClass parent_class;
};

struct _AnimatorPrivate {
	DrawArea* _da;
	GQueue* _actions;
	gboolean _running;
	guint _id;
	gboolean _enable;
};

static gint Animator_private_offset;
static gpointer animator_parent_class = NULL;

VALA_EXTERN GType animator_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Animator, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN GType animator_action_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorAction, g_object_unref)
static void _g_object_unref0_ (gpointer var);
static inline void _g_queue_free__g_object_unref0_ (GQueue* self);
VALA_EXTERN Animator* animator_new (DrawArea* da);
VALA_EXTERN Animator* animator_construct (GType object_type,
                              DrawArea* da);
VALA_EXTERN gboolean animator_is_running (Animator* self);
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN void animator_add_nodes (Animator* self,
                         GArray* n,
                         const gchar* name);
VALA_EXTERN GType animation_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN AnimationType animator_action_type (AnimatorAction* self);
VALA_EXTERN AnimatorNodes* animator_nodes_new (DrawArea* da,
                                   GArray* n,
                                   const gchar* name);
VALA_EXTERN AnimatorNodes* animator_nodes_construct (GType object_type,
                                         DrawArea* da,
                                         GArray* n,
                                         const gchar* name);
VALA_EXTERN GType animator_nodes_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorNodes, g_object_unref)
VALA_EXTERN void animator_add_node (Animator* self,
                        Node* n,
                        const gchar* name);
static void _vala_Node_free_function_content_of (gpointer data);
VALA_EXTERN void animator_add_callouts_fade (Animator* self,
                                 GArray* n,
                                 gboolean fade_out,
                                 const gchar* name);
VALA_EXTERN AnimatorFade* animator_fade_new (DrawArea* da,
                                 GArray* n,
                                 gboolean fade_out,
                                 const gchar* name);
VALA_EXTERN AnimatorFade* animator_fade_construct (GType object_type,
                                       DrawArea* da,
                                       GArray* n,
                                       gboolean fade_out,
                                       const gchar* name);
VALA_EXTERN GType animator_fade_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorFade, g_object_unref)
VALA_EXTERN void animator_add_scale (Animator* self,
                         const gchar* name);
VALA_EXTERN AnimatorScale* animator_scale_new (DrawArea* da,
                                   const gchar* name);
VALA_EXTERN AnimatorScale* animator_scale_construct (GType object_type,
                                         DrawArea* da,
                                         const gchar* name);
VALA_EXTERN GType animator_scale_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorScale, g_object_unref)
VALA_EXTERN void animator_add_pan (Animator* self,
                       const gchar* name);
VALA_EXTERN AnimatorPan* animator_pan_new (DrawArea* da,
                               const gchar* name);
VALA_EXTERN AnimatorPan* animator_pan_construct (GType object_type,
                                     DrawArea* da,
                                     const gchar* name);
VALA_EXTERN GType animator_pan_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorPan, g_object_unref)
VALA_EXTERN void animator_add_pan_scale (Animator* self,
                             const gchar* name);
VALA_EXTERN AnimatorPanScale* animator_pan_scale_new (DrawArea* da,
                                          const gchar* name);
VALA_EXTERN AnimatorPanScale* animator_pan_scale_construct (GType object_type,
                                                DrawArea* da,
                                                const gchar* name);
VALA_EXTERN GType animator_pan_scale_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorPanScale, g_object_unref)
VALA_EXTERN void animator_add_scale_in_place (Animator* self,
                                  const gchar* name,
                                  gdouble ssx,
                                  gdouble ssy);
VALA_EXTERN AnimatorScaleInPlace* animator_scale_in_place_new (DrawArea* da,
                                                   const gchar* name,
                                                   gdouble ssx,
                                                   gdouble ssy);
VALA_EXTERN AnimatorScaleInPlace* animator_scale_in_place_construct (GType object_type,
                                                         DrawArea* da,
                                                         const gchar* name,
                                                         gdouble ssx,
                                                         gdouble ssy);
VALA_EXTERN GType animator_scale_in_place_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimatorScaleInPlace, g_object_unref)
VALA_EXTERN void animator_cancel_last_add (Animator* self);
VALA_EXTERN void animator_flush (Animator* self);
VALA_EXTERN void animator_action_flush (AnimatorAction* self,
                            DrawArea* da);
VALA_EXTERN gboolean animator_action_save (AnimatorAction* self);
VALA_EXTERN void draw_area_auto_save (DrawArea* self);
VALA_EXTERN void animator_animate (Animator* self);
VALA_EXTERN gboolean animator_get_enable (Animator* self);
VALA_EXTERN void animator_action_on_completion (AnimatorAction* self,
                                    DrawArea* da);
static gboolean animator_animate_action (Animator* self);
static gboolean _animator_animate_action_gsource_func (gpointer self);
VALA_EXTERN void animator_action_capture (AnimatorAction* self,
                              DrawArea* da);
VALA_EXTERN void animator_action_adjust (AnimatorAction* self,
                             DrawArea* da);
VALA_EXTERN gboolean animator_action_done (AnimatorAction* self);
VALA_EXTERN void animator_set_enable (Animator* self,
                          gboolean value);
static void animator_finalize (GObject * obj);
static GType animator_get_type_once (void);
static void _vala_animator_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec);
static void _vala_animator_set_property (GObject * object,
                                  guint property_id,
                                  const GValue * value,
                                  GParamSpec * pspec);

static inline gpointer
animator_get_instance_private (Animator* self)
{
	return G_STRUCT_MEMBER_P (self, Animator_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_queue_free__g_object_unref0_ (GQueue* self)
{
	g_queue_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

Animator*
animator_construct (GType object_type,
                    DrawArea* da)
{
	Animator * self = NULL;
	DrawArea* _tmp0_;
	GQueue* _tmp1_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (Animator*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (da);
	_g_object_unref0 (self->priv->_da);
	self->priv->_da = _tmp0_;
	_tmp1_ = g_queue_new ();
	(self->priv->_actions == NULL) ? NULL : (self->priv->_actions = (_g_queue_free__g_object_unref0_ (self->priv->_actions), NULL));
	self->priv->_actions = _tmp1_;
	self->priv->_running = FALSE;
	return self;
}

Animator*
animator_new (DrawArea* da)
{
	return animator_construct (TYPE_ANIMATOR, da);
}

gboolean
animator_is_running (Animator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_running;
	return result;
}

void
animator_add_nodes (Animator* self,
                    GArray* n,
                    const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GQueue* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->_actions;
	if (_tmp1_->length == ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		GQueue* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->_actions;
		_tmp3_ = g_queue_peek_tail (_tmp2_);
		_tmp0_ = animator_action_type ((AnimatorAction*) _tmp3_) != ANIMATION_TYPE_NODES;
	}
	if (_tmp0_) {
		GQueue* _tmp4_;
		DrawArea* _tmp5_;
		AnimatorNodes* _tmp6_;
		_tmp4_ = self->priv->_actions;
		_tmp5_ = self->priv->_da;
		_tmp6_ = animator_nodes_new (_tmp5_, n, name);
		g_queue_push_tail (_tmp4_, (AnimatorAction*) _tmp6_);
	}
}

static void
_vala_Node_free_function_content_of (gpointer data)
{
	Node* self;
	self = *((Node**) data);
	_g_object_unref0_ (self);
}

void
animator_add_node (Animator* self,
                   Node* n,
                   const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GQueue* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->_actions;
	if (_tmp1_->length == ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		GQueue* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->_actions;
		_tmp3_ = g_queue_peek_tail (_tmp2_);
		_tmp0_ = animator_action_type ((AnimatorAction*) _tmp3_) != ANIMATION_TYPE_NODE;
	}
	if (_tmp0_) {
		GArray* ns = NULL;
		GArray* _tmp4_;
		GArray* _tmp5_;
		Node* _tmp6_;
		GQueue* _tmp7_;
		DrawArea* _tmp8_;
		GArray* _tmp9_;
		AnimatorNodes* _tmp10_;
		_tmp4_ = g_array_new (TRUE, TRUE, sizeof (Node*));
		g_array_set_clear_func (_tmp4_, (GDestroyNotify) _vala_Node_free_function_content_of);
		ns = _tmp4_;
		_tmp5_ = ns;
		_tmp6_ = _g_object_ref0 (n);
		g_array_append_val (_tmp5_, _tmp6_);
		_tmp7_ = self->priv->_actions;
		_tmp8_ = self->priv->_da;
		_tmp9_ = ns;
		_tmp10_ = animator_nodes_new (_tmp8_, _tmp9_, name);
		g_queue_push_tail (_tmp7_, (AnimatorAction*) _tmp10_);
		_g_array_unref0 (ns);
	}
}

void
animator_add_callouts_fade (Animator* self,
                            GArray* n,
                            gboolean fade_out,
                            const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GQueue* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (n != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->_actions;
	if (_tmp1_->length == ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		GQueue* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->_actions;
		_tmp3_ = g_queue_peek_tail (_tmp2_);
		_tmp0_ = animator_action_type ((AnimatorAction*) _tmp3_) != ANIMATION_TYPE_FADE;
	}
	if (_tmp0_) {
		GQueue* _tmp4_;
		DrawArea* _tmp5_;
		AnimatorFade* _tmp6_;
		_tmp4_ = self->priv->_actions;
		_tmp5_ = self->priv->_da;
		_tmp6_ = animator_fade_new (_tmp5_, n, fade_out, name);
		g_queue_push_tail (_tmp4_, (AnimatorAction*) _tmp6_);
	}
}

void
animator_add_scale (Animator* self,
                    const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GQueue* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->_actions;
	if (_tmp1_->length == ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		GQueue* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->_actions;
		_tmp3_ = g_queue_peek_tail (_tmp2_);
		_tmp0_ = animator_action_type ((AnimatorAction*) _tmp3_) != ANIMATION_TYPE_SCALE;
	}
	if (_tmp0_) {
		GQueue* _tmp4_;
		DrawArea* _tmp5_;
		AnimatorScale* _tmp6_;
		_tmp4_ = self->priv->_actions;
		_tmp5_ = self->priv->_da;
		_tmp6_ = animator_scale_new (_tmp5_, name);
		g_queue_push_tail (_tmp4_, (AnimatorAction*) _tmp6_);
	}
}

void
animator_add_pan (Animator* self,
                  const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GQueue* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->_actions;
	if (_tmp1_->length == ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		GQueue* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->_actions;
		_tmp3_ = g_queue_peek_tail (_tmp2_);
		_tmp0_ = animator_action_type ((AnimatorAction*) _tmp3_) != ANIMATION_TYPE_PAN;
	}
	if (_tmp0_) {
		GQueue* _tmp4_;
		DrawArea* _tmp5_;
		AnimatorPan* _tmp6_;
		_tmp4_ = self->priv->_actions;
		_tmp5_ = self->priv->_da;
		_tmp6_ = animator_pan_new (_tmp5_, name);
		g_queue_push_tail (_tmp4_, (AnimatorAction*) _tmp6_);
	}
}

void
animator_add_pan_scale (Animator* self,
                        const gchar* name)
{
	gboolean _tmp0_ = FALSE;
	GQueue* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->_actions;
	if (_tmp1_->length == ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		GQueue* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->_actions;
		_tmp3_ = g_queue_peek_tail (_tmp2_);
		_tmp0_ = animator_action_type ((AnimatorAction*) _tmp3_) != ANIMATION_TYPE_PANSCALE;
	}
	if (_tmp0_) {
		GQueue* _tmp4_;
		DrawArea* _tmp5_;
		AnimatorPanScale* _tmp6_;
		_tmp4_ = self->priv->_actions;
		_tmp5_ = self->priv->_da;
		_tmp6_ = animator_pan_scale_new (_tmp5_, name);
		g_queue_push_tail (_tmp4_, (AnimatorAction*) _tmp6_);
	}
}

void
animator_add_scale_in_place (Animator* self,
                             const gchar* name,
                             gdouble ssx,
                             gdouble ssy)
{
	gboolean _tmp0_ = FALSE;
	GQueue* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp1_ = self->priv->_actions;
	if (_tmp1_->length == ((guint) 0)) {
		_tmp0_ = TRUE;
	} else {
		GQueue* _tmp2_;
		gconstpointer _tmp3_;
		_tmp2_ = self->priv->_actions;
		_tmp3_ = g_queue_peek_tail (_tmp2_);
		_tmp0_ = animator_action_type ((AnimatorAction*) _tmp3_) != ANIMATION_TYPE_PANSCALE;
	}
	if (_tmp0_) {
		GQueue* _tmp4_;
		DrawArea* _tmp5_;
		AnimatorScaleInPlace* _tmp6_;
		_tmp4_ = self->priv->_actions;
		_tmp5_ = self->priv->_da;
		_tmp6_ = animator_scale_in_place_new (_tmp5_, name, ssx, ssy);
		g_queue_push_tail (_tmp4_, (AnimatorAction*) _tmp6_);
	}
}

void
animator_cancel_last_add (Animator* self)
{
	GQueue* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_actions;
	if (_tmp0_->length > ((guint) 0)) {
		GQueue* _tmp1_;
		gpointer _tmp2_;
		AnimatorAction* _tmp3_;
		_tmp1_ = self->priv->_actions;
		_tmp2_ = g_queue_pop_tail (_tmp1_);
		_tmp3_ = (AnimatorAction*) _tmp2_;
		_g_object_unref0 (_tmp3_);
	}
}

void
animator_flush (Animator* self)
{
	GQueue* _tmp0_;
	g_return_if_fail (self != NULL);
	if (self->priv->_id > ((guint) 0)) {
		g_source_remove (self->priv->_id);
		self->priv->_id = (guint) 0;
	}
	_tmp0_ = self->priv->_actions;
	if (!g_queue_is_empty (_tmp0_)) {
		gboolean save_needed = FALSE;
		DrawArea* _tmp8_;
		save_needed = FALSE;
		while (TRUE) {
			GQueue* _tmp1_;
			AnimatorAction* action = NULL;
			GQueue* _tmp2_;
			gpointer _tmp3_;
			AnimatorAction* _tmp4_;
			DrawArea* _tmp5_;
			AnimatorAction* _tmp6_;
			_tmp1_ = self->priv->_actions;
			if (!(!g_queue_is_empty (_tmp1_))) {
				break;
			}
			_tmp2_ = self->priv->_actions;
			_tmp3_ = g_queue_pop_head (_tmp2_);
			action = (AnimatorAction*) _tmp3_;
			_tmp4_ = action;
			_tmp5_ = self->priv->_da;
			animator_action_flush (_tmp4_, _tmp5_);
			_tmp6_ = action;
			save_needed |= animator_action_save (_tmp6_);
			_g_object_unref0 (action);
		}
		self->priv->_running = FALSE;
		if (save_needed) {
			DrawArea* _tmp7_;
			_tmp7_ = self->priv->_da;
			draw_area_auto_save (_tmp7_);
		}
		_tmp8_ = self->priv->_da;
		gtk_widget_queue_draw ((GtkWidget*) _tmp8_);
	}
}

static gboolean
_animator_animate_action_gsource_func (gpointer self)
{
	gboolean result;
	result = animator_animate_action ((Animator*) self);
	return result;
}

void
animator_animate (Animator* self)
{
	gboolean _tmp0_;
	GQueue* _tmp9_;
	gconstpointer _tmp10_;
	DrawArea* _tmp11_;
	GQueue* _tmp12_;
	gconstpointer _tmp13_;
	DrawArea* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_enable;
	if (!_tmp0_) {
		gboolean save_needed = FALSE;
		DrawArea* _tmp8_;
		save_needed = FALSE;
		while (TRUE) {
			GQueue* _tmp1_;
			AnimatorAction* action = NULL;
			GQueue* _tmp2_;
			gpointer _tmp3_;
			AnimatorAction* _tmp4_;
			AnimatorAction* _tmp5_;
			DrawArea* _tmp6_;
			_tmp1_ = self->priv->_actions;
			if (!(!g_queue_is_empty (_tmp1_))) {
				break;
			}
			_tmp2_ = self->priv->_actions;
			_tmp3_ = g_queue_pop_head (_tmp2_);
			action = (AnimatorAction*) _tmp3_;
			_tmp4_ = action;
			save_needed |= animator_action_save (_tmp4_);
			_tmp5_ = action;
			_tmp6_ = self->priv->_da;
			animator_action_on_completion (_tmp5_, _tmp6_);
			_g_object_unref0 (action);
		}
		if (save_needed) {
			DrawArea* _tmp7_;
			_tmp7_ = self->priv->_da;
			draw_area_auto_save (_tmp7_);
		}
		_tmp8_ = self->priv->_da;
		gtk_widget_queue_draw ((GtkWidget*) _tmp8_);
		return;
	}
	if (!self->priv->_running) {
		self->priv->_running = TRUE;
		self->priv->_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ANIMATOR__timeout, _animator_animate_action_gsource_func, g_object_ref (self), g_object_unref);
	}
	_tmp9_ = self->priv->_actions;
	_tmp10_ = g_queue_peek_tail (_tmp9_);
	_tmp11_ = self->priv->_da;
	animator_action_capture ((AnimatorAction*) _tmp10_, _tmp11_);
	_tmp12_ = self->priv->_actions;
	_tmp13_ = g_queue_peek_tail (_tmp12_);
	_tmp14_ = self->priv->_da;
	animator_action_adjust ((AnimatorAction*) _tmp13_, _tmp14_);
}

static gboolean
animator_animate_action (Animator* self)
{
	GQueue* _tmp0_;
	gconstpointer _tmp1_;
	DrawArea* _tmp2_;
	GQueue* _tmp3_;
	gconstpointer _tmp4_;
	DrawArea* _tmp14_;
	GQueue* _tmp15_;
	GQueue* _tmp16_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_actions;
	_tmp1_ = g_queue_peek_head (_tmp0_);
	_tmp2_ = self->priv->_da;
	animator_action_adjust ((AnimatorAction*) _tmp1_, _tmp2_);
	_tmp3_ = self->priv->_actions;
	_tmp4_ = g_queue_peek_head (_tmp3_);
	if (animator_action_done ((AnimatorAction*) _tmp4_)) {
		GQueue* _tmp5_;
		gconstpointer _tmp6_;
		DrawArea* _tmp7_;
		GQueue* _tmp8_;
		gconstpointer _tmp9_;
		GQueue* _tmp11_;
		gpointer _tmp12_;
		AnimatorAction* _tmp13_;
		_tmp5_ = self->priv->_actions;
		_tmp6_ = g_queue_peek_head (_tmp5_);
		_tmp7_ = self->priv->_da;
		animator_action_on_completion ((AnimatorAction*) _tmp6_, _tmp7_);
		_tmp8_ = self->priv->_actions;
		_tmp9_ = g_queue_peek_head (_tmp8_);
		if (animator_action_save ((AnimatorAction*) _tmp9_)) {
			DrawArea* _tmp10_;
			_tmp10_ = self->priv->_da;
			draw_area_auto_save (_tmp10_);
		}
		_tmp11_ = self->priv->_actions;
		_tmp12_ = g_queue_pop_head (_tmp11_);
		_tmp13_ = (AnimatorAction*) _tmp12_;
		_g_object_unref0 (_tmp13_);
	}
	_tmp14_ = self->priv->_da;
	gtk_widget_queue_draw ((GtkWidget*) _tmp14_);
	_tmp15_ = self->priv->_actions;
	if (_tmp15_->length == ((guint) 0)) {
		self->priv->_id = (guint) 0;
	}
	_tmp16_ = self->priv->_actions;
	self->priv->_running = _tmp16_->length > ((guint) 0);
	result = self->priv->_running;
	return result;
}

gboolean
animator_get_enable (Animator* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_enable;
	return result;
}

void
animator_set_enable (Animator* self,
                     gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = animator_get_enable (self);
	if (old_value != value) {
		self->priv->_enable = value;
		g_object_notify_by_pspec ((GObject *) self, animator_properties[ANIMATOR_ENABLE_PROPERTY]);
	}
}

static void
animator_class_init (AnimatorClass * klass,
                     gpointer klass_data)
{
	animator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Animator_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_animator_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_animator_set_property;
	G_OBJECT_CLASS (klass)->finalize = animator_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), ANIMATOR_ENABLE_PROPERTY, animator_properties[ANIMATOR_ENABLE_PROPERTY] = g_param_spec_boolean ("enable", "enable", "enable", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
animator_instance_init (Animator * self,
                        gpointer klass)
{
	self->priv = animator_get_instance_private (self);
	self->priv->_running = FALSE;
	self->priv->_id = (guint) 0;
	self->priv->_enable = TRUE;
}

static void
animator_finalize (GObject * obj)
{
	Animator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ANIMATOR, Animator);
	_g_object_unref0 (self->priv->_da);
	(self->priv->_actions == NULL) ? NULL : (self->priv->_actions = (_g_queue_free__g_object_unref0_ (self->priv->_actions), NULL));
	G_OBJECT_CLASS (animator_parent_class)->finalize (obj);
}

static GType
animator_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (AnimatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) animator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Animator), 0, (GInstanceInitFunc) animator_instance_init, NULL };
	GType animator_type_id;
	animator_type_id = g_type_register_static (G_TYPE_OBJECT, "Animator", &g_define_type_info, 0);
	Animator_private_offset = g_type_add_instance_private (animator_type_id, sizeof (AnimatorPrivate));
	return animator_type_id;
}

GType
animator_get_type (void)
{
	static volatile gsize animator_type_id__once = 0;
	if (g_once_init_enter (&animator_type_id__once)) {
		GType animator_type_id;
		animator_type_id = animator_get_type_once ();
		g_once_init_leave (&animator_type_id__once, animator_type_id);
	}
	return animator_type_id__once;
}

static void
_vala_animator_get_property (GObject * object,
                             guint property_id,
                             GValue * value,
                             GParamSpec * pspec)
{
	Animator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATOR, Animator);
	switch (property_id) {
		case ANIMATOR_ENABLE_PROPERTY:
		g_value_set_boolean (value, animator_get_enable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_animator_set_property (GObject * object,
                             guint property_id,
                             const GValue * value,
                             GParamSpec * pspec)
{
	Animator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_ANIMATOR, Animator);
	switch (property_id) {
		case ANIMATOR_ENABLE_PROPERTY:
		animator_set_enable (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

