/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Subtarget Enumeration Source Fragment                                      *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#ifdef GET_SUBTARGETINFO_ENUM
#undef GET_SUBTARGETINFO_ENUM

namespace llvm {
namespace X86 {
enum {
  FeatureADX = 0,
  FeatureAES = 1,
  FeatureAMXBF16 = 2,
  FeatureAMXCOMPLEX = 3,
  FeatureAMXFP16 = 4,
  FeatureAMXINT8 = 5,
  FeatureAMXTILE = 6,
  FeatureAVX = 7,
  FeatureAVX2 = 8,
  FeatureAVX10_1 = 9,
  FeatureAVX10_1_512 = 10,
  FeatureAVX512 = 11,
  FeatureAVXIFMA = 12,
  FeatureAVXNECONVERT = 13,
  FeatureAVXVNNI = 14,
  FeatureAVXVNNIINT8 = 15,
  FeatureAVXVNNIINT16 = 16,
  FeatureBF16 = 17,
  FeatureBITALG = 18,
  FeatureBMI = 19,
  FeatureBMI2 = 20,
  FeatureBWI = 21,
  FeatureCCMP = 22,
  FeatureCDI = 23,
  FeatureCF = 24,
  FeatureCLDEMOTE = 25,
  FeatureCLFLUSHOPT = 26,
  FeatureCLWB = 27,
  FeatureCLZERO = 28,
  FeatureCMOV = 29,
  FeatureCMPCCXADD = 30,
  FeatureCRC32 = 31,
  FeatureCX8 = 32,
  FeatureCX16 = 33,
  FeatureDQI = 34,
  FeatureEGPR = 35,
  FeatureENQCMD = 36,
  FeatureERMSB = 37,
  FeatureEVEX512 = 38,
  FeatureF16C = 39,
  FeatureFMA = 40,
  FeatureFMA4 = 41,
  FeatureFP16 = 42,
  FeatureFSGSBase = 43,
  FeatureFSRM = 44,
  FeatureFXSR = 45,
  FeatureGFNI = 46,
  FeatureHRESET = 47,
  FeatureHardenSlsIJmp = 48,
  FeatureHardenSlsRet = 49,
  FeatureIFMA = 50,
  FeatureINVPCID = 51,
  FeatureKL = 52,
  FeatureLAHFSAHF64 = 53,
  FeatureLVIControlFlowIntegrity = 54,
  FeatureLVILoadHardening = 55,
  FeatureLWP = 56,
  FeatureLZCNT = 57,
  FeatureMMX = 58,
  FeatureMOVBE = 59,
  FeatureMOVDIR64B = 60,
  FeatureMOVDIRI = 61,
  FeatureMWAITX = 62,
  FeatureNDD = 63,
  FeatureNF = 64,
  FeatureNOPL = 65,
  FeaturePCLMUL = 66,
  FeaturePCONFIG = 67,
  FeaturePKU = 68,
  FeaturePOPCNT = 69,
  FeaturePPX = 70,
  FeaturePREFETCHI = 71,
  FeaturePRFCHW = 72,
  FeaturePTWRITE = 73,
  FeaturePush2Pop2 = 74,
  FeatureRAOINT = 75,
  FeatureRDPID = 76,
  FeatureRDPRU = 77,
  FeatureRDRAND = 78,
  FeatureRDSEED = 79,
  FeatureRTM = 80,
  FeatureRetpoline = 81,
  FeatureRetpolineExternalThunk = 82,
  FeatureRetpolineIndirectBranches = 83,
  FeatureRetpolineIndirectCalls = 84,
  FeatureSERIALIZE = 85,
  FeatureSGX = 86,
  FeatureSHA = 87,
  FeatureSHA512 = 88,
  FeatureSHSTK = 89,
  FeatureSM3 = 90,
  FeatureSM4 = 91,
  FeatureSSE1 = 92,
  FeatureSSE2 = 93,
  FeatureSSE3 = 94,
  FeatureSSE4A = 95,
  FeatureSSE41 = 96,
  FeatureSSE42 = 97,
  FeatureSSEUnalignedMem = 98,
  FeatureSSSE3 = 99,
  FeatureSoftFloat = 100,
  FeatureSpeculativeExecutionSideEffectSuppression = 101,
  FeatureTBM = 102,
  FeatureTSXLDTRK = 103,
  FeatureTaggedGlobals = 104,
  FeatureUINTR = 105,
  FeatureUSERMSR = 106,
  FeatureUseGPR32InInlineAsm = 107,
  FeatureVAES = 108,
  FeatureVBMI = 109,
  FeatureVBMI2 = 110,
  FeatureVLX = 111,
  FeatureVNNI = 112,
  FeatureVP2INTERSECT = 113,
  FeatureVPCLMULQDQ = 114,
  FeatureVPOPCNTDQ = 115,
  FeatureWAITPKG = 116,
  FeatureWBNOINVD = 117,
  FeatureWIDEKL = 118,
  FeatureX86_64 = 119,
  FeatureX87 = 120,
  FeatureXOP = 121,
  FeatureXSAVE = 122,
  FeatureXSAVEC = 123,
  FeatureXSAVEOPT = 124,
  FeatureXSAVES = 125,
  FeatureZU = 126,
  Is16Bit = 127,
  Is32Bit = 128,
  Is64Bit = 129,
  ProcIntelAtom = 130,
  TuningAllowLight256Bit = 131,
  TuningBranchFusion = 132,
  TuningBranchHint = 133,
  TuningFast7ByteNOP = 134,
  TuningFast11ByteNOP = 135,
  TuningFast15ByteNOP = 136,
  TuningFastBEXTR = 137,
  TuningFastDPWSSD = 138,
  TuningFastGather = 139,
  TuningFastHorizontalOps = 140,
  TuningFastImm16 = 141,
  TuningFastImmVectorShift = 142,
  TuningFastLZCNT = 143,
  TuningFastMOVBE = 144,
  TuningFastSHLDRotate = 145,
  TuningFastScalarFSQRT = 146,
  TuningFastScalarShiftMasks = 147,
  TuningFastVariableCrossLaneShuffle = 148,
  TuningFastVariablePerLaneShuffle = 149,
  TuningFastVectorFSQRT = 150,
  TuningFastVectorShiftMasks = 151,
  TuningGETMANTFalseDeps = 152,
  TuningInsertVZEROUPPER = 153,
  TuningLEAForSP = 154,
  TuningLEAUsesAG = 155,
  TuningLZCNTFalseDeps = 156,
  TuningMULCFalseDeps = 157,
  TuningMULLQFalseDeps = 158,
  TuningMacroFusion = 159,
  TuningNoDomainDelay = 160,
  TuningNoDomainDelayBlend = 161,
  TuningNoDomainDelayMov = 162,
  TuningNoDomainDelayShuffle = 163,
  TuningPERMFalseDeps = 164,
  TuningPOPCNTFalseDeps = 165,
  TuningPadShortFunctions = 166,
  TuningPrefer128Bit = 167,
  TuningPrefer256Bit = 168,
  TuningPreferMaskRegisters = 169,
  TuningPreferMovmskOverVTest = 170,
  TuningPreferNoGather = 171,
  TuningPreferNoScatter = 172,
  TuningPreferShiftShuffle = 173,
  TuningRANGEFalseDeps = 174,
  TuningSBBDepBreaking = 175,
  TuningSlow3OpsLEA = 176,
  TuningSlowDivide32 = 177,
  TuningSlowDivide64 = 178,
  TuningSlowIncDec = 179,
  TuningSlowLEA = 180,
  TuningSlowPMADDWD = 181,
  TuningSlowPMULLD = 182,
  TuningSlowSHLD = 183,
  TuningSlowTwoMemOps = 184,
  TuningSlowUAMem16 = 185,
  TuningSlowUAMem32 = 186,
  TuningUseGLMDivSqrtCosts = 187,
  TuningUseSLMArithCosts = 188,
  NumSubtargetFeatures = 189
};
} // end namespace X86
} // end namespace llvm

#endif // GET_SUBTARGETINFO_ENUM


#ifdef GET_SUBTARGETINFO_MACRO
GET_SUBTARGETINFO_MACRO(AllowLight256Bit, false, allowLight256Bit)
GET_SUBTARGETINFO_MACRO(AllowTaggedGlobals, false, allowTaggedGlobals)
GET_SUBTARGETINFO_MACRO(DeprecatedUseRetpoline, false, deprecatedUseRetpoline)
GET_SUBTARGETINFO_MACRO(FastImmVectorShift, false, fastImmVectorShift)
GET_SUBTARGETINFO_MACRO(HardenSlsIJmp, false, hardenSlsIJmp)
GET_SUBTARGETINFO_MACRO(HardenSlsRet, false, hardenSlsRet)
GET_SUBTARGETINFO_MACRO(HasADX, false, hasADX)
GET_SUBTARGETINFO_MACRO(HasAES, false, hasAES)
GET_SUBTARGETINFO_MACRO(HasAMXBF16, false, hasAMXBF16)
GET_SUBTARGETINFO_MACRO(HasAMXCOMPLEX, false, hasAMXCOMPLEX)
GET_SUBTARGETINFO_MACRO(HasAMXFP16, false, hasAMXFP16)
GET_SUBTARGETINFO_MACRO(HasAMXINT8, false, hasAMXINT8)
GET_SUBTARGETINFO_MACRO(HasAMXTILE, false, hasAMXTILE)
GET_SUBTARGETINFO_MACRO(HasAVX10_1, false, hasAVX10_1)
GET_SUBTARGETINFO_MACRO(HasAVX10_1_512, false, hasAVX10_1_512)
GET_SUBTARGETINFO_MACRO(HasAVXIFMA, false, hasAVXIFMA)
GET_SUBTARGETINFO_MACRO(HasAVXNECONVERT, false, hasAVXNECONVERT)
GET_SUBTARGETINFO_MACRO(HasAVXVNNI, false, hasAVXVNNI)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT16, false, hasAVXVNNIINT16)
GET_SUBTARGETINFO_MACRO(HasAVXVNNIINT8, false, hasAVXVNNIINT8)
GET_SUBTARGETINFO_MACRO(HasBF16, false, hasBF16)
GET_SUBTARGETINFO_MACRO(HasBITALG, false, hasBITALG)
GET_SUBTARGETINFO_MACRO(HasBMI, false, hasBMI)
GET_SUBTARGETINFO_MACRO(HasBMI2, false, hasBMI2)
GET_SUBTARGETINFO_MACRO(HasBWI, false, hasBWI)
GET_SUBTARGETINFO_MACRO(HasBranchFusion, false, hasBranchFusion)
GET_SUBTARGETINFO_MACRO(HasBranchHint, false, hasBranchHint)
GET_SUBTARGETINFO_MACRO(HasCCMP, false, hasCCMP)
GET_SUBTARGETINFO_MACRO(HasCDI, false, hasCDI)
GET_SUBTARGETINFO_MACRO(HasCF, false, hasCF)
GET_SUBTARGETINFO_MACRO(HasCLDEMOTE, false, hasCLDEMOTE)
GET_SUBTARGETINFO_MACRO(HasCLFLUSHOPT, false, hasCLFLUSHOPT)
GET_SUBTARGETINFO_MACRO(HasCLWB, false, hasCLWB)
GET_SUBTARGETINFO_MACRO(HasCLZERO, false, hasCLZERO)
GET_SUBTARGETINFO_MACRO(HasCMOV, false, hasCMOV)
GET_SUBTARGETINFO_MACRO(HasCMPCCXADD, false, hasCMPCCXADD)
GET_SUBTARGETINFO_MACRO(HasCRC32, false, hasCRC32)
GET_SUBTARGETINFO_MACRO(HasCX16, false, hasCX16)
GET_SUBTARGETINFO_MACRO(HasCX8, false, hasCX8)
GET_SUBTARGETINFO_MACRO(HasDQI, false, hasDQI)
GET_SUBTARGETINFO_MACRO(HasEGPR, false, hasEGPR)
GET_SUBTARGETINFO_MACRO(HasENQCMD, false, hasENQCMD)
GET_SUBTARGETINFO_MACRO(HasERMSB, false, hasERMSB)
GET_SUBTARGETINFO_MACRO(HasEVEX512, false, hasEVEX512)
GET_SUBTARGETINFO_MACRO(HasF16C, false, hasF16C)
GET_SUBTARGETINFO_MACRO(HasFMA, false, hasFMA)
GET_SUBTARGETINFO_MACRO(HasFMA4, false, hasFMA4)
GET_SUBTARGETINFO_MACRO(HasFP16, false, hasFP16)
GET_SUBTARGETINFO_MACRO(HasFSGSBase, false, hasFSGSBase)
GET_SUBTARGETINFO_MACRO(HasFSRM, false, hasFSRM)
GET_SUBTARGETINFO_MACRO(HasFXSR, false, hasFXSR)
GET_SUBTARGETINFO_MACRO(HasFast11ByteNOP, false, hasFast11ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast15ByteNOP, false, hasFast15ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFast7ByteNOP, false, hasFast7ByteNOP)
GET_SUBTARGETINFO_MACRO(HasFastBEXTR, false, hasFastBEXTR)
GET_SUBTARGETINFO_MACRO(HasFastDPWSSD, false, hasFastDPWSSD)
GET_SUBTARGETINFO_MACRO(HasFastGather, false, hasFastGather)
GET_SUBTARGETINFO_MACRO(HasFastHorizontalOps, false, hasFastHorizontalOps)
GET_SUBTARGETINFO_MACRO(HasFastImm16, false, hasFastImm16)
GET_SUBTARGETINFO_MACRO(HasFastLZCNT, false, hasFastLZCNT)
GET_SUBTARGETINFO_MACRO(HasFastMOVBE, false, hasFastMOVBE)
GET_SUBTARGETINFO_MACRO(HasFastSHLDRotate, false, hasFastSHLDRotate)
GET_SUBTARGETINFO_MACRO(HasFastScalarFSQRT, false, hasFastScalarFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastScalarShiftMasks, false, hasFastScalarShiftMasks)
GET_SUBTARGETINFO_MACRO(HasFastVariableCrossLaneShuffle, false, hasFastVariableCrossLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVariablePerLaneShuffle, false, hasFastVariablePerLaneShuffle)
GET_SUBTARGETINFO_MACRO(HasFastVectorFSQRT, false, hasFastVectorFSQRT)
GET_SUBTARGETINFO_MACRO(HasFastVectorShiftMasks, false, hasFastVectorShiftMasks)
GET_SUBTARGETINFO_MACRO(HasGETMANTFalseDeps, false, hasGETMANTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasGFNI, false, hasGFNI)
GET_SUBTARGETINFO_MACRO(HasHRESET, false, hasHRESET)
GET_SUBTARGETINFO_MACRO(HasIFMA, false, hasIFMA)
GET_SUBTARGETINFO_MACRO(HasINVPCID, false, hasINVPCID)
GET_SUBTARGETINFO_MACRO(HasKL, false, hasKL)
GET_SUBTARGETINFO_MACRO(HasLAHFSAHF64, false, hasLAHFSAHF64)
GET_SUBTARGETINFO_MACRO(HasLWP, false, hasLWP)
GET_SUBTARGETINFO_MACRO(HasLZCNT, false, hasLZCNT)
GET_SUBTARGETINFO_MACRO(HasLZCNTFalseDeps, false, hasLZCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMMX, false, hasMMX)
GET_SUBTARGETINFO_MACRO(HasMOVBE, false, hasMOVBE)
GET_SUBTARGETINFO_MACRO(HasMOVDIR64B, false, hasMOVDIR64B)
GET_SUBTARGETINFO_MACRO(HasMOVDIRI, false, hasMOVDIRI)
GET_SUBTARGETINFO_MACRO(HasMULCFalseDeps, false, hasMULCFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMULLQFalseDeps, false, hasMULLQFalseDeps)
GET_SUBTARGETINFO_MACRO(HasMWAITX, false, hasMWAITX)
GET_SUBTARGETINFO_MACRO(HasMacroFusion, false, hasMacroFusion)
GET_SUBTARGETINFO_MACRO(HasNDD, false, hasNDD)
GET_SUBTARGETINFO_MACRO(HasNF, false, hasNF)
GET_SUBTARGETINFO_MACRO(HasNOPL, false, hasNOPL)
GET_SUBTARGETINFO_MACRO(HasPCLMUL, false, hasPCLMUL)
GET_SUBTARGETINFO_MACRO(HasPCONFIG, false, hasPCONFIG)
GET_SUBTARGETINFO_MACRO(HasPERMFalseDeps, false, hasPERMFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPKU, false, hasPKU)
GET_SUBTARGETINFO_MACRO(HasPOPCNT, false, hasPOPCNT)
GET_SUBTARGETINFO_MACRO(HasPOPCNTFalseDeps, false, hasPOPCNTFalseDeps)
GET_SUBTARGETINFO_MACRO(HasPPX, false, hasPPX)
GET_SUBTARGETINFO_MACRO(HasPREFETCHI, false, hasPREFETCHI)
GET_SUBTARGETINFO_MACRO(HasPRFCHW, false, hasPRFCHW)
GET_SUBTARGETINFO_MACRO(HasPTWRITE, false, hasPTWRITE)
GET_SUBTARGETINFO_MACRO(HasPush2Pop2, false, hasPush2Pop2)
GET_SUBTARGETINFO_MACRO(HasRANGEFalseDeps, false, hasRANGEFalseDeps)
GET_SUBTARGETINFO_MACRO(HasRAOINT, false, hasRAOINT)
GET_SUBTARGETINFO_MACRO(HasRDPID, false, hasRDPID)
GET_SUBTARGETINFO_MACRO(HasRDPRU, false, hasRDPRU)
GET_SUBTARGETINFO_MACRO(HasRDRAND, false, hasRDRAND)
GET_SUBTARGETINFO_MACRO(HasRDSEED, false, hasRDSEED)
GET_SUBTARGETINFO_MACRO(HasRTM, false, hasRTM)
GET_SUBTARGETINFO_MACRO(HasSBBDepBreaking, false, hasSBBDepBreaking)
GET_SUBTARGETINFO_MACRO(HasSERIALIZE, false, hasSERIALIZE)
GET_SUBTARGETINFO_MACRO(HasSGX, false, hasSGX)
GET_SUBTARGETINFO_MACRO(HasSHA, false, hasSHA)
GET_SUBTARGETINFO_MACRO(HasSHA512, false, hasSHA512)
GET_SUBTARGETINFO_MACRO(HasSHSTK, false, hasSHSTK)
GET_SUBTARGETINFO_MACRO(HasSM3, false, hasSM3)
GET_SUBTARGETINFO_MACRO(HasSM4, false, hasSM4)
GET_SUBTARGETINFO_MACRO(HasSSE4A, false, hasSSE4A)
GET_SUBTARGETINFO_MACRO(HasSSEUnalignedMem, false, hasSSEUnalignedMem)
GET_SUBTARGETINFO_MACRO(HasSlowDivide32, false, hasSlowDivide32)
GET_SUBTARGETINFO_MACRO(HasSlowDivide64, false, hasSlowDivide64)
GET_SUBTARGETINFO_MACRO(HasTBM, false, hasTBM)
GET_SUBTARGETINFO_MACRO(HasTSXLDTRK, false, hasTSXLDTRK)
GET_SUBTARGETINFO_MACRO(HasUINTR, false, hasUINTR)
GET_SUBTARGETINFO_MACRO(HasUSERMSR, false, hasUSERMSR)
GET_SUBTARGETINFO_MACRO(HasVAES, false, hasVAES)
GET_SUBTARGETINFO_MACRO(HasVBMI, false, hasVBMI)
GET_SUBTARGETINFO_MACRO(HasVBMI2, false, hasVBMI2)
GET_SUBTARGETINFO_MACRO(HasVLX, false, hasVLX)
GET_SUBTARGETINFO_MACRO(HasVNNI, false, hasVNNI)
GET_SUBTARGETINFO_MACRO(HasVP2INTERSECT, false, hasVP2INTERSECT)
GET_SUBTARGETINFO_MACRO(HasVPCLMULQDQ, false, hasVPCLMULQDQ)
GET_SUBTARGETINFO_MACRO(HasVPOPCNTDQ, false, hasVPOPCNTDQ)
GET_SUBTARGETINFO_MACRO(HasWAITPKG, false, hasWAITPKG)
GET_SUBTARGETINFO_MACRO(HasWBNOINVD, false, hasWBNOINVD)
GET_SUBTARGETINFO_MACRO(HasWIDEKL, false, hasWIDEKL)
GET_SUBTARGETINFO_MACRO(HasX86_64, false, hasX86_64)
GET_SUBTARGETINFO_MACRO(HasX87, false, hasX87)
GET_SUBTARGETINFO_MACRO(HasXOP, false, hasXOP)
GET_SUBTARGETINFO_MACRO(HasXSAVE, false, hasXSAVE)
GET_SUBTARGETINFO_MACRO(HasXSAVEC, false, hasXSAVEC)
GET_SUBTARGETINFO_MACRO(HasXSAVEOPT, false, hasXSAVEOPT)
GET_SUBTARGETINFO_MACRO(HasXSAVES, false, hasXSAVES)
GET_SUBTARGETINFO_MACRO(HasZU, false, hasZU)
GET_SUBTARGETINFO_MACRO(InsertVZEROUPPER, false, insertVZEROUPPER)
GET_SUBTARGETINFO_MACRO(Is16Bit, false, is16Bit)
GET_SUBTARGETINFO_MACRO(Is32Bit, false, is32Bit)
GET_SUBTARGETINFO_MACRO(Is64Bit, false, is64Bit)
GET_SUBTARGETINFO_MACRO(IsAtom, false, isAtom)
GET_SUBTARGETINFO_MACRO(IsPMADDWDSlow, false, isPMADDWDSlow)
GET_SUBTARGETINFO_MACRO(IsPMULLDSlow, false, isPMULLDSlow)
GET_SUBTARGETINFO_MACRO(IsSHLDSlow, false, isSHLDSlow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem16Slow, false, isUnalignedMem16Slow)
GET_SUBTARGETINFO_MACRO(IsUnalignedMem32Slow, false, isUnalignedMem32Slow)
GET_SUBTARGETINFO_MACRO(LeaUsesAG, false, leaUsesAG)
GET_SUBTARGETINFO_MACRO(NoDomainDelay, false, noDomainDelay)
GET_SUBTARGETINFO_MACRO(NoDomainDelayBlend, false, noDomainDelayBlend)
GET_SUBTARGETINFO_MACRO(NoDomainDelayMov, false, noDomainDelayMov)
GET_SUBTARGETINFO_MACRO(NoDomainDelayShuffle, false, noDomainDelayShuffle)
GET_SUBTARGETINFO_MACRO(PadShortFunctions, false, padShortFunctions)
GET_SUBTARGETINFO_MACRO(Prefer128Bit, false, prefer128Bit)
GET_SUBTARGETINFO_MACRO(Prefer256Bit, false, prefer256Bit)
GET_SUBTARGETINFO_MACRO(PreferGather, true, preferGather)
GET_SUBTARGETINFO_MACRO(PreferLowerShuffleAsShift, false, preferLowerShuffleAsShift)
GET_SUBTARGETINFO_MACRO(PreferMaskRegisters, false, preferMaskRegisters)
GET_SUBTARGETINFO_MACRO(PreferMovmskOverVTest, false, preferMovmskOverVTest)
GET_SUBTARGETINFO_MACRO(PreferScatter, true, preferScatter)
GET_SUBTARGETINFO_MACRO(Slow3OpsLEA, false, slow3OpsLEA)
GET_SUBTARGETINFO_MACRO(SlowIncDec, false, slowIncDec)
GET_SUBTARGETINFO_MACRO(SlowLEA, false, slowLEA)
GET_SUBTARGETINFO_MACRO(SlowTwoMemOps, false, slowTwoMemOps)
GET_SUBTARGETINFO_MACRO(UseGLMDivSqrtCosts, false, useGLMDivSqrtCosts)
GET_SUBTARGETINFO_MACRO(UseInlineAsmGPR32, false, useInlineAsmGPR32)
GET_SUBTARGETINFO_MACRO(UseLVIControlFlowIntegrity, false, useLVIControlFlowIntegrity)
GET_SUBTARGETINFO_MACRO(UseLVILoadHardening, false, useLVILoadHardening)
GET_SUBTARGETINFO_MACRO(UseLeaForSP, false, useLeaForSP)
GET_SUBTARGETINFO_MACRO(UseRetpolineExternalThunk, false, useRetpolineExternalThunk)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectBranches, false, useRetpolineIndirectBranches)
GET_SUBTARGETINFO_MACRO(UseRetpolineIndirectCalls, false, useRetpolineIndirectCalls)
GET_SUBTARGETINFO_MACRO(UseSLMArithCosts, false, useSLMArithCosts)
GET_SUBTARGETINFO_MACRO(UseSoftFloat, false, useSoftFloat)
GET_SUBTARGETINFO_MACRO(UseSpeculativeExecutionSideEffectSuppression, false, useSpeculativeExecutionSideEffectSuppression)
#undef GET_SUBTARGETINFO_MACRO
#endif // GET_SUBTARGETINFO_MACRO


#ifdef GET_SUBTARGETINFO_MC_DESC
#undef GET_SUBTARGETINFO_MC_DESC

namespace llvm {
// Sorted (by key) array of values for CPU features.
extern const llvm::SubtargetFeatureKV X86FeatureKV[] = {
  { "16bit-mode", "16-bit mode (i8086)", X86::Is16Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "32bit-mode", "32-bit mode (80386)", X86::Is32Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit", "Support 64-bit instructions", X86::FeatureX86_64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "64bit-mode", "64-bit mode (x86_64)", X86::Is64Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "adx", "Support ADX instructions", X86::FeatureADX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "aes", "Enable AES instructions", X86::FeatureAES, { { { 0x0ULL, 0x20000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "allow-light-256-bit", "Enable generation of 256-bit load/stores even if we prefer 128-bit", X86::TuningAllowLight256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-bf16", "Support AMX-BF16 instructions", X86::FeatureAMXBF16, { { { 0x40ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-complex", "Support AMX-COMPLEX instructions", X86::FeatureAMXCOMPLEX, { { { 0x40ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-fp16", "Support AMX amx-fp16 instructions", X86::FeatureAMXFP16, { { { 0x40ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-int8", "Support AMX-INT8 instructions", X86::FeatureAMXINT8, { { { 0x40ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "amx-tile", "Support AMX-TILE instructions", X86::FeatureAMXTILE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx", "Enable AVX instructions", X86::FeatureAVX, { { { 0x0ULL, 0x200000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.1-256", "Support AVX10.1 up to 256-bit instruction", X86::FeatureAVX10_1, { { { 0x4040000860000ULL, 0xd700000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx10.1-512", "Support AVX10.1 up to 512-bit instruction", X86::FeatureAVX10_1_512, { { { 0x4000000200ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx2", "Enable AVX2 instructions", X86::FeatureAVX2, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bf16", "Support bfloat16 floating point", X86::FeatureBF16, { { { 0x200000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bitalg", "Enable AVX-512 Bit Algorithms", X86::FeatureBITALG, { { { 0x200000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512bw", "Enable AVX-512 Byte and Word Instructions", X86::FeatureBWI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512cd", "Enable AVX-512 Conflict Detection Instructions", X86::FeatureCDI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512dq", "Enable AVX-512 Doubleword and Quadword Instructions", X86::FeatureDQI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512f", "Enable AVX-512 instructions", X86::FeatureAVX512, { { { 0x18000000100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512fp16", "Support 16-bit floating point", X86::FeatureFP16, { { { 0x400200000ULL, 0x800000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512ifma", "Enable AVX-512 Integer Fused Multiple-Add", X86::FeatureIFMA, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi", "Enable AVX-512 Vector Byte Manipulation Instructions", X86::FeatureVBMI, { { { 0x200000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vbmi2", "Enable AVX-512 further Vector Byte Manipulation Instructions", X86::FeatureVBMI2, { { { 0x200000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vl", "Enable AVX-512 Vector Length eXtensions", X86::FeatureVLX, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vnni", "Enable AVX-512 Vector Neural Network Instructions", X86::FeatureVNNI, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vp2intersect", "Enable AVX-512 vp2intersect", X86::FeatureVP2INTERSECT, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avx512vpopcntdq", "Enable AVX-512 Population Count Instructions", X86::FeatureVPOPCNTDQ, { { { 0x800ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxifma", "Enable AVX-IFMA", X86::FeatureAVXIFMA, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxneconvert", "Support AVX-NE-CONVERT instructions", X86::FeatureAVXNECONVERT, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnni", "Support AVX_VNNI encoding", X86::FeatureAVXVNNI, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint16", "Enable AVX-VNNI-INT16", X86::FeatureAVXVNNIINT16, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "avxvnniint8", "Enable AVX-VNNI-INT8", X86::FeatureAVXVNNIINT8, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi", "Support BMI instructions", X86::FeatureBMI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "bmi2", "Support BMI2 instructions", X86::FeatureBMI2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branch-hint", "Target has branch hint feature", X86::TuningBranchHint, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "branchfusion", "CMP/TEST can be fused with conditional branches", X86::TuningBranchFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ccmp", "Support conditional cmp & test instructions", X86::FeatureCCMP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cf", "Support conditional faulting", X86::FeatureCF, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cldemote", "Enable Cache Line Demote", X86::FeatureCLDEMOTE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clflushopt", "Flush A Cache Line Optimized", X86::FeatureCLFLUSHOPT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clwb", "Cache Line Write Back", X86::FeatureCLWB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "clzero", "Enable Cache Line Zero", X86::FeatureCLZERO, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmov", "Enable conditional move instructions", X86::FeatureCMOV, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cmpccxadd", "Support CMPCCXADD instructions", X86::FeatureCMPCCXADD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "crc32", "Enable SSE 4.2 CRC32 instruction (used when SSE4.2 is supported but function is GPR only)", X86::FeatureCRC32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx16", "64-bit with cmpxchg16b (this is true for most x86-64 chips, but not the first AMD chips)", X86::FeatureCX16, { { { 0x100000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "cx8", "Support CMPXCHG8B instructions", X86::FeatureCX8, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "egpr", "Support extended general purpose register", X86::FeatureEGPR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "enqcmd", "Has ENQCMD instructions", X86::FeatureENQCMD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ermsb", "REP MOVS/STOS are fast", X86::FeatureERMSB, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "evex512", "Support ZMM and 64-bit mask instructions", X86::FeatureEVEX512, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "f16c", "Support 16-bit floating point conversion instructions", X86::FeatureF16C, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-getmant", "VGETMANTSS/SD/SH and VGETMANDPS/PD(memory version) has a false dependency on dest register", X86::TuningGETMANTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-lzcnt-tzcnt", "LZCNT/TZCNT have a false dependency on dest register", X86::TuningLZCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mulc", "VF[C]MULCPH/SH has a false dependency on dest register", X86::TuningMULCFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-mullq", "VPMULLQ has a false dependency on dest register", X86::TuningMULLQFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-perm", "VPERMD/Q/PS/PD has a false dependency on dest register", X86::TuningPERMFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-popcnt", "POPCNT has a false dependency on dest register", X86::TuningPOPCNTFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "false-deps-range", "VRANGEPD/PS/SD/SS has a false dependency on dest register", X86::TuningRANGEFalseDeps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-11bytenop", "Target can quickly decode up to 11 byte NOPs", X86::TuningFast11ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-15bytenop", "Target can quickly decode up to 15 byte NOPs", X86::TuningFast15ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-7bytenop", "Target can quickly decode up to 7 byte NOPs", X86::TuningFast7ByteNOP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-bextr", "Indicates that the BEXTR instruction is implemented as a single uop with good throughput", X86::TuningFastBEXTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-dpwssd", "Prefer vpdpwssd instruction over vpmaddwd+vpaddd instruction sequence", X86::TuningFastDPWSSD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-gather", "Indicates if gather is reasonably fast (this is true for Skylake client and all AVX-512 CPUs)", X86::TuningFastGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-hops", "Prefer horizontal vector math instructions (haddp, phsub, etc.) over normal vector instructions with shuffles", X86::TuningFastHorizontalOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-imm16", "Prefer a i16 instruction with i16 immediate over extension to i32", X86::TuningFastImm16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-lzcnt", "LZCNT instructions are as fast as most simple integer ops", X86::TuningFastLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-movbe", "Prefer a movbe over a single-use load + bswap / single-use bswap + store", X86::TuningFastMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-fsqrt", "Scalar SQRT is fast (disable Newton-Raphson)", X86::TuningFastScalarFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-scalar-shift-masks", "Prefer a left/right scalar logical shift pair over a shift+and pair", X86::TuningFastScalarShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-shld-rotate", "SHLD can be used as a faster rotate", X86::TuningFastSHLDRotate, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-crosslane-shuffle", "Cross-lane shuffles with variable masks are fast", X86::TuningFastVariableCrossLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-variable-perlane-shuffle", "Per-lane shuffles with variable masks are fast", X86::TuningFastVariablePerLaneShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-fsqrt", "Vector SQRT is fast (disable Newton-Raphson)", X86::TuningFastVectorFSQRT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fast-vector-shift-masks", "Prefer a left/right vector logical shift pair over a shift+and pair", X86::TuningFastVectorShiftMasks, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "faster-shift-than-shuffle", "Shifts are faster (or as fast) as shuffle", X86::TuningPreferShiftShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma", "Enable three-operand fused multiple-add", X86::FeatureFMA, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fma4", "Enable four-operand fused multiple-add", X86::FeatureFMA4, { { { 0x80ULL, 0x80000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsgsbase", "Support FS/GS Base instructions", X86::FeatureFSGSBase, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fsrm", "REP MOVSB of short lengths is faster", X86::FeatureFSRM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "fxsr", "Support fxsave/fxrestore instructions", X86::FeatureFXSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "gfni", "Enable Galois Field Arithmetic Instructions", X86::FeatureGFNI, { { { 0x0ULL, 0x20000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ijmp", "Harden against straight line speculation across indirect JMP instructions.", X86::FeatureHardenSlsIJmp, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "harden-sls-ret", "Harden against straight line speculation across RET instructions.", X86::FeatureHardenSlsRet, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "hreset", "Has hreset instruction", X86::FeatureHRESET, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivl-to-divb", "Use 8-bit divide for positive values less than 256", X86::TuningSlowDivide32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "idivq-to-divl", "Use 32-bit divide for positive values less than 2^32", X86::TuningSlowDivide64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "inline-asm-use-gpr32", "Enable use of GPR32 in inline assembly for APX", X86::FeatureUseGPR32InInlineAsm, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "invpcid", "Invalidate Process-Context Identifier", X86::FeatureINVPCID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "kl", "Support Key Locker kl Instructions", X86::FeatureKL, { { { 0x0ULL, 0x20000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-sp", "Use LEA for adjusting the stack pointer (this is an optimization for Intel Atom processors)", X86::TuningLEAForSP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lea-uses-ag", "LEA instruction needs inputs at AG stage", X86::TuningLEAUsesAG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-cfi", "Prevent indirect calls/branches from using a memory operand, and precede all indirect calls/branches from a register with an LFENCE instruction to serialize control flow. Also decompose RET instructions into a POP+LFENCE+JMP sequence.", X86::FeatureLVIControlFlowIntegrity, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lvi-load-hardening", "Insert LFENCE instructions to prevent data speculatively injected into loads from being used maliciously.", X86::FeatureLVILoadHardening, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lwp", "Enable LWP instructions", X86::FeatureLWP, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "lzcnt", "Support LZCNT instruction", X86::FeatureLZCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "macrofusion", "Various instructions can be fused with conditional branches", X86::TuningMacroFusion, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mmx", "Enable MMX instructions", X86::FeatureMMX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movbe", "Support MOVBE instruction", X86::FeatureMOVBE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdir64b", "Support movdir64b instruction (direct store 64 bytes)", X86::FeatureMOVDIR64B, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "movdiri", "Support movdiri instruction (direct store integer)", X86::FeatureMOVDIRI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "mwaitx", "Enable MONITORX/MWAITX timer functionality", X86::FeatureMWAITX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ndd", "Support non-destructive destination", X86::FeatureNDD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nf", "Support status flags update suppression", X86::FeatureNF, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay", "Has no bypass delay when using the 'wrong' domain", X86::TuningNoDomainDelay, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-blend", "Has no bypass delay when using the 'wrong' blend type", X86::TuningNoDomainDelayBlend, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-mov", "Has no bypass delay when using the 'wrong' mov type", X86::TuningNoDomainDelayMov, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "no-bypass-delay-shuffle", "Has no bypass delay when using the 'wrong' shuffle type", X86::TuningNoDomainDelayShuffle, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "nopl", "Enable NOPL instruction (generally pentium pro+)", X86::FeatureNOPL, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pad-short-functions", "Pad short functions (to prevent a stall when returning too early)", X86::TuningPadShortFunctions, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pclmul", "Enable packed carry-less multiplication instructions", X86::FeaturePCLMUL, { { { 0x0ULL, 0x20000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pconfig", "platform configuration instruction", X86::FeaturePCONFIG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "pku", "Enable protection keys", X86::FeaturePKU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "popcnt", "Support POPCNT instruction", X86::FeaturePOPCNT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ppx", "Support Push-Pop Acceleration", X86::FeaturePPX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-128-bit", "Prefer 128-bit AVX instructions", X86::TuningPrefer128Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-256-bit", "Prefer 256-bit AVX instructions", X86::TuningPrefer256Bit, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-mask-registers", "Prefer AVX512 mask registers over PTEST/MOVMSK", X86::TuningPreferMaskRegisters, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-movmsk-over-vtest", "Prefer movmsk over vtest instruction", X86::TuningPreferMovmskOverVTest, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-gather", "Prefer no gather instructions", X86::TuningPreferNoGather, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefer-no-scatter", "Prefer no scatter instructions", X86::TuningPreferNoScatter, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prefetchi", "Prefetch instruction with T0 or T1 Hint", X86::FeaturePREFETCHI, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "prfchw", "Support PRFCHW instructions", X86::FeaturePRFCHW, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ptwrite", "Support ptwrite instruction", X86::FeaturePTWRITE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "push2pop2", "Support PUSH2/POP2 instructions", X86::FeaturePush2Pop2, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "raoint", "Support RAO-INT instructions", X86::FeatureRAOINT, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpid", "Support RDPID instructions", X86::FeatureRDPID, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdpru", "Support RDPRU instructions", X86::FeatureRDPRU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdrnd", "Support RDRAND instruction", X86::FeatureRDRAND, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rdseed", "Support RDSEED instruction", X86::FeatureRDSEED, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline", "Remove speculation of indirect branches from the generated code, either by avoiding them entirely or lowering them with a speculation blocking construct", X86::FeatureRetpoline, { { { 0x0ULL, 0x180000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-external-thunk", "When lowering an indirect call or branch using a `retpoline`, rely on the specified user provided thunk rather than emitting one ourselves. Only has effect when combined with some other retpoline feature", X86::FeatureRetpolineExternalThunk, { { { 0x0ULL, 0x100000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-branches", "Remove speculation of indirect branches from the generated code", X86::FeatureRetpolineIndirectBranches, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "retpoline-indirect-calls", "Remove speculation of indirect calls from the generated code", X86::FeatureRetpolineIndirectCalls, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "rtm", "Support RTM instructions", X86::FeatureRTM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sahf", "Support LAHF and SAHF instructions in 64-bit mode", X86::FeatureLAHFSAHF64, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sbb-dep-breaking", "SBB with same register has no source dependency", X86::TuningSBBDepBreaking, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "serialize", "Has serialize instruction", X86::FeatureSERIALIZE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "seses", "Prevent speculative execution side channel timing attacks by inserting a speculation barrier before memory reads, memory writes, and conditional branches. Implies LVI Control Flow integrity.", X86::FeatureSpeculativeExecutionSideEffectSuppression, { { { 0x40000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sgx", "Enable Software Guard Extensions", X86::FeatureSGX, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha", "Enable SHA instructions", X86::FeatureSHA, { { { 0x0ULL, 0x20000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sha512", "Support SHA512 instructions", X86::FeatureSHA512, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "shstk", "Support CET Shadow-Stack instructions", X86::FeatureSHSTK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-3ops-lea", "LEA instruction with 3 ops or certain registers is slow", X86::TuningSlow3OpsLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-incdec", "INC and DEC instructions are slower than ADD and SUB", X86::TuningSlowIncDec, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-lea", "LEA instruction with certain arguments is slow", X86::TuningSlowLEA, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmaddwd", "PMADDWD is slower than PMULLD", X86::TuningSlowPMADDWD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-pmulld", "PMULLD instruction is slow (compared to PMULLW/PMULHW and PMULUDQ)", X86::TuningSlowPMULLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-shld", "SHLD instruction is slow", X86::TuningSlowSHLD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-two-mem-ops", "Two memory operand instructions are slow", X86::TuningSlowTwoMemOps, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-16", "Slow unaligned 16-byte memory access", X86::TuningSlowUAMem16, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "slow-unaligned-mem-32", "Slow unaligned 32-byte memory access", X86::TuningSlowUAMem32, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm3", "Support SM3 instructions", X86::FeatureSM3, { { { 0x80ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sm4", "Support SM4 instructions", X86::FeatureSM4, { { { 0x100ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "soft-float", "Use software floating point features", X86::FeatureSoftFloat, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse", "Enable SSE instructions", X86::FeatureSSE1, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse-unaligned-mem", "Allow unaligned memory operands with SSE instructions (this may require setting a configuration bit in the processor)", X86::FeatureSSEUnalignedMem, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse2", "Enable SSE2 instructions", X86::FeatureSSE2, { { { 0x0ULL, 0x10000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse3", "Enable SSE3 instructions", X86::FeatureSSE3, { { { 0x0ULL, 0x20000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.1", "Enable SSE 4.1 instructions", X86::FeatureSSE41, { { { 0x0ULL, 0x800000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4.2", "Enable SSE 4.2 instructions", X86::FeatureSSE42, { { { 0x0ULL, 0x100000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "sse4a", "Support SSE 4a instructions", X86::FeatureSSE4A, { { { 0x0ULL, 0x40000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "ssse3", "Enable SSSE3 instructions", X86::FeatureSSSE3, { { { 0x0ULL, 0x40000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tagged-globals", "Use an instruction sequence for taking the address of a global that allows a memory tag in the upper address bits.", X86::FeatureTaggedGlobals, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tbm", "Enable TBM instructions", X86::FeatureTBM, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tsxldtrk", "Support TSXLDTRK instructions", X86::FeatureTSXLDTRK, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "tuning-fast-imm-vector-shift", "Vector shifts are fast (2/cycle) as opposed to slow (1/cycle)", X86::TuningFastImmVectorShift, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "uintr", "Has UINTR Instructions", X86::FeatureUINTR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-glm-div-sqrt-costs", "Use Goldmont specific floating point div/sqrt costs", X86::TuningUseGLMDivSqrtCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "use-slm-arith-costs", "Use Silvermont specific arithmetic costs", X86::TuningUseSLMArithCosts, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "usermsr", "Support USERMSR instructions", X86::FeatureUSERMSR, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vaes", "Promote selected AES instructions to AVX512/AVX registers", X86::FeatureVAES, { { { 0x102ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vpclmulqdq", "Enable vpclmulqdq instructions", X86::FeatureVPCLMULQDQ, { { { 0x80ULL, 0x4ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "vzeroupper", "Should insert vzeroupper instructions", X86::TuningInsertVZEROUPPER, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "waitpkg", "Wait and pause enhancements", X86::FeatureWAITPKG, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "wbnoinvd", "Write Back No Invalidate", X86::FeatureWBNOINVD, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "widekl", "Support Key Locker wide Instructions", X86::FeatureWIDEKL, { { { 0x10000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "x87", "Enable X87 float instructions", X86::FeatureX87, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xop", "Enable XOP instructions", X86::FeatureXOP, { { { 0x20000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsave", "Support xsave instructions", X86::FeatureXSAVE, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsavec", "Support xsavec instructions", X86::FeatureXSAVEC, { { { 0x0ULL, 0x400000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaveopt", "Support xsaveopt instructions", X86::FeatureXSAVEOPT, { { { 0x0ULL, 0x400000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "xsaves", "Support xsaves instructions", X86::FeatureXSAVES, { { { 0x0ULL, 0x400000000000000ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
  { "zu", "Support zero-upper SETcc/IMUL", X86::FeatureZU, { { { 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, 0x0ULL, } } } },
};

#ifdef DBGFIELD
#error "<target>GenSubtargetInfo.inc requires a DBGFIELD macro"
#endif
#if !defined(NDEBUG) || defined(LLVM_ENABLE_DUMP)
#define DBGFIELD(x) x,
#else
#define DBGFIELD(x)
#endif

// ===============================================================
// Data tables for the new per-operand machine model.

// {ProcResourceIdx, ReleaseAtCycle, AcquireAtCycle}
extern const llvm::MCWriteProcResEntry X86WriteProcResTable[] = {
  { 0,  0,  0 }, // Invalid
  { 5,  1,   0}, // #1
  {30,  1,   0}, // #2
  { 1,  1,   0}, // #3
  { 2,  1,   0}, // #4
  { 3,  1,   0}, // #5
  { 4,  1,   0}, // #6
  { 5,  1,   0}, // #7
  { 6,  1,   0}, // #8
  { 7,  1,   0}, // #9
  { 8,  1,   0}, // #10
  {30,  1,   0}, // #11
  { 4,  1,   0}, // #12
  { 5,  1,   0}, // #13
  { 7,  1,   0}, // #14
  { 8,  1,   0}, // #15
  {30,  1,   0}, // #16
  { 4,  2,   0}, // #17
  { 5,  3,   0}, // #18
  { 7,  2,   0}, // #19
  { 8,  2,   0}, // #20
  {15,  2,   0}, // #21
  {17,  1,   0}, // #22
  {20,  1,   0}, // #23
  {25,  1,   0}, // #24
  {30,  6,   0}, // #25
  { 4,  1,   0}, // #26
  { 5,  1,   0}, // #27
  { 7,  1,   0}, // #28
  { 8,  1,   0}, // #29
  {13,  1,   0}, // #30
  {14,  1,   0}, // #31
  {15,  1,   0}, // #32
  {16,  1,   0}, // #33
  {17,  1,   0}, // #34
  {30,  2,   0}, // #35
  { 4,  1,   0}, // #36
  { 5,  1,   0}, // #37
  {30,  1,   0}, // #38
  { 2,  1,   0}, // #39
  { 3,  1,   0}, // #40
  { 4,  1,   0}, // #41
  { 5,  1,   0}, // #42
  { 9,  1,   0}, // #43
  {10,  1,   0}, // #44
  {11,  1,   0}, // #45
  {30,  1,   0}, // #46
  {15,  2,   0}, // #47
  {17,  1,   0}, // #48
  {20,  1,   0}, // #49
  {25,  1,   0}, // #50
  {30,  3,   0}, // #51
  {15,  1,   0}, // #52
  {20,  1,   0}, // #53
  {25,  1,   0}, // #54
  {30,  2,   0}, // #55
  {15,  1,   0}, // #56
  {17,  1,   0}, // #57
  {30,  1,   0}, // #58
  { 5,  1,   0}, // #59
  {15,  2,   0}, // #60
  {17,  1,   0}, // #61
  {20,  1,   0}, // #62
  {25,  1,   0}, // #63
  {30,  4,   0}, // #64
  { 4,  1,   0}, // #65
  { 5,  2,   0}, // #66
  { 7,  1,   0}, // #67
  { 8,  1,   0}, // #68
  {15,  2,   0}, // #69
  {17,  1,   0}, // #70
  {20,  1,   0}, // #71
  {25,  1,   0}, // #72
  {30,  5,   0}, // #73
  { 4,  1,   0}, // #74
  { 5,  2,   0}, // #75
  { 7,  1,   0}, // #76
  { 8,  1,   0}, // #77
  {30,  2,   0}, // #78
  { 3,  1,   0}, // #79
  { 4,  1,   0}, // #80
  { 5,  1,   0}, // #81
  {10,  1,   0}, // #82
  {11,  1,   0}, // #83
  {15,  1,   0}, // #84
  {17,  1,   0}, // #85
  {30,  2,   0}, // #86
  { 3,  1,   0}, // #87
  { 4,  1,   0}, // #88
  { 5,  1,   0}, // #89
  {10,  1,   0}, // #90
  {11,  1,   0}, // #91
  {30,  1,   0}, // #92
  { 3,  1,   0}, // #93
  { 4,  1,   0}, // #94
  { 5,  1,   0}, // #95
  { 6,  1,   0}, // #96
  { 7,  1,   0}, // #97
  {10,  1,   0}, // #98
  {11,  1,   0}, // #99
  {21,  1,   0}, // #100
  {22,  1,   0}, // #101
  {30,  1,   0}, // #102
  { 2,  1,   0}, // #103
  { 3,  1,   0}, // #104
  { 4,  1,   0}, // #105
  { 5,  1,   0}, // #106
  {15,  1,   0}, // #107
  {17,  1,   0}, // #108
  {30,  2,   0}, // #109
  { 2,  1,   0}, // #110
  { 3,  1,   0}, // #111
  { 4,  1,   0}, // #112
  { 5,  1,   0}, // #113
  {30,  1,   0}, // #114
  { 2,  2,   0}, // #115
  { 3,  2,   0}, // #116
  { 4,  2,   0}, // #117
  { 5,  2,   0}, // #118
  {15,  1,   0}, // #119
  {17,  1,   0}, // #120
  {30,  3,   0}, // #121
  { 2,  2,   0}, // #122
  { 3,  2,   0}, // #123
  { 4,  2,   0}, // #124
  { 5,  2,   0}, // #125
  {30,  2,   0}, // #126
  { 1,  4,   0}, // #127
  { 2,  5,   0}, // #128
  { 3, 11,   0}, // #129
  { 4, 13,   0}, // #130
  { 5, 13,   0}, // #131
  { 6,  7,   0}, // #132
  { 7,  9,   0}, // #133
  { 8,  6,   0}, // #134
  {10,  6,   0}, // #135
  {11,  6,   0}, // #136
  {15,  1,   0}, // #137
  {17,  1,   0}, // #138
  {21,  3,   0}, // #139
  {22,  3,   0}, // #140
  {30, 14,   0}, // #141
  { 1,  4,   0}, // #142
  { 2,  5,   0}, // #143
  { 3, 12,   0}, // #144
  { 4, 14,   0}, // #145
  { 5, 14,   0}, // #146
  { 6,  7,   0}, // #147
  { 7,  9,   0}, // #148
  { 8,  6,   0}, // #149
  {10,  6,   0}, // #150
  {11,  6,   0}, // #151
  {21,  3,   0}, // #152
  {22,  3,   0}, // #153
  {30, 14,   0}, // #154
  { 2,  1,   0}, // #155
  { 3,  1,   0}, // #156
  { 4,  2,   0}, // #157
  { 5,  2,   0}, // #158
  { 7,  1,   0}, // #159
  { 8,  1,   0}, // #160
  { 9,  1,   0}, // #161
  {10,  1,   0}, // #162
  {11,  1,   0}, // #163
  {15,  1,   0}, // #164
  {17,  1,   0}, // #165
  {30,  3,   0}, // #166
  { 2,  1,   0}, // #167
  { 3,  1,   0}, // #168
  { 4,  2,   0}, // #169
  { 5,  2,   0}, // #170
  { 7,  1,   0}, // #171
  { 8,  1,   0}, // #172
  { 9,  1,   0}, // #173
  {10,  1,   0}, // #174
  {11,  1,   0}, // #175
  {30,  2,   0}, // #176
  { 5,  1,   0}, // #177
  {11,  1,   0}, // #178
  {15,  1,   0}, // #179
  {17,  1,   0}, // #180
  {30,  2,   0}, // #181
  { 5,  1,   0}, // #182
  {11,  1,   0}, // #183
  {30,  1,   0}, // #184
  { 2,  1,   0}, // #185
  { 3,  1,   0}, // #186
  { 4,  1,   0}, // #187
  { 5,  1,   0}, // #188
  { 9,  1,   0}, // #189
  {10,  1,   0}, // #190
  {11,  1,   0}, // #191
  {15,  1,   0}, // #192
  {17,  1,   0}, // #193
  {30,  2,   0}, // #194
  { 2,  1,   0}, // #195
  { 3,  1,   0}, // #196
  { 4,  3,   0}, // #197
  { 5,  9,   0}, // #198
  { 7,  2,   0}, // #199
  { 8,  2,   0}, // #200
  { 9,  1,   0}, // #201
  {10,  1,   0}, // #202
  {11,  3,   0}, // #203
  {15,  1,   0}, // #204
  {17,  1,   0}, // #205
  {30, 10,   0}, // #206
  { 2,  1,   0}, // #207
  { 3,  1,   0}, // #208
  { 4,  1,   0}, // #209
  { 5,  1,   0}, // #210
  { 9,  1,   0}, // #211
  {10,  1,   0}, // #212
  {11,  1,   0}, // #213
  {15,  2,   0}, // #214
  {17,  1,   0}, // #215
  {20,  1,   0}, // #216
  {25,  1,   0}, // #217
  {30,  4,   0}, // #218
  { 2,  1,   0}, // #219
  { 3,  1,   0}, // #220
  { 4,  3,   0}, // #221
  { 5,  8,   0}, // #222
  { 7,  2,   0}, // #223
  { 8,  2,   0}, // #224
  { 9,  1,   0}, // #225
  {10,  1,   0}, // #226
  {11,  3,   0}, // #227
  {15,  2,   0}, // #228
  {17,  1,   0}, // #229
  {20,  1,   0}, // #230
  {25,  1,   0}, // #231
  {30, 11,   0}, // #232
  { 4,  1,   0}, // #233
  { 5,  1,   0}, // #234
  { 7,  1,   0}, // #235
  { 8,  1,   0}, // #236
  {15,  1,   0}, // #237
  {17,  1,   0}, // #238
  {30,  2,   0}, // #239
  { 5,  3,   0}, // #240
  {30,  3,   0}, // #241
  { 4,  2,   0}, // #242
  { 5,  5,   0}, // #243
  { 7,  2,   0}, // #244
  { 8,  2,   0}, // #245
  {30,  5,   0}, // #246
  { 1,  1,   0}, // #247
  { 2,  1,   0}, // #248
  { 3,  1,   0}, // #249
  { 4,  1,   0}, // #250
  { 5,  1,   0}, // #251
  { 6,  1,   0}, // #252
  { 7,  1,   0}, // #253
  { 8,  1,   0}, // #254
  {15,  1,   0}, // #255
  {17,  1,   0}, // #256
  {30,  2,   0}, // #257
  { 2,  1,   0}, // #258
  { 3,  2,   0}, // #259
  { 4,  2,   0}, // #260
  { 5,  2,   0}, // #261
  { 6,  1,   0}, // #262
  { 7,  1,   0}, // #263
  {10,  1,   0}, // #264
  {11,  1,   0}, // #265
  {21,  1,   0}, // #266
  {22,  1,   0}, // #267
  {30,  2,   0}, // #268
  { 2,  1,   0}, // #269
  { 3,  2,   0}, // #270
  { 4,  2,   0}, // #271
  { 5,  2,   0}, // #272
  { 6,  1,   0}, // #273
  { 7,  1,   0}, // #274
  {10,  1,   0}, // #275
  {11,  1,   0}, // #276
  {15,  1,   0}, // #277
  {17,  1,   0}, // #278
  {21,  1,   0}, // #279
  {22,  1,   0}, // #280
  {30,  3,   0}, // #281
  { 1,  1,   0}, // #282
  { 2,  2,   0}, // #283
  { 3,  2,   0}, // #284
  { 4,  2,   0}, // #285
  { 5,  2,   0}, // #286
  { 6,  1,   0}, // #287
  { 7,  1,   0}, // #288
  { 8,  1,   0}, // #289
  {15,  1,   0}, // #290
  {17,  1,   0}, // #291
  {30,  3,   0}, // #292
  { 1,  1,   0}, // #293
  { 2,  2,   0}, // #294
  { 3,  2,   0}, // #295
  { 4,  2,   0}, // #296
  { 5,  2,   0}, // #297
  { 6,  1,   0}, // #298
  { 7,  1,   0}, // #299
  { 8,  1,   0}, // #300
  {30,  2,   0}, // #301
  { 2,  3,   0}, // #302
  { 3,  3,   0}, // #303
  { 4,  3,   0}, // #304
  { 5,  4,   0}, // #305
  { 9,  3,   0}, // #306
  {10,  3,   0}, // #307
  {11,  3,   0}, // #308
  {15,  1,   0}, // #309
  {17,  1,   0}, // #310
  {30,  5,   0}, // #311
  { 2,  3,   0}, // #312
  { 3,  3,   0}, // #313
  { 4,  3,   0}, // #314
  { 5,  4,   0}, // #315
  { 9,  3,   0}, // #316
  {10,  3,   0}, // #317
  {11,  3,   0}, // #318
  {30,  4,   0}, // #319
  { 2,  3,   0}, // #320
  { 3,  3,   0}, // #321
  { 4,  3,   0}, // #322
  { 5,  3,   0}, // #323
  { 9,  3,   0}, // #324
  {10,  3,   0}, // #325
  {11,  3,   0}, // #326
  {15,  1,   0}, // #327
  {17,  1,   0}, // #328
  {30,  4,   0}, // #329
  { 2,  3,   0}, // #330
  { 3,  3,   0}, // #331
  { 4,  3,   0}, // #332
  { 5,  3,   0}, // #333
  { 9,  3,   0}, // #334
  {10,  3,   0}, // #335
  {11,  3,   0}, // #336
  {30,  3,   0}, // #337
  { 2,  2,   0}, // #338
  { 3,  3,   0}, // #339
  { 4,  3,   0}, // #340
  { 5,  3,   0}, // #341
  {10,  1,   0}, // #342
  {11,  1,   0}, // #343
  {15,  1,   0}, // #344
  {17,  1,   0}, // #345
  {30,  4,   0}, // #346
  { 2,  2,   0}, // #347
  { 3,  3,   0}, // #348
  { 4,  3,   0}, // #349
  { 5,  3,   0}, // #350
  {10,  1,   0}, // #351
  {11,  1,   0}, // #352
  {30,  3,   0}, // #353
  { 2,  2,   0}, // #354
  { 3,  5,   0}, // #355
  { 4,  6,   0}, // #356
  { 5,  6,   0}, // #357
  { 6,  1,   0}, // #358
  { 7,  2,   0}, // #359
  { 8,  1,   0}, // #360
  {10,  3,   0}, // #361
  {11,  3,   0}, // #362
  {15,  1,   0}, // #363
  {17,  1,   0}, // #364
  {21,  1,   0}, // #365
  {22,  1,   0}, // #366
  {30,  7,   0}, // #367
  { 2,  2,   0}, // #368
  { 3,  5,   0}, // #369
  { 4,  6,   0}, // #370
  { 5,  6,   0}, // #371
  { 6,  1,   0}, // #372
  { 7,  2,   0}, // #373
  { 8,  1,   0}, // #374
  {10,  3,   0}, // #375
  {11,  3,   0}, // #376
  {21,  1,   0}, // #377
  {22,  1,   0}, // #378
  {30,  6,   0}, // #379
  { 3,  1,   0}, // #380
  { 4,  1,   0}, // #381
  { 5,  1,   0}, // #382
  {10,  1,   0}, // #383
  {11,  1,   0}, // #384
  {15,  1,   0}, // #385
  {20,  1,   0}, // #386
  {25,  1,   0}, // #387
  {30,  3,   0}, // #388
  { 1,  1,   0}, // #389
  { 2,  1,   0}, // #390
  { 3,  2,   0}, // #391
  { 4,  2,   0}, // #392
  { 5,  2,   0}, // #393
  { 6,  1,   0}, // #394
  { 7,  1,   0}, // #395
  { 8,  1,   0}, // #396
  {10,  1,   0}, // #397
  {11,  1,   0}, // #398
  {30,  2,   0}, // #399
  { 3,  1,   0}, // #400
  { 4,  1,   0}, // #401
  { 5,  1,   0}, // #402
  { 6,  1,   0}, // #403
  { 7,  1,   0}, // #404
  {10,  1,   0}, // #405
  {11,  1,   0}, // #406
  {13,  1,   0}, // #407
  {14,  1,   0}, // #408
  {15,  1,   0}, // #409
  {16,  1,   0}, // #410
  {17,  1,   0}, // #411
  {21,  1,   0}, // #412
  {22,  1,   0}, // #413
  {30,  2,   0}, // #414
  { 1,  1,   0}, // #415
  { 2,  1,   0}, // #416
  { 3,  9,   0}, // #417
  { 4, 10,   0}, // #418
  { 5, 10,   0}, // #419
  { 6,  9,   0}, // #420
  { 7, 10,   0}, // #421
  { 8,  2,   0}, // #422
  {30, 10,   0}, // #423
  { 3,  2,   0}, // #424
  { 4,  2,   0}, // #425
  { 5,  2,   0}, // #426
  { 6,  2,   0}, // #427
  { 7,  2,   0}, // #428
  {30,  2,   0}, // #429
  { 3,  3,   0}, // #430
  { 4,  3,   0}, // #431
  { 5,  3,   0}, // #432
  { 6,  2,   0}, // #433
  { 7,  2,   0}, // #434
  {10,  3,   0}, // #435
  {11,  3,   0}, // #436
  {15,  1,   0}, // #437
  {17,  1,   0}, // #438
  {21,  2,   0}, // #439
  {22,  2,   0}, // #440
  {30,  4,   0}, // #441
  { 3,  3,   0}, // #442
  { 4,  3,   0}, // #443
  { 5,  3,   0}, // #444
  { 6,  2,   0}, // #445
  { 7,  2,   0}, // #446
  {10,  3,   0}, // #447
  {11,  3,   0}, // #448
  {21,  2,   0}, // #449
  {22,  2,   0}, // #450
  {30,  3,   0}, // #451
  { 2,  1,   0}, // #452
  { 3,  1,   0}, // #453
  { 4,  2,   0}, // #454
  { 5,  4,   0}, // #455
  { 7,  1,   0}, // #456
  { 8,  1,   0}, // #457
  { 9,  1,   0}, // #458
  {10,  1,   0}, // #459
  {11,  1,   0}, // #460
  {15,  1,   0}, // #461
  {17,  1,   0}, // #462
  {30,  5,   0}, // #463
  { 2,  1,   0}, // #464
  { 3,  1,   0}, // #465
  { 4,  2,   0}, // #466
  { 5,  4,   0}, // #467
  { 7,  1,   0}, // #468
  { 8,  1,   0}, // #469
  { 9,  1,   0}, // #470
  {10,  1,   0}, // #471
  {11,  1,   0}, // #472
  {30,  4,   0}, // #473
  { 2,  1,   0}, // #474
  { 3,  1,   0}, // #475
  { 4,  1,   0}, // #476
  { 5,  2,   0}, // #477
  { 9,  1,   0}, // #478
  {10,  1,   0}, // #479
  {11,  1,   0}, // #480
  {15,  1,   0}, // #481
  {17,  1,   0}, // #482
  {30,  3,   0}, // #483
  { 2,  1,   0}, // #484
  { 3,  1,   0}, // #485
  { 4,  1,   0}, // #486
  { 5,  2,   0}, // #487
  { 9,  1,   0}, // #488
  {10,  1,   0}, // #489
  {11,  1,   0}, // #490
  {30,  2,   0}, // #491
  { 2,  1,   0}, // #492
  { 3,  1,   0}, // #493
  { 4,  2,   0}, // #494
  { 5,  3,   0}, // #495
  { 7,  1,   0}, // #496
  { 8,  1,   0}, // #497
  { 9,  1,   0}, // #498
  {10,  1,   0}, // #499
  {11,  1,   0}, // #500
  {15,  1,   0}, // #501
  {17,  1,   0}, // #502
  {30,  4,   0}, // #503
  { 2,  1,   0}, // #504
  { 3,  1,   0}, // #505
  { 4,  2,   0}, // #506
  { 5,  3,   0}, // #507
  { 7,  1,   0}, // #508
  { 8,  1,   0}, // #509
  { 9,  1,   0}, // #510
  {10,  1,   0}, // #511
  {11,  1,   0}, // #512
  {30,  3,   0}, // #513
  { 2,  1,   0}, // #514
  { 3,  2,   0}, // #515
  { 4,  2,   0}, // #516
  { 5,  2,   0}, // #517
  { 6,  1,   0}, // #518
  { 7,  1,   0}, // #519
  { 9,  1,   0}, // #520
  {10,  2,   0}, // #521
  {11,  2,   0}, // #522
  {15,  1,   0}, // #523
  {17,  1,   0}, // #524
  {21,  1,   0}, // #525
  {22,  1,   0}, // #526
  {30,  3,   0}, // #527
  { 2,  1,   0}, // #528
  { 3,  2,   0}, // #529
  { 4,  2,   0}, // #530
  { 5,  2,   0}, // #531
  { 6,  1,   0}, // #532
  { 7,  1,   0}, // #533
  { 9,  1,   0}, // #534
  {10,  2,   0}, // #535
  {11,  2,   0}, // #536
  {21,  1,   0}, // #537
  {22,  1,   0}, // #538
  {30,  2,   0}, // #539
  { 3,  1,   0}, // #540
  { 4,  1,   0}, // #541
  { 5,  1,   0}, // #542
  { 6,  1,   0}, // #543
  { 7,  1,   0}, // #544
  {10,  1,   0}, // #545
  {11,  1,   0}, // #546
  {15,  1,   0}, // #547
  {17,  1,   0}, // #548
  {21,  1,   0}, // #549
  {22,  1,   0}, // #550
  {30,  2,   0}, // #551
  { 1,  1,   0}, // #552
  { 2,  1,   0}, // #553
  { 3,  2,   0}, // #554
  { 4,  3,   0}, // #555
  { 5,  3,   0}, // #556
  { 6,  1,   0}, // #557
  { 7,  2,   0}, // #558
  { 8,  2,   0}, // #559
  {15,  1,   0}, // #560
  {17,  1,   0}, // #561
  {30,  4,   0}, // #562
  { 3,  1,   0}, // #563
  { 4,  1,   0}, // #564
  { 5,  1,   0}, // #565
  { 6,  1,   0}, // #566
  { 7,  1,   0}, // #567
  {30,  1,   0}, // #568
  { 3,  1,   0}, // #569
  { 4,  1,   0}, // #570
  { 5,  1,   0}, // #571
  { 6,  1,   0}, // #572
  { 7,  1,   0}, // #573
  {15,  1,   0}, // #574
  {17,  1,   0}, // #575
  {30,  2,   0}, // #576
  { 3,  3,   0}, // #577
  { 4,  3,   0}, // #578
  { 5,  3,   0}, // #579
  { 6,  3,   0}, // #580
  { 7,  3,   0}, // #581
  {10,  2,   0}, // #582
  {11,  2,   0}, // #583
  {15,  1,   0}, // #584
  {17,  1,   0}, // #585
  {21,  2,   0}, // #586
  {22,  2,   0}, // #587
  {30,  4,   0}, // #588
  { 3,  3,   0}, // #589
  { 4,  3,   0}, // #590
  { 5,  3,   0}, // #591
  { 6,  3,   0}, // #592
  { 7,  3,   0}, // #593
  {10,  2,   0}, // #594
  {11,  2,   0}, // #595
  {21,  2,   0}, // #596
  {22,  2,   0}, // #597
  {30,  3,   0}, // #598
  { 3,  2,   0}, // #599
  { 4,  2,   0}, // #600
  { 5,  2,   0}, // #601
  { 6,  1,   0}, // #602
  { 7,  1,   0}, // #603
  {10,  2,   0}, // #604
  {11,  2,   0}, // #605
  {21,  1,   0}, // #606
  {22,  1,   0}, // #607
  {30,  2,   0}, // #608
  { 1,  1,   0}, // #609
  { 2,  1,   0}, // #610
  { 3,  2,   0}, // #611
  { 4,  2,   0}, // #612
  { 5,  2,   0}, // #613
  { 6,  2,   0}, // #614
  { 7,  2,   0}, // #615
  { 8,  1,   0}, // #616
  {10,  1,   0}, // #617
  {11,  1,   0}, // #618
  {15,  1,   0}, // #619
  {17,  1,   0}, // #620
  {21,  1,   0}, // #621
  {22,  1,   0}, // #622
  {30,  3,   0}, // #623
  { 1,  1,   0}, // #624
  { 2,  1,   0}, // #625
  { 3,  2,   0}, // #626
  { 4,  2,   0}, // #627
  { 5,  2,   0}, // #628
  { 6,  2,   0}, // #629
  { 7,  2,   0}, // #630
  { 8,  1,   0}, // #631
  {10,  1,   0}, // #632
  {11,  1,   0}, // #633
  {21,  1,   0}, // #634
  {22,  1,   0}, // #635
  {30,  2,   0}, // #636
  { 3,  2,   0}, // #637
  { 4,  2,   0}, // #638
  { 5,  2,   0}, // #639
  { 6,  1,   0}, // #640
  { 7,  1,   0}, // #641
  {10,  2,   0}, // #642
  {11,  2,   0}, // #643
  {15,  1,   0}, // #644
  {17,  1,   0}, // #645
  {21,  1,   0}, // #646
  {22,  1,   0}, // #647
  {30,  3,   0}, // #648
  { 1,  3,   0}, // #649
  { 2,  4,   0}, // #650
  { 3,  6,   0}, // #651
  { 4,  7,   0}, // #652
  { 5,  7,   0}, // #653
  { 6,  4,   0}, // #654
  { 7,  5,   0}, // #655
  { 8,  4,   0}, // #656
  { 9,  1,   0}, // #657
  {10,  2,   0}, // #658
  {11,  2,   0}, // #659
  {15,  1,   0}, // #660
  {17,  1,   0}, // #661
  {21,  1,   0}, // #662
  {22,  1,   0}, // #663
  {30,  8,   0}, // #664
  { 1,  3,   0}, // #665
  { 2,  4,   0}, // #666
  { 3,  7,   0}, // #667
  { 4,  8,   0}, // #668
  { 5,  8,   0}, // #669
  { 6,  4,   0}, // #670
  { 7,  5,   0}, // #671
  { 8,  4,   0}, // #672
  { 9,  1,   0}, // #673
  {10,  2,   0}, // #674
  {11,  2,   0}, // #675
  {21,  1,   0}, // #676
  {22,  1,   0}, // #677
  {30,  8,   0}, // #678
  { 1,  3,   0}, // #679
  { 2,  4,   0}, // #680
  { 3,  7,   0}, // #681
  { 4,  8,   0}, // #682
  { 5,  8,   0}, // #683
  { 6,  4,   0}, // #684
  { 7,  5,   0}, // #685
  { 8,  4,   0}, // #686
  { 9,  1,   0}, // #687
  {10,  2,   0}, // #688
  {11,  2,   0}, // #689
  {15,  1,   0}, // #690
  {17,  1,   0}, // #691
  {21,  1,   0}, // #692
  {22,  1,   0}, // #693
  {30,  9,   0}, // #694
  { 1,  3,   0}, // #695
  { 2,  4,   0}, // #696
  { 3,  8,   0}, // #697
  { 4,  9,   0}, // #698
  { 5,  9,   0}, // #699
  { 6,  4,   0}, // #700
  { 7,  5,   0}, // #701
  { 8,  4,   0}, // #702
  { 9,  1,   0}, // #703
  {10,  2,   0}, // #704
  {11,  2,   0}, // #705
  {21,  1,   0}, // #706
  {22,  1,   0}, // #707
  {30,  9,   0}, // #708
  { 1,  3,   0}, // #709
  { 2,  3,   0}, // #710
  { 3,  3,   0}, // #711
  { 4,  3,   0}, // #712
  { 5,  3,   0}, // #713
  { 6,  3,   0}, // #714
  { 7,  3,   0}, // #715
  { 8,  3,   0}, // #716
  {15,  1,   0}, // #717
  {17,  1,   0}, // #718
  {30,  4,   0}, // #719
  { 1,  3,   0}, // #720
  { 2,  3,   0}, // #721
  { 3,  3,   0}, // #722
  { 4,  3,   0}, // #723
  { 5,  3,   0}, // #724
  { 6,  3,   0}, // #725
  { 7,  3,   0}, // #726
  { 8,  3,   0}, // #727
  {30,  3,   0}, // #728
  { 3,  3,   0}, // #729
  { 4,  3,   0}, // #730
  { 5,  3,   0}, // #731
  {10,  2,   0}, // #732
  {11,  2,   0}, // #733
  {15,  1,   0}, // #734
  {17,  1,   0}, // #735
  {30,  4,   0}, // #736
  { 3,  3,   0}, // #737
  { 4,  3,   0}, // #738
  { 5,  3,   0}, // #739
  {10,  2,   0}, // #740
  {11,  2,   0}, // #741
  {30,  3,   0}, // #742
  { 2,  1,   0}, // #743
  { 3,  2,   0}, // #744
  { 4,  2,   0}, // #745
  { 5,  2,   0}, // #746
  {10,  1,   0}, // #747
  {11,  1,   0}, // #748
  {30,  2,   0}, // #749
  { 4,  4,   0}, // #750
  { 5,  6,   0}, // #751
  { 7,  4,   0}, // #752
  { 8,  4,   0}, // #753
  {30,  6,   0}, // #754
  { 2,  2,   0}, // #755
  { 3,  2,   0}, // #756
  { 4,  5,   0}, // #757
  { 5,  7,   0}, // #758
  { 7,  3,   0}, // #759
  { 8,  3,   0}, // #760
  { 9,  2,   0}, // #761
  {10,  2,   0}, // #762
  {11,  2,   0}, // #763
  {15,  2,   0}, // #764
  {17,  1,   0}, // #765
  {20,  1,   0}, // #766
  {25,  1,   0}, // #767
  {30, 10,   0}, // #768
  { 2,  2,   0}, // #769
  { 3,  2,   0}, // #770
  { 4,  7,   0}, // #771
  { 5,  9,   0}, // #772
  { 7,  5,   0}, // #773
  { 8,  5,   0}, // #774
  { 9,  2,   0}, // #775
  {10,  2,   0}, // #776
  {11,  2,   0}, // #777
  {30,  9,   0}, // #778
  { 4,  2,   0}, // #779
  { 5,  3,   0}, // #780
  { 7,  2,   0}, // #781
  { 8,  2,   0}, // #782
  {30,  3,   0}, // #783
  { 4,  2,   0}, // #784
  { 5,  2,   0}, // #785
  { 7,  2,   0}, // #786
  { 8,  2,   0}, // #787
  {30,  2,   0}, // #788
  { 4,  1,   0}, // #789
  { 5,  1,   0}, // #790
  { 7,  1,   0}, // #791
  { 8,  1,   0}, // #792
  {15,  2,   0}, // #793
  {17,  1,   0}, // #794
  {20,  1,   0}, // #795
  {25,  1,   0}, // #796
  {30,  4,   0}, // #797
  { 4,  2,   0}, // #798
  { 5,  2,   0}, // #799
  { 7,  2,   0}, // #800
  { 8,  2,   0}, // #801
  {15,  2,   0}, // #802
  {17,  1,   0}, // #803
  {20,  1,   0}, // #804
  {25,  1,   0}, // #805
  {30,  5,   0}, // #806
  { 4,  4,   0}, // #807
  { 5,  4,   0}, // #808
  { 7,  4,   0}, // #809
  { 8,  4,   0}, // #810
  {30,  4,   0}, // #811
  { 4,  2,   0}, // #812
  { 5,  2,   0}, // #813
  { 7,  2,   0}, // #814
  { 8,  2,   0}, // #815
  {15,  1,   0}, // #816
  {20,  1,   0}, // #817
  {25,  1,   0}, // #818
  {30,  4,   0}, // #819
  { 2,  1,   0}, // #820
  { 3,  1,   0}, // #821
  { 4,  2,   0}, // #822
  { 5,  3,   0}, // #823
  { 7,  1,   0}, // #824
  { 8,  1,   0}, // #825
  { 9,  1,   0}, // #826
  {10,  1,   0}, // #827
  {11,  1,   0}, // #828
  {15,  2,   0}, // #829
  {17,  1,   0}, // #830
  {20,  1,   0}, // #831
  {25,  1,   0}, // #832
  {30,  6,   0}, // #833
  { 2,  1,   0}, // #834
  { 3,  1,   0}, // #835
  { 4,  1,   0}, // #836
  { 5,  2,   0}, // #837
  { 9,  1,   0}, // #838
  {10,  1,   0}, // #839
  {11,  1,   0}, // #840
  {15,  2,   0}, // #841
  {17,  1,   0}, // #842
  {20,  1,   0}, // #843
  {25,  1,   0}, // #844
  {30,  5,   0}, // #845
  { 1,  1,   0}, // #846
  { 2,  1,   0}, // #847
  { 3,  1,   0}, // #848
  { 4,  1,   0}, // #849
  { 5,  1,   0}, // #850
  { 6,  1,   0}, // #851
  { 7,  1,   0}, // #852
  { 8,  1,   0}, // #853
  {30,  1,   0}, // #854
  {31,  7,   0}, // #855
  { 1,  1,   0}, // #856
  { 2,  1,   0}, // #857
  { 3,  1,   0}, // #858
  { 4,  2,   0}, // #859
  { 5,  2,   0}, // #860
  { 6,  1,   0}, // #861
  { 7,  2,   0}, // #862
  { 8,  2,   0}, // #863
  {15,  1,   0}, // #864
  {20,  1,   0}, // #865
  {25,  1,   0}, // #866
  {30,  4,   0}, // #867
  { 3,  3,   0}, // #868
  { 4,  3,   0}, // #869
  { 5,  3,   0}, // #870
  {15,  1,   0}, // #871
  {17,  1,   0}, // #872
  {30,  4,   0}, // #873
  { 3,  3,   0}, // #874
  { 4,  3,   0}, // #875
  { 5,  3,   0}, // #876
  {30,  3,   0}, // #877
  { 2,  1,   0}, // #878
  { 3,  1,   0}, // #879
  { 4,  1,   0}, // #880
  { 5,  1,   0}, // #881
  {15,  1,   0}, // #882
  {20,  1,   0}, // #883
  {25,  1,   0}, // #884
  {30,  3,   0}, // #885
  { 1,  1,   0}, // #886
  { 2,  1,   0}, // #887
  { 3,  1,   0}, // #888
  { 4,  1,   0}, // #889
  { 5,  1,   0}, // #890
  { 6,  1,   0}, // #891
  { 7,  1,   0}, // #892
  { 8,  1,   0}, // #893
  {15,  1,   0}, // #894
  {20,  1,   0}, // #895
  {25,  1,   0}, // #896
  {30,  3,   0}, // #897
  { 1,  1,   0}, // #898
  { 2,  1,   0}, // #899
  { 3,  2,   0}, // #900
  { 4,  2,   0}, // #901
  { 5,  2,   0}, // #902
  { 6,  1,   0}, // #903
  { 7,  1,   0}, // #904
  { 8,  1,   0}, // #905
  {30,  2,   0}, // #906
  { 1,  2,   0}, // #907
  { 2,  3,   0}, // #908
  { 3,  7,   0}, // #909
  { 4, 15,   0}, // #910
  { 5, 15,   0}, // #911
  { 6,  6,   0}, // #912
  { 7, 10,   0}, // #913
  { 8,  6,   0}, // #914
  { 9,  1,   0}, // #915
  {10,  3,   0}, // #916
  {11,  3,   0}, // #917
  {21,  2,   0}, // #918
  {22,  2,   0}, // #919
  {23,  4,   0}, // #920
  {30, 15,   0}, // #921
  { 2,  1,   0}, // #922
  { 3,  3,   0}, // #923
  { 4,  3,   0}, // #924
  { 5,  3,   0}, // #925
  { 6,  2,   0}, // #926
  { 7,  2,   0}, // #927
  {10,  2,   0}, // #928
  {11,  2,   0}, // #929
  {21,  2,   0}, // #930
  {22,  2,   0}, // #931
  {30,  3,   0}, // #932
  { 1,  1,   0}, // #933
  { 2,  2,   0}, // #934
  { 3,  3,   0}, // #935
  { 4,  3,   0}, // #936
  { 5,  3,   0}, // #937
  { 6,  2,   0}, // #938
  { 7,  2,   0}, // #939
  { 8,  1,   0}, // #940
  {10,  1,   0}, // #941
  {11,  1,   0}, // #942
  {21,  1,   0}, // #943
  {22,  1,   0}, // #944
  {30,  3,   0}, // #945
  {14,  1,   0}, // #946
  {15,  1,   0}, // #947
  {19,  1,   0}, // #948
  {20,  1,   0}, // #949
  {30,  2,   0}, // #950
  { 5,  4,   0}, // #951
  {15,  2,   0}, // #952
  {17,  1,   0}, // #953
  {20,  1,   0}, // #954
  {25,  1,   0}, // #955
  {30,  7,   0}, // #956
  { 4,  1,   0}, // #957
  { 5,  6,   0}, // #958
  { 7,  1,   0}, // #959
  { 8,  1,   0}, // #960
  {15,  2,   0}, // #961
  {17,  1,   0}, // #962
  {20,  1,   0}, // #963
  {25,  1,   0}, // #964
  {30,  9,   0}, // #965
  { 4,  2,   0}, // #966
  { 5,  2,   0}, // #967
  { 7,  1,   0}, // #968
  { 8,  1,   0}, // #969
  {30,  2,   0}, // #970
  {13,  1,   0}, // #971
  {14,  1,   0}, // #972
  {15,  1,   0}, // #973
  {16,  1,   0}, // #974
  {17,  1,   0}, // #975
  {30,  1,   0}, // #976
  { 1,  1,   0}, // #977
  { 2,  1,   0}, // #978
  { 3,  2,   0}, // #979
  { 4,  2,   0}, // #980
  { 5,  2,   0}, // #981
  { 6,  2,   0}, // #982
  { 7,  2,   0}, // #983
  { 8,  1,   0}, // #984
  {13,  1,   0}, // #985
  {14,  1,   0}, // #986
  {15,  1,   0}, // #987
  {16,  1,   0}, // #988
  {17,  1,   0}, // #989
  {30,  3,   0}, // #990
  { 3,  1,   0}, // #991
  { 4,  1,   0}, // #992
  { 5,  1,   0}, // #993
  { 6,  1,   0}, // #994
  { 7,  1,   0}, // #995
  {10,  1,   0}, // #996
  {11,  1,   0}, // #997
  {14,  1,   0}, // #998
  {15,  1,   0}, // #999
  {19,  1,   0}, // #1000
  {20,  1,   0}, // #1001
  {21,  1,   0}, // #1002
  {22,  1,   0}, // #1003
  {30,  3,   0}, // #1004
  { 2,  1,   0}, // #1005
  { 3,  1,   0}, // #1006
  { 4,  7,   0}, // #1007
  { 5, 11,   0}, // #1008
  { 7,  6,   0}, // #1009
  { 8,  6,   0}, // #1010
  { 9,  1,   0}, // #1011
  {10,  1,   0}, // #1012
  {11,  1,   0}, // #1013
  {30, 11,   0}, // #1014
  { 4,  1,   0}, // #1015
  { 5,  1,   0}, // #1016
  { 7,  1,   0}, // #1017
  { 8,  1,   0}, // #1018
  {14,  1,   0}, // #1019
  {15,  1,   0}, // #1020
  {19,  1,   0}, // #1021
  {20,  1,   0}, // #1022
  {23,  1,   0}, // #1023
  {30,  3,   0}, // #1024
  { 3,  1,   0}, // #1025
  { 4,  2,   0}, // #1026
  { 5,  2,   0}, // #1027
  { 6,  1,   0}, // #1028
  { 7,  2,   0}, // #1029
  { 8,  1,   0}, // #1030
  {10,  1,   0}, // #1031
  {11,  1,   0}, // #1032
  {21,  1,   0}, // #1033
  {22,  1,   0}, // #1034
  {30,  2,   0}, // #1035
  { 2,  2,   0}, // #1036
  { 3,  2,   0}, // #1037
  { 4,  9,   0}, // #1038
  { 5, 13,   0}, // #1039
  { 7,  7,   0}, // #1040
  { 8,  7,   0}, // #1041
  { 9,  2,   0}, // #1042
  {10,  2,   0}, // #1043
  {11,  2,   0}, // #1044
  {15,  2,   0}, // #1045
  {17,  1,   0}, // #1046
  {20,  1,   0}, // #1047
  {25,  1,   0}, // #1048
  {30, 16,   0}, // #1049
  { 2,  1,   0}, // #1050
  { 3,  1,   0}, // #1051
  { 4,  5,   0}, // #1052
  { 5,  7,   0}, // #1053
  { 7,  4,   0}, // #1054
  { 8,  4,   0}, // #1055
  { 9,  1,   0}, // #1056
  {10,  1,   0}, // #1057
  {11,  1,   0}, // #1058
  {30,  7,   0}, // #1059
  { 1,  2,   0}, // #1060
  { 2,  2,   0}, // #1061
  { 3,  6,   0}, // #1062
  { 4, 12,   0}, // #1063
  { 5, 19,   0}, // #1064
  { 6,  4,   0}, // #1065
  { 7, 10,   0}, // #1066
  { 8,  8,   0}, // #1067
  {10,  4,   0}, // #1068
  {11,  4,   0}, // #1069
  {15,  2,   0}, // #1070
  {17,  1,   0}, // #1071
  {20,  1,   0}, // #1072
  {21,  2,   0}, // #1073
  {22,  2,   0}, // #1074
  {25,  1,   0}, // #1075
  {30, 22,   0}, // #1076
  { 4,  4,   0}, // #1077
  { 5,  4,   0}, // #1078
  {30,  4,   0}, // #1079
  { 1,  2,   0}, // #1080
  { 2,  8,   0}, // #1081
  { 3, 12,   0}, // #1082
  { 4, 21,   0}, // #1083
  { 5, 21,   0}, // #1084
  { 6,  5,   0}, // #1085
  { 7, 14,   0}, // #1086
  { 8,  9,   0}, // #1087
  { 9,  4,   0}, // #1088
  {10,  7,   0}, // #1089
  {11,  7,   0}, // #1090
  {21,  3,   0}, // #1091
  {22,  3,   0}, // #1092
  {30, 21,   0}, // #1093
  { 1,  2,   0}, // #1094
  { 2,  4,   0}, // #1095
  { 3, 13,   0}, // #1096
  { 4, 34,   0}, // #1097
  { 5, 34,   0}, // #1098
  { 6, 11,   0}, // #1099
  { 7, 32,   0}, // #1100
  { 8, 23,   0}, // #1101
  { 9,  2,   0}, // #1102
  {10, 11,   0}, // #1103
  {11, 11,   0}, // #1104
  {15, 19,   0}, // #1105
  {17, 14,   0}, // #1106
  {20,  4,   0}, // #1107
  {21,  9,   0}, // #1108
  {22,  9,   0}, // #1109
  {25,  5,   0}, // #1110
  {30, 57,   0}, // #1111
  { 2,  1,   0}, // #1112
  { 3,  1,   0}, // #1113
  { 4,  3,   0}, // #1114
  { 5,  9,   0}, // #1115
  { 7,  2,   0}, // #1116
  { 8,  2,   0}, // #1117
  { 9,  1,   0}, // #1118
  {10,  1,   0}, // #1119
  {11,  1,   0}, // #1120
  {15,  1,   0}, // #1121
  {17,  1,   0}, // #1122
  {30, 10,   0}, // #1123
  { 3,  1,   0}, // #1124
  { 4, 10,   0}, // #1125
  { 5, 10,   0}, // #1126
  { 6,  1,   0}, // #1127
  { 7,  3,   0}, // #1128
  { 8,  2,   0}, // #1129
  {10,  1,   0}, // #1130
  {11,  1,   0}, // #1131
  {21,  1,   0}, // #1132
  {22,  1,   0}, // #1133
  {23,  2,   0}, // #1134
  {30, 10,   0}, // #1135
  { 1,  7,   0}, // #1136
  { 2, 24,   0}, // #1137
  { 3, 44,   0}, // #1138
  { 4, 70,   0}, // #1139
  { 5, 75,   0}, // #1140
  { 6, 26,   0}, // #1141
  { 7, 52,   0}, // #1142
  { 8, 32,   0}, // #1143
  { 9, 17,   0}, // #1144
  {10, 36,   0}, // #1145
  {11, 37,   0}, // #1146
  {15, 10,   0}, // #1147
  {17,  9,   0}, // #1148
  {20,  1,   0}, // #1149
  {21, 19,   0}, // #1150
  {22, 19,   0}, // #1151
  {25,  1,   0}, // #1152
  {30, 86,   0}, // #1153
  { 3,  9,   0}, // #1154
  { 4, 15,   0}, // #1155
  { 5, 15,   0}, // #1156
  { 6,  9,   0}, // #1157
  { 7,  9,   0}, // #1158
  {10,  6,   0}, // #1159
  {11,  6,   0}, // #1160
  {21,  6,   0}, // #1161
  {22,  6,   0}, // #1162
  {30, 15,   0}, // #1163
  { 1,  5,   0}, // #1164
  { 2, 20,   0}, // #1165
  { 3, 35,   0}, // #1166
  { 4, 61,   0}, // #1167
  { 5, 66,   0}, // #1168
  { 6, 20,   0}, // #1169
  { 7, 46,   0}, // #1170
  { 8, 31,   0}, // #1171
  { 9, 15,   0}, // #1172
  {10, 30,   0}, // #1173
  {11, 30,   0}, // #1174
  {15,  6,   0}, // #1175
  {17,  5,   0}, // #1176
  {20,  1,   0}, // #1177
  {21, 15,   0}, // #1178
  {22, 15,   0}, // #1179
  {25,  1,   0}, // #1180
  {30, 73,   0}, // #1181
  { 1,  5,   0}, // #1182
  { 2, 20,   0}, // #1183
  { 3, 36,   0}, // #1184
  { 4, 61,   0}, // #1185
  { 5, 66,   0}, // #1186
  { 6, 21,   0}, // #1187
  { 7, 46,   0}, // #1188
  { 8, 30,   0}, // #1189
  { 9, 15,   0}, // #1190
  {10, 30,   0}, // #1191
  {11, 30,   0}, // #1192
  {15,  6,   0}, // #1193
  {17,  5,   0}, // #1194
  {20,  1,   0}, // #1195
  {21, 15,   0}, // #1196
  {22, 15,   0}, // #1197
  {25,  1,   0}, // #1198
  {30, 73,   0}, // #1199
  { 1,  6,   0}, // #1200
  { 2, 23,   0}, // #1201
  { 3, 41,   0}, // #1202
  { 4, 68,   0}, // #1203
  { 5, 73,   0}, // #1204
  { 6, 24,   0}, // #1205
  { 7, 51,   0}, // #1206
  { 8, 33,   0}, // #1207
  { 9, 16,   0}, // #1208
  {10, 34,   0}, // #1209
  {11, 34,   0}, // #1210
  {15,  9,   0}, // #1211
  {17,  8,   0}, // #1212
  {20,  1,   0}, // #1213
  {21, 18,   0}, // #1214
  {22, 18,   0}, // #1215
  {25,  1,   0}, // #1216
  {30, 83,   0}, // #1217
  { 2,  9,   0}, // #1218
  { 3, 23,   0}, // #1219
  { 4, 53,   0}, // #1220
  { 5, 54,   0}, // #1221
  { 6,  3,   0}, // #1222
  { 7, 33,   0}, // #1223
  { 8, 20,   0}, // #1224
  { 9,  8,   0}, // #1225
  {10, 15,   0}, // #1226
  {11, 16,   0}, // #1227
  {21,  2,   0}, // #1228
  {22,  2,   0}, // #1229
  {30, 54,   0}, // #1230
  { 1,  7,   0}, // #1231
  { 2, 26,   0}, // #1232
  { 3, 46,   0}, // #1233
  { 4, 71,   0}, // #1234
  { 5, 79,   0}, // #1235
  { 6, 27,   0}, // #1236
  { 7, 52,   0}, // #1237
  { 8, 32,   0}, // #1238
  { 9, 19,   0}, // #1239
  {10, 39,   0}, // #1240
  {11, 41,   0}, // #1241
  {15,  8,   0}, // #1242
  {17,  8,   0}, // #1243
  {21, 20,   0}, // #1244
  {22, 20,   0}, // #1245
  {30, 87,   0}, // #1246
  { 1,  7,   0}, // #1247
  { 2, 26,   0}, // #1248
  { 3, 46,   0}, // #1249
  { 4, 71,   0}, // #1250
  { 5, 79,   0}, // #1251
  { 6, 27,   0}, // #1252
  { 7, 52,   0}, // #1253
  { 8, 32,   0}, // #1254
  { 9, 19,   0}, // #1255
  {10, 39,   0}, // #1256
  {11, 41,   0}, // #1257
  {15,  7,   0}, // #1258
  {17,  7,   0}, // #1259
  {21, 20,   0}, // #1260
  {22, 20,   0}, // #1261
  {30, 86,   0}, // #1262
  { 1,  2,   0}, // #1263
  { 2,  9,   0}, // #1264
  { 3, 14,   0}, // #1265
  { 4, 24,   0}, // #1266
  { 5, 24,   0}, // #1267
  { 6,  7,   0}, // #1268
  { 7, 17,   0}, // #1269
  { 8, 12,   0}, // #1270
  { 9,  6,   0}, // #1271
  {10, 11,   0}, // #1272
  {11, 11,   0}, // #1273
  {15,  1,   0}, // #1274
  {20,  1,   0}, // #1275
  {21,  5,   0}, // #1276
  {22,  5,   0}, // #1277
  {25,  1,   0}, // #1278
  {30, 26,   0}, // #1279
  { 1,  2,   0}, // #1280
  { 2, 12,   0}, // #1281
  { 3, 17,   0}, // #1282
  { 4, 27,   0}, // #1283
  { 5, 32,   0}, // #1284
  { 6,  7,   0}, // #1285
  { 7, 17,   0}, // #1286
  { 8, 12,   0}, // #1287
  { 9, 10,   0}, // #1288
  {10, 15,   0}, // #1289
  {11, 15,   0}, // #1290
  {15, 40,   0}, // #1291
  {17,  2,   0}, // #1292
  {20, 38,   0}, // #1293
  {21,  5,   0}, // #1294
  {22,  5,   0}, // #1295
  {25, 38,   0}, // #1296
  {30, 110,   0}, // #1297
  { 1,  4,   0}, // #1298
  { 2,  4,   0}, // #1299
  { 3,  6,   0}, // #1300
  { 4, 57,   0}, // #1301
  { 5, 57,   0}, // #1302
  { 6,  5,   0}, // #1303
  { 7,  9,   0}, // #1304
  { 8,  8,   0}, // #1305
  {10,  1,   0}, // #1306
  {11,  1,   0}, // #1307
  {13, 33,   0}, // #1308
  {14, 33,   0}, // #1309
  {15, 33,   0}, // #1310
  {16, 33,   0}, // #1311
  {17, 33,   0}, // #1312
  {23,  2,   0}, // #1313
  {30, 90,   0}, // #1314
  { 1,  8,   0}, // #1315
  { 2, 35,   0}, // #1316
  { 3, 79,   0}, // #1317
  { 4, 142,   0}, // #1318
  { 5, 142,   0}, // #1319
  { 6, 37,   0}, // #1320
  { 7, 100,   0}, // #1321
  { 8, 71,   0}, // #1322
  { 9, 21,   0}, // #1323
  {10, 46,   0}, // #1324
  {11, 46,   0}, // #1325
  {15,  1,   0}, // #1326
  {20,  1,   0}, // #1327
  {21, 10,   0}, // #1328
  {22, 10,   0}, // #1329
  {25,  1,   0}, // #1330
  {30, 144,   0}, // #1331
  { 1,  1,   0}, // #1332
  { 2,  1,   0}, // #1333
  { 3,  1,   0}, // #1334
  { 4,  2,   0}, // #1335
  { 5,  2,   0}, // #1336
  { 6,  1,   0}, // #1337
  { 7,  1,   0}, // #1338
  { 8,  1,   0}, // #1339
  {30,  2,   0}, // #1340
  { 3,  2,   0}, // #1341
  { 4,  2,   0}, // #1342
  { 5,  2,   0}, // #1343
  { 6,  1,   0}, // #1344
  { 7,  1,   0}, // #1345
  {30,  2,   0}, // #1346
  { 2,  1,   0}, // #1347
  { 3,  1,   0}, // #1348
  { 4,  1,   0}, // #1349
  { 5,  1,   0}, // #1350
  { 9,  1,   0}, // #1351
  {10,  1,   0}, // #1352
  {11,  1,   0}, // #1353
  {15,  1,   0}, // #1354
  {20,  1,   0}, // #1355
  {25,  1,   0}, // #1356
  {30,  3,   0}, // #1357
  { 2,  1,   0}, // #1358
  { 3,  1,   0}, // #1359
  { 4,  3,   0}, // #1360
  { 5,  3,   0}, // #1361
  { 7,  2,   0}, // #1362
  { 8,  2,   0}, // #1363
  { 9,  1,   0}, // #1364
  {10,  1,   0}, // #1365
  {11,  1,   0}, // #1366
  {30,  3,   0}, // #1367
  { 3,  1,   0}, // #1368
  { 4,  1,   0}, // #1369
  { 5,  1,   0}, // #1370
  { 6,  1,   0}, // #1371
  { 7,  1,   0}, // #1372
  {10,  1,   0}, // #1373
  {11,  1,   0}, // #1374
  {15,  1,   0}, // #1375
  {20,  1,   0}, // #1376
  {21,  1,   0}, // #1377
  {22,  1,   0}, // #1378
  {25,  1,   0}, // #1379
  {30,  3,   0}, // #1380
  { 5,  2,   0}, // #1381
  {15,  1,   0}, // #1382
  {20,  1,   0}, // #1383
  {25,  1,   0}, // #1384
  {30,  4,   0}, // #1385
  { 2,  1,   0}, // #1386
  { 3,  1,   0}, // #1387
  { 4,  2,   0}, // #1388
  { 5,  2,   0}, // #1389
  { 7,  1,   0}, // #1390
  { 8,  1,   0}, // #1391
  { 9,  1,   0}, // #1392
  {10,  1,   0}, // #1393
  {11,  1,   0}, // #1394
  {15,  1,   0}, // #1395
  {20,  1,   0}, // #1396
  {25,  1,   0}, // #1397
  {30,  4,   0}, // #1398
  { 1,  5,   0}, // #1399
  { 2, 13,   0}, // #1400
  { 3, 13,   0}, // #1401
  { 4, 13,   0}, // #1402
  { 5, 13,   0}, // #1403
  { 6,  5,   0}, // #1404
  { 7,  5,   0}, // #1405
  { 8,  5,   0}, // #1406
  { 9,  8,   0}, // #1407
  {10,  8,   0}, // #1408
  {11,  8,   0}, // #1409
  {15, 21,   0}, // #1410
  {17, 21,   0}, // #1411
  {30, 34,   0}, // #1412
  { 4,  1,   0}, // #1413
  { 5,  1,   0}, // #1414
  { 7,  1,   0}, // #1415
  { 8,  1,   0}, // #1416
  {13,  1,   0}, // #1417
  {14,  1,   0}, // #1418
  {15,  1,   0}, // #1419
  {16,  1,   0}, // #1420
  {17,  1,   0}, // #1421
  {23,  1,   0}, // #1422
  {30,  2,   0}, // #1423
  { 1,  1,   0}, // #1424
  { 2,  1,   0}, // #1425
  { 3,  1,   0}, // #1426
  { 4,  1,   0}, // #1427
  { 5,  1,   0}, // #1428
  { 6,  1,   0}, // #1429
  { 7,  1,   0}, // #1430
  { 8,  1,   0}, // #1431
  {14,  1,   0}, // #1432
  {15,  1,   0}, // #1433
  {19,  1,   0}, // #1434
  {20,  1,   0}, // #1435
  {30,  3,   0}, // #1436
  { 5,  5,   0}, // #1437
  {15,  2,   0}, // #1438
  {17,  2,   0}, // #1439
  {30,  7,   0}, // #1440
  { 5,  2,   0}, // #1441
  {15,  2,   0}, // #1442
  {17,  1,   0}, // #1443
  {20,  1,   0}, // #1444
  {25,  1,   0}, // #1445
  {30,  5,   0}, // #1446
  { 4,  2,   0}, // #1447
  { 5,  2,   0}, // #1448
  { 7,  1,   0}, // #1449
  { 8,  1,   0}, // #1450
  {13,  1,   0}, // #1451
  {14,  2,   0}, // #1452
  {15,  2,   0}, // #1453
  {16,  1,   0}, // #1454
  {17,  1,   0}, // #1455
  {19,  1,   0}, // #1456
  {20,  1,   0}, // #1457
  {23,  1,   0}, // #1458
  {30,  5,   0}, // #1459
  { 4,  1,   0}, // #1460
  { 5,  3,   0}, // #1461
  { 7,  1,   0}, // #1462
  { 8,  1,   0}, // #1463
  {15,  2,   0}, // #1464
  {17,  1,   0}, // #1465
  {20,  1,   0}, // #1466
  {25,  1,   0}, // #1467
  {30,  6,   0}, // #1468
  { 3,  2,   0}, // #1469
  { 4,  2,   0}, // #1470
  { 5,  2,   0}, // #1471
  { 6,  2,   0}, // #1472
  { 7,  2,   0}, // #1473
  {10,  2,   0}, // #1474
  {11,  2,   0}, // #1475
  {13,  1,   0}, // #1476
  {14,  1,   0}, // #1477
  {15,  1,   0}, // #1478
  {16,  1,   0}, // #1479
  {17,  1,   0}, // #1480
  {21,  2,   0}, // #1481
  {22,  2,   0}, // #1482
  {30,  3,   0}, // #1483
  { 1,  1,   0}, // #1484
  { 2,  1,   0}, // #1485
  { 3,  1,   0}, // #1486
  { 4,  1,   0}, // #1487
  { 5,  1,   0}, // #1488
  { 6,  1,   0}, // #1489
  { 7,  1,   0}, // #1490
  { 8,  1,   0}, // #1491
  {13,  1,   0}, // #1492
  {14,  1,   0}, // #1493
  {15,  1,   0}, // #1494
  {16,  1,   0}, // #1495
  {17,  1,   0}, // #1496
  {30,  2,   0}, // #1497
  { 1,  1,   0}, // #1498
  { 2,  1,   0}, // #1499
  { 3,  2,   0}, // #1500
  { 4,  2,   0}, // #1501
  { 5,  2,   0}, // #1502
  { 6,  2,   0}, // #1503
  { 7,  2,   0}, // #1504
  { 8,  1,   0}, // #1505
  {10,  1,   0}, // #1506
  {11,  1,   0}, // #1507
  {13,  1,   0}, // #1508
  {14,  1,   0}, // #1509
  {15,  1,   0}, // #1510
  {16,  1,   0}, // #1511
  {17,  1,   0}, // #1512
  {21,  1,   0}, // #1513
  {22,  1,   0}, // #1514
  {30,  3,   0}, // #1515
  { 2,  3,   0}, // #1516
  { 3,  4,   0}, // #1517
  { 4,  7,   0}, // #1518
  { 5, 10,   0}, // #1519
  { 7,  3,   0}, // #1520
  { 8,  3,   0}, // #1521
  { 9,  3,   0}, // #1522
  {10,  3,   0}, // #1523
  {11,  4,   0}, // #1524
  {30, 10,   0}, // #1525
  { 4,  2,   0}, // #1526
  { 5,  2,   0}, // #1527
  { 7,  2,   0}, // #1528
  { 8,  2,   0}, // #1529
  {15,  1,   0}, // #1530
  {17,  1,   0}, // #1531
  {30,  3,   0}, // #1532
  { 2,  2,   0}, // #1533
  { 3,  3,   0}, // #1534
  { 4,  9,   0}, // #1535
  { 5, 18,   0}, // #1536
  { 6,  1,   0}, // #1537
  { 7,  7,   0}, // #1538
  { 8,  6,   0}, // #1539
  { 9,  2,   0}, // #1540
  {10,  3,   0}, // #1541
  {11,  3,   0}, // #1542
  {21,  1,   0}, // #1543
  {22,  1,   0}, // #1544
  {30, 18,   0}, // #1545
  { 1,  2,   0}, // #1546
  { 2,  9,   0}, // #1547
  { 3, 14,   0}, // #1548
  { 4, 21,   0}, // #1549
  { 5, 24,   0}, // #1550
  { 6,  4,   0}, // #1551
  { 7, 11,   0}, // #1552
  { 8,  7,   0}, // #1553
  { 9,  7,   0}, // #1554
  {10, 12,   0}, // #1555
  {11, 12,   0}, // #1556
  {15,  1,   0}, // #1557
  {17,  1,   0}, // #1558
  {21,  2,   0}, // #1559
  {22,  2,   0}, // #1560
  {30, 25,   0}, // #1561
  { 2,  2,   0}, // #1562
  { 3,  2,   0}, // #1563
  { 4,  2,   0}, // #1564
  { 5,  3,   0}, // #1565
  { 9,  2,   0}, // #1566
  {10,  2,   0}, // #1567
  {11,  2,   0}, // #1568
  {15,  2,   0}, // #1569
  {20,  2,   0}, // #1570
  {25,  2,   0}, // #1571
  {30,  7,   0}, // #1572
  { 4,  1,   0}, // #1573
  { 5,  1,   0}, // #1574
  { 7,  1,   0}, // #1575
  { 8,  1,   0}, // #1576
  {15,  1,   0}, // #1577
  {20,  1,   0}, // #1578
  {25,  1,   0}, // #1579
  {30,  3,   0}, // #1580
  { 2,  5,   0}, // #1581
  { 3,  5,   0}, // #1582
  { 4, 16,   0}, // #1583
  { 5, 23,   0}, // #1584
  { 7, 11,   0}, // #1585
  { 8,  8,   0}, // #1586
  { 9,  5,   0}, // #1587
  {10,  5,   0}, // #1588
  {11,  5,   0}, // #1589
  {30, 23,   0}, // #1590
  { 3,  2,   0}, // #1591
  { 4,  2,   0}, // #1592
  { 5,  2,   0}, // #1593
  { 6,  2,   0}, // #1594
  { 7,  2,   0}, // #1595
  {10,  2,   0}, // #1596
  {11,  2,   0}, // #1597
  {15,  1,   0}, // #1598
  {17,  1,   0}, // #1599
  {21,  2,   0}, // #1600
  {22,  2,   0}, // #1601
  {30,  3,   0}, // #1602
  { 3,  2,   0}, // #1603
  { 4,  2,   0}, // #1604
  { 5,  2,   0}, // #1605
  { 6,  2,   0}, // #1606
  { 7,  2,   0}, // #1607
  {10,  2,   0}, // #1608
  {11,  2,   0}, // #1609
  {21,  2,   0}, // #1610
  {22,  2,   0}, // #1611
  {30,  2,   0}, // #1612
  { 1,  1,   0}, // #1613
  { 2,  6,   0}, // #1614
  { 3,  8,   0}, // #1615
  { 4, 17,   0}, // #1616
  { 5, 20,   0}, // #1617
  { 6,  2,   0}, // #1618
  { 7, 11,   0}, // #1619
  { 8,  9,   0}, // #1620
  { 9,  5,   0}, // #1621
  {10,  7,   0}, // #1622
  {11,  7,   0}, // #1623
  {15,  2,   0}, // #1624
  {17,  2,   0}, // #1625
  {21,  1,   0}, // #1626
  {22,  1,   0}, // #1627
  {30, 22,   0}, // #1628
  { 1,  1,   0}, // #1629
  { 2,  4,   0}, // #1630
  { 3,  5,   0}, // #1631
  { 4, 10,   0}, // #1632
  { 5, 10,   0}, // #1633
  { 6,  2,   0}, // #1634
  { 7,  7,   0}, // #1635
  { 8,  6,   0}, // #1636
  { 9,  3,   0}, // #1637
  {10,  4,   0}, // #1638
  {11,  4,   0}, // #1639
  {15,  3,   0}, // #1640
  {17,  3,   0}, // #1641
  {21,  1,   0}, // #1642
  {22,  1,   0}, // #1643
  {30, 13,   0}, // #1644
  { 2,  8,   0}, // #1645
  { 3, 14,   0}, // #1646
  { 4, 30,   0}, // #1647
  { 5, 54,   0}, // #1648
  { 6,  2,   0}, // #1649
  { 7, 18,   0}, // #1650
  { 8, 14,   0}, // #1651
  { 9,  8,   0}, // #1652
  {10, 10,   0}, // #1653
  {11, 11,   0}, // #1654
  {21,  2,   0}, // #1655
  {22,  2,   0}, // #1656
  {30, 54,   0}, // #1657
  { 2,  3,   0}, // #1658
  { 3,  3,   0}, // #1659
  { 4,  7,   0}, // #1660
  { 5, 10,   0}, // #1661
  { 7,  4,   0}, // #1662
  { 8,  4,   0}, // #1663
  { 9,  3,   0}, // #1664
  {10,  3,   0}, // #1665
  {11,  3,   0}, // #1666
  {30, 10,   0}, // #1667
  { 2,  3,   0}, // #1668
  { 3,  4,   0}, // #1669
  { 4, 10,   0}, // #1670
  { 5, 15,   0}, // #1671
  { 6,  1,   0}, // #1672
  { 7,  7,   0}, // #1673
  { 8,  6,   0}, // #1674
  { 9,  3,   0}, // #1675
  {10,  4,   0}, // #1676
  {11,  4,   0}, // #1677
  {21,  1,   0}, // #1678
  {22,  1,   0}, // #1679
  {30, 15,   0}, // #1680
  { 2,  1,   0}, // #1681
  { 3,  1,   0}, // #1682
  { 4, 30,   0}, // #1683
  { 5, 30,   0}, // #1684
  { 7,  8,   0}, // #1685
  { 8,  8,   0}, // #1686
  { 9,  1,   0}, // #1687
  {10,  1,   0}, // #1688
  {11,  1,   0}, // #1689
  {13,  1,   0}, // #1690
  {14,  1,   0}, // #1691
  {15,  1,   0}, // #1692
  {16,  1,   0}, // #1693
  {17,  1,   0}, // #1694
  {23,  8,   0}, // #1695
  {30, 31,   0}, // #1696
  { 2, 35,   0}, // #1697
  { 3, 90,   0}, // #1698
  { 4, 134,   0}, // #1699
  { 5, 134,   0}, // #1700
  { 6, 34,   0}, // #1701
  { 7, 78,   0}, // #1702
  { 8, 44,   0}, // #1703
  { 9, 21,   0}, // #1704
  {10, 51,   0}, // #1705
  {11, 51,   0}, // #1706
  {15,  5,   0}, // #1707
  {17,  4,   0}, // #1708
  {20,  1,   0}, // #1709
  {21,  9,   0}, // #1710
  {22,  9,   0}, // #1711
  {25,  1,   0}, // #1712
  {30, 140,   0}, // #1713
  { 2, 52,   0}, // #1714
  { 3, 97,   0}, // #1715
  { 4, 150,   0}, // #1716
  { 5, 150,   0}, // #1717
  { 6, 45,   0}, // #1718
  { 7, 98,   0}, // #1719
  { 8, 53,   0}, // #1720
  { 9, 27,   0}, // #1721
  {10, 37,   0}, // #1722
  {11, 37,   0}, // #1723
  {15,  5,   0}, // #1724
  {17,  4,   0}, // #1725
  {20,  1,   0}, // #1726
  {21, 10,   0}, // #1727
  {22, 10,   0}, // #1728
  {25,  1,   0}, // #1729
  {30, 156,   0}, // #1730
  { 2,  1,   0}, // #1731
  { 3,  4,   0}, // #1732
  { 4, 15,   0}, // #1733
  { 5, 15,   0}, // #1734
  { 6,  2,   0}, // #1735
  { 7,  5,   0}, // #1736
  { 8,  3,   0}, // #1737
  { 9,  1,   0}, // #1738
  {10,  4,   0}, // #1739
  {11,  4,   0}, // #1740
  {13,  1,   0}, // #1741
  {14,  2,   0}, // #1742
  {15,  2,   0}, // #1743
  {16,  1,   0}, // #1744
  {17,  1,   0}, // #1745
  {19,  1,   0}, // #1746
  {20,  1,   0}, // #1747
  {21,  2,   0}, // #1748
  {22,  2,   0}, // #1749
  {23,  3,   0}, // #1750
  {30, 18,   0}, // #1751
  { 1,  2,   0}, // #1752
  { 2,  2,   0}, // #1753
  { 3,  7,   0}, // #1754
  { 4, 56,   0}, // #1755
  { 5, 56,   0}, // #1756
  { 6,  7,   0}, // #1757
  { 7, 17,   0}, // #1758
  { 8, 12,   0}, // #1759
  {13,  8,   0}, // #1760
  {14,  8,   0}, // #1761
  {15,  8,   0}, // #1762
  {16,  8,   0}, // #1763
  {17,  8,   0}, // #1764
  {30, 64,   0}, // #1765
  { 1,  4,   0}, // #1766
  { 2,  4,   0}, // #1767
  { 3,  6,   0}, // #1768
  { 4, 57,   0}, // #1769
  { 5, 57,   0}, // #1770
  { 6,  5,   0}, // #1771
  { 7, 11,   0}, // #1772
  { 8, 10,   0}, // #1773
  {10,  1,   0}, // #1774
  {11,  1,   0}, // #1775
  {13, 31,   0}, // #1776
  {14, 31,   0}, // #1777
  {15, 31,   0}, // #1778
  {16, 31,   0}, // #1779
  {17, 31,   0}, // #1780
  {23,  4,   0}, // #1781
  {30, 88,   0}, // #1782
  { 1,  9,   0}, // #1783
  { 2, 10,   0}, // #1784
  { 3, 26,   0}, // #1785
  { 4, 78,   0}, // #1786
  { 5, 78,   0}, // #1787
  { 6, 25,   0}, // #1788
  { 7, 47,   0}, // #1789
  { 8, 31,   0}, // #1790
  { 9,  1,   0}, // #1791
  {10, 17,   0}, // #1792
  {11, 17,   0}, // #1793
  {14, 11,   0}, // #1794
  {15, 11,   0}, // #1795
  {19, 11,   0}, // #1796
  {20, 11,   0}, // #1797
  {21, 16,   0}, // #1798
  {22, 16,   0}, // #1799
  {23,  1,   0}, // #1800
  {30, 100,   0}, // #1801
  { 1,  1,   0}, // #1802
  { 2,  1,   0}, // #1803
  { 3,  3,   0}, // #1804
  { 4,  3,   0}, // #1805
  { 5,  3,   0}, // #1806
  { 6,  1,   0}, // #1807
  { 7,  1,   0}, // #1808
  { 8,  1,   0}, // #1809
  {10,  1,   0}, // #1810
  {11,  1,   0}, // #1811
  {15,  2,   0}, // #1812
  {17,  2,   0}, // #1813
  {30,  5,   0}, // #1814
  { 1,  1,   0}, // #1815
  { 2,  1,   0}, // #1816
  { 3,  4,   0}, // #1817
  { 4,  4,   0}, // #1818
  { 5,  4,   0}, // #1819
  { 6,  1,   0}, // #1820
  { 7,  1,   0}, // #1821
  { 8,  1,   0}, // #1822
  {10,  2,   0}, // #1823
  {11,  2,   0}, // #1824
  {15,  4,   0}, // #1825
  {17,  4,   0}, // #1826
  {30,  8,   0}, // #1827
  { 1,  1,   0}, // #1828
  { 2,  1,   0}, // #1829
  { 3,  4,   0}, // #1830
  { 4,  4,   0}, // #1831
  { 5,  4,   0}, // #1832
  { 6,  1,   0}, // #1833
  { 7,  1,   0}, // #1834
  { 8,  1,   0}, // #1835
  {10,  2,   0}, // #1836
  {11,  2,   0}, // #1837
  {15,  8,   0}, // #1838
  {17,  8,   0}, // #1839
  {30, 12,   0}, // #1840
  { 4,  2,   0}, // #1841
  { 5,  2,   0}, // #1842
  { 7,  1,   0}, // #1843
  { 8,  1,   0}, // #1844
  {13,  1,   0}, // #1845
  {14,  1,   0}, // #1846
  {15,  1,   0}, // #1847
  {16,  1,   0}, // #1848
  {17,  1,   0}, // #1849
  {23,  1,   0}, // #1850
  {30,  3,   0}, // #1851
  { 2,  1,   0}, // #1852
  { 3,  1,   0}, // #1853
  { 4,  3,   0}, // #1854
  { 5,  3,   0}, // #1855
  { 7,  2,   0}, // #1856
  { 8,  2,   0}, // #1857
  { 9,  1,   0}, // #1858
  {10,  1,   0}, // #1859
  {11,  1,   0}, // #1860
  {15,  1,   0}, // #1861
  {17,  1,   0}, // #1862
  {30,  4,   0}, // #1863
  { 1,  2,   0}, // #1864
  { 2,  2,   0}, // #1865
  { 3,  2,   0}, // #1866
  { 4,  2,   0}, // #1867
  { 5,  2,   0}, // #1868
  { 6,  2,   0}, // #1869
  { 7,  2,   0}, // #1870
  { 8,  2,   0}, // #1871
  {15,  1,   0}, // #1872
  {20,  1,   0}, // #1873
  {25,  1,   0}, // #1874
  {30,  4,   0}, // #1875
  { 2,  3,   0}, // #1876
  { 3,  6,   0}, // #1877
  { 4,  7,   0}, // #1878
  { 5,  7,   0}, // #1879
  { 6,  1,   0}, // #1880
  { 7,  2,   0}, // #1881
  { 8,  1,   0}, // #1882
  {10,  1,   0}, // #1883
  {11,  1,   0}, // #1884
  {21,  1,   0}, // #1885
  {22,  1,   0}, // #1886
  {30,  7,   0}, // #1887
  { 2,  3,   0}, // #1888
  { 3,  6,   0}, // #1889
  { 4,  7,   0}, // #1890
  { 5,  7,   0}, // #1891
  { 6,  1,   0}, // #1892
  { 7,  2,   0}, // #1893
  { 8,  1,   0}, // #1894
  {10,  1,   0}, // #1895
  {11,  1,   0}, // #1896
  {15,  1,   0}, // #1897
  {17,  1,   0}, // #1898
  {21,  1,   0}, // #1899
  {22,  1,   0}, // #1900
  {30,  8,   0}, // #1901
  { 2,  2,   0}, // #1902
  { 3,  6,   0}, // #1903
  { 4,  7,   0}, // #1904
  { 5,  7,   0}, // #1905
  { 7,  1,   0}, // #1906
  { 8,  1,   0}, // #1907
  {10,  2,   0}, // #1908
  {11,  2,   0}, // #1909
  {30,  7,   0}, // #1910
  { 2,  2,   0}, // #1911
  { 3,  6,   0}, // #1912
  { 4,  7,   0}, // #1913
  { 5,  7,   0}, // #1914
  { 7,  1,   0}, // #1915
  { 8,  1,   0}, // #1916
  {10,  2,   0}, // #1917
  {11,  2,   0}, // #1918
  {15,  1,   0}, // #1919
  {17,  1,   0}, // #1920
  {30,  8,   0}, // #1921
  { 2,  1,   0}, // #1922
  { 3,  3,   0}, // #1923
  { 4,  3,   0}, // #1924
  { 5,  3,   0}, // #1925
  {10,  1,   0}, // #1926
  {11,  1,   0}, // #1927
  {30,  3,   0}, // #1928
  { 2,  1,   0}, // #1929
  { 3,  3,   0}, // #1930
  { 4,  3,   0}, // #1931
  { 5,  3,   0}, // #1932
  {10,  1,   0}, // #1933
  {11,  1,   0}, // #1934
  {15,  1,   0}, // #1935
  {17,  1,   0}, // #1936
  {30,  4,   0}, // #1937
  { 4,  1,   0}, // #1938
  { 5,  2,   0}, // #1939
  { 7,  1,   0}, // #1940
  { 8,  1,   0}, // #1941
  {15,  1,   0}, // #1942
  {17,  1,   0}, // #1943
  {30,  3,   0}, // #1944
  { 4,  1,   0}, // #1945
  { 5,  5,   0}, // #1946
  { 7,  1,   0}, // #1947
  { 8,  1,   0}, // #1948
  {15,  2,   0}, // #1949
  {17,  1,   0}, // #1950
  {20,  1,   0}, // #1951
  {25,  1,   0}, // #1952
  {30,  8,   0}, // #1953
  { 2,  2,   0}, // #1954
  { 3,  2,   0}, // #1955
  { 4,  5,   0}, // #1956
  { 5,  7,   0}, // #1957
  { 7,  3,   0}, // #1958
  { 8,  3,   0}, // #1959
  { 9,  2,   0}, // #1960
  {10,  2,   0}, // #1961
  {11,  2,   0}, // #1962
  {30,  7,   0}, // #1963
  { 1,  1,   0}, // #1964
  { 2,  4,   0}, // #1965
  { 3,  5,   0}, // #1966
  { 4,  9,   0}, // #1967
  { 5, 13,   0}, // #1968
  { 6,  2,   0}, // #1969
  { 7,  6,   0}, // #1970
  { 8,  5,   0}, // #1971
  { 9,  3,   0}, // #1972
  {10,  4,   0}, // #1973
  {11,  4,   0}, // #1974
  {15,  2,   0}, // #1975
  {17,  2,   0}, // #1976
  {21,  1,   0}, // #1977
  {22,  1,   0}, // #1978
  {30, 15,   0}, // #1979
  { 1,  1,   0}, // #1980
  { 2,  1,   0}, // #1981
  { 3,  3,   0}, // #1982
  { 4,  3,   0}, // #1983
  { 5,  3,   0}, // #1984
  { 6,  3,   0}, // #1985
  { 7,  3,   0}, // #1986
  { 8,  1,   0}, // #1987
  {10,  2,   0}, // #1988
  {11,  2,   0}, // #1989
  {21,  2,   0}, // #1990
  {22,  2,   0}, // #1991
  {30,  3,   0}, // #1992
  { 2,  1,   0}, // #1993
  { 3,  3,   0}, // #1994
  { 4,  3,   0}, // #1995
  { 5,  3,   0}, // #1996
  {10,  2,   0}, // #1997
  {11,  2,   0}, // #1998
  {30,  3,   0}, // #1999
  { 1,  1,   0}, // #2000
  { 2,  1,   0}, // #2001
  { 3,  3,   0}, // #2002
  { 4,  3,   0}, // #2003
  { 5,  3,   0}, // #2004
  { 6,  3,   0}, // #2005
  { 7,  3,   0}, // #2006
  { 8,  1,   0}, // #2007
  {10,  2,   0}, // #2008
  {11,  2,   0}, // #2009
  {15,  1,   0}, // #2010
  {17,  1,   0}, // #2011
  {21,  2,   0}, // #2012
  {22,  2,   0}, // #2013
  {30,  4,   0}, // #2014
  { 2,  1,   0}, // #2015
  { 3,  3,   0}, // #2016
  { 4,  3,   0}, // #2017
  { 5,  3,   0}, // #2018
  {10,  2,   0}, // #2019
  {11,  2,   0}, // #2020
  {15,  1,   0}, // #2021
  {17,  1,   0}, // #2022
  {30,  4,   0}, // #2023
  { 2, 52,   0}, // #2024
  { 3, 125,   0}, // #2025
  { 4, 178,   0}, // #2026
  { 5, 178,   0}, // #2027
  { 6, 41,   0}, // #2028
  { 7, 94,   0}, // #2029
  { 8, 53,   0}, // #2030
  { 9, 29,   0}, // #2031
  {10, 69,   0}, // #2032
  {11, 69,   0}, // #2033
  {15,  6,   0}, // #2034
  {17,  4,   0}, // #2035
  {20,  2,   0}, // #2036
  {21,  8,   0}, // #2037
  {22,  8,   0}, // #2038
  {25,  2,   0}, // #2039
  {30, 186,   0}, // #2040
  { 4,  1,   0}, // #2041
  { 5,  1,   0}, // #2042
  {13,  1,   0}, // #2043
  {14,  2,   0}, // #2044
  {15,  2,   0}, // #2045
  {16,  1,   0}, // #2046
  {17,  1,   0}, // #2047
  {19,  1,   0}, // #2048
  {20,  1,   0}, // #2049
  {30,  4,   0}, // #2050
  { 2,  1,   0}, // #2051
  { 3,  1,   0}, // #2052
  { 4,  3,   0}, // #2053
  { 5,  8,   0}, // #2054
  { 7,  2,   0}, // #2055
  { 8,  2,   0}, // #2056
  { 9,  1,   0}, // #2057
  {10,  1,   0}, // #2058
  {11,  1,   0}, // #2059
  {15,  1,   0}, // #2060
  {17,  1,   0}, // #2061
  {30,  9,   0}, // #2062
  { 2,  1,   0}, // #2063
  { 3,  1,   0}, // #2064
  { 4,  3,   0}, // #2065
  { 5,  7,   0}, // #2066
  { 7,  2,   0}, // #2067
  { 8,  2,   0}, // #2068
  { 9,  1,   0}, // #2069
  {10,  1,   0}, // #2070
  {11,  1,   0}, // #2071
  {15,  2,   0}, // #2072
  {17,  1,   0}, // #2073
  {20,  1,   0}, // #2074
  {25,  1,   0}, // #2075
  {30, 10,   0}, // #2076
  { 4,  1,   0}, // #2077
  { 5,  2,   0}, // #2078
  { 7,  1,   0}, // #2079
  { 8,  1,   0}, // #2080
  {15,  1,   0}, // #2081
  {20,  1,   0}, // #2082
  {25,  1,   0}, // #2083
  {30,  4,   0}, // #2084
  { 2,  1,   0}, // #2085
  { 3,  4,   0}, // #2086
  { 4, 10,   0}, // #2087
  { 5, 10,   0}, // #2088
  { 6,  3,   0}, // #2089
  { 7,  9,   0}, // #2090
  { 8,  6,   0}, // #2091
  { 9,  1,   0}, // #2092
  {10,  4,   0}, // #2093
  {11,  4,   0}, // #2094
  {21,  3,   0}, // #2095
  {22,  3,   0}, // #2096
  {30, 10,   0}, // #2097
  { 1,  7,   0}, // #2098
  { 2, 26,   0}, // #2099
  { 3, 47,   0}, // #2100
  { 4, 73,   0}, // #2101
  { 5, 80,   0}, // #2102
  { 6, 28,   0}, // #2103
  { 7, 54,   0}, // #2104
  { 8, 33,   0}, // #2105
  { 9, 19,   0}, // #2106
  {10, 40,   0}, // #2107
  {11, 42,   0}, // #2108
  {15,  7,   0}, // #2109
  {17,  7,   0}, // #2110
  {21, 21,   0}, // #2111
  {22, 21,   0}, // #2112
  {30, 87,   0}, // #2113
  { 1,  7,   0}, // #2114
  { 2, 27,   0}, // #2115
  { 3, 47,   0}, // #2116
  { 4, 73,   0}, // #2117
  { 5, 80,   0}, // #2118
  { 6, 27,   0}, // #2119
  { 7, 53,   0}, // #2120
  { 8, 33,   0}, // #2121
  { 9, 19,   0}, // #2122
  {10, 39,   0}, // #2123
  {11, 42,   0}, // #2124
  {15,  7,   0}, // #2125
  {17,  7,   0}, // #2126
  {21, 20,   0}, // #2127
  {22, 20,   0}, // #2128
  {30, 87,   0}, // #2129
  { 1,  7,   0}, // #2130
  { 2, 28,   0}, // #2131
  { 3, 48,   0}, // #2132
  { 4, 76,   0}, // #2133
  { 5, 84,   0}, // #2134
  { 6, 27,   0}, // #2135
  { 7, 55,   0}, // #2136
  { 8, 35,   0}, // #2137
  { 9, 21,   0}, // #2138
  {10, 41,   0}, // #2139
  {11, 43,   0}, // #2140
  {15, 10,   0}, // #2141
  {17, 10,   0}, // #2142
  {21, 20,   0}, // #2143
  {22, 20,   0}, // #2144
  {30, 94,   0}, // #2145
  { 1,  7,   0}, // #2146
  { 2, 28,   0}, // #2147
  { 3, 49,   0}, // #2148
  { 4, 77,   0}, // #2149
  { 5, 88,   0}, // #2150
  { 6, 28,   0}, // #2151
  { 7, 56,   0}, // #2152
  { 8, 35,   0}, // #2153
  { 9, 21,   0}, // #2154
  {10, 42,   0}, // #2155
  {11, 44,   0}, // #2156
  {15, 11,   0}, // #2157
  {17, 11,   0}, // #2158
  {21, 21,   0}, // #2159
  {22, 21,   0}, // #2160
  {30, 99,   0}, // #2161
  { 1,  7,   0}, // #2162
  { 2, 24,   0}, // #2163
  { 3, 43,   0}, // #2164
  { 4, 67,   0}, // #2165
  { 5, 73,   0}, // #2166
  { 6, 26,   0}, // #2167
  { 7, 50,   0}, // #2168
  { 8, 31,   0}, // #2169
  { 9, 17,   0}, // #2170
  {10, 36,   0}, // #2171
  {11, 36,   0}, // #2172
  {15,  9,   0}, // #2173
  {17,  8,   0}, // #2174
  {20,  1,   0}, // #2175
  {21, 19,   0}, // #2176
  {22, 19,   0}, // #2177
  {25,  1,   0}, // #2178
  {30, 83,   0}, // #2179
  { 1,  7,   0}, // #2180
  { 2, 24,   0}, // #2181
  { 3, 46,   0}, // #2182
  { 4, 74,   0}, // #2183
  { 5, 79,   0}, // #2184
  { 6, 28,   0}, // #2185
  { 7, 56,   0}, // #2186
  { 8, 34,   0}, // #2187
  { 9, 17,   0}, // #2188
  {10, 38,   0}, // #2189
  {11, 38,   0}, // #2190
  {15, 12,   0}, // #2191
  {17, 11,   0}, // #2192
  {20,  1,   0}, // #2193
  {21, 21,   0}, // #2194
  {22, 21,   0}, // #2195
  {25,  1,   0}, // #2196
  {30, 92,   0}, // #2197
  { 1,  5,   0}, // #2198
  { 2, 11,   0}, // #2199
  { 3, 18,   0}, // #2200
  { 4, 26,   0}, // #2201
  { 5, 32,   0}, // #2202
  { 6, 12,   0}, // #2203
  { 7, 20,   0}, // #2204
  { 8, 13,   0}, // #2205
  { 9,  6,   0}, // #2206
  {10, 13,   0}, // #2207
  {11, 15,   0}, // #2208
  {15,  5,   0}, // #2209
  {20,  5,   0}, // #2210
  {21,  7,   0}, // #2211
  {22,  7,   0}, // #2212
  {25,  5,   0}, // #2213
  {30, 42,   0}, // #2214
  { 4,  1,   0}, // #2215
  { 5,  1,   0}, // #2216
  { 7,  1,   0}, // #2217
  { 8,  1,   0}, // #2218
  {23,  1,   0}, // #2219
  {30,  1,   0}, // #2220
  { 1,  8,   0}, // #2221
  { 2, 22,   0}, // #2222
  { 3, 23,   0}, // #2223
  { 4, 25,   0}, // #2224
  { 5, 25,   0}, // #2225
  { 6,  9,   0}, // #2226
  { 7, 11,   0}, // #2227
  { 8, 10,   0}, // #2228
  { 9, 14,   0}, // #2229
  {10, 15,   0}, // #2230
  {11, 15,   0}, // #2231
  {15,  3,   0}, // #2232
  {17,  3,   0}, // #2233
  {21,  1,   0}, // #2234
  {22,  1,   0}, // #2235
  {30, 28,   0}, // #2236
  { 1,  1,   0}, // #2237
  { 2,  6,   0}, // #2238
  { 3,  9,   0}, // #2239
  { 4, 18,   0}, // #2240
  { 5, 20,   0}, // #2241
  { 6,  4,   0}, // #2242
  { 7, 13,   0}, // #2243
  { 8, 10,   0}, // #2244
  { 9,  5,   0}, // #2245
  {10,  6,   0}, // #2246
  {11,  6,   0}, // #2247
  {15,  3,   0}, // #2248
  {17,  3,   0}, // #2249
  {21,  1,   0}, // #2250
  {22,  1,   0}, // #2251
  {30, 23,   0}, // #2252
  { 1,  1,   0}, // #2253
  { 2,  4,   0}, // #2254
  { 3,  4,   0}, // #2255
  { 4,  8,   0}, // #2256
  { 5, 10,   0}, // #2257
  { 6,  1,   0}, // #2258
  { 7,  5,   0}, // #2259
  { 8,  5,   0}, // #2260
  { 9,  3,   0}, // #2261
  {10,  3,   0}, // #2262
  {11,  3,   0}, // #2263
  {15,  3,   0}, // #2264
  {17,  2,   0}, // #2265
  {20,  1,   0}, // #2266
  {25,  1,   0}, // #2267
  {30, 14,   0}, // #2268
  { 2,  3,   0}, // #2269
  { 3,  4,   0}, // #2270
  { 4,  9,   0}, // #2271
  { 5, 10,   0}, // #2272
  { 6,  1,   0}, // #2273
  { 7,  6,   0}, // #2274
  { 8,  5,   0}, // #2275
  { 9,  3,   0}, // #2276
  {10,  3,   0}, // #2277
  {11,  3,   0}, // #2278
  {15,  3,   0}, // #2279
  {17,  2,   0}, // #2280
  {20,  1,   0}, // #2281
  {25,  1,   0}, // #2282
  {30, 14,   0}, // #2283
  { 2,  3,   0}, // #2284
  { 3,  3,   0}, // #2285
  { 4,  8,   0}, // #2286
  { 5,  8,   0}, // #2287
  { 7,  5,   0}, // #2288
  { 8,  5,   0}, // #2289
  { 9,  3,   0}, // #2290
  {10,  3,   0}, // #2291
  {11,  3,   0}, // #2292
  {15,  3,   0}, // #2293
  {17,  2,   0}, // #2294
  {20,  1,   0}, // #2295
  {25,  1,   0}, // #2296
  {30, 12,   0}, // #2297
  { 2,  3,   0}, // #2298
  { 3,  3,   0}, // #2299
  { 4,  7,   0}, // #2300
  { 5,  8,   0}, // #2301
  { 7,  4,   0}, // #2302
  { 8,  4,   0}, // #2303
  { 9,  3,   0}, // #2304
  {10,  3,   0}, // #2305
  {11,  3,   0}, // #2306
  {15,  2,   0}, // #2307
  {17,  1,   0}, // #2308
  {20,  1,   0}, // #2309
  {25,  1,   0}, // #2310
  {30, 11,   0}, // #2311
  { 1,  1,   0}, // #2312
  { 2,  4,   0}, // #2313
  { 3, 12,   0}, // #2314
  { 4, 20,   0}, // #2315
  { 5, 22,   0}, // #2316
  { 6,  8,   0}, // #2317
  { 7, 16,   0}, // #2318
  { 8,  9,   0}, // #2319
  { 9,  3,   0}, // #2320
  {10, 10,   0}, // #2321
  {11, 10,   0}, // #2322
  {15,  3,   0}, // #2323
  {17,  1,   0}, // #2324
  {20,  2,   0}, // #2325
  {21,  7,   0}, // #2326
  {22,  7,   0}, // #2327
  {25,  2,   0}, // #2328
  {30, 27,   0}, // #2329
  { 2,  1,   0}, // #2330
  { 3,  6,   0}, // #2331
  { 4, 13,   0}, // #2332
  { 5, 18,   0}, // #2333
  { 6,  5,   0}, // #2334
  { 7, 12,   0}, // #2335
  { 8,  7,   0}, // #2336
  { 9,  1,   0}, // #2337
  {10,  6,   0}, // #2338
  {11,  6,   0}, // #2339
  {15,  2,   0}, // #2340
  {20,  2,   0}, // #2341
  {21,  5,   0}, // #2342
  {22,  5,   0}, // #2343
  {25,  2,   0}, // #2344
  {30, 22,   0}, // #2345
  { 2,  8,   0}, // #2346
  { 3, 22,   0}, // #2347
  { 4, 38,   0}, // #2348
  { 5, 44,   0}, // #2349
  { 6, 12,   0}, // #2350
  { 7, 28,   0}, // #2351
  { 8, 16,   0}, // #2352
  { 9,  7,   0}, // #2353
  {10, 19,   0}, // #2354
  {11, 21,   0}, // #2355
  {15,  2,   0}, // #2356
  {20,  2,   0}, // #2357
  {21, 12,   0}, // #2358
  {22, 12,   0}, // #2359
  {25,  2,   0}, // #2360
  {30, 48,   0}, // #2361
  { 3,  1,   0}, // #2362
  { 4,  2,   0}, // #2363
  { 5,  3,   0}, // #2364
  { 6,  1,   0}, // #2365
  { 7,  2,   0}, // #2366
  { 8,  1,   0}, // #2367
  {10,  1,   0}, // #2368
  {11,  1,   0}, // #2369
  {21,  1,   0}, // #2370
  {22,  1,   0}, // #2371
  {30,  3,   0}, // #2372
  { 2,  4,   0}, // #2373
  { 3, 10,   0}, // #2374
  { 4, 18,   0}, // #2375
  { 5, 24,   0}, // #2376
  { 6,  3,   0}, // #2377
  { 7, 11,   0}, // #2378
  { 8,  8,   0}, // #2379
  { 9,  4,   0}, // #2380
  {10,  7,   0}, // #2381
  {11,  9,   0}, // #2382
  {21,  3,   0}, // #2383
  {22,  3,   0}, // #2384
  {30, 24,   0}, // #2385
  { 1,  6,   0}, // #2386
  { 2, 21,   0}, // #2387
  { 3, 38,   0}, // #2388
  { 4, 66,   0}, // #2389
  { 5, 70,   0}, // #2390
  { 6, 23,   0}, // #2391
  { 7, 51,   0}, // #2392
  { 8, 34,   0}, // #2393
  { 9, 15,   0}, // #2394
  {10, 31,   0}, // #2395
  {11, 31,   0}, // #2396
  {15,  8,   0}, // #2397
  {17,  7,   0}, // #2398
  {20,  1,   0}, // #2399
  {21, 16,   0}, // #2400
  {22, 16,   0}, // #2401
  {25,  1,   0}, // #2402
  {30, 79,   0}, // #2403
  { 1,  6,   0}, // #2404
  { 2, 21,   0}, // #2405
  { 3, 37,   0}, // #2406
  { 4, 64,   0}, // #2407
  { 5, 70,   0}, // #2408
  { 6, 22,   0}, // #2409
  { 7, 49,   0}, // #2410
  { 8, 33,   0}, // #2411
  { 9, 15,   0}, // #2412
  {10, 31,   0}, // #2413
  {11, 31,   0}, // #2414
  {15,  8,   0}, // #2415
  {17,  7,   0}, // #2416
  {20,  1,   0}, // #2417
  {21, 16,   0}, // #2418
  {22, 16,   0}, // #2419
  {25,  1,   0}, // #2420
  {30, 79,   0}, // #2421
  { 1,  6,   0}, // #2422
  { 2, 21,   0}, // #2423
  { 3, 40,   0}, // #2424
  { 4, 70,   0}, // #2425
  { 5, 74,   0}, // #2426
  { 6, 25,   0}, // #2427
  { 7, 55,   0}, // #2428
  { 8, 36,   0}, // #2429
  { 9, 15,   0}, // #2430
  {10, 33,   0}, // #2431
  {11, 33,   0}, // #2432
  {15, 10,   0}, // #2433
  {17,  9,   0}, // #2434
  {20,  1,   0}, // #2435
  {21, 18,   0}, // #2436
  {22, 18,   0}, // #2437
  {25,  1,   0}, // #2438
  {30, 85,   0}, // #2439
  { 1,  6,   0}, // #2440
  { 2, 21,   0}, // #2441
  { 3, 39,   0}, // #2442
  { 4, 68,   0}, // #2443
  { 5, 74,   0}, // #2444
  { 6, 24,   0}, // #2445
  { 7, 53,   0}, // #2446
  { 8, 35,   0}, // #2447
  { 9, 15,   0}, // #2448
  {10, 33,   0}, // #2449
  {11, 33,   0}, // #2450
  {15, 10,   0}, // #2451
  {17,  9,   0}, // #2452
  {20,  1,   0}, // #2453
  {21, 18,   0}, // #2454
  {22, 18,   0}, // #2455
  {25,  1,   0}, // #2456
  {30, 85,   0}, // #2457
  { 1,  7,   0}, // #2458
  { 2, 23,   0}, // #2459
  { 3, 40,   0}, // #2460
  { 4, 65,   0}, // #2461
  { 5, 71,   0}, // #2462
  { 6, 24,   0}, // #2463
  { 7, 49,   0}, // #2464
  { 8, 32,   0}, // #2465
  { 9, 16,   0}, // #2466
  {10, 33,   0}, // #2467
  {11, 33,   0}, // #2468
  {15,  8,   0}, // #2469
  {17,  7,   0}, // #2470
  {20,  1,   0}, // #2471
  {21, 17,   0}, // #2472
  {22, 17,   0}, // #2473
  {25,  1,   0}, // #2474
  {30, 80,   0}, // #2475
  { 1,  7,   0}, // #2476
  { 2, 23,   0}, // #2477
  { 3, 43,   0}, // #2478
  { 4, 71,   0}, // #2479
  { 5, 77,   0}, // #2480
  { 6, 27,   0}, // #2481
  { 7, 55,   0}, // #2482
  { 8, 35,   0}, // #2483
  { 9, 16,   0}, // #2484
  {10, 36,   0}, // #2485
  {11, 36,   0}, // #2486
  {15, 11,   0}, // #2487
  {17, 10,   0}, // #2488
  {20,  1,   0}, // #2489
  {21, 20,   0}, // #2490
  {22, 20,   0}, // #2491
  {25,  1,   0}, // #2492
  {30, 89,   0}, // #2493
  { 4,  2,   0}, // #2494
  { 5,  3,   0}, // #2495
  { 7,  2,   0}, // #2496
  { 8,  2,   0}, // #2497
  {15,  1,   0}, // #2498
  {17,  1,   0}, // #2499
  {23,  2,   0}, // #2500
  {30,  4,   0}, // #2501
  { 4,  2,   0}, // #2502
  { 5,  3,   0}, // #2503
  { 7,  2,   0}, // #2504
  { 8,  2,   0}, // #2505
  {23,  2,   0}, // #2506
  {30,  3,   0}, // #2507
  { 4,  2,   0}, // #2508
  { 5,  4,   0}, // #2509
  { 7,  2,   0}, // #2510
  { 8,  2,   0}, // #2511
  {23,  2,   0}, // #2512
  {30,  4,   0}, // #2513
  { 2,  2,   0}, // #2514
  { 3,  2,   0}, // #2515
  { 4,  7,   0}, // #2516
  { 5,  8,   0}, // #2517
  { 7,  5,   0}, // #2518
  { 8,  5,   0}, // #2519
  { 9,  2,   0}, // #2520
  {10,  2,   0}, // #2521
  {11,  2,   0}, // #2522
  {15,  2,   0}, // #2523
  {17,  1,   0}, // #2524
  {20,  1,   0}, // #2525
  {25,  1,   0}, // #2526
  {30, 11,   0}, // #2527
  { 2,  3,   0}, // #2528
  { 3,  3,   0}, // #2529
  { 4,  7,   0}, // #2530
  { 5,  9,   0}, // #2531
  { 7,  4,   0}, // #2532
  { 8,  4,   0}, // #2533
  { 9,  3,   0}, // #2534
  {10,  3,   0}, // #2535
  {11,  3,   0}, // #2536
  {15,  2,   0}, // #2537
  {17,  1,   0}, // #2538
  {20,  1,   0}, // #2539
  {25,  1,   0}, // #2540
  {30, 12,   0}, // #2541
  { 1,  2,   0}, // #2542
  { 2,  9,   0}, // #2543
  { 3, 16,   0}, // #2544
  { 4, 24,   0}, // #2545
  { 5, 24,   0}, // #2546
  { 6,  6,   0}, // #2547
  { 7, 14,   0}, // #2548
  { 8,  7,   0}, // #2549
  { 9,  7,   0}, // #2550
  {10, 11,   0}, // #2551
  {11, 11,   0}, // #2552
  {15,  1,   0}, // #2553
  {17,  1,   0}, // #2554
  {21,  4,   0}, // #2555
  {22,  4,   0}, // #2556
  {30, 25,   0}, // #2557
  { 2,  1,   0}, // #2558
  { 3,  1,   0}, // #2559
  { 4,  3,   0}, // #2560
  { 5,  5,   0}, // #2561
  { 7,  2,   0}, // #2562
  { 8,  2,   0}, // #2563
  { 9,  1,   0}, // #2564
  {10,  1,   0}, // #2565
  {11,  1,   0}, // #2566
  {15,  1,   0}, // #2567
  {20,  1,   0}, // #2568
  {25,  1,   0}, // #2569
  {30,  7,   0}, // #2570
  { 3,  1,   0}, // #2571
  { 4,  1,   0}, // #2572
  { 5,  2,   0}, // #2573
  { 6,  1,   0}, // #2574
  { 7,  1,   0}, // #2575
  {10,  1,   0}, // #2576
  {11,  1,   0}, // #2577
  {21,  1,   0}, // #2578
  {22,  1,   0}, // #2579
  {30,  2,   0}, // #2580
  { 2,  1,   0}, // #2581
  { 3,  1,   0}, // #2582
  { 4,  5,   0}, // #2583
  { 5,  6,   0}, // #2584
  { 7,  4,   0}, // #2585
  { 8,  4,   0}, // #2586
  { 9,  1,   0}, // #2587
  {10,  1,   0}, // #2588
  {11,  1,   0}, // #2589
  {30,  6,   0}, // #2590
  { 1,  6,   0}, // #2591
  { 2, 13,   0}, // #2592
  { 3, 13,   0}, // #2593
  { 4, 13,   0}, // #2594
  { 5, 13,   0}, // #2595
  { 6,  6,   0}, // #2596
  { 7,  6,   0}, // #2597
  { 8,  6,   0}, // #2598
  { 9,  7,   0}, // #2599
  {10,  7,   0}, // #2600
  {11,  7,   0}, // #2601
  {15, 18,   0}, // #2602
  {17, 18,   0}, // #2603
  {30, 31,   0}, // #2604
  { 1,  6,   0}, // #2605
  { 2, 13,   0}, // #2606
  { 3, 13,   0}, // #2607
  { 4, 13,   0}, // #2608
  { 5, 13,   0}, // #2609
  { 6,  6,   0}, // #2610
  { 7,  6,   0}, // #2611
  { 8,  6,   0}, // #2612
  { 9,  7,   0}, // #2613
  {10,  7,   0}, // #2614
  {11,  7,   0}, // #2615
  {15, 17,   0}, // #2616
  {17, 17,   0}, // #2617
  {30, 30,   0}, // #2618
  { 1,  5,   0}, // #2619
  { 2, 13,   0}, // #2620
  { 3, 13,   0}, // #2621
  { 4, 13,   0}, // #2622
  { 5, 13,   0}, // #2623
  { 6,  5,   0}, // #2624
  { 7,  5,   0}, // #2625
  { 8,  5,   0}, // #2626
  { 9,  8,   0}, // #2627
  {10,  8,   0}, // #2628
  {11,  8,   0}, // #2629
  {15, 20,   0}, // #2630
  {17, 20,   0}, // #2631
  {30, 33,   0}, // #2632
  { 1,  1,   0}, // #2633
  { 2,  1,   0}, // #2634
  { 3,  1,   0}, // #2635
  { 4,  2,   0}, // #2636
  { 5,  2,   0}, // #2637
  { 6,  1,   0}, // #2638
  { 7,  2,   0}, // #2639
  { 8,  2,   0}, // #2640
  {15,  1,   0}, // #2641
  {17,  1,   0}, // #2642
  {30,  3,   0}, // #2643
  { 2,  4,   0}, // #2644
  { 3,  5,   0}, // #2645
  { 4,  6,   0}, // #2646
  { 5,  8,   0}, // #2647
  { 6,  1,   0}, // #2648
  { 7,  2,   0}, // #2649
  { 8,  1,   0}, // #2650
  { 9,  4,   0}, // #2651
  {10,  5,   0}, // #2652
  {11,  5,   0}, // #2653
  {21,  1,   0}, // #2654
  {22,  1,   0}, // #2655
  {30,  8,   0}, // #2656
  { 1,  1,   0}, // #2657
  { 2, 43,   0}, // #2658
  { 3, 91,   0}, // #2659
  { 4, 143,   0}, // #2660
  { 5, 143,   0}, // #2661
  { 6, 49,   0}, // #2662
  { 7, 101,   0}, // #2663
  { 8, 53,   0}, // #2664
  { 9, 23,   0}, // #2665
  {10, 35,   0}, // #2666
  {11, 35,   0}, // #2667
  {15,  6,   0}, // #2668
  {17,  4,   0}, // #2669
  {20,  2,   0}, // #2670
  {21, 12,   0}, // #2671
  {22, 12,   0}, // #2672
  {25,  2,   0}, // #2673
  {30, 151,   0}, // #2674
  { 1,  1,   0}, // #2675
  { 2, 43,   0}, // #2676
  { 3, 91,   0}, // #2677
  { 4, 144,   0}, // #2678
  { 5, 144,   0}, // #2679
  { 6, 49,   0}, // #2680
  { 7, 102,   0}, // #2681
  { 8, 54,   0}, // #2682
  { 9, 23,   0}, // #2683
  {10, 35,   0}, // #2684
  {11, 35,   0}, // #2685
  {15,  6,   0}, // #2686
  {17,  4,   0}, // #2687
  {20,  2,   0}, // #2688
  {21, 12,   0}, // #2689
  {22, 12,   0}, // #2690
  {25,  2,   0}, // #2691
  {30, 152,   0}, // #2692
  { 2, 52,   0}, // #2693
  { 3, 97,   0}, // #2694
  { 4, 149,   0}, // #2695
  { 5, 149,   0}, // #2696
  { 6, 45,   0}, // #2697
  { 7, 97,   0}, // #2698
  { 8, 52,   0}, // #2699
  { 9, 27,   0}, // #2700
  {10, 37,   0}, // #2701
  {11, 37,   0}, // #2702
  {15,  5,   0}, // #2703
  {17,  4,   0}, // #2704
  {20,  1,   0}, // #2705
  {21, 10,   0}, // #2706
  {22, 10,   0}, // #2707
  {25,  1,   0}, // #2708
  {30, 155,   0}, // #2709
  { 2, 52,   0}, // #2710
  { 3, 123,   0}, // #2711
  { 4, 176,   0}, // #2712
  { 5, 176,   0}, // #2713
  { 6, 41,   0}, // #2714
  { 7, 94,   0}, // #2715
  { 8, 53,   0}, // #2716
  { 9, 29,   0}, // #2717
  {10, 68,   0}, // #2718
  {11, 68,   0}, // #2719
  {15,  6,   0}, // #2720
  {17,  4,   0}, // #2721
  {20,  2,   0}, // #2722
  {21,  9,   0}, // #2723
  {22,  9,   0}, // #2724
  {25,  2,   0}, // #2725
  {30, 184,   0}, // #2726
  { 1,  1,   0}, // #2727
  { 3,  2,   0}, // #2728
  { 1,  1,   0}, // #2729
  { 3,  1,   0}, // #2730
  { 1,  6,   0}, // #2731
  { 2,  6,   0}, // #2732
  { 3, 12,   0}, // #2733
  { 1,  5,   0}, // #2734
  { 2,  5,   0}, // #2735
  { 3, 10,   0}, // #2736
  { 1, 16,   0}, // #2737
  { 2, 16,   0}, // #2738
  { 3, 32,   0}, // #2739
  { 3, 15,   0}, // #2740
  { 1, 10,   0}, // #2741
  { 2, 10,   0}, // #2742
  { 3, 20,   0}, // #2743
  { 1,  9,   0}, // #2744
  { 2,  9,   0}, // #2745
  { 3, 18,   0}, // #2746
  { 1,  5,   0}, // #2747
  { 3,  5,   0}, // #2748
  { 1,  7,   0}, // #2749
  { 2,  7,   0}, // #2750
  { 3, 14,   0}, // #2751
  { 1,  8,   0}, // #2752
  { 2,  8,   0}, // #2753
  { 3, 16,   0}, // #2754
  { 1, 12,   0}, // #2755
  { 2, 12,   0}, // #2756
  { 3, 24,   0}, // #2757
  { 1, 11,   0}, // #2758
  { 2, 11,   0}, // #2759
  { 3, 22,   0}, // #2760
  { 1, 50,   0}, // #2761
  { 2, 50,   0}, // #2762
  { 3, 100,   0}, // #2763
  { 1, 130,   0}, // #2764
  { 2, 130,   0}, // #2765
  { 3, 260,   0}, // #2766
  { 1, 68,   0}, // #2767
  { 2, 68,   0}, // #2768
  { 3, 136,   0}, // #2769
  { 1, 125,   0}, // #2770
  { 2, 125,   0}, // #2771
  { 3, 250,   0}, // #2772
  { 1, 70,   0}, // #2773
  { 2, 70,   0}, // #2774
  { 3, 140,   0}, // #2775
  { 1, 34,   0}, // #2776
  { 2, 34,   0}, // #2777
  { 3, 68,   0}, // #2778
  { 1, 62,   0}, // #2779
  { 2, 62,   0}, // #2780
  { 3, 124,   0}, // #2781
  { 1,  2,   0}, // #2782
  { 3,  2,   0}, // #2783
  { 1, 14,   0}, // #2784
  { 2, 14,   0}, // #2785
  { 3, 28,   0}, // #2786
  { 1,  3,   0}, // #2787
  { 3,  3,   0}, // #2788
  { 1,  4,   0}, // #2789
  { 2,  4,   0}, // #2790
  { 3,  8,   0}, // #2791
  { 1,  3,   0}, // #2792
  { 2,  3,   0}, // #2793
  { 3,  6,   0}, // #2794
  { 1,  2,   0}, // #2795
  { 2,  2,   0}, // #2796
  { 3,  4,   0}, // #2797
  { 1,  4,   0}, // #2798
  { 3,  4,   0}, // #2799
  { 1, 71,   0}, // #2800
  { 3, 71,   0}, // #2801
  { 1, 15,   0}, // #2802
  { 2, 15,   0}, // #2803
  { 3, 30,   0}, // #2804
  { 3, 21,   0}, // #2805
  { 3, 25,   0}, // #2806
  { 3, 29,   0}, // #2807
  { 3, 45,   0}, // #2808
  { 3, 55,   0}, // #2809
  { 3, 59,   0}, // #2810
  { 3, 63,   0}, // #2811
  { 3, 72,   0}, // #2812
  { 3, 74,   0}, // #2813
  { 3, 77,   0}, // #2814
  { 3, 78,   0}, // #2815
  { 3, 92,   0}, // #2816
  { 3, 94,   0}, // #2817
  { 3, 99,   0}, // #2818
  { 3, 121,   0}, // #2819
  { 3, 127,   0}, // #2820
  { 3, 130,   0}, // #2821
  { 3, 141,   0}, // #2822
  { 3, 146,   0}, // #2823
  { 3, 147,   0}, // #2824
  { 3, 168,   0}, // #2825
  { 3, 174,   0}, // #2826
  { 3, 183,   0}, // #2827
  { 3, 202,   0}, // #2828
  { 9,  6,   0}, // #2829
  {10,  2,   0}, // #2830
  { 4,  1,   0}, // #2831
  { 6,  1,   0}, // #2832
  { 5,  2,   0}, // #2833
  { 6,  2,   0}, // #2834
  {10,  1,   0}, // #2835
  { 5,  1,   0}, // #2836
  { 6,  1,   0}, // #2837
  {10,  1,   0}, // #2838
  { 4,  5,   0}, // #2839
  { 6,  5,   0}, // #2840
  {10,  1,   0}, // #2841
  { 4,  4,   0}, // #2842
  { 6,  4,   0}, // #2843
  {10,  1,   0}, // #2844
  { 4,  1,   0}, // #2845
  { 6,  1,   0}, // #2846
  {10,  1,   0}, // #2847
  { 7, 10,   0}, // #2848
  { 8, 10,   0}, // #2849
  { 9, 20,   0}, // #2850
  {10,  1,   0}, // #2851
  { 7,  1,   0}, // #2852
  { 8,  1,   0}, // #2853
  { 9,  2,   0}, // #2854
  {10,  1,   0}, // #2855
  { 7,  1,   0}, // #2856
  { 8,  1,   0}, // #2857
  { 9,  2,   0}, // #2858
  {10,  2,   0}, // #2859
  { 4,  2,   0}, // #2860
  { 6,  2,   0}, // #2861
  {10,  1,   0}, // #2862
  { 1, 25,   0}, // #2863
  { 9,  1,   0}, // #2864
  {10,  1,   0}, // #2865
  { 2, 69,   0}, // #2866
  { 4,  1,   0}, // #2867
  { 6,  1,   0}, // #2868
  {10,  1,   0}, // #2869
  { 2, 39,   0}, // #2870
  { 4,  1,   0}, // #2871
  { 6,  1,   0}, // #2872
  {10,  1,   0}, // #2873
  { 2, 17,   0}, // #2874
  { 4,  1,   0}, // #2875
  { 6,  1,   0}, // #2876
  {10,  1,   0}, // #2877
  { 2, 32,   0}, // #2878
  { 4,  1,   0}, // #2879
  { 6,  1,   0}, // #2880
  {10,  1,   0}, // #2881
  { 5,  8,   0}, // #2882
  { 6,  8,   0}, // #2883
  {10,  1,   0}, // #2884
  { 5, 12,   0}, // #2885
  { 6, 12,   0}, // #2886
  {10,  1,   0}, // #2887
  { 4,  1,   0}, // #2888
  { 6,  1,   0}, // #2889
  {10,  2,   0}, // #2890
  { 6, 10,   0}, // #2891
  { 5,  6,   0}, // #2892
  { 6,  6,   0}, // #2893
  {10,  1,   0}, // #2894
  { 8,  5,   0}, // #2895
  { 9,  5,   0}, // #2896
  {10,  1,   0}, // #2897
  { 8,  4,   0}, // #2898
  { 9,  4,   0}, // #2899
  {10,  1,   0}, // #2900
  { 8,  7,   0}, // #2901
  { 9,  7,   0}, // #2902
  {10,  1,   0}, // #2903
  { 8,  2,   0}, // #2904
  { 9,  2,   0}, // #2905
  {10,  1,   0}, // #2906
  { 7,  1,   0}, // #2907
  { 9,  1,   0}, // #2908
  {10,  1,   0}, // #2909
  { 3,  4,   0}, // #2910
  { 4,  1,   0}, // #2911
  { 6,  1,   0}, // #2912
  {10,  1,   0}, // #2913
  { 3,  2,   0}, // #2914
  { 4,  1,   0}, // #2915
  { 6,  1,   0}, // #2916
  {10,  1,   0}, // #2917
  { 4, 10,   0}, // #2918
  { 6, 10,   0}, // #2919
  {10,  1,   0}, // #2920
  { 4, 21,   0}, // #2921
  { 6, 21,   0}, // #2922
  {10,  1,   0}, // #2923
  { 4, 17,   0}, // #2924
  { 6, 17,   0}, // #2925
  {10,  1,   0}, // #2926
  { 4, 13,   0}, // #2927
  { 6, 13,   0}, // #2928
  {10,  1,   0}, // #2929
  { 4, 11,   0}, // #2930
  { 6, 11,   0}, // #2931
  {10,  1,   0}, // #2932
  { 7,  2,   0}, // #2933
  { 9,  2,   0}, // #2934
  {10,  1,   0}, // #2935
  { 4,  8,   0}, // #2936
  { 6,  8,   0}, // #2937
  {10,  1,   0}, // #2938
  { 2, 70,   0}, // #2939
  { 4,  1,   0}, // #2940
  { 6,  1,   0}, // #2941
  {10,  1,   0}, // #2942
  { 2, 40,   0}, // #2943
  { 4,  1,   0}, // #2944
  { 6,  1,   0}, // #2945
  {10,  1,   0}, // #2946
  { 2, 35,   0}, // #2947
  { 4,  1,   0}, // #2948
  { 6,  1,   0}, // #2949
  {10,  1,   0}, // #2950
  { 2, 20,   0}, // #2951
  { 4,  1,   0}, // #2952
  { 6,  1,   0}, // #2953
  {10,  1,   0}, // #2954
  { 5,  2,   0}, // #2955
  { 8,  2,   0}, // #2956
  {11,  1,   0}, // #2957
  {14,  1,   0}, // #2958
  {20,  1,   0}, // #2959
  { 2,  1,   0}, // #2960
  { 5,  1,   0}, // #2961
  { 7,  1,   0}, // #2962
  { 8,  1,   0}, // #2963
  { 1,  2,   0}, // #2964
  { 5, 44,   0}, // #2965
  { 7, 44,   0}, // #2966
  { 8, 44,   0}, // #2967
  {22,  1,   0}, // #2968
  {24,  1,   0}, // #2969
  { 1,  3,   0}, // #2970
  { 2,  1,   0}, // #2971
  { 5,  1,   0}, // #2972
  { 7,  1,   0}, // #2973
  { 8,  1,   0}, // #2974
  {22,  3,   0}, // #2975
  { 5,  1,   0}, // #2976
  { 8,  1,   0}, // #2977
  { 1,  1,   0}, // #2978
  {24,  1,   0}, // #2979
  { 5,  6,   0}, // #2980
  { 8,  6,   0}, // #2981
  { 1,  1,   0}, // #2982
  {13,  1,   0}, // #2983
  {14,  3,   0}, // #2984
  {20,  3,   0}, // #2985
  {24,  1,   0}, // #2986
  { 1,  3,   0}, // #2987
  {10,  3,   0}, // #2988
  {14,  1,   0}, // #2989
  {19,  1,   0}, // #2990
  {22,  3,   0}, // #2991
  { 1,  1,   0}, // #2992
  {13,  2,   0}, // #2993
  {14, 36,   0}, // #2994
  {20, 36,   0}, // #2995
  {24,  1,   0}, // #2996
  { 1,  4,   0}, // #2997
  { 5,  2,   0}, // #2998
  { 8,  2,   0}, // #2999
  {22,  3,   0}, // #3000
  {24,  1,   0}, // #3001
  {10,  4,   0}, // #3002
  {14,  1,   0}, // #3003
  {16,  1,   0}, // #3004
  {19,  1,   0}, // #3005
  { 1,  3,   0}, // #3006
  { 5,  2,   0}, // #3007
  { 8,  2,   0}, // #3008
  {22,  3,   0}, // #3009
  { 1,  3,   0}, // #3010
  {10,  1,   0}, // #3011
  {14,  1,   0}, // #3012
  {15,  1,   0}, // #3013
  {19,  1,   0}, // #3014
  {22,  3,   0}, // #3015
  { 1,  3,   0}, // #3016
  {12,  1,   0}, // #3017
  {14,  1,   0}, // #3018
  {15,  1,   0}, // #3019
  {19,  1,   0}, // #3020
  {22,  3,   0}, // #3021
  { 1,  3,   0}, // #3022
  {11,  1,   0}, // #3023
  {14,  1,   0}, // #3024
  {20,  1,   0}, // #3025
  {22,  3,   0}, // #3026
  { 1,  3,   0}, // #3027
  {14,  1,   0}, // #3028
  {16,  1,   0}, // #3029
  {19,  1,   0}, // #3030
  {21,  1,   0}, // #3031
  {22,  3,   0}, // #3032
  { 1,  3,   0}, // #3033
  { 5,  6,   0}, // #3034
  { 8,  6,   0}, // #3035
  {22,  3,   0}, // #3036
  { 1,  3,   0}, // #3037
  { 5,  8,   0}, // #3038
  { 8,  8,   0}, // #3039
  {22,  3,   0}, // #3040
  { 1,  2,   0}, // #3041
  { 5,  7,   0}, // #3042
  { 8,  7,   0}, // #3043
  {22,  2,   0}, // #3044
  { 1,  1,   0}, // #3045
  { 5, 42,   0}, // #3046
  { 8, 42,   0}, // #3047
  {22,  1,   0}, // #3048
  { 1,  1,   0}, // #3049
  { 5, 44,   0}, // #3050
  { 8, 44,   0}, // #3051
  {22,  1,   0}, // #3052
  { 1,  3,   0}, // #3053
  { 5,  1,   0}, // #3054
  { 8,  1,   0}, // #3055
  {22,  3,   0}, // #3056
  { 1,  2,   0}, // #3057
  {22,  2,   0}, // #3058
  { 5,  3,   0}, // #3059
  { 7,  3,   0}, // #3060
  { 8,  3,   0}, // #3061
  { 1,  3,   0}, // #3062
  { 5,  1,   0}, // #3063
  { 6,  1,   0}, // #3064
  { 8,  1,   0}, // #3065
  {10,  1,   0}, // #3066
  {14,  1,   0}, // #3067
  {15,  1,   0}, // #3068
  {19,  1,   0}, // #3069
  {22,  3,   0}, // #3070
  { 1,  3,   0}, // #3071
  { 5,  4,   0}, // #3072
  { 8,  4,   0}, // #3073
  {22,  3,   0}, // #3074
  { 1,  3,   0}, // #3075
  { 9,  1,   0}, // #3076
  {13,  1,   0}, // #3077
  {14,  1,   0}, // #3078
  {15,  1,   0}, // #3079
  {19,  1,   0}, // #3080
  {22,  3,   0}, // #3081
  { 1,  3,   0}, // #3082
  { 5,  1,   0}, // #3083
  { 6,  1,   0}, // #3084
  { 8,  1,   0}, // #3085
  { 9,  1,   0}, // #3086
  {10,  1,   0}, // #3087
  {13,  1,   0}, // #3088
  {14,  1,   0}, // #3089
  {15,  1,   0}, // #3090
  {19,  1,   0}, // #3091
  {22,  3,   0}, // #3092
  { 1,  3,   0}, // #3093
  { 9,  2,   0}, // #3094
  {13,  1,   0}, // #3095
  {14,  1,   0}, // #3096
  {15,  1,   0}, // #3097
  {19,  1,   0}, // #3098
  {22,  3,   0}, // #3099
  { 1,  3,   0}, // #3100
  { 4, 15,   0}, // #3101
  { 5,  1,   0}, // #3102
  { 7,  1,   0}, // #3103
  { 8,  1,   0}, // #3104
  {22,  3,   0}, // #3105
  { 1,  3,   0}, // #3106
  { 4, 14,   0}, // #3107
  { 5,  1,   0}, // #3108
  { 7,  1,   0}, // #3109
  { 8,  1,   0}, // #3110
  {22,  3,   0}, // #3111
  { 1,  3,   0}, // #3112
  { 4, 12,   0}, // #3113
  { 5,  1,   0}, // #3114
  { 7,  1,   0}, // #3115
  { 8,  1,   0}, // #3116
  {22,  3,   0}, // #3117
  { 1,  3,   0}, // #3118
  {10,  9,   0}, // #3119
  {14,  1,   0}, // #3120
  {16,  1,   0}, // #3121
  {19,  1,   0}, // #3122
  {22,  3,   0}, // #3123
  { 1,  3,   0}, // #3124
  {10, 10,   0}, // #3125
  {14,  1,   0}, // #3126
  {16,  1,   0}, // #3127
  {19,  1,   0}, // #3128
  {22,  3,   0}, // #3129
  { 1,  3,   0}, // #3130
  {10, 14,   0}, // #3131
  {14,  1,   0}, // #3132
  {16,  1,   0}, // #3133
  {19,  1,   0}, // #3134
  {22,  3,   0}, // #3135
  { 1,  1,   0}, // #3136
  {13,  1,   0}, // #3137
  {14,  2,   0}, // #3138
  {16,  2,   0}, // #3139
  {19,  2,   0}, // #3140
  {24,  1,   0}, // #3141
  { 5,  1,   0}, // #3142
  { 6,  1,   0}, // #3143
  { 8,  1,   0}, // #3144
  {10,  3,   0}, // #3145
  {14,  1,   0}, // #3146
  {15,  1,   0}, // #3147
  {19,  1,   0}, // #3148
  {10,  1,   0}, // #3149
  {14,  1,   0}, // #3150
  {19,  1,   0}, // #3151
  {13,  1,   0}, // #3152
  {14,  1,   0}, // #3153
  {16,  1,   0}, // #3154
  {19,  1,   0}, // #3155
  { 1,  3,   0}, // #3156
  {10,  5,   0}, // #3157
  {14,  1,   0}, // #3158
  {15,  1,   0}, // #3159
  {19,  1,   0}, // #3160
  {22,  3,   0}, // #3161
  { 1,  3,   0}, // #3162
  { 4, 17,   0}, // #3163
  { 5,  1,   0}, // #3164
  { 7,  1,   0}, // #3165
  { 8,  1,   0}, // #3166
  {22,  3,   0}, // #3167
  { 1,  3,   0}, // #3168
  { 4, 25,   0}, // #3169
  { 5,  1,   0}, // #3170
  { 7,  1,   0}, // #3171
  { 8,  1,   0}, // #3172
  {22,  3,   0}, // #3173
  { 1,  3,   0}, // #3174
  { 5,  1,   0}, // #3175
  { 7,  1,   0}, // #3176
  { 8,  1,   0}, // #3177
  {22,  3,   0}, // #3178
  {23,  5,   0}, // #3179
  { 5,  1,   0}, // #3180
  { 7,  1,   0}, // #3181
  { 8,  1,   0}, // #3182
  {23,  5,   0}, // #3183
  { 1,  3,   0}, // #3184
  { 5,  1,   0}, // #3185
  { 7,  1,   0}, // #3186
  { 8,  1,   0}, // #3187
  {22,  3,   0}, // #3188
  {23,  2,   0}, // #3189
  { 5,  1,   0}, // #3190
  { 7,  1,   0}, // #3191
  { 8,  1,   0}, // #3192
  {23,  2,   0}, // #3193
  { 1,  3,   0}, // #3194
  { 5,  1,   0}, // #3195
  { 7,  1,   0}, // #3196
  { 8,  1,   0}, // #3197
  {22,  3,   0}, // #3198
  {23,  4,   0}, // #3199
  { 5,  1,   0}, // #3200
  { 7,  1,   0}, // #3201
  { 8,  1,   0}, // #3202
  {23,  4,   0}, // #3203
  { 1,  3,   0}, // #3204
  { 5,  1,   0}, // #3205
  { 7,  1,   0}, // #3206
  { 8,  1,   0}, // #3207
  {22,  3,   0}, // #3208
  {23,  6,   0}, // #3209
  { 5,  1,   0}, // #3210
  { 7,  1,   0}, // #3211
  { 8,  1,   0}, // #3212
  {23,  6,   0}, // #3213
  { 1,  3,   0}, // #3214
  {10,  2,   0}, // #3215
  {14,  1,   0}, // #3216
  {19,  1,   0}, // #3217
  {22,  3,   0}, // #3218
  { 1,  3,   0}, // #3219
  {11,  3,   0}, // #3220
  {14,  1,   0}, // #3221
  {19,  1,   0}, // #3222
  {22,  3,   0}, // #3223
  { 1,  1,   0}, // #3224
  {22,  1,   0}, // #3225
  { 1,  3,   0}, // #3226
  { 5,  2,   0}, // #3227
  { 6,  2,   0}, // #3228
  { 8,  2,   0}, // #3229
  {22,  3,   0}, // #3230
  {11,  2,   0}, // #3231
  {14,  1,   0}, // #3232
  {19,  1,   0}, // #3233
  { 1,  1,   0}, // #3234
  {13,  1,   0}, // #3235
  {14,  1,   0}, // #3236
  {16,  1,   0}, // #3237
  {19,  1,   0}, // #3238
  {24,  1,   0}, // #3239
  {11,  1,   0}, // #3240
  {14,  1,   0}, // #3241
  {19,  1,   0}, // #3242
  { 1,  3,   0}, // #3243
  {11,  4,   0}, // #3244
  {14,  1,   0}, // #3245
  {19,  1,   0}, // #3246
  {22,  3,   0}, // #3247
  { 1,  3,   0}, // #3248
  {11,  2,   0}, // #3249
  {14,  1,   0}, // #3250
  {19,  1,   0}, // #3251
  {22,  3,   0}, // #3252
  { 1,  3,   0}, // #3253
  {12,  4,   0}, // #3254
  {14,  1,   0}, // #3255
  {15,  1,   0}, // #3256
  {19,  1,   0}, // #3257
  {22,  3,   0}, // #3258
  { 1,  3,   0}, // #3259
  {10,  1,   0}, // #3260
  {14,  1,   0}, // #3261
  {16,  1,   0}, // #3262
  {19,  1,   0}, // #3263
  {22,  3,   0}, // #3264
  { 1,  3,   0}, // #3265
  {12,  7,   0}, // #3266
  {14,  1,   0}, // #3267
  {15,  1,   0}, // #3268
  {19,  1,   0}, // #3269
  {22,  3,   0}, // #3270
  { 1, 23,   0}, // #3271
  { 5,  1,   0}, // #3272
  { 6,  1,   0}, // #3273
  { 8,  1,   0}, // #3274
  {10,  1,   0}, // #3275
  {11, 10,   0}, // #3276
  {14,  1,   0}, // #3277
  {16,  1,   0}, // #3278
  {19,  1,   0}, // #3279
  {22, 13,   0}, // #3280
  {24, 10,   0}, // #3281
  { 1, 20,   0}, // #3282
  { 5,  1,   0}, // #3283
  { 6,  1,   0}, // #3284
  { 8,  1,   0}, // #3285
  {10,  1,   0}, // #3286
  {11, 10,   0}, // #3287
  {14,  1,   0}, // #3288
  {16,  1,   0}, // #3289
  {19,  1,   0}, // #3290
  {22, 10,   0}, // #3291
  {24, 10,   0}, // #3292
  { 1,  3,   0}, // #3293
  { 5,  1,   0}, // #3294
  { 6,  1,   0}, // #3295
  { 8,  1,   0}, // #3296
  {10,  6,   0}, // #3297
  {14,  1,   0}, // #3298
  {16,  1,   0}, // #3299
  {19,  1,   0}, // #3300
  {22,  3,   0}, // #3301
  { 1,  3,   0}, // #3302
  { 5,  1,   0}, // #3303
  { 6,  1,   0}, // #3304
  { 8,  1,   0}, // #3305
  {10,  8,   0}, // #3306
  {14,  1,   0}, // #3307
  {16,  1,   0}, // #3308
  {19,  1,   0}, // #3309
  {22,  3,   0}, // #3310
  { 1,  3,   0}, // #3311
  {11,  1,   0}, // #3312
  {14,  1,   0}, // #3313
  {15,  1,   0}, // #3314
  {19,  1,   0}, // #3315
  {22,  3,   0}, // #3316
  { 1,  3,   0}, // #3317
  {11,  1,   0}, // #3318
  {12,  2,   0}, // #3319
  {14,  3,   0}, // #3320
  {15,  2,   0}, // #3321
  {19,  3,   0}, // #3322
  {22,  3,   0}, // #3323
  { 1,  3,   0}, // #3324
  {22,  2,   0}, // #3325
  {24,  1,   0}, // #3326
  { 1,  4,   0}, // #3327
  { 5,  1,   0}, // #3328
  { 8,  1,   0}, // #3329
  {22,  3,   0}, // #3330
  {24,  1,   0}, // #3331
  { 1,  3,   0}, // #3332
  {13,  1,   0}, // #3333
  {14,  1,   0}, // #3334
  {16,  1,   0}, // #3335
  {19,  1,   0}, // #3336
  {22,  3,   0}, // #3337
  { 1,  3,   0}, // #3338
  {10,  2,   0}, // #3339
  {14,  1,   0}, // #3340
  {16,  1,   0}, // #3341
  {19,  1,   0}, // #3342
  {22,  3,   0}, // #3343
  { 1,  1,   0}, // #3344
  { 5,  1,   0}, // #3345
  { 8,  1,   0}, // #3346
  {24,  1,   0}, // #3347
  { 1,  1,   0}, // #3348
  { 5, 22,   0}, // #3349
  { 8, 22,   0}, // #3350
  {22,  1,   0}, // #3351
  {10, 18,   0}, // #3352
  {14,  1,   0}, // #3353
  {16,  1,   0}, // #3354
  {19,  1,   0}, // #3355
  { 1, 18,   0}, // #3356
  {24, 18,   0}, // #3357
  { 1,  3,   0}, // #3358
  {10,  3,   0}, // #3359
  {14,  1,   0}, // #3360
  {22,  3,   0}, // #3361
  { 1,  3,   0}, // #3362
  {10,  2,   0}, // #3363
  {14,  1,   0}, // #3364
  {15,  1,   0}, // #3365
  {19,  1,   0}, // #3366
  {22,  3,   0}, // #3367
  { 1,  3,   0}, // #3368
  {14,  2,   0}, // #3369
  {16,  2,   0}, // #3370
  {19,  2,   0}, // #3371
  {21,  2,   0}, // #3372
  {22,  3,   0}, // #3373
  { 1,  3,   0}, // #3374
  {11,  2,   0}, // #3375
  {14,  2,   0}, // #3376
  {20,  2,   0}, // #3377
  {22,  3,   0}, // #3378
  { 1,  3,   0}, // #3379
  {11,  1,   0}, // #3380
  {14,  1,   0}, // #3381
  {19,  1,   0}, // #3382
  {22,  3,   0}, // #3383
  { 1,  3,   0}, // #3384
  { 9,  2,   0}, // #3385
  {10,  1,   0}, // #3386
  {13,  1,   0}, // #3387
  {14,  1,   0}, // #3388
  {15,  1,   0}, // #3389
  {19,  1,   0}, // #3390
  {22,  3,   0}, // #3391
  { 1,  1,   0}, // #3392
  { 9,  2,   0}, // #3393
  {10,  1,   0}, // #3394
  {13,  1,   0}, // #3395
  {14,  1,   0}, // #3396
  {15,  1,   0}, // #3397
  {19,  1,   0}, // #3398
  {24,  1,   0}, // #3399
  { 1,  1,   0}, // #3400
  { 9,  2,   0}, // #3401
  {13,  1,   0}, // #3402
  {14,  1,   0}, // #3403
  {15,  1,   0}, // #3404
  {19,  1,   0}, // #3405
  {24,  1,   0}, // #3406
  { 1,  3,   0}, // #3407
  {10, 18,   0}, // #3408
  {14,  2,   0}, // #3409
  {16,  2,   0}, // #3410
  {19,  2,   0}, // #3411
  {22,  3,   0}, // #3412
  { 1,  3,   0}, // #3413
  {10, 25,   0}, // #3414
  {14,  2,   0}, // #3415
  {16,  2,   0}, // #3416
  {19,  2,   0}, // #3417
  {22,  3,   0}, // #3418
  { 1,  3,   0}, // #3419
  {13,  1,   0}, // #3420
  {14,  2,   0}, // #3421
  {16,  2,   0}, // #3422
  {19,  2,   0}, // #3423
  {22,  3,   0}, // #3424
  { 1,  3,   0}, // #3425
  {10,  8,   0}, // #3426
  {14,  1,   0}, // #3427
  {15,  1,   0}, // #3428
  {19,  1,   0}, // #3429
  {22,  3,   0}, // #3430
  { 1,  3,   0}, // #3431
  {11,  3,   0}, // #3432
  {14,  2,   0}, // #3433
  {19,  2,   0}, // #3434
  {22,  3,   0}, // #3435
  { 1,  2,   0}, // #3436
  {10, 376,   0}, // #3437
  {14,  2,   0}, // #3438
  {19,  2,   0}, // #3439
  {24,  2,   0}, // #3440
  { 1,  3,   0}, // #3441
  {10,  4,   0}, // #3442
  {14,  2,   0}, // #3443
  {19,  2,   0}, // #3444
  {22,  3,   0}, // #3445
  { 1,  1,   0}, // #3446
  {10, 188,   0}, // #3447
  {14,  1,   0}, // #3448
  {19,  1,   0}, // #3449
  {24,  1,   0}, // #3450
  { 1,  3,   0}, // #3451
  {10,  4,   0}, // #3452
  {14,  1,   0}, // #3453
  {19,  1,   0}, // #3454
  {22,  3,   0}, // #3455
  {10,  2,   0}, // #3456
  {14,  2,   0}, // #3457
  {19,  2,   0}, // #3458
  { 1,  2,   0}, // #3459
  {13,  2,   0}, // #3460
  {14, 36,   0}, // #3461
  {20, 36,   0}, // #3462
  {24,  2,   0}, // #3463
  {11,  2,   0}, // #3464
  {14,  2,   0}, // #3465
  {19,  2,   0}, // #3466
  { 1,  3,   0}, // #3467
  {11,  4,   0}, // #3468
  {14,  2,   0}, // #3469
  {19,  2,   0}, // #3470
  {22,  3,   0}, // #3471
  { 1,  2,   0}, // #3472
  {13,  2,   0}, // #3473
  {14,  2,   0}, // #3474
  {16,  2,   0}, // #3475
  {19,  2,   0}, // #3476
  {24,  2,   0}, // #3477
  { 1,  3,   0}, // #3478
  { 5,  1,   0}, // #3479
  { 6,  1,   0}, // #3480
  { 8,  1,   0}, // #3481
  {10,  4,   0}, // #3482
  {14,  2,   0}, // #3483
  {19,  2,   0}, // #3484
  {22,  3,   0}, // #3485
  { 1,  3,   0}, // #3486
  {10,  1,   0}, // #3487
  {14,  2,   0}, // #3488
  {16,  2,   0}, // #3489
  {19,  2,   0}, // #3490
  {22,  3,   0}, // #3491
  { 1,  3,   0}, // #3492
  {10,  2,   0}, // #3493
  {14,  2,   0}, // #3494
  {16,  2,   0}, // #3495
  {19,  2,   0}, // #3496
  {22,  3,   0}, // #3497
  { 1,  3,   0}, // #3498
  { 5,  1,   0}, // #3499
  { 6,  1,   0}, // #3500
  { 8,  1,   0}, // #3501
  {10,  4,   0}, // #3502
  {14,  4,   0}, // #3503
  {19,  4,   0}, // #3504
  {22,  3,   0}, // #3505
  { 9,  3,   0}, // #3506
  {13,  1,   0}, // #3507
  {14,  1,   0}, // #3508
  {15,  1,   0}, // #3509
  {19,  1,   0}, // #3510
  { 5, 23,   0}, // #3511
  { 7, 23,   0}, // #3512
  { 8, 23,   0}, // #3513
  { 5, 21,   0}, // #3514
  { 7, 21,   0}, // #3515
  { 8, 21,   0}, // #3516
  { 5, 26,   0}, // #3517
  { 7, 26,   0}, // #3518
  { 8, 26,   0}, // #3519
  { 5, 69,   0}, // #3520
  { 7, 69,   0}, // #3521
  { 8, 69,   0}, // #3522
  { 5, 14,   0}, // #3523
  { 8, 14,   0}, // #3524
  { 5, 25,   0}, // #3525
  { 8, 25,   0}, // #3526
  { 5, 20,   0}, // #3527
  { 7, 20,   0}, // #3528
  { 8, 20,   0}, // #3529
  { 1,  3,   0}, // #3530
  {10, 10,   0}, // #3531
  {14,  1,   0}, // #3532
  {15,  1,   0}, // #3533
  {19,  1,   0}, // #3534
  {22,  3,   0}, // #3535
  { 1,  3,   0}, // #3536
  {10, 18,   0}, // #3537
  {14,  1,   0}, // #3538
  {15,  1,   0}, // #3539
  {19,  1,   0}, // #3540
  {22,  3,   0}, // #3541
  { 1,  1,   0}, // #3542
  {10,  4,   0}, // #3543
  {14,  2,   0}, // #3544
  {19,  2,   0}, // #3545
  {22,  1,   0}, // #3546
  { 5, 375,   0}, // #3547
  { 8, 375,   0}, // #3548
  { 5, 24,   0}, // #3549
  { 8, 24,   0}, // #3550
  {10,  6,   0}, // #3551
  {14,  1,   0}, // #3552
  {19,  1,   0}, // #3553
  {10,  8,   0}, // #3554
  {14,  1,   0}, // #3555
  {19,  1,   0}, // #3556
  { 5,  3,   0}, // #3557
  { 8,  3,   0}, // #3558
  { 5, 18,   0}, // #3559
  { 8, 18,   0}, // #3560
  { 5, 88,   0}, // #3561
  { 8, 88,   0}, // #3562
  { 1,  3,   0}, // #3563
  { 5,  3,   0}, // #3564
  { 8,  3,   0}, // #3565
  {22,  3,   0}, // #3566
  { 5, 10,   0}, // #3567
  { 8, 10,   0}, // #3568
  { 5, 12,   0}, // #3569
  { 8, 12,   0}, // #3570
  { 5, 17,   0}, // #3571
  { 8, 17,   0}, // #3572
  { 5,  5,   0}, // #3573
  { 8,  5,   0}, // #3574
  { 5, 23,   0}, // #3575
  { 8, 23,   0}, // #3576
  { 5, 20,   0}, // #3577
  { 8, 20,   0}, // #3578
  { 5, 19,   0}, // #3579
  { 8, 19,   0}, // #3580
  { 5, 13,   0}, // #3581
  { 8, 13,   0}, // #3582
  { 5, 21,   0}, // #3583
  { 8, 21,   0}, // #3584
  { 5, 15,   0}, // #3585
  { 8, 15,   0}, // #3586
  {13,  1,   0}, // #3587
  {14, 10,   0}, // #3588
  {16, 10,   0}, // #3589
  {19, 10,   0}, // #3590
  {13,  1,   0}, // #3591
  {14,  3,   0}, // #3592
  {16,  3,   0}, // #3593
  {19,  3,   0}, // #3594
  {13,  1,   0}, // #3595
  {14,  4,   0}, // #3596
  {16,  4,   0}, // #3597
  {19,  4,   0}, // #3598
  {11,  1,   0}, // #3599
  {12,  1,   0}, // #3600
  {14,  1,   0}, // #3601
  {15,  1,   0}, // #3602
  {19,  1,   0}, // #3603
  {22,  1,   0}, // #3604
  {23,  1,   0}, // #3605
  {14,  1,   0}, // #3606
  {20,  1,   0}, // #3607
  {22,  1,   0}, // #3608
  {23,  1,   0}, // #3609
  { 7,  1,   0}, // #3610
  {12,  1,   0}, // #3611
  {14,  2,   0}, // #3612
  {17,  1,   0}, // #3613
  {20,  2,   0}, // #3614
  {21,  2,   0}, // #3615
  {22,  3,   0}, // #3616
  {23,  6,   0}, // #3617
  {14,  1,   0}, // #3618
  {17,  1,   0}, // #3619
  {20,  1,   0}, // #3620
  {21,  1,   0}, // #3621
  {22,  1,   0}, // #3622
  {23,  2,   0}, // #3623
  { 7,  1,   0}, // #3624
  {12,  1,   0}, // #3625
  {21,  1,   0}, // #3626
  {23,  2,   0}, // #3627
  { 4,  1,   0}, // #3628
  {11,  1,   0}, // #3629
  {15,  1,   0}, // #3630
  {16,  1,   0}, // #3631
  {19,  1,   0}, // #3632
  {22,  1,   0}, // #3633
  {23,  1,   0}, // #3634
  {17,  1,   0}, // #3635
  {21,  1,   0}, // #3636
  {23,  1,   0}, // #3637
  { 7,  1,   0}, // #3638
  {12,  1,   0}, // #3639
  {17,  1,   0}, // #3640
  {21,  2,   0}, // #3641
  {22,  1,   0}, // #3642
  {23,  4,   0}, // #3643
  { 8,  1,   0}, // #3644
  {13,  1,   0}, // #3645
  {15,  1,   0}, // #3646
  {18,  1,   0}, // #3647
  {19,  1,   0}, // #3648
  {20,  1,   0}, // #3649
  {22,  1,   0}, // #3650
  {23,  1,   0}, // #3651
  {17,  1,   0}, // #3652
  {21,  1,   0}, // #3653
  {22,  1,   0}, // #3654
  {23,  2,   0}, // #3655
  { 4,  1,   0}, // #3656
  {11,  1,   0}, // #3657
  {15,  1,   0}, // #3658
  {16,  1,   0}, // #3659
  {17,  1,   0}, // #3660
  {19,  1,   0}, // #3661
  {21,  1,   0}, // #3662
  {22,  1,   0}, // #3663
  {23,  2,   0}, // #3664
  { 8,  1,   0}, // #3665
  {13,  1,   0}, // #3666
  {15,  1,   0}, // #3667
  {17,  1,   0}, // #3668
  {18,  1,   0}, // #3669
  {19,  1,   0}, // #3670
  {20,  1,   0}, // #3671
  {21,  1,   0}, // #3672
  {22,  1,   0}, // #3673
  {23,  2,   0}, // #3674
  { 8,  2,   0}, // #3675
  {13,  2,   0}, // #3676
  {15,  2,   0}, // #3677
  {17,  1,   0}, // #3678
  {18,  2,   0}, // #3679
  {19,  2,   0}, // #3680
  {20,  2,   0}, // #3681
  {21,  1,   0}, // #3682
  {22,  2,   0}, // #3683
  {23,  3,   0}, // #3684
  { 8,  2,   0}, // #3685
  {13,  2,   0}, // #3686
  {15,  2,   0}, // #3687
  {18,  2,   0}, // #3688
  {19,  2,   0}, // #3689
  {20,  2,   0}, // #3690
  {22,  2,   0}, // #3691
  {23,  2,   0}, // #3692
  { 3,  2,   0}, // #3693
  { 8,  7,   0}, // #3694
  {11,  2,   0}, // #3695
  {12,  2,   0}, // #3696
  {13,  9,   0}, // #3697
  {14,  2,   0}, // #3698
  {15,  7,   0}, // #3699
  {17,  1,   0}, // #3700
  {18,  7,   0}, // #3701
  {19, 10,   0}, // #3702
  {20,  9,   0}, // #3703
  {21,  1,   0}, // #3704
  {22, 10,   0}, // #3705
  {23, 11,   0}, // #3706
  { 3,  2,   0}, // #3707
  { 8,  7,   0}, // #3708
  {11,  2,   0}, // #3709
  {12,  2,   0}, // #3710
  {13,  9,   0}, // #3711
  {14,  2,   0}, // #3712
  {15,  7,   0}, // #3713
  {18,  7,   0}, // #3714
  {19, 11,   0}, // #3715
  {20,  9,   0}, // #3716
  {22, 11,   0}, // #3717
  {23, 11,   0}, // #3718
  {14,  1,   0}, // #3719
  {15,  1,   0}, // #3720
  {17,  1,   0}, // #3721
  {19,  1,   0}, // #3722
  {20,  1,   0}, // #3723
  {21,  1,   0}, // #3724
  {22,  2,   0}, // #3725
  {23,  3,   0}, // #3726
  {14,  1,   0}, // #3727
  {15,  1,   0}, // #3728
  {19,  1,   0}, // #3729
  {20,  1,   0}, // #3730
  {22,  2,   0}, // #3731
  {23,  2,   0}, // #3732
  {15,  1,   0}, // #3733
  {17,  1,   0}, // #3734
  {19,  1,   0}, // #3735
  {21,  1,   0}, // #3736
  {22,  1,   0}, // #3737
  {23,  2,   0}, // #3738
  { 7,  1,   0}, // #3739
  {12,  1,   0}, // #3740
  {14,  1,   0}, // #3741
  {17,  1,   0}, // #3742
  {20,  1,   0}, // #3743
  {21,  2,   0}, // #3744
  {22,  1,   0}, // #3745
  {23,  4,   0}, // #3746
  {22,  3,   0}, // #3747
  {23,  3,   0}, // #3748
  {14,  2,   0}, // #3749
  {20,  2,   0}, // #3750
  {22,  5,   0}, // #3751
  {23,  5,   0}, // #3752
  { 4,  1,   0}, // #3753
  { 8,  1,   0}, // #3754
  {11,  1,   0}, // #3755
  {13,  1,   0}, // #3756
  {15,  2,   0}, // #3757
  {16,  1,   0}, // #3758
  {17,  1,   0}, // #3759
  {18,  1,   0}, // #3760
  {19,  2,   0}, // #3761
  {20,  1,   0}, // #3762
  {21,  1,   0}, // #3763
  {22,  2,   0}, // #3764
  {23,  3,   0}, // #3765
  { 4,  1,   0}, // #3766
  { 8,  1,   0}, // #3767
  {11,  1,   0}, // #3768
  {13,  1,   0}, // #3769
  {15,  2,   0}, // #3770
  {16,  1,   0}, // #3771
  {18,  1,   0}, // #3772
  {19,  2,   0}, // #3773
  {20,  1,   0}, // #3774
  {22,  2,   0}, // #3775
  {23,  2,   0}, // #3776
  { 3,  1,   0}, // #3777
  {11,  1,   0}, // #3778
  {12,  1,   0}, // #3779
  {13,  1,   0}, // #3780
  {14,  1,   0}, // #3781
  {17,  1,   0}, // #3782
  {19,  1,   0}, // #3783
  {20,  1,   0}, // #3784
  {21,  1,   0}, // #3785
  {22,  1,   0}, // #3786
  {23,  2,   0}, // #3787
  { 3,  1,   0}, // #3788
  { 8,  1,   0}, // #3789
  {11,  1,   0}, // #3790
  {12,  1,   0}, // #3791
  {13,  2,   0}, // #3792
  {14,  1,   0}, // #3793
  {15,  1,   0}, // #3794
  {18,  1,   0}, // #3795
  {19,  2,   0}, // #3796
  {20,  2,   0}, // #3797
  {22,  2,   0}, // #3798
  {23,  2,   0}, // #3799
  { 3,  1,   0}, // #3800
  { 4,  1,   0}, // #3801
  {11,  2,   0}, // #3802
  {12,  1,   0}, // #3803
  {13,  1,   0}, // #3804
  {14,  1,   0}, // #3805
  {15,  1,   0}, // #3806
  {16,  1,   0}, // #3807
  {17,  1,   0}, // #3808
  {19,  2,   0}, // #3809
  {20,  1,   0}, // #3810
  {21,  1,   0}, // #3811
  {22,  2,   0}, // #3812
  {23,  3,   0}, // #3813
  { 3,  1,   0}, // #3814
  { 4,  1,   0}, // #3815
  {11,  2,   0}, // #3816
  {12,  1,   0}, // #3817
  {13,  1,   0}, // #3818
  {14,  1,   0}, // #3819
  {15,  1,   0}, // #3820
  {16,  1,   0}, // #3821
  {19,  2,   0}, // #3822
  {20,  1,   0}, // #3823
  {22,  2,   0}, // #3824
  {23,  2,   0}, // #3825
  { 3,  2,   0}, // #3826
  { 4,  2,   0}, // #3827
  { 8,  2,   0}, // #3828
  {11,  4,   0}, // #3829
  {12,  2,   0}, // #3830
  {13,  4,   0}, // #3831
  {14,  2,   0}, // #3832
  {15,  4,   0}, // #3833
  {16,  2,   0}, // #3834
  {17,  1,   0}, // #3835
  {18,  2,   0}, // #3836
  {19,  6,   0}, // #3837
  {20,  4,   0}, // #3838
  {21,  1,   0}, // #3839
  {22,  7,   0}, // #3840
  {23,  8,   0}, // #3841
  { 3,  7,   0}, // #3842
  { 4,  7,   0}, // #3843
  { 8,  3,   0}, // #3844
  { 9,  3,   0}, // #3845
  {11, 15,   0}, // #3846
  {12,  7,   0}, // #3847
  {13, 10,   0}, // #3848
  {14, 10,   0}, // #3849
  {15, 10,   0}, // #3850
  {16, 10,   0}, // #3851
  {18,  6,   0}, // #3852
  {19, 18,   0}, // #3853
  {20, 13,   0}, // #3854
  {22, 32,   0}, // #3855
  {23, 32,   0}, // #3856
  { 1, 10,   0}, // #3857
  { 3,  1,   0}, // #3858
  {11,  1,   0}, // #3859
  {12,  1,   0}, // #3860
  {13,  1,   0}, // #3861
  {14,  1,   0}, // #3862
  {19,  1,   0}, // #3863
  {20,  1,   0}, // #3864
  {22,  1,   0}, // #3865
  {23,  1,   0}, // #3866
  { 2,  8,   0}, // #3867
  { 3,  1,   0}, // #3868
  {11,  1,   0}, // #3869
  {12,  1,   0}, // #3870
  {13,  1,   0}, // #3871
  {14,  1,   0}, // #3872
  {17,  1,   0}, // #3873
  {19,  1,   0}, // #3874
  {20,  1,   0}, // #3875
  {21,  1,   0}, // #3876
  {22,  1,   0}, // #3877
  {23,  2,   0}, // #3878
  { 2,  8,   0}, // #3879
  { 3,  1,   0}, // #3880
  {11,  1,   0}, // #3881
  {12,  1,   0}, // #3882
  {13,  1,   0}, // #3883
  {14,  1,   0}, // #3884
  {19,  1,   0}, // #3885
  {20,  1,   0}, // #3886
  {22,  1,   0}, // #3887
  {23,  1,   0}, // #3888
  { 2,  5,   0}, // #3889
  { 3,  1,   0}, // #3890
  {11,  1,   0}, // #3891
  {12,  1,   0}, // #3892
  {13,  1,   0}, // #3893
  {14,  1,   0}, // #3894
  {17,  1,   0}, // #3895
  {19,  1,   0}, // #3896
  {20,  1,   0}, // #3897
  {21,  1,   0}, // #3898
  {22,  1,   0}, // #3899
  {23,  2,   0}, // #3900
  { 2,  5,   0}, // #3901
  { 3,  1,   0}, // #3902
  {11,  1,   0}, // #3903
  {12,  1,   0}, // #3904
  {13,  1,   0}, // #3905
  {14,  1,   0}, // #3906
  {19,  1,   0}, // #3907
  {20,  1,   0}, // #3908
  {22,  1,   0}, // #3909
  {23,  1,   0}, // #3910
  { 2,  3,   0}, // #3911
  { 3,  1,   0}, // #3912
  {11,  1,   0}, // #3913
  {12,  1,   0}, // #3914
  {13,  1,   0}, // #3915
  {14,  1,   0}, // #3916
  {19,  1,   0}, // #3917
  {20,  1,   0}, // #3918
  {22,  1,   0}, // #3919
  {23,  1,   0}, // #3920
  { 2,  4,   0}, // #3921
  { 3,  1,   0}, // #3922
  {11,  1,   0}, // #3923
  {12,  1,   0}, // #3924
  {13,  1,   0}, // #3925
  {14,  1,   0}, // #3926
  {19,  1,   0}, // #3927
  {20,  1,   0}, // #3928
  {22,  1,   0}, // #3929
  {23,  1,   0}, // #3930
  { 3,  1,   0}, // #3931
  { 4,  1,   0}, // #3932
  { 8,  1,   0}, // #3933
  {11,  2,   0}, // #3934
  {12,  1,   0}, // #3935
  {13,  2,   0}, // #3936
  {14,  1,   0}, // #3937
  {15,  2,   0}, // #3938
  {16,  1,   0}, // #3939
  {17,  1,   0}, // #3940
  {18,  1,   0}, // #3941
  {19,  3,   0}, // #3942
  {20,  2,   0}, // #3943
  {21,  1,   0}, // #3944
  {22,  3,   0}, // #3945
  {23,  4,   0}, // #3946
  { 3,  1,   0}, // #3947
  { 4,  1,   0}, // #3948
  { 8,  1,   0}, // #3949
  {11,  2,   0}, // #3950
  {12,  1,   0}, // #3951
  {13,  2,   0}, // #3952
  {14,  1,   0}, // #3953
  {15,  2,   0}, // #3954
  {16,  1,   0}, // #3955
  {18,  1,   0}, // #3956
  {19,  3,   0}, // #3957
  {20,  2,   0}, // #3958
  {22,  3,   0}, // #3959
  {23,  3,   0}, // #3960
  { 3,  2,   0}, // #3961
  { 4,  1,   0}, // #3962
  { 8,  1,   0}, // #3963
  {11,  3,   0}, // #3964
  {12,  2,   0}, // #3965
  {13,  3,   0}, // #3966
  {14,  3,   0}, // #3967
  {15,  2,   0}, // #3968
  {16,  1,   0}, // #3969
  {17,  1,   0}, // #3970
  {18,  1,   0}, // #3971
  {19,  4,   0}, // #3972
  {20,  4,   0}, // #3973
  {21,  1,   0}, // #3974
  {22,  5,   0}, // #3975
  {23,  6,   0}, // #3976
  { 3,  2,   0}, // #3977
  { 4,  1,   0}, // #3978
  { 8,  1,   0}, // #3979
  {11,  3,   0}, // #3980
  {12,  2,   0}, // #3981
  {13,  3,   0}, // #3982
  {14,  2,   0}, // #3983
  {15,  2,   0}, // #3984
  {16,  1,   0}, // #3985
  {18,  1,   0}, // #3986
  {19,  4,   0}, // #3987
  {20,  3,   0}, // #3988
  {22,  4,   0}, // #3989
  {23,  4,   0}, // #3990
  { 7,  1,   0}, // #3991
  { 8,  1,   0}, // #3992
  {12,  1,   0}, // #3993
  {13,  1,   0}, // #3994
  {15,  1,   0}, // #3995
  {18,  1,   0}, // #3996
  {19,  1,   0}, // #3997
  {20,  1,   0}, // #3998
  {21,  1,   0}, // #3999
  {22,  1,   0}, // #4000
  {23,  3,   0}, // #4001
  {11,  8,   0}, // #4002
  {15,  1,   0}, // #4003
  {19, 30,   0}, // #4004
  {22, 31,   0}, // #4005
  {23, 31,   0}, // #4006
  {11,  2,   0}, // #4007
  {19,  2,   0}, // #4008
  {22,  2,   0}, // #4009
  {23,  2,   0}, // #4010
  { 4,  1,   0}, // #4011
  { 8,  2,   0}, // #4012
  {11,  1,   0}, // #4013
  {13,  2,   0}, // #4014
  {15,  3,   0}, // #4015
  {16,  1,   0}, // #4016
  {17,  1,   0}, // #4017
  {18,  2,   0}, // #4018
  {19,  3,   0}, // #4019
  {20,  2,   0}, // #4020
  {21,  1,   0}, // #4021
  {22,  3,   0}, // #4022
  {23,  4,   0}, // #4023
  { 4,  1,   0}, // #4024
  { 8,  2,   0}, // #4025
  {11,  1,   0}, // #4026
  {13,  2,   0}, // #4027
  {15,  3,   0}, // #4028
  {16,  1,   0}, // #4029
  {18,  2,   0}, // #4030
  {19,  3,   0}, // #4031
  {20,  2,   0}, // #4032
  {22,  3,   0}, // #4033
  {23,  3,   0}, // #4034
  { 4,  1,   0}, // #4035
  {11,  1,   0}, // #4036
  {14,  1,   0}, // #4037
  {15,  1,   0}, // #4038
  {16,  1,   0}, // #4039
  {17,  1,   0}, // #4040
  {19,  1,   0}, // #4041
  {20,  1,   0}, // #4042
  {21,  1,   0}, // #4043
  {22,  4,   0}, // #4044
  {23,  5,   0}, // #4045
  { 4,  1,   0}, // #4046
  {11,  1,   0}, // #4047
  {14,  1,   0}, // #4048
  {15,  1,   0}, // #4049
  {16,  1,   0}, // #4050
  {19,  1,   0}, // #4051
  {20,  1,   0}, // #4052
  {22,  4,   0}, // #4053
  {23,  4,   0}, // #4054
  { 4,  1,   0}, // #4055
  {11,  1,   0}, // #4056
  {15,  1,   0}, // #4057
  {16,  1,   0}, // #4058
  {17,  1,   0}, // #4059
  {19,  1,   0}, // #4060
  {21,  1,   0}, // #4061
  {22,  2,   0}, // #4062
  {23,  3,   0}, // #4063
  { 4,  1,   0}, // #4064
  {11,  1,   0}, // #4065
  {15,  1,   0}, // #4066
  {16,  1,   0}, // #4067
  {19,  1,   0}, // #4068
  {22,  2,   0}, // #4069
  {23,  2,   0}, // #4070
  { 4,  1,   0}, // #4071
  {11,  1,   0}, // #4072
  {14,  1,   0}, // #4073
  {15,  1,   0}, // #4074
  {16,  1,   0}, // #4075
  {17,  1,   0}, // #4076
  {19,  1,   0}, // #4077
  {20,  1,   0}, // #4078
  {21,  1,   0}, // #4079
  {22,  3,   0}, // #4080
  {23,  4,   0}, // #4081
  { 4,  1,   0}, // #4082
  {11,  1,   0}, // #4083
  {14,  1,   0}, // #4084
  {15,  1,   0}, // #4085
  {16,  1,   0}, // #4086
  {19,  1,   0}, // #4087
  {20,  1,   0}, // #4088
  {22,  3,   0}, // #4089
  {23,  3,   0}, // #4090
  { 3,  1,   0}, // #4091
  {11,  1,   0}, // #4092
  {12,  1,   0}, // #4093
  {13,  1,   0}, // #4094
  {14,  1,   0}, // #4095
  {17,  1,   0}, // #4096
  {19,  1,   0}, // #4097
  {20,  1,   0}, // #4098
  {21,  1,   0}, // #4099
  {22,  2,   0}, // #4100
  {23,  3,   0}, // #4101
  {11,  1,   0}, // #4102
  {19,  1,   0}, // #4103
  {22,  1,   0}, // #4104
  {23,  1,   0}, // #4105
  { 7,  1,   0}, // #4106
  {12,  1,   0}, // #4107
  {17,  1,   0}, // #4108
  {21,  1,   0}, // #4109
  {23,  2,   0}, // #4110
  { 8,  2,   0}, // #4111
  {13,  2,   0}, // #4112
  {15,  3,   0}, // #4113
  {17,  1,   0}, // #4114
  {18,  2,   0}, // #4115
  {19,  3,   0}, // #4116
  {20,  2,   0}, // #4117
  {21,  1,   0}, // #4118
  {22,  3,   0}, // #4119
  {23,  4,   0}, // #4120
  { 8,  2,   0}, // #4121
  {13,  2,   0}, // #4122
  {15,  3,   0}, // #4123
  {18,  2,   0}, // #4124
  {19,  3,   0}, // #4125
  {20,  2,   0}, // #4126
  {22,  3,   0}, // #4127
  {23,  3,   0}, // #4128
  { 3,  1,   0}, // #4129
  { 8,  2,   0}, // #4130
  {11,  1,   0}, // #4131
  {12,  1,   0}, // #4132
  {13,  3,   0}, // #4133
  {14,  1,   0}, // #4134
  {15,  2,   0}, // #4135
  {17,  1,   0}, // #4136
  {18,  2,   0}, // #4137
  {19,  3,   0}, // #4138
  {20,  3,   0}, // #4139
  {21,  1,   0}, // #4140
  {22,  3,   0}, // #4141
  {23,  4,   0}, // #4142
  { 3,  1,   0}, // #4143
  { 8,  2,   0}, // #4144
  {11,  1,   0}, // #4145
  {12,  1,   0}, // #4146
  {13,  3,   0}, // #4147
  {14,  1,   0}, // #4148
  {15,  2,   0}, // #4149
  {18,  2,   0}, // #4150
  {19,  3,   0}, // #4151
  {20,  3,   0}, // #4152
  {22,  3,   0}, // #4153
  {23,  3,   0}, // #4154
  {11,  1,   0}, // #4155
  {17,  1,   0}, // #4156
  {19,  1,   0}, // #4157
  {21,  1,   0}, // #4158
  {22,  1,   0}, // #4159
  {23,  2,   0}, // #4160
  { 3,  4,   0}, // #4161
  { 8,  3,   0}, // #4162
  {11,  4,   0}, // #4163
  {12,  4,   0}, // #4164
  {13,  7,   0}, // #4165
  {14,  4,   0}, // #4166
  {15,  3,   0}, // #4167
  {17,  1,   0}, // #4168
  {18,  3,   0}, // #4169
  {19,  7,   0}, // #4170
  {20,  7,   0}, // #4171
  {21,  1,   0}, // #4172
  {22,  8,   0}, // #4173
  {23,  9,   0}, // #4174
  { 3,  4,   0}, // #4175
  { 8,  3,   0}, // #4176
  {11,  4,   0}, // #4177
  {12,  4,   0}, // #4178
  {13,  7,   0}, // #4179
  {14,  4,   0}, // #4180
  {15,  3,   0}, // #4181
  {18,  3,   0}, // #4182
  {19,  7,   0}, // #4183
  {20,  7,   0}, // #4184
  {22,  8,   0}, // #4185
  {23,  8,   0}, // #4186
  { 3,  4,   0}, // #4187
  { 8,  3,   0}, // #4188
  {11,  4,   0}, // #4189
  {12,  4,   0}, // #4190
  {13,  7,   0}, // #4191
  {14,  4,   0}, // #4192
  {15,  3,   0}, // #4193
  {17,  1,   0}, // #4194
  {18,  3,   0}, // #4195
  {19,  8,   0}, // #4196
  {20,  7,   0}, // #4197
  {21,  1,   0}, // #4198
  {22,  9,   0}, // #4199
  {23, 10,   0}, // #4200
  { 3,  4,   0}, // #4201
  { 8,  3,   0}, // #4202
  {11,  4,   0}, // #4203
  {12,  4,   0}, // #4204
  {13,  7,   0}, // #4205
  {14,  4,   0}, // #4206
  {15,  3,   0}, // #4207
  {18,  3,   0}, // #4208
  {19,  8,   0}, // #4209
  {20,  7,   0}, // #4210
  {22,  9,   0}, // #4211
  {23,  9,   0}, // #4212
  { 3,  3,   0}, // #4213
  {11,  3,   0}, // #4214
  {12,  3,   0}, // #4215
  {13,  3,   0}, // #4216
  {14,  3,   0}, // #4217
  {17,  1,   0}, // #4218
  {19,  3,   0}, // #4219
  {20,  3,   0}, // #4220
  {21,  1,   0}, // #4221
  {22,  3,   0}, // #4222
  {23,  4,   0}, // #4223
  { 3,  3,   0}, // #4224
  {11,  3,   0}, // #4225
  {12,  3,   0}, // #4226
  {13,  3,   0}, // #4227
  {14,  3,   0}, // #4228
  {19,  3,   0}, // #4229
  {20,  3,   0}, // #4230
  {22,  3,   0}, // #4231
  {23,  3,   0}, // #4232
  { 3,  2,   0}, // #4233
  {11,  2,   0}, // #4234
  {12,  2,   0}, // #4235
  {13,  2,   0}, // #4236
  {14,  2,   0}, // #4237
  {17,  1,   0}, // #4238
  {19,  2,   0}, // #4239
  {20,  2,   0}, // #4240
  {21,  1,   0}, // #4241
  {22,  2,   0}, // #4242
  {23,  3,   0}, // #4243
  { 3,  2,   0}, // #4244
  {11,  2,   0}, // #4245
  {12,  2,   0}, // #4246
  {13,  2,   0}, // #4247
  {14,  2,   0}, // #4248
  {19,  2,   0}, // #4249
  {20,  2,   0}, // #4250
  {22,  2,   0}, // #4251
  {23,  2,   0}, // #4252
  { 7,  1,   0}, // #4253
  {12,  1,   0}, // #4254
  {17,  1,   0}, // #4255
  {21,  2,   0}, // #4256
  {23,  3,   0}, // #4257
  { 3,  1,   0}, // #4258
  { 8,  1,   0}, // #4259
  {11,  1,   0}, // #4260
  {12,  1,   0}, // #4261
  {13,  2,   0}, // #4262
  {14,  1,   0}, // #4263
  {15,  1,   0}, // #4264
  {17,  1,   0}, // #4265
  {18,  1,   0}, // #4266
  {19,  2,   0}, // #4267
  {20,  2,   0}, // #4268
  {21,  1,   0}, // #4269
  {22,  2,   0}, // #4270
  {23,  3,   0}, // #4271
  {14,  2,   0}, // #4272
  {17,  1,   0}, // #4273
  {20,  2,   0}, // #4274
  {21,  1,   0}, // #4275
  {22,  2,   0}, // #4276
  {23,  3,   0}, // #4277
  {14,  4,   0}, // #4278
  {17,  1,   0}, // #4279
  {20,  4,   0}, // #4280
  {21,  1,   0}, // #4281
  {22,  6,   0}, // #4282
  {23,  7,   0}, // #4283
  {14,  2,   0}, // #4284
  {20,  2,   0}, // #4285
  {22,  3,   0}, // #4286
  {23,  3,   0}, // #4287
  { 4,  2,   0}, // #4288
  {11,  2,   0}, // #4289
  {15,  2,   0}, // #4290
  {16,  2,   0}, // #4291
  {17,  1,   0}, // #4292
  {19,  2,   0}, // #4293
  {21,  1,   0}, // #4294
  {22,  2,   0}, // #4295
  {23,  3,   0}, // #4296
  { 4,  2,   0}, // #4297
  {11,  2,   0}, // #4298
  {15,  2,   0}, // #4299
  {16,  2,   0}, // #4300
  {19,  2,   0}, // #4301
  {22,  2,   0}, // #4302
  {23,  2,   0}, // #4303
  { 7,  1,   0}, // #4304
  {12,  1,   0}, // #4305
  {14,  1,   0}, // #4306
  {20,  1,   0}, // #4307
  {21,  1,   0}, // #4308
  {22,  1,   0}, // #4309
  {23,  3,   0}, // #4310
  { 4,  1,   0}, // #4311
  {11,  1,   0}, // #4312
  {14,  1,   0}, // #4313
  {15,  1,   0}, // #4314
  {16,  1,   0}, // #4315
  {17,  1,   0}, // #4316
  {19,  1,   0}, // #4317
  {20,  1,   0}, // #4318
  {21,  2,   0}, // #4319
  {22,  4,   0}, // #4320
  {23,  6,   0}, // #4321
  { 4,  1,   0}, // #4322
  {11,  1,   0}, // #4323
  {15,  1,   0}, // #4324
  {16,  1,   0}, // #4325
  {17,  1,   0}, // #4326
  {19,  1,   0}, // #4327
  {21,  2,   0}, // #4328
  {22,  2,   0}, // #4329
  {23,  4,   0}, // #4330
  { 2, 14,   0}, // #4331
  { 3,  1,   0}, // #4332
  {11,  1,   0}, // #4333
  {12,  1,   0}, // #4334
  {13,  1,   0}, // #4335
  {14,  1,   0}, // #4336
  {17,  1,   0}, // #4337
  {19,  1,   0}, // #4338
  {20,  1,   0}, // #4339
  {21,  1,   0}, // #4340
  {22,  1,   0}, // #4341
  {23,  2,   0}, // #4342
  { 2, 14,   0}, // #4343
  { 3,  1,   0}, // #4344
  {11,  1,   0}, // #4345
  {12,  1,   0}, // #4346
  {13,  1,   0}, // #4347
  {14,  1,   0}, // #4348
  {19,  1,   0}, // #4349
  {20,  1,   0}, // #4350
  {22,  1,   0}, // #4351
  {23,  1,   0}, // #4352
  { 2,  7,   0}, // #4353
  { 3,  1,   0}, // #4354
  {11,  1,   0}, // #4355
  {12,  1,   0}, // #4356
  {13,  1,   0}, // #4357
  {14,  1,   0}, // #4358
  {17,  1,   0}, // #4359
  {19,  1,   0}, // #4360
  {20,  1,   0}, // #4361
  {21,  1,   0}, // #4362
  {22,  1,   0}, // #4363
  {23,  2,   0}, // #4364
  { 2,  7,   0}, // #4365
  { 3,  1,   0}, // #4366
  {11,  1,   0}, // #4367
  {12,  1,   0}, // #4368
  {13,  1,   0}, // #4369
  {14,  1,   0}, // #4370
  {19,  1,   0}, // #4371
  {20,  1,   0}, // #4372
  {22,  1,   0}, // #4373
  {23,  1,   0}, // #4374
  { 2,  9,   0}, // #4375
  { 3,  1,   0}, // #4376
  {11,  1,   0}, // #4377
  {12,  1,   0}, // #4378
  {13,  1,   0}, // #4379
  {14,  1,   0}, // #4380
  {19,  1,   0}, // #4381
  {20,  1,   0}, // #4382
  {22,  1,   0}, // #4383
  {23,  1,   0}, // #4384
  { 4,  1,   0}, // #4385
  { 7,  1,   0}, // #4386
  {11,  1,   0}, // #4387
  {12,  1,   0}, // #4388
  {15,  1,   0}, // #4389
  {16,  1,   0}, // #4390
  {19,  1,   0}, // #4391
  {21,  1,   0}, // #4392
  {22,  1,   0}, // #4393
  {23,  3,   0}, // #4394
  { 2, 16,   0}, // #4395
  { 3,  2,   0}, // #4396
  {11,  2,   0}, // #4397
  {12,  2,   0}, // #4398
  {13,  2,   0}, // #4399
  {14,  2,   0}, // #4400
  {17,  1,   0}, // #4401
  {19,  3,   0}, // #4402
  {20,  2,   0}, // #4403
  {21,  1,   0}, // #4404
  {22,  3,   0}, // #4405
  {23,  4,   0}, // #4406
  { 2, 16,   0}, // #4407
  { 3,  2,   0}, // #4408
  {11,  2,   0}, // #4409
  {12,  2,   0}, // #4410
  {13,  2,   0}, // #4411
  {14,  2,   0}, // #4412
  {19,  3,   0}, // #4413
  {20,  2,   0}, // #4414
  {22,  3,   0}, // #4415
  {23,  3,   0}, // #4416
  { 2, 10,   0}, // #4417
  { 3,  2,   0}, // #4418
  {11,  2,   0}, // #4419
  {12,  2,   0}, // #4420
  {13,  2,   0}, // #4421
  {14,  2,   0}, // #4422
  {17,  1,   0}, // #4423
  {19,  3,   0}, // #4424
  {20,  2,   0}, // #4425
  {21,  1,   0}, // #4426
  {22,  3,   0}, // #4427
  {23,  4,   0}, // #4428
  { 2, 10,   0}, // #4429
  { 3,  2,   0}, // #4430
  {11,  2,   0}, // #4431
  {12,  2,   0}, // #4432
  {13,  2,   0}, // #4433
  {14,  2,   0}, // #4434
  {19,  3,   0}, // #4435
  {20,  2,   0}, // #4436
  {22,  3,   0}, // #4437
  {23,  3,   0}, // #4438
  { 3,  1,   0}, // #4439
  { 7,  1,   0}, // #4440
  {11,  1,   0}, // #4441
  {12,  2,   0}, // #4442
  {13,  1,   0}, // #4443
  {14,  1,   0}, // #4444
  {15,  1,   0}, // #4445
  {19,  2,   0}, // #4446
  {20,  1,   0}, // #4447
  {21,  1,   0}, // #4448
  {22,  2,   0}, // #4449
  {23,  4,   0}, // #4450
  { 3,  2,   0}, // #4451
  { 8,  1,   0}, // #4452
  {11,  2,   0}, // #4453
  {12,  2,   0}, // #4454
  {13,  3,   0}, // #4455
  {14,  2,   0}, // #4456
  {15,  1,   0}, // #4457
  {17,  1,   0}, // #4458
  {18,  1,   0}, // #4459
  {19,  3,   0}, // #4460
  {20,  3,   0}, // #4461
  {21,  1,   0}, // #4462
  {22,  3,   0}, // #4463
  {23,  4,   0}, // #4464
  { 3,  2,   0}, // #4465
  { 8,  1,   0}, // #4466
  {11,  2,   0}, // #4467
  {12,  2,   0}, // #4468
  {13,  3,   0}, // #4469
  {14,  2,   0}, // #4470
  {15,  1,   0}, // #4471
  {18,  1,   0}, // #4472
  {19,  3,   0}, // #4473
  {20,  3,   0}, // #4474
  {22,  3,   0}, // #4475
  {23,  3,   0}, // #4476
  { 2, 28,   0}, // #4477
  { 3,  2,   0}, // #4478
  {11,  2,   0}, // #4479
  {12,  2,   0}, // #4480
  {13,  2,   0}, // #4481
  {14,  2,   0}, // #4482
  {17,  1,   0}, // #4483
  {19,  3,   0}, // #4484
  {20,  2,   0}, // #4485
  {21,  1,   0}, // #4486
  {22,  3,   0}, // #4487
  {23,  4,   0}, // #4488
  { 2, 28,   0}, // #4489
  { 3,  2,   0}, // #4490
  {11,  2,   0}, // #4491
  {12,  2,   0}, // #4492
  {13,  2,   0}, // #4493
  {14,  2,   0}, // #4494
  {19,  3,   0}, // #4495
  {20,  2,   0}, // #4496
  {22,  3,   0}, // #4497
  {23,  3,   0}, // #4498
  { 2, 14,   0}, // #4499
  { 3,  2,   0}, // #4500
  {11,  2,   0}, // #4501
  {12,  2,   0}, // #4502
  {13,  2,   0}, // #4503
  {14,  2,   0}, // #4504
  {17,  1,   0}, // #4505
  {19,  3,   0}, // #4506
  {20,  2,   0}, // #4507
  {21,  1,   0}, // #4508
  {22,  3,   0}, // #4509
  {23,  4,   0}, // #4510
  { 2, 14,   0}, // #4511
  { 3,  2,   0}, // #4512
  {11,  2,   0}, // #4513
  {12,  2,   0}, // #4514
  {13,  2,   0}, // #4515
  {14,  2,   0}, // #4516
  {19,  3,   0}, // #4517
  {20,  2,   0}, // #4518
  {22,  3,   0}, // #4519
  {23,  3,   0}, // #4520
  {14,  1,   0}, // #4521
  {17,  1,   0}, // #4522
  {20,  1,   0}, // #4523
  {21,  2,   0}, // #4524
  {22,  3,   0}, // #4525
  {23,  5,   0}, // #4526
  { 4,  2,   0}, // #4527
  {11,  2,   0}, // #4528
  {14,  3,   0}, // #4529
  {15,  3,   0}, // #4530
  {16,  2,   0}, // #4531
  {17,  1,   0}, // #4532
  {19,  3,   0}, // #4533
  {20,  3,   0}, // #4534
  {21,  2,   0}, // #4535
  {22,  9,   0}, // #4536
  {23, 11,   0}, // #4537
  { 3,  2,   0}, // #4538
  { 4,  1,   0}, // #4539
  { 9,  4,   0}, // #4540
  {11,  3,   0}, // #4541
  {12,  2,   0}, // #4542
  {13,  2,   0}, // #4543
  {14,  6,   0}, // #4544
  {15,  1,   0}, // #4545
  {16,  5,   0}, // #4546
  {18,  4,   0}, // #4547
  {19,  3,   0}, // #4548
  {20,  6,   0}, // #4549
  {22, 12,   0}, // #4550
  {23, 12,   0}, // #4551
  {17,  1,   0}, // #4552
  {21,  1,   0}, // #4553
  {22,  2,   0}, // #4554
  {23,  3,   0}, // #4555
  { 9,  1,   0}, // #4556
  {14,  1,   0}, // #4557
  {16,  1,   0}, // #4558
  {18,  1,   0}, // #4559
  {20,  1,   0}, // #4560
  {22,  3,   0}, // #4561
  {23,  3,   0}, // #4562
  { 7,  1,   0}, // #4563
  {12,  1,   0}, // #4564
  {17,  1,   0}, // #4565
  {21,  2,   0}, // #4566
  {22,  3,   0}, // #4567
  {23,  6,   0}, // #4568
  {14,  1,   0}, // #4569
  {20,  1,   0}, // #4570
  {22,  2,   0}, // #4571
  {23,  2,   0}, // #4572
  { 3,  1,   0}, // #4573
  {11,  2,   0}, // #4574
  {12,  1,   0}, // #4575
  {13,  1,   0}, // #4576
  {14,  1,   0}, // #4577
  {17,  1,   0}, // #4578
  {19,  2,   0}, // #4579
  {20,  1,   0}, // #4580
  {21,  1,   0}, // #4581
  {22,  2,   0}, // #4582
  {23,  3,   0}, // #4583
  {14,  2,   0}, // #4584
  {20,  2,   0}, // #4585
  {22, 11,   0}, // #4586
  {23, 11,   0}, // #4587
  { 7,  1,   0}, // #4588
  { 9,  1,   0}, // #4589
  {12,  1,   0}, // #4590
  {14,  1,   0}, // #4591
  {16,  1,   0}, // #4592
  {18,  1,   0}, // #4593
  {20,  1,   0}, // #4594
  {21,  1,   0}, // #4595
  {22,  1,   0}, // #4596
  {23,  3,   0}, // #4597
  { 9,  1,   0}, // #4598
  {14,  1,   0}, // #4599
  {16,  1,   0}, // #4600
  {18,  1,   0}, // #4601
  {20,  1,   0}, // #4602
  {22,  5,   0}, // #4603
  {23,  5,   0}, // #4604
  { 7,  1,   0}, // #4605
  {12,  1,   0}, // #4606
  {14,  4,   0}, // #4607
  {15,  2,   0}, // #4608
  {17,  1,   0}, // #4609
  {19,  2,   0}, // #4610
  {20,  4,   0}, // #4611
  {21,  2,   0}, // #4612
  {22, 11,   0}, // #4613
  {23, 14,   0}, // #4614
  { 9,  2,   0}, // #4615
  {14,  4,   0}, // #4616
  {15,  1,   0}, // #4617
  {16,  2,   0}, // #4618
  {18,  2,   0}, // #4619
  {19,  1,   0}, // #4620
  {20,  4,   0}, // #4621
  {22,  7,   0}, // #4622
  {23,  7,   0}, // #4623
  { 9,  1,   0}, // #4624
  {14,  1,   0}, // #4625
  {16,  1,   0}, // #4626
  {18,  1,   0}, // #4627
  {20,  1,   0}, // #4628
  {22,  6,   0}, // #4629
  {23,  6,   0}, // #4630
  { 3,  2,   0}, // #4631
  { 7,  1,   0}, // #4632
  { 8,  4,   0}, // #4633
  {11,  2,   0}, // #4634
  {12,  3,   0}, // #4635
  {13,  6,   0}, // #4636
  {14,  6,   0}, // #4637
  {15,  4,   0}, // #4638
  {17,  1,   0}, // #4639
  {18,  4,   0}, // #4640
  {19,  6,   0}, // #4641
  {20, 10,   0}, // #4642
  {21,  2,   0}, // #4643
  {22, 16,   0}, // #4644
  {23, 19,   0}, // #4645
  { 8,  2,   0}, // #4646
  {13,  2,   0}, // #4647
  {15,  2,   0}, // #4648
  {18,  2,   0}, // #4649
  {19,  2,   0}, // #4650
  {20,  2,   0}, // #4651
  {22, 22,   0}, // #4652
  {23, 22,   0}, // #4653
  { 7,  1,   0}, // #4654
  { 8,  1,   0}, // #4655
  { 9,  1,   0}, // #4656
  {12,  1,   0}, // #4657
  {13,  1,   0}, // #4658
  {14,  2,   0}, // #4659
  {15,  1,   0}, // #4660
  {16,  1,   0}, // #4661
  {17,  1,   0}, // #4662
  {18,  2,   0}, // #4663
  {19,  1,   0}, // #4664
  {20,  3,   0}, // #4665
  {21,  2,   0}, // #4666
  {22,  5,   0}, // #4667
  {23,  8,   0}, // #4668
  { 8,  6,   0}, // #4669
  {11,  3,   0}, // #4670
  {13,  6,   0}, // #4671
  {15,  6,   0}, // #4672
  {18,  6,   0}, // #4673
  {19,  9,   0}, // #4674
  {20,  6,   0}, // #4675
  {22, 15,   0}, // #4676
  {23, 15,   0}, // #4677
  { 8,  1,   0}, // #4678
  { 9,  5,   0}, // #4679
  {13,  1,   0}, // #4680
  {14,  9,   0}, // #4681
  {15,  1,   0}, // #4682
  {16,  5,   0}, // #4683
  {17,  2,   0}, // #4684
  {18,  6,   0}, // #4685
  {19,  1,   0}, // #4686
  {20, 10,   0}, // #4687
  {21,  3,   0}, // #4688
  {22, 20,   0}, // #4689
  {23, 23,   0}, // #4690
  { 8,  1,   0}, // #4691
  { 9,  5,   0}, // #4692
  {13,  1,   0}, // #4693
  {14,  9,   0}, // #4694
  {15,  1,   0}, // #4695
  {16,  5,   0}, // #4696
  {17,  3,   0}, // #4697
  {18,  6,   0}, // #4698
  {19,  1,   0}, // #4699
  {20, 10,   0}, // #4700
  {21,  3,   0}, // #4701
  {22, 20,   0}, // #4702
  {23, 23,   0}, // #4703
  { 8,  1,   0}, // #4704
  { 9,  1,   0}, // #4705
  {13,  1,   0}, // #4706
  {14,  2,   0}, // #4707
  {15,  1,   0}, // #4708
  {16,  1,   0}, // #4709
  {18,  2,   0}, // #4710
  {19,  1,   0}, // #4711
  {20,  3,   0}, // #4712
  {22,  8,   0}, // #4713
  {23,  8,   0}, // #4714
  { 3,  4,   0}, // #4715
  { 9,  2,   0}, // #4716
  {11,  4,   0}, // #4717
  {12,  4,   0}, // #4718
  {13,  5,   0}, // #4719
  {14,  8,   0}, // #4720
  {15,  1,   0}, // #4721
  {16,  2,   0}, // #4722
  {17, 33,   0}, // #4723
  {18,  2,   0}, // #4724
  {19,  6,   0}, // #4725
  {20,  9,   0}, // #4726
  {21, 33,   0}, // #4727
  {22, 57,   0}, // #4728
  {23, 90,   0}, // #4729
  { 9,  1,   0}, // #4730
  {14,  1,   0}, // #4731
  {16,  1,   0}, // #4732
  {17,  1,   0}, // #4733
  {18,  1,   0}, // #4734
  {20,  1,   0}, // #4735
  {21,  1,   0}, // #4736
  {22,  2,   0}, // #4737
  {23,  3,   0}, // #4738
  { 3,  1,   0}, // #4739
  {11,  1,   0}, // #4740
  {12,  1,   0}, // #4741
  {13,  1,   0}, // #4742
  {14,  1,   0}, // #4743
  {19,  1,   0}, // #4744
  {20,  1,   0}, // #4745
  {22,  2,   0}, // #4746
  {23,  2,   0}, // #4747
  {11,  1,   0}, // #4748
  {19,  2,   0}, // #4749
  {22,  2,   0}, // #4750
  {23,  2,   0}, // #4751
  {14,  1,   0}, // #4752
  {20,  1,   0}, // #4753
  {22,  3,   0}, // #4754
  {23,  3,   0}, // #4755
  { 4,  2,   0}, // #4756
  {11,  2,   0}, // #4757
  {14,  4,   0}, // #4758
  {15,  2,   0}, // #4759
  {16,  2,   0}, // #4760
  {19,  2,   0}, // #4761
  {20,  4,   0}, // #4762
  {22,  8,   0}, // #4763
  {23,  8,   0}, // #4764
  { 7,  1,   0}, // #4765
  {12,  1,   0}, // #4766
  {21,  1,   0}, // #4767
  {22,  1,   0}, // #4768
  {23,  3,   0}, // #4769
  { 7,  1,   0}, // #4770
  {12,  1,   0}, // #4771
  {14,  1,   0}, // #4772
  {20,  1,   0}, // #4773
  {21,  1,   0}, // #4774
  {22,  2,   0}, // #4775
  {23,  4,   0}, // #4776
  { 7,  1,   0}, // #4777
  { 9,  1,   0}, // #4778
  {12,  1,   0}, // #4779
  {14,  1,   0}, // #4780
  {16,  1,   0}, // #4781
  {18,  1,   0}, // #4782
  {20,  1,   0}, // #4783
  {21,  1,   0}, // #4784
  {22,  2,   0}, // #4785
  {23,  4,   0}, // #4786
  { 7,  1,   0}, // #4787
  {12,  1,   0}, // #4788
  {21,  1,   0}, // #4789
  {22,  4,   0}, // #4790
  {23,  6,   0}, // #4791
  { 9,  1,   0}, // #4792
  {14,  1,   0}, // #4793
  {16,  1,   0}, // #4794
  {18,  1,   0}, // #4795
  {20,  1,   0}, // #4796
  {22,  2,   0}, // #4797
  {23,  2,   0}, // #4798
  { 9,  1,   0}, // #4799
  {14,  1,   0}, // #4800
  {16,  1,   0}, // #4801
  {17,  1,   0}, // #4802
  {18,  1,   0}, // #4803
  {20,  1,   0}, // #4804
  {21,  1,   0}, // #4805
  {22,  1,   0}, // #4806
  {23,  2,   0}, // #4807
  { 3,  1,   0}, // #4808
  { 7,  1,   0}, // #4809
  {11,  1,   0}, // #4810
  {12,  2,   0}, // #4811
  {13,  1,   0}, // #4812
  {14,  1,   0}, // #4813
  {19,  1,   0}, // #4814
  {20,  1,   0}, // #4815
  {21,  1,   0}, // #4816
  {22,  1,   0}, // #4817
  {23,  3,   0}, // #4818
  { 4,  1,   0}, // #4819
  { 9,  1,   0}, // #4820
  {11,  1,   0}, // #4821
  {14,  2,   0}, // #4822
  {15,  1,   0}, // #4823
  {16,  2,   0}, // #4824
  {18,  1,   0}, // #4825
  {19,  1,   0}, // #4826
  {20,  2,   0}, // #4827
  {22,  4,   0}, // #4828
  {23,  4,   0}, // #4829
  { 7,  1,   0}, // #4830
  { 9,  1,   0}, // #4831
  {12,  1,   0}, // #4832
  {14,  1,   0}, // #4833
  {16,  1,   0}, // #4834
  {17,  1,   0}, // #4835
  {18,  1,   0}, // #4836
  {20,  1,   0}, // #4837
  {21,  2,   0}, // #4838
  {22,  2,   0}, // #4839
  {23,  5,   0}, // #4840
  { 7,  1,   0}, // #4841
  {12,  1,   0}, // #4842
  {14,  2,   0}, // #4843
  {17,  1,   0}, // #4844
  {20,  2,   0}, // #4845
  {21,  2,   0}, // #4846
  {22,  2,   0}, // #4847
  {23,  5,   0}, // #4848
  { 7,  1,   0}, // #4849
  {12,  1,   0}, // #4850
  {17,  1,   0}, // #4851
  {21,  2,   0}, // #4852
  {22,  2,   0}, // #4853
  {23,  5,   0}, // #4854
  { 8,  1,   0}, // #4855
  { 9,  1,   0}, // #4856
  {13,  1,   0}, // #4857
  {14,  1,   0}, // #4858
  {15,  1,   0}, // #4859
  {16,  1,   0}, // #4860
  {18,  2,   0}, // #4861
  {19,  1,   0}, // #4862
  {20,  2,   0}, // #4863
  {22,  2,   0}, // #4864
  {23,  2,   0}, // #4865
  {14,  1,   0}, // #4866
  {17,  1,   0}, // #4867
  {20,  1,   0}, // #4868
  {21,  1,   0}, // #4869
  {22,  4,   0}, // #4870
  {23,  5,   0}, // #4871
  { 9,  1,   0}, // #4872
  {14,  1,   0}, // #4873
  {16,  1,   0}, // #4874
  {18,  1,   0}, // #4875
  {20,  1,   0}, // #4876
  {22,  1,   0}, // #4877
  {23,  1,   0}, // #4878
  { 7,  1,   0}, // #4879
  {12,  1,   0}, // #4880
  {15,  1,   0}, // #4881
  {19,  1,   0}, // #4882
  {21,  1,   0}, // #4883
  {22,  1,   0}, // #4884
  {23,  3,   0}, // #4885
  {14,  2,   0}, // #4886
  {20,  2,   0}, // #4887
  {22,  2,   0}, // #4888
  {23,  2,   0}, // #4889
  { 8,  2,   0}, // #4890
  {13,  2,   0}, // #4891
  {15,  2,   0}, // #4892
  {18,  2,   0}, // #4893
  {19,  2,   0}, // #4894
  {20,  2,   0}, // #4895
  {22,  3,   0}, // #4896
  {23,  3,   0}, // #4897
  { 8,  1,   0}, // #4898
  {13,  1,   0}, // #4899
  {15,  1,   0}, // #4900
  {17,  1,   0}, // #4901
  {18,  1,   0}, // #4902
  {19,  2,   0}, // #4903
  {20,  1,   0}, // #4904
  {21,  1,   0}, // #4905
  {22,  2,   0}, // #4906
  {23,  3,   0}, // #4907
  { 4,  2,   0}, // #4908
  { 9,  2,   0}, // #4909
  {11,  2,   0}, // #4910
  {14,  2,   0}, // #4911
  {15,  2,   0}, // #4912
  {16,  4,   0}, // #4913
  {17,  1,   0}, // #4914
  {18,  2,   0}, // #4915
  {19,  2,   0}, // #4916
  {20,  2,   0}, // #4917
  {21,  1,   0}, // #4918
  {22,  7,   0}, // #4919
  {23,  8,   0}, // #4920
  { 4,  1,   0}, // #4921
  { 9,  2,   0}, // #4922
  {11,  1,   0}, // #4923
  {14,  2,   0}, // #4924
  {15,  1,   0}, // #4925
  {16,  3,   0}, // #4926
  {17,  1,   0}, // #4927
  {18,  2,   0}, // #4928
  {19,  1,   0}, // #4929
  {20,  2,   0}, // #4930
  {21,  1,   0}, // #4931
  {22,  4,   0}, // #4932
  {23,  5,   0}, // #4933
  { 4,  1,   0}, // #4934
  { 9,  1,   0}, // #4935
  {11,  1,   0}, // #4936
  {14,  2,   0}, // #4937
  {15,  1,   0}, // #4938
  {16,  2,   0}, // #4939
  {18,  1,   0}, // #4940
  {19,  1,   0}, // #4941
  {20,  2,   0}, // #4942
  {22,  3,   0}, // #4943
  {23,  3,   0}, // #4944
  {14,  1,   0}, // #4945
  {20,  1,   0}, // #4946
  {22,  5,   0}, // #4947
  {23,  5,   0}, // #4948
  { 4,  1,   0}, // #4949
  {11,  1,   0}, // #4950
  {14,  4,   0}, // #4951
  {15,  2,   0}, // #4952
  {16,  1,   0}, // #4953
  {17,  1,   0}, // #4954
  {19,  2,   0}, // #4955
  {20,  4,   0}, // #4956
  {21,  2,   0}, // #4957
  {22,  8,   0}, // #4958
  {23, 10,   0}, // #4959
  { 4,  2,   0}, // #4960
  {11,  2,   0}, // #4961
  {14,  2,   0}, // #4962
  {15,  2,   0}, // #4963
  {16,  2,   0}, // #4964
  {19,  2,   0}, // #4965
  {20,  2,   0}, // #4966
  {22,  7,   0}, // #4967
  {23,  7,   0}, // #4968
  { 4,  1,   0}, // #4969
  {11,  1,   0}, // #4970
  {14,  4,   0}, // #4971
  {15,  2,   0}, // #4972
  {16,  1,   0}, // #4973
  {19,  2,   0}, // #4974
  {20,  4,   0}, // #4975
  {22,  9,   0}, // #4976
  {23,  9,   0}, // #4977
  { 4,  2,   0}, // #4978
  {11,  2,   0}, // #4979
  {14,  3,   0}, // #4980
  {15,  3,   0}, // #4981
  {16,  2,   0}, // #4982
  {19,  3,   0}, // #4983
  {20,  3,   0}, // #4984
  {22, 10,   0}, // #4985
  {23, 10,   0}, // #4986
  { 9,  3,   0}, // #4987
  {14,  3,   0}, // #4988
  {16,  3,   0}, // #4989
  {17,  1,   0}, // #4990
  {18,  3,   0}, // #4991
  {20,  3,   0}, // #4992
  {21,  1,   0}, // #4993
  {22, 18,   0}, // #4994
  {23, 19,   0}, // #4995
  { 7,  1,   0}, // #4996
  { 9,  5,   0}, // #4997
  {12,  1,   0}, // #4998
  {14,  5,   0}, // #4999
  {16,  5,   0}, // #5000
  {17,  1,   0}, // #5001
  {18,  5,   0}, // #5002
  {20,  5,   0}, // #5003
  {21,  2,   0}, // #5004
  {22, 24,   0}, // #5005
  {23, 27,   0}, // #5006
  { 7,  1,   0}, // #5007
  { 9,  6,   0}, // #5008
  {12,  1,   0}, // #5009
  {14,  6,   0}, // #5010
  {16,  6,   0}, // #5011
  {17,  1,   0}, // #5012
  {18,  6,   0}, // #5013
  {20,  6,   0}, // #5014
  {21,  2,   0}, // #5015
  {22, 25,   0}, // #5016
  {23, 28,   0}, // #5017
  { 3,  2,   0}, // #5018
  {11,  4,   0}, // #5019
  {12,  2,   0}, // #5020
  {13,  3,   0}, // #5021
  {14, 12,   0}, // #5022
  {17,  8,   0}, // #5023
  {19,  7,   0}, // #5024
  {20, 13,   0}, // #5025
  {21,  8,   0}, // #5026
  {22, 56,   0}, // #5027
  {23, 64,   0}, // #5028
  { 3,  4,   0}, // #5029
  { 9,  4,   0}, // #5030
  {11,  4,   0}, // #5031
  {12,  4,   0}, // #5032
  {13,  5,   0}, // #5033
  {14, 10,   0}, // #5034
  {15,  1,   0}, // #5035
  {16,  4,   0}, // #5036
  {17, 31,   0}, // #5037
  {18,  4,   0}, // #5038
  {19,  6,   0}, // #5039
  {20, 11,   0}, // #5040
  {21, 31,   0}, // #5041
  {22, 57,   0}, // #5042
  {23, 88,   0}, // #5043
  { 3,  9,   0}, // #5044
  { 4,  9,   0}, // #5045
  { 7, 11,   0}, // #5046
  { 8,  8,   0}, // #5047
  { 9,  1,   0}, // #5048
  {11, 18,   0}, // #5049
  {12, 20,   0}, // #5050
  {13, 17,   0}, // #5051
  {14, 31,   0}, // #5052
  {15, 17,   0}, // #5053
  {16, 10,   0}, // #5054
  {18,  9,   0}, // #5055
  {19, 26,   0}, // #5056
  {20, 39,   0}, // #5057
  {21, 11,   0}, // #5058
  {22, 78,   0}, // #5059
  {23, 100,   0}, // #5060
  { 7,  1,   0}, // #5061
  { 8,  3,   0}, // #5062
  {12,  1,   0}, // #5063
  {13,  3,   0}, // #5064
  {15,  3,   0}, // #5065
  {17,  2,   0}, // #5066
  {18,  3,   0}, // #5067
  {19,  3,   0}, // #5068
  {20,  3,   0}, // #5069
  {21,  2,   0}, // #5070
  {22,  4,   0}, // #5071
  {23,  7,   0}, // #5072
  { 7,  1,   0}, // #5073
  { 8,  3,   0}, // #5074
  {12,  1,   0}, // #5075
  {13,  3,   0}, // #5076
  {15,  3,   0}, // #5077
  {17,  4,   0}, // #5078
  {18,  3,   0}, // #5079
  {19,  3,   0}, // #5080
  {20,  3,   0}, // #5081
  {21,  4,   0}, // #5082
  {22,  4,   0}, // #5083
  {23,  9,   0}, // #5084
  { 7,  1,   0}, // #5085
  { 8,  4,   0}, // #5086
  {12,  1,   0}, // #5087
  {13,  4,   0}, // #5088
  {15,  4,   0}, // #5089
  {17,  4,   0}, // #5090
  {18,  4,   0}, // #5091
  {19,  4,   0}, // #5092
  {20,  4,   0}, // #5093
  {21,  4,   0}, // #5094
  {22,  5,   0}, // #5095
  {23, 10,   0}, // #5096
  { 7,  1,   0}, // #5097
  { 8,  4,   0}, // #5098
  {12,  1,   0}, // #5099
  {13,  4,   0}, // #5100
  {15,  4,   0}, // #5101
  {17,  8,   0}, // #5102
  {18,  4,   0}, // #5103
  {19,  4,   0}, // #5104
  {20,  4,   0}, // #5105
  {21,  8,   0}, // #5106
  {22,  5,   0}, // #5107
  {23, 14,   0}, // #5108
  { 7,  1,   0}, // #5109
  { 8,  5,   0}, // #5110
  {12,  1,   0}, // #5111
  {13,  5,   0}, // #5112
  {15,  5,   0}, // #5113
  {17,  2,   0}, // #5114
  {18,  5,   0}, // #5115
  {19,  5,   0}, // #5116
  {20,  5,   0}, // #5117
  {21,  2,   0}, // #5118
  {22,  6,   0}, // #5119
  {23,  9,   0}, // #5120
  { 9,  1,   0}, // #5121
  {14,  1,   0}, // #5122
  {16,  1,   0}, // #5123
  {17,  1,   0}, // #5124
  {18,  1,   0}, // #5125
  {20,  1,   0}, // #5126
  {21,  1,   0}, // #5127
  {22, 17,   0}, // #5128
  {23, 18,   0}, // #5129
  {14,  1,   0}, // #5130
  {17,  1,   0}, // #5131
  {20,  1,   0}, // #5132
  {21,  1,   0}, // #5133
  {22,  2,   0}, // #5134
  {23,  3,   0}, // #5135
  { 9,  1,   0}, // #5136
  {16,  1,   0}, // #5137
  { 3,  3,   0}, // #5138
  {11,  1,   0}, // #5139
  {12,  2,   0}, // #5140
  {14,  1,   0}, // #5141
  { 8,  1,   0}, // #5142
  { 9,  1,   0}, // #5143
  {12,  1,   0}, // #5144
  {14,  1,   0}, // #5145
  {15,  1,   0}, // #5146
  { 8,  2,   0}, // #5147
  { 9,  2,   0}, // #5148
  {12,  2,   0}, // #5149
  {14,  2,   0}, // #5150
  {15,  2,   0}, // #5151
  { 3,  1,   0}, // #5152
  {11,  1,   0}, // #5153
  {12,  2,   0}, // #5154
  {14,  1,   0}, // #5155
  { 3,  2,   0}, // #5156
  {11,  1,   0}, // #5157
  {12,  2,   0}, // #5158
  {14,  1,   0}, // #5159
  { 3,  2,   0}, // #5160
  {11,  1,   0}, // #5161
  {12,  1,   0}, // #5162
  { 5,  1,   0}, // #5163
  { 7,  1,   0}, // #5164
  { 9,  1,   0}, // #5165
  {10,  1,   0}, // #5166
  {11,  1,   0}, // #5167
  {12,  1,   0}, // #5168
  { 7,  1,   0}, // #5169
  { 9,  2,   0}, // #5170
  {11,  1,   0}, // #5171
  {12,  1,   0}, // #5172
  {16,  1,   0}, // #5173
  {19,  1,   0}, // #5174
  { 7,  1,   0}, // #5175
  { 9,  2,   0}, // #5176
  {16,  1,   0}, // #5177
  {19,  1,   0}, // #5178
  { 7,  1,   0}, // #5179
  { 9,  1,   0}, // #5180
  {11,  1,   0}, // #5181
  {12,  1,   0}, // #5182
  {19,  1,   0}, // #5183
  { 7,  1,   0}, // #5184
  { 9,  1,   0}, // #5185
  {19,  1,   0}, // #5186
  { 9,  4,   0}, // #5187
  {10,  4,   0}, // #5188
  {11,  1,   0}, // #5189
  {12,  1,   0}, // #5190
  { 3,  8,   0}, // #5191
  {11,  1,   0}, // #5192
  {12,  1,   0}, // #5193
  { 1,  1,   0}, // #5194
  { 3,  1,   0}, // #5195
  { 5,  1,   0}, // #5196
  { 7,  1,   0}, // #5197
  { 9,  1,   0}, // #5198
  {10,  1,   0}, // #5199
  {11,  1,   0}, // #5200
  {12,  1,   0}, // #5201
  { 3,  4,   0}, // #5202
  {11,  1,   0}, // #5203
  {12,  1,   0}, // #5204
  { 8,  1,   0}, // #5205
  { 9,  1,   0}, // #5206
  {11,  1,   0}, // #5207
  {12,  1,   0}, // #5208
  {15,  1,   0}, // #5209
  { 8,  1,   0}, // #5210
  { 9,  1,   0}, // #5211
  {15,  1,   0}, // #5212
  { 1,  1,   0}, // #5213
  { 3,  1,   0}, // #5214
  { 5,  1,   0}, // #5215
  { 7,  1,   0}, // #5216
  { 8,  1,   0}, // #5217
  { 9,  2,   0}, // #5218
  {10,  1,   0}, // #5219
  {11,  1,   0}, // #5220
  {12,  1,   0}, // #5221
  {15,  1,   0}, // #5222
  { 1,  1,   0}, // #5223
  { 3,  1,   0}, // #5224
  { 5,  1,   0}, // #5225
  { 7,  1,   0}, // #5226
  { 8,  1,   0}, // #5227
  { 9,  2,   0}, // #5228
  {10,  1,   0}, // #5229
  {15,  1,   0}, // #5230
  { 8,  1,   0}, // #5231
  { 9,  1,   0}, // #5232
  {11,  1,   0}, // #5233
  {12,  1,   0}, // #5234
  {15,  2,   0}, // #5235
  { 8,  1,   0}, // #5236
  { 9,  1,   0}, // #5237
  {15,  2,   0}, // #5238
  { 2,  1,   0}, // #5239
  { 3,  1,   0}, // #5240
  { 4, 17,   0}, // #5241
  {11,  1,   0}, // #5242
  {12,  1,   0}, // #5243
  { 2,  1,   0}, // #5244
  { 3,  1,   0}, // #5245
  { 4, 25,   0}, // #5246
  {11,  1,   0}, // #5247
  {12,  1,   0}, // #5248
  { 2,  1,   0}, // #5249
  { 3,  1,   0}, // #5250
  { 4, 41,   0}, // #5251
  {11,  1,   0}, // #5252
  {12,  1,   0}, // #5253
  { 2,  1,   0}, // #5254
  { 3,  1,   0}, // #5255
  { 4, 12,   0}, // #5256
  {11,  1,   0}, // #5257
  {12,  1,   0}, // #5258
  { 6, 19,   0}, // #5259
  { 8,  1,   0}, // #5260
  { 9,  1,   0}, // #5261
  {10, 19,   0}, // #5262
  {11,  1,   0}, // #5263
  {12,  1,   0}, // #5264
  { 5,  3,   0}, // #5265
  { 6,  3,   0}, // #5266
  { 8,  1,   0}, // #5267
  { 9,  1,   0}, // #5268
  {10,  6,   0}, // #5269
  {11,  1,   0}, // #5270
  {12,  1,   0}, // #5271
  { 9,  1,   0}, // #5272
  {11,  1,   0}, // #5273
  {12,  1,   0}, // #5274
  {16,  1,   0}, // #5275
  { 2,  1,   0}, // #5276
  { 3,  1,   0}, // #5277
  {11,  1,   0}, // #5278
  {12,  1,   0}, // #5279
  {13,  3,   0}, // #5280
  { 2,  1,   0}, // #5281
  { 3,  1,   0}, // #5282
  {13,  3,   0}, // #5283
  { 2,  1,   0}, // #5284
  { 3,  1,   0}, // #5285
  {11,  1,   0}, // #5286
  {12,  1,   0}, // #5287
  {13,  1,   0}, // #5288
  { 2,  1,   0}, // #5289
  { 3,  1,   0}, // #5290
  {11,  1,   0}, // #5291
  {12,  1,   0}, // #5292
  {13,  2,   0}, // #5293
  { 2,  1,   0}, // #5294
  { 3,  1,   0}, // #5295
  {13,  1,   0}, // #5296
  { 2,  1,   0}, // #5297
  { 3,  1,   0}, // #5298
  {13,  2,   0}, // #5299
  { 2,  1,   0}, // #5300
  { 3,  1,   0}, // #5301
  {11,  1,   0}, // #5302
  {12,  1,   0}, // #5303
  {13,  4,   0}, // #5304
  { 2,  1,   0}, // #5305
  { 3,  1,   0}, // #5306
  {13,  4,   0}, // #5307
  { 7,  1,   0}, // #5308
  { 9,  1,   0}, // #5309
  {11,  1,   0}, // #5310
  {12,  1,   0}, // #5311
  {19,  2,   0}, // #5312
  { 7,  1,   0}, // #5313
  { 9,  1,   0}, // #5314
  {19,  2,   0}, // #5315
  { 6,  2,   0}, // #5316
  { 8,  1,   0}, // #5317
  { 9,  1,   0}, // #5318
  {10,  2,   0}, // #5319
  {11,  1,   0}, // #5320
  {12,  1,   0}, // #5321
  { 6,  1,   0}, // #5322
  { 8,  1,   0}, // #5323
  { 9,  1,   0}, // #5324
  {10,  1,   0}, // #5325
  {11,  1,   0}, // #5326
  {12,  1,   0}, // #5327
  { 9,  4,   0}, // #5328
  {11,  1,   0}, // #5329
  {12,  1,   0}, // #5330
  {16,  4,   0}, // #5331
  { 9,  4,   0}, // #5332
  {16,  4,   0}, // #5333
  { 1,  1,   0}, // #5334
  { 3,  1,   0}, // #5335
  { 5,  1,   0}, // #5336
  { 8,  1,   0}, // #5337
  { 9,  1,   0}, // #5338
  {10,  1,   0}, // #5339
  {11,  3,   0}, // #5340
  {12,  5,   0}, // #5341
  {14,  2,   0}, // #5342
  {16, 10,   0}, // #5343
  {18,  4,   0}, // #5344
  { 1,  1,   0}, // #5345
  { 3,  1,   0}, // #5346
  { 5,  1,   0}, // #5347
  { 8,  1,   0}, // #5348
  { 9,  1,   0}, // #5349
  {10,  1,   0}, // #5350
  {11,  2,   0}, // #5351
  {12,  4,   0}, // #5352
  {14,  2,   0}, // #5353
  {16, 10,   0}, // #5354
  {18,  4,   0}, // #5355
  { 1,  1,   0}, // #5356
  { 3,  1,   0}, // #5357
  { 5,  1,   0}, // #5358
  { 7,  1,   0}, // #5359
  { 8,  2,   0}, // #5360
  { 9,  3,   0}, // #5361
  {10,  1,   0}, // #5362
  {11,  1,   0}, // #5363
  {12,  1,   0}, // #5364
  {16,  2,   0}, // #5365
  {18,  2,   0}, // #5366
  { 1,  1,   0}, // #5367
  { 3,  1,   0}, // #5368
  { 5,  1,   0}, // #5369
  { 7,  1,   0}, // #5370
  { 8,  2,   0}, // #5371
  { 9,  3,   0}, // #5372
  {10,  1,   0}, // #5373
  {16,  2,   0}, // #5374
  {18,  2,   0}, // #5375
  { 7,  2,   0}, // #5376
  { 9,  3,   0}, // #5377
  {11,  1,   0}, // #5378
  {12,  1,   0}, // #5379
  {16,  1,   0}, // #5380
  {19,  2,   0}, // #5381
  { 7,  2,   0}, // #5382
  { 9,  3,   0}, // #5383
  {16,  1,   0}, // #5384
  {19,  2,   0}, // #5385
  { 9,  1,   0}, // #5386
  {11,  1,   0}, // #5387
  {12,  1,   0}, // #5388
  {16,  4,   0}, // #5389
  { 9,  1,   0}, // #5390
  {16,  4,   0}, // #5391
  { 3,  1,   0}, // #5392
  {12,  1,   0}, // #5393
  {14,  1,   0}, // #5394
  { 3, 22,   0}, // #5395
  {11,  1,   0}, // #5396
  {12,  1,   0}, // #5397
  { 6, 27,   0}, // #5398
  { 8,  1,   0}, // #5399
  { 9,  1,   0}, // #5400
  {10, 27,   0}, // #5401
  {11,  1,   0}, // #5402
  {12,  1,   0}, // #5403
  { 6, 21,   0}, // #5404
  { 8,  1,   0}, // #5405
  { 9,  1,   0}, // #5406
  {10, 21,   0}, // #5407
  {11,  1,   0}, // #5408
  {12,  1,   0}, // #5409
  { 6, 35,   0}, // #5410
  { 8,  1,   0}, // #5411
  { 9,  1,   0}, // #5412
  {10, 35,   0}, // #5413
  { 5,  2,   0}, // #5414
  { 7,  2,   0}, // #5415
  { 9,  2,   0}, // #5416
  {10,  2,   0}, // #5417
  {11,  2,   0}, // #5418
  {12,  2,   0}, // #5419
  { 8,  2,   0}, // #5420
  { 9,  2,   0}, // #5421
  {15,  2,   0}, // #5422
  { 9,  6,   0}, // #5423
  {10,  6,   0}, // #5424
  {11,  2,   0}, // #5425
  {12,  2,   0}, // #5426
  { 9,  2,   0}, // #5427
  {10,  2,   0}, // #5428
  {11,  1,   0}, // #5429
  {12,  1,   0}, // #5430
  { 8,  2,   0}, // #5431
  { 9,  2,   0}, // #5432
  {11,  2,   0}, // #5433
  {12,  2,   0}, // #5434
  {15,  2,   0}, // #5435
  { 8,  2,   0}, // #5436
  { 9,  2,   0}, // #5437
  {10,  4,   0}, // #5438
  {11,  2,   0}, // #5439
  {12,  2,   0}, // #5440
  {15,  2,   0}, // #5441
  { 8,  2,   0}, // #5442
  { 9,  2,   0}, // #5443
  {10,  4,   0}, // #5444
  {15,  2,   0}, // #5445
  { 8,  2,   0}, // #5446
  { 9,  2,   0}, // #5447
  {10,  2,   0}, // #5448
  {12,  1,   0}, // #5449
  {14,  1,   0}, // #5450
  {15,  2,   0}, // #5451
  { 8,  2,   0}, // #5452
  { 9,  2,   0}, // #5453
  {10,  2,   0}, // #5454
  {15,  2,   0}, // #5455
  { 6, 38,   0}, // #5456
  { 8,  2,   0}, // #5457
  { 9,  2,   0}, // #5458
  {10, 38,   0}, // #5459
  {11,  2,   0}, // #5460
  {12,  2,   0}, // #5461
  { 5,  6,   0}, // #5462
  { 6,  6,   0}, // #5463
  { 8,  2,   0}, // #5464
  { 9,  2,   0}, // #5465
  {10, 12,   0}, // #5466
  {11,  2,   0}, // #5467
  {12,  2,   0}, // #5468
  { 3,  4,   0}, // #5469
  { 5,  1,   0}, // #5470
  { 7,  1,   0}, // #5471
  { 8,  4,   0}, // #5472
  { 9,  5,   0}, // #5473
  {10,  1,   0}, // #5474
  {11,  4,   0}, // #5475
  {12,  8,   0}, // #5476
  {14,  4,   0}, // #5477
  {15,  4,   0}, // #5478
  { 9,  4,   0}, // #5479
  {10,  4,   0}, // #5480
  {11,  2,   0}, // #5481
  {12,  2,   0}, // #5482
  { 3,  2,   0}, // #5483
  { 5,  1,   0}, // #5484
  { 7,  1,   0}, // #5485
  { 8,  2,   0}, // #5486
  { 9,  3,   0}, // #5487
  {10,  1,   0}, // #5488
  {11,  2,   0}, // #5489
  {12,  4,   0}, // #5490
  {14,  2,   0}, // #5491
  {15,  2,   0}, // #5492
  { 3,  8,   0}, // #5493
  { 5,  1,   0}, // #5494
  { 7,  1,   0}, // #5495
  { 8, 10,   0}, // #5496
  { 9, 11,   0}, // #5497
  {10,  1,   0}, // #5498
  {11,  8,   0}, // #5499
  {12, 16,   0}, // #5500
  {14,  8,   0}, // #5501
  {15, 10,   0}, // #5502
  { 3,  4,   0}, // #5503
  { 5,  1,   0}, // #5504
  { 7,  1,   0}, // #5505
  { 8,  5,   0}, // #5506
  { 9,  6,   0}, // #5507
  {10,  1,   0}, // #5508
  {11,  4,   0}, // #5509
  {12,  8,   0}, // #5510
  {14,  4,   0}, // #5511
  {15,  5,   0}, // #5512
  { 9,  2,   0}, // #5513
  {16,  2,   0}, // #5514
  { 6,  4,   0}, // #5515
  { 8,  2,   0}, // #5516
  { 9,  2,   0}, // #5517
  {10,  4,   0}, // #5518
  {11,  2,   0}, // #5519
  {12,  2,   0}, // #5520
  { 6,  2,   0}, // #5521
  { 8,  2,   0}, // #5522
  { 9,  2,   0}, // #5523
  {10,  2,   0}, // #5524
  {11,  2,   0}, // #5525
  {12,  2,   0}, // #5526
  { 9,  2,   0}, // #5527
  {10,  6,   0}, // #5528
  {11,  2,   0}, // #5529
  {12,  2,   0}, // #5530
  { 9,  1,   0}, // #5531
  {10,  4,   0}, // #5532
  {11,  1,   0}, // #5533
  {12,  1,   0}, // #5534
  { 9,  4,   0}, // #5535
  {11,  2,   0}, // #5536
  {12,  2,   0}, // #5537
  {16,  4,   0}, // #5538
  { 9,  2,   0}, // #5539
  {11,  1,   0}, // #5540
  {12,  1,   0}, // #5541
  {16,  2,   0}, // #5542
  { 1,  1,   0}, // #5543
  { 3,  1,   0}, // #5544
  { 5,  2,   0}, // #5545
  { 9,  2,   0}, // #5546
  {10,  4,   0}, // #5547
  {11,  2,   0}, // #5548
  {12,  2,   0}, // #5549
  { 6, 54,   0}, // #5550
  { 8,  2,   0}, // #5551
  { 9,  2,   0}, // #5552
  {10, 54,   0}, // #5553
  {11,  2,   0}, // #5554
  {12,  2,   0}, // #5555
  { 6, 42,   0}, // #5556
  { 8,  2,   0}, // #5557
  { 9,  2,   0}, // #5558
  {10, 42,   0}, // #5559
  {11,  2,   0}, // #5560
  {12,  2,   0}, // #5561
  { 3,  2,   0}, // #5562
  {11, 16,   0}, // #5563
  {12, 32,   0}, // #5564
  {14, 16,   0}, // #5565
  { 9,  2,   0}, // #5566
  {10,  4,   0}, // #5567
  {11,  1,   0}, // #5568
  {12,  1,   0}, // #5569
  { 3, 42,   0}, // #5570
  { 5,  1,   0}, // #5571
  { 7,  1,   0}, // #5572
  { 8,  2,   0}, // #5573
  { 9,  3,   0}, // #5574
  {10,  1,   0}, // #5575
  {11,  2,   0}, // #5576
  {12, 18,   0}, // #5577
  {14, 16,   0}, // #5578
  {15,  2,   0}, // #5579
  { 3,  3,   0}, // #5580
  {11, 19,   0}, // #5581
  {12, 38,   0}, // #5582
  {14, 19,   0}, // #5583
  { 3,  6,   0}, // #5584
  {11, 38,   0}, // #5585
  {12, 76,   0}, // #5586
  {14, 38,   0}, // #5587
  { 3,  3,   0}, // #5588
  {11, 16,   0}, // #5589
  {12, 32,   0}, // #5590
  {14, 16,   0}, // #5591
  { 3,  3,   0}, // #5592
  {11, 17,   0}, // #5593
  {12, 34,   0}, // #5594
  {14, 17,   0}, // #5595
  { 3,  6,   0}, // #5596
  {11,  1,   0}, // #5597
  {12,  2,   0}, // #5598
  {14,  1,   0}, // #5599
  { 2,  1,   0}, // #5600
  { 3,  1,   0}, // #5601
  {12,  1,   0}, // #5602
  {14,  1,   0}, // #5603
  { 3,  1,   0}, // #5604
  {11, 19,   0}, // #5605
  {12, 38,   0}, // #5606
  {14, 19,   0}, // #5607
  {13,  1,   0}, // #5608
  {19,  1,   0}, // #5609
  {20,  1,   0}, // #5610
  {22,  1,   0}, // #5611
  {23,  1,   0}, // #5612
  { 3,  3,   0}, // #5613
  { 8,  6,   0}, // #5614
  {11,  3,   0}, // #5615
  {12,  3,   0}, // #5616
  {13,  9,   0}, // #5617
  {14,  3,   0}, // #5618
  {15,  6,   0}, // #5619
  {17,  1,   0}, // #5620
  {18,  6,   0}, // #5621
  {19, 10,   0}, // #5622
  {20,  9,   0}, // #5623
  {21,  1,   0}, // #5624
  {22, 10,   0}, // #5625
  {23, 11,   0}, // #5626
  { 3,  3,   0}, // #5627
  { 8,  6,   0}, // #5628
  {11,  3,   0}, // #5629
  {12,  3,   0}, // #5630
  {13,  9,   0}, // #5631
  {14,  3,   0}, // #5632
  {15,  6,   0}, // #5633
  {18,  6,   0}, // #5634
  {19, 11,   0}, // #5635
  {20,  9,   0}, // #5636
  {22, 11,   0}, // #5637
  {23, 11,   0}, // #5638
  { 8,  1,   0}, // #5639
  {11,  1,   0}, // #5640
  {13,  1,   0}, // #5641
  {15,  1,   0}, // #5642
  {17,  1,   0}, // #5643
  {18,  1,   0}, // #5644
  {19,  2,   0}, // #5645
  {20,  1,   0}, // #5646
  {21,  1,   0}, // #5647
  {22,  2,   0}, // #5648
  {23,  3,   0}, // #5649
  { 8,  1,   0}, // #5650
  {11,  1,   0}, // #5651
  {13,  1,   0}, // #5652
  {15,  1,   0}, // #5653
  {18,  1,   0}, // #5654
  {19,  2,   0}, // #5655
  {20,  1,   0}, // #5656
  {22,  2,   0}, // #5657
  {23,  2,   0}, // #5658
  {11,  2,   0}, // #5659
  {17,  1,   0}, // #5660
  {19,  2,   0}, // #5661
  {21,  1,   0}, // #5662
  {22,  2,   0}, // #5663
  {23,  3,   0}, // #5664
  { 1, 10,   0}, // #5665
  { 3,  1,   0}, // #5666
  {11,  1,   0}, // #5667
  {12,  1,   0}, // #5668
  {13,  1,   0}, // #5669
  {14,  1,   0}, // #5670
  {17,  1,   0}, // #5671
  {19,  1,   0}, // #5672
  {20,  1,   0}, // #5673
  {21,  1,   0}, // #5674
  {22,  1,   0}, // #5675
  {23,  2,   0}, // #5676
  { 3,  7,   0}, // #5677
  { 4,  2,   0}, // #5678
  { 8,  8,   0}, // #5679
  { 9,  3,   0}, // #5680
  {11,  9,   0}, // #5681
  {12,  7,   0}, // #5682
  {13, 16,   0}, // #5683
  {14, 10,   0}, // #5684
  {15, 10,   0}, // #5685
  {16,  5,   0}, // #5686
  {18, 11,   0}, // #5687
  {19, 18,   0}, // #5688
  {20, 19,   0}, // #5689
  {22, 32,   0}, // #5690
  {23, 32,   0}, // #5691
  { 2,  4,   0}, // #5692
  { 3,  1,   0}, // #5693
  {11,  1,   0}, // #5694
  {12,  1,   0}, // #5695
  {13,  1,   0}, // #5696
  {14,  1,   0}, // #5697
  {17,  1,   0}, // #5698
  {19,  1,   0}, // #5699
  {20,  1,   0}, // #5700
  {21,  1,   0}, // #5701
  {22,  1,   0}, // #5702
  {23,  2,   0}, // #5703
  { 2,  3,   0}, // #5704
  { 3,  1,   0}, // #5705
  {11,  1,   0}, // #5706
  {12,  1,   0}, // #5707
  {13,  1,   0}, // #5708
  {14,  1,   0}, // #5709
  {17,  1,   0}, // #5710
  {19,  1,   0}, // #5711
  {20,  1,   0}, // #5712
  {21,  1,   0}, // #5713
  {22,  1,   0}, // #5714
  {23,  2,   0}, // #5715
  { 8,  1,   0}, // #5716
  {13,  1,   0}, // #5717
  {15,  1,   0}, // #5718
  {17,  1,   0}, // #5719
  {18,  1,   0}, // #5720
  {19,  3,   0}, // #5721
  {20,  1,   0}, // #5722
  {21,  1,   0}, // #5723
  {22,  3,   0}, // #5724
  {23,  4,   0}, // #5725
  { 8,  1,   0}, // #5726
  {13,  1,   0}, // #5727
  {15,  1,   0}, // #5728
  {18,  1,   0}, // #5729
  {19,  3,   0}, // #5730
  {20,  1,   0}, // #5731
  {22,  3,   0}, // #5732
  {23,  3,   0}, // #5733
  { 8,  1,   0}, // #5734
  {11,  3,   0}, // #5735
  {13,  1,   0}, // #5736
  {14,  1,   0}, // #5737
  {15,  1,   0}, // #5738
  {17,  1,   0}, // #5739
  {18,  1,   0}, // #5740
  {19,  4,   0}, // #5741
  {20,  2,   0}, // #5742
  {21,  1,   0}, // #5743
  {22,  5,   0}, // #5744
  {23,  6,   0}, // #5745
  { 8,  1,   0}, // #5746
  {11,  3,   0}, // #5747
  {13,  1,   0}, // #5748
  {15,  1,   0}, // #5749
  {18,  1,   0}, // #5750
  {19,  4,   0}, // #5751
  {20,  1,   0}, // #5752
  {22,  4,   0}, // #5753
  {23,  4,   0}, // #5754
  {13,  9,   0}, // #5755
  {19,  9,   0}, // #5756
  {20,  9,   0}, // #5757
  {22, 10,   0}, // #5758
  {23, 10,   0}, // #5759
  {13,  2,   0}, // #5760
  {19,  2,   0}, // #5761
  {20,  2,   0}, // #5762
  {22,  2,   0}, // #5763
  {23,  2,   0}, // #5764
  { 8,  2,   0}, // #5765
  {11,  1,   0}, // #5766
  {13,  2,   0}, // #5767
  {15,  2,   0}, // #5768
  {17,  1,   0}, // #5769
  {18,  2,   0}, // #5770
  {19,  3,   0}, // #5771
  {20,  2,   0}, // #5772
  {21,  1,   0}, // #5773
  {22,  3,   0}, // #5774
  {23,  4,   0}, // #5775
  { 8,  2,   0}, // #5776
  {11,  1,   0}, // #5777
  {13,  2,   0}, // #5778
  {15,  2,   0}, // #5779
  {18,  2,   0}, // #5780
  {19,  3,   0}, // #5781
  {20,  2,   0}, // #5782
  {22,  3,   0}, // #5783
  {23,  3,   0}, // #5784
  { 3,  2,   0}, // #5785
  { 8,  4,   0}, // #5786
  {11,  2,   0}, // #5787
  {12,  2,   0}, // #5788
  {13,  6,   0}, // #5789
  {14,  2,   0}, // #5790
  {15,  4,   0}, // #5791
  {17,  1,   0}, // #5792
  {18,  4,   0}, // #5793
  {19,  6,   0}, // #5794
  {20,  6,   0}, // #5795
  {21,  1,   0}, // #5796
  {22,  7,   0}, // #5797
  {23,  8,   0}, // #5798
  { 3,  4,   0}, // #5799
  { 4,  2,   0}, // #5800
  { 8,  4,   0}, // #5801
  { 9,  8,   0}, // #5802
  {11,  6,   0}, // #5803
  {12,  4,   0}, // #5804
  {13,  8,   0}, // #5805
  {14, 26,   0}, // #5806
  {15,  6,   0}, // #5807
  {16, 10,   0}, // #5808
  {18, 12,   0}, // #5809
  {19, 10,   0}, // #5810
  {20, 30,   0}, // #5811
  {22, 66,   0}, // #5812
  {23, 66,   0}, // #5813
  {13,  1,   0}, // #5814
  {17,  1,   0}, // #5815
  {19,  1,   0}, // #5816
  {20,  1,   0}, // #5817
  {21,  1,   0}, // #5818
  {22,  1,   0}, // #5819
  {23,  2,   0}, // #5820
  { 8,  2,   0}, // #5821
  {13,  3,   0}, // #5822
  {15,  2,   0}, // #5823
  {17,  1,   0}, // #5824
  {18,  2,   0}, // #5825
  {19,  3,   0}, // #5826
  {20,  3,   0}, // #5827
  {21,  1,   0}, // #5828
  {22,  3,   0}, // #5829
  {23,  4,   0}, // #5830
  { 8,  2,   0}, // #5831
  {13,  3,   0}, // #5832
  {15,  2,   0}, // #5833
  {18,  2,   0}, // #5834
  {19,  3,   0}, // #5835
  {20,  3,   0}, // #5836
  {22,  3,   0}, // #5837
  {23,  3,   0}, // #5838
  { 8,  2,   0}, // #5839
  {13,  2,   0}, // #5840
  {15,  2,   0}, // #5841
  {17,  1,   0}, // #5842
  {18,  2,   0}, // #5843
  {19,  3,   0}, // #5844
  {20,  2,   0}, // #5845
  {21,  1,   0}, // #5846
  {22,  3,   0}, // #5847
  {23,  4,   0}, // #5848
  { 8,  2,   0}, // #5849
  {13,  2,   0}, // #5850
  {15,  2,   0}, // #5851
  {18,  2,   0}, // #5852
  {19,  3,   0}, // #5853
  {20,  2,   0}, // #5854
  {22,  3,   0}, // #5855
  {23,  3,   0}, // #5856
  { 7,  1,   0}, // #5857
  {12,  1,   0}, // #5858
  {14,  3,   0}, // #5859
  {17,  1,   0}, // #5860
  {20,  3,   0}, // #5861
  {21,  2,   0}, // #5862
  {22,  3,   0}, // #5863
  {23,  6,   0}, // #5864
  {14,  6,   0}, // #5865
  {17,  1,   0}, // #5866
  {20,  6,   0}, // #5867
  {21,  1,   0}, // #5868
  {22,  6,   0}, // #5869
  {23,  7,   0}, // #5870
  {14,  3,   0}, // #5871
  {20,  3,   0}, // #5872
  {22,  3,   0}, // #5873
  {23,  3,   0}, // #5874
  { 4,  1,   0}, // #5875
  {11,  1,   0}, // #5876
  {14,  2,   0}, // #5877
  {15,  1,   0}, // #5878
  {16,  1,   0}, // #5879
  {17,  1,   0}, // #5880
  {19,  1,   0}, // #5881
  {20,  2,   0}, // #5882
  {21,  2,   0}, // #5883
  {22,  4,   0}, // #5884
  {23,  6,   0}, // #5885
  { 4,  1,   0}, // #5886
  {11,  1,   0}, // #5887
  {14,  2,   0}, // #5888
  {15,  1,   0}, // #5889
  {16,  1,   0}, // #5890
  {19,  1,   0}, // #5891
  {20,  2,   0}, // #5892
  {22,  4,   0}, // #5893
  {23,  4,   0}, // #5894
  { 2,  6,   0}, // #5895
  { 3,  1,   0}, // #5896
  {11,  1,   0}, // #5897
  {12,  1,   0}, // #5898
  {13,  1,   0}, // #5899
  {14,  1,   0}, // #5900
  {17,  1,   0}, // #5901
  {19,  1,   0}, // #5902
  {20,  1,   0}, // #5903
  {21,  1,   0}, // #5904
  {22,  1,   0}, // #5905
  {23,  2,   0}, // #5906
  { 2,  6,   0}, // #5907
  { 3,  1,   0}, // #5908
  {11,  1,   0}, // #5909
  {12,  1,   0}, // #5910
  {13,  1,   0}, // #5911
  {14,  1,   0}, // #5912
  {19,  1,   0}, // #5913
  {20,  1,   0}, // #5914
  {22,  1,   0}, // #5915
  {23,  1,   0}, // #5916
  { 8,  1,   0}, // #5917
  {13,  2,   0}, // #5918
  {15,  1,   0}, // #5919
  {17,  1,   0}, // #5920
  {18,  1,   0}, // #5921
  {19,  2,   0}, // #5922
  {20,  2,   0}, // #5923
  {21,  1,   0}, // #5924
  {22,  2,   0}, // #5925
  {23,  3,   0}, // #5926
  { 8,  1,   0}, // #5927
  {13,  2,   0}, // #5928
  {15,  1,   0}, // #5929
  {18,  1,   0}, // #5930
  {19,  2,   0}, // #5931
  {20,  2,   0}, // #5932
  {22,  2,   0}, // #5933
  {23,  2,   0}, // #5934
  {13,  2,   0}, // #5935
  {17,  1,   0}, // #5936
  {19,  2,   0}, // #5937
  {20,  2,   0}, // #5938
  {21,  1,   0}, // #5939
  {22,  2,   0}, // #5940
  {23,  3,   0}, // #5941
  { 7,  1,   0}, // #5942
  { 8,  1,   0}, // #5943
  {11,  1,   0}, // #5944
  {12,  1,   0}, // #5945
  {13,  1,   0}, // #5946
  {15,  1,   0}, // #5947
  {18,  1,   0}, // #5948
  {19,  2,   0}, // #5949
  {20,  1,   0}, // #5950
  {21,  1,   0}, // #5951
  {22,  2,   0}, // #5952
  {23,  4,   0}, // #5953
  { 7,  1,   0}, // #5954
  { 8,  1,   0}, // #5955
  {12,  1,   0}, // #5956
  {13,  2,   0}, // #5957
  {15,  1,   0}, // #5958
  {18,  1,   0}, // #5959
  {19,  2,   0}, // #5960
  {20,  2,   0}, // #5961
  {21,  1,   0}, // #5962
  {22,  2,   0}, // #5963
  {23,  4,   0}, // #5964
  { 2, 16,   0}, // #5965
  { 3,  2,   0}, // #5966
  { 8,  1,   0}, // #5967
  {11,  2,   0}, // #5968
  {12,  2,   0}, // #5969
  {13,  3,   0}, // #5970
  {14,  2,   0}, // #5971
  {15,  1,   0}, // #5972
  {17,  1,   0}, // #5973
  {18,  1,   0}, // #5974
  {19,  3,   0}, // #5975
  {20,  3,   0}, // #5976
  {21,  1,   0}, // #5977
  {22,  3,   0}, // #5978
  {23,  4,   0}, // #5979
  { 2, 16,   0}, // #5980
  { 3,  2,   0}, // #5981
  { 8,  1,   0}, // #5982
  {11,  2,   0}, // #5983
  {12,  2,   0}, // #5984
  {13,  3,   0}, // #5985
  {14,  2,   0}, // #5986
  {15,  1,   0}, // #5987
  {18,  1,   0}, // #5988
  {19,  3,   0}, // #5989
  {20,  3,   0}, // #5990
  {22,  3,   0}, // #5991
  {23,  3,   0}, // #5992
  { 2, 10,   0}, // #5993
  { 3,  2,   0}, // #5994
  { 8,  1,   0}, // #5995
  {11,  2,   0}, // #5996
  {12,  2,   0}, // #5997
  {13,  3,   0}, // #5998
  {14,  2,   0}, // #5999
  {15,  1,   0}, // #6000
  {17,  1,   0}, // #6001
  {18,  1,   0}, // #6002
  {19,  3,   0}, // #6003
  {20,  3,   0}, // #6004
  {21,  1,   0}, // #6005
  {22,  3,   0}, // #6006
  {23,  4,   0}, // #6007
  { 2, 10,   0}, // #6008
  { 3,  2,   0}, // #6009
  { 8,  1,   0}, // #6010
  {11,  2,   0}, // #6011
  {12,  2,   0}, // #6012
  {13,  3,   0}, // #6013
  {14,  2,   0}, // #6014
  {15,  1,   0}, // #6015
  {18,  1,   0}, // #6016
  {19,  3,   0}, // #6017
  {20,  3,   0}, // #6018
  {22,  3,   0}, // #6019
  {23,  3,   0}, // #6020
  { 3,  1,   0}, // #6021
  { 7,  1,   0}, // #6022
  {11,  1,   0}, // #6023
  {12,  2,   0}, // #6024
  {13,  1,   0}, // #6025
  {14,  1,   0}, // #6026
  {17,  1,   0}, // #6027
  {19,  1,   0}, // #6028
  {20,  1,   0}, // #6029
  {21,  1,   0}, // #6030
  {22,  1,   0}, // #6031
  {23,  3,   0}, // #6032
  { 2, 12,   0}, // #6033
  { 3,  1,   0}, // #6034
  {11,  1,   0}, // #6035
  {12,  1,   0}, // #6036
  {13,  1,   0}, // #6037
  {14,  1,   0}, // #6038
  {17,  1,   0}, // #6039
  {19,  1,   0}, // #6040
  {20,  1,   0}, // #6041
  {21,  1,   0}, // #6042
  {22,  1,   0}, // #6043
  {23,  2,   0}, // #6044
  { 2, 12,   0}, // #6045
  { 3,  1,   0}, // #6046
  {11,  1,   0}, // #6047
  {12,  1,   0}, // #6048
  {13,  1,   0}, // #6049
  {14,  1,   0}, // #6050
  {19,  1,   0}, // #6051
  {20,  1,   0}, // #6052
  {22,  1,   0}, // #6053
  {23,  1,   0}, // #6054
  { 2, 24,   0}, // #6055
  { 3,  2,   0}, // #6056
  { 8,  1,   0}, // #6057
  {11,  2,   0}, // #6058
  {12,  2,   0}, // #6059
  {13,  3,   0}, // #6060
  {14,  2,   0}, // #6061
  {15,  1,   0}, // #6062
  {17,  1,   0}, // #6063
  {18,  1,   0}, // #6064
  {19,  3,   0}, // #6065
  {20,  3,   0}, // #6066
  {21,  1,   0}, // #6067
  {22,  3,   0}, // #6068
  {23,  4,   0}, // #6069
  { 2, 24,   0}, // #6070
  { 3,  2,   0}, // #6071
  { 8,  1,   0}, // #6072
  {11,  2,   0}, // #6073
  {12,  2,   0}, // #6074
  {13,  3,   0}, // #6075
  {14,  2,   0}, // #6076
  {15,  1,   0}, // #6077
  {18,  1,   0}, // #6078
  {19,  3,   0}, // #6079
  {20,  3,   0}, // #6080
  {22,  3,   0}, // #6081
  {23,  3,   0}, // #6082
  { 2, 12,   0}, // #6083
  { 3,  2,   0}, // #6084
  { 8,  1,   0}, // #6085
  {11,  2,   0}, // #6086
  {12,  2,   0}, // #6087
  {13,  3,   0}, // #6088
  {14,  2,   0}, // #6089
  {15,  1,   0}, // #6090
  {17,  1,   0}, // #6091
  {18,  1,   0}, // #6092
  {19,  3,   0}, // #6093
  {20,  3,   0}, // #6094
  {21,  1,   0}, // #6095
  {22,  3,   0}, // #6096
  {23,  4,   0}, // #6097
  { 2, 12,   0}, // #6098
  { 3,  2,   0}, // #6099
  { 8,  1,   0}, // #6100
  {11,  2,   0}, // #6101
  {12,  2,   0}, // #6102
  {13,  3,   0}, // #6103
  {14,  2,   0}, // #6104
  {15,  1,   0}, // #6105
  {18,  1,   0}, // #6106
  {19,  3,   0}, // #6107
  {20,  3,   0}, // #6108
  {22,  3,   0}, // #6109
  {23,  3,   0}, // #6110
  { 4,  2,   0}, // #6111
  {11,  2,   0}, // #6112
  {14,  4,   0}, // #6113
  {15,  3,   0}, // #6114
  {16,  2,   0}, // #6115
  {17,  1,   0}, // #6116
  {19,  3,   0}, // #6117
  {20,  4,   0}, // #6118
  {21,  2,   0}, // #6119
  {22,  9,   0}, // #6120
  {23, 11,   0}, // #6121
  { 3,  2,   0}, // #6122
  { 4,  1,   0}, // #6123
  { 8,  2,   0}, // #6124
  { 9,  4,   0}, // #6125
  {11,  3,   0}, // #6126
  {12,  2,   0}, // #6127
  {13,  6,   0}, // #6128
  {14,  6,   0}, // #6129
  {15,  3,   0}, // #6130
  {16,  5,   0}, // #6131
  {18,  6,   0}, // #6132
  {19,  7,   0}, // #6133
  {20, 10,   0}, // #6134
  {22, 15,   0}, // #6135
  {23, 15,   0}, // #6136
  { 3,  1,   0}, // #6137
  { 8,  1,   0}, // #6138
  {11,  2,   0}, // #6139
  {12,  1,   0}, // #6140
  {13,  2,   0}, // #6141
  {14,  1,   0}, // #6142
  {15,  1,   0}, // #6143
  {18,  1,   0}, // #6144
  {19,  3,   0}, // #6145
  {20,  2,   0}, // #6146
  {22,  3,   0}, // #6147
  {23,  3,   0}, // #6148
  { 7,  1,   0}, // #6149
  { 9,  1,   0}, // #6150
  {12,  1,   0}, // #6151
  {14,  2,   0}, // #6152
  {16,  1,   0}, // #6153
  {17,  1,   0}, // #6154
  {18,  1,   0}, // #6155
  {20,  2,   0}, // #6156
  {21,  2,   0}, // #6157
  {22,  5,   0}, // #6158
  {23,  8,   0}, // #6159
  { 3,  1,   0}, // #6160
  {11,  1,   0}, // #6161
  {12,  1,   0}, // #6162
  {13,  2,   0}, // #6163
  {14,  1,   0}, // #6164
  {17,  1,   0}, // #6165
  {19,  2,   0}, // #6166
  {20,  2,   0}, // #6167
  {21,  1,   0}, // #6168
  {22,  2,   0}, // #6169
  {23,  3,   0}, // #6170
  { 9,  1,   0}, // #6171
  {14,  1,   0}, // #6172
  {16,  1,   0}, // #6173
  {18,  1,   0}, // #6174
  {20,  1,   0}, // #6175
  {22,  4,   0}, // #6176
  {23,  4,   0}, // #6177
  { 9,  1,   0}, // #6178
  {14,  4,   0}, // #6179
  {15,  1,   0}, // #6180
  {16,  1,   0}, // #6181
  {18,  1,   0}, // #6182
  {19,  1,   0}, // #6183
  {20,  4,   0}, // #6184
  {22,  7,   0}, // #6185
  {23,  7,   0}, // #6186
  { 8,  1,   0}, // #6187
  { 9,  2,   0}, // #6188
  {13,  1,   0}, // #6189
  {14,  2,   0}, // #6190
  {15,  1,   0}, // #6191
  {16,  2,   0}, // #6192
  {18,  3,   0}, // #6193
  {19,  1,   0}, // #6194
  {20,  3,   0}, // #6195
  {22, 10,   0}, // #6196
  {23, 10,   0}, // #6197
  { 8,  6,   0}, // #6198
  {13,  9,   0}, // #6199
  {15,  6,   0}, // #6200
  {18,  6,   0}, // #6201
  {19,  9,   0}, // #6202
  {20,  9,   0}, // #6203
  {22, 15,   0}, // #6204
  {23, 15,   0}, // #6205
  { 4,  1,   0}, // #6206
  { 9,  5,   0}, // #6207
  {11,  1,   0}, // #6208
  {13,  4,   0}, // #6209
  {14,  5,   0}, // #6210
  {15,  1,   0}, // #6211
  {16,  6,   0}, // #6212
  {18,  5,   0}, // #6213
  {19,  5,   0}, // #6214
  {20,  9,   0}, // #6215
  {22, 10,   0}, // #6216
  {23, 10,   0}, // #6217
  { 4,  1,   0}, // #6218
  { 9,  1,   0}, // #6219
  {11,  1,   0}, // #6220
  {14,  1,   0}, // #6221
  {15,  1,   0}, // #6222
  {16,  2,   0}, // #6223
  {18,  1,   0}, // #6224
  {19,  1,   0}, // #6225
  {20,  1,   0}, // #6226
  {22,  4,   0}, // #6227
  {23,  4,   0}, // #6228
  { 4,  1,   0}, // #6229
  {11,  1,   0}, // #6230
  {14,  5,   0}, // #6231
  {15,  2,   0}, // #6232
  {16,  1,   0}, // #6233
  {17,  1,   0}, // #6234
  {19,  2,   0}, // #6235
  {20,  5,   0}, // #6236
  {21,  2,   0}, // #6237
  {22,  8,   0}, // #6238
  {23, 10,   0}, // #6239
  { 4,  2,   0}, // #6240
  {11,  2,   0}, // #6241
  {14,  3,   0}, // #6242
  {15,  2,   0}, // #6243
  {16,  2,   0}, // #6244
  {19,  2,   0}, // #6245
  {20,  3,   0}, // #6246
  {22,  7,   0}, // #6247
  {23,  7,   0}, // #6248
  { 4,  1,   0}, // #6249
  {11,  1,   0}, // #6250
  {14,  5,   0}, // #6251
  {15,  2,   0}, // #6252
  {16,  1,   0}, // #6253
  {19,  2,   0}, // #6254
  {20,  5,   0}, // #6255
  {22,  9,   0}, // #6256
  {23,  9,   0}, // #6257
  { 4,  2,   0}, // #6258
  {11,  2,   0}, // #6259
  {14,  4,   0}, // #6260
  {15,  3,   0}, // #6261
  {16,  2,   0}, // #6262
  {19,  3,   0}, // #6263
  {20,  4,   0}, // #6264
  {22, 10,   0}, // #6265
  {23, 10,   0}, // #6266
  { 4,  1,   0}, // #6267
  { 9,  8,   0}, // #6268
  {11,  1,   0}, // #6269
  {14,  8,   0}, // #6270
  {15,  1,   0}, // #6271
  {16,  9,   0}, // #6272
  {17,  1,   0}, // #6273
  {18,  8,   0}, // #6274
  {19,  1,   0}, // #6275
  {20,  8,   0}, // #6276
  {21,  1,   0}, // #6277
  {22, 30,   0}, // #6278
  {23, 31,   0}, // #6279
  { 7,  1,   0}, // #6280
  { 9, 10,   0}, // #6281
  {12,  1,   0}, // #6282
  {14, 10,   0}, // #6283
  {16, 10,   0}, // #6284
  {17,  1,   0}, // #6285
  {18, 10,   0}, // #6286
  {20, 10,   0}, // #6287
  {21,  2,   0}, // #6288
  {22, 36,   0}, // #6289
  {23, 39,   0}, // #6290
  { 7,  1,   0}, // #6291
  { 9, 11,   0}, // #6292
  {12,  1,   0}, // #6293
  {14, 11,   0}, // #6294
  {16, 11,   0}, // #6295
  {17,  1,   0}, // #6296
  {18, 11,   0}, // #6297
  {20, 11,   0}, // #6298
  {21,  2,   0}, // #6299
  {22, 37,   0}, // #6300
  {23, 40,   0}, // #6301
  { 4,  1,   0}, // #6302
  { 7,  1,   0}, // #6303
  { 8,  2,   0}, // #6304
  { 9,  3,   0}, // #6305
  {11,  1,   0}, // #6306
  {12,  1,   0}, // #6307
  {13,  2,   0}, // #6308
  {14,  3,   0}, // #6309
  {15,  4,   0}, // #6310
  {16,  4,   0}, // #6311
  {17,  1,   0}, // #6312
  {18,  5,   0}, // #6313
  {19,  4,   0}, // #6314
  {20,  5,   0}, // #6315
  {21,  2,   0}, // #6316
  {22, 15,   0}, // #6317
  {23, 18,   0}, // #6318
  { 3,  2,   0}, // #6319
  {11,  2,   0}, // #6320
  {12,  2,   0}, // #6321
  {13,  7,   0}, // #6322
  {14, 12,   0}, // #6323
  {17,  8,   0}, // #6324
  {19,  7,   0}, // #6325
  {20, 17,   0}, // #6326
  {21,  8,   0}, // #6327
  {22, 56,   0}, // #6328
  {23, 64,   0}, // #6329
  { 3,  9,   0}, // #6330
  { 4,  1,   0}, // #6331
  { 7, 11,   0}, // #6332
  { 8, 16,   0}, // #6333
  { 9,  1,   0}, // #6334
  {11, 10,   0}, // #6335
  {12, 20,   0}, // #6336
  {13, 25,   0}, // #6337
  {14, 31,   0}, // #6338
  {15, 17,   0}, // #6339
  {16,  2,   0}, // #6340
  {18, 17,   0}, // #6341
  {19, 26,   0}, // #6342
  {20, 47,   0}, // #6343
  {21, 11,   0}, // #6344
  {22, 78,   0}, // #6345
  {23, 100,   0}, // #6346
  { 3,  1,   0}, // #6347
  { 8,  1,   0}, // #6348
  {11,  1,   0}, // #6349
  {12,  1,   0}, // #6350
  {13,  2,   0}, // #6351
  {14,  1,   0}, // #6352
  {15,  1,   0}, // #6353
  {17,  2,   0}, // #6354
  {18,  1,   0}, // #6355
  {19,  3,   0}, // #6356
  {20,  2,   0}, // #6357
  {21,  2,   0}, // #6358
  {22,  3,   0}, // #6359
  {23,  5,   0}, // #6360
  { 3,  1,   0}, // #6361
  { 8,  1,   0}, // #6362
  {11,  1,   0}, // #6363
  {12,  1,   0}, // #6364
  {13,  2,   0}, // #6365
  {14,  1,   0}, // #6366
  {15,  1,   0}, // #6367
  {17,  4,   0}, // #6368
  {18,  1,   0}, // #6369
  {19,  3,   0}, // #6370
  {20,  2,   0}, // #6371
  {21,  4,   0}, // #6372
  {22,  3,   0}, // #6373
  {23,  7,   0}, // #6374
  { 3,  1,   0}, // #6375
  { 8,  1,   0}, // #6376
  {11,  1,   0}, // #6377
  {12,  1,   0}, // #6378
  {13,  2,   0}, // #6379
  {14,  1,   0}, // #6380
  {15,  1,   0}, // #6381
  {17,  8,   0}, // #6382
  {18,  1,   0}, // #6383
  {19,  3,   0}, // #6384
  {20,  2,   0}, // #6385
  {21,  8,   0}, // #6386
  {22,  3,   0}, // #6387
  {23, 11,   0}, // #6388
  { 8,  5,   0}, // #6389
  {11,  5,   0}, // #6390
  {13,  5,   0}, // #6391
  {15,  5,   0}, // #6392
  {18,  5,   0}, // #6393
  {19, 14,   0}, // #6394
  {20,  5,   0}, // #6395
  {22, 14,   0}, // #6396
  {23, 14,   0}, // #6397
  { 8,  9,   0}, // #6398
  {11,  7,   0}, // #6399
  {13,  9,   0}, // #6400
  {15,  9,   0}, // #6401
  {18,  9,   0}, // #6402
  {19, 21,   0}, // #6403
  {20,  9,   0}, // #6404
  {22, 21,   0}, // #6405
  {23, 21,   0}, // #6406
  { 8, 17,   0}, // #6407
  {11, 11,   0}, // #6408
  {13, 17,   0}, // #6409
  {15, 17,   0}, // #6410
  {18, 17,   0}, // #6411
  {19, 35,   0}, // #6412
  {20, 17,   0}, // #6413
  {22, 35,   0}, // #6414
  {23, 35,   0}, // #6415
  { 7,  2,   0}, // #6416
  {12,  2,   0}, // #6417
  {15,  1,   0}, // #6418
  {19,  1,   0}, // #6419
  {21,  2,   0}, // #6420
  {22,  1,   0}, // #6421
  {23,  5,   0}, // #6422
  { 7,  1,   0}, // #6423
  {11,  1,   0}, // #6424
  {12,  1,   0}, // #6425
  {19,  1,   0}, // #6426
  {21,  1,   0}, // #6427
  {22,  1,   0}, // #6428
  {23,  3,   0}, // #6429
  { 7,  1,   0}, // #6430
  { 8,  2,   0}, // #6431
  {12,  1,   0}, // #6432
  {13,  2,   0}, // #6433
  {15,  2,   0}, // #6434
  {18,  2,   0}, // #6435
  {19,  2,   0}, // #6436
  {20,  2,   0}, // #6437
  {21,  1,   0}, // #6438
  {22,  2,   0}, // #6439
  {23,  4,   0}, // #6440
  { 8,  1,   0}, // #6441
  {13,  1,   0}, // #6442
  {15,  1,   0}, // #6443
  {17,  1,   0}, // #6444
  {18,  1,   0}, // #6445
  {19,  1,   0}, // #6446
  {20,  1,   0}, // #6447
  {21,  1,   0}, // #6448
  {22,  2,   0}, // #6449
  {23,  3,   0}, // #6450
  { 3,  1,   0}, // #6451
  { 7,  2,   0}, // #6452
  {11,  1,   0}, // #6453
  {12,  3,   0}, // #6454
  {13,  1,   0}, // #6455
  {14,  1,   0}, // #6456
  {19,  1,   0}, // #6457
  {20,  1,   0}, // #6458
  {21,  2,   0}, // #6459
  {22,  3,   0}, // #6460
  {23,  7,   0}, // #6461
  { 3,  1,   0}, // #6462
  { 7,  4,   0}, // #6463
  {11,  1,   0}, // #6464
  {12,  5,   0}, // #6465
  {13,  1,   0}, // #6466
  {14,  1,   0}, // #6467
  {19,  1,   0}, // #6468
  {20,  1,   0}, // #6469
  {21,  4,   0}, // #6470
  {22,  3,   0}, // #6471
  {23, 11,   0}, // #6472
  { 3,  1,   0}, // #6473
  { 7,  8,   0}, // #6474
  {11,  1,   0}, // #6475
  {12,  9,   0}, // #6476
  {13,  1,   0}, // #6477
  {14,  1,   0}, // #6478
  {19,  1,   0}, // #6479
  {20,  1,   0}, // #6480
  {21,  8,   0}, // #6481
  {22,  3,   0}, // #6482
  {23, 19,   0}, // #6483
  { 3,  1,   0}, // #6484
  { 7, 16,   0}, // #6485
  { 8,  1,   0}, // #6486
  {11,  1,   0}, // #6487
  {12, 17,   0}, // #6488
  {13,  2,   0}, // #6489
  {14,  1,   0}, // #6490
  {15,  1,   0}, // #6491
  {18,  1,   0}, // #6492
  {19,  2,   0}, // #6493
  {20,  2,   0}, // #6494
  {21, 16,   0}, // #6495
  {22,  4,   0}, // #6496
  {23, 36,   0}, // #6497
  { 3,  1,   0}, // #6498
  { 7,  2,   0}, // #6499
  { 8,  1,   0}, // #6500
  {11,  1,   0}, // #6501
  {12,  3,   0}, // #6502
  {13,  2,   0}, // #6503
  {14,  1,   0}, // #6504
  {15,  1,   0}, // #6505
  {18,  1,   0}, // #6506
  {19,  2,   0}, // #6507
  {20,  2,   0}, // #6508
  {21,  2,   0}, // #6509
  {22,  4,   0}, // #6510
  {23,  8,   0}, // #6511
  { 3,  1,   0}, // #6512
  { 7,  4,   0}, // #6513
  { 8,  1,   0}, // #6514
  {11,  1,   0}, // #6515
  {12,  5,   0}, // #6516
  {13,  2,   0}, // #6517
  {14,  1,   0}, // #6518
  {15,  1,   0}, // #6519
  {18,  1,   0}, // #6520
  {19,  2,   0}, // #6521
  {20,  2,   0}, // #6522
  {21,  4,   0}, // #6523
  {22,  4,   0}, // #6524
  {23, 12,   0}, // #6525
  { 3,  1,   0}, // #6526
  { 7,  8,   0}, // #6527
  { 8,  1,   0}, // #6528
  {11,  1,   0}, // #6529
  {12,  9,   0}, // #6530
  {13,  2,   0}, // #6531
  {14,  1,   0}, // #6532
  {15,  1,   0}, // #6533
  {18,  1,   0}, // #6534
  {19,  2,   0}, // #6535
  {20,  2,   0}, // #6536
  {21,  8,   0}, // #6537
  {22,  4,   0}, // #6538
  {23, 20,   0}, // #6539
  {11,  3,   0}, // #6540
  {19,  3,   0}, // #6541
  {22,  3,   0}, // #6542
  {23,  3,   0}, // #6543
  {13,  3,   0}, // #6544
  {19,  3,   0}, // #6545
  {20,  3,   0}, // #6546
  {22,  3,   0}, // #6547
  {23,  3,   0}, // #6548
  { 4,  1,   0}, // #6549
  { 8,  2,   0}, // #6550
  {11,  3,   0}, // #6551
  {13,  2,   0}, // #6552
  {15,  3,   0}, // #6553
  {16,  1,   0}, // #6554
  {17,  1,   0}, // #6555
  {18,  2,   0}, // #6556
  {19,  7,   0}, // #6557
  {20,  2,   0}, // #6558
  {21,  1,   0}, // #6559
  {22,  7,   0}, // #6560
  {23,  8,   0}, // #6561
  {11,  3,   0}, // #6562
  {17,  1,   0}, // #6563
  {19,  3,   0}, // #6564
  {21,  1,   0}, // #6565
  {22,  3,   0}, // #6566
  {23,  4,   0}, // #6567
  {13,  3,   0}, // #6568
  {17,  1,   0}, // #6569
  {19,  3,   0}, // #6570
  {20,  3,   0}, // #6571
  {21,  1,   0}, // #6572
  {22,  3,   0}, // #6573
  {23,  4,   0}, // #6574
  { 3,  1,   0}, // #6575
  {11,  1,   0}, // #6576
  {12,  1,   0}, // #6577
  {13,  1,   0}, // #6578
  {14,  1,   0}, // #6579
  {17,  2,   0}, // #6580
  {19,  2,   0}, // #6581
  {20,  1,   0}, // #6582
  {21,  2,   0}, // #6583
  {22,  3,   0}, // #6584
  {23,  5,   0}, // #6585
  { 3,  1,   0}, // #6586
  {11,  1,   0}, // #6587
  {12,  1,   0}, // #6588
  {13,  1,   0}, // #6589
  {14,  1,   0}, // #6590
  {17,  4,   0}, // #6591
  {19,  2,   0}, // #6592
  {20,  1,   0}, // #6593
  {21,  4,   0}, // #6594
  {22,  3,   0}, // #6595
  {23,  7,   0}, // #6596
  { 3,  1,   0}, // #6597
  {11,  1,   0}, // #6598
  {12,  1,   0}, // #6599
  {13,  1,   0}, // #6600
  {14,  1,   0}, // #6601
  {17,  8,   0}, // #6602
  {19,  2,   0}, // #6603
  {20,  1,   0}, // #6604
  {21,  8,   0}, // #6605
  {22,  3,   0}, // #6606
  {23, 11,   0}, // #6607
  { 3,  1,   0}, // #6608
  {11,  1,   0}, // #6609
  {12,  1,   0}, // #6610
  {13,  1,   0}, // #6611
  {14,  1,   0}, // #6612
  {17, 16,   0}, // #6613
  {19,  2,   0}, // #6614
  {20,  1,   0}, // #6615
  {21, 16,   0}, // #6616
  {22,  3,   0}, // #6617
  {23, 19,   0}, // #6618
  { 8,  5,   0}, // #6619
  {11,  5,   0}, // #6620
  {13,  5,   0}, // #6621
  {15,  5,   0}, // #6622
  {17,  1,   0}, // #6623
  {18,  5,   0}, // #6624
  {19, 14,   0}, // #6625
  {20,  5,   0}, // #6626
  {21,  1,   0}, // #6627
  {22, 14,   0}, // #6628
  {23, 15,   0}, // #6629
  { 8,  9,   0}, // #6630
  {11,  7,   0}, // #6631
  {13,  9,   0}, // #6632
  {15,  9,   0}, // #6633
  {17,  1,   0}, // #6634
  {18,  9,   0}, // #6635
  {19, 21,   0}, // #6636
  {20,  9,   0}, // #6637
  {21,  1,   0}, // #6638
  {22, 21,   0}, // #6639
  {23, 22,   0}, // #6640
  { 8, 17,   0}, // #6641
  {11, 11,   0}, // #6642
  {13, 17,   0}, // #6643
  {15, 17,   0}, // #6644
  {17,  1,   0}, // #6645
  {18, 17,   0}, // #6646
  {19, 35,   0}, // #6647
  {20, 17,   0}, // #6648
  {21,  1,   0}, // #6649
  {22, 35,   0}, // #6650
  {23, 36,   0}, // #6651
  { 7,  1,   0}, // #6652
  {12,  1,   0}, // #6653
  {14,  2,   0}, // #6654
  {20,  2,   0}, // #6655
  {21,  1,   0}, // #6656
  {22,  2,   0}, // #6657
  {23,  4,   0}, // #6658
  { 4,  1,   0}, // #6659
  { 7,  1,   0}, // #6660
  { 9,  1,   0}, // #6661
  {11,  1,   0}, // #6662
  {12,  1,   0}, // #6663
  { 6,  1,   0}, // #6664
  { 8,  1,   0}, // #6665
  { 9,  1,   0}, // #6666
  {11,  1,   0}, // #6667
  {12,  1,   0}, // #6668
  { 5,  1,   0}, // #6669
  { 6,  2,   0}, // #6670
  { 8,  2,   0}, // #6671
  { 9,  2,   0}, // #6672
  {10,  2,   0}, // #6673
  {11,  3,   0}, // #6674
  {12,  6,   0}, // #6675
  { 6,  1,   0}, // #6676
  { 8,  1,   0}, // #6677
  { 9,  1,   0}, // #6678
  {10,  1,   0}, // #6679
  {11,  1,   0}, // #6680
  {12,  2,   0}, // #6681
  { 5,  1,   0}, // #6682
  {10,  1,   0}, // #6683
  {12,  2,   0}, // #6684
  {10,  1,   0}, // #6685
  {12,  1,   0}, // #6686
  { 5,  1,   0}, // #6687
  {10,  2,   0}, // #6688
  {11,  1,   0}, // #6689
  {12,  4,   0}, // #6690
  { 5,  1,   0}, // #6691
  {10,  2,   0}, // #6692
  {11,  3,   0}, // #6693
  {12,  6,   0}, // #6694
  { 8,  1,   0}, // #6695
  {10,  1,   0}, // #6696
  {11,  2,   0}, // #6697
  {12,  3,   0}, // #6698
  { 4,  1,   0}, // #6699
  { 7,  1,   0}, // #6700
  { 9,  1,   0}, // #6701
  {10,  1,   0}, // #6702
  {11,  1,   0}, // #6703
  {12,  2,   0}, // #6704
  { 6,  1,   0}, // #6705
  { 8,  1,   0}, // #6706
  { 9,  1,   0}, // #6707
  {10,  1,   0}, // #6708
  {11,  2,   0}, // #6709
  {12,  3,   0}, // #6710
  { 6,  1,   0}, // #6711
  { 8,  1,   0}, // #6712
  { 9,  1,   0}, // #6713
  {11,  2,   0}, // #6714
  {12,  2,   0}, // #6715
  { 6,  2,   0}, // #6716
  { 8,  2,   0}, // #6717
  { 9,  2,   0}, // #6718
  {10,  1,   0}, // #6719
  {11,  2,   0}, // #6720
  {12,  3,   0}, // #6721
  { 6,  2,   0}, // #6722
  { 8,  2,   0}, // #6723
  { 9,  2,   0}, // #6724
  {11,  2,   0}, // #6725
  {12,  2,   0}, // #6726
  {10,  1,   0}, // #6727
  {11, 10,   0}, // #6728
  {12, 11,   0}, // #6729
  {11, 11,   0}, // #6730
  {12, 11,   0}, // #6731
  { 4,  1,   0}, // #6732
  { 7,  1,   0}, // #6733
  { 8,  1,   0}, // #6734
  { 9,  1,   0}, // #6735
  {10,  1,   0}, // #6736
  {11,  2,   0}, // #6737
  {12,  3,   0}, // #6738
  { 4,  1,   0}, // #6739
  { 7,  1,   0}, // #6740
  { 8,  1,   0}, // #6741
  { 9,  1,   0}, // #6742
  {11,  2,   0}, // #6743
  {12,  2,   0}, // #6744
  { 8,  1,   0}, // #6745
  {10,  1,   0}, // #6746
  {11,  1,   0}, // #6747
  {12,  2,   0}, // #6748
  { 8,  2,   0}, // #6749
  {10,  1,   0}, // #6750
  {11,  2,   0}, // #6751
  {12,  3,   0}, // #6752
  { 8,  2,   0}, // #6753
  {11,  2,   0}, // #6754
  {12,  2,   0}, // #6755
  { 5,  1,   0}, // #6756
  { 6,  1,   0}, // #6757
  { 8,  2,   0}, // #6758
  { 9,  1,   0}, // #6759
  {10,  2,   0}, // #6760
  {11,  3,   0}, // #6761
  {12,  6,   0}, // #6762
  { 5,  1,   0}, // #6763
  { 8,  1,   0}, // #6764
  {10,  2,   0}, // #6765
  {11,  1,   0}, // #6766
  {12,  4,   0}, // #6767
  { 6,  2,   0}, // #6768
  { 8,  3,   0}, // #6769
  { 9,  2,   0}, // #6770
  {11,  3,   0}, // #6771
  {12,  3,   0}, // #6772
  { 8,  1,   0}, // #6773
  {11,  4,   0}, // #6774
  {12,  4,   0}, // #6775
  { 4,  1,   0}, // #6776
  { 6,  1,   0}, // #6777
  { 7,  1,   0}, // #6778
  { 8,  1,   0}, // #6779
  { 9,  2,   0}, // #6780
  {10,  1,   0}, // #6781
  {11,  2,   0}, // #6782
  {12,  3,   0}, // #6783
  { 4,  1,   0}, // #6784
  { 6,  1,   0}, // #6785
  { 7,  1,   0}, // #6786
  { 8,  1,   0}, // #6787
  { 9,  2,   0}, // #6788
  {11,  2,   0}, // #6789
  {12,  2,   0}, // #6790
  { 3,  1,   0}, // #6791
  { 7,  1,   0}, // #6792
  { 8,  1,   0}, // #6793
  {10,  1,   0}, // #6794
  {11,  1,   0}, // #6795
  {12,  2,   0}, // #6796
  { 3,  1,   0}, // #6797
  { 6,  1,   0}, // #6798
  { 7,  1,   0}, // #6799
  { 8,  2,   0}, // #6800
  { 9,  1,   0}, // #6801
  {11,  2,   0}, // #6802
  {12,  2,   0}, // #6803
  { 3,  1,   0}, // #6804
  { 4,  1,   0}, // #6805
  { 7,  2,   0}, // #6806
  { 8,  1,   0}, // #6807
  { 9,  1,   0}, // #6808
  {10,  1,   0}, // #6809
  {11,  2,   0}, // #6810
  {12,  3,   0}, // #6811
  { 3,  1,   0}, // #6812
  { 4,  1,   0}, // #6813
  { 7,  2,   0}, // #6814
  { 8,  1,   0}, // #6815
  { 9,  1,   0}, // #6816
  {11,  2,   0}, // #6817
  {12,  2,   0}, // #6818
  { 4,  1,   0}, // #6819
  { 6,  2,   0}, // #6820
  { 7,  1,   0}, // #6821
  { 8,  2,   0}, // #6822
  { 9,  3,   0}, // #6823
  {11,  3,   0}, // #6824
  {12,  3,   0}, // #6825
  { 3,  1,   0}, // #6826
  { 7,  1,   0}, // #6827
  { 8,  1,   0}, // #6828
  {11,  1,   0}, // #6829
  {12,  1,   0}, // #6830
  { 1, 10,   0}, // #6831
  { 3,  1,   0}, // #6832
  { 7,  1,   0}, // #6833
  { 8,  1,   0}, // #6834
  {10,  1,   0}, // #6835
  {11,  1,   0}, // #6836
  {12,  2,   0}, // #6837
  { 1, 10,   0}, // #6838
  { 3,  1,   0}, // #6839
  { 7,  1,   0}, // #6840
  { 8,  1,   0}, // #6841
  {11,  1,   0}, // #6842
  {12,  1,   0}, // #6843
  { 2, 22,   0}, // #6844
  { 3,  1,   0}, // #6845
  { 7,  1,   0}, // #6846
  { 8,  1,   0}, // #6847
  {10,  1,   0}, // #6848
  {11,  1,   0}, // #6849
  {12,  2,   0}, // #6850
  { 2, 22,   0}, // #6851
  { 3,  1,   0}, // #6852
  { 7,  1,   0}, // #6853
  { 8,  1,   0}, // #6854
  {11,  1,   0}, // #6855
  {12,  1,   0}, // #6856
  { 2, 14,   0}, // #6857
  { 3,  1,   0}, // #6858
  { 7,  1,   0}, // #6859
  { 8,  1,   0}, // #6860
  {10,  1,   0}, // #6861
  {11,  1,   0}, // #6862
  {12,  2,   0}, // #6863
  { 2, 14,   0}, // #6864
  { 3,  1,   0}, // #6865
  { 7,  1,   0}, // #6866
  { 8,  1,   0}, // #6867
  {11,  1,   0}, // #6868
  {12,  1,   0}, // #6869
  { 3,  1,   0}, // #6870
  { 4,  1,   0}, // #6871
  { 6,  1,   0}, // #6872
  { 7,  2,   0}, // #6873
  { 8,  2,   0}, // #6874
  { 9,  2,   0}, // #6875
  {10,  1,   0}, // #6876
  {11,  3,   0}, // #6877
  {12,  4,   0}, // #6878
  { 3,  1,   0}, // #6879
  { 4,  1,   0}, // #6880
  { 6,  1,   0}, // #6881
  { 7,  2,   0}, // #6882
  { 8,  2,   0}, // #6883
  { 9,  2,   0}, // #6884
  {11,  3,   0}, // #6885
  {12,  3,   0}, // #6886
  { 3,  1,   0}, // #6887
  { 4,  2,   0}, // #6888
  { 6,  2,   0}, // #6889
  { 7,  3,   0}, // #6890
  { 8,  3,   0}, // #6891
  { 9,  4,   0}, // #6892
  {10,  1,   0}, // #6893
  {11,  5,   0}, // #6894
  {12,  6,   0}, // #6895
  { 3,  1,   0}, // #6896
  { 4,  2,   0}, // #6897
  { 6,  1,   0}, // #6898
  { 7,  3,   0}, // #6899
  { 8,  2,   0}, // #6900
  { 9,  3,   0}, // #6901
  {11,  4,   0}, // #6902
  {12,  4,   0}, // #6903
  { 5,  1,   0}, // #6904
  { 9,  1,   0}, // #6905
  {10,  1,   0}, // #6906
  {11,  1,   0}, // #6907
  {12,  3,   0}, // #6908
  { 3,  1,   0}, // #6909
  { 7,  1,   0}, // #6910
  { 8,  1,   0}, // #6911
  { 9,  1,   0}, // #6912
  {11,  2,   0}, // #6913
  {12,  2,   0}, // #6914
  {11, 31,   0}, // #6915
  {12, 31,   0}, // #6916
  { 4,  1,   0}, // #6917
  { 6,  2,   0}, // #6918
  { 7,  1,   0}, // #6919
  { 8,  2,   0}, // #6920
  { 9,  3,   0}, // #6921
  {10,  1,   0}, // #6922
  {11,  3,   0}, // #6923
  {12,  4,   0}, // #6924
  { 4,  1,   0}, // #6925
  { 7,  1,   0}, // #6926
  { 8,  1,   0}, // #6927
  { 9,  1,   0}, // #6928
  {10,  1,   0}, // #6929
  {11,  4,   0}, // #6930
  {12,  5,   0}, // #6931
  { 4,  1,   0}, // #6932
  { 7,  1,   0}, // #6933
  { 8,  1,   0}, // #6934
  { 9,  1,   0}, // #6935
  {11,  4,   0}, // #6936
  {12,  4,   0}, // #6937
  { 4,  1,   0}, // #6938
  { 7,  1,   0}, // #6939
  { 9,  1,   0}, // #6940
  {10,  1,   0}, // #6941
  {11,  2,   0}, // #6942
  {12,  3,   0}, // #6943
  { 4,  1,   0}, // #6944
  { 7,  1,   0}, // #6945
  { 9,  1,   0}, // #6946
  {11,  2,   0}, // #6947
  {12,  2,   0}, // #6948
  { 4,  1,   0}, // #6949
  { 7,  1,   0}, // #6950
  { 8,  1,   0}, // #6951
  { 9,  1,   0}, // #6952
  {10,  1,   0}, // #6953
  {11,  3,   0}, // #6954
  {12,  4,   0}, // #6955
  { 4,  1,   0}, // #6956
  { 7,  1,   0}, // #6957
  { 8,  1,   0}, // #6958
  { 9,  1,   0}, // #6959
  {11,  3,   0}, // #6960
  {12,  3,   0}, // #6961
  { 3,  1,   0}, // #6962
  { 5,  1,   0}, // #6963
  { 6,  1,   0}, // #6964
  { 7,  1,   0}, // #6965
  { 8,  2,   0}, // #6966
  { 9,  1,   0}, // #6967
  {10,  1,   0}, // #6968
  {11,  2,   0}, // #6969
  {12,  4,   0}, // #6970
  { 6,  1,   0}, // #6971
  { 8,  1,   0}, // #6972
  { 9,  2,   0}, // #6973
  {11,  2,   0}, // #6974
  {12,  2,   0}, // #6975
  { 3,  1,   0}, // #6976
  { 7,  1,   0}, // #6977
  { 8,  1,   0}, // #6978
  { 9,  2,   0}, // #6979
  {10,  1,   0}, // #6980
  {11,  3,   0}, // #6981
  {12,  4,   0}, // #6982
  { 3,  1,   0}, // #6983
  { 7,  1,   0}, // #6984
  { 8,  1,   0}, // #6985
  { 9,  2,   0}, // #6986
  {11,  3,   0}, // #6987
  {12,  3,   0}, // #6988
  {10,  1,   0}, // #6989
  {11, 17,   0}, // #6990
  {12, 18,   0}, // #6991
  {11, 18,   0}, // #6992
  {12, 18,   0}, // #6993
  {10,  1,   0}, // #6994
  {11,  7,   0}, // #6995
  {12,  8,   0}, // #6996
  {11,  8,   0}, // #6997
  {12,  8,   0}, // #6998
  { 3,  3,   0}, // #6999
  { 7,  3,   0}, // #7000
  { 8,  3,   0}, // #7001
  {10,  1,   0}, // #7002
  {11,  3,   0}, // #7003
  {12,  4,   0}, // #7004
  { 3,  3,   0}, // #7005
  { 7,  3,   0}, // #7006
  { 8,  3,   0}, // #7007
  {11,  3,   0}, // #7008
  {12,  3,   0}, // #7009
  { 5,  1,   0}, // #7010
  {10,  2,   0}, // #7011
  {12,  3,   0}, // #7012
  { 3,  1,   0}, // #7013
  { 7,  1,   0}, // #7014
  { 8,  1,   0}, // #7015
  { 9,  1,   0}, // #7016
  {10,  1,   0}, // #7017
  {11,  2,   0}, // #7018
  {12,  3,   0}, // #7019
  { 3,  1,   0}, // #7020
  { 6,  1,   0}, // #7021
  { 7,  1,   0}, // #7022
  { 8,  2,   0}, // #7023
  { 9,  1,   0}, // #7024
  {10,  1,   0}, // #7025
  {11,  2,   0}, // #7026
  {12,  3,   0}, // #7027
  { 5,  1,   0}, // #7028
  { 8,  2,   0}, // #7029
  {10,  2,   0}, // #7030
  {11,  2,   0}, // #7031
  {12,  5,   0}, // #7032
  { 8,  4,   0}, // #7033
  {10,  1,   0}, // #7034
  {11,  4,   0}, // #7035
  {12,  5,   0}, // #7036
  { 5,  1,   0}, // #7037
  { 8,  3,   0}, // #7038
  {10,  2,   0}, // #7039
  {11,  3,   0}, // #7040
  {12,  6,   0}, // #7041
  { 8,  6,   0}, // #7042
  {10,  1,   0}, // #7043
  {11,  6,   0}, // #7044
  {12,  7,   0}, // #7045
  { 5,  1,   0}, // #7046
  { 8,  1,   0}, // #7047
  {10,  1,   0}, // #7048
  {11,  1,   0}, // #7049
  {12,  3,   0}, // #7050
  { 5,  1,   0}, // #7051
  { 8,  3,   0}, // #7052
  {10,  2,   0}, // #7053
  {11,  4,   0}, // #7054
  {12,  7,   0}, // #7055
  { 5,  1,   0}, // #7056
  { 8,  1,   0}, // #7057
  {10,  2,   0}, // #7058
  {11,  2,   0}, // #7059
  {12,  5,   0}, // #7060
  { 2, 21,   0}, // #7061
  { 3,  1,   0}, // #7062
  { 7,  1,   0}, // #7063
  { 8,  1,   0}, // #7064
  {10,  1,   0}, // #7065
  {11,  1,   0}, // #7066
  {12,  2,   0}, // #7067
  { 2, 21,   0}, // #7068
  { 3,  1,   0}, // #7069
  { 7,  1,   0}, // #7070
  { 8,  1,   0}, // #7071
  {11,  1,   0}, // #7072
  {12,  1,   0}, // #7073
  { 2, 24,   0}, // #7074
  { 3,  1,   0}, // #7075
  { 7,  1,   0}, // #7076
  { 8,  1,   0}, // #7077
  {11,  1,   0}, // #7078
  {12,  1,   0}, // #7079
  { 7,  1,   0}, // #7080
  {10,  1,   0}, // #7081
  {11,  1,   0}, // #7082
  {12,  2,   0}, // #7083
  { 4,  1,   0}, // #7084
  { 5,  1,   0}, // #7085
  { 7,  1,   0}, // #7086
  { 9,  1,   0}, // #7087
  {10,  1,   0}, // #7088
  {11,  1,   0}, // #7089
  {12,  3,   0}, // #7090
  { 2, 44,   0}, // #7091
  { 3,  2,   0}, // #7092
  { 7,  2,   0}, // #7093
  { 8,  3,   0}, // #7094
  {10,  1,   0}, // #7095
  {11,  3,   0}, // #7096
  {12,  4,   0}, // #7097
  { 2, 44,   0}, // #7098
  { 3,  2,   0}, // #7099
  { 7,  2,   0}, // #7100
  { 8,  3,   0}, // #7101
  {11,  3,   0}, // #7102
  {12,  3,   0}, // #7103
  { 2, 28,   0}, // #7104
  { 3,  2,   0}, // #7105
  { 7,  2,   0}, // #7106
  { 8,  3,   0}, // #7107
  {10,  1,   0}, // #7108
  {11,  3,   0}, // #7109
  {12,  4,   0}, // #7110
  { 2, 28,   0}, // #7111
  { 3,  2,   0}, // #7112
  { 7,  2,   0}, // #7113
  { 8,  3,   0}, // #7114
  {11,  3,   0}, // #7115
  {12,  3,   0}, // #7116
  { 5,  1,   0}, // #7117
  { 7,  2,   0}, // #7118
  {10,  1,   0}, // #7119
  {11,  2,   0}, // #7120
  {12,  4,   0}, // #7121
  { 8,  7,   0}, // #7122
  {10,  4,   0}, // #7123
  {11,  7,   0}, // #7124
  {12, 11,   0}, // #7125
  { 5,  1,   0}, // #7126
  {10,  2,   0}, // #7127
  {11,  2,   0}, // #7128
  {12,  5,   0}, // #7129
  { 6,  1,   0}, // #7130
  { 7,  1,   0}, // #7131
  { 8,  1,   0}, // #7132
  { 9,  1,   0}, // #7133
  {10,  1,   0}, // #7134
  {11,  2,   0}, // #7135
  {12,  3,   0}, // #7136
  { 5,  1,   0}, // #7137
  { 6,  2,   0}, // #7138
  { 8,  2,   0}, // #7139
  { 9,  2,   0}, // #7140
  {10,  2,   0}, // #7141
  {11,  2,   0}, // #7142
  {12,  5,   0}, // #7143
  { 4,  1,   0}, // #7144
  { 5,  1,   0}, // #7145
  { 7,  1,   0}, // #7146
  { 9,  1,   0}, // #7147
  {10,  2,   0}, // #7148
  {11,  1,   0}, // #7149
  {12,  4,   0}, // #7150
  { 4,  1,   0}, // #7151
  { 6,  3,   0}, // #7152
  { 7,  1,   0}, // #7153
  { 8,  5,   0}, // #7154
  { 9,  4,   0}, // #7155
  {11, 12,   0}, // #7156
  {12, 12,   0}, // #7157
  { 5,  1,   0}, // #7158
  { 6,  1,   0}, // #7159
  { 8,  1,   0}, // #7160
  { 9,  1,   0}, // #7161
  {10,  2,   0}, // #7162
  {11,  1,   0}, // #7163
  {12,  4,   0}, // #7164
  { 6,  1,   0}, // #7165
  { 8,  1,   0}, // #7166
  { 9,  1,   0}, // #7167
  {11,  4,   0}, // #7168
  {12,  4,   0}, // #7169
  { 4,  1,   0}, // #7170
  { 6,  3,   0}, // #7171
  { 7,  1,   0}, // #7172
  { 8,  3,   0}, // #7173
  { 9,  4,   0}, // #7174
  {11,  8,   0}, // #7175
  {12,  8,   0}, // #7176
  { 5,  1,   0}, // #7177
  { 6,  2,   0}, // #7178
  { 7,  1,   0}, // #7179
  { 8,  2,   0}, // #7180
  { 9,  2,   0}, // #7181
  {10,  1,   0}, // #7182
  {11,  3,   0}, // #7183
  {12,  5,   0}, // #7184
  { 3,  1,   0}, // #7185
  { 7,  1,   0}, // #7186
  { 8,  1,   0}, // #7187
  {11,  2,   0}, // #7188
  {12,  2,   0}, // #7189
  { 8,  2,   0}, // #7190
  {11,  3,   0}, // #7191
  {12,  3,   0}, // #7192
  { 4,  1,   0}, // #7193
  { 6,  1,   0}, // #7194
  { 7,  1,   0}, // #7195
  { 8,  5,   0}, // #7196
  { 9,  2,   0}, // #7197
  {11,  8,   0}, // #7198
  {12,  8,   0}, // #7199
  { 8,  8,   0}, // #7200
  {11,  8,   0}, // #7201
  {12,  8,   0}, // #7202
  { 5,  1,   0}, // #7203
  { 6,  1,   0}, // #7204
  { 8,  1,   0}, // #7205
  { 9,  1,   0}, // #7206
  {10,  1,   0}, // #7207
  {11,  1,   0}, // #7208
  {12,  3,   0}, // #7209
  { 5,  1,   0}, // #7210
  {10,  1,   0}, // #7211
  {11,  1,   0}, // #7212
  {12,  3,   0}, // #7213
  { 3,  1,   0}, // #7214
  { 5,  1,   0}, // #7215
  { 7,  1,   0}, // #7216
  { 8,  1,   0}, // #7217
  { 9,  1,   0}, // #7218
  {10,  1,   0}, // #7219
  {11,  2,   0}, // #7220
  {12,  4,   0}, // #7221
  { 5,  1,   0}, // #7222
  { 6,  1,   0}, // #7223
  { 7,  1,   0}, // #7224
  { 8,  1,   0}, // #7225
  { 9,  1,   0}, // #7226
  {10,  1,   0}, // #7227
  {11,  2,   0}, // #7228
  {12,  4,   0}, // #7229
  { 3,  1,   0}, // #7230
  { 5,  1,   0}, // #7231
  { 7,  1,   0}, // #7232
  { 8,  1,   0}, // #7233
  {10,  2,   0}, // #7234
  {11,  1,   0}, // #7235
  {12,  4,   0}, // #7236
  { 4,  1,   0}, // #7237
  { 6,  2,   0}, // #7238
  { 7,  1,   0}, // #7239
  { 8,  2,   0}, // #7240
  { 9,  3,   0}, // #7241
  {11,  4,   0}, // #7242
  {12,  4,   0}, // #7243
  {10,  2,   0}, // #7244
  {11,  3,   0}, // #7245
  {12,  5,   0}, // #7246
  { 5,  1,   0}, // #7247
  { 6,  1,   0}, // #7248
  { 7,  1,   0}, // #7249
  { 8,  1,   0}, // #7250
  { 9,  1,   0}, // #7251
  {10,  2,   0}, // #7252
  {11,  2,   0}, // #7253
  {12,  5,   0}, // #7254
  { 5,  1,   0}, // #7255
  { 8,  2,   0}, // #7256
  {10,  2,   0}, // #7257
  {11,  3,   0}, // #7258
  {12,  6,   0}, // #7259
  { 4,  2,   0}, // #7260
  { 7,  2,   0}, // #7261
  { 9,  2,   0}, // #7262
  {10,  1,   0}, // #7263
  {11,  2,   0}, // #7264
  {12,  3,   0}, // #7265
  { 8,  2,   0}, // #7266
  {10,  1,   0}, // #7267
  {11,  3,   0}, // #7268
  {12,  4,   0}, // #7269
  { 5,  1,   0}, // #7270
  { 8,  2,   0}, // #7271
  {10,  1,   0}, // #7272
  {11,  2,   0}, // #7273
  {12,  4,   0}, // #7274
  { 3,  1,   0}, // #7275
  { 4,  1,   0}, // #7276
  { 8,  1,   0}, // #7277
  { 9,  1,   0}, // #7278
  {11,  2,   0}, // #7279
  {12,  1,   0}, // #7280
  {13,  2,   0}, // #7281
  {14,  2,   0}, // #7282
  {15,  2,   0}, // #7283
  {16,  2,   0}, // #7284
  {18,  2,   0}, // #7285
  {19,  3,   0}, // #7286
  {20,  3,   0}, // #7287
  {22,  4,   0}, // #7288
  {23,  4,   0}, // #7289
  { 4,  1,   0}, // #7290
  { 9,  1,   0}, // #7291
  {11,  1,   0}, // #7292
  {14,  1,   0}, // #7293
  {15,  1,   0}, // #7294
  {16,  2,   0}, // #7295
  {17,  1,   0}, // #7296
  {18,  1,   0}, // #7297
  {19,  1,   0}, // #7298
  {20,  1,   0}, // #7299
  {21,  1,   0}, // #7300
  {22,  2,   0}, // #7301
  {23,  3,   0}, // #7302
  { 4,  1,   0}, // #7303
  { 9,  1,   0}, // #7304
  {11,  1,   0}, // #7305
  {14,  1,   0}, // #7306
  {15,  1,   0}, // #7307
  {16,  2,   0}, // #7308
  {18,  1,   0}, // #7309
  {19,  1,   0}, // #7310
  {20,  1,   0}, // #7311
  {22,  2,   0}, // #7312
  {23,  2,   0}, // #7313
  { 2, 17,   0}, // #7314
  { 3,  1,   0}, // #7315
  {11,  1,   0}, // #7316
  {12,  1,   0}, // #7317
  {13,  1,   0}, // #7318
  {14,  1,   0}, // #7319
  {19,  1,   0}, // #7320
  {20,  1,   0}, // #7321
  {22,  1,   0}, // #7322
  {23,  1,   0}, // #7323
  { 4,  1,   0}, // #7324
  { 7,  1,   0}, // #7325
  { 8,  1,   0}, // #7326
  {11,  1,   0}, // #7327
  {12,  1,   0}, // #7328
  {13,  1,   0}, // #7329
  {15,  2,   0}, // #7330
  {16,  1,   0}, // #7331
  {18,  1,   0}, // #7332
  {19,  2,   0}, // #7333
  {20,  1,   0}, // #7334
  {21,  1,   0}, // #7335
  {22,  2,   0}, // #7336
  {23,  4,   0}, // #7337
  { 2, 28,   0}, // #7338
  { 3,  2,   0}, // #7339
  {11,  2,   0}, // #7340
  {12,  2,   0}, // #7341
  {13,  2,   0}, // #7342
  {14,  2,   0}, // #7343
  {15,  1,   0}, // #7344
  {17,  1,   0}, // #7345
  {19,  3,   0}, // #7346
  {20,  2,   0}, // #7347
  {21,  1,   0}, // #7348
  {22,  3,   0}, // #7349
  {23,  4,   0}, // #7350
  { 2, 28,   0}, // #7351
  { 3,  2,   0}, // #7352
  {11,  2,   0}, // #7353
  {12,  2,   0}, // #7354
  {13,  2,   0}, // #7355
  {14,  2,   0}, // #7356
  {15,  1,   0}, // #7357
  {19,  3,   0}, // #7358
  {20,  2,   0}, // #7359
  {22,  3,   0}, // #7360
  {23,  3,   0}, // #7361
  { 2, 14,   0}, // #7362
  { 3,  2,   0}, // #7363
  {11,  2,   0}, // #7364
  {12,  2,   0}, // #7365
  {13,  2,   0}, // #7366
  {14,  2,   0}, // #7367
  {15,  1,   0}, // #7368
  {17,  1,   0}, // #7369
  {19,  3,   0}, // #7370
  {20,  2,   0}, // #7371
  {21,  1,   0}, // #7372
  {22,  3,   0}, // #7373
  {23,  4,   0}, // #7374
  { 2, 14,   0}, // #7375
  { 3,  2,   0}, // #7376
  {11,  2,   0}, // #7377
  {12,  2,   0}, // #7378
  {13,  2,   0}, // #7379
  {14,  2,   0}, // #7380
  {15,  1,   0}, // #7381
  {19,  3,   0}, // #7382
  {20,  2,   0}, // #7383
  {22,  3,   0}, // #7384
  {23,  3,   0}, // #7385
  { 3,  2,   0}, // #7386
  { 4,  1,   0}, // #7387
  { 8,  2,   0}, // #7388
  { 9,  4,   0}, // #7389
  {11,  5,   0}, // #7390
  {12,  2,   0}, // #7391
  {13,  4,   0}, // #7392
  {14,  6,   0}, // #7393
  {15,  3,   0}, // #7394
  {16,  5,   0}, // #7395
  {18,  6,   0}, // #7396
  {19,  7,   0}, // #7397
  {20,  8,   0}, // #7398
  {22, 15,   0}, // #7399
  {23, 15,   0}, // #7400
  { 7,  1,   0}, // #7401
  {12,  1,   0}, // #7402
  {17,  2,   0}, // #7403
  {21,  2,   0}, // #7404
  {22,  2,   0}, // #7405
  {23,  5,   0}, // #7406
  {17,  1,   0}, // #7407
  {21,  1,   0}, // #7408
  {22, 14,   0}, // #7409
  {23, 15,   0}, // #7410
  {17,  2,   0}, // #7411
  {21,  2,   0}, // #7412
  {22,  3,   0}, // #7413
  {23,  5,   0}, // #7414
  { 9,  2,   0}, // #7415
  {14,  2,   0}, // #7416
  {16,  2,   0}, // #7417
  {17,  1,   0}, // #7418
  {18,  2,   0}, // #7419
  {19,  1,   0}, // #7420
  {20,  2,   0}, // #7421
  {21,  1,   0}, // #7422
  {22,  3,   0}, // #7423
  {23,  4,   0}, // #7424
  {17,  1,   0}, // #7425
  {19, 16,   0}, // #7426
  {21,  1,   0}, // #7427
  {22, 16,   0}, // #7428
  {23, 17,   0}, // #7429
  { 3,  2,   0}, // #7430
  { 8,  2,   0}, // #7431
  {11,  2,   0}, // #7432
  {12,  2,   0}, // #7433
  {13,  4,   0}, // #7434
  {14,  4,   0}, // #7435
  {15,  3,   0}, // #7436
  {17,  2,   0}, // #7437
  {18,  2,   0}, // #7438
  {19,  8,   0}, // #7439
  {20,  6,   0}, // #7440
  {21,  2,   0}, // #7441
  {22, 10,   0}, // #7442
  {23, 12,   0}, // #7443
  { 3,  3,   0}, // #7444
  { 8,  3,   0}, // #7445
  {11,  3,   0}, // #7446
  {12,  3,   0}, // #7447
  {13,  6,   0}, // #7448
  {14,  7,   0}, // #7449
  {15,  4,   0}, // #7450
  {17,  4,   0}, // #7451
  {18,  3,   0}, // #7452
  {19, 12,   0}, // #7453
  {20, 10,   0}, // #7454
  {21,  4,   0}, // #7455
  {22, 16,   0}, // #7456
  {23, 20,   0}, // #7457
  { 3,  5,   0}, // #7458
  { 8,  3,   0}, // #7459
  {11,  5,   0}, // #7460
  {12,  5,   0}, // #7461
  {13,  8,   0}, // #7462
  {14, 13,   0}, // #7463
  {15,  4,   0}, // #7464
  {17,  8,   0}, // #7465
  {18,  3,   0}, // #7466
  {19, 18,   0}, // #7467
  {20, 16,   0}, // #7468
  {21,  8,   0}, // #7469
  {22, 26,   0}, // #7470
  {23, 34,   0}, // #7471
  { 3,  3,   0}, // #7472
  { 8,  3,   0}, // #7473
  {11,  3,   0}, // #7474
  {12,  3,   0}, // #7475
  {13,  6,   0}, // #7476
  {14,  5,   0}, // #7477
  {15,  4,   0}, // #7478
  {17,  2,   0}, // #7479
  {18,  3,   0}, // #7480
  {19, 10,   0}, // #7481
  {20,  8,   0}, // #7482
  {21,  2,   0}, // #7483
  {22, 12,   0}, // #7484
  {23, 14,   0}, // #7485
  { 3,  5,   0}, // #7486
  { 8,  3,   0}, // #7487
  {11,  5,   0}, // #7488
  {12,  5,   0}, // #7489
  {13,  8,   0}, // #7490
  {14,  9,   0}, // #7491
  {15,  4,   0}, // #7492
  {17,  4,   0}, // #7493
  {18,  3,   0}, // #7494
  {19, 14,   0}, // #7495
  {20, 12,   0}, // #7496
  {21,  4,   0}, // #7497
  {22, 18,   0}, // #7498
  {23, 22,   0}, // #7499
  { 3,  3,   0}, // #7500
  { 8,  3,   0}, // #7501
  {11,  3,   0}, // #7502
  {12,  3,   0}, // #7503
  {13,  6,   0}, // #7504
  {14,  5,   0}, // #7505
  {15,  4,   0}, // #7506
  {17,  2,   0}, // #7507
  {18,  3,   0}, // #7508
  {19, 11,   0}, // #7509
  {20,  8,   0}, // #7510
  {21,  2,   0}, // #7511
  {22, 13,   0}, // #7512
  {23, 15,   0}, // #7513
  {14,  1,   0}, // #7514
  {17,  1,   0}, // #7515
  {20,  1,   0}, // #7516
  {21,  1,   0}, // #7517
  {22,  3,   0}, // #7518
  {23,  4,   0}, // #7519
  { 4,  2,   0}, // #7520
  { 5,  3,   0}, // #7521
  { 7,  2,   0}, // #7522
  { 8,  2,   0}, // #7523
  {14,  2,   0}, // #7524
  {15,  1,   0}, // #7525
  {18,  1,   0}, // #7526
  {22,  1,   0}, // #7527
  {14,  1,   0}, // #7528
  {18,  1,   0}, // #7529
  {22,  1,   0}, // #7530
  { 5,  1,   0}, // #7531
  {14,  2,   0}, // #7532
  {15,  1,   0}, // #7533
  {18,  1,   0}, // #7534
  {22,  1,   0}, // #7535
  { 4,  1,   0}, // #7536
  { 5,  2,   0}, // #7537
  { 7,  1,   0}, // #7538
  { 8,  1,   0}, // #7539
  {14,  2,   0}, // #7540
  {15,  1,   0}, // #7541
  {18,  1,   0}, // #7542
  {22,  1,   0}, // #7543
  { 3,  1,   0}, // #7544
  { 4,  1,   0}, // #7545
  { 5,  1,   0}, // #7546
  {10,  1,   0}, // #7547
  {11,  1,   0}, // #7548
  {14,  1,   0}, // #7549
  {15,  1,   0}, // #7550
  { 2,  1,   0}, // #7551
  { 3,  1,   0}, // #7552
  { 4,  1,   0}, // #7553
  { 5,  1,   0}, // #7554
  {14,  1,   0}, // #7555
  {15,  1,   0}, // #7556
  { 2,  2,   0}, // #7557
  { 3,  2,   0}, // #7558
  { 4,  2,   0}, // #7559
  { 5,  2,   0}, // #7560
  {14,  1,   0}, // #7561
  {15,  1,   0}, // #7562
  { 1,  4,   0}, // #7563
  { 2,  5,   0}, // #7564
  { 3, 11,   0}, // #7565
  { 4, 13,   0}, // #7566
  { 5, 13,   0}, // #7567
  { 6,  7,   0}, // #7568
  { 7,  9,   0}, // #7569
  { 8,  6,   0}, // #7570
  {10,  6,   0}, // #7571
  {11,  6,   0}, // #7572
  {14,  1,   0}, // #7573
  {15,  1,   0}, // #7574
  {19,  3,   0}, // #7575
  { 1,  4,   0}, // #7576
  { 2,  5,   0}, // #7577
  { 3, 12,   0}, // #7578
  { 4, 14,   0}, // #7579
  { 5, 14,   0}, // #7580
  { 6,  7,   0}, // #7581
  { 7,  9,   0}, // #7582
  { 8,  6,   0}, // #7583
  {10,  6,   0}, // #7584
  {11,  6,   0}, // #7585
  {19,  3,   0}, // #7586
  { 2,  1,   0}, // #7587
  { 3,  1,   0}, // #7588
  { 4,  2,   0}, // #7589
  { 5,  2,   0}, // #7590
  { 7,  1,   0}, // #7591
  { 8,  1,   0}, // #7592
  { 9,  1,   0}, // #7593
  {10,  1,   0}, // #7594
  {11,  1,   0}, // #7595
  {14,  1,   0}, // #7596
  {15,  1,   0}, // #7597
  { 5,  1,   0}, // #7598
  {11,  1,   0}, // #7599
  {14,  1,   0}, // #7600
  {15,  1,   0}, // #7601
  { 2,  1,   0}, // #7602
  { 3,  1,   0}, // #7603
  { 4,  1,   0}, // #7604
  { 5,  1,   0}, // #7605
  { 9,  1,   0}, // #7606
  {10,  1,   0}, // #7607
  {11,  1,   0}, // #7608
  {14,  1,   0}, // #7609
  {15,  1,   0}, // #7610
  { 2,  1,   0}, // #7611
  { 3,  1,   0}, // #7612
  { 4,  3,   0}, // #7613
  { 5,  9,   0}, // #7614
  { 7,  2,   0}, // #7615
  { 8,  2,   0}, // #7616
  { 9,  1,   0}, // #7617
  {10,  1,   0}, // #7618
  {11,  3,   0}, // #7619
  {14,  1,   0}, // #7620
  {15,  1,   0}, // #7621
  { 2,  1,   0}, // #7622
  { 3,  1,   0}, // #7623
  { 4,  1,   0}, // #7624
  { 5,  1,   0}, // #7625
  { 9,  1,   0}, // #7626
  {10,  1,   0}, // #7627
  {11,  1,   0}, // #7628
  {14,  2,   0}, // #7629
  {15,  1,   0}, // #7630
  {18,  1,   0}, // #7631
  {22,  1,   0}, // #7632
  { 2,  1,   0}, // #7633
  { 3,  1,   0}, // #7634
  { 4,  3,   0}, // #7635
  { 5,  8,   0}, // #7636
  { 7,  2,   0}, // #7637
  { 8,  2,   0}, // #7638
  { 9,  1,   0}, // #7639
  {10,  1,   0}, // #7640
  {11,  3,   0}, // #7641
  {14,  2,   0}, // #7642
  {15,  1,   0}, // #7643
  {18,  1,   0}, // #7644
  {22,  1,   0}, // #7645
  { 3,  1,   0}, // #7646
  { 4,  1,   0}, // #7647
  { 5,  1,   0}, // #7648
  { 6,  1,   0}, // #7649
  { 7,  1,   0}, // #7650
  {10,  1,   0}, // #7651
  {11,  1,   0}, // #7652
  {19,  1,   0}, // #7653
  { 2,  1,   0}, // #7654
  { 3,  2,   0}, // #7655
  { 4,  2,   0}, // #7656
  { 5,  2,   0}, // #7657
  { 6,  1,   0}, // #7658
  { 7,  1,   0}, // #7659
  {10,  1,   0}, // #7660
  {11,  1,   0}, // #7661
  {19,  1,   0}, // #7662
  { 2,  1,   0}, // #7663
  { 3,  2,   0}, // #7664
  { 4,  2,   0}, // #7665
  { 5,  2,   0}, // #7666
  { 6,  1,   0}, // #7667
  { 7,  1,   0}, // #7668
  {10,  1,   0}, // #7669
  {11,  1,   0}, // #7670
  {14,  1,   0}, // #7671
  {15,  1,   0}, // #7672
  {19,  1,   0}, // #7673
  { 1,  1,   0}, // #7674
  { 2,  2,   0}, // #7675
  { 3,  2,   0}, // #7676
  { 4,  2,   0}, // #7677
  { 5,  2,   0}, // #7678
  { 6,  1,   0}, // #7679
  { 7,  1,   0}, // #7680
  { 8,  1,   0}, // #7681
  {14,  1,   0}, // #7682
  {15,  1,   0}, // #7683
  { 2,  1,   0}, // #7684
  { 3,  3,   0}, // #7685
  { 4,  3,   0}, // #7686
  { 5,  3,   0}, // #7687
  { 6,  1,   0}, // #7688
  { 7,  1,   0}, // #7689
  {10,  1,   0}, // #7690
  {11,  1,   0}, // #7691
  {19,  1,   0}, // #7692
  { 2,  3,   0}, // #7693
  { 3,  3,   0}, // #7694
  { 4,  3,   0}, // #7695
  { 5,  4,   0}, // #7696
  { 9,  3,   0}, // #7697
  {10,  3,   0}, // #7698
  {11,  3,   0}, // #7699
  {14,  1,   0}, // #7700
  {15,  1,   0}, // #7701
  { 2,  3,   0}, // #7702
  { 3,  3,   0}, // #7703
  { 4,  3,   0}, // #7704
  { 5,  3,   0}, // #7705
  { 9,  3,   0}, // #7706
  {10,  3,   0}, // #7707
  {11,  3,   0}, // #7708
  {14,  1,   0}, // #7709
  {15,  1,   0}, // #7710
  { 2,  2,   0}, // #7711
  { 3,  3,   0}, // #7712
  { 4,  3,   0}, // #7713
  { 5,  3,   0}, // #7714
  {10,  1,   0}, // #7715
  {11,  1,   0}, // #7716
  {14,  1,   0}, // #7717
  {15,  1,   0}, // #7718
  { 2,  2,   0}, // #7719
  { 3,  5,   0}, // #7720
  { 4,  6,   0}, // #7721
  { 5,  6,   0}, // #7722
  { 6,  1,   0}, // #7723
  { 7,  2,   0}, // #7724
  { 8,  1,   0}, // #7725
  {10,  3,   0}, // #7726
  {11,  3,   0}, // #7727
  {14,  1,   0}, // #7728
  {15,  1,   0}, // #7729
  {19,  1,   0}, // #7730
  { 2,  2,   0}, // #7731
  { 3,  5,   0}, // #7732
  { 4,  6,   0}, // #7733
  { 5,  6,   0}, // #7734
  { 6,  1,   0}, // #7735
  { 7,  2,   0}, // #7736
  { 8,  1,   0}, // #7737
  {10,  3,   0}, // #7738
  {11,  3,   0}, // #7739
  {19,  1,   0}, // #7740
  { 3,  1,   0}, // #7741
  { 4,  1,   0}, // #7742
  { 5,  1,   0}, // #7743
  {10,  1,   0}, // #7744
  {11,  1,   0}, // #7745
  {14,  1,   0}, // #7746
  {18,  1,   0}, // #7747
  {22,  1,   0}, // #7748
  { 3,  3,   0}, // #7749
  { 4,  3,   0}, // #7750
  { 5,  3,   0}, // #7751
  { 6,  2,   0}, // #7752
  { 7,  2,   0}, // #7753
  {10,  3,   0}, // #7754
  {11,  3,   0}, // #7755
  {14,  1,   0}, // #7756
  {15,  1,   0}, // #7757
  {19,  2,   0}, // #7758
  { 3,  3,   0}, // #7759
  { 4,  3,   0}, // #7760
  { 5,  3,   0}, // #7761
  { 6,  2,   0}, // #7762
  { 7,  2,   0}, // #7763
  {10,  3,   0}, // #7764
  {11,  3,   0}, // #7765
  {19,  2,   0}, // #7766
  { 2,  1,   0}, // #7767
  { 3,  1,   0}, // #7768
  { 4,  2,   0}, // #7769
  { 5,  4,   0}, // #7770
  { 7,  1,   0}, // #7771
  { 8,  1,   0}, // #7772
  { 9,  1,   0}, // #7773
  {10,  1,   0}, // #7774
  {11,  1,   0}, // #7775
  {14,  1,   0}, // #7776
  {15,  1,   0}, // #7777
  { 2,  1,   0}, // #7778
  { 3,  1,   0}, // #7779
  { 4,  1,   0}, // #7780
  { 5,  2,   0}, // #7781
  { 9,  1,   0}, // #7782
  {10,  1,   0}, // #7783
  {11,  1,   0}, // #7784
  {14,  1,   0}, // #7785
  {15,  1,   0}, // #7786
  { 2,  1,   0}, // #7787
  { 3,  1,   0}, // #7788
  { 4,  2,   0}, // #7789
  { 5,  3,   0}, // #7790
  { 7,  1,   0}, // #7791
  { 8,  1,   0}, // #7792
  { 9,  1,   0}, // #7793
  {10,  1,   0}, // #7794
  {11,  1,   0}, // #7795
  {14,  1,   0}, // #7796
  {15,  1,   0}, // #7797
  { 2,  1,   0}, // #7798
  { 3,  2,   0}, // #7799
  { 4,  2,   0}, // #7800
  { 5,  2,   0}, // #7801
  { 6,  1,   0}, // #7802
  { 7,  1,   0}, // #7803
  { 9,  1,   0}, // #7804
  {10,  2,   0}, // #7805
  {11,  2,   0}, // #7806
  {14,  1,   0}, // #7807
  {15,  1,   0}, // #7808
  {19,  1,   0}, // #7809
  { 2,  1,   0}, // #7810
  { 3,  2,   0}, // #7811
  { 4,  2,   0}, // #7812
  { 5,  2,   0}, // #7813
  { 6,  1,   0}, // #7814
  { 7,  1,   0}, // #7815
  { 9,  1,   0}, // #7816
  {10,  2,   0}, // #7817
  {11,  2,   0}, // #7818
  {19,  1,   0}, // #7819
  { 1,  1,   0}, // #7820
  { 2,  1,   0}, // #7821
  { 3,  2,   0}, // #7822
  { 4,  3,   0}, // #7823
  { 5,  3,   0}, // #7824
  { 6,  1,   0}, // #7825
  { 7,  2,   0}, // #7826
  { 8,  2,   0}, // #7827
  {14,  1,   0}, // #7828
  {15,  1,   0}, // #7829
  { 3,  1,   0}, // #7830
  { 4,  1,   0}, // #7831
  { 5,  1,   0}, // #7832
  { 6,  1,   0}, // #7833
  { 7,  1,   0}, // #7834
  {14,  1,   0}, // #7835
  {15,  1,   0}, // #7836
  { 3,  3,   0}, // #7837
  { 4,  3,   0}, // #7838
  { 5,  3,   0}, // #7839
  { 6,  3,   0}, // #7840
  { 7,  3,   0}, // #7841
  {10,  2,   0}, // #7842
  {11,  2,   0}, // #7843
  {14,  1,   0}, // #7844
  {15,  1,   0}, // #7845
  {19,  2,   0}, // #7846
  { 3,  3,   0}, // #7847
  { 4,  3,   0}, // #7848
  { 5,  3,   0}, // #7849
  { 6,  3,   0}, // #7850
  { 7,  3,   0}, // #7851
  {10,  2,   0}, // #7852
  {11,  2,   0}, // #7853
  {19,  2,   0}, // #7854
  { 3,  2,   0}, // #7855
  { 4,  2,   0}, // #7856
  { 5,  2,   0}, // #7857
  { 6,  1,   0}, // #7858
  { 7,  1,   0}, // #7859
  {10,  2,   0}, // #7860
  {11,  2,   0}, // #7861
  {19,  1,   0}, // #7862
  { 1,  1,   0}, // #7863
  { 2,  1,   0}, // #7864
  { 3,  2,   0}, // #7865
  { 4,  2,   0}, // #7866
  { 5,  2,   0}, // #7867
  { 6,  2,   0}, // #7868
  { 7,  2,   0}, // #7869
  { 8,  1,   0}, // #7870
  {10,  1,   0}, // #7871
  {11,  1,   0}, // #7872
  {14,  1,   0}, // #7873
  {15,  1,   0}, // #7874
  {19,  1,   0}, // #7875
  { 1,  1,   0}, // #7876
  { 2,  1,   0}, // #7877
  { 3,  2,   0}, // #7878
  { 4,  2,   0}, // #7879
  { 5,  2,   0}, // #7880
  { 6,  2,   0}, // #7881
  { 7,  2,   0}, // #7882
  { 8,  1,   0}, // #7883
  {10,  1,   0}, // #7884
  {11,  1,   0}, // #7885
  {19,  1,   0}, // #7886
  { 3,  2,   0}, // #7887
  { 4,  2,   0}, // #7888
  { 5,  2,   0}, // #7889
  { 6,  1,   0}, // #7890
  { 7,  1,   0}, // #7891
  {10,  2,   0}, // #7892
  {11,  2,   0}, // #7893
  {14,  1,   0}, // #7894
  {15,  1,   0}, // #7895
  {19,  1,   0}, // #7896
  { 1,  3,   0}, // #7897
  { 2,  4,   0}, // #7898
  { 3,  6,   0}, // #7899
  { 4,  7,   0}, // #7900
  { 5,  7,   0}, // #7901
  { 6,  4,   0}, // #7902
  { 7,  5,   0}, // #7903
  { 8,  4,   0}, // #7904
  { 9,  1,   0}, // #7905
  {10,  2,   0}, // #7906
  {11,  2,   0}, // #7907
  {14,  1,   0}, // #7908
  {15,  1,   0}, // #7909
  {19,  1,   0}, // #7910
  { 1,  3,   0}, // #7911
  { 2,  4,   0}, // #7912
  { 3,  7,   0}, // #7913
  { 4,  8,   0}, // #7914
  { 5,  8,   0}, // #7915
  { 6,  4,   0}, // #7916
  { 7,  5,   0}, // #7917
  { 8,  4,   0}, // #7918
  { 9,  1,   0}, // #7919
  {10,  2,   0}, // #7920
  {11,  2,   0}, // #7921
  {19,  1,   0}, // #7922
  { 1,  3,   0}, // #7923
  { 2,  4,   0}, // #7924
  { 3,  7,   0}, // #7925
  { 4,  8,   0}, // #7926
  { 5,  8,   0}, // #7927
  { 6,  4,   0}, // #7928
  { 7,  5,   0}, // #7929
  { 8,  4,   0}, // #7930
  { 9,  1,   0}, // #7931
  {10,  2,   0}, // #7932
  {11,  2,   0}, // #7933
  {14,  1,   0}, // #7934
  {15,  1,   0}, // #7935
  {19,  1,   0}, // #7936
  { 1,  3,   0}, // #7937
  { 2,  4,   0}, // #7938
  { 3,  8,   0}, // #7939
  { 4,  9,   0}, // #7940
  { 5,  9,   0}, // #7941
  { 6,  4,   0}, // #7942
  { 7,  5,   0}, // #7943
  { 8,  4,   0}, // #7944
  { 9,  1,   0}, // #7945
  {10,  2,   0}, // #7946
  {11,  2,   0}, // #7947
  {19,  1,   0}, // #7948
  { 1,  3,   0}, // #7949
  { 2,  3,   0}, // #7950
  { 3,  3,   0}, // #7951
  { 4,  3,   0}, // #7952
  { 5,  3,   0}, // #7953
  { 6,  3,   0}, // #7954
  { 7,  3,   0}, // #7955
  { 8,  3,   0}, // #7956
  {14,  1,   0}, // #7957
  {15,  1,   0}, // #7958
  { 3,  3,   0}, // #7959
  { 4,  3,   0}, // #7960
  { 5,  3,   0}, // #7961
  {10,  2,   0}, // #7962
  {11,  2,   0}, // #7963
  {14,  1,   0}, // #7964
  {15,  1,   0}, // #7965
  { 2,  2,   0}, // #7966
  { 3,  2,   0}, // #7967
  { 4,  5,   0}, // #7968
  { 5,  7,   0}, // #7969
  { 7,  3,   0}, // #7970
  { 8,  3,   0}, // #7971
  { 9,  2,   0}, // #7972
  {10,  2,   0}, // #7973
  {11,  2,   0}, // #7974
  {14,  2,   0}, // #7975
  {15,  1,   0}, // #7976
  {18,  1,   0}, // #7977
  {22,  1,   0}, // #7978
  { 4,  1,   0}, // #7979
  { 5,  1,   0}, // #7980
  { 7,  1,   0}, // #7981
  { 8,  1,   0}, // #7982
  {14,  2,   0}, // #7983
  {15,  1,   0}, // #7984
  {18,  1,   0}, // #7985
  {22,  1,   0}, // #7986
  { 4,  2,   0}, // #7987
  { 5,  2,   0}, // #7988
  { 7,  2,   0}, // #7989
  { 8,  2,   0}, // #7990
  {14,  2,   0}, // #7991
  {15,  1,   0}, // #7992
  {18,  1,   0}, // #7993
  {22,  1,   0}, // #7994
  { 4,  2,   0}, // #7995
  { 5,  2,   0}, // #7996
  { 7,  2,   0}, // #7997
  { 8,  2,   0}, // #7998
  {14,  1,   0}, // #7999
  {18,  1,   0}, // #8000
  {22,  1,   0}, // #8001
  { 2,  1,   0}, // #8002
  { 3,  1,   0}, // #8003
  { 4,  2,   0}, // #8004
  { 5,  3,   0}, // #8005
  { 7,  1,   0}, // #8006
  { 8,  1,   0}, // #8007
  { 9,  1,   0}, // #8008
  {10,  1,   0}, // #8009
  {11,  1,   0}, // #8010
  {14,  2,   0}, // #8011
  {15,  1,   0}, // #8012
  {18,  1,   0}, // #8013
  {22,  1,   0}, // #8014
  { 2,  1,   0}, // #8015
  { 3,  1,   0}, // #8016
  { 4,  1,   0}, // #8017
  { 5,  2,   0}, // #8018
  { 9,  1,   0}, // #8019
  {10,  1,   0}, // #8020
  {11,  1,   0}, // #8021
  {14,  2,   0}, // #8022
  {15,  1,   0}, // #8023
  {18,  1,   0}, // #8024
  {22,  1,   0}, // #8025
  { 1,  1,   0}, // #8026
  { 2,  1,   0}, // #8027
  { 3,  1,   0}, // #8028
  { 4,  1,   0}, // #8029
  { 5,  1,   0}, // #8030
  { 6,  1,   0}, // #8031
  { 7,  1,   0}, // #8032
  { 8,  1,   0}, // #8033
  {27,  7,   0}, // #8034
  { 1,  1,   0}, // #8035
  { 2,  1,   0}, // #8036
  { 3,  1,   0}, // #8037
  { 4,  2,   0}, // #8038
  { 5,  2,   0}, // #8039
  { 6,  1,   0}, // #8040
  { 7,  2,   0}, // #8041
  { 8,  2,   0}, // #8042
  {14,  1,   0}, // #8043
  {18,  1,   0}, // #8044
  {22,  1,   0}, // #8045
  { 3,  2,   0}, // #8046
  { 4,  2,   0}, // #8047
  { 5,  2,   0}, // #8048
  { 6,  2,   0}, // #8049
  { 7,  2,   0}, // #8050
  {10,  2,   0}, // #8051
  {11,  2,   0}, // #8052
  {19,  2,   0}, // #8053
  { 1,  1,   0}, // #8054
  { 2,  1,   0}, // #8055
  { 3,  4,   0}, // #8056
  { 4,  5,   0}, // #8057
  { 5,  5,   0}, // #8058
  { 6,  4,   0}, // #8059
  { 7,  5,   0}, // #8060
  { 8,  2,   0}, // #8061
  {10,  1,   0}, // #8062
  {11,  1,   0}, // #8063
  {14,  1,   0}, // #8064
  {15,  1,   0}, // #8065
  {19,  1,   0}, // #8066
  { 1,  1,   0}, // #8067
  { 2,  1,   0}, // #8068
  { 3,  4,   0}, // #8069
  { 4,  4,   0}, // #8070
  { 5,  4,   0}, // #8071
  { 6,  4,   0}, // #8072
  { 7,  4,   0}, // #8073
  { 8,  1,   0}, // #8074
  {10,  1,   0}, // #8075
  {11,  1,   0}, // #8076
  {19,  1,   0}, // #8077
  { 2,  1,   0}, // #8078
  { 3,  1,   0}, // #8079
  { 4,  1,   0}, // #8080
  { 5,  1,   0}, // #8081
  {14,  1,   0}, // #8082
  {18,  1,   0}, // #8083
  {22,  1,   0}, // #8084
  { 1,  1,   0}, // #8085
  { 2,  1,   0}, // #8086
  { 3,  1,   0}, // #8087
  { 4,  1,   0}, // #8088
  { 5,  1,   0}, // #8089
  { 6,  1,   0}, // #8090
  { 7,  1,   0}, // #8091
  { 8,  1,   0}, // #8092
  {14,  1,   0}, // #8093
  {18,  1,   0}, // #8094
  {22,  1,   0}, // #8095
  { 1,  2,   0}, // #8096
  { 2,  2,   0}, // #8097
  { 3,  3,   0}, // #8098
  { 4,  3,   0}, // #8099
  { 5,  3,   0}, // #8100
  { 6,  3,   0}, // #8101
  { 7,  3,   0}, // #8102
  { 8,  2,   0}, // #8103
  {14,  1,   0}, // #8104
  {15,  1,   0}, // #8105
  { 1,  2,   0}, // #8106
  { 2,  2,   0}, // #8107
  { 3,  2,   0}, // #8108
  { 4,  2,   0}, // #8109
  { 5,  2,   0}, // #8110
  { 6,  2,   0}, // #8111
  { 7,  2,   0}, // #8112
  { 8,  2,   0}, // #8113
  {14,  1,   0}, // #8114
  {15,  1,   0}, // #8115
  { 1,  2,   0}, // #8116
  { 2,  3,   0}, // #8117
  { 3,  7,   0}, // #8118
  { 4, 15,   0}, // #8119
  { 5, 15,   0}, // #8120
  { 6,  6,   0}, // #8121
  { 7, 10,   0}, // #8122
  { 8,  6,   0}, // #8123
  { 9,  1,   0}, // #8124
  {10,  3,   0}, // #8125
  {11,  3,   0}, // #8126
  {19,  2,   0}, // #8127
  {20,  4,   0}, // #8128
  { 2,  1,   0}, // #8129
  { 3,  3,   0}, // #8130
  { 4,  3,   0}, // #8131
  { 5,  3,   0}, // #8132
  { 6,  2,   0}, // #8133
  { 7,  2,   0}, // #8134
  {10,  2,   0}, // #8135
  {11,  2,   0}, // #8136
  {19,  2,   0}, // #8137
  { 1,  1,   0}, // #8138
  { 2,  2,   0}, // #8139
  { 3,  3,   0}, // #8140
  { 4,  3,   0}, // #8141
  { 5,  3,   0}, // #8142
  { 6,  2,   0}, // #8143
  { 7,  2,   0}, // #8144
  { 8,  1,   0}, // #8145
  {10,  1,   0}, // #8146
  {11,  1,   0}, // #8147
  {19,  1,   0}, // #8148
  { 5,  3,   0}, // #8149
  {14,  1,   0}, // #8150
  {15,  1,   0}, // #8151
  { 5,  4,   0}, // #8152
  {14,  2,   0}, // #8153
  {15,  1,   0}, // #8154
  {18,  1,   0}, // #8155
  {22,  1,   0}, // #8156
  { 4,  1,   0}, // #8157
  { 5,  6,   0}, // #8158
  { 7,  1,   0}, // #8159
  { 8,  1,   0}, // #8160
  {14,  2,   0}, // #8161
  {15,  1,   0}, // #8162
  {18,  1,   0}, // #8163
  {22,  1,   0}, // #8164
  { 1,  1,   0}, // #8165
  { 2,  1,   0}, // #8166
  { 3,  2,   0}, // #8167
  { 4,  2,   0}, // #8168
  { 5,  2,   0}, // #8169
  { 6,  2,   0}, // #8170
  { 7,  2,   0}, // #8171
  { 8,  1,   0}, // #8172
  {14,  1,   0}, // #8173
  {15,  1,   0}, // #8174
  { 3,  1,   0}, // #8175
  { 4,  1,   0}, // #8176
  { 5,  1,   0}, // #8177
  { 6,  1,   0}, // #8178
  { 7,  1,   0}, // #8179
  {10,  1,   0}, // #8180
  {11,  1,   0}, // #8181
  {17,  1,   0}, // #8182
  {18,  2,   0}, // #8183
  {19,  1,   0}, // #8184
  { 4,  1,   0}, // #8185
  { 5,  1,   0}, // #8186
  { 7,  1,   0}, // #8187
  { 8,  1,   0}, // #8188
  {17,  1,   0}, // #8189
  {18,  2,   0}, // #8190
  {20,  1,   0}, // #8191
  { 3,  1,   0}, // #8192
  { 4,  2,   0}, // #8193
  { 5,  2,   0}, // #8194
  { 6,  1,   0}, // #8195
  { 7,  2,   0}, // #8196
  { 8,  1,   0}, // #8197
  {10,  1,   0}, // #8198
  {11,  1,   0}, // #8199
  {19,  1,   0}, // #8200
  { 2,  2,   0}, // #8201
  { 3,  2,   0}, // #8202
  { 4,  9,   0}, // #8203
  { 5, 13,   0}, // #8204
  { 7,  7,   0}, // #8205
  { 8,  7,   0}, // #8206
  { 9,  2,   0}, // #8207
  {10,  2,   0}, // #8208
  {11,  2,   0}, // #8209
  {14,  2,   0}, // #8210
  {15,  1,   0}, // #8211
  {18,  1,   0}, // #8212
  {22,  1,   0}, // #8213
  { 1,  2,   0}, // #8214
  { 2,  2,   0}, // #8215
  { 3,  6,   0}, // #8216
  { 4, 12,   0}, // #8217
  { 5, 19,   0}, // #8218
  { 6,  4,   0}, // #8219
  { 7, 10,   0}, // #8220
  { 8,  8,   0}, // #8221
  {10,  4,   0}, // #8222
  {11,  4,   0}, // #8223
  {14,  2,   0}, // #8224
  {15,  1,   0}, // #8225
  {18,  1,   0}, // #8226
  {19,  2,   0}, // #8227
  {22,  1,   0}, // #8228
  { 1,  2,   0}, // #8229
  { 2,  8,   0}, // #8230
  { 3, 12,   0}, // #8231
  { 4, 21,   0}, // #8232
  { 5, 21,   0}, // #8233
  { 6,  5,   0}, // #8234
  { 7, 14,   0}, // #8235
  { 8,  9,   0}, // #8236
  { 9,  4,   0}, // #8237
  {10,  7,   0}, // #8238
  {11,  7,   0}, // #8239
  {19,  3,   0}, // #8240
  { 1,  2,   0}, // #8241
  { 2,  4,   0}, // #8242
  { 3, 13,   0}, // #8243
  { 4, 34,   0}, // #8244
  { 5, 34,   0}, // #8245
  { 6, 11,   0}, // #8246
  { 7, 32,   0}, // #8247
  { 8, 23,   0}, // #8248
  { 9,  2,   0}, // #8249
  {10, 11,   0}, // #8250
  {11, 11,   0}, // #8251
  {14, 19,   0}, // #8252
  {15, 14,   0}, // #8253
  {18,  4,   0}, // #8254
  {19,  9,   0}, // #8255
  {22,  5,   0}, // #8256
  { 2,  1,   0}, // #8257
  { 3,  1,   0}, // #8258
  { 4,  3,   0}, // #8259
  { 5,  9,   0}, // #8260
  { 7,  2,   0}, // #8261
  { 8,  2,   0}, // #8262
  { 9,  1,   0}, // #8263
  {10,  1,   0}, // #8264
  {11,  1,   0}, // #8265
  {14,  1,   0}, // #8266
  {15,  1,   0}, // #8267
  { 3,  1,   0}, // #8268
  { 4, 10,   0}, // #8269
  { 5, 10,   0}, // #8270
  { 6,  1,   0}, // #8271
  { 7,  3,   0}, // #8272
  { 8,  2,   0}, // #8273
  {10,  1,   0}, // #8274
  {11,  1,   0}, // #8275
  {19,  1,   0}, // #8276
  {20,  2,   0}, // #8277
  { 1,  7,   0}, // #8278
  { 2, 24,   0}, // #8279
  { 3, 44,   0}, // #8280
  { 4, 70,   0}, // #8281
  { 5, 75,   0}, // #8282
  { 6, 26,   0}, // #8283
  { 7, 52,   0}, // #8284
  { 8, 32,   0}, // #8285
  { 9, 17,   0}, // #8286
  {10, 36,   0}, // #8287
  {11, 37,   0}, // #8288
  {14, 10,   0}, // #8289
  {15,  9,   0}, // #8290
  {18,  1,   0}, // #8291
  {19, 19,   0}, // #8292
  {22,  1,   0}, // #8293
  { 3,  9,   0}, // #8294
  { 4, 15,   0}, // #8295
  { 5, 15,   0}, // #8296
  { 6,  9,   0}, // #8297
  { 7,  9,   0}, // #8298
  {10,  6,   0}, // #8299
  {11,  6,   0}, // #8300
  {19,  6,   0}, // #8301
  { 1,  5,   0}, // #8302
  { 2, 20,   0}, // #8303
  { 3, 35,   0}, // #8304
  { 4, 61,   0}, // #8305
  { 5, 66,   0}, // #8306
  { 6, 20,   0}, // #8307
  { 7, 46,   0}, // #8308
  { 8, 31,   0}, // #8309
  { 9, 15,   0}, // #8310
  {10, 30,   0}, // #8311
  {11, 30,   0}, // #8312
  {14,  6,   0}, // #8313
  {15,  5,   0}, // #8314
  {18,  1,   0}, // #8315
  {19, 15,   0}, // #8316
  {22,  1,   0}, // #8317
  { 1,  5,   0}, // #8318
  { 2, 20,   0}, // #8319
  { 3, 36,   0}, // #8320
  { 4, 61,   0}, // #8321
  { 5, 66,   0}, // #8322
  { 6, 21,   0}, // #8323
  { 7, 46,   0}, // #8324
  { 8, 30,   0}, // #8325
  { 9, 15,   0}, // #8326
  {10, 30,   0}, // #8327
  {11, 30,   0}, // #8328
  {14,  6,   0}, // #8329
  {15,  5,   0}, // #8330
  {18,  1,   0}, // #8331
  {19, 15,   0}, // #8332
  {22,  1,   0}, // #8333
  { 1,  6,   0}, // #8334
  { 2, 23,   0}, // #8335
  { 3, 41,   0}, // #8336
  { 4, 68,   0}, // #8337
  { 5, 73,   0}, // #8338
  { 6, 24,   0}, // #8339
  { 7, 51,   0}, // #8340
  { 8, 33,   0}, // #8341
  { 9, 16,   0}, // #8342
  {10, 34,   0}, // #8343
  {11, 34,   0}, // #8344
  {14,  9,   0}, // #8345
  {15,  8,   0}, // #8346
  {18,  1,   0}, // #8347
  {19, 18,   0}, // #8348
  {22,  1,   0}, // #8349
  { 2,  9,   0}, // #8350
  { 3, 23,   0}, // #8351
  { 4, 53,   0}, // #8352
  { 5, 54,   0}, // #8353
  { 6,  3,   0}, // #8354
  { 7, 33,   0}, // #8355
  { 8, 20,   0}, // #8356
  { 9,  8,   0}, // #8357
  {10, 15,   0}, // #8358
  {11, 16,   0}, // #8359
  {19,  2,   0}, // #8360
  { 1,  7,   0}, // #8361
  { 2, 26,   0}, // #8362
  { 3, 46,   0}, // #8363
  { 4, 71,   0}, // #8364
  { 5, 79,   0}, // #8365
  { 6, 27,   0}, // #8366
  { 7, 52,   0}, // #8367
  { 8, 32,   0}, // #8368
  { 9, 19,   0}, // #8369
  {10, 39,   0}, // #8370
  {11, 41,   0}, // #8371
  {14,  8,   0}, // #8372
  {15,  8,   0}, // #8373
  {19, 20,   0}, // #8374
  { 1,  7,   0}, // #8375
  { 2, 26,   0}, // #8376
  { 3, 46,   0}, // #8377
  { 4, 71,   0}, // #8378
  { 5, 79,   0}, // #8379
  { 6, 27,   0}, // #8380
  { 7, 52,   0}, // #8381
  { 8, 32,   0}, // #8382
  { 9, 19,   0}, // #8383
  {10, 39,   0}, // #8384
  {11, 41,   0}, // #8385
  {14,  7,   0}, // #8386
  {15,  7,   0}, // #8387
  {19, 20,   0}, // #8388
  { 1,  2,   0}, // #8389
  { 2,  9,   0}, // #8390
  { 3, 14,   0}, // #8391
  { 4, 24,   0}, // #8392
  { 5, 24,   0}, // #8393
  { 6,  7,   0}, // #8394
  { 7, 17,   0}, // #8395
  { 8, 12,   0}, // #8396
  { 9,  6,   0}, // #8397
  {10, 11,   0}, // #8398
  {11, 11,   0}, // #8399
  {14,  1,   0}, // #8400
  {18,  1,   0}, // #8401
  {19,  5,   0}, // #8402
  {22,  1,   0}, // #8403
  { 1,  2,   0}, // #8404
  { 2, 12,   0}, // #8405
  { 3, 17,   0}, // #8406
  { 4, 27,   0}, // #8407
  { 5, 32,   0}, // #8408
  { 6,  7,   0}, // #8409
  { 7, 17,   0}, // #8410
  { 8, 12,   0}, // #8411
  { 9, 10,   0}, // #8412
  {10, 15,   0}, // #8413
  {11, 15,   0}, // #8414
  {14, 40,   0}, // #8415
  {15,  2,   0}, // #8416
  {18, 38,   0}, // #8417
  {19,  5,   0}, // #8418
  {22, 38,   0}, // #8419
  { 1,  4,   0}, // #8420
  { 2,  4,   0}, // #8421
  { 3,  6,   0}, // #8422
  { 4, 10,   0}, // #8423
  { 5, 10,   0}, // #8424
  { 6,  5,   0}, // #8425
  { 7,  9,   0}, // #8426
  { 8,  8,   0}, // #8427
  {10,  1,   0}, // #8428
  {11,  1,   0}, // #8429
  {13, 47,   0}, // #8430
  {14, 80,   0}, // #8431
  {15, 80,   0}, // #8432
  {20,  2,   0}, // #8433
  { 1,  8,   0}, // #8434
  { 2, 35,   0}, // #8435
  { 3, 79,   0}, // #8436
  { 4, 142,   0}, // #8437
  { 5, 142,   0}, // #8438
  { 6, 37,   0}, // #8439
  { 7, 100,   0}, // #8440
  { 8, 71,   0}, // #8441
  { 9, 21,   0}, // #8442
  {10, 46,   0}, // #8443
  {11, 46,   0}, // #8444
  {14,  1,   0}, // #8445
  {18,  1,   0}, // #8446
  {19, 10,   0}, // #8447
  {22,  1,   0}, // #8448
  { 2,  1,   0}, // #8449
  { 3,  1,   0}, // #8450
  { 4,  1,   0}, // #8451
  { 5,  1,   0}, // #8452
  { 9,  1,   0}, // #8453
  {10,  1,   0}, // #8454
  {11,  1,   0}, // #8455
  {14,  1,   0}, // #8456
  {18,  1,   0}, // #8457
  {22,  1,   0}, // #8458
  { 3,  1,   0}, // #8459
  { 4,  1,   0}, // #8460
  { 5,  1,   0}, // #8461
  { 6,  1,   0}, // #8462
  { 7,  1,   0}, // #8463
  {10,  1,   0}, // #8464
  {11,  1,   0}, // #8465
  {14,  1,   0}, // #8466
  {18,  1,   0}, // #8467
  {19,  1,   0}, // #8468
  {22,  1,   0}, // #8469
  { 5,  2,   0}, // #8470
  {14,  1,   0}, // #8471
  {18,  1,   0}, // #8472
  {22,  1,   0}, // #8473
  { 2,  1,   0}, // #8474
  { 3,  1,   0}, // #8475
  { 4,  2,   0}, // #8476
  { 5,  2,   0}, // #8477
  { 7,  1,   0}, // #8478
  { 8,  1,   0}, // #8479
  { 9,  1,   0}, // #8480
  {10,  1,   0}, // #8481
  {11,  1,   0}, // #8482
  {14,  1,   0}, // #8483
  {18,  1,   0}, // #8484
  {22,  1,   0}, // #8485
  { 1,  5,   0}, // #8486
  { 2, 13,   0}, // #8487
  { 3, 13,   0}, // #8488
  { 4, 13,   0}, // #8489
  { 5, 13,   0}, // #8490
  { 6,  5,   0}, // #8491
  { 7,  5,   0}, // #8492
  { 8,  5,   0}, // #8493
  { 9,  8,   0}, // #8494
  {10,  8,   0}, // #8495
  {11,  8,   0}, // #8496
  {14, 21,   0}, // #8497
  {15, 21,   0}, // #8498
  { 4,  1,   0}, // #8499
  { 5,  1,   0}, // #8500
  { 7,  1,   0}, // #8501
  { 8,  1,   0}, // #8502
  {14,  1,   0}, // #8503
  {15,  1,   0}, // #8504
  {20,  1,   0}, // #8505
  { 1,  1,   0}, // #8506
  { 2,  1,   0}, // #8507
  { 3,  1,   0}, // #8508
  { 4,  1,   0}, // #8509
  { 5,  1,   0}, // #8510
  { 6,  1,   0}, // #8511
  { 7,  1,   0}, // #8512
  { 8,  1,   0}, // #8513
  {17,  1,   0}, // #8514
  {18,  2,   0}, // #8515
  { 5,  5,   0}, // #8516
  {14,  2,   0}, // #8517
  {15,  2,   0}, // #8518
  { 5,  2,   0}, // #8519
  {14,  2,   0}, // #8520
  {15,  1,   0}, // #8521
  {18,  1,   0}, // #8522
  {22,  1,   0}, // #8523
  { 4,  1,   0}, // #8524
  { 5,  1,   0}, // #8525
  { 7,  1,   0}, // #8526
  { 8,  1,   0}, // #8527
  {13,  1,   0}, // #8528
  {14,  2,   0}, // #8529
  {15,  2,   0}, // #8530
  {17,  1,   0}, // #8531
  {18,  2,   0}, // #8532
  {20,  1,   0}, // #8533
  { 4,  1,   0}, // #8534
  { 5,  3,   0}, // #8535
  { 7,  1,   0}, // #8536
  { 8,  1,   0}, // #8537
  {14,  2,   0}, // #8538
  {15,  1,   0}, // #8539
  {18,  1,   0}, // #8540
  {22,  1,   0}, // #8541
  { 3,  2,   0}, // #8542
  { 4,  2,   0}, // #8543
  { 5,  2,   0}, // #8544
  { 6,  2,   0}, // #8545
  { 7,  2,   0}, // #8546
  {10,  2,   0}, // #8547
  {11,  2,   0}, // #8548
  {14,  1,   0}, // #8549
  {15,  1,   0}, // #8550
  {19,  2,   0}, // #8551
  { 4,  2,   0}, // #8552
  { 5,  2,   0}, // #8553
  { 7,  2,   0}, // #8554
  { 8,  2,   0}, // #8555
  {14,  1,   0}, // #8556
  {15,  1,   0}, // #8557
  { 2,  2,   0}, // #8558
  { 3,  3,   0}, // #8559
  { 4,  9,   0}, // #8560
  { 5, 18,   0}, // #8561
  { 6,  1,   0}, // #8562
  { 7,  7,   0}, // #8563
  { 8,  6,   0}, // #8564
  { 9,  2,   0}, // #8565
  {10,  3,   0}, // #8566
  {11,  3,   0}, // #8567
  {19,  1,   0}, // #8568
  { 1,  2,   0}, // #8569
  { 2,  9,   0}, // #8570
  { 3, 14,   0}, // #8571
  { 4, 21,   0}, // #8572
  { 5, 24,   0}, // #8573
  { 6,  4,   0}, // #8574
  { 7, 11,   0}, // #8575
  { 8,  7,   0}, // #8576
  { 9,  7,   0}, // #8577
  {10, 12,   0}, // #8578
  {11, 12,   0}, // #8579
  {14,  1,   0}, // #8580
  {15,  1,   0}, // #8581
  {19,  2,   0}, // #8582
  { 2,  2,   0}, // #8583
  { 3,  2,   0}, // #8584
  { 4,  2,   0}, // #8585
  { 5,  3,   0}, // #8586
  { 9,  2,   0}, // #8587
  {10,  2,   0}, // #8588
  {11,  2,   0}, // #8589
  {14,  2,   0}, // #8590
  {18,  2,   0}, // #8591
  {22,  2,   0}, // #8592
  { 4,  1,   0}, // #8593
  { 5,  1,   0}, // #8594
  { 7,  1,   0}, // #8595
  { 8,  1,   0}, // #8596
  {14,  1,   0}, // #8597
  {18,  1,   0}, // #8598
  {22,  1,   0}, // #8599
  { 1,  1,   0}, // #8600
  { 2,  6,   0}, // #8601
  { 3,  8,   0}, // #8602
  { 4, 17,   0}, // #8603
  { 5, 20,   0}, // #8604
  { 6,  2,   0}, // #8605
  { 7, 11,   0}, // #8606
  { 8,  9,   0}, // #8607
  { 9,  5,   0}, // #8608
  {10,  7,   0}, // #8609
  {11,  7,   0}, // #8610
  {14,  2,   0}, // #8611
  {15,  2,   0}, // #8612
  {19,  1,   0}, // #8613
  { 1,  1,   0}, // #8614
  { 2,  4,   0}, // #8615
  { 3,  5,   0}, // #8616
  { 4, 10,   0}, // #8617
  { 5, 10,   0}, // #8618
  { 6,  2,   0}, // #8619
  { 7,  7,   0}, // #8620
  { 8,  6,   0}, // #8621
  { 9,  3,   0}, // #8622
  {10,  4,   0}, // #8623
  {11,  4,   0}, // #8624
  {14,  3,   0}, // #8625
  {15,  3,   0}, // #8626
  {19,  1,   0}, // #8627
  { 2,  8,   0}, // #8628
  { 3, 14,   0}, // #8629
  { 4, 30,   0}, // #8630
  { 5, 54,   0}, // #8631
  { 6,  2,   0}, // #8632
  { 7, 18,   0}, // #8633
  { 8, 14,   0}, // #8634
  { 9,  8,   0}, // #8635
  {10, 10,   0}, // #8636
  {11, 11,   0}, // #8637
  {19,  2,   0}, // #8638
  { 2,  3,   0}, // #8639
  { 3,  4,   0}, // #8640
  { 4, 10,   0}, // #8641
  { 5, 15,   0}, // #8642
  { 6,  1,   0}, // #8643
  { 7,  7,   0}, // #8644
  { 8,  6,   0}, // #8645
  { 9,  3,   0}, // #8646
  {10,  4,   0}, // #8647
  {11,  4,   0}, // #8648
  {19,  1,   0}, // #8649
  { 2,  1,   0}, // #8650
  { 3,  1,   0}, // #8651
  { 4,  9,   0}, // #8652
  { 5,  9,   0}, // #8653
  { 7,  8,   0}, // #8654
  { 8,  8,   0}, // #8655
  { 9,  1,   0}, // #8656
  {10,  1,   0}, // #8657
  {11,  1,   0}, // #8658
  {13, 21,   0}, // #8659
  {14, 22,   0}, // #8660
  {15, 22,   0}, // #8661
  {20,  8,   0}, // #8662
  { 2, 35,   0}, // #8663
  { 3, 90,   0}, // #8664
  { 4, 134,   0}, // #8665
  { 5, 134,   0}, // #8666
  { 6, 34,   0}, // #8667
  { 7, 78,   0}, // #8668
  { 8, 44,   0}, // #8669
  { 9, 21,   0}, // #8670
  {10, 51,   0}, // #8671
  {11, 51,   0}, // #8672
  {14,  5,   0}, // #8673
  {15,  4,   0}, // #8674
  {18,  1,   0}, // #8675
  {19,  9,   0}, // #8676
  {22,  1,   0}, // #8677
  { 2, 52,   0}, // #8678
  { 3, 97,   0}, // #8679
  { 4, 150,   0}, // #8680
  { 5, 150,   0}, // #8681
  { 6, 45,   0}, // #8682
  { 7, 98,   0}, // #8683
  { 8, 53,   0}, // #8684
  { 9, 27,   0}, // #8685
  {10, 37,   0}, // #8686
  {11, 37,   0}, // #8687
  {14,  5,   0}, // #8688
  {15,  4,   0}, // #8689
  {18,  1,   0}, // #8690
  {19, 10,   0}, // #8691
  {22,  1,   0}, // #8692
  { 2,  1,   0}, // #8693
  { 3,  4,   0}, // #8694
  { 4,  7,   0}, // #8695
  { 5,  7,   0}, // #8696
  { 6,  2,   0}, // #8697
  { 7,  5,   0}, // #8698
  { 8,  3,   0}, // #8699
  { 9,  1,   0}, // #8700
  {10,  4,   0}, // #8701
  {11,  4,   0}, // #8702
  {13,  1,   0}, // #8703
  {14,  9,   0}, // #8704
  {15,  9,   0}, // #8705
  {17,  1,   0}, // #8706
  {18,  2,   0}, // #8707
  {19,  2,   0}, // #8708
  {20,  3,   0}, // #8709
  { 1,  2,   0}, // #8710
  { 2,  2,   0}, // #8711
  { 3,  7,   0}, // #8712
  { 4, 17,   0}, // #8713
  { 5, 17,   0}, // #8714
  { 6,  7,   0}, // #8715
  { 7, 17,   0}, // #8716
  { 8, 12,   0}, // #8717
  {13, 39,   0}, // #8718
  {14, 47,   0}, // #8719
  {15, 47,   0}, // #8720
  { 1,  4,   0}, // #8721
  { 2,  4,   0}, // #8722
  { 3,  6,   0}, // #8723
  { 4, 12,   0}, // #8724
  { 5, 12,   0}, // #8725
  { 6,  5,   0}, // #8726
  { 7, 11,   0}, // #8727
  { 8, 10,   0}, // #8728
  {10,  1,   0}, // #8729
  {11,  1,   0}, // #8730
  {13, 45,   0}, // #8731
  {14, 76,   0}, // #8732
  {15, 76,   0}, // #8733
  {20,  4,   0}, // #8734
  { 1,  9,   0}, // #8735
  { 2, 10,   0}, // #8736
  { 3, 26,   0}, // #8737
  { 4, 59,   0}, // #8738
  { 5, 59,   0}, // #8739
  { 6, 25,   0}, // #8740
  { 7, 47,   0}, // #8741
  { 8, 31,   0}, // #8742
  { 9,  1,   0}, // #8743
  {10, 17,   0}, // #8744
  {11, 17,   0}, // #8745
  {17, 30,   0}, // #8746
  {18, 41,   0}, // #8747
  {19, 16,   0}, // #8748
  {20,  1,   0}, // #8749
  { 1,  1,   0}, // #8750
  { 2,  1,   0}, // #8751
  { 3,  3,   0}, // #8752
  { 4,  3,   0}, // #8753
  { 5,  3,   0}, // #8754
  { 6,  1,   0}, // #8755
  { 7,  1,   0}, // #8756
  { 8,  1,   0}, // #8757
  {10,  1,   0}, // #8758
  {11,  1,   0}, // #8759
  {14,  2,   0}, // #8760
  {15,  2,   0}, // #8761
  { 1,  1,   0}, // #8762
  { 2,  1,   0}, // #8763
  { 3,  4,   0}, // #8764
  { 4,  4,   0}, // #8765
  { 5,  4,   0}, // #8766
  { 6,  1,   0}, // #8767
  { 7,  1,   0}, // #8768
  { 8,  1,   0}, // #8769
  {10,  2,   0}, // #8770
  {11,  2,   0}, // #8771
  {14,  4,   0}, // #8772
  {15,  4,   0}, // #8773
  { 1,  1,   0}, // #8774
  { 2,  1,   0}, // #8775
  { 3,  4,   0}, // #8776
  { 4,  4,   0}, // #8777
  { 5,  4,   0}, // #8778
  { 6,  1,   0}, // #8779
  { 7,  1,   0}, // #8780
  { 8,  1,   0}, // #8781
  {10,  2,   0}, // #8782
  {11,  2,   0}, // #8783
  {14,  8,   0}, // #8784
  {15,  8,   0}, // #8785
  { 4,  1,   0}, // #8786
  { 5,  1,   0}, // #8787
  { 7,  1,   0}, // #8788
  { 8,  1,   0}, // #8789
  {13,  1,   0}, // #8790
  {14,  2,   0}, // #8791
  {15,  2,   0}, // #8792
  {20,  1,   0}, // #8793
  { 2,  1,   0}, // #8794
  { 3,  1,   0}, // #8795
  { 4,  3,   0}, // #8796
  { 5,  3,   0}, // #8797
  { 7,  2,   0}, // #8798
  { 8,  2,   0}, // #8799
  { 9,  1,   0}, // #8800
  {10,  1,   0}, // #8801
  {11,  1,   0}, // #8802
  {14,  1,   0}, // #8803
  {15,  1,   0}, // #8804
  { 1,  2,   0}, // #8805
  { 2,  2,   0}, // #8806
  { 3,  2,   0}, // #8807
  { 4,  2,   0}, // #8808
  { 5,  2,   0}, // #8809
  { 6,  2,   0}, // #8810
  { 7,  2,   0}, // #8811
  { 8,  2,   0}, // #8812
  {14,  1,   0}, // #8813
  {18,  1,   0}, // #8814
  {22,  1,   0}, // #8815
  { 2,  3,   0}, // #8816
  { 3,  6,   0}, // #8817
  { 4,  7,   0}, // #8818
  { 5,  7,   0}, // #8819
  { 6,  1,   0}, // #8820
  { 7,  2,   0}, // #8821
  { 8,  1,   0}, // #8822
  {10,  1,   0}, // #8823
  {11,  1,   0}, // #8824
  {19,  1,   0}, // #8825
  { 2,  3,   0}, // #8826
  { 3,  6,   0}, // #8827
  { 4,  7,   0}, // #8828
  { 5,  7,   0}, // #8829
  { 6,  1,   0}, // #8830
  { 7,  2,   0}, // #8831
  { 8,  1,   0}, // #8832
  {10,  1,   0}, // #8833
  {11,  1,   0}, // #8834
  {14,  1,   0}, // #8835
  {15,  1,   0}, // #8836
  {19,  1,   0}, // #8837
  { 2,  2,   0}, // #8838
  { 3,  6,   0}, // #8839
  { 4,  7,   0}, // #8840
  { 5,  7,   0}, // #8841
  { 7,  1,   0}, // #8842
  { 8,  1,   0}, // #8843
  {10,  2,   0}, // #8844
  {11,  2,   0}, // #8845
  {14,  1,   0}, // #8846
  {15,  1,   0}, // #8847
  { 2,  1,   0}, // #8848
  { 3,  3,   0}, // #8849
  { 4,  3,   0}, // #8850
  { 5,  3,   0}, // #8851
  {10,  1,   0}, // #8852
  {11,  1,   0}, // #8853
  {14,  1,   0}, // #8854
  {15,  1,   0}, // #8855
  { 4,  1,   0}, // #8856
  { 5,  2,   0}, // #8857
  { 7,  1,   0}, // #8858
  { 8,  1,   0}, // #8859
  {14,  1,   0}, // #8860
  {15,  1,   0}, // #8861
  { 4,  1,   0}, // #8862
  { 5,  5,   0}, // #8863
  { 7,  1,   0}, // #8864
  { 8,  1,   0}, // #8865
  {14,  2,   0}, // #8866
  {15,  1,   0}, // #8867
  {18,  1,   0}, // #8868
  {22,  1,   0}, // #8869
  { 2,  2,   0}, // #8870
  { 3,  4,   0}, // #8871
  { 4,  4,   0}, // #8872
  { 5,  4,   0}, // #8873
  { 6,  2,   0}, // #8874
  { 7,  2,   0}, // #8875
  {10,  2,   0}, // #8876
  {11,  2,   0}, // #8877
  {19,  2,   0}, // #8878
  { 1,  2,   0}, // #8879
  { 2,  2,   0}, // #8880
  { 3,  4,   0}, // #8881
  { 4,  4,   0}, // #8882
  { 5,  4,   0}, // #8883
  { 6,  4,   0}, // #8884
  { 7,  4,   0}, // #8885
  { 8,  2,   0}, // #8886
  {10,  2,   0}, // #8887
  {11,  2,   0}, // #8888
  {19,  2,   0}, // #8889
  { 2,  5,   0}, // #8890
  { 3, 15,   0}, // #8891
  { 4, 15,   0}, // #8892
  { 5, 15,   0}, // #8893
  { 6,  5,   0}, // #8894
  { 7,  5,   0}, // #8895
  {10,  5,   0}, // #8896
  {11,  5,   0}, // #8897
  {19,  5,   0}, // #8898
  { 2,  7,   0}, // #8899
  { 3, 22,   0}, // #8900
  { 4, 23,   0}, // #8901
  { 5, 23,   0}, // #8902
  { 6,  9,   0}, // #8903
  { 7, 10,   0}, // #8904
  { 8,  1,   0}, // #8905
  {10,  9,   0}, // #8906
  {11,  9,   0}, // #8907
  {19,  9,   0}, // #8908
  { 1, 11,   0}, // #8909
  { 2, 11,   0}, // #8910
  { 3, 37,   0}, // #8911
  { 4, 37,   0}, // #8912
  { 5, 37,   0}, // #8913
  { 6, 37,   0}, // #8914
  { 7, 37,   0}, // #8915
  { 8, 11,   0}, // #8916
  {10, 17,   0}, // #8917
  {11, 17,   0}, // #8918
  {19, 17,   0}, // #8919
  { 1,  1,   0}, // #8920
  { 2,  4,   0}, // #8921
  { 3,  5,   0}, // #8922
  { 4,  9,   0}, // #8923
  { 5, 13,   0}, // #8924
  { 6,  2,   0}, // #8925
  { 7,  6,   0}, // #8926
  { 8,  5,   0}, // #8927
  { 9,  3,   0}, // #8928
  {10,  4,   0}, // #8929
  {11,  4,   0}, // #8930
  {14,  2,   0}, // #8931
  {15,  2,   0}, // #8932
  {19,  1,   0}, // #8933
  { 1,  1,   0}, // #8934
  { 2,  1,   0}, // #8935
  { 3,  3,   0}, // #8936
  { 4,  3,   0}, // #8937
  { 5,  3,   0}, // #8938
  { 6,  3,   0}, // #8939
  { 7,  3,   0}, // #8940
  { 8,  1,   0}, // #8941
  {10,  2,   0}, // #8942
  {11,  2,   0}, // #8943
  {19,  2,   0}, // #8944
  { 1,  1,   0}, // #8945
  { 2,  1,   0}, // #8946
  { 3,  3,   0}, // #8947
  { 4,  3,   0}, // #8948
  { 5,  3,   0}, // #8949
  { 6,  3,   0}, // #8950
  { 7,  3,   0}, // #8951
  { 8,  1,   0}, // #8952
  {10,  2,   0}, // #8953
  {11,  2,   0}, // #8954
  {14,  1,   0}, // #8955
  {15,  1,   0}, // #8956
  {19,  2,   0}, // #8957
  { 2,  1,   0}, // #8958
  { 3,  3,   0}, // #8959
  { 4,  3,   0}, // #8960
  { 5,  3,   0}, // #8961
  {10,  2,   0}, // #8962
  {11,  2,   0}, // #8963
  {14,  1,   0}, // #8964
  {15,  1,   0}, // #8965
  { 2, 52,   0}, // #8966
  { 3, 125,   0}, // #8967
  { 4, 178,   0}, // #8968
  { 5, 178,   0}, // #8969
  { 6, 41,   0}, // #8970
  { 7, 94,   0}, // #8971
  { 8, 53,   0}, // #8972
  { 9, 29,   0}, // #8973
  {10, 69,   0}, // #8974
  {11, 69,   0}, // #8975
  {14,  6,   0}, // #8976
  {15,  4,   0}, // #8977
  {18,  2,   0}, // #8978
  {19,  8,   0}, // #8979
  {22,  2,   0}, // #8980
  { 3,  2,   0}, // #8981
  { 4,  2,   0}, // #8982
  { 5,  2,   0}, // #8983
  { 6,  1,   0}, // #8984
  { 7,  1,   0}, // #8985
  {10,  2,   0}, // #8986
  {11,  2,   0}, // #8987
  {14,  1,   0}, // #8988
  {18,  1,   0}, // #8989
  {19,  1,   0}, // #8990
  {22,  1,   0}, // #8991
  { 3,  2,   0}, // #8992
  { 4,  2,   0}, // #8993
  { 5,  2,   0}, // #8994
  { 6,  2,   0}, // #8995
  { 7,  2,   0}, // #8996
  {10,  2,   0}, // #8997
  {11,  2,   0}, // #8998
  {14,  1,   0}, // #8999
  {18,  1,   0}, // #9000
  {19,  2,   0}, // #9001
  {22,  1,   0}, // #9002
  { 1,  1,   0}, // #9003
  { 2,  2,   0}, // #9004
  { 3,  2,   0}, // #9005
  { 4,  2,   0}, // #9006
  { 5,  3,   0}, // #9007
  { 6,  1,   0}, // #9008
  { 7,  1,   0}, // #9009
  { 8,  1,   0}, // #9010
  {14,  2,   0}, // #9011
  {18,  2,   0}, // #9012
  {22,  2,   0}, // #9013
  { 1,  1,   0}, // #9014
  { 2,  2,   0}, // #9015
  { 3,  2,   0}, // #9016
  { 4,  2,   0}, // #9017
  { 5,  3,   0}, // #9018
  { 6,  1,   0}, // #9019
  { 7,  1,   0}, // #9020
  { 8,  1,   0}, // #9021
  {14,  4,   0}, // #9022
  {18,  4,   0}, // #9023
  {22,  4,   0}, // #9024
  { 1,  2,   0}, // #9025
  { 2,  2,   0}, // #9026
  { 3,  2,   0}, // #9027
  { 4,  2,   0}, // #9028
  { 5,  3,   0}, // #9029
  { 6,  2,   0}, // #9030
  { 7,  2,   0}, // #9031
  { 8,  2,   0}, // #9032
  {14,  8,   0}, // #9033
  {18,  8,   0}, // #9034
  {22,  8,   0}, // #9035
  { 1,  2,   0}, // #9036
  { 2,  2,   0}, // #9037
  { 3,  2,   0}, // #9038
  { 4,  2,   0}, // #9039
  { 5,  3,   0}, // #9040
  { 6,  2,   0}, // #9041
  { 7,  2,   0}, // #9042
  { 8,  2,   0}, // #9043
  {14, 16,   0}, // #9044
  {18, 16,   0}, // #9045
  {22, 16,   0}, // #9046
  { 1,  1,   0}, // #9047
  { 2,  2,   0}, // #9048
  { 3,  2,   0}, // #9049
  { 4,  2,   0}, // #9050
  { 5,  3,   0}, // #9051
  { 6,  1,   0}, // #9052
  { 7,  1,   0}, // #9053
  { 8,  1,   0}, // #9054
  {14,  8,   0}, // #9055
  {18,  8,   0}, // #9056
  {22,  8,   0}, // #9057
  { 3,  3,   0}, // #9058
  { 4,  3,   0}, // #9059
  { 5,  3,   0}, // #9060
  { 6,  2,   0}, // #9061
  { 7,  2,   0}, // #9062
  {10,  2,   0}, // #9063
  {11,  2,   0}, // #9064
  {14,  1,   0}, // #9065
  {15,  1,   0}, // #9066
  {19,  2,   0}, // #9067
  { 2,  5,   0}, // #9068
  { 3, 14,   0}, // #9069
  { 4, 14,   0}, // #9070
  { 5, 14,   0}, // #9071
  { 6,  5,   0}, // #9072
  { 7,  5,   0}, // #9073
  {10,  5,   0}, // #9074
  {11,  5,   0}, // #9075
  {14,  1,   0}, // #9076
  {15,  1,   0}, // #9077
  {19,  5,   0}, // #9078
  { 2,  3,   0}, // #9079
  { 3,  3,   0}, // #9080
  { 4,  3,   0}, // #9081
  { 5,  3,   0}, // #9082
  {14,  1,   0}, // #9083
  {15,  1,   0}, // #9084
  { 1,  1,   0}, // #9085
  { 2,  1,   0}, // #9086
  { 3,  2,   0}, // #9087
  { 4,  2,   0}, // #9088
  { 5,  2,   0}, // #9089
  { 6,  1,   0}, // #9090
  { 7,  1,   0}, // #9091
  { 8,  1,   0}, // #9092
  {10,  1,   0}, // #9093
  {11,  1,   0}, // #9094
  {14,  2,   0}, // #9095
  {15,  2,   0}, // #9096
  { 1,  1,   0}, // #9097
  { 2,  1,   0}, // #9098
  { 3,  3,   0}, // #9099
  { 4,  3,   0}, // #9100
  { 5,  3,   0}, // #9101
  { 6,  1,   0}, // #9102
  { 7,  1,   0}, // #9103
  { 8,  1,   0}, // #9104
  {10,  2,   0}, // #9105
  {11,  2,   0}, // #9106
  {14,  4,   0}, // #9107
  {15,  4,   0}, // #9108
  { 1,  1,   0}, // #9109
  { 2,  1,   0}, // #9110
  { 3,  3,   0}, // #9111
  { 4,  3,   0}, // #9112
  { 5,  3,   0}, // #9113
  { 6,  1,   0}, // #9114
  { 7,  1,   0}, // #9115
  { 8,  1,   0}, // #9116
  {10,  2,   0}, // #9117
  {11,  2,   0}, // #9118
  {14,  8,   0}, // #9119
  {15,  8,   0}, // #9120
  { 1,  1,   0}, // #9121
  { 2,  1,   0}, // #9122
  { 3,  3,   0}, // #9123
  { 4,  3,   0}, // #9124
  { 5,  3,   0}, // #9125
  { 6,  3,   0}, // #9126
  { 7,  3,   0}, // #9127
  { 8,  1,   0}, // #9128
  {10,  2,   0}, // #9129
  {11,  2,   0}, // #9130
  {14, 16,   0}, // #9131
  {15, 16,   0}, // #9132
  {19,  2,   0}, // #9133
  { 1,  7,   0}, // #9134
  { 2,  7,   0}, // #9135
  { 3, 22,   0}, // #9136
  { 4, 22,   0}, // #9137
  { 5, 22,   0}, // #9138
  { 6, 22,   0}, // #9139
  { 7, 22,   0}, // #9140
  { 8,  7,   0}, // #9141
  {10,  9,   0}, // #9142
  {11,  9,   0}, // #9143
  {19,  9,   0}, // #9144
  { 2,  7,   0}, // #9145
  { 3, 21,   0}, // #9146
  { 4, 22,   0}, // #9147
  { 5, 22,   0}, // #9148
  { 6,  9,   0}, // #9149
  { 7, 10,   0}, // #9150
  { 8,  1,   0}, // #9151
  {10,  9,   0}, // #9152
  {11,  9,   0}, // #9153
  {14,  1,   0}, // #9154
  {15,  1,   0}, // #9155
  {19,  9,   0}, // #9156
  { 1,  7,   0}, // #9157
  { 2,  7,   0}, // #9158
  { 3, 21,   0}, // #9159
  { 4, 21,   0}, // #9160
  { 5, 21,   0}, // #9161
  { 6, 21,   0}, // #9162
  { 7, 21,   0}, // #9163
  { 8,  7,   0}, // #9164
  {10,  9,   0}, // #9165
  {11,  9,   0}, // #9166
  {14,  1,   0}, // #9167
  {15,  1,   0}, // #9168
  {19,  9,   0}, // #9169
  { 1, 11,   0}, // #9170
  { 2, 11,   0}, // #9171
  { 3, 36,   0}, // #9172
  { 4, 36,   0}, // #9173
  { 5, 36,   0}, // #9174
  { 6, 36,   0}, // #9175
  { 7, 36,   0}, // #9176
  { 8, 11,   0}, // #9177
  {10, 17,   0}, // #9178
  {11, 17,   0}, // #9179
  {14,  1,   0}, // #9180
  {15,  1,   0}, // #9181
  {19, 17,   0}, // #9182
  { 2,  1,   0}, // #9183
  { 3,  1,   0}, // #9184
  { 4,  3,   0}, // #9185
  { 5,  8,   0}, // #9186
  { 7,  2,   0}, // #9187
  { 8,  2,   0}, // #9188
  { 9,  1,   0}, // #9189
  {10,  1,   0}, // #9190
  {11,  1,   0}, // #9191
  {14,  1,   0}, // #9192
  {15,  1,   0}, // #9193
  { 2,  1,   0}, // #9194
  { 3,  1,   0}, // #9195
  { 4,  3,   0}, // #9196
  { 5,  7,   0}, // #9197
  { 7,  2,   0}, // #9198
  { 8,  2,   0}, // #9199
  { 9,  1,   0}, // #9200
  {10,  1,   0}, // #9201
  {11,  1,   0}, // #9202
  {14,  2,   0}, // #9203
  {15,  1,   0}, // #9204
  {18,  1,   0}, // #9205
  {22,  1,   0}, // #9206
  { 4,  1,   0}, // #9207
  { 5,  2,   0}, // #9208
  { 7,  1,   0}, // #9209
  { 8,  1,   0}, // #9210
  {14,  1,   0}, // #9211
  {18,  1,   0}, // #9212
  {22,  1,   0}, // #9213
  { 2,  1,   0}, // #9214
  { 3,  4,   0}, // #9215
  { 4, 10,   0}, // #9216
  { 5, 10,   0}, // #9217
  { 6,  3,   0}, // #9218
  { 7,  9,   0}, // #9219
  { 8,  6,   0}, // #9220
  { 9,  1,   0}, // #9221
  {10,  4,   0}, // #9222
  {11,  4,   0}, // #9223
  {19,  3,   0}, // #9224
  { 1,  7,   0}, // #9225
  { 2, 26,   0}, // #9226
  { 3, 47,   0}, // #9227
  { 4, 73,   0}, // #9228
  { 5, 80,   0}, // #9229
  { 6, 28,   0}, // #9230
  { 7, 54,   0}, // #9231
  { 8, 33,   0}, // #9232
  { 9, 19,   0}, // #9233
  {10, 40,   0}, // #9234
  {11, 42,   0}, // #9235
  {14,  7,   0}, // #9236
  {15,  7,   0}, // #9237
  {19, 21,   0}, // #9238
  { 1,  7,   0}, // #9239
  { 2, 27,   0}, // #9240
  { 3, 47,   0}, // #9241
  { 4, 73,   0}, // #9242
  { 5, 80,   0}, // #9243
  { 6, 27,   0}, // #9244
  { 7, 53,   0}, // #9245
  { 8, 33,   0}, // #9246
  { 9, 19,   0}, // #9247
  {10, 39,   0}, // #9248
  {11, 42,   0}, // #9249
  {14,  7,   0}, // #9250
  {15,  7,   0}, // #9251
  {19, 20,   0}, // #9252
  { 1,  7,   0}, // #9253
  { 2, 28,   0}, // #9254
  { 3, 48,   0}, // #9255
  { 4, 76,   0}, // #9256
  { 5, 84,   0}, // #9257
  { 6, 27,   0}, // #9258
  { 7, 55,   0}, // #9259
  { 8, 35,   0}, // #9260
  { 9, 21,   0}, // #9261
  {10, 41,   0}, // #9262
  {11, 43,   0}, // #9263
  {14, 10,   0}, // #9264
  {15, 10,   0}, // #9265
  {19, 20,   0}, // #9266
  { 1,  7,   0}, // #9267
  { 2, 28,   0}, // #9268
  { 3, 49,   0}, // #9269
  { 4, 77,   0}, // #9270
  { 5, 88,   0}, // #9271
  { 6, 28,   0}, // #9272
  { 7, 56,   0}, // #9273
  { 8, 35,   0}, // #9274
  { 9, 21,   0}, // #9275
  {10, 42,   0}, // #9276
  {11, 44,   0}, // #9277
  {14, 11,   0}, // #9278
  {15, 11,   0}, // #9279
  {19, 21,   0}, // #9280
  { 1,  7,   0}, // #9281
  { 2, 24,   0}, // #9282
  { 3, 43,   0}, // #9283
  { 4, 67,   0}, // #9284
  { 5, 73,   0}, // #9285
  { 6, 26,   0}, // #9286
  { 7, 50,   0}, // #9287
  { 8, 31,   0}, // #9288
  { 9, 17,   0}, // #9289
  {10, 36,   0}, // #9290
  {11, 36,   0}, // #9291
  {14,  9,   0}, // #9292
  {15,  8,   0}, // #9293
  {18,  1,   0}, // #9294
  {19, 19,   0}, // #9295
  {22,  1,   0}, // #9296
  { 1,  7,   0}, // #9297
  { 2, 24,   0}, // #9298
  { 3, 46,   0}, // #9299
  { 4, 74,   0}, // #9300
  { 5, 79,   0}, // #9301
  { 6, 28,   0}, // #9302
  { 7, 56,   0}, // #9303
  { 8, 34,   0}, // #9304
  { 9, 17,   0}, // #9305
  {10, 38,   0}, // #9306
  {11, 38,   0}, // #9307
  {14, 12,   0}, // #9308
  {15, 11,   0}, // #9309
  {18,  1,   0}, // #9310
  {19, 21,   0}, // #9311
  {22,  1,   0}, // #9312
  { 1,  5,   0}, // #9313
  { 2, 11,   0}, // #9314
  { 3, 18,   0}, // #9315
  { 4, 26,   0}, // #9316
  { 5, 32,   0}, // #9317
  { 6, 12,   0}, // #9318
  { 7, 20,   0}, // #9319
  { 8, 13,   0}, // #9320
  { 9,  6,   0}, // #9321
  {10, 13,   0}, // #9322
  {11, 15,   0}, // #9323
  {14,  5,   0}, // #9324
  {18,  5,   0}, // #9325
  {19,  7,   0}, // #9326
  {22,  5,   0}, // #9327
  { 4,  1,   0}, // #9328
  { 5,  1,   0}, // #9329
  { 7,  1,   0}, // #9330
  { 8,  1,   0}, // #9331
  {20,  1,   0}, // #9332
  { 1,  8,   0}, // #9333
  { 2, 22,   0}, // #9334
  { 3, 23,   0}, // #9335
  { 4, 25,   0}, // #9336
  { 5, 25,   0}, // #9337
  { 6,  9,   0}, // #9338
  { 7, 11,   0}, // #9339
  { 8, 10,   0}, // #9340
  { 9, 14,   0}, // #9341
  {10, 15,   0}, // #9342
  {11, 15,   0}, // #9343
  {14,  3,   0}, // #9344
  {15,  3,   0}, // #9345
  {19,  1,   0}, // #9346
  { 1,  1,   0}, // #9347
  { 2,  6,   0}, // #9348
  { 3,  9,   0}, // #9349
  { 4, 18,   0}, // #9350
  { 5, 20,   0}, // #9351
  { 6,  4,   0}, // #9352
  { 7, 13,   0}, // #9353
  { 8, 10,   0}, // #9354
  { 9,  5,   0}, // #9355
  {10,  6,   0}, // #9356
  {11,  6,   0}, // #9357
  {14,  3,   0}, // #9358
  {15,  3,   0}, // #9359
  {19,  1,   0}, // #9360
  { 1,  1,   0}, // #9361
  { 2,  4,   0}, // #9362
  { 3,  4,   0}, // #9363
  { 4,  8,   0}, // #9364
  { 5, 10,   0}, // #9365
  { 6,  1,   0}, // #9366
  { 7,  5,   0}, // #9367
  { 8,  5,   0}, // #9368
  { 9,  3,   0}, // #9369
  {10,  3,   0}, // #9370
  {11,  3,   0}, // #9371
  {14,  3,   0}, // #9372
  {15,  2,   0}, // #9373
  {18,  1,   0}, // #9374
  {22,  1,   0}, // #9375
  { 2,  3,   0}, // #9376
  { 3,  4,   0}, // #9377
  { 4,  9,   0}, // #9378
  { 5, 10,   0}, // #9379
  { 6,  1,   0}, // #9380
  { 7,  6,   0}, // #9381
  { 8,  5,   0}, // #9382
  { 9,  3,   0}, // #9383
  {10,  3,   0}, // #9384
  {11,  3,   0}, // #9385
  {14,  3,   0}, // #9386
  {15,  2,   0}, // #9387
  {18,  1,   0}, // #9388
  {22,  1,   0}, // #9389
  { 2,  3,   0}, // #9390
  { 3,  3,   0}, // #9391
  { 4,  8,   0}, // #9392
  { 5,  8,   0}, // #9393
  { 7,  5,   0}, // #9394
  { 8,  5,   0}, // #9395
  { 9,  3,   0}, // #9396
  {10,  3,   0}, // #9397
  {11,  3,   0}, // #9398
  {14,  3,   0}, // #9399
  {15,  2,   0}, // #9400
  {18,  1,   0}, // #9401
  {22,  1,   0}, // #9402
  { 2,  3,   0}, // #9403
  { 3,  3,   0}, // #9404
  { 4,  7,   0}, // #9405
  { 5,  8,   0}, // #9406
  { 7,  4,   0}, // #9407
  { 8,  4,   0}, // #9408
  { 9,  3,   0}, // #9409
  {10,  3,   0}, // #9410
  {11,  3,   0}, // #9411
  {14,  2,   0}, // #9412
  {15,  1,   0}, // #9413
  {18,  1,   0}, // #9414
  {22,  1,   0}, // #9415
  { 1,  1,   0}, // #9416
  { 2,  4,   0}, // #9417
  { 3, 12,   0}, // #9418
  { 4, 20,   0}, // #9419
  { 5, 22,   0}, // #9420
  { 6,  8,   0}, // #9421
  { 7, 16,   0}, // #9422
  { 8,  9,   0}, // #9423
  { 9,  3,   0}, // #9424
  {10, 10,   0}, // #9425
  {11, 10,   0}, // #9426
  {14,  3,   0}, // #9427
  {15,  1,   0}, // #9428
  {18,  2,   0}, // #9429
  {19,  7,   0}, // #9430
  {22,  2,   0}, // #9431
  { 2,  1,   0}, // #9432
  { 3,  6,   0}, // #9433
  { 4, 13,   0}, // #9434
  { 5, 18,   0}, // #9435
  { 6,  5,   0}, // #9436
  { 7, 12,   0}, // #9437
  { 8,  7,   0}, // #9438
  { 9,  1,   0}, // #9439
  {10,  6,   0}, // #9440
  {11,  6,   0}, // #9441
  {14,  2,   0}, // #9442
  {18,  2,   0}, // #9443
  {19,  5,   0}, // #9444
  {22,  2,   0}, // #9445
  { 2,  8,   0}, // #9446
  { 3, 22,   0}, // #9447
  { 4, 38,   0}, // #9448
  { 5, 44,   0}, // #9449
  { 6, 12,   0}, // #9450
  { 7, 28,   0}, // #9451
  { 8, 16,   0}, // #9452
  { 9,  7,   0}, // #9453
  {10, 19,   0}, // #9454
  {11, 21,   0}, // #9455
  {14,  2,   0}, // #9456
  {18,  2,   0}, // #9457
  {19, 12,   0}, // #9458
  {22,  2,   0}, // #9459
  { 3,  1,   0}, // #9460
  { 4,  2,   0}, // #9461
  { 5,  3,   0}, // #9462
  { 6,  1,   0}, // #9463
  { 7,  2,   0}, // #9464
  { 8,  1,   0}, // #9465
  {10,  1,   0}, // #9466
  {11,  1,   0}, // #9467
  {19,  1,   0}, // #9468
  { 2,  4,   0}, // #9469
  { 3, 10,   0}, // #9470
  { 4, 18,   0}, // #9471
  { 5, 24,   0}, // #9472
  { 6,  3,   0}, // #9473
  { 7, 11,   0}, // #9474
  { 8,  8,   0}, // #9475
  { 9,  4,   0}, // #9476
  {10,  7,   0}, // #9477
  {11,  9,   0}, // #9478
  {19,  3,   0}, // #9479
  { 1,  6,   0}, // #9480
  { 2, 21,   0}, // #9481
  { 3, 38,   0}, // #9482
  { 4, 66,   0}, // #9483
  { 5, 70,   0}, // #9484
  { 6, 23,   0}, // #9485
  { 7, 51,   0}, // #9486
  { 8, 34,   0}, // #9487
  { 9, 15,   0}, // #9488
  {10, 31,   0}, // #9489
  {11, 31,   0}, // #9490
  {14,  8,   0}, // #9491
  {15,  7,   0}, // #9492
  {18,  1,   0}, // #9493
  {19, 16,   0}, // #9494
  {22,  1,   0}, // #9495
  { 1,  6,   0}, // #9496
  { 2, 21,   0}, // #9497
  { 3, 37,   0}, // #9498
  { 4, 64,   0}, // #9499
  { 5, 70,   0}, // #9500
  { 6, 22,   0}, // #9501
  { 7, 49,   0}, // #9502
  { 8, 33,   0}, // #9503
  { 9, 15,   0}, // #9504
  {10, 31,   0}, // #9505
  {11, 31,   0}, // #9506
  {14,  8,   0}, // #9507
  {15,  7,   0}, // #9508
  {18,  1,   0}, // #9509
  {19, 16,   0}, // #9510
  {22,  1,   0}, // #9511
  { 1,  6,   0}, // #9512
  { 2, 21,   0}, // #9513
  { 3, 40,   0}, // #9514
  { 4, 70,   0}, // #9515
  { 5, 74,   0}, // #9516
  { 6, 25,   0}, // #9517
  { 7, 55,   0}, // #9518
  { 8, 36,   0}, // #9519
  { 9, 15,   0}, // #9520
  {10, 33,   0}, // #9521
  {11, 33,   0}, // #9522
  {14, 10,   0}, // #9523
  {15,  9,   0}, // #9524
  {18,  1,   0}, // #9525
  {19, 18,   0}, // #9526
  {22,  1,   0}, // #9527
  { 1,  6,   0}, // #9528
  { 2, 21,   0}, // #9529
  { 3, 39,   0}, // #9530
  { 4, 68,   0}, // #9531
  { 5, 74,   0}, // #9532
  { 6, 24,   0}, // #9533
  { 7, 53,   0}, // #9534
  { 8, 35,   0}, // #9535
  { 9, 15,   0}, // #9536
  {10, 33,   0}, // #9537
  {11, 33,   0}, // #9538
  {14, 10,   0}, // #9539
  {15,  9,   0}, // #9540
  {18,  1,   0}, // #9541
  {19, 18,   0}, // #9542
  {22,  1,   0}, // #9543
  { 1,  7,   0}, // #9544
  { 2, 23,   0}, // #9545
  { 3, 40,   0}, // #9546
  { 4, 65,   0}, // #9547
  { 5, 71,   0}, // #9548
  { 6, 24,   0}, // #9549
  { 7, 49,   0}, // #9550
  { 8, 32,   0}, // #9551
  { 9, 16,   0}, // #9552
  {10, 33,   0}, // #9553
  {11, 33,   0}, // #9554
  {14,  8,   0}, // #9555
  {15,  7,   0}, // #9556
  {18,  1,   0}, // #9557
  {19, 17,   0}, // #9558
  {22,  1,   0}, // #9559
  { 1,  7,   0}, // #9560
  { 2, 23,   0}, // #9561
  { 3, 43,   0}, // #9562
  { 4, 71,   0}, // #9563
  { 5, 77,   0}, // #9564
  { 6, 27,   0}, // #9565
  { 7, 55,   0}, // #9566
  { 8, 35,   0}, // #9567
  { 9, 16,   0}, // #9568
  {10, 36,   0}, // #9569
  {11, 36,   0}, // #9570
  {14, 11,   0}, // #9571
  {15, 10,   0}, // #9572
  {18,  1,   0}, // #9573
  {19, 20,   0}, // #9574
  {22,  1,   0}, // #9575
  { 4,  2,   0}, // #9576
  { 5,  3,   0}, // #9577
  { 7,  2,   0}, // #9578
  { 8,  2,   0}, // #9579
  {14,  1,   0}, // #9580
  {15,  1,   0}, // #9581
  {20,  2,   0}, // #9582
  { 4,  2,   0}, // #9583
  { 5,  3,   0}, // #9584
  { 7,  2,   0}, // #9585
  { 8,  2,   0}, // #9586
  {20,  2,   0}, // #9587
  { 4,  2,   0}, // #9588
  { 5,  4,   0}, // #9589
  { 7,  2,   0}, // #9590
  { 8,  2,   0}, // #9591
  {20,  2,   0}, // #9592
  { 2,  2,   0}, // #9593
  { 3,  2,   0}, // #9594
  { 4,  7,   0}, // #9595
  { 5,  8,   0}, // #9596
  { 7,  5,   0}, // #9597
  { 8,  5,   0}, // #9598
  { 9,  2,   0}, // #9599
  {10,  2,   0}, // #9600
  {11,  2,   0}, // #9601
  {14,  2,   0}, // #9602
  {15,  1,   0}, // #9603
  {18,  1,   0}, // #9604
  {22,  1,   0}, // #9605
  { 2,  3,   0}, // #9606
  { 3,  3,   0}, // #9607
  { 4,  7,   0}, // #9608
  { 5,  9,   0}, // #9609
  { 7,  4,   0}, // #9610
  { 8,  4,   0}, // #9611
  { 9,  3,   0}, // #9612
  {10,  3,   0}, // #9613
  {11,  3,   0}, // #9614
  {14,  2,   0}, // #9615
  {15,  1,   0}, // #9616
  {18,  1,   0}, // #9617
  {22,  1,   0}, // #9618
  { 1,  2,   0}, // #9619
  { 2,  9,   0}, // #9620
  { 3, 16,   0}, // #9621
  { 4, 24,   0}, // #9622
  { 5, 24,   0}, // #9623
  { 6,  6,   0}, // #9624
  { 7, 14,   0}, // #9625
  { 8,  7,   0}, // #9626
  { 9,  7,   0}, // #9627
  {10, 11,   0}, // #9628
  {11, 11,   0}, // #9629
  {14,  1,   0}, // #9630
  {15,  1,   0}, // #9631
  {19,  4,   0}, // #9632
  { 2,  1,   0}, // #9633
  { 3,  1,   0}, // #9634
  { 4,  3,   0}, // #9635
  { 5,  5,   0}, // #9636
  { 7,  2,   0}, // #9637
  { 8,  2,   0}, // #9638
  { 9,  1,   0}, // #9639
  {10,  1,   0}, // #9640
  {11,  1,   0}, // #9641
  {14,  1,   0}, // #9642
  {18,  1,   0}, // #9643
  {22,  1,   0}, // #9644
  { 3,  1,   0}, // #9645
  { 4,  1,   0}, // #9646
  { 5,  2,   0}, // #9647
  { 6,  1,   0}, // #9648
  { 7,  1,   0}, // #9649
  {10,  1,   0}, // #9650
  {11,  1,   0}, // #9651
  {19,  1,   0}, // #9652
  { 1,  6,   0}, // #9653
  { 2, 13,   0}, // #9654
  { 3, 13,   0}, // #9655
  { 4, 13,   0}, // #9656
  { 5, 13,   0}, // #9657
  { 6,  6,   0}, // #9658
  { 7,  6,   0}, // #9659
  { 8,  6,   0}, // #9660
  { 9,  7,   0}, // #9661
  {10,  7,   0}, // #9662
  {11,  7,   0}, // #9663
  {14, 18,   0}, // #9664
  {15, 18,   0}, // #9665
  { 1,  6,   0}, // #9666
  { 2, 13,   0}, // #9667
  { 3, 13,   0}, // #9668
  { 4, 13,   0}, // #9669
  { 5, 13,   0}, // #9670
  { 6,  6,   0}, // #9671
  { 7,  6,   0}, // #9672
  { 8,  6,   0}, // #9673
  { 9,  7,   0}, // #9674
  {10,  7,   0}, // #9675
  {11,  7,   0}, // #9676
  {14, 17,   0}, // #9677
  {15, 17,   0}, // #9678
  { 1,  5,   0}, // #9679
  { 2, 13,   0}, // #9680
  { 3, 13,   0}, // #9681
  { 4, 13,   0}, // #9682
  { 5, 13,   0}, // #9683
  { 6,  5,   0}, // #9684
  { 7,  5,   0}, // #9685
  { 8,  5,   0}, // #9686
  { 9,  8,   0}, // #9687
  {10,  8,   0}, // #9688
  {11,  8,   0}, // #9689
  {14, 20,   0}, // #9690
  {15, 20,   0}, // #9691
  { 1,  1,   0}, // #9692
  { 2,  1,   0}, // #9693
  { 3,  1,   0}, // #9694
  { 4,  2,   0}, // #9695
  { 5,  2,   0}, // #9696
  { 6,  1,   0}, // #9697
  { 7,  2,   0}, // #9698
  { 8,  2,   0}, // #9699
  {14,  1,   0}, // #9700
  {15,  1,   0}, // #9701
  { 2,  4,   0}, // #9702
  { 3,  5,   0}, // #9703
  { 4,  6,   0}, // #9704
  { 5,  8,   0}, // #9705
  { 6,  1,   0}, // #9706
  { 7,  2,   0}, // #9707
  { 8,  1,   0}, // #9708
  { 9,  4,   0}, // #9709
  {10,  5,   0}, // #9710
  {11,  5,   0}, // #9711
  {19,  1,   0}, // #9712
  { 1,  1,   0}, // #9713
  { 2, 43,   0}, // #9714
  { 3, 91,   0}, // #9715
  { 4, 143,   0}, // #9716
  { 5, 143,   0}, // #9717
  { 6, 49,   0}, // #9718
  { 7, 101,   0}, // #9719
  { 8, 53,   0}, // #9720
  { 9, 23,   0}, // #9721
  {10, 35,   0}, // #9722
  {11, 35,   0}, // #9723
  {14,  6,   0}, // #9724
  {15,  4,   0}, // #9725
  {18,  2,   0}, // #9726
  {19, 12,   0}, // #9727
  {22,  2,   0}, // #9728
  { 1,  1,   0}, // #9729
  { 2, 43,   0}, // #9730
  { 3, 91,   0}, // #9731
  { 4, 144,   0}, // #9732
  { 5, 144,   0}, // #9733
  { 6, 49,   0}, // #9734
  { 7, 102,   0}, // #9735
  { 8, 54,   0}, // #9736
  { 9, 23,   0}, // #9737
  {10, 35,   0}, // #9738
  {11, 35,   0}, // #9739
  {14,  6,   0}, // #9740
  {15,  4,   0}, // #9741
  {18,  2,   0}, // #9742
  {19, 12,   0}, // #9743
  {22,  2,   0}, // #9744
  { 2, 52,   0}, // #9745
  { 3, 97,   0}, // #9746
  { 4, 149,   0}, // #9747
  { 5, 149,   0}, // #9748
  { 6, 45,   0}, // #9749
  { 7, 97,   0}, // #9750
  { 8, 52,   0}, // #9751
  { 9, 27,   0}, // #9752
  {10, 37,   0}, // #9753
  {11, 37,   0}, // #9754
  {14,  5,   0}, // #9755
  {15,  4,   0}, // #9756
  {18,  1,   0}, // #9757
  {19, 10,   0}, // #9758
  {22,  1,   0}, // #9759
  { 2, 52,   0}, // #9760
  { 3, 123,   0}, // #9761
  { 4, 176,   0}, // #9762
  { 5, 176,   0}, // #9763
  { 6, 41,   0}, // #9764
  { 7, 94,   0}, // #9765
  { 8, 53,   0}, // #9766
  { 9, 29,   0}, // #9767
  {10, 68,   0}, // #9768
  {11, 68,   0}, // #9769
  {14,  6,   0}, // #9770
  {15,  4,   0}, // #9771
  {18,  2,   0}, // #9772
  {19,  9,   0}, // #9773
  {22,  2,   0}, // #9774
  { 2,  1,   0}, // #9775
  { 3,  3,   0}, // #9776
  { 4,  3,   0}, // #9777
  { 5,  3,   0}, // #9778
  { 6,  1,   0}, // #9779
  { 7,  1,   0}, // #9780
  {10,  2,   0}, // #9781
  {11,  2,   0}, // #9782
  {14,  1,   0}, // #9783
  {15,  1,   0}, // #9784
  {19,  1,   0}, // #9785
  { 2,  1,   0}, // #9786
  { 3,  3,   0}, // #9787
  { 4,  3,   0}, // #9788
  { 5,  3,   0}, // #9789
  { 6,  1,   0}, // #9790
  { 7,  1,   0}, // #9791
  {10,  2,   0}, // #9792
  {11,  2,   0}, // #9793
  {19,  1,   0}, // #9794
  { 2,  2,   0}, // #9795
  { 3,  4,   0}, // #9796
  { 4,  4,   0}, // #9797
  { 5,  4,   0}, // #9798
  { 6,  1,   0}, // #9799
  { 7,  1,   0}, // #9800
  {10,  2,   0}, // #9801
  {11,  2,   0}, // #9802
  {14,  1,   0}, // #9803
  {15,  1,   0}, // #9804
  {19,  1,   0}, // #9805
  { 2,  2,   0}, // #9806
  { 3,  4,   0}, // #9807
  { 4,  4,   0}, // #9808
  { 5,  4,   0}, // #9809
  { 6,  1,   0}, // #9810
  { 7,  1,   0}, // #9811
  {10,  2,   0}, // #9812
  {11,  2,   0}, // #9813
  {19,  1,   0}, // #9814
  { 1,  2,   0}, // #9815
  { 2,  2,   0}, // #9816
  { 3,  4,   0}, // #9817
  { 4,  4,   0}, // #9818
  { 5,  4,   0}, // #9819
  { 6,  4,   0}, // #9820
  { 7,  4,   0}, // #9821
  { 8,  2,   0}, // #9822
  {10,  2,   0}, // #9823
  {11,  2,   0}, // #9824
  {14,  1,   0}, // #9825
  {15,  1,   0}, // #9826
  {19,  2,   0}, // #9827
  { 2,  2,   0}, // #9828
  { 3,  5,   0}, // #9829
  { 4,  6,   0}, // #9830
  { 5,  6,   0}, // #9831
  { 6,  2,   0}, // #9832
  { 7,  3,   0}, // #9833
  { 8,  1,   0}, // #9834
  {10,  2,   0}, // #9835
  {11,  2,   0}, // #9836
  {14,  1,   0}, // #9837
  {15,  1,   0}, // #9838
  {19,  2,   0}, // #9839
  { 2,  2,   0}, // #9840
  { 3,  5,   0}, // #9841
  { 4,  5,   0}, // #9842
  { 5,  5,   0}, // #9843
  { 6,  2,   0}, // #9844
  { 7,  2,   0}, // #9845
  {10,  2,   0}, // #9846
  {11,  2,   0}, // #9847
  {19,  2,   0}, // #9848
  { 2,  2,   0}, // #9849
  { 3,  4,   0}, // #9850
  { 4,  5,   0}, // #9851
  { 5,  5,   0}, // #9852
  { 6,  2,   0}, // #9853
  { 7,  3,   0}, // #9854
  { 8,  1,   0}, // #9855
  {10,  2,   0}, // #9856
  {11,  2,   0}, // #9857
  {14,  1,   0}, // #9858
  {15,  1,   0}, // #9859
  {19,  2,   0}, // #9860
  { 1,  2,   0}, // #9861
  { 2,  2,   0}, // #9862
  { 3,  4,   0}, // #9863
  { 4,  5,   0}, // #9864
  { 5,  5,   0}, // #9865
  { 6,  4,   0}, // #9866
  { 7,  5,   0}, // #9867
  { 8,  3,   0}, // #9868
  {10,  2,   0}, // #9869
  {11,  2,   0}, // #9870
  {14,  1,   0}, // #9871
  {15,  1,   0}, // #9872
  {19,  2,   0}, // #9873
  { 2,  2,   0}, // #9874
  { 3,  5,   0}, // #9875
  { 4,  6,   0}, // #9876
  { 5,  6,   0}, // #9877
  { 6,  2,   0}, // #9878
  { 7,  3,   0}, // #9879
  { 8,  1,   0}, // #9880
  {10,  2,   0}, // #9881
  {11,  2,   0}, // #9882
  {19,  2,   0}, // #9883
  { 2,  2,   0}, // #9884
  { 3,  4,   0}, // #9885
  { 4,  4,   0}, // #9886
  { 5,  4,   0}, // #9887
  { 6,  2,   0}, // #9888
  { 7,  2,   0}, // #9889
  {10,  2,   0}, // #9890
  {11,  2,   0}, // #9891
  {14,  1,   0}, // #9892
  {15,  1,   0}, // #9893
  {19,  2,   0}, // #9894
  { 2,  1,   0}, // #9895
  { 3,  4,   0}, // #9896
  { 4,  5,   0}, // #9897
  { 5,  5,   0}, // #9898
  { 6,  1,   0}, // #9899
  { 7,  2,   0}, // #9900
  { 8,  1,   0}, // #9901
  {10,  1,   0}, // #9902
  {11,  1,   0}, // #9903
  {14,  1,   0}, // #9904
  {15,  1,   0}, // #9905
  {19,  1,   0}, // #9906
  { 2,  1,   0}, // #9907
  { 3,  4,   0}, // #9908
  { 4,  4,   0}, // #9909
  { 5,  4,   0}, // #9910
  { 6,  1,   0}, // #9911
  { 7,  1,   0}, // #9912
  {10,  1,   0}, // #9913
  {11,  1,   0}, // #9914
  {19,  1,   0}, // #9915
  { 2,  1,   0}, // #9916
  { 3,  4,   0}, // #9917
  { 4,  4,   0}, // #9918
  { 5,  4,   0}, // #9919
  { 6,  1,   0}, // #9920
  { 7,  1,   0}, // #9921
  {10,  2,   0}, // #9922
  {11,  2,   0}, // #9923
  {14,  1,   0}, // #9924
  {15,  1,   0}, // #9925
  {19,  1,   0}, // #9926
  { 2,  1,   0}, // #9927
  { 3,  4,   0}, // #9928
  { 4,  4,   0}, // #9929
  { 5,  4,   0}, // #9930
  { 6,  1,   0}, // #9931
  { 7,  1,   0}, // #9932
  {10,  2,   0}, // #9933
  {11,  2,   0}, // #9934
  {19,  1,   0}, // #9935
  { 1,  1,   0}, // #9936
  { 2,  1,   0}, // #9937
  { 3,  4,   0}, // #9938
  { 4,  4,   0}, // #9939
  { 5,  4,   0}, // #9940
  { 6,  4,   0}, // #9941
  { 7,  4,   0}, // #9942
  { 8,  1,   0}, // #9943
  {10,  2,   0}, // #9944
  {11,  2,   0}, // #9945
  {14,  1,   0}, // #9946
  {15,  1,   0}, // #9947
  {19,  2,   0}, // #9948
  { 1,  1,   0}, // #9949
  { 2,  1,   0}, // #9950
  { 3,  4,   0}, // #9951
  { 4,  4,   0}, // #9952
  { 5,  4,   0}, // #9953
  { 6,  4,   0}, // #9954
  { 7,  4,   0}, // #9955
  { 8,  1,   0}, // #9956
  {10,  2,   0}, // #9957
  {11,  2,   0}, // #9958
  {19,  2,   0}, // #9959
  { 2,  2,   0}, // #9960
  { 3,  5,   0}, // #9961
  { 4,  6,   0}, // #9962
  { 5,  6,   0}, // #9963
  { 6,  1,   0}, // #9964
  { 7,  2,   0}, // #9965
  { 8,  1,   0}, // #9966
  {10,  1,   0}, // #9967
  {11,  1,   0}, // #9968
  {14,  1,   0}, // #9969
  {15,  1,   0}, // #9970
  {19,  1,   0}, // #9971
  { 2,  2,   0}, // #9972
  { 3,  4,   0}, // #9973
  { 4,  4,   0}, // #9974
  { 5,  4,   0}, // #9975
  { 6,  1,   0}, // #9976
  { 7,  1,   0}, // #9977
  {10,  1,   0}, // #9978
  {11,  1,   0}, // #9979
  {19,  1,   0}, // #9980
  { 2,  2,   0}, // #9981
  { 3,  3,   0}, // #9982
  { 4,  3,   0}, // #9983
  { 5,  3,   0}, // #9984
  { 6,  1,   0}, // #9985
  { 7,  1,   0}, // #9986
  {10,  1,   0}, // #9987
  {11,  1,   0}, // #9988
  {14,  1,   0}, // #9989
  {15,  1,   0}, // #9990
  {19,  1,   0}, // #9991
  { 2,  2,   0}, // #9992
  { 3,  3,   0}, // #9993
  { 4,  3,   0}, // #9994
  { 5,  3,   0}, // #9995
  { 6,  1,   0}, // #9996
  { 7,  1,   0}, // #9997
  {10,  1,   0}, // #9998
  {11,  1,   0}, // #9999
  {19,  1,   0}, // #10000
  { 1,  1,   0}, // #10001
  { 2,  2,   0}, // #10002
  { 3,  3,   0}, // #10003
  { 4,  3,   0}, // #10004
  { 5,  3,   0}, // #10005
  { 6,  1,   0}, // #10006
  { 7,  1,   0}, // #10007
  { 8,  1,   0}, // #10008
  { 2,  1,   0}, // #10009
  { 3,  2,   0}, // #10010
  { 4,  2,   0}, // #10011
  { 5,  2,   0}, // #10012
  {14,  1,   0}, // #10013
  {15,  1,   0}, // #10014
  { 1,  2,   0}, // #10015
  { 2,  2,   0}, // #10016
  { 3,  3,   0}, // #10017
  { 4,  3,   0}, // #10018
  { 5,  3,   0}, // #10019
  { 6,  2,   0}, // #10020
  { 7,  2,   0}, // #10021
  { 8,  2,   0}, // #10022
  {14,  1,   0}, // #10023
  {15,  1,   0}, // #10024
  { 1,  4,   0}, // #10025
  { 2,  4,   0}, // #10026
  { 3,  7,   0}, // #10027
  { 4,  8,   0}, // #10028
  { 5,  8,   0}, // #10029
  { 6,  7,   0}, // #10030
  { 7,  8,   0}, // #10031
  { 8,  5,   0}, // #10032
  {10,  1,   0}, // #10033
  {11,  1,   0}, // #10034
  {14,  1,   0}, // #10035
  {15,  1,   0}, // #10036
  {19,  1,   0}, // #10037
  { 1,  4,   0}, // #10038
  { 2,  4,   0}, // #10039
  { 3,  5,   0}, // #10040
  { 4,  6,   0}, // #10041
  { 5,  6,   0}, // #10042
  { 6,  5,   0}, // #10043
  { 7,  6,   0}, // #10044
  { 8,  5,   0}, // #10045
  {10,  1,   0}, // #10046
  {11,  1,   0}, // #10047
  {19,  1,   0}, // #10048
  { 1,  1,   0}, // #10049
  { 2,  1,   0}, // #10050
  { 3,  3,   0}, // #10051
  { 4,  3,   0}, // #10052
  { 5,  3,   0}, // #10053
  { 6,  3,   0}, // #10054
  { 7,  3,   0}, // #10055
  { 8,  1,   0}, // #10056
  {10,  2,   0}, // #10057
  {11,  2,   0}, // #10058
  {14,  8,   0}, // #10059
  {15,  8,   0}, // #10060
  {19,  2,   0}, // #10061
  { 5,  1,   0}, // #10062
  {14,  2,   0}, // #10063
  {18,  2,   0}, // #10064
  {22,  2,   0}, // #10065
  { 3, 11,   0}, // #10066
  { 4, 11,   0}, // #10067
  { 5, 11,   0}, // #10068
  { 6,  8,   0}, // #10069
  { 7,  8,   0}, // #10070
  {10,  8,   0}, // #10071
  {11,  8,   0}, // #10072
  {14,  1,   0}, // #10073
  {15,  1,   0}, // #10074
  {19,  8,   0}, // #10075
  { 3, 12,   0}, // #10076
  { 4, 12,   0}, // #10077
  { 5, 12,   0}, // #10078
  { 6,  8,   0}, // #10079
  { 7,  8,   0}, // #10080
  {10,  8,   0}, // #10081
  {11,  8,   0}, // #10082
  {19,  8,   0}, // #10083
  { 1,  1,   0}, // #10084
  { 2,  9,   0}, // #10085
  { 3, 29,   0}, // #10086
  { 4, 29,   0}, // #10087
  { 5, 29,   0}, // #10088
  { 6, 12,   0}, // #10089
  { 7, 12,   0}, // #10090
  { 8,  1,   0}, // #10091
  {10, 13,   0}, // #10092
  {11, 13,   0}, // #10093
  {14,  1,   0}, // #10094
  {15,  1,   0}, // #10095
  {19, 11,   0}, // #10096
  { 1,  1,   0}, // #10097
  { 2,  9,   0}, // #10098
  { 3, 30,   0}, // #10099
  { 4, 30,   0}, // #10100
  { 5, 30,   0}, // #10101
  { 6, 12,   0}, // #10102
  { 7, 12,   0}, // #10103
  { 8,  1,   0}, // #10104
  {10, 13,   0}, // #10105
  {11, 13,   0}, // #10106
  {19, 11,   0}, // #10107
  { 1, 13,   0}, // #10108
  { 2, 13,   0}, // #10109
  { 3, 45,   0}, // #10110
  { 4, 45,   0}, // #10111
  { 5, 45,   0}, // #10112
  { 6, 45,   0}, // #10113
  { 7, 45,   0}, // #10114
  { 8, 13,   0}, // #10115
  {10, 23,   0}, // #10116
  {11, 23,   0}, // #10117
  {14,  1,   0}, // #10118
  {15,  1,   0}, // #10119
  {19, 23,   0}, // #10120
  { 1, 13,   0}, // #10121
  { 2, 13,   0}, // #10122
  { 3, 46,   0}, // #10123
  { 4, 46,   0}, // #10124
  { 5, 46,   0}, // #10125
  { 6, 46,   0}, // #10126
  { 7, 46,   0}, // #10127
  { 8, 13,   0}, // #10128
  {10, 23,   0}, // #10129
  {11, 23,   0}, // #10130
  {19, 23,   0}, // #10131
  { 3,  4,   0}, // #10132
  { 4,  4,   0}, // #10133
  { 5,  4,   0}, // #10134
  { 6,  4,   0}, // #10135
  { 7,  4,   0}, // #10136
  {10,  4,   0}, // #10137
  {11,  4,   0}, // #10138
  {14,  1,   0}, // #10139
  {15,  1,   0}, // #10140
  {19,  4,   0}, // #10141
  { 3,  4,   0}, // #10142
  { 4,  4,   0}, // #10143
  { 5,  4,   0}, // #10144
  { 6,  4,   0}, // #10145
  { 7,  4,   0}, // #10146
  {10,  4,   0}, // #10147
  {11,  4,   0}, // #10148
  {19,  4,   0}, // #10149
  { 1,  8,   0}, // #10150
  { 2,  8,   0}, // #10151
  { 3, 29,   0}, // #10152
  { 4, 29,   0}, // #10153
  { 5, 29,   0}, // #10154
  { 6, 29,   0}, // #10155
  { 7, 29,   0}, // #10156
  { 8,  8,   0}, // #10157
  {10, 14,   0}, // #10158
  {11, 14,   0}, // #10159
  {14,  1,   0}, // #10160
  {15,  1,   0}, // #10161
  {19, 14,   0}, // #10162
  { 1,  8,   0}, // #10163
  { 2,  8,   0}, // #10164
  { 3, 30,   0}, // #10165
  { 4, 30,   0}, // #10166
  { 5, 30,   0}, // #10167
  { 6, 30,   0}, // #10168
  { 7, 30,   0}, // #10169
  { 8,  8,   0}, // #10170
  {10, 14,   0}, // #10171
  {11, 14,   0}, // #10172
  {19, 14,   0}, // #10173
  { 1,  1,   0}, // #10174
  { 2,  1,   0}, // #10175
  { 3,  3,   0}, // #10176
  { 4,  4,   0}, // #10177
  { 5,  4,   0}, // #10178
  { 6,  3,   0}, // #10179
  { 7,  4,   0}, // #10180
  { 8,  2,   0}, // #10181
  {10,  2,   0}, // #10182
  {11,  2,   0}, // #10183
  {14,  1,   0}, // #10184
  {18,  1,   0}, // #10185
  {19,  2,   0}, // #10186
  {22,  1,   0}, // #10187
  { 1,  1,   0}, // #10188
  { 2,  1,   0}, // #10189
  { 3,  3,   0}, // #10190
  { 4,  3,   0}, // #10191
  { 5,  4,   0}, // #10192
  { 6,  3,   0}, // #10193
  { 7,  3,   0}, // #10194
  { 8,  1,   0}, // #10195
  {10,  2,   0}, // #10196
  {11,  2,   0}, // #10197
  {14,  2,   0}, // #10198
  {18,  2,   0}, // #10199
  {19,  2,   0}, // #10200
  {22,  2,   0}, // #10201
  {25,  1,   0}, // #10202
  {26,  1,   0}, // #10203
  {15,  1,   0}, // #10204
  {23,  1,   0}, // #10205
  {24,  1,   0}, // #10206
  {25,  1,   0}, // #10207
  {26,  1,   0}, // #10208
  {16,  1,   0}, // #10209
  {24,  1,   0}, // #10210
  {25,  1,   0}, // #10211
  {26,  1,   0}, // #10212
  {16,  2,   0}, // #10213
  {19,  1,   0}, // #10214
  {20,  1,   0}, // #10215
  {22,  1,   0}, // #10216
  {24,  2,   0}, // #10217
  {25,  3,   0}, // #10218
  {26,  6,   0}, // #10219
  {16,  1,   0}, // #10220
  {19,  1,   0}, // #10221
  {24,  1,   0}, // #10222
  {25,  1,   0}, // #10223
  {26,  2,   0}, // #10224
  {17,  1,   0}, // #10225
  {23,  1,   0}, // #10226
  {25,  1,   0}, // #10227
  {26,  1,   0}, // #10228
  {20,  1,   0}, // #10229
  {22,  1,   0}, // #10230
  {26,  2,   0}, // #10231
  { 4,  1,   0}, // #10232
  {13,  1,   0}, // #10233
  {17,  1,   0}, // #10234
  {18,  1,   0}, // #10235
  {23,  1,   0}, // #10236
  {25,  1,   0}, // #10237
  {26,  1,   0}, // #10238
  {19,  1,   0}, // #10239
  {26,  1,   0}, // #10240
  {19,  1,   0}, // #10241
  {20,  1,   0}, // #10242
  {22,  1,   0}, // #10243
  {25,  1,   0}, // #10244
  {26,  4,   0}, // #10245
  { 3,  1,   0}, // #10246
  {13,  1,   0}, // #10247
  {14,  1,   0}, // #10248
  {15,  1,   0}, // #10249
  {16,  1,   0}, // #10250
  {23,  1,   0}, // #10251
  {24,  1,   0}, // #10252
  {25,  1,   0}, // #10253
  {26,  1,   0}, // #10254
  {19,  1,   0}, // #10255
  {25,  1,   0}, // #10256
  {26,  2,   0}, // #10257
  {13,  1,   0}, // #10258
  {19,  1,   0}, // #10259
  {23,  1,   0}, // #10260
  {25,  1,   0}, // #10261
  {26,  2,   0}, // #10262
  {13,  1,   0}, // #10263
  {23,  1,   0}, // #10264
  {25,  1,   0}, // #10265
  {26,  1,   0}, // #10266
  { 3,  1,   0}, // #10267
  {13,  1,   0}, // #10268
  {14,  1,   0}, // #10269
  {15,  1,   0}, // #10270
  {16,  1,   0}, // #10271
  {19,  1,   0}, // #10272
  {23,  1,   0}, // #10273
  {24,  1,   0}, // #10274
  {25,  1,   0}, // #10275
  {26,  2,   0}, // #10276
  { 3,  2,   0}, // #10277
  {13,  2,   0}, // #10278
  {14,  2,   0}, // #10279
  {15,  2,   0}, // #10280
  {16,  2,   0}, // #10281
  {19,  1,   0}, // #10282
  {23,  2,   0}, // #10283
  {24,  2,   0}, // #10284
  {25,  2,   0}, // #10285
  {26,  3,   0}, // #10286
  { 3,  2,   0}, // #10287
  {13,  2,   0}, // #10288
  {14,  2,   0}, // #10289
  {15,  2,   0}, // #10290
  {16,  2,   0}, // #10291
  {23,  2,   0}, // #10292
  {24,  2,   0}, // #10293
  {25,  2,   0}, // #10294
  {26,  2,   0}, // #10295
  { 3,  3,   0}, // #10296
  { 8,  6,   0}, // #10297
  {13,  3,   0}, // #10298
  {14,  3,   0}, // #10299
  {15,  9,   0}, // #10300
  {16,  3,   0}, // #10301
  {17,  6,   0}, // #10302
  {19,  1,   0}, // #10303
  {21,  6,   0}, // #10304
  {23, 10,   0}, // #10305
  {24,  9,   0}, // #10306
  {25, 10,   0}, // #10307
  {26, 11,   0}, // #10308
  { 3,  3,   0}, // #10309
  { 8,  6,   0}, // #10310
  {13,  3,   0}, // #10311
  {14,  3,   0}, // #10312
  {15,  9,   0}, // #10313
  {16,  3,   0}, // #10314
  {17,  6,   0}, // #10315
  {21,  6,   0}, // #10316
  {23, 11,   0}, // #10317
  {24,  9,   0}, // #10318
  {25, 11,   0}, // #10319
  {26, 11,   0}, // #10320
  {16,  1,   0}, // #10321
  {17,  1,   0}, // #10322
  {19,  1,   0}, // #10323
  {23,  1,   0}, // #10324
  {24,  1,   0}, // #10325
  {25,  2,   0}, // #10326
  {26,  3,   0}, // #10327
  {16,  1,   0}, // #10328
  {17,  1,   0}, // #10329
  {23,  1,   0}, // #10330
  {24,  1,   0}, // #10331
  {25,  2,   0}, // #10332
  {26,  2,   0}, // #10333
  {19,  1,   0}, // #10334
  {23,  2,   0}, // #10335
  {25,  2,   0}, // #10336
  {26,  3,   0}, // #10337
  {23,  2,   0}, // #10338
  {25,  2,   0}, // #10339
  {26,  2,   0}, // #10340
  {17,  1,   0}, // #10341
  {19,  1,   0}, // #10342
  {23,  1,   0}, // #10343
  {25,  1,   0}, // #10344
  {26,  2,   0}, // #10345
  { 4,  1,   0}, // #10346
  {13,  1,   0}, // #10347
  {17,  1,   0}, // #10348
  {18,  1,   0}, // #10349
  {19,  1,   0}, // #10350
  {23,  1,   0}, // #10351
  {25,  1,   0}, // #10352
  {26,  2,   0}, // #10353
  {16,  1,   0}, // #10354
  {19,  1,   0}, // #10355
  {20,  1,   0}, // #10356
  {22,  1,   0}, // #10357
  {24,  1,   0}, // #10358
  {25,  1,   0}, // #10359
  {26,  4,   0}, // #10360
  {25,  3,   0}, // #10361
  {26,  3,   0}, // #10362
  {16,  2,   0}, // #10363
  {24,  2,   0}, // #10364
  {25,  5,   0}, // #10365
  {26,  5,   0}, // #10366
  { 8,  1,   0}, // #10367
  {13,  1,   0}, // #10368
  {15,  1,   0}, // #10369
  {17,  1,   0}, // #10370
  {19,  1,   0}, // #10371
  {21,  1,   0}, // #10372
  {23,  2,   0}, // #10373
  {24,  1,   0}, // #10374
  {25,  2,   0}, // #10375
  {26,  3,   0}, // #10376
  { 8,  1,   0}, // #10377
  {13,  1,   0}, // #10378
  {15,  1,   0}, // #10379
  {17,  1,   0}, // #10380
  {21,  1,   0}, // #10381
  {23,  2,   0}, // #10382
  {24,  1,   0}, // #10383
  {25,  2,   0}, // #10384
  {26,  2,   0}, // #10385
  {13,  2,   0}, // #10386
  {19,  1,   0}, // #10387
  {23,  2,   0}, // #10388
  {25,  2,   0}, // #10389
  {26,  3,   0}, // #10390
  {13,  2,   0}, // #10391
  {23,  2,   0}, // #10392
  {25,  2,   0}, // #10393
  {26,  2,   0}, // #10394
  { 1, 10,   0}, // #10395
  { 3,  1,   0}, // #10396
  {13,  1,   0}, // #10397
  {14,  1,   0}, // #10398
  {15,  1,   0}, // #10399
  {16,  1,   0}, // #10400
  {19,  1,   0}, // #10401
  {23,  1,   0}, // #10402
  {24,  1,   0}, // #10403
  {25,  1,   0}, // #10404
  {26,  2,   0}, // #10405
  { 3,  7,   0}, // #10406
  { 4,  2,   0}, // #10407
  { 8,  8,   0}, // #10408
  { 9,  3,   0}, // #10409
  {13,  9,   0}, // #10410
  {14,  7,   0}, // #10411
  {15, 16,   0}, // #10412
  {16, 10,   0}, // #10413
  {17, 10,   0}, // #10414
  {18,  5,   0}, // #10415
  {21, 11,   0}, // #10416
  {23, 18,   0}, // #10417
  {24, 19,   0}, // #10418
  {25, 32,   0}, // #10419
  {26, 32,   0}, // #10420
  { 1, 10,   0}, // #10421
  { 3,  1,   0}, // #10422
  {13,  1,   0}, // #10423
  {14,  1,   0}, // #10424
  {15,  1,   0}, // #10425
  {16,  1,   0}, // #10426
  {23,  1,   0}, // #10427
  {24,  1,   0}, // #10428
  {25,  1,   0}, // #10429
  {26,  1,   0}, // #10430
  { 2,  4,   0}, // #10431
  { 3,  1,   0}, // #10432
  {13,  1,   0}, // #10433
  {14,  1,   0}, // #10434
  {15,  1,   0}, // #10435
  {16,  1,   0}, // #10436
  {19,  1,   0}, // #10437
  {23,  1,   0}, // #10438
  {24,  1,   0}, // #10439
  {25,  1,   0}, // #10440
  {26,  2,   0}, // #10441
  { 2,  4,   0}, // #10442
  { 3,  1,   0}, // #10443
  {13,  1,   0}, // #10444
  {14,  1,   0}, // #10445
  {15,  1,   0}, // #10446
  {16,  1,   0}, // #10447
  {23,  1,   0}, // #10448
  {24,  1,   0}, // #10449
  {25,  1,   0}, // #10450
  {26,  1,   0}, // #10451
  { 2,  3,   0}, // #10452
  { 3,  1,   0}, // #10453
  {13,  1,   0}, // #10454
  {14,  1,   0}, // #10455
  {15,  1,   0}, // #10456
  {16,  1,   0}, // #10457
  {19,  1,   0}, // #10458
  {23,  1,   0}, // #10459
  {24,  1,   0}, // #10460
  {25,  1,   0}, // #10461
  {26,  2,   0}, // #10462
  { 2,  3,   0}, // #10463
  { 3,  1,   0}, // #10464
  {13,  1,   0}, // #10465
  {14,  1,   0}, // #10466
  {15,  1,   0}, // #10467
  {16,  1,   0}, // #10468
  {23,  1,   0}, // #10469
  {24,  1,   0}, // #10470
  {25,  1,   0}, // #10471
  {26,  1,   0}, // #10472
  { 8,  1,   0}, // #10473
  {15,  1,   0}, // #10474
  {17,  1,   0}, // #10475
  {19,  1,   0}, // #10476
  {21,  1,   0}, // #10477
  {23,  3,   0}, // #10478
  {24,  1,   0}, // #10479
  {25,  3,   0}, // #10480
  {26,  4,   0}, // #10481
  { 8,  1,   0}, // #10482
  {15,  1,   0}, // #10483
  {17,  1,   0}, // #10484
  {21,  1,   0}, // #10485
  {23,  3,   0}, // #10486
  {24,  1,   0}, // #10487
  {25,  3,   0}, // #10488
  {26,  3,   0}, // #10489
  { 8,  1,   0}, // #10490
  {15,  1,   0}, // #10491
  {17,  1,   0}, // #10492
  {19,  1,   0}, // #10493
  {21,  1,   0}, // #10494
  {23,  4,   0}, // #10495
  {24,  1,   0}, // #10496
  {25,  4,   0}, // #10497
  {26,  5,   0}, // #10498
  { 8,  1,   0}, // #10499
  {15,  1,   0}, // #10500
  {17,  1,   0}, // #10501
  {21,  1,   0}, // #10502
  {23,  4,   0}, // #10503
  {24,  1,   0}, // #10504
  {25,  4,   0}, // #10505
  {26,  4,   0}, // #10506
  { 8,  1,   0}, // #10507
  {15,  1,   0}, // #10508
  {17,  1,   0}, // #10509
  {20,  1,   0}, // #10510
  {21,  1,   0}, // #10511
  {22,  1,   0}, // #10512
  {23,  1,   0}, // #10513
  {24,  1,   0}, // #10514
  {25,  1,   0}, // #10515
  {26,  3,   0}, // #10516
  { 3,  1,   0}, // #10517
  { 8,  1,   0}, // #10518
  {13,  1,   0}, // #10519
  {14,  1,   0}, // #10520
  {15,  2,   0}, // #10521
  {16,  1,   0}, // #10522
  {17,  1,   0}, // #10523
  {21,  1,   0}, // #10524
  {23,  2,   0}, // #10525
  {24,  2,   0}, // #10526
  {25,  2,   0}, // #10527
  {26,  2,   0}, // #10528
  {15,  9,   0}, // #10529
  {23,  9,   0}, // #10530
  {24,  9,   0}, // #10531
  {25, 10,   0}, // #10532
  {26, 10,   0}, // #10533
  {15,  2,   0}, // #10534
  {23,  2,   0}, // #10535
  {24,  2,   0}, // #10536
  {25,  2,   0}, // #10537
  {26,  2,   0}, // #10538
  { 8,  2,   0}, // #10539
  {13,  1,   0}, // #10540
  {15,  2,   0}, // #10541
  {17,  2,   0}, // #10542
  {19,  1,   0}, // #10543
  {21,  2,   0}, // #10544
  {23,  3,   0}, // #10545
  {24,  2,   0}, // #10546
  {25,  3,   0}, // #10547
  {26,  4,   0}, // #10548
  { 8,  2,   0}, // #10549
  {13,  1,   0}, // #10550
  {15,  2,   0}, // #10551
  {17,  2,   0}, // #10552
  {21,  2,   0}, // #10553
  {23,  3,   0}, // #10554
  {24,  2,   0}, // #10555
  {25,  3,   0}, // #10556
  {26,  3,   0}, // #10557
  { 3,  2,   0}, // #10558
  { 8,  4,   0}, // #10559
  {13,  2,   0}, // #10560
  {14,  2,   0}, // #10561
  {15,  6,   0}, // #10562
  {16,  2,   0}, // #10563
  {17,  4,   0}, // #10564
  {19,  1,   0}, // #10565
  {21,  4,   0}, // #10566
  {23,  6,   0}, // #10567
  {24,  6,   0}, // #10568
  {25,  7,   0}, // #10569
  {26,  8,   0}, // #10570
  { 3,  4,   0}, // #10571
  { 4,  2,   0}, // #10572
  { 8,  4,   0}, // #10573
  { 9,  8,   0}, // #10574
  {13,  6,   0}, // #10575
  {14,  4,   0}, // #10576
  {15,  8,   0}, // #10577
  {16, 26,   0}, // #10578
  {17,  6,   0}, // #10579
  {18, 10,   0}, // #10580
  {21, 12,   0}, // #10581
  {23, 10,   0}, // #10582
  {24, 30,   0}, // #10583
  {25, 66,   0}, // #10584
  {26, 66,   0}, // #10585
  { 4,  1,   0}, // #10586
  {13,  1,   0}, // #10587
  {16,  1,   0}, // #10588
  {17,  1,   0}, // #10589
  {18,  1,   0}, // #10590
  {19,  1,   0}, // #10591
  {23,  1,   0}, // #10592
  {24,  1,   0}, // #10593
  {25,  4,   0}, // #10594
  {26,  5,   0}, // #10595
  { 4,  1,   0}, // #10596
  {13,  1,   0}, // #10597
  {16,  1,   0}, // #10598
  {17,  1,   0}, // #10599
  {18,  1,   0}, // #10600
  {23,  1,   0}, // #10601
  {24,  1,   0}, // #10602
  {25,  4,   0}, // #10603
  {26,  4,   0}, // #10604
  { 4,  1,   0}, // #10605
  {13,  1,   0}, // #10606
  {17,  1,   0}, // #10607
  {18,  1,   0}, // #10608
  {19,  1,   0}, // #10609
  {23,  1,   0}, // #10610
  {25,  2,   0}, // #10611
  {26,  3,   0}, // #10612
  { 4,  1,   0}, // #10613
  {13,  1,   0}, // #10614
  {17,  1,   0}, // #10615
  {18,  1,   0}, // #10616
  {23,  1,   0}, // #10617
  {25,  2,   0}, // #10618
  {26,  2,   0}, // #10619
  { 4,  1,   0}, // #10620
  {13,  1,   0}, // #10621
  {16,  1,   0}, // #10622
  {17,  1,   0}, // #10623
  {18,  1,   0}, // #10624
  {19,  1,   0}, // #10625
  {23,  1,   0}, // #10626
  {24,  1,   0}, // #10627
  {25,  3,   0}, // #10628
  {26,  4,   0}, // #10629
  { 4,  1,   0}, // #10630
  {13,  1,   0}, // #10631
  {16,  1,   0}, // #10632
  {17,  1,   0}, // #10633
  {18,  1,   0}, // #10634
  {23,  1,   0}, // #10635
  {24,  1,   0}, // #10636
  {25,  3,   0}, // #10637
  {26,  3,   0}, // #10638
  { 4,  1,   0}, // #10639
  { 8,  1,   0}, // #10640
  {13,  1,   0}, // #10641
  {15,  1,   0}, // #10642
  {17,  2,   0}, // #10643
  {18,  1,   0}, // #10644
  {19,  1,   0}, // #10645
  {21,  1,   0}, // #10646
  {23,  2,   0}, // #10647
  {24,  1,   0}, // #10648
  {25,  2,   0}, // #10649
  {26,  3,   0}, // #10650
  { 4,  1,   0}, // #10651
  { 8,  1,   0}, // #10652
  {13,  1,   0}, // #10653
  {15,  1,   0}, // #10654
  {17,  2,   0}, // #10655
  {18,  1,   0}, // #10656
  {21,  1,   0}, // #10657
  {23,  2,   0}, // #10658
  {24,  1,   0}, // #10659
  {25,  2,   0}, // #10660
  {26,  2,   0}, // #10661
  { 8,  1,   0}, // #10662
  {15,  1,   0}, // #10663
  {17,  1,   0}, // #10664
  {21,  1,   0}, // #10665
  {23,  1,   0}, // #10666
  {24,  1,   0}, // #10667
  {25,  1,   0}, // #10668
  {26,  1,   0}, // #10669
  { 3,  1,   0}, // #10670
  {13,  1,   0}, // #10671
  {14,  1,   0}, // #10672
  {15,  1,   0}, // #10673
  {16,  1,   0}, // #10674
  {19,  1,   0}, // #10675
  {23,  1,   0}, // #10676
  {24,  1,   0}, // #10677
  {25,  2,   0}, // #10678
  {26,  3,   0}, // #10679
  {15,  1,   0}, // #10680
  {19,  1,   0}, // #10681
  {23,  1,   0}, // #10682
  {24,  1,   0}, // #10683
  {25,  1,   0}, // #10684
  {26,  2,   0}, // #10685
  { 8,  1,   0}, // #10686
  {15,  1,   0}, // #10687
  {17,  1,   0}, // #10688
  {19,  1,   0}, // #10689
  {21,  1,   0}, // #10690
  {23,  1,   0}, // #10691
  {24,  1,   0}, // #10692
  {25,  1,   0}, // #10693
  {26,  2,   0}, // #10694
  { 8,  2,   0}, // #10695
  {15,  3,   0}, // #10696
  {17,  2,   0}, // #10697
  {19,  1,   0}, // #10698
  {21,  2,   0}, // #10699
  {23,  3,   0}, // #10700
  {24,  3,   0}, // #10701
  {25,  3,   0}, // #10702
  {26,  4,   0}, // #10703
  { 8,  2,   0}, // #10704
  {15,  3,   0}, // #10705
  {17,  2,   0}, // #10706
  {21,  2,   0}, // #10707
  {23,  3,   0}, // #10708
  {24,  3,   0}, // #10709
  {25,  3,   0}, // #10710
  {26,  3,   0}, // #10711
  { 8,  2,   0}, // #10712
  {15,  2,   0}, // #10713
  {17,  2,   0}, // #10714
  {21,  2,   0}, // #10715
  {23,  2,   0}, // #10716
  {24,  2,   0}, // #10717
  {25,  2,   0}, // #10718
  {26,  2,   0}, // #10719
  { 8,  1,   0}, // #10720
  {15,  1,   0}, // #10721
  {17,  2,   0}, // #10722
  {19,  1,   0}, // #10723
  {21,  1,   0}, // #10724
  {23,  2,   0}, // #10725
  {24,  1,   0}, // #10726
  {25,  2,   0}, // #10727
  {26,  3,   0}, // #10728
  { 8,  1,   0}, // #10729
  {15,  1,   0}, // #10730
  {17,  2,   0}, // #10731
  {21,  1,   0}, // #10732
  {23,  2,   0}, // #10733
  {24,  1,   0}, // #10734
  {25,  2,   0}, // #10735
  {26,  2,   0}, // #10736
  { 3,  4,   0}, // #10737
  { 8,  3,   0}, // #10738
  {13,  4,   0}, // #10739
  {14,  4,   0}, // #10740
  {15,  7,   0}, // #10741
  {16,  4,   0}, // #10742
  {17,  3,   0}, // #10743
  {19,  1,   0}, // #10744
  {21,  3,   0}, // #10745
  {23,  7,   0}, // #10746
  {24,  7,   0}, // #10747
  {25,  8,   0}, // #10748
  {26,  9,   0}, // #10749
  { 3,  4,   0}, // #10750
  { 8,  3,   0}, // #10751
  {13,  4,   0}, // #10752
  {14,  4,   0}, // #10753
  {15,  7,   0}, // #10754
  {16,  4,   0}, // #10755
  {17,  3,   0}, // #10756
  {21,  3,   0}, // #10757
  {23,  7,   0}, // #10758
  {24,  7,   0}, // #10759
  {25,  8,   0}, // #10760
  {26,  8,   0}, // #10761
  { 3,  4,   0}, // #10762
  { 8,  3,   0}, // #10763
  {13,  4,   0}, // #10764
  {14,  4,   0}, // #10765
  {15,  7,   0}, // #10766
  {16,  4,   0}, // #10767
  {17,  3,   0}, // #10768
  {19,  1,   0}, // #10769
  {21,  3,   0}, // #10770
  {23,  8,   0}, // #10771
  {24,  7,   0}, // #10772
  {25,  9,   0}, // #10773
  {26, 10,   0}, // #10774
  { 3,  4,   0}, // #10775
  { 8,  3,   0}, // #10776
  {13,  4,   0}, // #10777
  {14,  4,   0}, // #10778
  {15,  7,   0}, // #10779
  {16,  4,   0}, // #10780
  {17,  3,   0}, // #10781
  {21,  3,   0}, // #10782
  {23,  8,   0}, // #10783
  {24,  7,   0}, // #10784
  {25,  9,   0}, // #10785
  {26,  9,   0}, // #10786
  { 3,  3,   0}, // #10787
  {13,  3,   0}, // #10788
  {14,  3,   0}, // #10789
  {15,  3,   0}, // #10790
  {16,  3,   0}, // #10791
  {19,  1,   0}, // #10792
  {23,  3,   0}, // #10793
  {24,  3,   0}, // #10794
  {25,  3,   0}, // #10795
  {26,  4,   0}, // #10796
  { 3,  3,   0}, // #10797
  {13,  3,   0}, // #10798
  {14,  3,   0}, // #10799
  {15,  3,   0}, // #10800
  {16,  3,   0}, // #10801
  {23,  3,   0}, // #10802
  {24,  3,   0}, // #10803
  {25,  3,   0}, // #10804
  {26,  3,   0}, // #10805
  {17,  2,   0}, // #10806
  {19,  1,   0}, // #10807
  {23,  3,   0}, // #10808
  {25,  3,   0}, // #10809
  {26,  4,   0}, // #10810
  {17,  2,   0}, // #10811
  {23,  3,   0}, // #10812
  {25,  3,   0}, // #10813
  {26,  3,   0}, // #10814
  {19,  1,   0}, // #10815
  {20,  1,   0}, // #10816
  {22,  1,   0}, // #10817
  {26,  3,   0}, // #10818
  {13,  1,   0}, // #10819
  {17,  1,   0}, // #10820
  {23,  2,   0}, // #10821
  {25,  2,   0}, // #10822
  {26,  2,   0}, // #10823
  { 3,  1,   0}, // #10824
  { 8,  1,   0}, // #10825
  {13,  1,   0}, // #10826
  {14,  1,   0}, // #10827
  {15,  2,   0}, // #10828
  {16,  1,   0}, // #10829
  {17,  1,   0}, // #10830
  {19,  1,   0}, // #10831
  {21,  1,   0}, // #10832
  {23,  2,   0}, // #10833
  {24,  2,   0}, // #10834
  {25,  2,   0}, // #10835
  {26,  3,   0}, // #10836
  {16,  2,   0}, // #10837
  {19,  1,   0}, // #10838
  {24,  2,   0}, // #10839
  {25,  2,   0}, // #10840
  {26,  3,   0}, // #10841
  {16,  3,   0}, // #10842
  {19,  1,   0}, // #10843
  {20,  1,   0}, // #10844
  {22,  1,   0}, // #10845
  {24,  3,   0}, // #10846
  {25,  3,   0}, // #10847
  {26,  6,   0}, // #10848
  {16,  6,   0}, // #10849
  {19,  1,   0}, // #10850
  {24,  6,   0}, // #10851
  {25,  6,   0}, // #10852
  {26,  7,   0}, // #10853
  {16,  3,   0}, // #10854
  {24,  3,   0}, // #10855
  {25,  3,   0}, // #10856
  {26,  3,   0}, // #10857
  {16,  1,   0}, // #10858
  {20,  1,   0}, // #10859
  {22,  1,   0}, // #10860
  {24,  1,   0}, // #10861
  {25,  1,   0}, // #10862
  {26,  3,   0}, // #10863
  { 4,  1,   0}, // #10864
  {13,  1,   0}, // #10865
  {16,  2,   0}, // #10866
  {17,  1,   0}, // #10867
  {18,  1,   0}, // #10868
  {19,  1,   0}, // #10869
  {22,  1,   0}, // #10870
  {23,  1,   0}, // #10871
  {24,  2,   0}, // #10872
  {25,  4,   0}, // #10873
  {26,  6,   0}, // #10874
  { 4,  1,   0}, // #10875
  {13,  1,   0}, // #10876
  {17,  1,   0}, // #10877
  {18,  1,   0}, // #10878
  {19,  1,   0}, // #10879
  {22,  1,   0}, // #10880
  {23,  1,   0}, // #10881
  {25,  2,   0}, // #10882
  {26,  4,   0}, // #10883
  { 4,  1,   0}, // #10884
  {13,  1,   0}, // #10885
  {16,  2,   0}, // #10886
  {17,  1,   0}, // #10887
  {18,  1,   0}, // #10888
  {23,  1,   0}, // #10889
  {24,  2,   0}, // #10890
  {25,  4,   0}, // #10891
  {26,  4,   0}, // #10892
  { 2,  6,   0}, // #10893
  { 3,  1,   0}, // #10894
  {13,  1,   0}, // #10895
  {14,  1,   0}, // #10896
  {15,  1,   0}, // #10897
  {16,  1,   0}, // #10898
  {19,  1,   0}, // #10899
  {23,  1,   0}, // #10900
  {24,  1,   0}, // #10901
  {25,  1,   0}, // #10902
  {26,  2,   0}, // #10903
  { 2,  6,   0}, // #10904
  { 3,  1,   0}, // #10905
  {13,  1,   0}, // #10906
  {14,  1,   0}, // #10907
  {15,  1,   0}, // #10908
  {16,  1,   0}, // #10909
  {23,  1,   0}, // #10910
  {24,  1,   0}, // #10911
  {25,  1,   0}, // #10912
  {26,  1,   0}, // #10913
  { 2,  7,   0}, // #10914
  { 3,  1,   0}, // #10915
  {13,  1,   0}, // #10916
  {14,  1,   0}, // #10917
  {15,  1,   0}, // #10918
  {16,  1,   0}, // #10919
  {23,  1,   0}, // #10920
  {24,  1,   0}, // #10921
  {25,  1,   0}, // #10922
  {26,  1,   0}, // #10923
  {15,  2,   0}, // #10924
  {19,  1,   0}, // #10925
  {23,  2,   0}, // #10926
  {24,  2,   0}, // #10927
  {25,  2,   0}, // #10928
  {26,  3,   0}, // #10929
  { 8,  1,   0}, // #10930
  {13,  1,   0}, // #10931
  {15,  1,   0}, // #10932
  {17,  1,   0}, // #10933
  {20,  1,   0}, // #10934
  {21,  1,   0}, // #10935
  {22,  1,   0}, // #10936
  {23,  2,   0}, // #10937
  {24,  1,   0}, // #10938
  {25,  2,   0}, // #10939
  {26,  4,   0}, // #10940
  { 8,  1,   0}, // #10941
  {15,  2,   0}, // #10942
  {17,  1,   0}, // #10943
  {20,  1,   0}, // #10944
  {21,  1,   0}, // #10945
  {22,  1,   0}, // #10946
  {23,  2,   0}, // #10947
  {24,  2,   0}, // #10948
  {25,  2,   0}, // #10949
  {26,  4,   0}, // #10950
  { 8,  1,   0}, // #10951
  {15,  2,   0}, // #10952
  {17,  1,   0}, // #10953
  {21,  1,   0}, // #10954
  {23,  2,   0}, // #10955
  {24,  2,   0}, // #10956
  {25,  2,   0}, // #10957
  {26,  2,   0}, // #10958
  { 2,  8,   0}, // #10959
  { 3,  1,   0}, // #10960
  {13,  1,   0}, // #10961
  {14,  1,   0}, // #10962
  {15,  1,   0}, // #10963
  {16,  1,   0}, // #10964
  {19,  1,   0}, // #10965
  {23,  1,   0}, // #10966
  {24,  1,   0}, // #10967
  {25,  1,   0}, // #10968
  {26,  2,   0}, // #10969
  { 2,  8,   0}, // #10970
  { 3,  1,   0}, // #10971
  {13,  1,   0}, // #10972
  {14,  1,   0}, // #10973
  {15,  1,   0}, // #10974
  {16,  1,   0}, // #10975
  {23,  1,   0}, // #10976
  {24,  1,   0}, // #10977
  {25,  1,   0}, // #10978
  {26,  1,   0}, // #10979
  { 2, 16,   0}, // #10980
  { 3,  2,   0}, // #10981
  { 8,  1,   0}, // #10982
  {13,  2,   0}, // #10983
  {14,  2,   0}, // #10984
  {15,  3,   0}, // #10985
  {16,  2,   0}, // #10986
  {17,  1,   0}, // #10987
  {19,  1,   0}, // #10988
  {21,  1,   0}, // #10989
  {23,  3,   0}, // #10990
  {24,  3,   0}, // #10991
  {25,  3,   0}, // #10992
  {26,  4,   0}, // #10993
  { 2, 16,   0}, // #10994
  { 3,  2,   0}, // #10995
  { 8,  1,   0}, // #10996
  {13,  2,   0}, // #10997
  {14,  2,   0}, // #10998
  {15,  3,   0}, // #10999
  {16,  2,   0}, // #11000
  {17,  1,   0}, // #11001
  {21,  1,   0}, // #11002
  {23,  3,   0}, // #11003
  {24,  3,   0}, // #11004
  {25,  3,   0}, // #11005
  {26,  3,   0}, // #11006
  { 2,  5,   0}, // #11007
  { 3,  1,   0}, // #11008
  {13,  1,   0}, // #11009
  {14,  1,   0}, // #11010
  {15,  1,   0}, // #11011
  {16,  1,   0}, // #11012
  {19,  1,   0}, // #11013
  {23,  1,   0}, // #11014
  {24,  1,   0}, // #11015
  {25,  1,   0}, // #11016
  {26,  2,   0}, // #11017
  { 2,  5,   0}, // #11018
  { 3,  1,   0}, // #11019
  {13,  1,   0}, // #11020
  {14,  1,   0}, // #11021
  {15,  1,   0}, // #11022
  {16,  1,   0}, // #11023
  {23,  1,   0}, // #11024
  {24,  1,   0}, // #11025
  {25,  1,   0}, // #11026
  {26,  1,   0}, // #11027
  { 2, 10,   0}, // #11028
  { 3,  2,   0}, // #11029
  { 8,  1,   0}, // #11030
  {13,  2,   0}, // #11031
  {14,  2,   0}, // #11032
  {15,  3,   0}, // #11033
  {16,  2,   0}, // #11034
  {17,  1,   0}, // #11035
  {19,  1,   0}, // #11036
  {21,  1,   0}, // #11037
  {23,  3,   0}, // #11038
  {24,  3,   0}, // #11039
  {25,  3,   0}, // #11040
  {26,  4,   0}, // #11041
  { 2, 10,   0}, // #11042
  { 3,  2,   0}, // #11043
  { 8,  1,   0}, // #11044
  {13,  2,   0}, // #11045
  {14,  2,   0}, // #11046
  {15,  3,   0}, // #11047
  {16,  2,   0}, // #11048
  {17,  1,   0}, // #11049
  {21,  1,   0}, // #11050
  {23,  3,   0}, // #11051
  {24,  3,   0}, // #11052
  {25,  3,   0}, // #11053
  {26,  3,   0}, // #11054
  { 3,  1,   0}, // #11055
  {13,  1,   0}, // #11056
  {14,  1,   0}, // #11057
  {15,  1,   0}, // #11058
  {16,  1,   0}, // #11059
  {20,  1,   0}, // #11060
  {22,  1,   0}, // #11061
  {23,  1,   0}, // #11062
  {24,  1,   0}, // #11063
  {25,  1,   0}, // #11064
  {26,  3,   0}, // #11065
  { 2, 12,   0}, // #11066
  { 3,  1,   0}, // #11067
  {13,  1,   0}, // #11068
  {14,  1,   0}, // #11069
  {15,  1,   0}, // #11070
  {16,  1,   0}, // #11071
  {19,  1,   0}, // #11072
  {23,  1,   0}, // #11073
  {24,  1,   0}, // #11074
  {25,  1,   0}, // #11075
  {26,  2,   0}, // #11076
  { 2, 12,   0}, // #11077
  { 3,  1,   0}, // #11078
  {13,  1,   0}, // #11079
  {14,  1,   0}, // #11080
  {15,  1,   0}, // #11081
  {16,  1,   0}, // #11082
  {23,  1,   0}, // #11083
  {24,  1,   0}, // #11084
  {25,  1,   0}, // #11085
  {26,  1,   0}, // #11086
  { 2, 24,   0}, // #11087
  { 3,  2,   0}, // #11088
  { 8,  1,   0}, // #11089
  {13,  2,   0}, // #11090
  {14,  2,   0}, // #11091
  {15,  3,   0}, // #11092
  {16,  2,   0}, // #11093
  {17,  1,   0}, // #11094
  {19,  1,   0}, // #11095
  {21,  1,   0}, // #11096
  {23,  3,   0}, // #11097
  {24,  3,   0}, // #11098
  {25,  3,   0}, // #11099
  {26,  4,   0}, // #11100
  { 2, 24,   0}, // #11101
  { 3,  2,   0}, // #11102
  { 8,  1,   0}, // #11103
  {13,  2,   0}, // #11104
  {14,  2,   0}, // #11105
  {15,  3,   0}, // #11106
  {16,  2,   0}, // #11107
  {17,  1,   0}, // #11108
  {21,  1,   0}, // #11109
  {23,  3,   0}, // #11110
  {24,  3,   0}, // #11111
  {25,  3,   0}, // #11112
  {26,  3,   0}, // #11113
  { 2, 12,   0}, // #11114
  { 3,  2,   0}, // #11115
  { 8,  1,   0}, // #11116
  {13,  2,   0}, // #11117
  {14,  2,   0}, // #11118
  {15,  3,   0}, // #11119
  {16,  2,   0}, // #11120
  {17,  1,   0}, // #11121
  {19,  1,   0}, // #11122
  {21,  1,   0}, // #11123
  {23,  3,   0}, // #11124
  {24,  3,   0}, // #11125
  {25,  3,   0}, // #11126
  {26,  4,   0}, // #11127
  { 2, 12,   0}, // #11128
  { 3,  2,   0}, // #11129
  { 8,  1,   0}, // #11130
  {13,  2,   0}, // #11131
  {14,  2,   0}, // #11132
  {15,  3,   0}, // #11133
  {16,  2,   0}, // #11134
  {17,  1,   0}, // #11135
  {21,  1,   0}, // #11136
  {23,  3,   0}, // #11137
  {24,  3,   0}, // #11138
  {25,  3,   0}, // #11139
  {26,  3,   0}, // #11140
  {16,  1,   0}, // #11141
  {19,  1,   0}, // #11142
  {22,  1,   0}, // #11143
  {24,  1,   0}, // #11144
  {25,  3,   0}, // #11145
  {26,  5,   0}, // #11146
  { 4,  2,   0}, // #11147
  {13,  2,   0}, // #11148
  {16,  4,   0}, // #11149
  {17,  3,   0}, // #11150
  {18,  2,   0}, // #11151
  {19,  1,   0}, // #11152
  {22,  1,   0}, // #11153
  {23,  3,   0}, // #11154
  {24,  4,   0}, // #11155
  {25,  9,   0}, // #11156
  {26, 11,   0}, // #11157
  { 3,  2,   0}, // #11158
  { 4,  1,   0}, // #11159
  { 8,  2,   0}, // #11160
  { 9,  4,   0}, // #11161
  {13,  3,   0}, // #11162
  {14,  2,   0}, // #11163
  {15,  6,   0}, // #11164
  {16,  6,   0}, // #11165
  {17,  3,   0}, // #11166
  {18,  5,   0}, // #11167
  {21,  6,   0}, // #11168
  {23,  7,   0}, // #11169
  {24, 10,   0}, // #11170
  {25, 15,   0}, // #11171
  {26, 15,   0}, // #11172
  { 3,  1,   0}, // #11173
  { 8,  1,   0}, // #11174
  {13,  2,   0}, // #11175
  {14,  1,   0}, // #11176
  {15,  2,   0}, // #11177
  {16,  1,   0}, // #11178
  {17,  1,   0}, // #11179
  {21,  1,   0}, // #11180
  {23,  3,   0}, // #11181
  {24,  2,   0}, // #11182
  {25,  3,   0}, // #11183
  {26,  3,   0}, // #11184
  {19,  1,   0}, // #11185
  {25,  2,   0}, // #11186
  {26,  3,   0}, // #11187
  { 9,  1,   0}, // #11188
  {16,  1,   0}, // #11189
  {18,  1,   0}, // #11190
  {21,  1,   0}, // #11191
  {24,  1,   0}, // #11192
  {25,  3,   0}, // #11193
  {26,  3,   0}, // #11194
  { 9,  1,   0}, // #11195
  {16,  2,   0}, // #11196
  {18,  1,   0}, // #11197
  {19,  1,   0}, // #11198
  {20,  1,   0}, // #11199
  {21,  1,   0}, // #11200
  {22,  1,   0}, // #11201
  {24,  2,   0}, // #11202
  {25,  5,   0}, // #11203
  {26,  8,   0}, // #11204
  {16,  1,   0}, // #11205
  {24,  1,   0}, // #11206
  {25,  2,   0}, // #11207
  {26,  2,   0}, // #11208
  { 3,  1,   0}, // #11209
  {13,  1,   0}, // #11210
  {14,  1,   0}, // #11211
  {15,  2,   0}, // #11212
  {16,  1,   0}, // #11213
  {19,  1,   0}, // #11214
  {23,  2,   0}, // #11215
  {24,  2,   0}, // #11216
  {25,  2,   0}, // #11217
  {26,  3,   0}, // #11218
  {16,  2,   0}, // #11219
  {24,  2,   0}, // #11220
  {25, 11,   0}, // #11221
  {26, 11,   0}, // #11222
  { 9,  1,   0}, // #11223
  {16,  1,   0}, // #11224
  {18,  1,   0}, // #11225
  {20,  1,   0}, // #11226
  {21,  1,   0}, // #11227
  {22,  1,   0}, // #11228
  {24,  1,   0}, // #11229
  {25,  1,   0}, // #11230
  {26,  3,   0}, // #11231
  { 9,  1,   0}, // #11232
  {16,  1,   0}, // #11233
  {18,  1,   0}, // #11234
  {21,  1,   0}, // #11235
  {24,  1,   0}, // #11236
  {25,  4,   0}, // #11237
  {26,  4,   0}, // #11238
  {16,  4,   0}, // #11239
  {17,  2,   0}, // #11240
  {19,  1,   0}, // #11241
  {20,  1,   0}, // #11242
  {22,  1,   0}, // #11243
  {23,  2,   0}, // #11244
  {24,  4,   0}, // #11245
  {25, 11,   0}, // #11246
  {26, 14,   0}, // #11247
  { 9,  1,   0}, // #11248
  {16,  4,   0}, // #11249
  {17,  1,   0}, // #11250
  {18,  1,   0}, // #11251
  {21,  1,   0}, // #11252
  {23,  1,   0}, // #11253
  {24,  4,   0}, // #11254
  {25,  7,   0}, // #11255
  {26,  7,   0}, // #11256
  { 9,  1,   0}, // #11257
  {16,  1,   0}, // #11258
  {18,  1,   0}, // #11259
  {21,  1,   0}, // #11260
  {24,  1,   0}, // #11261
  {25,  6,   0}, // #11262
  {26,  6,   0}, // #11263
  { 3,  2,   0}, // #11264
  { 8,  4,   0}, // #11265
  {13,  2,   0}, // #11266
  {14,  2,   0}, // #11267
  {15,  6,   0}, // #11268
  {16,  6,   0}, // #11269
  {17,  4,   0}, // #11270
  {19,  1,   0}, // #11271
  {20,  1,   0}, // #11272
  {21,  4,   0}, // #11273
  {22,  1,   0}, // #11274
  {23,  6,   0}, // #11275
  {24, 10,   0}, // #11276
  {25, 16,   0}, // #11277
  {26, 19,   0}, // #11278
  { 8,  2,   0}, // #11279
  {15,  2,   0}, // #11280
  {17,  2,   0}, // #11281
  {21,  2,   0}, // #11282
  {23,  2,   0}, // #11283
  {24,  2,   0}, // #11284
  {25, 22,   0}, // #11285
  {26, 22,   0}, // #11286
  { 8,  1,   0}, // #11287
  { 9,  2,   0}, // #11288
  {15,  1,   0}, // #11289
  {16,  2,   0}, // #11290
  {17,  1,   0}, // #11291
  {18,  2,   0}, // #11292
  {21,  3,   0}, // #11293
  {23,  1,   0}, // #11294
  {24,  3,   0}, // #11295
  {25, 10,   0}, // #11296
  {26, 10,   0}, // #11297
  { 8,  1,   0}, // #11298
  { 9,  1,   0}, // #11299
  {15,  1,   0}, // #11300
  {16,  2,   0}, // #11301
  {17,  1,   0}, // #11302
  {18,  1,   0}, // #11303
  {19,  1,   0}, // #11304
  {20,  1,   0}, // #11305
  {21,  2,   0}, // #11306
  {22,  1,   0}, // #11307
  {23,  1,   0}, // #11308
  {24,  3,   0}, // #11309
  {25,  5,   0}, // #11310
  {26,  8,   0}, // #11311
  { 8,  6,   0}, // #11312
  {15,  9,   0}, // #11313
  {17,  6,   0}, // #11314
  {21,  6,   0}, // #11315
  {23,  9,   0}, // #11316
  {24,  9,   0}, // #11317
  {25, 15,   0}, // #11318
  {26, 15,   0}, // #11319
  { 8,  1,   0}, // #11320
  { 9,  5,   0}, // #11321
  {15,  1,   0}, // #11322
  {16,  9,   0}, // #11323
  {17,  1,   0}, // #11324
  {18,  5,   0}, // #11325
  {19,  2,   0}, // #11326
  {21,  6,   0}, // #11327
  {22,  1,   0}, // #11328
  {23,  1,   0}, // #11329
  {24, 10,   0}, // #11330
  {25, 20,   0}, // #11331
  {26, 23,   0}, // #11332
  { 8,  1,   0}, // #11333
  { 9,  5,   0}, // #11334
  {15,  1,   0}, // #11335
  {16,  9,   0}, // #11336
  {17,  1,   0}, // #11337
  {18,  5,   0}, // #11338
  {19,  3,   0}, // #11339
  {21,  6,   0}, // #11340
  {23,  1,   0}, // #11341
  {24, 10,   0}, // #11342
  {25, 20,   0}, // #11343
  {26, 23,   0}, // #11344
  { 8,  1,   0}, // #11345
  { 9,  1,   0}, // #11346
  {15,  1,   0}, // #11347
  {16,  2,   0}, // #11348
  {17,  1,   0}, // #11349
  {18,  1,   0}, // #11350
  {21,  2,   0}, // #11351
  {23,  1,   0}, // #11352
  {24,  3,   0}, // #11353
  {25,  8,   0}, // #11354
  {26,  8,   0}, // #11355
  { 3,  4,   0}, // #11356
  { 9,  2,   0}, // #11357
  {13,  4,   0}, // #11358
  {14,  4,   0}, // #11359
  {15,  5,   0}, // #11360
  {16,  8,   0}, // #11361
  {17,  1,   0}, // #11362
  {18,  2,   0}, // #11363
  {19, 33,   0}, // #11364
  {21,  2,   0}, // #11365
  {23,  6,   0}, // #11366
  {24,  9,   0}, // #11367
  {25, 57,   0}, // #11368
  {26, 90,   0}, // #11369
  { 9,  1,   0}, // #11370
  {16,  1,   0}, // #11371
  {18,  1,   0}, // #11372
  {19,  1,   0}, // #11373
  {21,  1,   0}, // #11374
  {24,  1,   0}, // #11375
  {25,  2,   0}, // #11376
  {26,  3,   0}, // #11377
  { 3,  1,   0}, // #11378
  {13,  1,   0}, // #11379
  {14,  1,   0}, // #11380
  {15,  1,   0}, // #11381
  {16,  1,   0}, // #11382
  {23,  1,   0}, // #11383
  {24,  1,   0}, // #11384
  {25,  2,   0}, // #11385
  {26,  2,   0}, // #11386
  {16,  1,   0}, // #11387
  {24,  1,   0}, // #11388
  {25,  3,   0}, // #11389
  {26,  3,   0}, // #11390
  { 4,  2,   0}, // #11391
  {13,  2,   0}, // #11392
  {16,  3,   0}, // #11393
  {17,  2,   0}, // #11394
  {18,  2,   0}, // #11395
  {23,  2,   0}, // #11396
  {24,  3,   0}, // #11397
  {25,  7,   0}, // #11398
  {26,  7,   0}, // #11399
  {20,  1,   0}, // #11400
  {22,  1,   0}, // #11401
  {25,  1,   0}, // #11402
  {26,  3,   0}, // #11403
  {16,  1,   0}, // #11404
  {20,  1,   0}, // #11405
  {22,  1,   0}, // #11406
  {24,  1,   0}, // #11407
  {25,  2,   0}, // #11408
  {26,  4,   0}, // #11409
  { 9,  1,   0}, // #11410
  {16,  1,   0}, // #11411
  {18,  1,   0}, // #11412
  {20,  1,   0}, // #11413
  {21,  1,   0}, // #11414
  {22,  1,   0}, // #11415
  {24,  1,   0}, // #11416
  {25,  2,   0}, // #11417
  {26,  4,   0}, // #11418
  {20,  1,   0}, // #11419
  {22,  1,   0}, // #11420
  {25,  4,   0}, // #11421
  {26,  6,   0}, // #11422
  { 9,  1,   0}, // #11423
  {16,  1,   0}, // #11424
  {18,  1,   0}, // #11425
  {21,  1,   0}, // #11426
  {24,  1,   0}, // #11427
  {25,  2,   0}, // #11428
  {26,  2,   0}, // #11429
  { 9,  1,   0}, // #11430
  {16,  1,   0}, // #11431
  {18,  1,   0}, // #11432
  {19,  1,   0}, // #11433
  {21,  1,   0}, // #11434
  {24,  1,   0}, // #11435
  {25,  1,   0}, // #11436
  {26,  2,   0}, // #11437
  { 4,  1,   0}, // #11438
  { 9,  1,   0}, // #11439
  {13,  1,   0}, // #11440
  {16,  2,   0}, // #11441
  {17,  1,   0}, // #11442
  {18,  2,   0}, // #11443
  {21,  1,   0}, // #11444
  {23,  1,   0}, // #11445
  {24,  2,   0}, // #11446
  {25,  4,   0}, // #11447
  {26,  4,   0}, // #11448
  { 9,  1,   0}, // #11449
  {16,  1,   0}, // #11450
  {18,  1,   0}, // #11451
  {19,  1,   0}, // #11452
  {20,  1,   0}, // #11453
  {21,  1,   0}, // #11454
  {22,  1,   0}, // #11455
  {24,  1,   0}, // #11456
  {25,  2,   0}, // #11457
  {26,  5,   0}, // #11458
  {16,  2,   0}, // #11459
  {19,  1,   0}, // #11460
  {20,  1,   0}, // #11461
  {22,  1,   0}, // #11462
  {24,  2,   0}, // #11463
  {25,  2,   0}, // #11464
  {26,  5,   0}, // #11465
  {19,  1,   0}, // #11466
  {20,  1,   0}, // #11467
  {22,  1,   0}, // #11468
  {25,  2,   0}, // #11469
  {26,  5,   0}, // #11470
  { 8,  2,   0}, // #11471
  {15,  2,   0}, // #11472
  {17,  2,   0}, // #11473
  {19,  1,   0}, // #11474
  {21,  2,   0}, // #11475
  {23,  2,   0}, // #11476
  {24,  2,   0}, // #11477
  {25,  2,   0}, // #11478
  {26,  3,   0}, // #11479
  { 4,  1,   0}, // #11480
  { 9,  5,   0}, // #11481
  {13,  1,   0}, // #11482
  {15,  4,   0}, // #11483
  {16,  5,   0}, // #11484
  {17,  1,   0}, // #11485
  {18,  6,   0}, // #11486
  {21,  5,   0}, // #11487
  {23,  5,   0}, // #11488
  {24,  9,   0}, // #11489
  {25, 10,   0}, // #11490
  {26, 10,   0}, // #11491
  { 9,  1,   0}, // #11492
  {16,  1,   0}, // #11493
  {18,  1,   0}, // #11494
  {21,  1,   0}, // #11495
  {24,  1,   0}, // #11496
  {25,  1,   0}, // #11497
  {26,  1,   0}, // #11498
  {17,  1,   0}, // #11499
  {20,  1,   0}, // #11500
  {22,  1,   0}, // #11501
  {23,  1,   0}, // #11502
  {25,  1,   0}, // #11503
  {26,  3,   0}, // #11504
  {20,  1,   0}, // #11505
  {22,  2,   0}, // #11506
  {26,  3,   0}, // #11507
  {16,  2,   0}, // #11508
  {24,  2,   0}, // #11509
  {25,  2,   0}, // #11510
  {26,  2,   0}, // #11511
  { 8,  2,   0}, // #11512
  {15,  2,   0}, // #11513
  {17,  2,   0}, // #11514
  {21,  2,   0}, // #11515
  {23,  2,   0}, // #11516
  {24,  2,   0}, // #11517
  {25,  3,   0}, // #11518
  {26,  3,   0}, // #11519
  { 4,  1,   0}, // #11520
  { 9,  1,   0}, // #11521
  {13,  1,   0}, // #11522
  {16,  1,   0}, // #11523
  {17,  1,   0}, // #11524
  {18,  2,   0}, // #11525
  {21,  1,   0}, // #11526
  {23,  1,   0}, // #11527
  {24,  1,   0}, // #11528
  {25,  4,   0}, // #11529
  {26,  4,   0}, // #11530
  { 4,  1,   0}, // #11531
  { 9,  2,   0}, // #11532
  {13,  1,   0}, // #11533
  {16,  2,   0}, // #11534
  {17,  1,   0}, // #11535
  {18,  3,   0}, // #11536
  {19,  1,   0}, // #11537
  {21,  2,   0}, // #11538
  {23,  1,   0}, // #11539
  {24,  2,   0}, // #11540
  {25,  4,   0}, // #11541
  {26,  5,   0}, // #11542
  { 4,  1,   0}, // #11543
  { 9,  1,   0}, // #11544
  {13,  1,   0}, // #11545
  {16,  2,   0}, // #11546
  {17,  1,   0}, // #11547
  {18,  2,   0}, // #11548
  {21,  1,   0}, // #11549
  {23,  1,   0}, // #11550
  {24,  2,   0}, // #11551
  {25,  3,   0}, // #11552
  {26,  3,   0}, // #11553
  {16,  1,   0}, // #11554
  {24,  1,   0}, // #11555
  {25,  5,   0}, // #11556
  {26,  5,   0}, // #11557
  { 4,  1,   0}, // #11558
  {13,  1,   0}, // #11559
  {16,  5,   0}, // #11560
  {17,  2,   0}, // #11561
  {18,  1,   0}, // #11562
  {19,  1,   0}, // #11563
  {22,  1,   0}, // #11564
  {23,  2,   0}, // #11565
  {24,  5,   0}, // #11566
  {25,  8,   0}, // #11567
  {26, 10,   0}, // #11568
  { 4,  1,   0}, // #11569
  {13,  1,   0}, // #11570
  {16,  5,   0}, // #11571
  {17,  2,   0}, // #11572
  {18,  1,   0}, // #11573
  {23,  2,   0}, // #11574
  {24,  5,   0}, // #11575
  {25,  9,   0}, // #11576
  {26,  9,   0}, // #11577
  { 4,  2,   0}, // #11578
  {13,  2,   0}, // #11579
  {16,  4,   0}, // #11580
  {17,  3,   0}, // #11581
  {18,  2,   0}, // #11582
  {23,  3,   0}, // #11583
  {24,  4,   0}, // #11584
  {25, 10,   0}, // #11585
  {26, 10,   0}, // #11586
  { 4,  1,   0}, // #11587
  { 9,  8,   0}, // #11588
  {13,  1,   0}, // #11589
  {16,  8,   0}, // #11590
  {17,  1,   0}, // #11591
  {18,  9,   0}, // #11592
  {19,  1,   0}, // #11593
  {21,  8,   0}, // #11594
  {23,  1,   0}, // #11595
  {24,  8,   0}, // #11596
  {25, 30,   0}, // #11597
  {26, 31,   0}, // #11598
  { 9, 10,   0}, // #11599
  {16, 10,   0}, // #11600
  {18, 10,   0}, // #11601
  {19,  1,   0}, // #11602
  {20,  1,   0}, // #11603
  {21, 10,   0}, // #11604
  {22,  1,   0}, // #11605
  {24, 10,   0}, // #11606
  {25, 36,   0}, // #11607
  {26, 39,   0}, // #11608
  { 9, 11,   0}, // #11609
  {16, 11,   0}, // #11610
  {18, 11,   0}, // #11611
  {19,  1,   0}, // #11612
  {20,  1,   0}, // #11613
  {21, 11,   0}, // #11614
  {22,  1,   0}, // #11615
  {24, 11,   0}, // #11616
  {25, 37,   0}, // #11617
  {26, 40,   0}, // #11618
  { 4,  1,   0}, // #11619
  { 8,  2,   0}, // #11620
  { 9,  3,   0}, // #11621
  {13,  1,   0}, // #11622
  {15,  2,   0}, // #11623
  {16,  3,   0}, // #11624
  {17,  4,   0}, // #11625
  {18,  4,   0}, // #11626
  {19,  1,   0}, // #11627
  {20,  1,   0}, // #11628
  {21,  5,   0}, // #11629
  {22,  1,   0}, // #11630
  {23,  4,   0}, // #11631
  {24,  5,   0}, // #11632
  {25, 15,   0}, // #11633
  {26, 18,   0}, // #11634
  { 3,  2,   0}, // #11635
  {13,  2,   0}, // #11636
  {14,  2,   0}, // #11637
  {15,  7,   0}, // #11638
  {16, 12,   0}, // #11639
  {19,  8,   0}, // #11640
  {23,  7,   0}, // #11641
  {24, 17,   0}, // #11642
  {25, 56,   0}, // #11643
  {26, 64,   0}, // #11644
  { 3,  4,   0}, // #11645
  { 9,  4,   0}, // #11646
  {13,  4,   0}, // #11647
  {14,  4,   0}, // #11648
  {15,  5,   0}, // #11649
  {16, 10,   0}, // #11650
  {17,  1,   0}, // #11651
  {18,  4,   0}, // #11652
  {19, 31,   0}, // #11653
  {21,  4,   0}, // #11654
  {23,  6,   0}, // #11655
  {24, 11,   0}, // #11656
  {25, 57,   0}, // #11657
  {26, 88,   0}, // #11658
  { 3,  9,   0}, // #11659
  { 4,  1,   0}, // #11660
  { 8, 16,   0}, // #11661
  { 9,  1,   0}, // #11662
  {13, 10,   0}, // #11663
  {14,  9,   0}, // #11664
  {15, 25,   0}, // #11665
  {16, 31,   0}, // #11666
  {17, 17,   0}, // #11667
  {18,  2,   0}, // #11668
  {20, 11,   0}, // #11669
  {21, 17,   0}, // #11670
  {22, 11,   0}, // #11671
  {23, 26,   0}, // #11672
  {24, 47,   0}, // #11673
  {25, 78,   0}, // #11674
  {26, 100,   0}, // #11675
  { 3,  1,   0}, // #11676
  { 8,  1,   0}, // #11677
  {13,  1,   0}, // #11678
  {14,  1,   0}, // #11679
  {15,  2,   0}, // #11680
  {16,  1,   0}, // #11681
  {17,  1,   0}, // #11682
  {19,  2,   0}, // #11683
  {21,  1,   0}, // #11684
  {23,  3,   0}, // #11685
  {24,  2,   0}, // #11686
  {25,  3,   0}, // #11687
  {26,  5,   0}, // #11688
  { 3,  1,   0}, // #11689
  { 8,  1,   0}, // #11690
  {13,  1,   0}, // #11691
  {14,  1,   0}, // #11692
  {15,  2,   0}, // #11693
  {16,  1,   0}, // #11694
  {17,  1,   0}, // #11695
  {19,  4,   0}, // #11696
  {21,  1,   0}, // #11697
  {23,  3,   0}, // #11698
  {24,  2,   0}, // #11699
  {25,  3,   0}, // #11700
  {26,  7,   0}, // #11701
  { 3,  1,   0}, // #11702
  { 8,  1,   0}, // #11703
  {13,  1,   0}, // #11704
  {14,  1,   0}, // #11705
  {15,  2,   0}, // #11706
  {16,  1,   0}, // #11707
  {17,  1,   0}, // #11708
  {19,  8,   0}, // #11709
  {21,  1,   0}, // #11710
  {23,  3,   0}, // #11711
  {24,  2,   0}, // #11712
  {25,  3,   0}, // #11713
  {26, 11,   0}, // #11714
  { 8,  5,   0}, // #11715
  {13,  5,   0}, // #11716
  {15,  5,   0}, // #11717
  {17,  5,   0}, // #11718
  {21,  5,   0}, // #11719
  {23, 14,   0}, // #11720
  {24,  5,   0}, // #11721
  {25, 14,   0}, // #11722
  {26, 14,   0}, // #11723
  { 8,  9,   0}, // #11724
  {13,  7,   0}, // #11725
  {15,  9,   0}, // #11726
  {17,  9,   0}, // #11727
  {21,  9,   0}, // #11728
  {23, 21,   0}, // #11729
  {24,  9,   0}, // #11730
  {25, 21,   0}, // #11731
  {26, 21,   0}, // #11732
  { 8, 17,   0}, // #11733
  {13, 11,   0}, // #11734
  {15, 17,   0}, // #11735
  {17, 17,   0}, // #11736
  {21, 17,   0}, // #11737
  {23, 35,   0}, // #11738
  {24, 17,   0}, // #11739
  {25, 35,   0}, // #11740
  {26, 35,   0}, // #11741
  { 3,  1,   0}, // #11742
  { 8,  2,   0}, // #11743
  {13,  1,   0}, // #11744
  {14,  1,   0}, // #11745
  {15,  3,   0}, // #11746
  {16,  1,   0}, // #11747
  {17,  2,   0}, // #11748
  {21,  2,   0}, // #11749
  {23,  3,   0}, // #11750
  {24,  3,   0}, // #11751
  {25,  3,   0}, // #11752
  {26,  3,   0}, // #11753
  {13,  1,   0}, // #11754
  {17,  2,   0}, // #11755
  {23,  3,   0}, // #11756
  {25,  3,   0}, // #11757
  {26,  3,   0}, // #11758
  { 3,  1,   0}, // #11759
  { 8,  2,   0}, // #11760
  {13,  1,   0}, // #11761
  {14,  1,   0}, // #11762
  {15,  3,   0}, // #11763
  {16,  1,   0}, // #11764
  {17,  2,   0}, // #11765
  {19,  1,   0}, // #11766
  {21,  2,   0}, // #11767
  {23,  3,   0}, // #11768
  {24,  3,   0}, // #11769
  {25,  3,   0}, // #11770
  {26,  4,   0}, // #11771
  {13,  1,   0}, // #11772
  {17,  2,   0}, // #11773
  {19,  1,   0}, // #11774
  {23,  3,   0}, // #11775
  {25,  3,   0}, // #11776
  {26,  4,   0}, // #11777
  {17,  1,   0}, // #11778
  {20,  2,   0}, // #11779
  {22,  2,   0}, // #11780
  {23,  1,   0}, // #11781
  {25,  1,   0}, // #11782
  {26,  5,   0}, // #11783
  { 8,  2,   0}, // #11784
  {15,  2,   0}, // #11785
  {17,  2,   0}, // #11786
  {21,  2,   0}, // #11787
  {23,  3,   0}, // #11788
  {24,  2,   0}, // #11789
  {25,  3,   0}, // #11790
  {26,  3,   0}, // #11791
  {13,  1,   0}, // #11792
  {20,  1,   0}, // #11793
  {22,  1,   0}, // #11794
  {23,  1,   0}, // #11795
  {25,  1,   0}, // #11796
  {26,  3,   0}, // #11797
  { 8,  2,   0}, // #11798
  {15,  2,   0}, // #11799
  {17,  2,   0}, // #11800
  {20,  1,   0}, // #11801
  {21,  2,   0}, // #11802
  {22,  1,   0}, // #11803
  {23,  2,   0}, // #11804
  {24,  2,   0}, // #11805
  {25,  2,   0}, // #11806
  {26,  4,   0}, // #11807
  { 8,  1,   0}, // #11808
  {15,  1,   0}, // #11809
  {17,  1,   0}, // #11810
  {19,  1,   0}, // #11811
  {21,  1,   0}, // #11812
  {23,  1,   0}, // #11813
  {24,  1,   0}, // #11814
  {25,  2,   0}, // #11815
  {26,  3,   0}, // #11816
  { 3,  1,   0}, // #11817
  {13,  1,   0}, // #11818
  {14,  1,   0}, // #11819
  {15,  1,   0}, // #11820
  {16,  1,   0}, // #11821
  {20,  2,   0}, // #11822
  {22,  2,   0}, // #11823
  {23,  1,   0}, // #11824
  {24,  1,   0}, // #11825
  {25,  3,   0}, // #11826
  {26,  7,   0}, // #11827
  { 3,  1,   0}, // #11828
  {13,  1,   0}, // #11829
  {14,  1,   0}, // #11830
  {15,  1,   0}, // #11831
  {16,  1,   0}, // #11832
  {20,  4,   0}, // #11833
  {22,  4,   0}, // #11834
  {23,  1,   0}, // #11835
  {24,  1,   0}, // #11836
  {25,  3,   0}, // #11837
  {26, 11,   0}, // #11838
  { 3,  1,   0}, // #11839
  {13,  1,   0}, // #11840
  {14,  1,   0}, // #11841
  {15,  1,   0}, // #11842
  {16,  1,   0}, // #11843
  {20,  8,   0}, // #11844
  {22,  8,   0}, // #11845
  {23,  1,   0}, // #11846
  {24,  1,   0}, // #11847
  {25,  3,   0}, // #11848
  {26, 19,   0}, // #11849
  { 3,  1,   0}, // #11850
  { 8,  1,   0}, // #11851
  {13,  1,   0}, // #11852
  {14,  1,   0}, // #11853
  {15,  2,   0}, // #11854
  {16,  1,   0}, // #11855
  {17,  1,   0}, // #11856
  {20, 16,   0}, // #11857
  {21,  1,   0}, // #11858
  {22, 16,   0}, // #11859
  {23,  2,   0}, // #11860
  {24,  2,   0}, // #11861
  {25,  4,   0}, // #11862
  {26, 36,   0}, // #11863
  { 3,  1,   0}, // #11864
  { 8,  1,   0}, // #11865
  {13,  1,   0}, // #11866
  {14,  1,   0}, // #11867
  {15,  2,   0}, // #11868
  {16,  1,   0}, // #11869
  {17,  1,   0}, // #11870
  {20,  2,   0}, // #11871
  {21,  1,   0}, // #11872
  {22,  2,   0}, // #11873
  {23,  2,   0}, // #11874
  {24,  2,   0}, // #11875
  {25,  4,   0}, // #11876
  {26,  8,   0}, // #11877
  { 3,  1,   0}, // #11878
  { 8,  1,   0}, // #11879
  {13,  1,   0}, // #11880
  {14,  1,   0}, // #11881
  {15,  2,   0}, // #11882
  {16,  1,   0}, // #11883
  {17,  1,   0}, // #11884
  {20,  4,   0}, // #11885
  {21,  1,   0}, // #11886
  {22,  4,   0}, // #11887
  {23,  2,   0}, // #11888
  {24,  2,   0}, // #11889
  {25,  4,   0}, // #11890
  {26, 12,   0}, // #11891
  { 3,  1,   0}, // #11892
  { 8,  1,   0}, // #11893
  {13,  1,   0}, // #11894
  {14,  1,   0}, // #11895
  {15,  2,   0}, // #11896
  {16,  1,   0}, // #11897
  {17,  1,   0}, // #11898
  {20,  8,   0}, // #11899
  {21,  1,   0}, // #11900
  {22,  8,   0}, // #11901
  {23,  2,   0}, // #11902
  {24,  2,   0}, // #11903
  {25,  4,   0}, // #11904
  {26, 20,   0}, // #11905
  { 8,  2,   0}, // #11906
  {15,  2,   0}, // #11907
  {17,  2,   0}, // #11908
  {19,  1,   0}, // #11909
  {21,  2,   0}, // #11910
  {23,  3,   0}, // #11911
  {24,  2,   0}, // #11912
  {25,  3,   0}, // #11913
  {26,  4,   0}, // #11914
  {13,  3,   0}, // #11915
  {23,  3,   0}, // #11916
  {25,  3,   0}, // #11917
  {26,  3,   0}, // #11918
  { 3,  1,   0}, // #11919
  {13,  2,   0}, // #11920
  {14,  1,   0}, // #11921
  {15,  1,   0}, // #11922
  {16,  1,   0}, // #11923
  {19,  1,   0}, // #11924
  {23,  2,   0}, // #11925
  {24,  1,   0}, // #11926
  {25,  2,   0}, // #11927
  {26,  3,   0}, // #11928
  { 4,  1,   0}, // #11929
  { 8,  2,   0}, // #11930
  {13,  3,   0}, // #11931
  {15,  2,   0}, // #11932
  {17,  3,   0}, // #11933
  {18,  1,   0}, // #11934
  {19,  1,   0}, // #11935
  {21,  2,   0}, // #11936
  {23,  7,   0}, // #11937
  {24,  2,   0}, // #11938
  {25,  7,   0}, // #11939
  {26,  8,   0}, // #11940
  {13,  3,   0}, // #11941
  {19,  1,   0}, // #11942
  {23,  3,   0}, // #11943
  {25,  3,   0}, // #11944
  {26,  4,   0}, // #11945
  { 3,  1,   0}, // #11946
  {13,  1,   0}, // #11947
  {14,  1,   0}, // #11948
  {15,  1,   0}, // #11949
  {16,  1,   0}, // #11950
  {19,  2,   0}, // #11951
  {23,  2,   0}, // #11952
  {24,  1,   0}, // #11953
  {25,  3,   0}, // #11954
  {26,  5,   0}, // #11955
  { 3,  1,   0}, // #11956
  {13,  1,   0}, // #11957
  {14,  1,   0}, // #11958
  {15,  1,   0}, // #11959
  {16,  1,   0}, // #11960
  {19,  4,   0}, // #11961
  {23,  2,   0}, // #11962
  {24,  1,   0}, // #11963
  {25,  3,   0}, // #11964
  {26,  7,   0}, // #11965
  { 3,  1,   0}, // #11966
  {13,  1,   0}, // #11967
  {14,  1,   0}, // #11968
  {15,  1,   0}, // #11969
  {16,  1,   0}, // #11970
  {19,  8,   0}, // #11971
  {23,  2,   0}, // #11972
  {24,  1,   0}, // #11973
  {25,  3,   0}, // #11974
  {26, 11,   0}, // #11975
  { 3,  1,   0}, // #11976
  {13,  1,   0}, // #11977
  {14,  1,   0}, // #11978
  {15,  1,   0}, // #11979
  {16,  1,   0}, // #11980
  {19, 16,   0}, // #11981
  {23,  2,   0}, // #11982
  {24,  1,   0}, // #11983
  {25,  3,   0}, // #11984
  {26, 19,   0}, // #11985
  { 8,  5,   0}, // #11986
  {13,  5,   0}, // #11987
  {15,  5,   0}, // #11988
  {17,  5,   0}, // #11989
  {19,  1,   0}, // #11990
  {21,  5,   0}, // #11991
  {23, 14,   0}, // #11992
  {24,  5,   0}, // #11993
  {25, 14,   0}, // #11994
  {26, 15,   0}, // #11995
  { 8,  9,   0}, // #11996
  {13,  7,   0}, // #11997
  {15,  9,   0}, // #11998
  {17,  9,   0}, // #11999
  {19,  1,   0}, // #12000
  {21,  9,   0}, // #12001
  {23, 21,   0}, // #12002
  {24,  9,   0}, // #12003
  {25, 21,   0}, // #12004
  {26, 22,   0}, // #12005
  { 8, 17,   0}, // #12006
  {13, 11,   0}, // #12007
  {15, 17,   0}, // #12008
  {17, 17,   0}, // #12009
  {19,  1,   0}, // #12010
  {21, 17,   0}, // #12011
  {23, 35,   0}, // #12012
  {24, 17,   0}, // #12013
  {25, 35,   0}, // #12014
  {26, 36,   0}, // #12015
  {16,  2,   0}, // #12016
  {20,  1,   0}, // #12017
  {22,  1,   0}, // #12018
  {24,  2,   0}, // #12019
  {25,  2,   0}, // #12020
  {26,  4,   0}, // #12021
  { 3,  1,   0}, // #12022
  {11,  2,   0}, // #12023
  {12,  1,   0}, // #12024
  {13,  1,   0}, // #12025
  {14,  1,   0}, // #12026
  {19,  2,   0}, // #12027
  {20,  1,   0}, // #12028
  {22,  2,   0}, // #12029
  {23,  2,   0}, // #12030
  { 8,  1,   0}, // #12031
  {11,  2,   0}, // #12032
  {13,  1,   0}, // #12033
  {15,  1,   0}, // #12034
  {17,  1,   0}, // #12035
  {18,  1,   0}, // #12036
  {19,  3,   0}, // #12037
  {20,  1,   0}, // #12038
  {21,  1,   0}, // #12039
  {22,  3,   0}, // #12040
  {23,  4,   0}, // #12041
  { 8,  1,   0}, // #12042
  {11,  2,   0}, // #12043
  {13,  1,   0}, // #12044
  {15,  1,   0}, // #12045
  {18,  1,   0}, // #12046
  {19,  3,   0}, // #12047
  {20,  1,   0}, // #12048
  {22,  3,   0}, // #12049
  {23,  3,   0}, // #12050
  {22, 16,   0}, // #12051
  {23, 16,   0}, // #12052
  { 7,  1,   0}, // #12053
  { 9, 11,   0}, // #12054
  {12,  1,   0}, // #12055
  {14, 11,   0}, // #12056
  {16, 11,   0}, // #12057
  {17,  1,   0}, // #12058
  {18, 11,   0}, // #12059
  {20, 11,   0}, // #12060
  {21,  2,   0}, // #12061
  {22, 41,   0}, // #12062
  {23, 44,   0}, // #12063
  {11,  1,   0}, // #12064
  {22,  1,   0}, // #12065
  { 1,  1,   0}, // #12066
  { 4,  1,   0}, // #12067
  { 1,  2,   0}, // #12068
  { 4,  1,   0}, // #12069
  {11,  1,   0}, // #12070
  {15,  1,   0}, // #12071
  {18,  1,   0}, // #12072
  {20,  1,   0}, // #12073
  {21,  1,   0}, // #12074
  {22,  1,   0}, // #12075
  { 1,  1,   0}, // #12076
  {11,  1,   0}, // #12077
  {21,  1,   0}, // #12078
  { 1,  1,   0}, // #12079
  {11,  1,   0}, // #12080
  {16,  1,   0}, // #12081
  {22,  1,   0}, // #12082
  { 1,  1,   0}, // #12083
  { 4,  2,   0}, // #12084
  { 1,  1,   0}, // #12085
  { 4, 12,   0}, // #12086
  { 1,  1,   0}, // #12087
  { 4, 16,   0}, // #12088
  { 1,  1,   0}, // #12089
  {11,  2,   0}, // #12090
  {14,  1,   0}, // #12091
  {16,  1,   0}, // #12092
  {17,  1,   0}, // #12093
  {19,  1,   0}, // #12094
  {21,  1,   0}, // #12095
  {22,  1,   0}, // #12096
  { 1,  1,   0}, // #12097
  {11,  1,   0}, // #12098
  {12,  1,   0}, // #12099
  {16,  1,   0}, // #12100
  {17,  1,   0}, // #12101
  {18,  1,   0}, // #12102
  {22,  1,   0}, // #12103
  { 1,  1,   0}, // #12104
  {11,  1,   0}, // #12105
  {15,  1,   0}, // #12106
  {18,  1,   0}, // #12107
  {20,  1,   0}, // #12108
  {21,  1,   0}, // #12109
  {22,  1,   0}, // #12110
  { 1,  1,   0}, // #12111
  {11,  2,   0}, // #12112
  {15,  2,   0}, // #12113
  {18,  2,   0}, // #12114
  {20,  2,   0}, // #12115
  {21,  2,   0}, // #12116
  {22,  2,   0}, // #12117
  { 1,  1,   0}, // #12118
  { 4,  1,   0}, // #12119
  { 7,  1,   0}, // #12120
  {10, 17,   0}, // #12121
  { 1,  1,   0}, // #12122
  { 4,  1,   0}, // #12123
  { 7,  1,   0}, // #12124
  {10, 25,   0}, // #12125
  { 1,  1,   0}, // #12126
  { 4,  1,   0}, // #12127
  { 7,  1,   0}, // #12128
  {10, 41,   0}, // #12129
  { 1,  1,   0}, // #12130
  { 4,  1,   0}, // #12131
  { 7,  1,   0}, // #12132
  {10, 15,   0}, // #12133
  { 1,  1,   0}, // #12134
  {11,  5,   0}, // #12135
  {15,  5,   0}, // #12136
  {18,  5,   0}, // #12137
  {20,  5,   0}, // #12138
  {21,  5,   0}, // #12139
  {22,  5,   0}, // #12140
  { 1,  1,   0}, // #12141
  {11,  3,   0}, // #12142
  {15,  3,   0}, // #12143
  {18,  3,   0}, // #12144
  {20,  3,   0}, // #12145
  {21,  3,   0}, // #12146
  {22,  3,   0}, // #12147
  { 1,  1,   0}, // #12148
  {11,  5,   0}, // #12149
  {14,  3,   0}, // #12150
  {17,  3,   0}, // #12151
  {19,  5,   0}, // #12152
  {21,  3,   0}, // #12153
  {11,  3,   0}, // #12154
  {14,  2,   0}, // #12155
  {17,  2,   0}, // #12156
  {19,  3,   0}, // #12157
  {21,  2,   0}, // #12158
  { 1,  1,   0}, // #12159
  {11,  1,   0}, // #12160
  {22,  1,   0}, // #12161
  { 1,  1,   0}, // #12162
  { 4,  1,   0}, // #12163
  { 6,  1,   0}, // #12164
  {23,  1,   0}, // #12165
  { 1,  1,   0}, // #12166
  {11,  1,   0}, // #12167
  {19,  1,   0}, // #12168
  { 1,  1,   0}, // #12169
  {11,  1,   0}, // #12170
  {20,  1,   0}, // #12171
  {22,  1,   0}, // #12172
  {11,  1,   0}, // #12173
  {14,  1,   0}, // #12174
  {17,  1,   0}, // #12175
  {19,  1,   0}, // #12176
  {21,  1,   0}, // #12177
  { 1,  1,   0}, // #12178
  {11,  1,   0}, // #12179
  {14,  1,   0}, // #12180
  {17,  1,   0}, // #12181
  {19,  1,   0}, // #12182
  {21,  1,   0}, // #12183
  { 1,  1,   0}, // #12184
  { 4,  1,   0}, // #12185
  { 6,  1,   0}, // #12186
  {23,  2,   0}, // #12187
  { 1,  1,   0}, // #12188
  {11,  2,   0}, // #12189
  {12,  2,   0}, // #12190
  {16,  2,   0}, // #12191
  {17,  2,   0}, // #12192
  {18,  2,   0}, // #12193
  {22,  2,   0}, // #12194
  { 1,  1,   0}, // #12195
  {11,  2,   0}, // #12196
  {19,  2,   0}, // #12197
  { 1,  1,   0}, // #12198
  {11,  8,   0}, // #12199
  {15,  8,   0}, // #12200
  {18,  8,   0}, // #12201
  {20,  8,   0}, // #12202
  {21,  8,   0}, // #12203
  {22,  8,   0}, // #12204
  {11, 20,   0}, // #12205
  {15, 20,   0}, // #12206
  {18, 20,   0}, // #12207
  {20, 20,   0}, // #12208
  {21, 20,   0}, // #12209
  {22, 20,   0}, // #12210
  { 1,  1,   0}, // #12211
  {11,  2,   0}, // #12212
  {21,  2,   0}, // #12213
  { 1,  1,   0}, // #12214
  {11,  2,   0}, // #12215
  {16,  2,   0}, // #12216
  {22,  2,   0}, // #12217
  { 1,  1,   0}, // #12218
  {11,  9,   0}, // #12219
  {15,  9,   0}, // #12220
  {18,  9,   0}, // #12221
  {20,  9,   0}, // #12222
  {21,  9,   0}, // #12223
  {22,  9,   0}, // #12224
  { 1,  1,   0}, // #12225
  {11,  6,   0}, // #12226
  {15,  6,   0}, // #12227
  {18,  6,   0}, // #12228
  {20,  6,   0}, // #12229
  {21,  6,   0}, // #12230
  {22,  6,   0}, // #12231
  { 1,  1,   0}, // #12232
  {11,  2,   0}, // #12233
  {22,  2,   0}, // #12234
  { 1,  1,   0}, // #12235
  {11,  3,   0}, // #12236
  {16,  3,   0}, // #12237
  {22,  3,   0}, // #12238
  { 1,  1,   0}, // #12239
  {11,  4,   0}, // #12240
  {19,  4,   0}, // #12241
  {11,  2,   0}, // #12242
  {14,  2,   0}, // #12243
  {17,  2,   0}, // #12244
  {19,  2,   0}, // #12245
  {21,  2,   0}, // #12246
  { 1,  1,   0}, // #12247
  {11,  4,   0}, // #12248
  {12,  4,   0}, // #12249
  {16,  4,   0}, // #12250
  {17,  4,   0}, // #12251
  {18,  4,   0}, // #12252
  {22,  4,   0}, // #12253
  { 1,  1,   0}, // #12254
  {11,  2,   0}, // #12255
  {14,  2,   0}, // #12256
  {17,  2,   0}, // #12257
  {19,  2,   0}, // #12258
  {21,  2,   0}, // #12259
  { 1,  1,   0}, // #12260
  {11,  2,   0}, // #12261
  {13,  2,   0}, // #12262
  {16,  2,   0}, // #12263
  {19,  2,   0}, // #12264
  {20,  2,   0}, // #12265
  {22,  2,   0}, // #12266
  { 1,  1,   0}, // #12267
  {11,  4,   0}, // #12268
  {13,  4,   0}, // #12269
  {16,  4,   0}, // #12270
  {19,  4,   0}, // #12271
  {20,  4,   0}, // #12272
  {22,  4,   0}, // #12273
  { 1,  1,   0}, // #12274
  {11, 16,   0}, // #12275
  {15, 16,   0}, // #12276
  {18, 16,   0}, // #12277
  {20, 16,   0}, // #12278
  {21, 16,   0}, // #12279
  {22, 16,   0}, // #12280
  { 1,  1,   0}, // #12281
  {11, 10,   0}, // #12282
  {15, 10,   0}, // #12283
  {18, 10,   0}, // #12284
  {20, 10,   0}, // #12285
  {21, 10,   0}, // #12286
  {22, 10,   0}, // #12287
  {11,  2,   0}, // #12288
  {15,  1,   0}, // #12289
  {18,  1,   0}, // #12290
  {19,  1,   0}, // #12291
  {20,  1,   0}, // #12292
  {21,  1,   0}, // #12293
  {22,  1,   0}, // #12294
  { 1,  1,   0}, // #12295
  {11,  2,   0}, // #12296
  {15,  1,   0}, // #12297
  {18,  1,   0}, // #12298
  {19,  1,   0}, // #12299
  {20,  1,   0}, // #12300
  {21,  1,   0}, // #12301
  {22,  1,   0}, // #12302
  { 1,  1,   0}, // #12303
  {11,  1,   0}, // #12304
  {17,  1,   0}, // #12305
  { 1,  5,   0}, // #12306
  {11,  3,   0}, // #12307
  {14,  2,   0}, // #12308
  {17,  2,   0}, // #12309
  {19,  3,   0}, // #12310
  {21,  2,   0}, // #12311
  { 1,  1,   0}, // #12312
  {11,  1,   0}, // #12313
  {18,  1,   0}, // #12314
  {22,  1,   0}, // #12315
  { 1,  1,   0}, // #12316
  {11,  3,   0}, // #12317
  {18,  3,   0}, // #12318
  {22,  3,   0}, // #12319
  { 1,  1,   0}, // #12320
  {11,  2,   0}, // #12321
  {18,  2,   0}, // #12322
  {22,  2,   0}, // #12323
  { 1,  1,   0}, // #12324
  { 4,  1,   0}, // #12325
  { 9,  1,   0}, // #12326
  {11,  2,   0}, // #12327
  {15,  1,   0}, // #12328
  {18,  1,   0}, // #12329
  {20,  1,   0}, // #12330
  {21,  1,   0}, // #12331
  {22,  2,   0}, // #12332
  {11,  2,   0}, // #12333
  {14,  1,   0}, // #12334
  {15,  1,   0}, // #12335
  {17,  1,   0}, // #12336
  {18,  1,   0}, // #12337
  {19,  1,   0}, // #12338
  {20,  1,   0}, // #12339
  {21,  2,   0}, // #12340
  {22,  1,   0}, // #12341
  { 1,  1,   0}, // #12342
  {11,  2,   0}, // #12343
  {14,  1,   0}, // #12344
  {15,  1,   0}, // #12345
  {17,  1,   0}, // #12346
  {18,  1,   0}, // #12347
  {19,  1,   0}, // #12348
  {20,  1,   0}, // #12349
  {21,  2,   0}, // #12350
  {22,  1,   0}, // #12351
  {11,  2,   0}, // #12352
  {14,  1,   0}, // #12353
  {17,  1,   0}, // #12354
  {19,  2,   0}, // #12355
  {21,  1,   0}, // #12356
  {11,  2,   0}, // #12357
  {13,  1,   0}, // #12358
  {16,  1,   0}, // #12359
  {18,  1,   0}, // #12360
  {19,  1,   0}, // #12361
  {20,  1,   0}, // #12362
  {22,  2,   0}, // #12363
  {11,  1,   0}, // #12364
  {13,  1,   0}, // #12365
  {16,  1,   0}, // #12366
  {19,  1,   0}, // #12367
  {20,  1,   0}, // #12368
  {22,  1,   0}, // #12369
  { 1,  1,   0}, // #12370
  {11,  1,   0}, // #12371
  {13,  1,   0}, // #12372
  {16,  1,   0}, // #12373
  {19,  1,   0}, // #12374
  {20,  1,   0}, // #12375
  {22,  1,   0}, // #12376
  {12,  1,   0}, // #12377
  {23,  1,   0}, // #12378
  { 1,  2,   0}, // #12379
  { 5,  1,   0}, // #12380
  {12,  1,   0}, // #12381
  {16,  1,   0}, // #12382
  {19,  1,   0}, // #12383
  {21,  1,   0}, // #12384
  {22,  1,   0}, // #12385
  {23,  1,   0}, // #12386
  { 1,  1,   0}, // #12387
  {12,  1,   0}, // #12388
  {22,  1,   0}, // #12389
  { 1,  1,   0}, // #12390
  {12,  1,   0}, // #12391
  {17,  1,   0}, // #12392
  {23,  1,   0}, // #12393
  { 1,  1,   0}, // #12394
  { 5,  2,   0}, // #12395
  { 1,  1,   0}, // #12396
  { 5, 12,   0}, // #12397
  { 1,  1,   0}, // #12398
  { 5, 16,   0}, // #12399
  { 1,  1,   0}, // #12400
  {12,  2,   0}, // #12401
  {15,  1,   0}, // #12402
  {17,  1,   0}, // #12403
  {18,  1,   0}, // #12404
  {20,  1,   0}, // #12405
  {22,  1,   0}, // #12406
  {23,  1,   0}, // #12407
  { 1,  1,   0}, // #12408
  {12,  1,   0}, // #12409
  {13,  1,   0}, // #12410
  {17,  1,   0}, // #12411
  {18,  1,   0}, // #12412
  {19,  1,   0}, // #12413
  {23,  1,   0}, // #12414
  { 1,  1,   0}, // #12415
  {12,  1,   0}, // #12416
  {16,  1,   0}, // #12417
  {19,  1,   0}, // #12418
  {21,  1,   0}, // #12419
  {22,  1,   0}, // #12420
  {23,  1,   0}, // #12421
  { 1,  1,   0}, // #12422
  {12,  2,   0}, // #12423
  {16,  2,   0}, // #12424
  {19,  2,   0}, // #12425
  {21,  2,   0}, // #12426
  {22,  2,   0}, // #12427
  {23,  2,   0}, // #12428
  { 1,  1,   0}, // #12429
  { 5,  1,   0}, // #12430
  { 8,  1,   0}, // #12431
  {11, 17,   0}, // #12432
  { 1,  1,   0}, // #12433
  { 5,  1,   0}, // #12434
  { 8,  1,   0}, // #12435
  {11, 25,   0}, // #12436
  { 1,  1,   0}, // #12437
  { 5,  1,   0}, // #12438
  { 8,  1,   0}, // #12439
  {11, 41,   0}, // #12440
  { 1,  1,   0}, // #12441
  { 5,  1,   0}, // #12442
  { 8,  1,   0}, // #12443
  {11, 15,   0}, // #12444
  { 1,  1,   0}, // #12445
  {12,  6,   0}, // #12446
  {16,  6,   0}, // #12447
  {19,  6,   0}, // #12448
  {21,  6,   0}, // #12449
  {22,  6,   0}, // #12450
  {23,  6,   0}, // #12451
  { 1,  1,   0}, // #12452
  {12,  5,   0}, // #12453
  {16,  5,   0}, // #12454
  {19,  5,   0}, // #12455
  {21,  5,   0}, // #12456
  {22,  5,   0}, // #12457
  {23,  5,   0}, // #12458
  { 1,  1,   0}, // #12459
  {12,  5,   0}, // #12460
  {15,  3,   0}, // #12461
  {18,  3,   0}, // #12462
  {20,  5,   0}, // #12463
  {22,  3,   0}, // #12464
  {12,  3,   0}, // #12465
  {15,  2,   0}, // #12466
  {18,  2,   0}, // #12467
  {20,  3,   0}, // #12468
  {22,  2,   0}, // #12469
  { 1,  1,   0}, // #12470
  {12,  1,   0}, // #12471
  {23,  1,   0}, // #12472
  { 1,  1,   0}, // #12473
  { 5,  1,   0}, // #12474
  { 7,  1,   0}, // #12475
  {24,  1,   0}, // #12476
  { 1,  1,   0}, // #12477
  {12,  1,   0}, // #12478
  {20,  1,   0}, // #12479
  { 1,  1,   0}, // #12480
  {12,  1,   0}, // #12481
  {21,  1,   0}, // #12482
  {23,  1,   0}, // #12483
  {12,  1,   0}, // #12484
  {15,  1,   0}, // #12485
  {18,  1,   0}, // #12486
  {20,  1,   0}, // #12487
  {22,  1,   0}, // #12488
  { 1,  1,   0}, // #12489
  {12,  1,   0}, // #12490
  {15,  1,   0}, // #12491
  {18,  1,   0}, // #12492
  {20,  1,   0}, // #12493
  {22,  1,   0}, // #12494
  { 1,  1,   0}, // #12495
  { 5,  1,   0}, // #12496
  { 7,  1,   0}, // #12497
  {24,  2,   0}, // #12498
  { 1,  1,   0}, // #12499
  {12,  2,   0}, // #12500
  {13,  2,   0}, // #12501
  {17,  2,   0}, // #12502
  {18,  2,   0}, // #12503
  {19,  2,   0}, // #12504
  {23,  2,   0}, // #12505
  { 1,  1,   0}, // #12506
  {12,  2,   0}, // #12507
  {20,  2,   0}, // #12508
  { 1,  1,   0}, // #12509
  {12, 10,   0}, // #12510
  {16, 10,   0}, // #12511
  {19, 10,   0}, // #12512
  {21, 10,   0}, // #12513
  {22, 10,   0}, // #12514
  {23, 10,   0}, // #12515
  { 1,  1,   0}, // #12516
  {12,  7,   0}, // #12517
  {16,  7,   0}, // #12518
  {19,  7,   0}, // #12519
  {21,  7,   0}, // #12520
  {22,  7,   0}, // #12521
  {23,  7,   0}, // #12522
  {12, 20,   0}, // #12523
  {16, 20,   0}, // #12524
  {19, 20,   0}, // #12525
  {21, 20,   0}, // #12526
  {22, 20,   0}, // #12527
  {23, 20,   0}, // #12528
  { 1,  1,   0}, // #12529
  {12,  2,   0}, // #12530
  {17,  2,   0}, // #12531
  {23,  2,   0}, // #12532
  {12,  2,   0}, // #12533
  {15,  2,   0}, // #12534
  {18,  2,   0}, // #12535
  {20,  2,   0}, // #12536
  {22,  2,   0}, // #12537
  { 1,  1,   0}, // #12538
  {12,  2,   0}, // #12539
  {14,  2,   0}, // #12540
  {17,  2,   0}, // #12541
  {20,  2,   0}, // #12542
  {21,  2,   0}, // #12543
  {23,  2,   0}, // #12544
  {12,  2,   0}, // #12545
  {16,  1,   0}, // #12546
  {19,  1,   0}, // #12547
  {20,  1,   0}, // #12548
  {21,  1,   0}, // #12549
  {22,  1,   0}, // #12550
  {23,  1,   0}, // #12551
  { 1,  1,   0}, // #12552
  {12,  2,   0}, // #12553
  {16,  1,   0}, // #12554
  {19,  1,   0}, // #12555
  {20,  1,   0}, // #12556
  {21,  1,   0}, // #12557
  {22,  1,   0}, // #12558
  {23,  1,   0}, // #12559
  { 1,  1,   0}, // #12560
  {12,  1,   0}, // #12561
  {18,  1,   0}, // #12562
  { 1,  5,   0}, // #12563
  {12,  3,   0}, // #12564
  {15,  2,   0}, // #12565
  {18,  2,   0}, // #12566
  {20,  3,   0}, // #12567
  {22,  2,   0}, // #12568
  { 1,  1,   0}, // #12569
  {12,  1,   0}, // #12570
  {19,  1,   0}, // #12571
  {23,  1,   0}, // #12572
  { 1,  1,   0}, // #12573
  {12,  3,   0}, // #12574
  {19,  3,   0}, // #12575
  {23,  3,   0}, // #12576
  { 1,  1,   0}, // #12577
  {12,  3,   0}, // #12578
  {17,  3,   0}, // #12579
  {23,  3,   0}, // #12580
  { 1,  1,   0}, // #12581
  { 5,  1,   0}, // #12582
  {10,  1,   0}, // #12583
  {12,  2,   0}, // #12584
  {16,  1,   0}, // #12585
  {19,  1,   0}, // #12586
  {21,  1,   0}, // #12587
  {22,  1,   0}, // #12588
  {23,  2,   0}, // #12589
  {12,  2,   0}, // #12590
  {15,  1,   0}, // #12591
  {16,  1,   0}, // #12592
  {18,  1,   0}, // #12593
  {19,  1,   0}, // #12594
  {20,  1,   0}, // #12595
  {21,  1,   0}, // #12596
  {22,  2,   0}, // #12597
  {23,  1,   0}, // #12598
  { 1,  1,   0}, // #12599
  {12,  2,   0}, // #12600
  {15,  1,   0}, // #12601
  {16,  1,   0}, // #12602
  {18,  1,   0}, // #12603
  {19,  1,   0}, // #12604
  {20,  1,   0}, // #12605
  {21,  1,   0}, // #12606
  {22,  2,   0}, // #12607
  {23,  1,   0}, // #12608
  {12,  2,   0}, // #12609
  {15,  1,   0}, // #12610
  {18,  1,   0}, // #12611
  {20,  2,   0}, // #12612
  {22,  1,   0}, // #12613
  {12,  2,   0}, // #12614
  {14,  1,   0}, // #12615
  {17,  1,   0}, // #12616
  {19,  1,   0}, // #12617
  {20,  1,   0}, // #12618
  {21,  1,   0}, // #12619
  {23,  2,   0}, // #12620
  {12,  1,   0}, // #12621
  {14,  1,   0}, // #12622
  {17,  1,   0}, // #12623
  {20,  1,   0}, // #12624
  {21,  1,   0}, // #12625
  {23,  1,   0}, // #12626
  { 1,  1,   0}, // #12627
  {12,  1,   0}, // #12628
  {14,  1,   0}, // #12629
  {17,  1,   0}, // #12630
  {20,  1,   0}, // #12631
  {21,  1,   0}, // #12632
  {23,  1,   0}, // #12633
  {11,  1,   0}, // #12634
  {36,  1,   0}, // #12635
  {11,  0,   0}, // #12636
  {36,  0,   0}, // #12637
  {14,  1,   0}, // #12638
  {25,  1,   0}, // #12639
  {28,  1,   0}, // #12640
  {31,  1,   0}, // #12641
  {32,  1,   0}, // #12642
  {13,  1,   0}, // #12643
  {36,  1,   0}, // #12644
  {11, 12,   0}, // #12645
  {36, 12,   0}, // #12646
  { 4,  1,   0}, // #12647
  {13,  1,   0}, // #12648
  {36,  2,   0}, // #12649
  {37,  1,   0}, // #12650
  {38,  1,   0}, // #12651
  {11,  4,   0}, // #12652
  {36,  4,   0}, // #12653
  {11, 100,   0}, // #12654
  {36, 100,   0}, // #12655
  { 4,  1,   0}, // #12656
  {36,  1,   0}, // #12657
  { 4,  1,   0}, // #12658
  {36,  1,   0}, // #12659
  {37,  1,   0}, // #12660
  {39,  1,   0}, // #12661
  {10,  3,   0}, // #12662
  {11,  3,   0}, // #12663
  {36,  3,   0}, // #12664
  {19,  1,   0}, // #12665
  {27,  1,   0}, // #12666
  {37,  1,   0}, // #12667
  {39,  1,   0}, // #12668
  {14,  1,   0}, // #12669
  {19,  1,   0}, // #12670
  {37,  1,   0}, // #12671
  {38,  1,   0}, // #12672
  { 4,  2,   0}, // #12673
  {11,  1,   0}, // #12674
  {36,  3,   0}, // #12675
  {37,  2,   0}, // #12676
  {38,  1,   0}, // #12677
  {39,  1,   0}, // #12678
  {14,  2,   0}, // #12679
  {20,  2,   0}, // #12680
  {21,  2,   0}, // #12681
  {25,  2,   0}, // #12682
  {26,  2,   0}, // #12683
  {28,  2,   0}, // #12684
  {29,  2,   0}, // #12685
  {31,  2,   0}, // #12686
  {32,  2,   0}, // #12687
  { 4,  2,   0}, // #12688
  {11,  4,   0}, // #12689
  {36,  6,   0}, // #12690
  {37,  2,   0}, // #12691
  {38,  1,   0}, // #12692
  {39,  1,   0}, // #12693
  { 4,  1,   0}, // #12694
  {11,  4,   0}, // #12695
  {36,  5,   0}, // #12696
  {37,  1,   0}, // #12697
  {38,  1,   0}, // #12698
  { 4,  1,   0}, // #12699
  {11,  1,   0}, // #12700
  {36,  2,   0}, // #12701
  {37,  1,   0}, // #12702
  {38,  1,   0}, // #12703
  {14,  2,   0}, // #12704
  {19,  1,   0}, // #12705
  {22,  1,   0}, // #12706
  {23,  1,   0}, // #12707
  {25,  1,   0}, // #12708
  {28,  1,   0}, // #12709
  {31,  1,   0}, // #12710
  {32,  1,   0}, // #12711
  {37,  1,   0}, // #12712
  {38,  1,   0}, // #12713
  {14,  1,   0}, // #12714
  {22,  1,   0}, // #12715
  {23,  1,   0}, // #12716
  {25,  1,   0}, // #12717
  {28,  1,   0}, // #12718
  {31,  1,   0}, // #12719
  {32,  1,   0}, // #12720
  {14,  2,   0}, // #12721
  {19,  1,   0}, // #12722
  {20,  1,   0}, // #12723
  {21,  1,   0}, // #12724
  {25,  1,   0}, // #12725
  {26,  1,   0}, // #12726
  {28,  1,   0}, // #12727
  {29,  1,   0}, // #12728
  {31,  1,   0}, // #12729
  {32,  1,   0}, // #12730
  {37,  1,   0}, // #12731
  {38,  1,   0}, // #12732
  {14,  1,   0}, // #12733
  {20,  1,   0}, // #12734
  {21,  1,   0}, // #12735
  {25,  1,   0}, // #12736
  {26,  1,   0}, // #12737
  {28,  1,   0}, // #12738
  {29,  1,   0}, // #12739
  {31,  1,   0}, // #12740
  {32,  1,   0}, // #12741
  {14,  2,   0}, // #12742
  {19,  1,   0}, // #12743
  {25,  1,   0}, // #12744
  {28,  1,   0}, // #12745
  {31,  1,   0}, // #12746
  {32,  1,   0}, // #12747
  {37,  1,   0}, // #12748
  {38,  1,   0}, // #12749
  { 4,  1,   0}, // #12750
  {10,  1,   0}, // #12751
  {11,  1,   0}, // #12752
  {36,  2,   0}, // #12753
  {37,  1,   0}, // #12754
  {38,  1,   0}, // #12755
  {10,  1,   0}, // #12756
  {11,  1,   0}, // #12757
  {36,  1,   0}, // #12758
  { 4,  1,   0}, // #12759
  {11,  2,   0}, // #12760
  {36,  3,   0}, // #12761
  {37,  1,   0}, // #12762
  {38,  1,   0}, // #12763
  {11,  2,   0}, // #12764
  {36,  2,   0}, // #12765
  { 4,  1,   0}, // #12766
  { 6,  3,   0}, // #12767
  {10,  3,   0}, // #12768
  {11,  3,   0}, // #12769
  {36,  4,   0}, // #12770
  {37,  1,   0}, // #12771
  {38,  1,   0}, // #12772
  { 6,  3,   0}, // #12773
  {10,  3,   0}, // #12774
  {11,  3,   0}, // #12775
  {36,  3,   0}, // #12776
  { 4,  1,   0}, // #12777
  { 6,  4,   0}, // #12778
  {10,  4,   0}, // #12779
  {11,  4,   0}, // #12780
  {36,  5,   0}, // #12781
  {37,  1,   0}, // #12782
  {38,  1,   0}, // #12783
  { 6,  4,   0}, // #12784
  {10,  4,   0}, // #12785
  {11,  4,   0}, // #12786
  {36,  4,   0}, // #12787
  { 4,  2,   0}, // #12788
  {10,  1,   0}, // #12789
  {11,  1,   0}, // #12790
  {36,  3,   0}, // #12791
  {37,  2,   0}, // #12792
  {38,  1,   0}, // #12793
  {39,  1,   0}, // #12794
  {10,  2,   0}, // #12795
  {11,  2,   0}, // #12796
  {36,  2,   0}, // #12797
  { 9,  1,   0}, // #12798
  {11,  1,   0}, // #12799
  {36,  1,   0}, // #12800
  { 4,  1,   0}, // #12801
  { 9,  1,   0}, // #12802
  {11,  1,   0}, // #12803
  {36,  2,   0}, // #12804
  {37,  1,   0}, // #12805
  {38,  1,   0}, // #12806
  { 4,  1,   0}, // #12807
  {36,  1,   0}, // #12808
  {37,  1,   0}, // #12809
  {38,  1,   0}, // #12810
  {11, 28,   0}, // #12811
  {36, 28,   0}, // #12812
  {11,  8,   0}, // #12813
  {36,  8,   0}, // #12814
  {14,  3,   0}, // #12815
  {19,  1,   0}, // #12816
  {20,  2,   0}, // #12817
  {21,  2,   0}, // #12818
  {25,  2,   0}, // #12819
  {26,  2,   0}, // #12820
  {28,  2,   0}, // #12821
  {29,  2,   0}, // #12822
  {31,  2,   0}, // #12823
  {32,  2,   0}, // #12824
  {37,  1,   0}, // #12825
  {38,  1,   0}, // #12826
  { 4,  1,   0}, // #12827
  { 6,  1,   0}, // #12828
  {10,  1,   0}, // #12829
  {11,  1,   0}, // #12830
  {36,  2,   0}, // #12831
  {37,  1,   0}, // #12832
  {38,  1,   0}, // #12833
  { 6,  1,   0}, // #12834
  {10,  1,   0}, // #12835
  {11,  1,   0}, // #12836
  {36,  1,   0}, // #12837
  {14,  3,   0}, // #12838
  {19,  1,   0}, // #12839
  {22,  2,   0}, // #12840
  {23,  2,   0}, // #12841
  {25,  2,   0}, // #12842
  {28,  2,   0}, // #12843
  {31,  2,   0}, // #12844
  {32,  2,   0}, // #12845
  {37,  1,   0}, // #12846
  {38,  1,   0}, // #12847
  {14,  2,   0}, // #12848
  {22,  2,   0}, // #12849
  {23,  2,   0}, // #12850
  {25,  2,   0}, // #12851
  {28,  2,   0}, // #12852
  {31,  2,   0}, // #12853
  {32,  2,   0}, // #12854
  { 4,  1,   0}, // #12855
  { 5, 11,   0}, // #12856
  { 9, 11,   0}, // #12857
  {11, 11,   0}, // #12858
  {13, 11,   0}, // #12859
  {36, 12,   0}, // #12860
  {37,  1,   0}, // #12861
  {38,  1,   0}, // #12862
  { 5, 11,   0}, // #12863
  { 9, 11,   0}, // #12864
  {11, 11,   0}, // #12865
  {13, 11,   0}, // #12866
  {36, 11,   0}, // #12867
  { 4,  1,   0}, // #12868
  { 5, 13,   0}, // #12869
  { 9, 13,   0}, // #12870
  {11, 13,   0}, // #12871
  {13, 13,   0}, // #12872
  {36, 14,   0}, // #12873
  {37,  1,   0}, // #12874
  {38,  1,   0}, // #12875
  { 5, 13,   0}, // #12876
  { 9, 13,   0}, // #12877
  {11, 13,   0}, // #12878
  {13, 13,   0}, // #12879
  {36, 13,   0}, // #12880
  { 4,  1,   0}, // #12881
  { 5, 17,   0}, // #12882
  { 9, 17,   0}, // #12883
  {11, 17,   0}, // #12884
  {13, 17,   0}, // #12885
  {36, 18,   0}, // #12886
  {37,  1,   0}, // #12887
  {38,  1,   0}, // #12888
  { 5, 17,   0}, // #12889
  { 9, 17,   0}, // #12890
  {11, 17,   0}, // #12891
  {13, 17,   0}, // #12892
  {36, 17,   0}, // #12893
  { 4,  1,   0}, // #12894
  { 5, 10,   0}, // #12895
  { 9, 10,   0}, // #12896
  {11, 10,   0}, // #12897
  {13, 10,   0}, // #12898
  {36, 11,   0}, // #12899
  {37,  1,   0}, // #12900
  {38,  1,   0}, // #12901
  { 5, 10,   0}, // #12902
  { 9, 10,   0}, // #12903
  {11, 10,   0}, // #12904
  {13, 10,   0}, // #12905
  {36, 10,   0}, // #12906
  {14,  6,   0}, // #12907
  {16,  5,   0}, // #12908
  {19,  1,   0}, // #12909
  {20,  5,   0}, // #12910
  {21,  5,   0}, // #12911
  {24,  5,   0}, // #12912
  {25,  5,   0}, // #12913
  {26,  5,   0}, // #12914
  {28,  5,   0}, // #12915
  {29,  5,   0}, // #12916
  {30,  5,   0}, // #12917
  {31,  5,   0}, // #12918
  {32,  5,   0}, // #12919
  {34,  5,   0}, // #12920
  {35,  5,   0}, // #12921
  {37,  1,   0}, // #12922
  {38,  1,   0}, // #12923
  {14,  5,   0}, // #12924
  {16,  5,   0}, // #12925
  {20,  5,   0}, // #12926
  {21,  5,   0}, // #12927
  {24,  5,   0}, // #12928
  {25,  5,   0}, // #12929
  {26,  5,   0}, // #12930
  {28,  5,   0}, // #12931
  {29,  5,   0}, // #12932
  {30,  5,   0}, // #12933
  {31,  5,   0}, // #12934
  {32,  5,   0}, // #12935
  {34,  5,   0}, // #12936
  {35,  5,   0}, // #12937
  {14,  4,   0}, // #12938
  {16,  3,   0}, // #12939
  {19,  1,   0}, // #12940
  {20,  3,   0}, // #12941
  {21,  3,   0}, // #12942
  {24,  3,   0}, // #12943
  {25,  3,   0}, // #12944
  {26,  3,   0}, // #12945
  {28,  3,   0}, // #12946
  {29,  3,   0}, // #12947
  {30,  3,   0}, // #12948
  {31,  3,   0}, // #12949
  {32,  3,   0}, // #12950
  {34,  3,   0}, // #12951
  {35,  3,   0}, // #12952
  {37,  1,   0}, // #12953
  {38,  1,   0}, // #12954
  {14,  3,   0}, // #12955
  {16,  3,   0}, // #12956
  {20,  3,   0}, // #12957
  {21,  3,   0}, // #12958
  {24,  3,   0}, // #12959
  {25,  3,   0}, // #12960
  {26,  3,   0}, // #12961
  {28,  3,   0}, // #12962
  {29,  3,   0}, // #12963
  {30,  3,   0}, // #12964
  {31,  3,   0}, // #12965
  {32,  3,   0}, // #12966
  {34,  3,   0}, // #12967
  {35,  3,   0}, // #12968
  {14,  7,   0}, // #12969
  {19,  1,   0}, // #12970
  {20,  6,   0}, // #12971
  {21,  6,   0}, // #12972
  {25,  6,   0}, // #12973
  {26,  6,   0}, // #12974
  {28,  6,   0}, // #12975
  {29,  6,   0}, // #12976
  {31,  6,   0}, // #12977
  {32,  6,   0}, // #12978
  {37,  1,   0}, // #12979
  {38,  1,   0}, // #12980
  {14,  6,   0}, // #12981
  {20,  6,   0}, // #12982
  {21,  6,   0}, // #12983
  {25,  6,   0}, // #12984
  {26,  6,   0}, // #12985
  {28,  6,   0}, // #12986
  {29,  6,   0}, // #12987
  {31,  6,   0}, // #12988
  {32,  6,   0}, // #12989
  {14,  9,   0}, // #12990
  {19,  1,   0}, // #12991
  {20,  8,   0}, // #12992
  {21,  8,   0}, // #12993
  {25,  8,   0}, // #12994
  {26,  8,   0}, // #12995
  {28,  8,   0}, // #12996
  {29,  8,   0}, // #12997
  {31,  8,   0}, // #12998
  {32,  8,   0}, // #12999
  {37,  1,   0}, // #13000
  {38,  1,   0}, // #13001
  {14,  8,   0}, // #13002
  {20,  8,   0}, // #13003
  {21,  8,   0}, // #13004
  {25,  8,   0}, // #13005
  {26,  8,   0}, // #13006
  {28,  8,   0}, // #13007
  {29,  8,   0}, // #13008
  {31,  8,   0}, // #13009
  {32,  8,   0}, // #13010
  { 4,  1,   0}, // #13011
  {36,  1,   0}, // #13012
  {37,  2,   0}, // #13013
  {39,  2,   0}, // #13014
  {14,  2,   0}, // #13015
  {16,  1,   0}, // #13016
  {19,  1,   0}, // #13017
  {20,  1,   0}, // #13018
  {21,  1,   0}, // #13019
  {24,  1,   0}, // #13020
  {25,  1,   0}, // #13021
  {26,  1,   0}, // #13022
  {28,  1,   0}, // #13023
  {29,  1,   0}, // #13024
  {30,  1,   0}, // #13025
  {31,  1,   0}, // #13026
  {32,  1,   0}, // #13027
  {34,  1,   0}, // #13028
  {35,  1,   0}, // #13029
  {37,  1,   0}, // #13030
  {38,  1,   0}, // #13031
  {14,  2,   0}, // #13032
  {19,  1,   0}, // #13033
  {25,  1,   0}, // #13034
  {28,  1,   0}, // #13035
  {31,  1,   0}, // #13036
  {32,  1,   0}, // #13037
  {33,  1,   0}, // #13038
  {37,  1,   0}, // #13039
  {38,  1,   0}, // #13040
  {14,  1,   0}, // #13041
  {25,  1,   0}, // #13042
  {28,  1,   0}, // #13043
  {31,  1,   0}, // #13044
  {32,  1,   0}, // #13045
  {33,  1,   0}, // #13046
  {14,  3,   0}, // #13047
  {17,  2,   0}, // #13048
  {19,  1,   0}, // #13049
  {22,  2,   0}, // #13050
  {23,  2,   0}, // #13051
  {24,  2,   0}, // #13052
  {25,  2,   0}, // #13053
  {28,  2,   0}, // #13054
  {30,  2,   0}, // #13055
  {31,  2,   0}, // #13056
  {32,  2,   0}, // #13057
  {34,  2,   0}, // #13058
  {35,  2,   0}, // #13059
  {37,  1,   0}, // #13060
  {38,  1,   0}, // #13061
  {14,  2,   0}, // #13062
  {17,  2,   0}, // #13063
  {22,  2,   0}, // #13064
  {23,  2,   0}, // #13065
  {24,  2,   0}, // #13066
  {25,  2,   0}, // #13067
  {28,  2,   0}, // #13068
  {30,  2,   0}, // #13069
  {31,  2,   0}, // #13070
  {32,  2,   0}, // #13071
  {34,  2,   0}, // #13072
  {35,  2,   0}, // #13073
  {14,  2,   0}, // #13074
  {19,  1,   0}, // #13075
  {24,  1,   0}, // #13076
  {25,  1,   0}, // #13077
  {28,  1,   0}, // #13078
  {30,  1,   0}, // #13079
  {31,  1,   0}, // #13080
  {32,  1,   0}, // #13081
  {34,  1,   0}, // #13082
  {35,  1,   0}, // #13083
  {37,  1,   0}, // #13084
  {38,  1,   0}, // #13085
  {14,  1,   0}, // #13086
  {24,  1,   0}, // #13087
  {25,  1,   0}, // #13088
  {28,  1,   0}, // #13089
  {30,  1,   0}, // #13090
  {31,  1,   0}, // #13091
  {32,  1,   0}, // #13092
  {34,  1,   0}, // #13093
  {35,  1,   0}, // #13094
  { 8,  1,   0}, // #13095
  { 9,  1,   0}, // #13096
  {11,  1,   0}, // #13097
  {36,  1,   0}, // #13098
  { 4,  1,   0}, // #13099
  {11,  6,   0}, // #13100
  {36,  7,   0}, // #13101
  {37,  1,   0}, // #13102
  {38,  1,   0}, // #13103
  {14,  3,   0}, // #13104
  {15,  2,   0}, // #13105
  {19,  1,   0}, // #13106
  {20,  2,   0}, // #13107
  {21,  2,   0}, // #13108
  {25,  2,   0}, // #13109
  {26,  2,   0}, // #13110
  {28,  2,   0}, // #13111
  {29,  2,   0}, // #13112
  {31,  2,   0}, // #13113
  {32,  2,   0}, // #13114
  {33,  2,   0}, // #13115
  {37,  1,   0}, // #13116
  {38,  1,   0}, // #13117
  {14,  2,   0}, // #13118
  {15,  2,   0}, // #13119
  {20,  2,   0}, // #13120
  {21,  2,   0}, // #13121
  {25,  2,   0}, // #13122
  {26,  2,   0}, // #13123
  {28,  2,   0}, // #13124
  {29,  2,   0}, // #13125
  {31,  2,   0}, // #13126
  {32,  2,   0}, // #13127
  {33,  2,   0}, // #13128
  {14,  3,   0}, // #13129
  {19,  3,   0}, // #13130
  {37,  1,   0}, // #13131
  {38,  1,   0}, // #13132
  {14,  1,   0}, // #13133
  {17,  1,   0}, // #13134
  {22,  1,   0}, // #13135
  {23,  1,   0}, // #13136
  {24,  1,   0}, // #13137
  {25,  1,   0}, // #13138
  {28,  1,   0}, // #13139
  {30,  1,   0}, // #13140
  {31,  1,   0}, // #13141
  {32,  1,   0}, // #13142
  {34,  1,   0}, // #13143
  {35,  1,   0}, // #13144
  {14,  3,   0}, // #13145
  {19,  1,   0}, // #13146
  {25,  2,   0}, // #13147
  {28,  2,   0}, // #13148
  {31,  2,   0}, // #13149
  {32,  2,   0}, // #13150
  {37,  1,   0}, // #13151
  {38,  1,   0}, // #13152
  {14,  2,   0}, // #13153
  {25,  2,   0}, // #13154
  {28,  2,   0}, // #13155
  {31,  2,   0}, // #13156
  {32,  2,   0}, // #13157
  {14,  9,   0}, // #13158
  {19,  1,   0}, // #13159
  {25,  8,   0}, // #13160
  {28,  8,   0}, // #13161
  {31,  8,   0}, // #13162
  {32,  8,   0}, // #13163
  {37,  1,   0}, // #13164
  {38,  1,   0}, // #13165
  {14,  8,   0}, // #13166
  {25,  8,   0}, // #13167
  {28,  8,   0}, // #13168
  {31,  8,   0}, // #13169
  {32,  8,   0}, // #13170
  {14,  5,   0}, // #13171
  {19,  1,   0}, // #13172
  {20,  4,   0}, // #13173
  {21,  4,   0}, // #13174
  {25,  4,   0}, // #13175
  {26,  4,   0}, // #13176
  {28,  4,   0}, // #13177
  {29,  4,   0}, // #13178
  {31,  4,   0}, // #13179
  {32,  4,   0}, // #13180
  {37,  1,   0}, // #13181
  {38,  1,   0}, // #13182
  {14,  4,   0}, // #13183
  {20,  4,   0}, // #13184
  {21,  4,   0}, // #13185
  {25,  4,   0}, // #13186
  {26,  4,   0}, // #13187
  {28,  4,   0}, // #13188
  {29,  4,   0}, // #13189
  {31,  4,   0}, // #13190
  {32,  4,   0}, // #13191
  {14, 13,   0}, // #13192
  {19,  1,   0}, // #13193
  {25, 12,   0}, // #13194
  {28, 12,   0}, // #13195
  {31, 12,   0}, // #13196
  {32, 12,   0}, // #13197
  {37,  1,   0}, // #13198
  {38,  1,   0}, // #13199
  {14, 12,   0}, // #13200
  {25, 12,   0}, // #13201
  {28, 12,   0}, // #13202
  {31, 12,   0}, // #13203
  {32, 12,   0}, // #13204
  { 4,  2,   0}, // #13205
  {36,  2,   0}, // #13206
  {37,  3,   0}, // #13207
  {38,  1,   0}, // #13208
  {39,  2,   0}, // #13209
  {14,  2,   0}, // #13210
  {19,  2,   0}, // #13211
  {24,  1,   0}, // #13212
  {25,  1,   0}, // #13213
  {27,  1,   0}, // #13214
  {28,  1,   0}, // #13215
  {30,  1,   0}, // #13216
  {31,  1,   0}, // #13217
  {32,  1,   0}, // #13218
  {34,  1,   0}, // #13219
  {35,  1,   0}, // #13220
  {37,  1,   0}, // #13221
  {38,  1,   0}, // #13222
  {14,  1,   0}, // #13223
  {19,  1,   0}, // #13224
  {24,  1,   0}, // #13225
  {25,  1,   0}, // #13226
  {27,  1,   0}, // #13227
  {28,  1,   0}, // #13228
  {30,  1,   0}, // #13229
  {31,  1,   0}, // #13230
  {32,  1,   0}, // #13231
  {34,  1,   0}, // #13232
  {35,  1,   0}, // #13233
  { 4,  1,   0}, // #13234
  {10,  2,   0}, // #13235
  {11,  2,   0}, // #13236
  {36,  3,   0}, // #13237
  {37,  1,   0}, // #13238
  {38,  1,   0}, // #13239
  {14,  1,   0}, // #13240
  {16,  1,   0}, // #13241
  {20,  1,   0}, // #13242
  {21,  1,   0}, // #13243
  {24,  1,   0}, // #13244
  {25,  1,   0}, // #13245
  {26,  1,   0}, // #13246
  {28,  1,   0}, // #13247
  {29,  1,   0}, // #13248
  {30,  1,   0}, // #13249
  {31,  1,   0}, // #13250
  {32,  1,   0}, // #13251
  {34,  1,   0}, // #13252
  {35,  1,   0}, // #13253
  { 4,  1,   0}, // #13254
  { 9,  2,   0}, // #13255
  {11,  2,   0}, // #13256
  {36,  3,   0}, // #13257
  {37,  1,   0}, // #13258
  {39,  1,   0}, // #13259
  { 9,  2,   0}, // #13260
  {11,  2,   0}, // #13261
  {36,  2,   0}, // #13262
  { 4,  1,   0}, // #13263
  {10,  4,   0}, // #13264
  {11,  4,   0}, // #13265
  {36,  5,   0}, // #13266
  {37,  1,   0}, // #13267
  {38,  1,   0}, // #13268
  {14, 10,   0}, // #13269
  {16,  9,   0}, // #13270
  {19,  1,   0}, // #13271
  {20,  9,   0}, // #13272
  {21,  9,   0}, // #13273
  {24,  9,   0}, // #13274
  {25,  9,   0}, // #13275
  {26,  9,   0}, // #13276
  {28,  9,   0}, // #13277
  {29,  9,   0}, // #13278
  {30,  9,   0}, // #13279
  {31,  9,   0}, // #13280
  {32,  9,   0}, // #13281
  {34,  9,   0}, // #13282
  {35,  9,   0}, // #13283
  {37,  1,   0}, // #13284
  {38,  1,   0}, // #13285
  {14,  9,   0}, // #13286
  {16,  9,   0}, // #13287
  {20,  9,   0}, // #13288
  {21,  9,   0}, // #13289
  {24,  9,   0}, // #13290
  {25,  9,   0}, // #13291
  {26,  9,   0}, // #13292
  {28,  9,   0}, // #13293
  {29,  9,   0}, // #13294
  {30,  9,   0}, // #13295
  {31,  9,   0}, // #13296
  {32,  9,   0}, // #13297
  {34,  9,   0}, // #13298
  {35,  9,   0}, // #13299
  {14, 23,   0}, // #13300
  {16, 23,   0}, // #13301
  {20, 23,   0}, // #13302
  {21, 23,   0}, // #13303
  {24, 23,   0}, // #13304
  {25, 23,   0}, // #13305
  {26, 23,   0}, // #13306
  {28, 23,   0}, // #13307
  {29, 23,   0}, // #13308
  {30, 23,   0}, // #13309
  {31, 23,   0}, // #13310
  {32, 23,   0}, // #13311
  {34, 23,   0}, // #13312
  {35, 23,   0}, // #13313
  { 4,  1,   0}, // #13314
  {11, 60,   0}, // #13315
  {36, 61,   0}, // #13316
  {37,  1,   0}, // #13317
  {39,  1,   0}, // #13318
  {14,  2,   0}, // #13319
  {19,  1,   0}, // #13320
  {22,  2,   0}, // #13321
  {23,  2,   0}, // #13322
  {25,  2,   0}, // #13323
  {27,  1,   0}, // #13324
  {28,  2,   0}, // #13325
  {31,  2,   0}, // #13326
  {32,  2,   0}, // #13327
  {37,  1,   0}, // #13328
  {39,  1,   0}, // #13329
  {14,  1,   0}, // #13330
  {19,  1,   0}, // #13331
  {22,  1,   0}, // #13332
  {23,  1,   0}, // #13333
  {25,  1,   0}, // #13334
  {27,  1,   0}, // #13335
  {28,  1,   0}, // #13336
  {31,  1,   0}, // #13337
  {32,  1,   0}, // #13338
  {37,  1,   0}, // #13339
  {39,  1,   0}, // #13340
  {19,  6,   0}, // #13341
  {27,  6,   0}, // #13342
  {37,  1,   0}, // #13343
  {39,  1,   0}, // #13344
  {19,  4,   0}, // #13345
  {27,  4,   0}, // #13346
  {37,  1,   0}, // #13347
  {39,  1,   0}, // #13348
  {19, 12,   0}, // #13349
  {27, 12,   0}, // #13350
  {37,  1,   0}, // #13351
  {39,  1,   0}, // #13352
  {14,  4,   0}, // #13353
  {19,  1,   0}, // #13354
  {24,  3,   0}, // #13355
  {25,  3,   0}, // #13356
  {28,  3,   0}, // #13357
  {30,  3,   0}, // #13358
  {31,  3,   0}, // #13359
  {32,  3,   0}, // #13360
  {34,  3,   0}, // #13361
  {35,  3,   0}, // #13362
  {37,  1,   0}, // #13363
  {38,  1,   0}, // #13364
  {14,  3,   0}, // #13365
  {24,  3,   0}, // #13366
  {25,  3,   0}, // #13367
  {28,  3,   0}, // #13368
  {30,  3,   0}, // #13369
  {31,  3,   0}, // #13370
  {32,  3,   0}, // #13371
  {34,  3,   0}, // #13372
  {35,  3,   0}, // #13373
  {14,  3,   0}, // #13374
  {19,  1,   0}, // #13375
  {24,  2,   0}, // #13376
  {25,  2,   0}, // #13377
  {28,  2,   0}, // #13378
  {30,  2,   0}, // #13379
  {31,  2,   0}, // #13380
  {32,  2,   0}, // #13381
  {34,  2,   0}, // #13382
  {35,  2,   0}, // #13383
  {37,  1,   0}, // #13384
  {38,  1,   0}, // #13385
  {14,  2,   0}, // #13386
  {24,  2,   0}, // #13387
  {25,  2,   0}, // #13388
  {28,  2,   0}, // #13389
  {30,  2,   0}, // #13390
  {31,  2,   0}, // #13391
  {32,  2,   0}, // #13392
  {34,  2,   0}, // #13393
  {35,  2,   0}, // #13394
  {37, 30,   0}, // #13395
  { 4,  3,   0}, // #13396
  {36,  3,   0}, // #13397
  {37,  1,   0}, // #13398
  {38,  1,   0}, // #13399
  { 4,  1,   0}, // #13400
  {11, 12,   0}, // #13401
  {36, 13,   0}, // #13402
  {37,  1,   0}, // #13403
  {38,  1,   0}, // #13404
  {11, 24,   0}, // #13405
  {36, 24,   0}, // #13406
  {11, 59,   0}, // #13407
  {36, 59,   0}, // #13408
  {10,  6,   0}, // #13409
  {11,  6,   0}, // #13410
  {36,  6,   0}, // #13411
  {10,  8,   0}, // #13412
  {11,  8,   0}, // #13413
  {36,  8,   0}, // #13414
  { 4,  1,   0}, // #13415
  {14,  1,   0}, // #13416
  {15,  1,   0}, // #13417
  {20,  1,   0}, // #13418
  {21,  1,   0}, // #13419
  {25,  1,   0}, // #13420
  {26,  1,   0}, // #13421
  {28,  1,   0}, // #13422
  {29,  1,   0}, // #13423
  {31,  1,   0}, // #13424
  {32,  1,   0}, // #13425
  {33,  1,   0}, // #13426
  {36,  1,   0}, // #13427
  {37,  1,   0}, // #13428
  {38,  1,   0}, // #13429
  { 4,  1,   0}, // #13430
  {14, 24,   0}, // #13431
  {25, 24,   0}, // #13432
  {28, 24,   0}, // #13433
  {31, 24,   0}, // #13434
  {32, 24,   0}, // #13435
  {36,  1,   0}, // #13436
  {37,  1,   0}, // #13437
  {38,  1,   0}, // #13438
  { 4,  1,   0}, // #13439
  {14, 62,   0}, // #13440
  {25, 62,   0}, // #13441
  {28, 62,   0}, // #13442
  {31, 62,   0}, // #13443
  {32, 62,   0}, // #13444
  {36,  1,   0}, // #13445
  {37,  1,   0}, // #13446
  {38,  1,   0}, // #13447
  { 4,  1,   0}, // #13448
  {11,  4,   0}, // #13449
  {36,  5,   0}, // #13450
  {37,  1,   0}, // #13451
  {39,  1,   0}, // #13452
  {14,  6,   0}, // #13453
  {22,  6,   0}, // #13454
  {23,  6,   0}, // #13455
  {25,  6,   0}, // #13456
  {28,  6,   0}, // #13457
  {31,  6,   0}, // #13458
  {32,  6,   0}, // #13459
  { 4,  1,   0}, // #13460
  {14,  1,   0}, // #13461
  {16,  1,   0}, // #13462
  {20,  1,   0}, // #13463
  {21,  1,   0}, // #13464
  {24,  1,   0}, // #13465
  {25,  1,   0}, // #13466
  {26,  1,   0}, // #13467
  {28,  1,   0}, // #13468
  {29,  1,   0}, // #13469
  {30,  1,   0}, // #13470
  {31,  1,   0}, // #13471
  {32,  1,   0}, // #13472
  {34,  1,   0}, // #13473
  {35,  1,   0}, // #13474
  {36,  1,   0}, // #13475
  {37,  1,   0}, // #13476
  {38,  1,   0}, // #13477
  {14,  1,   0}, // #13478
  {15,  1,   0}, // #13479
  {19,  1,   0}, // #13480
  {20,  1,   0}, // #13481
  {21,  1,   0}, // #13482
  {25,  1,   0}, // #13483
  {26,  1,   0}, // #13484
  {27,  1,   0}, // #13485
  {28,  1,   0}, // #13486
  {29,  1,   0}, // #13487
  {31,  1,   0}, // #13488
  {32,  1,   0}, // #13489
  {33,  1,   0}, // #13490
  {37,  1,   0}, // #13491
  {39,  1,   0}, // #13492
  { 4,  1,   0}, // #13493
  {14,  8,   0}, // #13494
  {25,  8,   0}, // #13495
  {28,  8,   0}, // #13496
  {31,  8,   0}, // #13497
  {32,  8,   0}, // #13498
  {36,  1,   0}, // #13499
  {37,  1,   0}, // #13500
  {38,  1,   0}, // #13501
  {14,  3,   0}, // #13502
  {25,  3,   0}, // #13503
  {28,  3,   0}, // #13504
  {31,  3,   0}, // #13505
  {32,  3,   0}, // #13506
  { 4,  1,   0}, // #13507
  {14,  3,   0}, // #13508
  {25,  3,   0}, // #13509
  {28,  3,   0}, // #13510
  {31,  3,   0}, // #13511
  {32,  3,   0}, // #13512
  {36,  1,   0}, // #13513
  {37,  1,   0}, // #13514
  {38,  1,   0}, // #13515
  { 4,  1,   0}, // #13516
  {14,  2,   0}, // #13517
  {25,  2,   0}, // #13518
  {28,  2,   0}, // #13519
  {31,  2,   0}, // #13520
  {32,  2,   0}, // #13521
  {36,  1,   0}, // #13522
  {37,  1,   0}, // #13523
  {38,  1,   0}, // #13524
  { 4,  1,   0}, // #13525
  {11,  7,   0}, // #13526
  {36,  8,   0}, // #13527
  {37,  2,   0}, // #13528
  {38,  1,   0}, // #13529
  {39,  1,   0}, // #13530
  { 4,  1,   0}, // #13531
  {10,  8,   0}, // #13532
  {11,  8,   0}, // #13533
  {36,  9,   0}, // #13534
  {37,  1,   0}, // #13535
  {38,  1,   0}, // #13536
  {14,  5,   0}, // #13537
  {19,  1,   0}, // #13538
  {25,  4,   0}, // #13539
  {28,  4,   0}, // #13540
  {31,  4,   0}, // #13541
  {32,  4,   0}, // #13542
  { 4,  1,   0}, // #13543
  {14,  2,   0}, // #13544
  {16,  2,   0}, // #13545
  {20,  2,   0}, // #13546
  {21,  2,   0}, // #13547
  {24,  2,   0}, // #13548
  {25,  2,   0}, // #13549
  {26,  2,   0}, // #13550
  {28,  2,   0}, // #13551
  {29,  2,   0}, // #13552
  {30,  2,   0}, // #13553
  {31,  2,   0}, // #13554
  {32,  2,   0}, // #13555
  {34,  2,   0}, // #13556
  {35,  2,   0}, // #13557
  {36,  1,   0}, // #13558
  {37,  1,   0}, // #13559
  {38,  1,   0}, // #13560
  {11,  1,   0}, // #13561
  {41,  1,   0}, // #13562
  {11,  0,   0}, // #13563
  {41,  0,   0}, // #13564
  {14,  1,   0}, // #13565
  {28,  1,   0}, // #13566
  {33,  1,   0}, // #13567
  {36,  1,   0}, // #13568
  {37,  1,   0}, // #13569
  {13,  1,   0}, // #13570
  {41,  1,   0}, // #13571
  {11, 12,   0}, // #13572
  {41, 12,   0}, // #13573
  { 4,  1,   0}, // #13574
  {13,  1,   0}, // #13575
  {41,  2,   0}, // #13576
  {42,  1,   0}, // #13577
  {43,  1,   0}, // #13578
  {11,  4,   0}, // #13579
  {41,  4,   0}, // #13580
  {11, 100,   0}, // #13581
  {41, 100,   0}, // #13582
  { 4,  1,   0}, // #13583
  {41,  1,   0}, // #13584
  { 4,  1,   0}, // #13585
  {41,  1,   0}, // #13586
  {42,  1,   0}, // #13587
  {44,  1,   0}, // #13588
  {10,  3,   0}, // #13589
  {11,  3,   0}, // #13590
  {41,  3,   0}, // #13591
  {19,  1,   0}, // #13592
  {32,  1,   0}, // #13593
  {42,  1,   0}, // #13594
  {44,  1,   0}, // #13595
  {14,  1,   0}, // #13596
  {19,  1,   0}, // #13597
  {30,  1,   0}, // #13598
  {42,  1,   0}, // #13599
  {43,  1,   0}, // #13600
  { 4,  2,   0}, // #13601
  {11,  1,   0}, // #13602
  {41,  3,   0}, // #13603
  {42,  2,   0}, // #13604
  {43,  1,   0}, // #13605
  {44,  1,   0}, // #13606
  {14,  2,   0}, // #13607
  {20,  2,   0}, // #13608
  {21,  2,   0}, // #13609
  {24,  2,   0}, // #13610
  {28,  2,   0}, // #13611
  {29,  2,   0}, // #13612
  {33,  2,   0}, // #13613
  {34,  2,   0}, // #13614
  {36,  2,   0}, // #13615
  {37,  2,   0}, // #13616
  { 4,  2,   0}, // #13617
  {11,  4,   0}, // #13618
  {41,  6,   0}, // #13619
  {42,  2,   0}, // #13620
  {43,  1,   0}, // #13621
  {44,  1,   0}, // #13622
  { 4,  1,   0}, // #13623
  {11,  4,   0}, // #13624
  {41,  5,   0}, // #13625
  {42,  1,   0}, // #13626
  {43,  1,   0}, // #13627
  { 4,  1,   0}, // #13628
  {11,  1,   0}, // #13629
  {41,  2,   0}, // #13630
  {42,  1,   0}, // #13631
  {43,  1,   0}, // #13632
  {14,  2,   0}, // #13633
  {19,  1,   0}, // #13634
  {22,  1,   0}, // #13635
  {23,  1,   0}, // #13636
  {26,  1,   0}, // #13637
  {27,  1,   0}, // #13638
  {28,  1,   0}, // #13639
  {30,  1,   0}, // #13640
  {31,  1,   0}, // #13641
  {33,  1,   0}, // #13642
  {36,  1,   0}, // #13643
  {37,  1,   0}, // #13644
  {42,  1,   0}, // #13645
  {43,  1,   0}, // #13646
  {14,  1,   0}, // #13647
  {22,  1,   0}, // #13648
  {23,  1,   0}, // #13649
  {26,  1,   0}, // #13650
  {27,  1,   0}, // #13651
  {28,  1,   0}, // #13652
  {31,  1,   0}, // #13653
  {33,  1,   0}, // #13654
  {36,  1,   0}, // #13655
  {37,  1,   0}, // #13656
  {14,  2,   0}, // #13657
  {19,  1,   0}, // #13658
  {20,  1,   0}, // #13659
  {21,  1,   0}, // #13660
  {24,  1,   0}, // #13661
  {28,  1,   0}, // #13662
  {29,  1,   0}, // #13663
  {30,  1,   0}, // #13664
  {33,  1,   0}, // #13665
  {34,  1,   0}, // #13666
  {36,  1,   0}, // #13667
  {37,  1,   0}, // #13668
  {42,  1,   0}, // #13669
  {43,  1,   0}, // #13670
  {14,  1,   0}, // #13671
  {20,  1,   0}, // #13672
  {21,  1,   0}, // #13673
  {24,  1,   0}, // #13674
  {28,  1,   0}, // #13675
  {29,  1,   0}, // #13676
  {33,  1,   0}, // #13677
  {34,  1,   0}, // #13678
  {36,  1,   0}, // #13679
  {37,  1,   0}, // #13680
  {14,  2,   0}, // #13681
  {19,  1,   0}, // #13682
  {28,  1,   0}, // #13683
  {30,  1,   0}, // #13684
  {33,  1,   0}, // #13685
  {36,  1,   0}, // #13686
  {37,  1,   0}, // #13687
  {42,  1,   0}, // #13688
  {43,  1,   0}, // #13689
  { 4,  1,   0}, // #13690
  {10,  1,   0}, // #13691
  {11,  1,   0}, // #13692
  {41,  2,   0}, // #13693
  {42,  1,   0}, // #13694
  {43,  1,   0}, // #13695
  {10,  1,   0}, // #13696
  {11,  1,   0}, // #13697
  {41,  1,   0}, // #13698
  { 4,  1,   0}, // #13699
  { 6,  1,   0}, // #13700
  {10,  1,   0}, // #13701
  {11,  1,   0}, // #13702
  {41,  2,   0}, // #13703
  {42,  1,   0}, // #13704
  {43,  1,   0}, // #13705
  { 6,  1,   0}, // #13706
  {10,  1,   0}, // #13707
  {11,  1,   0}, // #13708
  {41,  1,   0}, // #13709
  { 4,  2,   0}, // #13710
  {10,  1,   0}, // #13711
  {11,  1,   0}, // #13712
  {41,  3,   0}, // #13713
  {42,  2,   0}, // #13714
  {43,  1,   0}, // #13715
  {44,  1,   0}, // #13716
  {10,  2,   0}, // #13717
  {11,  2,   0}, // #13718
  {41,  2,   0}, // #13719
  { 9,  1,   0}, // #13720
  {11,  1,   0}, // #13721
  {41,  1,   0}, // #13722
  { 4,  1,   0}, // #13723
  { 9,  1,   0}, // #13724
  {11,  1,   0}, // #13725
  {41,  2,   0}, // #13726
  {42,  1,   0}, // #13727
  {43,  1,   0}, // #13728
  { 4,  1,   0}, // #13729
  {41,  1,   0}, // #13730
  {42,  1,   0}, // #13731
  {43,  1,   0}, // #13732
  {11, 28,   0}, // #13733
  {41, 28,   0}, // #13734
  {11,  8,   0}, // #13735
  {41,  8,   0}, // #13736
  {14,  3,   0}, // #13737
  {19,  1,   0}, // #13738
  {20,  2,   0}, // #13739
  {21,  2,   0}, // #13740
  {24,  2,   0}, // #13741
  {28,  2,   0}, // #13742
  {29,  2,   0}, // #13743
  {30,  1,   0}, // #13744
  {33,  2,   0}, // #13745
  {34,  2,   0}, // #13746
  {36,  2,   0}, // #13747
  {37,  2,   0}, // #13748
  {42,  1,   0}, // #13749
  {43,  1,   0}, // #13750
  {14,  3,   0}, // #13751
  {19,  1,   0}, // #13752
  {22,  2,   0}, // #13753
  {23,  2,   0}, // #13754
  {26,  2,   0}, // #13755
  {27,  2,   0}, // #13756
  {28,  2,   0}, // #13757
  {30,  1,   0}, // #13758
  {31,  2,   0}, // #13759
  {33,  2,   0}, // #13760
  {36,  2,   0}, // #13761
  {37,  2,   0}, // #13762
  {42,  1,   0}, // #13763
  {43,  1,   0}, // #13764
  {14,  2,   0}, // #13765
  {22,  2,   0}, // #13766
  {23,  2,   0}, // #13767
  {26,  2,   0}, // #13768
  {27,  2,   0}, // #13769
  {28,  2,   0}, // #13770
  {31,  2,   0}, // #13771
  {33,  2,   0}, // #13772
  {36,  2,   0}, // #13773
  {37,  2,   0}, // #13774
  {14,  6,   0}, // #13775
  {19,  1,   0}, // #13776
  {22,  5,   0}, // #13777
  {23,  5,   0}, // #13778
  {26,  5,   0}, // #13779
  {27,  5,   0}, // #13780
  {28,  5,   0}, // #13781
  {30,  1,   0}, // #13782
  {31,  5,   0}, // #13783
  {33,  5,   0}, // #13784
  {36,  5,   0}, // #13785
  {37,  5,   0}, // #13786
  {42,  1,   0}, // #13787
  {43,  1,   0}, // #13788
  {14,  5,   0}, // #13789
  {22,  5,   0}, // #13790
  {23,  5,   0}, // #13791
  {26,  5,   0}, // #13792
  {27,  5,   0}, // #13793
  {28,  5,   0}, // #13794
  {31,  5,   0}, // #13795
  {33,  5,   0}, // #13796
  {36,  5,   0}, // #13797
  {37,  5,   0}, // #13798
  { 4,  1,   0}, // #13799
  { 5, 11,   0}, // #13800
  { 9, 11,   0}, // #13801
  {11, 11,   0}, // #13802
  {13, 11,   0}, // #13803
  {41, 12,   0}, // #13804
  {42,  1,   0}, // #13805
  {43,  1,   0}, // #13806
  { 5, 11,   0}, // #13807
  { 9, 11,   0}, // #13808
  {11, 11,   0}, // #13809
  {13, 11,   0}, // #13810
  {41, 11,   0}, // #13811
  { 4,  1,   0}, // #13812
  { 5, 13,   0}, // #13813
  { 9, 13,   0}, // #13814
  {11, 13,   0}, // #13815
  {13, 13,   0}, // #13816
  {41, 14,   0}, // #13817
  {42,  1,   0}, // #13818
  {43,  1,   0}, // #13819
  { 5, 13,   0}, // #13820
  { 9, 13,   0}, // #13821
  {11, 13,   0}, // #13822
  {13, 13,   0}, // #13823
  {41, 13,   0}, // #13824
  { 4,  1,   0}, // #13825
  { 5, 17,   0}, // #13826
  { 9, 17,   0}, // #13827
  {11, 17,   0}, // #13828
  {13, 17,   0}, // #13829
  {41, 18,   0}, // #13830
  {42,  1,   0}, // #13831
  {43,  1,   0}, // #13832
  { 5, 17,   0}, // #13833
  { 9, 17,   0}, // #13834
  {11, 17,   0}, // #13835
  {13, 17,   0}, // #13836
  {41, 17,   0}, // #13837
  { 4,  1,   0}, // #13838
  { 5, 10,   0}, // #13839
  { 9, 10,   0}, // #13840
  {11, 10,   0}, // #13841
  {13, 10,   0}, // #13842
  {41, 11,   0}, // #13843
  {42,  1,   0}, // #13844
  {43,  1,   0}, // #13845
  { 5, 10,   0}, // #13846
  { 9, 10,   0}, // #13847
  {11, 10,   0}, // #13848
  {13, 10,   0}, // #13849
  {41, 10,   0}, // #13850
  {14,  6,   0}, // #13851
  {16,  5,   0}, // #13852
  {19,  1,   0}, // #13853
  {20,  5,   0}, // #13854
  {21,  5,   0}, // #13855
  {24,  5,   0}, // #13856
  {25,  5,   0}, // #13857
  {27,  5,   0}, // #13858
  {28,  5,   0}, // #13859
  {29,  5,   0}, // #13860
  {30,  1,   0}, // #13861
  {33,  5,   0}, // #13862
  {34,  5,   0}, // #13863
  {35,  5,   0}, // #13864
  {36,  5,   0}, // #13865
  {37,  5,   0}, // #13866
  {39,  5,   0}, // #13867
  {40,  5,   0}, // #13868
  {42,  1,   0}, // #13869
  {43,  1,   0}, // #13870
  {14,  5,   0}, // #13871
  {16,  5,   0}, // #13872
  {20,  5,   0}, // #13873
  {21,  5,   0}, // #13874
  {24,  5,   0}, // #13875
  {25,  5,   0}, // #13876
  {27,  5,   0}, // #13877
  {28,  5,   0}, // #13878
  {29,  5,   0}, // #13879
  {33,  5,   0}, // #13880
  {34,  5,   0}, // #13881
  {35,  5,   0}, // #13882
  {36,  5,   0}, // #13883
  {37,  5,   0}, // #13884
  {39,  5,   0}, // #13885
  {40,  5,   0}, // #13886
  {14,  4,   0}, // #13887
  {16,  3,   0}, // #13888
  {19,  1,   0}, // #13889
  {20,  3,   0}, // #13890
  {21,  3,   0}, // #13891
  {24,  3,   0}, // #13892
  {25,  3,   0}, // #13893
  {27,  3,   0}, // #13894
  {28,  3,   0}, // #13895
  {29,  3,   0}, // #13896
  {30,  1,   0}, // #13897
  {33,  3,   0}, // #13898
  {34,  3,   0}, // #13899
  {35,  3,   0}, // #13900
  {36,  3,   0}, // #13901
  {37,  3,   0}, // #13902
  {39,  3,   0}, // #13903
  {40,  3,   0}, // #13904
  {42,  1,   0}, // #13905
  {43,  1,   0}, // #13906
  {14,  3,   0}, // #13907
  {16,  3,   0}, // #13908
  {20,  3,   0}, // #13909
  {21,  3,   0}, // #13910
  {24,  3,   0}, // #13911
  {25,  3,   0}, // #13912
  {27,  3,   0}, // #13913
  {28,  3,   0}, // #13914
  {29,  3,   0}, // #13915
  {33,  3,   0}, // #13916
  {34,  3,   0}, // #13917
  {35,  3,   0}, // #13918
  {36,  3,   0}, // #13919
  {37,  3,   0}, // #13920
  {39,  3,   0}, // #13921
  {40,  3,   0}, // #13922
  {14,  7,   0}, // #13923
  {19,  1,   0}, // #13924
  {20,  6,   0}, // #13925
  {21,  6,   0}, // #13926
  {24,  6,   0}, // #13927
  {28,  6,   0}, // #13928
  {29,  6,   0}, // #13929
  {30,  1,   0}, // #13930
  {33,  6,   0}, // #13931
  {34,  6,   0}, // #13932
  {36,  6,   0}, // #13933
  {37,  6,   0}, // #13934
  {42,  1,   0}, // #13935
  {43,  1,   0}, // #13936
  {14,  6,   0}, // #13937
  {20,  6,   0}, // #13938
  {21,  6,   0}, // #13939
  {24,  6,   0}, // #13940
  {28,  6,   0}, // #13941
  {29,  6,   0}, // #13942
  {33,  6,   0}, // #13943
  {34,  6,   0}, // #13944
  {36,  6,   0}, // #13945
  {37,  6,   0}, // #13946
  {14,  9,   0}, // #13947
  {19,  1,   0}, // #13948
  {20,  8,   0}, // #13949
  {21,  8,   0}, // #13950
  {24,  8,   0}, // #13951
  {28,  8,   0}, // #13952
  {29,  8,   0}, // #13953
  {30,  1,   0}, // #13954
  {33,  8,   0}, // #13955
  {34,  8,   0}, // #13956
  {36,  8,   0}, // #13957
  {37,  8,   0}, // #13958
  {42,  1,   0}, // #13959
  {43,  1,   0}, // #13960
  {14,  8,   0}, // #13961
  {20,  8,   0}, // #13962
  {21,  8,   0}, // #13963
  {24,  8,   0}, // #13964
  {28,  8,   0}, // #13965
  {29,  8,   0}, // #13966
  {33,  8,   0}, // #13967
  {34,  8,   0}, // #13968
  {36,  8,   0}, // #13969
  {37,  8,   0}, // #13970
  { 4,  1,   0}, // #13971
  {41,  1,   0}, // #13972
  {42,  2,   0}, // #13973
  {44,  2,   0}, // #13974
  {14,  2,   0}, // #13975
  {19,  2,   0}, // #13976
  {30,  2,   0}, // #13977
  {14,  2,   0}, // #13978
  {16,  1,   0}, // #13979
  {19,  1,   0}, // #13980
  {20,  1,   0}, // #13981
  {21,  1,   0}, // #13982
  {24,  1,   0}, // #13983
  {25,  1,   0}, // #13984
  {27,  1,   0}, // #13985
  {28,  1,   0}, // #13986
  {29,  1,   0}, // #13987
  {30,  1,   0}, // #13988
  {33,  1,   0}, // #13989
  {34,  1,   0}, // #13990
  {35,  1,   0}, // #13991
  {36,  1,   0}, // #13992
  {37,  1,   0}, // #13993
  {39,  1,   0}, // #13994
  {40,  1,   0}, // #13995
  {42,  1,   0}, // #13996
  {43,  1,   0}, // #13997
  {14,  2,   0}, // #13998
  {19,  1,   0}, // #13999
  {28,  1,   0}, // #14000
  {30,  1,   0}, // #14001
  {33,  1,   0}, // #14002
  {36,  1,   0}, // #14003
  {37,  1,   0}, // #14004
  {38,  1,   0}, // #14005
  {42,  1,   0}, // #14006
  {43,  1,   0}, // #14007
  {14,  1,   0}, // #14008
  {28,  1,   0}, // #14009
  {33,  1,   0}, // #14010
  {36,  1,   0}, // #14011
  {37,  1,   0}, // #14012
  {38,  1,   0}, // #14013
  {14,  3,   0}, // #14014
  {17,  2,   0}, // #14015
  {19,  1,   0}, // #14016
  {22,  2,   0}, // #14017
  {23,  2,   0}, // #14018
  {25,  2,   0}, // #14019
  {26,  2,   0}, // #14020
  {27,  2,   0}, // #14021
  {28,  2,   0}, // #14022
  {30,  1,   0}, // #14023
  {31,  2,   0}, // #14024
  {33,  2,   0}, // #14025
  {35,  2,   0}, // #14026
  {36,  2,   0}, // #14027
  {37,  2,   0}, // #14028
  {39,  2,   0}, // #14029
  {40,  2,   0}, // #14030
  {42,  1,   0}, // #14031
  {43,  1,   0}, // #14032
  {14,  2,   0}, // #14033
  {17,  2,   0}, // #14034
  {22,  2,   0}, // #14035
  {23,  2,   0}, // #14036
  {25,  2,   0}, // #14037
  {26,  2,   0}, // #14038
  {27,  2,   0}, // #14039
  {28,  2,   0}, // #14040
  {31,  2,   0}, // #14041
  {33,  2,   0}, // #14042
  {35,  2,   0}, // #14043
  {36,  2,   0}, // #14044
  {37,  2,   0}, // #14045
  {39,  2,   0}, // #14046
  {40,  2,   0}, // #14047
  { 4,  1,   0}, // #14048
  { 6,  3,   0}, // #14049
  {10,  3,   0}, // #14050
  {11,  3,   0}, // #14051
  {41,  4,   0}, // #14052
  {42,  1,   0}, // #14053
  {43,  1,   0}, // #14054
  { 6,  3,   0}, // #14055
  {10,  3,   0}, // #14056
  {11,  3,   0}, // #14057
  {41,  3,   0}, // #14058
  { 4,  1,   0}, // #14059
  { 6,  4,   0}, // #14060
  {10,  4,   0}, // #14061
  {11,  4,   0}, // #14062
  {41,  5,   0}, // #14063
  {42,  1,   0}, // #14064
  {43,  1,   0}, // #14065
  { 6,  4,   0}, // #14066
  {10,  4,   0}, // #14067
  {11,  4,   0}, // #14068
  {41,  4,   0}, // #14069
  {14,  2,   0}, // #14070
  {19,  1,   0}, // #14071
  {25,  1,   0}, // #14072
  {27,  1,   0}, // #14073
  {28,  1,   0}, // #14074
  {30,  1,   0}, // #14075
  {33,  1,   0}, // #14076
  {35,  1,   0}, // #14077
  {36,  1,   0}, // #14078
  {37,  1,   0}, // #14079
  {39,  1,   0}, // #14080
  {40,  1,   0}, // #14081
  {42,  1,   0}, // #14082
  {43,  1,   0}, // #14083
  {14,  1,   0}, // #14084
  {25,  1,   0}, // #14085
  {27,  1,   0}, // #14086
  {28,  1,   0}, // #14087
  {33,  1,   0}, // #14088
  {35,  1,   0}, // #14089
  {36,  1,   0}, // #14090
  {37,  1,   0}, // #14091
  {39,  1,   0}, // #14092
  {40,  1,   0}, // #14093
  { 8,  1,   0}, // #14094
  { 9,  1,   0}, // #14095
  {11,  1,   0}, // #14096
  {41,  1,   0}, // #14097
  { 4,  1,   0}, // #14098
  {11,  6,   0}, // #14099
  {41,  7,   0}, // #14100
  {42,  1,   0}, // #14101
  {43,  1,   0}, // #14102
  {14,  3,   0}, // #14103
  {15,  2,   0}, // #14104
  {19,  1,   0}, // #14105
  {20,  2,   0}, // #14106
  {21,  2,   0}, // #14107
  {24,  2,   0}, // #14108
  {28,  2,   0}, // #14109
  {29,  2,   0}, // #14110
  {30,  1,   0}, // #14111
  {33,  2,   0}, // #14112
  {34,  2,   0}, // #14113
  {36,  2,   0}, // #14114
  {37,  2,   0}, // #14115
  {38,  2,   0}, // #14116
  {42,  1,   0}, // #14117
  {43,  1,   0}, // #14118
  {14,  2,   0}, // #14119
  {15,  2,   0}, // #14120
  {20,  2,   0}, // #14121
  {21,  2,   0}, // #14122
  {24,  2,   0}, // #14123
  {28,  2,   0}, // #14124
  {29,  2,   0}, // #14125
  {33,  2,   0}, // #14126
  {34,  2,   0}, // #14127
  {36,  2,   0}, // #14128
  {37,  2,   0}, // #14129
  {38,  2,   0}, // #14130
  {14,  3,   0}, // #14131
  {19,  3,   0}, // #14132
  {30,  3,   0}, // #14133
  {42,  1,   0}, // #14134
  {43,  1,   0}, // #14135
  {14,  1,   0}, // #14136
  {17,  1,   0}, // #14137
  {22,  1,   0}, // #14138
  {23,  1,   0}, // #14139
  {25,  1,   0}, // #14140
  {26,  1,   0}, // #14141
  {27,  1,   0}, // #14142
  {28,  1,   0}, // #14143
  {31,  1,   0}, // #14144
  {33,  1,   0}, // #14145
  {35,  1,   0}, // #14146
  {36,  1,   0}, // #14147
  {37,  1,   0}, // #14148
  {39,  1,   0}, // #14149
  {40,  1,   0}, // #14150
  {14,  3,   0}, // #14151
  {19,  1,   0}, // #14152
  {28,  2,   0}, // #14153
  {30,  1,   0}, // #14154
  {33,  2,   0}, // #14155
  {36,  2,   0}, // #14156
  {37,  2,   0}, // #14157
  {42,  1,   0}, // #14158
  {43,  1,   0}, // #14159
  {14,  2,   0}, // #14160
  {28,  2,   0}, // #14161
  {33,  2,   0}, // #14162
  {36,  2,   0}, // #14163
  {37,  2,   0}, // #14164
  {14,  9,   0}, // #14165
  {19,  1,   0}, // #14166
  {28,  8,   0}, // #14167
  {30,  1,   0}, // #14168
  {33,  8,   0}, // #14169
  {36,  8,   0}, // #14170
  {37,  8,   0}, // #14171
  {42,  1,   0}, // #14172
  {43,  1,   0}, // #14173
  {14,  8,   0}, // #14174
  {28,  8,   0}, // #14175
  {33,  8,   0}, // #14176
  {36,  8,   0}, // #14177
  {37,  8,   0}, // #14178
  {14,  5,   0}, // #14179
  {19,  1,   0}, // #14180
  {20,  4,   0}, // #14181
  {21,  4,   0}, // #14182
  {24,  4,   0}, // #14183
  {28,  4,   0}, // #14184
  {29,  4,   0}, // #14185
  {30,  1,   0}, // #14186
  {33,  4,   0}, // #14187
  {34,  4,   0}, // #14188
  {36,  4,   0}, // #14189
  {37,  4,   0}, // #14190
  {42,  1,   0}, // #14191
  {43,  1,   0}, // #14192
  {14,  4,   0}, // #14193
  {20,  4,   0}, // #14194
  {21,  4,   0}, // #14195
  {24,  4,   0}, // #14196
  {28,  4,   0}, // #14197
  {29,  4,   0}, // #14198
  {33,  4,   0}, // #14199
  {34,  4,   0}, // #14200
  {36,  4,   0}, // #14201
  {37,  4,   0}, // #14202
  {14, 13,   0}, // #14203
  {19,  1,   0}, // #14204
  {28, 12,   0}, // #14205
  {30,  1,   0}, // #14206
  {33, 12,   0}, // #14207
  {36, 12,   0}, // #14208
  {37, 12,   0}, // #14209
  {42,  1,   0}, // #14210
  {43,  1,   0}, // #14211
  {14, 12,   0}, // #14212
  {28, 12,   0}, // #14213
  {33, 12,   0}, // #14214
  {36, 12,   0}, // #14215
  {37, 12,   0}, // #14216
  { 4,  2,   0}, // #14217
  {41,  2,   0}, // #14218
  {42,  3,   0}, // #14219
  {43,  1,   0}, // #14220
  {44,  2,   0}, // #14221
  {14,  3,   0}, // #14222
  {19,  1,   0}, // #14223
  {25,  2,   0}, // #14224
  {27,  2,   0}, // #14225
  {28,  2,   0}, // #14226
  {30,  1,   0}, // #14227
  {33,  2,   0}, // #14228
  {35,  2,   0}, // #14229
  {36,  2,   0}, // #14230
  {37,  2,   0}, // #14231
  {39,  2,   0}, // #14232
  {40,  2,   0}, // #14233
  {42,  1,   0}, // #14234
  {43,  1,   0}, // #14235
  {14,  2,   0}, // #14236
  {25,  2,   0}, // #14237
  {27,  2,   0}, // #14238
  {28,  2,   0}, // #14239
  {33,  2,   0}, // #14240
  {35,  2,   0}, // #14241
  {36,  2,   0}, // #14242
  {37,  2,   0}, // #14243
  {39,  2,   0}, // #14244
  {40,  2,   0}, // #14245
  {14,  2,   0}, // #14246
  {19,  2,   0}, // #14247
  {25,  1,   0}, // #14248
  {27,  1,   0}, // #14249
  {28,  1,   0}, // #14250
  {30,  1,   0}, // #14251
  {32,  1,   0}, // #14252
  {33,  1,   0}, // #14253
  {35,  1,   0}, // #14254
  {36,  1,   0}, // #14255
  {37,  1,   0}, // #14256
  {39,  1,   0}, // #14257
  {40,  1,   0}, // #14258
  {42,  1,   0}, // #14259
  {43,  1,   0}, // #14260
  {14,  1,   0}, // #14261
  {19,  1,   0}, // #14262
  {25,  1,   0}, // #14263
  {27,  1,   0}, // #14264
  {28,  1,   0}, // #14265
  {32,  1,   0}, // #14266
  {33,  1,   0}, // #14267
  {35,  1,   0}, // #14268
  {36,  1,   0}, // #14269
  {37,  1,   0}, // #14270
  {39,  1,   0}, // #14271
  {40,  1,   0}, // #14272
  { 4,  1,   0}, // #14273
  {10,  2,   0}, // #14274
  {11,  2,   0}, // #14275
  {41,  3,   0}, // #14276
  {42,  1,   0}, // #14277
  {43,  1,   0}, // #14278
  {14,  1,   0}, // #14279
  {16,  1,   0}, // #14280
  {20,  1,   0}, // #14281
  {21,  1,   0}, // #14282
  {24,  1,   0}, // #14283
  {25,  1,   0}, // #14284
  {27,  1,   0}, // #14285
  {28,  1,   0}, // #14286
  {29,  1,   0}, // #14287
  {33,  1,   0}, // #14288
  {34,  1,   0}, // #14289
  {35,  1,   0}, // #14290
  {36,  1,   0}, // #14291
  {37,  1,   0}, // #14292
  {39,  1,   0}, // #14293
  {40,  1,   0}, // #14294
  { 4,  1,   0}, // #14295
  { 9,  2,   0}, // #14296
  {11,  2,   0}, // #14297
  {41,  3,   0}, // #14298
  {42,  1,   0}, // #14299
  {44,  1,   0}, // #14300
  { 9,  2,   0}, // #14301
  {11,  2,   0}, // #14302
  {41,  2,   0}, // #14303
  { 4,  1,   0}, // #14304
  {10,  4,   0}, // #14305
  {11,  4,   0}, // #14306
  {41,  5,   0}, // #14307
  {42,  1,   0}, // #14308
  {43,  1,   0}, // #14309
  {14, 10,   0}, // #14310
  {16,  9,   0}, // #14311
  {19,  1,   0}, // #14312
  {20,  9,   0}, // #14313
  {21,  9,   0}, // #14314
  {24,  9,   0}, // #14315
  {25,  9,   0}, // #14316
  {27,  9,   0}, // #14317
  {28,  9,   0}, // #14318
  {29,  9,   0}, // #14319
  {30,  1,   0}, // #14320
  {33,  9,   0}, // #14321
  {34,  9,   0}, // #14322
  {35,  9,   0}, // #14323
  {36,  9,   0}, // #14324
  {37,  9,   0}, // #14325
  {39,  9,   0}, // #14326
  {40,  9,   0}, // #14327
  {42,  1,   0}, // #14328
  {43,  1,   0}, // #14329
  {14,  9,   0}, // #14330
  {16,  9,   0}, // #14331
  {20,  9,   0}, // #14332
  {21,  9,   0}, // #14333
  {24,  9,   0}, // #14334
  {25,  9,   0}, // #14335
  {27,  9,   0}, // #14336
  {28,  9,   0}, // #14337
  {29,  9,   0}, // #14338
  {33,  9,   0}, // #14339
  {34,  9,   0}, // #14340
  {35,  9,   0}, // #14341
  {36,  9,   0}, // #14342
  {37,  9,   0}, // #14343
  {39,  9,   0}, // #14344
  {40,  9,   0}, // #14345
  {14, 23,   0}, // #14346
  {16, 23,   0}, // #14347
  {20, 23,   0}, // #14348
  {21, 23,   0}, // #14349
  {24, 23,   0}, // #14350
  {25, 23,   0}, // #14351
  {27, 23,   0}, // #14352
  {28, 23,   0}, // #14353
  {29, 23,   0}, // #14354
  {33, 23,   0}, // #14355
  {34, 23,   0}, // #14356
  {35, 23,   0}, // #14357
  {36, 23,   0}, // #14358
  {37, 23,   0}, // #14359
  {39, 23,   0}, // #14360
  {40, 23,   0}, // #14361
  { 4,  1,   0}, // #14362
  {11, 60,   0}, // #14363
  {41, 61,   0}, // #14364
  {42,  1,   0}, // #14365
  {44,  1,   0}, // #14366
  {14,  5,   0}, // #14367
  {19,  1,   0}, // #14368
  {22,  4,   0}, // #14369
  {23,  4,   0}, // #14370
  {26,  4,   0}, // #14371
  {27,  4,   0}, // #14372
  {28,  4,   0}, // #14373
  {30,  1,   0}, // #14374
  {31,  4,   0}, // #14375
  {33,  4,   0}, // #14376
  {36,  4,   0}, // #14377
  {37,  4,   0}, // #14378
  {42,  1,   0}, // #14379
  {43,  1,   0}, // #14380
  {14,  4,   0}, // #14381
  {22,  4,   0}, // #14382
  {23,  4,   0}, // #14383
  {26,  4,   0}, // #14384
  {27,  4,   0}, // #14385
  {28,  4,   0}, // #14386
  {31,  4,   0}, // #14387
  {33,  4,   0}, // #14388
  {36,  4,   0}, // #14389
  {37,  4,   0}, // #14390
  {14,  2,   0}, // #14391
  {19,  1,   0}, // #14392
  {22,  2,   0}, // #14393
  {23,  2,   0}, // #14394
  {26,  2,   0}, // #14395
  {27,  2,   0}, // #14396
  {28,  2,   0}, // #14397
  {31,  2,   0}, // #14398
  {32,  1,   0}, // #14399
  {33,  2,   0}, // #14400
  {36,  2,   0}, // #14401
  {37,  2,   0}, // #14402
  {42,  1,   0}, // #14403
  {44,  1,   0}, // #14404
  {14,  1,   0}, // #14405
  {19,  1,   0}, // #14406
  {22,  1,   0}, // #14407
  {23,  1,   0}, // #14408
  {26,  1,   0}, // #14409
  {27,  1,   0}, // #14410
  {28,  1,   0}, // #14411
  {31,  1,   0}, // #14412
  {32,  1,   0}, // #14413
  {33,  1,   0}, // #14414
  {36,  1,   0}, // #14415
  {37,  1,   0}, // #14416
  {42,  1,   0}, // #14417
  {44,  1,   0}, // #14418
  {14,  5,   0}, // #14419
  {19,  1,   0}, // #14420
  {28,  4,   0}, // #14421
  {30,  1,   0}, // #14422
  {33,  4,   0}, // #14423
  {36,  4,   0}, // #14424
  {37,  4,   0}, // #14425
  {42,  1,   0}, // #14426
  {43,  1,   0}, // #14427
  {14,  4,   0}, // #14428
  {28,  4,   0}, // #14429
  {33,  4,   0}, // #14430
  {36,  4,   0}, // #14431
  {37,  4,   0}, // #14432
  {14, 11,   0}, // #14433
  {16, 10,   0}, // #14434
  {19,  1,   0}, // #14435
  {20, 10,   0}, // #14436
  {21, 10,   0}, // #14437
  {24, 10,   0}, // #14438
  {25, 10,   0}, // #14439
  {27, 10,   0}, // #14440
  {28, 10,   0}, // #14441
  {29, 10,   0}, // #14442
  {30,  1,   0}, // #14443
  {33, 10,   0}, // #14444
  {34, 10,   0}, // #14445
  {35, 10,   0}, // #14446
  {36, 10,   0}, // #14447
  {37, 10,   0}, // #14448
  {39, 10,   0}, // #14449
  {40, 10,   0}, // #14450
  {42,  1,   0}, // #14451
  {43,  1,   0}, // #14452
  {14, 10,   0}, // #14453
  {16, 10,   0}, // #14454
  {20, 10,   0}, // #14455
  {21, 10,   0}, // #14456
  {24, 10,   0}, // #14457
  {25, 10,   0}, // #14458
  {27, 10,   0}, // #14459
  {28, 10,   0}, // #14460
  {29, 10,   0}, // #14461
  {33, 10,   0}, // #14462
  {34, 10,   0}, // #14463
  {35, 10,   0}, // #14464
  {36, 10,   0}, // #14465
  {37, 10,   0}, // #14466
  {39, 10,   0}, // #14467
  {40, 10,   0}, // #14468
  {14,  7,   0}, // #14469
  {16,  6,   0}, // #14470
  {19,  1,   0}, // #14471
  {20,  6,   0}, // #14472
  {21,  6,   0}, // #14473
  {24,  6,   0}, // #14474
  {25,  6,   0}, // #14475
  {27,  6,   0}, // #14476
  {28,  6,   0}, // #14477
  {29,  6,   0}, // #14478
  {30,  1,   0}, // #14479
  {33,  6,   0}, // #14480
  {34,  6,   0}, // #14481
  {35,  6,   0}, // #14482
  {36,  6,   0}, // #14483
  {37,  6,   0}, // #14484
  {39,  6,   0}, // #14485
  {40,  6,   0}, // #14486
  {42,  1,   0}, // #14487
  {43,  1,   0}, // #14488
  {14,  6,   0}, // #14489
  {16,  6,   0}, // #14490
  {20,  6,   0}, // #14491
  {21,  6,   0}, // #14492
  {24,  6,   0}, // #14493
  {25,  6,   0}, // #14494
  {27,  6,   0}, // #14495
  {28,  6,   0}, // #14496
  {29,  6,   0}, // #14497
  {33,  6,   0}, // #14498
  {34,  6,   0}, // #14499
  {35,  6,   0}, // #14500
  {36,  6,   0}, // #14501
  {37,  6,   0}, // #14502
  {39,  6,   0}, // #14503
  {40,  6,   0}, // #14504
  {14,  3,   0}, // #14505
  {19,  1,   0}, // #14506
  {28,  2,   0}, // #14507
  {30,  1,   0}, // #14508
  {33,  2,   0}, // #14509
  {36,  2,   0}, // #14510
  {37,  2,   0}, // #14511
  {38,  2,   0}, // #14512
  {42,  1,   0}, // #14513
  {43,  1,   0}, // #14514
  {14,  2,   0}, // #14515
  {28,  2,   0}, // #14516
  {33,  2,   0}, // #14517
  {36,  2,   0}, // #14518
  {37,  2,   0}, // #14519
  {38,  2,   0}, // #14520
  {19,  6,   0}, // #14521
  {32,  6,   0}, // #14522
  {42,  1,   0}, // #14523
  {44,  1,   0}, // #14524
  {19,  4,   0}, // #14525
  {32,  4,   0}, // #14526
  {42,  1,   0}, // #14527
  {44,  1,   0}, // #14528
  {19, 12,   0}, // #14529
  {32, 12,   0}, // #14530
  {42,  1,   0}, // #14531
  {44,  1,   0}, // #14532
  {14,  4,   0}, // #14533
  {15,  3,   0}, // #14534
  {19,  1,   0}, // #14535
  {20,  3,   0}, // #14536
  {21,  3,   0}, // #14537
  {24,  3,   0}, // #14538
  {28,  3,   0}, // #14539
  {29,  3,   0}, // #14540
  {30,  1,   0}, // #14541
  {33,  3,   0}, // #14542
  {34,  3,   0}, // #14543
  {36,  3,   0}, // #14544
  {37,  3,   0}, // #14545
  {38,  3,   0}, // #14546
  {42,  1,   0}, // #14547
  {43,  1,   0}, // #14548
  {14,  3,   0}, // #14549
  {15,  3,   0}, // #14550
  {20,  3,   0}, // #14551
  {21,  3,   0}, // #14552
  {24,  3,   0}, // #14553
  {28,  3,   0}, // #14554
  {29,  3,   0}, // #14555
  {33,  3,   0}, // #14556
  {34,  3,   0}, // #14557
  {36,  3,   0}, // #14558
  {37,  3,   0}, // #14559
  {38,  3,   0}, // #14560
  {14,  4,   0}, // #14561
  {19,  1,   0}, // #14562
  {25,  3,   0}, // #14563
  {27,  3,   0}, // #14564
  {28,  3,   0}, // #14565
  {30,  1,   0}, // #14566
  {33,  3,   0}, // #14567
  {35,  3,   0}, // #14568
  {36,  3,   0}, // #14569
  {37,  3,   0}, // #14570
  {39,  3,   0}, // #14571
  {40,  3,   0}, // #14572
  {42,  1,   0}, // #14573
  {43,  1,   0}, // #14574
  {14,  3,   0}, // #14575
  {25,  3,   0}, // #14576
  {27,  3,   0}, // #14577
  {28,  3,   0}, // #14578
  {33,  3,   0}, // #14579
  {35,  3,   0}, // #14580
  {36,  3,   0}, // #14581
  {37,  3,   0}, // #14582
  {39,  3,   0}, // #14583
  {40,  3,   0}, // #14584
  {14,  3,   0}, // #14585
  {16,  2,   0}, // #14586
  {19,  1,   0}, // #14587
  {20,  2,   0}, // #14588
  {21,  2,   0}, // #14589
  {24,  2,   0}, // #14590
  {25,  2,   0}, // #14591
  {27,  2,   0}, // #14592
  {28,  2,   0}, // #14593
  {29,  2,   0}, // #14594
  {30,  1,   0}, // #14595
  {33,  2,   0}, // #14596
  {34,  2,   0}, // #14597
  {35,  2,   0}, // #14598
  {36,  2,   0}, // #14599
  {37,  2,   0}, // #14600
  {39,  2,   0}, // #14601
  {40,  2,   0}, // #14602
  {42,  1,   0}, // #14603
  {43,  1,   0}, // #14604
  {14,  2,   0}, // #14605
  {16,  2,   0}, // #14606
  {20,  2,   0}, // #14607
  {21,  2,   0}, // #14608
  {24,  2,   0}, // #14609
  {25,  2,   0}, // #14610
  {27,  2,   0}, // #14611
  {28,  2,   0}, // #14612
  {29,  2,   0}, // #14613
  {33,  2,   0}, // #14614
  {34,  2,   0}, // #14615
  {35,  2,   0}, // #14616
  {36,  2,   0}, // #14617
  {37,  2,   0}, // #14618
  {39,  2,   0}, // #14619
  {40,  2,   0}, // #14620
  {14, 19,   0}, // #14621
  {16, 18,   0}, // #14622
  {19,  1,   0}, // #14623
  {20, 18,   0}, // #14624
  {21, 18,   0}, // #14625
  {24, 18,   0}, // #14626
  {25, 18,   0}, // #14627
  {27, 18,   0}, // #14628
  {28, 18,   0}, // #14629
  {29, 18,   0}, // #14630
  {30,  1,   0}, // #14631
  {33, 18,   0}, // #14632
  {34, 18,   0}, // #14633
  {35, 18,   0}, // #14634
  {36, 18,   0}, // #14635
  {37, 18,   0}, // #14636
  {39, 18,   0}, // #14637
  {40, 18,   0}, // #14638
  {42,  1,   0}, // #14639
  {43,  1,   0}, // #14640
  {14, 18,   0}, // #14641
  {16, 18,   0}, // #14642
  {20, 18,   0}, // #14643
  {21, 18,   0}, // #14644
  {24, 18,   0}, // #14645
  {25, 18,   0}, // #14646
  {27, 18,   0}, // #14647
  {28, 18,   0}, // #14648
  {29, 18,   0}, // #14649
  {33, 18,   0}, // #14650
  {34, 18,   0}, // #14651
  {35, 18,   0}, // #14652
  {36, 18,   0}, // #14653
  {37, 18,   0}, // #14654
  {39, 18,   0}, // #14655
  {40, 18,   0}, // #14656
  {42, 30,   0}, // #14657
  { 4,  1,   0}, // #14658
  {11,  2,   0}, // #14659
  {41,  3,   0}, // #14660
  {42,  1,   0}, // #14661
  {43,  1,   0}, // #14662
  { 4,  3,   0}, // #14663
  {41,  3,   0}, // #14664
  {42,  1,   0}, // #14665
  {43,  1,   0}, // #14666
  { 4,  1,   0}, // #14667
  {11, 12,   0}, // #14668
  {41, 13,   0}, // #14669
  {42,  1,   0}, // #14670
  {43,  1,   0}, // #14671
  {11, 24,   0}, // #14672
  {41, 24,   0}, // #14673
  {11, 59,   0}, // #14674
  {41, 59,   0}, // #14675
  {10,  6,   0}, // #14676
  {11,  6,   0}, // #14677
  {41,  6,   0}, // #14678
  {10,  8,   0}, // #14679
  {11,  8,   0}, // #14680
  {41,  8,   0}, // #14681
  { 4,  1,   0}, // #14682
  {14,  1,   0}, // #14683
  {15,  1,   0}, // #14684
  {20,  1,   0}, // #14685
  {21,  1,   0}, // #14686
  {24,  1,   0}, // #14687
  {28,  1,   0}, // #14688
  {29,  1,   0}, // #14689
  {33,  1,   0}, // #14690
  {34,  1,   0}, // #14691
  {36,  1,   0}, // #14692
  {37,  1,   0}, // #14693
  {38,  1,   0}, // #14694
  {41,  1,   0}, // #14695
  {42,  1,   0}, // #14696
  {43,  1,   0}, // #14697
  { 4,  1,   0}, // #14698
  {14, 24,   0}, // #14699
  {28, 24,   0}, // #14700
  {33, 24,   0}, // #14701
  {36, 24,   0}, // #14702
  {37, 24,   0}, // #14703
  {41,  1,   0}, // #14704
  {42,  1,   0}, // #14705
  {43,  1,   0}, // #14706
  { 4,  1,   0}, // #14707
  {14, 62,   0}, // #14708
  {28, 62,   0}, // #14709
  {33, 62,   0}, // #14710
  {36, 62,   0}, // #14711
  {37, 62,   0}, // #14712
  {41,  1,   0}, // #14713
  {42,  1,   0}, // #14714
  {43,  1,   0}, // #14715
  { 4,  1,   0}, // #14716
  {11,  4,   0}, // #14717
  {41,  5,   0}, // #14718
  {42,  1,   0}, // #14719
  {44,  1,   0}, // #14720
  { 4,  1,   0}, // #14721
  {14,  1,   0}, // #14722
  {16,  1,   0}, // #14723
  {20,  1,   0}, // #14724
  {21,  1,   0}, // #14725
  {24,  1,   0}, // #14726
  {25,  1,   0}, // #14727
  {27,  1,   0}, // #14728
  {28,  1,   0}, // #14729
  {29,  1,   0}, // #14730
  {33,  1,   0}, // #14731
  {34,  1,   0}, // #14732
  {35,  1,   0}, // #14733
  {36,  1,   0}, // #14734
  {37,  1,   0}, // #14735
  {39,  1,   0}, // #14736
  {40,  1,   0}, // #14737
  {41,  1,   0}, // #14738
  {42,  1,   0}, // #14739
  {43,  1,   0}, // #14740
  {14,  1,   0}, // #14741
  {15,  1,   0}, // #14742
  {19,  1,   0}, // #14743
  {20,  1,   0}, // #14744
  {21,  1,   0}, // #14745
  {24,  1,   0}, // #14746
  {28,  1,   0}, // #14747
  {29,  1,   0}, // #14748
  {32,  1,   0}, // #14749
  {33,  1,   0}, // #14750
  {34,  1,   0}, // #14751
  {36,  1,   0}, // #14752
  {37,  1,   0}, // #14753
  {38,  1,   0}, // #14754
  {42,  1,   0}, // #14755
  {44,  1,   0}, // #14756
  { 4,  1,   0}, // #14757
  {14,  8,   0}, // #14758
  {28,  8,   0}, // #14759
  {33,  8,   0}, // #14760
  {36,  8,   0}, // #14761
  {37,  8,   0}, // #14762
  {41,  1,   0}, // #14763
  {42,  1,   0}, // #14764
  {43,  1,   0}, // #14765
  {14,  3,   0}, // #14766
  {28,  3,   0}, // #14767
  {33,  3,   0}, // #14768
  {36,  3,   0}, // #14769
  {37,  3,   0}, // #14770
  { 4,  1,   0}, // #14771
  {14,  3,   0}, // #14772
  {28,  3,   0}, // #14773
  {33,  3,   0}, // #14774
  {36,  3,   0}, // #14775
  {37,  3,   0}, // #14776
  {41,  1,   0}, // #14777
  {42,  1,   0}, // #14778
  {43,  1,   0}, // #14779
  { 4,  1,   0}, // #14780
  {14,  2,   0}, // #14781
  {28,  2,   0}, // #14782
  {33,  2,   0}, // #14783
  {36,  2,   0}, // #14784
  {37,  2,   0}, // #14785
  {41,  1,   0}, // #14786
  {42,  1,   0}, // #14787
  {43,  1,   0}, // #14788
  { 4,  1,   0}, // #14789
  {11,  7,   0}, // #14790
  {41,  8,   0}, // #14791
  {42,  2,   0}, // #14792
  {43,  1,   0}, // #14793
  {44,  1,   0}, // #14794
  { 4,  1,   0}, // #14795
  {10,  8,   0}, // #14796
  {11,  8,   0}, // #14797
  {41,  9,   0}, // #14798
  {42,  1,   0}, // #14799
  {43,  1,   0}, // #14800
  { 4,  1,   0}, // #14801
  {14,  2,   0}, // #14802
  {16,  2,   0}, // #14803
  {20,  2,   0}, // #14804
  {21,  2,   0}, // #14805
  {24,  2,   0}, // #14806
  {25,  2,   0}, // #14807
  {27,  2,   0}, // #14808
  {28,  2,   0}, // #14809
  {29,  2,   0}, // #14810
  {33,  2,   0}, // #14811
  {34,  2,   0}, // #14812
  {35,  2,   0}, // #14813
  {36,  2,   0}, // #14814
  {37,  2,   0}, // #14815
  {39,  2,   0}, // #14816
  {40,  2,   0}, // #14817
  {41,  1,   0}, // #14818
  {42,  1,   0}, // #14819
  {43,  1,   0}, // #14820
  {14,  1,   0}, // #14821
  {30,  1,   0}, // #14822
  {14,  6,   0}, // #14823
  {22,  6,   0}, // #14824
  {23,  6,   0}, // #14825
  {26,  6,   0}, // #14826
  {27,  6,   0}, // #14827
  {28,  6,   0}, // #14828
  {31,  6,   0}, // #14829
  {33,  6,   0}, // #14830
  {36,  6,   0}, // #14831
  {37,  6,   0}, // #14832
  {14,  4,   0}, // #14833
  {25,  4,   0}, // #14834
  {27,  4,   0}, // #14835
  {28,  4,   0}, // #14836
  {33,  4,   0}, // #14837
  {35,  4,   0}, // #14838
  {36,  4,   0}, // #14839
  {37,  4,   0}, // #14840
  {39,  4,   0}, // #14841
  {40,  4,   0}, // #14842
  {14,  5,   0}, // #14843
  {25,  5,   0}, // #14844
  {27,  5,   0}, // #14845
  {28,  5,   0}, // #14846
  {33,  5,   0}, // #14847
  {35,  5,   0}, // #14848
  {36,  5,   0}, // #14849
  {37,  5,   0}, // #14850
  {39,  5,   0}, // #14851
  {40,  5,   0}, // #14852
  {14,  3,   0}, // #14853
  {20,  3,   0}, // #14854
  {21,  3,   0}, // #14855
  {24,  3,   0}, // #14856
  {28,  3,   0}, // #14857
  {29,  3,   0}, // #14858
  {33,  3,   0}, // #14859
  {34,  3,   0}, // #14860
  {36,  3,   0}, // #14861
  {37,  3,   0}, // #14862
  {14,  5,   0}, // #14863
  {20,  5,   0}, // #14864
  {21,  5,   0}, // #14865
  {24,  5,   0}, // #14866
  {28,  5,   0}, // #14867
  {29,  5,   0}, // #14868
  {33,  5,   0}, // #14869
  {34,  5,   0}, // #14870
  {36,  5,   0}, // #14871
  {37,  5,   0}, // #14872
  {14,  6,   0}, // #14873
  {20,  2,   0}, // #14874
  {21,  2,   0}, // #14875
  {22,  2,   0}, // #14876
  {23,  2,   0}, // #14877
  {24,  2,   0}, // #14878
  {25,  2,   0}, // #14879
  {26,  2,   0}, // #14880
  {27,  4,   0}, // #14881
  {28,  6,   0}, // #14882
  {29,  2,   0}, // #14883
  {31,  2,   0}, // #14884
  {33,  6,   0}, // #14885
  {34,  2,   0}, // #14886
  {35,  2,   0}, // #14887
  {36,  6,   0}, // #14888
  {37,  6,   0}, // #14889
  {39,  2,   0}, // #14890
  {40,  2,   0}, // #14891
  {14,  2,   0}, // #14892
  {27,  2,   0}, // #14893
  {28,  2,   0}, // #14894
  {33,  2,   0}, // #14895
  {36,  2,   0}, // #14896
  {37,  2,   0} // #14897
}; // X86WriteProcResTable

// {Cycles, WriteResourceID}
extern const llvm::MCWriteLatencyEntry X86WriteLatencyTable[] = {
  { 0,  0}, // Invalid
  { 1,  0}, // #1 WriteALU_WriteZero_WriteVecALU_WriteJump_WriteMove_WriteLEA_WriteRMW_WriteADC_WriteFSign_WriteNop_WriteFLogic_WriteFBlend_WriteFVarBlend_WriteBSWAP32_WriteBitTest_WriteBitTestSet_WriteCMOV_WriteFCom_WriteVecALUX_WriteFLDC_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteFLD0_WriteFLD1_WriteVecMoveX_WriteVecShiftImm_WriteFMoveX_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVarShuffleX_WriteVecShiftImmX_WriteShift_WriteShuffleY_WriteFLogicY_WriteFBlendY_WriteVecALUY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecLogicY_WriteBlendY_WriteFVarShuffleY_WriteVecShiftImmY_WriteVarVecShift_WriteVarVecShiftY_WriteVarShuffleY_ADLPWriteResGroup40_ADLPWriteResGroup155_ADLPWriteResGroup151_ADLPWriteResGroup188_ADLPWriteResGroup189_ADLPWriteResGroup57_ADLPWriteResGroup21_ADLPWriteResGroup54_ADLPWriteResGroup22_ADLPWriteResGroup191_ADLPWriteResGroup6_ADLPWriteResGroup212_ADLPWriteResGroup173_ADLPWriteResGroup74_ADLPWriteResGroup77_ADLPWriteResGroup85_ADLPWriteResGroup128_ADLPWriteResGroup129_ADLPWriteResGroup130_ADLPWriteResGroup137_ADLPWriteResGroup144_ADLPWriteResGroup187_ADLPWriteResGroup210_ADLPWriteResGroup235_WriteCMPXCHGRMW_WriteJumpLd_WriteFStoreX_WriteFLoadX_AtomWrite0_1_WriteADCLd_WriteALULd_WriteFLogicLd_WriteBSWAP64_WriteBitTestImmLd_WriteCMOVLd_WriteLoad_WriteStore_WriteVecExtractSt_WriteVecALUXLd_WriteFShuffleLd_WriteVecLoadX_WriteFence_WriteVecStoreX_WriteVecMoveFromGpr_WriteVecStoreNT_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteVarShuffleLd_WriteVecLoadNT_WriteStoreNT_WriteFStoreNTX_WriteShuffleXLd_WriteVecLogicXLd_WriteRotate_WriteRotateCL_WriteShiftLd_WriteShiftCL_WriteSETCC_WriteVecShiftImmXLd_WriteFTestLd_AtomWrite1_1_AtomWrite0_1_1_AtomWrite01_1_WriteSHDrri_WriteLAHFSAHF_WriteVecMoveToGpr_WriteVecTest_WriteSETCCStore_WriteSHDrrcl_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WriteFStoreY_WriteBZHI_WriteFCMOV_WriteXCHG_WriteFComX_WriteFSqrt80_WriteSTMXCSR_WriteShuffle256_WriteVarShuffle256_WriteVecStoreY_WriteVPMOV256_WriteVecTestY_WriteFTestY_PdWriteTST_F_UCOM_FPPr_PdWriteLEA16r_PdWriteADCSBB64ri32_PdWriteVMOVUPDYmrVMOVUPSYmr_PdWriteVMOVDQUYmr_PdWriteMOVDQArr_PdWriteSETGEmSETGmSETLEmSETLm_WriteBLS_WriteMMXMOVMSK_WriteVecStoreNTY_WriteFStoreNTY_BWWriteResGroup10_BWWriteResGroup2_BWWriteResGroup5_BWWriteResGroup6_BWWriteResGroup3_BWWriteResGroup4_BWWriteResGroup7_BWWriteResGroup8_BWWriteResGroup9_WriteBEXTR_WriteLZCNT_WritePHAdd_WritePOPCNT_WriteFShuffle256_JWriteVecExtractF128_JWriteZeroIdiomYmm_WriteShuffleZ_WriteFLogicZ_WriteVecALUZ_WriteFMoveZ_WriteFShuffleZ_WriteVecMoveZ_WriteVecLogicZ_WriteFVarShuffleZ_WriteVecShiftImmZ_WriteVarVecShiftZ_WriteVarShuffleZ_SKXWriteResGroup9_SKXWriteResGroup11_SKXWriteResGroup3_SKXWriteResGroup6_SKXWriteResGroup7_SKXWriteResGroup4_SKXWriteResGroup8_SKXWriteResGroup10_SKXWritePSUB_WriteCvtSS2SD_WriteFVarShuffle256_SBWriteResGroup2_SBWriteResGroup1_SBWriteResGroup4_SBWriteResGroup5_SBWriteResGroupVzeroupper_WriteBitTestRegLd_HWWriteBTRSCmr_HWWrite2P1_HWWriteP01_HWWrite2P01_HWWrite2P0156_P23_HWWriteResGroup1_HWWriteINTO_HWWritePushA_HWWritePopA_HWWriteP1_HWWriteBOUND_HWWriteResGroup3_HWWriteResGroup6_HWWriteResGroup7_HWWrite3P01_HWWriteP0156_P23_HWWriteRETI_HWWriteRDPMC_HWWriteRDRAND_HWWriteFNSAVE_HWWriteFRSTOR_HWWriteResGroup2_HWWriteResGroup4_HWWriteResGroup5_HWWriteResGroup8_HWWriteResGroup9_HWWriteResGroup10_HWWriteADC0_WriteFVarBlendY_WriteFVarBlendZ_WriteVarBlendY_WriteVarBlendZ_SPRWriteResGroup43_SPRWriteResGroup164_SPRWriteResGroup160_SPRWriteResGroup193_SPRWriteResGroup52_SPRWriteResGroup61_SPRWriteResGroup23_SPRWriteResGroup58_SPRWriteResGroup24_SPRWriteResGroup195_SPRWriteResGroup216_SPRWriteResGroup95_SPRWriteResGroup137_SPRWriteResGroup92_SPRWriteResGroup78_SPRWriteResGroup81_SPRWriteResGroup89_SPRWriteResGroup138_SPRWriteResGroup139_SPRWriteResGroup140_SPRWriteResGroup147_SPRWriteResGroup153_SPRWriteResGroup192_SPRWriteResGroup214_SPRWriteResGroup240_SPRWriteResGroup508_ICXWriteResGroup9_ICXWriteResGroup11_ICXWriteResGroup3_ICXWriteResGroup6_ICXWriteResGroup7_ICXWriteResGroup4_ICXWriteResGroup8_ICXWriteResGroup10_ICXWritePSUB_SKLWriteResGroup9_SKLWriteResGroup11_SKLWriteResGroup3_SKLWriteResGroup6_SKLWriteResGroup7_SKLWriteResGroup4_SKLWriteResGroup8_SKLWriteResGroup10_SKLWritePSUB_WriteFCmp64X_WriteFCmpX_WriteFMOVMSK_WriteVecMOVMSK_WriteVecShiftX_WriteFCmp64Y_WriteFCmpY_WriteVecShiftY_ZnWriteFPU3Lat1_ZnWriteFLDr_ZnWriteFPU0Lat1_ZnWriteFXCH_ZnWriteJCXZ_ZnWriteLD_F80m_ZnWriteLOOPE_ZnWriteCMPXCHG8B_ZnWriteRET_ZnWritePCMPGTQr_ZnWriteFPU01Y_ZnWriteCALLr_ZnXADD_ZnWriteFPU013_ZnWriteSHA1MSG2r_ZnWriteSHA1NEXTEr_Zn2WriteFPU3Lat1_Zn2WriteFLDr_Zn2WriteFPU0Lat1_Zn2WriteFXCH_Zn2WriteJCXZ_Zn2WriteLD_F80m_Zn2WriteLOOPE_Zn2WriteCMPXCHG8B_Zn2WriteRET_Zn2WritePCMPGTQr_Zn2WriteFPU01Y_Zn2WriteCALLr_Zn2XADD_Zn2WriteFPU013_Zn2WriteSHA1MSG2r_Zn2WriteSHA1NEXTEr_Zn2WriteXCHG_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_Zn3WriteLFENCE_Zn3WriteMoveExtend_Zn3WriteVecALUXMMX_Zn3WriteRotateR1_Zn3WriteMOVMMX_Zn3WriteSFENCE_Zn3WriteMOVBEmr_Zn3WriteCvtPD2IMMX_Zn3WriteSHA1MSG2rr_SHA1NEXTErr_Zn3WriteALUSlow_Zn3WriteMaterialize32bitImm_Zn3WriteADC8mr_SBB8mr_Zn3WriteWriteXCHGUnrenameable_Zn3WritePOPCNT16rr_Zn3WriteLZCNT16rr_Zn3WriteMOVMMXSlow_Zn3WriteVecALUXSlow_Zn3WriteVecALUYSlow_WriteBSF_WriteBSR_WriteCvtSD2I_WriteVecShiftZ_Zn4WriteLFENCE_Zn4WriteMoveExtend_Zn4WriteRotateR1_Zn4WriteMOVMMX_Zn4WriteSFENCE_Zn4WriteMOVBEmr_Zn4WriteSHA1MSG2rr_SHA1NEXTErr_Zn4WriteALUSlow_Zn4WriteMaterialize32bitImm_Zn4WriteADC8mr_SBB8mr_Zn4WriteWriteXCHGUnrenameable_Zn4WritePOPCNT16rr_Zn4WriteLZCNT16rr_Zn4WriteMOVMMXSlow_Zn4WriteVecALUYSlow_Zn4WriteVecOpMask_Zn4WriteVecOpMaskMemMov_Zn4WriteVecOpMaskKRMov_Zn4WriteSHIFTri
  {12,  0}, // #2 WriteCMPXCHGRMW_WriteFStoreX_WriteFStoreY_WriteRMW_WriteAESDecEncLd_WriteAESKeyGenLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtSD2SSLd_WriteCvtSS2ILd_WriteStore_WriteFHAddLd_WriteVecStoreX_WriteShiftLd_WriteSHDmrcl_WriteSHDmri_WriteFSqrtX_WriteSTMXCSR_WriteFCmp64YLd_WriteFCmpYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFMAYLd_WriteVecStoreY_WriteMPSADYLd_WriteFMul64YLd_WriteFMulYLd_WriteVecTestYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFSqrtY_ADLPWriteResGroup36_ADLPWriteResGroup179_ADLPWriteResGroup50_ADLPWriteResGroup176_ADLPWriteResGroup139_ADLPWriteResGroup120_ADLPWriteResGroup142_ADLPWriteResGroup115_ADLPWriteResGroup229_ADLPWriteResGroup69_ADLPWriteResGroup127_ADLPWriteResGroup134_WriteIMul64Ld_WriteIMul64RegLd_WriteDPPD_WriteFRcpXLd_WriteFRsqrtXLd_WriteDiv8_WriteVecExtract_WriteIDiv8_WriteFMOVMSK_WriteCLMul_WritePCmpIStrMLd_WriteVecMOVMSK_PdWriteRCL8rCL_PdWriteRCR8ri_PdWriteVPCLMULQDQrri_WriteMPSADLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteFRndYLd_BWWriteResGroup135_WriteCvtSS2SDLd_WritePCmpIStrILd_WriteDPPSY_WriteCLMulLd_WriteVecIMulYLd_WriteVecIMulZLd_SKXWriteResGroup200_SKXWriteResGroup175_SKXWriteResGroup176_SKXWriteResGroup177_WriteAESIMC_WritePSADBWYLd_WritePSADBWZLd_WriteFHAddYLd_WriteFMul64ZLd_WriteFMulZLd_WritePMULLDYLd_WritePMULLDZLd_SBWriteResGroup111_WriteFRndLd_WriteFMAZLd_WriteCvtI2PDZLd_WriteCvtPD2IZLd_HWWriteResGroup91_3_WriteFAddYLd_WriteFAddZLd_WriteFCmpZLd_WriteCvtI2PSZLd_WriteCvtPS2PHZSt_WriteFRndZLd_WriteFCmp64ZLd_SPRWriteResGroup37_SPRWriteResGroup185_SPRWriteResGroup54_SPRWriteResGroup182_SPRWriteResGroup554_SPRWriteResGroup148_SPRWriteResGroup129_SPRWriteResGroup151_SPRWriteResGroup124_SPRWriteResGroup235_SPRWriteResGroup449_SPRWriteResGroup504_SPRWriteResGroup501_SPRWriteResGroup505_SPRWriteResGroup502_SPRWriteResGroup257_SPRWriteResGroup73_SPRWriteResGroup136_SPRWriteResGroup144_SPRWriteResGroup265_SPRWriteResGroup272_SPRWriteResGroup303_SPRWriteResGroup347_SPRWriteResGroup351_SPRWriteResGroup419_SPRWriteResGroup444_SPRWriteResGroup446_SPRWriteResGroup465_SPRWriteResGroup467_SPRWriteResGroup489_SPRWriteResGroup517_SPRWriteResGroup518_SPRWriteResGroup546_ICXWriteResGroup200_ICXWriteResGroup175_ICXWriteResGroup176_ICXWriteResGroup177_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFMAXLd_ZnWriteCVTPD2DQLd_ZnWriteFIST_ZnWriteFPU03_ZnWriteCVSTSI2SILd_Zn2WriteFIST_Zn2WriteFPU03_WriteVarShuffle256Ld_WriteFRcpZLd_WriteFRsqrtZLd
  { 6,  0}, // #3 WriteJumpLd_WriteBEXTR_WriteBitTestImmLd_WriteFHAdd_WriteCvtPH2PS_WriteCvtPS2PH_WriteVecTestY_ADLPWriteResGroup95_ADLPWriteResGroup5_ADLPWriteResGroup94_ADLPWriteResGroup154_ADLPWriteResGroup238_ADLPWriteResGroup53_ADLPWriteResGroup234_ADLPWriteResGroup30_ADLPWriteResGroup209_ADLPWriteResGroup111_ADLPWriteResGroup232_ADLPWriteResGroup224_ADLPWriteResGroup228_ADLPWriteResGroup141_ADLPWriteResGroup153_WriteFAdd64X_WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2SD_WriteIMul16Reg_WriteIMul16Imm_WriteIMul32_WriteFLD1_AtomWrite01_6_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCMPXCHG_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLZCNTLd_WritePHAdd_WritePHAddX_WritePOPCNTLd_WriteFRndLd_WriteTZCNTLd_PdWriteALURMW_WriteRMW_WriteBEXTRLd_WriteBLSLd_WriteIMul64_WriteIMul64Reg_WriteIMul64Imm_WriteVecInsertLd_WriteStore_WriteVecTestLd_WriteShuffle256Ld_WriteVarShuffle256Ld_WriteFMaskedStore64Y_WriteFMaskedLoadY_WriteFMaskedStore32Y_WriteVecMaskedLoadY_WriteVPMOV256Ld_WriteVecTestYLd_WriteFTestYLd_WriteFTestLd_PdWriteXLAT_PdWriteXADDm_PdWriteVBROADCASTYLd_PdWriteFCOMPm_PdWriteMMX_CVTPD2PIrrMMX_CVTPI2PDrr_PdWriteLXADD_PdWriteBMI1m_PdWriteCRC32r32r32_PdWriteMMX_CVTTPD2PIrr_WriteFLoadY_WriteADCLd_WriteALULd_WriteFLogicLd_WriteFBlendLd_WriteBitTestRegLd_WriteBZHILd_WriteCMOVLd_WriteCvtPS2PDLd_WriteCvtSS2SDLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVarShuffleLd_WriteVecShiftLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WriteVarShuffleXLd_WriteShiftLd_WriteSHDrrcl_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecShiftImmXLd_BWWriteResGroup69_BWWriteResGroup66_BWWriteResGroup70_BWWriteResGroup58_BWWriteResGroup71_BWWriteResGroup36b_BWWriteResGroup65_BWWriteResGroup62_BWWriteResGroup68_BWWriteResGroup59_BWWriteResGroup64_WriteIMul16Ld_WriteIMul16RegLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddLd_WriteFLogicYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFShuffleYLd_JWriteVBROADCASTYLd_WriteFLoadX_WriteCvtSD2I_WriteCvtSS2I_WriteVecLoadX_WriteCLMul_WriteCvtPS2PHSt_WriteFHAddY_SKXWriteResGroup86_SKXWriteResGroup72_SKXWriteResGroup81_SKXWriteResGroup82_SKXWriteResGroup87_SKXWriteResGroup88_SKXWriteResGroup44c_SKXWriteResGroup71_SKXWriteResGroup76_SKXWriteResGroup84_SKXWriteResGroup92a_SKXWriteResGroup79_SKXWriteResGroup73_SKXWriteResGroup80_SBWriteResGroup48_SBWriteResGroup53_SBWriteResGroup81_SBWriteResGroup49_SBWriteResGroup51_SBWriteResGroup52_WriteCvtI2PDZ_WriteCvtPD2IZ_WriteCvtPS2PHZ_WriteFRndZ_HWWriteResGroup18_HWWriteResGroup108_HWWriteResGroup60b_HWWriteResGroup0_HWWriteResGroup14_HWWriteResGroup107_HWWriteResGroup13_HWWriteResGroup16_SPRWriteResGroup104_SPRWriteResGroup5_SPRWriteResGroup103_SPRWriteResGroup163_SPRWriteResGroup243_SPRWriteResGroup57_SPRWriteResGroup239_SPRWriteResGroup32_SPRWriteResGroup213_SPRWriteResGroup120_SPRWriteResGroup237_SPRWriteResGroup230_SPRWriteResGroup234_SPRWriteResGroup494_SPRWriteResGroup150_SPRWriteResGroup162_SPRWriteResGroup251_SPRWriteResGroup253_SPRWriteResGroup365_SPRWriteResGroup437_SPRWriteResGroup438_SPRWriteResGroup443_SPRWriteResGroup520_SPRWriteResGroup538_ICXWriteResGroup86_ICXWriteResGroup72_ICXWriteResGroup81_ICXWriteResGroup82_ICXWriteResGroup87_ICXWriteResGroup88_ICXWriteResGroup44c_ICXWriteResGroup71_ICXWriteResGroup76_ICXWriteResGroup84_ICXWriteResGroup79_ICXWriteResGroup73_ICXWriteResGroup80_SKLWriteResGroup82_SKLWriteResGroup68_SKLWriteResGroup76_SKLWriteResGroup78_SKLWriteResGroup83_SKLWriteResGroup84_SKLWriteResGroup42c_SKLWriteResGroup67_SKLWriteResGroup72_SKLWriteResGroup80_SKLWriteResGroup88_SKLWriteResGroup75_SKLWriteResGroup69_ZnWriteBTRSCm_ZnWriteSHA1RNDS4r_Zn2WriteBTRSCm_Zn2WriteSHA1RNDS4r_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrM_WriteSHDmrcl_WriteSHDmri_Zn3WriteXCHG32rm_XCHG64rm_Zn3Writerm_SHA256MSG1rm_Zn3WriteSHA1RNDS4rri_Zn3WriteSHA1MSG1rm_Zn3WriteVPERMYri_WriteCvtPD2PSZ_WriteCvtPS2PDZ_Zn4WriteXCHG32rm_XCHG64rm_Zn4Writerm_SHA256MSG1rm_Zn4WriteSHA1RNDS4rri_Zn4WriteSHA1MSG1rm_Zn4WriteVPERMYri_Zn4WriteSCALErr_Zn4WriteBF16_Zn4CONFLICTrr
  {100,  0}, // #4 WriteSystem_WriteMicrocoded_ADLPWriteResGroup168_ADLPWriteResGroup198_ADLPWriteResGroup68_ADLPWriteResGroup269_ADLPWriteResGroup27_ADLPWriteResGroup201_ADLPWriteResGroup203_ADLPWriteResGroup28_ADLPWriteResGroup82_ADLPWriteResGroup96_ADLPWriteResGroup97_ADLPWriteResGroup98_ADLPWriteResGroup99_ADLPWriteResGroup100_ADLPWriteResGroup101_ADLPWriteResGroup135_ADLPWriteResGroup166_ADLPWriteResGroup167_ADLPWriteResGroup184_ADLPWriteResGroup185_ADLPWriteResGroup186_ADLPWriteResGroup199_ADLPWriteResGroup200_ADLPWriteResGroup205_ADLPWriteResGroup218_ADLPWriteResGroup236_ADLPWriteResGroup239_ADLPWriteResGroup270_SPRWriteResGroup177_SPRWriteResGroup202_SPRWriteResGroup72_SPRWriteResGroup556_SPRWriteResGroup29_SPRWriteResGroup205_SPRWriteResGroup207_SPRWriteResGroup30_SPRWriteResGroup86_SPRWriteResGroup105_SPRWriteResGroup106_SPRWriteResGroup107_SPRWriteResGroup108_SPRWriteResGroup109_SPRWriteResGroup110_SPRWriteResGroup145_SPRWriteResGroup175_SPRWriteResGroup176_SPRWriteResGroup189_SPRWriteResGroup190_SPRWriteResGroup191_SPRWriteResGroup203_SPRWriteResGroup204_SPRWriteResGroup209_SPRWriteResGroup224_SPRWriteResGroup241_SPRWriteResGroup244_SPRWriteResGroup557_SPRWriteResGroup576_ZnWriteMicrocoded_Zn2WriteMicrocoded
  { 3,  0}, // #5 WriteSHDrri_WriteFAdd64X_WriteFAddX_WriteBSF_WriteBSR_WriteBZHI_WriteFCMOV_WriteCMPXCHG_WriteFComX_WriteCRC32_WriteIMul16Reg_WriteIMul32Reg_WriteIMul32Imm_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteLAHFSAHF_WriteLZCNT_WriteVecMoveToGpr_WriteVecMoveFromGpr_WritePHAdd_WriteMMXMOVMSK_WritePSADBW_WriteVarShuffle_WriteFMOVMSK_WriteCLMul_WriteVecMOVMSK_WritePOPCNT_WritePSADBWX_WriteTZCNT_WriteFAdd64Y_WriteFAddY_WriteFVarBlendY_WriteShuffle256_WriteFShuffle256_WriteVarShuffle256_WritePSADBWY_WriteVarBlendY_WriteFVarShuffle256_WriteVPMOV256_WriteFTest_ADLPWriteResGroup23_ADLPWriteResGroup104_ADLPWriteResGroup103_ADLPWriteResGroup63_ADLPWriteResGroup118_ADLPWriteResGroup20_ADLPWriteResGroup64_ADLPWriteResGroup170_ADLPWriteResGroup119_ADLPWriteResGroup24_ADLPWriteResGroup19_ADLPWriteResGroup226_ADLPWriteResGroup16_ADLPWriteResGroup124_ADLPWriteResGroup8_ADLPWriteResGroup217_ADLPWriteResGroup245_WriteVecShiftLd_WriteVecShiftXLd_AtomWrite01_3_WriteFLoadX_WriteLoad_WriteXCHG_WriteFCmp64X_WriteFCmpX_WriteVecLoadX_WriteVecLoadNT_WriteFRnd_WriteFMaskedLoad_WriteVecMaskedLoad_WriteCMPXCHGRMW_WriteFLDC_WriteFLD0_WriteFLD1_WriteFStoreNTX_WriteVarShuffleX_WriteSHDrrcl_WriteFStoreNTY_WriteFVarShuffleY_WriteVarVecShift_PdWriteCMPXCHG8rm_PdWriteCMPXCHG8rr_PdWriteCMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm_PdWriteCMPXCHG8B_PdWriteCMPXCHG16B_PdWriteEXTRQ_PdWriteINSERTQI_PdWriteSHLD16rrCLSHLD32rrCLSHRD32rrCL_WriteCvtI2PS_WriteCvtPS2I_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHAddX_WriteRotateCL_WriteShiftCL_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMul64Y_WriteFMulY_WritePHAddY_WriteVecMOVMSKY_WriteVarVecShiftY_BWWriteResGroup34_BWWriteResGroup38_BWWriteResGroup37_BWWriteResGroup27_BWWriteResGroup28_BWWriteResGroup33_BWWriteSETA_SETBEm_WriteAESDecEnc_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteVecExtractSt_WriteLDMXCSR_WriteMPSAD_WriteVecTest_WriteCvtPH2PSY_WriteCvtI2PDY_WriteCvtPS2PH_WriteFRndY_JSlowLEA16r_JWriteCMPXCHG8rr_WriteCvtPS2PD_WriteCvtSS2SD_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2IZ_WriteCvtPS2PDY_WriteCvtPS2PDZ_WritePSADBWZ_WriteVecTestY_SKXWriteResGroup42_SKXWriteResGroup34_SKXWriteResGroup48_SKXWriteResGroup47_SKXWriteResGroup45_SKXWriteResGroup43_SKXWriteResGroup31_SKXWriteResGroup32_SKXWriteResGroup41_SKXWriteResGroup30_SKXWriteResGroup37_SKXWriteResGroup38_SKXWritePCMPGTQ_SKXWriteSETA_SETBEm_WriteVecALU_WriteFAdd64Z_WriteFAddZ_WriteFCmpZ_WriteCvtI2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHY_WriteCvtPS2PHZ_WriteFRndZ_WriteFCmp64Z_SBWriteResGroup30_SBWriteResGroup21_SBWriteResGroup22_SBWriteResGroup24_SBWriteResGroup26_2_SBWriteCMOVA_CMOVBErr_SBWriteSETA_SETBEm_WriteVarVecShiftZ_HWWriteResGroup58_HWWriteResGroup45_HWWriteResGroup44_HWWriteResGroup50_HWWriteResGroup51_HWWriteResGroup57_HWWriteCMOVA_CMOVBErr_HWWriteSETA_SETBEm_WriteMove_WriteShuffleZ_WriteVecALUZ_WriteVarShuffleZ_SPRWriteResGroup25_SPRWriteResGroup113_SPRWriteResGroup112_SPRWriteResGroup67_SPRWriteResGroup127_SPRWriteResGroup22_SPRWriteResGroup68_SPRWriteResGroup128_SPRWriteResGroup26_SPRWriteResGroup21_SPRWriteResGroup232_SPRWriteResGroup18_SPRWriteResGroup133_SPRWriteResGroup418_SPRWriteResGroup250_SPRWriteResGroup96_SPRWriteResGroup263_SPRWriteResGroup223_SPRWriteResGroup260_SPRWriteResGroup267_SPRWriteResGroup441_ICXWriteResGroup42_ICXWriteResGroup34_ICXWriteResGroup48_ICXWriteResGroup47_ICXWriteResGroup45_ICXWriteResGroup43_ICXWriteResGroup31_ICXWriteResGroup32_ICXWriteResGroup41_ICXWriteResGroup30_ICXWriteResGroup37_ICXWriteResGroup38_ICXWritePCMPGTQ_ICXWriteSETA_SETBEm_SKLWriteResGroup40_SKLWriteResGroup32_SKLWriteResGroup46_SKLWriteResGroup45_SKLWriteResGroup43_SKLWriteResGroup41_SKLWriteResGroup29_SKLWriteResGroup30_SKLWriteResGroup39_SKLWriteResGroup35_SKLWriteResGroup36_SKLWritePCMPGTQ_SKLWriteSETA_SETBEm_ZnWriteCVTPS2PDr_ZnWriteMul16_ZnWriteMul32_ZnWriteVCVTPS2PDY_Zn2WriteCVTPD2PSr_Zn2WriteCVTPS2PDr_Zn2WriteCVTSS2SDr_Zn2WriteMul16_Zn2WriteMul32_Zn2WriteCVTPD2PSYr_Zn2WriteVCVTPS2PDY_WriteFTestY_Zn2WriteCVTPD2DQr_Zn2WriteCVTDQ2PDr_Zn2WriteCVSTSI2SDr_Zn2WriteEXTRQ_WriteCvtSD2SS_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WritePHMINPOS_WritePMULLD_WriteFRcpX_WriteFRsqrtX_WriteVecIMulY_WritePMULLDY_WriteFRcpY_WriteFRsqrtY_Zn3WriteCvtI2PSMMX_Zn3WriteCMPXCHG8rr_Zn3WriteCMPXCHG8B_Zn3WriteRotateRightRI_Zn3WriteRotateRightRCL_Zn3WriteVPERM2I128rr_VPERM2F128rr_Zn3WriteEXTRQI_INSERTQI_Zn3WriteSHA256MSG2rr_Zn3WritePDEP_PEXT_Zn3WriteEXTRQ_INSERTQ_WriteVecIMulZ_WriteFMul64Z_WriteFMulZ_WriteFVarShuffleZ_WritePMULLDZ_Zn4WriteCMPXCHG8rr_Zn4WriteCMPXCHG8B_Zn4WriteRotateRightRI_Zn4WriteRotateRightRCL_Zn4WriteVPERM2I128rr_VPERM2F128rr_Zn4WriteEXTRQI_INSERTQI_Zn4WriteSHA256MSG2rr_Zn4WritePDEP_PEXT_Zn4WriteEXTRQ_INSERTQ_Zn4VPTESTZ128_Zn4PERMIT2_128
  { 7,  0}, // #6 WriteFLoadX_WriteAESKeyGen_WriteBLSLd_WriteCMOVLd_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteVecLoadX_WriteLDMXCSR_WriteVecLoadNT_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2PDY_ADLPWriteResGroup112_ADLPWriteResGroup152_ADLPWriteResGroup92_ADLPWriteResGroup58_ADLPWriteResGroup278_ADLPWriteResGroup208_ADLPWriteResGroup241_ADLPWriteResGroup78_ADLPWriteResGroup18_ADLPWriteResGroup52_ADLPWriteResGroup195_ADLPWriteResGroup106_ADLPWriteResGroup140_ADLPWriteResGroup0_ADLPWriteResGroup12_ADLPWriteResGroup13_ADLPWriteResGroup41_ADLPWriteResGroup143_ADLPWriteResGroup256_WriteFAdd64XLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteIMul16_WriteIMul16RegLd_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul8Ld_WritePHAddX_AtomWrite0_1_7_AtomWrite0_1_7_4_AtomWrite01_7_WriteFVarBlendLd_WriteCvtSD2SSLd_WriteIMul64_WriteVecIMulLd_WritePSADBWLd_WriteMPSAD_WriteFMul64X_WriteVarBlendLd_WritePHMINPOSLd_WriteFRcpLd_WriteFRsqrtLd_SLMWriteResGroup1rm_WriteFLogicLd_WriteFBlendLd_WriteBSFLd_PdWriteBTSIm_PdWriteBTSRm_WriteFCmp64Ld_WriteFCmpLd_WriteVecALUXLd_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteShuffleXLd_WriteVecLogicXLd_WriteBlendLd_WritePCmpIStrM_WritePHAddXLd_WriteShuffleYLd_WriteFLogicYLd_WriteFVarBlendYLd_WriteFBlendYLd_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteFShuffleYLd_WriteVecShiftImmXLd_PdWriteRCR32riRCR64ri_PdWriteVBROADCASTF128_PdWriteVEXTRACTF128mr_PdWriteRCL3264rCL_PdWriteRCR3264rCL_PdWriteVPPERMLd_WriteRMW_WriteAESDecEnc_WriteBEXTRLd_WriteVecShiftXLd_WriteVecTestLd_WriteCvtPS2PHYSt_WriteVecALUYLd_WriteFMaskedLoad_WriteMPSADY_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoad_WriteVecShiftImmYLd_WriteVarShuffleYLd_WriteVecShiftYLd_WriteFTestYLd_BWWriteResGroup80_BWWriteResGroup82_BWWriteResGroup90_BWWriteResGroup84_BWWriteResGroup89_BWWriteResGroup87_BWWriteResGroup88_BWWriteResGroup73_BWWriteResGroup77_BWWriteResGroup79_BWWriteResGroup74_BWWriteCMOVA_CMOVBErm_WriteAESIMCLd_WriteAESKeyGenLd_WriteCvtPS2PDLd_WriteVecIMulXLd_WriteVarShuffleLd_WriteFMulXLd_WriteFMulLd_WriteCLMulLd_WritePCmpIStrI_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRcpXLd_WriteFRsqrtXLd_WriteCvtPS2PDYLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_WriteFLoadY_WriteFComXLd_WriteFComLd_WriteCvtPH2PSY_WriteCvtPD2PSZ_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WriteVecLoadY_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVarVecShiftLd_SKXWriteResGroup100_SKXWriteResGroup99_SKXWriteResGroup95_SKXWriteResGroup89_SKXWriteResGroup101_SKXWriteResGroup111_SKXWriteResGroup104_SKXWriteResGroup109_SKXWriteResGroup107_SKXWriteResGroup108_SKXWriteResGroup96_SKXWriteResGroup90_SKXWriteResGroup93_SKXWriteResGroup92_SKXWriteResGroup93z_SKXWriteResGroup97_SKXWriteResGroup103_SKXWriteResGroup106_SKXWriteResGroup110_SKXWriteResGroup112_SKXWriteResGroup113_SKXWriteResGroup114_SKXWriteCMOVA_CMOVBErm_WriteADCLd_WriteVecInsertLd_WriteCvtPS2PDZLd_WriteFRcpZ_WriteFRsqrtZ_WriteFTestLd_SBWriteResGroup69_SBWriteResGroup25_1_SBWriteResGroup63_SBWriteResGroup68_SBWriteResGroup54_SBWriteResGroup58_SBWriteResGroup59_SBWriteResGroup62_SBWriteResGroup64_SBWriteResGroup66_SBWriteResGroup67_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WriteCvtPS2PHZSt_HWWriteResGroup25_HWWriteResGroup37_HWWriteResGroup26_HWWriteResGroup0_1_HWWriteResGroup39_HWWriteXLAT_HWWriteResGroup114_HWWriteResGroup41_HWWriteResGroup17_HWWriteResGroup11_1_HWWriteResGroup36_2_WriteCvtPD2IZ_SPRWriteResGroup121_SPRWriteResGroup161_SPRWriteResGroup82_SPRWriteResGroup62_SPRWriteResGroup565_SPRWriteResGroup212_SPRWriteResGroup246_SPRWriteResGroup20_SPRWriteResGroup199_SPRWriteResGroup115_SPRWriteResGroup149_SPRWriteResGroup464_SPRWriteResGroup39_SPRWriteResGroup268_SPRWriteResGroup0_SPRWriteResGroup15_SPRWriteResGroup44_SPRWriteResGroup152_SPRWriteResGroup415_SPRWriteResGroup93_SPRWriteResGroup271_SPRWriteResGroup470_SPRWriteResGroup486_SPRWriteResGroup488_ICXWriteResGroup100_ICXWriteResGroup99_ICXWriteResGroup95_ICXWriteResGroup89_ICXWriteResGroup101_ICXWriteResGroup111_ICXWriteResGroup104_ICXWriteResGroup109_ICXWriteResGroup107_ICXWriteResGroup108_ICXWriteResGroup96_ICXWriteResGroup92_ICXWriteResGroup90_ICXWriteResGroup93_ICXWriteResGroup93z_ICXWriteResGroup97_ICXWriteResGroup103_ICXWriteResGroup106_ICXWriteResGroup110_ICXWriteResGroup112_ICXWriteResGroup113_ICXWriteResGroup114_ICXWriteCMOVA_CMOVBErm_SKLWriteResGroup95_SKLWriteResGroup94_SKLWriteResGroup91_SKLWriteResGroup85_SKLWriteResGroup96_SKLWriteResGroup103_SKLWriteResGroup98_SKLWriteResGroup102_SKLWriteResGroup100_SKLWriteResGroup101_SKLWriteResGroup92_SKLWriteCMOVA_CMOVBErm_WriteFHAdd_WriteIMulHLd_WriteFHAddY_Zn2WriteMul16Ld_Zn2WriteMul32Ld_WriteMULX32Ld_WriteMULX64Ld_WriteFCMOV_WriteCRC32Ld_WriteIMul16Ld_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64Ld_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFVarShuffle256_Zn3WriteCMPXCHG8rm_LCMPXCHG8_Zn3WriteVPERM2F128rm_Zn3WriteSHA256MSG2rm_Zn3WriteXCHG8rm_XCHG16rm_Zn3WriteRotateRightMI_Zn3WriteRotateRightMCL_WriteDPPD_Zn4WriteCMPXCHG8rm_LCMPXCHG8_Zn4WriteVPERM2F128rm_Zn4WriteSHA256MSG2rm_Zn4WriteXCHG8rm_XCHG16rm_Zn4WriteRotateRightMI_Zn4WriteRotateRightMCL_Zn4WriteVPERMPSYrr
  { 8,  0}, // #7 WriteFLoadY_WriteAESIMC_WriteFLogicLd_WriteFBlendLd_WriteFVarBlendLd_WriteBSFLd_WriteBSRLd_WriteBZHILd_WriteFComXLd_WriteCRC32Ld_WriteFComLd_WriteVecALUXLd_WriteIMul16RegLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteIMul64RegLd_WriteIMul64ImmLd_WriteIMul8Ld_WriteFShuffleLd_WriteLZCNTLd_WriteVecInsertLd_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlendLd_WriteBlendLd_WritePOPCNTLd_WriteVarShuffleXLd_WriteVecShiftXLd_WriteFRnd_WriteTZCNTLd_WriteCvtPH2PSY_WriteCvtPS2PHY_WriteFRndY_WriteVecLoadY_WriteFMaskedLoad_WriteVecLoadNTY_WriteFVarShuffleLd_WriteVecMaskedLoad_WriteVarVecShiftLd_WriteFTestLd_ADLPWriteResGroup37_ADLPWriteResGroup38_ADLPWriteResGroup171_ADLPWriteResGroup117_ADLPWriteResGroup172_ADLPWriteResGroup110_ADLPWriteResGroup225_ADLPWriteResGroup192_ADLPWriteResGroup147_ADLPWriteResGroup150_ADLPWriteResGroup175_ADLPWriteResGroup216_ADLPWriteResGroup240_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteFHAdd_WriteIMul16Ld_WritePHAddXLd_AtomWrite01_8_WriteAESDecEnc_WriteAESKeyGen_WriteCvtI2PSLd_WriteCvtPD2PSLd_WriteCvtPS2ILd_WriteCvtSD2ILd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2ILd_WriteVecIMulXLd_WriteIMul32Ld_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePSADBWXLd_SLMWriteResGroup2rm_WriteVarShuffleLd_WriteVecShiftLd_WriteMPSAD_WriteCvtI2PDY_WriteCvtPD2PSY_WriteCvtPD2IY_WriteCvtPS2PDY_WriteFVarShuffleYLd_PdWriteVPERM2F128rm_PdWriteRCL3264ri_WriteCMPXCHGRMW_BWWriteResGroup100_WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteIMul16ImmLd_WritePHAddLd_WriteFMul64XLd_WriteMULX32Ld_WriteMULX64Ld_WriteFVarBlendYLd_WriteFMaskedLoadY_WriteVarBlendYLd_WriteVecMaskedLoadY_BWWriteResGroup97_BWWriteResGroup99_BWWriteResGroup154_BWWriteResGroup91_BWWriteResGroup92_WriteAESDecEncLd_WriteVecMoveFromGpr_WriteMPSADLd_WritePCmpIStrM_WriteVecTestLd_WriteFRndLd_WriteFAdd64YLd_WriteFAddYLd_WriteCvtI2PDYLd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_WriteFRndYLd_SKXWriteResGroup130_WriteCvtSS2SDLd_WritePSADBWLd_WriteShuffleYLd_WriteShuffleZLd_WriteFLogicYLd_WriteFLogicZLd_WriteFBlendYLd_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteCvtPS2IZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteCvtPS2PHYSt_WriteCvtPS2PHZSt_WriteFRndZ_WriteVecALUYLd_WriteVecALUZLd_WriteFShuffleYLd_WriteFShuffleZLd_WriteVecLogicYLd_WriteVecLogicZLd_WriteBlendYLd_WriteVarBlendZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_WriteVarShuffleYLd_WriteVarShuffleZLd_WriteVecShiftYLd_WriteVecShiftZLd_SKXWriteResGroup127_SKXWriteResGroup128_SKXWriteResGroup118_SKXWriteResGroup119_SKXWriteResGroup121_SKXWriteResGroup123_SKXWriteResGroup131_SKXWriteResGroup132_SKXWriteResGroup133_SKXWriteResGroup134_WriteVecALULd_WriteSHDmri_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_SBWriteResGroup86_SBWriteResGroup84_SBWriteResGroup77_SBWriteResGroup83_SBWriteResGroup85_SBWriteResGroup87_SBWriteCMOVA_CMOVBErm_HWWriteResGroup12_HWWriteResGroup48_HWWriteResGroup46_HWWriteResGroup47_HWWriteResGroup145_HWWriteResGroup11_2_HWWriteResGroup13_1_HWWriteResGroup17_2_HWWriteCMOVA_CMOVBErm_WriteVecShiftImmXLd_SPRWriteResGroup40_SPRWriteResGroup41_SPRWriteResGroup178_SPRWriteResGroup126_SPRWriteResGroup179_SPRWriteResGroup119_SPRWriteResGroup231_SPRWriteResGroup196_SPRWriteResGroup383_SPRWriteResGroup289_SPRWriteResGroup156_SPRWriteResGroup159_SPRWriteResGroup181_SPRWriteResGroup222_SPRWriteResGroup245_SPRWriteResGroup219_SPRWriteResGroup283_SPRWriteResGroup291_SPRWriteResGroup297_SPRWriteResGroup320_SPRWriteResGroup343_SPRWriteResGroup361_SPRWriteResGroup362_SPRWriteResGroup484_SPRWriteResGroup506_SPRWriteResGroup521_SPRWriteResGroup533_ICXWriteResGroup130_ICXWriteResGroup127_ICXWriteResGroup128_ICXWriteResGroup118_ICXWriteResGroup119_ICXWriteResGroup121_ICXWriteResGroup123_ICXWriteResGroup131_ICXWriteResGroup132_ICXWriteResGroup133_ICXWriteResGroup134_SKLWriteResGroup119_SKLWriteResGroup116_SKLWriteResGroup117_SKLWriteResGroup107_SKLWriteResGroup108_SKLWriteResGroup110_SKLWriteResGroup112_WriteFLoadX_ZnWriteMul16Ld_ZnWriteMul32Ld_WriteVecLoadX_ZnWriteFPU13_WriteShuffleLd_WriteVecLogicLd_WriteFStoreNT_WriteFCmp64YLd_WriteFCmpYLd_ZnWriteLEAVE_ZnWritePushA_ZnWritePCMPGTQm_ZnWriteBROADCAST_ZnWriteFPU01Op2_ZnWriteVPBROADCAST256Ld_ZnWritePCMPGTQYm_ZnWriteFPU0Lat1Ld_ZnWriteVPBROADCAST128Ld_ZnWriteFPU013m_ZnWriteSHA1MSG2Ld_ZnWriteSHA1NEXTELd_Zn2WriteMul64Ld_Zn2WriteFPU13_Zn2WriteLEAVE_Zn2WritePushA_Zn2WritePCMPGTQm_Zn2WriteBROADCAST_Zn2WriteFPU01Op2_Zn2WriteVPBROADCAST256Ld_Zn2WritePCMPGTQYm_Zn2WriteFPU0Lat1Ld_Zn2WriteVPBROADCAST128Ld_Zn2WriteFPU013m_Zn2WriteSHA1MSG2Ld_Zn2WriteSHA1NEXTELd_WriteFLD0_WriteVecTestYLd_Zn3WriteVINSERTF128rmr_Zn3WriteVEXTRACTI128mr_Zn3WriteRotateLeftMI_Zn3WriteRotateLeftMCL_WriteFVarBlendZLd_Zn4WriteVINSERTF128rmr_Zn4WriteVEXTRACTI128mr_Zn4WriteRotateLeftMI_Zn4WriteRotateLeftMCL
  {11,  0}, // #8 WriteADCLd_WriteALULd_WriteBEXTRLd_WriteBitTestRegLd_WriteFCmp64XLd_WriteFCmpXLd_WriteFCmp64Ld_WriteFCmpLd_WriteCvtI2PDLd_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtPS2PDLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDivX_WritePHAddLd_WritePSADBWLd_WriteVarShuffleLd_WriteMPSADLd_WriteFMul64XLd_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpIStrI_WritePCmpIStrM_WritePHMINPOSLd_WriteFRcpXLd_WriteFRcpLd_WriteFRsqrtXLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WritePSADBWYLd_WriteFDivY_WriteFMAXLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WriteFTestYLd_ADLPWriteResGroup56_ADLPWriteResGroup156_ADLPWriteResGroup263_ADLPWriteResGroup123_AtomWrite01_11_WriteCvtPD2PS_WriteCvtSD2SSLd_WriteAESDecEncLd_WriteAESIMCLd_WriteAESKeyGenLd_WritePMULLD_WriteFHAdd_WriteVecMoveToGpr_WriteVecMoveFromGpr_WriteFHAddY_PdWriteRCR8rCL_PdWriteRCL16ri_BWWriteResGroup122_1_WriteFRndLd_WriteSHDmrcl_WriteFSqrtX_WriteCvtI2PDYLd_WriteFMAYLd_WriteVecIMulYLd_WriteFHAddYLd_WriteFRcpY_WriteFRsqrtY_BWWriteResGroup133_BWWriteResGroup123_BWWriteResGroup131_BWWriteResGroup132_WriteCMPXCHGRMW_WriteDPPS_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_JWriteCMPXCHG8B_JWriteCMPXCHG8rm_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteVecIMulXLd_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteFCmp64ZLd_WriteMPSADYLd_WriteFMul64YLd_WriteFMul64ZLd_WriteFMulYLd_WriteFMulZLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_SKXWriteResGroup171_SKXWriteResGroup162_SKXWriteResGroup160_SKXWriteResGroup169_SKXWriteResGroup170_SKXWriteResGroup166_SKXWriteResGroup148_2_SKXWriteResGroup161_SKXWriteResGroup164_SKXWriteResGroup167_WriteFHAddLd_WritePCmpEStrM_WritePMULLDLd_WritePSADBWXLd_WriteCvtPD2PSZLd_WriteCvtPD2IZLd_WriteVecShiftYLd_WriteVecShiftZLd_SBWriteResGroup108_SBWriteResGroup104_SBWriteResGroup106_WriteCLMul_WriteVecTestYLd_WriteFRsqrtZ_HWWriteResGroup131_HWWriteFRNDINT_HWWriteResGroup91_2_HWWriteResGroup75_HWWriteResGroup129_HWWriteResGroup130_WriteFAddXLd_WriteCvtPH2PSZ_WriteCvtPS2PHZ_WritePSADBWZLd_WriteVarShuffleZLd_SPRWriteResGroup60_SPRWriteResGroup165_SPRWriteResGroup258_SPRWriteResGroup132_SPRWriteResGroup417_SPRWriteResGroup255_SPRWriteResGroup313_SPRWriteResGroup455_SPRWriteResGroup483_SPRWriteResGroup254_SPRWriteResGroup317_SPRWriteResGroup321_SPRWriteResGroup354_SPRWriteResGroup374_SPRWriteResGroup482_SPRWriteResGroup515_SPRWriteResGroup535_SPRWriteResGroup537_WriteCvtPD2PSLd_ICXWriteResGroup171_ICXWriteResGroup162_ICXWriteResGroup160_ICXWriteResGroup169_ICXWriteResGroup170_ICXWriteResGroup166_ICXWriteResGroup148_2_ICXWriteResGroup161_ICXWriteResGroup164_ICXWriteResGroup167_WriteCvtPD2ILd_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteCvtPS2PDYLd_SKLWriteResGroup156_SKLWriteResGroup149_SKLWriteResGroup146_SKLWriteResGroup154_SKLWriteResGroup155_ZnWriteCVTPD2PSLd_ZnWriteCVTSS2SDLd_ZnWriteFPU3_WriteVecIMulLd_ZnWriteCVTPD2PSYLd_WriteFRndYLd_WritePMULLDYLd_ZnWriteFILD_ZnWriteSHA256RNDS2Ld_Zn2WriteFPU3_Zn2WriteFILD_Zn2WriteCVSTSI2SILd_Zn2WriteSHA256RNDS2Ld_WriteFComXLd_WriteDiv16_WriteFLDC_WriteIDiv16_WriteFLD1_WriteCLMulLd_WriteCvtPH2PSYLd_Zn3WriteVPERMPSYrm_WriteCvtI2PDZLd_WriteCvtPS2IZLd_WriteCvtPH2PSZLd_WriteFDivZ_WriteDPPSY_Zn4WriteVPERMPSYrm
  {10,  0}, // #9 WriteFAdd64XLd_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteEMMS_WriteIMul16Ld_WriteCLMulLd_WritePMULLD_WritePSADBWXLd_WriteFVarBlendYLd_WriteVarBlendYLd_WritePHAddYLd_WritePMULLDY_ADLPWriteResGroup9_ADLPWriteResGroup169_ADLPWriteResGroup266_ADLPWriteResGroup15_WriteFComXLd_WriteCvtSD2SS_AtomWrite01_10_WriteFMul64XLd_WriteFRcpXLd_WriteFRsqrtXLd_AtomWrite0_1_10_WriteCMPXCHGRMW_WriteBSF_WriteBSR_WriteIMul64Ld_WriteLDMXCSR_WriteMPSADLd_WriteAESIMCLd_WriteAESKeyGenLd_WriteIMul64RegLd_WriteIMul64ImmLd_WritePHAddLd_WriteMMXMOVMSK_WriteFMulXLd_WriteFMul64Ld_WriteFMulLd_WritePCmpEStrM_WritePMULLDLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFAdd64YLd_WriteFAddYLd_WriteFMAXLd_WriteFMAYLd_WriteFMul64YLd_WriteFMulYLd_WriteFRcpYLd_WriteFRsqrtYLd_PdWriteCRC32r64r64_PdWriteRCL16rCL_PdWriteRCR16ri_PdWriteVFRCZP_PdWriteVFRCZS_PdWriteVFRCZY_WriteVecIMulXLd_WriteFHAddLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WriteVecTestYLd_BWWriteResGroup115_BWWriteResGroup117_WriteAESDecEncLd_WriteFCmp64XLd_WriteFCmpXLd_WriteCvtSD2SSLd_WritePCmpIStrI_WritePCmpIStrM_WriteShuffle256Ld_WriteFShuffle256Ld_WriteVarShuffle256Ld_WriteCvtPH2PSYLd_WriteCvtPH2PSZLd_WritePSADBWYLd_WritePSADBWZLd_WriteFVarShuffle256Ld_WriteVPMOV256Ld_WritePMULLDZ_SKXWriteResGroup148_SKXWriteResGroup157_SKXWriteResGroup154_SKXWriteResGroup136_2_SKXWriteResGroup149_SKXWriteResGroup151_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtSD2ILd_WriteCvtI2SSLd_WriteCvtSS2ILd_WritePCmpEStrILd_WriteSHDmrcl_WriteFMAZLd_WriteFAdd64ZLd_WriteFAddZLd_WriteFCmp64YLd_WriteFCmpYLd_WriteFCmpZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSYLd_WriteCvtI2PSZLd_WriteCvtPS2IYLd_WriteCvtPS2IZLd_WriteFRndYLd_WriteFRndZLd_WriteFCmp64ZLd_SBWriteResGroup101_WriteSHDmri_WriteCvtPD2PSZLd_WriteCvtPS2PDYLd_WriteCvtPS2PDZLd_WriteVarVecShiftYLd_WriteVarVecShiftZLd_HWWriteResGroup52_1_SPRWriteResGroup10_SPRWriteResGroup485_SPRWriteResGroup389_SPRWriteResGroup17_SPRWriteResGroup8_SPRWriteResGroup259_SPRWriteResGroup264_SPRWriteResGroup284_SPRWriteResGroup290_SPRWriteResGroup292_SPRWriteResGroup298_SPRWriteResGroup334_SPRWriteResGroup344_SPRWriteResGroup350_SPRWriteResGroup358_SPRWriteResGroup410_SPRWriteResGroup413_SPRWriteResGroup431_SPRWriteResGroup432_SPRWriteResGroup479_SPRWriteResGroup511_SPRWriteResGroup513_ICXWriteResGroup148_ICXWriteResGroup157_ICXWriteResGroup154_ICXWriteResGroup136_2_ICXWriteResGroup149_ICXWriteResGroup151_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtI2SDLd_WriteCvtSS2SDLd_SKLWriteResGroup133_SKLWriteResGroup143_SKLWriteResGroup138_SKLWriteResGroup140_WriteCRC32Ld_ZnWriteCVTPS2PDLd_WriteFDivX_WriteFComLd_WritePHAddXLd_WriteFDivY_WriteVarVecShiftLd_Zn2WriteCVTPD2PSLd_Zn2WriteCVTPS2PDLd_Zn2WriteCVTSS2SDLd_WriteVecTestLd_WriteFRndLd_Zn2WriteCVTPD2PSYLd_WriteFVarShuffleYLd_WriteFVarShuffleLd_WriteFTestYLd_WriteFTestLd_Zn2WriteCVTPD2DQLd_WriteCvtPS2PDLd_WriteDiv8_WriteIDiv8_WriteCvtPH2PSLd_WriteVecIMulYLd_WritePMULLDYLd_Zn3WriteVZEROALL_Zn3WriteVPERMPDYmi_WriteCvtPD2IYLd_WriteCvtPD2IZLd_WriteVecIMulZLd_WriteFMul64ZLd_WriteFMulZLd_WriteFVarShuffleZLd_WritePMULLDZLd_Zn4WriteVZEROALL_Zn4WriteVPERMPDYmi
  { 5,  0}, // #10 WriteAESDecEnc_WriteLoad_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtPS2PD_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecIMulX_WriteIMul16_WriteSHDrrcl_WriteVecIMulY_WriteFHAddY_WriteFTestY_ADLPWriteResGroup180_ADLPWriteResGroup181_ADLPWriteResGroup102_ADLPWriteResGroup242_ADLPWriteResGroup288_ADLPWriteResGroup182_ADLPWriteResGroup230_ADLPWriteResGroup29_ADLPWriteResGroup70_ADLPWriteResGroup126_ADLPWriteResGroup132_ADLPWriteResGroup254_ADLPWriteResGroup258_WriteFAddXLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFCom_WriteFComLd_WriteEMMS_WriteVecIMulXLd_WriteIMul32RegLd_WriteIMul32ImmLd_WriteLDMXCSR_WriteFMulXLd_WriteFMul64Ld_WritePSADBWXLd_WriteVarShuffleXLd_WriteFRndLd_AtomWrite1_5_AtomWrite0_1_5_AtomWrite01_5_WriteRMW_WriteCMOVLd_WriteCvtI2PS_WriteCvtPS2I_WriteCvtSD2I_WriteCvtI2SD_WriteCvtI2SS_WriteCvtSS2I_WriteIMul64Reg_WriteIMul64Imm_WriteIMul8_WriteVecShiftLd_WriteVecShiftXLd_SLMWriteResGroup2rr_WriteJumpLd_WriteFLoadX_WriteFLoadY_WriteADCLd_WriteALULd_WriteFAdd64X_WriteAESIMC_WriteAESKeyGen_WriteBitTestImmLd_WriteBitTestRegLd_WriteBZHILd_WriteIMul16Imm_WriteVecLoadX_WritePHAdd_WriteVecLoadNT_WriteFMul64X_WritePMULLD_WriteFRcpX_WriteShiftLd_WriteFRsqrtX_WriteFAdd64Y_WriteFAddY_WriteFMAX_WriteFMAY_WriteVecLoadY_WriteVecLoadNTY_WriteFMul64Y_WriteFMulY_WriteFRcpY_WriteFRsqrtY_PdWriteX87Add_PdWriteX87Mul_PdWriteCRC32r32r16_PdWriteCMOVm_WriteCMPXCHG_WriteCLMul_WritePHMINPOS_WriteCvtPS2PHSt_WritePSADBWY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_BWWriteResGroup50_BWWriteResGroup54_BWWriteResGroup36_BWWriteResGroup57_BWWriteResGroup49_BWWriteResGroup47_BWWriteResGroup51_BWWriteResGroup55_BWWritePCMPGTQ_WriteBLSLd_WriteBSR_WriteTZCNTLd_WriteCvtPH2PS_WriteVecIMulZ_SKXWriteResGroup61_SKXWriteResGroup44b_SKXWriteResGroup69_SKXWriteResGroup63_SKXWriteResGroup67_SKXWriteResGroup62_SKXWriteResGroup65_SKXWriteResGroup66_WriteVecExtractSt_WriteSTMXCSR_WritePSADBWZ_WriteFMAZ_WriteFMul64Z_WriteFMulZ_WritePMULLDY_WritePMULLDZ_SBWriteResGroup33_SBWriteResGroup41_SBWriteResGroup47_SBWriteResGroup76_SBWriteResGroup35_SBWriteResGroup35_2_SBWriteResGroup36_SBWriteResGroup40_SBWriteResGroup45_SBWriteResGroup46_SBWritePCMPGTQ_HWWriteResGroup93_HWWriteResGroup99_HWWriteResGroup60_HWWriteResGroup88_HWWriteResGroup89_HWWriteResGroup94_HWWriteResGroup100_HWWritePCMPGTQ_SPRWriteResGroup186_SPRWriteResGroup111_SPRWriteResGroup247_SPRWriteResGroup575_SPRWriteResGroup187_SPRWriteResGroup236_SPRWriteResGroup367_SPRWriteResGroup340_SPRWriteResGroup31_SPRWriteResGroup74_SPRWriteResGroup135_SPRWriteResGroup142_SPRWriteResGroup414_SPRWriteResGroup252_SPRWriteResGroup463_SPRWriteResGroup469_ICXWriteResGroup61_ICXWriteResGroup44b_ICXWriteResGroup69_ICXWriteResGroup63_ICXWriteResGroup67_ICXWriteResGroup62_ICXWriteResGroup65_ICXWriteResGroup66_SKLWriteResGroup60_SKLWriteResGroup42b_SKLWriteResGroup65_SKLWriteResGroup61_SKLWriteResGroup63_WriteBEXTRLd_WriteStore_WritePOPCNTLd_WriteCvtI2PDY_WriteCvtI2PSY_ZnWriteCVTPD2PSYr_WriteCvtPD2IY_WriteCvtPS2IY_ZnWriteCVTPD2DQr_ZnWriteSTr_ZnWriteXCHGrm_ZnWriteST_FP80m_ZnWriteEXTRACTPSm_ZnWriteMOVBE_ZnWritePop16r_ZnWriteCVTDQ2PDr_ZnWriteCVSTSI2SDr_ZnWriteCVSTSI2SIr_WriteLZCNTLd_Zn2WriteSTr_Zn2WriteXCHGrm_Zn2WriteST_FP80m_Zn2WriteEXTRACTPSm_Zn2WriteMOVBE_Zn2WritePop16r_WriteVarShuffle256_Zn3WriteMOVSlow_Zn3WriteX87Arith_Zn3WriteX87Div_Zn3Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn3WriteRotateM1_WriteBSFLd_WriteBSRLd_WriteFRcpZ_WriteFRsqrtZ_Zn4WriteMOVSlow_Zn4WriteX87Arith_Zn4WriteX87Div_Zn4Writerm_SHA1MSG2rm_SHA1NEXTErm_Zn4WriteRotateM1_Zn4WriteVPERMDYrr_Zn4MOVSrr_Zn4VPTESTZ_Zn4VRSQRT14PDZ256_Zn4PERMIT2Z
  {15,  0}, // #11 WriteAESIMCLd_WriteDiv32_WriteIDiv32_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_ADLPWriteResGroup44_WriteCMPXCHG_WriteSTMXCSR_WriteDPPDLd_WriteDPPS_WriteDiv16_WriteIDiv16_WritePCmpEStrMLd_PdWriteVFRCZm_PdWriteVFRCZYm_WritePMULLDLd_BWWriteResGroup149_BWWriteResGroup147_WriteDiv8Ld_WriteIDiv8Ld_WriteFRndYLd_WriteFRndZLd_SKXWriteResGroup195_SKXWriteResGroup191_SKXWriteResGroup174_SKXWriteResGroup174z_SKXWriteResGroup194_SBWriteResGroup119_HWWriteResGroup115_HWWriteFXTRACT_HWWriteResGroup188_WriteCvtPD2PSZLd_SPRWriteResGroup47_SPRWriteResGroup299_SPRWriteResGroup266_SPRWriteResGroup498_SPRWriteResGroup500_SPRWriteResGroup473_SPRWriteResGroup300_SPRWriteResGroup218_SPRWriteResGroup269_SPRWriteResGroup281_SPRWriteResGroup304_SPRWriteResGroup311_SPRWriteResGroup328_SPRWriteResGroup341_SPRWriteResGroup382_SPRWriteResGroup393_SPRWriteResGroup397_SPRWriteResGroup408_SPRWriteResGroup411_SPRWriteResGroup475_SPRWriteResGroup493_ICXWriteResGroup195_ICXWriteResGroup191_ICXWriteResGroup174_ICXWriteResGroup174z_ICXWriteResGroup194_SKLWriteResGroup174_SKLWriteResGroup171_WriteFDiv64Y_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtX_WriteDPPSY_WriteFSqrtY_WriteFSqrtZ
  { 2,  0}, // #12 WriteBLS_WriteBSWAP64_WriteXCHG_WriteFence_WritePHAddX_WriteVecShiftX_WriteRotate_WriteRotateCL_WriteShiftCL_WriteSETCC_WritePHAddY_ADLPWriteResGroup243_ADLPWriteResGroup268_ADLPWriteResGroup84_ADLPWriteResGroup62_ADLPWriteResGroup105_ADLPWriteResGroup55_ADLPWriteResGroup39_ADLPWriteResGroup219_ADLPWriteResGroup93_ADLPWriteResGroup222_ADLPWriteResGroup178_ADLPWriteResGroup11_ADLPWriteResGroup14_ADLPWriteResGroup25_WriteSHDrri_AtomWrite01_2_WriteLAHFSAHF_WriteStore_WriteSETCCStore_WriteSHDrrcl_WriteCMOV_WriteVecALU_WriteFLogic_WriteBEXTR_WriteFBlend_WriteFVarBlend_WriteBitTestSet_WriteFCmp64X_WriteFCmpX_WriteCRC32_WriteVecALUX_WriteEMMS_WriteFShuffle_WriteVecLogicX_WriteShuffle_WriteLZCNT_WriteVecStore_WriteVecStoreNT_WriteVecMove_WriteVecInsert_WriteVecShiftImm_WriteFStore_WriteShuffleX_WriteVarBlend_WriteBlend_WriteVecShiftImmX_WriteTZCNT_WriteShuffleY_WriteFLogicY_WriteFVarBlendY_WriteFBlendY_WriteFShuffle256_WriteFCmp64Y_WriteFCmpY_WriteFMoveY_WriteFShuffleY_WriteVecMoveY_WriteVecStoreNTY_PdWriteLAHF_PdWriteVEXTRACTF128rr_PdWriteMOVHPm_PdWriteBMI1_PdWriteSAHF_PdWriteBEXTRI_PdWriteBEXTRIm_PdWriteVPPERM_PdWrite3OpsLEA_WriteCvtPS2PD_WriteCvtSS2SD_WriteVecExtractSt_WriteVecTest_WriteSTMXCSR_WriteCvtPH2PSY_WriteVarBlendY_BWWriteResGroup14_BWWriteResGroup20_BWWriteResGroup22_BWWriteResGroup12_BWWriteResGroup17_BWWriteResGroup35_BWWriteResGroup25_BWWriteResGroup16_BWWriteResGroup18_BWWriteResGroup24_BWWriteResGroup87_1_BWWriteCMOVA_CMOVBErr_BWWriteSETA_SETBEr_WriteRMW_WriteFSign_WriteAESIMC_WriteAESKeyGen_WriteVecIMulX_WritePSADBW_WriteVarShuffle_WriteFMulX_WriteCLMul_WritePHMINPOS_WritePSADBWX_WriteVarShuffleX_WriteFRcpX_WriteFRsqrtX_WriteCvtPS2PDY_WriteFMulY_WriteFRcpY_WriteFRsqrtY_JWriteXCHG8rr_XADDrr_JWriteINSERTQ_JWrite3OpsLEA_WriteFComX_WriteVecMoveToGpr_WriteMMXMOVMSK_WriteFMOVMSK_WriteVecMOVMSK_WriteFVarBlendZ_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVarBlendZ_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_WriteVecMOVMSKY_WriteFTestY_SKXWriteResGroup17_SKXWriteResGroup23_SKXWriteResGroup25_SKXWriteResGroup14_SKXWriteResGroup44_SKXWriteResGroup28_SKXWriteResGroup20_SKXWriteResGroup13_SKXWriteResGroup21_SKXWriteResGroup27_SKXWriteResGroup107_1_SKXWriteResGroup29_SKXWriteCMOVA_CMOVBErr_SKXWriteSETA_SETBEr_WriteADC_WriteCvtPS2PDZ_WriteVecTestY_SBWriteResGroup18_SBWriteResGroup11_SBWriteResGroup12_SBWriteResGroup15_SBWriteResGroup23_SBWriteSETA_SETBEr_WriteCvtPH2PSZ_HWWriteResGroup30_HWWriteResGroup35_HWWriteResGroup21_HWWriteResGroup28_HWWriteResGroup33_HWWriteResGroup59_HWWriteResGroup24_HWWriteResGroup32_HWWriteResGroup19_HWWriteResGroup23_HWWriteResGroup23_16_HWWriteResGroup46_1_HWWriteSETA_SETBEr_SPRWriteResGroup248_SPRWriteResGroup555_SPRWriteResGroup88_SPRWriteResGroup66_SPRWriteResGroup114_SPRWriteResGroup59_SPRWriteResGroup42_SPRWriteResGroup28_SPRWriteResGroup225_SPRWriteResGroup102_SPRWriteResGroup228_SPRWriteResGroup184_SPRWriteResGroup13_SPRWriteResGroup16_SPRWriteResGroup27_SPRWriteResGroup491_SPRWriteResGroup509_SPRWriteResGroup514_ICXWriteResGroup17_ICXWriteResGroup23_ICXWriteResGroup25_ICXWriteResGroup14_ICXWriteResGroup44_ICXWriteResGroup28_ICXWriteResGroup20_ICXWriteResGroup13_ICXWriteResGroup21_ICXWriteResGroup27_ICXWriteResGroup107_1_ICXWriteResGroup29_ICXWriteCMOVA_CMOVBErr_ICXWriteSETA_SETBEr_SKLWriteResGroup17_SKLWriteResGroup23_SKLWriteResGroup25_SKLWriteResGroup14_SKLWriteResGroup42_SKLWriteResGroup28_SKLWriteResGroup20_SKLWriteResGroup13_SKLWriteResGroup21_SKLWriteResGroup27_SKLWriteResGroup100_1_SKLWriteCMOVA_CMOVBErr_SKLWriteSETA_SETBEr_WriteShuffle256_WriteVarShuffle256_WriteFVarShuffle256_ZnWriteEXTRACTPSr_ZnWriteVINSERT128r_ZnWriteEXTRQ_ZnWriteSHA1MSG1r_Zn2WriteEXTRACTPSr_Zn2WriteVINSERT128r_Zn2WriteSHA1MSG1r_WriteCvtSD2I_WriteCvtSS2I_WritePCmpIStrI_Zn3WriteCvtI2PDMMX_Zn3WriteSHA256MSG1rr_Zn3SlowLEA16r_Zn3WriteTZCNT16rr_Zn3WriteWriteFStoreMMX_Zn3WriteSHA1MSG1rr_Zn3Write3OpsLEA_WriteFCmpZ_WriteFCmp64Z_Zn4WriteSHA256MSG1rr_Zn4SlowLEA16r_Zn4WriteTZCNT16rr_Zn4WriteWriteFStoreMMX_Zn4WriteVecALUXSlow_Zn4WriteSHA1MSG1rr_Zn4WriteVFIXUPIMMPDZrr_VRANGESDrr_Zn4WriteSHIFTrr_Zn4WriteALIGN_Zn4WritePACK_Zn4WriteFCmp64_Zn4MOVDUPZ_Zn4MOVS_Zn4CONFLICTZ128_Zn4PERMILP_Zn4PERMIT2_128rr_Zn4VecALUZSlow_Zn4Write3OpsLEA
  {18,  0}, // #13 WriteRMW_WriteDiv64_WriteFDivXLd_WriteFDivLd_WriteIDiv64_WritePMULLDLd_WriteFSqrt64X_WritePMULLDYLd_WriteFSqrt64Y_ADLPWriteResGroup34_ADLPWriteResGroup206_ADLPWriteResGroup116_AtomWrite01_18_WriteDPPSLd_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteDiv32Ld_WriteDiv64Ld_WriteIDiv32Ld_WriteIDiv64Ld_WritePCmpEStrI_BWWriteResGroup160_BWWriteResGroup159_BWWriteResGroup183_2_WriteFSqrtXLd_WriteFDivYLd_WriteFDivZ_SKXWriteResGroup208_SKXWriteResGroup207_SKXWriteResGroupVEX2_WriteAESIMCLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup149_WriteCvtPS2IZLd_WritePMULLDZLd_SPRWriteResGroup36_SPRWriteResGroup210_SPRWriteResGroup125_SPRWriteResGroup286_SPRWriteResGroup288_SPRWriteResGroup294_SPRWriteResGroup296_SPRWriteResGroup312_SPRWriteResGroup318_SPRWriteResGroup319_SPRWriteResGroup329_SPRWriteResGroup335_SPRWriteResGroup345_SPRWriteResGroup348_SPRWriteResGroup352_SPRWriteResGroup356_ICXWriteResGroup208_ICXWriteResGroup207_ICXWriteResGroupVEX2_SKLWriteResGroup185_SKLWriteResGroup184_SKLWriteResGroupVEX2_WriteFDivZLd_WriteDPPSYLd
  { 4,  0}, // #14 WriteFCmp64X_WriteFCmpX_WriteCvtI2PS_WriteCvtPS2I_WriteVecExtract_WriteIMul16Imm_WriteIMul32_WriteIMul64_WriteVecInsert_WriteMPSAD_WriteFMul64X_WriteFMulX_WriteMULX32_WriteMULX64_WritePHMINPOS_WriteVecTest_WriteFRcpX_WriteFRsqrtX_WriteFCmp64Y_WriteFCmpY_WriteCvtI2PSY_WriteCvtPS2IY_WriteFMAX_WriteFMAY_WriteMPSADY_WriteFMul64Y_WriteFMulY_WriteVecMOVMSKY_WriteVecShiftY_WriteFRcpY_WriteFRsqrtY_ADLPWriteResGroup83_ADLPWriteResGroup174_ADLPWriteResGroup60_ADLPWriteResGroup51_ADLPWriteResGroup190_ADLPWriteResGroup277_ADLPWriteResGroup121_ADLPWriteResGroup158_ADLPWriteResGroup214_WritePHAddLd_WriteVecIMulLd_WritePSADBWLd_WriteFMulLd_WriteVarShuffleX_WriteFRcpLd_WriteFRsqrtLd_WriteSHDmrcl_WriteSHDmri_AtomWrite01_4_WriteJumpLd_WriteADCLd_WriteALULd_WriteFAdd64X_WriteFLogicLd_WriteFBlendLd_WriteFVarBlend_WriteBitTestImmLd_WriteBitTestRegLd_WriteRMW_WriteCvtSD2SS_WriteCvtSS2SD_WriteVecExtractSt_WriteVecALUXLd_WriteIMul16Reg_WriteFShuffleLd_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecInsertLd_WriteMMXMOVMSK_WriteVarShuffleLd_WriteFMOVMSK_WriteShuffleXLd_WriteVecLogicXLd_WriteVarBlend_WriteBlendLd_WriteStore_WriteVecTestLd_WriteShiftLd_WriteFVarShuffleLd_WriteVecShiftImmXLd_WriteFTestLd_SLMWriteResGroup1rr_WriteBSR_WriteCvtI2SD_WriteCvtI2SS_WriteVecIMulX_WriteIMul32Reg_WriteIMul32Imm_WriteIMul8_WritePOPCNT_WritePSADBWX_WriteFRnd_WriteCvtPS2PHYSt_WriteCvtPS2PHSt_WriteFRndY_PdWriteMMX_CVTPI2PSrr_PdWriteMOVQ2DQrr_PdWriteVPERM2F128rr_PdWriteVPMACS_WriteCvtI2PD_WriteCvtPD2I_WriteCvtPD2PS_WriteCvtSD2I_WriteCvtSS2I_WriteCvtPS2PDY_WriteVecTestY_BWWriteResGroup42_BWWriteResGroup44_BWWriteResGroup45_BWWriteResGroup41_BWWriteResGroup43_WriteBEXTRLd_WriteBSF_WriteCMOVLd_WriteFHAdd_WriteLZCNTLd_WriteVecMoveToGpr_WritePMULLD_WritePOPCNTLd_WriteSHDrrcl_WriteFHAddY_WriteFVarShuffleY_WriteFTestY_WriteFAddX_WriteAESDecEnc_WriteFAdd64Y_WriteFAdd64Z_WriteFAddY_WriteFAddZ_WriteFCmpZ_WriteCvtI2PDY_WriteCvtI2PDZ_WriteCvtI2PSZ_WriteFMAZ_WriteFCmp64Z_WriteFMul64Z_WriteFMulZ_WriteVecShiftZ_WriteFRcpZ_SKXWriteResGroup54_SKXWriteResGroup55_SKXWriteResGroup57_SKXWriteResGroup49_SKXWriteResGroup50_SKXWriteResGroup33_SKXWriteResGroup50z_SKXWriteResGroup51_WritePCmpEStrI_WriteCvtPD2PSY_WriteCvtPD2PSZ_WriteCvtPD2IY_WriteCvtPD2IZ_WriteCvtPS2PHZSt_SBWriteResGroup31_SBWriteResGroup29_2_SBWriteResGroup24b_WriteCvtPS2PDZ_HWWriteResGroup73_HWWriteMOVS_HWWriteResGroup62_HWWriteResGroup81_HWWriteResGroup72_HWWriteResGroup61_HWWriteCMPS_HWWriteResGroup83_WriteFRndZ_SPRWriteResGroup87_SPRWriteResGroup64_SPRWriteResGroup55_SPRWriteResGroup194_SPRWriteResGroup564_SPRWriteResGroup130_SPRWriteResGroup167_SPRWriteResGroup91_SPRWriteResGroup314_SPRWriteResGroup516_SPRWriteResGroup519_SPRWriteResGroup220_SPRWriteResGroup456_SPRWriteResGroup249_SPRWriteResGroup256_SPRWriteResGroup481_SPRWriteResGroup492_SPRWriteResGroup522_ICXWriteResGroup54_ICXWriteResGroup55_ICXWriteResGroup57_ICXWriteResGroup49_ICXWriteResGroup50_ICXWriteResGroup33_ICXWriteResGroup50z_ICXWriteResGroup51_SKLWriteResGroup53_SKLWriteResGroup55_SKLWriteResGroup54_SKLWriteResGroup57_SKLWriteResGroup47_WriteAESIMC_WriteAESKeyGen_WriteLoad_ZnWriteCVTPD2PSr_ZnWriteCVTSS2SDr_ZnWriteMul64_WriteVecIMulY_WriteFMaskedStore64_WriteFMaskedStore32_WriteVecMaskedStore32_WriteVecMaskedStore64_WritePMULLDY_ZnWriteCVTPS2PIr_ZnWritePUSH_ZnWriteINSERTQ_ZnWriteSHA256RNDS2r_Zn2WriteMul16Imm_Zn2WriteMul64_WriteVPMOV256_Zn2WriteCVTPS2PIr_Zn2WritePUSH_Zn2WriteCVSTSI2SIr_Zn2WriteINSERTQ_Zn2WriteSHA256RNDS2r_WriteFComX_WriteCLMul_WriteCvtPH2PSY_Zn3WriteCMPXCHG16B_LCMPXCHG16B_Zn3WriteRotateLeftRI_Zn3WriteRotateLeftRCL_Zn3WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn3WriteSHA256RNDS2rr_Zn3WriteMOVBE16rm_WriteCvtPS2IZ_WriteCvtPH2PSZ_WritePSADBWZ_Zn4WriteCMPXCHG16B_LCMPXCHG16B_Zn4WriteRotateLeftRI_Zn4WriteRotateLeftRCL_Zn4WriteVEXTRACTF128rr_VEXTRACTI128rr_Zn4WriteSHA256RNDS2rr_Zn4WriteMOVBE16rm_Zn4WriteVecALU2Slow_Zn4WriteBUSDr_VPMADDr_Zn4MOVSZ_Zn4VPTESTZ256_Zn4PERMIT2_256
  {20,  0}, // #15 WriteDiv16Ld_WriteFDiv64XLd_WriteIDiv16Ld_WriteFSqrtYLd_ADLPWriteResGroup159_ADLPWriteResGroup81_ADLPWriteResGroup48_ADLPWriteResGroup45_ADLPWriteResGroup79_ADLPWriteResGroup80_AtomWrite01_20_WritePCmpEStrMLd_WritePCmpIStrILd_WriteDPPDLd_WriteDPPSYLd_BWWriteResGroup167_BWWriteResGroup165_WriteAESKeyGen_WriteFSqrtZ_SKXWriteResGroup220_SKXWriteResGroup219_SKXWriteResGroup215_SKXWriteResGroupVEX4_WriteFDivXLd_WriteFDivLd_WriteCLMulLd_WriteFSqrtXLd_WriteFSqrtLd_WriteAESIMCLd_WriteDPPSLd_HWWriteResGroup156_HWWriteResGroup154_WriteFDiv64Ld_SPRWriteResGroup168_SPRWriteResGroup85_SPRWriteResGroup51_SPRWriteResGroup495_SPRWriteResGroup457_SPRWriteResGroup83_SPRWriteResGroup84_SPRWriteResGroup346_SPRWriteResGroup349_SPRWriteResGroup357_SPRWriteResGroup525_SPRWriteResGroup529_SPRWriteResGroup540_ICXWriteResGroup220_ICXWriteResGroup219_ICXWriteResGroup215_ICXWriteResGroupVEX4_SKLWriteResGroup193_SKLWriteResGroup192_SKLWriteResGroup189_SKLWriteResGroupVEX4_WriteFSqrt64X_WriteFSqrt80_WriteFSqrt64Y_WriteFDiv64YLd_WriteFDiv64ZLd
  {16,  0}, // #16 WriteDiv16_WriteDPPDLd_WriteIDiv16_WritePCmpEStrI_WritePCmpEStrM_WritePCmpIStrMLd_WriteFRndYLd_ADLPWriteResGroup267_WriteBSFLd_WriteBSRLd_WriteDiv8Ld_WriteFHAddLd_WriteIDiv8Ld_WritePCmpIStrILd_WriteFHAddYLd_WriteFDivXLd_BWWriteResGroup150_WriteFSqrt64X_WriteFSqrtXLd_WriteFSqrtLd_WritePMULLDYLd_BWWriteResGroup153_WriteDPPSLd_WriteFMaskedStore64Y_WriteFMaskedStore32_JWriteLOCK_CMPXCHG8rm_WriteFDivLd_WritePMULLDLd_WriteFRsqrtZLd_SKXWriteResGroup199_HWWriteResGroup120_HWWriteResGroup186_HWWriteResGroup190_WriteCvtPH2PSZLd_SPRWriteResGroup478_SPRWriteResGroup461_SPRWriteResGroup285_SPRWriteResGroup287_SPRWriteResGroup293_SPRWriteResGroup295_SPRWriteResGroup308_SPRWriteResGroup324_SPRWriteResGroup336_SPRWriteResGroup337_SPRWriteResGroup338_SPRWriteResGroup339_SPRWriteResGroup364_SPRWriteResGroup384_SPRWriteResGroup390_SPRWriteResGroup394_SPRWriteResGroup471_SPRWriteResGroup523_SPRWriteResGroup528_SPRWriteResGroup532_ICXWriteResGroup199_SKLWriteResGroup177_SKLWriteResGroup178
  {19,  0}, // #17 WriteDiv32Ld_WriteFDiv64Ld_WriteVecExtractSt_WriteIDiv32Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFDivYLd_WriteDiv16Ld_WriteIDiv16Ld_WritePCmpEStrILd_WriteAESIMCLd_WriteFDiv64XLd_BWWriteResGroup161_WriteDPPSLd_WritePCmpEStrM_BWWriteResGroup183_4_BWWriteResGroup183_3_WriteFDivX_WritePCmpEStrMLd_JWriteLOCK_CMPXCHG8B_JWriteLOCK_ALURMW_WriteFSqrtYLd_SKXWriteGatherEVEX4_WriteDPPSYLd_WriteFDivXLd_HWWriteResGroup135_HWWriteResGroup143_HWWriteFPREM_SPRWriteResGroup503_SPRWriteResGroup48_SPRWriteResGroup270_SPRWriteResGroup301_SPRWriteResGroup325_SPRWriteResGroup553_ICXWriteGatherEVEX4_WriteDiv8Ld_WriteIDiv8Ld
  {23,  0}, // #18 WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Ld_AtomWrite01_23_WriteFSqrtLd_WritePCmpEStrILd_WriteFSqrt80_WriteFDiv64Y_WriteFDivYLd_BWWriteResGroup176_WriteFDiv64Z_SKXWriteResGroup228_WriteIDiv8_HWWriteResGroup151_SPRWriteResGroup497_SPRWriteResGroup499_SPRWriteResGroup459_SPRWriteResGroup309_SPRWriteResGroup322_ICXWriteResGroup228_SKLWriteResGroup198
  {22,  0}, // #19 WriteDiv8Ld_WriteIDiv8Ld_WriteDPPSYLd_ADLPWriteResGroup46_AtomWrite01_22_WriteFDivLd_BWWriteResGroup172_WriteFMaskedStore32Y_SKXWriteResGroup223_SKXWriteResGroupVEX8_SKXWriteResGroup225_SKXWriteResGroup211_SKXWriteResGroup211_1_WriteFDiv64X_WriteFSqrt64XLd_HWWriteResGroup146_HWWriteResGroup187_SPRWriteResGroup49_SPRWriteResGroup302_SPRWriteResGroup326_SPRWriteResGroup526_SPRWriteResGroup530_ICXWriteResGroup223_ICXWriteResGroupVEX8_ICXWriteResGroup225_ICXWriteResGroup211_ICXWriteResGroup211_1_SKLWriteResGroup196_SKLWriteResGroupVEX8_WriteFDiv64YLd_WriteDPPSLd_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrt80_WriteFSqrtYLd_WriteFSqrtZLd
  {17,  0}, // #20 WriteDiv8_WriteIDiv8_WritePCmpEStrMLd_WriteStore_ADLPWriteResGroup276_ADLPWriteResGroup17_AtomWrite01_17_WritePCmpIStrI_WriteCLMulLd_WriteFDivY_WriteFRcpYLd_WriteFRsqrtYLd_BWWriteResGroup183_1_WriteDiv16_WriteIDiv16_WriteDPPSYLd_JWriteLOCK_CMPXCHGrm_WriteFDivXLd_WriteFSqrtLd_WritePMULLDYLd_WritePMULLDZLd_SKXWriteResGroup202_SKXWriteGatherEVEX2_WritePCmpIStrILd_WritePCmpIStrMLd_WriteFSqrtXLd_HWWriteResGroup147_HWWriteResGroup132_HWWriteResGroup185_HWWriteResGroup189_SPRWriteResGroup563_SPRWriteResGroup451_SPRWriteResGroup448_SPRWriteResGroup19_SPRWriteResGroup273_SPRWriteResGroup277_SPRWriteResGroup282_SPRWriteResGroup316_SPRWriteResGroup333_SPRWriteResGroup342_SPRWriteResGroup379_SPRWriteResGroup460_SPRWriteResGroup474_SPRWriteResGroup476_SPRWriteResGroup534_SPRWriteResGroup536_ICXWriteResGroup202_ICXWriteGatherEVEX2_SKLWriteResGroup180_WriteFDivLd_WriteFDivYLd_WriteDiv32Ld_WriteDiv64_WriteIDiv32Ld_WriteIDiv64
  {14,  0}, // #21 WriteFDiv64X_WriteDPPS_WriteFDiv64Y_WriteDPPSY_WriteFMaskedStore64Y_WriteFMaskedStore32Y_WriteVecMaskedStore32Y_WriteVecMaskedStore64Y_ADLPWriteResGroup157_WriteIMul64ImmLd_AtomWrite01_14_WritePMULLDLd_WriteAESDecEncLd_WriteDiv32_WriteDiv64_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteIDiv32_WriteIDiv64_WriteMPSADLd_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrtXLd_WriteFSqrt64Ld_WriteFSqrtLd_WriteFDiv64YLd_WriteFDivYLd_WriteFSqrt64YLd_WriteFSqrtYLd_WriteAESIMC_BWWriteResGroup139_1_WriteDPPDLd_BWWriteResGroup146_BWWriteResGroup141_BWWriteResGroup144_BWWriteResGroup145_WritePCmpEStrM_WriteAESIMCLd_WriteFRndLd_WriteCvtPD2PSYLd_WriteCvtPD2PSZLd_SKXWriteResGroup187_SKXWriteResGroup190_SKXWriteResGroup188_SKXWriteResGroup189_WriteAESKeyGenLd_WriteCLMul_WriteMPSADYLd_WriteFRcpYLd_WriteFRcpZLd_WriteFRsqrtYLd_WriteFRsqrtZLd_HWWriteResGroup142_HWWriteResGroup184_SPRWriteResGroup166_SPRWriteResGroup496_SPRWriteResGroup276_SPRWriteResGroup280_SPRWriteResGroup315_SPRWriteResGroup331_SPRWriteResGroup355_SPRWriteResGroup363_SPRWriteResGroup381_SPRWriteResGroup445_SPRWriteResGroup447_SPRWriteResGroup466_SPRWriteResGroup468_SPRWriteResGroup487_ICXWriteResGroup187_ICXWriteResGroup190_ICXWriteResGroup188_ICXWriteResGroup189_SKLWriteResGroup169_SKLWriteResGroup170_WriteFHAddLd_WriteFHAddYLd_WriteDiv8Ld_WriteIDiv8Ld_WriteFVarShuffle256Ld
  { 9,  0}, // #22 WriteDPPD_WriteIMul16ImmLd_WriteIMul32Ld_WriteIMul64Ld_WriteVecALULd_WriteShuffleLd_WriteVecLogicLd_WriteVecShiftLd_WriteMULX32Ld_WriteMULX64Ld_WritePHAddXLd_WriteVecTestLd_WriteShuffleYLd_WriteFLogicYLd_WriteFBlendYLd_WriteVecALUYLd_WriteFMaskedLoadY_WriteFShuffleYLd_WriteVecLogicYLd_WriteBlendYLd_WriteFVarShuffleYLd_WriteVecMaskedLoadY_WriteVarVecShiftYLd_WriteVarShuffleYLd_WriteVecShiftYLd_ADLPWriteResGroup114_ADLPWriteResGroup122_ADLPWriteResGroup255_ADLPWriteResGroup125_ADLPWriteResGroup197_ADLPWriteResGroup221_ADLPWriteResGroup177_ADLPWriteResGroup244_ADLPWriteResGroup264_WriteBitTestRegLd_WriteFCMOV_WriteFComX_WriteCvtSD2ILd_WriteCvtSS2ILd_WriteFHAddLd_WriteFMul64X_WriteFRcpX_WriteFRsqrtX_AtomWrite0_1_9_AtomWrite01_9_WritePHAddLd_WriteAESDecEnc_WriteCvtI2PSLd_WriteCvtPS2ILd_WriteCvtSD2SSLd_WriteCvtI2SDLd_WriteCvtI2SSLd_WriteCvtSS2SDLd_WriteFDiv64X_WriteFDivX_WriteVecIMulXLd_WriteVecIMulLd_WritePSADBWLd_WritePHMINPOSLd_WritePSADBWXLd_WriteFRndLd_WriteFSqrt64X_WriteFSqrtX_WriteCvtI2PSYLd_WriteCvtPS2IYLd_WriteFDiv64Y_WriteFDivY_WriteFRndYLd_WriteFSqrt64Y_WriteFSqrtY_PdWriteX87Div_PdWriteRCR16rCL_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteIMul16Ld_WriteSHDmri_WriteFAdd64YLd_WriteFAddYLd_WriteShuffle256Ld_WriteFShuffle256Ld_WriteFCmp64YLd_WriteFCmpYLd_WriteVarShuffle256Ld_WriteCvtPS2PDYLd_WriteFMul64YLd_WriteFMulYLd_WriteFVarShuffle256Ld_WritePHAddYLd_WriteVPMOV256Ld_BWWriteResGroup101_BWWriteResGroup112_BWWriteResGroup108_BWWriteResGroup113_WriteIMul64RegLd_WriteIMul64ImmLd_WriteFMul64XLd_WriteFMul64Ld_WritePMULLDLd_WriteSHDmrcl_WriteFHAddYLd_WriteVecTestYLd_WriteFTestYLd_WriteFAdd64Ld_WriteFAddLd_WriteFCmp64Ld_WriteFCmpLd_WriteFMulLd_WriteFRcpLd_WriteFRsqrtLd_WriteFMALd_WriteFVarBlendYLd_WriteFVarBlendZLd_WriteCvtI2PDYLd_WriteCvtI2PDZLd_WriteCvtI2PSZLd_WriteCvtPH2PSLd_WriteFRsqrtZ_SKXWriteResGroup135_SKXWriteResGroup137_SKXWriteResGroup136_SKXWriteResGroup146_SKXWriteResGroup143_SBWriteResGroup98_WriteFAdd64XLd_WriteFAddXLd_SBWriteResGroup100_WriteRMW_WriteFCmp64XLd_WriteFCmpXLd_WritePOPCNTLd_WriteVarBlendYLd_WriteVarBlendZLd_SBWriteResGroup97_2_SBWriteResGroup95_SBWriteResGroup99_SBWriteResGroupVzeroall_WriteCMPXCHGRMW_HWWriteResGroup69_WriteVarVecShiftLd_HWWriteResGroup66_HWWriteResGroup68_HWWriteResGroup53_1_HWWriteResGroup78_1_HWWriteResGroup80_HWWriteResGroup87_WriteShuffleZLd_WriteFLogicZLd_WriteVecALUZLd_WriteFShuffleZLd_WriteVecLogicZLd_WriteFVarShuffleZLd_WriteVecShiftImmYLd_WriteVecShiftImmZLd_WriteVarVecShiftZLd_WriteVecShiftZLd_SPRWriteResGroup123_SPRWriteResGroup131_SPRWriteResGroup262_SPRWriteResGroup134_SPRWriteResGroup201_SPRWriteResGroup227_SPRWriteResGroup183_SPRWriteResGroup472_SPRWriteResGroup477_SPRWriteResGroup261_SPRWriteResGroup442_SPRWriteResGroup275_SPRWriteResGroup279_SPRWriteResGroup330_SPRWriteResGroup366_SPRWriteResGroup392_SPRWriteResGroup396_SPRWriteResGroup409_SPRWriteResGroup412_SPRWriteResGroup507_SPRWriteResGroup510_SPRWriteResGroup512_SPRWriteResGroup524_ICXWriteResGroup135_ICXWriteResGroup137_ICXWriteResGroup136_ICXWriteResGroup146_ICXWriteResGroup143_WriteCvtPS2PDLd_SKLWriteResGroup120_SKLWriteResGroup123_SKLWriteResGroup121_SKLWriteResGroup131_SKLWriteResGroup128_ZnWriteMul64Ld_WriteFTestLd_ZnWriteFPU02_ZnWriteVINSERT128Ld_ZnWriteFPU01Op2Y_ZnWriteSHA1MSG1Ld_Zn2WriteFPU02_Zn2WriteVINSERT128Ld_Zn2WriteFPU01Op2Y_Zn2WriteSHA1MSG1Ld_WritePCmpIStrILd_Zn3WriteVPERMDYm_WriteVecShiftXLd_WriteFCmpZLd_WriteFCmp64ZLd_Zn4WriteVPERMYm
  {21,  0}, // #23 WriteDPPSLd_WriteFSqrt80_WriteFDiv64YLd_ADLPWriteResGroup220_AtomWrite01_21_WritePCmpEStrI_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrtY_BWWriteResGroup171_BWWriteResGroup169_BWWriteResGroup183_5_WriteFSqrtX_SKXWriteResGroup205_SKXWriteGatherEVEX8_WriteFDivY_WriteFDivZ_WriteDPPSYLd_WriteFSqrtZ_HWWriteResGroup144_WriteFSqrt64YLd_SPRWriteResGroup226_SPRWriteResGroup274_SPRWriteResGroup278_SPRWriteResGroup305_SPRWriteResGroup353_SPRWriteResGroup380_SPRWriteResGroup391_SPRWriteResGroup395_ICXWriteResGroup205_ICXWriteGatherEVEX8_WriteDiv16Ld_WriteIDiv16Ld_WriteFSqrtXLd_WriteFSqrtLd_WriteFSqrtYLd_WriteDiv64Ld_WriteIDiv64Ld_WriteFSqrt64Z
  {13,  0}, // #24 WriteVecIMulXLd_WriteVecIMulLd_WriteSETCCStore_WriteVecIMulYLd_WriteFHAddYLd_ADLPWriteResGroup113_ADLPWriteResGroup33_ADLPWriteResGroup10_ADLPWriteResGroup231_ADLPWriteResGroup223_ADLPWriteResGroup227_ADLPWriteResGroup4_ADLPWriteResGroup7_ADLPWriteResGroup138_ADLPWriteResGroup233_AtomWrite01_13_WriteBSFLd_WriteBSRLd_WriteCLMulLd_WritePCmpIStrM_WriteCvtI2PDLd_WriteCvtPD2ILd_WriteCvtPD2PSLd_WriteCvtPS2PDLd_WriteCvtSD2I_WriteCvtSS2I_WriteVecExtractSt_WriteCvtI2PDYLd_WriteCvtPD2PSYLd_WriteCvtPD2IYLd_WriteCvtPS2PDYLd_WriteCvtPH2PSYLd_WriteCvtPH2PSLd_PdWriteCVTSI642SDrr_CVTSI642SSrr_CVTSI2SDr_CVTSI2SSrr_PdWriteRCL8ri_WriteMPSADYLd_WritePCmpIStrMLd_WriteFMaskedStore64_WriteDPPS_WriteDPPSY_SKXWriteResGroup180_SKXWriteResGroup181_SKXWriteResGroup183_WriteAESDecEncLd_WriteMPSADLd_SBWriteResGroup114_WriteFDivX_WriteFRndYLd_WriteFRndZLd_HWWriteResGroup103_WriteCvtPS2PDZLd_WriteVecIMulZLd_SPRWriteResGroup122_SPRWriteResGroup35_SPRWriteResGroup11_SPRWriteResGroup229_SPRWriteResGroup233_SPRWriteResGroup4_SPRWriteResGroup480_SPRWriteResGroup332_SPRWriteResGroup458_SPRWriteResGroup7_SPRWriteResGroup94_SPRWriteResGroup238_SPRWriteResGroup307_SPRWriteResGroup359_SPRWriteResGroup360_SPRWriteResGroup462_SPRWriteResGroup490_SPRWriteResGroup527_SPRWriteResGroup531_ICXWriteResGroup180_ICXWriteResGroup181_ICXWriteResGroup183_SKLWriteResGroup162_WriteFDiv64X_ZnWriteSHA1RNDS4Ld_WriteFDiv64Y_Zn2WriteSHA1RNDS4Ld_WriteDiv32_WriteFHAddLd_WriteIDiv32_WritePCmpEStrILd_WritePCmpEStrMLd_WriteCvtPD2PSZLd_WriteFDiv64Z
  {511,  0}, // #25 WriteVecStoreNT_ADLPWriteResGroup145_SPRWriteResGroup154
  {512,  0}, // #26 WriteStoreNT_ADLPWriteResGroup148_SPRWriteResGroup157
  {518,  0}, // #27 WriteFStoreNTX_ADLPWriteResGroup149_SPRWriteResGroup158
  { 3,  0}, // #28 WriteIMulHLd
  { 9,  0}, // #29 WriteMULX32Ld_WriteMULX64Ld
  { 3,  0}, // #30 WriteIMulH
  { 4,  0}, // #31 WriteMULX32_WriteMULX64
  {31,  0}, // #32 WritePCmpEStrILd_WritePCmpIStrILd_WriteEMMS_SBWriteResGroup130_HWWriteResGroup163_HWWriteResGroup165_WriteFSqrt64ZLd_SPRWriteResGroup370_SPRWriteResGroup543
  {12,  0}, // #33 WriteRotateLd_WriteShiftLd_WriteShiftCLLd_ADLPWriteResGroup211_ADLPWriteResGroup271_SPRWriteResGroup215_SPRWriteResGroup558
  { 1,  0}, // #34 WriteRMW_WriteShift
  {12,  0}, // #35 WriteRotateLd_WriteShiftCLLd
  { 2,  0}, // #36 WriteRotate_WriteShiftCL
  {19,  0}, // #37 WriteRotateCLLd
  { 1,  0}, // #38 WriteRMW
  {19,  0}, // #39 WriteRotateCLLd
  { 2,  0}, // #40 WriteRotateCL
  {24,  0}, // #41 WriteFSqrt64XLd_ADLPWriteResGroup109_ADLPWriteResGroup237_WritePCmpEStrILd_WritePCmpEStrMLd_BWWriteResGroup177_WriteFDiv64XLd_WriteFDivXLd_WriteFDivLd_WriteFDiv64Ld_WriteFSqrt80_HWWriteResGroup162_SPRWriteResGroup118_SPRWriteResGroup450_SPRWriteResGroup242_SPRWriteResGroup306
  { 5,  0}, // #42 WriteLoad
  { 5,  0}, // #43 WriteVecMaskedGatherWriteback
  {507,  0}, // #44 WriteVecStoreNTY
  {542,  0}, // #45 WriteFStoreNTY
  {25,  0}, // #46 WriteFSqrt64YLd_ADLPWriteResGroup32_ADLPWriteResGroup47_AtomWrite01_25_WriteDiv16_WriteDiv32_WriteDiv64_WriteDiv8_WriteIDiv16_WriteIDiv32_WriteIDiv64_WriteIDiv8_WriteDPPS_WriteAESKeyGenLd_WritePCmpEStrMLd_WriteFDivZLd_SKXWriteResGroup233_SKXWriteGatherEVEX16_WriteFDiv64Ld_SPRWriteResGroup34_SPRWriteResGroup50_SPRWriteResGroup454_SPRWriteResGroup327_SPRWriteResGroup539_ICXWriteResGroup233_ICXWriteGatherEVEX16_SKLWriteResGroup202
  {11,  0}, // #47 WriteALULd
  { 1,  0}, // #48 WriteRMW
  {39,  0}, // #49 ADLPWriteResGroup274_ADLPWriteResGroup273_WriteFDivX_WriteFSqrt64ZLd_SPRWriteResGroup561_SPRWriteResGroup560_SPRWriteResGroup373_SPRWriteResGroup542
  { 1,  0}, // #50 WriteRMW
  {32,  0}, // #51 ADLPWriteResGroup31_AtomWrite01_32_WriteDPPSYLd_WriteFSqrt64XLd_WriteFSqrt64Ld_JWriteCMPXCHG16B_WriteFSqrt64Z_SPRWriteResGroup33
  {42,  0}, // #52 ADLPWriteResGroup207_ADLPWriteResGroup280_ADLPWriteResGroup287_ADLPWriteResGroup282_ADLPWriteResGroup283_ADLPWriteResGroup286_WriteFDivXLd_BWWriteResGroup196_WriteFSqrtY_SKXWriteResGroup254_SKXWriteResGroup255_WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd_HWWriteResGroup176_SPRWriteResGroup211_SPRWriteResGroup567_SPRWriteResGroup572_SPRWriteResGroup574_SPRWriteResGroup569_SPRWriteResGroup570_SPRWriteResGroup571_SPRWriteResGroup573_SPRWriteResGroup548_ICXWriteResGroup254_ICXWriteResGroup255_SKLWriteResGroup214_SKLWriteResGroup215
  {126,  0}, // #53 ADLPWriteResGroup49_SPRWriteResGroup53
  {75,  0}, // #54 ADLPWriteResGroup61_BWWriteResGroup200_SKXWriteResGroup263_HWWriteResGroup180_HWWriteFSCALE_SPRWriteResGroup65_ICXWriteResGroup263_SKLWriteResGroup220
  {35,  0}, // #55 ADLPWriteResGroup165_ADLPWriteResGroup164_ADLPWriteResGroup75_ADLPWriteResGroup76_ADLPWriteResGroup71_ADLPWriteResGroup72_ADLPWriteResGroup73_ADLPWriteResGroup160_ADLPWriteResGroup161_ADLPWriteResGroup162_ADLPWriteResGroup163_WriteFSqrt64_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFSqrt64YLd_BWWriteResGroup194_WriteFSqrt80_SKXWriteResGroup248_SKXWriteResGroup247_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Z_HWWriteResGroup170_SPRWriteResGroup174_SPRWriteResGroup173_SPRWriteResGroup79_SPRWriteResGroup80_SPRWriteResGroup75_SPRWriteResGroup76_SPRWriteResGroup77_SPRWriteResGroup169_SPRWriteResGroup170_SPRWriteResGroup171_SPRWriteResGroup172_SPRWriteResGroup545_ICXWriteResGroup248_ICXWriteResGroup247_SKLWriteResGroup210_SKLWriteResGroup209
  {63,  0}, // #56 ADLPWriteResGroup66_ADLPWriteResGroup67_ADLPWriteResGroup108_AtomWrite01_63_BWWriteResGroup199_BWWriteResGroup198_SKXWriteResGroup260_SKXWriteResGroup259_SPRWriteResGroup70_SPRWriteResGroup71_SPRWriteResGroup117_ICXWriteResGroup260_ICXWriteResGroup259_SKLWriteResGroup219_SKLWriteResGroup218
  {81,  0}, // #57 ADLPWriteResGroup248_ADLPWriteResGroup246_SPRWriteResGroup387_SPRWriteResGroup385
  {13,  0}, // #58 ADLPWriteResGroup272_ADLPWriteResGroup193_ADLPWriteResGroup213_ADLPWriteResGroup215_SPRWriteResGroup559_SPRWriteResGroup197_SPRWriteResGroup217_SPRWriteResGroup221
  { 1,  0}, // #59 WriteRMW
  {65,  0}, // #60 ADLPWriteResGroup90_SPRWriteResGroup100
  {70,  0}, // #61 ADLPWriteResGroup107_WriteFDivXLd_WriteFSqrtXLd_SPRWriteResGroup116
  {37,  0}, // #62 ADLPWriteResGroup279_WriteFDiv64Ld_SKXWriteResGroup250_SKXWriteResGroup249_SPRWriteResGroup566_SPRWriteResGroup372_ICXWriteResGroup250_ICXWriteResGroup249_SKLWriteResGroup211
  {27,  0}, // #63 ADLPWriteResGroup42_WriteDPPSY_PdWriteVDPPSrri_WriteFSqrtYLd_WriteFSqrt64X_WriteFSqrtZLd_SKXWriteResGroup239_WriteFSqrt64XLd_WriteFSqrt64Ld_HWWriteFPREM1_HWWriteResGroup155_SPRWriteResGroup45_SPRWriteResGroup433_SPRWriteResGroup434_ICXWriteResGroup239_SKLWriteResGroup206_WriteFSqrt64YLd
  {30,  0}, // #64 ADLPWriteResGroup43_AtomWrite01_30_WriteDPPSLd_BWWriteResGroup186_WriteFDiv64ZLd_SKXWriteResGroup243_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_HWWriteResGroup161_HWWriteResGroup164_SPRWriteResGroup46_SPRWriteResGroup440_ICXWriteResGroup243_SKLWriteResGroup208
  {41,  0}, // #65 ADLPWriteResGroup281_WriteFSqrtX_WriteDiv64_WriteIDiv64_SKXWriteResGroup253_HWWriteResGroup175_SPRWriteResGroup568_SPRWriteResGroup377_SPRWriteResGroup544_ICXWriteResGroup253_SKLWriteResGroup213
  {46,  0}, // #66 ADLPWriteResGroup285_ADLPWriteResGroup284_AtomWrite01_46_PdWriteVZEROUPPER_JWriteJVZEROUPPER_SKLWriteResGroup216
  {40,  0}, // #67 ADLPWriteResGroup257_WriteFSqrt80_SKXWriteResGroup252_SPRWriteResGroup416_SPRWriteResGroup435_SPRWriteResGroup436_SPRWriteResGroup547_ICXWriteResGroup252_SKLWriteResGroup212
  {62,  0}, // #68 ADLPWriteResGroup59_WriteFDiv64Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv8Ld_WriteFSqrt64Ld_SKXWriteResGroup258_SPRWriteResGroup63_ICXWriteResGroup258_SKLWriteResGroup217
  {106,  0}, // #69 ADLPWriteResGroup65_SKXWriteResGroup266_SPRWriteResGroup69_ICXWriteResGroup266_SKLWriteResGroup223
  {20,  0}, // #70 ADLPWriteResGroup251_SPRWriteResGroup402_SPRWriteResGroup399
  { 5,  0}, // #71 WriteVecMaskedGatherWriteback
  {29,  0}, // #72 ADLPWriteResGroup250_AtomWrite01_29_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_WriteIDiv16Ld_WriteIDiv32Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteAESKeyGen_WriteFDiv64YLd_WriteFSqrt64Y_BWWriteResGroup182_BWWriteResGroup185_SKXWriteResGroup242_WriteFDivY_WriteFDivZ_WriteFSqrtY_WriteFSqrtZ_SPRWriteResGroup398_SPRWriteResGroup405_SPRWriteResGroup439_ICXWriteResGroup242
  { 5,  0}, // #73 WriteVecMaskedGatherWriteback
  {28,  0}, // #74 ADLPWriteResGroup253_WriteDiv32Ld_WriteIDiv32Ld_WriteIDiv16Ld_WriteIDiv64Ld_WriteIDiv8Ld_WriteFDiv64XLd_WriteFDiv64Ld_WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_SPRWriteResGroup407_SPRWriteResGroup400_SPRWriteResGroup401_WriteFSqrt64XLd_WriteFSqrt64Ld_WriteFSqrt64YLd_WriteFSqrt64ZLd
  { 5,  0}, // #75 WriteVecMaskedGatherWriteback
  {30,  0}, // #76 ADLPWriteResGroup252_SPRWriteResGroup403_SPRWriteResGroup406
  { 5,  0}, // #77 WriteVecMaskedGatherWriteback
  {40,  0}, // #78 ADLPWriteResGroup275_SPRWriteResGroup562
  { 1,  0}, // #79 WriteRMW
  {26,  0}, // #80 ADLPWriteResGroup35_AtomWrite01_26_BWWriteResGroup180_WriteFSqrtXLd_WriteFSqrtLd_WriteFDiv64XLd_SPRWriteResGroup38_SPRWriteResGroup310_SPRWriteResGroup323_SPRWriteResGroup453
  {198,  0}, // #81 ADLPWriteResGroup87_SPRWriteResGroup97
  {66,  0}, // #82 ADLPWriteResGroup88_SPRWriteResGroup98
  {71,  0}, // #83 ADLPWriteResGroup89_ADLPWriteResGroup91_WriteFSqrt80_AtomWrite01_71_WriteFSqrt64X_SPRWriteResGroup99_SPRWriteResGroup101
  {217,  0}, // #84 ADLPWriteResGroup133_SPRWriteResGroup143
  {181,  0}, // #85 ADLPWriteResGroup136_SPRWriteResGroup146
  {514,  0}, // #86 ADLPWriteResGroup146_SPRWriteResGroup155
  {20,  0}, // #87 ADLPWriteResGroup194_ADLPWriteResGroup196_SPRWriteResGroup198_SPRWriteResGroup200
  { 1,  0}, // #88 WriteRMW
  {1386,  0}, // #89 ADLPWriteResGroup202_SPRWriteResGroup206
  {1381,  0}, // #90 ADLPWriteResGroup204_SPRWriteResGroup208
  {74,  0}, // #91 ADLPWriteResGroup247_ADLPWriteResGroup249_AtomWrite01_74_WriteFSqrt64XLd_SKXWriteResGroup262_SPRWriteResGroup386_SPRWriteResGroup388_ICXWriteResGroup262
  {521,  0}, // #92 ADLPWriteResGroup259_SPRWriteResGroup423
  {473,  0}, // #93 ADLPWriteResGroup260_SPRWriteResGroup422
  {494,  0}, // #94 ADLPWriteResGroup261_SPRWriteResGroup427
  {470,  0}, // #95 ADLPWriteResGroup262_SPRWriteResGroup421
  {50,  0}, // #96 WriteDiv16Ld_WriteDiv32Ld_WriteDiv8
  {130,  0}, // #97 WriteDiv64Ld_WriteIDiv64Ld_AtomWrite01_130
  {68,  0}, // #98 WriteDiv8Ld_AtomWrite01_68
  {125,  0}, // #99 WriteFDiv64XLd_WriteFSqrt64XLd
  {34,  0}, // #100 WriteFDivLd_WriteFSqrtLd_WriteFDiv64_WriteDiv16Ld_WriteDiv32Ld_WriteDiv64Ld_WriteDiv8Ld_BWWriteResGroup191_JWriteMASKMOVDQU_SBWriteResGroup131_WriteAESKeyGenLd_HWWriteResGroup166
  { 1,  0}, // #101 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #102 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {45,  0}, // #103 AtomWrite01_45_WriteFDiv64Y_WriteFDiv64Z_WriteFSqrt64Y_WriteFSqrt64Z_SPRWriteResGroup551_WriteDiv64Ld_WriteIDiv64Ld
  {48,  0}, // #104 AtomWrite01_48
  {55,  0}, // #105 AtomWrite01_55_SPRWriteResGroup550
  {59,  0}, // #106 AtomWrite01_59_WriteFSqrt64YLd
  {72,  0}, // #107 AtomWrite01_72_WriteFDiv64XLd
  {77,  0}, // #108 AtomWrite01_77
  {78,  0}, // #109 AtomWrite01_78
  {79,  0}, // #110 AtomWrite01_79
  {92,  0}, // #111 AtomWrite01_92
  {94,  0}, // #112 AtomWrite01_94
  {99,  0}, // #113 AtomWrite01_99
  {121,  0}, // #114 AtomWrite01_121
  {127,  0}, // #115 AtomWrite01_127
  {140,  0}, // #116 AtomWrite01_140_SKXWriteResGroup267_SPRWriteResGroup180_ICXWriteResGroup267
  {141,  0}, // #117 AtomWrite01_141
  {146,  0}, // #118 AtomWrite01_146
  {147,  0}, // #119 AtomWrite01_147
  {168,  0}, // #120 AtomWrite01_168
  {174,  0}, // #121 AtomWrite01_174
  {183,  0}, // #122 AtomWrite01_183
  {202,  0}, // #123 AtomWrite01_202
  {69,  0}, // #124 WriteFDiv64X
  { 4,  0}, // #125 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #126 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {44,  0}, // #127 WriteFSqrtXLd_WriteDiv64Ld_WriteIDiv64Ld_SKXWriteResGroup256_ICXWriteResGroup256
  {38,  0}, // #128 WriteFSqrt64Ld_WriteFDiv64Y_WriteFDivY_JWriteLOCK_CMPXCHG16B_SPRWriteResGroup369_SPRWriteResGroup541
  { 5,  0}, // #129 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 1,  0}, // #130 WriteRMW_WriteRotate_WriteRotateCL_WriteShift_WriteShiftCL
  {90,  0}, // #131 PdWriteVZEROALL_JWriteJVZEROALL
  {184,  0}, // #132 PdWriteLARrr
  {33,  0}, // #133 WriteAESKeyGenLd_SPRWriteResGroup452_SPRWriteResGroup371
  {80,  0}, // #134 WriteDiv16_WriteDiv32_WriteDiv64
  { 9,  0}, // #135 WriteIMulHLd
  { 8,  0}, // #136 WriteMULX32Ld_WriteMULX64Ld
  { 4,  0}, // #137 WriteIMulH
  { 3,  0}, // #138 WriteMULX32_WriteMULX64
  { 6,  0}, // #139 WriteRotateLd_WriteShiftLd_WriteALULd
  { 1,  0}, // #140 WriteRMW_WriteRotate_WriteShift
  { 8,  0}, // #141 WriteRotateCLLd_WriteShiftCLLd
  { 1,  0}, // #142 WriteRMW
  { 8,  0}, // #143 WriteRotateCLLd_WriteShiftCLLd
  { 3,  0}, // #144 WriteRotateCL_WriteShiftCL
  {60,  0}, // #145 BWWriteResGroup197
  {115,  0}, // #146 BWWriteResGroup202_HWWriteResGroup183
  { 4,  0}, // #147 WriteRotateLd_WriteRotateCLLd_WriteShiftLd_WriteShiftCLLd_WriteALULd
  { 2,  0}, // #148 WriteRMW
  {43,  0}, // #149 WriteFDiv64YLd_WriteFDivYLd_SPRWriteResGroup378
  {54,  0}, // #150 WriteFSqrt64Y
  {47,  0}, // #151 WriteFSqrtYLd_HWWriteFBLD_SPRWriteResGroup552
  {11,  0}, // #152 JWriteXCHGrm_XCHG_Part_JWriteLOCK_XADDrm_XCHG_Part
  {16,  0}, // #153 JWriteXCHGrm_LdSt_Part
  { 3,  0}, // #154 JWriteXADDrm_XCHG_Part
  {11,  0}, // #155 JWriteXADDrm_LdSt_Part
  {76,  0}, // #156 WriteDiv16_WriteDiv32_WriteDiv64
  {102,  0}, // #157 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {67,  0}, // #158 SKXWriteResGroup261_ICXWriteResGroup261
  { 7,  0}, // #159 WriteRotateLd
  { 1,  0}, // #160 WriteRMW
  { 7,  0}, // #161 WriteRotateLd
  { 2,  0}, // #162 WriteRotate
  {52,  0}, // #163 WriteFDiv64YLd_WriteFDiv64ZLd_WriteFSqrt64YLd_WriteFSqrt64ZLd
  {36,  0}, // #164 WriteFDivYLd_WriteFDivZLd_WriteFSqrtYLd_WriteFSqrtZLd_HWWriteResGroup171_SPRWriteResGroup368
  {98,  0}, // #165 WriteDiv16_WriteDiv32_WriteDiv64
  {112,  0}, // #166 WriteIDiv16_WriteIDiv32_WriteIDiv64
  {64,  0}, // #167 HWWriteResGroup179_HWWriteResGroup178
  {61,  0}, // #168 HWWriteResGroup177
  {27,  0}, // #169 SPRWriteResGroup404
  { 5,  0}, // #170 WriteVecMaskedGatherWriteback
  {49,  0}, // #171 SPRWriteResGroup375
  {51,  0}, // #172 SPRWriteResGroup376
  {477,  0}, // #173 SPRWriteResGroup420
  {550,  0}, // #174 SPRWriteResGroup424
  {474,  0}, // #175 SPRWriteResGroup425
  {464,  0}, // #176 SPRWriteResGroup426
  {475,  0}, // #177 SPRWriteResGroup428
  {476,  0}, // #178 SPRWriteResGroup429
  {471,  0}, // #179 SPRWriteResGroup430
  {53,  0}, // #180 SPRWriteResGroup549
  { 3,  0}, // #181 WriteIMulH
  { 3,  0}, // #182 WriteMULX32_WriteMULX64
  { 4,  0}, // #183 WriteLoad
  { 8,  0}, // #184 WriteVecMaskedGatherWriteback_WriteIMulHLd
  { 7,  0}, // #185 WriteIMulHLd_WriteMULX32Ld_WriteMULX64Ld
  { 7,  0} // #186 WriteMULX32Ld_WriteMULX64Ld
}; // X86WriteLatencyTable

// {UseIdx, WriteResourceID, Cycles}
extern const llvm::MCReadAdvanceEntry X86ReadAdvanceTable[] = {
  {0,  0,  0}, // Invalid
  {0,  0,  5}, // #1
  {5,  0,  5}, // #2
  {6,  0,  5}, // #3
  {0,  0,  5}, // #4
  {6,  0,  5}, // #5
  {0,  0,  6}, // #6
  {1,  0,  0}, // #7
  {0,  0,  6}, // #8
  {6,  0,  6}, // #9
  {0,  0,  6}, // #10
  {1,  0,  6}, // #11
  {0,  0,  5}, // #12
  {1,  0,  5}, // #13
  {0,  0,  3}, // #14
  {5,  0,  3}, // #15
  {6,  0,  3}, // #16
  {0,  0,  3}, // #17
  {6,  0,  3}, // #18
  {0,  0,  3}, // #19
  {1,  0,  3}, // #20
  {0,  0,  4}, // #21
  {5,  0,  4}, // #22
  {6,  0,  4}, // #23
  {0,  0,  4}, // #24
  {6,  0,  4}, // #25
  {0,  0, -10}, // #26
  {1,  0, -10}, // #27
  {0,  0, -6}, // #28
  {1,  0, -6}, // #29
  {5,  0,  3}, // #30
  {6,  0,  3}, // #31
  {7,  0,  3}, // #32
  {8,  0,  3}, // #33
  {0,  0,  7}, // #34
  {0,  0,  7}, // #35
  {6,  0,  7}, // #36
  {0,  0,  7}, // #37
  {1,  0,  7}, // #38
  {0,  0,  8}, // #39
  {0,  0,  8}, // #40
  {6,  0,  8}, // #41
  {0,  0,  8}, // #42
  {1,  0,  8}, // #43
  {0,  0, -1}, // #44
  {1,  0, -1} // #45
}; // X86ReadAdvanceTable

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AlderlakePModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  3, 9,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false, 12, 5,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    6, false, false, false, 17, 9,  2, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        2, false, false, false, 26, 10,  3, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  1, 2,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false, 36, 3,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteLEA")           1, false, false, false, 39, 8,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteRMW")           3, false, false, false, 47, 5,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteADC")           1, false, false, false, 12, 5,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 39, 8,  5, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreX")       2, false, false, false, 52, 4,  2, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 56, 3,  6, 1,  0, 0}, // #14
  {DBGFIELD("WriteFStoreY")       2, false, false, false, 52, 4,  2, 1,  0, 0}, // #15
  {DBGFIELD("WriteFLoadY")        1, false, false, false, 56, 3,  7, 1,  0, 0}, // #16
  {DBGFIELD("WriteMicrocoded")    1, false, false, false, 36, 3,  4, 1,  0, 0}, // #17
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 4, false, false, false, 59, 6,  2, 1,  0, 0}, // #18
  {DBGFIELD("WriteFSign")         1, false, false, false,  3, 9,  1, 1,  0, 0}, // #19
  {DBGFIELD("WriteADCRMW")        5, false, false, false, 65, 9,  2, 1,  0, 0}, // #20
  {DBGFIELD("WriteADCLd_ReadAfterLd") 2, false, false, false, 74, 5,  8, 1,  1, 1}, // #21
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 65, 9,  2, 1,  2, 2}, // #22
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 74, 5,  8, 1,  4, 2}, // #23
  {DBGFIELD("WriteALURMW")        4, false, false, false, 59, 6,  2, 1,  0, 0}, // #24
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #25
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 59, 6,  2, 1,  2, 1}, // #26
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #27
  {DBGFIELD("WriteFAdd64X")       1, false, false, false, 87, 6,  5, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #29
  {DBGFIELD("WriteFAddX")         1, false, false, false, 87, 6,  5, 1,  0, 0}, // #30
  {DBGFIELD("WriteNop")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #32
  {DBGFIELD("WriteFAdd64")        1, false, false, false, 87, 6,  5, 1,  0, 0}, // #33
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #34
  {DBGFIELD("WriteFAdd")          1, false, false, false, 93, 10,  5, 1,  0, 0}, // #35
  {DBGFIELD("WriteFAddLd")        2, false, false, false, 79, 8,  9, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #37
  {DBGFIELD("WriteAESDecEnc")     1, false, false, false, 110, 5, 10, 1,  0, 0}, // #38
  {DBGFIELD("WriteAESIMCLd")      3, false, false, false, 115, 7, 11, 1,  0, 0}, // #39
  {DBGFIELD("WriteAESIMC")        2, false, false, false, 122, 5,  7, 1,  0, 0}, // #40
  {DBGFIELD("WriteAESKeyGenLd")   14, false, false, false, 127, 15,  2, 1,  0, 0}, // #41
  {DBGFIELD("WriteAESKeyGen")     14, false, false, false, 142, 13,  6, 1,  0, 0}, // #42
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #43
  {DBGFIELD("WriteFLogic")        1, false, false, false, 111, 4,  1, 1,  0, 0}, // #44
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 155, 12,  8, 1,  2, 1}, // #45
  {DBGFIELD("WriteBEXTR")         2, false, false, false, 167, 10,  3, 1,  0, 0}, // #46
  {DBGFIELD("WriteBEXTRLd")       3, false, false, false, 155, 12,  8, 1,  0, 0}, // #47
  {DBGFIELD("WriteALULd")         1, false, false, false,  1, 2,  8, 1,  0, 0}, // #48
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #49
  {DBGFIELD("WriteFBlend")        1, false, false, false, 111, 4,  1, 1,  0, 0}, // #50
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #51
  {DBGFIELD("WriteFVarBlend")     1, false, false, false, 111, 4,  1, 1,  0, 0}, // #52
  {DBGFIELD("WriteBLSLd")         2, false, false, false, 177, 5,  6, 1,  0, 0}, // #53
  {DBGFIELD("WriteBLS")           1, false, false, false, 182, 3, 12, 1,  0, 0}, // #54
  {DBGFIELD("WriteBSFLd")         2, false, false, false, 185, 10,  7, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSF")           1, false, false, false, 39, 8,  5, 1,  0, 0}, // #56
  {DBGFIELD("WriteBSRLd")         2, false, false, false, 185, 10,  7, 1,  0, 0}, // #57
  {DBGFIELD("WriteBSR")           1, false, false, false, 39, 8,  5, 1,  0, 0}, // #58
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 39, 8,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBSWAP64")       2, false, false, false, 167, 10, 12, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestImmLd")  2, false, false, false, 185, 10,  3, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestRegLd")  10, false, false, false, 195, 12,  8, 1,  0, 0}, // #62
  {DBGFIELD("WriteBitTest")       1, false, false, false, 39, 8,  1, 1,  0, 0}, // #63
  {DBGFIELD("WriteBitTestSetImmRMW") 4, false, false, false, 207, 12,  2, 1,  0, 0}, // #64
  {DBGFIELD("WriteBitTestSetRegRMW") 11, false, false, false, 219, 14, 13, 1,  0, 0}, // #65
  {DBGFIELD("WriteBitTestSet")    1, false, false, false, 39, 8,  1, 1,  0, 0}, // #66
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 2, false, false, false, 185, 10,  7, 1,  2, 1}, // #67
  {DBGFIELD("WriteBZHI")          1, false, false, false, 39, 8,  5, 1,  0, 0}, // #68
  {DBGFIELD("WriteCMOV_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #69
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 2, false, false, false, 233, 7,  6, 1,  1, 1}, // #70
  {DBGFIELD("WriteCMOV")          1, false, false, false, 12, 5,  1, 1,  0, 0}, // #71
  {DBGFIELD("WriteLoad")          1, false, false, false, 56, 3, 10, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 39, 8,  5, 1,  0, 0}, // #73
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false,  1, 2,  8, 1,  2, 1}, // #74
  {DBGFIELD("WriteXCHG")          3, false, false, false, 240, 2, 12, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #76
  {DBGFIELD("WriteFCmp64X")       1, false, false, false, 110, 5, 14, 1,  0, 0}, // #77
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #78
  {DBGFIELD("WriteFCmpX")         1, false, false, false, 110, 5, 14, 1,  0, 0}, // #79
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #80
  {DBGFIELD("WriteFCmp64")        1, false, false, false, 110, 5, 14, 1,  0, 0}, // #81
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #82
  {DBGFIELD("WriteFCmp")          1, false, false, false, 110, 5, 14, 1,  0, 0}, // #83
  {DBGFIELD("WriteCMPXCHG")       5, false, false, false, 242, 5,  5, 1,  0, 0}, // #84
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 2, false, false, false, 247, 11,  7, 1,  6, 1}, // #85
  {DBGFIELD("WriteFComX")         1, false, false, false,  3, 9,  5, 1,  0, 0}, // #86
  {DBGFIELD("WriteFCom")          1, false, false, false, 93, 10,  1, 1,  0, 0}, // #87
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 2, false, false, false, 185, 10,  7, 1,  1, 1}, // #88
  {DBGFIELD("WriteCRC32")         1, false, false, false, 39, 8,  5, 1,  0, 0}, // #89
  {DBGFIELD("WriteCvtI2PDLd")     2, false, false, false, 103, 7,  8, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2PD")       2, false, false, false, 258, 11, 10, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2PSLd")     2, false, false, false, 103, 7,  8, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtI2PS")       1, false, false, false, 110, 5, 14, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPD2ILd")     3, false, false, false, 269, 13,  2, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPD2I")       2, false, false, false, 258, 11, 10, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPD2PSLd")    3, false, false, false, 269, 13,  2, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtPD2PS")      2, false, false, false, 258, 11, 10, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtPS2ILd")     2, false, false, false, 103, 7,  8, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtPS2I")       1, false, false, false, 110, 5, 14, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtPS2PDLd")    2, false, false, false, 103, 7,  8, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtPS2PD")      2, false, false, false, 258, 11, 10, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtSD2ILd")     3, false, false, false, 282, 11,  2, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #103
  {DBGFIELD("WriteCvtSD2I")       2, false, false, false, 293, 9,  6, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 3, false, false, false, 269, 13,  2, 1,  6, 1}, // #105
  {DBGFIELD("WriteCvtSD2SS")      2, false, false, false, 258, 11, 10, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SDLd")     2, false, false, false, 103, 7,  8, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #108
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 2, false, false, false, 258, 11,  6, 1,  0, 1}, // #109
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 2, false, false, false, 258, 11,  6, 1,  7, 1}, // #110
  {DBGFIELD("WriteCvtI2SSLd")     2, false, false, false, 103, 7,  8, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #112
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 2, false, false, false, 258, 11,  6, 1,  0, 1}, // #113
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 2, false, false, false, 258, 11,  6, 1,  7, 1}, // #114
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #115
  {DBGFIELD("WriteCvtSS2SD")      2, false, false, false, 258, 11, 10, 1,  0, 0}, // #116
  {DBGFIELD("WriteCvtSS2ILd")     3, false, false, false, 282, 11,  2, 1,  0, 0}, // #117
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #118
  {DBGFIELD("WriteCvtSS2I")       2, false, false, false, 293, 9,  6, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 302, 10, 15, 1,  2, 2}, // #120
  {DBGFIELD("WriteDiv16")         4, false, false, false, 312, 8, 16, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 302, 10, 17, 1,  2, 2}, // #122
  {DBGFIELD("WriteDiv32")         4, false, false, false, 312, 8, 11, 1,  0, 0}, // #123
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 320, 10, 18, 1,  2, 2}, // #124
  {DBGFIELD("WriteDiv64")         3, false, false, false, 330, 8, 13, 1,  0, 0}, // #125
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 330, 8, 19, 1,  2, 2}, // #126
  {DBGFIELD("WriteDiv8")          3, false, false, false, 330, 8, 20, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 2, false, false, false, 247, 11, 15, 1,  6, 1}, // #128
  {DBGFIELD("WriteFDiv64X")       1, false, false, false,  3, 9, 21, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 2, false, false, false, 247, 11, 13, 1,  6, 1}, // #130
  {DBGFIELD("WriteFDivX")         1, false, false, false,  3, 9,  8, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd")        2, false, false, false, 247, 11, 13, 1,  0, 0}, // #132
  {DBGFIELD("WriteFDiv")          1, false, false, false,  3, 9,  8, 1,  0, 0}, // #133
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 2, false, false, false, 247, 11, 17, 1,  6, 1}, // #134
  {DBGFIELD("WriteFDiv64")        1, false, false, false,  3, 9, 21, 1,  0, 0}, // #135
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 2, false, false, false, 247, 11, 13, 1,  6, 1}, // #136
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 4, false, false, false, 338, 9, 16, 1,  6, 1}, // #137
  {DBGFIELD("WriteDPPD")          3, false, false, false, 347, 7, 22, 1,  0, 0}, // #138
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 7, false, false, false, 354, 14, 23, 1,  6, 1}, // #139
  {DBGFIELD("WriteDPPS")          6, false, false, false, 368, 12, 21, 1,  0, 0}, // #140
  {DBGFIELD("WriteStore")         2, false, false, false, 52, 4,  2, 1,  0, 0}, // #141
  {DBGFIELD("WriteVecExtractSt")  3, false, false, false, 380, 9, 17, 1,  0, 0}, // #142
  {DBGFIELD("WriteVecExtract")    2, false, false, false, 389, 11, 14, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUX")       1, false, false, false, 110, 5,  1, 1,  0, 0}, // #144
  {DBGFIELD("WriteFComLd")        2, false, false, false, 400, 15,  7, 1,  0, 0}, // #145
  {DBGFIELD("WriteEMMS")          10, false, false, false, 415, 9,  9, 1,  0, 0}, // #146
  {DBGFIELD("WriteFLDC")          2, false, false, false, 424, 6,  1, 1,  0, 0}, // #147
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #148
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 110, 5, 10, 1,  0, 0}, // #149
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #150
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 4, false, false, false, 430, 12,  2, 1,  6, 1}, // #151
  {DBGFIELD("WriteFHAdd")         3, false, false, false, 442, 10,  3, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 302, 10, 15, 1,  2, 2}, // #153
  {DBGFIELD("WriteIDiv16")        4, false, false, false, 312, 8, 16, 1,  0, 0}, // #154
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 302, 10, 17, 1,  2, 2}, // #155
  {DBGFIELD("WriteIDiv32")        4, false, false, false, 312, 8, 11, 1,  0, 0}, // #156
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 320, 10, 18, 1,  2, 2}, // #157
  {DBGFIELD("WriteIDiv64")        3, false, false, false, 330, 8, 13, 1,  0, 0}, // #158
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 330, 8, 19, 1,  2, 2}, // #159
  {DBGFIELD("WriteIDiv8")         3, false, false, false, 330, 8, 20, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 452, 12,  9, 1,  2, 2}, // #161
  {DBGFIELD("WriteIMul16")        4, false, false, false, 464, 10, 10, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 2, false, false, false, 185, 10,  7, 1,  1, 1}, // #163
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 474, 10, 22, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul16Reg")     1, false, false, false, 39, 8,  5, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 484, 8, 14, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 492, 12, 22, 1,  2, 2}, // #167
  {DBGFIELD("WriteIMul32")        3, false, false, false, 504, 10, 14, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 2, false, false, false, 185, 10,  7, 1,  1, 1}, // #169
  {DBGFIELD("WriteIMul32ImmLd")   2, false, false, false, 185, 10,  7, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 39, 8,  5, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 39, 8,  5, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 514, 14, 22, 1,  2, 2}, // #173
  {DBGFIELD("WriteIMul64")        2, false, false, false, 528, 12, 14, 1,  0, 0}, // #174
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 2, false, false, false, 185, 10,  7, 1,  1, 1}, // #175
  {DBGFIELD("WriteIMul64ImmLd")   2, false, false, false, 185, 10,  7, 1,  0, 0}, // #176
  {DBGFIELD("WriteIMul64Reg")     1, false, false, false, 39, 8,  5, 1,  0, 0}, // #177
  {DBGFIELD("WriteIMul64Imm")     1, false, false, false, 39, 8,  5, 1,  0, 0}, // #178
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 2, false, false, false, 185, 10,  7, 1,  2, 2}, // #179
  {DBGFIELD("WriteIMul8")         1, false, false, false, 39, 8,  5, 1,  0, 0}, // #180
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 2, false, false, false, 540, 12,  7, 1,  6, 1}, // #181
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 93, 10,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecLogicX")     1, false, false, false, 111, 4,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteShuffle")       1, false, false, false, 93, 10,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 12, 5,  5, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 56, 3,  6, 1,  0, 0}, // #186
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 552, 11,  6, 1,  0, 0}, // #187
  {DBGFIELD("WriteFLD0")          1, false, false, false, 563, 6,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteFLD1")          2, false, false, false, 424, 6,  1, 1,  0, 0}, // #189
  {DBGFIELD("WriteFence")         1, false, false, false, 12, 5, 12, 1,  0, 0}, // #190
  {DBGFIELD("WriteLZCNTLd")       2, false, false, false, 185, 10,  7, 1,  0, 0}, // #191
  {DBGFIELD("WriteLZCNT")         1, false, false, false, 39, 8,  5, 1,  0, 0}, // #192
  {DBGFIELD("WriteVecStoreX")     2, false, false, false, 52, 4,  2, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStore")      2, false, false, false, 52, 4,  2, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false,  3, 9,  5, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 56, 3,  6, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #197
  {DBGFIELD("WriteVecMoveX")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecStoreNT")    2, false, false, false, 52, 4, 25, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecMove")       1, false, false, false, 563, 6,  1, 1,  0, 0}, // #200
  {DBGFIELD("WriteVecALULd")      2, false, false, false, 247, 11, 22, 1,  0, 0}, // #201
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 2, false, false, false, 540, 12, 22, 1,  6, 1}, // #202
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 2, false, false, false, 247, 11, 22, 1,  6, 1}, // #203
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 2, false, false, false, 569, 8, 22, 1,  6, 1}, // #204
  {DBGFIELD("WriteVecLogic")      1, false, false, false, 563, 6,  1, 1,  0, 0}, // #205
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 577, 12,  8, 1,  6, 1}, // #206
  {DBGFIELD("WritePHAdd")         3, false, false, false, 589, 10,  5, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 2, false, false, false, 79, 8,  7, 1,  1, 1}, // #208
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 2, false, false, false, 599, 10, 14, 1,  7, 1}, // #209
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 2, false, false, false, 247, 11, 24, 1,  6, 1}, // #210
  {DBGFIELD("WriteVecIMul")       1, false, false, false,  3, 9, 10, 1,  0, 0}, // #211
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false,  3, 9,  5, 1,  0, 0}, // #212
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #213
  {DBGFIELD("WritePSADBW")        1, false, false, false, 93, 10,  5, 1,  0, 0}, // #214
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 3, false, false, false, 609, 15,  8, 1,  6, 1}, // #215
  {DBGFIELD("WriteVarShuffle")    2, false, false, false, 624, 13,  5, 1,  0, 0}, // #216
  {DBGFIELD("WriteShuffleLd")     2, false, false, false, 540, 12, 22, 1,  0, 0}, // #217
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false,  3, 9,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 2, false, false, false, 247, 11, 22, 1,  6, 1}, // #219
  {DBGFIELD("WriteVecShift")      1, false, false, false,  3, 9,  1, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMoveX")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFShuffleLd")    2, false, false, false, 540, 12,  7, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStore")        2, false, false, false, 52, 4,  2, 1,  0, 0}, // #223
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false,  3, 9,  5, 1,  0, 0}, // #224
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 56, 3,  6, 1,  0, 0}, // #225
  {DBGFIELD("WriteStoreNT")       2, false, false, false, 52, 4, 26, 1,  0, 0}, // #226
  {DBGFIELD("WriteFStoreNTX")     2, false, false, false, 52, 4, 27, 1,  0, 0}, // #227
  {DBGFIELD("WriteFStoreNT")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #228
  {DBGFIELD("WriteFLoad")         1, false, false, false, 56, 3,  6, 1,  0, 0}, // #229
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 3, false, false, false, 637, 12,  8, 1,  6, 1}, // #230
  {DBGFIELD("WriteMPSAD")         2, false, false, false, 599, 10, 14, 1,  0, 0}, // #231
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #232
  {DBGFIELD("WriteFMul64X")       1, false, false, false, 110, 5, 14, 1,  0, 0}, // #233
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #234
  {DBGFIELD("WriteFMulX")         1, false, false, false, 110, 5, 14, 1,  0, 0}, // #235
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #236
  {DBGFIELD("WriteFMul64")        1, false, false, false, 110, 5, 14, 1,  0, 0}, // #237
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #238
  {DBGFIELD("WriteFMul")          1, false, false, false, 110, 5, 14, 1,  0, 0}, // #239
  {DBGFIELD("WriteMULX32Ld")      3, false, false, false, 492, 12, 22, 1,  0, 0}, // #240
  {DBGFIELD("WriteMULX32")        2, false, false, false, 504, 10, 14, 1,  0, 0}, // #241
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 4, false, false, false, 492, 12, 28, 2,  2, 1}, // #242
  {DBGFIELD("WriteIMulH_WriteMULX32") 3, false, false, false, 504, 10, 30, 2,  0, 0}, // #243
  {DBGFIELD("WriteMULX64Ld")      2, false, false, false, 514, 14, 22, 1,  0, 0}, // #244
  {DBGFIELD("WriteMULX64")        1, false, false, false, 528, 12, 14, 1,  0, 0}, // #245
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 3, false, false, false, 514, 14, 28, 2,  2, 1}, // #246
  {DBGFIELD("WriteIMulH_WriteMULX64") 2, false, false, false, 528, 12, 30, 2,  0, 0}, // #247
  {DBGFIELD("WriteFMulLd")        2, false, false, false, 103, 7,  8, 1,  0, 0}, // #248
  {DBGFIELD("WriteVecALUXLd")     2, false, false, false, 103, 7,  7, 1,  0, 0}, // #249
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #250
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 87, 6,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #252
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #253
  {DBGFIELD("WriteVarBlend")      1, false, false, false, 111, 4,  1, 1,  0, 0}, // #254
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #255
  {DBGFIELD("WriteBlend")         1, false, false, false, 87, 6,  1, 1,  0, 0}, // #256
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 2, false, false, false, 540, 12,  9, 1,  6, 1}, // #257
  {DBGFIELD("WriteCLMul")         1, false, false, false, 93, 10,  5, 1,  0, 0}, // #258
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8, false, false, false, 649, 16, 32, 1,  6, 1}, // #259
  {DBGFIELD("WritePCmpEStrI")     8, false, false, false, 665, 14, 16, 1,  0, 0}, // #260
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 9, false, false, false, 679, 16, 20, 1,  6, 1}, // #261
  {DBGFIELD("WritePCmpEStrM")     9, false, false, false, 695, 14, 16, 1,  0, 0}, // #262
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 4, false, false, false, 709, 11, 32, 1,  6, 1}, // #263
  {DBGFIELD("WritePCmpIStrI")     3, false, false, false, 720, 9,  8, 1,  0, 0}, // #264
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 4, false, false, false, 709, 11, 16, 1,  6, 1}, // #265
  {DBGFIELD("WritePCmpIStrM")     3, false, false, false, 720, 9,  8, 1,  0, 0}, // #266
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #267
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 729, 8, 22, 1,  6, 1}, // #268
  {DBGFIELD("WritePHAddX")        3, false, false, false, 737, 6, 12, 1,  0, 0}, // #269
  {DBGFIELD("WritePHMINPOSLd")    2, false, false, false, 247, 11,  8, 1,  0, 0}, // #270
  {DBGFIELD("WritePHMINPOS")      1, false, false, false,  3, 9, 14, 1,  0, 0}, // #271
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #272
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false,  3, 9,  5, 1,  0, 0}, // #273
  {DBGFIELD("WriteShuffleXLd")    2, false, false, false, 79, 8,  7, 1,  0, 0}, // #274
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 3, false, false, false, 115, 7, 13, 1,  6, 1}, // #275
  {DBGFIELD("WritePMULLD")        2, false, false, false, 122, 5,  9, 1,  0, 0}, // #276
  {DBGFIELD("WriteCopy")          3, false, false, false, 47, 5, 20, 1,  0, 0}, // #277
  {DBGFIELD("WritePOPCNTLd")      2, false, false, false, 185, 10,  7, 1,  0, 0}, // #278
  {DBGFIELD("WritePOPCNT")        1, false, false, false, 39, 8,  5, 1,  0, 0}, // #279
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 2, false, false, false, 540, 12,  9, 1,  6, 1}, // #280
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 93, 10,  5, 1,  0, 0}, // #281
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #282
  {DBGFIELD("WriteVarShuffleX")   1, false, false, false, 87, 6,  1, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 110, 5,  1, 1,  0, 0}, // #284
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #285
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 743, 7, 12, 1,  0, 0}, // #286
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 3, false, false, false, 609, 15, 22, 1,  6, 1}, // #287
  {DBGFIELD("WriteVecTest")       2, false, false, false, 624, 13, 14, 1,  0, 0}, // #288
  {DBGFIELD("WriteRotateLd_WriteRMW") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #289
  {DBGFIELD("WriteRotateLd_WriteRotate") 6, false, false, false, 750, 5, 35, 2,  0, 0}, // #290
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 10, false, false, false, 755, 14, 37, 2,  0, 0}, // #291
  {DBGFIELD("WriteRotateCLLd_WriteRotateCL") 9, false, false, false, 769, 10, 39, 2,  0, 0}, // #292
  {DBGFIELD("WriteRotate")        3, false, false, false, 779, 5, 12, 1,  0, 0}, // #293
  {DBGFIELD("WriteRotateCL")      2, false, false, false, 784, 5, 12, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRcpXLd")       2, false, false, false, 247, 11,  8, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRcpX")         1, false, false, false,  3, 9, 14, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRcpLd")        2, false, false, false, 247, 11,  8, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 2, false, false, false, 247, 11,  8, 1,  6, 1}, // #298
  {DBGFIELD("WriteFRcp")          1, false, false, false,  3, 9, 14, 1,  0, 0}, // #299
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 12, 5,  2, 1,  0, 0}, // #300
  {DBGFIELD("WriteShift")         1, false, false, false, 12, 5,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRndLd")        3, false, false, false, 115, 7, 11, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRnd")          2, false, false, false, 122, 5,  7, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 3, false, false, false, 115, 7, 11, 1,  6, 1}, // #304
  {DBGFIELD("WriteFRsqrtXLd")     2, false, false, false, 247, 11,  8, 1,  0, 0}, // #305
  {DBGFIELD("WriteFRsqrtX")       1, false, false, false,  3, 9, 14, 1,  0, 0}, // #306
  {DBGFIELD("WriteFRsqrtLd")      2, false, false, false, 247, 11,  8, 1,  0, 0}, // #307
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 2, false, false, false, 247, 11,  8, 1,  6, 1}, // #308
  {DBGFIELD("WriteFRsqrt")        1, false, false, false,  3, 9, 14, 1,  0, 0}, // #309
  {DBGFIELD("WriteShiftLd_WriteRMW") 4, false, false, false, 789, 9, 33, 2,  0, 0}, // #310
  {DBGFIELD("WriteShiftLd_WriteShift") 2, false, false, false, 784, 5, 33, 2,  0, 0}, // #311
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 5, false, false, false, 798, 9, 33, 2,  0, 0}, // #312
  {DBGFIELD("WriteShiftCLLd_WriteShiftCL") 4, false, false, false, 807, 5, 35, 2,  0, 0}, // #313
  {DBGFIELD("WriteShiftCL")       2, false, false, false, 784, 5, 12, 1,  0, 0}, // #314
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 12, 5,  2, 1,  2, 1}, // #315
  {DBGFIELD("WriteSETCCStore")    4, false, false, false, 812, 8, 24, 1,  0, 0}, // #316
  {DBGFIELD("WriteSETCC")         2, false, false, false, 784, 5, 12, 1,  0, 0}, // #317
  {DBGFIELD("WriteSHDmrcl")       6, false, false, false, 820, 14,  2, 1,  0, 0}, // #318
  {DBGFIELD("WriteSHDmri")        5, false, false, false, 834, 12,  2, 1,  0, 0}, // #319
  {DBGFIELD("WriteSHDrrcl")       3, false, false, false, 504, 10, 10, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrt64XLd")    2, false, false, false, 247, 11, 41, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrt64X")      1, false, false, false,  3, 9, 13, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtXLd")      2, false, false, false, 247, 11, 17, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrtX")        1, false, false, false,  3, 9,  2, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt64Ld")     2, false, false, false, 247, 11, 18, 1,  0, 0}, // #325
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 2, false, false, false, 247, 11, 18, 1,  6, 1}, // #326
  {DBGFIELD("WriteFSqrt64")       1, false, false, false,  3, 9, 13, 1,  0, 0}, // #327
  {DBGFIELD("WriteFSqrtLd")       2, false, false, false, 247, 11, 17, 1,  0, 0}, // #328
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 2, false, false, false, 247, 11, 17, 1,  6, 1}, // #329
  {DBGFIELD("WriteFSqrt")         1, false, false, false,  3, 9,  2, 1,  0, 0}, // #330
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 846, 10, 23, 1,  0, 0}, // #331
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 856, 12,  2, 1,  0, 0}, // #332
  {DBGFIELD("WriteTZCNTLd")       2, false, false, false, 185, 10,  7, 1,  0, 0}, // #333
  {DBGFIELD("WriteTZCNT")         1, false, false, false, 39, 8,  5, 1,  0, 0}, // #334
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFMALd")         2, false, false, false, 103, 7,  8, 1,  0, 0}, // #336
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 2, false, false, false, 79, 8,  8, 1,  6, 1}, // #337
  {DBGFIELD("WriteFAdd64Y")       1, false, false, false, 87, 6,  5, 1,  0, 0}, // #338
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 2, false, false, false, 79, 8,  8, 1,  6, 1}, // #341
  {DBGFIELD("WriteFAddY")         1, false, false, false, 87, 6,  5, 1,  0, 0}, // #342
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 79, 8, 22, 1,  6, 1}, // #345
  {DBGFIELD("WriteShuffleY")      1, false, false, false, 87, 6,  1, 1,  0, 0}, // #346
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 2, false, false, false, 104, 6, 22, 1,  6, 1}, // #349
  {DBGFIELD("WriteFLogicY")       1, false, false, false, 111, 4,  1, 1,  0, 0}, // #350
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteCvtPH2PSY")     2, false, false, false, 258, 11,  7, 1,  0, 0}, // #353
  {DBGFIELD("WriteCvtPH2PS")      2, false, false, false, 258, 11,  3, 1,  0, 0}, // #354
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 868, 6,  9, 1,  6, 1}, // #355
  {DBGFIELD("WriteFVarBlendY")    3, false, false, false, 874, 4,  5, 1,  0, 0}, // #356
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 2, false, false, false, 104, 6, 22, 1,  6, 1}, // #359
  {DBGFIELD("WriteFBlendY")       1, false, false, false, 111, 4,  1, 1,  0, 0}, // #360
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 868, 6,  9, 1,  8, 2}, // #361
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 104, 6,  7, 1,  8, 2}, // #362
  {DBGFIELD("WriteShuffle256Ld")  2, false, false, false, 540, 12,  8, 1,  0, 0}, // #363
  {DBGFIELD("WriteShuffle256")    1, false, false, false, 93, 10,  5, 1,  0, 0}, // #364
  {DBGFIELD("WriteShuffleYLd")    2, false, false, false, 79, 8, 22, 1,  0, 0}, // #365
  {DBGFIELD("WriteFShuffle256")   1, false, false, false, 93, 10,  5, 1,  0, 0}, // #366
  {DBGFIELD("WriteFShuffle256Ld") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #367
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #368
  {DBGFIELD("WriteFCmp64Y")       1, false, false, false, 110, 5, 14, 1,  0, 0}, // #369
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #370
  {DBGFIELD("WriteFCmpY")         1, false, false, false, 110, 5, 14, 1,  0, 0}, // #371
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteVarShuffle256Ld") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #374
  {DBGFIELD("WriteVarShuffle256") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #375
  {DBGFIELD("WriteCvtI2PDYLd")    2, false, false, false, 103, 7,  2, 1,  0, 0}, // #376
  {DBGFIELD("WriteCvtI2PDY")      2, false, false, false, 258, 11,  6, 1,  0, 0}, // #377
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtI2PSYLd")    2, false, false, false, 103, 7,  2, 1,  0, 0}, // #380
  {DBGFIELD("WriteCvtI2PSY")      1, false, false, false, 110, 5, 14, 1,  0, 0}, // #381
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 3, false, false, false, 269, 13,  2, 1,  6, 1}, // #384
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 3, false, false, false, 269, 13, 11, 1,  6, 1}, // #385
  {DBGFIELD("WriteCvtPD2PSY")     2, false, false, false, 258, 11,  6, 1,  0, 0}, // #386
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPD2PSYLd")   3, false, false, false, 269, 13, 11, 1,  0, 0}, // #389
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPD2IYLd")    3, false, false, false, 269, 13, 11, 1,  0, 0}, // #391
  {DBGFIELD("WriteCvtPD2IY")      2, false, false, false, 258, 11,  6, 1,  0, 0}, // #392
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2IYLd")    2, false, false, false, 103, 7,  2, 1,  0, 0}, // #395
  {DBGFIELD("WriteCvtPS2IY")      1, false, false, false, 110, 5, 14, 1,  0, 0}, // #396
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPS2PDYLd")   2, false, false, false, 103, 7,  2, 1,  0, 0}, // #399
  {DBGFIELD("WriteCvtPS2PDY")     2, false, false, false, 258, 11,  6, 1,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteCvtPH2PSYLd")   2, false, false, false, 103, 7,  2, 1,  0, 0}, // #403
  {DBGFIELD("WriteCvtPH2PSLd")    2, false, false, false, 103, 7,  2, 1,  0, 0}, // #404
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtPS2PHYSt")   3, false, false, false, 878, 8,  2, 1,  0, 0}, // #407
  {DBGFIELD("WriteCvtPS2PHY")     2, false, false, false, 258, 11,  7, 1,  0, 0}, // #408
  {DBGFIELD("WriteCvtPS2PHSt")    3, false, false, false, 878, 8,  2, 1,  0, 0}, // #409
  {DBGFIELD("WriteCvtPS2PH")      2, false, false, false, 258, 11,  3, 1,  0, 0}, // #410
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 3, false, false, false, 282, 11,  2, 1,  6, 1}, // #413
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 3, false, false, false, 282, 11,  2, 1,  6, 1}, // #414
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #415
  {DBGFIELD("WritePSADBWY")       1, false, false, false, 93, 10,  5, 1,  0, 0}, // #416
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 2, false, false, false, 247, 11, 23, 1,  6, 1}, // #419
  {DBGFIELD("WriteFDiv64Y")       1, false, false, false,  3, 9, 21, 1,  0, 0}, // #420
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 2, false, false, false, 247, 11, 17, 1,  6, 1}, // #423
  {DBGFIELD("WriteFDivY")         1, false, false, false,  3, 9,  8, 1,  0, 0}, // #424
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #427
  {DBGFIELD("WriteFMAX")          1, false, false, false, 110, 5, 14, 1,  0, 0}, // #428
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #429
  {DBGFIELD("WriteFMAY")          1, false, false, false, 110, 5, 14, 1,  0, 0}, // #430
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 7, false, false, false, 354, 14, 19, 1,  6, 1}, // #433
  {DBGFIELD("WriteDPPSY")         6, false, false, false, 368, 12, 21, 1,  0, 0}, // #434
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #435
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 103, 7,  2, 1, 10, 2}, // #436
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  8, 1, 10, 2}, // #437
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 2, false, false, false, 103, 7,  8, 1, 10, 2}, // #439
  {DBGFIELD("WriteFMA")           1, false, false, false, 110, 5, 14, 1,  0, 0}, // #440
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 103, 7,  2, 1,  8, 2}, // #441
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 103, 7,  8, 1,  8, 2}, // #442
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 2, false, false, false, 103, 7,  8, 1,  8, 2}, // #443
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 3, false, false, false, 115, 7, 16, 1,  6, 1}, // #444
  {DBGFIELD("WriteFRndY")         2, false, false, false, 122, 5,  7, 1,  0, 0}, // #445
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #446
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #449
  {DBGFIELD("WriteVecIMulY")      1, false, false, false, 110, 5, 10, 1,  0, 0}, // #450
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #453
  {DBGFIELD("WriteVecALUY")       1, false, false, false, 110, 5,  1, 1,  0, 0}, // #454
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 4, false, false, false, 430, 12, 24, 1,  6, 1}, // #457
  {DBGFIELD("WriteFHAddY")        3, false, false, false, 442, 10, 10, 1,  0, 0}, // #458
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #459
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #460
  {DBGFIELD("WriteVecLoadY")      1, false, false, false, 56, 3,  7, 1,  0, 0}, // #461
  {DBGFIELD("WriteFMaskedStore64Y") 3, false, false, false, 886, 12, 21, 1,  0, 0}, // #462
  {DBGFIELD("WriteFMaskedLoadY")  2, false, false, false, 104, 6, 22, 1,  0, 0}, // #463
  {DBGFIELD("WriteFMaskedStore64") 3, false, false, false, 886, 12, 21, 1,  0, 0}, // #464
  {DBGFIELD("WriteFMaskedLoad")   2, false, false, false, 104, 6,  7, 1,  0, 0}, // #465
  {DBGFIELD("WriteFMaskedStore32Y") 3, false, false, false, 886, 12, 21, 1,  0, 0}, // #466
  {DBGFIELD("WriteFMaskedStore32") 3, false, false, false, 886, 12, 21, 1,  0, 0}, // #467
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteFMoveY")        0, false, false, false,  0, 0,  1, 1,  0, 0}, // #470
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteFShuffleYLd")   2, false, false, false, 540, 12, 22, 1,  0, 0}, // #472
  {DBGFIELD("WriteFShuffleY")     1, false, false, false, 93, 10,  1, 1,  0, 0}, // #473
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteVecStoreY")     2, false, false, false, 52, 4,  2, 1,  0, 0}, // #476
  {DBGFIELD("WriteVecMoveY")      0, false, false, false,  0, 0,  1, 1,  0, 0}, // #477
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVecLoadNTY")    1, false, false, false, 56, 3,  7, 1,  0, 0}, // #479
  {DBGFIELD("WriteVecStoreNTY")   2, false, false, false, 52, 4, 44, 1,  0, 0}, // #480
  {DBGFIELD("WriteFStoreNTY")     2, false, false, false, 52, 4, 45, 1,  0, 0}, // #481
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 3, false, false, false, 637, 12,  2, 1,  6, 1}, // #482
  {DBGFIELD("WriteMPSADY")        2, false, false, false, 599, 10, 14, 1,  0, 0}, // #483
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #484
  {DBGFIELD("WriteFMul64Y")       1, false, false, false, 110, 5, 14, 1,  0, 0}, // #485
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #488
  {DBGFIELD("WriteFMulY")         1, false, false, false, 110, 5, 14, 1,  0, 0}, // #489
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteVecALUYLd")     2, false, false, false, 103, 7, 22, 1,  0, 0}, // #492
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 2, false, false, false, 104, 6, 22, 1,  6, 1}, // #494
  {DBGFIELD("WriteVecLogicY")     1, false, false, false, 111, 4,  1, 1,  0, 0}, // #495
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 2, false, false, false, 104, 6, 22, 1,  6, 1}, // #498
  {DBGFIELD("WriteBlendY")        1, false, false, false, 111, 4,  1, 1,  0, 0}, // #499
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 4, false, false, false, 868, 6,  9, 1,  6, 1}, // #500
  {DBGFIELD("WriteVarBlendY")     3, false, false, false, 874, 4,  5, 1,  0, 0}, // #501
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 4, false, false, false, 868, 6,  9, 1,  8, 2}, // #504
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 104, 6,  7, 1,  8, 2}, // #505
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 79, 8, 22, 1,  8, 2}, // #506
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 79, 8, 22, 1, 10, 2}, // #507
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 79, 8,  7, 1,  8, 2}, // #508
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 79, 8,  7, 1, 10, 2}, // #509
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 103, 7, 24, 1, 10, 2}, // #510
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 103, 7, 24, 1, 10, 2}, // #511
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #513
  {DBGFIELD("WriteFVarShuffle256") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 2, false, false, false, 540, 12, 22, 1,  8, 2}, // #515
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 2, false, false, false, 540, 12, 22, 1, 10, 2}, // #516
  {DBGFIELD("WriteFVarShuffleY")  1, false, false, false, 93, 10,  1, 1,  0, 0}, // #517
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 540, 12,  7, 1,  8, 2}, // #518
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 540, 12,  7, 1, 10, 2}, // #519
  {DBGFIELD("WriteFVarShuffle")   1, false, false, false, 93, 10,  1, 1,  0, 0}, // #520
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 540, 12, 22, 1,  6, 1}, // #521
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 2, false, false, false, 540, 12,  7, 1,  6, 1}, // #522
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 4, false, false, false, 729, 8,  9, 1,  6, 1}, // #525
  {DBGFIELD("WritePHAddY")        3, false, false, false, 737, 6, 12, 1,  0, 0}, // #526
  {DBGFIELD("WriteVecInsert")     2, false, false, false, 599, 10, 14, 1,  0, 0}, // #527
  {DBGFIELD("WriteVecIMulXLd")    2, false, false, false, 103, 7, 24, 1,  0, 0}, // #528
  {DBGFIELD("WriteVecIMulYLd")    2, false, false, false, 103, 7, 24, 1,  0, 0}, // #529
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteVecMaskedStore32Y") 3, false, false, false, 886, 12, 21, 1,  0, 0}, // #531
  {DBGFIELD("WriteVecMaskedLoadY") 2, false, false, false, 104, 6, 22, 1,  0, 0}, // #532
  {DBGFIELD("WriteVecMaskedStore32") 3, false, false, false, 886, 12, 21, 1,  0, 0}, // #533
  {DBGFIELD("WriteVecMaskedLoad") 2, false, false, false, 104, 6,  7, 1,  0, 0}, // #534
  {DBGFIELD("WriteVecMaskedStore64Y") 3, false, false, false, 886, 12, 21, 1,  0, 0}, // #535
  {DBGFIELD("WriteVecMaskedStore64") 3, false, false, false, 886, 12, 21, 1,  0, 0}, // #536
  {DBGFIELD("WriteVPMOV256Ld")    2, false, false, false, 540, 12,  8, 1,  0, 0}, // #537
  {DBGFIELD("WriteVPMOV256")      1, false, false, false, 93, 10,  5, 1,  0, 0}, // #538
  {DBGFIELD("WriteVecMOVMSKY")    1, false, false, false,  3, 9, 14, 1,  0, 0}, // #539
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 3, false, false, false, 115, 7, 13, 1,  6, 1}, // #540
  {DBGFIELD("WritePMULLDY")       2, false, false, false, 122, 5,  9, 1,  0, 0}, // #541
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 2, false, false, false, 79, 8,  7, 1,  8, 2}, // #544
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 2, false, false, false, 79, 8,  7, 1, 10, 2}, // #545
  {DBGFIELD("WriteVecShiftImmXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #546
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmY")  1, false, false, false, 110, 5,  1, 1,  0, 0}, // #548
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #551
  {DBGFIELD("WriteVarVecShift")   1, false, false, false, 110, 5,  1, 1,  0, 0}, // #552
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #553
  {DBGFIELD("WriteVarVecShiftY")  1, false, false, false, 110, 5,  1, 1,  0, 0}, // #554
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #557
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 79, 8, 22, 1,  6, 1}, // #558
  {DBGFIELD("WriteVarShuffleY")   1, false, false, false, 87, 6,  1, 1,  0, 0}, // #559
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #563
  {DBGFIELD("WriteVecShiftY")     2, false, false, false, 258, 11, 14, 1,  0, 0}, // #564
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 3, false, false, false, 609, 15,  2, 1,  6, 1}, // #567
  {DBGFIELD("WriteVecTestY")      2, false, false, false, 624, 13,  3, 1,  0, 0}, // #568
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 2, false, false, false, 247, 11,  8, 1,  6, 1}, // #569
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 2, false, false, false, 247, 11,  2, 1,  6, 1}, // #570
  {DBGFIELD("WriteFRcpY")         1, false, false, false,  3, 9, 14, 1,  0, 0}, // #571
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFRcpYLd")       2, false, false, false, 247, 11,  2, 1,  0, 0}, // #574
  {DBGFIELD("WriteFRndYLd")       3, false, false, false, 115, 7, 16, 1,  0, 0}, // #575
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 2, false, false, false, 247, 11,  8, 1,  6, 1}, // #576
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 2, false, false, false, 247, 11,  2, 1,  6, 1}, // #577
  {DBGFIELD("WriteFRsqrtY")       1, false, false, false,  3, 9, 14, 1,  0, 0}, // #578
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFRsqrtYLd")     2, false, false, false, 247, 11,  2, 1,  0, 0}, // #581
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 2, false, false, false, 540, 12, 22, 1,  6, 1}, // #582
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrt64YLd")    2, false, false, false, 247, 11, 46, 1,  0, 0}, // #584
  {DBGFIELD("WriteFSqrt64Y")      1, false, false, false,  3, 9, 13, 1,  0, 0}, // #585
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 2, false, false, false, 247, 11, 41, 1,  6, 1}, // #586
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 2, false, false, false, 247, 11, 46, 1,  6, 1}, // #587
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #589
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 2, false, false, false, 247, 11, 17, 1,  6, 1}, // #590
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 2, false, false, false, 247, 11, 15, 1,  6, 1}, // #591
  {DBGFIELD("WriteFSqrtY")        1, false, false, false,  3, 9,  2, 1,  0, 0}, // #592
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #594
  {DBGFIELD("WriteFSqrtYLd")      2, false, false, false, 247, 11, 15, 1,  0, 0}, // #595
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 2, false, false, false, 247, 11,  8, 1,  6, 1}, // #596
  {DBGFIELD("WriteFTestY")        1, false, false, false,  3, 9, 10, 1,  0, 0}, // #597
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 2, false, false, false, 247, 11,  7, 1,  6, 1}, // #598
  {DBGFIELD("WriteFTest")         1, false, false, false,  3, 9,  5, 1,  0, 0}, // #599
  {DBGFIELD("WriteALULd_WriteRMW") 4, false, false, false, 59, 6, 47, 2,  0, 0}, // #600
  {DBGFIELD("COPY")               8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #601
  {DBGFIELD("XAM_F")              1, false, false, false,  3, 9, 12, 1,  0, 0}, // #602
  {DBGFIELD("LD_Frr")             1, false, false, false, 36, 3,  1, 1,  0, 0}, // #603
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 182, 3,  1, 1,  0, 0}, // #604
  {DBGFIELD("RCL16m1_RCL16m1_EVEX_RCL16mi_RCL16mi_EVEX_RCL32m1_RCL32m1_EVEX_RCL32mi_RCL32mi_EVEX_RCL64m1_RCL64m1_EVEX_RCL64mi_RCL64mi_EVEX_RCL8m1_RCL8m1_EVEX_RCL8mi_RCL8mi_EVEX_RCR16m1_RCR16m1_EVEX_RCR16mi_RCR16mi_EVEX_RCR32m1_RCR32m1_EVEX_RCR32mi_RCR32mi_EVEX_RCR64m1_RCR64m1_EVEX_RCR64mi_RCR64mi_EVEX_RCR8m1_RCR8m1_EVEX_RCR8mi_RCR8mi_EVEX_ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #605
  {DBGFIELD("RCL16m1_ND_RCL16mi_ND_RCL32m1_ND_RCL32mi_ND_RCL64m1_ND_RCL64mi_ND_RCL8m1_ND_RCL8mi_ND_RCR16m1_ND_RCR16mi_ND_RCR32m1_ND_RCR32mi_ND_RCR64m1_ND_RCR64mi_ND_RCR8m1_ND_RCR8mi_ND_ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 6, false, false, false, 750, 5, 35, 2,  0, 0}, // #606
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX_RCR16mCL_RCR16mCL_EVEX_RCR32mCL_RCR32mCL_EVEX_RCR64mCL_RCR64mCL_EVEX_RCR8mCL_RCR8mCL_EVEX_ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 10, false, false, false, 755, 14, 37, 2,  0, 0}, // #607
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND_RCR16mCL_ND_RCR32mCL_ND_RCR64mCL_ND_RCR8mCL_ND_ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 9, false, false, false, 769, 10, 39, 2,  0, 0}, // #608
  {DBGFIELD("SAR16m1_SAR16m1_EVEX_SAR16m1_NF_SAR16mi_SAR16mi_EVEX_SAR16mi_NF_SAR32m1_SAR32m1_EVEX_SAR32m1_NF_SAR32mi_SAR32mi_EVEX_SAR32mi_NF_SAR64m1_SAR64m1_EVEX_SAR64m1_NF_SAR64mi_SAR64mi_EVEX_SAR64mi_NF_SAR8m1_SAR8m1_EVEX_SAR8m1_NF_SAR8mi_SAR8mi_EVEX_SAR8mi_NF_SHL16m1_SHL16m1_EVEX_SHL16m1_NF_SHL16mi_SHL16mi_EVEX_SHL16mi_NF_SHL32m1_SHL32m1_EVEX_SHL32m1_NF_SHL32mi_SHL32mi_EVEX_SHL32mi_NF_SHL64m1_SHL64m1_EVEX_SHL64m1_NF_SHL64mi_SHL64mi_EVEX_SHL64mi_NF_SHL8m1_SHL8m1_EVEX_SHL8m1_NF_SHL8mi_SHL8mi_EVEX_SHL8mi_NF_SHR16m1_SHR16m1_EVEX_SHR16m1_NF_SHR16mi_SHR16mi_EVEX_SHR16mi_NF_SHR32m1_SHR32m1_EVEX_SHR32m1_NF_SHR32mi_SHR32mi_EVEX_SHR32mi_NF_SHR64m1_SHR64m1_EVEX_SHR64m1_NF_SHR64mi_SHR64mi_EVEX_SHR64mi_NF_SHR8m1_SHR8m1_EVEX_SHR8m1_NF_SHR8mi_SHR8mi_EVEX_SHR8mi_NF") 4, false, false, false, 789, 9, 33, 2,  0, 0}, // #609
  {DBGFIELD("SAR16m1_ND_SAR16m1_NF_ND_SAR16mi_ND_SAR16mi_NF_ND_SAR32m1_ND_SAR32m1_NF_ND_SAR32mi_ND_SAR32mi_NF_ND_SAR64m1_ND_SAR64m1_NF_ND_SAR64mi_ND_SAR64mi_NF_ND_SAR8m1_ND_SAR8m1_NF_ND_SAR8mi_ND_SAR8mi_NF_ND_SHL16m1_ND_SHL16m1_NF_ND_SHL16mi_ND_SHL16mi_NF_ND_SHL32m1_ND_SHL32m1_NF_ND_SHL32mi_ND_SHL32mi_NF_ND_SHL64m1_ND_SHL64m1_NF_ND_SHL64mi_ND_SHL64mi_NF_ND_SHL8m1_ND_SHL8m1_NF_ND_SHL8mi_ND_SHL8mi_NF_ND_SHR16m1_ND_SHR16m1_NF_ND_SHR16mi_ND_SHR16mi_NF_ND_SHR32m1_ND_SHR32m1_NF_ND_SHR32mi_ND_SHR32mi_NF_ND_SHR64m1_ND_SHR64m1_NF_ND_SHR64mi_ND_SHR64mi_NF_ND_SHR8m1_ND_SHR8m1_NF_ND_SHR8mi_ND_SHR8mi_NF_ND") 2, false, false, false, 784, 5, 33, 2,  0, 0}, // #610
  {DBGFIELD("SAR16mCL_SAR16mCL_EVEX_SAR16mCL_NF_SAR32mCL_SAR32mCL_EVEX_SAR32mCL_NF_SAR64mCL_SAR64mCL_EVEX_SAR64mCL_NF_SAR8mCL_SAR8mCL_EVEX_SAR8mCL_NF_SHL16mCL_SHL16mCL_EVEX_SHL16mCL_NF_SHL32mCL_SHL32mCL_EVEX_SHL32mCL_NF_SHL64mCL_SHL64mCL_EVEX_SHL64mCL_NF_SHL8mCL_SHL8mCL_EVEX_SHL8mCL_NF_SHR16mCL_SHR16mCL_EVEX_SHR16mCL_NF_SHR32mCL_SHR32mCL_EVEX_SHR32mCL_NF_SHR64mCL_SHR64mCL_EVEX_SHR64mCL_NF_SHR8mCL_SHR8mCL_EVEX_SHR8mCL_NF") 5, false, false, false, 798, 9, 33, 2,  0, 0}, // #611
  {DBGFIELD("SAR16mCL_ND_SAR16mCL_NF_ND_SAR32mCL_ND_SAR32mCL_NF_ND_SAR64mCL_ND_SAR64mCL_NF_ND_SAR8mCL_ND_SAR8mCL_NF_ND_SHL16mCL_ND_SHL16mCL_NF_ND_SHL32mCL_ND_SHL32mCL_NF_ND_SHL64mCL_ND_SHL64mCL_NF_ND_SHL8mCL_ND_SHL8mCL_NF_ND_SHR16mCL_ND_SHR16mCL_NF_ND_SHR32mCL_ND_SHR32mCL_NF_ND_SHR64mCL_ND_SHR64mCL_NF_ND_SHR8mCL_ND_SHR8mCL_NF_ND") 4, false, false, false, 807, 5, 35, 2,  0, 0}, // #612
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #613
  {DBGFIELD("FCOMPP")             1, false, false, false, 36, 3,  4, 1,  0, 0}, // #614
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  3, 9, 12, 1,  0, 0}, // #615
  {DBGFIELD("MMX_CVTPI2PSrr")     2, false, false, false, 293, 9,  6, 1,  0, 0}, // #616
  {DBGFIELD("MMX_CVTPI2PSrm")     2, false, false, false, 103, 7,  8, 1,  0, 0}, // #617
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 2, false, false, false, 898, 9, 22, 1,  0, 0}, // #618
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 56, 3, 10, 1,  0, 0}, // #619
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH16i_PUSH32i_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #620
  {DBGFIELD("XCH_F")              15, false, false, false, 907, 15, 20, 1,  0, 0}, // #621
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 2, false, false, false, 26, 10,  3, 1,  0, 0}, // #622
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 2, false, false, false, 247, 11, 24, 1,  0, 0}, // #623
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 2, false, false, false, 400, 15,  9, 1,  0, 0}, // #624
  {DBGFIELD("CVTSI642SDrm")       2, false, false, false, 103, 7,  8, 1,  0, 0}, // #625
  {DBGFIELD("CVTSI642SDrm_Int")   2, false, false, false, 103, 7,  8, 1,  6, 1}, // #626
  {DBGFIELD("CVTSI642SSrr")       3, false, false, false, 922, 11,  7, 1,  0, 1}, // #627
  {DBGFIELD("CVTSI642SSrr_Int")   3, false, false, false, 922, 11,  7, 1,  7, 1}, // #628
  {DBGFIELD("CVTSI642SSrm")       3, false, false, false, 269, 13,  2, 1,  0, 0}, // #629
  {DBGFIELD("CVTSI642SSrm_Int")   3, false, false, false, 269, 13,  2, 1,  6, 1}, // #630
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 3, false, false, false, 933, 13,  7, 1,  0, 0}, // #631
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 3, false, false, false, 933, 13,  7, 1,  0, 0}, // #632
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 3, false, false, false, 282, 11,  2, 1,  0, 0}, // #633
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 2, false, false, false, 124, 3, 12, 1,  0, 0}, // #634
  {DBGFIELD("LFENCE")             1, false, false, false, 12, 5, 12, 1,  0, 0}, // #635
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #636
  {DBGFIELD("LEAVE_LEAVE64")      3, false, false, false, 118, 4,  3, 1,  0, 0}, // #637
  {DBGFIELD("POP16r")             2, false, false, false, 106, 4,  3, 1,  0, 0}, // #638
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 3, false, false, false, 47, 5,  1, 1,  0, 0}, // #639
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 870, 4,  3, 1,  0, 0}, // #640
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 36, 3,  4, 1,  0, 0}, // #641
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 946, 5,  1, 1,  0, 0}, // #642
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 36, 3,  1, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 563, 6,  1, 1,  0, 0}, // #644
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #645
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #646
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  2, false, false, false, 52, 4,  2, 1,  0, 0}, // #647
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 111, 4,  1, 1,  0, 0}, // #648
  {DBGFIELD("CLD")                2, false, false, false, 74, 5,  5, 1,  0, 0}, // #649
  {DBGFIELD("LDDQUrm")            1, false, false, false, 56, 3,  6, 1,  0, 0}, // #650
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 7, false, false, false, 951, 6,  6, 1,  0, 0}, // #651
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 3, false, false, false, 47, 5,  2, 1,  0, 0}, // #652
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 9, false, false, false, 957, 9, 49, 2,  0, 0}, // #653
  {DBGFIELD("PHADDDrr_PHSUBDrr")  3, false, false, false, 737, 6, 12, 1,  0, 0}, // #654
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 2, false, false, false, 177, 5,  3, 1,  0, 0}, // #655
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 2, false, false, false, 569, 8, 22, 1,  6, 1}, // #656
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 56, 3,  6, 1,  0, 0}, // #657
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 56, 3,  6, 1,  0, 0}, // #658
  {DBGFIELD("PADDQrm_PSUBQrm")    2, false, false, false, 104, 6,  7, 1,  6, 1}, // #659
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #660
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   2, false, false, false, 966, 5, 12, 1,  0, 0}, // #661
  {DBGFIELD("LD_F80m")            1, false, false, false, 971, 6,  6, 1,  0, 0}, // #662
  {DBGFIELD("PHADDDrm_PHSUBDrm")  4, false, false, false, 729, 8, 22, 1,  6, 1}, // #663
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 2, false, false, false, 389, 11, 14, 1,  0, 0}, // #664
  {DBGFIELD("FLDCW16m")           3, false, false, false, 977, 14,  6, 1,  0, 0}, // #665
  {DBGFIELD("ST_FP80m")           2, false, false, false, 946, 5,  1, 1,  0, 0}, // #666
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 3, false, false, false, 589, 10,  5, 1,  0, 0}, // #667
  {DBGFIELD("CMPXCHG8rm")         6, false, false, false, 17, 9, 24, 1,  0, 0}, // #668
  {DBGFIELD("INTO")               1, false, false, false, 36, 3,  4, 1,  0, 0}, // #669
  {DBGFIELD("XLAT")               3, false, false, false, 118, 4,  6, 1,  0, 0}, // #670
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 3, false, false, false, 504, 10, 10, 1,  0, 0}, // #671
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 39, 8,  5, 1,  0, 0}, // #672
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 6, false, false, false, 820, 14,  2, 1,  0, 0}, // #673
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 5, false, false, false, 834, 12,  2, 1,  0, 0}, // #674
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 3, false, false, false, 991, 14, 14, 1,  0, 0}, // #675
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 4, false, false, false, 577, 12,  8, 1,  6, 1}, // #676
  {DBGFIELD("AAD8i8")             1, false, false, false, 36, 3,  4, 1,  0, 0}, // #677
  {DBGFIELD("LOOPE")              11, false, false, false, 1005, 10,  5, 1,  0, 0}, // #678
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 946, 5,  1, 1,  0, 0}, // #679
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 3, false, false, false, 504, 10, 10, 1,  0, 0}, // #680
  {DBGFIELD("FNSTCW16m")          3, false, false, false, 1015, 10, 12, 1,  0, 0}, // #681
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 971, 6, 10, 1,  0, 0}, // #682
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 946, 5,  1, 1,  0, 0}, // #683
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 6, false, false, false, 820, 14,  2, 1,  0, 0}, // #684
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 5, false, false, false, 834, 12,  2, 1,  0, 0}, // #685
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 39, 8,  5, 1,  0, 0}, // #686
  {DBGFIELD("CMPXCHG8rr")         5, false, false, false, 242, 5,  5, 1,  0, 0}, // #687
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #688
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 36, 3,  4, 1,  0, 0}, // #689
  {DBGFIELD("AAA_AAS")            1, false, false, false, 36, 3,  4, 1,  0, 0}, // #690
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 6, false, false, false, 17, 9,  2, 1,  0, 0}, // #691
  {DBGFIELD("LOOPNE")             11, false, false, false, 1005, 10, 12, 1,  0, 0}, // #692
  {DBGFIELD("PAUSE")              2, false, false, false, 1025, 11, 14, 1,  0, 0}, // #693
  {DBGFIELD("CMPXCHG8B")          16, false, false, false, 1036, 14, 46, 1,  0, 0}, // #694
  {DBGFIELD("DAA")                1, false, false, false, 36, 3,  4, 1,  0, 0}, // #695
  {DBGFIELD("LOOP")               7, false, false, false, 1050, 10,  5, 1,  0, 0}, // #696
  {DBGFIELD("DAS")                1, false, false, false, 36, 3,  4, 1,  0, 0}, // #697
  {DBGFIELD("AAM8i8")             1, false, false, false, 36, 3,  4, 1,  0, 0}, // #698
  {DBGFIELD("STD")                2, false, false, false, 74, 5,  3, 1,  0, 0}, // #699
  {DBGFIELD("CMPXCHG16B")         22, false, false, false, 1060, 17, 51, 1,  0, 0}, // #700
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 36, 3,  4, 1,  0, 0}, // #701
  {DBGFIELD("FNCLEX_FXTRACT")     4, false, false, false, 1077, 3, 14, 1,  0, 0}, // #702
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 971, 6, 10, 1,  0, 0}, // #703
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 36, 3,  4, 1,  0, 0}, // #704
  {DBGFIELD("RDTSC_RDTSCP")       21, false, false, false, 1080, 14, 52, 1,  0, 0}, // #705
  {DBGFIELD("ENTER")              57, false, false, false, 1094, 18, 53, 1,  0, 0}, // #706
  {DBGFIELD("POPF16")             10, false, false, false, 1112, 12, 10, 1,  0, 0}, // #707
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 36, 3,  4, 1,  0, 0}, // #708
  {DBGFIELD("FRNDINT")            1, false, false, false, 36, 3,  4, 1,  0, 0}, // #709
  {DBGFIELD("MWAITrr_RDPMC")      10, false, false, false, 1124, 12, 15, 1,  0, 0}, // #710
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 36, 3,  4, 1,  0, 0}, // #711
  {DBGFIELD("FPREM")              1, false, false, false, 36, 3,  4, 1,  0, 0}, // #712
  {DBGFIELD("INSB_INSL_INSW")     86, false, false, false, 1136, 18, 15, 1,  0, 0}, // #713
  {DBGFIELD("FNINIT")             15, false, false, false, 1154, 10, 54, 1,  0, 0}, // #714
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 73, false, false, false, 1164, 18, 55, 1,  0, 0}, // #715
  {DBGFIELD("FPREM1")             1, false, false, false, 36, 3,  4, 1,  0, 0}, // #716
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 36, 3,  4, 1,  0, 0}, // #717
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 73, false, false, false, 1182, 18, 55, 1,  0, 0}, // #718
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  83, false, false, false, 1200, 18,  4, 1,  0, 0}, // #719
  {DBGFIELD("FSCALE")             1, false, false, false, 36, 3,  4, 1,  0, 0}, // #720
  {DBGFIELD("RDMSR")              54, false, false, false, 1218, 13,  4, 1,  0, 0}, // #721
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 2, false, false, false, 26, 10,  3, 1,  0, 0}, // #722
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 87, false, false, false, 1231, 16, 55, 1,  0, 0}, // #723
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 86, false, false, false, 1247, 16, 55, 1,  0, 0}, // #724
  {DBGFIELD("F2XM1")              1, false, false, false, 36, 3,  4, 1,  0, 0}, // #725
  {DBGFIELD("CPUID")              26, false, false, false, 1263, 17, 13, 1,  0, 0}, // #726
  {DBGFIELD("INT")                1, false, false, false, 36, 3,  4, 1,  0, 0}, // #727
  {DBGFIELD("INT3")               1, false, false, false, 36, 3,  4, 1,  0, 0}, // #728
  {DBGFIELD("FXSAVE_FXSAVE64")    110, false, false, false, 1280, 18,  4, 1,  0, 0}, // #729
  {DBGFIELD("FXRSTOR_FXRSTOR64")  90, false, false, false, 1298, 17, 56, 1,  0, 0}, // #730
  {DBGFIELD("FYL2X")              1, false, false, false, 36, 3,  4, 1,  0, 0}, // #731
  {DBGFIELD("FYL2XP1")            1, false, false, false, 36, 3,  4, 1,  0, 0}, // #732
  {DBGFIELD("FPTAN")              1, false, false, false, 36, 3,  4, 1,  0, 0}, // #733
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 36, 3,  4, 1,  0, 0}, // #734
  {DBGFIELD("FPATAN")             1, false, false, false, 36, 3,  4, 1,  0, 0}, // #735
  {DBGFIELD("WRMSR")              144, false, false, false, 1315, 17,  4, 1,  0, 0}, // #736
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #737
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false, 93, 10,  1, 1,  0, 0}, // #738
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 2, false, false, false, 424, 6, 12, 1,  0, 0}, // #739
  {DBGFIELD("FNOP")               1, false, false, false, 563, 6,  1, 1,  0, 0}, // #740
  {DBGFIELD("RET64")              2, false, false, false, 233, 7,  6, 1,  0, 0}, // #741
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 12, 5,  1, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #743
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 563, 6,  1, 1,  0, 0}, // #744
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 93, 10,  1, 1,  0, 0}, // #745
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 4, false, false, false, 870, 4,  3, 1,  0, 0}, // #746
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 1, false, false, false,  3, 9,  5, 1,  0, 0}, // #747
  {DBGFIELD("CWD")                2, false, false, false, 74, 5, 12, 1,  0, 0}, // #748
  {DBGFIELD("FNSTSW16r")          2, false, false, false, 1332, 9,  5, 1,  0, 0}, // #749
  {DBGFIELD("MMX_MOVDQ2Qrr")      2, false, false, false, 1341, 6,  5, 1,  0, 0}, // #750
  {DBGFIELD("PUSHFS64")           3, false, false, false, 1347, 11,  1, 1,  0, 0}, // #751
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 2, false, false, false, 624, 13, 14, 1,  0, 0}, // #752
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 3, false, false, false, 779, 5, 12, 1,  0, 0}, // #753
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 3, false, false, false, 779, 5, 12, 1,  0, 0}, // #754
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 3, false, false, false, 779, 5, 12, 1,  0, 0}, // #755
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #756
  {DBGFIELD("MOV64sr")            1, false, false, false, 36, 3,  1, 1,  0, 0}, // #757
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCL8rCL_RCL8rCL_EVEX_RCL8rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND_RCR8rCL_RCR8rCL_EVEX_RCR8rCL_ND") 2, false, false, false, 784, 5, 12, 1,  0, 0}, // #758
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #759
  {DBGFIELD("CLI")                3, false, false, false, 1358, 10,  4, 1,  0, 0}, // #760
  {DBGFIELD("PUSHGS64")           3, false, false, false, 1347, 11,  1, 1,  0, 0}, // #761
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 3, false, false, false, 991, 14, 14, 1,  0, 0}, // #762
  {DBGFIELD("CALL64pcrel32")      2, false, false, false, 52, 4,  5, 1,  0, 0}, // #763
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #764
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 3, false, false, false, 1368, 13,  2, 1,  0, 0}, // #765
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 4, false, false, false, 1381, 5,  6, 1,  0, 0}, // #766
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 3, false, false, false, 380, 9,  2, 1,  0, 0}, // #767
  {DBGFIELD("PUSHF16_PUSHF64")    4, false, false, false, 1386, 13, 14, 1,  0, 0}, // #768
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 3, false, false, false, 881, 5, 12, 1,  0, 0}, // #769
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 56, 3,  6, 1,  0, 0}, // #770
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #771
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #772
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #773
  {DBGFIELD("MOV16sm")            1, false, false, false, 36, 3,  1, 1,  0, 0}, // #774
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 2, false, false, false, 247, 11, 22, 1,  0, 0}, // #775
  {DBGFIELD("MMX_PALIGNRrmi")     2, false, false, false, 540, 12, 22, 1,  6, 1}, // #776
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 2, false, false, false, 247, 11, 22, 1,  6, 1}, // #777
  {DBGFIELD("LODSL_LODSQ")        3, false, false, false, 118, 4, 10, 1,  0, 0}, // #778
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #779
  {DBGFIELD("VINSERTF128rm")      2, false, false, false, 104, 6, 22, 1,  6, 1}, // #780
  {DBGFIELD("MMX_PADDQrm")        2, false, false, false, 569, 8, 22, 1,  6, 1}, // #781
  {DBGFIELD("VERRm_VERWm")        34, false, false, false, 1399, 14, 57, 1,  0, 0}, // #782
  {DBGFIELD("FARJMP64m")          2, false, false, false, 1413, 11,  3, 1,  0, 0}, // #783
  {DBGFIELD("FNSTSWm")            3, false, false, false, 1424, 13,  5, 1,  0, 0}, // #784
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 2, false, false, false, 484, 8,  3, 1,  0, 0}, // #785
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #786
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 5, false, false, false, 65, 9,  6, 1,  0, 0}, // #787
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 2, false, false, false, 247, 11,  7, 1,  6, 1}, // #788
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 7, false, false, false, 1437, 4,  3, 1,  0, 0}, // #789
  {DBGFIELD("ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #790
  {DBGFIELD("ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 6, false, false, false, 750, 5, 35, 2,  0, 0}, // #791
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 5, false, false, false, 1441, 6, 58, 2,  0, 0}, // #792
  {DBGFIELD("FARCALL64m")         5, false, false, false, 1447, 13,  6, 1,  0, 0}, // #793
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 971, 6,  6, 1,  0, 0}, // #794
  {DBGFIELD("ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 10, false, false, false, 755, 14, 37, 2,  0, 0}, // #795
  {DBGFIELD("ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 9, false, false, false, 769, 10, 39, 2,  0, 0}, // #796
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 6, false, false, false, 1460, 9,  2, 1, 12, 2}, // #797
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 2, false, false, false, 400, 15,  9, 1,  0, 0}, // #798
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 2, false, false, false, 540, 12,  9, 1,  6, 1}, // #799
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 3, false, false, false, 1469, 15,  8, 1,  0, 0}, // #800
  {DBGFIELD("MUL_F32m_MUL_F64m")  2, false, false, false, 1484, 14,  8, 1,  0, 0}, // #801
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 3, false, false, false, 1469, 15, 24, 1,  0, 0}, // #802
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 3, false, false, false, 1498, 18, 21, 1,  0, 0}, // #803
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 2, false, false, false, 1484, 14, 19, 1,  0, 0}, // #804
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 3, false, false, false, 1498, 18, 46, 1,  0, 0}, // #805
  {DBGFIELD("VZEROALL")           10, false, false, false, 1516, 10, 16, 1,  0, 0}, // #806
  {DBGFIELD("VZEROUPPER")         0, false, false, false,  0, 0,  0, 1,  0, 0}, // #807
  {DBGFIELD("CLC")                0, false, false, false,  0, 0,  1, 1,  0, 0}, // #808
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #809
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #810
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #811
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false, 111, 4,  1, 1,  0, 0}, // #812
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #813
  {DBGFIELD("PSUBQrr")            1, false, false, false, 111, 4,  1, 1,  0, 0}, // #814
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #815
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #816
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 2, false, false, false, 233, 7,  6, 1,  1, 1}, // #817
  {DBGFIELD("SETCCr")             2, false, false, false, 784, 5, 12, 1,  0, 0}, // #818
  {DBGFIELD("SETCCm")             4, false, false, false, 812, 8, 24, 1,  0, 0}, // #819
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 540, 12,  7, 1,  6, 1}, // #820
  {DBGFIELD("RETI16_RETI32_RETI64") 3, false, false, false, 1526, 7,  3, 1,  0, 0}, // #821
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 2, false, false, false, 26, 10,  3, 1,  0, 0}, // #822
  {DBGFIELD("RDPMC")              18, false, false, false, 1533, 13,  4, 1,  0, 0}, // #823
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 25, false, false, false, 1546, 16,  4, 1,  0, 0}, // #824
  {DBGFIELD("FBLDm")              1, false, false, false, 36, 3,  4, 1,  0, 0}, // #825
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false, 36, 3,  4, 1,  0, 0}, // #826
  {DBGFIELD("FSAVEm")             1, false, false, false, 36, 3,  4, 1,  0, 0}, // #827
  {DBGFIELD("FRSTORm")            1, false, false, false, 36, 3,  4, 1,  0, 0}, // #828
  {DBGFIELD("FXTRACT")            1, false, false, false, 36, 3,  4, 1,  0, 0}, // #829
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #830
  {DBGFIELD("VBROADCASTF128rm_VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #831
  {DBGFIELD("VBROADCASTI128rm")   1, false, false, false, 56, 3,  7, 1,  0, 0}, // #832
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #833
  {DBGFIELD("FBSTPm")             2, false, false, false, 946, 5,  1, 1,  0, 0}, // #834
  {DBGFIELD("VMPTRSTm")           2, false, false, false, 946, 5,  1, 1,  0, 0}, // #835
  {DBGFIELD("ST_FP32m_ST_FP64m")  2, false, false, false, 946, 5,  1, 1,  0, 0}, // #836
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #837
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #838
  {DBGFIELD("MMX_MOVQ2DQrr")      2, false, false, false, 898, 9,  5, 1,  0, 0}, // #839
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #840
  {DBGFIELD("FINCSTP")            1, false, false, false, 563, 6,  1, 1,  0, 0}, // #841
  {DBGFIELD("ANDN32rr_ANDN32rr_EVEX_ANDN32rr_NF_ANDN64rr_ANDN64rr_EVEX_ANDN64rr_NF") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #842
  {DBGFIELD("VPBLENDDYrri")       1, false, false, false, 111, 4,  1, 1,  0, 0}, // #843
  {DBGFIELD("VPBLENDDrri")        1, false, false, false, 111, 4,  1, 1,  0, 0}, // #844
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 7, false, false, false, 1562, 11, 23, 1,  0, 0}, // #845
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #846
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #847
  {DBGFIELD("PDEP32rm_PDEP32rm_EVEX_PDEP64rm_PDEP64rm_EVEX_PEXT32rm_PEXT32rm_EVEX_PEXT64rm_PEXT64rm_EVEX") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #848
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 2, false, false, false, 79, 8,  7, 1,  0, 0}, // #849
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #850
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 2, false, false, false, 1413, 11,  3, 1,  0, 0}, // #851
  {DBGFIELD("ANDN32rm_ANDN32rm_EVEX_ANDN32rm_NF_ANDN64rm_ANDN64rm_EVEX_ANDN64rm_NF") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #852
  {DBGFIELD("MOVBE16rm_MOVBE16rm_EVEX_MOVBE32rm_MOVBE32rm_EVEX_MOVBE64rm_MOVBE64rm_EVEX") 1, false, false, false,  1, 2,  8, 1,  0, 0}, // #853
  {DBGFIELD("VINSERTI128rm")      2, false, false, false, 104, 6, 22, 1,  6, 1}, // #854
  {DBGFIELD("VPBLENDDrmi")        2, false, false, false, 104, 6,  7, 1,  6, 1}, // #855
  {DBGFIELD("VPBLENDDYrmi")       2, false, false, false, 104, 6, 22, 1,  6, 1}, // #856
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 56, 3, 10, 1,  0, 0}, // #857
  {DBGFIELD("SFENCE")             2, false, false, false, 52, 4, 12, 1,  0, 0}, // #858
  {DBGFIELD("MOVBE32mr_MOVBE32mr_EVEX_MOVBE64mr_MOVBE64mr_EVEX") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #859
  {DBGFIELD("MOVBE16mr")          3, false, false, false, 1573, 8,  2, 1,  0, 0}, // #860
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #861
  {DBGFIELD("MFENCE")             2, false, false, false, 52, 4,  5, 1,  0, 0}, // #862
  {DBGFIELD("XGETBV")             23, false, false, false, 1581, 10, 14, 1,  0, 0}, // #863
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 3, false, false, false, 1591, 12,  2, 1,  6, 1}, // #864
  {DBGFIELD("LRET64_RET32")       2, false, false, false, 233, 7,  3, 1,  0, 0}, // #865
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 2, false, false, false, 784, 5,  1, 1,  0, 0}, // #866
  {DBGFIELD("PDEP32rr_PDEP32rr_EVEX_PDEP64rr_PDEP64rr_EVEX_PEXT32rr_PEXT32rr_EVEX_PEXT64rr_PEXT64rr_EVEX") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #867
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #868
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #869
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 2, false, false, false, 1603, 10, 14, 1,  0, 0}, // #870
  {DBGFIELD("CLDEMOTE")           3, false, false, false, 881, 5,  5, 1,  0, 0}, // #871
  {DBGFIELD("MMX_CVTPI2PDrm")     2, false, false, false, 103, 7,  8, 1,  0, 0}, // #872
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 2, false, false, false, 540, 12, 22, 1,  0, 0}, // #873
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 22, false, false, false, 1613, 16, 60, 1,  0, 0}, // #874
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 13, false, false, false, 1629, 16, 61, 1,  0, 0}, // #875
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #876
  {DBGFIELD("VPCMPGTQYrm")        2, false, false, false, 540, 12,  8, 1,  6, 1}, // #877
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 922, 11,  7, 1,  7, 1}, // #878
  {DBGFIELD("STR16r_STR32r_STR64r") 2, false, false, false, 484, 8, 10, 1,  0, 0}, // #879
  {DBGFIELD("XSETBV")             54, false, false, false, 1645, 13, 10, 1,  0, 0}, // #880
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX") 10, false, false, false, 755, 14, 37, 2,  0, 0}, // #881
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND") 9, false, false, false, 769, 10, 39, 2,  0, 0}, // #882
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND") 2, false, false, false, 784, 5, 12, 1,  0, 0}, // #883
  {DBGFIELD("RCL8rCL")            9, false, false, false, 769, 10,  6, 1,  0, 0}, // #884
  {DBGFIELD("RCR8rCL")            10, false, false, false, 1658, 10, 22, 1,  0, 0}, // #885
  {DBGFIELD("RDTSC")              15, false, false, false, 1668, 13, 13, 1,  0, 0}, // #886
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 31, false, false, false, 1681, 16, 62, 1,  0, 0}, // #887
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 1, false, false, false,  3, 9, 15, 1,  0, 0}, // #888
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 2, false, false, false, 1484, 14, 63, 1,  0, 0}, // #889
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 3, false, false, false, 1498, 18, 64, 1,  0, 0}, // #890
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 1, false, false, false,  3, 9, 11, 1,  0, 0}, // #891
  {DBGFIELD("XSAVE64")            140, false, false, false, 1697, 17, 65, 1,  0, 0}, // #892
  {DBGFIELD("XSAVE")              140, false, false, false, 1697, 17, 52, 1,  0, 0}, // #893
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 156, false, false, false, 1714, 17, 66, 1,  0, 0}, // #894
  {DBGFIELD("VMCLEARm")           18, false, false, false, 1731, 21, 67, 1,  0, 0}, // #895
  {DBGFIELD("FLDENVm")            64, false, false, false, 1752, 14, 68, 1,  0, 0}, // #896
  {DBGFIELD("FXRSTOR64")          88, false, false, false, 1766, 17, 56, 1,  0, 0}, // #897
  {DBGFIELD("FSTENVm")            100, false, false, false, 1783, 19, 69, 1,  0, 0}, // #898
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 5, false, false, false, 1802, 13, 70, 2,  0, 0}, // #899
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8, false, false, false, 1815, 13, 72, 2,  0, 0}, // #900
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8, false, false, false, 1815, 13, 74, 2,  0, 0}, // #901
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 12, false, false, false, 1828, 13, 76, 2,  0, 0}, // #902
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 5, false, false, false, 1802, 13, 70, 2,  0, 0}, // #903
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8, false, false, false, 1815, 13, 72, 2,  0, 0}, // #904
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 5, false, false, false, 1802, 13, 70, 2,  0, 0}, // #905
  {DBGFIELD("VPXORYrr")           1, false, false, false, 111, 4,  1, 1,  0, 0}, // #906
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #907
  {DBGFIELD("VPCMPGTQYrr")        1, false, false, false, 93, 10,  5, 1,  0, 0}, // #908
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #909
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #910
  {DBGFIELD("MOVBE16mr_EVEX")     2, false, false, false, 52, 4,  2, 1,  0, 0}, // #911
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 2, false, false, false, 400, 15,  7, 1,  0, 0}, // #912
  {DBGFIELD("LRET64")             3, false, false, false, 1841, 11,  6, 1,  0, 0}, // #913
  {DBGFIELD("POPF64")             7, false, false, false, 1852, 12, 10, 1,  0, 0}, // #914
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8, false, false, false, 1815, 13, 72, 2,  0, 0}, // #915
  {DBGFIELD("PCMPEQQrr")          1, false, false, false, 110, 5,  1, 1,  0, 0}, // #916
  {DBGFIELD("PCMPGTQrr")          1, false, false, false, 93, 10,  5, 1,  0, 0}, // #917
  {DBGFIELD("PCMPEQQrm")          2, false, false, false, 103, 7,  7, 1,  6, 1}, // #918
  {DBGFIELD("PCMPGTQrm")          2, false, false, false, 540, 12,  9, 1,  6, 1}, // #919
  {DBGFIELD("MOV16rm")            2, false, false, false, 106, 4,  3, 1,  0, 0}, // #920
  {DBGFIELD("POP16rmm")           3, false, false, false, 47, 5,  2, 1,  0, 0}, // #921
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 3, false, false, false, 47, 5,  2, 1,  0, 0}, // #922
  {DBGFIELD("PUSHF16")            4, false, false, false, 1386, 13,  2, 1,  0, 0}, // #923
  {DBGFIELD("LAHF")               1, false, false, false, 12, 5,  5, 1,  0, 0}, // #924
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mi8_EVEX_ADD16mi8_NF_ADD16mi_EVEX_ADD16mi_NF_ADD32mi_ADD32mi8_ADD32mi8_EVEX_ADD32mi8_NF_ADD32mi_EVEX_ADD32mi_NF_ADD64mi32_ADD64mi32_EVEX_ADD64mi32_NF_ADD64mi8_ADD64mi8_EVEX_ADD64mi8_NF_ADD8mi_ADD8mi8_ADD8mi_EVEX_ADD8mi_NF_SUB16mi_SUB16mi8_SUB16mi8_EVEX_SUB16mi8_NF_SUB16mi_EVEX_SUB16mi_NF_SUB32mi_SUB32mi8_SUB32mi8_EVEX_SUB32mi8_NF_SUB32mi_EVEX_SUB32mi_NF_SUB64mi32_SUB64mi32_EVEX_SUB64mi32_NF_SUB64mi8_SUB64mi8_EVEX_SUB64mi8_NF_SUB8mi_SUB8mi8_SUB8mi_EVEX_SUB8mi_NF") 4, false, false, false, 59, 6,  2, 1,  0, 0}, // #925
  {DBGFIELD("ADD16mi8_ND_ADD16mi8_NF_ND_ADD16mi_ND_ADD16mi_NF_ND_ADD16mr_ND_ADD16mr_NF_ND_ADD32mi8_ND_ADD32mi8_NF_ND_ADD32mi_ND_ADD32mi_NF_ND_ADD32mr_ND_ADD32mr_NF_ND_ADD64mi32_ND_ADD64mi32_NF_ND_ADD64mi8_ND_ADD64mi8_NF_ND_ADD64mr_ND_ADD64mr_NF_ND_ADD8mi_ND_ADD8mi_NF_ND_ADD8mr_ND_ADD8mr_NF_ND_SUB16mi8_ND_SUB16mi8_NF_ND_SUB16mi_ND_SUB16mi_NF_ND_SUB16mr_ND_SUB16mr_NF_ND_SUB32mi8_ND_SUB32mi8_NF_ND_SUB32mi_ND_SUB32mi_NF_ND_SUB32mr_ND_SUB32mr_NF_ND_SUB64mi32_ND_SUB64mi32_NF_ND_SUB64mi8_ND_SUB64mi8_NF_ND_SUB64mr_ND_SUB64mr_NF_ND_SUB8mi_ND_SUB8mi_NF_ND_SUB8mr_ND_SUB8mr_NF_ND") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #926
  {DBGFIELD("ADD16mr_ADD16mr_EVEX_ADD32mr_ADD32mr_EVEX_ADD64mr_ADD64mr_EVEX_ADD8mr_ADD8mr_EVEX_SUB16mr_SUB16mr_EVEX_SUB32mr_SUB32mr_EVEX_SUB64mr_SUB64mr_EVEX_SUB8mr_SUB8mr_EVEX") 4, false, false, false, 59, 6,  2, 1,  2, 1}, // #927
  {DBGFIELD("ADD16mr_NF_ADD32mr_NF_ADD64mr_NF_ADD8mr_NF_SUB16mr_NF_SUB32mr_NF_SUB64mr_NF_SUB8mr_NF") 4, false, false, false, 59, 6,  2, 1,  0, 0}, // #928
  {DBGFIELD("ADC16mi_ADC16mi8_ADC16mi8_EVEX_ADC16mi_EVEX_ADC32mi_ADC32mi8_ADC32mi8_EVEX_ADC32mi_EVEX_ADC64mi32_ADC64mi32_EVEX_ADC64mi8_ADC64mi8_EVEX_ADC8mi_ADC8mi8_ADC8mi_EVEX_SBB16mi_SBB16mi8_SBB16mi8_EVEX_SBB16mi_EVEX_SBB32mi_SBB32mi8_SBB32mi8_EVEX_SBB32mi_EVEX_SBB64mi32_SBB64mi32_EVEX_SBB64mi8_SBB64mi8_EVEX_SBB8mi_SBB8mi8_SBB8mi_EVEX") 5, false, false, false, 65, 9,  2, 1,  0, 0}, // #929
  {DBGFIELD("ADC16mi8_ND_ADC16mi_ND_ADC16mr_ND_ADC32mi8_ND_ADC32mi_ND_ADC32mr_ND_ADC64mi32_ND_ADC64mi8_ND_ADC64mr_ND_ADC8mi_ND_ADC8mr_ND_SBB16mi8_ND_SBB16mi_ND_SBB16mr_ND_SBB32mi8_ND_SBB32mi_ND_SBB32mr_ND_SBB64mi32_ND_SBB64mi8_ND_SBB64mr_ND_SBB8mi_ND_SBB8mr_ND") 2, false, false, false, 74, 5,  8, 1,  1, 1}, // #930
  {DBGFIELD("ADC16mr_EVEX_ADC32mr_EVEX_ADC64mr_EVEX_ADC8mr_EVEX_SBB16mr_EVEX_SBB32mr_EVEX_SBB64mr_EVEX_SBB8mr_EVEX") 5, false, false, false, 65, 9,  2, 1,  2, 2}, // #931
  {DBGFIELD("DEC16m_DEC16m_EVEX_DEC16m_NF_DEC32m_DEC32m_EVEX_DEC32m_NF_DEC64m_DEC64m_EVEX_DEC64m_NF_DEC8m_DEC8m_EVEX_DEC8m_NF_INC16m_INC16m_EVEX_INC16m_NF_INC32m_INC32m_EVEX_INC32m_NF_INC64m_INC64m_EVEX_INC64m_NF_INC8m_INC8m_EVEX_INC8m_NF_NEG16m_NEG16m_EVEX_NEG16m_NF_NEG32m_NEG32m_EVEX_NEG32m_NF_NEG64m_NEG64m_EVEX_NEG64m_NF_NEG8m_NEG8m_EVEX_NEG8m_NF_NOT16m_NOT16m_EVEX_NOT32m_NOT32m_EVEX_NOT64m_NOT64m_EVEX_NOT8m_NOT8m_EVEX") 4, false, false, false, 59, 6,  2, 1,  0, 0}, // #932
  {DBGFIELD("DEC16m_ND_DEC16m_NF_ND_DEC32m_ND_DEC32m_NF_ND_DEC64m_ND_DEC64m_NF_ND_DEC8m_ND_DEC8m_NF_ND_INC16m_ND_INC16m_NF_ND_INC32m_ND_INC32m_NF_ND_INC64m_ND_INC64m_NF_ND_INC8m_ND_INC8m_NF_ND_NEG16m_ND_NEG16m_NF_ND_NEG32m_ND_NEG32m_NF_ND_NEG64m_ND_NEG64m_NF_ND_NEG8m_ND_NEG8m_NF_ND_NOT16m_ND_NOT32m_ND_NOT64m_ND_NOT8m_ND") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #933
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 3, false, false, false, 1573, 8,  5, 1,  0, 0}, // #934
  {DBGFIELD("RET16_LRET16_LRET32") 2, false, false, false, 26, 10,  3, 1,  0, 0}, // #935
  {DBGFIELD("IRET16_IRET32_IRET64") 2, false, false, false, 26, 10,  3, 1,  0, 0}, // #936
  {DBGFIELD("AND16mi_AND16mi8_AND16mi8_EVEX_AND16mi8_NF_AND16mi_EVEX_AND16mi_NF_AND32mi_AND32mi8_AND32mi8_EVEX_AND32mi8_NF_AND32mi_EVEX_AND32mi_NF_AND64mi32_AND64mi32_EVEX_AND64mi32_NF_AND64mi8_AND64mi8_EVEX_AND64mi8_NF_AND8mi_AND8mi8_AND8mi_EVEX_AND8mi_NF_OR16mi_OR16mi8_OR16mi8_EVEX_OR16mi8_NF_OR16mi_EVEX_OR16mi_NF_OR32mi_OR32mi8_OR32mi8Locked_OR32mi8_EVEX_OR32mi8_NF_OR32mi_EVEX_OR32mi_NF_OR64mi32_OR64mi32_EVEX_OR64mi32_NF_OR64mi8_OR64mi8_EVEX_OR64mi8_NF_OR8mi_OR8mi8_OR8mi_EVEX_OR8mi_NF_XOR16mi_XOR16mi8_XOR16mi8_EVEX_XOR16mi8_NF_XOR16mi_EVEX_XOR16mi_NF_XOR32mi_XOR32mi8_XOR32mi8_EVEX_XOR32mi8_NF_XOR32mi_EVEX_XOR32mi_NF_XOR64mi32_XOR64mi32_EVEX_XOR64mi32_NF_XOR64mi8_XOR64mi8_EVEX_XOR64mi8_NF_XOR8mi_XOR8mi8_XOR8mi_EVEX_XOR8mi_NF") 4, false, false, false, 59, 6,  2, 1,  0, 0}, // #937
  {DBGFIELD("AND16mi8_ND_AND16mi8_NF_ND_AND16mi_ND_AND16mi_NF_ND_AND16mr_ND_AND16mr_NF_ND_AND32mi8_ND_AND32mi8_NF_ND_AND32mi_ND_AND32mi_NF_ND_AND32mr_ND_AND32mr_NF_ND_AND64mi32_ND_AND64mi32_NF_ND_AND64mi8_ND_AND64mi8_NF_ND_AND64mr_ND_AND64mr_NF_ND_AND8mi_ND_AND8mi_NF_ND_AND8mr_ND_AND8mr_NF_ND_OR16mi8_ND_OR16mi8_NF_ND_OR16mi_ND_OR16mi_NF_ND_OR16mr_ND_OR16mr_NF_ND_OR32mi8_ND_OR32mi8_NF_ND_OR32mi_ND_OR32mi_NF_ND_OR32mr_ND_OR32mr_NF_ND_OR64mi32_ND_OR64mi32_NF_ND_OR64mi8_ND_OR64mi8_NF_ND_OR64mr_ND_OR64mr_NF_ND_OR8mi_ND_OR8mi_NF_ND_OR8mr_ND_OR8mr_NF_ND_XOR16mi8_ND_XOR16mi8_NF_ND_XOR16mi_ND_XOR16mi_NF_ND_XOR16mr_ND_XOR16mr_NF_ND_XOR32mi8_ND_XOR32mi8_NF_ND_XOR32mi_ND_XOR32mi_NF_ND_XOR32mr_ND_XOR32mr_NF_ND_XOR64mi32_ND_XOR64mi32_NF_ND_XOR64mi8_ND_XOR64mi8_NF_ND_XOR64mr_ND_XOR64mr_NF_ND_XOR8mi_ND_XOR8mi_NF_ND_XOR8mr_ND_XOR8mr_NF_ND") 1, false, false, false,  1, 2,  8, 1,  1, 1}, // #938
  {DBGFIELD("AND16mr_AND16mr_EVEX_AND32mr_AND32mr_EVEX_AND64mr_AND64mr_EVEX_AND8mr_AND8mr_EVEX_OR16mr_OR16mr_EVEX_OR32mr_OR32mr_EVEX_OR64mr_OR64mr_EVEX_OR8mr_OR8mr_EVEX_XOR16mr_XOR16mr_EVEX_XOR32mr_XOR32mr_EVEX_XOR64mr_XOR64mr_EVEX_XOR8mr_XOR8mr_EVEX") 4, false, false, false, 59, 6,  2, 1,  2, 1}, // #939
  {DBGFIELD("AND16mr_NF_AND32mr_NF_AND64mr_NF_AND8mr_NF_OR16mr_NF_OR32mr_NF_OR64mr_NF_OR8mr_NF_XOR16mr_NF_XOR32mr_NF_XOR64mr_NF_XOR8mr_NF") 4, false, false, false, 59, 6,  2, 1,  0, 0}, // #940
  {DBGFIELD("SHLD16mri8_EVEX_SHLD16mri8_ND_SHLD16mri8_NF_SHLD16mri8_NF_ND_SHLD32mri8_SHLD32mri8_EVEX_SHLD32mri8_ND_SHLD32mri8_NF_SHLD32mri8_NF_ND_SHLD64mri8_EVEX_SHLD64mri8_ND_SHLD64mri8_NF_SHLD64mri8_NF_ND_SHRD16mri8_EVEX_SHRD16mri8_ND_SHRD16mri8_NF_SHRD16mri8_NF_ND_SHRD32mri8_SHRD32mri8_EVEX_SHRD32mri8_ND_SHRD32mri8_NF_SHRD32mri8_NF_ND_SHRD64mri8_EVEX_SHRD64mri8_ND_SHRD64mri8_NF_SHRD64mri8_NF_ND") 5, false, false, false, 834, 12,  2, 1,  0, 0}, // #941
  {DBGFIELD("SHLD16rrCL_EVEX_SHLD16rrCL_ND_SHLD16rrCL_NF_SHLD16rrCL_NF_ND_SHLD32rrCL_SHLD32rrCL_EVEX_SHLD32rrCL_ND_SHLD32rrCL_NF_SHLD32rrCL_NF_ND_SHLD64rrCL_EVEX_SHLD64rrCL_ND_SHLD64rrCL_NF_SHLD64rrCL_NF_ND_SHRD16rrCL_EVEX_SHRD16rrCL_ND_SHRD16rrCL_NF_SHRD16rrCL_NF_ND_SHRD32rrCL_SHRD32rrCL_EVEX_SHRD32rrCL_ND_SHRD32rrCL_NF_SHRD32rrCL_NF_ND_SHRD64rrCL_EVEX_SHRD64rrCL_ND_SHRD64rrCL_NF_SHRD64rrCL_NF_ND") 3, false, false, false, 504, 10, 10, 1,  0, 0}, // #942
  {DBGFIELD("SHLD16mrCL_EVEX_SHLD16mrCL_ND_SHLD16mrCL_NF_SHLD16mrCL_NF_ND_SHLD32mrCL_SHLD32mrCL_EVEX_SHLD32mrCL_ND_SHLD32mrCL_NF_SHLD32mrCL_NF_ND_SHLD64mrCL_EVEX_SHLD64mrCL_ND_SHLD64mrCL_NF_SHLD64mrCL_NF_ND_SHRD16mrCL_EVEX_SHRD16mrCL_ND_SHRD16mrCL_NF_SHRD16mrCL_NF_ND_SHRD32mrCL_SHRD32mrCL_EVEX_SHRD32mrCL_ND_SHRD32mrCL_NF_SHRD32mrCL_NF_ND_SHRD64mrCL_EVEX_SHRD64mrCL_ND_SHRD64mrCL_NF_SHRD64mrCL_NF_ND") 6, false, false, false, 820, 14,  2, 1,  0, 0}, // #943
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 3, false, false, false, 240, 2, 12, 1,  0, 0}, // #944
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #945
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 4, false, false, false, 1864, 12,  2, 1,  0, 0}, // #946
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 2, false, false, false, 946, 5,  1, 1,  0, 0}, // #947
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 2, false, false, false, 946, 5,  1, 1,  0, 0}, // #948
  {DBGFIELD("VPMASKMOVDYrm")      2, false, false, false, 104, 6, 22, 1,  0, 0}, // #949
  {DBGFIELD("VPMASKMOVDrm")       2, false, false, false, 104, 6,  7, 1,  0, 0}, // #950
  {DBGFIELD("VPMASKMOVDYmr")      3, false, false, false, 886, 12, 21, 1,  0, 0}, // #951
  {DBGFIELD("VPMASKMOVDmr")       3, false, false, false, 886, 12, 21, 1,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVQYmr")      3, false, false, false, 886, 12, 21, 1,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVQmr")       3, false, false, false, 886, 12, 21, 1,  0, 0}, // #954
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 2, false, false, false, 540, 12,  7, 1,  0, 0}, // #955
  {DBGFIELD("VPGATHERDDYrm")      12, false, false, false, 1828, 13, 76, 2,  0, 0}, // #956
  {DBGFIELD("VPGATHERDDrm")       8, false, false, false, 1815, 13, 74, 2,  0, 0}, // #957
  {DBGFIELD("VPGATHERDQYrm")      8, false, false, false, 1815, 13, 72, 2,  0, 0}, // #958
  {DBGFIELD("VPGATHERDQrm")       5, false, false, false, 1802, 13, 70, 2,  0, 0}, // #959
  {DBGFIELD("VPGATHERQDYrm")      8, false, false, false, 1815, 13, 72, 2,  0, 0}, // #960
  {DBGFIELD("VPGATHERQDrm")       5, false, false, false, 1802, 13, 70, 2,  0, 0}, // #961
  {DBGFIELD("VPGATHERQQYrm")      8, false, false, false, 1815, 13, 72, 2,  0, 0}, // #962
  {DBGFIELD("VPGATHERQQrm")       5, false, false, false, 1802, 13, 70, 2,  0, 0}, // #963
  {DBGFIELD("VPERM2F128rr")       1, false, false, false, 93, 10,  5, 1,  0, 0}, // #964
  {DBGFIELD("VPERM2I128rr")       1, false, false, false, 93, 10,  5, 1,  0, 0}, // #965
  {DBGFIELD("VPERM2F128rm")       2, false, false, false, 540, 12,  8, 1,  6, 1}, // #966
  {DBGFIELD("VPERM2I128rm")       2, false, false, false, 540, 12,  8, 1,  6, 1}, // #967
  {DBGFIELD("VBROADCASTF128rm")   1, false, false, false, 56, 3,  7, 1,  0, 0}, // #968
  {DBGFIELD("VEXTRACTF128rr")     1, false, false, false, 93, 10,  5, 1,  0, 0}, // #969
  {DBGFIELD("VEXTRACTI128rr")     1, false, false, false, 93, 10,  5, 1,  0, 0}, // #970
  {DBGFIELD("VEXTRACTF128mr")     2, false, false, false, 52, 4,  2, 1,  0, 0}, // #971
  {DBGFIELD("VEXTRACTI128mr")     2, false, false, false, 52, 4,  2, 1,  0, 0}, // #972
  {DBGFIELD("VINSERTF128rr")      1, false, false, false, 93, 10,  5, 1,  0, 0}, // #973
  {DBGFIELD("VINSERTI128rr")      1, false, false, false, 93, 10,  5, 1,  0, 0}, // #974
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #975
  {DBGFIELD("VCVTDQ2PDYrr")       2, false, false, false, 258, 11,  6, 1,  0, 0}, // #976
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #977
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #978
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #979
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 3, false, false, false, 269, 13, 11, 1,  0, 0}, // #980
  {DBGFIELD("MMX_CVTPI2PDrr")     2, false, false, false, 258, 11,  3, 1,  0, 0}, // #981
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 2, false, false, false, 258, 11,  7, 1,  0, 0}, // #982
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #983
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #984
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 3, false, false, false, 282, 11,  2, 1,  0, 0}, // #985
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 2, false, false, false, 258, 11,  6, 1,  0, 1}, // #986
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 2, false, false, false, 258, 11,  6, 1,  7, 1}, // #987
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #988
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #989
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #990
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 3, false, false, false, 282, 11,  2, 1,  0, 0}, // #991
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 3, false, false, false, 282, 11,  2, 1,  0, 0}, // #992
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false, 110, 5,  1, 1,  0, 0}, // #993
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false, 110, 5,  1, 1,  0, 0}, // #994
  {DBGFIELD("SHA256MSG2rm")       3, false, false, false, 1591, 12, 24, 1,  6, 1}, // #995
  {DBGFIELD("SHA256MSG2rr")       2, false, false, false, 1603, 10,  3, 1,  0, 0}, // #996
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 7, false, false, false, 1876, 12, 10, 1,  0, 0}, // #997
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 8, false, false, false, 1888, 14,  2, 1,  6, 1}, // #998
  {DBGFIELD("SHA1MSG2rr")         7, false, false, false, 1902, 9,  3, 1,  0, 0}, // #999
  {DBGFIELD("SHA1MSG2rm")         8, false, false, false, 1911, 11, 24, 1,  6, 1}, // #1000
  {DBGFIELD("SHA1NEXTErr")        3, false, false, false, 1922, 7,  5, 1,  0, 0}, // #1001
  {DBGFIELD("SHA1NEXTErm")        4, false, false, false, 1929, 9,  7, 1,  6, 1}, // #1002
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 93, 10,  3, 1,  0, 0}, // #1003
  {DBGFIELD("SHA1RNDS4rmi")       2, false, false, false, 540, 12, 24, 1,  6, 1}, // #1004
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 93, 10,  3, 1,  0, 0}, // #1005
  {DBGFIELD("SHA256RNDS2rm")      2, false, false, false, 540, 12, 24, 1,  6, 1}, // #1006
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 3, false, false, false, 240, 2, 12, 1,  0, 0}, // #1007
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1008
  {DBGFIELD("VCVTDQ2PSYrr")       1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1009
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1010
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 56, 3, 10, 1,  0, 0}, // #1011
  {DBGFIELD("MOVBE16rm")          3, false, false, false, 1938, 7,  6, 1,  0, 0}, // #1012
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 4, false, false, false, 1386, 13,  2, 1,  0, 0}, // #1013
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1014
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1015
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1016
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false, 39, 8,  5, 1,  0, 0}, // #1017
  {DBGFIELD("ADC8mr_SBB8mr")      6, false, false, false, 1460, 9, 24, 1, 12, 2}, // #1018
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false, 39, 8,  1, 1,  0, 0}, // #1019
  {DBGFIELD("LEA16r")             2, false, false, false, 484, 8, 12, 1,  0, 0}, // #1020
  {DBGFIELD("LCMPXCHG8")          6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1021
  {DBGFIELD("LCMPXCHG16B")        6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1022
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 3, false, false, false, 240, 2, 12, 1,  0, 0}, // #1023
  {DBGFIELD("XCHG8rm_XCHG16rm")   8, false, false, false, 1945, 9, 78, 2,  0, 0}, // #1024
  {DBGFIELD("POPCNT16rr")         1, false, false, false, 39, 8,  5, 1,  0, 0}, // #1025
  {DBGFIELD("LZCNT16rr")          1, false, false, false, 39, 8,  5, 1,  0, 0}, // #1026
  {DBGFIELD("TZCNT16rr")          1, false, false, false, 39, 8,  5, 1,  0, 0}, // #1027
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #1028
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #1029
  {DBGFIELD("RCL8mi_RCL16mi_RCL32mi_RCL64mi") 6, false, false, false, 17, 9, 33, 2,  0, 0}, // #1030
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 7, false, false, false, 1954, 10,  7, 1,  0, 0}, // #1031
  {DBGFIELD("RCR8mCL_RCR16mCL_RCR32mCL_RCR64mCL") 10, false, false, false, 755, 14, 37, 2,  0, 0}, // #1032
  {DBGFIELD("RCL16rCL_RCL32rCL_RCL64rCL") 7, false, false, false, 1954, 10,  7, 1,  0, 0}, // #1033
  {DBGFIELD("RCL8mCL_RCL16mCL_RCL32mCL_RCL64mCL") 10, false, false, false, 755, 14, 37, 2,  0, 0}, // #1034
  {DBGFIELD("MOVHPDmr_MOVHPSmr_VMOVHPDmr_VMOVHPSmr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1035
  {DBGFIELD("MMX_MOVQ2FR64rr")    2, false, false, false, 898, 9,  5, 1,  0, 0}, // #1036
  {DBGFIELD("MMX_MOVD64rr_MMX_MOVD64to64rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1037
  {DBGFIELD("EXTRQ")              1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1038
  {DBGFIELD("INSERTQ")            1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1039
  {DBGFIELD("PABSBrr_PABSDrr_PABSWrr_PADDSBrr_PADDSWrr_PADDUSBrr_PADDUSWrr_PAVGBrr_PAVGWrr_PSIGNBrr_PSIGNDrr_PSIGNWrr_VPABSBrr_VPABSDrr_VPABSWrr_VPADDSBrr_VPADDSWrr_VPADDUSBrr_VPADDUSWrr_VPAVGBrr_VPAVGWrr_VPCMPEQQrr_VPSIGNBrr_VPSIGNDrr_VPSIGNWrr_PSUBSBrr_PSUBSWrr_PSUBUSBrr_PSUBUSWrr_VPSUBSBrr_VPSUBSWrr_VPSUBUSBrr_VPSUBUSWrr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1040
  {DBGFIELD("MMX_PADDSBrr_MMX_PADDSWrr_MMX_PADDUSBrr_MMX_PADDUSWrr_MMX_PAVGBrr_MMX_PAVGWrr_MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1041
  {DBGFIELD("VPABSBYrr_VPABSDYrr_VPABSWYrr_VPADDSBYrr_VPADDSWYrr_VPADDUSBYrr_VPADDUSWYrr_VPSUBSBYrr_VPSUBSWYrr_VPSUBUSBYrr_VPSUBUSWYrr_VPAVGBYrr_VPAVGWYrr_VPCMPEQQYrr_VPSIGNBYrr_VPSIGNDYrr_VPSIGNWYrr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1042
  {DBGFIELD("MMX_CVTPD2PIrm_MMX_CVTTPD2PIrm") 3, false, false, false, 269, 13, 41, 1,  0, 0}, // #1043
  {DBGFIELD("SHA1MSG1rr")         2, false, false, false, 259, 10, 12, 1,  0, 0}, // #1044
  {DBGFIELD("SHA1MSG1rm")         3, false, false, false, 270, 12, 22, 1,  6, 1}, // #1045
  {DBGFIELD("VPERMPSYrm")         2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1046
  {DBGFIELD("VPERMPDYri")         1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1047
  {DBGFIELD("VPERMQYri")          1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1048
  {DBGFIELD("VPERMPDYmi")         2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1049
  {DBGFIELD("VPERMQYmi")          2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1050
  {DBGFIELD("VPERMDYrm")          2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1051
  {DBGFIELD("MOV32rr_MOV32rr_REV_MOV64rr_MOV64rr_REV") 1, false, false, false,  1, 2,  0, 1,  0, 0}, // #1052
  {DBGFIELD("MOVSX32rr32")        1, false, false, false, 182, 3,  1, 1,  0, 0}, // #1053
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV_SUB32rr_REV_SUB64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1054
  {DBGFIELD("CMP8rr_CMP8rr_REV_CMP16rr_CMP16rr_REV_CMP32rr_CMP32rr_REV_CMP64rr_CMP64rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1055
  {DBGFIELD("VXORPSrr_VXORPDrr")  1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1056
  {DBGFIELD("VANDNPSrr_VANDNPDrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1057
  {DBGFIELD("VANDNPSYrr_VANDNPDYrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1058
  {DBGFIELD("VPXORrr")            1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1059
  {DBGFIELD("VPANDNrr")           1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1060
  {DBGFIELD("VPANDNYrr")          1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1061
  {DBGFIELD("VPSUBBrr_VPSUBWrr_VPSUBDrr_VPSUBQrr_VPCMPGTBrr_VPCMPGTWrr_VPCMPGTDrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1062
  {DBGFIELD("KADDBrr_KADDDrr_KADDQrr_KADDWrr_KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1063
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk_KMOVBrk_KMOVDrk_KMOVQrk_KMOVWrk") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1064
  {DBGFIELD("KUNPCKBWrr_KUNPCKDQrr_KUNPCKWDrr") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1065
  {DBGFIELD("KMOVBmk_KMOVDmk_KMOVQmk_KMOVWmk") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1066
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVQkr_KMOVWkr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1067
  {DBGFIELD("VALIGNDZrri_VALIGNQZrri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1068
  {DBGFIELD("VALIGNDZ128rri_VALIGNQZ128rri") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1069
  {DBGFIELD("VALIGNDZ256rri_VALIGNQZ256rri") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1070
  {DBGFIELD("VPERMPSYrr")         1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1071
  {DBGFIELD("VPERMDYrr")          1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1072
  {DBGFIELD("VFIXUPIMMPDZ128rrik_VFIXUPIMMPDZ128rrikz_VFIXUPIMMPSZ128rrik_VFIXUPIMMPSZ128rrikz_VFIXUPIMMPDZ128rri_VFIXUPIMMPSZ128rri_VRANGEPDZ128rri_VRANGEPDZ128rrik_VRANGEPDZ128rrikz_VRANGEPSZ128rri_VRANGEPSZ128rrik_VRANGEPSZ128rrikz_VRANGESDZrri_VRANGESDZrrib_VRANGESDZrribk_VRANGESDZrribkz_VRANGESDZrrik_VRANGESDZrrikz_VRANGESSZrri_VRANGESSZrrib_VRANGESSZrribk_VRANGESSZrribkz_VRANGESSZrrik_VRANGESSZrrikz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1073
  {DBGFIELD("VFIXUPIMMPDZ256rrik_VFIXUPIMMPDZ256rrikz_VFIXUPIMMPSZ256rrik_VFIXUPIMMPSZ256rrikz_VFIXUPIMMPDZ256rri_VFIXUPIMMPSZ256rri_VRANGEPDZ256rri_VRANGEPDZ256rrik_VRANGEPDZ256rrikz_VRANGEPSZ256rri_VRANGEPSZ256rrik_VRANGEPSZ256rrikz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1074
  {DBGFIELD("VFIXUPIMMPDZrrik_VFIXUPIMMPDZrrikz_VFIXUPIMMPSZrrik_VFIXUPIMMPSZrrikz_VRANGEPDZrri_VRANGEPDZrrib_VRANGEPDZrribk_VRANGEPDZrribkz_VRANGEPDZrrik_VRANGEPDZrrikz_VRANGEPSZrri_VRANGEPSZrrib_VRANGEPSZrribk_VRANGEPSZrribkz_VRANGEPSZrrik_VRANGEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1075
  {DBGFIELD("VFIXUPIMMSDZrrik_VFIXUPIMMSDZrrikz_VFIXUPIMMSSZrrik_VFIXUPIMMSSZrrikz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1076
  {DBGFIELD("VSCALEFSDZrrb_Int_VSCALEFSDZrrb_Intk_VSCALEFSDZrrb_Intkz_VSCALEFSSZrrb_Int_VSCALEFSSZrrb_Intk_VSCALEFSSZrrb_Intkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1077
  {DBGFIELD("VREDUCEPDZ128rri_VREDUCEPDZ128rrik_VREDUCEPDZ128rrikz_VREDUCEPSZ128rri_VREDUCEPSZ128rrik_VREDUCEPSZ128rrikz_VREDUCESDZrri_VREDUCESDZrrib_VREDUCESDZrribk_VREDUCESDZrribkz_VREDUCESDZrrik_VREDUCESDZrrikz_VREDUCESSZrri_VREDUCESSZrrib_VREDUCESSZrribk_VREDUCESSZrribkz_VREDUCESSZrrik_VREDUCESSZrrikz") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1078
  {DBGFIELD("VREDUCEPDZrri_VREDUCEPDZrrib_VREDUCEPDZrribk_VREDUCEPDZrribkz_VREDUCEPDZrrik_VREDUCEPDZrrikz_VREDUCEPSZrri_VREDUCEPSZrrib_VREDUCEPSZrribk_VREDUCEPSZrribkz_VREDUCEPSZrrik_VREDUCEPSZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1079
  {DBGFIELD("VDPBF16PSZ128r_VDPBF16PSZ128rk_VDPBF16PSZ128rkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1080
  {DBGFIELD("VDPBF16PSZ256r_VDPBF16PSZ256rk_VDPBF16PSZ256rkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1081
  {DBGFIELD("VDPBF16PSZr_VDPBF16PSZrk_VDPBF16PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1082
  {DBGFIELD("VPDPBUSDSZ128r_VPDPBUSDSZ128rk_VPDPBUSDSZ128rkz_VPDPBUSDZ128r_VPDPBUSDZ128rk_VPDPBUSDZ128rkz_VPDPWSSDSZ128r_VPDPWSSDSZ128rk_VPDPWSSDSZ128rkz_VPDPWSSDZ128r_VPDPWSSDZ128rk_VPDPWSSDZ128rkz_VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #1083
  {DBGFIELD("VPDPBUSDSZ256r_VPDPBUSDSZ256rk_VPDPBUSDSZ256rkz_VPDPBUSDZ256r_VPDPBUSDZ256rk_VPDPBUSDZ256rkz_VPDPWSSDSZ256r_VPDPWSSDSZ256rk_VPDPWSSDSZ256rkz_VPDPWSSDZ256r_VPDPWSSDZ256rk_VPDPWSSDZ256rkz_VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #1084
  {DBGFIELD("VPDPBUSDSZr_VPDPBUSDSZrk_VPDPBUSDSZrkz_VPDPBUSDZr_VPDPBUSDZrk_VPDPBUSDZrkz_VPDPWSSDSZr_VPDPWSSDSZrk_VPDPWSSDSZrkz_VPDPWSSDZr_VPDPWSSDZrk_VPDPWSSDZrkz_VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1085
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz_VPSHLDDZ128rri_VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rri_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHLDWZ128rri_VPSHLDWZ128rrik_VPSHLDWZ128rrikz_VPSHRDDZ128rri_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rri_VPSHRDQZ128rrik_VPSHRDQZ128rrikz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz_VPSHRDWZ128rri_VPSHRDWZ128rrik_VPSHRDWZ128rrikz_VPSHUFBITQMBZ128rr_VPSHUFBITQMBZ128rrk") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #1086
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz_VPSHLDDZ256rri_VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rri_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHLDWZ256rri_VPSHLDWZ256rrik_VPSHLDWZ256rrikz_VPSHRDDZ256rri_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rri_VPSHRDQZ256rrik_VPSHRDQZ256rrikz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz_VPSHRDWZ256rri_VPSHRDWZ256rrik_VPSHRDWZ256rrikz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #1087
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz_VPSHLDDZrri_VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrri_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHLDVWZrk_VPSHLDVWZrkz_VPSHLDWZrri_VPSHLDWZrrik_VPSHLDWZrrikz_VPSHRDDZrri_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrri_VPSHRDQZrrik_VPSHRDQZrrikz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz_VPSHRDVWZrk_VPSHRDVWZrkz_VPSHRDWZrri_VPSHRDWZrrik_VPSHRDWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1088
  {DBGFIELD("PSLLDrr_PSLLQrr_PSLLWrr_PSRADrr_PSRAWrr_PSRLDrr_PSRLQrr_PSRLWrr_VPSLLDZ128rr_VPSLLDZ128rrk_VPSLLDZ128rrkz_VPSLLDrr_VPSLLQZ128rr_VPSLLQZ128rrk_VPSLLQZ128rrkz_VPSLLQrr_VPSLLWZ128rr_VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSLLWrr_VPSRADZ128rr_VPSRADZ128rrk_VPSRADZ128rrkz_VPSRADrr_VPSRAQZ128rr_VPSRAQZ128rrk_VPSRAQZ128rrkz_VPSRAWZ128rr_VPSRAWZ128rrk_VPSRAWZ128rrkz_VPSRAWrr_VPSRLDZ128rr_VPSRLDZ128rrk_VPSRLDZ128rrkz_VPSRLDrr_VPSRLQZ128rr_VPSRLQZ128rrk_VPSRLQZ128rrkz_VPSRLQrr_VPSRLWZ128rr_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRLWrr") 2, false, false, false, 743, 7, 12, 1,  0, 0}, // #1089
  {DBGFIELD("VPSLLDYrr_VPSLLDZ256rr_VPSLLDZ256rrk_VPSLLDZ256rrkz_VPSLLQYrr_VPSLLQZ256rr_VPSLLQZ256rrk_VPSLLQZ256rrkz_VPSLLWYrr_VPSLLWZ256rr_VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRADYrr_VPSRADZ256rr_VPSRADZ256rrk_VPSRADZ256rrkz_VPSRAQZ256rr_VPSRAQZ256rrk_VPSRAQZ256rrkz_VPSRAWYrr_VPSRAWZ256rr_VPSRAWZ256rrk_VPSRAWZ256rrkz_VPSRLDYrr_VPSRLDZ256rr_VPSRLDZ256rrk_VPSRLDZ256rrkz_VPSRLQYrr_VPSRLQZ256rr_VPSRLQZ256rrk_VPSRLQZ256rrkz_VPSRLWYrr_VPSRLWZ256rr_VPSRLWZ256rrk_VPSRLWZ256rrkz") 2, false, false, false, 258, 11, 14, 1,  0, 0}, // #1090
  {DBGFIELD("VPSLLDZrr_VPSLLDZrrk_VPSLLDZrrkz_VPSLLQZrr_VPSLLQZrrk_VPSLLQZrrkz_VPSLLWZrr_VPSLLWZrrk_VPSLLWZrrkz_VPSRADZrr_VPSRADZrrk_VPSRADZrrkz_VPSRAQZrr_VPSRAQZrrk_VPSRAQZrrkz_VPSRAWZrr_VPSRAWZrrk_VPSRAWZrrkz_VPSRLDZrr_VPSRLDZrrk_VPSRLDZrrkz_VPSRLQZrr_VPSRLQZrrk_VPSRLQZrrkz_VPSRLWZrr_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1091
  {DBGFIELD("VPSLLDQYri_VPSRLDQYri_VPSLLDQZ256ri_VPSRLDQZ256ri") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1092
  {DBGFIELD("PSLLDQri_PSRLDQri_VPSLLDQri_VPSRLDQri") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1093
  {DBGFIELD("VPSLLDQZri_VPSRLDQZri") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1094
  {DBGFIELD("VPSHUFBYrr_VPSHUFBZ256rr_VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1095
  {DBGFIELD("VPSHUFBZ128rr_VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1096
  {DBGFIELD("VPSHUFBZrr_VPSHUFBZrrk_VPSHUFBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1097
  {DBGFIELD("VPROLVDZ128rr_VPROLVDZ128rrk_VPROLVDZ128rrkz_VPROLVQZ128rr_VPROLVQZ128rrk_VPROLVQZ128rrkz_VPRORVDZ128rr_VPRORVDZ128rrk_VPRORVDZ128rrkz_VPRORVQZ128rr_VPRORVQZ128rrk_VPRORVQZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1098
  {DBGFIELD("VPROLVDZ256rr_VPROLVDZ256rrk_VPROLVDZ256rrkz_VPROLVQZ256rr_VPROLVQZ256rrk_VPROLVQZ256rrkz_VPRORVDZ256rr_VPRORVDZ256rrk_VPRORVDZ256rrkz_VPRORVQZ256rr_VPRORVQZ256rrk_VPRORVQZ256rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1099
  {DBGFIELD("VPROLVDZrr_VPROLVDZrrk_VPROLVDZrrkz_VPROLVQZrr_VPROLVQZrrk_VPROLVQZrrkz_VPRORVDZrr_VPRORVDZrrk_VPRORVDZrrkz_VPRORVQZrr_VPRORVQZrrk_VPRORVQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1100
  {DBGFIELD("VPROLDZ256ri_VPROLDZ256rik_VPROLDZ256rikz_VPROLQZ256ri_VPROLQZ256rik_VPROLQZ256rikz_VPRORDZ256ri_VPRORDZ256rik_VPRORDZ256rikz_VPRORQZ256ri_VPRORQZ256rik_VPRORQZ256rikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1101
  {DBGFIELD("VPROLDZ128ri_VPROLDZ128rik_VPROLDZ128rikz_VPROLQZ128ri_VPROLQZ128rik_VPROLQZ128rikz_VPRORDZ128ri_VPRORDZ128rik_VPRORDZ128rikz_VPRORQZ128ri_VPRORQZ128rik_VPRORQZ128rikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1102
  {DBGFIELD("VPROLDZri_VPROLDZrik_VPROLDZrikz_VPROLQZri_VPROLQZrik_VPROLQZrikz_VPRORDZri_VPRORDZrik_VPRORDZrikz_VPRORQZri_VPRORQZrik_VPRORQZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1103
  {DBGFIELD("VFMSUB231SSZr_Intkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1104
  {DBGFIELD("VPSLLDZ128ri_VPSLLDZ128rik_VPSLLDZ128rikz_VPSLLQZ128ri_VPSLLQZ128rik_VPSLLQZ128rikz_VPSLLWZ128ri_VPSLLWZ128rik_VPSLLWZ128rikz_VPSRADZ128ri_VPSRADZ128rik_VPSRADZ128rikz_VPSRAQZ128ri_VPSRAQZ128rik_VPSRAQZ128rikz_VPSRAWZ128ri_VPSRAWZ128rik_VPSRAWZ128rikz_VPSRLDZ128ri_VPSRLDZ128rik_VPSRLDZ128rikz_VPSRLQZ128ri_VPSRLQZ128rik_VPSRLQZ128rikz_VPSRLWZ128ri_VPSRLWZ128rik_VPSRLWZ128rikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1105
  {DBGFIELD("VPSLLDZ256ri_VPSLLDZ256rik_VPSLLDZ256rikz_VPSLLQZ256ri_VPSLLQZ256rik_VPSLLQZ256rikz_VPSLLWZ256ri_VPSLLWZ256rik_VPSLLWZ256rikz_VPSRADZ256ri_VPSRADZ256rik_VPSRADZ256rikz_VPSRAQZ256ri_VPSRAQZ256rik_VPSRAQZ256rikz_VPSRAWZ256ri_VPSRAWZ256rik_VPSRAWZ256rikz_VPSRLDZ256ri_VPSRLDZ256rik_VPSRLDZ256rikz_VPSRLQZ256ri_VPSRLQZ256rik_VPSRLQZ256rikz_VPSRLWZ256ri_VPSRLWZ256rik_VPSRLWZ256rikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1106
  {DBGFIELD("VPSLLDZri_VPSLLDZrik_VPSLLDZrikz_VPSLLQZri_VPSLLQZrik_VPSLLQZrikz_VPSLLWZri_VPSLLWZrik_VPSLLWZrikz_VPSRADZri_VPSRADZrik_VPSRADZrikz_VPSRAQZri_VPSRAQZrik_VPSRAQZrikz_VPSRAWZri_VPSRAWZrik_VPSRAWZrikz_VPSRLDZri_VPSRLDZrik_VPSRLDZrikz_VPSRLQZri_VPSRLQZrik_VPSRLQZrikz_VPSRLWZri_VPSRLWZrik_VPSRLWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1107
  {DBGFIELD("PALIGNRrri_VPALIGNRZ128rri_VPALIGNRZ128rrik_VPALIGNRZ128rrikz_VPALIGNRrri") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1108
  {DBGFIELD("VPALIGNRZ256rri_VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1109
  {DBGFIELD("VPALIGNRZrri_VPALIGNRZrrik_VPALIGNRZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1110
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWZ128rr_VPACKSSDWZ128rrk_VPACKSSDWZ128rrkz_VPACKSSDWrr_VPACKSSWBZ128rr_VPACKSSWBZ128rrk_VPACKSSWBZ128rrkz_VPACKSSWBrr_VPACKUSDWZ128rr_VPACKUSDWZ128rrk_VPACKUSDWZ128rrkz_VPACKUSDWrr_VPACKUSWBZ128rr_VPACKUSWBZ128rrk_VPACKUSWBZ128rrkz_VPACKUSWBrr") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1111
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSDWZ256rrk_VPACKSSDWZ256rrkz_VPACKSSWBZ256rr_VPACKSSWBZ256rrk_VPACKSSWBZ256rrkz_VPACKUSDWZ256rr_VPACKUSDWZ256rrk_VPACKUSDWZ256rrkz_VPACKUSWBZ256rr_VPACKUSWBZ256rrk_VPACKUSWBZ256rrkz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1112
  {DBGFIELD("VPACKSSDWZrr_VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrr_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrr_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrr_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1113
  {DBGFIELD("CMPPDrri_VCMPPDrri_VMAXCPDZ128rr_VMAXCPDZ128rrk_VMAXCPDZ128rrkz_VMAXPDZ128rr_VMAXPDZ128rrk_VMAXPDZ128rrkz_VMINCPDZ128rr_VMINCPDZ128rrk_VMINCPDZ128rrkz_VMINPDZ128rr_VMINPDZ128rrk_VMINPDZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1114
  {DBGFIELD("CMPPSrri_VCMPPSrri") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1115
  {DBGFIELD("CMPSDrri_CMPSDrri_Int_VCMPSDrri_VCMPSDrri_Int_MAXSDrr_Int_MINSDrr_Int_VMAXSDZrr_Int_VMAXSDZrr_Intk_VMAXSDZrr_Intkz_VMAXSDrr_Int_VMINSDZrr_Int_VMINSDZrr_Intk_VMINSDZrr_Intkz_VMINSDrr_Int") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1116
  {DBGFIELD("CMPSSrri_CMPSSrri_Int_VCMPSSrri_VCMPSSrri_Int_MAXSSrr_Int_MINSSrr_Int_VMAXSSZrr_Int_VMAXSSZrr_Intk_VMAXSSZrr_Intkz_VMAXSSrr_Int_VMINSSZrr_Int_VMINSSZrr_Intk_VMINSSZrr_Intkz_VMINSSrr_Int") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1117
  {DBGFIELD("VPMAXSQZ128rr_VPMAXSQZ128rrk_VPMAXSQZ128rrkz_VPMAXUQZ128rr_VPMAXUQZ128rrk_VPMAXUQZ128rrkz_VPMINSQZ128rr_VPMINSQZ128rrk_VPMINSQZ128rrkz_VPMINUQZ128rr_VPMINUQZ128rrk_VPMINUQZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1118
  {DBGFIELD("VPMAXSQZ256rr_VPMAXSQZ256rrk_VPMAXSQZ256rrkz_VPMAXUQZ256rr_VPMAXUQZ256rrk_VPMAXUQZ256rrkz_VPMINSQZ256rr_VPMINSQZ256rrk_VPMINSQZ256rrkz_VPMINUQZ256rr_VPMINUQZ256rrk_VPMINUQZ256rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1119
  {DBGFIELD("VPMAXSQZrr_VPMAXSQZrrk_VPMAXSQZrrkz_VPMAXUQZrr_VPMAXUQZrrk_VPMAXUQZrrkz_VPMINSQZrr_VPMINSQZrrk_VPMINSQZrrkz_VPMINUQZrr_VPMINUQZrrk_VPMINUQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1120
  {DBGFIELD("VMAXCPDZ256rr_VMAXCPDZ256rrk_VMAXCPDZ256rrkz_VMAXPDZ256rr_VMAXPDZ256rrk_VMAXPDZ256rrkz_VMINCPDZ256rr_VMINCPDZ256rrk_VMINCPDZ256rrkz_VMINPDZ256rr_VMINPDZ256rrk_VMINPDZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1121
  {DBGFIELD("VMAXCPDZrr_VMAXCPDZrrk_VMAXCPDZrrkz_VMAXPDZrr_VMAXPDZrrb_VMAXPDZrrbk_VMAXPDZrrbkz_VMAXPDZrrk_VMAXPDZrrkz_VMINCPDZrr_VMINCPDZrrk_VMINCPDZrrkz_VMINPDZrr_VMINPDZrrb_VMINPDZrrbk_VMINPDZrrbkz_VMINPDZrrk_VMINPDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1122
  {DBGFIELD("VMOVDDUPZ128rr_VMOVDDUPZ128rrk_VMOVDDUPZ128rrkz") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1123
  {DBGFIELD("VMOVDDUPZ256rr_VMOVDDUPZ256rrk_VMOVDDUPZ256rrkz") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1124
  {DBGFIELD("VMOVDDUPZrr_VMOVDDUPZrrk_VMOVDDUPZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1125
  {DBGFIELD("VPMOVSXBDZ128rr_VPMOVSXBDZ128rrk_VPMOVSXBDZ128rrkz_VPMOVSXBQZ128rr_VPMOVSXBQZ128rrk_VPMOVSXBQZ128rrkz_VPMOVSXBWZ128rr_VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVSXDQZ128rr_VPMOVSXDQZ128rrk_VPMOVSXDQZ128rrkz_VPMOVSXWDZ128rr_VPMOVSXWDZ128rrk_VPMOVSXWDZ128rrkz_VPMOVSXWQZ128rr_VPMOVSXWQZ128rrk_VPMOVSXWQZ128rrkz_VPMOVZXBDZ128rr_VPMOVZXBDZ128rrk_VPMOVZXBDZ128rrkz_VPMOVZXBQZ128rr_VPMOVZXBQZ128rrk_VPMOVZXBQZ128rrkz_VPMOVZXBWZ128rr_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz_VPMOVZXDQZ128rr_VPMOVZXDQZ128rrk_VPMOVZXDQZ128rrkz_VPMOVZXWDZ128rr_VPMOVZXWDZ128rrk_VPMOVZXWDZ128rrkz_VPMOVZXWQZ128rr_VPMOVZXWQZ128rrk_VPMOVZXWQZ128rrkz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1126
  {DBGFIELD("VPMOVSXBDZ256rr_VPMOVSXBDZ256rrk_VPMOVSXBDZ256rrkz_VPMOVSXBQZ256rr_VPMOVSXBQZ256rrk_VPMOVSXBQZ256rrkz_VPMOVSXBWZ256rr_VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVSXDQZ256rr_VPMOVSXDQZ256rrk_VPMOVSXDQZ256rrkz_VPMOVSXWDZ256rr_VPMOVSXWDZ256rrk_VPMOVSXWDZ256rrkz_VPMOVSXWQZ256rr_VPMOVSXWQZ256rrk_VPMOVSXWQZ256rrkz_VPMOVZXBDZ256rr_VPMOVZXBDZ256rrk_VPMOVZXBDZ256rrkz_VPMOVZXBQZ256rr_VPMOVZXBQZ256rrk_VPMOVZXBQZ256rrkz_VPMOVZXBWZ256rr_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz_VPMOVZXDQZ256rr_VPMOVZXDQZ256rrk_VPMOVZXDQZ256rrkz_VPMOVZXWDZ256rr_VPMOVZXWDZ256rrk_VPMOVZXWDZ256rrkz_VPMOVZXWQZ256rr_VPMOVZXWQZ256rrk_VPMOVZXWQZ256rrkz_VPMOVSXBDYrr_VPMOVSXBQYrr_VPMOVSXBWYrr_VPMOVZXBDYrr_VPMOVZXBQYrr_VPMOVZXBWYrr_VPMOVSXDQYrr_VPMOVSXWDYrr_VPMOVSXWQYrr_VPMOVUSQWZ128rr_VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz_VPMOVZXDQYrr_VPMOVZXWDYrr_VPMOVZXWQYrr_VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz_VPMOVQDZ256rr_VPMOVQDZ256rrk_VPMOVQDZ256rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1127
  {DBGFIELD("PMOVSXBDrr_PMOVSXBQrr_PMOVSXBWrr_PMOVSXDQrr_PMOVSXWDrr_PMOVSXWQrr_PMOVZXBDrr_PMOVZXBQrr_PMOVZXBWrr_PMOVZXDQrr_PMOVZXWDrr_PMOVZXWQrr_VPMOVSXBDrr_VPMOVSXBQrr_VPMOVSXBWrr_VPMOVSXDQrr_VPMOVSXWDrr_VPMOVSXWQrr_VPMOVZXBDrr_VPMOVZXBQrr_VPMOVZXBWrr_VPMOVZXDQrr_VPMOVZXWDrr_VPMOVZXWQrr") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1128
  {DBGFIELD("VPMOVSXBDZrr_VPMOVSXBDZrrk_VPMOVSXBDZrrkz_VPMOVSXBQZrr_VPMOVSXBQZrrk_VPMOVSXBQZrrkz_VPMOVSXBWZrr_VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVSXDQZrr_VPMOVSXDQZrrk_VPMOVSXDQZrrkz_VPMOVSXWDZrr_VPMOVSXWDZrrk_VPMOVSXWDZrrkz_VPMOVSXWQZrr_VPMOVSXWQZrrk_VPMOVSXWQZrrkz_VPMOVZXBDZrr_VPMOVZXBDZrrk_VPMOVZXBDZrrkz_VPMOVZXBQZrr_VPMOVZXBQZrrk_VPMOVZXBQZrrkz_VPMOVZXBWZrr_VPMOVZXBWZrrk_VPMOVZXBWZrrkz_VPMOVZXDQZrr_VPMOVZXDQZrrk_VPMOVZXDQZrrkz_VPMOVZXWDZrr_VPMOVZXWDZrrk_VPMOVZXWDZrrkz_VPMOVZXWQZrr_VPMOVZXWQZrrk_VPMOVZXWQZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1129
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz_VPMOVUSQWZrr_VPMOVUSQWZrrk_VPMOVUSQWZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1130
  {DBGFIELD("VPTESTMBZ128rrk_VPTESTMDZ128rrk_VPTESTMQZ128rrk_VPTESTMWZ128rrk_VPTESTNMBZ128rrk_VPTESTNMDZ128rrk_VPTESTNMQZ128rrk_VPTESTNMWZ128rrk") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1131
  {DBGFIELD("VPTESTMBZ256rr_VPTESTMBZ256rrk_VPTESTMDZ256rr_VPTESTMDZ256rrk_VPTESTMQZ256rr_VPTESTMQZ256rrk_VPTESTMWZ256rr_VPTESTMWZ256rrk_VPTESTNMBZ256rr_VPTESTNMBZ256rrk_VPTESTNMDZ256rr_VPTESTNMDZ256rrk_VPTESTNMQZ256rr_VPTESTNMQZ256rrk_VPTESTNMWZ256rr_VPTESTNMWZ256rrk") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1132
  {DBGFIELD("VPTESTMBZrrk_VPTESTMDZrrk_VPTESTMQZrrk_VPTESTMWZrrk_VPTESTNMBZrrk_VPTESTNMDZrrk_VPTESTNMQZrrk_VPTESTNMWZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1133
  {DBGFIELD("VPCONFLICTDZ128rr_VPCONFLICTDZ128rrk_VPCONFLICTDZ128rrkz_VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1134
  {DBGFIELD("VPCONFLICTDZ256rr_VPCONFLICTDZ256rrk_VPCONFLICTDZ256rrkz_VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1135
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrk_VPCONFLICTDZrrkz_VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1136
  {DBGFIELD("VRSQRT14PDZ128r_VRSQRT14PDZ128rk_VRSQRT14PDZ128rkz_VRSQRT14PSZ128r_VRSQRT14PSZ128rk_VRSQRT14PSZ128rkz") 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #1137
  {DBGFIELD("VRSQRT14PDZ256r_VRSQRT14PDZ256rk_VRSQRT14PDZ256rkz_VRSQRT14PSZ256r_VRSQRT14PSZ256rk_VRSQRT14PSZ256rkz") 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #1138
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PDZrk_VRSQRT14PDZrkz_VRSQRT14PSZr_VRSQRT14PSZrk_VRSQRT14PSZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1139
  {DBGFIELD("VPERMILPDYrr_VPERMILPDZ256rr_VPERMILPDZ256rrk_VPERMILPDZ256rrkz_VPERMILPSYrr_VPERMILPSZ256rr_VPERMILPSZ256rrk_VPERMILPSZ256rrkz") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1140
  {DBGFIELD("VPERMILPDZ128rr_VPERMILPDZ128rrk_VPERMILPDZ128rrkz_VPERMILPSZ128rr_VPERMILPSZ128rrk_VPERMILPSZ128rrkz") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1141
  {DBGFIELD("VPERMILPDZrr_VPERMILPDZrrk_VPERMILPDZrrkz_VPERMILPSZrr_VPERMILPSZrrk_VPERMILPSZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1142
  {DBGFIELD("VPERMI2PDZ128rr_VPERMI2PDZ128rrk_VPERMI2PDZ128rrkz_VPERMI2PSZ128rr_VPERMI2PSZ128rrk_VPERMI2PSZ128rrkz_VPERMT2PDZ128rr_VPERMT2PDZ128rrk_VPERMT2PDZ128rrkz_VPERMT2PSZ128rr_VPERMT2PSZ128rrk_VPERMT2PSZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1143
  {DBGFIELD("VPERMI2WZ128rr_VPERMI2WZ128rrk_VPERMI2WZ128rrkz_VPERMT2WZ128rr_VPERMT2WZ128rrk_VPERMT2WZ128rrkz_VPERMI2BZ128rr_VPERMI2BZ128rrk_VPERMI2BZ128rrkz_VPERMI2DZ128rr_VPERMI2DZ128rrk_VPERMI2DZ128rrkz_VPERMI2QZ128rr_VPERMI2QZ128rrk_VPERMI2QZ128rrkz_VPERMT2BZ128rr_VPERMT2BZ128rrk_VPERMT2BZ128rrkz_VPERMT2DZ128rr_VPERMT2DZ128rrk_VPERMT2DZ128rrkz_VPERMT2QZ128rr_VPERMT2QZ128rrk_VPERMT2QZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1144
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSBZ128rr_VPCOMPRESSBZ128rrk_VPCOMPRESSBZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPCOMPRESSWZ128rr_VPCOMPRESSWZ128rrk_VPCOMPRESSWZ128rrkz_VPERMBZ128rr_VPERMBZ128rrk_VPERMBZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1145
  {DBGFIELD("VPERMI2PDZ256rr_VPERMI2PDZ256rrk_VPERMI2PDZ256rrkz_VPERMI2PSZ256rr_VPERMI2PSZ256rrk_VPERMI2PSZ256rrkz_VPERMT2PDZ256rr_VPERMT2PDZ256rrk_VPERMT2PDZ256rrkz_VPERMT2PSZ256rr_VPERMT2PSZ256rrk_VPERMT2PSZ256rrkz_VPERMPDZ256rr_VPERMPDZ256rrk_VPERMPDZ256rrkz_VPERMPSZ256rr_VPERMPSZ256rrk_VPERMPSZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1146
  {DBGFIELD("VPERMI2WZ256rr_VPERMI2WZ256rrk_VPERMI2WZ256rrkz_VPERMT2WZ256rr_VPERMT2WZ256rrk_VPERMT2WZ256rrkz_VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSBZ256rr_VPCOMPRESSBZ256rrk_VPCOMPRESSBZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPCOMPRESSWZ256rr_VPCOMPRESSWZ256rrk_VPCOMPRESSWZ256rrkz_VPERMBZ256rr_VPERMBZ256rrk_VPERMBZ256rrkz_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz_VPERMI2BZ256rr_VPERMI2BZ256rrk_VPERMI2BZ256rrkz_VPERMI2DZ256rr_VPERMI2DZ256rrk_VPERMI2DZ256rrkz_VPERMI2QZ256rr_VPERMI2QZ256rrk_VPERMI2QZ256rrkz_VPERMT2BZ256rr_VPERMT2BZ256rrk_VPERMT2BZ256rrkz_VPERMT2DZ256rr_VPERMT2DZ256rrk_VPERMT2DZ256rrkz_VPERMT2QZ256rr_VPERMT2QZ256rrk_VPERMT2QZ256rrkz_VPEXPANDBZ256rr_VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rr_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1147
  {DBGFIELD("VPERMI2PDZrr_VPERMI2PDZrrk_VPERMI2PDZrrkz_VPERMI2PSZrr_VPERMI2PSZrrk_VPERMI2PSZrrkz_VPERMT2PDZrr_VPERMT2PDZrrk_VPERMT2PDZrrkz_VPERMT2PSZrr_VPERMT2PSZrrk_VPERMT2PSZrrkz_VPERMPDZrr_VPERMPDZrrk_VPERMPDZrrkz_VPERMPSZrr_VPERMPSZrrk_VPERMPSZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1148
  {DBGFIELD("VPERMI2WZrr_VPERMI2WZrrk_VPERMI2WZrrkz_VPERMT2WZrr_VPERMT2WZrrk_VPERMT2WZrrkz_VPERMBZrr_VPERMBZrrk_VPERMBZrrkz_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz_VPERMI2BZrr_VPERMI2BZrrk_VPERMI2BZrrkz_VPERMI2DZrr_VPERMI2DZrrk_VPERMI2DZrrkz_VPERMI2QZrr_VPERMI2QZrrk_VPERMI2QZrrkz_VPERMT2BZrr_VPERMT2BZrrk_VPERMT2BZrrkz_VPERMT2DZrr_VPERMT2DZrrk_VPERMT2DZrrkz_VPERMT2QZrr_VPERMT2QZrrk_VPERMT2QZrrkz_VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSBZrr_VPCOMPRESSBZrrk_VPCOMPRESSBZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPCOMPRESSWZrr_VPCOMPRESSWZrrk_VPCOMPRESSWZrrkz_VPEXPANDBZrr_VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrr_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1149
  {DBGFIELD("VPABSBZ128rr_VPABSBZ128rrk_VPABSBZ128rrkz_VPABSDZ128rr_VPABSDZ128rrk_VPABSDZ128rrkz_VPABSQZ128rr_VPABSQZ128rrk_VPABSQZ128rrkz_VPABSWZ128rr_VPABSWZ128rrk_VPABSWZ128rrkz_VPADDSBZ128rr_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rr_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rr_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rr_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rr_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rr_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPOPCNTBZ128rr_VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTDZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rr_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz_VPOPCNTWZ128rr_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz_VPSUBSBZ128rr_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rr_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPSUBUSBZ128rr_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rr_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1150
  {DBGFIELD("LSL16rr_LSL32rr_LSL64rr") 15, false, false, false, 1964, 16, 56, 1,  0, 0}, // #1151
  {DBGFIELD("LXADD8_LXADD16_LXADD32_LXADD64") 4, false, false, false, 59, 6,  2, 1,  0, 0}, // #1152
  {DBGFIELD("BLCFILL32rr_BLCFILL64rr_BLCI32rr_BLCI64rr_BLCIC32rr_BLCIC64rr_BLCMSK32rr_BLCMSK64rr_BLCS32rr_BLCS64rr_BLSFILL32rr_BLSFILL64rr_BLSIC32rr_BLSIC64rr_T1MSKC32rr_T1MSKC64rr_TZMSK32rr_TZMSK64rr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1153
  {DBGFIELD("BLCFILL32rm_BLCFILL64rm_BLCI32rm_BLCI64rm_BLCIC32rm_BLCIC64rm_BLCMSK32rm_BLCMSK64rm_BLCS32rm_BLCS64rm_BLSFILL32rm_BLSFILL64rm_BLSIC32rm_BLSIC64rm_T1MSKC32rm_T1MSKC64rm_TZMSK32rm_TZMSK64rm") 1, false, false, false,  1, 2,  8, 1,  0, 0}, // #1154
  {DBGFIELD("ADC64ri32_SBB64ri32") 1, false, false, false, 12, 5,  1, 1,  0, 0}, // #1155
  {DBGFIELD("CRC32r32r16")        1, false, false, false, 39, 8,  5, 1,  0, 0}, // #1156
  {DBGFIELD("CRC32r32r32")        1, false, false, false, 39, 8,  5, 1,  0, 0}, // #1157
  {DBGFIELD("CRC32r64r64")        1, false, false, false, 39, 8,  5, 1,  0, 0}, // #1158
  {DBGFIELD("SAHF")               2, false, false, false, 784, 5, 14, 1,  0, 0}, // #1159
  {DBGFIELD("BEXTRI32ri_BEXTRI64ri") 2, false, false, false, 167, 10,  3, 1,  0, 0}, // #1160
  {DBGFIELD("BEXTRI32mi_BEXTRI64mi") 3, false, false, false, 155, 12,  8, 1,  0, 0}, // #1161
  {DBGFIELD("RCR8ri")             3, false, false, false, 779, 5, 12, 1,  0, 0}, // #1162
  {DBGFIELD("RCL16rCL")           7, false, false, false, 1954, 10,  7, 1,  0, 0}, // #1163
  {DBGFIELD("RCR16ri")            3, false, false, false, 779, 5, 12, 1,  0, 0}, // #1164
  {DBGFIELD("RCR32rCL_RCR64rCL")  7, false, false, false, 1954, 10,  7, 1,  0, 0}, // #1165
  {DBGFIELD("RCL16ri")            3, false, false, false, 779, 5, 12, 1,  0, 0}, // #1166
  {DBGFIELD("RCL32ri_RCL64ri")    3, false, false, false, 779, 5, 12, 1,  0, 0}, // #1167
  {DBGFIELD("SHLD16rrCL")         3, false, false, false, 504, 10, 10, 1,  0, 0}, // #1168
  {DBGFIELD("SHLD32rrCL_SHRD32rrCL") 3, false, false, false, 504, 10, 10, 1,  0, 0}, // #1169
  {DBGFIELD("VMOVUPDYmr_VMOVUPSYmr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1170
  {DBGFIELD("TST_F")              1, false, false, false,  3, 9, 12, 1,  0, 0}, // #1171
  {DBGFIELD("VDPPSrri")           6, false, false, false, 368, 12, 21, 1,  0, 0}, // #1172
  {DBGFIELD("VFRCZPDrr_VFRCZPSrr") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1173
  {DBGFIELD("VFRCZSDrr_VFRCZSSrr") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1174
  {DBGFIELD("VFRCZPDrm_VFRCZPSrm_VFRCZSDrm_VFRCZSSrm") 3, false, false, false, 115, 7, 11, 1,  6, 1}, // #1175
  {DBGFIELD("VFRCZPSYrr_VFRCZPDYrr") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1176
  {DBGFIELD("VFRCZPSYrm_VFRCZPDYrm") 3, false, false, false, 115, 7, 16, 1,  6, 1}, // #1177
  {DBGFIELD("MMX_CVTTPD2PIrr")    2, false, false, false, 258, 11,  7, 1,  0, 0}, // #1178
  {DBGFIELD("CVTSI2SSrr")         2, false, false, false, 258, 11,  6, 1,  0, 1}, // #1179
  {DBGFIELD("VMOVDQUYmr")         2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1180
  {DBGFIELD("MOVDQArr")           0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1181
  {DBGFIELD("VPMACSDQHrr_VPMACSDQLrr_VPMACSSDQHrr_VPMACSSDQLrr") 2, false, false, false, 122, 5,  9, 1,  0, 0}, // #1182
  {DBGFIELD("VPPERMrrr_VPPERMrrr_REV") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1183
  {DBGFIELD("VPPERMrrm")          2, false, false, false, 79, 8,  7, 1, 10, 2}, // #1184
  {DBGFIELD("VPPERMrmr")          2, false, false, false, 79, 8,  7, 1,  8, 2}, // #1185
  {DBGFIELD("PHADDWrr_PHSUBWrr_PHADDSWrr_PHSUBSWrr_VPHADDDrr_VPHSUBDrr_VPHADDWrr_VPHSUBWrr_VPHADDSWrr_VPHSUBSWrr") 3, false, false, false, 737, 6, 12, 1,  0, 0}, // #1186
  {DBGFIELD("PHADDWrm_PHSUBWrm_PHADDSWrm_PHSUBSWrm_VPHADDDrm_VPHSUBDrm_VPHADDWrm_VPHSUBWrm_VPHADDSWrm_VPHSUBSWrm") 4, false, false, false, 729, 8, 22, 1,  6, 1}, // #1187
  {DBGFIELD("VPCLMULQDQrri")      1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1188
  {DBGFIELD("ANDNPSrr_ANDNPDrr")  1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1189
  {DBGFIELD("MMX_PXORrr_MMX_PANDNrr") 1, false, false, false, 563, 6,  1, 1,  0, 0}, // #1190
  {DBGFIELD("PANDNrr")            1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1191
  {DBGFIELD("MMX_PSUBBrr_MMX_PSUBDrr_MMX_PSUBWrr_MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false, 563, 6,  1, 1,  0, 0}, // #1192
  {DBGFIELD("LCMPXCHG16_LCMPXCHG32_LCMPXCHG64") 6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1193
  {DBGFIELD("CMPXCHG16rr_CMPXCHG32rr_CMPXCHG64rr") 5, false, false, false, 242, 5,  5, 1,  0, 0}, // #1194
  {DBGFIELD("LCMPXCHG8B")         6, false, false, false, 17, 9,  2, 1,  0, 0}, // #1195
  {DBGFIELD("INC8m_INC16m_INC32m_INC64m_DEC8m_DEC16m_DEC32m_DEC64m_NOT8m_NOT16m_NOT32m_NOT64m_NEG8m_NEG16m_NEG32m_NEG64m") 4, false, false, false, 59, 6,  2, 1,  0, 0}, // #1196
  {DBGFIELD("XCHG8rr")            3, false, false, false, 240, 2, 12, 1,  0, 0}, // #1197
  {DBGFIELD("MMX_PSUBSBrr_MMX_PSUBSWrr_MMX_PSUBUSBrr_MMX_PSUBUSWrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1198
  {DBGFIELD("PSUBSBrr_VPSUBSBrr_PSUBSWrr_VPSUBSWrr_PSUBUSBrr_VPSUBUSBrr_PSUBUSWrr_VPSUBUSWrr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1199
  {DBGFIELD("MMX_PCMPEQBrr_MMX_PCMPEQDrr_MMX_PCMPEQWrr_MMX_PMAXSWrr_MMX_PMINSWrr_MMX_PMAXUBrr_MMX_PMINUBrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1200
  {DBGFIELD("MMX_PCMPGTBrr_MMX_PCMPGTDrr_MMX_PCMPGTWrr") 1, false, false, false,  3, 9,  1, 1,  0, 0}, // #1201
  {DBGFIELD("CLAC_STAC")          1, false, false, false, 12, 5,  1, 1,  0, 0}, // #1202
  {DBGFIELD("PADDBrr_PADDDrr_PADDWrr_VPADDBrr_VPADDDrr_VPADDQrr_VPADDWrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1203
  {DBGFIELD("VPADDBYrr_VPADDDYrr_VPADDQYrr_VPADDWYrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1204
  {DBGFIELD("ADD_FPrST0_ADD_FST0r_ADD_FrST0_SUBR_FPrST0_SUBR_FST0r_SUBR_FrST0_SUB_FPrST0_SUB_FST0r_SUB_FrST0") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1205
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHSUBSWrr") 3, false, false, false, 1980, 13,  5, 1,  0, 0}, // #1206
  {DBGFIELD("PHADDSWrr_VPHADDSWrr_PHSUBSWrr_VPHSUBSWrr") 3, false, false, false, 1993, 7, 12, 1,  0, 0}, // #1207
  {DBGFIELD("VPHADDSWYrr_VPHSUBSWYrr") 3, false, false, false, 1993, 7, 12, 1,  0, 0}, // #1208
  {DBGFIELD("MMX_PADDSBrm_MMX_PADDSWrm_MMX_PADDUSBrm_MMX_PADDUSWrm_MMX_PAVGBrm_MMX_PAVGWrm_MMX_PCMPEQBrm_MMX_PCMPEQDrm_MMX_PCMPEQWrm_MMX_PCMPGTBrm_MMX_PCMPGTDrm_MMX_PCMPGTWrm_MMX_PMAXSWrm_MMX_PMAXUBrm_MMX_PMINSWrm_MMX_PMINUBrm_MMX_PSUBSBrm_MMX_PSUBSWrm_MMX_PSUBUSBrm_MMX_PSUBUSWrm") 2, false, false, false, 247, 11, 22, 1,  6, 1}, // #1209
  {DBGFIELD("PADDBrm_PADDDrm_PADDWrm_VPADDBrm_VPADDDrm_VPADDQrm_VPADDWrm_PSUBBrm_PSUBDrm_PSUBWrm_VPSUBBrm_VPSUBDrm_VPSUBQrm_VPSUBWrm") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #1210
  {DBGFIELD("VCVTSS2SI64rr_VCVTTSS2SI64rr") 3, false, false, false, 933, 13,  7, 1,  0, 0}, // #1211
  {DBGFIELD("VCVTSS2SI64rr_Int_VCVTTSS2SI64rr_Int") 3, false, false, false, 933, 13,  7, 1,  0, 0}, // #1212
  {DBGFIELD("VPADDBYrm_VPADDDYrm_VPADDQYrm_VPADDWYrm_VPSUBBYrm_VPSUBDYrm_VPSUBQYrm_VPSUBWYrm") 2, false, false, false, 104, 6, 22, 1,  6, 1}, // #1213
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHSUBSWrm") 4, false, false, false, 2000, 15,  8, 1,  6, 1}, // #1214
  {DBGFIELD("PHADDSWrm_VPHADDSWrm_PHSUBSWrm_VPHSUBSWrm") 4, false, false, false, 2015, 9, 22, 1,  6, 1}, // #1215
  {DBGFIELD("VPHADDSWYrm_VPHSUBSWYrm") 4, false, false, false, 2015, 9,  9, 1,  6, 1}, // #1216
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64") 186, false, false, false, 2024, 17, 52, 1,  0, 0}, // #1217
  {DBGFIELD("PCMPGTBrr_PCMPGTDrr_PCMPGTWrr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1218
  {DBGFIELD("VPCMPGTBrr_VPCMPGTDrr_VPCMPGTWrr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1219
  {DBGFIELD("VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1220
  {DBGFIELD("KANDBrr_KANDDrr_KANDQrr_KANDWrr_KANDNBrr_KANDNDrr_KANDNQrr_KANDNWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1221
  {DBGFIELD("KMOVBkk_KMOVDkk_KMOVQkk_KMOVWkk") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1222
  {DBGFIELD("KMOVBkk_EVEX_KMOVDkk_EVEX_KMOVQkk_EVEX_KMOVWkk_EVEX_VPMOVB2MZ128rr_VPMOVB2MZ256rr_VPMOVB2MZrr_VPMOVD2MZ128rr_VPMOVD2MZ256rr_VPMOVD2MZrr_VPMOVQ2MZ128rr_VPMOVQ2MZ256rr_VPMOVQ2MZrr_VPMOVW2MZ128rr_VPMOVW2MZ256rr_VPMOVW2MZrr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1223
  {DBGFIELD("KSET0D_KSET0Q_KSET0W_KSET1D_KSET1Q_KSET1W") 1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1224
  {DBGFIELD("KMOVBkr_EVEX_KMOVDkr_EVEX_KMOVQkr_EVEX_KMOVWkr_EVEX") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1225
  {DBGFIELD("VBLENDMPDZ128rr_VBLENDMPDZ128rrk_VBLENDMPDZ128rrkz_VBLENDMPSZ128rr_VBLENDMPSZ128rrk_VBLENDMPSZ128rrkz") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1226
  {DBGFIELD("VBLENDMPDZ256rr_VBLENDMPDZ256rrk_VBLENDMPDZ256rrkz_VBLENDMPSZ256rr_VBLENDMPSZ256rrk_VBLENDMPSZ256rrkz") 3, false, false, false, 874, 4,  5, 1,  0, 0}, // #1227
  {DBGFIELD("VPADDBZ128rr_VPADDBZ128rrk_VPADDBZ128rrkz_VPADDDZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rr_VPADDQZ128rrk_VPADDQZ128rrkz_VPADDWZ128rr_VPADDWZ128rrk_VPADDWZ128rrkz_VPSUBBZ128rrk_VPSUBBZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPSUBWZ128rrk_VPSUBWZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1228
  {DBGFIELD("VPADDBZ256rr_VPADDBZ256rrk_VPADDBZ256rrkz_VPADDDZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rr_VPADDQZ256rrk_VPADDQZ256rrkz_VPADDWZ256rr_VPADDWZ256rrk_VPADDWZ256rrkz_VPSUBBZ256rrk_VPSUBBZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPSUBWZ256rrk_VPSUBWZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1229
  {DBGFIELD("VPADDBZrr_VPADDBZrrk_VPADDBZrrkz_VPADDDZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrr_VPADDQZrrk_VPADDQZrrkz_VPADDWZrr_VPADDWZrrk_VPADDWZrrkz_VPSUBBZrrk_VPSUBBZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPSUBWZrrk_VPSUBWZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1230
  {DBGFIELD("VPBLENDMBZ128rr_VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMDZ128rr_VPBLENDMDZ128rrk_VPBLENDMDZ128rrkz_VPBLENDMQZ128rr_VPBLENDMQZ128rrk_VPBLENDMQZ128rrkz_VPBLENDMWZ128rr_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1231
  {DBGFIELD("VPBLENDMBZ256rr_VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMDZ256rr_VPBLENDMDZ256rrk_VPBLENDMDZ256rrkz_VPBLENDMQZ256rr_VPBLENDMQZ256rrk_VPBLENDMQZ256rrkz_VPBLENDMWZ256rr_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 3, false, false, false, 874, 4,  5, 1,  0, 0}, // #1232
  {DBGFIELD("KMOVBmk_EVEX_KMOVDmk_EVEX_KMOVQmk_EVEX_KMOVWmk_EVEX") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1233
  {DBGFIELD("VMOVDQU8Zmr_VMOVDQU8Zmrk") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1234
  {DBGFIELD("KMOVBrk_EVEX_KMOVDrk_EVEX_KMOVQrk_EVEX_KMOVWrk_EVEX") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1235
  {DBGFIELD("KORTESTBrr_KORTESTDrr_KORTESTQrr_KORTESTWrr_KTESTBrr_KTESTDrr_KTESTQrr_KTESTWrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1236
  {DBGFIELD("VALIGNDZ128rrik_VALIGNDZ128rrikz_VALIGNQZ128rrik_VALIGNQZ128rrikz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1237
  {DBGFIELD("VALIGNDZ256rrik_VALIGNDZ256rrikz_VALIGNQZ256rrik_VALIGNQZ256rrikz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1238
  {DBGFIELD("VALIGNDZrrik_VALIGNDZrrikz_VALIGNQZrrik_VALIGNQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1239
  {DBGFIELD("KSHIFTLBri_KSHIFTLDri_KSHIFTLQri_KSHIFTLWri_KSHIFTRBri_KSHIFTRDri_KSHIFTRQri_KSHIFTRWri") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1240
  {DBGFIELD("VCMPPDZ128rri_VCMPPDZ128rrik_VCMPPSZ128rri_VCMPPSZ128rrik_VFPCLASSPDZ128rr_VFPCLASSPDZ128rrk_VFPCLASSPSZ128rr_VFPCLASSPSZ128rrk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1241
  {DBGFIELD("VCMPPDZ256rri_VCMPPDZ256rrik_VCMPPSZ256rri_VCMPPSZ256rrik_VFPCLASSPDZ256rr_VFPCLASSPDZ256rrk_VFPCLASSPSZ256rr_VFPCLASSPSZ256rrk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1242
  {DBGFIELD("VCMPPDZrri_VCMPPDZrrib_VCMPPDZrribk_VCMPPDZrrik_VCMPPSZrri_VCMPPSZrrib_VCMPPSZrribk_VCMPPSZrrik_VFPCLASSPDZrr_VFPCLASSPDZrrk_VFPCLASSPSZrr_VFPCLASSPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1243
  {DBGFIELD("VCMPSDZrri_VCMPSDZrri_Int_VCMPSDZrri_Intk_VCMPSDZrrib_Int_VCMPSDZrrib_Intk_VCMPSSZrri_VCMPSSZrri_Int_VCMPSSZrri_Intk_VCMPSSZrrib_Int_VCMPSSZrrib_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1244
  {DBGFIELD("VPCMPBZ128rri_VPCMPBZ128rrik_VPCMPDZ128rri_VPCMPDZ128rrik_VPCMPEQBZ128rr_VPCMPEQBZ128rrk_VPCMPEQDZ128rr_VPCMPEQDZ128rrk_VPCMPEQQZ128rr_VPCMPEQQZ128rrk_VPCMPEQWZ128rr_VPCMPEQWZ128rrk_VPCMPGTBZ128rr_VPCMPGTBZ128rrk_VPCMPGTDZ128rr_VPCMPGTDZ128rrk_VPCMPGTQZ128rr_VPCMPGTQZ128rrk_VPCMPGTWZ128rr_VPCMPGTWZ128rrk_VPCMPQZ128rri_VPCMPQZ128rrik_VPCMPUBZ128rri_VPCMPUBZ128rrik_VPCMPUDZ128rri_VPCMPUDZ128rrik_VPCMPUQZ128rri_VPCMPUQZ128rrik_VPCMPUWZ128rri_VPCMPUWZ128rrik_VPCMPWZ128rri_VPCMPWZ128rrik") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1245
  {DBGFIELD("VPCMPBZ256rri_VPCMPBZ256rrik_VPCMPDZ256rri_VPCMPDZ256rrik_VPCMPEQBZ256rr_VPCMPEQBZ256rrk_VPCMPEQDZ256rr_VPCMPEQDZ256rrk_VPCMPEQQZ256rr_VPCMPEQQZ256rrk_VPCMPEQWZ256rr_VPCMPEQWZ256rrk_VPCMPGTBZ256rr_VPCMPGTBZ256rrk_VPCMPGTDZ256rr_VPCMPGTDZ256rrk_VPCMPGTQZ256rr_VPCMPGTQZ256rrk_VPCMPGTWZ256rr_VPCMPGTWZ256rrk_VPCMPQZ256rri_VPCMPQZ256rrik_VPCMPUBZ256rri_VPCMPUBZ256rrik_VPCMPUDZ256rri_VPCMPUDZ256rrik_VPCMPUQZ256rri_VPCMPUQZ256rrik_VPCMPUWZ256rri_VPCMPUWZ256rrik_VPCMPWZ256rri_VPCMPWZ256rrik") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1246
  {DBGFIELD("VPCMPBZrri_VPCMPBZrrik_VPCMPDZrri_VPCMPDZrrik_VPCMPEQBZrr_VPCMPEQBZrrk_VPCMPEQDZrr_VPCMPEQDZrrk_VPCMPEQQZrr_VPCMPEQQZrrk_VPCMPEQWZrr_VPCMPEQWZrrk_VPCMPGTBZrr_VPCMPGTBZrrk_VPCMPGTDZrr_VPCMPGTDZrrk_VPCMPGTQZrr_VPCMPGTQZrrk_VPCMPGTWZrr_VPCMPGTWZrrk_VPCMPQZrri_VPCMPQZrrik_VPCMPUBZrri_VPCMPUBZrrik_VPCMPUDZrri_VPCMPUDZrrik_VPCMPUQZrri_VPCMPUQZrrik_VPCMPUWZrri_VPCMPUWZrrik_VPCMPWZrri_VPCMPWZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1247
  {DBGFIELD("VPTESTMBZ128rr_VPTESTMDZ128rr_VPTESTMQZ128rr_VPTESTMWZ128rr_VPTESTNMBZ128rr_VPTESTNMDZ128rr_VPTESTNMQZ128rr_VPTESTNMWZ128rr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1248
  {DBGFIELD("VPTESTMBZrr_VPTESTMDZrr_VPTESTMQZrr_VPTESTMWZrr_VPTESTNMBZrr_VPTESTNMDZrr_VPTESTNMQZrr_VPTESTNMWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1249
  {DBGFIELD("VCVTPD2QQZ128rr_VCVTPD2QQZ128rrk_VCVTPD2QQZ128rrkz_VCVTPD2UQQZ128rr_VCVTPD2UQQZ128rrk_VCVTPD2UQQZ128rrkz_VCVTTPD2QQZ128rr_VCVTTPD2QQZ128rrk_VCVTTPD2QQZ128rrkz_VCVTTPD2UQQZ128rr_VCVTTPD2UQQZ128rrk_VCVTTPD2UQQZ128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1250
  {DBGFIELD("VCVTPD2QQZ256rr_VCVTPD2QQZ256rrk_VCVTPD2QQZ256rrkz_VCVTPD2UQQZ256rr_VCVTPD2UQQZ256rrk_VCVTPD2UQQZ256rrkz_VCVTTPD2QQZ256rr_VCVTTPD2QQZ256rrk_VCVTTPD2QQZ256rrkz_VCVTTPD2UQQZ256rr_VCVTTPD2UQQZ256rrk_VCVTTPD2UQQZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1251
  {DBGFIELD("VCVTPS2DQYrr_VCVTPS2DQZ256rr_VCVTPS2DQZ256rrk_VCVTPS2DQZ256rrkz_VCVTPS2UDQZ256rr_VCVTPS2UDQZ256rrk_VCVTPS2UDQZ256rrkz_VCVTTPS2DQZ256rr_VCVTTPS2DQZ256rrk_VCVTTPS2DQZ256rrkz_VCVTTPS2UDQZ256rr_VCVTTPS2UDQZ256rrk_VCVTTPS2UDQZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1252
  {DBGFIELD("VCVTPS2DQZ128rr_VCVTPS2DQZ128rrk_VCVTPS2DQZ128rrkz_VCVTPS2UDQZ128rr_VCVTPS2UDQZ128rrk_VCVTPS2UDQZ128rrkz_VCVTTPS2DQZ128rr_VCVTTPS2DQZ128rrk_VCVTTPS2DQZ128rrkz_VCVTTPS2UDQZ128rr_VCVTTPS2UDQZ128rrk_VCVTTPS2UDQZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1253
  {DBGFIELD("VCVTPD2QQZrr_VCVTPD2UQQZrr_VCVTTPD2QQZrr_VCVTTPD2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1254
  {DBGFIELD("VCVTPS2DQZrr_VCVTPS2UDQZrr_VCVTTPS2DQZrr_VCVTTPS2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1255
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ128rrk_VEXPANDPDZ128rrkz_VEXPANDPDZ256rr_VEXPANDPDZ256rrk_VEXPANDPDZ256rrkz_VEXPANDPDZrr_VEXPANDPDZrrk_VEXPANDPDZrrkz_VEXPANDPSZ128rr_VEXPANDPSZ128rrk_VEXPANDPSZ128rrkz_VEXPANDPSZ256rr_VEXPANDPSZ256rrk_VEXPANDPSZ256rrkz_VEXPANDPSZrr_VEXPANDPSZrrk_VEXPANDPSZrrkz_VPEXPANDDZ128rr_VPEXPANDDZ128rrk_VPEXPANDDZ128rrkz_VPEXPANDDZ256rr_VPEXPANDDZ256rrk_VPEXPANDDZ256rrkz_VPEXPANDDZrr_VPEXPANDDZrrk_VPEXPANDDZrrkz_VPEXPANDQZ128rr_VPEXPANDQZ128rrk_VPEXPANDQZ128rrkz_VPEXPANDQZ256rr_VPEXPANDQZ256rrk_VPEXPANDQZ256rrkz_VPEXPANDQZrr_VPEXPANDQZrrk_VPEXPANDQZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1256
  {DBGFIELD("VPMOVDBZ128rr_VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVDBZ256rr_VPMOVDBZ256rrk_VPMOVDBZ256rrkz_VPMOVDWZ128rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVDWZ256rr_VPMOVDWZ256rrk_VPMOVDWZ256rrkz_VPMOVQBZ128rr_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVQBZ256rr_VPMOVQBZ256rrk_VPMOVQBZ256rrkz_VPMOVQWZ128rr_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVQWZ256rr_VPMOVQWZ256rrk_VPMOVQWZ256rrkz_VPMOVSDBZ128rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSDBZ256rrk_VPMOVSDBZ256rrkz_VPMOVSDWZ128rr_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSDWZ256rr_VPMOVSDWZ256rrk_VPMOVSDWZ256rrkz_VPMOVSQBZ128rr_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSQBZ256rr_VPMOVSQBZ256rrk_VPMOVSQBZ256rrkz_VPMOVSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVSQWZ128rr_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVSQWZ256rr_VPMOVSQWZ256rrk_VPMOVSQWZ256rrkz_VPMOVSWBZ128rr_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVSWBZ256rr_VPMOVSWBZ256rrk_VPMOVSWBZ256rrkz_VPMOVUSDBZ128rr_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVUSDBZ256rr_VPMOVUSDBZ256rrk_VPMOVUSDBZ256rrkz_VPMOVUSDWZ128rr_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVUSDWZ256rr_VPMOVUSDWZ256rrk_VPMOVUSDWZ256rrkz_VPMOVUSQBZ128rr_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSQBZ256rrk_VPMOVUSQBZ256rrkz_VPMOVUSQDZ128rr_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQDZ256rr_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSWBZ128rr_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSWBZ256rr_VPMOVUSWBZ256rrk_VPMOVUSWBZ256rrkz_VPMOVWBZ128rr_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVWBZ256rr_VPMOVWBZ256rrk_VPMOVWBZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1257
  {DBGFIELD("VPMOVDBZrr_VPMOVDBZrrk_VPMOVDBZrrkz_VPMOVQBZrr_VPMOVQBZrrk_VPMOVQBZrrkz_VPMOVQWZrr_VPMOVQWZrrk_VPMOVQWZrrkz_VPMOVSDBZrr_VPMOVSDBZrrk_VPMOVSDBZrrkz_VPMOVSQBZrr_VPMOVSQBZrrk_VPMOVSQBZrrkz_VPMOVSQWZrr_VPMOVSQWZrrk_VPMOVSQWZrrkz_VPMOVUSDBZrr_VPMOVUSDBZrrk_VPMOVUSDBZrrkz_VPMOVUSQBZrr_VPMOVUSQBZrrk_VPMOVUSQBZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1258
  {DBGFIELD("VPMOVDWZrr_VPMOVDWZrrk_VPMOVDWZrrkz_VPMOVSDWZrr_VPMOVSDWZrrk_VPMOVSDWZrrkz_VPMOVSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVSWBZrr_VPMOVSWBZrrk_VPMOVSWBZrrkz_VPMOVUSDWZrr_VPMOVUSDWZrrk_VPMOVUSDWZrrkz_VPMOVUSQDZrr_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZrr_VPMOVUSWBZrrk_VPMOVUSWBZrrkz_VPMOVWBZrr_VPMOVWBZrrk_VPMOVWBZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1259
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk_VPMOVQDZ256mr_VPMOVQDZ256mrk_VPMOVQDZmr_VPMOVQDZmrk") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1260
  {DBGFIELD("VCVTDQ2PDZ128rr_VCVTDQ2PDZ128rrk_VCVTDQ2PDZ128rrkz_VCVTUDQ2PDZ128rr_VCVTUDQ2PDZ128rrk_VCVTUDQ2PDZ128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1261
  {DBGFIELD("VCVTPD2DQZ128rr_VCVTPD2DQZ128rrk_VCVTPD2DQZ128rrkz_VCVTPD2UDQZ128rr_VCVTPD2UDQZ128rrk_VCVTPD2UDQZ128rrkz_VCVTTPD2DQZ128rr_VCVTTPD2DQZ128rrk_VCVTTPD2DQZ128rrkz_VCVTTPD2UDQZ128rr_VCVTTPD2UDQZ128rrk_VCVTTPD2UDQZ128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1262
  {DBGFIELD("VCVTPS2PDZ128rr_VCVTPS2PDZ128rrk_VCVTPS2PDZ128rrkz_CVTPS2PDrr_VCVTPS2PDrr") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1263
  {DBGFIELD("VCVTPS2QQZ128rr_VCVTPS2QQZ128rrk_VCVTPS2QQZ128rrkz_VCVTPS2UQQZ128rr_VCVTPS2UQQZ128rrk_VCVTPS2UQQZ128rrkz_VCVTTPS2QQZ128rr_VCVTTPS2QQZ128rrk_VCVTTPS2QQZ128rrkz_VCVTTPS2UQQZ128rr_VCVTTPS2UQQZ128rrk_VCVTTPS2UQQZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1264
  {DBGFIELD("VCVTQQ2PSZ128rr_VCVTQQ2PSZ128rrk_VCVTQQ2PSZ128rrkz_VCVTUQQ2PSZ128rr_VCVTUQQ2PSZ128rrk_VCVTUQQ2PSZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1265
  {DBGFIELD("VCVTSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_CVTSI2SSrr_Int_VCVTSI2SSrr_VCVTSI2SSrr_Int_VCVTUSI2SSZrr_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 258, 11,  6, 1,  7, 1}, // #1266
  {DBGFIELD("VCVTSI2SDZrr_VCVTSI2SDZrr_Int_VCVTSI642SDZrr_VCVTSI642SDZrr_Int_VCVTSI642SDZrrb_Int_VCVTUSI2SDZrr_VCVTUSI2SDZrr_Int_VCVTUSI642SDZrr_VCVTUSI642SDZrr_Int_VCVTUSI642SDZrrb_Int") 2, false, false, false, 258, 11,  6, 1,  7, 1}, // #1267
  {DBGFIELD("VCVTSS2SDZrr_VCVTSS2SDZrr_Int_VCVTSS2SDZrr_Intk_VCVTSS2SDZrr_Intkz_VCVTSS2SDZrrb_Int_VCVTSS2SDZrrb_Intk_VCVTSS2SDZrrb_Intkz_CVTSS2SDrr_CVTSS2SDrr_Int_VCVTSS2SDrr_VCVTSS2SDrr_Int") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1268
  {DBGFIELD("VPCONFLICTQZ128rr_VPCONFLICTQZ128rrk_VPCONFLICTQZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1269
  {DBGFIELD("VCVTPS2PHZ128mr_VCVTPS2PHZ128mrk") 3, false, false, false, 878, 8,  2, 1,  0, 0}, // #1270
  {DBGFIELD("VCVTPS2PHZ256mr_VCVTPS2PHZ256mrk") 3, false, false, false, 878, 8,  2, 1,  0, 0}, // #1271
  {DBGFIELD("VCVTPS2PHZmr_VCVTPS2PHZmrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1272
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ128mrk_VPMOVDBZ256mr_VPMOVDBZ256mrk_VPMOVDBZmr_VPMOVDBZmrk_VPMOVDWZ128mr_VPMOVDWZ128mrk_VPMOVDWZ256mr_VPMOVDWZ256mrk_VPMOVDWZmr_VPMOVDWZmrk_VPMOVQBZ128mr_VPMOVQBZ128mrk_VPMOVQBZ256mr_VPMOVQBZ256mrk_VPMOVQBZmr_VPMOVQBZmrk_VPMOVQWZ128mr_VPMOVQWZ128mrk_VPMOVQWZ256mr_VPMOVQWZ256mrk_VPMOVQWZmr_VPMOVQWZmrk_VPMOVSDBZ128mr_VPMOVSDBZ128mrk_VPMOVSDBZ256mr_VPMOVSDBZ256mrk_VPMOVSDBZmr_VPMOVSDBZmrk_VPMOVSDWZ128mr_VPMOVSDWZ128mrk_VPMOVSDWZ256mr_VPMOVSDWZ256mrk_VPMOVSDWZmr_VPMOVSDWZmrk_VPMOVSQBZ128mr_VPMOVSQBZ128mrk_VPMOVSQBZ256mr_VPMOVSQBZ256mrk_VPMOVSQBZmr_VPMOVSQBZmrk_VPMOVSQDZ128mr_VPMOVSQDZ128mrk_VPMOVSQDZ256mr_VPMOVSQDZ256mrk_VPMOVSQDZmr_VPMOVSQDZmrk_VPMOVSQWZ128mr_VPMOVSQWZ128mrk_VPMOVSQWZ256mr_VPMOVSQWZ256mrk_VPMOVSQWZmr_VPMOVSQWZmrk_VPMOVSWBZ128mr_VPMOVSWBZ128mrk_VPMOVSWBZ256mr_VPMOVSWBZ256mrk_VPMOVSWBZmr_VPMOVSWBZmrk_VPMOVUSDBZ128mr_VPMOVUSDBZ128mrk_VPMOVUSDBZ256mr_VPMOVUSDBZ256mrk_VPMOVUSDBZmr_VPMOVUSDBZmrk_VPMOVUSDWZ128mr_VPMOVUSDWZ128mrk_VPMOVUSDWZ256mr_VPMOVUSDWZ256mrk_VPMOVUSDWZmr_VPMOVUSDWZmrk_VPMOVUSQBZ128mr_VPMOVUSQBZ128mrk_VPMOVUSQBZ256mr_VPMOVUSQBZ256mrk_VPMOVUSQBZmr_VPMOVUSQBZmrk_VPMOVUSQDZ128mr_VPMOVUSQDZ128mrk_VPMOVUSQDZ256mr_VPMOVUSQDZ256mrk_VPMOVUSQDZmr_VPMOVUSQDZmrk_VPMOVUSQWZ128mr_VPMOVUSQWZ128mrk_VPMOVUSQWZ256mr_VPMOVUSQWZ256mrk_VPMOVUSQWZmr_VPMOVUSQWZmrk_VPMOVUSWBZ128mr_VPMOVUSWBZ128mrk_VPMOVUSWBZ256mr_VPMOVUSWBZ256mrk_VPMOVUSWBZmr_VPMOVUSWBZmrk_VPMOVWBZ128mr_VPMOVWBZ128mrk_VPMOVWBZ256mr_VPMOVWBZ256mrk_VPMOVWBZmr_VPMOVWBZmrk") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1273
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPDZ128rrk_VCOMPRESSPDZ128rrkz_VCOMPRESSPSZ128rr_VCOMPRESSPSZ128rrk_VCOMPRESSPSZ128rrkz_VPCOMPRESSDZ128rr_VPCOMPRESSDZ128rrk_VPCOMPRESSDZ128rrkz_VPCOMPRESSQZ128rr_VPCOMPRESSQZ128rrk_VPCOMPRESSQZ128rrkz_VPERMWZ128rr_VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1274
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPDZ256rrk_VCOMPRESSPDZ256rrkz_VCOMPRESSPSZ256rr_VCOMPRESSPSZ256rrk_VCOMPRESSPSZ256rrkz_VPCOMPRESSDZ256rr_VPCOMPRESSDZ256rrk_VPCOMPRESSDZ256rrkz_VPCOMPRESSQZ256rr_VPCOMPRESSQZ256rrk_VPCOMPRESSQZ256rrkz_VPERMWZ256rr_VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1275
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPDZrrk_VCOMPRESSPDZrrkz_VCOMPRESSPSZrr_VCOMPRESSPSZrrk_VCOMPRESSPSZrrkz_VPCOMPRESSDZrr_VPCOMPRESSDZrrk_VPCOMPRESSDZrrkz_VPCOMPRESSQZrr_VPCOMPRESSQZrrk_VPCOMPRESSQZrrkz_VPERMWZrr_VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1276
  {DBGFIELD("VMOV64toPQIZrm_VMOVQI2PQIZrm") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1277
  {DBGFIELD("VMOVDI2PDIZrm")      1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1278
  {DBGFIELD("VCVTSI642SSZrr_VCVTSI642SSZrr_Int_VCVTSI642SSZrrb_Int_VCVTUSI642SSZrr_VCVTUSI642SSZrr_Int_VCVTUSI642SSZrrb_Int") 2, false, false, false, 258, 11,  6, 1,  7, 1}, // #1279
  {DBGFIELD("VMOVSDZrm_VMOVSDZrm_alt_VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrm_VMOVSSZrm_alt_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1280
  {DBGFIELD("VCVTDQ2PDZ256rr_VCVTDQ2PDZ256rrk_VCVTDQ2PDZ256rrkz_VCVTUDQ2PDZ256rr_VCVTUDQ2PDZ256rrk_VCVTUDQ2PDZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1281
  {DBGFIELD("VCVTPD2DQZ256rr_VCVTPD2DQZ256rrk_VCVTPD2DQZ256rrkz_VCVTPD2UDQZ256rr_VCVTPD2UDQZ256rrk_VCVTPD2UDQZ256rrkz_VCVTTPD2DQZ256rr_VCVTTPD2DQZ256rrk_VCVTTPD2DQZ256rrkz_VCVTTPD2UDQZ256rr_VCVTTPD2UDQZ256rrk_VCVTTPD2UDQZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1282
  {DBGFIELD("VCVTPS2PDYrr_VCVTPS2PDZ256rr_VCVTPS2PDZ256rrk_VCVTPS2PDZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1283
  {DBGFIELD("VCVTPS2QQZ256rr_VCVTPS2QQZ256rrk_VCVTPS2QQZ256rrkz_VCVTPS2UQQZ256rr_VCVTPS2UQQZ256rrk_VCVTPS2UQQZ256rrkz_VCVTTPS2QQZ256rr_VCVTTPS2QQZ256rrk_VCVTTPS2QQZ256rrkz_VCVTTPS2UQQZ256rr_VCVTTPS2UQQZ256rrk_VCVTTPS2UQQZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1284
  {DBGFIELD("VCVTQQ2PSZ256rr_VCVTQQ2PSZ256rrk_VCVTQQ2PSZ256rrkz_VCVTUQQ2PSZ256rr_VCVTUQQ2PSZ256rrk_VCVTUQQ2PSZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1285
  {DBGFIELD("VCVTDQ2PDZrr_VCVTUDQ2PDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1286
  {DBGFIELD("VCVTPD2DQZrr_VCVTPD2UDQZrr_VCVTTPD2DQZrr_VCVTTPD2UDQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1287
  {DBGFIELD("VCVTPS2PDZrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1288
  {DBGFIELD("VCVTPS2QQZrr_VCVTPS2UQQZrr_VCVTTPS2QQZrr_VCVTTPS2UQQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1289
  {DBGFIELD("VCVTQQ2PSZrr_VCVTUQQ2PSZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1290
  {DBGFIELD("VMOVNTDQAZ128rm")    1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1291
  {DBGFIELD("VBLENDMPDZ128rm_VBLENDMPDZ128rmb_VBLENDMPDZ128rmbk_VBLENDMPDZ128rmbkz_VBLENDMPDZ128rmk_VBLENDMPDZ128rmkz_VBLENDMPSZ128rm_VBLENDMPSZ128rmb_VBLENDMPSZ128rmbk_VBLENDMPSZ128rmbkz_VBLENDMPSZ128rmk_VBLENDMPSZ128rmkz") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #1292
  {DBGFIELD("VBROADCASTI32X2Z128rm_VBROADCASTI32X2Z128rmk_VBROADCASTI32X2Z128rmkz_VPBROADCASTDZ128rm_VPBROADCASTDZ128rmk_VPBROADCASTDZ128rmkz_VPBROADCASTQZ128rm_VPBROADCASTQZ128rmk_VPBROADCASTQZ128rmkz") 2, false, false, false, 79, 8,  7, 1,  0, 0}, // #1293
  {DBGFIELD("VBROADCASTSSZ128rm_VBROADCASTSSZ128rmk_VBROADCASTSSZ128rmkz") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1294
  {DBGFIELD("VMOVAPDZ128rm_VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rm_NOVLX_VMOVAPSZ128rm_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rm_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rm_NOVLX_VMOVUPSZ128rm_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1295
  {DBGFIELD("VMOVDDUPZ128rm_VMOVDDUPZ128rmk_VMOVDDUPZ128rmkz_VMOVSHDUPZ128rm_VMOVSHDUPZ128rmk_VMOVSHDUPZ128rmkz_VMOVSLDUPZ128rm_VMOVSLDUPZ128rmk_VMOVSLDUPZ128rmkz") 2, false, false, false, 540, 12,  7, 1,  0, 0}, // #1296
  {DBGFIELD("VMOVDQA32Z128rm_VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rm_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU16Z128rm_VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU32Z128rm_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rm_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz_VMOVDQU8Z128rm_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1297
  {DBGFIELD("VPADDBZ128rm_VPADDBZ128rmk_VPADDBZ128rmkz_VPADDDZ128rm_VPADDDZ128rmb_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rm_VPADDQZ128rmb_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPADDQZ128rmk_VPADDQZ128rmkz_VPADDWZ128rm_VPADDWZ128rmk_VPADDWZ128rmkz_VPSUBBZ128rm_VPSUBBZ128rmk_VPSUBBZ128rmkz_VPSUBDZ128rm_VPSUBDZ128rmb_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rm_VPSUBQZ128rmb_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPSUBWZ128rm_VPSUBWZ128rmk_VPSUBWZ128rmkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmik_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmik_VPTERNLOGQZ128rmikz") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #1298
  {DBGFIELD("VPBLENDMBZ128rm_VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMDZ128rm_VPBLENDMDZ128rmb_VPBLENDMDZ128rmbk_VPBLENDMDZ128rmbkz_VPBLENDMDZ128rmk_VPBLENDMDZ128rmkz_VPBLENDMQZ128rm_VPBLENDMQZ128rmb_VPBLENDMQZ128rmbk_VPBLENDMQZ128rmbkz_VPBLENDMQZ128rmk_VPBLENDMQZ128rmkz_VPBLENDMWZ128rm_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #1299
  {DBGFIELD("VPERMI2WZ128rr_VPERMI2WZ128rrk_VPERMI2WZ128rrkz_VPERMT2WZ128rr_VPERMT2WZ128rrk_VPERMT2WZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1300
  {DBGFIELD("VPERMI2WZ256rr_VPERMI2WZ256rrk_VPERMI2WZ256rrkz_VPERMT2WZ256rr_VPERMT2WZ256rrk_VPERMT2WZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1301
  {DBGFIELD("VPERMI2WZrr_VPERMI2WZrrk_VPERMI2WZrrkz_VPERMT2WZrr_VPERMT2WZrrk_VPERMT2WZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1302
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTTSS2SI64Zrr_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2USI64Zrr_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #1303
  {DBGFIELD("KMOVBkm_KMOVBkm_EVEX_KMOVDkm_KMOVDkm_EVEX_KMOVQkm_KMOVQkm_EVEX_KMOVWkm_KMOVWkm_EVEX") 1, false, false, false, 56, 3, 10, 1,  0, 0}, // #1304
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ128mrk_VCOMPRESSPDZ256mr_VCOMPRESSPDZ256mrk_VCOMPRESSPDZmr_VCOMPRESSPDZmrk_VCOMPRESSPSZ128mr_VCOMPRESSPSZ128mrk_VCOMPRESSPSZ256mr_VCOMPRESSPSZ256mrk_VCOMPRESSPSZmr_VCOMPRESSPSZmrk_VPCOMPRESSDZ128mr_VPCOMPRESSDZ128mrk_VPCOMPRESSDZ256mr_VPCOMPRESSDZ256mrk_VPCOMPRESSDZmr_VPCOMPRESSDZmrk_VPCOMPRESSQZ128mr_VPCOMPRESSQZ128mrk_VPCOMPRESSQZ256mr_VPCOMPRESSQZ256mrk_VPCOMPRESSQZmr_VPCOMPRESSQZmrk") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1305
  {DBGFIELD("VPSCATTERDQZ128mr_VPSCATTERQQZ128mr_VSCATTERDPDZ128mr_VSCATTERQPDZ128mr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1306
  {DBGFIELD("VPSCATTERDQZ256mr_VPSCATTERQQZ256mr_VSCATTERDPDZ256mr_VSCATTERQPDZ256mr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1307
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQDZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPSZmr_VSCATTERQPDZmr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1308
  {DBGFIELD("VSCATTERDPSZmr")     2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1309
  {DBGFIELD("VPBROADCASTBZ256rm_VPBROADCASTBZ256rmk_VPBROADCASTBZ256rmkz_VPBROADCASTBZrm_VPBROADCASTBZrmk_VPBROADCASTBZrmkz_VPBROADCASTWZ256rm_VPBROADCASTWZ256rmk_VPBROADCASTWZ256rmkz_VPBROADCASTWZrm_VPBROADCASTWZrmk_VPBROADCASTWZrmkz") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1310
  {DBGFIELD("VMOVNTDQAZ256rm")    1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1311
  {DBGFIELD("VBLENDMPDZ256rm_VBLENDMPDZ256rmb_VBLENDMPDZ256rmbk_VBLENDMPDZ256rmbkz_VBLENDMPDZ256rmk_VBLENDMPDZ256rmkz_VBLENDMPSZ256rm_VBLENDMPSZ256rmb_VBLENDMPSZ256rmbk_VBLENDMPSZ256rmbkz_VBLENDMPSZ256rmk_VBLENDMPSZ256rmkz") 4, false, false, false, 868, 6,  9, 1,  6, 1}, // #1312
  {DBGFIELD("VBLENDMPDZrm_VBLENDMPDZrmb_VBLENDMPDZrmbk_VBLENDMPDZrmbkz_VBLENDMPDZrmk_VBLENDMPDZrmkz_VBLENDMPSZrm_VBLENDMPSZrmb_VBLENDMPSZrmbk_VBLENDMPSZrmbkz_VBLENDMPSZrmk_VBLENDMPSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1313
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTF32X2Z256rmk_VBROADCASTF32X2Z256rmkz_VBROADCASTF32X2Zrm_VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Z256rm_VBROADCASTI32X2Z256rmk_VBROADCASTI32X2Z256rmkz_VBROADCASTI32X2Zrm_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZ256rm_VPBROADCASTDZ256rmk_VPBROADCASTDZ256rmkz_VPBROADCASTDZrm_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZ256rm_VPBROADCASTQZ256rmk_VPBROADCASTQZ256rmkz_VPBROADCASTQZrm_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1314
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTF32X4Z256rmk_VBROADCASTF32X4Z256rmkz_VBROADCASTF32X4rm_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF32X8rm_VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTF64X2Z128rm_VBROADCASTF64X2Z128rmk_VBROADCASTF64X2Z128rmkz_VBROADCASTF64X2rm_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTF64X4rm_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4Z256rm_VBROADCASTI32X4Z256rmk_VBROADCASTI32X4Z256rmkz_VBROADCASTI32X4rm_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI32X8rm_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTI64X2Z128rm_VBROADCASTI64X2Z128rmk_VBROADCASTI64X2Z128rmkz_VBROADCASTI64X2rm_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz_VBROADCASTI64X4rm_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz") 2, false, false, false, 79, 8, 22, 1,  0, 0}, // #1315
  {DBGFIELD("VBROADCASTSDZ256rm_VBROADCASTSDZ256rmk_VBROADCASTSDZ256rmkz_VBROADCASTSDZrm_VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZ256rm_VBROADCASTSSZ256rmk_VBROADCASTSSZ256rmkz_VBROADCASTSSZrm_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1316
  {DBGFIELD("VINSERTF32x4Z256rm_VINSERTF32x4Z256rmk_VINSERTF32x4Z256rmkz_VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Z256rm_VINSERTF64x2Z256rmk_VINSERTF64x2Z256rmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1317
  {DBGFIELD("VINSERTI32x4Z256rm_VINSERTI32x4Z256rmk_VINSERTI32x4Z256rmkz_VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Z256rm_VINSERTI64x2Z256rmk_VINSERTI64x2Z256rmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1318
  {DBGFIELD("VMOVAPDZ256rm_VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPDZrm_VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZ256rm_NOVLX_VMOVAPSZ256rm_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVAPSZrm_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZ256rm_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPDZrm_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZ256rm_NOVLX_VMOVUPSZ256rm_VMOVUPSZ256rmk_VMOVUPSZ256rmkz_VMOVUPSZrm_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1319
  {DBGFIELD("VMOVDDUPZ256rm_VMOVDDUPZ256rmk_VMOVDDUPZ256rmkz_VMOVSHDUPZ256rm_VMOVSHDUPZ256rmk_VMOVSHDUPZ256rmkz_VMOVSLDUPZ256rm_VMOVSLDUPZ256rmk_VMOVSLDUPZ256rmkz") 2, false, false, false, 540, 12, 22, 1,  0, 0}, // #1320
  {DBGFIELD("VMOVDDUPZrm_VMOVDDUPZrmk_VMOVDDUPZrmkz_VMOVSHDUPZrm_VMOVSHDUPZrmk_VMOVSHDUPZrmkz_VMOVSLDUPZrm_VMOVSLDUPZrmk_VMOVSLDUPZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1321
  {DBGFIELD("VMOVDQA32Z256rm_VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA32Zrm_VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Z256rm_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQA64Zrm_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU16Z256rm_VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU16Zrm_VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU32Z256rm_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU32Zrm_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Z256rm_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz_VMOVDQU64Zrm_VMOVDQU64Zrmk_VMOVDQU64Zrmkz_VMOVDQU8Z256rm_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz_VMOVDQU8Zrm_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1322
  {DBGFIELD("VPADDBZ256rm_VPADDBZ256rmk_VPADDBZ256rmkz_VPADDDZ256rm_VPADDDZ256rmb_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rm_VPADDQZ256rmb_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPADDQZ256rmk_VPADDQZ256rmkz_VPADDWZ256rm_VPADDWZ256rmk_VPADDWZ256rmkz_VPSUBBZ256rm_VPSUBBZ256rmk_VPSUBBZ256rmkz_VPSUBDZ256rm_VPSUBDZ256rmb_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rm_VPSUBQZ256rmb_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPSUBWZ256rm_VPSUBWZ256rmk_VPSUBWZ256rmkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmik_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmik_VPTERNLOGQZ256rmikz") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #1323
  {DBGFIELD("VPADDBZrm_VPADDBZrmk_VPADDBZrmkz_VPADDDZrm_VPADDDZrmb_VPADDDZrmbk_VPADDDZrmbkz_VPADDDZrmk_VPADDDZrmkz_VPADDQZrm_VPADDQZrmb_VPADDQZrmbk_VPADDQZrmbkz_VPADDQZrmk_VPADDQZrmkz_VPADDWZrm_VPADDWZrmk_VPADDWZrmkz_VPSUBBZrm_VPSUBBZrmk_VPSUBBZrmkz_VPSUBDZrm_VPSUBDZrmb_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrm_VPSUBQZrmb_VPSUBQZrmbk_VPSUBQZrmbkz_VPSUBQZrmk_VPSUBQZrmkz_VPSUBWZrm_VPSUBWZrmk_VPSUBWZrmkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmik_VPTERNLOGDZrmikz_VPTERNLOGQZrmbi_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGQZrmi_VPTERNLOGQZrmik_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1324
  {DBGFIELD("VPBLENDMBZ256rm_VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMDZ256rm_VPBLENDMDZ256rmb_VPBLENDMDZ256rmbk_VPBLENDMDZ256rmbkz_VPBLENDMDZ256rmk_VPBLENDMDZ256rmkz_VPBLENDMQZ256rm_VPBLENDMQZ256rmb_VPBLENDMQZ256rmbk_VPBLENDMQZ256rmbkz_VPBLENDMQZ256rmk_VPBLENDMQZ256rmkz_VPBLENDMWZ256rm_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 4, false, false, false, 868, 6,  9, 1,  6, 1}, // #1325
  {DBGFIELD("VPBLENDMBZrm_VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMDZrm_VPBLENDMDZrmb_VPBLENDMDZrmbk_VPBLENDMDZrmbkz_VPBLENDMDZrmk_VPBLENDMDZrmkz_VPBLENDMQZrm_VPBLENDMQZrmb_VPBLENDMQZrmbk_VPBLENDMQZrmbkz_VPBLENDMQZrmk_VPBLENDMQZrmkz_VPBLENDMWZrm_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1326
  {DBGFIELD("VPSCATTERQDZ128mr_VPSCATTERQDZ256mr_VSCATTERQPSZ128mr_VSCATTERQPSZ256mr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1327
  {DBGFIELD("VPSCATTERDDZ128mr_VSCATTERDPSZ128mr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1328
  {DBGFIELD("VPSCATTERDDZ256mr_VSCATTERDPSZ256mr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1329
  {DBGFIELD("VPSCATTERDDZmr")     2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1330
  {DBGFIELD("VALIGNDZ128rmbi_VALIGNDZ128rmbik_VALIGNDZ128rmbikz_VALIGNDZ128rmi_VALIGNDZ128rmik_VALIGNDZ128rmikz_VALIGNQZ128rmbi_VALIGNQZ128rmbik_VALIGNQZ128rmbikz_VALIGNQZ128rmi_VALIGNQZ128rmik_VALIGNQZ128rmikz") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #1331
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSDZrmk_VFPCLASSSSZrm_VFPCLASSSSZrmk") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1332
  {DBGFIELD("VPERMI2DZ128rm_VPERMI2DZ128rmb_VPERMI2DZ128rmbk_VPERMI2DZ128rmbkz_VPERMI2DZ128rmk_VPERMI2DZ128rmkz_VPERMI2QZ128rm_VPERMI2QZ128rmb_VPERMI2QZ128rmbk_VPERMI2QZ128rmbkz_VPERMI2QZ128rmk_VPERMI2QZ128rmkz_VPERMT2DZ128rm_VPERMT2DZ128rmb_VPERMT2DZ128rmbk_VPERMT2DZ128rmbkz_VPERMT2DZ128rmk_VPERMT2DZ128rmkz_VPERMT2QZ128rm_VPERMT2QZ128rmb_VPERMT2QZ128rmbk_VPERMT2QZ128rmbkz_VPERMT2QZ128rmk_VPERMT2QZ128rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1333
  {DBGFIELD("VPERMI2PDZ128rm_VPERMI2PDZ128rmb_VPERMI2PDZ128rmbk_VPERMI2PDZ128rmbkz_VPERMI2PDZ128rmk_VPERMI2PDZ128rmkz_VPERMI2PSZ128rm_VPERMI2PSZ128rmb_VPERMI2PSZ128rmbk_VPERMI2PSZ128rmbkz_VPERMI2PSZ128rmk_VPERMI2PSZ128rmkz_VPERMT2PDZ128rm_VPERMT2PDZ128rmb_VPERMT2PDZ128rmbk_VPERMT2PDZ128rmbkz_VPERMT2PDZ128rmk_VPERMT2PDZ128rmkz_VPERMT2PSZ128rm_VPERMT2PSZ128rmb_VPERMT2PSZ128rmbk_VPERMT2PSZ128rmbkz_VPERMT2PSZ128rmk_VPERMT2PSZ128rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1334
  {DBGFIELD("VPMAXSQZ128rm_VPMAXSQZ128rmb_VPMAXSQZ128rmbk_VPMAXSQZ128rmbkz_VPMAXSQZ128rmk_VPMAXSQZ128rmkz_VPMAXUQZ128rm_VPMAXUQZ128rmb_VPMAXUQZ128rmbk_VPMAXUQZ128rmbkz_VPMAXUQZ128rmk_VPMAXUQZ128rmkz_VPMINSQZ128rm_VPMINSQZ128rmb_VPMINSQZ128rmbk_VPMINSQZ128rmbkz_VPMINSQZ128rmk_VPMINSQZ128rmkz_VPMINUQZ128rm_VPMINUQZ128rmb_VPMINUQZ128rmbk_VPMINUQZ128rmbkz_VPMINUQZ128rmk_VPMINUQZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #1335
  {DBGFIELD("VCMPPDZ128rmbi_VCMPPDZ128rmbik_VCMPPDZ128rmi_VCMPPDZ128rmik_VCMPPSZ128rmbi_VCMPPSZ128rmbik_VCMPPSZ128rmi_VCMPPSZ128rmik_VFPCLASSPDZ128rm_VFPCLASSPDZ128rmb_VFPCLASSPDZ128rmbk_VFPCLASSPDZ128rmk_VFPCLASSPSZ128rm_VFPCLASSPSZ128rmb_VFPCLASSPSZ128rmbk_VFPCLASSPSZ128rmk") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1336
  {DBGFIELD("VCMPSDZrmi_VCMPSDZrmi_Int_VCMPSDZrmi_Intk_VCMPSSZrmi_VCMPSSZrmi_Int_VCMPSSZrmi_Intk") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1337
  {DBGFIELD("VPCMPBZ128rmi_VPCMPBZ128rmik_VPCMPDZ128rmi_VPCMPDZ128rmib_VPCMPDZ128rmibk_VPCMPDZ128rmik_VPCMPEQBZ128rm_VPCMPEQBZ128rmk_VPCMPEQDZ128rm_VPCMPEQDZ128rmb_VPCMPEQDZ128rmbk_VPCMPEQDZ128rmk_VPCMPEQQZ128rm_VPCMPEQQZ128rmb_VPCMPEQQZ128rmbk_VPCMPEQQZ128rmk_VPCMPEQWZ128rm_VPCMPEQWZ128rmk_VPCMPGTBZ128rm_VPCMPGTBZ128rmk_VPCMPGTDZ128rm_VPCMPGTDZ128rmb_VPCMPGTDZ128rmbk_VPCMPGTDZ128rmk_VPCMPGTQZ128rm_VPCMPGTQZ128rmb_VPCMPGTQZ128rmbk_VPCMPGTQZ128rmk_VPCMPGTWZ128rm_VPCMPGTWZ128rmk_VPCMPQZ128rmi_VPCMPQZ128rmib_VPCMPQZ128rmibk_VPCMPQZ128rmik_VPCMPUBZ128rmi_VPCMPUBZ128rmik_VPCMPUDZ128rmi_VPCMPUDZ128rmib_VPCMPUDZ128rmibk_VPCMPUDZ128rmik_VPCMPUQZ128rmi_VPCMPUQZ128rmib_VPCMPUQZ128rmibk_VPCMPUQZ128rmik_VPCMPUWZ128rmi_VPCMPUWZ128rmik_VPCMPWZ128rmi_VPCMPWZ128rmik") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #1338
  {DBGFIELD("VPTESTMBZ128rm_VPTESTMBZ128rmk_VPTESTMDZ128rm_VPTESTMDZ128rmb_VPTESTMDZ128rmbk_VPTESTMDZ128rmk_VPTESTMQZ128rm_VPTESTMQZ128rmb_VPTESTMQZ128rmbk_VPTESTMQZ128rmk_VPTESTMWZ128rm_VPTESTMWZ128rmk_VPTESTNMBZ128rm_VPTESTNMBZ128rmk_VPTESTNMDZ128rm_VPTESTNMDZ128rmb_VPTESTNMDZ128rmbk_VPTESTNMDZ128rmk_VPTESTNMQZ128rm_VPTESTNMQZ128rmb_VPTESTNMQZ128rmbk_VPTESTNMQZ128rmk_VPTESTNMWZ128rm_VPTESTNMWZ128rmk") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #1339
  {DBGFIELD("CVTPS2PDrm_VCVTPS2PDrm") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1340
  {DBGFIELD("VALIGNDZ256rmbi_VALIGNDZ256rmbik_VALIGNDZ256rmbikz_VALIGNDZ256rmi_VALIGNDZ256rmik_VALIGNDZ256rmikz_VALIGNQZ256rmbi_VALIGNQZ256rmbik_VALIGNQZ256rmbikz_VALIGNQZ256rmi_VALIGNQZ256rmik_VALIGNQZ256rmikz") 2, false, false, false, 79, 8, 22, 1,  6, 1}, // #1341
  {DBGFIELD("VALIGNDZrmbi_VALIGNDZrmbik_VALIGNDZrmbikz_VALIGNDZrmi_VALIGNDZrmik_VALIGNDZrmikz_VALIGNQZrmbi_VALIGNQZrmbik_VALIGNQZrmbikz_VALIGNQZrmi_VALIGNQZrmik_VALIGNQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1342
  {DBGFIELD("VPMAXSQZ256rm_VPMAXSQZ256rmb_VPMAXSQZ256rmbk_VPMAXSQZ256rmbkz_VPMAXSQZ256rmk_VPMAXSQZ256rmkz_VPMAXUQZ256rm_VPMAXUQZ256rmb_VPMAXUQZ256rmbk_VPMAXUQZ256rmbkz_VPMAXUQZ256rmk_VPMAXUQZ256rmkz_VPMINSQZ256rm_VPMINSQZ256rmb_VPMINSQZ256rmbk_VPMINSQZ256rmbkz_VPMINSQZ256rmk_VPMINSQZ256rmkz_VPMINUQZ256rm_VPMINUQZ256rmb_VPMINUQZ256rmbk_VPMINUQZ256rmbkz_VPMINUQZ256rmk_VPMINUQZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #1343
  {DBGFIELD("VPMAXSQZrm_VPMAXSQZrmb_VPMAXSQZrmbk_VPMAXSQZrmbkz_VPMAXSQZrmk_VPMAXSQZrmkz_VPMAXUQZrm_VPMAXUQZrmb_VPMAXUQZrmbk_VPMAXUQZrmbkz_VPMAXUQZrmk_VPMAXUQZrmkz_VPMINSQZrm_VPMINSQZrmb_VPMINSQZrmbk_VPMINSQZrmbkz_VPMINSQZrmk_VPMINSQZrmkz_VPMINUQZrm_VPMINUQZrmb_VPMINUQZrmbk_VPMINUQZrmbkz_VPMINUQZrmk_VPMINUQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1344
  {DBGFIELD("VCMPPDZ256rmbi_VCMPPDZ256rmbik_VCMPPDZ256rmi_VCMPPDZ256rmik_VCMPPSZ256rmbi_VCMPPSZ256rmbik_VCMPPSZ256rmi_VCMPPSZ256rmik_VFPCLASSPDZ256rm_VFPCLASSPDZ256rmb_VFPCLASSPDZ256rmbk_VFPCLASSPDZ256rmk_VFPCLASSPSZ256rm_VFPCLASSPSZ256rmb_VFPCLASSPSZ256rmbk_VFPCLASSPSZ256rmk") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1345
  {DBGFIELD("VCMPPDZrmbi_VCMPPDZrmbik_VCMPPDZrmi_VCMPPDZrmik_VCMPPSZrmbi_VCMPPSZrmbik_VCMPPSZrmi_VCMPPSZrmik_VFPCLASSPDZrm_VFPCLASSPDZrmb_VFPCLASSPDZrmbk_VFPCLASSPDZrmk_VFPCLASSPSZrm_VFPCLASSPSZrmb_VFPCLASSPSZrmbk_VFPCLASSPSZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1346
  {DBGFIELD("VPCMPBZ256rmi_VPCMPBZ256rmik_VPCMPDZ256rmi_VPCMPDZ256rmib_VPCMPDZ256rmibk_VPCMPDZ256rmik_VPCMPEQBZ256rm_VPCMPEQBZ256rmk_VPCMPEQDZ256rm_VPCMPEQDZ256rmb_VPCMPEQDZ256rmbk_VPCMPEQDZ256rmk_VPCMPEQQZ256rm_VPCMPEQQZ256rmb_VPCMPEQQZ256rmbk_VPCMPEQQZ256rmk_VPCMPEQWZ256rm_VPCMPEQWZ256rmk_VPCMPGTBZ256rm_VPCMPGTBZ256rmk_VPCMPGTDZ256rm_VPCMPGTDZ256rmb_VPCMPGTDZ256rmbk_VPCMPGTDZ256rmk_VPCMPGTQZ256rm_VPCMPGTQZ256rmb_VPCMPGTQZ256rmbk_VPCMPGTQZ256rmk_VPCMPGTWZ256rm_VPCMPGTWZ256rmk_VPCMPQZ256rmi_VPCMPQZ256rmib_VPCMPQZ256rmibk_VPCMPQZ256rmik_VPCMPUBZ256rmi_VPCMPUBZ256rmik_VPCMPUDZ256rmi_VPCMPUDZ256rmib_VPCMPUDZ256rmibk_VPCMPUDZ256rmik_VPCMPUQZ256rmi_VPCMPUQZ256rmib_VPCMPUQZ256rmibk_VPCMPUQZ256rmik_VPCMPUWZ256rmi_VPCMPUWZ256rmik_VPCMPWZ256rmi_VPCMPWZ256rmik") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #1347
  {DBGFIELD("VPCMPBZrmi_VPCMPBZrmik_VPCMPDZrmi_VPCMPDZrmib_VPCMPDZrmibk_VPCMPDZrmik_VPCMPEQBZrm_VPCMPEQBZrmk_VPCMPEQDZrm_VPCMPEQDZrmb_VPCMPEQDZrmbk_VPCMPEQDZrmk_VPCMPEQQZrm_VPCMPEQQZrmb_VPCMPEQQZrmbk_VPCMPEQQZrmk_VPCMPEQWZrm_VPCMPEQWZrmk_VPCMPGTBZrm_VPCMPGTBZrmk_VPCMPGTDZrm_VPCMPGTDZrmb_VPCMPGTDZrmbk_VPCMPGTDZrmk_VPCMPGTQZrm_VPCMPGTQZrmb_VPCMPGTQZrmbk_VPCMPGTQZrmk_VPCMPGTWZrm_VPCMPGTWZrmk_VPCMPQZrmi_VPCMPQZrmib_VPCMPQZrmibk_VPCMPQZrmik_VPCMPUBZrmi_VPCMPUBZrmik_VPCMPUDZrmi_VPCMPUDZrmib_VPCMPUDZrmibk_VPCMPUDZrmik_VPCMPUQZrmi_VPCMPUQZrmib_VPCMPUQZrmibk_VPCMPUQZrmik_VPCMPUWZrmi_VPCMPUWZrmik_VPCMPWZrmi_VPCMPWZrmik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1348
  {DBGFIELD("VPTESTMBZ256rm_VPTESTMBZ256rmk_VPTESTMDZ256rm_VPTESTMDZ256rmb_VPTESTMDZ256rmbk_VPTESTMDZ256rmk_VPTESTMQZ256rm_VPTESTMQZ256rmb_VPTESTMQZ256rmbk_VPTESTMQZ256rmk_VPTESTMWZ256rm_VPTESTMWZ256rmk_VPTESTNMBZ256rm_VPTESTNMBZ256rmk_VPTESTNMDZ256rm_VPTESTNMDZ256rmb_VPTESTNMDZ256rmbk_VPTESTNMDZ256rmk_VPTESTNMQZ256rm_VPTESTNMQZ256rmb_VPTESTNMQZ256rmbk_VPTESTNMQZ256rmk_VPTESTNMWZ256rm_VPTESTNMWZ256rmk") 2, false, false, false, 104, 6, 22, 1,  6, 1}, // #1349
  {DBGFIELD("VPTESTMBZrm_VPTESTMBZrmk_VPTESTMDZrm_VPTESTMDZrmb_VPTESTMDZrmbk_VPTESTMDZrmk_VPTESTMQZrm_VPTESTMQZrmb_VPTESTMQZrmbk_VPTESTMQZrmk_VPTESTMWZrm_VPTESTMWZrmk_VPTESTNMBZrm_VPTESTNMBZrmk_VPTESTNMDZrm_VPTESTNMDZrmb_VPTESTNMDZrmbk_VPTESTNMDZrmk_VPTESTNMQZrm_VPTESTNMQZrmb_VPTESTNMQZrmbk_VPTESTNMQZrmk_VPTESTNMWZrm_VPTESTNMWZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1350
  {DBGFIELD("VCVTDQ2PDZ128rm_VCVTDQ2PDZ128rmb_VCVTDQ2PDZ128rmbk_VCVTDQ2PDZ128rmbkz_VCVTDQ2PDZ128rmk_VCVTDQ2PDZ128rmkz_VCVTQQ2PDZ128rm_VCVTQQ2PDZ128rmb_VCVTQQ2PDZ128rmbk_VCVTQQ2PDZ128rmbkz_VCVTQQ2PDZ128rmk_VCVTQQ2PDZ128rmkz_VCVTUDQ2PDZ128rm_VCVTUDQ2PDZ128rmb_VCVTUDQ2PDZ128rmbk_VCVTUDQ2PDZ128rmbkz_VCVTUDQ2PDZ128rmk_VCVTUDQ2PDZ128rmkz_VCVTUQQ2PDZ128rm_VCVTUQQ2PDZ128rmb_VCVTUQQ2PDZ128rmbk_VCVTUQQ2PDZ128rmbkz_VCVTUQQ2PDZ128rmk_VCVTUQQ2PDZ128rmkz") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1351
  {DBGFIELD("VCVTDQ2PSZ128rm_VCVTDQ2PSZ128rmb_VCVTDQ2PSZ128rmbk_VCVTDQ2PSZ128rmbkz_VCVTDQ2PSZ128rmk_VCVTDQ2PSZ128rmkz_CVTDQ2PSrm_VCVTDQ2PSrm_VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmbkz_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUDQ2PSZ128rm_VCVTUDQ2PSZ128rmb_VCVTUDQ2PSZ128rmbk_VCVTUDQ2PSZ128rmbkz_VCVTUDQ2PSZ128rmk_VCVTUDQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1352
  {DBGFIELD("VCVTPD2QQZ128rm_VCVTPD2QQZ128rmb_VCVTPD2QQZ128rmbk_VCVTPD2QQZ128rmbkz_VCVTPD2QQZ128rmk_VCVTPD2QQZ128rmkz_VCVTPD2UQQZ128rm_VCVTPD2UQQZ128rmb_VCVTPD2UQQZ128rmbk_VCVTPD2UQQZ128rmbkz_VCVTPD2UQQZ128rmk_VCVTPD2UQQZ128rmkz_VCVTTPD2QQZ128rm_VCVTTPD2QQZ128rmb_VCVTTPD2QQZ128rmbk_VCVTTPD2QQZ128rmbkz_VCVTTPD2QQZ128rmk_VCVTTPD2QQZ128rmkz_VCVTTPD2UQQZ128rm_VCVTTPD2UQQZ128rmb_VCVTTPD2UQQZ128rmbk_VCVTTPD2UQQZ128rmbkz_VCVTTPD2UQQZ128rmk_VCVTTPD2UQQZ128rmkz") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #1353
  {DBGFIELD("VCVTPH2PSZ128rm_VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1354
  {DBGFIELD("VCVTPS2DQZ128rm_VCVTPS2DQZ128rmb_VCVTPS2DQZ128rmbk_VCVTPS2DQZ128rmbkz_VCVTPS2DQZ128rmk_VCVTPS2DQZ128rmkz_CVTPS2DQrm_VCVTPS2DQrm_VCVTPS2QQZ128rm_VCVTPS2QQZ128rmb_VCVTPS2QQZ128rmbk_VCVTPS2QQZ128rmbkz_VCVTPS2QQZ128rmk_VCVTPS2QQZ128rmkz_VCVTPS2UDQZ128rm_VCVTPS2UDQZ128rmb_VCVTPS2UDQZ128rmbk_VCVTPS2UDQZ128rmbkz_VCVTPS2UDQZ128rmk_VCVTPS2UDQZ128rmkz_VCVTPS2UQQZ128rm_VCVTPS2UQQZ128rmb_VCVTPS2UQQZ128rmbk_VCVTPS2UQQZ128rmbkz_VCVTPS2UQQZ128rmk_VCVTPS2UQQZ128rmkz_VCVTTPS2DQZ128rm_VCVTTPS2DQZ128rmb_VCVTTPS2DQZ128rmbk_VCVTTPS2DQZ128rmbkz_VCVTTPS2DQZ128rmk_VCVTTPS2DQZ128rmkz_CVTTPS2DQrm_VCVTTPS2DQrm_VCVTTPS2QQZ128rm_VCVTTPS2QQZ128rmb_VCVTTPS2QQZ128rmbk_VCVTTPS2QQZ128rmbkz_VCVTTPS2QQZ128rmk_VCVTTPS2QQZ128rmkz_VCVTTPS2UDQZ128rm_VCVTTPS2UDQZ128rmb_VCVTTPS2UDQZ128rmbk_VCVTTPS2UDQZ128rmbkz_VCVTTPS2UDQZ128rmk_VCVTTPS2UDQZ128rmkz_VCVTTPS2UQQZ128rm_VCVTTPS2UQQZ128rmb_VCVTTPS2UQQZ128rmbk_VCVTTPS2UQQZ128rmbkz_VCVTTPS2UQQZ128rmk_VCVTTPS2UQQZ128rmkz") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1355
  {DBGFIELD("VCVTPS2PDZ128rm_VCVTPS2PDZ128rmb_VCVTPS2PDZ128rmbk_VCVTPS2PDZ128rmbkz_VCVTPS2PDZ128rmk_VCVTPS2PDZ128rmkz") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1356
  {DBGFIELD("VCVTSS2SDZrm_VCVTSS2SDZrm_Int_VCVTSS2SDZrm_Intk_VCVTSS2SDZrm_Intkz_CVTSS2SDrm_CVTSS2SDrm_Int_VCVTSS2SDrm_VCVTSS2SDrm_Int") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1357
  {DBGFIELD("VEXPANDPDZ128rm_VEXPANDPDZ128rmk_VEXPANDPDZ128rmkz_VEXPANDPSZ128rm_VEXPANDPSZ128rmk_VEXPANDPSZ128rmkz_VPEXPANDDZ128rm_VPEXPANDDZ128rmk_VPEXPANDDZ128rmkz_VPEXPANDQZ128rm_VPEXPANDQZ128rmk_VPEXPANDQZ128rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1358
  {DBGFIELD("VCVTDQ2PSYrm")       2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1359
  {DBGFIELD("VCVTPS2PDYrm")       2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1360
  {DBGFIELD("VCVTDQ2PDZ256rm_VCVTDQ2PDZ256rmb_VCVTDQ2PDZ256rmbk_VCVTDQ2PDZ256rmbkz_VCVTDQ2PDZ256rmk_VCVTDQ2PDZ256rmkz_VCVTQQ2PDZ256rm_VCVTQQ2PDZ256rmb_VCVTQQ2PDZ256rmbk_VCVTQQ2PDZ256rmbkz_VCVTQQ2PDZ256rmk_VCVTQQ2PDZ256rmkz_VCVTUDQ2PDZ256rm_VCVTUDQ2PDZ256rmb_VCVTUDQ2PDZ256rmbk_VCVTUDQ2PDZ256rmbkz_VCVTUDQ2PDZ256rmk_VCVTUDQ2PDZ256rmkz_VCVTUQQ2PDZ256rm_VCVTUQQ2PDZ256rmb_VCVTUQQ2PDZ256rmbk_VCVTUQQ2PDZ256rmbkz_VCVTUQQ2PDZ256rmk_VCVTUQQ2PDZ256rmkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1361
  {DBGFIELD("VCVTDQ2PDZrm_VCVTDQ2PDZrmb_VCVTDQ2PDZrmbk_VCVTDQ2PDZrmbkz_VCVTDQ2PDZrmk_VCVTDQ2PDZrmkz_VCVTQQ2PDZrm_VCVTQQ2PDZrmb_VCVTQQ2PDZrmbk_VCVTQQ2PDZrmbkz_VCVTQQ2PDZrmk_VCVTQQ2PDZrmkz_VCVTUDQ2PDZrm_VCVTUDQ2PDZrmb_VCVTUDQ2PDZrmbk_VCVTUDQ2PDZrmbkz_VCVTUDQ2PDZrmk_VCVTUDQ2PDZrmkz_VCVTUQQ2PDZrm_VCVTUQQ2PDZrmb_VCVTUQQ2PDZrmbk_VCVTUQQ2PDZrmbkz_VCVTUQQ2PDZrmk_VCVTUQQ2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1362
  {DBGFIELD("VCVTDQ2PSZ256rm_VCVTDQ2PSZ256rmb_VCVTDQ2PSZ256rmbk_VCVTDQ2PSZ256rmbkz_VCVTDQ2PSZ256rmk_VCVTDQ2PSZ256rmkz_VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmbkz_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUDQ2PSZ256rm_VCVTUDQ2PSZ256rmb_VCVTUDQ2PSZ256rmbk_VCVTUDQ2PSZ256rmbkz_VCVTUDQ2PSZ256rmk_VCVTUDQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1363
  {DBGFIELD("VCVTDQ2PSZrm_VCVTDQ2PSZrmb_VCVTDQ2PSZrmbk_VCVTDQ2PSZrmbkz_VCVTDQ2PSZrmk_VCVTDQ2PSZrmkz_VCVTUDQ2PSZrm_VCVTUDQ2PSZrmb_VCVTUDQ2PSZrmbk_VCVTUDQ2PSZrmbkz_VCVTUDQ2PSZrmk_VCVTUDQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1364
  {DBGFIELD("VCVTPH2PSZ256rm_VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1365
  {DBGFIELD("VCVTPH2PSZrm_VCVTPH2PSZrmk_VCVTPH2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1366
  {DBGFIELD("VCVTPS2PDZ256rm_VCVTPS2PDZ256rmb_VCVTPS2PDZ256rmbk_VCVTPS2PDZ256rmbkz_VCVTPS2PDZ256rmk_VCVTPS2PDZ256rmkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1367
  {DBGFIELD("VCVTPS2PDZrm_VCVTPS2PDZrmb_VCVTPS2PDZrmbk_VCVTPS2PDZrmbkz_VCVTPS2PDZrmk_VCVTPS2PDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1368
  {DBGFIELD("VCVTPD2QQZ256rm_VCVTPD2QQZ256rmb_VCVTPD2QQZ256rmbk_VCVTPD2QQZ256rmbkz_VCVTPD2QQZ256rmk_VCVTPD2QQZ256rmkz_VCVTTPD2QQZ256rm_VCVTTPD2QQZ256rmb_VCVTTPD2QQZ256rmbk_VCVTTPD2QQZ256rmbkz_VCVTTPD2QQZ256rmk_VCVTTPD2QQZ256rmkz_VCVTPD2UQQZ256rm_VCVTPD2UQQZ256rmb_VCVTPD2UQQZ256rmbk_VCVTPD2UQQZ256rmbkz_VCVTPD2UQQZ256rmk_VCVTPD2UQQZ256rmkz_VCVTTPD2UQQZ256rm_VCVTTPD2UQQZ256rmb_VCVTTPD2UQQZ256rmbk_VCVTTPD2UQQZ256rmbkz_VCVTTPD2UQQZ256rmk_VCVTTPD2UQQZ256rmkz") 3, false, false, false, 269, 13, 11, 1,  0, 0}, // #1369
  {DBGFIELD("VCVTPD2QQZrm_VCVTPD2QQZrmb_VCVTPD2QQZrmbk_VCVTPD2QQZrmbkz_VCVTPD2QQZrmk_VCVTPD2QQZrmkz_VCVTTPD2QQZrm_VCVTTPD2QQZrmb_VCVTTPD2QQZrmbk_VCVTTPD2QQZrmbkz_VCVTTPD2QQZrmk_VCVTTPD2QQZrmkz_VCVTPD2UQQZrm_VCVTPD2UQQZrmb_VCVTPD2UQQZrmbk_VCVTPD2UQQZrmbkz_VCVTPD2UQQZrmk_VCVTPD2UQQZrmkz_VCVTTPD2UQQZrm_VCVTTPD2UQQZrmb_VCVTTPD2UQQZrmbk_VCVTTPD2UQQZrmbkz_VCVTTPD2UQQZrmk_VCVTTPD2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1370
  {DBGFIELD("VCVTPS2DQYrm_VCVTTPS2DQYrm_VCVTPS2DQZ256rm_VCVTPS2DQZ256rmb_VCVTPS2DQZ256rmbk_VCVTPS2DQZ256rmbkz_VCVTPS2DQZ256rmk_VCVTPS2DQZ256rmkz_VCVTTPS2DQZ256rm_VCVTTPS2DQZ256rmb_VCVTTPS2DQZ256rmbk_VCVTTPS2DQZ256rmbkz_VCVTTPS2DQZ256rmk_VCVTTPS2DQZ256rmkz_VCVTPS2QQZ256rm_VCVTPS2QQZ256rmb_VCVTPS2QQZ256rmbk_VCVTPS2QQZ256rmbkz_VCVTPS2QQZ256rmk_VCVTPS2QQZ256rmkz_VCVTTPS2QQZ256rm_VCVTTPS2QQZ256rmb_VCVTTPS2QQZ256rmbk_VCVTTPS2QQZ256rmbkz_VCVTTPS2QQZ256rmk_VCVTTPS2QQZ256rmkz_VCVTPS2UDQZ256rm_VCVTPS2UDQZ256rmb_VCVTPS2UDQZ256rmbk_VCVTPS2UDQZ256rmbkz_VCVTPS2UDQZ256rmk_VCVTPS2UDQZ256rmkz_VCVTTPS2UDQZ256rm_VCVTTPS2UDQZ256rmb_VCVTTPS2UDQZ256rmbk_VCVTTPS2UDQZ256rmbkz_VCVTTPS2UDQZ256rmk_VCVTTPS2UDQZ256rmkz_VCVTPS2UQQZ256rm_VCVTPS2UQQZ256rmb_VCVTPS2UQQZ256rmbk_VCVTPS2UQQZ256rmbkz_VCVTPS2UQQZ256rmk_VCVTPS2UQQZ256rmkz_VCVTTPS2UQQZ256rm_VCVTTPS2UQQZ256rmb_VCVTTPS2UQQZ256rmbk_VCVTTPS2UQQZ256rmbkz_VCVTTPS2UQQZ256rmk_VCVTTPS2UQQZ256rmkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1371
  {DBGFIELD("VCVTPS2DQZrm_VCVTPS2DQZrmb_VCVTPS2DQZrmbk_VCVTPS2DQZrmbkz_VCVTPS2DQZrmk_VCVTPS2DQZrmkz_VCVTTPS2DQZrm_VCVTTPS2DQZrmb_VCVTTPS2DQZrmbk_VCVTTPS2DQZrmbkz_VCVTTPS2DQZrmk_VCVTTPS2DQZrmkz_VCVTPS2UDQZrm_VCVTPS2UDQZrmb_VCVTPS2UDQZrmbk_VCVTPS2UDQZrmbkz_VCVTPS2UDQZrmk_VCVTPS2UDQZrmkz_VCVTTPS2UDQZrm_VCVTTPS2UDQZrmb_VCVTTPS2UDQZrmbk_VCVTTPS2UDQZrmbkz_VCVTTPS2UDQZrmk_VCVTTPS2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1372
  {DBGFIELD("VEXPANDPDZ256rm_VEXPANDPDZ256rmk_VEXPANDPDZ256rmkz_VEXPANDPDZrm_VEXPANDPDZrmk_VEXPANDPDZrmkz_VEXPANDPSZ256rm_VEXPANDPSZ256rmk_VEXPANDPSZ256rmkz_VEXPANDPSZrm_VEXPANDPSZrmk_VEXPANDPSZrmkz_VPEXPANDDZ256rm_VPEXPANDDZ256rmk_VPEXPANDDZ256rmkz_VPEXPANDDZrm_VPEXPANDDZrmk_VPEXPANDDZrmkz_VPEXPANDQZ256rm_VPEXPANDQZ256rmk_VPEXPANDQZ256rmkz_VPEXPANDQZrm_VPEXPANDQZrmk_VPEXPANDQZrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1373
  {DBGFIELD("CVTDQ2PDrm_VCVTDQ2PDrm") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1374
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #1375
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmbkz_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  0, 0}, // #1376
  {DBGFIELD("VPMULLQZ128rr_VPMULLQZ128rrk_VPMULLQZ128rrkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #1377
  {DBGFIELD("VPMULLQZ256rr_VPMULLQZ256rrk_VPMULLQZ256rrkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #1378
  {DBGFIELD("VPMULLQZrr_VPMULLQZrrk_VPMULLQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1379
  {DBGFIELD("VPERMWZ128rm_VPERMWZ128rmk_VPERMWZ128rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1380
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_VCVTTSD2USIZrm_Int") 3, false, false, false, 282, 11,  2, 1,  6, 1}, // #1381
  {DBGFIELD("VCVTSS2USI64Zrm_Int_VCVTTSS2USI64Zrm_VCVTTSS2USI64Zrm_Int") 3, false, false, false, 282, 11,  2, 1,  6, 1}, // #1382
  {DBGFIELD("VCVTPS2QQZrm_VCVTPS2QQZrmb_VCVTPS2QQZrmbk_VCVTPS2QQZrmbkz_VCVTPS2QQZrmk_VCVTPS2QQZrmkz_VCVTTPS2QQZrm_VCVTTPS2QQZrmb_VCVTTPS2QQZrmbk_VCVTTPS2QQZrmbkz_VCVTTPS2QQZrmk_VCVTTPS2QQZrmkz_VCVTPS2UQQZrm_VCVTPS2UQQZrmb_VCVTPS2UQQZrmbk_VCVTPS2UQQZrmbkz_VCVTPS2UQQZrmk_VCVTPS2UQQZrmkz_VCVTTPS2UQQZrm_VCVTTPS2UQQZrmb_VCVTTPS2UQQZrmbk_VCVTTPS2UQQZrmbkz_VCVTTPS2UQQZrmk_VCVTTPS2UQQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1383
  {DBGFIELD("VPERMWZ256rm_VPERMWZ256rmk_VPERMWZ256rmkz_VPERMWZrm_VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1384
  {DBGFIELD("VCVTDQ2PDYrm")       2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1385
  {DBGFIELD("VPERMI2WZ128rm_VPERMI2WZ128rmk_VPERMI2WZ128rmkz_VPERMT2WZ128rm_VPERMT2WZ128rmk_VPERMT2WZ128rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1386
  {DBGFIELD("VCVTPD2DQZrm_VCVTPD2DQZrmb_VCVTPD2DQZrmbk_VCVTPD2DQZrmbkz_VCVTPD2DQZrmk_VCVTPD2DQZrmkz_VCVTPD2UDQZrm_VCVTPD2UDQZrmb_VCVTPD2UDQZrmbk_VCVTPD2UDQZrmbkz_VCVTPD2UDQZrmk_VCVTPD2UDQZrmkz_VCVTTPD2DQZrm_VCVTTPD2DQZrmb_VCVTTPD2DQZrmbk_VCVTTPD2DQZrmbkz_VCVTTPD2DQZrmk_VCVTTPD2DQZrmkz_VCVTTPD2UDQZrm_VCVTTPD2UDQZrmb_VCVTTPD2UDQZrmbk_VCVTTPD2UDQZrmbkz_VCVTTPD2UDQZrmk_VCVTTPD2UDQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1387
  {DBGFIELD("VCVTQQ2PSZrm_VCVTQQ2PSZrmb_VCVTQQ2PSZrmbk_VCVTQQ2PSZrmbkz_VCVTQQ2PSZrmk_VCVTQQ2PSZrmkz_VCVTUQQ2PSZrm_VCVTUQQ2PSZrmb_VCVTUQQ2PSZrmbk_VCVTUQQ2PSZrmbkz_VCVTUQQ2PSZrmk_VCVTUQQ2PSZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1388
  {DBGFIELD("VPERMI2WZ256rm_VPERMI2WZ256rmk_VPERMI2WZ256rmkz_VPERMI2WZrm_VPERMI2WZrmk_VPERMI2WZrmkz_VPERMT2WZ256rm_VPERMT2WZ256rmk_VPERMT2WZ256rmkz_VPERMT2WZrm_VPERMT2WZrmk_VPERMT2WZrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1389
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmbkz_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  0, 0}, // #1390
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmbkz_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #1391
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmbkz_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #1392
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmbkz_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1393
  {DBGFIELD("VGATHERQPSZ128rm_VPGATHERQDZ128rm_VGATHERDPDZ128rm_VPGATHERDQZ128rm_VGATHERQPDZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #1394
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm_VGATHERQPDZ256rm_VPGATHERQQZ256rm_VGATHERDPSZ128rm_VPGATHERDDZ128rm_VGATHERDPDZ256rm_VPGATHERDQZ256rm") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #1395
  {DBGFIELD("VGATHERDPSZ256rm_VPGATHERDDZ256rm_VGATHERDPDZrm_VPGATHERDQZrm_VGATHERQPDZrm_VPGATHERQQZrm_VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #1396
  {DBGFIELD("VGATHERDPSZrm_VPGATHERDDZrm") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #1397
  {DBGFIELD("VPCONFLICTQZ256rr_VPCONFLICTQZ256rrk_VPCONFLICTQZ256rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1398
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmbkz_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  0, 0}, // #1399
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrk_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1400
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmbkz_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  0, 0}, // #1401
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmbkz_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1402
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmbkz_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1403
  {DBGFIELD("VXORPSZ128rr_VXORPDZ128rr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1404
  {DBGFIELD("VXORPSZ256rr_VXORPDZ256rr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1405
  {DBGFIELD("VXORPSZrr_VXORPDZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1406
  {DBGFIELD("VPXORDZ128rr_VPXORQZ128rr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1407
  {DBGFIELD("VPXORDZ256rr_VPXORQZ256rr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1408
  {DBGFIELD("VPXORDZrr_VPXORQZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1409
  {DBGFIELD("VPSUBBZ128rr_VPSUBDZ128rr_VPSUBQZ128rr_VPSUBWZ128rr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1410
  {DBGFIELD("VPSUBBZ256rr_VPSUBDZ256rr_VPSUBQZ256rr_VPSUBWZ256rr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1411
  {DBGFIELD("VPSUBBZrr_VPSUBDZrr_VPSUBQZrr_VPSUBWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1412
  {DBGFIELD("VPBROADCASTDrr_VPBROADCASTQrr") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1413
  {DBGFIELD("INSERTPSrr_VINSERTPSZrr_VINSERTPSrr_MOVHLPSrr_MOVLHPSrr_VMOVHLPSZrr_VMOVHLPSrr_VMOVLHPSZrr_VMOVLHPSrr_MOVDDUPrr_VMOVDDUPrr_VPERMILPDZ128ri_VPERMILPDZ128rik_VPERMILPDZ128rikz_VPERMILPDri_VPERMILPSZ128ri_VPERMILPSZ128rik_VPERMILPSZ128rikz_VPERMILPSri_UNPCKHPDrr_UNPCKHPSrr_UNPCKLPDrr_UNPCKLPSrr_VUNPCKHPDZ128rr_VUNPCKHPDZ128rrk_VUNPCKHPDZ128rrkz_VUNPCKHPDrr_VUNPCKHPSZ128rr_VUNPCKHPSZ128rrk_VUNPCKHPSZ128rrkz_VUNPCKHPSrr_VUNPCKLPDZ128rr_VUNPCKLPDZ128rrk_VUNPCKLPDZ128rrkz_VUNPCKLPDrr_VUNPCKLPSZ128rr_VUNPCKLPSZ128rrk_VUNPCKLPSZ128rrkz_VUNPCKLPSrr") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1414
  {DBGFIELD("VMOVDDUPYrr_VPERMILPDYri_VPERMILPDZ256ri_VPERMILPDZ256rik_VPERMILPDZ256rikz_VPERMILPSYri_VPERMILPSZ256ri_VPERMILPSZ256rik_VPERMILPSZ256rikz_VUNPCKHPDYrr_VUNPCKHPDZ256rr_VUNPCKHPDZ256rrk_VUNPCKHPDZ256rrkz_VUNPCKHPSYrr_VUNPCKHPSZ256rr_VUNPCKHPSZ256rrk_VUNPCKHPSZ256rrkz_VUNPCKLPDYrr_VUNPCKLPDZ256rr_VUNPCKLPDZ256rrk_VUNPCKLPDZ256rrkz_VUNPCKLPSYrr_VUNPCKLPSZ256rr_VUNPCKLPSZ256rrk_VUNPCKLPSZ256rrkz") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1415
  {DBGFIELD("VPALIGNRYrri")       1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1416
  {DBGFIELD("VPERMILPDrr_VPERMILPSrr") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1417
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDZrr_VMOVSDZrr_REV_VMOVSDZrrk_VMOVSDZrrk_REV_VMOVSDZrrkz_VMOVSDZrrkz_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSZrr_VMOVSSZrr_REV_VMOVSSZrrk_VMOVSSZrrk_REV_VMOVSSZrrkz_VMOVSSZrrkz_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1418
  {DBGFIELD("VPACKSSDWYrr_VPACKSSWBYrr_VPACKUSDWYrr_VPACKUSWBYrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1419
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTBZ128rmk_VPBROADCASTBZ128rmkz_VPBROADCASTWZ128rm_VPBROADCASTWZ128rmk_VPBROADCASTWZ128rmkz") 2, false, false, false, 79, 8,  7, 1,  0, 0}, // #1420
  {DBGFIELD("INSERTPSrm_VINSERTPSZrm_VINSERTPSrm_UNPCKHPDrm_UNPCKHPSrm_UNPCKLPDrm_UNPCKLPSrm_VUNPCKHPDZ128rm_VUNPCKHPDZ128rmb_VUNPCKHPDZ128rmbk_VUNPCKHPDZ128rmbkz_VUNPCKHPDZ128rmk_VUNPCKHPDZ128rmkz_VUNPCKHPDrm_VUNPCKHPSZ128rm_VUNPCKHPSZ128rmb_VUNPCKHPSZ128rmbk_VUNPCKHPSZ128rmbkz_VUNPCKHPSZ128rmk_VUNPCKHPSZ128rmkz_VUNPCKHPSrm_VUNPCKLPDZ128rm_VUNPCKLPDZ128rmb_VUNPCKLPDZ128rmbk_VUNPCKLPDZ128rmbkz_VUNPCKLPDZ128rmk_VUNPCKLPDZ128rmkz_VUNPCKLPDrm_VUNPCKLPSZ128rm_VUNPCKLPSZ128rmb_VUNPCKLPSZ128rmbk_VUNPCKLPSZ128rmbkz_VUNPCKLPSZ128rmk_VUNPCKLPSZ128rmkz_VUNPCKLPSrm") 2, false, false, false, 540, 12,  7, 1,  6, 1}, // #1421
  {DBGFIELD("PALIGNRrmi_VPALIGNRZ128rmi_VPALIGNRZ128rmik_VPALIGNRZ128rmikz_VPALIGNRrmi") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #1422
  {DBGFIELD("VPERMILPDZ128mbi_VPERMILPDZ128mbik_VPERMILPDZ128mbikz_VPERMILPDZ128mi_VPERMILPDZ128mik_VPERMILPDZ128mikz_VPERMILPDmi_VPERMILPSZ128mbi_VPERMILPSZ128mbik_VPERMILPSZ128mbikz_VPERMILPSZ128mi_VPERMILPSZ128mik_VPERMILPSZ128mikz_VPERMILPSmi") 2, false, false, false, 540, 12,  7, 1,  0, 0}, // #1423
  {DBGFIELD("VPERMILPDZ128rm_VPERMILPDZ128rmb_VPERMILPDZ128rmbk_VPERMILPDZ128rmbkz_VPERMILPDZ128rmk_VPERMILPDZ128rmkz_VPERMILPDrm_VPERMILPSZ128rm_VPERMILPSZ128rmb_VPERMILPSZ128rmbk_VPERMILPSZ128rmbkz_VPERMILPSZ128rmk_VPERMILPSZ128rmkz_VPERMILPSrm") 2, false, false, false, 540, 12,  7, 1,  6, 1}, // #1424
  {DBGFIELD("VPALIGNRYrmi_VPALIGNRZ256rmi_VPALIGNRZ256rmik_VPALIGNRZ256rmikz") 2, false, false, false, 79, 8, 22, 1,  6, 1}, // #1425
  {DBGFIELD("VPERMILPDYmi_VPERMILPDZ256mbi_VPERMILPDZ256mbik_VPERMILPDZ256mbikz_VPERMILPDZ256mi_VPERMILPDZ256mik_VPERMILPDZ256mikz_VPERMILPSYmi_VPERMILPSZ256mbi_VPERMILPSZ256mbik_VPERMILPSZ256mbikz_VPERMILPSZ256mi_VPERMILPSZ256mik_VPERMILPSZ256mikz") 2, false, false, false, 540, 12, 22, 1,  0, 0}, // #1426
  {DBGFIELD("VPERMILPDYrm_VPERMILPDZ256rm_VPERMILPDZ256rmb_VPERMILPDZ256rmbk_VPERMILPDZ256rmbkz_VPERMILPDZ256rmk_VPERMILPDZ256rmkz_VPERMILPSYrm_VPERMILPSZ256rm_VPERMILPSZ256rmb_VPERMILPSZ256rmbk_VPERMILPSZ256rmbkz_VPERMILPSZ256rmk_VPERMILPSZ256rmkz") 2, false, false, false, 540, 12, 22, 1,  6, 1}, // #1427
  {DBGFIELD("VUNPCKHPDYrm_VUNPCKHPDZ256rm_VUNPCKHPDZ256rmb_VUNPCKHPDZ256rmbk_VUNPCKHPDZ256rmbkz_VUNPCKHPDZ256rmk_VUNPCKHPDZ256rmkz_VUNPCKHPSYrm_VUNPCKHPSZ256rm_VUNPCKHPSZ256rmb_VUNPCKHPSZ256rmbk_VUNPCKHPSZ256rmbkz_VUNPCKHPSZ256rmk_VUNPCKHPSZ256rmkz_VUNPCKLPDYrm_VUNPCKLPDZ256rm_VUNPCKLPDZ256rmb_VUNPCKLPDZ256rmbk_VUNPCKLPDZ256rmbkz_VUNPCKLPDZ256rmk_VUNPCKLPDZ256rmkz_VUNPCKLPSYrm_VUNPCKLPSZ256rm_VUNPCKLPSZ256rmb_VUNPCKLPSZ256rmbk_VUNPCKLPSZ256rmbkz_VUNPCKLPSZ256rmk_VUNPCKLPSZ256rmkz") 2, false, false, false, 540, 12, 22, 1,  6, 1}, // #1428
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWZ128rm_VPACKSSDWZ128rmb_VPACKSSDWZ128rmbk_VPACKSSDWZ128rmbkz_VPACKSSDWZ128rmk_VPACKSSDWZ128rmkz_VPACKSSDWrm_VPACKSSWBZ128rm_VPACKSSWBZ128rmk_VPACKSSWBZ128rmkz_VPACKSSWBrm_VPACKUSDWZ128rm_VPACKUSDWZ128rmb_VPACKUSDWZ128rmbk_VPACKUSDWZ128rmbkz_VPACKUSDWZ128rmk_VPACKUSDWZ128rmkz_VPACKUSDWrm_VPACKUSWBZ128rm_VPACKUSWBZ128rmk_VPACKUSWBZ128rmkz_VPACKUSWBrm") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #1429
  {DBGFIELD("VPACKSSDWYrm_VPACKSSDWZ256rm_VPACKSSDWZ256rmb_VPACKSSDWZ256rmbk_VPACKSSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSDWZ256rmkz_VPACKSSWBYrm_VPACKSSWBZ256rm_VPACKSSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSDWYrm_VPACKUSDWZ256rm_VPACKUSDWZ256rmb_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmbkz_VPACKUSDWZ256rmk_VPACKUSDWZ256rmkz_VPACKUSWBYrm_VPACKUSWBZ256rm_VPACKUSWBZ256rmk_VPACKUSWBZ256rmkz") 2, false, false, false, 79, 8, 22, 1,  6, 1}, // #1430
  {DBGFIELD("VPACKSSDWZrm_VPACKSSDWZrmb_VPACKSSDWZrmbk_VPACKSSDWZrmbkz_VPACKSSDWZrmk_VPACKSSDWZrmkz_VPACKSSWBZrm_VPACKSSWBZrmk_VPACKSSWBZrmkz_VPACKUSDWZrm_VPACKUSDWZrmb_VPACKUSDWZrmbk_VPACKUSDWZrmbkz_VPACKUSDWZrmk_VPACKUSDWZrmkz_VPACKUSWBZrm_VPACKUSWBZrmk_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1431
  {DBGFIELD("AADD64mr_AAND64mr_AOR64mr_AXOR64mr") 3, false, false, false, 2041, 10,  6, 1,  0, 0}, // #1432
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT") 2, false, false, false, 233, 7,  3, 1,  0, 0}, // #1433
  {DBGFIELD("RET16")              2, false, false, false, 233, 7,  3, 1,  0, 0}, // #1434
  {DBGFIELD("RORX32mi_RORX64mi")  2, false, false, false, 233, 7,  3, 1,  0, 0}, // #1435
  {DBGFIELD("ADC16rm_ADC32rm_ADC64rm_ADC8rm_SBB16rm_SBB32rm_SBB64rm_SBB8rm_ADCX32rm_ADCX64rm_ADOX32rm_ADOX64rm") 2, false, false, false, 233, 7,  3, 1, 12, 2}, // #1436
  {DBGFIELD("ADC8mi_ADC8mi8_SBB8mi_SBB8mi8") 5, false, false, false, 65, 9, 24, 1,  0, 0}, // #1437
  {DBGFIELD("CMP16mi_CMP32mi_CMP8mi_CMP16mi8_CMP32mi8_CMP64mi8_CMP8mi8") 2, false, false, false, 106, 4,  3, 1,  0, 0}, // #1438
  {DBGFIELD("MOV8rm")             2, false, false, false, 106, 4,  3, 1,  0, 0}, // #1439
  {DBGFIELD("POP16rmr_POP32rmr")  2, false, false, false, 106, 4,  3, 1,  0, 0}, // #1440
  {DBGFIELD("POP32r")             2, false, false, false, 106, 4,  3, 1,  0, 0}, // #1441
  {DBGFIELD("CMP64mi32")          2, false, false, false, 106, 4,  3, 1,  0, 0}, // #1442
  {DBGFIELD("MOV8rm_NOREX")       2, false, false, false, 106, 4,  3, 1,  0, 0}, // #1443
  {DBGFIELD("MOVZX16rm8")         2, false, false, false, 106, 4,  3, 1,  0, 0}, // #1444
  {DBGFIELD("ADD16rm_ADD32rm_ADD64rm_ADD8rm_CMP16rm_CMP32rm_CMP64rm_CMP8rm_SUB16rm_SUB32rm_SUB64rm_SUB8rm_AND16rm_AND32rm_AND8rm_OR16rm_OR32rm_OR8rm_XOR16rm_XOR32rm_XOR8rm") 2, false, false, false, 106, 4,  3, 1,  1, 1}, // #1445
  {DBGFIELD("CMP16mr_CMP32mr_CMP64mr_CMP8mr") 2, false, false, false, 106, 4,  3, 1,  1, 1}, // #1446
  {DBGFIELD("ADD64ri8_SUB64ri8_DEC64r_INC64r") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1447
  {DBGFIELD("MOV64rr_MOV64rr_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1448
  {DBGFIELD("JMP_2")              0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1449
  {DBGFIELD("ADD8mi_ADD8mi8_SUB8mi_SUB8mi8") 4, false, false, false, 59, 6, 24, 1,  0, 0}, // #1450
  {DBGFIELD("AND8mi_AND8mi8_OR8mi_OR8mi8_XOR8mi_XOR8mi8") 4, false, false, false, 59, 6, 24, 1,  0, 0}, // #1451
  {DBGFIELD("DEC8m_INC8m_NEG8m_NOT8m") 4, false, false, false, 59, 6, 24, 1,  0, 0}, // #1452
  {DBGFIELD("ADD8mr")             4, false, false, false, 59, 6, 24, 1,  1, 1}, // #1453
  {DBGFIELD("AND8mr_OR8mr_XOR8mr") 4, false, false, false, 59, 6, 24, 1,  1, 1}, // #1454
  {DBGFIELD("SUB8mr")             4, false, false, false, 59, 6, 24, 1,  1, 1}, // #1455
  {DBGFIELD("ADDSSrr_ADDSSrr_Int_SUBSSrr_SUBSSrr_Int_VADDSSrr_VADDSSrr_Int_VSUBSSrr_VSUBSSrr_Int") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1456
  {DBGFIELD("AND16ri8_AND16rr_AND32ri8_AND32rr_AND64ri8_AND64rr_AND8ri8_AND8rr_AND16rr_REV_AND32rr_REV_AND64rr_REV_AND8rr_REV_TEST32i32_TEST64i32_AND32ri_AND8ri_TEST32ri_TEST8ri_AND64ri32_TEST64ri32_TEST8i8_OR16ri8_OR16rr_OR32ri8_OR32rr_OR64ri8_OR64rr_OR8ri8_OR8rr_XOR16ri8_XOR16rr_XOR32ri8_XOR64ri8_XOR8ri8_XOR8rr_OR16rr_REV_OR32rr_REV_OR64rr_REV_OR8rr_REV_XOR16rr_REV_XOR8rr_REV_OR32ri_OR8ri_XOR32ri_XOR8ri_OR64ri32_XOR64ri32_TEST16rr_TEST32rr_TEST64rr_TEST8rr") 1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1457
  {DBGFIELD("AND32i32_AND64i32_AND8i8_OR32i32_OR64i32_XOR32i32_XOR64i32_OR8i8_XOR8i8") 1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1458
  {DBGFIELD("XOR32rr_XOR64rr")    1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1459
  {DBGFIELD("XOR32rr_REV_XOR64rr_REV") 1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1460
  {DBGFIELD("XOR8rr_NOREX")       1, false, false, false,  1, 2, 12, 1,  0, 0}, // #1461
  {DBGFIELD("TEST16mi_TEST32mi_TEST8mi") 2, false, false, false, 106, 4,  6, 1,  0, 0}, // #1462
  {DBGFIELD("TEST64mi32")         2, false, false, false, 106, 4,  6, 1,  0, 0}, // #1463
  {DBGFIELD("OR64rm_XOR64rm")     2, false, false, false, 106, 4,  6, 1,  1, 1}, // #1464
  {DBGFIELD("AND64rm")            2, false, false, false, 106, 4,  6, 1,  1, 1}, // #1465
  {DBGFIELD("TEST16mr_TEST32mr_TEST64mr_TEST8mr") 2, false, false, false, 106, 4,  6, 1,  1, 1}, // #1466
  {DBGFIELD("ANDN32rm_ANDN64rm")  2, false, false, false, 177, 5,  6, 1,  1, 1}, // #1467
  {DBGFIELD("ANDN32rr_ANDN64rr")  1, false, false, false, 182, 3, 12, 1,  0, 0}, // #1468
  {DBGFIELD("BT64mr")             9, false, false, false, 2051, 12,  9, 1,  0, 0}, // #1469
  {DBGFIELD("BT64rr")             1, false, false, false, 39, 8,  5, 1,  0, 0}, // #1470
  {DBGFIELD("BTC64rr_BTR64rr_BTS64rr") 1, false, false, false, 39, 8,  5, 1,  0, 0}, // #1471
  {DBGFIELD("BTC64mr_BTR64mr_BTS64mr") 10, false, false, false, 2063, 14, 20, 1,  0, 0}, // #1472
  {DBGFIELD("CALL64m_CALL64m_NT") 5, false, false, false, 65, 9,  6, 1,  0, 0}, // #1473
  {DBGFIELD("CALL64r_CALL64r_NT") 3, false, false, false, 1573, 8,  5, 1,  0, 0}, // #1474
  {DBGFIELD("CDQE_CWDE")          1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1475
  {DBGFIELD("MOVSHDUPrr_MOVSLDUPrr_VMOVSHDUPrr_VMOVSLDUPrr_SHUFPDrri_SHUFPSrri_VSHUFPDrri_VSHUFPSrri") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1476
  {DBGFIELD("VMOVSHDUPYrr_VMOVSLDUPYrr_VSHUFPDYrri_VSHUFPSYrri") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1477
  {DBGFIELD("VPBLENDWYrri")       1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1478
  {DBGFIELD("CLFLUSH")            4, false, false, false, 2077, 8, 12, 1,  0, 0}, // #1479
  {DBGFIELD("CLTS")               10, false, false, false, 2085, 13,  4, 1,  0, 0}, // #1480
  {DBGFIELD("MOV16o16a_MOV16o32a_MOV16o64a") 3, false, false, false, 881, 5, 10, 1,  0, 0}, // #1481
  {DBGFIELD("CLWB")               3, false, false, false, 881, 5, 10, 1,  0, 0}, // #1482
  {DBGFIELD("CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SIrm") 3, false, false, false, 282, 11, 80, 1,  0, 0}, // #1483
  {DBGFIELD("VCVTTSD2SIrm_Int")   3, false, false, false, 282, 11, 80, 1,  0, 0}, // #1484
  {DBGFIELD("VCVTSI642SSrm_Int")  3, false, false, false, 269, 13,  2, 1,  6, 1}, // #1485
  {DBGFIELD("VCVTSI642SSrm")      3, false, false, false, 269, 13,  2, 1,  6, 1}, // #1486
  {DBGFIELD("VCVTSI642SSrr_Int")  3, false, false, false, 922, 11,  7, 1,  7, 1}, // #1487
  {DBGFIELD("JECXZ_JRCXZ")        2, false, false, false, 74, 5, 12, 1,  0, 0}, // #1488
  {DBGFIELD("ST_Frr")             1, false, false, false, 36, 3,  1, 1,  0, 0}, // #1489
  {DBGFIELD("MOV16sr_MOV32sr")    1, false, false, false, 36, 3,  1, 1,  0, 0}, // #1490
  {DBGFIELD("DEC16r_alt_SALC")    1, false, false, false, 36, 3,  1, 1,  0, 0}, // #1491
  {DBGFIELD("SYSCALL")            1, false, false, false, 36, 3,  1, 1,  0, 0}, // #1492
  {DBGFIELD("DEC32r_alt")         1, false, false, false, 789, 9,  6, 1,  0, 0}, // #1493
  {DBGFIELD("DIVR_FPrST0_DIVR_FrST0") 1, false, false, false,  3, 9, 11, 1,  0, 0}, // #1494
  {DBGFIELD("DIVSDrm_Int_VDIVSDrm_Int") 2, false, false, false, 247, 11, 15, 1,  6, 1}, // #1495
  {DBGFIELD("DIV_FPrST0_DIV_FrST0") 1, false, false, false,  3, 9, 15, 1,  0, 0}, // #1496
  {DBGFIELD("SMSW16m")            3, false, false, false, 1368, 13,  2, 1,  0, 0}, // #1497
  {DBGFIELD("MMX_PEXTRWrr")       2, false, false, false, 624, 13, 14, 1,  0, 0}, // #1498
  {DBGFIELD("MMX_PADDBrr_MMX_PADDDrr_MMX_PADDWrr") 1, false, false, false, 563, 6,  1, 1,  0, 0}, // #1499
  {DBGFIELD("GF2P8AFFINEINVQBrmi_GF2P8AFFINEQBrmi_VGF2P8AFFINEINVQBrmi_VGF2P8AFFINEQBrmi") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1500
  {DBGFIELD("GF2P8MULBrm_VGF2P8MULBrm") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1501
  {DBGFIELD("VGF2P8AFFINEINVQBYrmi_VGF2P8AFFINEQBYrmi") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1502
  {DBGFIELD("VGF2P8MULBYrm")      2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1503
  {DBGFIELD("GF2P8MULBrr_VGF2P8MULBrr") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #1504
  {DBGFIELD("VGF2P8MULBYrr")      1, false, false, false, 110, 5, 10, 1,  0, 0}, // #1505
  {DBGFIELD("IN16ri")             87, false, false, false, 2098, 16, 55, 1,  0, 0}, // #1506
  {DBGFIELD("IN16rr")             87, false, false, false, 2114, 16, 55, 1,  0, 0}, // #1507
  {DBGFIELD("IN32ri")             94, false, false, false, 2130, 16, 55, 1,  0, 0}, // #1508
  {DBGFIELD("IN32rr")             99, false, false, false, 2146, 16,  1, 1,  0, 0}, // #1509
  {DBGFIELD("INC16r_alt")         4, false, false, false, 12, 5,  1, 1,  0, 0}, // #1510
  {DBGFIELD("INC32r_alt")         1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1511
  {DBGFIELD("INSB")               83, false, false, false, 2162, 18, 15, 1,  0, 0}, // #1512
  {DBGFIELD("INSL")               92, false, false, false, 2180, 18, 15, 1,  0, 0}, // #1513
  {DBGFIELD("INVLPG")             42, false, false, false, 2198, 17,  4, 1,  0, 0}, // #1514
  {DBGFIELD("JMP64r_REX")         1, false, false, false, 2215, 6,  1, 1,  0, 0}, // #1515
  {DBGFIELD("JMP_1_JMP_4")        0, false, false, false,  0, 0,  0, 1,  0, 0}, // #1516
  {DBGFIELD("LAR16rm")            81, false, false, false, 2221, 16, 81, 1,  0, 0}, // #1517
  {DBGFIELD("LAR16rr")            22, false, false, false, 1613, 16, 82, 1,  0, 0}, // #1518
  {DBGFIELD("LAR32rm")            85, false, false, false, 2237, 16, 83, 1,  0, 0}, // #1519
  {DBGFIELD("LAR64rm")            87, false, false, false, 2237, 16, 83, 1,  0, 0}, // #1520
  {DBGFIELD("LEAVE")              4, false, false, false, 870, 4,  3, 1,  0, 0}, // #1521
  {DBGFIELD("LGDT64m")            14, false, false, false, 2253, 16,  4, 1,  0, 0}, // #1522
  {DBGFIELD("LIDT64m")            14, false, false, false, 2269, 15,  4, 1,  0, 0}, // #1523
  {DBGFIELD("LLDT16m")            12, false, false, false, 2284, 14,  4, 1,  0, 0}, // #1524
  {DBGFIELD("LLDT16r")            11, false, false, false, 2298, 14,  4, 1,  0, 0}, // #1525
  {DBGFIELD("LMSW16m")            27, false, false, false, 2312, 18,  4, 1,  0, 0}, // #1526
  {DBGFIELD("LMSW16r")            22, false, false, false, 2330, 16,  4, 1,  0, 0}, // #1527
  {DBGFIELD("MMX_MOVD64mr")       2, false, false, false, 52, 4, 13, 1,  0, 0}, // #1528
  {DBGFIELD("MMX_MOVD64rm_MMX_MOVQ64rm") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1529
  {DBGFIELD("MMX_MOVD64to64rm")   1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1530
  {DBGFIELD("MMX_MOVFR642Qrr")    2, false, false, false, 1341, 6,  5, 1,  0, 0}, // #1531
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm") 3, false, false, false, 1591, 12,  2, 1,  6, 1}, // #1532
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr") 2, false, false, false, 1603, 10, 14, 1,  0, 0}, // #1533
  {DBGFIELD("MMX_PINSRWrr")       2, false, false, false, 1603, 10, 14, 1,  7, 1}, // #1534
  {DBGFIELD("MMX_PADDBrm_MMX_PADDDrm_MMX_PADDWrm_MMX_PSUBBrm_MMX_PSUBDrm_MMX_PSUBWrm") 2, false, false, false, 569, 8, 22, 1,  6, 1}, // #1535
  {DBGFIELD("MMX_PINSRWrm")       2, false, false, false, 540, 12, 22, 1,  1, 1}, // #1536
  {DBGFIELD("VPALIGNRYrmi")       2, false, false, false, 540, 12, 22, 1,  6, 1}, // #1537
  {DBGFIELD("MOV16ao16_MOV16ao32_MOV16ao64") 2, false, false, false, 106, 4, 10, 1,  0, 0}, // #1538
  {DBGFIELD("PUSHFS16_PUSHFS32_PUSHGS16_PUSHGS32") 3, false, false, false, 1347, 11,  2, 1,  0, 0}, // #1539
  {DBGFIELD("MOV16ms")            3, false, false, false, 1347, 11,  2, 1,  0, 0}, // #1540
  {DBGFIELD("MOVBE32mr")          3, false, false, false, 1347, 11,  2, 1,  0, 0}, // #1541
  {DBGFIELD("MOV16rs_MOV32rs_MOV64rs") 2, false, false, false, 484, 8,  1, 1,  0, 0}, // #1542
  {DBGFIELD("SLDT16r")            2, false, false, false, 484, 8,  1, 1,  0, 0}, // #1543
  {DBGFIELD("STR16r")             2, false, false, false, 484, 8,  1, 1,  0, 0}, // #1544
  {DBGFIELD("MOV32ao16_MOV32ao32_MOV32ao64") 1, false, false, false, 56, 3,  1, 1,  0, 0}, // #1545
  {DBGFIELD("MOV64ao64")          1, false, false, false, 56, 3,  1, 1,  0, 0}, // #1546
  {DBGFIELD("MOV32o16a_MOV32o32a_MOV8o16a_MOV8o32a_MOV32o64a_MOV64o64a_MOV8o64a") 3, false, false, false, 881, 5,  1, 1,  0, 0}, // #1547
  {DBGFIELD("MOVZX32rr8_MOVZX64rr8") 1, false, false, false,  1, 2,  0, 1,  0, 0}, // #1548
  {DBGFIELD("MOVZX32rr8_NOREX")   1, false, false, false,  1, 2,  0, 1,  0, 0}, // #1549
  {DBGFIELD("MOV64ao32")          1, false, false, false, 56, 3, 10, 1,  0, 0}, // #1550
  {DBGFIELD("MOV64dr")            48, false, false, false, 2346, 16, 84, 1,  0, 0}, // #1551
  {DBGFIELD("MOV64o32a")          2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1552
  {DBGFIELD("MOV64rc")            3, false, false, false, 2362, 11,  4, 1,  0, 0}, // #1553
  {DBGFIELD("MOV64rd")            24, false, false, false, 2373, 13, 85, 1,  0, 0}, // #1554
  {DBGFIELD("MOV8ao16_MOV8ao32_MOV8ao64") 2, false, false, false, 106, 4,  1, 1,  0, 0}, // #1555
  {DBGFIELD("MOV8mi_MOV8mr")      2, false, false, false, 52, 4, 24, 1,  0, 0}, // #1556
  {DBGFIELD("MOV8mr_NOREX")       2, false, false, false, 52, 4, 24, 1,  0, 0}, // #1557
  {DBGFIELD("MOVBE32rm")          2, false, false, false, 185, 10,  3, 1,  0, 0}, // #1558
  {DBGFIELD("SLDT16m")            4, false, false, false, 1386, 13,  2, 1,  0, 0}, // #1559
  {DBGFIELD("STRm")               4, false, false, false, 1386, 13,  2, 1,  0, 0}, // #1560
  {DBGFIELD("MOVBE64rm")          3, false, false, false, 155, 12,  6, 1,  0, 0}, // #1561
  {DBGFIELD("MOVDIR64B16_MOVDIR64B32_MOVDIR64B64") 4, false, false, false, 789, 9,  1, 1,  0, 0}, // #1562
  {DBGFIELD("MOVDIRI32")          2, false, false, false, 52, 4, 25, 1,  0, 0}, // #1563
  {DBGFIELD("MOVDIRI64")          2, false, false, false, 52, 4, 86, 1,  0, 0}, // #1564
  {DBGFIELD("MOVLPDrm_MOVLPSrm_VMOVLPDrm_VMOVLPSrm") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #1565
  {DBGFIELD("SHUFPDrmi_SHUFPSrmi_VSHUFPDrmi_VSHUFPSrmi") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #1566
  {DBGFIELD("MOVNTDQmr")          2, false, false, false, 52, 4, 26, 1,  0, 0}, // #1567
  {DBGFIELD("MOVNTImr")           2, false, false, false, 52, 4, 27, 1,  0, 0}, // #1568
  {DBGFIELD("MOVSB")              7, false, false, false, 951, 6,  7, 1,  0, 0}, // #1569
  {DBGFIELD("MOVSDrr_MOVSDrr_REV_VMOVSDrr_VMOVSDrr_REV_VMOVSSrr_VMOVSSrr_REV") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1570
  {DBGFIELD("MOVSX16rm16_MOVSX16rm32") 1, false, false, false, 56, 3,  3, 1,  0, 0}, // #1571
  {DBGFIELD("MOVSX32rm16_MOVSX32rm32_MOVSX64rm16_MOVSX64rm32_MOVSX32rm8_MOVSX64rm8") 1, false, false, false, 56, 3,  3, 1,  0, 0}, // #1572
  {DBGFIELD("MOVSX32rm8_NOREX")   1, false, false, false, 56, 3,  3, 1,  0, 0}, // #1573
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32") 1, false, false, false, 182, 3,  1, 1,  0, 0}, // #1574
  {DBGFIELD("MOVSX16rr8")         1, false, false, false, 182, 3,  1, 1,  0, 0}, // #1575
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX64rr16_MOVSX64rr8") 1, false, false, false, 182, 3,  1, 1,  0, 0}, // #1576
  {DBGFIELD("MOVSX32rr8_NOREX")   1, false, false, false, 182, 3,  1, 1,  0, 0}, // #1577
  {DBGFIELD("MUL_FPrST0_MUL_FrST0") 1, false, false, false,  3, 9, 14, 1,  0, 0}, // #1578
  {DBGFIELD("OUT16ir")            79, false, false, false, 2386, 18, 55, 1,  0, 0}, // #1579
  {DBGFIELD("OUT16rr")            79, false, false, false, 2404, 18, 55, 1,  0, 0}, // #1580
  {DBGFIELD("OUT32ir")            85, false, false, false, 2422, 18, 55, 1,  0, 0}, // #1581
  {DBGFIELD("OUT32rr")            85, false, false, false, 2440, 18, 55, 1,  0, 0}, // #1582
  {DBGFIELD("OUTSB")              80, false, false, false, 2458, 18,  4, 1,  0, 0}, // #1583
  {DBGFIELD("OUTSL")              89, false, false, false, 2476, 18,  4, 1,  0, 0}, // #1584
  {DBGFIELD("PACKSSDWrm_PACKSSWBrm_PACKUSDWrm_PACKUSWBrm_VPACKSSDWrm_VPACKSSWBrm_VPACKUSDWrm_VPACKUSWBrm") 2, false, false, false, 540, 12,  9, 1,  6, 1}, // #1585
  {DBGFIELD("PACKSSDWrr_PACKSSWBrr_PACKUSDWrr_PACKUSWBrr_VPACKSSDWrr_VPACKSSWBrr_VPACKUSDWrr_VPACKUSWBrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1586
  {DBGFIELD("PALIGNRrmi_VPALIGNRrmi") 2, false, false, false, 540, 12,  7, 1,  6, 1}, // #1587
  {DBGFIELD("PALIGNRrri_VPALIGNRrri") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1588
  {DBGFIELD("PDEP32rm_PDEP64rm_PEXT32rm_PEXT64rm") 2, false, false, false, 185, 10,  7, 1,  1, 1}, // #1589
  {DBGFIELD("PREFETCHIT0_PREFETCHIT1") 1, false, false, false, 971, 6, 10, 1,  0, 0}, // #1590
  {DBGFIELD("PREFETCHT0_PREFETCHT1_PREFETCHT2") 1, false, false, false, 56, 3,  0, 1,  0, 0}, // #1591
  {DBGFIELD("PREFETCHNTA")        1, false, false, false, 56, 3,  0, 1,  0, 0}, // #1592
  {DBGFIELD("PTWRITE64m_PTWRITEm") 4, false, false, false, 2494, 8,  4, 1,  0, 0}, // #1593
  {DBGFIELD("PTWRITE64r")         3, false, false, false, 2502, 6,  4, 1,  0, 0}, // #1594
  {DBGFIELD("PTWRITEr")           4, false, false, false, 2508, 6,  4, 1,  0, 0}, // #1595
  {DBGFIELD("PUSH64r")            2, false, false, false, 52, 4,  1, 1,  0, 0}, // #1596
  {DBGFIELD("PUSH64rmr")          2, false, false, false, 52, 4,  1, 1,  0, 0}, // #1597
  {DBGFIELD("RCL8m1_RCR8m1")      6, false, false, false, 17, 9, 58, 2,  0, 0}, // #1598
  {DBGFIELD("RCL8mi")             6, false, false, false, 17, 9, 58, 2,  0, 0}, // #1599
  {DBGFIELD("RCR8mi")             6, false, false, false, 17, 9, 58, 2,  0, 0}, // #1600
  {DBGFIELD("RCL8mCL")            11, false, false, false, 2514, 14, 87, 2,  0, 0}, // #1601
  {DBGFIELD("RCR8mCL")            12, false, false, false, 2528, 14, 87, 2,  0, 0}, // #1602
  {DBGFIELD("RDPID64")            1, false, false, false, 39, 8,  4, 1,  0, 0}, // #1603
  {DBGFIELD("RDPKRUr")            3, false, false, false, 504, 10,  4, 1,  0, 0}, // #1604
  {DBGFIELD("RDRAND16r")          25, false, false, false, 1546, 16, 89, 1,  0, 0}, // #1605
  {DBGFIELD("RDSEED16r")          25, false, false, false, 2542, 16, 90, 1,  0, 0}, // #1606
  {DBGFIELD("RDSEED32r_RDSEED64r") 25, false, false, false, 2542, 16,  4, 1,  0, 0}, // #1607
  {DBGFIELD("REX64_PREFIX")       1, false, false, false,  0, 0,  1, 1,  0, 0}, // #1608
  {DBGFIELD("ROL16m1_ROL16mi_ROL32m1_ROL32mi_ROL64m1_ROL64mi_ROR16m1_ROR16mi_ROR32m1_ROR32mi_ROR64m1_ROR64mi") 5, false, false, false, 798, 9, 33, 2,  0, 0}, // #1609
  {DBGFIELD("ROL16mCL_ROL32mCL_ROL64mCL_ROR16mCL_ROR32mCL_ROR64mCL") 5, false, false, false, 798, 9, 33, 2,  0, 0}, // #1610
  {DBGFIELD("ROL16ri_ROL32ri_ROL64ri_ROL8ri_ROR16ri_ROR32ri_ROR64ri_ROR8ri") 2, false, false, false, 784, 5,  1, 1,  0, 0}, // #1611
  {DBGFIELD("ROL8m1_ROL8mi_ROR8m1_ROR8mi") 5, false, false, false, 798, 9, 58, 2,  0, 0}, // #1612
  {DBGFIELD("ROL8mCL_ROR8mCL")    5, false, false, false, 798, 9, 58, 2,  0, 0}, // #1613
  {DBGFIELD("SHL8mCL_SAR8mCL_SHR8mCL") 5, false, false, false, 798, 9, 58, 2,  0, 0}, // #1614
  {DBGFIELD("SAR8m1_SAR8mi_SHR8m1_SHR8mi_SHL8m1_SHL8mi") 4, false, false, false, 789, 9, 58, 2,  0, 0}, // #1615
  {DBGFIELD("SARX32rm_SARX64rm_SHRX32rm_SHRX64rm_SHLX32rm_SHLX64rm") 2, false, false, false, 233, 7,  7, 1,  1, 1}, // #1616
  {DBGFIELD("SARX32rr_SARX64rr_SHRX32rr_SHRX64rr_SHLX32rr_SHLX64rr") 1, false, false, false, 12, 5,  5, 1,  0, 0}, // #1617
  {DBGFIELD("SERIALIZE")          7, false, false, false, 2558, 13,  4, 1,  0, 0}, // #1618
  {DBGFIELD("SHRD16mri8")         5, false, false, false, 834, 12, 24, 1,  0, 0}, // #1619
  {DBGFIELD("SMSW16r")            2, false, false, false, 2571, 10,  1, 1,  0, 0}, // #1620
  {DBGFIELD("SMSW32r_SMSW64r")    2, false, false, false, 2571, 10,  4, 1,  0, 0}, // #1621
  {DBGFIELD("SQRTSDm_Int_VSQRTSDm_Int") 2, false, false, false, 247, 11, 41, 1,  6, 1}, // #1622
  {DBGFIELD("STI")                6, false, false, false, 2581, 10,  4, 1,  0, 0}, // #1623
  {DBGFIELD("STOSB")              4, false, false, false, 1381, 5,  7, 1,  0, 0}, // #1624
  {DBGFIELD("VBLENDVPDrmr_VBLENDVPSrmr") 4, false, false, false, 868, 6, 22, 1, 10, 2}, // #1625
  {DBGFIELD("VPBLENDVBrmr")       4, false, false, false, 868, 6, 22, 1, 10, 2}, // #1626
  {DBGFIELD("VBLENDVPDrrr_VBLENDVPSrrr") 3, false, false, false, 874, 4,  5, 1,  0, 0}, // #1627
  {DBGFIELD("VPBLENDVBrrr")       3, false, false, false, 874, 4,  5, 1,  0, 0}, // #1628
  {DBGFIELD("VERRm")              31, false, false, false, 2591, 14, 57, 1,  0, 0}, // #1629
  {DBGFIELD("VERRr")              30, false, false, false, 2605, 14, 91, 1,  0, 0}, // #1630
  {DBGFIELD("VERWr")              33, false, false, false, 2619, 14, 91, 1,  0, 0}, // #1631
  {DBGFIELD("VHADDPDrr_VHADDPSrr_VHSUBPDrr_VHSUBPSrr") 3, false, false, false, 442, 10, 10, 1,  0, 0}, // #1632
  {DBGFIELD("VLDMXCSR")           3, false, false, false, 2633, 11,  6, 1,  0, 0}, // #1633
  {DBGFIELD("VMOVMSKPDYrr_VMOVMSKPSYrr") 1, false, false, false,  3, 9, 10, 1,  0, 0}, // #1634
  {DBGFIELD("VMOVNTDQmr")         2, false, false, false, 52, 4, 92, 1,  0, 0}, // #1635
  {DBGFIELD("VMOVNTPDmr")         2, false, false, false, 52, 4, 93, 1,  0, 0}, // #1636
  {DBGFIELD("VMOVNTPSYmr")        2, false, false, false, 52, 4, 94, 1,  0, 0}, // #1637
  {DBGFIELD("VMOVNTPSmr")         2, false, false, false, 52, 4, 95, 1,  0, 0}, // #1638
  {DBGFIELD("VPACKSSDWYrm_VPACKSSWBYrm_VPACKUSDWYrm_VPACKUSWBYrm") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1639
  {DBGFIELD("VPCLMULQDQYrmi")     2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1640
  {DBGFIELD("VSHUFPDYrmi_VSHUFPSYrmi") 2, false, false, false, 79, 8, 22, 1,  6, 1}, // #1641
  {DBGFIELD("VPBLENDWYrmi")       2, false, false, false, 79, 8, 22, 1,  6, 1}, // #1642
  {DBGFIELD("WRPKRUr")            8, false, false, false, 2644, 13,  4, 1,  0, 0}, // #1643
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm") 5, false, false, false, 1441, 6, 33, 2,  0, 0}, // #1644
  {DBGFIELD("XCHG16rm")           8, false, false, false, 1945, 9, 49, 2,  0, 0}, // #1645
  {DBGFIELD("XCHG32rm")           8, false, false, false, 1945, 9, 49, 2,  0, 0}, // #1646
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS") 31, false, false, false, 1681, 16, 62, 1,  0, 0}, // #1647
  {DBGFIELD("XSAVEC")             151, false, false, false, 2657, 18, 52, 1,  0, 0}, // #1648
  {DBGFIELD("XSAVEC64")           152, false, false, false, 2675, 18, 52, 1,  0, 0}, // #1649
  {DBGFIELD("XSAVEOPT")           155, false, false, false, 2693, 17, 66, 1,  0, 0}, // #1650
  {DBGFIELD("XSAVES")             184, false, false, false, 2710, 17, 52, 1,  0, 0}, // #1651
  {DBGFIELD("VMOVAPDZrr_VMOVAPDZrr_REV_VMOVAPSZrr_VMOVAPSZrr_REV_VMOVUPDZrr_VMOVUPDZrr_REV_VMOVUPSZrr_VMOVUPSZrr_REV") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1652
  {DBGFIELD("VMOVDQA32Z256rr_VMOVDQA32Z256rr_REV_VMOVDQA64Z256rr_VMOVDQA64Z256rr_REV_VMOVDQAYrr_VMOVDQAYrr_REV_VMOVDQUYrr_VMOVDQUYrr_REV_VMOVDQU16Z256rr_VMOVDQU16Z256rr_REV_VMOVDQU32Z256rr_VMOVDQU32Z256rr_REV_VMOVDQU64Z256rr_VMOVDQU64Z256rr_REV_VMOVDQU8Z256rr_VMOVDQU8Z256rr_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1653
  {DBGFIELD("VMOVDQA32Zrr_VMOVDQA32Zrr_REV_VMOVDQA64Zrr_VMOVDQA64Zrr_REV_VMOVDQU16Zrr_VMOVDQU16Zrr_REV_VMOVDQU32Zrr_VMOVDQU32Zrr_REV_VMOVDQU64Zrr_VMOVDQU64Zrr_REV_VMOVDQU8Zrr_VMOVDQU8Zrr_REV") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1654
  {DBGFIELD("ADDPSrm_SUBPSrm_VADDPSrm_VSUBPSrm_ADDSUBPSrm_VADDSUBPSrm_VADDPSZ128rm_VADDPSZ128rmb_VADDPSZ128rmbk_VADDPSZ128rmk_VADDPSZ128rmkz_VSUBPSZ128rm_VSUBPSZ128rmb_VSUBPSZ128rmbk_VSUBPSZ128rmk_VSUBPSZ128rmkz_VADDPSZ128rmbkz_VSUBPSZ128rmbkz") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #1655
  {DBGFIELD("ADDPSrr_SUBPSrr_VADDPSrr_VSUBPSrr_ADDSUBPSrr_VADDSUBPSrr_VADDPSZ128rr_VADDPSZ128rrk_VSUBPSZ128rr_VSUBPSZ128rrk") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1656
  {DBGFIELD("VADDPSYrr_VSUBPSYrr_VADDPSZ256rr_VADDPSZ256rrk_VSUBPSZ256rr_VSUBPSZ256rrk") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1657
  {DBGFIELD("VPMOVSXBWZ128rrk_VPMOVSXBWZ128rrkz_VPMOVZXBWZ128rrk_VPMOVZXBWZ128rrkz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1658
  {DBGFIELD("VPSHUFBZ128rrk_VPSHUFBZ128rrkz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1659
  {DBGFIELD("VPSHUFBZ256rrk_VPSHUFBZ256rrkz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1660
  {DBGFIELD("VPSHUFHWZ128rik_VPSHUFHWZ128rikz_VPSHUFLWZ128rik_VPSHUFLWZ128rikz_VPUNPCKHBWZ128rrk_VPUNPCKHBWZ128rrkz_VPUNPCKHWDZ128rrk_VPUNPCKHWDZ128rrkz_VPUNPCKLBWZ128rrk_VPUNPCKLBWZ128rrkz_VPUNPCKLWDZ128rrk_VPUNPCKLWDZ128rrkz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1661
  {DBGFIELD("VPSHUFHWZ256rik_VPSHUFHWZ256rikz_VPSHUFLWZ256rik_VPSHUFLWZ256rikz_VPUNPCKHBWZ256rrk_VPUNPCKHBWZ256rrkz_VPUNPCKHWDZ256rrk_VPUNPCKHWDZ256rrkz_VPUNPCKLBWZ256rrk_VPUNPCKLBWZ256rrkz_VPUNPCKLWDZ256rrk_VPUNPCKLWDZ256rrkz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1662
  {DBGFIELD("VADDSUBPSYrr")       1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1663
  {DBGFIELD("VPOPCNTBZ128rm_VPOPCNTDZ128rm_VPOPCNTQZ128rm_VPOPCNTWZ128rm_VPOPCNTDZ128rmb_VPOPCNTDZ128rmk_VPOPCNTDZ128rmkz_VPOPCNTQZ128rmb_VPOPCNTQZ128rmk_VPOPCNTQZ128rmkz_VPOPCNTDZ128rmbk_VPOPCNTDZ128rmbkz_VPOPCNTQZ128rmbk_VPOPCNTQZ128rmbkz") 2, false, false, false, 103, 7,  7, 1,  0, 0}, // #1664
  {DBGFIELD("VFPCLASSPDZ128rmb_VFPCLASSPSZ128rmb") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1665
  {DBGFIELD("VFPCLASSPHZ128rmb")  2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1666
  {DBGFIELD("VPACKSSDWZ128rm_VPACKSSWBZ128rm_VPACKUSDWZ128rm_VPACKUSWBZ128rm_VPACKSSDWZ128rmb_VPACKUSDWZ128rmb") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #1667
  {DBGFIELD("VPMULTISHIFTQBZ128rm_VPMULTISHIFTQBZ128rmb") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #1668
  {DBGFIELD("VFPCLASSPHZ128rm")   2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1669
  {DBGFIELD("VFPCLASSPDZ256rm_VFPCLASSPSZ256rm") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1670
  {DBGFIELD("VFPCLASSPDZrm_VFPCLASSPSZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1671
  {DBGFIELD("VFPCLASSPHZ256rm")   2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1672
  {DBGFIELD("VFPCLASSPHZrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1673
  {DBGFIELD("VPERMBZ128rm")       2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1674
  {DBGFIELD("VPEXPANDBZ128rmk_VPEXPANDBZ128rmkz_VPEXPANDBZ256rmk_VPEXPANDBZ256rmkz_VPEXPANDWZ128rmk_VPEXPANDWZ128rmkz_VPEXPANDWZ256rmk_VPEXPANDWZ256rmkz_VPEXPANDBZrmk_VPEXPANDBZrmkz_VPEXPANDWZrmk_VPEXPANDWZrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1675
  {DBGFIELD("ADD_FPrST0_ADD_FrST0_SUBR_FPrST0_SUBR_FrST0_SUB_FPrST0_SUB_FrST0_SUBR_FST0r_SUB_FST0r") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1676
  {DBGFIELD("KMOVBkr_KMOVDkr_KMOVWkr") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1677
  {DBGFIELD("VCMPPHZ128rri_VCMPPHZ128rrik_VFPCLASSPHZ128rr_VFPCLASSPHZ128rrk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1678
  {DBGFIELD("VCMPPHZ256rri_VCMPPHZ256rrik_VFPCLASSPHZ256rr_VFPCLASSPHZ256rrk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1679
  {DBGFIELD("VCMPSDZrri_VCMPSSZrri_VCMPSDZrri_Int_VCMPSDZrri_Intk_VCMPSSZrri_Int_VCMPSSZrri_Intk_VFPCLASSSDZrr_VFPCLASSSDZrrk_VFPCLASSSSZrr_VFPCLASSSSZrrk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1680
  {DBGFIELD("VCMPSHZrri_VCMPSHZrri_Int_VCMPSHZrri_Intk_VFPCLASSSHZrr_VFPCLASSSHZrrk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1681
  {DBGFIELD("VPACKSSDWZ128rr_VPACKSSWBZ128rr_VPACKUSDWZ128rr_VPACKUSWBZ128rr") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1682
  {DBGFIELD("VPACKSSDWZ256rr_VPACKSSWBZ256rr_VPACKUSDWZ256rr_VPACKUSWBZ256rr") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1683
  {DBGFIELD("VPALIGNRZ128rrik_VPALIGNRZ128rrikz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1684
  {DBGFIELD("VPALIGNRZ256rrik_VPALIGNRZ256rrikz") 1, false, false, false, 87, 6,  1, 1,  0, 0}, // #1685
  {DBGFIELD("VPBROADCASTBZ128rrk_VPBROADCASTBZ128rrkz_VPBROADCASTWZ128rrk_VPBROADCASTWZ128rrkz") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1686
  {DBGFIELD("VPERMBZ128rr")       1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1687
  {DBGFIELD("VPERMBZ256rr_VPERMDZ256rr_VPERMDZ256rrk_VPERMDZ256rrkz_VPERMQZ256rr_VPERMQZ256rrk_VPERMQZ256rrkz_VPERMI2DZ256rr_VPERMI2DZ256rrk_VPERMI2DZ256rrkz_VPERMI2QZ256rr_VPERMI2QZ256rrk_VPERMI2QZ256rrkz_VPERMT2DZ256rr_VPERMT2DZ256rrk_VPERMT2DZ256rrkz_VPERMT2QZ256rr_VPERMT2QZ256rrk_VPERMT2QZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1688
  {DBGFIELD("VPERMBZrr_VPERMDZrr_VPERMDZrrk_VPERMDZrrkz_VPERMI2DZrr_VPERMI2DZrrk_VPERMI2DZrrkz_VPERMI2QZrr_VPERMI2QZrrk_VPERMI2QZrrkz_VPERMT2DZrr_VPERMT2DZrrk_VPERMT2DZrrkz_VPERMT2QZrr_VPERMT2QZrrk_VPERMT2QZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1689
  {DBGFIELD("VPERMQZrr_VPERMQZrrk_VPERMQZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1690
  {DBGFIELD("VPERMI2DZ128rr_VPERMI2DZ128rrk_VPERMI2DZ128rrkz_VPERMI2QZ128rr_VPERMI2QZ128rrk_VPERMI2QZ128rrkz_VPERMT2DZ128rr_VPERMT2DZ128rrk_VPERMT2DZ128rrkz_VPERMT2QZ128rr_VPERMT2QZ128rrk_VPERMT2QZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1691
  {DBGFIELD("VPMULTISHIFTQBZ128rr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1692
  {DBGFIELD("VPMULTISHIFTQBZ256rr_VPOPCNTBZ256rr_VPOPCNTDZ256rr_VPOPCNTQZ256rr_VPOPCNTWZ256rr_VPOPCNTDZ256rrk_VPOPCNTDZ256rrkz_VPOPCNTQZ256rrk_VPOPCNTQZ256rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1693
  {DBGFIELD("VPOPCNTBZ128rr_VPOPCNTDZ128rr_VPOPCNTQZ128rr_VPOPCNTWZ128rr_VPOPCNTDZ128rrk_VPOPCNTDZ128rrkz_VPOPCNTQZ128rrk_VPOPCNTQZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1694
  {DBGFIELD("VMOVSHDUPZ128rr_VMOVSHDUPZ128rrk_VMOVSHDUPZ128rrkz_VMOVSLDUPZ128rr_VMOVSLDUPZ128rrk_VMOVSLDUPZ128rrkz_VSHUFPDZ128rri_VSHUFPDZ128rrik_VSHUFPDZ128rrikz_VSHUFPSZ128rri_VSHUFPSZ128rrik_VSHUFPSZ128rrikz") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1695
  {DBGFIELD("VMOVSHDUPZ256rr_VMOVSHDUPZ256rrk_VMOVSHDUPZ256rrkz_VMOVSLDUPZ256rr_VMOVSLDUPZ256rrk_VMOVSLDUPZ256rrkz_VSHUFPDZ256rri_VSHUFPDZ256rrik_VSHUFPDZ256rrikz_VSHUFPSZ256rri_VSHUFPSZ256rrik_VSHUFPSZ256rrikz") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1696
  {DBGFIELD("VPMOVQDZ128rr_VPMOVQDZ128rrk_VPMOVQDZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1697
  {DBGFIELD("VCVTPD2DQZ128rm_VCVTPD2DQZ128rmb_VCVTPD2DQZ128rmbk_VCVTPD2DQZ128rmk_VCVTPD2DQZ128rmkz_VCVTPD2UDQZ128rm_VCVTPD2UDQZ128rmb_VCVTPD2UDQZ128rmbk_VCVTPD2UDQZ128rmk_VCVTPD2UDQZ128rmkz_VCVTTPD2DQZ128rm_VCVTTPD2DQZ128rmb_VCVTTPD2DQZ128rmbk_VCVTTPD2DQZ128rmk_VCVTTPD2DQZ128rmkz_VCVTTPD2UDQZ128rm_VCVTTPD2UDQZ128rmb_VCVTTPD2UDQZ128rmbk_VCVTTPD2UDQZ128rmk_VCVTTPD2UDQZ128rmkz_VCVTPD2DQZ128rmbkz_VCVTPD2UDQZ128rmbkz_VCVTTPD2DQZ128rmbkz_VCVTTPD2UDQZ128rmbkz") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #1698
  {DBGFIELD("VCVTPH2PSXZ128rm_VCVTPH2PSXZ128rmb") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1699
  {DBGFIELD("VCVTQQ2PSZ128rm_VCVTQQ2PSZ128rmb_VCVTQQ2PSZ128rmbk_VCVTQQ2PSZ128rmk_VCVTQQ2PSZ128rmkz_VCVTUQQ2PSZ128rm_VCVTUQQ2PSZ128rmb_VCVTUQQ2PSZ128rmbk_VCVTUQQ2PSZ128rmk_VCVTUQQ2PSZ128rmkz_VCVTQQ2PSZ128rmbkz_VCVTUQQ2PSZ128rmbkz") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1700
  {DBGFIELD("VCVTSI642SSZrm_VCVTSI642SSZrm_Int_VCVTUSI642SSZrm_VCVTUSI642SSZrm_Int") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1701
  {DBGFIELD("VCVTSD2SIZrm_VCVTTSD2SIZrm_VCVTSD2SIZrm_Int_VCVTTSD2SIZrm_Int") 3, false, false, false, 282, 11,  2, 1,  6, 1}, // #1702
  {DBGFIELD("VCVTSD2USIZrm_Int_VCVTTSD2USIZrm_Int") 3, false, false, false, 282, 11,  2, 1,  6, 1}, // #1703
  {DBGFIELD("CVTSI2SSrr_Int_VCVTSI2SSrr_Int_VCVTSI2SSZrr_VCVTUSI2SSZrr_VCVTSI2SSZrr_Int_VCVTSI2SSZrrb_Int_VCVTUSI2SSZrr_Int_VCVTUSI2SSZrrb_Int") 2, false, false, false, 258, 11,  6, 1,  7, 1}, // #1704
  {DBGFIELD("VCVTSS2SI64Zrr_VCVTTSS2SI64Zrr_VCVTSS2SI64Zrr_Int_VCVTSS2SI64Zrrb_Int_VCVTSS2USI64Zrr_Int_VCVTSS2USI64Zrrb_Int_VCVTTSS2SI64Zrr_Int_VCVTTSS2SI64Zrrb_Int_VCVTTSS2USI64Zrr_Int_VCVTTSS2USI64Zrrb_Int") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #1705
  {DBGFIELD("DIVSDrm_VDIVSDrm")   2, false, false, false, 247, 11, 17, 1,  6, 1}, // #1706
  {DBGFIELD("VDIVSDZrm")          2, false, false, false, 247, 11, 17, 1,  6, 1}, // #1707
  {DBGFIELD("VSQRTSHZm_Int_VSQRTSHZm_Intk_VSQRTSHZm_Intkz") 2, false, false, false, 247, 11, 17, 1,  6, 1}, // #1708
  {DBGFIELD("VSQRTSHZm")          2, false, false, false, 247, 11, 17, 1,  6, 1}, // #1709
  {DBGFIELD("ENQCMD16_ENQCMD32_ENQCMD64_ENQCMDS16_ENQCMDS32_ENQCMDS64") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1710
  {DBGFIELD("VPMOVQDZ256mr_VPMOVQDZmr") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1711
  {DBGFIELD("VEXTRACTPSZmr")      3, false, false, false, 380, 9, 17, 1,  0, 0}, // #1712
  {DBGFIELD("VEXTRACTPSZrr")      2, false, false, false, 389, 11, 14, 1,  0, 0}, // #1713
  {DBGFIELD("VPERMWZrr")          1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1714
  {DBGFIELD("VPEXPANDBZ256rm_VPEXPANDBZrm_VPEXPANDWZ256rm_VPEXPANDWZrm") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1715
  {DBGFIELD("VPADDBZrr_VPADDDZrr_VPADDQZrr_VPADDWZrr_VPADDDZrrk_VPADDDZrrkz_VPADDQZrrk_VPADDQZrrkz_VPSUBDZrrk_VPSUBDZrrkz_VPSUBQZrrk_VPSUBQZrrkz_VPTERNLOGDZrri_VPTERNLOGDZrrik_VPTERNLOGDZrrikz_VPTERNLOGQZrri_VPTERNLOGQZrrik_VPTERNLOGQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1716
  {DBGFIELD("VPLZCNTDZ256rm_VPLZCNTDZ256rmb_VPLZCNTDZ256rmbk_VPLZCNTDZ256rmk_VPLZCNTDZ256rmkz_VPLZCNTQZ256rm_VPLZCNTQZ256rmb_VPLZCNTQZ256rmbk_VPLZCNTQZ256rmk_VPLZCNTQZ256rmkz_VPLZCNTDZ256rmbkz_VPLZCNTQZ256rmbkz") 2, false, false, false, 103, 7, 24, 1,  0, 0}, // #1717
  {DBGFIELD("VADDPHZ128rm_VADDPHZ128rmb_VADDPHZ128rmbk_VADDPHZ128rmk_VADDPHZ128rmkz_VSUBPHZ128rm_VSUBPHZ128rmb_VSUBPHZ128rmbk_VSUBPHZ128rmk_VSUBPHZ128rmkz_VADDPHZ128rmbkz_VSUBPHZ128rmbkz") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #1718
  {DBGFIELD("VGETEXPPHZ128m_VGETEXPPHZ128mb_VGETEXPPHZ128mbk_VGETEXPPHZ128mk_VGETEXPPHZ128mkz_VGETEXPSHZm_VGETEXPSHZmk_VGETEXPSHZmkz_VGETMANTPHZ128rmbi_VGETMANTPHZ128rmik_VGETMANTPHZ128rmbik_VGETMANTPHZ128rmbikz_VGETMANTPHZ128rmi_VGETMANTPHZ128rmikz_VGETMANTSHZrmi_VGETMANTSHZrmik_VGETMANTSHZrmikz") 3, false, false, false, 115, 7, 11, 1,  6, 1}, // #1719
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rmbi_VGF2P8AFFINEINVQBZ128rmi_VGF2P8AFFINEQBZ128rmbi_VGF2P8AFFINEQBZ128rmi") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #1720
  {DBGFIELD("VMAXCPHZ128rm_VMAXCPHZ128rmb_VMAXCPHZ128rmbk_VMAXCPHZ128rmk_VMAXCPHZ128rmkz_VMINCPHZ128rm_VMINCPHZ128rmb_VMINCPHZ128rmbk_VMINCPHZ128rmk_VMINCPHZ128rmkz_VMAXCPHZ128rmbkz_VMINCPHZ128rmbkz_VMAXPHZ128rm_VMAXPHZ128rmb_VMAXPHZ128rmbk_VMAXPHZ128rmk_VMAXPHZ128rmkz_VMINPHZ128rm_VMINPHZ128rmb_VMINPHZ128rmbk_VMINPHZ128rmk_VMINPHZ128rmkz_VMAXPHZ128rmbkz_VMINPHZ128rmbkz") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1721
  {DBGFIELD("VMULPHZ128rm_VMULPHZ128rmb_VMULPHZ128rmbk_VMULPHZ128rmk_VMULPHZ128rmkz_VMULPHZ128rmbkz") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1722
  {DBGFIELD("VGETEXPPHZ128mbkz")  3, false, false, false, 115, 7, 11, 1,  6, 1}, // #1723
  {DBGFIELD("VGF2P8MULBZ128rm")   2, false, false, false, 103, 7,  7, 1,  6, 1}, // #1724
  {DBGFIELD("VADDSHZrm_VSUBSHZrm_VADDSHZrm_Int_VADDSHZrm_Intk_VADDSHZrm_Intkz_VSUBSHZrm_Int_VSUBSHZrm_Intk_VSUBSHZrm_Intkz") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #1725
  {DBGFIELD("VCVTSH2SSZrm_VCVTSH2SSZrm_Int") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1726
  {DBGFIELD("VMAXCSHZrm_VMINCSHZrm_VMAXSHZrm_VMINSHZrm_VMAXSHZrm_Int_VMAXSHZrm_Intk_VMAXSHZrm_Intkz_VMINSHZrm_Int_VMINSHZrm_Intk_VMINSHZrm_Intkz") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1727
  {DBGFIELD("VMULSHZrm_VMULSHZrm_Int_VMULSHZrm_Intk_VMULSHZrm_Intkz") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1728
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rmbi_VGF2P8AFFINEINVQBZ256rmi_VGF2P8AFFINEQBZ256rmbi_VGF2P8AFFINEQBZ256rmi") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #1729
  {DBGFIELD("VGF2P8MULBZ256rm")   2, false, false, false, 103, 7, 22, 1,  6, 1}, // #1730
  {DBGFIELD("VFMADD132PHZ128m_VFMADD132PHZ128mb_VFMADD132PHZ128mbk_VFMADD132PHZ128mk_VFMADD132PHZ128mkz_VFMADD213PHZ128m_VFMADD213PHZ128mb_VFMADD213PHZ128mbk_VFMADD213PHZ128mk_VFMADD213PHZ128mkz_VFMADD231PHZ128m_VFMADD231PHZ128mb_VFMADD231PHZ128mbk_VFMADD231PHZ128mk_VFMADD231PHZ128mkz_VFMSUB132PHZ128m_VFMSUB132PHZ128mb_VFMSUB132PHZ128mbk_VFMSUB132PHZ128mk_VFMSUB132PHZ128mkz_VFMSUB213PHZ128m_VFMSUB213PHZ128mb_VFMSUB213PHZ128mbk_VFMSUB213PHZ128mk_VFMSUB213PHZ128mkz_VFMSUB231PHZ128m_VFMSUB231PHZ128mb_VFMSUB231PHZ128mbk_VFMSUB231PHZ128mk_VFMSUB231PHZ128mkz_VFNMADD132PHZ128m_VFNMADD132PHZ128mb_VFNMADD132PHZ128mbk_VFNMADD132PHZ128mk_VFNMADD132PHZ128mkz_VFNMADD213PHZ128m_VFNMADD213PHZ128mb_VFNMADD213PHZ128mbk_VFNMADD213PHZ128mk_VFNMADD213PHZ128mkz_VFNMADD231PHZ128m_VFNMADD231PHZ128mb_VFNMADD231PHZ128mbk_VFNMADD231PHZ128mk_VFNMADD231PHZ128mkz_VFNMSUB132PHZ128m_VFNMSUB132PHZ128mb_VFNMSUB132PHZ128mbk_VFNMSUB132PHZ128mk_VFNMSUB132PHZ128mkz_VFNMSUB213PHZ128m_VFNMSUB213PHZ128mb_VFNMSUB213PHZ128mbk_VFNMSUB213PHZ128mk_VFNMSUB213PHZ128mkz_VFNMSUB231PHZ128m_VFNMSUB231PHZ128mb_VFNMSUB231PHZ128mbk_VFNMSUB231PHZ128mk_VFNMSUB231PHZ128mkz_VFMADD132PHZ128mbkz_VFMADD213PHZ128mbkz_VFMADD231PHZ128mbkz_VFMSUB132PHZ128mbkz_VFMSUB213PHZ128mbkz_VFMSUB231PHZ128mbkz_VFNMADD132PHZ128mbkz_VFNMADD213PHZ128mbkz_VFNMADD231PHZ128mbkz_VFNMSUB132PHZ128mbkz_VFNMSUB213PHZ128mbkz_VFNMSUB231PHZ128mbkz_VFMADDSUB132PHZ128m_VFMADDSUB132PHZ128mb_VFMADDSUB132PHZ128mbk_VFMADDSUB132PHZ128mk_VFMADDSUB132PHZ128mkz_VFMADDSUB213PHZ128m_VFMADDSUB213PHZ128mb_VFMADDSUB213PHZ128mbk_VFMADDSUB213PHZ128mk_VFMADDSUB213PHZ128mkz_VFMADDSUB231PHZ128m_VFMADDSUB231PHZ128mb_VFMADDSUB231PHZ128mbk_VFMADDSUB231PHZ128mk_VFMADDSUB231PHZ128mkz_VFMADDSUB132PHZ128mbkz_VFMADDSUB213PHZ128mbkz_VFMADDSUB231PHZ128mbkz_VFMSUBADD132PHZ128m_VFMSUBADD132PHZ128mb_VFMSUBADD132PHZ128mbk_VFMSUBADD132PHZ128mk_VFMSUBADD132PHZ128mkz_VFMSUBADD213PHZ128m_VFMSUBADD213PHZ128mb_VFMSUBADD213PHZ128mbk_VFMSUBADD213PHZ128mk_VFMSUBADD213PHZ128mkz_VFMSUBADD231PHZ128m_VFMSUBADD231PHZ128mb_VFMSUBADD231PHZ128mbk_VFMSUBADD231PHZ128mk_VFMSUBADD231PHZ128mkz_VFMSUBADD132PHZ128mbkz_VFMSUBADD213PHZ128mbkz_VFMSUBADD231PHZ128mbkz") 2, false, false, false, 103, 7,  8, 1, 10, 2}, // #1731
  {DBGFIELD("VFMADD132SHZm_VFMADD213SHZm_VFMADD231SHZm_VFMSUB132SHZm_VFMSUB213SHZm_VFMSUB231SHZm_VFNMADD132SHZm_VFNMADD213SHZm_VFNMADD231SHZm_VFNMSUB132SHZm_VFNMSUB213SHZm_VFNMSUB231SHZm_VFMADD132SHZm_Int_VFMADD132SHZm_Intk_VFMADD132SHZm_Intkz_VFMADD213SHZm_Int_VFMADD213SHZm_Intk_VFMADD213SHZm_Intkz_VFMADD231SHZm_Int_VFMADD231SHZm_Intk_VFMADD231SHZm_Intkz_VFMSUB132SHZm_Int_VFMSUB132SHZm_Intk_VFMSUB132SHZm_Intkz_VFMSUB213SHZm_Int_VFMSUB213SHZm_Intk_VFMSUB213SHZm_Intkz_VFMSUB231SHZm_Int_VFMSUB231SHZm_Intk_VFMSUB231SHZm_Intkz_VFNMADD132SHZm_Int_VFNMADD132SHZm_Intk_VFNMADD132SHZm_Intkz_VFNMADD213SHZm_Int_VFNMADD213SHZm_Intk_VFNMADD213SHZm_Intkz_VFNMADD231SHZm_Int_VFNMADD231SHZm_Intk_VFNMADD231SHZm_Intkz_VFNMSUB132SHZm_Int_VFNMSUB132SHZm_Intk_VFNMSUB132SHZm_Intkz_VFNMSUB213SHZm_Int_VFNMSUB213SHZm_Intk_VFNMSUB213SHZm_Intkz_VFNMSUB231SHZm_Int_VFNMSUB231SHZm_Intk_VFNMSUB231SHZm_Intkz") 2, false, false, false, 103, 7,  8, 1, 10, 2}, // #1732
  {DBGFIELD("VPMADD52HUQZ256m_VPMADD52HUQZ256mb_VPMADD52HUQZ256mbk_VPMADD52HUQZ256mk_VPMADD52HUQZ256mkz_VPMADD52LUQZ256m_VPMADD52LUQZ256mb_VPMADD52LUQZ256mbk_VPMADD52LUQZ256mk_VPMADD52LUQZ256mkz_VPMADD52HUQZ256mbkz_VPMADD52LUQZ256mbkz") 2, false, false, false, 103, 7, 24, 1, 10, 2}, // #1733
  {DBGFIELD("VADDPHZ128rr_VSUBPHZ128rr") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1734
  {DBGFIELD("VADDPHZ256rr_VSUBPHZ256rr") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1735
  {DBGFIELD("VADDSHZrr_VSUBSHZrr_VADDSHZrr_Int_VADDSHZrrb_Int_VSUBSHZrr_Int_VSUBSHZrrb_Int") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1736
  {DBGFIELD("VCVTPH2UWZ128rr_VCVTPH2WZ128rr_VCVTTPH2UWZ128rr_VCVTTPH2WZ128rr_VCVTUW2PHZ128rr_VCVTW2PHZ128rr") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1737
  {DBGFIELD("VCVTPH2UWZ256rr_VCVTPH2WZ256rr_VCVTTPH2UWZ256rr_VCVTTPH2WZ256rr_VCVTUW2PHZ256rr_VCVTW2PHZ256rr") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1738
  {DBGFIELD("VCVTSH2SSZrr_Int_VCVTSH2SSZrrb_Int") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1739
  {DBGFIELD("VFMADD132PHZ128r_VFMADD213PHZ128r_VFMADD231PHZ128r_VFMSUB132PHZ128r_VFMSUB213PHZ128r_VFMSUB231PHZ128r_VFNMADD132PHZ128r_VFNMADD213PHZ128r_VFNMADD231PHZ128r_VFNMSUB132PHZ128r_VFNMSUB213PHZ128r_VFNMSUB231PHZ128r_VFMADDSUB132PHZ128r_VFMADDSUB213PHZ128r_VFMADDSUB231PHZ128r_VFMSUBADD132PHZ128r_VFMSUBADD213PHZ128r_VFMSUBADD231PHZ128r") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1740
  {DBGFIELD("VFMADD132PHZ256r_VFMADD213PHZ256r_VFMADD231PHZ256r_VFMSUB132PHZ256r_VFMSUB213PHZ256r_VFMSUB231PHZ256r_VFNMADD132PHZ256r_VFNMADD213PHZ256r_VFNMADD231PHZ256r_VFNMSUB132PHZ256r_VFNMSUB213PHZ256r_VFNMSUB231PHZ256r_VFMADDSUB132PHZ256r_VFMADDSUB213PHZ256r_VFMADDSUB231PHZ256r_VFMSUBADD132PHZ256r_VFMSUBADD213PHZ256r_VFMSUBADD231PHZ256r") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1741
  {DBGFIELD("VFMADD132SHZr_VFMADD132SHZr_Int_VFMADD132SHZrb_VFMADD132SHZrb_Int_VFMADD213SHZr_VFMADD213SHZr_Int_VFMADD213SHZrb_VFMADD213SHZrb_Int_VFMADD231SHZr_VFMADD231SHZr_Int_VFMADD231SHZrb_VFMADD231SHZrb_Int_VFMSUB132SHZr_VFMSUB132SHZr_Int_VFMSUB132SHZrb_VFMSUB132SHZrb_Int_VFMSUB213SHZr_VFMSUB213SHZr_Int_VFMSUB213SHZrb_VFMSUB213SHZrb_Int_VFMSUB231SHZr_VFMSUB231SHZr_Int_VFMSUB231SHZrb_VFMSUB231SHZrb_Int_VFNMADD132SHZr_VFNMADD132SHZr_Int_VFNMADD132SHZrb_VFNMADD132SHZrb_Int_VFNMADD213SHZr_VFNMADD213SHZr_Int_VFNMADD213SHZrb_VFNMADD213SHZrb_Int_VFNMADD231SHZr_VFNMADD231SHZr_Int_VFNMADD231SHZrb_VFNMADD231SHZrb_Int_VFNMSUB132SHZr_VFNMSUB132SHZr_Int_VFNMSUB132SHZrb_VFNMSUB132SHZrb_Int_VFNMSUB213SHZr_VFNMSUB213SHZr_Int_VFNMSUB213SHZrb_VFNMSUB213SHZrb_Int_VFNMSUB231SHZr_VFNMSUB231SHZr_Int_VFNMSUB231SHZrb_VFNMSUB231SHZrb_Int") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1742
  {DBGFIELD("VGETEXPPHZ128r_VGETEXPSHZr_VGETEXPSHZrb_VGETMANTPHZ128rri_VGETMANTSHZrri_VGETMANTSHZrrib") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1743
  {DBGFIELD("VGETEXPPHZ256r_VGETMANTPHZ256rri") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1744
  {DBGFIELD("VGF2P8MULBZ128rr")   1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1745
  {DBGFIELD("VGF2P8MULBZ256rr")   1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1746
  {DBGFIELD("VMAXCPHZ128rr_VMINCPHZ128rr_VMAXPHZ128rr_VMINPHZ128rr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1747
  {DBGFIELD("VMAXCPHZ256rr_VMINCPHZ256rr_VMAXPHZ256rr_VMINPHZ256rr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1748
  {DBGFIELD("VMAXCSHZrr_VMINCSHZrr_VMAXSHZrr_VMINSHZrr_VMAXSHZrr_Int_VMAXSHZrrb_Int_VMINSHZrr_Int_VMINSHZrrb_Int") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1749
  {DBGFIELD("VMULPHZ128rr")       1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1750
  {DBGFIELD("VMULPHZ256rr")       1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1751
  {DBGFIELD("VMULSHZrr_VMULSHZrr_Int_VMULSHZrrb_Int") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1752
  {DBGFIELD("VCVTSH2SSZrr")       2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1753
  {DBGFIELD("VBROADCASTSSZ128rm") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1754
  {DBGFIELD("VMOVDDUPZ128rm_VMOVSHDUPZ128rm_VMOVSLDUPZ128rm") 2, false, false, false, 540, 12,  7, 1,  0, 0}, // #1755
  {DBGFIELD("VPBROADCASTDZ128rm_VPBROADCASTQZ128rm") 2, false, false, false, 79, 8,  7, 1,  0, 0}, // #1756
  {DBGFIELD("VBROADCASTI32X2Z128rm") 2, false, false, false, 79, 8,  7, 1,  0, 0}, // #1757
  {DBGFIELD("KANDBrr_KANDDrr_KANDNDrr_KANDNQrr_KANDNWrr_KANDQrr_KANDWrr_KNOTBrr_KNOTDrr_KNOTQrr_KNOTWrr_KORBrr_KORDrr_KORQrr_KORWrr_KXNORBrr_KXNORDrr_KXNORQrr_KXNORWrr_KXORBrr_KXORDrr_KXORQrr_KXORWrr") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #1758
  {DBGFIELD("VPABSBZrr_VPSUBSBZrr_VPABSDZrr_VPABSQZrr_VPABSWZrr_VPABSDZrrk_VPABSDZrrkz_VPABSQZrrk_VPABSQZrrkz_VPADDSBZrr_VPADDSWZrr_VPADDUSBZrr_VPADDUSWZrr_VPAVGBZrr_VPAVGWZrr_VPMAXSBZrr_VPMAXUDZrr_VPMAXUWZrr_VPMINSBZrr_VPMINUDZrr_VPMINUWZrr_VPMAXSDZrr_VPMAXUBZrr_VPMINSDZrr_VPMINUBZrr_VPMAXSDZrrk_VPMAXSDZrrkz_VPMAXUDZrrk_VPMAXUDZrrkz_VPMINSDZrrk_VPMINSDZrrkz_VPMINUDZrrk_VPMINUDZrrkz_VPMAXSWZrr_VPMINSWZrr_VPSUBSWZrr_VPSUBUSWZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1759
  {DBGFIELD("VPSHLDDZrri_VPSHLDQZrri_VPSHLDWZrri_VPSHRDDZrri_VPSHRDQZrri_VPSHRDWZrri_VPSHLDVDZrk_VPSHLDVDZrkz_VPSHLDVQZrk_VPSHLDVQZrkz_VPSHRDVDZrk_VPSHRDVDZrkz_VPSHRDVQZrk_VPSHRDVQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1760
  {DBGFIELD("VPSHLDVDZr_VPSHLDVQZr_VPSHLDVWZr_VPSHRDVDZr_VPSHRDVQZr_VPSHRDVWZr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1761
  {DBGFIELD("VPSUBUSBZrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1762
  {DBGFIELD("KMOVBkm_KMOVDkm_KMOVQkm_KMOVWkm") 1, false, false, false, 56, 3, 10, 1,  0, 0}, // #1763
  {DBGFIELD("KMOVBmk")            2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1764
  {DBGFIELD("VBROADCASTSSZ128rr_VBROADCASTSSZ128rrk_VBROADCASTSSZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1765
  {DBGFIELD("VPALIGNRZrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1766
  {DBGFIELD("VPSHUFDZri_VPSHUFHWZri_VPSHUFLWZri_VPSHUFDZrik_VPSHUFDZrikz_VPUNPCKHBWZrr_VPUNPCKHWDZrr_VPUNPCKLBWZrr_VPUNPCKLWDZrr_VPUNPCKHDQZrr_VPUNPCKHDQZrrk_VPUNPCKHDQZrrkz_VPUNPCKLDQZrr_VPUNPCKLDQZrrk_VPUNPCKLDQZrrkz_VPUNPCKLQDQZrr_VPUNPCKLQDQZrrk_VPUNPCKLQDQZrrkz_VPUNPCKHQDQZrr_VPUNPCKHQDQZrrk_VPUNPCKHQDQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1767
  {DBGFIELD("VPSHUFBZrr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1768
  {DBGFIELD("VPABSBZrrk_VPABSBZrrkz_VPABSWZrrk_VPABSWZrrkz_VPSUBSBZrrk_VPSUBSBZrrkz_VPSUBSWZrrk_VPSUBSWZrrkz_VPADDSBZrrk_VPADDSBZrrkz_VPADDSWZrrk_VPADDSWZrrkz_VPADDUSBZrrk_VPADDUSBZrrkz_VPADDUSWZrrk_VPADDUSWZrrkz_VPAVGBZrrk_VPAVGBZrrkz_VPAVGWZrrk_VPAVGWZrrkz_VPMAXSBZrrk_VPMAXSBZrrkz_VPMAXUWZrrk_VPMAXUWZrrkz_VPMINSBZrrk_VPMINSBZrrkz_VPMINUWZrrk_VPMINUWZrrkz_VPMAXSWZrrk_VPMAXSWZrrkz_VPMAXUBZrrk_VPMAXUBZrrkz_VPMINSWZrrk_VPMINSWZrrkz_VPMINUBZrrk_VPMINUBZrrkz_VPSUBUSBZrrk_VPSUBUSBZrrkz_VPSUBUSWZrrk_VPSUBUSWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1769
  {DBGFIELD("VPSHLDVWZrk_VPSHLDVWZrkz_VPSHRDVWZrk_VPSHRDVWZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1770
  {DBGFIELD("VPSLLVWZrrk_VPSLLVWZrrkz_VPSRLVWZrrk_VPSRLVWZrrkz_VPSRAVWZrrk_VPSRAVWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1771
  {DBGFIELD("VPSLLWZrik_VPSLLWZrikz_VPSRLWZrik_VPSRLWZrikz_VPSRAWZrik_VPSRAWZrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1772
  {DBGFIELD("VMOVSDto64Zrr")      1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1773
  {DBGFIELD("VCVTPH2DQZ128rr_VCVTPH2UDQZ128rr_VCVTTPH2DQZ128rr_VCVTTPH2UDQZ128rr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1774
  {DBGFIELD("VCVTPH2DQZ256rr_VCVTPH2UDQZ256rr_VCVTTPH2DQZ256rr_VCVTTPH2UDQZ256rr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1775
  {DBGFIELD("VCVTPH2PSXZ256rr")   2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1776
  {DBGFIELD("VCVTPS2PHXZ256rr")   2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1777
  {DBGFIELD("VCVTPH2PSXZ128rr")   2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1778
  {DBGFIELD("VCVTPS2PHXZ128rr")   2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1779
  {DBGFIELD("VPERMWZ128rrk_VPERMWZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1780
  {DBGFIELD("VPERMWZ256rrk_VPERMWZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1781
  {DBGFIELD("VPSLLWZ256rrk_VPSLLWZ256rrkz_VPSRLWZ256rrk_VPSRLWZ256rrkz_VPSRAWZ256rrk_VPSRAWZ256rrkz") 2, false, false, false, 258, 11, 14, 1,  0, 0}, // #1782
  {DBGFIELD("VMOVSHZmr_VMOVWmr")  2, false, false, false, 52, 4,  2, 1,  0, 0}, // #1783
  {DBGFIELD("VBROADCASTF32X2Z256rm_VBROADCASTI32X2Z256rm_VBROADCASTF32X2Zrm_VBROADCASTI32X2Zrm_VPBROADCASTQZrm_VPBROADCASTDZ256rm_VPBROADCASTQZ256rm_VPBROADCASTDZrm") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1784
  {DBGFIELD("VBROADCASTF32X4Z256rm_VBROADCASTI32X4Z256rm_VBROADCASTF32X8rm_VBROADCASTI32X8rm_VBROADCASTF32X4rm_VBROADCASTF64X4rm_VBROADCASTI32X4rm_VBROADCASTI64X4rm_VBROADCASTF64X2Z128rm_VBROADCASTF64X2rm_VBROADCASTI64X2Z128rm_VBROADCASTI64X2rm") 2, false, false, false, 79, 8, 22, 1,  0, 0}, // #1785
  {DBGFIELD("VBROADCASTSSZrm_VBROADCASTSDZ256rm_VBROADCASTSSZ256rm_VBROADCASTSDZrm") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1786
  {DBGFIELD("VMOVDDUPZrm_VMOVSHDUPZrm_VMOVSLDUPZrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1787
  {DBGFIELD("VMOVDDUPZ256rm_VMOVSHDUPZ256rm_VMOVSLDUPZ256rm") 2, false, false, false, 540, 12, 22, 1,  0, 0}, // #1788
  {DBGFIELD("VPMOVDBZrr_VPMOVQBZrr_VPMOVSQBZrr_VPMOVQWZrr_VPMOVSQWZrr_VPMOVSDBZrr_VPMOVUSDBZrr_VPMOVUSQBZrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1789
  {DBGFIELD("VPMOVSWBZrr_VPMOVWBZrr_VPMOVDWZrr_VPMOVSDWZrr_VPMOVUSDWZrr_VPMOVSQDZrr_VPMOVUSQDZrr_VPMOVSQDZrrk_VPMOVSQDZrrkz_VPMOVUSQDZrrk_VPMOVUSQDZrrkz_VPMOVUSWBZrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1790
  {DBGFIELD("VPMOVUSQWZrr")       1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1791
  {DBGFIELD("VBROADCASTF32X2Zrmk_VBROADCASTF32X2Zrmkz_VBROADCASTI32X2Zrmk_VBROADCASTI32X2Zrmkz_VPBROADCASTDZrmk_VPBROADCASTDZrmkz_VPBROADCASTQZrmk_VPBROADCASTQZrmkz") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1792
  {DBGFIELD("VBROADCASTF32X8rmk_VBROADCASTF32X8rmkz_VBROADCASTI32X8rmk_VBROADCASTI32X8rmkz_VBROADCASTF32X4rmk_VBROADCASTF32X4rmkz_VBROADCASTF64X4rmk_VBROADCASTF64X4rmkz_VBROADCASTI32X4rmk_VBROADCASTI32X4rmkz_VBROADCASTI64X4rmk_VBROADCASTI64X4rmkz_VBROADCASTF64X2rmk_VBROADCASTF64X2rmkz_VBROADCASTI64X2rmk_VBROADCASTI64X2rmkz") 2, false, false, false, 79, 8, 22, 1,  0, 0}, // #1793
  {DBGFIELD("VBROADCASTSDZrmk_VBROADCASTSDZrmkz_VBROADCASTSSZrmk_VBROADCASTSSZrmkz") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1794
  {DBGFIELD("VMOVAPDZrmk_VMOVAPDZrmkz_VMOVAPSZrmk_VMOVAPSZrmkz_VMOVUPDZrmk_VMOVUPDZrmkz_VMOVUPSZrmk_VMOVUPSZrmkz") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1795
  {DBGFIELD("VMOVDQA32Zrmk_VMOVDQA32Zrmkz_VMOVDQA64Zrmk_VMOVDQA64Zrmkz_VMOVDQU32Zrmk_VMOVDQU32Zrmkz_VMOVDQU64Zrmk_VMOVDQU64Zrmkz") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1796
  {DBGFIELD("VINSERTF32x4Zrm_VINSERTF32x4Zrmk_VINSERTF32x4Zrmkz_VINSERTF64x4Zrm_VINSERTF64x4Zrmk_VINSERTF64x4Zrmkz_VINSERTF32x8Zrm_VINSERTF32x8Zrmk_VINSERTF32x8Zrmkz_VINSERTF64x2Zrm_VINSERTF64x2Zrmk_VINSERTF64x2Zrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1797
  {DBGFIELD("VINSERTI32x4Zrm_VINSERTI32x4Zrmk_VINSERTI32x4Zrmkz_VINSERTI64x4Zrm_VINSERTI64x4Zrmk_VINSERTI64x4Zrmkz_VINSERTI32x8Zrm_VINSERTI32x8Zrmk_VINSERTI32x8Zrmkz_VINSERTI64x2Zrm_VINSERTI64x2Zrmk_VINSERTI64x2Zrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1798
  {DBGFIELD("VPADDBZrm_VPADDDZrm_VPADDQZrm_VPADDWZrm_VPSUBBZrm_VPSUBDZrm_VPSUBQZrm_VPSUBWZrm_VPADDDZrmb_VPADDDZrmk_VPADDDZrmkz_VPADDQZrmb_VPADDQZrmk_VPADDQZrmkz_VPSUBDZrmb_VPSUBDZrmk_VPSUBDZrmkz_VPSUBQZrmb_VPSUBQZrmk_VPSUBQZrmkz_VPADDDZrmbk_VPADDDZrmbkz_VPADDQZrmbk_VPADDQZrmbkz_VPSUBDZrmbk_VPSUBDZrmbkz_VPSUBQZrmbk_VPSUBQZrmbkz_VPTERNLOGDZrmbi_VPTERNLOGDZrmik_VPTERNLOGQZrmbi_VPTERNLOGQZrmik_VPTERNLOGDZrmbik_VPTERNLOGDZrmbikz_VPTERNLOGQZrmbik_VPTERNLOGQZrmbikz_VPTERNLOGDZrmi_VPTERNLOGDZrmikz_VPTERNLOGQZrmi_VPTERNLOGQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1799
  {DBGFIELD("VPBROADCASTWZrm_VPBROADCASTBZ256rm_VPBROADCASTWZ256rm_VPBROADCASTBZrm") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1800
  {DBGFIELD("VFPCLASSPDZ128rm_VFPCLASSPSZ128rm") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1801
  {DBGFIELD("VFPCLASSSDZrm_VFPCLASSSSZrm") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1802
  {DBGFIELD("VFPCLASSSHZrm")      2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1803
  {DBGFIELD("VPALIGNRZ256rmi")    2, false, false, false, 79, 8, 22, 1,  6, 1}, // #1804
  {DBGFIELD("VPSHUFBZrm")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1805
  {DBGFIELD("MOV16ri_MOV64ri_MOV8ri_MOV16ri_alt_MOV8ri_alt_MOV16rr_MOV16rr_REV_MOV8rr_MOV8rr_REV") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1806
  {DBGFIELD("MOV32ri_MOV32ri_alt") 1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1807
  {DBGFIELD("MOV8rr_NOREX")       1, false, false, false,  1, 2,  1, 1,  0, 0}, // #1808
  {DBGFIELD("VMOVLPDZ128rm_VMOVLPSZ128rm_VSHUFPDZ128rmbi_VSHUFPDZ128rmik_VSHUFPSZ128rmbi_VSHUFPSZ128rmik_VSHUFPDZ128rmbik_VSHUFPDZ128rmbikz_VSHUFPSZ128rmbik_VSHUFPSZ128rmbikz_VSHUFPDZ128rmi_VSHUFPDZ128rmikz_VSHUFPSZ128rmi_VSHUFPSZ128rmikz") 2, false, false, false, 540, 12,  7, 1,  6, 1}, // #1809
  {DBGFIELD("VMOVAPDZ128rrk_VMOVAPDZ128rrk_REV_VMOVAPDZ128rrkz_VMOVAPDZ128rrkz_REV_VMOVAPSZ128rrk_VMOVAPSZ128rrk_REV_VMOVAPSZ128rrkz_VMOVAPSZ128rrkz_REV_VMOVUPDZ128rrk_VMOVUPDZ128rrk_REV_VMOVUPDZ128rrkz_VMOVUPDZ128rrkz_REV_VMOVUPSZ128rrk_VMOVUPSZ128rrk_REV_VMOVUPSZ128rrkz_VMOVUPSZ128rrkz_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1810
  {DBGFIELD("VMOVAPDZ256rrk_VMOVAPDZ256rrk_REV_VMOVAPDZ256rrkz_VMOVAPDZ256rrkz_REV_VMOVAPSZ256rrk_VMOVAPSZ256rrk_REV_VMOVAPSZ256rrkz_VMOVAPSZ256rrkz_REV_VMOVUPDZ256rrk_VMOVUPDZ256rrk_REV_VMOVUPDZ256rrkz_VMOVUPDZ256rrkz_REV_VMOVUPSZ256rrk_VMOVUPSZ256rrk_REV_VMOVUPSZ256rrkz_VMOVUPSZ256rrkz_REV") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1811
  {DBGFIELD("VMOVDQA32Z128rrk_VMOVDQA32Z128rrk_REV_VMOVDQA32Z128rrkz_VMOVDQA32Z128rrkz_REV_VMOVDQA64Z128rrk_VMOVDQA64Z128rrk_REV_VMOVDQA64Z128rrkz_VMOVDQA64Z128rrkz_REV_VMOVDQU32Z128rrk_VMOVDQU32Z128rrk_REV_VMOVDQU32Z128rrkz_VMOVDQU32Z128rrkz_REV_VMOVDQU64Z128rrk_VMOVDQU64Z128rrk_REV_VMOVDQU64Z128rrkz_VMOVDQU64Z128rrkz_REV_VPMOVM2DZ128rr_VPMOVM2QZ128rr") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #1812
  {DBGFIELD("VMOVSHZrr_VMOVSHZrr_REV") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #1813
  {DBGFIELD("VPADDBZ128rr_VPADDDZ128rr_VPADDQZ128rr_VPADDWZ128rr_VPADDDZ128rrk_VPADDDZ128rrkz_VPADDQZ128rrk_VPADDQZ128rrkz_VPSUBDZ128rrk_VPSUBDZ128rrkz_VPSUBQZ128rrk_VPSUBQZ128rrkz_VPTERNLOGDZ128rri_VPTERNLOGDZ128rrik_VPTERNLOGDZ128rrikz_VPTERNLOGQZ128rri_VPTERNLOGQZ128rrik_VPTERNLOGQZ128rrikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1814
  {DBGFIELD("VPADDBZ256rr_VPADDDZ256rr_VPADDQZ256rr_VPADDWZ256rr_VPADDDZ256rrk_VPADDDZ256rrkz_VPADDQZ256rrk_VPADDQZ256rrkz_VPSUBDZ256rrk_VPSUBDZ256rrkz_VPSUBQZ256rrk_VPSUBQZ256rrkz_VPTERNLOGDZ256rri_VPTERNLOGDZ256rrik_VPTERNLOGDZ256rrikz_VPTERNLOGQZ256rri_VPTERNLOGQZ256rrik_VPTERNLOGQZ256rrikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #1815
  {DBGFIELD("VPABSBZrmk_VPABSBZrmkz_VPABSWZrmk_VPABSWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1816
  {DBGFIELD("VPSLLWZmik_VPSLLWZmikz_VPSRLWZmik_VPSRLWZmikz_VPSRAWZmik_VPSRAWZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1817
  {DBGFIELD("VPADDSBZrmk_VPADDSBZrmkz_VPADDSWZrmk_VPADDSWZrmkz_VPADDUSBZrmk_VPADDUSBZrmkz_VPADDUSWZrmk_VPADDUSWZrmkz_VPSUBSBZrmk_VPSUBSBZrmkz_VPSUBSWZrmk_VPSUBSWZrmkz_VPSUBUSBZrmk_VPSUBUSBZrmkz_VPSUBUSWZrmk_VPSUBUSWZrmkz_VPAVGBZrmk_VPAVGBZrmkz_VPAVGWZrmk_VPAVGWZrmkz_VPMAXSBZrmk_VPMAXSBZrmkz_VPMAXUWZrmk_VPMAXUWZrmkz_VPMINSBZrmk_VPMINSBZrmkz_VPMINUWZrmk_VPMINUWZrmkz_VPMAXSWZrmk_VPMAXSWZrmkz_VPMAXUBZrmk_VPMAXUBZrmkz_VPMINSWZrmk_VPMINSWZrmkz_VPMINUBZrmk_VPMINUBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1818
  {DBGFIELD("VPSHLDVWZmk_VPSHLDVWZmkz_VPSHRDVWZmk_VPSHRDVWZmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1819
  {DBGFIELD("VPSLLVWZrmk_VPSLLVWZrmkz_VPSRLVWZrmk_VPSRLVWZrmkz_VPSRAVWZrmk_VPSRAVWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1820
  {DBGFIELD("VPSLLWZrmk_VPSLLWZrmkz_VPSRLWZrmk_VPSRLWZrmkz_VPSRAWZrmk_VPSRAWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1821
  {DBGFIELD("VCOMISHZrr_VCOMISHZrrb_VUCOMISHZrr_VUCOMISHZrrb_VCOMISHZrr_Int_VUCOMISHZrr_Int") 1, false, false, false,  3, 9,  5, 1,  0, 0}, // #1822
  {DBGFIELD("VCVTPD2QQZrrb_VCVTPD2QQZrrbk_VCVTPD2QQZrrk_VCVTPD2QQZrrkz_VCVTPD2UQQZrrb_VCVTPD2UQQZrrbk_VCVTPD2UQQZrrk_VCVTPD2UQQZrrkz_VCVTTPD2QQZrrb_VCVTTPD2QQZrrbk_VCVTTPD2QQZrrk_VCVTTPD2QQZrrkz_VCVTTPD2UQQZrrb_VCVTTPD2UQQZrrbk_VCVTTPD2UQQZrrk_VCVTTPD2UQQZrrkz_VCVTPD2QQZrrbkz_VCVTPD2UQQZrrbkz_VCVTTPD2QQZrrbkz_VCVTTPD2UQQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1823
  {DBGFIELD("VCVTPS2DQZrrb_VCVTPS2DQZrrbk_VCVTPS2DQZrrk_VCVTPS2DQZrrkz_VCVTPS2UDQZrrb_VCVTPS2UDQZrrbk_VCVTPS2UDQZrrk_VCVTPS2UDQZrrkz_VCVTTPS2DQZrrb_VCVTTPS2DQZrrbk_VCVTTPS2DQZrrk_VCVTTPS2DQZrrkz_VCVTTPS2UDQZrrb_VCVTTPS2UDQZrrbk_VCVTTPS2UDQZrrk_VCVTTPS2UDQZrrkz_VCVTPS2DQZrrbkz_VCVTPS2UDQZrrbkz_VCVTTPS2DQZrrbkz_VCVTTPS2UDQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1824
  {DBGFIELD("VMAXCPSZrr_VMAXCPSZrrk_VMAXCPSZrrkz_VMAXPSZrr_VMAXPSZrrk_VMAXPSZrrkz_VMINCPSZrr_VMINCPSZrrk_VMINCPSZrrkz_VMINPSZrr_VMINPSZrrk_VMINPSZrrkz_VMAXPSZrrb_VMAXPSZrrbk_VMAXPSZrrbkz_VMINPSZrrb_VMINPSZrrbk_VMINPSZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1825
  {DBGFIELD("VPLZCNTDZrr_VPLZCNTDZrrk_VPLZCNTDZrrkz_VPLZCNTQZrr_VPLZCNTQZrrk_VPLZCNTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1826
  {DBGFIELD("VPMADD52HUQZr_VPMADD52HUQZrk_VPMADD52HUQZrkz_VPMADD52LUQZr_VPMADD52LUQZrk_VPMADD52LUQZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1827
  {DBGFIELD("VMOVAPDZ128rmk_VMOVAPDZ128rmkz_VMOVAPSZ128rmk_VMOVAPSZ128rmkz_VMOVUPDZ128rmk_VMOVUPDZ128rmkz_VMOVUPSZ128rmk_VMOVUPSZ128rmkz") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1828
  {DBGFIELD("VMOVDQA32Z128rmk_VMOVDQA32Z128rmkz_VMOVDQA64Z128rmk_VMOVDQA64Z128rmkz_VMOVDQU32Z128rmk_VMOVDQU32Z128rmkz_VMOVDQU64Z128rmk_VMOVDQU64Z128rmkz") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1829
  {DBGFIELD("VMOVSDZrmk_VMOVSDZrmkz_VMOVSSZrmk_VMOVSSZrmkz") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #1830
  {DBGFIELD("VPADDBZ128rm_VPADDDZ128rm_VPADDQZ128rm_VPADDWZ128rm_VPSUBBZ128rm_VPSUBDZ128rm_VPSUBQZ128rm_VPSUBWZ128rm_VPADDDZ128rmb_VPADDDZ128rmk_VPADDDZ128rmkz_VPADDQZ128rmb_VPADDQZ128rmk_VPADDQZ128rmkz_VPSUBDZ128rmb_VPSUBDZ128rmk_VPSUBDZ128rmkz_VPSUBQZ128rmb_VPSUBQZ128rmk_VPSUBQZ128rmkz_VPADDDZ128rmbk_VPADDDZ128rmbkz_VPADDQZ128rmbk_VPADDQZ128rmbkz_VPSUBDZ128rmbk_VPSUBDZ128rmbkz_VPSUBQZ128rmbk_VPSUBQZ128rmbkz_VPTERNLOGDZ128rmbi_VPTERNLOGDZ128rmik_VPTERNLOGQZ128rmbi_VPTERNLOGQZ128rmik_VPTERNLOGDZ128rmbik_VPTERNLOGDZ128rmbikz_VPTERNLOGQZ128rmbik_VPTERNLOGQZ128rmbikz_VPTERNLOGDZ128rmi_VPTERNLOGDZ128rmikz_VPTERNLOGQZ128rmi_VPTERNLOGQZ128rmikz") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #1831
  {DBGFIELD("VPBROADCASTBZ128rm_VPBROADCASTWZ128rm") 2, false, false, false, 79, 8,  7, 1,  0, 0}, // #1832
  {DBGFIELD("VPALIGNRZ128rmi")    2, false, false, false, 79, 8,  7, 1,  6, 1}, // #1833
  {DBGFIELD("VPEXTRDZmr_VPEXTRQZmr") 3, false, false, false, 380, 9, 17, 1,  0, 0}, // #1834
  {DBGFIELD("VPMOVQDZ128mr_VPMOVQDZ128mrk") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1835
  {DBGFIELD("ROUNDPDmi_ROUNDPSmi_VROUNDPDmi_VROUNDPSmi") 3, false, false, false, 115, 7, 11, 1,  0, 0}, // #1836
  {DBGFIELD("ROUNDSDmi_ROUNDSDmi_Int_ROUNDSSmi_ROUNDSSmi_Int_VROUNDSDmi_VROUNDSDmi_Int_VROUNDSSmi_VROUNDSSmi_Int_VRNDSCALEPDZ128rmbi_VRNDSCALEPDZ128rmik_VRNDSCALEPSZ128rmbi_VRNDSCALEPSZ128rmik_VRNDSCALEPDZ128rmbik_VRNDSCALEPDZ128rmbikz_VRNDSCALEPSZ128rmbik_VRNDSCALEPSZ128rmbikz_VRNDSCALEPDZ128rmi_VRNDSCALEPDZ128rmikz_VRNDSCALEPSZ128rmi_VRNDSCALEPSZ128rmikz_VRNDSCALESDZm_VRNDSCALESSZm_VRNDSCALESDZm_Int_VRNDSCALESDZm_Intk_VRNDSCALESDZm_Intkz_VRNDSCALESSZm_Int_VRNDSCALESSZm_Intk_VRNDSCALESSZm_Intkz") 3, false, false, false, 115, 7, 11, 1,  6, 1}, // #1837
  {DBGFIELD("ROUNDPDri_ROUNDSSri_VROUNDPDri_VROUNDSSri_ROUNDPSri_ROUNDSDri_VROUNDPSri_VROUNDSDri_ROUNDSDri_Int_ROUNDSSri_Int_VROUNDSDri_Int_VROUNDSSri_Int_VRNDSCALEPDZ128rri_VRNDSCALEPDZ128rrik_VRNDSCALEPDZ128rrikz_VRNDSCALEPSZ128rri_VRNDSCALEPSZ128rrik_VRNDSCALEPSZ128rrikz_VRNDSCALESDZr_VRNDSCALESSZr_VRNDSCALESDZr_Int_VRNDSCALESDZr_Intk_VRNDSCALESDZr_Intkz_VRNDSCALESDZrb_Int_VRNDSCALESDZrb_Intk_VRNDSCALESDZrb_Intkz_VRNDSCALESSZr_Int_VRNDSCALESSZr_Intk_VRNDSCALESSZr_Intkz_VRNDSCALESSZrb_Int_VRNDSCALESSZrb_Intk_VRNDSCALESSZrb_Intkz") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1838
  {DBGFIELD("VRNDSCALEPDZ256rri_VRNDSCALEPDZ256rrik_VRNDSCALEPDZ256rrikz_VRNDSCALEPSZ256rri_VRNDSCALEPSZ256rrik_VRNDSCALEPSZ256rrikz_VROUNDPDYri_VROUNDPSYri") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1839
  {DBGFIELD("VPMOVSXBWZ256rmk_VPMOVSXBWZ256rmkz_VPMOVSXBWZrmk_VPMOVSXBWZrmkz_VPMOVZXBWZ256rmk_VPMOVZXBWZ256rmkz_VPMOVZXBWZrmk_VPMOVZXBWZrmkz") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1840
  {DBGFIELD("VPOPCNTBZ128rmk_VPOPCNTBZ128rmkz_VPOPCNTWZ128rmk_VPOPCNTWZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  0, 0}, // #1841
  {DBGFIELD("VPOPCNTBZ256rmk_VPOPCNTBZ256rmkz_VPOPCNTWZ256rmk_VPOPCNTWZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  0, 0}, // #1842
  {DBGFIELD("VPOPCNTBZrmk_VPOPCNTBZrmkz_VPOPCNTWZrmk_VPOPCNTWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1843
  {DBGFIELD("VDBPSADBWZ128rmik_VDBPSADBWZ128rmikz") 2, false, false, false, 540, 12,  9, 1,  6, 1}, // #1844
  {DBGFIELD("VPMULTISHIFTQBZ128rmbk_VPMULTISHIFTQBZ128rmkz_VPMULTISHIFTQBZ128rmbkz_VPMULTISHIFTQBZ128rmk") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #1845
  {DBGFIELD("VDBPSADBWZ256rmik_VDBPSADBWZ256rmikz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1846
  {DBGFIELD("VDBPSADBWZrmik_VDBPSADBWZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1847
  {DBGFIELD("VPACKSSDWZ256rmbk_VPACKSSDWZ256rmkz_VPACKUSDWZ256rmbk_VPACKUSDWZ256rmkz_VPACKSSDWZ256rmbkz_VPACKUSDWZ256rmbkz_VPACKSSDWZ256rmk_VPACKSSWBZ256rmk_VPACKUSDWZ256rmk_VPACKUSWBZ256rmk_VPACKSSWBZ256rmkz_VPACKUSWBZ256rmkz") 2, false, false, false, 79, 8, 22, 1,  6, 1}, // #1848
  {DBGFIELD("VPACKSSDWZrmbk_VPACKSSDWZrmkz_VPACKUSDWZrmbk_VPACKUSDWZrmkz_VPACKSSDWZrmbkz_VPACKUSDWZrmbkz_VPACKSSDWZrmk_VPACKSSWBZrmk_VPACKUSDWZrmk_VPACKUSWBZrmk_VPACKSSWBZrmkz_VPACKUSWBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1849
  {DBGFIELD("VPERMBZ128rmk_VPERMBZ128rmkz_VPERMBZ256rmk_VPERMBZ256rmkz_VPERMBZrmk_VPERMBZrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #1850
  {DBGFIELD("VPMULTISHIFTQBZ256rmbk_VPMULTISHIFTQBZ256rmkz_VPMULTISHIFTQBZ256rmbkz_VPMULTISHIFTQBZ256rmk") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #1851
  {DBGFIELD("VPMULTISHIFTQBZrmbk_VPMULTISHIFTQBZrmkz_VPMULTISHIFTQBZrmbkz_VPMULTISHIFTQBZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1852
  {DBGFIELD("VSQRTSDZm_Int")      2, false, false, false, 247, 11, 18, 1,  6, 1}, // #1853
  {DBGFIELD("VADDPDZ128rrkz_VSUBPDZ128rrkz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1854
  {DBGFIELD("VADDPDZ256rrkz_VSUBPDZ256rrkz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1855
  {DBGFIELD("VADDPSZ128rrkz_VSUBPSZ128rrkz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1856
  {DBGFIELD("VADDPSZ256rrkz_VSUBPSZ256rrkz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1857
  {DBGFIELD("VADDSDZrr_Intkz_VADDSDZrrb_Intkz_VSUBSDZrr_Intkz_VSUBSDZrrb_Intkz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1858
  {DBGFIELD("VADDSSZrr_Intkz_VADDSSZrrb_Intkz_VSUBSSZrr_Intkz_VSUBSSZrrb_Intkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1859
  {DBGFIELD("VADDPDZrr_VADDPDZrrb_VSUBPDZrr_VSUBPDZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1860
  {DBGFIELD("VADDPSZrr_VADDPSZrrb_VSUBPSZrr_VSUBPSZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1861
  {DBGFIELD("VMOVDQU16Zrrk_VMOVDQU16Zrrk_REV_VMOVDQU16Zrrkz_VMOVDQU16Zrrkz_REV_VMOVDQU8Zrrk_VMOVDQU8Zrrk_REV_VMOVDQU8Zrrkz_VMOVDQU8Zrrkz_REV_VPMOVM2BZrr_VPMOVM2WZrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1862
  {DBGFIELD("VPBLENDMBZrrk_VPBLENDMBZrrkz_VPBLENDMWZrrk_VPBLENDMWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1863
  {DBGFIELD("VADDPHZ128rrk_VADDPHZ128rrkz_VSUBPHZ128rrk_VSUBPHZ128rrkz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1864
  {DBGFIELD("VADDPHZ256rrk_VADDPHZ256rrkz_VSUBPHZ256rrk_VSUBPHZ256rrkz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #1865
  {DBGFIELD("VADDSHZrr_Intk_VADDSHZrr_Intkz_VADDSHZrrb_Intk_VADDSHZrrb_Intkz_VSUBSHZrr_Intk_VSUBSHZrr_Intkz_VSUBSHZrrb_Intk_VSUBSHZrrb_Intkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1866
  {DBGFIELD("VCVTPH2UWZ128rrk_VCVTPH2UWZ128rrkz_VCVTPH2WZ128rrk_VCVTPH2WZ128rrkz_VCVTTPH2UWZ128rrk_VCVTTPH2UWZ128rrkz_VCVTTPH2WZ128rrk_VCVTTPH2WZ128rrkz_VCVTUW2PHZ128rrk_VCVTUW2PHZ128rrkz_VCVTW2PHZ128rrk_VCVTW2PHZ128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1867
  {DBGFIELD("VCVTPH2UWZ256rrk_VCVTPH2UWZ256rrkz_VCVTPH2WZ256rrk_VCVTPH2WZ256rrkz_VCVTTPH2UWZ256rrk_VCVTTPH2UWZ256rrkz_VCVTTPH2WZ256rrk_VCVTTPH2WZ256rrkz_VCVTUW2PHZ256rrk_VCVTUW2PHZ256rrkz_VCVTW2PHZ256rrk_VCVTW2PHZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1868
  {DBGFIELD("VFMADD132PHZ128rk_VFMADD132PHZ128rkz_VFMADD213PHZ128rk_VFMADD213PHZ128rkz_VFMADD231PHZ128rk_VFMADD231PHZ128rkz_VFMSUB132PHZ128rk_VFMSUB132PHZ128rkz_VFMSUB213PHZ128rk_VFMSUB213PHZ128rkz_VFMSUB231PHZ128rk_VFMSUB231PHZ128rkz_VFNMADD132PHZ128rk_VFNMADD132PHZ128rkz_VFNMADD213PHZ128rk_VFNMADD213PHZ128rkz_VFNMADD231PHZ128rk_VFNMADD231PHZ128rkz_VFNMSUB132PHZ128rk_VFNMSUB132PHZ128rkz_VFNMSUB213PHZ128rk_VFNMSUB213PHZ128rkz_VFNMSUB231PHZ128rk_VFNMSUB231PHZ128rkz_VFMADDSUB132PHZ128rk_VFMADDSUB132PHZ128rkz_VFMADDSUB213PHZ128rk_VFMADDSUB213PHZ128rkz_VFMADDSUB231PHZ128rk_VFMADDSUB231PHZ128rkz_VFMSUBADD132PHZ128rk_VFMSUBADD132PHZ128rkz_VFMSUBADD213PHZ128rk_VFMSUBADD213PHZ128rkz_VFMSUBADD231PHZ128rk_VFMSUBADD231PHZ128rkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1869
  {DBGFIELD("VFMADD132PHZ256rk_VFMADD132PHZ256rkz_VFMADD213PHZ256rk_VFMADD213PHZ256rkz_VFMADD231PHZ256rk_VFMADD231PHZ256rkz_VFMSUB132PHZ256rk_VFMSUB132PHZ256rkz_VFMSUB213PHZ256rk_VFMSUB213PHZ256rkz_VFMSUB231PHZ256rk_VFMSUB231PHZ256rkz_VFNMADD132PHZ256rk_VFNMADD132PHZ256rkz_VFNMADD213PHZ256rk_VFNMADD213PHZ256rkz_VFNMADD231PHZ256rk_VFNMADD231PHZ256rkz_VFNMSUB132PHZ256rk_VFNMSUB132PHZ256rkz_VFNMSUB213PHZ256rk_VFNMSUB213PHZ256rkz_VFNMSUB231PHZ256rk_VFNMSUB231PHZ256rkz_VFMADDSUB132PHZ256rk_VFMADDSUB132PHZ256rkz_VFMADDSUB213PHZ256rk_VFMADDSUB213PHZ256rkz_VFMADDSUB231PHZ256rk_VFMADDSUB231PHZ256rkz_VFMSUBADD132PHZ256rk_VFMSUBADD132PHZ256rkz_VFMSUBADD213PHZ256rk_VFMSUBADD213PHZ256rkz_VFMSUBADD231PHZ256rk_VFMSUBADD231PHZ256rkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1870
  {DBGFIELD("VFMADD132SHZr_Intk_VFMADD132SHZr_Intkz_VFMADD132SHZrb_Intk_VFMADD132SHZrb_Intkz_VFMADD213SHZr_Intk_VFMADD213SHZr_Intkz_VFMADD213SHZrb_Intk_VFMADD213SHZrb_Intkz_VFMADD231SHZr_Intk_VFMADD231SHZr_Intkz_VFMADD231SHZrb_Intk_VFMADD231SHZrb_Intkz_VFMSUB132SHZr_Intk_VFMSUB132SHZr_Intkz_VFMSUB132SHZrb_Intk_VFMSUB132SHZrb_Intkz_VFMSUB213SHZr_Intk_VFMSUB213SHZr_Intkz_VFMSUB213SHZrb_Intk_VFMSUB213SHZrb_Intkz_VFMSUB231SHZr_Intk_VFMSUB231SHZr_Intkz_VFMSUB231SHZrb_Intk_VFMSUB231SHZrb_Intkz_VFNMADD132SHZr_Intk_VFNMADD132SHZr_Intkz_VFNMADD132SHZrb_Intk_VFNMADD132SHZrb_Intkz_VFNMADD213SHZr_Intk_VFNMADD213SHZr_Intkz_VFNMADD213SHZrb_Intk_VFNMADD213SHZrb_Intkz_VFNMADD231SHZr_Intk_VFNMADD231SHZr_Intkz_VFNMADD231SHZrb_Intk_VFNMADD231SHZrb_Intkz_VFNMSUB132SHZr_Intk_VFNMSUB132SHZr_Intkz_VFNMSUB132SHZrb_Intk_VFNMSUB132SHZrb_Intkz_VFNMSUB213SHZr_Intk_VFNMSUB213SHZr_Intkz_VFNMSUB213SHZrb_Intk_VFNMSUB213SHZrb_Intkz_VFNMSUB231SHZr_Intk_VFNMSUB231SHZr_Intkz_VFNMSUB231SHZrb_Intk_VFNMSUB231SHZrb_Intkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1871
  {DBGFIELD("VGETEXPPHZ128rk_VGETEXPPHZ128rkz_VGETEXPSHZrbk_VGETEXPSHZrkz_VGETEXPSHZrbkz_VGETEXPSHZrk_VGETMANTPHZ128rrik_VGETMANTPHZ128rrikz_VGETMANTSHZrribk_VGETMANTSHZrrikz_VGETMANTSHZrribkz_VGETMANTSHZrrik") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1872
  {DBGFIELD("VGETEXPPHZ256rk_VGETEXPPHZ256rkz_VGETMANTPHZ256rrik_VGETMANTPHZ256rrikz") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #1873
  {DBGFIELD("VMAXCPHZ128rrk_VMAXCPHZ128rrkz_VMINCPHZ128rrk_VMINCPHZ128rrkz_VMAXPHZ128rrk_VMAXPHZ128rrkz_VMINPHZ128rrk_VMINPHZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1874
  {DBGFIELD("VMAXCPHZ256rrk_VMAXCPHZ256rrkz_VMINCPHZ256rrk_VMINCPHZ256rrkz_VMAXPHZ256rrk_VMAXPHZ256rrkz_VMINPHZ256rrk_VMINPHZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1875
  {DBGFIELD("VMULPHZ128rrk_VMULPHZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1876
  {DBGFIELD("VMULPHZ256rrk_VMULPHZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1877
  {DBGFIELD("VMAXSHZrr_Intk_VMAXSHZrr_Intkz_VMAXSHZrrb_Intk_VMAXSHZrrb_Intkz_VMINSHZrr_Intk_VMINSHZrr_Intkz_VMINSHZrrb_Intk_VMINSHZrrb_Intkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1878
  {DBGFIELD("VMULSHZrr_Intk_VMULSHZrr_Intkz_VMULSHZrrb_Intk_VMULSHZrrb_Intkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1879
  {DBGFIELD("VADDPHZrr_VADDPHZrrb_VSUBPHZrr_VSUBPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1880
  {DBGFIELD("VAESDECLASTZrr_VAESDECZrr_VAESENCLASTZrr_VAESENCZrr") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #1881
  {DBGFIELD("VCVTPH2UWZrr_VCVTPH2UWZrrb_VCVTPH2WZrr_VCVTPH2WZrrb_VCVTTPH2UWZrr_VCVTTPH2UWZrrb_VCVTTPH2WZrr_VCVTTPH2WZrrb_VCVTUW2PHZrr_VCVTUW2PHZrrb_VCVTW2PHZrr_VCVTW2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1882
  {DBGFIELD("VFMADD132PHZr_VFMADD132PHZrb_VFMADD213PHZr_VFMADD213PHZrb_VFMADD231PHZr_VFMADD231PHZrb_VFMSUB132PHZr_VFMSUB132PHZrb_VFMSUB213PHZr_VFMSUB213PHZrb_VFMSUB231PHZr_VFMSUB231PHZrb_VFNMADD132PHZr_VFNMADD132PHZrb_VFNMADD213PHZr_VFNMADD213PHZrb_VFNMADD231PHZr_VFNMADD231PHZrb_VFNMSUB132PHZr_VFNMSUB132PHZrb_VFNMSUB213PHZr_VFNMSUB213PHZrb_VFNMSUB231PHZr_VFNMSUB231PHZrb_VFMADDSUB132PHZr_VFMADDSUB132PHZrb_VFMADDSUB213PHZr_VFMADDSUB213PHZrb_VFMADDSUB231PHZr_VFMADDSUB231PHZrb_VFMSUBADD132PHZr_VFMSUBADD132PHZrb_VFMSUBADD213PHZr_VFMSUBADD213PHZrb_VFMSUBADD231PHZr_VFMSUBADD231PHZrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1883
  {DBGFIELD("VGETEXPPHZr_VGETEXPPHZrb_VGETMANTPHZrri_VGETMANTPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1884
  {DBGFIELD("VMAXCPHZrr_VMINCPHZrr_VMAXPHZrr_VMAXPHZrrb_VMINPHZrr_VMINPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1885
  {DBGFIELD("VMULPHZrr_VMULPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1886
  {DBGFIELD("VGF2P8MULBZrr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1887
  {DBGFIELD("VADDPHZrrbk_VADDPHZrrkz_VSUBPHZrrbk_VSUBPHZrrkz_VADDPHZrrbkz_VADDPHZrrk_VSUBPHZrrbkz_VSUBPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1888
  {DBGFIELD("VCVTPH2UWZrrbk_VCVTPH2UWZrrkz_VCVTPH2WZrrbk_VCVTPH2WZrrkz_VCVTTPH2UWZrrbk_VCVTTPH2UWZrrkz_VCVTTPH2WZrrbk_VCVTTPH2WZrrkz_VCVTPH2UWZrrbkz_VCVTPH2UWZrrk_VCVTPH2WZrrbkz_VCVTPH2WZrrk_VCVTTPH2UWZrrbkz_VCVTTPH2UWZrrk_VCVTTPH2WZrrbkz_VCVTTPH2WZrrk_VCVTUW2PHZrrbk_VCVTUW2PHZrrkz_VCVTW2PHZrrbk_VCVTW2PHZrrkz_VCVTUW2PHZrrbkz_VCVTUW2PHZrrk_VCVTW2PHZrrbkz_VCVTW2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1889
  {DBGFIELD("VFMADD132PHZrbk_VFMADD132PHZrkz_VFMADD213PHZrbk_VFMADD213PHZrkz_VFMADD231PHZrbk_VFMADD231PHZrkz_VFMSUB132PHZrbk_VFMSUB132PHZrkz_VFMSUB213PHZrbk_VFMSUB213PHZrkz_VFMSUB231PHZrbk_VFMSUB231PHZrkz_VFNMADD132PHZrbk_VFNMADD132PHZrkz_VFNMADD213PHZrbk_VFNMADD213PHZrkz_VFNMADD231PHZrbk_VFNMADD231PHZrkz_VFNMSUB132PHZrbk_VFNMSUB132PHZrkz_VFNMSUB213PHZrbk_VFNMSUB213PHZrkz_VFNMSUB231PHZrbk_VFNMSUB231PHZrkz_VFMADD132PHZrbkz_VFMADD132PHZrk_VFMADD213PHZrbkz_VFMADD213PHZrk_VFMADD231PHZrbkz_VFMADD231PHZrk_VFMSUB132PHZrbkz_VFMSUB132PHZrk_VFMSUB213PHZrbkz_VFMSUB213PHZrk_VFMSUB231PHZrbkz_VFMSUB231PHZrk_VFNMADD132PHZrbkz_VFNMADD132PHZrk_VFNMADD213PHZrbkz_VFNMADD213PHZrk_VFNMADD231PHZrbkz_VFNMADD231PHZrk_VFNMSUB132PHZrbkz_VFNMSUB132PHZrk_VFNMSUB213PHZrbkz_VFNMSUB213PHZrk_VFNMSUB231PHZrbkz_VFNMSUB231PHZrk_VFMADDSUB132PHZrbk_VFMADDSUB132PHZrkz_VFMADDSUB213PHZrbk_VFMADDSUB213PHZrkz_VFMADDSUB231PHZrbk_VFMADDSUB231PHZrkz_VFMADDSUB132PHZrbkz_VFMADDSUB132PHZrk_VFMADDSUB213PHZrbkz_VFMADDSUB213PHZrk_VFMADDSUB231PHZrbkz_VFMADDSUB231PHZrk_VFMSUBADD132PHZrbk_VFMSUBADD132PHZrkz_VFMSUBADD213PHZrbk_VFMSUBADD213PHZrkz_VFMSUBADD231PHZrbk_VFMSUBADD231PHZrkz_VFMSUBADD132PHZrbkz_VFMSUBADD132PHZrk_VFMSUBADD213PHZrbkz_VFMSUBADD213PHZrk_VFMSUBADD231PHZrbkz_VFMSUBADD231PHZrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1890
  {DBGFIELD("VGETEXPPHZrbk_VGETEXPPHZrkz_VGETEXPPHZrbkz_VGETEXPPHZrk_VGETMANTPHZrribk_VGETMANTPHZrrikz_VGETMANTPHZrribkz_VGETMANTPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1891
  {DBGFIELD("VMAXCPHZrrk_VMAXCPHZrrkz_VMINCPHZrrk_VMINCPHZrrkz_VMAXPHZrrbk_VMAXPHZrrkz_VMINPHZrrbk_VMINPHZrrkz_VMAXPHZrrbkz_VMAXPHZrrk_VMINPHZrrbkz_VMINPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1892
  {DBGFIELD("VMULPHZrrbk_VMULPHZrrkz_VMULPHZrrbkz_VMULPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1893
  {DBGFIELD("VPMOVSXBWZ128rmk_VPMOVSXBWZ128rmkz_VPMOVZXBWZ128rmk_VPMOVZXBWZ128rmkz_VPSHUFHWZ128mik_VPSHUFHWZ128mikz_VPSHUFLWZ128mik_VPSHUFLWZ128mikz") 2, false, false, false, 79, 8,  7, 1,  0, 0}, // #1894
  {DBGFIELD("VPSHUFHWZ256mik_VPSHUFHWZ256mikz_VPSHUFLWZ256mik_VPSHUFLWZ256mikz") 2, false, false, false, 79, 8, 22, 1,  0, 0}, // #1895
  {DBGFIELD("VADDPSYrm_VSUBPSYrm_VADDPSZ256rm_VADDPSZ256rmb_VADDPSZ256rmbk_VADDPSZ256rmk_VADDPSZ256rmkz_VSUBPSZ256rm_VSUBPSZ256rmb_VSUBPSZ256rmbk_VSUBPSZ256rmk_VSUBPSZ256rmkz_VADDPSZ256rmbkz_VSUBPSZ256rmbkz") 2, false, false, false, 79, 8,  8, 1,  6, 1}, // #1896
  {DBGFIELD("VPSHUFBZ256rmk_VPSHUFBZ256rmkz") 2, false, false, false, 79, 8, 22, 1,  6, 1}, // #1897
  {DBGFIELD("VPUNPCKHBWZ256rmk_VPUNPCKHBWZ256rmkz_VPUNPCKHWDZ256rmk_VPUNPCKHWDZ256rmkz_VPUNPCKLBWZ256rmk_VPUNPCKLBWZ256rmkz_VPUNPCKLWDZ256rmk_VPUNPCKLWDZ256rmkz") 2, false, false, false, 79, 8, 22, 1,  6, 1}, // #1898
  {DBGFIELD("VADDSUBPSYrm")       2, false, false, false, 79, 8,  8, 1,  6, 1}, // #1899
  {DBGFIELD("VPSHUFBZ128rmk_VPSHUFBZ128rmkz") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #1900
  {DBGFIELD("VPUNPCKHBWZ128rmk_VPUNPCKHBWZ128rmkz_VPUNPCKHWDZ128rmk_VPUNPCKHWDZ128rmkz_VPUNPCKLBWZ128rmk_VPUNPCKLBWZ128rmkz_VPUNPCKLWDZ128rmk_VPUNPCKLWDZ128rmkz") 2, false, false, false, 79, 8,  7, 1,  6, 1}, // #1901
  {DBGFIELD("VMOVDQU16Zrmk_VMOVDQU16Zrmkz_VMOVDQU8Zrmk_VMOVDQU8Zrmkz") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1902
  {DBGFIELD("VADDPSZrm_VADDPSZrmb_VADDPSZrmbk_VADDPSZrmk_VADDPSZrmkz_VSUBPSZrm_VSUBPSZrmb_VSUBPSZrmbk_VSUBPSZrmk_VSUBPSZrmkz_VADDPSZrmbkz_VSUBPSZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1903
  {DBGFIELD("VPBLENDMBZrmk_VPBLENDMBZrmkz_VPBLENDMWZrmk_VPBLENDMWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1904
  {DBGFIELD("VADDPSZrrbk_VADDPSZrrkz_VSUBPSZrrbk_VSUBPSZrrkz_VADDPSZrrbkz_VADDPSZrrk_VSUBPSZrrbkz_VSUBPSZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1905
  {DBGFIELD("VPLZCNTDZrm_VPLZCNTDZrmb_VPLZCNTDZrmbk_VPLZCNTDZrmk_VPLZCNTDZrmkz_VPLZCNTQZrm_VPLZCNTQZrmb_VPLZCNTQZrmbk_VPLZCNTQZrmk_VPLZCNTQZrmkz_VPLZCNTDZrmbkz_VPLZCNTQZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1906
  {DBGFIELD("VAESDECLASTZrm_VAESDECZrm_VAESENCLASTZrm_VAESENCZrm") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1907
  {DBGFIELD("VGF2P8AFFINEINVQBZrmbi_VGF2P8AFFINEINVQBZrmi_VGF2P8AFFINEQBZrmbi_VGF2P8AFFINEQBZrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1908
  {DBGFIELD("VGF2P8MULBZrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1909
  {DBGFIELD("VPMADD52HUQZm_VPMADD52HUQZmb_VPMADD52HUQZmbk_VPMADD52HUQZmk_VPMADD52HUQZmkz_VPMADD52LUQZm_VPMADD52LUQZmb_VPMADD52LUQZmbk_VPMADD52LUQZmk_VPMADD52LUQZmkz_VPMADD52HUQZmbkz_VPMADD52LUQZmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1910
  {DBGFIELD("VPOPCNTBZ256rm_VPOPCNTDZ256rm_VPOPCNTQZ256rm_VPOPCNTWZ256rm_VPOPCNTDZ256rmb_VPOPCNTDZ256rmk_VPOPCNTDZ256rmkz_VPOPCNTQZ256rmb_VPOPCNTQZ256rmk_VPOPCNTQZ256rmkz_VPOPCNTDZ256rmbk_VPOPCNTDZ256rmbkz_VPOPCNTQZ256rmbk_VPOPCNTQZ256rmbkz") 2, false, false, false, 103, 7, 22, 1,  0, 0}, // #1911
  {DBGFIELD("VPOPCNTBZrm_VPOPCNTDZrm_VPOPCNTQZrm_VPOPCNTWZrm_VPOPCNTDZrmb_VPOPCNTDZrmk_VPOPCNTDZrmkz_VPOPCNTQZrmb_VPOPCNTQZrmk_VPOPCNTQZrmkz_VPOPCNTDZrmbk_VPOPCNTDZrmbkz_VPOPCNTQZrmbk_VPOPCNTQZrmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1912
  {DBGFIELD("VPSHUFHWZmik_VPSHUFHWZmikz_VPSHUFLWZmik_VPSHUFLWZmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1913
  {DBGFIELD("VFPCLASSPDZ256rmb_VFPCLASSPSZ256rmb") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1914
  {DBGFIELD("VFPCLASSPDZrmb_VFPCLASSPSZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1915
  {DBGFIELD("VFPCLASSPHZ256rmb")  2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1916
  {DBGFIELD("VFPCLASSPHZrmb")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1917
  {DBGFIELD("VPALIGNRZrmik_VPALIGNRZrmikz_VPUNPCKHBWZrmk_VPUNPCKHBWZrmkz_VPUNPCKHWDZrmk_VPUNPCKHWDZrmkz_VPUNPCKLBWZrmk_VPUNPCKLBWZrmkz_VPUNPCKLWDZrmk_VPUNPCKLWDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1918
  {DBGFIELD("VPMULTISHIFTQBZ256rm_VPMULTISHIFTQBZ256rmb") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #1919
  {DBGFIELD("VPMULTISHIFTQBZrm_VPMULTISHIFTQBZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1920
  {DBGFIELD("VPCLMULQDQZrmi")     2, false, false, false, 540, 12,  9, 1,  6, 1}, // #1921
  {DBGFIELD("VPCLMULQDQZ256rmi")  2, false, false, false, 540, 12,  9, 1,  6, 1}, // #1922
  {DBGFIELD("VBLENDVPDYrmr_VBLENDVPSYrmr") 4, false, false, false, 868, 6,  9, 1,  8, 2}, // #1923
  {DBGFIELD("VPBLENDVBYrmr")      4, false, false, false, 868, 6,  9, 1,  8, 2}, // #1924
  {DBGFIELD("VBLENDVPDYrrr_VBLENDVPSYrrr") 3, false, false, false, 874, 4,  5, 1,  0, 0}, // #1925
  {DBGFIELD("VPBLENDVBYrrr")      3, false, false, false, 874, 4,  5, 1,  0, 0}, // #1926
  {DBGFIELD("VMOVAPDZ256rmk_VMOVAPDZ256rmkz_VMOVAPSZ256rmk_VMOVAPSZ256rmkz_VMOVUPDZ256rmk_VMOVUPDZ256rmkz_VMOVUPSZ256rmk_VMOVUPSZ256rmkz") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1927
  {DBGFIELD("VMOVDQA32Z256rmk_VMOVDQA32Z256rmkz_VMOVDQA64Z256rmk_VMOVDQA64Z256rmkz_VMOVDQU32Z256rmk_VMOVDQU32Z256rmkz_VMOVDQU64Z256rmk_VMOVDQU64Z256rmkz") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #1928
  {DBGFIELD("VPADDBZ256rm_VPADDDZ256rm_VPADDQZ256rm_VPADDWZ256rm_VPSUBBZ256rm_VPSUBDZ256rm_VPSUBQZ256rm_VPSUBWZ256rm_VPADDDZ256rmb_VPADDDZ256rmk_VPADDDZ256rmkz_VPADDQZ256rmb_VPADDQZ256rmk_VPADDQZ256rmkz_VPSUBDZ256rmb_VPSUBDZ256rmk_VPSUBDZ256rmkz_VPSUBQZ256rmb_VPSUBQZ256rmk_VPSUBQZ256rmkz_VPADDDZ256rmbk_VPADDDZ256rmbkz_VPADDQZ256rmbk_VPADDQZ256rmbkz_VPSUBDZ256rmbk_VPSUBDZ256rmbkz_VPSUBQZ256rmbk_VPSUBQZ256rmbkz_VPTERNLOGDZ256rmbi_VPTERNLOGDZ256rmik_VPTERNLOGQZ256rmbi_VPTERNLOGQZ256rmik_VPTERNLOGDZ256rmbik_VPTERNLOGDZ256rmbikz_VPTERNLOGQZ256rmbik_VPTERNLOGQZ256rmbikz_VPTERNLOGDZ256rmi_VPTERNLOGDZ256rmikz_VPTERNLOGQZ256rmi_VPTERNLOGQZ256rmikz") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #1929
  {DBGFIELD("VCMPPHZ128rmbi_VCMPPHZ128rmik_VCMPPHZ128rmbik_VCMPPHZ128rmi_VFPCLASSPHZ128rmbk_VFPCLASSPHZ128rmk") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1930
  {DBGFIELD("VCMPPHZ256rmbi_VCMPPHZ256rmik_VCMPPHZ256rmbik_VCMPPHZ256rmi_VFPCLASSPHZ256rmbk_VFPCLASSPHZ256rmk") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #1931
  {DBGFIELD("VCMPPHZrmbi_VCMPPHZrmik_VCMPPHZrmbik_VCMPPHZrmi_VFPCLASSPHZrmbk_VFPCLASSPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1932
  {DBGFIELD("VCMPSHZrmi_VCMPSHZrmi_Int_VCMPSHZrmi_Intk_VFPCLASSSHZrmk") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #1933
  {DBGFIELD("VCOMISHZrm_VCOMISHZrm_Int_VUCOMISHZrm_VUCOMISHZrm_Int") 2, false, false, false, 247, 11,  7, 1,  6, 1}, // #1934
  {DBGFIELD("VCOMPRESSPDZ128mr_VCOMPRESSPDZ256mr_VCOMPRESSPSZ128mr_VCOMPRESSPSZ256mr_VCOMPRESSPDZmr_VCOMPRESSPSZmr_VPCOMPRESSDZ128mr_VPCOMPRESSDZ256mr_VPCOMPRESSQZ128mr_VPCOMPRESSQZ256mr_VPCOMPRESSDZmr_VPCOMPRESSQZmr") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1935
  {DBGFIELD("VPMOVDBZmr_VPMOVQBZmr_VPMOVSQBZmr_VPMOVSWBZmr_VPMOVWBZmr_VPMOVDWZmr_VPMOVQWZmr_VPMOVSDWZmr_VPMOVSQWZmr_VPMOVUSDWZmr_VPMOVUSQWZmr_VPMOVSDBZmr_VPMOVSQDZmr_VPMOVUSDBZmr_VPMOVUSQDZmr_VPMOVUSQBZmr_VPMOVUSWBZmr") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1936
  {DBGFIELD("VPMOVDBZmrk_VPMOVQBZmrk_VPMOVSQBZmrk_VPMOVSWBZmrk_VPMOVWBZmrk_VPMOVDWZmrk_VPMOVQWZmrk_VPMOVSDWZmrk_VPMOVSQWZmrk_VPMOVUSDWZmrk_VPMOVUSQWZmrk_VPMOVSDBZmrk_VPMOVSQDZmrk_VPMOVUSDBZmrk_VPMOVUSQDZmrk_VPMOVUSQBZmrk_VPMOVUSWBZmrk") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #1937
  {DBGFIELD("VCOMPRESSPDZ128rr_VCOMPRESSPSZ128rr_VPCOMPRESSDZ128rr_VPCOMPRESSQZ128rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1938
  {DBGFIELD("VCOMPRESSPDZ256rr_VCOMPRESSPSZ256rr_VPCOMPRESSDZ256rr_VPCOMPRESSQZ256rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1939
  {DBGFIELD("VCOMPRESSPDZrr_VCOMPRESSPSZrr_VPCOMPRESSDZrr_VPCOMPRESSQZrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1940
  {DBGFIELD("VEXPANDPDZ128rr_VEXPANDPDZ256rr_VEXPANDPSZ128rr_VEXPANDPSZ256rr_VEXPANDPDZrr_VEXPANDPSZrr_VPEXPANDDZ128rr_VPEXPANDDZ256rr_VPEXPANDQZ128rr_VPEXPANDQZ256rr_VPEXPANDDZrr_VPEXPANDQZrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1941
  {DBGFIELD("VPCOMPRESSBZ128rr_VPCOMPRESSWZ128rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1942
  {DBGFIELD("VPCOMPRESSBZ256rr_VPCOMPRESSWZ256rr_VPEXPANDBZ256rr_VPEXPANDWZ256rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1943
  {DBGFIELD("VPCOMPRESSBZrr_VPCOMPRESSWZrr_VPEXPANDBZrr_VPEXPANDWZrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1944
  {DBGFIELD("VPEXPANDBZ128rr_VPEXPANDWZ128rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #1945
  {DBGFIELD("VCVTDQ2PDZrrk_VCVTDQ2PDZrrkz_VCVTUDQ2PDZrrk_VCVTUDQ2PDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1946
  {DBGFIELD("VCVTPS2QQZrrb_VCVTPS2QQZrrbk_VCVTPS2QQZrrk_VCVTPS2QQZrrkz_VCVTPS2UQQZrrb_VCVTPS2UQQZrrbk_VCVTPS2UQQZrrk_VCVTPS2UQQZrrkz_VCVTTPS2QQZrrb_VCVTTPS2QQZrrbk_VCVTTPS2QQZrrk_VCVTTPS2QQZrrkz_VCVTTPS2UQQZrrb_VCVTTPS2UQQZrrbk_VCVTTPS2UQQZrrk_VCVTTPS2UQQZrrkz_VCVTPS2QQZrrbkz_VCVTPS2UQQZrrbkz_VCVTTPS2QQZrrbkz_VCVTTPS2UQQZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1947
  {DBGFIELD("VCVTQQ2PSZrrb_VCVTQQ2PSZrrbk_VCVTQQ2PSZrrk_VCVTQQ2PSZrrkz_VCVTUQQ2PSZrrb_VCVTUQQ2PSZrrbk_VCVTUQQ2PSZrrk_VCVTUQQ2PSZrrkz_VCVTQQ2PSZrrbkz_VCVTUQQ2PSZrrbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1948
  {DBGFIELD("VCVTDQ2PHZ128rm_VCVTDQ2PHZ128rmb_VCVTUDQ2PHZ128rm_VCVTUDQ2PHZ128rmb") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1949
  {DBGFIELD("VCVTNEPS2BF16Z128rm_VCVTNEPS2BF16Z128rmb") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #1950
  {DBGFIELD("VCVTDQ2PHZ128rmbk_VCVTDQ2PHZ128rmkz_VCVTUDQ2PHZ128rmbk_VCVTUDQ2PHZ128rmkz_VCVTDQ2PHZ128rmbkz_VCVTDQ2PHZ128rmk_VCVTUDQ2PHZ128rmbkz_VCVTUDQ2PHZ128rmk") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1951
  {DBGFIELD("VCVTDQ2PHZ128rr_VCVTUDQ2PHZ128rr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1952
  {DBGFIELD("VCVTDQ2PHZ128rrk_VCVTDQ2PHZ128rrkz_VCVTUDQ2PHZ128rrk_VCVTUDQ2PHZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1953
  {DBGFIELD("VCVTDQ2PHZ256rm_VCVTDQ2PHZ256rmb_VCVTUDQ2PHZ256rm_VCVTUDQ2PHZ256rmb") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1954
  {DBGFIELD("VCVTNEPS2BF16Z128rmbk_VCVTNEPS2BF16Z128rmkz_VCVTNEPS2BF16Z128rmbkz_VCVTNEPS2BF16Z128rmk") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #1955
  {DBGFIELD("VCVTDQ2PHZ256rmbk_VCVTDQ2PHZ256rmkz_VCVTUDQ2PHZ256rmbk_VCVTUDQ2PHZ256rmkz_VCVTDQ2PHZ256rmbkz_VCVTDQ2PHZ256rmk_VCVTUDQ2PHZ256rmbkz_VCVTUDQ2PHZ256rmk") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1956
  {DBGFIELD("VCVTDQ2PHZ256rr_VCVTUDQ2PHZ256rr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1957
  {DBGFIELD("VCVTDQ2PHZ256rrk_VCVTDQ2PHZ256rrkz_VCVTUDQ2PHZ256rrk_VCVTUDQ2PHZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #1958
  {DBGFIELD("VCVTDQ2PHZrm_VCVTDQ2PHZrmb_VCVTUDQ2PHZrm_VCVTUDQ2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1959
  {DBGFIELD("VCVTDQ2PHZrmbk_VCVTDQ2PHZrmkz_VCVTUDQ2PHZrmbk_VCVTUDQ2PHZrmkz_VCVTDQ2PHZrmbkz_VCVTDQ2PHZrmk_VCVTUDQ2PHZrmbkz_VCVTUDQ2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1960
  {DBGFIELD("VCVTDQ2PHZrr_VCVTDQ2PHZrrb_VCVTUDQ2PHZrr_VCVTUDQ2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1961
  {DBGFIELD("VCVTDQ2PHZrrbk_VCVTDQ2PHZrrkz_VCVTUDQ2PHZrrbk_VCVTUDQ2PHZrrkz_VCVTDQ2PHZrrbkz_VCVTDQ2PHZrrk_VCVTUDQ2PHZrrbkz_VCVTUDQ2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1962
  {DBGFIELD("VCVTNE2PS2BF16Z128rm_VCVTNE2PS2BF16Z128rmb") 3, false, false, false, 269, 13,  2, 1,  6, 1}, // #1963
  {DBGFIELD("VCVTNE2PS2BF16Z128rmbk_VCVTNE2PS2BF16Z128rmkz_VCVTNE2PS2BF16Z128rmbkz_VCVTNE2PS2BF16Z128rmk") 3, false, false, false, 269, 13,  2, 1,  6, 1}, // #1964
  {DBGFIELD("VCVTNE2PS2BF16Z128rr") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1965
  {DBGFIELD("VCVTNE2PS2BF16Z256rr") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1966
  {DBGFIELD("VCVTNE2PS2BF16Z128rrk_VCVTNE2PS2BF16Z128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1967
  {DBGFIELD("VCVTNE2PS2BF16Z256rrk_VCVTNE2PS2BF16Z256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1968
  {DBGFIELD("VCVTNE2PS2BF16Z256rm_VCVTNE2PS2BF16Z256rmb") 3, false, false, false, 269, 13, 11, 1,  6, 1}, // #1969
  {DBGFIELD("VCVTNE2PS2BF16Z256rmbk_VCVTNE2PS2BF16Z256rmkz_VCVTNE2PS2BF16Z256rmbkz_VCVTNE2PS2BF16Z256rmk") 3, false, false, false, 269, 13, 11, 1,  6, 1}, // #1970
  {DBGFIELD("VCVTNE2PS2BF16Zrm_VCVTNE2PS2BF16Zrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1971
  {DBGFIELD("VDPBF16PSZm_VDPBF16PSZmb_VDPBF16PSZmbk_VDPBF16PSZmk_VDPBF16PSZmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1972
  {DBGFIELD("VDPBF16PSZmbkz")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1973
  {DBGFIELD("VCVTNE2PS2BF16Zrmbk_VCVTNE2PS2BF16Zrmkz_VCVTNE2PS2BF16Zrmbkz_VCVTNE2PS2BF16Zrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1974
  {DBGFIELD("VCVTNE2PS2BF16Zrr")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1975
  {DBGFIELD("VCVTNE2PS2BF16Zrrk_VCVTNE2PS2BF16Zrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1976
  {DBGFIELD("VCVTNEPS2BF16Z128rr") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1977
  {DBGFIELD("VCVTNEPS2BF16Z256rr") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1978
  {DBGFIELD("VCVTNEPS2BF16Z128rrk_VCVTNEPS2BF16Z128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1979
  {DBGFIELD("VCVTNEPS2BF16Z256rrk_VCVTNEPS2BF16Z256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #1980
  {DBGFIELD("VCVTNEPS2BF16Z256rm_VCVTNEPS2BF16Z256rmb") 3, false, false, false, 269, 13, 11, 1,  0, 0}, // #1981
  {DBGFIELD("VCVTNEPS2BF16Z256rmbk_VCVTNEPS2BF16Z256rmkz_VCVTNEPS2BF16Z256rmbkz_VCVTNEPS2BF16Z256rmk") 3, false, false, false, 269, 13, 11, 1,  0, 0}, // #1982
  {DBGFIELD("VCVTNEPS2BF16Zrm_VCVTNEPS2BF16Zrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1983
  {DBGFIELD("VCVTNEPS2BF16Zrmbk_VCVTNEPS2BF16Zrmkz_VCVTNEPS2BF16Zrmbkz_VCVTNEPS2BF16Zrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1984
  {DBGFIELD("VCVTNEPS2BF16Zrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1985
  {DBGFIELD("VCVTNEPS2BF16Zrrk_VCVTNEPS2BF16Zrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1986
  {DBGFIELD("VCVTPD2DQZ256rm_VCVTPD2DQZ256rmb_VCVTPD2UDQZ256rm_VCVTPD2UDQZ256rmb_VCVTTPD2DQZ256rm_VCVTTPD2DQZ256rmb_VCVTTPD2UDQZ256rm_VCVTTPD2UDQZ256rmb_VCVTPD2DQZ256rmbk_VCVTPD2DQZ256rmkz_VCVTPD2UDQZ256rmbk_VCVTPD2UDQZ256rmkz_VCVTTPD2DQZ256rmbk_VCVTTPD2DQZ256rmkz_VCVTTPD2UDQZ256rmbk_VCVTTPD2UDQZ256rmkz_VCVTPD2DQZ256rmbkz_VCVTPD2DQZ256rmk_VCVTPD2UDQZ256rmbkz_VCVTPD2UDQZ256rmk_VCVTTPD2DQZ256rmbkz_VCVTTPD2DQZ256rmk_VCVTTPD2UDQZ256rmbkz_VCVTTPD2UDQZ256rmk") 3, false, false, false, 269, 13, 11, 1,  0, 0}, // #1987
  {DBGFIELD("VCVTPH2DQZ256rm_VCVTPH2DQZ256rmb_VCVTPH2UDQZ256rm_VCVTPH2UDQZ256rmb_VCVTTPH2DQZ256rm_VCVTTPH2DQZ256rmb_VCVTTPH2UDQZ256rm_VCVTTPH2UDQZ256rmb") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1988
  {DBGFIELD("VCVTPH2PSXZ128rmbk_VCVTPH2PSXZ128rmkz_VCVTPH2PSXZ128rmbkz_VCVTPH2PSXZ128rmk") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #1989
  {DBGFIELD("VCVTPH2PSXZ256rm_VCVTPH2PSXZ256rmb") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1990
  {DBGFIELD("VCVTQQ2PSZ256rm_VCVTQQ2PSZ256rmb_VCVTQQ2PSZ256rmbk_VCVTQQ2PSZ256rmk_VCVTQQ2PSZ256rmkz_VCVTUQQ2PSZ256rm_VCVTUQQ2PSZ256rmb_VCVTUQQ2PSZ256rmbk_VCVTUQQ2PSZ256rmk_VCVTUQQ2PSZ256rmkz_VCVTQQ2PSZ256rmbkz_VCVTUQQ2PSZ256rmbkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #1991
  {DBGFIELD("VCVTPH2DQZrm_VCVTPH2DQZrmb_VCVTPH2UDQZrm_VCVTPH2UDQZrmb_VCVTTPH2DQZrm_VCVTTPH2DQZrmb_VCVTTPH2UDQZrm_VCVTTPH2UDQZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1992
  {DBGFIELD("VCVTPH2PSXZrm_VCVTPH2PSXZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1993
  {DBGFIELD("VCVTPD2PHZ128rm_VCVTPD2PHZ128rmb") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #1994
  {DBGFIELD("VCVTPD2PHZ128rmbk_VCVTPD2PHZ128rmkz_VCVTPD2PHZ128rmbkz_VCVTPD2PHZ128rmk") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #1995
  {DBGFIELD("VCVTPD2PHZ128rr")    2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1996
  {DBGFIELD("VCVTPD2PHZ128rrk_VCVTPD2PHZ128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #1997
  {DBGFIELD("VCVTPD2PHZ256rm_VCVTPD2PHZ256rmb") 3, false, false, false, 269, 13, 11, 1,  0, 0}, // #1998
  {DBGFIELD("VCVTPD2PHZ256rmbk_VCVTPD2PHZ256rmkz_VCVTPD2PHZ256rmbkz_VCVTPD2PHZ256rmk") 3, false, false, false, 269, 13, 11, 1,  0, 0}, // #1999
  {DBGFIELD("VCVTPD2PHZ256rr")    2, false, false, false, 258, 11,  6, 1,  0, 0}, // #2000
  {DBGFIELD("VCVTPD2PHZ256rrk_VCVTPD2PHZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #2001
  {DBGFIELD("VCVTPD2PHZrm_VCVTPD2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2002
  {DBGFIELD("VCVTPH2PDZrm_VCVTPH2PDZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2003
  {DBGFIELD("VCVTPD2PHZrmbk_VCVTPD2PHZrmkz_VCVTPD2PHZrmbkz_VCVTPD2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2004
  {DBGFIELD("VCVTPH2PDZrmbk_VCVTPH2PDZrmkz_VCVTPH2PDZrmbkz_VCVTPH2PDZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2005
  {DBGFIELD("VCVTPD2PHZrr_VCVTPD2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2006
  {DBGFIELD("VCVTPH2PDZrr_VCVTPH2PDZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2007
  {DBGFIELD("VCVTPD2PHZrrbk_VCVTPD2PHZrrkz_VCVTPD2PHZrrbkz_VCVTPD2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2008
  {DBGFIELD("VCVTPH2PDZrrbk_VCVTPH2PDZrrkz_VCVTPH2PDZrrbkz_VCVTPH2PDZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2009
  {DBGFIELD("VPABSBZ128rmk_VPABSBZ128rmkz_VPABSWZ128rmk_VPABSWZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  0, 0}, // #2010
  {DBGFIELD("VPABSBZ256rmk_VPABSBZ256rmkz_VPABSWZ256rmk_VPABSWZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  0, 0}, // #2011
  {DBGFIELD("VPLZCNTDZ128rm_VPLZCNTDZ128rmb_VPLZCNTDZ128rmbk_VPLZCNTDZ128rmk_VPLZCNTDZ128rmkz_VPLZCNTQZ128rm_VPLZCNTQZ128rmb_VPLZCNTQZ128rmbk_VPLZCNTQZ128rmk_VPLZCNTQZ128rmkz_VPLZCNTDZ128rmbkz_VPLZCNTQZ128rmbkz") 2, false, false, false, 103, 7, 24, 1,  0, 0}, // #2012
  {DBGFIELD("VPSLLWZ128mik_VPSLLWZ128mikz_VPSRLWZ128mik_VPSRLWZ128mikz_VPSRAWZ128mik_VPSRAWZ128mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2013
  {DBGFIELD("VPSLLWZ256mik_VPSLLWZ256mikz_VPSRLWZ256mik_VPSRLWZ256mikz_VPSRAWZ256mik_VPSRAWZ256mikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2014
  {DBGFIELD("VFIXUPIMMSDZrmi_VFIXUPIMMSDZrmik_VFIXUPIMMSDZrmikz_VFIXUPIMMSSZrmi_VFIXUPIMMSSZrmik_VFIXUPIMMSSZrmikz_VSCALEFSDZrm_VSCALEFSDZrmk_VSCALEFSDZrmkz_VSCALEFSSZrm_VSCALEFSSZrmk_VSCALEFSSZrmkz") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #2015
  {DBGFIELD("VPADDSBZ128rmk_VPADDSBZ128rmkz_VPADDSWZ128rmk_VPADDSWZ128rmkz_VPADDUSBZ128rmk_VPADDUSBZ128rmkz_VPADDUSWZ128rmk_VPADDUSWZ128rmkz_VPSUBSBZ128rmk_VPSUBSBZ128rmkz_VPSUBSWZ128rmk_VPSUBSWZ128rmkz_VPSUBUSBZ128rmk_VPSUBUSBZ128rmkz_VPSUBUSWZ128rmk_VPSUBUSWZ128rmkz_VPAVGBZ128rmk_VPAVGBZ128rmkz_VPAVGWZ128rmk_VPAVGWZ128rmkz_VPMAXSBZ128rmk_VPMAXSBZ128rmkz_VPMAXUWZ128rmk_VPMAXUWZ128rmkz_VPMINSBZ128rmk_VPMINSBZ128rmkz_VPMINUWZ128rmk_VPMINUWZ128rmkz_VPMAXSWZ128rmk_VPMAXSWZ128rmkz_VPMAXUBZ128rmk_VPMAXUBZ128rmkz_VPMINSWZ128rmk_VPMINSWZ128rmkz_VPMINUBZ128rmk_VPMINUBZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #2016
  {DBGFIELD("VPSHLDVWZ128mk_VPSHLDVWZ128mkz_VPSHRDVWZ128mk_VPSHRDVWZ128mkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2017
  {DBGFIELD("VPSLLVWZ128rmk_VPSLLVWZ128rmkz_VPSRLVWZ128rmk_VPSRLVWZ128rmkz_VPSRAVWZ128rmk_VPSRAVWZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #2018
  {DBGFIELD("VPSLLWZ128rmk_VPSLLWZ128rmkz_VPSRLWZ128rmk_VPSRLWZ128rmkz_VPSRAWZ128rmk_VPSRAWZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #2019
  {DBGFIELD("VPADDSBZ256rmk_VPADDSBZ256rmkz_VPADDSWZ256rmk_VPADDSWZ256rmkz_VPADDUSBZ256rmk_VPADDUSBZ256rmkz_VPADDUSWZ256rmk_VPADDUSWZ256rmkz_VPSUBSBZ256rmk_VPSUBSBZ256rmkz_VPSUBSWZ256rmk_VPSUBSWZ256rmkz_VPSUBUSBZ256rmk_VPSUBUSBZ256rmkz_VPSUBUSWZ256rmk_VPSUBUSWZ256rmkz_VPAVGBZ256rmk_VPAVGBZ256rmkz_VPAVGWZ256rmk_VPAVGWZ256rmkz_VPMAXSBZ256rmk_VPMAXSBZ256rmkz_VPMAXUWZ256rmk_VPMAXUWZ256rmkz_VPMINSBZ256rmk_VPMINSBZ256rmkz_VPMINUWZ256rmk_VPMINUWZ256rmkz_VPMAXSWZ256rmk_VPMAXSWZ256rmkz_VPMAXUBZ256rmk_VPMAXUBZ256rmkz_VPMINSWZ256rmk_VPMINSWZ256rmkz_VPMINUBZ256rmk_VPMINUBZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #2020
  {DBGFIELD("VPSHLDVWZ256mk_VPSHLDVWZ256mkz_VPSHRDVWZ256mk_VPSHRDVWZ256mkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2021
  {DBGFIELD("VPSLLVWZ256rmk_VPSLLVWZ256rmkz_VPSRLVWZ256rmk_VPSRLVWZ256rmkz_VPSRAVWZ256rmk_VPSRAVWZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #2022
  {DBGFIELD("VPSLLWZ256rmk_VPSLLWZ256rmkz_VPSRLWZ256rmk_VPSRLWZ256rmkz_VPSRAWZ256rmk_VPSRAWZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #2023
  {DBGFIELD("VPMADD52HUQZ128m_VPMADD52HUQZ128mb_VPMADD52HUQZ128mbk_VPMADD52HUQZ128mk_VPMADD52HUQZ128mkz_VPMADD52LUQZ128m_VPMADD52LUQZ128mb_VPMADD52LUQZ128mbk_VPMADD52LUQZ128mk_VPMADD52LUQZ128mkz_VPMADD52HUQZ128mbkz_VPMADD52LUQZ128mbkz") 2, false, false, false, 103, 7, 24, 1, 10, 2}, // #2024
  {DBGFIELD("VCVTQQ2PDZ128rr_VCVTQQ2PDZ128rrk_VCVTQQ2PDZ128rrkz_VCVTUQQ2PDZ128rr_VCVTUQQ2PDZ128rrk_VCVTUQQ2PDZ128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2025
  {DBGFIELD("VCVTQQ2PDZ256rr_VCVTQQ2PDZ256rrk_VCVTQQ2PDZ256rrkz_VCVTUQQ2PDZ256rr_VCVTUQQ2PDZ256rrk_VCVTUQQ2PDZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #2026
  {DBGFIELD("VFIXUPIMMSDZrri_VFIXUPIMMSSZrri_VSCALEFSDZrr_VSCALEFSDZrrk_VSCALEFSDZrrkz_VSCALEFSSZrr_VSCALEFSSZrrk_VSCALEFSSZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2027
  {DBGFIELD("VPLZCNTDZ128rr_VPLZCNTDZ128rrk_VPLZCNTDZ128rrkz_VPLZCNTQZ128rr_VPLZCNTQZ128rrk_VPLZCNTQZ128rrkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2028
  {DBGFIELD("VPLZCNTDZ256rr_VPLZCNTDZ256rrk_VPLZCNTDZ256rrkz_VPLZCNTQZ256rr_VPLZCNTQZ256rrk_VPLZCNTQZ256rrkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2029
  {DBGFIELD("VPMADD52HUQZ128r_VPMADD52HUQZ128rk_VPMADD52HUQZ128rkz_VPMADD52LUQZ128r_VPMADD52LUQZ128rk_VPMADD52LUQZ128rkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2030
  {DBGFIELD("VPMADD52HUQZ256r_VPMADD52HUQZ256rk_VPMADD52HUQZ256rkz_VPMADD52LUQZ256r_VPMADD52LUQZ256rk_VPMADD52LUQZ256rkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2031
  {DBGFIELD("VFIXUPIMMSDZrrib_VFIXUPIMMSDZrribk_VFIXUPIMMSDZrribkz_VFIXUPIMMSSZrrib_VFIXUPIMMSSZrribk_VFIXUPIMMSSZrribkz") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #2032
  {DBGFIELD("VCVTPH2DQZ128rm_VCVTPH2DQZ128rmb_VCVTPH2UDQZ128rm_VCVTPH2UDQZ128rmb_VCVTTPH2DQZ128rm_VCVTTPH2DQZ128rmb_VCVTTPH2UDQZ128rm_VCVTTPH2UDQZ128rmb") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #2033
  {DBGFIELD("VCVTPS2PHXZ128rm_VCVTPS2PHXZ128rmb") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #2034
  {DBGFIELD("VCVTPH2DQZ128rmbk_VCVTPH2DQZ128rmkz_VCVTPH2UDQZ128rmbk_VCVTPH2UDQZ128rmkz_VCVTTPH2DQZ128rmbk_VCVTTPH2DQZ128rmkz_VCVTTPH2UDQZ128rmbk_VCVTTPH2UDQZ128rmkz_VCVTPH2DQZ128rmbkz_VCVTPH2DQZ128rmk_VCVTPH2UDQZ128rmbkz_VCVTPH2UDQZ128rmk_VCVTTPH2DQZ128rmbkz_VCVTTPH2DQZ128rmk_VCVTTPH2UDQZ128rmbkz_VCVTTPH2UDQZ128rmk") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #2035
  {DBGFIELD("VCVTPH2DQZ128rrk_VCVTPH2DQZ128rrkz_VCVTPH2UDQZ128rrk_VCVTPH2UDQZ128rrkz_VCVTTPH2DQZ128rrk_VCVTTPH2DQZ128rrkz_VCVTTPH2UDQZ128rrk_VCVTTPH2UDQZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2036
  {DBGFIELD("VCVTPH2DQZ256rrk_VCVTPH2DQZ256rrkz_VCVTPH2UDQZ256rrk_VCVTPH2UDQZ256rrkz_VCVTTPH2DQZ256rrk_VCVTTPH2DQZ256rrkz_VCVTTPH2UDQZ256rrk_VCVTTPH2UDQZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2037
  {DBGFIELD("VCVTPH2PSXZ256rrk_VCVTPH2PSXZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #2038
  {DBGFIELD("VCVTPH2PSZ256rrk_VCVTPH2PSZ256rrkz") 2, false, false, false, 258, 11,  7, 1,  0, 0}, // #2039
  {DBGFIELD("VCVTPS2PHXZ256rrk_VCVTPS2PHXZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #2040
  {DBGFIELD("VCVTPS2PHZ256rrk_VCVTPS2PHZ256rrkz") 2, false, false, false, 258, 11,  7, 1,  0, 0}, // #2041
  {DBGFIELD("VCVTPH2DQZ256rmbk_VCVTPH2DQZ256rmkz_VCVTPH2UDQZ256rmbk_VCVTPH2UDQZ256rmkz_VCVTTPH2DQZ256rmbk_VCVTTPH2DQZ256rmkz_VCVTTPH2UDQZ256rmbk_VCVTTPH2UDQZ256rmkz_VCVTPH2DQZ256rmbkz_VCVTPH2DQZ256rmk_VCVTPH2UDQZ256rmbkz_VCVTPH2UDQZ256rmk_VCVTTPH2DQZ256rmbkz_VCVTTPH2DQZ256rmk_VCVTTPH2UDQZ256rmbkz_VCVTTPH2UDQZ256rmk") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #2042
  {DBGFIELD("VCVTPH2PSXZ256rmbk_VCVTPH2PSXZ256rmkz_VCVTPH2PSXZ256rmbkz_VCVTPH2PSXZ256rmk") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #2043
  {DBGFIELD("VCVTPS2PHXZ256rmbk_VCVTPS2PHXZ256rmkz_VCVTPS2PHXZ256rmbkz_VCVTPS2PHXZ256rmk") 3, false, false, false, 269, 13, 11, 1,  0, 0}, // #2044
  {DBGFIELD("VCVTPH2DQZrmbk_VCVTPH2DQZrmkz_VCVTPH2UDQZrmbk_VCVTPH2UDQZrmkz_VCVTTPH2DQZrmbk_VCVTTPH2DQZrmkz_VCVTTPH2UDQZrmbk_VCVTTPH2UDQZrmkz_VCVTPH2DQZrmbkz_VCVTPH2DQZrmk_VCVTPH2UDQZrmbkz_VCVTPH2UDQZrmk_VCVTTPH2DQZrmbkz_VCVTTPH2DQZrmk_VCVTTPH2UDQZrmbkz_VCVTTPH2UDQZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2045
  {DBGFIELD("VCVTPH2PSXZrmbk_VCVTPH2PSXZrmkz_VCVTPH2PSXZrmbkz_VCVTPH2PSXZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2046
  {DBGFIELD("VCVTPS2PHXZrmbk_VCVTPS2PHXZrmkz_VCVTPS2PHXZrmbkz_VCVTPS2PHXZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2047
  {DBGFIELD("VCVTPH2DQZrr_VCVTPH2DQZrrb_VCVTPH2UDQZrr_VCVTPH2UDQZrrb_VCVTTPH2DQZrr_VCVTTPH2DQZrrb_VCVTTPH2UDQZrr_VCVTTPH2UDQZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2048
  {DBGFIELD("VCVTPH2PSXZrr_VCVTPH2PSXZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2049
  {DBGFIELD("VCVTPH2PSZrr_VCVTPH2PSZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2050
  {DBGFIELD("VCVTPS2PHXZrr_VCVTPS2PHXZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2051
  {DBGFIELD("VCVTPS2PHZrr_VCVTPS2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2052
  {DBGFIELD("VPSHUFBITQMBZ128rrk") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2053
  {DBGFIELD("VPSHUFBITQMBZ256rrk") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2054
  {DBGFIELD("VPSHUFBITQMBZrrk")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2055
  {DBGFIELD("VCVTPH2DQZrrbk_VCVTPH2DQZrrkz_VCVTPH2UDQZrrbk_VCVTPH2UDQZrrkz_VCVTTPH2DQZrrbk_VCVTTPH2DQZrrkz_VCVTTPH2UDQZrrbk_VCVTTPH2UDQZrrkz_VCVTPH2DQZrrbkz_VCVTPH2DQZrrk_VCVTPH2UDQZrrbkz_VCVTPH2UDQZrrk_VCVTTPH2DQZrrbkz_VCVTTPH2DQZrrk_VCVTTPH2UDQZrrbkz_VCVTTPH2UDQZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2056
  {DBGFIELD("VCVTPH2PSXZrrbk_VCVTPH2PSXZrrkz_VCVTPH2PSXZrrbkz_VCVTPH2PSXZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2057
  {DBGFIELD("VCVTPS2PHXZrrbk_VCVTPS2PHXZrrkz_VCVTPS2PHXZrrbkz_VCVTPS2PHXZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2058
  {DBGFIELD("VCVTPH2PDZ128rm_VCVTPH2PDZ128rmb") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #2059
  {DBGFIELD("VCVTPH2PDZ128rmbk_VCVTPH2PDZ128rmkz_VCVTPH2PDZ128rmbkz_VCVTPH2PDZ128rmk") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #2060
  {DBGFIELD("VCVTPH2PDZ128rr")    2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2061
  {DBGFIELD("VCVTPH2PDZ128rrk_VCVTPH2PDZ128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2062
  {DBGFIELD("VCVTPH2PDZ256rm_VCVTPH2PDZ256rmb") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #2063
  {DBGFIELD("VCVTPH2PDZ256rmbk_VCVTPH2PDZ256rmkz_VCVTPH2PDZ256rmbkz_VCVTPH2PDZ256rmk") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #2064
  {DBGFIELD("VCVTPH2PDZ256rr")    2, false, false, false, 258, 11,  6, 1,  0, 0}, // #2065
  {DBGFIELD("VCVTPH2PDZ256rrk_VCVTPH2PDZ256rrkz") 2, false, false, false, 258, 11,  6, 1,  0, 0}, // #2066
  {DBGFIELD("VCVTPH2PSXZ128rrk_VCVTPH2PSXZ128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2067
  {DBGFIELD("VCVTPH2PSZ128rrk_VCVTPH2PSZ128rrkz") 2, false, false, false, 258, 11,  3, 1,  0, 0}, // #2068
  {DBGFIELD("VCVTPS2PHXZ128rrk_VCVTPS2PHXZ128rrkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2069
  {DBGFIELD("VCVTPS2PHZ128rrk_VCVTPS2PHZ128rrkz") 2, false, false, false, 258, 11,  3, 1,  0, 0}, // #2070
  {DBGFIELD("VCVTPH2PSZ128rmk_VCVTPH2PSZ128rmkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #2071
  {DBGFIELD("VCVTPH2PSZ256rmk_VCVTPH2PSZ256rmkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #2072
  {DBGFIELD("VCVTSH2SSZrm_Intk_VCVTSH2SSZrm_Intkz") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #2073
  {DBGFIELD("VPMADDUBSWZ128rmk_VPMADDUBSWZ128rmkz_VPMULHRSWZ128rmk_VPMULHRSWZ128rmkz_VPMULHUWZ128rmk_VPMULHUWZ128rmkz_VPMULHWZ128rmk_VPMULHWZ128rmkz_VPMULLWZ128rmk_VPMULLWZ128rmkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2074
  {DBGFIELD("VPMADDUBSWZ256rmk_VPMADDUBSWZ256rmkz_VPMULHRSWZ256rmk_VPMULHRSWZ256rmkz_VPMULHUWZ256rmk_VPMULHUWZ256rmkz_VPMULHWZ256rmk_VPMULHWZ256rmkz_VPMULLWZ256rmk_VPMULLWZ256rmkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2075
  {DBGFIELD("VCVTPH2PSZrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2076
  {DBGFIELD("VPERMWZrmk_VPERMWZrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2077
  {DBGFIELD("VCVTPH2QQZ128rm_VCVTPH2QQZ128rmb_VCVTPH2QQZ128rmbk_VCVTPH2QQZ128rmk_VCVTPH2QQZ128rmkz_VCVTPH2UQQZ128rm_VCVTPH2UQQZ128rmb_VCVTPH2UQQZ128rmbk_VCVTPH2UQQZ128rmk_VCVTPH2UQQZ128rmkz_VCVTTPH2QQZ128rm_VCVTTPH2QQZ128rmb_VCVTTPH2QQZ128rmbk_VCVTTPH2QQZ128rmk_VCVTTPH2QQZ128rmkz_VCVTTPH2UQQZ128rm_VCVTTPH2UQQZ128rmb_VCVTTPH2UQQZ128rmbk_VCVTTPH2UQQZ128rmk_VCVTTPH2UQQZ128rmkz_VCVTPH2QQZ128rmbkz_VCVTPH2UQQZ128rmbkz_VCVTTPH2QQZ128rmbkz_VCVTTPH2UQQZ128rmbkz") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #2078
  {DBGFIELD("VCVTPH2QQZ128rr_VCVTPH2QQZ128rrk_VCVTPH2QQZ128rrkz_VCVTPH2UQQZ128rr_VCVTPH2UQQZ128rrk_VCVTPH2UQQZ128rrkz_VCVTTPH2QQZ128rr_VCVTTPH2QQZ128rrk_VCVTTPH2QQZ128rrkz_VCVTTPH2UQQZ128rr_VCVTTPH2UQQZ128rrk_VCVTTPH2UQQZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2079
  {DBGFIELD("VCVTPH2QQZ256rr_VCVTPH2QQZ256rrk_VCVTPH2QQZ256rrkz_VCVTPH2UQQZ256rr_VCVTPH2UQQZ256rrk_VCVTPH2UQQZ256rrkz_VCVTTPH2QQZ256rr_VCVTTPH2QQZ256rrk_VCVTTPH2QQZ256rrkz_VCVTTPH2UQQZ256rr_VCVTTPH2UQQZ256rrk_VCVTTPH2UQQZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2080
  {DBGFIELD("VCVTPH2QQZ256rm_VCVTPH2QQZ256rmb_VCVTPH2QQZ256rmbk_VCVTPH2QQZ256rmk_VCVTPH2QQZ256rmkz_VCVTPH2UQQZ256rm_VCVTPH2UQQZ256rmb_VCVTPH2UQQZ256rmbk_VCVTPH2UQQZ256rmk_VCVTPH2UQQZ256rmkz_VCVTTPH2QQZ256rm_VCVTTPH2QQZ256rmb_VCVTTPH2QQZ256rmbk_VCVTTPH2QQZ256rmk_VCVTTPH2QQZ256rmkz_VCVTTPH2UQQZ256rm_VCVTTPH2UQQZ256rmb_VCVTTPH2UQQZ256rmbk_VCVTTPH2UQQZ256rmk_VCVTTPH2UQQZ256rmkz_VCVTPH2QQZ256rmbkz_VCVTPH2UQQZ256rmbkz_VCVTTPH2QQZ256rmbkz_VCVTTPH2UQQZ256rmbkz") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #2081
  {DBGFIELD("VCVTPS2PHXZ128rmbk_VCVTPS2PHXZ128rmkz_VCVTPS2PHXZ128rmbkz_VCVTPS2PHXZ128rmk") 3, false, false, false, 269, 13,  2, 1,  0, 0}, // #2082
  {DBGFIELD("VCVTPS2PHXZ256rm_VCVTPS2PHXZ256rmb") 3, false, false, false, 269, 13, 11, 1,  0, 0}, // #2083
  {DBGFIELD("VCVTPS2PHXZrm_VCVTPS2PHXZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2084
  {DBGFIELD("VCVTPS2PHZ128mrk")   3, false, false, false, 878, 8,  2, 1,  0, 0}, // #2085
  {DBGFIELD("VCVTPS2PHZ256mrk")   3, false, false, false, 878, 8,  2, 1,  0, 0}, // #2086
  {DBGFIELD("VCVTPS2PHZmrk")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2087
  {DBGFIELD("VCVTQQ2PHZ128rm_VCVTQQ2PHZ128rmb_VCVTUQQ2PHZ128rm_VCVTUQQ2PHZ128rmb") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #2088
  {DBGFIELD("VCVTQQ2PHZ128rmbk_VCVTQQ2PHZ128rmkz_VCVTUQQ2PHZ128rmbk_VCVTUQQ2PHZ128rmkz_VCVTQQ2PHZ128rmbkz_VCVTQQ2PHZ128rmk_VCVTUQQ2PHZ128rmbkz_VCVTUQQ2PHZ128rmk") 2, false, false, false, 103, 7,  8, 1,  0, 0}, // #2089
  {DBGFIELD("VCVTQQ2PHZ128rr_VCVTUQQ2PHZ128rr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2090
  {DBGFIELD("VCVTQQ2PHZ128rrk_VCVTQQ2PHZ128rrkz_VCVTUQQ2PHZ128rrk_VCVTUQQ2PHZ128rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2091
  {DBGFIELD("VCVTQQ2PHZ256rr_VCVTUQQ2PHZ256rr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2092
  {DBGFIELD("VCVTQQ2PHZ256rm_VCVTQQ2PHZ256rmb_VCVTUQQ2PHZ256rm_VCVTUQQ2PHZ256rmb") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #2093
  {DBGFIELD("VCVTQQ2PHZ256rmbk_VCVTQQ2PHZ256rmkz_VCVTUQQ2PHZ256rmbk_VCVTUQQ2PHZ256rmkz_VCVTQQ2PHZ256rmbkz_VCVTQQ2PHZ256rmk_VCVTUQQ2PHZ256rmbkz_VCVTUQQ2PHZ256rmk") 2, false, false, false, 103, 7,  2, 1,  0, 0}, // #2094
  {DBGFIELD("VCVTQQ2PHZ256rrk_VCVTQQ2PHZ256rrkz_VCVTUQQ2PHZ256rrk_VCVTUQQ2PHZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2095
  {DBGFIELD("VCVTQQ2PHZrm_VCVTQQ2PHZrmb_VCVTUQQ2PHZrm_VCVTUQQ2PHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2096
  {DBGFIELD("VCVTQQ2PHZrmbk_VCVTQQ2PHZrmkz_VCVTUQQ2PHZrmbk_VCVTUQQ2PHZrmkz_VCVTQQ2PHZrmbkz_VCVTQQ2PHZrmk_VCVTUQQ2PHZrmbkz_VCVTUQQ2PHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2097
  {DBGFIELD("VCVTQQ2PHZrr_VCVTQQ2PHZrrb_VCVTUQQ2PHZrr_VCVTUQQ2PHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2098
  {DBGFIELD("VCVTQQ2PHZrrbk_VCVTQQ2PHZrrkz_VCVTUQQ2PHZrrbk_VCVTUQQ2PHZrrkz_VCVTQQ2PHZrrbkz_VCVTQQ2PHZrrk_VCVTUQQ2PHZrrbkz_VCVTUQQ2PHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2099
  {DBGFIELD("VCVTSD2SHZrm_VCVTSD2SHZrm_Int") 3, false, false, false, 269, 13,  2, 1,  6, 1}, // #2100
  {DBGFIELD("VCVTSD2SHZrm_Intk_VCVTSD2SHZrm_Intkz") 3, false, false, false, 269, 13,  2, 1,  6, 1}, // #2101
  {DBGFIELD("VCVTSD2SHZrr_Int_VCVTSD2SHZrrb_Int") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2102
  {DBGFIELD("VCVTSD2SHZrr")       2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2103
  {DBGFIELD("VCVTSD2SHZrr_Intk_VCVTSD2SHZrr_Intkz_VCVTSD2SHZrrb_Intk_VCVTSD2SHZrrb_Intkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2104
  {DBGFIELD("VCVTSH2SDZrm_VCVTSH2SDZrm_Int") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #2105
  {DBGFIELD("VCVTSH2SDZrm_Intk_VCVTSH2SDZrm_Intkz") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #2106
  {DBGFIELD("VCVTSH2SDZrr_Int_VCVTSH2SDZrrb_Int") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2107
  {DBGFIELD("VCVTSH2SDZrr")       2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2108
  {DBGFIELD("VCVTSH2SDZrr_Intk_VCVTSH2SDZrr_Intkz_VCVTSH2SDZrrb_Intk_VCVTSH2SDZrrb_Intkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2109
  {DBGFIELD("VCVTSH2SI64Zrm_Int_VCVTSH2SIZrm_Int_VCVTSH2USI64Zrm_Int_VCVTSH2USIZrm_Int_VCVTTSH2SI64Zrm_Int_VCVTTSH2SIZrm_Int_VCVTTSH2USI64Zrm_Int_VCVTTSH2USIZrm_Int_VCVTTSH2SI64Zrm_VCVTTSH2SIZrm_VCVTTSH2USI64Zrm_VCVTTSH2USIZrm") 3, false, false, false, 282, 11,  2, 1,  6, 1}, // #2110
  {DBGFIELD("VCVTSH2SI64Zrr_Int_VCVTSH2SI64Zrrb_Int_VCVTSH2SIZrr_Int_VCVTSH2SIZrrb_Int_VCVTSH2USI64Zrr_Int_VCVTSH2USI64Zrrb_Int_VCVTSH2USIZrr_Int_VCVTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_Int_VCVTTSH2SI64Zrrb_Int_VCVTTSH2SIZrr_Int_VCVTTSH2SIZrrb_Int_VCVTTSH2USI64Zrr_Int_VCVTTSH2USI64Zrrb_Int_VCVTTSH2USIZrr_Int_VCVTTSH2USIZrrb_Int_VCVTTSH2SI64Zrr_VCVTTSH2SIZrr_VCVTTSH2USI64Zrr_VCVTTSH2USIZrr") 2, false, false, false, 293, 9,  6, 1,  0, 0}, // #2111
  {DBGFIELD("VCVTSH2SSZrr_Intk_VCVTSH2SSZrr_Intkz_VCVTSH2SSZrrb_Intk_VCVTSH2SSZrrb_Intkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2112
  {DBGFIELD("VCVTSI2SHZrm_VCVTSI2SHZrm_Int_VCVTSI642SHZrm_VCVTSI642SHZrm_Int_VCVTUSI2SHZrm_VCVTUSI2SHZrm_Int_VCVTUSI642SHZrm_VCVTUSI642SHZrm_Int") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #2113
  {DBGFIELD("VCVTSS2SHZrm_VCVTSS2SHZrm_Int") 3, false, false, false, 269, 13,  2, 1,  6, 1}, // #2114
  {DBGFIELD("VCVTSS2SHZrm_Intk_VCVTSS2SHZrm_Intkz") 3, false, false, false, 269, 13,  2, 1,  6, 1}, // #2115
  {DBGFIELD("VCVTSS2SHZrr_Int_VCVTSS2SHZrrb_Int") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2116
  {DBGFIELD("VCVTSS2SHZrr")       2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2117
  {DBGFIELD("VCVTSS2SHZrr_Intk_VCVTSS2SHZrr_Intkz_VCVTSS2SHZrrb_Intk_VCVTSS2SHZrrb_Intkz") 2, false, false, false, 258, 11, 10, 1,  0, 0}, // #2118
  {DBGFIELD("VDBPSADBWZ128rrik_VDBPSADBWZ128rrikz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2119
  {DBGFIELD("VDBPSADBWZ256rrik_VDBPSADBWZ256rrikz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2120
  {DBGFIELD("VDBPSADBWZrrik_VDBPSADBWZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2121
  {DBGFIELD("VPACKSSDWZrrk_VPACKSSDWZrrkz_VPACKSSWBZrrk_VPACKSSWBZrrkz_VPACKUSDWZrrk_VPACKUSDWZrrkz_VPACKUSWBZrrk_VPACKUSWBZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2122
  {DBGFIELD("VPBROADCASTBZ256rrk_VPBROADCASTBZ256rrkz_VPBROADCASTBZrrk_VPBROADCASTBZrrkz_VPBROADCASTDrZ256rrk_VPBROADCASTDrZ256rrkz_VPBROADCASTDrZrrk_VPBROADCASTDrZrrkz_VPBROADCASTQrZ256rrk_VPBROADCASTQrZ256rrkz_VPBROADCASTQrZrrk_VPBROADCASTQrZrrkz_VPBROADCASTWZ256rrk_VPBROADCASTWZ256rrkz_VPBROADCASTWZrrk_VPBROADCASTWZrrkz_VPBROADCASTWrZ256rrk_VPBROADCASTWrZ256rrkz_VPBROADCASTWrZrrk_VPBROADCASTWrZrrkz_VPBROADCASTBrZ256rr_VPBROADCASTDrZ256rr_VPBROADCASTQrZ256rr_VPBROADCASTWrZ256rr_VPBROADCASTBrZ256rrk_VPBROADCASTBrZ256rrkz_VPBROADCASTBrZrr_VPBROADCASTDrZrr_VPBROADCASTQrZrr_VPBROADCASTWrZrr_VPBROADCASTBrZrrk_VPBROADCASTBrZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2123
  {DBGFIELD("VPBROADCASTBrZ128rr_VPBROADCASTDrZ128rr_VPBROADCASTQrZ128rr_VPBROADCASTWrZ128rr_VPBROADCASTBrZ128rrk_VPBROADCASTBrZ128rrkz_VPBROADCASTDrZ128rrk_VPBROADCASTDrZ128rrkz_VPBROADCASTQrZ128rrk_VPBROADCASTQrZ128rrkz_VPBROADCASTWrZ128rrk_VPBROADCASTWrZ128rrkz") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #2124
  {DBGFIELD("VPERMBZ128rrk_VPERMBZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2125
  {DBGFIELD("VPERMBZ256rrk_VPERMBZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2126
  {DBGFIELD("VPERMBZrrk_VPERMBZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2127
  {DBGFIELD("VPMOVSXBWZ256rrk_VPMOVSXBWZ256rrkz_VPMOVZXBWZ256rrk_VPMOVZXBWZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2128
  {DBGFIELD("VPMOVSXBWZrrk_VPMOVSXBWZrrkz_VPMOVZXBWZrrk_VPMOVZXBWZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2129
  {DBGFIELD("VPMULTISHIFTQBZ128rrk_VPMULTISHIFTQBZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2130
  {DBGFIELD("VPMULTISHIFTQBZ256rrk_VPMULTISHIFTQBZ256rrkz_VPOPCNTBZ256rrk_VPOPCNTBZ256rrkz_VPOPCNTWZ256rrk_VPOPCNTWZ256rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2131
  {DBGFIELD("VPMULTISHIFTQBZrrk_VPMULTISHIFTQBZrrkz_VPOPCNTBZrrk_VPOPCNTBZrrkz_VPOPCNTWZrrk_VPOPCNTWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2132
  {DBGFIELD("VPOPCNTBZ128rrk_VPOPCNTBZ128rrkz_VPOPCNTWZ128rrk_VPOPCNTWZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2133
  {DBGFIELD("VDIVPHZ128rm_VDIVPHZ128rmb") 2, false, false, false, 247, 11, 13, 1,  6, 1}, // #2134
  {DBGFIELD("VDIVPHZ128rmbk_VDIVPHZ128rmkz_VDIVPHZ128rmbkz_VDIVPHZ128rmk") 2, false, false, false, 247, 11, 13, 1,  6, 1}, // #2135
  {DBGFIELD("VDIVPHZ128rr")       1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2136
  {DBGFIELD("VDIVPHZ256rr")       1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2137
  {DBGFIELD("VDIVPHZ128rrk")      1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2138
  {DBGFIELD("VDIVPHZ256rrk")      1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2139
  {DBGFIELD("VSQRTPHZ128r")       1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2140
  {DBGFIELD("VSQRTPHZ256r")       1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2141
  {DBGFIELD("VDIVPHZ128rrkz")     1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2142
  {DBGFIELD("VDIVPHZ256rm_VDIVPHZ256rmb") 2, false, false, false, 247, 11, 17, 1,  6, 1}, // #2143
  {DBGFIELD("VDIVPHZ256rmbk_VDIVPHZ256rmkz_VDIVPHZ256rmbkz_VDIVPHZ256rmk") 2, false, false, false, 247, 11, 17, 1,  6, 1}, // #2144
  {DBGFIELD("VSQRTPHZ128m_VSQRTPHZ128mb") 2, false, false, false, 247, 11, 17, 1,  6, 1}, // #2145
  {DBGFIELD("VDIVPHZ256rrkz")     1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2146
  {DBGFIELD("VDIVPHZrm_VDIVPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2147
  {DBGFIELD("VDIVPHZrmbk_VDIVPHZrmkz_VDIVPHZrmbkz_VDIVPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2148
  {DBGFIELD("VDIVPHZrr_VDIVPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2149
  {DBGFIELD("VDIVPHZrrbk_VDIVPHZrrkz_VDIVPHZrrbkz_VDIVPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2150
  {DBGFIELD("VDIVPSZrr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2151
  {DBGFIELD("VDIVSHZrm_Int_VDIVSHZrm_Intk_VDIVSHZrm_Intkz") 2, false, false, false, 247, 11, 13, 1,  6, 1}, // #2152
  {DBGFIELD("VDIVSHZrm")          2, false, false, false, 247, 11, 13, 1,  6, 1}, // #2153
  {DBGFIELD("VDIVSHZrr_Int")      1, false, false, false,  3, 9,  8, 1,  0, 0}, // #2154
  {DBGFIELD("VSQRTSHZr_Int")      1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2155
  {DBGFIELD("VDPBF16PSZ128m_VDPBF16PSZ128mb_VDPBF16PSZ128mbk_VDPBF16PSZ128mk_VDPBF16PSZ128mkz") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #2156
  {DBGFIELD("VDPBF16PSZ128mbkz")  2, false, false, false, 103, 7,  8, 1,  6, 1}, // #2157
  {DBGFIELD("VDPBF16PSZ256m_VDPBF16PSZ256mb_VDPBF16PSZ256mbk_VDPBF16PSZ256mk_VDPBF16PSZ256mkz") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #2158
  {DBGFIELD("VDPBF16PSZ256mbkz")  2, false, false, false, 103, 7,  2, 1,  6, 1}, // #2159
  {DBGFIELD("VPEXPANDBZ128rm_VPEXPANDWZ128rm") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2160
  {DBGFIELD("VFCMADDCPHZ128m_VFCMADDCPHZ128mb_VFMADDCPHZ128m_VFMADDCPHZ128mb") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2161
  {DBGFIELD("VFCMADDCPHZ256m_VFCMADDCPHZ256mb_VFMADDCPHZ256m_VFMADDCPHZ256mb") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2162
  {DBGFIELD("VROUNDPDYmi_VROUNDPSYmi") 3, false, false, false, 115, 7, 16, 1,  0, 0}, // #2163
  {DBGFIELD("VFCMADDCSHZm_VFMADDCSHZm_VFCMULCPHZ128rm_VFCMULCPHZ128rmb_VFMULCPHZ128rm_VFMULCPHZ128rmb_VFCMULCSHZrm_VFMULCSHZrm") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #2164
  {DBGFIELD("VRNDSCALEPHZ128rmbi_VRNDSCALEPHZ128rmi_VRNDSCALESHZm_VRNDSCALESHZm_Int") 3, false, false, false, 115, 7, 11, 1,  6, 1}, // #2165
  {DBGFIELD("VSCALEFPHZ128rm_VSCALEFPHZ128rmb") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #2166
  {DBGFIELD("VFCMULCPHZ256rm_VFCMULCPHZ256rmb_VFMULCPHZ256rm_VFMULCPHZ256rmb") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #2167
  {DBGFIELD("VRNDSCALEPDZ256rmbi_VRNDSCALEPDZ256rmi_VRNDSCALEPHZ256rmbi_VRNDSCALEPHZ256rmi_VRNDSCALEPSZ256rmbi_VRNDSCALEPSZ256rmi_VRNDSCALEPDZ256rmbik_VRNDSCALEPDZ256rmbikz_VRNDSCALEPDZ256rmik_VRNDSCALEPDZ256rmikz_VRNDSCALEPSZ256rmbik_VRNDSCALEPSZ256rmbikz_VRNDSCALEPSZ256rmik_VRNDSCALEPSZ256rmikz") 3, false, false, false, 115, 7, 16, 1,  6, 1}, // #2168
  {DBGFIELD("VSCALEFPHZ256rm_VSCALEFPHZ256rmb") 2, false, false, false, 79, 8,  8, 1,  6, 1}, // #2169
  {DBGFIELD("VSCALEFSHZrm")       2, false, false, false, 79, 8,  9, 1,  6, 1}, // #2170
  {DBGFIELD("VFCMADDCPHZ128mbk_VFCMADDCPHZ128mkz_VFMADDCPHZ128mbk_VFMADDCPHZ128mkz_VFCMADDCPHZ128mbkz_VFCMADDCPHZ128mk_VFMADDCPHZ128mbkz_VFMADDCPHZ128mk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2171
  {DBGFIELD("VFCMADDCPHZ256mbk_VFCMADDCPHZ256mkz_VFMADDCPHZ256mbk_VFMADDCPHZ256mkz_VFCMADDCPHZ256mbkz_VFCMADDCPHZ256mk_VFMADDCPHZ256mbkz_VFMADDCPHZ256mk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2172
  {DBGFIELD("VFCMADDCSHZmk_VFCMADDCSHZmkz_VFMADDCSHZmk_VFMADDCSHZmkz_VFCMULCPHZ128rmbk_VFCMULCPHZ128rmkz_VFMULCPHZ128rmbk_VFMULCPHZ128rmkz_VFCMULCPHZ128rmbkz_VFCMULCPHZ128rmk_VFMULCPHZ128rmbkz_VFMULCPHZ128rmk_VFCMULCSHZrmk_VFCMULCSHZrmkz_VFMULCSHZrmk_VFMULCSHZrmkz") 2, false, false, false, 103, 7,  8, 1,  6, 1}, // #2173
  {DBGFIELD("VFCMULCPHZ256rmbk_VFCMULCPHZ256rmkz_VFMULCPHZ256rmbk_VFMULCPHZ256rmkz_VFCMULCPHZ256rmbkz_VFCMULCPHZ256rmk_VFMULCPHZ256rmbkz_VFMULCPHZ256rmk") 2, false, false, false, 103, 7,  2, 1,  6, 1}, // #2174
  {DBGFIELD("VFCMADDCPHZ128r_VFMADDCPHZ128r_VFCMADDCSHZr_VFCMADDCSHZrb_VFMADDCSHZr_VFMADDCSHZrb_VFCMULCPHZ128rr_VFMULCPHZ128rr_VFCMULCSHZrr_VFCMULCSHZrrb_VFMULCSHZrr_VFMULCSHZrrb") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2175
  {DBGFIELD("VFCMADDCPHZ256r_VFMADDCPHZ256r_VFCMULCPHZ256rr_VFMULCPHZ256rr") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2176
  {DBGFIELD("VRNDSCALEPHZ128rri_VRNDSCALESHZr_Int_VRNDSCALESHZrb_Int") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #2177
  {DBGFIELD("VRNDSCALEPHZ256rri") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #2178
  {DBGFIELD("VSCALEFPHZ128rr")    1, false, false, false, 87, 6,  5, 1,  0, 0}, // #2179
  {DBGFIELD("VSCALEFPHZ256rr")    1, false, false, false, 87, 6,  5, 1,  0, 0}, // #2180
  {DBGFIELD("VRNDSCALESHZr")      2, false, false, false, 122, 5,  7, 1,  0, 0}, // #2181
  {DBGFIELD("VSCALEFSHZrr_VSCALEFSHZrrb_Int") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2182
  {DBGFIELD("VFCMADDCPHZ128rk_VFCMADDCPHZ128rkz_VFMADDCPHZ128rk_VFMADDCPHZ128rkz_VFCMADDCSHZrbk_VFCMADDCSHZrkz_VFMADDCSHZrbk_VFMADDCSHZrkz_VFCMADDCSHZrbkz_VFCMADDCSHZrk_VFMADDCSHZrbkz_VFMADDCSHZrk_VFCMULCPHZ128rrk_VFCMULCPHZ128rrkz_VFMULCPHZ128rrk_VFMULCPHZ128rrkz_VFCMULCSHZrrbk_VFCMULCSHZrrkz_VFMULCSHZrrbk_VFMULCSHZrrkz_VFCMULCSHZrrbkz_VFCMULCSHZrrk_VFMULCSHZrrbkz_VFMULCSHZrrk") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2183
  {DBGFIELD("VFCMADDCPHZ256rk_VFCMADDCPHZ256rkz_VFMADDCPHZ256rk_VFMADDCPHZ256rkz_VFCMULCPHZ256rrk_VFCMULCPHZ256rrkz_VFMULCPHZ256rrk_VFMULCPHZ256rrkz") 1, false, false, false, 110, 5, 14, 1,  0, 0}, // #2184
  {DBGFIELD("VFCMADDCPHZm_VFCMADDCPHZmb_VFMADDCPHZm_VFMADDCPHZmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2185
  {DBGFIELD("VFCMULCPHZrm_VFCMULCPHZrmb_VFMULCPHZrm_VFMULCPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2186
  {DBGFIELD("VRNDSCALEPDZrmbi_VRNDSCALEPDZrmi_VRNDSCALEPHZrmbi_VRNDSCALEPHZrmi_VRNDSCALEPSZrmbi_VRNDSCALEPSZrmi_VRNDSCALEPDZrmbik_VRNDSCALEPDZrmbikz_VRNDSCALEPDZrmik_VRNDSCALEPDZrmikz_VRNDSCALEPSZrmbik_VRNDSCALEPSZrmbikz_VRNDSCALEPSZrmik_VRNDSCALEPSZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2187
  {DBGFIELD("VSCALEFPHZrm_VSCALEFPHZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2188
  {DBGFIELD("VFCMADDCPHZmbk_VFCMADDCPHZmkz_VFMADDCPHZmbk_VFMADDCPHZmkz_VFCMADDCPHZmbkz_VFCMADDCPHZmk_VFMADDCPHZmbkz_VFMADDCPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2189
  {DBGFIELD("VFCMULCPHZrmbk_VFCMULCPHZrmkz_VFMULCPHZrmbk_VFMULCPHZrmkz_VFCMULCPHZrmbkz_VFCMULCPHZrmk_VFMULCPHZrmbkz_VFMULCPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2190
  {DBGFIELD("VFCMADDCPHZr_VFCMADDCPHZrb_VFMADDCPHZr_VFMADDCPHZrb_VFCMULCPHZrr_VFCMULCPHZrrb_VFMULCPHZrr_VFMULCPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2191
  {DBGFIELD("VRNDSCALEPHZrri_VRNDSCALEPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2192
  {DBGFIELD("VSCALEFPHZrr_VSCALEFPHZrrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2193
  {DBGFIELD("VFCMADDCPHZrbk_VFCMADDCPHZrkz_VFMADDCPHZrbk_VFMADDCPHZrkz_VFCMADDCPHZrbkz_VFCMADDCPHZrk_VFMADDCPHZrbkz_VFMADDCPHZrk_VFCMULCPHZrrbk_VFCMULCPHZrrkz_VFMULCPHZrrbk_VFMULCPHZrrkz_VFCMULCPHZrrbkz_VFCMULCPHZrrk_VFMULCPHZrrbkz_VFMULCPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2194
  {DBGFIELD("VGATHERDPDZ128rm_VGATHERQPDZ128rm_VPGATHERDQZ128rm_VPGATHERQQZ128rm") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #2195
  {DBGFIELD("VGATHERDPDZ256rm_VGATHERQPDZ256rm_VPGATHERDQZ256rm_VPGATHERQQZ256rm") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #2196
  {DBGFIELD("VGATHERQPSZ256rm_VPGATHERQDZ256rm") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #2197
  {DBGFIELD("VGATHERDPDZrm_VGATHERQPDZrm_VPGATHERDQZrm_VPGATHERQQZrm") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #2198
  {DBGFIELD("VGATHERQPSZrm_VPGATHERQDZrm") 1, false, false, false, 56, 3, 42, 2,  0, 0}, // #2199
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rmbik_VGF2P8AFFINEINVQBZ128rmbikz_VGF2P8AFFINEINVQBZ128rmik_VGF2P8AFFINEINVQBZ128rmikz_VGF2P8AFFINEQBZ128rmbik_VGF2P8AFFINEQBZ128rmbikz_VGF2P8AFFINEQBZ128rmik_VGF2P8AFFINEQBZ128rmikz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2200
  {DBGFIELD("VGF2P8MULBZ128rmk_VGF2P8MULBZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #2201
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rmbik_VGF2P8AFFINEINVQBZ256rmbikz_VGF2P8AFFINEINVQBZ256rmik_VGF2P8AFFINEINVQBZ256rmikz_VGF2P8AFFINEQBZ256rmbik_VGF2P8AFFINEQBZ256rmbikz_VGF2P8AFFINEQBZ256rmik_VGF2P8AFFINEQBZ256rmikz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2202
  {DBGFIELD("VGF2P8MULBZ256rmk_VGF2P8MULBZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #2203
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rrik_VGF2P8AFFINEQBZ128rrik") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2204
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rrik_VGF2P8AFFINEQBZ256rrik") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2205
  {DBGFIELD("VGF2P8MULBZ128rrk")  1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2206
  {DBGFIELD("VGF2P8MULBZ256rrk")  1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2207
  {DBGFIELD("VGF2P8AFFINEINVQBZ128rrikz_VGF2P8AFFINEQBZ128rrikz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2208
  {DBGFIELD("VGF2P8AFFINEINVQBZ256rrikz_VGF2P8AFFINEQBZ256rrikz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2209
  {DBGFIELD("VGF2P8MULBZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2210
  {DBGFIELD("VGF2P8MULBZ256rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2211
  {DBGFIELD("VGF2P8AFFINEINVQBZrmbik_VGF2P8AFFINEINVQBZrmbikz_VGF2P8AFFINEINVQBZrmik_VGF2P8AFFINEINVQBZrmikz_VGF2P8AFFINEQBZrmbik_VGF2P8AFFINEQBZrmbikz_VGF2P8AFFINEQBZrmik_VGF2P8AFFINEQBZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2212
  {DBGFIELD("VGF2P8MULBZrmk_VGF2P8MULBZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2213
  {DBGFIELD("VGF2P8AFFINEINVQBZrrik_VGF2P8AFFINEQBZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2214
  {DBGFIELD("VGF2P8MULBZrrk")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2215
  {DBGFIELD("VGF2P8AFFINEINVQBZrrikz_VGF2P8AFFINEQBZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2216
  {DBGFIELD("VGF2P8MULBZrrkz")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2217
  {DBGFIELD("VMOVDQU16Z128rmk_VMOVDQU16Z128rmkz_VMOVDQU8Z128rmk_VMOVDQU8Z128rmkz") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #2218
  {DBGFIELD("VMOVDQU16Z256rmk_VMOVDQU16Z256rmkz_VMOVDQU8Z256rmk_VMOVDQU8Z256rmkz") 1, false, false, false, 56, 3,  7, 1,  0, 0}, // #2219
  {DBGFIELD("VMOVSHZrmk_VMOVSHZrmkz") 1, false, false, false, 56, 3,  6, 1,  0, 0}, // #2220
  {DBGFIELD("VPBLENDMBZ128rmk_VPBLENDMBZ128rmkz_VPBLENDMWZ128rmk_VPBLENDMWZ128rmkz") 2, false, false, false, 104, 6,  7, 1,  6, 1}, // #2221
  {DBGFIELD("VPBLENDMBZ256rmk_VPBLENDMBZ256rmkz_VPBLENDMWZ256rmk_VPBLENDMWZ256rmkz") 4, false, false, false, 868, 6,  9, 1,  6, 1}, // #2222
  {DBGFIELD("VMOVDQU16Z128rrk_VMOVDQU16Z128rrk_REV_VMOVDQU16Z128rrkz_VMOVDQU16Z128rrkz_REV_VMOVDQU8Z128rrk_VMOVDQU8Z128rrk_REV_VMOVDQU8Z128rrkz_VMOVDQU8Z128rrkz_REV_VPMOVM2BZ128rr_VPMOVM2WZ128rr") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2223
  {DBGFIELD("VMOVDQU16Z256rrk_VMOVDQU16Z256rrk_REV_VMOVDQU16Z256rrkz_VMOVDQU16Z256rrkz_REV_VMOVDQU8Z256rrk_VMOVDQU8Z256rrk_REV_VMOVDQU8Z256rrkz_VMOVDQU8Z256rrkz_REV_VPMOVM2BZ256rr_VPMOVM2WZ256rr") 0, false, false, false,  0, 0,  1, 1,  0, 0}, // #2224
  {DBGFIELD("VMOVSHZrrk_VMOVSHZrrk_REV_VMOVSHZrrkz_VMOVSHZrrkz_REV") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #2225
  {DBGFIELD("VPBLENDMBZ128rrk_VPBLENDMBZ128rrkz_VPBLENDMWZ128rrk_VPBLENDMWZ128rrkz") 1, false, false, false, 111, 4,  1, 1,  0, 0}, // #2226
  {DBGFIELD("VPBLENDMBZ256rrk_VPBLENDMBZ256rrkz_VPBLENDMWZ256rrk_VPBLENDMWZ256rrkz") 3, false, false, false, 874, 4,  5, 1,  0, 0}, // #2227
  {DBGFIELD("VMOVDQU8Zmrk")       2, false, false, false, 52, 4,  2, 1,  0, 0}, // #2228
  {DBGFIELD("VMOVNTDQZ128mr")     2, false, false, false, 52, 4, 25, 1,  0, 0}, // #2229
  {DBGFIELD("VMOVNTDQZ256mr")     2, false, false, false, 52, 4, 44, 1,  0, 0}, // #2230
  {DBGFIELD("VMOVNTDQZmr")        2, false, false, false, 52, 4, 44, 1,  0, 0}, // #2231
  {DBGFIELD("VMOVNTPDZ128mr")     2, false, false, false, 52, 4, 27, 1,  0, 0}, // #2232
  {DBGFIELD("VMOVNTPDZ256mr")     2, false, false, false, 52, 4, 45, 1,  0, 0}, // #2233
  {DBGFIELD("VMOVNTPDZmr")        2, false, false, false, 52, 4, 45, 1,  0, 0}, // #2234
  {DBGFIELD("VMOVNTPSZ128mr")     2, false, false, false, 52, 4, 27, 1,  0, 0}, // #2235
  {DBGFIELD("VMOVNTPSZ256mr")     2, false, false, false, 52, 4, 45, 1,  0, 0}, // #2236
  {DBGFIELD("VMOVNTPSZmr")        2, false, false, false, 52, 4, 45, 1,  0, 0}, // #2237
  {DBGFIELD("VP2INTERSECTDZ128rm_VP2INTERSECTDZ128rmb") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #2238
  {DBGFIELD("VP2INTERSECTQZ256rm_VP2INTERSECTQZ256rmb") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #2239
  {DBGFIELD("VP2INTERSECTDZ128rr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2240
  {DBGFIELD("VP2INTERSECTQZ256rr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2241
  {DBGFIELD("VP2INTERSECTDZ256rm_VP2INTERSECTDZ256rmb") 2, false, false, false, 103, 7, 22, 1,  6, 1}, // #2242
  {DBGFIELD("VP2INTERSECTDZ256rr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2243
  {DBGFIELD("VP2INTERSECTDZrm_VP2INTERSECTDZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2244
  {DBGFIELD("VP2INTERSECTDZrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2245
  {DBGFIELD("VP2INTERSECTQZ128rm_VP2INTERSECTQZ128rmb") 2, false, false, false, 103, 7,  7, 1,  6, 1}, // #2246
  {DBGFIELD("VP2INTERSECTQZ128rr") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2247
  {DBGFIELD("VP2INTERSECTQZrm_VP2INTERSECTQZrmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2248
  {DBGFIELD("VP2INTERSECTQZrr")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2249
  {DBGFIELD("VPABSBZ128rrk_VPABSBZ128rrkz_VPABSWZ128rrk_VPABSWZ128rrkz_VPSUBSBZ128rrk_VPSUBSBZ128rrkz_VPSUBSWZ128rrk_VPSUBSWZ128rrkz_VPADDSBZ128rrk_VPADDSBZ128rrkz_VPADDSWZ128rrk_VPADDSWZ128rrkz_VPADDUSBZ128rrk_VPADDUSBZ128rrkz_VPADDUSWZ128rrk_VPADDUSWZ128rrkz_VPAVGBZ128rrk_VPAVGBZ128rrkz_VPAVGWZ128rrk_VPAVGWZ128rrkz_VPSUBUSBZ128rrk_VPSUBUSBZ128rrkz_VPSUBUSWZ128rrk_VPSUBUSWZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2250
  {DBGFIELD("VPABSBZ256rrk_VPABSBZ256rrkz_VPABSWZ256rrk_VPABSWZ256rrkz_VPSUBSBZ256rrk_VPSUBSBZ256rrkz_VPSUBSWZ256rrk_VPSUBSWZ256rrkz_VPADDSBZ256rrk_VPADDSBZ256rrkz_VPADDSWZ256rrk_VPADDSWZ256rrkz_VPADDUSBZ256rrk_VPADDUSBZ256rrkz_VPADDUSWZ256rrk_VPADDUSWZ256rrkz_VPAVGBZ256rrk_VPAVGBZ256rrkz_VPAVGWZ256rrk_VPAVGWZ256rrkz_VPMAXSBZ256rrk_VPMAXSBZ256rrkz_VPMAXUWZ256rrk_VPMAXUWZ256rrkz_VPMINSBZ256rrk_VPMINSBZ256rrkz_VPMINUWZ256rrk_VPMINUWZ256rrkz_VPMAXSWZ256rrk_VPMAXSWZ256rrkz_VPMAXUBZ256rrk_VPMAXUBZ256rrkz_VPMINSWZ256rrk_VPMINSWZ256rrkz_VPMINUBZ256rrk_VPMINUBZ256rrkz_VPSUBUSBZ256rrk_VPSUBUSBZ256rrkz_VPSUBUSWZ256rrk_VPSUBUSWZ256rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2251
  {DBGFIELD("VPMAXSBZ128rrk_VPMAXSBZ128rrkz_VPMAXUWZ128rrk_VPMAXUWZ128rrkz_VPMINSBZ128rrk_VPMINSBZ128rrkz_VPMINUWZ128rrk_VPMINUWZ128rrkz_VPMAXSWZ128rrk_VPMAXSWZ128rrkz_VPMAXUBZ128rrk_VPMAXUBZ128rrkz_VPMINSWZ128rrk_VPMINSWZ128rrkz_VPMINUBZ128rrk_VPMINUBZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2252
  {DBGFIELD("VPSHLDVWZ128rk_VPSHLDVWZ128rkz_VPSHRDVWZ128rk_VPSHRDVWZ128rkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2253
  {DBGFIELD("VPSHLDVWZ256rk_VPSHLDVWZ256rkz_VPSHRDVWZ256rk_VPSHRDVWZ256rkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2254
  {DBGFIELD("VPSLLVWZ128rrk_VPSLLVWZ128rrkz_VPSRLVWZ128rrk_VPSRLVWZ128rrkz_VPSRAVWZ128rrk_VPSRAVWZ128rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2255
  {DBGFIELD("VPSLLVWZ256rrk_VPSLLVWZ256rrkz_VPSRLVWZ256rrk_VPSRLVWZ256rrkz_VPSRAVWZ256rrk_VPSRAVWZ256rrkz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2256
  {DBGFIELD("VPSLLWZ128rik_VPSLLWZ128rikz_VPSRLWZ128rik_VPSRLWZ128rikz_VPSRAWZ128rik_VPSRAWZ128rikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2257
  {DBGFIELD("VPSLLWZ256rik_VPSLLWZ256rikz_VPSRLWZ256rik_VPSRLWZ256rikz_VPSRAWZ256rik_VPSRAWZ256rikz") 1, false, false, false, 110, 5,  1, 1,  0, 0}, // #2258
  {DBGFIELD("VSHUFPDZ256rmbi_VSHUFPDZ256rmik_VSHUFPSZ256rmbi_VSHUFPSZ256rmik_VSHUFPDZ256rmbik_VSHUFPDZ256rmbikz_VSHUFPSZ256rmbik_VSHUFPSZ256rmbikz_VSHUFPDZ256rmi_VSHUFPDZ256rmikz_VSHUFPSZ256rmi_VSHUFPSZ256rmikz") 2, false, false, false, 540, 12, 22, 1,  6, 1}, // #2259
  {DBGFIELD("VPBROADCASTMB2QZ128rr_VPBROADCASTMB2QZ256rr_VPBROADCASTMW2DZ128rr_VPBROADCASTMW2DZ256rr_VPBROADCASTMB2QZrr_VPBROADCASTMW2DZrr") 1, false, false, false, 93, 10,  1, 1,  0, 0}, // #2260
  {DBGFIELD("VPERMWZrrk_VPERMWZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2261
  {DBGFIELD("VPSRAWZrrk_VPSRAWZrrkz_VPSLLWZrrk_VPSLLWZrrkz_VPSRLWZrrk_VPSRLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2262
  {DBGFIELD("VPSHUFBITQMBZ128rr") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2263
  {DBGFIELD("VPSHUFBITQMBZ256rr") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2264
  {DBGFIELD("VPSHUFBITQMBZrr")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2265
  {DBGFIELD("VPCOMPRESSBZ128mr_VPCOMPRESSBZ256mr_VPCOMPRESSWZ128mr_VPCOMPRESSWZ256mr") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2266
  {DBGFIELD("VPCOMPRESSWZmr")     2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2267
  {DBGFIELD("VPCOMPRESSBZ128mrk_VPCOMPRESSBZ256mrk_VPCOMPRESSWZ128mrk_VPCOMPRESSWZ256mrk") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2268
  {DBGFIELD("VPCOMPRESSWZmrk")    2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2269
  {DBGFIELD("VPCOMPRESSBZmr")     2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2270
  {DBGFIELD("VPCOMPRESSBZmrk")    2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2271
  {DBGFIELD("VPCONFLICTDZ128rm_VPCONFLICTDZ128rmb_VPCONFLICTDZ128rmbk_VPCONFLICTDZ128rmk_VPCONFLICTDZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  0, 0}, // #2272
  {DBGFIELD("VPCONFLICTDZ256rm_VPCONFLICTDZ256rmb_VPCONFLICTDZ256rmbk_VPCONFLICTDZ256rmk_VPCONFLICTDZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  0, 0}, // #2273
  {DBGFIELD("VPCONFLICTDZrm_VPCONFLICTDZrmb_VPCONFLICTDZrmbk_VPCONFLICTDZrmk_VPCONFLICTDZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2274
  {DBGFIELD("VPCONFLICTDZrr_VPCONFLICTDZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2275
  {DBGFIELD("VPCONFLICTQZ128rm_VPCONFLICTQZ128rmb_VPCONFLICTQZ128rmbk_VPCONFLICTQZ128rmk_VPCONFLICTQZ128rmkz") 2, false, false, false, 103, 7,  7, 1,  0, 0}, // #2276
  {DBGFIELD("VPERMI2BZ128rm_VPERMT2BZ128rm") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2277
  {DBGFIELD("VPCONFLICTQZ256rm_VPCONFLICTQZ256rmb_VPCONFLICTQZ256rmbk_VPCONFLICTQZ256rmk_VPCONFLICTQZ256rmkz") 2, false, false, false, 103, 7, 22, 1,  0, 0}, // #2278
  {DBGFIELD("VPCONFLICTQZrm_VPCONFLICTQZrmb_VPCONFLICTQZrmbk_VPCONFLICTQZrmk_VPCONFLICTQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2279
  {DBGFIELD("VPCONFLICTQZrr_VPCONFLICTQZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2280
  {DBGFIELD("VPERMI2BZ128rmk_VPERMI2BZ128rmkz_VPERMT2BZ128rmk_VPERMT2BZ128rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2281
  {DBGFIELD("VPERMT2WZ128rm")     2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2282
  {DBGFIELD("VPERMI2BZ128rr_VPERMT2BZ128rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2283
  {DBGFIELD("VPERMI2BZ256rr_VPERMT2BZ256rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2284
  {DBGFIELD("VPERMI2BZ256rrk_VPERMI2BZ256rrkz_VPERMT2BZ256rrk_VPERMT2BZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2285
  {DBGFIELD("VPERMI2WZ128rr_VPERMT2WZ128rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2286
  {DBGFIELD("VPERMI2WZ256rr_VPERMT2WZ256rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2287
  {DBGFIELD("VPERMI2BZ256rm_VPERMT2BZ256rm") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2288
  {DBGFIELD("VPERMI2BZ256rmk_VPERMI2BZ256rmkz_VPERMT2BZ256rmk_VPERMT2BZ256rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2289
  {DBGFIELD("VPERMI2WZ128rm")     2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2290
  {DBGFIELD("VPERMT2WZ256rm")     2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2291
  {DBGFIELD("VPERMI2BZrm_VPERMT2BZrm") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2292
  {DBGFIELD("VPERMI2BZrmk_VPERMI2BZrmkz_VPERMT2BZrmk_VPERMT2BZrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2293
  {DBGFIELD("VPERMT2WZrm")        2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2294
  {DBGFIELD("VPERMI2BZrr_VPERMT2BZrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2295
  {DBGFIELD("VPERMI2BZrrk_VPERMI2BZrrkz_VPERMT2BZrrk_VPERMT2BZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2296
  {DBGFIELD("VPERMI2WZrr_VPERMT2WZrr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2297
  {DBGFIELD("VPERMI2WZ128rmk_VPERMI2WZ128rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2298
  {DBGFIELD("VPERMT2WZ256rmk_VPERMT2WZ256rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2299
  {DBGFIELD("VPERMI2WZ256rm")     2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2300
  {DBGFIELD("VPERMI2WZ256rmk_VPERMI2WZ256rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2301
  {DBGFIELD("VPERMI2WZrm")        2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2302
  {DBGFIELD("VPERMI2WZrmk_VPERMI2WZrmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2303
  {DBGFIELD("VPERMWZ128rm")       2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2304
  {DBGFIELD("VPERMWZ256rmk_VPERMWZ256rmkz") 2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2305
  {DBGFIELD("VPERMWZ128rr")       1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2306
  {DBGFIELD("VPERMWZ256rr")       1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2307
  {DBGFIELD("VPERMWZ256rm")       2, false, false, false, 540, 12,  8, 1,  6, 1}, // #2308
  {DBGFIELD("VPEXPANDBZ128rrk_VPEXPANDBZ128rrkz_VPEXPANDWZ128rrk_VPEXPANDWZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2309
  {DBGFIELD("VPEXPANDBZ256rrk_VPEXPANDBZ256rrkz_VPEXPANDWZ256rrk_VPEXPANDWZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2310
  {DBGFIELD("VPEXPANDBZrrk_VPEXPANDBZrrkz_VPEXPANDWZrrk_VPEXPANDWZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2311
  {DBGFIELD("VPMADDUBSWZ128rrk_VPMADDUBSWZ128rrkz_VPMULHRSWZ128rrk_VPMULHRSWZ128rrkz_VPMULHUWZ128rrk_VPMULHUWZ128rrkz_VPMULHWZ128rrk_VPMULHWZ128rrkz_VPMULLWZ128rrk_VPMULLWZ128rrkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2312
  {DBGFIELD("VPMADDUBSWZ256rrk_VPMADDUBSWZ256rrkz_VPMULHRSWZ256rrk_VPMULHRSWZ256rrkz_VPMULHUWZ256rrk_VPMULHUWZ256rrkz_VPMULHWZ256rrk_VPMULHWZ256rrkz_VPMULLWZ256rrk_VPMULLWZ256rrkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2313
  {DBGFIELD("VPMADDUBSWZrmk_VPMADDUBSWZrmkz_VPMULHRSWZrmk_VPMULHRSWZrmkz_VPMULHUWZrmk_VPMULHUWZrmkz_VPMULHWZrmk_VPMULHWZrmkz_VPMULLWZrmk_VPMULLWZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2314
  {DBGFIELD("VPMADDUBSWZrrk_VPMADDUBSWZrrkz_VPMULHRSWZrrk_VPMULHRSWZrrkz_VPMULHUWZrrk_VPMULHUWZrrkz_VPMULHWZrrk_VPMULHWZrrkz_VPMULLWZrrk_VPMULLWZrrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2315
  {DBGFIELD("VPMOVDBZ128mr_VPMOVDBZ256mr_VPMOVUSDBZ128mr_VPMOVUSDBZ256mr_VPMOVDWZ128mr_VPMOVDWZ256mr_VPMOVQWZ128mr_VPMOVQWZ256mr_VPMOVSDWZ128mr_VPMOVSDWZ256mr_VPMOVSQWZ128mr_VPMOVSQWZ256mr_VPMOVUSDWZ128mr_VPMOVUSDWZ256mr_VPMOVUSQWZ128mr_VPMOVUSQWZ256mr_VPMOVQBZ256mr_VPMOVSDBZ256mr_VPMOVSWBZ256mr_VPMOVWBZ256mr_VPMOVSDBZ128mr_VPMOVWBZ128mr_VPMOVSQBZ256mr_VPMOVUSQBZ256mr_VPMOVSQDZ128mr_VPMOVSQDZ256mr_VPMOVUSQDZ128mr_VPMOVUSQDZ256mr_VPMOVSWBZ128mr_VPMOVUSWBZ128mr") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2316
  {DBGFIELD("VPMOVUSWBZ256mr")    2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2317
  {DBGFIELD("VPMOVDBZ128mrk_VPMOVQBZ128mrk_VPMOVSQBZ128mrk_VPMOVSWBZ128mrk_VPMOVWBZ128mrk_VPMOVDWZ128mrk_VPMOVQWZ128mrk_VPMOVSDWZ128mrk_VPMOVSQWZ128mrk_VPMOVUSDWZ128mrk_VPMOVUSQWZ128mrk_VPMOVSDBZ128mrk_VPMOVSQDZ128mrk_VPMOVUSDBZ128mrk_VPMOVUSQDZ128mrk_VPMOVUSQBZ128mrk_VPMOVUSWBZ128mrk") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2318
  {DBGFIELD("VPMOVDBZ128rr_VPMOVQBZ128rr_VPMOVSQBZ128rr_VPMOVSWBZ128rr_VPMOVWBZ128rr_VPMOVDWZ128rr_VPMOVQWZ128rr_VPMOVSDWZ128rr_VPMOVSQWZ128rr_VPMOVUSDWZ128rr_VPMOVSDBZ128rr_VPMOVSQDZ128rr_VPMOVUSDBZ128rr_VPMOVUSQDZ128rr_VPMOVSQDZ128rrk_VPMOVSQDZ128rrkz_VPMOVUSQDZ128rrk_VPMOVUSQDZ128rrkz_VPMOVUSQBZ128rr_VPMOVUSWBZ128rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2319
  {DBGFIELD("VPMOVUSQWZ128rr")    1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2320
  {DBGFIELD("VPMOVDBZ128rrk_VPMOVDBZ128rrkz_VPMOVQBZ128rrk_VPMOVQBZ128rrkz_VPMOVSQBZ128rrk_VPMOVSQBZ128rrkz_VPMOVSWBZ128rrk_VPMOVSWBZ128rrkz_VPMOVWBZ128rrk_VPMOVWBZ128rrkz_VPMOVDBZ256rr_VPMOVQBZ256rr_VPMOVSQBZ256rr_VPMOVSWBZ256rr_VPMOVWBZ256rr_VPMOVDWZ128rrk_VPMOVDWZ128rrkz_VPMOVQWZ128rrk_VPMOVQWZ128rrkz_VPMOVSDWZ128rrk_VPMOVSDWZ128rrkz_VPMOVSQWZ128rrk_VPMOVSQWZ128rrkz_VPMOVUSDWZ128rrk_VPMOVUSDWZ128rrkz_VPMOVDWZ256rr_VPMOVQWZ256rr_VPMOVSDWZ256rr_VPMOVSQWZ256rr_VPMOVUSDWZ256rr_VPMOVSDBZ128rrk_VPMOVSDBZ128rrkz_VPMOVUSDBZ128rrk_VPMOVUSDBZ128rrkz_VPMOVSDBZ256rr_VPMOVSQDZ256rr_VPMOVUSDBZ256rr_VPMOVUSQDZ256rr_VPMOVSQDZ256rrk_VPMOVSQDZ256rrkz_VPMOVUSQDZ256rrk_VPMOVUSQDZ256rrkz_VPMOVUSQBZ128rrk_VPMOVUSQBZ128rrkz_VPMOVUSWBZ128rrk_VPMOVUSWBZ128rrkz_VPMOVUSQBZ256rr_VPMOVUSWBZ256rr") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2321
  {DBGFIELD("VPMOVUSQWZ128rrk_VPMOVUSQWZ128rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2322
  {DBGFIELD("VPMOVUSQWZ256rr")    1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2323
  {DBGFIELD("VPMOVDBZ256mrk_VPMOVQBZ256mrk_VPMOVSQBZ256mrk_VPMOVSWBZ256mrk_VPMOVWBZ256mrk_VPMOVDWZ256mrk_VPMOVQWZ256mrk_VPMOVSDWZ256mrk_VPMOVSQWZ256mrk_VPMOVUSDWZ256mrk_VPMOVUSQWZ256mrk_VPMOVSDBZ256mrk_VPMOVSQDZ256mrk_VPMOVUSDBZ256mrk_VPMOVUSQDZ256mrk_VPMOVUSQBZ256mrk_VPMOVUSWBZ256mrk") 2, false, false, false, 540, 12,  8, 1,  0, 0}, // #2324
  {DBGFIELD("VPMOVUSQWZ256rrk_VPMOVUSQWZ256rrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2325
  {DBGFIELD("VPMULLQZ128rm_VPMULLQZ128rmb_VPMULLQZ128rmbk_VPMULLQZ128rmk_VPMULLQZ128rmkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2326
  {DBGFIELD("VPMULLQZ256rm_VPMULLQZ256rmb_VPMULLQZ256rmbk_VPMULLQZ256rmk_VPMULLQZ256rmkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2327
  {DBGFIELD("VPMULLQZrm_VPMULLQZrmb_VPMULLQZrmbk_VPMULLQZrmk_VPMULLQZrmkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2328
  {DBGFIELD("VPSCATTERQDZ256mr_VSCATTERQPSZ256mr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #2329
  {DBGFIELD("VPSCATTERDQZmr_VPSCATTERQQZmr_VSCATTERDPDZmr_VSCATTERQPDZmr") 2, false, false, false, 52, 4,  2, 1,  0, 0}, // #2330
  {DBGFIELD("VPSHLDDZ128rmbi_VPSHLDQZ128rmbi_VPSHRDDZ128rmbi_VPSHRDQZ128rmbi_VPSHLDDZ128rmi_VPSHLDQZ128rmi_VPSHLDWZ128rmi_VPSHRDDZ128rmi_VPSHRDQZ128rmi_VPSHRDWZ128rmi_VPSHLDVDZ128m_VPSHLDVQZ128m_VPSHLDVWZ128m_VPSHRDVDZ128m_VPSHRDVQZ128m_VPSHRDVWZ128m_VPSHLDVDZ128mb_VPSHLDVDZ128mk_VPSHLDVDZ128mkz_VPSHLDVQZ128mb_VPSHLDVQZ128mk_VPSHLDVQZ128mkz_VPSHRDVDZ128mb_VPSHRDVDZ128mk_VPSHRDVDZ128mkz_VPSHRDVQZ128mb_VPSHRDVQZ128mk_VPSHRDVQZ128mkz_VPSHLDVDZ128mbk_VPSHLDVDZ128mbkz_VPSHLDVQZ128mbk_VPSHLDVQZ128mbkz_VPSHRDVDZ128mbk_VPSHRDVDZ128mbkz_VPSHRDVQZ128mbk_VPSHRDVQZ128mbkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2331
  {DBGFIELD("VPSHLDDZ128rmbik_VPSHLDDZ128rmbikz_VPSHLDDZ128rmik_VPSHLDDZ128rmikz_VPSHLDQZ128rmbik_VPSHLDQZ128rmbikz_VPSHLDQZ128rmik_VPSHLDQZ128rmikz_VPSHRDDZ128rmbik_VPSHRDDZ128rmbikz_VPSHRDDZ128rmik_VPSHRDDZ128rmikz_VPSHRDQZ128rmbik_VPSHRDQZ128rmbikz_VPSHRDQZ128rmik_VPSHRDQZ128rmikz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2332
  {DBGFIELD("VPSHLDDZ128rri_VPSHLDQZ128rri_VPSHLDWZ128rri_VPSHRDDZ128rri_VPSHRDQZ128rri_VPSHRDWZ128rri_VPSHLDVDZ128rk_VPSHLDVDZ128rkz_VPSHLDVQZ128rk_VPSHLDVQZ128rkz_VPSHRDVDZ128rk_VPSHRDVDZ128rkz_VPSHRDVQZ128rk_VPSHRDVQZ128rkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2333
  {DBGFIELD("VPSHLDDZ256rri_VPSHLDQZ256rri_VPSHLDWZ256rri_VPSHRDDZ256rri_VPSHRDQZ256rri_VPSHRDWZ256rri_VPSHLDVDZ256rk_VPSHLDVDZ256rkz_VPSHLDVQZ256rk_VPSHLDVQZ256rkz_VPSHRDVDZ256rk_VPSHRDVDZ256rkz_VPSHRDVQZ256rk_VPSHRDVQZ256rkz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2334
  {DBGFIELD("VPSHLDVDZ128r_VPSHLDVQZ128r_VPSHLDVWZ128r_VPSHRDVDZ128r_VPSHRDVQZ128r_VPSHRDVWZ128r") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2335
  {DBGFIELD("VPSHLDVDZ256r_VPSHLDVQZ256r_VPSHLDVWZ256r_VPSHRDVDZ256r_VPSHRDVQZ256r_VPSHRDVWZ256r") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2336
  {DBGFIELD("VPSHLDDZ128rrik_VPSHLDDZ128rrikz_VPSHLDQZ128rrik_VPSHLDQZ128rrikz_VPSHRDDZ128rrik_VPSHRDDZ128rrikz_VPSHRDQZ128rrik_VPSHRDQZ128rrikz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2337
  {DBGFIELD("VPSHLDDZ256rrik_VPSHLDDZ256rrikz_VPSHLDQZ256rrik_VPSHLDQZ256rrikz_VPSHRDDZ256rrik_VPSHRDDZ256rrikz_VPSHRDQZ256rrik_VPSHRDQZ256rrikz") 1, false, false, false, 110, 5, 10, 1,  0, 0}, // #2338
  {DBGFIELD("VPSHLDDZ256rmbi_VPSHLDQZ256rmbi_VPSHRDDZ256rmbi_VPSHRDQZ256rmbi_VPSHLDDZ256rmi_VPSHLDQZ256rmi_VPSHLDWZ256rmi_VPSHRDDZ256rmi_VPSHRDQZ256rmi_VPSHRDWZ256rmi_VPSHLDVDZ256m_VPSHLDVQZ256m_VPSHLDVWZ256m_VPSHRDVDZ256m_VPSHRDVQZ256m_VPSHRDVWZ256m_VPSHLDVDZ256mb_VPSHLDVDZ256mk_VPSHLDVDZ256mkz_VPSHLDVQZ256mb_VPSHLDVQZ256mk_VPSHLDVQZ256mkz_VPSHRDVDZ256mb_VPSHRDVDZ256mk_VPSHRDVDZ256mkz_VPSHRDVQZ256mb_VPSHRDVQZ256mk_VPSHRDVQZ256mkz_VPSHLDVDZ256mbk_VPSHLDVDZ256mbkz_VPSHLDVQZ256mbk_VPSHLDVQZ256mbkz_VPSHRDVDZ256mbk_VPSHRDVDZ256mbkz_VPSHRDVQZ256mbk_VPSHRDVQZ256mbkz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2339
  {DBGFIELD("VPSHLDDZ256rmbik_VPSHLDDZ256rmbikz_VPSHLDDZ256rmik_VPSHLDDZ256rmikz_VPSHLDQZ256rmbik_VPSHLDQZ256rmbikz_VPSHLDQZ256rmik_VPSHLDQZ256rmikz_VPSHRDDZ256rmbik_VPSHRDDZ256rmbikz_VPSHRDDZ256rmik_VPSHRDDZ256rmikz_VPSHRDQZ256rmbik_VPSHRDQZ256rmbikz_VPSHRDQZ256rmik_VPSHRDQZ256rmikz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2340
  {DBGFIELD("VPSHLDDZrmbi_VPSHLDQZrmbi_VPSHRDDZrmbi_VPSHRDQZrmbi_VPSHLDDZrmi_VPSHLDQZrmi_VPSHLDWZrmi_VPSHRDDZrmi_VPSHRDQZrmi_VPSHRDWZrmi_VPSHLDVDZm_VPSHLDVQZm_VPSHLDVWZm_VPSHRDVDZm_VPSHRDVQZm_VPSHRDVWZm_VPSHLDVDZmb_VPSHLDVDZmk_VPSHLDVDZmkz_VPSHLDVQZmb_VPSHLDVQZmk_VPSHLDVQZmkz_VPSHRDVDZmb_VPSHRDVDZmk_VPSHRDVDZmkz_VPSHRDVQZmb_VPSHRDVQZmk_VPSHRDVQZmkz_VPSHLDVDZmbk_VPSHLDVDZmbkz_VPSHLDVQZmbk_VPSHLDVQZmbkz_VPSHRDVDZmbk_VPSHRDVDZmbkz_VPSHRDVQZmbk_VPSHRDVQZmbkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2341
  {DBGFIELD("VPSHLDDZrmbik_VPSHLDDZrmbikz_VPSHLDDZrmik_VPSHLDDZrmikz_VPSHLDQZrmbik_VPSHLDQZrmbikz_VPSHLDQZrmik_VPSHLDQZrmikz_VPSHRDDZrmbik_VPSHRDDZrmbikz_VPSHRDDZrmik_VPSHRDDZrmikz_VPSHRDQZrmbik_VPSHRDQZrmbikz_VPSHRDQZrmik_VPSHRDQZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2342
  {DBGFIELD("VPSHLDDZrrik_VPSHLDDZrrikz_VPSHLDQZrrik_VPSHLDQZrrikz_VPSHRDDZrrik_VPSHRDDZrrikz_VPSHRDQZrrik_VPSHRDQZrrikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2343
  {DBGFIELD("VPSHLDWZ128rmik_VPSHLDWZ128rmikz_VPSHRDWZ128rmik_VPSHRDWZ128rmikz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2344
  {DBGFIELD("VPSHLDWZ256rmik_VPSHLDWZ256rmikz_VPSHRDWZ256rmik_VPSHRDWZ256rmikz") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2345
  {DBGFIELD("VPSHLDWZrmik_VPSHLDWZrmikz_VPSHRDWZrmik_VPSHRDWZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2346
  {DBGFIELD("VPSHUFBITQMBZ128rm") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2347
  {DBGFIELD("VPSHUFBITQMBZ256rm") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2348
  {DBGFIELD("VPSHUFBITQMBZrm")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2349
  {DBGFIELD("VPSHUFBITQMBZ128rmk") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2350
  {DBGFIELD("VPSHUFBITQMBZ256rmk") 2, false, false, false, 103, 7, 24, 1,  6, 1}, // #2351
  {DBGFIELD("VPSHUFBITQMBZrmk")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2352
  {DBGFIELD("VPSLLWZ128rrk_VPSLLWZ128rrkz_VPSRLWZ128rrk_VPSRLWZ128rrkz_VPSRAWZ128rrk_VPSRAWZ128rrkz") 2, false, false, false, 743, 7, 12, 1,  0, 0}, // #2353
  {DBGFIELD("VRCPPHZmbk_VRCPPHZmkz_VRCPPHZmbkz_VRCPPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2354
  {DBGFIELD("VRSQRTPHZmbk_VRSQRTPHZmkz_VRSQRTPHZmbkz_VRSQRTPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2355
  {DBGFIELD("VRCPPHZrk_VRCPPHZrkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2356
  {DBGFIELD("VREDUCEPHZ128rmbi_VREDUCEPHZ128rmi") 3, false, false, false, 115, 7, 11, 1,  6, 1}, // #2357
  {DBGFIELD("VREDUCESHZrmi")      3, false, false, false, 115, 7, 11, 1,  6, 1}, // #2358
  {DBGFIELD("VREDUCEPHZ256rmbi_VREDUCEPHZ256rmi") 3, false, false, false, 115, 7, 16, 1,  6, 1}, // #2359
  {DBGFIELD("VREDUCEPHZ128rmbik_VREDUCEPHZ128rmbikz_VREDUCEPHZ128rmik_VREDUCEPHZ128rmikz_VREDUCESHZrmik_VREDUCESHZrmikz") 3, false, false, false, 115, 7, 11, 1,  6, 1}, // #2360
  {DBGFIELD("VREDUCEPHZ256rmbik_VREDUCEPHZ256rmbikz_VREDUCEPHZ256rmik_VREDUCEPHZ256rmikz") 3, false, false, false, 115, 7, 16, 1,  6, 1}, // #2361
  {DBGFIELD("VREDUCEPHZ128rri_VREDUCESHZrri_VREDUCESHZrrib") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #2362
  {DBGFIELD("VREDUCEPHZ256rri")   2, false, false, false, 122, 5,  7, 1,  0, 0}, // #2363
  {DBGFIELD("VREDUCEPHZ128rrik_VREDUCEPHZ128rrikz_VREDUCESHZrribk_VREDUCESHZrrikz_VREDUCESHZrribkz_VREDUCESHZrrik") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #2364
  {DBGFIELD("VREDUCEPHZ256rrik_VREDUCEPHZ256rrikz") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #2365
  {DBGFIELD("VREDUCEPHZrmbi_VREDUCEPHZrmi") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2366
  {DBGFIELD("VREDUCEPHZrmbik_VREDUCEPHZrmbikz_VREDUCEPHZrmik_VREDUCEPHZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2367
  {DBGFIELD("VREDUCEPHZrri_VREDUCEPHZrrib") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2368
  {DBGFIELD("VREDUCEPHZrribk_VREDUCEPHZrrikz_VREDUCEPHZrribkz_VREDUCEPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2369
  {DBGFIELD("VRNDSCALEPDZrri_VRNDSCALEPDZrrib_VRNDSCALEPDZrribk_VRNDSCALEPDZrrik_VRNDSCALEPDZrrikz_VRNDSCALEPSZrri_VRNDSCALEPSZrrib_VRNDSCALEPSZrribk_VRNDSCALEPSZrrik_VRNDSCALEPSZrrikz_VRNDSCALEPDZrribkz_VRNDSCALEPSZrribkz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2370
  {DBGFIELD("VRNDSCALEPHZ128rmbik_VRNDSCALEPHZ128rmbikz_VRNDSCALEPHZ128rmik_VRNDSCALEPHZ128rmikz_VRNDSCALESHZm_Intk_VRNDSCALESHZm_Intkz") 3, false, false, false, 115, 7, 11, 1,  6, 1}, // #2371
  {DBGFIELD("VSCALEFPHZ128rmbk_VSCALEFPHZ128rmkz_VSCALEFPHZ128rmbkz_VSCALEFPHZ128rmk") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #2372
  {DBGFIELD("VRNDSCALEPHZ256rmbik_VRNDSCALEPHZ256rmbikz_VRNDSCALEPHZ256rmik_VRNDSCALEPHZ256rmikz") 3, false, false, false, 115, 7, 16, 1,  6, 1}, // #2373
  {DBGFIELD("VSCALEFPHZ256rmbk_VSCALEFPHZ256rmkz_VSCALEFPHZ256rmbkz_VSCALEFPHZ256rmk") 2, false, false, false, 79, 8,  8, 1,  6, 1}, // #2374
  {DBGFIELD("VSCALEFSHZrmk_VSCALEFSHZrmkz") 2, false, false, false, 79, 8,  9, 1,  6, 1}, // #2375
  {DBGFIELD("VRNDSCALEPHZ128rrik_VRNDSCALEPHZ128rrikz_VRNDSCALESHZr_Intk_VRNDSCALESHZr_Intkz_VRNDSCALESHZrb_Intk_VRNDSCALESHZrb_Intkz") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #2376
  {DBGFIELD("VRNDSCALEPHZ256rrik_VRNDSCALEPHZ256rrikz") 2, false, false, false, 122, 5,  7, 1,  0, 0}, // #2377
  {DBGFIELD("VSCALEFPHZ128rrk_VSCALEFPHZ128rrkz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #2378
  {DBGFIELD("VSCALEFPHZ256rrk_VSCALEFPHZ256rrkz") 1, false, false, false, 87, 6,  5, 1,  0, 0}, // #2379
  {DBGFIELD("VSCALEFSHZrrb_Intk_VSCALEFSHZrrb_Intkz_VSCALEFSHZrrk_VSCALEFSHZrrkz") 1, false, false, false, 93, 10,  5, 1,  0, 0}, // #2380
  {DBGFIELD("VRNDSCALEPHZrmbik_VRNDSCALEPHZrmbikz_VRNDSCALEPHZrmik_VRNDSCALEPHZrmikz") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2381
  {DBGFIELD("VSCALEFPHZrmbk_VSCALEFPHZrmkz_VSCALEFPHZrmbkz_VSCALEFPHZrmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2382
  {DBGFIELD("VRNDSCALEPHZrribk_VRNDSCALEPHZrrikz_VRNDSCALEPHZrribkz_VRNDSCALEPHZrrik") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2383
  {DBGFIELD("VSCALEFPHZrrbk_VSCALEFPHZrrkz_VSCALEFPHZrrbkz_VSCALEFPHZrrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2384
  {DBGFIELD("VRSQRT14PDZr_VRSQRT14PSZr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2385
  {DBGFIELD("VRSQRT14PSZrk")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2386
  {DBGFIELD("VRSQRTPHZr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2387
  {DBGFIELD("VSQRTPDYm")          2, false, false, false, 247, 11, 46, 1,  0, 0}, // #2388
  {DBGFIELD("VSQRTPDZ256m_VSQRTPDZ256mb") 2, false, false, false, 247, 11, 46, 1,  6, 1}, // #2389
  {DBGFIELD("VSQRTPDZ128mbk_VSQRTPDZ128mkz_VSQRTPDZ128mbkz_VSQRTPDZ128mk") 2, false, false, false, 247, 11, 41, 1,  6, 1}, // #2390
  {DBGFIELD("VSQRTSDZm_Intk_VSQRTSDZm_Intkz") 2, false, false, false, 247, 11, 18, 1,  6, 1}, // #2391
  {DBGFIELD("VSQRTPDZm")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2392
  {DBGFIELD("VSQRTPDZmb")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2393
  {DBGFIELD("VSQRTPDZr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2394
  {DBGFIELD("VSQRTPHZ128mbk_VSQRTPHZ128mkz_VSQRTPHZ128mbkz_VSQRTPHZ128mk") 2, false, false, false, 247, 11, 17, 1,  6, 1}, // #2395
  {DBGFIELD("VSQRTPHZ128rk")      1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2396
  {DBGFIELD("VSQRTPHZ256rk")      1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2397
  {DBGFIELD("VSQRTPHZ256rkz")     1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2398
  {DBGFIELD("VSQRTPHZ128rkz")     1, false, false, false,  3, 9,  2, 1,  0, 0}, // #2399
  {DBGFIELD("VSQRTPHZ256m_VSQRTPHZ256mb") 2, false, false, false, 247, 11, 15, 1,  6, 1}, // #2400
  {DBGFIELD("VSQRTPHZ256mbk_VSQRTPHZ256mkz_VSQRTPHZ256mbkz_VSQRTPHZ256mk") 2, false, false, false, 247, 11, 15, 1,  6, 1}, // #2401
  {DBGFIELD("VSQRTPHZm_VSQRTPHZmb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2402
  {DBGFIELD("VSQRTPHZmbk_VSQRTPHZmkz_VSQRTPHZmbkz_VSQRTPHZmk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2403
  {DBGFIELD("VSQRTPHZr_VSQRTPHZrb") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2404
  {DBGFIELD("VSQRTPHZrbk_VSQRTPHZrkz_VSQRTPHZrbkz_VSQRTPHZrk") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2405
  {DBGFIELD("VSQRTPSZr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #2406
  {DBGFIELD("XTEST")              1, false, false, false, 36, 3,  4, 1,  0, 0}, // #2407
  {DBGFIELD("PdWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2408
  {DBGFIELD("WriteVecALU")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2409
  {DBGFIELD("JWriteZeroLatency")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2410
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2411
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2412
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2413
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2414
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2415
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2416
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2417
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2418
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2419
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2420
  {DBGFIELD("JWriteLOCK_CMPXCHG8B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2421
  {DBGFIELD("JWriteLOCK_CMPXCHG16B") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2422
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2423
  {DBGFIELD("JWriteLOCK_CMPXCHGrm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2424
  {DBGFIELD("JWriteCMPXCHG8B")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2425
  {DBGFIELD("JWriteCMPXCHG16B")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2426
  {DBGFIELD("JWriteCMPXCHG8rm")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2427
  {DBGFIELD("WriteCMPXCHGRMW")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2428
  {DBGFIELD("JWriteCMPXCHG8rr")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2429
  {DBGFIELD("WriteCMPXCHG")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2430
  {DBGFIELD("JWriteLOCK_CMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2431
  {DBGFIELD("JWriteLOCK_CMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2432
  {DBGFIELD("JWriteLOCK_CMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2433
  {DBGFIELD("JWriteLOCK_CMPXCHGrm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2434
  {DBGFIELD("JWriteCMPXCHG8B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2435
  {DBGFIELD("JWriteCMPXCHG16B_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2436
  {DBGFIELD("JWriteCMPXCHG8rm_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2437
  {DBGFIELD("WriteCMPXCHGRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2438
  {DBGFIELD("JWriteCMPXCHG8rr_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2439
  {DBGFIELD("WriteCMPXCHG_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd_ReadAfterLd_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2440
  {DBGFIELD("JWriteLOCK_XADDrm_XCHG_Part_JWriteXCHGrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2441
  {DBGFIELD("JWriteXADDrm_XCHG_Part_JWriteXADDrm_LdSt_Part_ReadAfterLd") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2442
  {DBGFIELD("SBWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2443
  {DBGFIELD("WriteALU")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2444
  {DBGFIELD("HWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2445
  {DBGFIELD("BWWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2446
  {DBGFIELD("Zn3WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2447
  {DBGFIELD("Zn4WriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2448
  {DBGFIELD("SKLWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2449
  {DBGFIELD("SKXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2450
  {DBGFIELD("ICXWriteZeroLatency") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2451
  {DBGFIELD("WriteFLogic")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2452
  {DBGFIELD("WriteFLogicY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2453
  {DBGFIELD("JWriteZeroIdiomYmm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2454
  {DBGFIELD("WriteVecLogicX")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2455
  {DBGFIELD("WriteVecALUX")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2456
  {DBGFIELD("SKLWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2457
  {DBGFIELD("SKXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2458
  {DBGFIELD("ICXWritePSUB")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2459
  {DBGFIELD("SBWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2460
  {DBGFIELD("HWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2461
  {DBGFIELD("BWWritePCMPGTQ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2462
  {DBGFIELD("SKLWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2463
  {DBGFIELD("SKXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2464
  {DBGFIELD("ICXWritePCMPGTQ")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2465
  {DBGFIELD("SBWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2466
  {DBGFIELD("WriteCMOV")          0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2467
  {DBGFIELD("HWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2468
  {DBGFIELD("BWWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2469
  {DBGFIELD("SKLWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2470
  {DBGFIELD("SKXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2471
  {DBGFIELD("ICXWriteCMOVA_CMOVBErr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2472
  {DBGFIELD("SBWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2473
  {DBGFIELD("WriteCMOVLd")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2474
  {DBGFIELD("HWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2475
  {DBGFIELD("BWWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2476
  {DBGFIELD("PdWriteCMOVm")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2477
  {DBGFIELD("SKLWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2478
  {DBGFIELD("SKXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2479
  {DBGFIELD("ICXWriteCMOVA_CMOVBErm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2480
  {DBGFIELD("SBWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2481
  {DBGFIELD("WriteSETCC")         0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2482
  {DBGFIELD("HWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2483
  {DBGFIELD("BWWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2484
  {DBGFIELD("SKLWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2485
  {DBGFIELD("SKXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2486
  {DBGFIELD("ICXWriteSETA_SETBEr") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2487
  {DBGFIELD("SBWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2488
  {DBGFIELD("WriteSETCCStore")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2489
  {DBGFIELD("HWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2490
  {DBGFIELD("BWWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2491
  {DBGFIELD("PdWriteSETGEmSETGmSETLEmSETLm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2492
  {DBGFIELD("SKLWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2493
  {DBGFIELD("SKXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2494
  {DBGFIELD("ICXWriteSETA_SETBEm") 0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2495
  {DBGFIELD("WriteVecLogicY")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2496
  {DBGFIELD("WriteVecALUY")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2497
  {DBGFIELD("HWWriteADC0")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2498
  {DBGFIELD("WriteADC")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2499
  {DBGFIELD("WriteFShuffle256")   0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2500
  {DBGFIELD("Zn3Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2501
  {DBGFIELD("WriteLEA")           0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2502
  {DBGFIELD("Zn4Write3OpsLEA")    0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2503
  {DBGFIELD("PdWrite3OpsLEA")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2504
  {DBGFIELD("JWrite3OpsLEA")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2505
  {DBGFIELD("WriteVecLogic")      0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2506
  {DBGFIELD("JWriteLOCK_ALURMW")  0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2507
  {DBGFIELD("WriteALURMW")        0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2508
  {DBGFIELD("WriteFLogicZ")       0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2509
  {DBGFIELD("WriteVecLogicZ")     0, false, false, false,  0, 0,  0, 0,  0, 0}, // #2510
}; // AlderlakePModelSchedClasses

// {Name, NumMicroOps, BeginGroup, EndGroup, RetireOOO, WriteProcResIdx,#, WriteLatencyIdx,#, ReadAdvanceIdx,#}
static const llvm::MCSchedClassDesc AtomModelSchedClasses[] = {
  {DBGFIELD("InvalidSchedClass")  8191, false, false, false, 0, 0,  0, 0,  0, 0},
  {DBGFIELD("WriteALU")           1, false, false, false,  5, 1,  1, 1,  0, 0}, // #1
  {DBGFIELD("WriteZero")          1, false, false, false,  0, 0,  1, 1,  0, 0}, // #2
  {DBGFIELD("WriteVecALU")        1, false, false, false,  5, 1,  1, 1,  0, 0}, // #3
  {DBGFIELD("WriteJump")          1, false, false, false,  4, 2,  1, 1,  0, 0}, // #4
  {DBGFIELD("WriteCMPXCHGRMW")    1, false, false, false, 2727, 2,  1, 1,  0, 0}, // #5
  {DBGFIELD("WriteJumpLd")        1, false, false, false,  4, 2,  1, 1,  0, 0}, // #6
  {DBGFIELD("WriteMove")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #7
  {DBGFIELD("WriteSystem")        1, false, false, false,  5, 1,  4, 1,  0, 0}, // #8
  {DBGFIELD("WriteLEA")           1, false, false, false,  4, 2,  1, 1,  0, 0}, // #9
  {DBGFIELD("WriteRMW")           1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #10
  {DBGFIELD("WriteADC")           1, false, false, false,  5, 1,  1, 1,  0, 0}, // #11
  {DBGFIELD("WriteSHDrri")        1, false, false, false, 116, 1, 12, 1,  0, 0}, // #12
  {DBGFIELD("WriteFStoreX")       1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #13
  {DBGFIELD("WriteFLoadX")        1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #14
  {DBGFIELD("WriteFStoreY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #15
  {DBGFIELD("WriteFLoadY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #16
  {DBGFIELD("WriteMicrocoded")    1, false, false, false,  5, 1,  4, 1,  0, 0}, // #17
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #18
  {DBGFIELD("WriteFSign")         1, false, false, false,  4, 2,  1, 1,  0, 0}, // #19
  {DBGFIELD("WriteADCRMW")        1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #20
  {DBGFIELD("WriteADCLd_ReadAfterLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #21
  {DBGFIELD("WriteADCRMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 1, false, false, false, 2729, 2,  1, 1, 15, 2}, // #22
  {DBGFIELD("WriteADCLd_ReadAfterLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2729, 2,  1, 1, 17, 2}, // #23
  {DBGFIELD("WriteALURMW")        1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #24
  {DBGFIELD("WriteALULd_ReadAfterLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #25
  {DBGFIELD("WriteALURMW_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2729, 2,  1, 1, 15, 1}, // #26
  {DBGFIELD("WriteFAdd64XLd_ReadAfterVecXLd") 4, false, false, false, 2731, 3,  6, 1, 14, 1}, // #27
  {DBGFIELD("WriteFAdd64X")       3, false, false, false, 2734, 3,  3, 1,  0, 0}, // #28
  {DBGFIELD("WriteFAddXLd_ReadAfterVecXLd") 1, false, false, false, 389, 3, 10, 1, 14, 1}, // #29
  {DBGFIELD("WriteFAddX")         1, false, false, false,  4, 2, 10, 1,  0, 0}, // #30
  {DBGFIELD("WriteNop")           1, false, false, false,  5, 1,  1, 1,  0, 0}, // #31
  {DBGFIELD("WriteFAdd64Ld_ReadAfterVecLd") 1, false, false, false, 389, 3, 10, 1, 14, 1}, // #32
  {DBGFIELD("WriteFAdd64")        1, false, false, false,  4, 2, 10, 1,  0, 0}, // #33
  {DBGFIELD("WriteFAddLd_ReadAfterVecLd") 1, false, false, false, 389, 3, 10, 1, 14, 1}, // #34
  {DBGFIELD("WriteFAdd")          1, false, false, false,  4, 2, 10, 1,  0, 0}, // #35
  {DBGFIELD("WriteFAddLd")        1, false, false, false, 389, 3, 10, 1,  0, 0}, // #36
  {DBGFIELD("WriteAESDecEncLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #37
  {DBGFIELD("WriteAESDecEnc")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #38
  {DBGFIELD("WriteAESIMCLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #39
  {DBGFIELD("WriteAESIMC")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #40
  {DBGFIELD("WriteAESKeyGenLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #41
  {DBGFIELD("WriteAESKeyGen")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #42
  {DBGFIELD("WriteFLogicLd_ReadAfterVecXLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #43
  {DBGFIELD("WriteFLogic")        1, false, false, false,  5, 1,  1, 1,  0, 0}, // #44
  {DBGFIELD("WriteBEXTRLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #45
  {DBGFIELD("WriteBEXTR")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #46
  {DBGFIELD("WriteBEXTRLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #47
  {DBGFIELD("WriteALULd")         1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #48
  {DBGFIELD("WriteFBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #49
  {DBGFIELD("WriteFBlend")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #50
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #51
  {DBGFIELD("WriteFVarBlend")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #52
  {DBGFIELD("WriteBLSLd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #53
  {DBGFIELD("WriteBLS")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #54
  {DBGFIELD("WriteBSFLd")         10, false, false, false, 2737, 3, 16, 1,  0, 0}, // #55
  {DBGFIELD("WriteBSF")           10, false, false, false, 2737, 3, 16, 1,  0, 0}, // #56
  {DBGFIELD("WriteBSRLd")         10, false, false, false, 2737, 3, 16, 1,  0, 0}, // #57
  {DBGFIELD("WriteBSR")           10, false, false, false, 2737, 3, 16, 1,  0, 0}, // #58
  {DBGFIELD("WriteBSWAP32")       1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #59
  {DBGFIELD("WriteBSWAP64")       1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #60
  {DBGFIELD("WriteBitTestImmLd")  1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #61
  {DBGFIELD("WriteBitTestRegLd")  1, false, false, false, 417, 1, 22, 1,  0, 0}, // #62
  {DBGFIELD("WriteBitTest")       1, false, false, false,  4, 2,  1, 1,  0, 0}, // #63
  {DBGFIELD("WriteBitTestSetImmRMW") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #64
  {DBGFIELD("WriteBitTestSetRegRMW") 1, false, false, false, 129, 1,  8, 1,  0, 0}, // #65
  {DBGFIELD("WriteBitTestSet")    1, false, false, false,  4, 2,  1, 1,  0, 0}, // #66
  {DBGFIELD("WriteBZHILd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #67
  {DBGFIELD("WriteBZHI")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #68
  {DBGFIELD("WriteCMOV_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #69
  {DBGFIELD("WriteCMOVLd_ReadAfterLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #70
  {DBGFIELD("WriteCMOV")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #71
  {DBGFIELD("WriteLoad")          1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #72
  {DBGFIELD("WriteFCMOV")         1, false, false, false, 417, 1, 22, 1,  0, 0}, // #73
  {DBGFIELD("WriteALULd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2729, 2,  1, 1, 15, 1}, // #74
  {DBGFIELD("WriteXCHG")          1, false, false, false, 116, 1, 12, 1,  0, 0}, // #75
  {DBGFIELD("WriteFCmp64XLd_ReadAfterVecXLd") 4, false, false, false, 2731, 3,  6, 1, 14, 1}, // #76
  {DBGFIELD("WriteFCmp64X")       3, false, false, false, 2734, 3,  3, 1,  0, 0}, // #77
  {DBGFIELD("WriteFCmpXLd_ReadAfterVecXLd") 4, false, false, false, 2731, 3,  6, 1, 14, 1}, // #78
  {DBGFIELD("WriteFCmpX")         3, false, false, false, 2734, 3,  3, 1,  0, 0}, // #79
  {DBGFIELD("WriteFCmp64Ld_ReadAfterVecLd") 1, false, false, false, 389, 3, 10, 1, 14, 1}, // #80
  {DBGFIELD("WriteFCmp64")        1, false, false, false,  4, 2, 10, 1,  0, 0}, // #81
  {DBGFIELD("WriteFCmpLd_ReadAfterVecLd") 1, false, false, false, 389, 3, 10, 1, 14, 1}, // #82
  {DBGFIELD("WriteFCmp")          1, false, false, false,  4, 2, 10, 1,  0, 0}, // #83
  {DBGFIELD("WriteCMPXCHG")       1, false, false, false, 2740, 1, 11, 1,  0, 0}, // #84
  {DBGFIELD("WriteFComXLd_ReadAfterVecLd") 5, false, false, false, 2741, 3,  9, 1, 14, 1}, // #85
  {DBGFIELD("WriteFComX")         4, false, false, false, 2744, 3, 22, 1,  0, 0}, // #86
  {DBGFIELD("WriteFCom")          1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #87
  {DBGFIELD("WriteCRC32Ld_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #88
  {DBGFIELD("WriteCRC32")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #89
  {DBGFIELD("WriteCvtI2PDLd")     4, false, false, false, 2749, 3,  7, 1,  0, 0}, // #90
  {DBGFIELD("WriteCvtI2PD")       3, false, false, false, 2731, 3,  6, 1,  0, 0}, // #91
  {DBGFIELD("WriteCvtI2PSLd")     4, false, false, false, 2749, 3,  6, 1,  0, 0}, // #92
  {DBGFIELD("WriteCvtI2PS")       3, false, false, false, 2731, 3,  3, 1,  0, 0}, // #93
  {DBGFIELD("WriteCvtPD2ILd")     5, false, false, false, 2752, 3,  7, 1,  0, 0}, // #94
  {DBGFIELD("WriteCvtPD2I")       4, false, false, false, 2749, 3,  6, 1,  0, 0}, // #95
  {DBGFIELD("WriteCvtPD2PSLd")    5, false, false, false, 2755, 3,  2, 1,  0, 0}, // #96
  {DBGFIELD("WriteCvtPD2PS")      4, false, false, false, 2758, 3,  8, 1,  0, 0}, // #97
  {DBGFIELD("WriteCvtPS2ILd")     4, false, false, false, 2749, 3,  6, 1,  0, 0}, // #98
  {DBGFIELD("WriteCvtPS2I")       3, false, false, false, 2731, 3,  3, 1,  0, 0}, // #99
  {DBGFIELD("WriteCvtPS2PDLd")    5, false, false, false, 2749, 3,  7, 1,  0, 0}, // #100
  {DBGFIELD("WriteCvtPS2PD")      4, false, false, false, 2731, 3,  6, 1,  0, 0}, // #101
  {DBGFIELD("WriteCvtSD2ILd")     4, false, false, false, 2741, 3, 22, 1,  0, 0}, // #102
  {DBGFIELD("WriteCvtSD2I_ReadDefault") 3, false, false, false, 2752, 3,  7, 1,  0, 0}, // #103
  {DBGFIELD("WriteCvtSD2I")       3, false, false, false, 2752, 3,  7, 1,  0, 0}, // #104
  {DBGFIELD("WriteCvtSD2SSLd_ReadAfterVecLd") 4, false, false, false, 2755, 3,  8, 1, 14, 1}, // #105
  {DBGFIELD("WriteCvtSD2SS")      3, false, false, false, 2741, 3,  9, 1,  0, 0}, // #106
  {DBGFIELD("WriteCvtI2SDLd")     3, false, false, false, 2749, 3,  6, 1,  0, 0}, // #107
  {DBGFIELD("WriteCvtI2SDLd_ReadAfterVecLd") 3, false, false, false, 2749, 3,  6, 1, 14, 1}, // #108
  {DBGFIELD("WriteCvtI2SD_ReadInt2Fpu") 3, false, false, false, 2731, 3,  3, 1,  0, 1}, // #109
  {DBGFIELD("WriteCvtI2SD_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2731, 3,  3, 1,  7, 1}, // #110
  {DBGFIELD("WriteCvtI2SSLd")     1, false, false, false, 2731, 3,  6, 1,  0, 0}, // #111
  {DBGFIELD("WriteCvtI2SSLd_ReadAfterVecLd") 1, false, false, false, 2731, 3,  6, 1, 14, 1}, // #112
  {DBGFIELD("WriteCvtI2SS_ReadInt2Fpu") 3, false, false, false, 2731, 3,  3, 1,  0, 1}, // #113
  {DBGFIELD("WriteCvtI2SS_ReadDefault_ReadInt2Fpu") 3, false, false, false, 2731, 3,  3, 1,  7, 1}, // #114
  {DBGFIELD("WriteCvtSS2SDLd_ReadAfterVecLd") 4, false, false, false, 2749, 3,  6, 1, 14, 1}, // #115
  {DBGFIELD("WriteCvtSS2SD")      3, false, false, false, 2731, 3,  3, 1,  0, 0}, // #116
  {DBGFIELD("WriteCvtSS2ILd")     4, false, false, false, 2744, 3, 22, 1,  0, 0}, // #117
  {DBGFIELD("WriteCvtSS2I_ReadDefault") 3, false, false, false, 2752, 3,  7, 1,  0, 0}, // #118
  {DBGFIELD("WriteCvtSS2I")       3, false, false, false, 2752, 3,  7, 1,  0, 0}, // #119
  {DBGFIELD("WriteDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2761, 3, 96, 1, 15, 2}, // #120
  {DBGFIELD("WriteDiv16")         12, false, false, false, 2761, 3, 96, 1,  0, 0}, // #121
  {DBGFIELD("WriteDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 12, false, false, false, 2761, 3, 96, 1, 15, 2}, // #122
  {DBGFIELD("WriteDiv32")         12, false, false, false, 2761, 3, 96, 1,  0, 0}, // #123
  {DBGFIELD("WriteDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 38, false, false, false, 2764, 3, 97, 1, 15, 2}, // #124
  {DBGFIELD("WriteDiv64")         38, false, false, false, 2764, 3, 97, 1,  0, 0}, // #125
  {DBGFIELD("WriteDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 9, false, false, false, 2767, 3, 98, 1, 15, 2}, // #126
  {DBGFIELD("WriteDiv8")          9, false, false, false, 2761, 3, 96, 1,  0, 0}, // #127
  {DBGFIELD("WriteFDiv64XLd_ReadAfterVecXLd") 7, false, false, false, 2770, 3, 99, 1, 14, 1}, // #128
  {DBGFIELD("WriteFDiv64X")       6, false, false, false, 2770, 3, 99, 1,  0, 0}, // #129
  {DBGFIELD("WriteFDivXLd_ReadAfterVecXLd") 7, false, false, false, 2773, 3, 61, 1, 14, 1}, // #130
  {DBGFIELD("WriteFDivX")         6, false, false, false, 2773, 3, 61, 1,  0, 0}, // #131
  {DBGFIELD("WriteFDivLd")        4, false, false, false, 2776, 3, 100, 1,  0, 0}, // #132
  {DBGFIELD("WriteFDiv")          3, false, false, false, 2776, 3, 100, 1,  0, 0}, // #133
  {DBGFIELD("WriteFDiv64Ld_ReadAfterVecLd") 4, false, false, false, 2779, 3, 68, 1, 14, 1}, // #134
  {DBGFIELD("WriteFDiv64")        3, false, false, false, 2779, 3, 68, 1,  0, 0}, // #135
  {DBGFIELD("WriteFDivLd_ReadAfterVecLd") 4, false, false, false, 2776, 3, 100, 1, 14, 1}, // #136
  {DBGFIELD("WriteDPPDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #137
  {DBGFIELD("WriteDPPD")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #138
  {DBGFIELD("WriteDPPSLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #139
  {DBGFIELD("WriteDPPS")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #140
  {DBGFIELD("WriteStore")         1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #141
  {DBGFIELD("WriteVecExtractSt")  1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #142
  {DBGFIELD("WriteVecExtract")    1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #143
  {DBGFIELD("WriteVecALUX")       1, false, false, false,  5, 1,  1, 1,  0, 0}, // #144
  {DBGFIELD("WriteFComLd")        1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #145
  {DBGFIELD("WriteEMMS")          1, false, false, false, 355, 1, 10, 1,  0, 0}, // #146
  {DBGFIELD("WriteFLDC")          1, false, false, false, 2374, 1,  9, 1,  0, 0}, // #147
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd") 1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #148
  {DBGFIELD("WriteVecIMulX")      1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #149
  {DBGFIELD("WriteVecALUXLd_ReadAfterVecXLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #150
  {DBGFIELD("WriteFHAddLd_ReadAfterVecXLd") 6, false, false, false, 2744, 3, 22, 1, 14, 1}, // #151
  {DBGFIELD("WriteFHAdd")         5, false, false, false, 2752, 3,  7, 1,  0, 0}, // #152
  {DBGFIELD("WriteIDiv16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2779, 3, 68, 1, 15, 2}, // #153
  {DBGFIELD("WriteIDiv16")        29, false, false, false, 2779, 3, 68, 1,  0, 0}, // #154
  {DBGFIELD("WriteIDiv32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 29, false, false, false, 2779, 3, 68, 1, 15, 2}, // #155
  {DBGFIELD("WriteIDiv32")        29, false, false, false, 2779, 3, 68, 1,  0, 0}, // #156
  {DBGFIELD("WriteIDiv64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 60, false, false, false, 2764, 3, 97, 1, 15, 2}, // #157
  {DBGFIELD("WriteIDiv64")        60, false, false, false, 2764, 3, 97, 1,  0, 0}, // #158
  {DBGFIELD("WriteIDiv8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 26, false, false, false, 2779, 3, 68, 1, 15, 2}, // #159
  {DBGFIELD("WriteIDiv8")         26, false, false, false, 2779, 3, 68, 1,  0, 0}, // #160
  {DBGFIELD("WriteIMul16Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 5, false, false, false, 2752, 3,  7, 1, 15, 2}, // #161
  {DBGFIELD("WriteIMul16")        4, false, false, false, 2749, 3,  6, 1,  0, 0}, // #162
  {DBGFIELD("WriteIMul16RegLd_ReadAfterLd") 3, false, false, false, 2749, 3,  6, 1, 14, 1}, // #163
  {DBGFIELD("WriteIMul16ImmLd")   3, false, false, false, 2749, 3,  6, 1,  0, 0}, // #164
  {DBGFIELD("WriteIMul16Reg")     2, false, false, false, 2731, 3,  3, 1,  0, 0}, // #165
  {DBGFIELD("WriteIMul16Imm")     2, false, false, false, 2731, 3,  3, 1,  0, 0}, // #166
  {DBGFIELD("WriteIMul32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 4, false, false, false, 2749, 3,  6, 1, 15, 2}, // #167
  {DBGFIELD("WriteIMul32")        3, false, false, false, 2731, 3,  3, 1,  0, 0}, // #168
  {DBGFIELD("WriteIMul32RegLd_ReadAfterLd") 1, false, false, false, 2747, 2, 10, 1, 14, 1}, // #169
  {DBGFIELD("WriteIMul32ImmLd")   1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #170
  {DBGFIELD("WriteIMul32Reg")     1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #171
  {DBGFIELD("WriteIMul32Imm")     1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #172
  {DBGFIELD("WriteIMul64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 8, false, false, false, 2755, 3,  2, 1, 15, 2}, // #173
  {DBGFIELD("WriteIMul64")        8, false, false, false, 2755, 3,  2, 1,  0, 0}, // #174
  {DBGFIELD("WriteIMul64RegLd_ReadAfterLd") 6, false, false, false, 2755, 3,  2, 1, 14, 1}, // #175
  {DBGFIELD("WriteIMul64ImmLd")   7, false, false, false, 2784, 3, 21, 1,  0, 0}, // #176
  {DBGFIELD("WriteIMul64Reg")     6, false, false, false, 2755, 3,  2, 1,  0, 0}, // #177
  {DBGFIELD("WriteIMul64Imm")     7, false, false, false, 2784, 3, 21, 1,  0, 0}, // #178
  {DBGFIELD("WriteIMul8Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd_ReadAfterLd") 3, false, false, false, 2749, 3,  6, 1, 15, 2}, // #179
  {DBGFIELD("WriteIMul8")         3, false, false, false, 2749, 3,  6, 1,  0, 0}, // #180
  {DBGFIELD("WriteFShuffleLd_ReadAfterVecXLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #181
  {DBGFIELD("WriteFShuffle")      1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #182
  {DBGFIELD("WriteVecLogicX")     1, false, false, false,  5, 1,  1, 1,  0, 0}, // #183
  {DBGFIELD("WriteShuffle")       1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #184
  {DBGFIELD("WriteLAHFSAHF")      1, false, false, false, 116, 1, 12, 1,  0, 0}, // #185
  {DBGFIELD("WriteVecLoadX")      1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #186
  {DBGFIELD("WriteLDMXCSR")       4, false, false, false, 2734, 3, 10, 1,  0, 0}, // #187
  {DBGFIELD("WriteFLD0")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #188
  {DBGFIELD("WriteFLD1")          1, false, false, false, 651, 1,  3, 1,  0, 0}, // #189
  {DBGFIELD("WriteFence")         1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #190
  {DBGFIELD("WriteLZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #191
  {DBGFIELD("WriteLZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #192
  {DBGFIELD("WriteVecStoreX")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #193
  {DBGFIELD("WriteVecStore")      1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #194
  {DBGFIELD("WriteVecMoveToGpr")  1, false, false, false, 2787, 2,  5, 1,  0, 0}, // #195
  {DBGFIELD("WriteVecLoad")       1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #196
  {DBGFIELD("WriteVecMoveFromGpr") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #197
  {DBGFIELD("WriteVecMoveX")      1, false, false, false,  5, 1,  1, 1,  0, 0}, // #198
  {DBGFIELD("WriteVecStoreNT")    1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #199
  {DBGFIELD("WriteVecMove")       1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #200
  {DBGFIELD("WriteVecALULd")      1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #201
  {DBGFIELD("WriteShuffleLd_ReadAfterVecLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #202
  {DBGFIELD("WriteVecALULd_ReadAfterVecLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #203
  {DBGFIELD("WriteVecLogicLd_ReadAfterVecLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #204
  {DBGFIELD("WriteVecLogic")      1, false, false, false,  5, 1,  1, 1,  0, 0}, // #205
  {DBGFIELD("WritePHAddLd_ReadAfterVecLd") 4, false, false, false, 2789, 3, 14, 1, 14, 1}, // #206
  {DBGFIELD("WritePHAdd")         3, false, false, false, 2792, 3,  5, 1,  0, 0}, // #207
  {DBGFIELD("WriteVecInsertLd_ReadAfterLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #208
  {DBGFIELD("WriteVecInsert_ReadDefault_ReadInt2Fpu") 1, false, false, false, 2729, 2,  1, 1,  7, 1}, // #209
  {DBGFIELD("WriteVecIMulLd_ReadAfterVecLd") 1, false, false, false, 2729, 2, 14, 1, 14, 1}, // #210
  {DBGFIELD("WriteVecIMul")       1, false, false, false, 2729, 2, 14, 1,  0, 0}, // #211
  {DBGFIELD("WriteMMXMOVMSK")     1, false, false, false, 2787, 2,  5, 1,  0, 0}, // #212
  {DBGFIELD("WritePSADBWLd_ReadAfterVecLd") 1, false, false, false, 2729, 2, 14, 1, 14, 1}, // #213
  {DBGFIELD("WritePSADBW")        1, false, false, false, 2729, 2, 14, 1,  0, 0}, // #214
  {DBGFIELD("WriteVarShuffleLd_ReadAfterVecLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #215
  {DBGFIELD("WriteVarShuffle")    1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #216
  {DBGFIELD("WriteShuffleLd")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #217
  {DBGFIELD("WriteVecShiftImm")   1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #218
  {DBGFIELD("WriteVecShiftLd_ReadAfterVecLd") 3, false, false, false, 2795, 3,  5, 1, 14, 1}, // #219
  {DBGFIELD("WriteVecShift")      2, false, false, false, 389, 3, 12, 1,  0, 0}, // #220
  {DBGFIELD("WriteFMoveX")        1, false, false, false,  5, 1,  1, 1,  0, 0}, // #221
  {DBGFIELD("WriteFShuffleLd")    1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #222
  {DBGFIELD("WriteFStore")        1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #223
  {DBGFIELD("WriteFMOVMSK")       1, false, false, false, 2787, 2,  5, 1,  0, 0}, // #224
  {DBGFIELD("WriteVecLoadNT")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #225
  {DBGFIELD("WriteStoreNT")       1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #226
  {DBGFIELD("WriteFStoreNTX")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #227
  {DBGFIELD("WriteFStoreNT")      1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #228
  {DBGFIELD("WriteFLoad")         1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #229
  {DBGFIELD("WriteMPSADLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #230
  {DBGFIELD("WriteMPSAD")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #231
  {DBGFIELD("WriteFMul64XLd_ReadAfterVecXLd") 7, false, false, false, 2741, 3,  9, 1, 14, 1}, // #232
  {DBGFIELD("WriteFMul64X")       6, false, false, false, 2744, 3, 22, 1,  0, 0}, // #233
  {DBGFIELD("WriteFMulXLd_ReadAfterVecXLd") 1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #234
  {DBGFIELD("WriteFMulX")         1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #235
  {DBGFIELD("WriteFMul64Ld_ReadAfterVecLd") 1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #236
  {DBGFIELD("WriteFMul64")        1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #237
  {DBGFIELD("WriteFMulLd_ReadAfterVecLd") 1, false, false, false, 2782, 2, 14, 1, 14, 1}, // #238
  {DBGFIELD("WriteFMul")          1, false, false, false, 2782, 2, 14, 1,  0, 0}, // #239
  {DBGFIELD("WriteMULX32Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #240
  {DBGFIELD("WriteMULX32")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #241
  {DBGFIELD("WriteIMulHLd_WriteMULX32Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #242
  {DBGFIELD("WriteIMulH_WriteMULX32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #243
  {DBGFIELD("WriteMULX64Ld")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #244
  {DBGFIELD("WriteMULX64")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #245
  {DBGFIELD("WriteIMulHLd_WriteMULX64Ld_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #246
  {DBGFIELD("WriteIMulH_WriteMULX64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #247
  {DBGFIELD("WriteFMulLd")        1, false, false, false, 2782, 2, 14, 1,  0, 0}, // #248
  {DBGFIELD("WriteVecALUXLd")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #249
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #250
  {DBGFIELD("WriteShuffleX")      1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #251
  {DBGFIELD("WriteVecLogicXLd_ReadAfterVecXLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #252
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #253
  {DBGFIELD("WriteVarBlend")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #254
  {DBGFIELD("WriteBlendLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #255
  {DBGFIELD("WriteBlend")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #256
  {DBGFIELD("WriteCLMulLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #257
  {DBGFIELD("WriteCLMul")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #258
  {DBGFIELD("WritePCmpEStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #259
  {DBGFIELD("WritePCmpEStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #260
  {DBGFIELD("WritePCmpEStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #261
  {DBGFIELD("WritePCmpEStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #262
  {DBGFIELD("WritePCmpIStrILd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #263
  {DBGFIELD("WritePCmpIStrI")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #264
  {DBGFIELD("WritePCmpIStrMLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #265
  {DBGFIELD("WritePCmpIStrM")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #266
  {DBGFIELD("WriteCvtPS2ILd_ReadAfterVecXLd") 4, false, false, false, 2749, 3,  6, 1, 14, 1}, // #267
  {DBGFIELD("WritePHAddXLd_ReadAfterVecXLd") 4, false, false, false, 2752, 3,  7, 1, 14, 1}, // #268
  {DBGFIELD("WritePHAddX")        3, false, false, false, 2749, 3,  6, 1,  0, 0}, // #269
  {DBGFIELD("WritePHMINPOSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #270
  {DBGFIELD("WritePHMINPOS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #271
  {DBGFIELD("WriteCvtI2PSLd_ReadAfterVecXLd") 4, false, false, false, 2749, 3,  6, 1, 14, 1}, // #272
  {DBGFIELD("WriteVecMOVMSK")     1, false, false, false, 2787, 2,  5, 1,  0, 0}, // #273
  {DBGFIELD("WriteShuffleXLd")    1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #274
  {DBGFIELD("WritePMULLDLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #275
  {DBGFIELD("WritePMULLD")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #276
  {DBGFIELD("WriteCopy")          2, false, false, false, 2782, 2, 12, 1,  0, 0}, // #277
  {DBGFIELD("WritePOPCNTLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #278
  {DBGFIELD("WritePOPCNT")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #279
  {DBGFIELD("WritePSADBWXLd_ReadAfterVecXLd") 1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #280
  {DBGFIELD("WritePSADBWX")       1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #281
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd") 5, false, false, false, 2789, 3, 10, 1, 14, 1}, // #282
  {DBGFIELD("WriteVarShuffleX")   4, false, false, false, 2792, 3, 14, 1,  0, 0}, // #283
  {DBGFIELD("WriteVecShiftImmX")  1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #284
  {DBGFIELD("WriteVecShiftXLd_ReadAfterVecXLd") 3, false, false, false, 2795, 3,  5, 1, 14, 1}, // #285
  {DBGFIELD("WriteVecShiftX")     2, false, false, false, 389, 3, 12, 1,  0, 0}, // #286
  {DBGFIELD("WriteVecTestLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #287
  {DBGFIELD("WriteVecTest")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #288
  {DBGFIELD("WriteRotateLd_WriteRMW") 2, false, false, false, 2782, 2, 101, 2,  0, 0}, // #289
  {DBGFIELD("WriteRotateLd_WriteRotate") 2, false, false, false, 2782, 2, 101, 2,  0, 0}, // #290
  {DBGFIELD("WriteRotateCLLd_WriteRMW") 2, false, false, false, 2782, 2, 101, 2,  0, 0}, // #291
  {DBGFIELD("WriteRotateCLLd_WriteRotateCL") 2, false, false, false, 2782, 2, 101, 2,  0, 0}, // #292
  {DBGFIELD("WriteRotate")        1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #293
  {DBGFIELD("WriteRotateCL")      1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #294
  {DBGFIELD("WriteFRcpXLd")       6, false, false, false, 2741, 3,  9, 1,  0, 0}, // #295
  {DBGFIELD("WriteFRcpX")         5, false, false, false, 2744, 3, 22, 1,  0, 0}, // #296
  {DBGFIELD("WriteFRcpLd")        1, false, false, false, 2798, 2, 14, 1,  0, 0}, // #297
  {DBGFIELD("WriteFRcpLd_ReadAfterVecLd") 1, false, false, false, 2798, 2, 14, 1, 14, 1}, // #298
  {DBGFIELD("WriteFRcp")          1, false, false, false, 2798, 2, 14, 1,  0, 0}, // #299
  {DBGFIELD("WriteShiftLd")       1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #300
  {DBGFIELD("WriteShift")         1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #301
  {DBGFIELD("WriteFRndLd")        1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #302
  {DBGFIELD("WriteFRnd")          1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #303
  {DBGFIELD("WriteFRndLd_ReadAfterVecXLd") 1, false, false, false, 2747, 2, 10, 1, 14, 1}, // #304
  {DBGFIELD("WriteFRsqrtXLd")     6, false, false, false, 2741, 3,  9, 1,  0, 0}, // #305
  {DBGFIELD("WriteFRsqrtX")       5, false, false, false, 2744, 3, 22, 1,  0, 0}, // #306
  {DBGFIELD("WriteFRsqrtLd")      1, false, false, false, 2798, 2, 14, 1,  0, 0}, // #307
  {DBGFIELD("WriteFRsqrtLd_ReadAfterVecLd") 1, false, false, false, 2798, 2, 14, 1, 14, 1}, // #308
  {DBGFIELD("WriteFRsqrt")        1, false, false, false, 2798, 2, 14, 1,  0, 0}, // #309
  {DBGFIELD("WriteShiftLd_WriteRMW") 2, false, false, false, 2782, 2, 101, 2,  0, 0}, // #310
  {DBGFIELD("WriteShiftLd_WriteShift") 2, false, false, false, 2782, 2, 101, 2,  0, 0}, // #311
  {DBGFIELD("WriteShiftCLLd_WriteRMW") 2, false, false, false, 2782, 2, 101, 2,  0, 0}, // #312
  {DBGFIELD("WriteShiftCLLd_WriteShiftCL") 2, false, false, false, 2782, 2, 101, 2,  0, 0}, // #313
  {DBGFIELD("WriteShiftCL")       1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #314
  {DBGFIELD("WriteShiftLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterLd") 1, false, false, false, 2729, 2,  1, 1, 15, 1}, // #315
  {DBGFIELD("WriteSETCCStore")    1, false, false, false, 116, 1, 12, 1,  0, 0}, // #316
  {DBGFIELD("WriteSETCC")         1, false, false, false,  5, 1,  1, 1,  0, 0}, // #317
  {DBGFIELD("WriteSHDmrcl")       1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #318
  {DBGFIELD("WriteSHDmri")        1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #319
  {DBGFIELD("WriteSHDrrcl")       1, false, false, false, 116, 1, 12, 1,  0, 0}, // #320
  {DBGFIELD("WriteFSqrt64XLd")    6, false, false, false, 2770, 3, 99, 1,  0, 0}, // #321
  {DBGFIELD("WriteFSqrt64X")      5, false, false, false, 2770, 3, 99, 1,  0, 0}, // #322
  {DBGFIELD("WriteFSqrtXLd")      6, false, false, false, 2773, 3, 61, 1,  0, 0}, // #323
  {DBGFIELD("WriteFSqrtX")        5, false, false, false, 2773, 3, 61, 1,  0, 0}, // #324
  {DBGFIELD("WriteFSqrt64Ld")     4, false, false, false, 2779, 3, 68, 1,  0, 0}, // #325
  {DBGFIELD("WriteFSqrt64Ld_ReadAfterVecLd") 4, false, false, false, 2779, 3, 68, 1, 14, 1}, // #326
  {DBGFIELD("WriteFSqrt64")       3, false, false, false, 2779, 3, 68, 1,  0, 0}, // #327
  {DBGFIELD("WriteFSqrtLd")       4, false, false, false, 2776, 3, 100, 1,  0, 0}, // #328
  {DBGFIELD("WriteFSqrtLd_ReadAfterVecLd") 4, false, false, false, 2776, 3, 100, 1, 14, 1}, // #329
  {DBGFIELD("WriteFSqrt")         3, false, false, false, 2776, 3, 100, 1,  0, 0}, // #330
  {DBGFIELD("WriteFSqrt80")       1, false, false, false, 2800, 2, 83, 1,  0, 0}, // #331
  {DBGFIELD("WriteSTMXCSR")       4, false, false, false, 2802, 3, 11, 1,  0, 0}, // #332
  {DBGFIELD("WriteTZCNTLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #333
  {DBGFIELD("WriteTZCNT")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #334
  {DBGFIELD("WriteFMAZLd")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #335
  {DBGFIELD("WriteFMALd")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #336
  {DBGFIELD("WriteFAdd64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #337
  {DBGFIELD("WriteFAdd64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #338
  {DBGFIELD("WriteFAdd64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #339
  {DBGFIELD("WriteFAdd64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #340
  {DBGFIELD("WriteFAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #341
  {DBGFIELD("WriteFAddY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #342
  {DBGFIELD("WriteFAddZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #343
  {DBGFIELD("WriteFAddZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #344
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #345
  {DBGFIELD("WriteShuffleY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #346
  {DBGFIELD("WriteShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #347
  {DBGFIELD("WriteShuffleZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #348
  {DBGFIELD("WriteFLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #349
  {DBGFIELD("WriteFLogicY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #350
  {DBGFIELD("WriteFLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #351
  {DBGFIELD("WriteFLogicZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #352
  {DBGFIELD("WriteCvtPH2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #353
  {DBGFIELD("WriteCvtPH2PS")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #354
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #355
  {DBGFIELD("WriteFVarBlendY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #356
  {DBGFIELD("WriteFVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #357
  {DBGFIELD("WriteFVarBlendZ")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #358
  {DBGFIELD("WriteFBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #359
  {DBGFIELD("WriteFBlendY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #360
  {DBGFIELD("WriteFVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #361
  {DBGFIELD("WriteFVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #362
  {DBGFIELD("WriteShuffle256Ld")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #363
  {DBGFIELD("WriteShuffle256")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #364
  {DBGFIELD("WriteShuffleYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #365
  {DBGFIELD("WriteFShuffle256")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #366
  {DBGFIELD("WriteFShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #367
  {DBGFIELD("WriteFCmp64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #368
  {DBGFIELD("WriteFCmp64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #369
  {DBGFIELD("WriteFCmpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #370
  {DBGFIELD("WriteFCmpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #371
  {DBGFIELD("WriteFCmpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #372
  {DBGFIELD("WriteFCmpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #373
  {DBGFIELD("WriteVarShuffle256Ld") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #374
  {DBGFIELD("WriteVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #375
  {DBGFIELD("WriteCvtI2PDYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #376
  {DBGFIELD("WriteCvtI2PDY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #377
  {DBGFIELD("WriteCvtI2PDZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #378
  {DBGFIELD("WriteCvtI2PDZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #379
  {DBGFIELD("WriteCvtI2PSYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #380
  {DBGFIELD("WriteCvtI2PSY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #381
  {DBGFIELD("WriteCvtI2PSZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #382
  {DBGFIELD("WriteCvtI2PSZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #383
  {DBGFIELD("WriteCvtPD2PSLd_ReadAfterVecXLd") 5, false, false, false, 2755, 3,  2, 1, 14, 1}, // #384
  {DBGFIELD("WriteCvtPD2PSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #385
  {DBGFIELD("WriteCvtPD2PSY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #386
  {DBGFIELD("WriteCvtPD2PSZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #387
  {DBGFIELD("WriteCvtPD2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #388
  {DBGFIELD("WriteCvtPD2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #389
  {DBGFIELD("WriteCvtPD2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #390
  {DBGFIELD("WriteCvtPD2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #391
  {DBGFIELD("WriteCvtPD2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #392
  {DBGFIELD("WriteCvtPD2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #393
  {DBGFIELD("WriteCvtPD2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #394
  {DBGFIELD("WriteCvtPS2IYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #395
  {DBGFIELD("WriteCvtPS2IY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #396
  {DBGFIELD("WriteCvtPS2IZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #397
  {DBGFIELD("WriteCvtPS2IZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #398
  {DBGFIELD("WriteCvtPS2PDYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #399
  {DBGFIELD("WriteCvtPS2PDY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #400
  {DBGFIELD("WriteCvtPS2PDZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #401
  {DBGFIELD("WriteCvtPS2PDZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #402
  {DBGFIELD("WriteCvtPH2PSYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #403
  {DBGFIELD("WriteCvtPH2PSLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #404
  {DBGFIELD("WriteCvtPH2PSZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #405
  {DBGFIELD("WriteCvtPH2PSZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #406
  {DBGFIELD("WriteCvtPS2PHYSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #407
  {DBGFIELD("WriteCvtPS2PHY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #408
  {DBGFIELD("WriteCvtPS2PHSt")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #409
  {DBGFIELD("WriteCvtPS2PH")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #410
  {DBGFIELD("WriteCvtPS2PHZSt")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #411
  {DBGFIELD("WriteCvtPS2PHZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #412
  {DBGFIELD("WriteCvtSD2ILd_ReadAfterVecLd") 4, false, false, false, 2741, 3, 22, 1, 14, 1}, // #413
  {DBGFIELD("WriteCvtSS2ILd_ReadAfterVecLd") 4, false, false, false, 2744, 3, 22, 1, 14, 1}, // #414
  {DBGFIELD("WritePSADBWYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #415
  {DBGFIELD("WritePSADBWY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #416
  {DBGFIELD("WritePSADBWZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #417
  {DBGFIELD("WritePSADBWZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #418
  {DBGFIELD("WriteFDiv64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #419
  {DBGFIELD("WriteFDiv64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #420
  {DBGFIELD("WriteFDiv64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #421
  {DBGFIELD("WriteFDiv64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #422
  {DBGFIELD("WriteFDivYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #423
  {DBGFIELD("WriteFDivY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #424
  {DBGFIELD("WriteFDivZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #425
  {DBGFIELD("WriteFDivZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #426
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #427
  {DBGFIELD("WriteFMAX")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #428
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #429
  {DBGFIELD("WriteFMAY")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #430
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #431
  {DBGFIELD("WriteFMAZ")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #432
  {DBGFIELD("WriteDPPSYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #433
  {DBGFIELD("WriteDPPSY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #434
  {DBGFIELD("WriteVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #435
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #436
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #437
  {DBGFIELD("WriteFMAZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #438
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #439
  {DBGFIELD("WriteFMA")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #440
  {DBGFIELD("WriteFMAYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #441
  {DBGFIELD("WriteFMAXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #442
  {DBGFIELD("WriteFMALd_ReadAfterVecLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #443
  {DBGFIELD("WriteFRndYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #444
  {DBGFIELD("WriteFRndY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #445
  {DBGFIELD("WriteLoad_WriteVecMaskedGatherWriteback") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #446
  {DBGFIELD("WriteFRndZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #447
  {DBGFIELD("WriteFRndZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #448
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #449
  {DBGFIELD("WriteVecIMulY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #450
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #451
  {DBGFIELD("WriteVecIMulZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #452
  {DBGFIELD("WriteVecALUYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #453
  {DBGFIELD("WriteVecALUY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #454
  {DBGFIELD("WriteVecALUZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #455
  {DBGFIELD("WriteVecALUZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #456
  {DBGFIELD("WriteFHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #457
  {DBGFIELD("WriteFHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #458
  {DBGFIELD("WriteFShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #459
  {DBGFIELD("WriteShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #460
  {DBGFIELD("WriteVecLoadY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #461
  {DBGFIELD("WriteFMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #462
  {DBGFIELD("WriteFMaskedLoadY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #463
  {DBGFIELD("WriteFMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #464
  {DBGFIELD("WriteFMaskedLoad")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #465
  {DBGFIELD("WriteFMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #466
  {DBGFIELD("WriteFMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #467
  {DBGFIELD("WriteFCmp64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #468
  {DBGFIELD("WriteFCmp64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #469
  {DBGFIELD("WriteFMoveY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #470
  {DBGFIELD("WriteFMoveZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #471
  {DBGFIELD("WriteFShuffleYLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #472
  {DBGFIELD("WriteFShuffleY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #473
  {DBGFIELD("WriteFShuffleZLd")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #474
  {DBGFIELD("WriteFShuffleZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #475
  {DBGFIELD("WriteVecStoreY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #476
  {DBGFIELD("WriteVecMoveY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #477
  {DBGFIELD("WriteVecMoveZ")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #478
  {DBGFIELD("WriteVecLoadNTY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #479
  {DBGFIELD("WriteVecStoreNTY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #480
  {DBGFIELD("WriteFStoreNTY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #481
  {DBGFIELD("WriteMPSADYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #482
  {DBGFIELD("WriteMPSADY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #483
  {DBGFIELD("WriteFMul64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #484
  {DBGFIELD("WriteFMul64Y")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #485
  {DBGFIELD("WriteFMul64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #486
  {DBGFIELD("WriteFMul64Z")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #487
  {DBGFIELD("WriteFMulYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #488
  {DBGFIELD("WriteFMulY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #489
  {DBGFIELD("WriteFMulZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #490
  {DBGFIELD("WriteFMulZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #491
  {DBGFIELD("WriteVecALUYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #492
  {DBGFIELD("WriteVecALUZLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #493
  {DBGFIELD("WriteVecLogicYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #494
  {DBGFIELD("WriteVecLogicY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #495
  {DBGFIELD("WriteVecLogicZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #496
  {DBGFIELD("WriteVecLogicZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #497
  {DBGFIELD("WriteBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #498
  {DBGFIELD("WriteBlendY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #499
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #500
  {DBGFIELD("WriteVarBlendY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #501
  {DBGFIELD("WriteVarBlendZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #502
  {DBGFIELD("WriteVarBlendZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #503
  {DBGFIELD("WriteVarBlendYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #504
  {DBGFIELD("WriteVarBlendLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #505
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #506
  {DBGFIELD("WriteShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #507
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 1, false, false, false, 2729, 2,  1, 1, 17, 2}, // #508
  {DBGFIELD("WriteShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2729, 2,  1, 1, 19, 2}, // #509
  {DBGFIELD("WriteVecIMulYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #510
  {DBGFIELD("WriteVecIMulXLd_ReadAfterVecXLd_ReadAfterVecXLd") 1, false, false, false, 2782, 2, 10, 1, 19, 2}, // #511
  {DBGFIELD("WriteVecIMulZLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #512
  {DBGFIELD("WriteFVarShuffle256Ld_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #513
  {DBGFIELD("WriteFVarShuffle256") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #514
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #515
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #516
  {DBGFIELD("WriteFVarShuffleY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #517
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #518
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #519
  {DBGFIELD("WriteFVarShuffle")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #520
  {DBGFIELD("WriteFVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #521
  {DBGFIELD("WriteFVarShuffleLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #522
  {DBGFIELD("WriteFVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #523
  {DBGFIELD("WriteFVarShuffleZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #524
  {DBGFIELD("WritePHAddYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #525
  {DBGFIELD("WritePHAddY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #526
  {DBGFIELD("WriteVecInsert")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #527
  {DBGFIELD("WriteVecIMulXLd")    1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #528
  {DBGFIELD("WriteVecIMulYLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #529
  {DBGFIELD("WriteVecIMulZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #530
  {DBGFIELD("WriteVecMaskedStore32Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #531
  {DBGFIELD("WriteVecMaskedLoadY") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #532
  {DBGFIELD("WriteVecMaskedStore32") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #533
  {DBGFIELD("WriteVecMaskedLoad") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #534
  {DBGFIELD("WriteVecMaskedStore64Y") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #535
  {DBGFIELD("WriteVecMaskedStore64") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #536
  {DBGFIELD("WriteVPMOV256Ld")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #537
  {DBGFIELD("WriteVPMOV256")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #538
  {DBGFIELD("WriteVecMOVMSKY")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #539
  {DBGFIELD("WritePMULLDYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #540
  {DBGFIELD("WritePMULLDY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #541
  {DBGFIELD("WritePMULLDZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #542
  {DBGFIELD("WritePMULLDZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #543
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadDefault_ReadAfterVecXLd") 5, false, false, false, 2789, 3, 10, 1, 17, 2}, // #544
  {DBGFIELD("WriteVarShuffleXLd_ReadAfterVecXLd_ReadAfterVecXLd") 5, false, false, false, 2789, 3, 10, 1, 19, 2}, // #545
  {DBGFIELD("WriteVecShiftImmXLd") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #546
  {DBGFIELD("WriteVecShiftImmYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #547
  {DBGFIELD("WriteVecShiftImmY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #548
  {DBGFIELD("WriteVecShiftImmZLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #549
  {DBGFIELD("WriteVecShiftImmZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #550
  {DBGFIELD("WriteVarVecShiftLd_ReadAfterVecXLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #551
  {DBGFIELD("WriteVarVecShift")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #552
  {DBGFIELD("WriteVarVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #553
  {DBGFIELD("WriteVarVecShiftY")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #554
  {DBGFIELD("WriteVarVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #555
  {DBGFIELD("WriteVarVecShiftZ")  8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #556
  {DBGFIELD("WriteVecShiftImmXLd_ReadAfterVecXLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #557
  {DBGFIELD("WriteVarShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #558
  {DBGFIELD("WriteVarShuffleY")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #559
  {DBGFIELD("WriteVarShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #560
  {DBGFIELD("WriteVarShuffleZ")   8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #561
  {DBGFIELD("WriteShuffleZLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #562
  {DBGFIELD("WriteVecShiftYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #563
  {DBGFIELD("WriteVecShiftY")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #564
  {DBGFIELD("WriteVecShiftZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #565
  {DBGFIELD("WriteVecShiftZ")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #566
  {DBGFIELD("WriteVecTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #567
  {DBGFIELD("WriteVecTestY")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #568
  {DBGFIELD("WriteFRcpXLd_ReadAfterVecXLd") 6, false, false, false, 2741, 3,  9, 1, 14, 1}, // #569
  {DBGFIELD("WriteFRcpYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #570
  {DBGFIELD("WriteFRcpY")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #571
  {DBGFIELD("WriteFRcpZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #572
  {DBGFIELD("WriteFRcpZ")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #573
  {DBGFIELD("WriteFRcpYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #574
  {DBGFIELD("WriteFRndYLd")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #575
  {DBGFIELD("WriteFRsqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2741, 3,  9, 1, 14, 1}, // #576
  {DBGFIELD("WriteFRsqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #577
  {DBGFIELD("WriteFRsqrtY")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #578
  {DBGFIELD("WriteFRsqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #579
  {DBGFIELD("WriteFRsqrtZ")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #580
  {DBGFIELD("WriteFRsqrtYLd")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #581
  {DBGFIELD("WriteFShuffleYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #582
  {DBGFIELD("WriteFShuffleZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #583
  {DBGFIELD("WriteFSqrt64YLd")    8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #584
  {DBGFIELD("WriteFSqrt64Y")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #585
  {DBGFIELD("WriteFSqrt64XLd_ReadAfterVecXLd") 6, false, false, false, 2770, 3, 99, 1, 14, 1}, // #586
  {DBGFIELD("WriteFSqrt64YLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #587
  {DBGFIELD("WriteFSqrt64ZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #588
  {DBGFIELD("WriteFSqrt64Z")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #589
  {DBGFIELD("WriteFSqrtXLd_ReadAfterVecXLd") 6, false, false, false, 2773, 3, 61, 1, 14, 1}, // #590
  {DBGFIELD("WriteFSqrtYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #591
  {DBGFIELD("WriteFSqrtY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #592
  {DBGFIELD("WriteFSqrtZLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #593
  {DBGFIELD("WriteFSqrtZ")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #594
  {DBGFIELD("WriteFSqrtYLd")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #595
  {DBGFIELD("WriteFTestYLd_ReadAfterVecYLd") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #596
  {DBGFIELD("WriteFTestY")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #597
  {DBGFIELD("WriteFTestLd_ReadAfterVecXLd") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #598
  {DBGFIELD("WriteFTest")         1, false, false, false,  5, 1,  1, 1,  0, 0}, // #599
  {DBGFIELD("WriteALULd_WriteRMW") 2, false, false, false, 2782, 2, 101, 2,  0, 0}, // #600
  {DBGFIELD("COPY")               1, false, false, false,  5, 1,  1, 1,  0, 0}, // #601
  {DBGFIELD("XAM_F")              1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #602
  {DBGFIELD("LD_Frr")             1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #603
  {DBGFIELD("MOVSX64rr32")        1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #604
  {DBGFIELD("RCL16m1_RCL16m1_EVEX_RCL16mi_RCL16mi_EVEX_RCL32m1_RCL32m1_EVEX_RCL32mi_RCL32mi_EVEX_RCL64m1_RCL64m1_EVEX_RCL64mi_RCL64mi_EVEX_RCL8m1_RCL8m1_EVEX_RCL8mi_RCL8mi_EVEX_RCR16m1_RCR16m1_EVEX_RCR16mi_RCR16mi_EVEX_RCR32m1_RCR32m1_EVEX_RCR32mi_RCR32mi_EVEX_RCR64m1_RCR64m1_EVEX_RCR64mi_RCR64mi_EVEX_RCR8m1_RCR8m1_EVEX_RCR8mi_RCR8mi_EVEX_ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #605
  {DBGFIELD("RCL16m1_ND_RCL16mi_ND_RCL32m1_ND_RCL32mi_ND_RCL64m1_ND_RCL64mi_ND_RCL8m1_ND_RCL8mi_ND_RCR16m1_ND_RCR16mi_ND_RCR32m1_ND_RCR32mi_ND_RCR64m1_ND_RCR64mi_ND_RCR8m1_ND_RCR8mi_ND_ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #606
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX_RCR16mCL_RCR16mCL_EVEX_RCR32mCL_RCR32mCL_EVEX_RCR64mCL_RCR64mCL_EVEX_RCR8mCL_RCR8mCL_EVEX_ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #607
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND_RCR16mCL_ND_RCR32mCL_ND_RCR64mCL_ND_RCR8mCL_ND_ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #608
  {DBGFIELD("SAR16m1_SAR16m1_EVEX_SAR16m1_NF_SAR16mi_SAR16mi_EVEX_SAR16mi_NF_SAR32m1_SAR32m1_EVEX_SAR32m1_NF_SAR32mi_SAR32mi_EVEX_SAR32mi_NF_SAR64m1_SAR64m1_EVEX_SAR64m1_NF_SAR64mi_SAR64mi_EVEX_SAR64mi_NF_SAR8m1_SAR8m1_EVEX_SAR8m1_NF_SAR8mi_SAR8mi_EVEX_SAR8mi_NF_SHL16m1_SHL16m1_EVEX_SHL16m1_NF_SHL16mi_SHL16mi_EVEX_SHL16mi_NF_SHL32m1_SHL32m1_EVEX_SHL32m1_NF_SHL32mi_SHL32mi_EVEX_SHL32mi_NF_SHL64m1_SHL64m1_EVEX_SHL64m1_NF_SHL64mi_SHL64mi_EVEX_SHL64mi_NF_SHL8m1_SHL8m1_EVEX_SHL8m1_NF_SHL8mi_SHL8mi_EVEX_SHL8mi_NF_SHR16m1_SHR16m1_EVEX_SHR16m1_NF_SHR16mi_SHR16mi_EVEX_SHR16mi_NF_SHR32m1_SHR32m1_EVEX_SHR32m1_NF_SHR32mi_SHR32mi_EVEX_SHR32mi_NF_SHR64m1_SHR64m1_EVEX_SHR64m1_NF_SHR64mi_SHR64mi_EVEX_SHR64mi_NF_SHR8m1_SHR8m1_EVEX_SHR8m1_NF_SHR8mi_SHR8mi_EVEX_SHR8mi_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #609
  {DBGFIELD("SAR16m1_ND_SAR16m1_NF_ND_SAR16mi_ND_SAR16mi_NF_ND_SAR32m1_ND_SAR32m1_NF_ND_SAR32mi_ND_SAR32mi_NF_ND_SAR64m1_ND_SAR64m1_NF_ND_SAR64mi_ND_SAR64mi_NF_ND_SAR8m1_ND_SAR8m1_NF_ND_SAR8mi_ND_SAR8mi_NF_ND_SHL16m1_ND_SHL16m1_NF_ND_SHL16mi_ND_SHL16mi_NF_ND_SHL32m1_ND_SHL32m1_NF_ND_SHL32mi_ND_SHL32mi_NF_ND_SHL64m1_ND_SHL64m1_NF_ND_SHL64mi_ND_SHL64mi_NF_ND_SHL8m1_ND_SHL8m1_NF_ND_SHL8mi_ND_SHL8mi_NF_ND_SHR16m1_ND_SHR16m1_NF_ND_SHR16mi_ND_SHR16mi_NF_ND_SHR32m1_ND_SHR32m1_NF_ND_SHR32mi_ND_SHR32mi_NF_ND_SHR64m1_ND_SHR64m1_NF_ND_SHR64mi_ND_SHR64mi_NF_ND_SHR8m1_ND_SHR8m1_NF_ND_SHR8mi_ND_SHR8mi_NF_ND") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #610
  {DBGFIELD("SAR16mCL_SAR16mCL_EVEX_SAR16mCL_NF_SAR32mCL_SAR32mCL_EVEX_SAR32mCL_NF_SAR64mCL_SAR64mCL_EVEX_SAR64mCL_NF_SAR8mCL_SAR8mCL_EVEX_SAR8mCL_NF_SHL16mCL_SHL16mCL_EVEX_SHL16mCL_NF_SHL32mCL_SHL32mCL_EVEX_SHL32mCL_NF_SHL64mCL_SHL64mCL_EVEX_SHL64mCL_NF_SHL8mCL_SHL8mCL_EVEX_SHL8mCL_NF_SHR16mCL_SHR16mCL_EVEX_SHR16mCL_NF_SHR32mCL_SHR32mCL_EVEX_SHR32mCL_NF_SHR64mCL_SHR64mCL_EVEX_SHR64mCL_NF_SHR8mCL_SHR8mCL_EVEX_SHR8mCL_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #611
  {DBGFIELD("SAR16mCL_ND_SAR16mCL_NF_ND_SAR32mCL_ND_SAR32mCL_NF_ND_SAR64mCL_ND_SAR64mCL_NF_ND_SAR8mCL_ND_SAR8mCL_NF_ND_SHL16mCL_ND_SHL16mCL_NF_ND_SHL32mCL_ND_SHL32mCL_NF_ND_SHL64mCL_ND_SHL64mCL_NF_ND_SHL8mCL_ND_SHL8mCL_NF_ND_SHR16mCL_ND_SHR16mCL_NF_ND_SHR32mCL_ND_SHR32mCL_NF_ND_SHR64mCL_ND_SHR64mCL_NF_ND_SHR8mCL_ND_SHR8mCL_NF_ND") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #612
  {DBGFIELD("MOVSX32rr16_MOVSX32rr8_MOVSX32rr8_NOREX_MOVSX64rr16_MOVSX64rr8_MOVZX32rr16_MOVZX32rr8_MOVZX32rr8_NOREX_MOVZX64rr16_MOVZX64rr8") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #613
  {DBGFIELD("FCOMPP")             1, false, false, false,  4, 2,  1, 1,  0, 0}, // #614
  {DBGFIELD("UCOM_FPPr_UCOM_FPr_UCOM_Fr") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #615
  {DBGFIELD("MMX_CVTPI2PSrr")     1, false, false, false, 1581, 2, 10, 1,  0, 0}, // #616
  {DBGFIELD("MMX_CVTPI2PSrm")     1, false, false, false, 1581, 2, 10, 1,  0, 0}, // #617
  {DBGFIELD("MMX_CVTPS2PIrr_MMX_CVTTPS2PIrr") 1, false, false, false, 1581, 2, 10, 1,  0, 0}, // #618
  {DBGFIELD("POP32r_POP64r_POP16rmr_POP32rmr_POP64rmr") 1, false, false, false, 389, 3,  1, 1,  0, 0}, // #619
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH16i_PUSH32i_PUSH16rmr_PUSH32rmr_PUSH64rmr_PUSH16i8_PUSH32i8_PUSH64i8_PUSH64i32") 1, false, false, false, 389, 3,  1, 1,  0, 0}, // #620
  {DBGFIELD("XCH_F")              1, false, false, false, 389, 3,  1, 1,  0, 0}, // #621
  {DBGFIELD("RETI16_RETI32_RETI64_IRET_IRET16_IRET32_IRET64") 1, false, false, false, 389, 3,  1, 1,  0, 0}, // #622
  {DBGFIELD("MMX_CVTPS2PIrm_MMX_CVTTPS2PIrm") 1, false, false, false, 2734, 3, 10, 1,  0, 0}, // #623
  {DBGFIELD("ILD_F16m_ILD_F32m_ILD_F64m") 1, false, false, false, 2734, 3, 10, 1,  0, 0}, // #624
  {DBGFIELD("CVTSI642SDrm")       1, false, false, false, 2731, 3,  6, 1,  0, 0}, // #625
  {DBGFIELD("CVTSI642SDrm_Int")   1, false, false, false, 2731, 3,  6, 1,  0, 0}, // #626
  {DBGFIELD("CVTSI642SSrr")       4, false, false, false, 2752, 3,  6, 1,  0, 0}, // #627
  {DBGFIELD("CVTSI642SSrr_Int")   4, false, false, false, 2752, 3,  6, 1,  0, 0}, // #628
  {DBGFIELD("CVTSI642SSrm")       4, false, false, false, 2752, 3,  6, 1,  0, 0}, // #629
  {DBGFIELD("CVTSI642SSrm_Int")   4, false, false, false, 2752, 3,  6, 1,  0, 0}, // #630
  {DBGFIELD("CVTSS2SI64rr_CVTTSS2SI64rr") 4, false, false, false, 2744, 3, 22, 1,  0, 0}, // #631
  {DBGFIELD("CVTSS2SI64rr_Int_CVTTSS2SI64rr_Int") 4, false, false, false, 2744, 3, 22, 1,  0, 0}, // #632
  {DBGFIELD("CVTSS2SI64rm_CVTSS2SI64rm_Int_CVTTSS2SI64rm_CVTTSS2SI64rm_Int") 5, false, false, false, 2758, 3,  9, 1,  0, 0}, // #633
  {DBGFIELD("FDECSTP_FFREE_FFREEP_FINCSTP_WAIT_STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #634
  {DBGFIELD("LFENCE")             1, false, false, false,  5, 1,  1, 1,  0, 0}, // #635
  {DBGFIELD("MOVSSrr_MOVSSrr_REV") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #636
  {DBGFIELD("LEAVE_LEAVE64")      1, false, false, false, 116, 1, 12, 1,  0, 0}, // #637
  {DBGFIELD("POP16r")             1, false, false, false, 116, 1, 12, 1,  0, 0}, // #638
  {DBGFIELD("PUSH16rmm_PUSH32rmm_PUSH64rmm") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #639
  {DBGFIELD("LODSB_LODSL_LODSQ_LODSW_SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #640
  {DBGFIELD("PUSHCS16_PUSHCS32_PUSHDS16_PUSHDS32_PUSHES16_PUSHES32_PUSHFS16_PUSHFS32_PUSHFS64_PUSHGS16_PUSHGS32_PUSHGS64_PUSHSS16_PUSHSS32") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #641
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m_ST_F32m_ST_F64m_ST_FP32m_ST_FP64m") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #642
  {DBGFIELD("ST_FPrr_ST_Frr")     1, false, false, false, 116, 1, 12, 1,  0, 0}, // #643
  {DBGFIELD("MMX_PADDQrr_MMX_PSUBQrr") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #644
  {DBGFIELD("MOVSX16rr8_MOVZX16rr8") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #645
  {DBGFIELD("MOVDQUmr_MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #646
  {DBGFIELD("MOVUPDmr_MOVUPSmr")  1, false, false, false, 116, 1, 12, 1,  0, 0}, // #647
  {DBGFIELD("PADDQrr_PSUBQrr")    1, false, false, false, 116, 1, 12, 1,  0, 0}, // #648
  {DBGFIELD("CLD")                1, false, false, false, 303, 1,  5, 1,  0, 0}, // #649
  {DBGFIELD("LDDQUrm")            1, false, false, false, 303, 1,  5, 1,  0, 0}, // #650
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW_MOVSB_MOVSL_MOVSQ_MOVSW") 1, false, false, false, 303, 1,  5, 1,  0, 0}, // #651
  {DBGFIELD("POP16rmm_POP32rmm_POP64rmm") 1, false, false, false, 303, 1,  5, 1,  0, 0}, // #652
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm_XCHG16rm_XCHG32rm_XCHG64rm_XCHG8rm") 1, false, false, false, 303, 1,  5, 1,  0, 0}, // #653
  {DBGFIELD("PHADDDrr_PHSUBDrr")  1, false, false, false, 303, 1,  5, 1,  0, 0}, // #654
  {DBGFIELD("MOVSX16rm8_MOVZX16rm8") 1, false, false, false, 303, 1,  5, 1,  0, 0}, // #655
  {DBGFIELD("MMX_PADDQrm_MMX_PSUBQrm") 1, false, false, false, 303, 1,  5, 1,  0, 0}, // #656
  {DBGFIELD("MOVDQUrm")           1, false, false, false, 303, 1,  5, 1,  0, 0}, // #657
  {DBGFIELD("MOVUPDrm_MOVUPSrm")  1, false, false, false, 303, 1,  5, 1,  0, 0}, // #658
  {DBGFIELD("PADDQrm_PSUBQrm")    1, false, false, false, 303, 1,  5, 1,  0, 0}, // #659
  {DBGFIELD("CBW_CWD_CWDE_CDQ_CDQE_CQO") 1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #660
  {DBGFIELD("JCXZ_JECXZ_JRCXZ")   1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #661
  {DBGFIELD("LD_F80m")            1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #662
  {DBGFIELD("PHADDDrm_PHSUBDrm")  1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #663
  {DBGFIELD("MMX_PEXTRWrr_PEXTRWrr_PEXTRWrr_REV") 1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #664
  {DBGFIELD("FLDCW16m")           1, false, false, false, 355, 1, 10, 1,  0, 0}, // #665
  {DBGFIELD("ST_FP80m")           1, false, false, false, 355, 1, 10, 1,  0, 0}, // #666
  {DBGFIELD("MMX_PHADDSWrr_MMX_PHADDWrr_MMX_PHSUBSWrr_MMX_PHSUBWrr") 1, false, false, false, 355, 1, 10, 1,  0, 0}, // #667
  {DBGFIELD("CMPXCHG8rm")         1, false, false, false, 651, 1,  3, 1,  0, 0}, // #668
  {DBGFIELD("INTO")               1, false, false, false, 651, 1,  3, 1,  0, 0}, // #669
  {DBGFIELD("XLAT")               1, false, false, false, 651, 1,  3, 1,  0, 0}, // #670
  {DBGFIELD("SHLD16rrCL_SHRD16rrCL") 1, false, false, false, 651, 1,  3, 1,  0, 0}, // #671
  {DBGFIELD("SHLD16rri8_SHRD16rri8") 1, false, false, false, 651, 1,  3, 1,  0, 0}, // #672
  {DBGFIELD("SHLD16mrCL_SHRD16mrCL") 1, false, false, false, 651, 1,  3, 1,  0, 0}, // #673
  {DBGFIELD("SHLD16mri8_SHRD16mri8") 1, false, false, false, 651, 1,  3, 1,  0, 0}, // #674
  {DBGFIELD("IST_F16m_IST_F32m_IST_FP16m_IST_FP32m_IST_FP64m") 1, false, false, false, 651, 1,  3, 1,  0, 0}, // #675
  {DBGFIELD("MMX_PHADDSWrm_MMX_PHADDWrm_MMX_PHSUBSWrm_MMX_PHSUBWrm") 1, false, false, false, 651, 1,  3, 1,  0, 0}, // #676
  {DBGFIELD("AAD8i8")             1, false, false, false, 667, 1,  6, 1,  0, 0}, // #677
  {DBGFIELD("LOOPE")              1, false, false, false, 697, 1,  7, 1,  0, 0}, // #678
  {DBGFIELD("PUSHA16_PUSHA32")    1, false, false, false, 697, 1,  7, 1,  0, 0}, // #679
  {DBGFIELD("SHLD64rrCL_SHRD64rrCL") 1, false, false, false, 697, 1,  7, 1,  0, 0}, // #680
  {DBGFIELD("FNSTCW16m")          1, false, false, false, 697, 1,  7, 1,  0, 0}, // #681
  {DBGFIELD("POPA16_POPA32")      1, false, false, false, 417, 1, 22, 1,  0, 0}, // #682
  {DBGFIELD("PUSHF16_PUSHF32_PUSHF64") 1, false, false, false, 417, 1, 22, 1,  0, 0}, // #683
  {DBGFIELD("SHLD64mrCL_SHRD64mrCL") 1, false, false, false, 417, 1, 22, 1,  0, 0}, // #684
  {DBGFIELD("SHLD64mri8_SHRD64mri8") 1, false, false, false, 417, 1, 22, 1,  0, 0}, // #685
  {DBGFIELD("SHLD64rri8_SHRD64rri8") 1, false, false, false, 417, 1, 22, 1,  0, 0}, // #686
  {DBGFIELD("CMPXCHG8rr")         1, false, false, false, 417, 1, 22, 1,  0, 0}, // #687
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr_TST_F_TST_Fp32_TST_Fp64_TST_Fp80") 1, false, false, false, 417, 1, 22, 1,  0, 0}, // #688
  {DBGFIELD("BOUNDS16rm_BOUNDS32rm") 1, false, false, false, 129, 1,  8, 1,  0, 0}, // #689
  {DBGFIELD("AAA_AAS")            1, false, false, false, 1096, 1, 24, 1,  0, 0}, // #690
  {DBGFIELD("CMPXCHG16rm_CMPXCHG32rm_CMPXCHG64rm") 1, false, false, false, 1265, 1, 21, 1,  0, 0}, // #691
  {DBGFIELD("LOOPNE")             1, false, false, false, 1282, 1, 20, 1,  0, 0}, // #692
  {DBGFIELD("PAUSE")              1, false, false, false, 1282, 1, 20, 1,  0, 0}, // #693
  {DBGFIELD("CMPXCHG8B")          1, false, false, false, 2200, 1, 13, 1,  0, 0}, // #694
  {DBGFIELD("DAA")                1, false, false, false, 2200, 1, 13, 1,  0, 0}, // #695
  {DBGFIELD("LOOP")               1, false, false, false, 2200, 1, 13, 1,  0, 0}, // #696
  {DBGFIELD("DAS")                1, false, false, false, 2743, 1, 15, 1,  0, 0}, // #697
  {DBGFIELD("AAM8i8")             1, false, false, false, 2805, 1, 23, 1,  0, 0}, // #698
  {DBGFIELD("STD")                1, false, false, false, 2805, 1, 23, 1,  0, 0}, // #699
  {DBGFIELD("CMPXCHG16B")         1, false, false, false, 2347, 1, 19, 1,  0, 0}, // #700
  {DBGFIELD("ARPL16mr_ARPL16rr")  1, false, false, false, 1219, 1, 18, 1,  0, 0}, // #701
  {DBGFIELD("FNCLEX_FXTRACT")     1, false, false, false, 2806, 1, 46, 1,  0, 0}, // #702
  {DBGFIELD("POPF32_POPF64")      1, false, false, false, 1785, 1, 80, 1,  0, 0}, // #703
  {DBGFIELD("POPDS16_POPDS32_POPES16_POPES32_POPFS16_POPFS32_POPFS64_POPGS16_POPGS32_POPGS64") 1, false, false, false, 2807, 1, 72, 1,  0, 0}, // #704
  {DBGFIELD("RDTSC_RDTSCP")       1, false, false, false, 2804, 1, 64, 1,  0, 0}, // #705
  {DBGFIELD("ENTER")              1, false, false, false, 2739, 1, 51, 1,  0, 0}, // #706
  {DBGFIELD("POPF16")             1, false, false, false, 2739, 1, 51, 1,  0, 0}, // #707
  {DBGFIELD("MONITOR32rrr_MONITOR64rrr") 1, false, false, false, 2808, 1, 103, 1,  0, 0}, // #708
  {DBGFIELD("FRNDINT")            1, false, false, false, 1233, 1, 66, 1,  0, 0}, // #709
  {DBGFIELD("MWAITrr_RDPMC")      1, false, false, false, 1233, 1, 66, 1,  0, 0}, // #710
  {DBGFIELD("POPSS16_POPSS32")    1, false, false, false, 2132, 1, 104, 1,  0, 0}, // #711
  {DBGFIELD("FPREM")              1, false, false, false, 2809, 1, 105, 1,  0, 0}, // #712
  {DBGFIELD("INSB_INSL_INSW")     1, false, false, false, 2810, 1, 106, 1,  0, 0}, // #713
  {DBGFIELD("FNINIT")             1, false, false, false, 2811, 1, 56, 1,  0, 0}, // #714
  {DBGFIELD("OUT8rr_OUT16rr_OUT32rr") 1, false, false, false, 2778, 1, 98, 1,  0, 0}, // #715
  {DBGFIELD("FPREM1")             1, false, false, false, 2801, 1, 83, 1,  0, 0}, // #716
  {DBGFIELD("INVLPG_INVLPGA32_INVLPGA64") 1, false, false, false, 2801, 1, 83, 1,  0, 0}, // #717
  {DBGFIELD("OUT8ir_OUT16ir_OUT32ir") 1, false, false, false, 2812, 1, 107, 1,  0, 0}, // #718
  {DBGFIELD("OUTSB_OUTSL_OUTSW")  1, false, false, false, 2813, 1, 91, 1,  0, 0}, // #719
  {DBGFIELD("FSCALE")             1, false, false, false, 2814, 1, 108, 1,  0, 0}, // #720
  {DBGFIELD("RDMSR")              1, false, false, false, 2815, 1, 109, 1,  0, 0}, // #721
  {DBGFIELD("RET_RET16_RET32_RET64_LRET16_LRET32_LRET64_LRETI16_LRETI32_LRETI64") 1, false, false, false, 1317, 1, 110, 1,  0, 0}, // #722
  {DBGFIELD("IN8ri_IN16ri_IN32ri") 1, false, false, false, 2816, 1, 111, 1,  0, 0}, // #723
  {DBGFIELD("IN8rr_IN16rr_IN32rr") 1, false, false, false, 2817, 1, 112, 1,  0, 0}, // #724
  {DBGFIELD("F2XM1")              1, false, false, false, 2818, 1, 113, 1,  0, 0}, // #725
  {DBGFIELD("CPUID")              1, false, false, false, 2819, 1, 114, 1,  0, 0}, // #726
  {DBGFIELD("INT")                1, false, false, false, 2820, 1, 115, 1,  0, 0}, // #727
  {DBGFIELD("INT3")               1, false, false, false, 2821, 1, 97, 1,  0, 0}, // #728
  {DBGFIELD("FXSAVE_FXSAVE64")    1, false, false, false, 2775, 1, 116, 1,  0, 0}, // #729
  {DBGFIELD("FXRSTOR_FXRSTOR64")  1, false, false, false, 2822, 1, 117, 1,  0, 0}, // #730
  {DBGFIELD("FYL2X")              1, false, false, false, 2823, 1, 118, 1,  0, 0}, // #731
  {DBGFIELD("FYL2XP1")            1, false, false, false, 2824, 1, 119, 1,  0, 0}, // #732
  {DBGFIELD("FPTAN")              1, false, false, false, 2825, 1, 120, 1,  0, 0}, // #733
  {DBGFIELD("FSINCOS_FSIN_FCOS")  1, false, false, false, 2826, 1, 121, 1,  0, 0}, // #734
  {DBGFIELD("FPATAN")             1, false, false, false, 2827, 1, 122, 1,  0, 0}, // #735
  {DBGFIELD("WRMSR")              1, false, false, false, 2828, 1, 123, 1,  0, 0}, // #736
  {DBGFIELD("COMP_FST0r_COM_FST0r") 1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #737
  {DBGFIELD("UCOM_FPr_UCOM_Fr")   1, false, false, false,  4, 2,  1, 1,  0, 0}, // #738
  {DBGFIELD("FDECSTP_FINCSTP_FFREE_FFREEP") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #739
  {DBGFIELD("FNOP")               1, false, false, false,  5, 1,  1, 1,  0, 0}, // #740
  {DBGFIELD("RET64")              1, false, false, false, 1317, 1, 110, 1,  0, 0}, // #741
  {DBGFIELD("CDQ_CQO")            1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #742
  {DBGFIELD("MMX_PABSBrr_MMX_PABSDrr_MMX_PABSWrr_MMX_PSIGNBrr_MMX_PSIGNDrr_MMX_PSIGNWrr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #743
  {DBGFIELD("MMX_PADDQrr")        1, false, false, false, 116, 1, 12, 1,  0, 0}, // #744
  {DBGFIELD("MMX_PALIGNRrri")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #745
  {DBGFIELD("SCASB_SCASL_SCASQ_SCASW") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #746
  {DBGFIELD("COMISDrr_COMISDrr_Int_COMISSrr_COMISSrr_Int_UCOMISDrr_UCOMISDrr_Int_UCOMISSrr_UCOMISSrr_Int_VCOMISDrr_VCOMISDrr_Int_VCOMISSrr_VCOMISSrr_Int_VUCOMISDrr_VUCOMISDrr_Int_VUCOMISSrr_VUCOMISSrr_Int") 4, false, false, false, 2744, 3, 22, 1,  0, 0}, // #747
  {DBGFIELD("CWD")                1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #748
  {DBGFIELD("FNSTSW16r")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #749
  {DBGFIELD("MMX_MOVDQ2Qrr")      1, false, false, false,  5, 1,  1, 1,  0, 0}, // #750
  {DBGFIELD("PUSHFS64")           1, false, false, false, 116, 1, 12, 1,  0, 0}, // #751
  {DBGFIELD("EXTRACTPSrr_VEXTRACTPSrr") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #752
  {DBGFIELD("RCL8r1_RCL16r1_RCL32r1_RCL64r1_RCR8r1_RCR16r1_RCR32r1_RCR64r1") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #753
  {DBGFIELD("RCR8ri_RCR16ri_RCR32ri_RCR64ri") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #754
  {DBGFIELD("RCL8ri_RCL16ri_RCL32ri_RCL64ri") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #755
  {DBGFIELD("COM_FIPr_COM_FIr_UCOM_FIPr_UCOM_FIr") 1, false, false, false, 417, 1, 22, 1,  0, 0}, // #756
  {DBGFIELD("MOV64sr")            1, false, false, false,  5, 1,  1, 1,  0, 0}, // #757
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCL8rCL_RCL8rCL_EVEX_RCL8rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND_RCR8rCL_RCR8rCL_EVEX_RCR8rCL_ND") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #758
  {DBGFIELD("PUSH16r_PUSH16rmr_PUSH32r_PUSH32rmr_PUSH64i8_PUSH64r_PUSH64rmr") 1, false, false, false, 389, 3,  1, 1,  0, 0}, // #759
  {DBGFIELD("CLI")                1, false, false, false,  5, 1,  4, 1,  0, 0}, // #760
  {DBGFIELD("PUSHGS64")           1, false, false, false, 116, 1, 12, 1,  0, 0}, // #761
  {DBGFIELD("ISTT_FP16m_ISTT_FP32m_ISTT_FP64m") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #762
  {DBGFIELD("CALL64pcrel32")      1, false, false, false,  4, 2,  1, 1,  0, 0}, // #763
  {DBGFIELD("CALL64r_RVMARKER_CALL16r_CALL16r_NT_CALL32r_CALL32r_NT_CALL64r_CALL64r_NT") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #764
  {DBGFIELD("EXTRACTPSmr_VEXTRACTPSmr") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #765
  {DBGFIELD("STOSB_STOSL_STOSQ_STOSW") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #766
  {DBGFIELD("PEXTRDmr_PEXTRQmr_VPEXTRDmr_VPEXTRQmr") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #767
  {DBGFIELD("PUSHF16_PUSHF64")    1, false, false, false, 417, 1, 22, 1,  0, 0}, // #768
  {DBGFIELD("CLFLUSH_CLFLUSHOPT") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #769
  {DBGFIELD("VBROADCASTSSrm")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #770
  {DBGFIELD("MOV64toPQIrm_VMOV64toPQIrm_MOVDI2PDIrm_VMOVDI2PDIrm_MOVQI2PQIrm_VMOVQI2PQIrm") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #771
  {DBGFIELD("MOVDDUPrm_VMOVDDUPrm_MOVSHDUPrm_VMOVSHDUPrm_MOVSLDUPrm_VMOVSLDUPrm") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #772
  {DBGFIELD("MOVSDrm_MOVSDrm_alt_VMOVSDrm_VMOVSDrm_alt_MOVSSrm_MOVSSrm_alt_VMOVSSrm_VMOVSSrm_alt") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #773
  {DBGFIELD("MOV16sm")            1, false, false, false,  5, 1,  1, 1,  0, 0}, // #774
  {DBGFIELD("MMX_PABSBrm_MMX_PABSDrm_MMX_PABSWrm") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #775
  {DBGFIELD("MMX_PALIGNRrmi")     1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #776
  {DBGFIELD("MMX_PSIGNBrm_MMX_PSIGNDrm_MMX_PSIGNWrm") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #777
  {DBGFIELD("LODSL_LODSQ")        1, false, false, false, 116, 1, 12, 1,  0, 0}, // #778
  {DBGFIELD("VMOVDDUPYrm_VMOVSHDUPYrm_VMOVSLDUPYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #779
  {DBGFIELD("VINSERTF128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #780
  {DBGFIELD("MMX_PADDQrm")        1, false, false, false, 303, 1,  5, 1,  0, 0}, // #781
  {DBGFIELD("VERRm_VERWm")        1, false, false, false,  5, 1,  4, 1,  0, 0}, // #782
  {DBGFIELD("FARJMP64m")          1, false, false, false,  4, 2,  1, 1,  0, 0}, // #783
  {DBGFIELD("FNSTSWm")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #784
  {DBGFIELD("SLDT16r_SLDT32r_SLDT64r_STR16r_STR32r_STR64r") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #785
  {DBGFIELD("CALL64m_RVMARKER_CALL64m_CALL64m_NT") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #786
  {DBGFIELD("CALL16m_CALL16m_NT_CALL32m_CALL32m_NT") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #787
  {DBGFIELD("COMISDrm_COMISDrm_Int_COMISSrm_COMISSrm_Int_UCOMISDrm_UCOMISDrm_Int_UCOMISSrm_UCOMISSrm_Int_VCOMISDrm_VCOMISDrm_Int_VCOMISSrm_VCOMISSrm_Int_VUCOMISDrm_VUCOMISDrm_Int_VUCOMISSrm_VUCOMISSrm_Int") 5, false, false, false, 2741, 3,  9, 1, 14, 1}, // #788
  {DBGFIELD("CMPSB_CMPSL_CMPSQ_CMPSW") 1, false, false, false, 303, 1,  5, 1,  0, 0}, // #789
  {DBGFIELD("ROL16m1_ROL16m1_EVEX_ROL16m1_NF_ROL16mi_ROL16mi_EVEX_ROL16mi_NF_ROL32m1_ROL32m1_EVEX_ROL32m1_NF_ROL32mi_ROL32mi_EVEX_ROL32mi_NF_ROL64m1_ROL64m1_EVEX_ROL64m1_NF_ROL64mi_ROL64mi_EVEX_ROL64mi_NF_ROL8m1_ROL8m1_EVEX_ROL8m1_NF_ROL8mi_ROL8mi_EVEX_ROL8mi_NF_ROR16m1_ROR16m1_EVEX_ROR16m1_NF_ROR16mi_ROR16mi_EVEX_ROR16mi_NF_ROR32m1_ROR32m1_EVEX_ROR32m1_NF_ROR32mi_ROR32mi_EVEX_ROR32mi_NF_ROR64m1_ROR64m1_EVEX_ROR64m1_NF_ROR64mi_ROR64mi_EVEX_ROR64mi_NF_ROR8m1_ROR8m1_EVEX_ROR8m1_NF_ROR8mi_ROR8mi_EVEX_ROR8mi_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #790
  {DBGFIELD("ROL16m1_ND_ROL16m1_NF_ND_ROL16mi_ND_ROL16mi_NF_ND_ROL32m1_ND_ROL32m1_NF_ND_ROL32mi_ND_ROL32mi_NF_ND_ROL64m1_ND_ROL64m1_NF_ND_ROL64mi_ND_ROL64mi_NF_ND_ROL8m1_ND_ROL8m1_NF_ND_ROL8mi_ND_ROL8mi_NF_ND_ROR16m1_ND_ROR16m1_NF_ND_ROR16mi_ND_ROR16mi_NF_ND_ROR32m1_ND_ROR32m1_NF_ND_ROR32mi_ND_ROR32mi_NF_ND_ROR64m1_ND_ROR64m1_NF_ND_ROR64mi_ND_ROR64mi_NF_ND_ROR8m1_ND_ROR8m1_NF_ND_ROR8mi_ND_ROR8mi_NF_ND") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #791
  {DBGFIELD("XADD16rm_XADD32rm_XADD64rm_XADD8rm") 1, false, false, false, 303, 1,  5, 1,  0, 0}, // #792
  {DBGFIELD("FARCALL64m")         1, false, false, false,  4, 2,  1, 1,  0, 0}, // #793
  {DBGFIELD("LD_F32m_LD_F64m")    1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #794
  {DBGFIELD("ROL16mCL_ROL16mCL_EVEX_ROL16mCL_NF_ROL32mCL_ROL32mCL_EVEX_ROL32mCL_NF_ROL64mCL_ROL64mCL_EVEX_ROL64mCL_NF_ROL8mCL_ROL8mCL_EVEX_ROL8mCL_NF_ROR16mCL_ROR16mCL_EVEX_ROR16mCL_NF_ROR32mCL_ROR32mCL_EVEX_ROR32mCL_NF_ROR64mCL_ROR64mCL_EVEX_ROR64mCL_NF_ROR8mCL_ROR8mCL_EVEX_ROR8mCL_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #795
  {DBGFIELD("ROL16mCL_ND_ROL16mCL_NF_ND_ROL32mCL_ND_ROL32mCL_NF_ND_ROL64mCL_ND_ROL64mCL_NF_ND_ROL8mCL_ND_ROL8mCL_NF_ND_ROR16mCL_ND_ROR16mCL_NF_ND_ROR32mCL_ND_ROR32mCL_NF_ND_ROR64mCL_ND_ROR64mCL_NF_ND_ROR8mCL_ND_ROR8mCL_NF_ND") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #796
  {DBGFIELD("ADC8mr_ADC16mr_ADC32mr_ADC64mr_SBB8mr_SBB16mr_SBB32mr_SBB64mr") 1, false, false, false, 2729, 2,  1, 1, 15, 2}, // #797
  {DBGFIELD("ADD_F32m_ADD_F64m_SUBR_F32m_SUBR_F64m_SUB_F32m_SUB_F64m") 1, false, false, false, 389, 3, 10, 1,  0, 0}, // #798
  {DBGFIELD("PCMPGTQrm_VPCMPGTQrm") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #799
  {DBGFIELD("FICOM16m_FICOM32m_FICOMP16m_FICOMP32m") 1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #800
  {DBGFIELD("MUL_F32m_MUL_F64m")  1, false, false, false, 2782, 2, 14, 1,  0, 0}, // #801
  {DBGFIELD("ADD_FI16m_ADD_FI32m_SUBR_FI16m_SUBR_FI32m_SUB_FI16m_SUB_FI32m") 1, false, false, false, 389, 3, 10, 1,  0, 0}, // #802
  {DBGFIELD("MUL_FI16m_MUL_FI32m") 1, false, false, false, 2782, 2, 14, 1,  0, 0}, // #803
  {DBGFIELD("DIVR_F32m_DIVR_F64m_DIV_F32m_DIV_F64m") 4, false, false, false, 2776, 3, 100, 1,  0, 0}, // #804
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m_DIV_FI16m_DIV_FI32m") 4, false, false, false, 2776, 3, 100, 1,  0, 0}, // #805
  {DBGFIELD("VZEROALL")           1, false, false, false,  5, 1,  4, 1,  0, 0}, // #806
  {DBGFIELD("VZEROUPPER")         1, false, false, false,  5, 1,  4, 1,  0, 0}, // #807
  {DBGFIELD("CLC")                1, false, false, false,  5, 1,  1, 1,  0, 0}, // #808
  {DBGFIELD("SUB32rr_SUB64rr_XOR32rr_XOR64rr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #809
  {DBGFIELD("XORPSrr_VXORPSrr_XORPDrr_VXORPDrr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #810
  {DBGFIELD("VXORPSYrr_VXORPDYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #811
  {DBGFIELD("PXORrr_VPXORrr")     1, false, false, false,  5, 1,  1, 1,  0, 0}, // #812
  {DBGFIELD("PSUBBrr_VPSUBBrr_PSUBDrr_VPSUBDrr_VPSUBQrr_PSUBWrr_VPSUBWrr_PCMPGTBrr_VPCMPGTBrr_PCMPGTDrr_VPCMPGTDrr_PCMPGTWrr_VPCMPGTWrr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #813
  {DBGFIELD("PSUBQrr")            1, false, false, false, 116, 1, 12, 1,  0, 0}, // #814
  {DBGFIELD("PCMPGTQrr_VPCMPGTQrr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #815
  {DBGFIELD("CMOV16rr_CMOV32rr_CMOV64rr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #816
  {DBGFIELD("CMOV16rm_CMOV32rm_CMOV64rm") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #817
  {DBGFIELD("SETCCr")             1, false, false, false,  5, 1,  1, 1,  0, 0}, // #818
  {DBGFIELD("SETCCm")             1, false, false, false, 116, 1, 12, 1,  0, 0}, // #819
  {DBGFIELD("MOVHPDrm_MOVHPSrm_MOVLPDrm_MOVLPSrm_VMOVHPDrm_VMOVHPSrm_VMOVLPDrm_VMOVLPSrm") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #820
  {DBGFIELD("RETI16_RETI32_RETI64") 1, false, false, false, 389, 3,  1, 1,  0, 0}, // #821
  {DBGFIELD("LRETI16_LRETI32_LRETI64") 1, false, false, false, 1317, 1, 110, 1,  0, 0}, // #822
  {DBGFIELD("RDPMC")              1, false, false, false, 1233, 1, 66, 1,  0, 0}, // #823
  {DBGFIELD("RDRAND16r_RDRAND32r_RDRAND64r") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #824
  {DBGFIELD("FBLDm")              1, false, false, false,  5, 1,  4, 1,  0, 0}, // #825
  {DBGFIELD("FFREE_FFREEP")       1, false, false, false,  5, 1,  1, 1,  0, 0}, // #826
  {DBGFIELD("FSAVEm")             1, false, false, false,  5, 1,  4, 1,  0, 0}, // #827
  {DBGFIELD("FRSTORm")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #828
  {DBGFIELD("FXTRACT")            1, false, false, false, 2806, 1, 46, 1,  0, 0}, // #829
  {DBGFIELD("VPBROADCASTDrm_VPBROADCASTQrm") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #830
  {DBGFIELD("VBROADCASTF128rm_VBROADCASTSDYrm_VBROADCASTSSYrm") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #831
  {DBGFIELD("VBROADCASTI128rm")   1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #832
  {DBGFIELD("VPBROADCASTDYrm_VPBROADCASTQYrm") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #833
  {DBGFIELD("FBSTPm")             1, false, false, false,  5, 1,  4, 1,  0, 0}, // #834
  {DBGFIELD("VMPTRSTm")           1, false, false, false,  5, 1,  4, 1,  0, 0}, // #835
  {DBGFIELD("ST_FP32m_ST_FP64m")  1, false, false, false, 116, 1, 12, 1,  0, 0}, // #836
  {DBGFIELD("VPSLLVQYrr_VPSRLVQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #837
  {DBGFIELD("VPSLLVQrr_VPSRLVQrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #838
  {DBGFIELD("MMX_MOVQ2DQrr")      1, false, false, false,  5, 1,  1, 1,  0, 0}, // #839
  {DBGFIELD("JMP16r_JMP16r_NT_JMP32r_JMP32r_NT_JMP64r_JMP64r_NT_JMP64r_REX") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #840
  {DBGFIELD("FINCSTP")            1, false, false, false,  5, 1,  1, 1,  0, 0}, // #841
  {DBGFIELD("ANDN32rr_ANDN32rr_EVEX_ANDN32rr_NF_ANDN64rr_ANDN64rr_EVEX_ANDN64rr_NF") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #842
  {DBGFIELD("VPBLENDDYrri")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #843
  {DBGFIELD("VPBLENDDrri")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #844
  {DBGFIELD("SGDT64m_SIDT64m_SMSW16m_STRm_SYSCALL") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #845
  {DBGFIELD("VPSLLVQrm_VPSRLVQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #846
  {DBGFIELD("VPSLLVQYrm_VPSRLVQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #847
  {DBGFIELD("PDEP32rm_PDEP32rm_EVEX_PDEP64rm_PDEP64rm_EVEX_PEXT32rm_PEXT32rm_EVEX_PEXT64rm_PEXT64rm_EVEX") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #848
  {DBGFIELD("PMOVSXBDrm_PMOVZXBDrm_VPMOVSXBDrm_VPMOVZXBDrm_PMOVSXBQrm_PMOVZXBQrm_VPMOVSXBQrm_VPMOVZXBQrm_PMOVSXBWrm_PMOVZXBWrm_VPMOVSXBWrm_VPMOVZXBWrm_PMOVSXDQrm_PMOVZXDQrm_VPMOVSXDQrm_VPMOVZXDQrm_PMOVSXWDrm_PMOVZXWDrm_VPMOVSXWDrm_VPMOVZXWDrm_PMOVSXWQrm_PMOVZXWQrm_VPMOVSXWQrm_VPMOVZXWQrm") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #849
  {DBGFIELD("VPMOVSXBDYrm_VPMOVSXBQYrm_VPMOVSXWQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #850
  {DBGFIELD("JMP16m_JMP16m_NT_JMP32m_JMP32m_NT_JMP64m_JMP64m_NT_JMP64m_REX") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #851
  {DBGFIELD("ANDN32rm_ANDN32rm_EVEX_ANDN32rm_NF_ANDN64rm_ANDN64rm_EVEX_ANDN64rm_NF") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #852
  {DBGFIELD("MOVBE16rm_MOVBE16rm_EVEX_MOVBE32rm_MOVBE32rm_EVEX_MOVBE64rm_MOVBE64rm_EVEX") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #853
  {DBGFIELD("VINSERTI128rm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #854
  {DBGFIELD("VPBLENDDrmi")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #855
  {DBGFIELD("VPBLENDDYrmi")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #856
  {DBGFIELD("POP32r_POP64r")      1, false, false, false, 389, 3,  1, 1,  0, 0}, // #857
  {DBGFIELD("SFENCE")             1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #858
  {DBGFIELD("MOVBE32mr_MOVBE32mr_EVEX_MOVBE64mr_MOVBE64mr_EVEX") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #859
  {DBGFIELD("MOVBE16mr")          1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #860
  {DBGFIELD("PUSH16r_PUSH32r_PUSH64r_PUSH64i8") 1, false, false, false, 389, 3,  1, 1,  0, 0}, // #861
  {DBGFIELD("MFENCE")             1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #862
  {DBGFIELD("XGETBV")             1, false, false, false,  5, 1,  4, 1,  0, 0}, // #863
  {DBGFIELD("MMX_PACKSSDWrm_MMX_PACKSSWBrm_MMX_PACKUSWBrm") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #864
  {DBGFIELD("LRET64_RET32")       1, false, false, false, 1317, 1, 110, 1,  0, 0}, // #865
  {DBGFIELD("ROL8r1_ROL16r1_ROL32r1_ROL64r1_ROR8r1_ROR16r1_ROR32r1_ROR64r1") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #866
  {DBGFIELD("PDEP32rr_PDEP32rr_EVEX_PDEP64rr_PDEP64rr_EVEX_PEXT32rr_PEXT32rr_EVEX_PEXT64rr_PEXT64rr_EVEX") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #867
  {DBGFIELD("VPBROADCASTBrr_VPBROADCASTWrr") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #868
  {DBGFIELD("VPMOVSXBWYrm_VPMOVSXDQYrm_VPMOVSXWDYrm_VPMOVZXWDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #869
  {DBGFIELD("MMX_PACKSSDWrr_MMX_PACKSSWBrr_MMX_PACKUSWBrr") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #870
  {DBGFIELD("CLDEMOTE")           1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #871
  {DBGFIELD("MMX_CVTPI2PDrm")     4, false, false, false, 2749, 3,  7, 1,  0, 0}, // #872
  {DBGFIELD("VPBROADCASTBYrm_VPBROADCASTBrm_VPBROADCASTWYrm_VPBROADCASTWrm") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #873
  {DBGFIELD("LAR16rr_LAR32rr_LAR64rr") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #874
  {DBGFIELD("LAR16rm_LAR32rm_LAR64rm_LSL16rm_LSL32rm_LSL64rm") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #875
  {DBGFIELD("MUL_FPrST0_MUL_FST0r_MUL_FrST0") 1, false, false, false, 2782, 2, 14, 1,  0, 0}, // #876
  {DBGFIELD("VPCMPGTQYrm")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #877
  {DBGFIELD("VCVTSI642SSrr_VCVTSI642SSrr_Int") 3, false, false, false, 2731, 3,  3, 1,  7, 1}, // #878
  {DBGFIELD("STR16r_STR32r_STR64r") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #879
  {DBGFIELD("XSETBV")             1, false, false, false,  5, 1,  4, 1,  0, 0}, // #880
  {DBGFIELD("RCL16mCL_RCL16mCL_EVEX_RCL32mCL_RCL32mCL_EVEX_RCL64mCL_RCL64mCL_EVEX_RCL8mCL_RCL8mCL_EVEX") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #881
  {DBGFIELD("RCL16mCL_ND_RCL32mCL_ND_RCL64mCL_ND_RCL8mCL_ND") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #882
  {DBGFIELD("RCL16rCL_RCL16rCL_EVEX_RCL16rCL_ND_RCL32rCL_RCL32rCL_EVEX_RCL32rCL_ND_RCL64rCL_RCL64rCL_EVEX_RCL64rCL_ND_RCR16rCL_RCR16rCL_EVEX_RCR16rCL_ND_RCR32rCL_RCR32rCL_EVEX_RCR32rCL_ND_RCR64rCL_RCR64rCL_EVEX_RCR64rCL_ND") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #883
  {DBGFIELD("RCL8rCL")            1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #884
  {DBGFIELD("RCR8rCL")            1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #885
  {DBGFIELD("RDTSC")              1, false, false, false, 2804, 1, 64, 1,  0, 0}, // #886
  {DBGFIELD("XRSTOR_XRSTOR64_XRSTORS_XRSTORS64") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #887
  {DBGFIELD("DIV_FPrST0_DIV_FST0r_DIV_FrST0") 3, false, false, false, 2776, 3, 100, 1,  0, 0}, // #888
  {DBGFIELD("DIVR_F32m_DIVR_F64m") 4, false, false, false, 2776, 3, 100, 1,  0, 0}, // #889
  {DBGFIELD("DIVR_FI16m_DIVR_FI32m") 4, false, false, false, 2776, 3, 100, 1,  0, 0}, // #890
  {DBGFIELD("DIVR_FPrST0_DIVR_FST0r_DIVR_FrST0") 3, false, false, false, 2776, 3, 100, 1,  0, 0}, // #891
  {DBGFIELD("XSAVE64")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #892
  {DBGFIELD("XSAVE")              1, false, false, false,  5, 1,  4, 1,  0, 0}, // #893
  {DBGFIELD("XSAVEC_XSAVEC64_XSAVES_XSAVES64_XSAVEOPT_XSAVEOPT64") 1, false, false, false,  5, 1,  4, 1,  0, 0}, // #894
  {DBGFIELD("VMCLEARm")           1, false, false, false,  5, 1,  4, 1,  0, 0}, // #895
  {DBGFIELD("FLDENVm")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #896
  {DBGFIELD("FXRSTOR64")          1, false, false, false, 2822, 1, 117, 1,  0, 0}, // #897
  {DBGFIELD("FSTENVm")            1, false, false, false,  5, 1,  4, 1,  0, 0}, // #898
  {DBGFIELD("VGATHERDPDrm_VPGATHERDQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #899
  {DBGFIELD("VGATHERDPDYrm_VPGATHERDQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #900
  {DBGFIELD("VGATHERDPSrm_VPGATHERDDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #901
  {DBGFIELD("VGATHERDPSYrm_VPGATHERDDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #902
  {DBGFIELD("VGATHERQPDrm_VPGATHERQQrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #903
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm_VGATHERQPSYrm_VPGATHERQDYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #904
  {DBGFIELD("VGATHERQPSrm_VPGATHERQDrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #905
  {DBGFIELD("VPXORYrr")           8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #906
  {DBGFIELD("VPSUBBYrr_VPSUBDYrr_VPSUBQYrr_VPSUBWYrr_VPCMPGTBYrr_VPCMPGTDYrr_VPCMPGTWYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #907
  {DBGFIELD("VPCMPGTQYrr")        8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #908
  {DBGFIELD("ADC16ri8_ADC32ri8_ADC64ri8_SBB16ri8_SBB32ri8_SBB64ri8") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #909
  {DBGFIELD("ADC8i8_SBB8i8_ADC16i16_SBB16i16_ADC32i32_SBB32i32_ADC64i32_SBB64i32") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #910
  {DBGFIELD("MOVBE16mr_EVEX")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #911
  {DBGFIELD("FCOM32m_FCOM64m_FCOMP32m_FCOMP64m") 1, false, false, false, 2747, 2, 10, 1,  0, 0}, // #912
  {DBGFIELD("LRET64")             1, false, false, false, 1317, 1, 110, 1,  0, 0}, // #913
  {DBGFIELD("POPF64")             1, false, false, false, 1785, 1, 80, 1,  0, 0}, // #914
  {DBGFIELD("VGATHERQPDYrm_VPGATHERQQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #915
  {DBGFIELD("PCMPEQQrr")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #916
  {DBGFIELD("PCMPGTQrr")          1, false, false, false,  5, 1,  1, 1,  0, 0}, // #917
  {DBGFIELD("PCMPEQQrm")          1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #918
  {DBGFIELD("PCMPGTQrm")          1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #919
  {DBGFIELD("MOV16rm")            1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #920
  {DBGFIELD("POP16rmm")           1, false, false, false, 303, 1,  5, 1,  0, 0}, // #921
  {DBGFIELD("PUSH16rmm_PUSH32rmm") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #922
  {DBGFIELD("PUSHF16")            1, false, false, false, 417, 1, 22, 1,  0, 0}, // #923
  {DBGFIELD("LAHF")               1, false, false, false, 116, 1, 12, 1,  0, 0}, // #924
  {DBGFIELD("ADD16mi_ADD16mi8_ADD16mi8_EVEX_ADD16mi8_NF_ADD16mi_EVEX_ADD16mi_NF_ADD32mi_ADD32mi8_ADD32mi8_EVEX_ADD32mi8_NF_ADD32mi_EVEX_ADD32mi_NF_ADD64mi32_ADD64mi32_EVEX_ADD64mi32_NF_ADD64mi8_ADD64mi8_EVEX_ADD64mi8_NF_ADD8mi_ADD8mi8_ADD8mi_EVEX_ADD8mi_NF_SUB16mi_SUB16mi8_SUB16mi8_EVEX_SUB16mi8_NF_SUB16mi_EVEX_SUB16mi_NF_SUB32mi_SUB32mi8_SUB32mi8_EVEX_SUB32mi8_NF_SUB32mi_EVEX_SUB32mi_NF_SUB64mi32_SUB64mi32_EVEX_SUB64mi32_NF_SUB64mi8_SUB64mi8_EVEX_SUB64mi8_NF_SUB8mi_SUB8mi8_SUB8mi_EVEX_SUB8mi_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #925
  {DBGFIELD("ADD16mi8_ND_ADD16mi8_NF_ND_ADD16mi_ND_ADD16mi_NF_ND_ADD16mr_ND_ADD16mr_NF_ND_ADD32mi8_ND_ADD32mi8_NF_ND_ADD32mi_ND_ADD32mi_NF_ND_ADD32mr_ND_ADD32mr_NF_ND_ADD64mi32_ND_ADD64mi32_NF_ND_ADD64mi8_ND_ADD64mi8_NF_ND_ADD64mr_ND_ADD64mr_NF_ND_ADD8mi_ND_ADD8mi_NF_ND_ADD8mr_ND_ADD8mr_NF_ND_SUB16mi8_ND_SUB16mi8_NF_ND_SUB16mi_ND_SUB16mi_NF_ND_SUB16mr_ND_SUB16mr_NF_ND_SUB32mi8_ND_SUB32mi8_NF_ND_SUB32mi_ND_SUB32mi_NF_ND_SUB32mr_ND_SUB32mr_NF_ND_SUB64mi32_ND_SUB64mi32_NF_ND_SUB64mi8_ND_SUB64mi8_NF_ND_SUB64mr_ND_SUB64mr_NF_ND_SUB8mi_ND_SUB8mi_NF_ND_SUB8mr_ND_SUB8mr_NF_ND") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #926
  {DBGFIELD("ADD16mr_ADD16mr_EVEX_ADD32mr_ADD32mr_EVEX_ADD64mr_ADD64mr_EVEX_ADD8mr_ADD8mr_EVEX_SUB16mr_SUB16mr_EVEX_SUB32mr_SUB32mr_EVEX_SUB64mr_SUB64mr_EVEX_SUB8mr_SUB8mr_EVEX") 1, false, false, false, 2729, 2,  1, 1, 15, 1}, // #927
  {DBGFIELD("ADD16mr_NF_ADD32mr_NF_ADD64mr_NF_ADD8mr_NF_SUB16mr_NF_SUB32mr_NF_SUB64mr_NF_SUB8mr_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #928
  {DBGFIELD("ADC16mi_ADC16mi8_ADC16mi8_EVEX_ADC16mi_EVEX_ADC32mi_ADC32mi8_ADC32mi8_EVEX_ADC32mi_EVEX_ADC64mi32_ADC64mi32_EVEX_ADC64mi8_ADC64mi8_EVEX_ADC8mi_ADC8mi8_ADC8mi_EVEX_SBB16mi_SBB16mi8_SBB16mi8_EVEX_SBB16mi_EVEX_SBB32mi_SBB32mi8_SBB32mi8_EVEX_SBB32mi_EVEX_SBB64mi32_SBB64mi32_EVEX_SBB64mi8_SBB64mi8_EVEX_SBB8mi_SBB8mi8_SBB8mi_EVEX") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #929
  {DBGFIELD("ADC16mi8_ND_ADC16mi_ND_ADC16mr_ND_ADC32mi8_ND_ADC32mi_ND_ADC32mr_ND_ADC64mi32_ND_ADC64mi8_ND_ADC64mr_ND_ADC8mi_ND_ADC8mr_ND_SBB16mi8_ND_SBB16mi_ND_SBB16mr_ND_SBB32mi8_ND_SBB32mi_ND_SBB32mr_ND_SBB64mi32_ND_SBB64mi8_ND_SBB64mr_ND_SBB8mi_ND_SBB8mr_ND") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #930
  {DBGFIELD("ADC16mr_EVEX_ADC32mr_EVEX_ADC64mr_EVEX_ADC8mr_EVEX_SBB16mr_EVEX_SBB32mr_EVEX_SBB64mr_EVEX_SBB8mr_EVEX") 1, false, false, false, 2729, 2,  1, 1, 15, 2}, // #931
  {DBGFIELD("DEC16m_DEC16m_EVEX_DEC16m_NF_DEC32m_DEC32m_EVEX_DEC32m_NF_DEC64m_DEC64m_EVEX_DEC64m_NF_DEC8m_DEC8m_EVEX_DEC8m_NF_INC16m_INC16m_EVEX_INC16m_NF_INC32m_INC32m_EVEX_INC32m_NF_INC64m_INC64m_EVEX_INC64m_NF_INC8m_INC8m_EVEX_INC8m_NF_NEG16m_NEG16m_EVEX_NEG16m_NF_NEG32m_NEG32m_EVEX_NEG32m_NF_NEG64m_NEG64m_EVEX_NEG64m_NF_NEG8m_NEG8m_EVEX_NEG8m_NF_NOT16m_NOT16m_EVEX_NOT32m_NOT32m_EVEX_NOT64m_NOT64m_EVEX_NOT8m_NOT8m_EVEX") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #932
  {DBGFIELD("DEC16m_ND_DEC16m_NF_ND_DEC32m_ND_DEC32m_NF_ND_DEC64m_ND_DEC64m_NF_ND_DEC8m_ND_DEC8m_NF_ND_INC16m_ND_INC16m_NF_ND_INC32m_ND_INC32m_NF_ND_INC64m_ND_INC64m_NF_ND_INC8m_ND_INC8m_NF_ND_NEG16m_ND_NEG16m_NF_ND_NEG32m_ND_NEG32m_NF_ND_NEG64m_ND_NEG64m_NF_ND_NEG8m_ND_NEG8m_NF_ND_NOT16m_ND_NOT32m_ND_NOT64m_ND_NOT8m_ND") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #933
  {DBGFIELD("CALL16r_CALL16r_NT_CALL32r_CALL32r_NT") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #934
  {DBGFIELD("RET16_LRET16_LRET32") 1, false, false, false, 1317, 1, 110, 1,  0, 0}, // #935
  {DBGFIELD("IRET16_IRET32_IRET64") 1, false, false, false, 389, 3,  1, 1,  0, 0}, // #936
  {DBGFIELD("AND16mi_AND16mi8_AND16mi8_EVEX_AND16mi8_NF_AND16mi_EVEX_AND16mi_NF_AND32mi_AND32mi8_AND32mi8_EVEX_AND32mi8_NF_AND32mi_EVEX_AND32mi_NF_AND64mi32_AND64mi32_EVEX_AND64mi32_NF_AND64mi8_AND64mi8_EVEX_AND64mi8_NF_AND8mi_AND8mi8_AND8mi_EVEX_AND8mi_NF_OR16mi_OR16mi8_OR16mi8_EVEX_OR16mi8_NF_OR16mi_EVEX_OR16mi_NF_OR32mi_OR32mi8_OR32mi8Locked_OR32mi8_EVEX_OR32mi8_NF_OR32mi_EVEX_OR32mi_NF_OR64mi32_OR64mi32_EVEX_OR64mi32_NF_OR64mi8_OR64mi8_EVEX_OR64mi8_NF_OR8mi_OR8mi8_OR8mi_EVEX_OR8mi_NF_XOR16mi_XOR16mi8_XOR16mi8_EVEX_XOR16mi8_NF_XOR16mi_EVEX_XOR16mi_NF_XOR32mi_XOR32mi8_XOR32mi8_EVEX_XOR32mi8_NF_XOR32mi_EVEX_XOR32mi_NF_XOR64mi32_XOR64mi32_EVEX_XOR64mi32_NF_XOR64mi8_XOR64mi8_EVEX_XOR64mi8_NF_XOR8mi_XOR8mi8_XOR8mi_EVEX_XOR8mi_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #937
  {DBGFIELD("AND16mi8_ND_AND16mi8_NF_ND_AND16mi_ND_AND16mi_NF_ND_AND16mr_ND_AND16mr_NF_ND_AND32mi8_ND_AND32mi8_NF_ND_AND32mi_ND_AND32mi_NF_ND_AND32mr_ND_AND32mr_NF_ND_AND64mi32_ND_AND64mi32_NF_ND_AND64mi8_ND_AND64mi8_NF_ND_AND64mr_ND_AND64mr_NF_ND_AND8mi_ND_AND8mi_NF_ND_AND8mr_ND_AND8mr_NF_ND_OR16mi8_ND_OR16mi8_NF_ND_OR16mi_ND_OR16mi_NF_ND_OR16mr_ND_OR16mr_NF_ND_OR32mi8_ND_OR32mi8_NF_ND_OR32mi_ND_OR32mi_NF_ND_OR32mr_ND_OR32mr_NF_ND_OR64mi32_ND_OR64mi32_NF_ND_OR64mi8_ND_OR64mi8_NF_ND_OR64mr_ND_OR64mr_NF_ND_OR8mi_ND_OR8mi_NF_ND_OR8mr_ND_OR8mr_NF_ND_XOR16mi8_ND_XOR16mi8_NF_ND_XOR16mi_ND_XOR16mi_NF_ND_XOR16mr_ND_XOR16mr_NF_ND_XOR32mi8_ND_XOR32mi8_NF_ND_XOR32mi_ND_XOR32mi_NF_ND_XOR32mr_ND_XOR32mr_NF_ND_XOR64mi32_ND_XOR64mi32_NF_ND_XOR64mi8_ND_XOR64mi8_NF_ND_XOR64mr_ND_XOR64mr_NF_ND_XOR8mi_ND_XOR8mi_NF_ND_XOR8mr_ND_XOR8mr_NF_ND") 1, false, false, false, 2729, 2,  1, 1, 14, 1}, // #938
  {DBGFIELD("AND16mr_AND16mr_EVEX_AND32mr_AND32mr_EVEX_AND64mr_AND64mr_EVEX_AND8mr_AND8mr_EVEX_OR16mr_OR16mr_EVEX_OR32mr_OR32mr_EVEX_OR64mr_OR64mr_EVEX_OR8mr_OR8mr_EVEX_XOR16mr_XOR16mr_EVEX_XOR32mr_XOR32mr_EVEX_XOR64mr_XOR64mr_EVEX_XOR8mr_XOR8mr_EVEX") 1, false, false, false, 2729, 2,  1, 1, 15, 1}, // #939
  {DBGFIELD("AND16mr_NF_AND32mr_NF_AND64mr_NF_AND8mr_NF_OR16mr_NF_OR32mr_NF_OR64mr_NF_OR8mr_NF_XOR16mr_NF_XOR32mr_NF_XOR64mr_NF_XOR8mr_NF") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #940
  {DBGFIELD("SHLD16mri8_EVEX_SHLD16mri8_ND_SHLD16mri8_NF_SHLD16mri8_NF_ND_SHLD32mri8_SHLD32mri8_EVEX_SHLD32mri8_ND_SHLD32mri8_NF_SHLD32mri8_NF_ND_SHLD64mri8_EVEX_SHLD64mri8_ND_SHLD64mri8_NF_SHLD64mri8_NF_ND_SHRD16mri8_EVEX_SHRD16mri8_ND_SHRD16mri8_NF_SHRD16mri8_NF_ND_SHRD32mri8_SHRD32mri8_EVEX_SHRD32mri8_ND_SHRD32mri8_NF_SHRD32mri8_NF_ND_SHRD64mri8_EVEX_SHRD64mri8_ND_SHRD64mri8_NF_SHRD64mri8_NF_ND") 1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #941
  {DBGFIELD("SHLD16rrCL_EVEX_SHLD16rrCL_ND_SHLD16rrCL_NF_SHLD16rrCL_NF_ND_SHLD32rrCL_SHLD32rrCL_EVEX_SHLD32rrCL_ND_SHLD32rrCL_NF_SHLD32rrCL_NF_ND_SHLD64rrCL_EVEX_SHLD64rrCL_ND_SHLD64rrCL_NF_SHLD64rrCL_NF_ND_SHRD16rrCL_EVEX_SHRD16rrCL_ND_SHRD16rrCL_NF_SHRD16rrCL_NF_ND_SHRD32rrCL_SHRD32rrCL_EVEX_SHRD32rrCL_ND_SHRD32rrCL_NF_SHRD32rrCL_NF_ND_SHRD64rrCL_EVEX_SHRD64rrCL_ND_SHRD64rrCL_NF_SHRD64rrCL_NF_ND") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #942
  {DBGFIELD("SHLD16mrCL_EVEX_SHLD16mrCL_ND_SHLD16mrCL_NF_SHLD16mrCL_NF_ND_SHLD32mrCL_SHLD32mrCL_EVEX_SHLD32mrCL_ND_SHLD32mrCL_NF_SHLD32mrCL_NF_ND_SHLD64mrCL_EVEX_SHLD64mrCL_ND_SHLD64mrCL_NF_SHLD64mrCL_NF_ND_SHRD16mrCL_EVEX_SHRD16mrCL_ND_SHRD16mrCL_NF_SHRD16mrCL_NF_ND_SHRD32mrCL_SHRD32mrCL_EVEX_SHRD32mrCL_ND_SHRD32mrCL_NF_SHRD32mrCL_NF_ND_SHRD64mrCL_EVEX_SHRD64mrCL_ND_SHRD64mrCL_NF_SHRD64mrCL_NF_ND") 1, false, false, false, 1517, 1, 14, 1,  0, 0}, // #943
  {DBGFIELD("XADD16rr_XADD32rr_XADD64rr_XADD8rr") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #944
  {DBGFIELD("CHS_F_CHS_Fp32_CHS_Fp64_CHS_Fp80") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #945
  {DBGFIELD("MMX_MASKMOVQ_MMX_MASKMOVQ64") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #946
  {DBGFIELD("MASKMOVDQU_MASKMOVDQU64") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #947
  {DBGFIELD("VMASKMOVDQU_VMASKMOVDQU64") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #948
  {DBGFIELD("VPMASKMOVDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #949
  {DBGFIELD("VPMASKMOVDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #950
  {DBGFIELD("VPMASKMOVDYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #951
  {DBGFIELD("VPMASKMOVDmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #952
  {DBGFIELD("VPMASKMOVQYmr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #953
  {DBGFIELD("VPMASKMOVQmr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #954
  {DBGFIELD("VPBROADCASTBrm_VPBROADCASTWrm") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #955
  {DBGFIELD("VPGATHERDDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #956
  {DBGFIELD("VPGATHERDDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #957
  {DBGFIELD("VPGATHERDQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #958
  {DBGFIELD("VPGATHERDQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #959
  {DBGFIELD("VPGATHERQDYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #960
  {DBGFIELD("VPGATHERQDrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #961
  {DBGFIELD("VPGATHERQQYrm")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #962
  {DBGFIELD("VPGATHERQQrm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #963
  {DBGFIELD("VPERM2F128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #964
  {DBGFIELD("VPERM2I128rr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #965
  {DBGFIELD("VPERM2F128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #966
  {DBGFIELD("VPERM2I128rm")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #967
  {DBGFIELD("VBROADCASTF128rm")   1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #968
  {DBGFIELD("VEXTRACTF128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #969
  {DBGFIELD("VEXTRACTI128rr")     8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #970
  {DBGFIELD("VEXTRACTF128mr")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #971
  {DBGFIELD("VEXTRACTI128mr")     1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #972
  {DBGFIELD("VINSERTF128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #973
  {DBGFIELD("VINSERTI128rr")      8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #974
  {DBGFIELD("CVTDQ2PDrr_VCVTDQ2PDrr") 3, false, false, false, 2731, 3,  6, 1,  0, 0}, // #975
  {DBGFIELD("VCVTDQ2PDYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #976
  {DBGFIELD("CVTPD2DQrr_CVTTPD2DQrr_VCVTPD2DQrr_VCVTTPD2DQrr") 4, false, false, false, 2749, 3,  6, 1,  0, 0}, // #977
  {DBGFIELD("CVTPD2DQrm_CVTTPD2DQrm_VCVTPD2DQrm_VCVTTPD2DQrm") 5, false, false, false, 2752, 3,  7, 1,  0, 0}, // #978
  {DBGFIELD("VCVTPD2DQYrr_VCVTTPD2DQYrr") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #979
  {DBGFIELD("VCVTPD2DQYrm_VCVTTPD2DQYrm") 8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #980
  {DBGFIELD("MMX_CVTPI2PDrr")     3, false, false, false, 2731, 3,  6, 1,  0, 0}, // #981
  {DBGFIELD("MMX_CVTPD2PIrr_MMX_CVTTPD2PIrr") 4, false, false, false, 2749, 3,  6, 1,  0, 0}, // #982
  {DBGFIELD("CVTSS2SIrr_CVTTSS2SIrr_VCVTSS2SI64rr_VCVTSS2SIrr_VCVTTSS2SI64rr_VCVTTSS2SIrr") 3, false, false, false, 2752, 3,  7, 1,  0, 0}, // #983
  {DBGFIELD("CVTSS2SIrr_Int_CVTTSS2SIrr_Int_VCVTSS2SI64rr_Int_VCVTSS2SIrr_Int_VCVTTSS2SI64rr_Int_VCVTTSS2SIrr_Int") 3, false, false, false, 2752, 3,  7, 1,  0, 0}, // #984
  {DBGFIELD("CVTSS2SIrm_CVTSS2SIrm_Int_CVTTSS2SIrm_CVTTSS2SIrm_Int_VCVTSS2SI64rm_VCVTSS2SI64rm_Int_VCVTSS2SIrm_VCVTSS2SIrm_Int_VCVTTSS2SI64rm_VCVTTSS2SI64rm_Int_VCVTTSS2SIrm_VCVTTSS2SIrm_Int") 4, false, false, false, 2744, 3, 22, 1,  0, 0}, // #985
  {DBGFIELD("CVTSI2SDrr_CVTSI642SDrr") 3, false, false, false, 2731, 3,  3, 1,  0, 1}, // #986
  {DBGFIELD("CVTSI2SDrr_Int_CVTSI642SDrr_Int_VCVTSI2SDrr_VCVTSI2SDrr_Int_VCVTSI642SDrr_VCVTSI642SDrr_Int") 3, false, false, false, 2731, 3,  3, 1,  7, 1}, // #987
  {DBGFIELD("CVTSD2SI64rr_CVTSD2SIrr_CVTTSD2SI64rr_CVTTSD2SIrr_VCVTSD2SI64rr_VCVTSD2SIrr_VCVTTSD2SI64rr_VCVTTSD2SIrr") 3, false, false, false, 2752, 3,  7, 1,  0, 0}, // #988
  {DBGFIELD("CVTSD2SI64rr_Int_CVTSD2SIrr_Int_CVTTSD2SI64rr_Int_CVTTSD2SIrr_Int_VCVTSD2SI64rr_Int_VCVTSD2SIrr_Int") 3, false, false, false, 2752, 3,  7, 1,  0, 0}, // #989
  {DBGFIELD("VCVTTSD2SI64rr_Int_VCVTTSD2SIrr_Int") 3, false, false, false, 2752, 3,  7, 1,  0, 0}, // #990
  {DBGFIELD("CVTSD2SI64rm_CVTSD2SI64rm_Int_CVTSD2SIrm_CVTSD2SIrm_Int_CVTTSD2SI64rm_CVTTSD2SI64rm_Int_CVTTSD2SIrm_CVTTSD2SIrm_Int_VCVTSD2SI64rm_VCVTSD2SI64rm_Int_VCVTSD2SIrm_VCVTSD2SIrm_Int_VCVTTSD2SI64rm_VCVTTSD2SIrm") 4, false, false, false, 2741, 3, 22, 1,  0, 0}, // #991
  {DBGFIELD("VCVTTSD2SI64rm_Int_VCVTTSD2SIrm_Int") 4, false, false, false, 2744, 3, 22, 1,  0, 0}, // #992
  {DBGFIELD("EXTRQ_EXTRQI")       1, false, false, false,  5, 1,  1, 1,  0, 0}, // #993
  {DBGFIELD("INSERTQ_INSERTQI")   1, false, false, false,  5, 1,  1, 1,  0, 0}, // #994
  {DBGFIELD("SHA256MSG2rm")       1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #995
  {DBGFIELD("SHA256MSG2rr")       1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #996
  {DBGFIELD("SHA1MSG1rr_SHA256MSG1rr") 1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #997
  {DBGFIELD("SHA1MSG1rm_SHA256MSG1rm") 1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #998
  {DBGFIELD("SHA1MSG2rr")         1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #999
  {DBGFIELD("SHA1MSG2rm")         1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #1000
  {DBGFIELD("SHA1NEXTErr")        1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #1001
  {DBGFIELD("SHA1NEXTErm")        1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #1002
  {DBGFIELD("SHA1RNDS4rri")       1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #1003
  {DBGFIELD("SHA1RNDS4rmi")       1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #1004
  {DBGFIELD("SHA256RNDS2rr")      1, false, false, false, 2782, 2, 10, 1,  0, 0}, // #1005
  {DBGFIELD("SHA256RNDS2rm")      1, false, false, false, 2782, 2, 10, 1, 14, 1}, // #1006
  {DBGFIELD("XCHG16rr_XCHG32rr_XCHG64rr_XCHG8rr_XCHG16ar_XCHG32ar_XCHG64ar") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #1007
  {DBGFIELD("CVTDQ2PSrr_VCVTDQ2PSrr") 3, false, false, false, 2731, 3,  3, 1,  0, 0}, // #1008
  {DBGFIELD("VCVTDQ2PSYrr")       8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1009
  {DBGFIELD("CVTPS2DQrr_CVTTPS2DQrr_VCVTPS2DQrr_VCVTTPS2DQrr") 3, false, false, false, 2731, 3,  3, 1,  0, 0}, // #1010
  {DBGFIELD("MOV8rm_MOV8rm_NOREX_MOVSX16rm16_MOVSX16rm32_MOVZX16rm16") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #1011
  {DBGFIELD("MOVBE16rm")          1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #1012
  {DBGFIELD("MOVBE32mr_MOVBE64mr") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #1013
  {DBGFIELD("ADD8i8_ADD16i16_ADD32i32_ADD64i32_AND8i8_AND16i16_AND32i32_AND64i32_OR8i8_OR16i16_OR32i32_OR64i32_SUB8i8_SUB16i16_SUB32i32_SUB64i32_XOR8i8_XOR16i16_XOR32i32_XOR64i32") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #1014
  {DBGFIELD("MOVSX16rr16_MOVSX16rr32_MOVZX16rr16") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #1015
  {DBGFIELD("MOV32ri_MOV32ri_alt_MOV64ri32") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #1016
  {DBGFIELD("PDEP32rr_PDEP64rr_PEXT32rr_PEXT64rr") 1, false, false, false,  5, 1,  1, 1,  0, 0}, // #1017
  {DBGFIELD("ADC8mr_SBB8mr")      1, false, false, false, 2729, 2,  1, 1, 15, 2}, // #1018
  {DBGFIELD("LEA32r_LEA64r_LEA64_32r") 1, false, false, false,  4, 2,  1, 1,  0, 0}, // #1019
  {DBGFIELD("LEA16r")             1, false, false, false,  4, 2,  1, 1,  0, 0}, // #1020
  {DBGFIELD("LCMPXCHG8")          1, false, false, false, 2727, 2,  1, 1,  0, 0}, // #1021
  {DBGFIELD("LCMPXCHG16B")        1, false, false, false, 2727, 2,  1, 1,  0, 0}, // #1022
  {DBGFIELD("XCHG8rr_XCHG16rr_XCHG16ar") 1, false, false, false, 116, 1, 12, 1,  0, 0}, // #1023
  {DBGFIELD("XCHG8rm_XCHG16rm")   1, false, false, false, 303, 1,  5, 1,  0, 0}, // #1024
  {DBGFIELD("POPCNT16rr")         8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1025
  {DBGFIELD("LZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1026
  {DBGFIELD("TZCNT16rr")          8191, false, false, false,  0, 0,  0, 0,  0, 0}, // #1027
  {DBGFIELD("RCL8m1_RCL16m1_RCL32m1_RCL64m1_RCR8m1_RCR16m1_RCR32m1_RCR64m1") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #1028
  {DBGFIELD("RCR8mi_RCR16mi_RCR32mi_RCR64mi") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #1029
  {DBGFIELD("RCL8mi_RCL16mi_RCL32mi_RCL64mi") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #1030
  {DBGFIELD("RCR16rCL_RCR32rCL_RCR64rCL") 1, false, false, false, 2729, 2,  1, 1,  0, 0}, // #1031
  {DBGFIELD("RCR8mCL_RCR16