/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */

#include <xmloff/txtprmap.hxx>
#include <xmloff/xmlnamespace.hxx>
#include <xmloff/xmltoken.hxx>
#include <xmloff/maptype.hxx>
#include <xmloff/xmltypes.hxx>
#include "txtprhdl.hxx"
#include <xmlsdtypes.hxx>
#include <sal/log.hxx>
#include <rtl/ref.hxx>
#include <xmlprop.hxx>

using namespace ::com::sun::star;
using namespace ::xmloff::token;

#define M_E_( a, p, l, t, c ) \
    { a, p, l, t, c, SvtSaveOptions::ODFSVER_010, false }

#define M_EV_( a, p, l, t, c, v ) \
    { a, p, l, t, c, v, false }

#define M_ED_( a, p, l, t, c ) \
    { a, p, l, (t) | MID_FLAG_DEFAULT_ITEM_EXPORT, c, SvtSaveOptions::ODFSVER_010, false }

// text properties
#define MT_E( a, p, l, t, c ) \
    M_E_( a, p, l, (t|XML_TYPE_PROP_TEXT), c )
#define MT_ED( a, p, l, t, c ) \
    M_ED_( a, p, l, (t|XML_TYPE_PROP_TEXT), c )

// paragraph properties
#define MP_E( a, p, l, t, c ) \
    M_E_( a, p, l, (t|XML_TYPE_PROP_PARAGRAPH), c )
#define MP_ED( a, p, l, t, c ) \
    M_ED_( a, p, l, (t|XML_TYPE_PROP_PARAGRAPH), c )

// graphic properties
#define MG_E( a, p, l, t, c ) \
    M_E_( a, p, l, (t|XML_TYPE_PROP_GRAPHIC), c )
#define MG_ED( a, p, l, t, c ) \
    M_ED_( a, p, l, (t|XML_TYPE_PROP_GRAPHIC), c )
#define MG_EV( a, p, l, t, c, v ) \
    M_EV_( a, p, l, (t|XML_TYPE_PROP_GRAPHIC), c, v )

// section properties
#define MS_E( a, p, l, t, c ) \
    M_E_( a, p, l, (t|XML_TYPE_PROP_SECTION), c )

// ruby properties
#define MR_E( a, p, l, t, c ) \
    M_E_( a, p, l, (t|XML_TYPE_PROP_RUBY), c )
#define MR_EV( a, p, l, t, c, v ) \
    M_EV_( a, p, l, (t|XML_TYPE_PROP_RUBY), c, v )

// cell properties
#define MC_E( a, p, l, t, c ) \
    M_E_( a, p, l, (t|XML_TYPE_PROP_TABLE_CELL), c )

#define MAP_ODF13(name,prefix,token,type,context)  { name, prefix, token, type, context, SvtSaveOptions::ODFSVER_013, false }

// extensions import/export
#define MAP_EXT(name,prefix,token,type,context)  { name, prefix, token, type, context, SvtSaveOptions::ODFSVER_FUTURE_EXTENDED, false }
// extensions import only
#define MAP_EXT_I(name,prefix,token,type,context)  { name, prefix, token, type, context, SvtSaveOptions::ODFSVER_FUTURE_EXTENDED, true }

#define M_END() { nullptr }

#define MAP_(name,prefix,token,type,context)  { name, prefix, token, type, context, SvtSaveOptions::ODFSVER_010, false }
#define GMAP(name,prefix,token,type,context) MAP_(name,prefix,token,static_cast<sal_Int32>(type|XML_TYPE_PROP_GRAPHIC),context)

XMLPropertyMapEntry constexpr aXMLParaPropMap[] =
{
    // RES_UNKNOWNATR_CONTAINER
    MP_E( PROP_ParaUserDefinedAttributes,      XML_NAMESPACE_TEXT, XML_XMLNS, XML_TYPE_ATTRIBUTE_CONTAINER | MID_FLAG_SPECIAL_ITEM, 0 ),

    // fill attributes for paragraph backgrounds
    // #i125045# moved to the front to be able to exclude these in lcl_txtprmap_getMap
    // for TextPropMap::SHAPE_PARA to not have these double for Shapes (which already have these)
    GMAP( PROP_FillStyle,                      XML_NAMESPACE_DRAW, XML_FILL,                   XML_SW_TYPE_FILLSTYLE, 0 ),
    GMAP( PROP_FillColor,                      XML_NAMESPACE_DRAW, XML_FILL_COLOR,             XML_TYPE_COLOR, 0 ),
    GMAP( PROP_FillColor2,                     XML_NAMESPACE_DRAW, XML_SECONDARY_FILL_COLOR,   XML_TYPE_COLOR, 0 ),
    GMAP( PROP_FillGradientName,               XML_NAMESPACE_DRAW, XML_FILL_GRADIENT_NAME,     XML_TYPE_STYLENAME|MID_FLAG_NO_PROPERTY_IMPORT, CTF_FILLGRADIENTNAME ),
    GMAP( PROP_FillGradientStepCount,          XML_NAMESPACE_DRAW, XML_GRADIENT_STEP_COUNT,    XML_TYPE_NUMBER16, 0 ),
    GMAP( PROP_FillHatchName,                  XML_NAMESPACE_DRAW, XML_FILL_HATCH_NAME,        XML_TYPE_STYLENAME|MID_FLAG_NO_PROPERTY_IMPORT, CTF_FILLHATCHNAME ),
    GMAP( PROP_FillBackground,                 XML_NAMESPACE_DRAW, XML_FILL_HATCH_SOLID,       XML_TYPE_BOOL, 0 ),
    GMAP( PROP_FillBitmapName,                 XML_NAMESPACE_DRAW, XML_FILL_IMAGE_NAME,        XML_TYPE_STYLENAME|MID_FLAG_NO_PROPERTY_IMPORT, CTF_FILLBITMAPNAME ),
    GMAP( PROP_FillTransparence,               XML_NAMESPACE_DRAW, XML_OPACITY,                XML_TYPE_NEG_PERCENT16|MID_FLAG_MULTI_PROPERTY, 0 ),    // exists in SW, too
    GMAP( PROP_FillTransparenceGradientName,   XML_NAMESPACE_DRAW, XML_OPACITY_NAME,           XML_TYPE_STYLENAME|MID_FLAG_NO_PROPERTY_IMPORT, CTF_FILLTRANSNAME ),
    GMAP( PROP_FillBitmapSizeX,                XML_NAMESPACE_DRAW, XML_FILL_IMAGE_WIDTH,       XML_SW_TYPE_FILLBITMAPSIZE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapLogicalSize,          XML_NAMESPACE_DRAW, XML_FILL_IMAGE_WIDTH,       XML_SW_TYPE_LOGICAL_SIZE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapSizeY,                XML_NAMESPACE_DRAW, XML_FILL_IMAGE_HEIGHT,      XML_SW_TYPE_FILLBITMAPSIZE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapLogicalSize,          XML_NAMESPACE_DRAW, XML_FILL_IMAGE_HEIGHT,      XML_SW_TYPE_LOGICAL_SIZE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapMode,                 XML_NAMESPACE_STYLE,XML_REPEAT,                 XML_SW_TYPE_BITMAP_MODE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapPositionOffsetX,      XML_NAMESPACE_DRAW, XML_FILL_IMAGE_REF_POINT_X, XML_TYPE_PERCENT, 0 ),
    GMAP( PROP_FillBitmapPositionOffsetY,      XML_NAMESPACE_DRAW, XML_FILL_IMAGE_REF_POINT_Y, XML_TYPE_PERCENT, 0 ),
    GMAP( PROP_FillBitmapRectanglePoint,       XML_NAMESPACE_DRAW, XML_FILL_IMAGE_REF_POINT,   XML_SW_TYPE_BITMAP_REFPOINT, 0 ),
    GMAP( PROP_FillBitmapOffsetX,              XML_NAMESPACE_DRAW, XML_TILE_REPEAT_OFFSET,     XML_SW_TYPE_BITMAPREPOFFSETX|MID_FLAG_MULTI_PROPERTY, CTF_REPEAT_OFFSET_X ),
    GMAP( PROP_FillBitmapOffsetY,              XML_NAMESPACE_DRAW, XML_TILE_REPEAT_OFFSET,     XML_SW_TYPE_BITMAPREPOFFSETY|MID_FLAG_MULTI_PROPERTY, CTF_REPEAT_OFFSET_Y ),

    // RES_LR_SPACE
    // !!! DO NOT REORDER THE MARGINS !!!
    // - The all margin implementation enumerates the margin properties by relative index.
    MP_E( PROP_ParaLeftMargin,          XML_NAMESPACE_FO, XML_MARGIN,       XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_PARAMARGINALL ),
    MP_E( PROP_ParaLeftMarginRelative,  XML_NAMESPACE_FO, XML_MARGIN,       XML_TYPE_PERCENT16, CTF_PARAMARGINALL_REL ),
    MP_E( PROP_ParaLeftMargin,          XML_NAMESPACE_FO, XML_MARGIN_LEFT,  XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_PARALEFTMARGIN ),
    MP_E( PROP_ParaLeftMarginRelative,  XML_NAMESPACE_FO, XML_MARGIN_LEFT,  XML_TYPE_PERCENT16, CTF_PARALEFTMARGIN_REL ),
    MP_E( PROP_ParaRightMargin,         XML_NAMESPACE_FO, XML_MARGIN_RIGHT, XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_PARARIGHTMARGIN ),
    MP_E( PROP_ParaRightMarginRelative, XML_NAMESPACE_FO, XML_MARGIN_RIGHT, XML_TYPE_PERCENT16, CTF_PARARIGHTMARGIN_REL ),
    // RES_UL_SPACE
    MP_E( PROP_ParaTopMargin,            XML_NAMESPACE_FO,    XML_MARGIN_TOP,         XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_PARATOPMARGIN ),
    MP_E( PROP_ParaTopMarginRelative,    XML_NAMESPACE_FO,    XML_MARGIN_TOP,         XML_TYPE_PERCENT16, CTF_PARATOPMARGIN_REL ),
    MP_E( PROP_ParaBottomMargin,         XML_NAMESPACE_FO,    XML_MARGIN_BOTTOM,      XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_PARABOTTOMMARGIN ),
    MP_E( PROP_ParaBottomMarginRelative, XML_NAMESPACE_FO,    XML_MARGIN_BOTTOM,      XML_TYPE_PERCENT16, CTF_PARABOTTOMMARGIN_REL ),
    MAP_ODF13( PROP_ParaContextMargin,   XML_NAMESPACE_STYLE, XML_CONTEXTUAL_SPACING, XML_TYPE_BOOL|XML_TYPE_PROP_PARAGRAPH, 0 ),    // ODF 1.3 OFFICE-3767 and was written by LO<=4.2
    MAP_ODF13( PROP_ParaContextMargin,   XML_NAMESPACE_LO_EXT, XML_CONTEXTUAL_SPACING, XML_TYPE_BOOL|XML_TYPE_PROP_PARAGRAPH, 0 ),     // extension namespace
    // RES_CHRATR_CASEMAP
    MT_E( PROP_CharCaseMap, XML_NAMESPACE_FO, XML_FONT_VARIANT,   XML_TYPE_TEXT_CASEMAP_VAR, 0 ),
    MT_E( PROP_CharCaseMap, XML_NAMESPACE_FO, XML_TEXT_TRANSFORM, XML_TYPE_TEXT_CASEMAP,     0 ),
    // RES_CHRATR_COLOR
    MT_ED( PROP_CharColor,            XML_NAMESPACE_FO,     XML_COLOR,                 XML_TYPE_COLORAUTO|MID_FLAG_MERGE_PROPERTY,   0 ),
    MT_ED( PROP_CharColor,            XML_NAMESPACE_STYLE,  XML_USE_WINDOW_FONT_COLOR, XML_TYPE_ISAUTOCOLOR|MID_FLAG_MERGE_PROPERTY, 0 ),
    MAP_EXT_I( PROP_CharTransparence, XML_NAMESPACE_DRAW,   XML_OPACITY,               XML_TYPE_NEG_PERCENT16 | XML_TYPE_PROP_TEXT,  0 ),
    MAP_EXT( PROP_CharTransparence,   XML_NAMESPACE_LO_EXT, XML_OPACITY,               XML_TYPE_NEG_PERCENT16 | XML_TYPE_PROP_TEXT,  0 ),
    MAP_EXT( PROP_CharComplexColor,   XML_NAMESPACE_LO_EXT, XML_CHAR_COMPLEX_COLOR,    XML_TYPE_COMPLEX_COLOR|XML_TYPE_PROP_TEXT|MID_FLAG_ELEMENT_ITEM, CTF_COMPLEX_COLOR ),
    // RES_CHRATR_CONTOUR
    MT_E( PROP_CharContoured, XML_NAMESPACE_STYLE, XML_TEXT_OUTLINE, XML_TYPE_BOOL, 0 ),
    // RES_CHRATR_CROSSEDOUT
    MT_E( PROP_CharStrikeout, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_STYLE, XML_TYPE_TEXT_CROSSEDOUT_STYLE|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_E( PROP_CharStrikeout, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_TYPE,  XML_TYPE_TEXT_CROSSEDOUT_TYPE|MID_FLAG_MERGE_PROPERTY,  0 ),
    MT_E( PROP_CharStrikeout, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_WIDTH, XML_TYPE_TEXT_CROSSEDOUT_WIDTH|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_E( PROP_CharStrikeout, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_TEXT,  XML_TYPE_TEXT_CROSSEDOUT_TEXT|MID_FLAG_MERGE_PROPERTY,  0 ),
    // RES_CHRATR_ESCAPEMENT
    MT_E( PROP_CharEscapement,       XML_NAMESPACE_STYLE, XML_TEXT_POSITION, XML_TYPE_TEXT_ESCAPEMENT|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MT_E( PROP_CharEscapementHeight, XML_NAMESPACE_STYLE, XML_TEXT_POSITION, XML_TYPE_TEXT_ESCAPEMENT_HEIGHT|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    // RES_CHRATR_FONT
    MT_ED( PROP_CharFontName,      XML_NAMESPACE_STYLE, XML_FONT_NAME,           XML_TYPE_STRING|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTNAME ),
    MT_ED( PROP_CharFontName,      XML_NAMESPACE_FO,    XML_FONT_FAMILY,         XML_TYPE_TEXT_FONTFAMILYNAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTFAMILYNAME ),
    MT_ED( PROP_CharFontStyleName, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME,     XML_TYPE_STRING, CTF_FONTSTYLENAME ),
    MT_ED( PROP_CharFontFamily,    XML_NAMESPACE_STYLE, XML_FONT_FAMILY_GENERIC, XML_TYPE_TEXT_FONTFAMILY, CTF_FONTFAMILY ),
    MT_ED( PROP_CharFontPitch,     XML_NAMESPACE_STYLE, XML_FONT_PITCH,          XML_TYPE_TEXT_FONTPITCH, CTF_FONTPITCH ),
    MT_ED( PROP_CharFontCharSet,   XML_NAMESPACE_STYLE, XML_FONT_CHARSET,        XML_TYPE_TEXT_FONTENCODING, CTF_FONTCHARSET ),
    // RES_CHRATR_FONTSIZE
    MT_ED( PROP_CharHeight,     XML_NAMESPACE_FO,    XML_FONT_SIZE,     XML_TYPE_CHAR_HEIGHT|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT ),
    MT_ED( PROP_CharPropHeight, XML_NAMESPACE_FO,    XML_FONT_SIZE,     XML_TYPE_CHAR_HEIGHT_PROP|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_REL ),
    MT_ED( PROP_CharDiffHeight, XML_NAMESPACE_STYLE, XML_FONT_SIZE_REL, XML_TYPE_CHAR_HEIGHT_DIFF, CTF_CHARHEIGHT_DIFF ),
    // RES_CHRATR_KERNING
    MT_E( PROP_CharKerning, XML_NAMESPACE_FO, XML_LETTER_SPACING,     XML_TYPE_TEXT_KERNING, 0 ),
    // RES_CHRATR_LANGUAGE
    MT_ED( PROP_CharLocale, XML_NAMESPACE_STYLE, XML_RFC_LANGUAGE_TAG, XML_TYPE_CHAR_RFC_LANGUAGE_TAG|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_ED( PROP_CharLocale, XML_NAMESPACE_FO,    XML_LANGUAGE,         XML_TYPE_CHAR_LANGUAGE|MID_FLAG_MERGE_PROPERTY,         0 ),
    MT_ED( PROP_CharLocale, XML_NAMESPACE_FO,    XML_SCRIPT,           XML_TYPE_CHAR_SCRIPT|MID_FLAG_MERGE_PROPERTY,           0 ),
    MT_ED( PROP_CharLocale, XML_NAMESPACE_FO,    XML_COUNTRY,          XML_TYPE_CHAR_COUNTRY|MID_FLAG_MERGE_PROPERTY,          0 ),
    // RES_CHRATR_POSTURE
    MT_E( PROP_CharPosture, XML_NAMESPACE_FO, XML_FONT_STYLE, XML_TYPE_TEXT_POSTURE, 0 ),
    // RES_CHRATR_UNUSED1
    // RES_CHRATR_SHADOWED
    MT_E( PROP_CharShadowed, XML_NAMESPACE_FO, XML_TEXT_SHADOW, XML_TYPE_TEXT_SHADOWED, 0 ),
    // RES_CHRATR_UNDERLINE
    MT_E( PROP_CharUnderline,         XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_STYLE, XML_TYPE_TEXT_UNDERLINE_STYLE|MID_FLAG_MERGE_PROPERTY,  CTF_UNDERLINE ),
    MT_E( PROP_CharUnderline,         XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_TYPE,  XML_TYPE_TEXT_UNDERLINE_TYPE|MID_FLAG_MERGE_PROPERTY,  0 ),
    MT_E( PROP_CharUnderline,         XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_WIDTH, XML_TYPE_TEXT_UNDERLINE_WIDTH|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_E( PROP_CharUnderlineColor,    XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_COLOR, XML_TYPE_TEXT_UNDERLINE_COLOR|MID_FLAG_MULTI_PROPERTY,  CTF_UNDERLINE_COLOR  ),
    MT_E( PROP_CharUnderlineHasColor, XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_COLOR, XML_TYPE_TEXT_UNDERLINE_HASCOLOR|MID_FLAG_MERGE_ATTRIBUTE, CTF_UNDERLINE_HASCOLOR   ),
    // RES_CHRATR_WEIGHT
    MT_E( PROP_CharWeight, XML_NAMESPACE_FO, XML_FONT_WEIGHT, XML_TYPE_TEXT_WEIGHT, 0 ),
    // RES_CHRATR_RSID
    { PROP_Rsid, XML_NAMESPACE_OFFICE_EXT, XML_RSID, XML_TYPE_HEX|XML_TYPE_PROP_TEXT, 0, SvtSaveOptions::ODFSVER_FUTURE_EXTENDED, false },
    // RES_PARATR_RSID
    { PROP_ParRsid, XML_NAMESPACE_OFFICE_EXT, XML_PARRSID, XML_TYPE_HEX|XML_TYPE_PROP_TEXT, 0, SvtSaveOptions::ODFSVER_FUTURE_EXTENDED, false },
    // RES_CHRATR_WORDLINEMODE
    MT_E( PROP_CharWordMode, XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_MODE,    XML_TYPE_TEXT_LINE_MODE|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_E( PROP_CharWordMode, XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_MODE,     XML_TYPE_TEXT_LINE_MODE|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_E( PROP_CharWordMode, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_MODE, XML_TYPE_TEXT_LINE_MODE|MID_FLAG_MERGE_PROPERTY, 0 ),
    // RES_CHRATR_AUTOKERN
    MT_E( PROP_CharAutoKerning, XML_NAMESPACE_STYLE, XML_LETTER_KERNING, XML_TYPE_BOOL, 0 ),
    // RES_CHRATR_BLINK
    MT_E( PROP_CharFlash, XML_NAMESPACE_STYLE, XML_TEXT_BLINKING, XML_TYPE_BOOL, 0 ),
    // RES_CHRATR_NOHYPHEN
    // TODO: only for words, PROP_ParaIsHyphenation is for paragraphs: check them
    // RES_CHRATR_UNUSED2
    // RES_CHRATR_BACKGROUND
    MT_E( PROP_CharBackColor,       XML_NAMESPACE_FO, XML_BACKGROUND_COLOR,      XML_TYPE_COLORTRANSPARENT|MID_FLAG_MULTI_PROPERTY, CTF_CHAR_BACKGROUND ),
    MT_E( PROP_CharBackTransparent, XML_NAMESPACE_FO, XML_BACKGROUND_COLOR,      XML_TYPE_ISTRANSPARENT|MID_FLAG_MERGE_ATTRIBUTE, CTF_CHAR_BACKGROUND_TRANSPARENCY),
    MT_E( PROP_CharBackColor,       XML_NAMESPACE_FO, XML_TEXT_BACKGROUND_COLOR, XML_TYPE_COLOR|MID_FLAG_SPECIAL_ITEM_EXPORT, CTF_OLDTEXTBACKGROUND ),
    // RES_CHRATR_CJK_FONT
    MT_ED( PROP_CharFontNameAsian,      XML_NAMESPACE_STYLE, XML_FONT_NAME_ASIAN,           XML_TYPE_STRING|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTNAME_CJK ),
    MT_ED( PROP_CharFontNameAsian,      XML_NAMESPACE_STYLE, XML_FONT_FAMILY_ASIAN,         XML_TYPE_TEXT_FONTFAMILYNAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTFAMILYNAME_CJK ),
    MT_ED( PROP_CharFontStyleNameAsian, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME_ASIAN,     XML_TYPE_STRING, CTF_FONTSTYLENAME_CJK ),
    MT_ED( PROP_CharFontFamilyAsian,    XML_NAMESPACE_STYLE, XML_FONT_FAMILY_GENERIC_ASIAN, XML_TYPE_TEXT_FONTFAMILY, CTF_FONTFAMILY_CJK ),
    MT_ED( PROP_CharFontPitchAsian,     XML_NAMESPACE_STYLE, XML_FONT_PITCH_ASIAN,          XML_TYPE_TEXT_FONTPITCH, CTF_FONTPITCH_CJK ),
    MT_ED( PROP_CharFontCharSetAsian,   XML_NAMESPACE_STYLE, XML_FONT_CHARSET_ASIAN,        XML_TYPE_TEXT_FONTENCODING, CTF_FONTCHARSET_CJK ),
    // RES_CHRATR_CJK_FONTSIZE
    MT_ED( PROP_CharHeightAsian,     XML_NAMESPACE_STYLE, XML_FONT_SIZE_ASIAN,     XML_TYPE_CHAR_HEIGHT|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_CJK ),
    MT_ED( PROP_CharPropHeightAsian, XML_NAMESPACE_STYLE, XML_FONT_SIZE_ASIAN,     XML_TYPE_CHAR_HEIGHT_PROP|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_REL_CJK ),
    MT_ED( PROP_CharDiffHeightAsian, XML_NAMESPACE_STYLE, XML_FONT_SIZE_REL_ASIAN, XML_TYPE_CHAR_HEIGHT_DIFF, CTF_CHARHEIGHT_DIFF_CJK ),
    // RES_CHRATR_CJK_LANGUAGE
    MT_ED( PROP_CharLocaleAsian, XML_NAMESPACE_STYLE, XML_RFC_LANGUAGE_TAG_ASIAN, XML_TYPE_CHAR_RFC_LANGUAGE_TAG|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_ED( PROP_CharLocaleAsian, XML_NAMESPACE_STYLE, XML_LANGUAGE_ASIAN,         XML_TYPE_CHAR_LANGUAGE|MID_FLAG_MERGE_PROPERTY,         0 ),
    MT_ED( PROP_CharLocaleAsian, XML_NAMESPACE_STYLE, XML_SCRIPT_ASIAN,           XML_TYPE_CHAR_SCRIPT|MID_FLAG_MERGE_PROPERTY,           0 ),
    MT_ED( PROP_CharLocaleAsian, XML_NAMESPACE_STYLE, XML_COUNTRY_ASIAN,          XML_TYPE_CHAR_COUNTRY|MID_FLAG_MERGE_PROPERTY,          0 ),
    // RES_CHRATR_CJK_POSTURE
    MT_E( PROP_CharPostureAsian, XML_NAMESPACE_STYLE, XML_FONT_STYLE_ASIAN, XML_TYPE_TEXT_POSTURE, 0 ),
    // RES_CHRATR_CJK_WEIGHT
    MT_E( PROP_CharWeightAsian, XML_NAMESPACE_STYLE, XML_FONT_WEIGHT_ASIAN, XML_TYPE_TEXT_WEIGHT, 0 ),
    // RES_CHRATR_CTL_FONT
    MT_ED( PROP_CharFontNameComplex,      XML_NAMESPACE_STYLE, XML_FONT_NAME_COMPLEX,           XML_TYPE_STRING|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTNAME_CTL ),
    MT_ED( PROP_CharFontNameComplex,      XML_NAMESPACE_STYLE, XML_FONT_FAMILY_COMPLEX,         XML_TYPE_TEXT_FONTFAMILYNAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTFAMILYNAME_CTL ),
    MT_ED( PROP_CharFontStyleNameComplex, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME_COMPLEX,     XML_TYPE_STRING, CTF_FONTSTYLENAME_CTL ),
    MT_ED( PROP_CharFontFamilyComplex,    XML_NAMESPACE_STYLE, XML_FONT_FAMILY_GENERIC_COMPLEX, XML_TYPE_TEXT_FONTFAMILY, CTF_FONTFAMILY_CTL ),
    MT_ED( PROP_CharFontPitchComplex,     XML_NAMESPACE_STYLE, XML_FONT_PITCH_COMPLEX,          XML_TYPE_TEXT_FONTPITCH, CTF_FONTPITCH_CTL ),
    MT_ED( PROP_CharFontCharSetComplex,   XML_NAMESPACE_STYLE, XML_FONT_CHARSET_COMPLEX,        XML_TYPE_TEXT_FONTENCODING, CTF_FONTCHARSET_CTL ),
    // RES_CHRATR_CTL_FONTSIZE
    MT_ED( PROP_CharHeightComplex,     XML_NAMESPACE_STYLE, XML_FONT_SIZE_COMPLEX,     XML_TYPE_CHAR_HEIGHT|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_CTL ),
    MT_ED( PROP_CharPropHeightComplex, XML_NAMESPACE_STYLE, XML_FONT_SIZE_COMPLEX,     XML_TYPE_CHAR_HEIGHT_PROP|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_REL_CTL ),
    MT_ED( PROP_CharDiffHeightComplex, XML_NAMESPACE_STYLE, XML_FONT_SIZE_REL_COMPLEX, XML_TYPE_CHAR_HEIGHT_DIFF, CTF_CHARHEIGHT_DIFF_CTL ),
    // RES_CHRATR_CTL_LANGUAGE
    MT_ED( PROP_CharLocaleComplex, XML_NAMESPACE_STYLE, XML_RFC_LANGUAGE_TAG_COMPLEX, XML_TYPE_CHAR_RFC_LANGUAGE_TAG|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_ED( PROP_CharLocaleComplex, XML_NAMESPACE_STYLE, XML_LANGUAGE_COMPLEX,         XML_TYPE_CHAR_LANGUAGE|MID_FLAG_MERGE_PROPERTY,         0 ),
    MT_ED( PROP_CharLocaleComplex, XML_NAMESPACE_STYLE, XML_SCRIPT_COMPLEX,           XML_TYPE_CHAR_SCRIPT|MID_FLAG_MERGE_PROPERTY,           0 ),
    MT_ED( PROP_CharLocaleComplex, XML_NAMESPACE_STYLE, XML_COUNTRY_COMPLEX,          XML_TYPE_CHAR_COUNTRY|MID_FLAG_MERGE_PROPERTY,          0 ),
    // RES_CHRATR_CTL_POSTURE
    MT_E( PROP_CharPostureComplex, XML_NAMESPACE_STYLE, XML_FONT_STYLE_COMPLEX, XML_TYPE_TEXT_POSTURE, 0 ),
    // RES_CHRATR_CTL_WEIGHT
    MT_E( PROP_CharWeightComplex, XML_NAMESPACE_STYLE, XML_FONT_WEIGHT_COMPLEX, XML_TYPE_TEXT_WEIGHT, 0 ),
    // RES_CHRATR_ROTATE
    MT_E( PROP_CharRotation,            XML_NAMESPACE_STYLE, XML_TEXT_ROTATION_ANGLE, XML_TYPE_TEXT_ROTATION_ANGLE, 0 ),
    MT_E( PROP_CharRotationIsFitToLine, XML_NAMESPACE_STYLE, XML_TEXT_ROTATION_SCALE, XML_TYPE_TEXT_ROTATION_SCALE, 0 ),
    // RES_CHRATR_EMPHASIS_MARK
    MT_E( PROP_CharEmphasis, XML_NAMESPACE_STYLE, XML_TEXT_EMPHASIZE, XML_TYPE_TEXT_EMPHASIZE, 0 ),
    // RES_CHRATR_TWO_LINES
    MT_E( PROP_CharCombineIsOn,   XML_NAMESPACE_STYLE, XML_TEXT_COMBINE,            XML_TYPE_TEXT_COMBINE, 0 ),
    MT_E( PROP_CharCombinePrefix, XML_NAMESPACE_STYLE, XML_TEXT_COMBINE_START_CHAR, XML_TYPE_TEXT_COMBINECHAR, 0 ),
    MT_E( PROP_CharCombineSuffix, XML_NAMESPACE_STYLE, XML_TEXT_COMBINE_END_CHAR,   XML_TYPE_TEXT_COMBINECHAR, 0 ),
    // RES_CHRATR_SCALEW
    MT_E( PROP_CharScaleWidth, XML_NAMESPACE_STYLE, XML_TEXT_SCALE, XML_TYPE_PERCENT16, 0 ),
    //RES_CHRATR_RELIEF
    MT_E( PROP_CharRelief, XML_NAMESPACE_STYLE, XML_FONT_RELIEF, XML_TYPE_TEXT_FONT_RELIEF, 0 ),
    // RES_CHRATR_HIDDEN
    MT_E( PROP_CharHidden, XML_NAMESPACE_TEXT, XML_DISPLAY, XML_TYPE_TEXT_HIDDEN_AS_DISPLAY|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_TEXT_DISPLAY ),
    // RES_CHRATR_OVERLINE
    MT_E( PROP_CharOverline,         XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_STYLE, XML_TYPE_TEXT_OVERLINE_STYLE|MID_FLAG_MERGE_PROPERTY,     0 ),
    MT_E( PROP_CharOverline,         XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_TYPE,  XML_TYPE_TEXT_OVERLINE_TYPE|MID_FLAG_MERGE_PROPERTY,      0 ),
    MT_E( PROP_CharOverline,         XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_WIDTH, XML_TYPE_TEXT_OVERLINE_WIDTH|MID_FLAG_MERGE_PROPERTY,     0 ),
    MT_E( PROP_CharOverlineColor,    XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_COLOR, XML_TYPE_TEXT_OVERLINE_COLOR|MID_FLAG_MULTI_PROPERTY,     0 ),
    MT_E( PROP_CharOverlineHasColor, XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_COLOR, XML_TYPE_TEXT_OVERLINE_HASCOLOR|MID_FLAG_MERGE_ATTRIBUTE, 0 ),
    // RES_CHRATR_BOX
    MAP_EXT( PROP_CharLeftBorder,     XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH,        XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDERWIDTH ),
    MAP_EXT( PROP_CharLeftBorder,     XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH_LEFT,   XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDERWIDTH ),
    MAP_EXT( PROP_CharRightBorder,    XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH_RIGHT,  XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDERWIDTH ),
    MAP_EXT( PROP_CharTopBorder,      XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH_TOP,    XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDERWIDTH ),
    MAP_EXT( PROP_CharBottomBorder,   XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH_BOTTOM, XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDERWIDTH ),
    MAP_EXT_I( PROP_CharLeftBorder,   XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH,        XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDERWIDTH ),
    MAP_EXT_I( PROP_CharLeftBorder,   XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH_LEFT,   XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDERWIDTH ),
    MAP_EXT_I( PROP_CharRightBorder,  XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH_RIGHT,  XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDERWIDTH ),
    MAP_EXT_I( PROP_CharTopBorder,    XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH_TOP,    XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDERWIDTH ),
    MAP_EXT_I( PROP_CharBottomBorder, XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH_BOTTOM, XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDERWIDTH ),

    MAP_EXT( PROP_CharLeftBorderDistance,     XML_NAMESPACE_LO_EXT, XML_PADDING,        XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDERDISTANCE ),
    MAP_EXT( PROP_CharLeftBorderDistance,     XML_NAMESPACE_LO_EXT, XML_PADDING_LEFT,   XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDERDISTANCE ),
    MAP_EXT( PROP_CharRightBorderDistance,    XML_NAMESPACE_LO_EXT, XML_PADDING_RIGHT,  XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDERDISTANCE ),
    MAP_EXT( PROP_CharTopBorderDistance,      XML_NAMESPACE_LO_EXT, XML_PADDING_TOP,    XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDERDISTANCE ),
    MAP_EXT( PROP_CharBottomBorderDistance,   XML_NAMESPACE_LO_EXT, XML_PADDING_BOTTOM, XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharLeftBorderDistance,   XML_NAMESPACE_FO, XML_PADDING,        XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharLeftBorderDistance,   XML_NAMESPACE_FO, XML_PADDING_LEFT,   XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharRightBorderDistance,  XML_NAMESPACE_FO, XML_PADDING_RIGHT,  XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharTopBorderDistance,    XML_NAMESPACE_FO, XML_PADDING_TOP,    XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharBottomBorderDistance, XML_NAMESPACE_FO, XML_PADDING_BOTTOM, XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDERDISTANCE ),

    MAP_EXT( PROP_CharLeftBorder,     XML_NAMESPACE_LO_EXT, XML_BORDER,        XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDER ),
    MAP_EXT( PROP_CharLeftBorder,     XML_NAMESPACE_LO_EXT, XML_BORDER_LEFT,   XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDER ),
    MAP_EXT( PROP_CharRightBorder,    XML_NAMESPACE_LO_EXT, XML_BORDER_RIGHT,  XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDER ),
    MAP_EXT( PROP_CharTopBorder,      XML_NAMESPACE_LO_EXT, XML_BORDER_TOP,    XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDER ),
    MAP_EXT( PROP_CharBottomBorder,   XML_NAMESPACE_LO_EXT, XML_BORDER_BOTTOM, XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDER ),
    MAP_EXT_I( PROP_CharLeftBorder,   XML_NAMESPACE_FO,     XML_BORDER,        XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDER ),
    MAP_EXT_I( PROP_CharLeftBorder,   XML_NAMESPACE_FO,     XML_BORDER_LEFT,   XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDER ),
    MAP_EXT_I( PROP_CharRightBorder,  XML_NAMESPACE_FO,     XML_BORDER_RIGHT,  XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDER ),
    MAP_EXT_I( PROP_CharTopBorder,    XML_NAMESPACE_FO,     XML_BORDER_TOP,    XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDER ),
    MAP_EXT_I( PROP_CharBottomBorder, XML_NAMESPACE_FO,     XML_BORDER_BOTTOM, XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDER ),
    // RES_CHRATR_SHADOW
    MAP_EXT( PROP_CharShadowFormat,   XML_NAMESPACE_LO_EXT, XML_SHADOW, XML_TYPE_TEXT_SHADOW|XML_TYPE_PROP_TEXT, 0 ),
    MAP_EXT_I( PROP_CharShadowFormat, XML_NAMESPACE_STYLE,  XML_SHADOW, XML_TYPE_TEXT_SHADOW|XML_TYPE_PROP_TEXT, 0 ),
    // RES_CHRATR_HIGHLIGHT
    MT_E( PROP_CharHighlight, XML_NAMESPACE_FO, XML_BACKGROUND_COLOR, XML_TYPE_COLORTRANSPARENT|MID_FLAG_MULTI_PROPERTY| MID_FLAG_NO_PROPERTY_IMPORT, CTF_CHAR_HIGHLIGHT ),
    // RES_TXTATR_INETFMT
    // TODO
    // RES_TXTATR_REFMARK
    // TODO
    // RES_TXTATR_TOXMARK
    // TODO
    // RES_TXTATR_CHARFMT
//  M_E_SI( TEXT,   style_name,         RES_TXTATR_CHARFMT, 0 ),
    // RES_TXTATR_CJK_RUBY
    // TODO
    // RES_TXTATR_FIELD
    // TODO
    // RES_TXTATR_FLYCNT
    // TODO
    // RES_TXTATR_FTN
    // TODO
    // RES_TXTATR_SOFTHYPH
    // TODO
    // RES_TXTATR_HARDBLANK
    // TODO

    // RES_PARATR_LINESPACING
    MP_E( PROP_ParaLineSpacing, XML_NAMESPACE_FO,    XML_LINE_HEIGHT,          XML_TYPE_LINE_SPACE_FIXED,    0 ),
    MP_E( PROP_ParaLineSpacing, XML_NAMESPACE_STYLE, XML_LINE_HEIGHT_AT_LEAST, XML_TYPE_LINE_SPACE_MINIMUM,  0 ),
    MP_E( PROP_ParaLineSpacing, XML_NAMESPACE_STYLE, XML_LINE_SPACING,         XML_TYPE_LINE_SPACE_DISTANCE, 0 ),
    // RES_PARATR_ADJUST
    MP_E( PROP_ParaAdjust,           XML_NAMESPACE_FO,    XML_TEXT_ALIGN,          XML_TYPE_TEXT_ADJUST,     CTF_SD_SHAPE_PARA_ADJUST ),
    MP_E( PROP_ParaLastLineAdjust,   XML_NAMESPACE_FO,    XML_TEXT_ALIGN_LAST,     XML_TYPE_TEXT_ADJUSTLAST, CTF_PARA_ADJUSTLAST ),
    MP_E( PROP_ParaExpandSingleWord, XML_NAMESPACE_STYLE, XML_JUSTIFY_SINGLE_WORD, XML_TYPE_BOOL,            0 ),
    // RES_PARATR_SPLIT
    MP_E( PROP_ParaSplit, XML_NAMESPACE_FO, XML_KEEP_TOGETHER, XML_TYPE_TEXT_SPLIT, 0 ),
    // RES_PARATR_ORPHANS
    MP_E( PROP_ParaOrphans, XML_NAMESPACE_FO, XML_ORPHANS, XML_TYPE_NUMBER8, 0 ),
    // RES_PARATR_WIDOWS
    MP_E( PROP_ParaWidows, XML_NAMESPACE_FO, XML_WIDOWS, XML_TYPE_NUMBER8, 0 ),
    // RES_PARATR_TABSTOP
    MP_ED( PROP_ParaTabStops, XML_NAMESPACE_STYLE, XML_TAB_STOPS, MID_FLAG_ELEMENT_ITEM|XML_TYPE_TEXT_TABSTOP, CTF_TABSTOP ), // this is not really a string!
    // RES_PARATR_HYPHENZONE
    MT_E( PROP_ParaIsHyphenation,               XML_NAMESPACE_FO,     XML_HYPHENATE,                     XML_TYPE_BOOL,                             0 ),
    MT_E( PROP_ParaHyphenationMaxLeadingChars,  XML_NAMESPACE_FO,     XML_HYPHENATION_REMAIN_CHAR_COUNT, XML_TYPE_NUMBER16_NO_ZERO,                 0 ),
    MT_E( PROP_ParaHyphenationMaxTrailingChars, XML_NAMESPACE_FO,     XML_HYPHENATION_PUSH_CHAR_COUNT,   XML_TYPE_NUMBER16_NO_ZERO,                 0 ),
    MP_E( PROP_ParaHyphenationMaxHyphens,       XML_NAMESPACE_FO,     XML_HYPHENATION_LADDER_COUNT,      XML_TYPE_NUMBER16_NONE,                    0 ),
    MAP_EXT( PROP_ParaHyphenationNoCaps,        XML_NAMESPACE_LO_EXT, XML_HYPHENATION_NO_CAPS,           XML_TYPE_BOOL|XML_TYPE_PROP_TEXT,          0 ),
    MAP_EXT( PROP_ParaHyphenationNoLastWord,    XML_NAMESPACE_LO_EXT, XML_HYPHENATION_NO_LAST_WORD,      XML_TYPE_BOOL|XML_TYPE_PROP_TEXT,          0 ),
    MAP_EXT( PROP_ParaHyphenationMinWordLength, XML_NAMESPACE_LO_EXT, XML_HYPHENATION_WORD_CHAR_COUNT,   XML_TYPE_NUMBER16_NONE|XML_TYPE_PROP_TEXT, 0 ),
    MAP_EXT( PROP_ParaHyphenationZone,          XML_NAMESPACE_LO_EXT, XML_HYPHENATION_ZONE,              XML_TYPE_NUMBER16_NONE|XML_TYPE_PROP_TEXT, 0 ),
    MAP_EXT( PROP_ParaHyphenationCompoundMinLeadingChars, XML_NAMESPACE_LO_EXT, XML_HYPHENATION_COMPOUND_REMAIN_CHAR_COUNT, XML_TYPE_NUMBER16_NO_ZERO|XML_TYPE_PROP_TEXT,  0 ),
    MP_E( PROP_ParaHyphenationKeep,             XML_NAMESPACE_FO,     XML_HYPHENATION_KEEP,              XML_TYPE_HYPHENATION_KEEP,                 0 ),
    MAP_EXT( PROP_ParaHyphenationKeepType,      XML_NAMESPACE_LO_EXT, XML_HYPHENATION_KEEP_TYPE,         XML_TYPE_HYPHENATION_KEEP_TYPE|XML_TYPE_PROP_PARAGRAPH,           0 ),
    // RES_PARATR_DROP
    MP_E( PROP_DropCapWholeWord,     XML_NAMESPACE_STYLE, XML_LENGTH,     MID_FLAG_SPECIAL_ITEM|XML_TYPE_BOOL,         CTF_DROPCAPWHOLEWORD ),
    MP_E( PROP_DropCapCharStyleName, XML_NAMESPACE_STYLE, XML_STYLE_NAME, MID_FLAG_SPECIAL_ITEM|XML_TYPE_STRING,       CTF_DROPCAPCHARSTYLE ),
    MP_E( PROP_DropCapFormat,        XML_NAMESPACE_STYLE, XML_DROP_CAP,   MID_FLAG_ELEMENT_ITEM|XML_TYPE_TEXT_DROPCAP, CTF_DROPCAPFORMAT ),
    // RES_PARATR_REGISTER
    MP_E( PROP_ParaRegisterModeActive, XML_NAMESPACE_STYLE, XML_REGISTER_TRUE, XML_TYPE_BOOL, 0 ),
    // RES_PARATR_NUMRULE
    MP_E( PROP_NumberingStyleName, XML_NAMESPACE_STYLE, XML_LIST_STYLE_NAME, MID_FLAG_SPECIAL_ITEM|XML_TYPE_STYLENAME, CTF_NUMBERINGSTYLENAME ),

    // RES_FILL_ORDER
    // not required
    // RES_FRM_SIZE
    // not required
    // RES_PAPER_BIN
    // not required
    // RES_LR_SPACE

    MP_E( PROP_ParaFirstLineIndent,         XML_NAMESPACE_FO,    XML_TEXT_INDENT,      XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_PARAFIRSTLINE ),
    MP_E( PROP_ParaFirstLineIndentRelative, XML_NAMESPACE_FO,    XML_TEXT_INDENT,      XML_TYPE_PERCENT,                         CTF_PARAFIRSTLINE_REL ),
    MP_E( PROP_ParaIsAutoFirstLineIndent,   XML_NAMESPACE_STYLE, XML_AUTO_TEXT_INDENT, XML_TYPE_BOOL,                            0 ),
    // RES_PAGEDESC
    MP_E( PROP_PageDescName,     XML_NAMESPACE_STYLE, XML_MASTER_PAGE_NAME, MID_FLAG_SPECIAL_ITEM|XML_TYPE_STYLENAME,            CTF_PAGEDESCNAME ),
    MP_E( PROP_PageNumberOffset, XML_NAMESPACE_STYLE, XML_PAGE_NUMBER,      XML_TYPE_NUMBER16_AUTO|MID_FLAG_SPECIAL_ITEM_EXPORT, CTF_PAGENUMBEROFFSET ),
    // RES_BREAK : TODO: does this work?
    MP_E( PROP_BreakType, XML_NAMESPACE_FO, XML_BREAK_BEFORE, XML_TYPE_TEXT_BREAKBEFORE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MP_E( PROP_BreakType, XML_NAMESPACE_FO, XML_BREAK_AFTER,  XML_TYPE_TEXT_BREAKAFTER,                          0 ),
    // RES_CNTNT
    // not required
    // RES_HEADER
    // not required
    // RES_FOOTER
    // not required
    // RES_PRINT
    // not required
    // RES_OPAQUE
    // not required
    // RES_PROTECT
    // not required
    // RES_SURROUND
    // not required
    // RES_VERT_ORIENT
    // not required
    // RES_HORI_ORIENT
    // not required
    // RES_ANCHOR
    // not required
    // RES_BACKGROUND
    // DO NOT REORDER these!
    MP_E( PROP_ParaBackColor,           XML_NAMESPACE_FO,    XML_BACKGROUND_COLOR, XML_TYPE_COLORTRANSPARENT|MID_FLAG_MULTI_PROPERTY, 0 ),
    MP_E( PROP_ParaBackTransparent,     XML_NAMESPACE_FO,    XML_BACKGROUND_COLOR, XML_TYPE_ISTRANSPARENT|MID_FLAG_MERGE_ATTRIBUTE,   0 ),
    MP_E( PROP_ParaBackGraphicLocation, XML_NAMESPACE_STYLE, XML_POSITION,         MID_FLAG_SPECIAL_ITEM|XML_TYPE_BUILDIN_CMP_ONLY,   CTF_BACKGROUND_POS  ),
    MP_E( PROP_ParaBackGraphicFilter,   XML_NAMESPACE_STYLE, XML_FILTER_NAME,      MID_FLAG_SPECIAL_ITEM|XML_TYPE_STRING,          CTF_BACKGROUND_FILTER ),
    MP_E( PROP_ParaBackGraphic,         XML_NAMESPACE_STYLE, XML_BACKGROUND_IMAGE, MID_FLAG_ELEMENT_ITEM|XML_TYPE_GRAPHIC, CTF_BACKGROUND_URL ),

    // RES_BOX
    MP_E( PROP_LeftBorder,   XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH,        XML_TYPE_BORDER_WIDTH, CTF_ALLBORDERWIDTH ),
    MP_E( PROP_LeftBorder,   XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH_LEFT,   XML_TYPE_BORDER_WIDTH, CTF_LEFTBORDERWIDTH ),
    MP_E( PROP_RightBorder,  XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH_RIGHT,  XML_TYPE_BORDER_WIDTH, CTF_RIGHTBORDERWIDTH ),
    MP_E( PROP_TopBorder,    XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH_TOP,    XML_TYPE_BORDER_WIDTH, CTF_TOPBORDERWIDTH ),
    MP_E( PROP_BottomBorder, XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH_BOTTOM, XML_TYPE_BORDER_WIDTH, CTF_BOTTOMBORDERWIDTH ),

    MP_E( PROP_LeftBorderDistance,   XML_NAMESPACE_FO, XML_PADDING,        XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_ALLBORDERDISTANCE ), // need special import filtering
    MP_E( PROP_LeftBorderDistance,   XML_NAMESPACE_FO, XML_PADDING_LEFT,   XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_LEFTBORDERDISTANCE ),
    MP_E( PROP_RightBorderDistance,  XML_NAMESPACE_FO, XML_PADDING_RIGHT,  XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_RIGHTBORDERDISTANCE ),
    MP_E( PROP_TopBorderDistance,    XML_NAMESPACE_FO, XML_PADDING_TOP,    XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_TOPBORDERDISTANCE ),
    MP_E( PROP_BottomBorderDistance, XML_NAMESPACE_FO, XML_PADDING_BOTTOM, XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_BOTTOMBORDERDISTANCE ),

    MP_E( PROP_LeftBorder,   XML_NAMESPACE_FO, XML_BORDER,        XML_TYPE_BORDER, CTF_ALLBORDER ),
    MP_E( PROP_LeftBorder,   XML_NAMESPACE_FO, XML_BORDER_LEFT,   XML_TYPE_BORDER, CTF_LEFTBORDER ),
    MP_E( PROP_RightBorder,  XML_NAMESPACE_FO, XML_BORDER_RIGHT,  XML_TYPE_BORDER, CTF_RIGHTBORDER ),
    MP_E( PROP_TopBorder,    XML_NAMESPACE_FO, XML_BORDER_TOP,    XML_TYPE_BORDER, CTF_TOPBORDER ),
    MP_E( PROP_BottomBorder, XML_NAMESPACE_FO, XML_BORDER_BOTTOM, XML_TYPE_BORDER, CTF_BOTTOMBORDER ),
    // RES_SHADOW
    MP_E( PROP_ParaShadowFormat, XML_NAMESPACE_STYLE, XML_SHADOW, XML_TYPE_TEXT_SHADOW, 0 ),
    // RES_FRMMACRO
    // not required
    // RES_COL
    // not required
    // RES_KEEP
    MP_E( PROP_ParaKeepTogether, XML_NAMESPACE_FO, XML_KEEP_WITH_NEXT, XML_TYPE_TEXT_KEEP, 0 ),
    // RES_URL
    // not required
    // RES_EDIT_IN_READONLY
    // not required
    // RES_LAYOUT_SPLIT
    // not required
    // RES_CHAIN
    // not required

    // RES_LINENUMBER
    MP_E( PROP_ParaLineNumberCount,      XML_NAMESPACE_TEXT, XML_NUMBER_LINES, XML_TYPE_BOOL,   0 ),
    MP_E( PROP_ParaLineNumberStartValue, XML_NAMESPACE_TEXT, XML_LINE_NUMBER,  XML_TYPE_NUMBER, 0 ),

    // RES_FTN_AT_TXTEND
    // not required
    // RES_END_AT_TXTEND
    // not required
    MP_ED( PROP_ParaIsCharacterDistance,        XML_NAMESPACE_STYLE,  XML_TEXT_AUTOSPACE,    XML_TYPE_TEXT_AUTOSPACE,                  0 ),
    MP_ED( PROP_ParaIsHangingPunctuation,       XML_NAMESPACE_STYLE,  XML_PUNCTUATION_WRAP,  XML_TYPE_TEXT_PUNCTUATION_WRAP,           0 ),
    MP_ED( PROP_ParaIsForbiddenRules,           XML_NAMESPACE_STYLE,  XML_LINE_BREAK,        XML_TYPE_TEXT_LINE_BREAK,                 0 ),
    MP_E( PROP_TabStopDistance,                 XML_NAMESPACE_STYLE,  XML_TAB_STOP_DISTANCE, XML_TYPE_MEASURE,                         0 ),
    MAP_EXT_I( PROP_ParaTabStopDefaultDistance, XML_NAMESPACE_STYLE,  XML_TAB_STOP_DISTANCE, XML_TYPE_MEASURE|XML_TYPE_PROP_PARAGRAPH, 0 ),
    MAP_EXT( PROP_ParaTabStopDefaultDistance,   XML_NAMESPACE_LO_EXT, XML_TAB_STOP_DISTANCE, XML_TYPE_MEASURE|XML_TYPE_PROP_PARAGRAPH, 0 ),

    // RES_PARATR_VERTALIGN
    MP_E( PROP_ParaVertAlignment, XML_NAMESPACE_STYLE, XML_VERTICAL_ALIGN, XML_TYPE_TEXT_VERTICAL_ALIGN, 0 ),

    // RES_PARATR_SNAPTOGRID
    MP_E( PROP_SnapToGrid, XML_NAMESPACE_STYLE, XML_SNAP_TO_LAYOUT_GRID, XML_TYPE_BOOL, 0 ),

    MP_ED( PROP_WritingMode, XML_NAMESPACE_STYLE, XML_WRITING_MODE, XML_TYPE_TEXT_WRITING_MODE_WITH_DEFAULT, CTF_TEXTWRITINGMODE ),

    MP_E( PROP_ParaIsConnectBorder, XML_NAMESPACE_STYLE, XML_JOIN_BORDER, XML_TYPE_BOOL, 0 ),

    MP_E( PROP_DefaultOutlineLevel, XML_NAMESPACE_STYLE, XML_DEFAULT_OUTLINE_LEVEL, XML_TYPE_TEXT_NUMBER8_ONE_BASED|MID_FLAG_SPECIAL_ITEM_EXPORT|MID_FLAG_NO_PROPERTY_IMPORT, CTF_DEFAULT_OUTLINE_LEVEL ),

    MP_ED( PROP_FontIndependentLineSpacing, XML_NAMESPACE_STYLE, XML_FONT_INDEPENDENT_LINE_SPACING, XML_TYPE_BOOL, 0 ),

    MAP_EXT( PROP_ListAutoFormat, XML_NAMESPACE_LO_EXT, XML_MARKER_STYLE_NAME, XML_TYPE_STYLENAME|XML_TYPE_PROP_PARAGRAPH, 0 ),

    MAP_EXT( PROP_ParaLeftMarginUnit, XML_NAMESPACE_LO_EXT, XML_MARGIN_LEFT, XML_TYPE_PROP_PARAGRAPH|XML_TYPE_UNIT_MEASURE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MAP_EXT_I( PROP_ParaLeftMargin, XML_NAMESPACE_LO_EXT, XML_MARGIN_LEFT, XML_TYPE_PROP_PARAGRAPH|XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_PARALEFTMARGIN ),
    MAP_EXT_I( PROP_ParaLeftMarginRelative, XML_NAMESPACE_LO_EXT, XML_MARGIN_LEFT, XML_TYPE_PROP_PARAGRAPH|XML_TYPE_PERCENT16, CTF_PARALEFTMARGIN_REL ),
    MAP_EXT( PROP_ParaRightMarginUnit, XML_NAMESPACE_LO_EXT, XML_MARGIN_RIGHT, XML_TYPE_PROP_PARAGRAPH|XML_TYPE_UNIT_MEASURE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MAP_EXT_I( PROP_ParaRightMargin, XML_NAMESPACE_LO_EXT, XML_MARGIN_RIGHT, XML_TYPE_PROP_PARAGRAPH|XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_PARARIGHTMARGIN ),
    MAP_EXT_I( PROP_ParaRightMarginRelative, XML_NAMESPACE_LO_EXT, XML_MARGIN_RIGHT, XML_TYPE_PROP_PARAGRAPH|XML_TYPE_PERCENT16, CTF_PARARIGHTMARGIN_REL ),
    MAP_EXT( PROP_ParaFirstLineIndentUnit, XML_NAMESPACE_LO_EXT, XML_TEXT_INDENT, XML_TYPE_PROP_PARAGRAPH|XML_TYPE_UNIT_MEASURE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MAP_EXT_I( PROP_ParaFirstLineIndent, XML_NAMESPACE_LO_EXT, XML_TEXT_INDENT, XML_TYPE_PROP_PARAGRAPH|XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_PARAFIRSTLINE ),
    MAP_EXT_I( PROP_ParaFirstLineIndentRelative, XML_NAMESPACE_LO_EXT, XML_TEXT_INDENT, XML_TYPE_PROP_PARAGRAPH|XML_TYPE_PERCENT, CTF_PARAFIRSTLINE_REL ),

    M_END()
};


XMLPropertyMapEntry constexpr aXMLAdditionalTextDefaultsMap[] =
{
    // RES_FOLLOW_TEXT_FLOW - DVO #i18732#
    MG_ED( PROP_IsFollowingTextFlow, XML_NAMESPACE_STYLE, XML_FLOW_WITH_TEXT, XML_TYPE_BOOL, 0 ),

    // #i28701# - RES_WRAP_INFLUENCE_ON_OBJPOS
    MG_ED( PROP_WrapInfluenceOnPosition, XML_NAMESPACE_DRAW, XML_WRAP_INFLUENCE_ON_POSITION, XML_TYPE_WRAP_INFLUENCE_ON_POSITION, 0 ),

    M_END()
};

XMLPropertyMapEntry constexpr aXMLTextPropMap[] =
{
    // RES_CHRATR_CASEMAP
    MT_E( PROP_CharCaseMap, XML_NAMESPACE_FO, XML_FONT_VARIANT,   XML_TYPE_TEXT_CASEMAP_VAR, 0 ),
    MT_E( PROP_CharCaseMap, XML_NAMESPACE_FO, XML_TEXT_TRANSFORM, XML_TYPE_TEXT_CASEMAP,     0 ),
    // RES_CHRATR_COLOR
    MT_ED( PROP_CharColor,            XML_NAMESPACE_FO,     XML_COLOR,                 XML_TYPE_COLORAUTO|MID_FLAG_MERGE_PROPERTY,   0 ),
    MT_ED( PROP_CharColor,            XML_NAMESPACE_STYLE,  XML_USE_WINDOW_FONT_COLOR, XML_TYPE_ISAUTOCOLOR|MID_FLAG_MERGE_PROPERTY, 0 ),
    MAP_EXT_I( PROP_CharTransparence, XML_NAMESPACE_DRAW,   XML_OPACITY,               XML_TYPE_NEG_PERCENT16 | XML_TYPE_PROP_TEXT,  0 ),
    MAP_EXT( PROP_CharTransparence,   XML_NAMESPACE_LO_EXT, XML_OPACITY,               XML_TYPE_NEG_PERCENT16 | XML_TYPE_PROP_TEXT,  0 ),
    MAP_EXT( PROP_CharComplexColor,   XML_NAMESPACE_LO_EXT, XML_CHAR_COMPLEX_COLOR,    XML_TYPE_COMPLEX_COLOR|XML_TYPE_PROP_TEXT|MID_FLAG_ELEMENT_ITEM, CTF_COMPLEX_COLOR ),
    // RES_CHRATR_CONTOUR
    MT_E( PROP_CharContoured, XML_NAMESPACE_STYLE, XML_TEXT_OUTLINE, XML_TYPE_BOOL, 0 ),
    // RES_CHRATR_CROSSEDOUT
    MT_E( PROP_CharStrikeout, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_STYLE, XML_TYPE_TEXT_CROSSEDOUT_STYLE|MID_FLAG_MERGE_PROPERTY, 0),
    MT_E( PROP_CharStrikeout, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_TYPE,  XML_TYPE_TEXT_CROSSEDOUT_TYPE|MID_FLAG_MERGE_PROPERTY,  0),
    MT_E( PROP_CharStrikeout, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_WIDTH, XML_TYPE_TEXT_CROSSEDOUT_WIDTH|MID_FLAG_MERGE_PROPERTY, 0),
    MT_E( PROP_CharStrikeout, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_TEXT,  XML_TYPE_TEXT_CROSSEDOUT_TEXT|MID_FLAG_MERGE_PROPERTY,  0),
    // RES_CHRATR_ESCAPEMENT
    MT_E( PROP_CharEscapement,       XML_NAMESPACE_STYLE, XML_TEXT_POSITION, XML_TYPE_TEXT_ESCAPEMENT|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MT_E( PROP_CharEscapementHeight, XML_NAMESPACE_STYLE, XML_TEXT_POSITION, XML_TYPE_TEXT_ESCAPEMENT_HEIGHT|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    // RES_CHRATR_FONT
    MT_ED( PROP_CharFontName,      XML_NAMESPACE_STYLE, XML_FONT_NAME,           XML_TYPE_STRING|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTNAME ),
    MT_ED( PROP_CharFontName,      XML_NAMESPACE_FO,    XML_FONT_FAMILY,         XML_TYPE_TEXT_FONTFAMILYNAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTFAMILYNAME ),
    MT_ED( PROP_CharFontStyleName, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME,     XML_TYPE_STRING, CTF_FONTSTYLENAME ),
    MT_ED( PROP_CharFontFamily,    XML_NAMESPACE_STYLE, XML_FONT_FAMILY_GENERIC, XML_TYPE_TEXT_FONTFAMILY, CTF_FONTFAMILY ),
    MT_ED( PROP_CharFontPitch,     XML_NAMESPACE_STYLE, XML_FONT_PITCH,          XML_TYPE_TEXT_FONTPITCH, CTF_FONTPITCH ),
    MT_ED( PROP_CharFontCharSet,   XML_NAMESPACE_STYLE, XML_FONT_CHARSET,        XML_TYPE_TEXT_FONTENCODING, CTF_FONTCHARSET ),
    // RES_CHRATR_FONTSIZE
    MT_ED( PROP_CharHeight,     XML_NAMESPACE_FO,    XML_FONT_SIZE,     XML_TYPE_CHAR_HEIGHT|MID_FLAG_MULTI_PROPERTY,      CTF_CHARHEIGHT ),
    MT_ED( PROP_CharPropHeight, XML_NAMESPACE_FO,    XML_FONT_SIZE,     XML_TYPE_CHAR_HEIGHT_PROP|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_REL ),
    MT_ED( PROP_CharDiffHeight, XML_NAMESPACE_STYLE, XML_FONT_SIZE_REL, XML_TYPE_CHAR_HEIGHT_DIFF,                         CTF_CHARHEIGHT_DIFF ),
    // RES_CHRATR_KERNING
    MT_E( PROP_CharKerning, XML_NAMESPACE_FO, XML_LETTER_SPACING, XML_TYPE_TEXT_KERNING, 0 ),
    // RES_CHRATR_LANGUAGE
    MT_ED( PROP_CharLocale, XML_NAMESPACE_STYLE, XML_RFC_LANGUAGE_TAG, XML_TYPE_CHAR_RFC_LANGUAGE_TAG|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_ED( PROP_CharLocale, XML_NAMESPACE_FO,    XML_LANGUAGE,         XML_TYPE_CHAR_LANGUAGE|MID_FLAG_MERGE_PROPERTY,         0 ),
    MT_ED( PROP_CharLocale, XML_NAMESPACE_FO,    XML_SCRIPT,           XML_TYPE_CHAR_SCRIPT|MID_FLAG_MERGE_PROPERTY,           0 ),
    MT_ED( PROP_CharLocale, XML_NAMESPACE_FO,    XML_COUNTRY,          XML_TYPE_CHAR_COUNTRY|MID_FLAG_MERGE_PROPERTY,          0 ),
    // RES_CHRATR_POSTURE
    MT_E( PROP_CharPosture, XML_NAMESPACE_FO, XML_FONT_STYLE, XML_TYPE_TEXT_POSTURE, 0 ),
    // RES_CHRATR_UNUSED1
    // RES_CHRATR_SHADOWED
    MT_E( PROP_CharShadowed, XML_NAMESPACE_FO, XML_TEXT_SHADOW, XML_TYPE_TEXT_SHADOWED, 0 ),
    // VALIDATED UP TO THIS LINE
    // RES_CHRATR_UNDERLINE
    MT_E( PROP_CharUnderline,         XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_STYLE, XML_TYPE_TEXT_UNDERLINE_STYLE|MID_FLAG_MERGE_PROPERTY, CTF_UNDERLINE ),
    MT_E( PROP_CharUnderline,         XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_TYPE,  XML_TYPE_TEXT_UNDERLINE_TYPE|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_E( PROP_CharUnderline,         XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_WIDTH, XML_TYPE_TEXT_UNDERLINE_WIDTH|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_E( PROP_CharUnderlineColor,    XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_COLOR, XML_TYPE_TEXT_UNDERLINE_COLOR|MID_FLAG_MULTI_PROPERTY, CTF_UNDERLINE_COLOR  ),
    MT_E( PROP_CharUnderlineHasColor, XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_COLOR, XML_TYPE_TEXT_UNDERLINE_HASCOLOR|MID_FLAG_MERGE_ATTRIBUTE, CTF_UNDERLINE_HASCOLOR   ),
    // RES_CHRATR_WEIGHT
    MT_E( PROP_CharWeight, XML_NAMESPACE_FO, XML_FONT_WEIGHT, XML_TYPE_TEXT_WEIGHT, 0 ),
    // RES_CHRATR_RSID
    { PROP_Rsid, XML_NAMESPACE_OFFICE_EXT, XML_RSID, XML_TYPE_HEX|XML_TYPE_PROP_TEXT, 0, SvtSaveOptions::ODFSVER_FUTURE_EXTENDED, false },
    // RES_PARATR_RSID
    { PROP_ParRsid, XML_NAMESPACE_OFFICE_EXT, XML_PARRSID, XML_TYPE_HEX|XML_TYPE_PROP_TEXT, 0, SvtSaveOptions::ODFSVER_FUTURE_EXTENDED, false },
    // RES_CHRATR_WORDLINEMODE
    MT_E( PROP_CharWordMode, XML_NAMESPACE_STYLE, XML_TEXT_UNDERLINE_MODE,    XML_TYPE_TEXT_LINE_MODE|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_E( PROP_CharWordMode, XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_MODE,     XML_TYPE_TEXT_LINE_MODE|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_E( PROP_CharWordMode, XML_NAMESPACE_STYLE, XML_TEXT_LINE_THROUGH_MODE, XML_TYPE_TEXT_LINE_MODE|MID_FLAG_MERGE_PROPERTY, 0 ),
    // RES_CHRATR_AUTOKERN
    MT_E( PROP_CharAutoKerning, XML_NAMESPACE_STYLE, XML_LETTER_KERNING, XML_TYPE_BOOL, 0 ),
    // RES_CHRATR_BLINK
    MT_E( PROP_CharFlash, XML_NAMESPACE_STYLE, XML_TEXT_BLINKING, XML_TYPE_BOOL, 0 ),
    // RES_CHRATR_NOHYPHEN
    MT_E( PROP_CharNoHyphenation, XML_NAMESPACE_FO, XML_HYPHENATE, XML_TYPE_NBOOL, 0 ),
    // RES_CHRATR_UNUSED2
    // RES_CHRATR_BACKGROUND
    MT_E( PROP_CharBackColor,       XML_NAMESPACE_FO,     XML_BACKGROUND_COLOR,      XML_TYPE_COLORTRANSPARENT|MID_FLAG_MULTI_PROPERTY, CTF_CHAR_BACKGROUND ),
    MT_E( PROP_CharBackTransparent, XML_NAMESPACE_FO,     XML_BACKGROUND_COLOR,      XML_TYPE_ISTRANSPARENT|MID_FLAG_MERGE_ATTRIBUTE, CTF_CHAR_BACKGROUND_TRANSPARENCY),
    { PROP_CharShadingValue,        XML_NAMESPACE_LO_EXT, XML_CHAR_SHADING_VALUE,    XML_TYPE_NUMBER|XML_TYPE_PROP_TEXT, 0, SvtSaveOptions::ODFSVER_FUTURE_EXTENDED, false },
    MT_E( PROP_CharBackColor,       XML_NAMESPACE_FO,     XML_TEXT_BACKGROUND_COLOR, XML_TYPE_COLOR|MID_FLAG_SPECIAL_ITEM_EXPORT, CTF_OLDTEXTBACKGROUND ),
    // RES_CHRATR_CJK_FONT
    MT_ED( PROP_CharFontNameAsian,      XML_NAMESPACE_STYLE, XML_FONT_NAME_ASIAN,           XML_TYPE_STRING|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTNAME_CJK ),
    MT_ED( PROP_CharFontNameAsian,      XML_NAMESPACE_STYLE, XML_FONT_FAMILY_ASIAN,         XML_TYPE_TEXT_FONTFAMILYNAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTFAMILYNAME_CJK ),
    MT_ED( PROP_CharFontStyleNameAsian, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME_ASIAN,     XML_TYPE_STRING, CTF_FONTSTYLENAME_CJK ),
    MT_ED( PROP_CharFontFamilyAsian,    XML_NAMESPACE_STYLE, XML_FONT_FAMILY_GENERIC_ASIAN, XML_TYPE_TEXT_FONTFAMILY, CTF_FONTFAMILY_CJK ),
    MT_ED( PROP_CharFontPitchAsian,     XML_NAMESPACE_STYLE, XML_FONT_PITCH_ASIAN,          XML_TYPE_TEXT_FONTPITCH, CTF_FONTPITCH_CJK ),
    MT_ED( PROP_CharFontCharSetAsian,   XML_NAMESPACE_STYLE, XML_FONT_CHARSET_ASIAN,        XML_TYPE_TEXT_FONTENCODING, CTF_FONTCHARSET_CJK ),
    // RES_CHRATR_CJK_FONTSIZE
    MT_ED( PROP_CharHeightAsian,     XML_NAMESPACE_STYLE, XML_FONT_SIZE_ASIAN, XML_TYPE_CHAR_HEIGHT|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_CJK ),
    MT_ED( PROP_CharPropHeightAsian, XML_NAMESPACE_STYLE, XML_FONT_SIZE_ASIAN, XML_TYPE_CHAR_HEIGHT_PROP|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_REL_CJK ),
    MT_ED( PROP_CharDiffHeightAsian, XML_NAMESPACE_STYLE, XML_FONT_SIZE_REL_ASIAN, XML_TYPE_CHAR_HEIGHT_DIFF, CTF_CHARHEIGHT_DIFF_CJK ),
    // RES_CHRATR_CJK_LANGUAGE
    MT_ED( PROP_CharLocaleAsian, XML_NAMESPACE_STYLE, XML_RFC_LANGUAGE_TAG_ASIAN, XML_TYPE_CHAR_RFC_LANGUAGE_TAG|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_ED( PROP_CharLocaleAsian, XML_NAMESPACE_STYLE, XML_LANGUAGE_ASIAN,         XML_TYPE_CHAR_LANGUAGE|MID_FLAG_MERGE_PROPERTY,         0 ),
    MT_ED( PROP_CharLocaleAsian, XML_NAMESPACE_STYLE, XML_SCRIPT_ASIAN,           XML_TYPE_CHAR_SCRIPT|MID_FLAG_MERGE_PROPERTY,           0 ),
    MT_ED( PROP_CharLocaleAsian, XML_NAMESPACE_STYLE, XML_COUNTRY_ASIAN,          XML_TYPE_CHAR_COUNTRY|MID_FLAG_MERGE_PROPERTY,          0 ),
    // RES_CHRATR_CJK_POSTURE
    MT_E( PROP_CharPostureAsian, XML_NAMESPACE_STYLE, XML_FONT_STYLE_ASIAN, XML_TYPE_TEXT_POSTURE, 0 ),
    // RES_CHRATR_CJK_WEIGHT
    MT_E( PROP_CharWeightAsian, XML_NAMESPACE_STYLE, XML_FONT_WEIGHT_ASIAN, XML_TYPE_TEXT_WEIGHT, 0 ),
    // RES_CHRATR_CTL_FONT
    MT_ED( PROP_CharFontNameComplex,      XML_NAMESPACE_STYLE, XML_FONT_NAME_COMPLEX,           XML_TYPE_STRING|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTNAME_CTL ),
    MT_ED( PROP_CharFontNameComplex,      XML_NAMESPACE_STYLE, XML_FONT_FAMILY_COMPLEX,         XML_TYPE_TEXT_FONTFAMILYNAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTFAMILYNAME_CTL ),
    MT_ED( PROP_CharFontStyleNameComplex, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME_COMPLEX,     XML_TYPE_STRING, CTF_FONTSTYLENAME_CTL ),
    MT_ED( PROP_CharFontFamilyComplex,    XML_NAMESPACE_STYLE, XML_FONT_FAMILY_GENERIC_COMPLEX, XML_TYPE_TEXT_FONTFAMILY, CTF_FONTFAMILY_CTL ),
    MT_ED( PROP_CharFontPitchComplex,     XML_NAMESPACE_STYLE, XML_FONT_PITCH_COMPLEX,          XML_TYPE_TEXT_FONTPITCH, CTF_FONTPITCH_CTL ),
    MT_ED( PROP_CharFontCharSetComplex,   XML_NAMESPACE_STYLE, XML_FONT_CHARSET_COMPLEX,        XML_TYPE_TEXT_FONTENCODING, CTF_FONTCHARSET_CTL ),
    // RES_CHRATR_CTL_FONTSIZE
    MT_ED( PROP_CharHeightComplex,     XML_NAMESPACE_STYLE, XML_FONT_SIZE_COMPLEX,     XML_TYPE_CHAR_HEIGHT|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_CTL ),
    MT_ED( PROP_CharPropHeightComplex, XML_NAMESPACE_STYLE, XML_FONT_SIZE_COMPLEX,     XML_TYPE_CHAR_HEIGHT_PROP|MID_FLAG_MULTI_PROPERTY, CTF_CHARHEIGHT_REL_CTL ),
    MT_ED( PROP_CharDiffHeightComplex, XML_NAMESPACE_STYLE, XML_FONT_SIZE_REL_COMPLEX, XML_TYPE_CHAR_HEIGHT_DIFF, CTF_CHARHEIGHT_DIFF_CTL ),
    // RES_CHRATR_CTL_LANGUAGE
    MT_ED( PROP_CharLocaleComplex, XML_NAMESPACE_STYLE, XML_RFC_LANGUAGE_TAG_COMPLEX, XML_TYPE_CHAR_RFC_LANGUAGE_TAG|MID_FLAG_MERGE_PROPERTY, 0 ),
    MT_ED( PROP_CharLocaleComplex, XML_NAMESPACE_STYLE, XML_LANGUAGE_COMPLEX,         XML_TYPE_CHAR_LANGUAGE|MID_FLAG_MERGE_PROPERTY,         0 ),
    MT_ED( PROP_CharLocaleComplex, XML_NAMESPACE_STYLE, XML_SCRIPT_COMPLEX,           XML_TYPE_CHAR_SCRIPT|MID_FLAG_MERGE_PROPERTY,           0 ),
    MT_ED( PROP_CharLocaleComplex, XML_NAMESPACE_STYLE, XML_COUNTRY_COMPLEX,          XML_TYPE_CHAR_COUNTRY|MID_FLAG_MERGE_PROPERTY,          0 ),
    // RES_CHRATR_CTL_POSTURE
    MT_E( PROP_CharPostureComplex, XML_NAMESPACE_STYLE, XML_FONT_STYLE_COMPLEX, XML_TYPE_TEXT_POSTURE, 0 ),
    // RES_CHRATR_CTL_WEIGHT
    MT_E( PROP_CharWeightComplex, XML_NAMESPACE_STYLE, XML_FONT_WEIGHT_COMPLEX, XML_TYPE_TEXT_WEIGHT, 0 ),
    // RES_CHRATR_ROTATE
    MT_E( PROP_CharRotation,            XML_NAMESPACE_STYLE, XML_TEXT_ROTATION_ANGLE, XML_TYPE_TEXT_ROTATION_ANGLE, 0 ),
    MT_E( PROP_CharRotationIsFitToLine, XML_NAMESPACE_STYLE, XML_TEXT_ROTATION_SCALE, XML_TYPE_TEXT_ROTATION_SCALE, 0 ),
    // RES_CHRATR_EMPHASIS_MARK
    MT_E( PROP_CharEmphasis, XML_NAMESPACE_STYLE, XML_TEXT_EMPHASIZE, XML_TYPE_TEXT_EMPHASIZE, 0 ),
    // RES_CHRATR_TWO_LINES
    MT_E( PROP_CharCombineIsOn,   XML_NAMESPACE_STYLE, XML_TEXT_COMBINE,            XML_TYPE_TEXT_COMBINE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MT_E( PROP_CharCombinePrefix, XML_NAMESPACE_STYLE, XML_TEXT_COMBINE_START_CHAR, XML_TYPE_TEXT_COMBINECHAR, 0 ),
    MT_E( PROP_CharCombineSuffix, XML_NAMESPACE_STYLE, XML_TEXT_COMBINE_END_CHAR,   XML_TYPE_TEXT_COMBINECHAR, 0 ),
    // RES_CHRATR_SCALEW
    MT_E( PROP_CharScaleWidth, XML_NAMESPACE_STYLE, XML_TEXT_SCALE, XML_TYPE_PERCENT16, 0 ),
    // combined characters field, does not correspond to a property
    MT_E( PROP_, XML_NAMESPACE_STYLE, XML_TEXT_COMBINE, XML_TYPE_TEXT_COMBINE_CHARACTERS|MID_FLAG_NO_PROPERTY, CTF_COMBINED_CHARACTERS_FIELD ),
    //RES_CHRATR_RELIEF
    MT_E( PROP_CharRelief, XML_NAMESPACE_STYLE, XML_FONT_RELIEF, XML_TYPE_TEXT_FONT_RELIEF, 0 ),
    // RES_CHRATR_HIDDEN
    MT_E( PROP_CharHidden, XML_NAMESPACE_TEXT, XML_DISPLAY, XML_TYPE_TEXT_HIDDEN_AS_DISPLAY|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_TEXT_DISPLAY ),
    // RES_CHRATR_OVERLINE
    MT_E( PROP_CharOverline,         XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_STYLE, XML_TYPE_TEXT_OVERLINE_STYLE|MID_FLAG_MERGE_PROPERTY,     0 ),
    MT_E( PROP_CharOverline,         XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_TYPE,  XML_TYPE_TEXT_OVERLINE_TYPE|MID_FLAG_MERGE_PROPERTY,      0 ),
    MT_E( PROP_CharOverline,         XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_WIDTH, XML_TYPE_TEXT_OVERLINE_WIDTH|MID_FLAG_MERGE_PROPERTY,     0 ),
    MT_E( PROP_CharOverlineColor,    XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_COLOR, XML_TYPE_TEXT_OVERLINE_COLOR|MID_FLAG_MULTI_PROPERTY,     0 ),
    MT_E( PROP_CharOverlineHasColor, XML_NAMESPACE_STYLE, XML_TEXT_OVERLINE_COLOR, XML_TYPE_TEXT_OVERLINE_HASCOLOR|MID_FLAG_MERGE_ATTRIBUTE, 0 ),
    // RES_CHRATR_BOX
    MAP_EXT( PROP_CharLeftBorder,     XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH,        XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDERWIDTH ),
    MAP_EXT( PROP_CharLeftBorder,     XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH_LEFT,   XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDERWIDTH ),
    MAP_EXT( PROP_CharRightBorder,    XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH_RIGHT,  XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDERWIDTH ),
    MAP_EXT( PROP_CharTopBorder,      XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH_TOP,    XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDERWIDTH ),
    MAP_EXT( PROP_CharBottomBorder,   XML_NAMESPACE_LO_EXT, XML_BORDER_LINE_WIDTH_BOTTOM, XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDERWIDTH ),
    MAP_EXT_I( PROP_CharLeftBorder,   XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH,        XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDERWIDTH ),
    MAP_EXT_I( PROP_CharLeftBorder,   XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH_LEFT,   XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDERWIDTH ),
    MAP_EXT_I( PROP_CharRightBorder,  XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH_RIGHT,  XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDERWIDTH ),
    MAP_EXT_I( PROP_CharTopBorder,    XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH_TOP,    XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDERWIDTH ),
    MAP_EXT_I( PROP_CharBottomBorder, XML_NAMESPACE_STYLE,  XML_BORDER_LINE_WIDTH_BOTTOM, XML_TYPE_BORDER_WIDTH|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDERWIDTH ),

    MAP_EXT( PROP_CharLeftBorderDistance,     XML_NAMESPACE_LO_EXT, XML_PADDING,        XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDERDISTANCE ),
    MAP_EXT( PROP_CharLeftBorderDistance,     XML_NAMESPACE_LO_EXT, XML_PADDING_LEFT,   XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDERDISTANCE ),
    MAP_EXT( PROP_CharRightBorderDistance,    XML_NAMESPACE_LO_EXT, XML_PADDING_RIGHT,  XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDERDISTANCE ),
    MAP_EXT( PROP_CharTopBorderDistance,      XML_NAMESPACE_LO_EXT, XML_PADDING_TOP,    XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDERDISTANCE ),
    MAP_EXT( PROP_CharBottomBorderDistance,   XML_NAMESPACE_LO_EXT, XML_PADDING_BOTTOM, XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharLeftBorderDistance,   XML_NAMESPACE_FO, XML_PADDING,        XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharLeftBorderDistance,   XML_NAMESPACE_FO, XML_PADDING_LEFT,   XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharRightBorderDistance,  XML_NAMESPACE_FO, XML_PADDING_RIGHT,  XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharTopBorderDistance,    XML_NAMESPACE_FO, XML_PADDING_TOP,    XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDERDISTANCE ),
    MAP_EXT_I( PROP_CharBottomBorderDistance, XML_NAMESPACE_FO, XML_PADDING_BOTTOM, XML_TYPE_MEASURE|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDERDISTANCE ),

    MAP_EXT( PROP_CharLeftBorder,     XML_NAMESPACE_LO_EXT, XML_BORDER,        XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDER ),
    MAP_EXT( PROP_CharLeftBorder,     XML_NAMESPACE_LO_EXT, XML_BORDER_LEFT,   XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDER ),
    MAP_EXT( PROP_CharRightBorder,    XML_NAMESPACE_LO_EXT, XML_BORDER_RIGHT,  XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDER ),
    MAP_EXT( PROP_CharTopBorder,      XML_NAMESPACE_LO_EXT, XML_BORDER_TOP,    XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDER ),
    MAP_EXT( PROP_CharBottomBorder,   XML_NAMESPACE_LO_EXT, XML_BORDER_BOTTOM, XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDER ),
    MAP_EXT_I( PROP_CharLeftBorder,   XML_NAMESPACE_FO, XML_BORDER,        XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARALLBORDER ),
    MAP_EXT_I( PROP_CharLeftBorder,   XML_NAMESPACE_FO, XML_BORDER_LEFT,   XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARLEFTBORDER ),
    MAP_EXT_I( PROP_CharRightBorder,  XML_NAMESPACE_FO, XML_BORDER_RIGHT,  XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARRIGHTBORDER ),
    MAP_EXT_I( PROP_CharTopBorder,    XML_NAMESPACE_FO, XML_BORDER_TOP,    XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARTOPBORDER ),
    MAP_EXT_I( PROP_CharBottomBorder, XML_NAMESPACE_FO, XML_BORDER_BOTTOM, XML_TYPE_BORDER|XML_TYPE_PROP_TEXT, CTF_CHARBOTTOMBORDER ),
    // RES_CHRATR_SHADOW
    MAP_EXT( PROP_CharShadowFormat,   XML_NAMESPACE_LO_EXT, XML_SHADOW, XML_TYPE_TEXT_SHADOW|XML_TYPE_PROP_TEXT, 0 ),
    MAP_EXT_I( PROP_CharShadowFormat, XML_NAMESPACE_STYLE,  XML_SHADOW, XML_TYPE_TEXT_SHADOW|XML_TYPE_PROP_TEXT, 0 ),
    // RES_CHRATR_HIGHLIGHT
    MT_E( PROP_CharHighlight, XML_NAMESPACE_FO, XML_BACKGROUND_COLOR, XML_TYPE_COLORTRANSPARENT|MID_FLAG_MULTI_PROPERTY|MID_FLAG_NO_PROPERTY_IMPORT, CTF_CHAR_HIGHLIGHT ),
    // RES_TXTATR_INETFMT
    MT_E( PROP_HyperLinkURL, XML_NAMESPACE_TEXT, XML_XMLNS, XML_TYPE_STRING|MID_FLAG_NO_PROPERTY_IMPORT, CTF_HYPERLINK_URL ),
    // RES_TXTATR_REFMARK
    // TODO
    // RES_TXTATR_TOXMARK
    // TODO
    // RES_TXTATR_CHARFMT
    MT_E( PROP_CharStyleName, XML_NAMESPACE_TEXT, XML_STYLE_NAME, XML_TYPE_STRING|MID_FLAG_NO_PROPERTY_IMPORT, CTF_CHAR_STYLE_NAME ),
    // RES_TXTATR_CJK_RUBY
    // TODO
    // RES_TXTATR_FIELD
    // TODO
    // RES_TXTATR_FLYCNT
    // TODO
    // RES_TXTATR_FTN
    // TODO
    // RES_TXTATR_SOFTHYPH
    // TODO
    // RES_TXTATR_HARDBLANK
    // TODO
    // RES_UNKNOWNATR_CONTAINER
    MT_E( PROP_TextUserDefinedAttributes, XML_NAMESPACE_TEXT,  XML_XMLNS,             XML_TYPE_ATTRIBUTE_CONTAINER | MID_FLAG_SPECIAL_ITEM, 0 ),
    MT_ED( PROP_ParaIsCharacterDistance,  XML_NAMESPACE_STYLE, XML_TEXT_AUTOSPACE,    XML_TYPE_TEXT_AUTOSPACE,                              0 ),
    MT_ED( PROP_ParaIsHangingPunctuation, XML_NAMESPACE_STYLE, XML_PUNCTUATION_WRAP,  XML_TYPE_TEXT_PUNCTUATION_WRAP,                       0 ),
    MT_ED( PROP_ParaIsForbiddenRules,     XML_NAMESPACE_STYLE, XML_LINE_BREAK,        XML_TYPE_TEXT_LINE_BREAK,                             0 ),
    MT_E( PROP_TabStopDistance,           XML_NAMESPACE_STYLE, XML_TAB_STOP_DISTANCE, XML_TYPE_MEASURE,                                     0 ),

    M_END()
};

XMLPropertyMapEntry constexpr aXMLFramePropMap[] =
{
    // RES_FILL_ORDER
    // TODO: not required???
    // RES_FRM_SIZE
    MG_ED( PROP_Width,           XML_NAMESPACE_SVG,   XML_WIDTH,     XML_TYPE_MEASURE, CTF_FRAMEWIDTH_ABS ),
    MG_ED( PROP_Width,           XML_NAMESPACE_FO,    XML_MIN_WIDTH, XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_FRAMEWIDTH_MIN_ABS ),
    MG_ED( PROP_RelativeWidth,   XML_NAMESPACE_FO,    XML_MIN_WIDTH, XML_TYPE_TEXT_REL_WIDTH_HEIGHT, CTF_FRAMEWIDTH_MIN_REL ),
    MG_ED( PROP_RelativeWidth,   XML_NAMESPACE_STYLE, XML_REL_WIDTH, XML_TYPE_TEXT_REL_WIDTH_HEIGHT, CTF_FRAMEWIDTH_REL ),
    MG_ED( PROP_WidthType,       XML_NAMESPACE_FO,    XML_TEXT_BOX,  XML_TYPE_NUMBER16|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FRAMEWIDTH_TYPE ),
//  M_ED( "RelativeWidth",       XML_NAMESPACE_STYLE, XML_REL_WIDTH, XML_TYPE_TEXT_REL_WIDTH_HEIGHT|MID_FLAG_MULTI_PROPERTY, 0 ),
//  M_ED( "IsSyncWidthToHeight", XML_NAMESPACE_STYLE, XML_REL_WIDTH, XML_TYPE_TEXT_SYNC_WIDTH_HEIGHT|MID_FLAG_MULTI_PROPERTY, 0 ),

    MG_ED( PROP_Height,          XML_NAMESPACE_SVG,   XML_HEIGHT,     XML_TYPE_MEASURE, CTF_FRAMEHEIGHT_ABS ),
    MG_ED( PROP_Height,          XML_NAMESPACE_FO,    XML_MIN_HEIGHT, XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY, CTF_FRAMEHEIGHT_MIN_ABS ),
    MG_ED( PROP_RelativeHeight,  XML_NAMESPACE_FO,    XML_MIN_HEIGHT, XML_TYPE_TEXT_REL_WIDTH_HEIGHT, CTF_FRAMEHEIGHT_MIN_REL ),
    MG_ED( PROP_RelativeHeight,  XML_NAMESPACE_STYLE, XML_REL_HEIGHT, XML_TYPE_TEXT_REL_WIDTH_HEIGHT, CTF_FRAMEHEIGHT_REL ),
//  M_ED( "RelativeHeight",      XML_NAMESPACE_STYLE, XML_REL_HEIGHT, XML_TYPE_TEXT_REL_WIDTH_HEIGHT|MID_FLAG_MULTI_PROPERTY, CTF_FRAMEHEIGHT_REL ),
//  M_ED( "IsSyncHeightToWidth", XML_NAMESPACE_STYLE, XML_REL_HEIGHT, XML_TYPE_TEXT_SYNC_WIDTH_HEIGHT|MID_FLAG_MULTI_PROPERTY, CTF_SYNCHEIGHT ),
//  M_ED( "IsSyncHeightToWidth", XML_NAMESPACE_STYLE, XML_REL_HEIGHT, XML_TYPE_TEXT_SYNC_WIDTH_HEIGHT_MIN, CTF_SYNCHEIGHT_MIN ),
    MG_ED( PROP_SizeType,        XML_NAMESPACE_FO,    XML_TEXT_BOX,   XML_TYPE_NUMBER16|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_SIZETYPE ),
    // RES_PAPER_BIN
    // not required
    // RES_ANCHOR
    // moved to here because it is not used for automatic styles
    MG_ED( PROP_AnchorType, XML_NAMESPACE_TEXT, XML_ANCHOR_TYPE, XML_TYPE_TEXT_ANCHOR_TYPE, CTF_ANCHORTYPE ),
    // AnchorPage number is not required for styles!
    MG_ED( PROP_HoriOrientPosition, XML_NAMESPACE_SVG, XML_X, XML_TYPE_MEASURE, 0 ),
    MG_ED( PROP_VertOrientPosition, XML_NAMESPACE_SVG, XML_Y, XML_TYPE_MEASURE, 0 ),
    // ***** The map for automatic styles starts here *****
    // RES_LR_SPACE
    MG_E( PROP_LeftMargin,  XML_NAMESPACE_FO, XML_MARGIN,       XML_TYPE_MEASURE, CTF_MARGINALL ),
    MG_E( PROP_LeftMargin,  XML_NAMESPACE_FO, XML_MARGIN_LEFT,  XML_TYPE_MEASURE, CTF_MARGINLEFT ),
    MG_E( PROP_RightMargin, XML_NAMESPACE_FO, XML_MARGIN_RIGHT, XML_TYPE_MEASURE, CTF_MARGINRIGHT ),
    // RES_UL_SPACE
    MG_E( PROP_TopMargin,    XML_NAMESPACE_FO, XML_MARGIN_TOP,    XML_TYPE_MEASURE, CTF_MARGINTOP ),
    MG_E( PROP_BottomMargin, XML_NAMESPACE_FO, XML_MARGIN_BOTTOM, XML_TYPE_MEASURE, CTF_MARGINBOTTOM ),
    // RES_PAGEDESC
    // not required
    // RES_BREAK
    // not required
    // RES_CNTNT
    // not required (accessed using API)
    // RES_HEADER
    // not required
    // RES_FOOTER
    // not required
    // RES_PRINT
    MG_E( PROP_Print, XML_NAMESPACE_STYLE, XML_PRINT_CONTENT, XML_TYPE_BOOL, 0 ),
    // RES_OPAQUE
    MG_ED( PROP_Opaque, XML_NAMESPACE_STYLE, XML_RUN_THROUGH, XML_TYPE_TEXT_OPAQUE, 0 ),
    // RES_PROTECT
    MG_E( PROP_ContentProtected,  XML_NAMESPACE_STYLE, XML_PROTECT, XML_TYPE_TEXT_PROTECT_CONTENT|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MG_E( PROP_SizeProtected,     XML_NAMESPACE_STYLE, XML_PROTECT, XML_TYPE_TEXT_PROTECT_SIZE|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MG_E( PROP_PositionProtected, XML_NAMESPACE_STYLE, XML_PROTECT, XML_TYPE_TEXT_PROTECT_POSITION|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    // RES_SURROUND
    MG_ED( PROP_TextWrap,           XML_NAMESPACE_STYLE, XML_WRAP,                      XML_TYPE_TEXT_WRAP, CTF_WRAP ),
    MG_ED( PROP_SurroundAnchorOnly, XML_NAMESPACE_STYLE, XML_NUMBER_WRAPPED_PARAGRAPHS, XML_TYPE_TEXT_PARAGRAPH_ONLY, CTF_WRAP_PARAGRAPH_ONLY ),
    MG_E( PROP_SurroundContour,     XML_NAMESPACE_STYLE, XML_WRAP_CONTOUR,              XML_TYPE_BOOL, CTF_WRAP_CONTOUR ),
    MG_E( PROP_ContourOutside,      XML_NAMESPACE_STYLE, XML_WRAP_CONTOUR_MODE,         XML_TYPE_TEXT_WRAP_OUTSIDE, CTF_WRAP_CONTOUR_MODE ),
    // RES_VERT_ORIENT
    MG_ED( PROP_VertOrient,             XML_NAMESPACE_STYLE,  XML_VERTICAL_POS, XML_TYPE_TEXT_VERTICAL_POS, CTF_VERTICALPOS ),
    MG_ED( PROP_VertOrient,             XML_NAMESPACE_STYLE,  XML_VERTICAL_POS, XML_TYPE_TEXT_VERTICAL_POS_AT_CHAR, CTF_VERTICALPOS_ATCHAR ),
    MG_ED( PROP_VertOrient,             XML_NAMESPACE_STYLE,  XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_AS_CHAR|MID_FLAG_MULTI_PROPERTY, CTF_VERTICALREL_ASCHAR ),
    MG_ED( PROP_VertOrientRelation,     XML_NAMESPACE_STYLE,  XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL, CTF_VERTICALREL ),
    MG_ED( PROP_VertOrientRelation,     XML_NAMESPACE_STYLE,  XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_PAGE|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_VERTICALREL_PAGE ),
    MG_ED( PROP_VertOrientRelation,     XML_NAMESPACE_STYLE,  XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_FRAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_VERTICALREL_FRAME ),
    MAP_EXT_I( PROP_VertOrientRelation, XML_NAMESPACE_LO_EXT, XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL|XML_TYPE_PROP_GRAPHIC|MID_FLAG_DEFAULT_ITEM_EXPORT, CTF_VERTICALREL ),
    MAP_EXT_I( PROP_VertOrientRelation, XML_NAMESPACE_LO_EXT, XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_PAGE|MID_FLAG_SPECIAL_ITEM_IMPORT|XML_TYPE_PROP_GRAPHIC|MID_FLAG_DEFAULT_ITEM_EXPORT, CTF_VERTICALREL_PAGE ),
    MAP_EXT_I( PROP_VertOrientRelation, XML_NAMESPACE_LO_EXT, XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_FRAME|MID_FLAG_SPECIAL_ITEM_IMPORT|XML_TYPE_PROP_GRAPHIC|MID_FLAG_DEFAULT_ITEM_EXPORT, CTF_VERTICALREL_FRAME ),
    // RES_HORI_ORIENT
    MG_ED( PROP_HoriOrient,         XML_NAMESPACE_STYLE, XML_HORIZONTAL_POS, XML_TYPE_TEXT_HORIZONTAL_POS|MID_FLAG_MULTI_PROPERTY, CTF_HORIZONTALPOS ),
    MG_ED( PROP_PageToggle,         XML_NAMESPACE_STYLE, XML_HORIZONTAL_POS, XML_TYPE_TEXT_HORIZONTAL_MIRROR, CTF_HORIZONTALMIRROR ),
    MG_ED( PROP_HoriOrient,         XML_NAMESPACE_STYLE, XML_HORIZONTAL_POS, XML_TYPE_TEXT_HORIZONTAL_POS_MIRRORED|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_HORIZONTALPOS_MIRRORED ),
    MG_ED( PROP_HoriOrientRelation, XML_NAMESPACE_STYLE, XML_HORIZONTAL_REL, XML_TYPE_TEXT_HORIZONTAL_REL, CTF_HORIZONTALREL ),
    MG_ED( PROP_HoriOrientRelation, XML_NAMESPACE_STYLE, XML_HORIZONTAL_REL, XML_TYPE_TEXT_HORIZONTAL_REL_FRAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_HORIZONTALREL_FRAME ),
    // RES_ANCHOR
    // see above
    // RES_BACKGROUND
    // DO NOT REORDER these!
    MG_ED( PROP_BackColorRGB,          XML_NAMESPACE_FO,     XML_BACKGROUND_COLOR,              XML_TYPE_COLORTRANSPARENT|MID_FLAG_MULTI_PROPERTY, 0 ),
    MG_ED( PROP_BackTransparent,       XML_NAMESPACE_FO,     XML_BACKGROUND_COLOR,              XML_TYPE_ISTRANSPARENT|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, CTF_BACKGROUND_TRANSPARENT ),
    MG_ED( PROP_BackColorTransparency, XML_NAMESPACE_STYLE,  XML_BACKGROUND_TRANSPARENCY,       XML_TYPE_PERCENT8, CTF_BACKGROUND_TRANSPARENCY ),

    MG_E( PROP_BackGraphicTransparency, XML_NAMESPACE_STYLE, XML_BACKGROUND_IMAGE_TRANSPARENCY, MID_FLAG_SPECIAL_ITEM|XML_TYPE_PERCENT8, CTF_BACKGROUND_TRANSPARENCY ),
    MG_E( PROP_BackGraphicLocation,     XML_NAMESPACE_STYLE, XML_POSITION,                      MID_FLAG_SPECIAL_ITEM|XML_TYPE_BUILDIN_CMP_ONLY, CTF_BACKGROUND_POS  ),
    MG_E( PROP_BackGraphicFilter,       XML_NAMESPACE_STYLE, XML_FILTER_NAME,                   MID_FLAG_SPECIAL_ITEM|XML_TYPE_STRING, CTF_BACKGROUND_FILTER ),
    MG_E( PROP_BackGraphic,             XML_NAMESPACE_STYLE, XML_BACKGROUND_IMAGE,              MID_FLAG_ELEMENT_ITEM|XML_TYPE_GRAPHIC, CTF_BACKGROUND_URL ),

    // fill attributes
    GMAP( PROP_FillStyle,                      XML_NAMESPACE_DRAW,  XML_FILL,                   XML_SW_TYPE_FILLSTYLE, 0 ),
    GMAP( PROP_FillColor,                      XML_NAMESPACE_DRAW,  XML_FILL_COLOR,             XML_TYPE_COLOR, 0 ),
    GMAP( PROP_FillColor2,                     XML_NAMESPACE_DRAW,  XML_SECONDARY_FILL_COLOR,   XML_TYPE_COLOR, 0 ),
    GMAP( PROP_FillGradientName,               XML_NAMESPACE_DRAW,  XML_FILL_GRADIENT_NAME,     XML_TYPE_STYLENAME|MID_FLAG_NO_PROPERTY_IMPORT, CTF_FILLGRADIENTNAME ),
    GMAP( PROP_FillGradientStepCount,          XML_NAMESPACE_DRAW,  XML_GRADIENT_STEP_COUNT,    XML_TYPE_NUMBER16, 0 ),
    GMAP( PROP_FillHatchName,                  XML_NAMESPACE_DRAW,  XML_FILL_HATCH_NAME,        XML_TYPE_STYLENAME|MID_FLAG_NO_PROPERTY_IMPORT, CTF_FILLHATCHNAME ),
    GMAP( PROP_FillBackground,                 XML_NAMESPACE_DRAW,  XML_FILL_HATCH_SOLID,       XML_TYPE_BOOL, 0 ),
    GMAP( PROP_FillBitmapName,                 XML_NAMESPACE_DRAW,  XML_FILL_IMAGE_NAME,        XML_TYPE_STYLENAME|MID_FLAG_NO_PROPERTY_IMPORT, CTF_FILLBITMAPNAME ),
    GMAP( PROP_FillTransparence,               XML_NAMESPACE_DRAW,  XML_OPACITY,                XML_TYPE_NEG_PERCENT16|MID_FLAG_MULTI_PROPERTY, 0 ),    // exists in SW, too
    GMAP( PROP_FillTransparenceGradientName,   XML_NAMESPACE_DRAW,  XML_OPACITY_NAME,           XML_TYPE_STYLENAME|MID_FLAG_NO_PROPERTY_IMPORT, CTF_FILLTRANSNAME ),
    GMAP( PROP_FillBitmapSizeX,                XML_NAMESPACE_DRAW,  XML_FILL_IMAGE_WIDTH,       XML_SW_TYPE_FILLBITMAPSIZE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapLogicalSize,          XML_NAMESPACE_DRAW,  XML_FILL_IMAGE_WIDTH,       XML_SW_TYPE_LOGICAL_SIZE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapSizeY,                XML_NAMESPACE_DRAW,  XML_FILL_IMAGE_HEIGHT,      XML_SW_TYPE_FILLBITMAPSIZE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapLogicalSize,          XML_NAMESPACE_DRAW,  XML_FILL_IMAGE_HEIGHT,      XML_SW_TYPE_LOGICAL_SIZE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapMode,                 XML_NAMESPACE_STYLE, XML_REPEAT,                 XML_SW_TYPE_BITMAP_MODE|MID_FLAG_MULTI_PROPERTY, 0 ),
    GMAP( PROP_FillBitmapPositionOffsetX,      XML_NAMESPACE_DRAW,  XML_FILL_IMAGE_REF_POINT_X, XML_TYPE_PERCENT, 0 ),
    GMAP( PROP_FillBitmapPositionOffsetY,      XML_NAMESPACE_DRAW,  XML_FILL_IMAGE_REF_POINT_Y, XML_TYPE_PERCENT, 0 ),
    GMAP( PROP_FillBitmapRectanglePoint,       XML_NAMESPACE_DRAW,  XML_FILL_IMAGE_REF_POINT,   XML_SW_TYPE_BITMAP_REFPOINT, 0 ),
    GMAP( PROP_FillBitmapOffsetX,              XML_NAMESPACE_DRAW,  XML_TILE_REPEAT_OFFSET,     XML_SW_TYPE_BITMAPREPOFFSETX|MID_FLAG_MULTI_PROPERTY, CTF_REPEAT_OFFSET_X ),
    GMAP( PROP_FillBitmapOffsetY,              XML_NAMESPACE_DRAW,  XML_TILE_REPEAT_OFFSET,     XML_SW_TYPE_BITMAPREPOFFSETY|MID_FLAG_MULTI_PROPERTY, CTF_REPEAT_OFFSET_Y ),

    // RES_BOX
    MG_ED( PROP_LeftBorder,   XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH,        XML_TYPE_BORDER_WIDTH, CTF_ALLBORDERWIDTH ),
    MG_ED( PROP_LeftBorder,   XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH_LEFT,   XML_TYPE_BORDER_WIDTH, CTF_LEFTBORDERWIDTH ),
    MG_ED( PROP_RightBorder,  XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH_RIGHT,  XML_TYPE_BORDER_WIDTH, CTF_RIGHTBORDERWIDTH ),
    MG_ED( PROP_TopBorder,    XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH_TOP,    XML_TYPE_BORDER_WIDTH, CTF_TOPBORDERWIDTH ),
    MG_ED( PROP_BottomBorder, XML_NAMESPACE_STYLE, XML_BORDER_LINE_WIDTH_BOTTOM, XML_TYPE_BORDER_WIDTH, CTF_BOTTOMBORDERWIDTH ),

    MG_ED( PROP_LeftBorderDistance,   XML_NAMESPACE_FO, XML_PADDING,        XML_TYPE_MEASURE, CTF_ALLBORDERDISTANCE ), // need special import filtering
    MG_ED( PROP_LeftBorderDistance,   XML_NAMESPACE_FO, XML_PADDING_LEFT,   XML_TYPE_MEASURE, CTF_LEFTBORDERDISTANCE ),
    MG_ED( PROP_RightBorderDistance,  XML_NAMESPACE_FO, XML_PADDING_RIGHT,  XML_TYPE_MEASURE, CTF_RIGHTBORDERDISTANCE ),
    MG_ED( PROP_TopBorderDistance,    XML_NAMESPACE_FO, XML_PADDING_TOP,    XML_TYPE_MEASURE, CTF_TOPBORDERDISTANCE ),
    MG_ED( PROP_BottomBorderDistance, XML_NAMESPACE_FO, XML_PADDING_BOTTOM, XML_TYPE_MEASURE, CTF_BOTTOMBORDERDISTANCE ),

    // There is an additional property for controls!
    MG_ED( PROP_LeftBorder,   XML_NAMESPACE_FO, XML_BORDER,        XML_TYPE_BORDER|MID_FLAG_MULTI_PROPERTY, CTF_ALLBORDER ),
    MG_ED( PROP_LeftBorder,   XML_NAMESPACE_FO, XML_BORDER_LEFT,   XML_TYPE_BORDER,                         CTF_LEFTBORDER ),
    MG_ED( PROP_RightBorder,  XML_NAMESPACE_FO, XML_BORDER_RIGHT,  XML_TYPE_BORDER,                         CTF_RIGHTBORDER ),
    MG_ED( PROP_TopBorder,    XML_NAMESPACE_FO, XML_BORDER_TOP,    XML_TYPE_BORDER,                         CTF_TOPBORDER ),
    MG_ED( PROP_BottomBorder, XML_NAMESPACE_FO, XML_BORDER_BOTTOM, XML_TYPE_BORDER,                         CTF_BOTTOMBORDER ),
    // RES_SHADOW
    MG_E( PROP_ShadowFormat,       XML_NAMESPACE_STYLE, XML_SHADOW,         XML_TYPE_TEXT_SHADOW, 0 ),
    MG_E( PROP_ShadowTransparence, XML_NAMESPACE_DRAW,  XML_SHADOW_OPACITY, XML_TYPE_NEG_PERCENT, 0 ),
    // RES_FRMMACRO
    // TODO
    // RES_COL
    MG_E( PROP_TextColumns, XML_NAMESPACE_STYLE, XML_COLUMNS, MID_FLAG_ELEMENT_ITEM|XML_TYPE_TEXT_COLUMNS, CTF_TEXTCOLUMNS ),
    // RES_KEEP
    // not required
    // RES_URL
    // not required (exported as draw:a element)
    // RES_EDIT_IN_READONLY
    MG_ED( PROP_EditInReadonly, XML_NAMESPACE_STYLE, XML_EDITABLE, XML_TYPE_BOOL, 0 ),
    // RES_LAYOUT_SPLIT
    // not required
    // RES_CHAIN
    // not required (exported at text:text-box element)
    // RES_LINENUMBER
    // not required
    // RES_FTN_AT_TXTEND
    // not required
    // RES_END_AT_TXTEND
    // not required
    // RES_COLUMNBALANCE
    // TODO
    // RES_UNKNOWNATR_CONTAINER
//  M_E_SE( TEXT, xmlns, RES_UNKNOWNATR_CONTAINER, 0 ),
    // RES_GRFATR_MIRRORGRF (vertical MUST be processed after horizontal!)
    MG_E( PROP_HoriMirroredOnEvenPages, XML_NAMESPACE_STYLE, XML_MIRROR, XML_TYPE_TEXT_MIRROR_HORIZONTAL_LEFT|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MG_E( PROP_HoriMirroredOnOddPages,  XML_NAMESPACE_STYLE, XML_MIRROR, XML_TYPE_TEXT_MIRROR_HORIZONTAL_RIGHT|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    MG_E( PROP_VertMirrored,            XML_NAMESPACE_STYLE, XML_MIRROR, XML_TYPE_TEXT_MIRROR_VERTICAL|MID_FLAG_MERGE_ATTRIBUTE|MID_FLAG_MULTI_PROPERTY, 0 ),
    // RES_GRFATR_CROPGRF
    MG_EV( PROP_GraphicCrop, XML_NAMESPACE_FO, XML_CLIP, XML_TYPE_TEXT_CLIP, CTF_TEXT_CLIP, SvtSaveOptions::ODFSVER_012 ),
    MG_E( PROP_GraphicCrop,  XML_NAMESPACE_FO, XML_CLIP, XML_TYPE_TEXT_CLIP11, CTF_TEXT_CLIP11 ),
    // RES_GRFATR_ROTATION
    // not required (exported as svg:transform attribute)
    // RES_GRFATR_LUMINANCE
    MG_E( PROP_AdjustLuminance, XML_NAMESPACE_DRAW, XML_LUMINANCE, XML_TYPE_PERCENT16, 0 ),        // signed?
    // RES_GRFATR_CONTRAST
    MG_E( PROP_AdjustContrast, XML_NAMESPACE_DRAW, XML_CONTRAST, XML_TYPE_PERCENT16, 0 ),        // signed?
    // RES_GRFATR_CHANNELR
    MG_E( PROP_AdjustRed, XML_NAMESPACE_DRAW, XML_RED, XML_TYPE_PERCENT16, 0 ),        // signed?
    // RES_GRFATR_CHANNELG
    MG_E( PROP_AdjustGreen, XML_NAMESPACE_DRAW, XML_GREEN, XML_TYPE_PERCENT16, 0 ),        // signed?
    // RES_GRFATR_CHANNELB
    MG_E( PROP_AdjustBlue, XML_NAMESPACE_DRAW, XML_BLUE, XML_TYPE_PERCENT16, 0 ),        // signed?
    // RES_GRFATR_GAMMA
    MG_E( PROP_Gamma, XML_NAMESPACE_DRAW, XML_GAMMA, XML_TYPE_DOUBLE_PERCENT, 0 ),           // signed?
    // RES_GRFATR_INVERT
    MG_E( PROP_GraphicIsInverted, XML_NAMESPACE_DRAW, XML_COLOR_INVERSION, XML_TYPE_BOOL, 0 ),
    // RES_GRFATR_TRANSPARENCY
    MG_E( PROP_Transparency, XML_NAMESPACE_DRAW, XML_IMAGE_OPACITY, XML_TYPE_NEG_PERCENT16|MID_FLAG_MULTI_PROPERTY, 0 ), // #i25616#
    // RES_GRFATR_DRAWMODE
    MG_E( PROP_GraphicColorMode, XML_NAMESPACE_DRAW,   XML_COLOR_MODE,   XML_TYPE_COLOR_MODE, 0 ),
    MG_E( PROP_WritingMode,      XML_NAMESPACE_STYLE,  XML_WRITING_MODE, XML_TYPE_TEXT_WRITING_MODE_WITH_DEFAULT, 0 ),
    MAP_EXT_I( PROP_WritingMode, XML_NAMESPACE_LO_EXT, XML_WRITING_MODE, XML_TYPE_TEXT_WRITING_MODE_WITH_DEFAULT|XML_TYPE_PROP_GRAPHIC, 0),
    // RES_FOLLOW_TEXT_FLOW - DVO #i18732#
    MG_E( PROP_IsFollowingTextFlow, XML_NAMESPACE_DRAW,  XML_FLOW_WITH_TEXT, XML_TYPE_BOOL|MID_FLAG_SPECIAL_ITEM_EXPORT, CTF_OLD_FLOW_WITH_TEXT ),
    MG_E( PROP_IsFollowingTextFlow, XML_NAMESPACE_STYLE, XML_FLOW_WITH_TEXT, XML_TYPE_BOOL, 0 ),
    // #i28701# - RES_WRAP_INFLUENCE_ON_OBJPOS
    MG_E( PROP_WrapInfluenceOnPosition, XML_NAMESPACE_DRAW,   XML_WRAP_INFLUENCE_ON_POSITION, XML_TYPE_WRAP_INFLUENCE_ON_POSITION, 0 ),
    MAP_EXT( PROP_AllowOverlap,         XML_NAMESPACE_LO_EXT, XML_ALLOW_OVERLAP,              XML_TYPE_BOOL|XML_TYPE_PROP_GRAPHIC, 0 ),
    MAP_EXT( PROP_WrapTextAtFlyStart,   XML_NAMESPACE_LO_EXT, XML_WRAP_TEXT_AT_FRAME_START,   XML_TYPE_BOOL|XML_TYPE_PROP_GRAPHIC, 0 ),

    // special entries for floating frames
    MG_E( PROP_, XML_NAMESPACE_DRAW, XML_FRAME_DISPLAY_SCROLLBAR, XML_TYPE_BOOL|MID_FLAG_NO_PROPERTY|MID_FLAG_MULTI_PROPERTY, CTF_FRAME_DISPLAY_SCROLLBAR ),
    MG_E( PROP_, XML_NAMESPACE_DRAW, XML_FRAME_DISPLAY_BORDER,    XML_TYPE_BOOL|MID_FLAG_NO_PROPERTY|MID_FLAG_MULTI_PROPERTY, CTF_FRAME_DISPLAY_BORDER ),
    MG_E( PROP_, XML_NAMESPACE_DRAW, XML_FRAME_MARGIN_HORIZONTAL, XML_TYPE_MEASURE_PX|MID_FLAG_NO_PROPERTY|MID_FLAG_MULTI_PROPERTY,   CTF_FRAME_MARGIN_HORI ),
    MG_E( PROP_, XML_NAMESPACE_DRAW, XML_FRAME_MARGIN_VERTICAL,   XML_TYPE_MEASURE_PX|MID_FLAG_NO_PROPERTY|MID_FLAG_MULTI_PROPERTY,   CTF_FRAME_MARGIN_VERT ),
    MG_E( PROP_, XML_NAMESPACE_DRAW, XML_VISIBLE_AREA_LEFT,       XML_TYPE_MEASURE|MID_FLAG_NO_PROPERTY|MID_FLAG_MULTI_PROPERTY,  CTF_OLE_VIS_AREA_LEFT ),
    MG_E( PROP_, XML_NAMESPACE_DRAW, XML_VISIBLE_AREA_TOP,        XML_TYPE_MEASURE|MID_FLAG_NO_PROPERTY|MID_FLAG_MULTI_PROPERTY,  CTF_OLE_VIS_AREA_TOP ),
    MG_E( PROP_, XML_NAMESPACE_DRAW, XML_VISIBLE_AREA_WIDTH,      XML_TYPE_MEASURE|MID_FLAG_NO_PROPERTY|MID_FLAG_MULTI_PROPERTY,  CTF_OLE_VIS_AREA_WIDTH ),
    MG_E( PROP_, XML_NAMESPACE_DRAW, XML_VISIBLE_AREA_HEIGHT,     XML_TYPE_MEASURE|MID_FLAG_NO_PROPERTY|MID_FLAG_MULTI_PROPERTY,  CTF_OLE_VIS_AREA_HEIGHT ),
    MG_E( PROP_, XML_NAMESPACE_DRAW, XML_DRAW_ASPECT,             XML_TYPE_TEXT_DRAW_ASPECT|MID_FLAG_NO_PROPERTY|MID_FLAG_MULTI_PROPERTY, CTF_OLE_DRAW_ASPECT ),

    MG_E( PROP_UserDefinedAttributes,     XML_NAMESPACE_TEXT,   XML_XMLNS,                   XML_TYPE_ATTRIBUTE_CONTAINER | MID_FLAG_SPECIAL_ITEM, 0 ),
    MAP_EXT( PROP_RelativeWidthRelation,  XML_NAMESPACE_LO_EXT, XML_REL_WIDTH_REL,           XML_TYPE_TEXT_HORIZONTAL_REL|XML_TYPE_PROP_GRAPHIC, CTF_RELWIDTHREL),
    MAP_EXT( PROP_RelativeHeightRelation, XML_NAMESPACE_LO_EXT, XML_REL_HEIGHT_REL,          XML_TYPE_TEXT_VERTICAL_REL|XML_TYPE_PROP_GRAPHIC, CTF_RELHEIGHTREL),
    MG_E(PROP_TextVerticalAdjust,         XML_NAMESPACE_DRAW,   XML_TEXTAREA_VERTICAL_ALIGN, XML_TYPE_VERTICAL_ALIGN, 0),
    MAP_EXT(PROP_Decorative,              XML_NAMESPACE_LO_EXT, XML_DECORATIVE,              XML_TYPE_BOOL|XML_TYPE_PROP_GRAPHIC, 0),

    M_END()
};

XMLPropertyMapEntry constexpr aXMLShapePropMap[] =
{
    // RES_LR_SPACE
    MG_E( PROP_LeftMargin,  XML_NAMESPACE_FO, XML_MARGIN_LEFT,  XML_TYPE_MEASURE,  0),
    MG_E( PROP_RightMargin, XML_NAMESPACE_FO, XML_MARGIN_RIGHT, XML_TYPE_MEASURE, 0 ),
    // RES_UL_SPACE
    MG_E( PROP_TopMargin,    XML_NAMESPACE_FO, XML_MARGIN_TOP,    XML_TYPE_MEASURE, 0 ),
    MG_E( PROP_BottomMargin, XML_NAMESPACE_FO, XML_MARGIN_BOTTOM, XML_TYPE_MEASURE, 0 ),
    // RES_OPAQUE
    MG_ED( PROP_Opaque, XML_NAMESPACE_STYLE, XML_RUN_THROUGH, XML_TYPE_TEXT_OPAQUE, 0 ),
    // RES_SURROUND
    MG_E( PROP_TextWrap,           XML_NAMESPACE_STYLE, XML_WRAP,                      XML_TYPE_TEXT_WRAP, CTF_WRAP ),
    MG_E( PROP_SurroundAnchorOnly, XML_NAMESPACE_STYLE, XML_NUMBER_WRAPPED_PARAGRAPHS, XML_TYPE_TEXT_PARAGRAPH_ONLY, CTF_WRAP_PARAGRAPH_ONLY ),
    MG_E( PROP_SurroundContour,    XML_NAMESPACE_STYLE, XML_WRAP_CONTOUR,              XML_TYPE_BOOL, CTF_WRAP_CONTOUR ),
    MG_E( PROP_ContourOutside,     XML_NAMESPACE_STYLE, XML_WRAP_CONTOUR_MODE,         XML_TYPE_TEXT_WRAP_OUTSIDE, CTF_WRAP_CONTOUR_MODE ),
    // Use own CTF ids for positioning attributes (#i28749#)
    // RES_VERT_ORIENT
    MG_E( PROP_VertOrient, XML_NAMESPACE_STYLE, XML_VERTICAL_POS, XML_TYPE_TEXT_VERTICAL_POS, CTF_SHAPE_VERTICALPOS ),
    // Add property for at-character anchored shapes (#i26791#)
    MG_E( PROP_VertOrient,              XML_NAMESPACE_STYLE,  XML_VERTICAL_POS, XML_TYPE_TEXT_VERTICAL_POS_AT_CHAR, CTF_SHAPE_VERTICALPOS_ATCHAR ),
    MG_E( PROP_VertOrient,              XML_NAMESPACE_STYLE,  XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_AS_CHAR|MID_FLAG_MULTI_PROPERTY, CTF_VERTICALREL_ASCHAR ),
    MG_E( PROP_VertOrientRelation,      XML_NAMESPACE_STYLE,  XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL, CTF_SHAPE_VERTICALREL ),
    MG_E( PROP_VertOrientRelation,      XML_NAMESPACE_STYLE,  XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_PAGE|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_SHAPE_VERTICALREL_PAGE ),
    MG_E( PROP_VertOrientRelation,      XML_NAMESPACE_STYLE,  XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_FRAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_SHAPE_VERTICALREL_FRAME ),
    MAP_EXT_I( PROP_VertOrientRelation, XML_NAMESPACE_LO_EXT, XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL|XML_TYPE_PROP_GRAPHIC, CTF_VERTICALREL ),
    MAP_EXT_I( PROP_VertOrientRelation, XML_NAMESPACE_LO_EXT, XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_PAGE|MID_FLAG_SPECIAL_ITEM_IMPORT|XML_TYPE_PROP_GRAPHIC, CTF_VERTICALREL_PAGE ),
    MAP_EXT_I( PROP_VertOrientRelation, XML_NAMESPACE_LO_EXT, XML_VERTICAL_REL, XML_TYPE_TEXT_VERTICAL_REL_FRAME|MID_FLAG_SPECIAL_ITEM_IMPORT|XML_TYPE_PROP_GRAPHIC, CTF_VERTICALREL_FRAME ),
    // RES_HORI_ORIENT
    MG_E( PROP_HoriOrient,         XML_NAMESPACE_STYLE, XML_HORIZONTAL_POS, XML_TYPE_TEXT_HORIZONTAL_POS|MID_FLAG_MULTI_PROPERTY, CTF_SHAPE_HORIZONTALPOS ),
    MG_E( PROP_PageToggle,         XML_NAMESPACE_STYLE, XML_HORIZONTAL_POS, XML_TYPE_TEXT_HORIZONTAL_MIRROR, CTF_SHAPE_HORIZONTALMIRROR ),
    MG_E( PROP_HoriOrient,         XML_NAMESPACE_STYLE, XML_HORIZONTAL_POS, XML_TYPE_TEXT_HORIZONTAL_POS_MIRRORED|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_SHAPE_HORIZONTALPOS_MIRRORED ),
    MG_E( PROP_HoriOrientRelation, XML_NAMESPACE_STYLE, XML_HORIZONTAL_REL, XML_TYPE_TEXT_HORIZONTAL_REL, CTF_SHAPE_HORIZONTALREL ),
    MG_E( PROP_HoriOrientRelation, XML_NAMESPACE_STYLE, XML_HORIZONTAL_REL, XML_TYPE_TEXT_HORIZONTAL_REL_FRAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_SHAPE_HORIZONTALREL_FRAME ),
    // RES_WRAP_INFLUENCE_ON_OBJPOS (#i28701#)
    MG_ED( PROP_WrapInfluenceOnPosition, XML_NAMESPACE_DRAW,   XML_WRAP_INFLUENCE_ON_POSITION, XML_TYPE_WRAP_INFLUENCE_ON_POSITION, 0 ),
    MAP_EXT( PROP_AllowOverlap,          XML_NAMESPACE_LO_EXT, XML_ALLOW_OVERLAP,              XML_TYPE_BOOL|XML_TYPE_PROP_GRAPHIC, 0 ),
    // UserDefinedAttributes is already contained in the map this one is
    // chained to.

    // RES_FOLLOW_TEXT_FLOW (#i26791#)
    MG_ED( PROP_IsFollowingTextFlow, XML_NAMESPACE_STYLE, XML_FLOW_WITH_TEXT, XML_TYPE_BOOL, 0 ),

    // RES_FRM_SIZE
    MAP_EXT( PROP_RelativeWidthRelation,  XML_NAMESPACE_LO_EXT, XML_REL_WIDTH_REL, XML_TYPE_TEXT_HORIZONTAL_REL|XML_TYPE_PROP_GRAPHIC, CTF_RELWIDTHREL ),
    MAP_EXT( PROP_RelativeHeightRelation, XML_NAMESPACE_LO_EXT, XML_REL_HEIGHT_REL, XML_TYPE_TEXT_VERTICAL_REL|XML_TYPE_PROP_GRAPHIC, CTF_RELHEIGHTREL ),

    M_END()
};

XMLPropertyMapEntry constexpr aXMLSectionPropMap[] =
{
    // RES_COL
    MS_E( PROP_TextColumns, XML_NAMESPACE_STYLE, XML_COLUMNS, MID_FLAG_ELEMENT_ITEM|XML_TYPE_TEXT_COLUMNS, CTF_TEXTCOLUMNS ),

    // RES_BACKGROUND
    // DO NOT REORDER these!
    MS_E( PROP_BackColor,           XML_NAMESPACE_FO,    XML_BACKGROUND_COLOR, XML_TYPE_COLORTRANSPARENT|MID_FLAG_MULTI_PROPERTY, 0 ),
    MS_E( PROP_BackTransparent,     XML_NAMESPACE_FO,    XML_BACKGROUND_COLOR, XML_TYPE_ISTRANSPARENT|MID_FLAG_MERGE_ATTRIBUTE, 0 ),
    MS_E( PROP_BackGraphicLocation, XML_NAMESPACE_STYLE, XML_POSITION,         MID_FLAG_SPECIAL_ITEM|XML_TYPE_BUILDIN_CMP_ONLY, CTF_BACKGROUND_POS  ),
    MS_E( PROP_BackGraphicFilter,   XML_NAMESPACE_STYLE, XML_FILTER_NAME,      MID_FLAG_SPECIAL_ITEM|XML_TYPE_STRING, CTF_BACKGROUND_FILTER ),
    MS_E( PROP_BackGraphic,         XML_NAMESPACE_STYLE, XML_BACKGROUND_IMAGE, MID_FLAG_ELEMENT_ITEM|XML_TYPE_GRAPHIC, CTF_BACKGROUND_URL ),

    // move protect-flag into section element
//  M_E( "IsProtected",         STYLE,  PROTECT,    XML_TYPE_BOOL, 0 ),

    MS_E( PROP_DontBalanceTextColumns, XML_NAMESPACE_TEXT, XML_DONT_BALANCE_TEXT_COLUMNS, XML_TYPE_BOOL, 0 ),

    MS_E( PROP_WritingMode, XML_NAMESPACE_STYLE, XML_WRITING_MODE, XML_TYPE_TEXT_WRITING_MODE_WITH_DEFAULT, 0 ),

    MS_E( PROP_SectionLeftMargin,  XML_NAMESPACE_FO, XML_MARGIN_LEFT,  XML_TYPE_MEASURE, 0 ),
    MS_E( PROP_SectionRightMargin, XML_NAMESPACE_FO, XML_MARGIN_RIGHT, XML_TYPE_MEASURE, 0 ),

    // section footnote settings
    MS_E( PROP_FootnoteIsOwnNumbering,     XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_BOOL,    CTF_SECTION_FOOTNOTE_NUM_OWN ),
    MS_E( PROP_FootnoteIsRestartNumbering, XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_BOOL,    CTF_SECTION_FOOTNOTE_NUM_RESTART ),
    MS_E( PROP_FootnoteRestartNumberingAt, XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_NUMBER16, CTF_SECTION_FOOTNOTE_NUM_RESTART_AT ),
    MS_E( PROP_FootnoteNumberingType,      XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_NUMBER16, CTF_SECTION_FOOTNOTE_NUM_TYPE ),
    MS_E( PROP_FootnoteNumberingPrefix,    XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_STRING,  CTF_SECTION_FOOTNOTE_NUM_PREFIX ),
    MS_E( PROP_FootnoteNumberingSuffix,    XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_STRING,  CTF_SECTION_FOOTNOTE_NUM_SUFFIX ),
    MS_E( PROP_FootnoteIsCollectAtTextEnd, XML_NAMESPACE_TEXT, XML_NOTES_CONFIGURATION, MID_FLAG_ELEMENT_ITEM|XML_TYPE_BOOL,    CTF_SECTION_FOOTNOTE_END ),

    // section footnote settings
    MS_E( PROP_EndnoteIsOwnNumbering,     XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_BOOL,    CTF_SECTION_ENDNOTE_NUM_OWN ),
    MS_E( PROP_EndnoteIsRestartNumbering, XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_BOOL,    CTF_SECTION_ENDNOTE_NUM_RESTART ),
    MS_E( PROP_EndnoteRestartNumberingAt, XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_NUMBER16, CTF_SECTION_ENDNOTE_NUM_RESTART_AT ),
    MS_E( PROP_EndnoteNumberingType,      XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_NUMBER16, CTF_SECTION_ENDNOTE_NUM_TYPE ),
    MS_E( PROP_EndnoteNumberingPrefix,    XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_STRING,  CTF_SECTION_ENDNOTE_NUM_PREFIX ),
    MS_E( PROP_EndnoteNumberingSuffix,    XML_NAMESPACE_TEXT, XML__EMPTY,              MID_FLAG_SPECIAL_ITEM|XML_TYPE_STRING,  CTF_SECTION_ENDNOTE_NUM_SUFFIX ),
    MS_E( PROP_EndnoteIsCollectAtTextEnd, XML_NAMESPACE_TEXT, XML_NOTES_CONFIGURATION, MID_FLAG_ELEMENT_ITEM|XML_TYPE_BOOL,    CTF_SECTION_ENDNOTE_END ),
    MS_E( PROP_UserDefinedAttributes,     XML_NAMESPACE_TEXT, XML_XMLNS,               XML_TYPE_ATTRIBUTE_CONTAINER | MID_FLAG_SPECIAL_ITEM, 0 ),
    // RES_EDIT_IN_READONLY
    MS_E( PROP_EditInReadonly, XML_NAMESPACE_STYLE, XML_EDITABLE, XML_TYPE_BOOL, 0 ),
    M_END()
};

XMLPropertyMapEntry constexpr aXMLRubyPropMap[] =
{
    MR_E( PROP_RubyAdjust,    XML_NAMESPACE_STYLE,  XML_RUBY_ALIGN,    XML_TYPE_TEXT_RUBY_ADJUST,   0 ),
    MR_E( PROP_RubyIsAbove,   XML_NAMESPACE_STYLE,  XML_RUBY_POSITION, XML_TYPE_TEXT_RUBY_IS_ABOVE, 0 ),
    MR_EV( PROP_RubyPosition, XML_NAMESPACE_LO_EXT, XML_RUBY_POSITION, XML_TYPE_TEXT_RUBY_POSITION, 0, SvtSaveOptions::ODFSVER_FUTURE_EXTENDED),
    M_END()
};


XMLPropertyMapEntry constexpr aXMLTableDefaultsMap[] =
{
    // RES_COLLAPSING_BORDERS: only occurs in tables, but we need to
    // read/write the default for this item
    M_ED_( PROP_CollapsingBorders, XML_NAMESPACE_TABLE, XML_BORDER_MODEL, XML_TYPE_PROP_TABLE | XML_TYPE_BORDER_MODEL | MID_FLAG_NO_PROPERTY_IMPORT, CTF_BORDER_MODEL ),

    M_END()
};

XMLPropertyMapEntry constexpr aXMLTableRowDefaultsMap[] =
{
    // RES_ROW_SPLIT: only occurs in table rows, but we need to
    // read/write the default for this item
    M_ED_( PROP_IsSplitAllowed, XML_NAMESPACE_FO, XML_KEEP_TOGETHER, XML_TYPE_PROP_TABLE_ROW | XML_TYPE_TEXT_NKEEP | MID_FLAG_NO_PROPERTY_IMPORT, CTF_KEEP_TOGETHER ),

    M_END()
};

XMLPropertyMapEntry constexpr aXMLCellPropMap[] =
{
    MC_E( PROP_BackColor,            XML_NAMESPACE_FO,    XML_BACKGROUND_COLOR, XML_TYPE_COLORTRANSPARENT|MID_FLAG_MULTI_PROPERTY, 0 ),
    MC_E( PROP_LeftBorder,           XML_NAMESPACE_FO,    XML_BORDER_LEFT,      XML_TYPE_BORDER,                                   0 ),
    MC_E( PROP_RightBorder,          XML_NAMESPACE_FO,    XML_BORDER_RIGHT,     XML_TYPE_BORDER,                                   0 ),
    MC_E( PROP_TopBorder,            XML_NAMESPACE_FO,    XML_BORDER_TOP,       XML_TYPE_BORDER,                                   0 ),
    MC_E( PROP_BottomBorder,         XML_NAMESPACE_FO,    XML_BORDER_BOTTOM,    XML_TYPE_BORDER,                                   0 ),
    MC_E( PROP_BorderDistance,       XML_NAMESPACE_FO,    XML_PADDING,          XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY,          0 ),
    MC_E( PROP_LeftBorderDistance,   XML_NAMESPACE_FO,    XML_PADDING_LEFT,     XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY,          0 ),
    MC_E( PROP_RightBorderDistance,  XML_NAMESPACE_FO,    XML_PADDING_RIGHT,    XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY,          0 ),
    MC_E( PROP_TopBorderDistance,    XML_NAMESPACE_FO,    XML_PADDING_TOP,      XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY,          0 ),
    MC_E( PROP_BottomBorderDistance, XML_NAMESPACE_FO,    XML_PADDING_BOTTOM,   XML_TYPE_MEASURE|MID_FLAG_MULTI_PROPERTY,          0 ),
    MC_E( PROP_VertOrient,           XML_NAMESPACE_STYLE, XML_VERTICAL_ALIGN,   XML_TYPE_TEXT_VERTICAL_POS,                        0 ),
    MC_E( PROP_WritingMode,          XML_NAMESPACE_STYLE, XML_WRITING_MODE,     XML_TYPE_TEXT_WRITING_MODE_WITH_DEFAULT,           0 ),
    MC_E( PROP_NumberFormat,         XML_NAMESPACE_STYLE, XML_DATA_STYLE_NAME,  XML_TYPE_NUMBER|MID_FLAG_SPECIAL_ITEM_EXPORT,      0 ),
    // paragraph properties
    MP_E( PROP_ParaAdjust, XML_NAMESPACE_FO, XML_TEXT_ALIGN, XML_TYPE_TEXT_ADJUST, 0 ),
    // text properties
    MT_ED( PROP_CharColor,            XML_NAMESPACE_FO,     XML_COLOR,                   XML_TYPE_COLORAUTO|MID_FLAG_MERGE_PROPERTY,                0 ),
    MT_ED( PROP_CharColor,            XML_NAMESPACE_STYLE,  XML_USE_WINDOW_FONT_COLOR,   XML_TYPE_ISAUTOCOLOR|MID_FLAG_MERGE_PROPERTY,              0 ),
    MAP_EXT( PROP_CharComplexColor,   XML_NAMESPACE_LO_EXT, XML_CHAR_COMPLEX_COLOR,      XML_TYPE_COMPLEX_COLOR|XML_TYPE_PROP_TEXT|MID_FLAG_ELEMENT_ITEM, CTF_COMPLEX_COLOR),
    MT_E( PROP_CharShadowed,          XML_NAMESPACE_FO,     XML_TEXT_SHADOW,             XML_TYPE_TEXT_SHADOWED,                                    0 ),
    MT_E( PROP_CharContoured,         XML_NAMESPACE_STYLE,  XML_TEXT_OUTLINE,            XML_TYPE_BOOL,                                             0 ),
    MT_E( PROP_CharStrikeout,         XML_NAMESPACE_STYLE,  XML_TEXT_LINE_THROUGH_STYLE, XML_TYPE_TEXT_CROSSEDOUT_STYLE|MID_FLAG_MERGE_PROPERTY,    0 ),
    MT_E( PROP_CharStrikeout,         XML_NAMESPACE_STYLE,  XML_TEXT_LINE_THROUGH_TYPE,  XML_TYPE_TEXT_CROSSEDOUT_TYPE|MID_FLAG_MERGE_PROPERTY,     0 ),
    MT_E( PROP_CharStrikeout,         XML_NAMESPACE_STYLE,  XML_TEXT_LINE_THROUGH_WIDTH, XML_TYPE_TEXT_CROSSEDOUT_WIDTH|MID_FLAG_MERGE_PROPERTY,    0 ),
    MT_E( PROP_CharStrikeout,         XML_NAMESPACE_STYLE,  XML_TEXT_LINE_THROUGH_TEXT,  XML_TYPE_TEXT_CROSSEDOUT_TEXT|MID_FLAG_MERGE_PROPERTY,     0 ),
    MT_E( PROP_CharUnderline,         XML_NAMESPACE_STYLE,  XML_TEXT_UNDERLINE_STYLE,    XML_TYPE_TEXT_UNDERLINE_STYLE|MID_FLAG_MERGE_PROPERTY,     0 ),
    MT_E( PROP_CharUnderline,         XML_NAMESPACE_STYLE,  XML_TEXT_UNDERLINE_TYPE,     XML_TYPE_TEXT_UNDERLINE_TYPE|MID_FLAG_MERGE_PROPERTY,      0 ),
    MT_E( PROP_CharUnderline,         XML_NAMESPACE_STYLE,  XML_TEXT_UNDERLINE_WIDTH,    XML_TYPE_TEXT_UNDERLINE_WIDTH|MID_FLAG_MERGE_PROPERTY,     0 ),
    MT_E( PROP_CharUnderlineColor,    XML_NAMESPACE_STYLE,  XML_TEXT_UNDERLINE_COLOR,    XML_TYPE_TEXT_UNDERLINE_COLOR|MID_FLAG_MULTI_PROPERTY,     0 ),
    MT_E( PROP_CharUnderlineHasColor, XML_NAMESPACE_STYLE,  XML_TEXT_UNDERLINE_COLOR,    XML_TYPE_TEXT_UNDERLINE_HASCOLOR|MID_FLAG_MERGE_ATTRIBUTE, 0 ),
    // STANDARD FONT
    MT_ED( PROP_CharHeight, XML_NAMESPACE_FO, XML_FONT_SIZE,   XML_TYPE_CHAR_HEIGHT|MID_FLAG_MULTI_PROPERTY, 0 ),
    MT_E( PROP_CharWeight,  XML_NAMESPACE_FO, XML_FONT_WEIGHT, XML_TYPE_TEXT_WEIGHT,                         0 ),
    MT_E( PROP_CharPosture, XML_NAMESPACE_FO, XML_FONT_STYLE,  XML_TYPE_TEXT_POSTURE,                        0 ),
    // RES_CHRATR_FONT
    MT_ED( PROP_CharFontName,      XML_NAMESPACE_STYLE, XML_FONT_NAME,           XML_TYPE_STRING|MID_FLAG_SPECIAL_ITEM_IMPORT,              CTF_FONTNAME       ),
    MT_ED( PROP_CharFontName,      XML_NAMESPACE_FO,    XML_FONT_FAMILY,         XML_TYPE_TEXT_FONTFAMILYNAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTFAMILYNAME ),
    MT_ED( PROP_CharFontStyleName, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME,     XML_TYPE_STRING,                                           CTF_FONTSTYLENAME  ),
    MT_ED( PROP_CharFontFamily,    XML_NAMESPACE_STYLE, XML_FONT_FAMILY_GENERIC, XML_TYPE_TEXT_FONTFAMILY,                                  CTF_FONTFAMILY     ),
    MT_ED( PROP_CharFontPitch,     XML_NAMESPACE_STYLE, XML_FONT_PITCH,          XML_TYPE_TEXT_FONTPITCH,                                   CTF_FONTPITCH      ),
    MT_ED( PROP_CharFontCharSet,   XML_NAMESPACE_STYLE, XML_FONT_CHARSET,        XML_TYPE_TEXT_FONTENCODING,                                CTF_FONTCHARSET    ),
    // CJK FONT
    MT_ED( PROP_CharHeightAsian, XML_NAMESPACE_STYLE, XML_FONT_SIZE_ASIAN,   XML_TYPE_CHAR_HEIGHT|MID_FLAG_MULTI_PROPERTY, 0 ),
    MT_E( PROP_CharWeightAsian,  XML_NAMESPACE_STYLE, XML_FONT_WEIGHT_ASIAN, XML_TYPE_TEXT_WEIGHT,                         0 ),
    MT_E( PROP_CharPostureAsian, XML_NAMESPACE_STYLE, XML_FONT_STYLE_ASIAN,  XML_TYPE_TEXT_POSTURE,                        0 ),
    // RES_CHRATR_CJK_FONT
    MT_ED( PROP_CharFontNameAsian,      XML_NAMESPACE_STYLE, XML_FONT_NAME_ASIAN,           XML_TYPE_STRING|MID_FLAG_SPECIAL_ITEM_IMPORT,              CTF_FONTNAME_CJK       ),
    MT_ED( PROP_CharFontNameAsian,      XML_NAMESPACE_STYLE, XML_FONT_FAMILY_ASIAN,         XML_TYPE_TEXT_FONTFAMILYNAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTFAMILYNAME_CJK ),
    MT_ED( PROP_CharFontStyleNameAsian, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME_ASIAN,     XML_TYPE_STRING,                                           CTF_FONTSTYLENAME_CJK  ),
    MT_ED( PROP_CharFontFamilyAsian,    XML_NAMESPACE_STYLE, XML_FONT_FAMILY_GENERIC_ASIAN, XML_TYPE_TEXT_FONTFAMILY,                                  CTF_FONTFAMILY_CJK     ),
    MT_ED( PROP_CharFontPitchAsian,     XML_NAMESPACE_STYLE, XML_FONT_PITCH_ASIAN,          XML_TYPE_TEXT_FONTPITCH,                                   CTF_FONTPITCH_CJK      ),
    MT_ED( PROP_CharFontCharSetAsian,   XML_NAMESPACE_STYLE, XML_FONT_CHARSET_ASIAN,        XML_TYPE_TEXT_FONTENCODING,                                CTF_FONTCHARSET_CJK    ),
    // CTL FONT
    MT_ED( PROP_CharHeightComplex, XML_NAMESPACE_STYLE, XML_FONT_SIZE_COMPLEX,   XML_TYPE_CHAR_HEIGHT|MID_FLAG_MULTI_PROPERTY, 0),
    MT_E( PROP_CharWeightComplex,  XML_NAMESPACE_STYLE, XML_FONT_WEIGHT_COMPLEX, XML_TYPE_TEXT_WEIGHT,                         0),
    MT_E( PROP_CharPostureComplex, XML_NAMESPACE_STYLE, XML_FONT_STYLE_COMPLEX,  XML_TYPE_TEXT_POSTURE,                        0),
    // RES_CHRATR_CTL_FONT
    MT_ED( PROP_CharFontNameComplex,      XML_NAMESPACE_STYLE, XML_FONT_NAME_COMPLEX,           XML_TYPE_STRING|MID_FLAG_SPECIAL_ITEM_IMPORT,  CTF_FONTNAME_CTL),
    MT_ED( PROP_CharFontNameComplex,      XML_NAMESPACE_STYLE, XML_FONT_FAMILY_COMPLEX,         XML_TYPE_TEXT_FONTFAMILYNAME|MID_FLAG_SPECIAL_ITEM_IMPORT, CTF_FONTFAMILYNAME_CTL),
    MT_ED( PROP_CharFontStyleNameComplex, XML_NAMESPACE_STYLE, XML_FONT_STYLE_NAME_COMPLEX,     XML_TYPE_STRING, CTF_FONTSTYLENAME_CTL),
    MT_ED( PROP_CharFontFamilyComplex,    XML_NAMESPACE_STYLE, XML_FONT_FAMILY_GENERIC_COMPLEX, XML_TYPE_TEXT_FONTFAMILY, CTF_FONTFAMILY_CTL),
    MT_ED( PROP_CharFontPitchComplex,     XML_NAMESPACE_STYLE, XML_FONT_PITCH_COMPLEX,          XML_TYPE_TEXT_FONTPITCH, CTF_FONTPITCH_CTL),
    MT_ED( PROP_CharFontCharSetComplex,   XML_NAMESPACE_STYLE, XML_FONT_CHARSET_COMPLEX,        XML_TYPE_TEXT_FONTENCODING, CTF_FONTCHARSET_CTL),

    M_END()
};

static XMLPropertyMapEntry const *lcl_txtprmap_getMap( TextPropMap nType )
{
    XMLPropertyMapEntry const *pMap = nullptr;
    switch( nType )
    {
    case TextPropMap::TEXT:
        pMap = aXMLTextPropMap;
        break;
    case TextPropMap::SHAPE_PARA:
        // #i125045# use [21] instead of [1] for text props for Shapes, indices
        // [1..20] contain the DrawingLayer FillStyle attributes corresponding to
        // [XATTR_FILL_FIRST .. XATTR_FILL_LAST] and would be double since Shapes
        // already contain these (usually in aXMLSDProperties)
        pMap = &(aXMLParaPropMap[21]);
        assert( pMap->meXMLName == XML_MARGIN && " shape para map changed" );
        break;
    case TextPropMap::PARA:
        pMap = aXMLParaPropMap;
        break;
    case TextPropMap::FRAME:
        pMap = aXMLFramePropMap;
        break;
    case TextPropMap::AUTO_FRAME:
        pMap = &(aXMLFramePropMap[13]);
        assert( pMap->meXMLName == XML_MARGIN && " frame map changed" );
        break;
    case TextPropMap::SHAPE:
        pMap = aXMLShapePropMap;
        break;
    case TextPropMap::SECTION:
        pMap = aXMLSectionPropMap;
        break;
    case TextPropMap::RUBY:
        pMap = aXMLRubyPropMap;
        break;
    case TextPropMap::TEXT_ADDITIONAL_DEFAULTS:
        pMap = aXMLAdditionalTextDefaultsMap;
        break;
    case TextPropMap::TABLE_DEFAULTS:
        pMap = aXMLTableDefaultsMap;
        break;
    case TextPropMap::TABLE_ROW_DEFAULTS:
        pMap = aXMLTableRowDefaultsMap;
        break;
    case TextPropMap::CELL:
        pMap = aXMLCellPropMap;
        break;
    }
    SAL_WARN_IF( !pMap, "xmloff", "illegal map type" );
    return pMap;
}

const XMLPropertyMapEntry* XMLTextPropertySetMapper::getPropertyMapForType( TextPropMap _nType )
{
    return lcl_txtprmap_getMap( _nType );
}

XMLTextPropertySetMapper::XMLTextPropertySetMapper( TextPropMap nType, bool bForExport ) :
    XMLPropertySetMapper( lcl_txtprmap_getMap( nType ),
                          new XMLTextPropertyHandlerFactory, bForExport )
{
}

XMLTextPropertySetMapper::~XMLTextPropertySetMapper()
{
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
