/* computer-player.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from computer-player.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Reversi, also known as Iagno.

   Copyright 2010-2013 Robert Ancell
   Copyright 2013-2014 Michael Catanzaro
   Copyright 2014-2019 Arnaud Bonatti

   GNOME Reversi is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Reversi is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME Reversi.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_COMPUTER_PLAYER (computer_player_get_type ())
#define COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayer))
#define COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))
#define IS_COMPUTER_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPUTER_PLAYER))
#define IS_COMPUTER_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPUTER_PLAYER))
#define COMPUTER_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPUTER_PLAYER, ComputerPlayerClass))

typedef struct _ComputerPlayer ComputerPlayer;
typedef struct _ComputerPlayerClass ComputerPlayerClass;
typedef struct _ComputerPlayerPrivate ComputerPlayerPrivate;

#define TYPE_POSSIBLE_MOVE (possible_move_get_type ())
typedef struct _PossibleMove PossibleMove;
enum  {
	COMPUTER_PLAYER_0_PROPERTY,
	COMPUTER_PLAYER_MOVE_PENDING_PROPERTY,
	COMPUTER_PLAYER_NUM_PROPERTIES
};
static GParamSpec* computer_player_properties[COMPUTER_PLAYER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block3Data Block3Data;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
typedef struct _ComputerPlayerMoveAsyncData ComputerPlayerMoveAsyncData;

struct _PossibleMove {
	guint8 x;
	guint8 y;
	guint8 n_tiles;
	guint8 n_tiles_n;
	guint8 n_tiles_ne;
	guint8 n_tiles_e;
	guint8 n_tiles_se;
	guint8 n_tiles_s;
	guint8 n_tiles_so;
	guint8 n_tiles_o;
	guint8 n_tiles_no;
};

struct _ComputerPlayer {
	GObject parent_instance;
	ComputerPlayerPrivate * priv;
};

struct _ComputerPlayerClass {
	GObjectClass parent_class;
	void (*run_search) (ComputerPlayer* self, PossibleMove* chosen_move);
	void (*complete_move) (ComputerPlayer* self, PossibleMove* chosen_move);
};

struct _ComputerPlayerPrivate {
	guint pending_move_id;
	gboolean _move_pending;
	GRecMutex _move_pending_mutex;
};

struct _Block3Data {
	int _ref_count_;
	ComputerPlayer* self;
	PossibleMove best_move;
	gpointer _async_data_;
};

struct _ComputerPlayerMoveAsyncData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	ComputerPlayer* self;
	gdouble delay_seconds;
	Block3Data* _data3_;
	GTimer* timer;
	GTimer* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GTimer* _tmp3_;
	GThread* _tmp4_;
	GThread* _tmp5_;
	GTimer* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	GTimer* _tmp9_;
	GTimer* _tmp10_;
};

static gint ComputerPlayer_private_offset;
static gpointer computer_player_parent_class = NULL;

VALA_EXTERN GType computer_player_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ComputerPlayer, g_object_unref)
VALA_EXTERN GType possible_move_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PossibleMove* possible_move_dup (const PossibleMove* self);
VALA_EXTERN void possible_move_free (PossibleMove* self);
VALA_EXTERN void computer_player_run_search (ComputerPlayer* self,
                                 PossibleMove* chosen_move);
VALA_EXTERN void computer_player_complete_move (ComputerPlayer* self,
                                    PossibleMove* chosen_move);
VALA_EXTERN void computer_player_move_sync (ComputerPlayer* self,
                                guint8* x,
                                guint8* y);
static void computer_player_set_move_pending (ComputerPlayer* self,
                                       gboolean value);
VALA_EXTERN void computer_player_move (ComputerPlayer* self,
                           gdouble delay_seconds);
static void computer_player_move_async (ComputerPlayer* self,
                                 gdouble delay_seconds,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static void computer_player_move_finish (ComputerPlayer* self,
                                  GAsyncResult* _res_);
static void computer_player_move_async_data_free (gpointer _data);
static gboolean computer_player_move_async_co (ComputerPlayerMoveAsyncData* _data_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
VALA_EXTERN void possible_move_init (PossibleMove *self,
                         guint8 x,
                         guint8 y);
VALA_EXTERN gboolean computer_player_get_move_pending (ComputerPlayer* self);
static gboolean _computer_player_move_async_co_gsource_func (gpointer self);
static void* __lambda13_ (Block3Data* _data3_);
static gpointer ___lambda13__gthread_func (gpointer self);
static gboolean __lambda14_ (Block3Data* _data3_);
static gboolean ___lambda14__gsource_func (gpointer self);
VALA_EXTERN void computer_player_cancel_move (ComputerPlayer* self);
static void computer_player_real_run_search (ComputerPlayer* self,
                                      PossibleMove* chosen_move);
static void computer_player_real_complete_move (ComputerPlayer* self,
                                         PossibleMove* chosen_move);
VALA_EXTERN ComputerPlayer* computer_player_construct (GType object_type);
static void computer_player_finalize (GObject * obj);
static GType computer_player_get_type_once (void);
static void _vala_computer_player_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec);
static void _vala_computer_player_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);

static inline gpointer
computer_player_get_instance_private (ComputerPlayer* self)
{
	return G_STRUCT_MEMBER_P (self, ComputerPlayer_private_offset);
}

void
computer_player_move_sync (ComputerPlayer* self,
                           guint8* x,
                           guint8* y)
{
	guint8 _vala_x = 0U;
	guint8 _vala_y = 0U;
	PossibleMove best_move = {0};
	PossibleMove _tmp0_ = {0};
	PossibleMove _tmp1_;
	PossibleMove _tmp2_;
	PossibleMove _tmp3_;
	g_return_if_fail (self != NULL);
	computer_player_set_move_pending (self, TRUE);
	computer_player_run_search (self, &_tmp0_);
	best_move = _tmp0_;
	computer_player_set_move_pending (self, FALSE);
	_tmp1_ = best_move;
	computer_player_complete_move (self, &_tmp1_);
	_tmp2_ = best_move;
	_vala_x = _tmp2_.x;
	_tmp3_ = best_move;
	_vala_y = _tmp3_.y;
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
}

void
computer_player_move (ComputerPlayer* self,
                      gdouble delay_seconds)
{
	g_return_if_fail (self != NULL);
	computer_player_move_async (self, delay_seconds, NULL, NULL);
}

static void
computer_player_move_async_data_free (gpointer _data)
{
	ComputerPlayerMoveAsyncData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (ComputerPlayerMoveAsyncData, _data_);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
computer_player_move_async (ComputerPlayer* self,
                            gdouble delay_seconds,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	ComputerPlayerMoveAsyncData* _data_;
	ComputerPlayer* _tmp0_;
	g_return_if_fail (self != NULL);
	_data_ = g_slice_new0 (ComputerPlayerMoveAsyncData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, computer_player_move_async_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_data_->delay_seconds = delay_seconds;
	computer_player_move_async_co (_data_);
}

static void
computer_player_move_finish (ComputerPlayer* self,
                             GAsyncResult* _res_)
{
	ComputerPlayerMoveAsyncData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		ComputerPlayer* self;
		self = _data3_->self;
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
_computer_player_move_async_co_gsource_func (gpointer self)
{
	gboolean result;
	result = computer_player_move_async_co (self);
	return result;
}

static void*
__lambda13_ (Block3Data* _data3_)
{
	ComputerPlayer* self;
	PossibleMove _tmp0_ = {0};
	void* result;
	self = _data3_->self;
	computer_player_set_move_pending (self, TRUE);
	computer_player_run_search (self, &_tmp0_);
	_data3_->best_move = _tmp0_;
	computer_player_move_async_co (_data3_->_async_data_);
	result = NULL;
	return result;
}

static gpointer
___lambda13__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda13_ (self);
	block3_data_unref (self);
	return result;
}

static gboolean
__lambda14_ (Block3Data* _data3_)
{
	ComputerPlayer* self;
	PossibleMove _tmp0_;
	gboolean result;
	self = _data3_->self;
	_tmp0_ = _data3_->best_move;
	computer_player_complete_move (self, &_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda14_ (self);
	return result;
}

static gboolean
computer_player_move_async_co (ComputerPlayerMoveAsyncData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data3_ = g_slice_new0 (Block3Data);
	_data_->_data3_->_ref_count_ = 1;
	_data_->_data3_->self = g_object_ref (_data_->self);
	_data_->_data3_->_async_data_ = _data_;
	_data_->_tmp0_ = g_timer_new ();
	_data_->timer = _data_->_tmp0_;
	possible_move_init (&_data_->_data3_->best_move, (guint8) 0, (guint8) 0);
	while (TRUE) {
		_data_->_tmp1_ = computer_player_get_move_pending (_data_->self);
		_data_->_tmp2_ = _data_->_tmp1_;
		if (!_data_->_tmp2_) {
			break;
		}
		g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _computer_player_move_async_co_gsource_func, _data_, NULL);
		_data_->_state_ = 1;
		return FALSE;
		_state_1:
		;
	}
	_data_->_tmp3_ = _data_->timer;
	g_timer_start (_data_->_tmp3_);
	_data_->_tmp4_ = g_thread_new ("AI thread", ___lambda13__gthread_func, block3_data_ref (_data_->_data3_));
	_data_->_tmp5_ = _data_->_tmp4_;
	_g_thread_unref0 (_data_->_tmp5_);
	_data_->_state_ = 2;
	return FALSE;
	_state_2:
	;
	_data_->_tmp6_ = _data_->timer;
	g_timer_stop (_data_->_tmp6_);
	_data_->_tmp7_ = computer_player_get_move_pending (_data_->self);
	_data_->_tmp8_ = _data_->_tmp7_;
	if (!_data_->_tmp8_) {
		_g_timer_destroy0 (_data_->timer);
		block3_data_unref (_data_->_data3_);
		_data_->_data3_ = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp9_ = _data_->timer;
	if (g_timer_elapsed (_data_->_tmp9_, NULL) < _data_->delay_seconds) {
		_data_->_tmp10_ = _data_->timer;
		_data_->self->priv->pending_move_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) ((_data_->delay_seconds - g_timer_elapsed (_data_->_tmp10_, NULL)) * 1000), _computer_player_move_async_co_gsource_func, _data_, NULL);
		_data_->_state_ = 3;
		return FALSE;
		_state_3:
		;
	}
	_data_->self->priv->pending_move_id = (guint) 0;
	computer_player_set_move_pending (_data_->self, FALSE);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda14__gsource_func, block3_data_ref (_data_->_data3_), block3_data_unref);
	_g_timer_destroy0 (_data_->timer);
	block3_data_unref (_data_->_data3_);
	_data_->_data3_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

void
computer_player_cancel_move (ComputerPlayer* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = computer_player_get_move_pending (self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		return;
	}
	if (self->priv->pending_move_id != ((guint) 0)) {
		g_source_remove (self->priv->pending_move_id);
		self->priv->pending_move_id = (guint) 0;
	}
	computer_player_set_move_pending (self, FALSE);
}

static void
computer_player_real_run_search (ComputerPlayer* self,
                                 PossibleMove* chosen_move)
{
	g_critical ("Type `%s' does not implement abstract method `computer_player_run_search'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
computer_player_run_search (ComputerPlayer* self,
                            PossibleMove* chosen_move)
{
	ComputerPlayerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = COMPUTER_PLAYER_GET_CLASS (self);
	if (_klass_->run_search) {
		_klass_->run_search (self, chosen_move);
	}
}

static void
computer_player_real_complete_move (ComputerPlayer* self,
                                    PossibleMove* chosen_move)
{
	g_critical ("Type `%s' does not implement abstract method `computer_player_complete_move'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
computer_player_complete_move (ComputerPlayer* self,
                               PossibleMove* chosen_move)
{
	ComputerPlayerClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = COMPUTER_PLAYER_GET_CLASS (self);
	if (_klass_->complete_move) {
		_klass_->complete_move (self, chosen_move);
	}
}

ComputerPlayer*
computer_player_construct (GType object_type)
{
	ComputerPlayer * self = NULL;
	self = (ComputerPlayer*) g_object_new (object_type, NULL);
	return self;
}

gboolean
computer_player_get_move_pending (ComputerPlayer* self)
{
	gboolean result;
	gboolean _result_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_rec_mutex_lock (&self->priv->_move_pending_mutex);
	_result_ = self->priv->_move_pending;
	g_rec_mutex_unlock (&self->priv->_move_pending_mutex);
	result = _result_;
	return result;
}

static void
computer_player_set_move_pending (ComputerPlayer* self,
                                  gboolean value)
{
	g_return_if_fail (self != NULL);
	g_rec_mutex_lock (&self->priv->_move_pending_mutex);
	self->priv->_move_pending = value;
	g_rec_mutex_unlock (&self->priv->_move_pending_mutex);
}

static void
computer_player_class_init (ComputerPlayerClass * klass,
                            gpointer klass_data)
{
	computer_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ComputerPlayer_private_offset);
	((ComputerPlayerClass *) klass)->run_search = (void (*) (ComputerPlayer*, PossibleMove*)) computer_player_real_run_search;
	((ComputerPlayerClass *) klass)->complete_move = (void (*) (ComputerPlayer*, PossibleMove*)) computer_player_real_complete_move;
	G_OBJECT_CLASS (klass)->get_property = _vala_computer_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_computer_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = computer_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), COMPUTER_PLAYER_MOVE_PENDING_PROPERTY, computer_player_properties[COMPUTER_PLAYER_MOVE_PENDING_PROPERTY] = g_param_spec_boolean ("move-pending", "move-pending", "move-pending", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
computer_player_instance_init (ComputerPlayer * self,
                               gpointer klass)
{
	self->priv = computer_player_get_instance_private (self);
	self->priv->pending_move_id = (guint) 0;
	self->priv->_move_pending = FALSE;
}

static void
computer_player_finalize (GObject * obj)
{
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPUTER_PLAYER, ComputerPlayer);
	_vala_clear_GRecMutex (&self->priv->_move_pending_mutex);
	G_OBJECT_CLASS (computer_player_parent_class)->finalize (obj);
}

static GType
computer_player_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ComputerPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) computer_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ComputerPlayer), 0, (GInstanceInitFunc) computer_player_instance_init, NULL };
	GType computer_player_type_id;
	computer_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ComputerPlayer", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ComputerPlayer_private_offset = g_type_add_instance_private (computer_player_type_id, sizeof (ComputerPlayerPrivate));
	return computer_player_type_id;
}

GType
computer_player_get_type (void)
{
	static volatile gsize computer_player_type_id__once = 0;
	if (g_once_init_enter (&computer_player_type_id__once)) {
		GType computer_player_type_id;
		computer_player_type_id = computer_player_get_type_once ();
		g_once_init_leave (&computer_player_type_id__once, computer_player_type_id);
	}
	return computer_player_type_id__once;
}

static void
_vala_computer_player_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec)
{
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
	switch (property_id) {
		case COMPUTER_PLAYER_MOVE_PENDING_PROPERTY:
		g_value_set_boolean (value, computer_player_get_move_pending (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_computer_player_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec)
{
	ComputerPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_COMPUTER_PLAYER, ComputerPlayer);
	switch (property_id) {
		case COMPUTER_PLAYER_MOVE_PENDING_PROPERTY:
		computer_player_set_move_pending (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

