#include <tree_sitter/parser.h>

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 684
#define LARGE_STATE_COUNT 118
#define SYMBOL_COUNT 197
#define ALIAS_COUNT 6
#define TOKEN_COUNT 125
#define EXTERNAL_TOKEN_COUNT 1
#define FIELD_COUNT 13
#define MAX_ALIAS_SEQUENCE_LENGTH 15
#define PRODUCTION_ID_COUNT 40

enum {
  sym_identifier = 1,
  anon_sym_SEMI = 2,
  anon_sym__ = 3,
  anon_sym_BANG = 4,
  anon_sym_EQ = 5,
  anon_sym_LPAREN = 6,
  anon_sym_RPAREN = 7,
  anon_sym_DOT = 8,
  anon_sym_LBRACE = 9,
  anon_sym_RBRACE = 10,
  anon_sym_arg = 11,
  anon_sym_COMMA = 12,
  anon_sym_DOT_DOT_DOT = 13,
  anon_sym_PIPE = 14,
  anon_sym_ = 15,
  anon_sym_COLON = 16,
  anon_sym_pi = 17,
  sym_integer = 18,
  sym_hexinteger = 19,
  sym_float = 20,
  sym_exponential = 21,
  anon_sym_BSLASH = 22,
  aux_sym_symbol_token1 = 23,
  anon_sym_SQUOTE = 24,
  aux_sym_symbol_token2 = 25,
  sym_char = 26,
  anon_sym_DQUOTE = 27,
  aux_sym_string_token1 = 28,
  anon_sym_true = 29,
  anon_sym_false = 30,
  sym_escape_sequence = 31,
  anon_sym_inf = 32,
  anon_sym_nil = 33,
  anon_sym_thisFunction = 34,
  anon_sym_thisFunctionDef = 35,
  anon_sym_thisMethod = 36,
  anon_sym_thisProcess = 37,
  anon_sym_thisThread = 38,
  anon_sym_currentEnvironment = 39,
  anon_sym_topEnvironment = 40,
  anon_sym_var = 41,
  anon_sym_LT = 42,
  anon_sym_GT = 43,
  anon_sym_LT_GT = 44,
  anon_sym_classvar = 45,
  anon_sym_const = 46,
  aux_sym_environment_var_token1 = 47,
  anon_sym_TILDE = 48,
  anon_sym_CARET = 49,
  anon_sym_PLUS = 50,
  anon_sym_STAR = 51,
  aux_sym_line_comment_token1 = 52,
  sym_ref = 53,
  anon_sym_POUND = 54,
  anon_sym_LBRACK = 55,
  anon_sym_RBRACK = 56,
  anon_sym_DASH_GT = 57,
  anon_sym_Bag = 58,
  anon_sym_Dictionary = 59,
  anon_sym_Environment = 60,
  anon_sym_Event = 61,
  anon_sym_IdentityBag = 62,
  anon_sym_IdentityDictionary = 63,
  anon_sym_IdentitySet = 64,
  anon_sym_LazyEnvir = 65,
  anon_sym_MultiLevelIdentityDictionary = 66,
  anon_sym_ObjectTable = 67,
  anon_sym_Set = 68,
  anon_sym_TwoWayIdentityDictionary = 69,
  anon_sym_Array = 70,
  anon_sym_Array2D = 71,
  anon_sym_ArrayedCollection = 72,
  anon_sym_DoubleArray = 73,
  anon_sym_FloatArray = 74,
  anon_sym_Int16Array = 75,
  anon_sym_Int32Array = 76,
  anon_sym_Int8Array = 77,
  anon_sym_LinkedList = 78,
  anon_sym_List = 79,
  anon_sym_Order = 80,
  anon_sym_OrderedIdentitySet = 81,
  anon_sym_Pair = 82,
  anon_sym_PriorityQueue = 83,
  anon_sym_RawArray = 84,
  anon_sym_SequenceableCollection = 85,
  anon_sym_Signal = 86,
  anon_sym_SortedList = 87,
  anon_sym_SparseArray = 88,
  anon_sym_String = 89,
  anon_sym_SymbolArray = 90,
  anon_sym_DOT_DOT = 91,
  anon_sym_PIPE_AT_PIPE = 92,
  anon_sym_AT_AT = 93,
  anon_sym_AT_PIPE_AT = 94,
  aux_sym_binary_expression_token1 = 95,
  anon_sym_AMP_AMP = 96,
  anon_sym_PIPE_PIPE = 97,
  anon_sym_AMP = 98,
  anon_sym_EQ_EQ = 99,
  anon_sym_BANG_EQ = 100,
  anon_sym_LT_EQ = 101,
  anon_sym_GT_EQ = 102,
  anon_sym_LT_LT = 103,
  anon_sym_GT_GT = 104,
  anon_sym_DASH = 105,
  anon_sym_PLUS_PLUS = 106,
  anon_sym_SLASH = 107,
  anon_sym_PERCENT = 108,
  anon_sym_STAR_STAR = 109,
  anon_sym_PLUS_SLASH_PLUS = 110,
  aux_sym_class_token1 = 111,
  anon_sym_QMARK = 112,
  anon_sym_BANG_QMARK = 113,
  anon_sym_QMARK_QMARK = 114,
  anon_sym_if = 115,
  anon_sym_while = 116,
  anon_sym_DOTwhile = 117,
  anon_sym_for = 118,
  anon_sym_DOTfor = 119,
  anon_sym_forBy = 120,
  anon_sym_DOTforBy = 121,
  anon_sym_case = 122,
  anon_sym_switch = 123,
  sym_block_comment = 124,
  sym_source_file = 125,
  sym__expression = 126,
  sym__expression_statement = 127,
  sym__object = 128,
  sym_partial = 129,
  sym_duplicated_statement = 130,
  sym_function_definition = 131,
  sym_function_call = 132,
  sym_method_call = 133,
  sym_instance_variable_setter_call = 134,
  sym__expression_sequence = 135,
  sym_code_block = 136,
  sym_function_block = 137,
  sym__function_content = 138,
  sym_parameter_list = 139,
  sym_argument = 140,
  sym_parameter_call_list = 141,
  sym_argument_calls = 142,
  sym_unnamed_argument = 143,
  sym_named_argument = 144,
  sym_literal = 145,
  sym_number = 146,
  sym_symbol = 147,
  sym_string = 148,
  sym_bool = 149,
  sym_variable = 150,
  sym_builtin_var = 151,
  sym_local_var = 152,
  sym_instance_var = 153,
  sym_classvar = 154,
  sym_const = 155,
  sym_environment_var = 156,
  sym_variable_definition_sequence = 157,
  sym_variable_definition = 158,
  sym_return_statement = 159,
  sym_class_def = 160,
  sym_line_comment = 161,
  sym_collection = 162,
  sym__collection_sequence = 163,
  sym__paired_associative_sequence = 164,
  sym_association = 165,
  sym_associative_item = 166,
  sym_indexed_collection = 167,
  sym__index = 168,
  sym_arithmetic_series = 169,
  sym_binary_expression = 170,
  sym_unary_expression = 171,
  sym_class = 172,
  sym_nil_check = 173,
  sym_control_structure = 174,
  sym_if = 175,
  sym_while = 176,
  sym_for = 177,
  sym_forby = 178,
  sym_case = 179,
  sym_switch = 180,
  aux_sym_source_file_repeat1 = 181,
  aux_sym_function_call_repeat1 = 182,
  aux_sym__expression_sequence_repeat1 = 183,
  aux_sym_parameter_list_repeat1 = 184,
  aux_sym_parameter_list_repeat2 = 185,
  aux_sym_parameter_call_list_repeat1 = 186,
  aux_sym_string_repeat1 = 187,
  aux_sym_variable_definition_sequence_repeat1 = 188,
  aux_sym_class_def_repeat1 = 189,
  aux_sym_class_def_repeat2 = 190,
  aux_sym__collection_sequence_repeat1 = 191,
  aux_sym__paired_associative_sequence_repeat1 = 192,
  aux_sym_indexed_collection_repeat1 = 193,
  aux_sym_case_repeat1 = 194,
  aux_sym_switch_repeat1 = 195,
  aux_sym_switch_repeat2 = 196,
  alias_sym_class_method_name = 197,
  alias_sym_collection_type = 198,
  alias_sym_instance_method_name = 199,
  alias_sym_item = 200,
  alias_sym_parent_class = 201,
  alias_sym_receiver = 202,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_SEMI] = ";",
  [anon_sym__] = "_",
  [anon_sym_BANG] = "!",
  [anon_sym_EQ] = "=",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_DOT] = ".",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_arg] = "arg",
  [anon_sym_COMMA] = ",",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_PIPE] = "|",
  [anon_sym_] = " ",
  [anon_sym_COLON] = ":",
  [anon_sym_pi] = "pi",
  [sym_integer] = "integer",
  [sym_hexinteger] = "hexinteger",
  [sym_float] = "float",
  [sym_exponential] = "exponential",
  [anon_sym_BSLASH] = "\\",
  [aux_sym_symbol_token1] = "symbol_token1",
  [anon_sym_SQUOTE] = "'",
  [aux_sym_symbol_token2] = "symbol_token2",
  [sym_char] = "char",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_string_token1] = "string_token1",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_escape_sequence] = "escape_sequence",
  [anon_sym_inf] = "inf",
  [anon_sym_nil] = "nil",
  [anon_sym_thisFunction] = "thisFunction",
  [anon_sym_thisFunctionDef] = "thisFunctionDef",
  [anon_sym_thisMethod] = "thisMethod",
  [anon_sym_thisProcess] = "thisProcess",
  [anon_sym_thisThread] = "thisThread",
  [anon_sym_currentEnvironment] = "currentEnvironment",
  [anon_sym_topEnvironment] = "topEnvironment",
  [anon_sym_var] = "var",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_GT] = "<>",
  [anon_sym_classvar] = "classvar",
  [anon_sym_const] = "const",
  [aux_sym_environment_var_token1] = "identifier",
  [anon_sym_TILDE] = "identifier",
  [anon_sym_CARET] = "^",
  [anon_sym_PLUS] = "+",
  [anon_sym_STAR] = "*",
  [aux_sym_line_comment_token1] = "line_comment_token1",
  [sym_ref] = "ref",
  [anon_sym_POUND] = "#",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_Bag] = "Bag",
  [anon_sym_Dictionary] = "Dictionary",
  [anon_sym_Environment] = "Environment",
  [anon_sym_Event] = "Event",
  [anon_sym_IdentityBag] = "IdentityBag",
  [anon_sym_IdentityDictionary] = "IdentityDictionary",
  [anon_sym_IdentitySet] = "IdentitySet",
  [anon_sym_LazyEnvir] = "LazyEnvir",
  [anon_sym_MultiLevelIdentityDictionary] = "MultiLevelIdentityDictionary",
  [anon_sym_ObjectTable] = "ObjectTable",
  [anon_sym_Set] = "Set",
  [anon_sym_TwoWayIdentityDictionary] = "TwoWayIdentityDictionary",
  [anon_sym_Array] = "Array",
  [anon_sym_Array2D] = "Array2D",
  [anon_sym_ArrayedCollection] = "ArrayedCollection",
  [anon_sym_DoubleArray] = "DoubleArray",
  [anon_sym_FloatArray] = "FloatArray",
  [anon_sym_Int16Array] = "Int16Array",
  [anon_sym_Int32Array] = "Int32Array",
  [anon_sym_Int8Array] = "Int8Array",
  [anon_sym_LinkedList] = "LinkedList",
  [anon_sym_List] = "List",
  [anon_sym_Order] = "Order",
  [anon_sym_OrderedIdentitySet] = "OrderedIdentitySet",
  [anon_sym_Pair] = "Pair",
  [anon_sym_PriorityQueue] = "PriorityQueue",
  [anon_sym_RawArray] = "RawArray",
  [anon_sym_SequenceableCollection] = "SequenceableCollection",
  [anon_sym_Signal] = "Signal",
  [anon_sym_SortedList] = "SortedList",
  [anon_sym_SparseArray] = "SparseArray",
  [anon_sym_String] = "String",
  [anon_sym_SymbolArray] = "SymbolArray",
  [anon_sym_DOT_DOT] = "..",
  [anon_sym_PIPE_AT_PIPE] = "|@|",
  [anon_sym_AT_AT] = "@@",
  [anon_sym_AT_PIPE_AT] = "@|@",
  [aux_sym_binary_expression_token1] = "method_name",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_AMP] = "&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_DASH] = "-",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_PLUS_SLASH_PLUS] = "+/+",
  [aux_sym_class_token1] = "class_token1",
  [anon_sym_QMARK] = "\?",
  [anon_sym_BANG_QMARK] = "!\?",
  [anon_sym_QMARK_QMARK] = "\?\?",
  [anon_sym_if] = "if",
  [anon_sym_while] = "while",
  [anon_sym_DOTwhile] = ".while",
  [anon_sym_for] = "for",
  [anon_sym_DOTfor] = ".for",
  [anon_sym_forBy] = "forBy",
  [anon_sym_DOTforBy] = ".forBy",
  [anon_sym_case] = "case",
  [anon_sym_switch] = "switch",
  [sym_block_comment] = "block_comment",
  [sym_source_file] = "source_file",
  [sym__expression] = "_expression",
  [sym__expression_statement] = "_expression_statement",
  [sym__object] = "_object",
  [sym_partial] = "partial",
  [sym_duplicated_statement] = "duplicated_statement",
  [sym_function_definition] = "function_definition",
  [sym_function_call] = "function_call",
  [sym_method_call] = "method_call",
  [sym_instance_variable_setter_call] = "instance_variable_setter_call",
  [sym__expression_sequence] = "_expression_sequence",
  [sym_code_block] = "code_block",
  [sym_function_block] = "function_block",
  [sym__function_content] = "_function_content",
  [sym_parameter_list] = "parameter_list",
  [sym_argument] = "argument",
  [sym_parameter_call_list] = "parameter_call_list",
  [sym_argument_calls] = "argument_calls",
  [sym_unnamed_argument] = "unnamed_argument",
  [sym_named_argument] = "named_argument",
  [sym_literal] = "literal",
  [sym_number] = "number",
  [sym_symbol] = "symbol",
  [sym_string] = "string",
  [sym_bool] = "bool",
  [sym_variable] = "variable",
  [sym_builtin_var] = "builtin_var",
  [sym_local_var] = "local_var",
  [sym_instance_var] = "instance_var",
  [sym_classvar] = "classvar",
  [sym_const] = "const",
  [sym_environment_var] = "environment_var",
  [sym_variable_definition_sequence] = "variable_definition_sequence",
  [sym_variable_definition] = "variable_definition",
  [sym_return_statement] = "return_statement",
  [sym_class_def] = "class_def",
  [sym_line_comment] = "line_comment",
  [sym_collection] = "collection",
  [sym__collection_sequence] = "_collection_sequence",
  [sym__paired_associative_sequence] = "_paired_associative_sequence",
  [sym_association] = "association",
  [sym_associative_item] = "associative_item",
  [sym_indexed_collection] = "indexed_collection",
  [sym__index] = "_index",
  [sym_arithmetic_series] = "arithmetic_series",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_class] = "class",
  [sym_nil_check] = "nil_check",
  [sym_control_structure] = "control_structure",
  [sym_if] = "if",
  [sym_while] = "while",
  [sym_for] = "for",
  [sym_forby] = "forby",
  [sym_case] = "case",
  [sym_switch] = "switch",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_function_call_repeat1] = "function_call_repeat1",
  [aux_sym__expression_sequence_repeat1] = "_expression_sequence_repeat1",
  [aux_sym_parameter_list_repeat1] = "parameter_list_repeat1",
  [aux_sym_parameter_list_repeat2] = "parameter_list_repeat2",
  [aux_sym_parameter_call_list_repeat1] = "parameter_call_list_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_variable_definition_sequence_repeat1] = "variable_definition_sequence_repeat1",
  [aux_sym_class_def_repeat1] = "class_def_repeat1",
  [aux_sym_class_def_repeat2] = "class_def_repeat2",
  [aux_sym__collection_sequence_repeat1] = "_collection_sequence_repeat1",
  [aux_sym__paired_associative_sequence_repeat1] = "_paired_associative_sequence_repeat1",
  [aux_sym_indexed_collection_repeat1] = "indexed_collection_repeat1",
  [aux_sym_case_repeat1] = "case_repeat1",
  [aux_sym_switch_repeat1] = "switch_repeat1",
  [aux_sym_switch_repeat2] = "switch_repeat2",
  [alias_sym_class_method_name] = "class_method_name",
  [alias_sym_collection_type] = "collection_type",
  [alias_sym_instance_method_name] = "instance_method_name",
  [alias_sym_item] = "item",
  [alias_sym_parent_class] = "parent_class",
  [alias_sym_receiver] = "receiver",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [anon_sym__] = anon_sym__,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_arg] = anon_sym_arg,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_] = anon_sym_,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_pi] = anon_sym_pi,
  [sym_integer] = sym_integer,
  [sym_hexinteger] = sym_hexinteger,
  [sym_float] = sym_float,
  [sym_exponential] = sym_exponential,
  [anon_sym_BSLASH] = anon_sym_BSLASH,
  [aux_sym_symbol_token1] = aux_sym_symbol_token1,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [aux_sym_symbol_token2] = aux_sym_symbol_token2,
  [sym_char] = sym_char,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_string_token1] = aux_sym_string_token1,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_escape_sequence] = sym_escape_sequence,
  [anon_sym_inf] = anon_sym_inf,
  [anon_sym_nil] = anon_sym_nil,
  [anon_sym_thisFunction] = anon_sym_thisFunction,
  [anon_sym_thisFunctionDef] = anon_sym_thisFunctionDef,
  [anon_sym_thisMethod] = anon_sym_thisMethod,
  [anon_sym_thisProcess] = anon_sym_thisProcess,
  [anon_sym_thisThread] = anon_sym_thisThread,
  [anon_sym_currentEnvironment] = anon_sym_currentEnvironment,
  [anon_sym_topEnvironment] = anon_sym_topEnvironment,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_GT] = anon_sym_LT_GT,
  [anon_sym_classvar] = anon_sym_classvar,
  [anon_sym_const] = anon_sym_const,
  [aux_sym_environment_var_token1] = sym_identifier,
  [anon_sym_TILDE] = sym_identifier,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_STAR] = anon_sym_STAR,
  [aux_sym_line_comment_token1] = aux_sym_line_comment_token1,
  [sym_ref] = sym_ref,
  [anon_sym_POUND] = anon_sym_POUND,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_Bag] = anon_sym_Bag,
  [anon_sym_Dictionary] = anon_sym_Dictionary,
  [anon_sym_Environment] = anon_sym_Environment,
  [anon_sym_Event] = anon_sym_Event,
  [anon_sym_IdentityBag] = anon_sym_IdentityBag,
  [anon_sym_IdentityDictionary] = anon_sym_IdentityDictionary,
  [anon_sym_IdentitySet] = anon_sym_IdentitySet,
  [anon_sym_LazyEnvir] = anon_sym_LazyEnvir,
  [anon_sym_MultiLevelIdentityDictionary] = anon_sym_MultiLevelIdentityDictionary,
  [anon_sym_ObjectTable] = anon_sym_ObjectTable,
  [anon_sym_Set] = anon_sym_Set,
  [anon_sym_TwoWayIdentityDictionary] = anon_sym_TwoWayIdentityDictionary,
  [anon_sym_Array] = anon_sym_Array,
  [anon_sym_Array2D] = anon_sym_Array2D,
  [anon_sym_ArrayedCollection] = anon_sym_ArrayedCollection,
  [anon_sym_DoubleArray] = anon_sym_DoubleArray,
  [anon_sym_FloatArray] = anon_sym_FloatArray,
  [anon_sym_Int16Array] = anon_sym_Int16Array,
  [anon_sym_Int32Array] = anon_sym_Int32Array,
  [anon_sym_Int8Array] = anon_sym_Int8Array,
  [anon_sym_LinkedList] = anon_sym_LinkedList,
  [anon_sym_List] = anon_sym_List,
  [anon_sym_Order] = anon_sym_Order,
  [anon_sym_OrderedIdentitySet] = anon_sym_OrderedIdentitySet,
  [anon_sym_Pair] = anon_sym_Pair,
  [anon_sym_PriorityQueue] = anon_sym_PriorityQueue,
  [anon_sym_RawArray] = anon_sym_RawArray,
  [anon_sym_SequenceableCollection] = anon_sym_SequenceableCollection,
  [anon_sym_Signal] = anon_sym_Signal,
  [anon_sym_SortedList] = anon_sym_SortedList,
  [anon_sym_SparseArray] = anon_sym_SparseArray,
  [anon_sym_String] = anon_sym_String,
  [anon_sym_SymbolArray] = anon_sym_SymbolArray,
  [anon_sym_DOT_DOT] = anon_sym_DOT_DOT,
  [anon_sym_PIPE_AT_PIPE] = anon_sym_PIPE_AT_PIPE,
  [anon_sym_AT_AT] = anon_sym_AT_AT,
  [anon_sym_AT_PIPE_AT] = anon_sym_AT_PIPE_AT,
  [aux_sym_binary_expression_token1] = aux_sym_binary_expression_token1,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_PLUS_SLASH_PLUS] = anon_sym_PLUS_SLASH_PLUS,
  [aux_sym_class_token1] = aux_sym_class_token1,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_BANG_QMARK] = anon_sym_BANG_QMARK,
  [anon_sym_QMARK_QMARK] = anon_sym_QMARK_QMARK,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_DOTwhile] = anon_sym_DOTwhile,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_DOTfor] = anon_sym_DOTfor,
  [anon_sym_forBy] = anon_sym_forBy,
  [anon_sym_DOTforBy] = anon_sym_DOTforBy,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_switch] = anon_sym_switch,
  [sym_block_comment] = sym_block_comment,
  [sym_source_file] = sym_source_file,
  [sym__expression] = sym__expression,
  [sym__expression_statement] = sym__expression_statement,
  [sym__object] = sym__object,
  [sym_partial] = sym_partial,
  [sym_duplicated_statement] = sym_duplicated_statement,
  [sym_function_definition] = sym_function_definition,
  [sym_function_call] = sym_function_call,
  [sym_method_call] = sym_method_call,
  [sym_instance_variable_setter_call] = sym_instance_variable_setter_call,
  [sym__expression_sequence] = sym__expression_sequence,
  [sym_code_block] = sym_code_block,
  [sym_function_block] = sym_function_block,
  [sym__function_content] = sym__function_content,
  [sym_parameter_list] = sym_parameter_list,
  [sym_argument] = sym_argument,
  [sym_parameter_call_list] = sym_parameter_call_list,
  [sym_argument_calls] = sym_argument_calls,
  [sym_unnamed_argument] = sym_unnamed_argument,
  [sym_named_argument] = sym_named_argument,
  [sym_literal] = sym_literal,
  [sym_number] = sym_number,
  [sym_symbol] = sym_symbol,
  [sym_string] = sym_string,
  [sym_bool] = sym_bool,
  [sym_variable] = sym_variable,
  [sym_builtin_var] = sym_builtin_var,
  [sym_local_var] = sym_local_var,
  [sym_instance_var] = sym_instance_var,
  [sym_classvar] = sym_classvar,
  [sym_const] = sym_const,
  [sym_environment_var] = sym_environment_var,
  [sym_variable_definition_sequence] = sym_variable_definition_sequence,
  [sym_variable_definition] = sym_variable_definition,
  [sym_return_statement] = sym_return_statement,
  [sym_class_def] = sym_class_def,
  [sym_line_comment] = sym_line_comment,
  [sym_collection] = sym_collection,
  [sym__collection_sequence] = sym__collection_sequence,
  [sym__paired_associative_sequence] = sym__paired_associative_sequence,
  [sym_association] = sym_association,
  [sym_associative_item] = sym_associative_item,
  [sym_indexed_collection] = sym_indexed_collection,
  [sym__index] = sym__index,
  [sym_arithmetic_series] = sym_arithmetic_series,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_class] = sym_class,
  [sym_nil_check] = sym_nil_check,
  [sym_control_structure] = sym_control_structure,
  [sym_if] = sym_if,
  [sym_while] = sym_while,
  [sym_for] = sym_for,
  [sym_forby] = sym_forby,
  [sym_case] = sym_case,
  [sym_switch] = sym_switch,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_function_call_repeat1] = aux_sym_function_call_repeat1,
  [aux_sym__expression_sequence_repeat1] = aux_sym__expression_sequence_repeat1,
  [aux_sym_parameter_list_repeat1] = aux_sym_parameter_list_repeat1,
  [aux_sym_parameter_list_repeat2] = aux_sym_parameter_list_repeat2,
  [aux_sym_parameter_call_list_repeat1] = aux_sym_parameter_call_list_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_variable_definition_sequence_repeat1] = aux_sym_variable_definition_sequence_repeat1,
  [aux_sym_class_def_repeat1] = aux_sym_class_def_repeat1,
  [aux_sym_class_def_repeat2] = aux_sym_class_def_repeat2,
  [aux_sym__collection_sequence_repeat1] = aux_sym__collection_sequence_repeat1,
  [aux_sym__paired_associative_sequence_repeat1] = aux_sym__paired_associative_sequence_repeat1,
  [aux_sym_indexed_collection_repeat1] = aux_sym_indexed_collection_repeat1,
  [aux_sym_case_repeat1] = aux_sym_case_repeat1,
  [aux_sym_switch_repeat1] = aux_sym_switch_repeat1,
  [aux_sym_switch_repeat2] = aux_sym_switch_repeat2,
  [alias_sym_class_method_name] = alias_sym_class_method_name,
  [alias_sym_collection_type] = alias_sym_collection_type,
  [alias_sym_instance_method_name] = alias_sym_instance_method_name,
  [alias_sym_item] = alias_sym_item,
  [alias_sym_parent_class] = alias_sym_parent_class,
  [alias_sym_receiver] = alias_sym_receiver,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_arg] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pi] = {
    .visible = true,
    .named = false,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [sym_hexinteger] = {
    .visible = true,
    .named = true,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_exponential] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_symbol_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_symbol_token2] = {
    .visible = false,
    .named = false,
  },
  [sym_char] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_string_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_inf] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_nil] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thisFunction] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thisFunctionDef] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thisMethod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thisProcess] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_thisThread] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_currentEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_topEnvironment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_classvar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_const] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_environment_var_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_line_comment_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_ref] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_POUND] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Bag] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Dictionary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Environment] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IdentityBag] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IdentityDictionary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_IdentitySet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LazyEnvir] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_MultiLevelIdentityDictionary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ObjectTable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Set] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TwoWayIdentityDictionary] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Array2D] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ArrayedCollection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DoubleArray] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_FloatArray] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int16Array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int32Array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Int8Array] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LinkedList] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_List] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Order] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_OrderedIdentitySet] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Pair] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PriorityQueue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RawArray] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SequenceableCollection] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_Signal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SortedList] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SparseArray] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_String] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SymbolArray] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_AT_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_AT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AT_PIPE_AT] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_binary_expression_token1] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_SLASH_PLUS] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_class_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_QMARK_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTwhile] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTfor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_forBy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOTforBy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [sym_block_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym__expression_statement] = {
    .visible = false,
    .named = true,
  },
  [sym__object] = {
    .visible = false,
    .named = true,
  },
  [sym_partial] = {
    .visible = true,
    .named = true,
  },
  [sym_duplicated_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_method_call] = {
    .visible = true,
    .named = true,
  },
  [sym_instance_variable_setter_call] = {
    .visible = true,
    .named = true,
  },
  [sym__expression_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_code_block] = {
    .visible = true,
    .named = true,
  },
  [sym_function_block] = {
    .visible = true,
    .named = true,
  },
  [sym__function_content] = {
    .visible = false,
    .named = true,
  },
  [sym_parameter_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter_call_list] = {
    .visible = true,
    .named = true,
  },
  [sym_argument_calls] = {
    .visible = true,
    .named = true,
  },
  [sym_unnamed_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_named_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_number] = {
    .visible = true,
    .named = true,
  },
  [sym_symbol] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_bool] = {
    .visible = true,
    .named = true,
  },
  [sym_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_builtin_var] = {
    .visible = true,
    .named = true,
  },
  [sym_local_var] = {
    .visible = true,
    .named = true,
  },
  [sym_instance_var] = {
    .visible = true,
    .named = true,
  },
  [sym_classvar] = {
    .visible = true,
    .named = true,
  },
  [sym_const] = {
    .visible = true,
    .named = true,
  },
  [sym_environment_var] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_definition_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_class_def] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_collection] = {
    .visible = true,
    .named = true,
  },
  [sym__collection_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym__paired_associative_sequence] = {
    .visible = false,
    .named = true,
  },
  [sym_association] = {
    .visible = true,
    .named = true,
  },
  [sym_associative_item] = {
    .visible = true,
    .named = true,
  },
  [sym_indexed_collection] = {
    .visible = true,
    .named = true,
  },
  [sym__index] = {
    .visible = false,
    .named = true,
  },
  [sym_arithmetic_series] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym_nil_check] = {
    .visible = true,
    .named = true,
  },
  [sym_control_structure] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_for] = {
    .visible = true,
    .named = true,
  },
  [sym_forby] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym_switch] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__expression_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_list_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_parameter_call_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_definition_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_def_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_def_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__collection_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__paired_associative_sequence_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_indexed_collection_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_switch_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_class_method_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_collection_type] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_instance_method_name] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_item] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_parent_class] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_receiver] = {
    .visible = true,
    .named = true,
  },
};

enum {
  field_body_func = 1,
  field_duplicated_object = 2,
  field_duplication_times = 3,
  field_expression = 4,
  field_false = 5,
  field_index = 6,
  field_left = 7,
  field_name = 8,
  field_operator = 9,
  field_right = 10,
  field_test_func = 11,
  field_true = 12,
  field_value = 13,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_body_func] = "body_func",
  [field_duplicated_object] = "duplicated_object",
  [field_duplication_times] = "duplication_times",
  [field_expression] = "expression",
  [field_false] = "false",
  [field_index] = "index",
  [field_left] = "left",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_right] = "right",
  [field_test_func] = "test_func",
  [field_true] = "true",
  [field_value] = "value",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 2},
  [3] = {.index = 3, .length = 1},
  [4] = {.index = 4, .length = 2},
  [7] = {.index = 6, .length = 1},
  [8] = {.index = 7, .length = 1},
  [9] = {.index = 8, .length = 1},
  [10] = {.index = 9, .length = 3},
  [11] = {.index = 12, .length = 3},
  [12] = {.index = 3, .length = 1},
  [13] = {.index = 15, .length = 3},
  [14] = {.index = 18, .length = 2},
  [15] = {.index = 20, .length = 1},
  [16] = {.index = 21, .length = 2},
  [17] = {.index = 23, .length = 2},
  [19] = {.index = 25, .length = 4},
  [23] = {.index = 29, .length = 3},
  [25] = {.index = 32, .length = 3},
  [26] = {.index = 35, .length = 3},
  [27] = {.index = 38, .length = 2},
  [31] = {.index = 40, .length = 4},
  [33] = {.index = 44, .length = 4},
  [34] = {.index = 48, .length = 4},
  [35] = {.index = 52, .length = 3},
  [36] = {.index = 55, .length = 4},
  [37] = {.index = 59, .length = 3},
  [38] = {.index = 62, .length = 6},
  [39] = {.index = 68, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_operator, 0},
    {field_right, 1},
  [3] =
    {field_name, 1},
  [4] =
    {field_name, 0},
    {field_name, 1},
  [6] =
    {field_index, 0, .inherited = true},
  [7] =
    {field_index, 1, .inherited = true},
  [8] =
    {field_name, 2},
  [9] =
    {field_duplicated_object, 0},
    {field_duplication_times, 2},
    {field_operator, 1},
  [12] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [15] =
    {field_body_func, 2},
    {field_expression, 0},
    {field_name, 1},
  [18] =
    {field_name, 0},
    {field_value, 2},
  [20] =
    {field_index, 1},
  [21] =
    {field_index, 1, .inherited = true},
    {field_index, 2, .inherited = true},
  [23] =
    {field_index, 0, .inherited = true},
    {field_index, 1, .inherited = true},
  [25] =
    {field_expression, 0},
    {field_name, 1},
    {field_name, 2},
    {field_true, 3},
  [29] =
    {field_name, 0},
    {field_value, 1},
    {field_value, 2},
  [32] =
    {field_name, 0},
    {field_name, 1},
    {field_name, 2},
  [35] =
    {field_expression, 2},
    {field_name, 0},
    {field_true, 4},
  [38] =
    {field_index, 1},
    {field_index, 2},
  [40] =
    {field_name, 0},
    {field_value, 1},
    {field_value, 2},
    {field_value, 3},
  [44] =
    {field_expression, 2},
    {field_false, 5},
    {field_name, 0},
    {field_true, 4},
  [48] =
    {field_expression, 2},
    {field_name, 0},
    {field_true, 3},
    {field_true, 4},
  [52] =
    {field_body_func, 4},
    {field_name, 0},
    {field_test_func, 2},
  [55] =
    {field_expression, 0},
    {field_name, 1},
    {field_name, 2},
    {field_true, 4},
  [59] =
    {field_index, 1},
    {field_index, 2},
    {field_index, 3},
  [62] =
    {field_expression, 2},
    {field_false, 5},
    {field_false, 6},
    {field_name, 0},
    {field_true, 3},
    {field_true, 4},
  [68] =
    {field_expression, 0},
    {field_false, 5},
    {field_false, 6},
    {field_name, 1},
    {field_name, 2},
    {field_true, 4},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [4] = {
    [1] = sym_identifier,
  },
  [5] = {
    [0] = aux_sym_binary_expression_token1,
  },
  [6] = {
    [0] = alias_sym_receiver,
  },
  [12] = {
    [1] = aux_sym_binary_expression_token1,
  },
  [18] = {
    [2] = alias_sym_item,
  },
  [20] = {
    [0] = alias_sym_instance_method_name,
  },
  [21] = {
    [0] = sym_instance_var,
  },
  [22] = {
    [0] = alias_sym_collection_type,
  },
  [24] = {
    [1] = alias_sym_collection_type,
  },
  [28] = {
    [1] = alias_sym_class_method_name,
  },
  [29] = {
    [1] = sym_instance_var,
  },
  [30] = {
    [2] = alias_sym_parent_class,
  },
  [32] = {
    [3] = alias_sym_parent_class,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__object, 3,
    sym__object,
    alias_sym_item,
    alias_sym_receiver,
  sym_local_var, 2,
    sym_local_var,
    sym_instance_var,
  sym_class, 3,
    sym_class,
    alias_sym_collection_type,
    alias_sym_parent_class,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 3,
  [6] = 4,
  [7] = 4,
  [8] = 3,
  [9] = 9,
  [10] = 3,
  [11] = 4,
  [12] = 9,
  [13] = 13,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 16,
  [18] = 18,
  [19] = 19,
  [20] = 19,
  [21] = 19,
  [22] = 19,
  [23] = 16,
  [24] = 16,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 32,
  [33] = 33,
  [34] = 34,
  [35] = 33,
  [36] = 33,
  [37] = 37,
  [38] = 37,
  [39] = 39,
  [40] = 40,
  [41] = 39,
  [42] = 42,
  [43] = 42,
  [44] = 44,
  [45] = 40,
  [46] = 39,
  [47] = 47,
  [48] = 48,
  [49] = 37,
  [50] = 40,
  [51] = 42,
  [52] = 52,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 55,
  [58] = 58,
  [59] = 56,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 64,
  [72] = 72,
  [73] = 73,
  [74] = 69,
  [75] = 70,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 73,
  [81] = 81,
  [82] = 82,
  [83] = 78,
  [84] = 79,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 62,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 85,
  [94] = 87,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 68,
  [99] = 99,
  [100] = 65,
  [101] = 96,
  [102] = 92,
  [103] = 90,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 108,
  [117] = 111,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 129,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 106,
  [137] = 137,
  [138] = 109,
  [139] = 107,
  [140] = 104,
  [141] = 105,
  [142] = 113,
  [143] = 110,
  [144] = 112,
  [145] = 115,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 113,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 107,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 109,
  [223] = 223,
  [224] = 105,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 230,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 106,
  [238] = 115,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 104,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 112,
  [250] = 110,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 165,
  [256] = 256,
  [257] = 257,
  [258] = 151,
  [259] = 259,
  [260] = 259,
  [261] = 261,
  [262] = 257,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 167,
  [270] = 206,
  [271] = 213,
  [272] = 272,
  [273] = 273,
  [274] = 214,
  [275] = 275,
  [276] = 215,
  [277] = 277,
  [278] = 207,
  [279] = 219,
  [280] = 171,
  [281] = 210,
  [282] = 282,
  [283] = 176,
  [284] = 284,
  [285] = 189,
  [286] = 203,
  [287] = 211,
  [288] = 288,
  [289] = 212,
  [290] = 290,
  [291] = 208,
  [292] = 217,
  [293] = 185,
  [294] = 209,
  [295] = 216,
  [296] = 170,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 301,
  [303] = 303,
  [304] = 175,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 174,
  [309] = 298,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 256,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 282,
  [322] = 322,
  [323] = 323,
  [324] = 266,
  [325] = 264,
  [326] = 282,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 332,
  [336] = 336,
  [337] = 332,
  [338] = 338,
  [339] = 338,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 105,
  [350] = 112,
  [351] = 106,
  [352] = 109,
  [353] = 104,
  [354] = 110,
  [355] = 107,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 361,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 176,
  [370] = 171,
  [371] = 178,
  [372] = 175,
  [373] = 373,
  [374] = 175,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 175,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 381,
  [384] = 384,
  [385] = 385,
  [386] = 380,
  [387] = 380,
  [388] = 382,
  [389] = 384,
  [390] = 390,
  [391] = 384,
  [392] = 379,
  [393] = 381,
  [394] = 379,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 171,
  [419] = 419,
  [420] = 178,
  [421] = 421,
  [422] = 422,
  [423] = 176,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 191,
  [429] = 248,
  [430] = 228,
  [431] = 172,
  [432] = 432,
  [433] = 433,
  [434] = 432,
  [435] = 204,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 186,
  [442] = 198,
  [443] = 200,
  [444] = 444,
  [445] = 221,
  [446] = 446,
  [447] = 228,
  [448] = 448,
  [449] = 449,
  [450] = 248,
  [451] = 451,
  [452] = 221,
  [453] = 200,
  [454] = 201,
  [455] = 436,
  [456] = 456,
  [457] = 432,
  [458] = 458,
  [459] = 459,
  [460] = 186,
  [461] = 192,
  [462] = 193,
  [463] = 433,
  [464] = 173,
  [465] = 465,
  [466] = 229,
  [467] = 204,
  [468] = 172,
  [469] = 198,
  [470] = 173,
  [471] = 201,
  [472] = 229,
  [473] = 473,
  [474] = 474,
  [475] = 193,
  [476] = 433,
  [477] = 458,
  [478] = 478,
  [479] = 192,
  [480] = 191,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 487,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 487,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 382,
  [503] = 503,
  [504] = 504,
  [505] = 504,
  [506] = 504,
  [507] = 507,
  [508] = 508,
  [509] = 487,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 515,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 521,
  [522] = 520,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 529,
  [530] = 530,
  [531] = 531,
  [532] = 528,
  [533] = 533,
  [534] = 531,
  [535] = 535,
  [536] = 536,
  [537] = 514,
  [538] = 528,
  [539] = 539,
  [540] = 540,
  [541] = 533,
  [542] = 542,
  [543] = 543,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 531,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 533,
  [557] = 514,
  [558] = 515,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 576,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 560,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 591,
  [602] = 589,
  [603] = 603,
  [604] = 604,
  [605] = 579,
  [606] = 576,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 571,
  [611] = 611,
  [612] = 612,
  [613] = 562,
  [614] = 614,
  [615] = 559,
  [616] = 616,
  [617] = 617,
  [618] = 586,
  [619] = 587,
  [620] = 588,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 592,
  [625] = 612,
  [626] = 595,
  [627] = 627,
  [628] = 559,
  [629] = 591,
  [630] = 589,
  [631] = 631,
  [632] = 579,
  [633] = 571,
  [634] = 634,
  [635] = 635,
  [636] = 588,
  [637] = 637,
  [638] = 595,
  [639] = 595,
  [640] = 589,
  [641] = 571,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 645,
  [647] = 647,
  [648] = 648,
  [649] = 592,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 576,
  [654] = 654,
  [655] = 560,
  [656] = 656,
  [657] = 570,
  [658] = 562,
  [659] = 659,
  [660] = 588,
  [661] = 587,
  [662] = 586,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 576,
  [667] = 667,
  [668] = 668,
  [669] = 562,
  [670] = 670,
  [671] = 671,
  [672] = 672,
  [673] = 650,
  [674] = 645,
  [675] = 675,
  [676] = 570,
  [677] = 677,
  [678] = 678,
  [679] = 650,
  [680] = 645,
  [681] = 681,
  [682] = 682,
  [683] = 683,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(55);
      if (lookahead == '!') ADVANCE(57);
      if (lookahead == '"') ADVANCE(89);
      if (lookahead == '#') ADVANCE(112);
      if (lookahead == '$') ADVANCE(52);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '\'') ADVANCE(83);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '*') ADVANCE(109);
      if (lookahead == '+') ADVANCE(107);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(135);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == '@') ADVANCE(26);
      if (lookahead == '[') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(81);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == '^') ADVANCE(105);
      if (lookahead == '`') ADVANCE(111);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '}') ADVANCE(67);
      if (lookahead == '~') ADVANCE(104);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(141);
      if (('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(11)
      if (lookahead == '"') ADVANCE(89);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\\') ADVANCE(2);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(91);
      if (lookahead != 0) ADVANCE(93);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(90);
      if (lookahead == '\r') ADVANCE(95);
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(97);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 3:
      if (lookahead == ' ') ADVANCE(73);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 4:
      if (lookahead == ' ') ADVANCE(73);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r') SKIP(4)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 5:
      if (lookahead == '!') ADVANCE(57);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '*') ADVANCE(109);
      if (lookahead == '+') ADVANCE(107);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(135);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == '@') ADVANCE(26);
      if (lookahead == '[') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '}') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 6:
      if (lookahead == '!') ADVANCE(57);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '*') ADVANCE(109);
      if (lookahead == '+') ADVANCE(107);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(135);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == '@') ADVANCE(26);
      if (lookahead == '[') ADVANCE(113);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(71);
      if (lookahead == '}') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(6)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 7:
      if (lookahead == '!') ADVANCE(57);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '*') ADVANCE(109);
      if (lookahead == '+') ADVANCE(107);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(64);
      if (lookahead == '/') ADVANCE(135);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '}') ADVANCE(67);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(7)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 8:
      if (lookahead == '!') ADVANCE(57);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '*') ADVANCE(109);
      if (lookahead == '+') ADVANCE(107);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(62);
      if (lookahead == '/') ADVANCE(135);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(8)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 9:
      if (lookahead == '!') ADVANCE(57);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '*') ADVANCE(109);
      if (lookahead == '+') ADVANCE(107);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(131);
      if (lookahead == '.') ADVANCE(63);
      if (lookahead == '/') ADVANCE(135);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(98);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(9)
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 10:
      if (lookahead == '"') ADVANCE(89);
      if (lookahead == '$') ADVANCE(52);
      if (lookahead == '\'') ADVANCE(83);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '*') ADVANCE(108);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(42);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '0') ADVANCE(75);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '\\') ADVANCE(81);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '}') ADVANCE(67);
      if (lookahead == '~') ADVANCE(104);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(10)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 11:
      if (lookahead == '"') ADVANCE(89);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(11)
      END_STATE();
    case 12:
      if (lookahead == '\'') ADVANCE(83);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(85);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(87);
      END_STATE();
    case 13:
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 14:
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '=') ADVANCE(58);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(14)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 15:
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '\\') ADVANCE(36);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 16:
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '.') ADVANCE(20);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '|') ADVANCE(70);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(16)
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 17:
      if (lookahead == '+') ADVANCE(138);
      END_STATE();
    case 18:
      if (lookahead == '-') ADVANCE(44);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 19:
      if (lookahead == '.') ADVANCE(116);
      END_STATE();
    case 20:
      if (lookahead == '.') ADVANCE(117);
      END_STATE();
    case 21:
      if (lookahead == '.') ADVANCE(69);
      END_STATE();
    case 22:
      if (lookahead == '.') ADVANCE(45);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(21);
      END_STATE();
    case 24:
      if (lookahead == '/') ADVANCE(110);
      END_STATE();
    case 25:
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '[') ADVANCE(113);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(25)
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      END_STATE();
    case 26:
      if (lookahead == '@') ADVANCE(119);
      if (lookahead == '|') ADVANCE(27);
      END_STATE();
    case 27:
      if (lookahead == '@') ADVANCE(120);
      END_STATE();
    case 28:
      if (lookahead == '\\') ADVANCE(29);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 29:
      if (lookahead == 'd') ADVANCE(78);
      END_STATE();
    case 30:
      if (lookahead == 'e') ADVANCE(152);
      END_STATE();
    case 31:
      if (lookahead == 'h') ADVANCE(32);
      END_STATE();
    case 32:
      if (lookahead == 'i') ADVANCE(33);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(30);
      END_STATE();
    case 34:
      if (lookahead == 'o') ADVANCE(35);
      END_STATE();
    case 35:
      if (lookahead == 'r') ADVANCE(153);
      END_STATE();
    case 36:
      if (lookahead == 'u') ADVANCE(38);
      if (lookahead == 'x') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(97);
      if (lookahead != 0) ADVANCE(94);
      END_STATE();
    case 37:
      if (lookahead == 'y') ADVANCE(154);
      END_STATE();
    case 38:
      if (lookahead == '{') ADVANCE(48);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(46);
      END_STATE();
    case 39:
      if (lookahead == '|') ADVANCE(118);
      END_STATE();
    case 40:
      if (lookahead == '}') ADVANCE(94);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 41:
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(41);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(94);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(40);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(47);
      END_STATE();
    case 50:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 51:
      if (('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 52:
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(88);
      END_STATE();
    case 53:
      if (eof) ADVANCE(55);
      if (lookahead == '!') ADVANCE(57);
      if (lookahead == '"') ADVANCE(89);
      if (lookahead == '#') ADVANCE(112);
      if (lookahead == '$') ADVANCE(52);
      if (lookahead == '%') ADVANCE(136);
      if (lookahead == '&') ADVANCE(124);
      if (lookahead == '\'') ADVANCE(83);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '*') ADVANCE(109);
      if (lookahead == '+') ADVANCE(107);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(132);
      if (lookahead == '.') ADVANCE(65);
      if (lookahead == '/') ADVANCE(135);
      if (lookahead == '0') ADVANCE(75);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == ';') ADVANCE(56);
      if (lookahead == '<') ADVANCE(99);
      if (lookahead == '=') ADVANCE(59);
      if (lookahead == '>') ADVANCE(102);
      if (lookahead == '?') ADVANCE(149);
      if (lookahead == '[') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(81);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == '^') ADVANCE(105);
      if (lookahead == '`') ADVANCE(111);
      if (lookahead == 'r') ADVANCE(146);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(72);
      if (lookahead == '}') ADVANCE(67);
      if (lookahead == '~') ADVANCE(104);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(53)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(139);
      if (('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 54:
      if (eof) ADVANCE(55);
      if (lookahead == '"') ADVANCE(89);
      if (lookahead == '#') ADVANCE(112);
      if (lookahead == '$') ADVANCE(52);
      if (lookahead == '\'') ADVANCE(83);
      if (lookahead == '(') ADVANCE(60);
      if (lookahead == ')') ADVANCE(61);
      if (lookahead == '*') ADVANCE(108);
      if (lookahead == '+') ADVANCE(106);
      if (lookahead == ',') ADVANCE(68);
      if (lookahead == '-') ADVANCE(133);
      if (lookahead == '.') ADVANCE(19);
      if (lookahead == '/') ADVANCE(24);
      if (lookahead == '0') ADVANCE(75);
      if (lookahead == ':') ADVANCE(74);
      if (lookahead == '<') ADVANCE(100);
      if (lookahead == '>') ADVANCE(101);
      if (lookahead == '[') ADVANCE(113);
      if (lookahead == '\\') ADVANCE(81);
      if (lookahead == ']') ADVANCE(114);
      if (lookahead == '^') ADVANCE(105);
      if (lookahead == '`') ADVANCE(111);
      if (lookahead == 'r') ADVANCE(145);
      if (lookahead == '{') ADVANCE(66);
      if (lookahead == '|') ADVANCE(70);
      if (lookahead == '}') ADVANCE(67);
      if (lookahead == '~') ADVANCE(104);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(54)
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(76);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(141);
      if (('_' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(126);
      if (lookahead == '?') ADVANCE(150);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(125);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == 'f') ADVANCE(34);
      if (lookahead == 'w') ADVANCE(31);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(116);
      if (lookahead == 'w') ADVANCE(31);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == 'f') ADVANCE(34);
      if (lookahead == 'w') ADVANCE(31);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == 'w') ADVANCE(31);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '@') ADVANCE(39);
      if (lookahead == '|') ADVANCE(123);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '|') ADVANCE(123);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_);
      if (lookahead == ' ') ADVANCE(73);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(43);
      if (lookahead == 'x') ADVANCE(28);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(76);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(43);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(76);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(77);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_hexinteger);
      if (lookahead == '\\') ADVANCE(29);
      if (('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(78);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(sym_float);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(18);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(79);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(sym_exponential);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(80);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_BSLASH);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_symbol_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(82);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_symbol_token2);
      if (lookahead == '\n') ADVANCE(87);
      if (lookahead == '"' ||
          lookahead == '\'' ||
          lookahead == '\\') ADVANCE(110);
      if (lookahead != 0) ADVANCE(84);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(aux_sym_symbol_token2);
      if (lookahead == '/') ADVANCE(86);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(85);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(87);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(aux_sym_symbol_token2);
      if (lookahead == '/') ADVANCE(84);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(87);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(aux_sym_symbol_token2);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(87);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(sym_char);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(aux_sym_string_token1);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(92);
      if (lookahead == '\t' ||
          lookahead == '\r' ||
          lookahead == ' ') ADVANCE(91);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(93);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '/') ADVANCE(93);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(93);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(93);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(sym_escape_sequence);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (lookahead == '\n') ADVANCE(90);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(94);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(sym_escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(96);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(129);
      if (lookahead == '=') ADVANCE(127);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(129);
      if (lookahead == '=') ADVANCE(127);
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_GT);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(128);
      if (lookahead == '>') ADVANCE(130);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_LT_GT);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(134);
      if (lookahead == '/') ADVANCE(17);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_STAR);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(137);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(aux_sym_line_comment_token1);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(110);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(sym_ref);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_POUND);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_DOT_DOT);
      if (lookahead == '.') ADVANCE(69);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_PIPE_AT_PIPE);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_AT_AT);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_AT_PIPE_AT);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(aux_sym_binary_expression_token1);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(122);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(115);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(115);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(22);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '/') ADVANCE(110);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_PLUS_SLASH_PLUS);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(aux_sym_class_token1);
      if (lookahead == ':') ADVANCE(121);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(139);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(140);
      if (lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(aux_sym_class_token1);
      if (lookahead == ':') ADVANCE(121);
      if (lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(140);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(aux_sym_class_token1);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      if (lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(aux_sym_class_token1);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(142);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(aux_sym_class_token1);
      if (lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(143);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(aux_sym_class_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(144);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(50);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '#') ADVANCE(51);
      if (lookahead == ':') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == ':') ADVANCE(121);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(147);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z') ||
          lookahead == 181 ||
          (913 <= lookahead && lookahead <= 937) ||
          (945 <= lookahead && lookahead <= 969)) ADVANCE(148);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_QMARK);
      if (lookahead == '?') ADVANCE(151);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_BANG_QMARK);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_QMARK_QMARK);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_DOTwhile);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_DOTfor);
      if (lookahead == 'B') ADVANCE(37);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_DOTforBy);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (lookahead == 'A') ADVANCE(1);
      if (lookahead == 'B') ADVANCE(2);
      if (lookahead == 'D') ADVANCE(3);
      if (lookahead == 'E') ADVANCE(4);
      if (lookahead == 'F') ADVANCE(5);
      if (lookahead == 'I') ADVANCE(6);
      if (lookahead == 'L') ADVANCE(7);
      if (lookahead == 'M') ADVANCE(8);
      if (lookahead == 'O') ADVANCE(9);
      if (lookahead == 'P') ADVANCE(10);
      if (lookahead == 'R') ADVANCE(11);
      if (lookahead == 'S') ADVANCE(12);
      if (lookahead == 'T') ADVANCE(13);
      if (lookahead == '_') ADVANCE(14);
      if (lookahead == 'a') ADVANCE(15);
      if (lookahead == 'c') ADVANCE(16);
      if (lookahead == 'f') ADVANCE(17);
      if (lookahead == 'i') ADVANCE(18);
      if (lookahead == 'n') ADVANCE(19);
      if (lookahead == 'p') ADVANCE(20);
      if (lookahead == 's') ADVANCE(21);
      if (lookahead == 't') ADVANCE(22);
      if (lookahead == 'v') ADVANCE(23);
      if (lookahead == 'w') ADVANCE(24);
      if (lookahead == '\t' ||
          lookahead == '\n' ||
          lookahead == '\r' ||
          lookahead == ' ') SKIP(0)
      if (('b' <= lookahead && lookahead <= 'z')) ADVANCE(25);
      END_STATE();
    case 1:
      if (lookahead == 'r') ADVANCE(26);
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(27);
      END_STATE();
    case 3:
      if (lookahead == 'i') ADVANCE(28);
      if (lookahead == 'o') ADVANCE(29);
      END_STATE();
    case 4:
      if (lookahead == 'n') ADVANCE(30);
      if (lookahead == 'v') ADVANCE(31);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(32);
      END_STATE();
    case 6:
      if (lookahead == 'd') ADVANCE(33);
      if (lookahead == 'n') ADVANCE(34);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(35);
      if (lookahead == 'i') ADVANCE(36);
      END_STATE();
    case 8:
      if (lookahead == 'u') ADVANCE(37);
      END_STATE();
    case 9:
      if (lookahead == 'b') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 10:
      if (lookahead == 'a') ADVANCE(40);
      if (lookahead == 'r') ADVANCE(41);
      END_STATE();
    case 11:
      if (lookahead == 'a') ADVANCE(42);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(43);
      if (lookahead == 'i') ADVANCE(44);
      if (lookahead == 'o') ADVANCE(45);
      if (lookahead == 'p') ADVANCE(46);
      if (lookahead == 't') ADVANCE(47);
      if (lookahead == 'y') ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == 'w') ADVANCE(49);
      END_STATE();
    case 14:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 15:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'r') ADVANCE(50);
      END_STATE();
    case 16:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'a') ADVANCE(51);
      if (lookahead == 'l') ADVANCE(52);
      if (lookahead == 'o') ADVANCE(53);
      if (lookahead == 'u') ADVANCE(54);
      END_STATE();
    case 17:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'a') ADVANCE(55);
      if (lookahead == 'o') ADVANCE(56);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'f') ADVANCE(57);
      if (lookahead == 'n') ADVANCE(58);
      END_STATE();
    case 19:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'i') ADVANCE(59);
      END_STATE();
    case 20:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'i') ADVANCE(60);
      END_STATE();
    case 21:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'w') ADVANCE(61);
      END_STATE();
    case 22:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'h') ADVANCE(62);
      if (lookahead == 'o') ADVANCE(63);
      if (lookahead == 'r') ADVANCE(64);
      END_STATE();
    case 23:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'a') ADVANCE(65);
      END_STATE();
    case 24:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      if (lookahead == 'h') ADVANCE(66);
      END_STATE();
    case 25:
      ACCEPT_TOKEN(aux_sym_environment_var_token1);
      END_STATE();
    case 26:
      if (lookahead == 'r') ADVANCE(67);
      END_STATE();
    case 27:
      if (lookahead == 'g') ADVANCE(68);
      END_STATE();
    case 28:
      if (lookahead == 'c') ADVANCE(69);
      END_STATE();
    case 29:
      if (lookahead == 'u') ADVANCE(70);
      END_STATE();
    case 30:
      if (lookahead == 'v') ADVANCE(71);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(72);
      END_STATE();
    case 32:
      if (lookahead == 'o') ADVANCE(73);
      END_STATE();
    case 33:
      if (lookahead == 'e') ADVANCE(74);
      END_STATE();
    case 34:
      if (lookahead == 't') ADVANCE(75);
      END_STATE();
    case 35:
      if (lookahead == 'z') ADVANCE(76);
      END_STATE();
    case 36:
      if (lookahead == 'n') ADVANCE(77);
      if (lookahead == 's') ADVANCE(78);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(79);
      END_STATE();
    case 38:
      if (lookahead == 'j') ADVANCE(80);
      END_STATE();
    case 39:
      if (lookahead == 'd') ADVANCE(81);
      END_STATE();
    case 40:
      if (lookahead == 'i') ADVANCE(82);
      END_STATE();
    case 41:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 42:
      if (lookahead == 'w') ADVANCE(84);
      END_STATE();
    case 43:
      if (lookahead == 'q') ADVANCE(85);
      if (lookahead == 't') ADVANCE(86);
      END_STATE();
    case 44:
      if (lookahead == 'g') ADVANCE(87);
      END_STATE();
    case 45:
      if (lookahead == 'r') ADVANCE(88);
      END_STATE();
    case 46:
      if (lookahead == 'a') ADVANCE(89);
      END_STATE();
    case 47:
      if (lookahead == 'r') ADVANCE(90);
      END_STATE();
    case 48:
      if (lookahead == 'm') ADVANCE(91);
      END_STATE();
    case 49:
      if (lookahead == 'o') ADVANCE(92);
      END_STATE();
    case 50:
      if (lookahead == 'g') ADVANCE(93);
      END_STATE();
    case 51:
      if (lookahead == 's') ADVANCE(94);
      END_STATE();
    case 52:
      if (lookahead == 'a') ADVANCE(95);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(96);
      END_STATE();
    case 54:
      if (lookahead == 'r') ADVANCE(97);
      END_STATE();
    case 55:
      if (lookahead == 'l') ADVANCE(98);
      END_STATE();
    case 56:
      if (lookahead == 'r') ADVANCE(99);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 58:
      if (lookahead == 'f') ADVANCE(100);
      END_STATE();
    case 59:
      if (lookahead == 'l') ADVANCE(101);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(anon_sym_pi);
      END_STATE();
    case 61:
      if (lookahead == 'i') ADVANCE(102);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(103);
      END_STATE();
    case 63:
      if (lookahead == 'p') ADVANCE(104);
      END_STATE();
    case 64:
      if (lookahead == 'u') ADVANCE(105);
      END_STATE();
    case 65:
      if (lookahead == 'r') ADVANCE(106);
      END_STATE();
    case 66:
      if (lookahead == 'i') ADVANCE(107);
      END_STATE();
    case 67:
      if (lookahead == 'a') ADVANCE(108);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_Bag);
      END_STATE();
    case 69:
      if (lookahead == 't') ADVANCE(109);
      END_STATE();
    case 70:
      if (lookahead == 'b') ADVANCE(110);
      END_STATE();
    case 71:
      if (lookahead == 'i') ADVANCE(111);
      END_STATE();
    case 72:
      if (lookahead == 'n') ADVANCE(112);
      END_STATE();
    case 73:
      if (lookahead == 'a') ADVANCE(113);
      END_STATE();
    case 74:
      if (lookahead == 'n') ADVANCE(114);
      END_STATE();
    case 75:
      if (lookahead == '1') ADVANCE(115);
      if (lookahead == '3') ADVANCE(116);
      if (lookahead == '8') ADVANCE(117);
      END_STATE();
    case 76:
      if (lookahead == 'y') ADVANCE(118);
      END_STATE();
    case 77:
      if (lookahead == 'k') ADVANCE(119);
      END_STATE();
    case 78:
      if (lookahead == 't') ADVANCE(120);
      END_STATE();
    case 79:
      if (lookahead == 't') ADVANCE(121);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(122);
      END_STATE();
    case 81:
      if (lookahead == 'e') ADVANCE(123);
      END_STATE();
    case 82:
      if (lookahead == 'r') ADVANCE(124);
      END_STATE();
    case 83:
      if (lookahead == 'o') ADVANCE(125);
      END_STATE();
    case 84:
      if (lookahead == 'A') ADVANCE(126);
      END_STATE();
    case 85:
      if (lookahead == 'u') ADVANCE(127);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_Set);
      END_STATE();
    case 87:
      if (lookahead == 'n') ADVANCE(128);
      END_STATE();
    case 88:
      if (lookahead == 't') ADVANCE(129);
      END_STATE();
    case 89:
      if (lookahead == 'r') ADVANCE(130);
      END_STATE();
    case 90:
      if (lookahead == 'i') ADVANCE(131);
      END_STATE();
    case 91:
      if (lookahead == 'b') ADVANCE(132);
      END_STATE();
    case 92:
      if (lookahead == 'W') ADVANCE(133);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_arg);
      END_STATE();
    case 94:
      if (lookahead == 'e') ADVANCE(134);
      END_STATE();
    case 95:
      if (lookahead == 's') ADVANCE(135);
      END_STATE();
    case 96:
      if (lookahead == 's') ADVANCE(136);
      END_STATE();
    case 97:
      if (lookahead == 'r') ADVANCE(137);
      END_STATE();
    case 98:
      if (lookahead == 's') ADVANCE(138);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_for);
      if (lookahead == 'B') ADVANCE(139);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_inf);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_nil);
      END_STATE();
    case 102:
      if (lookahead == 't') ADVANCE(140);
      END_STATE();
    case 103:
      if (lookahead == 's') ADVANCE(141);
      END_STATE();
    case 104:
      if (lookahead == 'E') ADVANCE(142);
      END_STATE();
    case 105:
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 107:
      if (lookahead == 'l') ADVANCE(144);
      END_STATE();
    case 108:
      if (lookahead == 'y') ADVANCE(145);
      END_STATE();
    case 109:
      if (lookahead == 'i') ADVANCE(146);
      END_STATE();
    case 110:
      if (lookahead == 'l') ADVANCE(147);
      END_STATE();
    case 111:
      if (lookahead == 'r') ADVANCE(148);
      END_STATE();
    case 112:
      if (lookahead == 't') ADVANCE(149);
      END_STATE();
    case 113:
      if (lookahead == 't') ADVANCE(150);
      END_STATE();
    case 114:
      if (lookahead == 't') ADVANCE(151);
      END_STATE();
    case 115:
      if (lookahead == '6') ADVANCE(152);
      END_STATE();
    case 116:
      if (lookahead == '2') ADVANCE(153);
      END_STATE();
    case 117:
      if (lookahead == 'A') ADVANCE(154);
      END_STATE();
    case 118:
      if (lookahead == 'E') ADVANCE(155);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(156);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_List);
      END_STATE();
    case 121:
      if (lookahead == 'i') ADVANCE(157);
      END_STATE();
    case 122:
      if (lookahead == 'c') ADVANCE(158);
      END_STATE();
    case 123:
      if (lookahead == 'r') ADVANCE(159);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_Pair);
      END_STATE();
    case 125:
      if (lookahead == 'r') ADVANCE(160);
      END_STATE();
    case 126:
      if (lookahead == 'r') ADVANCE(161);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(162);
      END_STATE();
    case 128:
      if (lookahead == 'a') ADVANCE(163);
      END_STATE();
    case 129:
      if (lookahead == 'e') ADVANCE(164);
      END_STATE();
    case 130:
      if (lookahead == 's') ADVANCE(165);
      END_STATE();
    case 131:
      if (lookahead == 'n') ADVANCE(166);
      END_STATE();
    case 132:
      if (lookahead == 'o') ADVANCE(167);
      END_STATE();
    case 133:
      if (lookahead == 'a') ADVANCE(168);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 135:
      if (lookahead == 's') ADVANCE(169);
      END_STATE();
    case 136:
      if (lookahead == 't') ADVANCE(170);
      END_STATE();
    case 137:
      if (lookahead == 'e') ADVANCE(171);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(172);
      END_STATE();
    case 139:
      if (lookahead == 'y') ADVANCE(173);
      END_STATE();
    case 140:
      if (lookahead == 'c') ADVANCE(174);
      END_STATE();
    case 141:
      if (lookahead == 'F') ADVANCE(175);
      if (lookahead == 'M') ADVANCE(176);
      if (lookahead == 'P') ADVANCE(177);
      if (lookahead == 'T') ADVANCE(178);
      END_STATE();
    case 142:
      if (lookahead == 'n') ADVANCE(179);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 144:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_Array);
      if (lookahead == '2') ADVANCE(181);
      if (lookahead == 'e') ADVANCE(182);
      END_STATE();
    case 146:
      if (lookahead == 'o') ADVANCE(183);
      END_STATE();
    case 147:
      if (lookahead == 'e') ADVANCE(184);
      END_STATE();
    case 148:
      if (lookahead == 'o') ADVANCE(185);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_Event);
      END_STATE();
    case 150:
      if (lookahead == 'A') ADVANCE(186);
      END_STATE();
    case 151:
      if (lookahead == 'i') ADVANCE(187);
      END_STATE();
    case 152:
      if (lookahead == 'A') ADVANCE(188);
      END_STATE();
    case 153:
      if (lookahead == 'A') ADVANCE(189);
      END_STATE();
    case 154:
      if (lookahead == 'r') ADVANCE(190);
      END_STATE();
    case 155:
      if (lookahead == 'n') ADVANCE(191);
      END_STATE();
    case 156:
      if (lookahead == 'd') ADVANCE(192);
      END_STATE();
    case 157:
      if (lookahead == 'L') ADVANCE(193);
      END_STATE();
    case 158:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_Order);
      if (lookahead == 'e') ADVANCE(195);
      END_STATE();
    case 160:
      if (lookahead == 'i') ADVANCE(196);
      END_STATE();
    case 161:
      if (lookahead == 'r') ADVANCE(197);
      END_STATE();
    case 162:
      if (lookahead == 'n') ADVANCE(198);
      END_STATE();
    case 163:
      if (lookahead == 'l') ADVANCE(199);
      END_STATE();
    case 164:
      if (lookahead == 'd') ADVANCE(200);
      END_STATE();
    case 165:
      if (lookahead == 'e') ADVANCE(201);
      END_STATE();
    case 166:
      if (lookahead == 'g') ADVANCE(202);
      END_STATE();
    case 167:
      if (lookahead == 'l') ADVANCE(203);
      END_STATE();
    case 168:
      if (lookahead == 'y') ADVANCE(204);
      END_STATE();
    case 169:
      if (lookahead == 'v') ADVANCE(205);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(anon_sym_const);
      END_STATE();
    case 171:
      if (lookahead == 'n') ADVANCE(206);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_forBy);
      END_STATE();
    case 174:
      if (lookahead == 'h') ADVANCE(207);
      END_STATE();
    case 175:
      if (lookahead == 'u') ADVANCE(208);
      END_STATE();
    case 176:
      if (lookahead == 'e') ADVANCE(209);
      END_STATE();
    case 177:
      if (lookahead == 'r') ADVANCE(210);
      END_STATE();
    case 178:
      if (lookahead == 'h') ADVANCE(211);
      END_STATE();
    case 179:
      if (lookahead == 'v') ADVANCE(212);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 181:
      if (lookahead == 'D') ADVANCE(213);
      END_STATE();
    case 182:
      if (lookahead == 'd') ADVANCE(214);
      END_STATE();
    case 183:
      if (lookahead == 'n') ADVANCE(215);
      END_STATE();
    case 184:
      if (lookahead == 'A') ADVANCE(216);
      END_STATE();
    case 185:
      if (lookahead == 'n') ADVANCE(217);
      END_STATE();
    case 186:
      if (lookahead == 'r') ADVANCE(218);
      END_STATE();
    case 187:
      if (lookahead == 't') ADVANCE(219);
      END_STATE();
    case 188:
      if (lookahead == 'r') ADVANCE(220);
      END_STATE();
    case 189:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 190:
      if (lookahead == 'r') ADVANCE(222);
      END_STATE();
    case 191:
      if (lookahead == 'v') ADVANCE(223);
      END_STATE();
    case 192:
      if (lookahead == 'L') ADVANCE(224);
      END_STATE();
    case 193:
      if (lookahead == 'e') ADVANCE(225);
      END_STATE();
    case 194:
      if (lookahead == 'T') ADVANCE(226);
      END_STATE();
    case 195:
      if (lookahead == 'd') ADVANCE(227);
      END_STATE();
    case 196:
      if (lookahead == 't') ADVANCE(228);
      END_STATE();
    case 197:
      if (lookahead == 'a') ADVANCE(229);
      END_STATE();
    case 198:
      if (lookahead == 'c') ADVANCE(230);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_Signal);
      END_STATE();
    case 200:
      if (lookahead == 'L') ADVANCE(231);
      END_STATE();
    case 201:
      if (lookahead == 'A') ADVANCE(232);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(anon_sym_String);
      END_STATE();
    case 203:
      if (lookahead == 'A') ADVANCE(233);
      END_STATE();
    case 204:
      if (lookahead == 'I') ADVANCE(234);
      END_STATE();
    case 205:
      if (lookahead == 'a') ADVANCE(235);
      END_STATE();
    case 206:
      if (lookahead == 't') ADVANCE(236);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 208:
      if (lookahead == 'n') ADVANCE(237);
      END_STATE();
    case 209:
      if (lookahead == 't') ADVANCE(238);
      END_STATE();
    case 210:
      if (lookahead == 'o') ADVANCE(239);
      END_STATE();
    case 211:
      if (lookahead == 'r') ADVANCE(240);
      END_STATE();
    case 212:
      if (lookahead == 'i') ADVANCE(241);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_Array2D);
      END_STATE();
    case 214:
      if (lookahead == 'C') ADVANCE(242);
      END_STATE();
    case 215:
      if (lookahead == 'a') ADVANCE(243);
      END_STATE();
    case 216:
      if (lookahead == 'r') ADVANCE(244);
      END_STATE();
    case 217:
      if (lookahead == 'm') ADVANCE(245);
      END_STATE();
    case 218:
      if (lookahead == 'r') ADVANCE(246);
      END_STATE();
    case 219:
      if (lookahead == 'y') ADVANCE(247);
      END_STATE();
    case 220:
      if (lookahead == 'r') ADVANCE(248);
      END_STATE();
    case 221:
      if (lookahead == 'r') ADVANCE(249);
      END_STATE();
    case 222:
      if (lookahead == 'a') ADVANCE(250);
      END_STATE();
    case 223:
      if (lookahead == 'i') ADVANCE(251);
      END_STATE();
    case 224:
      if (lookahead == 'i') ADVANCE(252);
      END_STATE();
    case 225:
      if (lookahead == 'v') ADVANCE(253);
      END_STATE();
    case 226:
      if (lookahead == 'a') ADVANCE(254);
      END_STATE();
    case 227:
      if (lookahead == 'I') ADVANCE(255);
      END_STATE();
    case 228:
      if (lookahead == 'y') ADVANCE(256);
      END_STATE();
    case 229:
      if (lookahead == 'y') ADVANCE(257);
      END_STATE();
    case 230:
      if (lookahead == 'e') ADVANCE(258);
      END_STATE();
    case 231:
      if (lookahead == 'i') ADVANCE(259);
      END_STATE();
    case 232:
      if (lookahead == 'r') ADVANCE(260);
      END_STATE();
    case 233:
      if (lookahead == 'r') ADVANCE(261);
      END_STATE();
    case 234:
      if (lookahead == 'd') ADVANCE(262);
      END_STATE();
    case 235:
      if (lookahead == 'r') ADVANCE(263);
      END_STATE();
    case 236:
      if (lookahead == 'E') ADVANCE(264);
      END_STATE();
    case 237:
      if (lookahead == 'c') ADVANCE(265);
      END_STATE();
    case 238:
      if (lookahead == 'h') ADVANCE(266);
      END_STATE();
    case 239:
      if (lookahead == 'c') ADVANCE(267);
      END_STATE();
    case 240:
      if (lookahead == 'e') ADVANCE(268);
      END_STATE();
    case 241:
      if (lookahead == 'r') ADVANCE(269);
      END_STATE();
    case 242:
      if (lookahead == 'o') ADVANCE(270);
      END_STATE();
    case 243:
      if (lookahead == 'r') ADVANCE(271);
      END_STATE();
    case 244:
      if (lookahead == 'r') ADVANCE(272);
      END_STATE();
    case 245:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 246:
      if (lookahead == 'a') ADVANCE(274);
      END_STATE();
    case 247:
      if (lookahead == 'B') ADVANCE(275);
      if (lookahead == 'D') ADVANCE(276);
      if (lookahead == 'S') ADVANCE(277);
      END_STATE();
    case 248:
      if (lookahead == 'a') ADVANCE(278);
      END_STATE();
    case 249:
      if (lookahead == 'a') ADVANCE(279);
      END_STATE();
    case 250:
      if (lookahead == 'y') ADVANCE(280);
      END_STATE();
    case 251:
      if (lookahead == 'r') ADVANCE(281);
      END_STATE();
    case 252:
      if (lookahead == 's') ADVANCE(282);
      END_STATE();
    case 253:
      if (lookahead == 'e') ADVANCE(283);
      END_STATE();
    case 254:
      if (lookahead == 'b') ADVANCE(284);
      END_STATE();
    case 255:
      if (lookahead == 'd') ADVANCE(285);
      END_STATE();
    case 256:
      if (lookahead == 'Q') ADVANCE(286);
      END_STATE();
    case 257:
      ACCEPT_TOKEN(anon_sym_RawArray);
      END_STATE();
    case 258:
      if (lookahead == 'a') ADVANCE(287);
      END_STATE();
    case 259:
      if (lookahead == 's') ADVANCE(288);
      END_STATE();
    case 260:
      if (lookahead == 'r') ADVANCE(289);
      END_STATE();
    case 261:
      if (lookahead == 'r') ADVANCE(290);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(291);
      END_STATE();
    case 263:
      ACCEPT_TOKEN(anon_sym_classvar);
      END_STATE();
    case 264:
      if (lookahead == 'n') ADVANCE(292);
      END_STATE();
    case 265:
      if (lookahead == 't') ADVANCE(293);
      END_STATE();
    case 266:
      if (lookahead == 'o') ADVANCE(294);
      END_STATE();
    case 267:
      if (lookahead == 'e') ADVANCE(295);
      END_STATE();
    case 268:
      if (lookahead == 'a') ADVANCE(296);
      END_STATE();
    case 269:
      if (lookahead == 'o') ADVANCE(297);
      END_STATE();
    case 270:
      if (lookahead == 'l') ADVANCE(298);
      END_STATE();
    case 271:
      if (lookahead == 'y') ADVANCE(299);
      END_STATE();
    case 272:
      if (lookahead == 'a') ADVANCE(300);
      END_STATE();
    case 273:
      if (lookahead == 'n') ADVANCE(301);
      END_STATE();
    case 274:
      if (lookahead == 'y') ADVANCE(302);
      END_STATE();
    case 275:
      if (lookahead == 'a') ADVANCE(303);
      END_STATE();
    case 276:
      if (lookahead == 'i') ADVANCE(304);
      END_STATE();
    case 277:
      if (lookahead == 'e') ADVANCE(305);
      END_STATE();
    case 278:
      if (lookahead == 'y') ADVANCE(306);
      END_STATE();
    case 279:
      if (lookahead == 'y') ADVANCE(307);
      END_STATE();
    case 280:
      ACCEPT_TOKEN(anon_sym_Int8Array);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_LazyEnvir);
      END_STATE();
    case 282:
      if (lookahead == 't') ADVANCE(308);
      END_STATE();
    case 283:
      if (lookahead == 'l') ADVANCE(309);
      END_STATE();
    case 284:
      if (lookahead == 'l') ADVANCE(310);
      END_STATE();
    case 285:
      if (lookahead == 'e') ADVANCE(311);
      END_STATE();
    case 286:
      if (lookahead == 'u') ADVANCE(312);
      END_STATE();
    case 287:
      if (lookahead == 'b') ADVANCE(313);
      END_STATE();
    case 288:
      if (lookahead == 't') ADVANCE(314);
      END_STATE();
    case 289:
      if (lookahead == 'a') ADVANCE(315);
      END_STATE();
    case 290:
      if (lookahead == 'a') ADVANCE(316);
      END_STATE();
    case 291:
      if (lookahead == 'n') ADVANCE(317);
      END_STATE();
    case 292:
      if (lookahead == 'v') ADVANCE(318);
      END_STATE();
    case 293:
      if (lookahead == 'i') ADVANCE(319);
      END_STATE();
    case 294:
      if (lookahead == 'd') ADVANCE(320);
      END_STATE();
    case 295:
      if (lookahead == 's') ADVANCE(321);
      END_STATE();
    case 296:
      if (lookahead == 'd') ADVANCE(322);
      END_STATE();
    case 297:
      if (lookahead == 'n') ADVANCE(323);
      END_STATE();
    case 298:
      if (lookahead == 'l') ADVANCE(324);
      END_STATE();
    case 299:
      ACCEPT_TOKEN(anon_sym_Dictionary);
      END_STATE();
    case 300:
      if (lookahead == 'y') ADVANCE(325);
      END_STATE();
    case 301:
      if (lookahead == 't') ADVANCE(326);
      END_STATE();
    case 302:
      ACCEPT_TOKEN(anon_sym_FloatArray);
      END_STATE();
    case 303:
      if (lookahead == 'g') ADVANCE(327);
      END_STATE();
    case 304:
      if (lookahead == 'c') ADVANCE(328);
      END_STATE();
    case 305:
      if (lookahead == 't') ADVANCE(329);
      END_STATE();
    case 306:
      ACCEPT_TOKEN(anon_sym_Int16Array);
      END_STATE();
    case 307:
      ACCEPT_TOKEN(anon_sym_Int32Array);
      END_STATE();
    case 308:
      ACCEPT_TOKEN(anon_sym_LinkedList);
      END_STATE();
    case 309:
      if (lookahead == 'I') ADVANCE(330);
      END_STATE();
    case 310:
      if (lookahead == 'e') ADVANCE(331);
      END_STATE();
    case 311:
      if (lookahead == 'n') ADVANCE(332);
      END_STATE();
    case 312:
      if (lookahead == 'e') ADVANCE(333);
      END_STATE();
    case 313:
      if (lookahead == 'l') ADVANCE(334);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_SortedList);
      END_STATE();
    case 315:
      if (lookahead == 'y') ADVANCE(335);
      END_STATE();
    case 316:
      if (lookahead == 'y') ADVANCE(336);
      END_STATE();
    case 317:
      if (lookahead == 't') ADVANCE(337);
      END_STATE();
    case 318:
      if (lookahead == 'i') ADVANCE(338);
      END_STATE();
    case 319:
      if (lookahead == 'o') ADVANCE(339);
      END_STATE();
    case 320:
      ACCEPT_TOKEN(anon_sym_thisMethod);
      END_STATE();
    case 321:
      if (lookahead == 's') ADVANCE(340);
      END_STATE();
    case 322:
      ACCEPT_TOKEN(anon_sym_thisThread);
      END_STATE();
    case 323:
      if (lookahead == 'm') ADVANCE(341);
      END_STATE();
    case 324:
      if (lookahead == 'e') ADVANCE(342);
      END_STATE();
    case 325:
      ACCEPT_TOKEN(anon_sym_DoubleArray);
      END_STATE();
    case 326:
      ACCEPT_TOKEN(anon_sym_Environment);
      END_STATE();
    case 327:
      ACCEPT_TOKEN(anon_sym_IdentityBag);
      END_STATE();
    case 328:
      if (lookahead == 't') ADVANCE(343);
      END_STATE();
    case 329:
      ACCEPT_TOKEN(anon_sym_IdentitySet);
      END_STATE();
    case 330:
      if (lookahead == 'd') ADVANCE(344);
      END_STATE();
    case 331:
      ACCEPT_TOKEN(anon_sym_ObjectTable);
      END_STATE();
    case 332:
      if (lookahead == 't') ADVANCE(345);
      END_STATE();
    case 333:
      if (lookahead == 'u') ADVANCE(346);
      END_STATE();
    case 334:
      if (lookahead == 'e') ADVANCE(347);
      END_STATE();
    case 335:
      ACCEPT_TOKEN(anon_sym_SparseArray);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_SymbolArray);
      END_STATE();
    case 337:
      if (lookahead == 'i') ADVANCE(348);
      END_STATE();
    case 338:
      if (lookahead == 'r') ADVANCE(349);
      END_STATE();
    case 339:
      if (lookahead == 'n') ADVANCE(350);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_thisProcess);
      END_STATE();
    case 341:
      if (lookahead == 'e') ADVANCE(351);
      END_STATE();
    case 342:
      if (lookahead == 'c') ADVANCE(352);
      END_STATE();
    case 343:
      if (lookahead == 'i') ADVANCE(353);
      END_STATE();
    case 344:
      if (lookahead == 'e') ADVANCE(354);
      END_STATE();
    case 345:
      if (lookahead == 'i') ADVANCE(355);
      END_STATE();
    case 346:
      if (lookahead == 'e') ADVANCE(356);
      END_STATE();
    case 347:
      if (lookahead == 'C') ADVANCE(357);
      END_STATE();
    case 348:
      if (lookahead == 't') ADVANCE(358);
      END_STATE();
    case 349:
      if (lookahead == 'o') ADVANCE(359);
      END_STATE();
    case 350:
      ACCEPT_TOKEN(anon_sym_thisFunction);
      if (lookahead == 'D') ADVANCE(360);
      END_STATE();
    case 351:
      if (lookahead == 'n') ADVANCE(361);
      END_STATE();
    case 352:
      if (lookahead == 't') ADVANCE(362);
      END_STATE();
    case 353:
      if (lookahead == 'o') ADVANCE(363);
      END_STATE();
    case 354:
      if (lookahead == 'n') ADVANCE(364);
      END_STATE();
    case 355:
      if (lookahead == 't') ADVANCE(365);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_PriorityQueue);
      END_STATE();
    case 357:
      if (lookahead == 'o') ADVANCE(366);
      END_STATE();
    case 358:
      if (lookahead == 'y') ADVANCE(367);
      END_STATE();
    case 359:
      if (lookahead == 'n') ADVANCE(368);
      END_STATE();
    case 360:
      if (lookahead == 'e') ADVANCE(369);
      END_STATE();
    case 361:
      if (lookahead == 't') ADVANCE(370);
      END_STATE();
    case 362:
      if (lookahead == 'i') ADVANCE(371);
      END_STATE();
    case 363:
      if (lookahead == 'n') ADVANCE(372);
      END_STATE();
    case 364:
      if (lookahead == 't') ADVANCE(373);
      END_STATE();
    case 365:
      if (lookahead == 'y') ADVANCE(374);
      END_STATE();
    case 366:
      if (lookahead == 'l') ADVANCE(375);
      END_STATE();
    case 367:
      if (lookahead == 'D') ADVANCE(376);
      END_STATE();
    case 368:
      if (lookahead == 'm') ADVANCE(377);
      END_STATE();
    case 369:
      if (lookahead == 'f') ADVANCE(378);
      END_STATE();
    case 370:
      ACCEPT_TOKEN(anon_sym_topEnvironment);
      END_STATE();
    case 371:
      if (lookahead == 'o') ADVANCE(379);
      END_STATE();
    case 372:
      if (lookahead == 'a') ADVANCE(380);
      END_STATE();
    case 373:
      if (lookahead == 'i') ADVANCE(381);
      END_STATE();
    case 374:
      if (lookahead == 'S') ADVANCE(382);
      END_STATE();
    case 375:
      if (lookahead == 'l') ADVANCE(383);
      END_STATE();
    case 376:
      if (lookahead == 'i') ADVANCE(384);
      END_STATE();
    case 377:
      if (lookahead == 'e') ADVANCE(385);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_thisFunctionDef);
      END_STATE();
    case 379:
      if (lookahead == 'n') ADVANCE(386);
      END_STATE();
    case 380:
      if (lookahead == 'r') ADVANCE(387);
      END_STATE();
    case 381:
      if (lookahead == 't') ADVANCE(388);
      END_STATE();
    case 382:
      if (lookahead == 'e') ADVANCE(389);
      END_STATE();
    case 383:
      if (lookahead == 'e') ADVANCE(390);
      END_STATE();
    case 384:
      if (lookahead == 'c') ADVANCE(391);
      END_STATE();
    case 385:
      if (lookahead == 'n') ADVANCE(392);
      END_STATE();
    case 386:
      ACCEPT_TOKEN(anon_sym_ArrayedCollection);
      END_STATE();
    case 387:
      if (lookahead == 'y') ADVANCE(393);
      END_STATE();
    case 388:
      if (lookahead == 'y') ADVANCE(394);
      END_STATE();
    case 389:
      if (lookahead == 't') ADVANCE(395);
      END_STATE();
    case 390:
      if (lookahead == 'c') ADVANCE(396);
      END_STATE();
    case 391:
      if (lookahead == 't') ADVANCE(397);
      END_STATE();
    case 392:
      if (lookahead == 't') ADVANCE(398);
      END_STATE();
    case 393:
      ACCEPT_TOKEN(anon_sym_IdentityDictionary);
      END_STATE();
    case 394:
      if (lookahead == 'D') ADVANCE(399);
      END_STATE();
    case 395:
      ACCEPT_TOKEN(anon_sym_OrderedIdentitySet);
      END_STATE();
    case 396:
      if (lookahead == 't') ADVANCE(400);
      END_STATE();
    case 397:
      if (lookahead == 'i') ADVANCE(401);
      END_STATE();
    case 398:
      ACCEPT_TOKEN(anon_sym_currentEnvironment);
      END_STATE();
    case 399:
      if (lookahead == 'i') ADVANCE(402);
      END_STATE();
    case 400:
      if (lookahead == 'i') ADVANCE(403);
      END_STATE();
    case 401:
      if (lookahead == 'o') ADVANCE(404);
      END_STATE();
    case 402:
      if (lookahead == 'c') ADVANCE(405);
      END_STATE();
    case 403:
      if (lookahead == 'o') ADVANCE(406);
      END_STATE();
    case 404:
      if (lookahead == 'n') ADVANCE(407);
      END_STATE();
    case 405:
      if (lookahead == 't') ADVANCE(408);
      END_STATE();
    case 406:
      if (lookahead == 'n') ADVANCE(409);
      END_STATE();
    case 407:
      if (lookahead == 'a') ADVANCE(410);
      END_STATE();
    case 408:
      if (lookahead == 'i') ADVANCE(411);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_SequenceableCollection);
      END_STATE();
    case 410:
      if (lookahead == 'r') ADVANCE(412);
      END_STATE();
    case 411:
      if (lookahead == 'o') ADVANCE(413);
      END_STATE();
    case 412:
      if (lookahead == 'y') ADVANCE(414);
      END_STATE();
    case 413:
      if (lookahead == 'n') ADVANCE(415);
      END_STATE();
    case 414:
      ACCEPT_TOKEN(anon_sym_TwoWayIdentityDictionary);
      END_STATE();
    case 415:
      if (lookahead == 'a') ADVANCE(416);
      END_STATE();
    case 416:
      if (lookahead == 'r') ADVANCE(417);
      END_STATE();
    case 417:
      if (lookahead == 'y') ADVANCE(418);
      END_STATE();
    case 418:
      ACCEPT_TOKEN(anon_sym_MultiLevelIdentityDictionary);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0, .external_lex_state = 1},
  [1] = {.lex_state = 54, .external_lex_state = 1},
  [2] = {.lex_state = 54, .external_lex_state = 1},
  [3] = {.lex_state = 54, .external_lex_state = 1},
  [4] = {.lex_state = 54, .external_lex_state = 1},
  [5] = {.lex_state = 54, .external_lex_state = 1},
  [6] = {.lex_state = 54, .external_lex_state = 1},
  [7] = {.lex_state = 54, .external_lex_state = 1},
  [8] = {.lex_state = 54, .external_lex_state = 1},
  [9] = {.lex_state = 54, .external_lex_state = 1},
  [10] = {.lex_state = 54, .external_lex_state = 1},
  [11] = {.lex_state = 54, .external_lex_state = 1},
  [12] = {.lex_state = 54, .external_lex_state = 1},
  [13] = {.lex_state = 54, .external_lex_state = 1},
  [14] = {.lex_state = 54, .external_lex_state = 1},
  [15] = {.lex_state = 54, .external_lex_state = 1},
  [16] = {.lex_state = 54, .external_lex_state = 1},
  [17] = {.lex_state = 54, .external_lex_state = 1},
  [18] = {.lex_state = 54, .external_lex_state = 1},
  [19] = {.lex_state = 54, .external_lex_state = 1},
  [20] = {.lex_state = 54, .external_lex_state = 1},
  [21] = {.lex_state = 54, .external_lex_state = 1},
  [22] = {.lex_state = 54, .external_lex_state = 1},
  [23] = {.lex_state = 54, .external_lex_state = 1},
  [24] = {.lex_state = 54, .external_lex_state = 1},
  [25] = {.lex_state = 54, .external_lex_state = 1},
  [26] = {.lex_state = 54, .external_lex_state = 1},
  [27] = {.lex_state = 54, .external_lex_state = 1},
  [28] = {.lex_state = 54, .external_lex_state = 1},
  [29] = {.lex_state = 54, .external_lex_state = 1},
  [30] = {.lex_state = 54, .external_lex_state = 1},
  [31] = {.lex_state = 54, .external_lex_state = 1},
  [32] = {.lex_state = 54, .external_lex_state = 1},
  [33] = {.lex_state = 54, .external_lex_state = 1},
  [34] = {.lex_state = 54, .external_lex_state = 1},
  [35] = {.lex_state = 54, .external_lex_state = 1},
  [36] = {.lex_state = 54, .external_lex_state = 1},
  [37] = {.lex_state = 54, .external_lex_state = 1},
  [38] = {.lex_state = 54, .external_lex_state = 1},
  [39] = {.lex_state = 54, .external_lex_state = 1},
  [40] = {.lex_state = 54, .external_lex_state = 1},
  [41] = {.lex_state = 54, .external_lex_state = 1},
  [42] = {.lex_state = 54, .external_lex_state = 1},
  [43] = {.lex_state = 54, .external_lex_state = 1},
  [44] = {.lex_state = 54, .external_lex_state = 1},
  [45] = {.lex_state = 54, .external_lex_state = 1},
  [46] = {.lex_state = 54, .external_lex_state = 1},
  [47] = {.lex_state = 54, .external_lex_state = 1},
  [48] = {.lex_state = 54, .external_lex_state = 1},
  [49] = {.lex_state = 54, .external_lex_state = 1},
  [50] = {.lex_state = 54, .external_lex_state = 1},
  [51] = {.lex_state = 54, .external_lex_state = 1},
  [52] = {.lex_state = 54, .external_lex_state = 1},
  [53] = {.lex_state = 54, .external_lex_state = 1},
  [54] = {.lex_state = 54, .external_lex_state = 1},
  [55] = {.lex_state = 54, .external_lex_state = 1},
  [56] = {.lex_state = 54, .external_lex_state = 1},
  [57] = {.lex_state = 54, .external_lex_state = 1},
  [58] = {.lex_state = 54, .external_lex_state = 1},
  [59] = {.lex_state = 54, .external_lex_state = 1},
  [60] = {.lex_state = 54, .external_lex_state = 1},
  [61] = {.lex_state = 54, .external_lex_state = 1},
  [62] = {.lex_state = 54, .external_lex_state = 1},
  [63] = {.lex_state = 54, .external_lex_state = 1},
  [64] = {.lex_state = 54, .external_lex_state = 1},
  [65] = {.lex_state = 54, .external_lex_state = 1},
  [66] = {.lex_state = 54, .external_lex_state = 1},
  [67] = {.lex_state = 54, .external_lex_state = 1},
  [68] = {.lex_state = 54, .external_lex_state = 1},
  [69] = {.lex_state = 54, .external_lex_state = 1},
  [70] = {.lex_state = 54, .external_lex_state = 1},
  [71] = {.lex_state = 54, .external_lex_state = 1},
  [72] = {.lex_state = 54, .external_lex_state = 1},
  [73] = {.lex_state = 54, .external_lex_state = 1},
  [74] = {.lex_state = 54, .external_lex_state = 1},
  [75] = {.lex_state = 54, .external_lex_state = 1},
  [76] = {.lex_state = 54, .external_lex_state = 1},
  [77] = {.lex_state = 54, .external_lex_state = 1},
  [78] = {.lex_state = 54, .external_lex_state = 1},
  [79] = {.lex_state = 54, .external_lex_state = 1},
  [80] = {.lex_state = 54, .external_lex_state = 1},
  [81] = {.lex_state = 54, .external_lex_state = 1},
  [82] = {.lex_state = 54, .external_lex_state = 1},
  [83] = {.lex_state = 54, .external_lex_state = 1},
  [84] = {.lex_state = 54, .external_lex_state = 1},
  [85] = {.lex_state = 54, .external_lex_state = 1},
  [86] = {.lex_state = 54, .external_lex_state = 1},
  [87] = {.lex_state = 54, .external_lex_state = 1},
  [88] = {.lex_state = 54, .external_lex_state = 1},
  [89] = {.lex_state = 54, .external_lex_state = 1},
  [90] = {.lex_state = 54, .external_lex_state = 1},
  [91] = {.lex_state = 54, .external_lex_state = 1},
  [92] = {.lex_state = 54, .external_lex_state = 1},
  [93] = {.lex_state = 54, .external_lex_state = 1},
  [94] = {.lex_state = 54, .external_lex_state = 1},
  [95] = {.lex_state = 54, .external_lex_state = 1},
  [96] = {.lex_state = 54, .external_lex_state = 1},
  [97] = {.lex_state = 54, .external_lex_state = 1},
  [98] = {.lex_state = 54, .external_lex_state = 1},
  [99] = {.lex_state = 54, .external_lex_state = 1},
  [100] = {.lex_state = 54, .external_lex_state = 1},
  [101] = {.lex_state = 54, .external_lex_state = 1},
  [102] = {.lex_state = 54, .external_lex_state = 1},
  [103] = {.lex_state = 54, .external_lex_state = 1},
  [104] = {.lex_state = 53, .external_lex_state = 1},
  [105] = {.lex_state = 53, .external_lex_state = 1},
  [106] = {.lex_state = 53, .external_lex_state = 1},
  [107] = {.lex_state = 53, .external_lex_state = 1},
  [108] = {.lex_state = 53, .external_lex_state = 1},
  [109] = {.lex_state = 53, .external_lex_state = 1},
  [110] = {.lex_state = 53, .external_lex_state = 1},
  [111] = {.lex_state = 53, .external_lex_state = 1},
  [112] = {.lex_state = 53, .external_lex_state = 1},
  [113] = {.lex_state = 53, .external_lex_state = 1},
  [114] = {.lex_state = 53, .external_lex_state = 1},
  [115] = {.lex_state = 53, .external_lex_state = 1},
  [116] = {.lex_state = 53, .external_lex_state = 1},
  [117] = {.lex_state = 53, .external_lex_state = 1},
  [118] = {.lex_state = 54, .external_lex_state = 1},
  [119] = {.lex_state = 54, .external_lex_state = 1},
  [120] = {.lex_state = 54, .external_lex_state = 1},
  [121] = {.lex_state = 54, .external_lex_state = 1},
  [122] = {.lex_state = 54, .external_lex_state = 1},
  [123] = {.lex_state = 54, .external_lex_state = 1},
  [124] = {.lex_state = 54, .external_lex_state = 1},
  [125] = {.lex_state = 54, .external_lex_state = 1},
  [126] = {.lex_state = 54, .external_lex_state = 1},
  [127] = {.lex_state = 54, .external_lex_state = 1},
  [128] = {.lex_state = 54, .external_lex_state = 1},
  [129] = {.lex_state = 54, .external_lex_state = 1},
  [130] = {.lex_state = 54, .external_lex_state = 1},
  [131] = {.lex_state = 54, .external_lex_state = 1},
  [132] = {.lex_state = 54, .external_lex_state = 1},
  [133] = {.lex_state = 54, .external_lex_state = 1},
  [134] = {.lex_state = 54, .external_lex_state = 1},
  [135] = {.lex_state = 54, .external_lex_state = 1},
  [136] = {.lex_state = 54, .external_lex_state = 1},
  [137] = {.lex_state = 54, .external_lex_state = 1},
  [138] = {.lex_state = 54, .external_lex_state = 1},
  [139] = {.lex_state = 54, .external_lex_state = 1},
  [140] = {.lex_state = 54, .external_lex_state = 1},
  [141] = {.lex_state = 54, .external_lex_state = 1},
  [142] = {.lex_state = 54, .external_lex_state = 1},
  [143] = {.lex_state = 54, .external_lex_state = 1},
  [144] = {.lex_state = 54, .external_lex_state = 1},
  [145] = {.lex_state = 54, .external_lex_state = 1},
  [146] = {.lex_state = 5, .external_lex_state = 1},
  [147] = {.lex_state = 5, .external_lex_state = 1},
  [148] = {.lex_state = 5, .external_lex_state = 1},
  [149] = {.lex_state = 5, .external_lex_state = 1},
  [150] = {.lex_state = 5, .external_lex_state = 1},
  [151] = {.lex_state = 5, .external_lex_state = 1},
  [152] = {.lex_state = 5, .external_lex_state = 1},
  [153] = {.lex_state = 5, .external_lex_state = 1},
  [154] = {.lex_state = 5, .external_lex_state = 1},
  [155] = {.lex_state = 5, .external_lex_state = 1},
  [156] = {.lex_state = 5, .external_lex_state = 1},
  [157] = {.lex_state = 5, .external_lex_state = 1},
  [158] = {.lex_state = 5, .external_lex_state = 1},
  [159] = {.lex_state = 5, .external_lex_state = 1},
  [160] = {.lex_state = 5, .external_lex_state = 1},
  [161] = {.lex_state = 5, .external_lex_state = 1},
  [162] = {.lex_state = 5, .external_lex_state = 1},
  [163] = {.lex_state = 5, .external_lex_state = 1},
  [164] = {.lex_state = 5, .external_lex_state = 1},
  [165] = {.lex_state = 7, .external_lex_state = 1},
  [166] = {.lex_state = 10, .external_lex_state = 1},
  [167] = {.lex_state = 5, .external_lex_state = 1},
  [168] = {.lex_state = 5, .external_lex_state = 1},
  [169] = {.lex_state = 5, .external_lex_state = 1},
  [170] = {.lex_state = 5, .external_lex_state = 1},
  [171] = {.lex_state = 5, .external_lex_state = 1},
  [172] = {.lex_state = 5, .external_lex_state = 1},
  [173] = {.lex_state = 5, .external_lex_state = 1},
  [174] = {.lex_state = 5, .external_lex_state = 1},
  [175] = {.lex_state = 5, .external_lex_state = 1},
  [176] = {.lex_state = 5, .external_lex_state = 1},
  [177] = {.lex_state = 5, .external_lex_state = 1},
  [178] = {.lex_state = 5, .external_lex_state = 1},
  [179] = {.lex_state = 5, .external_lex_state = 1},
  [180] = {.lex_state = 5, .external_lex_state = 1},
  [181] = {.lex_state = 5, .external_lex_state = 1},
  [182] = {.lex_state = 5, .external_lex_state = 1},
  [183] = {.lex_state = 5, .external_lex_state = 1},
  [184] = {.lex_state = 5, .external_lex_state = 1},
  [185] = {.lex_state = 5, .external_lex_state = 1},
  [186] = {.lex_state = 5, .external_lex_state = 1},
  [187] = {.lex_state = 5, .external_lex_state = 1},
  [188] = {.lex_state = 5, .external_lex_state = 1},
  [189] = {.lex_state = 5, .external_lex_state = 1},
  [190] = {.lex_state = 5, .external_lex_state = 1},
  [191] = {.lex_state = 5, .external_lex_state = 1},
  [192] = {.lex_state = 5, .external_lex_state = 1},
  [193] = {.lex_state = 5, .external_lex_state = 1},
  [194] = {.lex_state = 5, .external_lex_state = 1},
  [195] = {.lex_state = 5, .external_lex_state = 1},
  [196] = {.lex_state = 5, .external_lex_state = 1},
  [197] = {.lex_state = 5, .external_lex_state = 1},
  [198] = {.lex_state = 5, .external_lex_state = 1},
  [199] = {.lex_state = 5, .external_lex_state = 1},
  [200] = {.lex_state = 5, .external_lex_state = 1},
  [201] = {.lex_state = 5, .external_lex_state = 1},
  [202] = {.lex_state = 5, .external_lex_state = 1},
  [203] = {.lex_state = 5, .external_lex_state = 1},
  [204] = {.lex_state = 5, .external_lex_state = 1},
  [205] = {.lex_state = 5, .external_lex_state = 1},
  [206] = {.lex_state = 5, .external_lex_state = 1},
  [207] = {.lex_state = 5, .external_lex_state = 1},
  [208] = {.lex_state = 5, .external_lex_state = 1},
  [209] = {.lex_state = 5, .external_lex_state = 1},
  [210] = {.lex_state = 5, .external_lex_state = 1},
  [211] = {.lex_state = 5, .external_lex_state = 1},
  [212] = {.lex_state = 5, .external_lex_state = 1},
  [213] = {.lex_state = 5, .external_lex_state = 1},
  [214] = {.lex_state = 5, .external_lex_state = 1},
  [215] = {.lex_state = 5, .external_lex_state = 1},
  [216] = {.lex_state = 5, .external_lex_state = 1},
  [217] = {.lex_state = 5, .external_lex_state = 1},
  [218] = {.lex_state = 5, .external_lex_state = 1},
  [219] = {.lex_state = 5, .external_lex_state = 1},
  [220] = {.lex_state = 5, .external_lex_state = 1},
  [221] = {.lex_state = 5, .external_lex_state = 1},
  [222] = {.lex_state = 5, .external_lex_state = 1},
  [223] = {.lex_state = 5, .external_lex_state = 1},
  [224] = {.lex_state = 5, .external_lex_state = 1},
  [225] = {.lex_state = 5, .external_lex_state = 1},
  [226] = {.lex_state = 5, .external_lex_state = 1},
  [227] = {.lex_state = 5, .external_lex_state = 1},
  [228] = {.lex_state = 5, .external_lex_state = 1},
  [229] = {.lex_state = 5, .external_lex_state = 1},
  [230] = {.lex_state = 5, .external_lex_state = 1},
  [231] = {.lex_state = 5, .external_lex_state = 1},
  [232] = {.lex_state = 5, .external_lex_state = 1},
  [233] = {.lex_state = 5, .external_lex_state = 1},
  [234] = {.lex_state = 5, .external_lex_state = 1},
  [235] = {.lex_state = 5, .external_lex_state = 1},
  [236] = {.lex_state = 5, .external_lex_state = 1},
  [237] = {.lex_state = 5, .external_lex_state = 1},
  [238] = {.lex_state = 5, .external_lex_state = 1},
  [239] = {.lex_state = 5, .external_lex_state = 1},
  [240] = {.lex_state = 5, .external_lex_state = 1},
  [241] = {.lex_state = 5, .external_lex_state = 1},
  [242] = {.lex_state = 5, .external_lex_state = 1},
  [243] = {.lex_state = 5, .external_lex_state = 1},
  [244] = {.lex_state = 5, .external_lex_state = 1},
  [245] = {.lex_state = 5, .external_lex_state = 1},
  [246] = {.lex_state = 5, .external_lex_state = 1},
  [247] = {.lex_state = 5, .external_lex_state = 1},
  [248] = {.lex_state = 5, .external_lex_state = 1},
  [249] = {.lex_state = 5, .external_lex_state = 1},
  [250] = {.lex_state = 5, .external_lex_state = 1},
  [251] = {.lex_state = 5, .external_lex_state = 1},
  [252] = {.lex_state = 5, .external_lex_state = 1},
  [253] = {.lex_state = 5, .external_lex_state = 1},
  [254] = {.lex_state = 5, .external_lex_state = 1},
  [255] = {.lex_state = 8, .external_lex_state = 1},
  [256] = {.lex_state = 5, .external_lex_state = 1},
  [257] = {.lex_state = 5, .external_lex_state = 1},
  [258] = {.lex_state = 5, .external_lex_state = 1},
  [259] = {.lex_state = 5, .external_lex_state = 1},
  [260] = {.lex_state = 5, .external_lex_state = 1},
  [261] = {.lex_state = 5, .external_lex_state = 1},
  [262] = {.lex_state = 5, .external_lex_state = 1},
  [263] = {.lex_state = 5, .external_lex_state = 1},
  [264] = {.lex_state = 5, .external_lex_state = 1},
  [265] = {.lex_state = 5, .external_lex_state = 1},
  [266] = {.lex_state = 5, .external_lex_state = 1},
  [267] = {.lex_state = 5, .external_lex_state = 1},
  [268] = {.lex_state = 5, .external_lex_state = 1},
  [269] = {.lex_state = 5, .external_lex_state = 1},
  [270] = {.lex_state = 5, .external_lex_state = 1},
  [271] = {.lex_state = 5, .external_lex_state = 1},
  [272] = {.lex_state = 5, .external_lex_state = 1},
  [273] = {.lex_state = 5, .external_lex_state = 1},
  [274] = {.lex_state = 5, .external_lex_state = 1},
  [275] = {.lex_state = 5, .external_lex_state = 1},
  [276] = {.lex_state = 5, .external_lex_state = 1},
  [277] = {.lex_state = 5, .external_lex_state = 1},
  [278] = {.lex_state = 5, .external_lex_state = 1},
  [279] = {.lex_state = 5, .external_lex_state = 1},
  [280] = {.lex_state = 9, .external_lex_state = 1},
  [281] = {.lex_state = 5, .external_lex_state = 1},
  [282] = {.lex_state = 9, .external_lex_state = 1},
  [283] = {.lex_state = 9, .external_lex_state = 1},
  [284] = {.lex_state = 5, .external_lex_state = 1},
  [285] = {.lex_state = 5, .external_lex_state = 1},
  [286] = {.lex_state = 5, .external_lex_state = 1},
  [287] = {.lex_state = 5, .external_lex_state = 1},
  [288] = {.lex_state = 5, .external_lex_state = 1},
  [289] = {.lex_state = 5, .external_lex_state = 1},
  [290] = {.lex_state = 5, .external_lex_state = 1},
  [291] = {.lex_state = 5, .external_lex_state = 1},
  [292] = {.lex_state = 5, .external_lex_state = 1},
  [293] = {.lex_state = 5, .external_lex_state = 1},
  [294] = {.lex_state = 5, .external_lex_state = 1},
  [295] = {.lex_state = 5, .external_lex_state = 1},
  [296] = {.lex_state = 5, .external_lex_state = 1},
  [297] = {.lex_state = 5, .external_lex_state = 1},
  [298] = {.lex_state = 5, .external_lex_state = 1},
  [299] = {.lex_state = 5, .external_lex_state = 1},
  [300] = {.lex_state = 5, .external_lex_state = 1},
  [301] = {.lex_state = 5, .external_lex_state = 1},
  [302] = {.lex_state = 5, .external_lex_state = 1},
  [303] = {.lex_state = 5, .external_lex_state = 1},
  [304] = {.lex_state = 5, .external_lex_state = 1},
  [305] = {.lex_state = 5, .external_lex_state = 1},
  [306] = {.lex_state = 5, .external_lex_state = 1},
  [307] = {.lex_state = 5, .external_lex_state = 1},
  [308] = {.lex_state = 5, .external_lex_state = 1},
  [309] = {.lex_state = 5, .external_lex_state = 1},
  [310] = {.lex_state = 5, .external_lex_state = 1},
  [311] = {.lex_state = 5, .external_lex_state = 1},
  [312] = {.lex_state = 5, .external_lex_state = 1},
  [313] = {.lex_state = 5, .external_lex_state = 1},
  [314] = {.lex_state = 5, .external_lex_state = 1},
  [315] = {.lex_state = 5, .external_lex_state = 1},
  [316] = {.lex_state = 5, .external_lex_state = 1},
  [317] = {.lex_state = 5, .external_lex_state = 1},
  [318] = {.lex_state = 5, .external_lex_state = 1},
  [319] = {.lex_state = 5, .external_lex_state = 1},
  [320] = {.lex_state = 5, .external_lex_state = 1},
  [321] = {.lex_state = 9, .external_lex_state = 1},
  [322] = {.lex_state = 5, .external_lex_state = 1},
  [323] = {.lex_state = 5, .external_lex_state = 1},
  [324] = {.lex_state = 5, .external_lex_state = 1},
  [325] = {.lex_state = 5, .external_lex_state = 1},
  [326] = {.lex_state = 9, .external_lex_state = 1},
  [327] = {.lex_state = 5, .external_lex_state = 1},
  [328] = {.lex_state = 5, .external_lex_state = 1},
  [329] = {.lex_state = 5, .external_lex_state = 1},
  [330] = {.lex_state = 5, .external_lex_state = 1},
  [331] = {.lex_state = 10, .external_lex_state = 1},
  [332] = {.lex_state = 54, .external_lex_state = 1},
  [333] = {.lex_state = 10, .external_lex_state = 1},
  [334] = {.lex_state = 10, .external_lex_state = 1},
  [335] = {.lex_state = 54, .external_lex_state = 1},
  [336] = {.lex_state = 10, .external_lex_state = 1},
  [337] = {.lex_state = 54, .external_lex_state = 1},
  [338] = {.lex_state = 10, .external_lex_state = 1},
  [339] = {.lex_state = 10, .external_lex_state = 1},
  [340] = {.lex_state = 10, .external_lex_state = 1},
  [341] = {.lex_state = 10, .external_lex_state = 1},
  [342] = {.lex_state = 10, .external_lex_state = 1},
  [343] = {.lex_state = 10, .external_lex_state = 1},
  [344] = {.lex_state = 10, .external_lex_state = 1},
  [345] = {.lex_state = 10, .external_lex_state = 1},
  [346] = {.lex_state = 10, .external_lex_state = 1},
  [347] = {.lex_state = 10, .external_lex_state = 1},
  [348] = {.lex_state = 10, .external_lex_state = 1},
  [349] = {.lex_state = 10, .external_lex_state = 1},
  [350] = {.lex_state = 10, .external_lex_state = 1},
  [351] = {.lex_state = 10, .external_lex_state = 1},
  [352] = {.lex_state = 10, .external_lex_state = 1},
  [353] = {.lex_state = 10, .external_lex_state = 1},
  [354] = {.lex_state = 10, .external_lex_state = 1},
  [355] = {.lex_state = 10, .external_lex_state = 1},
  [356] = {.lex_state = 10, .external_lex_state = 1},
  [357] = {.lex_state = 10, .external_lex_state = 1},
  [358] = {.lex_state = 10, .external_lex_state = 1},
  [359] = {.lex_state = 10, .external_lex_state = 1},
  [360] = {.lex_state = 10, .external_lex_state = 1},
  [361] = {.lex_state = 10, .external_lex_state = 1},
  [362] = {.lex_state = 10, .external_lex_state = 1},
  [363] = {.lex_state = 10, .external_lex_state = 1},
  [364] = {.lex_state = 10, .external_lex_state = 1},
  [365] = {.lex_state = 10, .external_lex_state = 1},
  [366] = {.lex_state = 10, .external_lex_state = 1},
  [367] = {.lex_state = 10, .external_lex_state = 1},
  [368] = {.lex_state = 10, .external_lex_state = 1},
  [369] = {.lex_state = 15, .external_lex_state = 1},
  [370] = {.lex_state = 15, .external_lex_state = 1},
  [371] = {.lex_state = 13, .external_lex_state = 1},
  [372] = {.lex_state = 13, .external_lex_state = 1},
  [373] = {.lex_state = 10, .external_lex_state = 1},
  [374] = {.lex_state = 3, .external_lex_state = 1},
  [375] = {.lex_state = 10, .external_lex_state = 1},
  [376] = {.lex_state = 10, .external_lex_state = 1},
  [377] = {.lex_state = 0, .external_lex_state = 1},
  [378] = {.lex_state = 15, .external_lex_state = 1},
  [379] = {.lex_state = 10, .external_lex_state = 1},
  [380] = {.lex_state = 10, .external_lex_state = 1},
  [381] = {.lex_state = 10, .external_lex_state = 1},
  [382] = {.lex_state = 3, .external_lex_state = 1},
  [383] = {.lex_state = 10, .external_lex_state = 1},
  [384] = {.lex_state = 10, .external_lex_state = 1},
  [385] = {.lex_state = 0, .external_lex_state = 1},
  [386] = {.lex_state = 10, .external_lex_state = 1},
  [387] = {.lex_state = 10, .external_lex_state = 1},
  [388] = {.lex_state = 13, .external_lex_state = 1},
  [389] = {.lex_state = 10, .external_lex_state = 1},
  [390] = {.lex_state = 0, .external_lex_state = 1},
  [391] = {.lex_state = 10, .external_lex_state = 1},
  [392] = {.lex_state = 10, .external_lex_state = 1},
  [393] = {.lex_state = 10, .external_lex_state = 1},
  [394] = {.lex_state = 10, .external_lex_state = 1},
  [395] = {.lex_state = 10, .external_lex_state = 1},
  [396] = {.lex_state = 10, .external_lex_state = 1},
  [397] = {.lex_state = 10, .external_lex_state = 1},
  [398] = {.lex_state = 10, .external_lex_state = 1},
  [399] = {.lex_state = 0, .external_lex_state = 1},
  [400] = {.lex_state = 0, .external_lex_state = 1},
  [401] = {.lex_state = 10, .external_lex_state = 1},
  [402] = {.lex_state = 10, .external_lex_state = 1},
  [403] = {.lex_state = 10, .external_lex_state = 1},
  [404] = {.lex_state = 10, .external_lex_state = 1},
  [405] = {.lex_state = 10, .external_lex_state = 1},
  [406] = {.lex_state = 10, .external_lex_state = 1},
  [407] = {.lex_state = 10, .external_lex_state = 1},
  [408] = {.lex_state = 0, .external_lex_state = 1},
  [409] = {.lex_state = 10, .external_lex_state = 1},
  [410] = {.lex_state = 10, .external_lex_state = 1},
  [411] = {.lex_state = 10, .external_lex_state = 1},
  [412] = {.lex_state = 10, .external_lex_state = 1},
  [413] = {.lex_state = 10, .external_lex_state = 1},
  [414] = {.lex_state = 10, .external_lex_state = 1},
  [415] = {.lex_state = 3, .external_lex_state = 1},
  [416] = {.lex_state = 10, .external_lex_state = 1},
  [417] = {.lex_state = 10, .external_lex_state = 1},
  [418] = {.lex_state = 3, .external_lex_state = 1},
  [419] = {.lex_state = 10, .external_lex_state = 1},
  [420] = {.lex_state = 3, .external_lex_state = 1},
  [421] = {.lex_state = 10, .external_lex_state = 1},
  [422] = {.lex_state = 3, .external_lex_state = 1},
  [423] = {.lex_state = 3, .external_lex_state = 1},
  [424] = {.lex_state = 3, .external_lex_state = 1},
  [425] = {.lex_state = 10, .external_lex_state = 1},
  [426] = {.lex_state = 0, .external_lex_state = 1},
  [427] = {.lex_state = 13, .external_lex_state = 1},
  [428] = {.lex_state = 3, .external_lex_state = 1},
  [429] = {.lex_state = 13, .external_lex_state = 1},
  [430] = {.lex_state = 13, .external_lex_state = 1},
  [431] = {.lex_state = 3, .external_lex_state = 1},
  [432] = {.lex_state = 1, .external_lex_state = 1},
  [433] = {.lex_state = 1, .external_lex_state = 1},
  [434] = {.lex_state = 1, .external_lex_state = 1},
  [435] = {.lex_state = 3, .external_lex_state = 1},
  [436] = {.lex_state = 13, .external_lex_state = 1},
  [437] = {.lex_state = 0, .external_lex_state = 1},
  [438] = {.lex_state = 10, .external_lex_state = 1},
  [439] = {.lex_state = 10, .external_lex_state = 1},
  [440] = {.lex_state = 10, .external_lex_state = 1},
  [441] = {.lex_state = 3, .external_lex_state = 1},
  [442] = {.lex_state = 3, .external_lex_state = 1},
  [443] = {.lex_state = 3, .external_lex_state = 1},
  [444] = {.lex_state = 13, .external_lex_state = 1},
  [445] = {.lex_state = 3, .external_lex_state = 1},
  [446] = {.lex_state = 0, .external_lex_state = 1},
  [447] = {.lex_state = 3, .external_lex_state = 1},
  [448] = {.lex_state = 0, .external_lex_state = 1},
  [449] = {.lex_state = 0, .external_lex_state = 1},
  [450] = {.lex_state = 3, .external_lex_state = 1},
  [451] = {.lex_state = 3, .external_lex_state = 1},
  [452] = {.lex_state = 13, .external_lex_state = 1},
  [453] = {.lex_state = 13, .external_lex_state = 1},
  [454] = {.lex_state = 3, .external_lex_state = 1},
  [455] = {.lex_state = 3, .external_lex_state = 1},
  [456] = {.lex_state = 1, .external_lex_state = 1},
  [457] = {.lex_state = 1, .external_lex_state = 1},
  [458] = {.lex_state = 13, .external_lex_state = 1},
  [459] = {.lex_state = 13, .external_lex_state = 1},
  [460] = {.lex_state = 13, .external_lex_state = 1},
  [461] = {.lex_state = 13, .external_lex_state = 1},
  [462] = {.lex_state = 13, .external_lex_state = 1},
  [463] = {.lex_state = 1, .external_lex_state = 1},
  [464] = {.lex_state = 3, .external_lex_state = 1},
  [465] = {.lex_state = 13, .external_lex_state = 1},
  [466] = {.lex_state = 13, .external_lex_state = 1},
  [467] = {.lex_state = 13, .external_lex_state = 1},
  [468] = {.lex_state = 13, .external_lex_state = 1},
  [469] = {.lex_state = 13, .external_lex_state = 1},
  [470] = {.lex_state = 13, .external_lex_state = 1},
  [471] = {.lex_state = 13, .external_lex_state = 1},
  [472] = {.lex_state = 3, .external_lex_state = 1},
  [473] = {.lex_state = 0, .external_lex_state = 1},
  [474] = {.lex_state = 13, .external_lex_state = 1},
  [475] = {.lex_state = 3, .external_lex_state = 1},
  [476] = {.lex_state = 1, .external_lex_state = 1},
  [477] = {.lex_state = 3, .external_lex_state = 1},
  [478] = {.lex_state = 10, .external_lex_state = 1},
  [479] = {.lex_state = 3, .external_lex_state = 1},
  [480] = {.lex_state = 13, .external_lex_state = 1},
  [481] = {.lex_state = 0, .external_lex_state = 1},
  [482] = {.lex_state = 0, .external_lex_state = 1},
  [483] = {.lex_state = 0, .external_lex_state = 1},
  [484] = {.lex_state = 1, .external_lex_state = 1},
  [485] = {.lex_state = 0, .external_lex_state = 1},
  [486] = {.lex_state = 0, .external_lex_state = 1},
  [487] = {.lex_state = 0, .external_lex_state = 1},
  [488] = {.lex_state = 0, .external_lex_state = 1},
  [489] = {.lex_state = 0, .external_lex_state = 1},
  [490] = {.lex_state = 0, .external_lex_state = 1},
  [491] = {.lex_state = 0, .external_lex_state = 1},
  [492] = {.lex_state = 0, .external_lex_state = 1},
  [493] = {.lex_state = 0, .external_lex_state = 1},
  [494] = {.lex_state = 0, .external_lex_state = 1},
  [495] = {.lex_state = 0, .external_lex_state = 1},
  [496] = {.lex_state = 0, .external_lex_state = 1},
  [497] = {.lex_state = 0, .external_lex_state = 1},
  [498] = {.lex_state = 0, .external_lex_state = 1},
  [499] = {.lex_state = 0, .external_lex_state = 1},
  [500] = {.lex_state = 0, .external_lex_state = 1},
  [501] = {.lex_state = 10, .external_lex_state = 1},
  [502] = {.lex_state = 0, .external_lex_state = 1},
  [503] = {.lex_state = 13, .external_lex_state = 1},
  [504] = {.lex_state = 25, .external_lex_state = 1},
  [505] = {.lex_state = 25, .external_lex_state = 1},
  [506] = {.lex_state = 25, .external_lex_state = 1},
  [507] = {.lex_state = 0, .external_lex_state = 1},
  [508] = {.lex_state = 0, .external_lex_state = 1},
  [509] = {.lex_state = 0, .external_lex_state = 1},
  [510] = {.lex_state = 0, .external_lex_state = 1},
  [511] = {.lex_state = 0, .external_lex_state = 1},
  [512] = {.lex_state = 25, .external_lex_state = 1},
  [513] = {.lex_state = 10, .external_lex_state = 1},
  [514] = {.lex_state = 12, .external_lex_state = 1},
  [515] = {.lex_state = 10, .external_lex_state = 1},
  [516] = {.lex_state = 25, .external_lex_state = 1},
  [517] = {.lex_state = 10, .external_lex_state = 1},
  [518] = {.lex_state = 0, .external_lex_state = 1},
  [519] = {.lex_state = 0, .external_lex_state = 1},
  [520] = {.lex_state = 0, .external_lex_state = 1},
  [521] = {.lex_state = 0, .external_lex_state = 1},
  [522] = {.lex_state = 0, .external_lex_state = 1},
  [523] = {.lex_state = 0, .external_lex_state = 1},
  [524] = {.lex_state = 0, .external_lex_state = 1},
  [525] = {.lex_state = 0, .external_lex_state = 1},
  [526] = {.lex_state = 0, .external_lex_state = 1},
  [527] = {.lex_state = 0, .external_lex_state = 1},
  [528] = {.lex_state = 10, .external_lex_state = 1},
  [529] = {.lex_state = 25, .external_lex_state = 1},
  [530] = {.lex_state = 0, .external_lex_state = 1},
  [531] = {.lex_state = 10, .external_lex_state = 1},
  [532] = {.lex_state = 10, .external_lex_state = 1},
  [533] = {.lex_state = 10, .external_lex_state = 1},
  [534] = {.lex_state = 10, .external_lex_state = 1},
  [535] = {.lex_state = 10, .external_lex_state = 1},
  [536] = {.lex_state = 10, .external_lex_state = 1},
  [537] = {.lex_state = 12, .external_lex_state = 1},
  [538] = {.lex_state = 10, .external_lex_state = 1},
  [539] = {.lex_state = 0, .external_lex_state = 1},
  [540] = {.lex_state = 0, .external_lex_state = 1},
  [541] = {.lex_state = 10, .external_lex_state = 1},
  [542] = {.lex_state = 0, .external_lex_state = 1},
  [543] = {.lex_state = 10, .external_lex_state = 1},
  [544] = {.lex_state = 0, .external_lex_state = 1},
  [545] = {.lex_state = 7, .external_lex_state = 1},
  [546] = {.lex_state = 10, .external_lex_state = 1},
  [547] = {.lex_state = 10, .external_lex_state = 1},
  [548] = {.lex_state = 0, .external_lex_state = 1},
  [549] = {.lex_state = 0, .external_lex_state = 1},
  [550] = {.lex_state = 0, .external_lex_state = 1},
  [551] = {.lex_state = 10, .external_lex_state = 1},
  [552] = {.lex_state = 10, .external_lex_state = 1},
  [553] = {.lex_state = 0, .external_lex_state = 1},
  [554] = {.lex_state = 10, .external_lex_state = 1},
  [555] = {.lex_state = 0, .external_lex_state = 1},
  [556] = {.lex_state = 10, .external_lex_state = 1},
  [557] = {.lex_state = 12, .external_lex_state = 1},
  [558] = {.lex_state = 10, .external_lex_state = 1},
  [559] = {.lex_state = 0, .external_lex_state = 1},
  [560] = {.lex_state = 0, .external_lex_state = 1},
  [561] = {.lex_state = 0, .external_lex_state = 1},
  [562] = {.lex_state = 0, .external_lex_state = 1},
  [563] = {.lex_state = 0, .external_lex_state = 1},
  [564] = {.lex_state = 0, .external_lex_state = 1},
  [565] = {.lex_state = 0, .external_lex_state = 1},
  [566] = {.lex_state = 7, .external_lex_state = 1},
  [567] = {.lex_state = 54, .external_lex_state = 1},
  [568] = {.lex_state = 0, .external_lex_state = 1},
  [569] = {.lex_state = 0, .external_lex_state = 1},
  [570] = {.lex_state = 0, .external_lex_state = 1},
  [571] = {.lex_state = 0, .external_lex_state = 1},
  [572] = {.lex_state = 0, .external_lex_state = 1},
  [573] = {.lex_state = 10, .external_lex_state = 1},
  [574] = {.lex_state = 0, .external_lex_state = 1},
  [575] = {.lex_state = 0, .external_lex_state = 1},
  [576] = {.lex_state = 0, .external_lex_state = 1},
  [577] = {.lex_state = 7, .external_lex_state = 1},
  [578] = {.lex_state = 7, .external_lex_state = 1},
  [579] = {.lex_state = 0, .external_lex_state = 1},
  [580] = {.lex_state = 0, .external_lex_state = 1},
  [581] = {.lex_state = 0, .external_lex_state = 1},
  [582] = {.lex_state = 0, .external_lex_state = 1},
  [583] = {.lex_state = 54, .external_lex_state = 1},
  [584] = {.lex_state = 7, .external_lex_state = 1},
  [585] = {.lex_state = 0, .external_lex_state = 1},
  [586] = {.lex_state = 0, .external_lex_state = 1},
  [587] = {.lex_state = 0, .external_lex_state = 1},
  [588] = {.lex_state = 0, .external_lex_state = 1},
  [589] = {.lex_state = 0, .external_lex_state = 1},
  [590] = {.lex_state = 0, .external_lex_state = 1},
  [591] = {.lex_state = 0, .external_lex_state = 1},
  [592] = {.lex_state = 0, .external_lex_state = 1},
  [593] = {.lex_state = 0, .external_lex_state = 1},
  [594] = {.lex_state = 0, .external_lex_state = 1},
  [595] = {.lex_state = 0, .external_lex_state = 1},
  [596] = {.lex_state = 10, .external_lex_state = 1},
  [597] = {.lex_state = 0, .external_lex_state = 1},
  [598] = {.lex_state = 0, .external_lex_state = 1},
  [599] = {.lex_state = 0, .external_lex_state = 1},
  [600] = {.lex_state = 7, .external_lex_state = 1},
  [601] = {.lex_state = 0, .external_lex_state = 1},
  [602] = {.lex_state = 0, .external_lex_state = 1},
  [603] = {.lex_state = 0, .external_lex_state = 1},
  [604] = {.lex_state = 0, .external_lex_state = 1},
  [605] = {.lex_state = 0, .external_lex_state = 1},
  [606] = {.lex_state = 0, .external_lex_state = 1},
  [607] = {.lex_state = 0, .external_lex_state = 1},
  [608] = {.lex_state = 0, .external_lex_state = 1},
  [609] = {.lex_state = 0, .external_lex_state = 1},
  [610] = {.lex_state = 0, .external_lex_state = 1},
  [611] = {.lex_state = 0, .external_lex_state = 1},
  [612] = {.lex_state = 0, .external_lex_state = 1},
  [613] = {.lex_state = 0, .external_lex_state = 1},
  [614] = {.lex_state = 0, .external_lex_state = 1},
  [615] = {.lex_state = 0, .external_lex_state = 1},
  [616] = {.lex_state = 0, .external_lex_state = 1},
  [617] = {.lex_state = 7, .external_lex_state = 1},
  [618] = {.lex_state = 0, .external_lex_state = 1},
  [619] = {.lex_state = 0, .external_lex_state = 1},
  [620] = {.lex_state = 0, .external_lex_state = 1},
  [621] = {.lex_state = 7, .external_lex_state = 1},
  [622] = {.lex_state = 0, .external_lex_state = 1},
  [623] = {.lex_state = 0, .external_lex_state = 1},
  [624] = {.lex_state = 0, .external_lex_state = 1},
  [625] = {.lex_state = 0, .external_lex_state = 1},
  [626] = {.lex_state = 0, .external_lex_state = 1},
  [627] = {.lex_state = 0, .external_lex_state = 1},
  [628] = {.lex_state = 0, .external_lex_state = 1},
  [629] = {.lex_state = 0, .external_lex_state = 1},
  [630] = {.lex_state = 0, .external_lex_state = 1},
  [631] = {.lex_state = 54, .external_lex_state = 1},
  [632] = {.lex_state = 0, .external_lex_state = 1},
  [633] = {.lex_state = 0, .external_lex_state = 1},
  [634] = {.lex_state = 0, .external_lex_state = 1},
  [635] = {.lex_state = 0, .external_lex_state = 1},
  [636] = {.lex_state = 0, .external_lex_state = 1},
  [637] = {.lex_state = 7, .external_lex_state = 1},
  [638] = {.lex_state = 0, .external_lex_state = 1},
  [639] = {.lex_state = 0, .external_lex_state = 1},
  [640] = {.lex_state = 0, .external_lex_state = 1},
  [641] = {.lex_state = 0, .external_lex_state = 1},
  [642] = {.lex_state = 0, .external_lex_state = 1},
  [643] = {.lex_state = 0, .external_lex_state = 1},
  [644] = {.lex_state = 0, .external_lex_state = 1},
  [645] = {.lex_state = 0, .external_lex_state = 1},
  [646] = {.lex_state = 0, .external_lex_state = 1},
  [647] = {.lex_state = 7, .external_lex_state = 1},
  [648] = {.lex_state = 7, .external_lex_state = 1},
  [649] = {.lex_state = 0, .external_lex_state = 1},
  [650] = {.lex_state = 0, .external_lex_state = 1},
  [651] = {.lex_state = 0, .external_lex_state = 1},
  [652] = {.lex_state = 10, .external_lex_state = 1},
  [653] = {.lex_state = 0, .external_lex_state = 1},
  [654] = {.lex_state = 10, .external_lex_state = 1},
  [655] = {.lex_state = 0, .external_lex_state = 1},
  [656] = {.lex_state = 0, .external_lex_state = 1},
  [657] = {.lex_state = 0, .external_lex_state = 1},
  [658] = {.lex_state = 0, .external_lex_state = 1},
  [659] = {.lex_state = 0, .external_lex_state = 1},
  [660] = {.lex_state = 0, .external_lex_state = 1},
  [661] = {.lex_state = 0, .external_lex_state = 1},
  [662] = {.lex_state = 0, .external_lex_state = 1},
  [663] = {.lex_state = 0, .external_lex_state = 1},
  [664] = {.lex_state = 0, .external_lex_state = 1},
  [665] = {.lex_state = 0, .external_lex_state = 1},
  [666] = {.lex_state = 0, .external_lex_state = 1},
  [667] = {.lex_state = 0, .external_lex_state = 1},
  [668] = {.lex_state = 0, .external_lex_state = 1},
  [669] = {.lex_state = 0, .external_lex_state = 1},
  [670] = {.lex_state = 0, .external_lex_state = 1},
  [671] = {.lex_state = 0, .external_lex_state = 1},
  [672] = {.lex_state = 0, .external_lex_state = 1},
  [673] = {.lex_state = 0, .external_lex_state = 1},
  [674] = {.lex_state = 0, .external_lex_state = 1},
  [675] = {.lex_state = 0, .external_lex_state = 1},
  [676] = {.lex_state = 0, .external_lex_state = 1},
  [677] = {.lex_state = 0, .external_lex_state = 1},
  [678] = {.lex_state = 10, .external_lex_state = 1},
  [679] = {.lex_state = 0, .external_lex_state = 1},
  [680] = {.lex_state = 0, .external_lex_state = 1},
  [681] = {.lex_state = 0, .external_lex_state = 1},
  [682] = {.lex_state = 10, .external_lex_state = 1},
  [683] = {(TSStateId)(-1)},
};

enum {
  ts_external_token_block_comment = 0,
};

static const TSSymbol ts_external_scanner_symbol_map[EXTERNAL_TOKEN_COUNT] = {
  [ts_external_token_block_comment] = sym_block_comment,
};

static const bool ts_external_scanner_states[2][EXTERNAL_TOKEN_COUNT] = {
  [1] = {
    [ts_external_token_block_comment] = true,
  },
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [sym_line_comment] = STATE(0),
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_arg] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_pi] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [anon_sym_BSLASH] = ACTIONS(1),
    [aux_sym_symbol_token1] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym_char] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_inf] = ACTIONS(1),
    [anon_sym_nil] = ACTIONS(1),
    [anon_sym_thisFunction] = ACTIONS(1),
    [anon_sym_thisFunctionDef] = ACTIONS(1),
    [anon_sym_thisMethod] = ACTIONS(1),
    [anon_sym_thisProcess] = ACTIONS(1),
    [anon_sym_thisThread] = ACTIONS(1),
    [anon_sym_currentEnvironment] = ACTIONS(1),
    [anon_sym_topEnvironment] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_GT] = ACTIONS(1),
    [anon_sym_classvar] = ACTIONS(1),
    [anon_sym_const] = ACTIONS(1),
    [aux_sym_environment_var_token1] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(1),
    [anon_sym_POUND] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_Bag] = ACTIONS(1),
    [anon_sym_Dictionary] = ACTIONS(1),
    [anon_sym_Environment] = ACTIONS(1),
    [anon_sym_Event] = ACTIONS(1),
    [anon_sym_IdentityBag] = ACTIONS(1),
    [anon_sym_IdentityDictionary] = ACTIONS(1),
    [anon_sym_IdentitySet] = ACTIONS(1),
    [anon_sym_LazyEnvir] = ACTIONS(1),
    [anon_sym_MultiLevelIdentityDictionary] = ACTIONS(1),
    [anon_sym_ObjectTable] = ACTIONS(1),
    [anon_sym_Set] = ACTIONS(1),
    [anon_sym_TwoWayIdentityDictionary] = ACTIONS(1),
    [anon_sym_Array] = ACTIONS(1),
    [anon_sym_Array2D] = ACTIONS(1),
    [anon_sym_ArrayedCollection] = ACTIONS(1),
    [anon_sym_DoubleArray] = ACTIONS(1),
    [anon_sym_FloatArray] = ACTIONS(1),
    [anon_sym_Int16Array] = ACTIONS(1),
    [anon_sym_Int32Array] = ACTIONS(1),
    [anon_sym_Int8Array] = ACTIONS(1),
    [anon_sym_LinkedList] = ACTIONS(1),
    [anon_sym_List] = ACTIONS(1),
    [anon_sym_Order] = ACTIONS(1),
    [anon_sym_OrderedIdentitySet] = ACTIONS(1),
    [anon_sym_Pair] = ACTIONS(1),
    [anon_sym_PriorityQueue] = ACTIONS(1),
    [anon_sym_RawArray] = ACTIONS(1),
    [anon_sym_SequenceableCollection] = ACTIONS(1),
    [anon_sym_Signal] = ACTIONS(1),
    [anon_sym_SortedList] = ACTIONS(1),
    [anon_sym_SparseArray] = ACTIONS(1),
    [anon_sym_String] = ACTIONS(1),
    [anon_sym_SymbolArray] = ACTIONS(1),
    [anon_sym_DOT_DOT] = ACTIONS(1),
    [anon_sym_PIPE_AT_PIPE] = ACTIONS(1),
    [anon_sym_AT_AT] = ACTIONS(1),
    [anon_sym_AT_PIPE_AT] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(1),
    [aux_sym_class_token1] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_BANG_QMARK] = ACTIONS(1),
    [anon_sym_QMARK_QMARK] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_DOTwhile] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_DOTfor] = ACTIONS(1),
    [anon_sym_forBy] = ACTIONS(1),
    [anon_sym_DOTforBy] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [sym_block_comment] = ACTIONS(5),
  },
  [1] = {
    [sym_source_file] = STATE(664),
    [sym__expression] = STATE(129),
    [sym__expression_statement] = STATE(663),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym_code_block] = STATE(114),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_class_def] = STATE(124),
    [sym_line_comment] = STATE(1),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(273),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym_source_file_repeat1] = STATE(14),
    [ts_builtin_sym_end] = ACTIONS(7),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [2] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(530),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_list] = STATE(15),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(2),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(77),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(79),
    [anon_sym_arg] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_PIPE] = ACTIONS(83),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [3] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(588),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_list] = STATE(23),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(3),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(85),
    [anon_sym_arg] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_PIPE] = ACTIONS(83),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [4] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(653),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_list] = STATE(21),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(4),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(87),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_arg] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_PIPE] = ACTIONS(83),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [5] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(660),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_list] = STATE(24),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(5),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(79),
    [anon_sym_arg] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_PIPE] = ACTIONS(83),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [6] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(576),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_list] = STATE(22),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(6),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(89),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_arg] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_PIPE] = ACTIONS(83),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [7] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(666),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_list] = STATE(20),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(7),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_arg] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_PIPE] = ACTIONS(83),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [8] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(620),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_list] = STATE(16),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(8),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(93),
    [anon_sym_arg] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_PIPE] = ACTIONS(83),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [9] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(586),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(282),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(9),
    [sym_collection] = STATE(244),
    [sym__paired_associative_sequence] = STATE(661),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(481),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(97),
    [anon_sym_LBRACE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(101),
    [sym_integer] = ACTIONS(103),
    [sym_hexinteger] = ACTIONS(105),
    [sym_float] = ACTIONS(101),
    [sym_exponential] = ACTIONS(105),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(107),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [10] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(636),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_list] = STATE(17),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(10),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(109),
    [anon_sym_arg] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_PIPE] = ACTIONS(83),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [11] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(606),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_list] = STATE(19),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(11),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(77),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_arg] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_PIPE] = ACTIONS(83),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [12] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(662),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(282),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(12),
    [sym_collection] = STATE(244),
    [sym__paired_associative_sequence] = STATE(661),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(481),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(111),
    [anon_sym_LBRACE] = ACTIONS(99),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(101),
    [sym_integer] = ACTIONS(103),
    [sym_hexinteger] = ACTIONS(105),
    [sym_float] = ACTIONS(101),
    [sym_exponential] = ACTIONS(105),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(107),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [13] = {
    [sym__expression] = STATE(129),
    [sym__expression_statement] = STATE(663),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym_code_block] = STATE(114),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_class_def] = STATE(124),
    [sym_line_comment] = STATE(13),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(273),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym_source_file_repeat1] = STATE(13),
    [ts_builtin_sym_end] = ACTIONS(113),
    [sym_identifier] = ACTIONS(115),
    [anon_sym__] = ACTIONS(118),
    [anon_sym_LPAREN] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(124),
    [anon_sym_COMMA] = ACTIONS(127),
    [anon_sym_COLON] = ACTIONS(130),
    [anon_sym_pi] = ACTIONS(133),
    [sym_integer] = ACTIONS(136),
    [sym_hexinteger] = ACTIONS(139),
    [sym_float] = ACTIONS(133),
    [sym_exponential] = ACTIONS(139),
    [anon_sym_BSLASH] = ACTIONS(142),
    [anon_sym_SQUOTE] = ACTIONS(145),
    [sym_char] = ACTIONS(148),
    [anon_sym_DQUOTE] = ACTIONS(151),
    [anon_sym_true] = ACTIONS(154),
    [anon_sym_false] = ACTIONS(154),
    [anon_sym_inf] = ACTIONS(157),
    [anon_sym_nil] = ACTIONS(157),
    [anon_sym_thisFunction] = ACTIONS(157),
    [anon_sym_thisFunctionDef] = ACTIONS(157),
    [anon_sym_thisMethod] = ACTIONS(157),
    [anon_sym_thisProcess] = ACTIONS(157),
    [anon_sym_thisThread] = ACTIONS(157),
    [anon_sym_currentEnvironment] = ACTIONS(157),
    [anon_sym_topEnvironment] = ACTIONS(157),
    [anon_sym_var] = ACTIONS(160),
    [anon_sym_LT] = ACTIONS(163),
    [anon_sym_GT] = ACTIONS(166),
    [anon_sym_LT_GT] = ACTIONS(166),
    [anon_sym_classvar] = ACTIONS(169),
    [aux_sym_environment_var_token1] = ACTIONS(172),
    [anon_sym_TILDE] = ACTIONS(175),
    [anon_sym_CARET] = ACTIONS(178),
    [anon_sym_PLUS] = ACTIONS(181),
    [anon_sym_STAR] = ACTIONS(130),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(184),
    [anon_sym_POUND] = ACTIONS(184),
    [anon_sym_LBRACK] = ACTIONS(187),
    [anon_sym_DASH] = ACTIONS(190),
    [aux_sym_class_token1] = ACTIONS(193),
    [anon_sym_if] = ACTIONS(196),
    [anon_sym_while] = ACTIONS(199),
    [anon_sym_for] = ACTIONS(202),
    [anon_sym_forBy] = ACTIONS(205),
    [anon_sym_case] = ACTIONS(208),
    [anon_sym_switch] = ACTIONS(211),
    [sym_block_comment] = ACTIONS(5),
  },
  [14] = {
    [sym__expression] = STATE(129),
    [sym__expression_statement] = STATE(663),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym_code_block] = STATE(114),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_class_def] = STATE(124),
    [sym_line_comment] = STATE(14),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(273),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym_source_file_repeat1] = STATE(13),
    [ts_builtin_sym_end] = ACTIONS(214),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(13),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_PLUS] = ACTIONS(53),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [15] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(544),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(15),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(216),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(218),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [16] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(626),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(16),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(220),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [17] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(639),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(17),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [18] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(267),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(311),
    [sym__expression_sequence] = STATE(618),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(18),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(224),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [19] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(613),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(19),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(216),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [20] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(669),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(20),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(226),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [21] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(658),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(21),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(228),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [22] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(562),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(22),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(230),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [23] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(595),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(23),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(232),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [24] = {
    [sym__expression_statement] = STATE(494),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym__expression_sequence] = STATE(638),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(24),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(26),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_RBRACE] = ACTIONS(218),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [25] = {
    [sym__expression_statement] = STATE(585),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(25),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(25),
    [sym_identifier] = ACTIONS(234),
    [anon_sym__] = ACTIONS(237),
    [anon_sym_LPAREN] = ACTIONS(240),
    [anon_sym_LBRACE] = ACTIONS(243),
    [anon_sym_COMMA] = ACTIONS(246),
    [anon_sym_COLON] = ACTIONS(249),
    [anon_sym_pi] = ACTIONS(252),
    [sym_integer] = ACTIONS(255),
    [sym_hexinteger] = ACTIONS(258),
    [sym_float] = ACTIONS(252),
    [sym_exponential] = ACTIONS(258),
    [anon_sym_BSLASH] = ACTIONS(261),
    [anon_sym_SQUOTE] = ACTIONS(264),
    [sym_char] = ACTIONS(267),
    [anon_sym_DQUOTE] = ACTIONS(270),
    [anon_sym_true] = ACTIONS(273),
    [anon_sym_false] = ACTIONS(273),
    [anon_sym_inf] = ACTIONS(276),
    [anon_sym_nil] = ACTIONS(276),
    [anon_sym_thisFunction] = ACTIONS(276),
    [anon_sym_thisFunctionDef] = ACTIONS(276),
    [anon_sym_thisMethod] = ACTIONS(276),
    [anon_sym_thisProcess] = ACTIONS(276),
    [anon_sym_thisThread] = ACTIONS(276),
    [anon_sym_currentEnvironment] = ACTIONS(276),
    [anon_sym_topEnvironment] = ACTIONS(276),
    [anon_sym_var] = ACTIONS(279),
    [anon_sym_LT] = ACTIONS(282),
    [anon_sym_GT] = ACTIONS(285),
    [anon_sym_LT_GT] = ACTIONS(285),
    [anon_sym_classvar] = ACTIONS(288),
    [aux_sym_environment_var_token1] = ACTIONS(291),
    [anon_sym_TILDE] = ACTIONS(294),
    [anon_sym_CARET] = ACTIONS(297),
    [anon_sym_STAR] = ACTIONS(249),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(300),
    [anon_sym_POUND] = ACTIONS(300),
    [anon_sym_LBRACK] = ACTIONS(303),
    [anon_sym_DASH] = ACTIONS(306),
    [aux_sym_class_token1] = ACTIONS(309),
    [anon_sym_if] = ACTIONS(312),
    [anon_sym_while] = ACTIONS(315),
    [anon_sym_for] = ACTIONS(318),
    [anon_sym_forBy] = ACTIONS(321),
    [anon_sym_case] = ACTIONS(324),
    [anon_sym_switch] = ACTIONS(327),
    [sym_block_comment] = ACTIONS(5),
  },
  [26] = {
    [sym__expression_statement] = STATE(492),
    [sym__object] = STATE(263),
    [sym_partial] = STATE(244),
    [sym_duplicated_statement] = STATE(500),
    [sym_function_definition] = STATE(500),
    [sym_function_call] = STATE(317),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(164),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_variable_definition_sequence] = STATE(500),
    [sym_variable_definition] = STATE(408),
    [sym_return_statement] = STATE(500),
    [sym_line_comment] = STATE(26),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym__expression_sequence_repeat1] = STATE(25),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(17),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_CARET] = ACTIONS(51),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [27] = {
    [sym__object] = STATE(300),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(330),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_call_list] = STATE(622),
    [sym_argument_calls] = STATE(499),
    [sym_unnamed_argument] = STATE(539),
    [sym_named_argument] = STATE(539),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(322),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(27),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(330),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(332),
    [anon_sym_LBRACE] = ACTIONS(99),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [28] = {
    [sym__object] = STATE(300),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(330),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_call_list] = STATE(575),
    [sym_argument_calls] = STATE(499),
    [sym_unnamed_argument] = STATE(539),
    [sym_named_argument] = STATE(539),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(322),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(28),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(330),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(334),
    [anon_sym_LBRACE] = ACTIONS(99),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [29] = {
    [sym__object] = STATE(300),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(330),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_call_list] = STATE(598),
    [sym_argument_calls] = STATE(499),
    [sym_unnamed_argument] = STATE(539),
    [sym_named_argument] = STATE(539),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(322),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(29),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(330),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(336),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [30] = {
    [sym__object] = STATE(300),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(330),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_call_list] = STATE(561),
    [sym_argument_calls] = STATE(499),
    [sym_unnamed_argument] = STATE(539),
    [sym_named_argument] = STATE(539),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(322),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(30),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(330),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(338),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [31] = {
    [sym__object] = STATE(300),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(330),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_call_list] = STATE(611),
    [sym_argument_calls] = STATE(499),
    [sym_unnamed_argument] = STATE(539),
    [sym_named_argument] = STATE(539),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(322),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(31),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(330),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(340),
    [anon_sym_LBRACE] = ACTIONS(99),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [32] = {
    [sym__object] = STATE(300),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(330),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_parameter_call_list] = STATE(642),
    [sym_argument_calls] = STATE(499),
    [sym_unnamed_argument] = STATE(539),
    [sym_named_argument] = STATE(539),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(322),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(32),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(330),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(342),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [33] = {
    [sym__object] = STATE(323),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(326),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(33),
    [sym_collection] = STATE(244),
    [sym__paired_associative_sequence] = STATE(619),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(481),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(101),
    [sym_integer] = ACTIONS(103),
    [sym_hexinteger] = ACTIONS(105),
    [sym_float] = ACTIONS(101),
    [sym_exponential] = ACTIONS(105),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(344),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [34] = {
    [sym__object] = STATE(300),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(330),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_argument_calls] = STATE(550),
    [sym_unnamed_argument] = STATE(539),
    [sym_named_argument] = STATE(539),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(322),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(34),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(330),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [35] = {
    [sym__object] = STATE(323),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(282),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(35),
    [sym_collection] = STATE(244),
    [sym__paired_associative_sequence] = STATE(661),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(481),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(101),
    [sym_integer] = ACTIONS(103),
    [sym_hexinteger] = ACTIONS(105),
    [sym_float] = ACTIONS(101),
    [sym_exponential] = ACTIONS(105),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(107),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [36] = {
    [sym__object] = STATE(323),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(321),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(36),
    [sym_collection] = STATE(244),
    [sym__paired_associative_sequence] = STATE(587),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(481),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(101),
    [sym_integer] = ACTIONS(103),
    [sym_hexinteger] = ACTIONS(105),
    [sym_float] = ACTIONS(101),
    [sym_exponential] = ACTIONS(105),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DOT_DOT] = ACTIONS(346),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [37] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(37),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(559),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [38] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(38),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(615),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [39] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(39),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(624),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [40] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(40),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(591),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [41] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(41),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(592),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [42] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(42),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(632),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [43] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(43),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(579),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [44] = {
    [sym__object] = STATE(323),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(44),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(555),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(348),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [45] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(45),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(629),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [46] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(46),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(649),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [47] = {
    [sym__object] = STATE(307),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(47),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(553),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_RBRACK] = ACTIONS(350),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [48] = {
    [sym__object] = STATE(323),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(48),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(555),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_RPAREN] = ACTIONS(352),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [49] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(49),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(628),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [50] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(50),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(601),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [51] = {
    [sym__object] = STATE(268),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(51),
    [sym_collection] = STATE(244),
    [sym__collection_sequence] = STATE(605),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(511),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [52] = {
    [sym__object] = STATE(307),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(52),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(553),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_RBRACK] = ACTIONS(354),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [53] = {
    [sym__object] = STATE(261),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(305),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(53),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym_switch_repeat2] = STATE(53),
    [sym_identifier] = ACTIONS(356),
    [anon_sym__] = ACTIONS(359),
    [anon_sym_LPAREN] = ACTIONS(362),
    [anon_sym_LBRACE] = ACTIONS(365),
    [anon_sym_COLON] = ACTIONS(368),
    [anon_sym_pi] = ACTIONS(371),
    [sym_integer] = ACTIONS(374),
    [sym_hexinteger] = ACTIONS(377),
    [sym_float] = ACTIONS(371),
    [sym_exponential] = ACTIONS(377),
    [anon_sym_BSLASH] = ACTIONS(380),
    [anon_sym_SQUOTE] = ACTIONS(383),
    [sym_char] = ACTIONS(386),
    [anon_sym_DQUOTE] = ACTIONS(389),
    [anon_sym_true] = ACTIONS(392),
    [anon_sym_false] = ACTIONS(392),
    [anon_sym_inf] = ACTIONS(395),
    [anon_sym_nil] = ACTIONS(395),
    [anon_sym_thisFunction] = ACTIONS(395),
    [anon_sym_thisFunctionDef] = ACTIONS(395),
    [anon_sym_thisMethod] = ACTIONS(395),
    [anon_sym_thisProcess] = ACTIONS(395),
    [anon_sym_thisThread] = ACTIONS(395),
    [anon_sym_currentEnvironment] = ACTIONS(395),
    [anon_sym_topEnvironment] = ACTIONS(395),
    [anon_sym_var] = ACTIONS(398),
    [anon_sym_LT] = ACTIONS(401),
    [anon_sym_GT] = ACTIONS(404),
    [anon_sym_LT_GT] = ACTIONS(404),
    [anon_sym_classvar] = ACTIONS(407),
    [aux_sym_environment_var_token1] = ACTIONS(410),
    [anon_sym_TILDE] = ACTIONS(413),
    [anon_sym_STAR] = ACTIONS(368),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(416),
    [anon_sym_POUND] = ACTIONS(416),
    [anon_sym_LBRACK] = ACTIONS(419),
    [anon_sym_DASH] = ACTIONS(422),
    [aux_sym_class_token1] = ACTIONS(425),
    [anon_sym_if] = ACTIONS(428),
    [anon_sym_while] = ACTIONS(431),
    [anon_sym_for] = ACTIONS(434),
    [anon_sym_forBy] = ACTIONS(437),
    [anon_sym_case] = ACTIONS(440),
    [anon_sym_switch] = ACTIONS(443),
    [sym_block_comment] = ACTIONS(5),
  },
  [54] = {
    [sym__object] = STATE(307),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(54),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(553),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [55] = {
    [sym__object] = STATE(262),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(309),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(55),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym_switch_repeat2] = STATE(53),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [56] = {
    [sym__object] = STATE(259),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(301),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(56),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym_switch_repeat2] = STATE(55),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [57] = {
    [sym__object] = STATE(257),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(298),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(57),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym_switch_repeat2] = STATE(53),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [58] = {
    [sym__object] = STATE(323),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(58),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(303),
    [sym_associative_item] = STATE(555),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(95),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [59] = {
    [sym__object] = STATE(260),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(302),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(59),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [aux_sym_switch_repeat2] = STATE(57),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [60] = {
    [sym__object] = STATE(316),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(60),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COMMA] = ACTIONS(456),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [61] = {
    [sym__object] = STATE(284),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(61),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [62] = {
    [sym__object] = STATE(281),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(62),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [63] = {
    [sym__object] = STATE(299),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(63),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [64] = {
    [sym__object] = STATE(185),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(64),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [65] = {
    [sym__object] = STATE(286),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(65),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [66] = {
    [sym__object] = STATE(265),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(319),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(320),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(66),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(272),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [67] = {
    [sym__object] = STATE(288),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(67),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [68] = {
    [sym__object] = STATE(270),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(68),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [69] = {
    [sym__object] = STATE(217),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(69),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [70] = {
    [sym__object] = STATE(216),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(70),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [71] = {
    [sym__object] = STATE(293),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(71),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [72] = {
    [sym__object] = STATE(318),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(72),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [73] = {
    [sym__object] = STATE(215),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(73),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [74] = {
    [sym__object] = STATE(292),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(74),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [75] = {
    [sym__object] = STATE(295),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(75),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [76] = {
    [sym__object] = STATE(314),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(76),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [77] = {
    [sym__object] = STATE(312),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(77),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [78] = {
    [sym__object] = STATE(214),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(78),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [79] = {
    [sym__object] = STATE(213),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(79),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [80] = {
    [sym__object] = STATE(276),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(80),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [81] = {
    [sym__object] = STATE(277),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(81),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [82] = {
    [sym__object] = STATE(290),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(327),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(82),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [83] = {
    [sym__object] = STATE(274),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(83),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [84] = {
    [sym__object] = STATE(271),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(84),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [85] = {
    [sym__object] = STATE(212),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(85),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [86] = {
    [sym__object] = STATE(275),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(86),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [87] = {
    [sym__object] = STATE(211),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(87),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [88] = {
    [sym__object] = STATE(265),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(319),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(88),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(272),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [89] = {
    [sym__object] = STATE(210),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(89),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [90] = {
    [sym__object] = STATE(209),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(90),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [91] = {
    [sym__object] = STATE(297),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(91),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [92] = {
    [sym__object] = STATE(208),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(92),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [93] = {
    [sym__object] = STATE(289),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(93),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [94] = {
    [sym__object] = STATE(287),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(94),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [95] = {
    [sym__object] = STATE(315),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(95),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [96] = {
    [sym__object] = STATE(207),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(96),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [97] = {
    [sym__object] = STATE(306),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(328),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(97),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [98] = {
    [sym__object] = STATE(206),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(98),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [99] = {
    [sym__object] = STATE(310),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(329),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(99),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [100] = {
    [sym__object] = STATE(203),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(100),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(256),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(9),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(19),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(27),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(19),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(59),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(73),
    [sym_block_comment] = ACTIONS(5),
  },
  [101] = {
    [sym__object] = STATE(278),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(101),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [102] = {
    [sym__object] = STATE(291),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(102),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [103] = {
    [sym__object] = STATE(294),
    [sym_partial] = STATE(244),
    [sym_function_call] = STATE(226),
    [sym_code_block] = STATE(244),
    [sym_function_block] = STATE(244),
    [sym__function_content] = STATE(249),
    [sym_literal] = STATE(244),
    [sym_number] = STATE(178),
    [sym_symbol] = STATE(192),
    [sym_string] = STATE(192),
    [sym_bool] = STATE(192),
    [sym_variable] = STATE(146),
    [sym_builtin_var] = STATE(156),
    [sym_local_var] = STATE(156),
    [sym_instance_var] = STATE(156),
    [sym_classvar] = STATE(156),
    [sym_environment_var] = STATE(156),
    [sym_line_comment] = STATE(103),
    [sym_collection] = STATE(244),
    [sym_association] = STATE(244),
    [sym_indexed_collection] = STATE(244),
    [sym_arithmetic_series] = STATE(229),
    [sym_binary_expression] = STATE(244),
    [sym_unary_expression] = STATE(244),
    [sym_class] = STATE(313),
    [sym_nil_check] = STATE(244),
    [sym_control_structure] = STATE(244),
    [sym_if] = STATE(199),
    [sym_while] = STATE(199),
    [sym_for] = STATE(199),
    [sym_forby] = STATE(199),
    [sym_case] = STATE(199),
    [sym_switch] = STATE(199),
    [sym_identifier] = ACTIONS(446),
    [anon_sym__] = ACTIONS(11),
    [anon_sym_LPAREN] = ACTIONS(75),
    [anon_sym_LBRACE] = ACTIONS(15),
    [anon_sym_COLON] = ACTIONS(448),
    [anon_sym_pi] = ACTIONS(21),
    [sym_integer] = ACTIONS(23),
    [sym_hexinteger] = ACTIONS(25),
    [sym_float] = ACTIONS(21),
    [sym_exponential] = ACTIONS(25),
    [anon_sym_BSLASH] = ACTIONS(450),
    [anon_sym_SQUOTE] = ACTIONS(29),
    [sym_char] = ACTIONS(31),
    [anon_sym_DQUOTE] = ACTIONS(33),
    [anon_sym_true] = ACTIONS(35),
    [anon_sym_false] = ACTIONS(35),
    [anon_sym_inf] = ACTIONS(37),
    [anon_sym_nil] = ACTIONS(37),
    [anon_sym_thisFunction] = ACTIONS(37),
    [anon_sym_thisFunctionDef] = ACTIONS(37),
    [anon_sym_thisMethod] = ACTIONS(37),
    [anon_sym_thisProcess] = ACTIONS(37),
    [anon_sym_thisThread] = ACTIONS(37),
    [anon_sym_currentEnvironment] = ACTIONS(37),
    [anon_sym_topEnvironment] = ACTIONS(37),
    [anon_sym_var] = ACTIONS(39),
    [anon_sym_LT] = ACTIONS(41),
    [anon_sym_GT] = ACTIONS(43),
    [anon_sym_LT_GT] = ACTIONS(43),
    [anon_sym_classvar] = ACTIONS(45),
    [aux_sym_environment_var_token1] = ACTIONS(47),
    [anon_sym_TILDE] = ACTIONS(49),
    [anon_sym_STAR] = ACTIONS(448),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(55),
    [anon_sym_POUND] = ACTIONS(55),
    [anon_sym_LBRACK] = ACTIONS(57),
    [anon_sym_DASH] = ACTIONS(452),
    [aux_sym_class_token1] = ACTIONS(61),
    [anon_sym_if] = ACTIONS(63),
    [anon_sym_while] = ACTIONS(65),
    [anon_sym_for] = ACTIONS(67),
    [anon_sym_forBy] = ACTIONS(69),
    [anon_sym_case] = ACTIONS(71),
    [anon_sym_switch] = ACTIONS(454),
    [sym_block_comment] = ACTIONS(5),
  },
  [104] = {
    [sym_line_comment] = STATE(104),
    [sym_identifier] = ACTIONS(458),
    [anon_sym_SEMI] = ACTIONS(460),
    [anon_sym__] = ACTIONS(458),
    [anon_sym_BANG] = ACTIONS(458),
    [anon_sym_EQ] = ACTIONS(458),
    [anon_sym_LPAREN] = ACTIONS(460),
    [anon_sym_RPAREN] = ACTIONS(460),
    [anon_sym_DOT] = ACTIONS(458),
    [anon_sym_LBRACE] = ACTIONS(460),
    [anon_sym_RBRACE] = ACTIONS(460),
    [anon_sym_COMMA] = ACTIONS(460),
    [anon_sym_PIPE] = ACTIONS(458),
    [anon_sym_COLON] = ACTIONS(460),
    [anon_sym_pi] = ACTIONS(458),
    [sym_integer] = ACTIONS(458),
    [sym_hexinteger] = ACTIONS(460),
    [sym_float] = ACTIONS(458),
    [sym_exponential] = ACTIONS(460),
    [anon_sym_BSLASH] = ACTIONS(460),
    [anon_sym_SQUOTE] = ACTIONS(460),
    [sym_char] = ACTIONS(460),
    [anon_sym_DQUOTE] = ACTIONS(460),
    [anon_sym_true] = ACTIONS(458),
    [anon_sym_false] = ACTIONS(458),
    [anon_sym_inf] = ACTIONS(458),
    [anon_sym_nil] = ACTIONS(458),
    [anon_sym_thisFunction] = ACTIONS(458),
    [anon_sym_thisFunctionDef] = ACTIONS(458),
    [anon_sym_thisMethod] = ACTIONS(458),
    [anon_sym_thisProcess] = ACTIONS(458),
    [anon_sym_thisThread] = ACTIONS(458),
    [anon_sym_currentEnvironment] = ACTIONS(458),
    [anon_sym_topEnvironment] = ACTIONS(458),
    [anon_sym_var] = ACTIONS(458),
    [anon_sym_LT] = ACTIONS(458),
    [anon_sym_GT] = ACTIONS(458),
    [anon_sym_LT_GT] = ACTIONS(460),
    [anon_sym_classvar] = ACTIONS(458),
    [aux_sym_environment_var_token1] = ACTIONS(458),
    [anon_sym_TILDE] = ACTIONS(460),
    [anon_sym_PLUS] = ACTIONS(458),
    [anon_sym_STAR] = ACTIONS(458),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(460),
    [anon_sym_POUND] = ACTIONS(460),
    [anon_sym_LBRACK] = ACTIONS(460),
    [anon_sym_RBRACK] = ACTIONS(460),
    [anon_sym_DASH_GT] = ACTIONS(460),
    [aux_sym_binary_expression_token1] = ACTIONS(460),
    [anon_sym_AMP_AMP] = ACTIONS(460),
    [anon_sym_PIPE_PIPE] = ACTIONS(460),
    [anon_sym_AMP] = ACTIONS(458),
    [anon_sym_EQ_EQ] = ACTIONS(460),
    [anon_sym_BANG_EQ] = ACTIONS(460),
    [anon_sym_LT_EQ] = ACTIONS(460),
    [anon_sym_GT_EQ] = ACTIONS(460),
    [anon_sym_LT_LT] = ACTIONS(460),
    [anon_sym_GT_GT] = ACTIONS(460),
    [anon_sym_DASH] = ACTIONS(458),
    [anon_sym_PLUS_PLUS] = ACTIONS(460),
    [anon_sym_SLASH] = ACTIONS(458),
    [anon_sym_PERCENT] = ACTIONS(460),
    [anon_sym_STAR_STAR] = ACTIONS(460),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(460),
    [aux_sym_class_token1] = ACTIONS(458),
    [anon_sym_QMARK] = ACTIONS(458),
    [anon_sym_BANG_QMARK] = ACTIONS(460),
    [anon_sym_QMARK_QMARK] = ACTIONS(460),
    [anon_sym_if] = ACTIONS(458),
    [anon_sym_while] = ACTIONS(458),
    [anon_sym_DOTwhile] = ACTIONS(460),
    [anon_sym_for] = ACTIONS(458),
    [anon_sym_forBy] = ACTIONS(458),
    [anon_sym_case] = ACTIONS(458),
    [anon_sym_switch] = ACTIONS(458),
    [sym_block_comment] = ACTIONS(5),
  },
  [105] = {
    [sym_line_comment] = STATE(105),
    [sym_identifier] = ACTIONS(462),
    [anon_sym_SEMI] = ACTIONS(464),
    [anon_sym__] = ACTIONS(462),
    [anon_sym_BANG] = ACTIONS(462),
    [anon_sym_EQ] = ACTIONS(462),
    [anon_sym_LPAREN] = ACTIONS(464),
    [anon_sym_RPAREN] = ACTIONS(464),
    [anon_sym_DOT] = ACTIONS(462),
    [anon_sym_LBRACE] = ACTIONS(464),
    [anon_sym_RBRACE] = ACTIONS(464),
    [anon_sym_COMMA] = ACTIONS(464),
    [anon_sym_PIPE] = ACTIONS(462),
    [anon_sym_COLON] = ACTIONS(464),
    [anon_sym_pi] = ACTIONS(462),
    [sym_integer] = ACTIONS(462),
    [sym_hexinteger] = ACTIONS(464),
    [sym_float] = ACTIONS(462),
    [sym_exponential] = ACTIONS(464),
    [anon_sym_BSLASH] = ACTIONS(464),
    [anon_sym_SQUOTE] = ACTIONS(464),
    [sym_char] = ACTIONS(464),
    [anon_sym_DQUOTE] = ACTIONS(464),
    [anon_sym_true] = ACTIONS(462),
    [anon_sym_false] = ACTIONS(462),
    [anon_sym_inf] = ACTIONS(462),
    [anon_sym_nil] = ACTIONS(462),
    [anon_sym_thisFunction] = ACTIONS(462),
    [anon_sym_thisFunctionDef] = ACTIONS(462),
    [anon_sym_thisMethod] = ACTIONS(462),
    [anon_sym_thisProcess] = ACTIONS(462),
    [anon_sym_thisThread] = ACTIONS(462),
    [anon_sym_currentEnvironment] = ACTIONS(462),
    [anon_sym_topEnvironment] = ACTIONS(462),
    [anon_sym_var] = ACTIONS(462),
    [anon_sym_LT] = ACTIONS(462),
    [anon_sym_GT] = ACTIONS(462),
    [anon_sym_LT_GT] = ACTIONS(464),
    [anon_sym_classvar] = ACTIONS(462),
    [aux_sym_environment_var_token1] = ACTIONS(462),
    [anon_sym_TILDE] = ACTIONS(464),
    [anon_sym_PLUS] = ACTIONS(462),
    [anon_sym_STAR] = ACTIONS(462),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(464),
    [anon_sym_POUND] = ACTIONS(464),
    [anon_sym_LBRACK] = ACTIONS(464),
    [anon_sym_RBRACK] = ACTIONS(464),
    [anon_sym_DASH_GT] = ACTIONS(464),
    [aux_sym_binary_expression_token1] = ACTIONS(464),
    [anon_sym_AMP_AMP] = ACTIONS(464),
    [anon_sym_PIPE_PIPE] = ACTIONS(464),
    [anon_sym_AMP] = ACTIONS(462),
    [anon_sym_EQ_EQ] = ACTIONS(464),
    [anon_sym_BANG_EQ] = ACTIONS(464),
    [anon_sym_LT_EQ] = ACTIONS(464),
    [anon_sym_GT_EQ] = ACTIONS(464),
    [anon_sym_LT_LT] = ACTIONS(464),
    [anon_sym_GT_GT] = ACTIONS(464),
    [anon_sym_DASH] = ACTIONS(462),
    [anon_sym_PLUS_PLUS] = ACTIONS(464),
    [anon_sym_SLASH] = ACTIONS(462),
    [anon_sym_PERCENT] = ACTIONS(464),
    [anon_sym_STAR_STAR] = ACTIONS(464),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(464),
    [aux_sym_class_token1] = ACTIONS(462),
    [anon_sym_QMARK] = ACTIONS(462),
    [anon_sym_BANG_QMARK] = ACTIONS(464),
    [anon_sym_QMARK_QMARK] = ACTIONS(464),
    [anon_sym_if] = ACTIONS(462),
    [anon_sym_while] = ACTIONS(462),
    [anon_sym_DOTwhile] = ACTIONS(464),
    [anon_sym_for] = ACTIONS(462),
    [anon_sym_forBy] = ACTIONS(462),
    [anon_sym_case] = ACTIONS(462),
    [anon_sym_switch] = ACTIONS(462),
    [sym_block_comment] = ACTIONS(5),
  },
  [106] = {
    [sym_line_comment] = STATE(106),
    [sym_identifier] = ACTIONS(466),
    [anon_sym_SEMI] = ACTIONS(468),
    [anon_sym__] = ACTIONS(466),
    [anon_sym_BANG] = ACTIONS(466),
    [anon_sym_EQ] = ACTIONS(466),
    [anon_sym_LPAREN] = ACTIONS(468),
    [anon_sym_RPAREN] = ACTIONS(468),
    [anon_sym_DOT] = ACTIONS(466),
    [anon_sym_LBRACE] = ACTIONS(468),
    [anon_sym_RBRACE] = ACTIONS(468),
    [anon_sym_COMMA] = ACTIONS(468),
    [anon_sym_PIPE] = ACTIONS(466),
    [anon_sym_COLON] = ACTIONS(468),
    [anon_sym_pi] = ACTIONS(466),
    [sym_integer] = ACTIONS(466),
    [sym_hexinteger] = ACTIONS(468),
    [sym_float] = ACTIONS(466),
    [sym_exponential] = ACTIONS(468),
    [anon_sym_BSLASH] = ACTIONS(468),
    [anon_sym_SQUOTE] = ACTIONS(468),
    [sym_char] = ACTIONS(468),
    [anon_sym_DQUOTE] = ACTIONS(468),
    [anon_sym_true] = ACTIONS(466),
    [anon_sym_false] = ACTIONS(466),
    [anon_sym_inf] = ACTIONS(466),
    [anon_sym_nil] = ACTIONS(466),
    [anon_sym_thisFunction] = ACTIONS(466),
    [anon_sym_thisFunctionDef] = ACTIONS(466),
    [anon_sym_thisMethod] = ACTIONS(466),
    [anon_sym_thisProcess] = ACTIONS(466),
    [anon_sym_thisThread] = ACTIONS(466),
    [anon_sym_currentEnvironment] = ACTIONS(466),
    [anon_sym_topEnvironment] = ACTIONS(466),
    [anon_sym_var] = ACTIONS(466),
    [anon_sym_LT] = ACTIONS(466),
    [anon_sym_GT] = ACTIONS(466),
    [anon_sym_LT_GT] = ACTIONS(468),
    [anon_sym_classvar] = ACTIONS(466),
    [aux_sym_environment_var_token1] = ACTIONS(466),
    [anon_sym_TILDE] = ACTIONS(468),
    [anon_sym_PLUS] = ACTIONS(466),
    [anon_sym_STAR] = ACTIONS(466),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(468),
    [anon_sym_POUND] = ACTIONS(468),
    [anon_sym_LBRACK] = ACTIONS(468),
    [anon_sym_RBRACK] = ACTIONS(468),
    [anon_sym_DASH_GT] = ACTIONS(468),
    [aux_sym_binary_expression_token1] = ACTIONS(468),
    [anon_sym_AMP_AMP] = ACTIONS(468),
    [anon_sym_PIPE_PIPE] = ACTIONS(468),
    [anon_sym_AMP] = ACTIONS(466),
    [anon_sym_EQ_EQ] = ACTIONS(468),
    [anon_sym_BANG_EQ] = ACTIONS(468),
    [anon_sym_LT_EQ] = ACTIONS(468),
    [anon_sym_GT_EQ] = ACTIONS(468),
    [anon_sym_LT_LT] = ACTIONS(468),
    [anon_sym_GT_GT] = ACTIONS(468),
    [anon_sym_DASH] = ACTIONS(466),
    [anon_sym_PLUS_PLUS] = ACTIONS(468),
    [anon_sym_SLASH] = ACTIONS(466),
    [anon_sym_PERCENT] = ACTIONS(468),
    [anon_sym_STAR_STAR] = ACTIONS(468),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(468),
    [aux_sym_class_token1] = ACTIONS(466),
    [anon_sym_QMARK] = ACTIONS(466),
    [anon_sym_BANG_QMARK] = ACTIONS(468),
    [anon_sym_QMARK_QMARK] = ACTIONS(468),
    [anon_sym_if] = ACTIONS(466),
    [anon_sym_while] = ACTIONS(466),
    [anon_sym_DOTwhile] = ACTIONS(468),
    [anon_sym_for] = ACTIONS(466),
    [anon_sym_forBy] = ACTIONS(466),
    [anon_sym_case] = ACTIONS(466),
    [anon_sym_switch] = ACTIONS(466),
    [sym_block_comment] = ACTIONS(5),
  },
  [107] = {
    [sym_line_comment] = STATE(107),
    [sym_identifier] = ACTIONS(470),
    [anon_sym_SEMI] = ACTIONS(472),
    [anon_sym__] = ACTIONS(470),
    [anon_sym_BANG] = ACTIONS(470),
    [anon_sym_EQ] = ACTIONS(470),
    [anon_sym_LPAREN] = ACTIONS(472),
    [anon_sym_RPAREN] = ACTIONS(472),
    [anon_sym_DOT] = ACTIONS(470),
    [anon_sym_LBRACE] = ACTIONS(472),
    [anon_sym_RBRACE] = ACTIONS(472),
    [anon_sym_COMMA] = ACTIONS(472),
    [anon_sym_PIPE] = ACTIONS(470),
    [anon_sym_COLON] = ACTIONS(472),
    [anon_sym_pi] = ACTIONS(470),
    [sym_integer] = ACTIONS(470),
    [sym_hexinteger] = ACTIONS(472),
    [sym_float] = ACTIONS(470),
    [sym_exponential] = ACTIONS(472),
    [anon_sym_BSLASH] = ACTIONS(472),
    [anon_sym_SQUOTE] = ACTIONS(472),
    [sym_char] = ACTIONS(472),
    [anon_sym_DQUOTE] = ACTIONS(472),
    [anon_sym_true] = ACTIONS(470),
    [anon_sym_false] = ACTIONS(470),
    [anon_sym_inf] = ACTIONS(470),
    [anon_sym_nil] = ACTIONS(470),
    [anon_sym_thisFunction] = ACTIONS(470),
    [anon_sym_thisFunctionDef] = ACTIONS(470),
    [anon_sym_thisMethod] = ACTIONS(470),
    [anon_sym_thisProcess] = ACTIONS(470),
    [anon_sym_thisThread] = ACTIONS(470),
    [anon_sym_currentEnvironment] = ACTIONS(470),
    [anon_sym_topEnvironment] = ACTIONS(470),
    [anon_sym_var] = ACTIONS(470),
    [anon_sym_LT] = ACTIONS(470),
    [anon_sym_GT] = ACTIONS(470),
    [anon_sym_LT_GT] = ACTIONS(472),
    [anon_sym_classvar] = ACTIONS(470),
    [aux_sym_environment_var_token1] = ACTIONS(470),
    [anon_sym_TILDE] = ACTIONS(472),
    [anon_sym_PLUS] = ACTIONS(470),
    [anon_sym_STAR] = ACTIONS(470),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(472),
    [anon_sym_POUND] = ACTIONS(472),
    [anon_sym_LBRACK] = ACTIONS(472),
    [anon_sym_RBRACK] = ACTIONS(472),
    [anon_sym_DASH_GT] = ACTIONS(472),
    [aux_sym_binary_expression_token1] = ACTIONS(472),
    [anon_sym_AMP_AMP] = ACTIONS(472),
    [anon_sym_PIPE_PIPE] = ACTIONS(472),
    [anon_sym_AMP] = ACTIONS(470),
    [anon_sym_EQ_EQ] = ACTIONS(472),
    [anon_sym_BANG_EQ] = ACTIONS(472),
    [anon_sym_LT_EQ] = ACTIONS(472),
    [anon_sym_GT_EQ] = ACTIONS(472),
    [anon_sym_LT_LT] = ACTIONS(472),
    [anon_sym_GT_GT] = ACTIONS(472),
    [anon_sym_DASH] = ACTIONS(470),
    [anon_sym_PLUS_PLUS] = ACTIONS(472),
    [anon_sym_SLASH] = ACTIONS(470),
    [anon_sym_PERCENT] = ACTIONS(472),
    [anon_sym_STAR_STAR] = ACTIONS(472),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(472),
    [aux_sym_class_token1] = ACTIONS(470),
    [anon_sym_QMARK] = ACTIONS(470),
    [anon_sym_BANG_QMARK] = ACTIONS(472),
    [anon_sym_QMARK_QMARK] = ACTIONS(472),
    [anon_sym_if] = ACTIONS(470),
    [anon_sym_while] = ACTIONS(470),
    [anon_sym_DOTwhile] = ACTIONS(472),
    [anon_sym_for] = ACTIONS(470),
    [anon_sym_forBy] = ACTIONS(470),
    [anon_sym_case] = ACTIONS(470),
    [anon_sym_switch] = ACTIONS(470),
    [sym_block_comment] = ACTIONS(5),
  },
  [108] = {
    [sym_line_comment] = STATE(108),
    [sym_identifier] = ACTIONS(474),
    [anon_sym_SEMI] = ACTIONS(476),
    [anon_sym__] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(478),
    [anon_sym_EQ] = ACTIONS(478),
    [anon_sym_LPAREN] = ACTIONS(480),
    [anon_sym_RPAREN] = ACTIONS(476),
    [anon_sym_DOT] = ACTIONS(478),
    [anon_sym_LBRACE] = ACTIONS(480),
    [anon_sym_RBRACE] = ACTIONS(476),
    [anon_sym_COMMA] = ACTIONS(476),
    [anon_sym_PIPE] = ACTIONS(478),
    [anon_sym_COLON] = ACTIONS(480),
    [anon_sym_pi] = ACTIONS(474),
    [sym_integer] = ACTIONS(474),
    [sym_hexinteger] = ACTIONS(480),
    [sym_float] = ACTIONS(474),
    [sym_exponential] = ACTIONS(480),
    [anon_sym_BSLASH] = ACTIONS(480),
    [anon_sym_SQUOTE] = ACTIONS(480),
    [sym_char] = ACTIONS(480),
    [anon_sym_DQUOTE] = ACTIONS(480),
    [anon_sym_true] = ACTIONS(474),
    [anon_sym_false] = ACTIONS(474),
    [anon_sym_inf] = ACTIONS(474),
    [anon_sym_nil] = ACTIONS(474),
    [anon_sym_thisFunction] = ACTIONS(474),
    [anon_sym_thisFunctionDef] = ACTIONS(474),
    [anon_sym_thisMethod] = ACTIONS(474),
    [anon_sym_thisProcess] = ACTIONS(474),
    [anon_sym_thisThread] = ACTIONS(474),
    [anon_sym_currentEnvironment] = ACTIONS(474),
    [anon_sym_topEnvironment] = ACTIONS(474),
    [anon_sym_var] = ACTIONS(474),
    [anon_sym_LT] = ACTIONS(482),
    [anon_sym_GT] = ACTIONS(482),
    [anon_sym_LT_GT] = ACTIONS(480),
    [anon_sym_classvar] = ACTIONS(474),
    [aux_sym_environment_var_token1] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(480),
    [anon_sym_PLUS] = ACTIONS(478),
    [anon_sym_STAR] = ACTIONS(482),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(480),
    [anon_sym_POUND] = ACTIONS(480),
    [anon_sym_LBRACK] = ACTIONS(480),
    [anon_sym_RBRACK] = ACTIONS(476),
    [anon_sym_DASH_GT] = ACTIONS(476),
    [aux_sym_binary_expression_token1] = ACTIONS(476),
    [anon_sym_AMP_AMP] = ACTIONS(476),
    [anon_sym_PIPE_PIPE] = ACTIONS(476),
    [anon_sym_AMP] = ACTIONS(478),
    [anon_sym_EQ_EQ] = ACTIONS(476),
    [anon_sym_BANG_EQ] = ACTIONS(476),
    [anon_sym_LT_EQ] = ACTIONS(476),
    [anon_sym_GT_EQ] = ACTIONS(476),
    [anon_sym_LT_LT] = ACTIONS(476),
    [anon_sym_GT_GT] = ACTIONS(476),
    [anon_sym_DASH] = ACTIONS(482),
    [anon_sym_PLUS_PLUS] = ACTIONS(476),
    [anon_sym_SLASH] = ACTIONS(478),
    [anon_sym_PERCENT] = ACTIONS(476),
    [anon_sym_STAR_STAR] = ACTIONS(476),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(476),
    [aux_sym_class_token1] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(478),
    [anon_sym_BANG_QMARK] = ACTIONS(476),
    [anon_sym_QMARK_QMARK] = ACTIONS(476),
    [anon_sym_if] = ACTIONS(474),
    [anon_sym_while] = ACTIONS(474),
    [anon_sym_DOTwhile] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(474),
    [anon_sym_forBy] = ACTIONS(474),
    [anon_sym_case] = ACTIONS(474),
    [anon_sym_switch] = ACTIONS(474),
    [sym_block_comment] = ACTIONS(5),
  },
  [109] = {
    [sym_line_comment] = STATE(109),
    [sym_identifier] = ACTIONS(485),
    [anon_sym_SEMI] = ACTIONS(487),
    [anon_sym__] = ACTIONS(485),
    [anon_sym_BANG] = ACTIONS(485),
    [anon_sym_EQ] = ACTIONS(485),
    [anon_sym_LPAREN] = ACTIONS(487),
    [anon_sym_RPAREN] = ACTIONS(487),
    [anon_sym_DOT] = ACTIONS(485),
    [anon_sym_LBRACE] = ACTIONS(487),
    [anon_sym_RBRACE] = ACTIONS(487),
    [anon_sym_COMMA] = ACTIONS(487),
    [anon_sym_PIPE] = ACTIONS(485),
    [anon_sym_COLON] = ACTIONS(487),
    [anon_sym_pi] = ACTIONS(485),
    [sym_integer] = ACTIONS(485),
    [sym_hexinteger] = ACTIONS(487),
    [sym_float] = ACTIONS(485),
    [sym_exponential] = ACTIONS(487),
    [anon_sym_BSLASH] = ACTIONS(487),
    [anon_sym_SQUOTE] = ACTIONS(487),
    [sym_char] = ACTIONS(487),
    [anon_sym_DQUOTE] = ACTIONS(487),
    [anon_sym_true] = ACTIONS(485),
    [anon_sym_false] = ACTIONS(485),
    [anon_sym_inf] = ACTIONS(485),
    [anon_sym_nil] = ACTIONS(485),
    [anon_sym_thisFunction] = ACTIONS(485),
    [anon_sym_thisFunctionDef] = ACTIONS(485),
    [anon_sym_thisMethod] = ACTIONS(485),
    [anon_sym_thisProcess] = ACTIONS(485),
    [anon_sym_thisThread] = ACTIONS(485),
    [anon_sym_currentEnvironment] = ACTIONS(485),
    [anon_sym_topEnvironment] = ACTIONS(485),
    [anon_sym_var] = ACTIONS(485),
    [anon_sym_LT] = ACTIONS(485),
    [anon_sym_GT] = ACTIONS(485),
    [anon_sym_LT_GT] = ACTIONS(487),
    [anon_sym_classvar] = ACTIONS(485),
    [aux_sym_environment_var_token1] = ACTIONS(485),
    [anon_sym_TILDE] = ACTIONS(487),
    [anon_sym_PLUS] = ACTIONS(485),
    [anon_sym_STAR] = ACTIONS(485),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(487),
    [anon_sym_POUND] = ACTIONS(487),
    [anon_sym_LBRACK] = ACTIONS(487),
    [anon_sym_RBRACK] = ACTIONS(487),
    [anon_sym_DASH_GT] = ACTIONS(487),
    [aux_sym_binary_expression_token1] = ACTIONS(487),
    [anon_sym_AMP_AMP] = ACTIONS(487),
    [anon_sym_PIPE_PIPE] = ACTIONS(487),
    [anon_sym_AMP] = ACTIONS(485),
    [anon_sym_EQ_EQ] = ACTIONS(487),
    [anon_sym_BANG_EQ] = ACTIONS(487),
    [anon_sym_LT_EQ] = ACTIONS(487),
    [anon_sym_GT_EQ] = ACTIONS(487),
    [anon_sym_LT_LT] = ACTIONS(487),
    [anon_sym_GT_GT] = ACTIONS(487),
    [anon_sym_DASH] = ACTIONS(485),
    [anon_sym_PLUS_PLUS] = ACTIONS(487),
    [anon_sym_SLASH] = ACTIONS(485),
    [anon_sym_PERCENT] = ACTIONS(487),
    [anon_sym_STAR_STAR] = ACTIONS(487),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(487),
    [aux_sym_class_token1] = ACTIONS(485),
    [anon_sym_QMARK] = ACTIONS(485),
    [anon_sym_BANG_QMARK] = ACTIONS(487),
    [anon_sym_QMARK_QMARK] = ACTIONS(487),
    [anon_sym_if] = ACTIONS(485),
    [anon_sym_while] = ACTIONS(485),
    [anon_sym_DOTwhile] = ACTIONS(487),
    [anon_sym_for] = ACTIONS(485),
    [anon_sym_forBy] = ACTIONS(485),
    [anon_sym_case] = ACTIONS(485),
    [anon_sym_switch] = ACTIONS(485),
    [sym_block_comment] = ACTIONS(5),
  },
  [110] = {
    [sym_line_comment] = STATE(110),
    [sym_identifier] = ACTIONS(489),
    [anon_sym_SEMI] = ACTIONS(491),
    [anon_sym__] = ACTIONS(489),
    [anon_sym_BANG] = ACTIONS(489),
    [anon_sym_EQ] = ACTIONS(489),
    [anon_sym_LPAREN] = ACTIONS(491),
    [anon_sym_RPAREN] = ACTIONS(491),
    [anon_sym_DOT] = ACTIONS(489),
    [anon_sym_LBRACE] = ACTIONS(491),
    [anon_sym_RBRACE] = ACTIONS(491),
    [anon_sym_COMMA] = ACTIONS(491),
    [anon_sym_PIPE] = ACTIONS(489),
    [anon_sym_COLON] = ACTIONS(491),
    [anon_sym_pi] = ACTIONS(489),
    [sym_integer] = ACTIONS(489),
    [sym_hexinteger] = ACTIONS(491),
    [sym_float] = ACTIONS(489),
    [sym_exponential] = ACTIONS(491),
    [anon_sym_BSLASH] = ACTIONS(491),
    [anon_sym_SQUOTE] = ACTIONS(491),
    [sym_char] = ACTIONS(491),
    [anon_sym_DQUOTE] = ACTIONS(491),
    [anon_sym_true] = ACTIONS(489),
    [anon_sym_false] = ACTIONS(489),
    [anon_sym_inf] = ACTIONS(489),
    [anon_sym_nil] = ACTIONS(489),
    [anon_sym_thisFunction] = ACTIONS(489),
    [anon_sym_thisFunctionDef] = ACTIONS(489),
    [anon_sym_thisMethod] = ACTIONS(489),
    [anon_sym_thisProcess] = ACTIONS(489),
    [anon_sym_thisThread] = ACTIONS(489),
    [anon_sym_currentEnvironment] = ACTIONS(489),
    [anon_sym_topEnvironment] = ACTIONS(489),
    [anon_sym_var] = ACTIONS(489),
    [anon_sym_LT] = ACTIONS(489),
    [anon_sym_GT] = ACTIONS(489),
    [anon_sym_LT_GT] = ACTIONS(491),
    [anon_sym_classvar] = ACTIONS(489),
    [aux_sym_environment_var_token1] = ACTIONS(489),
    [anon_sym_TILDE] = ACTIONS(491),
    [anon_sym_PLUS] = ACTIONS(489),
    [anon_sym_STAR] = ACTIONS(489),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(491),
    [anon_sym_POUND] = ACTIONS(491),
    [anon_sym_LBRACK] = ACTIONS(491),
    [anon_sym_RBRACK] = ACTIONS(491),
    [anon_sym_DASH_GT] = ACTIONS(491),
    [aux_sym_binary_expression_token1] = ACTIONS(491),
    [anon_sym_AMP_AMP] = ACTIONS(491),
    [anon_sym_PIPE_PIPE] = ACTIONS(491),
    [anon_sym_AMP] = ACTIONS(489),
    [anon_sym_EQ_EQ] = ACTIONS(491),
    [anon_sym_BANG_EQ] = ACTIONS(491),
    [anon_sym_LT_EQ] = ACTIONS(491),
    [anon_sym_GT_EQ] = ACTIONS(491),
    [anon_sym_LT_LT] = ACTIONS(491),
    [anon_sym_GT_GT] = ACTIONS(491),
    [anon_sym_DASH] = ACTIONS(489),
    [anon_sym_PLUS_PLUS] = ACTIONS(491),
    [anon_sym_SLASH] = ACTIONS(489),
    [anon_sym_PERCENT] = ACTIONS(491),
    [anon_sym_STAR_STAR] = ACTIONS(491),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(491),
    [aux_sym_class_token1] = ACTIONS(489),
    [anon_sym_QMARK] = ACTIONS(489),
    [anon_sym_BANG_QMARK] = ACTIONS(491),
    [anon_sym_QMARK_QMARK] = ACTIONS(491),
    [anon_sym_if] = ACTIONS(489),
    [anon_sym_while] = ACTIONS(489),
    [anon_sym_DOTwhile] = ACTIONS(491),
    [anon_sym_for] = ACTIONS(489),
    [anon_sym_forBy] = ACTIONS(489),
    [anon_sym_case] = ACTIONS(489),
    [anon_sym_switch] = ACTIONS(489),
    [sym_block_comment] = ACTIONS(5),
  },
  [111] = {
    [sym_line_comment] = STATE(111),
    [sym_identifier] = ACTIONS(474),
    [anon_sym_SEMI] = ACTIONS(493),
    [anon_sym__] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(495),
    [anon_sym_EQ] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(480),
    [anon_sym_RPAREN] = ACTIONS(493),
    [anon_sym_DOT] = ACTIONS(495),
    [anon_sym_LBRACE] = ACTIONS(480),
    [anon_sym_RBRACE] = ACTIONS(493),
    [anon_sym_COMMA] = ACTIONS(493),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_COLON] = ACTIONS(480),
    [anon_sym_pi] = ACTIONS(474),
    [sym_integer] = ACTIONS(474),
    [sym_hexinteger] = ACTIONS(480),
    [sym_float] = ACTIONS(474),
    [sym_exponential] = ACTIONS(480),
    [anon_sym_BSLASH] = ACTIONS(480),
    [anon_sym_SQUOTE] = ACTIONS(480),
    [sym_char] = ACTIONS(480),
    [anon_sym_DQUOTE] = ACTIONS(480),
    [anon_sym_true] = ACTIONS(474),
    [anon_sym_false] = ACTIONS(474),
    [anon_sym_inf] = ACTIONS(474),
    [anon_sym_nil] = ACTIONS(474),
    [anon_sym_thisFunction] = ACTIONS(474),
    [anon_sym_thisFunctionDef] = ACTIONS(474),
    [anon_sym_thisMethod] = ACTIONS(474),
    [anon_sym_thisProcess] = ACTIONS(474),
    [anon_sym_thisThread] = ACTIONS(474),
    [anon_sym_currentEnvironment] = ACTIONS(474),
    [anon_sym_topEnvironment] = ACTIONS(474),
    [anon_sym_var] = ACTIONS(474),
    [anon_sym_LT] = ACTIONS(497),
    [anon_sym_GT] = ACTIONS(497),
    [anon_sym_LT_GT] = ACTIONS(480),
    [anon_sym_classvar] = ACTIONS(474),
    [aux_sym_environment_var_token1] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(480),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_STAR] = ACTIONS(497),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(480),
    [anon_sym_POUND] = ACTIONS(480),
    [anon_sym_LBRACK] = ACTIONS(480),
    [anon_sym_RBRACK] = ACTIONS(493),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [aux_sym_binary_expression_token1] = ACTIONS(493),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_EQ_EQ] = ACTIONS(493),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_LT_LT] = ACTIONS(493),
    [anon_sym_GT_GT] = ACTIONS(493),
    [anon_sym_DASH] = ACTIONS(497),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(493),
    [anon_sym_STAR_STAR] = ACTIONS(493),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(493),
    [aux_sym_class_token1] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_BANG_QMARK] = ACTIONS(493),
    [anon_sym_QMARK_QMARK] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(474),
    [anon_sym_while] = ACTIONS(474),
    [anon_sym_DOTwhile] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(474),
    [anon_sym_forBy] = ACTIONS(474),
    [anon_sym_case] = ACTIONS(474),
    [anon_sym_switch] = ACTIONS(474),
    [sym_block_comment] = ACTIONS(5),
  },
  [112] = {
    [sym_line_comment] = STATE(112),
    [sym_identifier] = ACTIONS(500),
    [anon_sym_SEMI] = ACTIONS(502),
    [anon_sym__] = ACTIONS(500),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_EQ] = ACTIONS(500),
    [anon_sym_LPAREN] = ACTIONS(502),
    [anon_sym_RPAREN] = ACTIONS(502),
    [anon_sym_DOT] = ACTIONS(500),
    [anon_sym_LBRACE] = ACTIONS(502),
    [anon_sym_RBRACE] = ACTIONS(502),
    [anon_sym_COMMA] = ACTIONS(502),
    [anon_sym_PIPE] = ACTIONS(500),
    [anon_sym_COLON] = ACTIONS(502),
    [anon_sym_pi] = ACTIONS(500),
    [sym_integer] = ACTIONS(500),
    [sym_hexinteger] = ACTIONS(502),
    [sym_float] = ACTIONS(500),
    [sym_exponential] = ACTIONS(502),
    [anon_sym_BSLASH] = ACTIONS(502),
    [anon_sym_SQUOTE] = ACTIONS(502),
    [sym_char] = ACTIONS(502),
    [anon_sym_DQUOTE] = ACTIONS(502),
    [anon_sym_true] = ACTIONS(500),
    [anon_sym_false] = ACTIONS(500),
    [anon_sym_inf] = ACTIONS(500),
    [anon_sym_nil] = ACTIONS(500),
    [anon_sym_thisFunction] = ACTIONS(500),
    [anon_sym_thisFunctionDef] = ACTIONS(500),
    [anon_sym_thisMethod] = ACTIONS(500),
    [anon_sym_thisProcess] = ACTIONS(500),
    [anon_sym_thisThread] = ACTIONS(500),
    [anon_sym_currentEnvironment] = ACTIONS(500),
    [anon_sym_topEnvironment] = ACTIONS(500),
    [anon_sym_var] = ACTIONS(500),
    [anon_sym_LT] = ACTIONS(500),
    [anon_sym_GT] = ACTIONS(500),
    [anon_sym_LT_GT] = ACTIONS(502),
    [anon_sym_classvar] = ACTIONS(500),
    [aux_sym_environment_var_token1] = ACTIONS(500),
    [anon_sym_TILDE] = ACTIONS(502),
    [anon_sym_PLUS] = ACTIONS(500),
    [anon_sym_STAR] = ACTIONS(500),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(502),
    [anon_sym_POUND] = ACTIONS(502),
    [anon_sym_LBRACK] = ACTIONS(502),
    [anon_sym_RBRACK] = ACTIONS(502),
    [anon_sym_DASH_GT] = ACTIONS(502),
    [aux_sym_binary_expression_token1] = ACTIONS(502),
    [anon_sym_AMP_AMP] = ACTIONS(502),
    [anon_sym_PIPE_PIPE] = ACTIONS(502),
    [anon_sym_AMP] = ACTIONS(500),
    [anon_sym_EQ_EQ] = ACTIONS(502),
    [anon_sym_BANG_EQ] = ACTIONS(502),
    [anon_sym_LT_EQ] = ACTIONS(502),
    [anon_sym_GT_EQ] = ACTIONS(502),
    [anon_sym_LT_LT] = ACTIONS(502),
    [anon_sym_GT_GT] = ACTIONS(502),
    [anon_sym_DASH] = ACTIONS(500),
    [anon_sym_PLUS_PLUS] = ACTIONS(502),
    [anon_sym_SLASH] = ACTIONS(500),
    [anon_sym_PERCENT] = ACTIONS(502),
    [anon_sym_STAR_STAR] = ACTIONS(502),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(502),
    [aux_sym_class_token1] = ACTIONS(500),
    [anon_sym_QMARK] = ACTIONS(500),
    [anon_sym_BANG_QMARK] = ACTIONS(502),
    [anon_sym_QMARK_QMARK] = ACTIONS(502),
    [anon_sym_if] = ACTIONS(500),
    [anon_sym_while] = ACTIONS(500),
    [anon_sym_DOTwhile] = ACTIONS(502),
    [anon_sym_for] = ACTIONS(500),
    [anon_sym_forBy] = ACTIONS(500),
    [anon_sym_case] = ACTIONS(500),
    [anon_sym_switch] = ACTIONS(500),
    [sym_block_comment] = ACTIONS(5),
  },
  [113] = {
    [sym_line_comment] = STATE(113),
    [ts_builtin_sym_end] = ACTIONS(504),
    [sym_identifier] = ACTIONS(506),
    [anon_sym_SEMI] = ACTIONS(504),
    [anon_sym__] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(506),
    [anon_sym_EQ] = ACTIONS(506),
    [anon_sym_LPAREN] = ACTIONS(504),
    [anon_sym_DOT] = ACTIONS(506),
    [anon_sym_LBRACE] = ACTIONS(504),
    [anon_sym_COMMA] = ACTIONS(504),
    [anon_sym_PIPE] = ACTIONS(506),
    [anon_sym_COLON] = ACTIONS(504),
    [anon_sym_pi] = ACTIONS(506),
    [sym_integer] = ACTIONS(506),
    [sym_hexinteger] = ACTIONS(504),
    [sym_float] = ACTIONS(506),
    [sym_exponential] = ACTIONS(504),
    [anon_sym_BSLASH] = ACTIONS(504),
    [anon_sym_SQUOTE] = ACTIONS(504),
    [sym_char] = ACTIONS(504),
    [anon_sym_DQUOTE] = ACTIONS(504),
    [anon_sym_true] = ACTIONS(506),
    [anon_sym_false] = ACTIONS(506),
    [anon_sym_inf] = ACTIONS(506),
    [anon_sym_nil] = ACTIONS(506),
    [anon_sym_thisFunction] = ACTIONS(506),
    [anon_sym_thisFunctionDef] = ACTIONS(506),
    [anon_sym_thisMethod] = ACTIONS(506),
    [anon_sym_thisProcess] = ACTIONS(506),
    [anon_sym_thisThread] = ACTIONS(506),
    [anon_sym_currentEnvironment] = ACTIONS(506),
    [anon_sym_topEnvironment] = ACTIONS(506),
    [anon_sym_var] = ACTIONS(506),
    [anon_sym_LT] = ACTIONS(506),
    [anon_sym_GT] = ACTIONS(506),
    [anon_sym_LT_GT] = ACTIONS(504),
    [anon_sym_classvar] = ACTIONS(506),
    [aux_sym_environment_var_token1] = ACTIONS(506),
    [anon_sym_TILDE] = ACTIONS(504),
    [anon_sym_CARET] = ACTIONS(504),
    [anon_sym_PLUS] = ACTIONS(506),
    [anon_sym_STAR] = ACTIONS(506),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(504),
    [anon_sym_POUND] = ACTIONS(504),
    [anon_sym_LBRACK] = ACTIONS(504),
    [anon_sym_DASH_GT] = ACTIONS(504),
    [aux_sym_binary_expression_token1] = ACTIONS(504),
    [anon_sym_AMP_AMP] = ACTIONS(504),
    [anon_sym_PIPE_PIPE] = ACTIONS(504),
    [anon_sym_AMP] = ACTIONS(506),
    [anon_sym_EQ_EQ] = ACTIONS(504),
    [anon_sym_BANG_EQ] = ACTIONS(504),
    [anon_sym_LT_EQ] = ACTIONS(504),
    [anon_sym_GT_EQ] = ACTIONS(504),
    [anon_sym_LT_LT] = ACTIONS(504),
    [anon_sym_GT_GT] = ACTIONS(504),
    [anon_sym_DASH] = ACTIONS(506),
    [anon_sym_PLUS_PLUS] = ACTIONS(504),
    [anon_sym_SLASH] = ACTIONS(506),
    [anon_sym_PERCENT] = ACTIONS(504),
    [anon_sym_STAR_STAR] = ACTIONS(504),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(504),
    [aux_sym_class_token1] = ACTIONS(506),
    [anon_sym_QMARK] = ACTIONS(506),
    [anon_sym_BANG_QMARK] = ACTIONS(504),
    [anon_sym_QMARK_QMARK] = ACTIONS(504),
    [anon_sym_if] = ACTIONS(506),
    [anon_sym_while] = ACTIONS(506),
    [anon_sym_DOTwhile] = ACTIONS(504),
    [anon_sym_for] = ACTIONS(506),
    [anon_sym_forBy] = ACTIONS(506),
    [anon_sym_case] = ACTIONS(506),
    [anon_sym_switch] = ACTIONS(506),
    [sym_block_comment] = ACTIONS(5),
  },
  [114] = {
    [sym_line_comment] = STATE(114),
    [ts_builtin_sym_end] = ACTIONS(508),
    [sym_identifier] = ACTIONS(510),
    [anon_sym_SEMI] = ACTIONS(512),
    [anon_sym__] = ACTIONS(510),
    [anon_sym_BANG] = ACTIONS(514),
    [anon_sym_EQ] = ACTIONS(514),
    [anon_sym_LPAREN] = ACTIONS(508),
    [anon_sym_DOT] = ACTIONS(514),
    [anon_sym_LBRACE] = ACTIONS(508),
    [anon_sym_COMMA] = ACTIONS(508),
    [anon_sym_PIPE] = ACTIONS(514),
    [anon_sym_COLON] = ACTIONS(508),
    [anon_sym_pi] = ACTIONS(510),
    [sym_integer] = ACTIONS(510),
    [sym_hexinteger] = ACTIONS(508),
    [sym_float] = ACTIONS(510),
    [sym_exponential] = ACTIONS(508),
    [anon_sym_BSLASH] = ACTIONS(508),
    [anon_sym_SQUOTE] = ACTIONS(508),
    [sym_char] = ACTIONS(508),
    [anon_sym_DQUOTE] = ACTIONS(508),
    [anon_sym_true] = ACTIONS(510),
    [anon_sym_false] = ACTIONS(510),
    [anon_sym_inf] = ACTIONS(510),
    [anon_sym_nil] = ACTIONS(510),
    [anon_sym_thisFunction] = ACTIONS(510),
    [anon_sym_thisFunctionDef] = ACTIONS(510),
    [anon_sym_thisMethod] = ACTIONS(510),
    [anon_sym_thisProcess] = ACTIONS(510),
    [anon_sym_thisThread] = ACTIONS(510),
    [anon_sym_currentEnvironment] = ACTIONS(510),
    [anon_sym_topEnvironment] = ACTIONS(510),
    [anon_sym_var] = ACTIONS(510),
    [anon_sym_LT] = ACTIONS(516),
    [anon_sym_GT] = ACTIONS(516),
    [anon_sym_LT_GT] = ACTIONS(508),
    [anon_sym_classvar] = ACTIONS(510),
    [aux_sym_environment_var_token1] = ACTIONS(510),
    [anon_sym_TILDE] = ACTIONS(508),
    [anon_sym_CARET] = ACTIONS(508),
    [anon_sym_PLUS] = ACTIONS(516),
    [anon_sym_STAR] = ACTIONS(516),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(508),
    [anon_sym_POUND] = ACTIONS(508),
    [anon_sym_LBRACK] = ACTIONS(508),
    [anon_sym_DASH_GT] = ACTIONS(512),
    [aux_sym_binary_expression_token1] = ACTIONS(512),
    [anon_sym_AMP_AMP] = ACTIONS(512),
    [anon_sym_PIPE_PIPE] = ACTIONS(512),
    [anon_sym_AMP] = ACTIONS(514),
    [anon_sym_EQ_EQ] = ACTIONS(512),
    [anon_sym_BANG_EQ] = ACTIONS(512),
    [anon_sym_LT_EQ] = ACTIONS(512),
    [anon_sym_GT_EQ] = ACTIONS(512),
    [anon_sym_LT_LT] = ACTIONS(512),
    [anon_sym_GT_GT] = ACTIONS(512),
    [anon_sym_DASH] = ACTIONS(516),
    [anon_sym_PLUS_PLUS] = ACTIONS(512),
    [anon_sym_SLASH] = ACTIONS(514),
    [anon_sym_PERCENT] = ACTIONS(512),
    [anon_sym_STAR_STAR] = ACTIONS(512),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(512),
    [aux_sym_class_token1] = ACTIONS(510),
    [anon_sym_QMARK] = ACTIONS(514),
    [anon_sym_BANG_QMARK] = ACTIONS(512),
    [anon_sym_QMARK_QMARK] = ACTIONS(512),
    [anon_sym_if] = ACTIONS(510),
    [anon_sym_while] = ACTIONS(510),
    [anon_sym_DOTwhile] = ACTIONS(512),
    [anon_sym_for] = ACTIONS(510),
    [anon_sym_forBy] = ACTIONS(510),
    [anon_sym_case] = ACTIONS(510),
    [anon_sym_switch] = ACTIONS(510),
    [sym_block_comment] = ACTIONS(5),
  },
  [115] = {
    [sym_line_comment] = STATE(115),
    [ts_builtin_sym_end] = ACTIONS(519),
    [sym_identifier] = ACTIONS(521),
    [anon_sym_SEMI] = ACTIONS(519),
    [anon_sym__] = ACTIONS(521),
    [anon_sym_BANG] = ACTIONS(521),
    [anon_sym_EQ] = ACTIONS(521),
    [anon_sym_LPAREN] = ACTIONS(519),
    [anon_sym_DOT] = ACTIONS(521),
    [anon_sym_LBRACE] = ACTIONS(519),
    [anon_sym_COMMA] = ACTIONS(519),
    [anon_sym_PIPE] = ACTIONS(521),
    [anon_sym_COLON] = ACTIONS(519),
    [anon_sym_pi] = ACTIONS(521),
    [sym_integer] = ACTIONS(521),
    [sym_hexinteger] = ACTIONS(519),
    [sym_float] = ACTIONS(521),
    [sym_exponential] = ACTIONS(519),
    [anon_sym_BSLASH] = ACTIONS(519),
    [anon_sym_SQUOTE] = ACTIONS(519),
    [sym_char] = ACTIONS(519),
    [anon_sym_DQUOTE] = ACTIONS(519),
    [anon_sym_true] = ACTIONS(521),
    [anon_sym_false] = ACTIONS(521),
    [anon_sym_inf] = ACTIONS(521),
    [anon_sym_nil] = ACTIONS(521),
    [anon_sym_thisFunction] = ACTIONS(521),
    [anon_sym_thisFunctionDef] = ACTIONS(521),
    [anon_sym_thisMethod] = ACTIONS(521),
    [anon_sym_thisProcess] = ACTIONS(521),
    [anon_sym_thisThread] = ACTIONS(521),
    [anon_sym_currentEnvironment] = ACTIONS(521),
    [anon_sym_topEnvironment] = ACTIONS(521),
    [anon_sym_var] = ACTIONS(521),
    [anon_sym_LT] = ACTIONS(521),
    [anon_sym_GT] = ACTIONS(521),
    [anon_sym_LT_GT] = ACTIONS(519),
    [anon_sym_classvar] = ACTIONS(521),
    [aux_sym_environment_var_token1] = ACTIONS(521),
    [anon_sym_TILDE] = ACTIONS(519),
    [anon_sym_CARET] = ACTIONS(519),
    [anon_sym_PLUS] = ACTIONS(521),
    [anon_sym_STAR] = ACTIONS(521),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(519),
    [anon_sym_POUND] = ACTIONS(519),
    [anon_sym_LBRACK] = ACTIONS(519),
    [anon_sym_DASH_GT] = ACTIONS(519),
    [aux_sym_binary_expression_token1] = ACTIONS(519),
    [anon_sym_AMP_AMP] = ACTIONS(519),
    [anon_sym_PIPE_PIPE] = ACTIONS(519),
    [anon_sym_AMP] = ACTIONS(521),
    [anon_sym_EQ_EQ] = ACTIONS(519),
    [anon_sym_BANG_EQ] = ACTIONS(519),
    [anon_sym_LT_EQ] = ACTIONS(519),
    [anon_sym_GT_EQ] = ACTIONS(519),
    [anon_sym_LT_LT] = ACTIONS(519),
    [anon_sym_GT_GT] = ACTIONS(519),
    [anon_sym_DASH] = ACTIONS(521),
    [anon_sym_PLUS_PLUS] = ACTIONS(519),
    [anon_sym_SLASH] = ACTIONS(521),
    [anon_sym_PERCENT] = ACTIONS(519),
    [anon_sym_STAR_STAR] = ACTIONS(519),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(519),
    [aux_sym_class_token1] = ACTIONS(521),
    [anon_sym_QMARK] = ACTIONS(521),
    [anon_sym_BANG_QMARK] = ACTIONS(519),
    [anon_sym_QMARK_QMARK] = ACTIONS(519),
    [anon_sym_if] = ACTIONS(521),
    [anon_sym_while] = ACTIONS(521),
    [anon_sym_DOTwhile] = ACTIONS(519),
    [anon_sym_for] = ACTIONS(521),
    [anon_sym_forBy] = ACTIONS(521),
    [anon_sym_case] = ACTIONS(521),
    [anon_sym_switch] = ACTIONS(521),
    [sym_block_comment] = ACTIONS(5),
  },
  [116] = {
    [sym_line_comment] = STATE(116),
    [sym_identifier] = ACTIONS(482),
    [anon_sym__] = ACTIONS(474),
    [anon_sym_EQ] = ACTIONS(478),
    [anon_sym_LPAREN] = ACTIONS(523),
    [anon_sym_DOT] = ACTIONS(478),
    [anon_sym_LBRACE] = ACTIONS(523),
    [anon_sym_PIPE] = ACTIONS(478),
    [anon_sym_COLON] = ACTIONS(480),
    [anon_sym_pi] = ACTIONS(474),
    [sym_integer] = ACTIONS(474),
    [sym_hexinteger] = ACTIONS(480),
    [sym_float] = ACTIONS(474),
    [sym_exponential] = ACTIONS(480),
    [anon_sym_BSLASH] = ACTIONS(480),
    [anon_sym_SQUOTE] = ACTIONS(480),
    [sym_char] = ACTIONS(480),
    [anon_sym_DQUOTE] = ACTIONS(480),
    [anon_sym_true] = ACTIONS(474),
    [anon_sym_false] = ACTIONS(474),
    [anon_sym_inf] = ACTIONS(474),
    [anon_sym_nil] = ACTIONS(474),
    [anon_sym_thisFunction] = ACTIONS(474),
    [anon_sym_thisFunctionDef] = ACTIONS(474),
    [anon_sym_thisMethod] = ACTIONS(474),
    [anon_sym_thisProcess] = ACTIONS(474),
    [anon_sym_thisThread] = ACTIONS(474),
    [anon_sym_currentEnvironment] = ACTIONS(474),
    [anon_sym_topEnvironment] = ACTIONS(474),
    [anon_sym_var] = ACTIONS(474),
    [anon_sym_LT] = ACTIONS(482),
    [anon_sym_GT] = ACTIONS(482),
    [anon_sym_LT_GT] = ACTIONS(480),
    [anon_sym_classvar] = ACTIONS(474),
    [aux_sym_environment_var_token1] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(480),
    [anon_sym_PLUS] = ACTIONS(478),
    [anon_sym_STAR] = ACTIONS(482),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(480),
    [anon_sym_POUND] = ACTIONS(480),
    [anon_sym_LBRACK] = ACTIONS(480),
    [anon_sym_DASH_GT] = ACTIONS(476),
    [aux_sym_binary_expression_token1] = ACTIONS(476),
    [anon_sym_AMP_AMP] = ACTIONS(476),
    [anon_sym_PIPE_PIPE] = ACTIONS(476),
    [anon_sym_AMP] = ACTIONS(478),
    [anon_sym_EQ_EQ] = ACTIONS(476),
    [anon_sym_BANG_EQ] = ACTIONS(476),
    [anon_sym_LT_EQ] = ACTIONS(476),
    [anon_sym_GT_EQ] = ACTIONS(476),
    [anon_sym_LT_LT] = ACTIONS(476),
    [anon_sym_GT_GT] = ACTIONS(476),
    [anon_sym_DASH] = ACTIONS(482),
    [anon_sym_PLUS_PLUS] = ACTIONS(476),
    [anon_sym_SLASH] = ACTIONS(478),
    [anon_sym_PERCENT] = ACTIONS(476),
    [anon_sym_STAR_STAR] = ACTIONS(476),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(476),
    [aux_sym_class_token1] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(478),
    [anon_sym_BANG_QMARK] = ACTIONS(476),
    [anon_sym_QMARK_QMARK] = ACTIONS(476),
    [anon_sym_if] = ACTIONS(474),
    [anon_sym_while] = ACTIONS(474),
    [anon_sym_DOTwhile] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(474),
    [anon_sym_forBy] = ACTIONS(474),
    [anon_sym_case] = ACTIONS(474),
    [anon_sym_switch] = ACTIONS(474),
    [sym_block_comment] = ACTIONS(5),
  },
  [117] = {
    [sym_line_comment] = STATE(117),
    [sym_identifier] = ACTIONS(497),
    [anon_sym__] = ACTIONS(474),
    [anon_sym_EQ] = ACTIONS(495),
    [anon_sym_LPAREN] = ACTIONS(526),
    [anon_sym_DOT] = ACTIONS(495),
    [anon_sym_LBRACE] = ACTIONS(526),
    [anon_sym_PIPE] = ACTIONS(495),
    [anon_sym_COLON] = ACTIONS(480),
    [anon_sym_pi] = ACTIONS(474),
    [sym_integer] = ACTIONS(474),
    [sym_hexinteger] = ACTIONS(480),
    [sym_float] = ACTIONS(474),
    [sym_exponential] = ACTIONS(480),
    [anon_sym_BSLASH] = ACTIONS(480),
    [anon_sym_SQUOTE] = ACTIONS(480),
    [sym_char] = ACTIONS(480),
    [anon_sym_DQUOTE] = ACTIONS(480),
    [anon_sym_true] = ACTIONS(474),
    [anon_sym_false] = ACTIONS(474),
    [anon_sym_inf] = ACTIONS(474),
    [anon_sym_nil] = ACTIONS(474),
    [anon_sym_thisFunction] = ACTIONS(474),
    [anon_sym_thisFunctionDef] = ACTIONS(474),
    [anon_sym_thisMethod] = ACTIONS(474),
    [anon_sym_thisProcess] = ACTIONS(474),
    [anon_sym_thisThread] = ACTIONS(474),
    [anon_sym_currentEnvironment] = ACTIONS(474),
    [anon_sym_topEnvironment] = ACTIONS(474),
    [anon_sym_var] = ACTIONS(474),
    [anon_sym_LT] = ACTIONS(497),
    [anon_sym_GT] = ACTIONS(497),
    [anon_sym_LT_GT] = ACTIONS(480),
    [anon_sym_classvar] = ACTIONS(474),
    [aux_sym_environment_var_token1] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(480),
    [anon_sym_PLUS] = ACTIONS(495),
    [anon_sym_STAR] = ACTIONS(497),
    [aux_sym_line_comment_token1] = ACTIONS(3),
    [sym_ref] = ACTIONS(480),
    [anon_sym_POUND] = ACTIONS(480),
    [anon_sym_LBRACK] = ACTIONS(480),
    [anon_sym_DASH_GT] = ACTIONS(493),
    [aux_sym_binary_expression_token1] = ACTIONS(493),
    [anon_sym_AMP_AMP] = ACTIONS(493),
    [anon_sym_PIPE_PIPE] = ACTIONS(493),
    [anon_sym_AMP] = ACTIONS(495),
    [anon_sym_EQ_EQ] = ACTIONS(493),
    [anon_sym_BANG_EQ] = ACTIONS(493),
    [anon_sym_LT_EQ] = ACTIONS(493),
    [anon_sym_GT_EQ] = ACTIONS(493),
    [anon_sym_LT_LT] = ACTIONS(493),
    [anon_sym_GT_GT] = ACTIONS(493),
    [anon_sym_DASH] = ACTIONS(497),
    [anon_sym_PLUS_PLUS] = ACTIONS(493),
    [anon_sym_SLASH] = ACTIONS(495),
    [anon_sym_PERCENT] = ACTIONS(493),
    [anon_sym_STAR_STAR] = ACTIONS(493),
    [anon_sym_PLUS_SLASH_PLUS] = ACTIONS(493),
    [aux_sym_class_token1] = ACTIONS(474),
    [anon_sym_QMARK] = ACTIONS(495),
    [anon_sym_BANG_QMARK] = ACTIONS(493),
    [anon_sym_QMARK_QMARK] = ACTIONS(493),
    [anon_sym_if] = ACTIONS(474),
    [anon_sym_while] = ACTIONS(474),
    [anon_sym_DOTwhile] = ACTIONS(493),
    [anon_sym_for] = ACTIONS(474),
    [anon_sym_forBy] = ACTIONS(474),
    [anon_sym_case] = ACTIONS(474),
    [anon_sym_switch] = ACTIONS(474),
    [sym_block_comment] = ACTIONS(5),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(118), 1,
      sym_line_comment,
    ACTIONS(531), 20,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(529), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [62] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(119), 1,
      sym_line_comment,
    ACTIONS(533), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(535), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [124] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(120), 1,
      sym_line_comment,
    ACTIONS(539), 20,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(537), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [186] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(121), 1,
      sym_line_comment,
    ACTIONS(541), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(543), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [248] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(122), 1,
      sym_line_comment,
    ACTIONS(545), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(547), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [310] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(123), 1,
      sym_line_comment,
    ACTIONS(553), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(551), 18,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(549), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [374] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(124), 1,
      sym_line_comment,
    ACTIONS(508), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(510), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [436] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(125), 1,
      sym_line_comment,
    ACTIONS(557), 20,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(555), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [498] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(126), 1,
      sym_line_comment,
    ACTIONS(559), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(551), 18,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(549), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [562] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(127), 1,
      sym_line_comment,
    ACTIONS(563), 20,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(561), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [624] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(128), 1,
      sym_line_comment,
    ACTIONS(565), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(567), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [686] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(129), 1,
      sym_line_comment,
    ACTIONS(569), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(571), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [748] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(130), 1,
      sym_line_comment,
    ACTIONS(573), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(575), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [810] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(131), 1,
      sym_line_comment,
    ACTIONS(577), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(579), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [872] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(132), 1,
      sym_line_comment,
    ACTIONS(581), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(583), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [934] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(133), 1,
      sym_line_comment,
    ACTIONS(585), 20,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_PLUS,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(587), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [996] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(134), 1,
      sym_line_comment,
    ACTIONS(591), 20,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(589), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1058] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(135), 1,
      sym_line_comment,
    ACTIONS(551), 18,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_CARET,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(549), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1118] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(136), 1,
      sym_line_comment,
    ACTIONS(468), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(466), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1176] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(137), 1,
      sym_line_comment,
    ACTIONS(480), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(474), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1234] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(138), 1,
      sym_line_comment,
    ACTIONS(487), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(485), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1292] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(139), 1,
      sym_line_comment,
    ACTIONS(472), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(470), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1350] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(140), 1,
      sym_line_comment,
    ACTIONS(460), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(458), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1408] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(141), 1,
      sym_line_comment,
    ACTIONS(464), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(462), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1466] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(142), 1,
      sym_line_comment,
    ACTIONS(504), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(506), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1524] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(143), 1,
      sym_line_comment,
    ACTIONS(491), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(489), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1582] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(144), 1,
      sym_line_comment,
    ACTIONS(502), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(500), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1640] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(145), 1,
      sym_line_comment,
    ACTIONS(519), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_COLON,
      sym_hexinteger,
      sym_exponential,
      anon_sym_BSLASH,
      anon_sym_SQUOTE,
      sym_char,
      anon_sym_DQUOTE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_TILDE,
      anon_sym_STAR,
      sym_ref,
      anon_sym_POUND,
      anon_sym_LBRACK,
    ACTIONS(521), 28,
      anon_sym__,
      anon_sym_pi,
      sym_integer,
      sym_float,
      anon_sym_true,
      anon_sym_false,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      aux_sym_environment_var_token1,
      anon_sym_DASH,
      aux_sym_class_token1,
      sym_identifier,
      anon_sym_if,
      anon_sym_while,
      anon_sym_for,
      anon_sym_forBy,
      anon_sym_case,
      anon_sym_switch,
  [1698] = 9,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(146), 1,
      sym_line_comment,
    STATE(148), 1,
      sym__index,
    STATE(377), 1,
      aux_sym_indexed_collection_repeat1,
    ACTIONS(595), 3,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
    ACTIONS(514), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(512), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [1763] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(147), 1,
      sym_line_comment,
    ACTIONS(597), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(599), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [1818] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(148), 1,
      sym_line_comment,
    ACTIONS(605), 4,
      anon_sym_LBRACK,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
    ACTIONS(601), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(603), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [1875] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(149), 1,
      sym_line_comment,
    ACTIONS(607), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(609), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [1930] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(150), 1,
      sym_line_comment,
    ACTIONS(611), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(613), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [1985] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(619), 1,
      anon_sym_LPAREN,
    STATE(151), 1,
      sym_line_comment,
    STATE(237), 1,
      sym__function_content,
    ACTIONS(617), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(615), 26,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2046] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(152), 1,
      sym_line_comment,
    ACTIONS(621), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(623), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2101] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(153), 1,
      sym_line_comment,
    ACTIONS(605), 4,
      anon_sym_LBRACK,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
    ACTIONS(625), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(627), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2158] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(154), 1,
      sym_line_comment,
    ACTIONS(629), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(631), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2213] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(155), 1,
      sym_line_comment,
    ACTIONS(633), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(635), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2268] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(156), 1,
      sym_line_comment,
    ACTIONS(637), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(639), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2323] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(157), 1,
      sym_line_comment,
    ACTIONS(641), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(643), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2378] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(158), 1,
      sym_line_comment,
    ACTIONS(645), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(647), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2433] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(159), 1,
      sym_line_comment,
    ACTIONS(649), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(651), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2488] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(160), 1,
      sym_line_comment,
    ACTIONS(653), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(655), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2543] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(161), 1,
      sym_line_comment,
    ACTIONS(657), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(659), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2598] = 9,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(619), 1,
      anon_sym_LPAREN,
    ACTIONS(661), 1,
      anon_sym_COLON,
    STATE(162), 1,
      sym_line_comment,
    STATE(237), 1,
      sym__function_content,
    ACTIONS(617), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(615), 25,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2661] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(163), 1,
      sym_line_comment,
    ACTIONS(663), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(665), 28,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2716] = 12,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    ACTIONS(667), 1,
      anon_sym_EQ,
    ACTIONS(669), 1,
      anon_sym_COMMA,
    STATE(148), 1,
      sym__index,
    STATE(164), 1,
      sym_line_comment,
    STATE(377), 1,
      aux_sym_indexed_collection_repeat1,
    STATE(527), 1,
      aux_sym_variable_definition_sequence_repeat1,
    ACTIONS(595), 3,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
    ACTIONS(514), 11,
      anon_sym_BANG,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 20,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2784] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(675), 1,
      anon_sym_DOTfor,
    ACTIONS(677), 1,
      anon_sym_DOTforBy,
    STATE(165), 1,
      sym_line_comment,
    ACTIONS(671), 14,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(673), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [2842] = 24,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      sym_char,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(47), 1,
      aux_sym_environment_var_token1,
    ACTIONS(49), 1,
      anon_sym_TILDE,
    ACTIONS(679), 1,
      sym_identifier,
    ACTIONS(683), 1,
      sym_integer,
    ACTIONS(687), 1,
      anon_sym_BSLASH,
    ACTIONS(689), 1,
      anon_sym_DOT_DOT,
    STATE(166), 1,
      sym_line_comment,
    STATE(371), 1,
      sym_number,
    ACTIONS(35), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    ACTIONS(681), 2,
      anon_sym_pi,
      sym_float,
    ACTIONS(685), 2,
      sym_hexinteger,
      sym_exponential,
    STATE(599), 2,
      sym_literal,
      sym_variable,
    STATE(192), 3,
      sym_symbol,
      sym_string,
      sym_bool,
    STATE(156), 5,
      sym_builtin_var,
      sym_local_var,
      sym_instance_var,
      sym_classvar,
      sym_environment_var,
    ACTIONS(37), 9,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
  [2934] = 11,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      sym_identifier,
    ACTIONS(695), 1,
      anon_sym__,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    ACTIONS(701), 1,
      anon_sym_if,
    STATE(167), 1,
      sym_line_comment,
    STATE(205), 1,
      sym__function_content,
    ACTIONS(697), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(693), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3000] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(168), 1,
      sym_line_comment,
    ACTIONS(703), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(705), 26,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3053] = 10,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(707), 1,
      sym_identifier,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    STATE(169), 1,
      sym_line_comment,
    STATE(227), 1,
      sym_function_block,
    STATE(249), 1,
      sym__function_content,
    ACTIONS(711), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(709), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3116] = 10,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(691), 1,
      sym_identifier,
    ACTIONS(695), 1,
      anon_sym__,
    ACTIONS(699), 1,
      anon_sym_LPAREN,
    STATE(170), 1,
      sym_line_comment,
    STATE(205), 1,
      sym__function_content,
    ACTIONS(697), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(693), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3179] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(171), 1,
      sym_line_comment,
    ACTIONS(671), 14,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(673), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3231] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(172), 1,
      sym_line_comment,
    ACTIONS(715), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(717), 25,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3283] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(173), 1,
      sym_line_comment,
    ACTIONS(719), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(721), 25,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3335] = 9,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(725), 1,
      anon_sym__,
    ACTIONS(729), 1,
      anon_sym_LPAREN,
    STATE(174), 1,
      sym_line_comment,
    STATE(235), 1,
      sym__function_content,
    ACTIONS(727), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(723), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3395] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(731), 1,
      sym_identifier,
    STATE(175), 1,
      sym_line_comment,
    ACTIONS(737), 2,
      aux_sym_symbol_token1,
      sym_escape_sequence,
    ACTIONS(735), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(733), 23,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_COLON,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3451] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(176), 1,
      sym_line_comment,
    ACTIONS(739), 14,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(741), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3503] = 10,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(619), 1,
      anon_sym_LPAREN,
    ACTIONS(743), 1,
      anon_sym_EQ,
    ACTIONS(745), 1,
      anon_sym_COLON,
    STATE(177), 1,
      sym_line_comment,
    STATE(237), 1,
      sym__function_content,
    ACTIONS(617), 10,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(615), 23,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_LBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3565] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(751), 1,
      anon_sym_pi,
    STATE(178), 1,
      sym_line_comment,
    ACTIONS(747), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(749), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3619] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(179), 1,
      sym_line_comment,
    ACTIONS(753), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(755), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3670] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(180), 1,
      sym_line_comment,
    ACTIONS(757), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(759), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3721] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(181), 1,
      sym_line_comment,
    ACTIONS(761), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(763), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3772] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(182), 1,
      sym_line_comment,
    ACTIONS(765), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(767), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3823] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(183), 1,
      sym_line_comment,
    ACTIONS(769), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(771), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3874] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(184), 1,
      sym_line_comment,
    ACTIONS(773), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(775), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3925] = 9,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(185), 1,
      sym_line_comment,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(779), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(777), 20,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [3984] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(186), 1,
      sym_line_comment,
    ACTIONS(785), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(787), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4035] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(187), 1,
      sym_line_comment,
    ACTIONS(789), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(791), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4086] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(188), 1,
      sym_line_comment,
    ACTIONS(793), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(795), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4137] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(801), 1,
      anon_sym_DOT,
    STATE(189), 1,
      sym_line_comment,
    STATE(219), 1,
      aux_sym_function_call_repeat1,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(799), 11,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(797), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4194] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(190), 1,
      sym_line_comment,
    ACTIONS(803), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(805), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4245] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(191), 1,
      sym_line_comment,
    ACTIONS(807), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(809), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4296] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(192), 1,
      sym_line_comment,
    ACTIONS(747), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(749), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4347] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(193), 1,
      sym_line_comment,
    ACTIONS(811), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(813), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4398] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(194), 1,
      sym_line_comment,
    ACTIONS(506), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(504), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4449] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(195), 1,
      sym_line_comment,
    ACTIONS(815), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(817), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4500] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(196), 1,
      sym_line_comment,
    ACTIONS(819), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(821), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4551] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(197), 1,
      sym_line_comment,
    ACTIONS(823), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(825), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4602] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(198), 1,
      sym_line_comment,
    ACTIONS(827), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(829), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4653] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(199), 1,
      sym_line_comment,
    ACTIONS(831), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(833), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4704] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(200), 1,
      sym_line_comment,
    ACTIONS(835), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(837), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4755] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(201), 1,
      sym_line_comment,
    ACTIONS(839), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(841), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4806] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(202), 1,
      sym_line_comment,
    ACTIONS(470), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(472), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4857] = 22,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(203), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 3,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_QMARK,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(843), 8,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4942] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(204), 1,
      sym_line_comment,
    ACTIONS(873), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(875), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [4993] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(205), 1,
      sym_line_comment,
    ACTIONS(877), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(879), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5044] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(206), 1,
      sym_line_comment,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 7,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_QMARK,
    ACTIONS(843), 14,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5117] = 17,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(207), 1,
      sym_line_comment,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 6,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_QMARK,
    ACTIONS(843), 14,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5192] = 12,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(208), 1,
      sym_line_comment,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 10,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_QMARK,
    ACTIONS(843), 17,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5257] = 10,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(209), 1,
      sym_line_comment,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(843), 19,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5318] = 26,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(883), 1,
      anon_sym_BANG,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(210), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(881), 5,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [5411] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(211), 1,
      sym_line_comment,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(843), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5466] = 19,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(212), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 4,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(843), 10,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5545] = 20,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(213), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 4,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_QMARK,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(843), 9,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5626] = 15,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(214), 1,
      sym_line_comment,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 8,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_QMARK,
    ACTIONS(843), 14,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5697] = 14,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(215), 1,
      sym_line_comment,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 8,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      anon_sym_QMARK,
    ACTIONS(843), 16,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5766] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(216), 1,
      sym_line_comment,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(843), 21,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5823] = 22,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(217), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(895), 3,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_QMARK,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(893), 8,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5908] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(218), 1,
      sym_line_comment,
    ACTIONS(897), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(899), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [5959] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(905), 1,
      anon_sym_DOT,
    STATE(219), 2,
      sym_line_comment,
      aux_sym_function_call_repeat1,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(903), 11,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(901), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6014] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(220), 1,
      sym_line_comment,
    ACTIONS(908), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(910), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6065] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(221), 1,
      sym_line_comment,
    ACTIONS(912), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(914), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6116] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(222), 1,
      sym_line_comment,
    ACTIONS(485), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(487), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6167] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(223), 1,
      sym_line_comment,
    ACTIONS(916), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(918), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6218] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(224), 1,
      sym_line_comment,
    ACTIONS(462), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(464), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6269] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(225), 1,
      sym_line_comment,
    ACTIONS(920), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(922), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6320] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(226), 1,
      sym_line_comment,
    ACTIONS(514), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(512), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6371] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(227), 1,
      sym_line_comment,
    ACTIONS(924), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(926), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6422] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(228), 1,
      sym_line_comment,
    ACTIONS(928), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(930), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6473] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(229), 1,
      sym_line_comment,
    ACTIONS(932), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(934), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6524] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(230), 1,
      sym_line_comment,
    ACTIONS(936), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(938), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6575] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(231), 1,
      sym_line_comment,
    ACTIONS(940), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(942), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6626] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(232), 1,
      sym_line_comment,
    ACTIONS(944), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(946), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6677] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(233), 1,
      sym_line_comment,
    ACTIONS(948), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(950), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6728] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(234), 1,
      sym_line_comment,
    ACTIONS(952), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(954), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6779] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(235), 1,
      sym_line_comment,
    ACTIONS(956), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(958), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6830] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(236), 1,
      sym_line_comment,
    ACTIONS(960), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(962), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6881] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(237), 1,
      sym_line_comment,
    ACTIONS(466), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(468), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6932] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(238), 1,
      sym_line_comment,
    ACTIONS(521), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(519), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [6983] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(239), 1,
      sym_line_comment,
    ACTIONS(964), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(966), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7034] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(240), 1,
      sym_line_comment,
    ACTIONS(968), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(970), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7085] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(241), 1,
      sym_line_comment,
    ACTIONS(972), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(974), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7136] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(242), 1,
      sym_line_comment,
    ACTIONS(976), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(978), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7187] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(243), 1,
      sym_line_comment,
    ACTIONS(980), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(982), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7238] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(244), 1,
      sym_line_comment,
    ACTIONS(514), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(512), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7289] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(245), 1,
      sym_line_comment,
    ACTIONS(458), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(460), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7340] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(246), 1,
      sym_line_comment,
    ACTIONS(984), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(986), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7391] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(247), 1,
      sym_line_comment,
    ACTIONS(988), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(990), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7442] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(248), 1,
      sym_line_comment,
    ACTIONS(992), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(994), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7493] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(249), 1,
      sym_line_comment,
    ACTIONS(500), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(502), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7544] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(250), 1,
      sym_line_comment,
    ACTIONS(489), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(491), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7595] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(251), 1,
      sym_line_comment,
    ACTIONS(996), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(998), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7646] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(252), 1,
      sym_line_comment,
    ACTIONS(1000), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(1002), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7697] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(253), 1,
      sym_line_comment,
    ACTIONS(1004), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(1006), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7748] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(254), 1,
      sym_line_comment,
    ACTIONS(1008), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(1010), 24,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_RPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7799] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(675), 1,
      anon_sym_DOTfor,
    ACTIONS(677), 1,
      anon_sym_DOTforBy,
    STATE(255), 1,
      sym_line_comment,
    ACTIONS(671), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(673), 21,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7853] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1012), 1,
      anon_sym_LPAREN,
    ACTIONS(1014), 1,
      anon_sym_LBRACK,
    STATE(256), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [7907] = 29,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1016), 1,
      sym_identifier,
    ACTIONS(1018), 1,
      anon_sym_EQ,
    ACTIONS(1020), 1,
      anon_sym_LPAREN,
    ACTIONS(1022), 1,
      anon_sym_DOT,
    ACTIONS(1024), 1,
      anon_sym_LBRACE,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(1054), 1,
      anon_sym_QMARK,
    STATE(108), 1,
      sym_function_block,
    STATE(112), 1,
      sym__function_content,
    STATE(257), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(1056), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8005] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(237), 1,
      sym__function_content,
    STATE(258), 1,
      sym_line_comment,
    ACTIONS(617), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(615), 23,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_LBRACK,
      anon_sym_DASH_GT,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [8057] = 29,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1016), 1,
      sym_identifier,
    ACTIONS(1018), 1,
      anon_sym_EQ,
    ACTIONS(1020), 1,
      anon_sym_LPAREN,
    ACTIONS(1022), 1,
      anon_sym_DOT,
    ACTIONS(1024), 1,
      anon_sym_LBRACE,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(1054), 1,
      anon_sym_QMARK,
    STATE(112), 1,
      sym__function_content,
    STATE(117), 1,
      sym_function_block,
    STATE(259), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(1056), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8155] = 29,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1016), 1,
      sym_identifier,
    ACTIONS(1018), 1,
      anon_sym_EQ,
    ACTIONS(1020), 1,
      anon_sym_LPAREN,
    ACTIONS(1022), 1,
      anon_sym_DOT,
    ACTIONS(1024), 1,
      anon_sym_LBRACE,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(1054), 1,
      anon_sym_QMARK,
    STATE(111), 1,
      sym_function_block,
    STATE(112), 1,
      sym__function_content,
    STATE(260), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(1056), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8253] = 29,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1018), 1,
      anon_sym_EQ,
    ACTIONS(1022), 1,
      anon_sym_DOT,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(1054), 1,
      anon_sym_QMARK,
    ACTIONS(1058), 1,
      sym_identifier,
    ACTIONS(1060), 1,
      anon_sym_LPAREN,
    ACTIONS(1062), 1,
      anon_sym_LBRACE,
    STATE(137), 1,
      sym_function_block,
    STATE(144), 1,
      sym__function_content,
    STATE(261), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(1056), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8351] = 29,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1016), 1,
      sym_identifier,
    ACTIONS(1018), 1,
      anon_sym_EQ,
    ACTIONS(1020), 1,
      anon_sym_LPAREN,
    ACTIONS(1022), 1,
      anon_sym_DOT,
    ACTIONS(1024), 1,
      anon_sym_LBRACE,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(1054), 1,
      anon_sym_QMARK,
    STATE(112), 1,
      sym__function_content,
    STATE(116), 1,
      sym_function_block,
    STATE(262), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(1056), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8449] = 26,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1066), 1,
      anon_sym_BANG,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(263), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1064), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8540] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1072), 1,
      anon_sym_LPAREN,
    STATE(264), 1,
      sym_line_comment,
    ACTIONS(1070), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(1068), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [8591] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(265), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(1074), 4,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
  [8680] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1080), 1,
      anon_sym_LPAREN,
    STATE(266), 1,
      sym_line_comment,
    ACTIONS(1078), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(1076), 22,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [8731] = 27,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1066), 1,
      anon_sym_BANG,
    ACTIONS(1082), 1,
      anon_sym_COMMA,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(267), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    ACTIONS(1064), 2,
      anon_sym_SEMI,
      anon_sym_RPAREN,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8824] = 27,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1084), 1,
      anon_sym_COMMA,
    ACTIONS(1086), 1,
      anon_sym_RBRACK,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(268), 1,
      sym_line_comment,
    STATE(498), 1,
      aux_sym__collection_sequence_repeat1,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [8916] = 9,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(701), 1,
      anon_sym_if,
    ACTIONS(1088), 1,
      sym_identifier,
    ACTIONS(1090), 1,
      anon_sym__,
    STATE(205), 1,
      sym__function_content,
    STATE(269), 1,
      sym_line_comment,
    ACTIONS(697), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(693), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [8972] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(270), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 7,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(843), 11,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9042] = 20,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(271), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 4,
      anon_sym_EQ,
      anon_sym_DOT,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(843), 6,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9120] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1012), 1,
      anon_sym_LPAREN,
    ACTIONS(1014), 1,
      anon_sym_LBRACK,
    STATE(272), 1,
      sym_line_comment,
    ACTIONS(1074), 4,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
    ACTIONS(514), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 17,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9174] = 9,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1012), 1,
      anon_sym_LPAREN,
    ACTIONS(1014), 1,
      anon_sym_LBRACK,
    ACTIONS(1092), 1,
      anon_sym_LBRACE,
    ACTIONS(1094), 1,
      anon_sym_COLON,
    STATE(273), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 18,
      anon_sym_SEMI,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9230] = 15,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(274), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 8,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(843), 11,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9298] = 27,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1096), 1,
      anon_sym_SEMI,
    ACTIONS(1098), 1,
      anon_sym_COMMA,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(275), 1,
      sym_line_comment,
    STATE(495), 1,
      aux_sym_class_def_repeat1,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9390] = 14,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(276), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 8,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_AMP,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(843), 13,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9456] = 27,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1098), 1,
      anon_sym_COMMA,
    ACTIONS(1100), 1,
      anon_sym_SEMI,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(277), 1,
      sym_line_comment,
    STATE(491), 1,
      aux_sym_class_def_repeat1,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9548] = 17,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(278), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 6,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_LT,
      anon_sym_GT,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(843), 11,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9620] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1102), 1,
      anon_sym_DOT,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    STATE(279), 2,
      sym_line_comment,
      aux_sym_function_call_repeat1,
    ACTIONS(903), 11,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(901), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9672] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(280), 1,
      sym_line_comment,
    ACTIONS(671), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(673), 21,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9720] = 26,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(883), 1,
      sym_identifier,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1018), 1,
      anon_sym_EQ,
    ACTIONS(1022), 1,
      anon_sym_DOT,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(1054), 1,
      anon_sym_QMARK,
    STATE(281), 1,
      sym_line_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    ACTIONS(881), 2,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(1056), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [9810] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1105), 1,
      anon_sym_COMMA,
    ACTIONS(1107), 1,
      anon_sym_pi,
    ACTIONS(1109), 1,
      anon_sym_DOT_DOT,
    STATE(282), 1,
      sym_line_comment,
    ACTIONS(747), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(749), 19,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9864] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(283), 1,
      sym_line_comment,
    ACTIONS(739), 13,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(741), 21,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      anon_sym_DOT_DOT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [9912] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(284), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1111), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10000] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1113), 1,
      anon_sym_DOT,
    STATE(279), 1,
      aux_sym_function_call_repeat1,
    STATE(285), 1,
      sym_line_comment,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(799), 11,
      anon_sym_EQ,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(797), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10054] = 22,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1022), 1,
      anon_sym_DOT,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    STATE(286), 1,
      sym_line_comment,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 3,
      anon_sym_EQ,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(843), 5,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10136] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    STATE(287), 1,
      sym_line_comment,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(843), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10188] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(288), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1115), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10276] = 19,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    STATE(289), 1,
      sym_line_comment,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 4,
      anon_sym_EQ,
      anon_sym_DOT,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(843), 7,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10352] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(290), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(1117), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10440] = 12,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    STATE(291), 1,
      sym_line_comment,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 10,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_AMP,
      anon_sym_DASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(843), 14,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10502] = 22,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1022), 1,
      anon_sym_DOT,
    ACTIONS(1026), 1,
      anon_sym_PIPE,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1038), 1,
      anon_sym_AMP_AMP,
    ACTIONS(1040), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(1042), 1,
      anon_sym_AMP,
    ACTIONS(1048), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    STATE(292), 1,
      sym_line_comment,
    ACTIONS(1028), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(1030), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(1032), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(1046), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(1050), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(895), 3,
      anon_sym_EQ,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(1044), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
    ACTIONS(893), 5,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10584] = 9,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    STATE(293), 1,
      sym_line_comment,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(779), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(777), 17,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10640] = 10,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1034), 1,
      anon_sym_DASH_GT,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(1052), 1,
      anon_sym_PLUS_SLASH_PLUS,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    STATE(294), 1,
      sym_line_comment,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(843), 16,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10698] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1036), 1,
      aux_sym_binary_expression_token1,
    STATE(285), 1,
      aux_sym_function_call_repeat1,
    STATE(295), 1,
      sym_line_comment,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(845), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(843), 18,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10752] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1088), 1,
      sym_identifier,
    ACTIONS(1090), 1,
      anon_sym__,
    STATE(205), 1,
      sym__function_content,
    STATE(296), 1,
      sym_line_comment,
    ACTIONS(697), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(693), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10805] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(297), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    ACTIONS(1119), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [10892] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(108), 1,
      sym_function_block,
    STATE(112), 1,
      sym__function_content,
    STATE(298), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(512), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [10943] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(299), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    ACTIONS(1121), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11030] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(300), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    ACTIONS(1123), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11117] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(112), 1,
      sym__function_content,
    STATE(117), 1,
      sym_function_block,
    STATE(301), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(512), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [11168] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(111), 1,
      sym_function_block,
    STATE(112), 1,
      sym__function_content,
    STATE(302), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(512), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [11219] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(303), 1,
      sym_line_comment,
    ACTIONS(1125), 3,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    ACTIONS(514), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 18,
      anon_sym_SEMI,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [11268] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(304), 1,
      sym_line_comment,
    ACTIONS(737), 2,
      aux_sym_symbol_token1,
      sym_escape_sequence,
    ACTIONS(735), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(733), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [11317] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(137), 1,
      sym_function_block,
    STATE(144), 1,
      sym__function_content,
    STATE(305), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(512), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [11368] = 26,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1127), 1,
      anon_sym_RPAREN,
    ACTIONS(1129), 1,
      anon_sym_COMMA,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(306), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11457] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(307), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    ACTIONS(1131), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11544] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1133), 1,
      anon_sym__,
    STATE(235), 1,
      sym__function_content,
    STATE(308), 1,
      sym_line_comment,
    ACTIONS(727), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(723), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [11595] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(112), 1,
      sym__function_content,
    STATE(116), 1,
      sym_function_block,
    STATE(309), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(512), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [11646] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(310), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    ACTIONS(1135), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11733] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(311), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 20,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [11779] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1137), 1,
      anon_sym_COMMA,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(312), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11865] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1014), 1,
      anon_sym_LBRACK,
    STATE(313), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(512), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [11913] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1139), 1,
      anon_sym_COMMA,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(314), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [11999] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1141), 1,
      anon_sym_COMMA,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(315), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12085] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1143), 1,
      anon_sym_COMMA,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(316), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12171] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(317), 1,
      sym_line_comment,
    ACTIONS(514), 12,
      anon_sym_BANG,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 20,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12217] = 25,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    ACTIONS(1145), 1,
      anon_sym_COMMA,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(318), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12303] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(319), 1,
      sym_line_comment,
    ACTIONS(514), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 21,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12349] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(320), 1,
      sym_line_comment,
    ACTIONS(1147), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
    ACTIONS(514), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 18,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12397] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1107), 1,
      anon_sym_pi,
    ACTIONS(1149), 1,
      anon_sym_COMMA,
    ACTIONS(1151), 1,
      anon_sym_DOT_DOT,
    STATE(321), 1,
      sym_line_comment,
    ACTIONS(747), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(749), 17,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12448] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(743), 1,
      anon_sym_EQ,
    ACTIONS(745), 1,
      anon_sym_COLON,
    STATE(322), 1,
      sym_line_comment,
    ACTIONS(747), 10,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(749), 19,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12497] = 24,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(781), 1,
      aux_sym_binary_expression_token1,
    ACTIONS(783), 1,
      anon_sym_PLUS_SLASH_PLUS,
    ACTIONS(847), 1,
      anon_sym_DOT,
    ACTIONS(849), 1,
      anon_sym_PIPE,
    ACTIONS(857), 1,
      anon_sym_DASH_GT,
    ACTIONS(859), 1,
      anon_sym_AMP_AMP,
    ACTIONS(861), 1,
      anon_sym_PIPE_PIPE,
    ACTIONS(863), 1,
      anon_sym_AMP,
    ACTIONS(869), 1,
      anon_sym_PLUS_PLUS,
    ACTIONS(885), 1,
      anon_sym_EQ,
    ACTIONS(887), 1,
      anon_sym_QMARK,
    ACTIONS(891), 1,
      anon_sym_DOTwhile,
    STATE(189), 1,
      aux_sym_function_call_repeat1,
    STATE(323), 1,
      sym_line_comment,
    ACTIONS(851), 2,
      anon_sym_LT,
      anon_sym_GT,
    ACTIONS(853), 2,
      anon_sym_PLUS,
      anon_sym_DASH,
    ACTIONS(855), 2,
      anon_sym_STAR,
      anon_sym_SLASH,
    ACTIONS(867), 2,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
    ACTIONS(871), 2,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
    ACTIONS(889), 2,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
    STATE(223), 2,
      sym_method_call,
      sym_instance_variable_setter_call,
    ACTIONS(865), 4,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
  [12580] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(324), 1,
      sym_line_comment,
    ACTIONS(1078), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(1076), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12625] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(325), 1,
      sym_line_comment,
    ACTIONS(1070), 12,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      sym_identifier,
      anon_sym_QMARK,
    ACTIONS(1068), 19,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12670] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1107), 1,
      anon_sym_pi,
    ACTIONS(1153), 1,
      anon_sym_COMMA,
    ACTIONS(1155), 1,
      anon_sym_DOT_DOT,
    STATE(326), 1,
      sym_line_comment,
    ACTIONS(747), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(749), 17,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12721] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(327), 1,
      sym_line_comment,
    ACTIONS(514), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 20,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12766] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(328), 1,
      sym_line_comment,
    ACTIONS(514), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 19,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12810] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(329), 1,
      sym_line_comment,
    ACTIONS(514), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 19,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12854] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(330), 1,
      sym_line_comment,
    ACTIONS(514), 11,
      anon_sym_EQ,
      anon_sym_DOT,
      anon_sym_PIPE,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_PLUS,
      anon_sym_STAR,
      anon_sym_AMP,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_QMARK,
    ACTIONS(512), 19,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DASH_GT,
      aux_sym_binary_expression_token1,
      anon_sym_AMP_AMP,
      anon_sym_PIPE_PIPE,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_PLUS_PLUS,
      anon_sym_PERCENT,
      anon_sym_STAR_STAR,
      anon_sym_PLUS_SLASH_PLUS,
      anon_sym_BANG_QMARK,
      anon_sym_QMARK_QMARK,
      anon_sym_DOTwhile,
  [12898] = 14,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(47), 1,
      aux_sym_environment_var_token1,
    ACTIONS(49), 1,
      anon_sym_TILDE,
    ACTIONS(679), 1,
      sym_identifier,
    STATE(331), 1,
      sym_line_comment,
    STATE(400), 1,
      sym_variable,
    STATE(448), 1,
      sym_variable_definition,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(156), 5,
      sym_builtin_var,
      sym_local_var,
      sym_instance_var,
      sym_classvar,
      sym_environment_var,
    ACTIONS(37), 9,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
  [12954] = 19,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      sym_char,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(57), 1,
      anon_sym_LBRACK,
    ACTIONS(687), 1,
      anon_sym_BSLASH,
    ACTIONS(1157), 1,
      anon_sym_LPAREN,
    ACTIONS(1161), 1,
      aux_sym_class_token1,
    STATE(229), 1,
      sym_arithmetic_series,
    STATE(332), 1,
      sym_line_comment,
    STATE(371), 1,
      sym_number,
    STATE(657), 1,
      sym_class,
    ACTIONS(55), 2,
      sym_ref,
      anon_sym_POUND,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(1159), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(436), 2,
      sym_literal,
      sym_collection,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
    STATE(192), 3,
      sym_symbol,
      sym_string,
      sym_bool,
  [13020] = 14,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(47), 1,
      aux_sym_environment_var_token1,
    ACTIONS(49), 1,
      anon_sym_TILDE,
    ACTIONS(679), 1,
      sym_identifier,
    STATE(333), 1,
      sym_line_comment,
    STATE(399), 1,
      sym_variable,
    STATE(446), 1,
      sym_variable_definition,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(156), 5,
      sym_builtin_var,
      sym_local_var,
      sym_instance_var,
      sym_classvar,
      sym_environment_var,
    ACTIONS(37), 9,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
  [13076] = 14,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(47), 1,
      aux_sym_environment_var_token1,
    ACTIONS(49), 1,
      anon_sym_TILDE,
    ACTIONS(679), 1,
      sym_identifier,
    STATE(334), 1,
      sym_line_comment,
    STATE(473), 1,
      sym_variable,
    STATE(486), 1,
      sym_variable_definition,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(156), 5,
      sym_builtin_var,
      sym_local_var,
      sym_instance_var,
      sym_classvar,
      sym_environment_var,
    ACTIONS(37), 9,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
  [13132] = 19,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1161), 1,
      aux_sym_class_token1,
    ACTIONS(1163), 1,
      anon_sym_LPAREN,
    ACTIONS(1165), 1,
      anon_sym_BSLASH,
    ACTIONS(1167), 1,
      anon_sym_SQUOTE,
    ACTIONS(1169), 1,
      sym_char,
    ACTIONS(1171), 1,
      anon_sym_DQUOTE,
    ACTIONS(1177), 1,
      anon_sym_LBRACK,
    STATE(335), 1,
      sym_line_comment,
    STATE(371), 1,
      sym_number,
    STATE(466), 1,
      sym_arithmetic_series,
    STATE(570), 1,
      sym_class,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(1173), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(1175), 2,
      sym_ref,
      anon_sym_POUND,
    STATE(436), 2,
      sym_literal,
      sym_collection,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
    STATE(461), 3,
      sym_symbol,
      sym_string,
      sym_bool,
  [13198] = 14,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(47), 1,
      aux_sym_environment_var_token1,
    ACTIONS(49), 1,
      anon_sym_TILDE,
    ACTIONS(679), 1,
      sym_identifier,
    STATE(336), 1,
      sym_line_comment,
    STATE(540), 1,
      sym_variable,
    STATE(614), 1,
      sym_variable_definition,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(156), 5,
      sym_builtin_var,
      sym_local_var,
      sym_instance_var,
      sym_classvar,
      sym_environment_var,
    ACTIONS(37), 9,
      anon_sym_inf,
      anon_sym_nil,
      anon_sym_thisFunction,
      anon_sym_thisFunctionDef,
      anon_sym_thisMethod,
      anon_sym_thisProcess,
      anon_sym_thisThread,
      anon_sym_currentEnvironment,
      anon_sym_topEnvironment,
  [13254] = 19,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1161), 1,
      aux_sym_class_token1,
    ACTIONS(1179), 1,
      anon_sym_LPAREN,
    ACTIONS(1185), 1,
      anon_sym_BSLASH,
    ACTIONS(1187), 1,
      anon_sym_SQUOTE,
    ACTIONS(1189), 1,
      sym_char,
    ACTIONS(1191), 1,
      anon_sym_DQUOTE,
    ACTIONS(1197), 1,
      anon_sym_LBRACK,
    STATE(337), 1,
      sym_line_comment,
    STATE(420), 1,
      sym_number,
    STATE(472), 1,
      sym_arithmetic_series,
    STATE(676), 1,
      sym_class,
    ACTIONS(1183), 2,
      sym_integer,
      sym_float,
    ACTIONS(1193), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(1195), 2,
      sym_ref,
      anon_sym_POUND,
    STATE(455), 2,
      sym_literal,
      sym_collection,
    ACTIONS(1181), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
    STATE(479), 3,
      sym_symbol,
      sym_string,
      sym_bool,
  [13320] = 13,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      sym_char,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(687), 1,
      anon_sym_BSLASH,
    STATE(338), 1,
      sym_line_comment,
    STATE(371), 1,
      sym_number,
    STATE(625), 1,
      sym_literal,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(1159), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
    STATE(192), 3,
      sym_symbol,
      sym_string,
      sym_bool,
  [13366] = 13,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(29), 1,
      anon_sym_SQUOTE,
    ACTIONS(31), 1,
      sym_char,
    ACTIONS(33), 1,
      anon_sym_DQUOTE,
    ACTIONS(687), 1,
      anon_sym_BSLASH,
    STATE(339), 1,
      sym_line_comment,
    STATE(371), 1,
      sym_number,
    STATE(612), 1,
      sym_literal,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(1159), 2,
      anon_sym_true,
      anon_sym_false,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
    STATE(192), 3,
      sym_symbol,
      sym_string,
      sym_bool,
  [13412] = 15,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1199), 1,
      sym_identifier,
    ACTIONS(1202), 1,
      anon_sym_SEMI,
    ACTIONS(1205), 1,
      anon_sym_RBRACE,
    ACTIONS(1207), 1,
      anon_sym_var,
    ACTIONS(1210), 1,
      anon_sym_LT,
    ACTIONS(1216), 1,
      anon_sym_classvar,
    ACTIONS(1219), 1,
      anon_sym_const,
    ACTIONS(1222), 1,
      anon_sym_STAR,
    STATE(437), 1,
      sym_local_var,
    STATE(594), 1,
      sym_const,
    ACTIONS(1213), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(340), 2,
      sym_line_comment,
      aux_sym_class_def_repeat2,
    STATE(426), 2,
      sym_instance_var,
      sym_classvar,
  [13461] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_SEMI,
    ACTIONS(1229), 1,
      anon_sym_RBRACE,
    ACTIONS(1231), 1,
      anon_sym_const,
    ACTIONS(1233), 1,
      anon_sym_STAR,
    STATE(340), 1,
      aux_sym_class_def_repeat2,
    STATE(341), 1,
      sym_line_comment,
    STATE(437), 1,
      sym_local_var,
    STATE(594), 1,
      sym_const,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(426), 2,
      sym_instance_var,
      sym_classvar,
  [13512] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_SEMI,
    ACTIONS(1231), 1,
      anon_sym_const,
    ACTIONS(1233), 1,
      anon_sym_STAR,
    ACTIONS(1235), 1,
      anon_sym_RBRACE,
    STATE(342), 1,
      sym_line_comment,
    STATE(344), 1,
      aux_sym_class_def_repeat2,
    STATE(437), 1,
      sym_local_var,
    STATE(594), 1,
      sym_const,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(426), 2,
      sym_instance_var,
      sym_classvar,
  [13563] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_SEMI,
    ACTIONS(1231), 1,
      anon_sym_const,
    ACTIONS(1233), 1,
      anon_sym_STAR,
    ACTIONS(1237), 1,
      anon_sym_RBRACE,
    STATE(343), 1,
      sym_line_comment,
    STATE(345), 1,
      aux_sym_class_def_repeat2,
    STATE(437), 1,
      sym_local_var,
    STATE(594), 1,
      sym_const,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(426), 2,
      sym_instance_var,
      sym_classvar,
  [13614] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_SEMI,
    ACTIONS(1231), 1,
      anon_sym_const,
    ACTIONS(1233), 1,
      anon_sym_STAR,
    ACTIONS(1239), 1,
      anon_sym_RBRACE,
    STATE(340), 1,
      aux_sym_class_def_repeat2,
    STATE(344), 1,
      sym_line_comment,
    STATE(437), 1,
      sym_local_var,
    STATE(594), 1,
      sym_const,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(426), 2,
      sym_instance_var,
      sym_classvar,
  [13665] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_SEMI,
    ACTIONS(1231), 1,
      anon_sym_const,
    ACTIONS(1233), 1,
      anon_sym_STAR,
    ACTIONS(1241), 1,
      anon_sym_RBRACE,
    STATE(340), 1,
      aux_sym_class_def_repeat2,
    STATE(345), 1,
      sym_line_comment,
    STATE(437), 1,
      sym_local_var,
    STATE(594), 1,
      sym_const,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(426), 2,
      sym_instance_var,
      sym_classvar,
  [13716] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_SEMI,
    ACTIONS(1229), 1,
      anon_sym_RBRACE,
    ACTIONS(1231), 1,
      anon_sym_const,
    ACTIONS(1233), 1,
      anon_sym_STAR,
    STATE(346), 1,
      sym_line_comment,
    STATE(348), 1,
      aux_sym_class_def_repeat2,
    STATE(437), 1,
      sym_local_var,
    STATE(594), 1,
      sym_const,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(426), 2,
      sym_instance_var,
      sym_classvar,
  [13767] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_SEMI,
    ACTIONS(1231), 1,
      anon_sym_const,
    ACTIONS(1233), 1,
      anon_sym_STAR,
    ACTIONS(1243), 1,
      anon_sym_RBRACE,
    STATE(341), 1,
      aux_sym_class_def_repeat2,
    STATE(347), 1,
      sym_line_comment,
    STATE(437), 1,
      sym_local_var,
    STATE(594), 1,
      sym_const,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(426), 2,
      sym_instance_var,
      sym_classvar,
  [13818] = 16,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(1225), 1,
      sym_identifier,
    ACTIONS(1227), 1,
      anon_sym_SEMI,
    ACTIONS(1231), 1,
      anon_sym_const,
    ACTIONS(1233), 1,
      anon_sym_STAR,
    ACTIONS(1245), 1,
      anon_sym_RBRACE,
    STATE(340), 1,
      aux_sym_class_def_repeat2,
    STATE(348), 1,
      sym_line_comment,
    STATE(437), 1,
      sym_local_var,
    STATE(594), 1,
      sym_const,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(426), 2,
      sym_instance_var,
      sym_classvar,
  [13869] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(349), 1,
      sym_line_comment,
    ACTIONS(462), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(464), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [13895] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(350), 1,
      sym_line_comment,
    ACTIONS(500), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(502), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [13921] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(351), 1,
      sym_line_comment,
    ACTIONS(466), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(468), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [13947] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(352), 1,
      sym_line_comment,
    ACTIONS(485), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(487), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [13973] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(353), 1,
      sym_line_comment,
    ACTIONS(458), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(460), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [13999] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(354), 1,
      sym_line_comment,
    ACTIONS(489), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(491), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14025] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(355), 1,
      sym_line_comment,
    ACTIONS(470), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(472), 7,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14051] = 12,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(39), 1,
      anon_sym_var,
    ACTIONS(41), 1,
      anon_sym_LT,
    ACTIONS(45), 1,
      anon_sym_classvar,
    ACTIONS(679), 1,
      sym_identifier,
    ACTIONS(1231), 1,
      anon_sym_const,
    STATE(356), 1,
      sym_line_comment,
    STATE(483), 1,
      sym_local_var,
    STATE(623), 1,
      sym_const,
    ACTIONS(43), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
    STATE(485), 2,
      sym_instance_var,
      sym_classvar,
  [14090] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(357), 1,
      sym_line_comment,
    ACTIONS(1247), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1249), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14114] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(358), 1,
      sym_line_comment,
    ACTIONS(1251), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1253), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14138] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(359), 1,
      sym_line_comment,
    ACTIONS(1255), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1257), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14162] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(360), 1,
      sym_line_comment,
    ACTIONS(1259), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1261), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14186] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(361), 1,
      sym_line_comment,
    ACTIONS(1263), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1265), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14210] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(362), 1,
      sym_line_comment,
    ACTIONS(1205), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
    ACTIONS(1267), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
  [14234] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(363), 1,
      sym_line_comment,
    ACTIONS(1269), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1271), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14258] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(364), 1,
      sym_line_comment,
    ACTIONS(1273), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1275), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14282] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(365), 1,
      sym_line_comment,
    ACTIONS(1277), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1279), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14306] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(366), 1,
      sym_line_comment,
    ACTIONS(1281), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1283), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14330] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(367), 1,
      sym_line_comment,
    ACTIONS(1285), 5,
      anon_sym_var,
      anon_sym_LT,
      anon_sym_classvar,
      anon_sym_const,
      sym_identifier,
    ACTIONS(1287), 5,
      anon_sym_SEMI,
      anon_sym_RBRACE,
      anon_sym_GT,
      anon_sym_LT_GT,
      anon_sym_STAR,
  [14354] = 9,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1293), 1,
      anon_sym_LBRACE,
    STATE(350), 1,
      sym__function_content,
    STATE(360), 1,
      sym_function_block,
    STATE(368), 1,
      sym_line_comment,
    ACTIONS(615), 3,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_COMMA,
  [14384] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(739), 1,
      anon_sym_DOT_DOT,
    STATE(369), 1,
      sym_line_comment,
    ACTIONS(741), 7,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
      anon_sym_RBRACK,
  [14406] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(671), 1,
      anon_sym_DOT_DOT,
    STATE(370), 1,
      sym_line_comment,
    ACTIONS(673), 7,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
      anon_sym_RBRACK,
  [14428] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    STATE(371), 1,
      sym_line_comment,
    ACTIONS(749), 6,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
      anon_sym_RBRACK,
  [14449] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(372), 1,
      sym_line_comment,
    ACTIONS(1297), 3,
      aux_sym_symbol_token1,
      sym_escape_sequence,
      sym_identifier,
    ACTIONS(733), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [14470] = 9,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1299), 1,
      sym_identifier,
    ACTIONS(1302), 1,
      anon_sym_SEMI,
    ACTIONS(1304), 1,
      anon_sym_LPAREN,
    ACTIONS(1307), 1,
      anon_sym_LBRACE,
    STATE(350), 1,
      sym__function_content,
    STATE(478), 1,
      sym_function_block,
    STATE(373), 2,
      sym_line_comment,
      aux_sym_case_repeat1,
  [14499] = 7,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(733), 1,
      anon_sym_,
    ACTIONS(1312), 1,
      sym_escape_sequence,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(374), 1,
      sym_line_comment,
    ACTIONS(1310), 2,
      aux_sym_symbol_token1,
      sym_identifier,
    ACTIONS(735), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [14524] = 10,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1293), 1,
      anon_sym_LBRACE,
    ACTIONS(1316), 1,
      anon_sym_SEMI,
    STATE(350), 1,
      sym__function_content,
    STATE(375), 1,
      sym_line_comment,
    STATE(376), 1,
      aux_sym_case_repeat1,
    STATE(478), 1,
      sym_function_block,
  [14555] = 10,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1293), 1,
      anon_sym_LBRACE,
    ACTIONS(1318), 1,
      anon_sym_SEMI,
    STATE(350), 1,
      sym__function_content,
    STATE(373), 1,
      aux_sym_case_repeat1,
    STATE(376), 1,
      sym_line_comment,
    STATE(478), 1,
      sym_function_block,
  [14586] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(593), 1,
      anon_sym_LBRACK,
    STATE(153), 1,
      sym__index,
    STATE(377), 1,
      sym_line_comment,
    STATE(385), 1,
      aux_sym_indexed_collection_repeat1,
    ACTIONS(595), 3,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
  [14610] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(378), 1,
      sym_line_comment,
    ACTIONS(733), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(737), 3,
      aux_sym_symbol_token1,
      sym_escape_sequence,
      sym_identifier,
  [14630] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(379), 1,
      sym_line_comment,
    STATE(528), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14652] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(380), 1,
      sym_line_comment,
    STATE(534), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14674] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(381), 1,
      sym_line_comment,
    STATE(515), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14696] = 7,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1320), 1,
      anon_sym_EQ,
    ACTIONS(1322), 1,
      anon_sym_LPAREN,
    ACTIONS(1326), 1,
      anon_sym_,
    STATE(382), 1,
      sym_line_comment,
    ACTIONS(1324), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [14720] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(383), 1,
      sym_line_comment,
    STATE(558), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14742] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(384), 1,
      sym_line_comment,
    STATE(556), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14764] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1328), 1,
      anon_sym_LBRACK,
    STATE(449), 1,
      sym__index,
    STATE(385), 2,
      sym_line_comment,
      aux_sym_indexed_collection_repeat1,
    ACTIONS(1331), 3,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
  [14786] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(386), 1,
      sym_line_comment,
    STATE(531), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14808] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(387), 1,
      sym_line_comment,
    STATE(551), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14830] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1334), 1,
      anon_sym_EQ,
    ACTIONS(1336), 1,
      anon_sym_LPAREN,
    STATE(388), 1,
      sym_line_comment,
    ACTIONS(1326), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [14852] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(389), 1,
      sym_line_comment,
    STATE(533), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14874] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(390), 1,
      sym_line_comment,
    ACTIONS(615), 6,
      anon_sym_SEMI,
      anon_sym_EQ,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [14892] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(391), 1,
      sym_line_comment,
    STATE(541), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14914] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(392), 1,
      sym_line_comment,
    STATE(532), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14936] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(393), 1,
      sym_line_comment,
    STATE(517), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14958] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(394), 1,
      sym_line_comment,
    STATE(538), 1,
      sym_number,
    ACTIONS(681), 2,
      sym_integer,
      sym_float,
    ACTIONS(685), 3,
      anon_sym_pi,
      sym_hexinteger,
      sym_exponential,
  [14980] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(395), 1,
      sym_line_comment,
    STATE(681), 1,
      sym_function_block,
  [15005] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(396), 1,
      sym_line_comment,
    STATE(665), 1,
      sym_function_block,
  [15030] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(397), 1,
      sym_line_comment,
    STATE(524), 1,
      sym_function_block,
  [15055] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(1338), 1,
      sym_identifier,
    ACTIONS(1340), 1,
      anon_sym_LPAREN,
    STATE(179), 1,
      sym_function_block,
    STATE(249), 1,
      sym__function_content,
    STATE(398), 1,
      sym_line_comment,
  [15080] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1344), 1,
      anon_sym_EQ,
    ACTIONS(1346), 1,
      anon_sym_COMMA,
    STATE(399), 1,
      sym_line_comment,
    ACTIONS(1342), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [15101] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1344), 1,
      anon_sym_EQ,
    ACTIONS(1346), 1,
      anon_sym_COMMA,
    STATE(400), 1,
      sym_line_comment,
    ACTIONS(1348), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [15122] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(401), 1,
      sym_line_comment,
    STATE(643), 1,
      sym_function_block,
  [15147] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(402), 1,
      sym_line_comment,
    STATE(519), 1,
      sym_function_block,
  [15172] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(403), 1,
      sym_line_comment,
    STATE(644), 1,
      sym_function_block,
  [15197] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1289), 1,
      sym_identifier,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1293), 1,
      anon_sym_LBRACE,
    STATE(350), 1,
      sym__function_content,
    STATE(364), 1,
      sym_function_block,
    STATE(404), 1,
      sym_line_comment,
  [15222] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(99), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(405), 1,
      sym_line_comment,
    STATE(542), 1,
      sym_function_block,
  [15247] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(406), 1,
      sym_line_comment,
    STATE(518), 1,
      sym_function_block,
  [15272] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(407), 1,
      sym_line_comment,
    STATE(651), 1,
      sym_function_block,
  [15297] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(669), 1,
      anon_sym_COMMA,
    STATE(408), 1,
      sym_line_comment,
    STATE(527), 1,
      aux_sym_variable_definition_sequence_repeat1,
    ACTIONS(1064), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [15318] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(409), 1,
      sym_line_comment,
    STATE(565), 1,
      sym_function_block,
  [15343] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(410), 1,
      sym_line_comment,
    STATE(549), 1,
      sym_function_block,
  [15368] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(169), 1,
      sym_function_block,
    STATE(249), 1,
      sym__function_content,
    STATE(411), 1,
      sym_line_comment,
  [15393] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(412), 1,
      sym_line_comment,
    STATE(603), 1,
      sym_function_block,
  [15418] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(413), 1,
      sym_line_comment,
    STATE(671), 1,
      sym_function_block,
  [15443] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(414), 1,
      sym_line_comment,
    STATE(677), 1,
      sym_function_block,
  [15468] = 8,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1350), 1,
      anon_sym_COMMA,
    ACTIONS(1352), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1354), 1,
      anon_sym_PIPE,
    ACTIONS(1356), 1,
      anon_sym_,
    STATE(415), 1,
      sym_line_comment,
    STATE(422), 1,
      aux_sym_parameter_list_repeat2,
  [15493] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(218), 1,
      sym_function_block,
    STATE(249), 1,
      sym__function_content,
    STATE(416), 1,
      sym_line_comment,
  [15518] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(417), 1,
      sym_line_comment,
    STATE(521), 1,
      sym_function_block,
  [15543] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(673), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(418), 1,
      sym_line_comment,
    ACTIONS(671), 4,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
  [15562] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(419), 1,
      sym_line_comment,
    STATE(608), 1,
      sym_function_block,
  [15587] = 6,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(749), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1358), 1,
      anon_sym_pi,
    STATE(420), 1,
      sym_line_comment,
    ACTIONS(747), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [15608] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(421), 1,
      sym_line_comment,
    STATE(634), 1,
      sym_function_block,
  [15633] = 8,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1350), 1,
      anon_sym_COMMA,
    ACTIONS(1356), 1,
      anon_sym_,
    ACTIONS(1360), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1362), 1,
      anon_sym_PIPE,
    STATE(422), 1,
      sym_line_comment,
    STATE(424), 1,
      aux_sym_parameter_list_repeat2,
  [15658] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(741), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(423), 1,
      sym_line_comment,
    ACTIONS(739), 4,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
      anon_sym_pi,
  [15677] = 6,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1364), 1,
      anon_sym_COMMA,
    ACTIONS(1369), 1,
      anon_sym_,
    ACTIONS(1367), 2,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
    STATE(424), 2,
      sym_line_comment,
      aux_sym_parameter_list_repeat2,
  [15698] = 8,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    ACTIONS(1338), 1,
      sym_identifier,
    STATE(249), 1,
      sym__function_content,
    STATE(425), 1,
      sym_line_comment,
    STATE(597), 1,
      sym_function_block,
  [15723] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1098), 1,
      anon_sym_COMMA,
    ACTIONS(1372), 1,
      anon_sym_SEMI,
    ACTIONS(1374), 1,
      anon_sym_EQ,
    STATE(426), 1,
      sym_line_comment,
    STATE(482), 1,
      aux_sym_class_def_repeat1,
  [15745] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1376), 1,
      sym_identifier,
    ACTIONS(1378), 1,
      anon_sym_DOT_DOT_DOT,
    ACTIONS(1380), 1,
      anon_sym_PIPE,
    STATE(415), 1,
      sym_argument,
    STATE(427), 1,
      sym_line_comment,
  [15767] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(809), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(428), 1,
      sym_line_comment,
    ACTIONS(807), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [15785] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(429), 1,
      sym_line_comment,
    ACTIONS(994), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [15801] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(430), 1,
      sym_line_comment,
    ACTIONS(930), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [15817] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(717), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(431), 1,
      sym_line_comment,
    ACTIONS(715), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [15835] = 7,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1382), 1,
      anon_sym_DQUOTE,
    ACTIONS(1384), 1,
      aux_sym_string_token1,
    ACTIONS(1386), 1,
      sym_escape_sequence,
    STATE(432), 1,
      sym_line_comment,
    STATE(433), 1,
      aux_sym_string_repeat1,
  [15857] = 7,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1384), 1,
      aux_sym_string_token1,
    ACTIONS(1386), 1,
      sym_escape_sequence,
    ACTIONS(1388), 1,
      anon_sym_DQUOTE,
    STATE(433), 1,
      sym_line_comment,
    STATE(456), 1,
      aux_sym_string_repeat1,
  [15879] = 7,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1384), 1,
      aux_sym_string_token1,
    ACTIONS(1386), 1,
      sym_escape_sequence,
    ACTIONS(1390), 1,
      anon_sym_DQUOTE,
    STATE(434), 1,
      sym_line_comment,
    STATE(476), 1,
      aux_sym_string_repeat1,
  [15901] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(875), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(435), 1,
      sym_line_comment,
    ACTIONS(873), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [15919] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(436), 1,
      sym_line_comment,
    ACTIONS(1392), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [15935] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1098), 1,
      anon_sym_COMMA,
    ACTIONS(1394), 1,
      anon_sym_SEMI,
    ACTIONS(1396), 1,
      anon_sym_EQ,
    STATE(437), 1,
      sym_line_comment,
    STATE(497), 1,
      aux_sym_class_def_repeat1,
  [15957] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1398), 1,
      sym_identifier,
    ACTIONS(1400), 1,
      anon_sym_LT,
    STATE(438), 1,
      sym_line_comment,
    ACTIONS(1402), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
  [15977] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1404), 1,
      sym_identifier,
    ACTIONS(1406), 1,
      anon_sym_LT,
    STATE(439), 1,
      sym_line_comment,
    ACTIONS(1408), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
  [15997] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1410), 1,
      sym_identifier,
    ACTIONS(1412), 1,
      anon_sym_LT,
    STATE(440), 1,
      sym_line_comment,
    ACTIONS(1414), 2,
      anon_sym_GT,
      anon_sym_LT_GT,
  [16017] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(787), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(441), 1,
      sym_line_comment,
    ACTIONS(785), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16035] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(829), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(442), 1,
      sym_line_comment,
    ACTIONS(827), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16053] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(837), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(443), 1,
      sym_line_comment,
    ACTIONS(835), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16071] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1418), 1,
      anon_sym_COMMA,
    ACTIONS(1416), 2,
      anon_sym_SEMI,
      anon_sym_DOT_DOT_DOT,
    STATE(444), 2,
      sym_line_comment,
      aux_sym_parameter_list_repeat1,
  [16089] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(914), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(445), 1,
      sym_line_comment,
    ACTIONS(912), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16107] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1346), 1,
      anon_sym_COMMA,
    STATE(446), 1,
      sym_line_comment,
    ACTIONS(1342), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [16125] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(930), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(447), 1,
      sym_line_comment,
    ACTIONS(928), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16143] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1346), 1,
      anon_sym_COMMA,
    STATE(448), 1,
      sym_line_comment,
    ACTIONS(1348), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [16161] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(449), 1,
      sym_line_comment,
    ACTIONS(605), 4,
      anon_sym_LBRACK,
      anon_sym_PIPE_AT_PIPE,
      anon_sym_AT_AT,
      anon_sym_AT_PIPE_AT,
  [16177] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(994), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(450), 1,
      sym_line_comment,
    ACTIONS(992), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16195] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1421), 1,
      anon_sym_,
    STATE(451), 1,
      sym_line_comment,
    ACTIONS(1367), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16213] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(452), 1,
      sym_line_comment,
    ACTIONS(914), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16229] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(453), 1,
      sym_line_comment,
    ACTIONS(837), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16245] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(841), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(454), 1,
      sym_line_comment,
    ACTIONS(839), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16263] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1392), 1,
      anon_sym_,
    STATE(455), 1,
      sym_line_comment,
    ACTIONS(1423), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16281] = 6,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1425), 1,
      anon_sym_DQUOTE,
    ACTIONS(1427), 1,
      aux_sym_string_token1,
    ACTIONS(1430), 1,
      sym_escape_sequence,
    STATE(456), 2,
      sym_line_comment,
      aux_sym_string_repeat1,
  [16301] = 7,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1384), 1,
      aux_sym_string_token1,
    ACTIONS(1386), 1,
      sym_escape_sequence,
    ACTIONS(1433), 1,
      anon_sym_DQUOTE,
    STATE(457), 1,
      sym_line_comment,
    STATE(463), 1,
      aux_sym_string_repeat1,
  [16323] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(458), 1,
      sym_line_comment,
    ACTIONS(1435), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16339] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1437), 1,
      anon_sym_SEMI,
    ACTIONS(1439), 1,
      anon_sym_COMMA,
    ACTIONS(1441), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(459), 1,
      sym_line_comment,
    STATE(474), 1,
      aux_sym_parameter_list_repeat1,
  [16361] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(460), 1,
      sym_line_comment,
    ACTIONS(787), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16377] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(461), 1,
      sym_line_comment,
    ACTIONS(749), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16393] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(462), 1,
      sym_line_comment,
    ACTIONS(813), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16409] = 7,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1384), 1,
      aux_sym_string_token1,
    ACTIONS(1386), 1,
      sym_escape_sequence,
    ACTIONS(1443), 1,
      anon_sym_DQUOTE,
    STATE(456), 1,
      aux_sym_string_repeat1,
    STATE(463), 1,
      sym_line_comment,
  [16431] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(721), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(464), 1,
      sym_line_comment,
    ACTIONS(719), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16449] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1380), 1,
      anon_sym_SEMI,
    ACTIONS(1445), 1,
      sym_identifier,
    ACTIONS(1447), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(459), 1,
      sym_argument,
    STATE(465), 1,
      sym_line_comment,
  [16471] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(466), 1,
      sym_line_comment,
    ACTIONS(934), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16487] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(467), 1,
      sym_line_comment,
    ACTIONS(875), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16503] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(468), 1,
      sym_line_comment,
    ACTIONS(717), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16519] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(469), 1,
      sym_line_comment,
    ACTIONS(829), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16535] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(470), 1,
      sym_line_comment,
    ACTIONS(721), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16551] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(471), 1,
      sym_line_comment,
    ACTIONS(841), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16567] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(934), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(472), 1,
      sym_line_comment,
    ACTIONS(932), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16585] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1344), 1,
      anon_sym_EQ,
    STATE(473), 1,
      sym_line_comment,
    ACTIONS(1449), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [16603] = 7,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1439), 1,
      anon_sym_COMMA,
    ACTIONS(1451), 1,
      anon_sym_SEMI,
    ACTIONS(1453), 1,
      anon_sym_DOT_DOT_DOT,
    STATE(444), 1,
      aux_sym_parameter_list_repeat1,
    STATE(474), 1,
      sym_line_comment,
  [16625] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(813), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(475), 1,
      sym_line_comment,
    ACTIONS(811), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16643] = 7,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1384), 1,
      aux_sym_string_token1,
    ACTIONS(1386), 1,
      sym_escape_sequence,
    ACTIONS(1455), 1,
      anon_sym_DQUOTE,
    STATE(456), 1,
      aux_sym_string_repeat1,
    STATE(476), 1,
      sym_line_comment,
  [16665] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1435), 1,
      anon_sym_,
    STATE(477), 1,
      sym_line_comment,
    ACTIONS(1457), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16683] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(478), 1,
      sym_line_comment,
    ACTIONS(1459), 4,
      anon_sym_SEMI,
      anon_sym_LPAREN,
      anon_sym_LBRACE,
      sym_identifier,
  [16699] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(749), 1,
      anon_sym_,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    STATE(479), 1,
      sym_line_comment,
    ACTIONS(747), 3,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16717] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(480), 1,
      sym_line_comment,
    ACTIONS(809), 4,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
      anon_sym_PIPE,
  [16733] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1461), 1,
      anon_sym_RPAREN,
    ACTIONS(1463), 1,
      anon_sym_COMMA,
    STATE(481), 1,
      sym_line_comment,
    STATE(493), 1,
      aux_sym__paired_associative_sequence_repeat1,
  [16752] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1098), 1,
      anon_sym_COMMA,
    ACTIONS(1465), 1,
      anon_sym_SEMI,
    STATE(482), 1,
      sym_line_comment,
    STATE(489), 1,
      aux_sym_class_def_repeat1,
  [16771] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1469), 1,
      anon_sym_EQ,
    STATE(483), 1,
      sym_line_comment,
    ACTIONS(1467), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [16788] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1473), 1,
      aux_sym_string_token1,
    STATE(484), 1,
      sym_line_comment,
    ACTIONS(1471), 2,
      anon_sym_DQUOTE,
      sym_escape_sequence,
  [16805] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1477), 1,
      anon_sym_EQ,
    STATE(485), 1,
      sym_line_comment,
    ACTIONS(1475), 2,
      anon_sym_SEMI,
      anon_sym_COMMA,
  [16822] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(486), 1,
      sym_line_comment,
    ACTIONS(1449), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [16837] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1060), 1,
      anon_sym_LPAREN,
    ACTIONS(1062), 1,
      anon_sym_LBRACE,
    STATE(136), 1,
      sym__function_content,
    STATE(487), 1,
      sym_line_comment,
  [16856] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1020), 1,
      anon_sym_LPAREN,
    ACTIONS(1024), 1,
      anon_sym_LBRACE,
    STATE(106), 1,
      sym__function_content,
    STATE(488), 1,
      sym_line_comment,
  [16875] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1475), 1,
      anon_sym_SEMI,
    ACTIONS(1479), 1,
      anon_sym_COMMA,
    STATE(489), 2,
      sym_line_comment,
      aux_sym_class_def_repeat1,
  [16892] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1482), 1,
      anon_sym_RPAREN,
    ACTIONS(1484), 1,
      anon_sym_COMMA,
    STATE(490), 2,
      sym_line_comment,
      aux_sym_parameter_call_list_repeat1,
  [16909] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1098), 1,
      anon_sym_COMMA,
    ACTIONS(1487), 1,
      anon_sym_SEMI,
    STATE(489), 1,
      aux_sym_class_def_repeat1,
    STATE(491), 1,
      sym_line_comment,
  [16928] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1489), 1,
      anon_sym_SEMI,
    STATE(492), 1,
      sym_line_comment,
    ACTIONS(559), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [16945] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(348), 1,
      anon_sym_RPAREN,
    ACTIONS(1491), 1,
      anon_sym_COMMA,
    STATE(493), 1,
      sym_line_comment,
    STATE(510), 1,
      aux_sym__paired_associative_sequence_repeat1,
  [16964] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1493), 1,
      anon_sym_SEMI,
    STATE(494), 1,
      sym_line_comment,
    ACTIONS(1495), 2,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [16981] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1098), 1,
      anon_sym_COMMA,
    ACTIONS(1497), 1,
      anon_sym_SEMI,
    STATE(489), 1,
      aux_sym_class_def_repeat1,
    STATE(495), 1,
      sym_line_comment,
  [17000] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1291), 1,
      anon_sym_LPAREN,
    ACTIONS(1293), 1,
      anon_sym_LBRACE,
    STATE(351), 1,
      sym__function_content,
    STATE(496), 1,
      sym_line_comment,
  [17019] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1098), 1,
      anon_sym_COMMA,
    ACTIONS(1499), 1,
      anon_sym_SEMI,
    STATE(489), 1,
      aux_sym_class_def_repeat1,
    STATE(497), 1,
      sym_line_comment,
  [17038] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(350), 1,
      anon_sym_RBRACK,
    ACTIONS(1501), 1,
      anon_sym_COMMA,
    STATE(498), 1,
      sym_line_comment,
    STATE(508), 1,
      aux_sym__collection_sequence_repeat1,
  [17057] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1503), 1,
      anon_sym_RPAREN,
    ACTIONS(1505), 1,
      anon_sym_COMMA,
    STATE(499), 1,
      sym_line_comment,
    STATE(507), 1,
      aux_sym_parameter_call_list_repeat1,
  [17076] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(500), 1,
      sym_line_comment,
    ACTIONS(1064), 3,
      anon_sym_SEMI,
      anon_sym_RPAREN,
      anon_sym_RBRACE,
  [17091] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1507), 1,
      anon_sym_DOT_DOT,
    STATE(501), 1,
      sym_line_comment,
    ACTIONS(673), 2,
      anon_sym_pi,
      anon_sym_RBRACK,
  [17108] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1326), 1,
      anon_sym_SEMI,
    ACTIONS(1336), 1,
      anon_sym_LPAREN,
    ACTIONS(1509), 1,
      anon_sym_EQ,
    STATE(502), 1,
      sym_line_comment,
  [17127] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(503), 1,
      sym_line_comment,
    ACTIONS(1416), 3,
      anon_sym_SEMI,
      anon_sym_COMMA,
      anon_sym_DOT_DOT_DOT,
  [17142] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1161), 1,
      aux_sym_class_token1,
    ACTIONS(1511), 1,
      anon_sym_LBRACK,
    STATE(504), 1,
      sym_line_comment,
    STATE(673), 1,
      sym_class,
  [17161] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1161), 1,
      aux_sym_class_token1,
    ACTIONS(1513), 1,
      anon_sym_LBRACK,
    STATE(505), 1,
      sym_line_comment,
    STATE(650), 1,
      sym_class,
  [17180] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1161), 1,
      aux_sym_class_token1,
    ACTIONS(1515), 1,
      anon_sym_LBRACK,
    STATE(506), 1,
      sym_line_comment,
    STATE(679), 1,
      sym_class,
  [17199] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1505), 1,
      anon_sym_COMMA,
    ACTIONS(1517), 1,
      anon_sym_RPAREN,
    STATE(490), 1,
      aux_sym_parameter_call_list_repeat1,
    STATE(507), 1,
      sym_line_comment,
  [17218] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1131), 1,
      anon_sym_RBRACK,
    ACTIONS(1519), 1,
      anon_sym_COMMA,
    STATE(508), 2,
      sym_line_comment,
      aux_sym__collection_sequence_repeat1,
  [17235] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(15), 1,
      anon_sym_LBRACE,
    ACTIONS(713), 1,
      anon_sym_LPAREN,
    STATE(237), 1,
      sym__function_content,
    STATE(509), 1,
      sym_line_comment,
  [17254] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1522), 1,
      anon_sym_RPAREN,
    ACTIONS(1524), 1,
      anon_sym_COMMA,
    STATE(510), 2,
      sym_line_comment,
      aux_sym__paired_associative_sequence_repeat1,
  [17271] = 6,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1084), 1,
      anon_sym_COMMA,
    ACTIONS(1086), 1,
      anon_sym_RBRACK,
    STATE(498), 1,
      aux_sym__collection_sequence_repeat1,
    STATE(511), 1,
      sym_line_comment,
  [17290] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1161), 1,
      aux_sym_class_token1,
    STATE(512), 1,
      sym_line_comment,
    STATE(580), 1,
      sym_class,
  [17306] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1445), 1,
      sym_identifier,
    STATE(513), 1,
      sym_line_comment,
    STATE(567), 1,
      sym_argument,
  [17322] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(731), 1,
      anon_sym_SQUOTE,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1527), 1,
      aux_sym_symbol_token2,
    STATE(514), 1,
      sym_line_comment,
  [17338] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1529), 1,
      anon_sym_DOT_DOT,
    STATE(515), 1,
      sym_line_comment,
  [17354] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1161), 1,
      aux_sym_class_token1,
    STATE(516), 1,
      sym_line_comment,
    STATE(526), 1,
      sym_class,
  [17370] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1531), 1,
      anon_sym_DOT_DOT,
    STATE(517), 1,
      sym_line_comment,
  [17386] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1533), 1,
      anon_sym_COMMA,
    STATE(518), 1,
      sym_line_comment,
    STATE(525), 1,
      aux_sym_switch_repeat1,
  [17402] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1535), 1,
      anon_sym_RPAREN,
    ACTIONS(1537), 1,
      anon_sym_COMMA,
    STATE(519), 1,
      sym_line_comment,
  [17418] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1540), 1,
      anon_sym_LPAREN,
    STATE(56), 1,
      sym_code_block,
    STATE(520), 1,
      sym_line_comment,
  [17434] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1542), 1,
      anon_sym_RPAREN,
    ACTIONS(1544), 1,
      anon_sym_COMMA,
    STATE(521), 1,
      sym_line_comment,
  [17450] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1540), 1,
      anon_sym_LPAREN,
    STATE(59), 1,
      sym_code_block,
    STATE(522), 1,
      sym_line_comment,
  [17466] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1546), 1,
      anon_sym_COMMA,
    STATE(523), 2,
      sym_line_comment,
      aux_sym_switch_repeat1,
  [17480] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1549), 1,
      anon_sym_RPAREN,
    ACTIONS(1551), 1,
      anon_sym_COMMA,
    STATE(524), 1,
      sym_line_comment,
  [17496] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1554), 1,
      anon_sym_COMMA,
    STATE(523), 1,
      aux_sym_switch_repeat1,
    STATE(525), 1,
      sym_line_comment,
  [17512] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1556), 1,
      anon_sym_LBRACE,
    ACTIONS(1558), 1,
      anon_sym_COLON,
    STATE(526), 1,
      sym_line_comment,
  [17528] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1560), 1,
      anon_sym_COMMA,
    STATE(527), 1,
      sym_line_comment,
    STATE(548), 1,
      aux_sym_variable_definition_sequence_repeat1,
  [17544] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1562), 1,
      anon_sym_RPAREN,
    STATE(528), 1,
      sym_line_comment,
  [17560] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1161), 1,
      aux_sym_class_token1,
    STATE(529), 1,
      sym_line_comment,
    STATE(593), 1,
      sym_class,
  [17576] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(216), 1,
      anon_sym_RPAREN,
    ACTIONS(218), 1,
      anon_sym_RBRACE,
    STATE(530), 1,
      sym_line_comment,
  [17592] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1564), 1,
      anon_sym_RPAREN,
    STATE(531), 1,
      sym_line_comment,
  [17608] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1566), 1,
      anon_sym_RPAREN,
    STATE(532), 1,
      sym_line_comment,
  [17624] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1568), 1,
      anon_sym_RPAREN,
    STATE(533), 1,
      sym_line_comment,
  [17640] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1570), 1,
      anon_sym_RPAREN,
    STATE(534), 1,
      sym_line_comment,
  [17656] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1572), 1,
      sym_identifier,
    STATE(535), 1,
      sym_line_comment,
    STATE(569), 1,
      sym_argument,
  [17672] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1445), 1,
      sym_identifier,
    STATE(536), 1,
      sym_line_comment,
    STATE(583), 1,
      sym_argument,
  [17688] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1310), 1,
      anon_sym_SQUOTE,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1574), 1,
      aux_sym_symbol_token2,
    STATE(537), 1,
      sym_line_comment,
  [17704] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1576), 1,
      anon_sym_RPAREN,
    STATE(538), 1,
      sym_line_comment,
  [17720] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(539), 1,
      sym_line_comment,
    ACTIONS(1578), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [17734] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1344), 1,
      anon_sym_EQ,
    ACTIONS(1346), 1,
      anon_sym_COMMA,
    STATE(540), 1,
      sym_line_comment,
  [17750] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1580), 1,
      anon_sym_RPAREN,
    STATE(541), 1,
      sym_line_comment,
  [17766] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1582), 1,
      anon_sym_RPAREN,
    ACTIONS(1584), 1,
      anon_sym_COMMA,
    STATE(542), 1,
      sym_line_comment,
  [17782] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1376), 1,
      sym_identifier,
    STATE(451), 1,
      sym_argument,
    STATE(543), 1,
      sym_line_comment,
  [17798] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1586), 1,
      anon_sym_RPAREN,
    ACTIONS(1588), 1,
      anon_sym_RBRACE,
    STATE(544), 1,
      sym_line_comment,
  [17814] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1590), 1,
      sym_integer,
    ACTIONS(1592), 1,
      anon_sym_RBRACK,
    STATE(545), 1,
      sym_line_comment,
  [17830] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1572), 1,
      sym_identifier,
    STATE(546), 1,
      sym_line_comment,
    STATE(568), 1,
      sym_argument,
  [17846] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1445), 1,
      sym_identifier,
    STATE(503), 1,
      sym_argument,
    STATE(547), 1,
      sym_line_comment,
  [17862] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1594), 1,
      anon_sym_COMMA,
    STATE(548), 2,
      sym_line_comment,
      aux_sym_variable_definition_sequence_repeat1,
  [17876] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1597), 1,
      anon_sym_RPAREN,
    ACTIONS(1599), 1,
      anon_sym_COMMA,
    STATE(549), 1,
      sym_line_comment,
  [17892] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(550), 1,
      sym_line_comment,
    ACTIONS(1482), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [17906] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1601), 1,
      anon_sym_RPAREN,
    STATE(551), 1,
      sym_line_comment,
  [17922] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1445), 1,
      sym_identifier,
    STATE(552), 1,
      sym_line_comment,
    STATE(631), 1,
      sym_argument,
  [17938] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(553), 1,
      sym_line_comment,
    ACTIONS(1131), 2,
      anon_sym_COMMA,
      anon_sym_RBRACK,
  [17952] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1572), 1,
      sym_identifier,
    STATE(554), 1,
      sym_line_comment,
    STATE(627), 1,
      sym_argument,
  [17968] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    STATE(555), 1,
      sym_line_comment,
    ACTIONS(1522), 2,
      anon_sym_RPAREN,
      anon_sym_COMMA,
  [17982] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1603), 1,
      anon_sym_RPAREN,
    STATE(556), 1,
      sym_line_comment,
  [17998] = 5,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1314), 1,
      aux_sym_line_comment_token1,
    ACTIONS(1605), 1,
      anon_sym_SQUOTE,
    ACTIONS(1607), 1,
      aux_sym_symbol_token2,
    STATE(557), 1,
      sym_line_comment,
  [18014] = 5,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1295), 1,
      anon_sym_pi,
    ACTIONS(1609), 1,
      anon_sym_DOT_DOT,
    STATE(558), 1,
      sym_line_comment,
  [18030] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1611), 1,
      anon_sym_RBRACK,
    STATE(559), 1,
      sym_line_comment,
  [18043] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1613), 1,
      anon_sym_SQUOTE,
    STATE(560), 1,
      sym_line_comment,
  [18056] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1615), 1,
      anon_sym_RPAREN,
    STATE(561), 1,
      sym_line_comment,
  [18069] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1617), 1,
      anon_sym_RPAREN,
    STATE(562), 1,
      sym_line_comment,
  [18082] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1619), 1,
      anon_sym_COMMA,
    STATE(563), 1,
      sym_line_comment,
  [18095] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1621), 1,
      anon_sym_COMMA,
    STATE(564), 1,
      sym_line_comment,
  [18108] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1623), 1,
      anon_sym_RPAREN,
    STATE(565), 1,
      sym_line_comment,
  [18121] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1625), 1,
      sym_integer,
    STATE(566), 1,
      sym_line_comment,
  [18134] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1627), 1,
      anon_sym_PIPE,
    STATE(567), 1,
      sym_line_comment,
  [18147] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1627), 1,
      anon_sym_SEMI,
    STATE(568), 1,
      sym_line_comment,
  [18160] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1451), 1,
      anon_sym_SEMI,
    STATE(569), 1,
      sym_line_comment,
  [18173] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1629), 1,
      anon_sym_LBRACK,
    STATE(570), 1,
      sym_line_comment,
  [18186] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1631), 1,
      anon_sym_RBRACE,
    STATE(571), 1,
      sym_line_comment,
  [18199] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1633), 1,
      anon_sym_EQ,
    STATE(572), 1,
      sym_line_comment,
  [18212] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1635), 1,
      sym_identifier,
    STATE(573), 1,
      sym_line_comment,
  [18225] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1592), 1,
      anon_sym_RBRACK,
    STATE(574), 1,
      sym_line_comment,
  [18238] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1637), 1,
      anon_sym_RPAREN,
    STATE(575), 1,
      sym_line_comment,
  [18251] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(230), 1,
      anon_sym_RPAREN,
    STATE(576), 1,
      sym_line_comment,
  [18264] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1639), 1,
      sym_integer,
    STATE(577), 1,
      sym_line_comment,
  [18277] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1641), 1,
      sym_integer,
    STATE(578), 1,
      sym_line_comment,
  [18290] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1643), 1,
      anon_sym_RBRACK,
    STATE(579), 1,
      sym_line_comment,
  [18303] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1645), 1,
      anon_sym_LBRACE,
    STATE(580), 1,
      sym_line_comment,
  [18316] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1647), 1,
      anon_sym_COMMA,
    STATE(581), 1,
      sym_line_comment,
  [18329] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1649), 1,
      anon_sym_COMMA,
    STATE(582), 1,
      sym_line_comment,
  [18342] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1451), 1,
      anon_sym_PIPE,
    STATE(583), 1,
      sym_line_comment,
  [18355] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1651), 1,
      sym_integer,
    STATE(584), 1,
      sym_line_comment,
  [18368] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1653), 1,
      anon_sym_SEMI,
    STATE(585), 1,
      sym_line_comment,
  [18381] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1655), 1,
      anon_sym_RPAREN,
    STATE(586), 1,
      sym_line_comment,
  [18394] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1657), 1,
      anon_sym_RPAREN,
    STATE(587), 1,
      sym_line_comment,
  [18407] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(232), 1,
      anon_sym_RBRACE,
    STATE(588), 1,
      sym_line_comment,
  [18420] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1659), 1,
      anon_sym_RBRACE,
    STATE(589), 1,
      sym_line_comment,
  [18433] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1661), 1,
      anon_sym_SQUOTE,
    STATE(590), 1,
      sym_line_comment,
  [18446] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1663), 1,
      anon_sym_RBRACK,
    STATE(591), 1,
      sym_line_comment,
  [18459] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1657), 1,
      anon_sym_RBRACK,
    STATE(592), 1,
      sym_line_comment,
  [18472] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1665), 1,
      anon_sym_LBRACE,
    STATE(593), 1,
      sym_line_comment,
  [18485] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1374), 1,
      anon_sym_EQ,
    STATE(594), 1,
      sym_line_comment,
  [18498] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1667), 1,
      anon_sym_RBRACE,
    STATE(595), 1,
      sym_line_comment,
  [18511] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1669), 1,
      sym_identifier,
    STATE(596), 1,
      sym_line_comment,
  [18524] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1671), 1,
      anon_sym_RPAREN,
    STATE(597), 1,
      sym_line_comment,
  [18537] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1673), 1,
      anon_sym_RPAREN,
    STATE(598), 1,
      sym_line_comment,
  [18550] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1675), 1,
      anon_sym_RBRACK,
    STATE(599), 1,
      sym_line_comment,
  [18563] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1677), 1,
      sym_integer,
    STATE(600), 1,
      sym_line_comment,
  [18576] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1679), 1,
      anon_sym_RBRACK,
    STATE(601), 1,
      sym_line_comment,
  [18589] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1681), 1,
      anon_sym_RBRACE,
    STATE(602), 1,
      sym_line_comment,
  [18602] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1683), 1,
      anon_sym_COMMA,
    STATE(603), 1,
      sym_line_comment,
  [18615] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1685), 1,
      anon_sym_COMMA,
    STATE(604), 1,
      sym_line_comment,
  [18628] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1687), 1,
      anon_sym_RBRACK,
    STATE(605), 1,
      sym_line_comment,
  [18641] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(216), 1,
      anon_sym_RPAREN,
    STATE(606), 1,
      sym_line_comment,
  [18654] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1689), 1,
      anon_sym_COMMA,
    STATE(607), 1,
      sym_line_comment,
  [18667] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1691), 1,
      anon_sym_COMMA,
    STATE(608), 1,
      sym_line_comment,
  [18680] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1693), 1,
      anon_sym_RBRACK,
    STATE(609), 1,
      sym_line_comment,
  [18693] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1695), 1,
      anon_sym_RBRACE,
    STATE(610), 1,
      sym_line_comment,
  [18706] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1697), 1,
      anon_sym_RPAREN,
    STATE(611), 1,
      sym_line_comment,
  [18719] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1699), 1,
      anon_sym_RPAREN,
    STATE(612), 1,
      sym_line_comment,
  [18732] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1586), 1,
      anon_sym_RPAREN,
    STATE(613), 1,
      sym_line_comment,
  [18745] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1346), 1,
      anon_sym_COMMA,
    STATE(614), 1,
      sym_line_comment,
  [18758] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1701), 1,
      anon_sym_RBRACK,
    STATE(615), 1,
      sym_line_comment,
  [18771] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1703), 1,
      anon_sym_EQ,
    STATE(616), 1,
      sym_line_comment,
  [18784] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1705), 1,
      sym_integer,
    STATE(617), 1,
      sym_line_comment,
  [18797] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1707), 1,
      anon_sym_RPAREN,
    STATE(618), 1,
      sym_line_comment,
  [18810] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1709), 1,
      anon_sym_RPAREN,
    STATE(619), 1,
      sym_line_comment,
  [18823] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(220), 1,
      anon_sym_RBRACE,
    STATE(620), 1,
      sym_line_comment,
  [18836] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1711), 1,
      sym_integer,
    STATE(621), 1,
      sym_line_comment,
  [18849] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1713), 1,
      anon_sym_RPAREN,
    STATE(622), 1,
      sym_line_comment,
  [18862] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1477), 1,
      anon_sym_EQ,
    STATE(623), 1,
      sym_line_comment,
  [18875] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1709), 1,
      anon_sym_RBRACK,
    STATE(624), 1,
      sym_line_comment,
  [18888] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1715), 1,
      anon_sym_RPAREN,
    STATE(625), 1,
      sym_line_comment,
  [18901] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1717), 1,
      anon_sym_RBRACE,
    STATE(626), 1,
      sym_line_comment,
  [18914] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1719), 1,
      anon_sym_SEMI,
    STATE(627), 1,
      sym_line_comment,
  [18927] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1721), 1,
      anon_sym_RBRACK,
    STATE(628), 1,
      sym_line_comment,
  [18940] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1723), 1,
      anon_sym_RBRACK,
    STATE(629), 1,
      sym_line_comment,
  [18953] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1725), 1,
      anon_sym_RBRACE,
    STATE(630), 1,
      sym_line_comment,
  [18966] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1719), 1,
      anon_sym_PIPE,
    STATE(631), 1,
      sym_line_comment,
  [18979] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1727), 1,
      anon_sym_RBRACK,
    STATE(632), 1,
      sym_line_comment,
  [18992] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1729), 1,
      anon_sym_RBRACE,
    STATE(633), 1,
      sym_line_comment,
  [19005] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1731), 1,
      anon_sym_RPAREN,
    STATE(634), 1,
      sym_line_comment,
  [19018] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1733), 1,
      anon_sym_COMMA,
    STATE(635), 1,
      sym_line_comment,
  [19031] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(222), 1,
      anon_sym_RBRACE,
    STATE(636), 1,
      sym_line_comment,
  [19044] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1735), 1,
      sym_integer,
    STATE(637), 1,
      sym_line_comment,
  [19057] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1588), 1,
      anon_sym_RBRACE,
    STATE(638), 1,
      sym_line_comment,
  [19070] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1737), 1,
      anon_sym_RBRACE,
    STATE(639), 1,
      sym_line_comment,
  [19083] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1739), 1,
      anon_sym_RBRACE,
    STATE(640), 1,
      sym_line_comment,
  [19096] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1741), 1,
      anon_sym_RBRACE,
    STATE(641), 1,
      sym_line_comment,
  [19109] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1743), 1,
      anon_sym_RPAREN,
    STATE(642), 1,
      sym_line_comment,
  [19122] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1745), 1,
      anon_sym_RPAREN,
    STATE(643), 1,
      sym_line_comment,
  [19135] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1747), 1,
      anon_sym_RPAREN,
    STATE(644), 1,
      sym_line_comment,
  [19148] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1749), 1,
      anon_sym_LBRACE,
    STATE(645), 1,
      sym_line_comment,
  [19161] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1751), 1,
      anon_sym_LBRACE,
    STATE(646), 1,
      sym_line_comment,
  [19174] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1753), 1,
      sym_integer,
    STATE(647), 1,
      sym_line_comment,
  [19187] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1755), 1,
      sym_integer,
    STATE(648), 1,
      sym_line_comment,
  [19200] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1757), 1,
      anon_sym_RBRACK,
    STATE(649), 1,
      sym_line_comment,
  [19213] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1759), 1,
      anon_sym_LBRACK,
    STATE(650), 1,
      sym_line_comment,
  [19226] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1761), 1,
      anon_sym_RPAREN,
    STATE(651), 1,
      sym_line_comment,
  [19239] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1763), 1,
      sym_identifier,
    STATE(652), 1,
      sym_line_comment,
  [19252] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(228), 1,
      anon_sym_RPAREN,
    STATE(653), 1,
      sym_line_comment,
  [19265] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1765), 1,
      sym_identifier,
    STATE(654), 1,
      sym_line_comment,
  [19278] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1767), 1,
      anon_sym_SQUOTE,
    STATE(655), 1,
      sym_line_comment,
  [19291] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1769), 1,
      anon_sym_LPAREN,
    STATE(656), 1,
      sym_line_comment,
  [19304] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1014), 1,
      anon_sym_LBRACK,
    STATE(657), 1,
      sym_line_comment,
  [19317] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1771), 1,
      anon_sym_RPAREN,
    STATE(658), 1,
      sym_line_comment,
  [19330] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1773), 1,
      anon_sym_LPAREN,
    STATE(659), 1,
      sym_line_comment,
  [19343] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(218), 1,
      anon_sym_RBRACE,
    STATE(660), 1,
      sym_line_comment,
  [19356] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1757), 1,
      anon_sym_RPAREN,
    STATE(661), 1,
      sym_line_comment,
  [19369] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1775), 1,
      anon_sym_RPAREN,
    STATE(662), 1,
      sym_line_comment,
  [19382] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1777), 1,
      anon_sym_SEMI,
    STATE(663), 1,
      sym_line_comment,
  [19395] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1779), 1,
      ts_builtin_sym_end,
    STATE(664), 1,
      sym_line_comment,
  [19408] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1781), 1,
      anon_sym_RPAREN,
    STATE(665), 1,
      sym_line_comment,
  [19421] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(226), 1,
      anon_sym_RPAREN,
    STATE(666), 1,
      sym_line_comment,
  [19434] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1783), 1,
      anon_sym_LPAREN,
    STATE(667), 1,
      sym_line_comment,
  [19447] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1785), 1,
      anon_sym_LPAREN,
    STATE(668), 1,
      sym_line_comment,
  [19460] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1787), 1,
      anon_sym_RPAREN,
    STATE(669), 1,
      sym_line_comment,
  [19473] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1789), 1,
      anon_sym_LPAREN,
    STATE(670), 1,
      sym_line_comment,
  [19486] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1791), 1,
      anon_sym_RPAREN,
    STATE(671), 1,
      sym_line_comment,
  [19499] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1793), 1,
      anon_sym_LPAREN,
    STATE(672), 1,
      sym_line_comment,
  [19512] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1795), 1,
      anon_sym_LBRACK,
    STATE(673), 1,
      sym_line_comment,
  [19525] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1797), 1,
      anon_sym_LBRACE,
    STATE(674), 1,
      sym_line_comment,
  [19538] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1799), 1,
      anon_sym_COMMA,
    STATE(675), 1,
      sym_line_comment,
  [19551] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1801), 1,
      anon_sym_LBRACK,
    STATE(676), 1,
      sym_line_comment,
  [19564] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1803), 1,
      anon_sym_RPAREN,
    STATE(677), 1,
      sym_line_comment,
  [19577] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1805), 1,
      sym_identifier,
    STATE(678), 1,
      sym_line_comment,
  [19590] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1807), 1,
      anon_sym_LBRACK,
    STATE(679), 1,
      sym_line_comment,
  [19603] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1809), 1,
      anon_sym_LBRACE,
    STATE(680), 1,
      sym_line_comment,
  [19616] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1811), 1,
      anon_sym_RPAREN,
    STATE(681), 1,
      sym_line_comment,
  [19629] = 4,
    ACTIONS(3), 1,
      aux_sym_line_comment_token1,
    ACTIONS(5), 1,
      sym_block_comment,
    ACTIONS(1813), 1,
      sym_identifier,
    STATE(682), 1,
      sym_line_comment,
  [19642] = 1,
    ACTIONS(1815), 1,
      ts_builtin_sym_end,
};

static const uint32_t ts_small_parse_table_map[] = {
  [SMALL_STATE(118)] = 0,
  [SMALL_STATE(119)] = 62,
  [SMALL_STATE(120)] = 124,
  [SMALL_STATE(121)] = 186,
  [SMALL_STATE(122)] = 248,
  [SMALL_STATE(123)] = 310,
  [SMALL_STATE(124)] = 374,
  [SMALL_STATE(125)] = 436,
  [SMALL_STATE(126)] = 498,
  [SMALL_STATE(127)] = 562,
  [SMALL_STATE(128)] = 624,
  [SMALL_STATE(129)] = 686,
  [SMALL_STATE(130)] = 748,
  [SMALL_STATE(131)] = 810,
  [SMALL_STATE(132)] = 872,
  [SMALL_STATE(133)] = 934,
  [SMALL_STATE(134)] = 996,
  [SMALL_STATE(135)] = 1058,
  [SMALL_STATE(136)] = 1118,
  [SMALL_STATE(137)] = 1176,
  [SMALL_STATE(138)] = 1234,
  [SMALL_STATE(139)] = 1292,
  [SMALL_STATE(140)] = 1350,
  [SMALL_STATE(141)] = 1408,
  [SMALL_STATE(142)] = 1466,
  [SMALL_STATE(143)] = 1524,
  [SMALL_STATE(144)] = 1582,
  [SMALL_STATE(145)] = 1640,
  [SMALL_STATE(146)] = 1698,
  [SMALL_STATE(147)] = 1763,
  [SMALL_STATE(148)] = 1818,
  [SMALL_STATE(149)] = 1875,
  [SMALL_STATE(150)] = 1930,
  [SMALL_STATE(151)] = 1985,
  [SMALL_STATE(152)] = 2046,
  [SMALL_STATE(153)] = 2101,
  [SMALL_STATE(154)] = 2158,
  [SMALL_STATE(155)] = 2213,
  [SMALL_STATE(156)] = 2268,
  [SMALL_STATE(157)] = 2323,
  [SMALL_STATE(158)] = 2378,
  [SMALL_STATE(159)] = 2433,
  [SMALL_STATE(160)] = 2488,
  [SMALL_STATE(161)] = 2543,
  [SMALL_STATE(162)] = 2598,
  [SMALL_STATE(163)] = 2661,
  [SMALL_STATE(164)] = 2716,
  [SMALL_STATE(165)] = 2784,
  [SMALL_STATE(166)] = 2842,
  [SMALL_STATE(167)] = 2934,
  [SMALL_STATE(168)] = 3000,
  [SMALL_STATE(169)] = 3053,
  [SMALL_STATE(170)] = 3116,
  [SMALL_STATE(171)] = 3179,
  [SMALL_STATE(172)] = 3231,
  [SMALL_STATE(173)] = 3283,
  [SMALL_STATE(174)] = 3335,
  [SMALL_STATE(175)] = 3395,
  [SMALL_STATE(176)] = 3451,
  [SMALL_STATE(177)] = 3503,
  [SMALL_STATE(178)] = 3565,
  [SMALL_STATE(179)] = 3619,
  [SMALL_STATE(180)] = 3670,
  [SMALL_STATE(181)] = 3721,
  [SMALL_STATE(182)] = 3772,
  [SMALL_STATE(183)] = 3823,
  [SMALL_STATE(184)] = 3874,
  [SMALL_STATE(185)] = 3925,
  [SMALL_STATE(186)] = 3984,
  [SMALL_STATE(187)] = 4035,
  [SMALL_STATE(188)] = 4086,
  [SMALL_STATE(189)] = 4137,
  [SMALL_STATE(190)] = 4194,
  [SMALL_STATE(191)] = 4245,
  [SMALL_STATE(192)] = 4296,
  [SMALL_STATE(193)] = 4347,
  [SMALL_STATE(194)] = 4398,
  [SMALL_STATE(195)] = 4449,
  [SMALL_STATE(196)] = 4500,
  [SMALL_STATE(197)] = 4551,
  [SMALL_STATE(198)] = 4602,
  [SMALL_STATE(199)] = 4653,
  [SMALL_STATE(200)] = 4704,
  [SMALL_STATE(201)] = 4755,
  [SMALL_STATE(202)] = 4806,
  [SMALL_STATE(203)] = 4857,
  [SMALL_STATE(204)] = 4942,
  [SMALL_STATE(205)] = 4993,
  [SMALL_STATE(206)] = 5044,
  [SMALL_STATE(207)] = 5117,
  [SMALL_STATE(208)] = 5192,
  [SMALL_STATE(209)] = 5257,
  [SMALL_STATE(210)] = 5318,
  [SMALL_STATE(211)] = 5411,
  [SMALL_STATE(212)] = 5466,
  [SMALL_STATE(213)] = 5545,
  [SMALL_STATE(214)] = 5626,
  [SMALL_STATE(215)] = 5697,
  [SMALL_STATE(216)] = 5766,
  [SMALL_STATE(217)] = 5823,
  [SMALL_STATE(218)] = 5908,
  [SMALL_STATE(219)] = 5959,
  [SMALL_STATE(220)] = 6014,
  [SMALL_STATE(221)] = 6065,
  [SMALL_STATE(222)] = 6116,
  [SMALL_STATE(223)] = 6167,
  [SMALL_STATE(224)] = 6218,
  [SMALL_STATE(225)] = 6269,
  [SMALL_STATE(226)] = 6320,
  [SMALL_STATE(227)] = 6371,
  [SMALL_STATE(228)] = 6422,
  [SMALL_STATE(229)] = 6473,
  [SMALL_STATE(230)] = 6524,
  [SMALL_STATE(231)] = 6575,
  [SMALL_STATE(232)] = 6626,
  [SMALL_STATE(233)] = 6677,
  [SMALL_STATE(234)] = 6728,
  [SMALL_STATE(235)] = 6779,
  [SMALL_STATE(236)] = 6830,
  [SMALL_STATE(237)] = 6881,
  [SMALL_STATE(238)] = 6932,
  [SMALL_STATE(239)] = 6983,
  [SMALL_STATE(240)] = 7034,
  [SMALL_STATE(241)] = 7085,
  [SMALL_STATE(242)] = 7136,
  [SMALL_STATE(243)] = 7187,
  [SMALL_STATE(244)] = 7238,
  [SMALL_STATE(245)] = 7289,
  [SMALL_STATE(246)] = 7340,
  [SMALL_STATE(247)] = 7391,
  [SMALL_STATE(248)] = 7442,
  [SMALL_STATE(249)] = 7493,
  [SMALL_STATE(250)] = 7544,
  [SMALL_STATE(251)] = 7595,
  [SMALL_STATE(252)] = 7646,
  [SMALL_STATE(253)] = 7697,
  [SMALL_STATE(254)] = 7748,
  [SMALL_STATE(255)] = 7799,
  [SMALL_STATE(256)] = 7853,
  [SMALL_STATE(257)] = 7907,
  [SMALL_STATE(258)] = 8005,
  [SMALL_STATE(259)] = 8057,
  [SMALL_STATE(260)] = 8155,
  [SMALL_STATE(261)] = 8253,
  [SMALL_STATE(262)] = 8351,
  [SMALL_STATE(263)] = 8449,
  [SMALL_STATE(264)] = 8540,
  [SMALL_STATE(265)] = 8591,
  [SMALL_STATE(266)] = 8680,
  [SMALL_STATE(267)] = 8731,
  [SMALL_STATE(268)] = 8824,
  [SMALL_STATE(269)] = 8916,
  [SMALL_STATE(270)] = 8972,
  [SMALL_STATE(271)] = 9042,
  [SMALL_STATE(272)] = 9120,
  [SMALL_STATE(273)] = 9174,
  [SMALL_STATE(274)] = 9230,
  [SMALL_STATE(275)] = 9298,
  [SMALL_STATE(276)] = 9390,
  [SMALL_STATE(277)] = 9456,
  [SMALL_STATE(278)] = 9548,
  [SMALL_STATE(279)] = 9620,
  [SMALL_STATE(280)] = 9672,
  [SMALL_STATE(281)] = 9720,
  [SMALL_STATE(282)] = 9810,
  [SMALL_STATE(283)] = 9864,
  [SMALL_STATE(284)] = 9912,
  [SMALL_STATE(285)] = 10000,
  [SMALL_STATE(286)] = 10054,
  [SMALL_STATE(287)] = 10136,
  [SMALL_STATE(288)] = 10188,
  [SMALL_STATE(289)] = 10276,
  [SMALL_STATE(290)] = 10352,
  [SMALL_STATE(291)] = 10440,
  [SMALL_STATE(292)] = 10502,
  [SMALL_STATE(293)] = 10584,
  [SMALL_STATE(294)] = 10640,
  [SMALL_STATE(295)] = 10698,
  [SMALL_STATE(296)] = 10752,
  [SMALL_STATE(297)] = 10805,
  [SMALL_STATE(298)] = 10892,
  [SMALL_STATE(299)] = 10943,
  [SMALL_STATE(300)] = 11030,
  [SMALL_STATE(301)] = 11117,
  [SMALL_STATE(302)] = 11168,
  [SMALL_STATE(303)] = 11219,
  [SMALL_STATE(304)] = 11268,
  [SMALL_STATE(305)] = 11317,
  [SMALL_STATE(306)] = 11368,
  [SMALL_STATE(307)] = 11457,
  [SMALL_STATE(308)] = 11544,
  [SMALL_STATE(309)] = 11595,
  [SMALL_STATE(310)] = 11646,
  [SMALL_STATE(311)] = 11733,
  [SMALL_STATE(312)] = 11779,
  [SMALL_STATE(313)] = 11865,
  [SMALL_STATE(314)] = 11913,
  [SMALL_STATE(315)] = 11999,
  [SMALL_STATE(316)] = 12085,
  [SMALL_STATE(317)] = 12171,
  [SMALL_STATE(318)] = 12217,
  [SMALL_STATE(319)] = 12303,
  [SMALL_STATE(320)] = 12349,
  [SMALL_STATE(321)] = 12397,
  [SMALL_STATE(322)] = 12448,
  [SMALL_STATE(323)] = 12497,
  [SMALL_STATE(324)] = 12580,
  [SMALL_STATE(325)] = 12625,
  [SMALL_STATE(326)] = 12670,
  [SMALL_STATE(327)] = 12721,
  [SMALL_STATE(328)] = 12766,
  [SMALL_STATE(329)] = 12810,
  [SMALL_STATE(330)] = 12854,
  [SMALL_STATE(331)] = 12898,
  [SMALL_STATE(332)] = 12954,
  [SMALL_STATE(333)] = 13020,
  [SMALL_STATE(334)] = 13076,
  [SMALL_STATE(335)] = 13132,
  [SMALL_STATE(336)] = 13198,
  [SMALL_STATE(337)] = 13254,
  [SMALL_STATE(338)] = 13320,
  [SMALL_STATE(339)] = 13366,
  [SMALL_STATE(340)] = 13412,
  [SMALL_STATE(341)] = 13461,
  [SMALL_STATE(342)] = 13512,
  [SMALL_STATE(343)] = 13563,
  [SMALL_STATE(344)] = 13614,
  [SMALL_STATE(345)] = 13665,
  [SMALL_STATE(346)] = 13716,
  [SMALL_STATE(347)] = 13767,
  [SMALL_STATE(348)] = 13818,
  [SMALL_STATE(349)] = 13869,
  [SMALL_STATE(350)] = 13895,
  [SMALL_STATE(351)] = 13921,
  [SMALL_STATE(352)] = 13947,
  [SMALL_STATE(353)] = 13973,
  [SMALL_STATE(354)] = 13999,
  [SMALL_STATE(355)] = 14025,
  [SMALL_STATE(356)] = 14051,
  [SMALL_STATE(357)] = 14090,
  [SMALL_STATE(358)] = 14114,
  [SMALL_STATE(359)] = 14138,
  [SMALL_STATE(360)] = 14162,
  [SMALL_STATE(361)] = 14186,
  [SMALL_STATE(362)] = 14210,
  [SMALL_STATE(363)] = 14234,
  [SMALL_STATE(364)] = 14258,
  [SMALL_STATE(365)] = 14282,
  [SMALL_STATE(366)] = 14306,
  [SMALL_STATE(367)] = 14330,
  [SMALL_STATE(368)] = 14354,
  [SMALL_STATE(369)] = 14384,
  [SMALL_STATE(370)] = 14406,
  [SMALL_STATE(371)] = 14428,
  [SMALL_STATE(372)] = 14449,
  [SMALL_STATE(373)] = 14470,
  [SMALL_STATE(374)] = 14499,
  [SMALL_STATE(375)] = 14524,
  [SMALL_STATE(376)] = 14555,
  [SMALL_STATE(377)] = 14586,
  [SMALL_STATE(378)] = 14610,
  [SMALL_STATE(379)] = 14630,
  [SMALL_STATE(380)] = 14652,
  [SMALL_STATE(381)] = 14674,
  [SMALL_STATE(382)] = 14696,
  [SMALL_STATE(383)] = 14720,
  [SMALL_STATE(384)] = 14742,
  [SMALL_STATE(385)] = 14764,
  [SMALL_STATE(386)] = 14786,
  [SMALL_STATE(387)] = 14808,
  [SMALL_STATE(388)] = 14830,
  [SMALL_STATE(389)] = 14852,
  [SMALL_STATE(390)] = 14874,
  [SMALL_STATE(391)] = 14892,
  [SMALL_STATE(392)] = 14914,
  [SMALL_STATE(393)] = 14936,
  [SMALL_STATE(394)] = 14958,
  [SMALL_STATE(395)] = 14980,
  [SMALL_STATE(396)] = 15005,
  [SMALL_STATE(397)] = 15030,
  [SMALL_STATE(398)] = 15055,
  [SMALL_STATE(399)] = 15080,
  [SMALL_STATE(400)] = 15101,
  [SMALL_STATE(401)] = 15122,
  [SMALL_STATE(402)] = 15147,
  [SMALL_STATE(403)] = 15172,
  [SMALL_STATE(404)] = 15197,
  [SMALL_STATE(405)] = 15222,
  [SMALL_STATE(406)] = 15247,
  [SMALL_STATE(407)] = 15272,
  [SMALL_STATE(408)] = 15297,
  [SMALL_STATE(409)] = 15318,
  [SMALL_STATE(410)] = 15343,
  [SMALL_STATE(411)] = 15368,
  [SMALL_STATE(412)] = 15393,
  [SMALL_STATE(413)] = 15418,
  [SMALL_STATE(414)] = 15443,
  [SMALL_STATE(415)] = 15468,
  [SMALL_STATE(416)] = 15493,
  [SMALL_STATE(417)] = 15518,
  [SMALL_STATE(418)] = 15543,
  [SMALL_STATE(419)] = 15562,
  [SMALL_STATE(420)] = 15587,
  [SMALL_STATE(421)] = 15608,
  [SMALL_STATE(422)] = 15633,
  [SMALL_STATE(423)] = 15658,
  [SMALL_STATE(424)] = 15677,
  [SMALL_STATE(425)] = 15698,
  [SMALL_STATE(426)] = 15723,
  [SMALL_STATE(427)] = 15745,
  [SMALL_STATE(428)] = 15767,
  [SMALL_STATE(429)] = 15785,
  [SMALL_STATE(430)] = 15801,
  [SMALL_STATE(431)] = 15817,
  [SMALL_STATE(432)] = 15835,
  [SMALL_STATE(433)] = 15857,
  [SMALL_STATE(434)] = 15879,
  [SMALL_STATE(435)] = 15901,
  [SMALL_STATE(436)] = 15919,
  [SMALL_STATE(437)] = 15935,
  [SMALL_STATE(438)] = 15957,
  [SMALL_STATE(439)] = 15977,
  [SMALL_STATE(440)] = 15997,
  [SMALL_STATE(441)] = 16017,
  [SMALL_STATE(442)] = 16035,
  [SMALL_STATE(443)] = 16053,
  [SMALL_STATE(444)] = 16071,
  [SMALL_STATE(445)] = 16089,
  [SMALL_STATE(446)] = 16107,
  [SMALL_STATE(447)] = 16125,
  [SMALL_STATE(448)] = 16143,
  [SMALL_STATE(449)] = 16161,
  [SMALL_STATE(450)] = 16177,
  [SMALL_STATE(451)] = 16195,
  [SMALL_STATE(452)] = 16213,
  [SMALL_STATE(453)] = 16229,
  [SMALL_STATE(454)] = 16245,
  [SMALL_STATE(455)] = 16263,
  [SMALL_STATE(456)] = 16281,
  [SMALL_STATE(457)] = 16301,
  [SMALL_STATE(458)] = 16323,
  [SMALL_STATE(459)] = 16339,
  [SMALL_STATE(460)] = 16361,
  [SMALL_STATE(461)] = 16377,
  [SMALL_STATE(462)] = 16393,
  [SMALL_STATE(463)] = 16409,
  [SMALL_STATE(464)] = 16431,
  [SMALL_STATE(465)] = 16449,
  [SMALL_STATE(466)] = 16471,
  [SMALL_STATE(467)] = 16487,
  [SMALL_STATE(468)] = 16503,
  [SMALL_STATE(469)] = 16519,
  [SMALL_STATE(470)] = 16535,
  [SMALL_STATE(471)] = 16551,
  [SMALL_STATE(472)] = 16567,
  [SMALL_STATE(473)] = 16585,
  [SMALL_STATE(474)] = 16603,
  [SMALL_STATE(475)] = 16625,
  [SMALL_STATE(476)] = 16643,
  [SMALL_STATE(477)] = 16665,
  [SMALL_STATE(478)] = 16683,
  [SMALL_STATE(479)] = 16699,
  [SMALL_STATE(480)] = 16717,
  [SMALL_STATE(481)] = 16733,
  [SMALL_STATE(482)] = 16752,
  [SMALL_STATE(483)] = 16771,
  [SMALL_STATE(484)] = 16788,
  [SMALL_STATE(485)] = 16805,
  [SMALL_STATE(486)] = 16822,
  [SMALL_STATE(487)] = 16837,
  [SMALL_STATE(488)] = 16856,
  [SMALL_STATE(489)] = 16875,
  [SMALL_STATE(490)] = 16892,
  [SMALL_STATE(491)] = 16909,
  [SMALL_STATE(492)] = 16928,
  [SMALL_STATE(493)] = 16945,
  [SMALL_STATE(494)] = 16964,
  [SMALL_STATE(495)] = 16981,
  [SMALL_STATE(496)] = 17000,
  [SMALL_STATE(497)] = 17019,
  [SMALL_STATE(498)] = 17038,
  [SMALL_STATE(499)] = 17057,
  [SMALL_STATE(500)] = 17076,
  [SMALL_STATE(501)] = 17091,
  [SMALL_STATE(502)] = 17108,
  [SMALL_STATE(503)] = 17127,
  [SMALL_STATE(504)] = 17142,
  [SMALL_STATE(505)] = 17161,
  [SMALL_STATE(506)] = 17180,
  [SMALL_STATE(507)] = 17199,
  [SMALL_STATE(508)] = 17218,
  [SMALL_STATE(509)] = 17235,
  [SMALL_STATE(510)] = 17254,
  [SMALL_STATE(511)] = 17271,
  [SMALL_STATE(512)] = 17290,
  [SMALL_STATE(513)] = 17306,
  [SMALL_STATE(514)] = 17322,
  [SMALL_STATE(515)] = 17338,
  [SMALL_STATE(516)] = 17354,
  [SMALL_STATE(517)] = 17370,
  [SMALL_STATE(518)] = 17386,
  [SMALL_STATE(519)] = 17402,
  [SMALL_STATE(520)] = 17418,
  [SMALL_STATE(521)] = 17434,
  [SMALL_STATE(522)] = 17450,
  [SMALL_STATE(523)] = 17466,
  [SMALL_STATE(524)] = 17480,
  [SMALL_STATE(525)] = 17496,
  [SMALL_STATE(526)] = 17512,
  [SMALL_STATE(527)] = 17528,
  [SMALL_STATE(528)] = 17544,
  [SMALL_STATE(529)] = 17560,
  [SMALL_STATE(530)] = 17576,
  [SMALL_STATE(531)] = 17592,
  [SMALL_STATE(532)] = 17608,
  [SMALL_STATE(533)] = 17624,
  [SMALL_STATE(534)] = 17640,
  [SMALL_STATE(535)] = 17656,
  [SMALL_STATE(536)] = 17672,
  [SMALL_STATE(537)] = 17688,
  [SMALL_STATE(538)] = 17704,
  [SMALL_STATE(539)] = 17720,
  [SMALL_STATE(540)] = 17734,
  [SMALL_STATE(541)] = 17750,
  [SMALL_STATE(542)] = 17766,
  [SMALL_STATE(543)] = 17782,
  [SMALL_STATE(544)] = 17798,
  [SMALL_STATE(545)] = 17814,
  [SMALL_STATE(546)] = 17830,
  [SMALL_STATE(547)] = 17846,
  [SMALL_STATE(548)] = 17862,
  [SMALL_STATE(549)] = 17876,
  [SMALL_STATE(550)] = 17892,
  [SMALL_STATE(551)] = 17906,
  [SMALL_STATE(552)] = 17922,
  [SMALL_STATE(553)] = 17938,
  [SMALL_STATE(554)] = 17952,
  [SMALL_STATE(555)] = 17968,
  [SMALL_STATE(556)] = 17982,
  [SMALL_STATE(557)] = 17998,
  [SMALL_STATE(558)] = 18014,
  [SMALL_STATE(559)] = 18030,
  [SMALL_STATE(560)] = 18043,
  [SMALL_STATE(561)] = 18056,
  [SMALL_STATE(562)] = 18069,
  [SMALL_STATE(563)] = 18082,
  [SMALL_STATE(564)] = 18095,
  [SMALL_STATE(565)] = 18108,
  [SMALL_STATE(566)] = 18121,
  [SMALL_STATE(567)] = 18134,
  [SMALL_STATE(568)] = 18147,
  [SMALL_STATE(569)] = 18160,
  [SMALL_STATE(570)] = 18173,
  [SMALL_STATE(571)] = 18186,
  [SMALL_STATE(572)] = 18199,
  [SMALL_STATE(573)] = 18212,
  [SMALL_STATE(574)] = 18225,
  [SMALL_STATE(575)] = 18238,
  [SMALL_STATE(576)] = 18251,
  [SMALL_STATE(577)] = 18264,
  [SMALL_STATE(578)] = 18277,
  [SMALL_STATE(579)] = 18290,
  [SMALL_STATE(580)] = 18303,
  [SMALL_STATE(581)] = 18316,
  [SMALL_STATE(582)] = 18329,
  [SMALL_STATE(583)] = 18342,
  [SMALL_STATE(584)] = 18355,
  [SMALL_STATE(585)] = 18368,
  [SMALL_STATE(586)] = 18381,
  [SMALL_STATE(587)] = 18394,
  [SMALL_STATE(588)] = 18407,
  [SMALL_STATE(589)] = 18420,
  [SMALL_STATE(590)] = 18433,
  [SMALL_STATE(591)] = 18446,
  [SMALL_STATE(592)] = 18459,
  [SMALL_STATE(593)] = 18472,
  [SMALL_STATE(594)] = 18485,
  [SMALL_STATE(595)] = 18498,
  [SMALL_STATE(596)] = 18511,
  [SMALL_STATE(597)] = 18524,
  [SMALL_STATE(598)] = 18537,
  [SMALL_STATE(599)] = 18550,
  [SMALL_STATE(600)] = 18563,
  [SMALL_STATE(601)] = 18576,
  [SMALL_STATE(602)] = 18589,
  [SMALL_STATE(603)] = 18602,
  [SMALL_STATE(604)] = 18615,
  [SMALL_STATE(605)] = 18628,
  [SMALL_STATE(606)] = 18641,
  [SMALL_STATE(607)] = 18654,
  [SMALL_STATE(608)] = 18667,
  [SMALL_STATE(609)] = 18680,
  [SMALL_STATE(610)] = 18693,
  [SMALL_STATE(611)] = 18706,
  [SMALL_STATE(612)] = 18719,
  [SMALL_STATE(613)] = 18732,
  [SMALL_STATE(614)] = 18745,
  [SMALL_STATE(615)] = 18758,
  [SMALL_STATE(616)] = 18771,
  [SMALL_STATE(617)] = 18784,
  [SMALL_STATE(618)] = 18797,
  [SMALL_STATE(619)] = 18810,
  [SMALL_STATE(620)] = 18823,
  [SMALL_STATE(621)] = 18836,
  [SMALL_STATE(622)] = 18849,
  [SMALL_STATE(623)] = 18862,
  [SMALL_STATE(624)] = 18875,
  [SMALL_STATE(625)] = 18888,
  [SMALL_STATE(626)] = 18901,
  [SMALL_STATE(627)] = 18914,
  [SMALL_STATE(628)] = 18927,
  [SMALL_STATE(629)] = 18940,
  [SMALL_STATE(630)] = 18953,
  [SMALL_STATE(631)] = 18966,
  [SMALL_STATE(632)] = 18979,
  [SMALL_STATE(633)] = 18992,
  [SMALL_STATE(634)] = 19005,
  [SMALL_STATE(635)] = 19018,
  [SMALL_STATE(636)] = 19031,
  [SMALL_STATE(637)] = 19044,
  [SMALL_STATE(638)] = 19057,
  [SMALL_STATE(639)] = 19070,
  [SMALL_STATE(640)] = 19083,
  [SMALL_STATE(641)] = 19096,
  [SMALL_STATE(642)] = 19109,
  [SMALL_STATE(643)] = 19122,
  [SMALL_STATE(644)] = 19135,
  [SMALL_STATE(645)] = 19148,
  [SMALL_STATE(646)] = 19161,
  [SMALL_STATE(647)] = 19174,
  [SMALL_STATE(648)] = 19187,
  [SMALL_STATE(649)] = 19200,
  [SMALL_STATE(650)] = 19213,
  [SMALL_STATE(651)] = 19226,
  [SMALL_STATE(652)] = 19239,
  [SMALL_STATE(653)] = 19252,
  [SMALL_STATE(654)] = 19265,
  [SMALL_STATE(655)] = 19278,
  [SMALL_STATE(656)] = 19291,
  [SMALL_STATE(657)] = 19304,
  [SMALL_STATE(658)] = 19317,
  [SMALL_STATE(659)] = 19330,
  [SMALL_STATE(660)] = 19343,
  [SMALL_STATE(661)] = 19356,
  [SMALL_STATE(662)] = 19369,
  [SMALL_STATE(663)] = 19382,
  [SMALL_STATE(664)] = 19395,
  [SMALL_STATE(665)] = 19408,
  [SMALL_STATE(666)] = 19421,
  [SMALL_STATE(667)] = 19434,
  [SMALL_STATE(668)] = 19447,
  [SMALL_STATE(669)] = 19460,
  [SMALL_STATE(670)] = 19473,
  [SMALL_STATE(671)] = 19486,
  [SMALL_STATE(672)] = 19499,
  [SMALL_STATE(673)] = 19512,
  [SMALL_STATE(674)] = 19525,
  [SMALL_STATE(675)] = 19538,
  [SMALL_STATE(676)] = 19551,
  [SMALL_STATE(677)] = 19564,
  [SMALL_STATE(678)] = 19577,
  [SMALL_STATE(679)] = 19590,
  [SMALL_STATE(680)] = 19603,
  [SMALL_STATE(681)] = 19616,
  [SMALL_STATE(682)] = 19629,
  [SMALL_STATE(683)] = 19642,
};

static const TSParseActionEntry ts_parse_actions[] = {
  [0] = {.entry = {.count = 0, .reusable = false}},
  [1] = {.entry = {.count = 1, .reusable = false}}, RECOVER(),
  [3] = {.entry = {.count = 1, .reusable = true}}, SHIFT(683),
  [5] = {.entry = {.count = 1, .reusable = true}}, SHIFT_EXTRA(),
  [7] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 0),
  [9] = {.entry = {.count = 1, .reusable = false}}, SHIFT(151),
  [11] = {.entry = {.count = 1, .reusable = false}}, SHIFT(181),
  [13] = {.entry = {.count = 1, .reusable = true}}, SHIFT(12),
  [15] = {.entry = {.count = 1, .reusable = true}}, SHIFT(5),
  [17] = {.entry = {.count = 1, .reusable = true}}, SHIFT(334),
  [19] = {.entry = {.count = 1, .reusable = true}}, SHIFT(64),
  [21] = {.entry = {.count = 1, .reusable = false}}, SHIFT(171),
  [23] = {.entry = {.count = 1, .reusable = false}}, SHIFT(165),
  [25] = {.entry = {.count = 1, .reusable = true}}, SHIFT(171),
  [27] = {.entry = {.count = 1, .reusable = true}}, SHIFT(175),
  [29] = {.entry = {.count = 1, .reusable = true}}, SHIFT(514),
  [31] = {.entry = {.count = 1, .reusable = true}}, SHIFT(192),
  [33] = {.entry = {.count = 1, .reusable = true}}, SHIFT(434),
  [35] = {.entry = {.count = 1, .reusable = false}}, SHIFT(193),
  [37] = {.entry = {.count = 1, .reusable = false}}, SHIFT(155),
  [39] = {.entry = {.count = 1, .reusable = false}}, SHIFT(438),
  [41] = {.entry = {.count = 1, .reusable = false}}, SHIFT(682),
  [43] = {.entry = {.count = 1, .reusable = true}}, SHIFT(682),
  [45] = {.entry = {.count = 1, .reusable = false}}, SHIFT(440),
  [47] = {.entry = {.count = 1, .reusable = false}}, SHIFT(149),
  [49] = {.entry = {.count = 1, .reusable = true}}, SHIFT(678),
  [51] = {.entry = {.count = 1, .reusable = true}}, SHIFT(82),
  [53] = {.entry = {.count = 1, .reusable = true}}, SHIFT(516),
  [55] = {.entry = {.count = 1, .reusable = true}}, SHIFT(505),
  [57] = {.entry = {.count = 1, .reusable = true}}, SHIFT(46),
  [59] = {.entry = {.count = 1, .reusable = false}}, SHIFT(64),
  [61] = {.entry = {.count = 1, .reusable = false}}, SHIFT(168),
  [63] = {.entry = {.count = 1, .reusable = false}}, SHIFT(672),
  [65] = {.entry = {.count = 1, .reusable = false}}, SHIFT(670),
  [67] = {.entry = {.count = 1, .reusable = false}}, SHIFT(668),
  [69] = {.entry = {.count = 1, .reusable = false}}, SHIFT(667),
  [71] = {.entry = {.count = 1, .reusable = false}}, SHIFT(375),
  [73] = {.entry = {.count = 1, .reusable = false}}, SHIFT(522),
  [75] = {.entry = {.count = 1, .reusable = true}}, SHIFT(9),
  [77] = {.entry = {.count = 1, .reusable = true}}, SHIFT(638),
  [79] = {.entry = {.count = 1, .reusable = true}}, SHIFT(250),
  [81] = {.entry = {.count = 1, .reusable = false}}, SHIFT(465),
  [83] = {.entry = {.count = 1, .reusable = true}}, SHIFT(427),
  [85] = {.entry = {.count = 1, .reusable = true}}, SHIFT(354),
  [87] = {.entry = {.count = 1, .reusable = true}}, SHIFT(626),
  [89] = {.entry = {.count = 1, .reusable = true}}, SHIFT(595),
  [91] = {.entry = {.count = 1, .reusable = true}}, SHIFT(639),
  [93] = {.entry = {.count = 1, .reusable = true}}, SHIFT(110),
  [95] = {.entry = {.count = 1, .reusable = false}}, SHIFT(162),
  [97] = {.entry = {.count = 1, .reusable = true}}, SHIFT(194),
  [99] = {.entry = {.count = 1, .reusable = true}}, SHIFT(2),
  [101] = {.entry = {.count = 1, .reusable = false}}, SHIFT(280),
  [103] = {.entry = {.count = 1, .reusable = false}}, SHIFT(255),
  [105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(280),
  [107] = {.entry = {.count = 1, .reusable = true}}, SHIFT(386),
  [109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(143),
  [111] = {.entry = {.count = 1, .reusable = true}}, SHIFT(113),
  [113] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2),
  [115] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(151),
  [118] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(181),
  [121] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(12),
  [124] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(5),
  [127] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(334),
  [130] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(64),
  [133] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(171),
  [136] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(165),
  [139] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(171),
  [142] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(175),
  [145] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(514),
  [148] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(192),
  [151] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(434),
  [154] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(193),
  [157] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(155),
  [160] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(438),
  [163] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(682),
  [166] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(682),
  [169] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(440),
  [172] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(149),
  [175] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(678),
  [178] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(82),
  [181] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(516),
  [184] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(505),
  [187] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(46),
  [190] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(64),
  [193] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(168),
  [196] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(672),
  [199] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(670),
  [202] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(668),
  [205] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(667),
  [208] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(375),
  [211] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 2), SHIFT_REPEAT(522),
  [214] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_source_file, 1),
  [216] = {.entry = {.count = 1, .reusable = true}}, SHIFT(589),
  [218] = {.entry = {.count = 1, .reusable = true}}, SHIFT(224),
  [220] = {.entry = {.count = 1, .reusable = true}}, SHIFT(105),
  [222] = {.entry = {.count = 1, .reusable = true}}, SHIFT(141),
  [224] = {.entry = {.count = 1, .reusable = true}}, SHIFT(142),
  [226] = {.entry = {.count = 1, .reusable = true}}, SHIFT(640),
  [228] = {.entry = {.count = 1, .reusable = true}}, SHIFT(630),
  [230] = {.entry = {.count = 1, .reusable = true}}, SHIFT(602),
  [232] = {.entry = {.count = 1, .reusable = true}}, SHIFT(349),
  [234] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(151),
  [237] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(181),
  [240] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(9),
  [243] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(5),
  [246] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(334),
  [249] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(64),
  [252] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(171),
  [255] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(165),
  [258] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(171),
  [261] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(175),
  [264] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(514),
  [267] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(192),
  [270] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(434),
  [273] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(193),
  [276] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(155),
  [279] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(438),
  [282] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(682),
  [285] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(682),
  [288] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(440),
  [291] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(149),
  [294] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(678),
  [297] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(82),
  [300] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(505),
  [303] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(46),
  [306] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(64),
  [309] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(168),
  [312] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(672),
  [315] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(670),
  [318] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(668),
  [321] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(667),
  [324] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(375),
  [327] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2), SHIFT_REPEAT(522),
  [330] = {.entry = {.count = 1, .reusable = false}}, SHIFT(177),
  [332] = {.entry = {.count = 1, .reusable = true}}, SHIFT(184),
  [334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(241),
  [336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(232),
  [338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(190),
  [340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(183),
  [342] = {.entry = {.count = 1, .reusable = true}}, SHIFT(253),
  [344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(380),
  [346] = {.entry = {.count = 1, .reusable = true}}, SHIFT(387),
  [348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_associative_sequence, 2),
  [350] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__collection_sequence, 2),
  [352] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_associative_sequence, 3),
  [354] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__collection_sequence, 3),
  [356] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(258),
  [359] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(181),
  [362] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(9),
  [365] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(5),
  [368] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(71),
  [371] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(171),
  [374] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(165),
  [377] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(171),
  [380] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(304),
  [383] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(514),
  [386] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(192),
  [389] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(434),
  [392] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(193),
  [395] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(155),
  [398] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(438),
  [401] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(682),
  [404] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(682),
  [407] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(440),
  [410] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(149),
  [413] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(678),
  [416] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(505),
  [419] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(46),
  [422] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(71),
  [425] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(168),
  [428] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(672),
  [431] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(670),
  [434] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(668),
  [437] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(667),
  [440] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(375),
  [443] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), SHIFT_REPEAT(520),
  [446] = {.entry = {.count = 1, .reusable = false}}, SHIFT(258),
  [448] = {.entry = {.count = 1, .reusable = true}}, SHIFT(71),
  [450] = {.entry = {.count = 1, .reusable = true}}, SHIFT(304),
  [452] = {.entry = {.count = 1, .reusable = false}}, SHIFT(71),
  [454] = {.entry = {.count = 1, .reusable = false}}, SHIFT(520),
  [456] = {.entry = {.count = 1, .reusable = true}}, SHIFT(95),
  [458] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_content, 4),
  [460] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_content, 4),
  [462] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_content, 3),
  [464] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_content, 3),
  [466] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_block, 2, .production_id = 5),
  [468] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_block, 2, .production_id = 5),
  [470] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_content, 5),
  [472] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_content, 5),
  [474] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2),
  [476] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch, 5, .production_id = 1),
  [478] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch, 5, .production_id = 1),
  [480] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2),
  [482] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), REDUCE(sym_switch, 5, .production_id = 1),
  [485] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_content, 6),
  [487] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_content, 6),
  [489] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__function_content, 2),
  [491] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__function_content, 2),
  [493] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch, 4, .production_id = 1),
  [495] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch, 4, .production_id = 1),
  [497] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_switch_repeat2, 2), REDUCE(sym_switch, 4, .production_id = 1),
  [500] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_block, 1),
  [502] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_block, 1),
  [504] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_code_block, 2),
  [506] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_code_block, 2),
  [508] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 1),
  [510] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 1),
  [512] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__object, 1),
  [514] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__object, 1),
  [516] = {.entry = {.count = 2, .reusable = false}}, REDUCE(sym__expression, 1), REDUCE(sym__object, 1),
  [519] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_code_block, 3),
  [521] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_code_block, 3),
  [523] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), REDUCE(sym_switch, 5, .production_id = 1),
  [526] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat2, 2), REDUCE(sym_switch, 4, .production_id = 1),
  [529] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter_list, 3),
  [531] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 3),
  [533] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_def, 5, .production_id = 30),
  [535] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_def, 5, .production_id = 30),
  [537] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter_list, 5),
  [539] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 5),
  [541] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_def, 3),
  [543] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_def, 3),
  [545] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_def, 7, .production_id = 32),
  [547] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_def, 7, .production_id = 32),
  [549] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym__expression_sequence_repeat1, 2),
  [551] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__expression_sequence_repeat1, 2),
  [553] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_sequence, 3),
  [555] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter_list, 2),
  [557] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 2),
  [559] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_sequence, 2),
  [561] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter_list, 6),
  [563] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 6),
  [565] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_def, 5),
  [567] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_def, 5),
  [569] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_source_file_repeat1, 1),
  [571] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_source_file_repeat1, 1),
  [573] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_def, 6, .production_id = 30),
  [575] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_def, 6, .production_id = 30),
  [577] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_def, 4),
  [579] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_def, 4),
  [581] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression, 2),
  [583] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__expression, 2),
  [585] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class_def, 6, .production_id = 32),
  [587] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class_def, 6, .production_id = 32),
  [589] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_parameter_list, 4),
  [591] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_list, 4),
  [593] = {.entry = {.count = 1, .reusable = true}}, SHIFT(166),
  [595] = {.entry = {.count = 1, .reusable = true}}, SHIFT(584),
  [597] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__index, 5, .production_id = 37),
  [599] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__index, 5, .production_id = 37),
  [601] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_indexed_collection, 2, .production_id = 8),
  [603] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_indexed_collection, 2, .production_id = 8),
  [605] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_indexed_collection_repeat1, 1, .production_id = 7),
  [607] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_environment_var, 1, .production_id = 1),
  [609] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_environment_var, 1, .production_id = 1),
  [611] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_local_var, 2, .production_id = 3),
  [613] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_local_var, 2, .production_id = 3),
  [615] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_local_var, 1, .production_id = 1),
  [617] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_local_var, 1, .production_id = 1),
  [619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(31),
  [621] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__index, 3, .production_id = 15),
  [623] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__index, 3, .production_id = 15),
  [625] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_indexed_collection, 3, .production_id = 16),
  [627] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_indexed_collection, 3, .production_id = 16),
  [629] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__index, 2, .production_id = 15),
  [631] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__index, 2, .production_id = 15),
  [633] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_builtin_var, 1, .production_id = 1),
  [635] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_builtin_var, 1, .production_id = 1),
  [637] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_variable, 1),
  [639] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable, 1),
  [641] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_var, 2, .production_id = 3),
  [643] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_var, 2, .production_id = 3),
  [645] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_classvar, 2, .production_id = 3),
  [647] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_classvar, 2, .production_id = 3),
  [649] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_environment_var, 2, .production_id = 4),
  [651] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_environment_var, 2, .production_id = 4),
  [653] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym__index, 4, .production_id = 27),
  [655] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__index, 4, .production_id = 27),
  [657] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_classvar, 3, .production_id = 9),
  [659] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_classvar, 3, .production_id = 9),
  [661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(67),
  [663] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_var, 3, .production_id = 9),
  [665] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_var, 3, .production_id = 9),
  [667] = {.entry = {.count = 1, .reusable = false}}, SHIFT(66),
  [669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(333),
  [671] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 1),
  [673] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 1),
  [675] = {.entry = {.count = 1, .reusable = false}}, SHIFT(659),
  [677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(656),
  [679] = {.entry = {.count = 1, .reusable = false}}, SHIFT(390),
  [681] = {.entry = {.count = 1, .reusable = false}}, SHIFT(370),
  [683] = {.entry = {.count = 1, .reusable = false}}, SHIFT(501),
  [685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(370),
  [687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(378),
  [689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(600),
  [691] = {.entry = {.count = 1, .reusable = false}}, SHIFT(174),
  [693] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 1),
  [695] = {.entry = {.count = 1, .reusable = false}}, SHIFT(266),
  [697] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 1),
  [699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(28),
  [701] = {.entry = {.count = 1, .reusable = false}}, SHIFT(398),
  [703] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_class, 1, .production_id = 1),
  [705] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_class, 1, .production_id = 1),
  [707] = {.entry = {.count = 1, .reusable = false}}, SHIFT(509),
  [709] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 5, .production_id = 26),
  [711] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 5, .production_id = 26),
  [713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(645),
  [715] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_symbol, 3),
  [717] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_symbol, 3),
  [719] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_symbol, 2),
  [721] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_symbol, 2),
  [723] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 2, .production_id = 12),
  [725] = {.entry = {.count = 1, .reusable = false}}, SHIFT(264),
  [727] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 2, .production_id = 12),
  [729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(27),
  [731] = {.entry = {.count = 1, .reusable = false}}, SHIFT(173),
  [733] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_symbol, 1),
  [735] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_symbol, 1),
  [737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(173),
  [739] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_number, 2),
  [741] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_number, 2),
  [743] = {.entry = {.count = 1, .reusable = false}}, SHIFT(99),
  [745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(99),
  [747] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_literal, 1),
  [749] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_literal, 1),
  [751] = {.entry = {.count = 1, .reusable = false}}, SHIFT(176),
  [753] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 4, .production_id = 19),
  [755] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 4, .production_id = 19),
  [757] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 4),
  [759] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 4),
  [761] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_partial, 1),
  [763] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_partial, 1),
  [765] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch, 12, .production_id = 1),
  [767] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch, 12, .production_id = 1),
  [769] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 3, .production_id = 5),
  [771] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 3, .production_id = 5),
  [773] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 4, .production_id = 12),
  [775] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 4, .production_id = 12),
  [777] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unary_expression, 2, .production_id = 2),
  [779] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_unary_expression, 2, .production_id = 2),
  [781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(87),
  [783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(70),
  [785] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_collection, 5, .production_id = 24),
  [787] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_collection, 5, .production_id = 24),
  [789] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 4),
  [791] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 4),
  [793] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch, 15, .production_id = 1),
  [795] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch, 15, .production_id = 1),
  [797] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [799] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 2, .production_id = 6),
  [801] = {.entry = {.count = 1, .reusable = false}}, SHIFT(170),
  [803] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_variable_setter_call, 4),
  [805] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_variable_setter_call, 4),
  [807] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arithmetic_series, 7),
  [809] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arithmetic_series, 7),
  [811] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_bool, 1),
  [813] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_bool, 1),
  [815] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case, 3, .production_id = 1),
  [817] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case, 3, .production_id = 1),
  [819] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch, 11, .production_id = 1),
  [821] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch, 11, .production_id = 1),
  [823] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch, 14, .production_id = 1),
  [825] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch, 14, .production_id = 1),
  [827] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_collection, 3),
  [829] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_collection, 3),
  [831] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_control_structure, 1),
  [833] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_control_structure, 1),
  [835] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arithmetic_series, 5),
  [837] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arithmetic_series, 5),
  [839] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 2),
  [841] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 2),
  [843] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_binary_expression, 3, .production_id = 11),
  [845] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_binary_expression, 3, .production_id = 11),
  [847] = {.entry = {.count = 1, .reusable = false}}, SHIFT(167),
  [849] = {.entry = {.count = 1, .reusable = false}}, SHIFT(98),
  [851] = {.entry = {.count = 1, .reusable = false}}, SHIFT(96),
  [853] = {.entry = {.count = 1, .reusable = false}}, SHIFT(92),
  [855] = {.entry = {.count = 1, .reusable = false}}, SHIFT(90),
  [857] = {.entry = {.count = 1, .reusable = true}}, SHIFT(89),
  [859] = {.entry = {.count = 1, .reusable = true}}, SHIFT(85),
  [861] = {.entry = {.count = 1, .reusable = true}}, SHIFT(79),
  [863] = {.entry = {.count = 1, .reusable = false}}, SHIFT(78),
  [865] = {.entry = {.count = 1, .reusable = true}}, SHIFT(96),
  [867] = {.entry = {.count = 1, .reusable = true}}, SHIFT(73),
  [869] = {.entry = {.count = 1, .reusable = true}}, SHIFT(92),
  [871] = {.entry = {.count = 1, .reusable = true}}, SHIFT(90),
  [873] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_string, 3),
  [875] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_string, 3),
  [877] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 2),
  [879] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 2),
  [881] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_association, 3),
  [883] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_association, 3),
  [885] = {.entry = {.count = 1, .reusable = false}}, SHIFT(100),
  [887] = {.entry = {.count = 1, .reusable = false}}, SHIFT(69),
  [889] = {.entry = {.count = 1, .reusable = true}}, SHIFT(69),
  [891] = {.entry = {.count = 1, .reusable = true}}, SHIFT(416),
  [893] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_nil_check, 3),
  [895] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_nil_check, 3),
  [897] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while, 3, .production_id = 13),
  [899] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while, 3, .production_id = 13),
  [901] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_call_repeat1, 2),
  [903] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_call_repeat1, 2),
  [905] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_repeat1, 2), SHIFT_REPEAT(170),
  [908] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch, 13, .production_id = 1),
  [910] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch, 13, .production_id = 1),
  [912] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_collection, 4, .production_id = 22),
  [914] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_collection, 4, .production_id = 22),
  [916] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_function_call_repeat1, 1),
  [918] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_function_call_repeat1, 1),
  [920] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_forby, 10, .production_id = 1),
  [922] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_forby, 10, .production_id = 1),
  [924] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 6, .production_id = 33),
  [926] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 6, .production_id = 33),
  [928] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_collection, 4),
  [930] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_collection, 4),
  [932] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_collection, 1),
  [934] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_collection, 1),
  [936] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 6, .production_id = 34),
  [938] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 6, .production_id = 34),
  [940] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_while, 6, .production_id = 35),
  [942] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_while, 6, .production_id = 35),
  [944] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 3),
  [946] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 3),
  [948] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_switch, 9, .production_id = 1),
  [950] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_switch, 9, .production_id = 1),
  [952] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_forby, 9, .production_id = 3),
  [954] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_forby, 9, .production_id = 3),
  [956] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 3, .production_id = 12),
  [958] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 3, .production_id = 12),
  [960] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 8, .production_id = 39),
  [962] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 8, .production_id = 39),
  [964] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for, 8),
  [966] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for, 8),
  [968] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 8, .production_id = 38),
  [970] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 8, .production_id = 38),
  [972] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 3),
  [974] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 3),
  [976] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_if, 6, .production_id = 36),
  [978] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_if, 6, .production_id = 36),
  [980] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_for, 7),
  [982] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_for, 7),
  [984] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_case, 2, .production_id = 1),
  [986] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_case, 2, .production_id = 1),
  [988] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_variable_setter_call, 6, .production_id = 12),
  [990] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_variable_setter_call, 6, .production_id = 12),
  [992] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_arithmetic_series, 4),
  [994] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_arithmetic_series, 4),
  [996] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_function_call, 4, .production_id = 5),
  [998] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_call, 4, .production_id = 5),
  [1000] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_variable_setter_call, 5),
  [1002] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_variable_setter_call, 5),
  [1004] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_variable_setter_call, 5, .production_id = 12),
  [1006] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_variable_setter_call, 5, .production_id = 12),
  [1008] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_method_call, 5, .production_id = 12),
  [1010] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_method_call, 5, .production_id = 12),
  [1012] = {.entry = {.count = 1, .reusable = true}}, SHIFT(29),
  [1014] = {.entry = {.count = 1, .reusable = true}}, SHIFT(40),
  [1016] = {.entry = {.count = 1, .reusable = false}}, SHIFT(488),
  [1018] = {.entry = {.count = 1, .reusable = false}}, SHIFT(65),
  [1020] = {.entry = {.count = 1, .reusable = true}}, SHIFT(674),
  [1022] = {.entry = {.count = 1, .reusable = false}}, SHIFT(269),
  [1024] = {.entry = {.count = 1, .reusable = true}}, SHIFT(8),
  [1026] = {.entry = {.count = 1, .reusable = false}}, SHIFT(68),
  [1028] = {.entry = {.count = 1, .reusable = false}}, SHIFT(101),
  [1030] = {.entry = {.count = 1, .reusable = false}}, SHIFT(102),
  [1032] = {.entry = {.count = 1, .reusable = false}}, SHIFT(103),
  [1034] = {.entry = {.count = 1, .reusable = true}}, SHIFT(62),
  [1036] = {.entry = {.count = 1, .reusable = true}}, SHIFT(94),
  [1038] = {.entry = {.count = 1, .reusable = true}}, SHIFT(93),
  [1040] = {.entry = {.count = 1, .reusable = true}}, SHIFT(84),
  [1042] = {.entry = {.count = 1, .reusable = false}}, SHIFT(83),
  [1044] = {.entry = {.count = 1, .reusable = true}}, SHIFT(101),
  [1046] = {.entry = {.count = 1, .reusable = true}}, SHIFT(80),
  [1048] = {.entry = {.count = 1, .reusable = true}}, SHIFT(102),
  [1050] = {.entry = {.count = 1, .reusable = true}}, SHIFT(103),
  [1052] = {.entry = {.count = 1, .reusable = true}}, SHIFT(75),
  [1054] = {.entry = {.count = 1, .reusable = false}}, SHIFT(74),
  [1056] = {.entry = {.count = 1, .reusable = true}}, SHIFT(74),
  [1058] = {.entry = {.count = 1, .reusable = false}}, SHIFT(487),
  [1060] = {.entry = {.count = 1, .reusable = true}}, SHIFT(680),
  [1062] = {.entry = {.count = 1, .reusable = true}}, SHIFT(10),
  [1064] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_statement, 1),
  [1066] = {.entry = {.count = 1, .reusable = false}}, SHIFT(61),
  [1068] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_variable_setter_call, 3, .production_id = 12),
  [1070] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_variable_setter_call, 3, .production_id = 12),
  [1072] = {.entry = {.count = 1, .reusable = true}}, SHIFT(32),
  [1074] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_definition, 3, .production_id = 14),
  [1076] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_instance_variable_setter_call, 2),
  [1078] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_instance_variable_setter_call, 2),
  [1080] = {.entry = {.count = 1, .reusable = true}}, SHIFT(30),
  [1082] = {.entry = {.count = 1, .reusable = true}}, SHIFT(60),
  [1084] = {.entry = {.count = 1, .reusable = true}}, SHIFT(47),
  [1086] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__collection_sequence, 1),
  [1088] = {.entry = {.count = 1, .reusable = false}}, SHIFT(308),
  [1090] = {.entry = {.count = 1, .reusable = false}}, SHIFT(324),
  [1092] = {.entry = {.count = 1, .reusable = true}}, SHIFT(347),
  [1094] = {.entry = {.count = 1, .reusable = true}}, SHIFT(529),
  [1096] = {.entry = {.count = 1, .reusable = true}}, SHIFT(358),
  [1098] = {.entry = {.count = 1, .reusable = true}}, SHIFT(356),
  [1100] = {.entry = {.count = 1, .reusable = true}}, SHIFT(365),
  [1102] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_function_call_repeat1, 2), SHIFT_REPEAT(296),
  [1105] = {.entry = {.count = 1, .reusable = true}}, SHIFT(383),
  [1107] = {.entry = {.count = 1, .reusable = false}}, SHIFT(283),
  [1109] = {.entry = {.count = 1, .reusable = true}}, SHIFT(384),
  [1111] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_duplicated_statement, 3, .production_id = 10),
  [1113] = {.entry = {.count = 1, .reusable = false}}, SHIFT(296),
  [1115] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_associative_item, 3, .production_id = 18),
  [1117] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_return_statement, 2),
  [1119] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat1, 4, .production_id = 29),
  [1121] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat1, 4),
  [1123] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_unnamed_argument, 1),
  [1125] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_associative_item, 1),
  [1127] = {.entry = {.count = 1, .reusable = true}}, SHIFT(411),
  [1129] = {.entry = {.count = 1, .reusable = true}}, SHIFT(410),
  [1131] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__collection_sequence_repeat1, 2),
  [1133] = {.entry = {.count = 1, .reusable = false}}, SHIFT(325),
  [1135] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_named_argument, 3, .production_id = 25),
  [1137] = {.entry = {.count = 1, .reusable = true}}, SHIFT(412),
  [1139] = {.entry = {.count = 1, .reusable = true}}, SHIFT(397),
  [1141] = {.entry = {.count = 1, .reusable = true}}, SHIFT(417),
  [1143] = {.entry = {.count = 1, .reusable = true}}, SHIFT(406),
  [1145] = {.entry = {.count = 1, .reusable = true}}, SHIFT(402),
  [1147] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_function_definition, 3, .production_id = 14),
  [1149] = {.entry = {.count = 1, .reusable = true}}, SHIFT(393),
  [1151] = {.entry = {.count = 1, .reusable = true}}, SHIFT(391),
  [1153] = {.entry = {.count = 1, .reusable = true}}, SHIFT(381),
  [1155] = {.entry = {.count = 1, .reusable = true}}, SHIFT(389),
  [1157] = {.entry = {.count = 1, .reusable = true}}, SHIFT(35),
  [1159] = {.entry = {.count = 1, .reusable = true}}, SHIFT(193),
  [1161] = {.entry = {.count = 1, .reusable = true}}, SHIFT(168),
  [1163] = {.entry = {.count = 1, .reusable = true}}, SHIFT(36),
  [1165] = {.entry = {.count = 1, .reusable = true}}, SHIFT(372),
  [1167] = {.entry = {.count = 1, .reusable = true}}, SHIFT(557),
  [1169] = {.entry = {.count = 1, .reusable = true}}, SHIFT(461),
  [1171] = {.entry = {.count = 1, .reusable = true}}, SHIFT(432),
  [1173] = {.entry = {.count = 1, .reusable = true}}, SHIFT(462),
  [1175] = {.entry = {.count = 1, .reusable = true}}, SHIFT(504),
  [1177] = {.entry = {.count = 1, .reusable = true}}, SHIFT(41),
  [1179] = {.entry = {.count = 1, .reusable = true}}, SHIFT(33),
  [1181] = {.entry = {.count = 1, .reusable = true}}, SHIFT(418),
  [1183] = {.entry = {.count = 1, .reusable = false}}, SHIFT(418),
  [1185] = {.entry = {.count = 1, .reusable = true}}, SHIFT(374),
  [1187] = {.entry = {.count = 1, .reusable = true}}, SHIFT(537),
  [1189] = {.entry = {.count = 1, .reusable = true}}, SHIFT(479),
  [1191] = {.entry = {.count = 1, .reusable = true}}, SHIFT(457),
  [1193] = {.entry = {.count = 1, .reusable = true}}, SHIFT(475),
  [1195] = {.entry = {.count = 1, .reusable = true}}, SHIFT(506),
  [1197] = {.entry = {.count = 1, .reusable = true}}, SHIFT(39),
  [1199] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 2), SHIFT_REPEAT(368),
  [1202] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 2), SHIFT_REPEAT(359),
  [1205] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 2),
  [1207] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 2), SHIFT_REPEAT(438),
  [1210] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 2), SHIFT_REPEAT(682),
  [1213] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 2), SHIFT_REPEAT(682),
  [1216] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 2), SHIFT_REPEAT(440),
  [1219] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 2), SHIFT_REPEAT(439),
  [1222] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 2), SHIFT_REPEAT(596),
  [1225] = {.entry = {.count = 1, .reusable = false}}, SHIFT(368),
  [1227] = {.entry = {.count = 1, .reusable = true}}, SHIFT(359),
  [1229] = {.entry = {.count = 1, .reusable = true}}, SHIFT(131),
  [1231] = {.entry = {.count = 1, .reusable = false}}, SHIFT(439),
  [1233] = {.entry = {.count = 1, .reusable = true}}, SHIFT(596),
  [1235] = {.entry = {.count = 1, .reusable = true}}, SHIFT(133),
  [1237] = {.entry = {.count = 1, .reusable = true}}, SHIFT(119),
  [1239] = {.entry = {.count = 1, .reusable = true}}, SHIFT(122),
  [1241] = {.entry = {.count = 1, .reusable = true}}, SHIFT(130),
  [1243] = {.entry = {.count = 1, .reusable = true}}, SHIFT(121),
  [1245] = {.entry = {.count = 1, .reusable = true}}, SHIFT(128),
  [1247] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 3, .production_id = 21),
  [1249] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 3, .production_id = 21),
  [1251] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 4),
  [1253] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 4),
  [1255] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 1),
  [1257] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 1),
  [1259] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 2, .production_id = 20),
  [1261] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 2, .production_id = 20),
  [1263] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 2, .production_id = 21),
  [1265] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 2, .production_id = 21),
  [1267] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 2),
  [1269] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 3),
  [1271] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 3),
  [1273] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 3, .production_id = 28),
  [1275] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 3, .production_id = 28),
  [1277] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 4, .production_id = 21),
  [1279] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 4, .production_id = 21),
  [1281] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 5),
  [1283] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 5),
  [1285] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_class_def_repeat2, 5, .production_id = 21),
  [1287] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat2, 5, .production_id = 21),
  [1289] = {.entry = {.count = 1, .reusable = true}}, SHIFT(496),
  [1291] = {.entry = {.count = 1, .reusable = true}}, SHIFT(646),
  [1293] = {.entry = {.count = 1, .reusable = true}}, SHIFT(3),
  [1295] = {.entry = {.count = 1, .reusable = true}}, SHIFT(369),
  [1297] = {.entry = {.count = 1, .reusable = true}}, SHIFT(470),
  [1299] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_case_repeat1, 2), SHIFT_REPEAT(496),
  [1302] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_case_repeat1, 2),
  [1304] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_case_repeat1, 2), SHIFT_REPEAT(646),
  [1307] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_case_repeat1, 2), SHIFT_REPEAT(3),
  [1310] = {.entry = {.count = 1, .reusable = false}}, SHIFT(464),
  [1312] = {.entry = {.count = 1, .reusable = true}}, SHIFT(464),
  [1314] = {.entry = {.count = 1, .reusable = false}}, SHIFT(683),
  [1316] = {.entry = {.count = 1, .reusable = true}}, SHIFT(246),
  [1318] = {.entry = {.count = 1, .reusable = true}}, SHIFT(195),
  [1320] = {.entry = {.count = 1, .reusable = false}}, SHIFT(337),
  [1322] = {.entry = {.count = 1, .reusable = false}}, SHIFT(339),
  [1324] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 1, .production_id = 1),
  [1326] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 1, .production_id = 1),
  [1328] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indexed_collection_repeat1, 2, .production_id = 17), SHIFT_REPEAT(166),
  [1331] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_indexed_collection_repeat1, 2, .production_id = 17), SHIFT_REPEAT(584),
  [1334] = {.entry = {.count = 1, .reusable = true}}, SHIFT(335),
  [1336] = {.entry = {.count = 1, .reusable = true}}, SHIFT(338),
  [1338] = {.entry = {.count = 1, .reusable = true}}, SHIFT(509),
  [1340] = {.entry = {.count = 1, .reusable = true}}, SHIFT(405),
  [1342] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_definition_sequence, 3),
  [1344] = {.entry = {.count = 1, .reusable = true}}, SHIFT(88),
  [1346] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_variable_definition_sequence_repeat1, 2),
  [1348] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_definition_sequence, 4),
  [1350] = {.entry = {.count = 1, .reusable = false}}, SHIFT(543),
  [1352] = {.entry = {.count = 1, .reusable = false}}, SHIFT(513),
  [1354] = {.entry = {.count = 1, .reusable = false}}, SHIFT(118),
  [1356] = {.entry = {.count = 1, .reusable = true}}, SHIFT(543),
  [1358] = {.entry = {.count = 1, .reusable = false}}, SHIFT(423),
  [1360] = {.entry = {.count = 1, .reusable = false}}, SHIFT(552),
  [1362] = {.entry = {.count = 1, .reusable = false}}, SHIFT(134),
  [1364] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_parameter_list_repeat2, 2), SHIFT_REPEAT(543),
  [1367] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_parameter_list_repeat2, 2),
  [1369] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat2, 2), SHIFT_REPEAT(543),
  [1372] = {.entry = {.count = 1, .reusable = true}}, SHIFT(362),
  [1374] = {.entry = {.count = 1, .reusable = true}}, SHIFT(86),
  [1376] = {.entry = {.count = 1, .reusable = true}}, SHIFT(382),
  [1378] = {.entry = {.count = 1, .reusable = true}}, SHIFT(536),
  [1380] = {.entry = {.count = 1, .reusable = true}}, SHIFT(125),
  [1382] = {.entry = {.count = 1, .reusable = false}}, SHIFT(471),
  [1384] = {.entry = {.count = 1, .reusable = true}}, SHIFT(484),
  [1386] = {.entry = {.count = 1, .reusable = false}}, SHIFT(484),
  [1388] = {.entry = {.count = 1, .reusable = false}}, SHIFT(467),
  [1390] = {.entry = {.count = 1, .reusable = false}}, SHIFT(201),
  [1392] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 3, .production_id = 23),
  [1394] = {.entry = {.count = 1, .reusable = true}}, SHIFT(361),
  [1396] = {.entry = {.count = 1, .reusable = true}}, SHIFT(81),
  [1398] = {.entry = {.count = 1, .reusable = true}}, SHIFT(150),
  [1400] = {.entry = {.count = 1, .reusable = false}}, SHIFT(654),
  [1402] = {.entry = {.count = 1, .reusable = true}}, SHIFT(654),
  [1404] = {.entry = {.count = 1, .reusable = true}}, SHIFT(572),
  [1406] = {.entry = {.count = 1, .reusable = false}}, SHIFT(573),
  [1408] = {.entry = {.count = 1, .reusable = true}}, SHIFT(573),
  [1410] = {.entry = {.count = 1, .reusable = true}}, SHIFT(158),
  [1412] = {.entry = {.count = 1, .reusable = false}}, SHIFT(652),
  [1414] = {.entry = {.count = 1, .reusable = true}}, SHIFT(652),
  [1416] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2),
  [1418] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat1, 2), SHIFT_REPEAT(547),
  [1421] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_list_repeat2, 2),
  [1423] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 3, .production_id = 23),
  [1425] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2),
  [1427] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(484),
  [1430] = {.entry = {.count = 2, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 2), SHIFT_REPEAT(484),
  [1433] = {.entry = {.count = 1, .reusable = false}}, SHIFT(454),
  [1435] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument, 4, .production_id = 31),
  [1437] = {.entry = {.count = 1, .reusable = true}}, SHIFT(118),
  [1439] = {.entry = {.count = 1, .reusable = true}}, SHIFT(547),
  [1441] = {.entry = {.count = 1, .reusable = true}}, SHIFT(546),
  [1443] = {.entry = {.count = 1, .reusable = false}}, SHIFT(435),
  [1445] = {.entry = {.count = 1, .reusable = true}}, SHIFT(388),
  [1447] = {.entry = {.count = 1, .reusable = true}}, SHIFT(535),
  [1449] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_variable_definition_sequence, 2),
  [1451] = {.entry = {.count = 1, .reusable = true}}, SHIFT(134),
  [1453] = {.entry = {.count = 1, .reusable = true}}, SHIFT(554),
  [1455] = {.entry = {.count = 1, .reusable = false}}, SHIFT(204),
  [1457] = {.entry = {.count = 1, .reusable = false}}, REDUCE(sym_argument, 4, .production_id = 31),
  [1459] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_case_repeat1, 1),
  [1461] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__paired_associative_sequence, 1),
  [1463] = {.entry = {.count = 1, .reusable = true}}, SHIFT(44),
  [1465] = {.entry = {.count = 1, .reusable = true}}, SHIFT(363),
  [1467] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat1, 2, .production_id = 29),
  [1469] = {.entry = {.count = 1, .reusable = true}}, SHIFT(91),
  [1471] = {.entry = {.count = 1, .reusable = false}}, REDUCE(aux_sym_string_repeat1, 1),
  [1473] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_string_repeat1, 1),
  [1475] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_class_def_repeat1, 2),
  [1477] = {.entry = {.count = 1, .reusable = true}}, SHIFT(63),
  [1479] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_class_def_repeat1, 2), SHIFT_REPEAT(356),
  [1482] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_parameter_call_list_repeat1, 2),
  [1484] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_parameter_call_list_repeat1, 2), SHIFT_REPEAT(34),
  [1487] = {.entry = {.count = 1, .reusable = true}}, SHIFT(367),
  [1489] = {.entry = {.count = 1, .reusable = true}}, SHIFT(123),
  [1491] = {.entry = {.count = 1, .reusable = true}}, SHIFT(48),
  [1493] = {.entry = {.count = 1, .reusable = true}}, SHIFT(126),
  [1495] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym__expression_sequence, 1),
  [1497] = {.entry = {.count = 1, .reusable = true}}, SHIFT(366),
  [1499] = {.entry = {.count = 1, .reusable = true}}, SHIFT(357),
  [1501] = {.entry = {.count = 1, .reusable = true}}, SHIFT(52),
  [1503] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_call_list, 1),
  [1505] = {.entry = {.count = 1, .reusable = true}}, SHIFT(34),
  [1507] = {.entry = {.count = 1, .reusable = true}}, SHIFT(545),
  [1509] = {.entry = {.count = 1, .reusable = true}}, SHIFT(332),
  [1511] = {.entry = {.count = 1, .reusable = true}}, SHIFT(37),
  [1513] = {.entry = {.count = 1, .reusable = true}}, SHIFT(38),
  [1515] = {.entry = {.count = 1, .reusable = true}}, SHIFT(49),
  [1517] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_parameter_call_list, 2),
  [1519] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__collection_sequence_repeat1, 2), SHIFT_REPEAT(54),
  [1522] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym__paired_associative_sequence_repeat1, 2),
  [1524] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym__paired_associative_sequence_repeat1, 2), SHIFT_REPEAT(58),
  [1527] = {.entry = {.count = 1, .reusable = false}}, SHIFT(655),
  [1529] = {.entry = {.count = 1, .reusable = true}}, SHIFT(392),
  [1531] = {.entry = {.count = 1, .reusable = true}}, SHIFT(394),
  [1533] = {.entry = {.count = 1, .reusable = true}}, SHIFT(72),
  [1535] = {.entry = {.count = 1, .reusable = true}}, SHIFT(182),
  [1537] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat1, 4), SHIFT(396),
  [1540] = {.entry = {.count = 1, .reusable = true}}, SHIFT(18),
  [1542] = {.entry = {.count = 1, .reusable = true}}, SHIFT(233),
  [1544] = {.entry = {.count = 1, .reusable = true}}, SHIFT(407),
  [1546] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat1, 2), SHIFT_REPEAT(77),
  [1549] = {.entry = {.count = 1, .reusable = true}}, SHIFT(220),
  [1551] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_switch_repeat1, 4), SHIFT(395),
  [1554] = {.entry = {.count = 1, .reusable = true}}, SHIFT(76),
  [1556] = {.entry = {.count = 1, .reusable = true}}, SHIFT(346),
  [1558] = {.entry = {.count = 1, .reusable = true}}, SHIFT(512),
  [1560] = {.entry = {.count = 1, .reusable = true}}, SHIFT(331),
  [1562] = {.entry = {.count = 1, .reusable = true}}, SHIFT(191),
  [1564] = {.entry = {.count = 1, .reusable = true}}, SHIFT(248),
  [1566] = {.entry = {.count = 1, .reusable = true}}, SHIFT(428),
  [1568] = {.entry = {.count = 1, .reusable = true}}, SHIFT(443),
  [1570] = {.entry = {.count = 1, .reusable = true}}, SHIFT(450),
  [1572] = {.entry = {.count = 1, .reusable = true}}, SHIFT(502),
  [1574] = {.entry = {.count = 1, .reusable = false}}, SHIFT(560),
  [1576] = {.entry = {.count = 1, .reusable = true}}, SHIFT(480),
  [1578] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_argument_calls, 1),
  [1580] = {.entry = {.count = 1, .reusable = true}}, SHIFT(453),
  [1582] = {.entry = {.count = 1, .reusable = true}}, SHIFT(242),
  [1584] = {.entry = {.count = 1, .reusable = true}}, SHIFT(413),
  [1586] = {.entry = {.count = 1, .reusable = true}}, SHIFT(571),
  [1588] = {.entry = {.count = 1, .reusable = true}}, SHIFT(245),
  [1590] = {.entry = {.count = 1, .reusable = true}}, SHIFT(609),
  [1592] = {.entry = {.count = 1, .reusable = true}}, SHIFT(160),
  [1594] = {.entry = {.count = 2, .reusable = true}}, REDUCE(aux_sym_variable_definition_sequence_repeat1, 2), SHIFT_REPEAT(336),
  [1597] = {.entry = {.count = 1, .reusable = true}}, SHIFT(230),
  [1599] = {.entry = {.count = 1, .reusable = true}}, SHIFT(401),
  [1601] = {.entry = {.count = 1, .reusable = true}}, SHIFT(429),
  [1603] = {.entry = {.count = 1, .reusable = true}}, SHIFT(200),
  [1605] = {.entry = {.count = 1, .reusable = false}}, SHIFT(470),
  [1607] = {.entry = {.count = 1, .reusable = false}}, SHIFT(590),
  [1609] = {.entry = {.count = 1, .reusable = true}}, SHIFT(379),
  [1611] = {.entry = {.count = 1, .reusable = true}}, SHIFT(430),
  [1613] = {.entry = {.count = 1, .reusable = true}}, SHIFT(431),
  [1615] = {.entry = {.count = 1, .reusable = true}}, SHIFT(252),
  [1617] = {.entry = {.count = 1, .reusable = true}}, SHIFT(610),
  [1619] = {.entry = {.count = 1, .reusable = true}}, SHIFT(637),
  [1621] = {.entry = {.count = 1, .reusable = true}}, SHIFT(403),
  [1623] = {.entry = {.count = 1, .reusable = true}}, SHIFT(231),
  [1625] = {.entry = {.count = 1, .reusable = true}}, SHIFT(635),
  [1627] = {.entry = {.count = 1, .reusable = true}}, SHIFT(120),
  [1629] = {.entry = {.count = 1, .reusable = true}}, SHIFT(50),
  [1631] = {.entry = {.count = 1, .reusable = true}}, SHIFT(222),
  [1633] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const, 2, .production_id = 3),
  [1635] = {.entry = {.count = 1, .reusable = true}}, SHIFT(616),
  [1637] = {.entry = {.count = 1, .reusable = true}}, SHIFT(187),
  [1639] = {.entry = {.count = 1, .reusable = true}}, SHIFT(563),
  [1641] = {.entry = {.count = 1, .reusable = true}}, SHIFT(564),
  [1643] = {.entry = {.count = 1, .reusable = true}}, SHIFT(186),
  [1645] = {.entry = {.count = 1, .reusable = true}}, SHIFT(342),
  [1647] = {.entry = {.count = 1, .reusable = true}}, SHIFT(566),
  [1649] = {.entry = {.count = 1, .reusable = true}}, SHIFT(421),
  [1651] = {.entry = {.count = 1, .reusable = true}}, SHIFT(154),
  [1653] = {.entry = {.count = 1, .reusable = true}}, SHIFT(135),
  [1655] = {.entry = {.count = 1, .reusable = true}}, SHIFT(238),
  [1657] = {.entry = {.count = 1, .reusable = true}}, SHIFT(469),
  [1659] = {.entry = {.count = 1, .reusable = true}}, SHIFT(202),
  [1661] = {.entry = {.count = 1, .reusable = true}}, SHIFT(468),
  [1663] = {.entry = {.count = 1, .reusable = true}}, SHIFT(221),
  [1665] = {.entry = {.count = 1, .reusable = true}}, SHIFT(343),
  [1667] = {.entry = {.count = 1, .reusable = true}}, SHIFT(353),
  [1669] = {.entry = {.count = 1, .reusable = true}}, SHIFT(404),
  [1671] = {.entry = {.count = 1, .reusable = true}}, SHIFT(234),
  [1673] = {.entry = {.count = 1, .reusable = true}}, SHIFT(180),
  [1675] = {.entry = {.count = 1, .reusable = true}}, SHIFT(152),
  [1677] = {.entry = {.count = 1, .reusable = true}}, SHIFT(574),
  [1679] = {.entry = {.count = 1, .reusable = true}}, SHIFT(452),
  [1681] = {.entry = {.count = 1, .reusable = true}}, SHIFT(355),
  [1683] = {.entry = {.count = 1, .reusable = true}}, REDUCE(aux_sym_switch_repeat1, 4),
  [1685] = {.entry = {.count = 1, .reusable = true}}, SHIFT(577),
  [1687] = {.entry = {.count = 1, .reusable = true}}, SHIFT(460),
  [1689] = {.entry = {.count = 1, .reusable = true}}, SHIFT(578),
  [1691] = {.entry = {.count = 1, .reusable = true}}, SHIFT(409),
  [1693] = {.entry = {.count = 1, .reusable = true}}, SHIFT(147),
  [1695] = {.entry = {.count = 1, .reusable = true}}, SHIFT(352),
  [1697] = {.entry = {.count = 1, .reusable = true}}, SHIFT(251),
  [1699] = {.entry = {.count = 1, .reusable = true}}, SHIFT(477),
  [1701] = {.entry = {.count = 1, .reusable = true}}, SHIFT(228),
  [1703] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_const, 3, .production_id = 9),
  [1705] = {.entry = {.count = 1, .reusable = true}}, SHIFT(581),
  [1707] = {.entry = {.count = 1, .reusable = true}}, SHIFT(145),
  [1709] = {.entry = {.count = 1, .reusable = true}}, SHIFT(442),
  [1711] = {.entry = {.count = 1, .reusable = true}}, SHIFT(582),
  [1713] = {.entry = {.count = 1, .reusable = true}}, SHIFT(254),
  [1715] = {.entry = {.count = 1, .reusable = true}}, SHIFT(458),
  [1717] = {.entry = {.count = 1, .reusable = true}}, SHIFT(104),
  [1719] = {.entry = {.count = 1, .reusable = true}}, SHIFT(127),
  [1721] = {.entry = {.count = 1, .reusable = true}}, SHIFT(447),
  [1723] = {.entry = {.count = 1, .reusable = true}}, SHIFT(445),
  [1725] = {.entry = {.count = 1, .reusable = true}}, SHIFT(107),
  [1727] = {.entry = {.count = 1, .reusable = true}}, SHIFT(441),
  [1729] = {.entry = {.count = 1, .reusable = true}}, SHIFT(109),
  [1731] = {.entry = {.count = 1, .reusable = true}}, SHIFT(243),
  [1733] = {.entry = {.count = 1, .reusable = true}}, SHIFT(425),
  [1735] = {.entry = {.count = 1, .reusable = true}}, SHIFT(675),
  [1737] = {.entry = {.count = 1, .reusable = true}}, SHIFT(140),
  [1739] = {.entry = {.count = 1, .reusable = true}}, SHIFT(139),
  [1741] = {.entry = {.count = 1, .reusable = true}}, SHIFT(138),
  [1743] = {.entry = {.count = 1, .reusable = true}}, SHIFT(247),
  [1745] = {.entry = {.count = 1, .reusable = true}}, SHIFT(240),
  [1747] = {.entry = {.count = 1, .reusable = true}}, SHIFT(239),
  [1749] = {.entry = {.count = 1, .reusable = true}}, SHIFT(11),
  [1751] = {.entry = {.count = 1, .reusable = true}}, SHIFT(6),
  [1753] = {.entry = {.count = 1, .reusable = true}}, SHIFT(604),
  [1755] = {.entry = {.count = 1, .reusable = true}}, SHIFT(607),
  [1757] = {.entry = {.count = 1, .reusable = true}}, SHIFT(198),
  [1759] = {.entry = {.count = 1, .reusable = true}}, SHIFT(43),
  [1761] = {.entry = {.count = 1, .reusable = true}}, SHIFT(196),
  [1763] = {.entry = {.count = 1, .reusable = true}}, SHIFT(161),
  [1765] = {.entry = {.count = 1, .reusable = true}}, SHIFT(163),
  [1767] = {.entry = {.count = 1, .reusable = true}}, SHIFT(172),
  [1769] = {.entry = {.count = 1, .reusable = true}}, SHIFT(617),
  [1771] = {.entry = {.count = 1, .reusable = true}}, SHIFT(633),
  [1773] = {.entry = {.count = 1, .reusable = true}}, SHIFT(621),
  [1775] = {.entry = {.count = 1, .reusable = true}}, SHIFT(115),
  [1777] = {.entry = {.count = 1, .reusable = true}}, SHIFT(132),
  [1779] = {.entry = {.count = 1, .reusable = true}},  ACCEPT_INPUT(),
  [1781] = {.entry = {.count = 1, .reusable = true}}, SHIFT(197),
  [1783] = {.entry = {.count = 1, .reusable = true}}, SHIFT(647),
  [1785] = {.entry = {.count = 1, .reusable = true}}, SHIFT(648),
  [1787] = {.entry = {.count = 1, .reusable = true}}, SHIFT(641),
  [1789] = {.entry = {.count = 1, .reusable = true}}, SHIFT(419),
  [1791] = {.entry = {.count = 1, .reusable = true}}, SHIFT(236),
  [1793] = {.entry = {.count = 1, .reusable = true}}, SHIFT(97),
  [1795] = {.entry = {.count = 1, .reusable = true}}, SHIFT(51),
  [1797] = {.entry = {.count = 1, .reusable = true}}, SHIFT(4),
  [1799] = {.entry = {.count = 1, .reusable = true}}, SHIFT(414),
  [1801] = {.entry = {.count = 1, .reusable = true}}, SHIFT(45),
  [1803] = {.entry = {.count = 1, .reusable = true}}, SHIFT(225),
  [1805] = {.entry = {.count = 1, .reusable = true}}, SHIFT(159),
  [1807] = {.entry = {.count = 1, .reusable = true}}, SHIFT(42),
  [1809] = {.entry = {.count = 1, .reusable = true}}, SHIFT(7),
  [1811] = {.entry = {.count = 1, .reusable = true}}, SHIFT(188),
  [1813] = {.entry = {.count = 1, .reusable = true}}, SHIFT(157),
  [1815] = {.entry = {.count = 1, .reusable = true}}, REDUCE(sym_line_comment, 1),
};

#ifdef __cplusplus
extern "C" {
#endif
void *tree_sitter_supercollider_external_scanner_create(void);
void tree_sitter_supercollider_external_scanner_destroy(void *);
bool tree_sitter_supercollider_external_scanner_scan(void *, TSLexer *, const bool *);
unsigned tree_sitter_supercollider_external_scanner_serialize(void *, char *);
void tree_sitter_supercollider_external_scanner_deserialize(void *, const char *, unsigned);

#ifdef _WIN32
#define extern __declspec(dllexport)
#endif

extern const TSLanguage *tree_sitter_supercollider(void) {
  static const TSLanguage language = {
    .version = LANGUAGE_VERSION,
    .symbol_count = SYMBOL_COUNT,
    .alias_count = ALIAS_COUNT,
    .token_count = TOKEN_COUNT,
    .external_token_count = EXTERNAL_TOKEN_COUNT,
    .state_count = STATE_COUNT,
    .large_state_count = LARGE_STATE_COUNT,
    .production_id_count = PRODUCTION_ID_COUNT,
    .field_count = FIELD_COUNT,
    .max_alias_sequence_length = MAX_ALIAS_SEQUENCE_LENGTH,
    .parse_table = &ts_parse_table[0][0],
    .small_parse_table = ts_small_parse_table,
    .small_parse_table_map = ts_small_parse_table_map,
    .parse_actions = ts_parse_actions,
    .symbol_names = ts_symbol_names,
    .field_names = ts_field_names,
    .field_map_slices = ts_field_map_slices,
    .field_map_entries = ts_field_map_entries,
    .symbol_metadata = ts_symbol_metadata,
    .public_symbol_map = ts_symbol_map,
    .alias_map = ts_non_terminal_alias_map,
    .alias_sequences = &ts_alias_sequences[0][0],
    .lex_modes = ts_lex_modes,
    .lex_fn = ts_lex,
    .keyword_lex_fn = ts_lex_keywords,
    .keyword_capture_token = sym_identifier,
    .external_scanner = {
      &ts_external_scanner_states[0][0],
      ts_external_scanner_symbol_map,
      tree_sitter_supercollider_external_scanner_create,
      tree_sitter_supercollider_external_scanner_destroy,
      tree_sitter_supercollider_external_scanner_scan,
      tree_sitter_supercollider_external_scanner_serialize,
      tree_sitter_supercollider_external_scanner_deserialize,
    },
    .primary_state_ids = ts_primary_state_ids,
  };
  return &language;
}
#ifdef __cplusplus
}
#endif
