#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 882
#define LARGE_STATE_COUNT 329
#define SYMBOL_COUNT 517
#define ALIAS_COUNT 3
#define TOKEN_COUNT 324
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 35
#define MAX_ALIAS_SEQUENCE_LENGTH 12
#define PRODUCTION_ID_COUNT 88

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_pragma = 2,
  anon_sym_PIPE_PIPE = 3,
  anon_sym_DASH = 4,
  anon_sym_solidity = 5,
  aux_sym_pragma_value_token1 = 6,
  sym_solidity_version = 7,
  anon_sym_LT_EQ = 8,
  anon_sym_LT = 9,
  anon_sym_CARET = 10,
  anon_sym_GT = 11,
  anon_sym_GT_EQ = 12,
  anon_sym_TILDE = 13,
  anon_sym_EQ = 14,
  anon_sym_import = 15,
  anon_sym_from = 16,
  anon_sym_STAR = 17,
  anon_sym_LBRACE = 18,
  anon_sym_COMMA = 19,
  anon_sym_RBRACE = 20,
  anon_sym_as = 21,
  anon_sym_type = 22,
  anon_sym_is = 23,
  anon_sym_constant = 24,
  anon_sym_abstract = 25,
  anon_sym_contract = 26,
  anon_sym_error = 27,
  anon_sym_LPAREN = 28,
  anon_sym_RPAREN = 29,
  anon_sym_interface = 30,
  anon_sym_library = 31,
  anon_sym_struct = 32,
  anon_sym_enum = 33,
  anon_sym_event = 34,
  anon_sym_anonymous = 35,
  anon_sym_indexed = 36,
  anon_sym_using = 37,
  anon_sym_for = 38,
  anon_sym_assembly = 39,
  anon_sym_DQUOTEevmasm_DQUOTE = 40,
  anon_sym_COLON = 41,
  sym_yul_leave = 42,
  anon_sym_break = 43,
  anon_sym_continue = 44,
  anon_sym_DOT = 45,
  sym_yul_decimal_number = 46,
  sym_yul_hex_number = 47,
  anon_sym_true = 48,
  anon_sym_false = 49,
  anon_sym_let = 50,
  anon_sym_COLON_EQ = 51,
  anon_sym_if = 52,
  anon_sym_switch = 53,
  anon_sym_default = 54,
  anon_sym_case = 55,
  anon_sym_function = 56,
  anon_sym_DASH_GT = 57,
  anon_sym_stop = 58,
  anon_sym_add = 59,
  anon_sym_sub = 60,
  anon_sym_mul = 61,
  anon_sym_div = 62,
  anon_sym_sdiv = 63,
  anon_sym_mod = 64,
  anon_sym_smod = 65,
  anon_sym_exp = 66,
  anon_sym_not = 67,
  anon_sym_lt = 68,
  anon_sym_gt = 69,
  anon_sym_slt = 70,
  anon_sym_sgt = 71,
  anon_sym_eq = 72,
  anon_sym_iszero = 73,
  anon_sym_and = 74,
  anon_sym_or = 75,
  anon_sym_xor = 76,
  anon_sym_byte = 77,
  anon_sym_shl = 78,
  anon_sym_shr = 79,
  anon_sym_sar = 80,
  anon_sym_addmod = 81,
  anon_sym_mulmod = 82,
  anon_sym_signextend = 83,
  anon_sym_keccak256 = 84,
  anon_sym_pop = 85,
  anon_sym_mload = 86,
  anon_sym_mcopy = 87,
  anon_sym_tload = 88,
  anon_sym_tstore = 89,
  anon_sym_mstore = 90,
  anon_sym_mstore8 = 91,
  anon_sym_sload = 92,
  anon_sym_sstore = 93,
  anon_sym_msize = 94,
  anon_sym_gas = 95,
  anon_sym_address = 96,
  anon_sym_balance = 97,
  anon_sym_selfbalance = 98,
  anon_sym_caller = 99,
  anon_sym_callvalue = 100,
  anon_sym_calldataload = 101,
  anon_sym_calldatasize = 102,
  anon_sym_calldatacopy = 103,
  anon_sym_extcodesize = 104,
  anon_sym_extcodecopy = 105,
  anon_sym_returndatasize = 106,
  anon_sym_returndatacopy = 107,
  anon_sym_extcodehash = 108,
  anon_sym_create = 109,
  anon_sym_create2 = 110,
  anon_sym_call = 111,
  anon_sym_callcode = 112,
  anon_sym_delegatecall = 113,
  anon_sym_staticcall = 114,
  anon_sym_return = 115,
  anon_sym_revert = 116,
  anon_sym_selfdestruct = 117,
  anon_sym_invalid = 118,
  anon_sym_log0 = 119,
  anon_sym_log1 = 120,
  anon_sym_log2 = 121,
  anon_sym_log3 = 122,
  anon_sym_log4 = 123,
  anon_sym_chainid = 124,
  anon_sym_origin = 125,
  anon_sym_gasprice = 126,
  anon_sym_blockhash = 127,
  anon_sym_blobhash = 128,
  anon_sym_basefee = 129,
  anon_sym_blobfee = 130,
  anon_sym_coinbase = 131,
  anon_sym_timestamp = 132,
  anon_sym_number = 133,
  anon_sym_difficulty = 134,
  anon_sym_gaslimit = 135,
  sym_unchecked = 136,
  anon_sym_memory = 137,
  anon_sym_storage = 138,
  anon_sym_calldata = 139,
  anon_sym_var = 140,
  anon_sym_else = 141,
  anon_sym_while = 142,
  anon_sym_do = 143,
  anon_sym_try = 144,
  anon_sym_returns = 145,
  anon_sym_catch = 146,
  anon_sym_emit = 147,
  anon_sym_public = 148,
  anon_sym_internal = 149,
  anon_sym_private = 150,
  anon_sym_external = 151,
  anon_sym_pure = 152,
  anon_sym_view = 153,
  anon_sym_payable = 154,
  anon_sym_transient = 155,
  sym_immutable = 156,
  anon_sym_override = 157,
  anon_sym_modifier = 158,
  anon_sym_constructor = 159,
  anon_sym_fallback = 160,
  anon_sym_receive = 161,
  sym_virtual = 162,
  anon_sym_QMARK = 163,
  anon_sym_new = 164,
  anon_sym_LBRACK = 165,
  anon_sym_RBRACK = 166,
  anon_sym_AMP_AMP = 167,
  anon_sym_EQ_EQ = 168,
  anon_sym_BANG_EQ = 169,
  anon_sym_PIPE = 170,
  anon_sym_AMP = 171,
  anon_sym_LT_LT = 172,
  anon_sym_GT_GT = 173,
  anon_sym_PLUS = 174,
  anon_sym_SLASH = 175,
  anon_sym_PERCENT = 176,
  anon_sym_STAR_STAR = 177,
  anon_sym_delete = 178,
  anon_sym_BANG = 179,
  anon_sym_PLUS_PLUS = 180,
  anon_sym_DASH_DASH = 181,
  anon_sym_PLUS_EQ = 182,
  anon_sym_DASH_EQ = 183,
  anon_sym_STAR_EQ = 184,
  anon_sym_SLASH_EQ = 185,
  anon_sym_PERCENT_EQ = 186,
  anon_sym_CARET_EQ = 187,
  anon_sym_AMP_EQ = 188,
  anon_sym_PIPE_EQ = 189,
  anon_sym_GT_GT_EQ = 190,
  anon_sym_LT_LT_EQ = 191,
  anon_sym_mapping = 192,
  anon_sym_EQ_GT = 193,
  anon_sym_bool = 194,
  anon_sym_string = 195,
  anon_sym_int = 196,
  anon_sym_int8 = 197,
  anon_sym_int16 = 198,
  anon_sym_int24 = 199,
  anon_sym_int32 = 200,
  anon_sym_int40 = 201,
  anon_sym_int48 = 202,
  anon_sym_int56 = 203,
  anon_sym_int64 = 204,
  anon_sym_int72 = 205,
  anon_sym_int80 = 206,
  anon_sym_int88 = 207,
  anon_sym_int96 = 208,
  anon_sym_int104 = 209,
  anon_sym_int112 = 210,
  anon_sym_int120 = 211,
  anon_sym_int128 = 212,
  anon_sym_int136 = 213,
  anon_sym_int144 = 214,
  anon_sym_int152 = 215,
  anon_sym_int160 = 216,
  anon_sym_int168 = 217,
  anon_sym_int176 = 218,
  anon_sym_int184 = 219,
  anon_sym_int192 = 220,
  anon_sym_int200 = 221,
  anon_sym_int208 = 222,
  anon_sym_int216 = 223,
  anon_sym_int224 = 224,
  anon_sym_int232 = 225,
  anon_sym_int240 = 226,
  anon_sym_int248 = 227,
  anon_sym_int256 = 228,
  anon_sym_uint = 229,
  anon_sym_uint8 = 230,
  anon_sym_uint16 = 231,
  anon_sym_uint24 = 232,
  anon_sym_uint32 = 233,
  anon_sym_uint40 = 234,
  anon_sym_uint48 = 235,
  anon_sym_uint56 = 236,
  anon_sym_uint64 = 237,
  anon_sym_uint72 = 238,
  anon_sym_uint80 = 239,
  anon_sym_uint88 = 240,
  anon_sym_uint96 = 241,
  anon_sym_uint104 = 242,
  anon_sym_uint112 = 243,
  anon_sym_uint120 = 244,
  anon_sym_uint128 = 245,
  anon_sym_uint136 = 246,
  anon_sym_uint144 = 247,
  anon_sym_uint152 = 248,
  anon_sym_uint160 = 249,
  anon_sym_uint168 = 250,
  anon_sym_uint176 = 251,
  anon_sym_uint184 = 252,
  anon_sym_uint192 = 253,
  anon_sym_uint200 = 254,
  anon_sym_uint208 = 255,
  anon_sym_uint216 = 256,
  anon_sym_uint224 = 257,
  anon_sym_uint232 = 258,
  anon_sym_uint240 = 259,
  anon_sym_uint248 = 260,
  anon_sym_uint256 = 261,
  anon_sym_bytes = 262,
  anon_sym_bytes1 = 263,
  anon_sym_bytes2 = 264,
  anon_sym_bytes3 = 265,
  anon_sym_bytes4 = 266,
  anon_sym_bytes5 = 267,
  anon_sym_bytes6 = 268,
  anon_sym_bytes7 = 269,
  anon_sym_bytes8 = 270,
  anon_sym_bytes9 = 271,
  anon_sym_bytes10 = 272,
  anon_sym_bytes11 = 273,
  anon_sym_bytes12 = 274,
  anon_sym_bytes13 = 275,
  anon_sym_bytes14 = 276,
  anon_sym_bytes15 = 277,
  anon_sym_bytes16 = 278,
  anon_sym_bytes17 = 279,
  anon_sym_bytes18 = 280,
  anon_sym_bytes19 = 281,
  anon_sym_bytes20 = 282,
  anon_sym_bytes21 = 283,
  anon_sym_bytes22 = 284,
  anon_sym_bytes23 = 285,
  anon_sym_bytes24 = 286,
  anon_sym_bytes25 = 287,
  anon_sym_bytes26 = 288,
  anon_sym_bytes27 = 289,
  anon_sym_bytes28 = 290,
  anon_sym_bytes29 = 291,
  anon_sym_bytes30 = 292,
  anon_sym_bytes31 = 293,
  anon_sym_bytes32 = 294,
  anon_sym_fixed = 295,
  aux_sym__fixed_token1 = 296,
  anon_sym_ufixed = 297,
  aux_sym__ufixed_token1 = 298,
  anon_sym_SEMI = 299,
  aux_sym__decimal_number_token1 = 300,
  aux_sym__decimal_number_token2 = 301,
  aux_sym__hex_number_token1 = 302,
  sym__hex_digit = 303,
  anon_sym_wei = 304,
  anon_sym_szabo = 305,
  anon_sym_finney = 306,
  anon_sym_gwei = 307,
  anon_sym_ether = 308,
  anon_sym_seconds = 309,
  anon_sym_minutes = 310,
  anon_sym_hours = 311,
  anon_sym_days = 312,
  anon_sym_weeks = 313,
  anon_sym_years = 314,
  anon_sym_hex = 315,
  anon_sym_DQUOTE = 316,
  anon_sym__ = 317,
  anon_sym_SQUOTE = 318,
  sym__escape_sequence = 319,
  aux_sym__single_quoted_unicode_char_token1 = 320,
  aux_sym__double_quoted_unicode_char_token1 = 321,
  anon_sym_unicode = 322,
  sym_comment = 323,
  sym_source_file = 324,
  sym__source_unit = 325,
  sym__directive = 326,
  sym_pragma_directive = 327,
  sym_solidity_pragma_token = 328,
  sym_any_pragma_token = 329,
  sym__solidity = 330,
  sym_pragma_value = 331,
  sym__pragma_version_constraint = 332,
  sym_solidity_version_comparison_operator = 333,
  sym_import_directive = 334,
  sym__source_import = 335,
  sym__import_clause = 336,
  sym__from_clause = 337,
  sym__single_import = 338,
  sym__multiple_import = 339,
  sym__import_declaration = 340,
  sym__import_alias = 341,
  sym__declaration = 342,
  sym_user_defined_type_definition = 343,
  sym_constant_variable_declaration = 344,
  sym_contract_declaration = 345,
  sym_error_declaration = 346,
  sym_error_parameter = 347,
  sym_interface_declaration = 348,
  sym_library_declaration = 349,
  sym__class_heritage = 350,
  sym_inheritance_specifier = 351,
  sym_contract_body = 352,
  sym__contract_member = 353,
  sym_struct_declaration = 354,
  sym_struct_member = 355,
  sym_struct_body = 356,
  sym_enum_declaration = 357,
  sym_enum_body = 358,
  sym_event_definition = 359,
  sym__event_parameter_list = 360,
  sym_event_parameter = 361,
  sym_using_directive = 362,
  sym_any_source_type = 363,
  sym_statement = 364,
  sym_assembly_statement = 365,
  sym_assembly_flags = 366,
  sym__yul_statement = 367,
  sym_yul_label = 368,
  sym_yul_break = 369,
  sym_yul_continue = 370,
  sym_yul_identifier = 371,
  sym__yul_expression = 372,
  sym_yul_path = 373,
  sym__yul_literal = 374,
  sym_yul_string_literal = 375,
  sym_yul_boolean = 376,
  sym_yul_block = 377,
  sym_yul_variable_declaration = 378,
  sym__yul_assignment_operator = 379,
  sym_yul_assignment = 380,
  sym_yul_function_call = 381,
  sym_yul_if_statement = 382,
  sym_yul_for_statement = 383,
  sym_yul_switch_statement = 384,
  sym_yul_function_definition = 385,
  sym_yul_evm_builtin = 386,
  sym_block_statement = 387,
  sym_variable_declaration_statement = 388,
  sym_variable_declaration = 389,
  sym_variable_declaration_tuple = 390,
  sym_expression_statement = 391,
  sym_if_statement = 392,
  sym_for_statement = 393,
  sym_while_statement = 394,
  sym_do_while_statement = 395,
  sym_continue_statement = 396,
  sym_break_statement = 397,
  sym_revert_statement = 398,
  sym_try_statement = 399,
  sym_catch_clause = 400,
  sym_return_statement = 401,
  sym_emit_statement = 402,
  sym_state_variable_declaration = 403,
  sym_visibility = 404,
  sym_state_mutability = 405,
  sym_state_location = 406,
  sym_override_specifier = 407,
  sym_modifier_definition = 408,
  sym_constructor_definition = 409,
  sym_fallback_receive_definition = 410,
  sym_function_definition = 411,
  sym_return_type_definition = 412,
  sym_modifier_invocation = 413,
  sym__call_arguments = 414,
  sym_call_argument = 415,
  sym_call_struct_argument = 416,
  sym_function_body = 417,
  sym_expression = 418,
  sym__primary_expression = 419,
  sym_type_cast_expression = 420,
  sym_ternary_expression = 421,
  sym_new_expression = 422,
  sym_tuple_expression = 423,
  sym_inline_array_expression = 424,
  sym_binary_expression = 425,
  sym_unary_expression = 426,
  sym_update_expression = 427,
  sym_member_expression = 428,
  sym_array_access = 429,
  sym_slice_access = 430,
  sym_struct_expression = 431,
  sym_struct_field_assignment = 432,
  sym_parenthesized_expression = 433,
  sym_assignment_expression = 434,
  sym_augmented_assignment_expression = 435,
  sym_call_expression = 436,
  sym_payable_conversion_expression = 437,
  sym_meta_type_expression = 438,
  sym_type_name = 439,
  sym__array_type = 440,
  sym__function_type = 441,
  sym__parameter_list = 442,
  sym__return_parameters = 443,
  sym__nameless_parameter = 444,
  sym_parameter = 445,
  sym__storage_location = 446,
  sym_user_defined_type = 447,
  sym__identifier_path = 448,
  sym__mapping = 449,
  sym__mapping_key = 450,
  sym_primitive_type = 451,
  sym__int = 452,
  sym__uint = 453,
  sym__bytes = 454,
  sym__fixed = 455,
  sym__ufixed = 456,
  sym__semicolon = 457,
  sym__literal = 458,
  sym_string_literal = 459,
  sym_number_literal = 460,
  sym__decimal_number = 461,
  sym__hex_number = 462,
  sym_number_unit = 463,
  sym_true = 464,
  sym_false = 465,
  sym_boolean_literal = 466,
  sym_hex_string_literal = 467,
  sym__single_quoted_unicode_char = 468,
  sym__double_quoted_unicode_char = 469,
  sym_unicode_string_literal = 470,
  sym_string = 471,
  sym__string_immediate_elt_inside_double_quote = 472,
  sym__string_immediate_elt_inside_quote = 473,
  aux_sym_source_file_repeat1 = 474,
  aux_sym_solidity_pragma_token_repeat1 = 475,
  aux_sym__multiple_import_repeat1 = 476,
  aux_sym_error_declaration_repeat1 = 477,
  aux_sym__class_heritage_repeat1 = 478,
  aux_sym_contract_body_repeat1 = 479,
  aux_sym_struct_body_repeat1 = 480,
  aux_sym_enum_body_repeat1 = 481,
  aux_sym__event_parameter_list_repeat1 = 482,
  aux_sym_assembly_statement_repeat1 = 483,
  aux_sym_assembly_flags_repeat1 = 484,
  aux_sym_yul_path_repeat1 = 485,
  aux_sym_yul_variable_declaration_repeat1 = 486,
  aux_sym_yul_assignment_repeat1 = 487,
  aux_sym_yul_function_call_repeat1 = 488,
  aux_sym_yul_switch_statement_repeat1 = 489,
  aux_sym_block_statement_repeat1 = 490,
  aux_sym_variable_declaration_tuple_repeat1 = 491,
  aux_sym_variable_declaration_tuple_repeat2 = 492,
  aux_sym_try_statement_repeat1 = 493,
  aux_sym_state_variable_declaration_repeat1 = 494,
  aux_sym_override_specifier_repeat1 = 495,
  aux_sym_modifier_definition_repeat1 = 496,
  aux_sym_constructor_definition_repeat1 = 497,
  aux_sym_fallback_receive_definition_repeat1 = 498,
  aux_sym_function_definition_repeat1 = 499,
  aux_sym__call_arguments_repeat1 = 500,
  aux_sym_call_argument_repeat1 = 501,
  aux_sym_tuple_expression_repeat1 = 502,
  aux_sym_inline_array_expression_repeat1 = 503,
  aux_sym_struct_expression_repeat1 = 504,
  aux_sym__function_type_repeat1 = 505,
  aux_sym__parameter_list_repeat1 = 506,
  aux_sym__return_parameters_repeat1 = 507,
  aux_sym__identifier_path_repeat1 = 508,
  aux_sym_string_literal_repeat1 = 509,
  aux_sym_hex_string_literal_repeat1 = 510,
  aux_sym_hex_string_literal_repeat2 = 511,
  aux_sym_unicode_string_literal_repeat1 = 512,
  aux_sym_unicode_string_literal_repeat2 = 513,
  aux_sym_unicode_string_literal_repeat3 = 514,
  aux_sym_string_repeat1 = 515,
  aux_sym_string_repeat2 = 516,
  alias_sym_enum_value = 517,
  alias_sym_revert_arguments = 518,
  alias_sym_type_alias = 519,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_pragma] = "pragma",
  [anon_sym_PIPE_PIPE] = "||",
  [anon_sym_DASH] = "-",
  [anon_sym_solidity] = "solidity",
  [aux_sym_pragma_value_token1] = "pragma_value_token1",
  [sym_solidity_version] = "solidity_version",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_LT] = "<",
  [anon_sym_CARET] = "^",
  [anon_sym_GT] = ">",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_TILDE] = "~",
  [anon_sym_EQ] = "=",
  [anon_sym_import] = "import",
  [anon_sym_from] = "from",
  [anon_sym_STAR] = "*",
  [anon_sym_LBRACE] = "{",
  [anon_sym_COMMA] = ",",
  [anon_sym_RBRACE] = "}",
  [anon_sym_as] = "as",
  [anon_sym_type] = "type",
  [anon_sym_is] = "is",
  [anon_sym_constant] = "constant",
  [anon_sym_abstract] = "abstract",
  [anon_sym_contract] = "contract",
  [anon_sym_error] = "error",
  [anon_sym_LPAREN] = "(",
  [anon_sym_RPAREN] = ")",
  [anon_sym_interface] = "interface",
  [anon_sym_library] = "library",
  [anon_sym_struct] = "struct",
  [anon_sym_enum] = "enum",
  [anon_sym_event] = "event",
  [anon_sym_anonymous] = "anonymous",
  [anon_sym_indexed] = "indexed",
  [anon_sym_using] = "using",
  [anon_sym_for] = "for",
  [anon_sym_assembly] = "assembly",
  [anon_sym_DQUOTEevmasm_DQUOTE] = "\"evmasm\"",
  [anon_sym_COLON] = ":",
  [sym_yul_leave] = "yul_leave",
  [anon_sym_break] = "break",
  [anon_sym_continue] = "continue",
  [anon_sym_DOT] = ".",
  [sym_yul_decimal_number] = "yul_decimal_number",
  [sym_yul_hex_number] = "yul_hex_number",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [anon_sym_let] = "let",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_if] = "if",
  [anon_sym_switch] = "switch",
  [anon_sym_default] = "default",
  [anon_sym_case] = "case",
  [anon_sym_function] = "function",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_stop] = "stop",
  [anon_sym_add] = "add",
  [anon_sym_sub] = "sub",
  [anon_sym_mul] = "mul",
  [anon_sym_div] = "div",
  [anon_sym_sdiv] = "sdiv",
  [anon_sym_mod] = "mod",
  [anon_sym_smod] = "smod",
  [anon_sym_exp] = "exp",
  [anon_sym_not] = "not",
  [anon_sym_lt] = "lt",
  [anon_sym_gt] = "gt",
  [anon_sym_slt] = "slt",
  [anon_sym_sgt] = "sgt",
  [anon_sym_eq] = "eq",
  [anon_sym_iszero] = "iszero",
  [anon_sym_and] = "and",
  [anon_sym_or] = "or",
  [anon_sym_xor] = "xor",
  [anon_sym_byte] = "byte",
  [anon_sym_shl] = "shl",
  [anon_sym_shr] = "shr",
  [anon_sym_sar] = "sar",
  [anon_sym_addmod] = "addmod",
  [anon_sym_mulmod] = "mulmod",
  [anon_sym_signextend] = "signextend",
  [anon_sym_keccak256] = "keccak256",
  [anon_sym_pop] = "pop",
  [anon_sym_mload] = "mload",
  [anon_sym_mcopy] = "mcopy",
  [anon_sym_tload] = "tload",
  [anon_sym_tstore] = "tstore",
  [anon_sym_mstore] = "mstore",
  [anon_sym_mstore8] = "mstore8",
  [anon_sym_sload] = "sload",
  [anon_sym_sstore] = "sstore",
  [anon_sym_msize] = "msize",
  [anon_sym_gas] = "gas",
  [anon_sym_address] = "address",
  [anon_sym_balance] = "balance",
  [anon_sym_selfbalance] = "selfbalance",
  [anon_sym_caller] = "caller",
  [anon_sym_callvalue] = "callvalue",
  [anon_sym_calldataload] = "calldataload",
  [anon_sym_calldatasize] = "calldatasize",
  [anon_sym_calldatacopy] = "calldatacopy",
  [anon_sym_extcodesize] = "extcodesize",
  [anon_sym_extcodecopy] = "extcodecopy",
  [anon_sym_returndatasize] = "returndatasize",
  [anon_sym_returndatacopy] = "returndatacopy",
  [anon_sym_extcodehash] = "extcodehash",
  [anon_sym_create] = "create",
  [anon_sym_create2] = "create2",
  [anon_sym_call] = "call",
  [anon_sym_callcode] = "callcode",
  [anon_sym_delegatecall] = "delegatecall",
  [anon_sym_staticcall] = "staticcall",
  [anon_sym_return] = "return",
  [anon_sym_revert] = "revert",
  [anon_sym_selfdestruct] = "selfdestruct",
  [anon_sym_invalid] = "invalid",
  [anon_sym_log0] = "log0",
  [anon_sym_log1] = "log1",
  [anon_sym_log2] = "log2",
  [anon_sym_log3] = "log3",
  [anon_sym_log4] = "log4",
  [anon_sym_chainid] = "chainid",
  [anon_sym_origin] = "origin",
  [anon_sym_gasprice] = "gasprice",
  [anon_sym_blockhash] = "blockhash",
  [anon_sym_blobhash] = "blobhash",
  [anon_sym_basefee] = "basefee",
  [anon_sym_blobfee] = "blobfee",
  [anon_sym_coinbase] = "coinbase",
  [anon_sym_timestamp] = "timestamp",
  [anon_sym_number] = "number",
  [anon_sym_difficulty] = "difficulty",
  [anon_sym_gaslimit] = "gaslimit",
  [sym_unchecked] = "unchecked",
  [anon_sym_memory] = "memory",
  [anon_sym_storage] = "storage",
  [anon_sym_calldata] = "calldata",
  [anon_sym_var] = "var",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_do] = "do",
  [anon_sym_try] = "try",
  [anon_sym_returns] = "returns",
  [anon_sym_catch] = "catch",
  [anon_sym_emit] = "emit",
  [anon_sym_public] = "public",
  [anon_sym_internal] = "internal",
  [anon_sym_private] = "private",
  [anon_sym_external] = "external",
  [anon_sym_pure] = "pure",
  [anon_sym_view] = "view",
  [anon_sym_payable] = "payable",
  [anon_sym_transient] = "transient",
  [sym_immutable] = "immutable",
  [anon_sym_override] = "override",
  [anon_sym_modifier] = "modifier",
  [anon_sym_constructor] = "constructor",
  [anon_sym_fallback] = "fallback",
  [anon_sym_receive] = "receive",
  [sym_virtual] = "virtual",
  [anon_sym_QMARK] = "\?",
  [anon_sym_new] = "new",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_AMP_AMP] = "&&",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_PIPE] = "|",
  [anon_sym_AMP] = "&",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_PLUS] = "+",
  [anon_sym_SLASH] = "/",
  [anon_sym_PERCENT] = "%",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_delete] = "delete",
  [anon_sym_BANG] = "!",
  [anon_sym_PLUS_PLUS] = "++",
  [anon_sym_DASH_DASH] = "--",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_mapping] = "mapping",
  [anon_sym_EQ_GT] = "=>",
  [anon_sym_bool] = "bool",
  [anon_sym_string] = "string",
  [anon_sym_int] = "int",
  [anon_sym_int8] = "int8",
  [anon_sym_int16] = "int16",
  [anon_sym_int24] = "int24",
  [anon_sym_int32] = "int32",
  [anon_sym_int40] = "int40",
  [anon_sym_int48] = "int48",
  [anon_sym_int56] = "int56",
  [anon_sym_int64] = "int64",
  [anon_sym_int72] = "int72",
  [anon_sym_int80] = "int80",
  [anon_sym_int88] = "int88",
  [anon_sym_int96] = "int96",
  [anon_sym_int104] = "int104",
  [anon_sym_int112] = "int112",
  [anon_sym_int120] = "int120",
  [anon_sym_int128] = "int128",
  [anon_sym_int136] = "int136",
  [anon_sym_int144] = "int144",
  [anon_sym_int152] = "int152",
  [anon_sym_int160] = "int160",
  [anon_sym_int168] = "int168",
  [anon_sym_int176] = "int176",
  [anon_sym_int184] = "int184",
  [anon_sym_int192] = "int192",
  [anon_sym_int200] = "int200",
  [anon_sym_int208] = "int208",
  [anon_sym_int216] = "int216",
  [anon_sym_int224] = "int224",
  [anon_sym_int232] = "int232",
  [anon_sym_int240] = "int240",
  [anon_sym_int248] = "int248",
  [anon_sym_int256] = "int256",
  [anon_sym_uint] = "uint",
  [anon_sym_uint8] = "uint8",
  [anon_sym_uint16] = "uint16",
  [anon_sym_uint24] = "uint24",
  [anon_sym_uint32] = "uint32",
  [anon_sym_uint40] = "uint40",
  [anon_sym_uint48] = "uint48",
  [anon_sym_uint56] = "uint56",
  [anon_sym_uint64] = "uint64",
  [anon_sym_uint72] = "uint72",
  [anon_sym_uint80] = "uint80",
  [anon_sym_uint88] = "uint88",
  [anon_sym_uint96] = "uint96",
  [anon_sym_uint104] = "uint104",
  [anon_sym_uint112] = "uint112",
  [anon_sym_uint120] = "uint120",
  [anon_sym_uint128] = "uint128",
  [anon_sym_uint136] = "uint136",
  [anon_sym_uint144] = "uint144",
  [anon_sym_uint152] = "uint152",
  [anon_sym_uint160] = "uint160",
  [anon_sym_uint168] = "uint168",
  [anon_sym_uint176] = "uint176",
  [anon_sym_uint184] = "uint184",
  [anon_sym_uint192] = "uint192",
  [anon_sym_uint200] = "uint200",
  [anon_sym_uint208] = "uint208",
  [anon_sym_uint216] = "uint216",
  [anon_sym_uint224] = "uint224",
  [anon_sym_uint232] = "uint232",
  [anon_sym_uint240] = "uint240",
  [anon_sym_uint248] = "uint248",
  [anon_sym_uint256] = "uint256",
  [anon_sym_bytes] = "bytes",
  [anon_sym_bytes1] = "bytes1",
  [anon_sym_bytes2] = "bytes2",
  [anon_sym_bytes3] = "bytes3",
  [anon_sym_bytes4] = "bytes4",
  [anon_sym_bytes5] = "bytes5",
  [anon_sym_bytes6] = "bytes6",
  [anon_sym_bytes7] = "bytes7",
  [anon_sym_bytes8] = "bytes8",
  [anon_sym_bytes9] = "bytes9",
  [anon_sym_bytes10] = "bytes10",
  [anon_sym_bytes11] = "bytes11",
  [anon_sym_bytes12] = "bytes12",
  [anon_sym_bytes13] = "bytes13",
  [anon_sym_bytes14] = "bytes14",
  [anon_sym_bytes15] = "bytes15",
  [anon_sym_bytes16] = "bytes16",
  [anon_sym_bytes17] = "bytes17",
  [anon_sym_bytes18] = "bytes18",
  [anon_sym_bytes19] = "bytes19",
  [anon_sym_bytes20] = "bytes20",
  [anon_sym_bytes21] = "bytes21",
  [anon_sym_bytes22] = "bytes22",
  [anon_sym_bytes23] = "bytes23",
  [anon_sym_bytes24] = "bytes24",
  [anon_sym_bytes25] = "bytes25",
  [anon_sym_bytes26] = "bytes26",
  [anon_sym_bytes27] = "bytes27",
  [anon_sym_bytes28] = "bytes28",
  [anon_sym_bytes29] = "bytes29",
  [anon_sym_bytes30] = "bytes30",
  [anon_sym_bytes31] = "bytes31",
  [anon_sym_bytes32] = "bytes32",
  [anon_sym_fixed] = "fixed",
  [aux_sym__fixed_token1] = "_fixed_token1",
  [anon_sym_ufixed] = "ufixed",
  [aux_sym__ufixed_token1] = "_ufixed_token1",
  [anon_sym_SEMI] = ";",
  [aux_sym__decimal_number_token1] = "_decimal_number_token1",
  [aux_sym__decimal_number_token2] = "_decimal_number_token2",
  [aux_sym__hex_number_token1] = "_hex_number_token1",
  [sym__hex_digit] = "_hex_digit",
  [anon_sym_wei] = "wei",
  [anon_sym_szabo] = "szabo",
  [anon_sym_finney] = "finney",
  [anon_sym_gwei] = "gwei",
  [anon_sym_ether] = "ether",
  [anon_sym_seconds] = "seconds",
  [anon_sym_minutes] = "minutes",
  [anon_sym_hours] = "hours",
  [anon_sym_days] = "days",
  [anon_sym_weeks] = "weeks",
  [anon_sym_years] = "years",
  [anon_sym_hex] = "hex",
  [anon_sym_DQUOTE] = "\"",
  [anon_sym__] = "_",
  [anon_sym_SQUOTE] = "'",
  [sym__escape_sequence] = "_escape_sequence",
  [aux_sym__single_quoted_unicode_char_token1] = "_single_quoted_unicode_char_token1",
  [aux_sym__double_quoted_unicode_char_token1] = "_double_quoted_unicode_char_token1",
  [anon_sym_unicode] = "unicode",
  [sym_comment] = "comment",
  [sym_source_file] = "source_file",
  [sym__source_unit] = "_source_unit",
  [sym__directive] = "_directive",
  [sym_pragma_directive] = "pragma_directive",
  [sym_solidity_pragma_token] = "solidity_pragma_token",
  [sym_any_pragma_token] = "any_pragma_token",
  [sym__solidity] = "_solidity",
  [sym_pragma_value] = "pragma_value",
  [sym__pragma_version_constraint] = "_pragma_version_constraint",
  [sym_solidity_version_comparison_operator] = "solidity_version_comparison_operator",
  [sym_import_directive] = "import_directive",
  [sym__source_import] = "_source_import",
  [sym__import_clause] = "_import_clause",
  [sym__from_clause] = "_from_clause",
  [sym__single_import] = "_single_import",
  [sym__multiple_import] = "_multiple_import",
  [sym__import_declaration] = "_import_declaration",
  [sym__import_alias] = "_import_alias",
  [sym__declaration] = "_declaration",
  [sym_user_defined_type_definition] = "user_defined_type_definition",
  [sym_constant_variable_declaration] = "constant_variable_declaration",
  [sym_contract_declaration] = "contract_declaration",
  [sym_error_declaration] = "error_declaration",
  [sym_error_parameter] = "error_parameter",
  [sym_interface_declaration] = "interface_declaration",
  [sym_library_declaration] = "library_declaration",
  [sym__class_heritage] = "_class_heritage",
  [sym_inheritance_specifier] = "inheritance_specifier",
  [sym_contract_body] = "contract_body",
  [sym__contract_member] = "_contract_member",
  [sym_struct_declaration] = "struct_declaration",
  [sym_struct_member] = "struct_member",
  [sym_struct_body] = "struct_body",
  [sym_enum_declaration] = "enum_declaration",
  [sym_enum_body] = "enum_body",
  [sym_event_definition] = "event_definition",
  [sym__event_parameter_list] = "_event_parameter_list",
  [sym_event_parameter] = "event_parameter",
  [sym_using_directive] = "using_directive",
  [sym_any_source_type] = "any_source_type",
  [sym_statement] = "statement",
  [sym_assembly_statement] = "assembly_statement",
  [sym_assembly_flags] = "assembly_flags",
  [sym__yul_statement] = "_yul_statement",
  [sym_yul_label] = "yul_label",
  [sym_yul_break] = "yul_break",
  [sym_yul_continue] = "yul_continue",
  [sym_yul_identifier] = "yul_identifier",
  [sym__yul_expression] = "_yul_expression",
  [sym_yul_path] = "yul_path",
  [sym__yul_literal] = "_yul_literal",
  [sym_yul_string_literal] = "yul_string_literal",
  [sym_yul_boolean] = "yul_boolean",
  [sym_yul_block] = "yul_block",
  [sym_yul_variable_declaration] = "yul_variable_declaration",
  [sym__yul_assignment_operator] = "_yul_assignment_operator",
  [sym_yul_assignment] = "yul_assignment",
  [sym_yul_function_call] = "yul_function_call",
  [sym_yul_if_statement] = "yul_if_statement",
  [sym_yul_for_statement] = "yul_for_statement",
  [sym_yul_switch_statement] = "yul_switch_statement",
  [sym_yul_function_definition] = "yul_function_definition",
  [sym_yul_evm_builtin] = "yul_evm_builtin",
  [sym_block_statement] = "block_statement",
  [sym_variable_declaration_statement] = "variable_declaration_statement",
  [sym_variable_declaration] = "variable_declaration",
  [sym_variable_declaration_tuple] = "variable_declaration_tuple",
  [sym_expression_statement] = "expression_statement",
  [sym_if_statement] = "if_statement",
  [sym_for_statement] = "for_statement",
  [sym_while_statement] = "while_statement",
  [sym_do_while_statement] = "do_while_statement",
  [sym_continue_statement] = "continue_statement",
  [sym_break_statement] = "break_statement",
  [sym_revert_statement] = "revert_statement",
  [sym_try_statement] = "try_statement",
  [sym_catch_clause] = "catch_clause",
  [sym_return_statement] = "return_statement",
  [sym_emit_statement] = "emit_statement",
  [sym_state_variable_declaration] = "state_variable_declaration",
  [sym_visibility] = "visibility",
  [sym_state_mutability] = "state_mutability",
  [sym_state_location] = "state_location",
  [sym_override_specifier] = "override_specifier",
  [sym_modifier_definition] = "modifier_definition",
  [sym_constructor_definition] = "constructor_definition",
  [sym_fallback_receive_definition] = "fallback_receive_definition",
  [sym_function_definition] = "function_definition",
  [sym_return_type_definition] = "return_type_definition",
  [sym_modifier_invocation] = "modifier_invocation",
  [sym__call_arguments] = "_call_arguments",
  [sym_call_argument] = "call_argument",
  [sym_call_struct_argument] = "call_struct_argument",
  [sym_function_body] = "function_body",
  [sym_expression] = "expression",
  [sym__primary_expression] = "_primary_expression",
  [sym_type_cast_expression] = "type_cast_expression",
  [sym_ternary_expression] = "ternary_expression",
  [sym_new_expression] = "new_expression",
  [sym_tuple_expression] = "tuple_expression",
  [sym_inline_array_expression] = "inline_array_expression",
  [sym_binary_expression] = "binary_expression",
  [sym_unary_expression] = "unary_expression",
  [sym_update_expression] = "update_expression",
  [sym_member_expression] = "member_expression",
  [sym_array_access] = "array_access",
  [sym_slice_access] = "slice_access",
  [sym_struct_expression] = "struct_expression",
  [sym_struct_field_assignment] = "struct_field_assignment",
  [sym_parenthesized_expression] = "parenthesized_expression",
  [sym_assignment_expression] = "assignment_expression",
  [sym_augmented_assignment_expression] = "augmented_assignment_expression",
  [sym_call_expression] = "call_expression",
  [sym_payable_conversion_expression] = "payable_conversion_expression",
  [sym_meta_type_expression] = "meta_type_expression",
  [sym_type_name] = "type_name",
  [sym__array_type] = "_array_type",
  [sym__function_type] = "_function_type",
  [sym__parameter_list] = "_parameter_list",
  [sym__return_parameters] = "_return_parameters",
  [sym__nameless_parameter] = "return_parameter",
  [sym_parameter] = "parameter",
  [sym__storage_location] = "_storage_location",
  [sym_user_defined_type] = "user_defined_type",
  [sym__identifier_path] = "_identifier_path",
  [sym__mapping] = "_mapping",
  [sym__mapping_key] = "_mapping_key",
  [sym_primitive_type] = "primitive_type",
  [sym__int] = "_int",
  [sym__uint] = "_uint",
  [sym__bytes] = "_bytes",
  [sym__fixed] = "_fixed",
  [sym__ufixed] = "_ufixed",
  [sym__semicolon] = "_semicolon",
  [sym__literal] = "_literal",
  [sym_string_literal] = "string_literal",
  [sym_number_literal] = "number_literal",
  [sym__decimal_number] = "_decimal_number",
  [sym__hex_number] = "_hex_number",
  [sym_number_unit] = "number_unit",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_boolean_literal] = "boolean_literal",
  [sym_hex_string_literal] = "hex_string_literal",
  [sym__single_quoted_unicode_char] = "_single_quoted_unicode_char",
  [sym__double_quoted_unicode_char] = "_double_quoted_unicode_char",
  [sym_unicode_string_literal] = "unicode_string_literal",
  [sym_string] = "string",
  [sym__string_immediate_elt_inside_double_quote] = "_string_immediate_elt_inside_double_quote",
  [sym__string_immediate_elt_inside_quote] = "_string_immediate_elt_inside_quote",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_solidity_pragma_token_repeat1] = "solidity_pragma_token_repeat1",
  [aux_sym__multiple_import_repeat1] = "_multiple_import_repeat1",
  [aux_sym_error_declaration_repeat1] = "error_declaration_repeat1",
  [aux_sym__class_heritage_repeat1] = "_class_heritage_repeat1",
  [aux_sym_contract_body_repeat1] = "contract_body_repeat1",
  [aux_sym_struct_body_repeat1] = "struct_body_repeat1",
  [aux_sym_enum_body_repeat1] = "enum_body_repeat1",
  [aux_sym__event_parameter_list_repeat1] = "_event_parameter_list_repeat1",
  [aux_sym_assembly_statement_repeat1] = "assembly_statement_repeat1",
  [aux_sym_assembly_flags_repeat1] = "assembly_flags_repeat1",
  [aux_sym_yul_path_repeat1] = "yul_path_repeat1",
  [aux_sym_yul_variable_declaration_repeat1] = "yul_variable_declaration_repeat1",
  [aux_sym_yul_assignment_repeat1] = "yul_assignment_repeat1",
  [aux_sym_yul_function_call_repeat1] = "yul_function_call_repeat1",
  [aux_sym_yul_switch_statement_repeat1] = "yul_switch_statement_repeat1",
  [aux_sym_block_statement_repeat1] = "block_statement_repeat1",
  [aux_sym_variable_declaration_tuple_repeat1] = "variable_declaration_tuple_repeat1",
  [aux_sym_variable_declaration_tuple_repeat2] = "variable_declaration_tuple_repeat2",
  [aux_sym_try_statement_repeat1] = "try_statement_repeat1",
  [aux_sym_state_variable_declaration_repeat1] = "state_variable_declaration_repeat1",
  [aux_sym_override_specifier_repeat1] = "override_specifier_repeat1",
  [aux_sym_modifier_definition_repeat1] = "modifier_definition_repeat1",
  [aux_sym_constructor_definition_repeat1] = "constructor_definition_repeat1",
  [aux_sym_fallback_receive_definition_repeat1] = "fallback_receive_definition_repeat1",
  [aux_sym_function_definition_repeat1] = "function_definition_repeat1",
  [aux_sym__call_arguments_repeat1] = "_call_arguments_repeat1",
  [aux_sym_call_argument_repeat1] = "call_argument_repeat1",
  [aux_sym_tuple_expression_repeat1] = "tuple_expression_repeat1",
  [aux_sym_inline_array_expression_repeat1] = "inline_array_expression_repeat1",
  [aux_sym_struct_expression_repeat1] = "struct_expression_repeat1",
  [aux_sym__function_type_repeat1] = "_function_type_repeat1",
  [aux_sym__parameter_list_repeat1] = "_parameter_list_repeat1",
  [aux_sym__return_parameters_repeat1] = "_return_parameters_repeat1",
  [aux_sym__identifier_path_repeat1] = "_identifier_path_repeat1",
  [aux_sym_string_literal_repeat1] = "string_literal_repeat1",
  [aux_sym_hex_string_literal_repeat1] = "hex_string_literal_repeat1",
  [aux_sym_hex_string_literal_repeat2] = "hex_string_literal_repeat2",
  [aux_sym_unicode_string_literal_repeat1] = "unicode_string_literal_repeat1",
  [aux_sym_unicode_string_literal_repeat2] = "unicode_string_literal_repeat2",
  [aux_sym_unicode_string_literal_repeat3] = "unicode_string_literal_repeat3",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [alias_sym_enum_value] = "enum_value",
  [alias_sym_revert_arguments] = "revert_arguments",
  [alias_sym_type_alias] = "type_alias",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_pragma] = anon_sym_pragma,
  [anon_sym_PIPE_PIPE] = anon_sym_PIPE_PIPE,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_solidity] = anon_sym_solidity,
  [aux_sym_pragma_value_token1] = aux_sym_pragma_value_token1,
  [sym_solidity_version] = sym_solidity_version,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_TILDE] = anon_sym_TILDE,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_from] = anon_sym_from,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_type] = anon_sym_type,
  [anon_sym_is] = anon_sym_is,
  [anon_sym_constant] = anon_sym_constant,
  [anon_sym_abstract] = anon_sym_abstract,
  [anon_sym_contract] = anon_sym_contract,
  [anon_sym_error] = anon_sym_error,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_interface] = anon_sym_interface,
  [anon_sym_library] = anon_sym_library,
  [anon_sym_struct] = anon_sym_struct,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_event] = anon_sym_event,
  [anon_sym_anonymous] = anon_sym_anonymous,
  [anon_sym_indexed] = anon_sym_indexed,
  [anon_sym_using] = anon_sym_using,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_assembly] = anon_sym_assembly,
  [anon_sym_DQUOTEevmasm_DQUOTE] = anon_sym_DQUOTEevmasm_DQUOTE,
  [anon_sym_COLON] = anon_sym_COLON,
  [sym_yul_leave] = sym_yul_leave,
  [anon_sym_break] = anon_sym_break,
  [anon_sym_continue] = anon_sym_continue,
  [anon_sym_DOT] = anon_sym_DOT,
  [sym_yul_decimal_number] = sym_yul_decimal_number,
  [sym_yul_hex_number] = sym_yul_hex_number,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_switch] = anon_sym_switch,
  [anon_sym_default] = anon_sym_default,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_function] = anon_sym_function,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_stop] = anon_sym_stop,
  [anon_sym_add] = anon_sym_add,
  [anon_sym_sub] = anon_sym_sub,
  [anon_sym_mul] = anon_sym_mul,
  [anon_sym_div] = anon_sym_div,
  [anon_sym_sdiv] = anon_sym_sdiv,
  [anon_sym_mod] = anon_sym_mod,
  [anon_sym_smod] = anon_sym_smod,
  [anon_sym_exp] = anon_sym_exp,
  [anon_sym_not] = anon_sym_not,
  [anon_sym_lt] = anon_sym_lt,
  [anon_sym_gt] = anon_sym_gt,
  [anon_sym_slt] = anon_sym_slt,
  [anon_sym_sgt] = anon_sym_sgt,
  [anon_sym_eq] = anon_sym_eq,
  [anon_sym_iszero] = anon_sym_iszero,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_xor] = anon_sym_xor,
  [anon_sym_byte] = anon_sym_byte,
  [anon_sym_shl] = anon_sym_shl,
  [anon_sym_shr] = anon_sym_shr,
  [anon_sym_sar] = anon_sym_sar,
  [anon_sym_addmod] = anon_sym_addmod,
  [anon_sym_mulmod] = anon_sym_mulmod,
  [anon_sym_signextend] = anon_sym_signextend,
  [anon_sym_keccak256] = anon_sym_keccak256,
  [anon_sym_pop] = anon_sym_pop,
  [anon_sym_mload] = anon_sym_mload,
  [anon_sym_mcopy] = anon_sym_mcopy,
  [anon_sym_tload] = anon_sym_tload,
  [anon_sym_tstore] = anon_sym_tstore,
  [anon_sym_mstore] = anon_sym_mstore,
  [anon_sym_mstore8] = anon_sym_mstore8,
  [anon_sym_sload] = anon_sym_sload,
  [anon_sym_sstore] = anon_sym_sstore,
  [anon_sym_msize] = anon_sym_msize,
  [anon_sym_gas] = anon_sym_gas,
  [anon_sym_address] = anon_sym_address,
  [anon_sym_balance] = anon_sym_balance,
  [anon_sym_selfbalance] = anon_sym_selfbalance,
  [anon_sym_caller] = anon_sym_caller,
  [anon_sym_callvalue] = anon_sym_callvalue,
  [anon_sym_calldataload] = anon_sym_calldataload,
  [anon_sym_calldatasize] = anon_sym_calldatasize,
  [anon_sym_calldatacopy] = anon_sym_calldatacopy,
  [anon_sym_extcodesize] = anon_sym_extcodesize,
  [anon_sym_extcodecopy] = anon_sym_extcodecopy,
  [anon_sym_returndatasize] = anon_sym_returndatasize,
  [anon_sym_returndatacopy] = anon_sym_returndatacopy,
  [anon_sym_extcodehash] = anon_sym_extcodehash,
  [anon_sym_create] = anon_sym_create,
  [anon_sym_create2] = anon_sym_create2,
  [anon_sym_call] = anon_sym_call,
  [anon_sym_callcode] = anon_sym_callcode,
  [anon_sym_delegatecall] = anon_sym_delegatecall,
  [anon_sym_staticcall] = anon_sym_staticcall,
  [anon_sym_return] = anon_sym_return,
  [anon_sym_revert] = anon_sym_revert,
  [anon_sym_selfdestruct] = anon_sym_selfdestruct,
  [anon_sym_invalid] = anon_sym_invalid,
  [anon_sym_log0] = anon_sym_log0,
  [anon_sym_log1] = anon_sym_log1,
  [anon_sym_log2] = anon_sym_log2,
  [anon_sym_log3] = anon_sym_log3,
  [anon_sym_log4] = anon_sym_log4,
  [anon_sym_chainid] = anon_sym_chainid,
  [anon_sym_origin] = anon_sym_origin,
  [anon_sym_gasprice] = anon_sym_gasprice,
  [anon_sym_blockhash] = anon_sym_blockhash,
  [anon_sym_blobhash] = anon_sym_blobhash,
  [anon_sym_basefee] = anon_sym_basefee,
  [anon_sym_blobfee] = anon_sym_blobfee,
  [anon_sym_coinbase] = anon_sym_coinbase,
  [anon_sym_timestamp] = anon_sym_timestamp,
  [anon_sym_number] = anon_sym_number,
  [anon_sym_difficulty] = anon_sym_difficulty,
  [anon_sym_gaslimit] = anon_sym_gaslimit,
  [sym_unchecked] = sym_unchecked,
  [anon_sym_memory] = anon_sym_memory,
  [anon_sym_storage] = anon_sym_storage,
  [anon_sym_calldata] = anon_sym_calldata,
  [anon_sym_var] = anon_sym_var,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_do] = anon_sym_do,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_returns] = anon_sym_returns,
  [anon_sym_catch] = anon_sym_catch,
  [anon_sym_emit] = anon_sym_emit,
  [anon_sym_public] = anon_sym_public,
  [anon_sym_internal] = anon_sym_internal,
  [anon_sym_private] = anon_sym_private,
  [anon_sym_external] = anon_sym_external,
  [anon_sym_pure] = anon_sym_pure,
  [anon_sym_view] = anon_sym_view,
  [anon_sym_payable] = anon_sym_payable,
  [anon_sym_transient] = anon_sym_transient,
  [sym_immutable] = sym_immutable,
  [anon_sym_override] = anon_sym_override,
  [anon_sym_modifier] = anon_sym_modifier,
  [anon_sym_constructor] = anon_sym_constructor,
  [anon_sym_fallback] = anon_sym_fallback,
  [anon_sym_receive] = anon_sym_receive,
  [sym_virtual] = sym_virtual,
  [anon_sym_QMARK] = anon_sym_QMARK,
  [anon_sym_new] = anon_sym_new,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_AMP_AMP] = anon_sym_AMP_AMP,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_delete] = anon_sym_delete,
  [anon_sym_BANG] = anon_sym_BANG,
  [anon_sym_PLUS_PLUS] = anon_sym_PLUS_PLUS,
  [anon_sym_DASH_DASH] = anon_sym_DASH_DASH,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_mapping] = anon_sym_mapping,
  [anon_sym_EQ_GT] = anon_sym_EQ_GT,
  [anon_sym_bool] = anon_sym_bool,
  [anon_sym_string] = anon_sym_string,
  [anon_sym_int] = anon_sym_int,
  [anon_sym_int8] = anon_sym_int8,
  [anon_sym_int16] = anon_sym_int16,
  [anon_sym_int24] = anon_sym_int24,
  [anon_sym_int32] = anon_sym_int32,
  [anon_sym_int40] = anon_sym_int40,
  [anon_sym_int48] = anon_sym_int48,
  [anon_sym_int56] = anon_sym_int56,
  [anon_sym_int64] = anon_sym_int64,
  [anon_sym_int72] = anon_sym_int72,
  [anon_sym_int80] = anon_sym_int80,
  [anon_sym_int88] = anon_sym_int88,
  [anon_sym_int96] = anon_sym_int96,
  [anon_sym_int104] = anon_sym_int104,
  [anon_sym_int112] = anon_sym_int112,
  [anon_sym_int120] = anon_sym_int120,
  [anon_sym_int128] = anon_sym_int128,
  [anon_sym_int136] = anon_sym_int136,
  [anon_sym_int144] = anon_sym_int144,
  [anon_sym_int152] = anon_sym_int152,
  [anon_sym_int160] = anon_sym_int160,
  [anon_sym_int168] = anon_sym_int168,
  [anon_sym_int176] = anon_sym_int176,
  [anon_sym_int184] = anon_sym_int184,
  [anon_sym_int192] = anon_sym_int192,
  [anon_sym_int200] = anon_sym_int200,
  [anon_sym_int208] = anon_sym_int208,
  [anon_sym_int216] = anon_sym_int216,
  [anon_sym_int224] = anon_sym_int224,
  [anon_sym_int232] = anon_sym_int232,
  [anon_sym_int240] = anon_sym_int240,
  [anon_sym_int248] = anon_sym_int248,
  [anon_sym_int256] = anon_sym_int256,
  [anon_sym_uint] = anon_sym_uint,
  [anon_sym_uint8] = anon_sym_uint8,
  [anon_sym_uint16] = anon_sym_uint16,
  [anon_sym_uint24] = anon_sym_uint24,
  [anon_sym_uint32] = anon_sym_uint32,
  [anon_sym_uint40] = anon_sym_uint40,
  [anon_sym_uint48] = anon_sym_uint48,
  [anon_sym_uint56] = anon_sym_uint56,
  [anon_sym_uint64] = anon_sym_uint64,
  [anon_sym_uint72] = anon_sym_uint72,
  [anon_sym_uint80] = anon_sym_uint80,
  [anon_sym_uint88] = anon_sym_uint88,
  [anon_sym_uint96] = anon_sym_uint96,
  [anon_sym_uint104] = anon_sym_uint104,
  [anon_sym_uint112] = anon_sym_uint112,
  [anon_sym_uint120] = anon_sym_uint120,
  [anon_sym_uint128] = anon_sym_uint128,
  [anon_sym_uint136] = anon_sym_uint136,
  [anon_sym_uint144] = anon_sym_uint144,
  [anon_sym_uint152] = anon_sym_uint152,
  [anon_sym_uint160] = anon_sym_uint160,
  [anon_sym_uint168] = anon_sym_uint168,
  [anon_sym_uint176] = anon_sym_uint176,
  [anon_sym_uint184] = anon_sym_uint184,
  [anon_sym_uint192] = anon_sym_uint192,
  [anon_sym_uint200] = anon_sym_uint200,
  [anon_sym_uint208] = anon_sym_uint208,
  [anon_sym_uint216] = anon_sym_uint216,
  [anon_sym_uint224] = anon_sym_uint224,
  [anon_sym_uint232] = anon_sym_uint232,
  [anon_sym_uint240] = anon_sym_uint240,
  [anon_sym_uint248] = anon_sym_uint248,
  [anon_sym_uint256] = anon_sym_uint256,
  [anon_sym_bytes] = anon_sym_bytes,
  [anon_sym_bytes1] = anon_sym_bytes1,
  [anon_sym_bytes2] = anon_sym_bytes2,
  [anon_sym_bytes3] = anon_sym_bytes3,
  [anon_sym_bytes4] = anon_sym_bytes4,
  [anon_sym_bytes5] = anon_sym_bytes5,
  [anon_sym_bytes6] = anon_sym_bytes6,
  [anon_sym_bytes7] = anon_sym_bytes7,
  [anon_sym_bytes8] = anon_sym_bytes8,
  [anon_sym_bytes9] = anon_sym_bytes9,
  [anon_sym_bytes10] = anon_sym_bytes10,
  [anon_sym_bytes11] = anon_sym_bytes11,
  [anon_sym_bytes12] = anon_sym_bytes12,
  [anon_sym_bytes13] = anon_sym_bytes13,
  [anon_sym_bytes14] = anon_sym_bytes14,
  [anon_sym_bytes15] = anon_sym_bytes15,
  [anon_sym_bytes16] = anon_sym_bytes16,
  [anon_sym_bytes17] = anon_sym_bytes17,
  [anon_sym_bytes18] = anon_sym_bytes18,
  [anon_sym_bytes19] = anon_sym_bytes19,
  [anon_sym_bytes20] = anon_sym_bytes20,
  [anon_sym_bytes21] = anon_sym_bytes21,
  [anon_sym_bytes22] = anon_sym_bytes22,
  [anon_sym_bytes23] = anon_sym_bytes23,
  [anon_sym_bytes24] = anon_sym_bytes24,
  [anon_sym_bytes25] = anon_sym_bytes25,
  [anon_sym_bytes26] = anon_sym_bytes26,
  [anon_sym_bytes27] = anon_sym_bytes27,
  [anon_sym_bytes28] = anon_sym_bytes28,
  [anon_sym_bytes29] = anon_sym_bytes29,
  [anon_sym_bytes30] = anon_sym_bytes30,
  [anon_sym_bytes31] = anon_sym_bytes31,
  [anon_sym_bytes32] = anon_sym_bytes32,
  [anon_sym_fixed] = anon_sym_fixed,
  [aux_sym__fixed_token1] = aux_sym__fixed_token1,
  [anon_sym_ufixed] = anon_sym_ufixed,
  [aux_sym__ufixed_token1] = aux_sym__ufixed_token1,
  [anon_sym_SEMI] = anon_sym_SEMI,
  [aux_sym__decimal_number_token1] = aux_sym__decimal_number_token1,
  [aux_sym__decimal_number_token2] = aux_sym__decimal_number_token2,
  [aux_sym__hex_number_token1] = aux_sym__hex_number_token1,
  [sym__hex_digit] = sym__hex_digit,
  [anon_sym_wei] = anon_sym_wei,
  [anon_sym_szabo] = anon_sym_szabo,
  [anon_sym_finney] = anon_sym_finney,
  [anon_sym_gwei] = anon_sym_gwei,
  [anon_sym_ether] = anon_sym_ether,
  [anon_sym_seconds] = anon_sym_seconds,
  [anon_sym_minutes] = anon_sym_minutes,
  [anon_sym_hours] = anon_sym_hours,
  [anon_sym_days] = anon_sym_days,
  [anon_sym_weeks] = anon_sym_weeks,
  [anon_sym_years] = anon_sym_years,
  [anon_sym_hex] = anon_sym_hex,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [anon_sym__] = anon_sym__,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [sym__escape_sequence] = sym__escape_sequence,
  [aux_sym__single_quoted_unicode_char_token1] = aux_sym__single_quoted_unicode_char_token1,
  [aux_sym__double_quoted_unicode_char_token1] = aux_sym__double_quoted_unicode_char_token1,
  [anon_sym_unicode] = anon_sym_unicode,
  [sym_comment] = sym_comment,
  [sym_source_file] = sym_source_file,
  [sym__source_unit] = sym__source_unit,
  [sym__directive] = sym__directive,
  [sym_pragma_directive] = sym_pragma_directive,
  [sym_solidity_pragma_token] = sym_solidity_pragma_token,
  [sym_any_pragma_token] = sym_any_pragma_token,
  [sym__solidity] = sym__solidity,
  [sym_pragma_value] = sym_pragma_value,
  [sym__pragma_version_constraint] = sym__pragma_version_constraint,
  [sym_solidity_version_comparison_operator] = sym_solidity_version_comparison_operator,
  [sym_import_directive] = sym_import_directive,
  [sym__source_import] = sym__source_import,
  [sym__import_clause] = sym__import_clause,
  [sym__from_clause] = sym__from_clause,
  [sym__single_import] = sym__single_import,
  [sym__multiple_import] = sym__multiple_import,
  [sym__import_declaration] = sym__import_declaration,
  [sym__import_alias] = sym__import_alias,
  [sym__declaration] = sym__declaration,
  [sym_user_defined_type_definition] = sym_user_defined_type_definition,
  [sym_constant_variable_declaration] = sym_constant_variable_declaration,
  [sym_contract_declaration] = sym_contract_declaration,
  [sym_error_declaration] = sym_error_declaration,
  [sym_error_parameter] = sym_error_parameter,
  [sym_interface_declaration] = sym_interface_declaration,
  [sym_library_declaration] = sym_library_declaration,
  [sym__class_heritage] = sym__class_heritage,
  [sym_inheritance_specifier] = sym_inheritance_specifier,
  [sym_contract_body] = sym_contract_body,
  [sym__contract_member] = sym__contract_member,
  [sym_struct_declaration] = sym_struct_declaration,
  [sym_struct_member] = sym_struct_member,
  [sym_struct_body] = sym_struct_body,
  [sym_enum_declaration] = sym_enum_declaration,
  [sym_enum_body] = sym_enum_body,
  [sym_event_definition] = sym_event_definition,
  [sym__event_parameter_list] = sym__event_parameter_list,
  [sym_event_parameter] = sym_event_parameter,
  [sym_using_directive] = sym_using_directive,
  [sym_any_source_type] = sym_any_source_type,
  [sym_statement] = sym_statement,
  [sym_assembly_statement] = sym_assembly_statement,
  [sym_assembly_flags] = sym_assembly_flags,
  [sym__yul_statement] = sym__yul_statement,
  [sym_yul_label] = sym_yul_label,
  [sym_yul_break] = sym_yul_break,
  [sym_yul_continue] = sym_yul_continue,
  [sym_yul_identifier] = sym_yul_identifier,
  [sym__yul_expression] = sym__yul_expression,
  [sym_yul_path] = sym_yul_path,
  [sym__yul_literal] = sym__yul_literal,
  [sym_yul_string_literal] = sym_yul_string_literal,
  [sym_yul_boolean] = sym_yul_boolean,
  [sym_yul_block] = sym_yul_block,
  [sym_yul_variable_declaration] = sym_yul_variable_declaration,
  [sym__yul_assignment_operator] = sym__yul_assignment_operator,
  [sym_yul_assignment] = sym_yul_assignment,
  [sym_yul_function_call] = sym_yul_function_call,
  [sym_yul_if_statement] = sym_yul_if_statement,
  [sym_yul_for_statement] = sym_yul_for_statement,
  [sym_yul_switch_statement] = sym_yul_switch_statement,
  [sym_yul_function_definition] = sym_yul_function_definition,
  [sym_yul_evm_builtin] = sym_yul_evm_builtin,
  [sym_block_statement] = sym_block_statement,
  [sym_variable_declaration_statement] = sym_variable_declaration_statement,
  [sym_variable_declaration] = sym_variable_declaration,
  [sym_variable_declaration_tuple] = sym_variable_declaration_tuple,
  [sym_expression_statement] = sym_expression_statement,
  [sym_if_statement] = sym_if_statement,
  [sym_for_statement] = sym_for_statement,
  [sym_while_statement] = sym_while_statement,
  [sym_do_while_statement] = sym_do_while_statement,
  [sym_continue_statement] = sym_continue_statement,
  [sym_break_statement] = sym_break_statement,
  [sym_revert_statement] = sym_revert_statement,
  [sym_try_statement] = sym_try_statement,
  [sym_catch_clause] = sym_catch_clause,
  [sym_return_statement] = sym_return_statement,
  [sym_emit_statement] = sym_emit_statement,
  [sym_state_variable_declaration] = sym_state_variable_declaration,
  [sym_visibility] = sym_visibility,
  [sym_state_mutability] = sym_state_mutability,
  [sym_state_location] = sym_state_location,
  [sym_override_specifier] = sym_override_specifier,
  [sym_modifier_definition] = sym_modifier_definition,
  [sym_constructor_definition] = sym_constructor_definition,
  [sym_fallback_receive_definition] = sym_fallback_receive_definition,
  [sym_function_definition] = sym_function_definition,
  [sym_return_type_definition] = sym_return_type_definition,
  [sym_modifier_invocation] = sym_modifier_invocation,
  [sym__call_arguments] = sym__call_arguments,
  [sym_call_argument] = sym_call_argument,
  [sym_call_struct_argument] = sym_call_struct_argument,
  [sym_function_body] = sym_function_body,
  [sym_expression] = sym_expression,
  [sym__primary_expression] = sym__primary_expression,
  [sym_type_cast_expression] = sym_type_cast_expression,
  [sym_ternary_expression] = sym_ternary_expression,
  [sym_new_expression] = sym_new_expression,
  [sym_tuple_expression] = sym_tuple_expression,
  [sym_inline_array_expression] = sym_inline_array_expression,
  [sym_binary_expression] = sym_binary_expression,
  [sym_unary_expression] = sym_unary_expression,
  [sym_update_expression] = sym_update_expression,
  [sym_member_expression] = sym_member_expression,
  [sym_array_access] = sym_array_access,
  [sym_slice_access] = sym_slice_access,
  [sym_struct_expression] = sym_struct_expression,
  [sym_struct_field_assignment] = sym_struct_field_assignment,
  [sym_parenthesized_expression] = sym_parenthesized_expression,
  [sym_assignment_expression] = sym_assignment_expression,
  [sym_augmented_assignment_expression] = sym_augmented_assignment_expression,
  [sym_call_expression] = sym_call_expression,
  [sym_payable_conversion_expression] = sym_payable_conversion_expression,
  [sym_meta_type_expression] = sym_meta_type_expression,
  [sym_type_name] = sym_type_name,
  [sym__array_type] = sym__array_type,
  [sym__function_type] = sym__function_type,
  [sym__parameter_list] = sym__parameter_list,
  [sym__return_parameters] = sym__return_parameters,
  [sym__nameless_parameter] = sym__nameless_parameter,
  [sym_parameter] = sym_parameter,
  [sym__storage_location] = sym__storage_location,
  [sym_user_defined_type] = sym_user_defined_type,
  [sym__identifier_path] = sym__identifier_path,
  [sym__mapping] = sym__mapping,
  [sym__mapping_key] = sym__mapping_key,
  [sym_primitive_type] = sym_primitive_type,
  [sym__int] = sym__int,
  [sym__uint] = sym__uint,
  [sym__bytes] = sym__bytes,
  [sym__fixed] = sym__fixed,
  [sym__ufixed] = sym__ufixed,
  [sym__semicolon] = sym__semicolon,
  [sym__literal] = sym__literal,
  [sym_string_literal] = sym_string_literal,
  [sym_number_literal] = sym_number_literal,
  [sym__decimal_number] = sym__decimal_number,
  [sym__hex_number] = sym__hex_number,
  [sym_number_unit] = sym_number_unit,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_boolean_literal] = sym_boolean_literal,
  [sym_hex_string_literal] = sym_hex_string_literal,
  [sym__single_quoted_unicode_char] = sym__single_quoted_unicode_char,
  [sym__double_quoted_unicode_char] = sym__double_quoted_unicode_char,
  [sym_unicode_string_literal] = sym_unicode_string_literal,
  [sym_string] = sym_string,
  [sym__string_immediate_elt_inside_double_quote] = sym__string_immediate_elt_inside_double_quote,
  [sym__string_immediate_elt_inside_quote] = sym__string_immediate_elt_inside_quote,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_solidity_pragma_token_repeat1] = aux_sym_solidity_pragma_token_repeat1,
  [aux_sym__multiple_import_repeat1] = aux_sym__multiple_import_repeat1,
  [aux_sym_error_declaration_repeat1] = aux_sym_error_declaration_repeat1,
  [aux_sym__class_heritage_repeat1] = aux_sym__class_heritage_repeat1,
  [aux_sym_contract_body_repeat1] = aux_sym_contract_body_repeat1,
  [aux_sym_struct_body_repeat1] = aux_sym_struct_body_repeat1,
  [aux_sym_enum_body_repeat1] = aux_sym_enum_body_repeat1,
  [aux_sym__event_parameter_list_repeat1] = aux_sym__event_parameter_list_repeat1,
  [aux_sym_assembly_statement_repeat1] = aux_sym_assembly_statement_repeat1,
  [aux_sym_assembly_flags_repeat1] = aux_sym_assembly_flags_repeat1,
  [aux_sym_yul_path_repeat1] = aux_sym_yul_path_repeat1,
  [aux_sym_yul_variable_declaration_repeat1] = aux_sym_yul_variable_declaration_repeat1,
  [aux_sym_yul_assignment_repeat1] = aux_sym_yul_assignment_repeat1,
  [aux_sym_yul_function_call_repeat1] = aux_sym_yul_function_call_repeat1,
  [aux_sym_yul_switch_statement_repeat1] = aux_sym_yul_switch_statement_repeat1,
  [aux_sym_block_statement_repeat1] = aux_sym_block_statement_repeat1,
  [aux_sym_variable_declaration_tuple_repeat1] = aux_sym_variable_declaration_tuple_repeat1,
  [aux_sym_variable_declaration_tuple_repeat2] = aux_sym_variable_declaration_tuple_repeat2,
  [aux_sym_try_statement_repeat1] = aux_sym_try_statement_repeat1,
  [aux_sym_state_variable_declaration_repeat1] = aux_sym_state_variable_declaration_repeat1,
  [aux_sym_override_specifier_repeat1] = aux_sym_override_specifier_repeat1,
  [aux_sym_modifier_definition_repeat1] = aux_sym_modifier_definition_repeat1,
  [aux_sym_constructor_definition_repeat1] = aux_sym_constructor_definition_repeat1,
  [aux_sym_fallback_receive_definition_repeat1] = aux_sym_fallback_receive_definition_repeat1,
  [aux_sym_function_definition_repeat1] = aux_sym_function_definition_repeat1,
  [aux_sym__call_arguments_repeat1] = aux_sym__call_arguments_repeat1,
  [aux_sym_call_argument_repeat1] = aux_sym_call_argument_repeat1,
  [aux_sym_tuple_expression_repeat1] = aux_sym_tuple_expression_repeat1,
  [aux_sym_inline_array_expression_repeat1] = aux_sym_inline_array_expression_repeat1,
  [aux_sym_struct_expression_repeat1] = aux_sym_struct_expression_repeat1,
  [aux_sym__function_type_repeat1] = aux_sym__function_type_repeat1,
  [aux_sym__parameter_list_repeat1] = aux_sym__parameter_list_repeat1,
  [aux_sym__return_parameters_repeat1] = aux_sym__return_parameters_repeat1,
  [aux_sym__identifier_path_repeat1] = aux_sym__identifier_path_repeat1,
  [aux_sym_string_literal_repeat1] = aux_sym_string_literal_repeat1,
  [aux_sym_hex_string_literal_repeat1] = aux_sym_hex_string_literal_repeat1,
  [aux_sym_hex_string_literal_repeat2] = aux_sym_hex_string_literal_repeat2,
  [aux_sym_unicode_string_literal_repeat1] = aux_sym_unicode_string_literal_repeat1,
  [aux_sym_unicode_string_literal_repeat2] = aux_sym_unicode_string_literal_repeat2,
  [aux_sym_unicode_string_literal_repeat3] = aux_sym_unicode_string_literal_repeat3,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [alias_sym_enum_value] = alias_sym_enum_value,
  [alias_sym_revert_arguments] = alias_sym_revert_arguments,
  [alias_sym_type_alias] = alias_sym_type_alias,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_pragma] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_solidity] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_pragma_value_token1] = {
    .visible = false,
    .named = false,
  },
  [sym_solidity_version] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_TILDE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_from] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_type] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_is] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constant] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_abstract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_contract] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_error] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_interface] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_library] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_struct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_event] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_anonymous] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_indexed] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_using] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_assembly] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTEevmasm_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [sym_yul_leave] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_break] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_continue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [sym_yul_decimal_number] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_hex_number] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_switch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_default] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_function] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_stop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_add] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sub] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mul] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_div] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sdiv] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_smod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_exp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_not] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_lt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_slt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sgt] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_eq] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_iszero] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_xor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_byte] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_shr] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sar] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_addmod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mulmod] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_signextend] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_keccak256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mcopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_tstore] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mstore] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mstore8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_sstore] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_msize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gas] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_address] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_balance] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_selfbalance] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_caller] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callvalue] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldataload] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldatasize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldatacopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extcodesize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extcodecopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returndatasize] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returndatacopy] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extcodehash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_create] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_create2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_call] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_callcode] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delegatecall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_staticcall] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_revert] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_selfdestruct] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_invalid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log0] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_log4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_chainid] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_origin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gasprice] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blockhash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blobhash] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_basefee] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_blobfee] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_coinbase] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_timestamp] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_number] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_difficulty] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gaslimit] = {
    .visible = true,
    .named = false,
  },
  [sym_unchecked] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_memory] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_storage] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_calldata] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_var] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_do] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_returns] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_catch] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_emit] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_public] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_internal] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_private] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_external] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_pure] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_view] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_payable] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_transient] = {
    .visible = true,
    .named = false,
  },
  [sym_immutable] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_override] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_modifier] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_constructor] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fallback] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_receive] = {
    .visible = true,
    .named = false,
  },
  [sym_virtual] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_QMARK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_new] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_delete] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mapping] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bool] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_string] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int80] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int88] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int96] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int104] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int112] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int120] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int136] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int144] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int152] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int160] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int168] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int176] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int184] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int208] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int216] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int224] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int232] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int240] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int248] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_int256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint40] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint48] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint56] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint64] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint72] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint80] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint88] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint96] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint104] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint112] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint120] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint128] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint136] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint144] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint152] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint160] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint168] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint176] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint184] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint192] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint200] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint208] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint216] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint224] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint232] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint240] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint248] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uint256] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes1] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes3] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes4] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes5] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes6] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes7] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes8] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes9] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes10] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes11] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes12] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes13] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes14] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes15] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes16] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes17] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes18] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes19] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes20] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes21] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes22] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes23] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes24] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes25] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes26] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes27] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes28] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes29] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes30] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes31] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_bytes32] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_fixed] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__fixed_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_ufixed] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__ufixed_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_SEMI] = {
    .visible = true,
    .named = false,
  },
  [aux_sym__decimal_number_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__decimal_number_token2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__hex_number_token1] = {
    .visible = false,
    .named = false,
  },
  [sym__hex_digit] = {
    .visible = false,
    .named = true,
  },
  [anon_sym_wei] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_szabo] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_finney] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_gwei] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ether] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_seconds] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_minutes] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hours] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_days] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_weeks] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_years] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_hex] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym__] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [sym__escape_sequence] = {
    .visible = false,
    .named = true,
  },
  [aux_sym__single_quoted_unicode_char_token1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__double_quoted_unicode_char_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_unicode] = {
    .visible = true,
    .named = false,
  },
  [sym_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__source_unit] = {
    .visible = false,
    .named = true,
  },
  [sym__directive] = {
    .visible = false,
    .named = true,
  },
  [sym_pragma_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_solidity_pragma_token] = {
    .visible = true,
    .named = true,
  },
  [sym_any_pragma_token] = {
    .visible = true,
    .named = true,
  },
  [sym__solidity] = {
    .visible = false,
    .named = true,
  },
  [sym_pragma_value] = {
    .visible = true,
    .named = true,
  },
  [sym__pragma_version_constraint] = {
    .visible = false,
    .named = true,
  },
  [sym_solidity_version_comparison_operator] = {
    .visible = true,
    .named = true,
  },
  [sym_import_directive] = {
    .visible = true,
    .named = true,
  },
  [sym__source_import] = {
    .visible = false,
    .named = true,
  },
  [sym__import_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__from_clause] = {
    .visible = false,
    .named = true,
  },
  [sym__single_import] = {
    .visible = false,
    .named = true,
  },
  [sym__multiple_import] = {
    .visible = false,
    .named = true,
  },
  [sym__import_declaration] = {
    .visible = false,
    .named = true,
  },
  [sym__import_alias] = {
    .visible = false,
    .named = true,
  },
  [sym__declaration] = {
    .visible = false,
    .named = true,
  },
  [sym_user_defined_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constant_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_error_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_error_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_interface_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_library_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__class_heritage] = {
    .visible = false,
    .named = true,
  },
  [sym_inheritance_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_contract_body] = {
    .visible = true,
    .named = true,
  },
  [sym__contract_member] = {
    .visible = false,
    .named = true,
  },
  [sym_struct_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_member] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_body] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_body] = {
    .visible = true,
    .named = true,
  },
  [sym_event_definition] = {
    .visible = true,
    .named = true,
  },
  [sym__event_parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym_event_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_using_directive] = {
    .visible = true,
    .named = true,
  },
  [sym_any_source_type] = {
    .visible = true,
    .named = true,
  },
  [sym_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assembly_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_assembly_flags] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_statement] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_label] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_break] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_continue] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_identifier] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_path] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_literal] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_boolean] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_block] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym__yul_assignment_operator] = {
    .visible = false,
    .named = true,
  },
  [sym_yul_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_function_call] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_switch_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_yul_evm_builtin] = {
    .visible = true,
    .named = true,
  },
  [sym_block_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_variable_declaration_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_expression_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_if_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_for_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_do_while_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_continue_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_break_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_revert_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_try_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_catch_clause] = {
    .visible = true,
    .named = true,
  },
  [sym_return_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_emit_statement] = {
    .visible = true,
    .named = true,
  },
  [sym_state_variable_declaration] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_state_mutability] = {
    .visible = true,
    .named = true,
  },
  [sym_state_location] = {
    .visible = true,
    .named = true,
  },
  [sym_override_specifier] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_constructor_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_fallback_receive_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_function_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_return_type_definition] = {
    .visible = true,
    .named = true,
  },
  [sym_modifier_invocation] = {
    .visible = true,
    .named = true,
  },
  [sym__call_arguments] = {
    .visible = false,
    .named = true,
  },
  [sym_call_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_call_struct_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_function_body] = {
    .visible = true,
    .named = true,
  },
  [sym_expression] = {
    .visible = true,
    .named = true,
  },
  [sym__primary_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_type_cast_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_ternary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_new_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_inline_array_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_binary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_unary_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_update_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_member_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_array_access] = {
    .visible = true,
    .named = true,
  },
  [sym_slice_access] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_struct_field_assignment] = {
    .visible = true,
    .named = true,
  },
  [sym_parenthesized_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_augmented_assignment_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_call_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_payable_conversion_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_meta_type_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_type_name] = {
    .visible = true,
    .named = true,
  },
  [sym__array_type] = {
    .visible = false,
    .named = true,
  },
  [sym__function_type] = {
    .visible = false,
    .named = true,
  },
  [sym__parameter_list] = {
    .visible = false,
    .named = true,
  },
  [sym__return_parameters] = {
    .visible = false,
    .named = true,
  },
  [sym__nameless_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym__storage_location] = {
    .visible = false,
    .named = true,
  },
  [sym_user_defined_type] = {
    .visible = true,
    .named = true,
  },
  [sym__identifier_path] = {
    .visible = false,
    .named = true,
  },
  [sym__mapping] = {
    .visible = false,
    .named = true,
  },
  [sym__mapping_key] = {
    .visible = false,
    .named = true,
  },
  [sym_primitive_type] = {
    .visible = true,
    .named = true,
  },
  [sym__int] = {
    .visible = false,
    .named = true,
  },
  [sym__uint] = {
    .visible = false,
    .named = true,
  },
  [sym__bytes] = {
    .visible = false,
    .named = true,
  },
  [sym__fixed] = {
    .visible = false,
    .named = true,
  },
  [sym__ufixed] = {
    .visible = false,
    .named = true,
  },
  [sym__semicolon] = {
    .visible = false,
    .named = true,
  },
  [sym__literal] = {
    .visible = false,
    .named = true,
  },
  [sym_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_number_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__decimal_number] = {
    .visible = false,
    .named = true,
  },
  [sym__hex_number] = {
    .visible = false,
    .named = true,
  },
  [sym_number_unit] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_hex_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym__single_quoted_unicode_char] = {
    .visible = false,
    .named = true,
  },
  [sym__double_quoted_unicode_char] = {
    .visible = false,
    .named = true,
  },
  [sym_unicode_string_literal] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym__string_immediate_elt_inside_double_quote] = {
    .visible = false,
    .named = true,
  },
  [sym__string_immediate_elt_inside_quote] = {
    .visible = false,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_solidity_pragma_token_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__multiple_import_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_error_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__class_heritage_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_contract_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_enum_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__event_parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assembly_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_assembly_flags_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_assignment_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_function_call_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_yul_switch_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_variable_declaration_tuple_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_try_statement_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_state_variable_declaration_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_override_specifier_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_modifier_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_constructor_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_fallback_receive_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_function_definition_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_argument_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_inline_array_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_struct_expression_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__function_type_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__parameter_list_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__return_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym__identifier_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_hex_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_hex_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unicode_string_literal_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unicode_string_literal_repeat2] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_unicode_string_literal_repeat3] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_enum_value] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_revert_arguments] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type_alias] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_ancestor = 2,
  field_ancestor_arguments = 3,
  field_argument = 4,
  field_attempt = 5,
  field_base = 6,
  field_body = 7,
  field_condition = 8,
  field_else = 9,
  field_error = 10,
  field_from = 11,
  field_function = 12,
  field_import_name = 13,
  field_index = 14,
  field_initial = 15,
  field_key_identifier = 16,
  field_key_type = 17,
  field_left = 18,
  field_location = 19,
  field_name = 20,
  field_object = 21,
  field_operator = 22,
  field_parameters = 23,
  field_property = 24,
  field_return_type = 25,
  field_right = 26,
  field_source = 27,
  field_to = 28,
  field_type = 29,
  field_update = 30,
  field_value = 31,
  field_value_identifier = 32,
  field_value_type = 33,
  field_version_constraint = 34,
  field_visibility = 35,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_ancestor] = "ancestor",
  [field_ancestor_arguments] = "ancestor_arguments",
  [field_argument] = "argument",
  [field_attempt] = "attempt",
  [field_base] = "base",
  [field_body] = "body",
  [field_condition] = "condition",
  [field_else] = "else",
  [field_error] = "error",
  [field_from] = "from",
  [field_function] = "function",
  [field_import_name] = "import_name",
  [field_index] = "index",
  [field_initial] = "initial",
  [field_key_identifier] = "key_identifier",
  [field_key_type] = "key_type",
  [field_left] = "left",
  [field_location] = "location",
  [field_name] = "name",
  [field_object] = "object",
  [field_operator] = "operator",
  [field_parameters] = "parameters",
  [field_property] = "property",
  [field_return_type] = "return_type",
  [field_right] = "right",
  [field_source] = "source",
  [field_to] = "to",
  [field_type] = "type",
  [field_update] = "update",
  [field_value] = "value",
  [field_value_identifier] = "value_identifier",
  [field_value_type] = "value_type",
  [field_version_constraint] = "version_constraint",
  [field_visibility] = "visibility",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [1] = {.index = 0, .length = 1},
  [2] = {.index = 1, .length = 4},
  [3] = {.index = 5, .length = 1},
  [4] = {.index = 6, .length = 2},
  [5] = {.index = 8, .length = 1},
  [6] = {.index = 9, .length = 1},
  [7] = {.index = 10, .length = 1},
  [8] = {.index = 11, .length = 1},
  [9] = {.index = 12, .length = 1},
  [10] = {.index = 13, .length = 2},
  [11] = {.index = 15, .length = 2},
  [12] = {.index = 17, .length = 2},
  [13] = {.index = 19, .length = 2},
  [14] = {.index = 21, .length = 1},
  [15] = {.index = 22, .length = 2},
  [16] = {.index = 24, .length = 1},
  [17] = {.index = 25, .length = 2},
  [18] = {.index = 27, .length = 1},
  [19] = {.index = 28, .length = 3},
  [20] = {.index = 31, .length = 2},
  [21] = {.index = 33, .length = 1},
  [22] = {.index = 34, .length = 2},
  [23] = {.index = 36, .length = 1},
  [24] = {.index = 37, .length = 2},
  [25] = {.index = 39, .length = 2},
  [26] = {.index = 41, .length = 2},
  [27] = {.index = 43, .length = 2},
  [28] = {.index = 45, .length = 1},
  [29] = {.index = 46, .length = 4},
  [30] = {.index = 50, .length = 4},
  [31] = {.index = 54, .length = 2},
  [32] = {.index = 56, .length = 1},
  [33] = {.index = 57, .length = 1},
  [34] = {.index = 58, .length = 2},
  [36] = {.index = 60, .length = 3},
  [37] = {.index = 63, .length = 3},
  [38] = {.index = 66, .length = 2},
  [39] = {.index = 68, .length = 2},
  [40] = {.index = 70, .length = 2},
  [41] = {.index = 72, .length = 3},
  [42] = {.index = 75, .length = 2},
  [43] = {.index = 77, .length = 1},
  [44] = {.index = 78, .length = 1},
  [45] = {.index = 79, .length = 4},
  [46] = {.index = 83, .length = 2},
  [47] = {.index = 85, .length = 3},
  [48] = {.index = 88, .length = 2},
  [49] = {.index = 90, .length = 2},
  [50] = {.index = 92, .length = 2},
  [51] = {.index = 94, .length = 3},
  [52] = {.index = 97, .length = 2},
  [53] = {.index = 99, .length = 1},
  [54] = {.index = 100, .length = 4},
  [56] = {.index = 104, .length = 1},
  [57] = {.index = 105, .length = 2},
  [58] = {.index = 107, .length = 3},
  [59] = {.index = 110, .length = 3},
  [60] = {.index = 113, .length = 2},
  [61] = {.index = 115, .length = 2},
  [62] = {.index = 117, .length = 2},
  [63] = {.index = 119, .length = 1},
  [64] = {.index = 120, .length = 3},
  [65] = {.index = 123, .length = 1},
  [66] = {.index = 104, .length = 1},
  [67] = {.index = 124, .length = 2},
  [68] = {.index = 126, .length = 1},
  [69] = {.index = 127, .length = 4},
  [70] = {.index = 131, .length = 3},
  [71] = {.index = 134, .length = 5},
  [72] = {.index = 139, .length = 2},
  [73] = {.index = 141, .length = 2},
  [74] = {.index = 143, .length = 1},
  [75] = {.index = 144, .length = 3},
  [76] = {.index = 147, .length = 3},
  [77] = {.index = 150, .length = 2},
  [78] = {.index = 152, .length = 2},
  [79] = {.index = 154, .length = 4},
  [80] = {.index = 158, .length = 4},
  [81] = {.index = 162, .length = 3},
  [82] = {.index = 165, .length = 4},
  [83] = {.index = 169, .length = 2},
  [84] = {.index = 171, .length = 4},
  [85] = {.index = 175, .length = 5},
  [86] = {.index = 180, .length = 5},
  [87] = {.index = 185, .length = 6},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_parameters, 0, .inherited = true},
  [1] =
    {field_key_identifier, 0, .inherited = true},
    {field_key_type, 0, .inherited = true},
    {field_value_identifier, 0, .inherited = true},
    {field_value_type, 0, .inherited = true},
  [5] =
    {field_import_name, 0},
  [6] =
    {field_alias, 0, .inherited = true},
    {field_import_name, 0, .inherited = true},
  [8] =
    {field_source, 0},
  [9] =
    {field_parameters, 1},
  [10] =
    {field_version_constraint, 0},
  [11] =
    {field_version_constraint, 1, .inherited = true},
  [12] =
    {field_alias, 1, .inherited = true},
  [13] =
    {field_alias, 1, .inherited = true},
    {field_import_name, 0},
  [15] =
    {field_alias, 1, .inherited = true},
    {field_source, 1, .inherited = true},
  [17] =
    {field_alias, 1, .inherited = true},
    {field_source, 0},
  [19] =
    {field_body, 2},
    {field_name, 1},
  [21] =
    {field_type, 0},
  [22] =
    {field_version_constraint, 0, .inherited = true},
    {field_version_constraint, 1, .inherited = true},
  [24] =
    {field_alias, 1},
  [25] =
    {field_alias, 1, .inherited = true},
    {field_import_name, 1, .inherited = true},
  [27] =
    {field_source, 1},
  [28] =
    {field_alias, 1, .inherited = true},
    {field_import_name, 1, .inherited = true},
    {field_source, 2, .inherited = true},
  [31] =
    {field_body, 3},
    {field_name, 2},
  [33] =
    {field_ancestor, 0},
  [34] =
    {field_body, 3},
    {field_name, 1},
  [36] =
    {field_name, 1},
  [37] =
    {field_name, 1},
    {field_type, 0},
  [39] =
    {field_location, 1},
    {field_type, 0},
  [41] =
    {field_argument, 1},
    {field_operator, 0},
  [43] =
    {field_argument, 0},
    {field_operator, 1},
  [45] =
    {field_function, 0},
  [46] =
    {field_alias, 1, .inherited = true},
    {field_alias, 2, .inherited = true},
    {field_import_name, 1, .inherited = true},
    {field_import_name, 2, .inherited = true},
  [50] =
    {field_alias, 0, .inherited = true},
    {field_alias, 1, .inherited = true},
    {field_import_name, 0, .inherited = true},
    {field_import_name, 1, .inherited = true},
  [54] =
    {field_body, 4},
    {field_name, 2},
  [56] =
    {field_visibility, 0},
  [57] =
    {field_location, 0},
  [58] =
    {field_ancestor, 0},
    {field_ancestor_arguments, 1},
  [60] =
    {field_location, 1},
    {field_name, 2},
    {field_type, 0},
  [63] =
    {field_body, 4},
    {field_name, 1},
    {field_return_type, 3},
  [66] =
    {field_name, 1},
    {field_return_type, 3},
  [68] =
    {field_body, 4},
    {field_name, 1},
  [70] =
    {field_object, 0},
    {field_property, 2},
  [72] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [75] =
    {field_left, 0},
    {field_right, 2},
  [77] =
    {field_base, 0},
  [78] =
    {field_body, 2},
  [79] =
    {field_location, 0, .inherited = true},
    {field_location, 1, .inherited = true},
    {field_visibility, 0, .inherited = true},
    {field_visibility, 1, .inherited = true},
  [83] =
    {field_name, 2},
    {field_type, 0},
  [85] =
    {field_body, 5},
    {field_name, 1},
    {field_return_type, 4},
  [88] =
    {field_name, 1},
    {field_return_type, 4},
  [90] =
    {field_location, 2, .inherited = true},
    {field_type, 2, .inherited = true},
  [92] =
    {field_key_type, 2},
    {field_value_type, 4},
  [94] =
    {field_name, 2},
    {field_type, 0},
    {field_value, 4},
  [97] =
    {field_base, 0},
    {field_index, 2},
  [99] =
    {field_body, 3},
  [100] =
    {field_location, 1, .inherited = true},
    {field_name, 2},
    {field_type, 0},
    {field_visibility, 1, .inherited = true},
  [104] =
    {field_error, 1},
  [105] =
    {field_location, 1, .inherited = true},
    {field_type, 1, .inherited = true},
  [107] =
    {field_key_type, 2},
    {field_value_identifier, 5},
    {field_value_type, 4},
  [110] =
    {field_key_identifier, 3},
    {field_key_type, 2},
    {field_value_type, 5},
  [113] =
    {field_name, 0},
    {field_value, 2},
  [115] =
    {field_base, 0},
    {field_to, 3},
  [117] =
    {field_base, 0},
    {field_from, 2},
  [119] =
    {field_source, 3},
  [120] =
    {field_name, 1},
    {field_type, 0},
    {field_value, 3},
  [123] =
    {field_left, 1},
  [124] =
    {field_attempt, 1},
    {field_body, 2},
  [126] =
    {field_value, 2},
  [127] =
    {field_key_identifier, 3},
    {field_key_type, 2},
    {field_value_identifier, 6},
    {field_value_type, 5},
  [131] =
    {field_base, 0},
    {field_from, 2},
    {field_to, 4},
  [134] =
    {field_location, 1, .inherited = true},
    {field_name, 2},
    {field_type, 0},
    {field_value, 4},
    {field_visibility, 1, .inherited = true},
  [139] =
    {field_left, 1},
    {field_left, 2},
  [141] =
    {field_body, 4},
    {field_condition, 2},
  [143] =
    {field_body, 1},
  [144] =
    {field_body, 5},
    {field_condition, 3},
    {field_initial, 2},
  [147] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
  [150] =
    {field_left, 1},
    {field_right, 3},
  [152] =
    {field_attempt, 1},
    {field_body, 4},
  [154] =
    {field_body, 6},
    {field_condition, 3},
    {field_initial, 2},
    {field_update, 4},
  [158] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
  [162] =
    {field_left, 1},
    {field_left, 2},
    {field_right, 4},
  [165] =
    {field_body, 4},
    {field_body, 6},
    {field_condition, 2},
    {field_else, 5},
  [169] =
    {field_body, 1},
    {field_condition, 4},
  [171] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_right, 5},
  [175] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_left, 5},
  [180] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_right, 6},
  [185] =
    {field_left, 1},
    {field_left, 2},
    {field_left, 3},
    {field_left, 4},
    {field_left, 5},
    {field_right, 7},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [35] = {
    [1] = alias_sym_enum_value,
  },
  [55] = {
    [1] = alias_sym_revert_arguments,
  },
  [63] = {
    [1] = alias_sym_type_alias,
  },
  [66] = {
    [2] = alias_sym_revert_arguments,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym__call_arguments, 2,
    sym__call_arguments,
    alias_sym_revert_arguments,
  sym_user_defined_type, 2,
    sym_user_defined_type,
    alias_sym_type_alias,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 3,
  [4] = 4,
  [5] = 5,
  [6] = 6,
  [7] = 7,
  [8] = 3,
  [9] = 9,
  [10] = 10,
  [11] = 4,
  [12] = 12,
  [13] = 12,
  [14] = 14,
  [15] = 15,
  [16] = 16,
  [17] = 17,
  [18] = 14,
  [19] = 19,
  [20] = 17,
  [21] = 16,
  [22] = 15,
  [23] = 19,
  [24] = 24,
  [25] = 24,
  [26] = 26,
  [27] = 27,
  [28] = 28,
  [29] = 29,
  [30] = 30,
  [31] = 31,
  [32] = 29,
  [33] = 33,
  [34] = 34,
  [35] = 35,
  [36] = 34,
  [37] = 37,
  [38] = 38,
  [39] = 39,
  [40] = 40,
  [41] = 39,
  [42] = 42,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 48,
  [49] = 49,
  [50] = 50,
  [51] = 51,
  [52] = 49,
  [53] = 53,
  [54] = 54,
  [55] = 55,
  [56] = 56,
  [57] = 57,
  [58] = 58,
  [59] = 59,
  [60] = 60,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 54,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 73,
  [74] = 74,
  [75] = 75,
  [76] = 76,
  [77] = 77,
  [78] = 78,
  [79] = 79,
  [80] = 62,
  [81] = 81,
  [82] = 56,
  [83] = 60,
  [84] = 61,
  [85] = 85,
  [86] = 86,
  [87] = 87,
  [88] = 88,
  [89] = 89,
  [90] = 90,
  [91] = 91,
  [92] = 92,
  [93] = 93,
  [94] = 94,
  [95] = 95,
  [96] = 96,
  [97] = 97,
  [98] = 98,
  [99] = 99,
  [100] = 100,
  [101] = 101,
  [102] = 102,
  [103] = 103,
  [104] = 104,
  [105] = 105,
  [106] = 106,
  [107] = 107,
  [108] = 108,
  [109] = 109,
  [110] = 110,
  [111] = 111,
  [112] = 112,
  [113] = 113,
  [114] = 114,
  [115] = 115,
  [116] = 116,
  [117] = 117,
  [118] = 118,
  [119] = 119,
  [120] = 120,
  [121] = 121,
  [122] = 122,
  [123] = 123,
  [124] = 124,
  [125] = 125,
  [126] = 126,
  [127] = 127,
  [128] = 128,
  [129] = 128,
  [130] = 130,
  [131] = 131,
  [132] = 132,
  [133] = 133,
  [134] = 134,
  [135] = 135,
  [136] = 136,
  [137] = 133,
  [138] = 138,
  [139] = 139,
  [140] = 140,
  [141] = 141,
  [142] = 138,
  [143] = 135,
  [144] = 144,
  [145] = 141,
  [146] = 146,
  [147] = 147,
  [148] = 148,
  [149] = 149,
  [150] = 150,
  [151] = 151,
  [152] = 152,
  [153] = 153,
  [154] = 154,
  [155] = 155,
  [156] = 156,
  [157] = 157,
  [158] = 158,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 184,
  [194] = 170,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 190,
  [212] = 179,
  [213] = 165,
  [214] = 168,
  [215] = 162,
  [216] = 163,
  [217] = 191,
  [218] = 158,
  [219] = 192,
  [220] = 176,
  [221] = 189,
  [222] = 172,
  [223] = 181,
  [224] = 183,
  [225] = 187,
  [226] = 164,
  [227] = 169,
  [228] = 185,
  [229] = 171,
  [230] = 178,
  [231] = 175,
  [232] = 180,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 238,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 244,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 255,
  [256] = 256,
  [257] = 257,
  [258] = 258,
  [259] = 259,
  [260] = 260,
  [261] = 261,
  [262] = 262,
  [263] = 263,
  [264] = 264,
  [265] = 265,
  [266] = 266,
  [267] = 267,
  [268] = 268,
  [269] = 269,
  [270] = 270,
  [271] = 271,
  [272] = 272,
  [273] = 273,
  [274] = 274,
  [275] = 275,
  [276] = 276,
  [277] = 277,
  [278] = 278,
  [279] = 279,
  [280] = 280,
  [281] = 281,
  [282] = 282,
  [283] = 283,
  [284] = 284,
  [285] = 285,
  [286] = 286,
  [287] = 287,
  [288] = 288,
  [289] = 289,
  [290] = 290,
  [291] = 291,
  [292] = 292,
  [293] = 293,
  [294] = 294,
  [295] = 295,
  [296] = 296,
  [297] = 297,
  [298] = 298,
  [299] = 299,
  [300] = 300,
  [301] = 301,
  [302] = 302,
  [303] = 303,
  [304] = 304,
  [305] = 305,
  [306] = 306,
  [307] = 307,
  [308] = 308,
  [309] = 309,
  [310] = 310,
  [311] = 311,
  [312] = 312,
  [313] = 313,
  [314] = 314,
  [315] = 315,
  [316] = 316,
  [317] = 317,
  [318] = 318,
  [319] = 319,
  [320] = 320,
  [321] = 321,
  [322] = 322,
  [323] = 323,
  [324] = 324,
  [325] = 325,
  [326] = 326,
  [327] = 327,
  [328] = 328,
  [329] = 329,
  [330] = 330,
  [331] = 331,
  [332] = 332,
  [333] = 333,
  [334] = 334,
  [335] = 335,
  [336] = 336,
  [337] = 337,
  [338] = 338,
  [339] = 339,
  [340] = 340,
  [341] = 341,
  [342] = 342,
  [343] = 343,
  [344] = 344,
  [345] = 345,
  [346] = 346,
  [347] = 347,
  [348] = 348,
  [349] = 349,
  [350] = 350,
  [351] = 351,
  [352] = 352,
  [353] = 353,
  [354] = 354,
  [355] = 355,
  [356] = 356,
  [357] = 357,
  [358] = 358,
  [359] = 359,
  [360] = 360,
  [361] = 301,
  [362] = 362,
  [363] = 299,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 367,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 375,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 384,
  [385] = 385,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 389,
  [390] = 390,
  [391] = 391,
  [392] = 392,
  [393] = 393,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 404,
  [405] = 405,
  [406] = 406,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 422,
  [423] = 423,
  [424] = 424,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 429,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 434,
  [436] = 436,
  [437] = 437,
  [438] = 438,
  [439] = 439,
  [440] = 440,
  [441] = 441,
  [442] = 442,
  [443] = 443,
  [444] = 444,
  [445] = 445,
  [446] = 439,
  [447] = 447,
  [448] = 447,
  [449] = 449,
  [450] = 449,
  [451] = 451,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 459,
  [460] = 460,
  [461] = 461,
  [462] = 456,
  [463] = 458,
  [464] = 453,
  [465] = 452,
  [466] = 454,
  [467] = 457,
  [468] = 468,
  [469] = 469,
  [470] = 470,
  [471] = 471,
  [472] = 471,
  [473] = 473,
  [474] = 362,
  [475] = 475,
  [476] = 476,
  [477] = 476,
  [478] = 478,
  [479] = 478,
  [480] = 480,
  [481] = 481,
  [482] = 482,
  [483] = 483,
  [484] = 484,
  [485] = 485,
  [486] = 486,
  [487] = 487,
  [488] = 488,
  [489] = 489,
  [490] = 490,
  [491] = 491,
  [492] = 492,
  [493] = 493,
  [494] = 494,
  [495] = 495,
  [496] = 496,
  [497] = 497,
  [498] = 498,
  [499] = 499,
  [500] = 500,
  [501] = 501,
  [502] = 502,
  [503] = 503,
  [504] = 504,
  [505] = 505,
  [506] = 506,
  [507] = 507,
  [508] = 508,
  [509] = 509,
  [510] = 510,
  [511] = 511,
  [512] = 512,
  [513] = 513,
  [514] = 514,
  [515] = 515,
  [516] = 516,
  [517] = 517,
  [518] = 518,
  [519] = 519,
  [520] = 520,
  [521] = 516,
  [522] = 522,
  [523] = 523,
  [524] = 524,
  [525] = 525,
  [526] = 526,
  [527] = 527,
  [528] = 528,
  [529] = 522,
  [530] = 524,
  [531] = 525,
  [532] = 532,
  [533] = 533,
  [534] = 534,
  [535] = 535,
  [536] = 536,
  [537] = 537,
  [538] = 538,
  [539] = 539,
  [540] = 540,
  [541] = 541,
  [542] = 542,
  [543] = 541,
  [544] = 544,
  [545] = 545,
  [546] = 546,
  [547] = 547,
  [548] = 548,
  [549] = 549,
  [550] = 550,
  [551] = 551,
  [552] = 552,
  [553] = 553,
  [554] = 554,
  [555] = 555,
  [556] = 556,
  [557] = 557,
  [558] = 558,
  [559] = 559,
  [560] = 560,
  [561] = 561,
  [562] = 562,
  [563] = 563,
  [564] = 564,
  [565] = 565,
  [566] = 566,
  [567] = 567,
  [568] = 568,
  [569] = 569,
  [570] = 570,
  [571] = 571,
  [572] = 572,
  [573] = 573,
  [574] = 574,
  [575] = 575,
  [576] = 551,
  [577] = 577,
  [578] = 578,
  [579] = 579,
  [580] = 580,
  [581] = 581,
  [582] = 582,
  [583] = 583,
  [584] = 584,
  [585] = 585,
  [586] = 586,
  [587] = 587,
  [588] = 588,
  [589] = 589,
  [590] = 590,
  [591] = 591,
  [592] = 592,
  [593] = 593,
  [594] = 594,
  [595] = 595,
  [596] = 596,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 600,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 605,
  [606] = 606,
  [607] = 607,
  [608] = 608,
  [609] = 609,
  [610] = 610,
  [611] = 611,
  [612] = 612,
  [613] = 613,
  [614] = 614,
  [615] = 615,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 578,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 637,
  [638] = 638,
  [639] = 639,
  [640] = 640,
  [641] = 641,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 646,
  [647] = 647,
  [648] = 648,
  [649] = 649,
  [650] = 650,
  [651] = 651,
  [652] = 652,
  [653] = 653,
  [654] = 654,
  [655] = 655,
  [656] = 656,
  [657] = 657,
  [658] = 658,
  [659] = 659,
  [660] = 660,
  [661] = 661,
  [662] = 618,
  [663] = 663,
  [664] = 664,
  [665] = 665,
  [666] = 666,
  [667] = 667,
  [668] = 668,
  [669] = 669,
  [670] = 580,
  [671] = 671,
  [672] = 672,
  [673] = 673,
  [674] = 674,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 681,
  [682] = 627,
  [683] = 683,
  [684] = 684,
  [685] = 656,
  [686] = 665,
  [687] = 687,
  [688] = 688,
  [689] = 689,
  [690] = 690,
  [691] = 691,
  [692] = 692,
  [693] = 693,
  [694] = 694,
  [695] = 695,
  [696] = 696,
  [697] = 697,
  [698] = 698,
  [699] = 699,
  [700] = 700,
  [701] = 701,
  [702] = 702,
  [703] = 703,
  [704] = 704,
  [705] = 705,
  [706] = 706,
  [707] = 707,
  [708] = 708,
  [709] = 709,
  [710] = 710,
  [711] = 711,
  [712] = 712,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 718,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 722,
  [723] = 723,
  [724] = 724,
  [725] = 725,
  [726] = 726,
  [727] = 727,
  [728] = 728,
  [729] = 729,
  [730] = 730,
  [731] = 731,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 736,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 744,
  [745] = 729,
  [746] = 693,
  [747] = 747,
  [748] = 705,
  [749] = 749,
  [750] = 725,
  [751] = 751,
  [752] = 752,
  [753] = 753,
  [754] = 754,
  [755] = 755,
  [756] = 756,
  [757] = 757,
  [758] = 758,
  [759] = 755,
  [760] = 720,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 764,
  [765] = 765,
  [766] = 763,
  [767] = 719,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 699,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 718,
  [779] = 752,
  [780] = 692,
  [781] = 781,
  [782] = 769,
  [783] = 783,
  [784] = 784,
  [785] = 785,
  [786] = 786,
  [787] = 787,
  [788] = 749,
  [789] = 789,
  [790] = 790,
  [791] = 738,
  [792] = 792,
  [793] = 777,
  [794] = 794,
  [795] = 114,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 754,
  [801] = 801,
  [802] = 802,
  [803] = 803,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 817,
  [818] = 818,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 829,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 859,
  [860] = 811,
  [861] = 861,
  [862] = 852,
  [863] = 829,
  [864] = 805,
  [865] = 865,
  [866] = 866,
  [867] = 856,
  [868] = 868,
  [869] = 861,
  [870] = 870,
  [871] = 871,
  [872] = 837,
  [873] = 823,
  [874] = 836,
  [875] = 853,
  [876] = 876,
  [877] = 868,
  [878] = 859,
  [879] = 826,
  [880] = 880,
  [881] = 881,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(52);
      ADVANCE_MAP(
        '!', 109,
        '"', 137,
        '%', 106,
        '&', 101,
        '\'', 140,
        '(', 83,
        ')', 84,
        '*', 79,
        '+', 104,
        ',', 81,
        '-', 56,
        '.', 88,
        '/', 105,
        '0', 89,
        ':', 87,
        ';', 123,
        '<', 68,
        '=', 78,
        '>', 73,
        '?', 94,
        '[', 95,
        '\\', 32,
        ']', 96,
        '^', 71,
        '_', 139,
        '{', 80,
        '|', 100,
        '}', 82,
        '~', 75,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(90);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(50);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 1:
      if (lookahead == '\n') SKIP(13);
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead == '\\') ADVANCE(2);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(158);
      if (lookahead != 0) ADVANCE(159);
      END_STATE();
    case 2:
      if (lookahead == '\n') ADVANCE(153);
      if (lookahead == '\r') ADVANCE(142);
      if (lookahead == 'u') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(145);
      if (lookahead != 0) ADVANCE(141);
      END_STATE();
    case 3:
      if (lookahead == '\n') SKIP(15);
      if (lookahead == '\'') ADVANCE(140);
      if (lookahead == '/') ADVANCE(148);
      if (lookahead == '\\') ADVANCE(4);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(151);
      if (lookahead != 0) ADVANCE(152);
      END_STATE();
    case 4:
      if (lookahead == '\n') ADVANCE(146);
      if (lookahead == '\r') ADVANCE(143);
      if (lookahead == 'u') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(145);
      if (lookahead != 0) ADVANCE(141);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        ' ', 5,
        '"', 6,
        '-', 54,
        '.', 7,
        '/', 17,
        ';', 123,
        '<', 69,
        '=', 76,
        '>', 72,
        '^', 70,
        '|', 35,
        '~', 75,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(5);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 6:
      if (lookahead == ' ') ADVANCE(37);
      if (lookahead == '.') ADVANCE(7);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 7:
      if (lookahead == ' ') ADVANCE(37);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 8:
      if (lookahead == ' ') ADVANCE(38);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 24,
        '"', 137,
        '%', 106,
        '&', 101,
        '\'', 140,
        '(', 83,
        ')', 84,
        '*', 79,
        '+', 104,
        ',', 81,
        '-', 56,
        '.', 88,
        '/', 105,
        ':', 86,
        ';', 123,
        '<', 68,
        '=', 77,
        '>', 73,
        '?', 94,
        '[', 95,
        ']', 96,
        '^', 71,
        '{', 80,
        '|', 100,
        '}', 82,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(9);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 24,
        '"', 28,
        '%', 106,
        '&', 101,
        '(', 83,
        ')', 84,
        '*', 79,
        '+', 104,
        ',', 81,
        '-', 56,
        '.', 88,
        '/', 105,
        ':', 86,
        ';', 123,
        '<', 68,
        '=', 78,
        '>', 73,
        '?', 94,
        '[', 95,
        ']', 96,
        '^', 71,
        '{', 80,
        '|', 100,
        '}', 82,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(10);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 108,
        '"', 137,
        '\'', 140,
        '(', 83,
        ')', 84,
        '+', 20,
        ',', 81,
        '-', 55,
        '.', 40,
        '/', 17,
        '0', 128,
        ':', 86,
        ';', 123,
        '=', 25,
        '[', 95,
        ']', 96,
        '_', 125,
        '{', 80,
        '}', 82,
        '~', 75,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(129);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(11);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 12:
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '\'') ADVANCE(140);
      if (lookahead == '/') ADVANCE(17);
      if (lookahead == '_') ADVANCE(138);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(12);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(48);
      END_STATE();
    case 13:
      if (lookahead == '"') ADVANCE(137);
      if (lookahead == '/') ADVANCE(17);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(13);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(85);
      END_STATE();
    case 15:
      if (lookahead == '\'') ADVANCE(140);
      if (lookahead == '/') ADVANCE(17);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(15);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '(', 83,
        ')', 84,
        ',', 81,
        '-', 26,
        '.', 88,
        '/', 17,
        ';', 123,
        '=', 25,
        '[', 95,
        '{', 80,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(16);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 17:
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(162);
      END_STATE();
    case 18:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 19:
      if (lookahead == '*') ADVANCE(18);
      if (lookahead != 0) ADVANCE(19);
      END_STATE();
    case 20:
      if (lookahead == '+') ADVANCE(110);
      END_STATE();
    case 21:
      if (lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(131);
      END_STATE();
    case 22:
      if (lookahead == '-') ADVANCE(43);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(133);
      END_STATE();
    case 23:
      if (lookahead == '/') ADVANCE(57);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(60);
      if (lookahead != 0 &&
          lookahead != ';') ADVANCE(61);
      END_STATE();
    case 24:
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 25:
      if (lookahead == '>') ADVANCE(122);
      END_STATE();
    case 26:
      if (lookahead == '>') ADVANCE(93);
      END_STATE();
    case 27:
      if (lookahead == 'a') ADVANCE(31);
      END_STATE();
    case 28:
      if (lookahead == 'e') ADVANCE(33);
      END_STATE();
    case 29:
      if (lookahead == 'm') ADVANCE(27);
      END_STATE();
    case 30:
      if (lookahead == 'm') ADVANCE(14);
      END_STATE();
    case 31:
      if (lookahead == 's') ADVANCE(30);
      END_STATE();
    case 32:
      if (lookahead == 'u') ADVANCE(34);
      if (lookahead == 'x') ADVANCE(49);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(145);
      if (lookahead != 0) ADVANCE(141);
      END_STATE();
    case 33:
      if (lookahead == 'v') ADVANCE(29);
      END_STATE();
    case 34:
      if (lookahead == '{') ADVANCE(46);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(44);
      END_STATE();
    case 35:
      if (lookahead == '|') ADVANCE(53);
      END_STATE();
    case 36:
      if (lookahead == '}') ADVANCE(141);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 37:
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 38:
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 39:
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 40:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(132);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(130);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(131);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(133);
      END_STATE();
    case 44:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(49);
      END_STATE();
    case 45:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(141);
      END_STATE();
    case 46:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(36);
      END_STATE();
    case 47:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(134);
      END_STATE();
    case 48:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(136);
      END_STATE();
    case 49:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(45);
      END_STATE();
    case 50:
      if (eof) ADVANCE(52);
      ADVANCE_MAP(
        '!', 109,
        '"', 137,
        '%', 106,
        '&', 101,
        '\'', 140,
        '(', 83,
        ')', 84,
        '*', 79,
        '+', 104,
        ',', 81,
        '-', 56,
        '.', 88,
        '/', 105,
        '0', 89,
        ':', 87,
        ';', 123,
        '<', 68,
        '=', 78,
        '>', 73,
        '?', 94,
        '[', 95,
        ']', 96,
        '^', 71,
        '_', 139,
        '{', 80,
        '|', 100,
        '}', 82,
        '~', 75,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(90);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(50);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 51:
      if (eof) ADVANCE(52);
      ADVANCE_MAP(
        '!', 24,
        '"', 137,
        '%', 106,
        '&', 101,
        '\'', 140,
        '(', 83,
        ')', 84,
        '*', 79,
        '+', 104,
        ',', 81,
        '-', 56,
        '.', 88,
        '/', 105,
        '0', 89,
        ':', 87,
        ';', 123,
        '<', 68,
        '=', 77,
        '>', 73,
        '?', 94,
        '[', 95,
        ']', 96,
        '^', 71,
        '{', 80,
        '|', 100,
        '}', 82,
      );
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(90);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(51);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_PIPE_PIPE);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(111);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '-') ADVANCE(111);
      if (lookahead == '=') ADVANCE(113);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead == '*') ADVANCE(59);
      if (lookahead == '/') ADVANCE(161);
      if (lookahead != 0 &&
          lookahead != ';') ADVANCE(61);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead == '*') ADVANCE(58);
      if (lookahead == '/') ADVANCE(160);
      if (lookahead == ';') ADVANCE(19);
      if (lookahead != 0) ADVANCE(59);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead == '*') ADVANCE(58);
      if (lookahead == ';') ADVANCE(19);
      if (lookahead != 0) ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead == '/') ADVANCE(57);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(60);
      if (lookahead != 0 &&
          lookahead != ';') ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_pragma_value_token1);
      if (lookahead != 0 &&
          lookahead != ';') ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(sym_solidity_version);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(sym_solidity_version);
      if (lookahead == ' ') ADVANCE(65);
      if (lookahead == '"') ADVANCE(62);
      if (lookahead == '.') ADVANCE(39);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(63);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(sym_solidity_version);
      if (lookahead == '"') ADVANCE(62);
      if (lookahead == '.') ADVANCE(8);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(64);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(sym_solidity_version);
      if (lookahead == '"') ADVANCE(62);
      if (lookahead == '.') ADVANCE(39);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(sym_solidity_version);
      if (lookahead == '"') ADVANCE(62);
      if (lookahead == '*' ||
          ('0' <= lookahead && lookahead <= '9')) ADVANCE(66);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(102);
      if (lookahead == '=') ADVANCE(67);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '=') ADVANCE(67);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(117);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(74);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(74);
      if (lookahead == '>') ADVANCE(103);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(anon_sym_TILDE);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_EQ);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(98);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(98);
      if (lookahead == '>') ADVANCE(122);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(107);
      if (lookahead == '=') ADVANCE(114);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_DQUOTEevmasm_DQUOTE);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(92);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(sym_yul_decimal_number);
      if (lookahead == 'x') ADVANCE(91);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(sym_yul_decimal_number);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(90);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(sym_yul_hex_number);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(91);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_QMARK);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_AMP_AMP);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(119);
      if (lookahead == '|') ADVANCE(53);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '&') ADVANCE(97);
      if (lookahead == '=') ADVANCE(118);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(121);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '+') ADVANCE(110);
      if (lookahead == '=') ADVANCE(112);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '*') ADVANCE(19);
      if (lookahead == '/') ADVANCE(162);
      if (lookahead == '=') ADVANCE(115);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(116);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_BANG);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_BANG);
      if (lookahead == '=') ADVANCE(99);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_PLUS_PLUS);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_DASH_DASH);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_EQ_GT);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_SEMI);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '-') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(126);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(124);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(125);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(126);
      if (lookahead == '$' ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(21);
      if (lookahead == 'X' ||
          lookahead == 'x') ADVANCE(47);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(129);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(129);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(21);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(130);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(aux_sym__decimal_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(131);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(aux_sym__decimal_number_token2);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(22);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(132);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(aux_sym__decimal_number_token2);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(133);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(aux_sym__hex_number_token1);
      if (lookahead == '_') ADVANCE(135);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(134);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(aux_sym__hex_number_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(134);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(sym__hex_digit);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym__);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym__);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(127);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(sym__escape_sequence);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (lookahead == '\n') ADVANCE(153);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (lookahead == '\n') ADVANCE(146);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(141);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(sym__escape_sequence);
      if (('0' <= lookahead && lookahead <= '7')) ADVANCE(144);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '\r') ADVANCE(152);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(147);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(150);
      if (lookahead == '/') ADVANCE(147);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(152);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(149);
      if (lookahead == '/') ADVANCE(152);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(150);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(149);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(150);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead == '/') ADVANCE(148);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(151);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(152);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(aux_sym__single_quoted_unicode_char_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(152);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '\r') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(154);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(157);
      if (lookahead == '/') ADVANCE(154);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(159);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead == '/') ADVANCE(159);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(157);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '*') ADVANCE(156);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(157);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead == '/') ADVANCE(155);
      if (lookahead == '\t' ||
          (0x0b <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) ADVANCE(158);
      if (lookahead != 0 &&
          (lookahead < '\t' || '\r' < lookahead) &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(159);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(aux_sym__double_quoted_unicode_char_token1);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '"' &&
          lookahead != '\\') ADVANCE(159);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_comment);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead == ';') ADVANCE(162);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(161);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_comment);
      if (lookahead != 0 &&
          lookahead != '\n' &&
          lookahead != '\r') ADVANCE(162);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        'a', 1,
        'b', 2,
        'c', 3,
        'd', 4,
        'e', 5,
        'f', 6,
        'g', 7,
        'h', 8,
        'i', 9,
        'k', 10,
        'l', 11,
        'm', 12,
        'n', 13,
        'o', 14,
        'p', 15,
        'r', 16,
        's', 17,
        't', 18,
        'u', 19,
        'v', 20,
        'w', 21,
        'x', 22,
        'y', 23,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ' ||
          lookahead == 0xa0 ||
          lookahead == 0x200b ||
          lookahead == 0x2060 ||
          lookahead == 0xfeff) SKIP(0);
      END_STATE();
    case 1:
      if (lookahead == 'b') ADVANCE(24);
      if (lookahead == 'd') ADVANCE(25);
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 's') ADVANCE(27);
      END_STATE();
    case 2:
      if (lookahead == 'a') ADVANCE(28);
      if (lookahead == 'l') ADVANCE(29);
      if (lookahead == 'o') ADVANCE(30);
      if (lookahead == 'r') ADVANCE(31);
      if (lookahead == 'y') ADVANCE(32);
      END_STATE();
    case 3:
      if (lookahead == 'a') ADVANCE(33);
      if (lookahead == 'h') ADVANCE(34);
      if (lookahead == 'o') ADVANCE(35);
      if (lookahead == 'r') ADVANCE(36);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(37);
      if (lookahead == 'e') ADVANCE(38);
      if (lookahead == 'i') ADVANCE(39);
      if (lookahead == 'o') ADVANCE(40);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        'l', 41,
        'm', 42,
        'n', 43,
        'q', 44,
        'r', 45,
        't', 46,
        'v', 47,
        'x', 48,
      );
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(49);
      if (lookahead == 'i') ADVANCE(50);
      if (lookahead == 'o') ADVANCE(51);
      if (lookahead == 'r') ADVANCE(52);
      if (lookahead == 'u') ADVANCE(53);
      END_STATE();
    case 7:
      if (lookahead == 'a') ADVANCE(54);
      if (lookahead == 't') ADVANCE(55);
      if (lookahead == 'w') ADVANCE(56);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(57);
      if (lookahead == 'o') ADVANCE(58);
      END_STATE();
    case 9:
      if (lookahead == 'f') ADVANCE(59);
      if (lookahead == 'm') ADVANCE(60);
      if (lookahead == 'n') ADVANCE(61);
      if (lookahead == 's') ADVANCE(62);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(63);
      END_STATE();
    case 11:
      if (lookahead == 'e') ADVANCE(64);
      if (lookahead == 'i') ADVANCE(65);
      if (lookahead == 'o') ADVANCE(66);
      if (lookahead == 't') ADVANCE(67);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        'a', 68,
        'c', 69,
        'e', 70,
        'i', 71,
        'l', 72,
        'o', 73,
        's', 74,
        'u', 75,
      );
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(76);
      if (lookahead == 'o') ADVANCE(77);
      if (lookahead == 'u') ADVANCE(78);
      END_STATE();
    case 14:
      if (lookahead == 'r') ADVANCE(79);
      if (lookahead == 'v') ADVANCE(80);
      END_STATE();
    case 15:
      if (lookahead == 'a') ADVANCE(81);
      if (lookahead == 'o') ADVANCE(82);
      if (lookahead == 'r') ADVANCE(83);
      if (lookahead == 'u') ADVANCE(84);
      END_STATE();
    case 16:
      if (lookahead == 'e') ADVANCE(85);
      END_STATE();
    case 17:
      ADVANCE_MAP(
        'a', 86,
        'd', 87,
        'e', 88,
        'g', 89,
        'h', 90,
        'i', 91,
        'l', 92,
        'm', 93,
        'o', 94,
        's', 95,
        't', 96,
        'u', 97,
        'w', 98,
        'z', 99,
      );
      END_STATE();
    case 18:
      if (lookahead == 'i') ADVANCE(100);
      if (lookahead == 'l') ADVANCE(101);
      if (lookahead == 'r') ADVANCE(102);
      if (lookahead == 's') ADVANCE(103);
      if (lookahead == 'y') ADVANCE(104);
      END_STATE();
    case 19:
      if (lookahead == 'f') ADVANCE(105);
      if (lookahead == 'i') ADVANCE(106);
      if (lookahead == 'n') ADVANCE(107);
      if (lookahead == 's') ADVANCE(108);
      END_STATE();
    case 20:
      if (lookahead == 'a') ADVANCE(109);
      if (lookahead == 'i') ADVANCE(110);
      END_STATE();
    case 21:
      if (lookahead == 'e') ADVANCE(111);
      if (lookahead == 'h') ADVANCE(112);
      END_STATE();
    case 22:
      if (lookahead == 'o') ADVANCE(113);
      END_STATE();
    case 23:
      if (lookahead == 'e') ADVANCE(114);
      END_STATE();
    case 24:
      if (lookahead == 's') ADVANCE(115);
      END_STATE();
    case 25:
      if (lookahead == 'd') ADVANCE(116);
      END_STATE();
    case 26:
      if (lookahead == 'd') ADVANCE(117);
      if (lookahead == 'o') ADVANCE(118);
      END_STATE();
    case 27:
      ACCEPT_TOKEN(anon_sym_as);
      if (lookahead == 's') ADVANCE(119);
      END_STATE();
    case 28:
      if (lookahead == 'l') ADVANCE(120);
      if (lookahead == 's') ADVANCE(121);
      END_STATE();
    case 29:
      if (lookahead == 'o') ADVANCE(122);
      END_STATE();
    case 30:
      if (lookahead == 'o') ADVANCE(123);
      END_STATE();
    case 31:
      if (lookahead == 'e') ADVANCE(124);
      END_STATE();
    case 32:
      if (lookahead == 't') ADVANCE(125);
      END_STATE();
    case 33:
      if (lookahead == 'l') ADVANCE(126);
      if (lookahead == 's') ADVANCE(127);
      if (lookahead == 't') ADVANCE(128);
      END_STATE();
    case 34:
      if (lookahead == 'a') ADVANCE(129);
      END_STATE();
    case 35:
      if (lookahead == 'i') ADVANCE(130);
      if (lookahead == 'n') ADVANCE(131);
      END_STATE();
    case 36:
      if (lookahead == 'e') ADVANCE(132);
      END_STATE();
    case 37:
      if (lookahead == 'y') ADVANCE(133);
      END_STATE();
    case 38:
      if (lookahead == 'f') ADVANCE(134);
      if (lookahead == 'l') ADVANCE(135);
      END_STATE();
    case 39:
      if (lookahead == 'f') ADVANCE(136);
      if (lookahead == 'v') ADVANCE(137);
      END_STATE();
    case 40:
      ACCEPT_TOKEN(anon_sym_do);
      END_STATE();
    case 41:
      if (lookahead == 's') ADVANCE(138);
      END_STATE();
    case 42:
      if (lookahead == 'i') ADVANCE(139);
      END_STATE();
    case 43:
      if (lookahead == 'u') ADVANCE(140);
      END_STATE();
    case 44:
      ACCEPT_TOKEN(anon_sym_eq);
      END_STATE();
    case 45:
      if (lookahead == 'r') ADVANCE(141);
      END_STATE();
    case 46:
      if (lookahead == 'h') ADVANCE(142);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(143);
      END_STATE();
    case 48:
      if (lookahead == 'p') ADVANCE(144);
      if (lookahead == 't') ADVANCE(145);
      END_STATE();
    case 49:
      if (lookahead == 'l') ADVANCE(146);
      END_STATE();
    case 50:
      if (lookahead == 'n') ADVANCE(147);
      if (lookahead == 'x') ADVANCE(148);
      END_STATE();
    case 51:
      if (lookahead == 'r') ADVANCE(149);
      END_STATE();
    case 52:
      if (lookahead == 'o') ADVANCE(150);
      END_STATE();
    case 53:
      if (lookahead == 'n') ADVANCE(151);
      END_STATE();
    case 54:
      if (lookahead == 's') ADVANCE(152);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_gt);
      END_STATE();
    case 56:
      if (lookahead == 'e') ADVANCE(153);
      END_STATE();
    case 57:
      if (lookahead == 'x') ADVANCE(154);
      END_STATE();
    case 58:
      if (lookahead == 'u') ADVANCE(155);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 60:
      if (lookahead == 'm') ADVANCE(156);
      if (lookahead == 'p') ADVANCE(157);
      END_STATE();
    case 61:
      if (lookahead == 'd') ADVANCE(158);
      if (lookahead == 't') ADVANCE(159);
      if (lookahead == 'v') ADVANCE(160);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(anon_sym_is);
      if (lookahead == 'z') ADVANCE(161);
      END_STATE();
    case 63:
      if (lookahead == 'c') ADVANCE(162);
      END_STATE();
    case 64:
      if (lookahead == 'a') ADVANCE(163);
      if (lookahead == 't') ADVANCE(164);
      END_STATE();
    case 65:
      if (lookahead == 'b') ADVANCE(165);
      END_STATE();
    case 66:
      if (lookahead == 'g') ADVANCE(166);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(anon_sym_lt);
      END_STATE();
    case 68:
      if (lookahead == 'p') ADVANCE(167);
      END_STATE();
    case 69:
      if (lookahead == 'o') ADVANCE(168);
      END_STATE();
    case 70:
      if (lookahead == 'm') ADVANCE(169);
      END_STATE();
    case 71:
      if (lookahead == 'n') ADVANCE(170);
      END_STATE();
    case 72:
      if (lookahead == 'o') ADVANCE(171);
      END_STATE();
    case 73:
      if (lookahead == 'd') ADVANCE(172);
      END_STATE();
    case 74:
      if (lookahead == 'i') ADVANCE(173);
      if (lookahead == 't') ADVANCE(174);
      END_STATE();
    case 75:
      if (lookahead == 'l') ADVANCE(175);
      END_STATE();
    case 76:
      if (lookahead == 'w') ADVANCE(176);
      END_STATE();
    case 77:
      if (lookahead == 't') ADVANCE(177);
      END_STATE();
    case 78:
      if (lookahead == 'm') ADVANCE(178);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(anon_sym_or);
      if (lookahead == 'i') ADVANCE(179);
      END_STATE();
    case 80:
      if (lookahead == 'e') ADVANCE(180);
      END_STATE();
    case 81:
      if (lookahead == 'y') ADVANCE(181);
      END_STATE();
    case 82:
      if (lookahead == 'p') ADVANCE(182);
      END_STATE();
    case 83:
      if (lookahead == 'a') ADVANCE(183);
      if (lookahead == 'i') ADVANCE(184);
      END_STATE();
    case 84:
      if (lookahead == 'b') ADVANCE(185);
      if (lookahead == 'r') ADVANCE(186);
      END_STATE();
    case 85:
      if (lookahead == 'c') ADVANCE(187);
      if (lookahead == 't') ADVANCE(188);
      if (lookahead == 'v') ADVANCE(189);
      END_STATE();
    case 86:
      if (lookahead == 'r') ADVANCE(190);
      END_STATE();
    case 87:
      if (lookahead == 'i') ADVANCE(191);
      END_STATE();
    case 88:
      if (lookahead == 'c') ADVANCE(192);
      if (lookahead == 'l') ADVANCE(193);
      END_STATE();
    case 89:
      if (lookahead == 't') ADVANCE(194);
      END_STATE();
    case 90:
      if (lookahead == 'l') ADVANCE(195);
      if (lookahead == 'r') ADVANCE(196);
      END_STATE();
    case 91:
      if (lookahead == 'g') ADVANCE(197);
      END_STATE();
    case 92:
      if (lookahead == 'o') ADVANCE(198);
      if (lookahead == 't') ADVANCE(199);
      END_STATE();
    case 93:
      if (lookahead == 'o') ADVANCE(200);
      END_STATE();
    case 94:
      if (lookahead == 'l') ADVANCE(201);
      END_STATE();
    case 95:
      if (lookahead == 't') ADVANCE(202);
      END_STATE();
    case 96:
      if (lookahead == 'a') ADVANCE(203);
      if (lookahead == 'o') ADVANCE(204);
      if (lookahead == 'r') ADVANCE(205);
      END_STATE();
    case 97:
      if (lookahead == 'b') ADVANCE(206);
      END_STATE();
    case 98:
      if (lookahead == 'i') ADVANCE(207);
      END_STATE();
    case 99:
      if (lookahead == 'a') ADVANCE(208);
      END_STATE();
    case 100:
      if (lookahead == 'm') ADVANCE(209);
      END_STATE();
    case 101:
      if (lookahead == 'o') ADVANCE(210);
      END_STATE();
    case 102:
      if (lookahead == 'a') ADVANCE(211);
      if (lookahead == 'u') ADVANCE(212);
      if (lookahead == 'y') ADVANCE(213);
      END_STATE();
    case 103:
      if (lookahead == 't') ADVANCE(214);
      END_STATE();
    case 104:
      if (lookahead == 'p') ADVANCE(215);
      END_STATE();
    case 105:
      if (lookahead == 'i') ADVANCE(216);
      END_STATE();
    case 106:
      if (lookahead == 'n') ADVANCE(217);
      END_STATE();
    case 107:
      if (lookahead == 'c') ADVANCE(218);
      if (lookahead == 'i') ADVANCE(219);
      END_STATE();
    case 108:
      if (lookahead == 'i') ADVANCE(220);
      END_STATE();
    case 109:
      if (lookahead == 'r') ADVANCE(221);
      END_STATE();
    case 110:
      if (lookahead == 'e') ADVANCE(222);
      if (lookahead == 'r') ADVANCE(223);
      END_STATE();
    case 111:
      if (lookahead == 'e') ADVANCE(224);
      if (lookahead == 'i') ADVANCE(225);
      END_STATE();
    case 112:
      if (lookahead == 'i') ADVANCE(226);
      END_STATE();
    case 113:
      if (lookahead == 'r') ADVANCE(227);
      END_STATE();
    case 114:
      if (lookahead == 'a') ADVANCE(228);
      END_STATE();
    case 115:
      if (lookahead == 't') ADVANCE(229);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_add);
      if (lookahead == 'm') ADVANCE(230);
      if (lookahead == 'r') ADVANCE(231);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 118:
      if (lookahead == 'n') ADVANCE(232);
      END_STATE();
    case 119:
      if (lookahead == 'e') ADVANCE(233);
      END_STATE();
    case 120:
      if (lookahead == 'a') ADVANCE(234);
      END_STATE();
    case 121:
      if (lookahead == 'e') ADVANCE(235);
      END_STATE();
    case 122:
      if (lookahead == 'b') ADVANCE(236);
      if (lookahead == 'c') ADVANCE(237);
      END_STATE();
    case 123:
      if (lookahead == 'l') ADVANCE(238);
      END_STATE();
    case 124:
      if (lookahead == 'a') ADVANCE(239);
      END_STATE();
    case 125:
      if (lookahead == 'e') ADVANCE(240);
      END_STATE();
    case 126:
      if (lookahead == 'l') ADVANCE(241);
      END_STATE();
    case 127:
      if (lookahead == 'e') ADVANCE(242);
      END_STATE();
    case 128:
      if (lookahead == 'c') ADVANCE(243);
      END_STATE();
    case 129:
      if (lookahead == 'i') ADVANCE(244);
      END_STATE();
    case 130:
      if (lookahead == 'n') ADVANCE(245);
      END_STATE();
    case 131:
      if (lookahead == 's') ADVANCE(246);
      if (lookahead == 't') ADVANCE(247);
      END_STATE();
    case 132:
      if (lookahead == 'a') ADVANCE(248);
      END_STATE();
    case 133:
      if (lookahead == 's') ADVANCE(249);
      END_STATE();
    case 134:
      if (lookahead == 'a') ADVANCE(250);
      END_STATE();
    case 135:
      if (lookahead == 'e') ADVANCE(251);
      END_STATE();
    case 136:
      if (lookahead == 'f') ADVANCE(252);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_div);
      END_STATE();
    case 138:
      if (lookahead == 'e') ADVANCE(253);
      END_STATE();
    case 139:
      if (lookahead == 't') ADVANCE(254);
      END_STATE();
    case 140:
      if (lookahead == 'm') ADVANCE(255);
      END_STATE();
    case 141:
      if (lookahead == 'o') ADVANCE(256);
      END_STATE();
    case 142:
      if (lookahead == 'e') ADVANCE(257);
      END_STATE();
    case 143:
      if (lookahead == 'n') ADVANCE(258);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_exp);
      END_STATE();
    case 145:
      if (lookahead == 'c') ADVANCE(259);
      if (lookahead == 'e') ADVANCE(260);
      END_STATE();
    case 146:
      if (lookahead == 'l') ADVANCE(261);
      if (lookahead == 's') ADVANCE(262);
      END_STATE();
    case 147:
      if (lookahead == 'n') ADVANCE(263);
      END_STATE();
    case 148:
      if (lookahead == 'e') ADVANCE(264);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 150:
      if (lookahead == 'm') ADVANCE(265);
      END_STATE();
    case 151:
      if (lookahead == 'c') ADVANCE(266);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_gas);
      if (lookahead == 'l') ADVANCE(267);
      if (lookahead == 'p') ADVANCE(268);
      END_STATE();
    case 153:
      if (lookahead == 'i') ADVANCE(269);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_hex);
      END_STATE();
    case 155:
      if (lookahead == 'r') ADVANCE(270);
      END_STATE();
    case 156:
      if (lookahead == 'u') ADVANCE(271);
      END_STATE();
    case 157:
      if (lookahead == 'o') ADVANCE(272);
      END_STATE();
    case 158:
      if (lookahead == 'e') ADVANCE(273);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(anon_sym_int);
      ADVANCE_MAP(
        '1', 274,
        '2', 275,
        '3', 276,
        '4', 277,
        '5', 278,
        '6', 279,
        '7', 280,
        '8', 281,
        '9', 282,
        'e', 283,
      );
      END_STATE();
    case 160:
      if (lookahead == 'a') ADVANCE(284);
      END_STATE();
    case 161:
      if (lookahead == 'e') ADVANCE(285);
      END_STATE();
    case 162:
      if (lookahead == 'c') ADVANCE(286);
      END_STATE();
    case 163:
      if (lookahead == 'v') ADVANCE(287);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 165:
      if (lookahead == 'r') ADVANCE(288);
      END_STATE();
    case 166:
      if (lookahead == '0') ADVANCE(289);
      if (lookahead == '1') ADVANCE(290);
      if (lookahead == '2') ADVANCE(291);
      if (lookahead == '3') ADVANCE(292);
      if (lookahead == '4') ADVANCE(293);
      END_STATE();
    case 167:
      if (lookahead == 'p') ADVANCE(294);
      END_STATE();
    case 168:
      if (lookahead == 'p') ADVANCE(295);
      END_STATE();
    case 169:
      if (lookahead == 'o') ADVANCE(296);
      END_STATE();
    case 170:
      if (lookahead == 'u') ADVANCE(297);
      END_STATE();
    case 171:
      if (lookahead == 'a') ADVANCE(298);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(anon_sym_mod);
      if (lookahead == 'i') ADVANCE(299);
      END_STATE();
    case 173:
      if (lookahead == 'z') ADVANCE(300);
      END_STATE();
    case 174:
      if (lookahead == 'o') ADVANCE(301);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(anon_sym_mul);
      if (lookahead == 'm') ADVANCE(302);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_new);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(anon_sym_not);
      END_STATE();
    case 178:
      if (lookahead == 'b') ADVANCE(303);
      END_STATE();
    case 179:
      if (lookahead == 'g') ADVANCE(304);
      END_STATE();
    case 180:
      if (lookahead == 'r') ADVANCE(305);
      END_STATE();
    case 181:
      if (lookahead == 'a') ADVANCE(306);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(anon_sym_pop);
      END_STATE();
    case 183:
      if (lookahead == 'g') ADVANCE(307);
      END_STATE();
    case 184:
      if (lookahead == 'v') ADVANCE(308);
      END_STATE();
    case 185:
      if (lookahead == 'l') ADVANCE(309);
      END_STATE();
    case 186:
      if (lookahead == 'e') ADVANCE(310);
      END_STATE();
    case 187:
      if (lookahead == 'e') ADVANCE(311);
      END_STATE();
    case 188:
      if (lookahead == 'u') ADVANCE(312);
      END_STATE();
    case 189:
      if (lookahead == 'e') ADVANCE(313);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(anon_sym_sar);
      END_STATE();
    case 191:
      if (lookahead == 'v') ADVANCE(314);
      END_STATE();
    case 192:
      if (lookahead == 'o') ADVANCE(315);
      END_STATE();
    case 193:
      if (lookahead == 'f') ADVANCE(316);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(anon_sym_sgt);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(anon_sym_shl);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(anon_sym_shr);
      END_STATE();
    case 197:
      if (lookahead == 'n') ADVANCE(317);
      END_STATE();
    case 198:
      if (lookahead == 'a') ADVANCE(318);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(anon_sym_slt);
      END_STATE();
    case 200:
      if (lookahead == 'd') ADVANCE(319);
      END_STATE();
    case 201:
      if (lookahead == 'i') ADVANCE(320);
      END_STATE();
    case 202:
      if (lookahead == 'o') ADVANCE(321);
      END_STATE();
    case 203:
      if (lookahead == 't') ADVANCE(322);
      END_STATE();
    case 204:
      if (lookahead == 'p') ADVANCE(323);
      if (lookahead == 'r') ADVANCE(324);
      END_STATE();
    case 205:
      if (lookahead == 'i') ADVANCE(325);
      if (lookahead == 'u') ADVANCE(326);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(anon_sym_sub);
      END_STATE();
    case 207:
      if (lookahead == 't') ADVANCE(327);
      END_STATE();
    case 208:
      if (lookahead == 'b') ADVANCE(328);
      END_STATE();
    case 209:
      if (lookahead == 'e') ADVANCE(329);
      END_STATE();
    case 210:
      if (lookahead == 'a') ADVANCE(330);
      END_STATE();
    case 211:
      if (lookahead == 'n') ADVANCE(331);
      END_STATE();
    case 212:
      if (lookahead == 'e') ADVANCE(332);
      END_STATE();
    case 213:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 214:
      if (lookahead == 'o') ADVANCE(333);
      END_STATE();
    case 215:
      if (lookahead == 'e') ADVANCE(334);
      END_STATE();
    case 216:
      if (lookahead == 'x') ADVANCE(335);
      END_STATE();
    case 217:
      if (lookahead == 't') ADVANCE(336);
      END_STATE();
    case 218:
      if (lookahead == 'h') ADVANCE(337);
      END_STATE();
    case 219:
      if (lookahead == 'c') ADVANCE(338);
      END_STATE();
    case 220:
      if (lookahead == 'n') ADVANCE(339);
      END_STATE();
    case 221:
      ACCEPT_TOKEN(anon_sym_var);
      END_STATE();
    case 222:
      if (lookahead == 'w') ADVANCE(340);
      END_STATE();
    case 223:
      if (lookahead == 't') ADVANCE(341);
      END_STATE();
    case 224:
      if (lookahead == 'k') ADVANCE(342);
      END_STATE();
    case 225:
      ACCEPT_TOKEN(anon_sym_wei);
      END_STATE();
    case 226:
      if (lookahead == 'l') ADVANCE(343);
      END_STATE();
    case 227:
      ACCEPT_TOKEN(anon_sym_xor);
      END_STATE();
    case 228:
      if (lookahead == 'r') ADVANCE(344);
      END_STATE();
    case 229:
      if (lookahead == 'r') ADVANCE(345);
      END_STATE();
    case 230:
      if (lookahead == 'o') ADVANCE(346);
      END_STATE();
    case 231:
      if (lookahead == 'e') ADVANCE(347);
      END_STATE();
    case 232:
      if (lookahead == 'y') ADVANCE(348);
      END_STATE();
    case 233:
      if (lookahead == 'm') ADVANCE(349);
      END_STATE();
    case 234:
      if (lookahead == 'n') ADVANCE(350);
      END_STATE();
    case 235:
      if (lookahead == 'f') ADVANCE(351);
      END_STATE();
    case 236:
      if (lookahead == 'f') ADVANCE(352);
      if (lookahead == 'h') ADVANCE(353);
      END_STATE();
    case 237:
      if (lookahead == 'k') ADVANCE(354);
      END_STATE();
    case 238:
      ACCEPT_TOKEN(anon_sym_bool);
      END_STATE();
    case 239:
      if (lookahead == 'k') ADVANCE(355);
      END_STATE();
    case 240:
      ACCEPT_TOKEN(anon_sym_byte);
      if (lookahead == 's') ADVANCE(356);
      END_STATE();
    case 241:
      ACCEPT_TOKEN(anon_sym_call);
      if (lookahead == 'c') ADVANCE(357);
      if (lookahead == 'd') ADVANCE(358);
      if (lookahead == 'e') ADVANCE(359);
      if (lookahead == 'v') ADVANCE(360);
      END_STATE();
    case 242:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 243:
      if (lookahead == 'h') ADVANCE(361);
      END_STATE();
    case 244:
      if (lookahead == 'n') ADVANCE(362);
      END_STATE();
    case 245:
      if (lookahead == 'b') ADVANCE(363);
      END_STATE();
    case 246:
      if (lookahead == 't') ADVANCE(364);
      END_STATE();
    case 247:
      if (lookahead == 'i') ADVANCE(365);
      if (lookahead == 'r') ADVANCE(366);
      END_STATE();
    case 248:
      if (lookahead == 't') ADVANCE(367);
      END_STATE();
    case 249:
      ACCEPT_TOKEN(anon_sym_days);
      END_STATE();
    case 250:
      if (lookahead == 'u') ADVANCE(368);
      END_STATE();
    case 251:
      if (lookahead == 'g') ADVANCE(369);
      if (lookahead == 't') ADVANCE(370);
      END_STATE();
    case 252:
      if (lookahead == 'i') ADVANCE(371);
      END_STATE();
    case 253:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 254:
      ACCEPT_TOKEN(anon_sym_emit);
      END_STATE();
    case 255:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 256:
      if (lookahead == 'r') ADVANCE(372);
      END_STATE();
    case 257:
      if (lookahead == 'r') ADVANCE(373);
      END_STATE();
    case 258:
      if (lookahead == 't') ADVANCE(374);
      END_STATE();
    case 259:
      if (lookahead == 'o') ADVANCE(375);
      END_STATE();
    case 260:
      if (lookahead == 'r') ADVANCE(376);
      END_STATE();
    case 261:
      if (lookahead == 'b') ADVANCE(377);
      END_STATE();
    case 262:
      if (lookahead == 'e') ADVANCE(378);
      END_STATE();
    case 263:
      if (lookahead == 'e') ADVANCE(379);
      END_STATE();
    case 264:
      if (lookahead == 'd') ADVANCE(380);
      END_STATE();
    case 265:
      ACCEPT_TOKEN(anon_sym_from);
      END_STATE();
    case 266:
      if (lookahead == 't') ADVANCE(381);
      END_STATE();
    case 267:
      if (lookahead == 'i') ADVANCE(382);
      END_STATE();
    case 268:
      if (lookahead == 'r') ADVANCE(383);
      END_STATE();
    case 269:
      ACCEPT_TOKEN(anon_sym_gwei);
      END_STATE();
    case 270:
      if (lookahead == 's') ADVANCE(384);
      END_STATE();
    case 271:
      if (lookahead == 't') ADVANCE(385);
      END_STATE();
    case 272:
      if (lookahead == 'r') ADVANCE(386);
      END_STATE();
    case 273:
      if (lookahead == 'x') ADVANCE(387);
      END_STATE();
    case 274:
      ADVANCE_MAP(
        '0', 388,
        '1', 389,
        '2', 390,
        '3', 391,
        '4', 392,
        '5', 393,
        '6', 394,
        '7', 395,
        '8', 396,
        '9', 397,
      );
      END_STATE();
    case 275:
      if (lookahead == '0') ADVANCE(398);
      if (lookahead == '1') ADVANCE(399);
      if (lookahead == '2') ADVANCE(400);
      if (lookahead == '3') ADVANCE(401);
      if (lookahead == '4') ADVANCE(402);
      if (lookahead == '5') ADVANCE(403);
      END_STATE();
    case 276:
      if (lookahead == '2') ADVANCE(404);
      END_STATE();
    case 277:
      if (lookahead == '0') ADVANCE(405);
      if (lookahead == '8') ADVANCE(406);
      END_STATE();
    case 278:
      if (lookahead == '6') ADVANCE(407);
      END_STATE();
    case 279:
      if (lookahead == '4') ADVANCE(408);
      END_STATE();
    case 280:
      if (lookahead == '2') ADVANCE(409);
      END_STATE();
    case 281:
      ACCEPT_TOKEN(anon_sym_int8);
      if (lookahead == '0') ADVANCE(410);
      if (lookahead == '8') ADVANCE(411);
      END_STATE();
    case 282:
      if (lookahead == '6') ADVANCE(412);
      END_STATE();
    case 283:
      if (lookahead == 'r') ADVANCE(413);
      END_STATE();
    case 284:
      if (lookahead == 'l') ADVANCE(414);
      END_STATE();
    case 285:
      if (lookahead == 'r') ADVANCE(415);
      END_STATE();
    case 286:
      if (lookahead == 'a') ADVANCE(416);
      END_STATE();
    case 287:
      if (lookahead == 'e') ADVANCE(417);
      END_STATE();
    case 288:
      if (lookahead == 'a') ADVANCE(418);
      END_STATE();
    case 289:
      ACCEPT_TOKEN(anon_sym_log0);
      END_STATE();
    case 290:
      ACCEPT_TOKEN(anon_sym_log1);
      END_STATE();
    case 291:
      ACCEPT_TOKEN(anon_sym_log2);
      END_STATE();
    case 292:
      ACCEPT_TOKEN(anon_sym_log3);
      END_STATE();
    case 293:
      ACCEPT_TOKEN(anon_sym_log4);
      END_STATE();
    case 294:
      if (lookahead == 'i') ADVANCE(419);
      END_STATE();
    case 295:
      if (lookahead == 'y') ADVANCE(420);
      END_STATE();
    case 296:
      if (lookahead == 'r') ADVANCE(421);
      END_STATE();
    case 297:
      if (lookahead == 't') ADVANCE(422);
      END_STATE();
    case 298:
      if (lookahead == 'd') ADVANCE(423);
      END_STATE();
    case 299:
      if (lookahead == 'f') ADVANCE(424);
      END_STATE();
    case 300:
      if (lookahead == 'e') ADVANCE(425);
      END_STATE();
    case 301:
      if (lookahead == 'r') ADVANCE(426);
      END_STATE();
    case 302:
      if (lookahead == 'o') ADVANCE(427);
      END_STATE();
    case 303:
      if (lookahead == 'e') ADVANCE(428);
      END_STATE();
    case 304:
      if (lookahead == 'i') ADVANCE(429);
      END_STATE();
    case 305:
      if (lookahead == 'r') ADVANCE(430);
      END_STATE();
    case 306:
      if (lookahead == 'b') ADVANCE(431);
      END_STATE();
    case 307:
      if (lookahead == 'm') ADVANCE(432);
      END_STATE();
    case 308:
      if (lookahead == 'a') ADVANCE(433);
      END_STATE();
    case 309:
      if (lookahead == 'i') ADVANCE(434);
      END_STATE();
    case 310:
      ACCEPT_TOKEN(anon_sym_pure);
      END_STATE();
    case 311:
      if (lookahead == 'i') ADVANCE(435);
      END_STATE();
    case 312:
      if (lookahead == 'r') ADVANCE(436);
      END_STATE();
    case 313:
      if (lookahead == 'r') ADVANCE(437);
      END_STATE();
    case 314:
      ACCEPT_TOKEN(anon_sym_sdiv);
      END_STATE();
    case 315:
      if (lookahead == 'n') ADVANCE(438);
      END_STATE();
    case 316:
      if (lookahead == 'b') ADVANCE(439);
      if (lookahead == 'd') ADVANCE(440);
      END_STATE();
    case 317:
      if (lookahead == 'e') ADVANCE(441);
      END_STATE();
    case 318:
      if (lookahead == 'd') ADVANCE(442);
      END_STATE();
    case 319:
      ACCEPT_TOKEN(anon_sym_smod);
      END_STATE();
    case 320:
      if (lookahead == 'd') ADVANCE(443);
      END_STATE();
    case 321:
      if (lookahead == 'r') ADVANCE(444);
      END_STATE();
    case 322:
      if (lookahead == 'i') ADVANCE(445);
      END_STATE();
    case 323:
      ACCEPT_TOKEN(anon_sym_stop);
      END_STATE();
    case 324:
      if (lookahead == 'a') ADVANCE(446);
      END_STATE();
    case 325:
      if (lookahead == 'n') ADVANCE(447);
      END_STATE();
    case 326:
      if (lookahead == 'c') ADVANCE(448);
      END_STATE();
    case 327:
      if (lookahead == 'c') ADVANCE(449);
      END_STATE();
    case 328:
      if (lookahead == 'o') ADVANCE(450);
      END_STATE();
    case 329:
      if (lookahead == 's') ADVANCE(451);
      END_STATE();
    case 330:
      if (lookahead == 'd') ADVANCE(452);
      END_STATE();
    case 331:
      if (lookahead == 's') ADVANCE(453);
      END_STATE();
    case 332:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 333:
      if (lookahead == 'r') ADVANCE(454);
      END_STATE();
    case 334:
      ACCEPT_TOKEN(anon_sym_type);
      END_STATE();
    case 335:
      if (lookahead == 'e') ADVANCE(455);
      END_STATE();
    case 336:
      ACCEPT_TOKEN(anon_sym_uint);
      ADVANCE_MAP(
        '1', 456,
        '2', 457,
        '3', 458,
        '4', 459,
        '5', 460,
        '6', 461,
        '7', 462,
        '8', 463,
        '9', 464,
      );
      END_STATE();
    case 337:
      if (lookahead == 'e') ADVANCE(465);
      END_STATE();
    case 338:
      if (lookahead == 'o') ADVANCE(466);
      END_STATE();
    case 339:
      if (lookahead == 'g') ADVANCE(467);
      END_STATE();
    case 340:
      ACCEPT_TOKEN(anon_sym_view);
      END_STATE();
    case 341:
      if (lookahead == 'u') ADVANCE(468);
      END_STATE();
    case 342:
      if (lookahead == 's') ADVANCE(469);
      END_STATE();
    case 343:
      if (lookahead == 'e') ADVANCE(470);
      END_STATE();
    case 344:
      if (lookahead == 's') ADVANCE(471);
      END_STATE();
    case 345:
      if (lookahead == 'a') ADVANCE(472);
      END_STATE();
    case 346:
      if (lookahead == 'd') ADVANCE(473);
      END_STATE();
    case 347:
      if (lookahead == 's') ADVANCE(474);
      END_STATE();
    case 348:
      if (lookahead == 'm') ADVANCE(475);
      END_STATE();
    case 349:
      if (lookahead == 'b') ADVANCE(476);
      END_STATE();
    case 350:
      if (lookahead == 'c') ADVANCE(477);
      END_STATE();
    case 351:
      if (lookahead == 'e') ADVANCE(478);
      END_STATE();
    case 352:
      if (lookahead == 'e') ADVANCE(479);
      END_STATE();
    case 353:
      if (lookahead == 'a') ADVANCE(480);
      END_STATE();
    case 354:
      if (lookahead == 'h') ADVANCE(481);
      END_STATE();
    case 355:
      ACCEPT_TOKEN(anon_sym_break);
      END_STATE();
    case 356:
      ACCEPT_TOKEN(anon_sym_bytes);
      ADVANCE_MAP(
        '1', 482,
        '2', 483,
        '3', 484,
        '4', 485,
        '5', 486,
        '6', 487,
        '7', 488,
        '8', 489,
        '9', 490,
      );
      END_STATE();
    case 357:
      if (lookahead == 'o') ADVANCE(491);
      END_STATE();
    case 358:
      if (lookahead == 'a') ADVANCE(492);
      END_STATE();
    case 359:
      if (lookahead == 'r') ADVANCE(493);
      END_STATE();
    case 360:
      if (lookahead == 'a') ADVANCE(494);
      END_STATE();
    case 361:
      ACCEPT_TOKEN(anon_sym_catch);
      END_STATE();
    case 362:
      if (lookahead == 'i') ADVANCE(495);
      END_STATE();
    case 363:
      if (lookahead == 'a') ADVANCE(496);
      END_STATE();
    case 364:
      if (lookahead == 'a') ADVANCE(497);
      if (lookahead == 'r') ADVANCE(498);
      END_STATE();
    case 365:
      if (lookahead == 'n') ADVANCE(499);
      END_STATE();
    case 366:
      if (lookahead == 'a') ADVANCE(500);
      END_STATE();
    case 367:
      if (lookahead == 'e') ADVANCE(501);
      END_STATE();
    case 368:
      if (lookahead == 'l') ADVANCE(502);
      END_STATE();
    case 369:
      if (lookahead == 'a') ADVANCE(503);
      END_STATE();
    case 370:
      if (lookahead == 'e') ADVANCE(504);
      END_STATE();
    case 371:
      if (lookahead == 'c') ADVANCE(505);
      END_STATE();
    case 372:
      ACCEPT_TOKEN(anon_sym_error);
      END_STATE();
    case 373:
      ACCEPT_TOKEN(anon_sym_ether);
      END_STATE();
    case 374:
      ACCEPT_TOKEN(anon_sym_event);
      END_STATE();
    case 375:
      if (lookahead == 'd') ADVANCE(506);
      END_STATE();
    case 376:
      if (lookahead == 'n') ADVANCE(507);
      END_STATE();
    case 377:
      if (lookahead == 'a') ADVANCE(508);
      END_STATE();
    case 378:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 379:
      if (lookahead == 'y') ADVANCE(509);
      END_STATE();
    case 380:
      ACCEPT_TOKEN(anon_sym_fixed);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(510);
      END_STATE();
    case 381:
      if (lookahead == 'i') ADVANCE(511);
      END_STATE();
    case 382:
      if (lookahead == 'm') ADVANCE(512);
      END_STATE();
    case 383:
      if (lookahead == 'i') ADVANCE(513);
      END_STATE();
    case 384:
      ACCEPT_TOKEN(anon_sym_hours);
      END_STATE();
    case 385:
      if (lookahead == 'a') ADVANCE(514);
      END_STATE();
    case 386:
      if (lookahead == 't') ADVANCE(515);
      END_STATE();
    case 387:
      if (lookahead == 'e') ADVANCE(516);
      END_STATE();
    case 388:
      if (lookahead == '4') ADVANCE(517);
      END_STATE();
    case 389:
      if (lookahead == '2') ADVANCE(518);
      END_STATE();
    case 390:
      if (lookahead == '0') ADVANCE(519);
      if (lookahead == '8') ADVANCE(520);
      END_STATE();
    case 391:
      if (lookahead == '6') ADVANCE(521);
      END_STATE();
    case 392:
      if (lookahead == '4') ADVANCE(522);
      END_STATE();
    case 393:
      if (lookahead == '2') ADVANCE(523);
      END_STATE();
    case 394:
      ACCEPT_TOKEN(anon_sym_int16);
      if (lookahead == '0') ADVANCE(524);
      if (lookahead == '8') ADVANCE(525);
      END_STATE();
    case 395:
      if (lookahead == '6') ADVANCE(526);
      END_STATE();
    case 396:
      if (lookahead == '4') ADVANCE(527);
      END_STATE();
    case 397:
      if (lookahead == '2') ADVANCE(528);
      END_STATE();
    case 398:
      if (lookahead == '0') ADVANCE(529);
      if (lookahead == '8') ADVANCE(530);
      END_STATE();
    case 399:
      if (lookahead == '6') ADVANCE(531);
      END_STATE();
    case 400:
      if (lookahead == '4') ADVANCE(532);
      END_STATE();
    case 401:
      if (lookahead == '2') ADVANCE(533);
      END_STATE();
    case 402:
      ACCEPT_TOKEN(anon_sym_int24);
      if (lookahead == '0') ADVANCE(534);
      if (lookahead == '8') ADVANCE(535);
      END_STATE();
    case 403:
      if (lookahead == '6') ADVANCE(536);
      END_STATE();
    case 404:
      ACCEPT_TOKEN(anon_sym_int32);
      END_STATE();
    case 405:
      ACCEPT_TOKEN(anon_sym_int40);
      END_STATE();
    case 406:
      ACCEPT_TOKEN(anon_sym_int48);
      END_STATE();
    case 407:
      ACCEPT_TOKEN(anon_sym_int56);
      END_STATE();
    case 408:
      ACCEPT_TOKEN(anon_sym_int64);
      END_STATE();
    case 409:
      ACCEPT_TOKEN(anon_sym_int72);
      END_STATE();
    case 410:
      ACCEPT_TOKEN(anon_sym_int80);
      END_STATE();
    case 411:
      ACCEPT_TOKEN(anon_sym_int88);
      END_STATE();
    case 412:
      ACCEPT_TOKEN(anon_sym_int96);
      END_STATE();
    case 413:
      if (lookahead == 'f') ADVANCE(537);
      if (lookahead == 'n') ADVANCE(538);
      END_STATE();
    case 414:
      if (lookahead == 'i') ADVANCE(539);
      END_STATE();
    case 415:
      if (lookahead == 'o') ADVANCE(540);
      END_STATE();
    case 416:
      if (lookahead == 'k') ADVANCE(541);
      END_STATE();
    case 417:
      ACCEPT_TOKEN(sym_yul_leave);
      END_STATE();
    case 418:
      if (lookahead == 'r') ADVANCE(542);
      END_STATE();
    case 419:
      if (lookahead == 'n') ADVANCE(543);
      END_STATE();
    case 420:
      ACCEPT_TOKEN(anon_sym_mcopy);
      END_STATE();
    case 421:
      if (lookahead == 'y') ADVANCE(544);
      END_STATE();
    case 422:
      if (lookahead == 'e') ADVANCE(545);
      END_STATE();
    case 423:
      ACCEPT_TOKEN(anon_sym_mload);
      END_STATE();
    case 424:
      if (lookahead == 'i') ADVANCE(546);
      END_STATE();
    case 425:
      ACCEPT_TOKEN(anon_sym_msize);
      END_STATE();
    case 426:
      if (lookahead == 'e') ADVANCE(547);
      END_STATE();
    case 427:
      if (lookahead == 'd') ADVANCE(548);
      END_STATE();
    case 428:
      if (lookahead == 'r') ADVANCE(549);
      END_STATE();
    case 429:
      if (lookahead == 'n') ADVANCE(550);
      END_STATE();
    case 430:
      if (lookahead == 'i') ADVANCE(551);
      END_STATE();
    case 431:
      if (lookahead == 'l') ADVANCE(552);
      END_STATE();
    case 432:
      if (lookahead == 'a') ADVANCE(553);
      END_STATE();
    case 433:
      if (lookahead == 't') ADVANCE(554);
      END_STATE();
    case 434:
      if (lookahead == 'c') ADVANCE(555);
      END_STATE();
    case 435:
      if (lookahead == 'v') ADVANCE(556);
      END_STATE();
    case 436:
      if (lookahead == 'n') ADVANCE(557);
      END_STATE();
    case 437:
      if (lookahead == 't') ADVANCE(558);
      END_STATE();
    case 438:
      if (lookahead == 'd') ADVANCE(559);
      END_STATE();
    case 439:
      if (lookahead == 'a') ADVANCE(560);
      END_STATE();
    case 440:
      if (lookahead == 'e') ADVANCE(561);
      END_STATE();
    case 441:
      if (lookahead == 'x') ADVANCE(562);
      END_STATE();
    case 442:
      ACCEPT_TOKEN(anon_sym_sload);
      END_STATE();
    case 443:
      if (lookahead == 'i') ADVANCE(563);
      END_STATE();
    case 444:
      if (lookahead == 'e') ADVANCE(564);
      END_STATE();
    case 445:
      if (lookahead == 'c') ADVANCE(565);
      END_STATE();
    case 446:
      if (lookahead == 'g') ADVANCE(566);
      END_STATE();
    case 447:
      if (lookahead == 'g') ADVANCE(567);
      END_STATE();
    case 448:
      if (lookahead == 't') ADVANCE(568);
      END_STATE();
    case 449:
      if (lookahead == 'h') ADVANCE(569);
      END_STATE();
    case 450:
      ACCEPT_TOKEN(anon_sym_szabo);
      END_STATE();
    case 451:
      if (lookahead == 't') ADVANCE(570);
      END_STATE();
    case 452:
      ACCEPT_TOKEN(anon_sym_tload);
      END_STATE();
    case 453:
      if (lookahead == 'i') ADVANCE(571);
      END_STATE();
    case 454:
      if (lookahead == 'e') ADVANCE(572);
      END_STATE();
    case 455:
      if (lookahead == 'd') ADVANCE(573);
      END_STATE();
    case 456:
      ADVANCE_MAP(
        '0', 574,
        '1', 575,
        '2', 576,
        '3', 577,
        '4', 578,
        '5', 579,
        '6', 580,
        '7', 581,
        '8', 582,
        '9', 583,
      );
      END_STATE();
    case 457:
      if (lookahead == '0') ADVANCE(584);
      if (lookahead == '1') ADVANCE(585);
      if (lookahead == '2') ADVANCE(586);
      if (lookahead == '3') ADVANCE(587);
      if (lookahead == '4') ADVANCE(588);
      if (lookahead == '5') ADVANCE(589);
      END_STATE();
    case 458:
      if (lookahead == '2') ADVANCE(590);
      END_STATE();
    case 459:
      if (lookahead == '0') ADVANCE(591);
      if (lookahead == '8') ADVANCE(592);
      END_STATE();
    case 460:
      if (lookahead == '6') ADVANCE(593);
      END_STATE();
    case 461:
      if (lookahead == '4') ADVANCE(594);
      END_STATE();
    case 462:
      if (lookahead == '2') ADVANCE(595);
      END_STATE();
    case 463:
      ACCEPT_TOKEN(anon_sym_uint8);
      if (lookahead == '0') ADVANCE(596);
      if (lookahead == '8') ADVANCE(597);
      END_STATE();
    case 464:
      if (lookahead == '6') ADVANCE(598);
      END_STATE();
    case 465:
      if (lookahead == 'c') ADVANCE(599);
      END_STATE();
    case 466:
      if (lookahead == 'd') ADVANCE(600);
      END_STATE();
    case 467:
      ACCEPT_TOKEN(anon_sym_using);
      END_STATE();
    case 468:
      if (lookahead == 'a') ADVANCE(601);
      END_STATE();
    case 469:
      ACCEPT_TOKEN(anon_sym_weeks);
      END_STATE();
    case 470:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 471:
      ACCEPT_TOKEN(anon_sym_years);
      END_STATE();
    case 472:
      if (lookahead == 'c') ADVANCE(602);
      END_STATE();
    case 473:
      ACCEPT_TOKEN(anon_sym_addmod);
      END_STATE();
    case 474:
      if (lookahead == 's') ADVANCE(603);
      END_STATE();
    case 475:
      if (lookahead == 'o') ADVANCE(604);
      END_STATE();
    case 476:
      if (lookahead == 'l') ADVANCE(605);
      END_STATE();
    case 477:
      if (lookahead == 'e') ADVANCE(606);
      END_STATE();
    case 478:
      if (lookahead == 'e') ADVANCE(607);
      END_STATE();
    case 479:
      if (lookahead == 'e') ADVANCE(608);
      END_STATE();
    case 480:
      if (lookahead == 's') ADVANCE(609);
      END_STATE();
    case 481:
      if (lookahead == 'a') ADVANCE(610);
      END_STATE();
    case 482:
      ACCEPT_TOKEN(anon_sym_bytes1);
      ADVANCE_MAP(
        '0', 611,
        '1', 612,
        '2', 613,
        '3', 614,
        '4', 615,
        '5', 616,
        '6', 617,
        '7', 618,
        '8', 619,
        '9', 620,
      );
      END_STATE();
    case 483:
      ACCEPT_TOKEN(anon_sym_bytes2);
      ADVANCE_MAP(
        '0', 621,
        '1', 622,
        '2', 623,
        '3', 624,
        '4', 625,
        '5', 626,
        '6', 627,
        '7', 628,
        '8', 629,
        '9', 630,
      );
      END_STATE();
    case 484:
      ACCEPT_TOKEN(anon_sym_bytes3);
      if (lookahead == '0') ADVANCE(631);
      if (lookahead == '1') ADVANCE(632);
      if (lookahead == '2') ADVANCE(633);
      END_STATE();
    case 485:
      ACCEPT_TOKEN(anon_sym_bytes4);
      END_STATE();
    case 486:
      ACCEPT_TOKEN(anon_sym_bytes5);
      END_STATE();
    case 487:
      ACCEPT_TOKEN(anon_sym_bytes6);
      END_STATE();
    case 488:
      ACCEPT_TOKEN(anon_sym_bytes7);
      END_STATE();
    case 489:
      ACCEPT_TOKEN(anon_sym_bytes8);
      END_STATE();
    case 490:
      ACCEPT_TOKEN(anon_sym_bytes9);
      END_STATE();
    case 491:
      if (lookahead == 'd') ADVANCE(634);
      END_STATE();
    case 492:
      if (lookahead == 't') ADVANCE(635);
      END_STATE();
    case 493:
      ACCEPT_TOKEN(anon_sym_caller);
      END_STATE();
    case 494:
      if (lookahead == 'l') ADVANCE(636);
      END_STATE();
    case 495:
      if (lookahead == 'd') ADVANCE(637);
      END_STATE();
    case 496:
      if (lookahead == 's') ADVANCE(638);
      END_STATE();
    case 497:
      if (lookahead == 'n') ADVANCE(639);
      END_STATE();
    case 498:
      if (lookahead == 'u') ADVANCE(640);
      END_STATE();
    case 499:
      if (lookahead == 'u') ADVANCE(641);
      END_STATE();
    case 500:
      if (lookahead == 'c') ADVANCE(642);
      END_STATE();
    case 501:
      ACCEPT_TOKEN(anon_sym_create);
      if (lookahead == '2') ADVANCE(643);
      END_STATE();
    case 502:
      if (lookahead == 't') ADVANCE(644);
      END_STATE();
    case 503:
      if (lookahead == 't') ADVANCE(645);
      END_STATE();
    case 504:
      ACCEPT_TOKEN(anon_sym_delete);
      END_STATE();
    case 505:
      if (lookahead == 'u') ADVANCE(646);
      END_STATE();
    case 506:
      if (lookahead == 'e') ADVANCE(647);
      END_STATE();
    case 507:
      if (lookahead == 'a') ADVANCE(648);
      END_STATE();
    case 508:
      if (lookahead == 'c') ADVANCE(649);
      END_STATE();
    case 509:
      ACCEPT_TOKEN(anon_sym_finney);
      END_STATE();
    case 510:
      if (lookahead == 'x') ADVANCE(650);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(510);
      END_STATE();
    case 511:
      if (lookahead == 'o') ADVANCE(651);
      END_STATE();
    case 512:
      if (lookahead == 'i') ADVANCE(652);
      END_STATE();
    case 513:
      if (lookahead == 'c') ADVANCE(653);
      END_STATE();
    case 514:
      if (lookahead == 'b') ADVANCE(654);
      END_STATE();
    case 515:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 516:
      if (lookahead == 'd') ADVANCE(655);
      END_STATE();
    case 517:
      ACCEPT_TOKEN(anon_sym_int104);
      END_STATE();
    case 518:
      ACCEPT_TOKEN(anon_sym_int112);
      END_STATE();
    case 519:
      ACCEPT_TOKEN(anon_sym_int120);
      END_STATE();
    case 520:
      ACCEPT_TOKEN(anon_sym_int128);
      END_STATE();
    case 521:
      ACCEPT_TOKEN(anon_sym_int136);
      END_STATE();
    case 522:
      ACCEPT_TOKEN(anon_sym_int144);
      END_STATE();
    case 523:
      ACCEPT_TOKEN(anon_sym_int152);
      END_STATE();
    case 524:
      ACCEPT_TOKEN(anon_sym_int160);
      END_STATE();
    case 525:
      ACCEPT_TOKEN(anon_sym_int168);
      END_STATE();
    case 526:
      ACCEPT_TOKEN(anon_sym_int176);
      END_STATE();
    case 527:
      ACCEPT_TOKEN(anon_sym_int184);
      END_STATE();
    case 528:
      ACCEPT_TOKEN(anon_sym_int192);
      END_STATE();
    case 529:
      ACCEPT_TOKEN(anon_sym_int200);
      END_STATE();
    case 530:
      ACCEPT_TOKEN(anon_sym_int208);
      END_STATE();
    case 531:
      ACCEPT_TOKEN(anon_sym_int216);
      END_STATE();
    case 532:
      ACCEPT_TOKEN(anon_sym_int224);
      END_STATE();
    case 533:
      ACCEPT_TOKEN(anon_sym_int232);
      END_STATE();
    case 534:
      ACCEPT_TOKEN(anon_sym_int240);
      END_STATE();
    case 535:
      ACCEPT_TOKEN(anon_sym_int248);
      END_STATE();
    case 536:
      ACCEPT_TOKEN(anon_sym_int256);
      END_STATE();
    case 537:
      if (lookahead == 'a') ADVANCE(656);
      END_STATE();
    case 538:
      if (lookahead == 'a') ADVANCE(657);
      END_STATE();
    case 539:
      if (lookahead == 'd') ADVANCE(658);
      END_STATE();
    case 540:
      ACCEPT_TOKEN(anon_sym_iszero);
      END_STATE();
    case 541:
      if (lookahead == '2') ADVANCE(659);
      END_STATE();
    case 542:
      if (lookahead == 'y') ADVANCE(660);
      END_STATE();
    case 543:
      if (lookahead == 'g') ADVANCE(661);
      END_STATE();
    case 544:
      ACCEPT_TOKEN(anon_sym_memory);
      END_STATE();
    case 545:
      if (lookahead == 's') ADVANCE(662);
      END_STATE();
    case 546:
      if (lookahead == 'e') ADVANCE(663);
      END_STATE();
    case 547:
      ACCEPT_TOKEN(anon_sym_mstore);
      if (lookahead == '8') ADVANCE(664);
      END_STATE();
    case 548:
      ACCEPT_TOKEN(anon_sym_mulmod);
      END_STATE();
    case 549:
      ACCEPT_TOKEN(anon_sym_number);
      END_STATE();
    case 550:
      ACCEPT_TOKEN(anon_sym_origin);
      END_STATE();
    case 551:
      if (lookahead == 'd') ADVANCE(665);
      END_STATE();
    case 552:
      if (lookahead == 'e') ADVANCE(666);
      END_STATE();
    case 553:
      ACCEPT_TOKEN(anon_sym_pragma);
      END_STATE();
    case 554:
      if (lookahead == 'e') ADVANCE(667);
      END_STATE();
    case 555:
      ACCEPT_TOKEN(anon_sym_public);
      END_STATE();
    case 556:
      if (lookahead == 'e') ADVANCE(668);
      END_STATE();
    case 557:
      ACCEPT_TOKEN(anon_sym_return);
      if (lookahead == 'd') ADVANCE(669);
      if (lookahead == 's') ADVANCE(670);
      END_STATE();
    case 558:
      ACCEPT_TOKEN(anon_sym_revert);
      END_STATE();
    case 559:
      if (lookahead == 's') ADVANCE(671);
      END_STATE();
    case 560:
      if (lookahead == 'l') ADVANCE(672);
      END_STATE();
    case 561:
      if (lookahead == 's') ADVANCE(673);
      END_STATE();
    case 562:
      if (lookahead == 't') ADVANCE(674);
      END_STATE();
    case 563:
      if (lookahead == 't') ADVANCE(675);
      END_STATE();
    case 564:
      ACCEPT_TOKEN(anon_sym_sstore);
      END_STATE();
    case 565:
      if (lookahead == 'c') ADVANCE(676);
      END_STATE();
    case 566:
      if (lookahead == 'e') ADVANCE(677);
      END_STATE();
    case 567:
      ACCEPT_TOKEN(anon_sym_string);
      END_STATE();
    case 568:
      ACCEPT_TOKEN(anon_sym_struct);
      END_STATE();
    case 569:
      ACCEPT_TOKEN(anon_sym_switch);
      END_STATE();
    case 570:
      if (lookahead == 'a') ADVANCE(678);
      END_STATE();
    case 571:
      if (lookahead == 'e') ADVANCE(679);
      END_STATE();
    case 572:
      ACCEPT_TOKEN(anon_sym_tstore);
      END_STATE();
    case 573:
      ACCEPT_TOKEN(anon_sym_ufixed);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(680);
      END_STATE();
    case 574:
      if (lookahead == '4') ADVANCE(681);
      END_STATE();
    case 575:
      if (lookahead == '2') ADVANCE(682);
      END_STATE();
    case 576:
      if (lookahead == '0') ADVANCE(683);
      if (lookahead == '8') ADVANCE(684);
      END_STATE();
    case 577:
      if (lookahead == '6') ADVANCE(685);
      END_STATE();
    case 578:
      if (lookahead == '4') ADVANCE(686);
      END_STATE();
    case 579:
      if (lookahead == '2') ADVANCE(687);
      END_STATE();
    case 580:
      ACCEPT_TOKEN(anon_sym_uint16);
      if (lookahead == '0') ADVANCE(688);
      if (lookahead == '8') ADVANCE(689);
      END_STATE();
    case 581:
      if (lookahead == '6') ADVANCE(690);
      END_STATE();
    case 582:
      if (lookahead == '4') ADVANCE(691);
      END_STATE();
    case 583:
      if (lookahead == '2') ADVANCE(692);
      END_STATE();
    case 584:
      if (lookahead == '0') ADVANCE(693);
      if (lookahead == '8') ADVANCE(694);
      END_STATE();
    case 585:
      if (lookahead == '6') ADVANCE(695);
      END_STATE();
    case 586:
      if (lookahead == '4') ADVANCE(696);
      END_STATE();
    case 587:
      if (lookahead == '2') ADVANCE(697);
      END_STATE();
    case 588:
      ACCEPT_TOKEN(anon_sym_uint24);
      if (lookahead == '0') ADVANCE(698);
      if (lookahead == '8') ADVANCE(699);
      END_STATE();
    case 589:
      if (lookahead == '6') ADVANCE(700);
      END_STATE();
    case 590:
      ACCEPT_TOKEN(anon_sym_uint32);
      END_STATE();
    case 591:
      ACCEPT_TOKEN(anon_sym_uint40);
      END_STATE();
    case 592:
      ACCEPT_TOKEN(anon_sym_uint48);
      END_STATE();
    case 593:
      ACCEPT_TOKEN(anon_sym_uint56);
      END_STATE();
    case 594:
      ACCEPT_TOKEN(anon_sym_uint64);
      END_STATE();
    case 595:
      ACCEPT_TOKEN(anon_sym_uint72);
      END_STATE();
    case 596:
      ACCEPT_TOKEN(anon_sym_uint80);
      END_STATE();
    case 597:
      ACCEPT_TOKEN(anon_sym_uint88);
      END_STATE();
    case 598:
      ACCEPT_TOKEN(anon_sym_uint96);
      END_STATE();
    case 599:
      if (lookahead == 'k') ADVANCE(701);
      END_STATE();
    case 600:
      if (lookahead == 'e') ADVANCE(702);
      END_STATE();
    case 601:
      if (lookahead == 'l') ADVANCE(703);
      END_STATE();
    case 602:
      if (lookahead == 't') ADVANCE(704);
      END_STATE();
    case 603:
      ACCEPT_TOKEN(anon_sym_address);
      END_STATE();
    case 604:
      if (lookahead == 'u') ADVANCE(705);
      END_STATE();
    case 605:
      if (lookahead == 'y') ADVANCE(706);
      END_STATE();
    case 606:
      ACCEPT_TOKEN(anon_sym_balance);
      END_STATE();
    case 607:
      ACCEPT_TOKEN(anon_sym_basefee);
      END_STATE();
    case 608:
      ACCEPT_TOKEN(anon_sym_blobfee);
      END_STATE();
    case 609:
      if (lookahead == 'h') ADVANCE(707);
      END_STATE();
    case 610:
      if (lookahead == 's') ADVANCE(708);
      END_STATE();
    case 611:
      ACCEPT_TOKEN(anon_sym_bytes10);
      END_STATE();
    case 612:
      ACCEPT_TOKEN(anon_sym_bytes11);
      END_STATE();
    case 613:
      ACCEPT_TOKEN(anon_sym_bytes12);
      END_STATE();
    case 614:
      ACCEPT_TOKEN(anon_sym_bytes13);
      END_STATE();
    case 615:
      ACCEPT_TOKEN(anon_sym_bytes14);
      END_STATE();
    case 616:
      ACCEPT_TOKEN(anon_sym_bytes15);
      END_STATE();
    case 617:
      ACCEPT_TOKEN(anon_sym_bytes16);
      END_STATE();
    case 618:
      ACCEPT_TOKEN(anon_sym_bytes17);
      END_STATE();
    case 619:
      ACCEPT_TOKEN(anon_sym_bytes18);
      END_STATE();
    case 620:
      ACCEPT_TOKEN(anon_sym_bytes19);
      END_STATE();
    case 621:
      ACCEPT_TOKEN(anon_sym_bytes20);
      END_STATE();
    case 622:
      ACCEPT_TOKEN(anon_sym_bytes21);
      END_STATE();
    case 623:
      ACCEPT_TOKEN(anon_sym_bytes22);
      END_STATE();
    case 624:
      ACCEPT_TOKEN(anon_sym_bytes23);
      END_STATE();
    case 625:
      ACCEPT_TOKEN(anon_sym_bytes24);
      END_STATE();
    case 626:
      ACCEPT_TOKEN(anon_sym_bytes25);
      END_STATE();
    case 627:
      ACCEPT_TOKEN(anon_sym_bytes26);
      END_STATE();
    case 628:
      ACCEPT_TOKEN(anon_sym_bytes27);
      END_STATE();
    case 629:
      ACCEPT_TOKEN(anon_sym_bytes28);
      END_STATE();
    case 630:
      ACCEPT_TOKEN(anon_sym_bytes29);
      END_STATE();
    case 631:
      ACCEPT_TOKEN(anon_sym_bytes30);
      END_STATE();
    case 632:
      ACCEPT_TOKEN(anon_sym_bytes31);
      END_STATE();
    case 633:
      ACCEPT_TOKEN(anon_sym_bytes32);
      END_STATE();
    case 634:
      if (lookahead == 'e') ADVANCE(709);
      END_STATE();
    case 635:
      if (lookahead == 'a') ADVANCE(710);
      END_STATE();
    case 636:
      if (lookahead == 'u') ADVANCE(711);
      END_STATE();
    case 637:
      ACCEPT_TOKEN(anon_sym_chainid);
      END_STATE();
    case 638:
      if (lookahead == 'e') ADVANCE(712);
      END_STATE();
    case 639:
      if (lookahead == 't') ADVANCE(713);
      END_STATE();
    case 640:
      if (lookahead == 'c') ADVANCE(714);
      END_STATE();
    case 641:
      if (lookahead == 'e') ADVANCE(715);
      END_STATE();
    case 642:
      if (lookahead == 't') ADVANCE(716);
      END_STATE();
    case 643:
      ACCEPT_TOKEN(anon_sym_create2);
      END_STATE();
    case 644:
      ACCEPT_TOKEN(anon_sym_default);
      END_STATE();
    case 645:
      if (lookahead == 'e') ADVANCE(717);
      END_STATE();
    case 646:
      if (lookahead == 'l') ADVANCE(718);
      END_STATE();
    case 647:
      if (lookahead == 'c') ADVANCE(719);
      if (lookahead == 'h') ADVANCE(720);
      if (lookahead == 's') ADVANCE(721);
      END_STATE();
    case 648:
      if (lookahead == 'l') ADVANCE(722);
      END_STATE();
    case 649:
      if (lookahead == 'k') ADVANCE(723);
      END_STATE();
    case 650:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(724);
      END_STATE();
    case 651:
      if (lookahead == 'n') ADVANCE(725);
      END_STATE();
    case 652:
      if (lookahead == 't') ADVANCE(726);
      END_STATE();
    case 653:
      if (lookahead == 'e') ADVANCE(727);
      END_STATE();
    case 654:
      if (lookahead == 'l') ADVANCE(728);
      END_STATE();
    case 655:
      ACCEPT_TOKEN(anon_sym_indexed);
      END_STATE();
    case 656:
      if (lookahead == 'c') ADVANCE(729);
      END_STATE();
    case 657:
      if (lookahead == 'l') ADVANCE(730);
      END_STATE();
    case 658:
      ACCEPT_TOKEN(anon_sym_invalid);
      END_STATE();
    case 659:
      if (lookahead == '5') ADVANCE(731);
      END_STATE();
    case 660:
      ACCEPT_TOKEN(anon_sym_library);
      END_STATE();
    case 661:
      ACCEPT_TOKEN(anon_sym_mapping);
      END_STATE();
    case 662:
      ACCEPT_TOKEN(anon_sym_minutes);
      END_STATE();
    case 663:
      if (lookahead == 'r') ADVANCE(732);
      END_STATE();
    case 664:
      ACCEPT_TOKEN(anon_sym_mstore8);
      END_STATE();
    case 665:
      if (lookahead == 'e') ADVANCE(733);
      END_STATE();
    case 666:
      ACCEPT_TOKEN(anon_sym_payable);
      END_STATE();
    case 667:
      ACCEPT_TOKEN(anon_sym_private);
      END_STATE();
    case 668:
      ACCEPT_TOKEN(anon_sym_receive);
      END_STATE();
    case 669:
      if (lookahead == 'a') ADVANCE(734);
      END_STATE();
    case 670:
      ACCEPT_TOKEN(anon_sym_returns);
      END_STATE();
    case 671:
      ACCEPT_TOKEN(anon_sym_seconds);
      END_STATE();
    case 672:
      if (lookahead == 'a') ADVANCE(735);
      END_STATE();
    case 673:
      if (lookahead == 't') ADVANCE(736);
      END_STATE();
    case 674:
      if (lookahead == 'e') ADVANCE(737);
      END_STATE();
    case 675:
      if (lookahead == 'y') ADVANCE(738);
      END_STATE();
    case 676:
      if (lookahead == 'a') ADVANCE(739);
      END_STATE();
    case 677:
      ACCEPT_TOKEN(anon_sym_storage);
      END_STATE();
    case 678:
      if (lookahead == 'm') ADVANCE(740);
      END_STATE();
    case 679:
      if (lookahead == 'n') ADVANCE(741);
      END_STATE();
    case 680:
      if (lookahead == 'x') ADVANCE(742);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(680);
      END_STATE();
    case 681:
      ACCEPT_TOKEN(anon_sym_uint104);
      END_STATE();
    case 682:
      ACCEPT_TOKEN(anon_sym_uint112);
      END_STATE();
    case 683:
      ACCEPT_TOKEN(anon_sym_uint120);
      END_STATE();
    case 684:
      ACCEPT_TOKEN(anon_sym_uint128);
      END_STATE();
    case 685:
      ACCEPT_TOKEN(anon_sym_uint136);
      END_STATE();
    case 686:
      ACCEPT_TOKEN(anon_sym_uint144);
      END_STATE();
    case 687:
      ACCEPT_TOKEN(anon_sym_uint152);
      END_STATE();
    case 688:
      ACCEPT_TOKEN(anon_sym_uint160);
      END_STATE();
    case 689:
      ACCEPT_TOKEN(anon_sym_uint168);
      END_STATE();
    case 690:
      ACCEPT_TOKEN(anon_sym_uint176);
      END_STATE();
    case 691:
      ACCEPT_TOKEN(anon_sym_uint184);
      END_STATE();
    case 692:
      ACCEPT_TOKEN(anon_sym_uint192);
      END_STATE();
    case 693:
      ACCEPT_TOKEN(anon_sym_uint200);
      END_STATE();
    case 694:
      ACCEPT_TOKEN(anon_sym_uint208);
      END_STATE();
    case 695:
      ACCEPT_TOKEN(anon_sym_uint216);
      END_STATE();
    case 696:
      ACCEPT_TOKEN(anon_sym_uint224);
      END_STATE();
    case 697:
      ACCEPT_TOKEN(anon_sym_uint232);
      END_STATE();
    case 698:
      ACCEPT_TOKEN(anon_sym_uint240);
      END_STATE();
    case 699:
      ACCEPT_TOKEN(anon_sym_uint248);
      END_STATE();
    case 700:
      ACCEPT_TOKEN(anon_sym_uint256);
      END_STATE();
    case 701:
      if (lookahead == 'e') ADVANCE(743);
      END_STATE();
    case 702:
      ACCEPT_TOKEN(anon_sym_unicode);
      END_STATE();
    case 703:
      ACCEPT_TOKEN(sym_virtual);
      END_STATE();
    case 704:
      ACCEPT_TOKEN(anon_sym_abstract);
      END_STATE();
    case 705:
      if (lookahead == 's') ADVANCE(744);
      END_STATE();
    case 706:
      ACCEPT_TOKEN(anon_sym_assembly);
      END_STATE();
    case 707:
      ACCEPT_TOKEN(anon_sym_blobhash);
      END_STATE();
    case 708:
      if (lookahead == 'h') ADVANCE(745);
      END_STATE();
    case 709:
      ACCEPT_TOKEN(anon_sym_callcode);
      END_STATE();
    case 710:
      ACCEPT_TOKEN(anon_sym_calldata);
      if (lookahead == 'c') ADVANCE(746);
      if (lookahead == 'l') ADVANCE(747);
      if (lookahead == 's') ADVANCE(748);
      END_STATE();
    case 711:
      if (lookahead == 'e') ADVANCE(749);
      END_STATE();
    case 712:
      ACCEPT_TOKEN(anon_sym_coinbase);
      END_STATE();
    case 713:
      ACCEPT_TOKEN(anon_sym_constant);
      END_STATE();
    case 714:
      if (lookahead == 't') ADVANCE(750);
      END_STATE();
    case 715:
      ACCEPT_TOKEN(anon_sym_continue);
      END_STATE();
    case 716:
      ACCEPT_TOKEN(anon_sym_contract);
      END_STATE();
    case 717:
      if (lookahead == 'c') ADVANCE(751);
      END_STATE();
    case 718:
      if (lookahead == 't') ADVANCE(752);
      END_STATE();
    case 719:
      if (lookahead == 'o') ADVANCE(753);
      END_STATE();
    case 720:
      if (lookahead == 'a') ADVANCE(754);
      END_STATE();
    case 721:
      if (lookahead == 'i') ADVANCE(755);
      END_STATE();
    case 722:
      ACCEPT_TOKEN(anon_sym_external);
      END_STATE();
    case 723:
      ACCEPT_TOKEN(anon_sym_fallback);
      END_STATE();
    case 724:
      ACCEPT_TOKEN(aux_sym__fixed_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(724);
      END_STATE();
    case 725:
      ACCEPT_TOKEN(anon_sym_function);
      END_STATE();
    case 726:
      ACCEPT_TOKEN(anon_sym_gaslimit);
      END_STATE();
    case 727:
      ACCEPT_TOKEN(anon_sym_gasprice);
      END_STATE();
    case 728:
      if (lookahead == 'e') ADVANCE(756);
      END_STATE();
    case 729:
      if (lookahead == 'e') ADVANCE(757);
      END_STATE();
    case 730:
      ACCEPT_TOKEN(anon_sym_internal);
      END_STATE();
    case 731:
      if (lookahead == '6') ADVANCE(758);
      END_STATE();
    case 732:
      ACCEPT_TOKEN(anon_sym_modifier);
      END_STATE();
    case 733:
      ACCEPT_TOKEN(anon_sym_override);
      END_STATE();
    case 734:
      if (lookahead == 't') ADVANCE(759);
      END_STATE();
    case 735:
      if (lookahead == 'n') ADVANCE(760);
      END_STATE();
    case 736:
      if (lookahead == 'r') ADVANCE(761);
      END_STATE();
    case 737:
      if (lookahead == 'n') ADVANCE(762);
      END_STATE();
    case 738:
      ACCEPT_TOKEN(anon_sym_solidity);
      END_STATE();
    case 739:
      if (lookahead == 'l') ADVANCE(763);
      END_STATE();
    case 740:
      if (lookahead == 'p') ADVANCE(764);
      END_STATE();
    case 741:
      if (lookahead == 't') ADVANCE(765);
      END_STATE();
    case 742:
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(766);
      END_STATE();
    case 743:
      if (lookahead == 'd') ADVANCE(767);
      END_STATE();
    case 744:
      ACCEPT_TOKEN(anon_sym_anonymous);
      END_STATE();
    case 745:
      ACCEPT_TOKEN(anon_sym_blockhash);
      END_STATE();
    case 746:
      if (lookahead == 'o') ADVANCE(768);
      END_STATE();
    case 747:
      if (lookahead == 'o') ADVANCE(769);
      END_STATE();
    case 748:
      if (lookahead == 'i') ADVANCE(770);
      END_STATE();
    case 749:
      ACCEPT_TOKEN(anon_sym_callvalue);
      END_STATE();
    case 750:
      if (lookahead == 'o') ADVANCE(771);
      END_STATE();
    case 751:
      if (lookahead == 'a') ADVANCE(772);
      END_STATE();
    case 752:
      if (lookahead == 'y') ADVANCE(773);
      END_STATE();
    case 753:
      if (lookahead == 'p') ADVANCE(774);
      END_STATE();
    case 754:
      if (lookahead == 's') ADVANCE(775);
      END_STATE();
    case 755:
      if (lookahead == 'z') ADVANCE(776);
      END_STATE();
    case 756:
      ACCEPT_TOKEN(sym_immutable);
      END_STATE();
    case 757:
      ACCEPT_TOKEN(anon_sym_interface);
      END_STATE();
    case 758:
      ACCEPT_TOKEN(anon_sym_keccak256);
      END_STATE();
    case 759:
      if (lookahead == 'a') ADVANCE(777);
      END_STATE();
    case 760:
      if (lookahead == 'c') ADVANCE(778);
      END_STATE();
    case 761:
      if (lookahead == 'u') ADVANCE(779);
      END_STATE();
    case 762:
      if (lookahead == 'd') ADVANCE(780);
      END_STATE();
    case 763:
      if (lookahead == 'l') ADVANCE(781);
      END_STATE();
    case 764:
      ACCEPT_TOKEN(anon_sym_timestamp);
      END_STATE();
    case 765:
      ACCEPT_TOKEN(anon_sym_transient);
      END_STATE();
    case 766:
      ACCEPT_TOKEN(aux_sym__ufixed_token1);
      if (('0' <= lookahead && lookahead <= '9')) ADVANCE(766);
      END_STATE();
    case 767:
      ACCEPT_TOKEN(sym_unchecked);
      END_STATE();
    case 768:
      if (lookahead == 'p') ADVANCE(782);
      END_STATE();
    case 769:
      if (lookahead == 'a') ADVANCE(783);
      END_STATE();
    case 770:
      if (lookahead == 'z') ADVANCE(784);
      END_STATE();
    case 771:
      if (lookahead == 'r') ADVANCE(785);
      END_STATE();
    case 772:
      if (lookahead == 'l') ADVANCE(786);
      END_STATE();
    case 773:
      ACCEPT_TOKEN(anon_sym_difficulty);
      END_STATE();
    case 774:
      if (lookahead == 'y') ADVANCE(787);
      END_STATE();
    case 775:
      if (lookahead == 'h') ADVANCE(788);
      END_STATE();
    case 776:
      if (lookahead == 'e') ADVANCE(789);
      END_STATE();
    case 777:
      if (lookahead == 'c') ADVANCE(790);
      if (lookahead == 's') ADVANCE(791);
      END_STATE();
    case 778:
      if (lookahead == 'e') ADVANCE(792);
      END_STATE();
    case 779:
      if (lookahead == 'c') ADVANCE(793);
      END_STATE();
    case 780:
      ACCEPT_TOKEN(anon_sym_signextend);
      END_STATE();
    case 781:
      ACCEPT_TOKEN(anon_sym_staticcall);
      END_STATE();
    case 782:
      if (lookahead == 'y') ADVANCE(794);
      END_STATE();
    case 783:
      if (lookahead == 'd') ADVANCE(795);
      END_STATE();
    case 784:
      if (lookahead == 'e') ADVANCE(796);
      END_STATE();
    case 785:
      ACCEPT_TOKEN(anon_sym_constructor);
      END_STATE();
    case 786:
      if (lookahead == 'l') ADVANCE(797);
      END_STATE();
    case 787:
      ACCEPT_TOKEN(anon_sym_extcodecopy);
      END_STATE();
    case 788:
      ACCEPT_TOKEN(anon_sym_extcodehash);
      END_STATE();
    case 789:
      ACCEPT_TOKEN(anon_sym_extcodesize);
      END_STATE();
    case 790:
      if (lookahead == 'o') ADVANCE(798);
      END_STATE();
    case 791:
      if (lookahead == 'i') ADVANCE(799);
      END_STATE();
    case 792:
      ACCEPT_TOKEN(anon_sym_selfbalance);
      END_STATE();
    case 793:
      if (lookahead == 't') ADVANCE(800);
      END_STATE();
    case 794:
      ACCEPT_TOKEN(anon_sym_calldatacopy);
      END_STATE();
    case 795:
      ACCEPT_TOKEN(anon_sym_calldataload);
      END_STATE();
    case 796:
      ACCEPT_TOKEN(anon_sym_calldatasize);
      END_STATE();
    case 797:
      ACCEPT_TOKEN(anon_sym_delegatecall);
      END_STATE();
    case 798:
      if (lookahead == 'p') ADVANCE(801);
      END_STATE();
    case 799:
      if (lookahead == 'z') ADVANCE(802);
      END_STATE();
    case 800:
      ACCEPT_TOKEN(anon_sym_selfdestruct);
      END_STATE();
    case 801:
      if (lookahead == 'y') ADVANCE(803);
      END_STATE();
    case 802:
      if (lookahead == 'e') ADVANCE(804);
      END_STATE();
    case 803:
      ACCEPT_TOKEN(anon_sym_returndatacopy);
      END_STATE();
    case 804:
      ACCEPT_TOKEN(anon_sym_returndatasize);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 51},
  [2] = {.lex_state = 11},
  [3] = {.lex_state = 11},
  [4] = {.lex_state = 11},
  [5] = {.lex_state = 11},
  [6] = {.lex_state = 11},
  [7] = {.lex_state = 11},
  [8] = {.lex_state = 11},
  [9] = {.lex_state = 11},
  [10] = {.lex_state = 11},
  [11] = {.lex_state = 11},
  [12] = {.lex_state = 11},
  [13] = {.lex_state = 11},
  [14] = {.lex_state = 11},
  [15] = {.lex_state = 11},
  [16] = {.lex_state = 11},
  [17] = {.lex_state = 11},
  [18] = {.lex_state = 11},
  [19] = {.lex_state = 11},
  [20] = {.lex_state = 11},
  [21] = {.lex_state = 11},
  [22] = {.lex_state = 11},
  [23] = {.lex_state = 11},
  [24] = {.lex_state = 11},
  [25] = {.lex_state = 11},
  [26] = {.lex_state = 11},
  [27] = {.lex_state = 11},
  [28] = {.lex_state = 11},
  [29] = {.lex_state = 11},
  [30] = {.lex_state = 11},
  [31] = {.lex_state = 11},
  [32] = {.lex_state = 11},
  [33] = {.lex_state = 11},
  [34] = {.lex_state = 11},
  [35] = {.lex_state = 11},
  [36] = {.lex_state = 11},
  [37] = {.lex_state = 11},
  [38] = {.lex_state = 11},
  [39] = {.lex_state = 11},
  [40] = {.lex_state = 11},
  [41] = {.lex_state = 11},
  [42] = {.lex_state = 11},
  [43] = {.lex_state = 11},
  [44] = {.lex_state = 11},
  [45] = {.lex_state = 11},
  [46] = {.lex_state = 11},
  [47] = {.lex_state = 11},
  [48] = {.lex_state = 11},
  [49] = {.lex_state = 11},
  [50] = {.lex_state = 11},
  [51] = {.lex_state = 11},
  [52] = {.lex_state = 11},
  [53] = {.lex_state = 11},
  [54] = {.lex_state = 11},
  [55] = {.lex_state = 11},
  [56] = {.lex_state = 11},
  [57] = {.lex_state = 11},
  [58] = {.lex_state = 11},
  [59] = {.lex_state = 11},
  [60] = {.lex_state = 11},
  [61] = {.lex_state = 11},
  [62] = {.lex_state = 11},
  [63] = {.lex_state = 11},
  [64] = {.lex_state = 11},
  [65] = {.lex_state = 11},
  [66] = {.lex_state = 11},
  [67] = {.lex_state = 11},
  [68] = {.lex_state = 11},
  [69] = {.lex_state = 11},
  [70] = {.lex_state = 11},
  [71] = {.lex_state = 11},
  [72] = {.lex_state = 11},
  [73] = {.lex_state = 11},
  [74] = {.lex_state = 11},
  [75] = {.lex_state = 11},
  [76] = {.lex_state = 11},
  [77] = {.lex_state = 11},
  [78] = {.lex_state = 11},
  [79] = {.lex_state = 11},
  [80] = {.lex_state = 11},
  [81] = {.lex_state = 11},
  [82] = {.lex_state = 11},
  [83] = {.lex_state = 11},
  [84] = {.lex_state = 11},
  [85] = {.lex_state = 11},
  [86] = {.lex_state = 11},
  [87] = {.lex_state = 51},
  [88] = {.lex_state = 51},
  [89] = {.lex_state = 11},
  [90] = {.lex_state = 11},
  [91] = {.lex_state = 11},
  [92] = {.lex_state = 11},
  [93] = {.lex_state = 11},
  [94] = {.lex_state = 11},
  [95] = {.lex_state = 51},
  [96] = {.lex_state = 11},
  [97] = {.lex_state = 51},
  [98] = {.lex_state = 11},
  [99] = {.lex_state = 11},
  [100] = {.lex_state = 51},
  [101] = {.lex_state = 11},
  [102] = {.lex_state = 11},
  [103] = {.lex_state = 11},
  [104] = {.lex_state = 11},
  [105] = {.lex_state = 11},
  [106] = {.lex_state = 11},
  [107] = {.lex_state = 11},
  [108] = {.lex_state = 11},
  [109] = {.lex_state = 11},
  [110] = {.lex_state = 11},
  [111] = {.lex_state = 11},
  [112] = {.lex_state = 11},
  [113] = {.lex_state = 11},
  [114] = {.lex_state = 11},
  [115] = {.lex_state = 11},
  [116] = {.lex_state = 11},
  [117] = {.lex_state = 11},
  [118] = {.lex_state = 11},
  [119] = {.lex_state = 11},
  [120] = {.lex_state = 11},
  [121] = {.lex_state = 11},
  [122] = {.lex_state = 11},
  [123] = {.lex_state = 11},
  [124] = {.lex_state = 51},
  [125] = {.lex_state = 51},
  [126] = {.lex_state = 51},
  [127] = {.lex_state = 51},
  [128] = {.lex_state = 51},
  [129] = {.lex_state = 51},
  [130] = {.lex_state = 51},
  [131] = {.lex_state = 51},
  [132] = {.lex_state = 51},
  [133] = {.lex_state = 51},
  [134] = {.lex_state = 51},
  [135] = {.lex_state = 51},
  [136] = {.lex_state = 51},
  [137] = {.lex_state = 51},
  [138] = {.lex_state = 51},
  [139] = {.lex_state = 51},
  [140] = {.lex_state = 51},
  [141] = {.lex_state = 51},
  [142] = {.lex_state = 51},
  [143] = {.lex_state = 51},
  [144] = {.lex_state = 51},
  [145] = {.lex_state = 51},
  [146] = {.lex_state = 51},
  [147] = {.lex_state = 51},
  [148] = {.lex_state = 51},
  [149] = {.lex_state = 51},
  [150] = {.lex_state = 51},
  [151] = {.lex_state = 51},
  [152] = {.lex_state = 51},
  [153] = {.lex_state = 51},
  [154] = {.lex_state = 51},
  [155] = {.lex_state = 51},
  [156] = {.lex_state = 51},
  [157] = {.lex_state = 51},
  [158] = {.lex_state = 51},
  [159] = {.lex_state = 51},
  [160] = {.lex_state = 51},
  [161] = {.lex_state = 51},
  [162] = {.lex_state = 51},
  [163] = {.lex_state = 51},
  [164] = {.lex_state = 51},
  [165] = {.lex_state = 51},
  [166] = {.lex_state = 51},
  [167] = {.lex_state = 51},
  [168] = {.lex_state = 51},
  [169] = {.lex_state = 51},
  [170] = {.lex_state = 51},
  [171] = {.lex_state = 51},
  [172] = {.lex_state = 51},
  [173] = {.lex_state = 51},
  [174] = {.lex_state = 51},
  [175] = {.lex_state = 51},
  [176] = {.lex_state = 51},
  [177] = {.lex_state = 51},
  [178] = {.lex_state = 51},
  [179] = {.lex_state = 51},
  [180] = {.lex_state = 51},
  [181] = {.lex_state = 51},
  [182] = {.lex_state = 51},
  [183] = {.lex_state = 51},
  [184] = {.lex_state = 51},
  [185] = {.lex_state = 51},
  [186] = {.lex_state = 51},
  [187] = {.lex_state = 51},
  [188] = {.lex_state = 51},
  [189] = {.lex_state = 51},
  [190] = {.lex_state = 51},
  [191] = {.lex_state = 51},
  [192] = {.lex_state = 51},
  [193] = {.lex_state = 51},
  [194] = {.lex_state = 51},
  [195] = {.lex_state = 51},
  [196] = {.lex_state = 51},
  [197] = {.lex_state = 51},
  [198] = {.lex_state = 51},
  [199] = {.lex_state = 51},
  [200] = {.lex_state = 51},
  [201] = {.lex_state = 51},
  [202] = {.lex_state = 51},
  [203] = {.lex_state = 51},
  [204] = {.lex_state = 51},
  [205] = {.lex_state = 51},
  [206] = {.lex_state = 51},
  [207] = {.lex_state = 51},
  [208] = {.lex_state = 51},
  [209] = {.lex_state = 51},
  [210] = {.lex_state = 51},
  [211] = {.lex_state = 51},
  [212] = {.lex_state = 51},
  [213] = {.lex_state = 51},
  [214] = {.lex_state = 51},
  [215] = {.lex_state = 51},
  [216] = {.lex_state = 51},
  [217] = {.lex_state = 51},
  [218] = {.lex_state = 51},
  [219] = {.lex_state = 51},
  [220] = {.lex_state = 51},
  [221] = {.lex_state = 51},
  [222] = {.lex_state = 51},
  [223] = {.lex_state = 51},
  [224] = {.lex_state = 51},
  [225] = {.lex_state = 51},
  [226] = {.lex_state = 51},
  [227] = {.lex_state = 51},
  [228] = {.lex_state = 51},
  [229] = {.lex_state = 51},
  [230] = {.lex_state = 51},
  [231] = {.lex_state = 51},
  [232] = {.lex_state = 51},
  [233] = {.lex_state = 51},
  [234] = {.lex_state = 51},
  [235] = {.lex_state = 51},
  [236] = {.lex_state = 51},
  [237] = {.lex_state = 51},
  [238] = {.lex_state = 51},
  [239] = {.lex_state = 51},
  [240] = {.lex_state = 51},
  [241] = {.lex_state = 51},
  [242] = {.lex_state = 51},
  [243] = {.lex_state = 51},
  [244] = {.lex_state = 51},
  [245] = {.lex_state = 51},
  [246] = {.lex_state = 51},
  [247] = {.lex_state = 51},
  [248] = {.lex_state = 51},
  [249] = {.lex_state = 51},
  [250] = {.lex_state = 51},
  [251] = {.lex_state = 51},
  [252] = {.lex_state = 51},
  [253] = {.lex_state = 51},
  [254] = {.lex_state = 51},
  [255] = {.lex_state = 51},
  [256] = {.lex_state = 51},
  [257] = {.lex_state = 51},
  [258] = {.lex_state = 51},
  [259] = {.lex_state = 51},
  [260] = {.lex_state = 51},
  [261] = {.lex_state = 51},
  [262] = {.lex_state = 51},
  [263] = {.lex_state = 51},
  [264] = {.lex_state = 51},
  [265] = {.lex_state = 51},
  [266] = {.lex_state = 51},
  [267] = {.lex_state = 51},
  [268] = {.lex_state = 51},
  [269] = {.lex_state = 51},
  [270] = {.lex_state = 51},
  [271] = {.lex_state = 51},
  [272] = {.lex_state = 51},
  [273] = {.lex_state = 51},
  [274] = {.lex_state = 51},
  [275] = {.lex_state = 51},
  [276] = {.lex_state = 51},
  [277] = {.lex_state = 51},
  [278] = {.lex_state = 51},
  [279] = {.lex_state = 51},
  [280] = {.lex_state = 51},
  [281] = {.lex_state = 51},
  [282] = {.lex_state = 51},
  [283] = {.lex_state = 51},
  [284] = {.lex_state = 51},
  [285] = {.lex_state = 51},
  [286] = {.lex_state = 51},
  [287] = {.lex_state = 51},
  [288] = {.lex_state = 51},
  [289] = {.lex_state = 51},
  [290] = {.lex_state = 51},
  [291] = {.lex_state = 51},
  [292] = {.lex_state = 51},
  [293] = {.lex_state = 51},
  [294] = {.lex_state = 51},
  [295] = {.lex_state = 51},
  [296] = {.lex_state = 51},
  [297] = {.lex_state = 51},
  [298] = {.lex_state = 51},
  [299] = {.lex_state = 51},
  [300] = {.lex_state = 51},
  [301] = {.lex_state = 51},
  [302] = {.lex_state = 51},
  [303] = {.lex_state = 51},
  [304] = {.lex_state = 51},
  [305] = {.lex_state = 51},
  [306] = {.lex_state = 51},
  [307] = {.lex_state = 51},
  [308] = {.lex_state = 51},
  [309] = {.lex_state = 51},
  [310] = {.lex_state = 51},
  [311] = {.lex_state = 51},
  [312] = {.lex_state = 51},
  [313] = {.lex_state = 51},
  [314] = {.lex_state = 51},
  [315] = {.lex_state = 51},
  [316] = {.lex_state = 51},
  [317] = {.lex_state = 51},
  [318] = {.lex_state = 51},
  [319] = {.lex_state = 51},
  [320] = {.lex_state = 51},
  [321] = {.lex_state = 51},
  [322] = {.lex_state = 51},
  [323] = {.lex_state = 51},
  [324] = {.lex_state = 51},
  [325] = {.lex_state = 10},
  [326] = {.lex_state = 9},
  [327] = {.lex_state = 10},
  [328] = {.lex_state = 9},
  [329] = {.lex_state = 9},
  [330] = {.lex_state = 9},
  [331] = {.lex_state = 9},
  [332] = {.lex_state = 9},
  [333] = {.lex_state = 9},
  [334] = {.lex_state = 9},
  [335] = {.lex_state = 9},
  [336] = {.lex_state = 10},
  [337] = {.lex_state = 10},
  [338] = {.lex_state = 10},
  [339] = {.lex_state = 10},
  [340] = {.lex_state = 9},
  [341] = {.lex_state = 9},
  [342] = {.lex_state = 9},
  [343] = {.lex_state = 9},
  [344] = {.lex_state = 9},
  [345] = {.lex_state = 9},
  [346] = {.lex_state = 9},
  [347] = {.lex_state = 9},
  [348] = {.lex_state = 9},
  [349] = {.lex_state = 9},
  [350] = {.lex_state = 9},
  [351] = {.lex_state = 9},
  [352] = {.lex_state = 9},
  [353] = {.lex_state = 9},
  [354] = {.lex_state = 9},
  [355] = {.lex_state = 9},
  [356] = {.lex_state = 9},
  [357] = {.lex_state = 9},
  [358] = {.lex_state = 9},
  [359] = {.lex_state = 9},
  [360] = {.lex_state = 9},
  [361] = {.lex_state = 9},
  [362] = {.lex_state = 9},
  [363] = {.lex_state = 9},
  [364] = {.lex_state = 9},
  [365] = {.lex_state = 9},
  [366] = {.lex_state = 9},
  [367] = {.lex_state = 9},
  [368] = {.lex_state = 9},
  [369] = {.lex_state = 9},
  [370] = {.lex_state = 9},
  [371] = {.lex_state = 9},
  [372] = {.lex_state = 9},
  [373] = {.lex_state = 9},
  [374] = {.lex_state = 9},
  [375] = {.lex_state = 9},
  [376] = {.lex_state = 9},
  [377] = {.lex_state = 9},
  [378] = {.lex_state = 9},
  [379] = {.lex_state = 9},
  [380] = {.lex_state = 9},
  [381] = {.lex_state = 9},
  [382] = {.lex_state = 9},
  [383] = {.lex_state = 9},
  [384] = {.lex_state = 9},
  [385] = {.lex_state = 9},
  [386] = {.lex_state = 9},
  [387] = {.lex_state = 9},
  [388] = {.lex_state = 9},
  [389] = {.lex_state = 9},
  [390] = {.lex_state = 9},
  [391] = {.lex_state = 9},
  [392] = {.lex_state = 9},
  [393] = {.lex_state = 9},
  [394] = {.lex_state = 9},
  [395] = {.lex_state = 9},
  [396] = {.lex_state = 9},
  [397] = {.lex_state = 9},
  [398] = {.lex_state = 9},
  [399] = {.lex_state = 9},
  [400] = {.lex_state = 9},
  [401] = {.lex_state = 9},
  [402] = {.lex_state = 9},
  [403] = {.lex_state = 51},
  [404] = {.lex_state = 9},
  [405] = {.lex_state = 9},
  [406] = {.lex_state = 9},
  [407] = {.lex_state = 9},
  [408] = {.lex_state = 9},
  [409] = {.lex_state = 9},
  [410] = {.lex_state = 9},
  [411] = {.lex_state = 9},
  [412] = {.lex_state = 9},
  [413] = {.lex_state = 9},
  [414] = {.lex_state = 9},
  [415] = {.lex_state = 9},
  [416] = {.lex_state = 9},
  [417] = {.lex_state = 9},
  [418] = {.lex_state = 9},
  [419] = {.lex_state = 9},
  [420] = {.lex_state = 9},
  [421] = {.lex_state = 9},
  [422] = {.lex_state = 9},
  [423] = {.lex_state = 9},
  [424] = {.lex_state = 9},
  [425] = {.lex_state = 9},
  [426] = {.lex_state = 9},
  [427] = {.lex_state = 51},
  [428] = {.lex_state = 9},
  [429] = {.lex_state = 51},
  [430] = {.lex_state = 51},
  [431] = {.lex_state = 51},
  [432] = {.lex_state = 51},
  [433] = {.lex_state = 51},
  [434] = {.lex_state = 51},
  [435] = {.lex_state = 51},
  [436] = {.lex_state = 51},
  [437] = {.lex_state = 51},
  [438] = {.lex_state = 51},
  [439] = {.lex_state = 51},
  [440] = {.lex_state = 51},
  [441] = {.lex_state = 51},
  [442] = {.lex_state = 51},
  [443] = {.lex_state = 51},
  [444] = {.lex_state = 51},
  [445] = {.lex_state = 9},
  [446] = {.lex_state = 51},
  [447] = {.lex_state = 51},
  [448] = {.lex_state = 51},
  [449] = {.lex_state = 51},
  [450] = {.lex_state = 51},
  [451] = {.lex_state = 51},
  [452] = {.lex_state = 51},
  [453] = {.lex_state = 51},
  [454] = {.lex_state = 51},
  [455] = {.lex_state = 9},
  [456] = {.lex_state = 51},
  [457] = {.lex_state = 51},
  [458] = {.lex_state = 51},
  [459] = {.lex_state = 51},
  [460] = {.lex_state = 51},
  [461] = {.lex_state = 51},
  [462] = {.lex_state = 51},
  [463] = {.lex_state = 51},
  [464] = {.lex_state = 51},
  [465] = {.lex_state = 51},
  [466] = {.lex_state = 51},
  [467] = {.lex_state = 51},
  [468] = {.lex_state = 51},
  [469] = {.lex_state = 51},
  [470] = {.lex_state = 51},
  [471] = {.lex_state = 51},
  [472] = {.lex_state = 51},
  [473] = {.lex_state = 16},
  [474] = {.lex_state = 16},
  [475] = {.lex_state = 51},
  [476] = {.lex_state = 51},
  [477] = {.lex_state = 51},
  [478] = {.lex_state = 51},
  [479] = {.lex_state = 51},
  [480] = {.lex_state = 51},
  [481] = {.lex_state = 51},
  [482] = {.lex_state = 51},
  [483] = {.lex_state = 51},
  [484] = {.lex_state = 51},
  [485] = {.lex_state = 51},
  [486] = {.lex_state = 51},
  [487] = {.lex_state = 51},
  [488] = {.lex_state = 51},
  [489] = {.lex_state = 51},
  [490] = {.lex_state = 51},
  [491] = {.lex_state = 51},
  [492] = {.lex_state = 51},
  [493] = {.lex_state = 51},
  [494] = {.lex_state = 5},
  [495] = {.lex_state = 5},
  [496] = {.lex_state = 5},
  [497] = {.lex_state = 5},
  [498] = {.lex_state = 5},
  [499] = {.lex_state = 51},
  [500] = {.lex_state = 51},
  [501] = {.lex_state = 51},
  [502] = {.lex_state = 51},
  [503] = {.lex_state = 51},
  [504] = {.lex_state = 51},
  [505] = {.lex_state = 5},
  [506] = {.lex_state = 51},
  [507] = {.lex_state = 51},
  [508] = {.lex_state = 51},
  [509] = {.lex_state = 51},
  [510] = {.lex_state = 51},
  [511] = {.lex_state = 51},
  [512] = {.lex_state = 51},
  [513] = {.lex_state = 51},
  [514] = {.lex_state = 51},
  [515] = {.lex_state = 51},
  [516] = {.lex_state = 1},
  [517] = {.lex_state = 51},
  [518] = {.lex_state = 51},
  [519] = {.lex_state = 51},
  [520] = {.lex_state = 12},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 3},
  [523] = {.lex_state = 3},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 3},
  [526] = {.lex_state = 51},
  [527] = {.lex_state = 51},
  [528] = {.lex_state = 1},
  [529] = {.lex_state = 3},
  [530] = {.lex_state = 1},
  [531] = {.lex_state = 3},
  [532] = {.lex_state = 12},
  [533] = {.lex_state = 0},
  [534] = {.lex_state = 51},
  [535] = {.lex_state = 0},
  [536] = {.lex_state = 0},
  [537] = {.lex_state = 3},
  [538] = {.lex_state = 51},
  [539] = {.lex_state = 0},
  [540] = {.lex_state = 51},
  [541] = {.lex_state = 0},
  [542] = {.lex_state = 51},
  [543] = {.lex_state = 0},
  [544] = {.lex_state = 51},
  [545] = {.lex_state = 12},
  [546] = {.lex_state = 0},
  [547] = {.lex_state = 51},
  [548] = {.lex_state = 51},
  [549] = {.lex_state = 0},
  [550] = {.lex_state = 12},
  [551] = {.lex_state = 0},
  [552] = {.lex_state = 51},
  [553] = {.lex_state = 1},
  [554] = {.lex_state = 10},
  [555] = {.lex_state = 3},
  [556] = {.lex_state = 0},
  [557] = {.lex_state = 1},
  [558] = {.lex_state = 0},
  [559] = {.lex_state = 12},
  [560] = {.lex_state = 51},
  [561] = {.lex_state = 0},
  [562] = {.lex_state = 51},
  [563] = {.lex_state = 51},
  [564] = {.lex_state = 0},
  [565] = {.lex_state = 0},
  [566] = {.lex_state = 1},
  [567] = {.lex_state = 51},
  [568] = {.lex_state = 51},
  [569] = {.lex_state = 3},
  [570] = {.lex_state = 51},
  [571] = {.lex_state = 51},
  [572] = {.lex_state = 51},
  [573] = {.lex_state = 12},
  [574] = {.lex_state = 51},
  [575] = {.lex_state = 0},
  [576] = {.lex_state = 0},
  [577] = {.lex_state = 51},
  [578] = {.lex_state = 0},
  [579] = {.lex_state = 51},
  [580] = {.lex_state = 51},
  [581] = {.lex_state = 0},
  [582] = {.lex_state = 51},
  [583] = {.lex_state = 0},
  [584] = {.lex_state = 0},
  [585] = {.lex_state = 51},
  [586] = {.lex_state = 51},
  [587] = {.lex_state = 51},
  [588] = {.lex_state = 51},
  [589] = {.lex_state = 0},
  [590] = {.lex_state = 0},
  [591] = {.lex_state = 0},
  [592] = {.lex_state = 0},
  [593] = {.lex_state = 51},
  [594] = {.lex_state = 0},
  [595] = {.lex_state = 0},
  [596] = {.lex_state = 51},
  [597] = {.lex_state = 0},
  [598] = {.lex_state = 0},
  [599] = {.lex_state = 0},
  [600] = {.lex_state = 0},
  [601] = {.lex_state = 51},
  [602] = {.lex_state = 51},
  [603] = {.lex_state = 0},
  [604] = {.lex_state = 0},
  [605] = {.lex_state = 51},
  [606] = {.lex_state = 0},
  [607] = {.lex_state = 51},
  [608] = {.lex_state = 0},
  [609] = {.lex_state = 51},
  [610] = {.lex_state = 51},
  [611] = {.lex_state = 0},
  [612] = {.lex_state = 51},
  [613] = {.lex_state = 51},
  [614] = {.lex_state = 51},
  [615] = {.lex_state = 0},
  [616] = {.lex_state = 51},
  [617] = {.lex_state = 51},
  [618] = {.lex_state = 51},
  [619] = {.lex_state = 51},
  [620] = {.lex_state = 51},
  [621] = {.lex_state = 51},
  [622] = {.lex_state = 51},
  [623] = {.lex_state = 0},
  [624] = {.lex_state = 0},
  [625] = {.lex_state = 0},
  [626] = {.lex_state = 0},
  [627] = {.lex_state = 0},
  [628] = {.lex_state = 16},
  [629] = {.lex_state = 0},
  [630] = {.lex_state = 0},
  [631] = {.lex_state = 51},
  [632] = {.lex_state = 0},
  [633] = {.lex_state = 0},
  [634] = {.lex_state = 51},
  [635] = {.lex_state = 0},
  [636] = {.lex_state = 51},
  [637] = {.lex_state = 0},
  [638] = {.lex_state = 51},
  [639] = {.lex_state = 16},
  [640] = {.lex_state = 0},
  [641] = {.lex_state = 0},
  [642] = {.lex_state = 51},
  [643] = {.lex_state = 51},
  [644] = {.lex_state = 51},
  [645] = {.lex_state = 51},
  [646] = {.lex_state = 0},
  [647] = {.lex_state = 16},
  [648] = {.lex_state = 51},
  [649] = {.lex_state = 0},
  [650] = {.lex_state = 0},
  [651] = {.lex_state = 0},
  [652] = {.lex_state = 16},
  [653] = {.lex_state = 0},
  [654] = {.lex_state = 51},
  [655] = {.lex_state = 0},
  [656] = {.lex_state = 0},
  [657] = {.lex_state = 0},
  [658] = {.lex_state = 0},
  [659] = {.lex_state = 51},
  [660] = {.lex_state = 0},
  [661] = {.lex_state = 0},
  [662] = {.lex_state = 51},
  [663] = {.lex_state = 0},
  [664] = {.lex_state = 0},
  [665] = {.lex_state = 0},
  [666] = {.lex_state = 0},
  [667] = {.lex_state = 0},
  [668] = {.lex_state = 51},
  [669] = {.lex_state = 0},
  [670] = {.lex_state = 51},
  [671] = {.lex_state = 0},
  [672] = {.lex_state = 0},
  [673] = {.lex_state = 0},
  [674] = {.lex_state = 0},
  [675] = {.lex_state = 51},
  [676] = {.lex_state = 51},
  [677] = {.lex_state = 51},
  [678] = {.lex_state = 0},
  [679] = {.lex_state = 0},
  [680] = {.lex_state = 51},
  [681] = {.lex_state = 0},
  [682] = {.lex_state = 0},
  [683] = {.lex_state = 0},
  [684] = {.lex_state = 0},
  [685] = {.lex_state = 0},
  [686] = {.lex_state = 0},
  [687] = {.lex_state = 0},
  [688] = {.lex_state = 0},
  [689] = {.lex_state = 51},
  [690] = {.lex_state = 0},
  [691] = {.lex_state = 51},
  [692] = {.lex_state = 0},
  [693] = {.lex_state = 0},
  [694] = {.lex_state = 0},
  [695] = {.lex_state = 0},
  [696] = {.lex_state = 0},
  [697] = {.lex_state = 0},
  [698] = {.lex_state = 51},
  [699] = {.lex_state = 0},
  [700] = {.lex_state = 51},
  [701] = {.lex_state = 51},
  [702] = {.lex_state = 51},
  [703] = {.lex_state = 0},
  [704] = {.lex_state = 51},
  [705] = {.lex_state = 0},
  [706] = {.lex_state = 51},
  [707] = {.lex_state = 0},
  [708] = {.lex_state = 0},
  [709] = {.lex_state = 0},
  [710] = {.lex_state = 0},
  [711] = {.lex_state = 0},
  [712] = {.lex_state = 0},
  [713] = {.lex_state = 16},
  [714] = {.lex_state = 0},
  [715] = {.lex_state = 51},
  [716] = {.lex_state = 0},
  [717] = {.lex_state = 0},
  [718] = {.lex_state = 0},
  [719] = {.lex_state = 0},
  [720] = {.lex_state = 0},
  [721] = {.lex_state = 0},
  [722] = {.lex_state = 0},
  [723] = {.lex_state = 0},
  [724] = {.lex_state = 51},
  [725] = {.lex_state = 0},
  [726] = {.lex_state = 51},
  [727] = {.lex_state = 0},
  [728] = {.lex_state = 51},
  [729] = {.lex_state = 0},
  [730] = {.lex_state = 51},
  [731] = {.lex_state = 0},
  [732] = {.lex_state = 0},
  [733] = {.lex_state = 0},
  [734] = {.lex_state = 0},
  [735] = {.lex_state = 0},
  [736] = {.lex_state = 0},
  [737] = {.lex_state = 0},
  [738] = {.lex_state = 51},
  [739] = {.lex_state = 0},
  [740] = {.lex_state = 51},
  [741] = {.lex_state = 0},
  [742] = {.lex_state = 0},
  [743] = {.lex_state = 51},
  [744] = {.lex_state = 0},
  [745] = {.lex_state = 0},
  [746] = {.lex_state = 0},
  [747] = {.lex_state = 0},
  [748] = {.lex_state = 0},
  [749] = {.lex_state = 51},
  [750] = {.lex_state = 0},
  [751] = {.lex_state = 51},
  [752] = {.lex_state = 0},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 0},
  [755] = {.lex_state = 0},
  [756] = {.lex_state = 0},
  [757] = {.lex_state = 0},
  [758] = {.lex_state = 0},
  [759] = {.lex_state = 0},
  [760] = {.lex_state = 0},
  [761] = {.lex_state = 0},
  [762] = {.lex_state = 51},
  [763] = {.lex_state = 0},
  [764] = {.lex_state = 0},
  [765] = {.lex_state = 0},
  [766] = {.lex_state = 0},
  [767] = {.lex_state = 0},
  [768] = {.lex_state = 0},
  [769] = {.lex_state = 51},
  [770] = {.lex_state = 0},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 0},
  [773] = {.lex_state = 0},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 0},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 0},
  [778] = {.lex_state = 0},
  [779] = {.lex_state = 0},
  [780] = {.lex_state = 0},
  [781] = {.lex_state = 0},
  [782] = {.lex_state = 51},
  [783] = {.lex_state = 51},
  [784] = {.lex_state = 0},
  [785] = {.lex_state = 0},
  [786] = {.lex_state = 0},
  [787] = {.lex_state = 0},
  [788] = {.lex_state = 51},
  [789] = {.lex_state = 51},
  [790] = {.lex_state = 0},
  [791] = {.lex_state = 51},
  [792] = {.lex_state = 23},
  [793] = {.lex_state = 0},
  [794] = {.lex_state = 0},
  [795] = {.lex_state = 51},
  [796] = {.lex_state = 0},
  [797] = {.lex_state = 12},
  [798] = {.lex_state = 12},
  [799] = {.lex_state = 0},
  [800] = {.lex_state = 0},
  [801] = {.lex_state = 51},
  [802] = {.lex_state = 0},
  [803] = {.lex_state = 51},
  [804] = {.lex_state = 0},
  [805] = {.lex_state = 0},
  [806] = {.lex_state = 51},
  [807] = {.lex_state = 11},
  [808] = {.lex_state = 51},
  [809] = {.lex_state = 0},
  [810] = {.lex_state = 5},
  [811] = {.lex_state = 51},
  [812] = {.lex_state = 51},
  [813] = {.lex_state = 51},
  [814] = {.lex_state = 0},
  [815] = {.lex_state = 0},
  [816] = {.lex_state = 11},
  [817] = {.lex_state = 51},
  [818] = {.lex_state = 51},
  [819] = {.lex_state = 51},
  [820] = {.lex_state = 51},
  [821] = {.lex_state = 51},
  [822] = {.lex_state = 0},
  [823] = {.lex_state = 51},
  [824] = {.lex_state = 0},
  [825] = {.lex_state = 51},
  [826] = {.lex_state = 51},
  [827] = {.lex_state = 51},
  [828] = {.lex_state = 51},
  [829] = {.lex_state = 51},
  [830] = {.lex_state = 5},
  [831] = {.lex_state = 51},
  [832] = {.lex_state = 0},
  [833] = {.lex_state = 0},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 11},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 51},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 0},
  [841] = {.lex_state = 51},
  [842] = {.lex_state = 51},
  [843] = {.lex_state = 51},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 51},
  [846] = {.lex_state = 51},
  [847] = {.lex_state = 51},
  [848] = {.lex_state = 51},
  [849] = {.lex_state = 0},
  [850] = {.lex_state = 0},
  [851] = {.lex_state = 51},
  [852] = {.lex_state = 51},
  [853] = {.lex_state = 0},
  [854] = {.lex_state = 12},
  [855] = {.lex_state = 0},
  [856] = {.lex_state = 51},
  [857] = {.lex_state = 51},
  [858] = {.lex_state = 0},
  [859] = {.lex_state = 0},
  [860] = {.lex_state = 51},
  [861] = {.lex_state = 51},
  [862] = {.lex_state = 51},
  [863] = {.lex_state = 51},
  [864] = {.lex_state = 0},
  [865] = {.lex_state = 51},
  [866] = {.lex_state = 51},
  [867] = {.lex_state = 51},
  [868] = {.lex_state = 0},
  [869] = {.lex_state = 51},
  [870] = {.lex_state = 51},
  [871] = {.lex_state = 0},
  [872] = {.lex_state = 51},
  [873] = {.lex_state = 51},
  [874] = {.lex_state = 0},
  [875] = {.lex_state = 0},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 0},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 51},
  [880] = {.lex_state = 51},
  [881] = {.lex_state = 51},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_pragma] = ACTIONS(1),
    [anon_sym_PIPE_PIPE] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_solidity] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_TILDE] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_from] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_type] = ACTIONS(1),
    [anon_sym_is] = ACTIONS(1),
    [anon_sym_constant] = ACTIONS(1),
    [anon_sym_abstract] = ACTIONS(1),
    [anon_sym_contract] = ACTIONS(1),
    [anon_sym_error] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_interface] = ACTIONS(1),
    [anon_sym_library] = ACTIONS(1),
    [anon_sym_struct] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_event] = ACTIONS(1),
    [anon_sym_anonymous] = ACTIONS(1),
    [anon_sym_indexed] = ACTIONS(1),
    [anon_sym_using] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_assembly] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [sym_yul_leave] = ACTIONS(1),
    [anon_sym_break] = ACTIONS(1),
    [anon_sym_continue] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [sym_yul_decimal_number] = ACTIONS(1),
    [sym_yul_hex_number] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_switch] = ACTIONS(1),
    [anon_sym_default] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_function] = ACTIONS(1),
    [anon_sym_stop] = ACTIONS(1),
    [anon_sym_add] = ACTIONS(1),
    [anon_sym_sub] = ACTIONS(1),
    [anon_sym_mul] = ACTIONS(1),
    [anon_sym_div] = ACTIONS(1),
    [anon_sym_sdiv] = ACTIONS(1),
    [anon_sym_mod] = ACTIONS(1),
    [anon_sym_smod] = ACTIONS(1),
    [anon_sym_exp] = ACTIONS(1),
    [anon_sym_not] = ACTIONS(1),
    [anon_sym_lt] = ACTIONS(1),
    [anon_sym_gt] = ACTIONS(1),
    [anon_sym_slt] = ACTIONS(1),
    [anon_sym_sgt] = ACTIONS(1),
    [anon_sym_eq] = ACTIONS(1),
    [anon_sym_iszero] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_xor] = ACTIONS(1),
    [anon_sym_byte] = ACTIONS(1),
    [anon_sym_shl] = ACTIONS(1),
    [anon_sym_shr] = ACTIONS(1),
    [anon_sym_sar] = ACTIONS(1),
    [anon_sym_addmod] = ACTIONS(1),
    [anon_sym_mulmod] = ACTIONS(1),
    [anon_sym_signextend] = ACTIONS(1),
    [anon_sym_keccak256] = ACTIONS(1),
    [anon_sym_pop] = ACTIONS(1),
    [anon_sym_mload] = ACTIONS(1),
    [anon_sym_mcopy] = ACTIONS(1),
    [anon_sym_tload] = ACTIONS(1),
    [anon_sym_tstore] = ACTIONS(1),
    [anon_sym_mstore] = ACTIONS(1),
    [anon_sym_mstore8] = ACTIONS(1),
    [anon_sym_sload] = ACTIONS(1),
    [anon_sym_sstore] = ACTIONS(1),
    [anon_sym_msize] = ACTIONS(1),
    [anon_sym_gas] = ACTIONS(1),
    [anon_sym_address] = ACTIONS(1),
    [anon_sym_balance] = ACTIONS(1),
    [anon_sym_selfbalance] = ACTIONS(1),
    [anon_sym_caller] = ACTIONS(1),
    [anon_sym_callvalue] = ACTIONS(1),
    [anon_sym_calldataload] = ACTIONS(1),
    [anon_sym_calldatasize] = ACTIONS(1),
    [anon_sym_calldatacopy] = ACTIONS(1),
    [anon_sym_extcodesize] = ACTIONS(1),
    [anon_sym_extcodecopy] = ACTIONS(1),
    [anon_sym_returndatasize] = ACTIONS(1),
    [anon_sym_returndatacopy] = ACTIONS(1),
    [anon_sym_extcodehash] = ACTIONS(1),
    [anon_sym_create] = ACTIONS(1),
    [anon_sym_create2] = ACTIONS(1),
    [anon_sym_call] = ACTIONS(1),
    [anon_sym_callcode] = ACTIONS(1),
    [anon_sym_delegatecall] = ACTIONS(1),
    [anon_sym_staticcall] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_revert] = ACTIONS(1),
    [anon_sym_selfdestruct] = ACTIONS(1),
    [anon_sym_invalid] = ACTIONS(1),
    [anon_sym_log0] = ACTIONS(1),
    [anon_sym_log1] = ACTIONS(1),
    [anon_sym_log2] = ACTIONS(1),
    [anon_sym_log3] = ACTIONS(1),
    [anon_sym_log4] = ACTIONS(1),
    [anon_sym_chainid] = ACTIONS(1),
    [anon_sym_origin] = ACTIONS(1),
    [anon_sym_gasprice] = ACTIONS(1),
    [anon_sym_blockhash] = ACTIONS(1),
    [anon_sym_blobhash] = ACTIONS(1),
    [anon_sym_basefee] = ACTIONS(1),
    [anon_sym_blobfee] = ACTIONS(1),
    [anon_sym_coinbase] = ACTIONS(1),
    [anon_sym_timestamp] = ACTIONS(1),
    [anon_sym_number] = ACTIONS(1),
    [anon_sym_difficulty] = ACTIONS(1),
    [anon_sym_gaslimit] = ACTIONS(1),
    [sym_unchecked] = ACTIONS(1),
    [anon_sym_memory] = ACTIONS(1),
    [anon_sym_storage] = ACTIONS(1),
    [anon_sym_calldata] = ACTIONS(1),
    [anon_sym_var] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_do] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_returns] = ACTIONS(1),
    [anon_sym_catch] = ACTIONS(1),
    [anon_sym_emit] = ACTIONS(1),
    [anon_sym_public] = ACTIONS(1),
    [anon_sym_internal] = ACTIONS(1),
    [anon_sym_private] = ACTIONS(1),
    [anon_sym_external] = ACTIONS(1),
    [anon_sym_pure] = ACTIONS(1),
    [anon_sym_view] = ACTIONS(1),
    [anon_sym_payable] = ACTIONS(1),
    [anon_sym_transient] = ACTIONS(1),
    [sym_immutable] = ACTIONS(1),
    [anon_sym_override] = ACTIONS(1),
    [anon_sym_modifier] = ACTIONS(1),
    [anon_sym_constructor] = ACTIONS(1),
    [anon_sym_fallback] = ACTIONS(1),
    [anon_sym_receive] = ACTIONS(1),
    [sym_virtual] = ACTIONS(1),
    [anon_sym_QMARK] = ACTIONS(1),
    [anon_sym_new] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_AMP_AMP] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_delete] = ACTIONS(1),
    [anon_sym_BANG] = ACTIONS(1),
    [anon_sym_PLUS_PLUS] = ACTIONS(1),
    [anon_sym_DASH_DASH] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_mapping] = ACTIONS(1),
    [anon_sym_EQ_GT] = ACTIONS(1),
    [anon_sym_bool] = ACTIONS(1),
    [anon_sym_string] = ACTIONS(1),
    [anon_sym_int] = ACTIONS(1),
    [anon_sym_int8] = ACTIONS(1),
    [anon_sym_int16] = ACTIONS(1),
    [anon_sym_int24] = ACTIONS(1),
    [anon_sym_int32] = ACTIONS(1),
    [anon_sym_int40] = ACTIONS(1),
    [anon_sym_int48] = ACTIONS(1),
    [anon_sym_int56] = ACTIONS(1),
    [anon_sym_int64] = ACTIONS(1),
    [anon_sym_int72] = ACTIONS(1),
    [anon_sym_int80] = ACTIONS(1),
    [anon_sym_int88] = ACTIONS(1),
    [anon_sym_int96] = ACTIONS(1),
    [anon_sym_int104] = ACTIONS(1),
    [anon_sym_int112] = ACTIONS(1),
    [anon_sym_int120] = ACTIONS(1),
    [anon_sym_int128] = ACTIONS(1),
    [anon_sym_int136] = ACTIONS(1),
    [anon_sym_int144] = ACTIONS(1),
    [anon_sym_int152] = ACTIONS(1),
    [anon_sym_int160] = ACTIONS(1),
    [anon_sym_int168] = ACTIONS(1),
    [anon_sym_int176] = ACTIONS(1),
    [anon_sym_int184] = ACTIONS(1),
    [anon_sym_int192] = ACTIONS(1),
    [anon_sym_int200] = ACTIONS(1),
    [anon_sym_int208] = ACTIONS(1),
    [anon_sym_int216] = ACTIONS(1),
    [anon_sym_int224] = ACTIONS(1),
    [anon_sym_int232] = ACTIONS(1),
    [anon_sym_int240] = ACTIONS(1),
    [anon_sym_int248] = ACTIONS(1),
    [anon_sym_int256] = ACTIONS(1),
    [anon_sym_uint] = ACTIONS(1),
    [anon_sym_uint8] = ACTIONS(1),
    [anon_sym_uint16] = ACTIONS(1),
    [anon_sym_uint24] = ACTIONS(1),
    [anon_sym_uint32] = ACTIONS(1),
    [anon_sym_uint40] = ACTIONS(1),
    [anon_sym_uint48] = ACTIONS(1),
    [anon_sym_uint56] = ACTIONS(1),
    [anon_sym_uint64] = ACTIONS(1),
    [anon_sym_uint72] = ACTIONS(1),
    [anon_sym_uint80] = ACTIONS(1),
    [anon_sym_uint88] = ACTIONS(1),
    [anon_sym_uint96] = ACTIONS(1),
    [anon_sym_uint104] = ACTIONS(1),
    [anon_sym_uint112] = ACTIONS(1),
    [anon_sym_uint120] = ACTIONS(1),
    [anon_sym_uint128] = ACTIONS(1),
    [anon_sym_uint136] = ACTIONS(1),
    [anon_sym_uint144] = ACTIONS(1),
    [anon_sym_uint152] = ACTIONS(1),
    [anon_sym_uint160] = ACTIONS(1),
    [anon_sym_uint168] = ACTIONS(1),
    [anon_sym_uint176] = ACTIONS(1),
    [anon_sym_uint184] = ACTIONS(1),
    [anon_sym_uint192] = ACTIONS(1),
    [anon_sym_uint200] = ACTIONS(1),
    [anon_sym_uint208] = ACTIONS(1),
    [anon_sym_uint216] = ACTIONS(1),
    [anon_sym_uint224] = ACTIONS(1),
    [anon_sym_uint232] = ACTIONS(1),
    [anon_sym_uint240] = ACTIONS(1),
    [anon_sym_uint248] = ACTIONS(1),
    [anon_sym_uint256] = ACTIONS(1),
    [anon_sym_bytes] = ACTIONS(1),
    [anon_sym_bytes1] = ACTIONS(1),
    [anon_sym_bytes2] = ACTIONS(1),
    [anon_sym_bytes3] = ACTIONS(1),
    [anon_sym_bytes4] = ACTIONS(1),
    [anon_sym_bytes5] = ACTIONS(1),
    [anon_sym_bytes6] = ACTIONS(1),
    [anon_sym_bytes7] = ACTIONS(1),
    [anon_sym_bytes8] = ACTIONS(1),
    [anon_sym_bytes9] = ACTIONS(1),
    [anon_sym_bytes10] = ACTIONS(1),
    [anon_sym_bytes11] = ACTIONS(1),
    [anon_sym_bytes12] = ACTIONS(1),
    [anon_sym_bytes13] = ACTIONS(1),
    [anon_sym_bytes14] = ACTIONS(1),
    [anon_sym_bytes15] = ACTIONS(1),
    [anon_sym_bytes16] = ACTIONS(1),
    [anon_sym_bytes17] = ACTIONS(1),
    [anon_sym_bytes18] = ACTIONS(1),
    [anon_sym_bytes19] = ACTIONS(1),
    [anon_sym_bytes20] = ACTIONS(1),
    [anon_sym_bytes21] = ACTIONS(1),
    [anon_sym_bytes22] = ACTIONS(1),
    [anon_sym_bytes23] = ACTIONS(1),
    [anon_sym_bytes24] = ACTIONS(1),
    [anon_sym_bytes25] = ACTIONS(1),
    [anon_sym_bytes26] = ACTIONS(1),
    [anon_sym_bytes27] = ACTIONS(1),
    [anon_sym_bytes28] = ACTIONS(1),
    [anon_sym_bytes29] = ACTIONS(1),
    [anon_sym_bytes30] = ACTIONS(1),
    [anon_sym_bytes31] = ACTIONS(1),
    [anon_sym_bytes32] = ACTIONS(1),
    [anon_sym_fixed] = ACTIONS(1),
    [aux_sym__fixed_token1] = ACTIONS(1),
    [anon_sym_ufixed] = ACTIONS(1),
    [aux_sym__ufixed_token1] = ACTIONS(1),
    [anon_sym_SEMI] = ACTIONS(1),
    [anon_sym_wei] = ACTIONS(1),
    [anon_sym_szabo] = ACTIONS(1),
    [anon_sym_finney] = ACTIONS(1),
    [anon_sym_gwei] = ACTIONS(1),
    [anon_sym_ether] = ACTIONS(1),
    [anon_sym_seconds] = ACTIONS(1),
    [anon_sym_minutes] = ACTIONS(1),
    [anon_sym_hours] = ACTIONS(1),
    [anon_sym_days] = ACTIONS(1),
    [anon_sym_weeks] = ACTIONS(1),
    [anon_sym_years] = ACTIONS(1),
    [anon_sym_hex] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym__] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [sym__escape_sequence] = ACTIONS(1),
    [anon_sym_unicode] = ACTIONS(1),
    [sym_comment] = ACTIONS(3),
  },
  [1] = {
    [sym_source_file] = STATE(839),
    [sym__source_unit] = STATE(88),
    [sym__directive] = STATE(88),
    [sym_pragma_directive] = STATE(88),
    [sym_import_directive] = STATE(88),
    [sym__declaration] = STATE(88),
    [sym_user_defined_type_definition] = STATE(88),
    [sym_constant_variable_declaration] = STATE(88),
    [sym_contract_declaration] = STATE(88),
    [sym_error_declaration] = STATE(88),
    [sym_interface_declaration] = STATE(88),
    [sym_library_declaration] = STATE(88),
    [sym_struct_declaration] = STATE(88),
    [sym_enum_declaration] = STATE(88),
    [sym_event_definition] = STATE(88),
    [sym_function_definition] = STATE(88),
    [sym_type_name] = STATE(789),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(345),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(345),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [aux_sym_source_file_repeat1] = STATE(88),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_pragma] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_abstract] = ACTIONS(15),
    [anon_sym_contract] = ACTIONS(17),
    [anon_sym_error] = ACTIONS(19),
    [anon_sym_interface] = ACTIONS(21),
    [anon_sym_library] = ACTIONS(23),
    [anon_sym_struct] = ACTIONS(25),
    [anon_sym_enum] = ACTIONS(27),
    [anon_sym_event] = ACTIONS(29),
    [anon_sym_function] = ACTIONS(31),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
  },
  [2] = {
    [sym_statement] = STATE(6),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_struct_field_assignment] = STATE(625),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(6),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(39),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(47),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [3] = {
    [sym_statement] = STATE(7),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(7),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(107),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [4] = {
    [sym_statement] = STATE(8),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(8),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(109),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [5] = {
    [sym_statement] = STATE(6),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(6),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(111),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [6] = {
    [sym_statement] = STATE(7),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(7),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(113),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [7] = {
    [sym_statement] = STATE(7),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(7),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(115),
    [anon_sym_DASH] = ACTIONS(118),
    [anon_sym_TILDE] = ACTIONS(121),
    [anon_sym_LBRACE] = ACTIONS(124),
    [anon_sym_RBRACE] = ACTIONS(127),
    [anon_sym_type] = ACTIONS(129),
    [anon_sym_LPAREN] = ACTIONS(132),
    [anon_sym_for] = ACTIONS(135),
    [anon_sym_assembly] = ACTIONS(138),
    [anon_sym_break] = ACTIONS(141),
    [anon_sym_continue] = ACTIONS(144),
    [anon_sym_true] = ACTIONS(147),
    [anon_sym_false] = ACTIONS(150),
    [anon_sym_if] = ACTIONS(153),
    [anon_sym_function] = ACTIONS(156),
    [anon_sym_byte] = ACTIONS(159),
    [anon_sym_address] = ACTIONS(162),
    [anon_sym_return] = ACTIONS(165),
    [anon_sym_revert] = ACTIONS(168),
    [sym_unchecked] = ACTIONS(171),
    [anon_sym_var] = ACTIONS(174),
    [anon_sym_while] = ACTIONS(177),
    [anon_sym_do] = ACTIONS(180),
    [anon_sym_try] = ACTIONS(183),
    [anon_sym_emit] = ACTIONS(186),
    [anon_sym_payable] = ACTIONS(189),
    [anon_sym_new] = ACTIONS(192),
    [anon_sym_LBRACK] = ACTIONS(195),
    [anon_sym_delete] = ACTIONS(118),
    [anon_sym_BANG] = ACTIONS(121),
    [anon_sym_PLUS_PLUS] = ACTIONS(198),
    [anon_sym_DASH_DASH] = ACTIONS(198),
    [anon_sym_mapping] = ACTIONS(201),
    [anon_sym_bool] = ACTIONS(159),
    [anon_sym_string] = ACTIONS(159),
    [anon_sym_int] = ACTIONS(159),
    [anon_sym_int8] = ACTIONS(159),
    [anon_sym_int16] = ACTIONS(159),
    [anon_sym_int24] = ACTIONS(159),
    [anon_sym_int32] = ACTIONS(159),
    [anon_sym_int40] = ACTIONS(159),
    [anon_sym_int48] = ACTIONS(159),
    [anon_sym_int56] = ACTIONS(159),
    [anon_sym_int64] = ACTIONS(159),
    [anon_sym_int72] = ACTIONS(159),
    [anon_sym_int80] = ACTIONS(159),
    [anon_sym_int88] = ACTIONS(159),
    [anon_sym_int96] = ACTIONS(159),
    [anon_sym_int104] = ACTIONS(159),
    [anon_sym_int112] = ACTIONS(159),
    [anon_sym_int120] = ACTIONS(159),
    [anon_sym_int128] = ACTIONS(159),
    [anon_sym_int136] = ACTIONS(159),
    [anon_sym_int144] = ACTIONS(159),
    [anon_sym_int152] = ACTIONS(159),
    [anon_sym_int160] = ACTIONS(159),
    [anon_sym_int168] = ACTIONS(159),
    [anon_sym_int176] = ACTIONS(159),
    [anon_sym_int184] = ACTIONS(159),
    [anon_sym_int192] = ACTIONS(159),
    [anon_sym_int200] = ACTIONS(159),
    [anon_sym_int208] = ACTIONS(159),
    [anon_sym_int216] = ACTIONS(159),
    [anon_sym_int224] = ACTIONS(159),
    [anon_sym_int232] = ACTIONS(159),
    [anon_sym_int240] = ACTIONS(159),
    [anon_sym_int248] = ACTIONS(159),
    [anon_sym_int256] = ACTIONS(159),
    [anon_sym_uint] = ACTIONS(159),
    [anon_sym_uint8] = ACTIONS(159),
    [anon_sym_uint16] = ACTIONS(159),
    [anon_sym_uint24] = ACTIONS(159),
    [anon_sym_uint32] = ACTIONS(159),
    [anon_sym_uint40] = ACTIONS(159),
    [anon_sym_uint48] = ACTIONS(159),
    [anon_sym_uint56] = ACTIONS(159),
    [anon_sym_uint64] = ACTIONS(159),
    [anon_sym_uint72] = ACTIONS(159),
    [anon_sym_uint80] = ACTIONS(159),
    [anon_sym_uint88] = ACTIONS(159),
    [anon_sym_uint96] = ACTIONS(159),
    [anon_sym_uint104] = ACTIONS(159),
    [anon_sym_uint112] = ACTIONS(159),
    [anon_sym_uint120] = ACTIONS(159),
    [anon_sym_uint128] = ACTIONS(159),
    [anon_sym_uint136] = ACTIONS(159),
    [anon_sym_uint144] = ACTIONS(159),
    [anon_sym_uint152] = ACTIONS(159),
    [anon_sym_uint160] = ACTIONS(159),
    [anon_sym_uint168] = ACTIONS(159),
    [anon_sym_uint176] = ACTIONS(159),
    [anon_sym_uint184] = ACTIONS(159),
    [anon_sym_uint192] = ACTIONS(159),
    [anon_sym_uint200] = ACTIONS(159),
    [anon_sym_uint208] = ACTIONS(159),
    [anon_sym_uint216] = ACTIONS(159),
    [anon_sym_uint224] = ACTIONS(159),
    [anon_sym_uint232] = ACTIONS(159),
    [anon_sym_uint240] = ACTIONS(159),
    [anon_sym_uint248] = ACTIONS(159),
    [anon_sym_uint256] = ACTIONS(159),
    [anon_sym_bytes] = ACTIONS(159),
    [anon_sym_bytes1] = ACTIONS(159),
    [anon_sym_bytes2] = ACTIONS(159),
    [anon_sym_bytes3] = ACTIONS(159),
    [anon_sym_bytes4] = ACTIONS(159),
    [anon_sym_bytes5] = ACTIONS(159),
    [anon_sym_bytes6] = ACTIONS(159),
    [anon_sym_bytes7] = ACTIONS(159),
    [anon_sym_bytes8] = ACTIONS(159),
    [anon_sym_bytes9] = ACTIONS(159),
    [anon_sym_bytes10] = ACTIONS(159),
    [anon_sym_bytes11] = ACTIONS(159),
    [anon_sym_bytes12] = ACTIONS(159),
    [anon_sym_bytes13] = ACTIONS(159),
    [anon_sym_bytes14] = ACTIONS(159),
    [anon_sym_bytes15] = ACTIONS(159),
    [anon_sym_bytes16] = ACTIONS(159),
    [anon_sym_bytes17] = ACTIONS(159),
    [anon_sym_bytes18] = ACTIONS(159),
    [anon_sym_bytes19] = ACTIONS(159),
    [anon_sym_bytes20] = ACTIONS(159),
    [anon_sym_bytes21] = ACTIONS(159),
    [anon_sym_bytes22] = ACTIONS(159),
    [anon_sym_bytes23] = ACTIONS(159),
    [anon_sym_bytes24] = ACTIONS(159),
    [anon_sym_bytes25] = ACTIONS(159),
    [anon_sym_bytes26] = ACTIONS(159),
    [anon_sym_bytes27] = ACTIONS(159),
    [anon_sym_bytes28] = ACTIONS(159),
    [anon_sym_bytes29] = ACTIONS(159),
    [anon_sym_bytes30] = ACTIONS(159),
    [anon_sym_bytes31] = ACTIONS(159),
    [anon_sym_bytes32] = ACTIONS(159),
    [anon_sym_fixed] = ACTIONS(159),
    [aux_sym__fixed_token1] = ACTIONS(159),
    [anon_sym_ufixed] = ACTIONS(159),
    [aux_sym__ufixed_token1] = ACTIONS(159),
    [aux_sym__decimal_number_token1] = ACTIONS(204),
    [aux_sym__decimal_number_token2] = ACTIONS(207),
    [aux_sym__hex_number_token1] = ACTIONS(207),
    [anon_sym_hex] = ACTIONS(210),
    [anon_sym_DQUOTE] = ACTIONS(213),
    [anon_sym_SQUOTE] = ACTIONS(216),
    [anon_sym_unicode] = ACTIONS(219),
    [sym_comment] = ACTIONS(3),
  },
  [8] = {
    [sym_statement] = STATE(7),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(7),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(222),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [9] = {
    [sym_statement] = STATE(10),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(10),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(113),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [10] = {
    [sym_statement] = STATE(7),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(7),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(224),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [11] = {
    [sym_statement] = STATE(3),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_block_statement_repeat1] = STATE(3),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_RBRACE] = ACTIONS(226),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [12] = {
    [sym_statement] = STATE(879),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(670),
    [sym_variable_declaration_tuple] = STATE(867),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(446),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(228),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(230),
    [anon_sym_continue] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(236),
    [anon_sym_revert] = ACTIONS(238),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(240),
    [anon_sym_do] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(244),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [13] = {
    [sym_statement] = STATE(826),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(670),
    [sym_variable_declaration_tuple] = STATE(867),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(446),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(228),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(230),
    [anon_sym_continue] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(236),
    [anon_sym_revert] = ACTIONS(238),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(240),
    [anon_sym_do] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(244),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [14] = {
    [sym_statement] = STATE(114),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [15] = {
    [sym_statement] = STATE(116),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [16] = {
    [sym_statement] = STATE(118),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [17] = {
    [sym_statement] = STATE(115),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [18] = {
    [sym_statement] = STATE(795),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(670),
    [sym_variable_declaration_tuple] = STATE(867),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(446),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(228),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(230),
    [anon_sym_continue] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(236),
    [anon_sym_revert] = ACTIONS(238),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(240),
    [anon_sym_do] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(244),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [19] = {
    [sym_statement] = STATE(119),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(53),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(57),
    [anon_sym_continue] = ACTIONS(59),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(65),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(69),
    [anon_sym_revert] = ACTIONS(71),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(77),
    [anon_sym_do] = ACTIONS(79),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(83),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [20] = {
    [sym_statement] = STATE(115),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(670),
    [sym_variable_declaration_tuple] = STATE(867),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(446),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(228),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(230),
    [anon_sym_continue] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(236),
    [anon_sym_revert] = ACTIONS(238),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(240),
    [anon_sym_do] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(244),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [21] = {
    [sym_statement] = STATE(118),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(670),
    [sym_variable_declaration_tuple] = STATE(867),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(446),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(228),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(230),
    [anon_sym_continue] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(236),
    [anon_sym_revert] = ACTIONS(238),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(240),
    [anon_sym_do] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(244),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [22] = {
    [sym_statement] = STATE(116),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(670),
    [sym_variable_declaration_tuple] = STATE(867),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(446),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(228),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(230),
    [anon_sym_continue] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(236),
    [anon_sym_revert] = ACTIONS(238),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(240),
    [anon_sym_do] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(244),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [23] = {
    [sym_statement] = STATE(119),
    [sym_assembly_statement] = STATE(109),
    [sym_block_statement] = STATE(109),
    [sym_variable_declaration_statement] = STATE(109),
    [sym_variable_declaration] = STATE(670),
    [sym_variable_declaration_tuple] = STATE(867),
    [sym_expression_statement] = STATE(109),
    [sym_if_statement] = STATE(109),
    [sym_for_statement] = STATE(109),
    [sym_while_statement] = STATE(109),
    [sym_do_while_statement] = STATE(109),
    [sym_continue_statement] = STATE(109),
    [sym_break_statement] = STATE(109),
    [sym_revert_statement] = STATE(109),
    [sym_try_statement] = STATE(109),
    [sym_return_statement] = STATE(109),
    [sym_emit_statement] = STATE(109),
    [sym_expression] = STATE(446),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(45),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_for] = ACTIONS(228),
    [anon_sym_assembly] = ACTIONS(55),
    [anon_sym_break] = ACTIONS(230),
    [anon_sym_continue] = ACTIONS(232),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_if] = ACTIONS(234),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(236),
    [anon_sym_revert] = ACTIONS(238),
    [sym_unchecked] = ACTIONS(73),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_while] = ACTIONS(240),
    [anon_sym_do] = ACTIONS(242),
    [anon_sym_try] = ACTIONS(81),
    [anon_sym_emit] = ACTIONS(244),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [24] = {
    [sym_variable_declaration_statement] = STATE(34),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(34),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__semicolon] = STATE(34),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(246),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [25] = {
    [sym_variable_declaration_statement] = STATE(36),
    [sym_variable_declaration] = STATE(580),
    [sym_variable_declaration_tuple] = STATE(856),
    [sym_expression_statement] = STATE(36),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__semicolon] = STATE(36),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(51),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(75),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(248),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [26] = {
    [sym_variable_declaration] = STATE(666),
    [sym_expression] = STATE(430),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_variable_declaration_tuple_repeat1] = STATE(667),
    [aux_sym_tuple_expression_repeat1] = STATE(679),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(250),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(254),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [27] = {
    [sym_variable_declaration] = STATE(773),
    [sym_expression] = STATE(443),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_type_name] = STATE(526),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(427),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(403),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(256),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(259),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_function] = ACTIONS(67),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [28] = {
    [sym_call_argument] = STATE(604),
    [sym_expression] = STATE(433),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_tuple_expression_repeat1] = STATE(679),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_COMMA] = ACTIONS(263),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(265),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [29] = {
    [sym__call_arguments] = STATE(763),
    [sym_expression] = STATE(449),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__semicolon] = STATE(105),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(267),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(269),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [30] = {
    [sym_call_argument] = STATE(761),
    [sym_expression] = STATE(444),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(271),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [31] = {
    [sym_expression] = STATE(430),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_tuple_expression_repeat1] = STATE(679),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(263),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(273),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [32] = {
    [sym__call_arguments] = STATE(766),
    [sym_expression] = STATE(450),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__semicolon] = STATE(105),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(267),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(269),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [33] = {
    [sym_call_argument] = STATE(761),
    [sym_expression] = STATE(444),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(275),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [34] = {
    [sym_expression_statement] = STATE(49),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__semicolon] = STATE(49),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(277),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [35] = {
    [sym_call_argument] = STATE(604),
    [sym_expression] = STATE(444),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(279),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [36] = {
    [sym_expression_statement] = STATE(52),
    [sym_expression] = STATE(439),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__semicolon] = STATE(52),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(281),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [37] = {
    [sym_call_argument] = STATE(761),
    [sym_expression] = STATE(444),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_LBRACE] = ACTIONS(261),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [38] = {
    [sym_expression] = STATE(445),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_COLON] = ACTIONS(283),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(285),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [39] = {
    [sym_expression] = STATE(447),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__semicolon] = STATE(123),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(287),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [40] = {
    [sym_expression] = STATE(443),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(291),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [41] = {
    [sym_expression] = STATE(448),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__semicolon] = STATE(123),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [anon_sym_SEMI] = ACTIONS(287),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [42] = {
    [sym_expression] = STATE(443),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(293),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [43] = {
    [sym_expression] = STATE(443),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(289),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [44] = {
    [sym_expression] = STATE(443),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_COMMA] = ACTIONS(289),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(295),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [45] = {
    [sym_expression] = STATE(460),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(297),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [46] = {
    [sym_expression] = STATE(461),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(299),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [47] = {
    [sym_expression] = STATE(432),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(301),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [48] = {
    [sym_expression] = STATE(451),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(303),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [49] = {
    [sym_expression] = STATE(454),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(305),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [50] = {
    [sym_expression] = STATE(451),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(307),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [51] = {
    [sym_expression] = STATE(459),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(309),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [52] = {
    [sym_expression] = STATE(466),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_RPAREN] = ACTIONS(311),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [53] = {
    [sym_expression] = STATE(437),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [54] = {
    [sym_expression] = STATE(467),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [55] = {
    [sym_expression] = STATE(431),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [56] = {
    [sym_expression] = STATE(471),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [57] = {
    [sym_expression] = STATE(388),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [58] = {
    [sym_expression] = STATE(436),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [59] = {
    [sym_expression] = STATE(393),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [60] = {
    [sym_expression] = STATE(453),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [61] = {
    [sym_expression] = STATE(452),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [62] = {
    [sym_expression] = STATE(434),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [63] = {
    [sym_expression] = STATE(380),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [64] = {
    [sym_expression] = STATE(438),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [65] = {
    [sym_expression] = STATE(441),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [66] = {
    [sym_expression] = STATE(451),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [67] = {
    [sym_expression] = STATE(442),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [68] = {
    [sym_expression] = STATE(457),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [69] = {
    [sym_expression] = STATE(392),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [70] = {
    [sym_expression] = STATE(372),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [71] = {
    [sym_expression] = STATE(373),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [72] = {
    [sym_expression] = STATE(374),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [73] = {
    [sym_expression] = STATE(375),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [74] = {
    [sym_expression] = STATE(376),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [75] = {
    [sym_expression] = STATE(455),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [76] = {
    [sym_expression] = STATE(381),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [77] = {
    [sym_expression] = STATE(382),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [78] = {
    [sym_expression] = STATE(385),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [79] = {
    [sym_expression] = STATE(386),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [80] = {
    [sym_expression] = STATE(435),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [81] = {
    [sym_expression] = STATE(371),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [82] = {
    [sym_expression] = STATE(472),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [83] = {
    [sym_expression] = STATE(464),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [84] = {
    [sym_expression] = STATE(465),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [85] = {
    [sym_expression] = STATE(390),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [86] = {
    [sym_expression] = STATE(391),
    [sym__primary_expression] = STATE(406),
    [sym_type_cast_expression] = STATE(406),
    [sym_ternary_expression] = STATE(406),
    [sym_new_expression] = STATE(406),
    [sym_tuple_expression] = STATE(406),
    [sym_inline_array_expression] = STATE(406),
    [sym_binary_expression] = STATE(406),
    [sym_unary_expression] = STATE(406),
    [sym_update_expression] = STATE(406),
    [sym_member_expression] = STATE(406),
    [sym_array_access] = STATE(406),
    [sym_slice_access] = STATE(406),
    [sym_struct_expression] = STATE(406),
    [sym_parenthesized_expression] = STATE(406),
    [sym_assignment_expression] = STATE(406),
    [sym_augmented_assignment_expression] = STATE(406),
    [sym_call_expression] = STATE(406),
    [sym_payable_conversion_expression] = STATE(406),
    [sym_meta_type_expression] = STATE(406),
    [sym_user_defined_type] = STATE(406),
    [sym__identifier_path] = STATE(336),
    [sym_primitive_type] = STATE(377),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [sym__literal] = STATE(406),
    [sym_string_literal] = STATE(406),
    [sym_number_literal] = STATE(406),
    [sym__decimal_number] = STATE(355),
    [sym__hex_number] = STATE(355),
    [sym_true] = STATE(424),
    [sym_false] = STATE(424),
    [sym_boolean_literal] = STATE(406),
    [sym_hex_string_literal] = STATE(406),
    [sym_unicode_string_literal] = STATE(406),
    [sym_string] = STATE(364),
    [aux_sym_string_literal_repeat1] = STATE(364),
    [aux_sym_hex_string_literal_repeat2] = STATE(367),
    [aux_sym_unicode_string_literal_repeat3] = STATE(368),
    [sym_identifier] = ACTIONS(105),
    [anon_sym_DASH] = ACTIONS(41),
    [anon_sym_TILDE] = ACTIONS(43),
    [anon_sym_type] = ACTIONS(49),
    [anon_sym_LPAREN] = ACTIONS(252),
    [anon_sym_true] = ACTIONS(61),
    [anon_sym_false] = ACTIONS(63),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_payable] = ACTIONS(85),
    [anon_sym_new] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_delete] = ACTIONS(41),
    [anon_sym_BANG] = ACTIONS(43),
    [anon_sym_PLUS_PLUS] = ACTIONS(91),
    [anon_sym_DASH_DASH] = ACTIONS(91),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [aux_sym__decimal_number_token1] = ACTIONS(93),
    [aux_sym__decimal_number_token2] = ACTIONS(95),
    [aux_sym__hex_number_token1] = ACTIONS(95),
    [anon_sym_hex] = ACTIONS(97),
    [anon_sym_DQUOTE] = ACTIONS(99),
    [anon_sym_SQUOTE] = ACTIONS(101),
    [anon_sym_unicode] = ACTIONS(103),
    [sym_comment] = ACTIONS(3),
  },
  [87] = {
    [sym__source_unit] = STATE(87),
    [sym__directive] = STATE(87),
    [sym_pragma_directive] = STATE(87),
    [sym_import_directive] = STATE(87),
    [sym__declaration] = STATE(87),
    [sym_user_defined_type_definition] = STATE(87),
    [sym_constant_variable_declaration] = STATE(87),
    [sym_contract_declaration] = STATE(87),
    [sym_error_declaration] = STATE(87),
    [sym_interface_declaration] = STATE(87),
    [sym_library_declaration] = STATE(87),
    [sym_struct_declaration] = STATE(87),
    [sym_enum_declaration] = STATE(87),
    [sym_event_definition] = STATE(87),
    [sym_function_definition] = STATE(87),
    [sym_type_name] = STATE(789),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(345),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(345),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [aux_sym_source_file_repeat1] = STATE(87),
    [ts_builtin_sym_end] = ACTIONS(313),
    [sym_identifier] = ACTIONS(315),
    [anon_sym_pragma] = ACTIONS(318),
    [anon_sym_import] = ACTIONS(321),
    [anon_sym_type] = ACTIONS(324),
    [anon_sym_abstract] = ACTIONS(327),
    [anon_sym_contract] = ACTIONS(330),
    [anon_sym_error] = ACTIONS(333),
    [anon_sym_interface] = ACTIONS(336),
    [anon_sym_library] = ACTIONS(339),
    [anon_sym_struct] = ACTIONS(342),
    [anon_sym_enum] = ACTIONS(345),
    [anon_sym_event] = ACTIONS(348),
    [anon_sym_function] = ACTIONS(351),
    [anon_sym_byte] = ACTIONS(354),
    [anon_sym_address] = ACTIONS(357),
    [anon_sym_var] = ACTIONS(354),
    [anon_sym_mapping] = ACTIONS(360),
    [anon_sym_bool] = ACTIONS(354),
    [anon_sym_string] = ACTIONS(354),
    [anon_sym_int] = ACTIONS(354),
    [anon_sym_int8] = ACTIONS(354),
    [anon_sym_int16] = ACTIONS(354),
    [anon_sym_int24] = ACTIONS(354),
    [anon_sym_int32] = ACTIONS(354),
    [anon_sym_int40] = ACTIONS(354),
    [anon_sym_int48] = ACTIONS(354),
    [anon_sym_int56] = ACTIONS(354),
    [anon_sym_int64] = ACTIONS(354),
    [anon_sym_int72] = ACTIONS(354),
    [anon_sym_int80] = ACTIONS(354),
    [anon_sym_int88] = ACTIONS(354),
    [anon_sym_int96] = ACTIONS(354),
    [anon_sym_int104] = ACTIONS(354),
    [anon_sym_int112] = ACTIONS(354),
    [anon_sym_int120] = ACTIONS(354),
    [anon_sym_int128] = ACTIONS(354),
    [anon_sym_int136] = ACTIONS(354),
    [anon_sym_int144] = ACTIONS(354),
    [anon_sym_int152] = ACTIONS(354),
    [anon_sym_int160] = ACTIONS(354),
    [anon_sym_int168] = ACTIONS(354),
    [anon_sym_int176] = ACTIONS(354),
    [anon_sym_int184] = ACTIONS(354),
    [anon_sym_int192] = ACTIONS(354),
    [anon_sym_int200] = ACTIONS(354),
    [anon_sym_int208] = ACTIONS(354),
    [anon_sym_int216] = ACTIONS(354),
    [anon_sym_int224] = ACTIONS(354),
    [anon_sym_int232] = ACTIONS(354),
    [anon_sym_int240] = ACTIONS(354),
    [anon_sym_int248] = ACTIONS(354),
    [anon_sym_int256] = ACTIONS(354),
    [anon_sym_uint] = ACTIONS(354),
    [anon_sym_uint8] = ACTIONS(354),
    [anon_sym_uint16] = ACTIONS(354),
    [anon_sym_uint24] = ACTIONS(354),
    [anon_sym_uint32] = ACTIONS(354),
    [anon_sym_uint40] = ACTIONS(354),
    [anon_sym_uint48] = ACTIONS(354),
    [anon_sym_uint56] = ACTIONS(354),
    [anon_sym_uint64] = ACTIONS(354),
    [anon_sym_uint72] = ACTIONS(354),
    [anon_sym_uint80] = ACTIONS(354),
    [anon_sym_uint88] = ACTIONS(354),
    [anon_sym_uint96] = ACTIONS(354),
    [anon_sym_uint104] = ACTIONS(354),
    [anon_sym_uint112] = ACTIONS(354),
    [anon_sym_uint120] = ACTIONS(354),
    [anon_sym_uint128] = ACTIONS(354),
    [anon_sym_uint136] = ACTIONS(354),
    [anon_sym_uint144] = ACTIONS(354),
    [anon_sym_uint152] = ACTIONS(354),
    [anon_sym_uint160] = ACTIONS(354),
    [anon_sym_uint168] = ACTIONS(354),
    [anon_sym_uint176] = ACTIONS(354),
    [anon_sym_uint184] = ACTIONS(354),
    [anon_sym_uint192] = ACTIONS(354),
    [anon_sym_uint200] = ACTIONS(354),
    [anon_sym_uint208] = ACTIONS(354),
    [anon_sym_uint216] = ACTIONS(354),
    [anon_sym_uint224] = ACTIONS(354),
    [anon_sym_uint232] = ACTIONS(354),
    [anon_sym_uint240] = ACTIONS(354),
    [anon_sym_uint248] = ACTIONS(354),
    [anon_sym_uint256] = ACTIONS(354),
    [anon_sym_bytes] = ACTIONS(354),
    [anon_sym_bytes1] = ACTIONS(354),
    [anon_sym_bytes2] = ACTIONS(354),
    [anon_sym_bytes3] = ACTIONS(354),
    [anon_sym_bytes4] = ACTIONS(354),
    [anon_sym_bytes5] = ACTIONS(354),
    [anon_sym_bytes6] = ACTIONS(354),
    [anon_sym_bytes7] = ACTIONS(354),
    [anon_sym_bytes8] = ACTIONS(354),
    [anon_sym_bytes9] = ACTIONS(354),
    [anon_sym_bytes10] = ACTIONS(354),
    [anon_sym_bytes11] = ACTIONS(354),
    [anon_sym_bytes12] = ACTIONS(354),
    [anon_sym_bytes13] = ACTIONS(354),
    [anon_sym_bytes14] = ACTIONS(354),
    [anon_sym_bytes15] = ACTIONS(354),
    [anon_sym_bytes16] = ACTIONS(354),
    [anon_sym_bytes17] = ACTIONS(354),
    [anon_sym_bytes18] = ACTIONS(354),
    [anon_sym_bytes19] = ACTIONS(354),
    [anon_sym_bytes20] = ACTIONS(354),
    [anon_sym_bytes21] = ACTIONS(354),
    [anon_sym_bytes22] = ACTIONS(354),
    [anon_sym_bytes23] = ACTIONS(354),
    [anon_sym_bytes24] = ACTIONS(354),
    [anon_sym_bytes25] = ACTIONS(354),
    [anon_sym_bytes26] = ACTIONS(354),
    [anon_sym_bytes27] = ACTIONS(354),
    [anon_sym_bytes28] = ACTIONS(354),
    [anon_sym_bytes29] = ACTIONS(354),
    [anon_sym_bytes30] = ACTIONS(354),
    [anon_sym_bytes31] = ACTIONS(354),
    [anon_sym_bytes32] = ACTIONS(354),
    [anon_sym_fixed] = ACTIONS(354),
    [aux_sym__fixed_token1] = ACTIONS(354),
    [anon_sym_ufixed] = ACTIONS(354),
    [aux_sym__ufixed_token1] = ACTIONS(354),
    [sym_comment] = ACTIONS(3),
  },
  [88] = {
    [sym__source_unit] = STATE(87),
    [sym__directive] = STATE(87),
    [sym_pragma_directive] = STATE(87),
    [sym_import_directive] = STATE(87),
    [sym__declaration] = STATE(87),
    [sym_user_defined_type_definition] = STATE(87),
    [sym_constant_variable_declaration] = STATE(87),
    [sym_contract_declaration] = STATE(87),
    [sym_error_declaration] = STATE(87),
    [sym_interface_declaration] = STATE(87),
    [sym_library_declaration] = STATE(87),
    [sym_struct_declaration] = STATE(87),
    [sym_enum_declaration] = STATE(87),
    [sym_event_definition] = STATE(87),
    [sym_function_definition] = STATE(87),
    [sym_type_name] = STATE(789),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(345),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(345),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [aux_sym_source_file_repeat1] = STATE(87),
    [ts_builtin_sym_end] = ACTIONS(363),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_pragma] = ACTIONS(9),
    [anon_sym_import] = ACTIONS(11),
    [anon_sym_type] = ACTIONS(13),
    [anon_sym_abstract] = ACTIONS(15),
    [anon_sym_contract] = ACTIONS(17),
    [anon_sym_error] = ACTIONS(19),
    [anon_sym_interface] = ACTIONS(21),
    [anon_sym_library] = ACTIONS(23),
    [anon_sym_struct] = ACTIONS(25),
    [anon_sym_enum] = ACTIONS(27),
    [anon_sym_event] = ACTIONS(29),
    [anon_sym_function] = ACTIONS(31),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
  },
  [89] = {
    [sym_catch_clause] = STATE(90),
    [aux_sym_try_statement_repeat1] = STATE(90),
    [sym_identifier] = ACTIONS(365),
    [anon_sym_DASH] = ACTIONS(365),
    [anon_sym_TILDE] = ACTIONS(367),
    [anon_sym_LBRACE] = ACTIONS(367),
    [anon_sym_RBRACE] = ACTIONS(367),
    [anon_sym_type] = ACTIONS(365),
    [anon_sym_LPAREN] = ACTIONS(367),
    [anon_sym_for] = ACTIONS(365),
    [anon_sym_assembly] = ACTIONS(365),
    [anon_sym_break] = ACTIONS(365),
    [anon_sym_continue] = ACTIONS(365),
    [anon_sym_true] = ACTIONS(365),
    [anon_sym_false] = ACTIONS(365),
    [anon_sym_if] = ACTIONS(365),
    [anon_sym_function] = ACTIONS(365),
    [anon_sym_byte] = ACTIONS(365),
    [anon_sym_address] = ACTIONS(365),
    [anon_sym_return] = ACTIONS(365),
    [anon_sym_revert] = ACTIONS(365),
    [sym_unchecked] = ACTIONS(365),
    [anon_sym_var] = ACTIONS(365),
    [anon_sym_else] = ACTIONS(365),
    [anon_sym_while] = ACTIONS(365),
    [anon_sym_do] = ACTIONS(365),
    [anon_sym_try] = ACTIONS(365),
    [anon_sym_catch] = ACTIONS(369),
    [anon_sym_emit] = ACTIONS(365),
    [anon_sym_payable] = ACTIONS(365),
    [anon_sym_new] = ACTIONS(365),
    [anon_sym_LBRACK] = ACTIONS(367),
    [anon_sym_delete] = ACTIONS(365),
    [anon_sym_BANG] = ACTIONS(367),
    [anon_sym_PLUS_PLUS] = ACTIONS(367),
    [anon_sym_DASH_DASH] = ACTIONS(367),
    [anon_sym_mapping] = ACTIONS(365),
    [anon_sym_bool] = ACTIONS(365),
    [anon_sym_string] = ACTIONS(365),
    [anon_sym_int] = ACTIONS(365),
    [anon_sym_int8] = ACTIONS(365),
    [anon_sym_int16] = ACTIONS(365),
    [anon_sym_int24] = ACTIONS(365),
    [anon_sym_int32] = ACTIONS(365),
    [anon_sym_int40] = ACTIONS(365),
    [anon_sym_int48] = ACTIONS(365),
    [anon_sym_int56] = ACTIONS(365),
    [anon_sym_int64] = ACTIONS(365),
    [anon_sym_int72] = ACTIONS(365),
    [anon_sym_int80] = ACTIONS(365),
    [anon_sym_int88] = ACTIONS(365),
    [anon_sym_int96] = ACTIONS(365),
    [anon_sym_int104] = ACTIONS(365),
    [anon_sym_int112] = ACTIONS(365),
    [anon_sym_int120] = ACTIONS(365),
    [anon_sym_int128] = ACTIONS(365),
    [anon_sym_int136] = ACTIONS(365),
    [anon_sym_int144] = ACTIONS(365),
    [anon_sym_int152] = ACTIONS(365),
    [anon_sym_int160] = ACTIONS(365),
    [anon_sym_int168] = ACTIONS(365),
    [anon_sym_int176] = ACTIONS(365),
    [anon_sym_int184] = ACTIONS(365),
    [anon_sym_int192] = ACTIONS(365),
    [anon_sym_int200] = ACTIONS(365),
    [anon_sym_int208] = ACTIONS(365),
    [anon_sym_int216] = ACTIONS(365),
    [anon_sym_int224] = ACTIONS(365),
    [anon_sym_int232] = ACTIONS(365),
    [anon_sym_int240] = ACTIONS(365),
    [anon_sym_int248] = ACTIONS(365),
    [anon_sym_int256] = ACTIONS(365),
    [anon_sym_uint] = ACTIONS(365),
    [anon_sym_uint8] = ACTIONS(365),
    [anon_sym_uint16] = ACTIONS(365),
    [anon_sym_uint24] = ACTIONS(365),
    [anon_sym_uint32] = ACTIONS(365),
    [anon_sym_uint40] = ACTIONS(365),
    [anon_sym_uint48] = ACTIONS(365),
    [anon_sym_uint56] = ACTIONS(365),
    [anon_sym_uint64] = ACTIONS(365),
    [anon_sym_uint72] = ACTIONS(365),
    [anon_sym_uint80] = ACTIONS(365),
    [anon_sym_uint88] = ACTIONS(365),
    [anon_sym_uint96] = ACTIONS(365),
    [anon_sym_uint104] = ACTIONS(365),
    [anon_sym_uint112] = ACTIONS(365),
    [anon_sym_uint120] = ACTIONS(365),
    [anon_sym_uint128] = ACTIONS(365),
    [anon_sym_uint136] = ACTIONS(365),
    [anon_sym_uint144] = ACTIONS(365),
    [anon_sym_uint152] = ACTIONS(365),
    [anon_sym_uint160] = ACTIONS(365),
    [anon_sym_uint168] = ACTIONS(365),
    [anon_sym_uint176] = ACTIONS(365),
    [anon_sym_uint184] = ACTIONS(365),
    [anon_sym_uint192] = ACTIONS(365),
    [anon_sym_uint200] = ACTIONS(365),
    [anon_sym_uint208] = ACTIONS(365),
    [anon_sym_uint216] = ACTIONS(365),
    [anon_sym_uint224] = ACTIONS(365),
    [anon_sym_uint232] = ACTIONS(365),
    [anon_sym_uint240] = ACTIONS(365),
    [anon_sym_uint248] = ACTIONS(365),
    [anon_sym_uint256] = ACTIONS(365),
    [anon_sym_bytes] = ACTIONS(365),
    [anon_sym_bytes1] = ACTIONS(365),
    [anon_sym_bytes2] = ACTIONS(365),
    [anon_sym_bytes3] = ACTIONS(365),
    [anon_sym_bytes4] = ACTIONS(365),
    [anon_sym_bytes5] = ACTIONS(365),
    [anon_sym_bytes6] = ACTIONS(365),
    [anon_sym_bytes7] = ACTIONS(365),
    [anon_sym_bytes8] = ACTIONS(365),
    [anon_sym_bytes9] = ACTIONS(365),
    [anon_sym_bytes10] = ACTIONS(365),
    [anon_sym_bytes11] = ACTIONS(365),
    [anon_sym_bytes12] = ACTIONS(365),
    [anon_sym_bytes13] = ACTIONS(365),
    [anon_sym_bytes14] = ACTIONS(365),
    [anon_sym_bytes15] = ACTIONS(365),
    [anon_sym_bytes16] = ACTIONS(365),
    [anon_sym_bytes17] = ACTIONS(365),
    [anon_sym_bytes18] = ACTIONS(365),
    [anon_sym_bytes19] = ACTIONS(365),
    [anon_sym_bytes20] = ACTIONS(365),
    [anon_sym_bytes21] = ACTIONS(365),
    [anon_sym_bytes22] = ACTIONS(365),
    [anon_sym_bytes23] = ACTIONS(365),
    [anon_sym_bytes24] = ACTIONS(365),
    [anon_sym_bytes25] = ACTIONS(365),
    [anon_sym_bytes26] = ACTIONS(365),
    [anon_sym_bytes27] = ACTIONS(365),
    [anon_sym_bytes28] = ACTIONS(365),
    [anon_sym_bytes29] = ACTIONS(365),
    [anon_sym_bytes30] = ACTIONS(365),
    [anon_sym_bytes31] = ACTIONS(365),
    [anon_sym_bytes32] = ACTIONS(365),
    [anon_sym_fixed] = ACTIONS(365),
    [aux_sym__fixed_token1] = ACTIONS(365),
    [anon_sym_ufixed] = ACTIONS(365),
    [aux_sym__ufixed_token1] = ACTIONS(365),
    [aux_sym__decimal_number_token1] = ACTIONS(365),
    [aux_sym__decimal_number_token2] = ACTIONS(367),
    [aux_sym__hex_number_token1] = ACTIONS(367),
    [anon_sym_hex] = ACTIONS(365),
    [anon_sym_DQUOTE] = ACTIONS(367),
    [anon_sym_SQUOTE] = ACTIONS(367),
    [anon_sym_unicode] = ACTIONS(365),
    [sym_comment] = ACTIONS(3),
  },
  [90] = {
    [sym_catch_clause] = STATE(90),
    [aux_sym_try_statement_repeat1] = STATE(90),
    [sym_identifier] = ACTIONS(371),
    [anon_sym_DASH] = ACTIONS(371),
    [anon_sym_TILDE] = ACTIONS(373),
    [anon_sym_LBRACE] = ACTIONS(373),
    [anon_sym_RBRACE] = ACTIONS(373),
    [anon_sym_type] = ACTIONS(371),
    [anon_sym_LPAREN] = ACTIONS(373),
    [anon_sym_for] = ACTIONS(371),
    [anon_sym_assembly] = ACTIONS(371),
    [anon_sym_break] = ACTIONS(371),
    [anon_sym_continue] = ACTIONS(371),
    [anon_sym_true] = ACTIONS(371),
    [anon_sym_false] = ACTIONS(371),
    [anon_sym_if] = ACTIONS(371),
    [anon_sym_function] = ACTIONS(371),
    [anon_sym_byte] = ACTIONS(371),
    [anon_sym_address] = ACTIONS(371),
    [anon_sym_return] = ACTIONS(371),
    [anon_sym_revert] = ACTIONS(371),
    [sym_unchecked] = ACTIONS(371),
    [anon_sym_var] = ACTIONS(371),
    [anon_sym_else] = ACTIONS(371),
    [anon_sym_while] = ACTIONS(371),
    [anon_sym_do] = ACTIONS(371),
    [anon_sym_try] = ACTIONS(371),
    [anon_sym_catch] = ACTIONS(375),
    [anon_sym_emit] = ACTIONS(371),
    [anon_sym_payable] = ACTIONS(371),
    [anon_sym_new] = ACTIONS(371),
    [anon_sym_LBRACK] = ACTIONS(373),
    [anon_sym_delete] = ACTIONS(371),
    [anon_sym_BANG] = ACTIONS(373),
    [anon_sym_PLUS_PLUS] = ACTIONS(373),
    [anon_sym_DASH_DASH] = ACTIONS(373),
    [anon_sym_mapping] = ACTIONS(371),
    [anon_sym_bool] = ACTIONS(371),
    [anon_sym_string] = ACTIONS(371),
    [anon_sym_int] = ACTIONS(371),
    [anon_sym_int8] = ACTIONS(371),
    [anon_sym_int16] = ACTIONS(371),
    [anon_sym_int24] = ACTIONS(371),
    [anon_sym_int32] = ACTIONS(371),
    [anon_sym_int40] = ACTIONS(371),
    [anon_sym_int48] = ACTIONS(371),
    [anon_sym_int56] = ACTIONS(371),
    [anon_sym_int64] = ACTIONS(371),
    [anon_sym_int72] = ACTIONS(371),
    [anon_sym_int80] = ACTIONS(371),
    [anon_sym_int88] = ACTIONS(371),
    [anon_sym_int96] = ACTIONS(371),
    [anon_sym_int104] = ACTIONS(371),
    [anon_sym_int112] = ACTIONS(371),
    [anon_sym_int120] = ACTIONS(371),
    [anon_sym_int128] = ACTIONS(371),
    [anon_sym_int136] = ACTIONS(371),
    [anon_sym_int144] = ACTIONS(371),
    [anon_sym_int152] = ACTIONS(371),
    [anon_sym_int160] = ACTIONS(371),
    [anon_sym_int168] = ACTIONS(371),
    [anon_sym_int176] = ACTIONS(371),
    [anon_sym_int184] = ACTIONS(371),
    [anon_sym_int192] = ACTIONS(371),
    [anon_sym_int200] = ACTIONS(371),
    [anon_sym_int208] = ACTIONS(371),
    [anon_sym_int216] = ACTIONS(371),
    [anon_sym_int224] = ACTIONS(371),
    [anon_sym_int232] = ACTIONS(371),
    [anon_sym_int240] = ACTIONS(371),
    [anon_sym_int248] = ACTIONS(371),
    [anon_sym_int256] = ACTIONS(371),
    [anon_sym_uint] = ACTIONS(371),
    [anon_sym_uint8] = ACTIONS(371),
    [anon_sym_uint16] = ACTIONS(371),
    [anon_sym_uint24] = ACTIONS(371),
    [anon_sym_uint32] = ACTIONS(371),
    [anon_sym_uint40] = ACTIONS(371),
    [anon_sym_uint48] = ACTIONS(371),
    [anon_sym_uint56] = ACTIONS(371),
    [anon_sym_uint64] = ACTIONS(371),
    [anon_sym_uint72] = ACTIONS(371),
    [anon_sym_uint80] = ACTIONS(371),
    [anon_sym_uint88] = ACTIONS(371),
    [anon_sym_uint96] = ACTIONS(371),
    [anon_sym_uint104] = ACTIONS(371),
    [anon_sym_uint112] = ACTIONS(371),
    [anon_sym_uint120] = ACTIONS(371),
    [anon_sym_uint128] = ACTIONS(371),
    [anon_sym_uint136] = ACTIONS(371),
    [anon_sym_uint144] = ACTIONS(371),
    [anon_sym_uint152] = ACTIONS(371),
    [anon_sym_uint160] = ACTIONS(371),
    [anon_sym_uint168] = ACTIONS(371),
    [anon_sym_uint176] = ACTIONS(371),
    [anon_sym_uint184] = ACTIONS(371),
    [anon_sym_uint192] = ACTIONS(371),
    [anon_sym_uint200] = ACTIONS(371),
    [anon_sym_uint208] = ACTIONS(371),
    [anon_sym_uint216] = ACTIONS(371),
    [anon_sym_uint224] = ACTIONS(371),
    [anon_sym_uint232] = ACTIONS(371),
    [anon_sym_uint240] = ACTIONS(371),
    [anon_sym_uint248] = ACTIONS(371),
    [anon_sym_uint256] = ACTIONS(371),
    [anon_sym_bytes] = ACTIONS(371),
    [anon_sym_bytes1] = ACTIONS(371),
    [anon_sym_bytes2] = ACTIONS(371),
    [anon_sym_bytes3] = ACTIONS(371),
    [anon_sym_bytes4] = ACTIONS(371),
    [anon_sym_bytes5] = ACTIONS(371),
    [anon_sym_bytes6] = ACTIONS(371),
    [anon_sym_bytes7] = ACTIONS(371),
    [anon_sym_bytes8] = ACTIONS(371),
    [anon_sym_bytes9] = ACTIONS(371),
    [anon_sym_bytes10] = ACTIONS(371),
    [anon_sym_bytes11] = ACTIONS(371),
    [anon_sym_bytes12] = ACTIONS(371),
    [anon_sym_bytes13] = ACTIONS(371),
    [anon_sym_bytes14] = ACTIONS(371),
    [anon_sym_bytes15] = ACTIONS(371),
    [anon_sym_bytes16] = ACTIONS(371),
    [anon_sym_bytes17] = ACTIONS(371),
    [anon_sym_bytes18] = ACTIONS(371),
    [anon_sym_bytes19] = ACTIONS(371),
    [anon_sym_bytes20] = ACTIONS(371),
    [anon_sym_bytes21] = ACTIONS(371),
    [anon_sym_bytes22] = ACTIONS(371),
    [anon_sym_bytes23] = ACTIONS(371),
    [anon_sym_bytes24] = ACTIONS(371),
    [anon_sym_bytes25] = ACTIONS(371),
    [anon_sym_bytes26] = ACTIONS(371),
    [anon_sym_bytes27] = ACTIONS(371),
    [anon_sym_bytes28] = ACTIONS(371),
    [anon_sym_bytes29] = ACTIONS(371),
    [anon_sym_bytes30] = ACTIONS(371),
    [anon_sym_bytes31] = ACTIONS(371),
    [anon_sym_bytes32] = ACTIONS(371),
    [anon_sym_fixed] = ACTIONS(371),
    [aux_sym__fixed_token1] = ACTIONS(371),
    [anon_sym_ufixed] = ACTIONS(371),
    [aux_sym__ufixed_token1] = ACTIONS(371),
    [aux_sym__decimal_number_token1] = ACTIONS(371),
    [aux_sym__decimal_number_token2] = ACTIONS(373),
    [aux_sym__hex_number_token1] = ACTIONS(373),
    [anon_sym_hex] = ACTIONS(371),
    [anon_sym_DQUOTE] = ACTIONS(373),
    [anon_sym_SQUOTE] = ACTIONS(373),
    [anon_sym_unicode] = ACTIONS(371),
    [sym_comment] = ACTIONS(3),
  },
  [91] = {
    [sym_catch_clause] = STATE(90),
    [aux_sym_try_statement_repeat1] = STATE(90),
    [sym_identifier] = ACTIONS(378),
    [anon_sym_DASH] = ACTIONS(378),
    [anon_sym_TILDE] = ACTIONS(380),
    [anon_sym_LBRACE] = ACTIONS(380),
    [anon_sym_RBRACE] = ACTIONS(380),
    [anon_sym_type] = ACTIONS(378),
    [anon_sym_LPAREN] = ACTIONS(380),
    [anon_sym_for] = ACTIONS(378),
    [anon_sym_assembly] = ACTIONS(378),
    [anon_sym_break] = ACTIONS(378),
    [anon_sym_continue] = ACTIONS(378),
    [anon_sym_true] = ACTIONS(378),
    [anon_sym_false] = ACTIONS(378),
    [anon_sym_if] = ACTIONS(378),
    [anon_sym_function] = ACTIONS(378),
    [anon_sym_byte] = ACTIONS(378),
    [anon_sym_address] = ACTIONS(378),
    [anon_sym_return] = ACTIONS(378),
    [anon_sym_revert] = ACTIONS(378),
    [sym_unchecked] = ACTIONS(378),
    [anon_sym_var] = ACTIONS(378),
    [anon_sym_else] = ACTIONS(378),
    [anon_sym_while] = ACTIONS(378),
    [anon_sym_do] = ACTIONS(378),
    [anon_sym_try] = ACTIONS(378),
    [anon_sym_catch] = ACTIONS(369),
    [anon_sym_emit] = ACTIONS(378),
    [anon_sym_payable] = ACTIONS(378),
    [anon_sym_new] = ACTIONS(378),
    [anon_sym_LBRACK] = ACTIONS(380),
    [anon_sym_delete] = ACTIONS(378),
    [anon_sym_BANG] = ACTIONS(380),
    [anon_sym_PLUS_PLUS] = ACTIONS(380),
    [anon_sym_DASH_DASH] = ACTIONS(380),
    [anon_sym_mapping] = ACTIONS(378),
    [anon_sym_bool] = ACTIONS(378),
    [anon_sym_string] = ACTIONS(378),
    [anon_sym_int] = ACTIONS(378),
    [anon_sym_int8] = ACTIONS(378),
    [anon_sym_int16] = ACTIONS(378),
    [anon_sym_int24] = ACTIONS(378),
    [anon_sym_int32] = ACTIONS(378),
    [anon_sym_int40] = ACTIONS(378),
    [anon_sym_int48] = ACTIONS(378),
    [anon_sym_int56] = ACTIONS(378),
    [anon_sym_int64] = ACTIONS(378),
    [anon_sym_int72] = ACTIONS(378),
    [anon_sym_int80] = ACTIONS(378),
    [anon_sym_int88] = ACTIONS(378),
    [anon_sym_int96] = ACTIONS(378),
    [anon_sym_int104] = ACTIONS(378),
    [anon_sym_int112] = ACTIONS(378),
    [anon_sym_int120] = ACTIONS(378),
    [anon_sym_int128] = ACTIONS(378),
    [anon_sym_int136] = ACTIONS(378),
    [anon_sym_int144] = ACTIONS(378),
    [anon_sym_int152] = ACTIONS(378),
    [anon_sym_int160] = ACTIONS(378),
    [anon_sym_int168] = ACTIONS(378),
    [anon_sym_int176] = ACTIONS(378),
    [anon_sym_int184] = ACTIONS(378),
    [anon_sym_int192] = ACTIONS(378),
    [anon_sym_int200] = ACTIONS(378),
    [anon_sym_int208] = ACTIONS(378),
    [anon_sym_int216] = ACTIONS(378),
    [anon_sym_int224] = ACTIONS(378),
    [anon_sym_int232] = ACTIONS(378),
    [anon_sym_int240] = ACTIONS(378),
    [anon_sym_int248] = ACTIONS(378),
    [anon_sym_int256] = ACTIONS(378),
    [anon_sym_uint] = ACTIONS(378),
    [anon_sym_uint8] = ACTIONS(378),
    [anon_sym_uint16] = ACTIONS(378),
    [anon_sym_uint24] = ACTIONS(378),
    [anon_sym_uint32] = ACTIONS(378),
    [anon_sym_uint40] = ACTIONS(378),
    [anon_sym_uint48] = ACTIONS(378),
    [anon_sym_uint56] = ACTIONS(378),
    [anon_sym_uint64] = ACTIONS(378),
    [anon_sym_uint72] = ACTIONS(378),
    [anon_sym_uint80] = ACTIONS(378),
    [anon_sym_uint88] = ACTIONS(378),
    [anon_sym_uint96] = ACTIONS(378),
    [anon_sym_uint104] = ACTIONS(378),
    [anon_sym_uint112] = ACTIONS(378),
    [anon_sym_uint120] = ACTIONS(378),
    [anon_sym_uint128] = ACTIONS(378),
    [anon_sym_uint136] = ACTIONS(378),
    [anon_sym_uint144] = ACTIONS(378),
    [anon_sym_uint152] = ACTIONS(378),
    [anon_sym_uint160] = ACTIONS(378),
    [anon_sym_uint168] = ACTIONS(378),
    [anon_sym_uint176] = ACTIONS(378),
    [anon_sym_uint184] = ACTIONS(378),
    [anon_sym_uint192] = ACTIONS(378),
    [anon_sym_uint200] = ACTIONS(378),
    [anon_sym_uint208] = ACTIONS(378),
    [anon_sym_uint216] = ACTIONS(378),
    [anon_sym_uint224] = ACTIONS(378),
    [anon_sym_uint232] = ACTIONS(378),
    [anon_sym_uint240] = ACTIONS(378),
    [anon_sym_uint248] = ACTIONS(378),
    [anon_sym_uint256] = ACTIONS(378),
    [anon_sym_bytes] = ACTIONS(378),
    [anon_sym_bytes1] = ACTIONS(378),
    [anon_sym_bytes2] = ACTIONS(378),
    [anon_sym_bytes3] = ACTIONS(378),
    [anon_sym_bytes4] = ACTIONS(378),
    [anon_sym_bytes5] = ACTIONS(378),
    [anon_sym_bytes6] = ACTIONS(378),
    [anon_sym_bytes7] = ACTIONS(378),
    [anon_sym_bytes8] = ACTIONS(378),
    [anon_sym_bytes9] = ACTIONS(378),
    [anon_sym_bytes10] = ACTIONS(378),
    [anon_sym_bytes11] = ACTIONS(378),
    [anon_sym_bytes12] = ACTIONS(378),
    [anon_sym_bytes13] = ACTIONS(378),
    [anon_sym_bytes14] = ACTIONS(378),
    [anon_sym_bytes15] = ACTIONS(378),
    [anon_sym_bytes16] = ACTIONS(378),
    [anon_sym_bytes17] = ACTIONS(378),
    [anon_sym_bytes18] = ACTIONS(378),
    [anon_sym_bytes19] = ACTIONS(378),
    [anon_sym_bytes20] = ACTIONS(378),
    [anon_sym_bytes21] = ACTIONS(378),
    [anon_sym_bytes22] = ACTIONS(378),
    [anon_sym_bytes23] = ACTIONS(378),
    [anon_sym_bytes24] = ACTIONS(378),
    [anon_sym_bytes25] = ACTIONS(378),
    [anon_sym_bytes26] = ACTIONS(378),
    [anon_sym_bytes27] = ACTIONS(378),
    [anon_sym_bytes28] = ACTIONS(378),
    [anon_sym_bytes29] = ACTIONS(378),
    [anon_sym_bytes30] = ACTIONS(378),
    [anon_sym_bytes31] = ACTIONS(378),
    [anon_sym_bytes32] = ACTIONS(378),
    [anon_sym_fixed] = ACTIONS(378),
    [aux_sym__fixed_token1] = ACTIONS(378),
    [anon_sym_ufixed] = ACTIONS(378),
    [aux_sym__ufixed_token1] = ACTIONS(378),
    [aux_sym__decimal_number_token1] = ACTIONS(378),
    [aux_sym__decimal_number_token2] = ACTIONS(380),
    [aux_sym__hex_number_token1] = ACTIONS(380),
    [anon_sym_hex] = ACTIONS(378),
    [anon_sym_DQUOTE] = ACTIONS(380),
    [anon_sym_SQUOTE] = ACTIONS(380),
    [anon_sym_unicode] = ACTIONS(378),
    [sym_comment] = ACTIONS(3),
  },
  [92] = {
    [sym_identifier] = ACTIONS(382),
    [anon_sym_DASH] = ACTIONS(382),
    [anon_sym_TILDE] = ACTIONS(384),
    [anon_sym_LBRACE] = ACTIONS(384),
    [anon_sym_RBRACE] = ACTIONS(384),
    [anon_sym_type] = ACTIONS(382),
    [anon_sym_LPAREN] = ACTIONS(384),
    [anon_sym_RPAREN] = ACTIONS(384),
    [anon_sym_for] = ACTIONS(382),
    [anon_sym_assembly] = ACTIONS(382),
    [anon_sym_break] = ACTIONS(382),
    [anon_sym_continue] = ACTIONS(382),
    [anon_sym_true] = ACTIONS(382),
    [anon_sym_false] = ACTIONS(382),
    [anon_sym_if] = ACTIONS(382),
    [anon_sym_function] = ACTIONS(382),
    [anon_sym_byte] = ACTIONS(382),
    [anon_sym_address] = ACTIONS(382),
    [anon_sym_return] = ACTIONS(382),
    [anon_sym_revert] = ACTIONS(382),
    [sym_unchecked] = ACTIONS(382),
    [anon_sym_var] = ACTIONS(382),
    [anon_sym_else] = ACTIONS(382),
    [anon_sym_while] = ACTIONS(382),
    [anon_sym_do] = ACTIONS(382),
    [anon_sym_try] = ACTIONS(382),
    [anon_sym_emit] = ACTIONS(382),
    [anon_sym_payable] = ACTIONS(382),
    [anon_sym_new] = ACTIONS(382),
    [anon_sym_LBRACK] = ACTIONS(384),
    [anon_sym_delete] = ACTIONS(382),
    [anon_sym_BANG] = ACTIONS(384),
    [anon_sym_PLUS_PLUS] = ACTIONS(384),
    [anon_sym_DASH_DASH] = ACTIONS(384),
    [anon_sym_mapping] = ACTIONS(382),
    [anon_sym_bool] = ACTIONS(382),
    [anon_sym_string] = ACTIONS(382),
    [anon_sym_int] = ACTIONS(382),
    [anon_sym_int8] = ACTIONS(382),
    [anon_sym_int16] = ACTIONS(382),
    [anon_sym_int24] = ACTIONS(382),
    [anon_sym_int32] = ACTIONS(382),
    [anon_sym_int40] = ACTIONS(382),
    [anon_sym_int48] = ACTIONS(382),
    [anon_sym_int56] = ACTIONS(382),
    [anon_sym_int64] = ACTIONS(382),
    [anon_sym_int72] = ACTIONS(382),
    [anon_sym_int80] = ACTIONS(382),
    [anon_sym_int88] = ACTIONS(382),
    [anon_sym_int96] = ACTIONS(382),
    [anon_sym_int104] = ACTIONS(382),
    [anon_sym_int112] = ACTIONS(382),
    [anon_sym_int120] = ACTIONS(382),
    [anon_sym_int128] = ACTIONS(382),
    [anon_sym_int136] = ACTIONS(382),
    [anon_sym_int144] = ACTIONS(382),
    [anon_sym_int152] = ACTIONS(382),
    [anon_sym_int160] = ACTIONS(382),
    [anon_sym_int168] = ACTIONS(382),
    [anon_sym_int176] = ACTIONS(382),
    [anon_sym_int184] = ACTIONS(382),
    [anon_sym_int192] = ACTIONS(382),
    [anon_sym_int200] = ACTIONS(382),
    [anon_sym_int208] = ACTIONS(382),
    [anon_sym_int216] = ACTIONS(382),
    [anon_sym_int224] = ACTIONS(382),
    [anon_sym_int232] = ACTIONS(382),
    [anon_sym_int240] = ACTIONS(382),
    [anon_sym_int248] = ACTIONS(382),
    [anon_sym_int256] = ACTIONS(382),
    [anon_sym_uint] = ACTIONS(382),
    [anon_sym_uint8] = ACTIONS(382),
    [anon_sym_uint16] = ACTIONS(382),
    [anon_sym_uint24] = ACTIONS(382),
    [anon_sym_uint32] = ACTIONS(382),
    [anon_sym_uint40] = ACTIONS(382),
    [anon_sym_uint48] = ACTIONS(382),
    [anon_sym_uint56] = ACTIONS(382),
    [anon_sym_uint64] = ACTIONS(382),
    [anon_sym_uint72] = ACTIONS(382),
    [anon_sym_uint80] = ACTIONS(382),
    [anon_sym_uint88] = ACTIONS(382),
    [anon_sym_uint96] = ACTIONS(382),
    [anon_sym_uint104] = ACTIONS(382),
    [anon_sym_uint112] = ACTIONS(382),
    [anon_sym_uint120] = ACTIONS(382),
    [anon_sym_uint128] = ACTIONS(382),
    [anon_sym_uint136] = ACTIONS(382),
    [anon_sym_uint144] = ACTIONS(382),
    [anon_sym_uint152] = ACTIONS(382),
    [anon_sym_uint160] = ACTIONS(382),
    [anon_sym_uint168] = ACTIONS(382),
    [anon_sym_uint176] = ACTIONS(382),
    [anon_sym_uint184] = ACTIONS(382),
    [anon_sym_uint192] = ACTIONS(382),
    [anon_sym_uint200] = ACTIONS(382),
    [anon_sym_uint208] = ACTIONS(382),
    [anon_sym_uint216] = ACTIONS(382),
    [anon_sym_uint224] = ACTIONS(382),
    [anon_sym_uint232] = ACTIONS(382),
    [anon_sym_uint240] = ACTIONS(382),
    [anon_sym_uint248] = ACTIONS(382),
    [anon_sym_uint256] = ACTIONS(382),
    [anon_sym_bytes] = ACTIONS(382),
    [anon_sym_bytes1] = ACTIONS(382),
    [anon_sym_bytes2] = ACTIONS(382),
    [anon_sym_bytes3] = ACTIONS(382),
    [anon_sym_bytes4] = ACTIONS(382),
    [anon_sym_bytes5] = ACTIONS(382),
    [anon_sym_bytes6] = ACTIONS(382),
    [anon_sym_bytes7] = ACTIONS(382),
    [anon_sym_bytes8] = ACTIONS(382),
    [anon_sym_bytes9] = ACTIONS(382),
    [anon_sym_bytes10] = ACTIONS(382),
    [anon_sym_bytes11] = ACTIONS(382),
    [anon_sym_bytes12] = ACTIONS(382),
    [anon_sym_bytes13] = ACTIONS(382),
    [anon_sym_bytes14] = ACTIONS(382),
    [anon_sym_bytes15] = ACTIONS(382),
    [anon_sym_bytes16] = ACTIONS(382),
    [anon_sym_bytes17] = ACTIONS(382),
    [anon_sym_bytes18] = ACTIONS(382),
    [anon_sym_bytes19] = ACTIONS(382),
    [anon_sym_bytes20] = ACTIONS(382),
    [anon_sym_bytes21] = ACTIONS(382),
    [anon_sym_bytes22] = ACTIONS(382),
    [anon_sym_bytes23] = ACTIONS(382),
    [anon_sym_bytes24] = ACTIONS(382),
    [anon_sym_bytes25] = ACTIONS(382),
    [anon_sym_bytes26] = ACTIONS(382),
    [anon_sym_bytes27] = ACTIONS(382),
    [anon_sym_bytes28] = ACTIONS(382),
    [anon_sym_bytes29] = ACTIONS(382),
    [anon_sym_bytes30] = ACTIONS(382),
    [anon_sym_bytes31] = ACTIONS(382),
    [anon_sym_bytes32] = ACTIONS(382),
    [anon_sym_fixed] = ACTIONS(382),
    [aux_sym__fixed_token1] = ACTIONS(382),
    [anon_sym_ufixed] = ACTIONS(382),
    [aux_sym__ufixed_token1] = ACTIONS(382),
    [anon_sym_SEMI] = ACTIONS(384),
    [aux_sym__decimal_number_token1] = ACTIONS(382),
    [aux_sym__decimal_number_token2] = ACTIONS(384),
    [aux_sym__hex_number_token1] = ACTIONS(384),
    [anon_sym_hex] = ACTIONS(382),
    [anon_sym_DQUOTE] = ACTIONS(384),
    [anon_sym_SQUOTE] = ACTIONS(384),
    [anon_sym_unicode] = ACTIONS(382),
    [sym_comment] = ACTIONS(3),
  },
  [93] = {
    [sym_identifier] = ACTIONS(386),
    [anon_sym_DASH] = ACTIONS(386),
    [anon_sym_TILDE] = ACTIONS(388),
    [anon_sym_LBRACE] = ACTIONS(388),
    [anon_sym_RBRACE] = ACTIONS(388),
    [anon_sym_type] = ACTIONS(386),
    [anon_sym_LPAREN] = ACTIONS(388),
    [anon_sym_for] = ACTIONS(386),
    [anon_sym_assembly] = ACTIONS(386),
    [anon_sym_break] = ACTIONS(386),
    [anon_sym_continue] = ACTIONS(386),
    [anon_sym_true] = ACTIONS(386),
    [anon_sym_false] = ACTIONS(386),
    [anon_sym_if] = ACTIONS(386),
    [anon_sym_function] = ACTIONS(386),
    [anon_sym_byte] = ACTIONS(386),
    [anon_sym_address] = ACTIONS(386),
    [anon_sym_return] = ACTIONS(386),
    [anon_sym_revert] = ACTIONS(386),
    [sym_unchecked] = ACTIONS(386),
    [anon_sym_var] = ACTIONS(386),
    [anon_sym_else] = ACTIONS(386),
    [anon_sym_while] = ACTIONS(386),
    [anon_sym_do] = ACTIONS(386),
    [anon_sym_try] = ACTIONS(386),
    [anon_sym_emit] = ACTIONS(386),
    [anon_sym_payable] = ACTIONS(386),
    [anon_sym_new] = ACTIONS(386),
    [anon_sym_LBRACK] = ACTIONS(388),
    [anon_sym_delete] = ACTIONS(386),
    [anon_sym_BANG] = ACTIONS(388),
    [anon_sym_PLUS_PLUS] = ACTIONS(388),
    [anon_sym_DASH_DASH] = ACTIONS(388),
    [anon_sym_mapping] = ACTIONS(386),
    [anon_sym_bool] = ACTIONS(386),
    [anon_sym_string] = ACTIONS(386),
    [anon_sym_int] = ACTIONS(386),
    [anon_sym_int8] = ACTIONS(386),
    [anon_sym_int16] = ACTIONS(386),
    [anon_sym_int24] = ACTIONS(386),
    [anon_sym_int32] = ACTIONS(386),
    [anon_sym_int40] = ACTIONS(386),
    [anon_sym_int48] = ACTIONS(386),
    [anon_sym_int56] = ACTIONS(386),
    [anon_sym_int64] = ACTIONS(386),
    [anon_sym_int72] = ACTIONS(386),
    [anon_sym_int80] = ACTIONS(386),
    [anon_sym_int88] = ACTIONS(386),
    [anon_sym_int96] = ACTIONS(386),
    [anon_sym_int104] = ACTIONS(386),
    [anon_sym_int112] = ACTIONS(386),
    [anon_sym_int120] = ACTIONS(386),
    [anon_sym_int128] = ACTIONS(386),
    [anon_sym_int136] = ACTIONS(386),
    [anon_sym_int144] = ACTIONS(386),
    [anon_sym_int152] = ACTIONS(386),
    [anon_sym_int160] = ACTIONS(386),
    [anon_sym_int168] = ACTIONS(386),
    [anon_sym_int176] = ACTIONS(386),
    [anon_sym_int184] = ACTIONS(386),
    [anon_sym_int192] = ACTIONS(386),
    [anon_sym_int200] = ACTIONS(386),
    [anon_sym_int208] = ACTIONS(386),
    [anon_sym_int216] = ACTIONS(386),
    [anon_sym_int224] = ACTIONS(386),
    [anon_sym_int232] = ACTIONS(386),
    [anon_sym_int240] = ACTIONS(386),
    [anon_sym_int248] = ACTIONS(386),
    [anon_sym_int256] = ACTIONS(386),
    [anon_sym_uint] = ACTIONS(386),
    [anon_sym_uint8] = ACTIONS(386),
    [anon_sym_uint16] = ACTIONS(386),
    [anon_sym_uint24] = ACTIONS(386),
    [anon_sym_uint32] = ACTIONS(386),
    [anon_sym_uint40] = ACTIONS(386),
    [anon_sym_uint48] = ACTIONS(386),
    [anon_sym_uint56] = ACTIONS(386),
    [anon_sym_uint64] = ACTIONS(386),
    [anon_sym_uint72] = ACTIONS(386),
    [anon_sym_uint80] = ACTIONS(386),
    [anon_sym_uint88] = ACTIONS(386),
    [anon_sym_uint96] = ACTIONS(386),
    [anon_sym_uint104] = ACTIONS(386),
    [anon_sym_uint112] = ACTIONS(386),
    [anon_sym_uint120] = ACTIONS(386),
    [anon_sym_uint128] = ACTIONS(386),
    [anon_sym_uint136] = ACTIONS(386),
    [anon_sym_uint144] = ACTIONS(386),
    [anon_sym_uint152] = ACTIONS(386),
    [anon_sym_uint160] = ACTIONS(386),
    [anon_sym_uint168] = ACTIONS(386),
    [anon_sym_uint176] = ACTIONS(386),
    [anon_sym_uint184] = ACTIONS(386),
    [anon_sym_uint192] = ACTIONS(386),
    [anon_sym_uint200] = ACTIONS(386),
    [anon_sym_uint208] = ACTIONS(386),
    [anon_sym_uint216] = ACTIONS(386),
    [anon_sym_uint224] = ACTIONS(386),
    [anon_sym_uint232] = ACTIONS(386),
    [anon_sym_uint240] = ACTIONS(386),
    [anon_sym_uint248] = ACTIONS(386),
    [anon_sym_uint256] = ACTIONS(386),
    [anon_sym_bytes] = ACTIONS(386),
    [anon_sym_bytes1] = ACTIONS(386),
    [anon_sym_bytes2] = ACTIONS(386),
    [anon_sym_bytes3] = ACTIONS(386),
    [anon_sym_bytes4] = ACTIONS(386),
    [anon_sym_bytes5] = ACTIONS(386),
    [anon_sym_bytes6] = ACTIONS(386),
    [anon_sym_bytes7] = ACTIONS(386),
    [anon_sym_bytes8] = ACTIONS(386),
    [anon_sym_bytes9] = ACTIONS(386),
    [anon_sym_bytes10] = ACTIONS(386),
    [anon_sym_bytes11] = ACTIONS(386),
    [anon_sym_bytes12] = ACTIONS(386),
    [anon_sym_bytes13] = ACTIONS(386),
    [anon_sym_bytes14] = ACTIONS(386),
    [anon_sym_bytes15] = ACTIONS(386),
    [anon_sym_bytes16] = ACTIONS(386),
    [anon_sym_bytes17] = ACTIONS(386),
    [anon_sym_bytes18] = ACTIONS(386),
    [anon_sym_bytes19] = ACTIONS(386),
    [anon_sym_bytes20] = ACTIONS(386),
    [anon_sym_bytes21] = ACTIONS(386),
    [anon_sym_bytes22] = ACTIONS(386),
    [anon_sym_bytes23] = ACTIONS(386),
    [anon_sym_bytes24] = ACTIONS(386),
    [anon_sym_bytes25] = ACTIONS(386),
    [anon_sym_bytes26] = ACTIONS(386),
    [anon_sym_bytes27] = ACTIONS(386),
    [anon_sym_bytes28] = ACTIONS(386),
    [anon_sym_bytes29] = ACTIONS(386),
    [anon_sym_bytes30] = ACTIONS(386),
    [anon_sym_bytes31] = ACTIONS(386),
    [anon_sym_bytes32] = ACTIONS(386),
    [anon_sym_fixed] = ACTIONS(386),
    [aux_sym__fixed_token1] = ACTIONS(386),
    [anon_sym_ufixed] = ACTIONS(386),
    [aux_sym__ufixed_token1] = ACTIONS(386),
    [anon_sym_SEMI] = ACTIONS(388),
    [aux_sym__decimal_number_token1] = ACTIONS(386),
    [aux_sym__decimal_number_token2] = ACTIONS(388),
    [aux_sym__hex_number_token1] = ACTIONS(388),
    [anon_sym_hex] = ACTIONS(386),
    [anon_sym_DQUOTE] = ACTIONS(388),
    [anon_sym_SQUOTE] = ACTIONS(388),
    [anon_sym_unicode] = ACTIONS(386),
    [sym_comment] = ACTIONS(3),
  },
  [94] = {
    [sym_identifier] = ACTIONS(390),
    [anon_sym_DASH] = ACTIONS(390),
    [anon_sym_TILDE] = ACTIONS(392),
    [anon_sym_LBRACE] = ACTIONS(392),
    [anon_sym_RBRACE] = ACTIONS(392),
    [anon_sym_type] = ACTIONS(390),
    [anon_sym_LPAREN] = ACTIONS(392),
    [anon_sym_for] = ACTIONS(390),
    [anon_sym_assembly] = ACTIONS(390),
    [anon_sym_break] = ACTIONS(390),
    [anon_sym_continue] = ACTIONS(390),
    [anon_sym_true] = ACTIONS(390),
    [anon_sym_false] = ACTIONS(390),
    [anon_sym_if] = ACTIONS(390),
    [anon_sym_function] = ACTIONS(390),
    [anon_sym_byte] = ACTIONS(390),
    [anon_sym_address] = ACTIONS(390),
    [anon_sym_return] = ACTIONS(390),
    [anon_sym_revert] = ACTIONS(390),
    [sym_unchecked] = ACTIONS(390),
    [anon_sym_var] = ACTIONS(390),
    [anon_sym_else] = ACTIONS(390),
    [anon_sym_while] = ACTIONS(390),
    [anon_sym_do] = ACTIONS(390),
    [anon_sym_try] = ACTIONS(390),
    [anon_sym_catch] = ACTIONS(390),
    [anon_sym_emit] = ACTIONS(390),
    [anon_sym_payable] = ACTIONS(390),
    [anon_sym_new] = ACTIONS(390),
    [anon_sym_LBRACK] = ACTIONS(392),
    [anon_sym_delete] = ACTIONS(390),
    [anon_sym_BANG] = ACTIONS(392),
    [anon_sym_PLUS_PLUS] = ACTIONS(392),
    [anon_sym_DASH_DASH] = ACTIONS(392),
    [anon_sym_mapping] = ACTIONS(390),
    [anon_sym_bool] = ACTIONS(390),
    [anon_sym_string] = ACTIONS(390),
    [anon_sym_int] = ACTIONS(390),
    [anon_sym_int8] = ACTIONS(390),
    [anon_sym_int16] = ACTIONS(390),
    [anon_sym_int24] = ACTIONS(390),
    [anon_sym_int32] = ACTIONS(390),
    [anon_sym_int40] = ACTIONS(390),
    [anon_sym_int48] = ACTIONS(390),
    [anon_sym_int56] = ACTIONS(390),
    [anon_sym_int64] = ACTIONS(390),
    [anon_sym_int72] = ACTIONS(390),
    [anon_sym_int80] = ACTIONS(390),
    [anon_sym_int88] = ACTIONS(390),
    [anon_sym_int96] = ACTIONS(390),
    [anon_sym_int104] = ACTIONS(390),
    [anon_sym_int112] = ACTIONS(390),
    [anon_sym_int120] = ACTIONS(390),
    [anon_sym_int128] = ACTIONS(390),
    [anon_sym_int136] = ACTIONS(390),
    [anon_sym_int144] = ACTIONS(390),
    [anon_sym_int152] = ACTIONS(390),
    [anon_sym_int160] = ACTIONS(390),
    [anon_sym_int168] = ACTIONS(390),
    [anon_sym_int176] = ACTIONS(390),
    [anon_sym_int184] = ACTIONS(390),
    [anon_sym_int192] = ACTIONS(390),
    [anon_sym_int200] = ACTIONS(390),
    [anon_sym_int208] = ACTIONS(390),
    [anon_sym_int216] = ACTIONS(390),
    [anon_sym_int224] = ACTIONS(390),
    [anon_sym_int232] = ACTIONS(390),
    [anon_sym_int240] = ACTIONS(390),
    [anon_sym_int248] = ACTIONS(390),
    [anon_sym_int256] = ACTIONS(390),
    [anon_sym_uint] = ACTIONS(390),
    [anon_sym_uint8] = ACTIONS(390),
    [anon_sym_uint16] = ACTIONS(390),
    [anon_sym_uint24] = ACTIONS(390),
    [anon_sym_uint32] = ACTIONS(390),
    [anon_sym_uint40] = ACTIONS(390),
    [anon_sym_uint48] = ACTIONS(390),
    [anon_sym_uint56] = ACTIONS(390),
    [anon_sym_uint64] = ACTIONS(390),
    [anon_sym_uint72] = ACTIONS(390),
    [anon_sym_uint80] = ACTIONS(390),
    [anon_sym_uint88] = ACTIONS(390),
    [anon_sym_uint96] = ACTIONS(390),
    [anon_sym_uint104] = ACTIONS(390),
    [anon_sym_uint112] = ACTIONS(390),
    [anon_sym_uint120] = ACTIONS(390),
    [anon_sym_uint128] = ACTIONS(390),
    [anon_sym_uint136] = ACTIONS(390),
    [anon_sym_uint144] = ACTIONS(390),
    [anon_sym_uint152] = ACTIONS(390),
    [anon_sym_uint160] = ACTIONS(390),
    [anon_sym_uint168] = ACTIONS(390),
    [anon_sym_uint176] = ACTIONS(390),
    [anon_sym_uint184] = ACTIONS(390),
    [anon_sym_uint192] = ACTIONS(390),
    [anon_sym_uint200] = ACTIONS(390),
    [anon_sym_uint208] = ACTIONS(390),
    [anon_sym_uint216] = ACTIONS(390),
    [anon_sym_uint224] = ACTIONS(390),
    [anon_sym_uint232] = ACTIONS(390),
    [anon_sym_uint240] = ACTIONS(390),
    [anon_sym_uint248] = ACTIONS(390),
    [anon_sym_uint256] = ACTIONS(390),
    [anon_sym_bytes] = ACTIONS(390),
    [anon_sym_bytes1] = ACTIONS(390),
    [anon_sym_bytes2] = ACTIONS(390),
    [anon_sym_bytes3] = ACTIONS(390),
    [anon_sym_bytes4] = ACTIONS(390),
    [anon_sym_bytes5] = ACTIONS(390),
    [anon_sym_bytes6] = ACTIONS(390),
    [anon_sym_bytes7] = ACTIONS(390),
    [anon_sym_bytes8] = ACTIONS(390),
    [anon_sym_bytes9] = ACTIONS(390),
    [anon_sym_bytes10] = ACTIONS(390),
    [anon_sym_bytes11] = ACTIONS(390),
    [anon_sym_bytes12] = ACTIONS(390),
    [anon_sym_bytes13] = ACTIONS(390),
    [anon_sym_bytes14] = ACTIONS(390),
    [anon_sym_bytes15] = ACTIONS(390),
    [anon_sym_bytes16] = ACTIONS(390),
    [anon_sym_bytes17] = ACTIONS(390),
    [anon_sym_bytes18] = ACTIONS(390),
    [anon_sym_bytes19] = ACTIONS(390),
    [anon_sym_bytes20] = ACTIONS(390),
    [anon_sym_bytes21] = ACTIONS(390),
    [anon_sym_bytes22] = ACTIONS(390),
    [anon_sym_bytes23] = ACTIONS(390),
    [anon_sym_bytes24] = ACTIONS(390),
    [anon_sym_bytes25] = ACTIONS(390),
    [anon_sym_bytes26] = ACTIONS(390),
    [anon_sym_bytes27] = ACTIONS(390),
    [anon_sym_bytes28] = ACTIONS(390),
    [anon_sym_bytes29] = ACTIONS(390),
    [anon_sym_bytes30] = ACTIONS(390),
    [anon_sym_bytes31] = ACTIONS(390),
    [anon_sym_bytes32] = ACTIONS(390),
    [anon_sym_fixed] = ACTIONS(390),
    [aux_sym__fixed_token1] = ACTIONS(390),
    [anon_sym_ufixed] = ACTIONS(390),
    [aux_sym__ufixed_token1] = ACTIONS(390),
    [aux_sym__decimal_number_token1] = ACTIONS(390),
    [aux_sym__decimal_number_token2] = ACTIONS(392),
    [aux_sym__hex_number_token1] = ACTIONS(392),
    [anon_sym_hex] = ACTIONS(390),
    [anon_sym_DQUOTE] = ACTIONS(392),
    [anon_sym_SQUOTE] = ACTIONS(392),
    [anon_sym_unicode] = ACTIONS(390),
    [sym_comment] = ACTIONS(3),
  },
  [95] = {
    [sym_user_defined_type_definition] = STATE(100),
    [sym_error_declaration] = STATE(100),
    [sym__contract_member] = STATE(100),
    [sym_struct_declaration] = STATE(100),
    [sym_enum_declaration] = STATE(100),
    [sym_event_definition] = STATE(100),
    [sym_using_directive] = STATE(100),
    [sym_state_variable_declaration] = STATE(100),
    [sym_modifier_definition] = STATE(100),
    [sym_constructor_definition] = STATE(100),
    [sym_fallback_receive_definition] = STATE(100),
    [sym_function_definition] = STATE(100),
    [sym_type_name] = STATE(490),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(345),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(345),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [aux_sym_contract_body_repeat1] = STATE(100),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(394),
    [anon_sym_type] = ACTIONS(396),
    [anon_sym_error] = ACTIONS(398),
    [anon_sym_struct] = ACTIONS(400),
    [anon_sym_enum] = ACTIONS(402),
    [anon_sym_event] = ACTIONS(404),
    [anon_sym_using] = ACTIONS(406),
    [anon_sym_function] = ACTIONS(408),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_modifier] = ACTIONS(410),
    [anon_sym_constructor] = ACTIONS(412),
    [anon_sym_fallback] = ACTIONS(414),
    [anon_sym_receive] = ACTIONS(414),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
  },
  [96] = {
    [sym_identifier] = ACTIONS(416),
    [anon_sym_DASH] = ACTIONS(416),
    [anon_sym_TILDE] = ACTIONS(418),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_RBRACE] = ACTIONS(418),
    [anon_sym_type] = ACTIONS(416),
    [anon_sym_LPAREN] = ACTIONS(418),
    [anon_sym_for] = ACTIONS(416),
    [anon_sym_assembly] = ACTIONS(416),
    [anon_sym_break] = ACTIONS(416),
    [anon_sym_continue] = ACTIONS(416),
    [anon_sym_true] = ACTIONS(416),
    [anon_sym_false] = ACTIONS(416),
    [anon_sym_if] = ACTIONS(416),
    [anon_sym_function] = ACTIONS(416),
    [anon_sym_byte] = ACTIONS(416),
    [anon_sym_address] = ACTIONS(416),
    [anon_sym_return] = ACTIONS(416),
    [anon_sym_revert] = ACTIONS(416),
    [sym_unchecked] = ACTIONS(416),
    [anon_sym_var] = ACTIONS(416),
    [anon_sym_else] = ACTIONS(416),
    [anon_sym_while] = ACTIONS(416),
    [anon_sym_do] = ACTIONS(416),
    [anon_sym_try] = ACTIONS(416),
    [anon_sym_emit] = ACTIONS(416),
    [anon_sym_payable] = ACTIONS(416),
    [anon_sym_new] = ACTIONS(416),
    [anon_sym_LBRACK] = ACTIONS(418),
    [anon_sym_delete] = ACTIONS(416),
    [anon_sym_BANG] = ACTIONS(418),
    [anon_sym_PLUS_PLUS] = ACTIONS(418),
    [anon_sym_DASH_DASH] = ACTIONS(418),
    [anon_sym_mapping] = ACTIONS(416),
    [anon_sym_bool] = ACTIONS(416),
    [anon_sym_string] = ACTIONS(416),
    [anon_sym_int] = ACTIONS(416),
    [anon_sym_int8] = ACTIONS(416),
    [anon_sym_int16] = ACTIONS(416),
    [anon_sym_int24] = ACTIONS(416),
    [anon_sym_int32] = ACTIONS(416),
    [anon_sym_int40] = ACTIONS(416),
    [anon_sym_int48] = ACTIONS(416),
    [anon_sym_int56] = ACTIONS(416),
    [anon_sym_int64] = ACTIONS(416),
    [anon_sym_int72] = ACTIONS(416),
    [anon_sym_int80] = ACTIONS(416),
    [anon_sym_int88] = ACTIONS(416),
    [anon_sym_int96] = ACTIONS(416),
    [anon_sym_int104] = ACTIONS(416),
    [anon_sym_int112] = ACTIONS(416),
    [anon_sym_int120] = ACTIONS(416),
    [anon_sym_int128] = ACTIONS(416),
    [anon_sym_int136] = ACTIONS(416),
    [anon_sym_int144] = ACTIONS(416),
    [anon_sym_int152] = ACTIONS(416),
    [anon_sym_int160] = ACTIONS(416),
    [anon_sym_int168] = ACTIONS(416),
    [anon_sym_int176] = ACTIONS(416),
    [anon_sym_int184] = ACTIONS(416),
    [anon_sym_int192] = ACTIONS(416),
    [anon_sym_int200] = ACTIONS(416),
    [anon_sym_int208] = ACTIONS(416),
    [anon_sym_int216] = ACTIONS(416),
    [anon_sym_int224] = ACTIONS(416),
    [anon_sym_int232] = ACTIONS(416),
    [anon_sym_int240] = ACTIONS(416),
    [anon_sym_int248] = ACTIONS(416),
    [anon_sym_int256] = ACTIONS(416),
    [anon_sym_uint] = ACTIONS(416),
    [anon_sym_uint8] = ACTIONS(416),
    [anon_sym_uint16] = ACTIONS(416),
    [anon_sym_uint24] = ACTIONS(416),
    [anon_sym_uint32] = ACTIONS(416),
    [anon_sym_uint40] = ACTIONS(416),
    [anon_sym_uint48] = ACTIONS(416),
    [anon_sym_uint56] = ACTIONS(416),
    [anon_sym_uint64] = ACTIONS(416),
    [anon_sym_uint72] = ACTIONS(416),
    [anon_sym_uint80] = ACTIONS(416),
    [anon_sym_uint88] = ACTIONS(416),
    [anon_sym_uint96] = ACTIONS(416),
    [anon_sym_uint104] = ACTIONS(416),
    [anon_sym_uint112] = ACTIONS(416),
    [anon_sym_uint120] = ACTIONS(416),
    [anon_sym_uint128] = ACTIONS(416),
    [anon_sym_uint136] = ACTIONS(416),
    [anon_sym_uint144] = ACTIONS(416),
    [anon_sym_uint152] = ACTIONS(416),
    [anon_sym_uint160] = ACTIONS(416),
    [anon_sym_uint168] = ACTIONS(416),
    [anon_sym_uint176] = ACTIONS(416),
    [anon_sym_uint184] = ACTIONS(416),
    [anon_sym_uint192] = ACTIONS(416),
    [anon_sym_uint200] = ACTIONS(416),
    [anon_sym_uint208] = ACTIONS(416),
    [anon_sym_uint216] = ACTIONS(416),
    [anon_sym_uint224] = ACTIONS(416),
    [anon_sym_uint232] = ACTIONS(416),
    [anon_sym_uint240] = ACTIONS(416),
    [anon_sym_uint248] = ACTIONS(416),
    [anon_sym_uint256] = ACTIONS(416),
    [anon_sym_bytes] = ACTIONS(416),
    [anon_sym_bytes1] = ACTIONS(416),
    [anon_sym_bytes2] = ACTIONS(416),
    [anon_sym_bytes3] = ACTIONS(416),
    [anon_sym_bytes4] = ACTIONS(416),
    [anon_sym_bytes5] = ACTIONS(416),
    [anon_sym_bytes6] = ACTIONS(416),
    [anon_sym_bytes7] = ACTIONS(416),
    [anon_sym_bytes8] = ACTIONS(416),
    [anon_sym_bytes9] = ACTIONS(416),
    [anon_sym_bytes10] = ACTIONS(416),
    [anon_sym_bytes11] = ACTIONS(416),
    [anon_sym_bytes12] = ACTIONS(416),
    [anon_sym_bytes13] = ACTIONS(416),
    [anon_sym_bytes14] = ACTIONS(416),
    [anon_sym_bytes15] = ACTIONS(416),
    [anon_sym_bytes16] = ACTIONS(416),
    [anon_sym_bytes17] = ACTIONS(416),
    [anon_sym_bytes18] = ACTIONS(416),
    [anon_sym_bytes19] = ACTIONS(416),
    [anon_sym_bytes20] = ACTIONS(416),
    [anon_sym_bytes21] = ACTIONS(416),
    [anon_sym_bytes22] = ACTIONS(416),
    [anon_sym_bytes23] = ACTIONS(416),
    [anon_sym_bytes24] = ACTIONS(416),
    [anon_sym_bytes25] = ACTIONS(416),
    [anon_sym_bytes26] = ACTIONS(416),
    [anon_sym_bytes27] = ACTIONS(416),
    [anon_sym_bytes28] = ACTIONS(416),
    [anon_sym_bytes29] = ACTIONS(416),
    [anon_sym_bytes30] = ACTIONS(416),
    [anon_sym_bytes31] = ACTIONS(416),
    [anon_sym_bytes32] = ACTIONS(416),
    [anon_sym_fixed] = ACTIONS(416),
    [aux_sym__fixed_token1] = ACTIONS(416),
    [anon_sym_ufixed] = ACTIONS(416),
    [aux_sym__ufixed_token1] = ACTIONS(416),
    [anon_sym_SEMI] = ACTIONS(418),
    [aux_sym__decimal_number_token1] = ACTIONS(416),
    [aux_sym__decimal_number_token2] = ACTIONS(418),
    [aux_sym__hex_number_token1] = ACTIONS(418),
    [anon_sym_hex] = ACTIONS(416),
    [anon_sym_DQUOTE] = ACTIONS(418),
    [anon_sym_SQUOTE] = ACTIONS(418),
    [anon_sym_unicode] = ACTIONS(416),
    [sym_comment] = ACTIONS(3),
  },
  [97] = {
    [sym_user_defined_type_definition] = STATE(95),
    [sym_error_declaration] = STATE(95),
    [sym__contract_member] = STATE(95),
    [sym_struct_declaration] = STATE(95),
    [sym_enum_declaration] = STATE(95),
    [sym_event_definition] = STATE(95),
    [sym_using_directive] = STATE(95),
    [sym_state_variable_declaration] = STATE(95),
    [sym_modifier_definition] = STATE(95),
    [sym_constructor_definition] = STATE(95),
    [sym_fallback_receive_definition] = STATE(95),
    [sym_function_definition] = STATE(95),
    [sym_type_name] = STATE(490),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(345),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(345),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [aux_sym_contract_body_repeat1] = STATE(95),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_RBRACE] = ACTIONS(420),
    [anon_sym_type] = ACTIONS(396),
    [anon_sym_error] = ACTIONS(398),
    [anon_sym_struct] = ACTIONS(400),
    [anon_sym_enum] = ACTIONS(402),
    [anon_sym_event] = ACTIONS(404),
    [anon_sym_using] = ACTIONS(406),
    [anon_sym_function] = ACTIONS(408),
    [anon_sym_byte] = ACTIONS(33),
    [anon_sym_address] = ACTIONS(35),
    [anon_sym_var] = ACTIONS(33),
    [anon_sym_modifier] = ACTIONS(410),
    [anon_sym_constructor] = ACTIONS(412),
    [anon_sym_fallback] = ACTIONS(414),
    [anon_sym_receive] = ACTIONS(414),
    [anon_sym_mapping] = ACTIONS(37),
    [anon_sym_bool] = ACTIONS(33),
    [anon_sym_string] = ACTIONS(33),
    [anon_sym_int] = ACTIONS(33),
    [anon_sym_int8] = ACTIONS(33),
    [anon_sym_int16] = ACTIONS(33),
    [anon_sym_int24] = ACTIONS(33),
    [anon_sym_int32] = ACTIONS(33),
    [anon_sym_int40] = ACTIONS(33),
    [anon_sym_int48] = ACTIONS(33),
    [anon_sym_int56] = ACTIONS(33),
    [anon_sym_int64] = ACTIONS(33),
    [anon_sym_int72] = ACTIONS(33),
    [anon_sym_int80] = ACTIONS(33),
    [anon_sym_int88] = ACTIONS(33),
    [anon_sym_int96] = ACTIONS(33),
    [anon_sym_int104] = ACTIONS(33),
    [anon_sym_int112] = ACTIONS(33),
    [anon_sym_int120] = ACTIONS(33),
    [anon_sym_int128] = ACTIONS(33),
    [anon_sym_int136] = ACTIONS(33),
    [anon_sym_int144] = ACTIONS(33),
    [anon_sym_int152] = ACTIONS(33),
    [anon_sym_int160] = ACTIONS(33),
    [anon_sym_int168] = ACTIONS(33),
    [anon_sym_int176] = ACTIONS(33),
    [anon_sym_int184] = ACTIONS(33),
    [anon_sym_int192] = ACTIONS(33),
    [anon_sym_int200] = ACTIONS(33),
    [anon_sym_int208] = ACTIONS(33),
    [anon_sym_int216] = ACTIONS(33),
    [anon_sym_int224] = ACTIONS(33),
    [anon_sym_int232] = ACTIONS(33),
    [anon_sym_int240] = ACTIONS(33),
    [anon_sym_int248] = ACTIONS(33),
    [anon_sym_int256] = ACTIONS(33),
    [anon_sym_uint] = ACTIONS(33),
    [anon_sym_uint8] = ACTIONS(33),
    [anon_sym_uint16] = ACTIONS(33),
    [anon_sym_uint24] = ACTIONS(33),
    [anon_sym_uint32] = ACTIONS(33),
    [anon_sym_uint40] = ACTIONS(33),
    [anon_sym_uint48] = ACTIONS(33),
    [anon_sym_uint56] = ACTIONS(33),
    [anon_sym_uint64] = ACTIONS(33),
    [anon_sym_uint72] = ACTIONS(33),
    [anon_sym_uint80] = ACTIONS(33),
    [anon_sym_uint88] = ACTIONS(33),
    [anon_sym_uint96] = ACTIONS(33),
    [anon_sym_uint104] = ACTIONS(33),
    [anon_sym_uint112] = ACTIONS(33),
    [anon_sym_uint120] = ACTIONS(33),
    [anon_sym_uint128] = ACTIONS(33),
    [anon_sym_uint136] = ACTIONS(33),
    [anon_sym_uint144] = ACTIONS(33),
    [anon_sym_uint152] = ACTIONS(33),
    [anon_sym_uint160] = ACTIONS(33),
    [anon_sym_uint168] = ACTIONS(33),
    [anon_sym_uint176] = ACTIONS(33),
    [anon_sym_uint184] = ACTIONS(33),
    [anon_sym_uint192] = ACTIONS(33),
    [anon_sym_uint200] = ACTIONS(33),
    [anon_sym_uint208] = ACTIONS(33),
    [anon_sym_uint216] = ACTIONS(33),
    [anon_sym_uint224] = ACTIONS(33),
    [anon_sym_uint232] = ACTIONS(33),
    [anon_sym_uint240] = ACTIONS(33),
    [anon_sym_uint248] = ACTIONS(33),
    [anon_sym_uint256] = ACTIONS(33),
    [anon_sym_bytes] = ACTIONS(33),
    [anon_sym_bytes1] = ACTIONS(33),
    [anon_sym_bytes2] = ACTIONS(33),
    [anon_sym_bytes3] = ACTIONS(33),
    [anon_sym_bytes4] = ACTIONS(33),
    [anon_sym_bytes5] = ACTIONS(33),
    [anon_sym_bytes6] = ACTIONS(33),
    [anon_sym_bytes7] = ACTIONS(33),
    [anon_sym_bytes8] = ACTIONS(33),
    [anon_sym_bytes9] = ACTIONS(33),
    [anon_sym_bytes10] = ACTIONS(33),
    [anon_sym_bytes11] = ACTIONS(33),
    [anon_sym_bytes12] = ACTIONS(33),
    [anon_sym_bytes13] = ACTIONS(33),
    [anon_sym_bytes14] = ACTIONS(33),
    [anon_sym_bytes15] = ACTIONS(33),
    [anon_sym_bytes16] = ACTIONS(33),
    [anon_sym_bytes17] = ACTIONS(33),
    [anon_sym_bytes18] = ACTIONS(33),
    [anon_sym_bytes19] = ACTIONS(33),
    [anon_sym_bytes20] = ACTIONS(33),
    [anon_sym_bytes21] = ACTIONS(33),
    [anon_sym_bytes22] = ACTIONS(33),
    [anon_sym_bytes23] = ACTIONS(33),
    [anon_sym_bytes24] = ACTIONS(33),
    [anon_sym_bytes25] = ACTIONS(33),
    [anon_sym_bytes26] = ACTIONS(33),
    [anon_sym_bytes27] = ACTIONS(33),
    [anon_sym_bytes28] = ACTIONS(33),
    [anon_sym_bytes29] = ACTIONS(33),
    [anon_sym_bytes30] = ACTIONS(33),
    [anon_sym_bytes31] = ACTIONS(33),
    [anon_sym_bytes32] = ACTIONS(33),
    [anon_sym_fixed] = ACTIONS(33),
    [aux_sym__fixed_token1] = ACTIONS(33),
    [anon_sym_ufixed] = ACTIONS(33),
    [aux_sym__ufixed_token1] = ACTIONS(33),
    [sym_comment] = ACTIONS(3),
  },
  [98] = {
    [sym_identifier] = ACTIONS(422),
    [anon_sym_DASH] = ACTIONS(422),
    [anon_sym_TILDE] = ACTIONS(424),
    [anon_sym_LBRACE] = ACTIONS(424),
    [anon_sym_RBRACE] = ACTIONS(424),
    [anon_sym_type] = ACTIONS(422),
    [anon_sym_LPAREN] = ACTIONS(424),
    [anon_sym_for] = ACTIONS(422),
    [anon_sym_assembly] = ACTIONS(422),
    [anon_sym_break] = ACTIONS(422),
    [anon_sym_continue] = ACTIONS(422),
    [anon_sym_true] = ACTIONS(422),
    [anon_sym_false] = ACTIONS(422),
    [anon_sym_if] = ACTIONS(422),
    [anon_sym_function] = ACTIONS(422),
    [anon_sym_byte] = ACTIONS(422),
    [anon_sym_address] = ACTIONS(422),
    [anon_sym_return] = ACTIONS(422),
    [anon_sym_revert] = ACTIONS(422),
    [sym_unchecked] = ACTIONS(422),
    [anon_sym_var] = ACTIONS(422),
    [anon_sym_else] = ACTIONS(422),
    [anon_sym_while] = ACTIONS(422),
    [anon_sym_do] = ACTIONS(422),
    [anon_sym_try] = ACTIONS(422),
    [anon_sym_catch] = ACTIONS(422),
    [anon_sym_emit] = ACTIONS(422),
    [anon_sym_payable] = ACTIONS(422),
    [anon_sym_new] = ACTIONS(422),
    [anon_sym_LBRACK] = ACTIONS(424),
    [anon_sym_delete] = ACTIONS(422),
    [anon_sym_BANG] = ACTIONS(424),
    [anon_sym_PLUS_PLUS] = ACTIONS(424),
    [anon_sym_DASH_DASH] = ACTIONS(424),
    [anon_sym_mapping] = ACTIONS(422),
    [anon_sym_bool] = ACTIONS(422),
    [anon_sym_string] = ACTIONS(422),
    [anon_sym_int] = ACTIONS(422),
    [anon_sym_int8] = ACTIONS(422),
    [anon_sym_int16] = ACTIONS(422),
    [anon_sym_int24] = ACTIONS(422),
    [anon_sym_int32] = ACTIONS(422),
    [anon_sym_int40] = ACTIONS(422),
    [anon_sym_int48] = ACTIONS(422),
    [anon_sym_int56] = ACTIONS(422),
    [anon_sym_int64] = ACTIONS(422),
    [anon_sym_int72] = ACTIONS(422),
    [anon_sym_int80] = ACTIONS(422),
    [anon_sym_int88] = ACTIONS(422),
    [anon_sym_int96] = ACTIONS(422),
    [anon_sym_int104] = ACTIONS(422),
    [anon_sym_int112] = ACTIONS(422),
    [anon_sym_int120] = ACTIONS(422),
    [anon_sym_int128] = ACTIONS(422),
    [anon_sym_int136] = ACTIONS(422),
    [anon_sym_int144] = ACTIONS(422),
    [anon_sym_int152] = ACTIONS(422),
    [anon_sym_int160] = ACTIONS(422),
    [anon_sym_int168] = ACTIONS(422),
    [anon_sym_int176] = ACTIONS(422),
    [anon_sym_int184] = ACTIONS(422),
    [anon_sym_int192] = ACTIONS(422),
    [anon_sym_int200] = ACTIONS(422),
    [anon_sym_int208] = ACTIONS(422),
    [anon_sym_int216] = ACTIONS(422),
    [anon_sym_int224] = ACTIONS(422),
    [anon_sym_int232] = ACTIONS(422),
    [anon_sym_int240] = ACTIONS(422),
    [anon_sym_int248] = ACTIONS(422),
    [anon_sym_int256] = ACTIONS(422),
    [anon_sym_uint] = ACTIONS(422),
    [anon_sym_uint8] = ACTIONS(422),
    [anon_sym_uint16] = ACTIONS(422),
    [anon_sym_uint24] = ACTIONS(422),
    [anon_sym_uint32] = ACTIONS(422),
    [anon_sym_uint40] = ACTIONS(422),
    [anon_sym_uint48] = ACTIONS(422),
    [anon_sym_uint56] = ACTIONS(422),
    [anon_sym_uint64] = ACTIONS(422),
    [anon_sym_uint72] = ACTIONS(422),
    [anon_sym_uint80] = ACTIONS(422),
    [anon_sym_uint88] = ACTIONS(422),
    [anon_sym_uint96] = ACTIONS(422),
    [anon_sym_uint104] = ACTIONS(422),
    [anon_sym_uint112] = ACTIONS(422),
    [anon_sym_uint120] = ACTIONS(422),
    [anon_sym_uint128] = ACTIONS(422),
    [anon_sym_uint136] = ACTIONS(422),
    [anon_sym_uint144] = ACTIONS(422),
    [anon_sym_uint152] = ACTIONS(422),
    [anon_sym_uint160] = ACTIONS(422),
    [anon_sym_uint168] = ACTIONS(422),
    [anon_sym_uint176] = ACTIONS(422),
    [anon_sym_uint184] = ACTIONS(422),
    [anon_sym_uint192] = ACTIONS(422),
    [anon_sym_uint200] = ACTIONS(422),
    [anon_sym_uint208] = ACTIONS(422),
    [anon_sym_uint216] = ACTIONS(422),
    [anon_sym_uint224] = ACTIONS(422),
    [anon_sym_uint232] = ACTIONS(422),
    [anon_sym_uint240] = ACTIONS(422),
    [anon_sym_uint248] = ACTIONS(422),
    [anon_sym_uint256] = ACTIONS(422),
    [anon_sym_bytes] = ACTIONS(422),
    [anon_sym_bytes1] = ACTIONS(422),
    [anon_sym_bytes2] = ACTIONS(422),
    [anon_sym_bytes3] = ACTIONS(422),
    [anon_sym_bytes4] = ACTIONS(422),
    [anon_sym_bytes5] = ACTIONS(422),
    [anon_sym_bytes6] = ACTIONS(422),
    [anon_sym_bytes7] = ACTIONS(422),
    [anon_sym_bytes8] = ACTIONS(422),
    [anon_sym_bytes9] = ACTIONS(422),
    [anon_sym_bytes10] = ACTIONS(422),
    [anon_sym_bytes11] = ACTIONS(422),
    [anon_sym_bytes12] = ACTIONS(422),
    [anon_sym_bytes13] = ACTIONS(422),
    [anon_sym_bytes14] = ACTIONS(422),
    [anon_sym_bytes15] = ACTIONS(422),
    [anon_sym_bytes16] = ACTIONS(422),
    [anon_sym_bytes17] = ACTIONS(422),
    [anon_sym_bytes18] = ACTIONS(422),
    [anon_sym_bytes19] = ACTIONS(422),
    [anon_sym_bytes20] = ACTIONS(422),
    [anon_sym_bytes21] = ACTIONS(422),
    [anon_sym_bytes22] = ACTIONS(422),
    [anon_sym_bytes23] = ACTIONS(422),
    [anon_sym_bytes24] = ACTIONS(422),
    [anon_sym_bytes25] = ACTIONS(422),
    [anon_sym_bytes26] = ACTIONS(422),
    [anon_sym_bytes27] = ACTIONS(422),
    [anon_sym_bytes28] = ACTIONS(422),
    [anon_sym_bytes29] = ACTIONS(422),
    [anon_sym_bytes30] = ACTIONS(422),
    [anon_sym_bytes31] = ACTIONS(422),
    [anon_sym_bytes32] = ACTIONS(422),
    [anon_sym_fixed] = ACTIONS(422),
    [aux_sym__fixed_token1] = ACTIONS(422),
    [anon_sym_ufixed] = ACTIONS(422),
    [aux_sym__ufixed_token1] = ACTIONS(422),
    [aux_sym__decimal_number_token1] = ACTIONS(422),
    [aux_sym__decimal_number_token2] = ACTIONS(424),
    [aux_sym__hex_number_token1] = ACTIONS(424),
    [anon_sym_hex] = ACTIONS(422),
    [anon_sym_DQUOTE] = ACTIONS(424),
    [anon_sym_SQUOTE] = ACTIONS(424),
    [anon_sym_unicode] = ACTIONS(422),
    [sym_comment] = ACTIONS(3),
  },
  [99] = {
    [sym_identifier] = ACTIONS(426),
    [anon_sym_DASH] = ACTIONS(426),
    [anon_sym_TILDE] = ACTIONS(428),
    [anon_sym_LBRACE] = ACTIONS(428),
    [anon_sym_RBRACE] = ACTIONS(428),
    [anon_sym_type] = ACTIONS(426),
    [anon_sym_LPAREN] = ACTIONS(428),
    [anon_sym_for] = ACTIONS(426),
    [anon_sym_assembly] = ACTIONS(426),
    [anon_sym_break] = ACTIONS(426),
    [anon_sym_continue] = ACTIONS(426),
    [anon_sym_true] = ACTIONS(426),
    [anon_sym_false] = ACTIONS(426),
    [anon_sym_if] = ACTIONS(426),
    [anon_sym_function] = ACTIONS(426),
    [anon_sym_byte] = ACTIONS(426),
    [anon_sym_address] = ACTIONS(426),
    [anon_sym_return] = ACTIONS(426),
    [anon_sym_revert] = ACTIONS(426),
    [sym_unchecked] = ACTIONS(426),
    [anon_sym_var] = ACTIONS(426),
    [anon_sym_else] = ACTIONS(426),
    [anon_sym_while] = ACTIONS(426),
    [anon_sym_do] = ACTIONS(426),
    [anon_sym_try] = ACTIONS(426),
    [anon_sym_catch] = ACTIONS(426),
    [anon_sym_emit] = ACTIONS(426),
    [anon_sym_payable] = ACTIONS(426),
    [anon_sym_new] = ACTIONS(426),
    [anon_sym_LBRACK] = ACTIONS(428),
    [anon_sym_delete] = ACTIONS(426),
    [anon_sym_BANG] = ACTIONS(428),
    [anon_sym_PLUS_PLUS] = ACTIONS(428),
    [anon_sym_DASH_DASH] = ACTIONS(428),
    [anon_sym_mapping] = ACTIONS(426),
    [anon_sym_bool] = ACTIONS(426),
    [anon_sym_string] = ACTIONS(426),
    [anon_sym_int] = ACTIONS(426),
    [anon_sym_int8] = ACTIONS(426),
    [anon_sym_int16] = ACTIONS(426),
    [anon_sym_int24] = ACTIONS(426),
    [anon_sym_int32] = ACTIONS(426),
    [anon_sym_int40] = ACTIONS(426),
    [anon_sym_int48] = ACTIONS(426),
    [anon_sym_int56] = ACTIONS(426),
    [anon_sym_int64] = ACTIONS(426),
    [anon_sym_int72] = ACTIONS(426),
    [anon_sym_int80] = ACTIONS(426),
    [anon_sym_int88] = ACTIONS(426),
    [anon_sym_int96] = ACTIONS(426),
    [anon_sym_int104] = ACTIONS(426),
    [anon_sym_int112] = ACTIONS(426),
    [anon_sym_int120] = ACTIONS(426),
    [anon_sym_int128] = ACTIONS(426),
    [anon_sym_int136] = ACTIONS(426),
    [anon_sym_int144] = ACTIONS(426),
    [anon_sym_int152] = ACTIONS(426),
    [anon_sym_int160] = ACTIONS(426),
    [anon_sym_int168] = ACTIONS(426),
    [anon_sym_int176] = ACTIONS(426),
    [anon_sym_int184] = ACTIONS(426),
    [anon_sym_int192] = ACTIONS(426),
    [anon_sym_int200] = ACTIONS(426),
    [anon_sym_int208] = ACTIONS(426),
    [anon_sym_int216] = ACTIONS(426),
    [anon_sym_int224] = ACTIONS(426),
    [anon_sym_int232] = ACTIONS(426),
    [anon_sym_int240] = ACTIONS(426),
    [anon_sym_int248] = ACTIONS(426),
    [anon_sym_int256] = ACTIONS(426),
    [anon_sym_uint] = ACTIONS(426),
    [anon_sym_uint8] = ACTIONS(426),
    [anon_sym_uint16] = ACTIONS(426),
    [anon_sym_uint24] = ACTIONS(426),
    [anon_sym_uint32] = ACTIONS(426),
    [anon_sym_uint40] = ACTIONS(426),
    [anon_sym_uint48] = ACTIONS(426),
    [anon_sym_uint56] = ACTIONS(426),
    [anon_sym_uint64] = ACTIONS(426),
    [anon_sym_uint72] = ACTIONS(426),
    [anon_sym_uint80] = ACTIONS(426),
    [anon_sym_uint88] = ACTIONS(426),
    [anon_sym_uint96] = ACTIONS(426),
    [anon_sym_uint104] = ACTIONS(426),
    [anon_sym_uint112] = ACTIONS(426),
    [anon_sym_uint120] = ACTIONS(426),
    [anon_sym_uint128] = ACTIONS(426),
    [anon_sym_uint136] = ACTIONS(426),
    [anon_sym_uint144] = ACTIONS(426),
    [anon_sym_uint152] = ACTIONS(426),
    [anon_sym_uint160] = ACTIONS(426),
    [anon_sym_uint168] = ACTIONS(426),
    [anon_sym_uint176] = ACTIONS(426),
    [anon_sym_uint184] = ACTIONS(426),
    [anon_sym_uint192] = ACTIONS(426),
    [anon_sym_uint200] = ACTIONS(426),
    [anon_sym_uint208] = ACTIONS(426),
    [anon_sym_uint216] = ACTIONS(426),
    [anon_sym_uint224] = ACTIONS(426),
    [anon_sym_uint232] = ACTIONS(426),
    [anon_sym_uint240] = ACTIONS(426),
    [anon_sym_uint248] = ACTIONS(426),
    [anon_sym_uint256] = ACTIONS(426),
    [anon_sym_bytes] = ACTIONS(426),
    [anon_sym_bytes1] = ACTIONS(426),
    [anon_sym_bytes2] = ACTIONS(426),
    [anon_sym_bytes3] = ACTIONS(426),
    [anon_sym_bytes4] = ACTIONS(426),
    [anon_sym_bytes5] = ACTIONS(426),
    [anon_sym_bytes6] = ACTIONS(426),
    [anon_sym_bytes7] = ACTIONS(426),
    [anon_sym_bytes8] = ACTIONS(426),
    [anon_sym_bytes9] = ACTIONS(426),
    [anon_sym_bytes10] = ACTIONS(426),
    [anon_sym_bytes11] = ACTIONS(426),
    [anon_sym_bytes12] = ACTIONS(426),
    [anon_sym_bytes13] = ACTIONS(426),
    [anon_sym_bytes14] = ACTIONS(426),
    [anon_sym_bytes15] = ACTIONS(426),
    [anon_sym_bytes16] = ACTIONS(426),
    [anon_sym_bytes17] = ACTIONS(426),
    [anon_sym_bytes18] = ACTIONS(426),
    [anon_sym_bytes19] = ACTIONS(426),
    [anon_sym_bytes20] = ACTIONS(426),
    [anon_sym_bytes21] = ACTIONS(426),
    [anon_sym_bytes22] = ACTIONS(426),
    [anon_sym_bytes23] = ACTIONS(426),
    [anon_sym_bytes24] = ACTIONS(426),
    [anon_sym_bytes25] = ACTIONS(426),
    [anon_sym_bytes26] = ACTIONS(426),
    [anon_sym_bytes27] = ACTIONS(426),
    [anon_sym_bytes28] = ACTIONS(426),
    [anon_sym_bytes29] = ACTIONS(426),
    [anon_sym_bytes30] = ACTIONS(426),
    [anon_sym_bytes31] = ACTIONS(426),
    [anon_sym_bytes32] = ACTIONS(426),
    [anon_sym_fixed] = ACTIONS(426),
    [aux_sym__fixed_token1] = ACTIONS(426),
    [anon_sym_ufixed] = ACTIONS(426),
    [aux_sym__ufixed_token1] = ACTIONS(426),
    [aux_sym__decimal_number_token1] = ACTIONS(426),
    [aux_sym__decimal_number_token2] = ACTIONS(428),
    [aux_sym__hex_number_token1] = ACTIONS(428),
    [anon_sym_hex] = ACTIONS(426),
    [anon_sym_DQUOTE] = ACTIONS(428),
    [anon_sym_SQUOTE] = ACTIONS(428),
    [anon_sym_unicode] = ACTIONS(426),
    [sym_comment] = ACTIONS(3),
  },
  [100] = {
    [sym_user_defined_type_definition] = STATE(100),
    [sym_error_declaration] = STATE(100),
    [sym__contract_member] = STATE(100),
    [sym_struct_declaration] = STATE(100),
    [sym_enum_declaration] = STATE(100),
    [sym_event_definition] = STATE(100),
    [sym_using_directive] = STATE(100),
    [sym_state_variable_declaration] = STATE(100),
    [sym_modifier_definition] = STATE(100),
    [sym_constructor_definition] = STATE(100),
    [sym_fallback_receive_definition] = STATE(100),
    [sym_function_definition] = STATE(100),
    [sym_type_name] = STATE(490),
    [sym__array_type] = STATE(345),
    [sym__function_type] = STATE(351),
    [sym_user_defined_type] = STATE(345),
    [sym__identifier_path] = STATE(336),
    [sym__mapping] = STATE(353),
    [sym_primitive_type] = STATE(345),
    [sym__int] = STATE(338),
    [sym__uint] = STATE(338),
    [sym__bytes] = STATE(338),
    [sym__fixed] = STATE(338),
    [sym__ufixed] = STATE(338),
    [aux_sym_contract_body_repeat1] = STATE(100),
    [sym_identifier] = ACTIONS(430),
    [anon_sym_RBRACE] = ACTIONS(433),
    [anon_sym_type] = ACTIONS(435),
    [anon_sym_error] = ACTIONS(438),
    [anon_sym_struct] = ACTIONS(441),
    [anon_sym_enum] = ACTIONS(444),
    [anon_sym_event] = ACTIONS(447),
    [anon_sym_using] = ACTIONS(450),
    [anon_sym_function] = ACTIONS(453),
    [anon_sym_byte] = ACTIONS(456),
    [anon_sym_address] = ACTIONS(459),
    [anon_sym_var] = ACTIONS(456),
    [anon_sym_modifier] = ACTIONS(462),
    [anon_sym_constructor] = ACTIONS(465),
    [anon_sym_fallback] = ACTIONS(468),
    [anon_sym_receive] = ACTIONS(468),
    [anon_sym_mapping] = ACTIONS(471),
    [anon_sym_bool] = ACTIONS(456),
    [anon_sym_string] = ACTIONS(456),
    [anon_sym_int] = ACTIONS(456),
    [anon_sym_int8] = ACTIONS(456),
    [anon_sym_int16] = ACTIONS(456),
    [anon_sym_int24] = ACTIONS(456),
    [anon_sym_int32] = ACTIONS(456),
    [anon_sym_int40] = ACTIONS(456),
    [anon_sym_int48] = ACTIONS(456),
    [anon_sym_int56] = ACTIONS(456),
    [anon_sym_int64] = ACTIONS(456),
    [anon_sym_int72] = ACTIONS(456),
    [anon_sym_int80] = ACTIONS(456),
    [anon_sym_int88] = ACTIONS(456),
    [anon_sym_int96] = ACTIONS(456),
    [anon_sym_int104] = ACTIONS(456),
    [anon_sym_int112] = ACTIONS(456),
    [anon_sym_int120] = ACTIONS(456),
    [anon_sym_int128] = ACTIONS(456),
    [anon_sym_int136] = ACTIONS(456),
    [anon_sym_int144] = ACTIONS(456),
    [anon_sym_int152] = ACTIONS(456),
    [anon_sym_int160] = ACTIONS(456),
    [anon_sym_int168] = ACTIONS(456),
    [anon_sym_int176] = ACTIONS(456),
    [anon_sym_int184] = ACTIONS(456),
    [anon_sym_int192] = ACTIONS(456),
    [anon_sym_int200] = ACTIONS(456),
    [anon_sym_int208] = ACTIONS(456),
    [anon_sym_int216] = ACTIONS(456),
    [anon_sym_int224] = ACTIONS(456),
    [anon_sym_int232] = ACTIONS(456),
    [anon_sym_int240] = ACTIONS(456),
    [anon_sym_int248] = ACTIONS(456),
    [anon_sym_int256] = ACTIONS(456),
    [anon_sym_uint] = ACTIONS(456),
    [anon_sym_uint8] = ACTIONS(456),
    [anon_sym_uint16] = ACTIONS(456),
    [anon_sym_uint24] = ACTIONS(456),
    [anon_sym_uint32] = ACTIONS(456),
    [anon_sym_uint40] = ACTIONS(456),
    [anon_sym_uint48] = ACTIONS(456),
    [anon_sym_uint56] = ACTIONS(456),
    [anon_sym_uint64] = ACTIONS(456),
    [anon_sym_uint72] = ACTIONS(456),
    [anon_sym_uint80] = ACTIONS(456),
    [anon_sym_uint88] = ACTIONS(456),
    [anon_sym_uint96] = ACTIONS(456),
    [anon_sym_uint104] = ACTIONS(456),
    [anon_sym_uint112] = ACTIONS(456),
    [anon_sym_uint120] = ACTIONS(456),
    [anon_sym_uint128] = ACTIONS(456),
    [anon_sym_uint136] = ACTIONS(456),
    [anon_sym_uint144] = ACTIONS(456),
    [anon_sym_uint152] = ACTIONS(456),
    [anon_sym_uint160] = ACTIONS(456),
    [anon_sym_uint168] = ACTIONS(456),
    [anon_sym_uint176] = ACTIONS(456),
    [anon_sym_uint184] = ACTIONS(456),
    [anon_sym_uint192] = ACTIONS(456),
    [anon_sym_uint200] = ACTIONS(456),
    [anon_sym_uint208] = ACTIONS(456),
    [anon_sym_uint216] = ACTIONS(456),
    [anon_sym_uint224] = ACTIONS(456),
    [anon_sym_uint232] = ACTIONS(456),
    [anon_sym_uint240] = ACTIONS(456),
    [anon_sym_uint248] = ACTIONS(456),
    [anon_sym_uint256] = ACTIONS(456),
    [anon_sym_bytes] = ACTIONS(456),
    [anon_sym_bytes1] = ACTIONS(456),
    [anon_sym_bytes2] = ACTIONS(456),
    [anon_sym_bytes3] = ACTIONS(456),
    [anon_sym_bytes4] = ACTIONS(456),
    [anon_sym_bytes5] = ACTIONS(456),
    [anon_sym_bytes6] = ACTIONS(456),
    [anon_sym_bytes7] = ACTIONS(456),
    [anon_sym_bytes8] = ACTIONS(456),
    [anon_sym_bytes9] = ACTIONS(456),
    [anon_sym_bytes10] = ACTIONS(456),
    [anon_sym_bytes11] = ACTIONS(456),
    [anon_sym_bytes12] = ACTIONS(456),
    [anon_sym_bytes13] = ACTIONS(456),
    [anon_sym_bytes14] = ACTIONS(456),
    [anon_sym_bytes15] = ACTIONS(456),
    [anon_sym_bytes16] = ACTIONS(456),
    [anon_sym_bytes17] = ACTIONS(456),
    [anon_sym_bytes18] = ACTIONS(456),
    [anon_sym_bytes19] = ACTIONS(456),
    [anon_sym_bytes20] = ACTIONS(456),
    [anon_sym_bytes21] = ACTIONS(456),
    [anon_sym_bytes22] = ACTIONS(456),
    [anon_sym_bytes23] = ACTIONS(456),
    [anon_sym_bytes24] = ACTIONS(456),
    [anon_sym_bytes25] = ACTIONS(456),
    [anon_sym_bytes26] = ACTIONS(456),
    [anon_sym_bytes27] = ACTIONS(456),
    [anon_sym_bytes28] = ACTIONS(456),
    [anon_sym_bytes29] = ACTIONS(456),
    [anon_sym_bytes30] = ACTIONS(456),
    [anon_sym_bytes31] = ACTIONS(456),
    [anon_sym_bytes32] = ACTIONS(456),
    [anon_sym_fixed] = ACTIONS(456),
    [aux_sym__fixed_token1] = ACTIONS(456),
    [anon_sym_ufixed] = ACTIONS(456),
    [aux_sym__ufixed_token1] = ACTIONS(456),
    [sym_comment] = ACTIONS(3),
  },
  [101] = {
    [sym_identifier] = ACTIONS(474),
    [anon_sym_DASH] = ACTIONS(474),
    [anon_sym_TILDE] = ACTIONS(476),
    [anon_sym_LBRACE] = ACTIONS(476),
    [anon_sym_RBRACE] = ACTIONS(476),
    [anon_sym_type] = ACTIONS(474),
    [anon_sym_LPAREN] = ACTIONS(476),
    [anon_sym_for] = ACTIONS(474),
    [anon_sym_assembly] = ACTIONS(474),
    [anon_sym_break] = ACTIONS(474),
    [anon_sym_continue] = ACTIONS(474),
    [anon_sym_true] = ACTIONS(474),
    [anon_sym_false] = ACTIONS(474),
    [anon_sym_if] = ACTIONS(474),
    [anon_sym_function] = ACTIONS(474),
    [anon_sym_byte] = ACTIONS(474),
    [anon_sym_address] = ACTIONS(474),
    [anon_sym_return] = ACTIONS(474),
    [anon_sym_revert] = ACTIONS(474),
    [sym_unchecked] = ACTIONS(474),
    [anon_sym_var] = ACTIONS(474),
    [anon_sym_else] = ACTIONS(474),
    [anon_sym_while] = ACTIONS(474),
    [anon_sym_do] = ACTIONS(474),
    [anon_sym_try] = ACTIONS(474),
    [anon_sym_catch] = ACTIONS(474),
    [anon_sym_emit] = ACTIONS(474),
    [anon_sym_payable] = ACTIONS(474),
    [anon_sym_new] = ACTIONS(474),
    [anon_sym_LBRACK] = ACTIONS(476),
    [anon_sym_delete] = ACTIONS(474),
    [anon_sym_BANG] = ACTIONS(476),
    [anon_sym_PLUS_PLUS] = ACTIONS(476),
    [anon_sym_DASH_DASH] = ACTIONS(476),
    [anon_sym_mapping] = ACTIONS(474),
    [anon_sym_bool] = ACTIONS(474),
    [anon_sym_string] = ACTIONS(474),
    [anon_sym_int] = ACTIONS(474),
    [anon_sym_int8] = ACTIONS(474),
    [anon_sym_int16] = ACTIONS(474),
    [anon_sym_int24] = ACTIONS(474),
    [anon_sym_int32] = ACTIONS(474),
    [anon_sym_int40] = ACTIONS(474),
    [anon_sym_int48] = ACTIONS(474),
    [anon_sym_int56] = ACTIONS(474),
    [anon_sym_int64] = ACTIONS(474),
    [anon_sym_int72] = ACTIONS(474),
    [anon_sym_int80] = ACTIONS(474),
    [anon_sym_int88] = ACTIONS(474),
    [anon_sym_int96] = ACTIONS(474),
    [anon_sym_int104] = ACTIONS(474),
    [anon_sym_int112] = ACTIONS(474),
    [anon_sym_int120] = ACTIONS(474),
    [anon_sym_int128] = ACTIONS(474),
    [anon_sym_int136] = ACTIONS(474),
    [anon_sym_int144] = ACTIONS(474),
    [anon_sym_int152] = ACTIONS(474),
    [anon_sym_int160] = ACTIONS(474),
    [anon_sym_int168] = ACTIONS(474),
    [anon_sym_int176] = ACTIONS(474),
    [anon_sym_int184] = ACTIONS(474),
    [anon_sym_int192] = ACTIONS(474),
    [anon_sym_int200] = ACTIONS(474),
    [anon_sym_int208] = ACTIONS(474),
    [anon_sym_int216] = ACTIONS(474),
    [anon_sym_int224] = ACTIONS(474),
    [anon_sym_int232] = ACTIONS(474),
    [anon_sym_int240] = ACTIONS(474),
    [anon_sym_int248] = ACTIONS(474),
    [anon_sym_int256] = ACTIONS(474),
    [anon_sym_uint] = ACTIONS(474),
    [anon_sym_uint8] = ACTIONS(474),
    [anon_sym_uint16] = ACTIONS(474),
    [anon_sym_uint24] = ACTIONS(474),
    [anon_sym_uint32] = ACTIONS(474),
    [anon_sym_uint40] = ACTIONS(474),
    [anon_sym_uint48] = ACTIONS(474),
    [anon_sym_uint56] = ACTIONS(474),
    [anon_sym_uint64] = ACTIONS(474),
    [anon_sym_uint72] = ACTIONS(474),
    [anon_sym_uint80] = ACTIONS(474),
    [anon_sym_uint88] = ACTIONS(474),
    [anon_sym_uint96] = ACTIONS(474),
    [anon_sym_uint104] = ACTIONS(474),
    [anon_sym_uint112] = ACTIONS(474),
    [anon_sym_uint120] = ACTIONS(474),
    [anon_sym_uint128] = ACTIONS(474),
    [anon_sym_uint136] = ACTIONS(474),
    [anon_sym_uint144] = ACTIONS(474),
    [anon_sym_uint152] = ACTIONS(474),
    [anon_sym_uint160] = ACTIONS(474),
    [anon_sym_uint168] = ACTIONS(474),
    [anon_sym_uint176] = ACTIONS(474),
    [anon_sym_uint184] = ACTIONS(474),
    [anon_sym_uint192] = ACTIONS(474),
    [anon_sym_uint200] = ACTIONS(474),
    [anon_sym_uint208] = ACTIONS(474),
    [anon_sym_uint216] = ACTIONS(474),
    [anon_sym_uint224] = ACTIONS(474),
    [anon_sym_uint232] = ACTIONS(474),
    [anon_sym_uint240] = ACTIONS(474),
    [anon_sym_uint248] = ACTIONS(474),
    [anon_sym_uint256] = ACTIONS(474),
    [anon_sym_bytes] = ACTIONS(474),
    [anon_sym_bytes1] = ACTIONS(474),
    [anon_sym_bytes2] = ACTIONS(474),
    [anon_sym_bytes3] = ACTIONS(474),
    [anon_sym_bytes4] = ACTIONS(474),
    [anon_sym_bytes5] = ACTIONS(474),
    [anon_sym_bytes6] = ACTIONS(474),
    [anon_sym_bytes7] = ACTIONS(474),
    [anon_sym_bytes8] = ACTIONS(474),
    [anon_sym_bytes9] = ACTIONS(474),
    [anon_sym_bytes10] = ACTIONS(474),
    [anon_sym_bytes11] = ACTIONS(474),
    [anon_sym_bytes12] = ACTIONS(474),
    [anon_sym_bytes13] = ACTIONS(474),
    [anon_sym_bytes14] = ACTIONS(474),
    [anon_sym_bytes15] = ACTIONS(474),
    [anon_sym_bytes16] = ACTIONS(474),
    [anon_sym_bytes17] = ACTIONS(474),
    [anon_sym_bytes18] = ACTIONS(474),
    [anon_sym_bytes19] = ACTIONS(474),
    [anon_sym_bytes20] = ACTIONS(474),
    [anon_sym_bytes21] = ACTIONS(474),
    [anon_sym_bytes22] = ACTIONS(474),
    [anon_sym_bytes23] = ACTIONS(474),
    [anon_sym_bytes24] = ACTIONS(474),
    [anon_sym_bytes25] = ACTIONS(474),
    [anon_sym_bytes26] = ACTIONS(474),
    [anon_sym_bytes27] = ACTIONS(474),
    [anon_sym_bytes28] = ACTIONS(474),
    [anon_sym_bytes29] = ACTIONS(474),
    [anon_sym_bytes30] = ACTIONS(474),
    [anon_sym_bytes31] = ACTIONS(474),
    [anon_sym_bytes32] = ACTIONS(474),
    [anon_sym_fixed] = ACTIONS(474),
    [aux_sym__fixed_token1] = ACTIONS(474),
    [anon_sym_ufixed] = ACTIONS(474),
    [aux_sym__ufixed_token1] = ACTIONS(474),
    [aux_sym__decimal_number_token1] = ACTIONS(474),
    [aux_sym__decimal_number_token2] = ACTIONS(476),
    [aux_sym__hex_number_token1] = ACTIONS(476),
    [anon_sym_hex] = ACTIONS(474),
    [anon_sym_DQUOTE] = ACTIONS(476),
    [anon_sym_SQUOTE] = ACTIONS(476),
    [anon_sym_unicode] = ACTIONS(474),
    [sym_comment] = ACTIONS(3),
  },
  [102] = {
    [sym_identifier] = ACTIONS(478),
    [anon_sym_DASH] = ACTIONS(478),
    [anon_sym_TILDE] = ACTIONS(480),
    [anon_sym_LBRACE] = ACTIONS(480),
    [anon_sym_RBRACE] = ACTIONS(480),
    [anon_sym_type] = ACTIONS(478),
    [anon_sym_LPAREN] = ACTIONS(480),
    [anon_sym_for] = ACTIONS(478),
    [anon_sym_assembly] = ACTIONS(478),
    [anon_sym_break] = ACTIONS(478),
    [anon_sym_continue] = ACTIONS(478),
    [anon_sym_true] = ACTIONS(478),
    [anon_sym_false] = ACTIONS(478),
    [anon_sym_if] = ACTIONS(478),
    [anon_sym_function] = ACTIONS(478),
    [anon_sym_byte] = ACTIONS(478),
    [anon_sym_address] = ACTIONS(478),
    [anon_sym_return] = ACTIONS(478),
    [anon_sym_revert] = ACTIONS(478),
    [sym_unchecked] = ACTIONS(478),
    [anon_sym_var] = ACTIONS(478),
    [anon_sym_else] = ACTIONS(478),
    [anon_sym_while] = ACTIONS(478),
    [anon_sym_do] = ACTIONS(478),
    [anon_sym_try] = ACTIONS(478),
    [anon_sym_catch] = ACTIONS(478),
    [anon_sym_emit] = ACTIONS(478),
    [anon_sym_payable] = ACTIONS(478),
    [anon_sym_new] = ACTIONS(478),
    [anon_sym_LBRACK] = ACTIONS(480),
    [anon_sym_delete] = ACTIONS(478),
    [anon_sym_BANG] = ACTIONS(480),
    [anon_sym_PLUS_PLUS] = ACTIONS(480),
    [anon_sym_DASH_DASH] = ACTIONS(480),
    [anon_sym_mapping] = ACTIONS(478),
    [anon_sym_bool] = ACTIONS(478),
    [anon_sym_string] = ACTIONS(478),
    [anon_sym_int] = ACTIONS(478),
    [anon_sym_int8] = ACTIONS(478),
    [anon_sym_int16] = ACTIONS(478),
    [anon_sym_int24] = ACTIONS(478),
    [anon_sym_int32] = ACTIONS(478),
    [anon_sym_int40] = ACTIONS(478),
    [anon_sym_int48] = ACTIONS(478),
    [anon_sym_int56] = ACTIONS(478),
    [anon_sym_int64] = ACTIONS(478),
    [anon_sym_int72] = ACTIONS(478),
    [anon_sym_int80] = ACTIONS(478),
    [anon_sym_int88] = ACTIONS(478),
    [anon_sym_int96] = ACTIONS(478),
    [anon_sym_int104] = ACTIONS(478),
    [anon_sym_int112] = ACTIONS(478),
    [anon_sym_int120] = ACTIONS(478),
    [anon_sym_int128] = ACTIONS(478),
    [anon_sym_int136] = ACTIONS(478),
    [anon_sym_int144] = ACTIONS(478),
    [anon_sym_int152] = ACTIONS(478),
    [anon_sym_int160] = ACTIONS(478),
    [anon_sym_int168] = ACTIONS(478),
    [anon_sym_int176] = ACTIONS(478),
    [anon_sym_int184] = ACTIONS(478),
    [anon_sym_int192] = ACTIONS(478),
    [anon_sym_int200] = ACTIONS(478),
    [anon_sym_int208] = ACTIONS(478),
    [anon_sym_int216] = ACTIONS(478),
    [anon_sym_int224] = ACTIONS(478),
    [anon_sym_int232] = ACTIONS(478),
    [anon_sym_int240] = ACTIONS(478),
    [anon_sym_int248] = ACTIONS(478),
    [anon_sym_int256] = ACTIONS(478),
    [anon_sym_uint] = ACTIONS(478),
    [anon_sym_uint8] = ACTIONS(478),
    [anon_sym_uint16] = ACTIONS(478),
    [anon_sym_uint24] = ACTIONS(478),
    [anon_sym_uint32] = ACTIONS(478),
    [anon_sym_uint40] = ACTIONS(478),
    [anon_sym_uint48] = ACTIONS(478),
    [anon_sym_uint56] = ACTIONS(478),
    [anon_sym_uint64] = ACTIONS(478),
    [anon_sym_uint72] = ACTIONS(478),
    [anon_sym_uint80] = ACTIONS(478),
    [anon_sym_uint88] = ACTIONS(478),
    [anon_sym_uint96] = ACTIONS(478),
    [anon_sym_uint104] = ACTIONS(478),
    [anon_sym_uint112] = ACTIONS(478),
    [anon_sym_uint120] = ACTIONS(478),
    [anon_sym_uint128] = ACTIONS(478),
    [anon_sym_uint136] = ACTIONS(478),
    [anon_sym_uint144] = ACTIONS(478),
    [anon_sym_uint152] = ACTIONS(478),
    [anon_sym_uint160] = ACTIONS(478),
    [anon_sym_uint168] = ACTIONS(478),
    [anon_sym_uint176] = ACTIONS(478),
    [anon_sym_uint184] = ACTIONS(478),
    [anon_sym_uint192] = ACTIONS(478),
    [anon_sym_uint200] = ACTIONS(478),
    [anon_sym_uint208] = ACTIONS(478),
    [anon_sym_uint216] = ACTIONS(478),
    [anon_sym_uint224] = ACTIONS(478),
    [anon_sym_uint232] = ACTIONS(478),
    [anon_sym_uint240] = ACTIONS(478),
    [anon_sym_uint248] = ACTIONS(478),
    [anon_sym_uint256] = ACTIONS(478),
    [anon_sym_bytes] = ACTIONS(478),
    [anon_sym_bytes1] = ACTIONS(478),
    [anon_sym_bytes2] = ACTIONS(478),
    [anon_sym_bytes3] = ACTIONS(478),
    [anon_sym_bytes4] = ACTIONS(478),
    [anon_sym_bytes5] = ACTIONS(478),
    [anon_sym_bytes6] = ACTIONS(478),
    [anon_sym_bytes7] = ACTIONS(478),
    [anon_sym_bytes8] = ACTIONS(478),
    [anon_sym_bytes9] = ACTIONS(478),
    [anon_sym_bytes10] = ACTIONS(478),
    [anon_sym_bytes11] = ACTIONS(478),
    [anon_sym_bytes12] = ACTIONS(478),
    [anon_sym_bytes13] = ACTIONS(478),
    [anon_sym_bytes14] = ACTIONS(478),
    [anon_sym_bytes15] = ACTIONS(478),
    [anon_sym_bytes16] = ACTIONS(478),
    [anon_sym_bytes17] = ACTIONS(478),
    [anon_sym_bytes18] = ACTIONS(478),
    [anon_sym_bytes19] = ACTIONS(478),
    [anon_sym_bytes20] = ACTIONS(478),
    [anon_sym_bytes21] = ACTIONS(478),
    [anon_sym_bytes22] = ACTIONS(478),
    [anon_sym_bytes23] = ACTIONS(478),
    [anon_sym_bytes24] = ACTIONS(478),
    [anon_sym_bytes25] = ACTIONS(478),
    [anon_sym_bytes26] = ACTIONS(478),
    [anon_sym_bytes27] = ACTIONS(478),
    [anon_sym_bytes28] = ACTIONS(478),
    [anon_sym_bytes29] = ACTIONS(478),
    [anon_sym_bytes30] = ACTIONS(478),
    [anon_sym_bytes31] = ACTIONS(478),
    [anon_sym_bytes32] = ACTIONS(478),
    [anon_sym_fixed] = ACTIONS(478),
    [aux_sym__fixed_token1] = ACTIONS(478),
    [anon_sym_ufixed] = ACTIONS(478),
    [aux_sym__ufixed_token1] = ACTIONS(478),
    [aux_sym__decimal_number_token1] = ACTIONS(478),
    [aux_sym__decimal_number_token2] = ACTIONS(480),
    [aux_sym__hex_number_token1] = ACTIONS(480),
    [anon_sym_hex] = ACTIONS(478),
    [anon_sym_DQUOTE] = ACTIONS(480),
    [anon_sym_SQUOTE] = ACTIONS(480),
    [anon_sym_unicode] = ACTIONS(478),
    [sym_comment] = ACTIONS(3),
  },
  [103] = {
    [sym_identifier] = ACTIONS(482),
    [anon_sym_DASH] = ACTIONS(482),
    [anon_sym_TILDE] = ACTIONS(484),
    [anon_sym_LBRACE] = ACTIONS(484),
    [anon_sym_RBRACE] = ACTIONS(484),
    [anon_sym_type] = ACTIONS(482),
    [anon_sym_LPAREN] = ACTIONS(484),
    [anon_sym_for] = ACTIONS(482),
    [anon_sym_assembly] = ACTIONS(482),
    [anon_sym_break] = ACTIONS(482),
    [anon_sym_continue] = ACTIONS(482),
    [anon_sym_true] = ACTIONS(482),
    [anon_sym_false] = ACTIONS(482),
    [anon_sym_if] = ACTIONS(482),
    [anon_sym_function] = ACTIONS(482),
    [anon_sym_byte] = ACTIONS(482),
    [anon_sym_address] = ACTIONS(482),
    [anon_sym_return] = ACTIONS(482),
    [anon_sym_revert] = ACTIONS(482),
    [sym_unchecked] = ACTIONS(482),
    [anon_sym_var] = ACTIONS(482),
    [anon_sym_else] = ACTIONS(482),
    [anon_sym_while] = ACTIONS(482),
    [anon_sym_do] = ACTIONS(482),
    [anon_sym_try] = ACTIONS(482),
    [anon_sym_catch] = ACTIONS(482),
    [anon_sym_emit] = ACTIONS(482),
    [anon_sym_payable] = ACTIONS(482),
    [anon_sym_new] = ACTIONS(482),
    [anon_sym_LBRACK] = ACTIONS(484),
    [anon_sym_delete] = ACTIONS(482),
    [anon_sym_BANG] = ACTIONS(484),
    [anon_sym_PLUS_PLUS] = ACTIONS(484),
    [anon_sym_DASH_DASH] = ACTIONS(484),
    [anon_sym_mapping] = ACTIONS(482),
    [anon_sym_bool] = ACTIONS(482),
    [anon_sym_string] = ACTIONS(482),
    [anon_sym_int] = ACTIONS(482),
    [anon_sym_int8] = ACTIONS(482),
    [anon_sym_int16] = ACTIONS(482),
    [anon_sym_int24] = ACTIONS(482),
    [anon_sym_int32] = ACTIONS(482),
    [anon_sym_int40] = ACTIONS(482),
    [anon_sym_int48] = ACTIONS(482),
    [anon_sym_int56] = ACTIONS(482),
    [anon_sym_int64] = ACTIONS(482),
    [anon_sym_int72] = ACTIONS(482),
    [anon_sym_int80] = ACTIONS(482),
    [anon_sym_int88] = ACTIONS(482),
    [anon_sym_int96] = ACTIONS(482),
    [anon_sym_int104] = ACTIONS(482),
    [anon_sym_int112] = ACTIONS(482),
    [anon_sym_int120] = ACTIONS(482),
    [anon_sym_int128] = ACTIONS(482),
    [anon_sym_int136] = ACTIONS(482),
    [anon_sym_int144] = ACTIONS(482),
    [anon_sym_int152] = ACTIONS(482),
    [anon_sym_int160] = ACTIONS(482),
    [anon_sym_int168] = ACTIONS(482),
    [anon_sym_int176] = ACTIONS(482),
    [anon_sym_int184] = ACTIONS(482),
    [anon_sym_int192] = ACTIONS(482),
    [anon_sym_int200] = ACTIONS(482),
    [anon_sym_int208] = ACTIONS(482),
    [anon_sym_int216] = ACTIONS(482),
    [anon_sym_int224] = ACTIONS(482),
    [anon_sym_int232] = ACTIONS(482),
    [anon_sym_int240] = ACTIONS(482),
    [anon_sym_int248] = ACTIONS(482),
    [anon_sym_int256] = ACTIONS(482),
    [anon_sym_uint] = ACTIONS(482),
    [anon_sym_uint8] = ACTIONS(482),
    [anon_sym_uint16] = ACTIONS(482),
    [anon_sym_uint24] = ACTIONS(482),
    [anon_sym_uint32] = ACTIONS(482),
    [anon_sym_uint40] = ACTIONS(482),
    [anon_sym_uint48] = ACTIONS(482),
    [anon_sym_uint56] = ACTIONS(482),
    [anon_sym_uint64] = ACTIONS(482),
    [anon_sym_uint72] = ACTIONS(482),
    [anon_sym_uint80] = ACTIONS(482),
    [anon_sym_uint88] = ACTIONS(482),
    [anon_sym_uint96] = ACTIONS(482),
    [anon_sym_uint104] = ACTIONS(482),
    [anon_sym_uint112] = ACTIONS(482),
    [anon_sym_uint120] = ACTIONS(482),
    [anon_sym_uint128] = ACTIONS(482),
    [anon_sym_uint136] = ACTIONS(482),
    [anon_sym_uint144] = ACTIONS(482),
    [anon_sym_uint152] = ACTIONS(482),
    [anon_sym_uint160] = ACTIONS(482),
    [anon_sym_uint168] = ACTIONS(482),
    [anon_sym_uint176] = ACTIONS(482),
    [anon_sym_uint184] = ACTIONS(482),
    [anon_sym_uint192] = ACTIONS(482),
    [anon_sym_uint200] = ACTIONS(482),
    [anon_sym_uint208] = ACTIONS(482),
    [anon_sym_uint216] = ACTIONS(482),
    [anon_sym_uint224] = ACTIONS(482),
    [anon_sym_uint232] = ACTIONS(482),
    [anon_sym_uint240] = ACTIONS(482),
    [anon_sym_uint248] = ACTIONS(482),
    [anon_sym_uint256] = ACTIONS(482),
    [anon_sym_bytes] = ACTIONS(482),
    [anon_sym_bytes1] = ACTIONS(482),
    [anon_sym_bytes2] = ACTIONS(482),
    [anon_sym_bytes3] = ACTIONS(482),
    [anon_sym_bytes4] = ACTIONS(482),
    [anon_sym_bytes5] = ACTIONS(482),
    [anon_sym_bytes6] = ACTIONS(482),
    [anon_sym_bytes7] = ACTIONS(482),
    [anon_sym_bytes8] = ACTIONS(482),
    [anon_sym_bytes9] = ACTIONS(482),
    [anon_sym_bytes10] = ACTIONS(482),
    [anon_sym_bytes11] = ACTIONS(482),
    [anon_sym_bytes12] = ACTIONS(482),
    [anon_sym_bytes13] = ACTIONS(482),
    [anon_sym_bytes14] = ACTIONS(482),
    [anon_sym_bytes15] = ACTIONS(482),
    [anon_sym_bytes16] = ACTIONS(482),
    [anon_sym_bytes17] = ACTIONS(482),
    [anon_sym_bytes18] = ACTIONS(482),
    [anon_sym_bytes19] = ACTIONS(482),
    [anon_sym_bytes20] = ACTIONS(482),
    [anon_sym_bytes21] = ACTIONS(482),
    [anon_sym_bytes22] = ACTIONS(482),
    [anon_sym_bytes23] = ACTIONS(482),
    [anon_sym_bytes24] = ACTIONS(482),
    [anon_sym_bytes25] = ACTIONS(482),
    [anon_sym_bytes26] = ACTIONS(482),
    [anon_sym_bytes27] = ACTIONS(482),
    [anon_sym_bytes28] = ACTIONS(482),
    [anon_sym_bytes29] = ACTIONS(482),
    [anon_sym_bytes30] = ACTIONS(482),
    [anon_sym_bytes31] = ACTIONS(482),
    [anon_sym_bytes32] = ACTIONS(482),
    [anon_sym_fixed] = ACTIONS(482),
    [aux_sym__fixed_token1] = ACTIONS(482),
    [anon_sym_ufixed] = ACTIONS(482),
    [aux_sym__ufixed_token1] = ACTIONS(482),
    [aux_sym__decimal_number_token1] = ACTIONS(482),
    [aux_sym__decimal_number_token2] = ACTIONS(484),
    [aux_sym__hex_number_token1] = ACTIONS(484),
    [anon_sym_hex] = ACTIONS(482),
    [anon_sym_DQUOTE] = ACTIONS(484),
    [anon_sym_SQUOTE] = ACTIONS(484),
    [anon_sym_unicode] = ACTIONS(482),
    [sym_comment] = ACTIONS(3),
  },
  [104] = {
    [sym_identifier] = ACTIONS(486),
    [anon_sym_DASH] = ACTIONS(486),
    [anon_sym_TILDE] = ACTIONS(488),
    [anon_sym_LBRACE] = ACTIONS(488),
    [anon_sym_RBRACE] = ACTIONS(488),
    [anon_sym_type] = ACTIONS(486),
    [anon_sym_LPAREN] = ACTIONS(488),
    [anon_sym_for] = ACTIONS(486),
    [anon_sym_assembly] = ACTIONS(486),
    [anon_sym_break] = ACTIONS(486),
    [anon_sym_continue] = ACTIONS(486),
    [anon_sym_true] = ACTIONS(486),
    [anon_sym_false] = ACTIONS(486),
    [anon_sym_if] = ACTIONS(486),
    [anon_sym_function] = ACTIONS(486),
    [anon_sym_byte] = ACTIONS(486),
    [anon_sym_address] = ACTIONS(486),
    [anon_sym_return] = ACTIONS(486),
    [anon_sym_revert] = ACTIONS(486),
    [sym_unchecked] = ACTIONS(486),
    [anon_sym_var] = ACTIONS(486),
    [anon_sym_else] = ACTIONS(486),
    [anon_sym_while] = ACTIONS(486),
    [anon_sym_do] = ACTIONS(486),
    [anon_sym_try] = ACTIONS(486),
    [anon_sym_emit] = ACTIONS(486),
    [anon_sym_payable] = ACTIONS(486),
    [anon_sym_new] = ACTIONS(486),
    [anon_sym_LBRACK] = ACTIONS(488),
    [anon_sym_delete] = ACTIONS(486),
    [anon_sym_BANG] = ACTIONS(488),
    [anon_sym_PLUS_PLUS] = ACTIONS(488),
    [anon_sym_DASH_DASH] = ACTIONS(488),
    [anon_sym_mapping] = ACTIONS(486),
    [anon_sym_bool] = ACTIONS(486),
    [anon_sym_string] = ACTIONS(486),
    [anon_sym_int] = ACTIONS(486),
    [anon_sym_int8] = ACTIONS(486),
    [anon_sym_int16] = ACTIONS(486),
    [anon_sym_int24] = ACTIONS(486),
    [anon_sym_int32] = ACTIONS(486),
    [anon_sym_int40] = ACTIONS(486),
    [anon_sym_int48] = ACTIONS(486),
    [anon_sym_int56] = ACTIONS(486),
    [anon_sym_int64] = ACTIONS(486),
    [anon_sym_int72] = ACTIONS(486),
    [anon_sym_int80] = ACTIONS(486),
    [anon_sym_int88] = ACTIONS(486),
    [anon_sym_int96] = ACTIONS(486),
    [anon_sym_int104] = ACTIONS(486),
    [anon_sym_int112] = ACTIONS(486),
    [anon_sym_int120] = ACTIONS(486),
    [anon_sym_int128] = ACTIONS(486),
    [anon_sym_int136] = ACTIONS(486),
    [anon_sym_int144] = ACTIONS(486),
    [anon_sym_int152] = ACTIONS(486),
    [anon_sym_int160] = ACTIONS(486),
    [anon_sym_int168] = ACTIONS(486),
    [anon_sym_int176] = ACTIONS(486),
    [anon_sym_int184] = ACTIONS(486),
    [anon_sym_int192] = ACTIONS(486),
    [anon_sym_int200] = ACTIONS(486),
    [anon_sym_int208] = ACTIONS(486),
    [anon_sym_int216] = ACTIONS(486),
    [anon_sym_int224] = ACTIONS(486),
    [anon_sym_int232] = ACTIONS(486),
    [anon_sym_int240] = ACTIONS(486),
    [anon_sym_int248] = ACTIONS(486),
    [anon_sym_int256] = ACTIONS(486),
    [anon_sym_uint] = ACTIONS(486),
    [anon_sym_uint8] = ACTIONS(486),
    [anon_sym_uint16] = ACTIONS(486),
    [anon_sym_uint24] = ACTIONS(486),
    [anon_sym_uint32] = ACTIONS(486),
    [anon_sym_uint40] = ACTIONS(486),
    [anon_sym_uint48] = ACTIONS(486),
    [anon_sym_uint56] = ACTIONS(486),
    [anon_sym_uint64] = ACTIONS(486),
    [anon_sym_uint72] = ACTIONS(486),
    [anon_sym_uint80] = ACTIONS(486),
    [anon_sym_uint88] = ACTIONS(486),
    [anon_sym_uint96] = ACTIONS(486),
    [anon_sym_uint104] = ACTIONS(486),
    [anon_sym_uint112] = ACTIONS(486),
    [anon_sym_uint120] = ACTIONS(486),
    [anon_sym_uint128] = ACTIONS(486),
    [anon_sym_uint136] = ACTIONS(486),
    [anon_sym_uint144] = ACTIONS(486),
    [anon_sym_uint152] = ACTIONS(486),
    [anon_sym_uint160] = ACTIONS(486),
    [anon_sym_uint168] = ACTIONS(486),
    [anon_sym_uint176] = ACTIONS(486),
    [anon_sym_uint184] = ACTIONS(486),
    [anon_sym_uint192] = ACTIONS(486),
    [anon_sym_uint200] = ACTIONS(486),
    [anon_sym_uint208] = ACTIONS(486),
    [anon_sym_uint216] = ACTIONS(486),
    [anon_sym_uint224] = ACTIONS(486),
    [anon_sym_uint232] = ACTIONS(486),
    [anon_sym_uint240] = ACTIONS(486),
    [anon_sym_uint248] = ACTIONS(486),
    [anon_sym_uint256] = ACTIONS(486),
    [anon_sym_bytes] = ACTIONS(486),
    [anon_sym_bytes1] = ACTIONS(486),
    [anon_sym_bytes2] = ACTIONS(486),
    [anon_sym_bytes3] = ACTIONS(486),
    [anon_sym_bytes4] = ACTIONS(486),
    [anon_sym_bytes5] = ACTIONS(486),
    [anon_sym_bytes6] = ACTIONS(486),
    [anon_sym_bytes7] = ACTIONS(486),
    [anon_sym_bytes8] = ACTIONS(486),
    [anon_sym_bytes9] = ACTIONS(486),
    [anon_sym_bytes10] = ACTIONS(486),
    [anon_sym_bytes11] = ACTIONS(486),
    [anon_sym_bytes12] = ACTIONS(486),
    [anon_sym_bytes13] = ACTIONS(486),
    [anon_sym_bytes14] = ACTIONS(486),
    [anon_sym_bytes15] = ACTIONS(486),
    [anon_sym_bytes16] = ACTIONS(486),
    [anon_sym_bytes17] = ACTIONS(486),
    [anon_sym_bytes18] = ACTIONS(486),
    [anon_sym_bytes19] = ACTIONS(486),
    [anon_sym_bytes20] = ACTIONS(486),
    [anon_sym_bytes21] = ACTIONS(486),
    [anon_sym_bytes22] = ACTIONS(486),
    [anon_sym_bytes23] = ACTIONS(486),
    [anon_sym_bytes24] = ACTIONS(486),
    [anon_sym_bytes25] = ACTIONS(486),
    [anon_sym_bytes26] = ACTIONS(486),
    [anon_sym_bytes27] = ACTIONS(486),
    [anon_sym_bytes28] = ACTIONS(486),
    [anon_sym_bytes29] = ACTIONS(486),
    [anon_sym_bytes30] = ACTIONS(486),
    [anon_sym_bytes31] = ACTIONS(486),
    [anon_sym_bytes32] = ACTIONS(486),
    [anon_sym_fixed] = ACTIONS(486),
    [aux_sym__fixed_token1] = ACTIONS(486),
    [anon_sym_ufixed] = ACTIONS(486),
    [aux_sym__ufixed_token1] = ACTIONS(486),
    [aux_sym__decimal_number_token1] = ACTIONS(486),
    [aux_sym__decimal_number_token2] = ACTIONS(488),
    [aux_sym__hex_number_token1] = ACTIONS(488),
    [anon_sym_hex] = ACTIONS(486),
    [anon_sym_DQUOTE] = ACTIONS(488),
    [anon_sym_SQUOTE] = ACTIONS(488),
    [anon_sym_unicode] = ACTIONS(486),
    [sym_comment] = ACTIONS(3),
  },
  [105] = {
    [sym_identifier] = ACTIONS(490),
    [anon_sym_DASH] = ACTIONS(490),
    [anon_sym_TILDE] = ACTIONS(492),
    [anon_sym_LBRACE] = ACTIONS(492),
    [anon_sym_RBRACE] = ACTIONS(492),
    [anon_sym_type] = ACTIONS(490),
    [anon_sym_LPAREN] = ACTIONS(492),
    [anon_sym_for] = ACTIONS(490),
    [anon_sym_assembly] = ACTIONS(490),
    [anon_sym_break] = ACTIONS(490),
    [anon_sym_continue] = ACTIONS(490),
    [anon_sym_true] = ACTIONS(490),
    [anon_sym_false] = ACTIONS(490),
    [anon_sym_if] = ACTIONS(490),
    [anon_sym_function] = ACTIONS(490),
    [anon_sym_byte] = ACTIONS(490),
    [anon_sym_address] = ACTIONS(490),
    [anon_sym_return] = ACTIONS(490),
    [anon_sym_revert] = ACTIONS(490),
    [sym_unchecked] = ACTIONS(490),
    [anon_sym_var] = ACTIONS(490),
    [anon_sym_else] = ACTIONS(490),
    [anon_sym_while] = ACTIONS(490),
    [anon_sym_do] = ACTIONS(490),
    [anon_sym_try] = ACTIONS(490),
    [anon_sym_emit] = ACTIONS(490),
    [anon_sym_payable] = ACTIONS(490),
    [anon_sym_new] = ACTIONS(490),
    [anon_sym_LBRACK] = ACTIONS(492),
    [anon_sym_delete] = ACTIONS(490),
    [anon_sym_BANG] = ACTIONS(492),
    [anon_sym_PLUS_PLUS] = ACTIONS(492),
    [anon_sym_DASH_DASH] = ACTIONS(492),
    [anon_sym_mapping] = ACTIONS(490),
    [anon_sym_bool] = ACTIONS(490),
    [anon_sym_string] = ACTIONS(490),
    [anon_sym_int] = ACTIONS(490),
    [anon_sym_int8] = ACTIONS(490),
    [anon_sym_int16] = ACTIONS(490),
    [anon_sym_int24] = ACTIONS(490),
    [anon_sym_int32] = ACTIONS(490),
    [anon_sym_int40] = ACTIONS(490),
    [anon_sym_int48] = ACTIONS(490),
    [anon_sym_int56] = ACTIONS(490),
    [anon_sym_int64] = ACTIONS(490),
    [anon_sym_int72] = ACTIONS(490),
    [anon_sym_int80] = ACTIONS(490),
    [anon_sym_int88] = ACTIONS(490),
    [anon_sym_int96] = ACTIONS(490),
    [anon_sym_int104] = ACTIONS(490),
    [anon_sym_int112] = ACTIONS(490),
    [anon_sym_int120] = ACTIONS(490),
    [anon_sym_int128] = ACTIONS(490),
    [anon_sym_int136] = ACTIONS(490),
    [anon_sym_int144] = ACTIONS(490),
    [anon_sym_int152] = ACTIONS(490),
    [anon_sym_int160] = ACTIONS(490),
    [anon_sym_int168] = ACTIONS(490),
    [anon_sym_int176] = ACTIONS(490),
    [anon_sym_int184] = ACTIONS(490),
    [anon_sym_int192] = ACTIONS(490),
    [anon_sym_int200] = ACTIONS(490),
    [anon_sym_int208] = ACTIONS(490),
    [anon_sym_int216] = ACTIONS(490),
    [anon_sym_int224] = ACTIONS(490),
    [anon_sym_int232] = ACTIONS(490),
    [anon_sym_int240] = ACTIONS(490),
    [anon_sym_int248] = ACTIONS(490),
    [anon_sym_int256] = ACTIONS(490),
    [anon_sym_uint] = ACTIONS(490),
    [anon_sym_uint8] = ACTIONS(490),
    [anon_sym_uint16] = ACTIONS(490),
    [anon_sym_uint24] = ACTIONS(490),
    [anon_sym_uint32] = ACTIONS(490),
    [anon_sym_uint40] = ACTIONS(490),
    [anon_sym_uint48] = ACTIONS(490),
    [anon_sym_uint56] = ACTIONS(490),
    [anon_sym_uint64] = ACTIONS(490),
    [anon_sym_uint72] = ACTIONS(490),
    [anon_sym_uint80] = ACTIONS(490),
    [anon_sym_uint88] = ACTIONS(490),
    [anon_sym_uint96] = ACTIONS(490),
    [anon_sym_uint104] = ACTIONS(490),
    [anon_sym_uint112] = ACTIONS(490),
    [anon_sym_uint120] = ACTIONS(490),
    [anon_sym_uint128] = ACTIONS(490),
    [anon_sym_uint136] = ACTIONS(490),
    [anon_sym_uint144] = ACTIONS(490),
    [anon_sym_uint152] = ACTIONS(490),
    [anon_sym_uint160] = ACTIONS(490),
    [anon_sym_uint168] = ACTIONS(490),
    [anon_sym_uint176] = ACTIONS(490),
    [anon_sym_uint184] = ACTIONS(490),
    [anon_sym_uint192] = ACTIONS(490),
    [anon_sym_uint200] = ACTIONS(490),
    [anon_sym_uint208] = ACTIONS(490),
    [anon_sym_uint216] = ACTIONS(490),
    [anon_sym_uint224] = ACTIONS(490),
    [anon_sym_uint232] = ACTIONS(490),
    [anon_sym_uint240] = ACTIONS(490),
    [anon_sym_uint248] = ACTIONS(490),
    [anon_sym_uint256] = ACTIONS(490),
    [anon_sym_bytes] = ACTIONS(490),
    [anon_sym_bytes1] = ACTIONS(490),
    [anon_sym_bytes2] = ACTIONS(490),
    [anon_sym_bytes3] = ACTIONS(490),
    [anon_sym_bytes4] = ACTIONS(490),
    [anon_sym_bytes5] = ACTIONS(490),
    [anon_sym_bytes6] = ACTIONS(490),
    [anon_sym_bytes7] = ACTIONS(490),
    [anon_sym_bytes8] = ACTIONS(490),
    [anon_sym_bytes9] = ACTIONS(490),
    [anon_sym_bytes10] = ACTIONS(490),
    [anon_sym_bytes11] = ACTIONS(490),
    [anon_sym_bytes12] = ACTIONS(490),
    [anon_sym_bytes13] = ACTIONS(490),
    [anon_sym_bytes14] = ACTIONS(490),
    [anon_sym_bytes15] = ACTIONS(490),
    [anon_sym_bytes16] = ACTIONS(490),
    [anon_sym_bytes17] = ACTIONS(490),
    [anon_sym_bytes18] = ACTIONS(490),
    [anon_sym_bytes19] = ACTIONS(490),
    [anon_sym_bytes20] = ACTIONS(490),
    [anon_sym_bytes21] = ACTIONS(490),
    [anon_sym_bytes22] = ACTIONS(490),
    [anon_sym_bytes23] = ACTIONS(490),
    [anon_sym_bytes24] = ACTIONS(490),
    [anon_sym_bytes25] = ACTIONS(490),
    [anon_sym_bytes26] = ACTIONS(490),
    [anon_sym_bytes27] = ACTIONS(490),
    [anon_sym_bytes28] = ACTIONS(490),
    [anon_sym_bytes29] = ACTIONS(490),
    [anon_sym_bytes30] = ACTIONS(490),
    [anon_sym_bytes31] = ACTIONS(490),
    [anon_sym_bytes32] = ACTIONS(490),
    [anon_sym_fixed] = ACTIONS(490),
    [aux_sym__fixed_token1] = ACTIONS(490),
    [anon_sym_ufixed] = ACTIONS(490),
    [aux_sym__ufixed_token1] = ACTIONS(490),
    [aux_sym__decimal_number_token1] = ACTIONS(490),
    [aux_sym__decimal_number_token2] = ACTIONS(492),
    [aux_sym__hex_number_token1] = ACTIONS(492),
    [anon_sym_hex] = ACTIONS(490),
    [anon_sym_DQUOTE] = ACTIONS(492),
    [anon_sym_SQUOTE] = ACTIONS(492),
    [anon_sym_unicode] = ACTIONS(490),
    [sym_comment] = ACTIONS(3),
  },
  [106] = {
    [sym_identifier] = ACTIONS(494),
    [anon_sym_DASH] = ACTIONS(494),
    [anon_sym_TILDE] = ACTIONS(496),
    [anon_sym_LBRACE] = ACTIONS(496),
    [anon_sym_RBRACE] = ACTIONS(496),
    [anon_sym_type] = ACTIONS(494),
    [anon_sym_LPAREN] = ACTIONS(496),
    [anon_sym_for] = ACTIONS(494),
    [anon_sym_assembly] = ACTIONS(494),
    [anon_sym_break] = ACTIONS(494),
    [anon_sym_continue] = ACTIONS(494),
    [anon_sym_true] = ACTIONS(494),
    [anon_sym_false] = ACTIONS(494),
    [anon_sym_if] = ACTIONS(494),
    [anon_sym_function] = ACTIONS(494),
    [anon_sym_byte] = ACTIONS(494),
    [anon_sym_address] = ACTIONS(494),
    [anon_sym_return] = ACTIONS(494),
    [anon_sym_revert] = ACTIONS(494),
    [sym_unchecked] = ACTIONS(494),
    [anon_sym_var] = ACTIONS(494),
    [anon_sym_else] = ACTIONS(494),
    [anon_sym_while] = ACTIONS(494),
    [anon_sym_do] = ACTIONS(494),
    [anon_sym_try] = ACTIONS(494),
    [anon_sym_emit] = ACTIONS(494),
    [anon_sym_payable] = ACTIONS(494),
    [anon_sym_new] = ACTIONS(494),
    [anon_sym_LBRACK] = ACTIONS(496),
    [anon_sym_delete] = ACTIONS(494),
    [anon_sym_BANG] = ACTIONS(496),
    [anon_sym_PLUS_PLUS] = ACTIONS(496),
    [anon_sym_DASH_DASH] = ACTIONS(496),
    [anon_sym_mapping] = ACTIONS(494),
    [anon_sym_bool] = ACTIONS(494),
    [anon_sym_string] = ACTIONS(494),
    [anon_sym_int] = ACTIONS(494),
    [anon_sym_int8] = ACTIONS(494),
    [anon_sym_int16] = ACTIONS(494),
    [anon_sym_int24] = ACTIONS(494),
    [anon_sym_int32] = ACTIONS(494),
    [anon_sym_int40] = ACTIONS(494),
    [anon_sym_int48] = ACTIONS(494),
    [anon_sym_int56] = ACTIONS(494),
    [anon_sym_int64] = ACTIONS(494),
    [anon_sym_int72] = ACTIONS(494),
    [anon_sym_int80] = ACTIONS(494),
    [anon_sym_int88] = ACTIONS(494),
    [anon_sym_int96] = ACTIONS(494),
    [anon_sym_int104] = ACTIONS(494),
    [anon_sym_int112] = ACTIONS(494),
    [anon_sym_int120] = ACTIONS(494),
    [anon_sym_int128] = ACTIONS(494),
    [anon_sym_int136] = ACTIONS(494),
    [anon_sym_int144] = ACTIONS(494),
    [anon_sym_int152] = ACTIONS(494),
    [anon_sym_int160] = ACTIONS(494),
    [anon_sym_int168] = ACTIONS(494),
    [anon_sym_int176] = ACTIONS(494),
    [anon_sym_int184] = ACTIONS(494),
    [anon_sym_int192] = ACTIONS(494),
    [anon_sym_int200] = ACTIONS(494),
    [anon_sym_int208] = ACTIONS(494),
    [anon_sym_int216] = ACTIONS(494),
    [anon_sym_int224] = ACTIONS(494),
    [anon_sym_int232] = ACTIONS(494),
    [anon_sym_int240] = ACTIONS(494),
    [anon_sym_int248] = ACTIONS(494),
    [anon_sym_int256] = ACTIONS(494),
    [anon_sym_uint] = ACTIONS(494),
    [anon_sym_uint8] = ACTIONS(494),
    [anon_sym_uint16] = ACTIONS(494),
    [anon_sym_uint24] = ACTIONS(494),
    [anon_sym_uint32] = ACTIONS(494),
    [anon_sym_uint40] = ACTIONS(494),
    [anon_sym_uint48] = ACTIONS(494),
    [anon_sym_uint56] = ACTIONS(494),
    [anon_sym_uint64] = ACTIONS(494),
    [anon_sym_uint72] = ACTIONS(494),
    [anon_sym_uint80] = ACTIONS(494),
    [anon_sym_uint88] = ACTIONS(494),
    [anon_sym_uint96] = ACTIONS(494),
    [anon_sym_uint104] = ACTIONS(494),
    [anon_sym_uint112] = ACTIONS(494),
    [anon_sym_uint120] = ACTIONS(494),
    [anon_sym_uint128] = ACTIONS(494),
    [anon_sym_uint136] = ACTIONS(494),
    [anon_sym_uint144] = ACTIONS(494),
    [anon_sym_uint152] = ACTIONS(494),
    [anon_sym_uint160] = ACTIONS(494),
    [anon_sym_uint168] = ACTIONS(494),
    [anon_sym_uint176] = ACTIONS(494),
    [anon_sym_uint184] = ACTIONS(494),
    [anon_sym_uint192] = ACTIONS(494),
    [anon_sym_uint200] = ACTIONS(494),
    [anon_sym_uint208] = ACTIONS(494),
    [anon_sym_uint216] = ACTIONS(494),
    [anon_sym_uint224] = ACTIONS(494),
    [anon_sym_uint232] = ACTIONS(494),
    [anon_sym_uint240] = ACTIONS(494),
    [anon_sym_uint248] = ACTIONS(494),
    [anon_sym_uint256] = ACTIONS(494),
    [anon_sym_bytes] = ACTIONS(494),
    [anon_sym_bytes1] = ACTIONS(494),
    [anon_sym_bytes2] = ACTIONS(494),
    [anon_sym_bytes3] = ACTIONS(494),
    [anon_sym_bytes4] = ACTIONS(494),
    [anon_sym_bytes5] = ACTIONS(494),
    [anon_sym_bytes6] = ACTIONS(494),
    [anon_sym_bytes7] = ACTIONS(494),
    [anon_sym_bytes8] = ACTIONS(494),
    [anon_sym_bytes9] = ACTIONS(494),
    [anon_sym_bytes10] = ACTIONS(494),
    [anon_sym_bytes11] = ACTIONS(494),
    [anon_sym_bytes12] = ACTIONS(494),
    [anon_sym_bytes13] = ACTIONS(494),
    [anon_sym_bytes14] = ACTIONS(494),
    [anon_sym_bytes15] = ACTIONS(494),
    [anon_sym_bytes16] = ACTIONS(494),
    [anon_sym_bytes17] = ACTIONS(494),
    [anon_sym_bytes18] = ACTIONS(494),
    [anon_sym_bytes19] = ACTIONS(494),
    [anon_sym_bytes20] = ACTIONS(494),
    [anon_sym_bytes21] = ACTIONS(494),
    [anon_sym_bytes22] = ACTIONS(494),
    [anon_sym_bytes23] = ACTIONS(494),
    [anon_sym_bytes24] = ACTIONS(494),
    [anon_sym_bytes25] = ACTIONS(494),
    [anon_sym_bytes26] = ACTIONS(494),
    [anon_sym_bytes27] = ACTIONS(494),
    [anon_sym_bytes28] = ACTIONS(494),
    [anon_sym_bytes29] = ACTIONS(494),
    [anon_sym_bytes30] = ACTIONS(494),
    [anon_sym_bytes31] = ACTIONS(494),
    [anon_sym_bytes32] = ACTIONS(494),
    [anon_sym_fixed] = ACTIONS(494),
    [aux_sym__fixed_token1] = ACTIONS(494),
    [anon_sym_ufixed] = ACTIONS(494),
    [aux_sym__ufixed_token1] = ACTIONS(494),
    [aux_sym__decimal_number_token1] = ACTIONS(494),
    [aux_sym__decimal_number_token2] = ACTIONS(496),
    [aux_sym__hex_number_token1] = ACTIONS(496),
    [anon_sym_hex] = ACTIONS(494),
    [anon_sym_DQUOTE] = ACTIONS(496),
    [anon_sym_SQUOTE] = ACTIONS(496),
    [anon_sym_unicode] = ACTIONS(494),
    [sym_comment] = ACTIONS(3),
  },
  [107] = {
    [sym_identifier] = ACTIONS(498),
    [anon_sym_DASH] = ACTIONS(498),
    [anon_sym_TILDE] = ACTIONS(500),
    [anon_sym_LBRACE] = ACTIONS(500),
    [anon_sym_RBRACE] = ACTIONS(500),
    [anon_sym_type] = ACTIONS(498),
    [anon_sym_LPAREN] = ACTIONS(500),
    [anon_sym_for] = ACTIONS(498),
    [anon_sym_assembly] = ACTIONS(498),
    [anon_sym_break] = ACTIONS(498),
    [anon_sym_continue] = ACTIONS(498),
    [anon_sym_true] = ACTIONS(498),
    [anon_sym_false] = ACTIONS(498),
    [anon_sym_if] = ACTIONS(498),
    [anon_sym_function] = ACTIONS(498),
    [anon_sym_byte] = ACTIONS(498),
    [anon_sym_address] = ACTIONS(498),
    [anon_sym_return] = ACTIONS(498),
    [anon_sym_revert] = ACTIONS(498),
    [sym_unchecked] = ACTIONS(498),
    [anon_sym_var] = ACTIONS(498),
    [anon_sym_else] = ACTIONS(498),
    [anon_sym_while] = ACTIONS(498),
    [anon_sym_do] = ACTIONS(498),
    [anon_sym_try] = ACTIONS(498),
    [anon_sym_emit] = ACTIONS(498),
    [anon_sym_payable] = ACTIONS(498),
    [anon_sym_new] = ACTIONS(498),
    [anon_sym_LBRACK] = ACTIONS(500),
    [anon_sym_delete] = ACTIONS(498),
    [anon_sym_BANG] = ACTIONS(500),
    [anon_sym_PLUS_PLUS] = ACTIONS(500),
    [anon_sym_DASH_DASH] = ACTIONS(500),
    [anon_sym_mapping] = ACTIONS(498),
    [anon_sym_bool] = ACTIONS(498),
    [anon_sym_string] = ACTIONS(498),
    [anon_sym_int] = ACTIONS(498),
    [anon_sym_int8] = ACTIONS(498),
    [anon_sym_int16] = ACTIONS(498),
    [anon_sym_int24] = ACTIONS(498),
    [anon_sym_int32] = ACTIONS(498),
    [anon_sym_int40] = ACTIONS(498),
    [anon_sym_int48] = ACTIONS(498),
    [anon_sym_int56] = ACTIONS(498),
    [anon_sym_int64] = ACTIONS(498),
    [anon_sym_int72] = ACTIONS(498),
    [anon_sym_int80] = ACTIONS(498),
    [anon_sym_int88] = ACTIONS(498),
    [anon_sym_int96] = ACTIONS(498),
    [anon_sym_int104] = ACTIONS(498),
    [anon_sym_int112] = ACTIONS(498),
    [anon_sym_int120] = ACTIONS(498),
    [anon_sym_int128] = ACTIONS(498),
    [anon_sym_int136] = ACTIONS(498),
    [anon_sym_int144] = ACTIONS(498),
    [anon_sym_int152] = ACTIONS(498),
    [anon_sym_int160] = ACTIONS(498),
    [anon_sym_int168] = ACTIONS(498),
    [anon_sym_int176] = ACTIONS(498),
    [anon_sym_int184] = ACTIONS(498),
    [anon_sym_int192] = ACTIONS(498),
    [anon_sym_int200] = ACTIONS(498),
    [anon_sym_int208] = ACTIONS(498),
    [anon_sym_int216] = ACTIONS(498),
    [anon_sym_int224] = ACTIONS(498),
    [anon_sym_int232] = ACTIONS(498),
    [anon_sym_int240] = ACTIONS(498),
    [anon_sym_int248] = ACTIONS(498),
    [anon_sym_int256] = ACTIONS(498),
    [anon_sym_uint] = ACTIONS(498),
    [anon_sym_uint8] = ACTIONS(498),
    [anon_sym_uint16] = ACTIONS(498),
    [anon_sym_uint24] = ACTIONS(498),
    [anon_sym_uint32] = ACTIONS(498),
    [anon_sym_uint40] = ACTIONS(498),
    [anon_sym_uint48] = ACTIONS(498),
    [anon_sym_uint56] = ACTIONS(498),
    [anon_sym_uint64] = ACTIONS(498),
    [anon_sym_uint72] = ACTIONS(498),
    [anon_sym_uint80] = ACTIONS(498),
    [anon_sym_uint88] = ACTIONS(498),
    [anon_sym_uint96] = ACTIONS(498),
    [anon_sym_uint104] = ACTIONS(498),
    [anon_sym_uint112] = ACTIONS(498),
    [anon_sym_uint120] = ACTIONS(498),
    [anon_sym_uint128] = ACTIONS(498),
    [anon_sym_uint136] = ACTIONS(498),
    [anon_sym_uint144] = ACTIONS(498),
    [anon_sym_uint152] = ACTIONS(498),
    [anon_sym_uint160] = ACTIONS(498),
    [anon_sym_uint168] = ACTIONS(498),
    [anon_sym_uint176] = ACTIONS(498),
    [anon_sym_uint184] = ACTIONS(498),
    [anon_sym_uint192] = ACTIONS(498),
    [anon_sym_uint200] = ACTIONS(498),
    [anon_sym_uint208] = ACTIONS(498),
    [anon_sym_uint216] = ACTIONS(498),
    [anon_sym_uint224] = ACTIONS(498),
    [anon_sym_uint232] = ACTIONS(498),
    [anon_sym_uint240] = ACTIONS(498),
    [anon_sym_uint248] = ACTIONS(498),
    [anon_sym_uint256] = ACTIONS(498),
    [anon_sym_bytes] = ACTIONS(498),
    [anon_sym_bytes1] = ACTIONS(498),
    [anon_sym_bytes2] = ACTIONS(498),
    [anon_sym_bytes3] = ACTIONS(498),
    [anon_sym_bytes4] = ACTIONS(498),
    [anon_sym_bytes5] = ACTIONS(498),
    [anon_sym_bytes6] = ACTIONS(498),
    [anon_sym_bytes7] = ACTIONS(498),
    [anon_sym_bytes8] = ACTIONS(498),
    [anon_sym_bytes9] = ACTIONS(498),
    [anon_sym_bytes10] = ACTIONS(498),
    [anon_sym_bytes11] = ACTIONS(498),
    [anon_sym_bytes12] = ACTIONS(498),
    [anon_sym_bytes13] = ACTIONS(498),
    [anon_sym_bytes14] = ACTIONS(498),
    [anon_sym_bytes15] = ACTIONS(498),
    [anon_sym_bytes16] = ACTIONS(498),
    [anon_sym_bytes17] = ACTIONS(498),
    [anon_sym_bytes18] = ACTIONS(498),
    [anon_sym_bytes19] = ACTIONS(498),
    [anon_sym_bytes20] = ACTIONS(498),
    [anon_sym_bytes21] = ACTIONS(498),
    [anon_sym_bytes22] = ACTIONS(498),
    [anon_sym_bytes23] = ACTIONS(498),
    [anon_sym_bytes24] = ACTIONS(498),
    [anon_sym_bytes25] = ACTIONS(498),
    [anon_sym_bytes26] = ACTIONS(498),
    [anon_sym_bytes27] = ACTIONS(498),
    [anon_sym_bytes28] = ACTIONS(498),
    [anon_sym_bytes29] = ACTIONS(498),
    [anon_sym_bytes30] = ACTIONS(498),
    [anon_sym_bytes31] = ACTIONS(498),
    [anon_sym_bytes32] = ACTIONS(498),
    [anon_sym_fixed] = ACTIONS(498),
    [aux_sym__fixed_token1] = ACTIONS(498),
    [anon_sym_ufixed] = ACTIONS(498),
    [aux_sym__ufixed_token1] = ACTIONS(498),
    [aux_sym__decimal_number_token1] = ACTIONS(498),
    [aux_sym__decimal_number_token2] = ACTIONS(500),
    [aux_sym__hex_number_token1] = ACTIONS(500),
    [anon_sym_hex] = ACTIONS(498),
    [anon_sym_DQUOTE] = ACTIONS(500),
    [anon_sym_SQUOTE] = ACTIONS(500),
    [anon_sym_unicode] = ACTIONS(498),
    [sym_comment] = ACTIONS(3),
  },
  [108] = {
    [sym_identifier] = ACTIONS(502),
    [anon_sym_DASH] = ACTIONS(502),
    [anon_sym_TILDE] = ACTIONS(504),
    [anon_sym_LBRACE] = ACTIONS(504),
    [anon_sym_RBRACE] = ACTIONS(504),
    [anon_sym_type] = ACTIONS(502),
    [anon_sym_LPAREN] = ACTIONS(504),
    [anon_sym_for] = ACTIONS(502),
    [anon_sym_assembly] = ACTIONS(502),
    [anon_sym_break] = ACTIONS(502),
    [anon_sym_continue] = ACTIONS(502),
    [anon_sym_true] = ACTIONS(502),
    [anon_sym_false] = ACTIONS(502),
    [anon_sym_if] = ACTIONS(502),
    [anon_sym_function] = ACTIONS(502),
    [anon_sym_byte] = ACTIONS(502),
    [anon_sym_address] = ACTIONS(502),
    [anon_sym_return] = ACTIONS(502),
    [anon_sym_revert] = ACTIONS(502),
    [sym_unchecked] = ACTIONS(502),
    [anon_sym_var] = ACTIONS(502),
    [anon_sym_else] = ACTIONS(502),
    [anon_sym_while] = ACTIONS(502),
    [anon_sym_do] = ACTIONS(502),
    [anon_sym_try] = ACTIONS(502),
    [anon_sym_emit] = ACTIONS(502),
    [anon_sym_payable] = ACTIONS(502),
    [anon_sym_new] = ACTIONS(502),
    [anon_sym_LBRACK] = ACTIONS(504),
    [anon_sym_delete] = ACTIONS(502),
    [anon_sym_BANG] = ACTIONS(504),
    [anon_sym_PLUS_PLUS] = ACTIONS(504),
    [anon_sym_DASH_DASH] = ACTIONS(504),
    [anon_sym_mapping] = ACTIONS(502),
    [anon_sym_bool] = ACTIONS(502),
    [anon_sym_string] = ACTIONS(502),
    [anon_sym_int] = ACTIONS(502),
    [anon_sym_int8] = ACTIONS(502),
    [anon_sym_int16] = ACTIONS(502),
    [anon_sym_int24] = ACTIONS(502),
    [anon_sym_int32] = ACTIONS(502),
    [anon_sym_int40] = ACTIONS(502),
    [anon_sym_int48] = ACTIONS(502),
    [anon_sym_int56] = ACTIONS(502),
    [anon_sym_int64] = ACTIONS(502),
    [anon_sym_int72] = ACTIONS(502),
    [anon_sym_int80] = ACTIONS(502),
    [anon_sym_int88] = ACTIONS(502),
    [anon_sym_int96] = ACTIONS(502),
    [anon_sym_int104] = ACTIONS(502),
    [anon_sym_int112] = ACTIONS(502),
    [anon_sym_int120] = ACTIONS(502),
    [anon_sym_int128] = ACTIONS(502),
    [anon_sym_int136] = ACTIONS(502),
    [anon_sym_int144] = ACTIONS(502),
    [anon_sym_int152] = ACTIONS(502),
    [anon_sym_int160] = ACTIONS(502),
    [anon_sym_int168] = ACTIONS(502),
    [anon_sym_int176] = ACTIONS(502),
    [anon_sym_int184] = ACTIONS(502),
    [anon_sym_int192] = ACTIONS(502),
    [anon_sym_int200] = ACTIONS(502),
    [anon_sym_int208] = ACTIONS(502),
    [anon_sym_int216] = ACTIONS(502),
    [anon_sym_int224] = ACTIONS(502),
    [anon_sym_int232] = ACTIONS(502),
    [anon_sym_int240] = ACTIONS(502),
    [anon_sym_int248] = ACTIONS(502),
    [anon_sym_int256] = ACTIONS(502),
    [anon_sym_uint] = ACTIONS(502),
    [anon_sym_uint8] = ACTIONS(502),
    [anon_sym_uint16] = ACTIONS(502),
    [anon_sym_uint24] = ACTIONS(502),
    [anon_sym_uint32] = ACTIONS(502),
    [anon_sym_uint40] = ACTIONS(502),
    [anon_sym_uint48] = ACTIONS(502),
    [anon_sym_uint56] = ACTIONS(502),
    [anon_sym_uint64] = ACTIONS(502),
    [anon_sym_uint72] = ACTIONS(502),
    [anon_sym_uint80] = ACTIONS(502),
    [anon_sym_uint88] = ACTIONS(502),
    [anon_sym_uint96] = ACTIONS(502),
    [anon_sym_uint104] = ACTIONS(502),
    [anon_sym_uint112] = ACTIONS(502),
    [anon_sym_uint120] = ACTIONS(502),
    [anon_sym_uint128] = ACTIONS(502),
    [anon_sym_uint136] = ACTIONS(502),
    [anon_sym_uint144] = ACTIONS(502),
    [anon_sym_uint152] = ACTIONS(502),
    [anon_sym_uint160] = ACTIONS(502),
    [anon_sym_uint168] = ACTIONS(502),
    [anon_sym_uint176] = ACTIONS(502),
    [anon_sym_uint184] = ACTIONS(502),
    [anon_sym_uint192] = ACTIONS(502),
    [anon_sym_uint200] = ACTIONS(502),
    [anon_sym_uint208] = ACTIONS(502),
    [anon_sym_uint216] = ACTIONS(502),
    [anon_sym_uint224] = ACTIONS(502),
    [anon_sym_uint232] = ACTIONS(502),
    [anon_sym_uint240] = ACTIONS(502),
    [anon_sym_uint248] = ACTIONS(502),
    [anon_sym_uint256] = ACTIONS(502),
    [anon_sym_bytes] = ACTIONS(502),
    [anon_sym_bytes1] = ACTIONS(502),
    [anon_sym_bytes2] = ACTIONS(502),
    [anon_sym_bytes3] = ACTIONS(502),
    [anon_sym_bytes4] = ACTIONS(502),
    [anon_sym_bytes5] = ACTIONS(502),
    [anon_sym_bytes6] = ACTIONS(502),
    [anon_sym_bytes7] = ACTIONS(502),
    [anon_sym_bytes8] = ACTIONS(502),
    [anon_sym_bytes9] = ACTIONS(502),
    [anon_sym_bytes10] = ACTIONS(502),
    [anon_sym_bytes11] = ACTIONS(502),
    [anon_sym_bytes12] = ACTIONS(502),
    [anon_sym_bytes13] = ACTIONS(502),
    [anon_sym_bytes14] = ACTIONS(502),
    [anon_sym_bytes15] = ACTIONS(502),
    [anon_sym_bytes16] = ACTIONS(502),
    [anon_sym_bytes17] = ACTIONS(502),
    [anon_sym_bytes18] = ACTIONS(502),
    [anon_sym_bytes19] = ACTIONS(502),
    [anon_sym_bytes20] = ACTIONS(502),
    [anon_sym_bytes21] = ACTIONS(502),
    [anon_sym_bytes22] = ACTIONS(502),
    [anon_sym_bytes23] = ACTIONS(502),
    [anon_sym_bytes24] = ACTIONS(502),
    [anon_sym_bytes25] = ACTIONS(502),
    [anon_sym_bytes26] = ACTIONS(502),
    [anon_sym_bytes27] = ACTIONS(502),
    [anon_sym_bytes28] = ACTIONS(502),
    [anon_sym_bytes29] = ACTIONS(502),
    [anon_sym_bytes30] = ACTIONS(502),
    [anon_sym_bytes31] = ACTIONS(502),
    [anon_sym_bytes32] = ACTIONS(502),
    [anon_sym_fixed] = ACTIONS(502),
    [aux_sym__fixed_token1] = ACTIONS(502),
    [anon_sym_ufixed] = ACTIONS(502),
    [aux_sym__ufixed_token1] = ACTIONS(502),
    [aux_sym__decimal_number_token1] = ACTIONS(502),
    [aux_sym__decimal_number_token2] = ACTIONS(504),
    [aux_sym__hex_number_token1] = ACTIONS(504),
    [anon_sym_hex] = ACTIONS(502),
    [anon_sym_DQUOTE] = ACTIONS(504),
    [anon_sym_SQUOTE] = ACTIONS(504),
    [anon_sym_unicode] = ACTIONS(502),
    [sym_comment] = ACTIONS(3),
  },
  [109] = {
    [sym_identifier] = ACTIONS(506),
    [anon_sym_DASH] = ACTIONS(506),
    [anon_sym_TILDE] = ACTIONS(508),
    [anon_sym_LBRACE] = ACTIONS(508),
    [anon_sym_RBRACE] = ACTIONS(508),
    [anon_sym_type] = ACTIONS(506),
    [anon_sym_LPAREN] = ACTIONS(508),
    [anon_sym_for] = ACTIONS(506),
    [anon_sym_assembly] = ACTIONS(506),
    [anon_sym_break] = ACTIONS(506),
    [anon_sym_continue] = ACTIONS(506),
    [anon_sym_true] = ACTIONS(506),
    [anon_sym_false] = ACTIONS(506),
    [anon_sym_if] = ACTIONS(506),
    [anon_sym_function] = ACTIONS(506),
    [anon_sym_byte] = ACTIONS(506),
    [anon_sym_address] = ACTIONS(506),
    [anon_sym_return] = ACTIONS(506),
    [anon_sym_revert] = ACTIONS(506),
    [sym_unchecked] = ACTIONS(506),
    [anon_sym_var] = ACTIONS(506),
    [anon_sym_else] = ACTIONS(506),
    [anon_sym_while] = ACTIONS(506),
    [anon_sym_do] = ACTIONS(506),
    [anon_sym_try] = ACTIONS(506),
    [anon_sym_emit] = ACTIONS(506),
    [anon_sym_payable] = ACTIONS(506),
    [anon_sym_new] = ACTIONS(506),
    [anon_sym_LBRACK] = ACTIONS(508),
    [anon_sym_delete] = ACTIONS(506),
    [anon_sym_BANG] = ACTIONS(508),
    [anon_sym_PLUS_PLUS] = ACTIONS(508),
    [anon_sym_DASH_DASH] = ACTIONS(508),
    [anon_sym_mapping] = ACTIONS(506),
    [anon_sym_bool] = ACTIONS(506),
    [anon_sym_string] = ACTIONS(506),
    [anon_sym_int] = ACTIONS(506),
    [anon_sym_int8] = ACTIONS(506),
    [anon_sym_int16] = ACTIONS(506),
    [anon_sym_int24] = ACTIONS(506),
    [anon_sym_int32] = ACTIONS(506),
    [anon_sym_int40] = ACTIONS(506),
    [anon_sym_int48] = ACTIONS(506),
    [anon_sym_int56] = ACTIONS(506),
    [anon_sym_int64] = ACTIONS(506),
    [anon_sym_int72] = ACTIONS(506),
    [anon_sym_int80] = ACTIONS(506),
    [anon_sym_int88] = ACTIONS(506),
    [anon_sym_int96] = ACTIONS(506),
    [anon_sym_int104] = ACTIONS(506),
    [anon_sym_int112] = ACTIONS(506),
    [anon_sym_int120] = ACTIONS(506),
    [anon_sym_int128] = ACTIONS(506),
    [anon_sym_int136] = ACTIONS(506),
    [anon_sym_int144] = ACTIONS(506),
    [anon_sym_int152] = ACTIONS(506),
    [anon_sym_int160] = ACTIONS(506),
    [anon_sym_int168] = ACTIONS(506),
    [anon_sym_int176] = ACTIONS(506),
    [anon_sym_int184] = ACTIONS(506),
    [anon_sym_int192] = ACTIONS(506),
    [anon_sym_int200] = ACTIONS(506),
    [anon_sym_int208] = ACTIONS(506),
    [anon_sym_int216] = ACTIONS(506),
    [anon_sym_int224] = ACTIONS(506),
    [anon_sym_int232] = ACTIONS(506),
    [anon_sym_int240] = ACTIONS(506),
    [anon_sym_int248] = ACTIONS(506),
    [anon_sym_int256] = ACTIONS(506),
    [anon_sym_uint] = ACTIONS(506),
    [anon_sym_uint8] = ACTIONS(506),
    [anon_sym_uint16] = ACTIONS(506),
    [anon_sym_uint24] = ACTIONS(506),
    [anon_sym_uint32] = ACTIONS(506),
    [anon_sym_uint40] = ACTIONS(506),
    [anon_sym_uint48] = ACTIONS(506),
    [anon_sym_uint56] = ACTIONS(506),
    [anon_sym_uint64] = ACTIONS(506),
    [anon_sym_uint72] = ACTIONS(506),
    [anon_sym_uint80] = ACTIONS(506),
    [anon_sym_uint88] = ACTIONS(506),
    [anon_sym_uint96] = ACTIONS(506),
    [anon_sym_uint104] = ACTIONS(506),
    [anon_sym_uint112] = ACTIONS(506),
    [anon_sym_uint120] = ACTIONS(506),
    [anon_sym_uint128] = ACTIONS(506),
    [anon_sym_uint136] = ACTIONS(506),
    [anon_sym_uint144] = ACTIONS(506),
    [anon_sym_uint152] = ACTIONS(506),
    [anon_sym_uint160] = ACTIONS(506),
    [anon_sym_uint168] = ACTIONS(506),
    [anon_sym_uint176] = ACTIONS(506),
    [anon_sym_uint184] = ACTIONS(506),
    [anon_sym_uint192] = ACTIONS(506),
    [anon_sym_uint200] = ACTIONS(506),
    [anon_sym_uint208] = ACTIONS(506),
    [anon_sym_uint216] = ACTIONS(506),
    [anon_sym_uint224] = ACTIONS(506),
    [anon_sym_uint232] = ACTIONS(506),
    [anon_sym_uint240] = ACTIONS(506),
    [anon_sym_uint248] = ACTIONS(506),
    [anon_sym_uint256] = ACTIONS(506),
    [anon_sym_bytes] = ACTIONS(506),
    [anon_sym_bytes1] = ACTIONS(506),
    [anon_sym_bytes2] = ACTIONS(506),
    [anon_sym_bytes3] = ACTIONS(506),
    [anon_sym_bytes4] = ACTIONS(506),
    [anon_sym_bytes5] = ACTIONS(506),
    [anon_sym_bytes6] = ACTIONS(506),
    [anon_sym_bytes7] = ACTIONS(506),
    [anon_sym_bytes8] = ACTIONS(506),
    [anon_sym_bytes9] = ACTIONS(506),
    [anon_sym_bytes10] = ACTIONS(506),
    [anon_sym_bytes11] = ACTIONS(506),
    [anon_sym_bytes12] = ACTIONS(506),
    [anon_sym_bytes13] = ACTIONS(506),
    [anon_sym_bytes14] = ACTIONS(506),
    [anon_sym_bytes15] = ACTIONS(506),
    [anon_sym_bytes16] = ACTIONS(506),
    [anon_sym_bytes17] = ACTIONS(506),
    [anon_sym_bytes18] = ACTIONS(506),
    [anon_sym_bytes19] = ACTIONS(506),
    [anon_sym_bytes20] = ACTIONS(506),
    [anon_sym_bytes21] = ACTIONS(506),
    [anon_sym_bytes22] = ACTIONS(506),
    [anon_sym_bytes23] = ACTIONS(506),
    [anon_sym_bytes24] = ACTIONS(506),
    [anon_sym_bytes25] = ACTIONS(506),
    [anon_sym_bytes26] = ACTIONS(506),
    [anon_sym_bytes27] = ACTIONS(506),
    [anon_sym_bytes28] = ACTIONS(506),
    [anon_sym_bytes29] = ACTIONS(506),
    [anon_sym_bytes30] = ACTIONS(506),
    [anon_sym_bytes31] = ACTIONS(506),
    [anon_sym_bytes32] = ACTIONS(506),
    [anon_sym_fixed] = ACTIONS(506),
    [aux_sym__fixed_token1] = ACTIONS(506),
    [anon_sym_ufixed] = ACTIONS(506),
    [aux_sym__ufixed_token1] = ACTIONS(506),
    [aux_sym__decimal_number_token1] = ACTIONS(506),
    [aux_sym__decimal_number_token2] = ACTIONS(508),
    [aux_sym__hex_number_token1] = ACTIONS(508),
    [anon_sym_hex] = ACTIONS(506),
    [anon_sym_DQUOTE] = ACTIONS(508),
    [anon_sym_SQUOTE] = ACTIONS(508),
    [anon_sym_unicode] = ACTIONS(506),
    [sym_comment] = ACTIONS(3),
  },
  [110] = {
    [sym_identifier] = ACTIONS(510),
    [anon_sym_DASH] = ACTIONS(510),
    [anon_sym_TILDE] = ACTIONS(512),
    [anon_sym_LBRACE] = ACTIONS(512),
    [anon_sym_RBRACE] = ACTIONS(512),
    [anon_sym_type] = ACTIONS(510),
    [anon_sym_LPAREN] = ACTIONS(512),
    [anon_sym_for] = ACTIONS(510),
    [anon_sym_assembly] = ACTIONS(510),
    [anon_sym_break] = ACTIONS(510),
    [anon_sym_continue] = ACTIONS(510),
    [anon_sym_true] = ACTIONS(510),
    [anon_sym_false] = ACTIONS(510),
    [anon_sym_if] = ACTIONS(510),
    [anon_sym_function] = ACTIONS(510),
    [anon_sym_byte] = ACTIONS(510),
    [anon_sym_address] = ACTIONS(510),
    [anon_sym_return] = ACTIONS(510),
    [anon_sym_revert] = ACTIONS(510),
    [sym_unchecked] = ACTIONS(510),
    [anon_sym_var] = ACTIONS(510),
    [anon_sym_else] = ACTIONS(510),
    [anon_sym_while] = ACTIONS(510),
    [anon_sym_do] = ACTIONS(510),
    [anon_sym_try] = ACTIONS(510),
    [anon_sym_emit] = ACTIONS(510),
    [anon_sym_payable] = ACTIONS(510),
    [anon_sym_new] = ACTIONS(510),
    [anon_sym_LBRACK] = ACTIONS(512),
    [anon_sym_delete] = ACTIONS(510),
    [anon_sym_BANG] = ACTIONS(512),
    [anon_sym_PLUS_PLUS] = ACTIONS(512),
    [anon_sym_DASH_DASH] = ACTIONS(512),
    [anon_sym_mapping] = ACTIONS(510),
    [anon_sym_bool] = ACTIONS(510),
    [anon_sym_string] = ACTIONS(510),
    [anon_sym_int] = ACTIONS(510),
    [anon_sym_int8] = ACTIONS(510),
    [anon_sym_int16] = ACTIONS(510),
    [anon_sym_int24] = ACTIONS(510),
    [anon_sym_int32] = ACTIONS(510),
    [anon_sym_int40] = ACTIONS(510),
    [anon_sym_int48] = ACTIONS(510),
    [anon_sym_int56] = ACTIONS(510),
    [anon_sym_int64] = ACTIONS(510),
    [anon_sym_int72] = ACTIONS(510),
    [anon_sym_int80] = ACTIONS(510),
    [anon_sym_int88] = ACTIONS(510),
    [anon_sym_int96] = ACTIONS(510),
    [anon_sym_int104] = ACTIONS(510),
    [anon_sym_int112] = ACTIONS(510),
    [anon_sym_int120] = ACTIONS(510),
    [anon_sym_int128] = ACTIONS(510),
    [anon_sym_int136] = ACTIONS(510),
    [anon_sym_int144] = ACTIONS(510),
    [anon_sym_int152] = ACTIONS(510),
    [anon_sym_int160] = ACTIONS(510),
    [anon_sym_int168] = ACTIONS(510),
    [anon_sym_int176] = ACTIONS(510),
    [anon_sym_int184] = ACTIONS(510),
    [anon_sym_int192] = ACTIONS(510),
    [anon_sym_int200] = ACTIONS(510),
    [anon_sym_int208] = ACTIONS(510),
    [anon_sym_int216] = ACTIONS(510),
    [anon_sym_int224] = ACTIONS(510),
    [anon_sym_int232] = ACTIONS(510),
    [anon_sym_int240] = ACTIONS(510),
    [anon_sym_int248] = ACTIONS(510),
    [anon_sym_int256] = ACTIONS(510),
    [anon_sym_uint] = ACTIONS(510),
    [anon_sym_uint8] = ACTIONS(510),
    [anon_sym_uint16] = ACTIONS(510),
    [anon_sym_uint24] = ACTIONS(510),
    [anon_sym_uint32] = ACTIONS(510),
    [anon_sym_uint40] = ACTIONS(510),
    [anon_sym_uint48] = ACTIONS(510),
    [anon_sym_uint56] = ACTIONS(510),
    [anon_sym_uint64] = ACTIONS(510),
    [anon_sym_uint72] = ACTIONS(510),
    [anon_sym_uint80] = ACTIONS(510),
    [anon_sym_uint88] = ACTIONS(510),
    [anon_sym_uint96] = ACTIONS(510),
    [anon_sym_uint104] = ACTIONS(510),
    [anon_sym_uint112] = ACTIONS(510),
    [anon_sym_uint120] = ACTIONS(510),
    [anon_sym_uint128] = ACTIONS(510),
    [anon_sym_uint136] = ACTIONS(510),
    [anon_sym_uint144] = ACTIONS(510),
    [anon_sym_uint152] = ACTIONS(510),
    [anon_sym_uint160] = ACTIONS(510),
    [anon_sym_uint168] = ACTIONS(510),
    [anon_sym_uint176] = ACTIONS(510),
    [anon_sym_uint184] = ACTIONS(510),
    [anon_sym_uint192] = ACTIONS(510),
    [anon_sym_uint200] = ACTIONS(510),
    [anon_sym_uint208] = ACTIONS(510),
    [anon_sym_uint216] = ACTIONS(510),
    [anon_sym_uint224] = ACTIONS(510),
    [anon_sym_uint232] = ACTIONS(510),
    [anon_sym_uint240] = ACTIONS(510),
    [anon_sym_uint248] = ACTIONS(510),
    [anon_sym_uint256] = ACTIONS(510),
    [anon_sym_bytes] = ACTIONS(510),
    [anon_sym_bytes1] = ACTIONS(510),
    [anon_sym_bytes2] = ACTIONS(510),
    [anon_sym_bytes3] = ACTIONS(510),
    [anon_sym_bytes4] = ACTIONS(510),
    [anon_sym_bytes5] = ACTIONS(510),
    [anon_sym_bytes6] = ACTIONS(510),
    [anon_sym_bytes7] = ACTIONS(510),
    [anon_sym_bytes8] = ACTIONS(510),
    [anon_sym_bytes9] = ACTIONS(510),
    [anon_sym_bytes10] = ACTIONS(510),
    [anon_sym_bytes11] = ACTIONS(510),
    [anon_sym_bytes12] = ACTIONS(510),
    [anon_sym_bytes13] = ACTIONS(510),
    [anon_sym_bytes14] = ACTIONS(510),
    [anon_sym_bytes15] = ACTIONS(510),
    [anon_sym_bytes16] = ACTIONS(510),
    [anon_sym_bytes17] = ACTIONS(510),
    [anon_sym_bytes18] = ACTIONS(510),
    [anon_sym_bytes19] = ACTIONS(510),
    [anon_sym_bytes20] = ACTIONS(510),
    [anon_sym_bytes21] = ACTIONS(510),
    [anon_sym_bytes22] = ACTIONS(510),
    [anon_sym_bytes23] = ACTIONS(510),
    [anon_sym_bytes24] = ACTIONS(510),
    [anon_sym_bytes25] = ACTIONS(510),
    [anon_sym_bytes26] = ACTIONS(510),
    [anon_sym_bytes27] = ACTIONS(510),
    [anon_sym_bytes28] = ACTIONS(510),
    [anon_sym_bytes29] = ACTIONS(510),
    [anon_sym_bytes30] = ACTIONS(510),
    [anon_sym_bytes31] = ACTIONS(510),
    [anon_sym_bytes32] = ACTIONS(510),
    [anon_sym_fixed] = ACTIONS(510),
    [aux_sym__fixed_token1] = ACTIONS(510),
    [anon_sym_ufixed] = ACTIONS(510),
    [aux_sym__ufixed_token1] = ACTIONS(510),
    [aux_sym__decimal_number_token1] = ACTIONS(510),
    [aux_sym__decimal_number_token2] = ACTIONS(512),
    [aux_sym__hex_number_token1] = ACTIONS(512),
    [anon_sym_hex] = ACTIONS(510),
    [anon_sym_DQUOTE] = ACTIONS(512),
    [anon_sym_SQUOTE] = ACTIONS(512),
    [anon_sym_unicode] = ACTIONS(510),
    [sym_comment] = ACTIONS(3),
  },
  [111] = {
    [sym_identifier] = ACTIONS(514),
    [anon_sym_DASH] = ACTIONS(514),
    [anon_sym_TILDE] = ACTIONS(516),
    [anon_sym_LBRACE] = ACTIONS(516),
    [anon_sym_RBRACE] = ACTIONS(516),
    [anon_sym_type] = ACTIONS(514),
    [anon_sym_LPAREN] = ACTIONS(516),
    [anon_sym_for] = ACTIONS(514),
    [anon_sym_assembly] = ACTIONS(514),
    [anon_sym_break] = ACTIONS(514),
    [anon_sym_continue] = ACTIONS(514),
    [anon_sym_true] = ACTIONS(514),
    [anon_sym_false] = ACTIONS(514),
    [anon_sym_if] = ACTIONS(514),
    [anon_sym_function] = ACTIONS(514),
    [anon_sym_byte] = ACTIONS(514),
    [anon_sym_address] = ACTIONS(514),
    [anon_sym_return] = ACTIONS(514),
    [anon_sym_revert] = ACTIONS(514),
    [sym_unchecked] = ACTIONS(514),
    [anon_sym_var] = ACTIONS(514),
    [anon_sym_else] = ACTIONS(514),
    [anon_sym_while] = ACTIONS(514),
    [anon_sym_do] = ACTIONS(514),
    [anon_sym_try] = ACTIONS(514),
    [anon_sym_emit] = ACTIONS(514),
    [anon_sym_payable] = ACTIONS(514),
    [anon_sym_new] = ACTIONS(514),
    [anon_sym_LBRACK] = ACTIONS(516),
    [anon_sym_delete] = ACTIONS(514),
    [anon_sym_BANG] = ACTIONS(516),
    [anon_sym_PLUS_PLUS] = ACTIONS(516),
    [anon_sym_DASH_DASH] = ACTIONS(516),
    [anon_sym_mapping] = ACTIONS(514),
    [anon_sym_bool] = ACTIONS(514),
    [anon_sym_string] = ACTIONS(514),
    [anon_sym_int] = ACTIONS(514),
    [anon_sym_int8] = ACTIONS(514),
    [anon_sym_int16] = ACTIONS(514),
    [anon_sym_int24] = ACTIONS(514),
    [anon_sym_int32] = ACTIONS(514),
    [anon_sym_int40] = ACTIONS(514),
    [anon_sym_int48] = ACTIONS(514),
    [anon_sym_int56] = ACTIONS(514),
    [anon_sym_int64] = ACTIONS(514),
    [anon_sym_int72] = ACTIONS(514),
    [anon_sym_int80] = ACTIONS(514),
    [anon_sym_int88] = ACTIONS(514),
    [anon_sym_int96] = ACTIONS(514),
    [anon_sym_int104]