#include "tree_sitter/parser.h"

#if defined(__GNUC__) || defined(__clang__)
#pragma GCC diagnostic ignored "-Wmissing-field-initializers"
#endif

#define LANGUAGE_VERSION 14
#define STATE_COUNT 1216
#define LARGE_STATE_COUNT 61
#define SYMBOL_COUNT 238
#define ALIAS_COUNT 4
#define TOKEN_COUNT 103
#define EXTERNAL_TOKEN_COUNT 0
#define FIELD_COUNT 28
#define MAX_ALIAS_SEQUENCE_LENGTH 8
#define PRODUCTION_ID_COUNT 146

enum ts_symbol_identifiers {
  sym_identifier = 1,
  anon_sym_import = 2,
  anon_sym_DOT = 3,
  anon_sym_LPAREN = 4,
  anon_sym_COMMA = 5,
  anon_sym_RPAREN = 6,
  anon_sym_as = 7,
  anon_sym_if = 8,
  anon_sym_and = 9,
  anon_sym_extern = 10,
  anon_sym_DQUOTE = 11,
  aux_sym_extern_import_path_token1 = 12,
  anon_sym_fn = 13,
  aux_sym_method_name_token1 = 14,
  anon_sym_PLUS = 15,
  anon_sym_DASH = 16,
  anon_sym_SLASH = 17,
  anon_sym_STAR = 18,
  anon_sym_STAR_STAR = 19,
  anon_sym_PERCENT = 20,
  anon_sym_LT = 21,
  anon_sym_GT = 22,
  anon_sym_LT_EQ = 23,
  anon_sym_GT_EQ = 24,
  anon_sym_LT_LT = 25,
  anon_sym_GT_GT = 26,
  anon_sym_GT_GT_GT = 27,
  anon_sym_AMP = 28,
  anon_sym_PIPE = 29,
  anon_sym_CARET = 30,
  anon_sym_EQ_EQ = 31,
  anon_sym_BANG_EQ = 32,
  anon_sym_COLON = 33,
  anon_sym_DOT_DOT_DOT = 34,
  anon_sym_DASH_GT = 35,
  anon_sym_LBRACK = 36,
  anon_sym_RBRACK = 37,
  anon_sym_mut = 38,
  anon_sym_move = 39,
  anon_sym_asyncmut = 40,
  anon_sym_async = 41,
  anon_sym_static = 42,
  anon_sym_class = 43,
  anon_sym_builtin = 44,
  anon_sym_enum = 45,
  anon_sym_LBRACE = 46,
  anon_sym_RBRACE = 47,
  anon_sym_let = 48,
  anon_sym_case = 49,
  anon_sym_trait = 50,
  anon_sym_impl = 51,
  anon_sym_for = 52,
  anon_sym_ref = 53,
  anon_sym_uni = 54,
  anon_sym_EQ = 55,
  anon_sym_COLON_EQ = 56,
  anon_sym_PLUS_EQ = 57,
  anon_sym_DASH_EQ = 58,
  anon_sym_SLASH_EQ = 59,
  anon_sym_STAR_EQ = 60,
  anon_sym_STAR_STAR_EQ = 61,
  anon_sym_PERCENT_EQ = 62,
  anon_sym_LT_LT_EQ = 63,
  anon_sym_GT_GT_EQ = 64,
  anon_sym_GT_GT_GT_EQ = 65,
  anon_sym_AMP_EQ = 66,
  anon_sym_PIPE_EQ = 67,
  anon_sym_CARET_EQ = 68,
  anon_sym_LPAREN2 = 69,
  anon_sym_recover = 70,
  anon_sym_return = 71,
  aux_sym_return_token1 = 72,
  anon_sym_try = 73,
  anon_sym_throw = 74,
  anon_sym_else = 75,
  anon_sym_while = 76,
  anon_sym_loop = 77,
  anon_sym_match = 78,
  sym_wildcard_pattern = 79,
  anon_sym_or = 80,
  anon_sym_true = 81,
  anon_sym_false = 82,
  sym_float = 83,
  sym_integer = 84,
  anon_sym_SQUOTE = 85,
  anon_sym_DOLLAR = 86,
  aux_sym_string_token1 = 87,
  aux_sym_string_token2 = 88,
  anon_sym_BSLASHu_LBRACE = 89,
  aux_sym_escape_sequence_token1 = 90,
  anon_sym_BSLASH_BSLASH = 91,
  aux_sym_escape_sequence_token2 = 92,
  anon_sym_DOLLAR_LBRACE = 93,
  sym_self = 94,
  sym_nil = 95,
  sym_break = 96,
  sym_next = 97,
  sym_visibility = 98,
  sym_line_comment = 99,
  sym_identifier_with_special = 100,
  sym_field = 101,
  sym_constant = 102,
  sym_source_file = 103,
  sym__root = 104,
  sym_import = 105,
  sym_path = 106,
  sym_symbols = 107,
  sym_import_as = 108,
  sym_tags = 109,
  sym_extern_import = 110,
  sym_extern_import_path = 111,
  sym_external_function = 112,
  sym_extern_arguments = 113,
  sym_module_method = 114,
  sym_method_name = 115,
  sym_method_arguments = 116,
  sym_argument = 117,
  sym_rest_argument = 118,
  sym__returns = 119,
  sym_type_parameters = 120,
  sym_type_parameter = 121,
  sym_type_parameter_requirements = 122,
  sym__type_parameter_requirement = 123,
  sym__method_modifier = 124,
  sym_class = 125,
  sym__class_modifier = 126,
  sym_class_body = 127,
  sym__class_expression = 128,
  sym_define_field = 129,
  sym_define_case = 130,
  sym_case_arguments = 131,
  sym_class_method = 132,
  sym_trait = 133,
  sym_trait_body = 134,
  sym_trait_method = 135,
  sym__trait_method_modifier = 136,
  sym_required_traits = 137,
  sym__required_trait = 138,
  sym_implement_trait = 139,
  sym_implement_trait_body = 140,
  sym_bounds = 141,
  sym_bound = 142,
  sym_bound_requirements = 143,
  sym_reopen_class = 144,
  sym_reopen_class_body = 145,
  sym__type = 146,
  sym_generic_type = 147,
  sym_type_arguments = 148,
  sym_ref_type = 149,
  sym_mut_type = 150,
  sym_uni_type = 151,
  sym_move_type = 152,
  sym_fn_type = 153,
  sym_fn_type_arguments = 154,
  sym_tuple_type = 155,
  sym_block = 156,
  sym__expression = 157,
  sym_assign_receiver_field = 158,
  sym_assign_local = 159,
  sym_assign_field = 160,
  sym_replace_local = 161,
  sym_replace_field = 162,
  sym_compound_assign_local = 163,
  sym_compound_assign_field = 164,
  sym_compound_assign_receiver_field = 165,
  sym__call_name = 166,
  sym_call = 167,
  sym_call_arguments = 168,
  sym__call_argument = 169,
  sym_named_argument = 170,
  sym_call_with_receiver = 171,
  sym_ref = 172,
  sym_mut = 173,
  sym_recover = 174,
  sym_grouped_expression = 175,
  sym_tuple = 176,
  sym_array = 177,
  sym_return = 178,
  sym_try = 179,
  sym_throw = 180,
  sym_if = 181,
  sym_else_if = 182,
  sym_else = 183,
  sym_while = 184,
  sym_loop = 185,
  sym_match = 186,
  sym_cases = 187,
  sym_case = 188,
  sym__pattern = 189,
  sym_mutable_pattern = 190,
  sym_tuple_pattern = 191,
  sym_enum_pattern = 192,
  sym_enum_pattern_arguments = 193,
  sym_class_pattern = 194,
  sym_field_pattern = 195,
  sym_or_pattern = 196,
  sym_boolean_pattern = 197,
  sym_namespaced_constant_pattern = 198,
  sym_closure = 199,
  sym_closure_arguments = 200,
  sym_closure_argument = 201,
  sym_define_constant = 202,
  sym_define_variable = 203,
  sym_and_or = 204,
  sym_binary = 205,
  sym_cast = 206,
  sym_string = 207,
  sym_escape_sequence = 208,
  sym_interpolation = 209,
  sym_true = 210,
  sym_false = 211,
  sym_mutable = 212,
  sym_move = 213,
  aux_sym_source_file_repeat1 = 214,
  aux_sym_path_repeat1 = 215,
  aux_sym_symbols_repeat1 = 216,
  aux_sym_tags_repeat1 = 217,
  aux_sym_extern_arguments_repeat1 = 218,
  aux_sym_type_parameters_repeat1 = 219,
  aux_sym_type_parameter_requirements_repeat1 = 220,
  aux_sym_class_body_repeat1 = 221,
  aux_sym_case_arguments_repeat1 = 222,
  aux_sym_trait_body_repeat1 = 223,
  aux_sym_required_traits_repeat1 = 224,
  aux_sym_implement_trait_body_repeat1 = 225,
  aux_sym_bounds_repeat1 = 226,
  aux_sym_block_repeat1 = 227,
  aux_sym_call_arguments_repeat1 = 228,
  aux_sym_tuple_repeat1 = 229,
  aux_sym_if_repeat1 = 230,
  aux_sym_cases_repeat1 = 231,
  aux_sym_tuple_pattern_repeat1 = 232,
  aux_sym_class_pattern_repeat1 = 233,
  aux_sym_or_pattern_repeat1 = 234,
  aux_sym_closure_arguments_repeat1 = 235,
  aux_sym_string_repeat1 = 236,
  aux_sym_string_repeat2 = 237,
  alias_sym_identifier_pattern = 238,
  alias_sym_integer_pattern = 239,
  alias_sym_string_pattern = 240,
  alias_sym_type = 241,
};

static const char * const ts_symbol_names[] = {
  [ts_builtin_sym_end] = "end",
  [sym_identifier] = "identifier",
  [anon_sym_import] = "import",
  [anon_sym_DOT] = ".",
  [anon_sym_LPAREN] = "(",
  [anon_sym_COMMA] = ",",
  [anon_sym_RPAREN] = ")",
  [anon_sym_as] = "as",
  [anon_sym_if] = "if",
  [anon_sym_and] = "and",
  [anon_sym_extern] = "extern",
  [anon_sym_DQUOTE] = "\"",
  [aux_sym_extern_import_path_token1] = "extern_import_path_token1",
  [anon_sym_fn] = "fn",
  [aux_sym_method_name_token1] = "method_name_token1",
  [anon_sym_PLUS] = "+",
  [anon_sym_DASH] = "-",
  [anon_sym_SLASH] = "/",
  [anon_sym_STAR] = "*",
  [anon_sym_STAR_STAR] = "**",
  [anon_sym_PERCENT] = "%",
  [anon_sym_LT] = "<",
  [anon_sym_GT] = ">",
  [anon_sym_LT_EQ] = "<=",
  [anon_sym_GT_EQ] = ">=",
  [anon_sym_LT_LT] = "<<",
  [anon_sym_GT_GT] = ">>",
  [anon_sym_GT_GT_GT] = ">>>",
  [anon_sym_AMP] = "&",
  [anon_sym_PIPE] = "|",
  [anon_sym_CARET] = "^",
  [anon_sym_EQ_EQ] = "==",
  [anon_sym_BANG_EQ] = "!=",
  [anon_sym_COLON] = ":",
  [anon_sym_DOT_DOT_DOT] = "...",
  [anon_sym_DASH_GT] = "->",
  [anon_sym_LBRACK] = "[",
  [anon_sym_RBRACK] = "]",
  [anon_sym_mut] = "mut",
  [anon_sym_move] = "move",
  [anon_sym_asyncmut] = "async mut",
  [anon_sym_async] = "async",
  [anon_sym_static] = "static",
  [anon_sym_class] = "class",
  [anon_sym_builtin] = "builtin",
  [anon_sym_enum] = "enum",
  [anon_sym_LBRACE] = "{",
  [anon_sym_RBRACE] = "}",
  [anon_sym_let] = "let",
  [anon_sym_case] = "case",
  [anon_sym_trait] = "trait",
  [anon_sym_impl] = "impl",
  [anon_sym_for] = "for",
  [anon_sym_ref] = "ref",
  [anon_sym_uni] = "uni",
  [anon_sym_EQ] = "=",
  [anon_sym_COLON_EQ] = ":=",
  [anon_sym_PLUS_EQ] = "+=",
  [anon_sym_DASH_EQ] = "-=",
  [anon_sym_SLASH_EQ] = "/=",
  [anon_sym_STAR_EQ] = "*=",
  [anon_sym_STAR_STAR_EQ] = "**=",
  [anon_sym_PERCENT_EQ] = "%=",
  [anon_sym_LT_LT_EQ] = "<<=",
  [anon_sym_GT_GT_EQ] = ">>=",
  [anon_sym_GT_GT_GT_EQ] = ">>>=",
  [anon_sym_AMP_EQ] = "&=",
  [anon_sym_PIPE_EQ] = "|=",
  [anon_sym_CARET_EQ] = "^=",
  [anon_sym_LPAREN2] = "(",
  [anon_sym_recover] = "recover",
  [anon_sym_return] = "return",
  [aux_sym_return_token1] = "return_token1",
  [anon_sym_try] = "try",
  [anon_sym_throw] = "throw",
  [anon_sym_else] = "else",
  [anon_sym_while] = "while",
  [anon_sym_loop] = "loop",
  [anon_sym_match] = "match",
  [sym_wildcard_pattern] = "wildcard_pattern",
  [anon_sym_or] = "or",
  [anon_sym_true] = "true",
  [anon_sym_false] = "false",
  [sym_float] = "float",
  [sym_integer] = "integer",
  [anon_sym_SQUOTE] = "'",
  [anon_sym_DOLLAR] = "string_content",
  [aux_sym_string_token1] = "string_content",
  [aux_sym_string_token2] = "string_content",
  [anon_sym_BSLASHu_LBRACE] = "\\u{",
  [aux_sym_escape_sequence_token1] = "escape_sequence_token1",
  [anon_sym_BSLASH_BSLASH] = "\\\\",
  [aux_sym_escape_sequence_token2] = "escape_sequence_token2",
  [anon_sym_DOLLAR_LBRACE] = "${",
  [sym_self] = "self",
  [sym_nil] = "nil",
  [sym_break] = "break",
  [sym_next] = "next",
  [sym_visibility] = "visibility",
  [sym_line_comment] = "line_comment",
  [sym_identifier_with_special] = "name",
  [sym_field] = "field",
  [sym_constant] = "constant",
  [sym_source_file] = "source_file",
  [sym__root] = "_root",
  [sym_import] = "import",
  [sym_path] = "path",
  [sym_symbols] = "symbols",
  [sym_import_as] = "import_as",
  [sym_tags] = "tags",
  [sym_extern_import] = "extern_import",
  [sym_extern_import_path] = "path",
  [sym_external_function] = "external_function",
  [sym_extern_arguments] = "arguments",
  [sym_module_method] = "method",
  [sym_method_name] = "identifier",
  [sym_method_arguments] = "arguments",
  [sym_argument] = "argument",
  [sym_rest_argument] = "rest_argument",
  [sym__returns] = "_returns",
  [sym_type_parameters] = "type_parameters",
  [sym_type_parameter] = "type_parameter",
  [sym_type_parameter_requirements] = "requirements",
  [sym__type_parameter_requirement] = "_type_parameter_requirement",
  [sym__method_modifier] = "modifier",
  [sym_class] = "class",
  [sym__class_modifier] = "modifier",
  [sym_class_body] = "class_body",
  [sym__class_expression] = "_class_expression",
  [sym_define_field] = "define_field",
  [sym_define_case] = "define_case",
  [sym_case_arguments] = "arguments",
  [sym_class_method] = "method",
  [sym_trait] = "trait",
  [sym_trait_body] = "trait_body",
  [sym_trait_method] = "method",
  [sym__trait_method_modifier] = "modifier",
  [sym_required_traits] = "required_traits",
  [sym__required_trait] = "_required_trait",
  [sym_implement_trait] = "implement_trait",
  [sym_implement_trait_body] = "implement_trait_body",
  [sym_bounds] = "bounds",
  [sym_bound] = "bound",
  [sym_bound_requirements] = "requirements",
  [sym_reopen_class] = "reopen_class",
  [sym_reopen_class_body] = "reopen_class_body",
  [sym__type] = "_type",
  [sym_generic_type] = "generic_type",
  [sym_type_arguments] = "type_arguments",
  [sym_ref_type] = "ref_type",
  [sym_mut_type] = "mut_type",
  [sym_uni_type] = "uni_type",
  [sym_move_type] = "move_type",
  [sym_fn_type] = "fn_type",
  [sym_fn_type_arguments] = "arguments",
  [sym_tuple_type] = "tuple_type",
  [sym_block] = "block",
  [sym__expression] = "_expression",
  [sym_assign_receiver_field] = "assign_receiver_field",
  [sym_assign_local] = "assign_local",
  [sym_assign_field] = "assign_field",
  [sym_replace_local] = "replace_local",
  [sym_replace_field] = "replace_field",
  [sym_compound_assign_local] = "compound_assign_local",
  [sym_compound_assign_field] = "compound_assign_field",
  [sym_compound_assign_receiver_field] = "compound_assign_receiver_field",
  [sym__call_name] = "_call_name",
  [sym_call] = "call",
  [sym_call_arguments] = "arguments",
  [sym__call_argument] = "_call_argument",
  [sym_named_argument] = "named_argument",
  [sym_call_with_receiver] = "call",
  [sym_ref] = "ref",
  [sym_mut] = "mut",
  [sym_recover] = "recover",
  [sym_grouped_expression] = "grouped_expression",
  [sym_tuple] = "tuple",
  [sym_array] = "array",
  [sym_return] = "return",
  [sym_try] = "try",
  [sym_throw] = "throw",
  [sym_if] = "if",
  [sym_else_if] = "else_if",
  [sym_else] = "else",
  [sym_while] = "while",
  [sym_loop] = "loop",
  [sym_match] = "match",
  [sym_cases] = "cases",
  [sym_case] = "case",
  [sym__pattern] = "_pattern",
  [sym_mutable_pattern] = "mutable_pattern",
  [sym_tuple_pattern] = "tuple_pattern",
  [sym_enum_pattern] = "enum_pattern",
  [sym_enum_pattern_arguments] = "arguments",
  [sym_class_pattern] = "class_pattern",
  [sym_field_pattern] = "field_pattern",
  [sym_or_pattern] = "or_pattern",
  [sym_boolean_pattern] = "boolean_pattern",
  [sym_namespaced_constant_pattern] = "constant_pattern",
  [sym_closure] = "closure",
  [sym_closure_arguments] = "arguments",
  [sym_closure_argument] = "argument",
  [sym_define_constant] = "define_constant",
  [sym_define_variable] = "define_variable",
  [sym_and_or] = "binary",
  [sym_binary] = "binary",
  [sym_cast] = "cast",
  [sym_string] = "string",
  [sym_escape_sequence] = "escape_sequence",
  [sym_interpolation] = "interpolation",
  [sym_true] = "true",
  [sym_false] = "false",
  [sym_mutable] = "mutable",
  [sym_move] = "modifier",
  [aux_sym_source_file_repeat1] = "source_file_repeat1",
  [aux_sym_path_repeat1] = "path_repeat1",
  [aux_sym_symbols_repeat1] = "symbols_repeat1",
  [aux_sym_tags_repeat1] = "tags_repeat1",
  [aux_sym_extern_arguments_repeat1] = "extern_arguments_repeat1",
  [aux_sym_type_parameters_repeat1] = "type_parameters_repeat1",
  [aux_sym_type_parameter_requirements_repeat1] = "type_parameter_requirements_repeat1",
  [aux_sym_class_body_repeat1] = "class_body_repeat1",
  [aux_sym_case_arguments_repeat1] = "case_arguments_repeat1",
  [aux_sym_trait_body_repeat1] = "trait_body_repeat1",
  [aux_sym_required_traits_repeat1] = "required_traits_repeat1",
  [aux_sym_implement_trait_body_repeat1] = "implement_trait_body_repeat1",
  [aux_sym_bounds_repeat1] = "bounds_repeat1",
  [aux_sym_block_repeat1] = "block_repeat1",
  [aux_sym_call_arguments_repeat1] = "call_arguments_repeat1",
  [aux_sym_tuple_repeat1] = "tuple_repeat1",
  [aux_sym_if_repeat1] = "if_repeat1",
  [aux_sym_cases_repeat1] = "cases_repeat1",
  [aux_sym_tuple_pattern_repeat1] = "tuple_pattern_repeat1",
  [aux_sym_class_pattern_repeat1] = "class_pattern_repeat1",
  [aux_sym_or_pattern_repeat1] = "or_pattern_repeat1",
  [aux_sym_closure_arguments_repeat1] = "closure_arguments_repeat1",
  [aux_sym_string_repeat1] = "string_repeat1",
  [aux_sym_string_repeat2] = "string_repeat2",
  [alias_sym_identifier_pattern] = "identifier_pattern",
  [alias_sym_integer_pattern] = "integer_pattern",
  [alias_sym_string_pattern] = "string_pattern",
  [alias_sym_type] = "type",
};

static const TSSymbol ts_symbol_map[] = {
  [ts_builtin_sym_end] = ts_builtin_sym_end,
  [sym_identifier] = sym_identifier,
  [anon_sym_import] = anon_sym_import,
  [anon_sym_DOT] = anon_sym_DOT,
  [anon_sym_LPAREN] = anon_sym_LPAREN,
  [anon_sym_COMMA] = anon_sym_COMMA,
  [anon_sym_RPAREN] = anon_sym_RPAREN,
  [anon_sym_as] = anon_sym_as,
  [anon_sym_if] = anon_sym_if,
  [anon_sym_and] = anon_sym_and,
  [anon_sym_extern] = anon_sym_extern,
  [anon_sym_DQUOTE] = anon_sym_DQUOTE,
  [aux_sym_extern_import_path_token1] = aux_sym_extern_import_path_token1,
  [anon_sym_fn] = anon_sym_fn,
  [aux_sym_method_name_token1] = aux_sym_method_name_token1,
  [anon_sym_PLUS] = anon_sym_PLUS,
  [anon_sym_DASH] = anon_sym_DASH,
  [anon_sym_SLASH] = anon_sym_SLASH,
  [anon_sym_STAR] = anon_sym_STAR,
  [anon_sym_STAR_STAR] = anon_sym_STAR_STAR,
  [anon_sym_PERCENT] = anon_sym_PERCENT,
  [anon_sym_LT] = anon_sym_LT,
  [anon_sym_GT] = anon_sym_GT,
  [anon_sym_LT_EQ] = anon_sym_LT_EQ,
  [anon_sym_GT_EQ] = anon_sym_GT_EQ,
  [anon_sym_LT_LT] = anon_sym_LT_LT,
  [anon_sym_GT_GT] = anon_sym_GT_GT,
  [anon_sym_GT_GT_GT] = anon_sym_GT_GT_GT,
  [anon_sym_AMP] = anon_sym_AMP,
  [anon_sym_PIPE] = anon_sym_PIPE,
  [anon_sym_CARET] = anon_sym_CARET,
  [anon_sym_EQ_EQ] = anon_sym_EQ_EQ,
  [anon_sym_BANG_EQ] = anon_sym_BANG_EQ,
  [anon_sym_COLON] = anon_sym_COLON,
  [anon_sym_DOT_DOT_DOT] = anon_sym_DOT_DOT_DOT,
  [anon_sym_DASH_GT] = anon_sym_DASH_GT,
  [anon_sym_LBRACK] = anon_sym_LBRACK,
  [anon_sym_RBRACK] = anon_sym_RBRACK,
  [anon_sym_mut] = anon_sym_mut,
  [anon_sym_move] = anon_sym_move,
  [anon_sym_asyncmut] = anon_sym_asyncmut,
  [anon_sym_async] = anon_sym_async,
  [anon_sym_static] = anon_sym_static,
  [anon_sym_class] = anon_sym_class,
  [anon_sym_builtin] = anon_sym_builtin,
  [anon_sym_enum] = anon_sym_enum,
  [anon_sym_LBRACE] = anon_sym_LBRACE,
  [anon_sym_RBRACE] = anon_sym_RBRACE,
  [anon_sym_let] = anon_sym_let,
  [anon_sym_case] = anon_sym_case,
  [anon_sym_trait] = anon_sym_trait,
  [anon_sym_impl] = anon_sym_impl,
  [anon_sym_for] = anon_sym_for,
  [anon_sym_ref] = anon_sym_ref,
  [anon_sym_uni] = anon_sym_uni,
  [anon_sym_EQ] = anon_sym_EQ,
  [anon_sym_COLON_EQ] = anon_sym_COLON_EQ,
  [anon_sym_PLUS_EQ] = anon_sym_PLUS_EQ,
  [anon_sym_DASH_EQ] = anon_sym_DASH_EQ,
  [anon_sym_SLASH_EQ] = anon_sym_SLASH_EQ,
  [anon_sym_STAR_EQ] = anon_sym_STAR_EQ,
  [anon_sym_STAR_STAR_EQ] = anon_sym_STAR_STAR_EQ,
  [anon_sym_PERCENT_EQ] = anon_sym_PERCENT_EQ,
  [anon_sym_LT_LT_EQ] = anon_sym_LT_LT_EQ,
  [anon_sym_GT_GT_EQ] = anon_sym_GT_GT_EQ,
  [anon_sym_GT_GT_GT_EQ] = anon_sym_GT_GT_GT_EQ,
  [anon_sym_AMP_EQ] = anon_sym_AMP_EQ,
  [anon_sym_PIPE_EQ] = anon_sym_PIPE_EQ,
  [anon_sym_CARET_EQ] = anon_sym_CARET_EQ,
  [anon_sym_LPAREN2] = anon_sym_LPAREN,
  [anon_sym_recover] = anon_sym_recover,
  [anon_sym_return] = anon_sym_return,
  [aux_sym_return_token1] = aux_sym_return_token1,
  [anon_sym_try] = anon_sym_try,
  [anon_sym_throw] = anon_sym_throw,
  [anon_sym_else] = anon_sym_else,
  [anon_sym_while] = anon_sym_while,
  [anon_sym_loop] = anon_sym_loop,
  [anon_sym_match] = anon_sym_match,
  [sym_wildcard_pattern] = sym_wildcard_pattern,
  [anon_sym_or] = anon_sym_or,
  [anon_sym_true] = anon_sym_true,
  [anon_sym_false] = anon_sym_false,
  [sym_float] = sym_float,
  [sym_integer] = sym_integer,
  [anon_sym_SQUOTE] = anon_sym_SQUOTE,
  [anon_sym_DOLLAR] = anon_sym_DOLLAR,
  [aux_sym_string_token1] = anon_sym_DOLLAR,
  [aux_sym_string_token2] = anon_sym_DOLLAR,
  [anon_sym_BSLASHu_LBRACE] = anon_sym_BSLASHu_LBRACE,
  [aux_sym_escape_sequence_token1] = aux_sym_escape_sequence_token1,
  [anon_sym_BSLASH_BSLASH] = anon_sym_BSLASH_BSLASH,
  [aux_sym_escape_sequence_token2] = aux_sym_escape_sequence_token2,
  [anon_sym_DOLLAR_LBRACE] = anon_sym_DOLLAR_LBRACE,
  [sym_self] = sym_self,
  [sym_nil] = sym_nil,
  [sym_break] = sym_break,
  [sym_next] = sym_next,
  [sym_visibility] = sym_visibility,
  [sym_line_comment] = sym_line_comment,
  [sym_identifier_with_special] = sym_identifier_with_special,
  [sym_field] = sym_field,
  [sym_constant] = sym_constant,
  [sym_source_file] = sym_source_file,
  [sym__root] = sym__root,
  [sym_import] = sym_import,
  [sym_path] = sym_path,
  [sym_symbols] = sym_symbols,
  [sym_import_as] = sym_import_as,
  [sym_tags] = sym_tags,
  [sym_extern_import] = sym_extern_import,
  [sym_extern_import_path] = sym_path,
  [sym_external_function] = sym_external_function,
  [sym_extern_arguments] = sym_extern_arguments,
  [sym_module_method] = sym_module_method,
  [sym_method_name] = sym_identifier,
  [sym_method_arguments] = sym_extern_arguments,
  [sym_argument] = sym_argument,
  [sym_rest_argument] = sym_rest_argument,
  [sym__returns] = sym__returns,
  [sym_type_parameters] = sym_type_parameters,
  [sym_type_parameter] = sym_type_parameter,
  [sym_type_parameter_requirements] = sym_type_parameter_requirements,
  [sym__type_parameter_requirement] = sym__type_parameter_requirement,
  [sym__method_modifier] = sym__method_modifier,
  [sym_class] = sym_class,
  [sym__class_modifier] = sym__method_modifier,
  [sym_class_body] = sym_class_body,
  [sym__class_expression] = sym__class_expression,
  [sym_define_field] = sym_define_field,
  [sym_define_case] = sym_define_case,
  [sym_case_arguments] = sym_extern_arguments,
  [sym_class_method] = sym_module_method,
  [sym_trait] = sym_trait,
  [sym_trait_body] = sym_trait_body,
  [sym_trait_method] = sym_module_method,
  [sym__trait_method_modifier] = sym__method_modifier,
  [sym_required_traits] = sym_required_traits,
  [sym__required_trait] = sym__required_trait,
  [sym_implement_trait] = sym_implement_trait,
  [sym_implement_trait_body] = sym_implement_trait_body,
  [sym_bounds] = sym_bounds,
  [sym_bound] = sym_bound,
  [sym_bound_requirements] = sym_type_parameter_requirements,
  [sym_reopen_class] = sym_reopen_class,
  [sym_reopen_class_body] = sym_reopen_class_body,
  [sym__type] = sym__type,
  [sym_generic_type] = sym_generic_type,
  [sym_type_arguments] = sym_type_arguments,
  [sym_ref_type] = sym_ref_type,
  [sym_mut_type] = sym_mut_type,
  [sym_uni_type] = sym_uni_type,
  [sym_move_type] = sym_move_type,
  [sym_fn_type] = sym_fn_type,
  [sym_fn_type_arguments] = sym_extern_arguments,
  [sym_tuple_type] = sym_tuple_type,
  [sym_block] = sym_block,
  [sym__expression] = sym__expression,
  [sym_assign_receiver_field] = sym_assign_receiver_field,
  [sym_assign_local] = sym_assign_local,
  [sym_assign_field] = sym_assign_field,
  [sym_replace_local] = sym_replace_local,
  [sym_replace_field] = sym_replace_field,
  [sym_compound_assign_local] = sym_compound_assign_local,
  [sym_compound_assign_field] = sym_compound_assign_field,
  [sym_compound_assign_receiver_field] = sym_compound_assign_receiver_field,
  [sym__call_name] = sym__call_name,
  [sym_call] = sym_call,
  [sym_call_arguments] = sym_extern_arguments,
  [sym__call_argument] = sym__call_argument,
  [sym_named_argument] = sym_named_argument,
  [sym_call_with_receiver] = sym_call,
  [sym_ref] = sym_ref,
  [sym_mut] = sym_mut,
  [sym_recover] = sym_recover,
  [sym_grouped_expression] = sym_grouped_expression,
  [sym_tuple] = sym_tuple,
  [sym_array] = sym_array,
  [sym_return] = sym_return,
  [sym_try] = sym_try,
  [sym_throw] = sym_throw,
  [sym_if] = sym_if,
  [sym_else_if] = sym_else_if,
  [sym_else] = sym_else,
  [sym_while] = sym_while,
  [sym_loop] = sym_loop,
  [sym_match] = sym_match,
  [sym_cases] = sym_cases,
  [sym_case] = sym_case,
  [sym__pattern] = sym__pattern,
  [sym_mutable_pattern] = sym_mutable_pattern,
  [sym_tuple_pattern] = sym_tuple_pattern,
  [sym_enum_pattern] = sym_enum_pattern,
  [sym_enum_pattern_arguments] = sym_extern_arguments,
  [sym_class_pattern] = sym_class_pattern,
  [sym_field_pattern] = sym_field_pattern,
  [sym_or_pattern] = sym_or_pattern,
  [sym_boolean_pattern] = sym_boolean_pattern,
  [sym_namespaced_constant_pattern] = sym_namespaced_constant_pattern,
  [sym_closure] = sym_closure,
  [sym_closure_arguments] = sym_extern_arguments,
  [sym_closure_argument] = sym_argument,
  [sym_define_constant] = sym_define_constant,
  [sym_define_variable] = sym_define_variable,
  [sym_and_or] = sym_binary,
  [sym_binary] = sym_binary,
  [sym_cast] = sym_cast,
  [sym_string] = sym_string,
  [sym_escape_sequence] = sym_escape_sequence,
  [sym_interpolation] = sym_interpolation,
  [sym_true] = sym_true,
  [sym_false] = sym_false,
  [sym_mutable] = sym_mutable,
  [sym_move] = sym__method_modifier,
  [aux_sym_source_file_repeat1] = aux_sym_source_file_repeat1,
  [aux_sym_path_repeat1] = aux_sym_path_repeat1,
  [aux_sym_symbols_repeat1] = aux_sym_symbols_repeat1,
  [aux_sym_tags_repeat1] = aux_sym_tags_repeat1,
  [aux_sym_extern_arguments_repeat1] = aux_sym_extern_arguments_repeat1,
  [aux_sym_type_parameters_repeat1] = aux_sym_type_parameters_repeat1,
  [aux_sym_type_parameter_requirements_repeat1] = aux_sym_type_parameter_requirements_repeat1,
  [aux_sym_class_body_repeat1] = aux_sym_class_body_repeat1,
  [aux_sym_case_arguments_repeat1] = aux_sym_case_arguments_repeat1,
  [aux_sym_trait_body_repeat1] = aux_sym_trait_body_repeat1,
  [aux_sym_required_traits_repeat1] = aux_sym_required_traits_repeat1,
  [aux_sym_implement_trait_body_repeat1] = aux_sym_implement_trait_body_repeat1,
  [aux_sym_bounds_repeat1] = aux_sym_bounds_repeat1,
  [aux_sym_block_repeat1] = aux_sym_block_repeat1,
  [aux_sym_call_arguments_repeat1] = aux_sym_call_arguments_repeat1,
  [aux_sym_tuple_repeat1] = aux_sym_tuple_repeat1,
  [aux_sym_if_repeat1] = aux_sym_if_repeat1,
  [aux_sym_cases_repeat1] = aux_sym_cases_repeat1,
  [aux_sym_tuple_pattern_repeat1] = aux_sym_tuple_pattern_repeat1,
  [aux_sym_class_pattern_repeat1] = aux_sym_class_pattern_repeat1,
  [aux_sym_or_pattern_repeat1] = aux_sym_or_pattern_repeat1,
  [aux_sym_closure_arguments_repeat1] = aux_sym_closure_arguments_repeat1,
  [aux_sym_string_repeat1] = aux_sym_string_repeat1,
  [aux_sym_string_repeat2] = aux_sym_string_repeat2,
  [alias_sym_identifier_pattern] = alias_sym_identifier_pattern,
  [alias_sym_integer_pattern] = alias_sym_integer_pattern,
  [alias_sym_string_pattern] = alias_sym_string_pattern,
  [alias_sym_type] = alias_sym_type,
};

static const TSSymbolMetadata ts_symbol_metadata[] = {
  [ts_builtin_sym_end] = {
    .visible = false,
    .named = true,
  },
  [sym_identifier] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_import] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COMMA] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RPAREN] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_as] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_if] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_and] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_extern] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DQUOTE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_extern_import_path_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_fn] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_method_name_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_PLUS] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_BANG_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOT_DOT_DOT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_GT] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACK] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_mut] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_move] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_asyncmut] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_async] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_static] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_class] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_builtin] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_enum] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_RBRACE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_let] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_case] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_trait] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_impl] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_for] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_ref] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_uni] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_COLON_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PLUS_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_SLASH_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_STAR_STAR_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PERCENT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LT_LT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_GT_GT_GT_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_AMP_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_PIPE_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_CARET_EQ] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_LPAREN2] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_recover] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_return] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_return_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_try] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_throw] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_else] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_while] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_loop] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_match] = {
    .visible = true,
    .named = false,
  },
  [sym_wildcard_pattern] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_or] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_true] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_false] = {
    .visible = true,
    .named = false,
  },
  [sym_float] = {
    .visible = true,
    .named = true,
  },
  [sym_integer] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_SQUOTE] = {
    .visible = true,
    .named = false,
  },
  [anon_sym_DOLLAR] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_token1] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_string_token2] = {
    .visible = true,
    .named = true,
  },
  [anon_sym_BSLASHu_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token1] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_BSLASH_BSLASH] = {
    .visible = true,
    .named = false,
  },
  [aux_sym_escape_sequence_token2] = {
    .visible = false,
    .named = false,
  },
  [anon_sym_DOLLAR_LBRACE] = {
    .visible = true,
    .named = false,
  },
  [sym_self] = {
    .visible = true,
    .named = true,
  },
  [sym_nil] = {
    .visible = true,
    .named = true,
  },
  [sym_break] = {
    .visible = true,
    .named = true,
  },
  [sym_next] = {
    .visible = true,
    .named = true,
  },
  [sym_visibility] = {
    .visible = true,
    .named = true,
  },
  [sym_line_comment] = {
    .visible = true,
    .named = true,
  },
  [sym_identifier_with_special] = {
    .visible = true,
    .named = true,
  },
  [sym_field] = {
    .visible = true,
    .named = true,
  },
  [sym_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_source_file] = {
    .visible = true,
    .named = true,
  },
  [sym__root] = {
    .visible = false,
    .named = true,
  },
  [sym_import] = {
    .visible = true,
    .named = true,
  },
  [sym_path] = {
    .visible = true,
    .named = true,
  },
  [sym_symbols] = {
    .visible = true,
    .named = true,
  },
  [sym_import_as] = {
    .visible = true,
    .named = true,
  },
  [sym_tags] = {
    .visible = true,
    .named = true,
  },
  [sym_extern_import] = {
    .visible = true,
    .named = true,
  },
  [sym_extern_import_path] = {
    .visible = true,
    .named = true,
  },
  [sym_external_function] = {
    .visible = true,
    .named = true,
  },
  [sym_extern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_module_method] = {
    .visible = true,
    .named = true,
  },
  [sym_method_name] = {
    .visible = true,
    .named = true,
  },
  [sym_method_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_rest_argument] = {
    .visible = true,
    .named = true,
  },
  [sym__returns] = {
    .visible = false,
    .named = true,
  },
  [sym_type_parameters] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter] = {
    .visible = true,
    .named = true,
  },
  [sym_type_parameter_requirements] = {
    .visible = true,
    .named = true,
  },
  [sym__type_parameter_requirement] = {
    .visible = false,
    .named = true,
  },
  [sym__method_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class] = {
    .visible = true,
    .named = true,
  },
  [sym__class_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym__class_expression] = {
    .visible = false,
    .named = true,
  },
  [sym_define_field] = {
    .visible = true,
    .named = true,
  },
  [sym_define_case] = {
    .visible = true,
    .named = true,
  },
  [sym_case_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_class_method] = {
    .visible = true,
    .named = true,
  },
  [sym_trait] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_body] = {
    .visible = true,
    .named = true,
  },
  [sym_trait_method] = {
    .visible = true,
    .named = true,
  },
  [sym__trait_method_modifier] = {
    .visible = true,
    .named = true,
  },
  [sym_required_traits] = {
    .visible = true,
    .named = true,
  },
  [sym__required_trait] = {
    .visible = false,
    .named = true,
  },
  [sym_implement_trait] = {
    .visible = true,
    .named = true,
  },
  [sym_implement_trait_body] = {
    .visible = true,
    .named = true,
  },
  [sym_bounds] = {
    .visible = true,
    .named = true,
  },
  [sym_bound] = {
    .visible = true,
    .named = true,
  },
  [sym_bound_requirements] = {
    .visible = true,
    .named = true,
  },
  [sym_reopen_class] = {
    .visible = true,
    .named = true,
  },
  [sym_reopen_class_body] = {
    .visible = true,
    .named = true,
  },
  [sym__type] = {
    .visible = false,
    .named = true,
  },
  [sym_generic_type] = {
    .visible = true,
    .named = true,
  },
  [sym_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_ref_type] = {
    .visible = true,
    .named = true,
  },
  [sym_mut_type] = {
    .visible = true,
    .named = true,
  },
  [sym_uni_type] = {
    .visible = true,
    .named = true,
  },
  [sym_move_type] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_type] = {
    .visible = true,
    .named = true,
  },
  [sym_fn_type_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_type] = {
    .visible = true,
    .named = true,
  },
  [sym_block] = {
    .visible = true,
    .named = true,
  },
  [sym__expression] = {
    .visible = false,
    .named = true,
  },
  [sym_assign_receiver_field] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_local] = {
    .visible = true,
    .named = true,
  },
  [sym_assign_field] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_local] = {
    .visible = true,
    .named = true,
  },
  [sym_replace_field] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_assign_local] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_assign_field] = {
    .visible = true,
    .named = true,
  },
  [sym_compound_assign_receiver_field] = {
    .visible = true,
    .named = true,
  },
  [sym__call_name] = {
    .visible = false,
    .named = true,
  },
  [sym_call] = {
    .visible = true,
    .named = true,
  },
  [sym_call_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym__call_argument] = {
    .visible = false,
    .named = true,
  },
  [sym_named_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_call_with_receiver] = {
    .visible = true,
    .named = true,
  },
  [sym_ref] = {
    .visible = true,
    .named = true,
  },
  [sym_mut] = {
    .visible = true,
    .named = true,
  },
  [sym_recover] = {
    .visible = true,
    .named = true,
  },
  [sym_grouped_expression] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple] = {
    .visible = true,
    .named = true,
  },
  [sym_array] = {
    .visible = true,
    .named = true,
  },
  [sym_return] = {
    .visible = true,
    .named = true,
  },
  [sym_try] = {
    .visible = true,
    .named = true,
  },
  [sym_throw] = {
    .visible = true,
    .named = true,
  },
  [sym_if] = {
    .visible = true,
    .named = true,
  },
  [sym_else_if] = {
    .visible = true,
    .named = true,
  },
  [sym_else] = {
    .visible = true,
    .named = true,
  },
  [sym_while] = {
    .visible = true,
    .named = true,
  },
  [sym_loop] = {
    .visible = true,
    .named = true,
  },
  [sym_match] = {
    .visible = true,
    .named = true,
  },
  [sym_cases] = {
    .visible = true,
    .named = true,
  },
  [sym_case] = {
    .visible = true,
    .named = true,
  },
  [sym__pattern] = {
    .visible = false,
    .named = true,
  },
  [sym_mutable_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_tuple_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_enum_pattern_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_class_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_field_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_or_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_boolean_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_namespaced_constant_pattern] = {
    .visible = true,
    .named = true,
  },
  [sym_closure] = {
    .visible = true,
    .named = true,
  },
  [sym_closure_arguments] = {
    .visible = true,
    .named = true,
  },
  [sym_closure_argument] = {
    .visible = true,
    .named = true,
  },
  [sym_define_constant] = {
    .visible = true,
    .named = true,
  },
  [sym_define_variable] = {
    .visible = true,
    .named = true,
  },
  [sym_and_or] = {
    .visible = true,
    .named = true,
  },
  [sym_binary] = {
    .visible = true,
    .named = true,
  },
  [sym_cast] = {
    .visible = true,
    .named = true,
  },
  [sym_string] = {
    .visible = true,
    .named = true,
  },
  [sym_escape_sequence] = {
    .visible = true,
    .named = true,
  },
  [sym_interpolation] = {
    .visible = true,
    .named = true,
  },
  [sym_true] = {
    .visible = true,
    .named = true,
  },
  [sym_false] = {
    .visible = true,
    .named = true,
  },
  [sym_mutable] = {
    .visible = true,
    .named = true,
  },
  [sym_move] = {
    .visible = true,
    .named = true,
  },
  [aux_sym_source_file_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_path_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_symbols_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tags_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_extern_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameters_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_type_parameter_requirements_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_case_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_trait_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_required_traits_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_implement_trait_body_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_bounds_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_block_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_call_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_if_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_cases_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_tuple_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_class_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_or_pattern_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_closure_arguments_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat1] = {
    .visible = false,
    .named = false,
  },
  [aux_sym_string_repeat2] = {
    .visible = false,
    .named = false,
  },
  [alias_sym_identifier_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_integer_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_string_pattern] = {
    .visible = true,
    .named = true,
  },
  [alias_sym_type] = {
    .visible = true,
    .named = true,
  },
};

enum ts_field_identifiers {
  field_alias = 1,
  field_alternative = 2,
  field_arguments = 3,
  field_body = 4,
  field_bounds = 5,
  field_cases = 6,
  field_class = 7,
  field_condition = 8,
  field_consequence = 9,
  field_expression = 10,
  field_guard = 11,
  field_left = 12,
  field_modifier = 13,
  field_name = 14,
  field_operator = 15,
  field_path = 16,
  field_pattern = 17,
  field_receiver = 18,
  field_requirements = 19,
  field_returns = 20,
  field_right = 21,
  field_symbols = 22,
  field_tags = 23,
  field_trait = 24,
  field_type = 25,
  field_type_parameters = 26,
  field_value = 27,
  field_visibility = 28,
};

static const char * const ts_field_names[] = {
  [0] = NULL,
  [field_alias] = "alias",
  [field_alternative] = "alternative",
  [field_arguments] = "arguments",
  [field_body] = "body",
  [field_bounds] = "bounds",
  [field_cases] = "cases",
  [field_class] = "class",
  [field_condition] = "condition",
  [field_consequence] = "consequence",
  [field_expression] = "expression",
  [field_guard] = "guard",
  [field_left] = "left",
  [field_modifier] = "modifier",
  [field_name] = "name",
  [field_operator] = "operator",
  [field_path] = "path",
  [field_pattern] = "pattern",
  [field_receiver] = "receiver",
  [field_requirements] = "requirements",
  [field_returns] = "returns",
  [field_right] = "right",
  [field_symbols] = "symbols",
  [field_tags] = "tags",
  [field_trait] = "trait",
  [field_type] = "type",
  [field_type_parameters] = "type_parameters",
  [field_value] = "value",
  [field_visibility] = "visibility",
};

static const TSFieldMapSlice ts_field_map_slices[PRODUCTION_ID_COUNT] = {
  [2] = {.index = 0, .length = 1},
  [3] = {.index = 1, .length = 1},
  [4] = {.index = 2, .length = 1},
  [5] = {.index = 3, .length = 2},
  [6] = {.index = 5, .length = 1},
  [7] = {.index = 6, .length = 2},
  [8] = {.index = 8, .length = 2},
  [9] = {.index = 10, .length = 2},
  [10] = {.index = 12, .length = 1},
  [12] = {.index = 13, .length = 2},
  [13] = {.index = 15, .length = 2},
  [14] = {.index = 17, .length = 2},
  [15] = {.index = 19, .length = 2},
  [16] = {.index = 21, .length = 2},
  [17] = {.index = 23, .length = 2},
  [18] = {.index = 25, .length = 2},
  [19] = {.index = 27, .length = 2},
  [20] = {.index = 29, .length = 3},
  [21] = {.index = 32, .length = 2},
  [22] = {.index = 34, .length = 3},
  [23] = {.index = 37, .length = 1},
  [24] = {.index = 38, .length = 3},
  [25] = {.index = 41, .length = 3},
  [26] = {.index = 44, .length = 2},
  [27] = {.index = 46, .length = 2},
  [28] = {.index = 48, .length = 2},
  [29] = {.index = 50, .length = 1},
  [30] = {.index = 51, .length = 1},
  [31] = {.index = 52, .length = 1},
  [32] = {.index = 53, .length = 2},
  [33] = {.index = 55, .length = 3},
  [34] = {.index = 58, .length = 3},
  [35] = {.index = 61, .length = 3},
  [36] = {.index = 64, .length = 3},
  [37] = {.index = 67, .length = 3},
  [38] = {.index = 70, .length = 3},
  [39] = {.index = 73, .length = 3},
  [40] = {.index = 76, .length = 3},
  [41] = {.index = 79, .length = 2},
  [42] = {.index = 81, .length = 3},
  [43] = {.index = 84, .length = 3},
  [44] = {.index = 87, .length = 1},
  [45] = {.index = 88, .length = 3},
  [46] = {.index = 91, .length = 4},
  [47] = {.index = 95, .length = 2},
  [48] = {.index = 97, .length = 2},
  [49] = {.index = 99, .length = 3},
  [50] = {.index = 102, .length = 3},
  [51] = {.index = 105, .length = 3},
  [52] = {.index = 108, .length = 2},
  [53] = {.index = 110, .length = 3},
  [54] = {.index = 113, .length = 3},
  [55] = {.index = 116, .length = 3},
  [56] = {.index = 119, .length = 4},
  [57] = {.index = 123, .length = 4},
  [58] = {.index = 127, .length = 4},
  [59] = {.index = 131, .length = 2},
  [60] = {.index = 133, .length = 4},
  [61] = {.index = 137, .length = 4},
  [62] = {.index = 141, .length = 4},
  [63] = {.index = 145, .length = 4},
  [64] = {.index = 149, .length = 4},
  [65] = {.index = 153, .length = 1},
  [66] = {.index = 154, .length = 4},
  [67] = {.index = 158, .length = 3},
  [68] = {.index = 161, .length = 3},
  [69] = {.index = 164, .length = 4},
  [70] = {.index = 168, .length = 4},
  [71] = {.index = 172, .length = 3},
  [72] = {.index = 172, .length = 3},
  [77] = {.index = 175, .length = 2},
  [78] = {.index = 177, .length = 3},
  [79] = {.index = 180, .length = 3},
  [80] = {.index = 183, .length = 4},
  [81] = {.index = 187, .length = 4},
  [82] = {.index = 191, .length = 4},
  [83] = {.index = 195, .length = 4},
  [84] = {.index = 199, .length = 5},
  [85] = {.index = 204, .length = 5},
  [86] = {.index = 209, .length = 5},
  [87] = {.index = 214, .length = 5},
  [88] = {.index = 219, .length = 5},
  [89] = {.index = 224, .length = 2},
  [90] = {.index = 226, .length = 4},
  [91] = {.index = 230, .length = 5},
  [92] = {.index = 235, .length = 2},
  [93] = {.index = 237, .length = 2},
  [94] = {.index = 239, .length = 2},
  [95] = {.index = 241, .length = 2},
  [96] = {.index = 243, .length = 4},
  [97] = {.index = 243, .length = 4},
  [99] = {.index = 247, .length = 2},
  [100] = {.index = 249, .length = 5},
  [101] = {.index = 254, .length = 6},
  [102] = {.index = 260, .length = 2},
  [103] = {.index = 262, .length = 5},
  [104] = {.index = 267, .length = 3},
  [105] = {.index = 270, .length = 3},
  [106] = {.index = 273, .length = 3},
  [107] = {.index = 276, .length = 3},
  [108] = {.index = 279, .length = 3},
  [109] = {.index = 282, .length = 3},
  [110] = {.index = 285, .length = 3},
  [111] = {.index = 288, .length = 3},
  [112] = {.index = 291, .length = 3},
  [113] = {.index = 294, .length = 3},
  [114] = {.index = 297, .length = 2},
  [115] = {.index = 299, .length = 4},
  [116] = {.index = 303, .length = 4},
  [117] = {.index = 307, .length = 3},
  [118] = {.index = 310, .length = 4},
  [119] = {.index = 314, .length = 4},
  [120] = {.index = 318, .length = 4},
  [121] = {.index = 322, .length = 4},
  [122] = {.index = 326, .length = 4},
  [123] = {.index = 330, .length = 4},
  [124] = {.index = 334, .length = 4},
  [125] = {.index = 338, .length = 4},
  [126] = {.index = 342, .length = 4},
  [127] = {.index = 346, .length = 4},
  [128] = {.index = 350, .length = 2},
  [129] = {.index = 352, .length = 5},
  [130] = {.index = 357, .length = 5},
  [131] = {.index = 362, .length = 5},
  [132] = {.index = 367, .length = 5},
  [133] = {.index = 372, .length = 5},
  [134] = {.index = 377, .length = 5},
  [135] = {.index = 382, .length = 5},
  [136] = {.index = 387, .length = 5},
  [137] = {.index = 392, .length = 5},
  [138] = {.index = 397, .length = 5},
  [139] = {.index = 402, .length = 4},
  [140] = {.index = 406, .length = 6},
  [141] = {.index = 412, .length = 6},
  [142] = {.index = 418, .length = 6},
  [143] = {.index = 424, .length = 6},
  [144] = {.index = 430, .length = 6},
  [145] = {.index = 436, .length = 7},
};

static const TSFieldMapEntry ts_field_map_entries[] = {
  [0] =
    {field_name, 0},
  [1] =
    {field_path, 1},
  [2] =
    {field_body, 1},
  [3] =
    {field_arguments, 1},
    {field_name, 0},
  [5] =
    {field_path, 2},
  [6] =
    {field_path, 1},
    {field_symbols, 2},
  [8] =
    {field_path, 1},
    {field_tags, 2},
  [10] =
    {field_condition, 1},
    {field_consequence, 2},
  [12] =
    {field_name, 2},
  [13] =
    {field_body, 2},
    {field_name, 1},
  [15] =
    {field_body, 2},
    {field_returns, 1},
  [17] =
    {field_arguments, 1},
    {field_body, 2},
  [19] =
    {field_body, 2},
    {field_modifier, 1},
  [21] =
    {field_body, 2},
    {field_condition, 1},
  [23] =
    {field_name, 0},
    {field_value, 2},
  [25] =
    {field_name, 2},
    {field_receiver, 0},
  [27] =
    {field_expression, 0},
    {field_type, 2},
  [29] =
    {field_left, 0},
    {field_operator, 1},
    {field_right, 2},
  [32] =
    {field_path, 2},
    {field_tags, 3},
  [34] =
    {field_path, 1},
    {field_symbols, 2},
    {field_tags, 3},
  [37] =
    {field_alternative, 0},
  [38] =
    {field_alternative, 3},
    {field_condition, 1},
    {field_consequence, 2},
  [41] =
    {field_alternative, 3, .inherited = true},
    {field_condition, 1},
    {field_consequence, 2},
  [44] =
    {field_arguments, 3},
    {field_name, 2},
  [46] =
    {field_name, 2},
    {field_returns, 3},
  [48] =
    {field_body, 3},
    {field_name, 2},
  [50] =
    {field_returns, 1},
  [51] =
    {field_arguments, 1},
  [52] =
    {field_type, 1},
  [53] =
    {field_name, 3},
    {field_visibility, 1},
  [55] =
    {field_body, 3},
    {field_name, 2},
    {field_visibility, 1},
  [58] =
    {field_arguments, 2},
    {field_body, 3},
    {field_name, 1},
  [61] =
    {field_body, 3},
    {field_name, 1},
    {field_returns, 2},
  [64] =
    {field_body, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [67] =
    {field_arguments, 1},
    {field_body, 3},
    {field_returns, 2},
  [70] =
    {field_body, 3},
    {field_modifier, 1},
    {field_returns, 2},
  [73] =
    {field_arguments, 2},
    {field_body, 3},
    {field_modifier, 1},
  [76] =
    {field_body, 3},
    {field_modifier, 1},
    {field_name, 2},
  [79] =
    {field_name, 1},
    {field_value, 3},
  [81] =
    {field_body, 3},
    {field_name, 1},
    {field_requirements, 2},
  [84] =
    {field_body, 3},
    {field_bounds, 2},
    {field_name, 1},
  [87] =
    {field_value, 1},
  [88] =
    {field_arguments, 3},
    {field_name, 2},
    {field_receiver, 0},
  [91] =
    {field_alternative, 3, .inherited = true},
    {field_alternative, 4},
    {field_condition, 1},
    {field_consequence, 2},
  [95] =
    {field_alternative, 0, .inherited = true},
    {field_alternative, 1, .inherited = true},
  [97] =
    {field_name, 0},
    {field_type, 2},
  [99] =
    {field_arguments, 3},
    {field_name, 2},
    {field_returns, 4},
  [102] =
    {field_arguments, 3},
    {field_body, 4},
    {field_name, 2},
  [105] =
    {field_body, 4},
    {field_name, 2},
    {field_returns, 3},
  [108] =
    {field_arguments, 1},
    {field_returns, 2},
  [110] =
    {field_arguments, 4},
    {field_name, 3},
    {field_visibility, 1},
  [113] =
    {field_name, 3},
    {field_returns, 4},
    {field_visibility, 1},
  [116] =
    {field_body, 4},
    {field_name, 3},
    {field_visibility, 1},
  [119] =
    {field_arguments, 3},
    {field_body, 4},
    {field_name, 2},
    {field_visibility, 1},
  [123] =
    {field_body, 4},
    {field_name, 2},
    {field_returns, 3},
    {field_visibility, 1},
  [127] =
    {field_body, 4},
    {field_name, 2},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [131] =
    {field_name, 0},
    {field_requirements, 1},
  [133] =
    {field_arguments, 2},
    {field_body, 4},
    {field_name, 1},
    {field_returns, 3},
  [137] =
    {field_arguments, 3},
    {field_body, 4},
    {field_name, 1},
    {field_type_parameters, 2},
  [141] =
    {field_body, 4},
    {field_name, 1},
    {field_returns, 3},
    {field_type_parameters, 2},
  [145] =
    {field_arguments, 2},
    {field_body, 4},
    {field_modifier, 1},
    {field_returns, 3},
  [149] =
    {field_body, 4},
    {field_modifier, 2},
    {field_name, 3},
    {field_visibility, 1},
  [153] =
    {field_name, 1},
  [154] =
    {field_body, 4},
    {field_modifier, 1},
    {field_name, 2},
    {field_type_parameters, 3},
  [158] =
    {field_name, 2},
    {field_value, 4},
    {field_visibility, 1},
  [161] =
    {field_modifier, 1},
    {field_name, 2},
    {field_value, 4},
  [164] =
    {field_body, 4},
    {field_name, 2},
    {field_requirements, 3},
    {field_visibility, 1},
  [168] =
    {field_body, 4},
    {field_name, 1},
    {field_requirements, 3},
    {field_type_parameters, 2},
  [172] =
    {field_body, 4},
    {field_class, 3},
    {field_trait, 1},
  [175] =
    {field_cases, 3},
    {field_value, 1},
  [177] =
    {field_name, 2},
    {field_receiver, 0},
    {field_value, 4},
  [180] =
    {field_alias, 1},
    {field_alias, 2},
    {field_name, 0},
  [183] =
    {field_arguments, 3},
    {field_body, 5},
    {field_name, 2},
    {field_returns, 4},
  [187] =
    {field_arguments, 4},
    {field_name, 3},
    {field_returns, 5},
    {field_visibility, 1},
  [191] =
    {field_arguments, 4},
    {field_body, 5},
    {field_name, 3},
    {field_visibility, 1},
  [195] =
    {field_body, 5},
    {field_name, 3},
    {field_returns, 4},
    {field_visibility, 1},
  [199] =
    {field_arguments, 3},
    {field_body, 5},
    {field_name, 2},
    {field_returns, 4},
    {field_visibility, 1},
  [204] =
    {field_arguments, 4},
    {field_body, 5},
    {field_name, 2},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [209] =
    {field_body, 5},
    {field_name, 2},
    {field_returns, 4},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [214] =
    {field_arguments, 3},
    {field_body, 5},
    {field_name, 1},
    {field_returns, 4},
    {field_type_parameters, 2},
  [219] =
    {field_body, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [224] =
    {field_arguments, 2},
    {field_name, 1},
  [226] =
    {field_name, 1},
    {field_type, 2},
    {field_type, 3},
    {field_value, 5},
  [230] =
    {field_body, 5},
    {field_name, 2},
    {field_requirements, 4},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [235] =
    {field_name, 2},
    {field_visibility, 1},
  [237] =
    {field_name, 1},
    {field_returns, 2},
  [239] =
    {field_name, 1},
    {field_type_parameters, 2},
  [241] =
    {field_modifier, 1},
    {field_name, 2},
  [243] =
    {field_body, 5},
    {field_bounds, 4},
    {field_class, 3},
    {field_trait, 1},
  [247] =
    {field_condition, 2},
    {field_consequence, 3},
  [249] =
    {field_arguments, 4},
    {field_body, 6},
    {field_name, 3},
    {field_returns, 5},
    {field_visibility, 1},
  [254] =
    {field_arguments, 4},
    {field_body, 6},
    {field_name, 2},
    {field_returns, 5},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [260] =
    {field_name, 1},
    {field_type, 3},
  [262] =
    {field_modifier, 1},
    {field_name, 2},
    {field_type, 3},
    {field_type, 4},
    {field_value, 6},
  [267] =
    {field_arguments, 3},
    {field_name, 2},
    {field_visibility, 1},
  [270] =
    {field_name, 2},
    {field_returns, 3},
    {field_visibility, 1},
  [273] =
    {field_name, 2},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [276] =
    {field_modifier, 2},
    {field_name, 3},
    {field_visibility, 1},
  [279] =
    {field_arguments, 2},
    {field_name, 1},
    {field_returns, 3},
  [282] =
    {field_arguments, 3},
    {field_name, 1},
    {field_type_parameters, 2},
  [285] =
    {field_name, 1},
    {field_returns, 3},
    {field_type_parameters, 2},
  [288] =
    {field_arguments, 3},
    {field_modifier, 1},
    {field_name, 2},
  [291] =
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 3},
  [294] =
    {field_modifier, 1},
    {field_name, 2},
    {field_type_parameters, 3},
  [297] =
    {field_body, 3},
    {field_pattern, 1},
  [299] =
    {field_arguments, 3},
    {field_body, 4},
    {field_modifier, 1},
    {field_name, 2},
  [303] =
    {field_body, 4},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 3},
  [307] =
    {field_name, 2},
    {field_type, 4},
    {field_visibility, 1},
  [310] =
    {field_arguments, 3},
    {field_name, 2},
    {field_returns, 4},
    {field_visibility, 1},
  [314] =
    {field_arguments, 4},
    {field_name, 2},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [318] =
    {field_name, 2},
    {field_returns, 4},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [322] =
    {field_arguments, 4},
    {field_modifier, 2},
    {field_name, 3},
    {field_visibility, 1},
  [326] =
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 4},
    {field_visibility, 1},
  [330] =
    {field_modifier, 2},
    {field_name, 3},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [334] =
    {field_arguments, 3},
    {field_name, 1},
    {field_returns, 4},
    {field_type_parameters, 2},
  [338] =
    {field_arguments, 3},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 4},
  [342] =
    {field_arguments, 4},
    {field_modifier, 1},
    {field_name, 2},
    {field_type_parameters, 3},
  [346] =
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 4},
    {field_type_parameters, 3},
  [350] =
    {field_name, 0},
    {field_pattern, 2},
  [352] =
    {field_arguments, 4},
    {field_body, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_visibility, 1},
  [357] =
    {field_body, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 4},
    {field_visibility, 1},
  [362] =
    {field_arguments, 3},
    {field_body, 5},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 4},
  [367] =
    {field_arguments, 4},
    {field_body, 5},
    {field_modifier, 1},
    {field_name, 2},
    {field_type_parameters, 3},
  [372] =
    {field_body, 5},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 4},
    {field_type_parameters, 3},
  [377] =
    {field_arguments, 4},
    {field_name, 2},
    {field_returns, 5},
    {field_type_parameters, 3},
    {field_visibility, 1},
  [382] =
    {field_arguments, 4},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 5},
    {field_visibility, 1},
  [387] =
    {field_arguments, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [392] =
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 5},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [397] =
    {field_arguments, 4},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 5},
    {field_type_parameters, 3},
  [402] =
    {field_body, 5},
    {field_guard, 2},
    {field_guard, 3},
    {field_pattern, 1},
  [406] =
    {field_arguments, 4},
    {field_body, 6},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 5},
    {field_visibility, 1},
  [412] =
    {field_arguments, 5},
    {field_body, 6},
    {field_modifier, 2},
    {field_name, 3},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [418] =
    {field_body, 6},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 5},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [424] =
    {field_arguments, 4},
    {field_body, 6},
    {field_modifier, 1},
    {field_name, 2},
    {field_returns, 5},
    {field_type_parameters, 3},
  [430] =
    {field_arguments, 5},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 6},
    {field_type_parameters, 4},
    {field_visibility, 1},
  [436] =
    {field_arguments, 5},
    {field_body, 7},
    {field_modifier, 2},
    {field_name, 3},
    {field_returns, 6},
    {field_type_parameters, 4},
    {field_visibility, 1},
};

static const TSSymbol ts_alias_sequences[PRODUCTION_ID_COUNT][MAX_ALIAS_SEQUENCE_LENGTH] = {
  [0] = {0},
  [1] = {
    [0] = sym_identifier_with_special,
  },
  [11] = {
    [0] = alias_sym_type,
  },
  [68] = {
    [1] = sym__method_modifier,
  },
  [71] = {
    [1] = alias_sym_type,
  },
  [73] = {
    [0] = alias_sym_integer_pattern,
  },
  [74] = {
    [0] = alias_sym_identifier_pattern,
  },
  [75] = {
    [0] = sym_namespaced_constant_pattern,
  },
  [76] = {
    [0] = alias_sym_string_pattern,
  },
  [96] = {
    [1] = alias_sym_type,
  },
  [98] = {
    [1] = alias_sym_identifier_pattern,
  },
  [103] = {
    [1] = sym__method_modifier,
  },
};

static const uint16_t ts_non_terminal_alias_map[] = {
  sym_string, 2,
    sym_string,
    alias_sym_string_pattern,
  sym_mutable, 2,
    sym_mutable,
    sym__method_modifier,
  0,
};

static const TSStateId ts_primary_state_ids[STATE_COUNT] = {
  [0] = 0,
  [1] = 1,
  [2] = 2,
  [3] = 2,
  [4] = 2,
  [5] = 2,
  [6] = 6,
  [7] = 7,
  [8] = 8,
  [9] = 9,
  [10] = 10,
  [11] = 11,
  [12] = 8,
  [13] = 13,
  [14] = 10,
  [15] = 15,
  [16] = 15,
  [17] = 9,
  [18] = 11,
  [19] = 19,
  [20] = 19,
  [21] = 15,
  [22] = 19,
  [23] = 13,
  [24] = 13,
  [25] = 25,
  [26] = 26,
  [27] = 27,
  [28] = 26,
  [29] = 27,
  [30] = 25,
  [31] = 25,
  [32] = 26,
  [33] = 25,
  [34] = 25,
  [35] = 35,
  [36] = 26,
  [37] = 25,
  [38] = 26,
  [39] = 26,
  [40] = 40,
  [41] = 41,
  [42] = 35,
  [43] = 43,
  [44] = 44,
  [45] = 45,
  [46] = 46,
  [47] = 47,
  [48] = 47,
  [49] = 44,
  [50] = 43,
  [51] = 51,
  [52] = 45,
  [53] = 46,
  [54] = 51,
  [55] = 51,
  [56] = 46,
  [57] = 44,
  [58] = 47,
  [59] = 45,
  [60] = 43,
  [61] = 61,
  [62] = 62,
  [63] = 63,
  [64] = 64,
  [65] = 65,
  [66] = 66,
  [67] = 67,
  [68] = 68,
  [69] = 69,
  [70] = 70,
  [71] = 71,
  [72] = 72,
  [73] = 72,
  [74] = 74,
  [75] = 68,
  [76] = 76,
  [77] = 67,
  [78] = 64,
  [79] = 79,
  [80] = 80,
  [81] = 81,
  [82] = 82,
  [83] = 83,
  [84] = 84,
  [85] = 62,
  [86] = 86,
  [87] = 87,
  [88] = 63,
  [89] = 89,
  [90] = 62,
  [91] = 70,
  [92] = 92,
  [93] = 61,
  [94] = 79,
  [95] = 80,
  [96] = 81,
  [97] = 82,
  [98] = 83,
  [99] = 74,
  [100] = 100,
  [101] = 84,
  [102] = 89,
  [103] = 103,
  [104] = 103,
  [105] = 89,
  [106] = 84,
  [107] = 92,
  [108] = 83,
  [109] = 66,
  [110] = 82,
  [111] = 64,
  [112] = 69,
  [113] = 81,
  [114] = 63,
  [115] = 92,
  [116] = 64,
  [117] = 76,
  [118] = 63,
  [119] = 80,
  [120] = 66,
  [121] = 79,
  [122] = 61,
  [123] = 70,
  [124] = 71,
  [125] = 69,
  [126] = 76,
  [127] = 127,
  [128] = 84,
  [129] = 65,
  [130] = 68,
  [131] = 72,
  [132] = 66,
  [133] = 67,
  [134] = 69,
  [135] = 81,
  [136] = 71,
  [137] = 61,
  [138] = 65,
  [139] = 79,
  [140] = 80,
  [141] = 141,
  [142] = 62,
  [143] = 141,
  [144] = 141,
  [145] = 82,
  [146] = 103,
  [147] = 147,
  [148] = 148,
  [149] = 74,
  [150] = 67,
  [151] = 70,
  [152] = 76,
  [153] = 103,
  [154] = 154,
  [155] = 89,
  [156] = 71,
  [157] = 83,
  [158] = 74,
  [159] = 159,
  [160] = 160,
  [161] = 161,
  [162] = 162,
  [163] = 163,
  [164] = 164,
  [165] = 165,
  [166] = 166,
  [167] = 167,
  [168] = 168,
  [169] = 169,
  [170] = 170,
  [171] = 171,
  [172] = 172,
  [173] = 173,
  [174] = 174,
  [175] = 175,
  [176] = 176,
  [177] = 177,
  [178] = 178,
  [179] = 179,
  [180] = 180,
  [181] = 181,
  [182] = 182,
  [183] = 183,
  [184] = 184,
  [185] = 185,
  [186] = 186,
  [187] = 187,
  [188] = 188,
  [189] = 189,
  [190] = 190,
  [191] = 191,
  [192] = 192,
  [193] = 193,
  [194] = 194,
  [195] = 195,
  [196] = 196,
  [197] = 197,
  [198] = 198,
  [199] = 199,
  [200] = 200,
  [201] = 201,
  [202] = 202,
  [203] = 203,
  [204] = 204,
  [205] = 205,
  [206] = 206,
  [207] = 207,
  [208] = 208,
  [209] = 209,
  [210] = 210,
  [211] = 211,
  [212] = 212,
  [213] = 213,
  [214] = 214,
  [215] = 215,
  [216] = 216,
  [217] = 217,
  [218] = 218,
  [219] = 219,
  [220] = 220,
  [221] = 221,
  [222] = 183,
  [223] = 223,
  [224] = 224,
  [225] = 225,
  [226] = 226,
  [227] = 227,
  [228] = 228,
  [229] = 229,
  [230] = 180,
  [231] = 231,
  [232] = 232,
  [233] = 233,
  [234] = 234,
  [235] = 235,
  [236] = 236,
  [237] = 237,
  [238] = 174,
  [239] = 239,
  [240] = 240,
  [241] = 241,
  [242] = 242,
  [243] = 243,
  [244] = 244,
  [245] = 245,
  [246] = 246,
  [247] = 247,
  [248] = 248,
  [249] = 249,
  [250] = 250,
  [251] = 251,
  [252] = 252,
  [253] = 253,
  [254] = 254,
  [255] = 166,
  [256] = 256,
  [257] = 175,
  [258] = 176,
  [259] = 177,
  [260] = 179,
  [261] = 178,
  [262] = 182,
  [263] = 180,
  [264] = 183,
  [265] = 185,
  [266] = 188,
  [267] = 162,
  [268] = 181,
  [269] = 187,
  [270] = 186,
  [271] = 159,
  [272] = 160,
  [273] = 161,
  [274] = 184,
  [275] = 171,
  [276] = 200,
  [277] = 173,
  [278] = 229,
  [279] = 234,
  [280] = 249,
  [281] = 233,
  [282] = 223,
  [283] = 197,
  [284] = 235,
  [285] = 198,
  [286] = 253,
  [287] = 216,
  [288] = 163,
  [289] = 256,
  [290] = 252,
  [291] = 196,
  [292] = 199,
  [293] = 201,
  [294] = 202,
  [295] = 213,
  [296] = 245,
  [297] = 231,
  [298] = 209,
  [299] = 210,
  [300] = 219,
  [301] = 221,
  [302] = 165,
  [303] = 208,
  [304] = 205,
  [305] = 183,
  [306] = 203,
  [307] = 164,
  [308] = 242,
  [309] = 189,
  [310] = 310,
  [311] = 251,
  [312] = 190,
  [313] = 232,
  [314] = 225,
  [315] = 254,
  [316] = 224,
  [317] = 220,
  [318] = 217,
  [319] = 248,
  [320] = 218,
  [321] = 211,
  [322] = 226,
  [323] = 207,
  [324] = 241,
  [325] = 239,
  [326] = 250,
  [327] = 212,
  [328] = 247,
  [329] = 246,
  [330] = 237,
  [331] = 244,
  [332] = 243,
  [333] = 167,
  [334] = 168,
  [335] = 169,
  [336] = 170,
  [337] = 236,
  [338] = 214,
  [339] = 172,
  [340] = 206,
  [341] = 227,
  [342] = 204,
  [343] = 195,
  [344] = 194,
  [345] = 180,
  [346] = 228,
  [347] = 193,
  [348] = 192,
  [349] = 8,
  [350] = 11,
  [351] = 10,
  [352] = 9,
  [353] = 353,
  [354] = 8,
  [355] = 11,
  [356] = 9,
  [357] = 10,
  [358] = 223,
  [359] = 359,
  [360] = 360,
  [361] = 175,
  [362] = 362,
  [363] = 363,
  [364] = 364,
  [365] = 365,
  [366] = 366,
  [367] = 178,
  [368] = 368,
  [369] = 369,
  [370] = 370,
  [371] = 371,
  [372] = 372,
  [373] = 373,
  [374] = 374,
  [375] = 161,
  [376] = 376,
  [377] = 377,
  [378] = 378,
  [379] = 379,
  [380] = 380,
  [381] = 381,
  [382] = 382,
  [383] = 383,
  [384] = 160,
  [385] = 159,
  [386] = 386,
  [387] = 387,
  [388] = 388,
  [389] = 182,
  [390] = 162,
  [391] = 391,
  [392] = 392,
  [393] = 170,
  [394] = 394,
  [395] = 395,
  [396] = 396,
  [397] = 397,
  [398] = 398,
  [399] = 399,
  [400] = 400,
  [401] = 401,
  [402] = 402,
  [403] = 403,
  [404] = 165,
  [405] = 405,
  [406] = 245,
  [407] = 407,
  [408] = 408,
  [409] = 409,
  [410] = 410,
  [411] = 411,
  [412] = 412,
  [413] = 413,
  [414] = 414,
  [415] = 415,
  [416] = 416,
  [417] = 417,
  [418] = 418,
  [419] = 419,
  [420] = 420,
  [421] = 421,
  [422] = 232,
  [423] = 423,
  [424] = 163,
  [425] = 425,
  [426] = 426,
  [427] = 427,
  [428] = 428,
  [429] = 172,
  [430] = 430,
  [431] = 431,
  [432] = 432,
  [433] = 433,
  [434] = 434,
  [435] = 435,
  [436] = 171,
  [437] = 437,
  [438] = 175,
  [439] = 164,
  [440] = 440,
  [441] = 441,
  [442] = 253,
  [443] = 169,
  [444] = 168,
  [445] = 445,
  [446] = 446,
  [447] = 447,
  [448] = 448,
  [449] = 449,
  [450] = 450,
  [451] = 167,
  [452] = 452,
  [453] = 453,
  [454] = 454,
  [455] = 455,
  [456] = 456,
  [457] = 457,
  [458] = 458,
  [459] = 207,
  [460] = 460,
  [461] = 461,
  [462] = 462,
  [463] = 182,
  [464] = 183,
  [465] = 465,
  [466] = 466,
  [467] = 467,
  [468] = 468,
  [469] = 180,
  [470] = 470,
  [471] = 471,
  [472] = 234,
  [473] = 173,
  [474] = 234,
  [475] = 253,
  [476] = 232,
  [477] = 174,
  [478] = 166,
  [479] = 245,
  [480] = 207,
  [481] = 178,
  [482] = 176,
  [483] = 183,
  [484] = 180,
  [485] = 171,
  [486] = 163,
  [487] = 173,
  [488] = 161,
  [489] = 223,
  [490] = 167,
  [491] = 168,
  [492] = 169,
  [493] = 159,
  [494] = 179,
  [495] = 162,
  [496] = 170,
  [497] = 172,
  [498] = 160,
  [499] = 165,
  [500] = 164,
  [501] = 198,
  [502] = 181,
  [503] = 503,
  [504] = 186,
  [505] = 218,
  [506] = 177,
  [507] = 188,
  [508] = 187,
  [509] = 185,
  [510] = 195,
  [511] = 197,
  [512] = 219,
  [513] = 233,
  [514] = 192,
  [515] = 204,
  [516] = 203,
  [517] = 206,
  [518] = 221,
  [519] = 196,
  [520] = 205,
  [521] = 199,
  [522] = 251,
  [523] = 208,
  [524] = 235,
  [525] = 249,
  [526] = 213,
  [527] = 202,
  [528] = 189,
  [529] = 243,
  [530] = 244,
  [531] = 246,
  [532] = 231,
  [533] = 247,
  [534] = 224,
  [535] = 256,
  [536] = 226,
  [537] = 211,
  [538] = 248,
  [539] = 254,
  [540] = 227,
  [541] = 209,
  [542] = 190,
  [543] = 177,
  [544] = 184,
  [545] = 250,
  [546] = 193,
  [547] = 228,
  [548] = 220,
  [549] = 239,
  [550] = 210,
  [551] = 252,
  [552] = 242,
  [553] = 201,
  [554] = 200,
  [555] = 194,
  [556] = 217,
  [557] = 229,
  [558] = 558,
  [559] = 237,
  [560] = 214,
  [561] = 236,
  [562] = 216,
  [563] = 212,
  [564] = 241,
  [565] = 225,
  [566] = 184,
  [567] = 567,
  [568] = 194,
  [569] = 212,
  [570] = 570,
  [571] = 241,
  [572] = 252,
  [573] = 242,
  [574] = 193,
  [575] = 575,
  [576] = 210,
  [577] = 216,
  [578] = 214,
  [579] = 228,
  [580] = 580,
  [581] = 236,
  [582] = 582,
  [583] = 200,
  [584] = 229,
  [585] = 580,
  [586] = 582,
  [587] = 587,
  [588] = 250,
  [589] = 217,
  [590] = 220,
  [591] = 225,
  [592] = 580,
  [593] = 582,
  [594] = 237,
  [595] = 239,
  [596] = 201,
  [597] = 597,
  [598] = 598,
  [599] = 599,
  [600] = 599,
  [601] = 601,
  [602] = 602,
  [603] = 603,
  [604] = 604,
  [605] = 602,
  [606] = 603,
  [607] = 599,
  [608] = 603,
  [609] = 602,
  [610] = 604,
  [611] = 604,
  [612] = 612,
  [613] = 613,
  [614] = 613,
  [615] = 613,
  [616] = 616,
  [617] = 617,
  [618] = 618,
  [619] = 619,
  [620] = 620,
  [621] = 621,
  [622] = 622,
  [623] = 623,
  [624] = 624,
  [625] = 625,
  [626] = 626,
  [627] = 627,
  [628] = 628,
  [629] = 629,
  [630] = 630,
  [631] = 631,
  [632] = 632,
  [633] = 633,
  [634] = 634,
  [635] = 635,
  [636] = 636,
  [637] = 636,
  [638] = 636,
  [639] = 636,
  [640] = 640,
  [641] = 640,
  [642] = 642,
  [643] = 643,
  [644] = 644,
  [645] = 645,
  [646] = 640,
  [647] = 647,
  [648] = 642,
  [649] = 643,
  [650] = 650,
  [651] = 651,
  [652] = 640,
  [653] = 647,
  [654] = 645,
  [655] = 644,
  [656] = 643,
  [657] = 642,
  [658] = 658,
  [659] = 659,
  [660] = 659,
  [661] = 645,
  [662] = 644,
  [663] = 659,
  [664] = 642,
  [665] = 643,
  [666] = 659,
  [667] = 645,
  [668] = 668,
  [669] = 647,
  [670] = 644,
  [671] = 647,
  [672] = 672,
  [673] = 673,
  [674] = 673,
  [675] = 675,
  [676] = 676,
  [677] = 677,
  [678] = 678,
  [679] = 679,
  [680] = 680,
  [681] = 680,
  [682] = 682,
  [683] = 683,
  [684] = 682,
  [685] = 679,
  [686] = 675,
  [687] = 673,
  [688] = 683,
  [689] = 689,
  [690] = 677,
  [691] = 675,
  [692] = 677,
  [693] = 693,
  [694] = 675,
  [695] = 678,
  [696] = 680,
  [697] = 679,
  [698] = 678,
  [699] = 673,
  [700] = 700,
  [701] = 680,
  [702] = 682,
  [703] = 675,
  [704] = 677,
  [705] = 683,
  [706] = 682,
  [707] = 679,
  [708] = 673,
  [709] = 682,
  [710] = 679,
  [711] = 677,
  [712] = 678,
  [713] = 713,
  [714] = 714,
  [715] = 715,
  [716] = 716,
  [717] = 717,
  [718] = 716,
  [719] = 719,
  [720] = 720,
  [721] = 721,
  [722] = 715,
  [723] = 714,
  [724] = 724,
  [725] = 717,
  [726] = 714,
  [727] = 716,
  [728] = 728,
  [729] = 717,
  [730] = 715,
  [731] = 175,
  [732] = 732,
  [733] = 733,
  [734] = 734,
  [735] = 735,
  [736] = 735,
  [737] = 737,
  [738] = 738,
  [739] = 739,
  [740] = 740,
  [741] = 741,
  [742] = 742,
  [743] = 743,
  [744] = 735,
  [745] = 745,
  [746] = 746,
  [747] = 747,
  [748] = 748,
  [749] = 749,
  [750] = 750,
  [751] = 751,
  [752] = 752,
  [753] = 178,
  [754] = 754,
  [755] = 755,
  [756] = 749,
  [757] = 757,
  [758] = 758,
  [759] = 759,
  [760] = 758,
  [761] = 761,
  [762] = 762,
  [763] = 763,
  [764] = 754,
  [765] = 763,
  [766] = 766,
  [767] = 767,
  [768] = 768,
  [769] = 769,
  [770] = 770,
  [771] = 771,
  [772] = 772,
  [773] = 773,
  [774] = 774,
  [775] = 775,
  [776] = 776,
  [777] = 777,
  [778] = 778,
  [779] = 779,
  [780] = 780,
  [781] = 781,
  [782] = 782,
  [783] = 783,
  [784] = 784,
  [785] = 777,
  [786] = 786,
  [787] = 787,
  [788] = 788,
  [789] = 789,
  [790] = 790,
  [791] = 791,
  [792] = 374,
  [793] = 793,
  [794] = 794,
  [795] = 795,
  [796] = 796,
  [797] = 797,
  [798] = 798,
  [799] = 799,
  [800] = 800,
  [801] = 801,
  [802] = 802,
  [803] = 777,
  [804] = 804,
  [805] = 805,
  [806] = 806,
  [807] = 807,
  [808] = 808,
  [809] = 809,
  [810] = 810,
  [811] = 811,
  [812] = 812,
  [813] = 813,
  [814] = 814,
  [815] = 815,
  [816] = 816,
  [817] = 813,
  [818] = 813,
  [819] = 819,
  [820] = 820,
  [821] = 821,
  [822] = 822,
  [823] = 823,
  [824] = 824,
  [825] = 825,
  [826] = 826,
  [827] = 827,
  [828] = 828,
  [829] = 813,
  [830] = 830,
  [831] = 831,
  [832] = 832,
  [833] = 833,
  [834] = 834,
  [835] = 835,
  [836] = 836,
  [837] = 837,
  [838] = 838,
  [839] = 839,
  [840] = 840,
  [841] = 841,
  [842] = 842,
  [843] = 843,
  [844] = 844,
  [845] = 845,
  [846] = 846,
  [847] = 847,
  [848] = 848,
  [849] = 849,
  [850] = 850,
  [851] = 851,
  [852] = 852,
  [853] = 853,
  [854] = 854,
  [855] = 855,
  [856] = 856,
  [857] = 857,
  [858] = 858,
  [859] = 851,
  [860] = 860,
  [861] = 836,
  [862] = 862,
  [863] = 863,
  [864] = 864,
  [865] = 865,
  [866] = 866,
  [867] = 867,
  [868] = 868,
  [869] = 869,
  [870] = 870,
  [871] = 871,
  [872] = 872,
  [873] = 873,
  [874] = 874,
  [875] = 875,
  [876] = 876,
  [877] = 877,
  [878] = 834,
  [879] = 879,
  [880] = 880,
  [881] = 881,
  [882] = 882,
  [883] = 883,
  [884] = 884,
  [885] = 885,
  [886] = 886,
  [887] = 887,
  [888] = 888,
  [889] = 889,
  [890] = 890,
  [891] = 891,
  [892] = 892,
  [893] = 893,
  [894] = 894,
  [895] = 851,
  [896] = 896,
  [897] = 836,
  [898] = 898,
  [899] = 899,
  [900] = 834,
  [901] = 901,
  [902] = 902,
  [903] = 903,
  [904] = 904,
  [905] = 905,
  [906] = 906,
  [907] = 907,
  [908] = 908,
  [909] = 909,
  [910] = 910,
  [911] = 911,
  [912] = 912,
  [913] = 913,
  [914] = 914,
  [915] = 915,
  [916] = 916,
  [917] = 917,
  [918] = 918,
  [919] = 919,
  [920] = 920,
  [921] = 921,
  [922] = 922,
  [923] = 923,
  [924] = 924,
  [925] = 925,
  [926] = 926,
  [927] = 927,
  [928] = 928,
  [929] = 929,
  [930] = 930,
  [931] = 931,
  [932] = 932,
  [933] = 933,
  [934] = 934,
  [935] = 935,
  [936] = 936,
  [937] = 937,
  [938] = 938,
  [939] = 939,
  [940] = 940,
  [941] = 941,
  [942] = 942,
  [943] = 943,
  [944] = 944,
  [945] = 945,
  [946] = 946,
  [947] = 947,
  [948] = 947,
  [949] = 949,
  [950] = 950,
  [951] = 947,
  [952] = 952,
  [953] = 953,
  [954] = 954,
  [955] = 955,
  [956] = 956,
  [957] = 947,
  [958] = 958,
  [959] = 959,
  [960] = 960,
  [961] = 961,
  [962] = 962,
  [963] = 963,
  [964] = 964,
  [965] = 965,
  [966] = 966,
  [967] = 967,
  [968] = 968,
  [969] = 969,
  [970] = 970,
  [971] = 971,
  [972] = 943,
  [973] = 961,
  [974] = 974,
  [975] = 975,
  [976] = 976,
  [977] = 977,
  [978] = 962,
  [979] = 963,
  [980] = 965,
  [981] = 981,
  [982] = 982,
  [983] = 983,
  [984] = 984,
  [985] = 985,
  [986] = 986,
  [987] = 987,
  [988] = 968,
  [989] = 967,
  [990] = 968,
  [991] = 976,
  [992] = 959,
  [993] = 993,
  [994] = 961,
  [995] = 995,
  [996] = 996,
  [997] = 997,
  [998] = 998,
  [999] = 999,
  [1000] = 1000,
  [1001] = 1001,
  [1002] = 1002,
  [1003] = 1003,
  [1004] = 967,
  [1005] = 1005,
  [1006] = 1006,
  [1007] = 985,
  [1008] = 1008,
  [1009] = 1009,
  [1010] = 1010,
  [1011] = 965,
  [1012] = 1012,
  [1013] = 963,
  [1014] = 1014,
  [1015] = 1015,
  [1016] = 1016,
  [1017] = 1017,
  [1018] = 962,
  [1019] = 1019,
  [1020] = 1020,
  [1021] = 1021,
  [1022] = 1022,
  [1023] = 959,
  [1024] = 984,
  [1025] = 961,
  [1026] = 943,
  [1027] = 963,
  [1028] = 976,
  [1029] = 968,
  [1030] = 965,
  [1031] = 962,
  [1032] = 1032,
  [1033] = 1033,
  [1034] = 1034,
  [1035] = 967,
  [1036] = 1036,
  [1037] = 1037,
  [1038] = 985,
  [1039] = 1039,
  [1040] = 984,
  [1041] = 1041,
  [1042] = 1042,
  [1043] = 1043,
  [1044] = 1044,
  [1045] = 1045,
  [1046] = 1046,
  [1047] = 1047,
  [1048] = 1048,
  [1049] = 1049,
  [1050] = 1050,
  [1051] = 1051,
  [1052] = 1052,
  [1053] = 1053,
  [1054] = 1054,
  [1055] = 1055,
  [1056] = 1056,
  [1057] = 1057,
  [1058] = 1058,
  [1059] = 1059,
  [1060] = 1060,
  [1061] = 1061,
  [1062] = 1062,
  [1063] = 1063,
  [1064] = 1064,
  [1065] = 1065,
  [1066] = 1066,
  [1067] = 1067,
  [1068] = 1068,
  [1069] = 1069,
  [1070] = 1070,
  [1071] = 1071,
  [1072] = 1072,
  [1073] = 1073,
  [1074] = 1074,
  [1075] = 1075,
  [1076] = 1076,
  [1077] = 1077,
  [1078] = 1078,
  [1079] = 1079,
  [1080] = 1080,
  [1081] = 1081,
  [1082] = 1082,
  [1083] = 1083,
  [1084] = 1084,
  [1085] = 1085,
  [1086] = 1086,
  [1087] = 1087,
  [1088] = 1088,
  [1089] = 1089,
  [1090] = 1057,
  [1091] = 1091,
  [1092] = 1059,
  [1093] = 1093,
  [1094] = 1094,
  [1095] = 1095,
  [1096] = 1084,
  [1097] = 1097,
  [1098] = 1076,
  [1099] = 1076,
  [1100] = 1100,
  [1101] = 1101,
  [1102] = 1102,
  [1103] = 1084,
  [1104] = 1055,
  [1105] = 1105,
  [1106] = 1106,
  [1107] = 1107,
  [1108] = 1108,
  [1109] = 1109,
  [1110] = 1110,
  [1111] = 1047,
  [1112] = 1048,
  [1113] = 1113,
  [1114] = 1114,
  [1115] = 1115,
  [1116] = 1051,
  [1117] = 1117,
  [1118] = 1118,
  [1119] = 1119,
  [1120] = 1059,
  [1121] = 1121,
  [1122] = 1122,
  [1123] = 1055,
  [1124] = 1124,
  [1125] = 1125,
  [1126] = 1057,
  [1127] = 1127,
  [1128] = 1128,
  [1129] = 1129,
  [1130] = 1130,
  [1131] = 1131,
  [1132] = 1132,
  [1133] = 1133,
  [1134] = 1134,
  [1135] = 1135,
  [1136] = 1136,
  [1137] = 1137,
  [1138] = 1138,
  [1139] = 1139,
  [1140] = 1140,
  [1141] = 1141,
  [1142] = 1142,
  [1143] = 1143,
  [1144] = 1144,
  [1145] = 1145,
  [1146] = 1146,
  [1147] = 1047,
  [1148] = 1148,
  [1149] = 1048,
  [1150] = 1150,
  [1151] = 1151,
  [1152] = 1084,
  [1153] = 1153,
  [1154] = 1051,
  [1155] = 1155,
  [1156] = 1156,
  [1157] = 1157,
  [1158] = 1158,
  [1159] = 1159,
  [1160] = 1160,
  [1161] = 1161,
  [1162] = 1162,
  [1163] = 1163,
  [1164] = 1164,
  [1165] = 1051,
  [1166] = 1166,
  [1167] = 1167,
  [1168] = 1168,
  [1169] = 1169,
  [1170] = 1170,
  [1171] = 1171,
  [1172] = 1172,
  [1173] = 1173,
  [1174] = 1174,
  [1175] = 1175,
  [1176] = 1176,
  [1177] = 1177,
  [1178] = 1178,
  [1179] = 1179,
  [1180] = 1167,
  [1181] = 1181,
  [1182] = 1182,
  [1183] = 1171,
  [1184] = 1184,
  [1185] = 1185,
  [1186] = 1186,
  [1187] = 1181,
  [1188] = 1188,
  [1189] = 1189,
  [1190] = 1178,
  [1191] = 1191,
  [1192] = 1167,
  [1193] = 1193,
  [1194] = 1194,
  [1195] = 1195,
  [1196] = 1196,
  [1197] = 1171,
  [1198] = 1198,
  [1199] = 1182,
  [1200] = 1200,
  [1201] = 1167,
  [1202] = 1185,
  [1203] = 1203,
  [1204] = 1204,
  [1205] = 1179,
  [1206] = 1185,
  [1207] = 1207,
  [1208] = 1208,
  [1209] = 1209,
  [1210] = 1178,
  [1211] = 1178,
  [1212] = 1212,
  [1213] = 1182,
  [1214] = 1171,
  [1215] = 1215,
};

static bool ts_lex(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      if (eof) ADVANCE(50);
      ADVANCE_MAP(
        '!', 26,
        '"', 58,
        '#', 180,
        '$', 164,
        '%', 100,
        '&', 114,
        '\'', 163,
        '(', 155,
        ')', 55,
        '*', 95,
        '+', 86,
        ',', 54,
        '-', 88,
        '.', 52,
        '/', 94,
        '0', 158,
        ':', 122,
        '<', 101,
        '=', 141,
        '>', 103,
        '@', 43,
        '[', 125,
        '\\', 30,
        ']', 126,
        '^', 118,
        'e', 203,
        'm', 193,
        'p', 200,
        's', 196,
        '{', 139,
        '|', 116,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 1:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 100,
        '&', 114,
        '(', 155,
        ')', 55,
        '*', 95,
        '+', 86,
        ',', 54,
        '-', 91,
        '.', 51,
        '/', 94,
        ':', 122,
        '<', 101,
        '=', 141,
        '>', 103,
        '[', 125,
        ']', 126,
        '^', 118,
        '{', 139,
        '|', 116,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 2:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 100,
        '&', 114,
        ')', 55,
        '*', 95,
        '+', 86,
        ',', 54,
        '-', 91,
        '.', 51,
        '/', 94,
        ':', 122,
        '<', 101,
        '=', 141,
        '>', 103,
        '[', 125,
        ']', 126,
        '^', 118,
        '{', 139,
        '|', 116,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(2);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 3:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        '(', 53,
        ')', 55,
        '*', 96,
        '+', 85,
        ',', 54,
        '-', 92,
        '.', 51,
        '/', 93,
        ':', 121,
        '<', 102,
        '=', 28,
        '>', 104,
        '[', 125,
        ']', 126,
        '^', 117,
        '{', 139,
        '|', 115,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(3);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 4:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        '(', 53,
        ')', 55,
        '*', 96,
        '+', 85,
        '-', 92,
        '.', 23,
        '/', 93,
        '<', 102,
        '=', 28,
        '>', 104,
        '^', 117,
        'e', 82,
        'm', 73,
        'p', 80,
        '{', 139,
        '|', 115,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(4);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 5:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        ')', 55,
        '*', 96,
        '+', 85,
        ',', 54,
        '-', 92,
        '.', 51,
        '/', 93,
        '<', 102,
        '=', 28,
        '>', 104,
        ']', 126,
        '^', 117,
        '{', 139,
        '|', 115,
        '}', 140,
        '\t', 156,
        ' ', 156,
      );
      if (('\n' <= lookahead && lookahead <= '\r')) SKIP(6);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 6:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        ')', 55,
        '*', 96,
        '+', 85,
        ',', 54,
        '-', 92,
        '.', 51,
        '/', 93,
        '<', 102,
        '=', 28,
        '>', 104,
        ']', 126,
        '^', 117,
        '{', 139,
        '|', 115,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(6);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 7:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        '*', 96,
        '+', 85,
        '-', 87,
        '/', 93,
        '<', 102,
        '=', 28,
        '>', 104,
        '^', 117,
        'a', 75,
        'm', 72,
        'p', 80,
        's', 77,
        '|', 115,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(7);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 8:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        '*', 96,
        '+', 85,
        '-', 87,
        '/', 93,
        '<', 102,
        '=', 28,
        '>', 104,
        '^', 117,
        'a', 75,
        'm', 72,
        's', 77,
        '|', 115,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(8);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 9:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        '*', 96,
        '+', 85,
        '-', 87,
        '/', 93,
        '<', 102,
        '=', 28,
        '>', 104,
        '^', 117,
        'e', 82,
        '|', 115,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(9);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 10:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        '*', 96,
        '+', 85,
        '-', 87,
        '/', 93,
        '<', 102,
        '=', 28,
        '>', 104,
        '^', 117,
        'm', 72,
        'p', 80,
        '|', 115,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(10);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 11:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        '*', 96,
        '+', 85,
        '-', 87,
        '/', 93,
        '<', 102,
        '=', 28,
        '>', 104,
        '^', 117,
        'm', 72,
        '|', 115,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(11);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 12:
      ADVANCE_MAP(
        '!', 26,
        '#', 180,
        '%', 99,
        '&', 113,
        '*', 96,
        '+', 85,
        '-', 87,
        '/', 93,
        '<', 102,
        '=', 28,
        '>', 104,
        '^', 117,
        '|', 115,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(12);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 13:
      ADVANCE_MAP(
        '"', 58,
        '#', 180,
        '\'', 163,
        '(', 53,
        ')', 55,
        '-', 25,
        '0', 160,
        'm', 201,
        '{', 139,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(13);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(161);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 14:
      if (lookahead == '"') ADVANCE(58);
      if (lookahead == '#') ADVANCE(168);
      if (lookahead == '$') ADVANCE(164);
      if (lookahead == '\\') ADVANCE(30);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(169);
      if (lookahead != 0) ADVANCE(170);
      END_STATE();
    case 15:
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == '(') ADVANCE(53);
      if (lookahead == ')') ADVANCE(55);
      if (lookahead == ']') ADVANCE(126);
      if (lookahead == 'm') ADVANCE(193);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(15);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 16:
      ADVANCE_MAP(
        '#', 180,
        '(', 53,
        ',', 54,
        '-', 29,
        '@', 43,
        ']', 126,
        'm', 34,
        'p', 38,
        '{', 139,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(16);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 17:
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == ')') ADVANCE(55);
      if (lookahead == '-') ADVANCE(25);
      if (lookahead == '.') ADVANCE(23);
      if (lookahead == '0') ADVANCE(160);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(17);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(161);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      END_STATE();
    case 18:
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(195);
      if (lookahead == 'e') ADVANCE(203);
      if (lookahead == 'p') ADVANCE(200);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(18);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 19:
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == 'a') ADVANCE(195);
      if (lookahead == 'e') ADVANCE(203);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(19);
      if (lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 20:
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == 'e') ADVANCE(203);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(20);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 21:
      if (lookahead == '#') ADVANCE(180);
      if (lookahead == 'm') ADVANCE(201);
      if (lookahead == 'p') ADVANCE(200);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(21);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 22:
      if (lookahead == '#') ADVANCE(165);
      if (lookahead == '$') ADVANCE(164);
      if (lookahead == '\'') ADVANCE(163);
      if (lookahead == '\\') ADVANCE(30);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(166);
      if (lookahead != 0) ADVANCE(167);
      END_STATE();
    case 23:
      if (lookahead == '.') ADVANCE(24);
      END_STATE();
    case 24:
      if (lookahead == '.') ADVANCE(123);
      END_STATE();
    case 25:
      if (lookahead == '0') ADVANCE(160);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(161);
      END_STATE();
    case 26:
      if (lookahead == '=') ADVANCE(120);
      END_STATE();
    case 27:
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 28:
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 29:
      if (lookahead == '>') ADVANCE(124);
      END_STATE();
    case 30:
      if (lookahead == '\\') ADVANCE(173);
      if (lookahead == 'u') ADVANCE(175);
      if (lookahead == '"' ||
          lookahead == '$' ||
          lookahead == '\'' ||
          lookahead == '0' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(174);
      END_STATE();
    case 31:
      if (lookahead == 'b') ADVANCE(177);
      END_STATE();
    case 32:
      if (lookahead == 'e') ADVANCE(131);
      END_STATE();
    case 33:
      if (lookahead == 'm') ADVANCE(37);
      END_STATE();
    case 34:
      if (lookahead == 'o') ADVANCE(39);
      if (lookahead == 'u') ADVANCE(36);
      END_STATE();
    case 35:
      if (lookahead == 't') ADVANCE(134);
      END_STATE();
    case 36:
      if (lookahead == 't') ADVANCE(127);
      END_STATE();
    case 37:
      if (lookahead == 'u') ADVANCE(35);
      END_STATE();
    case 38:
      if (lookahead == 'u') ADVANCE(31);
      END_STATE();
    case 39:
      if (lookahead == 'v') ADVANCE(32);
      END_STATE();
    case 40:
      if (lookahead == '+' ||
          lookahead == '-') ADVANCE(41);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(157);
      END_STATE();
    case 41:
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(157);
      END_STATE();
    case 42:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 43:
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(208);
      END_STATE();
    case 44:
      if (eof) ADVANCE(50);
      ADVANCE_MAP(
        '!', 26,
        '"', 58,
        '#', 180,
        '$', 164,
        '%', 100,
        '&', 114,
        '\'', 163,
        '(', 53,
        ')', 55,
        '*', 95,
        '+', 86,
        ',', 54,
        '-', 88,
        '.', 52,
        '/', 94,
        '0', 158,
        ':', 122,
        '<', 101,
        '=', 141,
        '>', 103,
        '@', 43,
        '[', 125,
        '\\', 30,
        ']', 126,
        '^', 118,
        'e', 203,
        'm', 193,
        'p', 200,
        's', 196,
        '{', 139,
        '|', 116,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(44);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 45:
      if (eof) ADVANCE(50);
      ADVANCE_MAP(
        '!', 26,
        '"', 58,
        '#', 180,
        '%', 100,
        '&', 114,
        '\'', 163,
        '(', 155,
        '*', 95,
        '+', 86,
        '-', 89,
        '.', 51,
        '/', 94,
        '0', 158,
        ':', 27,
        '<', 101,
        '=', 141,
        '>', 103,
        '@', 43,
        '[', 125,
        '^', 118,
        'm', 182,
        '{', 139,
        '|', 116,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 46:
      if (eof) ADVANCE(50);
      ADVANCE_MAP(
        '!', 26,
        '"', 58,
        '#', 180,
        '%', 100,
        '&', 114,
        '\'', 163,
        '(', 53,
        ')', 55,
        '*', 95,
        '+', 86,
        ',', 54,
        '-', 88,
        '.', 51,
        '/', 94,
        '0', 158,
        ':', 27,
        '<', 101,
        '=', 141,
        '>', 103,
        '@', 43,
        '[', 125,
        ']', 126,
        '^', 118,
        'm', 182,
        '{', 139,
        '|', 116,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(46);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 47:
      if (eof) ADVANCE(50);
      ADVANCE_MAP(
        '!', 26,
        '"', 58,
        '#', 180,
        '%', 100,
        '&', 114,
        '\'', 163,
        '(', 53,
        '*', 95,
        '+', 86,
        '-', 89,
        '.', 51,
        '/', 94,
        '0', 158,
        ':', 27,
        '<', 101,
        '=', 141,
        '>', 103,
        '@', 43,
        '[', 125,
        '^', 118,
        'm', 182,
        '{', 139,
        '|', 116,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(47);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 48:
      if (eof) ADVANCE(50);
      ADVANCE_MAP(
        '!', 26,
        '"', 58,
        '#', 180,
        '%', 99,
        '&', 113,
        '\'', 163,
        '(', 53,
        '*', 96,
        '+', 85,
        '-', 90,
        '.', 51,
        '/', 93,
        '0', 158,
        '<', 102,
        '=', 28,
        '>', 104,
        '@', 43,
        '[', 125,
        '^', 117,
        'm', 182,
        '{', 139,
        '|', 115,
        '}', 140,
        '\t', 156,
        ' ', 156,
      );
      if (('\n' <= lookahead && lookahead <= '\r')) SKIP(49);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 49:
      if (eof) ADVANCE(50);
      ADVANCE_MAP(
        '!', 26,
        '"', 58,
        '#', 180,
        '%', 99,
        '&', 113,
        '\'', 163,
        '(', 53,
        '*', 96,
        '+', 85,
        '-', 90,
        '.', 51,
        '/', 93,
        '0', 158,
        '<', 102,
        '=', 28,
        '>', 104,
        '@', 43,
        '[', 125,
        '^', 117,
        'm', 182,
        '{', 139,
        '|', 115,
        '}', 140,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(49);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      if (lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      if (('A' <= lookahead && lookahead <= 'Z')) ADVANCE(209);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(ts_builtin_sym_end);
      END_STATE();
    case 51:
      ACCEPT_TOKEN(anon_sym_DOT);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_DOT);
      if (lookahead == '.') ADVANCE(24);
      END_STATE();
    case 53:
      ACCEPT_TOKEN(anon_sym_LPAREN);
      END_STATE();
    case 54:
      ACCEPT_TOKEN(anon_sym_COMMA);
      END_STATE();
    case 55:
      ACCEPT_TOKEN(anon_sym_RPAREN);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(anon_sym_extern);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 57:
      ACCEPT_TOKEN(anon_sym_extern);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_DQUOTE);
      END_STATE();
    case 59:
      ACCEPT_TOKEN(aux_sym_extern_import_path_token1);
      if (lookahead == '\n') ADVANCE(61);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(59);
      END_STATE();
    case 60:
      ACCEPT_TOKEN(aux_sym_extern_import_path_token1);
      if (lookahead == '#') ADVANCE(59);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(60);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '#') ADVANCE(61);
      END_STATE();
    case 61:
      ACCEPT_TOKEN(aux_sym_extern_import_path_token1);
      if (lookahead != 0 &&
          lookahead != '"') ADVANCE(61);
      END_STATE();
    case 62:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      END_STATE();
    case 63:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'a') ADVANCE(79);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'b') ADVANCE(178);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'c') ADVANCE(135);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 66:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'c') ADVANCE(137);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 67:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'e') ADVANCE(74);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 68:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'e') ADVANCE(132);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'i') ADVANCE(66);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 70:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(56);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'n') ADVANCE(65);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'o') ADVANCE(81);
      if (lookahead == 'u') ADVANCE(78);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 73:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'o') ADVANCE(81);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'r') ADVANCE(70);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 75:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 's') ADVANCE(83);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 't') ADVANCE(67);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 77:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 't') ADVANCE(63);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 't') ADVANCE(129);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 79:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 't') ADVANCE(69);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 80:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'u') ADVANCE(64);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'v') ADVANCE(68);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 82:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'x') ADVANCE(76);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 83:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == 'y') ADVANCE(71);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(aux_sym_method_name_token1);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 85:
      ACCEPT_TOKEN(anon_sym_PLUS);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(anon_sym_PLUS);
      if (lookahead == '=') ADVANCE(143);
      END_STATE();
    case 87:
      ACCEPT_TOKEN(anon_sym_DASH);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '0') ADVANCE(158);
      if (lookahead == '=') ADVANCE(144);
      if (lookahead == '>') ADVANCE(124);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '0') ADVANCE(158);
      if (lookahead == '=') ADVANCE(144);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      END_STATE();
    case 90:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '0') ADVANCE(158);
      if (('1' <= lookahead && lookahead <= '9')) ADVANCE(159);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '=') ADVANCE(144);
      if (lookahead == '>') ADVANCE(124);
      END_STATE();
    case 92:
      ACCEPT_TOKEN(anon_sym_DASH);
      if (lookahead == '>') ADVANCE(124);
      END_STATE();
    case 93:
      ACCEPT_TOKEN(anon_sym_SLASH);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_SLASH);
      if (lookahead == '=') ADVANCE(145);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(98);
      if (lookahead == '=') ADVANCE(146);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_STAR);
      if (lookahead == '*') ADVANCE(97);
      END_STATE();
    case 97:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_STAR_STAR);
      if (lookahead == '=') ADVANCE(147);
      END_STATE();
    case 99:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_PERCENT);
      if (lookahead == '=') ADVANCE(148);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(108);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_LT);
      if (lookahead == '<') ADVANCE(107);
      if (lookahead == '=') ADVANCE(105);
      END_STATE();
    case 103:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(106);
      if (lookahead == '>') ADVANCE(109);
      END_STATE();
    case 104:
      ACCEPT_TOKEN(anon_sym_GT);
      if (lookahead == '=') ADVANCE(106);
      if (lookahead == '>') ADVANCE(110);
      END_STATE();
    case 105:
      ACCEPT_TOKEN(anon_sym_LT_EQ);
      END_STATE();
    case 106:
      ACCEPT_TOKEN(anon_sym_GT_EQ);
      END_STATE();
    case 107:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      END_STATE();
    case 108:
      ACCEPT_TOKEN(anon_sym_LT_LT);
      if (lookahead == '=') ADVANCE(149);
      END_STATE();
    case 109:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '=') ADVANCE(150);
      if (lookahead == '>') ADVANCE(112);
      END_STATE();
    case 110:
      ACCEPT_TOKEN(anon_sym_GT_GT);
      if (lookahead == '>') ADVANCE(111);
      END_STATE();
    case 111:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      END_STATE();
    case 112:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT);
      if (lookahead == '=') ADVANCE(151);
      END_STATE();
    case 113:
      ACCEPT_TOKEN(anon_sym_AMP);
      END_STATE();
    case 114:
      ACCEPT_TOKEN(anon_sym_AMP);
      if (lookahead == '=') ADVANCE(152);
      END_STATE();
    case 115:
      ACCEPT_TOKEN(anon_sym_PIPE);
      END_STATE();
    case 116:
      ACCEPT_TOKEN(anon_sym_PIPE);
      if (lookahead == '=') ADVANCE(153);
      END_STATE();
    case 117:
      ACCEPT_TOKEN(anon_sym_CARET);
      END_STATE();
    case 118:
      ACCEPT_TOKEN(anon_sym_CARET);
      if (lookahead == '=') ADVANCE(154);
      END_STATE();
    case 119:
      ACCEPT_TOKEN(anon_sym_EQ_EQ);
      END_STATE();
    case 120:
      ACCEPT_TOKEN(anon_sym_BANG_EQ);
      END_STATE();
    case 121:
      ACCEPT_TOKEN(anon_sym_COLON);
      END_STATE();
    case 122:
      ACCEPT_TOKEN(anon_sym_COLON);
      if (lookahead == '=') ADVANCE(142);
      END_STATE();
    case 123:
      ACCEPT_TOKEN(anon_sym_DOT_DOT_DOT);
      END_STATE();
    case 124:
      ACCEPT_TOKEN(anon_sym_DASH_GT);
      END_STATE();
    case 125:
      ACCEPT_TOKEN(anon_sym_LBRACK);
      END_STATE();
    case 126:
      ACCEPT_TOKEN(anon_sym_RBRACK);
      END_STATE();
    case 127:
      ACCEPT_TOKEN(anon_sym_mut);
      END_STATE();
    case 128:
      ACCEPT_TOKEN(anon_sym_mut);
      if (lookahead == '$') ADVANCE(207);
      if (lookahead == '?') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      END_STATE();
    case 129:
      ACCEPT_TOKEN(anon_sym_mut);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 130:
      ACCEPT_TOKEN(anon_sym_mut);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 131:
      ACCEPT_TOKEN(anon_sym_move);
      END_STATE();
    case 132:
      ACCEPT_TOKEN(anon_sym_move);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 133:
      ACCEPT_TOKEN(anon_sym_move);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 134:
      ACCEPT_TOKEN(anon_sym_asyncmut);
      END_STATE();
    case 135:
      ACCEPT_TOKEN(anon_sym_async);
      if (lookahead == ' ') ADVANCE(33);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 136:
      ACCEPT_TOKEN(anon_sym_async);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 137:
      ACCEPT_TOKEN(anon_sym_static);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 138:
      ACCEPT_TOKEN(anon_sym_static);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 139:
      ACCEPT_TOKEN(anon_sym_LBRACE);
      END_STATE();
    case 140:
      ACCEPT_TOKEN(anon_sym_RBRACE);
      END_STATE();
    case 141:
      ACCEPT_TOKEN(anon_sym_EQ);
      if (lookahead == '=') ADVANCE(119);
      END_STATE();
    case 142:
      ACCEPT_TOKEN(anon_sym_COLON_EQ);
      END_STATE();
    case 143:
      ACCEPT_TOKEN(anon_sym_PLUS_EQ);
      END_STATE();
    case 144:
      ACCEPT_TOKEN(anon_sym_DASH_EQ);
      END_STATE();
    case 145:
      ACCEPT_TOKEN(anon_sym_SLASH_EQ);
      END_STATE();
    case 146:
      ACCEPT_TOKEN(anon_sym_STAR_EQ);
      END_STATE();
    case 147:
      ACCEPT_TOKEN(anon_sym_STAR_STAR_EQ);
      END_STATE();
    case 148:
      ACCEPT_TOKEN(anon_sym_PERCENT_EQ);
      END_STATE();
    case 149:
      ACCEPT_TOKEN(anon_sym_LT_LT_EQ);
      END_STATE();
    case 150:
      ACCEPT_TOKEN(anon_sym_GT_GT_EQ);
      END_STATE();
    case 151:
      ACCEPT_TOKEN(anon_sym_GT_GT_GT_EQ);
      END_STATE();
    case 152:
      ACCEPT_TOKEN(anon_sym_AMP_EQ);
      END_STATE();
    case 153:
      ACCEPT_TOKEN(anon_sym_PIPE_EQ);
      END_STATE();
    case 154:
      ACCEPT_TOKEN(anon_sym_CARET_EQ);
      END_STATE();
    case 155:
      ACCEPT_TOKEN(anon_sym_LPAREN2);
      END_STATE();
    case 156:
      ACCEPT_TOKEN(aux_sym_return_token1);
      if (lookahead == '\t' ||
          lookahead == ' ') ADVANCE(156);
      END_STATE();
    case 157:
      ACCEPT_TOKEN(sym_float);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(157);
      END_STATE();
    case 158:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == 'x') ADVANCE(42);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(159);
      END_STATE();
    case 159:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == '.') ADVANCE(41);
      if (lookahead == 'E' ||
          lookahead == 'e') ADVANCE(40);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(159);
      END_STATE();
    case 160:
      ACCEPT_TOKEN(sym_integer);
      if (lookahead == 'x') ADVANCE(42);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(161);
      END_STATE();
    case 161:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9') ||
          lookahead == '_') ADVANCE(161);
      END_STATE();
    case 162:
      ACCEPT_TOKEN(sym_integer);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(162);
      END_STATE();
    case 163:
      ACCEPT_TOKEN(anon_sym_SQUOTE);
      END_STATE();
    case 164:
      ACCEPT_TOKEN(anon_sym_DOLLAR);
      if (lookahead == '{') ADVANCE(176);
      END_STATE();
    case 165:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '\n') ADVANCE(167);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(165);
      END_STATE();
    case 166:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead == '#') ADVANCE(165);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(166);
      if (lookahead != 0 &&
          lookahead != '#' &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(167);
      END_STATE();
    case 167:
      ACCEPT_TOKEN(aux_sym_string_token1);
      if (lookahead != 0 &&
          lookahead != '$' &&
          lookahead != '\'' &&
          lookahead != '\\') ADVANCE(167);
      END_STATE();
    case 168:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '\n') ADVANCE(170);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(168);
      END_STATE();
    case 169:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead == '#') ADVANCE(168);
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') ADVANCE(169);
      if (lookahead != 0 &&
          (lookahead < '"' || '$' < lookahead) &&
          lookahead != '\\') ADVANCE(170);
      END_STATE();
    case 170:
      ACCEPT_TOKEN(aux_sym_string_token2);
      if (lookahead != 0 &&
          lookahead != '"' &&
          lookahead != '$' &&
          lookahead != '\\') ADVANCE(170);
      END_STATE();
    case 171:
      ACCEPT_TOKEN(anon_sym_BSLASHu_LBRACE);
      END_STATE();
    case 172:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token1);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'F') ||
          ('a' <= lookahead && lookahead <= 'f')) ADVANCE(172);
      END_STATE();
    case 173:
      ACCEPT_TOKEN(anon_sym_BSLASH_BSLASH);
      END_STATE();
    case 174:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token2);
      END_STATE();
    case 175:
      ACCEPT_TOKEN(aux_sym_escape_sequence_token2);
      if (lookahead == '{') ADVANCE(171);
      END_STATE();
    case 176:
      ACCEPT_TOKEN(anon_sym_DOLLAR_LBRACE);
      END_STATE();
    case 177:
      ACCEPT_TOKEN(sym_visibility);
      END_STATE();
    case 178:
      ACCEPT_TOKEN(sym_visibility);
      if (lookahead == '=' ||
          lookahead == '?') ADVANCE(62);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(84);
      END_STATE();
    case 179:
      ACCEPT_TOKEN(sym_visibility);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 180:
      ACCEPT_TOKEN(sym_line_comment);
      if (lookahead != 0 &&
          lookahead != '\n') ADVANCE(180);
      END_STATE();
    case 181:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(207);
      if (lookahead == '?') ADVANCE(206);
      if (lookahead == 't') ADVANCE(128);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      END_STATE();
    case 182:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(207);
      if (lookahead == '?') ADVANCE(206);
      if (lookahead == 'u') ADVANCE(181);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      END_STATE();
    case 183:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == '$') ADVANCE(207);
      if (lookahead == '?') ADVANCE(206);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(183);
      END_STATE();
    case 184:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'a') ADVANCE(199);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('b' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 185:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'b') ADVANCE(179);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 186:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(138);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 187:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'c') ADVANCE(136);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 188:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(194);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 189:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'e') ADVANCE(133);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 190:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'i') ADVANCE(186);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 191:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(57);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 192:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'n') ADVANCE(187);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 193:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'o') ADVANCE(202);
      if (lookahead == 'u') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 194:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'r') ADVANCE(191);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 195:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 's') ADVANCE(204);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 196:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(184);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 197:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(188);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 198:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(130);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 199:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 't') ADVANCE(190);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 200:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(185);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 201:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'u') ADVANCE(198);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 202:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'v') ADVANCE(189);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 203:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'x') ADVANCE(197);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 204:
      ACCEPT_TOKEN(sym_identifier);
      if (lookahead == 'y') ADVANCE(192);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 205:
      ACCEPT_TOKEN(sym_identifier);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(205);
      END_STATE();
    case 206:
      ACCEPT_TOKEN(sym_identifier_with_special);
      END_STATE();
    case 207:
      ACCEPT_TOKEN(sym_identifier_with_special);
      if (lookahead == '?') ADVANCE(206);
      if (lookahead == '$' ||
          ('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(207);
      END_STATE();
    case 208:
      ACCEPT_TOKEN(sym_field);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(208);
      END_STATE();
    case 209:
      ACCEPT_TOKEN(sym_constant);
      if (('0' <= lookahead && lookahead <= '9') ||
          ('A' <= lookahead && lookahead <= 'Z') ||
          lookahead == '_' ||
          ('a' <= lookahead && lookahead <= 'z')) ADVANCE(209);
      END_STATE();
    default:
      return false;
  }
}

static bool ts_lex_keywords(TSLexer *lexer, TSStateId state) {
  START_LEXER();
  eof = lexer->eof(lexer);
  switch (state) {
    case 0:
      ADVANCE_MAP(
        '_', 1,
        'a', 2,
        'b', 3,
        'c', 4,
        'e', 5,
        'f', 6,
        'i', 7,
        'l', 8,
        'm', 9,
        'n', 10,
        'o', 11,
        'r', 12,
        's', 13,
        't', 14,
        'u', 15,
        'w', 16,
      );
      if (('\t' <= lookahead && lookahead <= '\r') ||
          lookahead == ' ') SKIP(0);
      END_STATE();
    case 1:
      ACCEPT_TOKEN(sym_wildcard_pattern);
      END_STATE();
    case 2:
      if (lookahead == 'n') ADVANCE(17);
      if (lookahead == 's') ADVANCE(18);
      END_STATE();
    case 3:
      if (lookahead == 'r') ADVANCE(19);
      if (lookahead == 'u') ADVANCE(20);
      END_STATE();
    case 4:
      if (lookahead == 'a') ADVANCE(21);
      if (lookahead == 'l') ADVANCE(22);
      END_STATE();
    case 5:
      if (lookahead == 'l') ADVANCE(23);
      if (lookahead == 'n') ADVANCE(24);
      END_STATE();
    case 6:
      if (lookahead == 'a') ADVANCE(25);
      if (lookahead == 'n') ADVANCE(26);
      if (lookahead == 'o') ADVANCE(27);
      END_STATE();
    case 7:
      if (lookahead == 'f') ADVANCE(28);
      if (lookahead == 'm') ADVANCE(29);
      END_STATE();
    case 8:
      if (lookahead == 'e') ADVANCE(30);
      if (lookahead == 'o') ADVANCE(31);
      END_STATE();
    case 9:
      if (lookahead == 'a') ADVANCE(32);
      END_STATE();
    case 10:
      if (lookahead == 'e') ADVANCE(33);
      if (lookahead == 'i') ADVANCE(34);
      END_STATE();
    case 11:
      if (lookahead == 'r') ADVANCE(35);
      END_STATE();
    case 12:
      if (lookahead == 'e') ADVANCE(36);
      END_STATE();
    case 13:
      if (lookahead == 'e') ADVANCE(37);
      END_STATE();
    case 14:
      if (lookahead == 'h') ADVANCE(38);
      if (lookahead == 'r') ADVANCE(39);
      END_STATE();
    case 15:
      if (lookahead == 'n') ADVANCE(40);
      END_STATE();
    case 16:
      if (lookahead == 'h') ADVANCE(41);
      END_STATE();
    case 17:
      if (lookahead == 'd') ADVANCE(42);
      END_STATE();
    case 18:
      ACCEPT_TOKEN(anon_sym_as);
      END_STATE();
    case 19:
      if (lookahead == 'e') ADVANCE(43);
      END_STATE();
    case 20:
      if (lookahead == 'i') ADVANCE(44);
      END_STATE();
    case 21:
      if (lookahead == 's') ADVANCE(45);
      END_STATE();
    case 22:
      if (lookahead == 'a') ADVANCE(46);
      END_STATE();
    case 23:
      if (lookahead == 's') ADVANCE(47);
      END_STATE();
    case 24:
      if (lookahead == 'u') ADVANCE(48);
      END_STATE();
    case 25:
      if (lookahead == 'l') ADVANCE(49);
      END_STATE();
    case 26:
      ACCEPT_TOKEN(anon_sym_fn);
      END_STATE();
    case 27:
      if (lookahead == 'r') ADVANCE(50);
      END_STATE();
    case 28:
      ACCEPT_TOKEN(anon_sym_if);
      END_STATE();
    case 29:
      if (lookahead == 'p') ADVANCE(51);
      END_STATE();
    case 30:
      if (lookahead == 't') ADVANCE(52);
      END_STATE();
    case 31:
      if (lookahead == 'o') ADVANCE(53);
      END_STATE();
    case 32:
      if (lookahead == 't') ADVANCE(54);
      END_STATE();
    case 33:
      if (lookahead == 'x') ADVANCE(55);
      END_STATE();
    case 34:
      if (lookahead == 'l') ADVANCE(56);
      END_STATE();
    case 35:
      ACCEPT_TOKEN(anon_sym_or);
      END_STATE();
    case 36:
      if (lookahead == 'c') ADVANCE(57);
      if (lookahead == 'f') ADVANCE(58);
      if (lookahead == 't') ADVANCE(59);
      END_STATE();
    case 37:
      if (lookahead == 'l') ADVANCE(60);
      END_STATE();
    case 38:
      if (lookahead == 'r') ADVANCE(61);
      END_STATE();
    case 39:
      if (lookahead == 'a') ADVANCE(62);
      if (lookahead == 'u') ADVANCE(63);
      if (lookahead == 'y') ADVANCE(64);
      END_STATE();
    case 40:
      if (lookahead == 'i') ADVANCE(65);
      END_STATE();
    case 41:
      if (lookahead == 'i') ADVANCE(66);
      END_STATE();
    case 42:
      ACCEPT_TOKEN(anon_sym_and);
      END_STATE();
    case 43:
      if (lookahead == 'a') ADVANCE(67);
      END_STATE();
    case 44:
      if (lookahead == 'l') ADVANCE(68);
      END_STATE();
    case 45:
      if (lookahead == 'e') ADVANCE(69);
      END_STATE();
    case 46:
      if (lookahead == 's') ADVANCE(70);
      END_STATE();
    case 47:
      if (lookahead == 'e') ADVANCE(71);
      END_STATE();
    case 48:
      if (lookahead == 'm') ADVANCE(72);
      END_STATE();
    case 49:
      if (lookahead == 's') ADVANCE(73);
      END_STATE();
    case 50:
      ACCEPT_TOKEN(anon_sym_for);
      END_STATE();
    case 51:
      if (lookahead == 'l') ADVANCE(74);
      if (lookahead == 'o') ADVANCE(75);
      END_STATE();
    case 52:
      ACCEPT_TOKEN(anon_sym_let);
      END_STATE();
    case 53:
      if (lookahead == 'p') ADVANCE(76);
      END_STATE();
    case 54:
      if (lookahead == 'c') ADVANCE(77);
      END_STATE();
    case 55:
      if (lookahead == 't') ADVANCE(78);
      END_STATE();
    case 56:
      ACCEPT_TOKEN(sym_nil);
      END_STATE();
    case 57:
      if (lookahead == 'o') ADVANCE(79);
      END_STATE();
    case 58:
      ACCEPT_TOKEN(anon_sym_ref);
      END_STATE();
    case 59:
      if (lookahead == 'u') ADVANCE(80);
      END_STATE();
    case 60:
      if (lookahead == 'f') ADVANCE(81);
      END_STATE();
    case 61:
      if (lookahead == 'o') ADVANCE(82);
      END_STATE();
    case 62:
      if (lookahead == 'i') ADVANCE(83);
      END_STATE();
    case 63:
      if (lookahead == 'e') ADVANCE(84);
      END_STATE();
    case 64:
      ACCEPT_TOKEN(anon_sym_try);
      END_STATE();
    case 65:
      ACCEPT_TOKEN(anon_sym_uni);
      END_STATE();
    case 66:
      if (lookahead == 'l') ADVANCE(85);
      END_STATE();
    case 67:
      if (lookahead == 'k') ADVANCE(86);
      END_STATE();
    case 68:
      if (lookahead == 't') ADVANCE(87);
      END_STATE();
    case 69:
      ACCEPT_TOKEN(anon_sym_case);
      END_STATE();
    case 70:
      if (lookahead == 's') ADVANCE(88);
      END_STATE();
    case 71:
      ACCEPT_TOKEN(anon_sym_else);
      END_STATE();
    case 72:
      ACCEPT_TOKEN(anon_sym_enum);
      END_STATE();
    case 73:
      if (lookahead == 'e') ADVANCE(89);
      END_STATE();
    case 74:
      ACCEPT_TOKEN(anon_sym_impl);
      END_STATE();
    case 75:
      if (lookahead == 'r') ADVANCE(90);
      END_STATE();
    case 76:
      ACCEPT_TOKEN(anon_sym_loop);
      END_STATE();
    case 77:
      if (lookahead == 'h') ADVANCE(91);
      END_STATE();
    case 78:
      ACCEPT_TOKEN(sym_next);
      END_STATE();
    case 79:
      if (lookahead == 'v') ADVANCE(92);
      END_STATE();
    case 80:
      if (lookahead == 'r') ADVANCE(93);
      END_STATE();
    case 81:
      ACCEPT_TOKEN(sym_self);
      END_STATE();
    case 82:
      if (lookahead == 'w') ADVANCE(94);
      END_STATE();
    case 83:
      if (lookahead == 't') ADVANCE(95);
      END_STATE();
    case 84:
      ACCEPT_TOKEN(anon_sym_true);
      END_STATE();
    case 85:
      if (lookahead == 'e') ADVANCE(96);
      END_STATE();
    case 86:
      ACCEPT_TOKEN(sym_break);
      END_STATE();
    case 87:
      if (lookahead == 'i') ADVANCE(97);
      END_STATE();
    case 88:
      ACCEPT_TOKEN(anon_sym_class);
      END_STATE();
    case 89:
      ACCEPT_TOKEN(anon_sym_false);
      END_STATE();
    case 90:
      if (lookahead == 't') ADVANCE(98);
      END_STATE();
    case 91:
      ACCEPT_TOKEN(anon_sym_match);
      END_STATE();
    case 92:
      if (lookahead == 'e') ADVANCE(99);
      END_STATE();
    case 93:
      if (lookahead == 'n') ADVANCE(100);
      END_STATE();
    case 94:
      ACCEPT_TOKEN(anon_sym_throw);
      END_STATE();
    case 95:
      ACCEPT_TOKEN(anon_sym_trait);
      END_STATE();
    case 96:
      ACCEPT_TOKEN(anon_sym_while);
      END_STATE();
    case 97:
      if (lookahead == 'n') ADVANCE(101);
      END_STATE();
    case 98:
      ACCEPT_TOKEN(anon_sym_import);
      END_STATE();
    case 99:
      if (lookahead == 'r') ADVANCE(102);
      END_STATE();
    case 100:
      ACCEPT_TOKEN(anon_sym_return);
      END_STATE();
    case 101:
      ACCEPT_TOKEN(anon_sym_builtin);
      END_STATE();
    case 102:
      ACCEPT_TOKEN(anon_sym_recover);
      END_STATE();
    default:
      return false;
  }
}

static const TSLexMode ts_lex_modes[STATE_COUNT] = {
  [0] = {.lex_state = 0},
  [1] = {.lex_state = 46},
  [2] = {.lex_state = 46},
  [3] = {.lex_state = 46},
  [4] = {.lex_state = 46},
  [5] = {.lex_state = 46},
  [6] = {.lex_state = 46},
  [7] = {.lex_state = 46},
  [8] = {.lex_state = 45},
  [9] = {.lex_state = 45},
  [10] = {.lex_state = 45},
  [11] = {.lex_state = 46},
  [12] = {.lex_state = 45},
  [13] = {.lex_state = 46},
  [14] = {.lex_state = 45},
  [15] = {.lex_state = 46},
  [16] = {.lex_state = 46},
  [17] = {.lex_state = 45},
  [18] = {.lex_state = 46},
  [19] = {.lex_state = 46},
  [20] = {.lex_state = 46},
  [21] = {.lex_state = 46},
  [22] = {.lex_state = 46},
  [23] = {.lex_state = 46},
  [24] = {.lex_state = 46},
  [25] = {.lex_state = 46},
  [26] = {.lex_state = 46},
  [27] = {.lex_state = 46},
  [28] = {.lex_state = 46},
  [29] = {.lex_state = 46},
  [30] = {.lex_state = 46},
  [31] = {.lex_state = 46},
  [32] = {.lex_state = 46},
  [33] = {.lex_state = 46},
  [34] = {.lex_state = 46},
  [35] = {.lex_state = 46},
  [36] = {.lex_state = 46},
  [37] = {.lex_state = 46},
  [38] = {.lex_state = 46},
  [39] = {.lex_state = 46},
  [40] = {.lex_state = 46},
  [41] = {.lex_state = 46},
  [42] = {.lex_state = 46},
  [43] = {.lex_state = 46},
  [44] = {.lex_state = 46},
  [45] = {.lex_state = 46},
  [46] = {.lex_state = 46},
  [47] = {.lex_state = 46},
  [48] = {.lex_state = 46},
  [49] = {.lex_state = 46},
  [50] = {.lex_state = 46},
  [51] = {.lex_state = 46},
  [52] = {.lex_state = 46},
  [53] = {.lex_state = 46},
  [54] = {.lex_state = 46},
  [55] = {.lex_state = 46},
  [56] = {.lex_state = 46},
  [57] = {.lex_state = 46},
  [58] = {.lex_state = 46},
  [59] = {.lex_state = 46},
  [60] = {.lex_state = 46},
  [61] = {.lex_state = 46},
  [62] = {.lex_state = 46},
  [63] = {.lex_state = 46},
  [64] = {.lex_state = 46},
  [65] = {.lex_state = 46},
  [66] = {.lex_state = 46},
  [67] = {.lex_state = 46},
  [68] = {.lex_state = 46},
  [69] = {.lex_state = 46},
  [70] = {.lex_state = 46},
  [71] = {.lex_state = 46},
  [72] = {.lex_state = 46},
  [73] = {.lex_state = 46},
  [74] = {.lex_state = 46},
  [75] = {.lex_state = 46},
  [76] = {.lex_state = 46},
  [77] = {.lex_state = 46},
  [78] = {.lex_state = 46},
  [79] = {.lex_state = 46},
  [80] = {.lex_state = 46},
  [81] = {.lex_state = 46},
  [82] = {.lex_state = 46},
  [83] = {.lex_state = 46},
  [84] = {.lex_state = 46},
  [85] = {.lex_state = 46},
  [86] = {.lex_state = 46},
  [87] = {.lex_state = 46},
  [88] = {.lex_state = 46},
  [89] = {.lex_state = 46},
  [90] = {.lex_state = 46},
  [91] = {.lex_state = 46},
  [92] = {.lex_state = 46},
  [93] = {.lex_state = 46},
  [94] = {.lex_state = 46},
  [95] = {.lex_state = 46},
  [96] = {.lex_state = 46},
  [97] = {.lex_state = 46},
  [98] = {.lex_state = 46},
  [99] = {.lex_state = 46},
  [100] = {.lex_state = 46},
  [101] = {.lex_state = 46},
  [102] = {.lex_state = 46},
  [103] = {.lex_state = 46},
  [104] = {.lex_state = 46},
  [105] = {.lex_state = 46},
  [106] = {.lex_state = 46},
  [107] = {.lex_state = 46},
  [108] = {.lex_state = 46},
  [109] = {.lex_state = 46},
  [110] = {.lex_state = 46},
  [111] = {.lex_state = 46},
  [112] = {.lex_state = 46},
  [113] = {.lex_state = 46},
  [114] = {.lex_state = 46},
  [115] = {.lex_state = 46},
  [116] = {.lex_state = 46},
  [117] = {.lex_state = 46},
  [118] = {.lex_state = 46},
  [119] = {.lex_state = 46},
  [120] = {.lex_state = 46},
  [121] = {.lex_state = 46},
  [122] = {.lex_state = 46},
  [123] = {.lex_state = 46},
  [124] = {.lex_state = 46},
  [125] = {.lex_state = 46},
  [126] = {.lex_state = 46},
  [127] = {.lex_state = 46},
  [128] = {.lex_state = 46},
  [129] = {.lex_state = 46},
  [130] = {.lex_state = 46},
  [131] = {.lex_state = 46},
  [132] = {.lex_state = 46},
  [133] = {.lex_state = 46},
  [134] = {.lex_state = 46},
  [135] = {.lex_state = 46},
  [136] = {.lex_state = 46},
  [137] = {.lex_state = 46},
  [138] = {.lex_state = 46},
  [139] = {.lex_state = 46},
  [140] = {.lex_state = 46},
  [141] = {.lex_state = 46},
  [142] = {.lex_state = 46},
  [143] = {.lex_state = 46},
  [144] = {.lex_state = 46},
  [145] = {.lex_state = 46},
  [146] = {.lex_state = 46},
  [147] = {.lex_state = 46},
  [148] = {.lex_state = 46},
  [149] = {.lex_state = 46},
  [150] = {.lex_state = 46},
  [151] = {.lex_state = 46},
  [152] = {.lex_state = 46},
  [153] = {.lex_state = 46},
  [154] = {.lex_state = 46},
  [155] = {.lex_state = 46},
  [156] = {.lex_state = 46},
  [157] = {.lex_state = 46},
  [158] = {.lex_state = 46},
  [159] = {.lex_state = 46},
  [160] = {.lex_state = 46},
  [161] = {.lex_state = 46},
  [162] = {.lex_state = 46},
  [163] = {.lex_state = 46},
  [164] = {.lex_state = 46},
  [165] = {.lex_state = 46},
  [166] = {.lex_state = 46},
  [167] = {.lex_state = 46},
  [168] = {.lex_state = 46},
  [169] = {.lex_state = 46},
  [170] = {.lex_state = 46},
  [171] = {.lex_state = 46},
  [172] = {.lex_state = 46},
  [173] = {.lex_state = 46},
  [174] = {.lex_state = 46},
  [175] = {.lex_state = 46},
  [176] = {.lex_state = 46},
  [177] = {.lex_state = 45},
  [178] = {.lex_state = 46},
  [179] = {.lex_state = 45},
  [180] = {.lex_state = 46},
  [181] = {.lex_state = 45},
  [182] = {.lex_state = 46},
  [183] = {.lex_state = 46},
  [184] = {.lex_state = 48},
  [185] = {.lex_state = 46},
  [186] = {.lex_state = 46},
  [187] = {.lex_state = 45},
  [188] = {.lex_state = 45},
  [189] = {.lex_state = 46},
  [190] = {.lex_state = 46},
  [191] = {.lex_state = 46},
  [192] = {.lex_state = 46},
  [193] = {.lex_state = 46},
  [194] = {.lex_state = 46},
  [195] = {.lex_state = 46},
  [196] = {.lex_state = 46},
  [197] = {.lex_state = 46},
  [198] = {.lex_state = 46},
  [199] = {.lex_state = 46},
  [200] = {.lex_state = 46},
  [201] = {.lex_state = 46},
  [202] = {.lex_state = 46},
  [203] = {.lex_state = 46},
  [204] = {.lex_state = 46},
  [205] = {.lex_state = 46},
  [206] = {.lex_state = 46},
  [207] = {.lex_state = 46},
  [208] = {.lex_state = 46},
  [209] = {.lex_state = 46},
  [210] = {.lex_state = 46},
  [211] = {.lex_state = 46},
  [212] = {.lex_state = 46},
  [213] = {.lex_state = 46},
  [214] = {.lex_state = 46},
  [215] = {.lex_state = 46},
  [216] = {.lex_state = 46},
  [217] = {.lex_state = 46},
  [218] = {.lex_state = 46},
  [219] = {.lex_state = 46},
  [220] = {.lex_state = 46},
  [221] = {.lex_state = 46},
  [222] = {.lex_state = 46},
  [223] = {.lex_state = 46},
  [224] = {.lex_state = 46},
  [225] = {.lex_state = 46},
  [226] = {.lex_state = 46},
  [227] = {.lex_state = 46},
  [228] = {.lex_state = 46},
  [229] = {.lex_state = 46},
  [230] = {.lex_state = 46},
  [231] = {.lex_state = 46},
  [232] = {.lex_state = 46},
  [233] = {.lex_state = 46},
  [234] = {.lex_state = 46},
  [235] = {.lex_state = 46},
  [236] = {.lex_state = 46},
  [237] = {.lex_state = 46},
  [238] = {.lex_state = 46},
  [239] = {.lex_state = 46},
  [240] = {.lex_state = 46},
  [241] = {.lex_state = 46},
  [242] = {.lex_state = 46},
  [243] = {.lex_state = 46},
  [244] = {.lex_state = 46},
  [245] = {.lex_state = 46},
  [246] = {.lex_state = 46},
  [247] = {.lex_state = 46},
  [248] = {.lex_state = 46},
  [249] = {.lex_state = 46},
  [250] = {.lex_state = 46},
  [251] = {.lex_state = 46},
  [252] = {.lex_state = 46},
  [253] = {.lex_state = 46},
  [254] = {.lex_state = 46},
  [255] = {.lex_state = 46},
  [256] = {.lex_state = 46},
  [257] = {.lex_state = 46},
  [258] = {.lex_state = 46},
  [259] = {.lex_state = 45},
  [260] = {.lex_state = 45},
  [261] = {.lex_state = 46},
  [262] = {.lex_state = 46},
  [263] = {.lex_state = 46},
  [264] = {.lex_state = 46},
  [265] = {.lex_state = 46},
  [266] = {.lex_state = 45},
  [267] = {.lex_state = 46},
  [268] = {.lex_state = 45},
  [269] = {.lex_state = 45},
  [270] = {.lex_state = 46},
  [271] = {.lex_state = 46},
  [272] = {.lex_state = 46},
  [273] = {.lex_state = 46},
  [274] = {.lex_state = 48},
  [275] = {.lex_state = 46},
  [276] = {.lex_state = 46},
  [277] = {.lex_state = 46},
  [278] = {.lex_state = 46},
  [279] = {.lex_state = 46},
  [280] = {.lex_state = 46},
  [281] = {.lex_state = 46},
  [282] = {.lex_state = 46},
  [283] = {.lex_state = 46},
  [284] = {.lex_state = 46},
  [285] = {.lex_state = 46},
  [286] = {.lex_state = 46},
  [287] = {.lex_state = 46},
  [288] = {.lex_state = 46},
  [289] = {.lex_state = 46},
  [290] = {.lex_state = 46},
  [291] = {.lex_state = 46},
  [292] = {.lex_state = 46},
  [293] = {.lex_state = 46},
  [294] = {.lex_state = 46},
  [295] = {.lex_state = 46},
  [296] = {.lex_state = 46},
  [297] = {.lex_state = 46},
  [298] = {.lex_state = 46},
  [299] = {.lex_state = 46},
  [300] = {.lex_state = 46},
  [301] = {.lex_state = 46},
  [302] = {.lex_state = 46},
  [303] = {.lex_state = 46},
  [304] = {.lex_state = 46},
  [305] = {.lex_state = 46},
  [306] = {.lex_state = 46},
  [307] = {.lex_state = 46},
  [308] = {.lex_state = 46},
  [309] = {.lex_state = 46},
  [310] = {.lex_state = 46},
  [311] = {.lex_state = 46},
  [312] = {.lex_state = 46},
  [313] = {.lex_state = 46},
  [314] = {.lex_state = 46},
  [315] = {.lex_state = 46},
  [316] = {.lex_state = 46},
  [317] = {.lex_state = 46},
  [318] = {.lex_state = 46},
  [319] = {.lex_state = 46},
  [320] = {.lex_state = 46},
  [321] = {.lex_state = 46},
  [322] = {.lex_state = 46},
  [323] = {.lex_state = 46},
  [324] = {.lex_state = 46},
  [325] = {.lex_state = 46},
  [326] = {.lex_state = 46},
  [327] = {.lex_state = 46},
  [328] = {.lex_state = 46},
  [329] = {.lex_state = 46},
  [330] = {.lex_state = 46},
  [331] = {.lex_state = 46},
  [332] = {.lex_state = 46},
  [333] = {.lex_state = 46},
  [334] = {.lex_state = 46},
  [335] = {.lex_state = 46},
  [336] = {.lex_state = 46},
  [337] = {.lex_state = 46},
  [338] = {.lex_state = 46},
  [339] = {.lex_state = 46},
  [340] = {.lex_state = 46},
  [341] = {.lex_state = 46},
  [342] = {.lex_state = 46},
  [343] = {.lex_state = 46},
  [344] = {.lex_state = 46},
  [345] = {.lex_state = 46},
  [346] = {.lex_state = 46},
  [347] = {.lex_state = 46},
  [348] = {.lex_state = 46},
  [349] = {.lex_state = 1},
  [350] = {.lex_state = 1},
  [351] = {.lex_state = 1},
  [352] = {.lex_state = 1},
  [353] = {.lex_state = 1},
  [354] = {.lex_state = 1},
  [355] = {.lex_state = 1},
  [356] = {.lex_state = 1},
  [357] = {.lex_state = 1},
  [358] = {.lex_state = 46},
  [359] = {.lex_state = 46},
  [360] = {.lex_state = 46},
  [361] = {.lex_state = 46},
  [362] = {.lex_state = 46},
  [363] = {.lex_state = 46},
  [364] = {.lex_state = 46},
  [365] = {.lex_state = 46},
  [366] = {.lex_state = 46},
  [367] = {.lex_state = 46},
  [368] = {.lex_state = 46},
  [369] = {.lex_state = 46},
  [370] = {.lex_state = 46},
  [371] = {.lex_state = 46},
  [372] = {.lex_state = 46},
  [373] = {.lex_state = 46},
  [374] = {.lex_state = 46},
  [375] = {.lex_state = 46},
  [376] = {.lex_state = 46},
  [377] = {.lex_state = 46},
  [378] = {.lex_state = 46},
  [379] = {.lex_state = 46},
  [380] = {.lex_state = 46},
  [381] = {.lex_state = 46},
  [382] = {.lex_state = 46},
  [383] = {.lex_state = 46},
  [384] = {.lex_state = 46},
  [385] = {.lex_state = 46},
  [386] = {.lex_state = 46},
  [387] = {.lex_state = 46},
  [388] = {.lex_state = 46},
  [389] = {.lex_state = 46},
  [390] = {.lex_state = 46},
  [391] = {.lex_state = 46},
  [392] = {.lex_state = 46},
  [393] = {.lex_state = 46},
  [394] = {.lex_state = 46},
  [395] = {.lex_state = 46},
  [396] = {.lex_state = 46},
  [397] = {.lex_state = 46},
  [398] = {.lex_state = 46},
  [399] = {.lex_state = 46},
  [400] = {.lex_state = 46},
  [401] = {.lex_state = 46},
  [402] = {.lex_state = 46},
  [403] = {.lex_state = 46},
  [404] = {.lex_state = 46},
  [405] = {.lex_state = 46},
  [406] = {.lex_state = 46},
  [407] = {.lex_state = 46},
  [408] = {.lex_state = 46},
  [409] = {.lex_state = 46},
  [410] = {.lex_state = 46},
  [411] = {.lex_state = 46},
  [412] = {.lex_state = 46},
  [413] = {.lex_state = 46},
  [414] = {.lex_state = 46},
  [415] = {.lex_state = 46},
  [416] = {.lex_state = 46},
  [417] = {.lex_state = 46},
  [418] = {.lex_state = 46},
  [419] = {.lex_state = 46},
  [420] = {.lex_state = 46},
  [421] = {.lex_state = 46},
  [422] = {.lex_state = 46},
  [423] = {.lex_state = 46},
  [424] = {.lex_state = 46},
  [425] = {.lex_state = 46},
  [426] = {.lex_state = 46},
  [427] = {.lex_state = 46},
  [428] = {.lex_state = 46},
  [429] = {.lex_state = 46},
  [430] = {.lex_state = 46},
  [431] = {.lex_state = 46},
  [432] = {.lex_state = 46},
  [433] = {.lex_state = 46},
  [434] = {.lex_state = 46},
  [435] = {.lex_state = 46},
  [436] = {.lex_state = 46},
  [437] = {.lex_state = 46},
  [438] = {.lex_state = 3},
  [439] = {.lex_state = 46},
  [440] = {.lex_state = 46},
  [441] = {.lex_state = 46},
  [442] = {.lex_state = 46},
  [443] = {.lex_state = 46},
  [444] = {.lex_state = 46},
  [445] = {.lex_state = 46},
  [446] = {.lex_state = 46},
  [447] = {.lex_state = 46},
  [448] = {.lex_state = 46},
  [449] = {.lex_state = 46},
  [450] = {.lex_state = 46},
  [451] = {.lex_state = 46},
  [452] = {.lex_state = 46},
  [453] = {.lex_state = 46},
  [454] = {.lex_state = 46},
  [455] = {.lex_state = 46},
  [456] = {.lex_state = 46},
  [457] = {.lex_state = 46},
  [458] = {.lex_state = 46},
  [459] = {.lex_state = 46},
  [460] = {.lex_state = 46},
  [461] = {.lex_state = 46},
  [462] = {.lex_state = 46},
  [463] = {.lex_state = 1},
  [464] = {.lex_state = 46},
  [465] = {.lex_state = 46},
  [466] = {.lex_state = 46},
  [467] = {.lex_state = 46},
  [468] = {.lex_state = 46},
  [469] = {.lex_state = 46},
  [470] = {.lex_state = 46},
  [471] = {.lex_state = 46},
  [472] = {.lex_state = 46},
  [473] = {.lex_state = 46},
  [474] = {.lex_state = 1},
  [475] = {.lex_state = 1},
  [476] = {.lex_state = 1},
  [477] = {.lex_state = 1},
  [478] = {.lex_state = 1},
  [479] = {.lex_state = 1},
  [480] = {.lex_state = 1},
  [481] = {.lex_state = 1},
  [482] = {.lex_state = 1},
  [483] = {.lex_state = 1},
  [484] = {.lex_state = 1},
  [485] = {.lex_state = 1},
  [486] = {.lex_state = 1},
  [487] = {.lex_state = 1},
  [488] = {.lex_state = 1},
  [489] = {.lex_state = 1},
  [490] = {.lex_state = 1},
  [491] = {.lex_state = 1},
  [492] = {.lex_state = 1},
  [493] = {.lex_state = 1},
  [494] = {.lex_state = 1},
  [495] = {.lex_state = 1},
  [496] = {.lex_state = 1},
  [497] = {.lex_state = 1},
  [498] = {.lex_state = 1},
  [499] = {.lex_state = 1},
  [500] = {.lex_state = 1},
  [501] = {.lex_state = 1},
  [502] = {.lex_state = 1},
  [503] = {.lex_state = 4},
  [504] = {.lex_state = 1},
  [505] = {.lex_state = 1},
  [506] = {.lex_state = 1},
  [507] = {.lex_state = 1},
  [508] = {.lex_state = 1},
  [509] = {.lex_state = 1},
  [510] = {.lex_state = 1},
  [511] = {.lex_state = 1},
  [512] = {.lex_state = 1},
  [513] = {.lex_state = 1},
  [514] = {.lex_state = 1},
  [515] = {.lex_state = 1},
  [516] = {.lex_state = 1},
  [517] = {.lex_state = 1},
  [518] = {.lex_state = 1},
  [519] = {.lex_state = 1},
  [520] = {.lex_state = 1},
  [521] = {.lex_state = 1},
  [522] = {.lex_state = 1},
  [523] = {.lex_state = 1},
  [524] = {.lex_state = 1},
  [525] = {.lex_state = 1},
  [526] = {.lex_state = 1},
  [527] = {.lex_state = 1},
  [528] = {.lex_state = 1},
  [529] = {.lex_state = 1},
  [530] = {.lex_state = 1},
  [531] = {.lex_state = 1},
  [532] = {.lex_state = 1},
  [533] = {.lex_state = 1},
  [534] = {.lex_state = 1},
  [535] = {.lex_state = 1},
  [536] = {.lex_state = 1},
  [537] = {.lex_state = 1},
  [538] = {.lex_state = 1},
  [539] = {.lex_state = 1},
  [540] = {.lex_state = 1},
  [541] = {.lex_state = 1},
  [542] = {.lex_state = 1},
  [543] = {.lex_state = 1},
  [544] = {.lex_state = 5},
  [545] = {.lex_state = 1},
  [546] = {.lex_state = 1},
  [547] = {.lex_state = 1},
  [548] = {.lex_state = 1},
  [549] = {.lex_state = 1},
  [550] = {.lex_state = 1},
  [551] = {.lex_state = 1},
  [552] = {.lex_state = 1},
  [553] = {.lex_state = 1},
  [554] = {.lex_state = 1},
  [555] = {.lex_state = 1},
  [556] = {.lex_state = 1},
  [557] = {.lex_state = 1},
  [558] = {.lex_state = 7},
  [559] = {.lex_state = 1},
  [560] = {.lex_state = 1},
  [561] = {.lex_state = 1},
  [562] = {.lex_state = 1},
  [563] = {.lex_state = 1},
  [564] = {.lex_state = 1},
  [565] = {.lex_state = 1},
  [566] = {.lex_state = 5},
  [567] = {.lex_state = 8},
  [568] = {.lex_state = 1},
  [569] = {.lex_state = 1},
  [570] = {.lex_state = 1},
  [571] = {.lex_state = 1},
  [572] = {.lex_state = 1},
  [573] = {.lex_state = 1},
  [574] = {.lex_state = 1},
  [575] = {.lex_state = 1},
  [576] = {.lex_state = 1},
  [577] = {.lex_state = 1},
  [578] = {.lex_state = 1},
  [579] = {.lex_state = 1},
  [580] = {.lex_state = 1},
  [581] = {.lex_state = 1},
  [582] = {.lex_state = 1},
  [583] = {.lex_state = 1},
  [584] = {.lex_state = 1},
  [585] = {.lex_state = 1},
  [586] = {.lex_state = 1},
  [587] = {.lex_state = 1},
  [588] = {.lex_state = 1},
  [589] = {.lex_state = 1},
  [590] = {.lex_state = 1},
  [591] = {.lex_state = 1},
  [592] = {.lex_state = 1},
  [593] = {.lex_state = 1},
  [594] = {.lex_state = 1},
  [595] = {.lex_state = 1},
  [596] = {.lex_state = 1},
  [597] = {.lex_state = 10},
  [598] = {.lex_state = 1},
  [599] = {.lex_state = 1},
  [600] = {.lex_state = 1},
  [601] = {.lex_state = 1},
  [602] = {.lex_state = 1},
  [603] = {.lex_state = 1},
  [604] = {.lex_state = 1},
  [605] = {.lex_state = 1},
  [606] = {.lex_state = 1},
  [607] = {.lex_state = 1},
  [608] = {.lex_state = 1},
  [609] = {.lex_state = 1},
  [610] = {.lex_state = 1},
  [611] = {.lex_state = 1},
  [612] = {.lex_state = 1},
  [613] = {.lex_state = 1},
  [614] = {.lex_state = 1},
  [615] = {.lex_state = 1},
  [616] = {.lex_state = 11},
  [617] = {.lex_state = 13},
  [618] = {.lex_state = 13},
  [619] = {.lex_state = 9},
  [620] = {.lex_state = 13},
  [621] = {.lex_state = 13},
  [622] = {.lex_state = 13},
  [623] = {.lex_state = 13},
  [624] = {.lex_state = 12},
  [625] = {.lex_state = 12},
  [626] = {.lex_state = 13},
  [627] = {.lex_state = 13},
  [628] = {.lex_state = 12},
  [629] = {.lex_state = 12},
  [630] = {.lex_state = 12},
  [631] = {.lex_state = 12},
  [632] = {.lex_state = 13},
  [633] = {.lex_state = 13},
  [634] = {.lex_state = 12},
  [635] = {.lex_state = 12},
  [636] = {.lex_state = 15},
  [637] = {.lex_state = 15},
  [638] = {.lex_state = 15},
  [639] = {.lex_state = 15},
  [640] = {.lex_state = 15},
  [641] = {.lex_state = 15},
  [642] = {.lex_state = 15},
  [643] = {.lex_state = 15},
  [644] = {.lex_state = 15},
  [645] = {.lex_state = 15},
  [646] = {.lex_state = 15},
  [647] = {.lex_state = 15},
  [648] = {.lex_state = 15},
  [649] = {.lex_state = 15},
  [650] = {.lex_state = 15},
  [651] = {.lex_state = 15},
  [652] = {.lex_state = 15},
  [653] = {.lex_state = 15},
  [654] = {.lex_state = 15},
  [655] = {.lex_state = 15},
  [656] = {.lex_state = 15},
  [657] = {.lex_state = 15},
  [658] = {.lex_state = 15},
  [659] = {.lex_state = 15},
  [660] = {.lex_state = 15},
  [661] = {.lex_state = 15},
  [662] = {.lex_state = 15},
  [663] = {.lex_state = 15},
  [664] = {.lex_state = 15},
  [665] = {.lex_state = 15},
  [666] = {.lex_state = 15},
  [667] = {.lex_state = 15},
  [668] = {.lex_state = 15},
  [669] = {.lex_state = 15},
  [670] = {.lex_state = 15},
  [671] = {.lex_state = 15},
  [672] = {.lex_state = 15},
  [673] = {.lex_state = 15},
  [674] = {.lex_state = 15},
  [675] = {.lex_state = 15},
  [676] = {.lex_state = 15},
  [677] = {.lex_state = 15},
  [678] = {.lex_state = 15},
  [679] = {.lex_state = 15},
  [680] = {.lex_state = 15},
  [681] = {.lex_state = 15},
  [682] = {.lex_state = 15},
  [683] = {.lex_state = 15},
  [684] = {.lex_state = 15},
  [685] = {.lex_state = 15},
  [686] = {.lex_state = 15},
  [687] = {.lex_state = 15},
  [688] = {.lex_state = 15},
  [689] = {.lex_state = 15},
  [690] = {.lex_state = 15},
  [691] = {.lex_state = 15},
  [692] = {.lex_state = 15},
  [693] = {.lex_state = 15},
  [694] = {.lex_state = 15},
  [695] = {.lex_state = 15},
  [696] = {.lex_state = 15},
  [697] = {.lex_state = 15},
  [698] = {.lex_state = 15},
  [699] = {.lex_state = 15},
  [700] = {.lex_state = 15},
  [701] = {.lex_state = 15},
  [702] = {.lex_state = 15},
  [703] = {.lex_state = 15},
  [704] = {.lex_state = 15},
  [705] = {.lex_state = 15},
  [706] = {.lex_state = 15},
  [707] = {.lex_state = 15},
  [708] = {.lex_state = 15},
  [709] = {.lex_state = 15},
  [710] = {.lex_state = 15},
  [711] = {.lex_state = 15},
  [712] = {.lex_state = 15},
  [713] = {.lex_state = 3},
  [714] = {.lex_state = 14},
  [715] = {.lex_state = 22},
  [716] = {.lex_state = 22},
  [717] = {.lex_state = 14},
  [718] = {.lex_state = 22},
  [719] = {.lex_state = 3},
  [720] = {.lex_state = 3},
  [721] = {.lex_state = 3},
  [722] = {.lex_state = 22},
  [723] = {.lex_state = 14},
  [724] = {.lex_state = 14},
  [725] = {.lex_state = 14},
  [726] = {.lex_state = 14},
  [727] = {.lex_state = 22},
  [728] = {.lex_state = 22},
  [729] = {.lex_state = 14},
  [730] = {.lex_state = 22},
  [731] = {.lex_state = 46},
  [732] = {.lex_state = 1},
  [733] = {.lex_state = 1},
  [734] = {.lex_state = 1},
  [735] = {.lex_state = 16},
  [736] = {.lex_state = 16},
  [737] = {.lex_state = 46},
  [738] = {.lex_state = 3},
  [739] = {.lex_state = 46},
  [740] = {.lex_state = 46},
  [741] = {.lex_state = 46},
  [742] = {.lex_state = 3},
  [743] = {.lex_state = 3},
  [744] = {.lex_state = 16},
  [745] = {.lex_state = 46},
  [746] = {.lex_state = 46},
  [747] = {.lex_state = 3},
  [748] = {.lex_state = 3},
  [749] = {.lex_state = 22},
  [750] = {.lex_state = 16},
  [751] = {.lex_state = 16},
  [752] = {.lex_state = 1},
  [753] = {.lex_state = 0},
  [754] = {.lex_state = 14},
  [755] = {.lex_state = 1},
  [756] = {.lex_state = 14},
  [757] = {.lex_state = 18},
  [758] = {.lex_state = 22},
  [759] = {.lex_state = 1},
  [760] = {.lex_state = 14},
  [761] = {.lex_state = 1},
  [762] = {.lex_state = 1},
  [763] = {.lex_state = 14},
  [764] = {.lex_state = 22},
  [765] = {.lex_state = 22},
  [766] = {.lex_state = 1},
  [767] = {.lex_state = 1},
  [768] = {.lex_state = 1},
  [769] = {.lex_state = 46},
  [770] = {.lex_state = 1},
  [771] = {.lex_state = 0},
  [772] = {.lex_state = 3},
  [773] = {.lex_state = 1},
  [774] = {.lex_state = 0},
  [775] = {.lex_state = 1},
  [776] = {.lex_state = 0},
  [777] = {.lex_state = 46},
  [778] = {.lex_state = 46},
  [779] = {.lex_state = 1},
  [780] = {.lex_state = 1},
  [781] = {.lex_state = 1},
  [782] = {.lex_state = 1},
  [783] = {.lex_state = 1},
  [784] = {.lex_state = 1},
  [785] = {.lex_state = 46},
  [786] = {.lex_state = 3},
  [787] = {.lex_state = 1},
  [788] = {.lex_state = 46},
  [789] = {.lex_state = 3},
  [790] = {.lex_state = 1},
  [791] = {.lex_state = 46},
  [792] = {.lex_state = 3},
  [793] = {.lex_state = 1},
  [794] = {.lex_state = 1},
  [795] = {.lex_state = 1},
  [796] = {.lex_state = 1},
  [797] = {.lex_state = 1},
  [798] = {.lex_state = 1},
  [799] = {.lex_state = 1},
  [800] = {.lex_state = 1},
  [801] = {.lex_state = 1},
  [802] = {.lex_state = 1},
  [803] = {.lex_state = 46},
  [804] = {.lex_state = 19},
  [805] = {.lex_state = 46},
  [806] = {.lex_state = 1},
  [807] = {.lex_state = 46},
  [808] = {.lex_state = 3},
  [809] = {.lex_state = 1},
  [810] = {.lex_state = 1},
  [811] = {.lex_state = 3},
  [812] = {.lex_state = 1},
  [813] = {.lex_state = 17},
  [814] = {.lex_state = 1},
  [815] = {.lex_state = 21},
  [816] = {.lex_state = 1},
  [817] = {.lex_state = 17},
  [818] = {.lex_state = 17},
  [819] = {.lex_state = 1},
  [820] = {.lex_state = 1},
  [821] = {.lex_state = 16},
  [822] = {.lex_state = 17},
  [823] = {.lex_state = 1},
  [824] = {.lex_state = 1},
  [825] = {.lex_state = 17},
  [826] = {.lex_state = 1},
  [827] = {.lex_state = 1},
  [828] = {.lex_state = 0},
  [829] = {.lex_state = 17},
  [830] = {.lex_state = 1},
  [831] = {.lex_state = 1},
  [832] = {.lex_state = 1},
  [833] = {.lex_state = 1},
  [834] = {.lex_state = 0},
  [835] = {.lex_state = 0},
  [836] = {.lex_state = 0},
  [837] = {.lex_state = 1},
  [838] = {.lex_state = 0},
  [839] = {.lex_state = 0},
  [840] = {.lex_state = 1},
  [841] = {.lex_state = 1},
  [842] = {.lex_state = 1},
  [843] = {.lex_state = 1},
  [844] = {.lex_state = 0},
  [845] = {.lex_state = 1},
  [846] = {.lex_state = 1},
  [847] = {.lex_state = 1},
  [848] = {.lex_state = 0},
  [849] = {.lex_state = 1},
  [850] = {.lex_state = 1},
  [851] = {.lex_state = 1},
  [852] = {.lex_state = 1},
  [853] = {.lex_state = 1},
  [854] = {.lex_state = 1},
  [855] = {.lex_state = 1},
  [856] = {.lex_state = 0},
  [857] = {.lex_state = 1},
  [858] = {.lex_state = 1},
  [859] = {.lex_state = 1},
  [860] = {.lex_state = 1},
  [861] = {.lex_state = 0},
  [862] = {.lex_state = 1},
  [863] = {.lex_state = 1},
  [864] = {.lex_state = 1},
  [865] = {.lex_state = 0},
  [866] = {.lex_state = 1},
  [867] = {.lex_state = 1},
  [868] = {.lex_state = 1},
  [869] = {.lex_state = 0},
  [870] = {.lex_state = 0},
  [871] = {.lex_state = 1},
  [872] = {.lex_state = 1},
  [873] = {.lex_state = 0},
  [874] = {.lex_state = 1},
  [875] = {.lex_state = 1},
  [876] = {.lex_state = 0},
  [877] = {.lex_state = 1},
  [878] = {.lex_state = 0},
  [879] = {.lex_state = 0},
  [880] = {.lex_state = 0},
  [881] = {.lex_state = 0},
  [882] = {.lex_state = 1},
  [883] = {.lex_state = 1},
  [884] = {.lex_state = 1},
  [885] = {.lex_state = 1},
  [886] = {.lex_state = 1},
  [887] = {.lex_state = 1},
  [888] = {.lex_state = 0},
  [889] = {.lex_state = 1},
  [890] = {.lex_state = 1},
  [891] = {.lex_state = 1},
  [892] = {.lex_state = 1},
  [893] = {.lex_state = 1},
  [894] = {.lex_state = 1},
  [895] = {.lex_state = 1},
  [896] = {.lex_state = 1},
  [897] = {.lex_state = 0},
  [898] = {.lex_state = 1},
  [899] = {.lex_state = 1},
  [900] = {.lex_state = 0},
  [901] = {.lex_state = 1},
  [902] = {.lex_state = 0},
  [903] = {.lex_state = 1},
  [904] = {.lex_state = 1},
  [905] = {.lex_state = 1},
  [906] = {.lex_state = 1},
  [907] = {.lex_state = 0},
  [908] = {.lex_state = 1},
  [909] = {.lex_state = 1},
  [910] = {.lex_state = 0},
  [911] = {.lex_state = 1},
  [912] = {.lex_state = 1},
  [913] = {.lex_state = 0},
  [914] = {.lex_state = 1},
  [915] = {.lex_state = 1},
  [916] = {.lex_state = 0},
  [917] = {.lex_state = 1},
  [918] = {.lex_state = 1},
  [919] = {.lex_state = 0},
  [920] = {.lex_state = 1},
  [921] = {.lex_state = 1},
  [922] = {.lex_state = 1},
  [923] = {.lex_state = 0},
  [924] = {.lex_state = 0},
  [925] = {.lex_state = 1},
  [926] = {.lex_state = 1},
  [927] = {.lex_state = 1},
  [928] = {.lex_state = 0},
  [929] = {.lex_state = 0},
  [930] = {.lex_state = 1},
  [931] = {.lex_state = 0},
  [932] = {.lex_state = 0},
  [933] = {.lex_state = 1},
  [934] = {.lex_state = 0},
  [935] = {.lex_state = 1},
  [936] = {.lex_state = 1},
  [937] = {.lex_state = 1},
  [938] = {.lex_state = 1},
  [939] = {.lex_state = 1},
  [940] = {.lex_state = 1},
  [941] = {.lex_state = 1},
  [942] = {.lex_state = 1},
  [943] = {.lex_state = 0},
  [944] = {.lex_state = 0},
  [945] = {.lex_state = 0},
  [946] = {.lex_state = 0},
  [947] = {.lex_state = 13},
  [948] = {.lex_state = 13},
  [949] = {.lex_state = 1},
  [950] = {.lex_state = 46},
  [951] = {.lex_state = 13},
  [952] = {.lex_state = 0},
  [953] = {.lex_state = 0},
  [954] = {.lex_state = 0},
  [955] = {.lex_state = 1},
  [956] = {.lex_state = 0},
  [957] = {.lex_state = 13},
  [958] = {.lex_state = 20},
  [959] = {.lex_state = 0},
  [960] = {.lex_state = 1},
  [961] = {.lex_state = 0},
  [962] = {.lex_state = 0},
  [963] = {.lex_state = 0},
  [964] = {.lex_state = 1},
  [965] = {.lex_state = 0},
  [966] = {.lex_state = 0},
  [967] = {.lex_state = 0},
  [968] = {.lex_state = 0},
  [969] = {.lex_state = 0},
  [970] = {.lex_state = 0},
  [971] = {.lex_state = 0},
  [972] = {.lex_state = 0},
  [973] = {.lex_state = 0},
  [974] = {.lex_state = 0},
  [975] = {.lex_state = 0},
  [976] = {.lex_state = 1},
  [977] = {.lex_state = 1},
  [978] = {.lex_state = 0},
  [979] = {.lex_state = 0},
  [980] = {.lex_state = 0},
  [981] = {.lex_state = 0},
  [982] = {.lex_state = 0},
  [983] = {.lex_state = 0},
  [984] = {.lex_state = 0},
  [985] = {.lex_state = 0},
  [986] = {.lex_state = 0},
  [987] = {.lex_state = 1},
  [988] = {.lex_state = 0},
  [989] = {.lex_state = 0},
  [990] = {.lex_state = 0},
  [991] = {.lex_state = 1},
  [992] = {.lex_state = 0},
  [993] = {.lex_state = 0},
  [994] = {.lex_state = 0},
  [995] = {.lex_state = 0},
  [996] = {.lex_state = 0},
  [997] = {.lex_state = 0},
  [998] = {.lex_state = 0},
  [999] = {.lex_state = 0},
  [1000] = {.lex_state = 0},
  [1001] = {.lex_state = 0},
  [1002] = {.lex_state = 0},
  [1003] = {.lex_state = 0},
  [1004] = {.lex_state = 0},
  [1005] = {.lex_state = 0},
  [1006] = {.lex_state = 0},
  [1007] = {.lex_state = 0},
  [1008] = {.lex_state = 0},
  [1009] = {.lex_state = 1},
  [1010] = {.lex_state = 1},
  [1011] = {.lex_state = 0},
  [1012] = {.lex_state = 0},
  [1013] = {.lex_state = 0},
  [1014] = {.lex_state = 1},
  [1015] = {.lex_state = 4},
  [1016] = {.lex_state = 0},
  [1017] = {.lex_state = 0},
  [1018] = {.lex_state = 0},
  [1019] = {.lex_state = 0},
  [1020] = {.lex_state = 1},
  [1021] = {.lex_state = 0},
  [1022] = {.lex_state = 1},
  [1023] = {.lex_state = 0},
  [1024] = {.lex_state = 0},
  [1025] = {.lex_state = 0},
  [1026] = {.lex_state = 0},
  [1027] = {.lex_state = 0},
  [1028] = {.lex_state = 1},
  [1029] = {.lex_state = 0},
  [1030] = {.lex_state = 0},
  [1031] = {.lex_state = 0},
  [1032] = {.lex_state = 0},
  [1033] = {.lex_state = 0},
  [1034] = {.lex_state = 0},
  [1035] = {.lex_state = 0},
  [1036] = {.lex_state = 0},
  [1037] = {.lex_state = 0},
  [1038] = {.lex_state = 0},
  [1039] = {.lex_state = 0},
  [1040] = {.lex_state = 0},
  [1041] = {.lex_state = 1},
  [1042] = {.lex_state = 0},
  [1043] = {.lex_state = 0},
  [1044] = {.lex_state = 1},
  [1045] = {.lex_state = 16},
  [1046] = {.lex_state = 0},
  [1047] = {.lex_state = 0},
  [1048] = {.lex_state = 0},
  [1049] = {.lex_state = 1},
  [1050] = {.lex_state = 0},
  [1051] = {.lex_state = 0},
  [1052] = {.lex_state = 1},
  [1053] = {.lex_state = 1},
  [1054] = {.lex_state = 1},
  [1055] = {.lex_state = 0},
  [1056] = {.lex_state = 0},
  [1057] = {.lex_state = 0},
  [1058] = {.lex_state = 1},
  [1059] = {.lex_state = 0},
  [1060] = {.lex_state = 0},
  [1061] = {.lex_state = 0},
  [1062] = {.lex_state = 1},
  [1063] = {.lex_state = 1},
  [1064] = {.lex_state = 0},
  [1065] = {.lex_state = 0},
  [1066] = {.lex_state = 0},
  [1067] = {.lex_state = 1},
  [1068] = {.lex_state = 0},
  [1069] = {.lex_state = 1},
  [1070] = {.lex_state = 0},
  [1071] = {.lex_state = 0},
  [1072] = {.lex_state = 0},
  [1073] = {.lex_state = 0},
  [1074] = {.lex_state = 1},
  [1075] = {.lex_state = 1},
  [1076] = {.lex_state = 0},
  [1077] = {.lex_state = 1},
  [1078] = {.lex_state = 0},
  [1079] = {.lex_state = 1},
  [1080] = {.lex_state = 1},
  [1081] = {.lex_state = 0},
  [1082] = {.lex_state = 0},
  [1083] = {.lex_state = 0},
  [1084] = {.lex_state = 0},
  [1085] = {.lex_state = 0},
  [1086] = {.lex_state = 0},
  [1087] = {.lex_state = 0},
  [1088] = {.lex_state = 0},
  [1089] = {.lex_state = 0},
  [1090] = {.lex_state = 0},
  [1091] = {.lex_state = 0},
  [1092] = {.lex_state = 0},
  [1093] = {.lex_state = 1},
  [1094] = {.lex_state = 1},
  [1095] = {.lex_state = 0},
  [1096] = {.lex_state = 0},
  [1097] = {.lex_state = 16},
  [1098] = {.lex_state = 0},
  [1099] = {.lex_state = 0},
  [1100] = {.lex_state = 0},
  [1101] = {.lex_state = 0},
  [1102] = {.lex_state = 0},
  [1103] = {.lex_state = 0},
  [1104] = {.lex_state = 0},
  [1105] = {.lex_state = 0},
  [1106] = {.lex_state = 0},
  [1107] = {.lex_state = 0},
  [1108] = {.lex_state = 0},
  [1109] = {.lex_state = 0},
  [1110] = {.lex_state = 0},
  [1111] = {.lex_state = 0},
  [1112] = {.lex_state = 0},
  [1113] = {.lex_state = 0},
  [1114] = {.lex_state = 0},
  [1115] = {.lex_state = 0},
  [1116] = {.lex_state = 0},
  [1117] = {.lex_state = 1},
  [1118] = {.lex_state = 1},
  [1119] = {.lex_state = 1},
  [1120] = {.lex_state = 0},
  [1121] = {.lex_state = 0},
  [1122] = {.lex_state = 0},
  [1123] = {.lex_state = 0},
  [1124] = {.lex_state = 1},
  [1125] = {.lex_state = 0},
  [1126] = {.lex_state = 0},
  [1127] = {.lex_state = 0},
  [1128] = {.lex_state = 0},
  [1129] = {.lex_state = 0},
  [1130] = {.lex_state = 1},
  [1131] = {.lex_state = 0},
  [1132] = {.lex_state = 0},
  [1133] = {.lex_state = 0},
  [1134] = {.lex_state = 0},
  [1135] = {.lex_state = 0},
  [1136] = {.lex_state = 0},
  [1137] = {.lex_state = 0},
  [1138] = {.lex_state = 1},
  [1139] = {.lex_state = 0},
  [1140] = {.lex_state = 0},
  [1141] = {.lex_state = 1},
  [1142] = {.lex_state = 1},
  [1143] = {.lex_state = 0},
  [1144] = {.lex_state = 0},
  [1145] = {.lex_state = 1},
  [1146] = {.lex_state = 1},
  [1147] = {.lex_state = 0},
  [1148] = {.lex_state = 0},
  [1149] = {.lex_state = 0},
  [1150] = {.lex_state = 1},
  [1151] = {.lex_state = 1},
  [1152] = {.lex_state = 0},
  [1153] = {.lex_state = 0},
  [1154] = {.lex_state = 0},
  [1155] = {.lex_state = 0},
  [1156] = {.lex_state = 1},
  [1157] = {.lex_state = 1},
  [1158] = {.lex_state = 1},
  [1159] = {.lex_state = 1},
  [1160] = {.lex_state = 0},
  [1161] = {.lex_state = 0},
  [1162] = {.lex_state = 1},
  [1163] = {.lex_state = 0},
  [1164] = {.lex_state = 0},
  [1165] = {.lex_state = 0},
  [1166] = {.lex_state = 1},
  [1167] = {.lex_state = 1},
  [1168] = {.lex_state = 0},
  [1169] = {.lex_state = 0},
  [1170] = {.lex_state = 0},
  [1171] = {.lex_state = 0},
  [1172] = {.lex_state = 0},
  [1173] = {.lex_state = 0},
  [1174] = {.lex_state = 0},
  [1175] = {.lex_state = 0},
  [1176] = {.lex_state = 0},
  [1177] = {.lex_state = 0},
  [1178] = {.lex_state = 0},
  [1179] = {.lex_state = 172},
  [1180] = {.lex_state = 1},
  [1181] = {.lex_state = 0},
  [1182] = {.lex_state = 0},
  [1183] = {.lex_state = 0},
  [1184] = {.lex_state = 0},
  [1185] = {.lex_state = 1},
  [1186] = {.lex_state = 0},
  [1187] = {.lex_state = 0},
  [1188] = {.lex_state = 1},
  [1189] = {.lex_state = 60},
  [1190] = {.lex_state = 0},
  [1191] = {.lex_state = 0},
  [1192] = {.lex_state = 1},
  [1193] = {.lex_state = 0},
  [1194] = {.lex_state = 0},
  [1195] = {.lex_state = 0},
  [1196] = {.lex_state = 0},
  [1197] = {.lex_state = 0},
  [1198] = {.lex_state = 0},
  [1199] = {.lex_state = 0},
  [1200] = {.lex_state = 1},
  [1201] = {.lex_state = 1},
  [1202] = {.lex_state = 1},
  [1203] = {.lex_state = 0},
  [1204] = {.lex_state = 1},
  [1205] = {.lex_state = 172},
  [1206] = {.lex_state = 1},
  [1207] = {.lex_state = 0},
  [1208] = {.lex_state = 0},
  [1209] = {.lex_state = 0},
  [1210] = {.lex_state = 0},
  [1211] = {.lex_state = 0},
  [1212] = {.lex_state = 0},
  [1213] = {.lex_state = 0},
  [1214] = {.lex_state = 0},
  [1215] = {.lex_state = 1},
};

static const uint16_t ts_parse_table[LARGE_STATE_COUNT][SYMBOL_COUNT] = {
  [0] = {
    [ts_builtin_sym_end] = ACTIONS(1),
    [sym_identifier] = ACTIONS(1),
    [anon_sym_import] = ACTIONS(1),
    [anon_sym_DOT] = ACTIONS(1),
    [anon_sym_LPAREN] = ACTIONS(1),
    [anon_sym_COMMA] = ACTIONS(1),
    [anon_sym_RPAREN] = ACTIONS(1),
    [anon_sym_as] = ACTIONS(1),
    [anon_sym_if] = ACTIONS(1),
    [anon_sym_and] = ACTIONS(1),
    [anon_sym_extern] = ACTIONS(1),
    [anon_sym_DQUOTE] = ACTIONS(1),
    [anon_sym_fn] = ACTIONS(1),
    [anon_sym_PLUS] = ACTIONS(1),
    [anon_sym_DASH] = ACTIONS(1),
    [anon_sym_SLASH] = ACTIONS(1),
    [anon_sym_STAR] = ACTIONS(1),
    [anon_sym_STAR_STAR] = ACTIONS(1),
    [anon_sym_PERCENT] = ACTIONS(1),
    [anon_sym_LT] = ACTIONS(1),
    [anon_sym_GT] = ACTIONS(1),
    [anon_sym_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT] = ACTIONS(1),
    [anon_sym_GT_GT] = ACTIONS(1),
    [anon_sym_GT_GT_GT] = ACTIONS(1),
    [anon_sym_AMP] = ACTIONS(1),
    [anon_sym_PIPE] = ACTIONS(1),
    [anon_sym_CARET] = ACTIONS(1),
    [anon_sym_EQ_EQ] = ACTIONS(1),
    [anon_sym_BANG_EQ] = ACTIONS(1),
    [anon_sym_COLON] = ACTIONS(1),
    [anon_sym_DOT_DOT_DOT] = ACTIONS(1),
    [anon_sym_DASH_GT] = ACTIONS(1),
    [anon_sym_LBRACK] = ACTIONS(1),
    [anon_sym_RBRACK] = ACTIONS(1),
    [anon_sym_mut] = ACTIONS(1),
    [anon_sym_move] = ACTIONS(1),
    [anon_sym_static] = ACTIONS(1),
    [anon_sym_class] = ACTIONS(1),
    [anon_sym_builtin] = ACTIONS(1),
    [anon_sym_enum] = ACTIONS(1),
    [anon_sym_LBRACE] = ACTIONS(1),
    [anon_sym_RBRACE] = ACTIONS(1),
    [anon_sym_let] = ACTIONS(1),
    [anon_sym_case] = ACTIONS(1),
    [anon_sym_trait] = ACTIONS(1),
    [anon_sym_impl] = ACTIONS(1),
    [anon_sym_for] = ACTIONS(1),
    [anon_sym_ref] = ACTIONS(1),
    [anon_sym_uni] = ACTIONS(1),
    [anon_sym_EQ] = ACTIONS(1),
    [anon_sym_COLON_EQ] = ACTIONS(1),
    [anon_sym_PLUS_EQ] = ACTIONS(1),
    [anon_sym_DASH_EQ] = ACTIONS(1),
    [anon_sym_SLASH_EQ] = ACTIONS(1),
    [anon_sym_STAR_EQ] = ACTIONS(1),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(1),
    [anon_sym_PERCENT_EQ] = ACTIONS(1),
    [anon_sym_LT_LT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(1),
    [anon_sym_AMP_EQ] = ACTIONS(1),
    [anon_sym_PIPE_EQ] = ACTIONS(1),
    [anon_sym_CARET_EQ] = ACTIONS(1),
    [anon_sym_LPAREN2] = ACTIONS(1),
    [anon_sym_recover] = ACTIONS(1),
    [anon_sym_return] = ACTIONS(1),
    [anon_sym_try] = ACTIONS(1),
    [anon_sym_throw] = ACTIONS(1),
    [anon_sym_else] = ACTIONS(1),
    [anon_sym_while] = ACTIONS(1),
    [anon_sym_loop] = ACTIONS(1),
    [anon_sym_match] = ACTIONS(1),
    [sym_wildcard_pattern] = ACTIONS(1),
    [anon_sym_or] = ACTIONS(1),
    [anon_sym_true] = ACTIONS(1),
    [anon_sym_false] = ACTIONS(1),
    [sym_float] = ACTIONS(1),
    [sym_integer] = ACTIONS(1),
    [anon_sym_SQUOTE] = ACTIONS(1),
    [anon_sym_DOLLAR] = ACTIONS(1),
    [anon_sym_BSLASHu_LBRACE] = ACTIONS(1),
    [anon_sym_BSLASH_BSLASH] = ACTIONS(1),
    [aux_sym_escape_sequence_token2] = ACTIONS(1),
    [anon_sym_DOLLAR_LBRACE] = ACTIONS(1),
    [sym_self] = ACTIONS(1),
    [sym_nil] = ACTIONS(1),
    [sym_break] = ACTIONS(1),
    [sym_next] = ACTIONS(1),
    [sym_visibility] = ACTIONS(1),
    [sym_line_comment] = ACTIONS(3),
    [sym_field] = ACTIONS(1),
    [sym_constant] = ACTIONS(1),
  },
  [1] = {
    [sym_source_file] = STATE(1212),
    [sym__root] = STATE(7),
    [sym_import] = STATE(7),
    [sym_extern_import] = STATE(7),
    [sym_external_function] = STATE(7),
    [sym_module_method] = STATE(7),
    [sym_class] = STATE(7),
    [sym_trait] = STATE(7),
    [sym_implement_trait] = STATE(7),
    [sym_reopen_class] = STATE(7),
    [sym_block] = STATE(191),
    [sym__expression] = STATE(191),
    [sym_assign_receiver_field] = STATE(191),
    [sym_assign_local] = STATE(191),
    [sym_assign_field] = STATE(191),
    [sym_replace_local] = STATE(191),
    [sym_replace_field] = STATE(191),
    [sym_compound_assign_local] = STATE(191),
    [sym_compound_assign_field] = STATE(191),
    [sym_compound_assign_receiver_field] = STATE(191),
    [sym__call_name] = STATE(1059),
    [sym_call] = STATE(191),
    [sym_call_with_receiver] = STATE(191),
    [sym_ref] = STATE(191),
    [sym_mut] = STATE(191),
    [sym_recover] = STATE(191),
    [sym_grouped_expression] = STATE(191),
    [sym_tuple] = STATE(191),
    [sym_array] = STATE(191),
    [sym_return] = STATE(191),
    [sym_try] = STATE(191),
    [sym_throw] = STATE(191),
    [sym_if] = STATE(191),
    [sym_while] = STATE(191),
    [sym_loop] = STATE(191),
    [sym_match] = STATE(191),
    [sym_closure] = STATE(191),
    [sym_define_constant] = STATE(7),
    [sym_define_variable] = STATE(191),
    [sym_and_or] = STATE(191),
    [sym_binary] = STATE(191),
    [sym_cast] = STATE(191),
    [sym_string] = STATE(191),
    [sym_true] = STATE(191),
    [sym_false] = STATE(191),
    [aux_sym_source_file_repeat1] = STATE(7),
    [ts_builtin_sym_end] = ACTIONS(5),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(27),
    [anon_sym_trait] = ACTIONS(29),
    [anon_sym_impl] = ACTIONS(31),
    [anon_sym_ref] = ACTIONS(33),
    [anon_sym_recover] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(37),
    [anon_sym_try] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_loop] = ACTIONS(45),
    [anon_sym_match] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(51),
    [sym_float] = ACTIONS(53),
    [sym_integer] = ACTIONS(55),
    [anon_sym_SQUOTE] = ACTIONS(57),
    [sym_self] = ACTIONS(59),
    [sym_nil] = ACTIONS(59),
    [sym_break] = ACTIONS(59),
    [sym_next] = ACTIONS(59),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(61),
    [sym_field] = ACTIONS(63),
    [sym_constant] = ACTIONS(65),
  },
  [2] = {
    [sym_block] = STATE(225),
    [sym__expression] = STATE(225),
    [sym_assign_receiver_field] = STATE(225),
    [sym_assign_local] = STATE(225),
    [sym_assign_field] = STATE(225),
    [sym_replace_local] = STATE(225),
    [sym_replace_field] = STATE(225),
    [sym_compound_assign_local] = STATE(225),
    [sym_compound_assign_field] = STATE(225),
    [sym_compound_assign_receiver_field] = STATE(225),
    [sym__call_name] = STATE(1059),
    [sym_call] = STATE(225),
    [sym_call_with_receiver] = STATE(225),
    [sym_ref] = STATE(225),
    [sym_mut] = STATE(225),
    [sym_recover] = STATE(225),
    [sym_grouped_expression] = STATE(225),
    [sym_tuple] = STATE(225),
    [sym_array] = STATE(225),
    [sym_return] = STATE(225),
    [sym_try] = STATE(225),
    [sym_throw] = STATE(225),
    [sym_if] = STATE(225),
    [sym_while] = STATE(225),
    [sym_loop] = STATE(225),
    [sym_match] = STATE(225),
    [sym_closure] = STATE(225),
    [sym_define_variable] = STATE(225),
    [sym_and_or] = STATE(225),
    [sym_binary] = STATE(225),
    [sym_cast] = STATE(225),
    [sym_string] = STATE(225),
    [sym_true] = STATE(225),
    [sym_false] = STATE(225),
    [ts_builtin_sym_end] = ACTIONS(67),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(69),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_as] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_and] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(71),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_STAR_STAR] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(69),
    [anon_sym_GT_GT_GT] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_EQ_EQ] = ACTIONS(67),
    [anon_sym_BANG_EQ] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(69),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(73),
    [anon_sym_trait] = ACTIONS(69),
    [anon_sym_impl] = ACTIONS(69),
    [anon_sym_ref] = ACTIONS(33),
    [anon_sym_recover] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(37),
    [anon_sym_try] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_loop] = ACTIONS(45),
    [anon_sym_match] = ACTIONS(47),
    [anon_sym_or] = ACTIONS(69),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(51),
    [sym_float] = ACTIONS(75),
    [sym_integer] = ACTIONS(55),
    [anon_sym_SQUOTE] = ACTIONS(57),
    [sym_self] = ACTIONS(77),
    [sym_nil] = ACTIONS(77),
    [sym_break] = ACTIONS(77),
    [sym_next] = ACTIONS(77),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(61),
    [sym_field] = ACTIONS(63),
    [sym_constant] = ACTIONS(65),
  },
  [3] = {
    [sym_block] = STATE(565),
    [sym__expression] = STATE(565),
    [sym_assign_receiver_field] = STATE(565),
    [sym_assign_local] = STATE(565),
    [sym_assign_field] = STATE(565),
    [sym_replace_local] = STATE(565),
    [sym_replace_field] = STATE(565),
    [sym_compound_assign_local] = STATE(565),
    [sym_compound_assign_field] = STATE(565),
    [sym_compound_assign_receiver_field] = STATE(565),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(565),
    [sym_call_with_receiver] = STATE(565),
    [sym_ref] = STATE(565),
    [sym_mut] = STATE(565),
    [sym_recover] = STATE(565),
    [sym_grouped_expression] = STATE(565),
    [sym_tuple] = STATE(565),
    [sym_array] = STATE(565),
    [sym_return] = STATE(565),
    [sym_try] = STATE(565),
    [sym_throw] = STATE(565),
    [sym_if] = STATE(565),
    [sym_while] = STATE(565),
    [sym_loop] = STATE(565),
    [sym_match] = STATE(565),
    [sym_closure] = STATE(565),
    [sym_define_variable] = STATE(565),
    [sym_and_or] = STATE(565),
    [sym_binary] = STATE(565),
    [sym_cast] = STATE(565),
    [sym_string] = STATE(565),
    [sym_true] = STATE(565),
    [sym_false] = STATE(565),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(67),
    [anon_sym_RPAREN] = ACTIONS(67),
    [anon_sym_as] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_and] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_STAR_STAR] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(69),
    [anon_sym_GT_GT_GT] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_EQ_EQ] = ACTIONS(67),
    [anon_sym_BANG_EQ] = ACTIONS(67),
    [anon_sym_DASH_GT] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(67),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_or] = ACTIONS(69),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(117),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(123),
    [sym_nil] = ACTIONS(123),
    [sym_break] = ACTIONS(123),
    [sym_next] = ACTIONS(123),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [4] = {
    [sym_block] = STATE(591),
    [sym__expression] = STATE(591),
    [sym_assign_receiver_field] = STATE(591),
    [sym_assign_local] = STATE(591),
    [sym_assign_field] = STATE(591),
    [sym_replace_local] = STATE(591),
    [sym_replace_field] = STATE(591),
    [sym_compound_assign_local] = STATE(591),
    [sym_compound_assign_field] = STATE(591),
    [sym_compound_assign_receiver_field] = STATE(591),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(591),
    [sym_call_with_receiver] = STATE(591),
    [sym_ref] = STATE(591),
    [sym_mut] = STATE(591),
    [sym_recover] = STATE(591),
    [sym_grouped_expression] = STATE(591),
    [sym_tuple] = STATE(591),
    [sym_array] = STATE(591),
    [sym_return] = STATE(591),
    [sym_try] = STATE(591),
    [sym_throw] = STATE(591),
    [sym_if] = STATE(591),
    [sym_while] = STATE(591),
    [sym_loop] = STATE(591),
    [sym_match] = STATE(591),
    [sym_closure] = STATE(591),
    [sym_define_variable] = STATE(591),
    [sym_and_or] = STATE(591),
    [sym_binary] = STATE(591),
    [sym_cast] = STATE(591),
    [sym_string] = STATE(591),
    [sym_true] = STATE(591),
    [sym_false] = STATE(591),
    [sym_identifier] = ACTIONS(131),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_COMMA] = ACTIONS(67),
    [anon_sym_as] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_and] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_STAR_STAR] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(69),
    [anon_sym_GT_GT_GT] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_EQ_EQ] = ACTIONS(67),
    [anon_sym_BANG_EQ] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(133),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_RBRACE] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(135),
    [anon_sym_case] = ACTIONS(69),
    [anon_sym_ref] = ACTIONS(137),
    [anon_sym_recover] = ACTIONS(139),
    [anon_sym_return] = ACTIONS(141),
    [anon_sym_try] = ACTIONS(143),
    [anon_sym_throw] = ACTIONS(145),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_or] = ACTIONS(69),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(147),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(149),
    [sym_nil] = ACTIONS(149),
    [sym_break] = ACTIONS(149),
    [sym_next] = ACTIONS(149),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(151),
    [sym_constant] = ACTIONS(129),
  },
  [5] = {
    [sym_block] = STATE(314),
    [sym__expression] = STATE(314),
    [sym_assign_receiver_field] = STATE(314),
    [sym_assign_local] = STATE(314),
    [sym_assign_field] = STATE(314),
    [sym_replace_local] = STATE(314),
    [sym_replace_field] = STATE(314),
    [sym_compound_assign_local] = STATE(314),
    [sym_compound_assign_field] = STATE(314),
    [sym_compound_assign_receiver_field] = STATE(314),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(314),
    [sym_call_with_receiver] = STATE(314),
    [sym_ref] = STATE(314),
    [sym_mut] = STATE(314),
    [sym_recover] = STATE(314),
    [sym_grouped_expression] = STATE(314),
    [sym_tuple] = STATE(314),
    [sym_array] = STATE(314),
    [sym_return] = STATE(314),
    [sym_try] = STATE(314),
    [sym_throw] = STATE(314),
    [sym_if] = STATE(314),
    [sym_while] = STATE(314),
    [sym_loop] = STATE(314),
    [sym_match] = STATE(314),
    [sym_closure] = STATE(314),
    [sym_define_variable] = STATE(314),
    [sym_and_or] = STATE(314),
    [sym_binary] = STATE(314),
    [sym_cast] = STATE(314),
    [sym_string] = STATE(314),
    [sym_true] = STATE(314),
    [sym_false] = STATE(314),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_DOT] = ACTIONS(67),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_as] = ACTIONS(69),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_and] = ACTIONS(69),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_PLUS] = ACTIONS(67),
    [anon_sym_DASH] = ACTIONS(69),
    [anon_sym_SLASH] = ACTIONS(67),
    [anon_sym_STAR] = ACTIONS(69),
    [anon_sym_STAR_STAR] = ACTIONS(67),
    [anon_sym_PERCENT] = ACTIONS(67),
    [anon_sym_LT] = ACTIONS(69),
    [anon_sym_GT] = ACTIONS(69),
    [anon_sym_LT_EQ] = ACTIONS(67),
    [anon_sym_GT_EQ] = ACTIONS(67),
    [anon_sym_LT_LT] = ACTIONS(67),
    [anon_sym_GT_GT] = ACTIONS(69),
    [anon_sym_GT_GT_GT] = ACTIONS(67),
    [anon_sym_AMP] = ACTIONS(67),
    [anon_sym_PIPE] = ACTIONS(67),
    [anon_sym_CARET] = ACTIONS(67),
    [anon_sym_EQ_EQ] = ACTIONS(67),
    [anon_sym_BANG_EQ] = ACTIONS(67),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(67),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_or] = ACTIONS(69),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(191),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(197),
    [sym_nil] = ACTIONS(197),
    [sym_break] = ACTIONS(197),
    [sym_next] = ACTIONS(197),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [6] = {
    [sym__root] = STATE(6),
    [sym_import] = STATE(6),
    [sym_extern_import] = STATE(6),
    [sym_external_function] = STATE(6),
    [sym_module_method] = STATE(6),
    [sym_class] = STATE(6),
    [sym_trait] = STATE(6),
    [sym_implement_trait] = STATE(6),
    [sym_reopen_class] = STATE(6),
    [sym_block] = STATE(191),
    [sym__expression] = STATE(191),
    [sym_assign_receiver_field] = STATE(191),
    [sym_assign_local] = STATE(191),
    [sym_assign_field] = STATE(191),
    [sym_replace_local] = STATE(191),
    [sym_replace_field] = STATE(191),
    [sym_compound_assign_local] = STATE(191),
    [sym_compound_assign_field] = STATE(191),
    [sym_compound_assign_receiver_field] = STATE(191),
    [sym__call_name] = STATE(1059),
    [sym_call] = STATE(191),
    [sym_call_with_receiver] = STATE(191),
    [sym_ref] = STATE(191),
    [sym_mut] = STATE(191),
    [sym_recover] = STATE(191),
    [sym_grouped_expression] = STATE(191),
    [sym_tuple] = STATE(191),
    [sym_array] = STATE(191),
    [sym_return] = STATE(191),
    [sym_try] = STATE(191),
    [sym_throw] = STATE(191),
    [sym_if] = STATE(191),
    [sym_while] = STATE(191),
    [sym_loop] = STATE(191),
    [sym_match] = STATE(191),
    [sym_closure] = STATE(191),
    [sym_define_constant] = STATE(6),
    [sym_define_variable] = STATE(191),
    [sym_and_or] = STATE(191),
    [sym_binary] = STATE(191),
    [sym_cast] = STATE(191),
    [sym_string] = STATE(191),
    [sym_true] = STATE(191),
    [sym_false] = STATE(191),
    [aux_sym_source_file_repeat1] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(205),
    [sym_identifier] = ACTIONS(207),
    [anon_sym_import] = ACTIONS(210),
    [anon_sym_LPAREN] = ACTIONS(213),
    [anon_sym_if] = ACTIONS(216),
    [anon_sym_DQUOTE] = ACTIONS(219),
    [anon_sym_fn] = ACTIONS(222),
    [anon_sym_LBRACK] = ACTIONS(225),
    [anon_sym_mut] = ACTIONS(228),
    [anon_sym_class] = ACTIONS(231),
    [anon_sym_LBRACE] = ACTIONS(234),
    [anon_sym_let] = ACTIONS(237),
    [anon_sym_trait] = ACTIONS(240),
    [anon_sym_impl] = ACTIONS(243),
    [anon_sym_ref] = ACTIONS(246),
    [anon_sym_recover] = ACTIONS(249),
    [anon_sym_return] = ACTIONS(252),
    [anon_sym_try] = ACTIONS(255),
    [anon_sym_throw] = ACTIONS(258),
    [anon_sym_while] = ACTIONS(261),
    [anon_sym_loop] = ACTIONS(264),
    [anon_sym_match] = ACTIONS(267),
    [anon_sym_true] = ACTIONS(270),
    [anon_sym_false] = ACTIONS(273),
    [sym_float] = ACTIONS(276),
    [sym_integer] = ACTIONS(279),
    [anon_sym_SQUOTE] = ACTIONS(282),
    [sym_self] = ACTIONS(285),
    [sym_nil] = ACTIONS(285),
    [sym_break] = ACTIONS(285),
    [sym_next] = ACTIONS(285),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(288),
    [sym_field] = ACTIONS(291),
    [sym_constant] = ACTIONS(294),
  },
  [7] = {
    [sym__root] = STATE(6),
    [sym_import] = STATE(6),
    [sym_extern_import] = STATE(6),
    [sym_external_function] = STATE(6),
    [sym_module_method] = STATE(6),
    [sym_class] = STATE(6),
    [sym_trait] = STATE(6),
    [sym_implement_trait] = STATE(6),
    [sym_reopen_class] = STATE(6),
    [sym_block] = STATE(191),
    [sym__expression] = STATE(191),
    [sym_assign_receiver_field] = STATE(191),
    [sym_assign_local] = STATE(191),
    [sym_assign_field] = STATE(191),
    [sym_replace_local] = STATE(191),
    [sym_replace_field] = STATE(191),
    [sym_compound_assign_local] = STATE(191),
    [sym_compound_assign_field] = STATE(191),
    [sym_compound_assign_receiver_field] = STATE(191),
    [sym__call_name] = STATE(1059),
    [sym_call] = STATE(191),
    [sym_call_with_receiver] = STATE(191),
    [sym_ref] = STATE(191),
    [sym_mut] = STATE(191),
    [sym_recover] = STATE(191),
    [sym_grouped_expression] = STATE(191),
    [sym_tuple] = STATE(191),
    [sym_array] = STATE(191),
    [sym_return] = STATE(191),
    [sym_try] = STATE(191),
    [sym_throw] = STATE(191),
    [sym_if] = STATE(191),
    [sym_while] = STATE(191),
    [sym_loop] = STATE(191),
    [sym_match] = STATE(191),
    [sym_closure] = STATE(191),
    [sym_define_constant] = STATE(6),
    [sym_define_variable] = STATE(191),
    [sym_and_or] = STATE(191),
    [sym_binary] = STATE(191),
    [sym_cast] = STATE(191),
    [sym_string] = STATE(191),
    [sym_true] = STATE(191),
    [sym_false] = STATE(191),
    [aux_sym_source_file_repeat1] = STATE(6),
    [ts_builtin_sym_end] = ACTIONS(297),
    [sym_identifier] = ACTIONS(7),
    [anon_sym_import] = ACTIONS(9),
    [anon_sym_LPAREN] = ACTIONS(11),
    [anon_sym_if] = ACTIONS(13),
    [anon_sym_DQUOTE] = ACTIONS(15),
    [anon_sym_fn] = ACTIONS(17),
    [anon_sym_LBRACK] = ACTIONS(19),
    [anon_sym_mut] = ACTIONS(21),
    [anon_sym_class] = ACTIONS(23),
    [anon_sym_LBRACE] = ACTIONS(25),
    [anon_sym_let] = ACTIONS(27),
    [anon_sym_trait] = ACTIONS(29),
    [anon_sym_impl] = ACTIONS(31),
    [anon_sym_ref] = ACTIONS(33),
    [anon_sym_recover] = ACTIONS(35),
    [anon_sym_return] = ACTIONS(37),
    [anon_sym_try] = ACTIONS(39),
    [anon_sym_throw] = ACTIONS(41),
    [anon_sym_while] = ACTIONS(43),
    [anon_sym_loop] = ACTIONS(45),
    [anon_sym_match] = ACTIONS(47),
    [anon_sym_true] = ACTIONS(49),
    [anon_sym_false] = ACTIONS(51),
    [sym_float] = ACTIONS(53),
    [sym_integer] = ACTIONS(55),
    [anon_sym_SQUOTE] = ACTIONS(57),
    [sym_self] = ACTIONS(59),
    [sym_nil] = ACTIONS(59),
    [sym_break] = ACTIONS(59),
    [sym_next] = ACTIONS(59),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(61),
    [sym_field] = ACTIONS(63),
    [sym_constant] = ACTIONS(65),
  },
  [8] = {
    [ts_builtin_sym_end] = ACTIONS(299),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_import] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_as] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(301),
    [anon_sym_and] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [anon_sym_fn] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(301),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_PERCENT] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(301),
    [anon_sym_GT] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(299),
    [anon_sym_GT_EQ] = ACTIONS(299),
    [anon_sym_LT_LT] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(301),
    [anon_sym_GT_GT_GT] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(301),
    [anon_sym_PIPE] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [anon_sym_EQ_EQ] = ACTIONS(299),
    [anon_sym_BANG_EQ] = ACTIONS(299),
    [anon_sym_LBRACK] = ACTIONS(299),
    [anon_sym_mut] = ACTIONS(301),
    [anon_sym_class] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_let] = ACTIONS(301),
    [anon_sym_trait] = ACTIONS(301),
    [anon_sym_impl] = ACTIONS(301),
    [anon_sym_ref] = ACTIONS(301),
    [anon_sym_EQ] = ACTIONS(303),
    [anon_sym_COLON_EQ] = ACTIONS(305),
    [anon_sym_PLUS_EQ] = ACTIONS(307),
    [anon_sym_DASH_EQ] = ACTIONS(307),
    [anon_sym_SLASH_EQ] = ACTIONS(307),
    [anon_sym_STAR_EQ] = ACTIONS(307),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(307),
    [anon_sym_PERCENT_EQ] = ACTIONS(307),
    [anon_sym_LT_LT_EQ] = ACTIONS(307),
    [anon_sym_GT_GT_EQ] = ACTIONS(307),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(307),
    [anon_sym_AMP_EQ] = ACTIONS(307),
    [anon_sym_PIPE_EQ] = ACTIONS(307),
    [anon_sym_CARET_EQ] = ACTIONS(307),
    [anon_sym_LPAREN2] = ACTIONS(309),
    [anon_sym_recover] = ACTIONS(301),
    [anon_sym_return] = ACTIONS(301),
    [anon_sym_try] = ACTIONS(301),
    [anon_sym_throw] = ACTIONS(301),
    [anon_sym_while] = ACTIONS(301),
    [anon_sym_loop] = ACTIONS(301),
    [anon_sym_match] = ACTIONS(301),
    [anon_sym_or] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(301),
    [anon_sym_false] = ACTIONS(301),
    [sym_float] = ACTIONS(299),
    [sym_integer] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(299),
    [sym_self] = ACTIONS(301),
    [sym_nil] = ACTIONS(301),
    [sym_break] = ACTIONS(301),
    [sym_next] = ACTIONS(301),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(301),
    [sym_field] = ACTIONS(299),
    [sym_constant] = ACTIONS(299),
  },
  [9] = {
    [ts_builtin_sym_end] = ACTIONS(311),
    [sym_identifier] = ACTIONS(313),
    [anon_sym_import] = ACTIONS(313),
    [anon_sym_DOT] = ACTIONS(311),
    [anon_sym_LPAREN] = ACTIONS(313),
    [anon_sym_as] = ACTIONS(313),
    [anon_sym_if] = ACTIONS(313),
    [anon_sym_and] = ACTIONS(313),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_fn] = ACTIONS(313),
    [anon_sym_PLUS] = ACTIONS(313),
    [anon_sym_DASH] = ACTIONS(313),
    [anon_sym_SLASH] = ACTIONS(313),
    [anon_sym_STAR] = ACTIONS(313),
    [anon_sym_STAR_STAR] = ACTIONS(313),
    [anon_sym_PERCENT] = ACTIONS(313),
    [anon_sym_LT] = ACTIONS(313),
    [anon_sym_GT] = ACTIONS(313),
    [anon_sym_LT_EQ] = ACTIONS(311),
    [anon_sym_GT_EQ] = ACTIONS(311),
    [anon_sym_LT_LT] = ACTIONS(313),
    [anon_sym_GT_GT] = ACTIONS(313),
    [anon_sym_GT_GT_GT] = ACTIONS(313),
    [anon_sym_AMP] = ACTIONS(313),
    [anon_sym_PIPE] = ACTIONS(313),
    [anon_sym_CARET] = ACTIONS(313),
    [anon_sym_EQ_EQ] = ACTIONS(311),
    [anon_sym_BANG_EQ] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_mut] = ACTIONS(313),
    [anon_sym_class] = ACTIONS(313),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_let] = ACTIONS(313),
    [anon_sym_trait] = ACTIONS(313),
    [anon_sym_impl] = ACTIONS(313),
    [anon_sym_ref] = ACTIONS(313),
    [anon_sym_EQ] = ACTIONS(313),
    [anon_sym_PLUS_EQ] = ACTIONS(315),
    [anon_sym_DASH_EQ] = ACTIONS(315),
    [anon_sym_SLASH_EQ] = ACTIONS(315),
    [anon_sym_STAR_EQ] = ACTIONS(315),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(315),
    [anon_sym_PERCENT_EQ] = ACTIONS(315),
    [anon_sym_LT_LT_EQ] = ACTIONS(315),
    [anon_sym_GT_GT_EQ] = ACTIONS(315),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(315),
    [anon_sym_AMP_EQ] = ACTIONS(315),
    [anon_sym_PIPE_EQ] = ACTIONS(315),
    [anon_sym_CARET_EQ] = ACTIONS(315),
    [anon_sym_LPAREN2] = ACTIONS(311),
    [anon_sym_recover] = ACTIONS(313),
    [anon_sym_return] = ACTIONS(313),
    [anon_sym_try] = ACTIONS(313),
    [anon_sym_throw] = ACTIONS(313),
    [anon_sym_while] = ACTIONS(313),
    [anon_sym_loop] = ACTIONS(313),
    [anon_sym_match] = ACTIONS(313),
    [anon_sym_or] = ACTIONS(313),
    [anon_sym_true] = ACTIONS(313),
    [anon_sym_false] = ACTIONS(313),
    [sym_float] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [anon_sym_SQUOTE] = ACTIONS(311),
    [sym_self] = ACTIONS(313),
    [sym_nil] = ACTIONS(313),
    [sym_break] = ACTIONS(313),
    [sym_next] = ACTIONS(313),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(313),
    [sym_field] = ACTIONS(311),
    [sym_constant] = ACTIONS(311),
  },
  [10] = {
    [ts_builtin_sym_end] = ACTIONS(309),
    [sym_identifier] = ACTIONS(317),
    [anon_sym_import] = ACTIONS(317),
    [anon_sym_DOT] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_as] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_and] = ACTIONS(317),
    [anon_sym_DQUOTE] = ACTIONS(309),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_DASH] = ACTIONS(317),
    [anon_sym_SLASH] = ACTIONS(317),
    [anon_sym_STAR] = ACTIONS(317),
    [anon_sym_STAR_STAR] = ACTIONS(317),
    [anon_sym_PERCENT] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(317),
    [anon_sym_GT] = ACTIONS(317),
    [anon_sym_LT_EQ] = ACTIONS(309),
    [anon_sym_GT_EQ] = ACTIONS(309),
    [anon_sym_LT_LT] = ACTIONS(317),
    [anon_sym_GT_GT] = ACTIONS(317),
    [anon_sym_GT_GT_GT] = ACTIONS(317),
    [anon_sym_AMP] = ACTIONS(317),
    [anon_sym_PIPE] = ACTIONS(317),
    [anon_sym_CARET] = ACTIONS(317),
    [anon_sym_EQ_EQ] = ACTIONS(309),
    [anon_sym_BANG_EQ] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_mut] = ACTIONS(317),
    [anon_sym_class] = ACTIONS(317),
    [anon_sym_LBRACE] = ACTIONS(309),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_trait] = ACTIONS(317),
    [anon_sym_impl] = ACTIONS(317),
    [anon_sym_ref] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_PLUS_EQ] = ACTIONS(315),
    [anon_sym_DASH_EQ] = ACTIONS(315),
    [anon_sym_SLASH_EQ] = ACTIONS(315),
    [anon_sym_STAR_EQ] = ACTIONS(315),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(315),
    [anon_sym_PERCENT_EQ] = ACTIONS(315),
    [anon_sym_LT_LT_EQ] = ACTIONS(315),
    [anon_sym_GT_GT_EQ] = ACTIONS(315),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(315),
    [anon_sym_AMP_EQ] = ACTIONS(315),
    [anon_sym_PIPE_EQ] = ACTIONS(315),
    [anon_sym_CARET_EQ] = ACTIONS(315),
    [anon_sym_LPAREN2] = ACTIONS(309),
    [anon_sym_recover] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_try] = ACTIONS(317),
    [anon_sym_throw] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_or] = ACTIONS(317),
    [anon_sym_true] = ACTIONS(317),
    [anon_sym_false] = ACTIONS(317),
    [sym_float] = ACTIONS(309),
    [sym_integer] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(309),
    [sym_self] = ACTIONS(317),
    [sym_nil] = ACTIONS(317),
    [sym_break] = ACTIONS(317),
    [sym_next] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(317),
    [sym_field] = ACTIONS(309),
    [sym_constant] = ACTIONS(309),
  },
  [11] = {
    [ts_builtin_sym_end] = ACTIONS(299),
    [sym_identifier] = ACTIONS(301),
    [anon_sym_import] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(299),
    [anon_sym_as] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(301),
    [anon_sym_and] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [anon_sym_fn] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(301),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_PERCENT] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(301),
    [anon_sym_GT] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(299),
    [anon_sym_GT_EQ] = ACTIONS(299),
    [anon_sym_LT_LT] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(301),
    [anon_sym_GT_GT_GT] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(301),
    [anon_sym_PIPE] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [anon_sym_EQ_EQ] = ACTIONS(299),
    [anon_sym_BANG_EQ] = ACTIONS(299),
    [anon_sym_LBRACK] = ACTIONS(299),
    [anon_sym_mut] = ACTIONS(301),
    [anon_sym_class] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_let] = ACTIONS(301),
    [anon_sym_trait] = ACTIONS(301),
    [anon_sym_impl] = ACTIONS(301),
    [anon_sym_ref] = ACTIONS(301),
    [anon_sym_EQ] = ACTIONS(319),
    [anon_sym_COLON_EQ] = ACTIONS(321),
    [anon_sym_PLUS_EQ] = ACTIONS(323),
    [anon_sym_DASH_EQ] = ACTIONS(323),
    [anon_sym_SLASH_EQ] = ACTIONS(323),
    [anon_sym_STAR_EQ] = ACTIONS(323),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(323),
    [anon_sym_PERCENT_EQ] = ACTIONS(323),
    [anon_sym_LT_LT_EQ] = ACTIONS(323),
    [anon_sym_GT_GT_EQ] = ACTIONS(323),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(323),
    [anon_sym_AMP_EQ] = ACTIONS(323),
    [anon_sym_PIPE_EQ] = ACTIONS(323),
    [anon_sym_CARET_EQ] = ACTIONS(323),
    [anon_sym_recover] = ACTIONS(301),
    [anon_sym_return] = ACTIONS(301),
    [anon_sym_try] = ACTIONS(301),
    [anon_sym_throw] = ACTIONS(301),
    [anon_sym_while] = ACTIONS(301),
    [anon_sym_loop] = ACTIONS(301),
    [anon_sym_match] = ACTIONS(301),
    [anon_sym_or] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(301),
    [anon_sym_false] = ACTIONS(301),
    [sym_float] = ACTIONS(299),
    [sym_integer] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(299),
    [sym_self] = ACTIONS(301),
    [sym_nil] = ACTIONS(301),
    [sym_break] = ACTIONS(301),
    [sym_next] = ACTIONS(301),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(301),
    [sym_field] = ACTIONS(299),
    [sym_constant] = ACTIONS(299),
  },
  [12] = {
    [sym_identifier] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(301),
    [anon_sym_as] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(301),
    [anon_sym_and] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [anon_sym_fn] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(301),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_PERCENT] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(301),
    [anon_sym_GT] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(299),
    [anon_sym_GT_EQ] = ACTIONS(299),
    [anon_sym_LT_LT] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(301),
    [anon_sym_GT_GT_GT] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(301),
    [anon_sym_PIPE] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [anon_sym_EQ_EQ] = ACTIONS(299),
    [anon_sym_BANG_EQ] = ACTIONS(299),
    [anon_sym_LBRACK] = ACTIONS(299),
    [anon_sym_mut] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_let] = ACTIONS(301),
    [anon_sym_ref] = ACTIONS(301),
    [anon_sym_EQ] = ACTIONS(325),
    [anon_sym_COLON_EQ] = ACTIONS(327),
    [anon_sym_PLUS_EQ] = ACTIONS(329),
    [anon_sym_DASH_EQ] = ACTIONS(329),
    [anon_sym_SLASH_EQ] = ACTIONS(329),
    [anon_sym_STAR_EQ] = ACTIONS(329),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(329),
    [anon_sym_PERCENT_EQ] = ACTIONS(329),
    [anon_sym_LT_LT_EQ] = ACTIONS(329),
    [anon_sym_GT_GT_EQ] = ACTIONS(329),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(329),
    [anon_sym_AMP_EQ] = ACTIONS(329),
    [anon_sym_PIPE_EQ] = ACTIONS(329),
    [anon_sym_CARET_EQ] = ACTIONS(329),
    [anon_sym_LPAREN2] = ACTIONS(309),
    [anon_sym_recover] = ACTIONS(301),
    [anon_sym_return] = ACTIONS(301),
    [anon_sym_try] = ACTIONS(301),
    [anon_sym_throw] = ACTIONS(301),
    [anon_sym_while] = ACTIONS(301),
    [anon_sym_loop] = ACTIONS(301),
    [anon_sym_match] = ACTIONS(301),
    [anon_sym_or] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(301),
    [anon_sym_false] = ACTIONS(301),
    [sym_float] = ACTIONS(299),
    [sym_integer] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(299),
    [sym_self] = ACTIONS(301),
    [sym_nil] = ACTIONS(301),
    [sym_break] = ACTIONS(301),
    [sym_next] = ACTIONS(301),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(301),
    [sym_field] = ACTIONS(299),
    [sym_constant] = ACTIONS(299),
  },
  [13] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(943),
    [sym_named_argument] = STATE(943),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(333),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [14] = {
    [sym_identifier] = ACTIONS(317),
    [anon_sym_DOT] = ACTIONS(309),
    [anon_sym_LPAREN] = ACTIONS(317),
    [anon_sym_as] = ACTIONS(317),
    [anon_sym_if] = ACTIONS(317),
    [anon_sym_and] = ACTIONS(317),
    [anon_sym_DQUOTE] = ACTIONS(309),
    [anon_sym_fn] = ACTIONS(317),
    [anon_sym_PLUS] = ACTIONS(317),
    [anon_sym_DASH] = ACTIONS(317),
    [anon_sym_SLASH] = ACTIONS(317),
    [anon_sym_STAR] = ACTIONS(317),
    [anon_sym_STAR_STAR] = ACTIONS(317),
    [anon_sym_PERCENT] = ACTIONS(317),
    [anon_sym_LT] = ACTIONS(317),
    [anon_sym_GT] = ACTIONS(317),
    [anon_sym_LT_EQ] = ACTIONS(309),
    [anon_sym_GT_EQ] = ACTIONS(309),
    [anon_sym_LT_LT] = ACTIONS(317),
    [anon_sym_GT_GT] = ACTIONS(317),
    [anon_sym_GT_GT_GT] = ACTIONS(317),
    [anon_sym_AMP] = ACTIONS(317),
    [anon_sym_PIPE] = ACTIONS(317),
    [anon_sym_CARET] = ACTIONS(317),
    [anon_sym_EQ_EQ] = ACTIONS(309),
    [anon_sym_BANG_EQ] = ACTIONS(309),
    [anon_sym_LBRACK] = ACTIONS(309),
    [anon_sym_mut] = ACTIONS(317),
    [anon_sym_LBRACE] = ACTIONS(309),
    [anon_sym_RBRACE] = ACTIONS(309),
    [anon_sym_let] = ACTIONS(317),
    [anon_sym_ref] = ACTIONS(317),
    [anon_sym_EQ] = ACTIONS(317),
    [anon_sym_PLUS_EQ] = ACTIONS(339),
    [anon_sym_DASH_EQ] = ACTIONS(339),
    [anon_sym_SLASH_EQ] = ACTIONS(339),
    [anon_sym_STAR_EQ] = ACTIONS(339),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(339),
    [anon_sym_PERCENT_EQ] = ACTIONS(339),
    [anon_sym_LT_LT_EQ] = ACTIONS(339),
    [anon_sym_GT_GT_EQ] = ACTIONS(339),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(339),
    [anon_sym_AMP_EQ] = ACTIONS(339),
    [anon_sym_PIPE_EQ] = ACTIONS(339),
    [anon_sym_CARET_EQ] = ACTIONS(339),
    [anon_sym_LPAREN2] = ACTIONS(309),
    [anon_sym_recover] = ACTIONS(317),
    [anon_sym_return] = ACTIONS(317),
    [anon_sym_try] = ACTIONS(317),
    [anon_sym_throw] = ACTIONS(317),
    [anon_sym_while] = ACTIONS(317),
    [anon_sym_loop] = ACTIONS(317),
    [anon_sym_match] = ACTIONS(317),
    [anon_sym_or] = ACTIONS(317),
    [anon_sym_true] = ACTIONS(317),
    [anon_sym_false] = ACTIONS(317),
    [sym_float] = ACTIONS(309),
    [sym_integer] = ACTIONS(317),
    [anon_sym_SQUOTE] = ACTIONS(309),
    [sym_self] = ACTIONS(317),
    [sym_nil] = ACTIONS(317),
    [sym_break] = ACTIONS(317),
    [sym_next] = ACTIONS(317),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(317),
    [sym_field] = ACTIONS(309),
    [sym_constant] = ACTIONS(309),
  },
  [15] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(1043),
    [sym_named_argument] = STATE(1043),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(341),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [16] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(1043),
    [sym_named_argument] = STATE(1043),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(343),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [17] = {
    [sym_identifier] = ACTIONS(313),
    [anon_sym_DOT] = ACTIONS(311),
    [anon_sym_LPAREN] = ACTIONS(313),
    [anon_sym_as] = ACTIONS(313),
    [anon_sym_if] = ACTIONS(313),
    [anon_sym_and] = ACTIONS(313),
    [anon_sym_DQUOTE] = ACTIONS(311),
    [anon_sym_fn] = ACTIONS(313),
    [anon_sym_PLUS] = ACTIONS(313),
    [anon_sym_DASH] = ACTIONS(313),
    [anon_sym_SLASH] = ACTIONS(313),
    [anon_sym_STAR] = ACTIONS(313),
    [anon_sym_STAR_STAR] = ACTIONS(313),
    [anon_sym_PERCENT] = ACTIONS(313),
    [anon_sym_LT] = ACTIONS(313),
    [anon_sym_GT] = ACTIONS(313),
    [anon_sym_LT_EQ] = ACTIONS(311),
    [anon_sym_GT_EQ] = ACTIONS(311),
    [anon_sym_LT_LT] = ACTIONS(313),
    [anon_sym_GT_GT] = ACTIONS(313),
    [anon_sym_GT_GT_GT] = ACTIONS(313),
    [anon_sym_AMP] = ACTIONS(313),
    [anon_sym_PIPE] = ACTIONS(313),
    [anon_sym_CARET] = ACTIONS(313),
    [anon_sym_EQ_EQ] = ACTIONS(311),
    [anon_sym_BANG_EQ] = ACTIONS(311),
    [anon_sym_LBRACK] = ACTIONS(311),
    [anon_sym_mut] = ACTIONS(313),
    [anon_sym_LBRACE] = ACTIONS(311),
    [anon_sym_RBRACE] = ACTIONS(311),
    [anon_sym_let] = ACTIONS(313),
    [anon_sym_ref] = ACTIONS(313),
    [anon_sym_EQ] = ACTIONS(313),
    [anon_sym_PLUS_EQ] = ACTIONS(339),
    [anon_sym_DASH_EQ] = ACTIONS(339),
    [anon_sym_SLASH_EQ] = ACTIONS(339),
    [anon_sym_STAR_EQ] = ACTIONS(339),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(339),
    [anon_sym_PERCENT_EQ] = ACTIONS(339),
    [anon_sym_LT_LT_EQ] = ACTIONS(339),
    [anon_sym_GT_GT_EQ] = ACTIONS(339),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(339),
    [anon_sym_AMP_EQ] = ACTIONS(339),
    [anon_sym_PIPE_EQ] = ACTIONS(339),
    [anon_sym_CARET_EQ] = ACTIONS(339),
    [anon_sym_LPAREN2] = ACTIONS(311),
    [anon_sym_recover] = ACTIONS(313),
    [anon_sym_return] = ACTIONS(313),
    [anon_sym_try] = ACTIONS(313),
    [anon_sym_throw] = ACTIONS(313),
    [anon_sym_while] = ACTIONS(313),
    [anon_sym_loop] = ACTIONS(313),
    [anon_sym_match] = ACTIONS(313),
    [anon_sym_or] = ACTIONS(313),
    [anon_sym_true] = ACTIONS(313),
    [anon_sym_false] = ACTIONS(313),
    [sym_float] = ACTIONS(311),
    [sym_integer] = ACTIONS(313),
    [anon_sym_SQUOTE] = ACTIONS(311),
    [sym_self] = ACTIONS(313),
    [sym_nil] = ACTIONS(313),
    [sym_break] = ACTIONS(313),
    [sym_next] = ACTIONS(313),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(313),
    [sym_field] = ACTIONS(311),
    [sym_constant] = ACTIONS(311),
  },
  [18] = {
    [sym_identifier] = ACTIONS(301),
    [anon_sym_DOT] = ACTIONS(299),
    [anon_sym_LPAREN] = ACTIONS(299),
    [anon_sym_as] = ACTIONS(301),
    [anon_sym_if] = ACTIONS(301),
    [anon_sym_and] = ACTIONS(301),
    [anon_sym_DQUOTE] = ACTIONS(299),
    [anon_sym_fn] = ACTIONS(301),
    [anon_sym_PLUS] = ACTIONS(301),
    [anon_sym_DASH] = ACTIONS(301),
    [anon_sym_SLASH] = ACTIONS(301),
    [anon_sym_STAR] = ACTIONS(301),
    [anon_sym_STAR_STAR] = ACTIONS(301),
    [anon_sym_PERCENT] = ACTIONS(301),
    [anon_sym_LT] = ACTIONS(301),
    [anon_sym_GT] = ACTIONS(301),
    [anon_sym_LT_EQ] = ACTIONS(299),
    [anon_sym_GT_EQ] = ACTIONS(299),
    [anon_sym_LT_LT] = ACTIONS(301),
    [anon_sym_GT_GT] = ACTIONS(301),
    [anon_sym_GT_GT_GT] = ACTIONS(301),
    [anon_sym_AMP] = ACTIONS(301),
    [anon_sym_PIPE] = ACTIONS(301),
    [anon_sym_CARET] = ACTIONS(301),
    [anon_sym_EQ_EQ] = ACTIONS(299),
    [anon_sym_BANG_EQ] = ACTIONS(299),
    [anon_sym_LBRACK] = ACTIONS(299),
    [anon_sym_mut] = ACTIONS(301),
    [anon_sym_LBRACE] = ACTIONS(299),
    [anon_sym_RBRACE] = ACTIONS(299),
    [anon_sym_let] = ACTIONS(301),
    [anon_sym_ref] = ACTIONS(301),
    [anon_sym_EQ] = ACTIONS(345),
    [anon_sym_COLON_EQ] = ACTIONS(347),
    [anon_sym_PLUS_EQ] = ACTIONS(349),
    [anon_sym_DASH_EQ] = ACTIONS(349),
    [anon_sym_SLASH_EQ] = ACTIONS(349),
    [anon_sym_STAR_EQ] = ACTIONS(349),
    [anon_sym_STAR_STAR_EQ] = ACTIONS(349),
    [anon_sym_PERCENT_EQ] = ACTIONS(349),
    [anon_sym_LT_LT_EQ] = ACTIONS(349),
    [anon_sym_GT_GT_EQ] = ACTIONS(349),
    [anon_sym_GT_GT_GT_EQ] = ACTIONS(349),
    [anon_sym_AMP_EQ] = ACTIONS(349),
    [anon_sym_PIPE_EQ] = ACTIONS(349),
    [anon_sym_CARET_EQ] = ACTIONS(349),
    [anon_sym_recover] = ACTIONS(301),
    [anon_sym_return] = ACTIONS(301),
    [anon_sym_try] = ACTIONS(301),
    [anon_sym_throw] = ACTIONS(301),
    [anon_sym_while] = ACTIONS(301),
    [anon_sym_loop] = ACTIONS(301),
    [anon_sym_match] = ACTIONS(301),
    [anon_sym_or] = ACTIONS(301),
    [anon_sym_true] = ACTIONS(301),
    [anon_sym_false] = ACTIONS(301),
    [sym_float] = ACTIONS(299),
    [sym_integer] = ACTIONS(301),
    [anon_sym_SQUOTE] = ACTIONS(299),
    [sym_self] = ACTIONS(301),
    [sym_nil] = ACTIONS(301),
    [sym_break] = ACTIONS(301),
    [sym_next] = ACTIONS(301),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(301),
    [sym_field] = ACTIONS(299),
    [sym_constant] = ACTIONS(299),
  },
  [19] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(1043),
    [sym_named_argument] = STATE(1043),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(351),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [20] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(1043),
    [sym_named_argument] = STATE(1043),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(353),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [21] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(1043),
    [sym_named_argument] = STATE(1043),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(355),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [22] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(1043),
    [sym_named_argument] = STATE(1043),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(357),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [23] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(972),
    [sym_named_argument] = STATE(972),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(359),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [24] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(1026),
    [sym_named_argument] = STATE(1026),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(361),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [25] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(363),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [26] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(25),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(369),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [27] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(371),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [28] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(30),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(373),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [29] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(375),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [30] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(377),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [31] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(379),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [32] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(31),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(381),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [33] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(383),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [34] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(385),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [35] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(29),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(387),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [36] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(37),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(389),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [37] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(391),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [38] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(34),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(393),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [39] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(33),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(395),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [40] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(40),
    [sym_identifier] = ACTIONS(397),
    [anon_sym_LPAREN] = ACTIONS(400),
    [anon_sym_if] = ACTIONS(403),
    [anon_sym_DQUOTE] = ACTIONS(406),
    [anon_sym_fn] = ACTIONS(409),
    [anon_sym_LBRACK] = ACTIONS(412),
    [anon_sym_mut] = ACTIONS(415),
    [anon_sym_LBRACE] = ACTIONS(418),
    [anon_sym_RBRACE] = ACTIONS(421),
    [anon_sym_let] = ACTIONS(423),
    [anon_sym_ref] = ACTIONS(426),
    [anon_sym_recover] = ACTIONS(429),
    [anon_sym_return] = ACTIONS(432),
    [anon_sym_try] = ACTIONS(435),
    [anon_sym_throw] = ACTIONS(438),
    [anon_sym_while] = ACTIONS(441),
    [anon_sym_loop] = ACTIONS(444),
    [anon_sym_match] = ACTIONS(447),
    [anon_sym_true] = ACTIONS(450),
    [anon_sym_false] = ACTIONS(453),
    [sym_float] = ACTIONS(456),
    [sym_integer] = ACTIONS(459),
    [anon_sym_SQUOTE] = ACTIONS(462),
    [sym_self] = ACTIONS(465),
    [sym_nil] = ACTIONS(465),
    [sym_break] = ACTIONS(465),
    [sym_next] = ACTIONS(465),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(468),
    [sym_field] = ACTIONS(471),
    [sym_constant] = ACTIONS(474),
  },
  [41] = {
    [sym_block] = STATE(598),
    [sym__expression] = STATE(598),
    [sym_assign_receiver_field] = STATE(598),
    [sym_assign_local] = STATE(598),
    [sym_assign_field] = STATE(598),
    [sym_replace_local] = STATE(598),
    [sym_replace_field] = STATE(598),
    [sym_compound_assign_local] = STATE(598),
    [sym_compound_assign_field] = STATE(598),
    [sym_compound_assign_receiver_field] = STATE(598),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(598),
    [sym__call_argument] = STATE(1043),
    [sym_named_argument] = STATE(1043),
    [sym_call_with_receiver] = STATE(598),
    [sym_ref] = STATE(598),
    [sym_mut] = STATE(598),
    [sym_recover] = STATE(598),
    [sym_grouped_expression] = STATE(598),
    [sym_tuple] = STATE(598),
    [sym_array] = STATE(598),
    [sym_return] = STATE(598),
    [sym_try] = STATE(598),
    [sym_throw] = STATE(598),
    [sym_if] = STATE(598),
    [sym_while] = STATE(598),
    [sym_loop] = STATE(598),
    [sym_match] = STATE(598),
    [sym_closure] = STATE(598),
    [sym_define_variable] = STATE(598),
    [sym_and_or] = STATE(598),
    [sym_binary] = STATE(598),
    [sym_cast] = STATE(598),
    [sym_string] = STATE(598),
    [sym_true] = STATE(598),
    [sym_false] = STATE(598),
    [sym_identifier] = ACTIONS(331),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(335),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(337),
    [sym_nil] = ACTIONS(337),
    [sym_break] = ACTIONS(337),
    [sym_next] = ACTIONS(337),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [42] = {
    [sym_block] = STATE(310),
    [sym__expression] = STATE(310),
    [sym_assign_receiver_field] = STATE(310),
    [sym_assign_local] = STATE(310),
    [sym_assign_field] = STATE(310),
    [sym_replace_local] = STATE(310),
    [sym_replace_field] = STATE(310),
    [sym_compound_assign_local] = STATE(310),
    [sym_compound_assign_field] = STATE(310),
    [sym_compound_assign_receiver_field] = STATE(310),
    [sym__call_name] = STATE(1092),
    [sym_call] = STATE(310),
    [sym_call_with_receiver] = STATE(310),
    [sym_ref] = STATE(310),
    [sym_mut] = STATE(310),
    [sym_recover] = STATE(310),
    [sym_grouped_expression] = STATE(310),
    [sym_tuple] = STATE(310),
    [sym_array] = STATE(310),
    [sym_return] = STATE(310),
    [sym_try] = STATE(310),
    [sym_throw] = STATE(310),
    [sym_if] = STATE(310),
    [sym_while] = STATE(310),
    [sym_loop] = STATE(310),
    [sym_match] = STATE(310),
    [sym_closure] = STATE(310),
    [sym_define_variable] = STATE(310),
    [sym_and_or] = STATE(310),
    [sym_binary] = STATE(310),
    [sym_cast] = STATE(310),
    [sym_string] = STATE(310),
    [sym_true] = STATE(310),
    [sym_false] = STATE(310),
    [aux_sym_block_repeat1] = STATE(27),
    [sym_identifier] = ACTIONS(153),
    [anon_sym_LPAREN] = ACTIONS(155),
    [anon_sym_if] = ACTIONS(157),
    [anon_sym_DQUOTE] = ACTIONS(159),
    [anon_sym_fn] = ACTIONS(161),
    [anon_sym_LBRACK] = ACTIONS(163),
    [anon_sym_mut] = ACTIONS(165),
    [anon_sym_LBRACE] = ACTIONS(167),
    [anon_sym_RBRACE] = ACTIONS(477),
    [anon_sym_let] = ACTIONS(169),
    [anon_sym_ref] = ACTIONS(171),
    [anon_sym_recover] = ACTIONS(173),
    [anon_sym_return] = ACTIONS(175),
    [anon_sym_try] = ACTIONS(177),
    [anon_sym_throw] = ACTIONS(179),
    [anon_sym_while] = ACTIONS(181),
    [anon_sym_loop] = ACTIONS(183),
    [anon_sym_match] = ACTIONS(185),
    [anon_sym_true] = ACTIONS(187),
    [anon_sym_false] = ACTIONS(189),
    [sym_float] = ACTIONS(365),
    [sym_integer] = ACTIONS(193),
    [anon_sym_SQUOTE] = ACTIONS(195),
    [sym_self] = ACTIONS(367),
    [sym_nil] = ACTIONS(367),
    [sym_break] = ACTIONS(367),
    [sym_next] = ACTIONS(367),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(199),
    [sym_field] = ACTIONS(201),
    [sym_constant] = ACTIONS(203),
  },
  [43] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(479),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [44] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(485),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [45] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(487),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [46] = {
    [sym_block] = STATE(593),
    [sym__expression] = STATE(593),
    [sym_assign_receiver_field] = STATE(593),
    [sym_assign_local] = STATE(593),
    [sym_assign_field] = STATE(593),
    [sym_replace_local] = STATE(593),
    [sym_replace_field] = STATE(593),
    [sym_compound_assign_local] = STATE(593),
    [sym_compound_assign_field] = STATE(593),
    [sym_compound_assign_receiver_field] = STATE(593),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(593),
    [sym_call_with_receiver] = STATE(593),
    [sym_ref] = STATE(593),
    [sym_mut] = STATE(593),
    [sym_recover] = STATE(593),
    [sym_grouped_expression] = STATE(593),
    [sym_tuple] = STATE(593),
    [sym_array] = STATE(593),
    [sym_return] = STATE(593),
    [sym_try] = STATE(593),
    [sym_throw] = STATE(593),
    [sym_if] = STATE(593),
    [sym_while] = STATE(593),
    [sym_loop] = STATE(593),
    [sym_match] = STATE(593),
    [sym_closure] = STATE(593),
    [sym_define_variable] = STATE(593),
    [sym_and_or] = STATE(593),
    [sym_binary] = STATE(593),
    [sym_cast] = STATE(593),
    [sym_string] = STATE(593),
    [sym_true] = STATE(593),
    [sym_false] = STATE(593),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(489),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(491),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(493),
    [sym_nil] = ACTIONS(493),
    [sym_break] = ACTIONS(493),
    [sym_next] = ACTIONS(493),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [47] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(495),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [48] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(497),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [49] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(499),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [50] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(501),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [51] = {
    [sym_block] = STATE(580),
    [sym__expression] = STATE(580),
    [sym_assign_receiver_field] = STATE(580),
    [sym_assign_local] = STATE(580),
    [sym_assign_field] = STATE(580),
    [sym_replace_local] = STATE(580),
    [sym_replace_field] = STATE(580),
    [sym_compound_assign_local] = STATE(580),
    [sym_compound_assign_field] = STATE(580),
    [sym_compound_assign_receiver_field] = STATE(580),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(580),
    [sym_call_with_receiver] = STATE(580),
    [sym_ref] = STATE(580),
    [sym_mut] = STATE(580),
    [sym_recover] = STATE(580),
    [sym_grouped_expression] = STATE(580),
    [sym_tuple] = STATE(580),
    [sym_array] = STATE(580),
    [sym_return] = STATE(580),
    [sym_try] = STATE(580),
    [sym_throw] = STATE(580),
    [sym_if] = STATE(580),
    [sym_while] = STATE(580),
    [sym_loop] = STATE(580),
    [sym_match] = STATE(580),
    [sym_closure] = STATE(580),
    [sym_define_variable] = STATE(580),
    [sym_and_or] = STATE(580),
    [sym_binary] = STATE(580),
    [sym_cast] = STATE(580),
    [sym_string] = STATE(580),
    [sym_true] = STATE(580),
    [sym_false] = STATE(580),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(503),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(505),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(507),
    [sym_nil] = ACTIONS(507),
    [sym_break] = ACTIONS(507),
    [sym_next] = ACTIONS(507),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [52] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(509),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [53] = {
    [sym_block] = STATE(582),
    [sym__expression] = STATE(582),
    [sym_assign_receiver_field] = STATE(582),
    [sym_assign_local] = STATE(582),
    [sym_assign_field] = STATE(582),
    [sym_replace_local] = STATE(582),
    [sym_replace_field] = STATE(582),
    [sym_compound_assign_local] = STATE(582),
    [sym_compound_assign_field] = STATE(582),
    [sym_compound_assign_receiver_field] = STATE(582),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(582),
    [sym_call_with_receiver] = STATE(582),
    [sym_ref] = STATE(582),
    [sym_mut] = STATE(582),
    [sym_recover] = STATE(582),
    [sym_grouped_expression] = STATE(582),
    [sym_tuple] = STATE(582),
    [sym_array] = STATE(582),
    [sym_return] = STATE(582),
    [sym_try] = STATE(582),
    [sym_throw] = STATE(582),
    [sym_if] = STATE(582),
    [sym_while] = STATE(582),
    [sym_loop] = STATE(582),
    [sym_match] = STATE(582),
    [sym_closure] = STATE(582),
    [sym_define_variable] = STATE(582),
    [sym_and_or] = STATE(582),
    [sym_binary] = STATE(582),
    [sym_cast] = STATE(582),
    [sym_string] = STATE(582),
    [sym_true] = STATE(582),
    [sym_false] = STATE(582),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(511),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(513),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(515),
    [sym_nil] = ACTIONS(515),
    [sym_break] = ACTIONS(515),
    [sym_next] = ACTIONS(515),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [54] = {
    [sym_block] = STATE(592),
    [sym__expression] = STATE(592),
    [sym_assign_receiver_field] = STATE(592),
    [sym_assign_local] = STATE(592),
    [sym_assign_field] = STATE(592),
    [sym_replace_local] = STATE(592),
    [sym_replace_field] = STATE(592),
    [sym_compound_assign_local] = STATE(592),
    [sym_compound_assign_field] = STATE(592),
    [sym_compound_assign_receiver_field] = STATE(592),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(592),
    [sym_call_with_receiver] = STATE(592),
    [sym_ref] = STATE(592),
    [sym_mut] = STATE(592),
    [sym_recover] = STATE(592),
    [sym_grouped_expression] = STATE(592),
    [sym_tuple] = STATE(592),
    [sym_array] = STATE(592),
    [sym_return] = STATE(592),
    [sym_try] = STATE(592),
    [sym_throw] = STATE(592),
    [sym_if] = STATE(592),
    [sym_while] = STATE(592),
    [sym_loop] = STATE(592),
    [sym_match] = STATE(592),
    [sym_closure] = STATE(592),
    [sym_define_variable] = STATE(592),
    [sym_and_or] = STATE(592),
    [sym_binary] = STATE(592),
    [sym_cast] = STATE(592),
    [sym_string] = STATE(592),
    [sym_true] = STATE(592),
    [sym_false] = STATE(592),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(517),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(519),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(521),
    [sym_nil] = ACTIONS(521),
    [sym_break] = ACTIONS(521),
    [sym_next] = ACTIONS(521),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [55] = {
    [sym_block] = STATE(585),
    [sym__expression] = STATE(585),
    [sym_assign_receiver_field] = STATE(585),
    [sym_assign_local] = STATE(585),
    [sym_assign_field] = STATE(585),
    [sym_replace_local] = STATE(585),
    [sym_replace_field] = STATE(585),
    [sym_compound_assign_local] = STATE(585),
    [sym_compound_assign_field] = STATE(585),
    [sym_compound_assign_receiver_field] = STATE(585),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(585),
    [sym_call_with_receiver] = STATE(585),
    [sym_ref] = STATE(585),
    [sym_mut] = STATE(585),
    [sym_recover] = STATE(585),
    [sym_grouped_expression] = STATE(585),
    [sym_tuple] = STATE(585),
    [sym_array] = STATE(585),
    [sym_return] = STATE(585),
    [sym_try] = STATE(585),
    [sym_throw] = STATE(585),
    [sym_if] = STATE(585),
    [sym_while] = STATE(585),
    [sym_loop] = STATE(585),
    [sym_match] = STATE(585),
    [sym_closure] = STATE(585),
    [sym_define_variable] = STATE(585),
    [sym_and_or] = STATE(585),
    [sym_binary] = STATE(585),
    [sym_cast] = STATE(585),
    [sym_string] = STATE(585),
    [sym_true] = STATE(585),
    [sym_false] = STATE(585),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(523),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(525),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(527),
    [sym_nil] = ACTIONS(527),
    [sym_break] = ACTIONS(527),
    [sym_next] = ACTIONS(527),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [56] = {
    [sym_block] = STATE(586),
    [sym__expression] = STATE(586),
    [sym_assign_receiver_field] = STATE(586),
    [sym_assign_local] = STATE(586),
    [sym_assign_field] = STATE(586),
    [sym_replace_local] = STATE(586),
    [sym_replace_field] = STATE(586),
    [sym_compound_assign_local] = STATE(586),
    [sym_compound_assign_field] = STATE(586),
    [sym_compound_assign_receiver_field] = STATE(586),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(586),
    [sym_call_with_receiver] = STATE(586),
    [sym_ref] = STATE(586),
    [sym_mut] = STATE(586),
    [sym_recover] = STATE(586),
    [sym_grouped_expression] = STATE(586),
    [sym_tuple] = STATE(586),
    [sym_array] = STATE(586),
    [sym_return] = STATE(586),
    [sym_try] = STATE(586),
    [sym_throw] = STATE(586),
    [sym_if] = STATE(586),
    [sym_while] = STATE(586),
    [sym_loop] = STATE(586),
    [sym_match] = STATE(586),
    [sym_closure] = STATE(586),
    [sym_define_variable] = STATE(586),
    [sym_and_or] = STATE(586),
    [sym_binary] = STATE(586),
    [sym_cast] = STATE(586),
    [sym_string] = STATE(586),
    [sym_true] = STATE(586),
    [sym_false] = STATE(586),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(529),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(531),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(533),
    [sym_nil] = ACTIONS(533),
    [sym_break] = ACTIONS(533),
    [sym_next] = ACTIONS(533),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [57] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(535),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [58] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(537),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [59] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_RPAREN] = ACTIONS(539),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
  [60] = {
    [sym_block] = STATE(575),
    [sym__expression] = STATE(575),
    [sym_assign_receiver_field] = STATE(575),
    [sym_assign_local] = STATE(575),
    [sym_assign_field] = STATE(575),
    [sym_replace_local] = STATE(575),
    [sym_replace_field] = STATE(575),
    [sym_compound_assign_local] = STATE(575),
    [sym_compound_assign_field] = STATE(575),
    [sym_compound_assign_receiver_field] = STATE(575),
    [sym__call_name] = STATE(1120),
    [sym_call] = STATE(575),
    [sym_call_with_receiver] = STATE(575),
    [sym_ref] = STATE(575),
    [sym_mut] = STATE(575),
    [sym_recover] = STATE(575),
    [sym_grouped_expression] = STATE(575),
    [sym_tuple] = STATE(575),
    [sym_array] = STATE(575),
    [sym_return] = STATE(575),
    [sym_try] = STATE(575),
    [sym_throw] = STATE(575),
    [sym_if] = STATE(575),
    [sym_while] = STATE(575),
    [sym_loop] = STATE(575),
    [sym_match] = STATE(575),
    [sym_closure] = STATE(575),
    [sym_define_variable] = STATE(575),
    [sym_and_or] = STATE(575),
    [sym_binary] = STATE(575),
    [sym_cast] = STATE(575),
    [sym_string] = STATE(575),
    [sym_true] = STATE(575),
    [sym_false] = STATE(575),
    [sym_identifier] = ACTIONS(79),
    [anon_sym_LPAREN] = ACTIONS(81),
    [anon_sym_if] = ACTIONS(83),
    [anon_sym_DQUOTE] = ACTIONS(85),
    [anon_sym_fn] = ACTIONS(87),
    [anon_sym_LBRACK] = ACTIONS(89),
    [anon_sym_RBRACK] = ACTIONS(541),
    [anon_sym_mut] = ACTIONS(91),
    [anon_sym_LBRACE] = ACTIONS(93),
    [anon_sym_let] = ACTIONS(95),
    [anon_sym_ref] = ACTIONS(97),
    [anon_sym_recover] = ACTIONS(99),
    [anon_sym_return] = ACTIONS(101),
    [anon_sym_try] = ACTIONS(103),
    [anon_sym_throw] = ACTIONS(105),
    [anon_sym_while] = ACTIONS(107),
    [anon_sym_loop] = ACTIONS(109),
    [anon_sym_match] = ACTIONS(111),
    [anon_sym_true] = ACTIONS(113),
    [anon_sym_false] = ACTIONS(115),
    [sym_float] = ACTIONS(481),
    [sym_integer] = ACTIONS(119),
    [anon_sym_SQUOTE] = ACTIONS(121),
    [sym_self] = ACTIONS(483),
    [sym_nil] = ACTIONS(483),
    [sym_break] = ACTIONS(483),
    [sym_next] = ACTIONS(483),
    [sym_line_comment] = ACTIONS(3),
    [sym_identifier_with_special] = ACTIONS(125),
    [sym_field] = ACTIONS(127),
    [sym_constant] = ACTIONS(129),
  },
};

static const uint16_t ts_small_parse_table[] = {
  [0] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(543), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(545), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(317), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [123] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(547), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(549), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(299), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [246] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(551), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(553), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(201), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [369] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(555), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(557), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(583), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [492] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(559), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(561), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(600), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [615] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(563), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(565), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(577), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [738] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(567), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(569), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(549), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [861] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(571), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(573), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(605), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [984] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(575), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(577), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(308), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [1107] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(579), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(581), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(584), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [1230] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(583), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(585), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(290), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [1353] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(587), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(589), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(608), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [1476] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(591), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(593), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(606), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [1599] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(595), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(597), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(346), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [1722] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(599), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(601), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(609), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [1845] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(603), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(605), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(330), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [1968] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(607), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(609), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(325), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [2091] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(611), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(613), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(200), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [2214] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(615), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(617), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(318), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [2337] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(619), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(621), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(326), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [2460] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(623), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(625), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(327), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [2583] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(627), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(629), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(337), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [2706] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(631), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(633), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(338), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [2829] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(635), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(637), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(347), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [2952] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(639), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(641), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(210), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [3075] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(643), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(645), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(215), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [3198] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(647), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(649), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(601), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [3321] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(651), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(653), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(596), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [3444] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(655), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(657), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(344), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [3567] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(659), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(661), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(576), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [3690] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(663), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(665), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(557), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [3813] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(667), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(669), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(604), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [3936] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(671), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(673), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(220), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [4059] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(675), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(677), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(217), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [4182] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(679), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(681), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(250), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [4305] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(683), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(685), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(212), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [4428] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(687), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(689), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(236), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [4551] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(691), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(693), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(214), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [4674] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(695), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(697), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(228), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [4797] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(699), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(701), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(570), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [4920] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(703), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(705), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(193), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [5043] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(707), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(709), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(194), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [5166] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(711), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(713), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(571), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [5289] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(715), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(717), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(324), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [5412] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(719), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(721), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(568), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [5535] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(723), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(725), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(574), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [5658] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(727), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(729), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(611), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [5781] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(731), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(733), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(578), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [5904] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(735), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(737), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(562), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [6027] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(739), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(741), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(581), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [6150] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(743), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(745), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(554), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [6273] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(747), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(749), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(552), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [6396] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(751), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(753), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(569), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [6519] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(755), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(757), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(293), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [6642] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(759), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(761), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(610), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [6765] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(763), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(765), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(276), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [6888] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(767), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(769), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(559), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [7011] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(771), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(773), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(553), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [7134] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(775), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(777), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(588), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [7257] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(779), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(781), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(287), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [7380] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(783), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(785), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(589), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [7503] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(787), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(789), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(590), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [7626] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(153), 1,
      sym_identifier,
    ACTIONS(155), 1,
      anon_sym_LPAREN,
    ACTIONS(157), 1,
      anon_sym_if,
    ACTIONS(159), 1,
      anon_sym_DQUOTE,
    ACTIONS(161), 1,
      anon_sym_fn,
    ACTIONS(163), 1,
      anon_sym_LBRACK,
    ACTIONS(165), 1,
      anon_sym_mut,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(169), 1,
      anon_sym_let,
    ACTIONS(171), 1,
      anon_sym_ref,
    ACTIONS(173), 1,
      anon_sym_recover,
    ACTIONS(175), 1,
      anon_sym_return,
    ACTIONS(177), 1,
      anon_sym_try,
    ACTIONS(179), 1,
      anon_sym_throw,
    ACTIONS(181), 1,
      anon_sym_while,
    ACTIONS(183), 1,
      anon_sym_loop,
    ACTIONS(185), 1,
      anon_sym_match,
    ACTIONS(187), 1,
      anon_sym_true,
    ACTIONS(189), 1,
      anon_sym_false,
    ACTIONS(193), 1,
      sym_integer,
    ACTIONS(195), 1,
      anon_sym_SQUOTE,
    ACTIONS(199), 1,
      sym_identifier_with_special,
    ACTIONS(201), 1,
      sym_field,
    ACTIONS(203), 1,
      sym_constant,
    ACTIONS(791), 1,
      sym_float,
    STATE(1092), 1,
      sym__call_name,
    ACTIONS(793), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(278), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [7749] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(795), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(797), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(572), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [7872] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(799), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(801), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(573), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [7995] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(803), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(805), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(237), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [8118] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(481), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(483), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(575), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [8241] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(807), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(809), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(546), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [8364] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(811), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(813), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(599), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [8487] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(815), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(817), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(602), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [8610] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(819), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(821), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(603), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [8733] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(823), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(825), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(216), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [8856] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(827), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(829), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(239), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [8979] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(831), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(833), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(242), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [9102] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(835), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(837), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(563), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [9225] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(839), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(841), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(252), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [9348] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(843), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(845), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(548), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [9471] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(847), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(849), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(607), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [9594] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(851), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(853), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(556), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [9717] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(855), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(857), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(545), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [9840] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(859), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(861), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(615), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [9963] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(863), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(865), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(550), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [10086] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(867), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(869), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(614), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [10209] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(871), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(873), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(613), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [10332] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(875), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(877), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(561), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [10455] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(879), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(881), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(564), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [10578] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(883), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(885), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(587), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [10701] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(887), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(889), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(612), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [10824] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(891), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(893), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(579), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [10947] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(895), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(897), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(595), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [11070] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(899), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(901), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(229), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [11193] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(131), 1,
      sym_identifier,
    ACTIONS(133), 1,
      anon_sym_mut,
    ACTIONS(135), 1,
      anon_sym_let,
    ACTIONS(137), 1,
      anon_sym_ref,
    ACTIONS(139), 1,
      anon_sym_recover,
    ACTIONS(141), 1,
      anon_sym_return,
    ACTIONS(143), 1,
      anon_sym_try,
    ACTIONS(145), 1,
      anon_sym_throw,
    ACTIONS(151), 1,
      sym_field,
    ACTIONS(903), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(905), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(594), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [11316] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(907), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(909), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(241), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [11439] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(7), 1,
      sym_identifier,
    ACTIONS(11), 1,
      anon_sym_LPAREN,
    ACTIONS(13), 1,
      anon_sym_if,
    ACTIONS(15), 1,
      anon_sym_DQUOTE,
    ACTIONS(19), 1,
      anon_sym_LBRACK,
    ACTIONS(21), 1,
      anon_sym_mut,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(33), 1,
      anon_sym_ref,
    ACTIONS(35), 1,
      anon_sym_recover,
    ACTIONS(37), 1,
      anon_sym_return,
    ACTIONS(39), 1,
      anon_sym_try,
    ACTIONS(41), 1,
      anon_sym_throw,
    ACTIONS(43), 1,
      anon_sym_while,
    ACTIONS(45), 1,
      anon_sym_loop,
    ACTIONS(47), 1,
      anon_sym_match,
    ACTIONS(49), 1,
      anon_sym_true,
    ACTIONS(51), 1,
      anon_sym_false,
    ACTIONS(55), 1,
      sym_integer,
    ACTIONS(57), 1,
      anon_sym_SQUOTE,
    ACTIONS(61), 1,
      sym_identifier_with_special,
    ACTIONS(63), 1,
      sym_field,
    ACTIONS(65), 1,
      sym_constant,
    ACTIONS(71), 1,
      anon_sym_fn,
    ACTIONS(73), 1,
      anon_sym_let,
    ACTIONS(911), 1,
      sym_float,
    STATE(1059), 1,
      sym__call_name,
    ACTIONS(913), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(240), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [11562] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(915), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(917), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(555), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [11685] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(919), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(921), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(551), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [11808] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(923), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(925), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(560), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [11931] = 29,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(79), 1,
      sym_identifier,
    ACTIONS(81), 1,
      anon_sym_LPAREN,
    ACTIONS(83), 1,
      anon_sym_if,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(87), 1,
      anon_sym_fn,
    ACTIONS(89), 1,
      anon_sym_LBRACK,
    ACTIONS(91), 1,
      anon_sym_mut,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(95), 1,
      anon_sym_let,
    ACTIONS(97), 1,
      anon_sym_ref,
    ACTIONS(99), 1,
      anon_sym_recover,
    ACTIONS(101), 1,
      anon_sym_return,
    ACTIONS(103), 1,
      anon_sym_try,
    ACTIONS(105), 1,
      anon_sym_throw,
    ACTIONS(107), 1,
      anon_sym_while,
    ACTIONS(109), 1,
      anon_sym_loop,
    ACTIONS(111), 1,
      anon_sym_match,
    ACTIONS(113), 1,
      anon_sym_true,
    ACTIONS(115), 1,
      anon_sym_false,
    ACTIONS(119), 1,
      sym_integer,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(125), 1,
      sym_identifier_with_special,
    ACTIONS(127), 1,
      sym_field,
    ACTIONS(129), 1,
      sym_constant,
    ACTIONS(927), 1,
      sym_float,
    STATE(1120), 1,
      sym__call_name,
    ACTIONS(929), 4,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
    STATE(547), 33,
      sym_block,
      sym__expression,
      sym_assign_receiver_field,
      sym_assign_local,
      sym_assign_field,
      sym_replace_local,
      sym_replace_field,
      sym_compound_assign_local,
      sym_compound_assign_field,
      sym_compound_assign_receiver_field,
      sym_call,
      sym_call_with_receiver,
      sym_ref,
      sym_mut,
      sym_recover,
      sym_grouped_expression,
      sym_tuple,
      sym_array,
      sym_return,
      sym_try,
      sym_throw,
      sym_if,
      sym_while,
      sym_loop,
      sym_match,
      sym_closure,
      sym_define_variable,
      sym_and_or,
      sym_binary,
      sym_cast,
      sym_string,
      sym_true,
      sym_false,
  [12054] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(931), 27,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(933), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12123] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(935), 27,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(937), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12192] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(939), 27,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(941), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12261] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(943), 27,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(945), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12330] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(947), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(949), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12398] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(951), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(953), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12466] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(955), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(957), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12534] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(963), 1,
      anon_sym_else,
    STATE(174), 1,
      aux_sym_if_repeat1,
    STATE(185), 1,
      sym_else_if,
    STATE(206), 1,
      sym_else,
    ACTIONS(959), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(961), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12610] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(965), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(967), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12678] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(969), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(971), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12746] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(973), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(975), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12814] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(977), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(979), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12882] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(981), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(983), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [12950] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(985), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(987), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13018] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(989), 26,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(991), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13086] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(963), 1,
      anon_sym_else,
    STATE(176), 1,
      aux_sym_if_repeat1,
    STATE(185), 1,
      sym_else_if,
    STATE(189), 1,
      sym_else,
    ACTIONS(993), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(995), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13162] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1001), 1,
      anon_sym_LPAREN,
    ACTIONS(1003), 1,
      anon_sym_DASH_GT,
    STATE(171), 1,
      sym__returns,
    STATE(178), 1,
      sym_fn_type_arguments,
    ACTIONS(997), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(999), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13237] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1009), 1,
      anon_sym_else,
    STATE(176), 1,
      aux_sym_if_repeat1,
    STATE(185), 1,
      sym_else_if,
    ACTIONS(1005), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1007), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13310] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1016), 1,
      anon_sym_EQ,
    ACTIONS(1018), 1,
      anon_sym_LPAREN2,
    STATE(248), 1,
      sym_call_arguments,
    ACTIONS(1012), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1014), 34,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13383] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1003), 1,
      anon_sym_DASH_GT,
    STATE(165), 1,
      sym__returns,
    ACTIONS(1020), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1022), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13453] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN2,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(317), 35,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13519] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1024), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1026), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13584] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 1,
      anon_sym_LPAREN2,
    ACTIONS(1028), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1030), 34,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13651] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(232), 1,
      sym_type_arguments,
    ACTIONS(1032), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1034), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13718] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1036), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1038), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13783] = 4,
    ACTIONS(1040), 1,
      ts_builtin_sym_end,
    ACTIONS(1044), 1,
      aux_sym_return_token1,
    ACTIONS(1046), 1,
      sym_line_comment,
    ACTIONS(1042), 55,
      anon_sym_import,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_DQUOTE,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_LBRACE,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_float,
      sym_integer,
      anon_sym_SQUOTE,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
      sym_field,
      sym_constant,
  [13850] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1048), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1050), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13915] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1052), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1054), 34,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [13980] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(311), 1,
      anon_sym_LPAREN2,
    ACTIONS(299), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(301), 34,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14047] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 1,
      anon_sym_LPAREN2,
    ACTIONS(299), 22,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(301), 34,
      anon_sym_import,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14114] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1056), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1058), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14178] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1060), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1062), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14242] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1064), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1066), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14316] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1078), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1080), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14380] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1082), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1084), 27,
      anon_sym_import,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14452] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1086), 22,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1088), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14518] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1092), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14582] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1094), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14646] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1098), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1100), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14710] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1102), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1104), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14774] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1106), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1108), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14838] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1110), 22,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1112), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14904] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1114), 22,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1116), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [14970] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1118), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1120), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15034] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1122), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1124), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15098] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1126), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1128), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15162] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1130), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1132), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15226] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1134), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1136), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15290] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1138), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1140), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15354] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1142), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1144), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15418] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1146), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1148), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15482] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1150), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1152), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15556] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1154), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1156), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15620] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1158), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1160), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15694] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1162), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1164), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15758] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1166), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1168), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15832] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1170), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1172), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15906] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1174), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1176), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [15980] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1178), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1180), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16054] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1182), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1184), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16118] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1186), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1188), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16182] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1190), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1192), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16256] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1194), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1196), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16320] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1036), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1038), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16384] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1198), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1200), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16448] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1202), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1204), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16512] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1206), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1208), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16586] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1210), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1212), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16650] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1214), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1216), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16714] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1218), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1220), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16788] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1222), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1224), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16862] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1024), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1026), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16926] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1226), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1228), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [16990] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1230), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1232), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17054] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1234), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1236), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17118] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1238), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1240), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17182] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1242), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1244), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17246] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1246), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1248), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17320] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1250), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1252), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17394] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1254), 1,
      anon_sym_else,
    STATE(258), 1,
      aux_sym_if_repeat1,
    STATE(265), 1,
      sym_else_if,
    STATE(309), 1,
      sym_else,
    ACTIONS(993), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(995), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17466] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1256), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1258), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17540] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1260), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1262), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17614] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1264), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1266), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17688] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1268), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17762] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1272), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1274), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17826] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1276), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1278), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17890] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1280), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1282), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [17954] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1284), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1286), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18018] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1288), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1290), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18082] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1292), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1294), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18146] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1296), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1298), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18210] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1300), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1302), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18284] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1304), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1306), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18348] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1068), 1,
      anon_sym_DOT,
    ACTIONS(1070), 1,
      anon_sym_as,
    ACTIONS(1072), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1076), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1308), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1074), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1310), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18422] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1312), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1314), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18486] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1316), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1318), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18550] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1254), 1,
      anon_sym_else,
    STATE(238), 1,
      aux_sym_if_repeat1,
    STATE(265), 1,
      sym_else_if,
    STATE(340), 1,
      sym_else,
    ACTIONS(959), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(961), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18622] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1320), 23,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1322), 33,
      anon_sym_import,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18686] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1324), 1,
      anon_sym_LPAREN,
    ACTIONS(1326), 1,
      anon_sym_DASH_GT,
    STATE(261), 1,
      sym_fn_type_arguments,
    STATE(275), 1,
      sym__returns,
    ACTIONS(997), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(999), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18757] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1328), 1,
      anon_sym_else,
    STATE(258), 1,
      aux_sym_if_repeat1,
    STATE(265), 1,
      sym_else_if,
    ACTIONS(1005), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1007), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18826] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1331), 1,
      anon_sym_EQ,
    ACTIONS(1333), 1,
      anon_sym_LPAREN2,
    STATE(319), 1,
      sym_call_arguments,
    ACTIONS(1012), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1014), 30,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18895] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 23,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_LPAREN2,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(317), 31,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_EQ,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [18957] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1326), 1,
      anon_sym_DASH_GT,
    STATE(302), 1,
      sym__returns,
    ACTIONS(1020), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1022), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19023] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(313), 1,
      sym_type_arguments,
    ACTIONS(1032), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1034), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19086] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1024), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1026), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19147] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1036), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1038), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19208] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1048), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1050), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19269] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 1,
      anon_sym_LPAREN2,
    ACTIONS(299), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(301), 30,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19332] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(943), 24,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(945), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19393] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 1,
      anon_sym_LPAREN2,
    ACTIONS(1028), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1030), 30,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19456] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(311), 1,
      anon_sym_LPAREN2,
    ACTIONS(299), 22,
      anon_sym_DOT,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(301), 30,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19519] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1052), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1054), 30,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_else,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19580] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(931), 24,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(933), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19641] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(935), 24,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(937), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19702] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(939), 24,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(941), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19763] = 3,
    ACTIONS(1046), 1,
      sym_line_comment,
    ACTIONS(1335), 1,
      aux_sym_return_token1,
    ACTIONS(1042), 52,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_DQUOTE,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_mut,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_float,
      sym_integer,
      anon_sym_SQUOTE,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
      sym_field,
      sym_constant,
  [19824] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(981), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(983), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19884] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1110), 22,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1112), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [19946] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(989), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(991), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20006] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1222), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1224), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20076] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1238), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1240), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20136] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1296), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1298), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20196] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1234), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1236), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20256] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1198), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1200), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20316] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1098), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1100), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20376] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1242), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1244), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20436] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1102), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1104), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20496] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1312), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1314), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20556] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1174), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1176), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20626] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(947), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(949), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20686] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1320), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1322), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20746] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1308), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1310), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20816] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1094), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1096), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20876] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1106), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1108), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20936] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1114), 22,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1116), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [20998] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1118), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1120), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21058] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1162), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1164), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21118] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1280), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1282), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21178] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1226), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1228), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21238] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1146), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1148), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21298] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1150), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1152), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21368] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1186), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1188), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21428] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1194), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1196), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21488] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(955), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(957), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21548] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1142), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1144), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21608] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1130), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1132), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21668] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1036), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1038), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21728] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1122), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1124), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21788] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(951), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(953), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21848] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1268), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1270), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21918] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1056), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1058), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [21978] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1349), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1347), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22048] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1304), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1306), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22108] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1060), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1062), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22168] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1230), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1232), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22228] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1206), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1208), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22298] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1316), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1318), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22358] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1202), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1204), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22418] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1190), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1192), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22488] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1178), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1180), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22558] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1292), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1294), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22618] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1182), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1184), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22678] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1154), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1156), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22738] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1210), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1212), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22798] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1138), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1140), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22858] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1264), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1266), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22928] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1256), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1258), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [22998] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1300), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1302), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23068] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1158), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1160), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23138] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1288), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1290), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23198] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1284), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1286), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23258] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1250), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1252), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23328] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1276), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1278), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23388] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1272), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1274), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23448] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(965), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(967), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23508] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(969), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(971), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23568] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(973), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(975), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23628] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(977), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(979), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23688] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1246), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1248), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23758] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1166), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1168), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23828] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(985), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(987), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23888] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1134), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1136), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [23948] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1214), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1216), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [24008] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1126), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1128), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [24068] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1090), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1092), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [24128] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1086), 22,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1088), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [24190] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1024), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1026), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [24250] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1341), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1218), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1220), 21,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [24320] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1337), 1,
      anon_sym_DOT,
    ACTIONS(1339), 1,
      anon_sym_as,
    ACTIONS(1345), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1082), 9,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1343), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
    ACTIONS(1084), 23,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [24388] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1078), 23,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1080), 29,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_mut,
      anon_sym_let,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_or,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [24448] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 1,
      anon_sym_LPAREN2,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1353), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1355), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(299), 13,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
    ACTIONS(301), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [24506] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1357), 1,
      anon_sym_EQ,
    ACTIONS(1359), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1361), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(299), 13,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
    ACTIONS(301), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [24561] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1363), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(309), 14,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN2,
      anon_sym_or,
    ACTIONS(317), 15,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ,
  [24612] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1363), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(311), 14,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_LPAREN2,
      anon_sym_or,
    ACTIONS(313), 15,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ,
  [24663] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 1,
      anon_sym_LPAREN2,
    ACTIONS(1351), 1,
      anon_sym_EQ,
    ACTIONS(1353), 1,
      anon_sym_COLON_EQ,
    ACTIONS(1365), 1,
      anon_sym_COLON,
    ACTIONS(299), 10,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_or,
    ACTIONS(1355), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(301), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [24721] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 1,
      anon_sym_LPAREN2,
    ACTIONS(1367), 1,
      anon_sym_EQ,
    ACTIONS(1369), 1,
      anon_sym_COLON_EQ,
    ACTIONS(299), 11,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
    ACTIONS(1371), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(301), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [24777] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1373), 1,
      anon_sym_EQ,
    ACTIONS(1375), 1,
      anon_sym_COLON_EQ,
    ACTIONS(299), 11,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
    ACTIONS(1377), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(301), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
  [24830] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(311), 12,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_LPAREN2,
      anon_sym_or,
    ACTIONS(1379), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(313), 15,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ,
  [24879] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 12,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_LPAREN2,
      anon_sym_or,
    ACTIONS(1379), 12,
      anon_sym_PLUS_EQ,
      anon_sym_DASH_EQ,
      anon_sym_SLASH_EQ,
      anon_sym_STAR_EQ,
      anon_sym_STAR_STAR_EQ,
      anon_sym_PERCENT_EQ,
      anon_sym_LT_LT_EQ,
      anon_sym_GT_GT_EQ,
      anon_sym_GT_GT_GT_EQ,
      anon_sym_AMP_EQ,
      anon_sym_PIPE_EQ,
      anon_sym_CARET_EQ,
    ACTIONS(317), 15,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ,
  [24928] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1198), 13,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_EQ,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1200), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [24974] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1385), 1,
      anon_sym_LPAREN,
    ACTIONS(1387), 1,
      anon_sym_DASH_GT,
    ACTIONS(1389), 1,
      anon_sym_LBRACE,
    STATE(362), 1,
      sym_extern_arguments,
    STATE(388), 1,
      sym__returns,
    STATE(405), 1,
      sym_block,
    ACTIONS(1381), 7,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1383), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25032] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1385), 1,
      anon_sym_LPAREN,
    ACTIONS(1387), 1,
      anon_sym_DASH_GT,
    ACTIONS(1389), 1,
      anon_sym_LBRACE,
    STATE(363), 1,
      sym_extern_arguments,
    STATE(373), 1,
      sym__returns,
    STATE(467), 1,
      sym_block,
    ACTIONS(1391), 7,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1393), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25090] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1387), 1,
      anon_sym_DASH_GT,
    ACTIONS(1395), 1,
      anon_sym_LPAREN,
    STATE(367), 1,
      sym_fn_type_arguments,
    STATE(436), 1,
      sym__returns,
    ACTIONS(997), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(999), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25143] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1387), 1,
      anon_sym_DASH_GT,
    ACTIONS(1389), 1,
      anon_sym_LBRACE,
    STATE(376), 1,
      sym__returns,
    STATE(392), 1,
      sym_block,
    ACTIONS(1397), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1399), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25196] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1387), 1,
      anon_sym_DASH_GT,
    ACTIONS(1389), 1,
      anon_sym_LBRACE,
    STATE(377), 1,
      sym__returns,
    STATE(415), 1,
      sym_block,
    ACTIONS(1401), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1403), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25249] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1409), 1,
      anon_sym_DOT,
    STATE(369), 1,
      aux_sym_path_repeat1,
    ACTIONS(1405), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1407), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25297] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1415), 1,
      anon_sym_LPAREN,
    ACTIONS(1417), 1,
      anon_sym_if,
    STATE(382), 1,
      sym_symbols,
    STATE(461), 1,
      sym_tags,
    ACTIONS(1411), 8,
      ts_builtin_sym_end,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1413), 24,
      anon_sym_import,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25349] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1423), 1,
      anon_sym_and,
    STATE(370), 1,
      aux_sym_tags_repeat1,
    ACTIONS(1419), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1421), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25397] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1387), 1,
      anon_sym_DASH_GT,
    STATE(404), 1,
      sym__returns,
    ACTIONS(1020), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1022), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25445] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1429), 1,
      anon_sym_and,
    STATE(368), 1,
      aux_sym_tags_repeat1,
    ACTIONS(1425), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1427), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25493] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1436), 1,
      anon_sym_DOT,
    STATE(369), 1,
      aux_sym_path_repeat1,
    ACTIONS(1432), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1434), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25541] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1423), 1,
      anon_sym_and,
    STATE(368), 1,
      aux_sym_tags_repeat1,
    ACTIONS(1439), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1441), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25589] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1409), 1,
      anon_sym_DOT,
    STATE(364), 1,
      aux_sym_path_repeat1,
    ACTIONS(1443), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1445), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25637] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1447), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1449), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25680] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1389), 1,
      anon_sym_LBRACE,
    STATE(412), 1,
      sym_block,
    ACTIONS(1451), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1453), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25727] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1455), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1457), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25770] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(939), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(941), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25813] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1389), 1,
      anon_sym_LBRACE,
    STATE(417), 1,
      sym_block,
    ACTIONS(1459), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1461), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25860] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1389), 1,
      anon_sym_LBRACE,
    STATE(441), 1,
      sym_block,
    ACTIONS(1463), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1465), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25907] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1467), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1469), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25950] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1471), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1473), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [25993] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1425), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1427), 26,
      anon_sym_import,
      anon_sym_if,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26036] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1475), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1477), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26079] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_if,
    STATE(410), 1,
      sym_tags,
    ACTIONS(1479), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1481), 24,
      anon_sym_import,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26126] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1432), 10,
      ts_builtin_sym_end,
      anon_sym_DOT,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1434), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26169] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(935), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(937), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26212] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(931), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(933), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26255] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1483), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1485), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26298] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1487), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1489), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26341] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1389), 1,
      anon_sym_LBRACE,
    STATE(449), 1,
      sym_block,
    ACTIONS(1491), 8,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1493), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26388] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(422), 1,
      sym_type_arguments,
    ACTIONS(1032), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1034), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26433] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(943), 10,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_DASH_GT,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(945), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26476] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1417), 1,
      anon_sym_if,
    STATE(427), 1,
      sym_tags,
    ACTIONS(1495), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1497), 24,
      anon_sym_import,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26523] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1499), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1501), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26565] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(977), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(979), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26607] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1503), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1505), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26649] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1507), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1509), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26691] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1511), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1513), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26733] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1515), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1517), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26775] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1519), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1521), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26817] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1523), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1525), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26859] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1527), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1529), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26901] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1531), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1533), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26943] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1535), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1537), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [26985] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1539), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1541), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27027] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(955), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(957), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27069] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1543), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1545), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27111] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1280), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1282), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27153] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1547), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1549), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27195] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1551), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1553), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27237] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1555), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1557), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27279] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1559), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1561), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27321] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1563), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1565), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27363] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1567), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1569), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27405] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1571), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1573), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27447] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1577), 1,
      sym_identifier,
    ACTIONS(1575), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1579), 24,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier_with_special,
  [27491] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1581), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1583), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27533] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1585), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1587), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27575] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1589), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1591), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27617] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1593), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1595), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27659] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1597), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1599), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27701] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1601), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1603), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27743] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1605), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1607), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27785] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1230), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1232), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27827] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1609), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1611), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27869] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(947), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(949), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27911] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1613), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1615), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27953] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1617), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1619), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [27995] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1621), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1623), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28037] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1625), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1627), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28079] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(985), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(987), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28121] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1629), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1631), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28163] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1633), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1635), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28205] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1637), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1639), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28247] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1641), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1643), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28289] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1645), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1647), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28331] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1649), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1651), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28373] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(981), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(983), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28415] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1653), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1655), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28457] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1657), 1,
      anon_sym_LPAREN,
    ACTIONS(1659), 1,
      anon_sym_DASH_GT,
    STATE(481), 1,
      sym_fn_type_arguments,
    STATE(485), 1,
      sym__returns,
    ACTIONS(999), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(997), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [28507] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(951), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(953), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28549] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1661), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1663), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28591] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1665), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1667), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28633] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1312), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1314), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28675] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(973), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(975), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28717] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(969), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(971), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28759] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1669), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1671), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28801] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1673), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1675), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28843] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1677), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1679), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28885] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1681), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1683), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28927] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1685), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1687), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [28969] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1689), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1691), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29011] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(965), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(967), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29053] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1693), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1695), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29095] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1697), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1699), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29137] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1701), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1703), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29179] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1705), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1707), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29221] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1709), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1711), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29263] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1713), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1715), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29305] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1717), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1719), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29347] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1138), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1140), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29389] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1721), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1723), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29431] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1725), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1727), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29473] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1729), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1731), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29515] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1733), 1,
      anon_sym_LBRACK,
    STATE(476), 1,
      sym_type_arguments,
    ACTIONS(1034), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1032), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [29561] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1036), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1038), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29603] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1735), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1737), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29645] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1739), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1741), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29687] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1743), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1745), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29729] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1747), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1749), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29771] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1024), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1026), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29813] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1751), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1753), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29855] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1755), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1757), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29897] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1238), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(1240), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29939] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(989), 9,
      ts_builtin_sym_end,
      anon_sym_LPAREN,
      anon_sym_DQUOTE,
      anon_sym_LBRACK,
      anon_sym_LBRACE,
      sym_float,
      anon_sym_SQUOTE,
      sym_field,
      sym_constant,
    ACTIONS(991), 25,
      anon_sym_import,
      anon_sym_if,
      anon_sym_fn,
      anon_sym_mut,
      anon_sym_class,
      anon_sym_let,
      anon_sym_trait,
      anon_sym_impl,
      anon_sym_ref,
      anon_sym_recover,
      anon_sym_return,
      anon_sym_try,
      anon_sym_throw,
      anon_sym_while,
      anon_sym_loop,
      anon_sym_match,
      anon_sym_true,
      anon_sym_false,
      sym_integer,
      sym_self,
      sym_nil,
      sym_break,
      sym_next,
      sym_identifier,
      sym_identifier_with_special,
  [29981] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1240), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1238), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [30022] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1314), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1312), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [30063] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1232), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1230), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [30104] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1759), 1,
      anon_sym_else,
    STATE(482), 1,
      aux_sym_if_repeat1,
    STATE(509), 1,
      sym_else_if,
    STATE(528), 1,
      sym_else,
    ACTIONS(995), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(993), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [30153] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1759), 1,
      anon_sym_else,
    STATE(477), 1,
      aux_sym_if_repeat1,
    STATE(509), 1,
      sym_else_if,
    STATE(517), 1,
      sym_else,
    ACTIONS(961), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(959), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [30202] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1282), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1280), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [30243] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1140), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(1138), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_for,
      anon_sym_or,
  [30284] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1659), 1,
      anon_sym_DASH_GT,
    STATE(499), 1,
      sym__returns,
    ACTIONS(1022), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1020), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30328] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1761), 1,
      anon_sym_else,
    STATE(482), 1,
      aux_sym_if_repeat1,
    STATE(509), 1,
      sym_else_if,
    ACTIONS(1007), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1005), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [30374] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1038), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1036), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_else,
      anon_sym_or,
  [30414] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1026), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1024), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_else,
      anon_sym_or,
  [30454] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(983), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(981), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30493] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(949), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(947), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30532] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(991), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(989), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30571] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(941), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(939), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30610] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1200), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1198), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30649] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(967), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(965), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30688] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(971), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(969), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30727] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(975), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(973), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30766] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(933), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(931), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30805] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(317), 6,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
      anon_sym_EQ,
    ACTIONS(309), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_LPAREN2,
      anon_sym_or,
  [30844] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(945), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(943), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30883] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(979), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(977), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30922] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(987), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(985), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [30961] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(937), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(935), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [31000] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(957), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(955), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [31039] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(953), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(951), 26,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_fn,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_let,
      anon_sym_case,
      anon_sym_or,
  [31078] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1104), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1102), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31116] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 1,
      anon_sym_LPAREN2,
    ACTIONS(1030), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1028), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31156] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(1764), 1,
      anon_sym_LPAREN,
    ACTIONS(1766), 1,
      anon_sym_extern,
    ACTIONS(1772), 1,
      anon_sym_DASH_GT,
    ACTIONS(1774), 1,
      anon_sym_move,
    ACTIONS(1776), 1,
      sym_visibility,
    STATE(211), 1,
      sym_block,
    STATE(746), 1,
      sym_method_name,
    STATE(803), 1,
      sym_move,
    STATE(834), 1,
      sym_closure_arguments,
    STATE(1076), 1,
      sym__returns,
    ACTIONS(1768), 6,
      aux_sym_method_name_token1,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1770), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [31216] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1054), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1052), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_else,
      anon_sym_or,
  [31254] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1184), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1182), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_if,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31292] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1778), 1,
      anon_sym_EQ,
    ACTIONS(1780), 1,
      anon_sym_LPAREN2,
    STATE(538), 1,
      sym_call_arguments,
    ACTIONS(1014), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1012), 22,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
  [31336] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(309), 1,
      anon_sym_LPAREN2,
    ACTIONS(301), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(299), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31376] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(311), 1,
      anon_sym_LPAREN2,
    ACTIONS(301), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(299), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31416] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1050), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1048), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_else,
      anon_sym_or,
  [31454] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1092), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1090), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31491] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1100), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1098), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31528] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1188), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1186), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31565] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1236), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1234), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31602] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1080), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1078), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31639] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1128), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1126), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31676] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1124), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1122), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31713] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1136), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1134), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31750] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1196), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1194), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31787] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1096), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1094), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31824] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1132), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1130), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31861] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1108), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1106), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31898] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1306), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1304), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31935] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1144), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1142), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [31972] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1244), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1242), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32009] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1298), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1296), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32046] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1164), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1162), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32083] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1120), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1118), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32120] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1058), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1056), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32157] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1274), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1272), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32194] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1278), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1276), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32231] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1286), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1284), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32268] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1228), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1226), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32305] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1290), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1288), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32342] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1204), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1202), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32379] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1322), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1320), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32416] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1212), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1210), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32453] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1156), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1154), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32490] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1294), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1292), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32527] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1318), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1316), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32564] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1216), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1214), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32601] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1148), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1146), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32638] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1062), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1060), 24,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32675] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1780), 1,
      anon_sym_LPAREN2,
    ACTIONS(1782), 1,
      anon_sym_EQ,
    STATE(538), 1,
      sym_call_arguments,
    ACTIONS(1014), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1012), 21,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [32717] = 3,
    ACTIONS(1046), 1,
      sym_line_comment,
    ACTIONS(1784), 1,
      aux_sym_return_token1,
    ACTIONS(1042), 27,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
  [32753] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1300), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [32796] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1082), 7,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_and,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [32837] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1218), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [32880] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1190), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [32923] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1256), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [32966] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1150), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33009] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1308), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33052] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1268), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33095] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1116), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1114), 21,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
  [33132] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1112), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1110), 21,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
  [33169] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1088), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1086), 21,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
      anon_sym_or,
  [33206] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1178), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33249] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1222), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33292] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1798), 1,
      anon_sym_asyncmut,
    ACTIONS(1800), 1,
      sym_visibility,
    STATE(630), 1,
      sym__method_modifier,
    STATE(745), 1,
      sym_method_name,
    ACTIONS(1796), 4,
      anon_sym_mut,
      anon_sym_move,
      anon_sym_async,
      anon_sym_static,
    ACTIONS(1768), 5,
      aux_sym_method_name_token1,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1770), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33337] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1250), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33380] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1166), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33423] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1246), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33466] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1174), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33509] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1158), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33552] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1264), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33595] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1206), 5,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_DASH_GT,
      anon_sym_RBRACK,
      anon_sym_LBRACE,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33638] = 3,
    ACTIONS(1046), 1,
      sym_line_comment,
    ACTIONS(1802), 1,
      aux_sym_return_token1,
    ACTIONS(1042), 25,
      anon_sym_DOT,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [33672] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1798), 1,
      anon_sym_asyncmut,
    STATE(629), 1,
      sym__method_modifier,
    STATE(739), 1,
      sym_method_name,
    ACTIONS(1796), 4,
      anon_sym_mut,
      anon_sym_move,
      anon_sym_async,
      anon_sym_static,
    ACTIONS(1768), 5,
      aux_sym_method_name_token1,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1770), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33714] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1088), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1086), 20,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [33749] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1158), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33790] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1812), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33831] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1264), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33872] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1308), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33913] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1268), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33954] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1082), 5,
      anon_sym_COMMA,
      anon_sym_and,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [33993] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1814), 3,
      anon_sym_COMMA,
      anon_sym_RPAREN,
      anon_sym_RBRACK,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34034] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1150), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34075] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1174), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34116] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1166), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34157] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1218), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34198] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1816), 1,
      anon_sym_COMMA,
    ACTIONS(1818), 1,
      anon_sym_RPAREN,
    STATE(984), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34243] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1246), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34284] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1820), 1,
      anon_sym_COMMA,
    ACTIONS(1822), 1,
      anon_sym_RBRACK,
    STATE(992), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34329] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1112), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1110), 20,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [34364] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1222), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34405] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1824), 1,
      anon_sym_COMMA,
    ACTIONS(1826), 1,
      anon_sym_RPAREN,
    STATE(1040), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34450] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1828), 1,
      anon_sym_COMMA,
    ACTIONS(1830), 1,
      anon_sym_RBRACK,
    STATE(959), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34495] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1832), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34536] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1300), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34577] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1178), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34618] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1190), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34659] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1206), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34700] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1834), 1,
      anon_sym_COMMA,
    ACTIONS(1836), 1,
      anon_sym_RPAREN,
    STATE(1024), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34745] = 9,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1838), 1,
      anon_sym_COMMA,
    ACTIONS(1840), 1,
      anon_sym_RBRACK,
    STATE(1023), 1,
      aux_sym_tuple_repeat1,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34790] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1250), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34831] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1806), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1256), 3,
      anon_sym_COMMA,
      anon_sym_RBRACE,
      anon_sym_case,
    ACTIONS(1810), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1808), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34872] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1804), 1,
      anon_sym_DOT,
    ACTIONS(1116), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1114), 20,
      anon_sym_COMMA,
      anon_sym_as,
      anon_sym_and,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
      anon_sym_RBRACE,
      anon_sym_case,
      anon_sym_or,
  [34907] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1848), 1,
      sym_visibility,
    STATE(631), 1,
      sym__trait_method_modifier,
    STATE(713), 1,
      sym_method_name,
    ACTIONS(1846), 2,
      anon_sym_mut,
      anon_sym_move,
    ACTIONS(1842), 5,
      aux_sym_method_name_token1,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1844), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34947] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1850), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [34987] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    STATE(534), 1,
      sym_block,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35029] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(167), 1,
      anon_sym_LBRACE,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    STATE(316), 1,
      sym_block,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35071] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1852), 2,
      anon_sym_COMMA,
      anon_sym_RPAREN,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35111] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    STATE(478), 1,
      sym_block,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35153] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1854), 1,
      anon_sym_COMMA,
    ACTIONS(1856), 1,
      anon_sym_RPAREN,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35195] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1858), 1,
      anon_sym_LBRACE,
    STATE(186), 1,
      sym_block,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35237] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1860), 1,
      anon_sym_LBRACE,
    STATE(255), 1,
      sym_block,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35279] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1862), 1,
      anon_sym_COMMA,
    ACTIONS(1864), 1,
      anon_sym_RPAREN,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35321] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(25), 1,
      anon_sym_LBRACE,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    STATE(224), 1,
      sym_block,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35363] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1866), 1,
      anon_sym_COMMA,
    ACTIONS(1868), 1,
      anon_sym_RPAREN,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35405] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1858), 1,
      anon_sym_LBRACE,
    STATE(166), 1,
      sym_block,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35447] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(93), 1,
      anon_sym_LBRACE,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    STATE(504), 1,
      sym_block,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35489] = 8,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1860), 1,
      anon_sym_LBRACE,
    STATE(270), 1,
      sym_block,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35531] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1870), 1,
      anon_sym_DASH_GT,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 5,
      anon_sym_DASH,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 13,
      anon_sym_PLUS,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35570] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1872), 1,
      anon_sym_LBRACE,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35609] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1874), 1,
      anon_sym_LBRACE,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35648] = 7,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1786), 1,
      anon_sym_DOT,
    ACTIONS(1788), 1,
      anon_sym_as,
    ACTIONS(1876), 1,
      anon_sym_LBRACE,
    ACTIONS(1790), 2,
      anon_sym_and,
      anon_sym_or,
    ACTIONS(1794), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1792), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35687] = 6,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(628), 1,
      sym__trait_method_modifier,
    STATE(720), 1,
      sym_method_name,
    ACTIONS(1846), 2,
      anon_sym_mut,
      anon_sym_move,
    ACTIONS(1842), 5,
      aux_sym_method_name_token1,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1844), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35724] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1882), 1,
      anon_sym_RPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1888), 1,
      sym_wildcard_pattern,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(832), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [35777] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    ACTIONS(1896), 1,
      anon_sym_RPAREN,
    ACTIONS(1898), 1,
      sym_wildcard_pattern,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(814), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [35830] = 5,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1900), 1,
      anon_sym_extern,
    STATE(740), 1,
      sym_method_name,
    ACTIONS(1768), 5,
      aux_sym_method_name_token1,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1770), 14,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [35863] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1888), 1,
      sym_wildcard_pattern,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    ACTIONS(1902), 1,
      anon_sym_RPAREN,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(832), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [35916] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    ACTIONS(1904), 1,
      anon_sym_RPAREN,
    ACTIONS(1906), 1,
      sym_wildcard_pattern,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(826), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [35969] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1888), 1,
      sym_wildcard_pattern,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    ACTIONS(1908), 1,
      anon_sym_RPAREN,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(832), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [36022] = 15,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1888), 1,
      sym_wildcard_pattern,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    ACTIONS(1910), 1,
      anon_sym_RPAREN,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(832), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [36075] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(359), 1,
      sym_method_name,
    ACTIONS(1768), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1770), 15,
      aux_sym_method_name_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [36105] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(360), 1,
      sym_method_name,
    ACTIONS(1768), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1770), 15,
      aux_sym_method_name_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [36135] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    ACTIONS(1912), 1,
      sym_wildcard_pattern,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(762), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [36185] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    ACTIONS(1914), 1,
      sym_wildcard_pattern,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(899), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [36235] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(719), 1,
      sym_method_name,
    ACTIONS(1842), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1844), 15,
      aux_sym_method_name_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [36265] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(737), 1,
      sym_method_name,
    ACTIONS(1768), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1770), 15,
      aux_sym_method_name_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [36295] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(741), 1,
      sym_method_name,
    ACTIONS(1768), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1770), 15,
      aux_sym_method_name_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [36325] = 4,
    ACTIONS(3), 1,
      sym_line_comment,
    STATE(721), 1,
      sym_method_name,
    ACTIONS(1842), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1844), 15,
      aux_sym_method_name_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [36355] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1888), 1,
      sym_wildcard_pattern,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(832), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [36405] = 14,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(85), 1,
      anon_sym_DQUOTE,
    ACTIONS(121), 1,
      anon_sym_SQUOTE,
    ACTIONS(1878), 1,
      sym_identifier,
    ACTIONS(1880), 1,
      anon_sym_LPAREN,
    ACTIONS(1884), 1,
      anon_sym_mut,
    ACTIONS(1886), 1,
      anon_sym_LBRACE,
    ACTIONS(1892), 1,
      sym_integer,
    ACTIONS(1894), 1,
      sym_constant,
    ACTIONS(1916), 1,
      sym_wildcard_pattern,
    STATE(779), 1,
      sym_namespaced_constant_pattern,
    STATE(790), 1,
      sym_string,
    ACTIONS(1890), 2,
      anon_sym_true,
      anon_sym_false,
    STATE(883), 7,
      sym__pattern,
      sym_mutable_pattern,
      sym_tuple_pattern,
      sym_enum_pattern,
      sym_class_pattern,
      sym_or_pattern,
      sym_boolean_pattern,
  [36455] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1920), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1918), 15,
      aux_sym_method_name_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [36482] = 3,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1924), 4,
      anon_sym_STAR,
      anon_sym_LT,
      anon_sym_GT,
      anon_sym_GT_GT,
    ACTIONS(1922), 15,
      aux_sym_method_name_token1,
      anon_sym_PLUS,
      anon_sym_DASH,
      anon_sym_SLASH,
      anon_sym_STAR_STAR,
      anon_sym_PERCENT,
      anon_sym_LT_EQ,
      anon_sym_GT_EQ,
      anon_sym_LT_LT,
      anon_sym_GT_GT_GT,
      anon_sym_AMP,
      anon_sym_PIPE,
      anon_sym_CARET,
      anon_sym_EQ_EQ,
      anon_sym_BANG_EQ,
  [36509] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1928), 1,
      anon_sym_RPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    STATE(1027), 8,
      sym__type,
      sym_generic_type,
      sym_ref_type,
      sym_mut_type,
      sym_uni_type,
      sym_move_type,
      sym_fn_type,
      sym_tuple_type,
  [36547] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    ACTIONS(1942), 1,
      anon_sym_RPAREN,
    STATE(963), 8,
      sym__type,
      sym_generic_type,
      sym_ref_type,
      sym_mut_type,
      sym_uni_type,
      sym_move_type,
      sym_fn_type,
      sym_tuple_type,
  [36585] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    ACTIONS(1944), 1,
      anon_sym_RPAREN,
    STATE(1013), 8,
      sym__type,
      sym_generic_type,
      sym_ref_type,
      sym_mut_type,
      sym_uni_type,
      sym_move_type,
      sym_fn_type,
      sym_tuple_type,
  [36623] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    ACTIONS(1946), 1,
      anon_sym_RPAREN,
    STATE(979), 8,
      sym__type,
      sym_generic_type,
      sym_ref_type,
      sym_mut_type,
      sym_uni_type,
      sym_move_type,
      sym_fn_type,
      sym_tuple_type,
  [36661] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    ACTIONS(1948), 1,
      anon_sym_RPAREN,
    STATE(990), 8,
      sym__type,
      sym_generic_type,
      sym_ref_type,
      sym_mut_type,
      sym_uni_type,
      sym_move_type,
      sym_fn_type,
      sym_tuple_type,
  [36699] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    ACTIONS(1950), 1,
      anon_sym_RPAREN,
    STATE(1029), 8,
      sym__type,
      sym_generic_type,
      sym_ref_type,
      sym_mut_type,
      sym_uni_type,
      sym_move_type,
      sym_fn_type,
      sym_tuple_type,
  [36737] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    ACTIONS(1952), 1,
      anon_sym_RPAREN,
    STATE(996), 8,
      sym__type,
      sym_generic_type,
      sym_ref_type,
      sym_mut_type,
      sym_uni_type,
      sym_move_type,
      sym_fn_type,
      sym_tuple_type,
  [36775] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    ACTIONS(1954), 1,
      anon_sym_RPAREN,
    STATE(996), 8,
      sym__type,
      sym_generic_type,
      sym_ref_type,
      sym_mut_type,
      sym_uni_type,
      sym_move_type,
      sym_fn_type,
      sym_tuple_type,
  [36813] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    ACTIONS(1956), 1,
      anon_sym_RPAREN,
    STATE(996), 8,
      sym__type,
      sym_generic_type,
      sym_ref_type,
      sym_mut_type,
      sym_uni_type,
      sym_move_type,
      sym_fn_type,
      sym_tuple_type,
  [36851] = 10,
    ACTIONS(3), 1,
      sym_line_comment,
    ACTIONS(1926), 1,
      anon_sym_LPAREN,
    ACTIONS(1930), 1,
      anon_sym_fn,
    ACTIONS(1932), 1,
      anon_sym_mut,
    ACTIONS(1934), 1,
      anon_sym_move,
    ACTIONS(1936), 1,
      anon_sym_ref,
    ACTIONS(1938), 1,
      anon_sym_uni,
    ACTIONS(1940), 1,
      sym_constant,
    AC