/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, filter, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_filter_iir_filter_ccz = R"doc(IIR filter with complex input, complex output, and complex (double) taps.

This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


 The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


The input and output satisfy a difference equation of the form   


 
y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



with the corresponding rational system function   


 
H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

Constructor Specific Documentation:



Args:
    fftaps : 
    fbtaps : 
    oldstyle : )doc";


static const char* __doc_gr_filter_iir_filter_ccz_iir_filter_ccz_0 = R"doc()doc";


static const char* __doc_gr_filter_iir_filter_ccz_iir_filter_ccz_1 = R"doc()doc";


static const char* __doc_gr_filter_iir_filter_ccz_make = R"doc(IIR filter with complex input, complex output, and complex (double) taps.

This filter uses the Direct Form I implementation, where  contains the feed-forward taps, and  the feedback ones.


 The old style of the IIR filter uses feedback taps that are negative of what most definitions use (scipy and Matlab among them). This parameter keeps using the old GNU Radio style and is set to TRUE by default. When taps generated from scipy, Matlab, or gr_filter_design, use the new style by setting this to FALSE.


The input and output satisfy a difference equation of the form   


 
y[n] - \\sum_{k=1}^{M} a_k y[n-k] = \\sum_{k=0}^{N} b_k x[n-k]



with the corresponding rational system function   


 
H(z) = \\ frac{\\sum_{k=0}^{M} b_k z^{-k}}{1 - \\sum_{k=1}^{N} a_k z^{-k}}

Constructor Specific Documentation:



Args:
    fftaps : 
    fbtaps : 
    oldstyle : )doc";


static const char* __doc_gr_filter_iir_filter_ccz_set_taps = R"doc()doc";
