/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, digital, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_digital_cpmmod_bc = R"doc(Generic CPM modulator.

Examples:



The input of this block are symbols from an M-ary alphabet +/-1, +/-3, ..., +/-(M-1). Usually, M = 2 and therefore, the valid inputs are +/-1. The modulator will silently accept any other inputs, though. The output is the phase-modulated signal.

Constructor Specific Documentation:

Make CPM modulator block.

Args:
    type : The modulation type. Can be one of LREC, LRC, LSRC, TFM or GAUSSIAN. See gr_cpm::phase_response() for a detailed description.
    h : The modulation index.  is the maximum phase change that can occur between two symbols, i.e., if you only send ones, the phase will increase by   every  samples. Set this to 0.5 for Minimum Shift Keying variants.
    samples_per_sym : Samples per symbol.
    L : The length of the phase duration in symbols. For L=1, this yields full- response CPM symbols, for L > 1, partial-response.
    beta : For LSRC, this is the rolloff factor. For Gaussian pulses, this is the 3 dB time-bandwidth product.)doc";


static const char* __doc_gr_digital_cpmmod_bc_cpmmod_bc_0 = R"doc()doc";


static const char* __doc_gr_digital_cpmmod_bc_cpmmod_bc_1 = R"doc()doc";


static const char* __doc_gr_digital_cpmmod_bc_make = R"doc(Generic CPM modulator.

Examples:



The input of this block are symbols from an M-ary alphabet +/-1, +/-3, ..., +/-(M-1). Usually, M = 2 and therefore, the valid inputs are +/-1. The modulator will silently accept any other inputs, though. The output is the phase-modulated signal.

Constructor Specific Documentation:

Make CPM modulator block.

Args:
    type : The modulation type. Can be one of LREC, LRC, LSRC, TFM or GAUSSIAN. See gr_cpm::phase_response() for a detailed description.
    h : The modulation index.  is the maximum phase change that can occur between two symbols, i.e., if you only send ones, the phase will increase by   every  samples. Set this to 0.5 for Minimum Shift Keying variants.
    samples_per_sym : Samples per symbol.
    L : The length of the phase duration in symbols. For L=1, this yields full- response CPM symbols, for L > 1, partial-response.
    beta : For LSRC, this is the rolloff factor. For Gaussian pulses, this is the 3 dB time-bandwidth product.)doc";


static const char* __doc_gr_digital_cpmmod_bc_make_gmskmod_bc = R"doc(Make GMSK modulator block.


The type is GAUSSIAN and the modulation index for GMSK is 0.5. This are populated automatically by this factory function.)doc";


static const char* __doc_gr_digital_cpmmod_bc_taps = R"doc(Return the phase response FIR taps.)doc";


static const char* __doc_gr_digital_cpmmod_bc_type = R"doc(Return the type of CPM modulator.)doc";


static const char* __doc_gr_digital_cpmmod_bc_index = R"doc(Return the modulation index of the modulator.)doc";


static const char* __doc_gr_digital_cpmmod_bc_samples_per_sym = R"doc(Return the number of samples per symbol.)doc";


static const char* __doc_gr_digital_cpmmod_bc_beta = R"doc(Return the value of beta for the modulator.)doc";
