struct BaseCharMappingBlock {
  uint8_t mFirst;
  uint8_t mLast;
  uint16_t mMappingStartOffset;
};

static const uint16_t BASE_CHAR_MAPPING_LIST[] = {
  /* 0x00a1 */ 0x0021, /* ¡ → ! */
  /* 0x00a2 */ 0x00a2,
  /* 0x00a3 */ 0x00a3,
  /* 0x00a4 */ 0x00a4,
  /* 0x00a5 */ 0x00a5,
  /* 0x00a6 */ 0x00a6,
  /* 0x00a7 */ 0x00a7,
  /* 0x00a8 */ 0x00a8,
  /* 0x00a9 */ 0x00a9,
  /* 0x00aa */ 0x00aa,
  /* 0x00ab */ 0x00ab,
  /* 0x00ac */ 0x00ac,
  /* 0x00ad */ 0x00ad,
  /* 0x00ae */ 0x00ae,
  /* 0x00af */ 0x00af,
  /* 0x00b0 */ 0x00b0,
  /* 0x00b1 */ 0x00b1,
  /* 0x00b2 */ 0x00b2,
  /* 0x00b3 */ 0x00b3,
  /* 0x00b4 */ 0x00b4,
  /* 0x00b5 */ 0x00b5,
  /* 0x00b6 */ 0x00b6,
  /* 0x00b7 */ 0x00b7,
  /* 0x00b8 */ 0x00b8,
  /* 0x00b9 */ 0x00b9,
  /* 0x00ba */ 0x00ba,
  /* 0x00bb */ 0x00bb,
  /* 0x00bc */ 0x00bc,
  /* 0x00bd */ 0x00bd,
  /* 0x00be */ 0x00be,
  /* 0x00bf */ 0x003f, /* ¿ → ? */
  /* 0x00c0 */ 0x0041, /* À → A */
  /* 0x00c1 */ 0x0041, /* Á → A */
  /* 0x00c2 */ 0x0041, /* Â → A */
  /* 0x00c3 */ 0x0041, /* Ã → A */
  /* 0x00c4 */ 0x0041, /* Ä → A */
  /* 0x00c5 */ 0x0041, /* Å → A */
  /* 0x00c6 */ 0x00c6,
  /* 0x00c7 */ 0x0043, /* Ç → C */
  /* 0x00c8 */ 0x0045, /* È → E */
  /* 0x00c9 */ 0x0045, /* É → E */
  /* 0x00ca */ 0x0045, /* Ê → E */
  /* 0x00cb */ 0x0045, /* Ë → E */
  /* 0x00cc */ 0x0049, /* Ì → I */
  /* 0x00cd */ 0x0049, /* Í → I */
  /* 0x00ce */ 0x0049, /* Î → I */
  /* 0x00cf */ 0x0049, /* Ï → I */
  /* 0x00d0 */ 0x0044, /* Ð → D */
  /* 0x00d1 */ 0x004e, /* Ñ → N */
  /* 0x00d2 */ 0x004f, /* Ò → O */
  /* 0x00d3 */ 0x004f, /* Ó → O */
  /* 0x00d4 */ 0x004f, /* Ô → O */
  /* 0x00d5 */ 0x004f, /* Õ → O */
  /* 0x00d6 */ 0x004f, /* Ö → O */
  /* 0x00d7 */ 0x002a, /* × → * */
  /* 0x00d8 */ 0x004f, /* Ø → O */
  /* 0x00d9 */ 0x0055, /* Ù → U */
  /* 0x00da */ 0x0055, /* Ú → U */
  /* 0x00db */ 0x0055, /* Û → U */
  /* 0x00dc */ 0x0055, /* Ü → U */
  /* 0x00dd */ 0x0059, /* Ý → Y */
  /* 0x00de */ 0x00de,
  /* 0x00df */ 0x00df,
  /* 0x00e0 */ 0x0061, /* à → a */
  /* 0x00e1 */ 0x0061, /* á → a */
  /* 0x00e2 */ 0x0061, /* â → a */
  /* 0x00e3 */ 0x0061, /* ã → a */
  /* 0x00e4 */ 0x0061, /* ä → a */
  /* 0x00e5 */ 0x0061, /* å → a */
  /* 0x00e6 */ 0x00e6,
  /* 0x00e7 */ 0x0063, /* ç → c */
  /* 0x00e8 */ 0x0065, /* è → e */
  /* 0x00e9 */ 0x0065, /* é → e */
  /* 0x00ea */ 0x0065, /* ê → e */
  /* 0x00eb */ 0x0065, /* ë → e */
  /* 0x00ec */ 0x0069, /* ì → i */
  /* 0x00ed */ 0x0069, /* í → i */
  /* 0x00ee */ 0x0069, /* î → i */
  /* 0x00ef */ 0x0069, /* ï → i */
  /* 0x00f0 */ 0x0064, /* ð → d */
  /* 0x00f1 */ 0x006e, /* ñ → n */
  /* 0x00f2 */ 0x006f, /* ò → o */
  /* 0x00f3 */ 0x006f, /* ó → o */
  /* 0x00f4 */ 0x006f, /* ô → o */
  /* 0x00f5 */ 0x006f, /* õ → o */
  /* 0x00f6 */ 0x006f, /* ö → o */
  /* 0x00f7 */ 0x002f, /* ÷ → / */
  /* 0x00f8 */ 0x006f, /* ø → o */
  /* 0x00f9 */ 0x0075, /* ù → u */
  /* 0x00fa */ 0x0075, /* ú → u */
  /* 0x00fb */ 0x0075, /* û → u */
  /* 0x00fc */ 0x0075, /* ü → u */
  /* 0x00fd */ 0x0079, /* ý → y */
  /* 0x00fe */ 0x00fe,
  /* 0x00ff */ 0x0079, /* ÿ → y */
  /* 0x0100 */ 0x0041, /* Ā → A */
  /* 0x0101 */ 0x0061, /* ā → a */
  /* 0x0102 */ 0x0041, /* Ă → A */
  /* 0x0103 */ 0x0061, /* ă → a */
  /* 0x0104 */ 0x0041, /* Ą → A */
  /* 0x0105 */ 0x0061, /* ą → a */
  /* 0x0106 */ 0x0043, /* Ć → C */
  /* 0x0107 */ 0x0063, /* ć → c */
  /* 0x0108 */ 0x0043, /* Ĉ → C */
  /* 0x0109 */ 0x0063, /* ĉ → c */
  /* 0x010a */ 0x0043, /* Ċ → C */
  /* 0x010b */ 0x0063, /* ċ → c */
  /* 0x010c */ 0x0043, /* Č → C */
  /* 0x010d */ 0x0063, /* č → c */
  /* 0x010e */ 0x0044, /* Ď → D */
  /* 0x010f */ 0x0064, /* ď → d */
  /* 0x0110 */ 0x0044, /* Đ → D */
  /* 0x0111 */ 0x0064, /* đ → d */
  /* 0x0112 */ 0x0045, /* Ē → E */
  /* 0x0113 */ 0x0065, /* ē → e */
  /* 0x0114 */ 0x0045, /* Ĕ → E */
  /* 0x0115 */ 0x0065, /* ĕ → e */
  /* 0x0116 */ 0x0045, /* Ė → E */
  /* 0x0117 */ 0x0065, /* ė → e */
  /* 0x0118 */ 0x0045, /* Ę → E */
  /* 0x0119 */ 0x0065, /* ę → e */
  /* 0x011a */ 0x0045, /* Ě → E */
  /* 0x011b */ 0x0065, /* ě → e */
  /* 0x011c */ 0x0047, /* Ĝ → G */
  /* 0x011d */ 0x0067, /* ĝ → g */
  /* 0x011e */ 0x0047, /* Ğ → G */
  /* 0x011f */ 0x0067, /* ğ → g */
  /* 0x0120 */ 0x0047, /* Ġ → G */
  /* 0x0121 */ 0x0067, /* ġ → g */
  /* 0x0122 */ 0x0047, /* Ģ → G */
  /* 0x0123 */ 0x0067, /* ģ → g */
  /* 0x0124 */ 0x0048, /* Ĥ → H */
  /* 0x0125 */ 0x0068, /* ĥ → h */
  /* 0x0126 */ 0x0048, /* Ħ → H */
  /* 0x0127 */ 0x0068, /* ħ → h */
  /* 0x0128 */ 0x0049, /* Ĩ → I */
  /* 0x0129 */ 0x0069, /* ĩ → i */
  /* 0x012a */ 0x0049, /* Ī → I */
  /* 0x012b */ 0x0069, /* ī → i */
  /* 0x012c */ 0x0049, /* Ĭ → I */
  /* 0x012d */ 0x0069, /* ĭ → i */
  /* 0x012e */ 0x0049, /* Į → I */
  /* 0x012f */ 0x0069, /* į → i */
  /* 0x0130 */ 0x0049, /* İ → I */
  /* 0x0131 */ 0x0069, /* ı → i */
  /* 0x0132 */ 0x0132,
  /* 0x0133 */ 0x0133,
  /* 0x0134 */ 0x004a, /* Ĵ → J */
  /* 0x0135 */ 0x006a, /* ĵ → j */
  /* 0x0136 */ 0x004b, /* Ķ → K */
  /* 0x0137 */ 0x006b, /* ķ → k */
  /* 0x0138 */ 0x0071, /* ĸ → q */
  /* 0x0139 */ 0x004c, /* Ĺ → L */
  /* 0x013a */ 0x006c, /* ĺ → l */
  /* 0x013b */ 0x004c, /* Ļ → L */
  /* 0x013c */ 0x006c, /* ļ → l */
  /* 0x013d */ 0x004c, /* Ľ → L */
  /* 0x013e */ 0x006c, /* ľ → l */
  /* 0x013f */ 0x004c, /* Ŀ → L */
  /* 0x0140 */ 0x006c, /* ŀ → l */
  /* 0x0141 */ 0x004c, /* Ł → L */
  /* 0x0142 */ 0x006c, /* ł → l */
  /* 0x0143 */ 0x004e, /* Ń → N */
  /* 0x0144 */ 0x006e, /* ń → n */
  /* 0x0145 */ 0x004e, /* Ņ → N */
  /* 0x0146 */ 0x006e, /* ņ → n */
  /* 0x0147 */ 0x004e, /* Ň → N */
  /* 0x0148 */ 0x006e, /* ň → n */
  /* 0x0149 */ 0x0149,
  /* 0x014a */ 0x004e, /* Ŋ → N */
  /* 0x014b */ 0x006e, /* ŋ → n */
  /* 0x014c */ 0x004f, /* Ō → O */
  /* 0x014d */ 0x006f, /* ō → o */
  /* 0x014e */ 0x004f, /* Ŏ → O */
  /* 0x014f */ 0x006f, /* ŏ → o */
  /* 0x0150 */ 0x004f, /* Ő → O */
  /* 0x0151 */ 0x006f, /* ő → o */
  /* 0x0152 */ 0x0152,
  /* 0x0153 */ 0x0153,
  /* 0x0154 */ 0x0052, /* Ŕ → R */
  /* 0x0155 */ 0x0072, /* ŕ → r */
  /* 0x0156 */ 0x0052, /* Ŗ → R */
  /* 0x0157 */ 0x0072, /* ŗ → r */
  /* 0x0158 */ 0x0052, /* Ř → R */
  /* 0x0159 */ 0x0072, /* ř → r */
  /* 0x015a */ 0x0053, /* Ś → S */
  /* 0x015b */ 0x0073, /* ś → s */
  /* 0x015c */ 0x0053, /* Ŝ → S */
  /* 0x015d */ 0x0073, /* ŝ → s */
  /* 0x015e */ 0x0053, /* Ş → S */
  /* 0x015f */ 0x0073, /* ş → s */
  /* 0x0160 */ 0x0053, /* Š → S */
  /* 0x0161 */ 0x0073, /* š → s */
  /* 0x0162 */ 0x0054, /* Ţ → T */
  /* 0x0163 */ 0x0074, /* ţ → t */
  /* 0x0164 */ 0x0054, /* Ť → T */
  /* 0x0165 */ 0x0074, /* ť → t */
  /* 0x0166 */ 0x0054, /* Ŧ → T */
  /* 0x0167 */ 0x0074, /* ŧ → t */
  /* 0x0168 */ 0x0055, /* Ũ → U */
  /* 0x0169 */ 0x0075, /* ũ → u */
  /* 0x016a */ 0x0055, /* Ū → U */
  /* 0x016b */ 0x0075, /* ū → u */
  /* 0x016c */ 0x0055, /* Ŭ → U */
  /* 0x016d */ 0x0075, /* ŭ → u */
  /* 0x016e */ 0x0055, /* Ů → U */
  /* 0x016f */ 0x0075, /* ů → u */
  /* 0x0170 */ 0x0055, /* Ű → U */
  /* 0x0171 */ 0x0075, /* ű → u */
  /* 0x0172 */ 0x0055, /* Ų → U */
  /* 0x0173 */ 0x0075, /* ų → u */
  /* 0x0174 */ 0x0057, /* Ŵ → W */
  /* 0x0175 */ 0x0077, /* ŵ → w */
  /* 0x0176 */ 0x0059, /* Ŷ → Y */
  /* 0x0177 */ 0x0079, /* ŷ → y */
  /* 0x0178 */ 0x0059, /* Ÿ → Y */
  /* 0x0179 */ 0x005a, /* Ź → Z */
  /* 0x017a */ 0x007a, /* ź → z */
  /* 0x017b */ 0x005a, /* Ż → Z */
  /* 0x017c */ 0x007a, /* ż → z */
  /* 0x017d */ 0x005a, /* Ž → Z */
  /* 0x017e */ 0x007a, /* ž → z */
  /* 0x017f */ 0x0073, /* ſ → s */
  /* 0x0180 */ 0x0062, /* ƀ → b */
  /* 0x0181 */ 0x0042, /* Ɓ → B */
  /* 0x0182 */ 0x0042, /* Ƃ → B */
  /* 0x0183 */ 0x0062, /* ƃ → b */
  /* 0x0184 */ 0x0184,
  /* 0x0185 */ 0x0185,
  /* 0x0186 */ 0x0186,
  /* 0x0187 */ 0x0043, /* Ƈ → C */
  /* 0x0188 */ 0x0063, /* ƈ → c */
  /* 0x0189 */ 0x0044, /* Ɖ → D */
  /* 0x018a */ 0x0044, /* Ɗ → D */
  /* 0x018b */ 0x0044, /* Ƌ → D */
  /* 0x018c */ 0x0064, /* ƌ → d */
  /* 0x018d */ 0x018d,
  /* 0x018e */ 0x018e,
  /* 0x018f */ 0x018f,
  /* 0x0190 */ 0x0045, /* Ɛ → E */
  /* 0x0191 */ 0x0046, /* Ƒ → F */
  /* 0x0192 */ 0x0066, /* ƒ → f */
  /* 0x0193 */ 0x0047, /* Ɠ → G */
  /* 0x0194 */ 0x0194,
  /* 0x0195 */ 0x0195,
  /* 0x0196 */ 0x0049, /* Ɩ → I */
  /* 0x0197 */ 0x0049, /* Ɨ → I */
  /* 0x0198 */ 0x004b, /* Ƙ → K */
  /* 0x0199 */ 0x006b, /* ƙ → k */
  /* 0x019a */ 0x006c, /* ƚ → l */
  /* 0x019b */ 0x019b,
  /* 0x019c */ 0x019c,
  /* 0x019d */ 0x004e, /* Ɲ → N */
  /* 0x019e */ 0x006e, /* ƞ → n */
  /* 0x019f */ 0x019f,
  /* 0x01a0 */ 0x004f, /* Ơ → O */
  /* 0x01a1 */ 0x006f, /* ơ → o */
  /* 0x01a2 */ 0x01a2,
  /* 0x01a3 */ 0x01a3,
  /* 0x01a4 */ 0x0050, /* Ƥ → P */
  /* 0x01a5 */ 0x0070, /* ƥ → p */
  /* 0x01a6 */ 0x01a6,
  /* 0x01a7 */ 0x01a7,
  /* 0x01a8 */ 0x01a8,
  /* 0x01a9 */ 0x01a9,
  /* 0x01aa */ 0x01aa,
  /* 0x01ab */ 0x0074, /* ƫ → t */
  /* 0x01ac */ 0x0054, /* Ƭ → T */
  /* 0x01ad */ 0x0074, /* ƭ → t */
  /* 0x01ae */ 0x0054, /* Ʈ → T */
  /* 0x01af */ 0x0055, /* Ư → U */
  /* 0x01b0 */ 0x0075, /* ư → u */
  /* 0x01b1 */ 0x01b1,
  /* 0x01b2 */ 0x0056, /* Ʋ → V */
  /* 0x01b3 */ 0x0059, /* Ƴ → Y */
  /* 0x01b4 */ 0x0079, /* ƴ → y */
  /* 0x01b5 */ 0x005a, /* Ƶ → Z */
  /* 0x01b6 */ 0x007a, /* ƶ → z */
  /* 0x01b7 */ 0x01b7,
  /* 0x01b8 */ 0x01b8,
  /* 0x01b9 */ 0x01b9,
  /* 0x01ba */ 0x01ba,
  /* 0x01bb */ 0x01bb,
  /* 0x01bc */ 0x01bc,
  /* 0x01bd */ 0x01bd,
  /* 0x01be */ 0x01be,
  /* 0x01bf */ 0x01bf,
  /* 0x01c0 */ 0x01c0,
  /* 0x01c1 */ 0x01c1,
  /* 0x01c2 */ 0x01c2,
  /* 0x01c3 */ 0x01c3,
  /* 0x01c4 */ 0x01c4,
  /* 0x01c5 */ 0x01c5,
  /* 0x01c6 */ 0x01c6,
  /* 0x01c7 */ 0x01c7,
  /* 0x01c8 */ 0x01c8,
  /* 0x01c9 */ 0x01c9,
  /* 0x01ca */ 0x01ca,
  /* 0x01cb */ 0x01cb,
  /* 0x01cc */ 0x01cc,
  /* 0x01cd */ 0x0041, /* Ǎ → A */
  /* 0x01ce */ 0x0061, /* ǎ → a */
  /* 0x01cf */ 0x0049, /* Ǐ → I */
  /* 0x01d0 */ 0x0069, /* ǐ → i */
  /* 0x01d1 */ 0x004f, /* Ǒ → O */
  /* 0x01d2 */ 0x006f, /* ǒ → o */
  /* 0x01d3 */ 0x0055, /* Ǔ → U */
  /* 0x01d4 */ 0x0075, /* ǔ → u */
  /* 0x01d5 */ 0x0055, /* Ǖ → U */
  /* 0x01d6 */ 0x0075, /* ǖ → u */
  /* 0x01d7 */ 0x0055, /* Ǘ → U */
  /* 0x01d8 */ 0x0075, /* ǘ → u */
  /* 0x01d9 */ 0x0055, /* Ǚ → U */
  /* 0x01da */ 0x0075, /* ǚ → u */
  /* 0x01db */ 0x0055, /* Ǜ → U */
  /* 0x01dc */ 0x0075, /* ǜ → u */
  /* 0x01dd */ 0x01dd,
  /* 0x01de */ 0x0041, /* Ǟ → A */
  /* 0x01df */ 0x0061, /* ǟ → a */
  /* 0x01e0 */ 0x0041, /* Ǡ → A */
  /* 0x01e1 */ 0x0061, /* ǡ → a */
  /* 0x01e2 */ 0x00c6, /* Ǣ → Æ */
  /* 0x01e3 */ 0x00e6, /* ǣ → æ */
  /* 0x01e4 */ 0x0047, /* Ǥ → G */
  /* 0x01e5 */ 0x0067, /* ǥ → g */
  /* 0x01e6 */ 0x0047, /* Ǧ → G */
  /* 0x01e7 */ 0x0067, /* ǧ → g */
  /* 0x01e8 */ 0x004b, /* Ǩ → K */
  /* 0x01e9 */ 0x006b, /* ǩ → k */
  /* 0x01ea */ 0x004f, /* Ǫ → O */
  /* 0x01eb */ 0x006f, /* ǫ → o */
  /* 0x01ec */ 0x004f, /* Ǭ → O */
  /* 0x01ed */ 0x006f, /* ǭ → o */
  /* 0x01ee */ 0x01b7, /* Ǯ → Ʒ */
  /* 0x01ef */ 0x0292, /* ǯ → ʒ */
  /* 0x01f0 */ 0x006a, /* ǰ → j */
  /* 0x01f1 */ 0x01f1,
  /* 0x01f2 */ 0x01f2,
  /* 0x01f3 */ 0x01f3,
  /* 0x01f4 */ 0x0047, /* Ǵ → G */
  /* 0x01f5 */ 0x0067, /* ǵ → g */
  /* 0x01f6 */ 0x01f6,
  /* 0x01f7 */ 0x01f7,
  /* 0x01f8 */ 0x004e, /* Ǹ → N */
  /* 0x01f9 */ 0x006e, /* ǹ → n */
  /* 0x01fa */ 0x0041, /* Ǻ → A */
  /* 0x01fb */ 0x0061, /* ǻ → a */
  /* 0x01fc */ 0x00c6, /* Ǽ → Æ */
  /* 0x01fd */ 0x00e6, /* ǽ → æ */
  /* 0x01fe */ 0x00d8, /* Ǿ → Ø */
  /* 0x01ff */ 0x00f8, /* ǿ → ø */
  /* 0x0200 */ 0x0041, /* Ȁ → A */
  /* 0x0201 */ 0x0061, /* ȁ → a */
  /* 0x0202 */ 0x0041, /* Ȃ → A */
  /* 0x0203 */ 0x0061, /* ȃ → a */
  /* 0x0204 */ 0x0045, /* Ȅ → E */
  /* 0x0205 */ 0x0065, /* ȅ → e */
  /* 0x0206 */ 0x0045, /* Ȇ → E */
  /* 0x0207 */ 0x0065, /* ȇ → e */
  /* 0x0208 */ 0x0049, /* Ȉ → I */
  /* 0x0209 */ 0x0069, /* ȉ → i */
  /* 0x020a */ 0x0049, /* Ȋ → I */
  /* 0x020b */ 0x0069, /* ȋ → i */
  /* 0x020c */ 0x004f, /* Ȍ → O */
  /* 0x020d */ 0x006f, /* ȍ → o */
  /* 0x020e */ 0x004f, /* Ȏ → O */
  /* 0x020f */ 0x006f, /* ȏ → o */
  /* 0x0210 */ 0x0052, /* Ȑ → R */
  /* 0x0211 */ 0x0072, /* ȑ → r */
  /* 0x0212 */ 0x0052, /* Ȓ → R */
  /* 0x0213 */ 0x0072, /* ȓ → r */
  /* 0x0214 */ 0x0055, /* Ȕ → U */
  /* 0x0215 */ 0x0075, /* ȕ → u */
  /* 0x0216 */ 0x0055, /* Ȗ → U */
  /* 0x0217 */ 0x0075, /* ȗ → u */
  /* 0x0218 */ 0x0053, /* Ș → S */
  /* 0x0219 */ 0x0073, /* ș → s */
  /* 0x021a */ 0x0054, /* Ț → T */
  /* 0x021b */ 0x0074, /* ț → t */
  /* 0x021c */ 0x021c,
  /* 0x021d */ 0x021d,
  /* 0x021e */ 0x0048, /* Ȟ → H */
  /* 0x021f */ 0x0068, /* ȟ → h */
  /* 0x0220 */ 0x0220,
  /* 0x0221 */ 0x0064, /* ȡ → d */
  /* 0x0222 */ 0x0222,
  /* 0x0223 */ 0x0223,
  /* 0x0224 */ 0x005a, /* Ȥ → Z */
  /* 0x0225 */ 0x007a, /* ȥ → z */
  /* 0x0226 */ 0x0041, /* Ȧ → A */
  /* 0x0227 */ 0x0061, /* ȧ → a */
  /* 0x0228 */ 0x0045, /* Ȩ → E */
  /* 0x0229 */ 0x0065, /* ȩ → e */
  /* 0x022a */ 0x004f, /* Ȫ → O */
  /* 0x022b */ 0x006f, /* ȫ → o */
  /* 0x022c */ 0x004f, /* Ȭ → O */
  /* 0x022d */ 0x006f, /* ȭ → o */
  /* 0x022e */ 0x004f, /* Ȯ → O */
  /* 0x022f */ 0x006f, /* ȯ → o */
  /* 0x0230 */ 0x004f, /* Ȱ → O */
  /* 0x0231 */ 0x006f, /* ȱ → o */
  /* 0x0232 */ 0x0059, /* Ȳ → Y */
  /* 0x0233 */ 0x0079, /* ȳ → y */
  /* 0x0234 */ 0x006c, /* ȴ → l */
  /* 0x0235 */ 0x006e, /* ȵ → n */
  /* 0x0236 */ 0x0074, /* ȶ → t */
  /* 0x0237 */ 0x006a, /* ȷ → j */
  /* 0x0238 */ 0x0238,
  /* 0x0239 */ 0x0239,
  /* 0x023a */ 0x0041, /* Ⱥ → A */
  /* 0x023b */ 0x0043, /* Ȼ → C */
  /* 0x023c */ 0x0063, /* ȼ → c */
  /* 0x023d */ 0x004c, /* Ƚ → L */
  /* 0x023e */ 0x0054, /* Ⱦ → T */
  /* 0x023f */ 0x0073, /* ȿ → s */
  /* 0x0240 */ 0x007a, /* ɀ → z */
  /* 0x0241 */ 0x0241,
  /* 0x0242 */ 0x0242,
  /* 0x0243 */ 0x0042, /* Ƀ → B */
  /* 0x0244 */ 0x0055, /* Ʉ → U */
  /* 0x0245 */ 0x0245,
  /* 0x0246 */ 0x0045, /* Ɇ → E */
  /* 0x0247 */ 0x0065, /* ɇ → e */
  /* 0x0248 */ 0x004a, /* Ɉ → J */
  /* 0x0249 */ 0x006a, /* ɉ → j */
  /* 0x024a */ 0x024a,
  /* 0x024b */ 0x024b,
  /* 0x024c */ 0x0052, /* Ɍ → R */
  /* 0x024d */ 0x0072, /* ɍ → r */
  /* 0x024e */ 0x0059, /* Ɏ → Y */
  /* 0x024f */ 0x0079, /* ɏ → y */
  /* 0x0250 */ 0x0250,
  /* 0x0251 */ 0x0251,
  /* 0x0252 */ 0x0252,
  /* 0x0253 */ 0x0062, /* ɓ → b */
  /* 0x0254 */ 0x0254,
  /* 0x0255 */ 0x0063, /* ɕ → c */
  /* 0x0256 */ 0x0064, /* ɖ → d */
  /* 0x0257 */ 0x0064, /* ɗ → d */
  /* 0x0258 */ 0x0258,
  /* 0x0259 */ 0x0259,
  /* 0x025a */ 0x025a,
  /* 0x025b */ 0x0065, /* ɛ → e */
  /* 0x025c */ 0x025c,
  /* 0x025d */ 0x025d,
  /* 0x025e */ 0x025e,
  /* 0x025f */ 0x006a, /* ɟ → j */
  /* 0x0260 */ 0x0067, /* ɠ → g */
  /* 0x0261 */ 0x0067, /* ɡ → g */
  /* 0x0262 */ 0x0047, /* ɢ → G */
  /* 0x0263 */ 0x0263,
  /* 0x0264 */ 0x0264,
  /* 0x0265 */ 0x0265,
  /* 0x0266 */ 0x0068, /* ɦ → h */
  /* 0x0267 */ 0x0068, /* ɧ → h */
  /* 0x0268 */ 0x0069, /* ɨ → i */
  /* 0x0269 */ 0x0269,
  /* 0x026a */ 0x0049, /* ɪ → I */
  /* 0x026b */ 0x006c, /* ɫ → l */
  /* 0x026c */ 0x006c, /* ɬ → l */
  /* 0x026d */ 0x006c, /* ɭ → l */
  /* 0x026e */ 0x026e,
  /* 0x026f */ 0x026f,
  /* 0x0270 */ 0x0270,
  /* 0x0271 */ 0x006d, /* ɱ → m */
  /* 0x0272 */ 0x006e, /* ɲ → n */
  /* 0x0273 */ 0x006e, /* ɳ → n */
  /* 0x0274 */ 0x004e, /* ɴ → N */
  /* 0x0275 */ 0x0275,
  /* 0x0276 */ 0x0276,
  /* 0x0277 */ 0x0277,
  /* 0x0278 */ 0x0278,
  /* 0x0279 */ 0x0279,
  /* 0x027a */ 0x027a,
  /* 0x027b */ 0x027b,
  /* 0x027c */ 0x0072, /* ɼ → r */
  /* 0x027d */ 0x0072, /* ɽ → r */
  /* 0x027e */ 0x0072, /* ɾ → r */
  /* 0x027f */ 0x027f,
  /* 0x0280 */ 0x0052, /* ʀ → R */
  /* 0x0281 */ 0x0281,
  /* 0x0282 */ 0x0073, /* ʂ → s */
  /* 0x0283 */ 0x0283,
  /* 0x0284 */ 0x0284,
  /* 0x0285 */ 0x0285,
  /* 0x0286 */ 0x0286,
  /* 0x0287 */ 0x0287,
  /* 0x0288 */ 0x0074, /* ʈ → t */
  /* 0x0289 */ 0x0075, /* ʉ → u */
  /* 0x028a */ 0x028a,
  /* 0x028b */ 0x0076, /* ʋ → v */
  /* 0x028c */ 0x028c,
  /* 0x028d */ 0x028d,
  /* 0x028e */ 0x028e,
  /* 0x028f */ 0x0059, /* ʏ → Y */
  /* 0x0290 */ 0x007a, /* ʐ → z */
  /* 0x0291 */ 0x007a, /* ʑ → z */
  /* 0x0292 */ 0x0292,
  /* 0x0293 */ 0x0293,
  /* 0x0294 */ 0x0294,
  /* 0x0295 */ 0x0295,
  /* 0x0296 */ 0x0296,
  /* 0x0297 */ 0x0297,
  /* 0x0298 */ 0x0298,
  /* 0x0299 */ 0x0042, /* ʙ → B */
  /* 0x029a */ 0x029a,
  /* 0x029b */ 0x0047, /* ʛ → G */
  /* 0x029c */ 0x0048, /* ʜ → H */
  /* 0x029d */ 0x006a, /* ʝ → j */
  /* 0x029e */ 0x029e,
  /* 0x029f */ 0x004c, /* ʟ → L */
  /* 0x02a0 */ 0x0071, /* ʠ → q */
  /* 0x02a1 */ 0x02a1,
  /* 0x02a2 */ 0x02a2,
  /* 0x02a3 */ 0x02a3,
  /* 0x02a4 */ 0x02a4,
  /* 0x02a5 */ 0x02a5,
  /* 0x02a6 */ 0x02a6,
  /* 0x02a7 */ 0x02a7,
  /* 0x02a8 */ 0x02a8,
  /* 0x02a9 */ 0x02a9,
  /* 0x02aa */ 0x02aa,
  /* 0x02ab */ 0x02ab,
  /* 0x02ac */ 0x02ac,
  /* 0x02ad */ 0x02ad,
  /* 0x02ae */ 0x02ae,
  /* 0x02af */ 0x02af,
  /* 0x02b0 */ 0x02b0,
  /* 0x02b1 */ 0x02b1,
  /* 0x02b2 */ 0x02b2,
  /* 0x02b3 */ 0x02b3,
  /* 0x02b4 */ 0x02b4,
  /* 0x02b5 */ 0x02b5,
  /* 0x02b6 */ 0x02b6,
  /* 0x02b7 */ 0x02b7,
  /* 0x02b8 */ 0x02b8,
  /* 0x02b9 */ 0x0027, /* ʹ → ' */
  /* 0x02ba */ 0x0022, /* ʺ → " */
  /* 0x02bb */ 0x0027, /* ʻ → ' */
  /* 0x02bc */ 0x0027, /* ʼ → ' */
  /* 0x02bd */ 0x0027, /* ʽ → ' */
  /* 0x02be */ 0x02be,
  /* 0x02bf */ 0x02bf,
  /* 0x02c0 */ 0x02c0,
  /* 0x02c1 */ 0x02c1,
  /* 0x02c2 */ 0x003c, /* ˂ → < */
  /* 0x02c3 */ 0x003e, /* ˃ → > */
  /* 0x02c4 */ 0x005e, /* ˄ → ^ */
  /* 0x02c5 */ 0x02c5,
  /* 0x02c6 */ 0x005e, /* ˆ → ^ */
  /* 0x02c7 */ 0x02c7,
  /* 0x02c8 */ 0x0027, /* ˈ → ' */
  /* 0x02c9 */ 0x02c9,
  /* 0x02ca */ 0x02ca,
  /* 0x02cb */ 0x0060, /* ˋ → ` */
  /* 0x02cc */ 0x02cc,
  /* 0x02cd */ 0x02cd,
  /* 0x02ce */ 0x02ce,
  /* 0x02cf */ 0x02cf,
  /* 0x02d0 */ 0x003a, /* ː → : */
  /* 0x02d1 */ 0x02d1,
  /* 0x02d2 */ 0x02d2,
  /* 0x02d3 */ 0x02d3,
  /* 0x02d4 */ 0x02d4,
  /* 0x02d5 */ 0x02d5,
  /* 0x02d6 */ 0x002b, /* ˖ → + */
  /* 0x02d7 */ 0x002d, /* ˗ → - */
  /* 0x02d8 */ 0x02d8,
  /* 0x02d9 */ 0x02d9,
  /* 0x02da */ 0x02da,
  /* 0x02db */ 0x02db,
  /* 0x02dc */ 0x007e, /* ˜ → ~ */
  /* 0x0385 */ 0x00a8, /* ΅ → ¨ */
  /* 0x0386 */ 0x0391, /* Ά → Α */
  /* 0x0387 */ 0x0387,
  /* 0x0388 */ 0x0395, /* Έ → Ε */
  /* 0x0389 */ 0x0397, /* Ή → Η */
  /* 0x038a */ 0x0399, /* Ί → Ι */
  /* 0x038b */ 0x038b,
  /* 0x038c */ 0x039f, /* Ό → Ο */
  /* 0x038d */ 0x038d,
  /* 0x038e */ 0x03a5, /* Ύ → Υ */
  /* 0x038f */ 0x03a9, /* Ώ → Ω */
  /* 0x0390 */ 0x03b9, /* ΐ → ι */
  /* 0x0391 */ 0x0391,
  /* 0x0392 */ 0x0392,
  /* 0x0393 */ 0x0393,
  /* 0x0394 */ 0x0394,
  /* 0x0395 */ 0x0395,
  /* 0x0396 */ 0x0396,
  /* 0x0397 */ 0x0397,
  /* 0x0398 */ 0x0398,
  /* 0x0399 */ 0x0399,
  /* 0x039a */ 0x039a,
  /* 0x039b */ 0x039b,
  /* 0x039c */ 0x039c,
  /* 0x039d */ 0x039d,
  /* 0x039e */ 0x039e,
  /* 0x039f */ 0x039f,
  /* 0x03a0 */ 0x03a0,
  /* 0x03a1 */ 0x03a1,
  /* 0x03a2 */ 0x03a2,
  /* 0x03a3 */ 0x03a3,
  /* 0x03a4 */ 0x03a4,
  /* 0x03a5 */ 0x03a5,
  /* 0x03a6 */ 0x03a6,
  /* 0x03a7 */ 0x03a7,
  /* 0x03a8 */ 0x03a8,
  /* 0x03a9 */ 0x03a9,
  /* 0x03aa */ 0x0399, /* Ϊ → Ι */
  /* 0x03ab */ 0x03a5, /* Ϋ → Υ */
  /* 0x03ac */ 0x03b1, /* ά → α */
  /* 0x03ad */ 0x03b5, /* έ → ε */
  /* 0x03ae */ 0x03b7, /* ή → η */
  /* 0x03af */ 0x03b9, /* ί → ι */
  /* 0x03b0 */ 0x03c5, /* ΰ → υ */
  /* 0x03b1 */ 0x03b1,
  /* 0x03b2 */ 0x03b2,
  /* 0x03b3 */ 0x03b3,
  /* 0x03b4 */ 0x03b4,
  /* 0x03b5 */ 0x03b5,
  /* 0x03b6 */ 0x03b6,
  /* 0x03b7 */ 0x03b7,
  /* 0x03b8 */ 0x03b8,
  /* 0x03b9 */ 0x03b9,
  /* 0x03ba */ 0x03ba,
  /* 0x03bb */ 0x03bb,
  /* 0x03bc */ 0x03bc,
  /* 0x03bd */ 0x03bd,
  /* 0x03be */ 0x03be,
  /* 0x03bf */ 0x03bf,
  /* 0x03c0 */ 0x03c0,
  /* 0x03c1 */ 0x03c1,
  /* 0x03c2 */ 0x03c2,
  /* 0x03c3 */ 0x03c3,
  /* 0x03c4 */ 0x03c4,
  /* 0x03c5 */ 0x03c5,
  /* 0x03c6 */ 0x03c6,
  /* 0x03c7 */ 0x03c7,
  /* 0x03c8 */ 0x03c8,
  /* 0x03c9 */ 0x03c9,
  /* 0x03ca */ 0x03b9, /* ϊ → ι */
  /* 0x03cb */ 0x03c5, /* ϋ → υ */
  /* 0x03cc */ 0x03bf, /* ό → ο */
  /* 0x03cd */ 0x03c5, /* ύ → υ */
  /* 0x03ce */ 0x03c9, /* ώ → ω */
  /* 0x03cf */ 0x03cf,
  /* 0x03d0 */ 0x03d0,
  /* 0x03d1 */ 0x03d1,
  /* 0x03d2 */ 0x03d2,
  /* 0x03d3 */ 0x03d2, /* ϓ → ϒ */
  /* 0x03d4 */ 0x03d2, /* ϔ → ϒ */
  /* 0x0400 */ 0x0415, /* Ѐ → Е */
  /* 0x0401 */ 0x0415, /* Ё → Е */
  /* 0x0402 */ 0x0402,
  /* 0x0403 */ 0x0413, /* Ѓ → Г */
  /* 0x0404 */ 0x0404,
  /* 0x0405 */ 0x0405,
  /* 0x0406 */ 0x0406,
  /* 0x0407 */ 0x0406, /* Ї → І */
  /* 0x0408 */ 0x0408,
  /* 0x0409 */ 0x0409,
  /* 0x040a */ 0x040a,
  /* 0x040b */ 0x040b,
  /* 0x040c */ 0x041a, /* Ќ → К */
  /* 0x040d */ 0x0418, /* Ѝ → И */
  /* 0x040e */ 0x0423, /* Ў → У */
  /* 0x040f */ 0x040f,
  /* 0x0410 */ 0x0410,
  /* 0x0411 */ 0x0411,
  /* 0x0412 */ 0x0412,
  /* 0x0413 */ 0x0413,
  /* 0x0414 */ 0x0414,
  /* 0x0415 */ 0x0415,
  /* 0x0416 */ 0x0416,
  /* 0x0417 */ 0x0417,
  /* 0x0418 */ 0x0418,
  /* 0x0419 */ 0x0418, /* Й → И */
  /* 0x041a */ 0x041a,
  /* 0x041b */ 0x041b,
  /* 0x041c */ 0x041c,
  /* 0x041d */ 0x041d,
  /* 0x041e */ 0x041e,
  /* 0x041f */ 0x041f,
  /* 0x0420 */ 0x0420,
  /* 0x0421 */ 0x0421,
  /* 0x0422 */ 0x0422,
  /* 0x0423 */ 0x0423,
  /* 0x0424 */ 0x0424,
  /* 0x0425 */ 0x0425,
  /* 0x0426 */ 0x0426,
  /* 0x0427 */ 0x0427,
  /* 0x0428 */ 0x0428,
  /* 0x0429 */ 0x0429,
  /* 0x042a */ 0x042a,
  /* 0x042b */ 0x042b,
  /* 0x042c */ 0x042c,
  /* 0x042d */ 0x042d,
  /* 0x042e */ 0x042e,
  /* 0x042f */ 0x042f,
  /* 0x0430 */ 0x0430,
  /* 0x0431 */ 0x0431,
  /* 0x0432 */ 0x0432,
  /* 0x0433 */ 0x0433,
  /* 0x0434 */ 0x0434,
  /* 0x0435 */ 0x0435,
  /* 0x0436 */ 0x0436,
  /* 0x0437 */ 0x0437,
  /* 0x0438 */ 0x0438,
  /* 0x0439 */ 0x0438, /* й → и */
  /* 0x043a */ 0x043a,
  /* 0x043b */ 0x043b,
  /* 0x043c */ 0x043c,
  /* 0x043d */ 0x043d,
  /* 0x043e */ 0x043e,
  /* 0x043f */ 0x043f,
  /* 0x0440 */ 0x0440,
  /* 0x0441 */ 0x0441,
  /* 0x0442 */ 0x0442,
  /* 0x0443 */ 0x0443,
  /* 0x0444 */ 0x0444,
  /* 0x0445 */ 0x0445,
  /* 0x0446 */ 0x0446,
  /* 0x0447 */ 0x0447,
  /* 0x0448 */ 0x0448,
  /* 0x0449 */ 0x0449,
  /* 0x044a */ 0x044a,
  /* 0x044b */ 0x044b,
  /* 0x044c */ 0x044c,
  /* 0x044d */ 0x044d,
  /* 0x044e */ 0x044e,
  /* 0x044f */ 0x044f,
  /* 0x0450 */ 0x0435, /* ѐ → е */
  /* 0x0451 */ 0x0435, /* ё → е */
  /* 0x0452 */ 0x0452,
  /* 0x0453 */ 0x0433, /* ѓ → г */
  /* 0x0454 */ 0x0454,
  /* 0x0455 */ 0x0455,
  /* 0x0456 */ 0x0456,
  /* 0x0457 */ 0x0456, /* ї → і */
  /* 0x0458 */ 0x0458,
  /* 0x0459 */ 0x0459,
  /* 0x045a */ 0x045a,
  /* 0x045b */ 0x045b,
  /* 0x045c */ 0x043a, /* ќ → к */
  /* 0x045d */ 0x0438, /* ѝ → и */
  /* 0x045e */ 0x0443, /* ў → у */
  /* 0x045f */ 0x045f,
  /* 0x0460 */ 0x0460,
  /* 0x0461 */ 0x0461,
  /* 0x0462 */ 0x0462,
  /* 0x0463 */ 0x0463,
  /* 0x0464 */ 0x0464,
  /* 0x0465 */ 0x0465,
  /* 0x0466 */ 0x0466,
  /* 0x0467 */ 0x0467,
  /* 0x0468 */ 0x0468,
  /* 0x0469 */ 0x0469,
  /* 0x046a */ 0x046a,
  /* 0x046b */ 0x046b,
  /* 0x046c */ 0x046c,
  /* 0x046d */ 0x046d,
  /* 0x046e */ 0x046e,
  /* 0x046f */ 0x046f,
  /* 0x0470 */ 0x0470,
  /* 0x0471 */ 0x0471,
  /* 0x0472 */ 0x0472,
  /* 0x0473 */ 0x0473,
  /* 0x0474 */ 0x0474,
  /* 0x0475 */ 0x0475,
  /* 0x0476 */ 0x0474, /* Ѷ → Ѵ */
  /* 0x0477 */ 0x0475, /* ѷ → ѵ */
  /* 0x0478 */ 0x0478,
  /* 0x0479 */ 0x0479,
  /* 0x047a */ 0x047a,
  /* 0x047b */ 0x047b,
  /* 0x047c */ 0x047c,
  /* 0x047d */ 0x047d,
  /* 0x047e */ 0x047e,
  /* 0x047f */ 0x047f,
  /* 0x0480 */ 0x0480,
  /* 0x0481 */ 0x0481,
  /* 0x0482 */ 0x0482,
  /* 0x0483 */ 0x0483,
  /* 0x0484 */ 0x0484,
  /* 0x0485 */ 0x0485,
  /* 0x0486 */ 0x0486,
  /* 0x0487 */ 0x0487,
  /* 0x0488 */ 0x0488,
  /* 0x0489 */ 0x0489,
  /* 0x048a */ 0x048a,
  /* 0x048b */ 0x048b,
  /* 0x048c */ 0x048c,
  /* 0x048d */ 0x048d,
  /* 0x048e */ 0x048e,
  /* 0x048f */ 0x048f,
  /* 0x0490 */ 0x0490,
  /* 0x0491 */ 0x0491,
  /* 0x0492 */ 0x0492,
  /* 0x0493 */ 0x0493,
  /* 0x0494 */ 0x0494,
  /* 0x0495 */ 0x0495,
  /* 0x0496 */ 0x0496,
  /* 0x0497 */ 0x0497,
  /* 0x0498 */ 0x0498,
  /* 0x0499 */ 0x0499,
  /* 0x049a */ 0x049a,
  /* 0x049b */ 0x049b,
  /* 0x049c */ 0x049c,
  /* 0x049d */ 0x049d,
  /* 0x049e */ 0x049e,
  /* 0x049f */ 0x049f,
  /* 0x04a0 */ 0x04a0,
  /* 0x04a1 */ 0x04a1,
  /* 0x04a2 */ 0x04a2,
  /* 0x04a3 */ 0x04a3,
  /* 0x04a4 */ 0x04a4,
  /* 0x04a5 */ 0x04a5,
  /* 0x04a6 */ 0x04a6,
  /* 0x04a7 */ 0x04a7,
  /* 0x04a8 */ 0x04a8,
  /* 0x04a9 */ 0x04a9,
  /* 0x04aa */ 0x04aa,
  /* 0x04ab */ 0x04ab,
  /* 0x04ac */ 0x04ac,
  /* 0x04ad */ 0x04ad,
  /* 0x04ae */ 0x04ae,
  /* 0x04af */ 0x04af,
  /* 0x04b0 */ 0x04b0,
  /* 0x04b1 */ 0x04b1,
  /* 0x04b2 */ 0x04b2,
  /* 0x04b3 */ 0x04b3,
  /* 0x04b4 */ 0x04b4,
  /* 0x04b5 */ 0x04b5,
  /* 0x04b6 */ 0x04b6,
  /* 0x04b7 */ 0x04b7,
  /* 0x04b8 */ 0x04b8,
  /* 0x04b9 */ 0x04b9,
  /* 0x04ba */ 0x04ba,
  /* 0x04bb */ 0x04bb,
  /* 0x04bc */ 0x04bc,
  /* 0x04bd */ 0x04bd,
  /* 0x04be */ 0x04be,
  /* 0x04bf */ 0x04bf,
  /* 0x04c0 */ 0x04c0,
  /* 0x04c1 */ 0x0416, /* Ӂ → Ж */
  /* 0x04c2 */ 0x0436, /* ӂ → ж */
  /* 0x04c3 */ 0x04c3,
  /* 0x04c4 */ 0x04c4,
  /* 0x04c5 */ 0x04c5,
  /* 0x04c6 */ 0x04c6,
  /* 0x04c7 */ 0x04c7,
  /* 0x04c8 */ 0x04c8,
  /* 0x04c9 */ 0x04c9,
  /* 0x04ca */ 0x04ca,
  /* 0x04cb */ 0x04cb,
  /* 0x04cc */ 0x04cc,
  /* 0x04cd */ 0x04cd,
  /* 0x04ce */ 0x04ce,
  /* 0x04cf */ 0x04cf,
  /* 0x04d0 */ 0x0410, /* Ӑ → А */
  /* 0x04d1 */ 0x0430, /* ӑ → а */
  /* 0x04d2 */ 0x0410, /* Ӓ → А */
  /* 0x04d3 */ 0x0430, /* ӓ → а */
  /* 0x04d4 */ 0x04d4,
  /* 0x04d5 */ 0x04d5,
  /* 0x04d6 */ 0x0415, /* Ӗ → Е */
  /* 0x04d7 */ 0x0435, /* ӗ → е */
  /* 0x04d8 */ 0x04d8,
  /* 0x04d9 */ 0x04d9,
  /* 0x04da */ 0x04d8, /* Ӛ → Ә */
  /* 0x04db */ 0x04d9, /* ӛ → ә */
  /* 0x04dc */ 0x0416, /* Ӝ → Ж */
  /* 0x04dd */ 0x0436, /* ӝ → ж */
  /* 0x04de */ 0x0417, /* Ӟ → З */
  /* 0x04df */ 0x0437, /* ӟ → з */
  /* 0x04e0 */ 0x04e0,
  /* 0x04e1 */ 0x04e1,
  /* 0x04e2 */ 0x0418, /* Ӣ → И */
  /* 0x04e3 */ 0x0438, /* ӣ → и */
  /* 0x04e4 */ 0x0418, /* Ӥ → И */
  /* 0x04e5 */ 0x0438, /* ӥ → и */
  /* 0x04e6 */ 0x041e, /* Ӧ → О */
  /* 0x04e7 */ 0x043e, /* ӧ → о */
  /* 0x04e8 */ 0x04e8,
  /* 0x04e9 */ 0x04e9,
  /* 0x04ea */ 0x04e8, /* Ӫ → Ө */
  /* 0x04eb */ 0x04e9, /* ӫ → ө */
  /* 0x04ec */ 0x042d, /* Ӭ → Э */
  /* 0x04ed */ 0x044d, /* ӭ → э */
  /* 0x04ee */ 0x0423, /* Ӯ → У */
  /* 0x04ef */ 0x0443, /* ӯ → у */
  /* 0x04f0 */ 0x0423, /* Ӱ → У */
  /* 0x04f1 */ 0x0443, /* ӱ → у */
  /* 0x04f2 */ 0x0423, /* Ӳ → У */
  /* 0x04f3 */ 0x0443, /* ӳ → у */
  /* 0x04f4 */ 0x0427, /* Ӵ → Ч */
  /* 0x04f5 */ 0x0447, /* ӵ → ч */
  /* 0x04f6 */ 0x04f6,
  /* 0x04f7 */ 0x04f7,
  /* 0x04f8 */ 0x042b, /* Ӹ → Ы */
  /* 0x04f9 */ 0x044b, /* ӹ → ы */
  /* 0x0622 */ 0x0627, /* آ → ا */
  /* 0x0623 */ 0x0627, /* أ → ا */
  /* 0x0624 */ 0x0648, /* ؤ → و */
  /* 0x0625 */ 0x0627, /* إ → ا */
  /* 0x0626 */ 0x064a, /* ئ → ي */
  /* 0x0627 */ 0x0627,
  /* 0x0628 */ 0x0628,
  /* 0x0629 */ 0x0629,
  /* 0x062a */ 0x062a,
  /* 0x062b */ 0x062b,
  /* 0x062c */ 0x062c,
  /* 0x062d */ 0x062d,
  /* 0x062e */ 0x062e,
  /* 0x062f */ 0x062f,
  /* 0x0630 */ 0x0630,
  /* 0x0631 */ 0x0631,
  /* 0x0632 */ 0x0632,
  /* 0x0633 */ 0x0633,
  /* 0x0634 */ 0x0634,
  /* 0x0635 */ 0x0635,
  /* 0x0636 */ 0x0636,
  /* 0x0637 */ 0x0637,
  /* 0x0638 */ 0x0638,
  /* 0x0639 */ 0x0639,
  /* 0x063a */ 0x063a,
  /* 0x063b */ 0x063b,
  /* 0x063c */ 0x063c,
  /* 0x063d */ 0x063d,
  /* 0x063e */ 0x063e,
  /* 0x063f */ 0x063f,
  /* 0x0640 */ 0x0640,
  /* 0x0641 */ 0x0641,
  /* 0x0642 */ 0x0642,
  /* 0x0643 */ 0x0643,
  /* 0x0644 */ 0x0644,
  /* 0x0645 */ 0x0645,
  /* 0x0646 */ 0x0646,
  /* 0x0647 */ 0x0647,
  /* 0x0648 */ 0x0648,
  /* 0x0649 */ 0x0649,
  /* 0x064a */ 0x064a,
  /* 0x064b */ 0x064b,
  /* 0x064c */ 0x064c,
  /* 0x064d */ 0x064d,
  /* 0x064e */ 0x064e,
  /* 0x064f */ 0x064f,
  /* 0x0650 */ 0x0650,
  /* 0x0651 */ 0x0651,
  /* 0x0652 */ 0x0652,
  /* 0x0653 */ 0x0653,
  /* 0x0654 */ 0x0654,
  /* 0x0655 */ 0x0655,
  /* 0x0656 */ 0x0656,
  /* 0x0657 */ 0x0657,
  /* 0x0658 */ 0x0658,
  /* 0x0659 */ 0x0659,
  /* 0x065a */ 0x065a,
  /* 0x065b */ 0x065b,
  /* 0x065c */ 0x065c,
  /* 0x065d */ 0x065d,
  /* 0x065e */ 0x065e,
  /* 0x065f */ 0x065f,
  /* 0x0660 */ 0x0660,
  /* 0x0661 */ 0x0661,
  /* 0x0662 */ 0x0662,
  /* 0x0663 */ 0x0663,
  /* 0x0664 */ 0x0664,
  /* 0x0665 */ 0x0665,
  /* 0x0666 */ 0x0666,
  /* 0x0667 */ 0x0667,
  /* 0x0668 */ 0x0668,
  /* 0x0669 */ 0x0669,
  /* 0x066a */ 0x066a,
  /* 0x066b */ 0x066b,
  /* 0x066c */ 0x066c,
  /* 0x066d */ 0x066d,
  /* 0x066e */ 0x066e,
  /* 0x066f */ 0x066f,
  /* 0x0670 */ 0x0670,
  /* 0x0671 */ 0x0671,
  /* 0x0672 */ 0x0672,
  /* 0x0673 */ 0x0673,
  /* 0x0674 */ 0x0674,
  /* 0x0675 */ 0x0675,
  /* 0x0676 */ 0x0676,
  /* 0x0677 */ 0x0677,
  /* 0x0678 */ 0x0678,
  /* 0x0679 */ 0x0679,
  /* 0x067a */ 0x067a,
  /* 0x067b */ 0x067b,
  /* 0x067c */ 0x067c,
  /* 0x067d */ 0x067d,
  /* 0x067e */ 0x067e,
  /* 0x067f */ 0x067f,
  /* 0x0680 */ 0x0680,
  /* 0x0681 */ 0x0681,
  /* 0x0682 */ 0x0682,
  /* 0x0683 */ 0x0683,
  /* 0x0684 */ 0x0684,
  /* 0x0685 */ 0x0685,
  /* 0x0686 */ 0x0686,
  /* 0x0687 */ 0x0687,
  /* 0x0688 */ 0x0688,
  /* 0x0689 */ 0x0689,
  /* 0x068a */ 0x068a,
  /* 0x068b */ 0x068b,
  /* 0x068c */ 0x068c,
  /* 0x068d */ 0x068d,
  /* 0x068e */ 0x068e,
  /* 0x068f */ 0x068f,
  /* 0x0690 */ 0x0690,
  /* 0x0691 */ 0x0691,
  /* 0x0692 */ 0x0692,
  /* 0x0693 */ 0x0693,
  /* 0x0694 */ 0x0694,
  /* 0x0695 */ 0x0695,
  /* 0x0696 */ 0x0696,
  /* 0x0697 */ 0x0697,
  /* 0x0698 */ 0x0698,
  /* 0x0699 */ 0x0699,
  /* 0x069a */ 0x069a,
  /* 0x069b */ 0x069b,
  /* 0x069c */ 0x069c,
  /* 0x069d */ 0x069d,
  /* 0x069e */ 0x069e,
  /* 0x069f */ 0x069f,
  /* 0x06a0 */ 0x06a0,
  /* 0x06a1 */ 0x06a1,
  /* 0x06a2 */ 0x06a2,
  /* 0x06a3 */ 0x06a3,
  /* 0x06a4 */ 0x06a4,
  /* 0x06a5 */ 0x06a5,
  /* 0x06a6 */ 0x06a6,
  /* 0x06a7 */ 0x06a7,
  /* 0x06a8 */ 0x06a8,
  /* 0x06a9 */ 0x06a9,
  /* 0x06aa */ 0x06aa,
  /* 0x06ab */ 0x06ab,
  /* 0x06ac */ 0x06ac,
  /* 0x06ad */ 0x06ad,
  /* 0x06ae */ 0x06ae,
  /* 0x06af */ 0x06af,
  /* 0x06b0 */ 0x06b0,
  /* 0x06b1 */ 0x06b1,
  /* 0x06b2 */ 0x06b2,
  /* 0x06b3 */ 0x06b3,
  /* 0x06b4 */ 0x06b4,
  /* 0x06b5 */ 0x06b5,
  /* 0x06b6 */ 0x06b6,
  /* 0x06b7 */ 0x06b7,
  /* 0x06b8 */ 0x06b8,
  /* 0x06b9 */ 0x06b9,
  /* 0x06ba */ 0x06ba,
  /* 0x06bb */ 0x06bb,
  /* 0x06bc */ 0x06bc,
  /* 0x06bd */ 0x06bd,
  /* 0x06be */ 0x06be,
  /* 0x06bf */ 0x06bf,
  /* 0x06c0 */ 0x06d5, /* ۀ → ە */
  /* 0x06c1 */ 0x06c1,
  /* 0x06c2 */ 0x06c1, /* ۂ → ہ */
  /* 0x06c3 */ 0x06c3,
  /* 0x06c4 */ 0x06c4,
  /* 0x06c5 */ 0x06c5,
  /* 0x06c6 */ 0x06c6,
  /* 0x06c7 */ 0x06c7,
  /* 0x06c8 */ 0x06c8,
  /* 0x06c9 */ 0x06c9,
  /* 0x06ca */ 0x06ca,
  /* 0x06cb */ 0x06cb,
  /* 0x06cc */ 0x06cc,
  /* 0x06cd */ 0x06cd,
  /* 0x06ce */ 0x06ce,
  /* 0x06cf */ 0x06cf,
  /* 0x06d0 */ 0x06d0,
  /* 0x06d1 */ 0x06d1,
  /* 0x06d2 */ 0x06d2,
  /* 0x06d3 */ 0x06d2, /* ۓ → ے */
  /* 0x0929 */ 0x0928, /* ऩ → न */
  /* 0x092a */ 0x092a,
  /* 0x092b */ 0x092b,
  /* 0x092c */ 0x092c,
  /* 0x092d */ 0x092d,
  /* 0x092e */ 0x092e,
  /* 0x092f */ 0x092f,
  /* 0x0930 */ 0x0930,
  /* 0x0931 */ 0x0930, /* ऱ → र */
  /* 0x0932 */ 0x0932,
  /* 0x0933 */ 0x0933,
  /* 0x0934 */ 0x0933, /* ऴ → ळ */
  /* 0x0935 */ 0x0935,
  /* 0x0936 */ 0x0936,
  /* 0x0937 */ 0x0937,
  /* 0x0938 */ 0x0938,
  /* 0x0939 */ 0x0939,
  /* 0x093a */ 0x093a,
  /* 0x093b */ 0x093b,
  /* 0x093c */ 0x093c,
  /* 0x093d */ 0x093d,
  /* 0x093e */ 0x093e,
  /* 0x093f */ 0x093f,
  /* 0x0940 */ 0x0940,
  /* 0x0941 */ 0x0941,
  /* 0x0942 */ 0x0942,
  /* 0x0943 */ 0x0943,
  /* 0x0944 */ 0x0944,
  /* 0x0945 */ 0x0945,
  /* 0x0946 */ 0x0946,
  /* 0x0947 */ 0x0947,
  /* 0x0948 */ 0x0948,
  /* 0x0949 */ 0x0949,
  /* 0x094a */ 0x094a,
  /* 0x094b */ 0x094b,
  /* 0x094c */ 0x094c,
  /* 0x094d */ 0x094d,
  /* 0x094e */ 0x094e,
  /* 0x094f */ 0x094f,
  /* 0x0950 */ 0x0950,
  /* 0x0951 */ 0x0951,
  /* 0x0952 */ 0x0952,
  /* 0x0953 */ 0x0953,
  /* 0x0954 */ 0x0954,
  /* 0x0955 */ 0x0955,
  /* 0x0956 */ 0x0956,
  /* 0x0957 */ 0x0957,
  /* 0x0958 */ 0x0915, /* क़ → क */
  /* 0x0959 */ 0x0916, /* ख़ → ख */
  /* 0x095a */ 0x0917, /* ग़ → ग */
  /* 0x095b */ 0x091c, /* ज़ → ज */
  /* 0x095c */ 0x0921, /* ड़ → ड */
  /* 0x095d */ 0x0922, /* ढ़ → ढ */
  /* 0x095e */ 0x092b, /* फ़ → फ */
  /* 0x095f */ 0x092f, /* य़ → य */
  /* 0x0960 */ 0x0960,
  /* 0x0961 */ 0x0961,
  /* 0x0962 */ 0x0962,
  /* 0x0963 */ 0x0963,
  /* 0x0964 */ 0x0964,
  /* 0x0965 */ 0x0965,
  /* 0x0966 */ 0x0966,
  /* 0x0967 */ 0x0967,
  /* 0x0968 */ 0x0968,
  /* 0x0969 */ 0x0969,
  /* 0x096a */ 0x096a,
  /* 0x096b */ 0x096b,
  /* 0x096c */ 0x096c,
  /* 0x096d */ 0x096d,
  /* 0x096e */ 0x096e,
  /* 0x096f */ 0x096f,
  /* 0x0970 */ 0x0970,
  /* 0x0971 */ 0x0971,
  /* 0x0972 */ 0x0972,
  /* 0x0973 */ 0x0973,
  /* 0x0974 */ 0x0974,
  /* 0x0975 */ 0x0975,
  /* 0x0976 */ 0x0976,
  /* 0x0977 */ 0x0977,
  /* 0x0978 */ 0x0978,
  /* 0x0979 */ 0x0979,
  /* 0x097a */ 0x097a,
  /* 0x097b */ 0x097b,
  /* 0x097c */ 0x097c,
  /* 0x097d */ 0x097d,
  /* 0x097e */ 0x097e,
  /* 0x097f */ 0x097f,
  /* 0x0980 */ 0x0980,
  /* 0x0981 */ 0x0981,
  /* 0x0982 */ 0x0982,
  /* 0x0983 */ 0x0983,
  /* 0x0984 */ 0x0984,
  /* 0x0985 */ 0x0985,
  /* 0x0986 */ 0x0986,
  /* 0x0987 */ 0x0987,
  /* 0x0988 */ 0x0988,
  /* 0x0989 */ 0x0989,
  /* 0x098a */ 0x098a,
  /* 0x098b */ 0x098b,
  /* 0x098c */ 0x098c,
  /* 0x098d */ 0x098d,
  /* 0x098e */ 0x098e,
  /* 0x098f */ 0x098f,
  /* 0x0990 */ 0x0990,
  /* 0x0991 */ 0x0991,
  /* 0x0992 */ 0x0992,
  /* 0x0993 */ 0x0993,
  /* 0x0994 */ 0x0994,
  /* 0x0995 */ 0x0995,
  /* 0x0996 */ 0x0996,
  /* 0x0997 */ 0x0997,
  /* 0x0998 */ 0x0998,
  /* 0x0999 */ 0x0999,
  /* 0x099a */ 0x099a,
  /* 0x099b */ 0x099b,
  /* 0x099c */ 0x099c,
  /* 0x099d */ 0x099d,
  /* 0x099e */ 0x099e,
  /* 0x099f */ 0x099f,
  /* 0x09a0 */ 0x09a0,
  /* 0x09a1 */ 0x09a1,
  /* 0x09a2 */ 0x09a2,
  /* 0x09a3 */ 0x09a3,
  /* 0x09a4 */ 0x09a4,
  /* 0x09a5 */ 0x09a5,
  /* 0x09a6 */ 0x09a6,
  /* 0x09a7 */ 0x09a7,
  /* 0x09a8 */ 0x09a8,
  /* 0x09a9 */ 0x09a9,
  /* 0x09aa */ 0x09aa,
  /* 0x09ab */ 0x09ab,
  /* 0x09ac */ 0x09ac,
  /* 0x09ad */ 0x09ad,
  /* 0x09ae */ 0x09ae,
  /* 0x09af */ 0x09af,
  /* 0x09b0 */ 0x09b0,
  /* 0x09b1 */ 0x09b1,
  /* 0x09b2 */ 0x09b2,
  /* 0x09b3 */ 0x09b3,
  /* 0x09b4 */ 0x09b4,
  /* 0x09b5 */ 0x09b5,
  /* 0x09b6 */ 0x09b6,
  /* 0x09b7 */ 0x09b7,
  /* 0x09b8 */ 0x09b8,
  /* 0x09b9 */ 0x09b9,
  /* 0x09ba */ 0x09ba,
  /* 0x09bb */ 0x09bb,
  /* 0x09bc */ 0x09bc,
  /* 0x09bd */ 0x09bd,
  /* 0x09be */ 0x09be,
  /* 0x09bf */ 0x09bf,
  /* 0x09c0 */ 0x09c0,
  /* 0x09c1 */ 0x09c1,
  /* 0x09c2 */ 0x09c2,
  /* 0x09c3 */ 0x09c3,
  /* 0x09c4 */ 0x09c4,
  /* 0x09c5 */ 0x09c5,
  /* 0x09c6 */ 0x09c6,
  /* 0x09c7 */ 0x09c7,
  /* 0x09c8 */ 0x09c8,
  /* 0x09c9 */ 0x09c9,
  /* 0x09ca */ 0x09ca,
  /* 0x09cb */ 0x09cb,
  /* 0x09cc */ 0x09cc,
  /* 0x09cd */ 0x09cd,
  /* 0x09ce */ 0x09ce,
  /* 0x09cf */ 0x09cf,
  /* 0x09d0 */ 0x09d0,
  /* 0x09d1 */ 0x09d1,
  /* 0x09d2 */ 0x09d2,
  /* 0x09d3 */ 0x09d3,
  /* 0x09d4 */ 0x09d4,
  /* 0x09d5 */ 0x09d5,
  /* 0x09d6 */ 0x09d6,
  /* 0x09d7 */ 0x09d7,
  /* 0x09d8 */ 0x09d8,
  /* 0x09d9 */ 0x09d9,
  /* 0x09da */ 0x09da,
  /* 0x09db */ 0x09db,
  /* 0x09dc */ 0x09a1, /* ড় → ড */
  /* 0x09dd */ 0x09a2, /* ঢ় → ঢ */
  /* 0x09de */ 0x09de,
  /* 0x09df */ 0x09af, /* য় → য */
  /* 0x0a33 */ 0x0a32, /* ਲ਼ → ਲ */
  /* 0x0a34 */ 0x0a34,
  /* 0x0a35 */ 0x0a35,
  /* 0x0a36 */ 0x0a38, /* ਸ਼ → ਸ */
  /* 0x0a37 */ 0x0a37,
  /* 0x0a38 */ 0x0a38,
  /* 0x0a39 */ 0x0a39,
  /* 0x0a3a */ 0x0a3a,
  /* 0x0a3b */ 0x0a3b,
  /* 0x0a3c */ 0x0a3c,
  /* 0x0a3d */ 0x0a3d,
  /* 0x0a3e */ 0x0a3e,
  /* 0x0a3f */ 0x0a3f,
  /* 0x0a40 */ 0x0a40,
  /* 0x0a41 */ 0x0a41,
  /* 0x0a42 */ 0x0a42,
  /* 0x0a43 */ 0x0a43,
  /* 0x0a44 */ 0x0a44,
  /* 0x0a45 */ 0x0a45,
  /* 0x0a46 */ 0x0a46,
  /* 0x0a47 */ 0x0a47,
  /* 0x0a48 */ 0x0a48,
  /* 0x0a49 */ 0x0a49,
  /* 0x0a4a */ 0x0a4a,
  /* 0x0a4b */ 0x0a4b,
  /* 0x0a4c */ 0x0a4c,
  /* 0x0a4d */ 0x0a4d,
  /* 0x0a4e */ 0x0a4e,
  /* 0x0a4f */ 0x0a4f,
  /* 0x0a50 */ 0x0a50,
  /* 0x0a51 */ 0x0a51,
  /* 0x0a52 */ 0x0a52,
  /* 0x0a53 */ 0x0a53,
  /* 0x0a54 */ 0x0a54,
  /* 0x0a55 */ 0x0a55,
  /* 0x0a56 */ 0x0a56,
  /* 0x0a57 */ 0x0a57,
  /* 0x0a58 */ 0x0a58,
  /* 0x0a59 */ 0x0a16, /* ਖ਼ → ਖ */
  /* 0x0a5a */ 0x0a17, /* ਗ਼ → ਗ */
  /* 0x0a5b */ 0x0a1c, /* ਜ਼ → ਜ */
  /* 0x0a5c */ 0x0a5c,
  /* 0x0a5d */ 0x0a5d,
  /* 0x0a5e */ 0x0a2b, /* ਫ਼ → ਫ */
  /* 0x0b5c */ 0x0b21, /* ଡ଼ → ଡ */
  /* 0x0b5d */ 0x0b22, /* ଢ଼ → ଢ */
  /* 0x1d00 */ 0x0041, /* ᴀ → A */
  /* 0x1d01 */ 0x1d01,
  /* 0x1d02 */ 0x1d02,
  /* 0x1d03 */ 0x0042, /* ᴃ → B */
  /* 0x1d04 */ 0x0043, /* ᴄ → C */
  /* 0x1d05 */ 0x0044, /* ᴅ → D */
  /* 0x1d06 */ 0x0044, /* ᴆ → D */
  /* 0x1d07 */ 0x0045, /* ᴇ → E */
  /* 0x1d08 */ 0x1d08,
  /* 0x1d09 */ 0x1d09,
  /* 0x1d0a */ 0x004a, /* ᴊ → J */
  /* 0x1d0b */ 0x004b, /* ᴋ → K */
  /* 0x1d0c */ 0x004c, /* ᴌ → L */
  /* 0x1d0d */ 0x004d, /* ᴍ → M */
  /* 0x1d0e */ 0x1d0e,
  /* 0x1d0f */ 0x004f, /* ᴏ → O */
  /* 0x1d10 */ 0x1d10,
  /* 0x1d11 */ 0x1d11,
  /* 0x1d12 */ 0x1d12,
  /* 0x1d13 */ 0x1d13,
  /* 0x1d14 */ 0x1d14,
  /* 0x1d15 */ 0x1d15,
  /* 0x1d16 */ 0x1d16,
  /* 0x1d17 */ 0x1d17,
  /* 0x1d18 */ 0x0050, /* ᴘ → P */
  /* 0x1d19 */ 0x1d19,
  /* 0x1d1a */ 0x1d1a,
  /* 0x1d1b */ 0x0054, /* ᴛ → T */
  /* 0x1d1c */ 0x0055, /* ᴜ → U */
  /* 0x1d1d */ 0x1d1d,
  /* 0x1d1e */ 0x1d1e,
  /* 0x1d1f */ 0x1d1f,
  /* 0x1d20 */ 0x0056, /* ᴠ → V */
  /* 0x1d21 */ 0x0057, /* ᴡ → W */
  /* 0x1d22 */ 0x005a, /* ᴢ → Z */
  /* 0x1d23 */ 0x1d23,
  /* 0x1d24 */ 0x1d24,
  /* 0x1d25 */ 0x1d25,
  /* 0x1d26 */ 0x1d26,
  /* 0x1d27 */ 0x1d27,
  /* 0x1d28 */ 0x1d28,
  /* 0x1d29 */ 0x1d29,
  /* 0x1d2a */ 0x1d2a,
  /* 0x1d2b */ 0x1d2b,
  /* 0x1d2c */ 0x1d2c,
  /* 0x1d2d */ 0x1d2d,
  /* 0x1d2e */ 0x1d2e,
  /* 0x1d2f */ 0x1d2f,
  /* 0x1d30 */ 0x1d30,
  /* 0x1d31 */ 0x1d31,
  /* 0x1d32 */ 0x1d32,
  /* 0x1d33 */ 0x1d33,
  /* 0x1d34 */ 0x1d34,
  /* 0x1d35 */ 0x1d35,
  /* 0x1d36 */ 0x1d36,
  /* 0x1d37 */ 0x1d37,
  /* 0x1d38 */ 0x1d38,
  /* 0x1d39 */ 0x1d39,
  /* 0x1d3a */ 0x1d3a,
  /* 0x1d3b */ 0x1d3b,
  /* 0x1d3c */ 0x1d3c,
  /* 0x1d3d */ 0x1d3d,
  /* 0x1d3e */ 0x1d3e,
  /* 0x1d3f */ 0x1d3f,
  /* 0x1d40 */ 0x1d40,
  /* 0x1d41 */ 0x1d41,
  /* 0x1d42 */ 0x1d42,
  /* 0x1d43 */ 0x1d43,
  /* 0x1d44 */ 0x1d44,
  /* 0x1d45 */ 0x1d45,
  /* 0x1d46 */ 0x1d46,
  /* 0x1d47 */ 0x1d47,
  /* 0x1d48 */ 0x1d48,
  /* 0x1d49 */ 0x1d49,
  /* 0x1d4a */ 0x1d4a,
  /* 0x1d4b */ 0x1d4b,
  /* 0x1d4c */ 0x1d4c,
  /* 0x1d4d */ 0x1d4d,
  /* 0x1d4e */ 0x1d4e,
  /* 0x1d4f */ 0x1d4f,
  /* 0x1d50 */ 0x1d50,
  /* 0x1d51 */ 0x1d51,
  /* 0x1d52 */ 0x1d52,
  /* 0x1d53 */ 0x1d53,
  /* 0x1d54 */ 0x1d54,
  /* 0x1d55 */ 0x1d55,
  /* 0x1d56 */ 0x1d56,
  /* 0x1d57 */ 0x1d57,
  /* 0x1d58 */ 0x1d58,
  /* 0x1d59 */ 0x1d59,
  /* 0x1d5a */ 0x1d5a,
  /* 0x1d5b */ 0x1d5b,
  /* 0x1d5c */ 0x1d5c,
  /* 0x1d5d */ 0x1d5d,
  /* 0x1d5e */ 0x1d5e,
  /* 0x1d5f */ 0x1d5f,
  /* 0x1d60 */ 0x1d60,
  /* 0x1d61 */ 0x1d61,
  /* 0x1d62 */ 0x1d62,
  /* 0x1d63 */ 0x1d63,
  /* 0x1d64 */ 0x1d64,
  /* 0x1d65 */ 0x1d65,
  /* 0x1d66 */ 0x1d66,
  /* 0x1d67 */ 0x1d67,
  /* 0x1d68 */ 0x1d68,
  /* 0x1d69 */ 0x1d69,
  /* 0x1d6a */ 0x1d6a,
  /* 0x1d6b */ 0x1d6b,
  /* 0x1d6c */ 0x0062, /* ᵬ → b */
  /* 0x1d6d */ 0x0064, /* ᵭ → d */
  /* 0x1d6e */ 0x0066, /* ᵮ → f */
  /* 0x1d6f */ 0x006d, /* ᵯ → m */
  /* 0x1d70 */ 0x006e, /* ᵰ → n */
  /* 0x1d71 */ 0x0070, /* ᵱ → p */
  /* 0x1d72 */ 0x0072, /* ᵲ → r */
  /* 0x1d73 */ 0x0072, /* ᵳ → r */
  /* 0x1d74 */ 0x0073, /* ᵴ → s */
  /* 0x1d75 */ 0x0074, /* ᵵ → t */
  /* 0x1d76 */ 0x007a, /* ᵶ → z */
  /* 0x1d77 */ 0x1d77,
  /* 0x1d78 */ 0x1d78,
  /* 0x1d79 */ 0x1d79,
  /* 0x1d7a */ 0x1d7a,
  /* 0x1d7b */ 0x0049, /* ᵻ → I */
  /* 0x1d7c */ 0x1d7c,
  /* 0x1d7d */ 0x0070, /* ᵽ → p */
  /* 0x1d7e */ 0x0055, /* ᵾ → U */
  /* 0x1d7f */ 0x1d7f,
  /* 0x1d80 */ 0x0062, /* ᶀ → b */
  /* 0x1d81 */ 0x0064, /* ᶁ → d */
  /* 0x1d82 */ 0x0066, /* ᶂ → f */
  /* 0x1d83 */ 0x0067, /* ᶃ → g */
  /* 0x1d84 */ 0x006b, /* ᶄ → k */
  /* 0x1d85 */ 0x006c, /* ᶅ → l */
  /* 0x1d86 */ 0x006d, /* ᶆ → m */
  /* 0x1d87 */ 0x006e, /* ᶇ → n */
  /* 0x1d88 */ 0x0070, /* ᶈ → p */
  /* 0x1d89 */ 0x0072, /* ᶉ → r */
  /* 0x1d8a */ 0x0073, /* ᶊ → s */
  /* 0x1d8b */ 0x1d8b,
  /* 0x1d8c */ 0x0076, /* ᶌ → v */
  /* 0x1d8d */ 0x0078, /* ᶍ → x */
  /* 0x1d8e */ 0x007a, /* ᶎ → z */
  /* 0x1d8f */ 0x0061, /* ᶏ → a */
  /* 0x1d90 */ 0x1d90,
  /* 0x1d91 */ 0x0064, /* ᶑ → d */
  /* 0x1d92 */ 0x0065, /* ᶒ → e */
  /* 0x1d93 */ 0x0065, /* ᶓ → e */
  /* 0x1d94 */ 0x1d94,
  /* 0x1d95 */ 0x1d95,
  /* 0x1d96 */ 0x0069, /* ᶖ → i */
  /* 0x1d97 */ 0x1d97,
  /* 0x1d98 */ 0x1d98,
  /* 0x1d99 */ 0x0075, /* ᶙ → u */
  /* 0x1e00 */ 0x0041, /* Ḁ → A */
  /* 0x1e01 */ 0x0061, /* ḁ → a */
  /* 0x1e02 */ 0x0042, /* Ḃ → B */
  /* 0x1e03 */ 0x0062, /* ḃ → b */
  /* 0x1e04 */ 0x0042, /* Ḅ → B */
  /* 0x1e05 */ 0x0062, /* ḅ → b */
  /* 0x1e06 */ 0x0042, /* Ḇ → B */
  /* 0x1e07 */ 0x0062, /* ḇ → b */
  /* 0x1e08 */ 0x0043, /* Ḉ → C */
  /* 0x1e09 */ 0x0063, /* ḉ → c */
  /* 0x1e0a */ 0x0044, /* Ḋ → D */
  /* 0x1e0b */ 0x0064, /* ḋ → d */
  /* 0x1e0c */ 0x0044, /* Ḍ → D */
  /* 0x1e0d */ 0x0064, /* ḍ → d */
  /* 0x1e0e */ 0x0044, /* Ḏ → D */
  /* 0x1e0f */ 0x0064, /* ḏ → d */
  /* 0x1e10 */ 0x0044, /* Ḑ → D */
  /* 0x1e11 */ 0x0064, /* ḑ → d */
  /* 0x1e12 */ 0x0044, /* Ḓ → D */
  /* 0x1e13 */ 0x0064, /* ḓ → d */
  /* 0x1e14 */ 0x0045, /* Ḕ → E */
  /* 0x1e15 */ 0x0065, /* ḕ → e */
  /* 0x1e16 */ 0x0045, /* Ḗ → E */
  /* 0x1e17 */ 0x0065, /* ḗ → e */
  /* 0x1e18 */ 0x0045, /* Ḙ → E */
  /* 0x1e19 */ 0x0065, /* ḙ → e */
  /* 0x1e1a */ 0x0045, /* Ḛ → E */
  /* 0x1e1b */ 0x0065, /* ḛ → e */
  /* 0x1e1c */ 0x0045, /* Ḝ → E */
  /* 0x1e1d */ 0x0065, /* ḝ → e */
  /* 0x1e1e */ 0x0046, /* Ḟ → F */
  /* 0x1e1f */ 0x0066, /* ḟ → f */
  /* 0x1e20 */ 0x0047, /* Ḡ → G */
  /* 0x1e21 */ 0x0067, /* ḡ → g */
  /* 0x1e22 */ 0x0048, /* Ḣ → H */
  /* 0x1e23 */ 0x0068, /* ḣ → h */
  /* 0x1e24 */ 0x0048, /* Ḥ → H */
  /* 0x1e25 */ 0x0068, /* ḥ → h */
  /* 0x1e26 */ 0x0048, /* Ḧ → H */
  /* 0x1e27 */ 0x0068, /* ḧ → h */
  /* 0x1e28 */ 0x0048, /* Ḩ → H */
  /* 0x1e29 */ 0x0068, /* ḩ → h */
  /* 0x1e2a */ 0x0048, /* Ḫ → H */
  /* 0x1e2b */ 0x0068, /* ḫ → h */
  /* 0x1e2c */ 0x0049, /* Ḭ → I */
  /* 0x1e2d */ 0x0069, /* ḭ → i */
  /* 0x1e2e */ 0x0049, /* Ḯ → I */
  /* 0x1e2f */ 0x0069, /* ḯ → i */
  /* 0x1e30 */ 0x004b, /* Ḱ → K */
  /* 0x1e31 */ 0x006b, /* ḱ → k */
  /* 0x1e32 */ 0x004b, /* Ḳ → K */
  /* 0x1e33 */ 0x006b, /* ḳ → k */
  /* 0x1e34 */ 0x004b, /* Ḵ → K */
  /* 0x1e35 */ 0x006b, /* ḵ → k */
  /* 0x1e36 */ 0x004c, /* Ḷ → L */
  /* 0x1e37 */ 0x006c, /* ḷ → l */
  /* 0x1e38 */ 0x004c, /* Ḹ → L */
  /* 0x1e39 */ 0x006c, /* ḹ → l */
  /* 0x1e3a */ 0x004c, /* Ḻ → L */
  /* 0x1e3b */ 0x006c, /* ḻ → l */
  /* 0x1e3c */ 0x004c, /* Ḽ → L */
  /* 0x1e3d */ 0x006c, /* ḽ → l */
  /* 0x1e3e */ 0x004d, /* Ḿ → M */
  /* 0x1e3f */ 0x006d, /* ḿ → m */
  /* 0x1e40 */ 0x004d, /* Ṁ → M */
  /* 0x1e41 */ 0x006d, /* ṁ → m */
  /* 0x1e42 */ 0x004d, /* Ṃ → M */
  /* 0x1e43 */ 0x006d, /* ṃ → m */
  /* 0x1e44 */ 0x004e, /* Ṅ → N */
  /* 0x1e45 */ 0x006e, /* ṅ → n */
  /* 0x1e46 */ 0x004e, /* Ṇ → N */
  /* 0x1e47 */ 0x006e, /* ṇ → n */
  /* 0x1e48 */ 0x004e, /* Ṉ → N */
  /* 0x1e49 */ 0x006e, /* ṉ → n */
  /* 0x1e4a */ 0x004e, /* Ṋ → N */
  /* 0x1e4b */ 0x006e, /* ṋ → n */
  /* 0x1e4c */ 0x004f, /* Ṍ → O */
  /* 0x1e4d */ 0x006f, /* ṍ → o */
  /* 0x1e4e */ 0x004f, /* Ṏ → O */
  /* 0x1e4f */ 0x006f, /* ṏ → o */
  /* 0x1e50 */ 0x004f, /* Ṑ → O */
  /* 0x1e51 */ 0x006f, /* ṑ → o */
  /* 0x1e52 */ 0x004f, /* Ṓ → O */
  /* 0x1e53 */ 0x006f, /* ṓ → o */
  /* 0x1e54 */ 0x0050, /* Ṕ → P */
  /* 0x1e55 */ 0x0070, /* ṕ → p */
  /* 0x1e56 */ 0x0050, /* Ṗ → P */
  /* 0x1e57 */ 0x0070, /* ṗ → p */
  /* 0x1e58 */ 0x0052, /* Ṙ → R */
  /* 0x1e59 */ 0x0072, /* ṙ → r */
  /* 0x1e5a */ 0x0052, /* Ṛ → R */
  /* 0x1e5b */ 0x0072, /* ṛ → r */
  /* 0x1e5c */ 0x0052, /* Ṝ → R */
  /* 0x1e5d */ 0x0072, /* ṝ → r */
  /* 0x1e5e */ 0x0052, /* Ṟ → R */
  /* 0x1e5f */ 0x0072, /* ṟ → r */
  /* 0x1e60 */ 0x0053, /* Ṡ → S */
  /* 0x1e61 */ 0x0073, /* ṡ → s */
  /* 0x1e62 */ 0x0053, /* Ṣ → S */
  /* 0x1e63 */ 0x0073, /* ṣ → s */
  /* 0x1e64 */ 0x0053, /* Ṥ → S */
  /* 0x1e65 */ 0x0073, /* ṥ → s */
  /* 0x1e66 */ 0x0053, /* Ṧ → S */
  /* 0x1e67 */ 0x0073, /* ṧ → s */
  /* 0x1e68 */ 0x0053, /* Ṩ → S */
  /* 0x1e69 */ 0x0073, /* ṩ → s */
  /* 0x1e6a */ 0x0054, /* Ṫ → T */
  /* 0x1e6b */ 0x0074, /* ṫ → t */
  /* 0x1e6c */ 0x0054, /* Ṭ → T */
  /* 0x1e6d */ 0x0074, /* ṭ → t */
  /* 0x1e6e */ 0x0054, /* Ṯ → T */
  /* 0x1e6f */ 0x0074, /* ṯ → t */
  /* 0x1e70 */ 0x0054, /* Ṱ → T */
  /* 0x1e71 */ 0x0074, /* ṱ → t */
  /* 0x1e72 */ 0x0055, /* Ṳ → U */
  /* 0x1e73 */ 0x0075, /* ṳ → u */
  /* 0x1e74 */ 0x0055, /* Ṵ → U */
  /* 0x1e75 */ 0x0075, /* ṵ → u */
  /* 0x1e76 */ 0x0055, /* Ṷ → U */
  /* 0x1e77 */ 0x0075, /* ṷ → u */
  /* 0x1e78 */ 0x0055, /* Ṹ → U */
  /* 0x1e79 */ 0x0075, /* ṹ → u */
  /* 0x1e7a */ 0x0055, /* Ṻ → U */
  /* 0x1e7b */ 0x0075, /* ṻ → u */
  /* 0x1e7c */ 0x0056, /* Ṽ → V */
  /* 0x1e7d */ 0x0076, /* ṽ → v */
  /* 0x1e7e */ 0x0056, /* Ṿ → V */
  /* 0x1e7f */ 0x0076, /* ṿ → v */
  /* 0x1e80 */ 0x0057, /* Ẁ → W */
  /* 0x1e81 */ 0x0077, /* ẁ → w */
  /* 0x1e82 */ 0x0057, /* Ẃ → W */
  /* 0x1e83 */ 0x0077, /* ẃ → w */
  /* 0x1e84 */ 0x0057, /* Ẅ → W */
  /* 0x1e85 */ 0x0077, /* ẅ → w */
  /* 0x1e86 */ 0x0057, /* Ẇ → W */
  /* 0x1e87 */ 0x0077, /* ẇ → w */
  /* 0x1e88 */ 0x0057, /* Ẉ → W */
  /* 0x1e89 */ 0x0077, /* ẉ → w */
  /* 0x1e8a */ 0x0058, /* Ẋ → X */
  /* 0x1e8b */ 0x0078, /* ẋ → x */
  /* 0x1e8c */ 0x0058, /* Ẍ → X */
  /* 0x1e8d */ 0x0078, /* ẍ → x */
  /* 0x1e8e */ 0x0059, /* Ẏ → Y */
  /* 0x1e8f */ 0x0079, /* ẏ → y */
  /* 0x1e90 */ 0x005a, /* Ẑ → Z */
  /* 0x1e91 */ 0x007a, /* ẑ → z */
  /* 0x1e92 */ 0x005a, /* Ẓ → Z */
  /* 0x1e93 */ 0x007a, /* ẓ → z */
  /* 0x1e94 */ 0x005a, /* Ẕ → Z */
  /* 0x1e95 */ 0x007a, /* ẕ → z */
  /* 0x1e96 */ 0x0068, /* ẖ → h */
  /* 0x1e97 */ 0x0074, /* ẗ → t */
  /* 0x1e98 */ 0x0077, /* ẘ → w */
  /* 0x1e99 */ 0x0079, /* ẙ → y */
  /* 0x1e9a */ 0x0061, /* ẚ → a */
  /* 0x1e9b */ 0x017f, /* ẛ → ſ */
  /* 0x1e9c */ 0x0073, /* ẜ → s */
  /* 0x1e9d */ 0x0073, /* ẝ → s */
  /* 0x1e9e */ 0x1e9e,
  /* 0x1e9f */ 0x1e9f,
  /* 0x1ea0 */ 0x0041, /* Ạ → A */
  /* 0x1ea1 */ 0x0061, /* ạ → a */
  /* 0x1ea2 */ 0x0041, /* Ả → A */
  /* 0x1ea3 */ 0x0061, /* ả → a */
  /* 0x1ea4 */ 0x0041, /* Ấ → A */
  /* 0x1ea5 */ 0x0061, /* ấ → a */
  /* 0x1ea6 */ 0x0041, /* Ầ → A */
  /* 0x1ea7 */ 0x0061, /* ầ → a */
  /* 0x1ea8 */ 0x0041, /* Ẩ → A */
  /* 0x1ea9 */ 0x0061, /* ẩ → a */
  /* 0x1eaa */ 0x0041, /* Ẫ → A */
  /* 0x1eab */ 0x0061, /* ẫ → a */
  /* 0x1eac */ 0x0041, /* Ậ → A */
  /* 0x1ead */ 0x0061, /* ậ → a */
  /* 0x1eae */ 0x0041, /* Ắ → A */
  /* 0x1eaf */ 0x0061, /* ắ → a */
  /* 0x1eb0 */ 0x0041, /* Ằ → A */
  /* 0x1eb1 */ 0x0061, /* ằ → a */
  /* 0x1eb2 */ 0x0041, /* Ẳ → A */
  /* 0x1eb3 */ 0x0061, /* ẳ → a */
  /* 0x1eb4 */ 0x0041, /* Ẵ → A */
  /* 0x1eb5 */ 0x0061, /* ẵ → a */
  /* 0x1eb6 */ 0x0041, /* Ặ → A */
  /* 0x1eb7 */ 0x0061, /* ặ → a */
  /* 0x1eb8 */ 0x0045, /* Ẹ → E */
  /* 0x1eb9 */ 0x0065, /* ẹ → e */
  /* 0x1eba */ 0x0045, /* Ẻ → E */
  /* 0x1ebb */ 0x0065, /* ẻ → e */
  /* 0x1ebc */ 0x0045, /* Ẽ → E */
  /* 0x1ebd */ 0x0065, /* ẽ → e */
  /* 0x1ebe */ 0x0045, /* Ế → E */
  /* 0x1ebf */ 0x0065, /* ế → e */
  /* 0x1ec0 */ 0x0045, /* Ề → E */
  /* 0x1ec1 */ 0x0065, /* ề → e */
  /* 0x1ec2 */ 0x0045, /* Ể → E */
  /* 0x1ec3 */ 0x0065, /* ể → e */
  /* 0x1ec4 */ 0x0045, /* Ễ → E */
  /* 0x1ec5 */ 0x0065, /* ễ → e */
  /* 0x1ec6 */ 0x0045, /* Ệ → E */
  /* 0x1ec7 */ 0x0065, /* ệ → e */
  /* 0x1ec8 */ 0x0049, /* Ỉ → I */
  /* 0x1ec9 */ 0x0069, /* ỉ → i */
  /* 0x1eca */ 0x0049, /* Ị → I */
  /* 0x1ecb */ 0x0069, /* ị → i */
  /* 0x1ecc */ 0x004f, /* Ọ → O */
  /* 0x1ecd */ 0x006f, /* ọ → o */
  /* 0x1ece */ 0x004f, /* Ỏ → O */
  /* 0x1ecf */ 0x006f, /* ỏ → o */
  /* 0x1ed0 */ 0x004f, /* Ố → O */
  /* 0x1ed1 */ 0x006f, /* ố → o */
  /* 0x1ed2 */ 0x004f, /* Ồ → O */
  /* 0x1ed3 */ 0x006f, /* ồ → o */
  /* 0x1ed4 */ 0x004f, /* Ổ → O */
  /* 0x1ed5 */ 0x006f, /* ổ → o */
  /* 0x1ed6 */ 0x004f, /* Ỗ → O */
  /* 0x1ed7 */ 0x006f, /* ỗ → o */
  /* 0x1ed8 */ 0x004f, /* Ộ → O */
  /* 0x1ed9 */ 0x006f, /* ộ → o */
  /* 0x1eda */ 0x004f, /* Ớ → O */
  /* 0x1edb */ 0x006f, /* ớ → o */
  /* 0x1edc */ 0x004f, /* Ờ → O */
  /* 0x1edd */ 0x006f, /* ờ → o */
  /* 0x1ede */ 0x004f, /* Ở → O */
  /* 0x1edf */ 0x006f, /* ở → o */
  /* 0x1ee0 */ 0x004f, /* Ỡ → O */
  /* 0x1ee1 */ 0x006f, /* ỡ → o */
  /* 0x1ee2 */ 0x004f, /* Ợ → O */
  /* 0x1ee3 */ 0x006f, /* ợ → o */
  /* 0x1ee4 */ 0x0055, /* Ụ → U */
  /* 0x1ee5 */ 0x0075, /* ụ → u */
  /* 0x1ee6 */ 0x0055, /* Ủ → U */
  /* 0x1ee7 */ 0x0075, /* ủ → u */
  /* 0x1ee8 */ 0x0055, /* Ứ → U */
  /* 0x1ee9 */ 0x0075, /* ứ → u */
  /* 0x1eea */ 0x0055, /* Ừ → U */
  /* 0x1eeb */ 0x0075, /* ừ → u */
  /* 0x1eec */ 0x0055, /* Ử → U */
  /* 0x1eed */ 0x0075, /* ử → u */
  /* 0x1eee */ 0x0055, /* Ữ → U */
  /* 0x1eef */ 0x0075, /* ữ → u */
  /* 0x1ef0 */ 0x0055, /* Ự → U */
  /* 0x1ef1 */ 0x0075, /* ự → u */
  /* 0x1ef2 */ 0x0059, /* Ỳ → Y */
  /* 0x1ef3 */ 0x0079, /* ỳ → y */
  /* 0x1ef4 */ 0x0059, /* Ỵ → Y */
  /* 0x1ef5 */ 0x0079, /* ỵ → y */
  /* 0x1ef6 */ 0x0059, /* Ỷ → Y */
  /* 0x1ef7 */ 0x0079, /* ỷ → y */
  /* 0x1ef8 */ 0x0059, /* Ỹ → Y */
  /* 0x1ef9 */ 0x0079, /* ỹ → y */
  /* 0x1efa */ 0x1efa,
  /* 0x1efb */ 0x1efb,
  /* 0x1efc */ 0x0056, /* Ỽ → V */
  /* 0x1efd */ 0x0076, /* ỽ → v */
  /* 0x1efe */ 0x0059, /* Ỿ → Y */
  /* 0x1eff */ 0x0079, /* ỿ → y */
  /* 0x1f00 */ 0x03b1, /* ἀ → α */
  /* 0x1f01 */ 0x03b1, /* ἁ → α */
  /* 0x1f02 */ 0x03b1, /* ἂ → α */
  /* 0x1f03 */ 0x03b1, /* ἃ → α */
  /* 0x1f04 */ 0x03b1, /* ἄ → α */
  /* 0x1f05 */ 0x03b1, /* ἅ → α */
  /* 0x1f06 */ 0x03b1, /* ἆ → α */
  /* 0x1f07 */ 0x03b1, /* ἇ → α */
  /* 0x1f08 */ 0x0391, /* Ἀ → Α */
  /* 0x1f09 */ 0x0391, /* Ἁ → Α */
  /* 0x1f0a */ 0x0391, /* Ἂ → Α */
  /* 0x1f0b */ 0x0391, /* Ἃ → Α */
  /* 0x1f0c */ 0x0391, /* Ἄ → Α */
  /* 0x1f0d */ 0x0391, /* Ἅ → Α */
  /* 0x1f0e */ 0x0391, /* Ἆ → Α */
  /* 0x1f0f */ 0x0391, /* Ἇ → Α */
  /* 0x1f10 */ 0x03b5, /* ἐ → ε */
  /* 0x1f11 */ 0x03b5, /* ἑ → ε */
  /* 0x1f12 */ 0x03b5, /* ἒ → ε */
  /* 0x1f13 */ 0x03b5, /* ἓ → ε */
  /* 0x1f14 */ 0x03b5, /* ἔ → ε */
  /* 0x1f15 */ 0x03b5, /* ἕ → ε */
  /* 0x1f16 */ 0x1f16,
  /* 0x1f17 */ 0x1f17,
  /* 0x1f18 */ 0x0395, /* Ἐ → Ε */
  /* 0x1f19 */ 0x0395, /* Ἑ → Ε */
  /* 0x1f1a */ 0x0395, /* Ἒ → Ε */
  /* 0x1f1b */ 0x0395, /* Ἓ → Ε */
  /* 0x1f1c */ 0x0395, /* Ἔ → Ε */
  /* 0x1f1d */ 0x0395, /* Ἕ → Ε */
  /* 0x1f1e */ 0x1f1e,
  /* 0x1f1f */ 0x1f1f,
  /* 0x1f20 */ 0x03b7, /* ἠ → η */
  /* 0x1f21 */ 0x03b7, /* ἡ → η */
  /* 0x1f22 */ 0x03b7, /* ἢ → η */
  /* 0x1f23 */ 0x03b7, /* ἣ → η */
  /* 0x1f24 */ 0x03b7, /* ἤ → η */
  /* 0x1f25 */ 0x03b7, /* ἥ → η */
  /* 0x1f26 */ 0x03b7, /* ἦ → η */
  /* 0x1f27 */ 0x03b7, /* ἧ → η */
  /* 0x1f28 */ 0x0397, /* Ἠ → Η */
  /* 0x1f29 */ 0x0397, /* Ἡ → Η */
  /* 0x1f2a */ 0x0397, /* Ἢ → Η */
  /* 0x1f2b */ 0x0397, /* Ἣ → Η */
  /* 0x1f2c */ 0x0397, /* Ἤ → Η */
  /* 0x1f2d */ 0x0397, /* Ἥ → Η */
  /* 0x1f2e */ 0x0397, /* Ἦ → Η */
  /* 0x1f2f */ 0x0397, /* Ἧ → Η */
  /* 0x1f30 */ 0x03b9, /* ἰ → ι */
  /* 0x1f31 */ 0x03b9, /* ἱ → ι */
  /* 0x1f32 */ 0x03b9, /* ἲ → ι */
  /* 0x1f33 */ 0x03b9, /* ἳ → ι */
  /* 0x1f34 */ 0x03b9, /* ἴ → ι */
  /* 0x1f35 */ 0x03b9, /* ἵ → ι */
  /* 0x1f36 */ 0x03b9, /* ἶ → ι */
  /* 0x1f37 */ 0x03b9, /* ἷ → ι */
  /* 0x1f38 */ 0x0399, /* Ἰ → Ι */
  /* 0x1f39 */ 0x0399, /* Ἱ → Ι */
  /* 0x1f3a */ 0x0399, /* Ἲ → Ι */
  /* 0x1f3b */ 0x0399, /* Ἳ → Ι */
  /* 0x1f3c */ 0x0399, /* Ἴ → Ι */
  /* 0x1f3d */ 0x0399, /* Ἵ → Ι */
  /* 0x1f3e */ 0x0399, /* Ἶ → Ι */
  /* 0x1f3f */ 0x0399, /* Ἷ → Ι */
  /* 0x1f40 */ 0x03bf, /* ὀ → ο */
  /* 0x1f41 */ 0x03bf, /* ὁ → ο */
  /* 0x1f42 */ 0x03bf, /* ὂ → ο */
  /* 0x1f43 */ 0x03bf, /* ὃ → ο */
  /* 0x1f44 */ 0x03bf, /* ὄ → ο */
  /* 0x1f45 */ 0x03bf, /* ὅ → ο */
  /* 0x1f46 */ 0x1f46,
  /* 0x1f47 */ 0x1f47,
  /* 0x1f48 */ 0x039f, /* Ὀ → Ο */
  /* 0x1f49 */ 0x039f, /* Ὁ → Ο */
  /* 0x1f4a */ 0x039f, /* Ὂ → Ο */
  /* 0x1f4b */ 0x039f, /* Ὃ → Ο */
  /* 0x1f4c */ 0x039f, /* Ὄ → Ο */
  /* 0x1f4d */ 0x039f, /* Ὅ → Ο */
  /* 0x1f4e */ 0x1f4e,
  /* 0x1f4f */ 0x1f4f,
  /* 0x1f50 */ 0x03c5, /* ὐ → υ */
  /* 0x1f51 */ 0x03c5, /* ὑ → υ */
  /* 0x1f52 */ 0x03c5, /* ὒ → υ */
  /* 0x1f53 */ 0x03c5, /* ὓ → υ */
  /* 0x1f54 */ 0x03c5, /* ὔ → υ */
  /* 0x1f55 */ 0x03c5, /* ὕ → υ */
  /* 0x1f56 */ 0x03c5, /* ὖ → υ */
  /* 0x1f57 */ 0x03c5, /* ὗ → υ */
  /* 0x1f58 */ 0x1f58,
  /* 0x1f59 */ 0x03a5, /* Ὑ → Υ */
  /* 0x1f5a */ 0x1f5a,
  /* 0x1f5b */ 0x03a5, /* Ὓ → Υ */
  /* 0x1f5c */ 0x1f5c,
  /* 0x1f5d */ 0x03a5, /* Ὕ → Υ */
  /* 0x1f5e */ 0x1f5e,
  /* 0x1f5f */ 0x03a5, /* Ὗ → Υ */
  /* 0x1f60 */ 0x03c9, /* ὠ → ω */
  /* 0x1f61 */ 0x03c9, /* ὡ → ω */
  /* 0x1f62 */ 0x03c9, /* ὢ → ω */
  /* 0x1f63 */ 0x03c9, /* ὣ → ω */
  /* 0x1f64 */ 0x03c9, /* ὤ → ω */
  /* 0x1f65 */ 0x03c9, /* ὥ → ω */
  /* 0x1f66 */ 0x03c9, /* ὦ → ω */
  /* 0x1f67 */ 0x03c9, /* ὧ → ω */
  /* 0x1f68 */ 0x03a9, /* Ὠ → Ω */
  /* 0x1f69 */ 0x03a9, /* Ὡ → Ω */
  /* 0x1f6a */ 0x03a9, /* Ὢ → Ω */
  /* 0x1f6b */ 0x03a9, /* Ὣ → Ω */
  /* 0x1f6c */ 0x03a9, /* Ὤ → Ω */
  /* 0x1f6d */ 0x03a9, /* Ὥ → Ω */
  /* 0x1f6e */ 0x03a9, /* Ὦ → Ω */
  /* 0x1f6f */ 0x03a9, /* Ὧ → Ω */
  /* 0x1f70 */ 0x03b1, /* ὰ → α */
  /* 0x1f71 */ 0x03b1, /* ά → α */
  /* 0x1f72 */ 0x03b5, /* ὲ → ε */
  /* 0x1f73 */ 0x03b5, /* έ → ε */
  /* 0x1f74 */ 0x03b7, /* ὴ → η */
  /* 0x1f75 */ 0x03b7, /* ή → η */
  /* 0x1f76 */ 0x03b9, /* ὶ → ι */
  /* 0x1f77 */ 0x03b9, /* ί → ι */
  /* 0x1f78 */ 0x03bf, /* ὸ → ο */
  /* 0x1f79 */ 0x03bf, /* ό → ο */
  /* 0x1f7a */ 0x03c5, /* ὺ → υ */
  /* 0x1f7b */ 0x03c5, /* ύ → υ */
  /* 0x1f7c */ 0x03c9, /* ὼ → ω */
  /* 0x1f7d */ 0x03c9, /* ώ → ω */
  /* 0x1f7e */ 0x1f7e,
  /* 0x1f7f */ 0x1f7f,
  /* 0x1f80 */ 0x03b1, /* ᾀ → α */
  /* 0x1f81 */ 0x03b1, /* ᾁ → α */
  /* 0x1f82 */ 0x03b1, /* ᾂ → α */
  /* 0x1f83 */ 0x03b1, /* ᾃ → α */
  /* 0x1f84 */ 0x03b1, /* ᾄ → α */
  /* 0x1f85 */ 0x03b1, /* ᾅ → α */
  /* 0x1f86 */ 0x03b1, /* ᾆ → α */
  /* 0x1f87 */ 0x03b1, /* ᾇ → α */
  /* 0x1f88 */ 0x0391, /* ᾈ → Α */
  /* 0x1f89 */ 0x0391, /* ᾉ → Α */
  /* 0x1f8a */ 0x0391, /* ᾊ → Α */
  /* 0x1f8b */ 0x0391, /* ᾋ → Α */
  /* 0x1f8c */ 0x0391, /* ᾌ → Α */
  /* 0x1f8d */ 0x0391, /* ᾍ → Α */
  /* 0x1f8e */ 0x0391, /* ᾎ → Α */
  /* 0x1f8f */ 0x0391, /* ᾏ → Α */
  /* 0x1f90 */ 0x03b7, /* ᾐ → η */
  /* 0x1f91 */ 0x03b7, /* ᾑ → η */
  /* 0x1f92 */ 0x03b7, /* ᾒ → η */
  /* 0x1f93 */ 0x03b7, /* ᾓ → η */
  /* 0x1f94 */ 0x03b7, /* ᾔ → η */
  /* 0x1f95 */ 0x03b7, /* ᾕ → η */
  /* 0x1f96 */ 0x03b7, /* ᾖ → η */
  /* 0x1f97 */ 0x03b7, /* ᾗ → η */
  /* 0x1f98 */ 0x0397, /* ᾘ → Η */
  /* 0x1f99 */ 0x0397, /* ᾙ → Η */
  /* 0x1f9a */ 0x0397, /* ᾚ → Η */
  /* 0x1f9b */ 0x0397, /* ᾛ → Η */
  /* 0x1f9c */ 0x0397, /* ᾜ → Η */
  /* 0x1f9d */ 0x0397, /* ᾝ → Η */
  /* 0x1f9e */ 0x0397, /* ᾞ → Η */
  /* 0x1f9f */ 0x0397, /* ᾟ → Η */
  /* 0x1fa0 */ 0x03c9, /* ᾠ → ω */
  /* 0x1fa1 */ 0x03c9, /* ᾡ → ω */
  /* 0x1fa2 */ 0x03c9, /* ᾢ → ω */
  /* 0x1fa3 */ 0x03c9, /* ᾣ → ω */
  /* 0x1fa4 */ 0x03c9, /* ᾤ → ω */
  /* 0x1fa5 */ 0x03c9, /* ᾥ → ω */
  /* 0x1fa6 */ 0x03c9, /* ᾦ → ω */
  /* 0x1fa7 */ 0x03c9, /* ᾧ → ω */
  /* 0x1fa8 */ 0x03a9, /* ᾨ → Ω */
  /* 0x1fa9 */ 0x03a9, /* ᾩ → Ω */
  /* 0x1faa */ 0x03a9, /* ᾪ → Ω */
  /* 0x1fab */ 0x03a9, /* ᾫ → Ω */
  /* 0x1fac */ 0x03a9, /* ᾬ → Ω */
  /* 0x1fad */ 0x03a9, /* ᾭ → Ω */
  /* 0x1fae */ 0x03a9, /* ᾮ → Ω */
  /* 0x1faf */ 0x03a9, /* ᾯ → Ω */
  /* 0x1fb0 */ 0x03b1, /* ᾰ → α */
  /* 0x1fb1 */ 0x03b1, /* ᾱ → α */
  /* 0x1fb2 */ 0x03b1, /* ᾲ → α */
  /* 0x1fb3 */ 0x03b1, /* ᾳ → α */
  /* 0x1fb4 */ 0x03b1, /* ᾴ → α */
  /* 0x1fb5 */ 0x1fb5,
  /* 0x1fb6 */ 0x03b1, /* ᾶ → α */
  /* 0x1fb7 */ 0x03b1, /* ᾷ → α */
  /* 0x1fb8 */ 0x0391, /* Ᾰ → Α */
  /* 0x1fb9 */ 0x0391, /* Ᾱ → Α */
  /* 0x1fba */ 0x0391, /* Ὰ → Α */
  /* 0x1fbb */ 0x0391, /* Ά → Α */
  /* 0x1fbc */ 0x0391, /* ᾼ → Α */
  /* 0x1fbd */ 0x1fbd,
  /* 0x1fbe */ 0x1fbe,
  /* 0x1fbf */ 0x1fbf,
  /* 0x1fc0 */ 0x1fc0,
  /* 0x1fc1 */ 0x00a8, /* ῁ → ¨ */
  /* 0x1fc2 */ 0x03b7, /* ῂ → η */
  /* 0x1fc3 */ 0x03b7, /* ῃ → η */
  /* 0x1fc4 */ 0x03b7, /* ῄ → η */
  /* 0x1fc5 */ 0x1fc5,
  /* 0x1fc6 */ 0x03b7, /* ῆ → η */
  /* 0x1fc7 */ 0x03b7, /* ῇ → η */
  /* 0x1fc8 */ 0x0395, /* Ὲ → Ε */
  /* 0x1fc9 */ 0x0395, /* Έ → Ε */
  /* 0x1fca */ 0x0397, /* Ὴ → Η */
  /* 0x1fcb */ 0x0397, /* Ή → Η */
  /* 0x1fcc */ 0x0397, /* ῌ → Η */
  /* 0x1fcd */ 0x1fbf, /* ῍ → ᾿ */
  /* 0x1fce */ 0x1fbf, /* ῎ → ᾿ */
  /* 0x1fcf */ 0x1fbf, /* ῏ → ᾿ */
  /* 0x1fd0 */ 0x03b9, /* ῐ → ι */
  /* 0x1fd1 */ 0x03b9, /* ῑ → ι */
  /* 0x1fd2 */ 0x03b9, /* ῒ → ι */
  /* 0x1fd3 */ 0x03b9, /* ΐ → ι */
  /* 0x1fd4 */ 0x1fd4,
  /* 0x1fd5 */ 0x1fd5,
  /* 0x1fd6 */ 0x03b9, /* ῖ → ι */
  /* 0x1fd7 */ 0x03b9, /* ῗ → ι */
  /* 0x1fd8 */ 0x0399, /* Ῐ → Ι */
  /* 0x1fd9 */ 0x0399, /* Ῑ → Ι */
  /* 0x1fda */ 0x0399, /* Ὶ → Ι */
  /* 0x1fdb */ 0x0399, /* Ί → Ι */
  /* 0x1fdc */ 0x1fdc,
  /* 0x1fdd */ 0x1ffe, /* ῝ → ῾ */
  /* 0x1fde */ 0x1ffe, /* ῞ → ῾ */
  /* 0x1fdf */ 0x1ffe, /* ῟ → ῾ */
  /* 0x1fe0 */ 0x03c5, /* ῠ → υ */
  /* 0x1fe1 */ 0x03c5, /* ῡ → υ */
  /* 0x1fe2 */ 0x03c5, /* ῢ → υ */
  /* 0x1fe3 */ 0x03c5, /* ΰ → υ */
  /* 0x1fe4 */ 0x03c1, /* ῤ → ρ */
  /* 0x1fe5 */ 0x03c1, /* ῥ → ρ */
  /* 0x1fe6 */ 0x03c5, /* ῦ → υ */
  /* 0x1fe7 */ 0x03c5, /* ῧ → υ */
  /* 0x1fe8 */ 0x03a5, /* Ῠ → Υ */
  /* 0x1fe9 */ 0x03a5, /* Ῡ → Υ */
  /* 0x1fea */ 0x03a5, /* Ὺ → Υ */
  /* 0x1feb */ 0x03a5, /* Ύ → Υ */
  /* 0x1fec */ 0x03a1, /* Ῥ → Ρ */
  /* 0x1fed */ 0x00a8, /* ῭ → ¨ */
  /* 0x1fee */ 0x00a8, /* ΅ → ¨ */
  /* 0x1fef */ 0x1fef,
  /* 0x1ff0 */ 0x1ff0,
  /* 0x1ff1 */ 0x1ff1,
  /* 0x1ff2 */ 0x03c9, /* ῲ → ω */
  /* 0x1ff3 */ 0x03c9, /* ῳ → ω */
  /* 0x1ff4 */ 0x03c9, /* ῴ → ω */
  /* 0x1ff5 */ 0x1ff5,
  /* 0x1ff6 */ 0x03c9, /* ῶ → ω */
  /* 0x1ff7 */ 0x03c9, /* ῷ → ω */
  /* 0x1ff8 */ 0x039f, /* Ὸ → Ο */
  /* 0x1ff9 */ 0x039f, /* Ό → Ο */
  /* 0x1ffa */ 0x03a9, /* Ὼ → Ω */
  /* 0x1ffb */ 0x03a9, /* Ώ → Ω */
  /* 0x1ffc */ 0x03a9, /* ῼ → Ω */
  /* 0x2010 */ 0x002d, /* ‐ → - */
  /* 0x2011 */ 0x002d, /* ‑ → - */
  /* 0x2012 */ 0x002d, /* ‒ → - */
  /* 0x2013 */ 0x002d, /* – → - */
  /* 0x2014 */ 0x002d, /* — → - */
  /* 0x2015 */ 0x002d, /* ― → - */
  /* 0x2016 */ 0x2016,
  /* 0x2017 */ 0x2017,
  /* 0x2018 */ 0x0027, /* ‘ → ' */
  /* 0x2019 */ 0x0027, /* ’ → ' */
  /* 0x201a */ 0x002c, /* ‚ → , */
  /* 0x201b */ 0x0027, /* ‛ → ' */
  /* 0x201c */ 0x0022, /* “ → " */
  /* 0x201d */ 0x0022, /* ” → " */
  /* 0x201e */ 0x201e,
  /* 0x201f */ 0x0022, /* ‟ → " */
  /* 0x2020 */ 0x2020,
  /* 0x2021 */ 0x2021,
  /* 0x2022 */ 0x2022,
  /* 0x2023 */ 0x2023,
  /* 0x2024 */ 0x002e, /* ․ → . */
  /* 0x2025 */ 0x2025,
  /* 0x2026 */ 0x2026,
  /* 0x2027 */ 0x2027,
  /* 0x2028 */ 0x2028,
  /* 0x2029 */ 0x2029,
  /* 0x202a */ 0x202a,
  /* 0x202b */ 0x202b,
  /* 0x202c */ 0x202c,
  /* 0x202d */ 0x202d,
  /* 0x202e */ 0x202e,
  /* 0x202f */ 0x202f,
  /* 0x2030 */ 0x2030,
  /* 0x2031 */ 0x2031,
  /* 0x2032 */ 0x0027, /* ′ → ' */
  /* 0x2033 */ 0x0022, /* ″ → " */
  /* 0x2034 */ 0x2034,
  /* 0x2035 */ 0x2035,
  /* 0x2036 */ 0x2036,
  /* 0x2037 */ 0x2037,
  /* 0x2038 */ 0x2038,
  /* 0x2039 */ 0x003c, /* ‹ → < */
  /* 0x203a */ 0x003e, /* › → > */
  /* 0x203b */ 0x203b,
  /* 0x203c */ 0x203c,
  /* 0x203d */ 0x203d,
  /* 0x203e */ 0x203e,
  /* 0x203f */ 0x203f,
  /* 0x2040 */ 0x2040,
  /* 0x2041 */ 0x2041,
  /* 0x2042 */ 0x2042,
  /* 0x2043 */ 0x2043,
  /* 0x2044 */ 0x002f, /* ⁄ → / */
  /* 0x2045 */ 0x005b, /* ⁅ → [ */
  /* 0x2046 */ 0x005d, /* ⁆ → ] */
  /* 0x2047 */ 0x2047,
  /* 0x2048 */ 0x2048,
  /* 0x2049 */ 0x2049,
  /* 0x204a */ 0x204a,
  /* 0x204b */ 0x204b,
  /* 0x204c */ 0x204c,
  /* 0x204d */ 0x204d,
  /* 0x204e */ 0x002a, /* ⁎ → * */
  /* 0x2102 */ 0x0043, /* ℂ → C */
  /* 0x2103 */ 0x2103,
  /* 0x2104 */ 0x2104,
  /* 0x2105 */ 0x2105,
  /* 0x2106 */ 0x2106,
  /* 0x2107 */ 0x2107,
  /* 0x2108 */ 0x2108,
  /* 0x2109 */ 0x2109,
  /* 0x210a */ 0x0067, /* ℊ → g */
  /* 0x210b */ 0x0048, /* ℋ → H */
  /* 0x210c */ 0x0078, /* ℌ → x */
  /* 0x210d */ 0x0048, /* ℍ → H */
  /* 0x210e */ 0x0068, /* ℎ → h */
  /* 0x210f */ 0x210f,
  /* 0x2110 */ 0x0049, /* ℐ → I */
  /* 0x2111 */ 0x0049, /* ℑ → I */
  /* 0x2112 */ 0x004c, /* ℒ → L */
  /* 0x2113 */ 0x006c, /* ℓ → l */
  /* 0x2114 */ 0x2114,
  /* 0x2115 */ 0x004e, /* ℕ → N */
  /* 0x2116 */ 0x2116,
  /* 0x2117 */ 0x2117,
  /* 0x2118 */ 0x0050, /* ℘ → P */
  /* 0x2119 */ 0x0050, /* ℙ → P */
  /* 0x211a */ 0x0051, /* ℚ → Q */
  /* 0x211b */ 0x0052, /* ℛ → R */
  /* 0x211c */ 0x0052, /* ℜ → R */
  /* 0x211d */ 0x0052, /* ℝ → R */
  /* 0x211e */ 0x211e,
  /* 0x211f */ 0x211f,
  /* 0x2120 */ 0x2120,
  /* 0x2121 */ 0x2121,
  /* 0x2122 */ 0x2122,
  /* 0x2123 */ 0x2123,
  /* 0x2124 */ 0x005a, /* ℤ → Z */
  /* 0x2125 */ 0x2125,
  /* 0x2126 */ 0x2126,
  /* 0x2127 */ 0x2127,
  /* 0x2128 */ 0x005a, /* ℨ → Z */
  /* 0x2129 */ 0x2129,
  /* 0x212a */ 0x212a,
  /* 0x212b */ 0x0041, /* Å → A */
  /* 0x212c */ 0x0042, /* ℬ → B */
  /* 0x212d */ 0x0043, /* ℭ → C */
  /* 0x212e */ 0x212e,
  /* 0x212f */ 0x0065, /* ℯ → e */
  /* 0x2130 */ 0x0045, /* ℰ → E */
  /* 0x2131 */ 0x0046, /* ℱ → F */
  /* 0x2132 */ 0x2132,
  /* 0x2133 */ 0x004d, /* ℳ → M */
  /* 0x2134 */ 0x006f, /* ℴ → o */
  /* 0x2135 */ 0x2135,
  /* 0x2136 */ 0x2136,
  /* 0x2137 */ 0x2137,
  /* 0x2138 */ 0x2138,
  /* 0x2139 */ 0x0069, /* ℹ → i */
  /* 0x213a */ 0x213a,
  /* 0x213b */ 0x213b,
  /* 0x213c */ 0x213c,
  /* 0x213d */ 0x213d,
  /* 0x213e */ 0x213e,
  /* 0x213f */ 0x213f,
  /* 0x2140 */ 0x2140,
  /* 0x2141 */ 0x2141,
  /* 0x2142 */ 0x2142,
  /* 0x2143 */ 0x2143,
  /* 0x2144 */ 0x2144,
  /* 0x2145 */ 0x0044, /* ⅅ → D */
  /* 0x2146 */ 0x0064, /* ⅆ → d */
  /* 0x2147 */ 0x0065, /* ⅇ → e */
  /* 0x2148 */ 0x0069, /* ⅈ → i */
  /* 0x2149 */ 0x006a, /* ⅉ → j */
  /* 0x214a */ 0x214a,
  /* 0x214b */ 0x214b,
  /* 0x214c */ 0x214c,
  /* 0x214d */ 0x214d,
  /* 0x214e */ 0x214e,
  /* 0x214f */ 0x214f,
  /* 0x2150 */ 0x2150,
  /* 0x2151 */ 0x2151,
  /* 0x2152 */ 0x2152,
  /* 0x2153 */ 0x2153,
  /* 0x2154 */ 0x2154,
  /* 0x2155 */ 0x2155,
  /* 0x2156 */ 0x2156,
  /* 0x2157 */ 0x2157,
  /* 0x2158 */ 0x2158,
  /* 0x2159 */ 0x2159,
  /* 0x215a */ 0x215a,
  /* 0x215b */ 0x215b,
  /* 0x215c */ 0x215c,
  /* 0x215d */ 0x215d,
  /* 0x215e */ 0x215e,
  /* 0x215f */ 0x215f,
  /* 0x2160 */ 0x0049, /* Ⅰ → I */
  /* 0x2161 */ 0x2161,
  /* 0x2162 */ 0x2162,
  /* 0x2163 */ 0x2163,
  /* 0x2164 */ 0x0056, /* Ⅴ → V */
  /* 0x2165 */ 0x2165,
  /* 0x2166 */ 0x2166,
  /* 0x2167 */ 0x2167,
  /* 0x2168 */ 0x2168,
  /* 0x2169 */ 0x0058, /* Ⅹ → X */
  /* 0x216a */ 0x216a,
  /* 0x216b */ 0x216b,
  /* 0x216c */ 0x004c, /* Ⅼ → L */
  /* 0x216d */ 0x0043, /* Ⅽ → C */
  /* 0x216e */ 0x0044, /* Ⅾ → D */
  /* 0x216f */ 0x004d, /* Ⅿ → M */
  /* 0x2170 */ 0x0069, /* ⅰ → i */
  /* 0x2171 */ 0x2171,
  /* 0x2172 */ 0x2172,
  /* 0x2173 */ 0x2173,
  /* 0x2174 */ 0x0076, /* ⅴ → v */
  /* 0x2175 */ 0x2175,
  /* 0x2176 */ 0x2176,
  /* 0x2177 */ 0x2177,
  /* 0x2178 */ 0x2178,
  /* 0x2179 */ 0x0078, /* ⅹ → x */
  /* 0x217a */ 0x217a,
  /* 0x217b */ 0x217b,
  /* 0x217c */ 0x006c, /* ⅼ → l */
  /* 0x217d */ 0x0063, /* ⅽ → c */
  /* 0x217e */ 0x0064, /* ⅾ → d */
  /* 0x217f */ 0x006d, /* ⅿ → m */
  /* 0x2212 */ 0x002d, /* − → - */
  /* 0x2213 */ 0x2213,
  /* 0x2214 */ 0x2214,
  /* 0x2215 */ 0x002f, /* ∕ → / */
  /* 0x2216 */ 0x005c, /* ∖ → \ */
  /* 0x2217 */ 0x2217,
  /* 0x2218 */ 0x2218,
  /* 0x2219 */ 0x2219,
  /* 0x221a */ 0x221a,
  /* 0x221b */ 0x221b,
  /* 0x221c */ 0x221c,
  /* 0x221d */ 0x221d,
  /* 0x221e */ 0x221e,
  /* 0x221f */ 0x221f,
  /* 0x2220 */ 0x2220,
  /* 0x2221 */ 0x2221,
  /* 0x2222 */ 0x2222,
  /* 0x2223 */ 0x007c, /* ∣ → | */
  /* 0x2c60 */ 0x004c, /* Ⱡ → L */
  /* 0x2c61 */ 0x006c, /* ⱡ → l */
  /* 0x2c62 */ 0x004c, /* Ɫ → L */
  /* 0x2c63 */ 0x0050, /* Ᵽ → P */
  /* 0x2c64 */ 0x0052, /* Ɽ → R */
  /* 0x2c65 */ 0x0061, /* ⱥ → a */
  /* 0x2c66 */ 0x0074, /* ⱦ → t */
  /* 0x2c67 */ 0x0048, /* Ⱨ → H */
  /* 0x2c68 */ 0x0068, /* ⱨ → h */
  /* 0x2c69 */ 0x004b, /* Ⱪ → K */
  /* 0x2c6a */ 0x006b, /* ⱪ → k */
  /* 0x2c6b */ 0x005a, /* Ⱬ → Z */
  /* 0x2c6c */ 0x007a, /* ⱬ → z */
  /* 0x2c6d */ 0x2c6d,
  /* 0x2c6e */ 0x004d, /* Ɱ → M */
  /* 0x2c6f */ 0x2c6f,
  /* 0x2c70 */ 0x2c70,
  /* 0x2c71 */ 0x0076, /* ⱱ → v */
  /* 0x2c72 */ 0x0057, /* Ⱳ → W */
  /* 0x2c73 */ 0x0077, /* ⱳ → w */
  /* 0x2c74 */ 0x0076, /* ⱴ → v */
  /* 0x2c75 */ 0x2c75,
  /* 0x2c76 */ 0x2c76,
  /* 0x2c77 */ 0x2c77,
  /* 0x2c78 */ 0x0065, /* ⱸ → e */
  /* 0x2c79 */ 0x2c79,
  /* 0x2c7a */ 0x006f, /* ⱺ → o */
  /* 0x2c7b */ 0x2c7b,
  /* 0x2c7c */ 0x2c7c,
  /* 0x2c7d */ 0x2c7d,
  /* 0x2c7e */ 0x0053, /* Ȿ → S */
  /* 0x2c7f */ 0x005a, /* Ɀ → Z */
  /* 0x3001 */ 0x002c, /* 、 → , */
  /* 0x3002 */ 0x002e, /* 。 → . */
  /* 0x3003 */ 0x3003,
  /* 0x3004 */ 0x3004,
  /* 0x3005 */ 0x3005,
  /* 0x3006 */ 0x3006,
  /* 0x3007 */ 0x0030, /* 〇 → 0 */
  /* 0x3008 */ 0x003c, /* 〈 → < */
  /* 0x3009 */ 0x003e, /* 〉 → > */
  /* 0x300a */ 0x300a,
  /* 0x300b */ 0x300b,
  /* 0x300c */ 0x300c,
  /* 0x300d */ 0x300d,
  /* 0x300e */ 0x300e,
  /* 0x300f */ 0x300f,
  /* 0x3010 */ 0x3010,
  /* 0x3011 */ 0x3011,
  /* 0x3012 */ 0x3012,
  /* 0x3013 */ 0x3013,
  /* 0x3014 */ 0x005b, /* 〔 → [ */
  /* 0x3015 */ 0x005d, /* 〕 → ] */
  /* 0x3016 */ 0x3016,
  /* 0x3017 */ 0x3017,
  /* 0x3018 */ 0x005b, /* 〘 → [ */
  /* 0x3019 */ 0x005d, /* 〙 → ] */
  /* 0x301a */ 0x005b, /* 〚 → [ */
  /* 0x301b */ 0x005d, /* 〛 → ] */
  /* 0x301c */ 0x301c,
  /* 0x301d */ 0x0022, /* 〝 → " */
  /* 0x301e */ 0x0022, /* 〞 → " */
  /* 0xa730 */ 0x0046, /* ꜰ → F */
  /* 0xa731 */ 0x0053, /* ꜱ → S */
  /* 0xa732 */ 0xa732,
  /* 0xa733 */ 0xa733,
  /* 0xa734 */ 0xa734,
  /* 0xa735 */ 0xa735,
  /* 0xa736 */ 0xa736,
  /* 0xa737 */ 0xa737,
  /* 0xa738 */ 0xa738,
  /* 0xa739 */ 0xa739,
  /* 0xa73a */ 0xa73a,
  /* 0xa73b */ 0xa73b,
  /* 0xa73c */ 0xa73c,
  /* 0xa73d */ 0xa73d,
  /* 0xa73e */ 0xa73e,
  /* 0xa73f */ 0xa73f,
  /* 0xa740 */ 0x004b, /* Ꝁ → K */
  /* 0xa741 */ 0x006b, /* ꝁ → k */
  /* 0xa742 */ 0x004b, /* Ꝃ → K */
  /* 0xa743 */ 0x006b, /* ꝃ → k */
  /* 0xa744 */ 0x004b, /* Ꝅ → K */
  /* 0xa745 */ 0x006b, /* ꝅ → k */
  /* 0xa746 */ 0x004c, /* Ꝇ → L */
  /* 0xa747 */ 0x006c, /* ꝇ → l */
  /* 0xa748 */ 0x004c, /* Ꝉ → L */
  /* 0xa749 */ 0x006c, /* ꝉ → l */
  /* 0xa74a */ 0x004f, /* Ꝋ → O */
  /* 0xa74b */ 0x006f, /* ꝋ → o */
  /* 0xa74c */ 0x004f, /* Ꝍ → O */
  /* 0xa74d */ 0x006f, /* ꝍ → o */
  /* 0xa74e */ 0xa74e,
  /* 0xa74f */ 0xa74f,
  /* 0xa750 */ 0x0050, /* Ꝑ → P */
  /* 0xa751 */ 0x0070, /* ꝑ → p */
  /* 0xa752 */ 0x0050, /* Ꝓ → P */
  /* 0xa753 */ 0x0070, /* ꝓ → p */
  /* 0xa754 */ 0x0050, /* Ꝕ → P */
  /* 0xa755 */ 0x0070, /* ꝕ → p */
  /* 0xa756 */ 0x0051, /* Ꝗ → Q */
  /* 0xa757 */ 0x0071, /* ꝗ → q */
  /* 0xa758 */ 0x0051, /* Ꝙ → Q */
  /* 0xa759 */ 0x0071, /* ꝙ → q */
  /* 0xa75a */ 0xa75a,
  /* 0xa75b */ 0xa75b,
  /* 0xa75c */ 0xa75c,
  /* 0xa75d */ 0xa75d,
  /* 0xa75e */ 0x0056, /* Ꝟ → V */
  /* 0xa75f */ 0x0076, /* ꝟ → v */
  /* 0xa760 */ 0xa760,
  /* 0xa761 */ 0xa761,
  /* 0xa762 */ 0xa762,
  /* 0xa763 */ 0xa763,
  /* 0xa764 */ 0xa764,
  /* 0xa765 */ 0xa765,
  /* 0xa766 */ 0xa766,
  /* 0xa767 */ 0xa767,
  /* 0xa768 */ 0xa768,
  /* 0xa769 */ 0xa769,
  /* 0xa76a */ 0xa76a,
  /* 0xa76b */ 0xa76b,
  /* 0xa76c */ 0xa76c,
  /* 0xa76d */ 0xa76d,
  /* 0xa76e */ 0xa76e,
  /* 0xa76f */ 0xa76f,
  /* 0xa770 */ 0xa770,
  /* 0xa771 */ 0x0064, /* ꝱ → d */
  /* 0xa772 */ 0x006c, /* ꝲ → l */
  /* 0xa773 */ 0x006d, /* ꝳ → m */
  /* 0xa774 */ 0x006e, /* ꝴ → n */
  /* 0xa775 */ 0x0072, /* ꝵ → r */
  /* 0xa776 */ 0x0052, /* ꝶ → R */
  /* 0xa777 */ 0x0074, /* ꝷ → t */
  /* 0xa778 */ 0xa778,
  /* 0xa779 */ 0x0044, /* Ꝺ → D */
  /* 0xa77a */ 0x0064, /* ꝺ → d */
  /* 0xa77b */ 0x0046, /* Ꝼ → F */
  /* 0xa77c */ 0x0066, /* ꝼ → f */
  /* 0xa77d */ 0xa77d,
  /* 0xa77e */ 0xa77e,
  /* 0xa77f */ 0xa77f,
  /* 0xa780 */ 0xa780,
  /* 0xa781 */ 0xa781,
  /* 0xa782 */ 0xa782,
  /* 0xa783 */ 0xa783,
  /* 0xa784 */ 0xa784,
  /* 0xa785 */ 0xa785,
  /* 0xa786 */ 0x0054, /* Ꞇ → T */
  /* 0xa787 */ 0x0074, /* ꞇ → t */
  /* 0xa788 */ 0xa788,
  /* 0xa789 */ 0xa789,
  /* 0xa78a */ 0xa78a,
  /* 0xa78b */ 0xa78b,
  /* 0xa78c */ 0xa78c,
  /* 0xa78d */ 0xa78d,
  /* 0xa78e */ 0xa78e,
  /* 0xa78f */ 0xa78f,
  /* 0xa790 */ 0x004e, /* Ꞑ → N */
  /* 0xa791 */ 0x006e, /* ꞑ → n */
  /* 0xa792 */ 0x0043, /* Ꞓ → C */
  /* 0xa793 */ 0x0063, /* ꞓ → c */
  /* 0xa794 */ 0xa794,
  /* 0xa795 */ 0xa795,
  /* 0xa796 */ 0xa796,
  /* 0xa797 */ 0xa797,
  /* 0xa798 */ 0xa798,
  /* 0xa799 */ 0xa799,
  /* 0xa79a */ 0xa79a,
  /* 0xa79b */ 0xa79b,
  /* 0xa79c */ 0xa79c,
  /* 0xa79d */ 0xa79d,
  /* 0xa79e */ 0xa79e,
  /* 0xa79f */ 0xa79f,
  /* 0xa7a0 */ 0x0047, /* Ꞡ → G */
  /* 0xa7a1 */ 0x0067, /* ꞡ → g */
  /* 0xa7a2 */ 0x004b, /* Ꞣ → K */
  /* 0xa7a3 */ 0x006b, /* ꞣ → k */
  /* 0xa7a4 */ 0x004e, /* Ꞥ → N */
  /* 0xa7a5 */ 0x006e, /* ꞥ → n */
  /* 0xa7a6 */ 0x0052, /* Ꞧ → R */
  /* 0xa7a7 */ 0x0072, /* ꞧ → r */
  /* 0xa7a8 */ 0x0053, /* Ꞩ → S */
  /* 0xa7a9 */ 0x0073, /* ꞩ → s */
  /* 0xa7aa */ 0x0048, /* Ɦ → H */
  /* 0xfb1d */ 0x05d9, /* יִ → י */
  /* 0xfb1e */ 0xfb1e,
  /* 0xfb1f */ 0x05f2, /* ײַ → ײ */
  /* 0xfb20 */ 0xfb20,
  /* 0xfb21 */ 0xfb21,
  /* 0xfb22 */ 0xfb22,
  /* 0xfb23 */ 0xfb23,
  /* 0xfb24 */ 0xfb24,
  /* 0xfb25 */ 0xfb25,
  /* 0xfb26 */ 0xfb26,
  /* 0xfb27 */ 0xfb27,
  /* 0xfb28 */ 0xfb28,
  /* 0xfb29 */ 0xfb29,
  /* 0xfb2a */ 0x05e9, /* שׁ → ש */
  /* 0xfb2b */ 0x05e9, /* שׂ → ש */
  /* 0xfb2c */ 0x05e9, /* שּׁ → ש */
  /* 0xfb2d */ 0x05e9, /* שּׂ → ש */
  /* 0xfb2e */ 0x05d0, /* אַ → א */
  /* 0xfb2f */ 0x05d0, /* אָ → א */
  /* 0xfb30 */ 0x05d0, /* אּ → א */
  /* 0xfb31 */ 0x05d1, /* בּ → ב */
  /* 0xfb32 */ 0x05d2, /* גּ → ג */
  /* 0xfb33 */ 0x05d3, /* דּ → ד */
  /* 0xfb34 */ 0x05d4, /* הּ → ה */
  /* 0xfb35 */ 0x05d5, /* וּ → ו */
  /* 0xfb36 */ 0x05d6, /* זּ → ז */
  /* 0xfb37 */ 0xfb37,
  /* 0xfb38 */ 0x05d8, /* טּ → ט */
  /* 0xfb39 */ 0x05d9, /* יּ → י */
  /* 0xfb3a */ 0x05da, /* ךּ → ך */
  /* 0xfb3b */ 0x05db, /* כּ → כ */
  /* 0xfb3c */ 0x05dc, /* לּ → ל */
  /* 0xfb3d */ 0xfb3d,
  /* 0xfb3e */ 0x05de, /* מּ → מ */
  /* 0xfb3f */ 0xfb3f,
  /* 0xfb40 */ 0x05e0, /* נּ → נ */
  /* 0xfb41 */ 0x05e1, /* סּ → ס */
  /* 0xfb42 */ 0xfb42,
  /* 0xfb43 */ 0x05e3, /* ףּ → ף */
  /* 0xfb44 */ 0x05e4, /* פּ → פ */
  /* 0xfb45 */ 0xfb45,
  /* 0xfb46 */ 0x05e6, /* צּ → צ */
  /* 0xfb47 */ 0x05e7, /* קּ → ק */
  /* 0xfb48 */ 0x05e8, /* רּ → ר */
  /* 0xfb49 */ 0x05e9, /* שּ → ש */
  /* 0xfb4a */ 0x05ea, /* תּ → ת */
  /* 0xfb4b */ 0x05d5, /* וֹ → ו */
  /* 0xfb4c */ 0x05d1, /* בֿ → ב */
  /* 0xfb4d */ 0x05db, /* כֿ → כ */
  /* 0xfb4e */ 0x05e4, /* פֿ → פ */
  /* 0xfe10 */ 0x002c, /* ︐ → , */
  /* 0xfe11 */ 0x002c, /* ︑ → , */
  /* 0xfe12 */ 0x002e, /* ︒ → . */
  /* 0xfe13 */ 0x003a, /* ︓ → : */
  /* 0xfe14 */ 0x003b, /* ︔ → ; */
  /* 0xfe15 */ 0x0021, /* ︕ → ! */
  /* 0xfe16 */ 0x003f, /* ︖ → ? */
  /* 0xfe17 */ 0xfe17,
  /* 0xfe18 */ 0xfe18,
  /* 0xfe19 */ 0xfe19,
  /* 0xfe1a */ 0xfe1a,
  /* 0xfe1b */ 0xfe1b,
  /* 0xfe1c */ 0xfe1c,
  /* 0xfe1d */ 0xfe1d,
  /* 0xfe1e */ 0xfe1e,
  /* 0xfe1f */ 0xfe1f,
  /* 0xfe20 */ 0xfe20,
  /* 0xfe21 */ 0xfe21,
  /* 0xfe22 */ 0xfe22,
  /* 0xfe23 */ 0xfe23,
  /* 0xfe24 */ 0xfe24,
  /* 0xfe25 */ 0xfe25,
  /* 0xfe26 */ 0xfe26,
  /* 0xfe27 */ 0xfe27,
  /* 0xfe28 */ 0xfe28,
  /* 0xfe29 */ 0xfe29,
  /* 0xfe2a */ 0xfe2a,
  /* 0xfe2b */ 0xfe2b,
  /* 0xfe2c */ 0xfe2c,
  /* 0xfe2d */ 0xfe2d,
  /* 0xfe2e */ 0xfe2e,
  /* 0xfe2f */ 0xfe2f,
  /* 0xfe30 */ 0xfe30,
  /* 0xfe31 */ 0x002d, /* ︱ → - */
  /* 0xfe32 */ 0x002d, /* ︲ → - */
  /* 0xfe33 */ 0xfe33,
  /* 0xfe34 */ 0xfe34,
  /* 0xfe35 */ 0x0028, /* ︵ → ( */
  /* 0xfe36 */ 0x0029, /* ︶ → ) */
  /* 0xfe37 */ 0x007b, /* ︷ → { */
  /* 0xfe38 */ 0x007d, /* ︸ → } */
  /* 0xfe39 */ 0x005b, /* ︹ → [ */
  /* 0xfe3a */ 0x005d, /* ︺ → ] */
  /* 0xfe3b */ 0xfe3b,
  /* 0xfe3c */ 0xfe3c,
  /* 0xfe3d */ 0xfe3d,
  /* 0xfe3e */ 0xfe3e,
  /* 0xfe3f */ 0x003c, /* ︿ → < */
  /* 0xfe40 */ 0x003e, /* ﹀ → > */
  /* 0xfe41 */ 0xfe41,
  /* 0xfe42 */ 0xfe42,
  /* 0xfe43 */ 0xfe43,
  /* 0xfe44 */ 0xfe44,
  /* 0xfe45 */ 0xfe45,
  /* 0xfe46 */ 0xfe46,
  /* 0xfe47 */ 0x005b, /* ﹇ → [ */
  /* 0xfe48 */ 0x005d, /* ﹈ → ] */
  /* 0xfe49 */ 0xfe49,
  /* 0xfe4a */ 0xfe4a,
  /* 0xfe4b */ 0xfe4b,
  /* 0xfe4c */ 0xfe4c,
  /* 0xfe4d */ 0xfe4d,
  /* 0xfe4e */ 0xfe4e,
  /* 0xfe4f */ 0xfe4f,
  /* 0xfe50 */ 0x002c, /* ﹐ → , */
  /* 0xfe51 */ 0x002c, /* ﹑ → , */
  /* 0xfe52 */ 0x002e, /* ﹒ → . */
  /* 0xfe53 */ 0xfe53,
  /* 0xfe54 */ 0x003b, /* ﹔ → ; */
  /* 0xfe55 */ 0x003a, /* ﹕ → : */
  /* 0xfe56 */ 0x003f, /* ﹖ → ? */
  /* 0xfe57 */ 0x0021, /* ﹗ → ! */
  /* 0xfe58 */ 0x002d, /* ﹘ → - */
  /* 0xfe59 */ 0x0028, /* ﹙ → ( */
  /* 0xfe5a */ 0x0029, /* ﹚ → ) */
  /* 0xfe5b */ 0x007b, /* ﹛ → { */
  /* 0xfe5c */ 0x007d, /* ﹜ → } */
  /* 0xfe5d */ 0x005b, /* ﹝ → [ */
  /* 0xfe5e */ 0x005d, /* ﹞ → ] */
  /* 0xfe5f */ 0x0023, /* ﹟ → # */
  /* 0xfe60 */ 0x0026, /* ﹠ → & */
  /* 0xfe61 */ 0x002a, /* ﹡ → * */
  /* 0xfe62 */ 0x002b, /* ﹢ → + */
  /* 0xfe63 */ 0x002d, /* ﹣ → - */
  /* 0xfe64 */ 0x003c, /* ﹤ → < */
  /* 0xfe65 */ 0x003e, /* ﹥ → > */
  /* 0xfe66 */ 0x003d, /* ﹦ → = */
  /* 0xfe67 */ 0xfe67,
  /* 0xfe68 */ 0x005c, /* ﹨ → \ */
  /* 0xfe69 */ 0x0024, /* ﹩ → $ */
  /* 0xfe6a */ 0x0025, /* ﹪ → % */
  /* 0xfe6b */ 0x0040, /* ﹫ → @ */
  /* 0xff01 */ 0x0021, /* ！ → ! */
  /* 0xff02 */ 0x0022, /* ＂ → " */
  /* 0xff03 */ 0x0023, /* ＃ → # */
  /* 0xff04 */ 0x0024, /* ＄ → $ */
  /* 0xff05 */ 0x0025, /* ％ → % */
  /* 0xff06 */ 0x0026, /* ＆ → & */
  /* 0xff07 */ 0x0027, /* ＇ → ' */
  /* 0xff08 */ 0x0028, /* （ → ( */
  /* 0xff09 */ 0x0029, /* ） → ) */
  /* 0xff0a */ 0x002a, /* ＊ → * */
  /* 0xff0b */ 0x002b, /* ＋ → + */
  /* 0xff0c */ 0x002c, /* ， → , */
  /* 0xff0d */ 0x002d, /* － → - */
  /* 0xff0e */ 0x002e, /* ． → . */
  /* 0xff0f */ 0x002f, /* ／ → / */
  /* 0xff10 */ 0x0030, /* ０ → 0 */
  /* 0xff11 */ 0x0031, /* １ → 1 */
  /* 0xff12 */ 0x0032, /* ２ → 2 */
  /* 0xff13 */ 0x0033, /* ３ → 3 */
  /* 0xff14 */ 0x0034, /* ４ → 4 */
  /* 0xff15 */ 0x0035, /* ５ → 5 */
  /* 0xff16 */ 0x0036, /* ６ → 6 */
  /* 0xff17 */ 0x0037, /* ７ → 7 */
  /* 0xff18 */ 0x0038, /* ８ → 8 */
  /* 0xff19 */ 0x0039, /* ９ → 9 */
  /* 0xff1a */ 0x003a, /* ： → : */
  /* 0xff1b */ 0x003b, /* ； → ; */
  /* 0xff1c */ 0x003c, /* ＜ → < */
  /* 0xff1d */ 0x003d, /* ＝ → = */
  /* 0xff1e */ 0x003e, /* ＞ → > */
  /* 0xff1f */ 0x003f, /* ？ → ? */
  /* 0xff20 */ 0x0040, /* ＠ → @ */
  /* 0xff21 */ 0x0041, /* Ａ → A */
  /* 0xff22 */ 0x0042, /* Ｂ → B */
  /* 0xff23 */ 0x0043, /* Ｃ → C */
  /* 0xff24 */ 0x0044, /* Ｄ → D */
  /* 0xff25 */ 0x0045, /* Ｅ → E */
  /* 0xff26 */ 0x0046, /* Ｆ → F */
  /* 0xff27 */ 0x0047, /* Ｇ → G */
  /* 0xff28 */ 0x0048, /* Ｈ → H */
  /* 0xff29 */ 0x0049, /* Ｉ → I */
  /* 0xff2a */ 0x004a, /* Ｊ → J */
  /* 0xff2b */ 0x004b, /* Ｋ → K */
  /* 0xff2c */ 0x004c, /* Ｌ → L */
  /* 0xff2d */ 0x004d, /* Ｍ → M */
  /* 0xff2e */ 0x004e, /* Ｎ → N */
  /* 0xff2f */ 0x004f, /* Ｏ → O */
  /* 0xff30 */ 0x0050, /* Ｐ → P */
  /* 0xff31 */ 0x0051, /* Ｑ → Q */
  /* 0xff32 */ 0x0052, /* Ｒ → R */
  /* 0xff33 */ 0x0053, /* Ｓ → S */
  /* 0xff34 */ 0x0054, /* Ｔ → T */
  /* 0xff35 */ 0x0055, /* Ｕ → U */
  /* 0xff36 */ 0x0056, /* Ｖ → V */
  /* 0xff37 */ 0x0057, /* Ｗ → W */
  /* 0xff38 */ 0x0058, /* Ｘ → X */
  /* 0xff39 */ 0x0059, /* Ｙ → Y */
  /* 0xff3a */ 0x005a, /* Ｚ → Z */
  /* 0xff3b */ 0x005b, /* ［ → [ */
  /* 0xff3c */ 0x005c, /* ＼ → \ */
  /* 0xff3d */ 0x005d, /* ］ → ] */
  /* 0xff3e */ 0x005e, /* ＾ → ^ */
  /* 0xff3f */ 0x005f, /* ＿ → _ */
  /* 0xff40 */ 0x0060, /* ｀ → ` */
  /* 0xff41 */ 0x0061, /* ａ → a */
  /* 0xff42 */ 0x0062, /* ｂ → b */
  /* 0xff43 */ 0x0063, /* ｃ → c */
  /* 0xff44 */ 0x0064, /* ｄ → d */
  /* 0xff45 */ 0x0065, /* ｅ → e */
  /* 0xff46 */ 0x0066, /* ｆ → f */
  /* 0xff47 */ 0x0067, /* ｇ → g */
  /* 0xff48 */ 0x0068, /* ｈ → h */
  /* 0xff49 */ 0x0069, /* ｉ → i */
  /* 0xff4a */ 0x006a, /* ｊ → j */
  /* 0xff4b */ 0x006b, /* ｋ → k */
  /* 0xff4c */ 0x006c, /* ｌ → l */
  /* 0xff4d */ 0x006d, /* ｍ → m */
  /* 0xff4e */ 0x006e, /* ｎ → n */
  /* 0xff4f */ 0x006f, /* ｏ → o */
  /* 0xff50 */ 0x0070, /* ｐ → p */
  /* 0xff51 */ 0x0071, /* ｑ → q */
  /* 0xff52 */ 0x0072, /* ｒ → r */
  /* 0xff53 */ 0x0073, /* ｓ → s */
  /* 0xff54 */ 0x0074, /* ｔ → t */
  /* 0xff55 */ 0x0075, /* ｕ → u */
  /* 0xff56 */ 0x0076, /* ｖ → v */
  /* 0xff57 */ 0x0077, /* ｗ → w */
  /* 0xff58 */ 0x0078, /* ｘ → x */
  /* 0xff59 */ 0x0079, /* ｙ → y */
  /* 0xff5a */ 0x007a, /* ｚ → z */
  /* 0xff5b */ 0x007b, /* ｛ → { */
  /* 0xff5c */ 0x007c, /* ｜ → | */
  /* 0xff5d */ 0x007d, /* ｝ → } */
  /* 0xff5e */ 0x007e, /* ～ → ~ */
  /* 0xff5f */ 0xff5f,
  /* 0xff60 */ 0xff60,
  /* 0xff61 */ 0x002e, /* ｡ → . */
  /* 0xff62 */ 0xff62,
  /* 0xff63 */ 0xff63,
  /* 0xff64 */ 0x002c, /* ､ → , */
  /* 0x105c9 */ 0x05d2, /* 𐗉 → 𐗒 */
  /* 0x105ca */ 0x05ca,
  /* 0x105cb */ 0x05cb,
  /* 0x105cc */ 0x05cc,
  /* 0x105cd */ 0x05cd,
  /* 0x105ce */ 0x05ce,
  /* 0x105cf */ 0x05cf,
  /* 0x105d0 */ 0x05d0,
  /* 0x105d1 */ 0x05d1,
  /* 0x105d2 */ 0x05d2,
  /* 0x105d3 */ 0x05d3,
  /* 0x105d4 */ 0x05d4,
  /* 0x105d5 */ 0x05d5,
  /* 0x105d6 */ 0x05d6,
  /* 0x105d7 */ 0x05d7,
  /* 0x105d8 */ 0x05d8,
  /* 0x105d9 */ 0x05d9,
  /* 0x105da */ 0x05da,
  /* 0x105db */ 0x05db,
  /* 0x105dc */ 0x05dc,
  /* 0x105dd */ 0x05dd,
  /* 0x105de */ 0x05de,
  /* 0x105df */ 0x05df,
  /* 0x105e0 */ 0x05e0,
  /* 0x105e1 */ 0x05e1,
  /* 0x105e2 */ 0x05e2,
  /* 0x105e3 */ 0x05e3,
  /* 0x105e4 */ 0x05da, /* 𐗤 → 𐗚 */
  /* 0x1109a */ 0x1099, /* 𑂚 → 𑂙 */
  /* 0x1109b */ 0x109b,
  /* 0x1109c */ 0x109b, /* 𑂜 → 𑂛 */
  /* 0x1109d */ 0x109d,
  /* 0x1109e */ 0x109e,
  /* 0x1109f */ 0x109f,
  /* 0x110a0 */ 0x10a0,
  /* 0x110a1 */ 0x10a1,
  /* 0x110a2 */ 0x10a2,
  /* 0x110a3 */ 0x10a3,
  /* 0x110a4 */ 0x10a4,
  /* 0x110a5 */ 0x10a5,
  /* 0x110a6 */ 0x10a6,
  /* 0x110a7 */ 0x10a7,
  /* 0x110a8 */ 0x10a8,
  /* 0x110a9 */ 0x10a9,
  /* 0x110aa */ 0x10aa,
  /* 0x110ab */ 0x10a5, /* 𑂫 → 𑂥 */
};

static const struct BaseCharMappingBlock BASE_CHAR_MAPPING_BLOCKS[] = {
  {0xa1, 0xff,    0}, // 0x00xx
  {0x00, 0xff,   95}, // 0x01xx
  {0x00, 0xdc,  351}, // 0x02xx
  {0x85, 0xd4,  572}, // 0x03xx
  {0x00, 0xf9,  652}, // 0x04xx
  {0x22, 0xd3,  902}, // 0x06xx
  {0x29, 0xdf, 1080}, // 0x09xx
  {0x33, 0x5e, 1263}, // 0x0axx
  {0x5c, 0x5d, 1307}, // 0x0bxx
  {0x00, 0x99, 1309}, // 0x1dxx
  {0x00, 0xff, 1463}, // 0x1exx
  {0x00, 0xfc, 1719}, // 0x1fxx
  {0x10, 0x4e, 1972}, // 0x20xx
  {0x02, 0x7f, 2035}, // 0x21xx
  {0x12, 0x23, 2161}, // 0x22xx
  {0x60, 0x7f, 2179}, // 0x2cxx
  {0x01, 0x1e, 2211}, // 0x30xx
  {0x30, 0xaa, 2241}, // 0xa7xx
  {0x1d, 0x4e, 2364}, // 0xfbxx
  {0x10, 0x6b, 2414}, // 0xfexx
  {0x01, 0x64, 2506}, // 0xffxx
  {0xc9, 0xe4, 2606}, // 0x105xx
  {0x9a, 0xab, 2634}, // 0x110xx
};

static const uint8_t BASE_CHAR_MAPPING_BLOCK_INDEX[] = {
    0, // 0x00xx
    1, // 0x01xx
    2, // 0x02xx
    3, // 0x03xx
    4, // 0x04xx
  255, // 0x05xx
    5, // 0x06xx
  255, // 0x07xx
  255, // 0x08xx
    6, // 0x09xx
    7, // 0x0axx
    8, // 0x0bxx
  255, // 0x0cxx
  255, // 0x0dxx
  255, // 0x0exx
  255, // 0x0fxx
  255, // 0x10xx
  255, // 0x11xx
  255, // 0x12xx
  255, // 0x13xx
  255, // 0x14xx
  255, // 0x15xx
  255, // 0x16xx
  255, // 0x17xx
  255, // 0x18xx
  255, // 0x19xx
  255, // 0x1axx
  255, // 0x1bxx
  255, // 0x1cxx
    9, // 0x1dxx
   10, // 0x1exx
   11, // 0x1fxx
   12, // 0x20xx
   13, // 0x21xx
   14, // 0x22xx
  255, // 0x23xx
  255, // 0x24xx
  255, // 0x25xx
  255, // 0x26xx
  255, // 0x27xx
  255, // 0x28xx
  255, // 0x29xx
  255, // 0x2axx
  255, // 0x2bxx
   15, // 0x2cxx
  255, // 0x2dxx
  255, // 0x2exx
  255, // 0x2fxx
   16, // 0x30xx
  255, // 0x31xx
  255, // 0x32xx
  255, // 0x33xx
  255, // 0x34xx
  255, // 0x35xx
  255, // 0x36xx
  255, // 0x37xx
  255, // 0x38xx
  255, // 0x39xx
  255, // 0x3axx
  255, // 0x3bxx
  255, // 0x3cxx
  255, // 0x3dxx
  255, // 0x3exx
  255, // 0x3fxx
  255, // 0x40xx
  255, // 0x41xx
  255, // 0x42xx
  255, // 0x43xx
  255, // 0x44xx
  255, // 0x45xx
  255, // 0x46xx
  255, // 0x47xx
  255, // 0x48xx
  255, // 0x49xx
  255, // 0x4axx
  255, // 0x4bxx
  255, // 0x4cxx
  255, // 0x4dxx
  255, // 0x4exx
  255, // 0x4fxx
  255, // 0x50xx
  255, // 0x51xx
  255, // 0x52xx
  255, // 0x53xx
  255, // 0x54xx
  255, // 0x55xx
  255, // 0x56xx
  255, // 0x57xx
  255, // 0x58xx
  255, // 0x59xx
  255, // 0x5axx
  255, // 0x5bxx
  255, // 0x5cxx
  255, // 0x5dxx
  255, // 0x5exx
  255, // 0x5fxx
  255, // 0x60xx
  255, // 0x61xx
  255, // 0x62xx
  255, // 0x63xx
  255, // 0x64xx
  255, // 0x65xx
  255, // 0x66xx
  255, // 0x67xx
  255, // 0x68xx
  255, // 0x69xx
  255, // 0x6axx
  255, // 0x6bxx
  255, // 0x6cxx
  255, // 0x6dxx
  255, // 0x6exx
  255, // 0x6fxx
  255, // 0x70xx
  255, // 0x71xx
  255, // 0x72xx
  255, // 0x73xx
  255, // 0x74xx
  255, // 0x75xx
  255, // 0x76xx
  255, // 0x77xx
  255, // 0x78xx
  255, // 0x79xx
  255, // 0x7axx
  255, // 0x7bxx
  255, // 0x7cxx
  255, // 0x7dxx
  255, // 0x7exx
  255, // 0x7fxx
  255, // 0x80xx
  255, // 0x81xx
  255, // 0x82xx
  255, // 0x83xx
  255, // 0x84xx
  255, // 0x85xx
  255, // 0x86xx
  255, // 0x87xx
  255, // 0x88xx
  255, // 0x89xx
  255, // 0x8axx
  255, // 0x8bxx
  255, // 0x8cxx
  255, // 0x8dxx
  255, // 0x8exx
  255, // 0x8fxx
  255, // 0x90xx
  255, // 0x91xx
  255, // 0x92xx
  255, // 0x93xx
  255, // 0x94xx
  255, // 0x95xx
  255, // 0x96xx
  255, // 0x97xx
  255, // 0x98xx
  255, // 0x99xx
  255, // 0x9axx
  255, // 0x9bxx
  255, // 0x9cxx
  255, // 0x9dxx
  255, // 0x9exx
  255, // 0x9fxx
  255, // 0xa0xx
  255, // 0xa1xx
  255, // 0xa2xx
  255, // 0xa3xx
  255, // 0xa4xx
  255, // 0xa5xx
  255, // 0xa6xx
   17, // 0xa7xx
  255, // 0xa8xx
  255, // 0xa9xx
  255, // 0xaaxx
  255, // 0xabxx
  255, // 0xacxx
  255, // 0xadxx
  255, // 0xaexx
  255, // 0xafxx
  255, // 0xb0xx
  255, // 0xb1xx
  255, // 0xb2xx
  255, // 0xb3xx
  255, // 0xb4xx
  255, // 0xb5xx
  255, // 0xb6xx
  255, // 0xb7xx
  255, // 0xb8xx
  255, // 0xb9xx
  255, // 0xbaxx
  255, // 0xbbxx
  255, // 0xbcxx
  255, // 0xbdxx
  255, // 0xbexx
  255, // 0xbfxx
  255, // 0xc0xx
  255, // 0xc1xx
  255, // 0xc2xx
  255, // 0xc3xx
  255, // 0xc4xx
  255, // 0xc5xx
  255, // 0xc6xx
  255, // 0xc7xx
  255, // 0xc8xx
  255, // 0xc9xx
  255, // 0xcaxx
  255, // 0xcbxx
  255, // 0xccxx
  255, // 0xcdxx
  255, // 0xcexx
  255, // 0xcfxx
  255, // 0xd0xx
  255, // 0xd1xx
  255, // 0xd2xx
  255, // 0xd3xx
  255, // 0xd4xx
  255, // 0xd5xx
  255, // 0xd6xx
  255, // 0xd7xx
  255, // 0xd8xx
  255, // 0xd9xx
  255, // 0xdaxx
  255, // 0xdbxx
  255, // 0xdcxx
  255, // 0xddxx
  255, // 0xdexx
  255, // 0xdfxx
  255, // 0xe0xx
  255, // 0xe1xx
  255, // 0xe2xx
  255, // 0xe3xx
  255, // 0xe4xx
  255, // 0xe5xx
  255, // 0xe6xx
  255, // 0xe7xx
  255, // 0xe8xx
  255, // 0xe9xx
  255, // 0xeaxx
  255, // 0xebxx
  255, // 0xecxx
  255, // 0xedxx
  255, // 0xeexx
  255, // 0xefxx
  255, // 0xf0xx
  255, // 0xf1xx
  255, // 0xf2xx
  255, // 0xf3xx
  255, // 0xf4xx
  255, // 0xf5xx
  255, // 0xf6xx
  255, // 0xf7xx
  255, // 0xf8xx
  255, // 0xf9xx
  255, // 0xfaxx
   18, // 0xfbxx
  255, // 0xfcxx
  255, // 0xfdxx
   19, // 0xfexx
   20, // 0xffxx
  255, // 0x100xx
  255, // 0x101xx
  255, // 0x102xx
  255, // 0x103xx
  255, // 0x104xx
   21, // 0x105xx
  255, // 0x106xx
  255, // 0x107xx
  255, // 0x108xx
  255, // 0x109xx
  255, // 0x10axx
  255, // 0x10bxx
  255, // 0x10cxx
  255, // 0x10dxx
  255, // 0x10exx
  255, // 0x10fxx
   22, // 0x110xx
};
