// -*- mode: C++ -*-

// AUTOGENERATED BY glean_parser.  DO NOT EDIT.

/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#ifndef mozilla_GleanDomMediaEmeMetrics_h
#define mozilla_GleanDomMediaEmeMetrics_h

#include "mozilla/glean/bindings/MetricTypes.h"

namespace mozilla::glean {

namespace mediadrm {
  /**
   * generated from mediadrm.decryption
   */
  enum class DecryptionLabel: uint16_t {
    eHasHardwareDecryption = 0,
    eHasHardwareClearlead = 1,
    eHasSoftwareClearlead = 2,
    eHasWmf = 3,
    e__Other__,
  };
  /**
   * Record the statuses related with the media decryption.
   */
  constexpr impl::Labeled<impl::BooleanMetric, DecryptionLabel> decryption(3740);

  /**
   * generated from mediadrm.eme_playback
   */
  struct EmePlaybackExtra {
    mozilla::Maybe<nsCString> keySystem;
    mozilla::Maybe<uint32_t> playedTime;
    mozilla::Maybe<nsCString> resolution;
    mozilla::Maybe<nsCString> videoCodec;

    std::tuple<nsTArray<nsCString>, nsTArray<nsCString>> ToFfiExtra() const {
      nsTArray<nsCString> extraKeys;
      nsTArray<nsCString> extraValues;
      if (keySystem) {
        extraKeys.AppendElement()->AssignASCII("key_system");
        extraValues.EmplaceBack(keySystem.value());
      }
      if (playedTime) {
        extraKeys.AppendElement()->AssignASCII("played_time");
        extraValues.AppendElement()->AppendInt(playedTime.value());
      }
      if (resolution) {
        extraKeys.AppendElement()->AssignASCII("resolution");
        extraValues.EmplaceBack(resolution.value());
      }
      if (videoCodec) {
        extraKeys.AppendElement()->AssignASCII("video_codec");
        extraValues.EmplaceBack(videoCodec.value());
      }
      return std::make_tuple(std::move(extraKeys), std::move(extraValues));
    }
  };
  /**
   * Record the EME play time with the video codec and resolutions.
   */
  constexpr impl::EventMetric<EmePlaybackExtra> eme_playback(3741);
}

} // namespace mozilla::glean

#endif // mozilla_GleanDomMediaEmeMetrics_h
