/*
 * This file is autogenerated, see util/species-gen.py and dat/species/ for
 * more info.
 */
#pragma once

#include "enum.h"

static const species_skill_aptitude species_skill_aptitudes[] =
{

    {SP_HUMAN, SK_FIGHTING,       0},
    {SP_HUMAN, SK_SHORT_BLADES,   0},
    {SP_HUMAN, SK_LONG_BLADES,    0},
    {SP_HUMAN, SK_AXES,           0},
    {SP_HUMAN, SK_MACES_FLAILS,   0},
    {SP_HUMAN, SK_POLEARMS,       0},
    {SP_HUMAN, SK_STAVES,         0},
    {SP_HUMAN, SK_RANGED_WEAPONS, 0},
    {SP_HUMAN, SK_THROWING,       0},
    {SP_HUMAN, SK_ARMOUR,         0},
    {SP_HUMAN, SK_DODGING,        0},
    {SP_HUMAN, SK_STEALTH,        1},
    {SP_HUMAN, SK_SHIELDS,        0},
    {SP_HUMAN, SK_UNARMED_COMBAT, 0},
    {SP_HUMAN, SK_SPELLCASTING,   -1},
    {SP_HUMAN, SK_CONJURATIONS,   0},
    {SP_HUMAN, SK_HEXES,          0},
    {SP_HUMAN, SK_SUMMONINGS,     0},
    {SP_HUMAN, SK_NECROMANCY,     0},
    {SP_HUMAN, SK_FORGECRAFT,     0},
    {SP_HUMAN, SK_TRANSLOCATIONS, 0},
    {SP_HUMAN, SK_FIRE_MAGIC,     0},
    {SP_HUMAN, SK_ICE_MAGIC,      0},
    {SP_HUMAN, SK_AIR_MAGIC,      0},
    {SP_HUMAN, SK_EARTH_MAGIC,    0},
    {SP_HUMAN, SK_ALCHEMY,        0},
    {SP_HUMAN, SK_INVOCATIONS,    1},
    {SP_HUMAN, SK_EVOCATIONS,     0},
    {SP_HUMAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_HUMAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_HUMAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_HUMAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_HUMAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_HUMAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif

#if TAG_MAJOR_VERSION == 34
    {SP_HIGH_ELF, SK_FIGHTING,       0},
    {SP_HIGH_ELF, SK_SHORT_BLADES,   2},
    {SP_HIGH_ELF, SK_LONG_BLADES,    2},
    {SP_HIGH_ELF, SK_AXES,           -2},
    {SP_HIGH_ELF, SK_MACES_FLAILS,   -2},
    {SP_HIGH_ELF, SK_POLEARMS,       -2},
    {SP_HIGH_ELF, SK_STAVES,         0},
    {SP_HIGH_ELF, SK_RANGED_WEAPONS, 3},
    {SP_HIGH_ELF, SK_THROWING,       0},
    {SP_HIGH_ELF, SK_ARMOUR,         -1},
    {SP_HIGH_ELF, SK_DODGING,        1},
    {SP_HIGH_ELF, SK_STEALTH,        2},
    {SP_HIGH_ELF, SK_SHIELDS,        -1},
    {SP_HIGH_ELF, SK_UNARMED_COMBAT, -2},
    {SP_HIGH_ELF, SK_SPELLCASTING,   1},
    {SP_HIGH_ELF, SK_CONJURATIONS,   1},
    {SP_HIGH_ELF, SK_HEXES,          0},
    {SP_HIGH_ELF, SK_SUMMONINGS,     -1},
    {SP_HIGH_ELF, SK_NECROMANCY,     -2},
    {SP_HIGH_ELF, SK_FORGECRAFT,     0},
    {SP_HIGH_ELF, SK_TRANSLOCATIONS, 1},
    {SP_HIGH_ELF, SK_FIRE_MAGIC,     0},
    {SP_HIGH_ELF, SK_ICE_MAGIC,      0},
    {SP_HIGH_ELF, SK_AIR_MAGIC,      2},
    {SP_HIGH_ELF, SK_EARTH_MAGIC,    -2},
    {SP_HIGH_ELF, SK_ALCHEMY,        -2},
    {SP_HIGH_ELF, SK_INVOCATIONS,    1},
    {SP_HIGH_ELF, SK_EVOCATIONS,     0},
    {SP_HIGH_ELF, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_HIGH_ELF, SK_STABBING,       UNUSABLE_SKILL},
    {SP_HIGH_ELF, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_HIGH_ELF, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_HIGH_ELF, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_HIGH_ELF, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif

    {SP_DEEP_ELF, SK_FIGHTING,       -2},
    {SP_DEEP_ELF, SK_SHORT_BLADES,   0},
    {SP_DEEP_ELF, SK_LONG_BLADES,    -1},
    {SP_DEEP_ELF, SK_AXES,           -2},
    {SP_DEEP_ELF, SK_MACES_FLAILS,   -3},
    {SP_DEEP_ELF, SK_POLEARMS,       -3},
    {SP_DEEP_ELF, SK_STAVES,         0},
    {SP_DEEP_ELF, SK_RANGED_WEAPONS, 3},
    {SP_DEEP_ELF, SK_THROWING,       0},
    {SP_DEEP_ELF, SK_ARMOUR,         -2},
    {SP_DEEP_ELF, SK_DODGING,        2},
    {SP_DEEP_ELF, SK_STEALTH,        3},
    {SP_DEEP_ELF, SK_SHIELDS,        -2},
    {SP_DEEP_ELF, SK_UNARMED_COMBAT, -2},
    {SP_DEEP_ELF, SK_SPELLCASTING,   3},
    {SP_DEEP_ELF, SK_CONJURATIONS,   1},
    {SP_DEEP_ELF, SK_HEXES,          3},
    {SP_DEEP_ELF, SK_SUMMONINGS,     1},
    {SP_DEEP_ELF, SK_NECROMANCY,     2},
    {SP_DEEP_ELF, SK_FORGECRAFT,     1},
    {SP_DEEP_ELF, SK_TRANSLOCATIONS, 1},
    {SP_DEEP_ELF, SK_FIRE_MAGIC,     1},
    {SP_DEEP_ELF, SK_ICE_MAGIC,      1},
    {SP_DEEP_ELF, SK_AIR_MAGIC,      1},
    {SP_DEEP_ELF, SK_EARTH_MAGIC,    1},
    {SP_DEEP_ELF, SK_ALCHEMY,        1},
    {SP_DEEP_ELF, SK_INVOCATIONS,    1},
    {SP_DEEP_ELF, SK_EVOCATIONS,     1},
    {SP_DEEP_ELF, SK_SHAPESHIFTING,  0},
#if TAG_MAJOR_VERSION == 34
    {SP_DEEP_ELF, SK_STABBING,       UNUSABLE_SKILL},
    {SP_DEEP_ELF, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_DEEP_ELF, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_DEEP_ELF, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_DEEP_ELF, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif

#if TAG_MAJOR_VERSION == 34
    {SP_SLUDGE_ELF, SK_FIGHTING,       1},
    {SP_SLUDGE_ELF, SK_SHORT_BLADES,   -1},
    {SP_SLUDGE_ELF, SK_LONG_BLADES,    -1},
    {SP_SLUDGE_ELF, SK_AXES,           -2},
    {SP_SLUDGE_ELF, SK_MACES_FLAILS,   -2},
    {SP_SLUDGE_ELF, SK_POLEARMS,       -2},
    {SP_SLUDGE_ELF, SK_STAVES,         0},
    {SP_SLUDGE_ELF, SK_RANGED_WEAPONS, 0},
    {SP_SLUDGE_ELF, SK_THROWING,       0},
    {SP_SLUDGE_ELF, SK_ARMOUR,         -2},
    {SP_SLUDGE_ELF, SK_DODGING,        2},
    {SP_SLUDGE_ELF, SK_STEALTH,        2},
    {SP_SLUDGE_ELF, SK_SHIELDS,        -2},
    {SP_SLUDGE_ELF, SK_UNARMED_COMBAT, 1},
    {SP_SLUDGE_ELF, SK_SPELLCASTING,   1},
    {SP_SLUDGE_ELF, SK_CONJURATIONS,   -2},
    {SP_SLUDGE_ELF, SK_HEXES,          0},
    {SP_SLUDGE_ELF, SK_SUMMONINGS,     1},
    {SP_SLUDGE_ELF, SK_NECROMANCY,     1},
    {SP_SLUDGE_ELF, SK_FORGECRAFT,     0},
    {SP_SLUDGE_ELF, SK_TRANSLOCATIONS, 0},
    {SP_SLUDGE_ELF, SK_FIRE_MAGIC,     1},
    {SP_SLUDGE_ELF, SK_ICE_MAGIC,      1},
    {SP_SLUDGE_ELF, SK_AIR_MAGIC,      1},
    {SP_SLUDGE_ELF, SK_EARTH_MAGIC,    1},
    {SP_SLUDGE_ELF, SK_ALCHEMY,        1},
    {SP_SLUDGE_ELF, SK_INVOCATIONS,    1},
    {SP_SLUDGE_ELF, SK_EVOCATIONS,     0},
    {SP_SLUDGE_ELF, SK_SHAPESHIFTING,  1},
#if TAG_MAJOR_VERSION == 34
    {SP_SLUDGE_ELF, SK_STABBING,       UNUSABLE_SKILL},
    {SP_SLUDGE_ELF, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_SLUDGE_ELF, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_SLUDGE_ELF, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_SLUDGE_ELF, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif
#if TAG_MAJOR_VERSION == 34
    {SP_HALFLING, SK_FIGHTING,       -1},
    {SP_HALFLING, SK_SHORT_BLADES,   2},
    {SP_HALFLING, SK_LONG_BLADES,    0},
    {SP_HALFLING, SK_AXES,           0},
    {SP_HALFLING, SK_MACES_FLAILS,   -1},
    {SP_HALFLING, SK_POLEARMS,       -1},
    {SP_HALFLING, SK_STAVES,         -2},
    {SP_HALFLING, SK_RANGED_WEAPONS, 3},
    {SP_HALFLING, SK_THROWING,       0},
    {SP_HALFLING, SK_ARMOUR,         1},
    {SP_HALFLING, SK_DODGING,        1},
    {SP_HALFLING, SK_STEALTH,        2},
    {SP_HALFLING, SK_SHIELDS,        1},
    {SP_HALFLING, SK_UNARMED_COMBAT, -2},
    {SP_HALFLING, SK_SPELLCASTING,   -3},
    {SP_HALFLING, SK_CONJURATIONS,   -2},
    {SP_HALFLING, SK_HEXES,          -2},
    {SP_HALFLING, SK_SUMMONINGS,     -2},
    {SP_HALFLING, SK_NECROMANCY,     -2},
    {SP_HALFLING, SK_FORGECRAFT,     0},
    {SP_HALFLING, SK_TRANSLOCATIONS, 1},
    {SP_HALFLING, SK_FIRE_MAGIC,     0},
    {SP_HALFLING, SK_ICE_MAGIC,      0},
    {SP_HALFLING, SK_AIR_MAGIC,      0},
    {SP_HALFLING, SK_EARTH_MAGIC,    0},
    {SP_HALFLING, SK_ALCHEMY,        0},
    {SP_HALFLING, SK_INVOCATIONS,    1},
    {SP_HALFLING, SK_EVOCATIONS,     0},
    {SP_HALFLING, SK_SHAPESHIFTING,  0},
#if TAG_MAJOR_VERSION == 34
    {SP_HALFLING, SK_STABBING,       UNUSABLE_SKILL},
    {SP_HALFLING, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_HALFLING, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_HALFLING, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_HALFLING, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif
#if TAG_MAJOR_VERSION == 34
    {SP_HILL_ORC, SK_FIGHTING,       2},
    {SP_HILL_ORC, SK_SHORT_BLADES,   0},
    {SP_HILL_ORC, SK_LONG_BLADES,    1},
    {SP_HILL_ORC, SK_AXES,           3},
    {SP_HILL_ORC, SK_MACES_FLAILS,   1},
    {SP_HILL_ORC, SK_POLEARMS,       1},
    {SP_HILL_ORC, SK_STAVES,         -1},
    {SP_HILL_ORC, SK_RANGED_WEAPONS, -1},
    {SP_HILL_ORC, SK_THROWING,       -1},
    {SP_HILL_ORC, SK_ARMOUR,         1},
    {SP_HILL_ORC, SK_DODGING,        -2},
    {SP_HILL_ORC, SK_STEALTH,        -1},
    {SP_HILL_ORC, SK_SHIELDS,        1},
    {SP_HILL_ORC, SK_UNARMED_COMBAT, 1},
    {SP_HILL_ORC, SK_SPELLCASTING,   -3},
    {SP_HILL_ORC, SK_CONJURATIONS,   0},
    {SP_HILL_ORC, SK_HEXES,          0},
    {SP_HILL_ORC, SK_SUMMONINGS,     0},
    {SP_HILL_ORC, SK_NECROMANCY,     0},
    {SP_HILL_ORC, SK_FORGECRAFT,     0},
    {SP_HILL_ORC, SK_TRANSLOCATIONS, -2},
    {SP_HILL_ORC, SK_FIRE_MAGIC,     1},
    {SP_HILL_ORC, SK_ICE_MAGIC,      -1},
    {SP_HILL_ORC, SK_AIR_MAGIC,      -2},
    {SP_HILL_ORC, SK_EARTH_MAGIC,    0},
    {SP_HILL_ORC, SK_ALCHEMY,        -2},
    {SP_HILL_ORC, SK_INVOCATIONS,    3},
    {SP_HILL_ORC, SK_EVOCATIONS,     0},
    {SP_HILL_ORC, SK_SHAPESHIFTING,  -2},
#if TAG_MAJOR_VERSION == 34
    {SP_HILL_ORC, SK_STABBING,       UNUSABLE_SKILL},
    {SP_HILL_ORC, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_HILL_ORC, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_HILL_ORC, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_HILL_ORC, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif

    {SP_KOBOLD, SK_FIGHTING,       1},
    {SP_KOBOLD, SK_SHORT_BLADES,   3},
    {SP_KOBOLD, SK_LONG_BLADES,    -2},
    {SP_KOBOLD, SK_AXES,           -2},
    {SP_KOBOLD, SK_MACES_FLAILS,   -1},
    {SP_KOBOLD, SK_POLEARMS,       -2},
    {SP_KOBOLD, SK_STAVES,         -1},
    {SP_KOBOLD, SK_RANGED_WEAPONS, 3},
    {SP_KOBOLD, SK_THROWING,       1},
    {SP_KOBOLD, SK_ARMOUR,         -2},
    {SP_KOBOLD, SK_DODGING,        2},
    {SP_KOBOLD, SK_STEALTH,        4},
    {SP_KOBOLD, SK_SHIELDS,        -2},
    {SP_KOBOLD, SK_UNARMED_COMBAT, 0},
    {SP_KOBOLD, SK_SPELLCASTING,   0},
    {SP_KOBOLD, SK_CONJURATIONS,   0},
    {SP_KOBOLD, SK_HEXES,          0},
    {SP_KOBOLD, SK_SUMMONINGS,     0},
    {SP_KOBOLD, SK_NECROMANCY,     0},
    {SP_KOBOLD, SK_FORGECRAFT,     0},
    {SP_KOBOLD, SK_TRANSLOCATIONS, 0},
    {SP_KOBOLD, SK_FIRE_MAGIC,     0},
    {SP_KOBOLD, SK_ICE_MAGIC,      0},
    {SP_KOBOLD, SK_AIR_MAGIC,      0},
    {SP_KOBOLD, SK_EARTH_MAGIC,    0},
    {SP_KOBOLD, SK_ALCHEMY,        0},
    {SP_KOBOLD, SK_INVOCATIONS,    1},
    {SP_KOBOLD, SK_EVOCATIONS,     2},
    {SP_KOBOLD, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_KOBOLD, SK_STABBING,       UNUSABLE_SKILL},
    {SP_KOBOLD, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_KOBOLD, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_KOBOLD, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_KOBOLD, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_MUMMY, SK_FIGHTING,       0},
    {SP_MUMMY, SK_SHORT_BLADES,   -2},
    {SP_MUMMY, SK_LONG_BLADES,    -2},
    {SP_MUMMY, SK_AXES,           -2},
    {SP_MUMMY, SK_MACES_FLAILS,   -2},
    {SP_MUMMY, SK_POLEARMS,       -2},
    {SP_MUMMY, SK_STAVES,         -2},
    {SP_MUMMY, SK_RANGED_WEAPONS, -2},
    {SP_MUMMY, SK_THROWING,       -2},
    {SP_MUMMY, SK_ARMOUR,         -2},
    {SP_MUMMY, SK_DODGING,        -2},
    {SP_MUMMY, SK_STEALTH,        -1},
    {SP_MUMMY, SK_SHIELDS,        -2},
    {SP_MUMMY, SK_UNARMED_COMBAT, -2},
    {SP_MUMMY, SK_SPELLCASTING,   2},
    {SP_MUMMY, SK_CONJURATIONS,   -2},
    {SP_MUMMY, SK_HEXES,          -1},
    {SP_MUMMY, SK_SUMMONINGS,     -2},
    {SP_MUMMY, SK_NECROMANCY,     0},
    {SP_MUMMY, SK_FORGECRAFT,     -2},
    {SP_MUMMY, SK_TRANSLOCATIONS, -2},
    {SP_MUMMY, SK_FIRE_MAGIC,     -2},
    {SP_MUMMY, SK_ICE_MAGIC,      -2},
    {SP_MUMMY, SK_AIR_MAGIC,      -2},
    {SP_MUMMY, SK_EARTH_MAGIC,    -2},
    {SP_MUMMY, SK_ALCHEMY,        -2},
    {SP_MUMMY, SK_INVOCATIONS,    -1},
    {SP_MUMMY, SK_EVOCATIONS,     -2},
    {SP_MUMMY, SK_SHAPESHIFTING,  UNUSABLE_SKILL},
#if TAG_MAJOR_VERSION == 34
    {SP_MUMMY, SK_STABBING,       UNUSABLE_SKILL},
    {SP_MUMMY, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_MUMMY, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_MUMMY, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_MUMMY, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_NAGA, SK_FIGHTING,       0},
    {SP_NAGA, SK_SHORT_BLADES,   0},
    {SP_NAGA, SK_LONG_BLADES,    0},
    {SP_NAGA, SK_AXES,           0},
    {SP_NAGA, SK_MACES_FLAILS,   0},
    {SP_NAGA, SK_POLEARMS,       0},
    {SP_NAGA, SK_STAVES,         0},
    {SP_NAGA, SK_RANGED_WEAPONS, -1},
    {SP_NAGA, SK_THROWING,       -1},
    {SP_NAGA, SK_ARMOUR,         -1},
    {SP_NAGA, SK_DODGING,        -2},
    {SP_NAGA, SK_STEALTH,        5},
    {SP_NAGA, SK_SHIELDS,        -1},
    {SP_NAGA, SK_UNARMED_COMBAT, 0},
    {SP_NAGA, SK_SPELLCASTING,   -1},
    {SP_NAGA, SK_CONJURATIONS,   0},
    {SP_NAGA, SK_HEXES,          0},
    {SP_NAGA, SK_SUMMONINGS,     0},
    {SP_NAGA, SK_NECROMANCY,     0},
    {SP_NAGA, SK_FORGECRAFT,     0},
    {SP_NAGA, SK_TRANSLOCATIONS, 0},
    {SP_NAGA, SK_FIRE_MAGIC,     0},
    {SP_NAGA, SK_ICE_MAGIC,      0},
    {SP_NAGA, SK_AIR_MAGIC,      0},
    {SP_NAGA, SK_EARTH_MAGIC,    0},
    {SP_NAGA, SK_ALCHEMY,        2},
    {SP_NAGA, SK_INVOCATIONS,    1},
    {SP_NAGA, SK_EVOCATIONS,     0},
    {SP_NAGA, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_NAGA, SK_STABBING,       UNUSABLE_SKILL},
    {SP_NAGA, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_NAGA, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_NAGA, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_NAGA, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_ONI, SK_FIGHTING,       3},
    {SP_ONI, SK_SHORT_BLADES,   -1},
    {SP_ONI, SK_LONG_BLADES,    -1},
    {SP_ONI, SK_AXES,           0},
    {SP_ONI, SK_MACES_FLAILS,   0},
    {SP_ONI, SK_POLEARMS,       0},
    {SP_ONI, SK_STAVES,         0},
    {SP_ONI, SK_RANGED_WEAPONS, -3},
    {SP_ONI, SK_THROWING,       0},
    {SP_ONI, SK_ARMOUR,         -1},
    {SP_ONI, SK_DODGING,        -1},
    {SP_ONI, SK_STEALTH,        -2},
    {SP_ONI, SK_SHIELDS,        -1},
    {SP_ONI, SK_UNARMED_COMBAT, -1},
    {SP_ONI, SK_SPELLCASTING,   1},
    {SP_ONI, SK_CONJURATIONS,   -1},
    {SP_ONI, SK_HEXES,          -1},
    {SP_ONI, SK_SUMMONINGS,     -1},
    {SP_ONI, SK_NECROMANCY,     -1},
    {SP_ONI, SK_FORGECRAFT,     -1},
    {SP_ONI, SK_TRANSLOCATIONS, -1},
    {SP_ONI, SK_FIRE_MAGIC,     -1},
    {SP_ONI, SK_ICE_MAGIC,      -1},
    {SP_ONI, SK_AIR_MAGIC,      -1},
    {SP_ONI, SK_EARTH_MAGIC,    -1},
    {SP_ONI, SK_ALCHEMY,        -1},
    {SP_ONI, SK_INVOCATIONS,    2},
    {SP_ONI, SK_EVOCATIONS,     -2},
    {SP_ONI, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_ONI, SK_STABBING,       UNUSABLE_SKILL},
    {SP_ONI, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_ONI, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_ONI, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_ONI, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_TROLL, SK_FIGHTING,       -2},
    {SP_TROLL, SK_SHORT_BLADES,   -2},
    {SP_TROLL, SK_LONG_BLADES,    -2},
    {SP_TROLL, SK_AXES,           -2},
    {SP_TROLL, SK_MACES_FLAILS,   -1},
    {SP_TROLL, SK_POLEARMS,       -2},
    {SP_TROLL, SK_STAVES,         -2},
    {SP_TROLL, SK_RANGED_WEAPONS, -4},
    {SP_TROLL, SK_THROWING,       -1},
    {SP_TROLL, SK_ARMOUR,         -2},
    {SP_TROLL, SK_DODGING,        -2},
    {SP_TROLL, SK_STEALTH,        -5},
    {SP_TROLL, SK_SHIELDS,        -1},
    {SP_TROLL, SK_UNARMED_COMBAT, 0},
    {SP_TROLL, SK_SPELLCASTING,   -5},
    {SP_TROLL, SK_CONJURATIONS,   -3},
    {SP_TROLL, SK_HEXES,          -4},
    {SP_TROLL, SK_SUMMONINGS,     -3},
    {SP_TROLL, SK_NECROMANCY,     -2},
    {SP_TROLL, SK_FORGECRAFT,     -3},
    {SP_TROLL, SK_TRANSLOCATIONS, -3},
    {SP_TROLL, SK_FIRE_MAGIC,     -3},
    {SP_TROLL, SK_ICE_MAGIC,      -3},
    {SP_TROLL, SK_AIR_MAGIC,      -4},
    {SP_TROLL, SK_EARTH_MAGIC,    -1},
    {SP_TROLL, SK_ALCHEMY,        -3},
    {SP_TROLL, SK_INVOCATIONS,    -1},
    {SP_TROLL, SK_EVOCATIONS,     -3},
    {SP_TROLL, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_TROLL, SK_STABBING,       UNUSABLE_SKILL},
    {SP_TROLL, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_TROLL, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_TROLL, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_TROLL, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_RED_DRACONIAN, SK_FIGHTING,       1},
    {SP_RED_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_RED_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_RED_DRACONIAN, SK_AXES,           0},
    {SP_RED_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_RED_DRACONIAN, SK_POLEARMS,       0},
    {SP_RED_DRACONIAN, SK_STAVES,         0},
    {SP_RED_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_RED_DRACONIAN, SK_THROWING,       -1},
    {SP_RED_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_RED_DRACONIAN, SK_DODGING,        -1},
    {SP_RED_DRACONIAN, SK_STEALTH,        0},
    {SP_RED_DRACONIAN, SK_SHIELDS,        0},
    {SP_RED_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_RED_DRACONIAN, SK_SPELLCASTING,   -1},
    {SP_RED_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_RED_DRACONIAN, SK_HEXES,          -1},
    {SP_RED_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_RED_DRACONIAN, SK_NECROMANCY,     0},
    {SP_RED_DRACONIAN, SK_FORGECRAFT,     0},
    {SP_RED_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_RED_DRACONIAN, SK_FIRE_MAGIC,     2},
    {SP_RED_DRACONIAN, SK_ICE_MAGIC,      -2},
    {SP_RED_DRACONIAN, SK_AIR_MAGIC,      0},
    {SP_RED_DRACONIAN, SK_EARTH_MAGIC,    0},
    {SP_RED_DRACONIAN, SK_ALCHEMY,        0},
    {SP_RED_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_RED_DRACONIAN, SK_EVOCATIONS,     0},
    {SP_RED_DRACONIAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_RED_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_RED_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_RED_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_RED_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_RED_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_WHITE_DRACONIAN, SK_FIGHTING,       1},
    {SP_WHITE_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_WHITE_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_WHITE_DRACONIAN, SK_AXES,           0},
    {SP_WHITE_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_WHITE_DRACONIAN, SK_POLEARMS,       0},
    {SP_WHITE_DRACONIAN, SK_STAVES,         0},
    {SP_WHITE_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_WHITE_DRACONIAN, SK_THROWING,       -1},
    {SP_WHITE_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_WHITE_DRACONIAN, SK_DODGING,        -1},
    {SP_WHITE_DRACONIAN, SK_STEALTH,        0},
    {SP_WHITE_DRACONIAN, SK_SHIELDS,        0},
    {SP_WHITE_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_WHITE_DRACONIAN, SK_SPELLCASTING,   -1},
    {SP_WHITE_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_WHITE_DRACONIAN, SK_HEXES,          -1},
    {SP_WHITE_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_WHITE_DRACONIAN, SK_NECROMANCY,     0},
    {SP_WHITE_DRACONIAN, SK_FORGECRAFT,     0},
    {SP_WHITE_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_WHITE_DRACONIAN, SK_FIRE_MAGIC,     -2},
    {SP_WHITE_DRACONIAN, SK_ICE_MAGIC,      2},
    {SP_WHITE_DRACONIAN, SK_AIR_MAGIC,      0},
    {SP_WHITE_DRACONIAN, SK_EARTH_MAGIC,    0},
    {SP_WHITE_DRACONIAN, SK_ALCHEMY,        0},
    {SP_WHITE_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_WHITE_DRACONIAN, SK_EVOCATIONS,     0},
    {SP_WHITE_DRACONIAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_WHITE_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_WHITE_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_WHITE_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_WHITE_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_WHITE_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_GREEN_DRACONIAN, SK_FIGHTING,       1},
    {SP_GREEN_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_GREEN_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_GREEN_DRACONIAN, SK_AXES,           0},
    {SP_GREEN_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_GREEN_DRACONIAN, SK_POLEARMS,       0},
    {SP_GREEN_DRACONIAN, SK_STAVES,         0},
    {SP_GREEN_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_GREEN_DRACONIAN, SK_THROWING,       -1},
    {SP_GREEN_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_GREEN_DRACONIAN, SK_DODGING,        -1},
    {SP_GREEN_DRACONIAN, SK_STEALTH,        0},
    {SP_GREEN_DRACONIAN, SK_SHIELDS,        0},
    {SP_GREEN_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_GREEN_DRACONIAN, SK_SPELLCASTING,   -1},
    {SP_GREEN_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_GREEN_DRACONIAN, SK_HEXES,          -1},
    {SP_GREEN_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_GREEN_DRACONIAN, SK_NECROMANCY,     0},
    {SP_GREEN_DRACONIAN, SK_FORGECRAFT,     0},
    {SP_GREEN_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_GREEN_DRACONIAN, SK_FIRE_MAGIC,     0},
    {SP_GREEN_DRACONIAN, SK_ICE_MAGIC,      0},
    {SP_GREEN_DRACONIAN, SK_AIR_MAGIC,      0},
    {SP_GREEN_DRACONIAN, SK_EARTH_MAGIC,    0},
    {SP_GREEN_DRACONIAN, SK_ALCHEMY,        2},
    {SP_GREEN_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_GREEN_DRACONIAN, SK_EVOCATIONS,     0},
    {SP_GREEN_DRACONIAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_GREEN_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_GREEN_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_GREEN_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_GREEN_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_GREEN_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_YELLOW_DRACONIAN, SK_FIGHTING,       1},
    {SP_YELLOW_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_YELLOW_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_YELLOW_DRACONIAN, SK_AXES,           0},
    {SP_YELLOW_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_YELLOW_DRACONIAN, SK_POLEARMS,       0},
    {SP_YELLOW_DRACONIAN, SK_STAVES,         0},
    {SP_YELLOW_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_YELLOW_DRACONIAN, SK_THROWING,       -1},
    {SP_YELLOW_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_YELLOW_DRACONIAN, SK_DODGING,        -1},
    {SP_YELLOW_DRACONIAN, SK_STEALTH,        0},
    {SP_YELLOW_DRACONIAN, SK_SHIELDS,        0},
    {SP_YELLOW_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_YELLOW_DRACONIAN, SK_SPELLCASTING,   -1},
    {SP_YELLOW_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_YELLOW_DRACONIAN, SK_HEXES,          -1},
    {SP_YELLOW_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_YELLOW_DRACONIAN, SK_NECROMANCY,     0},
    {SP_YELLOW_DRACONIAN, SK_FORGECRAFT,     2},
    {SP_YELLOW_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_YELLOW_DRACONIAN, SK_FIRE_MAGIC,     0},
    {SP_YELLOW_DRACONIAN, SK_ICE_MAGIC,      0},
    {SP_YELLOW_DRACONIAN, SK_AIR_MAGIC,      0},
    {SP_YELLOW_DRACONIAN, SK_EARTH_MAGIC,    0},
    {SP_YELLOW_DRACONIAN, SK_ALCHEMY,        0},
    {SP_YELLOW_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_YELLOW_DRACONIAN, SK_EVOCATIONS,     0},
    {SP_YELLOW_DRACONIAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_YELLOW_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_YELLOW_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_YELLOW_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_YELLOW_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_YELLOW_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_GREY_DRACONIAN, SK_FIGHTING,       1},
    {SP_GREY_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_GREY_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_GREY_DRACONIAN, SK_AXES,           0},
    {SP_GREY_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_GREY_DRACONIAN, SK_POLEARMS,       0},
    {SP_GREY_DRACONIAN, SK_STAVES,         0},
    {SP_GREY_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_GREY_DRACONIAN, SK_THROWING,       -1},
    {SP_GREY_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_GREY_DRACONIAN, SK_DODGING,        -1},
    {SP_GREY_DRACONIAN, SK_STEALTH,        0},
    {SP_GREY_DRACONIAN, SK_SHIELDS,        0},
    {SP_GREY_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_GREY_DRACONIAN, SK_SPELLCASTING,   -1},
    {SP_GREY_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_GREY_DRACONIAN, SK_HEXES,          -1},
    {SP_GREY_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_GREY_DRACONIAN, SK_NECROMANCY,     0},
    {SP_GREY_DRACONIAN, SK_FORGECRAFT,     0},
    {SP_GREY_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_GREY_DRACONIAN, SK_FIRE_MAGIC,     0},
    {SP_GREY_DRACONIAN, SK_ICE_MAGIC,      0},
    {SP_GREY_DRACONIAN, SK_AIR_MAGIC,      -2},
    {SP_GREY_DRACONIAN, SK_EARTH_MAGIC,    2},
    {SP_GREY_DRACONIAN, SK_ALCHEMY,        0},
    {SP_GREY_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_GREY_DRACONIAN, SK_EVOCATIONS,     0},
    {SP_GREY_DRACONIAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_GREY_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_GREY_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_GREY_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_GREY_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_GREY_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_BLACK_DRACONIAN, SK_FIGHTING,       1},
    {SP_BLACK_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_BLACK_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_BLACK_DRACONIAN, SK_AXES,           0},
    {SP_BLACK_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_BLACK_DRACONIAN, SK_POLEARMS,       0},
    {SP_BLACK_DRACONIAN, SK_STAVES,         0},
    {SP_BLACK_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_BLACK_DRACONIAN, SK_THROWING,       -1},
    {SP_BLACK_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_BLACK_DRACONIAN, SK_DODGING,        -1},
    {SP_BLACK_DRACONIAN, SK_STEALTH,        0},
    {SP_BLACK_DRACONIAN, SK_SHIELDS,        0},
    {SP_BLACK_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_BLACK_DRACONIAN, SK_SPELLCASTING,   -1},
    {SP_BLACK_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_BLACK_DRACONIAN, SK_HEXES,          -1},
    {SP_BLACK_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_BLACK_DRACONIAN, SK_NECROMANCY,     0},
    {SP_BLACK_DRACONIAN, SK_FORGECRAFT,     0},
    {SP_BLACK_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_BLACK_DRACONIAN, SK_FIRE_MAGIC,     0},
    {SP_BLACK_DRACONIAN, SK_ICE_MAGIC,      0},
    {SP_BLACK_DRACONIAN, SK_AIR_MAGIC,      2},
    {SP_BLACK_DRACONIAN, SK_EARTH_MAGIC,    -2},
    {SP_BLACK_DRACONIAN, SK_ALCHEMY,        0},
    {SP_BLACK_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_BLACK_DRACONIAN, SK_EVOCATIONS,     0},
    {SP_BLACK_DRACONIAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_BLACK_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_BLACK_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_BLACK_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_BLACK_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_BLACK_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_PURPLE_DRACONIAN, SK_FIGHTING,       1},
    {SP_PURPLE_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_PURPLE_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_PURPLE_DRACONIAN, SK_AXES,           0},
    {SP_PURPLE_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_PURPLE_DRACONIAN, SK_POLEARMS,       0},
    {SP_PURPLE_DRACONIAN, SK_STAVES,         0},
    {SP_PURPLE_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_PURPLE_DRACONIAN, SK_THROWING,       -1},
    {SP_PURPLE_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_PURPLE_DRACONIAN, SK_DODGING,        -1},
    {SP_PURPLE_DRACONIAN, SK_STEALTH,        0},
    {SP_PURPLE_DRACONIAN, SK_SHIELDS,        0},
    {SP_PURPLE_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_PURPLE_DRACONIAN, SK_SPELLCASTING,   1},
    {SP_PURPLE_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_PURPLE_DRACONIAN, SK_HEXES,          1},
    {SP_PURPLE_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_PURPLE_DRACONIAN, SK_NECROMANCY,     0},
    {SP_PURPLE_DRACONIAN, SK_FORGECRAFT,     0},
    {SP_PURPLE_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_PURPLE_DRACONIAN, SK_FIRE_MAGIC,     0},
    {SP_PURPLE_DRACONIAN, SK_ICE_MAGIC,      0},
    {SP_PURPLE_DRACONIAN, SK_AIR_MAGIC,      0},
    {SP_PURPLE_DRACONIAN, SK_EARTH_MAGIC,    0},
    {SP_PURPLE_DRACONIAN, SK_ALCHEMY,        0},
    {SP_PURPLE_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_PURPLE_DRACONIAN, SK_EVOCATIONS,     1},
    {SP_PURPLE_DRACONIAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_PURPLE_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_PURPLE_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_PURPLE_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_PURPLE_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_PURPLE_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif

#if TAG_MAJOR_VERSION == 34
    {SP_MOTTLED_DRACONIAN, SK_FIGHTING,       1},
    {SP_MOTTLED_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_MOTTLED_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_MOTTLED_DRACONIAN, SK_AXES,           0},
    {SP_MOTTLED_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_MOTTLED_DRACONIAN, SK_POLEARMS,       0},
    {SP_MOTTLED_DRACONIAN, SK_STAVES,         0},
    {SP_MOTTLED_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_MOTTLED_DRACONIAN, SK_THROWING,       -1},
    {SP_MOTTLED_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_MOTTLED_DRACONIAN, SK_DODGING,        -1},
    {SP_MOTTLED_DRACONIAN, SK_STEALTH,        0},
    {SP_MOTTLED_DRACONIAN, SK_SHIELDS,        0},
    {SP_MOTTLED_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_MOTTLED_DRACONIAN, SK_SPELLCASTING,   -1},
    {SP_MOTTLED_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_MOTTLED_DRACONIAN, SK_HEXES,          -1},
    {SP_MOTTLED_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_MOTTLED_DRACONIAN, SK_NECROMANCY,     0},
    {SP_MOTTLED_DRACONIAN, SK_FORGECRAFT,     0},
    {SP_MOTTLED_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_MOTTLED_DRACONIAN, SK_FIRE_MAGIC,     1},
    {SP_MOTTLED_DRACONIAN, SK_ICE_MAGIC,      0},
    {SP_MOTTLED_DRACONIAN, SK_AIR_MAGIC,      0},
    {SP_MOTTLED_DRACONIAN, SK_EARTH_MAGIC,    0},
    {SP_MOTTLED_DRACONIAN, SK_ALCHEMY,        0},
    {SP_MOTTLED_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_MOTTLED_DRACONIAN, SK_EVOCATIONS,     0},
    {SP_MOTTLED_DRACONIAN, SK_SHAPESHIFTING,  0},
#if TAG_MAJOR_VERSION == 34
    {SP_MOTTLED_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_MOTTLED_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_MOTTLED_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_MOTTLED_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_MOTTLED_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif

    {SP_PALE_DRACONIAN, SK_FIGHTING,       1},
    {SP_PALE_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_PALE_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_PALE_DRACONIAN, SK_AXES,           0},
    {SP_PALE_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_PALE_DRACONIAN, SK_POLEARMS,       0},
    {SP_PALE_DRACONIAN, SK_STAVES,         0},
    {SP_PALE_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_PALE_DRACONIAN, SK_THROWING,       -1},
    {SP_PALE_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_PALE_DRACONIAN, SK_DODGING,        -1},
    {SP_PALE_DRACONIAN, SK_STEALTH,        0},
    {SP_PALE_DRACONIAN, SK_SHIELDS,        0},
    {SP_PALE_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_PALE_DRACONIAN, SK_SPELLCASTING,   -1},
    {SP_PALE_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_PALE_DRACONIAN, SK_HEXES,          -1},
    {SP_PALE_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_PALE_DRACONIAN, SK_NECROMANCY,     0},
    {SP_PALE_DRACONIAN, SK_FORGECRAFT,     0},
    {SP_PALE_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_PALE_DRACONIAN, SK_FIRE_MAGIC,     1},
    {SP_PALE_DRACONIAN, SK_ICE_MAGIC,      0},
    {SP_PALE_DRACONIAN, SK_AIR_MAGIC,      1},
    {SP_PALE_DRACONIAN, SK_EARTH_MAGIC,    0},
    {SP_PALE_DRACONIAN, SK_ALCHEMY,        0},
    {SP_PALE_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_PALE_DRACONIAN, SK_EVOCATIONS,     1},
    {SP_PALE_DRACONIAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_PALE_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_PALE_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_PALE_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_PALE_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_PALE_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_BASE_DRACONIAN, SK_FIGHTING,       1},
    {SP_BASE_DRACONIAN, SK_SHORT_BLADES,   0},
    {SP_BASE_DRACONIAN, SK_LONG_BLADES,    0},
    {SP_BASE_DRACONIAN, SK_AXES,           0},
    {SP_BASE_DRACONIAN, SK_MACES_FLAILS,   0},
    {SP_BASE_DRACONIAN, SK_POLEARMS,       0},
    {SP_BASE_DRACONIAN, SK_STAVES,         0},
    {SP_BASE_DRACONIAN, SK_RANGED_WEAPONS, -1},
    {SP_BASE_DRACONIAN, SK_THROWING,       -1},
    {SP_BASE_DRACONIAN, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_BASE_DRACONIAN, SK_DODGING,        -1},
    {SP_BASE_DRACONIAN, SK_STEALTH,        0},
    {SP_BASE_DRACONIAN, SK_SHIELDS,        0},
    {SP_BASE_DRACONIAN, SK_UNARMED_COMBAT, 0},
    {SP_BASE_DRACONIAN, SK_SPELLCASTING,   -1},
    {SP_BASE_DRACONIAN, SK_CONJURATIONS,   0},
    {SP_BASE_DRACONIAN, SK_HEXES,          -1},
    {SP_BASE_DRACONIAN, SK_SUMMONINGS,     0},
    {SP_BASE_DRACONIAN, SK_NECROMANCY,     0},
    {SP_BASE_DRACONIAN, SK_FORGECRAFT,     0},
    {SP_BASE_DRACONIAN, SK_TRANSLOCATIONS, 0},
    {SP_BASE_DRACONIAN, SK_FIRE_MAGIC,     0},
    {SP_BASE_DRACONIAN, SK_ICE_MAGIC,      0},
    {SP_BASE_DRACONIAN, SK_AIR_MAGIC,      0},
    {SP_BASE_DRACONIAN, SK_EARTH_MAGIC,    0},
    {SP_BASE_DRACONIAN, SK_ALCHEMY,        0},
    {SP_BASE_DRACONIAN, SK_INVOCATIONS,    1},
    {SP_BASE_DRACONIAN, SK_EVOCATIONS,     0},
    {SP_BASE_DRACONIAN, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_BASE_DRACONIAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_BASE_DRACONIAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_BASE_DRACONIAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_BASE_DRACONIAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_BASE_DRACONIAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif

#if TAG_MAJOR_VERSION == 34
    {SP_CENTAUR, SK_FIGHTING,       0},
    {SP_CENTAUR, SK_SHORT_BLADES,   -1},
    {SP_CENTAUR, SK_LONG_BLADES,    -1},
    {SP_CENTAUR, SK_AXES,           -1},
    {SP_CENTAUR, SK_MACES_FLAILS,   -1},
    {SP_CENTAUR, SK_POLEARMS,       -1},
    {SP_CENTAUR, SK_STAVES,         -1},
    {SP_CENTAUR, SK_RANGED_WEAPONS, 3},
    {SP_CENTAUR, SK_THROWING,       1},
    {SP_CENTAUR, SK_ARMOUR,         -3},
    {SP_CENTAUR, SK_DODGING,        -3},
    {SP_CENTAUR, SK_STEALTH,        -4},
    {SP_CENTAUR, SK_SHIELDS,        -3},
    {SP_CENTAUR, SK_UNARMED_COMBAT, 0},
    {SP_CENTAUR, SK_SPELLCASTING,   -3},
    {SP_CENTAUR, SK_CONJURATIONS,   -1},
    {SP_CENTAUR, SK_HEXES,          -1},
    {SP_CENTAUR, SK_SUMMONINGS,     -1},
    {SP_CENTAUR, SK_NECROMANCY,     -1},
    {SP_CENTAUR, SK_FORGECRAFT,     0},
    {SP_CENTAUR, SK_TRANSLOCATIONS, -1},
    {SP_CENTAUR, SK_FIRE_MAGIC,     -1},
    {SP_CENTAUR, SK_ICE_MAGIC,      -1},
    {SP_CENTAUR, SK_AIR_MAGIC,      -1},
    {SP_CENTAUR, SK_EARTH_MAGIC,    -1},
    {SP_CENTAUR, SK_ALCHEMY,        -2},
    {SP_CENTAUR, SK_INVOCATIONS,    1},
    {SP_CENTAUR, SK_EVOCATIONS,     -1},
    {SP_CENTAUR, SK_SHAPESHIFTING,  0},
#if TAG_MAJOR_VERSION == 34
    {SP_CENTAUR, SK_STABBING,       UNUSABLE_SKILL},
    {SP_CENTAUR, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_CENTAUR, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_CENTAUR, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_CENTAUR, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif

    {SP_DEMIGOD, SK_FIGHTING,       -1},
    {SP_DEMIGOD, SK_SHORT_BLADES,   -1},
    {SP_DEMIGOD, SK_LONG_BLADES,    -1},
    {SP_DEMIGOD, SK_AXES,           -1},
    {SP_DEMIGOD, SK_MACES_FLAILS,   -1},
    {SP_DEMIGOD, SK_POLEARMS,       -1},
    {SP_DEMIGOD, SK_STAVES,         -1},
    {SP_DEMIGOD, SK_RANGED_WEAPONS, -1},
    {SP_DEMIGOD, SK_THROWING,       -1},
    {SP_DEMIGOD, SK_ARMOUR,         -1},
    {SP_DEMIGOD, SK_DODGING,        -1},
    {SP_DEMIGOD, SK_STEALTH,        0},
    {SP_DEMIGOD, SK_SHIELDS,        -1},
    {SP_DEMIGOD, SK_UNARMED_COMBAT, -1},
    {SP_DEMIGOD, SK_SPELLCASTING,   -2},
    {SP_DEMIGOD, SK_CONJURATIONS,   -1},
    {SP_DEMIGOD, SK_HEXES,          -1},
    {SP_DEMIGOD, SK_SUMMONINGS,     -1},
    {SP_DEMIGOD, SK_NECROMANCY,     -1},
    {SP_DEMIGOD, SK_FORGECRAFT,     -1},
    {SP_DEMIGOD, SK_TRANSLOCATIONS, -1},
    {SP_DEMIGOD, SK_FIRE_MAGIC,     -1},
    {SP_DEMIGOD, SK_ICE_MAGIC,      -1},
    {SP_DEMIGOD, SK_AIR_MAGIC,      -1},
    {SP_DEMIGOD, SK_EARTH_MAGIC,    -1},
    {SP_DEMIGOD, SK_ALCHEMY,        -1},
    {SP_DEMIGOD, SK_INVOCATIONS,    UNUSABLE_SKILL},
    {SP_DEMIGOD, SK_EVOCATIONS,     -1},
    {SP_DEMIGOD, SK_SHAPESHIFTING,  -2},
#if TAG_MAJOR_VERSION == 34
    {SP_DEMIGOD, SK_STABBING,       UNUSABLE_SKILL},
    {SP_DEMIGOD, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_DEMIGOD, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_DEMIGOD, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_DEMIGOD, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_SPRIGGAN, SK_FIGHTING,       -2},
    {SP_SPRIGGAN, SK_SHORT_BLADES,   1},
    {SP_SPRIGGAN, SK_LONG_BLADES,    -2},
    {SP_SPRIGGAN, SK_AXES,           -2},
    {SP_SPRIGGAN, SK_MACES_FLAILS,   -3},
    {SP_SPRIGGAN, SK_POLEARMS,       -3},
    {SP_SPRIGGAN, SK_STAVES,         -3},
    {SP_SPRIGGAN, SK_RANGED_WEAPONS, 0},
    {SP_SPRIGGAN, SK_THROWING,       0},
    {SP_SPRIGGAN, SK_ARMOUR,         -3},
    {SP_SPRIGGAN, SK_DODGING,        3},
    {SP_SPRIGGAN, SK_STEALTH,        5},
    {SP_SPRIGGAN, SK_SHIELDS,        -3},
    {SP_SPRIGGAN, SK_UNARMED_COMBAT, -2},
    {SP_SPRIGGAN, SK_SPELLCASTING,   2},
    {SP_SPRIGGAN, SK_CONJURATIONS,   -3},
    {SP_SPRIGGAN, SK_HEXES,          2},
    {SP_SPRIGGAN, SK_SUMMONINGS,     -2},
    {SP_SPRIGGAN, SK_NECROMANCY,     -1},
    {SP_SPRIGGAN, SK_FORGECRAFT,     -2},
    {SP_SPRIGGAN, SK_TRANSLOCATIONS, 4},
    {SP_SPRIGGAN, SK_FIRE_MAGIC,     -2},
    {SP_SPRIGGAN, SK_ICE_MAGIC,      -2},
    {SP_SPRIGGAN, SK_AIR_MAGIC,      -1},
    {SP_SPRIGGAN, SK_EARTH_MAGIC,    -1},
    {SP_SPRIGGAN, SK_ALCHEMY,        1},
    {SP_SPRIGGAN, SK_INVOCATIONS,    0},
    {SP_SPRIGGAN, SK_EVOCATIONS,     3},
    {SP_SPRIGGAN, SK_SHAPESHIFTING,  2},
#if TAG_MAJOR_VERSION == 34
    {SP_SPRIGGAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_SPRIGGAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_SPRIGGAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_SPRIGGAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_SPRIGGAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_MINOTAUR, SK_FIGHTING,       2},
    {SP_MINOTAUR, SK_SHORT_BLADES,   1},
    {SP_MINOTAUR, SK_LONG_BLADES,    2},
    {SP_MINOTAUR, SK_AXES,           2},
    {SP_MINOTAUR, SK_MACES_FLAILS,   2},
    {SP_MINOTAUR, SK_POLEARMS,       2},
    {SP_MINOTAUR, SK_STAVES,         2},
    {SP_MINOTAUR, SK_RANGED_WEAPONS, 1},
    {SP_MINOTAUR, SK_THROWING,       0},
    {SP_MINOTAUR, SK_ARMOUR,         2},
    {SP_MINOTAUR, SK_DODGING,        1},
    {SP_MINOTAUR, SK_STEALTH,        -1},
    {SP_MINOTAUR, SK_SHIELDS,        2},
    {SP_MINOTAUR, SK_UNARMED_COMBAT, 1},
    {SP_MINOTAUR, SK_SPELLCASTING,   -4},
    {SP_MINOTAUR, SK_CONJURATIONS,   -3},
    {SP_MINOTAUR, SK_HEXES,          -4},
    {SP_MINOTAUR, SK_SUMMONINGS,     -3},
    {SP_MINOTAUR, SK_NECROMANCY,     -3},
    {SP_MINOTAUR, SK_FORGECRAFT,     -2},
    {SP_MINOTAUR, SK_TRANSLOCATIONS, -3},
    {SP_MINOTAUR, SK_FIRE_MAGIC,     -3},
    {SP_MINOTAUR, SK_ICE_MAGIC,      -3},
    {SP_MINOTAUR, SK_AIR_MAGIC,      -3},
    {SP_MINOTAUR, SK_EARTH_MAGIC,    -2},
    {SP_MINOTAUR, SK_ALCHEMY,        -3},
    {SP_MINOTAUR, SK_INVOCATIONS,    0},
    {SP_MINOTAUR, SK_EVOCATIONS,     -1},
    {SP_MINOTAUR, SK_SHAPESHIFTING,  -3},
#if TAG_MAJOR_VERSION == 34
    {SP_MINOTAUR, SK_STABBING,       UNUSABLE_SKILL},
    {SP_MINOTAUR, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_MINOTAUR, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_MINOTAUR, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_MINOTAUR, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_DEMONSPAWN, SK_FIGHTING,       0},
    {SP_DEMONSPAWN, SK_SHORT_BLADES,   -1},
    {SP_DEMONSPAWN, SK_LONG_BLADES,    -1},
    {SP_DEMONSPAWN, SK_AXES,           -1},
    {SP_DEMONSPAWN, SK_MACES_FLAILS,   -1},
    {SP_DEMONSPAWN, SK_POLEARMS,       -1},
    {SP_DEMONSPAWN, SK_STAVES,         -1},
    {SP_DEMONSPAWN, SK_RANGED_WEAPONS, -1},
    {SP_DEMONSPAWN, SK_THROWING,       -1},
    {SP_DEMONSPAWN, SK_ARMOUR,         -1},
    {SP_DEMONSPAWN, SK_DODGING,        -1},
    {SP_DEMONSPAWN, SK_STEALTH,        0},
    {SP_DEMONSPAWN, SK_SHIELDS,        -1},
    {SP_DEMONSPAWN, SK_UNARMED_COMBAT, -1},
    {SP_DEMONSPAWN, SK_SPELLCASTING,   -1},
    {SP_DEMONSPAWN, SK_CONJURATIONS,   0},
    {SP_DEMONSPAWN, SK_HEXES,          0},
    {SP_DEMONSPAWN, SK_SUMMONINGS,     0},
    {SP_DEMONSPAWN, SK_NECROMANCY,     1},
    {SP_DEMONSPAWN, SK_FORGECRAFT,     -1},
    {SP_DEMONSPAWN, SK_TRANSLOCATIONS, -1},
    {SP_DEMONSPAWN, SK_FIRE_MAGIC,     -1},
    {SP_DEMONSPAWN, SK_ICE_MAGIC,      -1},
    {SP_DEMONSPAWN, SK_AIR_MAGIC,      -1},
    {SP_DEMONSPAWN, SK_EARTH_MAGIC,    -1},
    {SP_DEMONSPAWN, SK_ALCHEMY,        0},
    {SP_DEMONSPAWN, SK_INVOCATIONS,    3},
    {SP_DEMONSPAWN, SK_EVOCATIONS,     0},
    {SP_DEMONSPAWN, SK_SHAPESHIFTING,  -2},
#if TAG_MAJOR_VERSION == 34
    {SP_DEMONSPAWN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_DEMONSPAWN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_DEMONSPAWN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_DEMONSPAWN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_DEMONSPAWN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif

#if TAG_MAJOR_VERSION == 34
    {SP_GHOUL, SK_FIGHTING,       1},
    {SP_GHOUL, SK_SHORT_BLADES,   -1},
    {SP_GHOUL, SK_LONG_BLADES,    -1},
    {SP_GHOUL, SK_AXES,           -1},
    {SP_GHOUL, SK_MACES_FLAILS,   -1},
    {SP_GHOUL, SK_POLEARMS,       -1},
    {SP_GHOUL, SK_STAVES,         -1},
    {SP_GHOUL, SK_RANGED_WEAPONS, -1},
    {SP_GHOUL, SK_THROWING,       -1},
    {SP_GHOUL, SK_ARMOUR,         -1},
    {SP_GHOUL, SK_DODGING,        -1},
    {SP_GHOUL, SK_STEALTH,        2},
    {SP_GHOUL, SK_SHIELDS,        -1},
    {SP_GHOUL, SK_UNARMED_COMBAT, 1},
    {SP_GHOUL, SK_SPELLCASTING,   -2},
    {SP_GHOUL, SK_CONJURATIONS,   -2},
    {SP_GHOUL, SK_HEXES,          -2},
    {SP_GHOUL, SK_SUMMONINGS,     -1},
    {SP_GHOUL, SK_NECROMANCY,     0},
    {SP_GHOUL, SK_FORGECRAFT,     -2},
    {SP_GHOUL, SK_TRANSLOCATIONS, -1},
    {SP_GHOUL, SK_FIRE_MAGIC,     -2},
    {SP_GHOUL, SK_ICE_MAGIC,      1},
    {SP_GHOUL, SK_AIR_MAGIC,      -2},
    {SP_GHOUL, SK_EARTH_MAGIC,    1},
    {SP_GHOUL, SK_ALCHEMY,        -1},
    {SP_GHOUL, SK_INVOCATIONS,    1},
    {SP_GHOUL, SK_EVOCATIONS,     -1},
    {SP_GHOUL, SK_SHAPESHIFTING,  UNUSABLE_SKILL},
#if TAG_MAJOR_VERSION == 34
    {SP_GHOUL, SK_STABBING,       UNUSABLE_SKILL},
    {SP_GHOUL, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_GHOUL, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_GHOUL, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_GHOUL, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif

    {SP_TENGU, SK_FIGHTING,       0},
    {SP_TENGU, SK_SHORT_BLADES,   1},
    {SP_TENGU, SK_LONG_BLADES,    1},
    {SP_TENGU, SK_AXES,           1},
    {SP_TENGU, SK_MACES_FLAILS,   1},
    {SP_TENGU, SK_POLEARMS,       1},
    {SP_TENGU, SK_STAVES,         1},
    {SP_TENGU, SK_RANGED_WEAPONS, 1},
    {SP_TENGU, SK_THROWING,       0},
    {SP_TENGU, SK_ARMOUR,         1},
    {SP_TENGU, SK_DODGING,        1},
    {SP_TENGU, SK_STEALTH,        1},
    {SP_TENGU, SK_SHIELDS,        0},
    {SP_TENGU, SK_UNARMED_COMBAT, 1},
    {SP_TENGU, SK_SPELLCASTING,   -1},
    {SP_TENGU, SK_CONJURATIONS,   3},
    {SP_TENGU, SK_HEXES,          -3},
    {SP_TENGU, SK_SUMMONINGS,     2},
    {SP_TENGU, SK_NECROMANCY,     1},
    {SP_TENGU, SK_FORGECRAFT,     -2},
    {SP_TENGU, SK_TRANSLOCATIONS, -2},
    {SP_TENGU, SK_FIRE_MAGIC,     1},
    {SP_TENGU, SK_ICE_MAGIC,      -1},
    {SP_TENGU, SK_AIR_MAGIC,      3},
    {SP_TENGU, SK_EARTH_MAGIC,    -3},
    {SP_TENGU, SK_ALCHEMY,        -1},
    {SP_TENGU, SK_INVOCATIONS,    -1},
    {SP_TENGU, SK_EVOCATIONS,     0},
    {SP_TENGU, SK_SHAPESHIFTING,  -2},
#if TAG_MAJOR_VERSION == 34
    {SP_TENGU, SK_STABBING,       UNUSABLE_SKILL},
    {SP_TENGU, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_TENGU, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_TENGU, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_TENGU, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_MERFOLK, SK_FIGHTING,       1},
    {SP_MERFOLK, SK_SHORT_BLADES,   2},
    {SP_MERFOLK, SK_LONG_BLADES,    1},
    {SP_MERFOLK, SK_AXES,           -2},
    {SP_MERFOLK, SK_MACES_FLAILS,   -2},
    {SP_MERFOLK, SK_POLEARMS,       4},
    {SP_MERFOLK, SK_STAVES,         -2},
    {SP_MERFOLK, SK_RANGED_WEAPONS, -2},
    {SP_MERFOLK, SK_THROWING,       0},
    {SP_MERFOLK, SK_ARMOUR,         -3},
    {SP_MERFOLK, SK_DODGING,        3},
    {SP_MERFOLK, SK_STEALTH,        2},
    {SP_MERFOLK, SK_SHIELDS,        0},
    {SP_MERFOLK, SK_UNARMED_COMBAT, 1},
    {SP_MERFOLK, SK_SPELLCASTING,   -1},
    {SP_MERFOLK, SK_CONJURATIONS,   -2},
    {SP_MERFOLK, SK_HEXES,          0},
    {SP_MERFOLK, SK_SUMMONINGS,     0},
    {SP_MERFOLK, SK_NECROMANCY,     -2},
    {SP_MERFOLK, SK_FORGECRAFT,     0},
    {SP_MERFOLK, SK_TRANSLOCATIONS, -2},
    {SP_MERFOLK, SK_FIRE_MAGIC,     -3},
    {SP_MERFOLK, SK_ICE_MAGIC,      1},
    {SP_MERFOLK, SK_AIR_MAGIC,      -2},
    {SP_MERFOLK, SK_EARTH_MAGIC,    -2},
    {SP_MERFOLK, SK_ALCHEMY,        3},
    {SP_MERFOLK, SK_INVOCATIONS,    1},
    {SP_MERFOLK, SK_EVOCATIONS,     0},
    {SP_MERFOLK, SK_SHAPESHIFTING,  2},
#if TAG_MAJOR_VERSION == 34
    {SP_MERFOLK, SK_STABBING,       UNUSABLE_SKILL},
    {SP_MERFOLK, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_MERFOLK, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_MERFOLK, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_MERFOLK, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif

#if TAG_MAJOR_VERSION == 34
    {SP_VAMPIRE, SK_FIGHTING,       -1},
    {SP_VAMPIRE, SK_SHORT_BLADES,   1},
    {SP_VAMPIRE, SK_LONG_BLADES,    0},
    {SP_VAMPIRE, SK_AXES,           -1},
    {SP_VAMPIRE, SK_MACES_FLAILS,   -2},
    {SP_VAMPIRE, SK_POLEARMS,       -1},
    {SP_VAMPIRE, SK_STAVES,         -2},
    {SP_VAMPIRE, SK_RANGED_WEAPONS, -2},
    {SP_VAMPIRE, SK_THROWING,       -2},
    {SP_VAMPIRE, SK_ARMOUR,         -2},
    {SP_VAMPIRE, SK_DODGING,        1},
    {SP_VAMPIRE, SK_STEALTH,        5},
    {SP_VAMPIRE, SK_SHIELDS,        -1},
    {SP_VAMPIRE, SK_UNARMED_COMBAT, 1},
    {SP_VAMPIRE, SK_SPELLCASTING,   -1},
    {SP_VAMPIRE, SK_CONJURATIONS,   -3},
    {SP_VAMPIRE, SK_HEXES,          4},
    {SP_VAMPIRE, SK_SUMMONINGS,     0},
    {SP_VAMPIRE, SK_NECROMANCY,     1},
    {SP_VAMPIRE, SK_FORGECRAFT,     0},
    {SP_VAMPIRE, SK_TRANSLOCATIONS, -2},
    {SP_VAMPIRE, SK_FIRE_MAGIC,     -2},
    {SP_VAMPIRE, SK_ICE_MAGIC,      0},
    {SP_VAMPIRE, SK_AIR_MAGIC,      0},
    {SP_VAMPIRE, SK_EARTH_MAGIC,    0},
    {SP_VAMPIRE, SK_ALCHEMY,        1},
    {SP_VAMPIRE, SK_INVOCATIONS,    -1},
    {SP_VAMPIRE, SK_EVOCATIONS,     -1},
    {SP_VAMPIRE, SK_SHAPESHIFTING,  0},
#if TAG_MAJOR_VERSION == 34
    {SP_VAMPIRE, SK_STABBING,       UNUSABLE_SKILL},
    {SP_VAMPIRE, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_VAMPIRE, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_VAMPIRE, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_VAMPIRE, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif
#if TAG_MAJOR_VERSION == 34
    {SP_DEEP_DWARF, SK_FIGHTING,       -1},
    {SP_DEEP_DWARF, SK_SHORT_BLADES,   -1},
    {SP_DEEP_DWARF, SK_LONG_BLADES,    0},
    {SP_DEEP_DWARF, SK_AXES,           1},
    {SP_DEEP_DWARF, SK_MACES_FLAILS,   0},
    {SP_DEEP_DWARF, SK_POLEARMS,       -1},
    {SP_DEEP_DWARF, SK_STAVES,         -1},
    {SP_DEEP_DWARF, SK_RANGED_WEAPONS, 1},
    {SP_DEEP_DWARF, SK_THROWING,       -1},
    {SP_DEEP_DWARF, SK_ARMOUR,         1},
    {SP_DEEP_DWARF, SK_DODGING,        1},
    {SP_DEEP_DWARF, SK_STEALTH,        3},
    {SP_DEEP_DWARF, SK_SHIELDS,        1},
    {SP_DEEP_DWARF, SK_UNARMED_COMBAT, -1},
    {SP_DEEP_DWARF, SK_SPELLCASTING,   -2},
    {SP_DEEP_DWARF, SK_CONJURATIONS,   -1},
    {SP_DEEP_DWARF, SK_HEXES,          -2},
    {SP_DEEP_DWARF, SK_SUMMONINGS,     -1},
    {SP_DEEP_DWARF, SK_NECROMANCY,     1},
    {SP_DEEP_DWARF, SK_FORGECRAFT,     0},
    {SP_DEEP_DWARF, SK_TRANSLOCATIONS, 1},
    {SP_DEEP_DWARF, SK_FIRE_MAGIC,     -1},
    {SP_DEEP_DWARF, SK_ICE_MAGIC,      -1},
    {SP_DEEP_DWARF, SK_AIR_MAGIC,      -3},
    {SP_DEEP_DWARF, SK_EARTH_MAGIC,    3},
    {SP_DEEP_DWARF, SK_ALCHEMY,        -2},
    {SP_DEEP_DWARF, SK_INVOCATIONS,    3},
    {SP_DEEP_DWARF, SK_EVOCATIONS,     3},
    {SP_DEEP_DWARF, SK_SHAPESHIFTING,  0},
#if TAG_MAJOR_VERSION == 34
    {SP_DEEP_DWARF, SK_STABBING,       UNUSABLE_SKILL},
    {SP_DEEP_DWARF, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_DEEP_DWARF, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_DEEP_DWARF, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_DEEP_DWARF, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif

    {SP_FELID, SK_FIGHTING,       0},
    {SP_FELID, SK_SHORT_BLADES,   UNUSABLE_SKILL},
    {SP_FELID, SK_LONG_BLADES,    UNUSABLE_SKILL},
    {SP_FELID, SK_AXES,           UNUSABLE_SKILL},
    {SP_FELID, SK_MACES_FLAILS,   UNUSABLE_SKILL},
    {SP_FELID, SK_POLEARMS,       UNUSABLE_SKILL},
    {SP_FELID, SK_STAVES,         UNUSABLE_SKILL},
    {SP_FELID, SK_RANGED_WEAPONS, UNUSABLE_SKILL},
    {SP_FELID, SK_THROWING,       UNUSABLE_SKILL},
    {SP_FELID, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_FELID, SK_DODGING,        3},
    {SP_FELID, SK_STEALTH,        4},
    {SP_FELID, SK_SHIELDS,        UNUSABLE_SKILL},
    {SP_FELID, SK_UNARMED_COMBAT, 0},
    {SP_FELID, SK_SPELLCASTING,   -1},
    {SP_FELID, SK_CONJURATIONS,   -1},
    {SP_FELID, SK_HEXES,          4},
    {SP_FELID, SK_SUMMONINGS,     0},
    {SP_FELID, SK_NECROMANCY,     0},
    {SP_FELID, SK_FORGECRAFT,     -1},
    {SP_FELID, SK_TRANSLOCATIONS, 4},
    {SP_FELID, SK_FIRE_MAGIC,     -1},
    {SP_FELID, SK_ICE_MAGIC,      -1},
    {SP_FELID, SK_AIR_MAGIC,      -1},
    {SP_FELID, SK_EARTH_MAGIC,    -1},
    {SP_FELID, SK_ALCHEMY,        -1},
    {SP_FELID, SK_INVOCATIONS,    0},
    {SP_FELID, SK_EVOCATIONS,     1},
    {SP_FELID, SK_SHAPESHIFTING,  -2},
#if TAG_MAJOR_VERSION == 34
    {SP_FELID, SK_STABBING,       UNUSABLE_SKILL},
    {SP_FELID, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_FELID, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_FELID, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_FELID, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_OCTOPODE, SK_FIGHTING,       0},
    {SP_OCTOPODE, SK_SHORT_BLADES,   0},
    {SP_OCTOPODE, SK_LONG_BLADES,    0},
    {SP_OCTOPODE, SK_AXES,           0},
    {SP_OCTOPODE, SK_MACES_FLAILS,   0},
    {SP_OCTOPODE, SK_POLEARMS,       0},
    {SP_OCTOPODE, SK_STAVES,         0},
    {SP_OCTOPODE, SK_RANGED_WEAPONS, 0},
    {SP_OCTOPODE, SK_THROWING,       0},
    {SP_OCTOPODE, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_OCTOPODE, SK_DODGING,        0},
    {SP_OCTOPODE, SK_STEALTH,        4},
    {SP_OCTOPODE, SK_SHIELDS,        0},
    {SP_OCTOPODE, SK_UNARMED_COMBAT, 0},
    {SP_OCTOPODE, SK_SPELLCASTING,   -1},
    {SP_OCTOPODE, SK_CONJURATIONS,   0},
    {SP_OCTOPODE, SK_HEXES,          0},
    {SP_OCTOPODE, SK_SUMMONINGS,     0},
    {SP_OCTOPODE, SK_NECROMANCY,     0},
    {SP_OCTOPODE, SK_FORGECRAFT,     0},
    {SP_OCTOPODE, SK_TRANSLOCATIONS, 0},
    {SP_OCTOPODE, SK_FIRE_MAGIC,     0},
    {SP_OCTOPODE, SK_ICE_MAGIC,      0},
    {SP_OCTOPODE, SK_AIR_MAGIC,      0},
    {SP_OCTOPODE, SK_EARTH_MAGIC,    0},
    {SP_OCTOPODE, SK_ALCHEMY,        1},
    {SP_OCTOPODE, SK_INVOCATIONS,    1},
    {SP_OCTOPODE, SK_EVOCATIONS,     1},
    {SP_OCTOPODE, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_OCTOPODE, SK_STABBING,       UNUSABLE_SKILL},
    {SP_OCTOPODE, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_OCTOPODE, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_OCTOPODE, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_OCTOPODE, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_DJINNI, SK_FIGHTING,       0},
    {SP_DJINNI, SK_SHORT_BLADES,   -1},
    {SP_DJINNI, SK_LONG_BLADES,    -1},
    {SP_DJINNI, SK_AXES,           -2},
    {SP_DJINNI, SK_MACES_FLAILS,   -2},
    {SP_DJINNI, SK_POLEARMS,       -2},
    {SP_DJINNI, SK_STAVES,         -1},
    {SP_DJINNI, SK_RANGED_WEAPONS, -2},
    {SP_DJINNI, SK_THROWING,       -2},
    {SP_DJINNI, SK_ARMOUR,         0},
    {SP_DJINNI, SK_DODGING,        1},
    {SP_DJINNI, SK_STEALTH,        -1},
    {SP_DJINNI, SK_SHIELDS,        0},
    {SP_DJINNI, SK_UNARMED_COMBAT, 0},
    {SP_DJINNI, SK_SPELLCASTING,   11},
    {SP_DJINNI, SK_CONJURATIONS,   11},
    {SP_DJINNI, SK_HEXES,          11},
    {SP_DJINNI, SK_SUMMONINGS,     11},
    {SP_DJINNI, SK_NECROMANCY,     11},
    {SP_DJINNI, SK_FORGECRAFT,     11},
    {SP_DJINNI, SK_TRANSLOCATIONS, 11},
    {SP_DJINNI, SK_FIRE_MAGIC,     11},
    {SP_DJINNI, SK_ICE_MAGIC,      11},
    {SP_DJINNI, SK_AIR_MAGIC,      11},
    {SP_DJINNI, SK_EARTH_MAGIC,    11},
    {SP_DJINNI, SK_ALCHEMY,        11},
    {SP_DJINNI, SK_INVOCATIONS,    0},
    {SP_DJINNI, SK_EVOCATIONS,     0},
    {SP_DJINNI, SK_SHAPESHIFTING,  -2},
#if TAG_MAJOR_VERSION == 34
    {SP_DJINNI, SK_STABBING,       UNUSABLE_SKILL},
    {SP_DJINNI, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_DJINNI, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_DJINNI, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_DJINNI, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif

#if TAG_MAJOR_VERSION == 34
    {SP_LAVA_ORC, SK_FIGHTING,       2},
    {SP_LAVA_ORC, SK_SHORT_BLADES,   0},
    {SP_LAVA_ORC, SK_LONG_BLADES,    1},
    {SP_LAVA_ORC, SK_AXES,           2},
    {SP_LAVA_ORC, SK_MACES_FLAILS,   1},
    {SP_LAVA_ORC, SK_POLEARMS,       1},
    {SP_LAVA_ORC, SK_STAVES,         -1},
    {SP_LAVA_ORC, SK_RANGED_WEAPONS, -2},
    {SP_LAVA_ORC, SK_THROWING,       -1},
    {SP_LAVA_ORC, SK_ARMOUR,         1},
    {SP_LAVA_ORC, SK_DODGING,        -2},
    {SP_LAVA_ORC, SK_STEALTH,        -1},
    {SP_LAVA_ORC, SK_SHIELDS,        1},
    {SP_LAVA_ORC, SK_UNARMED_COMBAT, 1},
    {SP_LAVA_ORC, SK_SPELLCASTING,   -3},
    {SP_LAVA_ORC, SK_CONJURATIONS,   0},
    {SP_LAVA_ORC, SK_HEXES,          0},
    {SP_LAVA_ORC, SK_SUMMONINGS,     0},
    {SP_LAVA_ORC, SK_NECROMANCY,     0},
    {SP_LAVA_ORC, SK_FORGECRAFT,     0},
    {SP_LAVA_ORC, SK_TRANSLOCATIONS, -2},
    {SP_LAVA_ORC, SK_FIRE_MAGIC,     2},
    {SP_LAVA_ORC, SK_ICE_MAGIC,      -4},
    {SP_LAVA_ORC, SK_AIR_MAGIC,      -3},
    {SP_LAVA_ORC, SK_EARTH_MAGIC,    1},
    {SP_LAVA_ORC, SK_ALCHEMY,        -1},
    {SP_LAVA_ORC, SK_INVOCATIONS,    3},
    {SP_LAVA_ORC, SK_EVOCATIONS,     0},
    {SP_LAVA_ORC, SK_SHAPESHIFTING,  1},
#if TAG_MAJOR_VERSION == 34
    {SP_LAVA_ORC, SK_STABBING,       UNUSABLE_SKILL},
    {SP_LAVA_ORC, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_LAVA_ORC, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_LAVA_ORC, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_LAVA_ORC, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif

    {SP_GARGOYLE, SK_FIGHTING,       1},
    {SP_GARGOYLE, SK_SHORT_BLADES,   -1},
    {SP_GARGOYLE, SK_LONG_BLADES,    -1},
    {SP_GARGOYLE, SK_AXES,           -1},
    {SP_GARGOYLE, SK_MACES_FLAILS,   0},
    {SP_GARGOYLE, SK_POLEARMS,       -1},
    {SP_GARGOYLE, SK_STAVES,         0},
    {SP_GARGOYLE, SK_RANGED_WEAPONS, 0},
    {SP_GARGOYLE, SK_THROWING,       -1},
    {SP_GARGOYLE, SK_ARMOUR,         1},
    {SP_GARGOYLE, SK_DODGING,        -2},
    {SP_GARGOYLE, SK_STEALTH,        2},
    {SP_GARGOYLE, SK_SHIELDS,        1},
    {SP_GARGOYLE, SK_UNARMED_COMBAT, 0},
    {SP_GARGOYLE, SK_SPELLCASTING,   -1},
    {SP_GARGOYLE, SK_CONJURATIONS,   1},
    {SP_GARGOYLE, SK_HEXES,          -1},
    {SP_GARGOYLE, SK_SUMMONINGS,     -1},
    {SP_GARGOYLE, SK_NECROMANCY,     -2},
    {SP_GARGOYLE, SK_FORGECRAFT,     -1},
    {SP_GARGOYLE, SK_TRANSLOCATIONS, -1},
    {SP_GARGOYLE, SK_FIRE_MAGIC,     0},
    {SP_GARGOYLE, SK_ICE_MAGIC,      0},
    {SP_GARGOYLE, SK_AIR_MAGIC,      -2},
    {SP_GARGOYLE, SK_EARTH_MAGIC,    2},
    {SP_GARGOYLE, SK_ALCHEMY,        -2},
    {SP_GARGOYLE, SK_INVOCATIONS,    1},
    {SP_GARGOYLE, SK_EVOCATIONS,     -1},
    {SP_GARGOYLE, SK_SHAPESHIFTING,  -3},
#if TAG_MAJOR_VERSION == 34
    {SP_GARGOYLE, SK_STABBING,       UNUSABLE_SKILL},
    {SP_GARGOYLE, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_GARGOYLE, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_GARGOYLE, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_GARGOYLE, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_FORMICID, SK_FIGHTING,       1},
    {SP_FORMICID, SK_SHORT_BLADES,   0},
    {SP_FORMICID, SK_LONG_BLADES,    0},
    {SP_FORMICID, SK_AXES,           0},
    {SP_FORMICID, SK_MACES_FLAILS,   0},
    {SP_FORMICID, SK_POLEARMS,       0},
    {SP_FORMICID, SK_STAVES,         0},
    {SP_FORMICID, SK_RANGED_WEAPONS, 0},
    {SP_FORMICID, SK_THROWING,       0},
    {SP_FORMICID, SK_ARMOUR,         1},
    {SP_FORMICID, SK_DODGING,        -1},
    {SP_FORMICID, SK_STEALTH,        3},
    {SP_FORMICID, SK_SHIELDS,        3},
    {SP_FORMICID, SK_UNARMED_COMBAT, 0},
    {SP_FORMICID, SK_SPELLCASTING,   0},
    {SP_FORMICID, SK_CONJURATIONS,   -1},
    {SP_FORMICID, SK_HEXES,          2},
    {SP_FORMICID, SK_SUMMONINGS,     0},
    {SP_FORMICID, SK_NECROMANCY,     0},
    {SP_FORMICID, SK_FORGECRAFT,     0},
    {SP_FORMICID, SK_TRANSLOCATIONS, 2},
    {SP_FORMICID, SK_FIRE_MAGIC,     0},
    {SP_FORMICID, SK_ICE_MAGIC,      0},
    {SP_FORMICID, SK_AIR_MAGIC,      -2},
    {SP_FORMICID, SK_EARTH_MAGIC,    2},
    {SP_FORMICID, SK_ALCHEMY,        3},
    {SP_FORMICID, SK_INVOCATIONS,    2},
    {SP_FORMICID, SK_EVOCATIONS,     1},
    {SP_FORMICID, SK_SHAPESHIFTING,  0},
#if TAG_MAJOR_VERSION == 34
    {SP_FORMICID, SK_STABBING,       UNUSABLE_SKILL},
    {SP_FORMICID, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_FORMICID, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_FORMICID, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_FORMICID, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_VINE_STALKER, SK_FIGHTING,       -1},
    {SP_VINE_STALKER, SK_SHORT_BLADES,   -1},
    {SP_VINE_STALKER, SK_LONG_BLADES,    -1},
    {SP_VINE_STALKER, SK_AXES,           -1},
    {SP_VINE_STALKER, SK_MACES_FLAILS,   -1},
    {SP_VINE_STALKER, SK_POLEARMS,       -1},
    {SP_VINE_STALKER, SK_STAVES,         -1},
    {SP_VINE_STALKER, SK_RANGED_WEAPONS, -1},
    {SP_VINE_STALKER, SK_THROWING,       -1},
    {SP_VINE_STALKER, SK_ARMOUR,         -2},
    {SP_VINE_STALKER, SK_DODGING,        -2},
    {SP_VINE_STALKER, SK_STEALTH,        3},
    {SP_VINE_STALKER, SK_SHIELDS,        -1},
    {SP_VINE_STALKER, SK_UNARMED_COMBAT, 0},
    {SP_VINE_STALKER, SK_SPELLCASTING,   0},
    {SP_VINE_STALKER, SK_CONJURATIONS,   0},
    {SP_VINE_STALKER, SK_HEXES,          0},
    {SP_VINE_STALKER, SK_SUMMONINGS,     0},
    {SP_VINE_STALKER, SK_NECROMANCY,     0},
    {SP_VINE_STALKER, SK_FORGECRAFT,     0},
    {SP_VINE_STALKER, SK_TRANSLOCATIONS, 0},
    {SP_VINE_STALKER, SK_FIRE_MAGIC,     0},
    {SP_VINE_STALKER, SK_ICE_MAGIC,      0},
    {SP_VINE_STALKER, SK_AIR_MAGIC,      0},
    {SP_VINE_STALKER, SK_EARTH_MAGIC,    0},
    {SP_VINE_STALKER, SK_ALCHEMY,        0},
    {SP_VINE_STALKER, SK_INVOCATIONS,    0},
    {SP_VINE_STALKER, SK_EVOCATIONS,     -1},
    {SP_VINE_STALKER, SK_SHAPESHIFTING,  -1},
#if TAG_MAJOR_VERSION == 34
    {SP_VINE_STALKER, SK_STABBING,       UNUSABLE_SKILL},
    {SP_VINE_STALKER, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_VINE_STALKER, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_VINE_STALKER, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_VINE_STALKER, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_BARACHI, SK_FIGHTING,       2},
    {SP_BARACHI, SK_SHORT_BLADES,   1},
    {SP_BARACHI, SK_LONG_BLADES,    2},
    {SP_BARACHI, SK_AXES,           1},
    {SP_BARACHI, SK_MACES_FLAILS,   1},
    {SP_BARACHI, SK_POLEARMS,       0},
    {SP_BARACHI, SK_STAVES,         1},
    {SP_BARACHI, SK_RANGED_WEAPONS, 0},
    {SP_BARACHI, SK_THROWING,       0},
    {SP_BARACHI, SK_ARMOUR,         2},
    {SP_BARACHI, SK_DODGING,        1},
    {SP_BARACHI, SK_STEALTH,        0},
    {SP_BARACHI, SK_SHIELDS,        1},
    {SP_BARACHI, SK_UNARMED_COMBAT, 1},
    {SP_BARACHI, SK_SPELLCASTING,   0},
    {SP_BARACHI, SK_CONJURATIONS,   1},
    {SP_BARACHI, SK_HEXES,          1},
    {SP_BARACHI, SK_SUMMONINGS,     2},
    {SP_BARACHI, SK_NECROMANCY,     -1},
    {SP_BARACHI, SK_FORGECRAFT,     1},
    {SP_BARACHI, SK_TRANSLOCATIONS, 1},
    {SP_BARACHI, SK_FIRE_MAGIC,     1},
    {SP_BARACHI, SK_ICE_MAGIC,      2},
    {SP_BARACHI, SK_AIR_MAGIC,      1},
    {SP_BARACHI, SK_EARTH_MAGIC,    0},
    {SP_BARACHI, SK_ALCHEMY,        1},
    {SP_BARACHI, SK_INVOCATIONS,    -1},
    {SP_BARACHI, SK_EVOCATIONS,     1},
    {SP_BARACHI, SK_SHAPESHIFTING,  0},
#if TAG_MAJOR_VERSION == 34
    {SP_BARACHI, SK_STABBING,       UNUSABLE_SKILL},
    {SP_BARACHI, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_BARACHI, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_BARACHI, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_BARACHI, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_GNOLL, SK_FIGHTING,       8},
    {SP_GNOLL, SK_SHORT_BLADES,   8},
    {SP_GNOLL, SK_LONG_BLADES,    8},
    {SP_GNOLL, SK_AXES,           8},
    {SP_GNOLL, SK_MACES_FLAILS,   8},
    {SP_GNOLL, SK_POLEARMS,       8},
    {SP_GNOLL, SK_STAVES,         8},
    {SP_GNOLL, SK_RANGED_WEAPONS, 8},
    {SP_GNOLL, SK_THROWING,       8},
    {SP_GNOLL, SK_ARMOUR,         8},
    {SP_GNOLL, SK_DODGING,        8},
    {SP_GNOLL, SK_STEALTH,        8},
    {SP_GNOLL, SK_SHIELDS,        8},
    {SP_GNOLL, SK_UNARMED_COMBAT, 8},
    {SP_GNOLL, SK_SPELLCASTING,   8},
    {SP_GNOLL, SK_CONJURATIONS,   6},
    {SP_GNOLL, SK_HEXES,          6},
    {SP_GNOLL, SK_SUMMONINGS,     6},
    {SP_GNOLL, SK_NECROMANCY,     6},
    {SP_GNOLL, SK_FORGECRAFT,     6},
    {SP_GNOLL, SK_TRANSLOCATIONS, 6},
    {SP_GNOLL, SK_FIRE_MAGIC,     6},
    {SP_GNOLL, SK_ICE_MAGIC,      6},
    {SP_GNOLL, SK_AIR_MAGIC,      6},
    {SP_GNOLL, SK_EARTH_MAGIC,    6},
    {SP_GNOLL, SK_ALCHEMY,        6},
    {SP_GNOLL, SK_INVOCATIONS,    9},
    {SP_GNOLL, SK_EVOCATIONS,     8},
    {SP_GNOLL, SK_SHAPESHIFTING,  7},
#if TAG_MAJOR_VERSION == 34
    {SP_GNOLL, SK_STABBING,       UNUSABLE_SKILL},
    {SP_GNOLL, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_GNOLL, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_GNOLL, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_GNOLL, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_ARMATAUR, SK_FIGHTING,       -1},
    {SP_ARMATAUR, SK_SHORT_BLADES,   -1},
    {SP_ARMATAUR, SK_LONG_BLADES,    -1},
    {SP_ARMATAUR, SK_AXES,           -2},
    {SP_ARMATAUR, SK_MACES_FLAILS,   -1},
    {SP_ARMATAUR, SK_POLEARMS,       -2},
    {SP_ARMATAUR, SK_STAVES,         -1},
    {SP_ARMATAUR, SK_RANGED_WEAPONS, -3},
    {SP_ARMATAUR, SK_THROWING,       -1},
    {SP_ARMATAUR, SK_ARMOUR,         3},
    {SP_ARMATAUR, SK_DODGING,        -3},
    {SP_ARMATAUR, SK_STEALTH,        2},
    {SP_ARMATAUR, SK_SHIELDS,        1},
    {SP_ARMATAUR, SK_UNARMED_COMBAT, -1},
    {SP_ARMATAUR, SK_SPELLCASTING,   -2},
    {SP_ARMATAUR, SK_CONJURATIONS,   -1},
    {SP_ARMATAUR, SK_HEXES,          -1},
    {SP_ARMATAUR, SK_SUMMONINGS,     -2},
    {SP_ARMATAUR, SK_NECROMANCY,     -2},
    {SP_ARMATAUR, SK_FORGECRAFT,     -2},
    {SP_ARMATAUR, SK_TRANSLOCATIONS, 0},
    {SP_ARMATAUR, SK_FIRE_MAGIC,     -1},
    {SP_ARMATAUR, SK_ICE_MAGIC,      -1},
    {SP_ARMATAUR, SK_AIR_MAGIC,      -1},
    {SP_ARMATAUR, SK_EARTH_MAGIC,    -1},
    {SP_ARMATAUR, SK_ALCHEMY,        -1},
    {SP_ARMATAUR, SK_INVOCATIONS,    0},
    {SP_ARMATAUR, SK_EVOCATIONS,     0},
    {SP_ARMATAUR, SK_SHAPESHIFTING,  -2},
#if TAG_MAJOR_VERSION == 34
    {SP_ARMATAUR, SK_STABBING,       UNUSABLE_SKILL},
    {SP_ARMATAUR, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_ARMATAUR, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_ARMATAUR, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_ARMATAUR, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif

#if TAG_MAJOR_VERSION == 34
    {SP_MAYFLYTAUR, SK_FIGHTING,       1},
    {SP_MAYFLYTAUR, SK_SHORT_BLADES,   3},
    {SP_MAYFLYTAUR, SK_LONG_BLADES,    3},
    {SP_MAYFLYTAUR, SK_AXES,           1},
    {SP_MAYFLYTAUR, SK_MACES_FLAILS,   3},
    {SP_MAYFLYTAUR, SK_POLEARMS,       3},
    {SP_MAYFLYTAUR, SK_STAVES,         3},
    {SP_MAYFLYTAUR, SK_RANGED_WEAPONS, 2},
    {SP_MAYFLYTAUR, SK_THROWING,       2},
    {SP_MAYFLYTAUR, SK_ARMOUR,         1},
    {SP_MAYFLYTAUR, SK_DODGING,        1},
    {SP_MAYFLYTAUR, SK_STEALTH,        3},
    {SP_MAYFLYTAUR, SK_SHIELDS,        1},
    {SP_MAYFLYTAUR, SK_UNARMED_COMBAT, 3},
    {SP_MAYFLYTAUR, SK_SPELLCASTING,   2},
    {SP_MAYFLYTAUR, SK_CONJURATIONS,   1},
    {SP_MAYFLYTAUR, SK_HEXES,          2},
    {SP_MAYFLYTAUR, SK_SUMMONINGS,     2},
    {SP_MAYFLYTAUR, SK_NECROMANCY,     1},
    {SP_MAYFLYTAUR, SK_FORGECRAFT,     0},
    {SP_MAYFLYTAUR, SK_TRANSLOCATIONS, 2},
    {SP_MAYFLYTAUR, SK_FIRE_MAGIC,     1},
    {SP_MAYFLYTAUR, SK_ICE_MAGIC,      1},
    {SP_MAYFLYTAUR, SK_AIR_MAGIC,      1},
    {SP_MAYFLYTAUR, SK_EARTH_MAGIC,    1},
    {SP_MAYFLYTAUR, SK_ALCHEMY,        1},
    {SP_MAYFLYTAUR, SK_INVOCATIONS,    2},
    {SP_MAYFLYTAUR, SK_EVOCATIONS,     1},
    {SP_MAYFLYTAUR, SK_SHAPESHIFTING,  0},
#if TAG_MAJOR_VERSION == 34
    {SP_MAYFLYTAUR, SK_STABBING,       UNUSABLE_SKILL},
    {SP_MAYFLYTAUR, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_MAYFLYTAUR, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_MAYFLYTAUR, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_MAYFLYTAUR, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif
#if TAG_MAJOR_VERSION == 34
    {SP_METEORAN, SK_FIGHTING,       1},
    {SP_METEORAN, SK_SHORT_BLADES,   1},
    {SP_METEORAN, SK_LONG_BLADES,    2},
    {SP_METEORAN, SK_AXES,           2},
    {SP_METEORAN, SK_MACES_FLAILS,   3},
    {SP_METEORAN, SK_POLEARMS,       2},
    {SP_METEORAN, SK_STAVES,         2},
    {SP_METEORAN, SK_RANGED_WEAPONS, 1},
    {SP_METEORAN, SK_THROWING,       2},
    {SP_METEORAN, SK_ARMOUR,         1},
    {SP_METEORAN, SK_DODGING,        1},
    {SP_METEORAN, SK_STEALTH,        -2},
    {SP_METEORAN, SK_SHIELDS,        1},
    {SP_METEORAN, SK_UNARMED_COMBAT, 2},
    {SP_METEORAN, SK_SPELLCASTING,   2},
    {SP_METEORAN, SK_CONJURATIONS,   2},
    {SP_METEORAN, SK_HEXES,          2},
    {SP_METEORAN, SK_SUMMONINGS,     2},
    {SP_METEORAN, SK_NECROMANCY,     1},
    {SP_METEORAN, SK_FORGECRAFT,     0},
    {SP_METEORAN, SK_TRANSLOCATIONS, 2},
    {SP_METEORAN, SK_FIRE_MAGIC,     2},
    {SP_METEORAN, SK_ICE_MAGIC,      1},
    {SP_METEORAN, SK_AIR_MAGIC,      2},
    {SP_METEORAN, SK_EARTH_MAGIC,    2},
    {SP_METEORAN, SK_ALCHEMY,        2},
    {SP_METEORAN, SK_INVOCATIONS,    3},
    {SP_METEORAN, SK_EVOCATIONS,     2},
    {SP_METEORAN, SK_SHAPESHIFTING,  1},
#if TAG_MAJOR_VERSION == 34
    {SP_METEORAN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_METEORAN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_METEORAN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_METEORAN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_METEORAN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif
#endif

    {SP_MOUNTAIN_DWARF, SK_FIGHTING,       1},
    {SP_MOUNTAIN_DWARF, SK_SHORT_BLADES,   -2},
    {SP_MOUNTAIN_DWARF, SK_LONG_BLADES,    -1},
    {SP_MOUNTAIN_DWARF, SK_AXES,           2},
    {SP_MOUNTAIN_DWARF, SK_MACES_FLAILS,   2},
    {SP_MOUNTAIN_DWARF, SK_POLEARMS,       0},
    {SP_MOUNTAIN_DWARF, SK_STAVES,         1},
    {SP_MOUNTAIN_DWARF, SK_RANGED_WEAPONS, -2},
    {SP_MOUNTAIN_DWARF, SK_THROWING,       -2},
    {SP_MOUNTAIN_DWARF, SK_ARMOUR,         1},
    {SP_MOUNTAIN_DWARF, SK_DODGING,        -3},
    {SP_MOUNTAIN_DWARF, SK_STEALTH,        -2},
    {SP_MOUNTAIN_DWARF, SK_SHIELDS,        1},
    {SP_MOUNTAIN_DWARF, SK_UNARMED_COMBAT, 0},
    {SP_MOUNTAIN_DWARF, SK_SPELLCASTING,   -2},
    {SP_MOUNTAIN_DWARF, SK_CONJURATIONS,   -1},
    {SP_MOUNTAIN_DWARF, SK_HEXES,          0},
    {SP_MOUNTAIN_DWARF, SK_SUMMONINGS,     -2},
    {SP_MOUNTAIN_DWARF, SK_NECROMANCY,     1},
    {SP_MOUNTAIN_DWARF, SK_FORGECRAFT,     2},
    {SP_MOUNTAIN_DWARF, SK_TRANSLOCATIONS, -2},
    {SP_MOUNTAIN_DWARF, SK_FIRE_MAGIC,     2},
    {SP_MOUNTAIN_DWARF, SK_ICE_MAGIC,      -1},
    {SP_MOUNTAIN_DWARF, SK_AIR_MAGIC,      -3},
    {SP_MOUNTAIN_DWARF, SK_EARTH_MAGIC,    1},
    {SP_MOUNTAIN_DWARF, SK_ALCHEMY,        -2},
    {SP_MOUNTAIN_DWARF, SK_INVOCATIONS,    3},
    {SP_MOUNTAIN_DWARF, SK_EVOCATIONS,     1},
    {SP_MOUNTAIN_DWARF, SK_SHAPESHIFTING,  -2},
#if TAG_MAJOR_VERSION == 34
    {SP_MOUNTAIN_DWARF, SK_STABBING,       UNUSABLE_SKILL},
    {SP_MOUNTAIN_DWARF, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_MOUNTAIN_DWARF, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_MOUNTAIN_DWARF, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_MOUNTAIN_DWARF, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_COGLIN, SK_FIGHTING,       0},
    {SP_COGLIN, SK_SHORT_BLADES,   -1},
    {SP_COGLIN, SK_LONG_BLADES,    0},
    {SP_COGLIN, SK_AXES,           0},
    {SP_COGLIN, SK_MACES_FLAILS,   -1},
    {SP_COGLIN, SK_POLEARMS,       -1},
    {SP_COGLIN, SK_STAVES,         -1},
    {SP_COGLIN, SK_RANGED_WEAPONS, -1},
    {SP_COGLIN, SK_THROWING,       -1},
    {SP_COGLIN, SK_ARMOUR,         -1},
    {SP_COGLIN, SK_DODGING,        -1},
    {SP_COGLIN, SK_STEALTH,        -1},
    {SP_COGLIN, SK_SHIELDS,        -3},
    {SP_COGLIN, SK_UNARMED_COMBAT, -1},
    {SP_COGLIN, SK_SPELLCASTING,   -2},
    {SP_COGLIN, SK_CONJURATIONS,   -1},
    {SP_COGLIN, SK_HEXES,          -1},
    {SP_COGLIN, SK_SUMMONINGS,     0},
    {SP_COGLIN, SK_NECROMANCY,     0},
    {SP_COGLIN, SK_FORGECRAFT,     2},
    {SP_COGLIN, SK_TRANSLOCATIONS, 0},
    {SP_COGLIN, SK_FIRE_MAGIC,     -1},
    {SP_COGLIN, SK_ICE_MAGIC,      -1},
    {SP_COGLIN, SK_AIR_MAGIC,      -1},
    {SP_COGLIN, SK_EARTH_MAGIC,    -1},
    {SP_COGLIN, SK_ALCHEMY,        1},
    {SP_COGLIN, SK_INVOCATIONS,    -2},
    {SP_COGLIN, SK_EVOCATIONS,     3},
    {SP_COGLIN, SK_SHAPESHIFTING,  -2},
#if TAG_MAJOR_VERSION == 34
    {SP_COGLIN, SK_STABBING,       UNUSABLE_SKILL},
    {SP_COGLIN, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_COGLIN, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_COGLIN, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_COGLIN, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_POLTERGEIST, SK_FIGHTING,       -1},
    {SP_POLTERGEIST, SK_SHORT_BLADES,   1},
    {SP_POLTERGEIST, SK_LONG_BLADES,    0},
    {SP_POLTERGEIST, SK_AXES,           -1},
    {SP_POLTERGEIST, SK_MACES_FLAILS,   -2},
    {SP_POLTERGEIST, SK_POLEARMS,       -1},
    {SP_POLTERGEIST, SK_STAVES,         -2},
    {SP_POLTERGEIST, SK_RANGED_WEAPONS, -2},
    {SP_POLTERGEIST, SK_THROWING,       2},
    {SP_POLTERGEIST, SK_ARMOUR,         UNUSABLE_SKILL},
    {SP_POLTERGEIST, SK_DODGING,        1},
    {SP_POLTERGEIST, SK_STEALTH,        5},
    {SP_POLTERGEIST, SK_SHIELDS,        -1},
    {SP_POLTERGEIST, SK_UNARMED_COMBAT, -3},
    {SP_POLTERGEIST, SK_SPELLCASTING,   -1},
    {SP_POLTERGEIST, SK_CONJURATIONS,   -3},
    {SP_POLTERGEIST, SK_HEXES,          4},
    {SP_POLTERGEIST, SK_SUMMONINGS,     0},
    {SP_POLTERGEIST, SK_NECROMANCY,     1},
    {SP_POLTERGEIST, SK_FORGECRAFT,     -1},
    {SP_POLTERGEIST, SK_TRANSLOCATIONS, 0},
    {SP_POLTERGEIST, SK_FIRE_MAGIC,     -1},
    {SP_POLTERGEIST, SK_ICE_MAGIC,      1},
    {SP_POLTERGEIST, SK_AIR_MAGIC,      1},
    {SP_POLTERGEIST, SK_EARTH_MAGIC,    -1},
    {SP_POLTERGEIST, SK_ALCHEMY,        1},
    {SP_POLTERGEIST, SK_INVOCATIONS,    -1},
    {SP_POLTERGEIST, SK_EVOCATIONS,     -1},
    {SP_POLTERGEIST, SK_SHAPESHIFTING,  UNUSABLE_SKILL},
#if TAG_MAJOR_VERSION == 34
    {SP_POLTERGEIST, SK_STABBING,       UNUSABLE_SKILL},
    {SP_POLTERGEIST, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_POLTERGEIST, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_POLTERGEIST, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_POLTERGEIST, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif


    {SP_REVENANT, SK_FIGHTING,       1},
    {SP_REVENANT, SK_SHORT_BLADES,   -1},
    {SP_REVENANT, SK_LONG_BLADES,    -1},
    {SP_REVENANT, SK_AXES,           -1},
    {SP_REVENANT, SK_MACES_FLAILS,   -1},
    {SP_REVENANT, SK_POLEARMS,       -1},
    {SP_REVENANT, SK_STAVES,         -1},
    {SP_REVENANT, SK_RANGED_WEAPONS, -3},
    {SP_REVENANT, SK_THROWING,       -1},
    {SP_REVENANT, SK_ARMOUR,         -1},
    {SP_REVENANT, SK_DODGING,        -1},
    {SP_REVENANT, SK_STEALTH,        2},
    {SP_REVENANT, SK_SHIELDS,        -1},
    {SP_REVENANT, SK_UNARMED_COMBAT, 1},
    {SP_REVENANT, SK_SPELLCASTING,   -1},
    {SP_REVENANT, SK_CONJURATIONS,   -1},
    {SP_REVENANT, SK_HEXES,          -2},
    {SP_REVENANT, SK_SUMMONINGS,     -1},
    {SP_REVENANT, SK_NECROMANCY,     0},
    {SP_REVENANT, SK_FORGECRAFT,     -2},
    {SP_REVENANT, SK_TRANSLOCATIONS, -1},
    {SP_REVENANT, SK_FIRE_MAGIC,     -2},
    {SP_REVENANT, SK_ICE_MAGIC,      1},
    {SP_REVENANT, SK_AIR_MAGIC,      -2},
    {SP_REVENANT, SK_EARTH_MAGIC,    1},
    {SP_REVENANT, SK_ALCHEMY,        -1},
    {SP_REVENANT, SK_INVOCATIONS,    1},
    {SP_REVENANT, SK_EVOCATIONS,     -1},
    {SP_REVENANT, SK_SHAPESHIFTING,  UNUSABLE_SKILL},
#if TAG_MAJOR_VERSION == 34
    {SP_REVENANT, SK_STABBING,       UNUSABLE_SKILL},
    {SP_REVENANT, SK_TRAPS,          UNUSABLE_SKILL},
    {SP_REVENANT, SK_CHARMS,         UNUSABLE_SKILL},
    {SP_REVENANT, SK_SLINGS,         UNUSABLE_SKILL},
    {SP_REVENANT, SK_CROSSBOWS,      UNUSABLE_SKILL},
#endif

};
COMPILE_CHECK(ARRAYSZ(species_skill_aptitudes) == NUM_SPECIES * NUM_SKILLS);
