/* window_group.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from window_group.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright Budgie Desktop Developers
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include "budgie-windowing.h"
#include <libxfce4windowing/libxfce4windowing.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gdesktopappinfo.h>
#include <glib-object.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BUDGIE_WINDOWING_WINDOW_GROUP_0_PROPERTY,
	BUDGIE_WINDOWING_WINDOW_GROUP_APPLICATION_PROPERTY,
	BUDGIE_WINDOWING_WINDOW_GROUP_GROUP_ID_PROPERTY,
	BUDGIE_WINDOWING_WINDOW_GROUP_APP_INFO_PROPERTY,
	BUDGIE_WINDOWING_WINDOW_GROUP_NUM_PROPERTIES
};
static GParamSpec* budgie_windowing_window_group_properties[BUDGIE_WINDOWING_WINDOW_GROUP_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	BUDGIE_WINDOWING_WINDOW_GROUP_ACTIVE_WINDOW_CHANGED_SIGNAL,
	BUDGIE_WINDOWING_WINDOW_GROUP_APP_ICON_CHANGED_SIGNAL,
	BUDGIE_WINDOWING_WINDOW_GROUP_WINDOW_STATE_CHANGED_SIGNAL,
	BUDGIE_WINDOWING_WINDOW_GROUP_WINDOW_ADDED_SIGNAL,
	BUDGIE_WINDOWING_WINDOW_GROUP_WINDOW_REMOVED_SIGNAL,
	BUDGIE_WINDOWING_WINDOW_GROUP_NUM_SIGNALS
};
static guint budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_NUM_SIGNALS] = {0};

struct _BudgieWindowingWindowGroupPrivate {
	XfwApplication* _application;
	gchar* _group_id;
	GDesktopAppInfo* _app_info;
	GList* windows;
	XfwWindow* active_window;
	XfwWindow* last_active_window;
};

static gint BudgieWindowingWindowGroup_private_offset;
static gpointer budgie_windowing_window_group_parent_class = NULL;

static void budgie_windowing_window_group_icon_changed (BudgieWindowingWindowGroup* self);
static void budgie_windowing_window_group_state_changed (BudgieWindowingWindowGroup* self,
                                                  XfwWindow* window,
                                                  XfwWindowState changed_mask,
                                                  XfwWindowState new_state);
static void _budgie_windowing_window_group_state_changed_libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                                                          XfwWindowState changed_mask,
                                                                                          XfwWindowState new_state,
                                                                                          gpointer self);
static void g_cclosure_user_marshal_VOID__OBJECT_FLAGS_FLAGS (GClosure * closure,
                                                       GValue * return_value,
                                                       guint n_param_values,
                                                       const GValue * param_values,
                                                       gpointer invocation_hint,
                                                       gpointer marshal_data);
static GObject * budgie_windowing_window_group_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void _budgie_windowing_window_group_icon_changed_libxfce4windowing_application_icon_changed (XfwApplication* _sender,
                                                                                             gpointer self);
static void budgie_windowing_window_group_finalize (GObject * obj);
static GType budgie_windowing_window_group_get_type_once (void);
static void _vala_budgie_windowing_window_group_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_budgie_windowing_window_group_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
budgie_windowing_window_group_get_instance_private (BudgieWindowingWindowGroup* self)
{
	return G_STRUCT_MEMBER_P (self, BudgieWindowingWindowGroup_private_offset);
}

/**
 * Create a new WindowGroup for an application.
 */
BudgieWindowingWindowGroup*
budgie_windowing_window_group_construct (GType object_type,
                                         XfwApplication* application,
                                         GDesktopAppInfo* app_info)
{
	BudgieWindowingWindowGroup * self = NULL;
	const gchar* _tmp0_;
	g_return_val_if_fail (application != NULL, NULL);
	_tmp0_ = xfw_application_get_class_id (application);
	self = (BudgieWindowingWindowGroup*) g_object_new (object_type, "application", application, "group-id", _tmp0_, "app-info", app_info, NULL);
	return self;
}

BudgieWindowingWindowGroup*
budgie_windowing_window_group_new (XfwApplication* application,
                                   GDesktopAppInfo* app_info)
{
	return budgie_windowing_window_group_construct (BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, application, app_info);
}

static void
budgie_windowing_window_group_icon_changed (BudgieWindowingWindowGroup* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_APP_ICON_CHANGED_SIGNAL], 0);
}

static void
budgie_windowing_window_group_state_changed (BudgieWindowingWindowGroup* self,
                                             XfwWindow* window,
                                             XfwWindowState changed_mask,
                                             XfwWindowState new_state)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	g_signal_emit (self, budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_WINDOW_STATE_CHANGED_SIGNAL], 0, window, changed_mask, new_state);
}

/**
 * Adds a window to this WindowGroup.
 */
static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
_budgie_windowing_window_group_state_changed_libxfce4windowing_window_state_changed (XfwWindow* _sender,
                                                                                     XfwWindowState changed_mask,
                                                                                     XfwWindowState new_state,
                                                                                     gpointer self)
{
	budgie_windowing_window_group_state_changed ((BudgieWindowingWindowGroup*) self, _sender, changed_mask, new_state);
}

static inline gboolean
vala_g_list_is_empty (GList* self)
{
	gboolean result;
	result = ((GList*) self) == NULL;
	return result;
}

void
budgie_windowing_window_group_add_window (BudgieWindowingWindowGroup* self,
                                          XfwWindow* window)
{
	XfwApplication* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GList* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_application;
	_tmp1_ = xfw_application_get_name (_tmp0_);
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = xfw_window_get_name (window);
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat ("adding window to group '", _tmp2_, "': ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	g_debug ("window_group.vala:80: %s", _tmp6_);
	_g_free0 (_tmp6_);
	g_signal_connect_object (window, "state-changed", (GCallback) _budgie_windowing_window_group_state_changed_libxfce4windowing_window_state_changed, self, 0);
	_tmp7_ = self->priv->windows;
	if (vala_g_list_is_empty (_tmp7_)) {
		self->priv->last_active_window = window;
	}
	self->priv->windows = g_list_append (self->priv->windows, window);
	g_signal_emit (self, budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_WINDOW_ADDED_SIGNAL], 0, window);
}

/**
 * Removed a window from this WindowGroup, typically when the window
 * has been closed.
 */
void
budgie_windowing_window_group_remove_window (BudgieWindowingWindowGroup* self,
                                             XfwWindow* window)
{
	XfwApplication* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	XfwWindow* _tmp7_;
	XfwWindow* _tmp8_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	_tmp0_ = self->priv->_application;
	_tmp1_ = xfw_application_get_name (_tmp0_);
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = xfw_window_get_name (window);
	_tmp4_ = string_to_string (_tmp3_);
	_tmp5_ = g_strconcat ("removing window from group '", _tmp2_, "': ", _tmp4_, NULL);
	_tmp6_ = _tmp5_;
	g_debug ("window_group.vala:101: %s", _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->active_window;
	if (_tmp7_ == window) {
		self->priv->active_window = NULL;
	}
	_tmp8_ = self->priv->last_active_window;
	if (_tmp8_ == window) {
		XfwWindow* _tmp9_;
		_tmp9_ = budgie_windowing_window_group_get_next_window (self, window, TRUE);
		self->priv->last_active_window = _tmp9_;
	}
	g_signal_emit (self, budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_WINDOW_REMOVED_SIGNAL], 0, window);
	self->priv->windows = g_list_remove (self->priv->windows, window);
}

/**
 * Get the desktop ID of this application.
 *
 * Returns: the desktop ID of the application
 */
gchar*
budgie_windowing_window_group_get_desktop_id (BudgieWindowingWindowGroup* self)
{
	XfwApplication* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application;
	_tmp1_ = xfw_application_get_name (_tmp0_);
	_tmp2_ = g_strdup_printf ("%s.desktop", _tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * Get the currently active window in this group if
 * one is active.
 *
 * Returns: the currently active window, or NULL
 */
XfwWindow*
budgie_windowing_window_group_get_active_window (BudgieWindowingWindowGroup* self)
{
	XfwWindow* _tmp0_;
	XfwWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->active_window;
	result = _tmp0_;
	return result;
}

/**
 * Get the last active window in this group.
 *
 * Returns: the last active window, or NULL
 */
XfwWindow*
budgie_windowing_window_group_get_last_active_window (BudgieWindowingWindowGroup* self)
{
	XfwWindow* _tmp0_;
	XfwWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->last_active_window;
	result = _tmp0_;
	return result;
}

/**
 * Get the first opened window in this group.
 *
 * Returns: the first opened window or null
 */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

XfwWindow*
budgie_windowing_window_group_get_first_window (BudgieWindowingWindowGroup* self)
{
	GList* first = NULL;
	GList* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	GList* _tmp3_;
	gconstpointer _tmp4_;
	XfwWindow* _tmp5_;
	XfwWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->windows;
	_tmp1_ = g_list_first (_tmp0_);
	first = _tmp1_;
	_tmp2_ = first;
	if (_tmp2_ == NULL) {
		result = NULL;
		return result;
	}
	_tmp3_ = first;
	_tmp4_ = _tmp3_->data;
	_tmp5_ = _g_object_ref0 ((XfwWindow*) _tmp4_);
	result = _tmp5_;
	return result;
}

/**
 * Get the icon for this window group.
 *
 * Returns: the icon if found for the given size and scale
 */
GdkPixbuf*
budgie_windowing_window_group_get_icon (BudgieWindowingWindowGroup* self,
                                        gint size,
                                        gint scale)
{
	XfwApplication* _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application;
	_tmp1_ = xfw_application_get_icon (_tmp0_, size, scale);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

/**
 * Get the next window in the group relative to the given window.
 *
 * This works on a copy of the current window list in case we need
 * to reverse the list.
 *
 * Returns: The next (or technically previous, if reversed) window in the group
 */
XfwWindow*
budgie_windowing_window_group_get_next_window (BudgieWindowingWindowGroup* self,
                                               XfwWindow* window,
                                               gboolean reverse)
{
	GList* copy = NULL;
	GList* _tmp0_;
	GList* _tmp4_;
	gint i = 0;
	GList* _tmp5_;
	gint _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	gconstpointer _tmp9_;
	XfwWindow* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = budgie_windowing_window_group_get_windows (self);
	copy = _tmp0_;
	if (reverse) {
		copy = g_list_reverse (copy);
	}
	if (window == NULL) {
		GList* _tmp1_;
		GList* _tmp2_;
		gconstpointer _tmp3_;
		_tmp1_ = copy;
		_tmp2_ = g_list_first (_tmp1_);
		_tmp3_ = _tmp2_->data;
		result = (XfwWindow*) _tmp3_;
		(copy == NULL) ? NULL : (copy = (g_list_free (copy), NULL));
		return result;
	}
	_tmp4_ = self->priv->windows;
	if (g_list_length (_tmp4_) == ((guint) 1)) {
		result = window;
		(copy == NULL) ? NULL : (copy = (g_list_free (copy), NULL));
		return result;
	}
	_tmp5_ = copy;
	i = g_list_index (_tmp5_, window);
	_tmp6_ = i;
	i = _tmp6_ + 1;
	_tmp7_ = copy;
	if (((guint) i) >= g_list_length (_tmp7_)) {
		i = 0;
	}
	_tmp8_ = copy;
	_tmp9_ = g_list_nth_data (_tmp8_, (guint) i);
	result = (XfwWindow*) _tmp9_;
	(copy == NULL) ? NULL : (copy = (g_list_free (copy), NULL));
	return result;
}

/**
 * Get the open windows in this group.
 *
 * Returns: a list of open windows
 */
GList*
budgie_windowing_window_group_get_windows (BudgieWindowingWindowGroup* self)
{
	GList* _tmp0_;
	GList* _tmp1_;
	GList* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->windows;
	_tmp1_ = g_list_copy (_tmp0_);
	result = _tmp1_;
	return result;
}

/**
 * Checks whether or not the given window is in this group.
 *
 * Returns: true if the window is in this window group
 */
gboolean
budgie_windowing_window_group_has_window (BudgieWindowingWindowGroup* self,
                                          XfwWindow* window)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (window == NULL) {
		result = FALSE;
		return result;
	}
	_tmp0_ = self->priv->windows;
	_tmp1_ = g_list_find (_tmp0_, window);
	result = _tmp1_ != NULL;
	return result;
}

/**
 * Check whether this group has an open window on
 * a workspace.
 *
 * Returns: true if there is a window on the workspace
 */
gboolean
budgie_windowing_window_group_has_window_on_workspace (BudgieWindowingWindowGroup* self,
                                                       XfwWorkspace* workspace)
{
	GList* _tmp0_;
	GList* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (workspace != NULL, FALSE);
	_tmp0_ = self->priv->windows;
	if (vala_g_list_is_empty (_tmp0_)) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->windows;
	{
		GList* window_collection = NULL;
		GList* window_it = NULL;
		window_collection = _tmp1_;
		for (window_it = window_collection; window_it != NULL; window_it = window_it->next) {
			XfwWindow* window = NULL;
			window = (XfwWindow*) window_it->data;
			{
				XfwWorkspace* window_workspace = NULL;
				XfwWindow* _tmp2_;
				XfwWorkspace* _tmp3_;
				XfwWorkspace* _tmp4_;
				XfwWorkspace* _tmp5_;
				XfwWorkspace* _tmp6_;
				const gchar* _tmp7_;
				const gchar* _tmp8_;
				_tmp2_ = window;
				_tmp3_ = xfw_window_get_workspace (_tmp2_);
				_tmp4_ = _g_object_ref0 (_tmp3_);
				window_workspace = _tmp4_;
				_tmp5_ = window_workspace;
				if (_tmp5_ == NULL) {
					_g_object_unref0 (window_workspace);
					continue;
				}
				_tmp6_ = window_workspace;
				_tmp7_ = xfw_workspace_get_id (_tmp6_);
				_tmp8_ = xfw_workspace_get_id (workspace);
				if (g_strcmp0 (_tmp7_, _tmp8_) == 0) {
					result = TRUE;
					_g_object_unref0 (window_workspace);
					return result;
				}
				_g_object_unref0 (window_workspace);
			}
		}
	}
	result = FALSE;
	return result;
}

/**
 * Checks whether or not this group still has any open windows.
 *
 * Returns: true if there are open windows
 */
gboolean
budgie_windowing_window_group_has_windows (BudgieWindowingWindowGroup* self)
{
	XfwApplication* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GList* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GList* _tmp8_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_application;
	_tmp1_ = xfw_application_get_name (_tmp0_);
	_tmp2_ = string_to_string (_tmp1_);
	_tmp3_ = self->priv->windows;
	_tmp4_ = g_strdup_printf ("%u", g_list_length (_tmp3_));
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strconcat ("window group '", _tmp2_, " has ", _tmp5_, " windows in it", NULL);
	_tmp7_ = _tmp6_;
	g_debug ("window_group.vala:255: %s", _tmp7_);
	_g_free0 (_tmp7_);
	_g_free0 (_tmp5_);
	_tmp8_ = self->priv->windows;
	result = g_list_length (_tmp8_) > ((guint) 0);
	return result;
}

/**
 * Set the currently active window.
 */
void
budgie_windowing_window_group_set_active_window (BudgieWindowingWindowGroup* self,
                                                 XfwWindow* window)
{
	g_return_if_fail (self != NULL);
	self->priv->active_window = window;
	g_signal_emit (self, budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_ACTIVE_WINDOW_CHANGED_SIGNAL], 0, window);
}

/**
 * Set the previously active window.
 */
void
budgie_windowing_window_group_set_last_active_window (BudgieWindowingWindowGroup* self,
                                                      XfwWindow* window)
{
	g_return_if_fail (self != NULL);
	self->priv->last_active_window = window;
}

XfwApplication*
budgie_windowing_window_group_get_application (BudgieWindowingWindowGroup* self)
{
	XfwApplication* result;
	XfwApplication* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application;
	result = _tmp0_;
	return result;
}

static void
budgie_windowing_window_group_set_application (BudgieWindowingWindowGroup* self,
                                               XfwApplication* value)
{
	XfwApplication* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_windowing_window_group_get_application (self);
	if (old_value != value) {
		XfwApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_windowing_window_group_properties[BUDGIE_WINDOWING_WINDOW_GROUP_APPLICATION_PROPERTY]);
	}
}

const gchar*
budgie_windowing_window_group_get_group_id (BudgieWindowingWindowGroup* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_group_id;
	result = _tmp0_;
	return result;
}

static void
budgie_windowing_window_group_set_group_id (BudgieWindowingWindowGroup* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_windowing_window_group_get_group_id (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_group_id);
		self->priv->_group_id = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_windowing_window_group_properties[BUDGIE_WINDOWING_WINDOW_GROUP_GROUP_ID_PROPERTY]);
	}
}

GDesktopAppInfo*
budgie_windowing_window_group_get_app_info (BudgieWindowingWindowGroup* self)
{
	GDesktopAppInfo* result;
	GDesktopAppInfo* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_app_info;
	result = _tmp0_;
	return result;
}

static void
budgie_windowing_window_group_set_app_info (BudgieWindowingWindowGroup* self,
                                            GDesktopAppInfo* value)
{
	GDesktopAppInfo* old_value;
	g_return_if_fail (self != NULL);
	old_value = budgie_windowing_window_group_get_app_info (self);
	if (old_value != value) {
		GDesktopAppInfo* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_app_info);
		self->priv->_app_info = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, budgie_windowing_window_group_properties[BUDGIE_WINDOWING_WINDOW_GROUP_APP_INFO_PROPERTY]);
	}
}

static void
g_cclosure_user_marshal_VOID__OBJECT_FLAGS_FLAGS (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_FLAGS_FLAGS) (gpointer data1, gpointer arg_1, guint arg_2, guint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_FLAGS_FLAGS callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_FLAGS_FLAGS) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_flags (param_values + 2), g_value_get_flags (param_values + 3), data2);
}

static void
_budgie_windowing_window_group_icon_changed_libxfce4windowing_application_icon_changed (XfwApplication* _sender,
                                                                                        gpointer self)
{
	budgie_windowing_window_group_icon_changed ((BudgieWindowingWindowGroup*) self);
}

static GObject *
budgie_windowing_window_group_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BudgieWindowingWindowGroup * self;
	XfwApplication* _tmp0_;
	parent_class = G_OBJECT_CLASS (budgie_windowing_window_group_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, BudgieWindowingWindowGroup);
	(self->priv->windows == NULL) ? NULL : (self->priv->windows = (g_list_free (self->priv->windows), NULL));
	self->priv->windows = NULL;
	_tmp0_ = self->priv->_application;
	g_signal_connect_object (_tmp0_, "icon-changed", (GCallback) _budgie_windowing_window_group_icon_changed_libxfce4windowing_application_icon_changed, self, 0);
	return obj;
}

static void
budgie_windowing_window_group_class_init (BudgieWindowingWindowGroupClass * klass,
                                          gpointer klass_data)
{
	budgie_windowing_window_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BudgieWindowingWindowGroup_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_windowing_window_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_windowing_window_group_set_property;
	G_OBJECT_CLASS (klass)->constructor = budgie_windowing_window_group_constructor;
	G_OBJECT_CLASS (klass)->finalize = budgie_windowing_window_group_finalize;
	/** The Xfw.Application that this group belongs to. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WINDOWING_WINDOW_GROUP_APPLICATION_PROPERTY, budgie_windowing_window_group_properties[BUDGIE_WINDOWING_WINDOW_GROUP_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", xfw_application_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/** A copy of the application's ID. */
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WINDOWING_WINDOW_GROUP_GROUP_ID_PROPERTY, budgie_windowing_window_group_properties[BUDGIE_WINDOWING_WINDOW_GROUP_GROUP_ID_PROPERTY] = g_param_spec_string ("group-id", "group-id", "group-id", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_WINDOWING_WINDOW_GROUP_APP_INFO_PROPERTY, budgie_windowing_window_group_properties[BUDGIE_WINDOWING_WINDOW_GROUP_APP_INFO_PROPERTY] = g_param_spec_object ("app-info", "app-info", "app-info", G_TYPE_DESKTOP_APP_INFO, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	/**
	 * Emitted when the active window in the group changes.
	 */
	budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_ACTIVE_WINDOW_CHANGED_SIGNAL] = g_signal_new ("active-window-changed", BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, xfw_window_get_type ());
	/**
	 * Emitted when the icon of the application for this group changes.
	 */
	budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_APP_ICON_CHANGED_SIGNAL] = g_signal_new ("app-icon-changed", BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	/**
	 * Emitted when the state of a window in this group changes.
	 */
	budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_WINDOW_STATE_CHANGED_SIGNAL] = g_signal_new ("window-state-changed", BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_FLAGS_FLAGS, G_TYPE_NONE, 3, xfw_window_get_type (), xfw_window_state_get_type (), xfw_window_state_get_type ());
	/**
	 * Emitted when a window has been added to this group.
	 */
	budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_WINDOW_ADDED_SIGNAL] = g_signal_new ("window-added", BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, xfw_window_get_type ());
	/**
	 * Emitted when a window has been removed from this group.
	 */
	budgie_windowing_window_group_signals[BUDGIE_WINDOWING_WINDOW_GROUP_WINDOW_REMOVED_SIGNAL] = g_signal_new ("window-removed", BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, xfw_window_get_type ());
}

static void
budgie_windowing_window_group_instance_init (BudgieWindowingWindowGroup * self,
                                             gpointer klass)
{
	self->priv = budgie_windowing_window_group_get_instance_private (self);
	self->priv->_app_info = NULL;
	self->priv->active_window = NULL;
	self->priv->last_active_window = NULL;
}

static void
budgie_windowing_window_group_finalize (GObject * obj)
{
	BudgieWindowingWindowGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, BudgieWindowingWindowGroup);
	_g_object_unref0 (self->priv->_application);
	_g_free0 (self->priv->_group_id);
	_g_object_unref0 (self->priv->_app_info);
	(self->priv->windows == NULL) ? NULL : (self->priv->windows = (g_list_free (self->priv->windows), NULL));
	G_OBJECT_CLASS (budgie_windowing_window_group_parent_class)->finalize (obj);
}

/**
 * This object represnts a group of windows belonging to the same
 * application.
 */
static GType
budgie_windowing_window_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BudgieWindowingWindowGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_windowing_window_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieWindowingWindowGroup), 0, (GInstanceInitFunc) budgie_windowing_window_group_instance_init, NULL };
	GType budgie_windowing_window_group_type_id;
	budgie_windowing_window_group_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieWindowingWindowGroup", &g_define_type_info, 0);
	BudgieWindowingWindowGroup_private_offset = g_type_add_instance_private (budgie_windowing_window_group_type_id, sizeof (BudgieWindowingWindowGroupPrivate));
	return budgie_windowing_window_group_type_id;
}

GType
budgie_windowing_window_group_get_type (void)
{
	static volatile gsize budgie_windowing_window_group_type_id__once = 0;
	if (g_once_init_enter (&budgie_windowing_window_group_type_id__once)) {
		GType budgie_windowing_window_group_type_id;
		budgie_windowing_window_group_type_id = budgie_windowing_window_group_get_type_once ();
		g_once_init_leave (&budgie_windowing_window_group_type_id__once, budgie_windowing_window_group_type_id);
	}
	return budgie_windowing_window_group_type_id__once;
}

static void
_vala_budgie_windowing_window_group_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	BudgieWindowingWindowGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, BudgieWindowingWindowGroup);
	switch (property_id) {
		case BUDGIE_WINDOWING_WINDOW_GROUP_APPLICATION_PROPERTY:
		g_value_set_object (value, budgie_windowing_window_group_get_application (self));
		break;
		case BUDGIE_WINDOWING_WINDOW_GROUP_GROUP_ID_PROPERTY:
		g_value_set_string (value, budgie_windowing_window_group_get_group_id (self));
		break;
		case BUDGIE_WINDOWING_WINDOW_GROUP_APP_INFO_PROPERTY:
		g_value_set_object (value, budgie_windowing_window_group_get_app_info (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_budgie_windowing_window_group_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	BudgieWindowingWindowGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_WINDOWING_TYPE_WINDOW_GROUP, BudgieWindowingWindowGroup);
	switch (property_id) {
		case BUDGIE_WINDOWING_WINDOW_GROUP_APPLICATION_PROPERTY:
		budgie_windowing_window_group_set_application (self, g_value_get_object (value));
		break;
		case BUDGIE_WINDOWING_WINDOW_GROUP_GROUP_ID_PROPERTY:
		budgie_windowing_window_group_set_group_id (self, g_value_get_string (value));
		break;
		case BUDGIE_WINDOWING_WINDOW_GROUP_APP_INFO_PROPERTY:
		budgie_windowing_window_group_set_app_info (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

