/* window.c generated by valac 0.56.18, the Vala compiler
 * generated from window.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is used for drawing the
* window components for both the library view and the reading view
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <webkit2/webkit2.h>
#include <granite.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <gio/gio.h>
#include <libsoup/soup.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS 12
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_TITLE _ ("Title")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_AUTHOR _ ("Author")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_MODIFIED_DATE _ ("Last Opened")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_RATING _ ("Rating")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_TAGS _ ("Tags")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_SELECT_BOOK _ ("Select one or more books in library")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_ADD_BOOK _ ("Add books to library")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_REMOVE_BOOK_UNSELECTED _ ("Select books to enable removal")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_PREV_PAGE _ ("Go to previous page")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_NEXT_PAGE _ ("Go to next page")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PAGE_CONTEXTMENU_WORD_MEANING _ ("Check Word Meaning")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PAGE_CONTEXTMENU_FULL_SCREEN_ENTRY _ ("Enter fullscreen view (F11)")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PAGE_CONTEXTMENU_FULL_SCREEN_EXIT _ ("Exit fullscreen view (Esc)")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_PAGE_CONTEXTMENU_ANNOTATE_SELECTION _ ("Annotate selected text")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_WELCOME_MESSAGE_TITLE _ ("Looks like Bookworm has no books")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_WELCOME_MESSAGE_SUBTITLE _ ("Build your library by adding eBooks")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_WELCOME_OPENDIR_MESSAGE _ ("Select an eBook to read")
#define BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_REMOVE_BOOK _ ("Remove selected books from library (eBook file will not be deleted)")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_APP_WINDOW (bookworm_app_app_window_get_type ())
#define BOOKWORM_APP_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_APP_WINDOW, BookwormAppAppWindow))
#define BOOKWORM_APP_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_APP_WINDOW, BookwormAppAppWindowClass))
#define BOOKWORM_APP_IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_APP_WINDOW))
#define BOOKWORM_APP_IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_APP_WINDOW))
#define BOOKWORM_APP_APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_APP_WINDOW, BookwormAppAppWindowClass))

typedef struct _BookwormAppAppWindow BookwormAppAppWindow;
typedef struct _BookwormAppAppWindowClass BookwormAppAppWindowClass;
typedef struct _BookwormAppAppWindowPrivate BookwormAppAppWindowPrivate;

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;
typedef struct _Block20Data Block20Data;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
#define __vala_WebKitNavigationAction_free0(var) ((var == NULL) ? NULL : (var = (_vala_WebKitNavigationAction_free (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define __vala_GtkTreePath_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTreePath_free (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
typedef struct _BookwormAppParamSpecAppWindow BookwormAppParamSpecAppWindow;

struct _BookwormAppAppWindow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppAppWindowPrivate * priv;
};

struct _BookwormAppAppWindowClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppAppWindow *self);
};

struct _Block20Data {
	int _ref_count_;
	GtkActionBar* book_reading_footer_box;
};

struct _BookwormAppParamSpecAppWindow {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_app_window_parent_class = NULL;
VALA_EXTERN GtkInfoBar* bookworm_app_app_window_infobar;
GtkInfoBar* bookworm_app_app_window_infobar = NULL;
VALA_EXTERN GtkBox* bookworm_app_app_window_bookLibrary_ui_box;
GtkBox* bookworm_app_app_window_bookLibrary_ui_box = NULL;
VALA_EXTERN GtkFlowBox* bookworm_app_app_window_library_grid;
GtkFlowBox* bookworm_app_app_window_library_grid = NULL;
VALA_EXTERN GtkListStore* bookworm_app_app_window_library_table_liststore;
GtkListStore* bookworm_app_app_window_library_table_liststore = NULL;
VALA_EXTERN GtkTreeIter bookworm_app_app_window_library_table_iter;
GtkTreeIter bookworm_app_app_window_library_table_iter = {0};
VALA_EXTERN GtkTreeView* bookworm_app_app_window_library_table_treeview;
GtkTreeView* bookworm_app_app_window_library_table_treeview = NULL;
VALA_EXTERN GtkLabel* bookworm_app_app_window_infobarLabel;
GtkLabel* bookworm_app_app_window_infobarLabel = NULL;
VALA_EXTERN GtkScrolledWindow* bookworm_app_app_window_library_grid_scroll;
GtkScrolledWindow* bookworm_app_app_window_library_grid_scroll = NULL;
VALA_EXTERN GtkScrolledWindow* bookworm_app_app_window_library_list_scroll;
GtkScrolledWindow* bookworm_app_app_window_library_list_scroll = NULL;
VALA_EXTERN WebKitWebView* bookworm_app_app_window_aWebView;
WebKitWebView* bookworm_app_app_window_aWebView = NULL;
VALA_EXTERN WebKitSettings* bookworm_app_app_window_webkitSettings;
WebKitSettings* bookworm_app_app_window_webkitSettings = NULL;
VALA_EXTERN GtkEventBox* bookworm_app_app_window_book_reading_footer_eventbox;
GtkEventBox* bookworm_app_app_window_book_reading_footer_eventbox = NULL;
VALA_EXTERN GtkBox* bookworm_app_app_window_book_reading_footer_box;
GtkBox* bookworm_app_app_window_book_reading_footer_box = NULL;
VALA_EXTERN GtkBox* bookworm_app_app_window_bookReading_ui_box;
GtkBox* bookworm_app_app_window_bookReading_ui_box = NULL;
VALA_EXTERN GtkButton* bookworm_app_app_window_forward_button;
GtkButton* bookworm_app_app_window_forward_button = NULL;
VALA_EXTERN GtkButton* bookworm_app_app_window_back_button;
GtkButton* bookworm_app_app_window_back_button = NULL;
VALA_EXTERN GtkProgressBar* bookworm_app_app_window_bookAdditionBar;
GtkProgressBar* bookworm_app_app_window_bookAdditionBar = NULL;
VALA_EXTERN GtkAdjustment* bookworm_app_app_window_pageAdjustment;
GtkAdjustment* bookworm_app_app_window_pageAdjustment = NULL;
VALA_EXTERN GtkScale* bookworm_app_app_window_pageSlider;
GtkScale* bookworm_app_app_window_pageSlider = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_app_window_settings;
BookwormAppSettings* bookworm_app_app_window_settings = NULL;
VALA_EXTERN gboolean bookworm_app_app_window_isWebViewRequestCompleted;
gboolean bookworm_app_app_window_isWebViewRequestCompleted = TRUE;
VALA_EXTERN GtkButton* bookworm_app_app_window_remove_book_button;
GtkButton* bookworm_app_app_window_remove_book_button = NULL;
VALA_EXTERN GtkButton* bookworm_app_app_window_page_button_prev;
GtkButton* bookworm_app_app_window_page_button_prev = NULL;
VALA_EXTERN GtkButton* bookworm_app_app_window_page_button_next;
GtkButton* bookworm_app_app_window_page_button_next = NULL;
VALA_EXTERN gint bookworm_app_app_window_noOfBooksSelected;
gint bookworm_app_app_window_noOfBooksSelected = 0;
VALA_EXTERN GtkImage* bookworm_app_bookworm_select_book_image;
VALA_EXTERN GtkImage* bookworm_app_bookworm_add_book_image;
VALA_EXTERN GtkImage* bookworm_app_bookworm_remove_book_image;
VALA_EXTERN GtkImage* bookworm_app_bookworm_back_page_image;
VALA_EXTERN GtkImage* bookworm_app_bookworm_forward_page_image;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
VALA_EXTERN GtkImage* bookworm_app_bookworm_back_button_image;
VALA_EXTERN GtkImage* bookworm_app_bookworm_forward_button_image;
VALA_EXTERN GeeHashMap* bookworm_app_bookworm_libraryViewMap;
VALA_EXTERN gchar* bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
VALA_EXTERN gchar* bookworm_app_bookworm_locationOfEBookCurrentlyRead;
VALA_EXTERN GtkApplicationWindow* bookworm_app_bookworm_window;
VALA_EXTERN gchar** bookworm_app_bookworm_pathsOfBooksToBeAdded;
VALA_EXTERN gint bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
VALA_EXTERN gboolean bookworm_app_bookworm_isBookBeingAddedToLibrary;
VALA_EXTERN gint bookworm_app_bookworm_current_page_counter;
VALA_EXTERN GeeArrayList* bookworm_app_bookworm_paginationlist;
VALA_EXTERN GraniteWidgetsWelcome* bookworm_app_bookworm_welcomeWidget;
VALA_EXTERN GtkBox* bookworm_app_bookworm_bookWormUIBox;

VALA_EXTERN gpointer bookworm_app_app_window_ref (gpointer instance);
VALA_EXTERN void bookworm_app_app_window_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_app_window (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_app_window (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_app_window (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_app_window (const GValue* value);
VALA_EXTERN GType bookworm_app_app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppAppWindow, bookworm_app_app_window_unref)
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN GtkBox* bookworm_app_app_window_createBoookwormUI (void);
static Block20Data* block20_data_ref (Block20Data* _data20_);
static void block20_data_unref (void * _userdata_);
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN void bookworm_app_app_window_on_info_bar_closed (void);
static void _bookworm_app_app_window_on_info_bar_closed_gtk_info_bar_response (GtkInfoBar* _sender,
                                                                        gint response_id,
                                                                        gpointer self);
VALA_EXTERN gdouble bookworm_app_settings_get_zoom_level (BookwormAppSettings* self);
VALA_EXTERN gint bookworm_app_settings_get_reading_font_size (BookwormAppSettings* self);
VALA_EXTERN const gchar* bookworm_app_settings_get_reading_font_name (BookwormAppSettings* self);
VALA_EXTERN GtkBox* bookworm_app_info_createBookInfo (void);
static void __lambda45_ (GtkTreePath* path,
                  GtkTreeViewColumn* column);
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN void bookworm_app_library_updateListViewForSelection (BookwormAppBook* lBook);
VALA_EXTERN void bookworm_app_bookworm_readSelectedBook (BookwormAppBook* aBook);
static void ___lambda45__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                               GtkTreePath* path,
                                               GtkTreeViewColumn* column,
                                               gpointer self);
static void __lambda46_ (const gchar* path,
                  const gchar* new_text);
VALA_EXTERN gboolean bookworm_app_app_window_updateLibraryListViewData (const gchar* path,
                                                            const gchar* new_text,
                                                            gint column);
static void ___lambda46__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                                 const gchar* path,
                                                 const gchar* new_text,
                                                 gpointer self);
static void __lambda47_ (const gchar* path,
                  const gchar* new_text);
static void ___lambda47__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                                 const gchar* path,
                                                 const gchar* new_text,
                                                 gpointer self);
static void __lambda48_ (const gchar* path,
                  const gchar* new_text);
static void ___lambda48__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                                 const gchar* path,
                                                 const gchar* new_text,
                                                 gpointer self);
static gboolean __lambda49_ (GdkEventButton* event);
static gboolean ___lambda49__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static void __lambda50_ (void);
VALA_EXTERN BookwormAppBook* bookworm_app_book_new (void);
VALA_EXTERN BookwormAppBook* bookworm_app_book_construct (GType object_type);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_content_handler_renderPage (BookwormAppBook* aBook,
                                                          gchar* direction);
static void ___lambda50__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda51_ (void);
static void ___lambda51__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean __lambda52_ (GtkScrollType scroll,
                      gdouble new_value);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookPageNumber (BookwormAppBook* self,
                                          gint aBookPageNumber);
VALA_EXTERN gint bookworm_app_book_getBookPageNumber (BookwormAppBook* self);
static gboolean ___lambda52__gtk_range_change_value (GtkRange* _sender,
                                              GtkScrollType scroll,
                                              gdouble new_value,
                                              gpointer self);
static void __lambda53_ (void);
VALA_EXTERN GeeArrayList* bookworm_app_utils_selectFileChooser (GtkFileChooserAction action,
                                                    const gchar* title,
                                                    GtkWindow* parent,
                                                    gboolean select_multiple,
                                                    const gchar* filterType);
VALA_EXTERN void bookworm_app_library_addBooksToLibrary (GAsyncReadyCallback _callback_,
                                             gpointer _user_data_);
VALA_EXTERN void bookworm_app_library_addBooksToLibrary_finish (GAsyncResult* _res_);
static void ___lambda53__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda54_ (void);
VALA_EXTERN const gchar* bookworm_app_settings_get_library_view_mode (BookwormAppSettings* self);
VALA_EXTERN void bookworm_app_library_updateGridViewForSelection (BookwormAppBook* lBook);
static void ___lambda54__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda55_ (void);
VALA_EXTERN void bookworm_app_library_removeSelectedBooksFromLibrary (void);
static void ___lambda55__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static gboolean __lambda56_ (Block20Data* _data20_,
                      WebKitContextMenu* context_menu,
                      GdkEvent* event,
                      WebKitHitTestResult* hit_test_result);
static void __lambda57_ (void);
VALA_EXTERN gchar* bookworm_app_utils_setWebViewTitle (const gchar* javascript);
VALA_EXTERN void bookworm_app_info_populateDictionaryResults (const gchar* word);
static void ___lambda57__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda58_ (void);
VALA_EXTERN void bookworm_app_app_dialog_createAnnotationDialog (const gchar* textForAnnotation);
static void ___lambda58__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda59_ (Block20Data* _data20_);
static void ___lambda59__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static void __lambda60_ (Block20Data* _data20_);
static void ___lambda60__g_simple_action_activate (GSimpleAction* _sender,
                                            GVariant* parameter,
                                            gpointer self);
static gboolean ___lambda56__webkit_web_view_context_menu (WebKitWebView* _sender,
                                                    WebKitContextMenu* context_menu,
                                                    GdkEvent* event,
                                                    WebKitHitTestResult* hit_test_result,
                                                    gpointer self);
static gboolean __lambda61_ (WebKitPolicyDecision* decision,
                      WebKitPolicyDecisionType type);
static WebKitNavigationAction* _vala_WebKitNavigationAction_copy (WebKitNavigationAction* self);
VALA_EXTERN gchar* bookworm_app_utils_decodeHTMLChars (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
static void _vala_WebKitNavigationAction_free (WebKitNavigationAction* self);
VALA_EXTERN void bookworm_app_bookworm_toggleUIState (void);
static gboolean ___lambda61__webkit_web_view_decide_policy (WebKitWebView* _sender,
                                                     WebKitPolicyDecision* decision,
                                                     WebKitPolicyDecisionType type,
                                                     gpointer self);
static void __lambda62_ (void);
VALA_EXTERN void bookworm_app_app_window_handleLibraryPageButtons (const gchar* mode,
                                                       gboolean isPaginateRequired);
static void ___lambda62__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
static void __lambda63_ (void);
static void ___lambda63__gtk_button_clicked (GtkButton* _sender,
                                      gpointer self);
VALA_EXTERN void bookworm_app_library_paginateLibrary (const gchar* library_search_data,
                                           const gchar* mode);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN void bookworm_app_book_setBookAuthor (BookwormAppBook* self,
                                      const gchar* aBookAuthor);
VALA_EXTERN void bookworm_app_book_setBookTags (BookwormAppBook* self,
                                    const gchar* aBookTags);
VALA_EXTERN void bookworm_app_book_setWasBookOpened (BookwormAppBook* self,
                                         gboolean aWasBookOpened);
static void _vala_GtkTreePath_free (GtkTreePath* self);
VALA_EXTERN GraniteWidgetsWelcome* bookworm_app_app_window_createWelcomeScreen (void);
static void __lambda64_ (void);
static void ___lambda64__granite_widgets_welcome_activated (GraniteWidgetsWelcome* _sender,
                                                     gint index,
                                                     gpointer self);
VALA_EXTERN void bookworm_app_app_window_showInfoBar (BookwormAppBook* aBook,
                                          GtkMessageType aMessageType);
VALA_EXTERN gchar* bookworm_app_book_getParsingIssue (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_app_window_handleWindowStateEvents (GdkEventWindowState* ev);
VALA_EXTERN void bookworm_app_settings_set_is_fullscreen (BookwormAppSettings* self,
                                              gboolean value);
VALA_EXTERN void bookworm_app_app_window_controlDeletionButton (gboolean selectionState);
VALA_EXTERN BookwormAppAppWindow* bookworm_app_app_window_new (void);
VALA_EXTERN BookwormAppAppWindow* bookworm_app_app_window_construct (GType object_type);
static void bookworm_app_app_window_finalize (BookwormAppAppWindow * obj);
static GType bookworm_app_app_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

VALA_EXTERN const gchar* BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[8];

static Block20Data*
block20_data_ref (Block20Data* _data20_)
{
#line 50 "../src/window.vala"
	g_atomic_int_inc (&_data20_->_ref_count_);
#line 50 "../src/window.vala"
	return _data20_;
#line 415 "window.c"
}

static void
block20_data_unref (void * _userdata_)
{
	Block20Data* _data20_;
	_data20_ = (Block20Data*) _userdata_;
#line 50 "../src/window.vala"
	if (g_atomic_int_dec_and_test (&_data20_->_ref_count_)) {
#line 50 "../src/window.vala"
		_g_object_unref0 (_data20_->book_reading_footer_box);
#line 50 "../src/window.vala"
		g_slice_free (Block20Data, _data20_);
#line 429 "window.c"
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 159 "../src/window.vala"
	return self ? g_object_ref (self) : NULL;
#line 438 "window.c"
}

static void
_bookworm_app_app_window_on_info_bar_closed_gtk_info_bar_response (GtkInfoBar* _sender,
                                                                   gint response_id,
                                                                   gpointer self)
{
#line 163 "../src/window.vala"
	bookworm_app_app_window_on_info_bar_closed ();
#line 448 "window.c"
}

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 236 "../src/window.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 456 "window.c"
}

static void
__lambda45_ (GtkTreePath* path,
             GtkTreeViewColumn* column)
{
	GtkTreeIter iter = {0};
	GValue bookLocation = {0};
	GtkTreeModel* aTreeModel = NULL;
	GtkTreeView* _tmp0_;
	GtkTreeModel* _tmp1_;
	GtkTreeModel* _tmp2_;
	GtkTreeModel* _tmp3_;
	GtkTreeIter _tmp4_ = {0};
	GtkTreeModel* _tmp5_;
	GtkTreeIter _tmp6_;
	GValue _tmp7_ = {0};
	BookwormAppBook* aBook = NULL;
	GeeHashMap* _tmp8_;
	GValue _tmp9_;
	gpointer _tmp10_;
	gboolean _tmp11_ = FALSE;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
#line 223 "../src/window.vala"
	g_return_if_fail (path != NULL);
#line 223 "../src/window.vala"
	g_return_if_fail (column != NULL);
#line 226 "../src/window.vala"
	_tmp0_ = bookworm_app_app_window_library_table_treeview;
#line 226 "../src/window.vala"
	_tmp1_ = gtk_tree_view_get_model (_tmp0_);
#line 226 "../src/window.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 226 "../src/window.vala"
	aTreeModel = _tmp2_;
#line 227 "../src/window.vala"
	_tmp3_ = aTreeModel;
#line 227 "../src/window.vala"
	gtk_tree_model_get_iter (_tmp3_, &_tmp4_, path);
#line 227 "../src/window.vala"
	iter = _tmp4_;
#line 228 "../src/window.vala"
	_tmp5_ = aTreeModel;
#line 228 "../src/window.vala"
	_tmp6_ = iter;
#line 228 "../src/window.vala"
	gtk_tree_model_get_value (_tmp5_, &_tmp6_, 7, &_tmp7_);
#line 228 "../src/window.vala"
	G_IS_VALUE (&bookLocation) ? (g_value_unset (&bookLocation), NULL) : NULL;
#line 228 "../src/window.vala"
	bookLocation = _tmp7_;
#line 230 "../src/window.vala"
	_tmp8_ = bookworm_app_bookworm_libraryViewMap;
#line 230 "../src/window.vala"
	_tmp9_ = bookLocation;
#line 230 "../src/window.vala"
	_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp8_, g_value_get_string (&_tmp9_));
#line 230 "../src/window.vala"
	aBook = (BookwormAppBook*) _tmp10_;
#line 232 "../src/window.vala"
	_tmp12_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 232 "../src/window.vala"
	_tmp13_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[6];
#line 232 "../src/window.vala"
	if (g_strcmp0 (_tmp12_, _tmp13_) == 0) {
#line 232 "../src/window.vala"
		_tmp11_ = TRUE;
#line 527 "window.c"
	} else {
		const gchar* _tmp14_;
		const gchar* _tmp15_;
#line 233 "../src/window.vala"
		_tmp14_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 233 "../src/window.vala"
		_tmp15_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[7];
#line 233 "../src/window.vala"
		_tmp11_ = g_strcmp0 (_tmp14_, _tmp15_) == 0;
#line 537 "window.c"
	}
#line 232 "../src/window.vala"
	if (_tmp11_) {
#line 541 "window.c"
		const gchar* _tmp16_;
		gchar* _tmp17_;
		BookwormAppBook* _tmp18_;
		BookwormAppBook* _tmp19_;
#line 235 "../src/window.vala"
		_tmp16_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[7];
#line 235 "../src/window.vala"
		_tmp17_ = g_strdup (_tmp16_);
#line 235 "../src/window.vala"
		_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 235 "../src/window.vala"
		bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp17_;
#line 236 "../src/window.vala"
		_tmp18_ = aBook;
#line 236 "../src/window.vala"
		_tmp19_ = _bookworm_app_book_ref0 (_tmp18_);
#line 236 "../src/window.vala"
		bookworm_app_library_updateListViewForSelection (_tmp19_);
#line 560 "window.c"
	}
#line 238 "../src/window.vala"
	_tmp20_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 238 "../src/window.vala"
	_tmp21_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 238 "../src/window.vala"
	if (g_strcmp0 (_tmp20_, _tmp21_) == 0) {
#line 568 "window.c"
		BookwormAppBook* _tmp22_;
		BookwormAppBook* _tmp23_;
#line 239 "../src/window.vala"
		_tmp22_ = aBook;
#line 239 "../src/window.vala"
		_tmp23_ = _bookworm_app_book_ref0 (_tmp22_);
#line 239 "../src/window.vala"
		bookworm_app_bookworm_readSelectedBook (_tmp23_);
#line 577 "window.c"
	}
#line 223 "../src/window.vala"
	_bookworm_app_book_unref0 (aBook);
#line 223 "../src/window.vala"
	_g_object_unref0 (aTreeModel);
#line 223 "../src/window.vala"
	G_IS_VALUE (&bookLocation) ? (g_value_unset (&bookLocation), NULL) : NULL;
#line 585 "window.c"
}

static void
___lambda45__gtk_tree_view_row_activated (GtkTreeView* _sender,
                                          GtkTreePath* path,
                                          GtkTreeViewColumn* column,
                                          gpointer self)
{
#line 223 "../src/window.vala"
	__lambda45_ (path, column);
#line 596 "window.c"
}

static void
__lambda46_ (const gchar* path,
             const gchar* new_text)
{
#line 244 "../src/window.vala"
	g_return_if_fail (path != NULL);
#line 244 "../src/window.vala"
	g_return_if_fail (new_text != NULL);
#line 245 "../src/window.vala"
	bookworm_app_app_window_updateLibraryListViewData (path, new_text, 1);
#line 609 "window.c"
}

static void
___lambda46__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                            const gchar* path,
                                            const gchar* new_text,
                                            gpointer self)
{
#line 244 "../src/window.vala"
	__lambda46_ (path, new_text);
#line 620 "window.c"
}

static void
__lambda47_ (const gchar* path,
             const gchar* new_text)
{
#line 247 "../src/window.vala"
	g_return_if_fail (path != NULL);
#line 247 "../src/window.vala"
	g_return_if_fail (new_text != NULL);
#line 248 "../src/window.vala"
	bookworm_app_app_window_updateLibraryListViewData (path, new_text, 2);
#line 633 "window.c"
}

static void
___lambda47__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                            const gchar* path,
                                            const gchar* new_text,
                                            gpointer self)
{
#line 247 "../src/window.vala"
	__lambda47_ (path, new_text);
#line 644 "window.c"
}

static void
__lambda48_ (const gchar* path,
             const gchar* new_text)
{
#line 250 "../src/window.vala"
	g_return_if_fail (path != NULL);
#line 250 "../src/window.vala"
	g_return_if_fail (new_text != NULL);
#line 251 "../src/window.vala"
	bookworm_app_app_window_updateLibraryListViewData (path, new_text, 5);
#line 657 "window.c"
}

static void
___lambda48__gtk_cell_renderer_text_edited (GtkCellRendererText* _sender,
                                            const gchar* path,
                                            const gchar* new_text,
                                            gpointer self)
{
#line 250 "../src/window.vala"
	__lambda48_ (path, new_text);
#line 668 "window.c"
}

static gboolean
__lambda49_ (GdkEventButton* event)
{
	guint mouseButtonClicked = 0U;
	guint _tmp0_ = 0U;
	gboolean _tmp1_ = FALSE;
	gboolean result;
#line 255 "../src/window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 258 "../src/window.vala"
	gdk_event_get_button ((GdkEvent*) event, &_tmp0_);
#line 258 "../src/window.vala"
	mouseButtonClicked = _tmp0_;
#line 260 "../src/window.vala"
	if (gdk_event_get_event_type ((GdkEvent*) event) == GDK_BUTTON_PRESS) {
#line 260 "../src/window.vala"
		_tmp1_ = mouseButtonClicked == ((guint) 3);
#line 688 "window.c"
	} else {
#line 260 "../src/window.vala"
		_tmp1_ = FALSE;
#line 692 "window.c"
	}
#line 260 "../src/window.vala"
	if (_tmp1_) {
#line 696 "window.c"
	}
#line 271 "../src/window.vala"
	result = FALSE;
#line 271 "../src/window.vala"
	return result;
#line 702 "window.c"
}

static gboolean
___lambda49__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda49_ (event);
#line 255 "../src/window.vala"
	return result;
#line 714 "window.c"
}

static void
__lambda50_ (void)
{
	BookwormAppBook* currentBookForForward = NULL;
	BookwormAppBook* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	BookwormAppBook* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BookwormAppBook* _tmp9_;
	BookwormAppBook* _tmp10_;
	gchar* _tmp11_;
	BookwormAppBook* _tmp12_;
	GeeHashMap* _tmp13_;
	BookwormAppBook* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	BookwormAppBook* _tmp17_;
	BookwormAppBook* _tmp18_;
	gchar* _tmp19_;
#line 277 "../src/window.vala"
	_tmp0_ = bookworm_app_book_new ();
#line 277 "../src/window.vala"
	currentBookForForward = _tmp0_;
#line 278 "../src/window.vala"
	_tmp1_ = bookworm_app_bookworm_libraryViewMap;
#line 278 "../src/window.vala"
	_tmp2_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 278 "../src/window.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 278 "../src/window.vala"
	_bookworm_app_book_unref0 (currentBookForForward);
#line 278 "../src/window.vala"
	currentBookForForward = (BookwormAppBook*) _tmp3_;
#line 279 "../src/window.vala"
	_tmp4_ = currentBookForForward;
#line 279 "../src/window.vala"
	_tmp5_ = bookworm_app_book_getBookLocation (_tmp4_);
#line 279 "../src/window.vala"
	_tmp6_ = _tmp5_;
#line 279 "../src/window.vala"
	_tmp7_ = g_strconcat ("Initiating read forward for eBook:", _tmp6_, NULL);
#line 279 "../src/window.vala"
	_tmp8_ = _tmp7_;
#line 279 "../src/window.vala"
	g_debug ("window.vala:279: %s", _tmp8_);
#line 279 "../src/window.vala"
	_g_free0 (_tmp8_);
#line 279 "../src/window.vala"
	_g_free0 (_tmp6_);
#line 280 "../src/window.vala"
	_tmp9_ = currentBookForForward;
#line 280 "../src/window.vala"
	_tmp10_ = _bookworm_app_book_ref0 (_tmp9_);
#line 280 "../src/window.vala"
	_tmp11_ = g_strdup ("FORWARD");
#line 280 "../src/window.vala"
	_tmp12_ = bookworm_app_content_handler_renderPage (_tmp10_, _tmp11_);
#line 280 "../src/window.vala"
	_bookworm_app_book_unref0 (currentBookForForward);
#line 280 "../src/window.vala"
	currentBookForForward = _tmp12_;
#line 282 "../src/window.vala"
	_tmp13_ = bookworm_app_bookworm_libraryViewMap;
#line 282 "../src/window.vala"
	_tmp14_ = currentBookForForward;
#line 282 "../src/window.vala"
	_tmp15_ = bookworm_app_book_getBookLocation (_tmp14_);
#line 282 "../src/window.vala"
	_tmp16_ = _tmp15_;
#line 282 "../src/window.vala"
	_tmp17_ = currentBookForForward;
#line 282 "../src/window.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp16_, _tmp17_);
#line 282 "../src/window.vala"
	_g_free0 (_tmp16_);
#line 283 "../src/window.vala"
	_tmp18_ = currentBookForForward;
#line 283 "../src/window.vala"
	_tmp19_ = bookworm_app_book_getBookLocation (_tmp18_);
#line 283 "../src/window.vala"
	_g_free0 (bookworm_app_bookworm_locationOfEBookCurrentlyRead);
#line 283 "../src/window.vala"
	bookworm_app_bookworm_locationOfEBookCurrentlyRead = _tmp19_;
#line 275 "../src/window.vala"
	_bookworm_app_book_unref0 (currentBookForForward);
#line 807 "window.c"
}

static void
___lambda50__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 275 "../src/window.vala"
	__lambda50_ ();
#line 816 "window.c"
}

static void
__lambda51_ (void)
{
	BookwormAppBook* currentBookForReverse = NULL;
	BookwormAppBook* _tmp0_;
	GeeHashMap* _tmp1_;
	const gchar* _tmp2_;
	gpointer _tmp3_;
	BookwormAppBook* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BookwormAppBook* _tmp9_;
	BookwormAppBook* _tmp10_;
	gchar* _tmp11_;
	BookwormAppBook* _tmp12_;
	GeeHashMap* _tmp13_;
	BookwormAppBook* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	BookwormAppBook* _tmp17_;
	BookwormAppBook* _tmp18_;
	gchar* _tmp19_;
#line 288 "../src/window.vala"
	_tmp0_ = bookworm_app_book_new ();
#line 288 "../src/window.vala"
	currentBookForReverse = _tmp0_;
#line 289 "../src/window.vala"
	_tmp1_ = bookworm_app_bookworm_libraryViewMap;
#line 289 "../src/window.vala"
	_tmp2_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 289 "../src/window.vala"
	_tmp3_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, _tmp2_);
#line 289 "../src/window.vala"
	_bookworm_app_book_unref0 (currentBookForReverse);
#line 289 "../src/window.vala"
	currentBookForReverse = (BookwormAppBook*) _tmp3_;
#line 290 "../src/window.vala"
	_tmp4_ = currentBookForReverse;
#line 290 "../src/window.vala"
	_tmp5_ = bookworm_app_book_getBookLocation (_tmp4_);
#line 290 "../src/window.vala"
	_tmp6_ = _tmp5_;
#line 290 "../src/window.vala"
	_tmp7_ = g_strconcat ("Initiating read previous for eBook:", _tmp6_, NULL);
#line 290 "../src/window.vala"
	_tmp8_ = _tmp7_;
#line 290 "../src/window.vala"
	g_debug ("window.vala:290: %s", _tmp8_);
#line 290 "../src/window.vala"
	_g_free0 (_tmp8_);
#line 290 "../src/window.vala"
	_g_free0 (_tmp6_);
#line 291 "../src/window.vala"
	_tmp9_ = currentBookForReverse;
#line 291 "../src/window.vala"
	_tmp10_ = _bookworm_app_book_ref0 (_tmp9_);
#line 291 "../src/window.vala"
	_tmp11_ = g_strdup ("BACKWARD");
#line 291 "../src/window.vala"
	_tmp12_ = bookworm_app_content_handler_renderPage (_tmp10_, _tmp11_);
#line 291 "../src/window.vala"
	_bookworm_app_book_unref0 (currentBookForReverse);
#line 291 "../src/window.vala"
	currentBookForReverse = _tmp12_;
#line 293 "../src/window.vala"
	_tmp13_ = bookworm_app_bookworm_libraryViewMap;
#line 293 "../src/window.vala"
	_tmp14_ = currentBookForReverse;
#line 293 "../src/window.vala"
	_tmp15_ = bookworm_app_book_getBookLocation (_tmp14_);
#line 293 "../src/window.vala"
	_tmp16_ = _tmp15_;
#line 293 "../src/window.vala"
	_tmp17_ = currentBookForReverse;
#line 293 "../src/window.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp13_, _tmp16_, _tmp17_);
#line 293 "../src/window.vala"
	_g_free0 (_tmp16_);
#line 294 "../src/window.vala"
	_tmp18_ = currentBookForReverse;
#line 294 "../src/window.vala"
	_tmp19_ = bookworm_app_book_getBookLocation (_tmp18_);
#line 294 "../src/window.vala"
	_g_free0 (bookworm_app_bookworm_locationOfEBookCurrentlyRead);
#line 294 "../src/window.vala"
	bookworm_app_bookworm_locationOfEBookCurrentlyRead = _tmp19_;
#line 286 "../src/window.vala"
	_bookworm_app_book_unref0 (currentBookForReverse);
#line 909 "window.c"
}

static void
___lambda51__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 286 "../src/window.vala"
	__lambda51_ ();
#line 918 "window.c"
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
#line 997 "glib-2.0.vapi"
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
#line 997 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 997 "glib-2.0.vapi"
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
#line 997 "glib-2.0.vapi"
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
#line 997 "glib-2.0.vapi"
	_tmp3_ = g_strdup (_tmp2_);
#line 997 "glib-2.0.vapi"
	_tmp4_ = _tmp3_;
#line 997 "glib-2.0.vapi"
	_tmp1_ = (g_free (_tmp1_), NULL);
#line 997 "glib-2.0.vapi"
	result = _tmp4_;
#line 997 "glib-2.0.vapi"
	return result;
#line 949 "window.c"
}

static gboolean
__lambda52_ (GtkScrollType scroll,
             gdouble new_value)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	BookwormAppBook* currentBookForSlider = NULL;
	BookwormAppBook* _tmp9_;
	GeeHashMap* _tmp10_;
	const gchar* _tmp11_;
	gpointer _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	BookwormAppBook* _tmp15_;
	GeeArrayList* _tmp16_;
	GeeArrayList* _tmp17_;
	gint _tmp18_;
	gint _tmp19_;
	gboolean _tmp20_;
	BookwormAppBook* _tmp30_;
	BookwormAppBook* _tmp31_;
	gchar* _tmp32_;
	BookwormAppBook* _tmp33_;
	GeeHashMap* _tmp34_;
	BookwormAppBook* _tmp35_;
	gchar* _tmp36_;
	gchar* _tmp37_;
	BookwormAppBook* _tmp38_;
	BookwormAppBook* _tmp39_;
	gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	gchar* _tmp43_;
	gchar* _tmp44_;
	gchar* _tmp45_;
	BookwormAppBook* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	gchar* _tmp49_;
	gchar* _tmp50_;
	gboolean result;
#line 298 "../src/window.vala"
	_tmp0_ = double_to_string (new_value);
#line 298 "../src/window.vala"
	_tmp1_ = _tmp0_;
#line 298 "../src/window.vala"
	_tmp2_ = g_strconcat ("Page Slider value change [", _tmp1_, NULL);
#line 298 "../src/window.vala"
	_tmp3_ = _tmp2_;
#line 298 "../src/window.vala"
	_tmp4_ = g_strconcat (_tmp3_, "] Initiated for book at location:", NULL);
#line 298 "../src/window.vala"
	_tmp5_ = _tmp4_;
#line 298 "../src/window.vala"
	_tmp6_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 298 "../src/window.vala"
	_tmp7_ = g_strconcat (_tmp5_, _tmp6_, NULL);
#line 298 "../src/window.vala"
	_tmp8_ = _tmp7_;
#line 298 "../src/window.vala"
	g_debug ("window.vala:298: %s", _tmp8_);
#line 298 "../src/window.vala"
	_g_free0 (_tmp8_);
#line 298 "../src/window.vala"
	_g_free0 (_tmp5_);
#line 298 "../src/window.vala"
	_g_free0 (_tmp3_);
#line 298 "../src/window.vala"
	_g_free0 (_tmp1_);
#line 300 "../src/window.vala"
	_tmp9_ = bookworm_app_book_new ();
#line 300 "../src/window.vala"
	currentBookForSlider = _tmp9_;
#line 301 "../src/window.vala"
	_tmp10_ = bookworm_app_bookworm_libraryViewMap;
#line 301 "../src/window.vala"
	_tmp11_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 301 "../src/window.vala"
	_tmp12_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, _tmp11_);
#line 301 "../src/window.vala"
	_bookworm_app_book_unref0 (currentBookForSlider);
#line 301 "../src/window.vala"
	currentBookForSlider = (BookwormAppBook*) _tmp12_;
#line 302 "../src/window.vala"
	_tmp13_ = double_to_string (new_value);
#line 302 "../src/window.vala"
	_tmp14_ = _tmp13_;
#line 302 "../src/window.vala"
	_tmp15_ = currentBookForSlider;
#line 302 "../src/window.vala"
	_tmp16_ = bookworm_app_book_getBookContentList (_tmp15_);
#line 302 "../src/window.vala"
	_tmp17_ = _tmp16_;
#line 302 "../src/window.vala"
	_tmp18_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp17_);
#line 302 "../src/window.vala"
	_tmp19_ = _tmp18_;
#line 302 "../src/window.vala"
	_tmp20_ = (atoi (_tmp14_) - 1) > _tmp19_;
#line 302 "../src/window.vala"
	_g_object_unref0 (_tmp17_);
#line 302 "../src/window.vala"
	_g_free0 (_tmp14_);
#line 302 "../src/window.vala"
	if (_tmp20_) {
#line 1064 "window.c"
		BookwormAppBook* _tmp21_;
		BookwormAppBook* _tmp22_;
		GeeArrayList* _tmp23_;
		GeeArrayList* _tmp24_;
		gint _tmp25_;
		gint _tmp26_;
#line 304 "../src/window.vala"
		_tmp21_ = currentBookForSlider;
#line 304 "../src/window.vala"
		_tmp22_ = currentBookForSlider;
#line 304 "../src/window.vala"
		_tmp23_ = bookworm_app_book_getBookContentList (_tmp22_);
#line 304 "../src/window.vala"
		_tmp24_ = _tmp23_;
#line 304 "../src/window.vala"
		_tmp25_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp24_);
#line 304 "../src/window.vala"
		_tmp26_ = _tmp25_;
#line 304 "../src/window.vala"
		bookworm_app_book_setBookPageNumber (_tmp21_, _tmp26_ - 1);
#line 304 "../src/window.vala"
		_g_object_unref0 (_tmp24_);
#line 1087 "window.c"
	} else {
		BookwormAppBook* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
#line 306 "../src/window.vala"
		_tmp27_ = currentBookForSlider;
#line 306 "../src/window.vala"
		_tmp28_ = double_to_string (new_value);
#line 306 "../src/window.vala"
		_tmp29_ = _tmp28_;
#line 306 "../src/window.vala"
		bookworm_app_book_setBookPageNumber (_tmp27_, atoi (_tmp29_) - 1);
#line 306 "../src/window.vala"
		_g_free0 (_tmp29_);
#line 1102 "window.c"
	}
#line 309 "../src/window.vala"
	_tmp30_ = currentBookForSlider;
#line 309 "../src/window.vala"
	_tmp31_ = _bookworm_app_book_ref0 (_tmp30_);
#line 309 "../src/window.vala"
	_tmp32_ = g_strdup ("");
#line 309 "../src/window.vala"
	_tmp33_ = bookworm_app_content_handler_renderPage (_tmp31_, _tmp32_);
#line 309 "../src/window.vala"
	_bookworm_app_book_unref0 (currentBookForSlider);
#line 309 "../src/window.vala"
	currentBookForSlider = _tmp33_;
#line 310 "../src/window.vala"
	_tmp34_ = bookworm_app_bookworm_libraryViewMap;
#line 310 "../src/window.vala"
	_tmp35_ = currentBookForSlider;
#line 310 "../src/window.vala"
	_tmp36_ = bookworm_app_book_getBookLocation (_tmp35_);
#line 310 "../src/window.vala"
	_tmp37_ = _tmp36_;
#line 310 "../src/window.vala"
	_tmp38_ = currentBookForSlider;
#line 310 "../src/window.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp34_, _tmp37_, _tmp38_);
#line 310 "../src/window.vala"
	_g_free0 (_tmp37_);
#line 311 "../src/window.vala"
	_tmp39_ = currentBookForSlider;
#line 311 "../src/window.vala"
	_tmp40_ = bookworm_app_book_getBookLocation (_tmp39_);
#line 311 "../src/window.vala"
	_g_free0 (bookworm_app_bookworm_locationOfEBookCurrentlyRead);
#line 311 "../src/window.vala"
	bookworm_app_bookworm_locationOfEBookCurrentlyRead = _tmp40_;
#line 312 "../src/window.vala"
	_tmp41_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 312 "../src/window.vala"
	_tmp42_ = g_strconcat ("Page Slider value change action completed for book at location:", _tmp41_, NULL);
#line 312 "../src/window.vala"
	_tmp43_ = _tmp42_;
#line 312 "../src/window.vala"
	_tmp44_ = g_strconcat (_tmp43_, " and rendering completed for page number:", NULL);
#line 312 "../src/window.vala"
	_tmp45_ = _tmp44_;
#line 312 "../src/window.vala"
	_tmp46_ = currentBookForSlider;
#line 312 "../src/window.vala"
	_tmp47_ = g_strdup_printf ("%i", bookworm_app_book_getBookPageNumber (_tmp46_));
#line 312 "../src/window.vala"
	_tmp48_ = _tmp47_;
#line 312 "../src/window.vala"
	_tmp49_ = g_strconcat (_tmp45_, _tmp48_, NULL);
#line 312 "../src/window.vala"
	_tmp50_ = _tmp49_;
#line 312 "../src/window.vala"
	g_debug ("window.vala:312: %s", _tmp50_);
#line 312 "../src/window.vala"
	_g_free0 (_tmp50_);
#line 312 "../src/window.vala"
	_g_free0 (_tmp48_);
#line 312 "../src/window.vala"
	_g_free0 (_tmp45_);
#line 312 "../src/window.vala"
	_g_free0 (_tmp43_);
#line 315 "../src/window.vala"
	result = TRUE;
#line 315 "../src/window.vala"
	_bookworm_app_book_unref0 (currentBookForSlider);
#line 315 "../src/window.vala"
	return result;
#line 1174 "window.c"
}

static gboolean
___lambda52__gtk_range_change_value (GtkRange* _sender,
                                     GtkScrollType scroll,
                                     gdouble new_value,
                                     gpointer self)
{
	gboolean result;
	result = __lambda52_ (scroll, new_value);
#line 297 "../src/window.vala"
	return result;
#line 1187 "window.c"
}

static void
__lambda53_ (void)
{
	GeeArrayList* selectedEBooks = NULL;
	GtkApplicationWindow* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gchar** _tmp5_;
	gint countOfBooksToBeAdded = 0;
	GtkProgressBar* _tmp18_;
#line 319 "../src/window.vala"
	_tmp0_ = bookworm_app_bookworm_window;
#line 319 "../src/window.vala"
	_tmp1_ = bookworm_app_utils_selectFileChooser (GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Select eBook"), (GtkWindow*) _tmp0_, TRUE, "EBOOKS");
#line 319 "../src/window.vala"
	selectedEBooks = _tmp1_;
#line 322 "../src/window.vala"
	_tmp2_ = selectedEBooks;
#line 322 "../src/window.vala"
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 322 "../src/window.vala"
	_tmp4_ = _tmp3_;
#line 322 "../src/window.vala"
	_tmp5_ = g_new0 (gchar*, _tmp4_ + 1);
#line 322 "../src/window.vala"
	bookworm_app_bookworm_pathsOfBooksToBeAdded = (_vala_array_free (bookworm_app_bookworm_pathsOfBooksToBeAdded, bookworm_app_bookworm_pathsOfBooksToBeAdded_length1, (GDestroyNotify) g_free), NULL);
#line 322 "../src/window.vala"
	bookworm_app_bookworm_pathsOfBooksToBeAdded = _tmp5_;
#line 322 "../src/window.vala"
	bookworm_app_bookworm_pathsOfBooksToBeAdded_length1 = _tmp4_;
#line 323 "../src/window.vala"
	countOfBooksToBeAdded = 0;
#line 1224 "window.c"
	{
		GeeArrayList* _pathToSelectedBook_list = NULL;
		GeeArrayList* _tmp6_;
		gint _pathToSelectedBook_size = 0;
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		gint _pathToSelectedBook_index = 0;
#line 324 "../src/window.vala"
		_tmp6_ = selectedEBooks;
#line 324 "../src/window.vala"
		_pathToSelectedBook_list = _tmp6_;
#line 324 "../src/window.vala"
		_tmp7_ = _pathToSelectedBook_list;
#line 324 "../src/window.vala"
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
#line 324 "../src/window.vala"
		_tmp9_ = _tmp8_;
#line 324 "../src/window.vala"
		_pathToSelectedBook_size = _tmp9_;
#line 324 "../src/window.vala"
		_pathToSelectedBook_index = -1;
#line 324 "../src/window.vala"
		while (TRUE) {
#line 1249 "window.c"
			gint _tmp10_;
			gint _tmp11_;
			gchar* pathToSelectedBook = NULL;
			GeeArrayList* _tmp12_;
			gpointer _tmp13_;
			gchar** _tmp14_;
			gint _tmp14__length1;
			const gchar* _tmp15_;
			gchar* _tmp16_;
			gint _tmp17_;
#line 324 "../src/window.vala"
			_pathToSelectedBook_index = _pathToSelectedBook_index + 1;
#line 324 "../src/window.vala"
			_tmp10_ = _pathToSelectedBook_index;
#line 324 "../src/window.vala"
			_tmp11_ = _pathToSelectedBook_size;
#line 324 "../src/window.vala"
			if (!(_tmp10_ < _tmp11_)) {
#line 324 "../src/window.vala"
				break;
#line 1270 "window.c"
			}
#line 324 "../src/window.vala"
			_tmp12_ = _pathToSelectedBook_list;
#line 324 "../src/window.vala"
			_tmp13_ = gee_abstract_list_get ((GeeAbstractList*) _tmp12_, _pathToSelectedBook_index);
#line 324 "../src/window.vala"
			pathToSelectedBook = (gchar*) _tmp13_;
#line 325 "../src/window.vala"
			_tmp14_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 325 "../src/window.vala"
			_tmp14__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 325 "../src/window.vala"
			_tmp15_ = pathToSelectedBook;
#line 325 "../src/window.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 325 "../src/window.vala"
			_g_free0 (_tmp14_[countOfBooksToBeAdded]);
#line 325 "../src/window.vala"
			_tmp14_[countOfBooksToBeAdded] = _tmp16_;
#line 326 "../src/window.vala"
			_tmp17_ = countOfBooksToBeAdded;
#line 326 "../src/window.vala"
			countOfBooksToBeAdded = _tmp17_ + 1;
#line 324 "../src/window.vala"
			_g_free0 (pathToSelectedBook);
#line 1296 "window.c"
		}
	}
#line 329 "../src/window.vala"
	_tmp18_ = bookworm_app_app_window_bookAdditionBar;
#line 329 "../src/window.vala"
	gtk_widget_show ((GtkWidget*) _tmp18_);
#line 330 "../src/window.vala"
	bookworm_app_bookworm_isBookBeingAddedToLibrary = TRUE;
#line 331 "../src/window.vala"
	bookworm_app_library_addBooksToLibrary (NULL, NULL);
#line 318 "../src/window.vala"
	_g_object_unref0 (selectedEBooks);
#line 1309 "window.c"
}

static void
___lambda53__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 318 "../src/window.vala"
	__lambda53_ ();
#line 1318 "window.c"
}

static void
__lambda54_ (void)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
#line 336 "../src/window.vala"
	bookworm_app_app_window_noOfBooksSelected = 0;
#line 338 "../src/window.vala"
	_tmp2_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 338 "../src/window.vala"
	_tmp3_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 338 "../src/window.vala"
	if (g_strcmp0 (_tmp2_, _tmp3_) == 0) {
#line 338 "../src/window.vala"
		_tmp1_ = TRUE;
#line 1338 "window.c"
	} else {
		const gchar* _tmp4_;
		const gchar* _tmp5_;
#line 339 "../src/window.vala"
		_tmp4_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 339 "../src/window.vala"
		_tmp5_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[6];
#line 339 "../src/window.vala"
		_tmp1_ = g_strcmp0 (_tmp4_, _tmp5_) == 0;
#line 1348 "window.c"
	}
#line 338 "../src/window.vala"
	if (_tmp1_) {
#line 338 "../src/window.vala"
		_tmp0_ = TRUE;
#line 1354 "window.c"
	} else {
		const gchar* _tmp6_;
		const gchar* _tmp7_;
#line 340 "../src/window.vala"
		_tmp6_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 340 "../src/window.vala"
		_tmp7_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[7];
#line 340 "../src/window.vala"
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
#line 1364 "window.c"
	}
#line 338 "../src/window.vala"
	if (_tmp0_) {
#line 1368 "window.c"
		gboolean _tmp8_ = FALSE;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
#line 343 "../src/window.vala"
		_tmp9_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 343 "../src/window.vala"
		_tmp10_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[6];
#line 343 "../src/window.vala"
		if (g_strcmp0 (_tmp9_, _tmp10_) == 0) {
#line 343 "../src/window.vala"
			_tmp8_ = TRUE;
#line 1380 "window.c"
		} else {
			const gchar* _tmp11_;
			const gchar* _tmp12_;
#line 344 "../src/window.vala"
			_tmp11_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 344 "../src/window.vala"
			_tmp12_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[7];
#line 344 "../src/window.vala"
			_tmp8_ = g_strcmp0 (_tmp11_, _tmp12_) == 0;
#line 1390 "window.c"
		}
#line 343 "../src/window.vala"
		if (_tmp8_) {
#line 1394 "window.c"
			const gchar* _tmp13_;
			gchar* _tmp14_;
#line 347 "../src/window.vala"
			_tmp13_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[5];
#line 347 "../src/window.vala"
			_tmp14_ = g_strdup (_tmp13_);
#line 347 "../src/window.vala"
			_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 347 "../src/window.vala"
			bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp14_;
#line 348 "../src/window.vala"
			bookworm_app_library_updateListViewForSelection (NULL);
#line 1407 "window.c"
		} else {
			const gchar* _tmp15_;
			gchar* _tmp16_;
#line 351 "../src/window.vala"
			_tmp15_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[6];
#line 351 "../src/window.vala"
			_tmp16_ = g_strdup (_tmp15_);
#line 351 "../src/window.vala"
			_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 351 "../src/window.vala"
			bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp16_;
#line 352 "../src/window.vala"
			bookworm_app_library_updateListViewForSelection (NULL);
#line 1421 "window.c"
		}
	} else {
		gboolean _tmp17_ = FALSE;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
#line 356 "../src/window.vala"
		_tmp18_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 356 "../src/window.vala"
		_tmp19_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[2];
#line 356 "../src/window.vala"
		if (g_strcmp0 (_tmp18_, _tmp19_) == 0) {
#line 356 "../src/window.vala"
			_tmp17_ = TRUE;
#line 1435 "window.c"
		} else {
			const gchar* _tmp20_;
			const gchar* _tmp21_;
#line 357 "../src/window.vala"
			_tmp20_ = bookworm_app_bookworm_BOOKWORM_CURRENT_STATE;
#line 357 "../src/window.vala"
			_tmp21_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[3];
#line 357 "../src/window.vala"
			_tmp17_ = g_strcmp0 (_tmp20_, _tmp21_) == 0;
#line 1445 "window.c"
		}
#line 356 "../src/window.vala"
		if (_tmp17_) {
#line 1449 "window.c"
			BookwormAppSettings* _tmp22_;
			const gchar* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
#line 360 "../src/window.vala"
			_tmp22_ = bookworm_app_app_window_settings;
#line 360 "../src/window.vala"
			_tmp23_ = bookworm_app_settings_get_library_view_mode (_tmp22_);
#line 360 "../src/window.vala"
			_tmp24_ = _tmp23_;
#line 360 "../src/window.vala"
			_tmp25_ = g_strdup (_tmp24_);
#line 360 "../src/window.vala"
			_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 360 "../src/window.vala"
			bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp25_;
#line 361 "../src/window.vala"
			bookworm_app_library_updateGridViewForSelection (NULL);
#line 1468 "window.c"
		} else {
			const gchar* _tmp26_;
			gchar* _tmp27_;
#line 364 "../src/window.vala"
			_tmp26_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[2];
#line 364 "../src/window.vala"
			_tmp27_ = g_strdup (_tmp26_);
#line 364 "../src/window.vala"
			_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 364 "../src/window.vala"
			bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp27_;
#line 365 "../src/window.vala"
			bookworm_app_library_updateGridViewForSelection (NULL);
#line 1482 "window.c"
		}
	}
}

static void
___lambda54__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 334 "../src/window.vala"
	__lambda54_ ();
#line 1493 "window.c"
}

static void
__lambda55_ (void)
{
#line 371 "../src/window.vala"
	bookworm_app_library_removeSelectedBooksFromLibrary ();
#line 1501 "window.c"
}

static void
___lambda55__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 370 "../src/window.vala"
	__lambda55_ ();
#line 1510 "window.c"
}

static void
__lambda57_ (void)
{
	gchar* selected_text = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
#line 409 "../src/window.vala"
	_tmp0_ = bookworm_app_utils_setWebViewTitle ("document.title = getSelectionText()");
#line 409 "../src/window.vala"
	selected_text = _tmp0_;
#line 410 "../src/window.vala"
	_tmp2_ = selected_text;
#line 410 "../src/window.vala"
	if (_tmp2_ != NULL) {
#line 1528 "window.c"
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 410 "../src/window.vala"
		_tmp3_ = selected_text;
#line 410 "../src/window.vala"
		_tmp4_ = strlen (_tmp3_);
#line 410 "../src/window.vala"
		_tmp5_ = _tmp4_;
#line 410 "../src/window.vala"
		_tmp1_ = _tmp5_ > 0;
#line 1540 "window.c"
	} else {
#line 410 "../src/window.vala"
		_tmp1_ = FALSE;
#line 1544 "window.c"
	}
#line 410 "../src/window.vala"
	if (_tmp1_) {
#line 1548 "window.c"
		const gchar* _tmp6_;
#line 411 "../src/window.vala"
		_tmp6_ = selected_text;
#line 411 "../src/window.vala"
		bookworm_app_info_populateDictionaryResults (_tmp6_);
#line 1554 "window.c"
	}
#line 408 "../src/window.vala"
	_g_free0 (selected_text);
#line 1558 "window.c"
}

static void
___lambda57__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
#line 408 "../src/window.vala"
	__lambda57_ ();
#line 1568 "window.c"
}

static void
__lambda58_ (void)
{
	gchar* selected_text = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
#line 415 "../src/window.vala"
	_tmp0_ = bookworm_app_utils_setWebViewTitle ("document.title = getSelectionText()");
#line 415 "../src/window.vala"
	selected_text = _tmp0_;
#line 416 "../src/window.vala"
	_tmp2_ = selected_text;
#line 416 "../src/window.vala"
	if (_tmp2_ != NULL) {
#line 1586 "window.c"
		const gchar* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 416 "../src/window.vala"
		_tmp3_ = selected_text;
#line 416 "../src/window.vala"
		_tmp4_ = strlen (_tmp3_);
#line 416 "../src/window.vala"
		_tmp5_ = _tmp4_;
#line 416 "../src/window.vala"
		_tmp1_ = _tmp5_ > 0;
#line 1598 "window.c"
	} else {
#line 416 "../src/window.vala"
		_tmp1_ = FALSE;
#line 1602 "window.c"
	}
#line 416 "../src/window.vala"
	if (_tmp1_) {
#line 1606 "window.c"
		const gchar* _tmp6_;
#line 417 "../src/window.vala"
		_tmp6_ = selected_text;
#line 417 "../src/window.vala"
		bookworm_app_app_dialog_createAnnotationDialog (_tmp6_);
#line 1612 "window.c"
	}
#line 414 "../src/window.vala"
	_g_free0 (selected_text);
#line 1616 "window.c"
}

static void
___lambda58__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
#line 414 "../src/window.vala"
	__lambda58_ ();
#line 1626 "window.c"
}

static void
__lambda59_ (Block20Data* _data20_)
{
	GtkApplicationWindow* _tmp0_;
#line 421 "../src/window.vala"
	gtk_widget_hide ((GtkWidget*) _data20_->book_reading_footer_box);
#line 422 "../src/window.vala"
	_tmp0_ = bookworm_app_bookworm_window;
#line 422 "../src/window.vala"
	gtk_window_fullscreen ((GtkWindow*) _tmp0_);
#line 1639 "window.c"
}

static void
___lambda59__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
#line 420 "../src/window.vala"
	__lambda59_ (self);
#line 1649 "window.c"
}

static void
__lambda60_ (Block20Data* _data20_)
{
	GtkApplicationWindow* _tmp0_;
#line 425 "../src/window.vala"
	gtk_widget_show ((GtkWidget*) _data20_->book_reading_footer_box);
#line 426 "../src/window.vala"
	_tmp0_ = bookworm_app_bookworm_window;
#line 426 "../src/window.vala"
	gtk_window_unfullscreen ((GtkWindow*) _tmp0_);
#line 1662 "window.c"
}

static void
___lambda60__g_simple_action_activate (GSimpleAction* _sender,
                                       GVariant* parameter,
                                       gpointer self)
{
#line 424 "../src/window.vala"
	__lambda60_ (self);
#line 1672 "window.c"
}

static gboolean
__lambda56_ (Block20Data* _data20_,
             WebKitContextMenu* context_menu,
             GdkEvent* event,
             WebKitHitTestResult* hit_test_result)
{
	GSimpleAction* pageActionFullScreenEntry = NULL;
	GSimpleAction* _tmp0_;
	GSimpleAction* pageActionFullScreenExit = NULL;
	GSimpleAction* _tmp1_;
	GSimpleAction* pageActionWordMeaning = NULL;
	GSimpleAction* _tmp2_;
	GSimpleAction* pageActionAnnotateSelection = NULL;
	GSimpleAction* _tmp3_;
	WebKitContextMenuItem* pageContextMenuItemWordMeaning = NULL;
	GSimpleAction* _tmp4_;
	WebKitContextMenuItem* _tmp5_;
	WebKitContextMenuItem* pageContextMenuItemFullScreenEntry = NULL;
	GSimpleAction* _tmp6_;
	WebKitContextMenuItem* _tmp7_;
	WebKitContextMenuItem* pageContextMenuItemFullScreenExit = NULL;
	GSimpleAction* _tmp8_;
	WebKitContextMenuItem* _tmp9_;
	WebKitContextMenuItem* pageContextMenuItemAnnotateSelection = NULL;
	GSimpleAction* _tmp10_;
	WebKitContextMenuItem* _tmp11_;
	WebKitContextMenuItem* _tmp12_;
	WebKitContextMenuItem* _tmp13_;
	GSimpleAction* _tmp16_;
	GSimpleAction* _tmp17_;
	GSimpleAction* _tmp18_;
	GSimpleAction* _tmp19_;
	gboolean result;
#line 374 "../src/window.vala"
	g_return_val_if_fail (context_menu != NULL, FALSE);
#line 374 "../src/window.vala"
	g_return_val_if_fail (event != NULL, FALSE);
#line 374 "../src/window.vala"
	g_return_val_if_fail (hit_test_result != NULL, FALSE);
#line 375 "../src/window.vala"
	webkit_context_menu_remove_all (context_menu);
#line 376 "../src/window.vala"
	_tmp0_ = g_simple_action_new ("FULL_SCREEN_READING_VIEW", NULL);
#line 376 "../src/window.vala"
	pageActionFullScreenEntry = _tmp0_;
#line 377 "../src/window.vala"
	_tmp1_ = g_simple_action_new ("FULL_SCREEN_READING_VIEW", NULL);
#line 377 "../src/window.vala"
	pageActionFullScreenExit = _tmp1_;
#line 378 "../src/window.vala"
	_tmp2_ = g_simple_action_new ("WORD_MEANING", NULL);
#line 378 "../src/window.vala"
	pageActionWordMeaning = _tmp2_;
#line 379 "../src/window.vala"
	_tmp3_ = g_simple_action_new ("ANNOTATE_SELECTION", NULL);
#line 379 "../src/window.vala"
	pageActionAnnotateSelection = _tmp3_;
#line 381 "../src/window.vala"
	_tmp4_ = pageActionWordMeaning;
#line 381 "../src/window.vala"
	_tmp5_ = webkit_context_menu_item_new_from_gaction ((GAction*) _tmp4_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_PAGE_CONTEXTMENU_WORD_MEANING, NULL);
#line 381 "../src/window.vala"
	g_object_ref_sink (_tmp5_);
#line 381 "../src/window.vala"
	pageContextMenuItemWordMeaning = _tmp5_;
#line 385 "../src/window.vala"
	_tmp6_ = pageActionFullScreenEntry;
#line 385 "../src/window.vala"
	_tmp7_ = webkit_context_menu_item_new_from_gaction ((GAction*) _tmp6_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_PAGE_CONTEXTMENU_FULL_SCREEN_ENTRY, NULL);
#line 385 "../src/window.vala"
	g_object_ref_sink (_tmp7_);
#line 385 "../src/window.vala"
	pageContextMenuItemFullScreenEntry = _tmp7_;
#line 389 "../src/window.vala"
	_tmp8_ = pageActionFullScreenExit;
#line 389 "../src/window.vala"
	_tmp9_ = webkit_context_menu_item_new_from_gaction ((GAction*) _tmp8_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_PAGE_CONTEXTMENU_FULL_SCREEN_EXIT, NULL);
#line 389 "../src/window.vala"
	g_object_ref_sink (_tmp9_);
#line 389 "../src/window.vala"
	pageContextMenuItemFullScreenExit = _tmp9_;
#line 393 "../src/window.vala"
	_tmp10_ = pageActionAnnotateSelection;
#line 393 "../src/window.vala"
	_tmp11_ = webkit_context_menu_item_new_from_gaction ((GAction*) _tmp10_, BOOKWORM_APP_CONSTANTS_TEXT_FOR_PAGE_CONTEXTMENU_ANNOTATE_SELECTION, NULL);
#line 393 "../src/window.vala"
	g_object_ref_sink (_tmp11_);
#line 393 "../src/window.vala"
	pageContextMenuItemAnnotateSelection = _tmp11_;
#line 398 "../src/window.vala"
	_tmp12_ = pageContextMenuItemWordMeaning;
#line 398 "../src/window.vala"
	webkit_context_menu_append (context_menu, _tmp12_);
#line 399 "../src/window.vala"
	_tmp13_ = pageContextMenuItemAnnotateSelection;
#line 399 "../src/window.vala"
	webkit_context_menu_append (context_menu, _tmp13_);
#line 401 "../src/window.vala"
	if (gtk_widget_get_visible ((GtkWidget*) _data20_->book_reading_footer_box)) {
#line 1774 "window.c"
		WebKitContextMenuItem* _tmp14_;
#line 402 "../src/window.vala"
		_tmp14_ = pageContextMenuItemFullScreenEntry;
#line 402 "../src/window.vala"
		webkit_context_menu_append (context_menu, _tmp14_);
#line 1780 "window.c"
	} else {
		WebKitContextMenuItem* _tmp15_;
#line 404 "../src/window.vala"
		_tmp15_ = pageContextMenuItemFullScreenExit;
#line 404 "../src/window.vala"
		webkit_context_menu_append (context_menu, _tmp15_);
#line 1787 "window.c"
	}
#line 408 "../src/window.vala"
	_tmp16_ = pageActionWordMeaning;
#line 408 "../src/window.vala"
	g_signal_connect (_tmp16_, "activate", (GCallback) ___lambda57__g_simple_action_activate, NULL);
#line 414 "../src/window.vala"
	_tmp17_ = pageActionAnnotateSelection;
#line 414 "../src/window.vala"
	g_signal_connect (_tmp17_, "activate", (GCallback) ___lambda58__g_simple_action_activate, NULL);
#line 420 "../src/window.vala"
	_tmp18_ = pageActionFullScreenEntry;
#line 420 "../src/window.vala"
	g_signal_connect_data (_tmp18_, "activate", (GCallback) ___lambda59__g_simple_action_activate, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
#line 424 "../src/window.vala"
	_tmp19_ = pageActionFullScreenExit;
#line 424 "../src/window.vala"
	g_signal_connect_data (_tmp19_, "activate", (GCallback) ___lambda60__g_simple_action_activate, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
#line 429 "../src/window.vala"
	result = FALSE;
#line 429 "../src/window.vala"
	_g_object_unref0 (pageContextMenuItemAnnotateSelection);
#line 429 "../src/window.vala"
	_g_object_unref0 (pageContextMenuItemFullScreenExit);
#line 429 "../src/window.vala"
	_g_object_unref0 (pageContextMenuItemFullScreenEntry);
#line 429 "../src/window.vala"
	_g_object_unref0 (pageContextMenuItemWordMeaning);
#line 429 "../src/window.vala"
	_g_object_unref0 (pageActionAnnotateSelection);
#line 429 "../src/window.vala"
	_g_object_unref0 (pageActionWordMeaning);
#line 429 "../src/window.vala"
	_g_object_unref0 (pageActionFullScreenExit);
#line 429 "../src/window.vala"
	_g_object_unref0 (pageActionFullScreenEntry);
#line 429 "../src/window.vala"
	return result;
#line 1825 "window.c"
}

static gboolean
___lambda56__webkit_web_view_context_menu (WebKitWebView* _sender,
                                           WebKitContextMenu* context_menu,
                                           GdkEvent* event,
                                           WebKitHitTestResult* hit_test_result,
                                           gpointer self)
{
	gboolean result;
	result = __lambda56_ (self, context_menu, event, hit_test_result);
#line 374 "../src/window.vala"
	return result;
#line 1839 "window.c"
}

static WebKitNavigationAction*
_vala_WebKitNavigationAction_copy (WebKitNavigationAction* self)
{
#line 448 "../src/window.vala"
	return g_boxed_copy (webkit_navigation_action_get_type (), self);
#line 1847 "window.c"
}

static gpointer
__vala_WebKitNavigationAction_copy0 (gpointer self)
{
#line 448 "../src/window.vala"
	return self ? _vala_WebKitNavigationAction_copy (self) : NULL;
#line 1855 "window.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 1876 "window.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1900 "window.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1908 "window.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1914 "window.c"
	}
}

static void
_vala_WebKitNavigationAction_free (WebKitNavigationAction* self)
{
#line 458 "../src/window.vala"
	g_boxed_free (webkit_navigation_action_get_type (), self);
#line 1923 "window.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1945 "window.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1949 "window.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1955 "window.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1959 "window.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1963 "window.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1971 "window.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1999 "window.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 2008 "window.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 2022 "window.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 2031 "window.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 2045 "window.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 2054 "window.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 2063 "window.c"
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 2090 "window.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 2096 "window.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 2102 "window.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 2106 "window.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 2114 "window.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 2118 "window.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 2130 "window.c"
}

static gboolean
__lambda61_ (WebKitPolicyDecision* decision,
             WebKitPolicyDecisionType type)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
#line 432 "../src/window.vala"
	g_return_val_if_fail (decision != NULL, FALSE);
#line 433 "../src/window.vala"
	if (type == WEBKIT_POLICY_DECISION_TYPE_RESPONSE) {
#line 434 "../src/window.vala"
		g_debug ("window.vala:434: Signal captured for Policy type WebKit.PolicyDecision" \
"Type.RESPONSE");
#line 435 "../src/window.vala"
		bookworm_app_app_window_isWebViewRequestCompleted = TRUE;
#line 2147 "window.c"
	}
#line 437 "../src/window.vala"
	if (type == WEBKIT_POLICY_DECISION_TYPE_NEW_WINDOW_ACTION) {
#line 438 "../src/window.vala"
		g_debug ("window.vala:438: Signal captured for Policy type WebKit.PolicyDecision" \
"Type.NEW_WINDOW_ACTION");
#line 439 "../src/window.vala"
		bookworm_app_app_window_isWebViewRequestCompleted = TRUE;
#line 2155 "window.c"
	}
#line 441 "../src/window.vala"
	if (type == WEBKIT_POLICY_DECISION_TYPE_NAVIGATION_ACTION) {
#line 441 "../src/window.vala"
		_tmp0_ = bookworm_app_app_window_isWebViewRequestCompleted;
#line 2161 "window.c"
	} else {
#line 441 "../src/window.vala"
		_tmp0_ = FALSE;
#line 2165 "window.c"
	}
#line 441 "../src/window.vala"
	if (_tmp0_) {
#line 2169 "window.c"
		WebKitNavigationPolicyDecision* aNavDecision = NULL;
		WebKitNavigationPolicyDecision* _tmp1_;
		WebKitNavigationAction* aNavAction = NULL;
		WebKitNavigationPolicyDecision* _tmp2_;
		WebKitNavigationAction* _tmp3_;
		WebKitNavigationAction* _tmp4_;
		WebKitURIRequest* aURIReq = NULL;
		WebKitNavigationAction* _tmp5_;
		WebKitURIRequest* _tmp6_;
		WebKitURIRequest* _tmp7_;
		gchar* url_clicked_on_webview = NULL;
		WebKitURIRequest* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		const gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		WebKitWebView* _tmp25_;
		const gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gboolean _tmp29_ = FALSE;
		gboolean _tmp30_ = FALSE;
		WebKitWebView* _tmp31_;
		const gchar* _tmp32_;
		const gchar* _tmp43_;
		const gchar* _tmp47_;
		GFile* _tmp48_;
		GFile* _tmp49_;
		gchar* _tmp50_;
		gint contentLocationPosition = 0;
		BookwormAppBook* aBook = NULL;
		GeeHashMap* _tmp51_;
		const gchar* _tmp52_;
		gpointer _tmp53_;
#line 442 "../src/window.vala"
		g_debug ("window.vala:442: Signal captured for Policy type WebKit.PolicyDecision" \
"Type.NAVIGATION_ACTION");
#line 445 "../src/window.vala"
		bookworm_app_app_window_isWebViewRequestCompleted = FALSE;
#line 447 "../src/window.vala"
		_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (decision, webkit_navigation_policy_decision_get_type (), WebKitNavigationPolicyDecision));
#line 447 "../src/window.vala"
		aNavDecision = _tmp1_;
#line 448 "../src/window.vala"
		_tmp2_ = aNavDecision;
#line 448 "../src/window.vala"
		_tmp3_ = webkit_navigation_policy_decision_get_navigation_action (_tmp2_);
#line 448 "../src/window.vala"
		_tmp4_ = __vala_WebKitNavigationAction_copy0 (_tmp3_);
#line 448 "../src/window.vala"
		aNavAction = _tmp4_;
#line 449 "../src/window.vala"
		_tmp5_ = aNavAction;
#line 449 "../src/window.vala"
		_tmp6_ = webkit_navigation_action_get_request (_tmp5_);
#line 449 "../src/window.vala"
		_tmp7_ = _g_object_ref0 (_tmp6_);
#line 449 "../src/window.vala"
		aURIReq = _tmp7_;
#line 450 "../src/window.vala"
		_tmp8_ = aURIReq;
#line 450 "../src/window.vala"
		_tmp9_ = webkit_uri_request_get_uri (_tmp8_);
#line 450 "../src/window.vala"
		_tmp10_ = string_strip (_tmp9_);
#line 450 "../src/window.vala"
		_tmp11_ = _tmp10_;
#line 450 "../src/window.vala"
		_tmp12_ = bookworm_app_utils_decodeHTMLChars (_tmp11_);
#line 450 "../src/window.vala"
		_tmp13_ = _tmp12_;
#line 450 "../src/window.vala"
		_g_free0 (_tmp11_);
#line 450 "../src/window.vala"
		url_clicked_on_webview = _tmp13_;
#line 451 "../src/window.vala"
		_tmp14_ = url_clicked_on_webview;
#line 451 "../src/window.vala"
		_tmp15_ = soup_uri_decode (_tmp14_);
#line 451 "../src/window.vala"
		_g_free0 (url_clicked_on_webview);
#line 451 "../src/window.vala"
		url_clicked_on_webview = _tmp15_;
#line 452 "../src/window.vala"
		_tmp16_ = url_clicked_on_webview;
#line 452 "../src/window.vala"
		_tmp17_ = g_strconcat ("URL Captured:", _tmp16_, NULL);
#line 452 "../src/window.vala"
		_tmp18_ = _tmp17_;
#line 452 "../src/window.vala"
		g_debug ("window.vala:452: %s", _tmp18_);
#line 452 "../src/window.vala"
		_g_free0 (_tmp18_);
#line 455 "../src/window.vala"
		_tmp19_ = url_clicked_on_webview;
#line 455 "../src/window.vala"
		if (string_index_of (_tmp19_, "file://", 0) == -1) {
#line 2273 "window.c"
			const gchar* _tmp20_;
			gchar* _tmp21_;
			gchar* _tmp22_;
			gchar* _tmp23_;
			gchar* _tmp24_;
#line 456 "../src/window.vala"
			_tmp20_ = url_clicked_on_webview;
#line 456 "../src/window.vala"
			_tmp21_ = g_strconcat ("xdg-open ", _tmp20_, NULL);
#line 456 "../src/window.vala"
			_tmp22_ = _tmp21_;
#line 456 "../src/window.vala"
			_tmp23_ = bookworm_app_utils_execute_sync_command (_tmp22_);
#line 456 "../src/window.vala"
			_tmp24_ = _tmp23_;
#line 456 "../src/window.vala"
			_g_free0 (_tmp24_);
#line 456 "../src/window.vala"
			_g_free0 (_tmp22_);
#line 457 "../src/window.vala"
			webkit_policy_decision_ignore (decision);
#line 458 "../src/window.vala"
			result = TRUE;
#line 458 "../src/window.vala"
			_g_free0 (url_clicked_on_webview);
#line 458 "../src/window.vala"
			_g_object_unref0 (aURIReq);
#line 458 "../src/window.vala"
			__vala_WebKitNavigationAction_free0 (aNavAction);
#line 458 "../src/window.vala"
			_g_object_unref0 (aNavDecision);
#line 458 "../src/window.vala"
			return result;
#line 2307 "window.c"
		}
#line 462 "../src/window.vala"
		_tmp25_ = bookworm_app_app_window_aWebView;
#line 462 "../src/window.vala"
		_tmp26_ = webkit_web_view_get_title (_tmp25_);
#line 462 "../src/window.vala"
		_tmp27_ = g_strconcat ("Window Title:", _tmp26_, NULL);
#line 462 "../src/window.vala"
		_tmp28_ = _tmp27_;
#line 462 "../src/window.vala"
		g_debug ("window.vala:462: %s", _tmp28_);
#line 462 "../src/window.vala"
		_g_free0 (_tmp28_);
#line 463 "../src/window.vala"
		_tmp31_ = bookworm_app_app_window_aWebView;
#line 463 "../src/window.vala"
		_tmp32_ = webkit_web_view_get_title (_tmp31_);
#line 463 "../src/window.vala"
		if (_tmp32_ != NULL) {
#line 2327 "window.c"
			WebKitWebView* _tmp33_;
			const gchar* _tmp34_;
			gint _tmp35_;
			gint _tmp36_;
#line 464 "../src/window.vala"
			_tmp33_ = bookworm_app_app_window_aWebView;
#line 464 "../src/window.vala"
			_tmp34_ = webkit_web_view_get_title (_tmp33_);
#line 464 "../src/window.vala"
			_tmp35_ = strlen (_tmp34_);
#line 464 "../src/window.vala"
			_tmp36_ = _tmp35_;
#line 464 "../src/window.vala"
			_tmp30_ = _tmp36_ > 1;
#line 2342 "window.c"
		} else {
#line 463 "../src/window.vala"
			_tmp30_ = FALSE;
#line 2346 "window.c"
		}
#line 463 "../src/window.vala"
		if (_tmp30_) {
#line 2350 "window.c"
			WebKitWebView* _tmp37_;
			const gchar* _tmp38_;
#line 465 "../src/window.vala"
			_tmp37_ = bookworm_app_app_window_aWebView;
#line 465 "../src/window.vala"
			_tmp38_ = webkit_web_view_get_title (_tmp37_);
#line 465 "../src/window.vala"
			_tmp29_ = string_index_of (_tmp38_, "annotation:", 0) != -1;
#line 2359 "window.c"
		} else {
#line 463 "../src/window.vala"
			_tmp29_ = FALSE;
#line 2363 "window.c"
		}
#line 463 "../src/window.vala"
		if (_tmp29_) {
#line 2367 "window.c"
			WebKitWebView* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
#line 468 "../src/window.vala"
			_tmp39_ = bookworm_app_app_window_aWebView;
#line 468 "../src/window.vala"
			_tmp40_ = webkit_web_view_get_title (_tmp39_);
#line 468 "../src/window.vala"
			_tmp41_ = string_replace (_tmp40_, "annotation:", "");
#line 468 "../src/window.vala"
			_tmp42_ = _tmp41_;
#line 468 "../src/window.vala"
			bookworm_app_app_dialog_createAnnotationDialog (_tmp42_);
#line 468 "../src/window.vala"
			_g_free0 (_tmp42_);
#line 471 "../src/window.vala"
			bookworm_app_app_window_isWebViewRequestCompleted = TRUE;
#line 2386 "window.c"
		}
#line 475 "../src/window.vala"
		_tmp43_ = url_clicked_on_webview;
#line 475 "../src/window.vala"
		if (string_index_of (_tmp43_, "#", 0) != -1) {
#line 2392 "window.c"
			const gchar* _tmp44_;
			const gchar* _tmp45_;
			gchar* _tmp46_;
#line 476 "../src/window.vala"
			_tmp44_ = url_clicked_on_webview;
#line 476 "../src/window.vala"
			_tmp45_ = url_clicked_on_webview;
#line 476 "../src/window.vala"
			_tmp46_ = string_slice (_tmp44_, (glong) 0, (glong) string_index_of (_tmp45_, "#", 0));
#line 476 "../src/window.vala"
			_g_free0 (url_clicked_on_webview);
#line 476 "../src/window.vala"
			url_clicked_on_webview = _tmp46_;
#line 2406 "window.c"
		}
#line 478 "../src/window.vala"
		_tmp47_ = url_clicked_on_webview;
#line 478 "../src/window.vala"
		_tmp48_ = g_file_new_for_path (_tmp47_);
#line 478 "../src/window.vala"
		_tmp49_ = _tmp48_;
#line 478 "../src/window.vala"
		_tmp50_ = g_file_get_basename (_tmp49_);
#line 478 "../src/window.vala"
		_g_free0 (url_clicked_on_webview);
#line 478 "../src/window.vala"
		url_clicked_on_webview = _tmp50_;
#line 478 "../src/window.vala"
		_g_object_unref0 (_tmp49_);
#line 479 "../src/window.vala"
		contentLocationPosition = 0;
#line 480 "../src/window.vala"
		_tmp51_ = bookworm_app_bookworm_libraryViewMap;
#line 480 "../src/window.vala"
		_tmp52_ = bookworm_app_bookworm_locationOfEBookCurrentlyRead;
#line 480 "../src/window.vala"
		_tmp53_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp51_, _tmp52_);
#line 480 "../src/window.vala"
		aBook = (BookwormAppBook*) _tmp53_;
#line 2432 "window.c"
		{
			GeeArrayList* _aBookContent_list = NULL;
			BookwormAppBook* _tmp54_;
			GeeArrayList* _tmp55_;
			gint _aBookContent_size = 0;
			GeeArrayList* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			gint _aBookContent_index = 0;
#line 482 "../src/window.vala"
			_tmp54_ = aBook;
#line 482 "../src/window.vala"
			_tmp55_ = bookworm_app_book_getBookContentList (_tmp54_);
#line 482 "../src/window.vala"
			_aBookContent_list = _tmp55_;
#line 482 "../src/window.vala"
			_tmp56_ = _aBookContent_list;
#line 482 "../src/window.vala"
			_tmp57_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp56_);
#line 482 "../src/window.vala"
			_tmp58_ = _tmp57_;
#line 482 "../src/window.vala"
			_aBookContent_size = _tmp58_;
#line 482 "../src/window.vala"
			_aBookContent_index = -1;
#line 482 "../src/window.vala"
			while (TRUE) {
#line 2460 "window.c"
				gint _tmp59_;
				gint _tmp60_;
				gchar* aBookContent = NULL;
				GeeArrayList* _tmp61_;
				gpointer _tmp62_;
				const gchar* _tmp63_;
				gchar* _tmp64_;
				gchar* _tmp65_;
				const gchar* _tmp66_;
				gboolean _tmp67_;
				gint _tmp90_;
#line 482 "../src/window.vala"
				_aBookContent_index = _aBookContent_index + 1;
#line 482 "../src/window.vala"
				_tmp59_ = _aBookContent_index;
#line 482 "../src/window.vala"
				_tmp60_ = _aBookContent_size;
#line 482 "../src/window.vala"
				if (!(_tmp59_ < _tmp60_)) {
#line 482 "../src/window.vala"
					break;
#line 2482 "window.c"
				}
#line 482 "../src/window.vala"
				_tmp61_ = _aBookContent_list;
#line 482 "../src/window.vala"
				_tmp62_ = gee_abstract_list_get ((GeeAbstractList*) _tmp61_, _aBookContent_index);
#line 482 "../src/window.vala"
				aBookContent = (gchar*) _tmp62_;
#line 483 "../src/window.vala"
				_tmp63_ = aBookContent;
#line 483 "../src/window.vala"
				_tmp64_ = bookworm_app_utils_decodeHTMLChars (_tmp63_);
#line 483 "../src/window.vala"
				_tmp65_ = _tmp64_;
#line 483 "../src/window.vala"
				_tmp66_ = url_clicked_on_webview;
#line 483 "../src/window.vala"
				_tmp67_ = string_index_of (_tmp65_, _tmp66_, 0) != -1;
#line 483 "../src/window.vala"
				_g_free0 (_tmp65_);
#line 483 "../src/window.vala"
				if (_tmp67_) {
#line 2504 "window.c"
					const gchar* _tmp68_;
					gchar* _tmp69_;
					gchar* _tmp70_;
					gchar* _tmp71_;
					gchar* _tmp72_;
					BookwormAppBook* _tmp73_;
					GeeHashMap* _tmp74_;
					BookwormAppBook* _tmp75_;
					gchar* _tmp76_;
					gchar* _tmp77_;
					BookwormAppBook* _tmp78_;
					BookwormAppBook* _tmp79_;
					BookwormAppBook* _tmp80_;
					gchar* _tmp81_;
					BookwormAppBook* _tmp82_;
					const gchar* _tmp83_;
					gchar* _tmp84_;
					BookwormAppBook* _tmp85_;
					gchar* _tmp86_;
					gchar* _tmp87_;
					gchar* _tmp88_;
					gchar* _tmp89_;
#line 484 "../src/window.vala"
					_tmp68_ = aBookContent;
#line 484 "../src/window.vala"
					_tmp69_ = bookworm_app_utils_decodeHTMLChars (_tmp68_);
#line 484 "../src/window.vala"
					_tmp70_ = _tmp69_;
#line 484 "../src/window.vala"
					_tmp71_ = g_strconcat ("Matched Link Clicked to book content:", _tmp70_, NULL);
#line 484 "../src/window.vala"
					_tmp72_ = _tmp71_;
#line 484 "../src/window.vala"
					g_debug ("window.vala:484: %s", _tmp72_);
#line 484 "../src/window.vala"
					_g_free0 (_tmp72_);
#line 484 "../src/window.vala"
					_g_free0 (_tmp70_);
#line 485 "../src/window.vala"
					_tmp73_ = aBook;
#line 485 "../src/window.vala"
					bookworm_app_book_setBookPageNumber (_tmp73_, contentLocationPosition);
#line 487 "../src/window.vala"
					_tmp74_ = bookworm_app_bookworm_libraryViewMap;
#line 487 "../src/window.vala"
					_tmp75_ = aBook;
#line 487 "../src/window.vala"
					_tmp76_ = bookworm_app_book_getBookLocation (_tmp75_);
#line 487 "../src/window.vala"
					_tmp77_ = _tmp76_;
#line 487 "../src/window.vala"
					_tmp78_ = aBook;
#line 487 "../src/window.vala"
					gee_abstract_map_set ((GeeAbstractMap*) _tmp74_, _tmp77_, _tmp78_);
#line 487 "../src/window.vala"
					_g_free0 (_tmp77_);
#line 488 "../src/window.vala"
					_tmp79_ = aBook;
#line 488 "../src/window.vala"
					_tmp80_ = _bookworm_app_book_ref0 (_tmp79_);
#line 488 "../src/window.vala"
					_tmp81_ = g_strdup ("");
#line 488 "../src/window.vala"
					_tmp82_ = bookworm_app_content_handler_renderPage (_tmp80_, _tmp81_);
#line 488 "../src/window.vala"
					_bookworm_app_book_unref0 (aBook);
#line 488 "../src/window.vala"
					aBook = _tmp82_;
#line 490 "../src/window.vala"
					_tmp83_ = BOOKWORM_APP_CONSTANTS_BOOKWORM_UI_STATES[1];
#line 490 "../src/window.vala"
					_tmp84_ = g_strdup (_tmp83_);
#line 490 "../src/window.vala"
					_g_free0 (bookworm_app_bookworm_BOOKWORM_CURRENT_STATE);
#line 490 "../src/window.vala"
					bookworm_app_bookworm_BOOKWORM_CURRENT_STATE = _tmp84_;
#line 491 "../src/window.vala"
					bookworm_app_bookworm_toggleUIState ();
#line 492 "../src/window.vala"
					_tmp85_ = aBook;
#line 492 "../src/window.vala"
					_tmp86_ = g_strdup_printf ("%i", bookworm_app_book_getBookPageNumber (_tmp85_));
#line 492 "../src/window.vala"
					_tmp87_ = _tmp86_;
#line 492 "../src/window.vala"
					_tmp88_ = g_strconcat ("URL is initiated from Bookworm Contents, Book page number set at:", _tmp87_, NULL);
#line 492 "../src/window.vala"
					_tmp89_ = _tmp88_;
#line 492 "../src/window.vala"
					g_debug ("window.vala:492: %s", _tmp89_);
#line 492 "../src/window.vala"
					_g_free0 (_tmp89_);
#line 492 "../src/window.vala"
					_g_free0 (_tmp87_);
#line 495 "../src/window.vala"
					_g_free0 (aBookContent);
#line 495 "../src/window.vala"
					break;
#line 2603 "window.c"
				}
#line 497 "../src/window.vala"
				_tmp90_ = contentLocationPosition;
#line 497 "../src/window.vala"
				contentLocationPosition = _tmp90_ + 1;
#line 482 "../src/window.vala"
				_g_free0 (aBookContent);
#line 2611 "window.c"
			}
#line 482 "../src/window.vala"
			_g_object_unref0 (_aBookContent_list);
#line 2615 "window.c"
		}
#line 441 "../src/window.vala"
		_bookworm_app_book_unref0 (aBook);
#line 441 "../src/window.vala"
		_g_free0 (url_clicked_on_webview);
#line 441 "../src/window.vala"
		_g_object_unref0 (aURIReq);
#line 441 "../src/window.vala"
		__vala_WebKitNavigationAction_free0 (aNavAction);
#line 441 "../src/window.vala"
		_g_object_unref0 (aNavDecision);
#line 2627 "window.c"
	}
#line 500 "../src/window.vala"
	bookworm_app_app_window_isWebViewRequestCompleted = TRUE;
#line 501 "../src/window.vala"
	result = TRUE;
#line 501 "../src/window.vala"
	return result;
#line 2635 "window.c"
}

static gboolean
___lambda61__webkit_web_view_decide_policy (WebKitWebView* _sender,
                                            WebKitPolicyDecision* decision,
                                            WebKitPolicyDecisionType type,
                                            gpointer self)
{
	gboolean result;
	result = __lambda61_ (decision, type);
#line 432 "../src/window.vala"
	return result;
#line 2648 "window.c"
}

static void
__lambda62_ (void)
{
#line 506 "../src/window.vala"
	bookworm_app_app_window_handleLibraryPageButtons ("NEXT_PAGE", TRUE);
#line 2656 "window.c"
}

static void
___lambda62__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 505 "../src/window.vala"
	__lambda62_ ();
#line 2665 "window.c"
}

static void
__lambda63_ (void)
{
#line 509 "../src/window.vala"
	bookworm_app_app_window_handleLibraryPageButtons ("PREV_PAGE", TRUE);
#line 2673 "window.c"
}

static void
___lambda63__gtk_button_clicked (GtkButton* _sender,
                                 gpointer self)
{
#line 508 "../src/window.vala"
	__lambda63_ ();
#line 2682 "window.c"
}

GtkBox*
bookworm_app_app_window_createBoookwormUI (void)
{
	Block20Data* _data20_;
	BookwormAppSettings* _tmp0_;
	GtkFlowBox* _tmp1_;
	GtkFlowBox* _tmp2_;
	GtkFlowBox* _tmp3_;
	GtkFlowBox* _tmp4_;
	GtkFlowBox* _tmp5_;
	GtkScrolledWindow* _tmp6_;
	GtkScrolledWindow* _tmp7_;
	GtkScrolledWindow* _tmp8_;
	GtkFlowBox* _tmp9_;
	GtkListStore* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkTreeView* _tmp12_;
	GtkCellRendererPixbuf* selection_cell_pix = NULL;
	GtkCellRendererPixbuf* _tmp13_;
	GtkCellRendererText* non_editable_cell_txt = NULL;
	GtkCellRendererText* _tmp14_;
	GtkCellRendererText* title_cell_txt = NULL;
	GtkCellRendererText* _tmp15_;
	GtkCellRendererText* author_cell_txt = NULL;
	GtkCellRendererText* _tmp16_;
	GtkCellRendererPixbuf* rating_cell_pix = NULL;
	GtkCellRendererPixbuf* _tmp17_;
	GtkCellRendererText* tags_cell_txt = NULL;
	GtkCellRendererText* _tmp18_;
	GtkTreeView* _tmp19_;
	GtkTreeView* _tmp20_;
	GtkTreeView* _tmp21_;
	GtkTreeView* _tmp22_;
	GtkTreeView* _tmp23_;
	GtkTreeView* _tmp24_;
	GtkScrolledWindow* _tmp25_;
	GtkScrolledWindow* _tmp26_;
	GtkScrolledWindow* _tmp27_;
	GtkTreeView* _tmp28_;
	GtkBox* library_view_box = NULL;
	GtkBox* _tmp29_;
	GtkScrolledWindow* _tmp30_;
	GtkScrolledWindow* _tmp31_;
	GtkButton* select_book_button = NULL;
	GtkButton* _tmp32_;
	GtkImage* _tmp33_;
	GtkButton* add_book_button = NULL;
	GtkButton* _tmp34_;
	GtkImage* _tmp35_;
	GtkButton* _tmp36_;
	GtkButton* _tmp37_;
	GtkImage* _tmp38_;
	GtkButton* _tmp39_;
	GtkButton* _tmp40_;
	GtkButton* _tmp41_;
	GtkBox* library_page_switcher_box = NULL;
	GtkBox* _tmp42_;
	GtkButton* _tmp43_;
	GtkButton* _tmp44_;
	GtkImage* _tmp45_;
	GtkButton* _tmp46_;
	GtkButton* _tmp47_;
	GtkButton* _tmp48_;
	GtkButton* _tmp49_;
	GtkButton* _tmp50_;
	GtkButton* _tmp51_;
	GtkImage* _tmp52_;
	GtkButton* _tmp53_;
	GtkButton* _tmp54_;
	GtkButton* _tmp55_;
	GtkProgressBar* _tmp56_;
	GtkProgressBar* _tmp57_;
	GtkProgressBar* _tmp58_;
	GtkActionBar* add_remove_footer_box = NULL;
	GtkActionBar* _tmp59_;
	GtkButton* _tmp60_;
	GtkProgressBar* _tmp61_;
	GtkInfoBar* _tmp62_;
	GtkLabel* _tmp63_;
	GtkContainer* infobarContent = NULL;
	GtkInfoBar* _tmp64_;
	GtkContainer* _tmp65_;
	GtkContainer* _tmp66_;
	GtkInfoBar* _tmp67_;
	GtkLabel* _tmp68_;
	GtkInfoBar* _tmp69_;
	GtkInfoBar* _tmp70_;
	GtkInfoBar* _tmp71_;
	GtkBox* _tmp72_;
	GtkBox* _tmp73_;
	GtkBox* _tmp74_;
	GtkBox* _tmp75_;
	WebKitSettings* _tmp76_;
	WebKitSettings* _tmp77_;
	WebKitSettings* _tmp78_;
	WebKitSettings* _tmp79_;
	WebKitSettings* _tmp80_;
	WebKitWebView* _tmp81_;
	WebKitWebView* _tmp82_;
	BookwormAppSettings* _tmp83_;
	BookwormAppSettings* _tmp84_;
	gdouble _tmp85_;
	gdouble _tmp86_;
	WebKitSettings* _tmp87_;
	WebKitSettings* _tmp88_;
	BookwormAppSettings* _tmp89_;
	gint _tmp90_;
	gint _tmp91_;
	WebKitSettings* _tmp92_;
	BookwormAppSettings* _tmp93_;
	const gchar* _tmp94_;
	const gchar* _tmp95_;
	GtkButton* _tmp96_;
	GtkButton* _tmp97_;
	GtkImage* _tmp98_;
	GtkButton* _tmp99_;
	GtkButton* _tmp100_;
	GtkButton* _tmp101_;
	GtkImage* _tmp102_;
	GtkButton* _tmp103_;
	GtkAdjustment* _tmp104_;
	GtkAdjustment* _tmp105_;
	GtkScale* _tmp106_;
	GtkScale* _tmp107_;
	GtkScale* _tmp108_;
	GtkScale* _tmp109_;
	GtkActionBar* _tmp110_;
	GtkButton* _tmp111_;
	GtkScale* _tmp112_;
	GtkButton* _tmp113_;
	GtkBox* _tmp114_;
	GtkBox* _tmp115_;
	GtkBox* _tmp116_;
	WebKitWebView* _tmp117_;
	GtkBox* _tmp118_;
	GtkBox* main_ui_box = NULL;
	GtkBox* _tmp119_;
	GtkInfoBar* _tmp120_;
	GtkBox* _tmp121_;
	GtkBox* _tmp122_;
	GtkBox* _tmp123_;
	GtkBox* _tmp124_;
	GtkTreeView* _tmp125_;
	GtkTreeView* _tmp126_;
	GtkButton* _tmp127_;
	GtkButton* _tmp128_;
	GtkScale* _tmp129_;
	GtkButton* _tmp130_;
	WebKitWebView* _tmp131_;
	WebKitWebView* _tmp132_;
	GtkButton* _tmp133_;
	GtkButton* _tmp134_;
	GtkBox* result;
#line 50 "../src/window.vala"
	_data20_ = g_slice_new0 (Block20Data);
#line 50 "../src/window.vala"
	_data20_->_ref_count_ = 1;
#line 51 "../src/window.vala"
	g_info ("window.vala:51: [START] [FUNCTION:createBoookwormUI]");
#line 52 "../src/window.vala"
	_tmp0_ = bookworm_app_settings_get_instance ();
#line 52 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_settings);
#line 52 "../src/window.vala"
	bookworm_app_app_window_settings = _tmp0_;
#line 55 "../src/window.vala"
	_tmp1_ = (GtkFlowBox*) gtk_flow_box_new ();
#line 55 "../src/window.vala"
	g_object_ref_sink (_tmp1_);
#line 55 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_library_grid);
#line 55 "../src/window.vala"
	bookworm_app_app_window_library_grid = _tmp1_;
#line 56 "../src/window.vala"
	_tmp2_ = bookworm_app_app_window_library_grid;
#line 56 "../src/window.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp2_, (guint) BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 57 "../src/window.vala"
	_tmp3_ = bookworm_app_app_window_library_grid;
#line 57 "../src/window.vala"
	gtk_flow_box_set_column_spacing (_tmp3_, (guint) BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 58 "../src/window.vala"
	_tmp4_ = bookworm_app_app_window_library_grid;
#line 58 "../src/window.vala"
	gtk_flow_box_set_row_spacing (_tmp4_, (guint) BOOKWORM_APP_CONSTANTS_SPACING_WIDGETS);
#line 59 "../src/window.vala"
	_tmp5_ = bookworm_app_app_window_library_grid;
#line 59 "../src/window.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_START);
#line 61 "../src/window.vala"
	_tmp6_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 61 "../src/window.vala"
	g_object_ref_sink (_tmp6_);
#line 61 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_library_grid_scroll);
#line 61 "../src/window.vala"
	bookworm_app_app_window_library_grid_scroll = _tmp6_;
#line 62 "../src/window.vala"
	_tmp7_ = bookworm_app_app_window_library_grid_scroll;
#line 62 "../src/window.vala"
	gtk_scrolled_window_set_policy (_tmp7_, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 63 "../src/window.vala"
	_tmp8_ = bookworm_app_app_window_library_grid_scroll;
#line 63 "../src/window.vala"
	_tmp9_ = bookworm_app_app_window_library_grid;
#line 63 "../src/window.vala"
	gtk_container_add ((GtkContainer*) _tmp8_, (GtkWidget*) _tmp9_);
#line 66 "../src/window.vala"
	_tmp10_ = gtk_list_store_new (8, gdk_pixbuf_get_type (), G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, gdk_pixbuf_get_type (), G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING, -1);
#line 66 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_library_table_liststore);
#line 66 "../src/window.vala"
	bookworm_app_app_window_library_table_liststore = _tmp10_;
#line 76 "../src/window.vala"
	_tmp11_ = (GtkTreeView*) gtk_tree_view_new ();
#line 76 "../src/window.vala"
	g_object_ref_sink (_tmp11_);
#line 76 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_library_table_treeview);
#line 76 "../src/window.vala"
	bookworm_app_app_window_library_table_treeview = _tmp11_;
#line 77 "../src/window.vala"
	_tmp12_ = bookworm_app_app_window_library_table_treeview;
#line 77 "../src/window.vala"
	gtk_tree_view_set_activate_on_single_click (_tmp12_, TRUE);
#line 79 "../src/window.vala"
	_tmp13_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 79 "../src/window.vala"
	g_object_ref_sink (_tmp13_);
#line 79 "../src/window.vala"
	selection_cell_pix = _tmp13_;
#line 80 "../src/window.vala"
	_tmp14_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 80 "../src/window.vala"
	g_object_ref_sink (_tmp14_);
#line 80 "../src/window.vala"
	non_editable_cell_txt = _tmp14_;
#line 81 "../src/window.vala"
	_tmp15_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 81 "../src/window.vala"
	g_object_ref_sink (_tmp15_);
#line 81 "../src/window.vala"
	title_cell_txt = _tmp15_;
#line 82 "../src/window.vala"
	g_object_set (title_cell_txt, "editable", TRUE, NULL);
#line 83 "../src/window.vala"
	_tmp16_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 83 "../src/window.vala"
	g_object_ref_sink (_tmp16_);
#line 83 "../src/window.vala"
	author_cell_txt = _tmp16_;
#line 84 "../src/window.vala"
	g_object_set (author_cell_txt, "editable", TRUE, NULL);
#line 85 "../src/window.vala"
	_tmp17_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
#line 85 "../src/window.vala"
	g_object_ref_sink (_tmp17_);
#line 85 "../src/window.vala"
	rating_cell_pix = _tmp17_;
#line 86 "../src/window.vala"
	_tmp18_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
#line 86 "../src/window.vala"
	g_object_ref_sink (_tmp18_);
#line 86 "../src/window.vala"
	tags_cell_txt = _tmp18_;
#line 87 "../src/window.vala"
	g_object_set (tags_cell_txt, "editable", TRUE, NULL);
#line 89 "../src/window.vala"
	_tmp19_ = bookworm_app_app_window_library_table_treeview;
#line 89 "../src/window.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp19_, -1, " ", (GtkCellRenderer*) selection_cell_pix, "pixbuf", 0, NULL);
#line 90 "../src/window.vala"
	_tmp20_ = bookworm_app_app_window_library_table_treeview;
#line 90 "../src/window.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp20_, -1, BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_TITLE, (GtkCellRenderer*) title_cell_txt, "text", 1, NULL);
#line 91 "../src/window.vala"
	_tmp21_ = bookworm_app_app_window_library_table_treeview;
#line 91 "../src/window.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp21_, -1, BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_AUTHOR, (GtkCellRenderer*) author_cell_txt, "text", 2, NULL);
#line 92 "../src/window.vala"
	_tmp22_ = bookworm_app_app_window_library_table_treeview;
#line 92 "../src/window.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp22_, -1, BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_MODIFIED_DATE, (GtkCellRenderer*) non_editable_cell_txt, "text", 3, NULL);
#line 93 "../src/window.vala"
	_tmp23_ = bookworm_app_app_window_library_table_treeview;
#line 93 "../src/window.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp23_, -1, BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_RATING, (GtkCellRenderer*) rating_cell_pix, "pixbuf", 4, NULL);
#line 94 "../src/window.vala"
	_tmp24_ = bookworm_app_app_window_library_table_treeview;
#line 94 "../src/window.vala"
	gtk_tree_view_insert_column_with_attributes (_tmp24_, -1, BOOKWORM_APP_CONSTANTS_TEXT_FOR_LIST_VIEW_COLUMN_NAME_TAGS, (GtkCellRenderer*) tags_cell_txt, "text", 5, NULL);
#line 96 "../src/window.vala"
	_tmp25_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
#line 96 "../src/window.vala"
	g_object_ref_sink (_tmp25_);
#line 96 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_library_list_scroll);
#line 96 "../src/window.vala"
	bookworm_app_app_window_library_list_scroll = _tmp25_;
#line 97 "../src/window.vala"
	_tmp26_ = bookworm_app_app_window_library_list_scroll;
#line 97 "../src/window.vala"
	gtk_scrolled_window_set_policy (_tmp26_, GTK_POLICY_AUTOMATIC, GTK_POLICY_AUTOMATIC);
#line 98 "../src/window.vala"
	_tmp27_ = bookworm_app_app_window_library_list_scroll;
#line 98 "../src/window.vala"
	_tmp28_ = bookworm_app_app_window_library_table_treeview;
#line 98 "../src/window.vala"
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
#line 101 "../src/window.vala"
	_tmp29_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 101 "../src/window.vala"
	g_object_ref_sink (_tmp29_);
#line 101 "../src/window.vala"
	library_view_box = _tmp29_;
#line 102 "../src/window.vala"
	gtk_container_set_border_width ((GtkContainer*) library_view_box, (guint) 0);
#line 103 "../src/window.vala"
	_tmp30_ = bookworm_app_app_window_library_grid_scroll;
#line 103 "../src/window.vala"
	gtk_box_pack_start (library_view_box, (GtkWidget*) _tmp30_, TRUE, TRUE, (guint) 0);
#line 104 "../src/window.vala"
	_tmp31_ = bookworm_app_app_window_library_list_scroll;
#line 104 "../src/window.vala"
	gtk_box_pack_start (library_view_box, (GtkWidget*) _tmp31_, TRUE, TRUE, (guint) 0);
#line 107 "../src/window.vala"
	_tmp32_ = (GtkButton*) gtk_button_new ();
#line 107 "../src/window.vala"
	g_object_ref_sink (_tmp32_);
#line 107 "../src/window.vala"
	select_book_button = _tmp32_;
#line 108 "../src/window.vala"
	_tmp33_ = bookworm_app_bookworm_select_book_image;
#line 108 "../src/window.vala"
	gtk_button_set_image (select_book_button, (GtkWidget*) _tmp33_);
#line 109 "../src/window.vala"
	gtk_button_set_relief (select_book_button, GTK_RELIEF_NONE);
#line 110 "../src/window.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) select_book_button, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_SELECT_BOOK);
#line 113 "../src/window.vala"
	_tmp34_ = (GtkButton*) gtk_button_new ();
#line 113 "../src/window.vala"
	g_object_ref_sink (_tmp34_);
#line 113 "../src/window.vala"
	add_book_button = _tmp34_;
#line 114 "../src/window.vala"
	_tmp35_ = bookworm_app_bookworm_add_book_image;
#line 114 "../src/window.vala"
	gtk_button_set_image (add_book_button, (GtkWidget*) _tmp35_);
#line 115 "../src/window.vala"
	gtk_button_set_relief (add_book_button, GTK_RELIEF_NONE);
#line 116 "../src/window.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) add_book_button, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_ADD_BOOK);
#line 119 "../src/window.vala"
	_tmp36_ = (GtkButton*) gtk_button_new ();
#line 119 "../src/window.vala"
	g_object_ref_sink (_tmp36_);
#line 119 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_remove_book_button);
#line 119 "../src/window.vala"
	bookworm_app_app_window_remove_book_button = _tmp36_;
#line 120 "../src/window.vala"
	_tmp37_ = bookworm_app_app_window_remove_book_button;
#line 120 "../src/window.vala"
	_tmp38_ = bookworm_app_bookworm_remove_book_image;
#line 120 "../src/window.vala"
	gtk_button_set_image (_tmp37_, (GtkWidget*) _tmp38_);
#line 121 "../src/window.vala"
	_tmp39_ = bookworm_app_app_window_remove_book_button;
#line 121 "../src/window.vala"
	gtk_button_set_relief (_tmp39_, GTK_RELIEF_NONE);
#line 123 "../src/window.vala"
	_tmp40_ = bookworm_app_app_window_remove_book_button;
#line 123 "../src/window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp40_, FALSE);
#line 124 "../src/window.vala"
	_tmp41_ = bookworm_app_app_window_remove_book_button;
#line 124 "../src/window.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp41_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_REMOVE_BOOK_UNSELECTED);
#line 127 "../src/window.vala"
	_tmp42_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
#line 127 "../src/window.vala"
	g_object_ref_sink (_tmp42_);
#line 127 "../src/window.vala"
	library_page_switcher_box = _tmp42_;
#line 128 "../src/window.vala"
	gtk_container_set_border_width ((GtkContainer*) library_page_switcher_box, (guint) 0);
#line 130 "../src/window.vala"
	_tmp43_ = (GtkButton*) gtk_button_new ();
#line 130 "../src/window.vala"
	g_object_ref_sink (_tmp43_);
#line 130 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_page_button_prev);
#line 130 "../src/window.vala"
	bookworm_app_app_window_page_button_prev = _tmp43_;
#line 131 "../src/window.vala"
	_tmp44_ = bookworm_app_app_window_page_button_prev;
#line 131 "../src/window.vala"
	_tmp45_ = bookworm_app_bookworm_back_page_image;
#line 131 "../src/window.vala"
	gtk_button_set_image (_tmp44_, (GtkWidget*) _tmp45_);
#line 132 "../src/window.vala"
	_tmp46_ = bookworm_app_app_window_page_button_prev;
#line 132 "../src/window.vala"
	gtk_button_set_relief (_tmp46_, GTK_RELIEF_NONE);
#line 133 "../src/window.vala"
	_tmp47_ = bookworm_app_app_window_page_button_prev;
#line 133 "../src/window.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp47_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_PREV_PAGE);
#line 134 "../src/window.vala"
	_tmp48_ = bookworm_app_app_window_page_button_prev;
#line 134 "../src/window.vala"
	gtk_box_pack_start (library_page_switcher_box, (GtkWidget*) _tmp48_, TRUE, TRUE, (guint) 0);
#line 135 "../src/window.vala"
	_tmp49_ = bookworm_app_app_window_page_button_prev;
#line 135 "../src/window.vala"
	gtk_widget_set_sensitive ((GtkWidget*) _tmp49_, FALSE);
#line 137 "../src/window.vala"
	_tmp50_ = (GtkButton*) gtk_button_new ();
#line 137 "../src/window.vala"
	g_object_ref_sink (_tmp50_);
#line 137 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_page_button_next);
#line 137 "../src/window.vala"
	bookworm_app_app_window_page_button_next = _tmp50_;
#line 138 "../src/window.vala"
	_tmp51_ = bookworm_app_app_window_page_button_next;
#line 138 "../src/window.vala"
	_tmp52_ = bookworm_app_bookworm_forward_page_image;
#line 138 "../src/window.vala"
	gtk_button_set_image (_tmp51_, (GtkWidget*) _tmp52_);
#line 139 "../src/window.vala"
	_tmp53_ = bookworm_app_app_window_page_button_next;
#line 139 "../src/window.vala"
	gtk_button_set_relief (_tmp53_, GTK_RELIEF_NONE);
#line 140 "../src/window.vala"
	_tmp54_ = bookworm_app_app_window_page_button_next;
#line 140 "../src/window.vala"
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp54_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_NEXT_PAGE);
#line 141 "../src/window.vala"
	_tmp55_ = bookworm_app_app_window_page_button_next;
#line 141 "../src/window.vala"
	gtk_box_pack_start (library_page_switcher_box, (GtkWidget*) _tmp55_, TRUE, TRUE, (guint) 0);
#line 144 "../src/window.vala"
	_tmp56_ = (GtkProgressBar*) gtk_progress_bar_new ();
#line 144 "../src/window.vala"
	g_object_ref_sink (_tmp56_);
#line 144 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_bookAdditionBar);
#line 144 "../src/window.vala"
	bookworm_app_app_window_bookAdditionBar = _tmp56_;
#line 145 "../src/window.vala"
	_tmp57_ = bookworm_app_app_window_bookAdditionBar;
#line 145 "../src/window.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp57_, GTK_ALIGN_CENTER);
#line 146 "../src/window.vala"
	_tmp58_ = bookworm_app_app_window_bookAdditionBar;
#line 146 "../src/window.vala"
	gtk_progress_bar_set_show_text (_tmp58_, TRUE);
#line 149 "../src/window.vala"
	_tmp59_ = (GtkActionBar*) gtk_action_bar_new ();
#line 149 "../src/window.vala"
	g_object_ref_sink (_tmp59_);
#line 149 "../src/window.vala"
	add_remove_footer_box = _tmp59_;
#line 150 "../src/window.vala"
	gtk_action_bar_pack_start (add_remove_footer_box, (GtkWidget*) select_book_button);
#line 151 "../src/window.vala"
	gtk_action_bar_pack_start (add_remove_footer_box, (GtkWidget*) add_book_button);
#line 152 "../src/window.vala"
	_tmp60_ = bookworm_app_app_window_remove_book_button;
#line 152 "../src/window.vala"
	gtk_action_bar_pack_start (add_remove_footer_box, (GtkWidget*) _tmp60_);
#line 153 "../src/window.vala"
	_tmp61_ = bookworm_app_app_window_bookAdditionBar;
#line 153 "../src/window.vala"
	gtk_action_bar_pack_start (add_remove_footer_box, (GtkWidget*) _tmp61_);
#line 154 "../src/window.vala"
	gtk_action_bar_pack_end (add_remove_footer_box, (GtkWidget*) library_page_switcher_box);
#line 157 "../src/window.vala"
	_tmp62_ = (GtkInfoBar*) gtk_info_bar_new ();
#line 157 "../src/window.vala"
	g_object_ref_sink (_tmp62_);
#line 157 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_infobar);
#line 157 "../src/window.vala"
	bookworm_app_app_window_infobar = _tmp62_;
#line 158 "../src/window.vala"
	_tmp63_ = (GtkLabel*) gtk_label_new ("");
#line 158 "../src/window.vala"
	g_object_ref_sink (_tmp63_);
#line 158 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_infobarLabel);
#line 158 "../src/window.vala"
	bookworm_app_app_window_infobarLabel = _tmp63_;
#line 159 "../src/window.vala"
	_tmp64_ = bookworm_app_app_window_infobar;
#line 159 "../src/window.vala"
	_tmp65_ = gtk_info_bar_get_content_area (_tmp64_);
#line 159 "../src/window.vala"
	_tmp66_ = _g_object_ref0 (_tmp65_);
#line 159 "../src/window.vala"
	infobarContent = _tmp66_;
#line 160 "../src/window.vala"
	_tmp67_ = bookworm_app_app_window_infobar;
#line 160 "../src/window.vala"
	gtk_info_bar_set_message_type (_tmp67_, GTK_MESSAGE_INFO);
#line 161 "../src/window.vala"
	_tmp68_ = bookworm_app_app_window_infobarLabel;
#line 161 "../src/window.vala"
	gtk_container_add (infobarContent, (GtkWidget*) _tmp68_);
#line 162 "../src/window.vala"
	_tmp69_ = bookworm_app_app_window_infobar;
#line 162 "../src/window.vala"
	gtk_info_bar_set_show_close_button (_tmp69_, TRUE);
#line 163 "../src/window.vala"
	_tmp70_ = bookworm_app_app_window_infobar;
#line 163 "../src/window.vala"
	g_signal_connect (_tmp70_, "response", (GCallback) _bookworm_app_app_window_on_info_bar_closed_gtk_info_bar_response, NULL);
#line 164 "../src/window.vala"
	_tmp71_ = bookworm_app_app_window_infobar;
#line 164 "../src/window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp71_);
#line 167 "../src/window.vala"
	_tmp72_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 167 "../src/window.vala"
	g_object_ref_sink (_tmp72_);
#line 167 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_bookLibrary_ui_box);
#line 167 "../src/window.vala"
	bookworm_app_app_window_bookLibrary_ui_box = _tmp72_;
#line 168 "../src/window.vala"
	_tmp73_ = bookworm_app_app_window_bookLibrary_ui_box;
#line 168 "../src/window.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp73_, (guint) 0);
#line 169 "../src/window.vala"
	_tmp74_ = bookworm_app_app_window_bookLibrary_ui_box;
#line 169 "../src/window.vala"
	gtk_box_pack_start (_tmp74_, (GtkWidget*) library_view_box, TRUE, TRUE, (guint) 0);
#line 170 "../src/window.vala"
	_tmp75_ = bookworm_app_app_window_bookLibrary_ui_box;
#line 170 "../src/window.vala"
	gtk_box_pack_start (_tmp75_, (GtkWidget*) add_remove_footer_box, FALSE, TRUE, (guint) 0);
#line 173 "../src/window.vala"
	_tmp76_ = webkit_settings_new ();
#line 173 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_webkitSettings);
#line 173 "../src/window.vala"
	bookworm_app_app_window_webkitSettings = _tmp76_;
#line 174 "../src/window.vala"
	_tmp77_ = bookworm_app_app_window_webkitSettings;
#line 174 "../src/window.vala"
	webkit_settings_set_allow_file_access_from_file_urls (_tmp77_, TRUE);
#line 175 "../src/window.vala"
	_tmp78_ = bookworm_app_app_window_webkitSettings;
#line 175 "../src/window.vala"
	webkit_settings_set_allow_universal_access_from_file_urls (_tmp78_, TRUE);
#line 176 "../src/window.vala"
	_tmp79_ = bookworm_app_app_window_webkitSettings;
#line 176 "../src/window.vala"
	webkit_settings_set_auto_load_images (_tmp79_, TRUE);
#line 177 "../src/window.vala"
	_tmp80_ = bookworm_app_app_window_webkitSettings;
#line 177 "../src/window.vala"
	_tmp81_ = (WebKitWebView*) webkit_web_view_new_with_settings (_tmp80_);
#line 177 "../src/window.vala"
	g_object_ref_sink (_tmp81_);
#line 177 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_aWebView);
#line 177 "../src/window.vala"
	bookworm_app_app_window_aWebView = _tmp81_;
#line 178 "../src/window.vala"
	_tmp82_ = bookworm_app_app_window_aWebView;
#line 178 "../src/window.vala"
	_tmp83_ = bookworm_app_settings_get_instance ();
#line 178 "../src/window.vala"
	_tmp84_ = _tmp83_;
#line 178 "../src/window.vala"
	_tmp85_ = bookworm_app_settings_get_zoom_level (_tmp84_);
#line 178 "../src/window.vala"
	_tmp86_ = _tmp85_;
#line 178 "../src/window.vala"
	webkit_web_view_set_zoom_level (_tmp82_, _tmp86_);
#line 178 "../src/window.vala"
	_g_object_unref0 (_tmp84_);
#line 179 "../src/window.vala"
	_tmp87_ = bookworm_app_app_window_webkitSettings;
#line 179 "../src/window.vala"
	webkit_settings_set_enable_javascript (_tmp87_, TRUE);
#line 182 "../src/window.vala"
	_tmp88_ = bookworm_app_app_window_webkitSettings;
#line 182 "../src/window.vala"
	_tmp89_ = bookworm_app_bookworm_settings;
#line 182 "../src/window.vala"
	_tmp90_ = bookworm_app_settings_get_reading_font_size (_tmp89_);
#line 182 "../src/window.vala"
	_tmp91_ = _tmp90_;
#line 182 "../src/window.vala"
	webkit_settings_set_default_font_size (_tmp88_, (guint32) _tmp91_);
#line 183 "../src/window.vala"
	_tmp92_ = bookworm_app_app_window_webkitSettings;
#line 183 "../src/window.vala"
	_tmp93_ = bookworm_app_bookworm_settings;
#line 183 "../src/window.vala"
	_tmp94_ = bookworm_app_settings_get_reading_font_name (_tmp93_);
#line 183 "../src/window.vala"
	_tmp95_ = _tmp94_;
#line 183 "../src/window.vala"
	webkit_settings_set_default_font_family (_tmp92_, _tmp95_);
#line 186 "../src/window.vala"
	_tmp96_ = (GtkButton*) gtk_button_new ();
#line 186 "../src/window.vala"
	g_object_ref_sink (_tmp96_);
#line 186 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_back_button);
#line 186 "../src/window.vala"
	bookworm_app_app_window_back_button = _tmp96_;
#line 187 "../src/window.vala"
	_tmp97_ = bookworm_app_app_window_back_button;
#line 187 "../src/window.vala"
	_tmp98_ = bookworm_app_bookworm_back_button_image;
#line 187 "../src/window.vala"
	gtk_button_set_image (_tmp97_, (GtkWidget*) _tmp98_);
#line 188 "../src/window.vala"
	_tmp99_ = bookworm_app_app_window_back_button;
#line 188 "../src/window.vala"
	gtk_button_set_relief (_tmp99_, GTK_RELIEF_NONE);
#line 191 "../src/window.vala"
	_tmp100_ = (GtkButton*) gtk_button_new ();
#line 191 "../src/window.vala"
	g_object_ref_sink (_tmp100_);
#line 191 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_forward_button);
#line 191 "../src/window.vala"
	bookworm_app_app_window_forward_button = _tmp100_;
#line 192 "../src/window.vala"
	_tmp101_ = bookworm_app_app_window_forward_button;
#line 192 "../src/window.vala"
	_tmp102_ = bookworm_app_bookworm_forward_button_image;
#line 192 "../src/window.vala"
	gtk_button_set_image (_tmp101_, (GtkWidget*) _tmp102_);
#line 193 "../src/window.vala"
	_tmp103_ = bookworm_app_app_window_forward_button;
#line 193 "../src/window.vala"
	gtk_button_set_relief (_tmp103_, GTK_RELIEF_NONE);
#line 196 "../src/window.vala"
	_tmp104_ = gtk_adjustment_new ((gdouble) 0, (gdouble) 1, (gdouble) 100, (gdouble) 1, (gdouble) 0, (gdouble) 0);
#line 196 "../src/window.vala"
	g_object_ref_sink (_tmp104_);
#line 196 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_pageAdjustment);
#line 196 "../src/window.vala"
	bookworm_app_app_window_pageAdjustment = _tmp104_;
#line 197 "../src/window.vala"
	_tmp105_ = bookworm_app_app_window_pageAdjustment;
#line 197 "../src/window.vala"
	_tmp106_ = (GtkScale*) gtk_scale_new (GTK_ORIENTATION_HORIZONTAL, _tmp105_);
#line 197 "../src/window.vala"
	g_object_ref_sink (_tmp106_);
#line 197 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_pageSlider);
#line 197 "../src/window.vala"
	bookworm_app_app_window_pageSlider = _tmp106_;
#line 198 "../src/window.vala"
	_tmp107_ = bookworm_app_app_window_pageSlider;
#line 198 "../src/window.vala"
	gtk_scale_set_digits (_tmp107_, 0);
#line 199 "../src/window.vala"
	_tmp108_ = bookworm_app_app_window_pageSlider;
#line 199 "../src/window.vala"
	gtk_widget_set_valign ((GtkWidget*) _tmp108_, GTK_ALIGN_START);
#line 200 "../src/window.vala"
	_tmp109_ = bookworm_app_app_window_pageSlider;
#line 200 "../src/window.vala"
	gtk_widget_set_hexpand ((GtkWidget*) _tmp109_, TRUE);
#line 203 "../src/window.vala"
	_tmp110_ = (GtkActionBar*) gtk_action_bar_new ();
#line 203 "../src/window.vala"
	g_object_ref_sink (_tmp110_);
#line 203 "../src/window.vala"
	_data20_->book_reading_footer_box = _tmp110_;
#line 204 "../src/window.vala"
	_tmp111_ = bookworm_app_app_window_back_button;
#line 204 "../src/window.vala"
	gtk_action_bar_pack_start (_data20_->book_reading_footer_box, (GtkWidget*) _tmp111_);
#line 205 "../src/window.vala"
	_tmp112_ = bookworm_app_app_window_pageSlider;
#line 205 "../src/window.vala"
	gtk_action_bar_pack_start (_data20_->book_reading_footer_box, (GtkWidget*) _tmp112_);
#line 206 "../src/window.vala"
	_tmp113_ = bookworm_app_app_window_forward_button;
#line 206 "../src/window.vala"
	gtk_action_bar_pack_end (_data20_->book_reading_footer_box, (GtkWidget*) _tmp113_);
#line 209 "../src/window.vala"
	_tmp114_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 209 "../src/window.vala"
	g_object_ref_sink (_tmp114_);
#line 209 "../src/window.vala"
	_g_object_unref0 (bookworm_app_app_window_bookReading_ui_box);
#line 209 "../src/window.vala"
	bookworm_app_app_window_bookReading_ui_box = _tmp114_;
#line 210 "../src/window.vala"
	_tmp115_ = bookworm_app_app_window_bookReading_ui_box;
#line 210 "../src/window.vala"
	gtk_container_set_border_width ((GtkContainer*) _tmp115_, (guint) 0);
#line 211 "../src/window.vala"
	_tmp116_ = bookworm_app_app_window_bookReading_ui_box;
#line 211 "../src/window.vala"
	_tmp117_ = bookworm_app_app_window_aWebView;
#line 211 "../src/window.vala"
	gtk_box_pack_start (_tmp116_, (GtkWidget*) _tmp117_, TRUE, TRUE, (guint) 0);
#line 212 "../src/window.vala"
	_tmp118_ = bookworm_app_app_window_bookReading_ui_box;
#line 212 "../src/window.vala"
	gtk_box_pack_start (_tmp118_, (GtkWidget*) _data20_->book_reading_footer_box, FALSE, TRUE, (guint) 0);
#line 215 "../src/window.vala"
	_tmp119_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
#line 215 "../src/window.vala"
	g_object_ref_sink (_tmp119_);
#line 215 "../src/window.vala"
	main_ui_box = _tmp119_;
#line 216 "../src/window.vala"
	gtk_container_set_border_width ((GtkContainer*) main_ui_box, (guint) 0);
#line 217 "../src/window.vala"
	_tmp120_ = bookworm_app_app_window_infobar;
#line 217 "../src/window.vala"
	gtk_box_pack_start (main_ui_box, (GtkWidget*) _tmp120_, FALSE, TRUE, (guint) 0);
#line 218 "../src/window.vala"
	_tmp121_ = bookworm_app_app_window_bookLibrary_ui_box;
#line 218 "../src/window.vala"
	gtk_box_pack_start (main_ui_box, (GtkWidget*) _tmp121_, TRUE, TRUE, (guint) 0);
#line 219 "../src/window.vala"
	_tmp122_ = bookworm_app_info_createBookInfo ();
#line 219 "../src/window.vala"
	_tmp123_ = _tmp122_;
#line 219 "../src/window.vala"
	gtk_box_pack_start (main_ui_box, (GtkWidget*) _tmp123_, TRUE, TRUE, (guint) 0);
#line 219 "../src/window.vala"
	_g_object_unref0 (_tmp123_);
#line 220 "../src/window.vala"
	_tmp124_ = bookworm_app_app_window_bookReading_ui_box;
#line 220 "../src/window.vala"
	gtk_box_pack_end (main_ui_box, (GtkWidget*) _tmp124_, TRUE, TRUE, (guint) 0);
#line 223 "../src/window.vala"
	_tmp125_ = bookworm_app_app_window_library_table_treeview;
#line 223 "../src/window.vala"
	g_signal_connect (_tmp125_, "row-activated", (GCallback) ___lambda45__gtk_tree_view_row_activated, NULL);
#line 244 "../src/window.vala"
	g_signal_connect (title_cell_txt, "edited", (GCallback) ___lambda46__gtk_cell_renderer_text_edited, NULL);
#line 247 "../src/window.vala"
	g_signal_connect (author_cell_txt, "edited", (GCallback) ___lambda47__gtk_cell_renderer_text_edited, NULL);
#line 250 "../src/window.vala"
	g_signal_connect (tags_cell_txt, "edited", (GCallback) ___lambda48__gtk_cell_renderer_text_edited, NULL);
#line 255 "../src/window.vala"
	_tmp126_ = bookworm_app_app_window_library_table_treeview;
#line 255 "../src/window.vala"
	g_signal_connect ((GtkWidget*) _tmp126_, "button-press-event", (GCallback) ___lambda49__gtk_widget_button_press_event, NULL);
#line 275 "../src/window.vala"
	_tmp127_ = bookworm_app_app_window_forward_button;
#line 275 "../src/window.vala"
	g_signal_connect (_tmp127_, "clicked", (GCallback) ___lambda50__gtk_button_clicked, NULL);
#line 286 "../src/window.vala"
	_tmp128_ = bookworm_app_app_window_back_button;
#line 286 "../src/window.vala"
	g_signal_connect (_tmp128_, "clicked", (GCallback) ___lambda51__gtk_button_clicked, NULL);
#line 297 "../src/window.vala"
	_tmp129_ = bookworm_app_app_window_pageSlider;
#line 297 "../src/window.vala"
	g_signal_connect ((GtkRange*) _tmp129_, "change-value", (GCallback) ___lambda52__gtk_range_change_value, NULL);
#line 318 "../src/window.vala"
	g_signal_connect (add_book_button, "clicked", (GCallback) ___lambda53__gtk_button_clicked, NULL);
#line 334 "../src/window.vala"
	g_signal_connect (select_book_button, "clicked", (GCallback) ___lambda54__gtk_button_clicked, NULL);
#line 370 "../src/window.vala"
	_tmp130_ = bookworm_app_app_window_remove_book_button;
#line 370 "../src/window.vala"
	g_signal_connect (_tmp130_, "clicked", (GCallback) ___lambda55__gtk_button_clicked, NULL);
#line 374 "../src/window.vala"
	_tmp131_ = bookworm_app_app_window_aWebView;
#line 374 "../src/window.vala"
	g_signal_connect_data (_tmp131_, "context-menu", (GCallback) ___lambda56__webkit_web_view_context_menu, block20_data_ref (_data20_), (GClosureNotify) block20_data_unref, 0);
#line 432 "../src/window.vala"
	_tmp132_ = bookworm_app_app_window_aWebView;
#line 432 "../src/window.vala"
	g_signal_connect (_tmp132_, "decide-policy", (GCallback) ___lambda61__webkit_web_view_decide_policy, NULL);
#line 505 "../src/window.vala"
	_tmp133_ = bookworm_app_app_window_page_button_next;
#line 505 "../src/window.vala"
	g_signal_connect (_tmp133_, "clicked", (GCallback) ___lambda62__gtk_button_clicked, NULL);
#line 508 "../src/window.vala"
	_tmp134_ = bookworm_app_app_window_page_button_prev;
#line 508 "../src/window.vala"
	g_signal_connect (_tmp134_, "clicked", (GCallback) ___lambda63__gtk_button_clicked, NULL);
#line 512 "../src/window.vala"
	g_info ("window.vala:512: [END] [FUNCTION:createBoookwormUI]");
#line 513 "../src/window.vala"
	result = main_ui_box;
#line 513 "../src/window.vala"
	_g_object_unref0 (infobarContent);
#line 513 "../src/window.vala"
	_g_object_unref0 (add_remove_footer_box);
#line 513 "../src/window.vala"
	_g_object_unref0 (library_page_switcher_box);
#line 513 "../src/window.vala"
	_g_object_unref0 (add_book_button);
#line 513 "../src/window.vala"
	_g_object_unref0 (select_book_button);
#line 513 "../src/window.vala"
	_g_object_unref0 (library_view_box);
#line 513 "../src/window.vala"
	_g_object_unref0 (tags_cell_txt);
#line 513 "../src/window.vala"
	_g_object_unref0 (rating_cell_pix);
#line 513 "../src/window.vala"
	_g_object_unref0 (author_cell_txt);
#line 513 "../src/window.vala"
	_g_object_unref0 (title_cell_txt);
#line 513 "../src/window.vala"
	_g_object_unref0 (non_editable_cell_txt);
#line 513 "../src/window.vala"
	_g_object_unref0 (selection_cell_pix);
#line 513 "../src/window.vala"
	block20_data_unref (_data20_);
#line 513 "../src/window.vala"
	_data20_ = NULL;
#line 513 "../src/window.vala"
	return result;
#line 3512 "window.c"
}

void
bookworm_app_app_window_handleLibraryPageButtons (const gchar* mode,
                                                  gboolean isPaginateRequired)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp5_ = FALSE;
#line 516 "../src/window.vala"
	g_return_if_fail (mode != NULL);
#line 517 "../src/window.vala"
	if (g_strcmp0 (mode, "NEXT_PAGE") == 0) {
#line 517 "../src/window.vala"
		_tmp0_ = isPaginateRequired;
#line 3527 "window.c"
	} else {
#line 517 "../src/window.vala"
		_tmp0_ = FALSE;
#line 3531 "window.c"
	}
#line 517 "../src/window.vala"
	if (_tmp0_) {
#line 3535 "window.c"
		GtkButton* _tmp1_;
		GeeArrayList* _tmp3_;
#line 519 "../src/window.vala"
		_tmp1_ = bookworm_app_app_window_page_button_prev;
#line 519 "../src/window.vala"
		if (!gtk_widget_get_sensitive ((GtkWidget*) _tmp1_)) {
#line 3542 "window.c"
			GtkButton* _tmp2_;
#line 520 "../src/window.vala"
			_tmp2_ = bookworm_app_app_window_page_button_prev;
#line 520 "../src/window.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp2_, TRUE);
#line 3548 "window.c"
		}
#line 523 "../src/window.vala"
		bookworm_app_bookworm_current_page_counter = bookworm_app_bookworm_current_page_counter + 1;
#line 524 "../src/window.vala"
		bookworm_app_library_paginateLibrary ("", "PAGINATED_SEARCH");
#line 526 "../src/window.vala"
		_tmp3_ = bookworm_app_bookworm_paginationlist;
#line 526 "../src/window.vala"
		if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp3_, "-1")) {
#line 3558 "window.c"
			GtkButton* _tmp4_;
#line 527 "../src/window.vala"
			_tmp4_ = bookworm_app_app_window_page_button_next;
#line 527 "../src/window.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
#line 3564 "window.c"
		}
	}
#line 530 "../src/window.vala"
	if (g_strcmp0 (mode, "PREV_PAGE") == 0) {
#line 530 "../src/window.vala"
		_tmp5_ = isPaginateRequired;
#line 3571 "window.c"
	} else {
#line 530 "../src/window.vala"
		_tmp5_ = FALSE;
#line 3575 "window.c"
	}
#line 530 "../src/window.vala"
	if (_tmp5_) {
#line 531 "../src/window.vala"
		if (bookworm_app_bookworm_current_page_counter > 0) {
#line 3581 "window.c"
			GtkButton* _tmp6_;
			GeeArrayList* _tmp8_;
#line 533 "../src/window.vala"
			_tmp6_ = bookworm_app_app_window_page_button_next;
#line 533 "../src/window.vala"
			if (!gtk_widget_get_sensitive ((GtkWidget*) _tmp6_)) {
#line 3588 "window.c"
				GtkButton* _tmp7_;
#line 534 "../src/window.vala"
				_tmp7_ = bookworm_app_app_window_page_button_next;
#line 534 "../src/window.vala"
				gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
#line 3594 "window.c"
			}
#line 537 "../src/window.vala"
			_tmp8_ = bookworm_app_bookworm_paginationlist;
#line 537 "../src/window.vala"
			if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp8_, "-1")) {
#line 3600 "window.c"
				GeeArrayList* _tmp9_;
#line 538 "../src/window.vala"
				_tmp9_ = bookworm_app_bookworm_paginationlist;
#line 538 "../src/window.vala"
				gee_abstract_collection_remove ((GeeAbstractCollection*) _tmp9_, "-1");
#line 3606 "window.c"
			}
#line 540 "../src/window.vala"
			bookworm_app_bookworm_current_page_counter = bookworm_app_bookworm_current_page_counter - 1;
#line 541 "../src/window.vala"
			bookworm_app_library_paginateLibrary ("", "PAGINATED_SEARCH");
#line 3612 "window.c"
		} else {
			GtkButton* _tmp10_;
#line 544 "../src/window.vala"
			_tmp10_ = bookworm_app_app_window_page_button_prev;
#line 544 "../src/window.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
#line 3619 "window.c"
		}
	}
#line 547 "../src/window.vala"
	if (!isPaginateRequired) {
#line 3624 "window.c"
		GeeArrayList* _tmp12_;
#line 548 "../src/window.vala"
		if (bookworm_app_bookworm_current_page_counter < 1) {
#line 3628 "window.c"
			GtkButton* _tmp11_;
#line 549 "../src/window.vala"
			_tmp11_ = bookworm_app_app_window_page_button_prev;
#line 549 "../src/window.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp11_, FALSE);
#line 3634 "window.c"
		}
#line 551 "../src/window.vala"
		_tmp12_ = bookworm_app_bookworm_paginationlist;
#line 551 "../src/window.vala"
		if (gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp12_, "-1")) {
#line 3640 "window.c"
			GtkButton* _tmp13_;
#line 552 "../src/window.vala"
			_tmp13_ = bookworm_app_app_window_page_button_next;
#line 552 "../src/window.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, FALSE);
#line 3646 "window.c"
		}
	}
}

static void
_vala_GtkTreePath_free (GtkTreePath* self)
{
#line 590 "../src/window.vala"
	g_boxed_free (gtk_tree_path_get_type (), self);
#line 3656 "window.c"
}

gboolean
bookworm_app_app_window_updateLibraryListViewData (const gchar* path,
                                                   const gchar* new_text,
                                                   gint column)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GtkTreeIter sortedIter = {0};
	GValue bookLocation = {0};
	GtkTreeModel* aTreeModel = NULL;
	GtkTreeView* _tmp12_;
	GtkTreeModel* _tmp13_;
	GtkTreeModel* _tmp14_;
	GtkTreePath* aTreePath = NULL;
	GtkTreePath* _tmp15_;
	GtkTreeModel* _tmp16_;
	GtkTreePath* _tmp17_;
	GtkTreeIter _tmp18_ = {0};
	GtkTreeModel* _tmp19_;
	GtkTreeIter _tmp20_;
	GValue _tmp21_ = {0};
	GtkTreeIter iter = {0};
	gchar* bookLocationforCurrentRow = NULL;
	gboolean iterExists = FALSE;
	GtkListStore* _tmp22_;
	GtkTreeIter _tmp23_ = {0};
	gboolean _tmp24_;
	gboolean result;
#line 557 "../src/window.vala"
	g_return_val_if_fail (path != NULL, FALSE);
#line 557 "../src/window.vala"
	g_return_val_if_fail (new_text != NULL, FALSE);
#line 558 "../src/window.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:updateLibraryListViewData] updating metadata in List" \
" View on row:", path, NULL);
#line 558 "../src/window.vala"
	_tmp1_ = _tmp0_;
#line 558 "../src/window.vala"
	_tmp2_ = g_strconcat (_tmp1_, " for change:", NULL);
#line 558 "../src/window.vala"
	_tmp3_ = _tmp2_;
#line 558 "../src/window.vala"
	_tmp4_ = g_strconcat (_tmp3_, new_text, NULL);
#line 558 "../src/window.vala"
	_tmp5_ = _tmp4_;
#line 558 "../src/window.vala"
	_tmp6_ = g_strconcat (_tmp5_, " on column:", NULL);
#line 558 "../src/window.vala"
	_tmp7_ = _tmp6_;
#line 558 "../src/window.vala"
	_tmp8_ = g_strdup_printf ("%i", column);
#line 558 "../src/window.vala"
	_tmp9_ = _tmp8_;
#line 558 "../src/window.vala"
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
#line 558 "../src/window.vala"
	_tmp11_ = _tmp10_;
#line 558 "../src/window.vala"
	g_info ("window.vala:558: %s", _tmp11_);
#line 558 "../src/window.vala"
	_g_free0 (_tmp11_);
#line 558 "../src/window.vala"
	_g_free0 (_tmp9_);
#line 558 "../src/window.vala"
	_g_free0 (_tmp7_);
#line 558 "../src/window.vala"
	_g_free0 (_tmp5_);
#line 558 "../src/window.vala"
	_g_free0 (_tmp3_);
#line 558 "../src/window.vala"
	_g_free0 (_tmp1_);
#line 563 "../src/window.vala"
	_tmp12_ = bookworm_app_app_window_library_table_treeview;
#line 563 "../src/window.vala"
	_tmp13_ = gtk_tree_view_get_model (_tmp12_);
#line 563 "../src/window.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 563 "../src/window.vala"
	aTreeModel = _tmp14_;
#line 564 "../src/window.vala"
	_tmp15_ = gtk_tree_path_new_from_string (path);
#line 564 "../src/window.vala"
	aTreePath = _tmp15_;
#line 565 "../src/window.vala"
	_tmp16_ = aTreeModel;
#line 565 "../src/window.vala"
	_tmp17_ = aTreePath;
#line 565 "../src/window.vala"
	gtk_tree_model_get_iter (_tmp16_, &_tmp18_, _tmp17_);
#line 565 "../src/window.vala"
	sortedIter = _tmp18_;
#line 566 "../src/window.vala"
	_tmp19_ = aTreeModel;
#line 566 "../src/window.vala"
	_tmp20_ = sortedIter;
#line 566 "../src/window.vala"
	gtk_tree_model_get_value (_tmp19_, &_tmp20_, 7, &_tmp21_);
#line 566 "../src/window.vala"
	G_IS_VALUE (&bookLocation) ? (g_value_unset (&bookLocation), NULL) : NULL;
#line 566 "../src/window.vala"
	bookLocation = _tmp21_;
#line 571 "../src/window.vala"
	iterExists = TRUE;
#line 572 "../src/window.vala"
	_tmp22_ = bookworm_app_app_window_library_table_liststore;
#line 572 "../src/window.vala"
	_tmp24_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp22_, &_tmp23_);
#line 572 "../src/window.vala"
	iter = _tmp23_;
#line 572 "../src/window.vala"
	iterExists = _tmp24_;
#line 573 "../src/window.vala"
	while (TRUE) {
#line 3781 "window.c"
		GtkListStore* _tmp25_;
		GtkTreeIter _tmp26_;
		gchar* _tmp27_ = NULL;
		GValue _tmp28_;
		const gchar* _tmp29_;
		GtkListStore* _tmp47_;
		gboolean _tmp48_;
#line 573 "../src/window.vala"
		if (!iterExists) {
#line 573 "../src/window.vala"
			break;
#line 3793 "window.c"
		}
#line 574 "../src/window.vala"
		_tmp25_ = bookworm_app_app_window_library_table_liststore;
#line 574 "../src/window.vala"
		_tmp26_ = iter;
#line 574 "../src/window.vala"
		gtk_tree_model_get ((GtkTreeModel*) _tmp25_, &_tmp26_, 7, &_tmp27_, -1);
#line 574 "../src/window.vala"
		_g_free0 (bookLocationforCurrentRow);
#line 574 "../src/window.vala"
		bookLocationforCurrentRow = _tmp27_;
#line 575 "../src/window.vala"
		_tmp28_ = bookLocation;
#line 575 "../src/window.vala"
		_tmp29_ = bookLocationforCurrentRow;
#line 575 "../src/window.vala"
		if (g_strcmp0 (g_value_get_string (&_tmp28_), _tmp29_) == 0) {
#line 3811 "window.c"
			GtkListStore* _tmp30_;
			GtkTreeIter _tmp31_;
			BookwormAppBook* aBook = NULL;
			GeeHashMap* _tmp32_;
			GValue _tmp33_;
			gpointer _tmp34_;
			BookwormAppBook* _tmp38_;
			GeeHashMap* _tmp39_;
			BookwormAppBook* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			BookwormAppBook* _tmp43_;
			GValue _tmp44_;
			gchar* _tmp45_;
			gchar* _tmp46_;
#line 576 "../src/window.vala"
			_tmp30_ = bookworm_app_app_window_library_table_liststore;
#line 576 "../src/window.vala"
			_tmp31_ = iter;
#line 576 "../src/window.vala"
			gtk_list_store_set (_tmp30_, &_tmp31_, column, new_text, -1);
#line 577 "../src/window.vala"
			_tmp32_ = bookworm_app_bookworm_libraryViewMap;
#line 577 "../src/window.vala"
			_tmp33_ = bookLocation;
#line 577 "../src/window.vala"
			_tmp34_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp32_, g_value_get_string (&_tmp33_));
#line 577 "../src/window.vala"
			aBook = (BookwormAppBook*) _tmp34_;
#line 578 "../src/window.vala"
			if (column == 1) {
#line 3843 "window.c"
				BookwormAppBook* _tmp35_;
#line 579 "../src/window.vala"
				_tmp35_ = aBook;
#line 579 "../src/window.vala"
				bookworm_app_book_setBookTitle (_tmp35_, new_text);
#line 3849 "window.c"
			}
#line 581 "../src/window.vala"
			if (column == 2) {
#line 3853 "window.c"
				BookwormAppBook* _tmp36_;
#line 582 "../src/window.vala"
				_tmp36_ = aBook;
#line 582 "../src/window.vala"
				bookworm_app_book_setBookAuthor (_tmp36_, new_text);
#line 3859 "window.c"
			}
#line 584 "../src/window.vala"
			if (column == 5) {
#line 3863 "window.c"
				BookwormAppBook* _tmp37_;
#line 585 "../src/window.vala"
				_tmp37_ = aBook;
#line 585 "../src/window.vala"
				bookworm_app_book_setBookTags (_tmp37_, new_text);
#line 3869 "window.c"
			}
#line 587 "../src/window.vala"
			_tmp38_ = aBook;
#line 587 "../src/window.vala"
			bookworm_app_book_setWasBookOpened (_tmp38_, TRUE);
#line 588 "../src/window.vala"
			_tmp39_ = bookworm_app_bookworm_libraryViewMap;
#line 588 "../src/window.vala"
			_tmp40_ = aBook;
#line 588 "../src/window.vala"
			_tmp41_ = bookworm_app_book_getBookLocation (_tmp40_);
#line 588 "../src/window.vala"
			_tmp42_ = _tmp41_;
#line 588 "../src/window.vala"
			_tmp43_ = aBook;
#line 588 "../src/window.vala"
			gee_abstract_map_set ((GeeAbstractMap*) _tmp39_, _tmp42_, _tmp43_);
#line 588 "../src/window.vala"
			_g_free0 (_tmp42_);
#line 589 "../src/window.vala"
			_tmp44_ = bookLocation;
#line 589 "../src/window.vala"
			_tmp45_ = g_strconcat ("Completed updating metadata in List View for book:", g_value_get_string (&_tmp44_), NULL);
#line 589 "../src/window.vala"
			_tmp46_ = _tmp45_;
#line 589 "../src/window.vala"
			g_debug ("window.vala:589: %s", _tmp46_);
#line 589 "../src/window.vala"
			_g_free0 (_tmp46_);
#line 590 "../src/window.vala"
			result = TRUE;
#line 590 "../src/window.vala"
			_bookworm_app_book_unref0 (aBook);
#line 590 "../src/window.vala"
			_g_free0 (bookLocationforCurrentRow);
#line 590 "../src/window.vala"
			__vala_GtkTreePath_free0 (aTreePath);
#line 590 "../src/window.vala"
			_g_object_unref0 (aTreeModel);
#line 590 "../src/window.vala"
			G_IS_VALUE (&bookLocation) ? (g_value_unset (&bookLocation), NULL) : NULL;
#line 590 "../src/window.vala"
			return result;
#line 3913 "window.c"
		}
#line 592 "../src/window.vala"
		_tmp47_ = bookworm_app_app_window_library_table_liststore;
#line 592 "../src/window.vala"
		_tmp48_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp47_, &iter);
#line 592 "../src/window.vala"
		iterExists = _tmp48_;
#line 3921 "window.c"
	}
#line 594 "../src/window.vala"
	g_info ("window.vala:594: [END] [FUNCTION:updateLibraryListViewData] ");
#line 595 "../src/window.vala"
	result = TRUE;
#line 595 "../src/window.vala"
	_g_free0 (bookLocationforCurrentRow);
#line 595 "../src/window.vala"
	__vala_GtkTreePath_free0 (aTreePath);
#line 595 "../src/window.vala"
	_g_object_unref0 (aTreeModel);
#line 595 "../src/window.vala"
	G_IS_VALUE (&bookLocation) ? (g_value_unset (&bookLocation), NULL) : NULL;
#line 595 "../src/window.vala"
	return result;
#line 3937 "window.c"
}

static void
__lambda64_ (void)
{
	GeeArrayList* selectedEBooks = NULL;
	GtkApplicationWindow* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
#line 613 "../src/window.vala"
	_tmp0_ = bookworm_app_bookworm_window;
#line 613 "../src/window.vala"
	_tmp1_ = bookworm_app_utils_selectFileChooser (GTK_FILE_CHOOSER_ACTION_OPEN, _ ("Select eBook"), (GtkWindow*) _tmp0_, TRUE, "EBOOKS");
#line 613 "../src/window.vala"
	selectedEBooks = _tmp1_;
#line 620 "../src/window.vala"
	_tmp2_ = selectedEBooks;
#line 620 "../src/window.vala"
	_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
#line 620 "../src/window.vala"
	_tmp4_ = _tmp3_;
#line 620 "../src/window.vala"
	if (_tmp4_ > 0) {
#line 3963 "window.c"
		GtkApplicationWindow* _tmp5_;
		GraniteWidgetsWelcome* _tmp6_;
		GtkApplicationWindow* _tmp7_;
		GtkBox* _tmp8_;
		GtkBox* _tmp9_;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gchar** _tmp13_;
		gint countOfBooksToBeAdded = 0;
		GtkProgressBar* _tmp26_;
#line 621 "../src/window.vala"
		_tmp5_ = bookworm_app_bookworm_window;
#line 621 "../src/window.vala"
		_tmp6_ = bookworm_app_bookworm_welcomeWidget;
#line 621 "../src/window.vala"
		gtk_container_remove ((GtkContainer*) _tmp5_, (GtkWidget*) _tmp6_);
#line 622 "../src/window.vala"
		_tmp7_ = bookworm_app_bookworm_window;
#line 622 "../src/window.vala"
		_tmp8_ = bookworm_app_bookworm_bookWormUIBox;
#line 622 "../src/window.vala"
		gtk_container_add ((GtkContainer*) _tmp7_, (GtkWidget*) _tmp8_);
#line 623 "../src/window.vala"
		_tmp9_ = bookworm_app_bookworm_bookWormUIBox;
#line 623 "../src/window.vala"
		gtk_widget_show_all ((GtkWidget*) _tmp9_);
#line 624 "../src/window.vala"
		bookworm_app_bookworm_toggleUIState ();
#line 626 "../src/window.vala"
		_tmp10_ = selectedEBooks;
#line 626 "../src/window.vala"
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
#line 626 "../src/window.vala"
		_tmp12_ = _tmp11_;
#line 626 "../src/window.vala"
		_tmp13_ = g_new0 (gchar*, _tmp12_ + 1);
#line 626 "../src/window.vala"
		bookworm_app_bookworm_pathsOfBooksToBeAdded = (_vala_array_free (bookworm_app_bookworm_pathsOfBooksToBeAdded, bookworm_app_bookworm_pathsOfBooksToBeAdded_length1, (GDestroyNotify) g_free), NULL);
#line 626 "../src/window.vala"
		bookworm_app_bookworm_pathsOfBooksToBeAdded = _tmp13_;
#line 626 "../src/window.vala"
		bookworm_app_bookworm_pathsOfBooksToBeAdded_length1 = _tmp12_;
#line 627 "../src/window.vala"
		countOfBooksToBeAdded = 0;
#line 4009 "window.c"
		{
			GeeArrayList* _pathToSelectedBook_list = NULL;
			GeeArrayList* _tmp14_;
			gint _pathToSelectedBook_size = 0;
			GeeArrayList* _tmp15_;
			gint _tmp16_;
			gint _tmp17_;
			gint _pathToSelectedBook_index = 0;
#line 628 "../src/window.vala"
			_tmp14_ = selectedEBooks;
#line 628 "../src/window.vala"
			_pathToSelectedBook_list = _tmp14_;
#line 628 "../src/window.vala"
			_tmp15_ = _pathToSelectedBook_list;
#line 628 "../src/window.vala"
			_tmp16_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp15_);
#line 628 "../src/window.vala"
			_tmp17_ = _tmp16_;
#line 628 "../src/window.vala"
			_pathToSelectedBook_size = _tmp17_;
#line 628 "../src/window.vala"
			_pathToSelectedBook_index = -1;
#line 628 "../src/window.vala"
			while (TRUE) {
#line 4034 "window.c"
				gint _tmp18_;
				gint _tmp19_;
				gchar* pathToSelectedBook = NULL;
				GeeArrayList* _tmp20_;
				gpointer _tmp21_;
				gchar** _tmp22_;
				gint _tmp22__length1;
				const gchar* _tmp23_;
				gchar* _tmp24_;
				gint _tmp25_;
#line 628 "../src/window.vala"
				_pathToSelectedBook_index = _pathToSelectedBook_index + 1;
#line 628 "../src/window.vala"
				_tmp18_ = _pathToSelectedBook_index;
#line 628 "../src/window.vala"
				_tmp19_ = _pathToSelectedBook_size;
#line 628 "../src/window.vala"
				if (!(_tmp18_ < _tmp19_)) {
#line 628 "../src/window.vala"
					break;
#line 4055 "window.c"
				}
#line 628 "../src/window.vala"
				_tmp20_ = _pathToSelectedBook_list;
#line 628 "../src/window.vala"
				_tmp21_ = gee_abstract_list_get ((GeeAbstractList*) _tmp20_, _pathToSelectedBook_index);
#line 628 "../src/window.vala"
				pathToSelectedBook = (gchar*) _tmp21_;
#line 629 "../src/window.vala"
				_tmp22_ = bookworm_app_bookworm_pathsOfBooksToBeAdded;
#line 629 "../src/window.vala"
				_tmp22__length1 = bookworm_app_bookworm_pathsOfBooksToBeAdded_length1;
#line 629 "../src/window.vala"
				_tmp23_ = pathToSelectedBook;
#line 629 "../src/window.vala"
				_tmp24_ = g_strdup (_tmp23_);
#line 629 "../src/window.vala"
				_g_free0 (_tmp22_[countOfBooksToBeAdded]);
#line 629 "../src/window.vala"
				_tmp22_[countOfBooksToBeAdded] = _tmp24_;
#line 630 "../src/window.vala"
				_tmp25_ = countOfBooksToBeAdded;
#line 630 "../src/window.vala"
				countOfBooksToBeAdded = _tmp25_ + 1;
#line 628 "../src/window.vala"
				_g_free0 (pathToSelectedBook);
#line 4081 "window.c"
			}
		}
#line 633 "../src/window.vala"
		_tmp26_ = bookworm_app_app_window_bookAdditionBar;
#line 633 "../src/window.vala"
		gtk_widget_show ((GtkWidget*) _tmp26_);
#line 634 "../src/window.vala"
		bookworm_app_bookworm_isBookBeingAddedToLibrary = TRUE;
#line 635 "../src/window.vala"
		bookworm_app_library_addBooksToLibrary (NULL, NULL);
#line 4092 "window.c"
	}
#line 612 "../src/window.vala"
	_g_object_unref0 (selectedEBooks);
#line 4096 "window.c"
}

static void
___lambda64__granite_widgets_welcome_activated (GraniteWidgetsWelcome* _sender,
                                                gint index,
                                                gpointer self)
{
#line 612 "../src/window.vala"
	__lambda64_ ();
#line 4106 "window.c"
}

GraniteWidgetsWelcome*
bookworm_app_app_window_createWelcomeScreen (void)
{
	GraniteWidgetsWelcome* _tmp0_;
	GtkImage* openFolderImage = NULL;
	GtkImage* _tmp1_;
	GraniteWidgetsWelcome* _tmp2_;
	GraniteWidgetsWelcome* _tmp3_;
	GraniteWidgetsWelcome* _tmp4_;
	GraniteWidgetsWelcome* _tmp5_;
	GraniteWidgetsWelcome* result;
#line 599 "../src/window.vala"
	g_info ("window.vala:599: [START] [FUNCTION:createWelcomeScreen] ");
#line 601 "../src/window.vala"
	_tmp0_ = granite_widgets_welcome_new (BOOKWORM_APP_CONSTANTS_TEXT_FOR_WELCOME_MESSAGE_TITLE, BOOKWORM_APP_CONSTANTS_TEXT_FOR_WELCOME_MESSAGE_SUBTITLE);
#line 601 "../src/window.vala"
	g_object_ref_sink (_tmp0_);
#line 601 "../src/window.vala"
	_g_object_unref0 (bookworm_app_bookworm_welcomeWidget);
#line 601 "../src/window.vala"
	bookworm_app_bookworm_welcomeWidget = _tmp0_;
#line 604 "../src/window.vala"
	_tmp1_ = (GtkImage*) gtk_image_new_from_icon_name ("document-open", (GtkIconSize) GTK_ICON_SIZE_DIALOG);
#line 604 "../src/window.vala"
	g_object_ref_sink (_tmp1_);
#line 604 "../src/window.vala"
	openFolderImage = _tmp1_;
#line 605 "../src/window.vala"
	_tmp2_ = bookworm_app_bookworm_welcomeWidget;
#line 605 "../src/window.vala"
	granite_widgets_welcome_append_with_image (_tmp2_, openFolderImage, "Open", BOOKWORM_APP_CONSTANTS_TEXT_FOR_WELCOME_OPENDIR_MESSAGE);
#line 612 "../src/window.vala"
	_tmp3_ = bookworm_app_bookworm_welcomeWidget;
#line 612 "../src/window.vala"
	g_signal_connect (_tmp3_, "activated", (GCallback) ___lambda64__granite_widgets_welcome_activated, NULL);
#line 638 "../src/window.vala"
	g_info ("window.vala:638: [END] [FUNCTION:createWelcomeScreen] ");
#line 639 "../src/window.vala"
	_tmp4_ = bookworm_app_bookworm_welcomeWidget;
#line 639 "../src/window.vala"
	_tmp5_ = _g_object_ref0 (_tmp4_);
#line 639 "../src/window.vala"
	result = _tmp5_;
#line 639 "../src/window.vala"
	_g_object_unref0 (openFolderImage);
#line 639 "../src/window.vala"
	return result;
#line 4156 "window.c"
}

void
bookworm_app_app_window_showInfoBar (BookwormAppBook* aBook,
                                     GtkMessageType aMessageType)
{
	GString* message = NULL;
	GString* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GString* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GtkLabel* _tmp6_;
	const gchar* _tmp7_;
	GtkInfoBar* _tmp8_;
	GtkInfoBar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
#line 642 "../src/window.vala"
	g_return_if_fail (aBook != NULL);
#line 643 "../src/window.vala"
	g_debug ("window.vala:643: [START] [FUNCTION:showInfoBar] ");
#line 644 "../src/window.vala"
	_tmp0_ = g_string_new ("");
#line 644 "../src/window.vala"
	message = _tmp0_;
#line 645 "../src/window.vala"
	_tmp1_ = bookworm_app_book_getParsingIssue (aBook);
#line 645 "../src/window.vala"
	_tmp2_ = _tmp1_;
#line 645 "../src/window.vala"
	_tmp3_ = g_string_append (message, _tmp2_);
#line 645 "../src/window.vala"
	_tmp4_ = bookworm_app_book_getBookLocation (aBook);
#line 645 "../src/window.vala"
	_tmp5_ = _tmp4_;
#line 645 "../src/window.vala"
	g_string_append (_tmp3_, _tmp5_);
#line 645 "../src/window.vala"
	_g_free0 (_tmp5_);
#line 645 "../src/window.vala"
	_g_free0 (_tmp2_);
#line 647 "../src/window.vala"
	_tmp6_ = bookworm_app_app_window_infobarLabel;
#line 647 "../src/window.vala"
	_tmp7_ = message->str;
#line 647 "../src/window.vala"
	gtk_label_set_text (_tmp6_, _tmp7_);
#line 648 "../src/window.vala"
	_tmp8_ = bookworm_app_app_window_infobar;
#line 648 "../src/window.vala"
	gtk_info_bar_set_message_type (_tmp8_, aMessageType);
#line 649 "../src/window.vala"
	_tmp9_ = bookworm_app_app_window_infobar;
#line 649 "../src/window.vala"
	gtk_widget_show ((GtkWidget*) _tmp9_);
#line 650 "../src/window.vala"
	_tmp10_ = message->str;
#line 650 "../src/window.vala"
	_tmp11_ = g_strconcat ("[END] [FUNCTION:showInfoBar] with message:", _tmp10_, NULL);
#line 650 "../src/window.vala"
	_tmp12_ = _tmp11_;
#line 650 "../src/window.vala"
	g_debug ("window.vala:650: %s", _tmp12_);
#line 650 "../src/window.vala"
	_g_free0 (_tmp12_);
#line 642 "../src/window.vala"
	_g_string_free0 (message);
#line 4227 "window.c"
}

void
bookworm_app_app_window_on_info_bar_closed (void)
{
	GtkInfoBar* _tmp0_;
#line 655 "../src/window.vala"
	_tmp0_ = bookworm_app_app_window_infobar;
#line 655 "../src/window.vala"
	gtk_widget_hide ((GtkWidget*) _tmp0_);
#line 4238 "window.c"
}

gboolean
bookworm_app_app_window_handleWindowStateEvents (GdkEventWindowState* ev)
{
	gboolean result;
#line 658 "../src/window.vala"
	g_return_val_if_fail (ev != NULL, FALSE);
#line 659 "../src/window.vala"
	if (ev->type == GDK_WINDOW_STATE) {
#line 4249 "window.c"
		GdkWindow* _tmp0_;
#line 660 "../src/window.vala"
		_tmp0_ = ev->window;
#line 660 "../src/window.vala"
		if ((gdk_window_get_state (_tmp0_) & GDK_WINDOW_STATE_FULLSCREEN) == 0) {
#line 4255 "window.c"
			BookwormAppSettings* _tmp1_;
#line 661 "../src/window.vala"
			_tmp1_ = bookworm_app_app_window_settings;
#line 661 "../src/window.vala"
			bookworm_app_settings_set_is_fullscreen (_tmp1_, FALSE);
#line 4261 "window.c"
		} else {
			BookwormAppSettings* _tmp2_;
#line 663 "../src/window.vala"
			_tmp2_ = bookworm_app_app_window_settings;
#line 663 "../src/window.vala"
			bookworm_app_settings_set_is_fullscreen (_tmp2_, TRUE);
#line 4268 "window.c"
		}
	}
#line 666 "../src/window.vala"
	result = FALSE;
#line 666 "../src/window.vala"
	return result;
#line 4275 "window.c"
}

void
bookworm_app_app_window_controlDeletionButton (gboolean selectionState)
{
#line 670 "../src/window.vala"
	if (selectionState) {
#line 4283 "window.c"
		gint _tmp0_;
		GtkButton* _tmp1_;
		GtkButton* _tmp2_;
#line 672 "../src/window.vala"
		_tmp0_ = bookworm_app_app_window_noOfBooksSelected;
#line 672 "../src/window.vala"
		bookworm_app_app_window_noOfBooksSelected = _tmp0_ + 1;
#line 673 "../src/window.vala"
		_tmp1_ = bookworm_app_app_window_remove_book_button;
#line 673 "../src/window.vala"
		gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
#line 674 "../src/window.vala"
		_tmp2_ = bookworm_app_app_window_remove_book_button;
#line 674 "../src/window.vala"
		gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp2_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_REMOVE_BOOK);
#line 4299 "window.c"
	} else {
		gint _tmp3_;
#line 678 "../src/window.vala"
		_tmp3_ = bookworm_app_app_window_noOfBooksSelected;
#line 678 "../src/window.vala"
		bookworm_app_app_window_noOfBooksSelected = _tmp3_ - 1;
#line 679 "../src/window.vala"
		if (bookworm_app_app_window_noOfBooksSelected < 1) {
#line 4308 "window.c"
			GtkButton* _tmp4_;
			GtkButton* _tmp5_;
#line 680 "../src/window.vala"
			_tmp4_ = bookworm_app_app_window_remove_book_button;
#line 680 "../src/window.vala"
			gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
#line 681 "../src/window.vala"
			_tmp5_ = bookworm_app_app_window_remove_book_button;
#line 681 "../src/window.vala"
			gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp5_, BOOKWORM_APP_CONSTANTS_TOOLTIP_TEXT_FOR_REMOVE_BOOK_UNSELECTED);
#line 4319 "window.c"
		}
	}
}

BookwormAppAppWindow*
bookworm_app_app_window_construct (GType object_type)
{
	BookwormAppAppWindow* self = NULL;
#line 23 "../src/window.vala"
	self = (BookwormAppAppWindow*) g_type_create_instance (object_type);
#line 23 "../src/window.vala"
	return self;
#line 4332 "window.c"
}

BookwormAppAppWindow*
bookworm_app_app_window_new (void)
{
#line 23 "../src/window.vala"
	return bookworm_app_app_window_construct (BOOKWORM_APP_TYPE_APP_WINDOW);
#line 4340 "window.c"
}

static void
bookworm_app_value_app_window_init (GValue* value)
{
#line 23 "../src/window.vala"
	value->data[0].v_pointer = NULL;
#line 4348 "window.c"
}

static void
bookworm_app_value_app_window_free_value (GValue* value)
{
#line 23 "../src/window.vala"
	if (value->data[0].v_pointer) {
#line 23 "../src/window.vala"
		bookworm_app_app_window_unref (value->data[0].v_pointer);
#line 4358 "window.c"
	}
}

static void
bookworm_app_value_app_window_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
#line 23 "../src/window.vala"
	if (src_value->data[0].v_pointer) {
#line 23 "../src/window.vala"
		dest_value->data[0].v_pointer = bookworm_app_app_window_ref (src_value->data[0].v_pointer);
#line 4370 "window.c"
	} else {
#line 23 "../src/window.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4374 "window.c"
	}
}

static gpointer
bookworm_app_value_app_window_peek_pointer (const GValue* value)
{
#line 23 "../src/window.vala"
	return value->data[0].v_pointer;
#line 4383 "window.c"
}

static gchar*
bookworm_app_value_app_window_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
#line 23 "../src/window.vala"
	if (collect_values[0].v_pointer) {
#line 4394 "window.c"
		BookwormAppAppWindow * object;
		object = collect_values[0].v_pointer;
#line 23 "../src/window.vala"
		if (object->parent_instance.g_class == NULL) {
#line 23 "../src/window.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4401 "window.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 23 "../src/window.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4405 "window.c"
		}
#line 23 "../src/window.vala"
		value->data[0].v_pointer = bookworm_app_app_window_ref (object);
#line 4409 "window.c"
	} else {
#line 23 "../src/window.vala"
		value->data[0].v_pointer = NULL;
#line 4413 "window.c"
	}
#line 23 "../src/window.vala"
	return NULL;
#line 4417 "window.c"
}

static gchar*
bookworm_app_value_app_window_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	BookwormAppAppWindow ** object_p;
	object_p = collect_values[0].v_pointer;
#line 23 "../src/window.vala"
	if (!object_p) {
#line 23 "../src/window.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4432 "window.c"
	}
#line 23 "../src/window.vala"
	if (!value->data[0].v_pointer) {
#line 23 "../src/window.vala"
		*object_p = NULL;
#line 4438 "window.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 23 "../src/window.vala"
		*object_p = value->data[0].v_pointer;
#line 4442 "window.c"
	} else {
#line 23 "../src/window.vala"
		*object_p = bookworm_app_app_window_ref (value->data[0].v_pointer);
#line 4446 "window.c"
	}
#line 23 "../src/window.vala"
	return NULL;
#line 4450 "window.c"
}

GParamSpec*
bookworm_app_param_spec_app_window (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	BookwormAppParamSpecAppWindow* spec;
#line 23 "../src/window.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_APP_WINDOW), NULL);
#line 23 "../src/window.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 23 "../src/window.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 23 "../src/window.vala"
	return G_PARAM_SPEC (spec);
#line 4469 "window.c"
}

gpointer
bookworm_app_value_get_app_window (const GValue* value)
{
#line 23 "../src/window.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_APP_WINDOW), NULL);
#line 23 "../src/window.vala"
	return value->data[0].v_pointer;
#line 4479 "window.c"
}

void
bookworm_app_value_set_app_window (GValue* value,
                                   gpointer v_object)
{
	BookwormAppAppWindow * old;
#line 23 "../src/window.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_APP_WINDOW));
#line 23 "../src/window.vala"
	old = value->data[0].v_pointer;
#line 23 "../src/window.vala"
	if (v_object) {
#line 23 "../src/window.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_APP_WINDOW));
#line 23 "../src/window.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 23 "../src/window.vala"
		value->data[0].v_pointer = v_object;
#line 23 "../src/window.vala"
		bookworm_app_app_window_ref (value->data[0].v_pointer);
#line 4501 "window.c"
	} else {
#line 23 "../src/window.vala"
		value->data[0].v_pointer = NULL;
#line 4505 "window.c"
	}
#line 23 "../src/window.vala"
	if (old) {
#line 23 "../src/window.vala"
		bookworm_app_app_window_unref (old);
#line 4511 "window.c"
	}
}

void
bookworm_app_value_take_app_window (GValue* value,
                                    gpointer v_object)
{
	BookwormAppAppWindow * old;
#line 23 "../src/window.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_APP_WINDOW));
#line 23 "../src/window.vala"
	old = value->data[0].v_pointer;
#line 23 "../src/window.vala"
	if (v_object) {
#line 23 "../src/window.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_APP_WINDOW));
#line 23 "../src/window.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 23 "../src/window.vala"
		value->data[0].v_pointer = v_object;
#line 4532 "window.c"
	} else {
#line 23 "../src/window.vala"
		value->data[0].v_pointer = NULL;
#line 4536 "window.c"
	}
#line 23 "../src/window.vala"
	if (old) {
#line 23 "../src/window.vala"
		bookworm_app_app_window_unref (old);
#line 4542 "window.c"
	}
}

static void
bookworm_app_app_window_class_init (BookwormAppAppWindowClass * klass,
                                    gpointer klass_data)
{
#line 23 "../src/window.vala"
	bookworm_app_app_window_parent_class = g_type_class_peek_parent (klass);
#line 23 "../src/window.vala"
	((BookwormAppAppWindowClass *) klass)->finalize = bookworm_app_app_window_finalize;
#line 4554 "window.c"
}

static void
bookworm_app_app_window_instance_init (BookwormAppAppWindow * self,
                                       gpointer klass)
{
#line 23 "../src/window.vala"
	self->ref_count = 1;
#line 4563 "window.c"
}

static void
bookworm_app_app_window_finalize (BookwormAppAppWindow * obj)
{
	BookwormAppAppWindow * self;
#line 23 "../src/window.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_APP_WINDOW, BookwormAppAppWindow);
#line 23 "../src/window.vala"
	g_signal_handlers_destroy (self);
#line 4574 "window.c"
}

static GType
bookworm_app_app_window_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_app_window_init, bookworm_app_value_app_window_free_value, bookworm_app_value_app_window_copy_value, bookworm_app_value_app_window_peek_pointer, "p", bookworm_app_value_app_window_collect_value, "p", bookworm_app_value_app_window_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppAppWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_app_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppAppWindow), 0, (GInstanceInitFunc) bookworm_app_app_window_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_app_window_type_id;
	bookworm_app_app_window_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppAppWindow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_app_window_type_id;
}

GType
bookworm_app_app_window_get_type (void)
{
	static volatile gsize bookworm_app_app_window_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_app_window_type_id__once)) {
		GType bookworm_app_app_window_type_id;
		bookworm_app_app_window_type_id = bookworm_app_app_window_get_type_once ();
		g_once_init_leave (&bookworm_app_app_window_type_id__once, bookworm_app_app_window_type_id);
	}
	return bookworm_app_app_window_type_id__once;
}

gpointer
bookworm_app_app_window_ref (gpointer instance)
{
	BookwormAppAppWindow * self;
	self = instance;
#line 23 "../src/window.vala"
	g_atomic_int_inc (&self->ref_count);
#line 23 "../src/window.vala"
	return instance;
#line 4609 "window.c"
}

void
bookworm_app_app_window_unref (gpointer instance)
{
	BookwormAppAppWindow * self;
	self = instance;
#line 23 "../src/window.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 23 "../src/window.vala"
		BOOKWORM_APP_APP_WINDOW_GET_CLASS (self)->finalize (self);
#line 23 "../src/window.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4623 "window.c"
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

