/* book.c generated by valac 0.56.18, the Vala compiler
 * generated from book.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and has the getter/setter methods
* used for holding the state of the book
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
typedef struct _BookwormAppBookPrivate BookwormAppBookPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
typedef struct _BookwormAppParamSpecBook BookwormAppParamSpecBook;

struct _BookwormAppBook {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppBookPrivate * priv;
};

struct _BookwormAppBookClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppBook *self);
};

struct _BookwormAppBookPrivate {
	gint bookId;
	gboolean isBookParsedCorrectly;
	gchar* parsingIssue;
	gchar* bookLocation;
	gchar* bookCoverLocation;
	gchar* bookExtractionLocation;
	gchar* bookTitle;
	gchar* bookAuthor;
	gchar* bookTags;
	gchar* annotationTags;
	gchar* bookPublishDate;
	gchar* bookCreationDate;
	gchar* bookLastModificationDate;
	gint bookPageNumber;
	gint bookTotalPages;
	gint bookScrollPosition;
	gint bookRating;
	gboolean isBookCoverImagePresent;
	GString* bookmarks;
	GeeTreeMap* annotationMap;
	GeeArrayList* bookContentList;
	GeeArrayList* TOCMap;
	gchar* opfFileLocation;
	gchar* baseLocationOfContents;
	gboolean ifPageForward;
	gboolean ifPageBackward;
	gboolean isBookSelected;
	gboolean wasBookOpened;
	gchar* bookAnchor;
	GeeHashMap* bookWidgetsList;
};

struct _BookwormAppParamSpecBook {
	GParamSpec parent_instance;
};

static gint BookwormAppBook_private_offset;
static gpointer bookworm_app_book_parent_class = NULL;

VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN void bookworm_app_book_setBookId (BookwormAppBook* self,
                                  gint aBookId);
VALA_EXTERN gint bookworm_app_book_getBookId (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setIsBookParsed (BookwormAppBook* self,
                                        gboolean isParsed);
VALA_EXTERN gboolean bookworm_app_book_getIsBookParsed (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setParsingIssue (BookwormAppBook* self,
                                        const gchar* aParsingIssue);
VALA_EXTERN gchar* bookworm_app_book_getParsingIssue (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookLocation (BookwormAppBook* self,
                                        const gchar* aBookLocation);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookCoverLocation (BookwormAppBook* self,
                                             const gchar* aBookCoverLocation);
VALA_EXTERN gchar* bookworm_app_book_getBookCoverLocation (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookContentList (BookwormAppBook* self,
                                           const gchar* contentList);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_clearBookContentList (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setTOC (BookwormAppBook* self,
                               GeeHashMap* toc);
VALA_EXTERN GeeArrayList* bookworm_app_book_getTOC (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_clearTOC (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookExtractionLocation (BookwormAppBook* self,
                                                  const gchar* aBookExtractionLocation);
VALA_EXTERN gchar* bookworm_app_book_getBookExtractionLocation (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookRating (BookwormAppBook* self,
                                      gint aBookRating);
VALA_EXTERN gint bookworm_app_book_getBookRating (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookAuthor (BookwormAppBook* self,
                                      const gchar* aBookAuthor);
VALA_EXTERN gchar* bookworm_app_book_getBookAuthor (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookTags (BookwormAppBook* self,
                                    const gchar* aBookTags);
VALA_EXTERN gchar* bookworm_app_book_getBookTags (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setAnnotationTags (BookwormAppBook* self,
                                          const gchar* anAnnotationTags);
VALA_EXTERN gchar* bookworm_app_book_getAnnotationTags (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setOPFFileLocation (BookwormAppBook* self,
                                           const gchar* aOPFFileLocation);
VALA_EXTERN gchar* bookworm_app_book_getOPFFileLocation (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBaseLocationOfContents (BookwormAppBook* self,
                                                  const gchar* aBaseLocationOfContents);
VALA_EXTERN gchar* bookworm_app_book_getBaseLocationOfContents (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setIsBookCoverImagePresent (BookwormAppBook* self,
                                                   gboolean isABookCoverImagePresent);
VALA_EXTERN gboolean bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookPublishDate (BookwormAppBook* self,
                                           const gchar* aBookPublishDate);
VALA_EXTERN gchar* bookworm_app_book_getBookPublishDate (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookCreationDate (BookwormAppBook* self,
                                            const gchar* aBookCreationDate);
VALA_EXTERN gchar* bookworm_app_book_getBookCreationDate (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookLastModificationDate (BookwormAppBook* self,
                                                    const gchar* aBookLastModificationDate);
VALA_EXTERN gchar* bookworm_app_book_getBookLastModificationDate (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookPageNumber (BookwormAppBook* self,
                                          gint aBookPageNumber);
VALA_EXTERN gint bookworm_app_book_getBookPageNumber (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookTotalPages (BookwormAppBook* self,
                                          gint aBookTotalPages);
VALA_EXTERN gint bookworm_app_book_getBookTotalPages (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookScrollPos (BookwormAppBook* self,
                                         gint aBookScrollPos);
VALA_EXTERN gint bookworm_app_book_getBookScrollPos (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setIfPageForward (BookwormAppBook* self,
                                         gboolean ifBookPageForward);
VALA_EXTERN gboolean bookworm_app_book_getIfPageForward (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setIfPageBackward (BookwormAppBook* self,
                                          gboolean ifBookPageBackward);
VALA_EXTERN gboolean bookworm_app_book_getIfPageBackward (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setIsBookSelected (BookwormAppBook* self,
                                          gboolean aIsBookSelected);
VALA_EXTERN gboolean bookworm_app_book_getIsBookSelected (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setWasBookOpened (BookwormAppBook* self,
                                         gboolean aWasBookOpened);
VALA_EXTERN gboolean bookworm_app_book_getWasBookOpened (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookmark (BookwormAppBook* self,
                                    gint pageNumber,
                                    const gchar* action);
VALA_EXTERN gchar* bookworm_app_book_getBookmark (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setAnnotations (BookwormAppBook* self,
                                       const gchar* index,
                                       const gchar* annotationText);
VALA_EXTERN gchar* bookworm_app_book_getAnnotations (BookwormAppBook* self,
                                         const gchar* index);
VALA_EXTERN GeeTreeMap* bookworm_app_book_getAnnotationList (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setAnnotationList (BookwormAppBook* self,
                                          GeeTreeMap* aTreeMap);
VALA_EXTERN void bookworm_app_book_setBookWidget (BookwormAppBook* self,
                                      const gchar* name,
                                      GtkWidget* aWidget);
VALA_EXTERN GtkWidget* bookworm_app_book_getBookWidget (BookwormAppBook* self,
                                            const gchar* name);
VALA_EXTERN void bookworm_app_book_setAnchor (BookwormAppBook* self,
                                  const gchar* aBookAnchor);
VALA_EXTERN gchar* bookworm_app_book_getAnchor (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_book_to_string (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_book_new (void);
VALA_EXTERN BookwormAppBook* bookworm_app_book_construct (GType object_type);
static void bookworm_app_book_finalize (BookwormAppBook * obj);
static GType bookworm_app_book_get_type_once (void);

static inline gpointer
bookworm_app_book_get_instance_private (BookwormAppBook* self)
{
	return G_STRUCT_MEMBER_P (self, BookwormAppBook_private_offset);
}

void
bookworm_app_book_setBookId (BookwormAppBook* self,
                             gint aBookId)
{
#line 57 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 58 "../src/book.vala"
	self->priv->bookId = aBookId;
#line 251 "book.c"
}

gint
bookworm_app_book_getBookId (BookwormAppBook* self)
{
	gint result;
#line 60 "../src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 61 "../src/book.vala"
	result = self->priv->bookId;
#line 61 "../src/book.vala"
	return result;
#line 264 "book.c"
}

void
bookworm_app_book_setIsBookParsed (BookwormAppBook* self,
                                   gboolean isParsed)
{
#line 65 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 66 "../src/book.vala"
	self->priv->isBookParsedCorrectly = isParsed;
#line 275 "book.c"
}

gboolean
bookworm_app_book_getIsBookParsed (BookwormAppBook* self)
{
	gboolean result;
#line 68 "../src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 69 "../src/book.vala"
	result = self->priv->isBookParsedCorrectly;
#line 69 "../src/book.vala"
	return result;
#line 288 "book.c"
}

void
bookworm_app_book_setParsingIssue (BookwormAppBook* self,
                                   const gchar* aParsingIssue)
{
	gchar* _tmp0_;
#line 73 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 73 "../src/book.vala"
	g_return_if_fail (aParsingIssue != NULL);
#line 74 "../src/book.vala"
	_tmp0_ = g_strdup (aParsingIssue);
#line 74 "../src/book.vala"
	_g_free0 (self->priv->parsingIssue);
#line 74 "../src/book.vala"
	self->priv->parsingIssue = _tmp0_;
#line 306 "book.c"
}

gchar*
bookworm_app_book_getParsingIssue (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 76 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 77 "../src/book.vala"
	_tmp0_ = self->priv->parsingIssue;
#line 77 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 77 "../src/book.vala"
	result = _tmp1_;
#line 77 "../src/book.vala"
	return result;
#line 325 "book.c"
}

void
bookworm_app_book_setBookLocation (BookwormAppBook* self,
                                   const gchar* aBookLocation)
{
	gchar* _tmp0_;
#line 81 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 81 "../src/book.vala"
	g_return_if_fail (aBookLocation != NULL);
#line 82 "../src/book.vala"
	_tmp0_ = g_strdup (aBookLocation);
#line 82 "../src/book.vala"
	_g_free0 (self->priv->bookLocation);
#line 82 "../src/book.vala"
	self->priv->bookLocation = _tmp0_;
#line 343 "book.c"
}

gchar*
bookworm_app_book_getBookLocation (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 84 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 85 "../src/book.vala"
	_tmp0_ = self->priv->bookLocation;
#line 85 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 85 "../src/book.vala"
	result = _tmp1_;
#line 85 "../src/book.vala"
	return result;
#line 362 "book.c"
}

void
bookworm_app_book_setBookCoverLocation (BookwormAppBook* self,
                                        const gchar* aBookCoverLocation)
{
	gchar* _tmp0_;
#line 89 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 89 "../src/book.vala"
	g_return_if_fail (aBookCoverLocation != NULL);
#line 90 "../src/book.vala"
	_tmp0_ = g_strdup (aBookCoverLocation);
#line 90 "../src/book.vala"
	_g_free0 (self->priv->bookCoverLocation);
#line 90 "../src/book.vala"
	self->priv->bookCoverLocation = _tmp0_;
#line 380 "book.c"
}

gchar*
bookworm_app_book_getBookCoverLocation (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 92 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 93 "../src/book.vala"
	_tmp0_ = self->priv->bookCoverLocation;
#line 93 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 93 "../src/book.vala"
	result = _tmp1_;
#line 93 "../src/book.vala"
	return result;
#line 399 "book.c"
}

void
bookworm_app_book_setBookContentList (BookwormAppBook* self,
                                      const gchar* contentList)
{
	GeeArrayList* _tmp0_;
#line 97 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 97 "../src/book.vala"
	g_return_if_fail (contentList != NULL);
#line 98 "../src/book.vala"
	_tmp0_ = self->priv->bookContentList;
#line 98 "../src/book.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, contentList);
#line 415 "book.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 101 "../src/book.vala"
	return self ? g_object_ref (self) : NULL;
#line 423 "book.c"
}

GeeArrayList*
bookworm_app_book_getBookContentList (BookwormAppBook* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
#line 100 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 101 "../src/book.vala"
	_tmp0_ = self->priv->bookContentList;
#line 101 "../src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 101 "../src/book.vala"
	result = _tmp1_;
#line 101 "../src/book.vala"
	return result;
#line 442 "book.c"
}

void
bookworm_app_book_clearBookContentList (BookwormAppBook* self)
{
	GeeArrayList* _tmp0_;
#line 103 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 104 "../src/book.vala"
	_tmp0_ = self->priv->bookContentList;
#line 104 "../src/book.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 455 "book.c"
}

void
bookworm_app_book_setTOC (BookwormAppBook* self,
                          GeeHashMap* toc)
{
	GeeArrayList* _tmp0_;
#line 108 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 108 "../src/book.vala"
	g_return_if_fail (toc != NULL);
#line 109 "../src/book.vala"
	_tmp0_ = self->priv->TOCMap;
#line 109 "../src/book.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, toc);
#line 471 "book.c"
}

GeeArrayList*
bookworm_app_book_getTOC (BookwormAppBook* self)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* result;
#line 111 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 112 "../src/book.vala"
	_tmp0_ = self->priv->TOCMap;
#line 112 "../src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 112 "../src/book.vala"
	result = _tmp1_;
#line 112 "../src/book.vala"
	return result;
#line 490 "book.c"
}

void
bookworm_app_book_clearTOC (BookwormAppBook* self)
{
	GeeArrayList* _tmp0_;
#line 114 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 115 "../src/book.vala"
	_tmp0_ = self->priv->TOCMap;
#line 115 "../src/book.vala"
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp0_);
#line 503 "book.c"
}

void
bookworm_app_book_setBookExtractionLocation (BookwormAppBook* self,
                                             const gchar* aBookExtractionLocation)
{
	gchar* _tmp0_;
#line 119 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 119 "../src/book.vala"
	g_return_if_fail (aBookExtractionLocation != NULL);
#line 120 "../src/book.vala"
	_tmp0_ = g_strdup (aBookExtractionLocation);
#line 120 "../src/book.vala"
	_g_free0 (self->priv->bookExtractionLocation);
#line 120 "../src/book.vala"
	self->priv->bookExtractionLocation = _tmp0_;
#line 521 "book.c"
}

gchar*
bookworm_app_book_getBookExtractionLocation (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 122 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 123 "../src/book.vala"
	_tmp0_ = self->priv->bookExtractionLocation;
#line 123 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 123 "../src/book.vala"
	result = _tmp1_;
#line 123 "../src/book.vala"
	return result;
#line 540 "book.c"
}

void
bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                const gchar* aBookTitle)
{
	gchar* _tmp0_;
#line 127 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 127 "../src/book.vala"
	g_return_if_fail (aBookTitle != NULL);
#line 128 "../src/book.vala"
	_tmp0_ = g_strdup (aBookTitle);
#line 128 "../src/book.vala"
	_g_free0 (self->priv->bookTitle);
#line 128 "../src/book.vala"
	self->priv->bookTitle = _tmp0_;
#line 558 "book.c"
}

gchar*
bookworm_app_book_getBookTitle (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 130 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 131 "../src/book.vala"
	_tmp0_ = self->priv->bookTitle;
#line 131 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 131 "../src/book.vala"
	result = _tmp1_;
#line 131 "../src/book.vala"
	return result;
#line 577 "book.c"
}

void
bookworm_app_book_setBookRating (BookwormAppBook* self,
                                 gint aBookRating)
{
#line 135 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 136 "../src/book.vala"
	self->priv->bookRating = aBookRating;
#line 588 "book.c"
}

gint
bookworm_app_book_getBookRating (BookwormAppBook* self)
{
	gint result;
#line 138 "../src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 139 "../src/book.vala"
	result = self->priv->bookRating;
#line 139 "../src/book.vala"
	return result;
#line 601 "book.c"
}

void
bookworm_app_book_setBookAuthor (BookwormAppBook* self,
                                 const gchar* aBookAuthor)
{
	gchar* _tmp0_;
#line 143 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 143 "../src/book.vala"
	g_return_if_fail (aBookAuthor != NULL);
#line 144 "../src/book.vala"
	_tmp0_ = g_strdup (aBookAuthor);
#line 144 "../src/book.vala"
	_g_free0 (self->priv->bookAuthor);
#line 144 "../src/book.vala"
	self->priv->bookAuthor = _tmp0_;
#line 619 "book.c"
}

gchar*
bookworm_app_book_getBookAuthor (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 146 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 147 "../src/book.vala"
	_tmp0_ = self->priv->bookAuthor;
#line 147 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 147 "../src/book.vala"
	result = _tmp1_;
#line 147 "../src/book.vala"
	return result;
#line 638 "book.c"
}

void
bookworm_app_book_setBookTags (BookwormAppBook* self,
                               const gchar* aBookTags)
{
	gchar* _tmp0_;
#line 151 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 151 "../src/book.vala"
	g_return_if_fail (aBookTags != NULL);
#line 152 "../src/book.vala"
	_tmp0_ = g_strdup (aBookTags);
#line 152 "../src/book.vala"
	_g_free0 (self->priv->bookTags);
#line 152 "../src/book.vala"
	self->priv->bookTags = _tmp0_;
#line 656 "book.c"
}

gchar*
bookworm_app_book_getBookTags (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 154 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 155 "../src/book.vala"
	_tmp0_ = self->priv->bookTags;
#line 155 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 155 "../src/book.vala"
	result = _tmp1_;
#line 155 "../src/book.vala"
	return result;
#line 675 "book.c"
}

void
bookworm_app_book_setAnnotationTags (BookwormAppBook* self,
                                     const gchar* anAnnotationTags)
{
	gchar* _tmp0_;
#line 159 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 159 "../src/book.vala"
	g_return_if_fail (anAnnotationTags != NULL);
#line 160 "../src/book.vala"
	_tmp0_ = g_strdup (anAnnotationTags);
#line 160 "../src/book.vala"
	_g_free0 (self->priv->annotationTags);
#line 160 "../src/book.vala"
	self->priv->annotationTags = _tmp0_;
#line 693 "book.c"
}

gchar*
bookworm_app_book_getAnnotationTags (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 162 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 163 "../src/book.vala"
	_tmp0_ = self->priv->annotationTags;
#line 163 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 163 "../src/book.vala"
	result = _tmp1_;
#line 163 "../src/book.vala"
	return result;
#line 712 "book.c"
}

void
bookworm_app_book_setOPFFileLocation (BookwormAppBook* self,
                                      const gchar* aOPFFileLocation)
{
	gchar* _tmp0_;
#line 167 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 167 "../src/book.vala"
	g_return_if_fail (aOPFFileLocation != NULL);
#line 168 "../src/book.vala"
	_tmp0_ = g_strdup (aOPFFileLocation);
#line 168 "../src/book.vala"
	_g_free0 (self->priv->opfFileLocation);
#line 168 "../src/book.vala"
	self->priv->opfFileLocation = _tmp0_;
#line 730 "book.c"
}

gchar*
bookworm_app_book_getOPFFileLocation (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 170 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 171 "../src/book.vala"
	_tmp0_ = self->priv->opfFileLocation;
#line 171 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 171 "../src/book.vala"
	result = _tmp1_;
#line 171 "../src/book.vala"
	return result;
#line 749 "book.c"
}

void
bookworm_app_book_setBaseLocationOfContents (BookwormAppBook* self,
                                             const gchar* aBaseLocationOfContents)
{
	gchar* _tmp0_;
#line 175 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 175 "../src/book.vala"
	g_return_if_fail (aBaseLocationOfContents != NULL);
#line 176 "../src/book.vala"
	_tmp0_ = g_strdup (aBaseLocationOfContents);
#line 176 "../src/book.vala"
	_g_free0 (self->priv->baseLocationOfContents);
#line 176 "../src/book.vala"
	self->priv->baseLocationOfContents = _tmp0_;
#line 767 "book.c"
}

gchar*
bookworm_app_book_getBaseLocationOfContents (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 178 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 179 "../src/book.vala"
	_tmp0_ = self->priv->baseLocationOfContents;
#line 179 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 179 "../src/book.vala"
	result = _tmp1_;
#line 179 "../src/book.vala"
	return result;
#line 786 "book.c"
}

void
bookworm_app_book_setIsBookCoverImagePresent (BookwormAppBook* self,
                                              gboolean isABookCoverImagePresent)
{
#line 183 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 184 "../src/book.vala"
	self->priv->isBookCoverImagePresent = isABookCoverImagePresent;
#line 797 "book.c"
}

gboolean
bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self)
{
	gboolean result;
#line 186 "../src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 187 "../src/book.vala"
	result = self->priv->isBookCoverImagePresent;
#line 187 "../src/book.vala"
	return result;
#line 810 "book.c"
}

void
bookworm_app_book_setBookPublishDate (BookwormAppBook* self,
                                      const gchar* aBookPublishDate)
{
	gchar* _tmp0_;
#line 191 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 191 "../src/book.vala"
	g_return_if_fail (aBookPublishDate != NULL);
#line 192 "../src/book.vala"
	_tmp0_ = g_strdup (aBookPublishDate);
#line 192 "../src/book.vala"
	_g_free0 (self->priv->bookPublishDate);
#line 192 "../src/book.vala"
	self->priv->bookPublishDate = _tmp0_;
#line 828 "book.c"
}

gchar*
bookworm_app_book_getBookPublishDate (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 194 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 195 "../src/book.vala"
	_tmp0_ = self->priv->bookPublishDate;
#line 195 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 195 "../src/book.vala"
	result = _tmp1_;
#line 195 "../src/book.vala"
	return result;
#line 847 "book.c"
}

void
bookworm_app_book_setBookCreationDate (BookwormAppBook* self,
                                       const gchar* aBookCreationDate)
{
	gchar* _tmp0_;
#line 199 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 199 "../src/book.vala"
	g_return_if_fail (aBookCreationDate != NULL);
#line 200 "../src/book.vala"
	_tmp0_ = g_strdup (aBookCreationDate);
#line 200 "../src/book.vala"
	_g_free0 (self->priv->bookCreationDate);
#line 200 "../src/book.vala"
	self->priv->bookCreationDate = _tmp0_;
#line 865 "book.c"
}

gchar*
bookworm_app_book_getBookCreationDate (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 202 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 203 "../src/book.vala"
	_tmp0_ = self->priv->bookCreationDate;
#line 203 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 203 "../src/book.vala"
	result = _tmp1_;
#line 203 "../src/book.vala"
	return result;
#line 884 "book.c"
}

void
bookworm_app_book_setBookLastModificationDate (BookwormAppBook* self,
                                               const gchar* aBookLastModificationDate)
{
	gchar* _tmp0_;
#line 207 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 207 "../src/book.vala"
	g_return_if_fail (aBookLastModificationDate != NULL);
#line 208 "../src/book.vala"
	_tmp0_ = g_strdup (aBookLastModificationDate);
#line 208 "../src/book.vala"
	_g_free0 (self->priv->bookLastModificationDate);
#line 208 "../src/book.vala"
	self->priv->bookLastModificationDate = _tmp0_;
#line 902 "book.c"
}

gchar*
bookworm_app_book_getBookLastModificationDate (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 210 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 211 "../src/book.vala"
	_tmp0_ = self->priv->bookLastModificationDate;
#line 211 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 211 "../src/book.vala"
	result = _tmp1_;
#line 211 "../src/book.vala"
	return result;
#line 921 "book.c"
}

void
bookworm_app_book_setBookPageNumber (BookwormAppBook* self,
                                     gint aBookPageNumber)
{
#line 215 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 216 "../src/book.vala"
	self->priv->bookPageNumber = aBookPageNumber;
#line 932 "book.c"
}

gint
bookworm_app_book_getBookPageNumber (BookwormAppBook* self)
{
	gint result;
#line 218 "../src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 219 "../src/book.vala"
	result = self->priv->bookPageNumber;
#line 219 "../src/book.vala"
	return result;
#line 945 "book.c"
}

void
bookworm_app_book_setBookTotalPages (BookwormAppBook* self,
                                     gint aBookTotalPages)
{
#line 223 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 224 "../src/book.vala"
	self->priv->bookTotalPages = aBookTotalPages;
#line 956 "book.c"
}

gint
bookworm_app_book_getBookTotalPages (BookwormAppBook* self)
{
	gint result;
#line 226 "../src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 227 "../src/book.vala"
	result = self->priv->bookTotalPages;
#line 227 "../src/book.vala"
	return result;
#line 969 "book.c"
}

void
bookworm_app_book_setBookScrollPos (BookwormAppBook* self,
                                    gint aBookScrollPos)
{
#line 231 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 232 "../src/book.vala"
	self->priv->bookScrollPosition = aBookScrollPos;
#line 980 "book.c"
}

gint
bookworm_app_book_getBookScrollPos (BookwormAppBook* self)
{
	gint result;
#line 234 "../src/book.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 235 "../src/book.vala"
	result = self->priv->bookScrollPosition;
#line 235 "../src/book.vala"
	return result;
#line 993 "book.c"
}

void
bookworm_app_book_setIfPageForward (BookwormAppBook* self,
                                    gboolean ifBookPageForward)
{
#line 239 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 240 "../src/book.vala"
	self->priv->ifPageForward = ifBookPageForward;
#line 1004 "book.c"
}

gboolean
bookworm_app_book_getIfPageForward (BookwormAppBook* self)
{
	gboolean result;
#line 242 "../src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 243 "../src/book.vala"
	result = self->priv->ifPageForward;
#line 243 "../src/book.vala"
	return result;
#line 1017 "book.c"
}

void
bookworm_app_book_setIfPageBackward (BookwormAppBook* self,
                                     gboolean ifBookPageBackward)
{
#line 247 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 248 "../src/book.vala"
	self->priv->ifPageBackward = ifBookPageBackward;
#line 1028 "book.c"
}

gboolean
bookworm_app_book_getIfPageBackward (BookwormAppBook* self)
{
	gboolean result;
#line 250 "../src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 251 "../src/book.vala"
	result = self->priv->ifPageBackward;
#line 251 "../src/book.vala"
	return result;
#line 1041 "book.c"
}

void
bookworm_app_book_setIsBookSelected (BookwormAppBook* self,
                                     gboolean aIsBookSelected)
{
#line 255 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 256 "../src/book.vala"
	self->priv->isBookSelected = aIsBookSelected;
#line 1052 "book.c"
}

gboolean
bookworm_app_book_getIsBookSelected (BookwormAppBook* self)
{
	gboolean result;
#line 258 "../src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 259 "../src/book.vala"
	result = self->priv->isBookSelected;
#line 259 "../src/book.vala"
	return result;
#line 1065 "book.c"
}

void
bookworm_app_book_setWasBookOpened (BookwormAppBook* self,
                                    gboolean aWasBookOpened)
{
#line 263 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 264 "../src/book.vala"
	self->priv->wasBookOpened = aWasBookOpened;
#line 1076 "book.c"
}

gboolean
bookworm_app_book_getWasBookOpened (BookwormAppBook* self)
{
	gboolean result;
#line 266 "../src/book.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 267 "../src/book.vala"
	result = self->priv->wasBookOpened;
#line 267 "../src/book.vala"
	return result;
#line 1089 "book.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 1111 "book.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 1115 "book.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 1121 "book.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 1125 "book.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 1129 "book.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 1137 "book.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1165 "book.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 1174 "book.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 1188 "book.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 1197 "book.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 1211 "book.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 1220 "book.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 1229 "book.c"
}

void
bookworm_app_book_setBookmark (BookwormAppBook* self,
                               gint pageNumber,
                               const gchar* action)
{
#line 271 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 271 "../src/book.vala"
	g_return_if_fail (action != NULL);
#line 272 "../src/book.vala"
	if (g_strcmp0 ("ACTIVE_CLICKED", action) == 0) {
#line 1243 "book.c"
		GString* _tmp0_;
		GString* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 273 "../src/book.vala"
		_tmp0_ = self->priv->bookmarks;
#line 273 "../src/book.vala"
		_tmp1_ = self->priv->bookmarks;
#line 273 "../src/book.vala"
		_tmp2_ = _tmp1_->str;
#line 273 "../src/book.vala"
		_tmp3_ = g_strdup_printf ("%i", pageNumber);
#line 273 "../src/book.vala"
		_tmp4_ = _tmp3_;
#line 273 "../src/book.vala"
		_tmp5_ = g_strconcat ("**", _tmp4_, NULL);
#line 273 "../src/book.vala"
		_tmp6_ = _tmp5_;
#line 273 "../src/book.vala"
		_tmp7_ = g_strconcat (_tmp6_, "**", NULL);
#line 273 "../src/book.vala"
		_tmp8_ = _tmp7_;
#line 273 "../src/book.vala"
		_tmp9_ = string_replace (_tmp2_, _tmp8_, "");
#line 273 "../src/book.vala"
		_tmp10_ = _tmp9_;
#line 273 "../src/book.vala"
		g_string_assign (_tmp0_, _tmp10_);
#line 273 "../src/book.vala"
		_g_free0 (_tmp10_);
#line 273 "../src/book.vala"
		_g_free0 (_tmp8_);
#line 273 "../src/book.vala"
		_g_free0 (_tmp6_);
#line 273 "../src/book.vala"
		_g_free0 (_tmp4_);
#line 1287 "book.c"
	}
#line 275 "../src/book.vala"
	if (g_strcmp0 ("INACTIVE_CLICKED", action) == 0) {
#line 1291 "book.c"
		GString* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 276 "../src/book.vala"
		_tmp11_ = self->priv->bookmarks;
#line 276 "../src/book.vala"
		_tmp12_ = g_strdup_printf ("%i", pageNumber);
#line 276 "../src/book.vala"
		_tmp13_ = _tmp12_;
#line 276 "../src/book.vala"
		_tmp14_ = g_strconcat ("**", _tmp13_, NULL);
#line 276 "../src/book.vala"
		_tmp15_ = _tmp14_;
#line 276 "../src/book.vala"
		_tmp16_ = g_strconcat (_tmp15_, "**", NULL);
#line 276 "../src/book.vala"
		_tmp17_ = _tmp16_;
#line 276 "../src/book.vala"
		g_string_append (_tmp11_, _tmp17_);
#line 276 "../src/book.vala"
		_g_free0 (_tmp17_);
#line 276 "../src/book.vala"
		_g_free0 (_tmp15_);
#line 276 "../src/book.vala"
		_g_free0 (_tmp13_);
#line 1321 "book.c"
	}
#line 278 "../src/book.vala"
	if (pageNumber == -10) {
#line 1325 "book.c"
		GString* _tmp18_;
#line 280 "../src/book.vala"
		_tmp18_ = self->priv->bookmarks;
#line 280 "../src/book.vala"
		g_string_assign (_tmp18_, action);
#line 1331 "book.c"
	}
}

gchar*
bookworm_app_book_getBookmark (BookwormAppBook* self)
{
	GString* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* result;
#line 283 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 284 "../src/book.vala"
	_tmp0_ = self->priv->bookmarks;
#line 284 "../src/book.vala"
	_tmp1_ = _tmp0_->str;
#line 284 "../src/book.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 284 "../src/book.vala"
	result = _tmp2_;
#line 284 "../src/book.vala"
	return result;
#line 1354 "book.c"
}

void
bookworm_app_book_setAnnotations (BookwormAppBook* self,
                                  const gchar* index,
                                  const gchar* annotationText)
{
	gboolean _tmp0_ = FALSE;
#line 288 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 288 "../src/book.vala"
	g_return_if_fail (index != NULL);
#line 288 "../src/book.vala"
	g_return_if_fail (annotationText != NULL);
#line 290 "../src/book.vala"
	if (annotationText != NULL) {
#line 1371 "book.c"
		gint _tmp1_;
		gint _tmp2_;
#line 290 "../src/book.vala"
		_tmp1_ = strlen (annotationText);
#line 290 "../src/book.vala"
		_tmp2_ = _tmp1_;
#line 290 "../src/book.vala"
		_tmp0_ = _tmp2_ > 0;
#line 1380 "book.c"
	} else {
#line 290 "../src/book.vala"
		_tmp0_ = FALSE;
#line 1384 "book.c"
	}
#line 290 "../src/book.vala"
	if (_tmp0_) {
#line 1388 "book.c"
		GeeTreeMap* _tmp3_;
#line 292 "../src/book.vala"
		_tmp3_ = self->priv->annotationMap;
#line 292 "../src/book.vala"
		gee_abstract_map_set ((GeeAbstractMap*) _tmp3_, index, annotationText);
#line 1394 "book.c"
	} else {
		GeeTreeMap* _tmp4_;
#line 295 "../src/book.vala"
		_tmp4_ = self->priv->annotationMap;
#line 295 "../src/book.vala"
		if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp4_, index)) {
#line 1401 "book.c"
			GeeTreeMap* _tmp5_;
#line 296 "../src/book.vala"
			_tmp5_ = self->priv->annotationMap;
#line 296 "../src/book.vala"
			gee_abstract_map_unset ((GeeAbstractMap*) _tmp5_, index, NULL);
#line 1407 "book.c"
		}
	}
}

gchar*
bookworm_app_book_getAnnotations (BookwormAppBook* self,
                                  const gchar* index)
{
	GeeTreeMap* _tmp0_;
	gchar* result;
#line 300 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 300 "../src/book.vala"
	g_return_val_if_fail (index != NULL, NULL);
#line 301 "../src/book.vala"
	_tmp0_ = self->priv->annotationMap;
#line 301 "../src/book.vala"
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, index)) {
#line 1426 "book.c"
		GeeTreeMap* _tmp1_;
		gpointer _tmp2_;
#line 302 "../src/book.vala"
		_tmp1_ = self->priv->annotationMap;
#line 302 "../src/book.vala"
		_tmp2_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp1_, index);
#line 302 "../src/book.vala"
		result = (gchar*) _tmp2_;
#line 302 "../src/book.vala"
		return result;
#line 1437 "book.c"
	} else {
		gchar* _tmp3_;
#line 304 "../src/book.vala"
		_tmp3_ = g_strdup ("");
#line 304 "../src/book.vala"
		result = _tmp3_;
#line 304 "../src/book.vala"
		return result;
#line 1446 "book.c"
	}
}

GeeTreeMap*
bookworm_app_book_getAnnotationList (BookwormAppBook* self)
{
	GeeTreeMap* _tmp0_;
	GeeTreeMap* _tmp1_;
	GeeTreeMap* result;
#line 307 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 308 "../src/book.vala"
	_tmp0_ = self->priv->annotationMap;
#line 308 "../src/book.vala"
	_tmp1_ = _g_object_ref0 (_tmp0_);
#line 308 "../src/book.vala"
	result = _tmp1_;
#line 308 "../src/book.vala"
	return result;
#line 1466 "book.c"
}

void
bookworm_app_book_setAnnotationList (BookwormAppBook* self,
                                     GeeTreeMap* aTreeMap)
{
	GeeTreeMap* _tmp0_;
#line 310 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 310 "../src/book.vala"
	g_return_if_fail (aTreeMap != NULL);
#line 311 "../src/book.vala"
	_tmp0_ = self->priv->annotationMap;
#line 311 "../src/book.vala"
	gee_map_set_all ((GeeMap*) _tmp0_, (GeeMap*) aTreeMap);
#line 1482 "book.c"
}

void
bookworm_app_book_setBookWidget (BookwormAppBook* self,
                                 const gchar* name,
                                 GtkWidget* aWidget)
{
	GeeHashMap* _tmp0_;
#line 315 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 315 "../src/book.vala"
	g_return_if_fail (name != NULL);
#line 315 "../src/book.vala"
	g_return_if_fail (aWidget != NULL);
#line 316 "../src/book.vala"
	_tmp0_ = self->priv->bookWidgetsList;
#line 316 "../src/book.vala"
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, name, aWidget);
#line 1501 "book.c"
}

GtkWidget*
bookworm_app_book_getBookWidget (BookwormAppBook* self,
                                 const gchar* name)
{
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	GtkWidget* result;
#line 318 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 318 "../src/book.vala"
	g_return_val_if_fail (name != NULL, NULL);
#line 319 "../src/book.vala"
	_tmp0_ = self->priv->bookWidgetsList;
#line 319 "../src/book.vala"
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, name);
#line 319 "../src/book.vala"
	result = (GtkWidget*) _tmp1_;
#line 319 "../src/book.vala"
	return result;
#line 1523 "book.c"
}

void
bookworm_app_book_setAnchor (BookwormAppBook* self,
                             const gchar* aBookAnchor)
{
	gchar* _tmp0_;
#line 323 "../src/book.vala"
	g_return_if_fail (self != NULL);
#line 323 "../src/book.vala"
	g_return_if_fail (aBookAnchor != NULL);
#line 324 "../src/book.vala"
	_tmp0_ = g_strdup (aBookAnchor);
#line 324 "../src/book.vala"
	_g_free0 (self->priv->bookAnchor);
#line 324 "../src/book.vala"
	self->priv->bookAnchor = _tmp0_;
#line 1541 "book.c"
}

gchar*
bookworm_app_book_getAnchor (BookwormAppBook* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
#line 326 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 327 "../src/book.vala"
	_tmp0_ = self->priv->bookAnchor;
#line 327 "../src/book.vala"
	_tmp1_ = g_strdup (_tmp0_);
#line 327 "../src/book.vala"
	result = _tmp1_;
#line 327 "../src/book.vala"
	return result;
#line 1560 "book.c"
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
#line 37 "glib-2.0.vapi"
	if (self) {
#line 1569 "book.c"
		gchar* _tmp0_;
#line 38 "glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "glib-2.0.vapi"
		result = _tmp0_;
#line 38 "glib-2.0.vapi"
		return result;
#line 1577 "book.c"
	} else {
		gchar* _tmp1_;
#line 40 "glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "glib-2.0.vapi"
		result = _tmp1_;
#line 40 "glib-2.0.vapi"
		return result;
#line 1586 "book.c"
	}
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
#line 1624 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1625 "glib-2.0.vapi"
	result = self;
#line 1625 "glib-2.0.vapi"
	return result;
#line 1600 "book.c"
}

gchar*
bookworm_app_book_to_string (BookwormAppBook* self)
{
	GString* bookDetails = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GString* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	const gchar* _tmp8_;
	GString* _tmp9_;
	GString* _tmp10_;
	GString* _tmp11_;
	const gchar* _tmp12_;
	GString* _tmp13_;
	GString* _tmp14_;
	GString* _tmp15_;
	const gchar* _tmp16_;
	GString* _tmp17_;
	GString* _tmp18_;
	const gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	GString* _tmp22_;
	GString* _tmp23_;
	GString* _tmp24_;
	const gchar* _tmp25_;
	GString* _tmp26_;
	GString* _tmp27_;
	GString* _tmp28_;
	const gchar* _tmp29_;
	GString* _tmp30_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GString* _tmp35_;
	GString* _tmp36_;
	GString* _tmp37_;
	gchar* _tmp38_;
	gchar* _tmp39_;
	GString* _tmp40_;
	GString* _tmp41_;
	GString* _tmp42_;
	const gchar* _tmp43_;
	GString* _tmp44_;
	GString* _tmp45_;
	GString* _tmp46_;
	const gchar* _tmp47_;
	GString* _tmp48_;
	GString* _tmp49_;
	GString* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	GString* _tmp53_;
	GString* _tmp54_;
	GString* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	GString* _tmp58_;
	GString* _tmp59_;
	GString* _tmp60_;
	gchar* _tmp61_;
	gchar* _tmp62_;
	GString* _tmp63_;
	GString* _tmp64_;
	GString* _tmp65_;
	GString* _tmp66_;
	const gchar* _tmp67_;
	GString* _tmp68_;
	GString* _tmp69_;
	GString* _tmp70_;
	const gchar* _tmp71_;
	GString* _tmp72_;
	GString* _tmp73_;
	GString* _tmp74_;
	gchar* _tmp75_;
	gchar* _tmp76_;
	GString* _tmp77_;
	GString* _tmp78_;
	GString* _tmp79_;
	const gchar* _tmp80_;
	const gchar* _tmp81_;
	GString* _tmp82_;
	GString* _tmp83_;
	GString* _tmp84_;
	const gchar* _tmp85_;
	const gchar* _tmp86_;
	GString* _tmp87_;
	GString* _tmp88_;
	GString* _tmp108_;
	const gchar* _tmp109_;
	gchar* _tmp110_;
	gchar* result;
#line 331 "../src/book.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 332 "../src/book.vala"
	_tmp0_ = g_string_new ("");
#line 332 "../src/book.vala"
	bookDetails = _tmp0_;
#line 333 "../src/book.vala"
	_tmp1_ = bookDetails;
#line 333 "../src/book.vala"
	_tmp2_ = g_string_append (_tmp1_, "bookId=");
#line 333 "../src/book.vala"
	_tmp3_ = g_strdup_printf ("%i", self->priv->bookId);
#line 333 "../src/book.vala"
	_tmp4_ = _tmp3_;
#line 333 "../src/book.vala"
	_tmp5_ = g_string_append (_tmp2_, _tmp4_);
#line 333 "../src/book.vala"
	_tmp6_ = g_string_append (_tmp5_, ",\n");
#line 333 "../src/book.vala"
	_tmp7_ = g_string_append (_tmp6_, "bookLocation=");
#line 333 "../src/book.vala"
	_tmp8_ = self->priv->bookLocation;
#line 333 "../src/book.vala"
	_tmp9_ = g_string_append (_tmp7_, _tmp8_);
#line 333 "../src/book.vala"
	_tmp10_ = g_string_append (_tmp9_, ",\n");
#line 333 "../src/book.vala"
	_tmp11_ = g_string_append (_tmp10_, "bookCoverLocation=");
#line 333 "../src/book.vala"
	_tmp12_ = self->priv->bookCoverLocation;
#line 333 "../src/book.vala"
	_tmp13_ = g_string_append (_tmp11_, _tmp12_);
#line 333 "../src/book.vala"
	_tmp14_ = g_string_append (_tmp13_, ",\n");
#line 333 "../src/book.vala"
	_tmp15_ = g_string_append (_tmp14_, "bookExtractionLocation=");
#line 333 "../src/book.vala"
	_tmp16_ = self->priv->bookExtractionLocation;
#line 333 "../src/book.vala"
	_tmp17_ = g_string_append (_tmp15_, _tmp16_);
#line 333 "../src/book.vala"
	_tmp18_ = g_string_append (_tmp17_, ",\n");
#line 333 "../src/book.vala"
	_tmp19_ = self->priv->bookTitle;
#line 333 "../src/book.vala"
	_tmp20_ = g_strconcat ("bookTitle=", _tmp19_, NULL);
#line 333 "../src/book.vala"
	_tmp21_ = _tmp20_;
#line 333 "../src/book.vala"
	_tmp22_ = g_string_append (_tmp18_, _tmp21_);
#line 333 "../src/book.vala"
	_tmp23_ = g_string_append (_tmp22_, ",\n");
#line 333 "../src/book.vala"
	_tmp24_ = g_string_append (_tmp23_, "opfFileLocation=");
#line 333 "../src/book.vala"
	_tmp25_ = self->priv->opfFileLocation;
#line 333 "../src/book.vala"
	_tmp26_ = g_string_append (_tmp24_, _tmp25_);
#line 333 "../src/book.vala"
	_tmp27_ = g_string_append (_tmp26_, ",\n");
#line 333 "../src/book.vala"
	_tmp28_ = g_string_append (_tmp27_, "baseLocationOfContents=");
#line 333 "../src/book.vala"
	_tmp29_ = self->priv->baseLocationOfContents;
#line 333 "../src/book.vala"
	_tmp30_ = g_string_append (_tmp28_, _tmp29_);
#line 333 "../src/book.vala"
	_tmp31_ = g_string_append (_tmp30_, ",\n");
#line 333 "../src/book.vala"
	_tmp32_ = self->priv->bookPublishDate;
#line 333 "../src/book.vala"
	_tmp33_ = g_strconcat ("bookPublishDate=", _tmp32_, NULL);
#line 333 "../src/book.vala"
	_tmp34_ = _tmp33_;
#line 333 "../src/book.vala"
	_tmp35_ = g_string_append (_tmp31_, _tmp34_);
#line 333 "../src/book.vala"
	_tmp36_ = g_string_append (_tmp35_, ",\n");
#line 333 "../src/book.vala"
	_tmp37_ = g_string_append (_tmp36_, "isBookCoverImagePresent=");
#line 333 "../src/book.vala"
	_tmp38_ = bool_to_string (self->priv->isBookCoverImagePresent);
#line 333 "../src/book.vala"
	_tmp39_ = _tmp38_;
#line 333 "../src/book.vala"
	_tmp40_ = g_string_append (_tmp37_, _tmp39_);
#line 333 "../src/book.vala"
	_tmp41_ = g_string_append (_tmp40_, ",\n");
#line 333 "../src/book.vala"
	_tmp42_ = g_string_append (_tmp41_, "bookCreationDate=");
#line 333 "../src/book.vala"
	_tmp43_ = self->priv->bookCreationDate;
#line 333 "../src/book.vala"
	_tmp44_ = g_string_append (_tmp42_, _tmp43_);
#line 333 "../src/book.vala"
	_tmp45_ = g_string_append (_tmp44_, ",\n");
#line 333 "../src/book.vala"
	_tmp46_ = g_string_append (_tmp45_, "bookLastModificationDate=");
#line 333 "../src/book.vala"
	_tmp47_ = self->priv->bookLastModificationDate;
#line 333 "../src/book.vala"
	_tmp48_ = g_string_append (_tmp46_, _tmp47_);
#line 333 "../src/book.vala"
	_tmp49_ = g_string_append (_tmp48_, ",\n");
#line 333 "../src/book.vala"
	_tmp50_ = g_string_append (_tmp49_, "bookPageNumber=");
#line 333 "../src/book.vala"
	_tmp51_ = g_strdup_printf ("%i", self->priv->bookPageNumber);
#line 333 "../src/book.vala"
	_tmp52_ = _tmp51_;
#line 333 "../src/book.vala"
	_tmp53_ = g_string_append (_tmp50_, _tmp52_);
#line 333 "../src/book.vala"
	_tmp54_ = g_string_append (_tmp53_, ",\n");
#line 333 "../src/book.vala"
	_tmp55_ = g_string_append (_tmp54_, "ifPageForward=");
#line 333 "../src/book.vala"
	_tmp56_ = bool_to_string (self->priv->ifPageForward);
#line 333 "../src/book.vala"
	_tmp57_ = _tmp56_;
#line 333 "../src/book.vala"
	_tmp58_ = g_string_append (_tmp55_, _tmp57_);
#line 333 "../src/book.vala"
	_tmp59_ = g_string_append (_tmp58_, ",\n");
#line 333 "../src/book.vala"
	_tmp60_ = g_string_append (_tmp59_, "ifPageBackward=");
#line 333 "../src/book.vala"
	_tmp61_ = bool_to_string (self->priv->ifPageBackward);
#line 333 "../src/book.vala"
	_tmp62_ = _tmp61_;
#line 333 "../src/book.vala"
	_tmp63_ = g_string_append (_tmp60_, _tmp62_);
#line 333 "../src/book.vala"
	_tmp64_ = g_string_append (_tmp63_, ",\n");
#line 333 "../src/book.vala"
	_tmp65_ = g_string_append (_tmp64_, "bookmarks=");
#line 333 "../src/book.vala"
	_tmp66_ = self->priv->bookmarks;
#line 333 "../src/book.vala"
	_tmp67_ = _tmp66_->str;
#line 333 "../src/book.vala"
	_tmp68_ = g_string_append (_tmp65_, _tmp67_);
#line 333 "../src/book.vala"
	_tmp69_ = g_string_append (_tmp68_, ",\n");
#line 333 "../src/book.vala"
	_tmp70_ = g_string_append (_tmp69_, "author=");
#line 333 "../src/book.vala"
	_tmp71_ = self->priv->bookAuthor;
#line 333 "../src/book.vala"
	_tmp72_ = g_string_append (_tmp70_, _tmp71_);
#line 333 "../src/book.vala"
	_tmp73_ = g_string_append (_tmp72_, ",\n");
#line 333 "../src/book.vala"
	_tmp74_ = g_string_append (_tmp73_, "ratings=");
#line 333 "../src/book.vala"
	_tmp75_ = g_strdup_printf ("%i", self->priv->bookRating);
#line 333 "../src/book.vala"
	_tmp76_ = _tmp75_;
#line 333 "../src/book.vala"
	_tmp77_ = g_string_append (_tmp74_, _tmp76_);
#line 333 "../src/book.vala"
	_tmp78_ = g_string_append (_tmp77_, ",\n");
#line 333 "../src/book.vala"
	_tmp79_ = g_string_append (_tmp78_, "tags=");
#line 333 "../src/book.vala"
	_tmp80_ = self->priv->bookTags;
#line 333 "../src/book.vala"
	_tmp81_ = string_to_string (_tmp80_);
#line 333 "../src/book.vala"
	_tmp82_ = g_string_append (_tmp79_, _tmp81_);
#line 333 "../src/book.vala"
	_tmp83_ = g_string_append (_tmp82_, ",\n");
#line 333 "../src/book.vala"
	_tmp84_ = g_string_append (_tmp83_, "annotation tags=");
#line 333 "../src/book.vala"
	_tmp85_ = self->priv->annotationTags;
#line 333 "../src/book.vala"
	_tmp86_ = string_to_string (_tmp85_);
#line 333 "../src/book.vala"
	_tmp87_ = g_string_append (_tmp84_, _tmp86_);
#line 333 "../src/book.vala"
	_tmp88_ = g_string_append (_tmp87_, ",\n");
#line 333 "../src/book.vala"
	g_string_append (_tmp88_, "bookContentList=");
#line 333 "../src/book.vala"
	_g_free0 (_tmp76_);
#line 333 "../src/book.vala"
	_g_free0 (_tmp62_);
#line 333 "../src/book.vala"
	_g_free0 (_tmp57_);
#line 333 "../src/book.vala"
	_g_free0 (_tmp52_);
#line 333 "../src/book.vala"
	_g_free0 (_tmp39_);
#line 333 "../src/book.vala"
	_g_free0 (_tmp34_);
#line 333 "../src/book.vala"
	_g_free0 (_tmp21_);
#line 333 "../src/book.vala"
	_g_free0 (_tmp4_);
#line 1900 "book.c"
	{
		gint i = 0;
#line 353 "../src/book.vala"
		i = 0;
#line 1905 "book.c"
		{
			gboolean _tmp89_ = FALSE;
#line 353 "../src/book.vala"
			_tmp89_ = TRUE;
#line 353 "../src/book.vala"
			while (TRUE) {
#line 1912 "book.c"
				GeeArrayList* _tmp91_;
				gint _tmp92_;
				gint _tmp93_;
				GString* _tmp94_;
				gchar* _tmp95_;
				gchar* _tmp96_;
				gchar* _tmp97_;
				gchar* _tmp98_;
				gchar* _tmp99_;
				gchar* _tmp100_;
				GeeArrayList* _tmp101_;
				gpointer _tmp102_;
				gchar* _tmp103_;
				gchar* _tmp104_;
				gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
#line 353 "../src/book.vala"
				if (!_tmp89_) {
#line 1932 "book.c"
					gint _tmp90_;
#line 353 "../src/book.vala"
					_tmp90_ = i;
#line 353 "../src/book.vala"
					i = _tmp90_ + 1;
#line 1938 "book.c"
				}
#line 353 "../src/book.vala"
				_tmp89_ = FALSE;
#line 353 "../src/book.vala"
				_tmp91_ = self->priv->bookContentList;
#line 353 "../src/book.vala"
				_tmp92_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp91_);
#line 353 "../src/book.vala"
				_tmp93_ = _tmp92_;
#line 353 "../src/book.vala"
				if (!(i < _tmp93_)) {
#line 353 "../src/book.vala"
					break;
#line 1952 "book.c"
				}
#line 354 "../src/book.vala"
				_tmp94_ = bookDetails;
#line 354 "../src/book.vala"
				_tmp95_ = g_strdup_printf ("%i", i);
#line 354 "../src/book.vala"
				_tmp96_ = _tmp95_;
#line 354 "../src/book.vala"
				_tmp97_ = g_strconcat ("[", _tmp96_, NULL);
#line 354 "../src/book.vala"
				_tmp98_ = _tmp97_;
#line 354 "../src/book.vala"
				_tmp99_ = g_strconcat (_tmp98_, "]=", NULL);
#line 354 "../src/book.vala"
				_tmp100_ = _tmp99_;
#line 354 "../src/book.vala"
				_tmp101_ = self->priv->bookContentList;
#line 354 "../src/book.vala"
				_tmp102_ = gee_abstract_list_get ((GeeAbstractList*) _tmp101_, i);
#line 354 "../src/book.vala"
				_tmp103_ = (gchar*) _tmp102_;
#line 354 "../src/book.vala"
				_tmp104_ = g_strconcat (_tmp100_, _tmp103_, NULL);
#line 354 "../src/book.vala"
				_tmp105_ = _tmp104_;
#line 354 "../src/book.vala"
				_tmp106_ = g_strconcat (_tmp105_, ",", NULL);
#line 354 "../src/book.vala"
				_tmp107_ = _tmp106_;
#line 354 "../src/book.vala"
				g_string_append (_tmp94_, _tmp107_);
#line 354 "../src/book.vala"
				_g_free0 (_tmp107_);
#line 354 "../src/book.vala"
				_g_free0 (_tmp105_);
#line 354 "../src/book.vala"
				_g_free0 (_tmp103_);
#line 354 "../src/book.vala"
				_g_free0 (_tmp100_);
#line 354 "../src/book.vala"
				_g_free0 (_tmp98_);
#line 354 "../src/book.vala"
				_g_free0 (_tmp96_);
#line 1996 "book.c"
			}
		}
	}
#line 356 "../src/book.vala"
	_tmp108_ = bookDetails;
#line 356 "../src/book.vala"
	_tmp109_ = _tmp108_->str;
#line 356 "../src/book.vala"
	_tmp110_ = g_strdup (_tmp109_);
#line 356 "../src/book.vala"
	result = _tmp110_;
#line 356 "../src/book.vala"
	_g_string_free0 (bookDetails);
#line 356 "../src/book.vala"
	return result;
#line 2012 "book.c"
}

BookwormAppBook*
bookworm_app_book_construct (GType object_type)
{
	BookwormAppBook* self = NULL;
#line 21 "../src/book.vala"
	self = (BookwormAppBook*) g_type_create_instance (object_type);
#line 21 "../src/book.vala"
	return self;
#line 2023 "book.c"
}

BookwormAppBook*
bookworm_app_book_new (void)
{
#line 21 "../src/book.vala"
	return bookworm_app_book_construct (BOOKWORM_APP_TYPE_BOOK);
#line 2031 "book.c"
}

static void
bookworm_app_value_book_init (GValue* value)
{
#line 21 "../src/book.vala"
	value->data[0].v_pointer = NULL;
#line 2039 "book.c"
}

static void
bookworm_app_value_book_free_value (GValue* value)
{
#line 21 "../src/book.vala"
	if (value->data[0].v_pointer) {
#line 21 "../src/book.vala"
		bookworm_app_book_unref (value->data[0].v_pointer);
#line 2049 "book.c"
	}
}

static void
bookworm_app_value_book_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
#line 21 "../src/book.vala"
	if (src_value->data[0].v_pointer) {
#line 21 "../src/book.vala"
		dest_value->data[0].v_pointer = bookworm_app_book_ref (src_value->data[0].v_pointer);
#line 2061 "book.c"
	} else {
#line 21 "../src/book.vala"
		dest_value->data[0].v_pointer = NULL;
#line 2065 "book.c"
	}
}

static gpointer
bookworm_app_value_book_peek_pointer (const GValue* value)
{
#line 21 "../src/book.vala"
	return value->data[0].v_pointer;
#line 2074 "book.c"
}

static gchar*
bookworm_app_value_book_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
#line 21 "../src/book.vala"
	if (collect_values[0].v_pointer) {
#line 2085 "book.c"
		BookwormAppBook * object;
		object = collect_values[0].v_pointer;
#line 21 "../src/book.vala"
		if (object->parent_instance.g_class == NULL) {
#line 21 "../src/book.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2092 "book.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 21 "../src/book.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 2096 "book.c"
		}
#line 21 "../src/book.vala"
		value->data[0].v_pointer = bookworm_app_book_ref (object);
#line 2100 "book.c"
	} else {
#line 21 "../src/book.vala"
		value->data[0].v_pointer = NULL;
#line 2104 "book.c"
	}
#line 21 "../src/book.vala"
	return NULL;
#line 2108 "book.c"
}

static gchar*
bookworm_app_value_book_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	BookwormAppBook ** object_p;
	object_p = collect_values[0].v_pointer;
#line 21 "../src/book.vala"
	if (!object_p) {
#line 21 "../src/book.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 2123 "book.c"
	}
#line 21 "../src/book.vala"
	if (!value->data[0].v_pointer) {
#line 21 "../src/book.vala"
		*object_p = NULL;
#line 2129 "book.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 21 "../src/book.vala"
		*object_p = value->data[0].v_pointer;
#line 2133 "book.c"
	} else {
#line 21 "../src/book.vala"
		*object_p = bookworm_app_book_ref (value->data[0].v_pointer);
#line 2137 "book.c"
	}
#line 21 "../src/book.vala"
	return NULL;
#line 2141 "book.c"
}

GParamSpec*
bookworm_app_param_spec_book (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	BookwormAppParamSpecBook* spec;
#line 21 "../src/book.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_BOOK), NULL);
#line 21 "../src/book.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 21 "../src/book.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 21 "../src/book.vala"
	return G_PARAM_SPEC (spec);
#line 2160 "book.c"
}

gpointer
bookworm_app_value_get_book (const GValue* value)
{
#line 21 "../src/book.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_BOOK), NULL);
#line 21 "../src/book.vala"
	return value->data[0].v_pointer;
#line 2170 "book.c"
}

void
bookworm_app_value_set_book (GValue* value,
                             gpointer v_object)
{
	BookwormAppBook * old;
#line 21 "../src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_BOOK));
#line 21 "../src/book.vala"
	old = value->data[0].v_pointer;
#line 21 "../src/book.vala"
	if (v_object) {
#line 21 "../src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_BOOK));
#line 21 "../src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "../src/book.vala"
		value->data[0].v_pointer = v_object;
#line 21 "../src/book.vala"
		bookworm_app_book_ref (value->data[0].v_pointer);
#line 2192 "book.c"
	} else {
#line 21 "../src/book.vala"
		value->data[0].v_pointer = NULL;
#line 2196 "book.c"
	}
#line 21 "../src/book.vala"
	if (old) {
#line 21 "../src/book.vala"
		bookworm_app_book_unref (old);
#line 2202 "book.c"
	}
}

void
bookworm_app_value_take_book (GValue* value,
                              gpointer v_object)
{
	BookwormAppBook * old;
#line 21 "../src/book.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_BOOK));
#line 21 "../src/book.vala"
	old = value->data[0].v_pointer;
#line 21 "../src/book.vala"
	if (v_object) {
#line 21 "../src/book.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_BOOK));
#line 21 "../src/book.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 21 "../src/book.vala"
		value->data[0].v_pointer = v_object;
#line 2223 "book.c"
	} else {
#line 21 "../src/book.vala"
		value->data[0].v_pointer = NULL;
#line 2227 "book.c"
	}
#line 21 "../src/book.vala"
	if (old) {
#line 21 "../src/book.vala"
		bookworm_app_book_unref (old);
#line 2233 "book.c"
	}
}

static void
bookworm_app_book_class_init (BookwormAppBookClass * klass,
                              gpointer klass_data)
{
#line 21 "../src/book.vala"
	bookworm_app_book_parent_class = g_type_class_peek_parent (klass);
#line 21 "../src/book.vala"
	((BookwormAppBookClass *) klass)->finalize = bookworm_app_book_finalize;
#line 21 "../src/book.vala"
	g_type_class_adjust_private_offset (klass, &BookwormAppBook_private_offset);
#line 2247 "book.c"
}

static void
bookworm_app_book_instance_init (BookwormAppBook * self,
                                 gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	GString* _tmp11_;
	GeeTreeMap* _tmp12_;
	GeeArrayList* _tmp13_;
	GeeArrayList* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	GeeHashMap* _tmp18_;
#line 21 "../src/book.vala"
	self->priv = bookworm_app_book_get_instance_private (self);
#line 23 "../src/book.vala"
	self->priv->bookId = 0;
#line 24 "../src/book.vala"
	self->priv->isBookParsedCorrectly = FALSE;
#line 25 "../src/book.vala"
	_tmp0_ = g_strdup ("");
#line 25 "../src/book.vala"
	self->priv->parsingIssue = _tmp0_;
#line 26 "../src/book.vala"
	_tmp1_ = g_strdup ("");
#line 26 "../src/book.vala"
	self->priv->bookLocation = _tmp1_;
#line 27 "../src/book.vala"
	_tmp2_ = g_strdup ("");
#line 27 "../src/book.vala"
	self->priv->bookCoverLocation = _tmp2_;
#line 28 "../src/book.vala"
	_tmp3_ = g_strdup ("");
#line 28 "../src/book.vala"
	self->priv->bookExtractionLocation = _tmp3_;
#line 29 "../src/book.vala"
	_tmp4_ = g_strdup ("");
#line 29 "../src/book.vala"
	self->priv->bookTitle = _tmp4_;
#line 30 "../src/book.vala"
	_tmp5_ = g_strdup ("");
#line 30 "../src/book.vala"
	self->priv->bookAuthor = _tmp5_;
#line 31 "../src/book.vala"
	_tmp6_ = g_strdup ("");
#line 31 "../src/book.vala"
	self->priv->bookTags = _tmp6_;
#line 32 "../src/book.vala"
	_tmp7_ = g_strdup ("");
#line 32 "../src/book.vala"
	self->priv->annotationTags = _tmp7_;
#line 33 "../src/book.vala"
	_tmp8_ = g_strdup ("");
#line 33 "../src/book.vala"
	self->priv->bookPublishDate = _tmp8_;
#line 34 "../src/book.vala"
	_tmp9_ = g_strdup ("");
#line 34 "../src/book.vala"
	self->priv->bookCreationDate = _tmp9_;
#line 35 "../src/book.vala"
	_tmp10_ = g_strdup ("");
#line 35 "../src/book.vala"
	self->priv->bookLastModificationDate = _tmp10_;
#line 36 "../src/book.vala"
	self->priv->bookPageNumber = -1;
#line 37 "../src/book.vala"
	self->priv->bookTotalPages = 1;
#line 38 "../src/book.vala"
	self->priv->bookScrollPosition = -1;
#line 39 "../src/book.vala"
	self->priv->bookRating = 0;
#line 40 "../src/book.vala"
	self->priv->isBookCoverImagePresent = FALSE;
#line 41 "../src/book.vala"
	_tmp11_ = g_string_new ("");
#line 41 "../src/book.vala"
	self->priv->bookmarks = _tmp11_;
#line 42 "../src/book.vala"
	_tmp12_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
#line 42 "../src/book.vala"
	self->priv->annotationMap = _tmp12_;
#line 43 "../src/book.vala"
	_tmp13_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
#line 43 "../src/book.vala"
	self->priv->bookContentList = _tmp13_;
#line 44 "../src/book.vala"
	_tmp14_ = gee_array_list_new (GEE_TYPE_HASH_MAP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
#line 44 "../src/book.vala"
	self->priv->TOCMap = _tmp14_;
#line 47 "../src/book.vala"
	_tmp15_ = g_strdup ("");
#line 47 "../src/book.vala"
	self->priv->opfFileLocation = _tmp15_;
#line 48 "../src/book.vala"
	_tmp16_ = g_strdup ("");
#line 48 "../src/book.vala"
	self->priv->baseLocationOfContents = _tmp16_;
#line 49 "../src/book.vala"
	self->priv->ifPageForward = TRUE;
#line 50 "../src/book.vala"
	self->priv->ifPageBackward = TRUE;
#line 51 "../src/book.vala"
	self->priv->isBookSelected = FALSE;
#line 52 "../src/book.vala"
	self->priv->wasBookOpened = FALSE;
#line 53 "../src/book.vala"
	_tmp17_ = g_strdup ("");
#line 53 "../src/book.vala"
	self->priv->bookAnchor = _tmp17_;
#line 54 "../src/book.vala"
	_tmp18_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gtk_widget_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 54 "../src/book.vala"
	self->priv->bookWidgetsList = _tmp18_;
#line 21 "../src/book.vala"
	self->ref_count = 1;
#line 2375 "book.c"
}

static void
bookworm_app_book_finalize (BookwormAppBook * obj)
{
	BookwormAppBook * self;
#line 21 "../src/book.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_BOOK, BookwormAppBook);
#line 21 "../src/book.vala"
	g_signal_handlers_destroy (self);
#line 25 "../src/book.vala"
	_g_free0 (self->priv->parsingIssue);
#line 26 "../src/book.vala"
	_g_free0 (self->priv->bookLocation);
#line 27 "../src/book.vala"
	_g_free0 (self->priv->bookCoverLocation);
#line 28 "../src/book.vala"
	_g_free0 (self->priv->bookExtractionLocation);
#line 29 "../src/book.vala"
	_g_free0 (self->priv->bookTitle);
#line 30 "../src/book.vala"
	_g_free0 (self->priv->bookAuthor);
#line 31 "../src/book.vala"
	_g_free0 (self->priv->bookTags);
#line 32 "../src/book.vala"
	_g_free0 (self->priv->annotationTags);
#line 33 "../src/book.vala"
	_g_free0 (self->priv->bookPublishDate);
#line 34 "../src/book.vala"
	_g_free0 (self->priv->bookCreationDate);
#line 35 "../src/book.vala"
	_g_free0 (self->priv->bookLastModificationDate);
#line 41 "../src/book.vala"
	_g_string_free0 (self->priv->bookmarks);
#line 42 "../src/book.vala"
	_g_object_unref0 (self->priv->annotationMap);
#line 43 "../src/book.vala"
	_g_object_unref0 (self->priv->bookContentList);
#line 44 "../src/book.vala"
	_g_object_unref0 (self->priv->TOCMap);
#line 47 "../src/book.vala"
	_g_free0 (self->priv->opfFileLocation);
#line 48 "../src/book.vala"
	_g_free0 (self->priv->baseLocationOfContents);
#line 53 "../src/book.vala"
	_g_free0 (self->priv->bookAnchor);
#line 54 "../src/book.vala"
	_g_object_unref0 (self->priv->bookWidgetsList);
#line 2424 "book.c"
}

static GType
bookworm_app_book_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_book_init, bookworm_app_value_book_free_value, bookworm_app_value_book_copy_value, bookworm_app_value_book_peek_pointer, "p", bookworm_app_value_book_collect_value, "p", bookworm_app_value_book_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppBookClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_book_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppBook), 0, (GInstanceInitFunc) bookworm_app_book_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_book_type_id;
	bookworm_app_book_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppBook", &g_define_type_info, &g_define_type_fundamental_info, 0);
	BookwormAppBook_private_offset = g_type_add_instance_private (bookworm_app_book_type_id, sizeof (BookwormAppBookPrivate));
	return bookworm_app_book_type_id;
}

GType
bookworm_app_book_get_type (void)
{
	static volatile gsize bookworm_app_book_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_book_type_id__once)) {
		GType bookworm_app_book_type_id;
		bookworm_app_book_type_id = bookworm_app_book_get_type_once ();
		g_once_init_leave (&bookworm_app_book_type_id__once, bookworm_app_book_type_id);
	}
	return bookworm_app_book_type_id__once;
}

gpointer
bookworm_app_book_ref (gpointer instance)
{
	BookwormAppBook * self;
	self = instance;
#line 21 "../src/book.vala"
	g_atomic_int_inc (&self->ref_count);
#line 21 "../src/book.vala"
	return instance;
#line 2460 "book.c"
}

void
bookworm_app_book_unref (gpointer instance)
{
	BookwormAppBook * self;
	self = instance;
#line 21 "../src/book.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 21 "../src/book.vala"
		BOOKWORM_APP_BOOK_GET_CLASS (self)->finalize (self);
#line 21 "../src/book.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 2474 "book.c"
	}
}

