/* 
 * JGimp - A Java extension for the GIMP
 * Copyright (C) 2002  Georgia Tech Research Corp.
 * Written by Michael Terry, mterry@cc.gatech.edu
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

package org.gimp.jgimp;


/**
 * Exception thrown when a read buffer is too small
 * to hold all the pixels for the area desired.
 */
public class JGimpBufferOverflowException extends JGimpException {

    public JGimpBufferOverflowException(
        int x,
        int y,
        int desiredWidth,
        int desiredHeight,
        int actualWidth,
        int actualHeight,
        int bytesPerPixel,
        int numBytesInArray) {
        super(
            "Buffer overflow exception. desired x: "
                + x
                + " desired y: "
                + y
                + " desired width: "
                + desiredWidth
                + " desired height: "
                + desiredHeight
                + " actual width: "
                + actualWidth
                + " actual height: "
                + actualHeight
                + " bytes per pixel: "
                + bytesPerPixel
                + " number of bytes in array: "
                + numBytesInArray);
    }
}
