# PonyCheck
<span class="source-link">[[Source]](src/pony_check/pony_check.md#L-0-105)</span>
```pony
primitive val PonyCheck
```

## Constructors

### create
<span class="source-link">[[Source]](src/pony_check/pony_check.md#L-0-105)</span>


```pony
new val create()
: PonyCheck val^
```

#### Returns

* [PonyCheck](pony_check-PonyCheck.md) val^

---

## Public Functions

### for_all\[T: T\]
<span class="source-link">[[Source]](src/pony_check/pony_check.md#L-0-106)</span>


Convenience method for running 1 to many properties as part of
one PonyTest UnitTest.

Example:

```pony
  class MyTestWithSomeProperties is UnitTest
    fun name(): String => "mytest/withMultipleProperties"

    fun apply(h: TestHelper) =>
      PonyCheck.for_all[U8](recover Generators.unit[U8](0) end, h)(
        {(u, h) =>
          h.assert_eq(u, 0)
          consume u
        })
```


```pony
fun box for_all[T: T](
  gen: Generator[T] val,
  h: TestHelper val)
: ForAll[T] ref
```
#### Parameters

*   gen: [Generator](pony_check-Generator.md)\[T\] val
*   h: [TestHelper](pony_test-TestHelper.md) val

#### Returns

* [ForAll](pony_check-ForAll.md)\[T\] ref

---

### for_all2\[T1: T1, T2: T2\]
<span class="source-link">[[Source]](src/pony_check/pony_check.md#L-0-127)</span>


```pony
fun box for_all2[T1: T1, T2: T2](
  gen1: Generator[T1] val,
  gen2: Generator[T2] val,
  h: TestHelper val)
: ForAll2[T1, T2] ref
```
#### Parameters

*   gen1: [Generator](pony_check-Generator.md)\[T1\] val
*   gen2: [Generator](pony_check-Generator.md)\[T2\] val
*   h: [TestHelper](pony_test-TestHelper.md) val

#### Returns

* [ForAll2](pony_check-ForAll2.md)\[T1, T2\] ref

---

### for_all3\[T1: T1, T2: T2, T3: T3\]
<span class="source-link">[[Source]](src/pony_check/pony_check.md#L-0-135)</span>


```pony
fun box for_all3[T1: T1, T2: T2, T3: T3](
  gen1: Generator[T1] val,
  gen2: Generator[T2] val,
  gen3: Generator[T3] val,
  h: TestHelper val)
: ForAll3[T1, T2, T3] ref
```
#### Parameters

*   gen1: [Generator](pony_check-Generator.md)\[T1\] val
*   gen2: [Generator](pony_check-Generator.md)\[T2\] val
*   gen3: [Generator](pony_check-Generator.md)\[T3\] val
*   h: [TestHelper](pony_test-TestHelper.md) val

#### Returns

* [ForAll3](pony_check-ForAll3.md)\[T1, T2, T3\] ref

---

### for_all4\[T1: T1, T2: T2, T3: T3, T4: T4\]
<span class="source-link">[[Source]](src/pony_check/pony_check.md#L-0-144)</span>


```pony
fun box for_all4[T1: T1, T2: T2, T3: T3, T4: T4](
  gen1: Generator[T1] val,
  gen2: Generator[T2] val,
  gen3: Generator[T3] val,
  gen4: Generator[T4] val,
  h: TestHelper val)
: ForAll4[T1, T2, T3, T4] ref
```
#### Parameters

*   gen1: [Generator](pony_check-Generator.md)\[T1\] val
*   gen2: [Generator](pony_check-Generator.md)\[T2\] val
*   gen3: [Generator](pony_check-Generator.md)\[T3\] val
*   gen4: [Generator](pony_check-Generator.md)\[T4\] val
*   h: [TestHelper](pony_test-TestHelper.md) val

#### Returns

* [ForAll4](pony_check-ForAll4.md)\[T1, T2, T3, T4\] ref

---

### eq
<span class="source-link">[[Source]](src/pony_check/pony_check.md#L-0-106)</span>


```pony
fun box eq(
  that: PonyCheck val)
: Bool val
```
#### Parameters

*   that: [PonyCheck](pony_check-PonyCheck.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

### ne
<span class="source-link">[[Source]](src/pony_check/pony_check.md#L-0-106)</span>


```pony
fun box ne(
  that: PonyCheck val)
: Bool val
```
#### Parameters

*   that: [PonyCheck](pony_check-PonyCheck.md) val

#### Returns

* [Bool](builtin-Bool.md) val

---

