/*
 * Decompiled with CFR 0.152.
 */
package oracle.ucp.routing;

import java.util.ArrayList;
import java.util.List;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import oracle.jdbc.OracleShardingKey;
import oracle.jdbc.pool.OracleShardingKeyImpl;
import oracle.ucp.routing.SuperShardingKeys;
import oracle.ucp.util.Pair;

class ListSuperShardingKeys
implements SuperShardingKeys {
    private final NavigableSet<OracleShardingKeyImpl> superKeys;
    private final OracleShardingKeyImpl[] aSuperKeys;

    ListSuperShardingKeys(List<OracleShardingKeyImpl> keys) {
        this.superKeys = new TreeSet<OracleShardingKeyImpl>(keys);
        this.aSuperKeys = this.superKeys.toArray(new OracleShardingKeyImpl[this.superKeys.size()]);
    }

    @Override
    public boolean contains(OracleShardingKey superKey) {
        return this.superKeys.contains(superKey);
    }

    public int hashCode() {
        return this.superKeys.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSuperShardingKeys)) {
            return false;
        }
        ListSuperShardingKeys oList = (ListSuperShardingKeys)obj;
        return this.superKeys.equals(oList.superKeys);
    }

    public String toString() {
        if (this.superKeys == null || this.superKeys.isEmpty()) {
            return "";
        }
        return "[" + this.superKeys.stream().map(x -> x.toString()).collect(Collectors.joining(",")) + "]";
    }

    @Override
    public int compareTo(SuperShardingKeys other) {
        int thatSize;
        if (other == null || !(other instanceof ListSuperShardingKeys)) {
            return 1;
        }
        ListSuperShardingKeys that = (ListSuperShardingKeys)other;
        int thisSize = this.superKeys.size();
        int dif = thisSize - (thatSize = that.superKeys.size());
        if (0 != dif) {
            return dif;
        }
        for (int i = 0; i < thisSize; ++i) {
            int res = this.aSuperKeys[i].compareTo((OracleShardingKey)that.aSuperKeys[i]);
            if (res == 0) continue;
            return res;
        }
        return 0;
    }

    @Override
    public List<Pair<OracleShardingKey, OracleShardingKey>> getKeys() {
        ArrayList<Pair<OracleShardingKey, OracleShardingKey>> pairs = new ArrayList<Pair<OracleShardingKey, OracleShardingKey>>();
        for (int i = 0; i < this.aSuperKeys.length; ++i) {
            pairs.add(new Pair<OracleShardingKeyImpl, OracleShardingKeyImpl>(this.aSuperKeys[i], this.aSuperKeys[i]));
        }
        return pairs;
    }
}

