# -*- coding: binary -*-

#
# This mixin is a simplistic implementation of X11 initial connection protocol
#
# Wireshark dissector: https://wiki.wireshark.org/X11
#

module Msf::Exploit::Remote::X11::Extension
  include Msf::Exploit::Remote::X11::Read
  include Rex::Proto::X11::Extension

  # Query for an extension, converts the name of the extension to the ID #
  def x11_query_extension(extension_name, call_count)
    sock.put(X11QueryExtensionRequest.new(extension: extension_name, unused2: call_count).to_binary_s)
    x11_read_response(X11QueryExtensionResponse)
  end

  # toggles an extension on or off (enable/disable)
  def x11_toggle_extension(extension_id, wanted_major: 0, toggle: true)
    sock.put(
      X11ExtensionToggleRequest.new(
        opcode: extension_id,
        toggle: (toggle ? 0 : 1), # 0 is enable, 1 is disable
        wanted_major: wanted_major
      ).to_binary_s
    )
    x11_read_response(X11ExtensionToggleResponse)
  end
end
