/*
 * Decompiled with CFR 0.152.
 */
package mediathek.tool.ttml.exporters;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import mediathek.tool.ttml.ITtmlExporter;
import mediathek.tool.ttml.StyledString;
import mediathek.tool.ttml.Subtitle;
import mediathek.tool.ttml.TimedTextMarkupLanguageParser;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class AdvancedSubstationAlphaExporter
implements ITtmlExporter {
    private static final Logger logger = LogManager.getLogger();
    private final SimpleDateFormat assFormat = new SimpleDateFormat("HH:mm:ss.SSS");

    private String getAssTime(Date time) {
        String assTime = this.assFormat.format(time);
        return assTime.substring(0, assTime.length() - 1);
    }

    private String colorToBGR(Color color) {
        return String.format("%02X%02X%02X", color.getBlue(), color.getGreen(), color.getRed());
    }

    private Color hexToColor(@NotNull String hex) {
        if ((hex = hex.replace("#", "")).length() == 6) {
            return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16));
        }
        if (hex.length() == 8) {
            return new Color(Integer.valueOf(hex.substring(0, 2), 16), Integer.valueOf(hex.substring(2, 4), 16), Integer.valueOf(hex.substring(4, 6), 16), Integer.valueOf(hex.substring(6, 8), 16));
        }
        logger.error("Failed to convert hex color string: {}", (Object)hex);
        return Color.WHITE;
    }

    @Override
    public void write(TimedTextMarkupLanguageParser parser, Path assFile) {
        try (FileOutputStream fos = new FileOutputStream(assFile.toFile());
             OutputStreamWriter osw = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);
             PrintWriter writer = new PrintWriter(osw);){
            writer.print("[Script Info]\n; Script generated by MediathekView\nScriptType: v4.00+\nScaledBorderAndShadow: yes\nYCbCr Matrix: None\n\n[V4+ Styles]\nFormat: Name, Fontname, Fontsize, PrimaryColour, SecondaryColour, OutlineColour, BackColour, Bold, Italic, Underline, StrikeOut, ScaleX, ScaleY, Spacing, Angle, BorderStyle, Outline, Shadow, Alignment, MarginL, MarginR, MarginV, Encoding\nStyle: Default,,22,,,,,0,0,0,0,100,100,0,0,3,1,0,2,10,10,25,1\n\n[Events]\nFormat: Layer, Start, End, Style, Name, MarginL, MarginR, MarginV, Effect, Text\n");
            for (Subtitle title : parser.getSubtitleList()) {
                String titleRegion = title.getRegion();
                String titleBegin = this.getAssTime(title.getBegin());
                String titleEnd = this.getAssTime(title.getEnd());
                String titleText = "Dialogue: 0," + titleBegin + "," + titleEnd + ",Default,,0,0,0,,";
                if (titleRegion != null) {
                    titleText = titleText + "{\\an" + titleRegion + "}";
                }
                StringBuilder entryText = new StringBuilder();
                for (StyledString entry : title.getListOfStrings()) {
                    String entryBackgroundColorString;
                    if (!entryText.isEmpty()) {
                        entryText.append("\\N");
                    }
                    entryText.append("{");
                    String entryColorString = entry.getColor();
                    if (!entryColorString.isEmpty()) {
                        entryText.append("\\1c&H").append(this.colorToBGR(this.hexToColor(entryColorString))).append("&");
                    }
                    if (!(entryBackgroundColorString = entry.getBackgroundColor()).isEmpty()) {
                        Color entryBackgroundColor = this.hexToColor(entryBackgroundColorString);
                        entryText.append("\\3c&H").append(this.colorToBGR(entryBackgroundColor)).append("&");
                        entryText.append("\\3a&H").append(String.format("%02X", 255 - entryBackgroundColor.getAlpha())).append("&");
                    }
                    entryText.append("}");
                    entryText.append(entry.getText().replace("<br/>", "\\N"));
                }
                writer.println(titleText + String.valueOf(entryText));
            }
            logger.trace("Export to ASS was succesful.");
        }
        catch (Exception ex) {
            logger.error("File: {}", (Object)assFile, (Object)ex);
        }
    }
}

