/*
 * Decompiled with CFR 0.152.
 */
package mediathek.mainwindow;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.time.Duration;
import java.util.IllegalFormatException;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.Timer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import mediathek.config.Daten;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010\u0007\u001a\u00020\u0006H\u0002J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0006H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0002J\u0010\u0010\r\u001a\u00020\f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lmediathek/mainwindow/FilmAgeLabel;", "Ljavax/swing/JLabel;", "Ljava/awt/event/ActionListener;", "<init>", "()V", "oldAge", "Lmediathek/mainwindow/FilmAgeLabel$FilmListAge;", "calculateFilmListAge", "computeAgeString", "", "age", "setAgeToLabel", "", "actionPerformed", "e", "Ljava/awt/event/ActionEvent;", "FilmListAge", "MediathekView"})
public final class FilmAgeLabel
extends JLabel
implements ActionListener {
    @NotNull
    private FilmListAge oldAge = new FilmListAge(0L, 0L);

    public FilmAgeLabel() {
        this.setToolTipText("Alter der Filmliste");
        this.setAgeToLabel();
        Timer timer = new Timer(1000, this);
        timer.setRepeats(true);
        timer.start();
    }

    private final FilmListAge calculateFilmListAge() {
        Duration duration = Duration.ofSeconds(Daten.getInstance().getListeFilme().getMetaData().getAgeInSeconds());
        long minutes = duration.toMinutes();
        long hours = minutes / (long)60;
        return new FilmListAge(hours, minutes -= hours * (long)60);
    }

    private final String computeAgeString(FilmListAge age) throws IllegalFormatException {
        Object object;
        if (age.getHours() == 0L) {
            object = "Alter: " + age.getMinutes() + "m";
        } else if (age.getHours() >= 24L) {
            long duration = TimeUnit.MILLISECONDS.convert(age.getHours() * (long)60 + age.getMinutes(), TimeUnit.MINUTES);
            String string = DurationFormatUtils.formatDuration((long)duration, (String)"'Alter: 'dd'd' HH'h' mm'm'", (boolean)true);
            Intrinsics.checkNotNull((Object)string);
            object = string;
        } else {
            object = "Alter: " + age.getHours() + "h " + age.getMinutes() + "m";
        }
        return object;
    }

    private final void setAgeToLabel() {
        FilmListAge curAge = this.calculateFilmListAge();
        if (!Intrinsics.areEqual((Object)curAge, (Object)this.oldAge)) {
            String result2 = this.computeAgeString(curAge);
            this.setText(result2);
            this.oldAge = curAge;
        }
    }

    @Override
    public void actionPerformed(@NotNull ActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        this.setAgeToLabel();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0011H\u00d6\u0001J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\b\u00a8\u0006\u0014"}, d2={"Lmediathek/mainwindow/FilmAgeLabel$FilmListAge;", "", "hours", "", "minutes", "<init>", "(JJ)V", "getHours", "()J", "getMinutes", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "", "MediathekView"})
    private static final class FilmListAge {
        private final long hours;
        private final long minutes;

        public FilmListAge(long hours, long minutes) {
            this.hours = hours;
            this.minutes = minutes;
        }

        public final long getHours() {
            return this.hours;
        }

        public final long getMinutes() {
            return this.minutes;
        }

        public final long component1() {
            return this.hours;
        }

        public final long component2() {
            return this.minutes;
        }

        @NotNull
        public final FilmListAge copy(long hours, long minutes) {
            return new FilmListAge(hours, minutes);
        }

        public static /* synthetic */ FilmListAge copy$default(FilmListAge filmListAge, long l, long l2, int n, Object object) {
            if ((n & 1) != 0) {
                l = filmListAge.hours;
            }
            if ((n & 2) != 0) {
                l2 = filmListAge.minutes;
            }
            return filmListAge.copy(l, l2);
        }

        @NotNull
        public String toString() {
            return "FilmListAge(hours=" + this.hours + ", minutes=" + this.minutes + ")";
        }

        public int hashCode() {
            int result2 = Long.hashCode(this.hours);
            result2 = result2 * 31 + Long.hashCode(this.minutes);
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof FilmListAge)) {
                return false;
            }
            FilmListAge filmListAge = (FilmListAge)other;
            if (this.hours != filmListAge.hours) {
                return false;
            }
            return this.minutes == filmListAge.minutes;
        }
    }
}

