/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.actions;

import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import mediathek.config.Daten;
import mediathek.gui.bookmark.BookmarkDataList;
import mediathek.mainwindow.MediathekGui;
import mediathek.swing.IconUtils;
import org.kordamp.ikonli.Ikon;
import org.kordamp.ikonli.materialdesign2.MaterialDesignF;

public class DeleteBookmarksAction
extends AbstractAction {
    private final MediathekGui owner;

    public DeleteBookmarksAction(MediathekGui parent) {
        this.owner = parent;
        this.putValue("ShortDescription", "Merkliste vollst\u00e4ndig l\u00f6schen");
        this.putValue("Name", "Merkliste vollst\u00e4ndig l\u00f6schen...");
        this.putValue("SmallIcon", IconUtils.toolbarIcon((Ikon)MaterialDesignF.FILE_DOCUMENT_REMOVE));
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        int res;
        boolean restoreManageBookmarkWindow = false;
        JDialog bookmarkDialog = this.owner.tabFilme.bookmarkDialog;
        if (bookmarkDialog != null && bookmarkDialog.isVisible()) {
            restoreManageBookmarkWindow = true;
            bookmarkDialog.setVisible(false);
        }
        if ((res = JOptionPane.showConfirmDialog(this.owner, "M\u00f6chten Sie wirklich die Merkliste vollst\u00e4ndig l\u00f6schen?", "MediathekView", 0)) == 0) {
            BookmarkDataList bookmarkList = Daten.getInstance().getListeBookmarkList();
            bookmarkList.clear();
            bookmarkList.saveToFile();
            JOptionPane.showMessageDialog(this.owner, "Die Merkliste wurde gel\u00f6scht", "MediathekView", 1);
        }
        if (restoreManageBookmarkWindow) {
            bookmarkDialog.setVisible(true);
        }
    }
}

