/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.document;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.InvertableType;
import org.apache.lucene.document.StoredValue;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableFieldType;
import org.apache.lucene.util.BytesRef;

public final class StringField
extends Field {
    public static final FieldType TYPE_NOT_STORED = new FieldType();
    public static final FieldType TYPE_STORED = new FieldType();
    private BytesRef binaryValue;
    private final StoredValue storedValue;

    public StringField(String name, String value, Field.Store stored) {
        super(name, value, (IndexableFieldType)(stored == Field.Store.YES ? TYPE_STORED : TYPE_NOT_STORED));
        this.binaryValue = new BytesRef(value);
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    public StringField(String name, BytesRef value, Field.Store stored) {
        super(name, value, (IndexableFieldType)(stored == Field.Store.YES ? TYPE_STORED : TYPE_NOT_STORED));
        this.binaryValue = value;
        this.storedValue = stored == Field.Store.YES ? new StoredValue(value) : null;
    }

    @Override
    public InvertableType invertableType() {
        return InvertableType.BINARY;
    }

    @Override
    public BytesRef binaryValue() {
        return this.binaryValue;
    }

    @Override
    public void setStringValue(String value) {
        super.setStringValue(value);
        this.binaryValue = new BytesRef(value);
        if (this.storedValue != null) {
            this.storedValue.setStringValue(value);
        }
    }

    @Override
    public void setBytesValue(BytesRef value) {
        super.setBytesValue(value);
        this.binaryValue = value;
        if (this.storedValue != null) {
            this.storedValue.setBinaryValue(value);
        }
    }

    @Override
    public StoredValue storedValue() {
        return this.storedValue;
    }

    static {
        TYPE_NOT_STORED.setOmitNorms(true);
        TYPE_NOT_STORED.setIndexOptions(IndexOptions.DOCS);
        TYPE_NOT_STORED.setTokenized(false);
        TYPE_NOT_STORED.freeze();
        TYPE_STORED.setOmitNorms(true);
        TYPE_STORED.setIndexOptions(IndexOptions.DOCS);
        TYPE_STORED.setStored(true);
        TYPE_STORED.setTokenized(false);
        TYPE_STORED.freeze();
    }
}

